/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.http;

import com.collections.CollectionUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.dropwizard.revolver.RevolverBundle;
import io.dropwizard.revolver.core.RevolverCommand;
import io.dropwizard.revolver.core.config.ClientConfig;
import io.dropwizard.revolver.core.config.RuntimeConfig;
import io.dropwizard.revolver.core.tracing.TraceInfo;
import io.dropwizard.revolver.core.util.RevolverCommandHelper;
import io.dropwizard.revolver.discovery.EndpointSpec;
import io.dropwizard.revolver.discovery.model.Endpoint;
import io.dropwizard.revolver.exception.RevolverException;
import io.dropwizard.revolver.http.RevolverHttpClientFactory;
import io.dropwizard.revolver.http.RevolverHttpContext;
import io.dropwizard.revolver.http.config.RevolverHttpApiConfig;
import io.dropwizard.revolver.http.config.RevolverHttpServiceConfig;
import io.dropwizard.revolver.http.model.RevolverHttpRequest;
import io.dropwizard.revolver.http.model.RevolverHttpResponse;
import io.dropwizard.revolver.retry.RetryUtils;
import io.dropwizard.revolver.splitting.RevolverSplitServiceConfig;
import io.dropwizard.revolver.splitting.SplitConfig;
import io.dropwizard.revolver.splitting.SplitStrategy;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevolverHttpCommand
extends RevolverCommand<RevolverHttpRequest, RevolverHttpResponse, RevolverHttpContext, RevolverHttpServiceConfig, RevolverHttpApiConfig> {
    private static final Logger log = LoggerFactory.getLogger(RevolverHttpCommand.class);
    public static final String CALL_MODE_POLLING = "POLLING";
    public static final String CALL_MODE_CALLBACK = "CALLBACK";
    public static final String CALL_MODE_CALLBACK_SYNC = "CALLBACK_SYNC";
    private final OkHttpClient client;

    public RevolverHttpCommand(RuntimeConfig runtimeConfig, ClientConfig clientConfiguration, RevolverHttpServiceConfig serviceConfiguration, RevolverHttpApiConfig apiConfiguration, RevolverHttpContext revolverContext) {
        super(revolverContext, clientConfiguration, runtimeConfig, serviceConfiguration, apiConfiguration);
        this.client = RevolverHttpClientFactory.buildClient(serviceConfiguration);
    }

    @Override
    public boolean isFallbackEnabled() {
        return false;
    }

    @Override
    public RevolverHttpResponse execute(RevolverHttpContext context, RevolverHttpRequest request) throws Exception {
        Preconditions.checkNotNull((Object)this.client);
        RevolverHttpApiConfig apiConfig = (RevolverHttpApiConfig)this.getApiConfiguration();
        if (apiConfig.getMethods().contains((Object)request.getMethod())) {
            switch (request.getMethod()) {
                case GET: {
                    return this.doGet(request);
                }
                case POST: {
                    return this.doPost(request);
                }
                case PUT: {
                    return this.doPut(request);
                }
                case DELETE: {
                    return this.doDelete(request);
                }
                case HEAD: {
                    return this.doHead(request);
                }
                case OPTIONS: {
                    return this.doOptions(request);
                }
                case PATCH: {
                    return this.doPatch(request);
                }
            }
        }
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.putSingle((Object)"X-REQUEST-PATH", (Object)request.getPath());
        headers.putSingle((Object)"X-REQUEST-METHOD", (Object)request.getMethod().name());
        headers.putSingle((Object)"X-REQUEST-API", (Object)((RevolverHttpApiConfig)this.getApiConfiguration()).getApi());
        return RevolverHttpResponse.builder().headers((MultivaluedMap<String, String>)headers).statusCode(Response.Status.BAD_REQUEST.getStatusCode()).build();
    }

    @Override
    protected RevolverHttpResponse fallback(RevolverHttpContext context, RevolverHttpRequest requestType) {
        log.error("Fallback triggered for command: " + RevolverCommandHelper.getName(requestType));
        return null;
    }

    private HttpUrl getServiceUrl(RevolverHttpRequest request, RevolverHttpApiConfig apiConfiguration) throws RevolverException {
        Endpoint endpoint;
        EndpointSpec endpointSpec = this.generateEndPoint(apiConfiguration);
        if (endpointSpec == null) {
            endpointSpec = ((RevolverHttpServiceConfig)this.getServiceConfiguration()).getEndpoint();
        }
        if ((endpoint = RevolverBundle.serviceNameResolver.resolve(endpointSpec)) == null) {
            if (Strings.isNullOrEmpty((String)((RevolverHttpServiceConfig)this.getServiceConfiguration()).getFallbackAddress())) {
                throw new RevolverException(503, "R999", "Service [" + request.getPath() + "] Unavailable");
            }
            String[] address = ((RevolverHttpServiceConfig)this.getServiceConfiguration()).getFallbackAddress().split(":");
            endpoint = address.length == 1 ? Endpoint.builder().host(address[0]).port(80).build() : Endpoint.builder().host(address[0]).port(Integer.parseInt(address[1])).build();
        }
        return this.generateURI(request, apiConfiguration, endpoint);
    }

    private EndpointSpec generateEndPoint(RevolverHttpApiConfig apiConfiguration) {
        if (null != apiConfiguration.getSplitConfig() && apiConfiguration.getSplitConfig().isEnabled()) {
            return this.getFromSplitConfig(apiConfiguration);
        }
        return ((RevolverHttpServiceConfig)this.getServiceConfiguration()).getEndpoint();
    }

    private EndpointSpec getFromSplitConfig(RevolverHttpApiConfig apiConfiguration) {
        String serviceEndPoint = this.getSplitService(apiConfiguration);
        RevolverHttpServiceConfig serviceConfig = (RevolverHttpServiceConfig)this.getServiceConfiguration();
        if (serviceConfig == null || null == serviceConfig.getServiceSplitConfig() || apiConfiguration.getSplitConfig().getSplitStrategy() != SplitStrategy.SERVICE || StringUtils.isEmpty((CharSequence)serviceEndPoint)) {
            return null;
        }
        for (RevolverSplitServiceConfig splitServiceConfig : serviceConfig.getServiceSplitConfig().getConfigs()) {
            if (!splitServiceConfig.getName().equals(serviceEndPoint)) continue;
            return splitServiceConfig.getEndpoint();
        }
        return null;
    }

    private RevolverHttpResponse executeRequest(RevolverHttpApiConfig apiConfiguration, Request request, boolean readBody, RevolverHttpRequest originalRequest) throws Exception {
        try (Response response = null;){
            long start = System.currentTimeMillis();
            response = null != apiConfiguration.getRetryConfig() && apiConfiguration.getRetryConfig().isEnabled() ? (Response)RetryUtils.getRetryer(apiConfiguration).call(() -> {
                HttpUrl url = this.getServiceUrl(originalRequest, (RevolverHttpApiConfig)this.getApiConfiguration());
                return this.client.newCall(request.newBuilder().url(url).build()).execute();
            }) : this.client.newCall(request).execute();
            long end = System.currentTimeMillis();
            RevolverHttpResponse httpResponse = this.getHttpResponse(apiConfiguration, response, readBody);
            log.info("[{}/{}] {} {}:{}{} {} {}ms", new Object[]{apiConfiguration.getApi(), apiConfiguration.getPath(), request.method(), request.url().host(), request.url().port(), request.url().encodedPath(), httpResponse.getStatusCode(), end - start});
            RevolverHttpResponse revolverHttpResponse = httpResponse;
            return revolverHttpResponse;
        }
    }

    private RevolverHttpResponse doGet(RevolverHttpRequest request) throws Exception {
        Request.Builder httpRequest = this.initializeRequest(request);
        httpRequest.get();
        return this.executeRequest((RevolverHttpApiConfig)this.getApiConfiguration(), httpRequest.build(), true, request);
    }

    private Request.Builder initializeRequest(RevolverHttpRequest request) throws RevolverException {
        HttpUrl url = this.getServiceUrl(request, (RevolverHttpApiConfig)this.getApiConfiguration());
        Request.Builder httpRequest = new Request.Builder().url(url);
        this.addHeaders(request, httpRequest);
        this.trackingHeaders(request, httpRequest);
        return httpRequest;
    }

    private RevolverHttpResponse doOptions(RevolverHttpRequest request) throws Exception {
        Request.Builder httpRequest = this.initializeRequest(request);
        httpRequest.method("OPTIONS", null);
        return this.executeRequest((RevolverHttpApiConfig)this.getApiConfiguration(), httpRequest.build(), true, request);
    }

    private RevolverHttpResponse doHead(RevolverHttpRequest request) throws Exception {
        Request.Builder httpRequest = this.initializeRequest(request);
        httpRequest.head();
        return this.executeRequest((RevolverHttpApiConfig)this.getApiConfiguration(), httpRequest.build(), false, request);
    }

    private RevolverHttpResponse doDelete(RevolverHttpRequest request) throws Exception {
        Request.Builder httpRequest = this.initializeRequest(request);
        httpRequest.delete();
        return this.executeRequest((RevolverHttpApiConfig)this.getApiConfiguration(), httpRequest.build(), true, request);
    }

    private RevolverHttpResponse doPatch(RevolverHttpRequest request) throws Exception {
        Request.Builder httpRequest = this.initializeRequest(request);
        if (request.getBody() != null) {
            if (null != request.getHeaders() && StringUtils.isNotBlank((CharSequence)((CharSequence)request.getHeaders().getFirst((Object)"Content-Type")))) {
                httpRequest.patch(RequestBody.create((MediaType)MediaType.parse((String)((String)request.getHeaders().getFirst((Object)"Content-Type"))), (byte[])request.getBody()));
            } else {
                httpRequest.patch(RequestBody.create((MediaType)MediaType.parse((String)"*/*"), (byte[])request.getBody()));
            }
        } else {
            httpRequest.patch(RequestBody.create((MediaType)MediaType.parse((String)"*/*"), (byte[])new byte[0]));
        }
        return this.executeRequest((RevolverHttpApiConfig)this.getApiConfiguration(), httpRequest.build(), true, request);
    }

    private RevolverHttpResponse doPost(RevolverHttpRequest request) throws Exception {
        Request.Builder httpRequest = this.initializeRequest(request);
        if (request.getBody() != null) {
            if (null != request.getHeaders() && StringUtils.isNotBlank((CharSequence)((CharSequence)request.getHeaders().getFirst((Object)"Content-Type")))) {
                httpRequest.post(RequestBody.create((MediaType)MediaType.parse((String)((String)request.getHeaders().getFirst((Object)"Content-Type"))), (byte[])request.getBody()));
            } else {
                httpRequest.post(RequestBody.create((MediaType)MediaType.parse((String)"*/*"), (byte[])request.getBody()));
            }
        } else {
            httpRequest.post(RequestBody.create((MediaType)MediaType.parse((String)"*/*"), (byte[])new byte[0]));
        }
        return this.executeRequest((RevolverHttpApiConfig)this.getApiConfiguration(), httpRequest.build(), true, request);
    }

    private RevolverHttpResponse doPut(RevolverHttpRequest request) throws Exception {
        Request.Builder httpRequest = this.initializeRequest(request);
        if (request.getBody() != null) {
            if (null != request.getHeaders() && StringUtils.isNotBlank((CharSequence)((CharSequence)request.getHeaders().getFirst((Object)"Content-Type")))) {
                httpRequest.put(RequestBody.create((MediaType)MediaType.parse((String)((String)request.getHeaders().getFirst((Object)"Content-Type"))), (byte[])request.getBody()));
            } else {
                httpRequest.put(RequestBody.create((MediaType)MediaType.parse((String)"*/*"), (byte[])request.getBody()));
            }
        } else {
            httpRequest.put(RequestBody.create((MediaType)MediaType.parse((String)"*/*"), (byte[])new byte[0]));
        }
        return this.executeRequest((RevolverHttpApiConfig)this.getApiConfiguration(), httpRequest.build(), true, request);
    }

    private HttpUrl generateURI(RevolverHttpRequest request, RevolverHttpApiConfig apiConfiguration, Endpoint endpoint) {
        HttpUrl.Builder builder = new HttpUrl.Builder();
        this.addQueryParams(request, builder);
        if (((RevolverHttpServiceConfig)this.getServiceConfiguration()).isSecured()) {
            builder.scheme("https");
        } else {
            builder.scheme("http");
        }
        builder.host(endpoint.getHost()).port(endpoint.getPort()).encodedPath(this.resolvePath(apiConfiguration, request));
        return builder.build();
    }

    private RevolverHttpResponse getHttpResponse(RevolverHttpApiConfig apiConfiguration, Response response, boolean readBody) throws Exception {
        if (apiConfiguration.getAcceptableResponseCodes() != null && !apiConfiguration.getAcceptableResponseCodes().isEmpty() && !apiConfiguration.getAcceptableResponseCodes().contains(response.code())) {
            if (response.body() != null) {
                log.error("Response: " + response.body().string());
            }
            throw new Exception(String.format("HTTP %s %s failed with [%d - %s]", apiConfiguration.getMethods(), apiConfiguration.getApi(), response.code(), response.message()));
        }
        MultivaluedHashMap headers = new MultivaluedHashMap();
        response.headers().names().forEach(h -> headers.putSingle(h, (Object)response.header(h)));
        RevolverHttpResponse.RevolverHttpResponseBuilder revolverResponse = RevolverHttpResponse.builder().statusCode(response.code()).headers((MultivaluedMap<String, String>)headers);
        if (readBody && response.body() != null) {
            revolverResponse.body(response.body().bytes());
        }
        return revolverResponse.build();
    }

    private String resolvePath(RevolverHttpApiConfig httpApiConfiguration, RevolverHttpRequest request) {
        String uri = null;
        if (Strings.isNullOrEmpty((String)request.getPath())) {
            if (null != request.getPathParams()) {
                uri = StringSubstitutor.replace((Object)httpApiConfiguration.getPath(), request.getPathParams());
            }
        } else {
            uri = request.getPath();
        }
        if (Strings.isNullOrEmpty((String)uri)) {
            uri = httpApiConfiguration.getPath();
        }
        return uri.charAt(0) == '/' ? uri : "/" + uri;
    }

    private String getSplitService(RevolverHttpApiConfig httpApiConfiguration) {
        double random = Math.random();
        for (SplitConfig splitConfig : CollectionUtils.nullSafeList(httpApiConfiguration.getSplitConfig().getSplits())) {
            if (!(splitConfig.getFrom() <= random) || !(splitConfig.getTo() > random)) continue;
            return splitConfig.getService();
        }
        return "";
    }

    private String getUri(RevolverHttpApiConfig httpApiConfiguration, RevolverHttpRequest request) {
        String uri = "";
        if (Strings.isNullOrEmpty((String)request.getPath())) {
            if (null != request.getPathParams()) {
                uri = StringSubstitutor.replace((Object)httpApiConfiguration.getPath(), request.getPathParams());
            }
        } else {
            uri = request.getPath();
        }
        return uri;
    }

    private void addQueryParams(RevolverHttpRequest request, HttpUrl.Builder builder) {
        if (null != request.getQueryParams()) {
            request.getQueryParams().forEach((key, values) -> values.forEach(value -> builder.addQueryParameter(key, value)));
        }
    }

    private void trackingHeaders(RevolverHttpRequest request, Request.Builder requestBuilder) {
        List existing;
        if (!((RevolverHttpServiceConfig)this.getServiceConfiguration()).isTrackingHeaders()) {
            return;
        }
        TraceInfo spanInfo = request.getTrace();
        if (request.getHeaders() == null) {
            request.setHeaders((MultivaluedMap<String, String>)new MultivaluedHashMap());
        }
        if (!(existing = request.getHeaders().keySet().stream().map(String::toLowerCase).collect(Collectors.toList())).contains("X-TRANSACTION-ID".toLowerCase())) {
            requestBuilder.addHeader("X-TRANSACTION-ID", spanInfo.getTransactionId());
        }
        if (!existing.contains("X-REQUEST-ID".toLowerCase())) {
            requestBuilder.addHeader("X-REQUEST-ID", spanInfo.getRequestId());
        }
        if (!existing.contains("X-PARENT-REQUEST-ID".toLowerCase())) {
            requestBuilder.addHeader("X-PARENT-REQUEST-ID", spanInfo.getParentRequestId());
        }
        if (!existing.contains("X-REQUEST-TIMESTAMP".toLowerCase())) {
            requestBuilder.addHeader("X-REQUEST-TIMESTAMP", Long.toString(spanInfo.getTimestamp()));
        }
        if (!existing.contains("X-CLIENT-ID".toLowerCase())) {
            requestBuilder.addHeader("X-CLIENT-ID", this.getClientConfiguration().getClientName());
        }
    }

    private void addHeaders(RevolverHttpRequest request, Request.Builder requestBuilder) {
        if (null != request.getHeaders()) {
            request.getHeaders().forEach((key, values) -> values.forEach(value -> requestBuilder.addHeader(key, value)));
        }
    }

    public static RevolverHttpCommandBuilder builder() {
        return new RevolverHttpCommandBuilder();
    }

    public static class RevolverHttpCommandBuilder {
        private RuntimeConfig runtimeConfig;
        private ClientConfig clientConfiguration;
        private RevolverHttpServiceConfig serviceConfiguration;
        private RevolverHttpApiConfig apiConfiguration;
        private RevolverHttpContext revolverContext;

        RevolverHttpCommandBuilder() {
        }

        public RevolverHttpCommandBuilder runtimeConfig(RuntimeConfig runtimeConfig) {
            this.runtimeConfig = runtimeConfig;
            return this;
        }

        public RevolverHttpCommandBuilder clientConfiguration(ClientConfig clientConfiguration) {
            this.clientConfiguration = clientConfiguration;
            return this;
        }

        public RevolverHttpCommandBuilder serviceConfiguration(RevolverHttpServiceConfig serviceConfiguration) {
            this.serviceConfiguration = serviceConfiguration;
            return this;
        }

        public RevolverHttpCommandBuilder apiConfiguration(RevolverHttpApiConfig apiConfiguration) {
            this.apiConfiguration = apiConfiguration;
            return this;
        }

        public RevolverHttpCommandBuilder revolverContext(RevolverHttpContext revolverContext) {
            this.revolverContext = revolverContext;
            return this;
        }

        public RevolverHttpCommand build() {
            return new RevolverHttpCommand(this.runtimeConfig, this.clientConfiguration, this.serviceConfiguration, this.apiConfiguration, this.revolverContext);
        }

        public String toString() {
            return "RevolverHttpCommand.RevolverHttpCommandBuilder(runtimeConfig=" + this.runtimeConfig + ", clientConfiguration=" + this.clientConfiguration + ", serviceConfiguration=" + this.serviceConfiguration + ", apiConfiguration=" + this.apiConfiguration + ", revolverContext=" + this.revolverContext + ")";
        }
    }
}

