package io.dropwizard.revolver.resource;

import org.glassfish.jersey.server.model.ModelProcessor;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceModel;

import javax.ws.rs.core.Configuration;
import javax.ws.rs.ext.Provider;
import java.util.Set;

@Provider
public class DisabledMethodsProcessor implements ModelProcessor {
    private final Set<String> disabledMethods;

    public DisabledMethodsProcessor(final Set<String> disabledMethods) {
        this.disabledMethods = disabledMethods;
    }

    @Override
    public ResourceModel processResourceModel(final ResourceModel resourceModel, final Configuration configuration) {
        ResourceModel.Builder newResourceModelBuilder = new ResourceModel.Builder(false);

        for (final Resource resource: resourceModel.getResources()) {
            final Resource.Builder resourceBuilder = Resource.builder(resource.getPath());
            for (final Resource childResource: resource.getChildResources()) {
                final String fullPath = childResource.getParent().getPath() + childResource.getPath();
                if (disabledMethods != null && disabledMethods.contains(fullPath)) {
                    continue;
                }
                resourceBuilder.addChildResource(childResource);
            }
            newResourceModelBuilder.addResource(resourceBuilder.build());
        }

        return newResourceModelBuilder.build();
    }

    @Override
    public ResourceModel processSubResource(final ResourceModel subResourceModel, final Configuration configuration) {
        return subResourceModel;
    }
}
