// Compiled by ClojureScript 1.9.293 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('goog.Uri');
goog.require('goog.net.jsloader');
goog.require('cljs.core.async');
goog.require('goog.object');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__26696__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__26696__auto__){
return or__26696__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.fix_node_request_url = (function figwheel$client$file_reloading$fix_node_request_url(url){

if(cljs.core.truth_(goog.string.startsWith(url,"../"))){
return clojure.string.replace.call(null,url,"../","");
} else {
return [cljs.core.str("goog/"),cljs.core.str(url)].join('');
}
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__26696__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, ["svgpan.SvgPan",null,"far.out",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__26696__auto__)){
return or__26696__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__36783_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__36783_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([name], true));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([parent_ns], true));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__36788 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__36789 = null;
var count__36790 = (0);
var i__36791 = (0);
while(true){
if((i__36791 < count__36790)){
var n = cljs.core._nth.call(null,chunk__36789,i__36791);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__36792 = seq__36788;
var G__36793 = chunk__36789;
var G__36794 = count__36790;
var G__36795 = (i__36791 + (1));
seq__36788 = G__36792;
chunk__36789 = G__36793;
count__36790 = G__36794;
i__36791 = G__36795;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__36788);
if(temp__6753__auto__){
var seq__36788__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__36788__$1)){
var c__27602__auto__ = cljs.core.chunk_first.call(null,seq__36788__$1);
var G__36796 = cljs.core.chunk_rest.call(null,seq__36788__$1);
var G__36797 = c__27602__auto__;
var G__36798 = cljs.core.count.call(null,c__27602__auto__);
var G__36799 = (0);
seq__36788 = G__36796;
chunk__36789 = G__36797;
count__36790 = G__36798;
i__36791 = G__36799;
continue;
} else {
var n = cljs.core.first.call(null,seq__36788__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__36800 = cljs.core.next.call(null,seq__36788__$1);
var G__36801 = null;
var G__36802 = (0);
var G__36803 = (0);
seq__36788 = G__36800;
chunk__36789 = G__36801;
count__36790 = G__36802;
i__36791 = G__36803;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__36854_36865 = cljs.core.seq.call(null,deps);
var chunk__36855_36866 = null;
var count__36856_36867 = (0);
var i__36857_36868 = (0);
while(true){
if((i__36857_36868 < count__36856_36867)){
var dep_36869 = cljs.core._nth.call(null,chunk__36855_36866,i__36857_36868);
topo_sort_helper_STAR_.call(null,dep_36869,(depth + (1)),state);

var G__36870 = seq__36854_36865;
var G__36871 = chunk__36855_36866;
var G__36872 = count__36856_36867;
var G__36873 = (i__36857_36868 + (1));
seq__36854_36865 = G__36870;
chunk__36855_36866 = G__36871;
count__36856_36867 = G__36872;
i__36857_36868 = G__36873;
continue;
} else {
var temp__6753__auto___36874 = cljs.core.seq.call(null,seq__36854_36865);
if(temp__6753__auto___36874){
var seq__36854_36875__$1 = temp__6753__auto___36874;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__36854_36875__$1)){
var c__27602__auto___36876 = cljs.core.chunk_first.call(null,seq__36854_36875__$1);
var G__36877 = cljs.core.chunk_rest.call(null,seq__36854_36875__$1);
var G__36878 = c__27602__auto___36876;
var G__36879 = cljs.core.count.call(null,c__27602__auto___36876);
var G__36880 = (0);
seq__36854_36865 = G__36877;
chunk__36855_36866 = G__36878;
count__36856_36867 = G__36879;
i__36857_36868 = G__36880;
continue;
} else {
var dep_36881 = cljs.core.first.call(null,seq__36854_36875__$1);
topo_sort_helper_STAR_.call(null,dep_36881,(depth + (1)),state);

var G__36882 = cljs.core.next.call(null,seq__36854_36875__$1);
var G__36883 = null;
var G__36884 = (0);
var G__36885 = (0);
seq__36854_36865 = G__36882;
chunk__36855_36866 = G__36883;
count__36856_36867 = G__36884;
i__36857_36868 = G__36885;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__36858){
var vec__36862 = p__36858;
var seq__36863 = cljs.core.seq.call(null,vec__36862);
var first__36864 = cljs.core.first.call(null,seq__36863);
var seq__36863__$1 = cljs.core.next.call(null,seq__36863);
var x = first__36864;
var xs = seq__36863__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__36862,seq__36863,first__36864,seq__36863__$1,x,xs,get_deps__$1){
return (function (p1__36804_SHARP_){
return clojure.set.difference.call(null,p1__36804_SHARP_,x);
});})(vec__36862,seq__36863,first__36864,seq__36863__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str(goog.basePath),cljs.core.str(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str(goog.basePath),cljs.core.str(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__36898 = cljs.core.seq.call(null,provides);
var chunk__36899 = null;
var count__36900 = (0);
var i__36901 = (0);
while(true){
if((i__36901 < count__36900)){
var prov = cljs.core._nth.call(null,chunk__36899,i__36901);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__36902_36910 = cljs.core.seq.call(null,requires);
var chunk__36903_36911 = null;
var count__36904_36912 = (0);
var i__36905_36913 = (0);
while(true){
if((i__36905_36913 < count__36904_36912)){
var req_36914 = cljs.core._nth.call(null,chunk__36903_36911,i__36905_36913);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_36914,prov);

var G__36915 = seq__36902_36910;
var G__36916 = chunk__36903_36911;
var G__36917 = count__36904_36912;
var G__36918 = (i__36905_36913 + (1));
seq__36902_36910 = G__36915;
chunk__36903_36911 = G__36916;
count__36904_36912 = G__36917;
i__36905_36913 = G__36918;
continue;
} else {
var temp__6753__auto___36919 = cljs.core.seq.call(null,seq__36902_36910);
if(temp__6753__auto___36919){
var seq__36902_36920__$1 = temp__6753__auto___36919;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__36902_36920__$1)){
var c__27602__auto___36921 = cljs.core.chunk_first.call(null,seq__36902_36920__$1);
var G__36922 = cljs.core.chunk_rest.call(null,seq__36902_36920__$1);
var G__36923 = c__27602__auto___36921;
var G__36924 = cljs.core.count.call(null,c__27602__auto___36921);
var G__36925 = (0);
seq__36902_36910 = G__36922;
chunk__36903_36911 = G__36923;
count__36904_36912 = G__36924;
i__36905_36913 = G__36925;
continue;
} else {
var req_36926 = cljs.core.first.call(null,seq__36902_36920__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_36926,prov);

var G__36927 = cljs.core.next.call(null,seq__36902_36920__$1);
var G__36928 = null;
var G__36929 = (0);
var G__36930 = (0);
seq__36902_36910 = G__36927;
chunk__36903_36911 = G__36928;
count__36904_36912 = G__36929;
i__36905_36913 = G__36930;
continue;
}
} else {
}
}
break;
}

var G__36931 = seq__36898;
var G__36932 = chunk__36899;
var G__36933 = count__36900;
var G__36934 = (i__36901 + (1));
seq__36898 = G__36931;
chunk__36899 = G__36932;
count__36900 = G__36933;
i__36901 = G__36934;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__36898);
if(temp__6753__auto__){
var seq__36898__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__36898__$1)){
var c__27602__auto__ = cljs.core.chunk_first.call(null,seq__36898__$1);
var G__36935 = cljs.core.chunk_rest.call(null,seq__36898__$1);
var G__36936 = c__27602__auto__;
var G__36937 = cljs.core.count.call(null,c__27602__auto__);
var G__36938 = (0);
seq__36898 = G__36935;
chunk__36899 = G__36936;
count__36900 = G__36937;
i__36901 = G__36938;
continue;
} else {
var prov = cljs.core.first.call(null,seq__36898__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__36906_36939 = cljs.core.seq.call(null,requires);
var chunk__36907_36940 = null;
var count__36908_36941 = (0);
var i__36909_36942 = (0);
while(true){
if((i__36909_36942 < count__36908_36941)){
var req_36943 = cljs.core._nth.call(null,chunk__36907_36940,i__36909_36942);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_36943,prov);

var G__36944 = seq__36906_36939;
var G__36945 = chunk__36907_36940;
var G__36946 = count__36908_36941;
var G__36947 = (i__36909_36942 + (1));
seq__36906_36939 = G__36944;
chunk__36907_36940 = G__36945;
count__36908_36941 = G__36946;
i__36909_36942 = G__36947;
continue;
} else {
var temp__6753__auto___36948__$1 = cljs.core.seq.call(null,seq__36906_36939);
if(temp__6753__auto___36948__$1){
var seq__36906_36949__$1 = temp__6753__auto___36948__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__36906_36949__$1)){
var c__27602__auto___36950 = cljs.core.chunk_first.call(null,seq__36906_36949__$1);
var G__36951 = cljs.core.chunk_rest.call(null,seq__36906_36949__$1);
var G__36952 = c__27602__auto___36950;
var G__36953 = cljs.core.count.call(null,c__27602__auto___36950);
var G__36954 = (0);
seq__36906_36939 = G__36951;
chunk__36907_36940 = G__36952;
count__36908_36941 = G__36953;
i__36909_36942 = G__36954;
continue;
} else {
var req_36955 = cljs.core.first.call(null,seq__36906_36949__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_36955,prov);

var G__36956 = cljs.core.next.call(null,seq__36906_36949__$1);
var G__36957 = null;
var G__36958 = (0);
var G__36959 = (0);
seq__36906_36939 = G__36956;
chunk__36907_36940 = G__36957;
count__36908_36941 = G__36958;
i__36909_36942 = G__36959;
continue;
}
} else {
}
}
break;
}

var G__36960 = cljs.core.next.call(null,seq__36898__$1);
var G__36961 = null;
var G__36962 = (0);
var G__36963 = (0);
seq__36898 = G__36960;
chunk__36899 = G__36961;
count__36900 = G__36962;
i__36901 = G__36963;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__36968_36972 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__36969_36973 = null;
var count__36970_36974 = (0);
var i__36971_36975 = (0);
while(true){
if((i__36971_36975 < count__36970_36974)){
var ns_36976 = cljs.core._nth.call(null,chunk__36969_36973,i__36971_36975);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_36976);

var G__36977 = seq__36968_36972;
var G__36978 = chunk__36969_36973;
var G__36979 = count__36970_36974;
var G__36980 = (i__36971_36975 + (1));
seq__36968_36972 = G__36977;
chunk__36969_36973 = G__36978;
count__36970_36974 = G__36979;
i__36971_36975 = G__36980;
continue;
} else {
var temp__6753__auto___36981 = cljs.core.seq.call(null,seq__36968_36972);
if(temp__6753__auto___36981){
var seq__36968_36982__$1 = temp__6753__auto___36981;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__36968_36982__$1)){
var c__27602__auto___36983 = cljs.core.chunk_first.call(null,seq__36968_36982__$1);
var G__36984 = cljs.core.chunk_rest.call(null,seq__36968_36982__$1);
var G__36985 = c__27602__auto___36983;
var G__36986 = cljs.core.count.call(null,c__27602__auto___36983);
var G__36987 = (0);
seq__36968_36972 = G__36984;
chunk__36969_36973 = G__36985;
count__36970_36974 = G__36986;
i__36971_36975 = G__36987;
continue;
} else {
var ns_36988 = cljs.core.first.call(null,seq__36968_36982__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_36988);

var G__36989 = cljs.core.next.call(null,seq__36968_36982__$1);
var G__36990 = null;
var G__36991 = (0);
var G__36992 = (0);
seq__36968_36972 = G__36989;
chunk__36969_36973 = G__36990;
count__36970_36974 = G__36991;
i__36971_36975 = G__36992;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__26696__auto__ = goog.require__;
if(cljs.core.truth_(or__26696__auto__)){
return or__26696__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__36993__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__36993 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__36994__i = 0, G__36994__a = new Array(arguments.length -  0);
while (G__36994__i < G__36994__a.length) {G__36994__a[G__36994__i] = arguments[G__36994__i + 0]; ++G__36994__i;}
  args = new cljs.core.IndexedSeq(G__36994__a,0);
} 
return G__36993__delegate.call(this,args);};
G__36993.cljs$lang$maxFixedArity = 0;
G__36993.cljs$lang$applyTo = (function (arglist__36995){
var args = cljs.core.seq(arglist__36995);
return G__36993__delegate(args);
});
G__36993.cljs$core$IFn$_invoke$arity$variadic = G__36993__delegate;
return G__36993;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__36997 = cljs.core._EQ_;
var expr__36998 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__36997.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__36998))){
var path_parts = ((function (pred__36997,expr__36998){
return (function (p1__36996_SHARP_){
return clojure.string.split.call(null,p1__36996_SHARP_,/[\/\\]/);
});})(pred__36997,expr__36998))
;
var sep = (cljs.core.truth_(cljs.core.re_matches.call(null,/win.*/,process.platform))?"\\":"/");
var root = clojure.string.join.call(null,sep,cljs.core.pop.call(null,cljs.core.pop.call(null,path_parts.call(null,__dirname))));
return ((function (path_parts,sep,root,pred__36997,expr__36998){
return (function (request_url,callback){

var cache_path = clojure.string.join.call(null,sep,cljs.core.cons.call(null,root,path_parts.call(null,figwheel.client.file_reloading.fix_node_request_url.call(null,request_url))));
(require.cache[cache_path] = null);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e37000){if((e37000 instanceof Error)){
var e = e37000;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e37000;

}
}})());
});
;})(path_parts,sep,root,pred__36997,expr__36998))
} else {
if(cljs.core.truth_(pred__36997.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__36998))){
return ((function (pred__36997,expr__36998){
return (function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
deferred.addCallback(((function (deferred,pred__36997,expr__36998){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred,pred__36997,expr__36998))
);

return deferred.addErrback(((function (deferred,pred__36997,expr__36998){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred,pred__36997,expr__36998))
);
});
;})(pred__36997,expr__36998))
} else {
return ((function (pred__36997,expr__36998){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__36997,expr__36998))
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__37001,callback){
var map__37004 = p__37001;
var map__37004__$1 = ((((!((map__37004 == null)))?((((map__37004.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37004.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37004):map__37004);
var file_msg = map__37004__$1;
var request_url = cljs.core.get.call(null,map__37004__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Attempting to load "),cljs.core.str(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__37004,map__37004__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Successfully loaded "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__37004,map__37004__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__29377__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29377__auto__){
return (function (){
var f__29378__auto__ = (function (){var switch__29263__auto__ = ((function (c__29377__auto__){
return (function (state_37028){
var state_val_37029 = (state_37028[(1)]);
if((state_val_37029 === (7))){
var inst_37024 = (state_37028[(2)]);
var state_37028__$1 = state_37028;
var statearr_37030_37050 = state_37028__$1;
(statearr_37030_37050[(2)] = inst_37024);

(statearr_37030_37050[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37029 === (1))){
var state_37028__$1 = state_37028;
var statearr_37031_37051 = state_37028__$1;
(statearr_37031_37051[(2)] = null);

(statearr_37031_37051[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37029 === (4))){
var inst_37008 = (state_37028[(7)]);
var inst_37008__$1 = (state_37028[(2)]);
var state_37028__$1 = (function (){var statearr_37032 = state_37028;
(statearr_37032[(7)] = inst_37008__$1);

return statearr_37032;
})();
if(cljs.core.truth_(inst_37008__$1)){
var statearr_37033_37052 = state_37028__$1;
(statearr_37033_37052[(1)] = (5));

} else {
var statearr_37034_37053 = state_37028__$1;
(statearr_37034_37053[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37029 === (6))){
var state_37028__$1 = state_37028;
var statearr_37035_37054 = state_37028__$1;
(statearr_37035_37054[(2)] = null);

(statearr_37035_37054[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37029 === (3))){
var inst_37026 = (state_37028[(2)]);
var state_37028__$1 = state_37028;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37028__$1,inst_37026);
} else {
if((state_val_37029 === (2))){
var state_37028__$1 = state_37028;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37028__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_37029 === (11))){
var inst_37020 = (state_37028[(2)]);
var state_37028__$1 = (function (){var statearr_37036 = state_37028;
(statearr_37036[(8)] = inst_37020);

return statearr_37036;
})();
var statearr_37037_37055 = state_37028__$1;
(statearr_37037_37055[(2)] = null);

(statearr_37037_37055[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37029 === (9))){
var inst_37014 = (state_37028[(9)]);
var inst_37012 = (state_37028[(10)]);
var inst_37016 = inst_37014.call(null,inst_37012);
var state_37028__$1 = state_37028;
var statearr_37038_37056 = state_37028__$1;
(statearr_37038_37056[(2)] = inst_37016);

(statearr_37038_37056[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37029 === (5))){
var inst_37008 = (state_37028[(7)]);
var inst_37010 = figwheel.client.file_reloading.blocking_load.call(null,inst_37008);
var state_37028__$1 = state_37028;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37028__$1,(8),inst_37010);
} else {
if((state_val_37029 === (10))){
var inst_37012 = (state_37028[(10)]);
var inst_37018 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_37012);
var state_37028__$1 = state_37028;
var statearr_37039_37057 = state_37028__$1;
(statearr_37039_37057[(2)] = inst_37018);

(statearr_37039_37057[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37029 === (8))){
var inst_37008 = (state_37028[(7)]);
var inst_37014 = (state_37028[(9)]);
var inst_37012 = (state_37028[(2)]);
var inst_37013 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_37014__$1 = cljs.core.get.call(null,inst_37013,inst_37008);
var state_37028__$1 = (function (){var statearr_37040 = state_37028;
(statearr_37040[(9)] = inst_37014__$1);

(statearr_37040[(10)] = inst_37012);

return statearr_37040;
})();
if(cljs.core.truth_(inst_37014__$1)){
var statearr_37041_37058 = state_37028__$1;
(statearr_37041_37058[(1)] = (9));

} else {
var statearr_37042_37059 = state_37028__$1;
(statearr_37042_37059[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__29377__auto__))
;
return ((function (switch__29263__auto__,c__29377__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__29264__auto__ = null;
var figwheel$client$file_reloading$state_machine__29264__auto____0 = (function (){
var statearr_37046 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_37046[(0)] = figwheel$client$file_reloading$state_machine__29264__auto__);

(statearr_37046[(1)] = (1));

return statearr_37046;
});
var figwheel$client$file_reloading$state_machine__29264__auto____1 = (function (state_37028){
while(true){
var ret_value__29265__auto__ = (function (){try{while(true){
var result__29266__auto__ = switch__29263__auto__.call(null,state_37028);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29266__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29266__auto__;
}
break;
}
}catch (e37047){if((e37047 instanceof Object)){
var ex__29267__auto__ = e37047;
var statearr_37048_37060 = state_37028;
(statearr_37048_37060[(5)] = ex__29267__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37028);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37047;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29265__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37061 = state_37028;
state_37028 = G__37061;
continue;
} else {
return ret_value__29265__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__29264__auto__ = function(state_37028){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__29264__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__29264__auto____1.call(this,state_37028);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__29264__auto____0;
figwheel$client$file_reloading$state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__29264__auto____1;
return figwheel$client$file_reloading$state_machine__29264__auto__;
})()
;})(switch__29263__auto__,c__29377__auto__))
})();
var state__29379__auto__ = (function (){var statearr_37049 = f__29378__auto__.call(null);
(statearr_37049[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29377__auto__);

return statearr_37049;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29379__auto__);
});})(c__29377__auto__))
);

return c__29377__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__37062,callback){
var map__37065 = p__37062;
var map__37065__$1 = ((((!((map__37065 == null)))?((((map__37065.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37065.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37065):map__37065);
var file_msg = map__37065__$1;
var namespace = cljs.core.get.call(null,map__37065__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__37065,map__37065__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__37065,map__37065__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__37067){
var map__37070 = p__37067;
var map__37070__$1 = ((((!((map__37070 == null)))?((((map__37070.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37070.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37070):map__37070);
var file_msg = map__37070__$1;
var namespace = cljs.core.get.call(null,map__37070__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__26684__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas));
if(and__26684__auto__){
var or__26696__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__26696__auto__)){
return or__26696__auto__;
} else {
var or__26696__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__26696__auto____$1)){
return or__26696__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__26684__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__37072,callback){
var map__37075 = p__37072;
var map__37075__$1 = ((((!((map__37075 == null)))?((((map__37075.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37075.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37075):map__37075);
var file_msg = map__37075__$1;
var request_url = cljs.core.get.call(null,map__37075__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__37075__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Figwheel: Not trying to load file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__29377__auto___37179 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29377__auto___37179,out){
return (function (){
var f__29378__auto__ = (function (){var switch__29263__auto__ = ((function (c__29377__auto___37179,out){
return (function (state_37161){
var state_val_37162 = (state_37161[(1)]);
if((state_val_37162 === (1))){
var inst_37135 = cljs.core.seq.call(null,files);
var inst_37136 = cljs.core.first.call(null,inst_37135);
var inst_37137 = cljs.core.next.call(null,inst_37135);
var inst_37138 = files;
var state_37161__$1 = (function (){var statearr_37163 = state_37161;
(statearr_37163[(7)] = inst_37136);

(statearr_37163[(8)] = inst_37138);

(statearr_37163[(9)] = inst_37137);

return statearr_37163;
})();
var statearr_37164_37180 = state_37161__$1;
(statearr_37164_37180[(2)] = null);

(statearr_37164_37180[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37162 === (2))){
var inst_37138 = (state_37161[(8)]);
var inst_37144 = (state_37161[(10)]);
var inst_37143 = cljs.core.seq.call(null,inst_37138);
var inst_37144__$1 = cljs.core.first.call(null,inst_37143);
var inst_37145 = cljs.core.next.call(null,inst_37143);
var inst_37146 = (inst_37144__$1 == null);
var inst_37147 = cljs.core.not.call(null,inst_37146);
var state_37161__$1 = (function (){var statearr_37165 = state_37161;
(statearr_37165[(10)] = inst_37144__$1);

(statearr_37165[(11)] = inst_37145);

return statearr_37165;
})();
if(inst_37147){
var statearr_37166_37181 = state_37161__$1;
(statearr_37166_37181[(1)] = (4));

} else {
var statearr_37167_37182 = state_37161__$1;
(statearr_37167_37182[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37162 === (3))){
var inst_37159 = (state_37161[(2)]);
var state_37161__$1 = state_37161;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37161__$1,inst_37159);
} else {
if((state_val_37162 === (4))){
var inst_37144 = (state_37161[(10)]);
var inst_37149 = figwheel.client.file_reloading.reload_js_file.call(null,inst_37144);
var state_37161__$1 = state_37161;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37161__$1,(7),inst_37149);
} else {
if((state_val_37162 === (5))){
var inst_37155 = cljs.core.async.close_BANG_.call(null,out);
var state_37161__$1 = state_37161;
var statearr_37168_37183 = state_37161__$1;
(statearr_37168_37183[(2)] = inst_37155);

(statearr_37168_37183[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37162 === (6))){
var inst_37157 = (state_37161[(2)]);
var state_37161__$1 = state_37161;
var statearr_37169_37184 = state_37161__$1;
(statearr_37169_37184[(2)] = inst_37157);

(statearr_37169_37184[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37162 === (7))){
var inst_37145 = (state_37161[(11)]);
var inst_37151 = (state_37161[(2)]);
var inst_37152 = cljs.core.async.put_BANG_.call(null,out,inst_37151);
var inst_37138 = inst_37145;
var state_37161__$1 = (function (){var statearr_37170 = state_37161;
(statearr_37170[(8)] = inst_37138);

(statearr_37170[(12)] = inst_37152);

return statearr_37170;
})();
var statearr_37171_37185 = state_37161__$1;
(statearr_37171_37185[(2)] = null);

(statearr_37171_37185[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__29377__auto___37179,out))
;
return ((function (switch__29263__auto__,c__29377__auto___37179,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__29264__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__29264__auto____0 = (function (){
var statearr_37175 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37175[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__29264__auto__);

(statearr_37175[(1)] = (1));

return statearr_37175;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__29264__auto____1 = (function (state_37161){
while(true){
var ret_value__29265__auto__ = (function (){try{while(true){
var result__29266__auto__ = switch__29263__auto__.call(null,state_37161);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29266__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29266__auto__;
}
break;
}
}catch (e37176){if((e37176 instanceof Object)){
var ex__29267__auto__ = e37176;
var statearr_37177_37186 = state_37161;
(statearr_37177_37186[(5)] = ex__29267__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37161);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37176;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29265__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37187 = state_37161;
state_37161 = G__37187;
continue;
} else {
return ret_value__29265__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__29264__auto__ = function(state_37161){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__29264__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__29264__auto____1.call(this,state_37161);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__29264__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__29264__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__29264__auto__;
})()
;})(switch__29263__auto__,c__29377__auto___37179,out))
})();
var state__29379__auto__ = (function (){var statearr_37178 = f__29378__auto__.call(null);
(statearr_37178[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29377__auto___37179);

return statearr_37178;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29379__auto__);
});})(c__29377__auto___37179,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__37188,opts){
var map__37192 = p__37188;
var map__37192__$1 = ((((!((map__37192 == null)))?((((map__37192.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37192.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37192):map__37192);
var eval_body = cljs.core.get.call(null,map__37192__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__37192__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__26684__auto__ = eval_body;
if(cljs.core.truth_(and__26684__auto__)){
return typeof eval_body === 'string';
} else {
return and__26684__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Evaling file "),cljs.core.str(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e37194){var e = e37194;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Unable to evaluate "),cljs.core.str(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["figwheel.connect",null], null), null),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__6751__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__37195_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__37195_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__6751__auto__)){
var file_msg = temp__6751__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__37204){
var vec__37205 = p__37204;
var k = cljs.core.nth.call(null,vec__37205,(0),null);
var v = cljs.core.nth.call(null,vec__37205,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__37208){
var vec__37209 = p__37208;
var k = cljs.core.nth.call(null,vec__37209,(0),null);
var v = cljs.core.nth.call(null,vec__37209,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__37215,p__37216){
var map__37464 = p__37215;
var map__37464__$1 = ((((!((map__37464 == null)))?((((map__37464.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37464.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37464):map__37464);
var opts = map__37464__$1;
var before_jsload = cljs.core.get.call(null,map__37464__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__37464__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__37464__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__37465 = p__37216;
var map__37465__$1 = ((((!((map__37465 == null)))?((((map__37465.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37465.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37465):map__37465);
var msg = map__37465__$1;
var files = cljs.core.get.call(null,map__37465__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__37465__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__37465__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__29377__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29377__auto__,map__37464,map__37464__$1,opts,before_jsload,on_jsload,reload_dependents,map__37465,map__37465__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__29378__auto__ = (function (){var switch__29263__auto__ = ((function (c__29377__auto__,map__37464,map__37464__$1,opts,before_jsload,on_jsload,reload_dependents,map__37465,map__37465__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_37619){
var state_val_37620 = (state_37619[(1)]);
if((state_val_37620 === (7))){
var inst_37479 = (state_37619[(7)]);
var inst_37481 = (state_37619[(8)]);
var inst_37482 = (state_37619[(9)]);
var inst_37480 = (state_37619[(10)]);
var inst_37487 = cljs.core._nth.call(null,inst_37480,inst_37482);
var inst_37488 = figwheel.client.file_reloading.eval_body.call(null,inst_37487,opts);
var inst_37489 = (inst_37482 + (1));
var tmp37621 = inst_37479;
var tmp37622 = inst_37481;
var tmp37623 = inst_37480;
var inst_37479__$1 = tmp37621;
var inst_37480__$1 = tmp37623;
var inst_37481__$1 = tmp37622;
var inst_37482__$1 = inst_37489;
var state_37619__$1 = (function (){var statearr_37624 = state_37619;
(statearr_37624[(7)] = inst_37479__$1);

(statearr_37624[(11)] = inst_37488);

(statearr_37624[(8)] = inst_37481__$1);

(statearr_37624[(9)] = inst_37482__$1);

(statearr_37624[(10)] = inst_37480__$1);

return statearr_37624;
})();
var statearr_37625_37711 = state_37619__$1;
(statearr_37625_37711[(2)] = null);

(statearr_37625_37711[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (20))){
var inst_37522 = (state_37619[(12)]);
var inst_37530 = figwheel.client.file_reloading.sort_files.call(null,inst_37522);
var state_37619__$1 = state_37619;
var statearr_37626_37712 = state_37619__$1;
(statearr_37626_37712[(2)] = inst_37530);

(statearr_37626_37712[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (27))){
var state_37619__$1 = state_37619;
var statearr_37627_37713 = state_37619__$1;
(statearr_37627_37713[(2)] = null);

(statearr_37627_37713[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (1))){
var inst_37471 = (state_37619[(13)]);
var inst_37468 = before_jsload.call(null,files);
var inst_37469 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_37470 = (function (){return ((function (inst_37471,inst_37468,inst_37469,state_val_37620,c__29377__auto__,map__37464,map__37464__$1,opts,before_jsload,on_jsload,reload_dependents,map__37465,map__37465__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__37212_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__37212_SHARP_);
});
;})(inst_37471,inst_37468,inst_37469,state_val_37620,c__29377__auto__,map__37464,map__37464__$1,opts,before_jsload,on_jsload,reload_dependents,map__37465,map__37465__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_37471__$1 = cljs.core.filter.call(null,inst_37470,files);
var inst_37472 = cljs.core.not_empty.call(null,inst_37471__$1);
var state_37619__$1 = (function (){var statearr_37628 = state_37619;
(statearr_37628[(14)] = inst_37469);

(statearr_37628[(15)] = inst_37468);

(statearr_37628[(13)] = inst_37471__$1);

return statearr_37628;
})();
if(cljs.core.truth_(inst_37472)){
var statearr_37629_37714 = state_37619__$1;
(statearr_37629_37714[(1)] = (2));

} else {
var statearr_37630_37715 = state_37619__$1;
(statearr_37630_37715[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (24))){
var state_37619__$1 = state_37619;
var statearr_37631_37716 = state_37619__$1;
(statearr_37631_37716[(2)] = null);

(statearr_37631_37716[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (39))){
var inst_37572 = (state_37619[(16)]);
var state_37619__$1 = state_37619;
var statearr_37632_37717 = state_37619__$1;
(statearr_37632_37717[(2)] = inst_37572);

(statearr_37632_37717[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (46))){
var inst_37614 = (state_37619[(2)]);
var state_37619__$1 = state_37619;
var statearr_37633_37718 = state_37619__$1;
(statearr_37633_37718[(2)] = inst_37614);

(statearr_37633_37718[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (4))){
var inst_37516 = (state_37619[(2)]);
var inst_37517 = cljs.core.List.EMPTY;
var inst_37518 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_37517);
var inst_37519 = (function (){return ((function (inst_37516,inst_37517,inst_37518,state_val_37620,c__29377__auto__,map__37464,map__37464__$1,opts,before_jsload,on_jsload,reload_dependents,map__37465,map__37465__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__37213_SHARP_){
var and__26684__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__37213_SHARP_);
if(cljs.core.truth_(and__26684__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__37213_SHARP_));
} else {
return and__26684__auto__;
}
});
;})(inst_37516,inst_37517,inst_37518,state_val_37620,c__29377__auto__,map__37464,map__37464__$1,opts,before_jsload,on_jsload,reload_dependents,map__37465,map__37465__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_37520 = cljs.core.filter.call(null,inst_37519,files);
var inst_37521 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_37522 = cljs.core.concat.call(null,inst_37520,inst_37521);
var state_37619__$1 = (function (){var statearr_37634 = state_37619;
(statearr_37634[(12)] = inst_37522);

(statearr_37634[(17)] = inst_37518);

(statearr_37634[(18)] = inst_37516);

return statearr_37634;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_37635_37719 = state_37619__$1;
(statearr_37635_37719[(1)] = (16));

} else {
var statearr_37636_37720 = state_37619__$1;
(statearr_37636_37720[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (15))){
var inst_37506 = (state_37619[(2)]);
var state_37619__$1 = state_37619;
var statearr_37637_37721 = state_37619__$1;
(statearr_37637_37721[(2)] = inst_37506);

(statearr_37637_37721[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (21))){
var inst_37532 = (state_37619[(19)]);
var inst_37532__$1 = (state_37619[(2)]);
var inst_37533 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_37532__$1);
var state_37619__$1 = (function (){var statearr_37638 = state_37619;
(statearr_37638[(19)] = inst_37532__$1);

return statearr_37638;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37619__$1,(22),inst_37533);
} else {
if((state_val_37620 === (31))){
var inst_37617 = (state_37619[(2)]);
var state_37619__$1 = state_37619;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37619__$1,inst_37617);
} else {
if((state_val_37620 === (32))){
var inst_37572 = (state_37619[(16)]);
var inst_37577 = inst_37572.cljs$lang$protocol_mask$partition0$;
var inst_37578 = (inst_37577 & (64));
var inst_37579 = inst_37572.cljs$core$ISeq$;
var inst_37580 = (cljs.core.PROTOCOL_SENTINEL === inst_37579);
var inst_37581 = (inst_37578) || (inst_37580);
var state_37619__$1 = state_37619;
if(cljs.core.truth_(inst_37581)){
var statearr_37639_37722 = state_37619__$1;
(statearr_37639_37722[(1)] = (35));

} else {
var statearr_37640_37723 = state_37619__$1;
(statearr_37640_37723[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (40))){
var inst_37594 = (state_37619[(20)]);
var inst_37593 = (state_37619[(2)]);
var inst_37594__$1 = cljs.core.get.call(null,inst_37593,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_37595 = cljs.core.get.call(null,inst_37593,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_37596 = cljs.core.not_empty.call(null,inst_37594__$1);
var state_37619__$1 = (function (){var statearr_37641 = state_37619;
(statearr_37641[(20)] = inst_37594__$1);

(statearr_37641[(21)] = inst_37595);

return statearr_37641;
})();
if(cljs.core.truth_(inst_37596)){
var statearr_37642_37724 = state_37619__$1;
(statearr_37642_37724[(1)] = (41));

} else {
var statearr_37643_37725 = state_37619__$1;
(statearr_37643_37725[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (33))){
var state_37619__$1 = state_37619;
var statearr_37644_37726 = state_37619__$1;
(statearr_37644_37726[(2)] = false);

(statearr_37644_37726[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (13))){
var inst_37492 = (state_37619[(22)]);
var inst_37496 = cljs.core.chunk_first.call(null,inst_37492);
var inst_37497 = cljs.core.chunk_rest.call(null,inst_37492);
var inst_37498 = cljs.core.count.call(null,inst_37496);
var inst_37479 = inst_37497;
var inst_37480 = inst_37496;
var inst_37481 = inst_37498;
var inst_37482 = (0);
var state_37619__$1 = (function (){var statearr_37645 = state_37619;
(statearr_37645[(7)] = inst_37479);

(statearr_37645[(8)] = inst_37481);

(statearr_37645[(9)] = inst_37482);

(statearr_37645[(10)] = inst_37480);

return statearr_37645;
})();
var statearr_37646_37727 = state_37619__$1;
(statearr_37646_37727[(2)] = null);

(statearr_37646_37727[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (22))){
var inst_37535 = (state_37619[(23)]);
var inst_37540 = (state_37619[(24)]);
var inst_37536 = (state_37619[(25)]);
var inst_37532 = (state_37619[(19)]);
var inst_37535__$1 = (state_37619[(2)]);
var inst_37536__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_37535__$1);
var inst_37537 = (function (){var all_files = inst_37532;
var res_SINGLEQUOTE_ = inst_37535__$1;
var res = inst_37536__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_37535,inst_37540,inst_37536,inst_37532,inst_37535__$1,inst_37536__$1,state_val_37620,c__29377__auto__,map__37464,map__37464__$1,opts,before_jsload,on_jsload,reload_dependents,map__37465,map__37465__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__37214_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__37214_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_37535,inst_37540,inst_37536,inst_37532,inst_37535__$1,inst_37536__$1,state_val_37620,c__29377__auto__,map__37464,map__37464__$1,opts,before_jsload,on_jsload,reload_dependents,map__37465,map__37465__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_37538 = cljs.core.filter.call(null,inst_37537,inst_37535__$1);
var inst_37539 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_37540__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_37539);
var inst_37541 = cljs.core.not_empty.call(null,inst_37540__$1);
var state_37619__$1 = (function (){var statearr_37647 = state_37619;
(statearr_37647[(23)] = inst_37535__$1);

(statearr_37647[(24)] = inst_37540__$1);

(statearr_37647[(25)] = inst_37536__$1);

(statearr_37647[(26)] = inst_37538);

return statearr_37647;
})();
if(cljs.core.truth_(inst_37541)){
var statearr_37648_37728 = state_37619__$1;
(statearr_37648_37728[(1)] = (23));

} else {
var statearr_37649_37729 = state_37619__$1;
(statearr_37649_37729[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (36))){
var state_37619__$1 = state_37619;
var statearr_37650_37730 = state_37619__$1;
(statearr_37650_37730[(2)] = false);

(statearr_37650_37730[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (41))){
var inst_37594 = (state_37619[(20)]);
var inst_37598 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_37599 = cljs.core.map.call(null,inst_37598,inst_37594);
var inst_37600 = cljs.core.pr_str.call(null,inst_37599);
var inst_37601 = [cljs.core.str("figwheel-no-load meta-data: "),cljs.core.str(inst_37600)].join('');
var inst_37602 = figwheel.client.utils.log.call(null,inst_37601);
var state_37619__$1 = state_37619;
var statearr_37651_37731 = state_37619__$1;
(statearr_37651_37731[(2)] = inst_37602);

(statearr_37651_37731[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (43))){
var inst_37595 = (state_37619[(21)]);
var inst_37605 = (state_37619[(2)]);
var inst_37606 = cljs.core.not_empty.call(null,inst_37595);
var state_37619__$1 = (function (){var statearr_37652 = state_37619;
(statearr_37652[(27)] = inst_37605);

return statearr_37652;
})();
if(cljs.core.truth_(inst_37606)){
var statearr_37653_37732 = state_37619__$1;
(statearr_37653_37732[(1)] = (44));

} else {
var statearr_37654_37733 = state_37619__$1;
(statearr_37654_37733[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (29))){
var inst_37535 = (state_37619[(23)]);
var inst_37540 = (state_37619[(24)]);
var inst_37536 = (state_37619[(25)]);
var inst_37572 = (state_37619[(16)]);
var inst_37532 = (state_37619[(19)]);
var inst_37538 = (state_37619[(26)]);
var inst_37568 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_37571 = (function (){var all_files = inst_37532;
var res_SINGLEQUOTE_ = inst_37535;
var res = inst_37536;
var files_not_loaded = inst_37538;
var dependencies_that_loaded = inst_37540;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_37535,inst_37540,inst_37536,inst_37572,inst_37532,inst_37538,inst_37568,state_val_37620,c__29377__auto__,map__37464,map__37464__$1,opts,before_jsload,on_jsload,reload_dependents,map__37465,map__37465__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__37570){
var map__37655 = p__37570;
var map__37655__$1 = ((((!((map__37655 == null)))?((((map__37655.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37655.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37655):map__37655);
var namespace = cljs.core.get.call(null,map__37655__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_37535,inst_37540,inst_37536,inst_37572,inst_37532,inst_37538,inst_37568,state_val_37620,c__29377__auto__,map__37464,map__37464__$1,opts,before_jsload,on_jsload,reload_dependents,map__37465,map__37465__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_37572__$1 = cljs.core.group_by.call(null,inst_37571,inst_37538);
var inst_37574 = (inst_37572__$1 == null);
var inst_37575 = cljs.core.not.call(null,inst_37574);
var state_37619__$1 = (function (){var statearr_37657 = state_37619;
(statearr_37657[(28)] = inst_37568);

(statearr_37657[(16)] = inst_37572__$1);

return statearr_37657;
})();
if(inst_37575){
var statearr_37658_37734 = state_37619__$1;
(statearr_37658_37734[(1)] = (32));

} else {
var statearr_37659_37735 = state_37619__$1;
(statearr_37659_37735[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (44))){
var inst_37595 = (state_37619[(21)]);
var inst_37608 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_37595);
var inst_37609 = cljs.core.pr_str.call(null,inst_37608);
var inst_37610 = [cljs.core.str("not required: "),cljs.core.str(inst_37609)].join('');
var inst_37611 = figwheel.client.utils.log.call(null,inst_37610);
var state_37619__$1 = state_37619;
var statearr_37660_37736 = state_37619__$1;
(statearr_37660_37736[(2)] = inst_37611);

(statearr_37660_37736[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (6))){
var inst_37513 = (state_37619[(2)]);
var state_37619__$1 = state_37619;
var statearr_37661_37737 = state_37619__$1;
(statearr_37661_37737[(2)] = inst_37513);

(statearr_37661_37737[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (28))){
var inst_37538 = (state_37619[(26)]);
var inst_37565 = (state_37619[(2)]);
var inst_37566 = cljs.core.not_empty.call(null,inst_37538);
var state_37619__$1 = (function (){var statearr_37662 = state_37619;
(statearr_37662[(29)] = inst_37565);

return statearr_37662;
})();
if(cljs.core.truth_(inst_37566)){
var statearr_37663_37738 = state_37619__$1;
(statearr_37663_37738[(1)] = (29));

} else {
var statearr_37664_37739 = state_37619__$1;
(statearr_37664_37739[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (25))){
var inst_37536 = (state_37619[(25)]);
var inst_37552 = (state_37619[(2)]);
var inst_37553 = cljs.core.not_empty.call(null,inst_37536);
var state_37619__$1 = (function (){var statearr_37665 = state_37619;
(statearr_37665[(30)] = inst_37552);

return statearr_37665;
})();
if(cljs.core.truth_(inst_37553)){
var statearr_37666_37740 = state_37619__$1;
(statearr_37666_37740[(1)] = (26));

} else {
var statearr_37667_37741 = state_37619__$1;
(statearr_37667_37741[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (34))){
var inst_37588 = (state_37619[(2)]);
var state_37619__$1 = state_37619;
if(cljs.core.truth_(inst_37588)){
var statearr_37668_37742 = state_37619__$1;
(statearr_37668_37742[(1)] = (38));

} else {
var statearr_37669_37743 = state_37619__$1;
(statearr_37669_37743[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (17))){
var state_37619__$1 = state_37619;
var statearr_37670_37744 = state_37619__$1;
(statearr_37670_37744[(2)] = recompile_dependents);

(statearr_37670_37744[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (3))){
var state_37619__$1 = state_37619;
var statearr_37671_37745 = state_37619__$1;
(statearr_37671_37745[(2)] = null);

(statearr_37671_37745[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (12))){
var inst_37509 = (state_37619[(2)]);
var state_37619__$1 = state_37619;
var statearr_37672_37746 = state_37619__$1;
(statearr_37672_37746[(2)] = inst_37509);

(statearr_37672_37746[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (2))){
var inst_37471 = (state_37619[(13)]);
var inst_37478 = cljs.core.seq.call(null,inst_37471);
var inst_37479 = inst_37478;
var inst_37480 = null;
var inst_37481 = (0);
var inst_37482 = (0);
var state_37619__$1 = (function (){var statearr_37673 = state_37619;
(statearr_37673[(7)] = inst_37479);

(statearr_37673[(8)] = inst_37481);

(statearr_37673[(9)] = inst_37482);

(statearr_37673[(10)] = inst_37480);

return statearr_37673;
})();
var statearr_37674_37747 = state_37619__$1;
(statearr_37674_37747[(2)] = null);

(statearr_37674_37747[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (23))){
var inst_37535 = (state_37619[(23)]);
var inst_37540 = (state_37619[(24)]);
var inst_37536 = (state_37619[(25)]);
var inst_37532 = (state_37619[(19)]);
var inst_37538 = (state_37619[(26)]);
var inst_37543 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_37545 = (function (){var all_files = inst_37532;
var res_SINGLEQUOTE_ = inst_37535;
var res = inst_37536;
var files_not_loaded = inst_37538;
var dependencies_that_loaded = inst_37540;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_37535,inst_37540,inst_37536,inst_37532,inst_37538,inst_37543,state_val_37620,c__29377__auto__,map__37464,map__37464__$1,opts,before_jsload,on_jsload,reload_dependents,map__37465,map__37465__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__37544){
var map__37675 = p__37544;
var map__37675__$1 = ((((!((map__37675 == null)))?((((map__37675.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37675.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37675):map__37675);
var request_url = cljs.core.get.call(null,map__37675__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_37535,inst_37540,inst_37536,inst_37532,inst_37538,inst_37543,state_val_37620,c__29377__auto__,map__37464,map__37464__$1,opts,before_jsload,on_jsload,reload_dependents,map__37465,map__37465__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_37546 = cljs.core.reverse.call(null,inst_37540);
var inst_37547 = cljs.core.map.call(null,inst_37545,inst_37546);
var inst_37548 = cljs.core.pr_str.call(null,inst_37547);
var inst_37549 = figwheel.client.utils.log.call(null,inst_37548);
var state_37619__$1 = (function (){var statearr_37677 = state_37619;
(statearr_37677[(31)] = inst_37543);

return statearr_37677;
})();
var statearr_37678_37748 = state_37619__$1;
(statearr_37678_37748[(2)] = inst_37549);

(statearr_37678_37748[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (35))){
var state_37619__$1 = state_37619;
var statearr_37679_37749 = state_37619__$1;
(statearr_37679_37749[(2)] = true);

(statearr_37679_37749[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (19))){
var inst_37522 = (state_37619[(12)]);
var inst_37528 = figwheel.client.file_reloading.expand_files.call(null,inst_37522);
var state_37619__$1 = state_37619;
var statearr_37680_37750 = state_37619__$1;
(statearr_37680_37750[(2)] = inst_37528);

(statearr_37680_37750[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (11))){
var state_37619__$1 = state_37619;
var statearr_37681_37751 = state_37619__$1;
(statearr_37681_37751[(2)] = null);

(statearr_37681_37751[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (9))){
var inst_37511 = (state_37619[(2)]);
var state_37619__$1 = state_37619;
var statearr_37682_37752 = state_37619__$1;
(statearr_37682_37752[(2)] = inst_37511);

(statearr_37682_37752[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (5))){
var inst_37481 = (state_37619[(8)]);
var inst_37482 = (state_37619[(9)]);
var inst_37484 = (inst_37482 < inst_37481);
var inst_37485 = inst_37484;
var state_37619__$1 = state_37619;
if(cljs.core.truth_(inst_37485)){
var statearr_37683_37753 = state_37619__$1;
(statearr_37683_37753[(1)] = (7));

} else {
var statearr_37684_37754 = state_37619__$1;
(statearr_37684_37754[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (14))){
var inst_37492 = (state_37619[(22)]);
var inst_37501 = cljs.core.first.call(null,inst_37492);
var inst_37502 = figwheel.client.file_reloading.eval_body.call(null,inst_37501,opts);
var inst_37503 = cljs.core.next.call(null,inst_37492);
var inst_37479 = inst_37503;
var inst_37480 = null;
var inst_37481 = (0);
var inst_37482 = (0);
var state_37619__$1 = (function (){var statearr_37685 = state_37619;
(statearr_37685[(7)] = inst_37479);

(statearr_37685[(32)] = inst_37502);

(statearr_37685[(8)] = inst_37481);

(statearr_37685[(9)] = inst_37482);

(statearr_37685[(10)] = inst_37480);

return statearr_37685;
})();
var statearr_37686_37755 = state_37619__$1;
(statearr_37686_37755[(2)] = null);

(statearr_37686_37755[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (45))){
var state_37619__$1 = state_37619;
var statearr_37687_37756 = state_37619__$1;
(statearr_37687_37756[(2)] = null);

(statearr_37687_37756[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (26))){
var inst_37535 = (state_37619[(23)]);
var inst_37540 = (state_37619[(24)]);
var inst_37536 = (state_37619[(25)]);
var inst_37532 = (state_37619[(19)]);
var inst_37538 = (state_37619[(26)]);
var inst_37555 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_37557 = (function (){var all_files = inst_37532;
var res_SINGLEQUOTE_ = inst_37535;
var res = inst_37536;
var files_not_loaded = inst_37538;
var dependencies_that_loaded = inst_37540;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_37535,inst_37540,inst_37536,inst_37532,inst_37538,inst_37555,state_val_37620,c__29377__auto__,map__37464,map__37464__$1,opts,before_jsload,on_jsload,reload_dependents,map__37465,map__37465__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__37556){
var map__37688 = p__37556;
var map__37688__$1 = ((((!((map__37688 == null)))?((((map__37688.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37688.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37688):map__37688);
var namespace = cljs.core.get.call(null,map__37688__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__37688__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_37535,inst_37540,inst_37536,inst_37532,inst_37538,inst_37555,state_val_37620,c__29377__auto__,map__37464,map__37464__$1,opts,before_jsload,on_jsload,reload_dependents,map__37465,map__37465__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_37558 = cljs.core.map.call(null,inst_37557,inst_37536);
var inst_37559 = cljs.core.pr_str.call(null,inst_37558);
var inst_37560 = figwheel.client.utils.log.call(null,inst_37559);
var inst_37561 = (function (){var all_files = inst_37532;
var res_SINGLEQUOTE_ = inst_37535;
var res = inst_37536;
var files_not_loaded = inst_37538;
var dependencies_that_loaded = inst_37540;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_37535,inst_37540,inst_37536,inst_37532,inst_37538,inst_37555,inst_37557,inst_37558,inst_37559,inst_37560,state_val_37620,c__29377__auto__,map__37464,map__37464__$1,opts,before_jsload,on_jsload,reload_dependents,map__37465,map__37465__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_37535,inst_37540,inst_37536,inst_37532,inst_37538,inst_37555,inst_37557,inst_37558,inst_37559,inst_37560,state_val_37620,c__29377__auto__,map__37464,map__37464__$1,opts,before_jsload,on_jsload,reload_dependents,map__37465,map__37465__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_37562 = setTimeout(inst_37561,(10));
var state_37619__$1 = (function (){var statearr_37690 = state_37619;
(statearr_37690[(33)] = inst_37555);

(statearr_37690[(34)] = inst_37560);

return statearr_37690;
})();
var statearr_37691_37757 = state_37619__$1;
(statearr_37691_37757[(2)] = inst_37562);

(statearr_37691_37757[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (16))){
var state_37619__$1 = state_37619;
var statearr_37692_37758 = state_37619__$1;
(statearr_37692_37758[(2)] = reload_dependents);

(statearr_37692_37758[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (38))){
var inst_37572 = (state_37619[(16)]);
var inst_37590 = cljs.core.apply.call(null,cljs.core.hash_map,inst_37572);
var state_37619__$1 = state_37619;
var statearr_37693_37759 = state_37619__$1;
(statearr_37693_37759[(2)] = inst_37590);

(statearr_37693_37759[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (30))){
var state_37619__$1 = state_37619;
var statearr_37694_37760 = state_37619__$1;
(statearr_37694_37760[(2)] = null);

(statearr_37694_37760[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (10))){
var inst_37492 = (state_37619[(22)]);
var inst_37494 = cljs.core.chunked_seq_QMARK_.call(null,inst_37492);
var state_37619__$1 = state_37619;
if(inst_37494){
var statearr_37695_37761 = state_37619__$1;
(statearr_37695_37761[(1)] = (13));

} else {
var statearr_37696_37762 = state_37619__$1;
(statearr_37696_37762[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (18))){
var inst_37526 = (state_37619[(2)]);
var state_37619__$1 = state_37619;
if(cljs.core.truth_(inst_37526)){
var statearr_37697_37763 = state_37619__$1;
(statearr_37697_37763[(1)] = (19));

} else {
var statearr_37698_37764 = state_37619__$1;
(statearr_37698_37764[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (42))){
var state_37619__$1 = state_37619;
var statearr_37699_37765 = state_37619__$1;
(statearr_37699_37765[(2)] = null);

(statearr_37699_37765[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (37))){
var inst_37585 = (state_37619[(2)]);
var state_37619__$1 = state_37619;
var statearr_37700_37766 = state_37619__$1;
(statearr_37700_37766[(2)] = inst_37585);

(statearr_37700_37766[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37620 === (8))){
var inst_37479 = (state_37619[(7)]);
var inst_37492 = (state_37619[(22)]);
var inst_37492__$1 = cljs.core.seq.call(null,inst_37479);
var state_37619__$1 = (function (){var statearr_37701 = state_37619;
(statearr_37701[(22)] = inst_37492__$1);

return statearr_37701;
})();
if(inst_37492__$1){
var statearr_37702_37767 = state_37619__$1;
(statearr_37702_37767[(1)] = (10));

} else {
var statearr_37703_37768 = state_37619__$1;
(statearr_37703_37768[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29377__auto__,map__37464,map__37464__$1,opts,before_jsload,on_jsload,reload_dependents,map__37465,map__37465__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__29263__auto__,c__29377__auto__,map__37464,map__37464__$1,opts,before_jsload,on_jsload,reload_dependents,map__37465,map__37465__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__29264__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__29264__auto____0 = (function (){
var statearr_37707 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37707[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__29264__auto__);

(statearr_37707[(1)] = (1));

return statearr_37707;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__29264__auto____1 = (function (state_37619){
while(true){
var ret_value__29265__auto__ = (function (){try{while(true){
var result__29266__auto__ = switch__29263__auto__.call(null,state_37619);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29266__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29266__auto__;
}
break;
}
}catch (e37708){if((e37708 instanceof Object)){
var ex__29267__auto__ = e37708;
var statearr_37709_37769 = state_37619;
(statearr_37709_37769[(5)] = ex__29267__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37619);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37708;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29265__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37770 = state_37619;
state_37619 = G__37770;
continue;
} else {
return ret_value__29265__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__29264__auto__ = function(state_37619){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__29264__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__29264__auto____1.call(this,state_37619);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__29264__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__29264__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__29264__auto__;
})()
;})(switch__29263__auto__,c__29377__auto__,map__37464,map__37464__$1,opts,before_jsload,on_jsload,reload_dependents,map__37465,map__37465__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__29379__auto__ = (function (){var statearr_37710 = f__29378__auto__.call(null);
(statearr_37710[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29377__auto__);

return statearr_37710;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29379__auto__);
});})(c__29377__auto__,map__37464,map__37464__$1,opts,before_jsload,on_jsload,reload_dependents,map__37465,map__37465__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__29377__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str(location.protocol),cljs.core.str("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__37773,link){
var map__37776 = p__37773;
var map__37776__$1 = ((((!((map__37776 == null)))?((((map__37776.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37776.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37776):map__37776);
var file = cljs.core.get.call(null,map__37776__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__6753__auto__ = link.href;
if(cljs.core.truth_(temp__6753__auto__)){
var link_href = temp__6753__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__6753__auto__,map__37776,map__37776__$1,file){
return (function (p1__37771_SHARP_,p2__37772_SHARP_){
if(cljs.core._EQ_.call(null,p1__37771_SHARP_,p2__37772_SHARP_)){
return p1__37771_SHARP_;
} else {
return false;
}
});})(link_href,temp__6753__auto__,map__37776,map__37776__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__6753__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__37782){
var map__37783 = p__37782;
var map__37783__$1 = ((((!((map__37783 == null)))?((((map__37783.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37783.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37783):map__37783);
var match_length = cljs.core.get.call(null,map__37783__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__37783__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__37778_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__37778_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__6753__auto__)){
var res = temp__6753__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.add_link_to_doc = (function figwheel$client$file_reloading$add_link_to_doc(var_args){
var args37785 = [];
var len__27912__auto___37788 = arguments.length;
var i__27913__auto___37789 = (0);
while(true){
if((i__27913__auto___37789 < len__27912__auto___37788)){
args37785.push((arguments[i__27913__auto___37789]));

var G__37790 = (i__27913__auto___37789 + (1));
i__27913__auto___37789 = G__37790;
continue;
} else {
}
break;
}

var G__37787 = args37785.length;
switch (G__37787) {
case 1:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37785.length)].join('')));

}
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = (function (new_link){
return (document.getElementsByTagName("head")[(0)]).appendChild(new_link);
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = (function (orig_link,klone){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
return parent.removeChild(orig_link);
});})(parent))
,(300));
});

figwheel.client.file_reloading.add_link_to_doc.cljs$lang$maxFixedArity = 2;

figwheel.client.file_reloading.distictify = (function figwheel$client$file_reloading$distictify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__37792_SHARP_,p2__37793_SHARP_){
return cljs.core.assoc.call(null,p1__37792_SHARP_,cljs.core.get.call(null,p2__37793_SHARP_,key),p2__37793_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(p__37794){
var map__37797 = p__37794;
var map__37797__$1 = ((((!((map__37797 == null)))?((((map__37797.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37797.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37797):map__37797);
var f_data = map__37797__$1;
var file = cljs.core.get.call(null,map__37797__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__6753__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__6753__auto__)){
var link = temp__6753__auto__;
return figwheel.client.file_reloading.add_link_to_doc.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href));
} else {
return null;
}
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__37799,p__37800){
var map__37809 = p__37799;
var map__37809__$1 = ((((!((map__37809 == null)))?((((map__37809.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37809.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37809):map__37809);
var opts = map__37809__$1;
var on_cssload = cljs.core.get.call(null,map__37809__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__37810 = p__37800;
var map__37810__$1 = ((((!((map__37810 == null)))?((((map__37810.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37810.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37810):map__37810);
var files_msg = map__37810__$1;
var files = cljs.core.get.call(null,map__37810__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var seq__37813_37817 = cljs.core.seq.call(null,figwheel.client.file_reloading.distictify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
var chunk__37814_37818 = null;
var count__37815_37819 = (0);
var i__37816_37820 = (0);
while(true){
if((i__37816_37820 < count__37815_37819)){
var f_37821 = cljs.core._nth.call(null,chunk__37814_37818,i__37816_37820);
figwheel.client.file_reloading.reload_css_file.call(null,f_37821);

var G__37822 = seq__37813_37817;
var G__37823 = chunk__37814_37818;
var G__37824 = count__37815_37819;
var G__37825 = (i__37816_37820 + (1));
seq__37813_37817 = G__37822;
chunk__37814_37818 = G__37823;
count__37815_37819 = G__37824;
i__37816_37820 = G__37825;
continue;
} else {
var temp__6753__auto___37826 = cljs.core.seq.call(null,seq__37813_37817);
if(temp__6753__auto___37826){
var seq__37813_37827__$1 = temp__6753__auto___37826;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__37813_37827__$1)){
var c__27602__auto___37828 = cljs.core.chunk_first.call(null,seq__37813_37827__$1);
var G__37829 = cljs.core.chunk_rest.call(null,seq__37813_37827__$1);
var G__37830 = c__27602__auto___37828;
var G__37831 = cljs.core.count.call(null,c__27602__auto___37828);
var G__37832 = (0);
seq__37813_37817 = G__37829;
chunk__37814_37818 = G__37830;
count__37815_37819 = G__37831;
i__37816_37820 = G__37832;
continue;
} else {
var f_37833 = cljs.core.first.call(null,seq__37813_37827__$1);
figwheel.client.file_reloading.reload_css_file.call(null,f_37833);

var G__37834 = cljs.core.next.call(null,seq__37813_37827__$1);
var G__37835 = null;
var G__37836 = (0);
var G__37837 = (0);
seq__37813_37817 = G__37834;
chunk__37814_37818 = G__37835;
count__37815_37819 = G__37836;
i__37816_37820 = G__37837;
continue;
}
} else {
}
}
break;
}

return setTimeout(((function (map__37809,map__37809__$1,opts,on_cssload,map__37810,map__37810__$1,files_msg,files){
return (function (){
figwheel.client.file_reloading.on_cssload_custom_event.call(null,files);

return on_cssload.call(null,files);
});})(map__37809,map__37809__$1,opts,on_cssload,map__37810,map__37810__$1,files_msg,files))
,(100));
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1491498012392