// Compiled by ClojureScript 1.9.293 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args29436 = [];
var len__27912__auto___29442 = arguments.length;
var i__27913__auto___29443 = (0);
while(true){
if((i__27913__auto___29443 < len__27912__auto___29442)){
args29436.push((arguments[i__27913__auto___29443]));

var G__29444 = (i__27913__auto___29443 + (1));
i__27913__auto___29443 = G__29444;
continue;
} else {
}
break;
}

var G__29438 = args29436.length;
switch (G__29438) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29436.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async29439 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29439 = (function (f,blockable,meta29440){
this.f = f;
this.blockable = blockable;
this.meta29440 = meta29440;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async29439.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29441,meta29440__$1){
var self__ = this;
var _29441__$1 = this;
return (new cljs.core.async.t_cljs$core$async29439(self__.f,self__.blockable,meta29440__$1));
});

cljs.core.async.t_cljs$core$async29439.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29441){
var self__ = this;
var _29441__$1 = this;
return self__.meta29440;
});

cljs.core.async.t_cljs$core$async29439.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async29439.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async29439.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async29439.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async29439.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta29440","meta29440",-1915504902,null)], null);
});

cljs.core.async.t_cljs$core$async29439.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async29439.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29439";

cljs.core.async.t_cljs$core$async29439.cljs$lang$ctorPrWriter = (function (this__27348__auto__,writer__27349__auto__,opt__27350__auto__){
return cljs.core._write.call(null,writer__27349__auto__,"cljs.core.async/t_cljs$core$async29439");
});

cljs.core.async.__GT_t_cljs$core$async29439 = (function cljs$core$async$__GT_t_cljs$core$async29439(f__$1,blockable__$1,meta29440){
return (new cljs.core.async.t_cljs$core$async29439(f__$1,blockable__$1,meta29440));
});

}

return (new cljs.core.async.t_cljs$core$async29439(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args29448 = [];
var len__27912__auto___29451 = arguments.length;
var i__27913__auto___29452 = (0);
while(true){
if((i__27913__auto___29452 < len__27912__auto___29451)){
args29448.push((arguments[i__27913__auto___29452]));

var G__29453 = (i__27913__auto___29452 + (1));
i__27913__auto___29452 = G__29453;
continue;
} else {
}
break;
}

var G__29450 = args29448.length;
switch (G__29450) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29448.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args29455 = [];
var len__27912__auto___29458 = arguments.length;
var i__27913__auto___29459 = (0);
while(true){
if((i__27913__auto___29459 < len__27912__auto___29458)){
args29455.push((arguments[i__27913__auto___29459]));

var G__29460 = (i__27913__auto___29459 + (1));
i__27913__auto___29459 = G__29460;
continue;
} else {
}
break;
}

var G__29457 = args29455.length;
switch (G__29457) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29455.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args29462 = [];
var len__27912__auto___29465 = arguments.length;
var i__27913__auto___29466 = (0);
while(true){
if((i__27913__auto___29466 < len__27912__auto___29465)){
args29462.push((arguments[i__27913__auto___29466]));

var G__29467 = (i__27913__auto___29466 + (1));
i__27913__auto___29466 = G__29467;
continue;
} else {
}
break;
}

var G__29464 = args29462.length;
switch (G__29464) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29462.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_29469 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_29469);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_29469,ret){
return (function (){
return fn1.call(null,val_29469);
});})(val_29469,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args29470 = [];
var len__27912__auto___29473 = arguments.length;
var i__27913__auto___29474 = (0);
while(true){
if((i__27913__auto___29474 < len__27912__auto___29473)){
args29470.push((arguments[i__27913__auto___29474]));

var G__29475 = (i__27913__auto___29474 + (1));
i__27913__auto___29474 = G__29475;
continue;
} else {
}
break;
}

var G__29472 = args29470.length;
switch (G__29472) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29470.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__6751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__6751__auto__)){
var ret = temp__6751__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__6751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__6751__auto__)){
var retb = temp__6751__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__6751__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__6751__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__27712__auto___29477 = n;
var x_29478 = (0);
while(true){
if((x_29478 < n__27712__auto___29477)){
(a[x_29478] = (0));

var G__29479 = (x_29478 + (1));
x_29478 = G__29479;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__29480 = (i + (1));
i = G__29480;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async29484 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29484 = (function (flag,meta29485){
this.flag = flag;
this.meta29485 = meta29485;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async29484.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_29486,meta29485__$1){
var self__ = this;
var _29486__$1 = this;
return (new cljs.core.async.t_cljs$core$async29484(self__.flag,meta29485__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async29484.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_29486){
var self__ = this;
var _29486__$1 = this;
return self__.meta29485;
});})(flag))
;

cljs.core.async.t_cljs$core$async29484.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async29484.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async29484.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async29484.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async29484.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta29485","meta29485",-153505457,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async29484.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async29484.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29484";

cljs.core.async.t_cljs$core$async29484.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__27348__auto__,writer__27349__auto__,opt__27350__auto__){
return cljs.core._write.call(null,writer__27349__auto__,"cljs.core.async/t_cljs$core$async29484");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async29484 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async29484(flag__$1,meta29485){
return (new cljs.core.async.t_cljs$core$async29484(flag__$1,meta29485));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async29484(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async29490 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29490 = (function (flag,cb,meta29491){
this.flag = flag;
this.cb = cb;
this.meta29491 = meta29491;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async29490.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29492,meta29491__$1){
var self__ = this;
var _29492__$1 = this;
return (new cljs.core.async.t_cljs$core$async29490(self__.flag,self__.cb,meta29491__$1));
});

cljs.core.async.t_cljs$core$async29490.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29492){
var self__ = this;
var _29492__$1 = this;
return self__.meta29491;
});

cljs.core.async.t_cljs$core$async29490.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async29490.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async29490.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async29490.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async29490.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta29491","meta29491",-1796655709,null)], null);
});

cljs.core.async.t_cljs$core$async29490.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async29490.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29490";

cljs.core.async.t_cljs$core$async29490.cljs$lang$ctorPrWriter = (function (this__27348__auto__,writer__27349__auto__,opt__27350__auto__){
return cljs.core._write.call(null,writer__27349__auto__,"cljs.core.async/t_cljs$core$async29490");
});

cljs.core.async.__GT_t_cljs$core$async29490 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async29490(flag__$1,cb__$1,meta29491){
return (new cljs.core.async.t_cljs$core$async29490(flag__$1,cb__$1,meta29491));
});

}

return (new cljs.core.async.t_cljs$core$async29490(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__29493_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__29493_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__29494_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__29494_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__26696__auto__ = wport;
if(cljs.core.truth_(or__26696__auto__)){
return or__26696__auto__;
} else {
return port;
}
})()], null));
} else {
var G__29495 = (i + (1));
i = G__29495;
continue;
}
} else {
return null;
}
break;
}
})();
var or__26696__auto__ = ret;
if(cljs.core.truth_(or__26696__auto__)){
return or__26696__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__6753__auto__ = (function (){var and__26684__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__26684__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__26684__auto__;
}
})();
if(cljs.core.truth_(temp__6753__auto__)){
var got = temp__6753__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__27919__auto__ = [];
var len__27912__auto___29501 = arguments.length;
var i__27913__auto___29502 = (0);
while(true){
if((i__27913__auto___29502 < len__27912__auto___29501)){
args__27919__auto__.push((arguments[i__27913__auto___29502]));

var G__29503 = (i__27913__auto___29502 + (1));
i__27913__auto___29502 = G__29503;
continue;
} else {
}
break;
}

var argseq__27920__auto__ = ((((1) < args__27919__auto__.length))?(new cljs.core.IndexedSeq(args__27919__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__27920__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__29498){
var map__29499 = p__29498;
var map__29499__$1 = ((((!((map__29499 == null)))?((((map__29499.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29499.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__29499):map__29499);
var opts = map__29499__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq29496){
var G__29497 = cljs.core.first.call(null,seq29496);
var seq29496__$1 = cljs.core.next.call(null,seq29496);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29497,seq29496__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args29504 = [];
var len__27912__auto___29554 = arguments.length;
var i__27913__auto___29555 = (0);
while(true){
if((i__27913__auto___29555 < len__27912__auto___29554)){
args29504.push((arguments[i__27913__auto___29555]));

var G__29556 = (i__27913__auto___29555 + (1));
i__27913__auto___29555 = G__29556;
continue;
} else {
}
break;
}

var G__29506 = args29504.length;
switch (G__29506) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29504.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__29377__auto___29558 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29377__auto___29558){
return (function (){
var f__29378__auto__ = (function (){var switch__29263__auto__ = ((function (c__29377__auto___29558){
return (function (state_29530){
var state_val_29531 = (state_29530[(1)]);
if((state_val_29531 === (7))){
var inst_29526 = (state_29530[(2)]);
var state_29530__$1 = state_29530;
var statearr_29532_29559 = state_29530__$1;
(statearr_29532_29559[(2)] = inst_29526);

(statearr_29532_29559[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (1))){
var state_29530__$1 = state_29530;
var statearr_29533_29560 = state_29530__$1;
(statearr_29533_29560[(2)] = null);

(statearr_29533_29560[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (4))){
var inst_29509 = (state_29530[(7)]);
var inst_29509__$1 = (state_29530[(2)]);
var inst_29510 = (inst_29509__$1 == null);
var state_29530__$1 = (function (){var statearr_29534 = state_29530;
(statearr_29534[(7)] = inst_29509__$1);

return statearr_29534;
})();
if(cljs.core.truth_(inst_29510)){
var statearr_29535_29561 = state_29530__$1;
(statearr_29535_29561[(1)] = (5));

} else {
var statearr_29536_29562 = state_29530__$1;
(statearr_29536_29562[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (13))){
var state_29530__$1 = state_29530;
var statearr_29537_29563 = state_29530__$1;
(statearr_29537_29563[(2)] = null);

(statearr_29537_29563[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (6))){
var inst_29509 = (state_29530[(7)]);
var state_29530__$1 = state_29530;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29530__$1,(11),to,inst_29509);
} else {
if((state_val_29531 === (3))){
var inst_29528 = (state_29530[(2)]);
var state_29530__$1 = state_29530;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29530__$1,inst_29528);
} else {
if((state_val_29531 === (12))){
var state_29530__$1 = state_29530;
var statearr_29538_29564 = state_29530__$1;
(statearr_29538_29564[(2)] = null);

(statearr_29538_29564[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (2))){
var state_29530__$1 = state_29530;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29530__$1,(4),from);
} else {
if((state_val_29531 === (11))){
var inst_29519 = (state_29530[(2)]);
var state_29530__$1 = state_29530;
if(cljs.core.truth_(inst_29519)){
var statearr_29539_29565 = state_29530__$1;
(statearr_29539_29565[(1)] = (12));

} else {
var statearr_29540_29566 = state_29530__$1;
(statearr_29540_29566[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (9))){
var state_29530__$1 = state_29530;
var statearr_29541_29567 = state_29530__$1;
(statearr_29541_29567[(2)] = null);

(statearr_29541_29567[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (5))){
var state_29530__$1 = state_29530;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29542_29568 = state_29530__$1;
(statearr_29542_29568[(1)] = (8));

} else {
var statearr_29543_29569 = state_29530__$1;
(statearr_29543_29569[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (14))){
var inst_29524 = (state_29530[(2)]);
var state_29530__$1 = state_29530;
var statearr_29544_29570 = state_29530__$1;
(statearr_29544_29570[(2)] = inst_29524);

(statearr_29544_29570[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (10))){
var inst_29516 = (state_29530[(2)]);
var state_29530__$1 = state_29530;
var statearr_29545_29571 = state_29530__$1;
(statearr_29545_29571[(2)] = inst_29516);

(statearr_29545_29571[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (8))){
var inst_29513 = cljs.core.async.close_BANG_.call(null,to);
var state_29530__$1 = state_29530;
var statearr_29546_29572 = state_29530__$1;
(statearr_29546_29572[(2)] = inst_29513);

(statearr_29546_29572[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29377__auto___29558))
;
return ((function (switch__29263__auto__,c__29377__auto___29558){
return (function() {
var cljs$core$async$state_machine__29264__auto__ = null;
var cljs$core$async$state_machine__29264__auto____0 = (function (){
var statearr_29550 = [null,null,null,null,null,null,null,null];
(statearr_29550[(0)] = cljs$core$async$state_machine__29264__auto__);

(statearr_29550[(1)] = (1));

return statearr_29550;
});
var cljs$core$async$state_machine__29264__auto____1 = (function (state_29530){
while(true){
var ret_value__29265__auto__ = (function (){try{while(true){
var result__29266__auto__ = switch__29263__auto__.call(null,state_29530);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29266__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29266__auto__;
}
break;
}
}catch (e29551){if((e29551 instanceof Object)){
var ex__29267__auto__ = e29551;
var statearr_29552_29573 = state_29530;
(statearr_29552_29573[(5)] = ex__29267__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29530);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29551;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29265__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29574 = state_29530;
state_29530 = G__29574;
continue;
} else {
return ret_value__29265__auto__;
}
break;
}
});
cljs$core$async$state_machine__29264__auto__ = function(state_29530){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29264__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29264__auto____1.call(this,state_29530);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29264__auto____0;
cljs$core$async$state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29264__auto____1;
return cljs$core$async$state_machine__29264__auto__;
})()
;})(switch__29263__auto__,c__29377__auto___29558))
})();
var state__29379__auto__ = (function (){var statearr_29553 = f__29378__auto__.call(null);
(statearr_29553[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29377__auto___29558);

return statearr_29553;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29379__auto__);
});})(c__29377__auto___29558))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__29762){
var vec__29763 = p__29762;
var v = cljs.core.nth.call(null,vec__29763,(0),null);
var p = cljs.core.nth.call(null,vec__29763,(1),null);
var job = vec__29763;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__29377__auto___29949 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29377__auto___29949,res,vec__29763,v,p,job,jobs,results){
return (function (){
var f__29378__auto__ = (function (){var switch__29263__auto__ = ((function (c__29377__auto___29949,res,vec__29763,v,p,job,jobs,results){
return (function (state_29770){
var state_val_29771 = (state_29770[(1)]);
if((state_val_29771 === (1))){
var state_29770__$1 = state_29770;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29770__$1,(2),res,v);
} else {
if((state_val_29771 === (2))){
var inst_29767 = (state_29770[(2)]);
var inst_29768 = cljs.core.async.close_BANG_.call(null,res);
var state_29770__$1 = (function (){var statearr_29772 = state_29770;
(statearr_29772[(7)] = inst_29767);

return statearr_29772;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29770__$1,inst_29768);
} else {
return null;
}
}
});})(c__29377__auto___29949,res,vec__29763,v,p,job,jobs,results))
;
return ((function (switch__29263__auto__,c__29377__auto___29949,res,vec__29763,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29264__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29264__auto____0 = (function (){
var statearr_29776 = [null,null,null,null,null,null,null,null];
(statearr_29776[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29264__auto__);

(statearr_29776[(1)] = (1));

return statearr_29776;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29264__auto____1 = (function (state_29770){
while(true){
var ret_value__29265__auto__ = (function (){try{while(true){
var result__29266__auto__ = switch__29263__auto__.call(null,state_29770);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29266__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29266__auto__;
}
break;
}
}catch (e29777){if((e29777 instanceof Object)){
var ex__29267__auto__ = e29777;
var statearr_29778_29950 = state_29770;
(statearr_29778_29950[(5)] = ex__29267__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29770);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29777;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29265__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29951 = state_29770;
state_29770 = G__29951;
continue;
} else {
return ret_value__29265__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29264__auto__ = function(state_29770){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29264__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29264__auto____1.call(this,state_29770);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29264__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29264__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29264__auto__;
})()
;})(switch__29263__auto__,c__29377__auto___29949,res,vec__29763,v,p,job,jobs,results))
})();
var state__29379__auto__ = (function (){var statearr_29779 = f__29378__auto__.call(null);
(statearr_29779[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29377__auto___29949);

return statearr_29779;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29379__auto__);
});})(c__29377__auto___29949,res,vec__29763,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__29780){
var vec__29781 = p__29780;
var v = cljs.core.nth.call(null,vec__29781,(0),null);
var p = cljs.core.nth.call(null,vec__29781,(1),null);
var job = vec__29781;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__27712__auto___29952 = n;
var __29953 = (0);
while(true){
if((__29953 < n__27712__auto___29952)){
var G__29784_29954 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__29784_29954) {
case "compute":
var c__29377__auto___29956 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__29953,c__29377__auto___29956,G__29784_29954,n__27712__auto___29952,jobs,results,process,async){
return (function (){
var f__29378__auto__ = (function (){var switch__29263__auto__ = ((function (__29953,c__29377__auto___29956,G__29784_29954,n__27712__auto___29952,jobs,results,process,async){
return (function (state_29797){
var state_val_29798 = (state_29797[(1)]);
if((state_val_29798 === (1))){
var state_29797__$1 = state_29797;
var statearr_29799_29957 = state_29797__$1;
(statearr_29799_29957[(2)] = null);

(statearr_29799_29957[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29798 === (2))){
var state_29797__$1 = state_29797;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29797__$1,(4),jobs);
} else {
if((state_val_29798 === (3))){
var inst_29795 = (state_29797[(2)]);
var state_29797__$1 = state_29797;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29797__$1,inst_29795);
} else {
if((state_val_29798 === (4))){
var inst_29787 = (state_29797[(2)]);
var inst_29788 = process.call(null,inst_29787);
var state_29797__$1 = state_29797;
if(cljs.core.truth_(inst_29788)){
var statearr_29800_29958 = state_29797__$1;
(statearr_29800_29958[(1)] = (5));

} else {
var statearr_29801_29959 = state_29797__$1;
(statearr_29801_29959[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29798 === (5))){
var state_29797__$1 = state_29797;
var statearr_29802_29960 = state_29797__$1;
(statearr_29802_29960[(2)] = null);

(statearr_29802_29960[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29798 === (6))){
var state_29797__$1 = state_29797;
var statearr_29803_29961 = state_29797__$1;
(statearr_29803_29961[(2)] = null);

(statearr_29803_29961[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29798 === (7))){
var inst_29793 = (state_29797[(2)]);
var state_29797__$1 = state_29797;
var statearr_29804_29962 = state_29797__$1;
(statearr_29804_29962[(2)] = inst_29793);

(statearr_29804_29962[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__29953,c__29377__auto___29956,G__29784_29954,n__27712__auto___29952,jobs,results,process,async))
;
return ((function (__29953,switch__29263__auto__,c__29377__auto___29956,G__29784_29954,n__27712__auto___29952,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29264__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29264__auto____0 = (function (){
var statearr_29808 = [null,null,null,null,null,null,null];
(statearr_29808[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29264__auto__);

(statearr_29808[(1)] = (1));

return statearr_29808;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29264__auto____1 = (function (state_29797){
while(true){
var ret_value__29265__auto__ = (function (){try{while(true){
var result__29266__auto__ = switch__29263__auto__.call(null,state_29797);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29266__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29266__auto__;
}
break;
}
}catch (e29809){if((e29809 instanceof Object)){
var ex__29267__auto__ = e29809;
var statearr_29810_29963 = state_29797;
(statearr_29810_29963[(5)] = ex__29267__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29797);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29809;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29265__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29964 = state_29797;
state_29797 = G__29964;
continue;
} else {
return ret_value__29265__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29264__auto__ = function(state_29797){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29264__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29264__auto____1.call(this,state_29797);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29264__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29264__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29264__auto__;
})()
;})(__29953,switch__29263__auto__,c__29377__auto___29956,G__29784_29954,n__27712__auto___29952,jobs,results,process,async))
})();
var state__29379__auto__ = (function (){var statearr_29811 = f__29378__auto__.call(null);
(statearr_29811[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29377__auto___29956);

return statearr_29811;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29379__auto__);
});})(__29953,c__29377__auto___29956,G__29784_29954,n__27712__auto___29952,jobs,results,process,async))
);


break;
case "async":
var c__29377__auto___29965 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__29953,c__29377__auto___29965,G__29784_29954,n__27712__auto___29952,jobs,results,process,async){
return (function (){
var f__29378__auto__ = (function (){var switch__29263__auto__ = ((function (__29953,c__29377__auto___29965,G__29784_29954,n__27712__auto___29952,jobs,results,process,async){
return (function (state_29824){
var state_val_29825 = (state_29824[(1)]);
if((state_val_29825 === (1))){
var state_29824__$1 = state_29824;
var statearr_29826_29966 = state_29824__$1;
(statearr_29826_29966[(2)] = null);

(statearr_29826_29966[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29825 === (2))){
var state_29824__$1 = state_29824;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29824__$1,(4),jobs);
} else {
if((state_val_29825 === (3))){
var inst_29822 = (state_29824[(2)]);
var state_29824__$1 = state_29824;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29824__$1,inst_29822);
} else {
if((state_val_29825 === (4))){
var inst_29814 = (state_29824[(2)]);
var inst_29815 = async.call(null,inst_29814);
var state_29824__$1 = state_29824;
if(cljs.core.truth_(inst_29815)){
var statearr_29827_29967 = state_29824__$1;
(statearr_29827_29967[(1)] = (5));

} else {
var statearr_29828_29968 = state_29824__$1;
(statearr_29828_29968[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29825 === (5))){
var state_29824__$1 = state_29824;
var statearr_29829_29969 = state_29824__$1;
(statearr_29829_29969[(2)] = null);

(statearr_29829_29969[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29825 === (6))){
var state_29824__$1 = state_29824;
var statearr_29830_29970 = state_29824__$1;
(statearr_29830_29970[(2)] = null);

(statearr_29830_29970[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29825 === (7))){
var inst_29820 = (state_29824[(2)]);
var state_29824__$1 = state_29824;
var statearr_29831_29971 = state_29824__$1;
(statearr_29831_29971[(2)] = inst_29820);

(statearr_29831_29971[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__29953,c__29377__auto___29965,G__29784_29954,n__27712__auto___29952,jobs,results,process,async))
;
return ((function (__29953,switch__29263__auto__,c__29377__auto___29965,G__29784_29954,n__27712__auto___29952,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29264__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29264__auto____0 = (function (){
var statearr_29835 = [null,null,null,null,null,null,null];
(statearr_29835[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29264__auto__);

(statearr_29835[(1)] = (1));

return statearr_29835;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29264__auto____1 = (function (state_29824){
while(true){
var ret_value__29265__auto__ = (function (){try{while(true){
var result__29266__auto__ = switch__29263__auto__.call(null,state_29824);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29266__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29266__auto__;
}
break;
}
}catch (e29836){if((e29836 instanceof Object)){
var ex__29267__auto__ = e29836;
var statearr_29837_29972 = state_29824;
(statearr_29837_29972[(5)] = ex__29267__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29824);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29836;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29265__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29973 = state_29824;
state_29824 = G__29973;
continue;
} else {
return ret_value__29265__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29264__auto__ = function(state_29824){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29264__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29264__auto____1.call(this,state_29824);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29264__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29264__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29264__auto__;
})()
;})(__29953,switch__29263__auto__,c__29377__auto___29965,G__29784_29954,n__27712__auto___29952,jobs,results,process,async))
})();
var state__29379__auto__ = (function (){var statearr_29838 = f__29378__auto__.call(null);
(statearr_29838[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29377__auto___29965);

return statearr_29838;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29379__auto__);
});})(__29953,c__29377__auto___29965,G__29784_29954,n__27712__auto___29952,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__29974 = (__29953 + (1));
__29953 = G__29974;
continue;
} else {
}
break;
}

var c__29377__auto___29975 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29377__auto___29975,jobs,results,process,async){
return (function (){
var f__29378__auto__ = (function (){var switch__29263__auto__ = ((function (c__29377__auto___29975,jobs,results,process,async){
return (function (state_29860){
var state_val_29861 = (state_29860[(1)]);
if((state_val_29861 === (1))){
var state_29860__$1 = state_29860;
var statearr_29862_29976 = state_29860__$1;
(statearr_29862_29976[(2)] = null);

(statearr_29862_29976[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29861 === (2))){
var state_29860__$1 = state_29860;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29860__$1,(4),from);
} else {
if((state_val_29861 === (3))){
var inst_29858 = (state_29860[(2)]);
var state_29860__$1 = state_29860;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29860__$1,inst_29858);
} else {
if((state_val_29861 === (4))){
var inst_29841 = (state_29860[(7)]);
var inst_29841__$1 = (state_29860[(2)]);
var inst_29842 = (inst_29841__$1 == null);
var state_29860__$1 = (function (){var statearr_29863 = state_29860;
(statearr_29863[(7)] = inst_29841__$1);

return statearr_29863;
})();
if(cljs.core.truth_(inst_29842)){
var statearr_29864_29977 = state_29860__$1;
(statearr_29864_29977[(1)] = (5));

} else {
var statearr_29865_29978 = state_29860__$1;
(statearr_29865_29978[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29861 === (5))){
var inst_29844 = cljs.core.async.close_BANG_.call(null,jobs);
var state_29860__$1 = state_29860;
var statearr_29866_29979 = state_29860__$1;
(statearr_29866_29979[(2)] = inst_29844);

(statearr_29866_29979[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29861 === (6))){
var inst_29841 = (state_29860[(7)]);
var inst_29846 = (state_29860[(8)]);
var inst_29846__$1 = cljs.core.async.chan.call(null,(1));
var inst_29847 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29848 = [inst_29841,inst_29846__$1];
var inst_29849 = (new cljs.core.PersistentVector(null,2,(5),inst_29847,inst_29848,null));
var state_29860__$1 = (function (){var statearr_29867 = state_29860;
(statearr_29867[(8)] = inst_29846__$1);

return statearr_29867;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29860__$1,(8),jobs,inst_29849);
} else {
if((state_val_29861 === (7))){
var inst_29856 = (state_29860[(2)]);
var state_29860__$1 = state_29860;
var statearr_29868_29980 = state_29860__$1;
(statearr_29868_29980[(2)] = inst_29856);

(statearr_29868_29980[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29861 === (8))){
var inst_29846 = (state_29860[(8)]);
var inst_29851 = (state_29860[(2)]);
var state_29860__$1 = (function (){var statearr_29869 = state_29860;
(statearr_29869[(9)] = inst_29851);

return statearr_29869;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29860__$1,(9),results,inst_29846);
} else {
if((state_val_29861 === (9))){
var inst_29853 = (state_29860[(2)]);
var state_29860__$1 = (function (){var statearr_29870 = state_29860;
(statearr_29870[(10)] = inst_29853);

return statearr_29870;
})();
var statearr_29871_29981 = state_29860__$1;
(statearr_29871_29981[(2)] = null);

(statearr_29871_29981[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__29377__auto___29975,jobs,results,process,async))
;
return ((function (switch__29263__auto__,c__29377__auto___29975,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29264__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29264__auto____0 = (function (){
var statearr_29875 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29875[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29264__auto__);

(statearr_29875[(1)] = (1));

return statearr_29875;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29264__auto____1 = (function (state_29860){
while(true){
var ret_value__29265__auto__ = (function (){try{while(true){
var result__29266__auto__ = switch__29263__auto__.call(null,state_29860);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29266__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29266__auto__;
}
break;
}
}catch (e29876){if((e29876 instanceof Object)){
var ex__29267__auto__ = e29876;
var statearr_29877_29982 = state_29860;
(statearr_29877_29982[(5)] = ex__29267__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29860);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29876;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29265__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29983 = state_29860;
state_29860 = G__29983;
continue;
} else {
return ret_value__29265__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29264__auto__ = function(state_29860){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29264__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29264__auto____1.call(this,state_29860);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29264__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29264__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29264__auto__;
})()
;})(switch__29263__auto__,c__29377__auto___29975,jobs,results,process,async))
})();
var state__29379__auto__ = (function (){var statearr_29878 = f__29378__auto__.call(null);
(statearr_29878[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29377__auto___29975);

return statearr_29878;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29379__auto__);
});})(c__29377__auto___29975,jobs,results,process,async))
);


var c__29377__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29377__auto__,jobs,results,process,async){
return (function (){
var f__29378__auto__ = (function (){var switch__29263__auto__ = ((function (c__29377__auto__,jobs,results,process,async){
return (function (state_29916){
var state_val_29917 = (state_29916[(1)]);
if((state_val_29917 === (7))){
var inst_29912 = (state_29916[(2)]);
var state_29916__$1 = state_29916;
var statearr_29918_29984 = state_29916__$1;
(statearr_29918_29984[(2)] = inst_29912);

(statearr_29918_29984[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29917 === (20))){
var state_29916__$1 = state_29916;
var statearr_29919_29985 = state_29916__$1;
(statearr_29919_29985[(2)] = null);

(statearr_29919_29985[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29917 === (1))){
var state_29916__$1 = state_29916;
var statearr_29920_29986 = state_29916__$1;
(statearr_29920_29986[(2)] = null);

(statearr_29920_29986[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29917 === (4))){
var inst_29881 = (state_29916[(7)]);
var inst_29881__$1 = (state_29916[(2)]);
var inst_29882 = (inst_29881__$1 == null);
var state_29916__$1 = (function (){var statearr_29921 = state_29916;
(statearr_29921[(7)] = inst_29881__$1);

return statearr_29921;
})();
if(cljs.core.truth_(inst_29882)){
var statearr_29922_29987 = state_29916__$1;
(statearr_29922_29987[(1)] = (5));

} else {
var statearr_29923_29988 = state_29916__$1;
(statearr_29923_29988[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29917 === (15))){
var inst_29894 = (state_29916[(8)]);
var state_29916__$1 = state_29916;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29916__$1,(18),to,inst_29894);
} else {
if((state_val_29917 === (21))){
var inst_29907 = (state_29916[(2)]);
var state_29916__$1 = state_29916;
var statearr_29924_29989 = state_29916__$1;
(statearr_29924_29989[(2)] = inst_29907);

(statearr_29924_29989[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29917 === (13))){
var inst_29909 = (state_29916[(2)]);
var state_29916__$1 = (function (){var statearr_29925 = state_29916;
(statearr_29925[(9)] = inst_29909);

return statearr_29925;
})();
var statearr_29926_29990 = state_29916__$1;
(statearr_29926_29990[(2)] = null);

(statearr_29926_29990[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29917 === (6))){
var inst_29881 = (state_29916[(7)]);
var state_29916__$1 = state_29916;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29916__$1,(11),inst_29881);
} else {
if((state_val_29917 === (17))){
var inst_29902 = (state_29916[(2)]);
var state_29916__$1 = state_29916;
if(cljs.core.truth_(inst_29902)){
var statearr_29927_29991 = state_29916__$1;
(statearr_29927_29991[(1)] = (19));

} else {
var statearr_29928_29992 = state_29916__$1;
(statearr_29928_29992[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29917 === (3))){
var inst_29914 = (state_29916[(2)]);
var state_29916__$1 = state_29916;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29916__$1,inst_29914);
} else {
if((state_val_29917 === (12))){
var inst_29891 = (state_29916[(10)]);
var state_29916__$1 = state_29916;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29916__$1,(14),inst_29891);
} else {
if((state_val_29917 === (2))){
var state_29916__$1 = state_29916;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29916__$1,(4),results);
} else {
if((state_val_29917 === (19))){
var state_29916__$1 = state_29916;
var statearr_29929_29993 = state_29916__$1;
(statearr_29929_29993[(2)] = null);

(statearr_29929_29993[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29917 === (11))){
var inst_29891 = (state_29916[(2)]);
var state_29916__$1 = (function (){var statearr_29930 = state_29916;
(statearr_29930[(10)] = inst_29891);

return statearr_29930;
})();
var statearr_29931_29994 = state_29916__$1;
(statearr_29931_29994[(2)] = null);

(statearr_29931_29994[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29917 === (9))){
var state_29916__$1 = state_29916;
var statearr_29932_29995 = state_29916__$1;
(statearr_29932_29995[(2)] = null);

(statearr_29932_29995[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29917 === (5))){
var state_29916__$1 = state_29916;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29933_29996 = state_29916__$1;
(statearr_29933_29996[(1)] = (8));

} else {
var statearr_29934_29997 = state_29916__$1;
(statearr_29934_29997[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29917 === (14))){
var inst_29896 = (state_29916[(11)]);
var inst_29894 = (state_29916[(8)]);
var inst_29894__$1 = (state_29916[(2)]);
var inst_29895 = (inst_29894__$1 == null);
var inst_29896__$1 = cljs.core.not.call(null,inst_29895);
var state_29916__$1 = (function (){var statearr_29935 = state_29916;
(statearr_29935[(11)] = inst_29896__$1);

(statearr_29935[(8)] = inst_29894__$1);

return statearr_29935;
})();
if(inst_29896__$1){
var statearr_29936_29998 = state_29916__$1;
(statearr_29936_29998[(1)] = (15));

} else {
var statearr_29937_29999 = state_29916__$1;
(statearr_29937_29999[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29917 === (16))){
var inst_29896 = (state_29916[(11)]);
var state_29916__$1 = state_29916;
var statearr_29938_30000 = state_29916__$1;
(statearr_29938_30000[(2)] = inst_29896);

(statearr_29938_30000[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29917 === (10))){
var inst_29888 = (state_29916[(2)]);
var state_29916__$1 = state_29916;
var statearr_29939_30001 = state_29916__$1;
(statearr_29939_30001[(2)] = inst_29888);

(statearr_29939_30001[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29917 === (18))){
var inst_29899 = (state_29916[(2)]);
var state_29916__$1 = state_29916;
var statearr_29940_30002 = state_29916__$1;
(statearr_29940_30002[(2)] = inst_29899);

(statearr_29940_30002[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29917 === (8))){
var inst_29885 = cljs.core.async.close_BANG_.call(null,to);
var state_29916__$1 = state_29916;
var statearr_29941_30003 = state_29916__$1;
(statearr_29941_30003[(2)] = inst_29885);

(statearr_29941_30003[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29377__auto__,jobs,results,process,async))
;
return ((function (switch__29263__auto__,c__29377__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29264__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29264__auto____0 = (function (){
var statearr_29945 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29945[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29264__auto__);

(statearr_29945[(1)] = (1));

return statearr_29945;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29264__auto____1 = (function (state_29916){
while(true){
var ret_value__29265__auto__ = (function (){try{while(true){
var result__29266__auto__ = switch__29263__auto__.call(null,state_29916);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29266__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29266__auto__;
}
break;
}
}catch (e29946){if((e29946 instanceof Object)){
var ex__29267__auto__ = e29946;
var statearr_29947_30004 = state_29916;
(statearr_29947_30004[(5)] = ex__29267__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29916);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29946;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29265__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30005 = state_29916;
state_29916 = G__30005;
continue;
} else {
return ret_value__29265__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29264__auto__ = function(state_29916){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29264__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29264__auto____1.call(this,state_29916);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29264__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29264__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29264__auto__;
})()
;})(switch__29263__auto__,c__29377__auto__,jobs,results,process,async))
})();
var state__29379__auto__ = (function (){var statearr_29948 = f__29378__auto__.call(null);
(statearr_29948[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29377__auto__);

return statearr_29948;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29379__auto__);
});})(c__29377__auto__,jobs,results,process,async))
);

return c__29377__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args30006 = [];
var len__27912__auto___30009 = arguments.length;
var i__27913__auto___30010 = (0);
while(true){
if((i__27913__auto___30010 < len__27912__auto___30009)){
args30006.push((arguments[i__27913__auto___30010]));

var G__30011 = (i__27913__auto___30010 + (1));
i__27913__auto___30010 = G__30011;
continue;
} else {
}
break;
}

var G__30008 = args30006.length;
switch (G__30008) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30006.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args30013 = [];
var len__27912__auto___30016 = arguments.length;
var i__27913__auto___30017 = (0);
while(true){
if((i__27913__auto___30017 < len__27912__auto___30016)){
args30013.push((arguments[i__27913__auto___30017]));

var G__30018 = (i__27913__auto___30017 + (1));
i__27913__auto___30017 = G__30018;
continue;
} else {
}
break;
}

var G__30015 = args30013.length;
switch (G__30015) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30013.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args30020 = [];
var len__27912__auto___30073 = arguments.length;
var i__27913__auto___30074 = (0);
while(true){
if((i__27913__auto___30074 < len__27912__auto___30073)){
args30020.push((arguments[i__27913__auto___30074]));

var G__30075 = (i__27913__auto___30074 + (1));
i__27913__auto___30074 = G__30075;
continue;
} else {
}
break;
}

var G__30022 = args30020.length;
switch (G__30022) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30020.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__29377__auto___30077 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29377__auto___30077,tc,fc){
return (function (){
var f__29378__auto__ = (function (){var switch__29263__auto__ = ((function (c__29377__auto___30077,tc,fc){
return (function (state_30048){
var state_val_30049 = (state_30048[(1)]);
if((state_val_30049 === (7))){
var inst_30044 = (state_30048[(2)]);
var state_30048__$1 = state_30048;
var statearr_30050_30078 = state_30048__$1;
(statearr_30050_30078[(2)] = inst_30044);

(statearr_30050_30078[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30049 === (1))){
var state_30048__$1 = state_30048;
var statearr_30051_30079 = state_30048__$1;
(statearr_30051_30079[(2)] = null);

(statearr_30051_30079[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30049 === (4))){
var inst_30025 = (state_30048[(7)]);
var inst_30025__$1 = (state_30048[(2)]);
var inst_30026 = (inst_30025__$1 == null);
var state_30048__$1 = (function (){var statearr_30052 = state_30048;
(statearr_30052[(7)] = inst_30025__$1);

return statearr_30052;
})();
if(cljs.core.truth_(inst_30026)){
var statearr_30053_30080 = state_30048__$1;
(statearr_30053_30080[(1)] = (5));

} else {
var statearr_30054_30081 = state_30048__$1;
(statearr_30054_30081[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30049 === (13))){
var state_30048__$1 = state_30048;
var statearr_30055_30082 = state_30048__$1;
(statearr_30055_30082[(2)] = null);

(statearr_30055_30082[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30049 === (6))){
var inst_30025 = (state_30048[(7)]);
var inst_30031 = p.call(null,inst_30025);
var state_30048__$1 = state_30048;
if(cljs.core.truth_(inst_30031)){
var statearr_30056_30083 = state_30048__$1;
(statearr_30056_30083[(1)] = (9));

} else {
var statearr_30057_30084 = state_30048__$1;
(statearr_30057_30084[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30049 === (3))){
var inst_30046 = (state_30048[(2)]);
var state_30048__$1 = state_30048;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30048__$1,inst_30046);
} else {
if((state_val_30049 === (12))){
var state_30048__$1 = state_30048;
var statearr_30058_30085 = state_30048__$1;
(statearr_30058_30085[(2)] = null);

(statearr_30058_30085[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30049 === (2))){
var state_30048__$1 = state_30048;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30048__$1,(4),ch);
} else {
if((state_val_30049 === (11))){
var inst_30025 = (state_30048[(7)]);
var inst_30035 = (state_30048[(2)]);
var state_30048__$1 = state_30048;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30048__$1,(8),inst_30035,inst_30025);
} else {
if((state_val_30049 === (9))){
var state_30048__$1 = state_30048;
var statearr_30059_30086 = state_30048__$1;
(statearr_30059_30086[(2)] = tc);

(statearr_30059_30086[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30049 === (5))){
var inst_30028 = cljs.core.async.close_BANG_.call(null,tc);
var inst_30029 = cljs.core.async.close_BANG_.call(null,fc);
var state_30048__$1 = (function (){var statearr_30060 = state_30048;
(statearr_30060[(8)] = inst_30028);

return statearr_30060;
})();
var statearr_30061_30087 = state_30048__$1;
(statearr_30061_30087[(2)] = inst_30029);

(statearr_30061_30087[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30049 === (14))){
var inst_30042 = (state_30048[(2)]);
var state_30048__$1 = state_30048;
var statearr_30062_30088 = state_30048__$1;
(statearr_30062_30088[(2)] = inst_30042);

(statearr_30062_30088[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30049 === (10))){
var state_30048__$1 = state_30048;
var statearr_30063_30089 = state_30048__$1;
(statearr_30063_30089[(2)] = fc);

(statearr_30063_30089[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30049 === (8))){
var inst_30037 = (state_30048[(2)]);
var state_30048__$1 = state_30048;
if(cljs.core.truth_(inst_30037)){
var statearr_30064_30090 = state_30048__$1;
(statearr_30064_30090[(1)] = (12));

} else {
var statearr_30065_30091 = state_30048__$1;
(statearr_30065_30091[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29377__auto___30077,tc,fc))
;
return ((function (switch__29263__auto__,c__29377__auto___30077,tc,fc){
return (function() {
var cljs$core$async$state_machine__29264__auto__ = null;
var cljs$core$async$state_machine__29264__auto____0 = (function (){
var statearr_30069 = [null,null,null,null,null,null,null,null,null];
(statearr_30069[(0)] = cljs$core$async$state_machine__29264__auto__);

(statearr_30069[(1)] = (1));

return statearr_30069;
});
var cljs$core$async$state_machine__29264__auto____1 = (function (state_30048){
while(true){
var ret_value__29265__auto__ = (function (){try{while(true){
var result__29266__auto__ = switch__29263__auto__.call(null,state_30048);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29266__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29266__auto__;
}
break;
}
}catch (e30070){if((e30070 instanceof Object)){
var ex__29267__auto__ = e30070;
var statearr_30071_30092 = state_30048;
(statearr_30071_30092[(5)] = ex__29267__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30048);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30070;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29265__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30093 = state_30048;
state_30048 = G__30093;
continue;
} else {
return ret_value__29265__auto__;
}
break;
}
});
cljs$core$async$state_machine__29264__auto__ = function(state_30048){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29264__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29264__auto____1.call(this,state_30048);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29264__auto____0;
cljs$core$async$state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29264__auto____1;
return cljs$core$async$state_machine__29264__auto__;
})()
;})(switch__29263__auto__,c__29377__auto___30077,tc,fc))
})();
var state__29379__auto__ = (function (){var statearr_30072 = f__29378__auto__.call(null);
(statearr_30072[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29377__auto___30077);

return statearr_30072;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29379__auto__);
});})(c__29377__auto___30077,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__29377__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29377__auto__){
return (function (){
var f__29378__auto__ = (function (){var switch__29263__auto__ = ((function (c__29377__auto__){
return (function (state_30157){
var state_val_30158 = (state_30157[(1)]);
if((state_val_30158 === (7))){
var inst_30153 = (state_30157[(2)]);
var state_30157__$1 = state_30157;
var statearr_30159_30180 = state_30157__$1;
(statearr_30159_30180[(2)] = inst_30153);

(statearr_30159_30180[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30158 === (1))){
var inst_30137 = init;
var state_30157__$1 = (function (){var statearr_30160 = state_30157;
(statearr_30160[(7)] = inst_30137);

return statearr_30160;
})();
var statearr_30161_30181 = state_30157__$1;
(statearr_30161_30181[(2)] = null);

(statearr_30161_30181[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30158 === (4))){
var inst_30140 = (state_30157[(8)]);
var inst_30140__$1 = (state_30157[(2)]);
var inst_30141 = (inst_30140__$1 == null);
var state_30157__$1 = (function (){var statearr_30162 = state_30157;
(statearr_30162[(8)] = inst_30140__$1);

return statearr_30162;
})();
if(cljs.core.truth_(inst_30141)){
var statearr_30163_30182 = state_30157__$1;
(statearr_30163_30182[(1)] = (5));

} else {
var statearr_30164_30183 = state_30157__$1;
(statearr_30164_30183[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30158 === (6))){
var inst_30144 = (state_30157[(9)]);
var inst_30137 = (state_30157[(7)]);
var inst_30140 = (state_30157[(8)]);
var inst_30144__$1 = f.call(null,inst_30137,inst_30140);
var inst_30145 = cljs.core.reduced_QMARK_.call(null,inst_30144__$1);
var state_30157__$1 = (function (){var statearr_30165 = state_30157;
(statearr_30165[(9)] = inst_30144__$1);

return statearr_30165;
})();
if(inst_30145){
var statearr_30166_30184 = state_30157__$1;
(statearr_30166_30184[(1)] = (8));

} else {
var statearr_30167_30185 = state_30157__$1;
(statearr_30167_30185[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30158 === (3))){
var inst_30155 = (state_30157[(2)]);
var state_30157__$1 = state_30157;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30157__$1,inst_30155);
} else {
if((state_val_30158 === (2))){
var state_30157__$1 = state_30157;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30157__$1,(4),ch);
} else {
if((state_val_30158 === (9))){
var inst_30144 = (state_30157[(9)]);
var inst_30137 = inst_30144;
var state_30157__$1 = (function (){var statearr_30168 = state_30157;
(statearr_30168[(7)] = inst_30137);

return statearr_30168;
})();
var statearr_30169_30186 = state_30157__$1;
(statearr_30169_30186[(2)] = null);

(statearr_30169_30186[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30158 === (5))){
var inst_30137 = (state_30157[(7)]);
var state_30157__$1 = state_30157;
var statearr_30170_30187 = state_30157__$1;
(statearr_30170_30187[(2)] = inst_30137);

(statearr_30170_30187[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30158 === (10))){
var inst_30151 = (state_30157[(2)]);
var state_30157__$1 = state_30157;
var statearr_30171_30188 = state_30157__$1;
(statearr_30171_30188[(2)] = inst_30151);

(statearr_30171_30188[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30158 === (8))){
var inst_30144 = (state_30157[(9)]);
var inst_30147 = cljs.core.deref.call(null,inst_30144);
var state_30157__$1 = state_30157;
var statearr_30172_30189 = state_30157__$1;
(statearr_30172_30189[(2)] = inst_30147);

(statearr_30172_30189[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__29377__auto__))
;
return ((function (switch__29263__auto__,c__29377__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__29264__auto__ = null;
var cljs$core$async$reduce_$_state_machine__29264__auto____0 = (function (){
var statearr_30176 = [null,null,null,null,null,null,null,null,null,null];
(statearr_30176[(0)] = cljs$core$async$reduce_$_state_machine__29264__auto__);

(statearr_30176[(1)] = (1));

return statearr_30176;
});
var cljs$core$async$reduce_$_state_machine__29264__auto____1 = (function (state_30157){
while(true){
var ret_value__29265__auto__ = (function (){try{while(true){
var result__29266__auto__ = switch__29263__auto__.call(null,state_30157);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29266__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29266__auto__;
}
break;
}
}catch (e30177){if((e30177 instanceof Object)){
var ex__29267__auto__ = e30177;
var statearr_30178_30190 = state_30157;
(statearr_30178_30190[(5)] = ex__29267__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30157);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30177;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29265__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30191 = state_30157;
state_30157 = G__30191;
continue;
} else {
return ret_value__29265__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__29264__auto__ = function(state_30157){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__29264__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__29264__auto____1.call(this,state_30157);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__29264__auto____0;
cljs$core$async$reduce_$_state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__29264__auto____1;
return cljs$core$async$reduce_$_state_machine__29264__auto__;
})()
;})(switch__29263__auto__,c__29377__auto__))
})();
var state__29379__auto__ = (function (){var statearr_30179 = f__29378__auto__.call(null);
(statearr_30179[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29377__auto__);

return statearr_30179;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29379__auto__);
});})(c__29377__auto__))
);

return c__29377__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__29377__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29377__auto__,f__$1){
return (function (){
var f__29378__auto__ = (function (){var switch__29263__auto__ = ((function (c__29377__auto__,f__$1){
return (function (state_30211){
var state_val_30212 = (state_30211[(1)]);
if((state_val_30212 === (1))){
var inst_30206 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_30211__$1 = state_30211;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30211__$1,(2),inst_30206);
} else {
if((state_val_30212 === (2))){
var inst_30208 = (state_30211[(2)]);
var inst_30209 = f__$1.call(null,inst_30208);
var state_30211__$1 = state_30211;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30211__$1,inst_30209);
} else {
return null;
}
}
});})(c__29377__auto__,f__$1))
;
return ((function (switch__29263__auto__,c__29377__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__29264__auto__ = null;
var cljs$core$async$transduce_$_state_machine__29264__auto____0 = (function (){
var statearr_30216 = [null,null,null,null,null,null,null];
(statearr_30216[(0)] = cljs$core$async$transduce_$_state_machine__29264__auto__);

(statearr_30216[(1)] = (1));

return statearr_30216;
});
var cljs$core$async$transduce_$_state_machine__29264__auto____1 = (function (state_30211){
while(true){
var ret_value__29265__auto__ = (function (){try{while(true){
var result__29266__auto__ = switch__29263__auto__.call(null,state_30211);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29266__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29266__auto__;
}
break;
}
}catch (e30217){if((e30217 instanceof Object)){
var ex__29267__auto__ = e30217;
var statearr_30218_30220 = state_30211;
(statearr_30218_30220[(5)] = ex__29267__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30211);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30217;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29265__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30221 = state_30211;
state_30211 = G__30221;
continue;
} else {
return ret_value__29265__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__29264__auto__ = function(state_30211){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__29264__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__29264__auto____1.call(this,state_30211);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__29264__auto____0;
cljs$core$async$transduce_$_state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__29264__auto____1;
return cljs$core$async$transduce_$_state_machine__29264__auto__;
})()
;})(switch__29263__auto__,c__29377__auto__,f__$1))
})();
var state__29379__auto__ = (function (){var statearr_30219 = f__29378__auto__.call(null);
(statearr_30219[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29377__auto__);

return statearr_30219;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29379__auto__);
});})(c__29377__auto__,f__$1))
);

return c__29377__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args30222 = [];
var len__27912__auto___30274 = arguments.length;
var i__27913__auto___30275 = (0);
while(true){
if((i__27913__auto___30275 < len__27912__auto___30274)){
args30222.push((arguments[i__27913__auto___30275]));

var G__30276 = (i__27913__auto___30275 + (1));
i__27913__auto___30275 = G__30276;
continue;
} else {
}
break;
}

var G__30224 = args30222.length;
switch (G__30224) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30222.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__29377__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29377__auto__){
return (function (){
var f__29378__auto__ = (function (){var switch__29263__auto__ = ((function (c__29377__auto__){
return (function (state_30249){
var state_val_30250 = (state_30249[(1)]);
if((state_val_30250 === (7))){
var inst_30231 = (state_30249[(2)]);
var state_30249__$1 = state_30249;
var statearr_30251_30278 = state_30249__$1;
(statearr_30251_30278[(2)] = inst_30231);

(statearr_30251_30278[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30250 === (1))){
var inst_30225 = cljs.core.seq.call(null,coll);
var inst_30226 = inst_30225;
var state_30249__$1 = (function (){var statearr_30252 = state_30249;
(statearr_30252[(7)] = inst_30226);

return statearr_30252;
})();
var statearr_30253_30279 = state_30249__$1;
(statearr_30253_30279[(2)] = null);

(statearr_30253_30279[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30250 === (4))){
var inst_30226 = (state_30249[(7)]);
var inst_30229 = cljs.core.first.call(null,inst_30226);
var state_30249__$1 = state_30249;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30249__$1,(7),ch,inst_30229);
} else {
if((state_val_30250 === (13))){
var inst_30243 = (state_30249[(2)]);
var state_30249__$1 = state_30249;
var statearr_30254_30280 = state_30249__$1;
(statearr_30254_30280[(2)] = inst_30243);

(statearr_30254_30280[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30250 === (6))){
var inst_30234 = (state_30249[(2)]);
var state_30249__$1 = state_30249;
if(cljs.core.truth_(inst_30234)){
var statearr_30255_30281 = state_30249__$1;
(statearr_30255_30281[(1)] = (8));

} else {
var statearr_30256_30282 = state_30249__$1;
(statearr_30256_30282[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30250 === (3))){
var inst_30247 = (state_30249[(2)]);
var state_30249__$1 = state_30249;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30249__$1,inst_30247);
} else {
if((state_val_30250 === (12))){
var state_30249__$1 = state_30249;
var statearr_30257_30283 = state_30249__$1;
(statearr_30257_30283[(2)] = null);

(statearr_30257_30283[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30250 === (2))){
var inst_30226 = (state_30249[(7)]);
var state_30249__$1 = state_30249;
if(cljs.core.truth_(inst_30226)){
var statearr_30258_30284 = state_30249__$1;
(statearr_30258_30284[(1)] = (4));

} else {
var statearr_30259_30285 = state_30249__$1;
(statearr_30259_30285[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30250 === (11))){
var inst_30240 = cljs.core.async.close_BANG_.call(null,ch);
var state_30249__$1 = state_30249;
var statearr_30260_30286 = state_30249__$1;
(statearr_30260_30286[(2)] = inst_30240);

(statearr_30260_30286[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30250 === (9))){
var state_30249__$1 = state_30249;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30261_30287 = state_30249__$1;
(statearr_30261_30287[(1)] = (11));

} else {
var statearr_30262_30288 = state_30249__$1;
(statearr_30262_30288[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30250 === (5))){
var inst_30226 = (state_30249[(7)]);
var state_30249__$1 = state_30249;
var statearr_30263_30289 = state_30249__$1;
(statearr_30263_30289[(2)] = inst_30226);

(statearr_30263_30289[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30250 === (10))){
var inst_30245 = (state_30249[(2)]);
var state_30249__$1 = state_30249;
var statearr_30264_30290 = state_30249__$1;
(statearr_30264_30290[(2)] = inst_30245);

(statearr_30264_30290[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30250 === (8))){
var inst_30226 = (state_30249[(7)]);
var inst_30236 = cljs.core.next.call(null,inst_30226);
var inst_30226__$1 = inst_30236;
var state_30249__$1 = (function (){var statearr_30265 = state_30249;
(statearr_30265[(7)] = inst_30226__$1);

return statearr_30265;
})();
var statearr_30266_30291 = state_30249__$1;
(statearr_30266_30291[(2)] = null);

(statearr_30266_30291[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29377__auto__))
;
return ((function (switch__29263__auto__,c__29377__auto__){
return (function() {
var cljs$core$async$state_machine__29264__auto__ = null;
var cljs$core$async$state_machine__29264__auto____0 = (function (){
var statearr_30270 = [null,null,null,null,null,null,null,null];
(statearr_30270[(0)] = cljs$core$async$state_machine__29264__auto__);

(statearr_30270[(1)] = (1));

return statearr_30270;
});
var cljs$core$async$state_machine__29264__auto____1 = (function (state_30249){
while(true){
var ret_value__29265__auto__ = (function (){try{while(true){
var result__29266__auto__ = switch__29263__auto__.call(null,state_30249);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29266__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29266__auto__;
}
break;
}
}catch (e30271){if((e30271 instanceof Object)){
var ex__29267__auto__ = e30271;
var statearr_30272_30292 = state_30249;
(statearr_30272_30292[(5)] = ex__29267__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30249);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30271;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29265__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30293 = state_30249;
state_30249 = G__30293;
continue;
} else {
return ret_value__29265__auto__;
}
break;
}
});
cljs$core$async$state_machine__29264__auto__ = function(state_30249){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29264__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29264__auto____1.call(this,state_30249);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29264__auto____0;
cljs$core$async$state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29264__auto____1;
return cljs$core$async$state_machine__29264__auto__;
})()
;})(switch__29263__auto__,c__29377__auto__))
})();
var state__29379__auto__ = (function (){var statearr_30273 = f__29378__auto__.call(null);
(statearr_30273[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29377__auto__);

return statearr_30273;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29379__auto__);
});})(c__29377__auto__))
);

return c__29377__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__27409__auto__ = (((_ == null))?null:_);
var m__27410__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__27409__auto__)]);
if(!((m__27410__auto__ == null))){
return m__27410__auto__.call(null,_);
} else {
var m__27410__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__27410__auto____$1 == null))){
return m__27410__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__27409__auto__ = (((m == null))?null:m);
var m__27410__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__27409__auto__)]);
if(!((m__27410__auto__ == null))){
return m__27410__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__27410__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__27410__auto____$1 == null))){
return m__27410__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__27409__auto__ = (((m == null))?null:m);
var m__27410__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__27409__auto__)]);
if(!((m__27410__auto__ == null))){
return m__27410__auto__.call(null,m,ch);
} else {
var m__27410__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__27410__auto____$1 == null))){
return m__27410__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__27409__auto__ = (((m == null))?null:m);
var m__27410__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__27409__auto__)]);
if(!((m__27410__auto__ == null))){
return m__27410__auto__.call(null,m);
} else {
var m__27410__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__27410__auto____$1 == null))){
return m__27410__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async30519 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30519 = (function (ch,cs,meta30520){
this.ch = ch;
this.cs = cs;
this.meta30520 = meta30520;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async30519.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_30521,meta30520__$1){
var self__ = this;
var _30521__$1 = this;
return (new cljs.core.async.t_cljs$core$async30519(self__.ch,self__.cs,meta30520__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async30519.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_30521){
var self__ = this;
var _30521__$1 = this;
return self__.meta30520;
});})(cs))
;

cljs.core.async.t_cljs$core$async30519.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async30519.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async30519.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async30519.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async30519.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async30519.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async30519.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta30520","meta30520",-1402435610,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async30519.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30519.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30519";

cljs.core.async.t_cljs$core$async30519.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__27348__auto__,writer__27349__auto__,opt__27350__auto__){
return cljs.core._write.call(null,writer__27349__auto__,"cljs.core.async/t_cljs$core$async30519");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async30519 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async30519(ch__$1,cs__$1,meta30520){
return (new cljs.core.async.t_cljs$core$async30519(ch__$1,cs__$1,meta30520));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async30519(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__29377__auto___30744 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29377__auto___30744,cs,m,dchan,dctr,done){
return (function (){
var f__29378__auto__ = (function (){var switch__29263__auto__ = ((function (c__29377__auto___30744,cs,m,dchan,dctr,done){
return (function (state_30656){
var state_val_30657 = (state_30656[(1)]);
if((state_val_30657 === (7))){
var inst_30652 = (state_30656[(2)]);
var state_30656__$1 = state_30656;
var statearr_30658_30745 = state_30656__$1;
(statearr_30658_30745[(2)] = inst_30652);

(statearr_30658_30745[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (20))){
var inst_30555 = (state_30656[(7)]);
var inst_30567 = cljs.core.first.call(null,inst_30555);
var inst_30568 = cljs.core.nth.call(null,inst_30567,(0),null);
var inst_30569 = cljs.core.nth.call(null,inst_30567,(1),null);
var state_30656__$1 = (function (){var statearr_30659 = state_30656;
(statearr_30659[(8)] = inst_30568);

return statearr_30659;
})();
if(cljs.core.truth_(inst_30569)){
var statearr_30660_30746 = state_30656__$1;
(statearr_30660_30746[(1)] = (22));

} else {
var statearr_30661_30747 = state_30656__$1;
(statearr_30661_30747[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (27))){
var inst_30597 = (state_30656[(9)]);
var inst_30604 = (state_30656[(10)]);
var inst_30524 = (state_30656[(11)]);
var inst_30599 = (state_30656[(12)]);
var inst_30604__$1 = cljs.core._nth.call(null,inst_30597,inst_30599);
var inst_30605 = cljs.core.async.put_BANG_.call(null,inst_30604__$1,inst_30524,done);
var state_30656__$1 = (function (){var statearr_30662 = state_30656;
(statearr_30662[(10)] = inst_30604__$1);

return statearr_30662;
})();
if(cljs.core.truth_(inst_30605)){
var statearr_30663_30748 = state_30656__$1;
(statearr_30663_30748[(1)] = (30));

} else {
var statearr_30664_30749 = state_30656__$1;
(statearr_30664_30749[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (1))){
var state_30656__$1 = state_30656;
var statearr_30665_30750 = state_30656__$1;
(statearr_30665_30750[(2)] = null);

(statearr_30665_30750[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (24))){
var inst_30555 = (state_30656[(7)]);
var inst_30574 = (state_30656[(2)]);
var inst_30575 = cljs.core.next.call(null,inst_30555);
var inst_30533 = inst_30575;
var inst_30534 = null;
var inst_30535 = (0);
var inst_30536 = (0);
var state_30656__$1 = (function (){var statearr_30666 = state_30656;
(statearr_30666[(13)] = inst_30535);

(statearr_30666[(14)] = inst_30574);

(statearr_30666[(15)] = inst_30534);

(statearr_30666[(16)] = inst_30536);

(statearr_30666[(17)] = inst_30533);

return statearr_30666;
})();
var statearr_30667_30751 = state_30656__$1;
(statearr_30667_30751[(2)] = null);

(statearr_30667_30751[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (39))){
var state_30656__$1 = state_30656;
var statearr_30671_30752 = state_30656__$1;
(statearr_30671_30752[(2)] = null);

(statearr_30671_30752[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (4))){
var inst_30524 = (state_30656[(11)]);
var inst_30524__$1 = (state_30656[(2)]);
var inst_30525 = (inst_30524__$1 == null);
var state_30656__$1 = (function (){var statearr_30672 = state_30656;
(statearr_30672[(11)] = inst_30524__$1);

return statearr_30672;
})();
if(cljs.core.truth_(inst_30525)){
var statearr_30673_30753 = state_30656__$1;
(statearr_30673_30753[(1)] = (5));

} else {
var statearr_30674_30754 = state_30656__$1;
(statearr_30674_30754[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (15))){
var inst_30535 = (state_30656[(13)]);
var inst_30534 = (state_30656[(15)]);
var inst_30536 = (state_30656[(16)]);
var inst_30533 = (state_30656[(17)]);
var inst_30551 = (state_30656[(2)]);
var inst_30552 = (inst_30536 + (1));
var tmp30668 = inst_30535;
var tmp30669 = inst_30534;
var tmp30670 = inst_30533;
var inst_30533__$1 = tmp30670;
var inst_30534__$1 = tmp30669;
var inst_30535__$1 = tmp30668;
var inst_30536__$1 = inst_30552;
var state_30656__$1 = (function (){var statearr_30675 = state_30656;
(statearr_30675[(18)] = inst_30551);

(statearr_30675[(13)] = inst_30535__$1);

(statearr_30675[(15)] = inst_30534__$1);

(statearr_30675[(16)] = inst_30536__$1);

(statearr_30675[(17)] = inst_30533__$1);

return statearr_30675;
})();
var statearr_30676_30755 = state_30656__$1;
(statearr_30676_30755[(2)] = null);

(statearr_30676_30755[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (21))){
var inst_30578 = (state_30656[(2)]);
var state_30656__$1 = state_30656;
var statearr_30680_30756 = state_30656__$1;
(statearr_30680_30756[(2)] = inst_30578);

(statearr_30680_30756[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (31))){
var inst_30604 = (state_30656[(10)]);
var inst_30608 = done.call(null,null);
var inst_30609 = cljs.core.async.untap_STAR_.call(null,m,inst_30604);
var state_30656__$1 = (function (){var statearr_30681 = state_30656;
(statearr_30681[(19)] = inst_30608);

return statearr_30681;
})();
var statearr_30682_30757 = state_30656__$1;
(statearr_30682_30757[(2)] = inst_30609);

(statearr_30682_30757[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (32))){
var inst_30598 = (state_30656[(20)]);
var inst_30596 = (state_30656[(21)]);
var inst_30597 = (state_30656[(9)]);
var inst_30599 = (state_30656[(12)]);
var inst_30611 = (state_30656[(2)]);
var inst_30612 = (inst_30599 + (1));
var tmp30677 = inst_30598;
var tmp30678 = inst_30596;
var tmp30679 = inst_30597;
var inst_30596__$1 = tmp30678;
var inst_30597__$1 = tmp30679;
var inst_30598__$1 = tmp30677;
var inst_30599__$1 = inst_30612;
var state_30656__$1 = (function (){var statearr_30683 = state_30656;
(statearr_30683[(20)] = inst_30598__$1);

(statearr_30683[(21)] = inst_30596__$1);

(statearr_30683[(9)] = inst_30597__$1);

(statearr_30683[(12)] = inst_30599__$1);

(statearr_30683[(22)] = inst_30611);

return statearr_30683;
})();
var statearr_30684_30758 = state_30656__$1;
(statearr_30684_30758[(2)] = null);

(statearr_30684_30758[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (40))){
var inst_30624 = (state_30656[(23)]);
var inst_30628 = done.call(null,null);
var inst_30629 = cljs.core.async.untap_STAR_.call(null,m,inst_30624);
var state_30656__$1 = (function (){var statearr_30685 = state_30656;
(statearr_30685[(24)] = inst_30628);

return statearr_30685;
})();
var statearr_30686_30759 = state_30656__$1;
(statearr_30686_30759[(2)] = inst_30629);

(statearr_30686_30759[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (33))){
var inst_30615 = (state_30656[(25)]);
var inst_30617 = cljs.core.chunked_seq_QMARK_.call(null,inst_30615);
var state_30656__$1 = state_30656;
if(inst_30617){
var statearr_30687_30760 = state_30656__$1;
(statearr_30687_30760[(1)] = (36));

} else {
var statearr_30688_30761 = state_30656__$1;
(statearr_30688_30761[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (13))){
var inst_30545 = (state_30656[(26)]);
var inst_30548 = cljs.core.async.close_BANG_.call(null,inst_30545);
var state_30656__$1 = state_30656;
var statearr_30689_30762 = state_30656__$1;
(statearr_30689_30762[(2)] = inst_30548);

(statearr_30689_30762[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (22))){
var inst_30568 = (state_30656[(8)]);
var inst_30571 = cljs.core.async.close_BANG_.call(null,inst_30568);
var state_30656__$1 = state_30656;
var statearr_30690_30763 = state_30656__$1;
(statearr_30690_30763[(2)] = inst_30571);

(statearr_30690_30763[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (36))){
var inst_30615 = (state_30656[(25)]);
var inst_30619 = cljs.core.chunk_first.call(null,inst_30615);
var inst_30620 = cljs.core.chunk_rest.call(null,inst_30615);
var inst_30621 = cljs.core.count.call(null,inst_30619);
var inst_30596 = inst_30620;
var inst_30597 = inst_30619;
var inst_30598 = inst_30621;
var inst_30599 = (0);
var state_30656__$1 = (function (){var statearr_30691 = state_30656;
(statearr_30691[(20)] = inst_30598);

(statearr_30691[(21)] = inst_30596);

(statearr_30691[(9)] = inst_30597);

(statearr_30691[(12)] = inst_30599);

return statearr_30691;
})();
var statearr_30692_30764 = state_30656__$1;
(statearr_30692_30764[(2)] = null);

(statearr_30692_30764[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (41))){
var inst_30615 = (state_30656[(25)]);
var inst_30631 = (state_30656[(2)]);
var inst_30632 = cljs.core.next.call(null,inst_30615);
var inst_30596 = inst_30632;
var inst_30597 = null;
var inst_30598 = (0);
var inst_30599 = (0);
var state_30656__$1 = (function (){var statearr_30693 = state_30656;
(statearr_30693[(20)] = inst_30598);

(statearr_30693[(21)] = inst_30596);

(statearr_30693[(9)] = inst_30597);

(statearr_30693[(27)] = inst_30631);

(statearr_30693[(12)] = inst_30599);

return statearr_30693;
})();
var statearr_30694_30765 = state_30656__$1;
(statearr_30694_30765[(2)] = null);

(statearr_30694_30765[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (43))){
var state_30656__$1 = state_30656;
var statearr_30695_30766 = state_30656__$1;
(statearr_30695_30766[(2)] = null);

(statearr_30695_30766[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (29))){
var inst_30640 = (state_30656[(2)]);
var state_30656__$1 = state_30656;
var statearr_30696_30767 = state_30656__$1;
(statearr_30696_30767[(2)] = inst_30640);

(statearr_30696_30767[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (44))){
var inst_30649 = (state_30656[(2)]);
var state_30656__$1 = (function (){var statearr_30697 = state_30656;
(statearr_30697[(28)] = inst_30649);

return statearr_30697;
})();
var statearr_30698_30768 = state_30656__$1;
(statearr_30698_30768[(2)] = null);

(statearr_30698_30768[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (6))){
var inst_30588 = (state_30656[(29)]);
var inst_30587 = cljs.core.deref.call(null,cs);
var inst_30588__$1 = cljs.core.keys.call(null,inst_30587);
var inst_30589 = cljs.core.count.call(null,inst_30588__$1);
var inst_30590 = cljs.core.reset_BANG_.call(null,dctr,inst_30589);
var inst_30595 = cljs.core.seq.call(null,inst_30588__$1);
var inst_30596 = inst_30595;
var inst_30597 = null;
var inst_30598 = (0);
var inst_30599 = (0);
var state_30656__$1 = (function (){var statearr_30699 = state_30656;
(statearr_30699[(29)] = inst_30588__$1);

(statearr_30699[(20)] = inst_30598);

(statearr_30699[(21)] = inst_30596);

(statearr_30699[(9)] = inst_30597);

(statearr_30699[(30)] = inst_30590);

(statearr_30699[(12)] = inst_30599);

return statearr_30699;
})();
var statearr_30700_30769 = state_30656__$1;
(statearr_30700_30769[(2)] = null);

(statearr_30700_30769[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (28))){
var inst_30596 = (state_30656[(21)]);
var inst_30615 = (state_30656[(25)]);
var inst_30615__$1 = cljs.core.seq.call(null,inst_30596);
var state_30656__$1 = (function (){var statearr_30701 = state_30656;
(statearr_30701[(25)] = inst_30615__$1);

return statearr_30701;
})();
if(inst_30615__$1){
var statearr_30702_30770 = state_30656__$1;
(statearr_30702_30770[(1)] = (33));

} else {
var statearr_30703_30771 = state_30656__$1;
(statearr_30703_30771[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (25))){
var inst_30598 = (state_30656[(20)]);
var inst_30599 = (state_30656[(12)]);
var inst_30601 = (inst_30599 < inst_30598);
var inst_30602 = inst_30601;
var state_30656__$1 = state_30656;
if(cljs.core.truth_(inst_30602)){
var statearr_30704_30772 = state_30656__$1;
(statearr_30704_30772[(1)] = (27));

} else {
var statearr_30705_30773 = state_30656__$1;
(statearr_30705_30773[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (34))){
var state_30656__$1 = state_30656;
var statearr_30706_30774 = state_30656__$1;
(statearr_30706_30774[(2)] = null);

(statearr_30706_30774[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (17))){
var state_30656__$1 = state_30656;
var statearr_30707_30775 = state_30656__$1;
(statearr_30707_30775[(2)] = null);

(statearr_30707_30775[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (3))){
var inst_30654 = (state_30656[(2)]);
var state_30656__$1 = state_30656;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30656__$1,inst_30654);
} else {
if((state_val_30657 === (12))){
var inst_30583 = (state_30656[(2)]);
var state_30656__$1 = state_30656;
var statearr_30708_30776 = state_30656__$1;
(statearr_30708_30776[(2)] = inst_30583);

(statearr_30708_30776[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (2))){
var state_30656__$1 = state_30656;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30656__$1,(4),ch);
} else {
if((state_val_30657 === (23))){
var state_30656__$1 = state_30656;
var statearr_30709_30777 = state_30656__$1;
(statearr_30709_30777[(2)] = null);

(statearr_30709_30777[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (35))){
var inst_30638 = (state_30656[(2)]);
var state_30656__$1 = state_30656;
var statearr_30710_30778 = state_30656__$1;
(statearr_30710_30778[(2)] = inst_30638);

(statearr_30710_30778[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (19))){
var inst_30555 = (state_30656[(7)]);
var inst_30559 = cljs.core.chunk_first.call(null,inst_30555);
var inst_30560 = cljs.core.chunk_rest.call(null,inst_30555);
var inst_30561 = cljs.core.count.call(null,inst_30559);
var inst_30533 = inst_30560;
var inst_30534 = inst_30559;
var inst_30535 = inst_30561;
var inst_30536 = (0);
var state_30656__$1 = (function (){var statearr_30711 = state_30656;
(statearr_30711[(13)] = inst_30535);

(statearr_30711[(15)] = inst_30534);

(statearr_30711[(16)] = inst_30536);

(statearr_30711[(17)] = inst_30533);

return statearr_30711;
})();
var statearr_30712_30779 = state_30656__$1;
(statearr_30712_30779[(2)] = null);

(statearr_30712_30779[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (11))){
var inst_30555 = (state_30656[(7)]);
var inst_30533 = (state_30656[(17)]);
var inst_30555__$1 = cljs.core.seq.call(null,inst_30533);
var state_30656__$1 = (function (){var statearr_30713 = state_30656;
(statearr_30713[(7)] = inst_30555__$1);

return statearr_30713;
})();
if(inst_30555__$1){
var statearr_30714_30780 = state_30656__$1;
(statearr_30714_30780[(1)] = (16));

} else {
var statearr_30715_30781 = state_30656__$1;
(statearr_30715_30781[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (9))){
var inst_30585 = (state_30656[(2)]);
var state_30656__$1 = state_30656;
var statearr_30716_30782 = state_30656__$1;
(statearr_30716_30782[(2)] = inst_30585);

(statearr_30716_30782[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (5))){
var inst_30531 = cljs.core.deref.call(null,cs);
var inst_30532 = cljs.core.seq.call(null,inst_30531);
var inst_30533 = inst_30532;
var inst_30534 = null;
var inst_30535 = (0);
var inst_30536 = (0);
var state_30656__$1 = (function (){var statearr_30717 = state_30656;
(statearr_30717[(13)] = inst_30535);

(statearr_30717[(15)] = inst_30534);

(statearr_30717[(16)] = inst_30536);

(statearr_30717[(17)] = inst_30533);

return statearr_30717;
})();
var statearr_30718_30783 = state_30656__$1;
(statearr_30718_30783[(2)] = null);

(statearr_30718_30783[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (14))){
var state_30656__$1 = state_30656;
var statearr_30719_30784 = state_30656__$1;
(statearr_30719_30784[(2)] = null);

(statearr_30719_30784[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (45))){
var inst_30646 = (state_30656[(2)]);
var state_30656__$1 = state_30656;
var statearr_30720_30785 = state_30656__$1;
(statearr_30720_30785[(2)] = inst_30646);

(statearr_30720_30785[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (26))){
var inst_30588 = (state_30656[(29)]);
var inst_30642 = (state_30656[(2)]);
var inst_30643 = cljs.core.seq.call(null,inst_30588);
var state_30656__$1 = (function (){var statearr_30721 = state_30656;
(statearr_30721[(31)] = inst_30642);

return statearr_30721;
})();
if(inst_30643){
var statearr_30722_30786 = state_30656__$1;
(statearr_30722_30786[(1)] = (42));

} else {
var statearr_30723_30787 = state_30656__$1;
(statearr_30723_30787[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (16))){
var inst_30555 = (state_30656[(7)]);
var inst_30557 = cljs.core.chunked_seq_QMARK_.call(null,inst_30555);
var state_30656__$1 = state_30656;
if(inst_30557){
var statearr_30724_30788 = state_30656__$1;
(statearr_30724_30788[(1)] = (19));

} else {
var statearr_30725_30789 = state_30656__$1;
(statearr_30725_30789[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (38))){
var inst_30635 = (state_30656[(2)]);
var state_30656__$1 = state_30656;
var statearr_30726_30790 = state_30656__$1;
(statearr_30726_30790[(2)] = inst_30635);

(statearr_30726_30790[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (30))){
var state_30656__$1 = state_30656;
var statearr_30727_30791 = state_30656__$1;
(statearr_30727_30791[(2)] = null);

(statearr_30727_30791[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (10))){
var inst_30534 = (state_30656[(15)]);
var inst_30536 = (state_30656[(16)]);
var inst_30544 = cljs.core._nth.call(null,inst_30534,inst_30536);
var inst_30545 = cljs.core.nth.call(null,inst_30544,(0),null);
var inst_30546 = cljs.core.nth.call(null,inst_30544,(1),null);
var state_30656__$1 = (function (){var statearr_30728 = state_30656;
(statearr_30728[(26)] = inst_30545);

return statearr_30728;
})();
if(cljs.core.truth_(inst_30546)){
var statearr_30729_30792 = state_30656__$1;
(statearr_30729_30792[(1)] = (13));

} else {
var statearr_30730_30793 = state_30656__$1;
(statearr_30730_30793[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (18))){
var inst_30581 = (state_30656[(2)]);
var state_30656__$1 = state_30656;
var statearr_30731_30794 = state_30656__$1;
(statearr_30731_30794[(2)] = inst_30581);

(statearr_30731_30794[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (42))){
var state_30656__$1 = state_30656;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30656__$1,(45),dchan);
} else {
if((state_val_30657 === (37))){
var inst_30615 = (state_30656[(25)]);
var inst_30524 = (state_30656[(11)]);
var inst_30624 = (state_30656[(23)]);
var inst_30624__$1 = cljs.core.first.call(null,inst_30615);
var inst_30625 = cljs.core.async.put_BANG_.call(null,inst_30624__$1,inst_30524,done);
var state_30656__$1 = (function (){var statearr_30732 = state_30656;
(statearr_30732[(23)] = inst_30624__$1);

return statearr_30732;
})();
if(cljs.core.truth_(inst_30625)){
var statearr_30733_30795 = state_30656__$1;
(statearr_30733_30795[(1)] = (39));

} else {
var statearr_30734_30796 = state_30656__$1;
(statearr_30734_30796[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (8))){
var inst_30535 = (state_30656[(13)]);
var inst_30536 = (state_30656[(16)]);
var inst_30538 = (inst_30536 < inst_30535);
var inst_30539 = inst_30538;
var state_30656__$1 = state_30656;
if(cljs.core.truth_(inst_30539)){
var statearr_30735_30797 = state_30656__$1;
(statearr_30735_30797[(1)] = (10));

} else {
var statearr_30736_30798 = state_30656__$1;
(statearr_30736_30798[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29377__auto___30744,cs,m,dchan,dctr,done))
;
return ((function (switch__29263__auto__,c__29377__auto___30744,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__29264__auto__ = null;
var cljs$core$async$mult_$_state_machine__29264__auto____0 = (function (){
var statearr_30740 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30740[(0)] = cljs$core$async$mult_$_state_machine__29264__auto__);

(statearr_30740[(1)] = (1));

return statearr_30740;
});
var cljs$core$async$mult_$_state_machine__29264__auto____1 = (function (state_30656){
while(true){
var ret_value__29265__auto__ = (function (){try{while(true){
var result__29266__auto__ = switch__29263__auto__.call(null,state_30656);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29266__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29266__auto__;
}
break;
}
}catch (e30741){if((e30741 instanceof Object)){
var ex__29267__auto__ = e30741;
var statearr_30742_30799 = state_30656;
(statearr_30742_30799[(5)] = ex__29267__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30656);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30741;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29265__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30800 = state_30656;
state_30656 = G__30800;
continue;
} else {
return ret_value__29265__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__29264__auto__ = function(state_30656){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__29264__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__29264__auto____1.call(this,state_30656);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__29264__auto____0;
cljs$core$async$mult_$_state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__29264__auto____1;
return cljs$core$async$mult_$_state_machine__29264__auto__;
})()
;})(switch__29263__auto__,c__29377__auto___30744,cs,m,dchan,dctr,done))
})();
var state__29379__auto__ = (function (){var statearr_30743 = f__29378__auto__.call(null);
(statearr_30743[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29377__auto___30744);

return statearr_30743;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29379__auto__);
});})(c__29377__auto___30744,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args30801 = [];
var len__27912__auto___30804 = arguments.length;
var i__27913__auto___30805 = (0);
while(true){
if((i__27913__auto___30805 < len__27912__auto___30804)){
args30801.push((arguments[i__27913__auto___30805]));

var G__30806 = (i__27913__auto___30805 + (1));
i__27913__auto___30805 = G__30806;
continue;
} else {
}
break;
}

var G__30803 = args30801.length;
switch (G__30803) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30801.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__27409__auto__ = (((m == null))?null:m);
var m__27410__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__27409__auto__)]);
if(!((m__27410__auto__ == null))){
return m__27410__auto__.call(null,m,ch);
} else {
var m__27410__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__27410__auto____$1 == null))){
return m__27410__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__27409__auto__ = (((m == null))?null:m);
var m__27410__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__27409__auto__)]);
if(!((m__27410__auto__ == null))){
return m__27410__auto__.call(null,m,ch);
} else {
var m__27410__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__27410__auto____$1 == null))){
return m__27410__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__27409__auto__ = (((m == null))?null:m);
var m__27410__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__27409__auto__)]);
if(!((m__27410__auto__ == null))){
return m__27410__auto__.call(null,m);
} else {
var m__27410__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__27410__auto____$1 == null))){
return m__27410__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__27409__auto__ = (((m == null))?null:m);
var m__27410__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__27409__auto__)]);
if(!((m__27410__auto__ == null))){
return m__27410__auto__.call(null,m,state_map);
} else {
var m__27410__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__27410__auto____$1 == null))){
return m__27410__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__27409__auto__ = (((m == null))?null:m);
var m__27410__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__27409__auto__)]);
if(!((m__27410__auto__ == null))){
return m__27410__auto__.call(null,m,mode);
} else {
var m__27410__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__27410__auto____$1 == null))){
return m__27410__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__27919__auto__ = [];
var len__27912__auto___30818 = arguments.length;
var i__27913__auto___30819 = (0);
while(true){
if((i__27913__auto___30819 < len__27912__auto___30818)){
args__27919__auto__.push((arguments[i__27913__auto___30819]));

var G__30820 = (i__27913__auto___30819 + (1));
i__27913__auto___30819 = G__30820;
continue;
} else {
}
break;
}

var argseq__27920__auto__ = ((((3) < args__27919__auto__.length))?(new cljs.core.IndexedSeq(args__27919__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__27920__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__30812){
var map__30813 = p__30812;
var map__30813__$1 = ((((!((map__30813 == null)))?((((map__30813.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30813.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30813):map__30813);
var opts = map__30813__$1;
var statearr_30815_30821 = state;
(statearr_30815_30821[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__6753__auto__ = cljs.core.async.do_alts.call(null,((function (map__30813,map__30813__$1,opts){
return (function (val){
var statearr_30816_30822 = state;
(statearr_30816_30822[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__30813,map__30813__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__6753__auto__)){
var cb = temp__6753__auto__;
var statearr_30817_30823 = state;
(statearr_30817_30823[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq30808){
var G__30809 = cljs.core.first.call(null,seq30808);
var seq30808__$1 = cljs.core.next.call(null,seq30808);
var G__30810 = cljs.core.first.call(null,seq30808__$1);
var seq30808__$2 = cljs.core.next.call(null,seq30808__$1);
var G__30811 = cljs.core.first.call(null,seq30808__$2);
var seq30808__$3 = cljs.core.next.call(null,seq30808__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__30809,G__30810,G__30811,seq30808__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async30991 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30991 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta30992){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta30992 = meta30992;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async30991.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_30993,meta30992__$1){
var self__ = this;
var _30993__$1 = this;
return (new cljs.core.async.t_cljs$core$async30991(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta30992__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30991.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_30993){
var self__ = this;
var _30993__$1 = this;
return self__.meta30992;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30991.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async30991.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30991.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async30991.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30991.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30991.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30991.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30991.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30991.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta30992","meta30992",-142435253,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30991.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30991.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30991";

cljs.core.async.t_cljs$core$async30991.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__27348__auto__,writer__27349__auto__,opt__27350__auto__){
return cljs.core._write.call(null,writer__27349__auto__,"cljs.core.async/t_cljs$core$async30991");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async30991 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async30991(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta30992){
return (new cljs.core.async.t_cljs$core$async30991(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta30992));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async30991(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__29377__auto___31158 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29377__auto___31158,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__29378__auto__ = (function (){var switch__29263__auto__ = ((function (c__29377__auto___31158,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_31095){
var state_val_31096 = (state_31095[(1)]);
if((state_val_31096 === (7))){
var inst_31010 = (state_31095[(2)]);
var state_31095__$1 = state_31095;
var statearr_31097_31159 = state_31095__$1;
(statearr_31097_31159[(2)] = inst_31010);

(statearr_31097_31159[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31096 === (20))){
var inst_31022 = (state_31095[(7)]);
var state_31095__$1 = state_31095;
var statearr_31098_31160 = state_31095__$1;
(statearr_31098_31160[(2)] = inst_31022);

(statearr_31098_31160[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31096 === (27))){
var state_31095__$1 = state_31095;
var statearr_31099_31161 = state_31095__$1;
(statearr_31099_31161[(2)] = null);

(statearr_31099_31161[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31096 === (1))){
var inst_30997 = (state_31095[(8)]);
var inst_30997__$1 = calc_state.call(null);
var inst_30999 = (inst_30997__$1 == null);
var inst_31000 = cljs.core.not.call(null,inst_30999);
var state_31095__$1 = (function (){var statearr_31100 = state_31095;
(statearr_31100[(8)] = inst_30997__$1);

return statearr_31100;
})();
if(inst_31000){
var statearr_31101_31162 = state_31095__$1;
(statearr_31101_31162[(1)] = (2));

} else {
var statearr_31102_31163 = state_31095__$1;
(statearr_31102_31163[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31096 === (24))){
var inst_31046 = (state_31095[(9)]);
var inst_31069 = (state_31095[(10)]);
var inst_31055 = (state_31095[(11)]);
var inst_31069__$1 = inst_31046.call(null,inst_31055);
var state_31095__$1 = (function (){var statearr_31103 = state_31095;
(statearr_31103[(10)] = inst_31069__$1);

return statearr_31103;
})();
if(cljs.core.truth_(inst_31069__$1)){
var statearr_31104_31164 = state_31095__$1;
(statearr_31104_31164[(1)] = (29));

} else {
var statearr_31105_31165 = state_31095__$1;
(statearr_31105_31165[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31096 === (4))){
var inst_31013 = (state_31095[(2)]);
var state_31095__$1 = state_31095;
if(cljs.core.truth_(inst_31013)){
var statearr_31106_31166 = state_31095__$1;
(statearr_31106_31166[(1)] = (8));

} else {
var statearr_31107_31167 = state_31095__$1;
(statearr_31107_31167[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31096 === (15))){
var inst_31040 = (state_31095[(2)]);
var state_31095__$1 = state_31095;
if(cljs.core.truth_(inst_31040)){
var statearr_31108_31168 = state_31095__$1;
(statearr_31108_31168[(1)] = (19));

} else {
var statearr_31109_31169 = state_31095__$1;
(statearr_31109_31169[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31096 === (21))){
var inst_31045 = (state_31095[(12)]);
var inst_31045__$1 = (state_31095[(2)]);
var inst_31046 = cljs.core.get.call(null,inst_31045__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_31047 = cljs.core.get.call(null,inst_31045__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_31048 = cljs.core.get.call(null,inst_31045__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_31095__$1 = (function (){var statearr_31110 = state_31095;
(statearr_31110[(9)] = inst_31046);

(statearr_31110[(12)] = inst_31045__$1);

(statearr_31110[(13)] = inst_31047);

return statearr_31110;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_31095__$1,(22),inst_31048);
} else {
if((state_val_31096 === (31))){
var inst_31077 = (state_31095[(2)]);
var state_31095__$1 = state_31095;
if(cljs.core.truth_(inst_31077)){
var statearr_31111_31170 = state_31095__$1;
(statearr_31111_31170[(1)] = (32));

} else {
var statearr_31112_31171 = state_31095__$1;
(statearr_31112_31171[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31096 === (32))){
var inst_31054 = (state_31095[(14)]);
var state_31095__$1 = state_31095;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31095__$1,(35),out,inst_31054);
} else {
if((state_val_31096 === (33))){
var inst_31045 = (state_31095[(12)]);
var inst_31022 = inst_31045;
var state_31095__$1 = (function (){var statearr_31113 = state_31095;
(statearr_31113[(7)] = inst_31022);

return statearr_31113;
})();
var statearr_31114_31172 = state_31095__$1;
(statearr_31114_31172[(2)] = null);

(statearr_31114_31172[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31096 === (13))){
var inst_31022 = (state_31095[(7)]);
var inst_31029 = inst_31022.cljs$lang$protocol_mask$partition0$;
var inst_31030 = (inst_31029 & (64));
var inst_31031 = inst_31022.cljs$core$ISeq$;
var inst_31032 = (cljs.core.PROTOCOL_SENTINEL === inst_31031);
var inst_31033 = (inst_31030) || (inst_31032);
var state_31095__$1 = state_31095;
if(cljs.core.truth_(inst_31033)){
var statearr_31115_31173 = state_31095__$1;
(statearr_31115_31173[(1)] = (16));

} else {
var statearr_31116_31174 = state_31095__$1;
(statearr_31116_31174[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31096 === (22))){
var inst_31055 = (state_31095[(11)]);
var inst_31054 = (state_31095[(14)]);
var inst_31053 = (state_31095[(2)]);
var inst_31054__$1 = cljs.core.nth.call(null,inst_31053,(0),null);
var inst_31055__$1 = cljs.core.nth.call(null,inst_31053,(1),null);
var inst_31056 = (inst_31054__$1 == null);
var inst_31057 = cljs.core._EQ_.call(null,inst_31055__$1,change);
var inst_31058 = (inst_31056) || (inst_31057);
var state_31095__$1 = (function (){var statearr_31117 = state_31095;
(statearr_31117[(11)] = inst_31055__$1);

(statearr_31117[(14)] = inst_31054__$1);

return statearr_31117;
})();
if(cljs.core.truth_(inst_31058)){
var statearr_31118_31175 = state_31095__$1;
(statearr_31118_31175[(1)] = (23));

} else {
var statearr_31119_31176 = state_31095__$1;
(statearr_31119_31176[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31096 === (36))){
var inst_31045 = (state_31095[(12)]);
var inst_31022 = inst_31045;
var state_31095__$1 = (function (){var statearr_31120 = state_31095;
(statearr_31120[(7)] = inst_31022);

return statearr_31120;
})();
var statearr_31121_31177 = state_31095__$1;
(statearr_31121_31177[(2)] = null);

(statearr_31121_31177[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31096 === (29))){
var inst_31069 = (state_31095[(10)]);
var state_31095__$1 = state_31095;
var statearr_31122_31178 = state_31095__$1;
(statearr_31122_31178[(2)] = inst_31069);

(statearr_31122_31178[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31096 === (6))){
var state_31095__$1 = state_31095;
var statearr_31123_31179 = state_31095__$1;
(statearr_31123_31179[(2)] = false);

(statearr_31123_31179[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31096 === (28))){
var inst_31065 = (state_31095[(2)]);
var inst_31066 = calc_state.call(null);
var inst_31022 = inst_31066;
var state_31095__$1 = (function (){var statearr_31124 = state_31095;
(statearr_31124[(7)] = inst_31022);

(statearr_31124[(15)] = inst_31065);

return statearr_31124;
})();
var statearr_31125_31180 = state_31095__$1;
(statearr_31125_31180[(2)] = null);

(statearr_31125_31180[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31096 === (25))){
var inst_31091 = (state_31095[(2)]);
var state_31095__$1 = state_31095;
var statearr_31126_31181 = state_31095__$1;
(statearr_31126_31181[(2)] = inst_31091);

(statearr_31126_31181[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31096 === (34))){
var inst_31089 = (state_31095[(2)]);
var state_31095__$1 = state_31095;
var statearr_31127_31182 = state_31095__$1;
(statearr_31127_31182[(2)] = inst_31089);

(statearr_31127_31182[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31096 === (17))){
var state_31095__$1 = state_31095;
var statearr_31128_31183 = state_31095__$1;
(statearr_31128_31183[(2)] = false);

(statearr_31128_31183[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31096 === (3))){
var state_31095__$1 = state_31095;
var statearr_31129_31184 = state_31095__$1;
(statearr_31129_31184[(2)] = false);

(statearr_31129_31184[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31096 === (12))){
var inst_31093 = (state_31095[(2)]);
var state_31095__$1 = state_31095;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31095__$1,inst_31093);
} else {
if((state_val_31096 === (2))){
var inst_30997 = (state_31095[(8)]);
var inst_31002 = inst_30997.cljs$lang$protocol_mask$partition0$;
var inst_31003 = (inst_31002 & (64));
var inst_31004 = inst_30997.cljs$core$ISeq$;
var inst_31005 = (cljs.core.PROTOCOL_SENTINEL === inst_31004);
var inst_31006 = (inst_31003) || (inst_31005);
var state_31095__$1 = state_31095;
if(cljs.core.truth_(inst_31006)){
var statearr_31130_31185 = state_31095__$1;
(statearr_31130_31185[(1)] = (5));

} else {
var statearr_31131_31186 = state_31095__$1;
(statearr_31131_31186[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31096 === (23))){
var inst_31054 = (state_31095[(14)]);
var inst_31060 = (inst_31054 == null);
var state_31095__$1 = state_31095;
if(cljs.core.truth_(inst_31060)){
var statearr_31132_31187 = state_31095__$1;
(statearr_31132_31187[(1)] = (26));

} else {
var statearr_31133_31188 = state_31095__$1;
(statearr_31133_31188[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31096 === (35))){
var inst_31080 = (state_31095[(2)]);
var state_31095__$1 = state_31095;
if(cljs.core.truth_(inst_31080)){
var statearr_31134_31189 = state_31095__$1;
(statearr_31134_31189[(1)] = (36));

} else {
var statearr_31135_31190 = state_31095__$1;
(statearr_31135_31190[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31096 === (19))){
var inst_31022 = (state_31095[(7)]);
var inst_31042 = cljs.core.apply.call(null,cljs.core.hash_map,inst_31022);
var state_31095__$1 = state_31095;
var statearr_31136_31191 = state_31095__$1;
(statearr_31136_31191[(2)] = inst_31042);

(statearr_31136_31191[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31096 === (11))){
var inst_31022 = (state_31095[(7)]);
var inst_31026 = (inst_31022 == null);
var inst_31027 = cljs.core.not.call(null,inst_31026);
var state_31095__$1 = state_31095;
if(inst_31027){
var statearr_31137_31192 = state_31095__$1;
(statearr_31137_31192[(1)] = (13));

} else {
var statearr_31138_31193 = state_31095__$1;
(statearr_31138_31193[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31096 === (9))){
var inst_30997 = (state_31095[(8)]);
var state_31095__$1 = state_31095;
var statearr_31139_31194 = state_31095__$1;
(statearr_31139_31194[(2)] = inst_30997);

(statearr_31139_31194[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31096 === (5))){
var state_31095__$1 = state_31095;
var statearr_31140_31195 = state_31095__$1;
(statearr_31140_31195[(2)] = true);

(statearr_31140_31195[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31096 === (14))){
var state_31095__$1 = state_31095;
var statearr_31141_31196 = state_31095__$1;
(statearr_31141_31196[(2)] = false);

(statearr_31141_31196[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31096 === (26))){
var inst_31055 = (state_31095[(11)]);
var inst_31062 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_31055);
var state_31095__$1 = state_31095;
var statearr_31142_31197 = state_31095__$1;
(statearr_31142_31197[(2)] = inst_31062);

(statearr_31142_31197[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31096 === (16))){
var state_31095__$1 = state_31095;
var statearr_31143_31198 = state_31095__$1;
(statearr_31143_31198[(2)] = true);

(statearr_31143_31198[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31096 === (38))){
var inst_31085 = (state_31095[(2)]);
var state_31095__$1 = state_31095;
var statearr_31144_31199 = state_31095__$1;
(statearr_31144_31199[(2)] = inst_31085);

(statearr_31144_31199[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31096 === (30))){
var inst_31046 = (state_31095[(9)]);
var inst_31047 = (state_31095[(13)]);
var inst_31055 = (state_31095[(11)]);
var inst_31072 = cljs.core.empty_QMARK_.call(null,inst_31046);
var inst_31073 = inst_31047.call(null,inst_31055);
var inst_31074 = cljs.core.not.call(null,inst_31073);
var inst_31075 = (inst_31072) && (inst_31074);
var state_31095__$1 = state_31095;
var statearr_31145_31200 = state_31095__$1;
(statearr_31145_31200[(2)] = inst_31075);

(statearr_31145_31200[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31096 === (10))){
var inst_30997 = (state_31095[(8)]);
var inst_31018 = (state_31095[(2)]);
var inst_31019 = cljs.core.get.call(null,inst_31018,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_31020 = cljs.core.get.call(null,inst_31018,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_31021 = cljs.core.get.call(null,inst_31018,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_31022 = inst_30997;
var state_31095__$1 = (function (){var statearr_31146 = state_31095;
(statearr_31146[(16)] = inst_31021);

(statearr_31146[(7)] = inst_31022);

(statearr_31146[(17)] = inst_31020);

(statearr_31146[(18)] = inst_31019);

return statearr_31146;
})();
var statearr_31147_31201 = state_31095__$1;
(statearr_31147_31201[(2)] = null);

(statearr_31147_31201[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31096 === (18))){
var inst_31037 = (state_31095[(2)]);
var state_31095__$1 = state_31095;
var statearr_31148_31202 = state_31095__$1;
(statearr_31148_31202[(2)] = inst_31037);

(statearr_31148_31202[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31096 === (37))){
var state_31095__$1 = state_31095;
var statearr_31149_31203 = state_31095__$1;
(statearr_31149_31203[(2)] = null);

(statearr_31149_31203[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31096 === (8))){
var inst_30997 = (state_31095[(8)]);
var inst_31015 = cljs.core.apply.call(null,cljs.core.hash_map,inst_30997);
var state_31095__$1 = state_31095;
var statearr_31150_31204 = state_31095__$1;
(statearr_31150_31204[(2)] = inst_31015);

(statearr_31150_31204[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29377__auto___31158,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__29263__auto__,c__29377__auto___31158,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__29264__auto__ = null;
var cljs$core$async$mix_$_state_machine__29264__auto____0 = (function (){
var statearr_31154 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31154[(0)] = cljs$core$async$mix_$_state_machine__29264__auto__);

(statearr_31154[(1)] = (1));

return statearr_31154;
});
var cljs$core$async$mix_$_state_machine__29264__auto____1 = (function (state_31095){
while(true){
var ret_value__29265__auto__ = (function (){try{while(true){
var result__29266__auto__ = switch__29263__auto__.call(null,state_31095);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29266__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29266__auto__;
}
break;
}
}catch (e31155){if((e31155 instanceof Object)){
var ex__29267__auto__ = e31155;
var statearr_31156_31205 = state_31095;
(statearr_31156_31205[(5)] = ex__29267__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31095);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31155;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29265__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31206 = state_31095;
state_31095 = G__31206;
continue;
} else {
return ret_value__29265__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__29264__auto__ = function(state_31095){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__29264__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__29264__auto____1.call(this,state_31095);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__29264__auto____0;
cljs$core$async$mix_$_state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__29264__auto____1;
return cljs$core$async$mix_$_state_machine__29264__auto__;
})()
;})(switch__29263__auto__,c__29377__auto___31158,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__29379__auto__ = (function (){var statearr_31157 = f__29378__auto__.call(null);
(statearr_31157[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29377__auto___31158);

return statearr_31157;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29379__auto__);
});})(c__29377__auto___31158,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__27409__auto__ = (((p == null))?null:p);
var m__27410__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__27409__auto__)]);
if(!((m__27410__auto__ == null))){
return m__27410__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__27410__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__27410__auto____$1 == null))){
return m__27410__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__27409__auto__ = (((p == null))?null:p);
var m__27410__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__27409__auto__)]);
if(!((m__27410__auto__ == null))){
return m__27410__auto__.call(null,p,v,ch);
} else {
var m__27410__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__27410__auto____$1 == null))){
return m__27410__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args31207 = [];
var len__27912__auto___31210 = arguments.length;
var i__27913__auto___31211 = (0);
while(true){
if((i__27913__auto___31211 < len__27912__auto___31210)){
args31207.push((arguments[i__27913__auto___31211]));

var G__31212 = (i__27913__auto___31211 + (1));
i__27913__auto___31211 = G__31212;
continue;
} else {
}
break;
}

var G__31209 = args31207.length;
switch (G__31209) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31207.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__27409__auto__ = (((p == null))?null:p);
var m__27410__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__27409__auto__)]);
if(!((m__27410__auto__ == null))){
return m__27410__auto__.call(null,p);
} else {
var m__27410__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__27410__auto____$1 == null))){
return m__27410__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__27409__auto__ = (((p == null))?null:p);
var m__27410__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__27409__auto__)]);
if(!((m__27410__auto__ == null))){
return m__27410__auto__.call(null,p,v);
} else {
var m__27410__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__27410__auto____$1 == null))){
return m__27410__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args31215 = [];
var len__27912__auto___31340 = arguments.length;
var i__27913__auto___31341 = (0);
while(true){
if((i__27913__auto___31341 < len__27912__auto___31340)){
args31215.push((arguments[i__27913__auto___31341]));

var G__31342 = (i__27913__auto___31341 + (1));
i__27913__auto___31341 = G__31342;
continue;
} else {
}
break;
}

var G__31217 = args31215.length;
switch (G__31217) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31215.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__26696__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__26696__auto__)){
return or__26696__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__26696__auto__,mults){
return (function (p1__31214_SHARP_){
if(cljs.core.truth_(p1__31214_SHARP_.call(null,topic))){
return p1__31214_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__31214_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__26696__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async31218 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31218 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta31219){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta31219 = meta31219;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31218.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_31220,meta31219__$1){
var self__ = this;
var _31220__$1 = this;
return (new cljs.core.async.t_cljs$core$async31218(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta31219__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31218.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_31220){
var self__ = this;
var _31220__$1 = this;
return self__.meta31219;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31218.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31218.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31218.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31218.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31218.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__6753__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__6753__auto__)){
var m = temp__6753__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31218.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31218.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31218.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta31219","meta31219",1989407213,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31218.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31218.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31218";

cljs.core.async.t_cljs$core$async31218.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__27348__auto__,writer__27349__auto__,opt__27350__auto__){
return cljs.core._write.call(null,writer__27349__auto__,"cljs.core.async/t_cljs$core$async31218");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async31218 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async31218(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta31219){
return (new cljs.core.async.t_cljs$core$async31218(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta31219));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async31218(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__29377__auto___31344 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29377__auto___31344,mults,ensure_mult,p){
return (function (){
var f__29378__auto__ = (function (){var switch__29263__auto__ = ((function (c__29377__auto___31344,mults,ensure_mult,p){
return (function (state_31292){
var state_val_31293 = (state_31292[(1)]);
if((state_val_31293 === (7))){
var inst_31288 = (state_31292[(2)]);
var state_31292__$1 = state_31292;
var statearr_31294_31345 = state_31292__$1;
(statearr_31294_31345[(2)] = inst_31288);

(statearr_31294_31345[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31293 === (20))){
var state_31292__$1 = state_31292;
var statearr_31295_31346 = state_31292__$1;
(statearr_31295_31346[(2)] = null);

(statearr_31295_31346[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31293 === (1))){
var state_31292__$1 = state_31292;
var statearr_31296_31347 = state_31292__$1;
(statearr_31296_31347[(2)] = null);

(statearr_31296_31347[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31293 === (24))){
var inst_31271 = (state_31292[(7)]);
var inst_31280 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_31271);
var state_31292__$1 = state_31292;
var statearr_31297_31348 = state_31292__$1;
(statearr_31297_31348[(2)] = inst_31280);

(statearr_31297_31348[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31293 === (4))){
var inst_31223 = (state_31292[(8)]);
var inst_31223__$1 = (state_31292[(2)]);
var inst_31224 = (inst_31223__$1 == null);
var state_31292__$1 = (function (){var statearr_31298 = state_31292;
(statearr_31298[(8)] = inst_31223__$1);

return statearr_31298;
})();
if(cljs.core.truth_(inst_31224)){
var statearr_31299_31349 = state_31292__$1;
(statearr_31299_31349[(1)] = (5));

} else {
var statearr_31300_31350 = state_31292__$1;
(statearr_31300_31350[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31293 === (15))){
var inst_31265 = (state_31292[(2)]);
var state_31292__$1 = state_31292;
var statearr_31301_31351 = state_31292__$1;
(statearr_31301_31351[(2)] = inst_31265);

(statearr_31301_31351[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31293 === (21))){
var inst_31285 = (state_31292[(2)]);
var state_31292__$1 = (function (){var statearr_31302 = state_31292;
(statearr_31302[(9)] = inst_31285);

return statearr_31302;
})();
var statearr_31303_31352 = state_31292__$1;
(statearr_31303_31352[(2)] = null);

(statearr_31303_31352[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31293 === (13))){
var inst_31247 = (state_31292[(10)]);
var inst_31249 = cljs.core.chunked_seq_QMARK_.call(null,inst_31247);
var state_31292__$1 = state_31292;
if(inst_31249){
var statearr_31304_31353 = state_31292__$1;
(statearr_31304_31353[(1)] = (16));

} else {
var statearr_31305_31354 = state_31292__$1;
(statearr_31305_31354[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31293 === (22))){
var inst_31277 = (state_31292[(2)]);
var state_31292__$1 = state_31292;
if(cljs.core.truth_(inst_31277)){
var statearr_31306_31355 = state_31292__$1;
(statearr_31306_31355[(1)] = (23));

} else {
var statearr_31307_31356 = state_31292__$1;
(statearr_31307_31356[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31293 === (6))){
var inst_31223 = (state_31292[(8)]);
var inst_31271 = (state_31292[(7)]);
var inst_31273 = (state_31292[(11)]);
var inst_31271__$1 = topic_fn.call(null,inst_31223);
var inst_31272 = cljs.core.deref.call(null,mults);
var inst_31273__$1 = cljs.core.get.call(null,inst_31272,inst_31271__$1);
var state_31292__$1 = (function (){var statearr_31308 = state_31292;
(statearr_31308[(7)] = inst_31271__$1);

(statearr_31308[(11)] = inst_31273__$1);

return statearr_31308;
})();
if(cljs.core.truth_(inst_31273__$1)){
var statearr_31309_31357 = state_31292__$1;
(statearr_31309_31357[(1)] = (19));

} else {
var statearr_31310_31358 = state_31292__$1;
(statearr_31310_31358[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31293 === (25))){
var inst_31282 = (state_31292[(2)]);
var state_31292__$1 = state_31292;
var statearr_31311_31359 = state_31292__$1;
(statearr_31311_31359[(2)] = inst_31282);

(statearr_31311_31359[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31293 === (17))){
var inst_31247 = (state_31292[(10)]);
var inst_31256 = cljs.core.first.call(null,inst_31247);
var inst_31257 = cljs.core.async.muxch_STAR_.call(null,inst_31256);
var inst_31258 = cljs.core.async.close_BANG_.call(null,inst_31257);
var inst_31259 = cljs.core.next.call(null,inst_31247);
var inst_31233 = inst_31259;
var inst_31234 = null;
var inst_31235 = (0);
var inst_31236 = (0);
var state_31292__$1 = (function (){var statearr_31312 = state_31292;
(statearr_31312[(12)] = inst_31236);

(statearr_31312[(13)] = inst_31258);

(statearr_31312[(14)] = inst_31234);

(statearr_31312[(15)] = inst_31235);

(statearr_31312[(16)] = inst_31233);

return statearr_31312;
})();
var statearr_31313_31360 = state_31292__$1;
(statearr_31313_31360[(2)] = null);

(statearr_31313_31360[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31293 === (3))){
var inst_31290 = (state_31292[(2)]);
var state_31292__$1 = state_31292;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31292__$1,inst_31290);
} else {
if((state_val_31293 === (12))){
var inst_31267 = (state_31292[(2)]);
var state_31292__$1 = state_31292;
var statearr_31314_31361 = state_31292__$1;
(statearr_31314_31361[(2)] = inst_31267);

(statearr_31314_31361[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31293 === (2))){
var state_31292__$1 = state_31292;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31292__$1,(4),ch);
} else {
if((state_val_31293 === (23))){
var state_31292__$1 = state_31292;
var statearr_31315_31362 = state_31292__$1;
(statearr_31315_31362[(2)] = null);

(statearr_31315_31362[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31293 === (19))){
var inst_31223 = (state_31292[(8)]);
var inst_31273 = (state_31292[(11)]);
var inst_31275 = cljs.core.async.muxch_STAR_.call(null,inst_31273);
var state_31292__$1 = state_31292;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31292__$1,(22),inst_31275,inst_31223);
} else {
if((state_val_31293 === (11))){
var inst_31247 = (state_31292[(10)]);
var inst_31233 = (state_31292[(16)]);
var inst_31247__$1 = cljs.core.seq.call(null,inst_31233);
var state_31292__$1 = (function (){var statearr_31316 = state_31292;
(statearr_31316[(10)] = inst_31247__$1);

return statearr_31316;
})();
if(inst_31247__$1){
var statearr_31317_31363 = state_31292__$1;
(statearr_31317_31363[(1)] = (13));

} else {
var statearr_31318_31364 = state_31292__$1;
(statearr_31318_31364[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31293 === (9))){
var inst_31269 = (state_31292[(2)]);
var state_31292__$1 = state_31292;
var statearr_31319_31365 = state_31292__$1;
(statearr_31319_31365[(2)] = inst_31269);

(statearr_31319_31365[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31293 === (5))){
var inst_31230 = cljs.core.deref.call(null,mults);
var inst_31231 = cljs.core.vals.call(null,inst_31230);
var inst_31232 = cljs.core.seq.call(null,inst_31231);
var inst_31233 = inst_31232;
var inst_31234 = null;
var inst_31235 = (0);
var inst_31236 = (0);
var state_31292__$1 = (function (){var statearr_31320 = state_31292;
(statearr_31320[(12)] = inst_31236);

(statearr_31320[(14)] = inst_31234);

(statearr_31320[(15)] = inst_31235);

(statearr_31320[(16)] = inst_31233);

return statearr_31320;
})();
var statearr_31321_31366 = state_31292__$1;
(statearr_31321_31366[(2)] = null);

(statearr_31321_31366[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31293 === (14))){
var state_31292__$1 = state_31292;
var statearr_31325_31367 = state_31292__$1;
(statearr_31325_31367[(2)] = null);

(statearr_31325_31367[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31293 === (16))){
var inst_31247 = (state_31292[(10)]);
var inst_31251 = cljs.core.chunk_first.call(null,inst_31247);
var inst_31252 = cljs.core.chunk_rest.call(null,inst_31247);
var inst_31253 = cljs.core.count.call(null,inst_31251);
var inst_31233 = inst_31252;
var inst_31234 = inst_31251;
var inst_31235 = inst_31253;
var inst_31236 = (0);
var state_31292__$1 = (function (){var statearr_31326 = state_31292;
(statearr_31326[(12)] = inst_31236);

(statearr_31326[(14)] = inst_31234);

(statearr_31326[(15)] = inst_31235);

(statearr_31326[(16)] = inst_31233);

return statearr_31326;
})();
var statearr_31327_31368 = state_31292__$1;
(statearr_31327_31368[(2)] = null);

(statearr_31327_31368[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31293 === (10))){
var inst_31236 = (state_31292[(12)]);
var inst_31234 = (state_31292[(14)]);
var inst_31235 = (state_31292[(15)]);
var inst_31233 = (state_31292[(16)]);
var inst_31241 = cljs.core._nth.call(null,inst_31234,inst_31236);
var inst_31242 = cljs.core.async.muxch_STAR_.call(null,inst_31241);
var inst_31243 = cljs.core.async.close_BANG_.call(null,inst_31242);
var inst_31244 = (inst_31236 + (1));
var tmp31322 = inst_31234;
var tmp31323 = inst_31235;
var tmp31324 = inst_31233;
var inst_31233__$1 = tmp31324;
var inst_31234__$1 = tmp31322;
var inst_31235__$1 = tmp31323;
var inst_31236__$1 = inst_31244;
var state_31292__$1 = (function (){var statearr_31328 = state_31292;
(statearr_31328[(12)] = inst_31236__$1);

(statearr_31328[(17)] = inst_31243);

(statearr_31328[(14)] = inst_31234__$1);

(statearr_31328[(15)] = inst_31235__$1);

(statearr_31328[(16)] = inst_31233__$1);

return statearr_31328;
})();
var statearr_31329_31369 = state_31292__$1;
(statearr_31329_31369[(2)] = null);

(statearr_31329_31369[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31293 === (18))){
var inst_31262 = (state_31292[(2)]);
var state_31292__$1 = state_31292;
var statearr_31330_31370 = state_31292__$1;
(statearr_31330_31370[(2)] = inst_31262);

(statearr_31330_31370[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31293 === (8))){
var inst_31236 = (state_31292[(12)]);
var inst_31235 = (state_31292[(15)]);
var inst_31238 = (inst_31236 < inst_31235);
var inst_31239 = inst_31238;
var state_31292__$1 = state_31292;
if(cljs.core.truth_(inst_31239)){
var statearr_31331_31371 = state_31292__$1;
(statearr_31331_31371[(1)] = (10));

} else {
var statearr_31332_31372 = state_31292__$1;
(statearr_31332_31372[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29377__auto___31344,mults,ensure_mult,p))
;
return ((function (switch__29263__auto__,c__29377__auto___31344,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__29264__auto__ = null;
var cljs$core$async$state_machine__29264__auto____0 = (function (){
var statearr_31336 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31336[(0)] = cljs$core$async$state_machine__29264__auto__);

(statearr_31336[(1)] = (1));

return statearr_31336;
});
var cljs$core$async$state_machine__29264__auto____1 = (function (state_31292){
while(true){
var ret_value__29265__auto__ = (function (){try{while(true){
var result__29266__auto__ = switch__29263__auto__.call(null,state_31292);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29266__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29266__auto__;
}
break;
}
}catch (e31337){if((e31337 instanceof Object)){
var ex__29267__auto__ = e31337;
var statearr_31338_31373 = state_31292;
(statearr_31338_31373[(5)] = ex__29267__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31292);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31337;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29265__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31374 = state_31292;
state_31292 = G__31374;
continue;
} else {
return ret_value__29265__auto__;
}
break;
}
});
cljs$core$async$state_machine__29264__auto__ = function(state_31292){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29264__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29264__auto____1.call(this,state_31292);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29264__auto____0;
cljs$core$async$state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29264__auto____1;
return cljs$core$async$state_machine__29264__auto__;
})()
;})(switch__29263__auto__,c__29377__auto___31344,mults,ensure_mult,p))
})();
var state__29379__auto__ = (function (){var statearr_31339 = f__29378__auto__.call(null);
(statearr_31339[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29377__auto___31344);

return statearr_31339;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29379__auto__);
});})(c__29377__auto___31344,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args31375 = [];
var len__27912__auto___31378 = arguments.length;
var i__27913__auto___31379 = (0);
while(true){
if((i__27913__auto___31379 < len__27912__auto___31378)){
args31375.push((arguments[i__27913__auto___31379]));

var G__31380 = (i__27913__auto___31379 + (1));
i__27913__auto___31379 = G__31380;
continue;
} else {
}
break;
}

var G__31377 = args31375.length;
switch (G__31377) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31375.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args31382 = [];
var len__27912__auto___31385 = arguments.length;
var i__27913__auto___31386 = (0);
while(true){
if((i__27913__auto___31386 < len__27912__auto___31385)){
args31382.push((arguments[i__27913__auto___31386]));

var G__31387 = (i__27913__auto___31386 + (1));
i__27913__auto___31386 = G__31387;
continue;
} else {
}
break;
}

var G__31384 = args31382.length;
switch (G__31384) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31382.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args31389 = [];
var len__27912__auto___31460 = arguments.length;
var i__27913__auto___31461 = (0);
while(true){
if((i__27913__auto___31461 < len__27912__auto___31460)){
args31389.push((arguments[i__27913__auto___31461]));

var G__31462 = (i__27913__auto___31461 + (1));
i__27913__auto___31461 = G__31462;
continue;
} else {
}
break;
}

var G__31391 = args31389.length;
switch (G__31391) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31389.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__29377__auto___31464 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29377__auto___31464,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__29378__auto__ = (function (){var switch__29263__auto__ = ((function (c__29377__auto___31464,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_31430){
var state_val_31431 = (state_31430[(1)]);
if((state_val_31431 === (7))){
var state_31430__$1 = state_31430;
var statearr_31432_31465 = state_31430__$1;
(statearr_31432_31465[(2)] = null);

(statearr_31432_31465[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31431 === (1))){
var state_31430__$1 = state_31430;
var statearr_31433_31466 = state_31430__$1;
(statearr_31433_31466[(2)] = null);

(statearr_31433_31466[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31431 === (4))){
var inst_31394 = (state_31430[(7)]);
var inst_31396 = (inst_31394 < cnt);
var state_31430__$1 = state_31430;
if(cljs.core.truth_(inst_31396)){
var statearr_31434_31467 = state_31430__$1;
(statearr_31434_31467[(1)] = (6));

} else {
var statearr_31435_31468 = state_31430__$1;
(statearr_31435_31468[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31431 === (15))){
var inst_31426 = (state_31430[(2)]);
var state_31430__$1 = state_31430;
var statearr_31436_31469 = state_31430__$1;
(statearr_31436_31469[(2)] = inst_31426);

(statearr_31436_31469[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31431 === (13))){
var inst_31419 = cljs.core.async.close_BANG_.call(null,out);
var state_31430__$1 = state_31430;
var statearr_31437_31470 = state_31430__$1;
(statearr_31437_31470[(2)] = inst_31419);

(statearr_31437_31470[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31431 === (6))){
var state_31430__$1 = state_31430;
var statearr_31438_31471 = state_31430__$1;
(statearr_31438_31471[(2)] = null);

(statearr_31438_31471[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31431 === (3))){
var inst_31428 = (state_31430[(2)]);
var state_31430__$1 = state_31430;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31430__$1,inst_31428);
} else {
if((state_val_31431 === (12))){
var inst_31416 = (state_31430[(8)]);
var inst_31416__$1 = (state_31430[(2)]);
var inst_31417 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_31416__$1);
var state_31430__$1 = (function (){var statearr_31439 = state_31430;
(statearr_31439[(8)] = inst_31416__$1);

return statearr_31439;
})();
if(cljs.core.truth_(inst_31417)){
var statearr_31440_31472 = state_31430__$1;
(statearr_31440_31472[(1)] = (13));

} else {
var statearr_31441_31473 = state_31430__$1;
(statearr_31441_31473[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31431 === (2))){
var inst_31393 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_31394 = (0);
var state_31430__$1 = (function (){var statearr_31442 = state_31430;
(statearr_31442[(7)] = inst_31394);

(statearr_31442[(9)] = inst_31393);

return statearr_31442;
})();
var statearr_31443_31474 = state_31430__$1;
(statearr_31443_31474[(2)] = null);

(statearr_31443_31474[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31431 === (11))){
var inst_31394 = (state_31430[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_31430,(10),Object,null,(9));
var inst_31403 = chs__$1.call(null,inst_31394);
var inst_31404 = done.call(null,inst_31394);
var inst_31405 = cljs.core.async.take_BANG_.call(null,inst_31403,inst_31404);
var state_31430__$1 = state_31430;
var statearr_31444_31475 = state_31430__$1;
(statearr_31444_31475[(2)] = inst_31405);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31430__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31431 === (9))){
var inst_31394 = (state_31430[(7)]);
var inst_31407 = (state_31430[(2)]);
var inst_31408 = (inst_31394 + (1));
var inst_31394__$1 = inst_31408;
var state_31430__$1 = (function (){var statearr_31445 = state_31430;
(statearr_31445[(7)] = inst_31394__$1);

(statearr_31445[(10)] = inst_31407);

return statearr_31445;
})();
var statearr_31446_31476 = state_31430__$1;
(statearr_31446_31476[(2)] = null);

(statearr_31446_31476[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31431 === (5))){
var inst_31414 = (state_31430[(2)]);
var state_31430__$1 = (function (){var statearr_31447 = state_31430;
(statearr_31447[(11)] = inst_31414);

return statearr_31447;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31430__$1,(12),dchan);
} else {
if((state_val_31431 === (14))){
var inst_31416 = (state_31430[(8)]);
var inst_31421 = cljs.core.apply.call(null,f,inst_31416);
var state_31430__$1 = state_31430;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31430__$1,(16),out,inst_31421);
} else {
if((state_val_31431 === (16))){
var inst_31423 = (state_31430[(2)]);
var state_31430__$1 = (function (){var statearr_31448 = state_31430;
(statearr_31448[(12)] = inst_31423);

return statearr_31448;
})();
var statearr_31449_31477 = state_31430__$1;
(statearr_31449_31477[(2)] = null);

(statearr_31449_31477[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31431 === (10))){
var inst_31398 = (state_31430[(2)]);
var inst_31399 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_31430__$1 = (function (){var statearr_31450 = state_31430;
(statearr_31450[(13)] = inst_31398);

return statearr_31450;
})();
var statearr_31451_31478 = state_31430__$1;
(statearr_31451_31478[(2)] = inst_31399);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31430__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31431 === (8))){
var inst_31412 = (state_31430[(2)]);
var state_31430__$1 = state_31430;
var statearr_31452_31479 = state_31430__$1;
(statearr_31452_31479[(2)] = inst_31412);

(statearr_31452_31479[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29377__auto___31464,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__29263__auto__,c__29377__auto___31464,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__29264__auto__ = null;
var cljs$core$async$state_machine__29264__auto____0 = (function (){
var statearr_31456 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31456[(0)] = cljs$core$async$state_machine__29264__auto__);

(statearr_31456[(1)] = (1));

return statearr_31456;
});
var cljs$core$async$state_machine__29264__auto____1 = (function (state_31430){
while(true){
var ret_value__29265__auto__ = (function (){try{while(true){
var result__29266__auto__ = switch__29263__auto__.call(null,state_31430);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29266__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29266__auto__;
}
break;
}
}catch (e31457){if((e31457 instanceof Object)){
var ex__29267__auto__ = e31457;
var statearr_31458_31480 = state_31430;
(statearr_31458_31480[(5)] = ex__29267__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31430);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31457;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29265__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31481 = state_31430;
state_31430 = G__31481;
continue;
} else {
return ret_value__29265__auto__;
}
break;
}
});
cljs$core$async$state_machine__29264__auto__ = function(state_31430){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29264__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29264__auto____1.call(this,state_31430);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29264__auto____0;
cljs$core$async$state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29264__auto____1;
return cljs$core$async$state_machine__29264__auto__;
})()
;})(switch__29263__auto__,c__29377__auto___31464,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__29379__auto__ = (function (){var statearr_31459 = f__29378__auto__.call(null);
(statearr_31459[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29377__auto___31464);

return statearr_31459;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29379__auto__);
});})(c__29377__auto___31464,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args31483 = [];
var len__27912__auto___31541 = arguments.length;
var i__27913__auto___31542 = (0);
while(true){
if((i__27913__auto___31542 < len__27912__auto___31541)){
args31483.push((arguments[i__27913__auto___31542]));

var G__31543 = (i__27913__auto___31542 + (1));
i__27913__auto___31542 = G__31543;
continue;
} else {
}
break;
}

var G__31485 = args31483.length;
switch (G__31485) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31483.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__29377__auto___31545 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29377__auto___31545,out){
return (function (){
var f__29378__auto__ = (function (){var switch__29263__auto__ = ((function (c__29377__auto___31545,out){
return (function (state_31517){
var state_val_31518 = (state_31517[(1)]);
if((state_val_31518 === (7))){
var inst_31496 = (state_31517[(7)]);
var inst_31497 = (state_31517[(8)]);
var inst_31496__$1 = (state_31517[(2)]);
var inst_31497__$1 = cljs.core.nth.call(null,inst_31496__$1,(0),null);
var inst_31498 = cljs.core.nth.call(null,inst_31496__$1,(1),null);
var inst_31499 = (inst_31497__$1 == null);
var state_31517__$1 = (function (){var statearr_31519 = state_31517;
(statearr_31519[(7)] = inst_31496__$1);

(statearr_31519[(8)] = inst_31497__$1);

(statearr_31519[(9)] = inst_31498);

return statearr_31519;
})();
if(cljs.core.truth_(inst_31499)){
var statearr_31520_31546 = state_31517__$1;
(statearr_31520_31546[(1)] = (8));

} else {
var statearr_31521_31547 = state_31517__$1;
(statearr_31521_31547[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31518 === (1))){
var inst_31486 = cljs.core.vec.call(null,chs);
var inst_31487 = inst_31486;
var state_31517__$1 = (function (){var statearr_31522 = state_31517;
(statearr_31522[(10)] = inst_31487);

return statearr_31522;
})();
var statearr_31523_31548 = state_31517__$1;
(statearr_31523_31548[(2)] = null);

(statearr_31523_31548[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31518 === (4))){
var inst_31487 = (state_31517[(10)]);
var state_31517__$1 = state_31517;
return cljs.core.async.ioc_alts_BANG_.call(null,state_31517__$1,(7),inst_31487);
} else {
if((state_val_31518 === (6))){
var inst_31513 = (state_31517[(2)]);
var state_31517__$1 = state_31517;
var statearr_31524_31549 = state_31517__$1;
(statearr_31524_31549[(2)] = inst_31513);

(statearr_31524_31549[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31518 === (3))){
var inst_31515 = (state_31517[(2)]);
var state_31517__$1 = state_31517;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31517__$1,inst_31515);
} else {
if((state_val_31518 === (2))){
var inst_31487 = (state_31517[(10)]);
var inst_31489 = cljs.core.count.call(null,inst_31487);
var inst_31490 = (inst_31489 > (0));
var state_31517__$1 = state_31517;
if(cljs.core.truth_(inst_31490)){
var statearr_31526_31550 = state_31517__$1;
(statearr_31526_31550[(1)] = (4));

} else {
var statearr_31527_31551 = state_31517__$1;
(statearr_31527_31551[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31518 === (11))){
var inst_31487 = (state_31517[(10)]);
var inst_31506 = (state_31517[(2)]);
var tmp31525 = inst_31487;
var inst_31487__$1 = tmp31525;
var state_31517__$1 = (function (){var statearr_31528 = state_31517;
(statearr_31528[(10)] = inst_31487__$1);

(statearr_31528[(11)] = inst_31506);

return statearr_31528;
})();
var statearr_31529_31552 = state_31517__$1;
(statearr_31529_31552[(2)] = null);

(statearr_31529_31552[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31518 === (9))){
var inst_31497 = (state_31517[(8)]);
var state_31517__$1 = state_31517;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31517__$1,(11),out,inst_31497);
} else {
if((state_val_31518 === (5))){
var inst_31511 = cljs.core.async.close_BANG_.call(null,out);
var state_31517__$1 = state_31517;
var statearr_31530_31553 = state_31517__$1;
(statearr_31530_31553[(2)] = inst_31511);

(statearr_31530_31553[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31518 === (10))){
var inst_31509 = (state_31517[(2)]);
var state_31517__$1 = state_31517;
var statearr_31531_31554 = state_31517__$1;
(statearr_31531_31554[(2)] = inst_31509);

(statearr_31531_31554[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31518 === (8))){
var inst_31496 = (state_31517[(7)]);
var inst_31487 = (state_31517[(10)]);
var inst_31497 = (state_31517[(8)]);
var inst_31498 = (state_31517[(9)]);
var inst_31501 = (function (){var cs = inst_31487;
var vec__31492 = inst_31496;
var v = inst_31497;
var c = inst_31498;
return ((function (cs,vec__31492,v,c,inst_31496,inst_31487,inst_31497,inst_31498,state_val_31518,c__29377__auto___31545,out){
return (function (p1__31482_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__31482_SHARP_);
});
;})(cs,vec__31492,v,c,inst_31496,inst_31487,inst_31497,inst_31498,state_val_31518,c__29377__auto___31545,out))
})();
var inst_31502 = cljs.core.filterv.call(null,inst_31501,inst_31487);
var inst_31487__$1 = inst_31502;
var state_31517__$1 = (function (){var statearr_31532 = state_31517;
(statearr_31532[(10)] = inst_31487__$1);

return statearr_31532;
})();
var statearr_31533_31555 = state_31517__$1;
(statearr_31533_31555[(2)] = null);

(statearr_31533_31555[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__29377__auto___31545,out))
;
return ((function (switch__29263__auto__,c__29377__auto___31545,out){
return (function() {
var cljs$core$async$state_machine__29264__auto__ = null;
var cljs$core$async$state_machine__29264__auto____0 = (function (){
var statearr_31537 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31537[(0)] = cljs$core$async$state_machine__29264__auto__);

(statearr_31537[(1)] = (1));

return statearr_31537;
});
var cljs$core$async$state_machine__29264__auto____1 = (function (state_31517){
while(true){
var ret_value__29265__auto__ = (function (){try{while(true){
var result__29266__auto__ = switch__29263__auto__.call(null,state_31517);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29266__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29266__auto__;
}
break;
}
}catch (e31538){if((e31538 instanceof Object)){
var ex__29267__auto__ = e31538;
var statearr_31539_31556 = state_31517;
(statearr_31539_31556[(5)] = ex__29267__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31517);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31538;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29265__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31557 = state_31517;
state_31517 = G__31557;
continue;
} else {
return ret_value__29265__auto__;
}
break;
}
});
cljs$core$async$state_machine__29264__auto__ = function(state_31517){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29264__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29264__auto____1.call(this,state_31517);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29264__auto____0;
cljs$core$async$state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29264__auto____1;
return cljs$core$async$state_machine__29264__auto__;
})()
;})(switch__29263__auto__,c__29377__auto___31545,out))
})();
var state__29379__auto__ = (function (){var statearr_31540 = f__29378__auto__.call(null);
(statearr_31540[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29377__auto___31545);

return statearr_31540;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29379__auto__);
});})(c__29377__auto___31545,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args31558 = [];
var len__27912__auto___31607 = arguments.length;
var i__27913__auto___31608 = (0);
while(true){
if((i__27913__auto___31608 < len__27912__auto___31607)){
args31558.push((arguments[i__27913__auto___31608]));

var G__31609 = (i__27913__auto___31608 + (1));
i__27913__auto___31608 = G__31609;
continue;
} else {
}
break;
}

var G__31560 = args31558.length;
switch (G__31560) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31558.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__29377__auto___31611 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29377__auto___31611,out){
return (function (){
var f__29378__auto__ = (function (){var switch__29263__auto__ = ((function (c__29377__auto___31611,out){
return (function (state_31584){
var state_val_31585 = (state_31584[(1)]);
if((state_val_31585 === (7))){
var inst_31566 = (state_31584[(7)]);
var inst_31566__$1 = (state_31584[(2)]);
var inst_31567 = (inst_31566__$1 == null);
var inst_31568 = cljs.core.not.call(null,inst_31567);
var state_31584__$1 = (function (){var statearr_31586 = state_31584;
(statearr_31586[(7)] = inst_31566__$1);

return statearr_31586;
})();
if(inst_31568){
var statearr_31587_31612 = state_31584__$1;
(statearr_31587_31612[(1)] = (8));

} else {
var statearr_31588_31613 = state_31584__$1;
(statearr_31588_31613[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31585 === (1))){
var inst_31561 = (0);
var state_31584__$1 = (function (){var statearr_31589 = state_31584;
(statearr_31589[(8)] = inst_31561);

return statearr_31589;
})();
var statearr_31590_31614 = state_31584__$1;
(statearr_31590_31614[(2)] = null);

(statearr_31590_31614[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31585 === (4))){
var state_31584__$1 = state_31584;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31584__$1,(7),ch);
} else {
if((state_val_31585 === (6))){
var inst_31579 = (state_31584[(2)]);
var state_31584__$1 = state_31584;
var statearr_31591_31615 = state_31584__$1;
(statearr_31591_31615[(2)] = inst_31579);

(statearr_31591_31615[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31585 === (3))){
var inst_31581 = (state_31584[(2)]);
var inst_31582 = cljs.core.async.close_BANG_.call(null,out);
var state_31584__$1 = (function (){var statearr_31592 = state_31584;
(statearr_31592[(9)] = inst_31581);

return statearr_31592;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31584__$1,inst_31582);
} else {
if((state_val_31585 === (2))){
var inst_31561 = (state_31584[(8)]);
var inst_31563 = (inst_31561 < n);
var state_31584__$1 = state_31584;
if(cljs.core.truth_(inst_31563)){
var statearr_31593_31616 = state_31584__$1;
(statearr_31593_31616[(1)] = (4));

} else {
var statearr_31594_31617 = state_31584__$1;
(statearr_31594_31617[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31585 === (11))){
var inst_31561 = (state_31584[(8)]);
var inst_31571 = (state_31584[(2)]);
var inst_31572 = (inst_31561 + (1));
var inst_31561__$1 = inst_31572;
var state_31584__$1 = (function (){var statearr_31595 = state_31584;
(statearr_31595[(8)] = inst_31561__$1);

(statearr_31595[(10)] = inst_31571);

return statearr_31595;
})();
var statearr_31596_31618 = state_31584__$1;
(statearr_31596_31618[(2)] = null);

(statearr_31596_31618[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31585 === (9))){
var state_31584__$1 = state_31584;
var statearr_31597_31619 = state_31584__$1;
(statearr_31597_31619[(2)] = null);

(statearr_31597_31619[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31585 === (5))){
var state_31584__$1 = state_31584;
var statearr_31598_31620 = state_31584__$1;
(statearr_31598_31620[(2)] = null);

(statearr_31598_31620[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31585 === (10))){
var inst_31576 = (state_31584[(2)]);
var state_31584__$1 = state_31584;
var statearr_31599_31621 = state_31584__$1;
(statearr_31599_31621[(2)] = inst_31576);

(statearr_31599_31621[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31585 === (8))){
var inst_31566 = (state_31584[(7)]);
var state_31584__$1 = state_31584;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31584__$1,(11),out,inst_31566);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__29377__auto___31611,out))
;
return ((function (switch__29263__auto__,c__29377__auto___31611,out){
return (function() {
var cljs$core$async$state_machine__29264__auto__ = null;
var cljs$core$async$state_machine__29264__auto____0 = (function (){
var statearr_31603 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31603[(0)] = cljs$core$async$state_machine__29264__auto__);

(statearr_31603[(1)] = (1));

return statearr_31603;
});
var cljs$core$async$state_machine__29264__auto____1 = (function (state_31584){
while(true){
var ret_value__29265__auto__ = (function (){try{while(true){
var result__29266__auto__ = switch__29263__auto__.call(null,state_31584);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29266__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29266__auto__;
}
break;
}
}catch (e31604){if((e31604 instanceof Object)){
var ex__29267__auto__ = e31604;
var statearr_31605_31622 = state_31584;
(statearr_31605_31622[(5)] = ex__29267__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31584);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31604;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29265__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31623 = state_31584;
state_31584 = G__31623;
continue;
} else {
return ret_value__29265__auto__;
}
break;
}
});
cljs$core$async$state_machine__29264__auto__ = function(state_31584){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29264__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29264__auto____1.call(this,state_31584);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29264__auto____0;
cljs$core$async$state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29264__auto____1;
return cljs$core$async$state_machine__29264__auto__;
})()
;})(switch__29263__auto__,c__29377__auto___31611,out))
})();
var state__29379__auto__ = (function (){var statearr_31606 = f__29378__auto__.call(null);
(statearr_31606[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29377__auto___31611);

return statearr_31606;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29379__auto__);
});})(c__29377__auto___31611,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async31631 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31631 = (function (f,ch,meta31632){
this.f = f;
this.ch = ch;
this.meta31632 = meta31632;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31631.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31633,meta31632__$1){
var self__ = this;
var _31633__$1 = this;
return (new cljs.core.async.t_cljs$core$async31631(self__.f,self__.ch,meta31632__$1));
});

cljs.core.async.t_cljs$core$async31631.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31633){
var self__ = this;
var _31633__$1 = this;
return self__.meta31632;
});

cljs.core.async.t_cljs$core$async31631.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31631.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async31631.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async31631.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31631.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async31634 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31634 = (function (f,ch,meta31632,_,fn1,meta31635){
this.f = f;
this.ch = ch;
this.meta31632 = meta31632;
this._ = _;
this.fn1 = fn1;
this.meta31635 = meta31635;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31634.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_31636,meta31635__$1){
var self__ = this;
var _31636__$1 = this;
return (new cljs.core.async.t_cljs$core$async31634(self__.f,self__.ch,self__.meta31632,self__._,self__.fn1,meta31635__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async31634.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_31636){
var self__ = this;
var _31636__$1 = this;
return self__.meta31635;
});})(___$1))
;

cljs.core.async.t_cljs$core$async31634.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31634.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async31634.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async31634.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__31624_SHARP_){
return f1.call(null,(((p1__31624_SHARP_ == null))?null:self__.f.call(null,p1__31624_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async31634.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31632","meta31632",-1838297711,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async31631","cljs.core.async/t_cljs$core$async31631",-1908281450,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta31635","meta31635",-134584965,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async31634.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31634.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31634";

cljs.core.async.t_cljs$core$async31634.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__27348__auto__,writer__27349__auto__,opt__27350__auto__){
return cljs.core._write.call(null,writer__27349__auto__,"cljs.core.async/t_cljs$core$async31634");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async31634 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async31634(f__$1,ch__$1,meta31632__$1,___$2,fn1__$1,meta31635){
return (new cljs.core.async.t_cljs$core$async31634(f__$1,ch__$1,meta31632__$1,___$2,fn1__$1,meta31635));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async31634(self__.f,self__.ch,self__.meta31632,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__26684__auto__ = ret;
if(cljs.core.truth_(and__26684__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__26684__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async31631.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31631.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async31631.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31632","meta31632",-1838297711,null)], null);
});

cljs.core.async.t_cljs$core$async31631.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31631.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31631";

cljs.core.async.t_cljs$core$async31631.cljs$lang$ctorPrWriter = (function (this__27348__auto__,writer__27349__auto__,opt__27350__auto__){
return cljs.core._write.call(null,writer__27349__auto__,"cljs.core.async/t_cljs$core$async31631");
});

cljs.core.async.__GT_t_cljs$core$async31631 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async31631(f__$1,ch__$1,meta31632){
return (new cljs.core.async.t_cljs$core$async31631(f__$1,ch__$1,meta31632));
});

}

return (new cljs.core.async.t_cljs$core$async31631(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async31640 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31640 = (function (f,ch,meta31641){
this.f = f;
this.ch = ch;
this.meta31641 = meta31641;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31640.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31642,meta31641__$1){
var self__ = this;
var _31642__$1 = this;
return (new cljs.core.async.t_cljs$core$async31640(self__.f,self__.ch,meta31641__$1));
});

cljs.core.async.t_cljs$core$async31640.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31642){
var self__ = this;
var _31642__$1 = this;
return self__.meta31641;
});

cljs.core.async.t_cljs$core$async31640.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31640.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async31640.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31640.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async31640.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31640.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async31640.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31641","meta31641",-1940793710,null)], null);
});

cljs.core.async.t_cljs$core$async31640.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31640.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31640";

cljs.core.async.t_cljs$core$async31640.cljs$lang$ctorPrWriter = (function (this__27348__auto__,writer__27349__auto__,opt__27350__auto__){
return cljs.core._write.call(null,writer__27349__auto__,"cljs.core.async/t_cljs$core$async31640");
});

cljs.core.async.__GT_t_cljs$core$async31640 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async31640(f__$1,ch__$1,meta31641){
return (new cljs.core.async.t_cljs$core$async31640(f__$1,ch__$1,meta31641));
});

}

return (new cljs.core.async.t_cljs$core$async31640(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async31646 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31646 = (function (p,ch,meta31647){
this.p = p;
this.ch = ch;
this.meta31647 = meta31647;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31646.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31648,meta31647__$1){
var self__ = this;
var _31648__$1 = this;
return (new cljs.core.async.t_cljs$core$async31646(self__.p,self__.ch,meta31647__$1));
});

cljs.core.async.t_cljs$core$async31646.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31648){
var self__ = this;
var _31648__$1 = this;
return self__.meta31647;
});

cljs.core.async.t_cljs$core$async31646.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31646.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async31646.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async31646.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31646.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async31646.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31646.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async31646.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31647","meta31647",-360327350,null)], null);
});

cljs.core.async.t_cljs$core$async31646.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31646.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31646";

cljs.core.async.t_cljs$core$async31646.cljs$lang$ctorPrWriter = (function (this__27348__auto__,writer__27349__auto__,opt__27350__auto__){
return cljs.core._write.call(null,writer__27349__auto__,"cljs.core.async/t_cljs$core$async31646");
});

cljs.core.async.__GT_t_cljs$core$async31646 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async31646(p__$1,ch__$1,meta31647){
return (new cljs.core.async.t_cljs$core$async31646(p__$1,ch__$1,meta31647));
});

}

return (new cljs.core.async.t_cljs$core$async31646(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args31649 = [];
var len__27912__auto___31693 = arguments.length;
var i__27913__auto___31694 = (0);
while(true){
if((i__27913__auto___31694 < len__27912__auto___31693)){
args31649.push((arguments[i__27913__auto___31694]));

var G__31695 = (i__27913__auto___31694 + (1));
i__27913__auto___31694 = G__31695;
continue;
} else {
}
break;
}

var G__31651 = args31649.length;
switch (G__31651) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31649.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__29377__auto___31697 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29377__auto___31697,out){
return (function (){
var f__29378__auto__ = (function (){var switch__29263__auto__ = ((function (c__29377__auto___31697,out){
return (function (state_31672){
var state_val_31673 = (state_31672[(1)]);
if((state_val_31673 === (7))){
var inst_31668 = (state_31672[(2)]);
var state_31672__$1 = state_31672;
var statearr_31674_31698 = state_31672__$1;
(statearr_31674_31698[(2)] = inst_31668);

(statearr_31674_31698[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31673 === (1))){
var state_31672__$1 = state_31672;
var statearr_31675_31699 = state_31672__$1;
(statearr_31675_31699[(2)] = null);

(statearr_31675_31699[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31673 === (4))){
var inst_31654 = (state_31672[(7)]);
var inst_31654__$1 = (state_31672[(2)]);
var inst_31655 = (inst_31654__$1 == null);
var state_31672__$1 = (function (){var statearr_31676 = state_31672;
(statearr_31676[(7)] = inst_31654__$1);

return statearr_31676;
})();
if(cljs.core.truth_(inst_31655)){
var statearr_31677_31700 = state_31672__$1;
(statearr_31677_31700[(1)] = (5));

} else {
var statearr_31678_31701 = state_31672__$1;
(statearr_31678_31701[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31673 === (6))){
var inst_31654 = (state_31672[(7)]);
var inst_31659 = p.call(null,inst_31654);
var state_31672__$1 = state_31672;
if(cljs.core.truth_(inst_31659)){
var statearr_31679_31702 = state_31672__$1;
(statearr_31679_31702[(1)] = (8));

} else {
var statearr_31680_31703 = state_31672__$1;
(statearr_31680_31703[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31673 === (3))){
var inst_31670 = (state_31672[(2)]);
var state_31672__$1 = state_31672;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31672__$1,inst_31670);
} else {
if((state_val_31673 === (2))){
var state_31672__$1 = state_31672;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31672__$1,(4),ch);
} else {
if((state_val_31673 === (11))){
var inst_31662 = (state_31672[(2)]);
var state_31672__$1 = state_31672;
var statearr_31681_31704 = state_31672__$1;
(statearr_31681_31704[(2)] = inst_31662);

(statearr_31681_31704[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31673 === (9))){
var state_31672__$1 = state_31672;
var statearr_31682_31705 = state_31672__$1;
(statearr_31682_31705[(2)] = null);

(statearr_31682_31705[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31673 === (5))){
var inst_31657 = cljs.core.async.close_BANG_.call(null,out);
var state_31672__$1 = state_31672;
var statearr_31683_31706 = state_31672__$1;
(statearr_31683_31706[(2)] = inst_31657);

(statearr_31683_31706[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31673 === (10))){
var inst_31665 = (state_31672[(2)]);
var state_31672__$1 = (function (){var statearr_31684 = state_31672;
(statearr_31684[(8)] = inst_31665);

return statearr_31684;
})();
var statearr_31685_31707 = state_31672__$1;
(statearr_31685_31707[(2)] = null);

(statearr_31685_31707[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31673 === (8))){
var inst_31654 = (state_31672[(7)]);
var state_31672__$1 = state_31672;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31672__$1,(11),out,inst_31654);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__29377__auto___31697,out))
;
return ((function (switch__29263__auto__,c__29377__auto___31697,out){
return (function() {
var cljs$core$async$state_machine__29264__auto__ = null;
var cljs$core$async$state_machine__29264__auto____0 = (function (){
var statearr_31689 = [null,null,null,null,null,null,null,null,null];
(statearr_31689[(0)] = cljs$core$async$state_machine__29264__auto__);

(statearr_31689[(1)] = (1));

return statearr_31689;
});
var cljs$core$async$state_machine__29264__auto____1 = (function (state_31672){
while(true){
var ret_value__29265__auto__ = (function (){try{while(true){
var result__29266__auto__ = switch__29263__auto__.call(null,state_31672);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29266__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29266__auto__;
}
break;
}
}catch (e31690){if((e31690 instanceof Object)){
var ex__29267__auto__ = e31690;
var statearr_31691_31708 = state_31672;
(statearr_31691_31708[(5)] = ex__29267__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31672);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31690;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29265__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31709 = state_31672;
state_31672 = G__31709;
continue;
} else {
return ret_value__29265__auto__;
}
break;
}
});
cljs$core$async$state_machine__29264__auto__ = function(state_31672){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29264__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29264__auto____1.call(this,state_31672);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29264__auto____0;
cljs$core$async$state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29264__auto____1;
return cljs$core$async$state_machine__29264__auto__;
})()
;})(switch__29263__auto__,c__29377__auto___31697,out))
})();
var state__29379__auto__ = (function (){var statearr_31692 = f__29378__auto__.call(null);
(statearr_31692[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29377__auto___31697);

return statearr_31692;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29379__auto__);
});})(c__29377__auto___31697,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args31710 = [];
var len__27912__auto___31713 = arguments.length;
var i__27913__auto___31714 = (0);
while(true){
if((i__27913__auto___31714 < len__27912__auto___31713)){
args31710.push((arguments[i__27913__auto___31714]));

var G__31715 = (i__27913__auto___31714 + (1));
i__27913__auto___31714 = G__31715;
continue;
} else {
}
break;
}

var G__31712 = args31710.length;
switch (G__31712) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31710.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__29377__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29377__auto__){
return (function (){
var f__29378__auto__ = (function (){var switch__29263__auto__ = ((function (c__29377__auto__){
return (function (state_31882){
var state_val_31883 = (state_31882[(1)]);
if((state_val_31883 === (7))){
var inst_31878 = (state_31882[(2)]);
var state_31882__$1 = state_31882;
var statearr_31884_31925 = state_31882__$1;
(statearr_31884_31925[(2)] = inst_31878);

(statearr_31884_31925[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31883 === (20))){
var inst_31848 = (state_31882[(7)]);
var inst_31859 = (state_31882[(2)]);
var inst_31860 = cljs.core.next.call(null,inst_31848);
var inst_31834 = inst_31860;
var inst_31835 = null;
var inst_31836 = (0);
var inst_31837 = (0);
var state_31882__$1 = (function (){var statearr_31885 = state_31882;
(statearr_31885[(8)] = inst_31834);

(statearr_31885[(9)] = inst_31859);

(statearr_31885[(10)] = inst_31836);

(statearr_31885[(11)] = inst_31837);

(statearr_31885[(12)] = inst_31835);

return statearr_31885;
})();
var statearr_31886_31926 = state_31882__$1;
(statearr_31886_31926[(2)] = null);

(statearr_31886_31926[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31883 === (1))){
var state_31882__$1 = state_31882;
var statearr_31887_31927 = state_31882__$1;
(statearr_31887_31927[(2)] = null);

(statearr_31887_31927[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31883 === (4))){
var inst_31823 = (state_31882[(13)]);
var inst_31823__$1 = (state_31882[(2)]);
var inst_31824 = (inst_31823__$1 == null);
var state_31882__$1 = (function (){var statearr_31888 = state_31882;
(statearr_31888[(13)] = inst_31823__$1);

return statearr_31888;
})();
if(cljs.core.truth_(inst_31824)){
var statearr_31889_31928 = state_31882__$1;
(statearr_31889_31928[(1)] = (5));

} else {
var statearr_31890_31929 = state_31882__$1;
(statearr_31890_31929[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31883 === (15))){
var state_31882__$1 = state_31882;
var statearr_31894_31930 = state_31882__$1;
(statearr_31894_31930[(2)] = null);

(statearr_31894_31930[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31883 === (21))){
var state_31882__$1 = state_31882;
var statearr_31895_31931 = state_31882__$1;
(statearr_31895_31931[(2)] = null);

(statearr_31895_31931[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31883 === (13))){
var inst_31834 = (state_31882[(8)]);
var inst_31836 = (state_31882[(10)]);
var inst_31837 = (state_31882[(11)]);
var inst_31835 = (state_31882[(12)]);
var inst_31844 = (state_31882[(2)]);
var inst_31845 = (inst_31837 + (1));
var tmp31891 = inst_31834;
var tmp31892 = inst_31836;
var tmp31893 = inst_31835;
var inst_31834__$1 = tmp31891;
var inst_31835__$1 = tmp31893;
var inst_31836__$1 = tmp31892;
var inst_31837__$1 = inst_31845;
var state_31882__$1 = (function (){var statearr_31896 = state_31882;
(statearr_31896[(8)] = inst_31834__$1);

(statearr_31896[(14)] = inst_31844);

(statearr_31896[(10)] = inst_31836__$1);

(statearr_31896[(11)] = inst_31837__$1);

(statearr_31896[(12)] = inst_31835__$1);

return statearr_31896;
})();
var statearr_31897_31932 = state_31882__$1;
(statearr_31897_31932[(2)] = null);

(statearr_31897_31932[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31883 === (22))){
var state_31882__$1 = state_31882;
var statearr_31898_31933 = state_31882__$1;
(statearr_31898_31933[(2)] = null);

(statearr_31898_31933[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31883 === (6))){
var inst_31823 = (state_31882[(13)]);
var inst_31832 = f.call(null,inst_31823);
var inst_31833 = cljs.core.seq.call(null,inst_31832);
var inst_31834 = inst_31833;
var inst_31835 = null;
var inst_31836 = (0);
var inst_31837 = (0);
var state_31882__$1 = (function (){var statearr_31899 = state_31882;
(statearr_31899[(8)] = inst_31834);

(statearr_31899[(10)] = inst_31836);

(statearr_31899[(11)] = inst_31837);

(statearr_31899[(12)] = inst_31835);

return statearr_31899;
})();
var statearr_31900_31934 = state_31882__$1;
(statearr_31900_31934[(2)] = null);

(statearr_31900_31934[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31883 === (17))){
var inst_31848 = (state_31882[(7)]);
var inst_31852 = cljs.core.chunk_first.call(null,inst_31848);
var inst_31853 = cljs.core.chunk_rest.call(null,inst_31848);
var inst_31854 = cljs.core.count.call(null,inst_31852);
var inst_31834 = inst_31853;
var inst_31835 = inst_31852;
var inst_31836 = inst_31854;
var inst_31837 = (0);
var state_31882__$1 = (function (){var statearr_31901 = state_31882;
(statearr_31901[(8)] = inst_31834);

(statearr_31901[(10)] = inst_31836);

(statearr_31901[(11)] = inst_31837);

(statearr_31901[(12)] = inst_31835);

return statearr_31901;
})();
var statearr_31902_31935 = state_31882__$1;
(statearr_31902_31935[(2)] = null);

(statearr_31902_31935[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31883 === (3))){
var inst_31880 = (state_31882[(2)]);
var state_31882__$1 = state_31882;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31882__$1,inst_31880);
} else {
if((state_val_31883 === (12))){
var inst_31868 = (state_31882[(2)]);
var state_31882__$1 = state_31882;
var statearr_31903_31936 = state_31882__$1;
(statearr_31903_31936[(2)] = inst_31868);

(statearr_31903_31936[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31883 === (2))){
var state_31882__$1 = state_31882;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31882__$1,(4),in$);
} else {
if((state_val_31883 === (23))){
var inst_31876 = (state_31882[(2)]);
var state_31882__$1 = state_31882;
var statearr_31904_31937 = state_31882__$1;
(statearr_31904_31937[(2)] = inst_31876);

(statearr_31904_31937[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31883 === (19))){
var inst_31863 = (state_31882[(2)]);
var state_31882__$1 = state_31882;
var statearr_31905_31938 = state_31882__$1;
(statearr_31905_31938[(2)] = inst_31863);

(statearr_31905_31938[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31883 === (11))){
var inst_31834 = (state_31882[(8)]);
var inst_31848 = (state_31882[(7)]);
var inst_31848__$1 = cljs.core.seq.call(null,inst_31834);
var state_31882__$1 = (function (){var statearr_31906 = state_31882;
(statearr_31906[(7)] = inst_31848__$1);

return statearr_31906;
})();
if(inst_31848__$1){
var statearr_31907_31939 = state_31882__$1;
(statearr_31907_31939[(1)] = (14));

} else {
var statearr_31908_31940 = state_31882__$1;
(statearr_31908_31940[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31883 === (9))){
var inst_31870 = (state_31882[(2)]);
var inst_31871 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_31882__$1 = (function (){var statearr_31909 = state_31882;
(statearr_31909[(15)] = inst_31870);

return statearr_31909;
})();
if(cljs.core.truth_(inst_31871)){
var statearr_31910_31941 = state_31882__$1;
(statearr_31910_31941[(1)] = (21));

} else {
var statearr_31911_31942 = state_31882__$1;
(statearr_31911_31942[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31883 === (5))){
var inst_31826 = cljs.core.async.close_BANG_.call(null,out);
var state_31882__$1 = state_31882;
var statearr_31912_31943 = state_31882__$1;
(statearr_31912_31943[(2)] = inst_31826);

(statearr_31912_31943[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31883 === (14))){
var inst_31848 = (state_31882[(7)]);
var inst_31850 = cljs.core.chunked_seq_QMARK_.call(null,inst_31848);
var state_31882__$1 = state_31882;
if(inst_31850){
var statearr_31913_31944 = state_31882__$1;
(statearr_31913_31944[(1)] = (17));

} else {
var statearr_31914_31945 = state_31882__$1;
(statearr_31914_31945[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31883 === (16))){
var inst_31866 = (state_31882[(2)]);
var state_31882__$1 = state_31882;
var statearr_31915_31946 = state_31882__$1;
(statearr_31915_31946[(2)] = inst_31866);

(statearr_31915_31946[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31883 === (10))){
var inst_31837 = (state_31882[(11)]);
var inst_31835 = (state_31882[(12)]);
var inst_31842 = cljs.core._nth.call(null,inst_31835,inst_31837);
var state_31882__$1 = state_31882;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31882__$1,(13),out,inst_31842);
} else {
if((state_val_31883 === (18))){
var inst_31848 = (state_31882[(7)]);
var inst_31857 = cljs.core.first.call(null,inst_31848);
var state_31882__$1 = state_31882;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31882__$1,(20),out,inst_31857);
} else {
if((state_val_31883 === (8))){
var inst_31836 = (state_31882[(10)]);
var inst_31837 = (state_31882[(11)]);
var inst_31839 = (inst_31837 < inst_31836);
var inst_31840 = inst_31839;
var state_31882__$1 = state_31882;
if(cljs.core.truth_(inst_31840)){
var statearr_31916_31947 = state_31882__$1;
(statearr_31916_31947[(1)] = (10));

} else {
var statearr_31917_31948 = state_31882__$1;
(statearr_31917_31948[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29377__auto__))
;
return ((function (switch__29263__auto__,c__29377__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__29264__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__29264__auto____0 = (function (){
var statearr_31921 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31921[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__29264__auto__);

(statearr_31921[(1)] = (1));

return statearr_31921;
});
var cljs$core$async$mapcat_STAR__$_state_machine__29264__auto____1 = (function (state_31882){
while(true){
var ret_value__29265__auto__ = (function (){try{while(true){
var result__29266__auto__ = switch__29263__auto__.call(null,state_31882);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29266__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29266__auto__;
}
break;
}
}catch (e31922){if((e31922 instanceof Object)){
var ex__29267__auto__ = e31922;
var statearr_31923_31949 = state_31882;
(statearr_31923_31949[(5)] = ex__29267__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31882);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31922;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29265__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31950 = state_31882;
state_31882 = G__31950;
continue;
} else {
return ret_value__29265__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__29264__auto__ = function(state_31882){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__29264__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__29264__auto____1.call(this,state_31882);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__29264__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__29264__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__29264__auto__;
})()
;})(switch__29263__auto__,c__29377__auto__))
})();
var state__29379__auto__ = (function (){var statearr_31924 = f__29378__auto__.call(null);
(statearr_31924[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29377__auto__);

return statearr_31924;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29379__auto__);
});})(c__29377__auto__))
);

return c__29377__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args31951 = [];
var len__27912__auto___31954 = arguments.length;
var i__27913__auto___31955 = (0);
while(true){
if((i__27913__auto___31955 < len__27912__auto___31954)){
args31951.push((arguments[i__27913__auto___31955]));

var G__31956 = (i__27913__auto___31955 + (1));
i__27913__auto___31955 = G__31956;
continue;
} else {
}
break;
}

var G__31953 = args31951.length;
switch (G__31953) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31951.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args31958 = [];
var len__27912__auto___31961 = arguments.length;
var i__27913__auto___31962 = (0);
while(true){
if((i__27913__auto___31962 < len__27912__auto___31961)){
args31958.push((arguments[i__27913__auto___31962]));

var G__31963 = (i__27913__auto___31962 + (1));
i__27913__auto___31962 = G__31963;
continue;
} else {
}
break;
}

var G__31960 = args31958.length;
switch (G__31960) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31958.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args31965 = [];
var len__27912__auto___32016 = arguments.length;
var i__27913__auto___32017 = (0);
while(true){
if((i__27913__auto___32017 < len__27912__auto___32016)){
args31965.push((arguments[i__27913__auto___32017]));

var G__32018 = (i__27913__auto___32017 + (1));
i__27913__auto___32017 = G__32018;
continue;
} else {
}
break;
}

var G__31967 = args31965.length;
switch (G__31967) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31965.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__29377__auto___32020 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29377__auto___32020,out){
return (function (){
var f__29378__auto__ = (function (){var switch__29263__auto__ = ((function (c__29377__auto___32020,out){
return (function (state_31991){
var state_val_31992 = (state_31991[(1)]);
if((state_val_31992 === (7))){
var inst_31986 = (state_31991[(2)]);
var state_31991__$1 = state_31991;
var statearr_31993_32021 = state_31991__$1;
(statearr_31993_32021[(2)] = inst_31986);

(statearr_31993_32021[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31992 === (1))){
var inst_31968 = null;
var state_31991__$1 = (function (){var statearr_31994 = state_31991;
(statearr_31994[(7)] = inst_31968);

return statearr_31994;
})();
var statearr_31995_32022 = state_31991__$1;
(statearr_31995_32022[(2)] = null);

(statearr_31995_32022[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31992 === (4))){
var inst_31971 = (state_31991[(8)]);
var inst_31971__$1 = (state_31991[(2)]);
var inst_31972 = (inst_31971__$1 == null);
var inst_31973 = cljs.core.not.call(null,inst_31972);
var state_31991__$1 = (function (){var statearr_31996 = state_31991;
(statearr_31996[(8)] = inst_31971__$1);

return statearr_31996;
})();
if(inst_31973){
var statearr_31997_32023 = state_31991__$1;
(statearr_31997_32023[(1)] = (5));

} else {
var statearr_31998_32024 = state_31991__$1;
(statearr_31998_32024[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31992 === (6))){
var state_31991__$1 = state_31991;
var statearr_31999_32025 = state_31991__$1;
(statearr_31999_32025[(2)] = null);

(statearr_31999_32025[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31992 === (3))){
var inst_31988 = (state_31991[(2)]);
var inst_31989 = cljs.core.async.close_BANG_.call(null,out);
var state_31991__$1 = (function (){var statearr_32000 = state_31991;
(statearr_32000[(9)] = inst_31988);

return statearr_32000;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31991__$1,inst_31989);
} else {
if((state_val_31992 === (2))){
var state_31991__$1 = state_31991;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31991__$1,(4),ch);
} else {
if((state_val_31992 === (11))){
var inst_31971 = (state_31991[(8)]);
var inst_31980 = (state_31991[(2)]);
var inst_31968 = inst_31971;
var state_31991__$1 = (function (){var statearr_32001 = state_31991;
(statearr_32001[(10)] = inst_31980);

(statearr_32001[(7)] = inst_31968);

return statearr_32001;
})();
var statearr_32002_32026 = state_31991__$1;
(statearr_32002_32026[(2)] = null);

(statearr_32002_32026[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31992 === (9))){
var inst_31971 = (state_31991[(8)]);
var state_31991__$1 = state_31991;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31991__$1,(11),out,inst_31971);
} else {
if((state_val_31992 === (5))){
var inst_31968 = (state_31991[(7)]);
var inst_31971 = (state_31991[(8)]);
var inst_31975 = cljs.core._EQ_.call(null,inst_31971,inst_31968);
var state_31991__$1 = state_31991;
if(inst_31975){
var statearr_32004_32027 = state_31991__$1;
(statearr_32004_32027[(1)] = (8));

} else {
var statearr_32005_32028 = state_31991__$1;
(statearr_32005_32028[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31992 === (10))){
var inst_31983 = (state_31991[(2)]);
var state_31991__$1 = state_31991;
var statearr_32006_32029 = state_31991__$1;
(statearr_32006_32029[(2)] = inst_31983);

(statearr_32006_32029[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31992 === (8))){
var inst_31968 = (state_31991[(7)]);
var tmp32003 = inst_31968;
var inst_31968__$1 = tmp32003;
var state_31991__$1 = (function (){var statearr_32007 = state_31991;
(statearr_32007[(7)] = inst_31968__$1);

return statearr_32007;
})();
var statearr_32008_32030 = state_31991__$1;
(statearr_32008_32030[(2)] = null);

(statearr_32008_32030[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__29377__auto___32020,out))
;
return ((function (switch__29263__auto__,c__29377__auto___32020,out){
return (function() {
var cljs$core$async$state_machine__29264__auto__ = null;
var cljs$core$async$state_machine__29264__auto____0 = (function (){
var statearr_32012 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32012[(0)] = cljs$core$async$state_machine__29264__auto__);

(statearr_32012[(1)] = (1));

return statearr_32012;
});
var cljs$core$async$state_machine__29264__auto____1 = (function (state_31991){
while(true){
var ret_value__29265__auto__ = (function (){try{while(true){
var result__29266__auto__ = switch__29263__auto__.call(null,state_31991);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29266__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29266__auto__;
}
break;
}
}catch (e32013){if((e32013 instanceof Object)){
var ex__29267__auto__ = e32013;
var statearr_32014_32031 = state_31991;
(statearr_32014_32031[(5)] = ex__29267__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31991);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32013;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29265__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32032 = state_31991;
state_31991 = G__32032;
continue;
} else {
return ret_value__29265__auto__;
}
break;
}
});
cljs$core$async$state_machine__29264__auto__ = function(state_31991){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29264__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29264__auto____1.call(this,state_31991);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29264__auto____0;
cljs$core$async$state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29264__auto____1;
return cljs$core$async$state_machine__29264__auto__;
})()
;})(switch__29263__auto__,c__29377__auto___32020,out))
})();
var state__29379__auto__ = (function (){var statearr_32015 = f__29378__auto__.call(null);
(statearr_32015[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29377__auto___32020);

return statearr_32015;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29379__auto__);
});})(c__29377__auto___32020,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args32033 = [];
var len__27912__auto___32103 = arguments.length;
var i__27913__auto___32104 = (0);
while(true){
if((i__27913__auto___32104 < len__27912__auto___32103)){
args32033.push((arguments[i__27913__auto___32104]));

var G__32105 = (i__27913__auto___32104 + (1));
i__27913__auto___32104 = G__32105;
continue;
} else {
}
break;
}

var G__32035 = args32033.length;
switch (G__32035) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32033.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__29377__auto___32107 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29377__auto___32107,out){
return (function (){
var f__29378__auto__ = (function (){var switch__29263__auto__ = ((function (c__29377__auto___32107,out){
return (function (state_32073){
var state_val_32074 = (state_32073[(1)]);
if((state_val_32074 === (7))){
var inst_32069 = (state_32073[(2)]);
var state_32073__$1 = state_32073;
var statearr_32075_32108 = state_32073__$1;
(statearr_32075_32108[(2)] = inst_32069);

(statearr_32075_32108[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32074 === (1))){
var inst_32036 = (new Array(n));
var inst_32037 = inst_32036;
var inst_32038 = (0);
var state_32073__$1 = (function (){var statearr_32076 = state_32073;
(statearr_32076[(7)] = inst_32038);

(statearr_32076[(8)] = inst_32037);

return statearr_32076;
})();
var statearr_32077_32109 = state_32073__$1;
(statearr_32077_32109[(2)] = null);

(statearr_32077_32109[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32074 === (4))){
var inst_32041 = (state_32073[(9)]);
var inst_32041__$1 = (state_32073[(2)]);
var inst_32042 = (inst_32041__$1 == null);
var inst_32043 = cljs.core.not.call(null,inst_32042);
var state_32073__$1 = (function (){var statearr_32078 = state_32073;
(statearr_32078[(9)] = inst_32041__$1);

return statearr_32078;
})();
if(inst_32043){
var statearr_32079_32110 = state_32073__$1;
(statearr_32079_32110[(1)] = (5));

} else {
var statearr_32080_32111 = state_32073__$1;
(statearr_32080_32111[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32074 === (15))){
var inst_32063 = (state_32073[(2)]);
var state_32073__$1 = state_32073;
var statearr_32081_32112 = state_32073__$1;
(statearr_32081_32112[(2)] = inst_32063);

(statearr_32081_32112[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32074 === (13))){
var state_32073__$1 = state_32073;
var statearr_32082_32113 = state_32073__$1;
(statearr_32082_32113[(2)] = null);

(statearr_32082_32113[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32074 === (6))){
var inst_32038 = (state_32073[(7)]);
var inst_32059 = (inst_32038 > (0));
var state_32073__$1 = state_32073;
if(cljs.core.truth_(inst_32059)){
var statearr_32083_32114 = state_32073__$1;
(statearr_32083_32114[(1)] = (12));

} else {
var statearr_32084_32115 = state_32073__$1;
(statearr_32084_32115[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32074 === (3))){
var inst_32071 = (state_32073[(2)]);
var state_32073__$1 = state_32073;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32073__$1,inst_32071);
} else {
if((state_val_32074 === (12))){
var inst_32037 = (state_32073[(8)]);
var inst_32061 = cljs.core.vec.call(null,inst_32037);
var state_32073__$1 = state_32073;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32073__$1,(15),out,inst_32061);
} else {
if((state_val_32074 === (2))){
var state_32073__$1 = state_32073;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32073__$1,(4),ch);
} else {
if((state_val_32074 === (11))){
var inst_32053 = (state_32073[(2)]);
var inst_32054 = (new Array(n));
var inst_32037 = inst_32054;
var inst_32038 = (0);
var state_32073__$1 = (function (){var statearr_32085 = state_32073;
(statearr_32085[(7)] = inst_32038);

(statearr_32085[(8)] = inst_32037);

(statearr_32085[(10)] = inst_32053);

return statearr_32085;
})();
var statearr_32086_32116 = state_32073__$1;
(statearr_32086_32116[(2)] = null);

(statearr_32086_32116[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32074 === (9))){
var inst_32037 = (state_32073[(8)]);
var inst_32051 = cljs.core.vec.call(null,inst_32037);
var state_32073__$1 = state_32073;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32073__$1,(11),out,inst_32051);
} else {
if((state_val_32074 === (5))){
var inst_32038 = (state_32073[(7)]);
var inst_32046 = (state_32073[(11)]);
var inst_32041 = (state_32073[(9)]);
var inst_32037 = (state_32073[(8)]);
var inst_32045 = (inst_32037[inst_32038] = inst_32041);
var inst_32046__$1 = (inst_32038 + (1));
var inst_32047 = (inst_32046__$1 < n);
var state_32073__$1 = (function (){var statearr_32087 = state_32073;
(statearr_32087[(11)] = inst_32046__$1);

(statearr_32087[(12)] = inst_32045);

return statearr_32087;
})();
if(cljs.core.truth_(inst_32047)){
var statearr_32088_32117 = state_32073__$1;
(statearr_32088_32117[(1)] = (8));

} else {
var statearr_32089_32118 = state_32073__$1;
(statearr_32089_32118[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32074 === (14))){
var inst_32066 = (state_32073[(2)]);
var inst_32067 = cljs.core.async.close_BANG_.call(null,out);
var state_32073__$1 = (function (){var statearr_32091 = state_32073;
(statearr_32091[(13)] = inst_32066);

return statearr_32091;
})();
var statearr_32092_32119 = state_32073__$1;
(statearr_32092_32119[(2)] = inst_32067);

(statearr_32092_32119[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32074 === (10))){
var inst_32057 = (state_32073[(2)]);
var state_32073__$1 = state_32073;
var statearr_32093_32120 = state_32073__$1;
(statearr_32093_32120[(2)] = inst_32057);

(statearr_32093_32120[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32074 === (8))){
var inst_32046 = (state_32073[(11)]);
var inst_32037 = (state_32073[(8)]);
var tmp32090 = inst_32037;
var inst_32037__$1 = tmp32090;
var inst_32038 = inst_32046;
var state_32073__$1 = (function (){var statearr_32094 = state_32073;
(statearr_32094[(7)] = inst_32038);

(statearr_32094[(8)] = inst_32037__$1);

return statearr_32094;
})();
var statearr_32095_32121 = state_32073__$1;
(statearr_32095_32121[(2)] = null);

(statearr_32095_32121[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29377__auto___32107,out))
;
return ((function (switch__29263__auto__,c__29377__auto___32107,out){
return (function() {
var cljs$core$async$state_machine__29264__auto__ = null;
var cljs$core$async$state_machine__29264__auto____0 = (function (){
var statearr_32099 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32099[(0)] = cljs$core$async$state_machine__29264__auto__);

(statearr_32099[(1)] = (1));

return statearr_32099;
});
var cljs$core$async$state_machine__29264__auto____1 = (function (state_32073){
while(true){
var ret_value__29265__auto__ = (function (){try{while(true){
var result__29266__auto__ = switch__29263__auto__.call(null,state_32073);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29266__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29266__auto__;
}
break;
}
}catch (e32100){if((e32100 instanceof Object)){
var ex__29267__auto__ = e32100;
var statearr_32101_32122 = state_32073;
(statearr_32101_32122[(5)] = ex__29267__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32073);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32100;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29265__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32123 = state_32073;
state_32073 = G__32123;
continue;
} else {
return ret_value__29265__auto__;
}
break;
}
});
cljs$core$async$state_machine__29264__auto__ = function(state_32073){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29264__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29264__auto____1.call(this,state_32073);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29264__auto____0;
cljs$core$async$state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29264__auto____1;
return cljs$core$async$state_machine__29264__auto__;
})()
;})(switch__29263__auto__,c__29377__auto___32107,out))
})();
var state__29379__auto__ = (function (){var statearr_32102 = f__29378__auto__.call(null);
(statearr_32102[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29377__auto___32107);

return statearr_32102;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29379__auto__);
});})(c__29377__auto___32107,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args32124 = [];
var len__27912__auto___32198 = arguments.length;
var i__27913__auto___32199 = (0);
while(true){
if((i__27913__auto___32199 < len__27912__auto___32198)){
args32124.push((arguments[i__27913__auto___32199]));

var G__32200 = (i__27913__auto___32199 + (1));
i__27913__auto___32199 = G__32200;
continue;
} else {
}
break;
}

var G__32126 = args32124.length;
switch (G__32126) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32124.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__29377__auto___32202 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29377__auto___32202,out){
return (function (){
var f__29378__auto__ = (function (){var switch__29263__auto__ = ((function (c__29377__auto___32202,out){
return (function (state_32168){
var state_val_32169 = (state_32168[(1)]);
if((state_val_32169 === (7))){
var inst_32164 = (state_32168[(2)]);
var state_32168__$1 = state_32168;
var statearr_32170_32203 = state_32168__$1;
(statearr_32170_32203[(2)] = inst_32164);

(statearr_32170_32203[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32169 === (1))){
var inst_32127 = [];
var inst_32128 = inst_32127;
var inst_32129 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_32168__$1 = (function (){var statearr_32171 = state_32168;
(statearr_32171[(7)] = inst_32129);

(statearr_32171[(8)] = inst_32128);

return statearr_32171;
})();
var statearr_32172_32204 = state_32168__$1;
(statearr_32172_32204[(2)] = null);

(statearr_32172_32204[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32169 === (4))){
var inst_32132 = (state_32168[(9)]);
var inst_32132__$1 = (state_32168[(2)]);
var inst_32133 = (inst_32132__$1 == null);
var inst_32134 = cljs.core.not.call(null,inst_32133);
var state_32168__$1 = (function (){var statearr_32173 = state_32168;
(statearr_32173[(9)] = inst_32132__$1);

return statearr_32173;
})();
if(inst_32134){
var statearr_32174_32205 = state_32168__$1;
(statearr_32174_32205[(1)] = (5));

} else {
var statearr_32175_32206 = state_32168__$1;
(statearr_32175_32206[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32169 === (15))){
var inst_32158 = (state_32168[(2)]);
var state_32168__$1 = state_32168;
var statearr_32176_32207 = state_32168__$1;
(statearr_32176_32207[(2)] = inst_32158);

(statearr_32176_32207[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32169 === (13))){
var state_32168__$1 = state_32168;
var statearr_32177_32208 = state_32168__$1;
(statearr_32177_32208[(2)] = null);

(statearr_32177_32208[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32169 === (6))){
var inst_32128 = (state_32168[(8)]);
var inst_32153 = inst_32128.length;
var inst_32154 = (inst_32153 > (0));
var state_32168__$1 = state_32168;
if(cljs.core.truth_(inst_32154)){
var statearr_32178_32209 = state_32168__$1;
(statearr_32178_32209[(1)] = (12));

} else {
var statearr_32179_32210 = state_32168__$1;
(statearr_32179_32210[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32169 === (3))){
var inst_32166 = (state_32168[(2)]);
var state_32168__$1 = state_32168;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32168__$1,inst_32166);
} else {
if((state_val_32169 === (12))){
var inst_32128 = (state_32168[(8)]);
var inst_32156 = cljs.core.vec.call(null,inst_32128);
var state_32168__$1 = state_32168;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32168__$1,(15),out,inst_32156);
} else {
if((state_val_32169 === (2))){
var state_32168__$1 = state_32168;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32168__$1,(4),ch);
} else {
if((state_val_32169 === (11))){
var inst_32136 = (state_32168[(10)]);
var inst_32132 = (state_32168[(9)]);
var inst_32146 = (state_32168[(2)]);
var inst_32147 = [];
var inst_32148 = inst_32147.push(inst_32132);
var inst_32128 = inst_32147;
var inst_32129 = inst_32136;
var state_32168__$1 = (function (){var statearr_32180 = state_32168;
(statearr_32180[(7)] = inst_32129);

(statearr_32180[(11)] = inst_32146);

(statearr_32180[(8)] = inst_32128);

(statearr_32180[(12)] = inst_32148);

return statearr_32180;
})();
var statearr_32181_32211 = state_32168__$1;
(statearr_32181_32211[(2)] = null);

(statearr_32181_32211[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32169 === (9))){
var inst_32128 = (state_32168[(8)]);
var inst_32144 = cljs.core.vec.call(null,inst_32128);
var state_32168__$1 = state_32168;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32168__$1,(11),out,inst_32144);
} else {
if((state_val_32169 === (5))){
var inst_32136 = (state_32168[(10)]);
var inst_32129 = (state_32168[(7)]);
var inst_32132 = (state_32168[(9)]);
var inst_32136__$1 = f.call(null,inst_32132);
var inst_32137 = cljs.core._EQ_.call(null,inst_32136__$1,inst_32129);
var inst_32138 = cljs.core.keyword_identical_QMARK_.call(null,inst_32129,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_32139 = (inst_32137) || (inst_32138);
var state_32168__$1 = (function (){var statearr_32182 = state_32168;
(statearr_32182[(10)] = inst_32136__$1);

return statearr_32182;
})();
if(cljs.core.truth_(inst_32139)){
var statearr_32183_32212 = state_32168__$1;
(statearr_32183_32212[(1)] = (8));

} else {
var statearr_32184_32213 = state_32168__$1;
(statearr_32184_32213[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32169 === (14))){
var inst_32161 = (state_32168[(2)]);
var inst_32162 = cljs.core.async.close_BANG_.call(null,out);
var state_32168__$1 = (function (){var statearr_32186 = state_32168;
(statearr_32186[(13)] = inst_32161);

return statearr_32186;
})();
var statearr_32187_32214 = state_32168__$1;
(statearr_32187_32214[(2)] = inst_32162);

(statearr_32187_32214[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32169 === (10))){
var inst_32151 = (state_32168[(2)]);
var state_32168__$1 = state_32168;
var statearr_32188_32215 = state_32168__$1;
(statearr_32188_32215[(2)] = inst_32151);

(statearr_32188_32215[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32169 === (8))){
var inst_32136 = (state_32168[(10)]);
var inst_32132 = (state_32168[(9)]);
var inst_32128 = (state_32168[(8)]);
var inst_32141 = inst_32128.push(inst_32132);
var tmp32185 = inst_32128;
var inst_32128__$1 = tmp32185;
var inst_32129 = inst_32136;
var state_32168__$1 = (function (){var statearr_32189 = state_32168;
(statearr_32189[(7)] = inst_32129);

(statearr_32189[(8)] = inst_32128__$1);

(statearr_32189[(14)] = inst_32141);

return statearr_32189;
})();
var statearr_32190_32216 = state_32168__$1;
(statearr_32190_32216[(2)] = null);

(statearr_32190_32216[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29377__auto___32202,out))
;
return ((function (switch__29263__auto__,c__29377__auto___32202,out){
return (function() {
var cljs$core$async$state_machine__29264__auto__ = null;
var cljs$core$async$state_machine__29264__auto____0 = (function (){
var statearr_32194 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32194[(0)] = cljs$core$async$state_machine__29264__auto__);

(statearr_32194[(1)] = (1));

return statearr_32194;
});
var cljs$core$async$state_machine__29264__auto____1 = (function (state_32168){
while(true){
var ret_value__29265__auto__ = (function (){try{while(true){
var result__29266__auto__ = switch__29263__auto__.call(null,state_32168);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29266__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29266__auto__;
}
break;
}
}catch (e32195){if((e32195 instanceof Object)){
var ex__29267__auto__ = e32195;
var statearr_32196_32217 = state_32168;
(statearr_32196_32217[(5)] = ex__29267__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32168);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32195;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29265__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32218 = state_32168;
state_32168 = G__32218;
continue;
} else {
return ret_value__29265__auto__;
}
break;
}
});
cljs$core$async$state_machine__29264__auto__ = function(state_32168){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29264__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29264__auto____1.call(this,state_32168);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29264__auto____0;
cljs$core$async$state_machine__29264__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29264__auto____1;
return cljs$core$async$state_machine__29264__auto__;
})()
;})(switch__29263__auto__,c__29377__auto___32202,out))
})();
var state__29379__auto__ = (function (){var statearr_32197 = f__29378__auto__.call(null);
(statearr_32197[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29377__auto___32202);

return statearr_32197;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29379__auto__);
});})(c__29377__auto___32202,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1491498009916