// Compiled by ClojureScript 1.9.293 {}
goog.provide('superv.async');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('cljs.spec');
goog.require('cljs.core.async.impl.protocols');
/**
 * Take the &env from a macro, and tell whether we are expanding into cljs.
 */
superv.async.cljs_env_QMARK_ = (function superv$async$cljs_env_QMARK_(env){
return cljs.core.boolean$.call(null,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(env));
});

/**
 * @interface
 */
superv.async.PSupervisor = function(){};

superv.async._error = (function superv$async$_error(this$){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_error$arity$1 == null)))){
return this$.superv$async$PSupervisor$_error$arity$1(this$);
} else {
var x__48178__auto__ = (((this$ == null))?null:this$);
var m__48179__auto__ = (superv.async._error[goog.typeOf(x__48178__auto__)]);
if(!((m__48179__auto__ == null))){
return m__48179__auto__.call(null,this$);
} else {
var m__48179__auto____$1 = (superv.async._error["_"]);
if(!((m__48179__auto____$1 == null))){
return m__48179__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-error",this$);
}
}
}
});

superv.async._abort = (function superv$async$_abort(this$){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_abort$arity$1 == null)))){
return this$.superv$async$PSupervisor$_abort$arity$1(this$);
} else {
var x__48178__auto__ = (((this$ == null))?null:this$);
var m__48179__auto__ = (superv.async._abort[goog.typeOf(x__48178__auto__)]);
if(!((m__48179__auto__ == null))){
return m__48179__auto__.call(null,this$);
} else {
var m__48179__auto____$1 = (superv.async._abort["_"]);
if(!((m__48179__auto____$1 == null))){
return m__48179__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-abort",this$);
}
}
}
});

superv.async._register_go = (function superv$async$_register_go(this$,body){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_register_go$arity$2 == null)))){
return this$.superv$async$PSupervisor$_register_go$arity$2(this$,body);
} else {
var x__48178__auto__ = (((this$ == null))?null:this$);
var m__48179__auto__ = (superv.async._register_go[goog.typeOf(x__48178__auto__)]);
if(!((m__48179__auto__ == null))){
return m__48179__auto__.call(null,this$,body);
} else {
var m__48179__auto____$1 = (superv.async._register_go["_"]);
if(!((m__48179__auto____$1 == null))){
return m__48179__auto____$1.call(null,this$,body);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-register-go",this$);
}
}
}
});

superv.async._unregister_go = (function superv$async$_unregister_go(this$,id){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_unregister_go$arity$2 == null)))){
return this$.superv$async$PSupervisor$_unregister_go$arity$2(this$,id);
} else {
var x__48178__auto__ = (((this$ == null))?null:this$);
var m__48179__auto__ = (superv.async._unregister_go[goog.typeOf(x__48178__auto__)]);
if(!((m__48179__auto__ == null))){
return m__48179__auto__.call(null,this$,id);
} else {
var m__48179__auto____$1 = (superv.async._unregister_go["_"]);
if(!((m__48179__auto____$1 == null))){
return m__48179__auto____$1.call(null,this$,id);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-unregister-go",this$);
}
}
}
});

superv.async._track_exception = (function superv$async$_track_exception(this$,e){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_track_exception$arity$2 == null)))){
return this$.superv$async$PSupervisor$_track_exception$arity$2(this$,e);
} else {
var x__48178__auto__ = (((this$ == null))?null:this$);
var m__48179__auto__ = (superv.async._track_exception[goog.typeOf(x__48178__auto__)]);
if(!((m__48179__auto__ == null))){
return m__48179__auto__.call(null,this$,e);
} else {
var m__48179__auto____$1 = (superv.async._track_exception["_"]);
if(!((m__48179__auto____$1 == null))){
return m__48179__auto____$1.call(null,this$,e);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-track-exception",this$);
}
}
}
});

superv.async._free_exception = (function superv$async$_free_exception(this$,e){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_free_exception$arity$2 == null)))){
return this$.superv$async$PSupervisor$_free_exception$arity$2(this$,e);
} else {
var x__48178__auto__ = (((this$ == null))?null:this$);
var m__48179__auto__ = (superv.async._free_exception[goog.typeOf(x__48178__auto__)]);
if(!((m__48179__auto__ == null))){
return m__48179__auto__.call(null,this$,e);
} else {
var m__48179__auto____$1 = (superv.async._free_exception["_"]);
if(!((m__48179__auto____$1 == null))){
return m__48179__auto____$1.call(null,this$,e);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-free-exception",this$);
}
}
}
});

superv.async.now = (function superv$async$now(){
return (new Date());
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {superv.async.PSupervisor}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
superv.async.TrackingSupervisor = (function (error,abort,registered,pending_exceptions,__meta,__extmap,__hash){
this.error = error;
this.abort = abort;
this.registered = registered;
this.pending_exceptions = pending_exceptions;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
superv.async.TrackingSupervisor.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__48135__auto__,k__48136__auto__){
var self__ = this;
var this__48135__auto____$1 = this;
return cljs.core._lookup.call(null,this__48135__auto____$1,k__48136__auto__,null);
});

superv.async.TrackingSupervisor.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__48137__auto__,k70206,else__48138__auto__){
var self__ = this;
var this__48137__auto____$1 = this;
var G__70208 = (((k70206 instanceof cljs.core.Keyword))?k70206.fqn:null);
switch (G__70208) {
case "error":
return self__.error;

break;
case "abort":
return self__.abort;

break;
case "registered":
return self__.registered;

break;
case "pending-exceptions":
return self__.pending_exceptions;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k70206,else__48138__auto__);

}
});

superv.async.TrackingSupervisor.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__48149__auto__,writer__48150__auto__,opts__48151__auto__){
var self__ = this;
var this__48149__auto____$1 = this;
var pr_pair__48152__auto__ = ((function (this__48149__auto____$1){
return (function (keyval__48153__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__48150__auto__,cljs.core.pr_writer,""," ","",opts__48151__auto__,keyval__48153__auto__);
});})(this__48149__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__48150__auto__,pr_pair__48152__auto__,"#superv.async.TrackingSupervisor{",", ","}",opts__48151__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error","error",-978969032),self__.error],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abort","abort",521193198),self__.abort],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"registered","registered",-388600037),self__.registered],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),self__.pending_exceptions],null))], null),self__.__extmap));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

superv.async.TrackingSupervisor.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__70205){
var self__ = this;
var G__70205__$1 = this;
return (new cljs.core.RecordIter((0),G__70205__$1,4,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__48133__auto__){
var self__ = this;
var this__48133__auto____$1 = this;
return self__.__meta;
});

superv.async.TrackingSupervisor.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__48129__auto__){
var self__ = this;
var this__48129__auto____$1 = this;
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,self__.__hash));
});

superv.async.TrackingSupervisor.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__48139__auto__){
var self__ = this;
var this__48139__auto____$1 = this;
return (4 + cljs.core.count.call(null,self__.__extmap));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__48130__auto__){
var self__ = this;
var this__48130__auto____$1 = this;
var h__47902__auto__ = self__.__hash;
if(!((h__47902__auto__ == null))){
return h__47902__auto__;
} else {
var h__47902__auto____$1 = cljs.core.hash_imap.call(null,this__48130__auto____$1);
self__.__hash = h__47902__auto____$1;

return h__47902__auto____$1;
}
});

superv.async.TrackingSupervisor.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__48131__auto__,other__48132__auto__){
var self__ = this;
var this__48131__auto____$1 = this;
if(cljs.core.truth_((function (){var and__47453__auto__ = other__48132__auto__;
if(cljs.core.truth_(and__47453__auto__)){
var and__47453__auto____$1 = (this__48131__auto____$1.constructor === other__48132__auto__.constructor);
if(and__47453__auto____$1){
return cljs.core.equiv_map.call(null,this__48131__auto____$1,other__48132__auto__);
} else {
return and__47453__auto____$1;
}
} else {
return and__47453__auto__;
}
})())){
return true;
} else {
return false;
}
});

superv.async.TrackingSupervisor.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__48144__auto__,k__48145__auto__){
var self__ = this;
var this__48144__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),null,new cljs.core.Keyword(null,"abort","abort",521193198),null,new cljs.core.Keyword(null,"error","error",-978969032),null,new cljs.core.Keyword(null,"registered","registered",-388600037),null], null), null),k__48145__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__48144__auto____$1),self__.__meta),k__48145__auto__);
} else {
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__48145__auto__)),null));
}
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$ = cljs.core.PROTOCOL_SENTINEL;

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_error$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.error;
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_abort$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.abort;
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_register_go$arity$2 = (function (this$,body){
var self__ = this;
var this$__$1 = this;
var id = cljs.core.random_uuid.call(null);
cljs.core.swap_BANG_.call(null,self__.registered,cljs.core.assoc,id,body);

return id;
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_unregister_go$arity$2 = (function (this$,id){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.registered,cljs.core.dissoc,id);
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_track_exception$arity$2 = (function (this$,e){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.pending_exceptions,cljs.core.assoc,e,superv.async.now.call(null));
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_free_exception$arity$2 = (function (this$,e){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.pending_exceptions,cljs.core.dissoc,e);
});

superv.async.TrackingSupervisor.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__48142__auto__,k__48143__auto__,G__70205){
var self__ = this;
var this__48142__auto____$1 = this;
var pred__70209 = cljs.core.keyword_identical_QMARK_;
var expr__70210 = k__48143__auto__;
if(cljs.core.truth_(pred__70209.call(null,new cljs.core.Keyword(null,"error","error",-978969032),expr__70210))){
return (new superv.async.TrackingSupervisor(G__70205,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__70209.call(null,new cljs.core.Keyword(null,"abort","abort",521193198),expr__70210))){
return (new superv.async.TrackingSupervisor(self__.error,G__70205,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__70209.call(null,new cljs.core.Keyword(null,"registered","registered",-388600037),expr__70210))){
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,G__70205,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__70209.call(null,new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),expr__70210))){
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,G__70205,self__.__meta,self__.__extmap,null));
} else {
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__48143__auto__,G__70205),null));
}
}
}
}
});

superv.async.TrackingSupervisor.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__48147__auto__){
var self__ = this;
var this__48147__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error","error",-978969032),self__.error],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abort","abort",521193198),self__.abort],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"registered","registered",-388600037),self__.registered],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),self__.pending_exceptions],null))], null),self__.__extmap));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__48134__auto__,G__70205){
var self__ = this;
var this__48134__auto____$1 = this;
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,G__70205,self__.__extmap,self__.__hash));
});

superv.async.TrackingSupervisor.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__48140__auto__,entry__48141__auto__){
var self__ = this;
var this__48140__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__48141__auto__)){
return cljs.core._assoc.call(null,this__48140__auto____$1,cljs.core._nth.call(null,entry__48141__auto__,(0)),cljs.core._nth.call(null,entry__48141__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__48140__auto____$1,entry__48141__auto__);
}
});

superv.async.TrackingSupervisor.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"error","error",661562495,null),new cljs.core.Symbol(null,"abort","abort",-2133242571,null),new cljs.core.Symbol(null,"registered","registered",1251931490,null),new cljs.core.Symbol(null,"pending-exceptions","pending-exceptions",-247748567,null)], null);
});

superv.async.TrackingSupervisor.cljs$lang$type = true;

superv.async.TrackingSupervisor.cljs$lang$ctorPrSeq = (function (this__48171__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"superv.async/TrackingSupervisor");
});

superv.async.TrackingSupervisor.cljs$lang$ctorPrWriter = (function (this__48171__auto__,writer__48172__auto__){
return cljs.core._write.call(null,writer__48172__auto__,"superv.async/TrackingSupervisor");
});

superv.async.__GT_TrackingSupervisor = (function superv$async$__GT_TrackingSupervisor(error,abort,registered,pending_exceptions){
return (new superv.async.TrackingSupervisor(error,abort,registered,pending_exceptions,null,null,null));
});

superv.async.map__GT_TrackingSupervisor = (function superv$async$map__GT_TrackingSupervisor(G__70207){
return (new superv.async.TrackingSupervisor(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(G__70207),new cljs.core.Keyword(null,"abort","abort",521193198).cljs$core$IFn$_invoke$arity$1(G__70207),new cljs.core.Keyword(null,"registered","registered",-388600037).cljs$core$IFn$_invoke$arity$1(G__70207),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(G__70207),null,cljs.core.dissoc.call(null,G__70207,new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094)),null));
});

cljs.core.enable_console_print_BANG_.call(null);
/**
 * A simple supervisor which deals with errors through callbacks. You need to
 *   close its abort channel manually if you want the context to stop. It is
 *   supposed to be used at a boundary to an unsupervised system. If you want
 *   strong supervision, use the restarting-supervisor instead.
 */
superv.async.simple_supervisor = (function superv$async$simple_supervisor(var_args){
var args__48688__auto__ = [];
var len__48681__auto___70237 = arguments.length;
var i__48682__auto___70238 = (0);
while(true){
if((i__48682__auto___70238 < len__48681__auto___70237)){
args__48688__auto__.push((arguments[i__48682__auto___70238]));

var G__70239 = (i__48682__auto___70238 + (1));
i__48682__auto___70238 = G__70239;
continue;
} else {
}
break;
}

var argseq__48689__auto__ = ((((0) < args__48688__auto__.length))?(new cljs.core.IndexedSeq(args__48688__auto__.slice((0)),(0),null)):null);
return superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic(argseq__48689__auto__);
});

superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic = (function (p__70214){
var map__70215 = p__70214;
var map__70215__$1 = ((((!((map__70215 == null)))?((((map__70215.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__70215.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__70215):map__70215);
var stale_timeout = cljs.core.get.call(null,map__70215__$1,new cljs.core.Keyword(null,"stale-timeout","stale-timeout",-468804294),((10) * (1000)));
var error_fn = cljs.core.get.call(null,map__70215__$1,new cljs.core.Keyword(null,"error-fn","error-fn",-171437615),((function (map__70215,map__70215__$1,stale_timeout){
return (function (e){
return cljs.core.println.call(null,"Supervisor:",e,e.stack);
});})(map__70215,map__70215__$1,stale_timeout))
);
var pending_fn = cljs.core.get.call(null,map__70215__$1,new cljs.core.Keyword(null,"pending-fn","pending-fn",1734381755));
var s = superv.async.map__GT_TrackingSupervisor.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.async.chan.call(null),new cljs.core.Keyword(null,"abort","abort",521193198),cljs.core.async.chan.call(null),new cljs.core.Keyword(null,"registered","registered",-388600037),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)], null));
var err_ch = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(s);
cljs.core.async.take_BANG_.call(null,err_ch,((function (s,err_ch,map__70215,map__70215__$1,stale_timeout,error_fn,pending_fn){
return (function superv$async$loop_fn(e){
error_fn.call(null,e);

return cljs.core.async.take_BANG_.call(null,err_ch,superv$async$loop_fn);
});})(s,err_ch,map__70215,map__70215__$1,stale_timeout,error_fn,pending_fn))
);

((function (s,err_ch,map__70215,map__70215__$1,stale_timeout,error_fn,pending_fn){
return (function superv$async$pending(_){
var vec__70227 = cljs.core.filter.call(null,((function (s,err_ch,map__70215,map__70215__$1,stale_timeout,error_fn,pending_fn){
return (function (p__70233){
var vec__70234 = p__70233;
var k = cljs.core.nth.call(null,vec__70234,(0),null);
var v = cljs.core.nth.call(null,vec__70234,(1),null);
return ((superv.async.now.call(null).getTime() - stale_timeout) > v.getTime());
});})(s,err_ch,map__70215,map__70215__$1,stale_timeout,error_fn,pending_fn))
,cljs.core.deref.call(null,new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s)));
var vec__70230 = cljs.core.nth.call(null,vec__70227,(0),null);
var e = cljs.core.nth.call(null,vec__70230,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__70230,(1),null);
if(cljs.core.truth_(e)){
error_fn.call(null,e);

superv.async._free_exception.call(null,s,e);
} else {
}

return cljs.core.async.take_BANG_.call(null,cljs.core.async.timeout.call(null,stale_timeout),superv$async$pending);
});})(s,err_ch,map__70215,map__70215__$1,stale_timeout,error_fn,pending_fn))
.call(null,null);

return s;
});

superv.async.simple_supervisor.cljs$lang$maxFixedArity = (0);

superv.async.simple_supervisor.cljs$lang$applyTo = (function (seq70213){
return superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq70213));
});

superv.async.S = superv.async.simple_supervisor.call(null);
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
superv.async.throw_if_exception = (function superv$async$throw_if_exception(S,x){
if((x instanceof Error)){
superv.async._free_exception.call(null,S,x);

throw cljs.core.ex_info.call(null,[cljs.core.str(x)].join(''),(function (){var or__47465__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__47465__auto__)){
return or__47465__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
superv.async.superv_init = (function superv$async$superv_init(){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [superv.async._error,superv.async._abort,superv.async._register_go,superv.async._unregister_go,superv.async._track_exception,superv.async._free_exception,superv.async.throw_if_exception], null);
});
goog.exportSymbol('superv.async.superv_init', superv.async.superv_init);
superv.async.superv_init.call(null);
superv.async.supervisor_QMARK_ = (function superv$async$supervisor_QMARK_(x){
if(!((x == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === x.superv$async$PSupervisor$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,superv.async.PSupervisor,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,superv.async.PSupervisor,x);
}
});
superv.async.check_supervisor = (function superv$async$check_supervisor(x){
if(cljs.core.truth_(superv.async.supervisor_QMARK_.call(null,x))){
return null;
} else {
throw cljs.core.ex_info.call(null,"First argument is not a supervisor.",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"argument","argument",1183001841),x], null));
}
});
/**
 * Here until http://dev.clojure.org/jira/browse/ASYNC-74 is resolved.
 */
superv.async.chan_QMARK_ = (function superv$async$chan_QMARK_(x){
if(!((x == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$ReadPort$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.ReadPort,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.ReadPort,x);
}
});
/**
 * Same as core.async/take!, but tracks exceptions in supervisor. TODO
 * deal with abortion.
 */
superv.async.take_QMARK_ = (function superv$async$take_QMARK_(var_args){
var args70257 = [];
var len__48681__auto___70260 = arguments.length;
var i__48682__auto___70261 = (0);
while(true){
if((i__48682__auto___70261 < len__48681__auto___70260)){
args70257.push((arguments[i__48682__auto___70261]));

var G__70262 = (i__48682__auto___70261 + (1));
i__48682__auto___70261 = G__70262;
continue;
} else {
}
break;
}

var G__70259 = args70257.length;
switch (G__70259) {
case 3:
return superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args70257.length)].join('')));

}
});

superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (S,port,fn1){
return superv.async.take_QMARK_.call(null,S,port,fn1,true);
});

superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$4 = (function (S,port,fn1,on_caller_QMARK_){
return cljs.core.async.take_BANG_.call(null,port,(function (v){
if((v instanceof Error)){
superv.async._free_exception.call(null,S,v);
} else {
}

return fn1.call(null,v);
}),on_caller_QMARK_);
});

superv.async.take_QMARK_.cljs$lang$maxFixedArity = 4;

/**
 * Same as core.async/put!, but tracks exceptions in supervisor. TODO
 * deal with abortion.
 */
superv.async.put_QMARK_ = (function superv$async$put_QMARK_(var_args){
var args70264 = [];
var len__48681__auto___70267 = arguments.length;
var i__48682__auto___70268 = (0);
while(true){
if((i__48682__auto___70268 < len__48681__auto___70267)){
args70264.push((arguments[i__48682__auto___70268]));

var G__70269 = (i__48682__auto___70268 + (1));
i__48682__auto___70268 = G__70269;
continue;
} else {
}
break;
}

var G__70266 = args70264.length;
switch (G__70266) {
case 3:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args70264.length)].join('')));

}
});

superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (S,port,val){
return superv.async.put_QMARK_.call(null,S,port,val,(function superv$async$noop(_){
return null;
}));
});

superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$4 = (function (S,port,val,fn1){
return superv.async.put_QMARK_.call(null,S,port,val,fn1,true);
});

superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$5 = (function (S,port,val,fn1,on_caller_QMARK_){
return cljs.core.async.put_BANG_.call(null,port,val,(function (ret){
if(((val instanceof Error)) && (!(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data.call(null,val)),new cljs.core.Keyword(null,"aborted","aborted",1775972619))))){
superv.async._track_exception.call(null,S,val);
} else {
}

return fn1.call(null,ret);
}),on_caller_QMARK_);
});

superv.async.put_QMARK_.cljs$lang$maxFixedArity = 5;

/**
 * Same as core.async alts! but throws an exception if the channel returns a
 * throwable object or the context has been aborted.
 */
superv.async.alts_QMARK_ = (function superv$async$alts_QMARK_(var_args){
var args__48688__auto__ = [];
var len__48681__auto___70280 = arguments.length;
var i__48682__auto___70281 = (0);
while(true){
if((i__48682__auto___70281 < len__48681__auto___70280)){
args__48688__auto__.push((arguments[i__48682__auto___70281]));

var G__70282 = (i__48682__auto___70281 + (1));
i__48682__auto___70281 = G__70282;
continue;
} else {
}
break;
}

var argseq__48689__auto__ = ((((2) < args__48688__auto__.length))?(new cljs.core.IndexedSeq(args__48688__auto__.slice((2)),(0),null)):null);
return superv.async.alts_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__48689__auto__);
});

superv.async.alts_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (S,ports,opts){
var abort__68191__auto__ = superv.async._abort.call(null,S);
var to__68192__auto__ = cljs.core.async.timeout.call(null,(0));
var vec__70274 = cljs.core.async.alts_BANG_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [abort__68191__auto__,to__68192__auto__], null),new cljs.core.Keyword(null,"priority","priority",1431093715),true);
var val__68193__auto__ = cljs.core.nth.call(null,vec__70274,(0),null);
var port__68194__auto__ = cljs.core.nth.call(null,vec__70274,(1),null);
if(cljs.core._EQ_.call(null,port__68194__auto__,abort__68191__auto__)){
return cljs.core.ex_info.call(null,"Aborted operations",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"aborted","aborted",1775972619)], null));
} else {
var vec__70277 = cljs.core.apply.call(null,cljs.core.async.alts_BANG_,ports,opts);
var val = cljs.core.nth.call(null,vec__70277,(0),null);
var port = cljs.core.nth.call(null,vec__70277,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [superv.async.throw_if_exception.call(null,S,val),port], null);
}
});

superv.async.alts_QMARK_.cljs$lang$maxFixedArity = (2);

superv.async.alts_QMARK_.cljs$lang$applyTo = (function (seq70271){
var G__70272 = cljs.core.first.call(null,seq70271);
var seq70271__$1 = cljs.core.next.call(null,seq70271);
var G__70273 = cljs.core.first.call(null,seq70271__$1);
var seq70271__$2 = cljs.core.next.call(null,seq70271__$1);
return superv.async.alts_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__70272,G__70273,seq70271__$2);
});

/**
 * Takes objects from in-ch, asynchrously applies function f> (function should
 *   return a channel), takes the result from the returned channel and if it's
 *   truthy, puts it in the out-ch. Returns the closed out-ch. Closes the
 *   returned channel when the input channel has been completely consumed and all
 *   objects have been processed.
 *   If out-ch is not provided, an unbuffered one will be used.
 */
superv.async.pmap_GT__GT_ = (function superv$async$pmap_GT__GT_(var_args){
var args70292 = [];
var len__48681__auto___70495 = arguments.length;
var i__48682__auto___70496 = (0);
while(true){
if((i__48682__auto___70496 < len__48681__auto___70495)){
args70292.push((arguments[i__48682__auto___70496]));

var G__70497 = (i__48682__auto___70496 + (1));
i__48682__auto___70496 = G__70497;
continue;
} else {
}
break;
}

var G__70294 = args70292.length;
switch (G__70294) {
case 4:
return superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args70292.length)].join('')));

}
});

superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$4 = (function (S,f_GT_,parallelism,in_ch){
return superv.async.pmap_GT__GT_.call(null,S,f_GT_,parallelism,cljs.core.async.chan.call(null),in_ch);
});

superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$5 = (function (S,f_GT_,parallelism,out_ch,in_ch){
if(cljs.core.fn_QMARK_.call(null,f_GT_)){
} else {
throw (new Error("Assert failed: (fn? f>)"));
}

if((cljs.core.integer_QMARK_.call(null,parallelism)) && ((parallelism > (0)))){
} else {
throw (new Error("Assert failed: (and (integer? parallelism) (pos? parallelism))"));
}

if((in_ch instanceof cljs.core.async.impl.protocols.ReadPort)){
} else {
throw (new Error("Assert failed: (instance? ReadPort in-ch)"));
}

var threads = cljs.core.atom.call(null,parallelism);
var n__48481__auto___70499 = parallelism;
var __70500 = (0);
while(true){
if((__70500 < n__48481__auto___70499)){
var c__68170__auto___70501 = superv.async.check_supervisor.call(null,superv.async.S);
var id__68171__auto___70502 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"loop","loop",1244978678,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol(null,"when-let","when-let",-1383043480,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"obj","obj",-1672671807,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"in-ch","in-ch",-1757981794,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,"when-let","when-let",-1383043480,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"result","result",-1239343558,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),cljs.core.list(new cljs.core.Symbol(null,"f>","f>",-1169871571,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)))], null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"result","result",-1239343558,null))),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null)))))),cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"zero?","zero?",325758897,null),cljs.core.list(new cljs.core.Symbol(null,"swap!","swap!",-655677516,null),new cljs.core.Symbol(null,"threads","threads",-77267207,null),new cljs.core.Symbol(null,"dec","dec",-766002333,null))),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null)))));
var c__50102__auto___70503 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__70500,c__50102__auto___70503,c__68170__auto___70501,id__68171__auto___70502,n__48481__auto___70499,threads){
return (function (){
var f__50103__auto__ = (function (){var switch__50079__auto__ = ((function (__70500,c__50102__auto___70503,c__68170__auto___70501,id__68171__auto___70502,n__48481__auto___70499,threads){
return (function (state_70429){
var state_val_70430 = (state_70429[(1)]);
if((state_val_70430 === (7))){
var inst_70298 = (state_70429[(7)]);
var inst_70306 = (state_70429[(2)]);
var state_70429__$1 = (function (){var statearr_70431 = state_70429;
(statearr_70431[(8)] = inst_70306);

return statearr_70431;
})();
var statearr_70432_70504 = state_70429__$1;
(statearr_70432_70504[(2)] = inst_70298);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_70429__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70430 === (20))){
var inst_70413 = (state_70429[(2)]);
var state_70429__$1 = state_70429;
var statearr_70433_70505 = state_70429__$1;
(statearr_70433_70505[(2)] = inst_70413);

(statearr_70433_70505[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70430 === (27))){
var inst_70375 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_70376 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_70377 = cljs.core.PersistentHashMap.fromArrays(inst_70375,inst_70376);
var inst_70378 = cljs.core.ex_info.call(null,"Aborted operations",inst_70377);
var state_70429__$1 = state_70429;
var statearr_70434_70506 = state_70429__$1;
(statearr_70434_70506[(2)] = inst_70378);

(statearr_70434_70506[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70430 === (1))){
var state_70429__$1 = state_70429;
var statearr_70435_70507 = state_70429__$1;
(statearr_70435_70507[(2)] = null);

(statearr_70435_70507[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70430 === (24))){
var inst_70357 = (state_70429[(2)]);
var inst_70358 = superv.async.throw_if_exception.call(null,S,inst_70357);
var inst_70359 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_70429__$1 = (function (){var statearr_70436 = state_70429;
(statearr_70436[(9)] = inst_70358);

return statearr_70436;
})();
var statearr_70437_70508 = state_70429__$1;
(statearr_70437_70508[(2)] = inst_70359);

(statearr_70437_70508[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70430 === (39))){
var state_70429__$1 = state_70429;
var statearr_70438_70509 = state_70429__$1;
(statearr_70438_70509[(2)] = null);

(statearr_70438_70509[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70430 === (4))){
var inst_70298 = (state_70429[(7)]);
var inst_70298__$1 = (state_70429[(2)]);
var inst_70299 = cljs.core.ex_data.call(null,inst_70298__$1);
var inst_70300 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_70299);
var inst_70301 = cljs.core._EQ_.call(null,inst_70300,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_70429__$1 = (function (){var statearr_70439 = state_70429;
(statearr_70439[(7)] = inst_70298__$1);

return statearr_70439;
})();
if(inst_70301){
var statearr_70440_70510 = state_70429__$1;
(statearr_70440_70510[(1)] = (5));

} else {
var statearr_70441_70511 = state_70429__$1;
(statearr_70441_70511[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70430 === (15))){
var inst_70331 = (state_70429[(10)]);
var inst_70333 = (inst_70331 instanceof Error);
var state_70429__$1 = state_70429;
if(cljs.core.truth_(inst_70333)){
var statearr_70442_70512 = state_70429__$1;
(statearr_70442_70512[(1)] = (18));

} else {
var statearr_70443_70513 = state_70429__$1;
(statearr_70443_70513[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70430 === (21))){
var inst_70338 = (state_70429[(11)]);
var inst_70344 = (state_70429[(2)]);
var inst_70345 = cljs.core.nth.call(null,inst_70344,(0),null);
var inst_70346 = cljs.core.nth.call(null,inst_70344,(1),null);
var inst_70347 = cljs.core._EQ_.call(null,inst_70346,inst_70338);
var state_70429__$1 = (function (){var statearr_70444 = state_70429;
(statearr_70444[(12)] = inst_70345);

return statearr_70444;
})();
if(inst_70347){
var statearr_70445_70514 = state_70429__$1;
(statearr_70445_70514[(1)] = (22));

} else {
var statearr_70446_70515 = state_70429__$1;
(statearr_70446_70515[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70430 === (31))){
var state_70429__$1 = state_70429;
var statearr_70447_70516 = state_70429__$1;
(statearr_70447_70516[(2)] = null);

(statearr_70447_70516[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70430 === (32))){
var inst_70410 = (state_70429[(2)]);
var state_70429__$1 = (function (){var statearr_70448 = state_70429;
(statearr_70448[(13)] = inst_70410);

return statearr_70448;
})();
var statearr_70449_70517 = state_70429__$1;
(statearr_70449_70517[(2)] = null);

(statearr_70449_70517[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70430 === (40))){
var inst_70425 = (state_70429[(2)]);
var state_70429__$1 = state_70429;
var statearr_70450_70518 = state_70429__$1;
(statearr_70450_70518[(2)] = inst_70425);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_70429__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70430 === (33))){
var inst_70387 = (state_70429[(14)]);
var inst_70393 = (state_70429[(2)]);
var inst_70394 = cljs.core.nth.call(null,inst_70393,(0),null);
var inst_70395 = cljs.core.nth.call(null,inst_70393,(1),null);
var inst_70396 = cljs.core._EQ_.call(null,inst_70395,inst_70387);
var state_70429__$1 = (function (){var statearr_70451 = state_70429;
(statearr_70451[(15)] = inst_70394);

return statearr_70451;
})();
if(inst_70396){
var statearr_70452_70519 = state_70429__$1;
(statearr_70452_70519[(1)] = (34));

} else {
var statearr_70453_70520 = state_70429__$1;
(statearr_70453_70520[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70430 === (13))){
var inst_70320 = (state_70429[(16)]);
var state_70429__$1 = state_70429;
var statearr_70454_70521 = state_70429__$1;
(statearr_70454_70521[(2)] = inst_70320);

(statearr_70454_70521[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70430 === (22))){
var inst_70349 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_70350 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_70351 = cljs.core.PersistentHashMap.fromArrays(inst_70349,inst_70350);
var inst_70352 = cljs.core.ex_info.call(null,"Aborted operations",inst_70351);
var state_70429__$1 = state_70429;
var statearr_70455_70522 = state_70429__$1;
(statearr_70455_70522[(2)] = inst_70352);

(statearr_70455_70522[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70430 === (36))){
var inst_70406 = (state_70429[(2)]);
var inst_70407 = superv.async.throw_if_exception.call(null,S,inst_70406);
var state_70429__$1 = state_70429;
var statearr_70456_70523 = state_70429__$1;
(statearr_70456_70523[(2)] = inst_70407);

(statearr_70456_70523[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70430 === (29))){
var inst_70382 = (state_70429[(17)]);
var inst_70381 = (state_70429[(2)]);
var inst_70382__$1 = superv.async.throw_if_exception.call(null,S,inst_70381);
var state_70429__$1 = (function (){var statearr_70457 = state_70429;
(statearr_70457[(17)] = inst_70382__$1);

return statearr_70457;
})();
if(cljs.core.truth_(inst_70382__$1)){
var statearr_70458_70524 = state_70429__$1;
(statearr_70458_70524[(1)] = (30));

} else {
var statearr_70459_70525 = state_70429__$1;
(statearr_70459_70525[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70430 === (6))){
var inst_70298 = (state_70429[(7)]);
var inst_70304 = superv.async._track_exception.call(null,S,inst_70298);
var state_70429__$1 = state_70429;
var statearr_70460_70526 = state_70429__$1;
(statearr_70460_70526[(2)] = inst_70304);

(statearr_70460_70526[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70430 === (28))){
var inst_70371 = (state_70429[(18)]);
var state_70429__$1 = state_70429;
var statearr_70461_70527 = state_70429__$1;
(statearr_70461_70527[(2)] = inst_70371);

(statearr_70461_70527[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70430 === (25))){
var inst_70355 = (state_70429[(2)]);
var state_70429__$1 = state_70429;
var statearr_70462_70528 = state_70429__$1;
(statearr_70462_70528[(2)] = inst_70355);

(statearr_70462_70528[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70430 === (34))){
var inst_70398 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_70399 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_70400 = cljs.core.PersistentHashMap.fromArrays(inst_70398,inst_70399);
var inst_70401 = cljs.core.ex_info.call(null,"Aborted operations",inst_70400);
var state_70429__$1 = state_70429;
var statearr_70463_70529 = state_70429__$1;
(statearr_70463_70529[(2)] = inst_70401);

(statearr_70463_70529[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70430 === (17))){
var inst_70416 = (state_70429[(2)]);
var state_70429__$1 = state_70429;
var statearr_70464_70530 = state_70429__$1;
(statearr_70464_70530[(2)] = inst_70416);

(statearr_70464_70530[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70430 === (3))){
var inst_70295 = (state_70429[(2)]);
var inst_70296 = superv.async._unregister_go.call(null,S,id__68171__auto___70502);
var state_70429__$1 = (function (){var statearr_70465 = state_70429;
(statearr_70465[(19)] = inst_70295);

(statearr_70465[(20)] = inst_70296);

return statearr_70465;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_70429__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70430 === (12))){
var inst_70324 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_70325 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_70326 = cljs.core.PersistentHashMap.fromArrays(inst_70324,inst_70325);
var inst_70327 = cljs.core.ex_info.call(null,"Aborted operations",inst_70326);
var state_70429__$1 = state_70429;
var statearr_70466_70531 = state_70429__$1;
(statearr_70466_70531[(2)] = inst_70327);

(statearr_70466_70531[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70430 === (2))){
var inst_70427 = (state_70429[(2)]);
var state_70429__$1 = state_70429;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70429__$1,inst_70427);
} else {
if((state_val_70430 === (23))){
var inst_70331 = (state_70429[(10)]);
var state_70429__$1 = state_70429;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_70429__$1,(25),out_ch,inst_70331);
} else {
if((state_val_70430 === (35))){
var inst_70382 = (state_70429[(17)]);
var state_70429__$1 = state_70429;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_70429__$1,(37),out_ch,inst_70382);
} else {
if((state_val_70430 === (19))){
var inst_70331 = (state_70429[(10)]);
var inst_70364 = (state_70429[(21)]);
var inst_70364__$1 = superv.async._abort.call(null,S);
var inst_70365 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70366 = f_GT_.call(null,inst_70331);
var inst_70367 = [inst_70364__$1,inst_70366];
var inst_70368 = (new cljs.core.PersistentVector(null,2,(5),inst_70365,inst_70367,null));
var state_70429__$1 = (function (){var statearr_70467 = state_70429;
(statearr_70467[(21)] = inst_70364__$1);

return statearr_70467;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_70429__$1,(26),inst_70368,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_70430 === (11))){
var inst_70314 = (state_70429[(22)]);
var inst_70319 = (state_70429[(2)]);
var inst_70320 = cljs.core.nth.call(null,inst_70319,(0),null);
var inst_70321 = cljs.core.nth.call(null,inst_70319,(1),null);
var inst_70322 = cljs.core._EQ_.call(null,inst_70321,inst_70314);
var state_70429__$1 = (function (){var statearr_70468 = state_70429;
(statearr_70468[(16)] = inst_70320);

return statearr_70468;
})();
if(inst_70322){
var statearr_70469_70532 = state_70429__$1;
(statearr_70469_70532[(1)] = (12));

} else {
var statearr_70470_70533 = state_70429__$1;
(statearr_70470_70533[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70430 === (9))){
var inst_70314 = (state_70429[(22)]);
var inst_70314__$1 = superv.async._abort.call(null,S);
var inst_70315 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70316 = [inst_70314__$1,in_ch];
var inst_70317 = (new cljs.core.PersistentVector(null,2,(5),inst_70315,inst_70316,null));
var state_70429__$1 = (function (){var statearr_70471 = state_70429;
(statearr_70471[(22)] = inst_70314__$1);

return statearr_70471;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_70429__$1,(11),inst_70317,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_70430 === (5))){
var state_70429__$1 = state_70429;
var statearr_70472_70534 = state_70429__$1;
(statearr_70472_70534[(2)] = null);

(statearr_70472_70534[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70430 === (14))){
var inst_70331 = (state_70429[(10)]);
var inst_70330 = (state_70429[(2)]);
var inst_70331__$1 = superv.async.throw_if_exception.call(null,S,inst_70330);
var state_70429__$1 = (function (){var statearr_70473 = state_70429;
(statearr_70473[(10)] = inst_70331__$1);

return statearr_70473;
})();
if(cljs.core.truth_(inst_70331__$1)){
var statearr_70474_70535 = state_70429__$1;
(statearr_70474_70535[(1)] = (15));

} else {
var statearr_70475_70536 = state_70429__$1;
(statearr_70475_70536[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70430 === (26))){
var inst_70364 = (state_70429[(21)]);
var inst_70370 = (state_70429[(2)]);
var inst_70371 = cljs.core.nth.call(null,inst_70370,(0),null);
var inst_70372 = cljs.core.nth.call(null,inst_70370,(1),null);
var inst_70373 = cljs.core._EQ_.call(null,inst_70372,inst_70364);
var state_70429__$1 = (function (){var statearr_70476 = state_70429;
(statearr_70476[(18)] = inst_70371);

return statearr_70476;
})();
if(inst_70373){
var statearr_70477_70537 = state_70429__$1;
(statearr_70477_70537[(1)] = (27));

} else {
var statearr_70478_70538 = state_70429__$1;
(statearr_70478_70538[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70430 === (16))){
var state_70429__$1 = state_70429;
var statearr_70479_70539 = state_70429__$1;
(statearr_70479_70539[(2)] = null);

(statearr_70479_70539[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70430 === (38))){
var inst_70422 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_70429__$1 = state_70429;
var statearr_70480_70540 = state_70429__$1;
(statearr_70480_70540[(2)] = inst_70422);

(statearr_70480_70540[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70430 === (30))){
var inst_70387 = (state_70429[(14)]);
var inst_70387__$1 = superv.async._abort.call(null,S);
var inst_70388 = cljs.core.async.timeout.call(null,(0));
var inst_70389 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70390 = [inst_70387__$1,inst_70388];
var inst_70391 = (new cljs.core.PersistentVector(null,2,(5),inst_70389,inst_70390,null));
var state_70429__$1 = (function (){var statearr_70481 = state_70429;
(statearr_70481[(14)] = inst_70387__$1);

return statearr_70481;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_70429__$1,(33),inst_70391,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_70430 === (10))){
var inst_70418 = (state_70429[(2)]);
var inst_70419 = cljs.core.swap_BANG_.call(null,threads,cljs.core.dec);
var inst_70420 = (inst_70419 === (0));
var state_70429__$1 = (function (){var statearr_70482 = state_70429;
(statearr_70482[(23)] = inst_70418);

return statearr_70482;
})();
if(cljs.core.truth_(inst_70420)){
var statearr_70483_70541 = state_70429__$1;
(statearr_70483_70541[(1)] = (38));

} else {
var statearr_70484_70542 = state_70429__$1;
(statearr_70484_70542[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70430 === (18))){
var inst_70338 = (state_70429[(11)]);
var inst_70338__$1 = superv.async._abort.call(null,S);
var inst_70339 = cljs.core.async.timeout.call(null,(0));
var inst_70340 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70341 = [inst_70338__$1,inst_70339];
var inst_70342 = (new cljs.core.PersistentVector(null,2,(5),inst_70340,inst_70341,null));
var state_70429__$1 = (function (){var statearr_70485 = state_70429;
(statearr_70485[(11)] = inst_70338__$1);

return statearr_70485;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_70429__$1,(21),inst_70342,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_70430 === (37))){
var inst_70404 = (state_70429[(2)]);
var state_70429__$1 = state_70429;
var statearr_70486_70543 = state_70429__$1;
(statearr_70486_70543[(2)] = inst_70404);

(statearr_70486_70543[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70430 === (8))){
var ___$1 = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_70429,(4),Error,(3),(2));
var state_70429__$1 = state_70429;
var statearr_70487_70544 = state_70429__$1;
(statearr_70487_70544[(2)] = null);

(statearr_70487_70544[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(__70500,c__50102__auto___70503,c__68170__auto___70501,id__68171__auto___70502,n__48481__auto___70499,threads))
;
return ((function (__70500,switch__50079__auto__,c__50102__auto___70503,c__68170__auto___70501,id__68171__auto___70502,n__48481__auto___70499,threads){
return (function() {
var superv$async$state_machine__50080__auto__ = null;
var superv$async$state_machine__50080__auto____0 = (function (){
var statearr_70491 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70491[(0)] = superv$async$state_machine__50080__auto__);

(statearr_70491[(1)] = (1));

return statearr_70491;
});
var superv$async$state_machine__50080__auto____1 = (function (state_70429){
while(true){
var ret_value__50081__auto__ = (function (){try{while(true){
var result__50082__auto__ = switch__50079__auto__.call(null,state_70429);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50082__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50082__auto__;
}
break;
}
}catch (e70492){if((e70492 instanceof Object)){
var ex__50083__auto__ = e70492;
var statearr_70493_70545 = state_70429;
(statearr_70493_70545[(5)] = ex__50083__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_70429);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e70492;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50081__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70546 = state_70429;
state_70429 = G__70546;
continue;
} else {
return ret_value__50081__auto__;
}
break;
}
});
superv$async$state_machine__50080__auto__ = function(state_70429){
switch(arguments.length){
case 0:
return superv$async$state_machine__50080__auto____0.call(this);
case 1:
return superv$async$state_machine__50080__auto____1.call(this,state_70429);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__50080__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__50080__auto____0;
superv$async$state_machine__50080__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__50080__auto____1;
return superv$async$state_machine__50080__auto__;
})()
;})(__70500,switch__50079__auto__,c__50102__auto___70503,c__68170__auto___70501,id__68171__auto___70502,n__48481__auto___70499,threads))
})();
var state__50104__auto__ = (function (){var statearr_70494 = f__50103__auto__.call(null);
(statearr_70494[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__50102__auto___70503);

return statearr_70494;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50104__auto__);
});})(__70500,c__50102__auto___70503,c__68170__auto___70501,id__68171__auto___70502,n__48481__auto___70499,threads))
);


var G__70547 = (__70500 + (1));
__70500 = G__70547;
continue;
} else {
}
break;
}

return out_ch;
});

superv.async.pmap_GT__GT_.cljs$lang$maxFixedArity = 5;

/**
 * Similiar to dorun. Simply takes messages from channels but does nothing with
 *   them. Returns channel that will close when all messages have been consumed.
 */
superv.async.engulf = (function superv$async$engulf(var_args){
var args__48688__auto__ = [];
var len__48681__auto___70628 = arguments.length;
var i__48682__auto___70629 = (0);
while(true){
if((i__48682__auto___70629 < len__48681__auto___70628)){
args__48688__auto__.push((arguments[i__48682__auto___70629]));

var G__70630 = (i__48682__auto___70629 + (1));
i__48682__auto___70629 = G__70630;
continue;
} else {
}
break;
}

var argseq__48689__auto__ = ((((1) < args__48688__auto__.length))?(new cljs.core.IndexedSeq(args__48688__auto__.slice((1)),(0),null)):null);
return superv.async.engulf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__48689__auto__);
});

superv.async.engulf.cljs$core$IFn$_invoke$arity$variadic = (function (S,cs){
var ch = cljs.core.async.merge.call(null,cs);
var c__68170__auto__ = superv.async.check_supervisor.call(null,superv.async.S);
var id__68171__auto__ = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null))))));
var c__50102__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50102__auto__,c__68170__auto__,id__68171__auto__,ch){
return (function (){
var f__50103__auto__ = (function (){var switch__50079__auto__ = ((function (c__50102__auto__,c__68170__auto__,id__68171__auto__,ch){
return (function (state_70597){
var state_val_70598 = (state_70597[(1)]);
if((state_val_70598 === (7))){
var inst_70553 = (state_70597[(7)]);
var inst_70561 = (state_70597[(2)]);
var state_70597__$1 = (function (){var statearr_70599 = state_70597;
(statearr_70599[(8)] = inst_70561);

return statearr_70599;
})();
var statearr_70600_70631 = state_70597__$1;
(statearr_70600_70631[(2)] = inst_70553);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_70597__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70598 === (1))){
var state_70597__$1 = state_70597;
var statearr_70601_70632 = state_70597__$1;
(statearr_70601_70632[(2)] = null);

(statearr_70601_70632[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70598 === (4))){
var inst_70553 = (state_70597[(7)]);
var inst_70553__$1 = (state_70597[(2)]);
var inst_70554 = cljs.core.ex_data.call(null,inst_70553__$1);
var inst_70555 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_70554);
var inst_70556 = cljs.core._EQ_.call(null,inst_70555,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_70597__$1 = (function (){var statearr_70602 = state_70597;
(statearr_70602[(7)] = inst_70553__$1);

return statearr_70602;
})();
if(inst_70556){
var statearr_70603_70633 = state_70597__$1;
(statearr_70603_70633[(1)] = (5));

} else {
var statearr_70604_70634 = state_70597__$1;
(statearr_70604_70634[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70598 === (15))){
var state_70597__$1 = state_70597;
var statearr_70605_70635 = state_70597__$1;
(statearr_70605_70635[(2)] = null);

(statearr_70605_70635[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70598 === (13))){
var inst_70575 = (state_70597[(9)]);
var state_70597__$1 = state_70597;
var statearr_70606_70636 = state_70597__$1;
(statearr_70606_70636[(2)] = inst_70575);

(statearr_70606_70636[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70598 === (6))){
var inst_70553 = (state_70597[(7)]);
var inst_70559 = superv.async._track_exception.call(null,S,inst_70553);
var state_70597__$1 = state_70597;
var statearr_70607_70637 = state_70597__$1;
(statearr_70607_70637[(2)] = inst_70559);

(statearr_70607_70637[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70598 === (17))){
var inst_70591 = (state_70597[(2)]);
var state_70597__$1 = state_70597;
var statearr_70608_70638 = state_70597__$1;
(statearr_70608_70638[(2)] = inst_70591);

(statearr_70608_70638[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70598 === (3))){
var inst_70550 = (state_70597[(2)]);
var inst_70551 = superv.async._unregister_go.call(null,S,id__68171__auto__);
var state_70597__$1 = (function (){var statearr_70609 = state_70597;
(statearr_70609[(10)] = inst_70551);

(statearr_70609[(11)] = inst_70550);

return statearr_70609;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_70597__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70598 === (12))){
var inst_70579 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_70580 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_70581 = cljs.core.PersistentHashMap.fromArrays(inst_70579,inst_70580);
var inst_70582 = cljs.core.ex_info.call(null,"Aborted operations",inst_70581);
var state_70597__$1 = state_70597;
var statearr_70610_70639 = state_70597__$1;
(statearr_70610_70639[(2)] = inst_70582);

(statearr_70610_70639[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70598 === (2))){
var inst_70595 = (state_70597[(2)]);
var state_70597__$1 = state_70597;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70597__$1,inst_70595);
} else {
if((state_val_70598 === (11))){
var inst_70569 = (state_70597[(12)]);
var inst_70574 = (state_70597[(2)]);
var inst_70575 = cljs.core.nth.call(null,inst_70574,(0),null);
var inst_70576 = cljs.core.nth.call(null,inst_70574,(1),null);
var inst_70577 = cljs.core._EQ_.call(null,inst_70576,inst_70569);
var state_70597__$1 = (function (){var statearr_70611 = state_70597;
(statearr_70611[(9)] = inst_70575);

return statearr_70611;
})();
if(inst_70577){
var statearr_70612_70640 = state_70597__$1;
(statearr_70612_70640[(1)] = (12));

} else {
var statearr_70613_70641 = state_70597__$1;
(statearr_70613_70641[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70598 === (9))){
var inst_70569 = (state_70597[(12)]);
var inst_70569__$1 = superv.async._abort.call(null,S);
var inst_70570 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70571 = [inst_70569__$1,ch];
var inst_70572 = (new cljs.core.PersistentVector(null,2,(5),inst_70570,inst_70571,null));
var state_70597__$1 = (function (){var statearr_70614 = state_70597;
(statearr_70614[(12)] = inst_70569__$1);

return statearr_70614;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_70597__$1,(11),inst_70572,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_70598 === (5))){
var state_70597__$1 = state_70597;
var statearr_70615_70642 = state_70597__$1;
(statearr_70615_70642[(2)] = null);

(statearr_70615_70642[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70598 === (14))){
var inst_70585 = (state_70597[(2)]);
var inst_70586 = superv.async.throw_if_exception.call(null,S,inst_70585);
var state_70597__$1 = state_70597;
if(cljs.core.truth_(inst_70586)){
var statearr_70616_70643 = state_70597__$1;
(statearr_70616_70643[(1)] = (15));

} else {
var statearr_70617_70644 = state_70597__$1;
(statearr_70617_70644[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70598 === (16))){
var state_70597__$1 = state_70597;
var statearr_70618_70645 = state_70597__$1;
(statearr_70618_70645[(2)] = null);

(statearr_70618_70645[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70598 === (10))){
var inst_70593 = (state_70597[(2)]);
var state_70597__$1 = state_70597;
var statearr_70619_70646 = state_70597__$1;
(statearr_70619_70646[(2)] = inst_70593);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_70597__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70598 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_70597,(4),Error,(3),(2));
var state_70597__$1 = state_70597;
var statearr_70620_70647 = state_70597__$1;
(statearr_70620_70647[(2)] = null);

(statearr_70620_70647[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__50102__auto__,c__68170__auto__,id__68171__auto__,ch))
;
return ((function (switch__50079__auto__,c__50102__auto__,c__68170__auto__,id__68171__auto__,ch){
return (function() {
var superv$async$state_machine__50080__auto__ = null;
var superv$async$state_machine__50080__auto____0 = (function (){
var statearr_70624 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70624[(0)] = superv$async$state_machine__50080__auto__);

(statearr_70624[(1)] = (1));

return statearr_70624;
});
var superv$async$state_machine__50080__auto____1 = (function (state_70597){
while(true){
var ret_value__50081__auto__ = (function (){try{while(true){
var result__50082__auto__ = switch__50079__auto__.call(null,state_70597);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50082__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50082__auto__;
}
break;
}
}catch (e70625){if((e70625 instanceof Object)){
var ex__50083__auto__ = e70625;
var statearr_70626_70648 = state_70597;
(statearr_70626_70648[(5)] = ex__50083__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_70597);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e70625;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50081__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70649 = state_70597;
state_70597 = G__70649;
continue;
} else {
return ret_value__50081__auto__;
}
break;
}
});
superv$async$state_machine__50080__auto__ = function(state_70597){
switch(arguments.length){
case 0:
return superv$async$state_machine__50080__auto____0.call(this);
case 1:
return superv$async$state_machine__50080__auto____1.call(this,state_70597);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__50080__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__50080__auto____0;
superv$async$state_machine__50080__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__50080__auto____1;
return superv$async$state_machine__50080__auto__;
})()
;})(switch__50079__auto__,c__50102__auto__,c__68170__auto__,id__68171__auto__,ch))
})();
var state__50104__auto__ = (function (){var statearr_70627 = f__50103__auto__.call(null);
(statearr_70627[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__50102__auto__);

return statearr_70627;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50104__auto__);
});})(c__50102__auto__,c__68170__auto__,id__68171__auto__,ch))
);

return c__50102__auto__;
});

superv.async.engulf.cljs$lang$maxFixedArity = (1);

superv.async.engulf.cljs$lang$applyTo = (function (seq70548){
var G__70549 = cljs.core.first.call(null,seq70548);
var seq70548__$1 = cljs.core.next.call(null,seq70548);
return superv.async.engulf.cljs$core$IFn$_invoke$arity$variadic(G__70549,seq70548__$1);
});

/**
 * Performs a reduce on objects from ch with the function f> (which
 *   should return a channel). Returns a channel with the resulting
 *   value.
 */
superv.async.reduce_GT_ = (function superv$async$reduce_GT_(S,f_GT_,acc,ch){
var result = cljs.core.async.chan.call(null);
var c__68170__auto___71016 = superv.async.check_supervisor.call(null,superv.async.S);
var id__68171__auto___71017 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"acc","acc",-1815869457,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null)], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),new cljs.core.Symbol(null,"x","x",-555367584,null)),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"result","result",-1239343558,null),new cljs.core.Symbol(null,"x","x",-555367584,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"result","result",-1239343558,null))),cljs.core.list(new cljs.core.Symbol(null,"->>","->>",-1874332161,null),cljs.core.list(new cljs.core.Symbol(null,"f>","f>",-1169871571,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null),new cljs.core.Symbol(null,"x","x",-555367584,null)),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null)),new cljs.core.Symbol(null,"recur","recur",1202958259,null))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"result","result",-1239343558,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"result","result",-1239343558,null)))))));
var c__50102__auto___71018 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50102__auto___71018,c__68170__auto___71016,id__68171__auto___71017,result){
return (function (){
var f__50103__auto__ = (function (){var switch__50079__auto__ = ((function (c__50102__auto___71018,c__68170__auto___71016,id__68171__auto___71017,result){
return (function (state_70958){
var state_val_70959 = (state_70958[(1)]);
if((state_val_70959 === (7))){
var inst_70836 = (state_70958[(7)]);
var inst_70844 = (state_70958[(2)]);
var state_70958__$1 = (function (){var statearr_70960 = state_70958;
(statearr_70960[(8)] = inst_70844);

return statearr_70960;
})();
var statearr_70961_71019 = state_70958__$1;
(statearr_70961_71019[(2)] = inst_70836);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_70958__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70959 === (20))){
var inst_70924 = (state_70958[(2)]);
var state_70958__$1 = state_70958;
var statearr_70962_71020 = state_70958__$1;
(statearr_70962_71020[(2)] = inst_70924);

(statearr_70962_71020[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70959 === (27))){
var inst_70914 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_70915 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_70916 = cljs.core.PersistentHashMap.fromArrays(inst_70914,inst_70915);
var inst_70917 = cljs.core.ex_info.call(null,"Aborted operations",inst_70916);
var state_70958__$1 = state_70958;
var statearr_70963_71021 = state_70958__$1;
(statearr_70963_71021[(2)] = inst_70917);

(statearr_70963_71021[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70959 === (1))){
var state_70958__$1 = state_70958;
var statearr_70964_71022 = state_70958__$1;
(statearr_70964_71022[(2)] = null);

(statearr_70964_71022[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70959 === (24))){
var inst_70896 = (state_70958[(2)]);
var inst_70897 = superv.async.throw_if_exception.call(null,S,inst_70896);
var inst_70898 = cljs.core.async.close_BANG_.call(null,result);
var state_70958__$1 = (function (){var statearr_70965 = state_70958;
(statearr_70965[(9)] = inst_70897);

return statearr_70965;
})();
var statearr_70966_71023 = state_70958__$1;
(statearr_70966_71023[(2)] = inst_70898);

(statearr_70966_71023[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70959 === (4))){
var inst_70836 = (state_70958[(7)]);
var inst_70836__$1 = (state_70958[(2)]);
var inst_70837 = cljs.core.ex_data.call(null,inst_70836__$1);
var inst_70838 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_70837);
var inst_70839 = cljs.core._EQ_.call(null,inst_70838,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_70958__$1 = (function (){var statearr_70967 = state_70958;
(statearr_70967[(7)] = inst_70836__$1);

return statearr_70967;
})();
if(inst_70839){
var statearr_70968_71024 = state_70958__$1;
(statearr_70968_71024[(1)] = (5));

} else {
var statearr_70969_71025 = state_70958__$1;
(statearr_70969_71025[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70959 === (15))){
var inst_70870 = (state_70958[(10)]);
var inst_70872 = (inst_70870 instanceof Error);
var state_70958__$1 = state_70958;
if(cljs.core.truth_(inst_70872)){
var statearr_70970_71026 = state_70958__$1;
(statearr_70970_71026[(1)] = (18));

} else {
var statearr_70971_71027 = state_70958__$1;
(statearr_70971_71027[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70959 === (21))){
var inst_70877 = (state_70958[(11)]);
var inst_70883 = (state_70958[(2)]);
var inst_70884 = cljs.core.nth.call(null,inst_70883,(0),null);
var inst_70885 = cljs.core.nth.call(null,inst_70883,(1),null);
var inst_70886 = cljs.core._EQ_.call(null,inst_70885,inst_70877);
var state_70958__$1 = (function (){var statearr_70972 = state_70958;
(statearr_70972[(12)] = inst_70884);

return statearr_70972;
})();
if(inst_70886){
var statearr_70973_71028 = state_70958__$1;
(statearr_70973_71028[(1)] = (22));

} else {
var statearr_70974_71029 = state_70958__$1;
(statearr_70974_71029[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70959 === (31))){
var inst_70940 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_70941 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_70942 = cljs.core.PersistentHashMap.fromArrays(inst_70940,inst_70941);
var inst_70943 = cljs.core.ex_info.call(null,"Aborted operations",inst_70942);
var state_70958__$1 = state_70958;
var statearr_70975_71030 = state_70958__$1;
(statearr_70975_71030[(2)] = inst_70943);

(statearr_70975_71030[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70959 === (32))){
var inst_70848 = (state_70958[(13)]);
var state_70958__$1 = state_70958;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_70958__$1,(34),result,inst_70848);
} else {
if((state_val_70959 === (33))){
var inst_70948 = (state_70958[(2)]);
var inst_70949 = superv.async.throw_if_exception.call(null,S,inst_70948);
var inst_70950 = cljs.core.async.close_BANG_.call(null,result);
var state_70958__$1 = (function (){var statearr_70976 = state_70958;
(statearr_70976[(14)] = inst_70949);

return statearr_70976;
})();
var statearr_70977_71031 = state_70958__$1;
(statearr_70977_71031[(2)] = inst_70950);

(statearr_70977_71031[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70959 === (13))){
var inst_70859 = (state_70958[(15)]);
var state_70958__$1 = state_70958;
var statearr_70978_71032 = state_70958__$1;
(statearr_70978_71032[(2)] = inst_70859);

(statearr_70978_71032[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70959 === (22))){
var inst_70888 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_70889 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_70890 = cljs.core.PersistentHashMap.fromArrays(inst_70888,inst_70889);
var inst_70891 = cljs.core.ex_info.call(null,"Aborted operations",inst_70890);
var state_70958__$1 = state_70958;
var statearr_70979_71033 = state_70958__$1;
(statearr_70979_71033[(2)] = inst_70891);

(statearr_70979_71033[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70959 === (29))){
var inst_70920 = (state_70958[(2)]);
var inst_70921 = superv.async.throw_if_exception.call(null,S,inst_70920);
var inst_70848 = inst_70921;
var state_70958__$1 = (function (){var statearr_70980 = state_70958;
(statearr_70980[(13)] = inst_70848);

return statearr_70980;
})();
var statearr_70981_71034 = state_70958__$1;
(statearr_70981_71034[(2)] = null);

(statearr_70981_71034[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70959 === (6))){
var inst_70836 = (state_70958[(7)]);
var inst_70842 = superv.async._track_exception.call(null,S,inst_70836);
var state_70958__$1 = state_70958;
var statearr_70982_71035 = state_70958__$1;
(statearr_70982_71035[(2)] = inst_70842);

(statearr_70982_71035[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70959 === (28))){
var inst_70910 = (state_70958[(16)]);
var state_70958__$1 = state_70958;
var statearr_70983_71036 = state_70958__$1;
(statearr_70983_71036[(2)] = inst_70910);

(statearr_70983_71036[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70959 === (25))){
var inst_70894 = (state_70958[(2)]);
var state_70958__$1 = state_70958;
var statearr_70984_71037 = state_70958__$1;
(statearr_70984_71037[(2)] = inst_70894);

(statearr_70984_71037[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70959 === (34))){
var inst_70946 = (state_70958[(2)]);
var state_70958__$1 = state_70958;
var statearr_70985_71038 = state_70958__$1;
(statearr_70985_71038[(2)] = inst_70946);

(statearr_70985_71038[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70959 === (17))){
var inst_70952 = (state_70958[(2)]);
var state_70958__$1 = state_70958;
var statearr_70986_71039 = state_70958__$1;
(statearr_70986_71039[(2)] = inst_70952);

(statearr_70986_71039[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70959 === (3))){
var inst_70833 = (state_70958[(2)]);
var inst_70834 = superv.async._unregister_go.call(null,S,id__68171__auto___71017);
var state_70958__$1 = (function (){var statearr_70987 = state_70958;
(statearr_70987[(17)] = inst_70834);

(statearr_70987[(18)] = inst_70833);

return statearr_70987;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_70958__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70959 === (12))){
var inst_70863 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_70864 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_70865 = cljs.core.PersistentHashMap.fromArrays(inst_70863,inst_70864);
var inst_70866 = cljs.core.ex_info.call(null,"Aborted operations",inst_70865);
var state_70958__$1 = state_70958;
var statearr_70988_71040 = state_70958__$1;
(statearr_70988_71040[(2)] = inst_70866);

(statearr_70988_71040[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70959 === (2))){
var inst_70956 = (state_70958[(2)]);
var state_70958__$1 = state_70958;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70958__$1,inst_70956);
} else {
if((state_val_70959 === (23))){
var inst_70870 = (state_70958[(10)]);
var state_70958__$1 = state_70958;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_70958__$1,(25),result,inst_70870);
} else {
if((state_val_70959 === (19))){
var inst_70903 = (state_70958[(19)]);
var inst_70848 = (state_70958[(13)]);
var inst_70870 = (state_70958[(10)]);
var inst_70903__$1 = superv.async._abort.call(null,S);
var inst_70904 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70905 = f_GT_.call(null,inst_70848,inst_70870);
var inst_70906 = [inst_70903__$1,inst_70905];
var inst_70907 = (new cljs.core.PersistentVector(null,2,(5),inst_70904,inst_70906,null));
var state_70958__$1 = (function (){var statearr_70989 = state_70958;
(statearr_70989[(19)] = inst_70903__$1);

return statearr_70989;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_70958__$1,(26),inst_70907,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_70959 === (11))){
var inst_70853 = (state_70958[(20)]);
var inst_70858 = (state_70958[(2)]);
var inst_70859 = cljs.core.nth.call(null,inst_70858,(0),null);
var inst_70860 = cljs.core.nth.call(null,inst_70858,(1),null);
var inst_70861 = cljs.core._EQ_.call(null,inst_70860,inst_70853);
var state_70958__$1 = (function (){var statearr_70990 = state_70958;
(statearr_70990[(15)] = inst_70859);

return statearr_70990;
})();
if(inst_70861){
var statearr_70991_71041 = state_70958__$1;
(statearr_70991_71041[(1)] = (12));

} else {
var statearr_70992_71042 = state_70958__$1;
(statearr_70992_71042[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70959 === (9))){
var inst_70853 = (state_70958[(20)]);
var inst_70853__$1 = superv.async._abort.call(null,S);
var inst_70854 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70855 = [inst_70853__$1,ch];
var inst_70856 = (new cljs.core.PersistentVector(null,2,(5),inst_70854,inst_70855,null));
var state_70958__$1 = (function (){var statearr_70993 = state_70958;
(statearr_70993[(20)] = inst_70853__$1);

return statearr_70993;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_70958__$1,(11),inst_70856,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_70959 === (5))){
var state_70958__$1 = state_70958;
var statearr_70994_71043 = state_70958__$1;
(statearr_70994_71043[(2)] = null);

(statearr_70994_71043[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70959 === (14))){
var inst_70870 = (state_70958[(10)]);
var inst_70869 = (state_70958[(2)]);
var inst_70870__$1 = superv.async.throw_if_exception.call(null,S,inst_70869);
var state_70958__$1 = (function (){var statearr_70995 = state_70958;
(statearr_70995[(10)] = inst_70870__$1);

return statearr_70995;
})();
if(cljs.core.truth_(inst_70870__$1)){
var statearr_70996_71044 = state_70958__$1;
(statearr_70996_71044[(1)] = (15));

} else {
var statearr_70997_71045 = state_70958__$1;
(statearr_70997_71045[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70959 === (26))){
var inst_70903 = (state_70958[(19)]);
var inst_70909 = (state_70958[(2)]);
var inst_70910 = cljs.core.nth.call(null,inst_70909,(0),null);
var inst_70911 = cljs.core.nth.call(null,inst_70909,(1),null);
var inst_70912 = cljs.core._EQ_.call(null,inst_70911,inst_70903);
var state_70958__$1 = (function (){var statearr_70998 = state_70958;
(statearr_70998[(16)] = inst_70910);

return statearr_70998;
})();
if(inst_70912){
var statearr_70999_71046 = state_70958__$1;
(statearr_70999_71046[(1)] = (27));

} else {
var statearr_71000_71047 = state_70958__$1;
(statearr_71000_71047[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70959 === (16))){
var inst_70929 = (state_70958[(21)]);
var inst_70929__$1 = superv.async._abort.call(null,S);
var inst_70930 = cljs.core.async.timeout.call(null,(0));
var inst_70931 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70932 = [inst_70929__$1,inst_70930];
var inst_70933 = (new cljs.core.PersistentVector(null,2,(5),inst_70931,inst_70932,null));
var state_70958__$1 = (function (){var statearr_71001 = state_70958;
(statearr_71001[(21)] = inst_70929__$1);

return statearr_71001;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_70958__$1,(30),inst_70933,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_70959 === (30))){
var inst_70929 = (state_70958[(21)]);
var inst_70935 = (state_70958[(2)]);
var inst_70936 = cljs.core.nth.call(null,inst_70935,(0),null);
var inst_70937 = cljs.core.nth.call(null,inst_70935,(1),null);
var inst_70938 = cljs.core._EQ_.call(null,inst_70937,inst_70929);
var state_70958__$1 = (function (){var statearr_71002 = state_70958;
(statearr_71002[(22)] = inst_70936);

return statearr_71002;
})();
if(inst_70938){
var statearr_71003_71048 = state_70958__$1;
(statearr_71003_71048[(1)] = (31));

} else {
var statearr_71004_71049 = state_70958__$1;
(statearr_71004_71049[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70959 === (10))){
var inst_70954 = (state_70958[(2)]);
var state_70958__$1 = state_70958;
var statearr_71005_71050 = state_70958__$1;
(statearr_71005_71050[(2)] = inst_70954);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_70958__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70959 === (18))){
var inst_70877 = (state_70958[(11)]);
var inst_70877__$1 = superv.async._abort.call(null,S);
var inst_70878 = cljs.core.async.timeout.call(null,(0));
var inst_70879 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70880 = [inst_70877__$1,inst_70878];
var inst_70881 = (new cljs.core.PersistentVector(null,2,(5),inst_70879,inst_70880,null));
var state_70958__$1 = (function (){var statearr_71006 = state_70958;
(statearr_71006[(11)] = inst_70877__$1);

return statearr_71006;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_70958__$1,(21),inst_70881,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_70959 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_70958,(4),Error,(3),(2));
var inst_70848 = acc;
var state_70958__$1 = (function (){var statearr_71007 = state_70958;
(statearr_71007[(13)] = inst_70848);

return statearr_71007;
})();
var statearr_71008_71051 = state_70958__$1;
(statearr_71008_71051[(2)] = null);

(statearr_71008_71051[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__50102__auto___71018,c__68170__auto___71016,id__68171__auto___71017,result))
;
return ((function (switch__50079__auto__,c__50102__auto___71018,c__68170__auto___71016,id__68171__auto___71017,result){
return (function() {
var superv$async$reduce_GT__$_state_machine__50080__auto__ = null;
var superv$async$reduce_GT__$_state_machine__50080__auto____0 = (function (){
var statearr_71012 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71012[(0)] = superv$async$reduce_GT__$_state_machine__50080__auto__);

(statearr_71012[(1)] = (1));

return statearr_71012;
});
var superv$async$reduce_GT__$_state_machine__50080__auto____1 = (function (state_70958){
while(true){
var ret_value__50081__auto__ = (function (){try{while(true){
var result__50082__auto__ = switch__50079__auto__.call(null,state_70958);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50082__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50082__auto__;
}
break;
}
}catch (e71013){if((e71013 instanceof Object)){
var ex__50083__auto__ = e71013;
var statearr_71014_71052 = state_70958;
(statearr_71014_71052[(5)] = ex__50083__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_70958);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e71013;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50081__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71053 = state_70958;
state_70958 = G__71053;
continue;
} else {
return ret_value__50081__auto__;
}
break;
}
});
superv$async$reduce_GT__$_state_machine__50080__auto__ = function(state_70958){
switch(arguments.length){
case 0:
return superv$async$reduce_GT__$_state_machine__50080__auto____0.call(this);
case 1:
return superv$async$reduce_GT__$_state_machine__50080__auto____1.call(this,state_70958);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$reduce_GT__$_state_machine__50080__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$reduce_GT__$_state_machine__50080__auto____0;
superv$async$reduce_GT__$_state_machine__50080__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$reduce_GT__$_state_machine__50080__auto____1;
return superv$async$reduce_GT__$_state_machine__50080__auto__;
})()
;})(switch__50079__auto__,c__50102__auto___71018,c__68170__auto___71016,id__68171__auto___71017,result))
})();
var state__50104__auto__ = (function (){var statearr_71015 = f__50103__auto__.call(null);
(statearr_71015[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__50102__auto___71018);

return statearr_71015;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50104__auto__);
});})(c__50102__auto___71018,c__68170__auto___71016,id__68171__auto___71017,result))
);


return result;
});
/**
 * Concatenates two or more channels. First takes all values from first channel
 *   and supplies to output channel, then takes all values from second channel and
 *   so on. Similiar to core.async/merge but maintains the order of values.
 */
superv.async.concat_GT__GT_ = (function superv$async$concat_GT__GT_(var_args){
var args__48688__auto__ = [];
var len__48681__auto___71183 = arguments.length;
var i__48682__auto___71184 = (0);
while(true){
if((i__48682__auto___71184 < len__48681__auto___71183)){
args__48688__auto__.push((arguments[i__48682__auto___71184]));

var G__71185 = (i__48682__auto___71184 + (1));
i__48682__auto___71184 = G__71185;
continue;
} else {
}
break;
}

var argseq__48689__auto__ = ((((1) < args__48688__auto__.length))?(new cljs.core.IndexedSeq(args__48688__auto__.slice((1)),(0),null)):null);
return superv.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__48689__auto__);
});

superv.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (S,cs){
var out = cljs.core.async.chan.call(null);
var c__68170__auto___71186 = superv.async.check_supervisor.call(null,superv.async.S);
var id__68171__auto___71187 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"loop","loop",1244978678,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null)], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"c","c",-122660552,null),cljs.core.list(new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"c","c",-122660552,null))], null),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"v","v",1661996586,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null))),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),cljs.core.list(new cljs.core.Symbol(null,"rest","rest",398835108,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null)))),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out","out",729986010,null))))));
var c__50102__auto___71188 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50102__auto___71188,c__68170__auto___71186,id__68171__auto___71187,out){
return (function (){
var f__50103__auto__ = (function (){var switch__50079__auto__ = ((function (c__50102__auto___71188,c__68170__auto___71186,id__68171__auto___71187,out){
return (function (state_71136){
var state_val_71137 = (state_71136[(1)]);
if((state_val_71137 === (7))){
var inst_71059 = (state_71136[(7)]);
var inst_71067 = (state_71136[(2)]);
var state_71136__$1 = (function (){var statearr_71139 = state_71136;
(statearr_71139[(8)] = inst_71067);

return statearr_71139;
})();
var statearr_71140_71189 = state_71136__$1;
(statearr_71140_71189[(2)] = inst_71059);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71136__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71137 === (20))){
var inst_71126 = (state_71136[(2)]);
var state_71136__$1 = state_71136;
var statearr_71141_71190 = state_71136__$1;
(statearr_71141_71190[(2)] = inst_71126);

(statearr_71141_71190[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71137 === (1))){
var state_71136__$1 = state_71136;
var statearr_71142_71191 = state_71136__$1;
(statearr_71142_71191[(2)] = null);

(statearr_71142_71191[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71137 === (24))){
var inst_71071 = (state_71136[(9)]);
var inst_71119 = (state_71136[(2)]);
var inst_71120 = superv.async.throw_if_exception.call(null,S,inst_71119);
var tmp71138 = inst_71071;
var inst_71071__$1 = tmp71138;
var state_71136__$1 = (function (){var statearr_71143 = state_71136;
(statearr_71143[(10)] = inst_71120);

(statearr_71143[(9)] = inst_71071__$1);

return statearr_71143;
})();
var statearr_71144_71192 = state_71136__$1;
(statearr_71144_71192[(2)] = null);

(statearr_71144_71192[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71137 === (4))){
var inst_71059 = (state_71136[(7)]);
var inst_71059__$1 = (state_71136[(2)]);
var inst_71060 = cljs.core.ex_data.call(null,inst_71059__$1);
var inst_71061 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_71060);
var inst_71062 = cljs.core._EQ_.call(null,inst_71061,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_71136__$1 = (function (){var statearr_71145 = state_71136;
(statearr_71145[(7)] = inst_71059__$1);

return statearr_71145;
})();
if(inst_71062){
var statearr_71146_71193 = state_71136__$1;
(statearr_71146_71193[(1)] = (5));

} else {
var statearr_71147_71194 = state_71136__$1;
(statearr_71147_71194[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71137 === (15))){
var inst_71088 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_71089 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_71090 = cljs.core.PersistentHashMap.fromArrays(inst_71088,inst_71089);
var inst_71091 = cljs.core.ex_info.call(null,"Aborted operations",inst_71090);
var state_71136__$1 = state_71136;
var statearr_71148_71195 = state_71136__$1;
(statearr_71148_71195[(2)] = inst_71091);

(statearr_71148_71195[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71137 === (21))){
var inst_71100 = (state_71136[(11)]);
var inst_71106 = (state_71136[(2)]);
var inst_71107 = cljs.core.nth.call(null,inst_71106,(0),null);
var inst_71108 = cljs.core.nth.call(null,inst_71106,(1),null);
var inst_71109 = cljs.core._EQ_.call(null,inst_71108,inst_71100);
var state_71136__$1 = (function (){var statearr_71149 = state_71136;
(statearr_71149[(12)] = inst_71107);

return statearr_71149;
})();
if(inst_71109){
var statearr_71150_71196 = state_71136__$1;
(statearr_71150_71196[(1)] = (22));

} else {
var statearr_71151_71197 = state_71136__$1;
(statearr_71151_71197[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71137 === (13))){
var inst_71130 = (state_71136[(2)]);
var state_71136__$1 = state_71136;
var statearr_71152_71198 = state_71136__$1;
(statearr_71152_71198[(2)] = inst_71130);

(statearr_71152_71198[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71137 === (22))){
var inst_71111 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_71112 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_71113 = cljs.core.PersistentHashMap.fromArrays(inst_71111,inst_71112);
var inst_71114 = cljs.core.ex_info.call(null,"Aborted operations",inst_71113);
var state_71136__$1 = state_71136;
var statearr_71153_71199 = state_71136__$1;
(statearr_71153_71199[(2)] = inst_71114);

(statearr_71153_71199[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71137 === (6))){
var inst_71059 = (state_71136[(7)]);
var inst_71065 = superv.async._track_exception.call(null,S,inst_71059);
var state_71136__$1 = state_71136;
var statearr_71154_71200 = state_71136__$1;
(statearr_71154_71200[(2)] = inst_71065);

(statearr_71154_71200[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71137 === (25))){
var inst_71117 = (state_71136[(2)]);
var state_71136__$1 = state_71136;
var statearr_71155_71201 = state_71136__$1;
(statearr_71155_71201[(2)] = inst_71117);

(statearr_71155_71201[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71137 === (17))){
var inst_71095 = (state_71136[(13)]);
var inst_71094 = (state_71136[(2)]);
var inst_71095__$1 = superv.async.throw_if_exception.call(null,S,inst_71094);
var state_71136__$1 = (function (){var statearr_71156 = state_71136;
(statearr_71156[(13)] = inst_71095__$1);

return statearr_71156;
})();
if(cljs.core.truth_(inst_71095__$1)){
var statearr_71157_71202 = state_71136__$1;
(statearr_71157_71202[(1)] = (18));

} else {
var statearr_71158_71203 = state_71136__$1;
(statearr_71158_71203[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71137 === (3))){
var inst_71056 = (state_71136[(2)]);
var inst_71057 = superv.async._unregister_go.call(null,S,id__68171__auto___71187);
var state_71136__$1 = (function (){var statearr_71159 = state_71136;
(statearr_71159[(14)] = inst_71056);

(statearr_71159[(15)] = inst_71057);

return statearr_71159;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71136__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71137 === (12))){
var inst_71128 = cljs.core.async.close_BANG_.call(null,out);
var state_71136__$1 = state_71136;
var statearr_71160_71204 = state_71136__$1;
(statearr_71160_71204[(2)] = inst_71128);

(statearr_71160_71204[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71137 === (2))){
var inst_71134 = (state_71136[(2)]);
var state_71136__$1 = state_71136;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71136__$1,inst_71134);
} else {
if((state_val_71137 === (23))){
var inst_71095 = (state_71136[(13)]);
var state_71136__$1 = state_71136;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_71136__$1,(25),out,inst_71095);
} else {
if((state_val_71137 === (19))){
var inst_71071 = (state_71136[(9)]);
var inst_71123 = cljs.core.rest.call(null,inst_71071);
var inst_71071__$1 = inst_71123;
var state_71136__$1 = (function (){var statearr_71161 = state_71136;
(statearr_71161[(9)] = inst_71071__$1);

return statearr_71161;
})();
var statearr_71162_71205 = state_71136__$1;
(statearr_71162_71205[(2)] = null);

(statearr_71162_71205[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71137 === (11))){
var inst_71073 = (state_71136[(16)]);
var inst_71078 = (state_71136[(17)]);
var inst_71078__$1 = superv.async._abort.call(null,S);
var inst_71079 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71080 = [inst_71078__$1,inst_71073];
var inst_71081 = (new cljs.core.PersistentVector(null,2,(5),inst_71079,inst_71080,null));
var state_71136__$1 = (function (){var statearr_71163 = state_71136;
(statearr_71163[(17)] = inst_71078__$1);

return statearr_71163;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_71136__$1,(14),inst_71081,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_71137 === (9))){
var inst_71073 = (state_71136[(16)]);
var inst_71071 = (state_71136[(9)]);
var inst_71073__$1 = cljs.core.first.call(null,inst_71071);
var state_71136__$1 = (function (){var statearr_71164 = state_71136;
(statearr_71164[(16)] = inst_71073__$1);

return statearr_71164;
})();
if(cljs.core.truth_(inst_71073__$1)){
var statearr_71165_71206 = state_71136__$1;
(statearr_71165_71206[(1)] = (11));

} else {
var statearr_71166_71207 = state_71136__$1;
(statearr_71166_71207[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71137 === (5))){
var state_71136__$1 = state_71136;
var statearr_71167_71208 = state_71136__$1;
(statearr_71167_71208[(2)] = null);

(statearr_71167_71208[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71137 === (14))){
var inst_71078 = (state_71136[(17)]);
var inst_71083 = (state_71136[(2)]);
var inst_71084 = cljs.core.nth.call(null,inst_71083,(0),null);
var inst_71085 = cljs.core.nth.call(null,inst_71083,(1),null);
var inst_71086 = cljs.core._EQ_.call(null,inst_71085,inst_71078);
var state_71136__$1 = (function (){var statearr_71168 = state_71136;
(statearr_71168[(18)] = inst_71084);

return statearr_71168;
})();
if(inst_71086){
var statearr_71169_71209 = state_71136__$1;
(statearr_71169_71209[(1)] = (15));

} else {
var statearr_71170_71210 = state_71136__$1;
(statearr_71170_71210[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71137 === (16))){
var inst_71084 = (state_71136[(18)]);
var state_71136__$1 = state_71136;
var statearr_71171_71211 = state_71136__$1;
(statearr_71171_71211[(2)] = inst_71084);

(statearr_71171_71211[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71137 === (10))){
var inst_71132 = (state_71136[(2)]);
var state_71136__$1 = state_71136;
var statearr_71172_71212 = state_71136__$1;
(statearr_71172_71212[(2)] = inst_71132);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71136__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71137 === (18))){
var inst_71100 = (state_71136[(11)]);
var inst_71100__$1 = superv.async._abort.call(null,S);
var inst_71101 = cljs.core.async.timeout.call(null,(0));
var inst_71102 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71103 = [inst_71100__$1,inst_71101];
var inst_71104 = (new cljs.core.PersistentVector(null,2,(5),inst_71102,inst_71103,null));
var state_71136__$1 = (function (){var statearr_71173 = state_71136;
(statearr_71173[(11)] = inst_71100__$1);

return statearr_71173;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_71136__$1,(21),inst_71104,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_71137 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_71136,(4),Error,(3),(2));
var inst_71071 = cs;
var state_71136__$1 = (function (){var statearr_71174 = state_71136;
(statearr_71174[(9)] = inst_71071);

return statearr_71174;
})();
var statearr_71175_71213 = state_71136__$1;
(statearr_71175_71213[(2)] = null);

(statearr_71175_71213[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__50102__auto___71188,c__68170__auto___71186,id__68171__auto___71187,out))
;
return ((function (switch__50079__auto__,c__50102__auto___71188,c__68170__auto___71186,id__68171__auto___71187,out){
return (function() {
var superv$async$state_machine__50080__auto__ = null;
var superv$async$state_machine__50080__auto____0 = (function (){
var statearr_71179 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71179[(0)] = superv$async$state_machine__50080__auto__);

(statearr_71179[(1)] = (1));

return statearr_71179;
});
var superv$async$state_machine__50080__auto____1 = (function (state_71136){
while(true){
var ret_value__50081__auto__ = (function (){try{while(true){
var result__50082__auto__ = switch__50079__auto__.call(null,state_71136);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50082__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50082__auto__;
}
break;
}
}catch (e71180){if((e71180 instanceof Object)){
var ex__50083__auto__ = e71180;
var statearr_71181_71214 = state_71136;
(statearr_71181_71214[(5)] = ex__50083__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71136);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e71180;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50081__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71215 = state_71136;
state_71136 = G__71215;
continue;
} else {
return ret_value__50081__auto__;
}
break;
}
});
superv$async$state_machine__50080__auto__ = function(state_71136){
switch(arguments.length){
case 0:
return superv$async$state_machine__50080__auto____0.call(this);
case 1:
return superv$async$state_machine__50080__auto____1.call(this,state_71136);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__50080__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__50080__auto____0;
superv$async$state_machine__50080__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__50080__auto____1;
return superv$async$state_machine__50080__auto__;
})()
;})(switch__50079__auto__,c__50102__auto___71188,c__68170__auto___71186,id__68171__auto___71187,out))
})();
var state__50104__auto__ = (function (){var statearr_71182 = f__50103__auto__.call(null);
(statearr_71182[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__50102__auto___71188);

return statearr_71182;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50104__auto__);
});})(c__50102__auto___71188,c__68170__auto___71186,id__68171__auto___71187,out))
);


return out;
});

superv.async.concat_GT__GT_.cljs$lang$maxFixedArity = (1);

superv.async.concat_GT__GT_.cljs$lang$applyTo = (function (seq71054){
var G__71055 = cljs.core.first.call(null,seq71054);
var seq71054__$1 = cljs.core.next.call(null,seq71054);
return superv.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic(G__71055,seq71054__$1);
});

superv.async.partition_all_GT__GT_ = (function superv$async$partition_all_GT__GT_(var_args){
var args__48688__auto__ = [];
var len__48681__auto___71433 = arguments.length;
var i__48682__auto___71434 = (0);
while(true){
if((i__48682__auto___71434 < len__48681__auto___71433)){
args__48688__auto__.push((arguments[i__48682__auto___71434]));

var G__71435 = (i__48682__auto___71434 + (1));
i__48682__auto___71434 = G__71435;
continue;
} else {
}
break;
}

var argseq__48689__auto__ = ((((3) < args__48688__auto__.length))?(new cljs.core.IndexedSeq(args__48688__auto__.slice((3)),(0),null)):null);
return superv.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__48689__auto__);
});

superv.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (S,n,in_ch,p__71220){
var map__71221 = p__71220;
var map__71221__$1 = ((((!((map__71221 == null)))?((((map__71221.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71221.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71221):map__71221);
var out_ch = cljs.core.get.call(null,map__71221__$1,new cljs.core.Keyword(null,"out-ch","out-ch",-189045854));

new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(n > (0))], null)], null);

var out_ch__$1 = (function (){var or__47465__auto__ = out_ch;
if(cljs.core.truth_(or__47465__auto__)){
return or__47465__auto__;
} else {
return cljs.core.async.chan.call(null);
}
})();
var c__68170__auto___71436 = superv.async.check_supervisor.call(null,superv.async.S);
var id__68171__auto___71437 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"batch","batch",977610327,null),cljs.core.PersistentVector.EMPTY], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"obj","obj",-1672671807,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"in-ch","in-ch",-1757981794,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null))),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null),cljs.core.list(new cljs.core.Symbol(null,"conj","conj",-1127293942,null),new cljs.core.Symbol(null,"batch","batch",977610327,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),cljs.core.PersistentVector.EMPTY)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null))))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"not-empty","not-empty",2029453590,null),new cljs.core.Symbol(null,"batch","batch",977610327,null)),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"batch","batch",977610327,null))),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null)))))));
var c__50102__auto___71438 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50102__auto___71438,c__68170__auto___71436,id__68171__auto___71437,out_ch__$1,map__71221,map__71221__$1,out_ch){
return (function (){
var f__50103__auto__ = (function (){var switch__50079__auto__ = ((function (c__50102__auto___71438,c__68170__auto___71436,id__68171__auto___71437,out_ch__$1,map__71221,map__71221__$1,out_ch){
return (function (state_71365){
var state_val_71366 = (state_71365[(1)]);
if((state_val_71366 === (7))){
var inst_71226 = (state_71365[(7)]);
var inst_71234 = (state_71365[(2)]);
var state_71365__$1 = (function (){var statearr_71367 = state_71365;
(statearr_71367[(8)] = inst_71234);

return statearr_71367;
})();
var statearr_71368_71439 = state_71365__$1;
(statearr_71368_71439[(2)] = inst_71226);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71365__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71366 === (20))){
var inst_71326 = (state_71365[(2)]);
var state_71365__$1 = state_71365;
var statearr_71369_71440 = state_71365__$1;
(statearr_71369_71440[(2)] = inst_71326);

(statearr_71369_71440[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71366 === (27))){
var inst_71291 = (state_71365[(9)]);
var inst_71239 = inst_71291;
var state_71365__$1 = (function (){var statearr_71370 = state_71365;
(statearr_71370[(10)] = inst_71239);

return statearr_71370;
})();
var statearr_71371_71441 = state_71365__$1;
(statearr_71371_71441[(2)] = null);

(statearr_71371_71441[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71366 === (1))){
var state_71365__$1 = state_71365;
var statearr_71372_71442 = state_71365__$1;
(statearr_71372_71442[(2)] = null);

(statearr_71372_71442[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71366 === (24))){
var inst_71287 = (state_71365[(2)]);
var inst_71288 = superv.async.throw_if_exception.call(null,S,inst_71287);
var inst_71289 = cljs.core.async.close_BANG_.call(null,out_ch__$1);
var state_71365__$1 = (function (){var statearr_71373 = state_71365;
(statearr_71373[(11)] = inst_71288);

return statearr_71373;
})();
var statearr_71374_71443 = state_71365__$1;
(statearr_71374_71443[(2)] = inst_71289);

(statearr_71374_71443[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71366 === (39))){
var inst_71239 = (state_71365[(10)]);
var state_71365__$1 = state_71365;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_71365__$1,(41),out_ch__$1,inst_71239);
} else {
if((state_val_71366 === (4))){
var inst_71226 = (state_71365[(7)]);
var inst_71226__$1 = (state_71365[(2)]);
var inst_71227 = cljs.core.ex_data.call(null,inst_71226__$1);
var inst_71228 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_71227);
var inst_71229 = cljs.core._EQ_.call(null,inst_71228,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_71365__$1 = (function (){var statearr_71375 = state_71365;
(statearr_71375[(7)] = inst_71226__$1);

return statearr_71375;
})();
if(inst_71229){
var statearr_71376_71444 = state_71365__$1;
(statearr_71376_71444[(1)] = (5));

} else {
var statearr_71377_71445 = state_71365__$1;
(statearr_71377_71445[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71366 === (15))){
var inst_71261 = (state_71365[(12)]);
var inst_71263 = (inst_71261 instanceof Error);
var state_71365__$1 = state_71365;
if(cljs.core.truth_(inst_71263)){
var statearr_71378_71446 = state_71365__$1;
(statearr_71378_71446[(1)] = (18));

} else {
var statearr_71379_71447 = state_71365__$1;
(statearr_71379_71447[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71366 === (21))){
var inst_71268 = (state_71365[(13)]);
var inst_71274 = (state_71365[(2)]);
var inst_71275 = cljs.core.nth.call(null,inst_71274,(0),null);
var inst_71276 = cljs.core.nth.call(null,inst_71274,(1),null);
var inst_71277 = cljs.core._EQ_.call(null,inst_71276,inst_71268);
var state_71365__$1 = (function (){var statearr_71380 = state_71365;
(statearr_71380[(14)] = inst_71275);

return statearr_71380;
})();
if(inst_71277){
var statearr_71381_71448 = state_71365__$1;
(statearr_71381_71448[(1)] = (22));

} else {
var statearr_71382_71449 = state_71365__$1;
(statearr_71382_71449[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71366 === (31))){
var inst_71291 = (state_71365[(9)]);
var state_71365__$1 = state_71365;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_71365__$1,(33),out_ch__$1,inst_71291);
} else {
if((state_val_71366 === (32))){
var inst_71317 = (state_71365[(2)]);
var inst_71318 = superv.async.throw_if_exception.call(null,S,inst_71317);
var inst_71319 = cljs.core.PersistentVector.EMPTY;
var inst_71239 = inst_71319;
var state_71365__$1 = (function (){var statearr_71383 = state_71365;
(statearr_71383[(10)] = inst_71239);

(statearr_71383[(15)] = inst_71318);

return statearr_71383;
})();
var statearr_71384_71450 = state_71365__$1;
(statearr_71384_71450[(2)] = null);

(statearr_71384_71450[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71366 === (40))){
var inst_71352 = (state_71365[(2)]);
var inst_71353 = superv.async.throw_if_exception.call(null,S,inst_71352);
var state_71365__$1 = state_71365;
var statearr_71385_71451 = state_71365__$1;
(statearr_71385_71451[(2)] = inst_71353);

(statearr_71385_71451[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71366 === (33))){
var inst_71315 = (state_71365[(2)]);
var state_71365__$1 = state_71365;
var statearr_71386_71452 = state_71365__$1;
(statearr_71386_71452[(2)] = inst_71315);

(statearr_71386_71452[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71366 === (13))){
var inst_71250 = (state_71365[(16)]);
var state_71365__$1 = state_71365;
var statearr_71387_71453 = state_71365__$1;
(statearr_71387_71453[(2)] = inst_71250);

(statearr_71387_71453[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71366 === (22))){
var inst_71279 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_71280 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_71281 = cljs.core.PersistentHashMap.fromArrays(inst_71279,inst_71280);
var inst_71282 = cljs.core.ex_info.call(null,"Aborted operations",inst_71281);
var state_71365__$1 = state_71365;
var statearr_71388_71454 = state_71365__$1;
(statearr_71388_71454[(2)] = inst_71282);

(statearr_71388_71454[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71366 === (36))){
var inst_71356 = (state_71365[(2)]);
var inst_71357 = cljs.core.async.close_BANG_.call(null,out_ch__$1);
var state_71365__$1 = (function (){var statearr_71389 = state_71365;
(statearr_71389[(17)] = inst_71356);

return statearr_71389;
})();
var statearr_71390_71455 = state_71365__$1;
(statearr_71390_71455[(2)] = inst_71357);

(statearr_71390_71455[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71366 === (41))){
var inst_71350 = (state_71365[(2)]);
var state_71365__$1 = state_71365;
var statearr_71391_71456 = state_71365__$1;
(statearr_71391_71456[(2)] = inst_71350);

(statearr_71391_71456[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71366 === (29))){
var inst_71298 = (state_71365[(18)]);
var inst_71304 = (state_71365[(2)]);
var inst_71305 = cljs.core.nth.call(null,inst_71304,(0),null);
var inst_71306 = cljs.core.nth.call(null,inst_71304,(1),null);
var inst_71307 = cljs.core._EQ_.call(null,inst_71306,inst_71298);
var state_71365__$1 = (function (){var statearr_71392 = state_71365;
(statearr_71392[(19)] = inst_71305);

return statearr_71392;
})();
if(inst_71307){
var statearr_71393_71457 = state_71365__$1;
(statearr_71393_71457[(1)] = (30));

} else {
var statearr_71394_71458 = state_71365__$1;
(statearr_71394_71458[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71366 === (6))){
var inst_71226 = (state_71365[(7)]);
var inst_71232 = superv.async._track_exception.call(null,S,inst_71226);
var state_71365__$1 = state_71365;
var statearr_71395_71459 = state_71365__$1;
(statearr_71395_71459[(2)] = inst_71232);

(statearr_71395_71459[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71366 === (28))){
var inst_71324 = (state_71365[(2)]);
var state_71365__$1 = state_71365;
var statearr_71396_71460 = state_71365__$1;
(statearr_71396_71460[(2)] = inst_71324);

(statearr_71396_71460[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71366 === (25))){
var inst_71285 = (state_71365[(2)]);
var state_71365__$1 = state_71365;
var statearr_71397_71461 = state_71365__$1;
(statearr_71397_71461[(2)] = inst_71285);

(statearr_71397_71461[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71366 === (34))){
var inst_71333 = (state_71365[(20)]);
var inst_71333__$1 = superv.async._abort.call(null,S);
var inst_71334 = cljs.core.async.timeout.call(null,(0));
var inst_71335 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71336 = [inst_71333__$1,inst_71334];
var inst_71337 = (new cljs.core.PersistentVector(null,2,(5),inst_71335,inst_71336,null));
var state_71365__$1 = (function (){var statearr_71398 = state_71365;
(statearr_71398[(20)] = inst_71333__$1);

return statearr_71398;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_71365__$1,(37),inst_71337,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_71366 === (17))){
var inst_71359 = (state_71365[(2)]);
var state_71365__$1 = state_71365;
var statearr_71399_71462 = state_71365__$1;
(statearr_71399_71462[(2)] = inst_71359);

(statearr_71399_71462[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71366 === (3))){
var inst_71223 = (state_71365[(2)]);
var inst_71224 = superv.async._unregister_go.call(null,S,id__68171__auto___71437);
var state_71365__$1 = (function (){var statearr_71400 = state_71365;
(statearr_71400[(21)] = inst_71223);

(statearr_71400[(22)] = inst_71224);

return statearr_71400;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71365__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71366 === (12))){
var inst_71254 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_71255 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_71256 = cljs.core.PersistentHashMap.fromArrays(inst_71254,inst_71255);
var inst_71257 = cljs.core.ex_info.call(null,"Aborted operations",inst_71256);
var state_71365__$1 = state_71365;
var statearr_71401_71463 = state_71365__$1;
(statearr_71401_71463[(2)] = inst_71257);

(statearr_71401_71463[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71366 === (2))){
var inst_71363 = (state_71365[(2)]);
var state_71365__$1 = state_71365;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71365__$1,inst_71363);
} else {
if((state_val_71366 === (23))){
var inst_71261 = (state_71365[(12)]);
var state_71365__$1 = state_71365;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_71365__$1,(25),out_ch__$1,inst_71261);
} else {
if((state_val_71366 === (35))){
var state_71365__$1 = state_71365;
var statearr_71402_71464 = state_71365__$1;
(statearr_71402_71464[(2)] = null);

(statearr_71402_71464[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71366 === (19))){
var inst_71291 = (state_71365[(9)]);
var inst_71239 = (state_71365[(10)]);
var inst_71261 = (state_71365[(12)]);
var inst_71291__$1 = cljs.core.conj.call(null,inst_71239,inst_71261);
var inst_71292 = cljs.core.count.call(null,inst_71291__$1);
var inst_71293 = cljs.core._EQ_.call(null,n,inst_71292);
var state_71365__$1 = (function (){var statearr_71403 = state_71365;
(statearr_71403[(9)] = inst_71291__$1);

return statearr_71403;
})();
if(inst_71293){
var statearr_71404_71465 = state_71365__$1;
(statearr_71404_71465[(1)] = (26));

} else {
var statearr_71405_71466 = state_71365__$1;
(statearr_71405_71466[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71366 === (11))){
var inst_71244 = (state_71365[(23)]);
var inst_71249 = (state_71365[(2)]);
var inst_71250 = cljs.core.nth.call(null,inst_71249,(0),null);
var inst_71251 = cljs.core.nth.call(null,inst_71249,(1),null);
var inst_71252 = cljs.core._EQ_.call(null,inst_71251,inst_71244);
var state_71365__$1 = (function (){var statearr_71406 = state_71365;
(statearr_71406[(16)] = inst_71250);

return statearr_71406;
})();
if(inst_71252){
var statearr_71407_71467 = state_71365__$1;
(statearr_71407_71467[(1)] = (12));

} else {
var statearr_71408_71468 = state_71365__$1;
(statearr_71408_71468[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71366 === (9))){
var inst_71244 = (state_71365[(23)]);
var inst_71244__$1 = superv.async._abort.call(null,S);
var inst_71245 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71246 = [inst_71244__$1,in_ch];
var inst_71247 = (new cljs.core.PersistentVector(null,2,(5),inst_71245,inst_71246,null));
var state_71365__$1 = (function (){var statearr_71409 = state_71365;
(statearr_71409[(23)] = inst_71244__$1);

return statearr_71409;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_71365__$1,(11),inst_71247,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_71366 === (5))){
var state_71365__$1 = state_71365;
var statearr_71410_71469 = state_71365__$1;
(statearr_71410_71469[(2)] = null);

(statearr_71410_71469[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71366 === (14))){
var inst_71261 = (state_71365[(12)]);
var inst_71260 = (state_71365[(2)]);
var inst_71261__$1 = superv.async.throw_if_exception.call(null,S,inst_71260);
var state_71365__$1 = (function (){var statearr_71411 = state_71365;
(statearr_71411[(12)] = inst_71261__$1);

return statearr_71411;
})();
if(cljs.core.truth_(inst_71261__$1)){
var statearr_71412_71470 = state_71365__$1;
(statearr_71412_71470[(1)] = (15));

} else {
var statearr_71413_71471 = state_71365__$1;
(statearr_71413_71471[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71366 === (26))){
var inst_71298 = (state_71365[(18)]);
var inst_71298__$1 = superv.async._abort.call(null,S);
var inst_71299 = cljs.core.async.timeout.call(null,(0));
var inst_71300 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71301 = [inst_71298__$1,inst_71299];
var inst_71302 = (new cljs.core.PersistentVector(null,2,(5),inst_71300,inst_71301,null));
var state_71365__$1 = (function (){var statearr_71414 = state_71365;
(statearr_71414[(18)] = inst_71298__$1);

return statearr_71414;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_71365__$1,(29),inst_71302,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_71366 === (16))){
var inst_71239 = (state_71365[(10)]);
var inst_71328 = cljs.core.not_empty.call(null,inst_71239);
var state_71365__$1 = state_71365;
if(cljs.core.truth_(inst_71328)){
var statearr_71415_71472 = state_71365__$1;
(statearr_71415_71472[(1)] = (34));

} else {
var statearr_71416_71473 = state_71365__$1;
(statearr_71416_71473[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71366 === (38))){
var inst_71344 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_71345 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_71346 = cljs.core.PersistentHashMap.fromArrays(inst_71344,inst_71345);
var inst_71347 = cljs.core.ex_info.call(null,"Aborted operations",inst_71346);
var state_71365__$1 = state_71365;
var statearr_71417_71474 = state_71365__$1;
(statearr_71417_71474[(2)] = inst_71347);

(statearr_71417_71474[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71366 === (30))){
var inst_71309 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_71310 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_71311 = cljs.core.PersistentHashMap.fromArrays(inst_71309,inst_71310);
var inst_71312 = cljs.core.ex_info.call(null,"Aborted operations",inst_71311);
var state_71365__$1 = state_71365;
var statearr_71418_71475 = state_71365__$1;
(statearr_71418_71475[(2)] = inst_71312);

(statearr_71418_71475[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71366 === (10))){
var inst_71361 = (state_71365[(2)]);
var state_71365__$1 = state_71365;
var statearr_71419_71476 = state_71365__$1;
(statearr_71419_71476[(2)] = inst_71361);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71365__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71366 === (18))){
var inst_71268 = (state_71365[(13)]);
var inst_71268__$1 = superv.async._abort.call(null,S);
var inst_71269 = cljs.core.async.timeout.call(null,(0));
var inst_71270 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71271 = [inst_71268__$1,inst_71269];
var inst_71272 = (new cljs.core.PersistentVector(null,2,(5),inst_71270,inst_71271,null));
var state_71365__$1 = (function (){var statearr_71420 = state_71365;
(statearr_71420[(13)] = inst_71268__$1);

return statearr_71420;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_71365__$1,(21),inst_71272,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_71366 === (37))){
var inst_71333 = (state_71365[(20)]);
var inst_71339 = (state_71365[(2)]);
var inst_71340 = cljs.core.nth.call(null,inst_71339,(0),null);
var inst_71341 = cljs.core.nth.call(null,inst_71339,(1),null);
var inst_71342 = cljs.core._EQ_.call(null,inst_71341,inst_71333);
var state_71365__$1 = (function (){var statearr_71421 = state_71365;
(statearr_71421[(24)] = inst_71340);

return statearr_71421;
})();
if(inst_71342){
var statearr_71422_71477 = state_71365__$1;
(statearr_71422_71477[(1)] = (38));

} else {
var statearr_71423_71478 = state_71365__$1;
(statearr_71423_71478[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71366 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_71365,(4),Error,(3),(2));
var inst_71238 = cljs.core.PersistentVector.EMPTY;
var inst_71239 = inst_71238;
var state_71365__$1 = (function (){var statearr_71424 = state_71365;
(statearr_71424[(10)] = inst_71239);

return statearr_71424;
})();
var statearr_71425_71479 = state_71365__$1;
(statearr_71425_71479[(2)] = null);

(statearr_71425_71479[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__50102__auto___71438,c__68170__auto___71436,id__68171__auto___71437,out_ch__$1,map__71221,map__71221__$1,out_ch))
;
return ((function (switch__50079__auto__,c__50102__auto___71438,c__68170__auto___71436,id__68171__auto___71437,out_ch__$1,map__71221,map__71221__$1,out_ch){
return (function() {
var superv$async$state_machine__50080__auto__ = null;
var superv$async$state_machine__50080__auto____0 = (function (){
var statearr_71429 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71429[(0)] = superv$async$state_machine__50080__auto__);

(statearr_71429[(1)] = (1));

return statearr_71429;
});
var superv$async$state_machine__50080__auto____1 = (function (state_71365){
while(true){
var ret_value__50081__auto__ = (function (){try{while(true){
var result__50082__auto__ = switch__50079__auto__.call(null,state_71365);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50082__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50082__auto__;
}
break;
}
}catch (e71430){if((e71430 instanceof Object)){
var ex__50083__auto__ = e71430;
var statearr_71431_71480 = state_71365;
(statearr_71431_71480[(5)] = ex__50083__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71365);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e71430;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50081__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71481 = state_71365;
state_71365 = G__71481;
continue;
} else {
return ret_value__50081__auto__;
}
break;
}
});
superv$async$state_machine__50080__auto__ = function(state_71365){
switch(arguments.length){
case 0:
return superv$async$state_machine__50080__auto____0.call(this);
case 1:
return superv$async$state_machine__50080__auto____1.call(this,state_71365);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__50080__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__50080__auto____0;
superv$async$state_machine__50080__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__50080__auto____1;
return superv$async$state_machine__50080__auto__;
})()
;})(switch__50079__auto__,c__50102__auto___71438,c__68170__auto___71436,id__68171__auto___71437,out_ch__$1,map__71221,map__71221__$1,out_ch))
})();
var state__50104__auto__ = (function (){var statearr_71432 = f__50103__auto__.call(null);
(statearr_71432[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__50102__auto___71438);

return statearr_71432;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50104__auto__);
});})(c__50102__auto___71438,c__68170__auto___71436,id__68171__auto___71437,out_ch__$1,map__71221,map__71221__$1,out_ch))
);


return out_ch__$1;
});

superv.async.partition_all_GT__GT_.cljs$lang$maxFixedArity = (3);

superv.async.partition_all_GT__GT_.cljs$lang$applyTo = (function (seq71216){
var G__71217 = cljs.core.first.call(null,seq71216);
var seq71216__$1 = cljs.core.next.call(null,seq71216);
var G__71218 = cljs.core.first.call(null,seq71216__$1);
var seq71216__$2 = cljs.core.next.call(null,seq71216__$1);
var G__71219 = cljs.core.first.call(null,seq71216__$2);
var seq71216__$3 = cljs.core.next.call(null,seq71216__$2);
return superv.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic(G__71217,G__71218,G__71219,seq71216__$3);
});

/**
 * Counts items in a channel. Returns a channel with the item count.
 */
superv.async.count_GT_ = (function superv$async$count_GT_(S,ch){
return cljs.core.async.reduce.call(null,(function (acc,obj){
if((obj instanceof Error)){
return superv.async.put_QMARK_.call(null,S,superv.async._error.call(null,S),obj);
} else {
return (acc + (1));
}
}),(0),ch);
});
/**
 * Debounces channel. Forwards first item from input channel to output
 *   immediately. After that one item every interval ms (if any). If there are more
 *   items in between, they are dropped.
 */
superv.async.debounce_GT__GT_ = (function superv$async$debounce_GT__GT_(S,ch,interval){
var out = cljs.core.async.chan.call(null);
var c__68170__auto___71800 = superv.async.check_supervisor.call(null,superv.async.S);
var id__68171__auto___71801 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"last-val","last-val",-1727586789,null),null], null),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),cljs.core.list(new cljs.core.Symbol(null,"or","or",1876275696,null),new cljs.core.Symbol(null,"last-val","last-val",-1727586789,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))),new cljs.core.Symbol(null,"timer","timer",373563788,null),cljs.core.list(new cljs.core.Symbol("async","timeout","async/timeout",1951904349,null),new cljs.core.Symbol(null,"interval","interval",-945940352,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.Symbol(null,"val","val",1769233139,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out","out",729986010,null)),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"new-val","new-val",902372928,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null),cljs.core.list(new cljs.core.Symbol(null,"alts?","alts?",1625745590,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"timer","timer",373563788,null)], null))], null),cljs.core.list(new cljs.core.Symbol(null,"condp","condp",1054325175,null),new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"timer","timer",373563788,null),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"val","val",1769233139,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)))))))));
var c__50102__auto___71802 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50102__auto___71802,c__68170__auto___71800,id__68171__auto___71801,out){
return (function (){
var f__50103__auto__ = (function (){var switch__50079__auto__ = ((function (c__50102__auto___71802,c__68170__auto___71800,id__68171__auto___71801,out){
return (function (state_71746){
var state_val_71747 = (state_71746[(1)]);
if((state_val_71747 === (7))){
var inst_71644 = (state_71746[(7)]);
var inst_71652 = (state_71746[(2)]);
var state_71746__$1 = (function (){var statearr_71748 = state_71746;
(statearr_71748[(8)] = inst_71652);

return statearr_71748;
})();
var statearr_71749_71803 = state_71746__$1;
(statearr_71749_71803[(2)] = inst_71644);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71746__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71747 === (20))){
var inst_71740 = (state_71746[(2)]);
var state_71746__$1 = state_71746;
var statearr_71750_71804 = state_71746__$1;
(statearr_71750_71804[(2)] = inst_71740);

(statearr_71750_71804[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71747 === (27))){
var inst_71724 = (state_71746[(2)]);
var inst_71725 = superv.async.throw_if_exception.call(null,S,inst_71724);
var inst_71656 = null;
var state_71746__$1 = (function (){var statearr_71751 = state_71746;
(statearr_71751[(9)] = inst_71656);

(statearr_71751[(10)] = inst_71725);

return statearr_71751;
})();
var statearr_71752_71805 = state_71746__$1;
(statearr_71752_71805[(2)] = null);

(statearr_71752_71805[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71747 === (1))){
var state_71746__$1 = state_71746;
var statearr_71753_71806 = state_71746__$1;
(statearr_71753_71806[(2)] = null);

(statearr_71753_71806[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71747 === (24))){
var inst_71705 = (state_71746[(11)]);
var inst_71711 = (state_71746[(2)]);
var inst_71712 = cljs.core.nth.call(null,inst_71711,(0),null);
var inst_71713 = cljs.core.nth.call(null,inst_71711,(1),null);
var inst_71714 = cljs.core._EQ_.call(null,inst_71713,inst_71705);
var state_71746__$1 = (function (){var statearr_71754 = state_71746;
(statearr_71754[(12)] = inst_71712);

return statearr_71754;
})();
if(inst_71714){
var statearr_71755_71807 = state_71746__$1;
(statearr_71755_71807[(1)] = (25));

} else {
var statearr_71756_71808 = state_71746__$1;
(statearr_71756_71808[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71747 === (4))){
var inst_71644 = (state_71746[(7)]);
var inst_71644__$1 = (state_71746[(2)]);
var inst_71645 = cljs.core.ex_data.call(null,inst_71644__$1);
var inst_71646 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_71645);
var inst_71647 = cljs.core._EQ_.call(null,inst_71646,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_71746__$1 = (function (){var statearr_71757 = state_71746;
(statearr_71757[(7)] = inst_71644__$1);

return statearr_71757;
})();
if(inst_71647){
var statearr_71758_71809 = state_71746__$1;
(statearr_71758_71809[(1)] = (5));

} else {
var statearr_71759_71810 = state_71746__$1;
(statearr_71759_71810[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71747 === (15))){
var inst_71673 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_71674 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_71675 = cljs.core.PersistentHashMap.fromArrays(inst_71673,inst_71674);
var inst_71676 = cljs.core.ex_info.call(null,"Aborted operations",inst_71675);
var state_71746__$1 = state_71746;
var statearr_71760_71811 = state_71746__$1;
(statearr_71760_71811[(2)] = inst_71676);

(statearr_71760_71811[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71747 === (21))){
var inst_71705 = (state_71746[(11)]);
var inst_71705__$1 = superv.async._abort.call(null,S);
var inst_71706 = cljs.core.async.timeout.call(null,(0));
var inst_71707 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71708 = [inst_71705__$1,inst_71706];
var inst_71709 = (new cljs.core.PersistentVector(null,2,(5),inst_71707,inst_71708,null));
var state_71746__$1 = (function (){var statearr_71761 = state_71746;
(statearr_71761[(11)] = inst_71705__$1);

return statearr_71761;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_71746__$1,(24),inst_71709,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_71747 === (31))){
var inst_71736 = (state_71746[(2)]);
var state_71746__$1 = state_71746;
var statearr_71762_71812 = state_71746__$1;
(statearr_71762_71812[(2)] = inst_71736);

(statearr_71762_71812[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71747 === (13))){
var inst_71682 = (state_71746[(13)]);
var inst_71682__$1 = (state_71746[(2)]);
var inst_71683 = cljs.core.async.timeout.call(null,interval);
var inst_71684 = (inst_71682__$1 == null);
var state_71746__$1 = (function (){var statearr_71763 = state_71746;
(statearr_71763[(14)] = inst_71683);

(statearr_71763[(13)] = inst_71682__$1);

return statearr_71763;
})();
if(cljs.core.truth_(inst_71684)){
var statearr_71764_71813 = state_71746__$1;
(statearr_71764_71813[(1)] = (18));

} else {
var statearr_71765_71814 = state_71746__$1;
(statearr_71765_71814[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71747 === (22))){
var inst_71696 = (state_71746[(15)]);
var inst_71728 = cljs.core._EQ_.call(null,inst_71696,inst_71696);
var state_71746__$1 = state_71746;
if(inst_71728){
var statearr_71766_71815 = state_71746__$1;
(statearr_71766_71815[(1)] = (29));

} else {
var statearr_71767_71816 = state_71746__$1;
(statearr_71767_71816[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71747 === (29))){
var inst_71695 = (state_71746[(16)]);
var inst_71656 = inst_71695;
var state_71746__$1 = (function (){var statearr_71768 = state_71746;
(statearr_71768[(9)] = inst_71656);

return statearr_71768;
})();
var statearr_71769_71817 = state_71746__$1;
(statearr_71769_71817[(2)] = null);

(statearr_71769_71817[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71747 === (6))){
var inst_71644 = (state_71746[(7)]);
var inst_71650 = superv.async._track_exception.call(null,S,inst_71644);
var state_71746__$1 = state_71746;
var statearr_71770_71818 = state_71746__$1;
(statearr_71770_71818[(2)] = inst_71650);

(statearr_71770_71818[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71747 === (28))){
var inst_71722 = (state_71746[(2)]);
var state_71746__$1 = state_71746;
var statearr_71771_71819 = state_71746__$1;
(statearr_71771_71819[(2)] = inst_71722);

(statearr_71771_71819[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71747 === (25))){
var inst_71716 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_71717 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_71718 = cljs.core.PersistentHashMap.fromArrays(inst_71716,inst_71717);
var inst_71719 = cljs.core.ex_info.call(null,"Aborted operations",inst_71718);
var state_71746__$1 = state_71746;
var statearr_71772_71820 = state_71746__$1;
(statearr_71772_71820[(2)] = inst_71719);

(statearr_71772_71820[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71747 === (17))){
var inst_71679 = (state_71746[(2)]);
var inst_71680 = superv.async.throw_if_exception.call(null,S,inst_71679);
var state_71746__$1 = state_71746;
var statearr_71773_71821 = state_71746__$1;
(statearr_71773_71821[(2)] = inst_71680);

(statearr_71773_71821[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71747 === (3))){
var inst_71641 = (state_71746[(2)]);
var inst_71642 = superv.async._unregister_go.call(null,S,id__68171__auto___71801);
var state_71746__$1 = (function (){var statearr_71774 = state_71746;
(statearr_71774[(17)] = inst_71641);

(statearr_71774[(18)] = inst_71642);

return statearr_71774;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71746__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71747 === (12))){
var inst_71663 = (state_71746[(19)]);
var inst_71663__$1 = superv.async._abort.call(null,S);
var inst_71664 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71665 = [inst_71663__$1,ch];
var inst_71666 = (new cljs.core.PersistentVector(null,2,(5),inst_71664,inst_71665,null));
var state_71746__$1 = (function (){var statearr_71775 = state_71746;
(statearr_71775[(19)] = inst_71663__$1);

return statearr_71775;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_71746__$1,(14),inst_71666,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_71747 === (2))){
var inst_71744 = (state_71746[(2)]);
var state_71746__$1 = state_71746;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71746__$1,inst_71744);
} else {
if((state_val_71747 === (23))){
var inst_71738 = (state_71746[(2)]);
var state_71746__$1 = state_71746;
var statearr_71776_71822 = state_71746__$1;
(statearr_71776_71822[(2)] = inst_71738);

(statearr_71776_71822[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71747 === (19))){
var inst_71683 = (state_71746[(14)]);
var inst_71696 = (state_71746[(15)]);
var inst_71691 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71692 = [ch,inst_71683];
var inst_71693 = (new cljs.core.PersistentVector(null,2,(5),inst_71691,inst_71692,null));
var inst_71694 = superv.async.alts_QMARK_.call(null,S,inst_71693);
var inst_71695 = cljs.core.nth.call(null,inst_71694,(0),null);
var inst_71696__$1 = cljs.core.nth.call(null,inst_71694,(1),null);
var inst_71700 = cljs.core._EQ_.call(null,inst_71683,inst_71696__$1);
var state_71746__$1 = (function (){var statearr_71777 = state_71746;
(statearr_71777[(15)] = inst_71696__$1);

(statearr_71777[(16)] = inst_71695);

return statearr_71777;
})();
if(inst_71700){
var statearr_71778_71823 = state_71746__$1;
(statearr_71778_71823[(1)] = (21));

} else {
var statearr_71779_71824 = state_71746__$1;
(statearr_71779_71824[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71747 === (11))){
var inst_71656 = (state_71746[(9)]);
var state_71746__$1 = state_71746;
var statearr_71780_71825 = state_71746__$1;
(statearr_71780_71825[(2)] = inst_71656);

(statearr_71780_71825[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71747 === (9))){
var inst_71656 = (state_71746[(9)]);
var state_71746__$1 = state_71746;
if(cljs.core.truth_(inst_71656)){
var statearr_71781_71826 = state_71746__$1;
(statearr_71781_71826[(1)] = (11));

} else {
var statearr_71782_71827 = state_71746__$1;
(statearr_71782_71827[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71747 === (5))){
var state_71746__$1 = state_71746;
var statearr_71783_71828 = state_71746__$1;
(statearr_71783_71828[(2)] = null);

(statearr_71783_71828[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71747 === (14))){
var inst_71663 = (state_71746[(19)]);
var inst_71668 = (state_71746[(2)]);
var inst_71669 = cljs.core.nth.call(null,inst_71668,(0),null);
var inst_71670 = cljs.core.nth.call(null,inst_71668,(1),null);
var inst_71671 = cljs.core._EQ_.call(null,inst_71670,inst_71663);
var state_71746__$1 = (function (){var statearr_71784 = state_71746;
(statearr_71784[(20)] = inst_71669);

return statearr_71784;
})();
if(inst_71671){
var statearr_71785_71829 = state_71746__$1;
(statearr_71785_71829[(1)] = (15));

} else {
var statearr_71786_71830 = state_71746__$1;
(statearr_71786_71830[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71747 === (26))){
var inst_71682 = (state_71746[(13)]);
var state_71746__$1 = state_71746;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_71746__$1,(28),out,inst_71682);
} else {
if((state_val_71747 === (16))){
var inst_71669 = (state_71746[(20)]);
var state_71746__$1 = state_71746;
var statearr_71787_71831 = state_71746__$1;
(statearr_71787_71831[(2)] = inst_71669);

(statearr_71787_71831[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71747 === (30))){
var inst_71696 = (state_71746[(15)]);
var inst_71732 = [cljs.core.str("No matching clause: "),cljs.core.str(inst_71696)].join('');
var inst_71733 = (new Error(inst_71732));
var inst_71734 = (function(){throw inst_71733})();
var state_71746__$1 = state_71746;
var statearr_71788_71832 = state_71746__$1;
(statearr_71788_71832[(2)] = inst_71734);

(statearr_71788_71832[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71747 === (10))){
var inst_71742 = (state_71746[(2)]);
var state_71746__$1 = state_71746;
var statearr_71789_71833 = state_71746__$1;
(statearr_71789_71833[(2)] = inst_71742);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71746__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71747 === (18))){
var inst_71686 = cljs.core.async.close_BANG_.call(null,out);
var state_71746__$1 = state_71746;
var statearr_71790_71834 = state_71746__$1;
(statearr_71790_71834[(2)] = inst_71686);

(statearr_71790_71834[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71747 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_71746,(4),Error,(3),(2));
var inst_71656 = null;
var state_71746__$1 = (function (){var statearr_71791 = state_71746;
(statearr_71791[(9)] = inst_71656);

return statearr_71791;
})();
var statearr_71792_71835 = state_71746__$1;
(statearr_71792_71835[(2)] = null);

(statearr_71792_71835[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__50102__auto___71802,c__68170__auto___71800,id__68171__auto___71801,out))
;
return ((function (switch__50079__auto__,c__50102__auto___71802,c__68170__auto___71800,id__68171__auto___71801,out){
return (function() {
var superv$async$debounce_GT__GT__$_state_machine__50080__auto__ = null;
var superv$async$debounce_GT__GT__$_state_machine__50080__auto____0 = (function (){
var statearr_71796 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71796[(0)] = superv$async$debounce_GT__GT__$_state_machine__50080__auto__);

(statearr_71796[(1)] = (1));

return statearr_71796;
});
var superv$async$debounce_GT__GT__$_state_machine__50080__auto____1 = (function (state_71746){
while(true){
var ret_value__50081__auto__ = (function (){try{while(true){
var result__50082__auto__ = switch__50079__auto__.call(null,state_71746);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50082__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50082__auto__;
}
break;
}
}catch (e71797){if((e71797 instanceof Object)){
var ex__50083__auto__ = e71797;
var statearr_71798_71836 = state_71746;
(statearr_71798_71836[(5)] = ex__50083__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71746);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e71797;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50081__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71837 = state_71746;
state_71746 = G__71837;
continue;
} else {
return ret_value__50081__auto__;
}
break;
}
});
superv$async$debounce_GT__GT__$_state_machine__50080__auto__ = function(state_71746){
switch(arguments.length){
case 0:
return superv$async$debounce_GT__GT__$_state_machine__50080__auto____0.call(this);
case 1:
return superv$async$debounce_GT__GT__$_state_machine__50080__auto____1.call(this,state_71746);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$debounce_GT__GT__$_state_machine__50080__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$debounce_GT__GT__$_state_machine__50080__auto____0;
superv$async$debounce_GT__GT__$_state_machine__50080__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$debounce_GT__GT__$_state_machine__50080__auto____1;
return superv$async$debounce_GT__GT__$_state_machine__50080__auto__;
})()
;})(switch__50079__auto__,c__50102__auto___71802,c__68170__auto___71800,id__68171__auto___71801,out))
})();
var state__50104__auto__ = (function (){var statearr_71799 = f__50103__auto__.call(null);
(statearr_71799[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__50102__auto___71802);

return statearr_71799;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50104__auto__);
});})(c__50102__auto___71802,c__68170__auto___71800,id__68171__auto___71801,out))
);


return out;
});
/**
 * Safely managed tap. The channel is closed on abortion and all
 *   pending puts are flushed.
 */
superv.async.tap = (function superv$async$tap(var_args){
var args71838 = [];
var len__48681__auto___71976 = arguments.length;
var i__48682__auto___71977 = (0);
while(true){
if((i__48682__auto___71977 < len__48681__auto___71976)){
args71838.push((arguments[i__48682__auto___71977]));

var G__71978 = (i__48682__auto___71977 + (1));
i__48682__auto___71977 = G__71978;
continue;
} else {
}
break;
}

var G__71840 = args71838.length;
switch (G__71840) {
case 3:
return superv.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.tap.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args71838.length)].join('')));

}
});

superv.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (S,mult,ch){
return superv.async.tap.call(null,S,mult,ch,false);
});

superv.async.tap.cljs$core$IFn$_invoke$arity$4 = (function (S,mult,ch,close_QMARK_){
var c__68170__auto___71980 = superv.async.check_supervisor.call(null,superv.async.S);
var id__68171__auto___71981 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("cljs.core.async","<!","cljs.core.async/<!",1278951036,null),cljs.core.list(new cljs.core.Symbol("superv.async","-abort","superv.async/-abort",-365058004,null),new cljs.core.Symbol(null,"S","S",-1387142461,null))),cljs.core.list(new cljs.core.Symbol(null,"close!","close!",-438778971,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)),cljs.core.list(new cljs.core.Symbol(null,"go-try","go-try",1412345407,null),cljs.core.list(new cljs.core.Symbol(null,"while","while",-1691317983,null),cljs.core.list(new cljs.core.Symbol(null,"<!","<!",-1961915773,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))))));
var c__50102__auto___71982 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50102__auto___71982,c__68170__auto___71980,id__68171__auto___71981){
return (function (){
var f__50103__auto__ = (function (){var switch__50079__auto__ = ((function (c__50102__auto___71982,c__68170__auto___71980,id__68171__auto___71981){
return (function (state_71919){
var state_val_71920 = (state_71919[(1)]);
if((state_val_71920 === (7))){
var inst_71844 = (state_71919[(7)]);
var inst_71852 = (state_71919[(2)]);
var state_71919__$1 = (function (){var statearr_71921 = state_71919;
(statearr_71921[(8)] = inst_71852);

return statearr_71921;
})();
var statearr_71922_71983 = state_71919__$1;
(statearr_71922_71983[(2)] = inst_71844);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71919__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71920 === (1))){
var state_71919__$1 = state_71919;
var statearr_71923_71984 = state_71919__$1;
(statearr_71923_71984[(2)] = null);

(statearr_71923_71984[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71920 === (4))){
var inst_71844 = (state_71919[(7)]);
var inst_71844__$1 = (state_71919[(2)]);
var inst_71845 = cljs.core.ex_data.call(null,inst_71844__$1);
var inst_71846 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_71845);
var inst_71847 = cljs.core._EQ_.call(null,inst_71846,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_71919__$1 = (function (){var statearr_71924 = state_71919;
(statearr_71924[(7)] = inst_71844__$1);

return statearr_71924;
})();
if(inst_71847){
var statearr_71925_71985 = state_71919__$1;
(statearr_71925_71985[(1)] = (5));

} else {
var statearr_71926_71986 = state_71919__$1;
(statearr_71926_71986[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71920 === (15))){
var inst_71868 = (state_71919[(2)]);
var state_71919__$1 = state_71919;
var statearr_71927_71987 = state_71919__$1;
(statearr_71927_71987[(2)] = inst_71868);

(statearr_71927_71987[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71920 === (13))){
var state_71919__$1 = state_71919;
var statearr_71928_71988 = state_71919__$1;
(statearr_71928_71988[(2)] = null);

(statearr_71928_71988[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71920 === (6))){
var inst_71844 = (state_71919[(7)]);
var inst_71850 = superv.async._track_exception.call(null,S,inst_71844);
var state_71919__$1 = state_71919;
var statearr_71929_71989 = state_71919__$1;
(statearr_71929_71989[(2)] = inst_71850);

(statearr_71929_71989[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71920 === (3))){
var inst_71841 = (state_71919[(2)]);
var inst_71842 = superv.async._unregister_go.call(null,S,id__68171__auto___71981);
var state_71919__$1 = (function (){var statearr_71930 = state_71919;
(statearr_71930[(9)] = inst_71841);

(statearr_71930[(10)] = inst_71842);

return statearr_71930;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71919__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71920 === (12))){
var inst_71863 = (state_71919[(2)]);
var state_71919__$1 = state_71919;
if(cljs.core.truth_(inst_71863)){
var statearr_71931_71990 = state_71919__$1;
(statearr_71931_71990[(1)] = (13));

} else {
var statearr_71932_71991 = state_71919__$1;
(statearr_71932_71991[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71920 === (2))){
var inst_71917 = (state_71919[(2)]);
var state_71919__$1 = state_71919;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71919__$1,inst_71917);
} else {
if((state_val_71920 === (11))){
var inst_71860 = (state_71919[(11)]);
var inst_71870 = (state_71919[(2)]);
var inst_71871 = null;
var inst_71872 = superv.async._register_go.call(null,inst_71870,inst_71871);
var inst_71913 = cljs.core.async.chan.call(null,(1));
var inst_71914 = (function (){var c__68170__auto____$1 = inst_71860;
var id__68171__auto____$1 = inst_71872;
var c__50102__auto____$1 = inst_71913;
return ((function (c__68170__auto____$1,id__68171__auto____$1,c__50102__auto____$1,inst_71860,inst_71870,inst_71871,inst_71872,inst_71913,state_val_71920,c__50102__auto___71982,c__68170__auto___71980,id__68171__auto___71981){
return (function (){
var f__50103__auto__ = (function (){var switch__50079__auto__ = ((function (c__68170__auto____$1,id__68171__auto____$1,c__50102__auto____$1,inst_71860,inst_71870,inst_71871,inst_71872,inst_71913,state_val_71920,c__50102__auto___71982,c__68170__auto___71980,id__68171__auto___71981){
return (function (state_71911){
var state_val_71912 = (state_71911[(1)]);
if((state_val_71912 === (7))){
var state_71911__$1 = state_71911;
var statearr_71933_71992 = state_71911__$1;
(statearr_71933_71992[(2)] = null);

(statearr_71933_71992[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71912 === (20))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_71911,(10),Error,(3),(2));
var state_71911__$1 = state_71911;
var statearr_71934_71993 = state_71911__$1;
(statearr_71934_71993[(2)] = null);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71911__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71912 === (1))){
var state_71911__$1 = state_71911;
var statearr_71935_71994 = state_71911__$1;
(statearr_71935_71994[(2)] = null);

(statearr_71935_71994[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71912 === (4))){
var state_71911__$1 = state_71911;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71911__$1,(6),ch);
} else {
if((state_val_71912 === (15))){
var inst_71886 = (state_71911[(7)]);
var inst_71901 = (state_71911[(2)]);
var inst_71902 = superv.async._track_exception.call(null,inst_71901,inst_71886);
var state_71911__$1 = state_71911;
var statearr_71936_71995 = state_71911__$1;
(statearr_71936_71995[(2)] = inst_71902);

(statearr_71936_71995[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71912 === (13))){
var inst_71886 = (state_71911[(7)]);
var inst_71904 = (state_71911[(2)]);
var state_71911__$1 = (function (){var statearr_71937 = state_71911;
(statearr_71937[(8)] = inst_71904);

return statearr_71937;
})();
var statearr_71938_71996 = state_71911__$1;
(statearr_71938_71996[(2)] = inst_71886);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71911__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71912 === (6))){
var inst_71876 = (state_71911[(2)]);
var state_71911__$1 = state_71911;
if(cljs.core.truth_(inst_71876)){
var statearr_71939_71997 = state_71911__$1;
(statearr_71939_71997[(1)] = (7));

} else {
var statearr_71940_71998 = state_71911__$1;
(statearr_71940_71998[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71912 === (17))){
var state_71911__$1 = state_71911;
var statearr_71941_71999 = state_71911__$1;
(statearr_71941_71999[(2)] = null);

(statearr_71941_71999[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71912 === (3))){
var inst_71873 = (state_71911[(2)]);
var state_71911__$1 = (function (){var statearr_71942 = state_71911;
(statearr_71942[(9)] = inst_71873);

return statearr_71942;
})();
var statearr_71943_72000 = state_71911__$1;
(statearr_71943_72000[(2)] = null);

(statearr_71943_72000[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71912 === (12))){
var state_71911__$1 = state_71911;
var statearr_71944_72001 = state_71911__$1;
(statearr_71944_72001[(2)] = null);

(statearr_71944_72001[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71912 === (2))){
var inst_71909 = (state_71911[(2)]);
var state_71911__$1 = state_71911;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71911__$1,inst_71909);
} else {
if((state_val_71912 === (19))){
var inst_71899 = (state_71911[(2)]);
var state_71911__$1 = state_71911;
var statearr_71945_72002 = state_71911__$1;
(statearr_71945_72002[(2)] = inst_71899);

(statearr_71945_72002[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71912 === (11))){
var state_71911__$1 = state_71911;
var statearr_71946_72003 = state_71911__$1;
(statearr_71946_72003[(2)] = null);

(statearr_71946_72003[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71912 === (9))){
var inst_71881 = (state_71911[(2)]);
var state_71911__$1 = state_71911;
var statearr_71947_72004 = state_71911__$1;
(statearr_71947_72004[(2)] = inst_71881);

(statearr_71947_72004[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71912 === (5))){
var inst_71883 = (state_71911[(2)]);
var inst_71884 = superv.async._unregister_go.call(null,inst_71883,id__68171__auto____$1);
var state_71911__$1 = (function (){var statearr_71948 = state_71911;
(statearr_71948[(10)] = inst_71884);

return statearr_71948;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71911__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71912 === (14))){
var state_71911__$1 = state_71911;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71911__$1,(16),ch);
} else {
if((state_val_71912 === (16))){
var inst_71894 = (state_71911[(2)]);
var state_71911__$1 = state_71911;
if(cljs.core.truth_(inst_71894)){
var statearr_71949_72005 = state_71911__$1;
(statearr_71949_72005[(1)] = (17));

} else {
var statearr_71950_72006 = state_71911__$1;
(statearr_71950_72006[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71912 === (10))){
var inst_71886 = (state_71911[(7)]);
var inst_71886__$1 = (state_71911[(2)]);
var inst_71887 = cljs.core.ex_data.call(null,inst_71886__$1);
var inst_71888 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_71887);
var inst_71889 = cljs.core._EQ_.call(null,inst_71888,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_71911__$1 = (function (){var statearr_71951 = state_71911;
(statearr_71951[(7)] = inst_71886__$1);

return statearr_71951;
})();
if(inst_71889){
var statearr_71952_72007 = state_71911__$1;
(statearr_71952_72007[(1)] = (11));

} else {
var statearr_71953_72008 = state_71911__$1;
(statearr_71953_72008[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71912 === (18))){
var state_71911__$1 = state_71911;
var statearr_71954_72009 = state_71911__$1;
(statearr_71954_72009[(2)] = null);

(statearr_71954_72009[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71912 === (8))){
var state_71911__$1 = state_71911;
var statearr_71955_72010 = state_71911__$1;
(statearr_71955_72010[(2)] = null);

(statearr_71955_72010[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__68170__auto____$1,id__68171__auto____$1,c__50102__auto____$1,inst_71860,inst_71870,inst_71871,inst_71872,inst_71913,state_val_71920,c__50102__auto___71982,c__68170__auto___71980,id__68171__auto___71981))
;
return ((function (switch__50079__auto__,c__68170__auto____$1,id__68171__auto____$1,c__50102__auto____$1,inst_71860,inst_71870,inst_71871,inst_71872,inst_71913,state_val_71920,c__50102__auto___71982,c__68170__auto___71980,id__68171__auto___71981){
return (function() {
var superv$async$state_machine__50080__auto__ = null;
var superv$async$state_machine__50080__auto____0 = (function (){
var statearr_71959 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_71959[(0)] = superv$async$state_machine__50080__auto__);

(statearr_71959[(1)] = (1));

return statearr_71959;
});
var superv$async$state_machine__50080__auto____1 = (function (state_71911){
while(true){
var ret_value__50081__auto__ = (function (){try{while(true){
var result__50082__auto__ = switch__50079__auto__.call(null,state_71911);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50082__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50082__auto__;
}
break;
}
}catch (e71960){if((e71960 instanceof Object)){
var ex__50083__auto__ = e71960;
var statearr_71961_72011 = state_71911;
(statearr_71961_72011[(5)] = ex__50083__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71911);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e71960;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50081__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72012 = state_71911;
state_71911 = G__72012;
continue;
} else {
return ret_value__50081__auto__;
}
break;
}
});
superv$async$state_machine__50080__auto__ = function(state_71911){
switch(arguments.length){
case 0:
return superv$async$state_machine__50080__auto____0.call(this);
case 1:
return superv$async$state_machine__50080__auto____1.call(this,state_71911);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__50080__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__50080__auto____0;
superv$async$state_machine__50080__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__50080__auto____1;
return superv$async$state_machine__50080__auto__;
})()
;})(switch__50079__auto__,c__68170__auto____$1,id__68171__auto____$1,c__50102__auto____$1,inst_71860,inst_71870,inst_71871,inst_71872,inst_71913,state_val_71920,c__50102__auto___71982,c__68170__auto___71980,id__68171__auto___71981))
})();
var state__50104__auto__ = (function (){var statearr_71962 = f__50103__auto__.call(null);
(statearr_71962[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__50102__auto____$1);

return statearr_71962;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50104__auto__);
});
;})(c__68170__auto____$1,id__68171__auto____$1,c__50102__auto____$1,inst_71860,inst_71870,inst_71871,inst_71872,inst_71913,state_val_71920,c__50102__auto___71982,c__68170__auto___71980,id__68171__auto___71981))
})();
var inst_71915 = cljs.core.async.impl.dispatch.run.call(null,inst_71914);
var state_71919__$1 = (function (){var statearr_71963 = state_71919;
(statearr_71963[(12)] = inst_71915);

return statearr_71963;
})();
var statearr_71964_72013 = state_71919__$1;
(statearr_71964_72013[(2)] = inst_71913);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71919__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71920 === (9))){
var inst_71858 = (state_71919[(2)]);
var inst_71859 = cljs.core.async.close_BANG_.call(null,ch);
var inst_71860 = superv.async.check_supervisor.call(null,superv.async.S);
var state_71919__$1 = (function (){var statearr_71965 = state_71919;
(statearr_71965[(11)] = inst_71860);

(statearr_71965[(13)] = inst_71859);

(statearr_71965[(14)] = inst_71858);

return statearr_71965;
})();
var statearr_71966_72014 = state_71919__$1;
(statearr_71966_72014[(2)] = null);

(statearr_71966_72014[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71920 === (5))){
var state_71919__$1 = state_71919;
var statearr_71967_72015 = state_71919__$1;
(statearr_71967_72015[(2)] = null);

(statearr_71967_72015[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71920 === (14))){
var state_71919__$1 = state_71919;
var statearr_71968_72016 = state_71919__$1;
(statearr_71968_72016[(2)] = null);

(statearr_71968_72016[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71920 === (10))){
var state_71919__$1 = state_71919;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71919__$1,(12),ch);
} else {
if((state_val_71920 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_71919,(4),Error,(3),(2));
var inst_71856 = superv.async._abort.call(null,S);
var state_71919__$1 = state_71919;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71919__$1,(9),inst_71856);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__50102__auto___71982,c__68170__auto___71980,id__68171__auto___71981))
;
return ((function (switch__50079__auto__,c__50102__auto___71982,c__68170__auto___71980,id__68171__auto___71981){
return (function() {
var superv$async$state_machine__50080__auto__ = null;
var superv$async$state_machine__50080__auto____0 = (function (){
var statearr_71972 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71972[(0)] = superv$async$state_machine__50080__auto__);

(statearr_71972[(1)] = (1));

return statearr_71972;
});
var superv$async$state_machine__50080__auto____1 = (function (state_71919){
while(true){
var ret_value__50081__auto__ = (function (){try{while(true){
var result__50082__auto__ = switch__50079__auto__.call(null,state_71919);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50082__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50082__auto__;
}
break;
}
}catch (e71973){if((e71973 instanceof Object)){
var ex__50083__auto__ = e71973;
var statearr_71974_72017 = state_71919;
(statearr_71974_72017[(5)] = ex__50083__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71919);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e71973;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50081__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72018 = state_71919;
state_71919 = G__72018;
continue;
} else {
return ret_value__50081__auto__;
}
break;
}
});
superv$async$state_machine__50080__auto__ = function(state_71919){
switch(arguments.length){
case 0:
return superv$async$state_machine__50080__auto____0.call(this);
case 1:
return superv$async$state_machine__50080__auto____1.call(this,state_71919);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__50080__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__50080__auto____0;
superv$async$state_machine__50080__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__50080__auto____1;
return superv$async$state_machine__50080__auto__;
})()
;})(switch__50079__auto__,c__50102__auto___71982,c__68170__auto___71980,id__68171__auto___71981))
})();
var state__50104__auto__ = (function (){var statearr_71975 = f__50103__auto__.call(null);
(statearr_71975[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__50102__auto___71982);

return statearr_71975;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50104__auto__);
});})(c__50102__auto___71982,c__68170__auto___71980,id__68171__auto___71981))
);


return cljs.core.async.tap.call(null,mult,ch,close_QMARK_);
});

superv.async.tap.cljs$lang$maxFixedArity = 4;

/**
 * Safely managed subscription. The channel is closed on abortion and
 *   all pending puts are flushed.
 */
superv.async.sub = (function superv$async$sub(var_args){
var args72019 = [];
var len__48681__auto___72123 = arguments.length;
var i__48682__auto___72124 = (0);
while(true){
if((i__48682__auto___72124 < len__48681__auto___72123)){
args72019.push((arguments[i__48682__auto___72124]));

var G__72125 = (i__48682__auto___72124 + (1));
i__48682__auto___72124 = G__72125;
continue;
} else {
}
break;
}

var G__72021 = args72019.length;
switch (G__72021) {
case 4:
return superv.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return superv.async.sub.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args72019.length)].join('')));

}
});

superv.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (S,p,topic,ch){
return superv.async.sub.call(null,S,p,topic,ch,false);
});

superv.async.sub.cljs$core$IFn$_invoke$arity$5 = (function (S,p,topic,ch,close_QMARK_){
var c__68170__auto___72127 = superv.async.check_supervisor.call(null,superv.async.S);
var id__68171__auto___72128 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("cljs.core.async","<!","cljs.core.async/<!",1278951036,null),cljs.core.list(new cljs.core.Symbol("superv.async","-abort","superv.async/-abort",-365058004,null),new cljs.core.Symbol(null,"S","S",-1387142461,null))),cljs.core.list(new cljs.core.Symbol(null,"close!","close!",-438778971,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)),cljs.core.list(new cljs.core.Symbol(null,"go-try","go-try",1412345407,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),cljs.core.list(new cljs.core.Symbol(null,"while","while",-1691317983,null),cljs.core.list(new cljs.core.Symbol(null,"<!","<!",-1961915773,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))))));
var c__50102__auto___72129 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50102__auto___72129,c__68170__auto___72127,id__68171__auto___72128){
return (function (){
var f__50103__auto__ = (function (){var switch__50079__auto__ = ((function (c__50102__auto___72129,c__68170__auto___72127,id__68171__auto___72128){
return (function (state_72080){
var state_val_72081 = (state_72080[(1)]);
if((state_val_72081 === (1))){
var state_72080__$1 = state_72080;
var statearr_72082_72130 = state_72080__$1;
(statearr_72082_72130[(2)] = null);

(statearr_72082_72130[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72081 === (2))){
var inst_72078 = (state_72080[(2)]);
var state_72080__$1 = state_72080;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72080__$1,inst_72078);
} else {
if((state_val_72081 === (3))){
var inst_72022 = (state_72080[(2)]);
var inst_72023 = superv.async._unregister_go.call(null,S,id__68171__auto___72128);
var state_72080__$1 = (function (){var statearr_72083 = state_72080;
(statearr_72083[(7)] = inst_72023);

(statearr_72083[(8)] = inst_72022);

return statearr_72083;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72080__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72081 === (4))){
var inst_72025 = (state_72080[(9)]);
var inst_72025__$1 = (state_72080[(2)]);
var inst_72026 = cljs.core.ex_data.call(null,inst_72025__$1);
var inst_72027 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_72026);
var inst_72028 = cljs.core._EQ_.call(null,inst_72027,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_72080__$1 = (function (){var statearr_72084 = state_72080;
(statearr_72084[(9)] = inst_72025__$1);

return statearr_72084;
})();
if(inst_72028){
var statearr_72085_72131 = state_72080__$1;
(statearr_72085_72131[(1)] = (5));

} else {
var statearr_72086_72132 = state_72080__$1;
(statearr_72086_72132[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72081 === (5))){
var state_72080__$1 = state_72080;
var statearr_72087_72133 = state_72080__$1;
(statearr_72087_72133[(2)] = null);

(statearr_72087_72133[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72081 === (6))){
var inst_72025 = (state_72080[(9)]);
var inst_72031 = superv.async._track_exception.call(null,S,inst_72025);
var state_72080__$1 = state_72080;
var statearr_72088_72134 = state_72080__$1;
(statearr_72088_72134[(2)] = inst_72031);

(statearr_72088_72134[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72081 === (7))){
var inst_72025 = (state_72080[(9)]);
var inst_72033 = (state_72080[(2)]);
var state_72080__$1 = (function (){var statearr_72089 = state_72080;
(statearr_72089[(10)] = inst_72033);

return statearr_72089;
})();
var statearr_72090_72135 = state_72080__$1;
(statearr_72090_72135[(2)] = inst_72025);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72080__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72081 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_72080,(4),Error,(3),(2));
var inst_72037 = superv.async._abort.call(null,S);
var state_72080__$1 = state_72080;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72080__$1,(9),inst_72037);
} else {
if((state_val_72081 === (9))){
var inst_72039 = (state_72080[(2)]);
var inst_72040 = cljs.core.async.close_BANG_.call(null,ch);
var inst_72041 = superv.async.check_supervisor.call(null,superv.async.S);
var inst_72042 = cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"while","while",-1691317983,null),cljs.core.list(new cljs.core.Symbol(null,"<!","<!",-1961915773,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))));
var inst_72043 = superv.async._register_go.call(null,S,inst_72042);
var inst_72074 = cljs.core.async.chan.call(null,(1));
var inst_72075 = (function (){var c__68170__auto____$1 = inst_72041;
var id__68171__auto____$1 = inst_72043;
var c__50102__auto____$1 = inst_72074;
return ((function (c__68170__auto____$1,id__68171__auto____$1,c__50102__auto____$1,inst_72039,inst_72040,inst_72041,inst_72042,inst_72043,inst_72074,state_val_72081,c__50102__auto___72129,c__68170__auto___72127,id__68171__auto___72128){
return (function (){
var f__50103__auto__ = (function (){var switch__50079__auto__ = ((function (c__68170__auto____$1,id__68171__auto____$1,c__50102__auto____$1,inst_72039,inst_72040,inst_72041,inst_72042,inst_72043,inst_72074,state_val_72081,c__50102__auto___72129,c__68170__auto___72127,id__68171__auto___72128){
return (function (state_72072){
var state_val_72073 = (state_72072[(1)]);
if((state_val_72073 === (7))){
var inst_72047 = (state_72072[(7)]);
var inst_72055 = (state_72072[(2)]);
var state_72072__$1 = (function (){var statearr_72091 = state_72072;
(statearr_72091[(8)] = inst_72055);

return statearr_72091;
})();
var statearr_72092_72136 = state_72072__$1;
(statearr_72092_72136[(2)] = inst_72047);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72072__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72073 === (1))){
var state_72072__$1 = state_72072;
var statearr_72093_72137 = state_72072__$1;
(statearr_72093_72137[(2)] = null);

(statearr_72093_72137[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72073 === (4))){
var inst_72047 = (state_72072[(7)]);
var inst_72047__$1 = (state_72072[(2)]);
var inst_72048 = cljs.core.ex_data.call(null,inst_72047__$1);
var inst_72049 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_72048);
var inst_72050 = cljs.core._EQ_.call(null,inst_72049,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_72072__$1 = (function (){var statearr_72094 = state_72072;
(statearr_72094[(7)] = inst_72047__$1);

return statearr_72094;
})();
if(inst_72050){
var statearr_72095_72138 = state_72072__$1;
(statearr_72095_72138[(1)] = (5));

} else {
var statearr_72096_72139 = state_72072__$1;
(statearr_72096_72139[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72073 === (13))){
var state_72072__$1 = state_72072;
var statearr_72097_72140 = state_72072__$1;
(statearr_72097_72140[(2)] = null);

(statearr_72097_72140[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72073 === (6))){
var inst_72047 = (state_72072[(7)]);
var inst_72053 = superv.async._track_exception.call(null,S,inst_72047);
var state_72072__$1 = state_72072;
var statearr_72098_72141 = state_72072__$1;
(statearr_72098_72141[(2)] = inst_72053);

(statearr_72098_72141[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72073 === (3))){
var inst_72044 = (state_72072[(2)]);
var inst_72045 = superv.async._unregister_go.call(null,S,id__68171__auto____$1);
var state_72072__$1 = (function (){var statearr_72099 = state_72072;
(statearr_72099[(9)] = inst_72044);

(statearr_72099[(10)] = inst_72045);

return statearr_72099;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72072__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72073 === (12))){
var state_72072__$1 = state_72072;
var statearr_72100_72142 = state_72072__$1;
(statearr_72100_72142[(2)] = null);

(statearr_72100_72142[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72073 === (2))){
var inst_72070 = (state_72072[(2)]);
var state_72072__$1 = state_72072;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72072__$1,inst_72070);
} else {
if((state_val_72073 === (11))){
var inst_72061 = (state_72072[(2)]);
var state_72072__$1 = state_72072;
if(cljs.core.truth_(inst_72061)){
var statearr_72101_72143 = state_72072__$1;
(statearr_72101_72143[(1)] = (12));

} else {
var statearr_72102_72144 = state_72072__$1;
(statearr_72102_72144[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72073 === (9))){
var state_72072__$1 = state_72072;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72072__$1,(11),ch);
} else {
if((state_val_72073 === (5))){
var state_72072__$1 = state_72072;
var statearr_72103_72145 = state_72072__$1;
(statearr_72103_72145[(2)] = null);

(statearr_72103_72145[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72073 === (14))){
var inst_72066 = (state_72072[(2)]);
var state_72072__$1 = state_72072;
var statearr_72104_72146 = state_72072__$1;
(statearr_72104_72146[(2)] = inst_72066);

(statearr_72104_72146[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72073 === (10))){
var inst_72068 = (state_72072[(2)]);
var state_72072__$1 = state_72072;
var statearr_72105_72147 = state_72072__$1;
(statearr_72105_72147[(2)] = inst_72068);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72072__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72073 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_72072,(4),Error,(3),(2));
var state_72072__$1 = state_72072;
var statearr_72106_72148 = state_72072__$1;
(statearr_72106_72148[(2)] = null);

(statearr_72106_72148[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__68170__auto____$1,id__68171__auto____$1,c__50102__auto____$1,inst_72039,inst_72040,inst_72041,inst_72042,inst_72043,inst_72074,state_val_72081,c__50102__auto___72129,c__68170__auto___72127,id__68171__auto___72128))
;
return ((function (switch__50079__auto__,c__68170__auto____$1,id__68171__auto____$1,c__50102__auto____$1,inst_72039,inst_72040,inst_72041,inst_72042,inst_72043,inst_72074,state_val_72081,c__50102__auto___72129,c__68170__auto___72127,id__68171__auto___72128){
return (function() {
var superv$async$state_machine__50080__auto__ = null;
var superv$async$state_machine__50080__auto____0 = (function (){
var statearr_72110 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_72110[(0)] = superv$async$state_machine__50080__auto__);

(statearr_72110[(1)] = (1));

return statearr_72110;
});
var superv$async$state_machine__50080__auto____1 = (function (state_72072){
while(true){
var ret_value__50081__auto__ = (function (){try{while(true){
var result__50082__auto__ = switch__50079__auto__.call(null,state_72072);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50082__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50082__auto__;
}
break;
}
}catch (e72111){if((e72111 instanceof Object)){
var ex__50083__auto__ = e72111;
var statearr_72112_72149 = state_72072;
(statearr_72112_72149[(5)] = ex__50083__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72072);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e72111;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50081__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72150 = state_72072;
state_72072 = G__72150;
continue;
} else {
return ret_value__50081__auto__;
}
break;
}
});
superv$async$state_machine__50080__auto__ = function(state_72072){
switch(arguments.length){
case 0:
return superv$async$state_machine__50080__auto____0.call(this);
case 1:
return superv$async$state_machine__50080__auto____1.call(this,state_72072);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__50080__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__50080__auto____0;
superv$async$state_machine__50080__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__50080__auto____1;
return superv$async$state_machine__50080__auto__;
})()
;})(switch__50079__auto__,c__68170__auto____$1,id__68171__auto____$1,c__50102__auto____$1,inst_72039,inst_72040,inst_72041,inst_72042,inst_72043,inst_72074,state_val_72081,c__50102__auto___72129,c__68170__auto___72127,id__68171__auto___72128))
})();
var state__50104__auto__ = (function (){var statearr_72113 = f__50103__auto__.call(null);
(statearr_72113[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__50102__auto____$1);

return statearr_72113;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50104__auto__);
});
;})(c__68170__auto____$1,id__68171__auto____$1,c__50102__auto____$1,inst_72039,inst_72040,inst_72041,inst_72042,inst_72043,inst_72074,state_val_72081,c__50102__auto___72129,c__68170__auto___72127,id__68171__auto___72128))
})();
var inst_72076 = cljs.core.async.impl.dispatch.run.call(null,inst_72075);
var state_72080__$1 = (function (){var statearr_72114 = state_72080;
(statearr_72114[(11)] = inst_72040);

(statearr_72114[(12)] = inst_72076);

(statearr_72114[(13)] = inst_72039);

return statearr_72114;
})();
var statearr_72115_72151 = state_72080__$1;
(statearr_72115_72151[(2)] = inst_72074);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72080__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__50102__auto___72129,c__68170__auto___72127,id__68171__auto___72128))
;
return ((function (switch__50079__auto__,c__50102__auto___72129,c__68170__auto___72127,id__68171__auto___72128){
return (function() {
var superv$async$state_machine__50080__auto__ = null;
var superv$async$state_machine__50080__auto____0 = (function (){
var statearr_72119 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72119[(0)] = superv$async$state_machine__50080__auto__);

(statearr_72119[(1)] = (1));

return statearr_72119;
});
var superv$async$state_machine__50080__auto____1 = (function (state_72080){
while(true){
var ret_value__50081__auto__ = (function (){try{while(true){
var result__50082__auto__ = switch__50079__auto__.call(null,state_72080);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50082__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50082__auto__;
}
break;
}
}catch (e72120){if((e72120 instanceof Object)){
var ex__50083__auto__ = e72120;
var statearr_72121_72152 = state_72080;
(statearr_72121_72152[(5)] = ex__50083__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72080);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e72120;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50081__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72153 = state_72080;
state_72080 = G__72153;
continue;
} else {
return ret_value__50081__auto__;
}
break;
}
});
superv$async$state_machine__50080__auto__ = function(state_72080){
switch(arguments.length){
case 0:
return superv$async$state_machine__50080__auto____0.call(this);
case 1:
return superv$async$state_machine__50080__auto____1.call(this,state_72080);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__50080__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__50080__auto____0;
superv$async$state_machine__50080__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__50080__auto____1;
return superv$async$state_machine__50080__auto__;
})()
;})(switch__50079__auto__,c__50102__auto___72129,c__68170__auto___72127,id__68171__auto___72128))
})();
var state__50104__auto__ = (function (){var statearr_72122 = f__50103__auto__.call(null);
(statearr_72122[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__50102__auto___72129);

return statearr_72122;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50104__auto__);
});})(c__50102__auto___72129,c__68170__auto___72127,id__68171__auto___72128))
);


return cljs.core.async.sub.call(null,p,topic,ch,close_QMARK_);
});

superv.async.sub.cljs$lang$maxFixedArity = 5;

/**
 * Creates a supervised channel for transducer xform. Exceptions
 *   immediatly propagate to the supervisor.
 */
superv.async.chan_super = (function superv$async$chan_super(S,buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,(function (e){
return cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(S),e);
}));
});
/**
 * Starts a subsystem with supervised go-routines initialized by start-fn.
 *   Restarts the system on error for retries times with a potential delay in
 *   milliseconds, an optional error-fn predicate determining the retry and a
 *   optional filter by exception type. You can optionally pass a supervisor to
 *   form a supervision tree. Whenever this passed supervisor aborts the context,
 *   this supervisor will close as well. You still need to block on the result of
 *   this supervisor if you want a clean synchronized shutdown. The concept is
 *   similar to http://learnyousomeerlang.com/supervisors
 * 
 *   All blocking channel ops in the subroutines (supervised context) are
 *   aborted with an exception on error to force total termination. The
 *   supervisor waits until all supervised go-routines are finished and
 *   have freed resources before restarting.
 * 
 *   If exceptions are not taken from go-try channels (by error), they
 *   become stale after stale-timeout and trigger a restart. 
 */
superv.async.restarting_supervisor = (function superv$async$restarting_supervisor(var_args){
var args__48688__auto__ = [];
var len__48681__auto___72450 = arguments.length;
var i__48682__auto___72451 = (0);
while(true){
if((i__48682__auto___72451 < len__48681__auto___72450)){
args__48688__auto__.push((arguments[i__48682__auto___72451]));

var G__72452 = (i__48682__auto___72451 + (1));
i__48682__auto___72451 = G__72452;
continue;
} else {
}
break;
}

var argseq__48689__auto__ = ((((1) < args__48688__auto__.length))?(new cljs.core.IndexedSeq(args__48688__auto__.slice((1)),(0),null)):null);
return superv.async.restarting_supervisor.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__48689__auto__);
});

superv.async.restarting_supervisor.cljs$core$IFn$_invoke$arity$variadic = (function (start_fn,p__72168){
var map__72169 = p__72168;
var map__72169__$1 = ((((!((map__72169 == null)))?((((map__72169.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72169.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72169):map__72169);
var retries = cljs.core.get.call(null,map__72169__$1,new cljs.core.Keyword(null,"retries","retries",1888092808),Infinity);
var delay = cljs.core.get.call(null,map__72169__$1,new cljs.core.Keyword(null,"delay","delay",-574225219),(0));
var error_fn = cljs.core.get.call(null,map__72169__$1,new cljs.core.Keyword(null,"error-fn","error-fn",-171437615),null);
var exception = cljs.core.get.call(null,map__72169__$1,new cljs.core.Keyword(null,"exception","exception",-335277064),Error);
var stale_timeout = cljs.core.get.call(null,map__72169__$1,new cljs.core.Keyword(null,"stale-timeout","stale-timeout",-468804294),((60) * (1000)));
var log_fn = cljs.core.get.call(null,map__72169__$1,new cljs.core.Keyword(null,"log-fn","log-fn",-2003241282),((function (map__72169,map__72169__$1,retries,delay,error_fn,exception,stale_timeout){
return (function (level,msg){
return cljs.core.println.call(null,level,msg);
});})(map__72169,map__72169__$1,retries,delay,error_fn,exception,stale_timeout))
);
var supervisor = cljs.core.get.call(null,map__72169__$1,new cljs.core.Keyword(null,"supervisor","supervisor",-134060208));
var retries__$1 = (function (){var or__47465__auto__ = retries;
if(cljs.core.truth_(or__47465__auto__)){
return or__47465__auto__;
} else {
return Infinity;
}
})();
var out_ch = cljs.core.async.chan.call(null);
var c__50102__auto___72453 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__50102__auto___72453,retries__$1,out_ch,map__72169,map__72169__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (){
var f__50103__auto__ = (function (){var switch__50079__auto__ = ((function (c__50102__auto___72453,retries__$1,out_ch,map__72169,map__72169__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (state_72354){
var state_val_72355 = (state_72354[(1)]);
if((state_val_72355 === (7))){
var inst_72175 = (state_72354[(7)]);
var inst_72303 = (state_72354[(2)]);
var inst_72304 = cljs.core.nth.call(null,inst_72303,(0),null);
var inst_72305 = cljs.core.nth.call(null,inst_72303,(1),null);
var inst_72306 = cljs.core._EQ_.call(null,inst_72305,inst_72175);
var inst_72307 = !(inst_72306);
var state_72354__$1 = (function (){var statearr_72356 = state_72354;
(statearr_72356[(8)] = inst_72304);

return statearr_72356;
})();
if(inst_72307){
var statearr_72357_72454 = state_72354__$1;
(statearr_72357_72454[(1)] = (8));

} else {
var statearr_72358_72455 = state_72354__$1;
(statearr_72358_72455[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72355 === (1))){
var inst_72171 = retries__$1;
var state_72354__$1 = (function (){var statearr_72359 = state_72354;
(statearr_72359[(9)] = inst_72171);

return statearr_72359;
})();
var statearr_72360_72456 = state_72354__$1;
(statearr_72360_72456[(2)] = null);

(statearr_72360_72456[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72355 === (4))){
var inst_72171 = (state_72354[(9)]);
var inst_72183 = (state_72354[(10)]);
var inst_72173 = (state_72354[(11)]);
var inst_72174 = (state_72354[(12)]);
var inst_72175 = (state_72354[(7)]);
var inst_72184 = (state_72354[(13)]);
var inst_72186 = superv.async.check_supervisor.call(null,superv.async.S);
var inst_72187 = cljs.core.list(cljs.core.list(new cljs.core.Symbol("cljs.core.async","<!","cljs.core.async/<!",1278951036,null),cljs.core.list(new cljs.core.Symbol("superv.async","-abort","superv.async/-abort",-365058004,null),new cljs.core.Symbol(null,"supervisor","supervisor",1506471319,null))),cljs.core.list(new cljs.core.Symbol(null,"close!","close!",-438778971,null),new cljs.core.Symbol(null,"ab-ch","ab-ch",-698106711,null)));
var inst_72188 = superv.async._register_go.call(null,supervisor,inst_72187);
var inst_72213 = cljs.core.async.chan.call(null,(1));
var inst_72214 = (function (){var stale_timeout__$1 = (1000);
var c__68170__auto__ = inst_72186;
var err_ch = inst_72173;
var id__68171__auto__ = inst_72188;
var ab_ch = inst_72174;
var c__50102__auto____$1 = inst_72213;
var res_ch = inst_72184;
var close_ch = inst_72175;
var retries__$2 = inst_72171;
var s = inst_72183;
return ((function (stale_timeout__$1,c__68170__auto__,err_ch,id__68171__auto__,ab_ch,c__50102__auto____$1,res_ch,close_ch,retries__$2,s,inst_72171,inst_72183,inst_72173,inst_72174,inst_72175,inst_72184,inst_72186,inst_72187,inst_72188,inst_72213,state_val_72355,c__50102__auto___72453,retries__$1,out_ch,map__72169,map__72169__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (){
var f__50103__auto__ = (function (){var switch__50079__auto__ = ((function (stale_timeout__$1,c__68170__auto__,err_ch,id__68171__auto__,ab_ch,c__50102__auto____$1,res_ch,close_ch,retries__$2,s,inst_72171,inst_72183,inst_72173,inst_72174,inst_72175,inst_72184,inst_72186,inst_72187,inst_72188,inst_72213,state_val_72355,c__50102__auto___72453,retries__$1,out_ch,map__72169,map__72169__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (state_72211){
var state_val_72212 = (state_72211[(1)]);
if((state_val_72212 === (1))){
var state_72211__$1 = state_72211;
var statearr_72361_72457 = state_72211__$1;
(statearr_72361_72457[(2)] = null);

(statearr_72361_72457[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72212 === (2))){
var inst_72209 = (state_72211[(2)]);
var state_72211__$1 = state_72211;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72211__$1,inst_72209);
} else {
if((state_val_72212 === (3))){
var inst_72189 = (state_72211[(2)]);
var inst_72190 = superv.async._unregister_go.call(null,supervisor,id__68171__auto__);
var state_72211__$1 = (function (){var statearr_72362 = state_72211;
(statearr_72362[(7)] = inst_72190);

(statearr_72362[(8)] = inst_72189);

return statearr_72362;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72211__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72212 === (4))){
var inst_72192 = (state_72211[(9)]);
var inst_72192__$1 = (state_72211[(2)]);
var inst_72193 = cljs.core.ex_data.call(null,inst_72192__$1);
var inst_72194 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_72193);
var inst_72195 = cljs.core._EQ_.call(null,inst_72194,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_72211__$1 = (function (){var statearr_72363 = state_72211;
(statearr_72363[(9)] = inst_72192__$1);

return statearr_72363;
})();
if(inst_72195){
var statearr_72364_72458 = state_72211__$1;
(statearr_72364_72458[(1)] = (5));

} else {
var statearr_72365_72459 = state_72211__$1;
(statearr_72365_72459[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72212 === (5))){
var state_72211__$1 = state_72211;
var statearr_72366_72460 = state_72211__$1;
(statearr_72366_72460[(2)] = null);

(statearr_72366_72460[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72212 === (6))){
var inst_72192 = (state_72211[(9)]);
var inst_72198 = superv.async._track_exception.call(null,supervisor,inst_72192);
var state_72211__$1 = state_72211;
var statearr_72367_72461 = state_72211__$1;
(statearr_72367_72461[(2)] = inst_72198);

(statearr_72367_72461[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72212 === (7))){
var inst_72192 = (state_72211[(9)]);
var inst_72200 = (state_72211[(2)]);
var state_72211__$1 = (function (){var statearr_72368 = state_72211;
(statearr_72368[(10)] = inst_72200);

return statearr_72368;
})();
var statearr_72369_72462 = state_72211__$1;
(statearr_72369_72462[(2)] = inst_72192);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72211__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72212 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_72211,(4),Error,(3),(2));
var inst_72204 = superv.async._abort.call(null,supervisor);
var state_72211__$1 = state_72211;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72211__$1,(9),inst_72204);
} else {
if((state_val_72212 === (9))){
var inst_72206 = (state_72211[(2)]);
var inst_72207 = cljs.core.async.close_BANG_.call(null,ab_ch);
var state_72211__$1 = (function (){var statearr_72370 = state_72211;
(statearr_72370[(11)] = inst_72206);

return statearr_72370;
})();
var statearr_72371_72463 = state_72211__$1;
(statearr_72371_72463[(2)] = inst_72207);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72211__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(stale_timeout__$1,c__68170__auto__,err_ch,id__68171__auto__,ab_ch,c__50102__auto____$1,res_ch,close_ch,retries__$2,s,inst_72171,inst_72183,inst_72173,inst_72174,inst_72175,inst_72184,inst_72186,inst_72187,inst_72188,inst_72213,state_val_72355,c__50102__auto___72453,retries__$1,out_ch,map__72169,map__72169__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
;
return ((function (switch__50079__auto__,stale_timeout__$1,c__68170__auto__,err_ch,id__68171__auto__,ab_ch,c__50102__auto____$1,res_ch,close_ch,retries__$2,s,inst_72171,inst_72183,inst_72173,inst_72174,inst_72175,inst_72184,inst_72186,inst_72187,inst_72188,inst_72213,state_val_72355,c__50102__auto___72453,retries__$1,out_ch,map__72169,map__72169__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function() {
var superv$async$state_machine__50080__auto__ = null;
var superv$async$state_machine__50080__auto____0 = (function (){
var statearr_72375 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72375[(0)] = superv$async$state_machine__50080__auto__);

(statearr_72375[(1)] = (1));

return statearr_72375;
});
var superv$async$state_machine__50080__auto____1 = (function (state_72211){
while(true){
var ret_value__50081__auto__ = (function (){try{while(true){
var result__50082__auto__ = switch__50079__auto__.call(null,state_72211);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50082__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50082__auto__;
}
break;
}
}catch (e72376){if((e72376 instanceof Object)){
var ex__50083__auto__ = e72376;
var statearr_72377_72464 = state_72211;
(statearr_72377_72464[(5)] = ex__50083__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72211);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e72376;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50081__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72465 = state_72211;
state_72211 = G__72465;
continue;
} else {
return ret_value__50081__auto__;
}
break;
}
});
superv$async$state_machine__50080__auto__ = function(state_72211){
switch(arguments.length){
case 0:
return superv$async$state_machine__50080__auto____0.call(this);
case 1:
return superv$async$state_machine__50080__auto____1.call(this,state_72211);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__50080__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__50080__auto____0;
superv$async$state_machine__50080__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__50080__auto____1;
return superv$async$state_machine__50080__auto__;
})()
;})(switch__50079__auto__,stale_timeout__$1,c__68170__auto__,err_ch,id__68171__auto__,ab_ch,c__50102__auto____$1,res_ch,close_ch,retries__$2,s,inst_72171,inst_72183,inst_72173,inst_72174,inst_72175,inst_72184,inst_72186,inst_72187,inst_72188,inst_72213,state_val_72355,c__50102__auto___72453,retries__$1,out_ch,map__72169,map__72169__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var state__50104__auto__ = (function (){var statearr_72378 = f__50103__auto__.call(null);
(statearr_72378[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__50102__auto____$1);

return statearr_72378;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50104__auto__);
});
;})(stale_timeout__$1,c__68170__auto__,err_ch,id__68171__auto__,ab_ch,c__50102__auto____$1,res_ch,close_ch,retries__$2,s,inst_72171,inst_72183,inst_72173,inst_72174,inst_72175,inst_72184,inst_72186,inst_72187,inst_72188,inst_72213,state_val_72355,c__50102__auto___72453,retries__$1,out_ch,map__72169,map__72169__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var inst_72215 = cljs.core.async.impl.dispatch.run.call(null,inst_72214);
var state_72354__$1 = (function (){var statearr_72379 = state_72354;
(statearr_72379[(14)] = inst_72215);

return statearr_72379;
})();
var statearr_72380_72466 = state_72354__$1;
(statearr_72380_72466[(2)] = inst_72213);

(statearr_72380_72466[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72355 === (15))){
var inst_72304 = (state_72354[(8)]);
var inst_72326 = [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72327 = [new cljs.core.Keyword(null,"passing-error","passing-error",-1357712542),inst_72304];
var inst_72328 = cljs.core.PersistentHashMap.fromArrays(inst_72326,inst_72327);
var inst_72329 = log_fn.call(null,new cljs.core.Keyword(null,"error","error",-978969032),inst_72328);
var inst_72330 = cljs.core.async.put_BANG_.call(null,out_ch,inst_72304);
var inst_72331 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_72354__$1 = (function (){var statearr_72381 = state_72354;
(statearr_72381[(15)] = inst_72330);

(statearr_72381[(16)] = inst_72329);

return statearr_72381;
})();
var statearr_72382_72467 = state_72354__$1;
(statearr_72382_72467[(2)] = inst_72331);

(statearr_72382_72467[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72355 === (13))){
var inst_72304 = (state_72354[(8)]);
var inst_72318 = error_fn.call(null,inst_72304);
var state_72354__$1 = state_72354;
var statearr_72383_72468 = state_72354__$1;
(statearr_72383_72468[(2)] = inst_72318);

(statearr_72383_72468[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72355 === (6))){
var inst_72171 = (state_72354[(9)]);
var inst_72183 = (state_72354[(10)]);
var inst_72173 = (state_72354[(11)]);
var inst_72174 = (state_72354[(12)]);
var inst_72175 = (state_72354[(7)]);
var inst_72184 = (state_72354[(13)]);
var inst_72218 = (state_72354[(2)]);
var inst_72265 = cljs.core.async.chan.call(null,(1));
var inst_72266 = (function (){var retries__$2 = inst_72171;
var err_ch = inst_72173;
var ab_ch = inst_72174;
var close_ch = inst_72175;
var s = inst_72183;
var res_ch = inst_72184;
var stale_timeout__$1 = (1000);
var c__50102__auto____$1 = inst_72265;
return ((function (retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__50102__auto____$1,inst_72171,inst_72183,inst_72173,inst_72174,inst_72175,inst_72184,inst_72218,inst_72265,state_val_72355,c__50102__auto___72453,retries__$1,out_ch,map__72169,map__72169__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (){
var f__50103__auto__ = (function (){var switch__50079__auto__ = ((function (retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__50102__auto____$1,inst_72171,inst_72183,inst_72173,inst_72174,inst_72175,inst_72184,inst_72218,inst_72265,state_val_72355,c__50102__auto___72453,retries__$1,out_ch,map__72169,map__72169__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (state_72263){
var state_val_72264 = (state_72263[(1)]);
if((state_val_72264 === (7))){
var inst_72238 = (state_72263[(7)]);
var inst_72225 = (state_72263[(2)]);
var inst_72233 = (function (){return ((function (inst_72238,inst_72225,state_val_72264,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__50102__auto____$1,inst_72171,inst_72183,inst_72173,inst_72174,inst_72175,inst_72184,inst_72218,inst_72265,state_val_72355,c__50102__auto___72453,retries__$1,out_ch,map__72169,map__72169__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (p__72232){
var vec__72384 = p__72232;
var k = cljs.core.nth.call(null,vec__72384,(0),null);
var v = cljs.core.nth.call(null,vec__72384,(1),null);
return ((superv.async.now.call(null).getTime() - stale_timeout__$1) > v.getTime());
});
;})(inst_72238,inst_72225,state_val_72264,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__50102__auto____$1,inst_72171,inst_72183,inst_72173,inst_72174,inst_72175,inst_72184,inst_72218,inst_72265,state_val_72355,c__50102__auto___72453,retries__$1,out_ch,map__72169,map__72169__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var inst_72234 = new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s);
var inst_72235 = cljs.core.deref.call(null,inst_72234);
var inst_72236 = cljs.core.filter.call(null,inst_72233,inst_72235);
var inst_72237 = cljs.core.nth.call(null,inst_72236,(0),null);
var inst_72238__$1 = cljs.core.nth.call(null,inst_72237,(0),null);
var inst_72239 = cljs.core.nth.call(null,inst_72237,(1),null);
var state_72263__$1 = (function (){var statearr_72387 = state_72263;
(statearr_72387[(7)] = inst_72238__$1);

(statearr_72387[(8)] = inst_72239);

(statearr_72387[(9)] = inst_72225);

return statearr_72387;
})();
if(cljs.core.truth_(inst_72238__$1)){
var statearr_72388_72469 = state_72263__$1;
(statearr_72388_72469[(1)] = (8));

} else {
var statearr_72389_72470 = state_72263__$1;
(statearr_72389_72470[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72264 === (1))){
var state_72263__$1 = state_72263;
var statearr_72390_72471 = state_72263__$1;
(statearr_72390_72471[(2)] = null);

(statearr_72390_72471[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72264 === (4))){
var state_72263__$1 = state_72263;
var statearr_72391_72472 = state_72263__$1;
(statearr_72391_72472[(2)] = null);

(statearr_72391_72472[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72264 === (13))){
var inst_72238 = (state_72263[(7)]);
var inst_72251 = (state_72263[(2)]);
var inst_72252 = superv.async._free_exception.call(null,s,inst_72238);
var inst_72253 = cljs.core.async.put_BANG_.call(null,err_ch,inst_72238);
var state_72263__$1 = (function (){var statearr_72392 = state_72263;
(statearr_72392[(10)] = inst_72252);

(statearr_72392[(11)] = inst_72251);

return statearr_72392;
})();
var statearr_72393_72473 = state_72263__$1;
(statearr_72393_72473[(2)] = inst_72253);

(statearr_72393_72473[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72264 === (6))){
var inst_72259 = (state_72263[(2)]);
var state_72263__$1 = state_72263;
var statearr_72394_72474 = state_72263__$1;
(statearr_72394_72474[(2)] = inst_72259);

(statearr_72394_72474[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72264 === (3))){
var inst_72261 = (state_72263[(2)]);
var state_72263__$1 = state_72263;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72263__$1,inst_72261);
} else {
if((state_val_72264 === (12))){
var inst_72238 = (state_72263[(7)]);
var inst_72246 = [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72247 = [new cljs.core.Keyword(null,"stale-error-in-supervisor","stale-error-in-supervisor",-123257662),inst_72238];
var inst_72248 = cljs.core.PersistentHashMap.fromArrays(inst_72246,inst_72247);
var inst_72249 = log_fn.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_72248);
var state_72263__$1 = state_72263;
var statearr_72395_72475 = state_72263__$1;
(statearr_72395_72475[(2)] = inst_72249);

(statearr_72395_72475[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72264 === (2))){
var inst_72220 = cljs.core.async.poll_BANG_.call(null,ab_ch);
var state_72263__$1 = state_72263;
if(cljs.core.truth_(inst_72220)){
var statearr_72396_72476 = state_72263__$1;
(statearr_72396_72476[(1)] = (4));

} else {
var statearr_72397_72477 = state_72263__$1;
(statearr_72397_72477[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72264 === (11))){
var state_72263__$1 = state_72263;
var statearr_72398_72478 = state_72263__$1;
(statearr_72398_72478[(2)] = null);

(statearr_72398_72478[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72264 === (9))){
var state_72263__$1 = state_72263;
var statearr_72399_72479 = state_72263__$1;
(statearr_72399_72479[(2)] = null);

(statearr_72399_72479[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72264 === (5))){
var inst_72223 = cljs.core.async.timeout.call(null,stale_timeout__$1);
var state_72263__$1 = state_72263;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72263__$1,(7),inst_72223);
} else {
if((state_val_72264 === (10))){
var inst_72257 = (state_72263[(2)]);
var state_72263__$1 = state_72263;
var statearr_72400_72480 = state_72263__$1;
(statearr_72400_72480[(2)] = inst_72257);

(statearr_72400_72480[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72264 === (8))){
var inst_72238 = (state_72263[(7)]);
var inst_72241 = cljs.core.ex_data.call(null,inst_72238);
var inst_72242 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_72241);
var inst_72243 = cljs.core._EQ_.call(null,inst_72242,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_72263__$1 = state_72263;
if(inst_72243){
var statearr_72401_72481 = state_72263__$1;
(statearr_72401_72481[(1)] = (11));

} else {
var statearr_72402_72482 = state_72263__$1;
(statearr_72402_72482[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__50102__auto____$1,inst_72171,inst_72183,inst_72173,inst_72174,inst_72175,inst_72184,inst_72218,inst_72265,state_val_72355,c__50102__auto___72453,retries__$1,out_ch,map__72169,map__72169__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
;
return ((function (switch__50079__auto__,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__50102__auto____$1,inst_72171,inst_72183,inst_72173,inst_72174,inst_72175,inst_72184,inst_72218,inst_72265,state_val_72355,c__50102__auto___72453,retries__$1,out_ch,map__72169,map__72169__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function() {
var superv$async$state_machine__50080__auto__ = null;
var superv$async$state_machine__50080__auto____0 = (function (){
var statearr_72406 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72406[(0)] = superv$async$state_machine__50080__auto__);

(statearr_72406[(1)] = (1));

return statearr_72406;
});
var superv$async$state_machine__50080__auto____1 = (function (state_72263){
while(true){
var ret_value__50081__auto__ = (function (){try{while(true){
var result__50082__auto__ = switch__50079__auto__.call(null,state_72263);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50082__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50082__auto__;
}
break;
}
}catch (e72407){if((e72407 instanceof Object)){
var ex__50083__auto__ = e72407;
var statearr_72408_72483 = state_72263;
(statearr_72408_72483[(5)] = ex__50083__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72263);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e72407;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50081__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72484 = state_72263;
state_72263 = G__72484;
continue;
} else {
return ret_value__50081__auto__;
}
break;
}
});
superv$async$state_machine__50080__auto__ = function(state_72263){
switch(arguments.length){
case 0:
return superv$async$state_machine__50080__auto____0.call(this);
case 1:
return superv$async$state_machine__50080__auto____1.call(this,state_72263);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__50080__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__50080__auto____0;
superv$async$state_machine__50080__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__50080__auto____1;
return superv$async$state_machine__50080__auto__;
})()
;})(switch__50079__auto__,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__50102__auto____$1,inst_72171,inst_72183,inst_72173,inst_72174,inst_72175,inst_72184,inst_72218,inst_72265,state_val_72355,c__50102__auto___72453,retries__$1,out_ch,map__72169,map__72169__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var state__50104__auto__ = (function (){var statearr_72409 = f__50103__auto__.call(null);
(statearr_72409[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__50102__auto____$1);

return statearr_72409;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50104__auto__);
});
;})(retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__50102__auto____$1,inst_72171,inst_72183,inst_72173,inst_72174,inst_72175,inst_72184,inst_72218,inst_72265,state_val_72355,c__50102__auto___72453,retries__$1,out_ch,map__72169,map__72169__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var inst_72267 = cljs.core.async.impl.dispatch.run.call(null,inst_72266);
var inst_72293 = cljs.core.async.chan.call(null,(1));
var inst_72294 = (function (){var retries__$2 = inst_72171;
var err_ch = inst_72173;
var ab_ch = inst_72174;
var close_ch = inst_72175;
var s = inst_72183;
var res_ch = inst_72184;
var stale_timeout__$1 = (1000);
var c__50102__auto____$1 = inst_72293;
return ((function (retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__50102__auto____$1,inst_72171,inst_72183,inst_72173,inst_72174,inst_72175,inst_72184,inst_72218,inst_72265,inst_72266,inst_72267,inst_72293,state_val_72355,c__50102__auto___72453,retries__$1,out_ch,map__72169,map__72169__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (){
var f__50103__auto__ = (function (){var switch__50079__auto__ = ((function (retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__50102__auto____$1,inst_72171,inst_72183,inst_72173,inst_72174,inst_72175,inst_72184,inst_72218,inst_72265,inst_72266,inst_72267,inst_72293,state_val_72355,c__50102__auto___72453,retries__$1,out_ch,map__72169,map__72169__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (state_72291){
var state_val_72292 = (state_72291[(1)]);
if((state_val_72292 === (1))){
var inst_72268 = (0);
var state_72291__$1 = (function (){var statearr_72410 = state_72291;
(statearr_72410[(7)] = inst_72268);

return statearr_72410;
})();
var statearr_72411_72485 = state_72291__$1;
(statearr_72411_72485[(2)] = null);

(statearr_72411_72485[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72292 === (2))){
var inst_72270 = new cljs.core.Keyword(null,"registered","registered",-388600037).cljs$core$IFn$_invoke$arity$1(s);
var inst_72271 = cljs.core.deref.call(null,inst_72270);
var inst_72272 = cljs.core.empty_QMARK_.call(null,inst_72271);
var inst_72273 = new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s);
var inst_72274 = cljs.core.deref.call(null,inst_72273);
var inst_72275 = cljs.core.empty_QMARK_.call(null,inst_72274);
var inst_72276 = (inst_72272) && (inst_72275);
var inst_72277 = cljs.core.not.call(null,inst_72276);
var state_72291__$1 = state_72291;
if(inst_72277){
var statearr_72412_72486 = state_72291__$1;
(statearr_72412_72486[(1)] = (4));

} else {
var statearr_72413_72487 = state_72291__$1;
(statearr_72413_72487[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72292 === (3))){
var inst_72289 = (state_72291[(2)]);
var state_72291__$1 = state_72291;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72291__$1,inst_72289);
} else {
if((state_val_72292 === (4))){
var inst_72279 = cljs.core.async.timeout.call(null,(100));
var state_72291__$1 = state_72291;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72291__$1,(7),inst_72279);
} else {
if((state_val_72292 === (5))){
var inst_72285 = cljs.core.async.close_BANG_.call(null,close_ch);
var state_72291__$1 = state_72291;
var statearr_72414_72488 = state_72291__$1;
(statearr_72414_72488[(2)] = inst_72285);

(statearr_72414_72488[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72292 === (6))){
var inst_72287 = (state_72291[(2)]);
var state_72291__$1 = state_72291;
var statearr_72415_72489 = state_72291__$1;
(statearr_72415_72489[(2)] = inst_72287);

(statearr_72415_72489[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72292 === (7))){
var inst_72268 = (state_72291[(7)]);
var inst_72281 = (state_72291[(2)]);
var inst_72282 = (inst_72268 + (1));
var inst_72268__$1 = inst_72282;
var state_72291__$1 = (function (){var statearr_72416 = state_72291;
(statearr_72416[(8)] = inst_72281);

(statearr_72416[(7)] = inst_72268__$1);

return statearr_72416;
})();
var statearr_72417_72490 = state_72291__$1;
(statearr_72417_72490[(2)] = null);

(statearr_72417_72490[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__50102__auto____$1,inst_72171,inst_72183,inst_72173,inst_72174,inst_72175,inst_72184,inst_72218,inst_72265,inst_72266,inst_72267,inst_72293,state_val_72355,c__50102__auto___72453,retries__$1,out_ch,map__72169,map__72169__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
;
return ((function (switch__50079__auto__,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__50102__auto____$1,inst_72171,inst_72183,inst_72173,inst_72174,inst_72175,inst_72184,inst_72218,inst_72265,inst_72266,inst_72267,inst_72293,state_val_72355,c__50102__auto___72453,retries__$1,out_ch,map__72169,map__72169__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function() {
var superv$async$state_machine__50080__auto__ = null;
var superv$async$state_machine__50080__auto____0 = (function (){
var statearr_72421 = [null,null,null,null,null,null,null,null,null];
(statearr_72421[(0)] = superv$async$state_machine__50080__auto__);

(statearr_72421[(1)] = (1));

return statearr_72421;
});
var superv$async$state_machine__50080__auto____1 = (function (state_72291){
while(true){
var ret_value__50081__auto__ = (function (){try{while(true){
var result__50082__auto__ = switch__50079__auto__.call(null,state_72291);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50082__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50082__auto__;
}
break;
}
}catch (e72422){if((e72422 instanceof Object)){
var ex__50083__auto__ = e72422;
var statearr_72423_72491 = state_72291;
(statearr_72423_72491[(5)] = ex__50083__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72291);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e72422;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50081__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72492 = state_72291;
state_72291 = G__72492;
continue;
} else {
return ret_value__50081__auto__;
}
break;
}
});
superv$async$state_machine__50080__auto__ = function(state_72291){
switch(arguments.length){
case 0:
return superv$async$state_machine__50080__auto____0.call(this);
case 1:
return superv$async$state_machine__50080__auto____1.call(this,state_72291);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__50080__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__50080__auto____0;
superv$async$state_machine__50080__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__50080__auto____1;
return superv$async$state_machine__50080__auto__;
})()
;})(switch__50079__auto__,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__50102__auto____$1,inst_72171,inst_72183,inst_72173,inst_72174,inst_72175,inst_72184,inst_72218,inst_72265,inst_72266,inst_72267,inst_72293,state_val_72355,c__50102__auto___72453,retries__$1,out_ch,map__72169,map__72169__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var state__50104__auto__ = (function (){var statearr_72424 = f__50103__auto__.call(null);
(statearr_72424[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__50102__auto____$1);

return statearr_72424;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50104__auto__);
});
;})(retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__50102__auto____$1,inst_72171,inst_72183,inst_72173,inst_72174,inst_72175,inst_72184,inst_72218,inst_72265,inst_72266,inst_72267,inst_72293,state_val_72355,c__50102__auto___72453,retries__$1,out_ch,map__72169,map__72169__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var inst_72295 = cljs.core.async.impl.dispatch.run.call(null,inst_72294);
var inst_72299 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72300 = [inst_72173,inst_72175];
var inst_72301 = (new cljs.core.PersistentVector(null,2,(5),inst_72299,inst_72300,null));
var state_72354__$1 = (function (){var statearr_72425 = state_72354;
(statearr_72425[(17)] = inst_72267);

(statearr_72425[(18)] = inst_72295);

(statearr_72425[(19)] = inst_72218);

return statearr_72425;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_72354__$1,(7),inst_72301,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_72355 === (17))){
var inst_72343 = (state_72354[(2)]);
var state_72354__$1 = state_72354;
var statearr_72426_72493 = state_72354__$1;
(statearr_72426_72493[(2)] = inst_72343);

(statearr_72426_72493[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72355 === (3))){
var inst_72352 = (state_72354[(2)]);
var state_72354__$1 = state_72354;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72354__$1,inst_72352);
} else {
if((state_val_72355 === (12))){
var inst_72315 = (state_72354[(20)]);
var state_72354__$1 = state_72354;
var statearr_72427_72494 = state_72354__$1;
(statearr_72427_72494[(2)] = inst_72315);

(statearr_72427_72494[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72355 === (2))){
var inst_72183 = (state_72354[(10)]);
var inst_72173 = (state_72354[(11)]);
var inst_72174 = (state_72354[(12)]);
var inst_72173__$1 = cljs.core.async.chan.call(null);
var inst_72174__$1 = cljs.core.async.chan.call(null);
var inst_72175 = cljs.core.async.chan.call(null);
var inst_72176 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),new cljs.core.Keyword(null,"restarting","restarting",760677572)];
var inst_72177 = cljs.core.PersistentHashMap.EMPTY;
var inst_72178 = cljs.core.atom.call(null,inst_72177);
var inst_72179 = cljs.core.PersistentHashMap.EMPTY;
var inst_72180 = cljs.core.atom.call(null,inst_72179);
var inst_72181 = [inst_72173__$1,inst_72174__$1,inst_72178,inst_72180,true];
var inst_72182 = cljs.core.PersistentHashMap.fromArrays(inst_72176,inst_72181);
var inst_72183__$1 = superv.async.map__GT_TrackingSupervisor.call(null,inst_72182);
var inst_72184 = start_fn.call(null,inst_72183__$1);
var state_72354__$1 = (function (){var statearr_72428 = state_72354;
(statearr_72428[(10)] = inst_72183__$1);

(statearr_72428[(11)] = inst_72173__$1);

(statearr_72428[(12)] = inst_72174__$1);

(statearr_72428[(7)] = inst_72175);

(statearr_72428[(13)] = inst_72184);

return statearr_72428;
})();
if(cljs.core.truth_(supervisor)){
var statearr_72429_72495 = state_72354__$1;
(statearr_72429_72495[(1)] = (4));

} else {
var statearr_72430_72496 = state_72354__$1;
(statearr_72430_72496[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72355 === (19))){
var inst_72346 = (state_72354[(2)]);
var inst_72347 = cljs.core.async.put_BANG_.call(null,out_ch,inst_72346);
var inst_72348 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_72354__$1 = (function (){var statearr_72431 = state_72354;
(statearr_72431[(21)] = inst_72347);

return statearr_72431;
})();
var statearr_72432_72497 = state_72354__$1;
(statearr_72432_72497[(2)] = inst_72348);

(statearr_72432_72497[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72355 === (11))){
var inst_72304 = (state_72354[(8)]);
var inst_72315 = (state_72354[(20)]);
var inst_72312 = (state_72354[(2)]);
var inst_72313 = (inst_72304 instanceof exception);
var inst_72314 = cljs.core.not.call(null,inst_72313);
var inst_72315__$1 = cljs.core.not.call(null,error_fn);
var state_72354__$1 = (function (){var statearr_72433 = state_72354;
(statearr_72433[(22)] = inst_72312);

(statearr_72433[(23)] = inst_72314);

(statearr_72433[(20)] = inst_72315__$1);

return statearr_72433;
})();
if(inst_72315__$1){
var statearr_72434_72498 = state_72354__$1;
(statearr_72434_72498[(1)] = (12));

} else {
var statearr_72435_72499 = state_72354__$1;
(statearr_72435_72499[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72355 === (9))){
var inst_72184 = (state_72354[(13)]);
var state_72354__$1 = state_72354;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72354__$1,(19),inst_72184);
} else {
if((state_val_72355 === (5))){
var state_72354__$1 = state_72354;
var statearr_72436_72500 = state_72354__$1;
(statearr_72436_72500[(2)] = null);

(statearr_72436_72500[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72355 === (14))){
var inst_72171 = (state_72354[(9)]);
var inst_72314 = (state_72354[(23)]);
var inst_72320 = (state_72354[(2)]);
var inst_72321 = cljs.core.not.call(null,inst_72320);
var inst_72322 = (inst_72171 > (0));
var inst_72323 = cljs.core.not.call(null,inst_72322);
var inst_72324 = (inst_72314) || (inst_72321) || (inst_72323);
var state_72354__$1 = state_72354;
if(cljs.core.truth_(inst_72324)){
var statearr_72437_72501 = state_72354__$1;
(statearr_72437_72501[(1)] = (15));

} else {
var statearr_72438_72502 = state_72354__$1;
(statearr_72438_72502[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72355 === (16))){
var inst_72333 = cljs.core.async.timeout.call(null,delay);
var state_72354__$1 = state_72354;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72354__$1,(18),inst_72333);
} else {
if((state_val_72355 === (10))){
var inst_72350 = (state_72354[(2)]);
var state_72354__$1 = state_72354;
var statearr_72439_72503 = state_72354__$1;
(statearr_72439_72503[(2)] = inst_72350);

(statearr_72439_72503[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72355 === (18))){
var inst_72304 = (state_72354[(8)]);
var inst_72171 = (state_72354[(9)]);
var inst_72335 = (state_72354[(2)]);
var inst_72336 = [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"further-retries","further-retries",1297645153)];
var inst_72337 = [new cljs.core.Keyword(null,"retry","retry",-614012896),inst_72304,inst_72171];
var inst_72338 = cljs.core.PersistentHashMap.fromArrays(inst_72336,inst_72337);
var inst_72339 = log_fn.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),inst_72338);
var inst_72340 = (inst_72171 - (1));
var inst_72171__$1 = inst_72340;
var state_72354__$1 = (function (){var statearr_72440 = state_72354;
(statearr_72440[(9)] = inst_72171__$1);

(statearr_72440[(24)] = inst_72339);

(statearr_72440[(25)] = inst_72335);

return statearr_72440;
})();
var statearr_72441_72504 = state_72354__$1;
(statearr_72441_72504[(2)] = null);

(statearr_72441_72504[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72355 === (8))){
var inst_72173 = (state_72354[(11)]);
var inst_72174 = (state_72354[(12)]);
var inst_72175 = (state_72354[(7)]);
var inst_72309 = cljs.core.async.close_BANG_.call(null,inst_72173);
var inst_72310 = cljs.core.async.close_BANG_.call(null,inst_72174);
var state_72354__$1 = (function (){var statearr_72442 = state_72354;
(statearr_72442[(26)] = inst_72310);

(statearr_72442[(27)] = inst_72309);

return statearr_72442;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72354__$1,(11),inst_72175);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__50102__auto___72453,retries__$1,out_ch,map__72169,map__72169__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
;
return ((function (switch__50079__auto__,c__50102__auto___72453,retries__$1,out_ch,map__72169,map__72169__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function() {
var superv$async$state_machine__50080__auto__ = null;
var superv$async$state_machine__50080__auto____0 = (function (){
var statearr_72446 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72446[(0)] = superv$async$state_machine__50080__auto__);

(statearr_72446[(1)] = (1));

return statearr_72446;
});
var superv$async$state_machine__50080__auto____1 = (function (state_72354){
while(true){
var ret_value__50081__auto__ = (function (){try{while(true){
var result__50082__auto__ = switch__50079__auto__.call(null,state_72354);
if(cljs.core.keyword_identical_QMARK_.call(null,result__50082__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__50082__auto__;
}
break;
}
}catch (e72447){if((e72447 instanceof Object)){
var ex__50083__auto__ = e72447;
var statearr_72448_72505 = state_72354;
(statearr_72448_72505[(5)] = ex__50083__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72354);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e72447;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__50081__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72506 = state_72354;
state_72354 = G__72506;
continue;
} else {
return ret_value__50081__auto__;
}
break;
}
});
superv$async$state_machine__50080__auto__ = function(state_72354){
switch(arguments.length){
case 0:
return superv$async$state_machine__50080__auto____0.call(this);
case 1:
return superv$async$state_machine__50080__auto____1.call(this,state_72354);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__50080__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__50080__auto____0;
superv$async$state_machine__50080__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__50080__auto____1;
return superv$async$state_machine__50080__auto__;
})()
;})(switch__50079__auto__,c__50102__auto___72453,retries__$1,out_ch,map__72169,map__72169__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var state__50104__auto__ = (function (){var statearr_72449 = f__50103__auto__.call(null);
(statearr_72449[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__50102__auto___72453);

return statearr_72449;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__50104__auto__);
});})(c__50102__auto___72453,retries__$1,out_ch,map__72169,map__72169__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
);


return out_ch;
});

superv.async.restarting_supervisor.cljs$lang$maxFixedArity = (1);

superv.async.restarting_supervisor.cljs$lang$applyTo = (function (seq72166){
var G__72167 = cljs.core.first.call(null,seq72166);
var seq72166__$1 = cljs.core.next.call(null,seq72166);
return superv.async.restarting_supervisor.cljs$core$IFn$_invoke$arity$variadic(G__72167,seq72166__$1);
});


//# sourceMappingURL=async.js.map?rel=1483105114545