// Compiled by ClojureScript 1.9.293 {}
goog.provide('superv.async');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('cljs.spec');
goog.require('cljs.core.async.impl.protocols');
/**
 * Take the &env from a macro, and tell whether we are expanding into cljs.
 */
superv.async.cljs_env_QMARK_ = (function superv$async$cljs_env_QMARK_(env){
return cljs.core.boolean$.call(null,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(env));
});

/**
 * @interface
 */
superv.async.PSupervisor = function(){};

superv.async._error = (function superv$async$_error(this$){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_error$arity$1 == null)))){
return this$.superv$async$PSupervisor$_error$arity$1(this$);
} else {
var x__10098__auto__ = (((this$ == null))?null:this$);
var m__10099__auto__ = (superv.async._error[goog.typeOf(x__10098__auto__)]);
if(!((m__10099__auto__ == null))){
return m__10099__auto__.call(null,this$);
} else {
var m__10099__auto____$1 = (superv.async._error["_"]);
if(!((m__10099__auto____$1 == null))){
return m__10099__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-error",this$);
}
}
}
});

superv.async._abort = (function superv$async$_abort(this$){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_abort$arity$1 == null)))){
return this$.superv$async$PSupervisor$_abort$arity$1(this$);
} else {
var x__10098__auto__ = (((this$ == null))?null:this$);
var m__10099__auto__ = (superv.async._abort[goog.typeOf(x__10098__auto__)]);
if(!((m__10099__auto__ == null))){
return m__10099__auto__.call(null,this$);
} else {
var m__10099__auto____$1 = (superv.async._abort["_"]);
if(!((m__10099__auto____$1 == null))){
return m__10099__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-abort",this$);
}
}
}
});

superv.async._register_go = (function superv$async$_register_go(this$,body){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_register_go$arity$2 == null)))){
return this$.superv$async$PSupervisor$_register_go$arity$2(this$,body);
} else {
var x__10098__auto__ = (((this$ == null))?null:this$);
var m__10099__auto__ = (superv.async._register_go[goog.typeOf(x__10098__auto__)]);
if(!((m__10099__auto__ == null))){
return m__10099__auto__.call(null,this$,body);
} else {
var m__10099__auto____$1 = (superv.async._register_go["_"]);
if(!((m__10099__auto____$1 == null))){
return m__10099__auto____$1.call(null,this$,body);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-register-go",this$);
}
}
}
});

superv.async._unregister_go = (function superv$async$_unregister_go(this$,id){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_unregister_go$arity$2 == null)))){
return this$.superv$async$PSupervisor$_unregister_go$arity$2(this$,id);
} else {
var x__10098__auto__ = (((this$ == null))?null:this$);
var m__10099__auto__ = (superv.async._unregister_go[goog.typeOf(x__10098__auto__)]);
if(!((m__10099__auto__ == null))){
return m__10099__auto__.call(null,this$,id);
} else {
var m__10099__auto____$1 = (superv.async._unregister_go["_"]);
if(!((m__10099__auto____$1 == null))){
return m__10099__auto____$1.call(null,this$,id);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-unregister-go",this$);
}
}
}
});

superv.async._track_exception = (function superv$async$_track_exception(this$,e){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_track_exception$arity$2 == null)))){
return this$.superv$async$PSupervisor$_track_exception$arity$2(this$,e);
} else {
var x__10098__auto__ = (((this$ == null))?null:this$);
var m__10099__auto__ = (superv.async._track_exception[goog.typeOf(x__10098__auto__)]);
if(!((m__10099__auto__ == null))){
return m__10099__auto__.call(null,this$,e);
} else {
var m__10099__auto____$1 = (superv.async._track_exception["_"]);
if(!((m__10099__auto____$1 == null))){
return m__10099__auto____$1.call(null,this$,e);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-track-exception",this$);
}
}
}
});

superv.async._free_exception = (function superv$async$_free_exception(this$,e){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_free_exception$arity$2 == null)))){
return this$.superv$async$PSupervisor$_free_exception$arity$2(this$,e);
} else {
var x__10098__auto__ = (((this$ == null))?null:this$);
var m__10099__auto__ = (superv.async._free_exception[goog.typeOf(x__10098__auto__)]);
if(!((m__10099__auto__ == null))){
return m__10099__auto__.call(null,this$,e);
} else {
var m__10099__auto____$1 = (superv.async._free_exception["_"]);
if(!((m__10099__auto____$1 == null))){
return m__10099__auto____$1.call(null,this$,e);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-free-exception",this$);
}
}
}
});

superv.async.now = (function superv$async$now(){
return (new Date());
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {superv.async.PSupervisor}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
superv.async.TrackingSupervisor = (function (error,abort,registered,pending_exceptions,__meta,__extmap,__hash){
this.error = error;
this.abort = abort;
this.registered = registered;
this.pending_exceptions = pending_exceptions;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
superv.async.TrackingSupervisor.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__10055__auto__,k__10056__auto__){
var self__ = this;
var this__10055__auto____$1 = this;
return cljs.core._lookup.call(null,this__10055__auto____$1,k__10056__auto__,null);
});

superv.async.TrackingSupervisor.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__10057__auto__,k21137,else__10058__auto__){
var self__ = this;
var this__10057__auto____$1 = this;
var G__21139 = (((k21137 instanceof cljs.core.Keyword))?k21137.fqn:null);
switch (G__21139) {
case "error":
return self__.error;

break;
case "abort":
return self__.abort;

break;
case "registered":
return self__.registered;

break;
case "pending-exceptions":
return self__.pending_exceptions;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k21137,else__10058__auto__);

}
});

superv.async.TrackingSupervisor.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__10069__auto__,writer__10070__auto__,opts__10071__auto__){
var self__ = this;
var this__10069__auto____$1 = this;
var pr_pair__10072__auto__ = ((function (this__10069__auto____$1){
return (function (keyval__10073__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__10070__auto__,cljs.core.pr_writer,""," ","",opts__10071__auto__,keyval__10073__auto__);
});})(this__10069__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__10070__auto__,pr_pair__10072__auto__,"#superv.async.TrackingSupervisor{",", ","}",opts__10071__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error","error",-978969032),self__.error],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abort","abort",521193198),self__.abort],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"registered","registered",-388600037),self__.registered],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),self__.pending_exceptions],null))], null),self__.__extmap));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

superv.async.TrackingSupervisor.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__21136){
var self__ = this;
var G__21136__$1 = this;
return (new cljs.core.RecordIter((0),G__21136__$1,4,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__10053__auto__){
var self__ = this;
var this__10053__auto____$1 = this;
return self__.__meta;
});

superv.async.TrackingSupervisor.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__10049__auto__){
var self__ = this;
var this__10049__auto____$1 = this;
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,self__.__hash));
});

superv.async.TrackingSupervisor.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__10059__auto__){
var self__ = this;
var this__10059__auto____$1 = this;
return (4 + cljs.core.count.call(null,self__.__extmap));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__10050__auto__){
var self__ = this;
var this__10050__auto____$1 = this;
var h__9822__auto__ = self__.__hash;
if(!((h__9822__auto__ == null))){
return h__9822__auto__;
} else {
var h__9822__auto____$1 = cljs.core.hash_imap.call(null,this__10050__auto____$1);
self__.__hash = h__9822__auto____$1;

return h__9822__auto____$1;
}
});

superv.async.TrackingSupervisor.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__10051__auto__,other__10052__auto__){
var self__ = this;
var this__10051__auto____$1 = this;
if(cljs.core.truth_((function (){var and__9373__auto__ = other__10052__auto__;
if(cljs.core.truth_(and__9373__auto__)){
var and__9373__auto____$1 = (this__10051__auto____$1.constructor === other__10052__auto__.constructor);
if(and__9373__auto____$1){
return cljs.core.equiv_map.call(null,this__10051__auto____$1,other__10052__auto__);
} else {
return and__9373__auto____$1;
}
} else {
return and__9373__auto__;
}
})())){
return true;
} else {
return false;
}
});

superv.async.TrackingSupervisor.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__10064__auto__,k__10065__auto__){
var self__ = this;
var this__10064__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),null,new cljs.core.Keyword(null,"abort","abort",521193198),null,new cljs.core.Keyword(null,"error","error",-978969032),null,new cljs.core.Keyword(null,"registered","registered",-388600037),null], null), null),k__10065__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__10064__auto____$1),self__.__meta),k__10065__auto__);
} else {
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__10065__auto__)),null));
}
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$ = cljs.core.PROTOCOL_SENTINEL;

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_error$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.error;
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_abort$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.abort;
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_register_go$arity$2 = (function (this$,body){
var self__ = this;
var this$__$1 = this;
var id = cljs.core.random_uuid.call(null);
cljs.core.swap_BANG_.call(null,self__.registered,cljs.core.assoc,id,body);

return id;
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_unregister_go$arity$2 = (function (this$,id){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.registered,cljs.core.dissoc,id);
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_track_exception$arity$2 = (function (this$,e){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.pending_exceptions,cljs.core.assoc,e,superv.async.now.call(null));
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_free_exception$arity$2 = (function (this$,e){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.pending_exceptions,cljs.core.dissoc,e);
});

superv.async.TrackingSupervisor.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__10062__auto__,k__10063__auto__,G__21136){
var self__ = this;
var this__10062__auto____$1 = this;
var pred__21140 = cljs.core.keyword_identical_QMARK_;
var expr__21141 = k__10063__auto__;
if(cljs.core.truth_(pred__21140.call(null,new cljs.core.Keyword(null,"error","error",-978969032),expr__21141))){
return (new superv.async.TrackingSupervisor(G__21136,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21140.call(null,new cljs.core.Keyword(null,"abort","abort",521193198),expr__21141))){
return (new superv.async.TrackingSupervisor(self__.error,G__21136,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21140.call(null,new cljs.core.Keyword(null,"registered","registered",-388600037),expr__21141))){
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,G__21136,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21140.call(null,new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),expr__21141))){
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,G__21136,self__.__meta,self__.__extmap,null));
} else {
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__10063__auto__,G__21136),null));
}
}
}
}
});

superv.async.TrackingSupervisor.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__10067__auto__){
var self__ = this;
var this__10067__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error","error",-978969032),self__.error],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abort","abort",521193198),self__.abort],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"registered","registered",-388600037),self__.registered],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),self__.pending_exceptions],null))], null),self__.__extmap));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__10054__auto__,G__21136){
var self__ = this;
var this__10054__auto____$1 = this;
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,G__21136,self__.__extmap,self__.__hash));
});

superv.async.TrackingSupervisor.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__10060__auto__,entry__10061__auto__){
var self__ = this;
var this__10060__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__10061__auto__)){
return cljs.core._assoc.call(null,this__10060__auto____$1,cljs.core._nth.call(null,entry__10061__auto__,(0)),cljs.core._nth.call(null,entry__10061__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__10060__auto____$1,entry__10061__auto__);
}
});

superv.async.TrackingSupervisor.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"error","error",661562495,null),new cljs.core.Symbol(null,"abort","abort",-2133242571,null),new cljs.core.Symbol(null,"registered","registered",1251931490,null),new cljs.core.Symbol(null,"pending-exceptions","pending-exceptions",-247748567,null)], null);
});

superv.async.TrackingSupervisor.cljs$lang$type = true;

superv.async.TrackingSupervisor.cljs$lang$ctorPrSeq = (function (this__10091__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"superv.async/TrackingSupervisor");
});

superv.async.TrackingSupervisor.cljs$lang$ctorPrWriter = (function (this__10091__auto__,writer__10092__auto__){
return cljs.core._write.call(null,writer__10092__auto__,"superv.async/TrackingSupervisor");
});

superv.async.__GT_TrackingSupervisor = (function superv$async$__GT_TrackingSupervisor(error,abort,registered,pending_exceptions){
return (new superv.async.TrackingSupervisor(error,abort,registered,pending_exceptions,null,null,null));
});

superv.async.map__GT_TrackingSupervisor = (function superv$async$map__GT_TrackingSupervisor(G__21138){
return (new superv.async.TrackingSupervisor(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(G__21138),new cljs.core.Keyword(null,"abort","abort",521193198).cljs$core$IFn$_invoke$arity$1(G__21138),new cljs.core.Keyword(null,"registered","registered",-388600037).cljs$core$IFn$_invoke$arity$1(G__21138),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(G__21138),null,cljs.core.dissoc.call(null,G__21138,new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094)),null));
});

cljs.core.enable_console_print_BANG_.call(null);
/**
 * A simple supervisor which deals with errors through callbacks.
 */
superv.async.simple_supervisor = (function superv$async$simple_supervisor(var_args){
var args__10608__auto__ = [];
var len__10601__auto___21168 = arguments.length;
var i__10602__auto___21169 = (0);
while(true){
if((i__10602__auto___21169 < len__10601__auto___21168)){
args__10608__auto__.push((arguments[i__10602__auto___21169]));

var G__21170 = (i__10602__auto___21169 + (1));
i__10602__auto___21169 = G__21170;
continue;
} else {
}
break;
}

var argseq__10609__auto__ = ((((0) < args__10608__auto__.length))?(new cljs.core.IndexedSeq(args__10608__auto__.slice((0)),(0),null)):null);
return superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic(argseq__10609__auto__);
});

superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic = (function (p__21145){
var map__21146 = p__21145;
var map__21146__$1 = ((((!((map__21146 == null)))?((((map__21146.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21146.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21146):map__21146);
var stale_timeout = cljs.core.get.call(null,map__21146__$1,new cljs.core.Keyword(null,"stale-timeout","stale-timeout",-468804294),((10) * (1000)));
var error_fn = cljs.core.get.call(null,map__21146__$1,new cljs.core.Keyword(null,"error-fn","error-fn",-171437615),((function (map__21146,map__21146__$1,stale_timeout){
return (function (e){
return cljs.core.println.call(null,"Supervisor:",e,e.stack);
});})(map__21146,map__21146__$1,stale_timeout))
);
var pending_fn = cljs.core.get.call(null,map__21146__$1,new cljs.core.Keyword(null,"pending-fn","pending-fn",1734381755),((function (map__21146,map__21146__$1,stale_timeout,error_fn){
return (function (e){
return cljs.core.println.call(null,"Supervisor detected stale error:",e,e.stack);
});})(map__21146,map__21146__$1,stale_timeout,error_fn))
);
var s = cljs.core.assoc.call(null,superv.async.map__GT_TrackingSupervisor.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.async.chan.call(null),new cljs.core.Keyword(null,"abort","abort",521193198),cljs.core.async.chan.call(null),new cljs.core.Keyword(null,"registered","registered",-388600037),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)], null)),new cljs.core.Keyword(null,"global?","global?",-2022837689),true);
var err_ch = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(s);
cljs.core.async.take_BANG_.call(null,err_ch,((function (s,err_ch,map__21146,map__21146__$1,stale_timeout,error_fn,pending_fn){
return (function superv$async$loop_fn(e){
error_fn.call(null,e);

return cljs.core.async.take_BANG_.call(null,err_ch,superv$async$loop_fn);
});})(s,err_ch,map__21146,map__21146__$1,stale_timeout,error_fn,pending_fn))
);

((function (s,err_ch,map__21146,map__21146__$1,stale_timeout,error_fn,pending_fn){
return (function superv$async$pending(_){
var vec__21158 = cljs.core.filter.call(null,((function (s,err_ch,map__21146,map__21146__$1,stale_timeout,error_fn,pending_fn){
return (function (p__21164){
var vec__21165 = p__21164;
var k = cljs.core.nth.call(null,vec__21165,(0),null);
var v = cljs.core.nth.call(null,vec__21165,(1),null);
return ((superv.async.now.call(null).getTime() - stale_timeout) > v.getTime());
});})(s,err_ch,map__21146,map__21146__$1,stale_timeout,error_fn,pending_fn))
,cljs.core.deref.call(null,new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s)));
var vec__21161 = cljs.core.nth.call(null,vec__21158,(0),null);
var e = cljs.core.nth.call(null,vec__21161,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__21161,(1),null);
if(cljs.core.truth_(e)){
pending_fn.call(null,e);

superv.async._free_exception.call(null,s,e);
} else {
}

return cljs.core.async.take_BANG_.call(null,cljs.core.async.timeout.call(null,stale_timeout),superv$async$pending);
});})(s,err_ch,map__21146,map__21146__$1,stale_timeout,error_fn,pending_fn))
.call(null,null);

return s;
});

superv.async.simple_supervisor.cljs$lang$maxFixedArity = (0);

superv.async.simple_supervisor.cljs$lang$applyTo = (function (seq21144){
return superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq21144));
});

superv.async.S = superv.async.simple_supervisor.call(null);
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
superv.async.throw_if_exception = (function superv$async$throw_if_exception(S,x){
if((x instanceof Error)){
superv.async._free_exception.call(null,S,x);

throw cljs.core.ex_info.call(null,[cljs.core.str(x)].join(''),(function (){var or__9385__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__9385__auto__)){
return or__9385__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
superv.async.superv_init = (function superv$async$superv_init(){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [superv.async._error,superv.async._abort,superv.async._register_go,superv.async._unregister_go,superv.async._track_exception,superv.async._free_exception,superv.async.throw_if_exception], null);
});
goog.exportSymbol('superv.async.superv_init', superv.async.superv_init);
superv.async.superv_init.call(null);
superv.async.supervisor_QMARK_ = (function superv$async$supervisor_QMARK_(x){
if(!((x == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === x.superv$async$PSupervisor$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,superv.async.PSupervisor,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,superv.async.PSupervisor,x);
}
});
/**
 * Here until http://dev.clojure.org/jira/browse/ASYNC-74 is resolved.
 */
superv.async.channel_QMARK_ = (function superv$async$channel_QMARK_(x){
if(!((x == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$ReadPort$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.ReadPort,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.ReadPort,x);
}
});
cljs.spec.def_impl.call(null,new cljs.core.Symbol("superv.async","go-try","superv.async/go-try",218378086,null),cljs.core.list(new cljs.core.Symbol("cljs.spec","fspec","cljs.spec/fspec",982220571,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec","cat","cljs.spec/cat",850003863,null),new cljs.core.Keyword(null,"S","S",1267293308),new cljs.core.Symbol("superv.async","supervisor?","superv.async/supervisor?",-926102460,null),new cljs.core.Keyword(null,"body","body",-2049205669),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Symbol("superv.async","channel?","superv.async/channel?",-1907957519,null)),cljs.spec.fspec_impl.call(null,cljs.spec.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec","cat","cljs.spec/cat",850003863,null),new cljs.core.Keyword(null,"S","S",1267293308),new cljs.core.Symbol("superv.async","supervisor?","superv.async/supervisor?",-926102460,null),new cljs.core.Keyword(null,"body","body",-2049205669),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),cljs.spec.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"S","S",1267293308),new cljs.core.Keyword(null,"body","body",-2049205669)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [superv.async.supervisor_QMARK_,cljs.core.any_QMARK_], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("superv.async","supervisor?","superv.async/supervisor?",-926102460,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec","cat","cljs.spec/cat",850003863,null),new cljs.core.Keyword(null,"S","S",1267293308),new cljs.core.Symbol("superv.async","supervisor?","superv.async/supervisor?",-926102460,null),new cljs.core.Keyword(null,"body","body",-2049205669),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),cljs.spec.spec_impl.call(null,new cljs.core.Symbol("superv.async","channel?","superv.async/channel?",-1907957519,null),superv.async.channel_QMARK_,null,null),new cljs.core.Symbol("superv.async","channel?","superv.async/channel?",-1907957519,null),null,null,null));
/**
 * Same as core.async/take!, but tracks exceptions in supervisor. TODO
 * deal with abortion.
 */
superv.async.take_QMARK_ = (function superv$async$take_QMARK_(var_args){
var args21186 = [];
var len__10601__auto___21189 = arguments.length;
var i__10602__auto___21190 = (0);
while(true){
if((i__10602__auto___21190 < len__10601__auto___21189)){
args21186.push((arguments[i__10602__auto___21190]));

var G__21191 = (i__10602__auto___21190 + (1));
i__10602__auto___21190 = G__21191;
continue;
} else {
}
break;
}

var G__21188 = args21186.length;
switch (G__21188) {
case 3:
return superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21186.length)].join('')));

}
});

superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (S,port,fn1){
return superv.async.take_QMARK_.call(null,S,port,fn1,true);
});

superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$4 = (function (S,port,fn1,on_caller_QMARK_){
return cljs.core.async.take_BANG_.call(null,port,(function (v){
if((v instanceof Error)){
superv.async._free_exception.call(null,S,v);
} else {
}

return fn1.call(null,v);
}),on_caller_QMARK_);
});

superv.async.take_QMARK_.cljs$lang$maxFixedArity = 4;

/**
 * Same as core.async/put!, but tracks exceptions in supervisor. TODO
 * deal with abortion.
 */
superv.async.put_QMARK_ = (function superv$async$put_QMARK_(var_args){
var args21193 = [];
var len__10601__auto___21196 = arguments.length;
var i__10602__auto___21197 = (0);
while(true){
if((i__10602__auto___21197 < len__10601__auto___21196)){
args21193.push((arguments[i__10602__auto___21197]));

var G__21198 = (i__10602__auto___21197 + (1));
i__10602__auto___21197 = G__21198;
continue;
} else {
}
break;
}

var G__21195 = args21193.length;
switch (G__21195) {
case 3:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21193.length)].join('')));

}
});

superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (S,port,val){
return superv.async.put_QMARK_.call(null,S,port,val,(function superv$async$noop(_){
return null;
}));
});

superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$4 = (function (S,port,val,fn1){
return superv.async.put_QMARK_.call(null,S,port,val,fn1,true);
});

superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$5 = (function (S,port,val,fn1,on_caller_QMARK_){
return cljs.core.async.put_BANG_.call(null,port,val,(function (ret){
if(((val instanceof Error)) && (!(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data.call(null,val)),new cljs.core.Keyword(null,"aborted","aborted",1775972619))))){
superv.async._track_exception.call(null,S,val);
} else {
}

return fn1.call(null,ret);
}),on_caller_QMARK_);
});

superv.async.put_QMARK_.cljs$lang$maxFixedArity = 5;

/**
 * Same as core.async alts! but throws an exception if the channel returns a
 * throwable object or the context has been aborted.
 */
superv.async.alts_QMARK_ = (function superv$async$alts_QMARK_(var_args){
var args__10608__auto__ = [];
var len__10601__auto___21209 = arguments.length;
var i__10602__auto___21210 = (0);
while(true){
if((i__10602__auto___21210 < len__10601__auto___21209)){
args__10608__auto__.push((arguments[i__10602__auto___21210]));

var G__21211 = (i__10602__auto___21210 + (1));
i__10602__auto___21210 = G__21211;
continue;
} else {
}
break;
}

var argseq__10609__auto__ = ((((2) < args__10608__auto__.length))?(new cljs.core.IndexedSeq(args__10608__auto__.slice((2)),(0),null)):null);
return superv.async.alts_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__10609__auto__);
});

superv.async.alts_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (S,ports,opts){
var abort__18269__auto__ = superv.async._abort.call(null,S);
var to__18270__auto__ = cljs.core.async.timeout.call(null,(0));
var vec__21203 = cljs.core.async.alts_BANG_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [abort__18269__auto__,to__18270__auto__], null),new cljs.core.Keyword(null,"priority","priority",1431093715),true);
var val__18271__auto__ = cljs.core.nth.call(null,vec__21203,(0),null);
var port__18272__auto__ = cljs.core.nth.call(null,vec__21203,(1),null);
if(cljs.core._EQ_.call(null,port__18272__auto__,abort__18269__auto__)){
return cljs.core.ex_info.call(null,"Aborted operations",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"aborted","aborted",1775972619)], null));
} else {
var vec__21206 = cljs.core.apply.call(null,cljs.core.async.alts_BANG_,ports,opts);
var val = cljs.core.nth.call(null,vec__21206,(0),null);
var port = cljs.core.nth.call(null,vec__21206,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [superv.async.throw_if_exception.call(null,S,val),port], null);
}
});

superv.async.alts_QMARK_.cljs$lang$maxFixedArity = (2);

superv.async.alts_QMARK_.cljs$lang$applyTo = (function (seq21200){
var G__21201 = cljs.core.first.call(null,seq21200);
var seq21200__$1 = cljs.core.next.call(null,seq21200);
var G__21202 = cljs.core.first.call(null,seq21200__$1);
var seq21200__$2 = cljs.core.next.call(null,seq21200__$1);
return superv.async.alts_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__21201,G__21202,seq21200__$2);
});

