// Compiled by ClojureScript 1.8.34 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('goog.Uri');
goog.require('goog.net.jsloader');
goog.require('cljs.core.async');
goog.require('goog.object');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__24551__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__24551__auto__){
return or__24551__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.fix_node_request_url = (function figwheel$client$file_reloading$fix_node_request_url(url){

if(cljs.core.truth_(goog.string.startsWith(url,"../"))){
return clojure.string.replace.call(null,url,"../","");
} else {
return [cljs.core.str("goog/"),cljs.core.str(url)].join('');
}
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__24551__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, ["svgpan.SvgPan",null,"far.out",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__24551__auto__)){
return or__24551__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__32107_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__32107_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([name], true));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([parent_ns], true));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__32112 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__32113 = null;
var count__32114 = (0);
var i__32115 = (0);
while(true){
if((i__32115 < count__32114)){
var n = cljs.core._nth.call(null,chunk__32113,i__32115);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__32116 = seq__32112;
var G__32117 = chunk__32113;
var G__32118 = count__32114;
var G__32119 = (i__32115 + (1));
seq__32112 = G__32116;
chunk__32113 = G__32117;
count__32114 = G__32118;
i__32115 = G__32119;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__32112);
if(temp__4657__auto__){
var seq__32112__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32112__$1)){
var c__25362__auto__ = cljs.core.chunk_first.call(null,seq__32112__$1);
var G__32120 = cljs.core.chunk_rest.call(null,seq__32112__$1);
var G__32121 = c__25362__auto__;
var G__32122 = cljs.core.count.call(null,c__25362__auto__);
var G__32123 = (0);
seq__32112 = G__32120;
chunk__32113 = G__32121;
count__32114 = G__32122;
i__32115 = G__32123;
continue;
} else {
var n = cljs.core.first.call(null,seq__32112__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__32124 = cljs.core.next.call(null,seq__32112__$1);
var G__32125 = null;
var G__32126 = (0);
var G__32127 = (0);
seq__32112 = G__32124;
chunk__32113 = G__32125;
count__32114 = G__32126;
i__32115 = G__32127;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__32166_32173 = cljs.core.seq.call(null,deps);
var chunk__32167_32174 = null;
var count__32168_32175 = (0);
var i__32169_32176 = (0);
while(true){
if((i__32169_32176 < count__32168_32175)){
var dep_32177 = cljs.core._nth.call(null,chunk__32167_32174,i__32169_32176);
topo_sort_helper_STAR_.call(null,dep_32177,(depth + (1)),state);

var G__32178 = seq__32166_32173;
var G__32179 = chunk__32167_32174;
var G__32180 = count__32168_32175;
var G__32181 = (i__32169_32176 + (1));
seq__32166_32173 = G__32178;
chunk__32167_32174 = G__32179;
count__32168_32175 = G__32180;
i__32169_32176 = G__32181;
continue;
} else {
var temp__4657__auto___32182 = cljs.core.seq.call(null,seq__32166_32173);
if(temp__4657__auto___32182){
var seq__32166_32183__$1 = temp__4657__auto___32182;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32166_32183__$1)){
var c__25362__auto___32184 = cljs.core.chunk_first.call(null,seq__32166_32183__$1);
var G__32185 = cljs.core.chunk_rest.call(null,seq__32166_32183__$1);
var G__32186 = c__25362__auto___32184;
var G__32187 = cljs.core.count.call(null,c__25362__auto___32184);
var G__32188 = (0);
seq__32166_32173 = G__32185;
chunk__32167_32174 = G__32186;
count__32168_32175 = G__32187;
i__32169_32176 = G__32188;
continue;
} else {
var dep_32189 = cljs.core.first.call(null,seq__32166_32183__$1);
topo_sort_helper_STAR_.call(null,dep_32189,(depth + (1)),state);

var G__32190 = cljs.core.next.call(null,seq__32166_32183__$1);
var G__32191 = null;
var G__32192 = (0);
var G__32193 = (0);
seq__32166_32173 = G__32190;
chunk__32167_32174 = G__32191;
count__32168_32175 = G__32192;
i__32169_32176 = G__32193;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__32170){
var vec__32172 = p__32170;
var x = cljs.core.nth.call(null,vec__32172,(0),null);
var xs = cljs.core.nthnext.call(null,vec__32172,(1));
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__32172,x,xs,get_deps__$1){
return (function (p1__32128_SHARP_){
return clojure.set.difference.call(null,p1__32128_SHARP_,x);
});})(vec__32172,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str(goog.basePath),cljs.core.str(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str(goog.basePath),cljs.core.str(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__32206 = cljs.core.seq.call(null,provides);
var chunk__32207 = null;
var count__32208 = (0);
var i__32209 = (0);
while(true){
if((i__32209 < count__32208)){
var prov = cljs.core._nth.call(null,chunk__32207,i__32209);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__32210_32218 = cljs.core.seq.call(null,requires);
var chunk__32211_32219 = null;
var count__32212_32220 = (0);
var i__32213_32221 = (0);
while(true){
if((i__32213_32221 < count__32212_32220)){
var req_32222 = cljs.core._nth.call(null,chunk__32211_32219,i__32213_32221);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_32222,prov);

var G__32223 = seq__32210_32218;
var G__32224 = chunk__32211_32219;
var G__32225 = count__32212_32220;
var G__32226 = (i__32213_32221 + (1));
seq__32210_32218 = G__32223;
chunk__32211_32219 = G__32224;
count__32212_32220 = G__32225;
i__32213_32221 = G__32226;
continue;
} else {
var temp__4657__auto___32227 = cljs.core.seq.call(null,seq__32210_32218);
if(temp__4657__auto___32227){
var seq__32210_32228__$1 = temp__4657__auto___32227;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32210_32228__$1)){
var c__25362__auto___32229 = cljs.core.chunk_first.call(null,seq__32210_32228__$1);
var G__32230 = cljs.core.chunk_rest.call(null,seq__32210_32228__$1);
var G__32231 = c__25362__auto___32229;
var G__32232 = cljs.core.count.call(null,c__25362__auto___32229);
var G__32233 = (0);
seq__32210_32218 = G__32230;
chunk__32211_32219 = G__32231;
count__32212_32220 = G__32232;
i__32213_32221 = G__32233;
continue;
} else {
var req_32234 = cljs.core.first.call(null,seq__32210_32228__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_32234,prov);

var G__32235 = cljs.core.next.call(null,seq__32210_32228__$1);
var G__32236 = null;
var G__32237 = (0);
var G__32238 = (0);
seq__32210_32218 = G__32235;
chunk__32211_32219 = G__32236;
count__32212_32220 = G__32237;
i__32213_32221 = G__32238;
continue;
}
} else {
}
}
break;
}

var G__32239 = seq__32206;
var G__32240 = chunk__32207;
var G__32241 = count__32208;
var G__32242 = (i__32209 + (1));
seq__32206 = G__32239;
chunk__32207 = G__32240;
count__32208 = G__32241;
i__32209 = G__32242;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__32206);
if(temp__4657__auto__){
var seq__32206__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32206__$1)){
var c__25362__auto__ = cljs.core.chunk_first.call(null,seq__32206__$1);
var G__32243 = cljs.core.chunk_rest.call(null,seq__32206__$1);
var G__32244 = c__25362__auto__;
var G__32245 = cljs.core.count.call(null,c__25362__auto__);
var G__32246 = (0);
seq__32206 = G__32243;
chunk__32207 = G__32244;
count__32208 = G__32245;
i__32209 = G__32246;
continue;
} else {
var prov = cljs.core.first.call(null,seq__32206__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__32214_32247 = cljs.core.seq.call(null,requires);
var chunk__32215_32248 = null;
var count__32216_32249 = (0);
var i__32217_32250 = (0);
while(true){
if((i__32217_32250 < count__32216_32249)){
var req_32251 = cljs.core._nth.call(null,chunk__32215_32248,i__32217_32250);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_32251,prov);

var G__32252 = seq__32214_32247;
var G__32253 = chunk__32215_32248;
var G__32254 = count__32216_32249;
var G__32255 = (i__32217_32250 + (1));
seq__32214_32247 = G__32252;
chunk__32215_32248 = G__32253;
count__32216_32249 = G__32254;
i__32217_32250 = G__32255;
continue;
} else {
var temp__4657__auto___32256__$1 = cljs.core.seq.call(null,seq__32214_32247);
if(temp__4657__auto___32256__$1){
var seq__32214_32257__$1 = temp__4657__auto___32256__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32214_32257__$1)){
var c__25362__auto___32258 = cljs.core.chunk_first.call(null,seq__32214_32257__$1);
var G__32259 = cljs.core.chunk_rest.call(null,seq__32214_32257__$1);
var G__32260 = c__25362__auto___32258;
var G__32261 = cljs.core.count.call(null,c__25362__auto___32258);
var G__32262 = (0);
seq__32214_32247 = G__32259;
chunk__32215_32248 = G__32260;
count__32216_32249 = G__32261;
i__32217_32250 = G__32262;
continue;
} else {
var req_32263 = cljs.core.first.call(null,seq__32214_32257__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_32263,prov);

var G__32264 = cljs.core.next.call(null,seq__32214_32257__$1);
var G__32265 = null;
var G__32266 = (0);
var G__32267 = (0);
seq__32214_32247 = G__32264;
chunk__32215_32248 = G__32265;
count__32216_32249 = G__32266;
i__32217_32250 = G__32267;
continue;
}
} else {
}
}
break;
}

var G__32268 = cljs.core.next.call(null,seq__32206__$1);
var G__32269 = null;
var G__32270 = (0);
var G__32271 = (0);
seq__32206 = G__32268;
chunk__32207 = G__32269;
count__32208 = G__32270;
i__32209 = G__32271;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel$client$file_reloading$figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__32276_32280 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__32277_32281 = null;
var count__32278_32282 = (0);
var i__32279_32283 = (0);
while(true){
if((i__32279_32283 < count__32278_32282)){
var ns_32284 = cljs.core._nth.call(null,chunk__32277_32281,i__32279_32283);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_32284);

var G__32285 = seq__32276_32280;
var G__32286 = chunk__32277_32281;
var G__32287 = count__32278_32282;
var G__32288 = (i__32279_32283 + (1));
seq__32276_32280 = G__32285;
chunk__32277_32281 = G__32286;
count__32278_32282 = G__32287;
i__32279_32283 = G__32288;
continue;
} else {
var temp__4657__auto___32289 = cljs.core.seq.call(null,seq__32276_32280);
if(temp__4657__auto___32289){
var seq__32276_32290__$1 = temp__4657__auto___32289;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32276_32290__$1)){
var c__25362__auto___32291 = cljs.core.chunk_first.call(null,seq__32276_32290__$1);
var G__32292 = cljs.core.chunk_rest.call(null,seq__32276_32290__$1);
var G__32293 = c__25362__auto___32291;
var G__32294 = cljs.core.count.call(null,c__25362__auto___32291);
var G__32295 = (0);
seq__32276_32280 = G__32292;
chunk__32277_32281 = G__32293;
count__32278_32282 = G__32294;
i__32279_32283 = G__32295;
continue;
} else {
var ns_32296 = cljs.core.first.call(null,seq__32276_32290__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_32296);

var G__32297 = cljs.core.next.call(null,seq__32276_32290__$1);
var G__32298 = null;
var G__32299 = (0);
var G__32300 = (0);
seq__32276_32280 = G__32297;
chunk__32277_32281 = G__32298;
count__32278_32282 = G__32299;
i__32279_32283 = G__32300;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__24551__auto__ = goog.require__;
if(cljs.core.truth_(or__24551__auto__)){
return or__24551__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__32301__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__32301 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__32302__i = 0, G__32302__a = new Array(arguments.length -  0);
while (G__32302__i < G__32302__a.length) {G__32302__a[G__32302__i] = arguments[G__32302__i + 0]; ++G__32302__i;}
  args = new cljs.core.IndexedSeq(G__32302__a,0);
} 
return G__32301__delegate.call(this,args);};
G__32301.cljs$lang$maxFixedArity = 0;
G__32301.cljs$lang$applyTo = (function (arglist__32303){
var args = cljs.core.seq(arglist__32303);
return G__32301__delegate(args);
});
G__32301.cljs$core$IFn$_invoke$arity$variadic = G__32301__delegate;
return G__32301;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
;
}
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__32305 = cljs.core._EQ_;
var expr__32306 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__32305.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__32306))){
var path_parts = ((function (pred__32305,expr__32306){
return (function (p1__32304_SHARP_){
return clojure.string.split.call(null,p1__32304_SHARP_,/[\/\\]/);
});})(pred__32305,expr__32306))
;
var sep = (cljs.core.truth_(cljs.core.re_matches.call(null,/win.*/,process.platform))?"\\":"/");
var root = clojure.string.join.call(null,sep,cljs.core.pop.call(null,cljs.core.pop.call(null,path_parts.call(null,__dirname))));
return ((function (path_parts,sep,root,pred__32305,expr__32306){
return (function (request_url,callback){

var cache_path = clojure.string.join.call(null,sep,cljs.core.cons.call(null,root,path_parts.call(null,figwheel.client.file_reloading.fix_node_request_url.call(null,request_url))));
(require.cache[cache_path] = null);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e32308){if((e32308 instanceof Error)){
var e = e32308;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e32308;

}
}})());
});
;})(path_parts,sep,root,pred__32305,expr__32306))
} else {
if(cljs.core.truth_(pred__32305.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__32306))){
return ((function (pred__32305,expr__32306){
return (function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),{"cleanupWhenDone": true});
deferred.addCallback(((function (deferred,pred__32305,expr__32306){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred,pred__32305,expr__32306))
);

return deferred.addErrback(((function (deferred,pred__32305,expr__32306){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred,pred__32305,expr__32306))
);
});
;})(pred__32305,expr__32306))
} else {
return ((function (pred__32305,expr__32306){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__32305,expr__32306))
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__32309,callback){
var map__32312 = p__32309;
var map__32312__$1 = ((((!((map__32312 == null)))?((((map__32312.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32312.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32312):map__32312);
var file_msg = map__32312__$1;
var request_url = cljs.core.get.call(null,map__32312__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Attempting to load "),cljs.core.str(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__32312,map__32312__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Successfully loaded "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__32312,map__32312__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__26717__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26717__auto__){
return (function (){
var f__26718__auto__ = (function (){var switch__26605__auto__ = ((function (c__26717__auto__){
return (function (state_32336){
var state_val_32337 = (state_32336[(1)]);
if((state_val_32337 === (7))){
var inst_32332 = (state_32336[(2)]);
var state_32336__$1 = state_32336;
var statearr_32338_32358 = state_32336__$1;
(statearr_32338_32358[(2)] = inst_32332);

(statearr_32338_32358[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (1))){
var state_32336__$1 = state_32336;
var statearr_32339_32359 = state_32336__$1;
(statearr_32339_32359[(2)] = null);

(statearr_32339_32359[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (4))){
var inst_32316 = (state_32336[(7)]);
var inst_32316__$1 = (state_32336[(2)]);
var state_32336__$1 = (function (){var statearr_32340 = state_32336;
(statearr_32340[(7)] = inst_32316__$1);

return statearr_32340;
})();
if(cljs.core.truth_(inst_32316__$1)){
var statearr_32341_32360 = state_32336__$1;
(statearr_32341_32360[(1)] = (5));

} else {
var statearr_32342_32361 = state_32336__$1;
(statearr_32342_32361[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (6))){
var state_32336__$1 = state_32336;
var statearr_32343_32362 = state_32336__$1;
(statearr_32343_32362[(2)] = null);

(statearr_32343_32362[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (3))){
var inst_32334 = (state_32336[(2)]);
var state_32336__$1 = state_32336;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32336__$1,inst_32334);
} else {
if((state_val_32337 === (2))){
var state_32336__$1 = state_32336;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32336__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_32337 === (11))){
var inst_32328 = (state_32336[(2)]);
var state_32336__$1 = (function (){var statearr_32344 = state_32336;
(statearr_32344[(8)] = inst_32328);

return statearr_32344;
})();
var statearr_32345_32363 = state_32336__$1;
(statearr_32345_32363[(2)] = null);

(statearr_32345_32363[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (9))){
var inst_32320 = (state_32336[(9)]);
var inst_32322 = (state_32336[(10)]);
var inst_32324 = inst_32322.call(null,inst_32320);
var state_32336__$1 = state_32336;
var statearr_32346_32364 = state_32336__$1;
(statearr_32346_32364[(2)] = inst_32324);

(statearr_32346_32364[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (5))){
var inst_32316 = (state_32336[(7)]);
var inst_32318 = figwheel.client.file_reloading.blocking_load.call(null,inst_32316);
var state_32336__$1 = state_32336;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32336__$1,(8),inst_32318);
} else {
if((state_val_32337 === (10))){
var inst_32320 = (state_32336[(9)]);
var inst_32326 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_32320);
var state_32336__$1 = state_32336;
var statearr_32347_32365 = state_32336__$1;
(statearr_32347_32365[(2)] = inst_32326);

(statearr_32347_32365[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (8))){
var inst_32316 = (state_32336[(7)]);
var inst_32322 = (state_32336[(10)]);
var inst_32320 = (state_32336[(2)]);
var inst_32321 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_32322__$1 = cljs.core.get.call(null,inst_32321,inst_32316);
var state_32336__$1 = (function (){var statearr_32348 = state_32336;
(statearr_32348[(9)] = inst_32320);

(statearr_32348[(10)] = inst_32322__$1);

return statearr_32348;
})();
if(cljs.core.truth_(inst_32322__$1)){
var statearr_32349_32366 = state_32336__$1;
(statearr_32349_32366[(1)] = (9));

} else {
var statearr_32350_32367 = state_32336__$1;
(statearr_32350_32367[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__26717__auto__))
;
return ((function (switch__26605__auto__,c__26717__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__26606__auto__ = null;
var figwheel$client$file_reloading$state_machine__26606__auto____0 = (function (){
var statearr_32354 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32354[(0)] = figwheel$client$file_reloading$state_machine__26606__auto__);

(statearr_32354[(1)] = (1));

return statearr_32354;
});
var figwheel$client$file_reloading$state_machine__26606__auto____1 = (function (state_32336){
while(true){
var ret_value__26607__auto__ = (function (){try{while(true){
var result__26608__auto__ = switch__26605__auto__.call(null,state_32336);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26608__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26608__auto__;
}
break;
}
}catch (e32355){if((e32355 instanceof Object)){
var ex__26609__auto__ = e32355;
var statearr_32356_32368 = state_32336;
(statearr_32356_32368[(5)] = ex__26609__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32336);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32355;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26607__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32369 = state_32336;
state_32336 = G__32369;
continue;
} else {
return ret_value__26607__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__26606__auto__ = function(state_32336){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__26606__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__26606__auto____1.call(this,state_32336);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__26606__auto____0;
figwheel$client$file_reloading$state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__26606__auto____1;
return figwheel$client$file_reloading$state_machine__26606__auto__;
})()
;})(switch__26605__auto__,c__26717__auto__))
})();
var state__26719__auto__ = (function (){var statearr_32357 = f__26718__auto__.call(null);
(statearr_32357[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26717__auto__);

return statearr_32357;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26719__auto__);
});})(c__26717__auto__))
);

return c__26717__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__32370,callback){
var map__32373 = p__32370;
var map__32373__$1 = ((((!((map__32373 == null)))?((((map__32373.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32373.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32373):map__32373);
var file_msg = map__32373__$1;
var namespace = cljs.core.get.call(null,map__32373__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__32373,map__32373__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__32373,map__32373__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__32375){
var map__32378 = p__32375;
var map__32378__$1 = ((((!((map__32378 == null)))?((((map__32378.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32378.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32378):map__32378);
var file_msg = map__32378__$1;
var namespace = cljs.core.get.call(null,map__32378__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__24539__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas));
if(and__24539__auto__){
var or__24551__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__24551__auto__)){
return or__24551__auto__;
} else {
var or__24551__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__24551__auto____$1)){
return or__24551__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__24539__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__32380,callback){
var map__32383 = p__32380;
var map__32383__$1 = ((((!((map__32383 == null)))?((((map__32383.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32383.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32383):map__32383);
var file_msg = map__32383__$1;
var request_url = cljs.core.get.call(null,map__32383__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__32383__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Figwheel: Not trying to load file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__26717__auto___32471 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26717__auto___32471,out){
return (function (){
var f__26718__auto__ = (function (){var switch__26605__auto__ = ((function (c__26717__auto___32471,out){
return (function (state_32453){
var state_val_32454 = (state_32453[(1)]);
if((state_val_32454 === (1))){
var inst_32431 = cljs.core.nth.call(null,files,(0),null);
var inst_32432 = cljs.core.nthnext.call(null,files,(1));
var inst_32433 = files;
var state_32453__$1 = (function (){var statearr_32455 = state_32453;
(statearr_32455[(7)] = inst_32433);

(statearr_32455[(8)] = inst_32432);

(statearr_32455[(9)] = inst_32431);

return statearr_32455;
})();
var statearr_32456_32472 = state_32453__$1;
(statearr_32456_32472[(2)] = null);

(statearr_32456_32472[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32454 === (2))){
var inst_32436 = (state_32453[(10)]);
var inst_32433 = (state_32453[(7)]);
var inst_32436__$1 = cljs.core.nth.call(null,inst_32433,(0),null);
var inst_32437 = cljs.core.nthnext.call(null,inst_32433,(1));
var inst_32438 = (inst_32436__$1 == null);
var inst_32439 = cljs.core.not.call(null,inst_32438);
var state_32453__$1 = (function (){var statearr_32457 = state_32453;
(statearr_32457[(10)] = inst_32436__$1);

(statearr_32457[(11)] = inst_32437);

return statearr_32457;
})();
if(inst_32439){
var statearr_32458_32473 = state_32453__$1;
(statearr_32458_32473[(1)] = (4));

} else {
var statearr_32459_32474 = state_32453__$1;
(statearr_32459_32474[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32454 === (3))){
var inst_32451 = (state_32453[(2)]);
var state_32453__$1 = state_32453;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32453__$1,inst_32451);
} else {
if((state_val_32454 === (4))){
var inst_32436 = (state_32453[(10)]);
var inst_32441 = figwheel.client.file_reloading.reload_js_file.call(null,inst_32436);
var state_32453__$1 = state_32453;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32453__$1,(7),inst_32441);
} else {
if((state_val_32454 === (5))){
var inst_32447 = cljs.core.async.close_BANG_.call(null,out);
var state_32453__$1 = state_32453;
var statearr_32460_32475 = state_32453__$1;
(statearr_32460_32475[(2)] = inst_32447);

(statearr_32460_32475[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32454 === (6))){
var inst_32449 = (state_32453[(2)]);
var state_32453__$1 = state_32453;
var statearr_32461_32476 = state_32453__$1;
(statearr_32461_32476[(2)] = inst_32449);

(statearr_32461_32476[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32454 === (7))){
var inst_32437 = (state_32453[(11)]);
var inst_32443 = (state_32453[(2)]);
var inst_32444 = cljs.core.async.put_BANG_.call(null,out,inst_32443);
var inst_32433 = inst_32437;
var state_32453__$1 = (function (){var statearr_32462 = state_32453;
(statearr_32462[(7)] = inst_32433);

(statearr_32462[(12)] = inst_32444);

return statearr_32462;
})();
var statearr_32463_32477 = state_32453__$1;
(statearr_32463_32477[(2)] = null);

(statearr_32463_32477[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__26717__auto___32471,out))
;
return ((function (switch__26605__auto__,c__26717__auto___32471,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__26606__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__26606__auto____0 = (function (){
var statearr_32467 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32467[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__26606__auto__);

(statearr_32467[(1)] = (1));

return statearr_32467;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__26606__auto____1 = (function (state_32453){
while(true){
var ret_value__26607__auto__ = (function (){try{while(true){
var result__26608__auto__ = switch__26605__auto__.call(null,state_32453);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26608__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26608__auto__;
}
break;
}
}catch (e32468){if((e32468 instanceof Object)){
var ex__26609__auto__ = e32468;
var statearr_32469_32478 = state_32453;
(statearr_32469_32478[(5)] = ex__26609__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32453);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32468;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26607__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32479 = state_32453;
state_32453 = G__32479;
continue;
} else {
return ret_value__26607__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__26606__auto__ = function(state_32453){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__26606__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__26606__auto____1.call(this,state_32453);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__26606__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__26606__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__26606__auto__;
})()
;})(switch__26605__auto__,c__26717__auto___32471,out))
})();
var state__26719__auto__ = (function (){var statearr_32470 = f__26718__auto__.call(null);
(statearr_32470[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26717__auto___32471);

return statearr_32470;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26719__auto__);
});})(c__26717__auto___32471,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__32480,opts){
var map__32484 = p__32480;
var map__32484__$1 = ((((!((map__32484 == null)))?((((map__32484.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32484.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32484):map__32484);
var eval_body__$1 = cljs.core.get.call(null,map__32484__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__32484__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__24539__auto__ = eval_body__$1;
if(cljs.core.truth_(and__24539__auto__)){
return typeof eval_body__$1 === 'string';
} else {
return and__24539__auto__;
}
})())){
var code = eval_body__$1;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Evaling file "),cljs.core.str(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e32486){var e = e32486;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Unable to evaluate "),cljs.core.str(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["figwheel.connect",null], null), null),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__4655__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__32487_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__32487_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__4655__auto__)){
var file_msg = temp__4655__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__32492){
var vec__32493 = p__32492;
var k = cljs.core.nth.call(null,vec__32493,(0),null);
var v = cljs.core.nth.call(null,vec__32493,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__32494){
var vec__32495 = p__32494;
var k = cljs.core.nth.call(null,vec__32495,(0),null);
var v = cljs.core.nth.call(null,vec__32495,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__32499,p__32500){
var map__32747 = p__32499;
var map__32747__$1 = ((((!((map__32747 == null)))?((((map__32747.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32747.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32747):map__32747);
var opts = map__32747__$1;
var before_jsload = cljs.core.get.call(null,map__32747__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__32747__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__32747__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__32748 = p__32500;
var map__32748__$1 = ((((!((map__32748 == null)))?((((map__32748.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32748.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32748):map__32748);
var msg = map__32748__$1;
var files = cljs.core.get.call(null,map__32748__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__32748__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__32748__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__26717__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26717__auto__,map__32747,map__32747__$1,opts,before_jsload,on_jsload,reload_dependents,map__32748,map__32748__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__26718__auto__ = (function (){var switch__26605__auto__ = ((function (c__26717__auto__,map__32747,map__32747__$1,opts,before_jsload,on_jsload,reload_dependents,map__32748,map__32748__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_32901){
var state_val_32902 = (state_32901[(1)]);
if((state_val_32902 === (7))){
var inst_32763 = (state_32901[(7)]);
var inst_32764 = (state_32901[(8)]);
var inst_32762 = (state_32901[(9)]);
var inst_32765 = (state_32901[(10)]);
var inst_32770 = cljs.core._nth.call(null,inst_32763,inst_32765);
var inst_32771 = figwheel.client.file_reloading.eval_body.call(null,inst_32770,opts);
var inst_32772 = (inst_32765 + (1));
var tmp32903 = inst_32763;
var tmp32904 = inst_32764;
var tmp32905 = inst_32762;
var inst_32762__$1 = tmp32905;
var inst_32763__$1 = tmp32903;
var inst_32764__$1 = tmp32904;
var inst_32765__$1 = inst_32772;
var state_32901__$1 = (function (){var statearr_32906 = state_32901;
(statearr_32906[(11)] = inst_32771);

(statearr_32906[(7)] = inst_32763__$1);

(statearr_32906[(8)] = inst_32764__$1);

(statearr_32906[(9)] = inst_32762__$1);

(statearr_32906[(10)] = inst_32765__$1);

return statearr_32906;
})();
var statearr_32907_32993 = state_32901__$1;
(statearr_32907_32993[(2)] = null);

(statearr_32907_32993[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (20))){
var inst_32805 = (state_32901[(12)]);
var inst_32813 = figwheel.client.file_reloading.sort_files.call(null,inst_32805);
var state_32901__$1 = state_32901;
var statearr_32908_32994 = state_32901__$1;
(statearr_32908_32994[(2)] = inst_32813);

(statearr_32908_32994[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (27))){
var state_32901__$1 = state_32901;
var statearr_32909_32995 = state_32901__$1;
(statearr_32909_32995[(2)] = null);

(statearr_32909_32995[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (1))){
var inst_32754 = (state_32901[(13)]);
var inst_32751 = before_jsload.call(null,files);
var inst_32752 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_32753 = (function (){return ((function (inst_32754,inst_32751,inst_32752,state_val_32902,c__26717__auto__,map__32747,map__32747__$1,opts,before_jsload,on_jsload,reload_dependents,map__32748,map__32748__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__32496_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__32496_SHARP_);
});
;})(inst_32754,inst_32751,inst_32752,state_val_32902,c__26717__auto__,map__32747,map__32747__$1,opts,before_jsload,on_jsload,reload_dependents,map__32748,map__32748__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_32754__$1 = cljs.core.filter.call(null,inst_32753,files);
var inst_32755 = cljs.core.not_empty.call(null,inst_32754__$1);
var state_32901__$1 = (function (){var statearr_32910 = state_32901;
(statearr_32910[(13)] = inst_32754__$1);

(statearr_32910[(14)] = inst_32751);

(statearr_32910[(15)] = inst_32752);

return statearr_32910;
})();
if(cljs.core.truth_(inst_32755)){
var statearr_32911_32996 = state_32901__$1;
(statearr_32911_32996[(1)] = (2));

} else {
var statearr_32912_32997 = state_32901__$1;
(statearr_32912_32997[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (24))){
var state_32901__$1 = state_32901;
var statearr_32913_32998 = state_32901__$1;
(statearr_32913_32998[(2)] = null);

(statearr_32913_32998[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (39))){
var inst_32855 = (state_32901[(16)]);
var state_32901__$1 = state_32901;
var statearr_32914_32999 = state_32901__$1;
(statearr_32914_32999[(2)] = inst_32855);

(statearr_32914_32999[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (46))){
var inst_32896 = (state_32901[(2)]);
var state_32901__$1 = state_32901;
var statearr_32915_33000 = state_32901__$1;
(statearr_32915_33000[(2)] = inst_32896);

(statearr_32915_33000[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (4))){
var inst_32799 = (state_32901[(2)]);
var inst_32800 = cljs.core.List.EMPTY;
var inst_32801 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_32800);
var inst_32802 = (function (){return ((function (inst_32799,inst_32800,inst_32801,state_val_32902,c__26717__auto__,map__32747,map__32747__$1,opts,before_jsload,on_jsload,reload_dependents,map__32748,map__32748__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__32497_SHARP_){
var and__24539__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__32497_SHARP_);
if(cljs.core.truth_(and__24539__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__32497_SHARP_));
} else {
return and__24539__auto__;
}
});
;})(inst_32799,inst_32800,inst_32801,state_val_32902,c__26717__auto__,map__32747,map__32747__$1,opts,before_jsload,on_jsload,reload_dependents,map__32748,map__32748__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_32803 = cljs.core.filter.call(null,inst_32802,files);
var inst_32804 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_32805 = cljs.core.concat.call(null,inst_32803,inst_32804);
var state_32901__$1 = (function (){var statearr_32916 = state_32901;
(statearr_32916[(17)] = inst_32799);

(statearr_32916[(18)] = inst_32801);

(statearr_32916[(12)] = inst_32805);

return statearr_32916;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_32917_33001 = state_32901__$1;
(statearr_32917_33001[(1)] = (16));

} else {
var statearr_32918_33002 = state_32901__$1;
(statearr_32918_33002[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (15))){
var inst_32789 = (state_32901[(2)]);
var state_32901__$1 = state_32901;
var statearr_32919_33003 = state_32901__$1;
(statearr_32919_33003[(2)] = inst_32789);

(statearr_32919_33003[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (21))){
var inst_32815 = (state_32901[(19)]);
var inst_32815__$1 = (state_32901[(2)]);
var inst_32816 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_32815__$1);
var state_32901__$1 = (function (){var statearr_32920 = state_32901;
(statearr_32920[(19)] = inst_32815__$1);

return statearr_32920;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32901__$1,(22),inst_32816);
} else {
if((state_val_32902 === (31))){
var inst_32899 = (state_32901[(2)]);
var state_32901__$1 = state_32901;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32901__$1,inst_32899);
} else {
if((state_val_32902 === (32))){
var inst_32855 = (state_32901[(16)]);
var inst_32860 = inst_32855.cljs$lang$protocol_mask$partition0$;
var inst_32861 = (inst_32860 & (64));
var inst_32862 = inst_32855.cljs$core$ISeq$;
var inst_32863 = (inst_32861) || (inst_32862);
var state_32901__$1 = state_32901;
if(cljs.core.truth_(inst_32863)){
var statearr_32921_33004 = state_32901__$1;
(statearr_32921_33004[(1)] = (35));

} else {
var statearr_32922_33005 = state_32901__$1;
(statearr_32922_33005[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (40))){
var inst_32876 = (state_32901[(20)]);
var inst_32875 = (state_32901[(2)]);
var inst_32876__$1 = cljs.core.get.call(null,inst_32875,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_32877 = cljs.core.get.call(null,inst_32875,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_32878 = cljs.core.not_empty.call(null,inst_32876__$1);
var state_32901__$1 = (function (){var statearr_32923 = state_32901;
(statearr_32923[(21)] = inst_32877);

(statearr_32923[(20)] = inst_32876__$1);

return statearr_32923;
})();
if(cljs.core.truth_(inst_32878)){
var statearr_32924_33006 = state_32901__$1;
(statearr_32924_33006[(1)] = (41));

} else {
var statearr_32925_33007 = state_32901__$1;
(statearr_32925_33007[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (33))){
var state_32901__$1 = state_32901;
var statearr_32926_33008 = state_32901__$1;
(statearr_32926_33008[(2)] = false);

(statearr_32926_33008[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (13))){
var inst_32775 = (state_32901[(22)]);
var inst_32779 = cljs.core.chunk_first.call(null,inst_32775);
var inst_32780 = cljs.core.chunk_rest.call(null,inst_32775);
var inst_32781 = cljs.core.count.call(null,inst_32779);
var inst_32762 = inst_32780;
var inst_32763 = inst_32779;
var inst_32764 = inst_32781;
var inst_32765 = (0);
var state_32901__$1 = (function (){var statearr_32927 = state_32901;
(statearr_32927[(7)] = inst_32763);

(statearr_32927[(8)] = inst_32764);

(statearr_32927[(9)] = inst_32762);

(statearr_32927[(10)] = inst_32765);

return statearr_32927;
})();
var statearr_32928_33009 = state_32901__$1;
(statearr_32928_33009[(2)] = null);

(statearr_32928_33009[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (22))){
var inst_32818 = (state_32901[(23)]);
var inst_32815 = (state_32901[(19)]);
var inst_32823 = (state_32901[(24)]);
var inst_32819 = (state_32901[(25)]);
var inst_32818__$1 = (state_32901[(2)]);
var inst_32819__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_32818__$1);
var inst_32820 = (function (){var all_files = inst_32815;
var res_SINGLEQUOTE_ = inst_32818__$1;
var res = inst_32819__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_32818,inst_32815,inst_32823,inst_32819,inst_32818__$1,inst_32819__$1,state_val_32902,c__26717__auto__,map__32747,map__32747__$1,opts,before_jsload,on_jsload,reload_dependents,map__32748,map__32748__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__32498_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__32498_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_32818,inst_32815,inst_32823,inst_32819,inst_32818__$1,inst_32819__$1,state_val_32902,c__26717__auto__,map__32747,map__32747__$1,opts,before_jsload,on_jsload,reload_dependents,map__32748,map__32748__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_32821 = cljs.core.filter.call(null,inst_32820,inst_32818__$1);
var inst_32822 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_32823__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_32822);
var inst_32824 = cljs.core.not_empty.call(null,inst_32823__$1);
var state_32901__$1 = (function (){var statearr_32929 = state_32901;
(statearr_32929[(26)] = inst_32821);

(statearr_32929[(23)] = inst_32818__$1);

(statearr_32929[(24)] = inst_32823__$1);

(statearr_32929[(25)] = inst_32819__$1);

return statearr_32929;
})();
if(cljs.core.truth_(inst_32824)){
var statearr_32930_33010 = state_32901__$1;
(statearr_32930_33010[(1)] = (23));

} else {
var statearr_32931_33011 = state_32901__$1;
(statearr_32931_33011[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (36))){
var state_32901__$1 = state_32901;
var statearr_32932_33012 = state_32901__$1;
(statearr_32932_33012[(2)] = false);

(statearr_32932_33012[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (41))){
var inst_32876 = (state_32901[(20)]);
var inst_32880 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_32881 = cljs.core.map.call(null,inst_32880,inst_32876);
var inst_32882 = cljs.core.pr_str.call(null,inst_32881);
var inst_32883 = [cljs.core.str("figwheel-no-load meta-data: "),cljs.core.str(inst_32882)].join('');
var inst_32884 = figwheel.client.utils.log.call(null,inst_32883);
var state_32901__$1 = state_32901;
var statearr_32933_33013 = state_32901__$1;
(statearr_32933_33013[(2)] = inst_32884);

(statearr_32933_33013[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (43))){
var inst_32877 = (state_32901[(21)]);
var inst_32887 = (state_32901[(2)]);
var inst_32888 = cljs.core.not_empty.call(null,inst_32877);
var state_32901__$1 = (function (){var statearr_32934 = state_32901;
(statearr_32934[(27)] = inst_32887);

return statearr_32934;
})();
if(cljs.core.truth_(inst_32888)){
var statearr_32935_33014 = state_32901__$1;
(statearr_32935_33014[(1)] = (44));

} else {
var statearr_32936_33015 = state_32901__$1;
(statearr_32936_33015[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (29))){
var inst_32821 = (state_32901[(26)]);
var inst_32818 = (state_32901[(23)]);
var inst_32815 = (state_32901[(19)]);
var inst_32823 = (state_32901[(24)]);
var inst_32819 = (state_32901[(25)]);
var inst_32855 = (state_32901[(16)]);
var inst_32851 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_32854 = (function (){var all_files = inst_32815;
var res_SINGLEQUOTE_ = inst_32818;
var res = inst_32819;
var files_not_loaded = inst_32821;
var dependencies_that_loaded = inst_32823;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_32821,inst_32818,inst_32815,inst_32823,inst_32819,inst_32855,inst_32851,state_val_32902,c__26717__auto__,map__32747,map__32747__$1,opts,before_jsload,on_jsload,reload_dependents,map__32748,map__32748__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__32853){
var map__32937 = p__32853;
var map__32937__$1 = ((((!((map__32937 == null)))?((((map__32937.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32937.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32937):map__32937);
var namespace = cljs.core.get.call(null,map__32937__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_32821,inst_32818,inst_32815,inst_32823,inst_32819,inst_32855,inst_32851,state_val_32902,c__26717__auto__,map__32747,map__32747__$1,opts,before_jsload,on_jsload,reload_dependents,map__32748,map__32748__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_32855__$1 = cljs.core.group_by.call(null,inst_32854,inst_32821);
var inst_32857 = (inst_32855__$1 == null);
var inst_32858 = cljs.core.not.call(null,inst_32857);
var state_32901__$1 = (function (){var statearr_32939 = state_32901;
(statearr_32939[(28)] = inst_32851);

(statearr_32939[(16)] = inst_32855__$1);

return statearr_32939;
})();
if(inst_32858){
var statearr_32940_33016 = state_32901__$1;
(statearr_32940_33016[(1)] = (32));

} else {
var statearr_32941_33017 = state_32901__$1;
(statearr_32941_33017[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (44))){
var inst_32877 = (state_32901[(21)]);
var inst_32890 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_32877);
var inst_32891 = cljs.core.pr_str.call(null,inst_32890);
var inst_32892 = [cljs.core.str("not required: "),cljs.core.str(inst_32891)].join('');
var inst_32893 = figwheel.client.utils.log.call(null,inst_32892);
var state_32901__$1 = state_32901;
var statearr_32942_33018 = state_32901__$1;
(statearr_32942_33018[(2)] = inst_32893);

(statearr_32942_33018[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (6))){
var inst_32796 = (state_32901[(2)]);
var state_32901__$1 = state_32901;
var statearr_32943_33019 = state_32901__$1;
(statearr_32943_33019[(2)] = inst_32796);

(statearr_32943_33019[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (28))){
var inst_32821 = (state_32901[(26)]);
var inst_32848 = (state_32901[(2)]);
var inst_32849 = cljs.core.not_empty.call(null,inst_32821);
var state_32901__$1 = (function (){var statearr_32944 = state_32901;
(statearr_32944[(29)] = inst_32848);

return statearr_32944;
})();
if(cljs.core.truth_(inst_32849)){
var statearr_32945_33020 = state_32901__$1;
(statearr_32945_33020[(1)] = (29));

} else {
var statearr_32946_33021 = state_32901__$1;
(statearr_32946_33021[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (25))){
var inst_32819 = (state_32901[(25)]);
var inst_32835 = (state_32901[(2)]);
var inst_32836 = cljs.core.not_empty.call(null,inst_32819);
var state_32901__$1 = (function (){var statearr_32947 = state_32901;
(statearr_32947[(30)] = inst_32835);

return statearr_32947;
})();
if(cljs.core.truth_(inst_32836)){
var statearr_32948_33022 = state_32901__$1;
(statearr_32948_33022[(1)] = (26));

} else {
var statearr_32949_33023 = state_32901__$1;
(statearr_32949_33023[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (34))){
var inst_32870 = (state_32901[(2)]);
var state_32901__$1 = state_32901;
if(cljs.core.truth_(inst_32870)){
var statearr_32950_33024 = state_32901__$1;
(statearr_32950_33024[(1)] = (38));

} else {
var statearr_32951_33025 = state_32901__$1;
(statearr_32951_33025[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (17))){
var state_32901__$1 = state_32901;
var statearr_32952_33026 = state_32901__$1;
(statearr_32952_33026[(2)] = recompile_dependents);

(statearr_32952_33026[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (3))){
var state_32901__$1 = state_32901;
var statearr_32953_33027 = state_32901__$1;
(statearr_32953_33027[(2)] = null);

(statearr_32953_33027[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (12))){
var inst_32792 = (state_32901[(2)]);
var state_32901__$1 = state_32901;
var statearr_32954_33028 = state_32901__$1;
(statearr_32954_33028[(2)] = inst_32792);

(statearr_32954_33028[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (2))){
var inst_32754 = (state_32901[(13)]);
var inst_32761 = cljs.core.seq.call(null,inst_32754);
var inst_32762 = inst_32761;
var inst_32763 = null;
var inst_32764 = (0);
var inst_32765 = (0);
var state_32901__$1 = (function (){var statearr_32955 = state_32901;
(statearr_32955[(7)] = inst_32763);

(statearr_32955[(8)] = inst_32764);

(statearr_32955[(9)] = inst_32762);

(statearr_32955[(10)] = inst_32765);

return statearr_32955;
})();
var statearr_32956_33029 = state_32901__$1;
(statearr_32956_33029[(2)] = null);

(statearr_32956_33029[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (23))){
var inst_32821 = (state_32901[(26)]);
var inst_32818 = (state_32901[(23)]);
var inst_32815 = (state_32901[(19)]);
var inst_32823 = (state_32901[(24)]);
var inst_32819 = (state_32901[(25)]);
var inst_32826 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_32828 = (function (){var all_files = inst_32815;
var res_SINGLEQUOTE_ = inst_32818;
var res = inst_32819;
var files_not_loaded = inst_32821;
var dependencies_that_loaded = inst_32823;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_32821,inst_32818,inst_32815,inst_32823,inst_32819,inst_32826,state_val_32902,c__26717__auto__,map__32747,map__32747__$1,opts,before_jsload,on_jsload,reload_dependents,map__32748,map__32748__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__32827){
var map__32957 = p__32827;
var map__32957__$1 = ((((!((map__32957 == null)))?((((map__32957.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32957.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32957):map__32957);
var request_url = cljs.core.get.call(null,map__32957__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_32821,inst_32818,inst_32815,inst_32823,inst_32819,inst_32826,state_val_32902,c__26717__auto__,map__32747,map__32747__$1,opts,before_jsload,on_jsload,reload_dependents,map__32748,map__32748__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_32829 = cljs.core.reverse.call(null,inst_32823);
var inst_32830 = cljs.core.map.call(null,inst_32828,inst_32829);
var inst_32831 = cljs.core.pr_str.call(null,inst_32830);
var inst_32832 = figwheel.client.utils.log.call(null,inst_32831);
var state_32901__$1 = (function (){var statearr_32959 = state_32901;
(statearr_32959[(31)] = inst_32826);

return statearr_32959;
})();
var statearr_32960_33030 = state_32901__$1;
(statearr_32960_33030[(2)] = inst_32832);

(statearr_32960_33030[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (35))){
var state_32901__$1 = state_32901;
var statearr_32961_33031 = state_32901__$1;
(statearr_32961_33031[(2)] = true);

(statearr_32961_33031[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (19))){
var inst_32805 = (state_32901[(12)]);
var inst_32811 = figwheel.client.file_reloading.expand_files.call(null,inst_32805);
var state_32901__$1 = state_32901;
var statearr_32962_33032 = state_32901__$1;
(statearr_32962_33032[(2)] = inst_32811);

(statearr_32962_33032[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (11))){
var state_32901__$1 = state_32901;
var statearr_32963_33033 = state_32901__$1;
(statearr_32963_33033[(2)] = null);

(statearr_32963_33033[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (9))){
var inst_32794 = (state_32901[(2)]);
var state_32901__$1 = state_32901;
var statearr_32964_33034 = state_32901__$1;
(statearr_32964_33034[(2)] = inst_32794);

(statearr_32964_33034[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (5))){
var inst_32764 = (state_32901[(8)]);
var inst_32765 = (state_32901[(10)]);
var inst_32767 = (inst_32765 < inst_32764);
var inst_32768 = inst_32767;
var state_32901__$1 = state_32901;
if(cljs.core.truth_(inst_32768)){
var statearr_32965_33035 = state_32901__$1;
(statearr_32965_33035[(1)] = (7));

} else {
var statearr_32966_33036 = state_32901__$1;
(statearr_32966_33036[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (14))){
var inst_32775 = (state_32901[(22)]);
var inst_32784 = cljs.core.first.call(null,inst_32775);
var inst_32785 = figwheel.client.file_reloading.eval_body.call(null,inst_32784,opts);
var inst_32786 = cljs.core.next.call(null,inst_32775);
var inst_32762 = inst_32786;
var inst_32763 = null;
var inst_32764 = (0);
var inst_32765 = (0);
var state_32901__$1 = (function (){var statearr_32967 = state_32901;
(statearr_32967[(7)] = inst_32763);

(statearr_32967[(32)] = inst_32785);

(statearr_32967[(8)] = inst_32764);

(statearr_32967[(9)] = inst_32762);

(statearr_32967[(10)] = inst_32765);

return statearr_32967;
})();
var statearr_32968_33037 = state_32901__$1;
(statearr_32968_33037[(2)] = null);

(statearr_32968_33037[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (45))){
var state_32901__$1 = state_32901;
var statearr_32969_33038 = state_32901__$1;
(statearr_32969_33038[(2)] = null);

(statearr_32969_33038[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (26))){
var inst_32821 = (state_32901[(26)]);
var inst_32818 = (state_32901[(23)]);
var inst_32815 = (state_32901[(19)]);
var inst_32823 = (state_32901[(24)]);
var inst_32819 = (state_32901[(25)]);
var inst_32838 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_32840 = (function (){var all_files = inst_32815;
var res_SINGLEQUOTE_ = inst_32818;
var res = inst_32819;
var files_not_loaded = inst_32821;
var dependencies_that_loaded = inst_32823;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_32821,inst_32818,inst_32815,inst_32823,inst_32819,inst_32838,state_val_32902,c__26717__auto__,map__32747,map__32747__$1,opts,before_jsload,on_jsload,reload_dependents,map__32748,map__32748__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__32839){
var map__32970 = p__32839;
var map__32970__$1 = ((((!((map__32970 == null)))?((((map__32970.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32970.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32970):map__32970);
var namespace = cljs.core.get.call(null,map__32970__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__32970__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_32821,inst_32818,inst_32815,inst_32823,inst_32819,inst_32838,state_val_32902,c__26717__auto__,map__32747,map__32747__$1,opts,before_jsload,on_jsload,reload_dependents,map__32748,map__32748__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_32841 = cljs.core.map.call(null,inst_32840,inst_32819);
var inst_32842 = cljs.core.pr_str.call(null,inst_32841);
var inst_32843 = figwheel.client.utils.log.call(null,inst_32842);
var inst_32844 = (function (){var all_files = inst_32815;
var res_SINGLEQUOTE_ = inst_32818;
var res = inst_32819;
var files_not_loaded = inst_32821;
var dependencies_that_loaded = inst_32823;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_32821,inst_32818,inst_32815,inst_32823,inst_32819,inst_32838,inst_32840,inst_32841,inst_32842,inst_32843,state_val_32902,c__26717__auto__,map__32747,map__32747__$1,opts,before_jsload,on_jsload,reload_dependents,map__32748,map__32748__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_32821,inst_32818,inst_32815,inst_32823,inst_32819,inst_32838,inst_32840,inst_32841,inst_32842,inst_32843,state_val_32902,c__26717__auto__,map__32747,map__32747__$1,opts,before_jsload,on_jsload,reload_dependents,map__32748,map__32748__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_32845 = setTimeout(inst_32844,(10));
var state_32901__$1 = (function (){var statearr_32972 = state_32901;
(statearr_32972[(33)] = inst_32843);

(statearr_32972[(34)] = inst_32838);

return statearr_32972;
})();
var statearr_32973_33039 = state_32901__$1;
(statearr_32973_33039[(2)] = inst_32845);

(statearr_32973_33039[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (16))){
var state_32901__$1 = state_32901;
var statearr_32974_33040 = state_32901__$1;
(statearr_32974_33040[(2)] = reload_dependents);

(statearr_32974_33040[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (38))){
var inst_32855 = (state_32901[(16)]);
var inst_32872 = cljs.core.apply.call(null,cljs.core.hash_map,inst_32855);
var state_32901__$1 = state_32901;
var statearr_32975_33041 = state_32901__$1;
(statearr_32975_33041[(2)] = inst_32872);

(statearr_32975_33041[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (30))){
var state_32901__$1 = state_32901;
var statearr_32976_33042 = state_32901__$1;
(statearr_32976_33042[(2)] = null);

(statearr_32976_33042[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (10))){
var inst_32775 = (state_32901[(22)]);
var inst_32777 = cljs.core.chunked_seq_QMARK_.call(null,inst_32775);
var state_32901__$1 = state_32901;
if(inst_32777){
var statearr_32977_33043 = state_32901__$1;
(statearr_32977_33043[(1)] = (13));

} else {
var statearr_32978_33044 = state_32901__$1;
(statearr_32978_33044[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (18))){
var inst_32809 = (state_32901[(2)]);
var state_32901__$1 = state_32901;
if(cljs.core.truth_(inst_32809)){
var statearr_32979_33045 = state_32901__$1;
(statearr_32979_33045[(1)] = (19));

} else {
var statearr_32980_33046 = state_32901__$1;
(statearr_32980_33046[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (42))){
var state_32901__$1 = state_32901;
var statearr_32981_33047 = state_32901__$1;
(statearr_32981_33047[(2)] = null);

(statearr_32981_33047[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (37))){
var inst_32867 = (state_32901[(2)]);
var state_32901__$1 = state_32901;
var statearr_32982_33048 = state_32901__$1;
(statearr_32982_33048[(2)] = inst_32867);

(statearr_32982_33048[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32902 === (8))){
var inst_32762 = (state_32901[(9)]);
var inst_32775 = (state_32901[(22)]);
var inst_32775__$1 = cljs.core.seq.call(null,inst_32762);
var state_32901__$1 = (function (){var statearr_32983 = state_32901;
(statearr_32983[(22)] = inst_32775__$1);

return statearr_32983;
})();
if(inst_32775__$1){
var statearr_32984_33049 = state_32901__$1;
(statearr_32984_33049[(1)] = (10));

} else {
var statearr_32985_33050 = state_32901__$1;
(statearr_32985_33050[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26717__auto__,map__32747,map__32747__$1,opts,before_jsload,on_jsload,reload_dependents,map__32748,map__32748__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__26605__auto__,c__26717__auto__,map__32747,map__32747__$1,opts,before_jsload,on_jsload,reload_dependents,map__32748,map__32748__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__26606__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__26606__auto____0 = (function (){
var statearr_32989 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32989[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__26606__auto__);

(statearr_32989[(1)] = (1));

return statearr_32989;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__26606__auto____1 = (function (state_32901){
while(true){
var ret_value__26607__auto__ = (function (){try{while(true){
var result__26608__auto__ = switch__26605__auto__.call(null,state_32901);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26608__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26608__auto__;
}
break;
}
}catch (e32990){if((e32990 instanceof Object)){
var ex__26609__auto__ = e32990;
var statearr_32991_33051 = state_32901;
(statearr_32991_33051[(5)] = ex__26609__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32901);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32990;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26607__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33052 = state_32901;
state_32901 = G__33052;
continue;
} else {
return ret_value__26607__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__26606__auto__ = function(state_32901){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__26606__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__26606__auto____1.call(this,state_32901);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__26606__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__26606__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__26606__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__26606__auto__;
})()
;})(switch__26605__auto__,c__26717__auto__,map__32747,map__32747__$1,opts,before_jsload,on_jsload,reload_dependents,map__32748,map__32748__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__26719__auto__ = (function (){var statearr_32992 = f__26718__auto__.call(null);
(statearr_32992[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26717__auto__);

return statearr_32992;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26719__auto__);
});})(c__26717__auto__,map__32747,map__32747__$1,opts,before_jsload,on_jsload,reload_dependents,map__32748,map__32748__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__26717__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str(location.protocol),cljs.core.str("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__33055,link){
var map__33058 = p__33055;
var map__33058__$1 = ((((!((map__33058 == null)))?((((map__33058.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33058.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33058):map__33058);
var file = cljs.core.get.call(null,map__33058__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = link.href;
if(cljs.core.truth_(temp__4657__auto__)){
var link_href = temp__4657__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4657__auto__,map__33058,map__33058__$1,file){
return (function (p1__33053_SHARP_,p2__33054_SHARP_){
if(cljs.core._EQ_.call(null,p1__33053_SHARP_,p2__33054_SHARP_)){
return p1__33053_SHARP_;
} else {
return false;
}
});})(link_href,temp__4657__auto__,map__33058,map__33058__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4657__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__33064){
var map__33065 = p__33064;
var map__33065__$1 = ((((!((map__33065 == null)))?((((map__33065.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33065.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33065):map__33065);
var match_length = cljs.core.get.call(null,map__33065__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__33065__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__33060_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__33060_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4657__auto__)){
var res = temp__4657__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.add_link_to_doc = (function figwheel$client$file_reloading$add_link_to_doc(var_args){
var args33067 = [];
var len__25620__auto___33070 = arguments.length;
var i__25621__auto___33071 = (0);
while(true){
if((i__25621__auto___33071 < len__25620__auto___33070)){
args33067.push((arguments[i__25621__auto___33071]));

var G__33072 = (i__25621__auto___33071 + (1));
i__25621__auto___33071 = G__33072;
continue;
} else {
}
break;
}

var G__33069 = args33067.length;
switch (G__33069) {
case 1:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33067.length)].join('')));

}
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = (function (new_link){
return (document.getElementsByTagName("head")[(0)]).appendChild(new_link);
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = (function (orig_link,klone){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
return parent.removeChild(orig_link);
});})(parent))
,(300));
});

figwheel.client.file_reloading.add_link_to_doc.cljs$lang$maxFixedArity = 2;
figwheel.client.file_reloading.distictify = (function figwheel$client$file_reloading$distictify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__33074_SHARP_,p2__33075_SHARP_){
return cljs.core.assoc.call(null,p1__33074_SHARP_,cljs.core.get.call(null,p2__33075_SHARP_,key),p2__33075_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(p__33076){
var map__33079 = p__33076;
var map__33079__$1 = ((((!((map__33079 == null)))?((((map__33079.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33079.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33079):map__33079);
var f_data = map__33079__$1;
var file = cljs.core.get.call(null,map__33079__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4657__auto__)){
var link = temp__4657__auto__;
return figwheel.client.file_reloading.add_link_to_doc.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href));
} else {
return null;
}
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__33081,p__33082){
var map__33091 = p__33081;
var map__33091__$1 = ((((!((map__33091 == null)))?((((map__33091.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33091.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33091):map__33091);
var opts = map__33091__$1;
var on_cssload = cljs.core.get.call(null,map__33091__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__33092 = p__33082;
var map__33092__$1 = ((((!((map__33092 == null)))?((((map__33092.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33092.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33092):map__33092);
var files_msg = map__33092__$1;
var files = cljs.core.get.call(null,map__33092__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var seq__33095_33099 = cljs.core.seq.call(null,figwheel.client.file_reloading.distictify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
var chunk__33096_33100 = null;
var count__33097_33101 = (0);
var i__33098_33102 = (0);
while(true){
if((i__33098_33102 < count__33097_33101)){
var f_33103 = cljs.core._nth.call(null,chunk__33096_33100,i__33098_33102);
figwheel.client.file_reloading.reload_css_file.call(null,f_33103);

var G__33104 = seq__33095_33099;
var G__33105 = chunk__33096_33100;
var G__33106 = count__33097_33101;
var G__33107 = (i__33098_33102 + (1));
seq__33095_33099 = G__33104;
chunk__33096_33100 = G__33105;
count__33097_33101 = G__33106;
i__33098_33102 = G__33107;
continue;
} else {
var temp__4657__auto___33108 = cljs.core.seq.call(null,seq__33095_33099);
if(temp__4657__auto___33108){
var seq__33095_33109__$1 = temp__4657__auto___33108;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33095_33109__$1)){
var c__25362__auto___33110 = cljs.core.chunk_first.call(null,seq__33095_33109__$1);
var G__33111 = cljs.core.chunk_rest.call(null,seq__33095_33109__$1);
var G__33112 = c__25362__auto___33110;
var G__33113 = cljs.core.count.call(null,c__25362__auto___33110);
var G__33114 = (0);
seq__33095_33099 = G__33111;
chunk__33096_33100 = G__33112;
count__33097_33101 = G__33113;
i__33098_33102 = G__33114;
continue;
} else {
var f_33115 = cljs.core.first.call(null,seq__33095_33109__$1);
figwheel.client.file_reloading.reload_css_file.call(null,f_33115);

var G__33116 = cljs.core.next.call(null,seq__33095_33109__$1);
var G__33117 = null;
var G__33118 = (0);
var G__33119 = (0);
seq__33095_33099 = G__33116;
chunk__33096_33100 = G__33117;
count__33097_33101 = G__33118;
i__33098_33102 = G__33119;
continue;
}
} else {
}
}
break;
}

return setTimeout(((function (map__33091,map__33091__$1,opts,on_cssload,map__33092,map__33092__$1,files_msg,files){
return (function (){
figwheel.client.file_reloading.on_cssload_custom_event.call(null,files);

return on_cssload.call(null,files);
});})(map__33091,map__33091__$1,opts,on_cssload,map__33092,map__33092__$1,files_msg,files))
,(100));
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1477097019380