/*
 * Decompiled with CFR 0.152.
 */
package me.tonsky.persistent_sorted_set;

import clojure.lang.IChunk;
import clojure.lang.IFn;
import clojure.lang.Reduced;
import me.tonsky.persistent_sorted_set.PersistentSortedSet;
import me.tonsky.persistent_sorted_set.Seq;

class Chunk
implements IChunk {
    final PersistentSortedSet _set;
    final Object[] _keys;
    final int _idx;
    final int _end;
    final boolean _asc;
    final int _version;

    Chunk(Seq seq) {
        this._set = seq._set;
        this._asc = seq._asc;
        this._idx = seq._idx;
        this._keys = seq._node._keys;
        this._version = seq._version;
        if (this._asc) {
            int n;
            if (seq._keyTo != null) {
                for (n = seq._node._len - 1; n > this._idx && seq._cmp.compare(this._keys[n], seq._keyTo) > 0; --n) {
                }
            }
            this._end = n;
        } else {
            int n;
            if (seq._keyTo != null) {
                for (n = 0; n < this._idx && seq._cmp.compare(this._keys[n], seq._keyTo) < 0; ++n) {
                }
            }
            this._end = n;
        }
    }

    Chunk(PersistentSortedSet persistentSortedSet, Object[] objectArray, int n, int n2, boolean bl, int n3) {
        this._set = persistentSortedSet;
        this._keys = objectArray;
        this._idx = n;
        this._end = n2;
        this._asc = bl;
        this._version = n3;
    }

    void checkVersion() {
        if (this._version != this._set._version) {
            throw new RuntimeException("Tovarisch, you are iterating and mutating a transient set at the same time!");
        }
    }

    public IChunk dropFirst() {
        this.checkVersion();
        if (this._idx == this._end) {
            throw new IllegalStateException("dropFirst of empty chunk");
        }
        return new Chunk(this._set, this._keys, this._asc ? this._idx + 1 : this._idx - 1, this._end, this._asc, this._version);
    }

    public Object reduce(IFn iFn, Object object) {
        this.checkVersion();
        Object object2 = iFn.invoke(object, this._keys[this._idx]);
        if (object2 instanceof Reduced) {
            return ((Reduced)object2).deref();
        }
        if (this._asc) {
            for (int i = this._idx + 1; i <= this._end; ++i) {
                if (!((object2 = iFn.invoke(object2, this._keys[i])) instanceof Reduced)) continue;
                return ((Reduced)object2).deref();
            }
        } else {
            for (int i = this._idx - 1; i >= this._end; --i) {
                if (!((object2 = iFn.invoke(object2, this._keys[i])) instanceof Reduced)) continue;
                return ((Reduced)object2).deref();
            }
        }
        return object2;
    }

    public Object nth(int n) {
        this.checkVersion();
        assert (n >= 0 && n < this.count());
        return this._asc ? this._keys[this._idx + n] : this._keys[this._idx - n];
    }

    public Object nth(int n, Object object) {
        this.checkVersion();
        if (n >= 0 && n < this.count()) {
            return this.nth(n);
        }
        return object;
    }

    public int count() {
        this.checkVersion();
        if (this._asc) {
            return this._end - this._idx + 1;
        }
        return this._idx - this._end + 1;
    }
}

