/*
 * Decompiled with CFR 0.152.
 */
package me.tonsky.persistent_sorted_set;

import clojure.lang.AFn;
import clojure.lang.Counted;
import clojure.lang.IHashEq;
import clojure.lang.ILookup;
import clojure.lang.IObj;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentSet;
import clojure.lang.ISeq;
import clojure.lang.Murmur3;
import clojure.lang.RT;
import clojure.lang.Util;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;

public abstract class APersistentSortedSet<Key, Address>
extends AFn
implements IObj,
Counted,
IPersistentSet,
ILookup,
Iterable,
Set,
Serializable,
IHashEq {
    int _hash;
    int _hasheq;
    final IPersistentMap _meta;
    final Comparator<Key> _cmp;

    public APersistentSortedSet(IPersistentMap iPersistentMap, Comparator<Key> comparator) {
        this._meta = iPersistentMap;
        this._cmp = comparator;
    }

    public IPersistentMap meta() {
        return this._meta;
    }

    public boolean equiv(Object object) {
        if (!(object instanceof Set)) {
            return false;
        }
        Set set = (Set)object;
        if (set.size() != this.count()) {
            return false;
        }
        return this.containsAll((Collection)set);
    }

    public Object get(Object object) {
        return this.contains(object) ? object : null;
    }

    public Object valAt(Object object) {
        return this.contains(object) ? object : null;
    }

    public Object valAt(Object object, Object object2) {
        return this.contains(object) ? object : object2;
    }

    public Object invoke(Object object) {
        return this.contains(object) ? object : null;
    }

    public Object invoke(Object object, Object object2) {
        return this.contains(object) ? object : object2;
    }

    public int hasheq() {
        if (this._hasheq == 0) {
            this._hasheq = Murmur3.hashUnordered((Iterable)this);
        }
        return this._hasheq;
    }

    @Override
    public boolean containsAll(Collection collection) {
        for (Object e : collection) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        return this.count();
    }

    @Override
    public boolean isEmpty() {
        return this.count() == 0;
    }

    @Override
    public Object[] toArray() {
        return RT.seqToArray((ISeq)this.seq());
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        return RT.seqToPassedArray((ISeq)this.seq(), (Object[])objectArray);
    }

    @Override
    public boolean add(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        int n = this._hash;
        if (n == 0) {
            for (Object e : this) {
                n += Util.hash(e);
            }
            this._hash = n;
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        return this.equiv(object);
    }

    public String toString() {
        return RT.printString((Object)this);
    }
}

