/*
 * Decompiled with CFR 0.152.
 */
package me.tonsky.persistent_sorted_set;

import clojure.lang.IFn;
import java.util.Comparator;
import java.util.List;
import me.tonsky.persistent_sorted_set.ANode;
import me.tonsky.persistent_sorted_set.ArrayUtil;
import me.tonsky.persistent_sorted_set.IStorage;
import me.tonsky.persistent_sorted_set.PersistentSortedSet;
import me.tonsky.persistent_sorted_set.Settings;
import me.tonsky.persistent_sorted_set.Stitch;

public class Leaf<Key, Address>
extends ANode<Key, Address> {
    public Leaf(int n, Key[] KeyArray, Settings settings) {
        super(n, KeyArray, settings);
    }

    public Leaf(int n, Settings settings) {
        super(n, new Object[ANode.newLen(n, settings)], settings);
    }

    public Leaf(List<Key> list, Settings settings) {
        this(list.size(), list.toArray(), settings);
    }

    @Override
    public int level() {
        return 0;
    }

    @Override
    public int count(IStorage iStorage) {
        return this._len;
    }

    @Override
    public boolean contains(IStorage iStorage, Key Key, Comparator<Key> comparator) {
        return this.search(Key, comparator) >= 0;
    }

    @Override
    public ANode[] add(IStorage iStorage, Key Key, Comparator<Key> comparator, Settings settings) {
        int n = this.search(Key, comparator);
        if (n >= 0) {
            return PersistentSortedSet.UNCHANGED;
        }
        int n2 = -n - 1;
        assert (0 <= n2 && n2 <= this._len);
        if (this.editable() && this._len < this._keys.length) {
            if (n2 == this._len) {
                this._keys[this._len] = Key;
                ++this._len;
                return new ANode[]{this};
            }
            ArrayUtil.copy(this._keys, n2, this._len, this._keys, n2 + 1);
            this._keys[n2] = Key;
            ++this._len;
            return PersistentSortedSet.EARLY_EXIT;
        }
        if (this._len < this._settings.branchingFactor()) {
            Leaf<Key, Address> leaf = new Leaf<Key, Address>(this._len + 1, settings);
            new Stitch(leaf._keys, 0).copyAll(this._keys, 0, n2).copyOne(Key).copyAll(this._keys, n2, this._len);
            return new ANode[]{leaf};
        }
        int n3 = this._len + 1 >>> 1;
        int n4 = this._len + 1 - n3;
        if (n2 < n3) {
            Leaf<Key, Address> leaf = new Leaf<Key, Address>(n3, settings);
            Leaf<Key, Address> leaf2 = new Leaf<Key, Address>(n4, settings);
            new Stitch(leaf._keys, 0).copyAll(this._keys, 0, n2).copyOne(Key).copyAll(this._keys, n2, n3 - 1);
            ArrayUtil.copy(this._keys, n3 - 1, this._len, leaf2._keys, 0);
            return new ANode[]{leaf, leaf2};
        }
        Leaf<Key, Address> leaf = new Leaf<Key, Address>(n3, settings);
        Leaf<Key, Address> leaf3 = new Leaf<Key, Address>(n4, settings);
        ArrayUtil.copy(this._keys, 0, n3, leaf._keys, 0);
        new Stitch(leaf3._keys, 0).copyAll(this._keys, n3, n2).copyOne(Key).copyAll(this._keys, n2, this._len);
        return new ANode[]{leaf, leaf3};
    }

    @Override
    public ANode[] remove(IStorage iStorage, Key Key, ANode aNode, ANode aNode2, Comparator<Key> comparator, Settings settings) {
        Leaf<Key, Address> leaf = (Leaf<Key, Address>)aNode;
        Leaf<Key, Address> leaf2 = (Leaf<Key, Address>)aNode2;
        int n = this.search(Key, comparator);
        if (n < 0) {
            return PersistentSortedSet.UNCHANGED;
        }
        int n2 = this._len - 1;
        if (n2 >= this._settings.minBranchingFactor() || leaf == null && leaf2 == null) {
            if (this.editable()) {
                ArrayUtil.copy(this._keys, n + 1, this._len, this._keys, n);
                this._len = n2;
                if (n == n2) {
                    return new ANode[]{leaf, this, leaf2};
                }
                return PersistentSortedSet.EARLY_EXIT;
            }
            Leaf<Key, Address> leaf3 = new Leaf<Key, Address>(n2, settings);
            new Stitch(leaf3._keys, 0).copyAll(this._keys, 0, n).copyAll(this._keys, n + 1, this._len);
            return new ANode[]{leaf, leaf3, leaf2};
        }
        if (leaf != null && leaf._len + n2 <= this._settings.branchingFactor()) {
            Leaf<Key, Address> leaf4 = new Leaf<Key, Address>(leaf._len + n2, settings);
            new Stitch(leaf4._keys, 0).copyAll(leaf._keys, 0, leaf._len).copyAll(this._keys, 0, n).copyAll(this._keys, n + 1, this._len);
            return new ANode[]{null, leaf4, leaf2};
        }
        if (leaf2 != null && n2 + leaf2.len() <= this._settings.branchingFactor()) {
            Leaf<Key, Address> leaf5 = new Leaf<Key, Address>(n2 + leaf2._len, settings);
            new Stitch(leaf5._keys, 0).copyAll(this._keys, 0, n).copyAll(this._keys, n + 1, this._len).copyAll(leaf2._keys, 0, leaf2._len);
            return new ANode[]{leaf, leaf5, null};
        }
        if (leaf != null && (leaf.editable() || leaf2 == null || leaf._len >= leaf2._len)) {
            Leaf<Key, Address> leaf6;
            Leaf leaf7;
            int n3 = leaf._len + n2;
            int n4 = n3 >>> 1;
            int n5 = n3 - n4;
            int n6 = leaf._len - n4;
            if (this.editable() && n5 <= this._keys.length) {
                leaf7 = this;
                ArrayUtil.copy(this._keys, n + 1, this._len, this._keys, n6 + n);
                ArrayUtil.copy(this._keys, 0, n, this._keys, n6);
                ArrayUtil.copy(leaf._keys, n4, leaf._len, this._keys, 0);
                this._len = n5;
            } else {
                leaf7 = new Leaf(n5, settings);
                new Stitch(leaf7._keys, 0).copyAll(leaf._keys, n4, leaf._len).copyAll(this._keys, 0, n).copyAll(this._keys, n + 1, this._len);
            }
            if (leaf.editable()) {
                leaf6 = leaf;
                leaf._len = n4;
            } else {
                leaf6 = new Leaf<Key, Address>(n4, settings);
                ArrayUtil.copy(leaf._keys, 0, n4, leaf6._keys, 0);
            }
            return new ANode[]{leaf6, leaf7, leaf2};
        }
        if (leaf2 != null) {
            Leaf<Key, Address> leaf8;
            Leaf leaf9;
            int n7 = n2 + leaf2._len;
            int n8 = n7 >>> 1;
            int n9 = n7 - n8;
            int n10 = leaf2._len - n9;
            if (this.editable() && n8 <= this._keys.length) {
                leaf9 = this;
                new Stitch(this._keys, n).copyAll(this._keys, n + 1, this._len).copyAll(leaf2._keys, 0, n10);
                this._len = n8;
            } else {
                leaf9 = new Leaf(n8, settings);
                new Stitch(leaf9._keys, 0).copyAll(this._keys, 0, n).copyAll(this._keys, n + 1, this._len).copyAll(leaf2._keys, 0, n10);
            }
            if (leaf2.editable()) {
                leaf8 = leaf2;
                ArrayUtil.copy(leaf2._keys, n10, leaf2._len, leaf2._keys, 0);
                leaf2._len = n9;
            } else {
                leaf8 = new Leaf<Key, Address>(n9, settings);
                ArrayUtil.copy(leaf2._keys, n10, leaf2._len, leaf8._keys, 0);
            }
            return new ANode[]{leaf, leaf9, leaf8};
        }
        throw new RuntimeException("Unreachable");
    }

    @Override
    public ANode[] replace(IStorage iStorage, Key Key, Key Key2, Comparator<Key> comparator, Settings settings) {
        assert (0 == comparator.compare(Key, Key2)) : "oldKey and newKey must compare as equal (cmp.compare must return 0)";
        int n = this.search(Key, comparator);
        if (n < 0) {
            return PersistentSortedSet.UNCHANGED;
        }
        if (this.editable()) {
            this._keys[n] = Key2;
            if (n == this._len - 1) {
                return new ANode[]{this};
            }
            return PersistentSortedSet.EARLY_EXIT;
        }
        Leaf<Key, Address> leaf = new Leaf<Key, Address>(this._len, settings);
        ArrayUtil.copy(this._keys, 0, this._len, leaf._keys, 0);
        leaf._keys[n] = Key2;
        return new ANode[]{leaf};
    }

    @Override
    public void walkAddresses(IStorage iStorage, IFn iFn) {
    }

    @Override
    public Address store(IStorage<Key, Address> iStorage) {
        return iStorage.store(this);
    }

    @Override
    public String str(IStorage iStorage, int n) {
        StringBuilder stringBuilder = new StringBuilder("{");
        for (int i = 0; i < this._len; ++i) {
            if (i > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(this._keys[i].toString());
        }
        return stringBuilder.append("}").toString();
    }

    @Override
    public void toString(StringBuilder stringBuilder, Address Address, String string) {
        stringBuilder.append(string);
        stringBuilder.append("Leaf   addr: " + String.valueOf(Address) + " len: " + this._len + " ");
    }
}

