/*
 * Decompiled with CFR 0.152.
 */
package me.tonsky.persistent_sorted_set;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;
import me.tonsky.persistent_sorted_set.RefType;

public class Settings {
    public final int _branchingFactor;
    public final RefType _refType;
    public final AtomicBoolean _edit;

    public Settings(int n, RefType refType, AtomicBoolean atomicBoolean) {
        this._branchingFactor = n;
        this._refType = refType;
        this._edit = atomicBoolean;
    }

    public Settings() {
        this(0, null);
    }

    public Settings(int n) {
        this(n, null);
    }

    public Settings(int n, RefType refType) {
        if (n <= 0) {
            n = 512;
        }
        if (null == refType) {
            refType = RefType.SOFT;
        }
        this._branchingFactor = n;
        this._refType = refType;
        this._edit = null;
    }

    public int minBranchingFactor() {
        return this._branchingFactor >>> 1;
    }

    public int branchingFactor() {
        return this._branchingFactor;
    }

    public int expandLen() {
        return 8;
    }

    public RefType refType() {
        return this._refType;
    }

    public boolean editable() {
        return this._edit != null && this._edit.get();
    }

    public Settings editable(boolean bl) {
        assert (!this.editable());
        assert (bl);
        return new Settings(this._branchingFactor, this._refType, new AtomicBoolean(bl));
    }

    public void persistent() {
        assert (this._edit != null);
        this._edit.set(false);
    }

    public <T> Object makeReference(T t) {
        switch (this._refType) {
            case STRONG: {
                return t;
            }
            case SOFT: {
                return new SoftReference<T>(t);
            }
            case WEAK: {
                return new WeakReference<T>(t);
            }
        }
        throw new RuntimeException("Unexpected _refType: " + String.valueOf((Object)this._refType));
    }

    public Object readReference(Object object) {
        return object instanceof Reference ? ((Reference)object).get() : object;
    }
}

