/*
 * Decompiled with CFR 0.152.
 */
package me.tonsky.persistent_sorted_set;

import clojure.lang.ASeq;
import clojure.lang.IChunkedSeq;
import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.IReduce;
import clojure.lang.ISeq;
import clojure.lang.Obj;
import clojure.lang.PersistentList;
import clojure.lang.Reduced;
import clojure.lang.Reversible;
import java.util.Comparator;
import java.util.Iterator;
import me.tonsky.persistent_sorted_set.ANode;
import me.tonsky.persistent_sorted_set.Branch;
import me.tonsky.persistent_sorted_set.Chunk;
import me.tonsky.persistent_sorted_set.ISeek;
import me.tonsky.persistent_sorted_set.JavaIter;
import me.tonsky.persistent_sorted_set.PersistentSortedSet;

public class Seq
extends ASeq
implements IReduce,
Reversible,
IChunkedSeq,
ISeek {
    final PersistentSortedSet _set;
    Seq _parent;
    ANode _node;
    int _idx;
    final Object _keyTo;
    final Comparator _cmp;
    final boolean _asc;
    final int _version;

    Seq(IPersistentMap iPersistentMap, PersistentSortedSet persistentSortedSet, Seq seq, ANode aNode, int n, Object object, Comparator comparator, boolean bl, int n2) {
        super(iPersistentMap);
        this._set = persistentSortedSet;
        this._parent = seq;
        this._node = aNode;
        this._idx = n;
        this._keyTo = object;
        this._cmp = comparator;
        this._asc = bl;
        this._version = n2;
    }

    void checkVersion() {
        if (this._version != this._set._version) {
            throw new RuntimeException("Tovarisch, you are iterating and mutating a transient set at the same time!");
        }
    }

    ANode child() {
        assert (this._node instanceof Branch) : this._node;
        return ((Branch)this._node).child(this._set._storage, this._idx);
    }

    boolean over() {
        if (this._keyTo == null) {
            return false;
        }
        int n = this._cmp.compare(this.first(), this._keyTo);
        return this._asc ? n > 0 : n < 0;
    }

    boolean advance() {
        this.checkVersion();
        if (this._asc) {
            if (this._idx < this._node._len - 1) {
                ++this._idx;
                return !this.over();
            }
            if (this._parent != null) {
                this._parent = this._parent.next();
                if (this._parent != null) {
                    this._node = this._parent.child();
                    this._idx = 0;
                    return !this.over();
                }
            }
        } else {
            if (this._idx > 0) {
                --this._idx;
                return !this.over();
            }
            if (this._parent != null) {
                this._parent = this._parent.next();
                if (this._parent != null) {
                    this._node = this._parent.child();
                    this._idx = this._node._len - 1;
                    return !this.over();
                }
            }
        }
        return false;
    }

    protected Seq clone() {
        return new Seq(this.meta(), this._set, this._parent, this._node, this._idx, this._keyTo, this._cmp, this._asc, this._version);
    }

    public Object first() {
        this.checkVersion();
        return this._node._keys[this._idx];
    }

    public Seq next() {
        Seq seq = this.clone();
        return seq.advance() ? seq : null;
    }

    public Obj withMeta(IPersistentMap iPersistentMap) {
        if (this.meta() == iPersistentMap) {
            return this;
        }
        return new Seq(iPersistentMap, this._set, this._parent, this._node, this._idx, this._keyTo, this._cmp, this._asc, this._version);
    }

    public Object reduce(IFn iFn) {
        this.checkVersion();
        Seq seq = this.clone();
        Object object = seq.first();
        while (seq.advance()) {
            if (!((object = iFn.invoke(object, seq.first())) instanceof Reduced)) continue;
            return ((Reduced)object).deref();
        }
        return object;
    }

    public Object reduce(IFn iFn, Object object) {
        this.checkVersion();
        Seq seq = this.clone();
        Object object2 = object;
        do {
            if (!((object2 = iFn.invoke(object2, seq.first())) instanceof Reduced)) continue;
            return ((Reduced)object2).deref();
        } while (seq.advance());
        return object2;
    }

    public Iterator iterator() {
        this.checkVersion();
        return new JavaIter(this.clone());
    }

    public Chunk chunkedFirst() {
        this.checkVersion();
        return new Chunk(this);
    }

    public Seq chunkedNext() {
        this.checkVersion();
        if (this._parent == null) {
            return null;
        }
        Seq seq = this._parent.next();
        if (seq == null) {
            return null;
        }
        ANode aNode = seq.child();
        Seq seq2 = new Seq(this.meta(), this._set, seq, aNode, this._asc ? 0 : aNode._len - 1, this._keyTo, this._cmp, this._asc, this._version);
        return seq2.over() ? null : seq2;
    }

    public ISeq chunkedMore() {
        Seq seq = this.chunkedNext();
        if (seq == null) {
            return PersistentList.EMPTY;
        }
        return seq;
    }

    boolean atBeginning() {
        return this._idx == 0 && (this._parent == null || this._parent.atBeginning());
    }

    boolean atEnd() {
        return this._idx == this._node._len - 1 && (this._parent == null || this._parent.atEnd());
    }

    public Seq rseq() {
        this.checkVersion();
        if (this._asc) {
            return this._set.rslice(this._keyTo, this.atBeginning() ? null : this.first(), this._cmp);
        }
        return this._set.slice(this._keyTo, this.atEnd() ? null : this.first(), this._cmp);
    }

    public Seq seek(Object object) {
        return this.seek(object, this._cmp);
    }

    public Seq seek(Object object, Comparator comparator) {
        int n;
        if (object == null) {
            throw new RuntimeException("seek can't be called with a nil key!");
        }
        Seq seq = this._parent;
        ANode aNode = this._node;
        if (this._asc) {
            int n2;
            while (aNode != null && comparator.compare(aNode.maxKey(), object) < 0) {
                if (seq == null) {
                    return null;
                }
                aNode = seq._node;
                seq = seq._parent;
            }
            while (true) {
                if ((n2 = aNode.searchFirst(object, comparator)) < 0) {
                    n2 = -n2 - 1;
                }
                if (n2 == aNode._len) {
                    return null;
                }
                if (!(aNode instanceof Branch)) break;
                seq = new Seq(null, this._set, seq, aNode, n2, null, null, true, this._version);
                aNode = seq.child();
            }
            return (seq = new Seq(null, this._set, seq, aNode, n2, this._keyTo, comparator, true, this._version)).over() ? null : seq;
        }
        while (comparator.compare(object, aNode.minKey()) < 0 && seq != null) {
            aNode = seq._node;
            seq = seq._parent;
        }
        while (aNode instanceof Branch) {
            n = aNode.searchLast(object, comparator) + 1;
            if (n == aNode._len) {
                --n;
            }
            seq = new Seq(null, this._set, seq, aNode, n, null, null, false, this._version);
            aNode = seq.child();
        }
        n = aNode.searchLast(object, comparator);
        if (n == -1) {
            return (seq = new Seq(null, this._set, seq, aNode, 0, this._keyTo, comparator, false, this._version)).advance() ? seq : null;
        }
        return (seq = new Seq(null, this._set, seq, aNode, n, this._keyTo, comparator, false, this._version)).over() ? null : seq;
    }
}

