/*
 * Decompiled with CFR 0.152.
 */
package me.tonsky.persistent_sorted_set;

import clojure.lang.IEditableCollection;
import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.IReduce;
import clojure.lang.ITransientSet;
import clojure.lang.RT;
import clojure.lang.Reversible;
import clojure.lang.Sorted;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import me.tonsky.persistent_sorted_set.ANode;
import me.tonsky.persistent_sorted_set.APersistentSortedSet;
import me.tonsky.persistent_sorted_set.Branch;
import me.tonsky.persistent_sorted_set.IPersistentSortedSet;
import me.tonsky.persistent_sorted_set.IStorage;
import me.tonsky.persistent_sorted_set.JavaIter;
import me.tonsky.persistent_sorted_set.Leaf;
import me.tonsky.persistent_sorted_set.Seq;
import me.tonsky.persistent_sorted_set.Settings;

public class PersistentSortedSet<Key, Address>
extends APersistentSortedSet<Key, Address>
implements IEditableCollection,
ITransientSet,
Reversible,
Sorted,
IReduce,
IPersistentSortedSet<Key, Address> {
    public static ANode[] EARLY_EXIT = new ANode[0];
    public static ANode[] UNCHANGED = new ANode[0];
    public static final PersistentSortedSet EMPTY = new PersistentSortedSet();
    public Address _address;
    public Object _root;
    public int _count;
    public int _version;
    public final Settings _settings;
    public IStorage<Key, Address> _storage;

    public PersistentSortedSet() {
        this(null, RT.DEFAULT_COMPARATOR);
    }

    public PersistentSortedSet(Comparator<Key> comparator) {
        this(null, comparator);
    }

    public PersistentSortedSet(IPersistentMap iPersistentMap, Comparator<Key> comparator) {
        this(iPersistentMap, comparator, null, new Settings());
    }

    public PersistentSortedSet(IPersistentMap iPersistentMap, Comparator<Key> comparator, IStorage<Key, Address> iStorage, Settings settings) {
        this(iPersistentMap, comparator, null, iStorage, new Leaf(0, settings), 0, settings, 0);
    }

    public PersistentSortedSet(IPersistentMap iPersistentMap, Comparator<Key> comparator, Address Address, IStorage<Key, Address> iStorage, Object object, int n, Settings settings, int n2) {
        super(iPersistentMap, comparator);
        this._address = Address;
        this._root = object;
        this._count = n;
        this._version = n2;
        this._settings = settings;
        this._storage = iStorage;
    }

    public ANode<Key, Address> root() {
        assert (this._address != null || this._root != null);
        ANode<Key, Address> aNode = (ANode<Key, Address>)this._settings.readReference(this._root);
        if (aNode == null && this._address != null) {
            aNode = this._storage.restore(this._address);
            this._root = this._settings.makeReference(aNode);
        }
        return aNode;
    }

    private int alterCount(int n) {
        return this._count < 0 ? this._count : this._count + n;
    }

    public boolean editable() {
        return this._settings.editable();
    }

    public Address address(Address Address) {
        this._address = Address;
        return Address;
    }

    public Seq slice(Key Key, Key Key2) {
        return this.slice(Key, Key2, this._cmp);
    }

    public Seq slice(Key Key, Key Key2, Comparator<Key> comparator) {
        int n;
        assert (Key == null || Key2 == null || comparator.compare(Key, Key2) <= 0) : "From " + String.valueOf(Key) + " after to " + String.valueOf(Key2);
        Seq seq = null;
        ANode aNode = this.root();
        if (aNode.len() == 0) {
            return null;
        }
        if (Key == null) {
            while (aNode instanceof Branch) {
                seq = new Seq(null, this, seq, aNode, 0, null, null, true, this._version);
                aNode = seq.child();
            }
            return (seq = new Seq(null, this, seq, aNode, 0, Key2, comparator, true, this._version)).over() ? null : seq;
        }
        while (true) {
            if ((n = aNode.searchFirst(Key, comparator)) < 0) {
                n = -n - 1;
            }
            if (n == aNode._len) {
                return null;
            }
            if (!(aNode instanceof Branch)) break;
            seq = new Seq(null, this, seq, aNode, n, null, null, true, this._version);
            aNode = seq.child();
        }
        return (seq = new Seq(null, this, seq, aNode, n, Key2, comparator, true, this._version)).over() ? null : seq;
    }

    public Seq rslice(Key Key, Key Key2) {
        return this.rslice(Key, Key2, this._cmp);
    }

    public Seq rslice(Key Key, Key Key2, Comparator<Key> comparator) {
        int n;
        assert (Key == null || Key2 == null || comparator.compare(Key, Key2) >= 0) : "From " + String.valueOf(Key) + " before to " + String.valueOf(Key2);
        Seq seq = null;
        ANode aNode = this.root();
        if (aNode.len() == 0) {
            return null;
        }
        if (Key == null) {
            int n2;
            while (true) {
                n2 = aNode._len - 1;
                if (!(aNode instanceof Branch)) break;
                seq = new Seq(null, this, seq, aNode, n2, null, null, false, this._version);
                aNode = seq.child();
            }
            return (seq = new Seq(null, this, seq, aNode, n2, Key2, comparator, false, this._version)).over() ? null : seq;
        }
        while (aNode instanceof Branch) {
            n = aNode.searchLast(Key, comparator) + 1;
            if (n == aNode._len) {
                --n;
            }
            seq = new Seq(null, this, seq, aNode, n, null, null, false, this._version);
            aNode = seq.child();
        }
        n = aNode.searchLast(Key, comparator);
        if (n == -1) {
            return (seq = new Seq(null, this, seq, aNode, 0, Key2, comparator, false, this._version)).advance() ? seq : null;
        }
        return (seq = new Seq(null, this, seq, aNode, n, Key2, comparator, false, this._version)).over() ? null : seq;
    }

    public void walkAddresses(IFn iFn) {
        if (this._address != null && !RT.booleanCast((Object)iFn.invoke(this._address))) {
            return;
        }
        this.root().walkAddresses(this._storage, iFn);
    }

    public Address store() {
        assert (this._storage != null);
        if (this._address == null) {
            ANode aNode = (ANode)this._settings.readReference(this._root);
            this.address(aNode.store(this._storage));
            this._root = this._settings.makeReference(aNode);
        }
        return this._address;
    }

    public Address store(IStorage<Key, Address> iStorage) {
        this._storage = iStorage;
        return this.store();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("#{");
        for (Object e : this) {
            stringBuilder.append(e).append(" ");
        }
        if (stringBuilder.charAt(stringBuilder.length() - 1) == " ".charAt(0)) {
            stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public String str() {
        return this.root().str(this._storage, 0);
    }

    public PersistentSortedSet withMeta(IPersistentMap iPersistentMap) {
        if (this._meta == iPersistentMap) {
            return this;
        }
        return new PersistentSortedSet<Key, Address>(iPersistentMap, this._cmp, this._address, this._storage, this._root, this._count, this._settings, this._version);
    }

    public int count() {
        if (this._count < 0) {
            this._count = this.root().count(this._storage);
        }
        return this._count;
    }

    public Comparator comparator() {
        return this._cmp;
    }

    public Object entryKey(Object object) {
        return object;
    }

    public Object reduce(IFn iFn) {
        Seq seq = (Seq)this.seq();
        return seq == null ? iFn.invoke() : seq.reduce(iFn);
    }

    public Object reduce(IFn iFn, Object object) {
        Seq seq = (Seq)this.seq();
        return seq == null ? object : seq.reduce(iFn, object);
    }

    public PersistentSortedSet empty() {
        return new PersistentSortedSet<Key, Address>(this._meta, this._cmp, this._storage, this._settings);
    }

    public PersistentSortedSet cons(Object object) {
        return this.cons(object, this._cmp);
    }

    public PersistentSortedSet cons(Object object, Comparator comparator) {
        ANode[] aNodeArray = this.root().add(this._storage, object, comparator, this._settings);
        if (UNCHANGED == aNodeArray) {
            return this;
        }
        if (this.editable()) {
            if (1 == aNodeArray.length) {
                this._address = null;
                this._root = aNodeArray[0];
            } else if (2 == aNodeArray.length) {
                Object[] objectArray = new Object[]{aNodeArray[0].maxKey(), aNodeArray[1].maxKey()};
                this._address = null;
                this._root = new Branch(aNodeArray[0].level() + 1, 2, objectArray, null, new Object[]{aNodeArray[0], aNodeArray[1]}, this._settings);
            }
            this._count = this.alterCount(1);
            ++this._version;
            return this;
        }
        if (1 == aNodeArray.length) {
            return new PersistentSortedSet<Key, Object>(this._meta, this._cmp, null, this._storage, aNodeArray[0], this.alterCount(1), this._settings, this._version + 1);
        }
        Object[] objectArray = new Object[]{aNodeArray[0].maxKey(), aNodeArray[1].maxKey()};
        Object[] objectArray2 = Arrays.copyOf(aNodeArray, aNodeArray.length, new Object[0].getClass());
        Branch branch = new Branch(aNodeArray[0].level() + 1, 2, objectArray, null, objectArray2, this._settings);
        return new PersistentSortedSet<Key, Object>(this._meta, this._cmp, null, this._storage, branch, this.alterCount(1), this._settings, this._version + 1);
    }

    public PersistentSortedSet disjoin(Object object) {
        return this.disjoin(object, this._cmp);
    }

    public PersistentSortedSet disjoin(Object object, Comparator comparator) {
        ANode[] aNodeArray = this.root().remove(this._storage, object, null, null, comparator, this._settings);
        if (UNCHANGED == aNodeArray) {
            return this;
        }
        if (aNodeArray == EARLY_EXIT) {
            this._address = null;
            this._count = this.alterCount(-1);
            ++this._version;
            return this;
        }
        ANode aNode = aNodeArray[1];
        if (this.editable()) {
            if (aNode instanceof Branch && aNode._len == 1) {
                aNode = ((Branch)aNode).child(this._storage, 0);
            }
            this._address = null;
            this._root = aNode;
            this._count = this.alterCount(-1);
            ++this._version;
            return this;
        }
        if (aNode instanceof Branch && aNode._len == 1) {
            aNode = ((Branch)aNode).child(this._storage, 0);
            return new PersistentSortedSet<Key, Object>(this._meta, this._cmp, null, this._storage, aNode, this.alterCount(-1), this._settings, this._version + 1);
        }
        return new PersistentSortedSet<Key, Object>(this._meta, this._cmp, null, this._storage, aNode, this.alterCount(-1), this._settings, this._version + 1);
    }

    public PersistentSortedSet replace(Object object, Object object2) {
        return this.replace(object, object2, this._cmp);
    }

    public PersistentSortedSet replace(Object object, Object object2, Comparator comparator) {
        ANode[] aNodeArray = this.root().replace(this._storage, object, object2, comparator, this._settings);
        if (UNCHANGED == aNodeArray) {
            return this;
        }
        if (EARLY_EXIT == aNodeArray) {
            this._address = null;
            ++this._version;
            return this;
        }
        ANode aNode = aNodeArray[0];
        if (this.editable()) {
            this._address = null;
            this._root = aNode;
            ++this._version;
            return this;
        }
        return new PersistentSortedSet<Key, Object>(this._meta, this._cmp, null, this._storage, aNode, this._count, this._settings, this._version + 1);
    }

    @Override
    public boolean contains(Object object) {
        return this.root().contains(this._storage, object, this._cmp);
    }

    public Key lookup(Object object) {
        return this.lookup(object, this._cmp);
    }

    public Key lookup(Object object, Comparator<Key> comparator) {
        int n;
        ANode<Object, Address> aNode = this.root();
        if (aNode.len() == 0) {
            return null;
        }
        while (true) {
            if ((n = aNode.searchFirst(object, comparator)) >= aNode._len) {
                return null;
            }
            if (!(aNode instanceof Branch)) break;
            aNode = ((Branch)aNode).child(this._storage, n);
        }
        if (comparator.compare(aNode._keys[n], object) != 0) {
            return null;
        }
        return aNode._keys[n];
    }

    public PersistentSortedSet asTransient() {
        if (this.editable()) {
            throw new IllegalStateException("Expected persistent set");
        }
        return new PersistentSortedSet<Key, Address>(this._meta, this._cmp, this._address, this._storage, this._root, this._count, this._settings.editable(true), this._version);
    }

    public PersistentSortedSet conj(Object object) {
        return this.cons(object, this._cmp);
    }

    public PersistentSortedSet persistent() {
        if (!this.editable()) {
            throw new IllegalStateException("Expected transient set");
        }
        this._settings.persistent();
        return this;
    }

    @Override
    public Iterator iterator() {
        return new JavaIter((Seq)this.seq());
    }
}

