/*
 * Decompiled with CFR 0.152.
 */
package me.tonsky.persistent_sorted_set;

import clojure.lang.IFn;
import clojure.lang.RT;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import me.tonsky.persistent_sorted_set.ANode;
import me.tonsky.persistent_sorted_set.ArrayUtil;
import me.tonsky.persistent_sorted_set.IStorage;
import me.tonsky.persistent_sorted_set.PersistentSortedSet;
import me.tonsky.persistent_sorted_set.Settings;
import me.tonsky.persistent_sorted_set.Stitch;

public class Branch<Key, Address>
extends ANode<Key, Address> {
    public final int _level;
    public Address[] _addresses;
    public Object[] _children;

    public Branch(int n, int n2, Key[] KeyArray, Address[] AddressArray, Object[] objectArray, Settings settings) {
        super(n2, KeyArray, settings);
        assert (n >= 1);
        assert (AddressArray == null || AddressArray.length >= n2) : "addresses = " + Arrays.toString(AddressArray) + ", len = " + n2;
        assert (objectArray == null || objectArray.length >= n2);
        this._level = n;
        this._addresses = AddressArray;
        this._children = objectArray;
    }

    public Branch(int n, int n2, Settings settings) {
        super(n2, new Object[ANode.newLen(n2, settings)], settings);
        assert (n >= 1);
        this._level = n;
        this._addresses = null;
        this._children = null;
    }

    public Branch(int n, List<Key> list, List<Address> list2, Settings settings) {
        this(n, list.size(), list.toArray(), list2.toArray(), null, settings);
    }

    protected Address[] ensureAddresses() {
        if (this._addresses == null) {
            this._addresses = new Object[this._keys.length];
        }
        return this._addresses;
    }

    public List<Address> addresses() {
        if (this._addresses == null) {
            return Arrays.asList(new Object[this._len]);
        }
        if (this._addresses.length == this._len) {
            return Arrays.asList(this._addresses);
        }
        return Arrays.asList(Arrays.copyOfRange(this._addresses, 0, this._len));
    }

    public Address address(int n) {
        assert (0 <= n && n < this._len);
        if (this._addresses == null) {
            return null;
        }
        return this._addresses[n];
    }

    public Address address(int n, Address Address) {
        assert (0 <= n && n < this._len);
        if (this._addresses != null || Address != null) {
            this.ensureAddresses();
            this._addresses[n] = Address;
            if (Address != null && this._children[n] instanceof ANode) {
                this._children[n] = this._settings.makeReference(this._children[n]);
            }
        }
        return Address;
    }

    public ANode<Key, Address> child(IStorage iStorage, int n) {
        assert (0 <= n && n < this._len);
        assert (this._children != null && this._children[n] != null || this._addresses != null && this._addresses[n] != null);
        ANode aNode = null;
        if (this._children != null) {
            Object object = this._children[n];
            aNode = (ANode)this._settings.readReference(object);
        }
        if (aNode == null) {
            assert (this._addresses[n] != null);
            aNode = iStorage.restore(this._addresses[n]);
            this.ensureChildren()[n] = this._settings.makeReference(aNode);
        } else if (this._addresses != null && this._addresses[n] != null) {
            iStorage.accessed(this._addresses[n]);
        }
        return aNode;
    }

    public ANode<Key, Address> child(int n, ANode<Key, Address> aNode) {
        this.address(n, null);
        if (this._children != null || aNode != null) {
            this.ensureChildren();
            this._children[n] = aNode;
        }
        return aNode;
    }

    @Override
    public int count(IStorage iStorage) {
        int n = 0;
        for (int i = 0; i < this._len; ++i) {
            n += this.child(iStorage, i).count(iStorage);
        }
        return n;
    }

    @Override
    public int level() {
        return this._level;
    }

    protected Object[] ensureChildren() {
        if (this._children == null) {
            this._children = new Object[this._keys.length];
        }
        return this._children;
    }

    @Override
    public boolean contains(IStorage iStorage, Key Key, Comparator<Key> comparator) {
        int n = this.search(Key, comparator);
        if (n >= 0) {
            return true;
        }
        int n2 = -n - 1;
        if (n2 == this._len) {
            return false;
        }
        assert (0 <= n2 && n2 < this._len);
        return this.child(iStorage, n2).contains(iStorage, Key, comparator);
    }

    @Override
    public ANode[] add(IStorage iStorage, Key Key, Comparator<Key> comparator, Settings settings) {
        int n = this.search(Key, comparator);
        if (n >= 0) {
            return PersistentSortedSet.UNCHANGED;
        }
        int n2 = -n - 1;
        if (n2 == this._len) {
            n2 = this._len - 1;
        }
        assert (0 <= n2 && n2 < this._len);
        ANode[] aNodeArray = this.child(iStorage, n2).add(iStorage, Key, comparator, settings);
        if (PersistentSortedSet.UNCHANGED == aNodeArray) {
            return PersistentSortedSet.UNCHANGED;
        }
        if (PersistentSortedSet.EARLY_EXIT == aNodeArray) {
            return PersistentSortedSet.EARLY_EXIT;
        }
        if (1 == aNodeArray.length && this.editable()) {
            ANode aNode = aNodeArray[0];
            this._keys[n2] = aNode.maxKey();
            this.child(n2, aNode);
            if (n2 == this._len - 1 && aNode.maxKey() == this.maxKey()) {
                return new ANode[]{this};
            }
            return PersistentSortedSet.EARLY_EXIT;
        }
        if (1 == aNodeArray.length) {
            Object[] objectArray;
            ANode aNode = aNodeArray[0];
            if (0 == comparator.compare(aNode.maxKey(), this._keys[n2])) {
                objectArray = this._keys;
            } else {
                objectArray = Arrays.copyOfRange(this._keys, 0, this._len);
                objectArray[n2] = aNode.maxKey();
            }
            Address[] AddressArray = null;
            Object[] objectArray2 = null;
            if (aNode == this.child(iStorage, n2)) {
                AddressArray = this._addresses;
                objectArray2 = this._children;
            } else {
                if (this._addresses != null) {
                    AddressArray = Arrays.copyOfRange(this._addresses, 0, this._len);
                    AddressArray[n2] = null;
                }
                objectArray2 = this._children == null ? new Object[this._keys.length] : Arrays.copyOfRange(this._children, 0, this._len);
                objectArray2[n2] = aNode;
            }
            return new ANode[]{new Branch<Object, Address>(this._level, this._len, objectArray, AddressArray, objectArray2, settings)};
        }
        if (this._len < this._settings.branchingFactor()) {
            Branch<Key, Address> branch = new Branch<Key, Address>(this._level, this._len + 1, settings);
            new Stitch(branch._keys, 0).copyAll(this._keys, 0, n2).copyOne(aNodeArray[0].maxKey()).copyOne(aNodeArray[1].maxKey()).copyAll(this._keys, n2 + 1, this._len);
            if (this._addresses != null) {
                branch.ensureAddresses();
                new Stitch(branch._addresses, 0).copyAll(this._addresses, 0, n2).copyOne(null).copyOne(null).copyAll(this._addresses, n2 + 1, this._len);
            }
            branch.ensureChildren();
            new Stitch(branch._children, 0).copyAll(this._children, 0, n2).copyOne(aNodeArray[0]).copyOne(aNodeArray[1]).copyAll(this._children, n2 + 1, this._len);
            return new ANode[]{branch};
        }
        int n3 = this._len + 1 >>> 1;
        if (n2 + 1 == n3) {
            ++n3;
        }
        int n4 = this._len + 1 - n3;
        if (n2 < n3) {
            Object[] objectArray = new Object[n3];
            new Stitch(objectArray, 0).copyAll(this._keys, 0, n2).copyOne(aNodeArray[0].maxKey()).copyOne(aNodeArray[1].maxKey()).copyAll(this._keys, n2 + 1, n3 - 1);
            Object[] objectArray3 = new Object[n4];
            ArrayUtil.copy(this._keys, n3 - 1, this._len, objectArray3, 0);
            Object[] objectArray4 = null;
            Object[] objectArray5 = null;
            if (this._addresses != null) {
                objectArray4 = new Object[n3];
                new Stitch(objectArray4, 0).copyAll(this._addresses, 0, n2).copyOne(null).copyOne(null).copyAll(this._addresses, n2 + 1, n3 - 1);
                objectArray5 = new Object[n4];
                ArrayUtil.copy(this._addresses, n3 - 1, this._len, objectArray5, 0);
            }
            Object[] objectArray6 = new Object[n3];
            Object[] objectArray7 = null;
            new Stitch(objectArray6, 0).copyAll(this._children, 0, n2).copyOne(aNodeArray[0]).copyOne(aNodeArray[1]).copyAll(this._children, n2 + 1, n3 - 1);
            if (this._children != null) {
                objectArray7 = new Object[n4];
                ArrayUtil.copy(this._children, n3 - 1, this._len, objectArray7, 0);
            }
            return new ANode[]{new Branch<Object, Object>(this._level, n3, objectArray, objectArray4, objectArray6, settings), new Branch<Object, Object>(this._level, n4, objectArray3, objectArray5, objectArray7, settings)};
        }
        Object[] objectArray = new Object[n3];
        Object[] objectArray8 = new Object[n4];
        ArrayUtil.copy(this._keys, 0, n3, objectArray, 0);
        new Stitch(objectArray8, 0).copyAll(this._keys, n3, n2).copyOne(aNodeArray[0].maxKey()).copyOne(aNodeArray[1].maxKey()).copyAll(this._keys, n2 + 1, this._len);
        Object[] objectArray9 = null;
        Object[] objectArray10 = null;
        if (this._addresses != null) {
            objectArray9 = new Object[n3];
            ArrayUtil.copy(this._addresses, 0, n3, objectArray9, 0);
            objectArray10 = new Object[n4];
            new Stitch(objectArray10, 0).copyAll(this._addresses, n3, n2).copyOne(null).copyOne(null).copyAll(this._addresses, n2 + 1, this._len);
        }
        Object[] objectArray11 = null;
        Object[] objectArray12 = new Object[n4];
        if (this._children != null) {
            objectArray11 = new Object[n3];
            ArrayUtil.copy(this._children, 0, n3, objectArray11, 0);
        }
        new Stitch(objectArray12, 0).copyAll(this._children, n3, n2).copyOne(aNodeArray[0]).copyOne(aNodeArray[1]).copyAll(this._children, n2 + 1, this._len);
        return new ANode[]{new Branch<Object, Object>(this._level, n3, objectArray, objectArray9, objectArray11, settings), new Branch<Object, Object>(this._level, n4, objectArray8, objectArray10, objectArray12, settings)};
    }

    @Override
    public ANode[] remove(IStorage iStorage, Key Key, ANode aNode, ANode aNode2, Comparator<Key> comparator, Settings settings) {
        Branch branch = (Branch)aNode;
        Branch branch2 = (Branch)aNode2;
        int n = this.search(Key, comparator);
        if (n < 0) {
            n = -n - 1;
        }
        if (n == this._len) {
            return PersistentSortedSet.UNCHANGED;
        }
        assert (0 <= n && n < this._len);
        ANode<Key, Address> aNode3 = n > 0 ? this.child(iStorage, n - 1) : null;
        ANode<Key, Address> aNode4 = n < this._len - 1 ? this.child(iStorage, n + 1) : null;
        int n2 = Branch.safeLen(aNode3);
        int n3 = Branch.safeLen(aNode4);
        ANode[] aNodeArray = this.child(iStorage, n).remove(iStorage, Key, aNode3, aNode4, comparator, settings);
        if (PersistentSortedSet.UNCHANGED == aNodeArray) {
            return PersistentSortedSet.UNCHANGED;
        }
        if (PersistentSortedSet.EARLY_EXIT == aNodeArray) {
            return PersistentSortedSet.EARLY_EXIT;
        }
        boolean bl = aNode3 != aNodeArray[0] || n2 != Branch.safeLen(aNodeArray[0]);
        boolean bl2 = aNode4 != aNodeArray[2] || n3 != Branch.safeLen(aNodeArray[2]);
        int n4 = this._len - 1 - (aNode3 != null ? 1 : 0) - (aNode4 != null ? 1 : 0) + (aNodeArray[0] != null ? 1 : 0) + 1 + (aNodeArray[2] != null ? 1 : 0);
        if (n4 >= this._settings.minBranchingFactor() || branch == null && branch2 == null) {
            Stitch stitch;
            if (this.editable() && n < this._len - 2) {
                Stitch stitch2;
                Stitch stitch3 = new Stitch(this._keys, Math.max(n - 1, 0));
                if (aNodeArray[0] != null) {
                    stitch3.copyOne(aNodeArray[0].maxKey());
                }
                stitch3.copyOne(aNodeArray[1].maxKey());
                if (aNodeArray[2] != null) {
                    stitch3.copyOne(aNodeArray[2].maxKey());
                }
                if (n4 != this._len) {
                    stitch3.copyAll(this._keys, n + 2, this._len);
                }
                if (this._addresses != null) {
                    stitch2 = new Stitch(this._addresses, Math.max(n - 1, 0));
                    if (aNodeArray[0] != null) {
                        stitch2.copyOne(bl ? null : this.address(n - 1));
                    }
                    stitch2.copyOne(null);
                    if (aNodeArray[2] != null) {
                        stitch2.copyOne(bl2 ? null : this.address(n + 1));
                    }
                    if (n4 != this._len) {
                        stitch2.copyAll(this._addresses, n + 2, this._len);
                    }
                }
                this.ensureChildren();
                stitch2 = new Stitch(this._children, Math.max(n - 1, 0));
                if (aNodeArray[0] != null) {
                    stitch2.copyOne(aNodeArray[0]);
                }
                stitch2.copyOne(aNodeArray[1]);
                if (aNodeArray[2] != null) {
                    stitch2.copyOne(aNodeArray[2]);
                }
                if (n4 != this._len) {
                    stitch2.copyAll(this._children, n + 2, this._len);
                }
                this._len = n4;
                return PersistentSortedSet.EARLY_EXIT;
            }
            Branch<Key, Address> branch3 = new Branch<Key, Address>(this._level, n4, settings);
            Stitch stitch4 = new Stitch(branch3._keys, 0);
            stitch4.copyAll(this._keys, 0, n - 1);
            if (aNodeArray[0] != null) {
                stitch4.copyOne(aNodeArray[0].maxKey());
            }
            stitch4.copyOne(aNodeArray[1].maxKey());
            if (aNodeArray[2] != null) {
                stitch4.copyOne(aNodeArray[2].maxKey());
            }
            stitch4.copyAll(this._keys, n + 2, this._len);
            if (this._addresses != null) {
                stitch = new Stitch(branch3.ensureAddresses(), 0);
                stitch.copyAll(this._addresses, 0, n - 1);
                if (aNodeArray[0] != null) {
                    stitch.copyOne(bl ? null : this.address(n - 1));
                }
                stitch.copyOne(null);
                if (aNodeArray[2] != null) {
                    stitch.copyOne(bl2 ? null : this.address(n + 1));
                }
                stitch.copyAll(this._addresses, n + 2, this._len);
            }
            branch3.ensureChildren();
            stitch = new Stitch(branch3._children, 0);
            stitch.copyAll(this._children, 0, n - 1);
            if (aNodeArray[0] != null) {
                stitch.copyOne(aNodeArray[0]);
            }
            stitch.copyOne(aNodeArray[1]);
            if (aNodeArray[2] != null) {
                stitch.copyOne(aNodeArray[2]);
            }
            stitch.copyAll(this._children, n + 2, this._len);
            return new ANode[]{branch, branch3, branch2};
        }
        if (branch != null && branch._len + n4 <= this._settings.branchingFactor()) {
            Stitch stitch;
            Branch<Key, Address> branch4 = new Branch<Key, Address>(this._level, branch._len + n4, settings);
            Stitch stitch5 = new Stitch(branch4._keys, 0);
            stitch5.copyAll(branch._keys, 0, branch._len);
            stitch5.copyAll(this._keys, 0, n - 1);
            if (aNodeArray[0] != null) {
                stitch5.copyOne(aNodeArray[0].maxKey());
            }
            stitch5.copyOne(aNodeArray[1].maxKey());
            if (aNodeArray[2] != null) {
                stitch5.copyOne(aNodeArray[2].maxKey());
            }
            stitch5.copyAll(this._keys, n + 2, this._len);
            if (branch._addresses != null || this._addresses != null) {
                stitch = new Stitch(branch4.ensureAddresses(), 0);
                stitch.copyAll(branch._addresses, 0, branch._len);
                stitch.copyAll(this._addresses, 0, n - 1);
                if (aNodeArray[0] != null) {
                    stitch.copyOne(bl ? null : this.address(n - 1));
                }
                stitch.copyOne(null);
                if (aNodeArray[2] != null) {
                    stitch.copyOne(bl2 ? null : this.address(n + 1));
                }
                stitch.copyAll(this._addresses, n + 2, this._len);
            }
            branch4.ensureChildren();
            stitch = new Stitch(branch4._children, 0);
            stitch.copyAll(branch._children, 0, branch._len);
            stitch.copyAll(this._children, 0, n - 1);
            if (aNodeArray[0] != null) {
                stitch.copyOne(aNodeArray[0]);
            }
            stitch.copyOne(aNodeArray[1]);
            if (aNodeArray[2] != null) {
                stitch.copyOne(aNodeArray[2]);
            }
            stitch.copyAll(this._children, n + 2, this._len);
            return new ANode[]{null, branch4, branch2};
        }
        if (branch2 != null && n4 + branch2._len <= this._settings.branchingFactor()) {
            Stitch stitch;
            Branch<Key, Address> branch5 = new Branch<Key, Address>(this._level, n4 + branch2._len, settings);
            Stitch stitch6 = new Stitch(branch5._keys, 0);
            stitch6.copyAll(this._keys, 0, n - 1);
            if (aNodeArray[0] != null) {
                stitch6.copyOne(aNodeArray[0].maxKey());
            }
            stitch6.copyOne(aNodeArray[1].maxKey());
            if (aNodeArray[2] != null) {
                stitch6.copyOne(aNodeArray[2].maxKey());
            }
            stitch6.copyAll(this._keys, n + 2, this._len);
            stitch6.copyAll(branch2._keys, 0, branch2._len);
            if (this._addresses != null || branch2._addresses != null) {
                stitch = new Stitch(branch5.ensureAddresses(), 0);
                stitch.copyAll(this._addresses, 0, n - 1);
                if (aNodeArray[0] != null) {
                    stitch.copyOne(bl ? null : this.address(n - 1));
                }
                stitch.copyOne(null);
                if (aNodeArray[2] != null) {
                    stitch.copyOne(bl2 ? null : this.address(n + 1));
                }
                stitch.copyAll(this._addresses, n + 2, this._len);
                stitch.copyAll(branch2._addresses, 0, branch2._len);
            }
            branch5.ensureChildren();
            stitch = new Stitch(branch5._children, 0);
            stitch.copyAll(this._children, 0, n - 1);
            if (aNodeArray[0] != null) {
                stitch.copyOne(aNodeArray[0]);
            }
            stitch.copyOne(aNodeArray[1]);
            if (aNodeArray[2] != null) {
                stitch.copyOne(aNodeArray[2]);
            }
            stitch.copyAll(this._children, n + 2, this._len);
            stitch.copyAll(branch2._children, 0, branch2._len);
            return new ANode[]{branch, branch5, null};
        }
        if (branch != null && (branch2 == null || branch._len >= branch2._len)) {
            Stitch stitch;
            int n5 = branch._len + n4;
            int n6 = n5 >>> 1;
            int n7 = n5 - n6;
            Branch<Key, Address> branch6 = new Branch<Key, Address>(this._level, n6, settings);
            Branch<Key, Address> branch7 = new Branch<Key, Address>(this._level, n7, settings);
            ArrayUtil.copy(branch._keys, 0, n6, branch6._keys, 0);
            Stitch stitch7 = new Stitch(branch7._keys, 0);
            stitch7.copyAll(branch._keys, n6, branch._len);
            stitch7.copyAll(this._keys, 0, n - 1);
            if (aNodeArray[0] != null) {
                stitch7.copyOne(aNodeArray[0].maxKey());
            }
            stitch7.copyOne(aNodeArray[1].maxKey());
            if (aNodeArray[2] != null) {
                stitch7.copyOne(aNodeArray[2].maxKey());
            }
            stitch7.copyAll(this._keys, n + 2, this._len);
            if (branch._addresses != null) {
                ArrayUtil.copy(branch._addresses, 0, n6, branch6.ensureAddresses(), 0);
            }
            if (branch._children != null) {
                ArrayUtil.copy(branch._children, 0, n6, branch6.ensureChildren(), 0);
            }
            if (branch._addresses != null || this._addresses != null) {
                stitch = new Stitch(branch7.ensureAddresses(), 0);
                stitch.copyAll(branch._addresses, n6, branch._len);
                stitch.copyAll(this._addresses, 0, n - 1);
                if (aNodeArray[0] != null) {
                    stitch.copyOne(bl ? null : this.address(n - 1));
                }
                stitch.copyOne(null);
                if (aNodeArray[2] != null) {
                    stitch.copyOne(bl2 ? null : this.address(n + 1));
                }
                stitch.copyAll(this._addresses, n + 2, this._len);
            }
            branch7.ensureChildren();
            stitch = new Stitch(branch7._children, 0);
            stitch.copyAll(branch._children, n6, branch._len);
            stitch.copyAll(this._children, 0, n - 1);
            if (aNodeArray[0] != null) {
                stitch.copyOne(aNodeArray[0]);
            }
            stitch.copyOne(aNodeArray[1]);
            if (aNodeArray[2] != null) {
                stitch.copyOne(aNodeArray[2]);
            }
            stitch.copyAll(this._children, n + 2, this._len);
            return new ANode[]{branch6, branch7, branch2};
        }
        if (branch2 != null) {
            Stitch stitch;
            int n8 = n4 + branch2._len;
            int n9 = n8 >>> 1;
            int n10 = n8 - n9;
            int n11 = branch2._len - n10;
            Branch<Key, Address> branch8 = new Branch<Key, Address>(this._level, n9, settings);
            Branch<Key, Address> branch9 = new Branch<Key, Address>(this._level, n10, settings);
            Stitch stitch8 = new Stitch(branch8._keys, 0);
            stitch8.copyAll(this._keys, 0, n - 1);
            if (aNodeArray[0] != null) {
                stitch8.copyOne(aNodeArray[0].maxKey());
            }
            stitch8.copyOne(aNodeArray[1].maxKey());
            if (aNodeArray[2] != null) {
                stitch8.copyOne(aNodeArray[2].maxKey());
            }
            stitch8.copyAll(this._keys, n + 2, this._len);
            stitch8.copyAll(branch2._keys, 0, n11);
            ArrayUtil.copy(branch2._keys, n11, branch2._len, branch9._keys, 0);
            if (this._addresses != null || branch2._addresses != null) {
                stitch = new Stitch(branch8.ensureAddresses(), 0);
                stitch.copyAll(this._addresses, 0, n - 1);
                if (aNodeArray[0] != null) {
                    stitch.copyOne(bl ? null : this.address(n - 1));
                }
                stitch.copyOne(null);
                if (aNodeArray[2] != null) {
                    stitch.copyOne(bl2 ? null : this.address(n + 1));
                }
                stitch.copyAll(this._addresses, n + 2, this._len);
                stitch.copyAll(branch2._addresses, 0, n11);
            }
            branch8.ensureChildren();
            stitch = new Stitch(branch8._children, 0);
            stitch.copyAll(this._children, 0, n - 1);
            if (aNodeArray[0] != null) {
                stitch.copyOne(aNodeArray[0]);
            }
            stitch.copyOne(aNodeArray[1]);
            if (aNodeArray[2] != null) {
                stitch.copyOne(aNodeArray[2]);
            }
            stitch.copyAll(this._children, n + 2, this._len);
            stitch.copyAll(branch2._children, 0, n11);
            if (branch2._addresses != null) {
                ArrayUtil.copy(branch2._addresses, n11, branch2._len, branch9.ensureAddresses(), 0);
            }
            if (branch2._children != null) {
                ArrayUtil.copy(branch2._children, n11, branch2._len, branch9.ensureChildren(), 0);
            }
            return new ANode[]{branch, branch8, branch9};
        }
        throw new RuntimeException("Unreachable");
    }

    @Override
    public ANode[] replace(IStorage iStorage, Key Key, Key Key2, Comparator<Key> comparator, Settings settings) {
        Object[] objectArray;
        boolean bl;
        assert (0 == comparator.compare(Key, Key2)) : "oldKey and newKey must compare as equal (cmp.compare must return 0)";
        int n = this.search(Key, comparator);
        if (n < 0) {
            n = -n - 1;
        }
        if (n == this._len) {
            n = this._len - 1;
        }
        assert (0 <= n && n < this._len);
        ANode[] aNodeArray = this.child(iStorage, n).replace(iStorage, Key, Key2, comparator, settings);
        if (PersistentSortedSet.UNCHANGED == aNodeArray) {
            return PersistentSortedSet.UNCHANGED;
        }
        if (PersistentSortedSet.EARLY_EXIT == aNodeArray) {
            return PersistentSortedSet.EARLY_EXIT;
        }
        ANode aNode = aNodeArray[0];
        Object Key3 = aNode.maxKey();
        boolean bl2 = bl = n == this._len - 1 && 0 != comparator.compare(Key3, this._keys[n]);
        if (this.editable()) {
            this._keys[n] = Key3;
            this.child(n, aNode);
            if (this._addresses != null) {
                this._addresses[n] = null;
            }
            if (bl) {
                return new ANode[]{this};
            }
            return PersistentSortedSet.EARLY_EXIT;
        }
        if (0 == comparator.compare(Key3, this._keys[n])) {
            objectArray = this._keys;
        } else {
            objectArray = Arrays.copyOfRange(this._keys, 0, this._len);
            objectArray[n] = Key3;
        }
        Address[] AddressArray = null;
        if (this._addresses != null) {
            AddressArray = Arrays.copyOfRange(this._addresses, 0, this._len);
            AddressArray[n] = null;
        }
        Object[] objectArray2 = this._children == null ? new Object[this._keys.length] : Arrays.copyOfRange(this._children, 0, this._len);
        objectArray2[n] = aNode;
        return new ANode[]{new Branch<Object, Address>(this._level, this._len, objectArray, AddressArray, objectArray2, settings)};
    }

    @Override
    public void walkAddresses(IStorage iStorage, IFn iFn) {
        for (int i = 0; i < this._len; ++i) {
            Address Address = this.address(i);
            if (Address != null && !RT.booleanCast((Object)iFn.invoke(Address)) || this._level <= 1) continue;
            this.child(iStorage, i).walkAddresses(iStorage, iFn);
        }
    }

    @Override
    public Address store(IStorage<Key, Address> iStorage) {
        this.ensureAddresses();
        for (int i = 0; i < this._len; ++i) {
            if (this._addresses[i] != null) continue;
            assert (this._children != null);
            assert (this._children[i] != null);
            assert (this._children[i] instanceof ANode);
            this.address(i, ((ANode)this._children[i]).store(iStorage));
        }
        return iStorage.store(this);
    }

    @Override
    public String str(IStorage iStorage, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this._len; ++i) {
            stringBuilder.append("\n");
            for (int j = 0; j < n; ++j) {
                stringBuilder.append("| ");
            }
            stringBuilder.append(String.valueOf(this._keys[i]) + ": " + this.child(iStorage, i).str(iStorage, n + 1));
        }
        return stringBuilder.toString();
    }

    @Override
    public void toString(StringBuilder stringBuilder, Address Address, String string) {
        stringBuilder.append(string);
        stringBuilder.append("Branch addr: " + String.valueOf(Address) + " len: " + this._len + " ");
        for (int i = 0; i < this._len; ++i) {
            Object object;
            stringBuilder.append("\n");
            ANode aNode = null;
            if (this._children != null && (object = this._children[i]) != null) {
                aNode = (ANode)this._settings.readReference(object);
            }
            if (aNode != null) {
                aNode.toString(stringBuilder, this.address(i), string + "  ");
                continue;
            }
            stringBuilder.append(string + "  " + String.valueOf(this.address(i)) + ": <lazy> ");
        }
    }
}

