// Compiled by ClojureScript 1.11.132 {:optimizations :none}
goog.provide('superv.async');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');

/**
 * @interface
 */
superv.async.PSupervisor = function(){};

var superv$async$PSupervisor$_error$dyn_28016 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (superv.async._error[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return m__5351__auto__.call(null,this$);
} else {
var m__5349__auto__ = (superv.async._error["_"]);
if((!((m__5349__auto__ == null)))){
return m__5349__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-error",this$);
}
}
});
superv.async._error = (function superv$async$_error(this$){
if((((!((this$ == null)))) && ((!((this$.superv$async$PSupervisor$_error$arity$1 == null)))))){
return this$.superv$async$PSupervisor$_error$arity$1(this$);
} else {
return superv$async$PSupervisor$_error$dyn_28016.call(null,this$);
}
});

var superv$async$PSupervisor$_abort$dyn_28017 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (superv.async._abort[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return m__5351__auto__.call(null,this$);
} else {
var m__5349__auto__ = (superv.async._abort["_"]);
if((!((m__5349__auto__ == null)))){
return m__5349__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-abort",this$);
}
}
});
superv.async._abort = (function superv$async$_abort(this$){
if((((!((this$ == null)))) && ((!((this$.superv$async$PSupervisor$_abort$arity$1 == null)))))){
return this$.superv$async$PSupervisor$_abort$arity$1(this$);
} else {
return superv$async$PSupervisor$_abort$dyn_28017.call(null,this$);
}
});

var superv$async$PSupervisor$_register_go$dyn_28018 = (function (this$,body){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (superv.async._register_go[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return m__5351__auto__.call(null,this$,body);
} else {
var m__5349__auto__ = (superv.async._register_go["_"]);
if((!((m__5349__auto__ == null)))){
return m__5349__auto__.call(null,this$,body);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-register-go",this$);
}
}
});
superv.async._register_go = (function superv$async$_register_go(this$,body){
if((((!((this$ == null)))) && ((!((this$.superv$async$PSupervisor$_register_go$arity$2 == null)))))){
return this$.superv$async$PSupervisor$_register_go$arity$2(this$,body);
} else {
return superv$async$PSupervisor$_register_go$dyn_28018.call(null,this$,body);
}
});

var superv$async$PSupervisor$_unregister_go$dyn_28019 = (function (this$,id){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (superv.async._unregister_go[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return m__5351__auto__.call(null,this$,id);
} else {
var m__5349__auto__ = (superv.async._unregister_go["_"]);
if((!((m__5349__auto__ == null)))){
return m__5349__auto__.call(null,this$,id);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-unregister-go",this$);
}
}
});
superv.async._unregister_go = (function superv$async$_unregister_go(this$,id){
if((((!((this$ == null)))) && ((!((this$.superv$async$PSupervisor$_unregister_go$arity$2 == null)))))){
return this$.superv$async$PSupervisor$_unregister_go$arity$2(this$,id);
} else {
return superv$async$PSupervisor$_unregister_go$dyn_28019.call(null,this$,id);
}
});

var superv$async$PSupervisor$_track_exception$dyn_28020 = (function (this$,e){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (superv.async._track_exception[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return m__5351__auto__.call(null,this$,e);
} else {
var m__5349__auto__ = (superv.async._track_exception["_"]);
if((!((m__5349__auto__ == null)))){
return m__5349__auto__.call(null,this$,e);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-track-exception",this$);
}
}
});
superv.async._track_exception = (function superv$async$_track_exception(this$,e){
if((((!((this$ == null)))) && ((!((this$.superv$async$PSupervisor$_track_exception$arity$2 == null)))))){
return this$.superv$async$PSupervisor$_track_exception$arity$2(this$,e);
} else {
return superv$async$PSupervisor$_track_exception$dyn_28020.call(null,this$,e);
}
});

var superv$async$PSupervisor$_free_exception$dyn_28021 = (function (this$,e){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (superv.async._free_exception[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return m__5351__auto__.call(null,this$,e);
} else {
var m__5349__auto__ = (superv.async._free_exception["_"]);
if((!((m__5349__auto__ == null)))){
return m__5349__auto__.call(null,this$,e);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-free-exception",this$);
}
}
});
superv.async._free_exception = (function superv$async$_free_exception(this$,e){
if((((!((this$ == null)))) && ((!((this$.superv$async$PSupervisor$_free_exception$arity$2 == null)))))){
return this$.superv$async$PSupervisor$_free_exception$arity$2(this$,e);
} else {
return superv$async$PSupervisor$_free_exception$dyn_28021.call(null,this$,e);
}
});

superv.async.now = (function superv$async$now(){
return (new Date());
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {superv.async.PSupervisor}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
superv.async.TrackingSupervisor = (function (error,aborts,registered,pending_exceptions,__meta,__extmap,__hash){
this.error = error;
this.aborts = aborts;
this.registered = registered;
this.pending_exceptions = pending_exceptions;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(superv.async.TrackingSupervisor.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5300__auto__,k__5301__auto__){
var self__ = this;
var this__5300__auto____$1 = this;
return this__5300__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5301__auto__,null);
}));

(superv.async.TrackingSupervisor.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5302__auto__,k28023,else__5303__auto__){
var self__ = this;
var this__5302__auto____$1 = this;
var G__28027 = k28023;
var G__28027__$1 = (((G__28027 instanceof cljs.core.Keyword))?G__28027.fqn:null);
switch (G__28027__$1) {
case "error":
return self__.error;

break;
case "aborts":
return self__.aborts;

break;
case "registered":
return self__.registered;

break;
case "pending-exceptions":
return self__.pending_exceptions;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k28023,else__5303__auto__);

}
}));

(superv.async.TrackingSupervisor.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5320__auto__,f__5321__auto__,init__5322__auto__){
var self__ = this;
var this__5320__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__5323__auto__,p__28028){
var vec__28029 = p__28028;
var k__5324__auto__ = cljs.core.nth.call(null,vec__28029,(0),null);
var v__5325__auto__ = cljs.core.nth.call(null,vec__28029,(1),null);
return f__5321__auto__.call(null,ret__5323__auto__,k__5324__auto__,v__5325__auto__);
}),init__5322__auto__,this__5320__auto____$1);
}));

(superv.async.TrackingSupervisor.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5315__auto__,writer__5316__auto__,opts__5317__auto__){
var self__ = this;
var this__5315__auto____$1 = this;
var pr_pair__5318__auto__ = (function (keyval__5319__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__5316__auto__,cljs.core.pr_writer,""," ","",opts__5317__auto__,keyval__5319__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__5316__auto__,pr_pair__5318__auto__,"#superv.async.TrackingSupervisor{",", ","}",opts__5317__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error","error",-978969032),self__.error],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"aborts","aborts",-277478143),self__.aborts],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"registered","registered",-388600037),self__.registered],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),self__.pending_exceptions],null))], null),self__.__extmap));
}));

(superv.async.TrackingSupervisor.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__28022){
var self__ = this;
var G__28022__$1 = this;
return (new cljs.core.RecordIter((0),G__28022__$1,4,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"aborts","aborts",-277478143),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(superv.async.TrackingSupervisor.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5298__auto__){
var self__ = this;
var this__5298__auto____$1 = this;
return self__.__meta;
}));

(superv.async.TrackingSupervisor.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5295__auto__){
var self__ = this;
var this__5295__auto____$1 = this;
return (new superv.async.TrackingSupervisor(self__.error,self__.aborts,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,self__.__hash));
}));

(superv.async.TrackingSupervisor.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5304__auto__){
var self__ = this;
var this__5304__auto____$1 = this;
return (4 + cljs.core.count.call(null,self__.__extmap));
}));

(superv.async.TrackingSupervisor.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5296__auto__){
var self__ = this;
var this__5296__auto____$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = (function (coll__5297__auto__){
return (-1100907306 ^ cljs.core.hash_unordered_coll.call(null,coll__5297__auto__));
}).call(null,this__5296__auto____$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(superv.async.TrackingSupervisor.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this28024,other28025){
var self__ = this;
var this28024__$1 = this;
return (((!((other28025 == null)))) && ((((this28024__$1.constructor === other28025.constructor)) && (((cljs.core._EQ_.call(null,this28024__$1.error,other28025.error)) && (((cljs.core._EQ_.call(null,this28024__$1.aborts,other28025.aborts)) && (((cljs.core._EQ_.call(null,this28024__$1.registered,other28025.registered)) && (((cljs.core._EQ_.call(null,this28024__$1.pending_exceptions,other28025.pending_exceptions)) && (cljs.core._EQ_.call(null,this28024__$1.__extmap,other28025.__extmap)))))))))))));
}));

(superv.async.TrackingSupervisor.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5310__auto__,k__5311__auto__){
var self__ = this;
var this__5310__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"aborts","aborts",-277478143),null,new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),null,new cljs.core.Keyword(null,"error","error",-978969032),null,new cljs.core.Keyword(null,"registered","registered",-388600037),null], null), null),k__5311__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__5310__auto____$1),self__.__meta),k__5311__auto__);
} else {
return (new superv.async.TrackingSupervisor(self__.error,self__.aborts,self__.registered,self__.pending_exceptions,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__5311__auto__)),null));
}
}));

(superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$ = cljs.core.PROTOCOL_SENTINEL);

(superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_error$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.error;
}));

(superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_abort$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.rand_nth.call(null,self__.aborts);
}));

(superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_register_go$arity$2 = (function (this$,body){
var self__ = this;
var this$__$1 = this;
var id = cljs.core.random_uuid.call(null);
cljs.core.swap_BANG_.call(null,self__.registered,cljs.core.assoc,id,body);

return id;
}));

(superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_unregister_go$arity$2 = (function (this$,id){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.registered,cljs.core.dissoc,id);
}));

(superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_track_exception$arity$2 = (function (this$,e){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.pending_exceptions,cljs.core.assoc,e,superv.async.now.call(null));
}));

(superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_free_exception$arity$2 = (function (this$,e){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.pending_exceptions,cljs.core.dissoc,e);
}));

(superv.async.TrackingSupervisor.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5307__auto__,k28023){
var self__ = this;
var this__5307__auto____$1 = this;
var G__28032 = k28023;
var G__28032__$1 = (((G__28032 instanceof cljs.core.Keyword))?G__28032.fqn:null);
switch (G__28032__$1) {
case "error":
case "aborts":
case "registered":
case "pending-exceptions":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k28023);

}
}));

(superv.async.TrackingSupervisor.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5308__auto__,k__5309__auto__,G__28022){
var self__ = this;
var this__5308__auto____$1 = this;
var pred__28033 = cljs.core.keyword_identical_QMARK_;
var expr__28034 = k__5309__auto__;
if(cljs.core.truth_(pred__28033.call(null,new cljs.core.Keyword(null,"error","error",-978969032),expr__28034))){
return (new superv.async.TrackingSupervisor(G__28022,self__.aborts,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28033.call(null,new cljs.core.Keyword(null,"aborts","aborts",-277478143),expr__28034))){
return (new superv.async.TrackingSupervisor(self__.error,G__28022,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28033.call(null,new cljs.core.Keyword(null,"registered","registered",-388600037),expr__28034))){
return (new superv.async.TrackingSupervisor(self__.error,self__.aborts,G__28022,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28033.call(null,new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),expr__28034))){
return (new superv.async.TrackingSupervisor(self__.error,self__.aborts,self__.registered,G__28022,self__.__meta,self__.__extmap,null));
} else {
return (new superv.async.TrackingSupervisor(self__.error,self__.aborts,self__.registered,self__.pending_exceptions,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__5309__auto__,G__28022),null));
}
}
}
}
}));

(superv.async.TrackingSupervisor.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5313__auto__){
var self__ = this;
var this__5313__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"error","error",-978969032),self__.error,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"aborts","aborts",-277478143),self__.aborts,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"registered","registered",-388600037),self__.registered,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),self__.pending_exceptions,null))], null),self__.__extmap));
}));

(superv.async.TrackingSupervisor.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5299__auto__,G__28022){
var self__ = this;
var this__5299__auto____$1 = this;
return (new superv.async.TrackingSupervisor(self__.error,self__.aborts,self__.registered,self__.pending_exceptions,G__28022,self__.__extmap,self__.__hash));
}));

(superv.async.TrackingSupervisor.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5305__auto__,entry__5306__auto__){
var self__ = this;
var this__5305__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__5306__auto__)){
return this__5305__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__5306__auto__,(0)),cljs.core._nth.call(null,entry__5306__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__5305__auto____$1,entry__5306__auto__);
}
}));

(superv.async.TrackingSupervisor.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"error","error",661562495,null),new cljs.core.Symbol(null,"aborts","aborts",1363053384,null),new cljs.core.Symbol(null,"registered","registered",1251931490,null),new cljs.core.Symbol(null,"pending-exceptions","pending-exceptions",-247748567,null)], null);
}));

(superv.async.TrackingSupervisor.cljs$lang$type = true);

(superv.async.TrackingSupervisor.cljs$lang$ctorPrSeq = (function (this__5346__auto__){
return (new cljs.core.List(null,"superv.async/TrackingSupervisor",null,(1),null));
}));

(superv.async.TrackingSupervisor.cljs$lang$ctorPrWriter = (function (this__5346__auto__,writer__5347__auto__){
return cljs.core._write.call(null,writer__5347__auto__,"superv.async/TrackingSupervisor");
}));

/**
 * Positional factory function for superv.async/TrackingSupervisor.
 */
superv.async.__GT_TrackingSupervisor = (function superv$async$__GT_TrackingSupervisor(error,aborts,registered,pending_exceptions){
return (new superv.async.TrackingSupervisor(error,aborts,registered,pending_exceptions,null,null,null));
});

/**
 * Factory function for superv.async/TrackingSupervisor, taking a map of keywords to field values.
 */
superv.async.map__GT_TrackingSupervisor = (function superv$async$map__GT_TrackingSupervisor(G__28026){
var extmap__5342__auto__ = (function (){var G__28036 = cljs.core.dissoc.call(null,G__28026,new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"aborts","aborts",-277478143),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094));
if(cljs.core.record_QMARK_.call(null,G__28026)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__28036);
} else {
return G__28036;
}
})();
return (new superv.async.TrackingSupervisor(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(G__28026),new cljs.core.Keyword(null,"aborts","aborts",-277478143).cljs$core$IFn$_invoke$arity$1(G__28026),new cljs.core.Keyword(null,"registered","registered",-388600037).cljs$core$IFn$_invoke$arity$1(G__28026),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(G__28026),null,cljs.core.not_empty.call(null,extmap__5342__auto__),null));
});

superv.async.NUM_ABORT_CHANS = (1000);
/**
 * A simple supervisor which deals with errors through callbacks. You need to
 *   close its abort channel manually if you want the context to stop. It is
 *   supposed to be used at a boundary to an unsupervised system. If you want
 *   strong supervision, use the restarting-supervisor instead.
 */
superv.async.simple_supervisor = (function superv$async$simple_supervisor(var_args){
var args__5732__auto__ = [];
var len__5726__auto___28052 = arguments.length;
var i__5727__auto___28053 = (0);
while(true){
if((i__5727__auto___28053 < len__5726__auto___28052)){
args__5732__auto__.push((arguments[i__5727__auto___28053]));

var G__28054 = (i__5727__auto___28053 + (1));
i__5727__auto___28053 = G__28054;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((0) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((0)),(0),null)):null);
return superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic(argseq__5733__auto__);
});

(superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic = (function (p__28040){
var map__28041 = p__28040;
var map__28041__$1 = cljs.core.__destructure_map.call(null,map__28041);
var stale_timeout = cljs.core.get.call(null,map__28041__$1,new cljs.core.Keyword(null,"stale-timeout","stale-timeout",-468804294),((10) * (1000)));
var error_fn = cljs.core.get.call(null,map__28041__$1,new cljs.core.Keyword(null,"error-fn","error-fn",-171437615),(function (e){
return cljs.core.println.call(null,"Supervisor:",e,e.stack);
}));
var pending_fn = cljs.core.get.call(null,map__28041__$1,new cljs.core.Keyword(null,"pending-fn","pending-fn",1734381755));
var s = superv.async.map__GT_TrackingSupervisor.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.async.chan.call(null),new cljs.core.Keyword(null,"aborts","aborts",-277478143),cljs.core.vec.call(null,cljs.core.repeatedly.call(null,(1000),(function (){
return cljs.core.async.promise_chan.call(null);
}))),new cljs.core.Keyword(null,"registered","registered",-388600037),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)], null));
var err_ch = s.error;
cljs.core.async.take_BANG_.call(null,err_ch,(function superv$async$loop_fn(e){
error_fn.call(null,e);

return cljs.core.async.take_BANG_.call(null,err_ch,superv$async$loop_fn);
}));

(function superv$async$pending(_){
var vec__28042 = cljs.core.filter.call(null,(function (p__28048){
var vec__28049 = p__28048;
var k = cljs.core.nth.call(null,vec__28049,(0),null);
var v = cljs.core.nth.call(null,vec__28049,(1),null);
return ((superv.async.now.call(null).getTime() - stale_timeout) > v.getTime());
}),cljs.core.deref.call(null,s.pending_exceptions));
var vec__28045 = cljs.core.nth.call(null,vec__28042,(0),null);
var e = cljs.core.nth.call(null,vec__28045,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__28045,(1),null);
if(cljs.core.truth_(e)){
error_fn.call(null,e);

superv.async._free_exception.call(null,s,e);
} else {
}

return cljs.core.async.take_BANG_.call(null,cljs.core.async.timeout.call(null,stale_timeout),superv$async$pending);
}).call(null,null);

return s;
}));

(superv.async.simple_supervisor.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(superv.async.simple_supervisor.cljs$lang$applyTo = (function (seq28039){
var self__5712__auto__ = this;
return self__5712__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28039));
}));

superv.async.dummy_supervisor = (function superv$async$dummy_supervisor(){
return superv.async.map__GT_TrackingSupervisor.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.async.chan.call(null),new cljs.core.Keyword(null,"aborts","aborts",-277478143),cljs.core.vec.call(null,cljs.core.repeatedly.call(null,(1000),(function (){
return cljs.core.async.promise_chan.call(null);
}))),new cljs.core.Keyword(null,"registered","registered",-388600037),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)], null));
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
superv.async.throw_if_exception_ = (function superv$async$throw_if_exception_(x){
if((x instanceof Error)){
throw cljs.core.ex_info.call(null,(function (){var or__5002__auto__ = x.message;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(x);
}
})(),(function (){var or__5002__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
superv.async.S = (function (){try{return superv.async.simple_supervisor.call(null);
}catch (e28055){if((e28055 instanceof Error)){
var _ = e28055;
return superv.async.simple_supervisor.call(null);
} else {
throw e28055;

}
}})();
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
superv.async.throw_if_exception = (function superv$async$throw_if_exception(S,x){
if((x instanceof Error)){
superv.async._free_exception.call(null,S,x);

throw cljs.core.ex_info.call(null,(function (){var or__5002__auto__ = x.message;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(x);
}
})(),(function (){var or__5002__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
superv.async.superv_init = (function superv$async$superv_init(){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [superv.async._error,superv.async._abort,superv.async._register_go,superv.async._unregister_go,superv.async._track_exception,superv.async._free_exception,superv.async.throw_if_exception], null);
});
goog.exportSymbol('superv.async.superv_init', superv.async.superv_init);
superv.async.superv_init.call(null);
superv.async.supervisor_QMARK_ = (function superv$async$supervisor_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.superv$async$PSupervisor$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,superv.async.PSupervisor,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,superv.async.PSupervisor,x);
}
});
superv.async.check_supervisor = (function superv$async$check_supervisor(x){
if(superv.async.supervisor_QMARK_.call(null,x)){
return null;
} else {
throw cljs.core.ex_info.call(null,"First argument is not a supervisor.",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"argument","argument",1183001841),x], null));
}
});
/**
 * Here until http://dev.clojure.org/jira/browse/ASYNC-74 is resolved.
 */
superv.async.chan_QMARK_ = (function superv$async$chan_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$ReadPort$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.ReadPort,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.ReadPort,x);
}
});
superv.async.finally_exp_QMARK_ = (function superv$async$finally_exp_QMARK_(exp){
return (!(((cljs.core.seq_QMARK_.call(null,exp)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,exp),new cljs.core.Symbol(null,"finally","finally",-1065347064,null))))));
});
var ret__5781__auto___28066 = (function (){
/**
 * Asynchronously executes the body in a go block. You can provide catch and
 *   finally clauses to the nested try statement. Returns a channel which will
 *   receive the result of the body when completed or the exception if an exception
 *   is thrown. You are responsible to take this exception and deal with it! This
 *   means you need to take the result from the channel at some point or the
 *   supervisor will take care of the error.
 */
superv.async.go_try = (function superv$async$go_try(var_args){
var args__5732__auto__ = [];
var len__5726__auto___28067 = arguments.length;
var i__5727__auto___28068 = (0);
while(true){
if((i__5727__auto___28068 < len__5726__auto___28067)){
args__5732__auto__.push((arguments[i__5727__auto___28068]));

var G__28069 = (i__5727__auto___28068 + (1));
i__5727__auto___28068 = G__28069;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((3) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((3)),(0),null)):null);
return superv.async.go_try.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5733__auto__);
});

(superv.async.go_try.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,S,exps){
var body = cljs.core.take_while.call(null,superv.async.finally_exp_QMARK_,exps);
var finally$ = cljs.core.drop_while.call(null,superv.async.finally_exp_QMARK_,exps);
var _ = (((cljs.core.count.call(null,finally$) > (1)))?(function(){throw cljs.core.ex_info.call(null,"More than one finally clause provided.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"body","body",-2049205669),exps,new cljs.core.Keyword(null,"finally-clauses","finally-clauses",-596172727),finally$], null))})():null);
var finally$__$1 = cljs.core.rest.call(null,cljs.core.first.call(null,finally$));
var e = (cljs.core.truth_(new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(_AMPERSAND_env))?new cljs.core.Symbol("js","Error","js/Error",-1692659266,null):new cljs.core.Symbol("superv.async","Exception","superv.async/Exception",-1987302539,null));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"c__28059__auto__","c__28059__auto__",2122997208,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("superv.async","check-supervisor","superv.async/check-supervisor",-1941277037,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol("superv.async","S","superv.async/S",-2038996566,null),null,(1),null))))),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"id__28060__auto__","id__28060__auto__",345022623,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("superv.async","-register-go","superv.async/-register-go",-1603980432,null),null,(1),null)),(new cljs.core.List(null,S,null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"quote","quote",1377916282,null),null,(1),null)),(new cljs.core.List(null,exps,null,(1),null))))),null,(1),null))))),null,(1),null)))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("superv.async","go","superv.async/go",544852673,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"try","try",-1273693247,null),null,(1),null)),body,(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"catch","catch",-1616370245,null),null,(1),null)),(new cljs.core.List(null,e,null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"e__28061__auto__","e__28061__auto__",-51785729,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","when-not","cljs.core/when-not",-556141047,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","=","cljs.core/=",-1891498332,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Keyword(null,"type","type",1174270348),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","ex-data","cljs.core/ex-data",-1491231397,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"e__28061__auto__","e__28061__auto__",-51785729,null),null,(1),null))))),null,(1),null))))),null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword(null,"aborted","aborted",1775972619),null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("superv.async","-track-exception","superv.async/-track-exception",2061944342,null),null,(1),null)),(new cljs.core.List(null,S,null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"e__28061__auto__","e__28061__auto__",-51785729,null),null,(1),null))))),null,(1),null))))),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"e__28061__auto__","e__28061__auto__",-51785729,null),null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"finally","finally",-1065347064,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("superv.async","-unregister-go","superv.async/-unregister-go",-280234622,null),null,(1),null)),(new cljs.core.List(null,S,null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"id__28060__auto__","id__28060__auto__",345022623,null),null,(1),null))))),null,(1),null)),finally$__$1))),null,(1),null))))),null,(1),null))))),null,(1),null)))));
}));

(superv.async.go_try.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(superv.async.go_try.cljs$lang$applyTo = (function (seq28062){
var G__28063 = cljs.core.first.call(null,seq28062);
var seq28062__$1 = cljs.core.next.call(null,seq28062);
var G__28064 = cljs.core.first.call(null,seq28062__$1);
var seq28062__$2 = cljs.core.next.call(null,seq28062__$1);
var G__28065 = cljs.core.first.call(null,seq28062__$2);
var seq28062__$3 = cljs.core.next.call(null,seq28062__$2);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28063,G__28064,G__28065,seq28062__$3);
}));

return null;
})()
;
(superv.async.go_try.cljs$lang$macro = true);

var ret__5781__auto___28075 = (function (){
/**
 * Loop binding for go-try.
 */
superv.async.go_loop_try = (function superv$async$go_loop_try(var_args){
var args__5732__auto__ = [];
var len__5726__auto___28076 = arguments.length;
var i__5727__auto___28077 = (0);
while(true){
if((i__5727__auto___28077 < len__5726__auto___28076)){
args__5732__auto__.push((arguments[i__5727__auto___28077]));

var G__28078 = (i__5727__auto___28077 + (1));
i__5727__auto___28077 = G__28078;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((4) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((4)),(0),null)):null);
return superv.async.go_loop_try.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5733__auto__);
});

(superv.async.go_loop_try.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,S,bindings,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("superv.async","go-try","superv.async/go-try",218378086,null),null,(1),null)),(new cljs.core.List(null,S,null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","loop","cljs.core/loop",-1829423021,null),null,(1),null)),(new cljs.core.List(null,bindings,null,(1),null)),body))),null,(1),null)))));
}));

(superv.async.go_loop_try.cljs$lang$maxFixedArity = (4));

/** @this {Function} */
(superv.async.go_loop_try.cljs$lang$applyTo = (function (seq28070){
var G__28071 = cljs.core.first.call(null,seq28070);
var seq28070__$1 = cljs.core.next.call(null,seq28070);
var G__28072 = cljs.core.first.call(null,seq28070__$1);
var seq28070__$2 = cljs.core.next.call(null,seq28070__$1);
var G__28073 = cljs.core.first.call(null,seq28070__$2);
var seq28070__$3 = cljs.core.next.call(null,seq28070__$2);
var G__28074 = cljs.core.first.call(null,seq28070__$3);
var seq28070__$4 = cljs.core.next.call(null,seq28070__$3);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28071,G__28072,G__28073,G__28074,seq28070__$4);
}));

return null;
})()
;
(superv.async.go_loop_try.cljs$lang$macro = true);

var ret__5781__auto___28085 = /**
 * Same as core.async <! but throws an exception if the channel returns a
 * throwable object or the context has been aborted.
 */
superv.async._LT__QMARK_ = (function superv$async$_LT__QMARK_(_AMPERSAND_form,_AMPERSAND_env,S,ch){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("superv.async","throw-if-exception","superv.async/throw-if-exception",-1629409238,null),null,(1),null)),(new cljs.core.List(null,S,null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"abort__28082__auto__","abort__28082__auto__",260003859,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("superv.async","-abort","superv.async/-abort",-365058004,null),null,(1),null)),(new cljs.core.List(null,S,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"val__28083__auto__","val__28083__auto__",-2087453600,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"port__28084__auto__","port__28084__auto__",288428453,null),null,(1),null)))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core.async","alts!","cljs.core.async/alts!",1340091011,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"abort__28082__auto__","abort__28082__auto__",260003859,null),null,(1),null)),(new cljs.core.List(null,ch,null,(1),null)))))),null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword(null,"priority","priority",1431093715),null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword(null,"true","true",-1114210334),null,(1),null))))),null,(1),null)))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","=","cljs.core/=",-1891498332,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"port__28084__auto__","port__28084__auto__",288428453,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"abort__28082__auto__","abort__28082__auto__",260003859,null),null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","ex-info","cljs.core/ex-info",-409744395,null),null,(1),null)),(new cljs.core.List(null,"Aborted operations",null,(1),null)),(new cljs.core.List(null,cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Keyword(null,"type","type",1174270348),null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword(null,"aborted","aborted",1775972619),null,(1),null)))))),null,(1),null))))),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"val__28083__auto__","val__28083__auto__",-2087453600,null),null,(1),null))))),null,(1),null))))),null,(1),null)))));
});
(superv.async._LT__QMARK_.cljs$lang$macro = true);

/**
 * Same as core.async/take!, but tracks exceptions in supervisor. TODO
 * deal with abortion.
 */
superv.async.take_QMARK_ = (function superv$async$take_QMARK_(var_args){
var G__28091 = arguments.length;
switch (G__28091) {
case 3:
return superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (S,port,fn1){
return superv.async.take_QMARK_.call(null,S,port,fn1,true);
}));

(superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$4 = (function (S,port,fn1,on_caller_QMARK_){
return cljs.core.async.take_BANG_.call(null,port,(function (v){
if((v instanceof Error)){
superv.async._free_exception.call(null,S,v);
} else {
}

return fn1.call(null,v);
}),on_caller_QMARK_);
}));

(superv.async.take_QMARK_.cljs$lang$maxFixedArity = 4);

/**
 * Same as core.async/put!, but tracks exceptions in supervisor. TODO
 * deal with abortion.
 */
superv.async.put_QMARK_ = (function superv$async$put_QMARK_(var_args){
var G__28094 = arguments.length;
switch (G__28094) {
case 3:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (S,port,val){
return superv.async.put_QMARK_.call(null,S,port,val,(function superv$async$noop(_){
return null;
}));
}));

(superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$4 = (function (S,port,val,fn1){
return superv.async.put_QMARK_.call(null,S,port,val,fn1,true);
}));

(superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$5 = (function (S,port,val,fn1,on_caller_QMARK_){
return cljs.core.async.put_BANG_.call(null,port,val,(function (ret){
if((((val instanceof Error)) && ((!(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data.call(null,val)),new cljs.core.Keyword(null,"aborted","aborted",1775972619))))))){
superv.async._track_exception.call(null,S,val);
} else {
}

return fn1.call(null,ret);
}),on_caller_QMARK_);
}));

(superv.async.put_QMARK_.cljs$lang$maxFixedArity = 5);

/**
 * Reduces over a sequence s with a go function go-f or a normal function f
 *   given the initial value init.
 */
superv.async.reduce_LT_ = (function superv$async$reduce_LT_(S,maybe_go_f,init,s){
var c__14578__auto__ = superv.async.check_supervisor.call(null,superv.async.S);
var id__14579__auto__ = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"loop","loop",1244978678,null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"acc","acc",-1815869457,null),new cljs.core.Symbol(null,"init","init",-234949907,null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"r","r",1169147337,null)], null),new cljs.core.Symbol(null,"s","s",-948495851,null)], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),new cljs.core.Symbol(null,"f","f",43394975,null),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"maybe-ch","maybe-ch",-1346627156,null),cljs.core.list(new cljs.core.Symbol(null,"maybe-go-f","maybe-go-f",-1545142082,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null),new cljs.core.Symbol(null,"f","f",43394975,null))], null),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"chan?","chan?",1219428,null),new cljs.core.Symbol(null,"maybe-ch","maybe-ch",-1346627156,null)),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"maybe-ch","maybe-ch",-1346627156,null)),new cljs.core.Symbol(null,"maybe-ch","maybe-ch",-1346627156,null)),new cljs.core.Symbol(null,"r","r",1169147337,null))),new cljs.core.Symbol(null,"acc","acc",-1815869457,null)))));
var c__21592__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = (function (state_28186){
var state_val_28187 = (state_28186[(1)]);
if((state_val_28187 === (7))){
var inst_28112 = (state_28186[(7)]);
var inst_28118 = superv.async._track_exception.call(null,S,inst_28112);
var state_28186__$1 = state_28186;
var statearr_28188_28232 = state_28186__$1;
(statearr_28188_28232[(2)] = inst_28118);

(statearr_28188_28232[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28187 === (20))){
var inst_28161 = (state_28186[(8)]);
var state_28186__$1 = state_28186;
var statearr_28189_28233 = state_28186__$1;
(statearr_28189_28233[(2)] = inst_28161);

(statearr_28189_28233[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28187 === (1))){
var state_28186__$1 = state_28186;
var statearr_28190_28234 = state_28186__$1;
(statearr_28190_28234[(2)] = null);

(statearr_28190_28234[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28187 === (4))){
var _ = (function (){var statearr_28191 = state_28186;
(statearr_28191[(4)] = cljs.core.rest.call(null,(state_28186[(4)])));

return statearr_28191;
})();
var inst_28108 = (state_28186[(2)]);
var inst_28109 = superv.async._unregister_go.call(null,S,id__14579__auto__);
var ___$1 = (function (){var temp__5804__auto__ = (state_28186[(5)]);
if(cljs.core.truth_(temp__5804__auto__)){
var e__20700__auto__ = temp__5804__auto__;
throw e__20700__auto__;
} else {
return null;
}
})();
var state_28186__$1 = (function (){var statearr_28192 = state_28186;
(statearr_28192[(9)] = inst_28109);

return statearr_28192;
})();
var statearr_28193_28235 = state_28186__$1;
(statearr_28193_28235[(2)] = inst_28108);

(statearr_28193_28235[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28187 === (15))){
var inst_28155 = (state_28186[(10)]);
var inst_28149 = (state_28186[(11)]);
var inst_28155__$1 = superv.async._abort.call(null,S);
var inst_28156 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28157 = [inst_28155__$1,inst_28149];
var inst_28158 = (new cljs.core.PersistentVector(null,2,(5),inst_28156,inst_28157,null));
var state_28186__$1 = (function (){var statearr_28194 = state_28186;
(statearr_28194[(10)] = inst_28155__$1);

return statearr_28194;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_28186__$1,(18),inst_28158,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_28187 === (21))){
var inst_28171 = (state_28186[(2)]);
var inst_28172 = superv.async.throw_if_exception.call(null,S,inst_28171);
var state_28186__$1 = state_28186;
var statearr_28195_28236 = state_28186__$1;
(statearr_28195_28236[(2)] = inst_28172);

(statearr_28195_28236[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28187 === (13))){
var inst_28139 = (state_28186[(12)]);
var state_28186__$1 = state_28186;
var statearr_28196_28237 = state_28186__$1;
(statearr_28196_28237[(2)] = inst_28139);

(statearr_28196_28237[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28187 === (6))){
var state_28186__$1 = state_28186;
var statearr_28197_28238 = state_28186__$1;
(statearr_28197_28238[(2)] = null);

(statearr_28197_28238[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28187 === (17))){
var inst_28147 = (state_28186[(13)]);
var inst_28175 = (state_28186[(2)]);
var inst_28139 = inst_28175;
var inst_28140 = inst_28147;
var state_28186__$1 = (function (){var statearr_28198 = state_28186;
(statearr_28198[(12)] = inst_28139);

(statearr_28198[(14)] = inst_28140);

return statearr_28198;
})();
var statearr_28199_28239 = state_28186__$1;
(statearr_28199_28239[(2)] = null);

(statearr_28199_28239[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28187 === (3))){
var inst_28184 = (state_28186[(2)]);
var state_28186__$1 = state_28186;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28186__$1,inst_28184);
} else {
if((state_val_28187 === (12))){
var inst_28139 = (state_28186[(12)]);
var inst_28146 = (state_28186[(15)]);
var inst_28149 = (state_28186[(11)]);
var inst_28149__$1 = maybe_go_f.call(null,S,inst_28139,inst_28146);
var inst_28150 = superv.async.chan_QMARK_.call(null,inst_28149__$1);
var state_28186__$1 = (function (){var statearr_28200 = state_28186;
(statearr_28200[(11)] = inst_28149__$1);

return statearr_28200;
})();
if(inst_28150){
var statearr_28201_28240 = state_28186__$1;
(statearr_28201_28240[(1)] = (15));

} else {
var statearr_28202_28241 = state_28186__$1;
(statearr_28202_28241[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28187 === (2))){
var _ = (function (){var statearr_28203 = state_28186;
(statearr_28203[(4)] = cljs.core.cons.call(null,(4),(state_28186[(4)])));

return statearr_28203;
})();
var ___$1 = (function (){var statearr_28204 = state_28186;
(statearr_28204[(4)] = cljs.core.cons.call(null,(9),(state_28186[(4)])));

return statearr_28204;
})();
var inst_28134 = init;
var inst_28135 = s;
var inst_28136 = cljs.core.seq.call(null,inst_28135);
var inst_28137 = cljs.core.first.call(null,inst_28136);
var inst_28138 = cljs.core.next.call(null,inst_28136);
var inst_28139 = inst_28134;
var inst_28140 = inst_28135;
var state_28186__$1 = (function (){var statearr_28205 = state_28186;
(statearr_28205[(16)] = inst_28137);

(statearr_28205[(17)] = inst_28138);

(statearr_28205[(12)] = inst_28139);

(statearr_28205[(14)] = inst_28140);

return statearr_28205;
})();
var statearr_28206_28242 = state_28186__$1;
(statearr_28206_28242[(2)] = null);

(statearr_28206_28242[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28187 === (19))){
var inst_28165 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_28166 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_28167 = cljs.core.PersistentHashMap.fromArrays(inst_28165,inst_28166);
var inst_28168 = cljs.core.ex_info.call(null,"Aborted operations",inst_28167);
var state_28186__$1 = state_28186;
var statearr_28208_28243 = state_28186__$1;
(statearr_28208_28243[(2)] = inst_28168);

(statearr_28208_28243[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28187 === (11))){
var inst_28181 = (state_28186[(2)]);
var _ = (function (){var statearr_28209 = state_28186;
(statearr_28209[(4)] = cljs.core.rest.call(null,(state_28186[(4)])));

return statearr_28209;
})();
var state_28186__$1 = state_28186;
var statearr_28210_28244 = state_28186__$1;
(statearr_28210_28244[(2)] = inst_28181);

(statearr_28210_28244[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28187 === (9))){
var _ = (function (){var statearr_28211 = state_28186;
(statearr_28211[(4)] = cljs.core.rest.call(null,(state_28186[(4)])));

return statearr_28211;
})();
var state_28186__$1 = state_28186;
var ex28207 = (state_28186__$1[(2)]);
var statearr_28212_28245 = state_28186__$1;
(statearr_28212_28245[(5)] = ex28207);


if((ex28207 instanceof Error)){
var statearr_28213_28246 = state_28186__$1;
(statearr_28213_28246[(1)] = (5));

(statearr_28213_28246[(5)] = null);

} else {
throw ex28207;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28187 === (5))){
var inst_28112 = (state_28186[(7)]);
var inst_28112__$1 = (state_28186[(2)]);
var inst_28113 = cljs.core.ex_data.call(null,inst_28112__$1);
var inst_28114 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_28113);
var inst_28115 = cljs.core._EQ_.call(null,inst_28114,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_28186__$1 = (function (){var statearr_28214 = state_28186;
(statearr_28214[(7)] = inst_28112__$1);

return statearr_28214;
})();
if(inst_28115){
var statearr_28215_28247 = state_28186__$1;
(statearr_28215_28247[(1)] = (6));

} else {
var statearr_28216_28248 = state_28186__$1;
(statearr_28216_28248[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28187 === (14))){
var inst_28179 = (state_28186[(2)]);
var state_28186__$1 = state_28186;
var statearr_28217_28249 = state_28186__$1;
(statearr_28217_28249[(2)] = inst_28179);

(statearr_28217_28249[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28187 === (16))){
var inst_28149 = (state_28186[(11)]);
var state_28186__$1 = state_28186;
var statearr_28218_28250 = state_28186__$1;
(statearr_28218_28250[(2)] = inst_28149);

(statearr_28218_28250[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28187 === (10))){
var inst_28140 = (state_28186[(14)]);
var inst_28146 = (state_28186[(15)]);
var inst_28145 = cljs.core.seq.call(null,inst_28140);
var inst_28146__$1 = cljs.core.first.call(null,inst_28145);
var inst_28147 = cljs.core.next.call(null,inst_28145);
var state_28186__$1 = (function (){var statearr_28219 = state_28186;
(statearr_28219[(15)] = inst_28146__$1);

(statearr_28219[(13)] = inst_28147);

return statearr_28219;
})();
if(cljs.core.truth_(inst_28146__$1)){
var statearr_28220_28251 = state_28186__$1;
(statearr_28220_28251[(1)] = (12));

} else {
var statearr_28221_28252 = state_28186__$1;
(statearr_28221_28252[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28187 === (18))){
var inst_28155 = (state_28186[(10)]);
var inst_28160 = (state_28186[(2)]);
var inst_28161 = cljs.core.nth.call(null,inst_28160,(0),null);
var inst_28162 = cljs.core.nth.call(null,inst_28160,(1),null);
var inst_28163 = cljs.core._EQ_.call(null,inst_28162,inst_28155);
var state_28186__$1 = (function (){var statearr_28222 = state_28186;
(statearr_28222[(8)] = inst_28161);

return statearr_28222;
})();
if(inst_28163){
var statearr_28223_28253 = state_28186__$1;
(statearr_28223_28253[(1)] = (19));

} else {
var statearr_28224_28254 = state_28186__$1;
(statearr_28224_28254[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28187 === (8))){
var inst_28112 = (state_28186[(7)]);
var inst_28120 = (state_28186[(2)]);
var state_28186__$1 = (function (){var statearr_28225 = state_28186;
(statearr_28225[(18)] = inst_28120);

return statearr_28225;
})();
var statearr_28226_28255 = state_28186__$1;
(statearr_28226_28255[(2)] = inst_28112);

(statearr_28226_28255[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var superv$async$reduce_LT__$_state_machine__21468__auto__ = null;
var superv$async$reduce_LT__$_state_machine__21468__auto____0 = (function (){
var statearr_28227 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28227[(0)] = superv$async$reduce_LT__$_state_machine__21468__auto__);

(statearr_28227[(1)] = (1));

return statearr_28227;
});
var superv$async$reduce_LT__$_state_machine__21468__auto____1 = (function (state_28186){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_28186);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e28228){var ex__21471__auto__ = e28228;
var statearr_28229_28256 = state_28186;
(statearr_28229_28256[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_28186[(4)]))){
var statearr_28230_28257 = state_28186;
(statearr_28230_28257[(1)] = cljs.core.first.call(null,(state_28186[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28258 = state_28186;
state_28186 = G__28258;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
superv$async$reduce_LT__$_state_machine__21468__auto__ = function(state_28186){
switch(arguments.length){
case 0:
return superv$async$reduce_LT__$_state_machine__21468__auto____0.call(this);
case 1:
return superv$async$reduce_LT__$_state_machine__21468__auto____1.call(this,state_28186);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$reduce_LT__$_state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$reduce_LT__$_state_machine__21468__auto____0;
superv$async$reduce_LT__$_state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$reduce_LT__$_state_machine__21468__auto____1;
return superv$async$reduce_LT__$_state_machine__21468__auto__;
})()
})();
var state__21594__auto__ = (function (){var statearr_28231 = f__21593__auto__.call(null);
(statearr_28231[(6)] = c__21592__auto__);

return statearr_28231;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
}));

return c__21592__auto__;
});
/**
 * Reduces over a sequence s with a go function go-f or a normal function f
 *   given the initial value init.
 */
superv.async.reduce_LT__QMARK__ = (function superv$async$reduce_LT__QMARK__(maybe_go_f,init,s){
var c__21592__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = (function (state_28311){
var state_val_28312 = (state_28311[(1)]);
if((state_val_28312 === (7))){
var inst_28283 = (state_28311[(7)]);
var inst_28289 = (state_28311[(8)]);
var inst_28288 = cljs.core.seq.call(null,inst_28283);
var inst_28289__$1 = cljs.core.first.call(null,inst_28288);
var inst_28290 = cljs.core.next.call(null,inst_28288);
var state_28311__$1 = (function (){var statearr_28313 = state_28311;
(statearr_28313[(8)] = inst_28289__$1);

(statearr_28313[(9)] = inst_28290);

return statearr_28313;
})();
if(cljs.core.truth_(inst_28289__$1)){
var statearr_28314_28344 = state_28311__$1;
(statearr_28314_28344[(1)] = (9));

} else {
var statearr_28315_28345 = state_28311__$1;
(statearr_28315_28345[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28312 === (1))){
var state_28311__$1 = state_28311;
var statearr_28316_28346 = state_28311__$1;
(statearr_28316_28346[(2)] = null);

(statearr_28316_28346[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28312 === (4))){
var _ = (function (){var statearr_28317 = state_28311;
(statearr_28317[(4)] = cljs.core.rest.call(null,(state_28311[(4)])));

return statearr_28317;
})();
var inst_28260 = (state_28311[(2)]);
var ___$1 = (function (){var temp__5804__auto__ = (state_28311[(5)]);
if(cljs.core.truth_(temp__5804__auto__)){
var e__20700__auto__ = temp__5804__auto__;
throw e__20700__auto__;
} else {
return null;
}
})();
var state_28311__$1 = state_28311;
var statearr_28318_28347 = state_28311__$1;
(statearr_28318_28347[(2)] = inst_28260);

(statearr_28318_28347[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28312 === (15))){
var inst_28296 = (state_28311[(2)]);
var inst_28297 = superv.async.throw_if_exception_.call(null,inst_28296);
var state_28311__$1 = state_28311;
var statearr_28320_28348 = state_28311__$1;
(statearr_28320_28348[(2)] = inst_28297);

(statearr_28320_28348[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28312 === (13))){
var inst_28292 = (state_28311[(10)]);
var state_28311__$1 = state_28311;
var statearr_28321_28349 = state_28311__$1;
(statearr_28321_28349[(2)] = inst_28292);

(statearr_28321_28349[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28312 === (6))){
var _ = (function (){var statearr_28322 = state_28311;
(statearr_28322[(4)] = cljs.core.rest.call(null,(state_28311[(4)])));

return statearr_28322;
})();
var state_28311__$1 = state_28311;
var ex28319 = (state_28311__$1[(2)]);
var statearr_28323_28350 = state_28311__$1;
(statearr_28323_28350[(5)] = ex28319);


if((ex28319 instanceof Error)){
var statearr_28324_28351 = state_28311__$1;
(statearr_28324_28351[(1)] = (5));

(statearr_28324_28351[(5)] = null);

} else {
throw ex28319;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28312 === (3))){
var inst_28309 = (state_28311[(2)]);
var state_28311__$1 = state_28311;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28311__$1,inst_28309);
} else {
if((state_val_28312 === (12))){
var inst_28292 = (state_28311[(10)]);
var state_28311__$1 = state_28311;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28311__$1,(15),inst_28292);
} else {
if((state_val_28312 === (2))){
var _ = (function (){var statearr_28325 = state_28311;
(statearr_28325[(4)] = cljs.core.cons.call(null,(4),(state_28311[(4)])));

return statearr_28325;
})();
var ___$1 = (function (){var statearr_28326 = state_28311;
(statearr_28326[(4)] = cljs.core.cons.call(null,(6),(state_28311[(4)])));

return statearr_28326;
})();
var inst_28277 = init;
var inst_28278 = s;
var inst_28279 = cljs.core.seq.call(null,inst_28278);
var inst_28280 = cljs.core.first.call(null,inst_28279);
var inst_28281 = cljs.core.next.call(null,inst_28279);
var inst_28282 = inst_28277;
var inst_28283 = inst_28278;
var state_28311__$1 = (function (){var statearr_28327 = state_28311;
(statearr_28327[(11)] = inst_28280);

(statearr_28327[(12)] = inst_28281);

(statearr_28327[(13)] = inst_28282);

(statearr_28327[(7)] = inst_28283);

return statearr_28327;
})();
var statearr_28328_28352 = state_28311__$1;
(statearr_28328_28352[(2)] = null);

(statearr_28328_28352[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28312 === (11))){
var inst_28304 = (state_28311[(2)]);
var state_28311__$1 = state_28311;
var statearr_28329_28353 = state_28311__$1;
(statearr_28329_28353[(2)] = inst_28304);

(statearr_28329_28353[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28312 === (9))){
var inst_28282 = (state_28311[(13)]);
var inst_28289 = (state_28311[(8)]);
var inst_28292 = (state_28311[(10)]);
var inst_28292__$1 = maybe_go_f.call(null,inst_28282,inst_28289);
var inst_28293 = superv.async.chan_QMARK_.call(null,inst_28292__$1);
var state_28311__$1 = (function (){var statearr_28330 = state_28311;
(statearr_28330[(10)] = inst_28292__$1);

return statearr_28330;
})();
if(inst_28293){
var statearr_28331_28354 = state_28311__$1;
(statearr_28331_28354[(1)] = (12));

} else {
var statearr_28332_28355 = state_28311__$1;
(statearr_28332_28355[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28312 === (5))){
var inst_28263 = (state_28311[(2)]);
var state_28311__$1 = state_28311;
var statearr_28333_28356 = state_28311__$1;
(statearr_28333_28356[(2)] = inst_28263);

(statearr_28333_28356[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28312 === (14))){
var inst_28290 = (state_28311[(9)]);
var inst_28300 = (state_28311[(2)]);
var inst_28282 = inst_28300;
var inst_28283 = inst_28290;
var state_28311__$1 = (function (){var statearr_28334 = state_28311;
(statearr_28334[(13)] = inst_28282);

(statearr_28334[(7)] = inst_28283);

return statearr_28334;
})();
var statearr_28335_28357 = state_28311__$1;
(statearr_28335_28357[(2)] = null);

(statearr_28335_28357[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28312 === (10))){
var inst_28282 = (state_28311[(13)]);
var state_28311__$1 = state_28311;
var statearr_28336_28358 = state_28311__$1;
(statearr_28336_28358[(2)] = inst_28282);

(statearr_28336_28358[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28312 === (8))){
var inst_28306 = (state_28311[(2)]);
var _ = (function (){var statearr_28337 = state_28311;
(statearr_28337[(4)] = cljs.core.rest.call(null,(state_28311[(4)])));

return statearr_28337;
})();
var state_28311__$1 = state_28311;
var statearr_28338_28359 = state_28311__$1;
(statearr_28338_28359[(2)] = inst_28306);

(statearr_28338_28359[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var superv$async$reduce_LT__QMARK___$_state_machine__21468__auto__ = null;
var superv$async$reduce_LT__QMARK___$_state_machine__21468__auto____0 = (function (){
var statearr_28339 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28339[(0)] = superv$async$reduce_LT__QMARK___$_state_machine__21468__auto__);

(statearr_28339[(1)] = (1));

return statearr_28339;
});
var superv$async$reduce_LT__QMARK___$_state_machine__21468__auto____1 = (function (state_28311){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_28311);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e28340){var ex__21471__auto__ = e28340;
var statearr_28341_28360 = state_28311;
(statearr_28341_28360[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_28311[(4)]))){
var statearr_28342_28361 = state_28311;
(statearr_28342_28361[(1)] = cljs.core.first.call(null,(state_28311[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28362 = state_28311;
state_28311 = G__28362;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
superv$async$reduce_LT__QMARK___$_state_machine__21468__auto__ = function(state_28311){
switch(arguments.length){
case 0:
return superv$async$reduce_LT__QMARK___$_state_machine__21468__auto____0.call(this);
case 1:
return superv$async$reduce_LT__QMARK___$_state_machine__21468__auto____1.call(this,state_28311);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$reduce_LT__QMARK___$_state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$reduce_LT__QMARK___$_state_machine__21468__auto____0;
superv$async$reduce_LT__QMARK___$_state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$reduce_LT__QMARK___$_state_machine__21468__auto____1;
return superv$async$reduce_LT__QMARK___$_state_machine__21468__auto__;
})()
})();
var state__21594__auto__ = (function (){var statearr_28343 = f__21593__auto__.call(null);
(statearr_28343[(6)] = c__21592__auto__);

return statearr_28343;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
}));

return c__21592__auto__;
});
/**
 * Takes objects from in-ch, asynchrously applies function f> (function should
 *   return a channel), takes the result from the returned channel and if it's
 *   truthy, puts it in the out-ch. Returns the closed out-ch. Closes the
 *   returned channel when the input channel has been completely consumed and all
 *   objects have been processed.
 *   If out-ch is not provided, an unbuffered one will be used.
 */
superv.async.pmap_GT__GT_ = (function superv$async$pmap_GT__GT_(var_args){
var G__28364 = arguments.length;
switch (G__28364) {
case 4:
return superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$4 = (function (S,f_GT_,parallelism,in_ch){
return superv.async.pmap_GT__GT_.call(null,S,f_GT_,parallelism,cljs.core.async.chan.call(null),in_ch);
}));

(superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$5 = (function (S,f_GT_,parallelism,out_ch,in_ch){
if(cljs.core.fn_QMARK_.call(null,f_GT_)){
} else {
throw (new Error("Assert failed: (fn? f>)"));
}

if(((cljs.core.integer_QMARK_.call(null,parallelism)) && ((parallelism > (0))))){
} else {
throw (new Error("Assert failed: (and (integer? parallelism) (pos? parallelism))"));
}

var threads = cljs.core.atom.call(null,parallelism);
var n__5593__auto___28579 = parallelism;
var __28580 = (0);
while(true){
if((__28580 < n__5593__auto___28579)){
var c__14578__auto___28581 = superv.async.check_supervisor.call(null,superv.async.S);
var id__14579__auto___28582 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"loop","loop",1244978678,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol(null,"when-let","when-let",-1383043480,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"obj","obj",-1672671807,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"in-ch","in-ch",-1757981794,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,"when-let","when-let",-1383043480,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"result","result",-1239343558,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),cljs.core.list(new cljs.core.Symbol(null,"f>","f>",-1169871571,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)))], null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"result","result",-1239343558,null))),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null)))))),cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"zero?","zero?",325758897,null),cljs.core.list(new cljs.core.Symbol(null,"swap!","swap!",-655677516,null),new cljs.core.Symbol(null,"threads","threads",-77267207,null),new cljs.core.Symbol(null,"dec","dec",-766002333,null))),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null)))));
var c__21592__auto___28583 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__28580,c__21592__auto___28583,c__14578__auto___28581,id__14579__auto___28582,n__5593__auto___28579,threads){
return (function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = ((function (__28580,c__21592__auto___28583,c__14578__auto___28581,id__14579__auto___28582,n__5593__auto___28579,threads){
return (function (state_28505){
var state_val_28506 = (state_28505[(1)]);
if((state_val_28506 === (7))){
var inst_28370 = (state_28505[(7)]);
var inst_28376 = superv.async._track_exception.call(null,S,inst_28370);
var state_28505__$1 = state_28505;
var statearr_28507_28584 = state_28505__$1;
(statearr_28507_28584[(2)] = inst_28376);

(statearr_28507_28584[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28506 === (20))){
var inst_28406 = (state_28505[(8)]);
var inst_28439 = (state_28505[(9)]);
var inst_28439__$1 = superv.async._abort.call(null,S);
var inst_28440 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28441 = f_GT_.call(null,inst_28406);
var inst_28442 = [inst_28439__$1,inst_28441];
var inst_28443 = (new cljs.core.PersistentVector(null,2,(5),inst_28440,inst_28442,null));
var state_28505__$1 = (function (){var statearr_28508 = state_28505;
(statearr_28508[(9)] = inst_28439__$1);

return statearr_28508;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_28505__$1,(27),inst_28443,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_28506 === (27))){
var inst_28439 = (state_28505[(9)]);
var inst_28445 = (state_28505[(2)]);
var inst_28446 = cljs.core.nth.call(null,inst_28445,(0),null);
var inst_28447 = cljs.core.nth.call(null,inst_28445,(1),null);
var inst_28448 = cljs.core._EQ_.call(null,inst_28447,inst_28439);
var state_28505__$1 = (function (){var statearr_28509 = state_28505;
(statearr_28509[(10)] = inst_28446);

return statearr_28509;
})();
if(inst_28448){
var statearr_28510_28585 = state_28505__$1;
(statearr_28510_28585[(1)] = (28));

} else {
var statearr_28511_28586 = state_28505__$1;
(statearr_28511_28586[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28506 === (1))){
var state_28505__$1 = state_28505;
var statearr_28512_28587 = state_28505__$1;
(statearr_28512_28587[(2)] = null);

(statearr_28512_28587[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28506 === (24))){
var inst_28406 = (state_28505[(8)]);
var state_28505__$1 = state_28505;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28505__$1,(26),out_ch,inst_28406);
} else {
if((state_val_28506 === (39))){
var inst_28497 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_28505__$1 = state_28505;
var statearr_28513_28588 = state_28505__$1;
(statearr_28513_28588[(2)] = inst_28497);

(statearr_28513_28588[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28506 === (4))){
var ___$1 = (function (){var statearr_28514 = state_28505;
(statearr_28514[(4)] = cljs.core.rest.call(null,(state_28505[(4)])));

return statearr_28514;
})();
var inst_28366 = (state_28505[(2)]);
var inst_28367 = superv.async._unregister_go.call(null,S,id__14579__auto___28582);
var ___$2 = (function (){var temp__5804__auto__ = (state_28505[(5)]);
if(cljs.core.truth_(temp__5804__auto__)){
var e__20700__auto__ = temp__5804__auto__;
throw e__20700__auto__;
} else {
return null;
}
})();
var state_28505__$1 = (function (){var statearr_28515 = state_28505;
(statearr_28515[(11)] = inst_28367);

return statearr_28515;
})();
var statearr_28516_28589 = state_28505__$1;
(statearr_28516_28589[(2)] = inst_28366);

(statearr_28516_28589[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28506 === (15))){
var inst_28406 = (state_28505[(8)]);
var inst_28405 = (state_28505[(2)]);
var inst_28406__$1 = superv.async.throw_if_exception.call(null,S,inst_28405);
var state_28505__$1 = (function (){var statearr_28517 = state_28505;
(statearr_28517[(8)] = inst_28406__$1);

return statearr_28517;
})();
if(cljs.core.truth_(inst_28406__$1)){
var statearr_28518_28590 = state_28505__$1;
(statearr_28518_28590[(1)] = (16));

} else {
var statearr_28519_28591 = state_28505__$1;
(statearr_28519_28591[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28506 === (21))){
var inst_28488 = (state_28505[(2)]);
var state_28505__$1 = state_28505;
var statearr_28520_28592 = state_28505__$1;
(statearr_28520_28592[(2)] = inst_28488);

(statearr_28520_28592[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28506 === (31))){
var inst_28462 = (state_28505[(12)]);
var inst_28462__$1 = superv.async._abort.call(null,S);
var inst_28463 = cljs.core.async.timeout.call(null,(0));
var inst_28464 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28465 = [inst_28462__$1,inst_28463];
var inst_28466 = (new cljs.core.PersistentVector(null,2,(5),inst_28464,inst_28465,null));
var state_28505__$1 = (function (){var statearr_28521 = state_28505;
(statearr_28521[(12)] = inst_28462__$1);

return statearr_28521;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_28505__$1,(34),inst_28466,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_28506 === (32))){
var state_28505__$1 = state_28505;
var statearr_28522_28593 = state_28505__$1;
(statearr_28522_28593[(2)] = null);

(statearr_28522_28593[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28506 === (40))){
var state_28505__$1 = state_28505;
var statearr_28523_28594 = state_28505__$1;
(statearr_28523_28594[(2)] = null);

(statearr_28523_28594[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28506 === (33))){
var inst_28485 = (state_28505[(2)]);
var state_28505__$1 = (function (){var statearr_28524 = state_28505;
(statearr_28524[(13)] = inst_28485);

return statearr_28524;
})();
var statearr_28525_28595 = state_28505__$1;
(statearr_28525_28595[(2)] = null);

(statearr_28525_28595[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28506 === (13))){
var inst_28399 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_28400 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_28401 = cljs.core.PersistentHashMap.fromArrays(inst_28399,inst_28400);
var inst_28402 = cljs.core.ex_info.call(null,"Aborted operations",inst_28401);
var state_28505__$1 = state_28505;
var statearr_28526_28596 = state_28505__$1;
(statearr_28526_28596[(2)] = inst_28402);

(statearr_28526_28596[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28506 === (22))){
var inst_28413 = (state_28505[(14)]);
var inst_28419 = (state_28505[(2)]);
var inst_28420 = cljs.core.nth.call(null,inst_28419,(0),null);
var inst_28421 = cljs.core.nth.call(null,inst_28419,(1),null);
var inst_28422 = cljs.core._EQ_.call(null,inst_28421,inst_28413);
var state_28505__$1 = (function (){var statearr_28527 = state_28505;
(statearr_28527[(15)] = inst_28420);

return statearr_28527;
})();
if(inst_28422){
var statearr_28528_28597 = state_28505__$1;
(statearr_28528_28597[(1)] = (23));

} else {
var statearr_28529_28598 = state_28505__$1;
(statearr_28529_28598[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28506 === (36))){
var inst_28457 = (state_28505[(16)]);
var state_28505__$1 = state_28505;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28505__$1,(38),out_ch,inst_28457);
} else {
if((state_val_28506 === (41))){
var inst_28500 = (state_28505[(2)]);
var ___$1 = (function (){var statearr_28530 = state_28505;
(statearr_28530[(4)] = cljs.core.rest.call(null,(state_28505[(4)])));

return statearr_28530;
})();
var state_28505__$1 = state_28505;
var statearr_28531_28599 = state_28505__$1;
(statearr_28531_28599[(2)] = inst_28500);

(statearr_28531_28599[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28506 === (29))){
var inst_28446 = (state_28505[(10)]);
var state_28505__$1 = state_28505;
var statearr_28532_28600 = state_28505__$1;
(statearr_28532_28600[(2)] = inst_28446);

(statearr_28532_28600[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28506 === (6))){
var state_28505__$1 = state_28505;
var statearr_28533_28601 = state_28505__$1;
(statearr_28533_28601[(2)] = null);

(statearr_28533_28601[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28506 === (28))){
var inst_28450 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_28451 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_28452 = cljs.core.PersistentHashMap.fromArrays(inst_28450,inst_28451);
var inst_28453 = cljs.core.ex_info.call(null,"Aborted operations",inst_28452);
var state_28505__$1 = state_28505;
var statearr_28534_28602 = state_28505__$1;
(statearr_28534_28602[(2)] = inst_28453);

(statearr_28534_28602[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28506 === (25))){
var inst_28432 = (state_28505[(2)]);
var inst_28433 = superv.async.throw_if_exception.call(null,S,inst_28432);
var inst_28434 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_28505__$1 = (function (){var statearr_28535 = state_28505;
(statearr_28535[(17)] = inst_28433);

return statearr_28535;
})();
var statearr_28536_28603 = state_28505__$1;
(statearr_28536_28603[(2)] = inst_28434);

(statearr_28536_28603[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28506 === (34))){
var inst_28462 = (state_28505[(12)]);
var inst_28468 = (state_28505[(2)]);
var inst_28469 = cljs.core.nth.call(null,inst_28468,(0),null);
var inst_28470 = cljs.core.nth.call(null,inst_28468,(1),null);
var inst_28471 = cljs.core._EQ_.call(null,inst_28470,inst_28462);
var state_28505__$1 = (function (){var statearr_28537 = state_28505;
(statearr_28537[(18)] = inst_28469);

return statearr_28537;
})();
if(inst_28471){
var statearr_28538_28604 = state_28505__$1;
(statearr_28538_28604[(1)] = (35));

} else {
var statearr_28539_28605 = state_28505__$1;
(statearr_28539_28605[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28506 === (17))){
var state_28505__$1 = state_28505;
var statearr_28540_28606 = state_28505__$1;
(statearr_28540_28606[(2)] = null);

(statearr_28540_28606[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28506 === (3))){
var inst_28503 = (state_28505[(2)]);
var state_28505__$1 = state_28505;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28505__$1,inst_28503);
} else {
if((state_val_28506 === (12))){
var inst_28389 = (state_28505[(19)]);
var inst_28394 = (state_28505[(2)]);
var inst_28395 = cljs.core.nth.call(null,inst_28394,(0),null);
var inst_28396 = cljs.core.nth.call(null,inst_28394,(1),null);
var inst_28397 = cljs.core._EQ_.call(null,inst_28396,inst_28389);
var state_28505__$1 = (function (){var statearr_28541 = state_28505;
(statearr_28541[(20)] = inst_28395);

return statearr_28541;
})();
if(inst_28397){
var statearr_28542_28607 = state_28505__$1;
(statearr_28542_28607[(1)] = (13));

} else {
var statearr_28543_28608 = state_28505__$1;
(statearr_28543_28608[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28506 === (2))){
var ___$1 = (function (){var statearr_28544 = state_28505;
(statearr_28544[(4)] = cljs.core.cons.call(null,(4),(state_28505[(4)])));

return statearr_28544;
})();
var ___$2 = (function (){var statearr_28545 = state_28505;
(statearr_28545[(4)] = cljs.core.cons.call(null,(9),(state_28505[(4)])));

return statearr_28545;
})();
var state_28505__$1 = state_28505;
var statearr_28546_28609 = state_28505__$1;
(statearr_28546_28609[(2)] = null);

(statearr_28546_28609[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28506 === (23))){
var inst_28424 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_28425 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_28426 = cljs.core.PersistentHashMap.fromArrays(inst_28424,inst_28425);
var inst_28427 = cljs.core.ex_info.call(null,"Aborted operations",inst_28426);
var state_28505__$1 = state_28505;
var statearr_28547_28610 = state_28505__$1;
(statearr_28547_28610[(2)] = inst_28427);

(statearr_28547_28610[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28506 === (35))){
var inst_28473 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_28474 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_28475 = cljs.core.PersistentHashMap.fromArrays(inst_28473,inst_28474);
var inst_28476 = cljs.core.ex_info.call(null,"Aborted operations",inst_28475);
var state_28505__$1 = state_28505;
var statearr_28548_28611 = state_28505__$1;
(statearr_28548_28611[(2)] = inst_28476);

(statearr_28548_28611[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28506 === (19))){
var inst_28413 = (state_28505[(14)]);
var inst_28413__$1 = superv.async._abort.call(null,S);
var inst_28414 = cljs.core.async.timeout.call(null,(0));
var inst_28415 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28416 = [inst_28413__$1,inst_28414];
var inst_28417 = (new cljs.core.PersistentVector(null,2,(5),inst_28415,inst_28416,null));
var state_28505__$1 = (function (){var statearr_28550 = state_28505;
(statearr_28550[(14)] = inst_28413__$1);

return statearr_28550;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_28505__$1,(22),inst_28417,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_28506 === (11))){
var inst_28493 = (state_28505[(2)]);
var inst_28494 = cljs.core.swap_BANG_.call(null,threads,cljs.core.dec);
var inst_28495 = (inst_28494 === (0));
var state_28505__$1 = (function (){var statearr_28551 = state_28505;
(statearr_28551[(21)] = inst_28493);

return statearr_28551;
})();
if(cljs.core.truth_(inst_28495)){
var statearr_28552_28612 = state_28505__$1;
(statearr_28552_28612[(1)] = (39));

} else {
var statearr_28553_28613 = state_28505__$1;
(statearr_28553_28613[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28506 === (9))){
var ___$1 = (function (){var statearr_28554 = state_28505;
(statearr_28554[(4)] = cljs.core.rest.call(null,(state_28505[(4)])));

return statearr_28554;
})();
var state_28505__$1 = state_28505;
var ex28549 = (state_28505__$1[(2)]);
var statearr_28555_28614 = state_28505__$1;
(statearr_28555_28614[(5)] = ex28549);


if((ex28549 instanceof Error)){
var statearr_28556_28615 = state_28505__$1;
(statearr_28556_28615[(1)] = (5));

(statearr_28556_28615[(5)] = null);

} else {
throw ex28549;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28506 === (5))){
var inst_28370 = (state_28505[(7)]);
var inst_28370__$1 = (state_28505[(2)]);
var inst_28371 = cljs.core.ex_data.call(null,inst_28370__$1);
var inst_28372 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_28371);
var inst_28373 = cljs.core._EQ_.call(null,inst_28372,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_28505__$1 = (function (){var statearr_28557 = state_28505;
(statearr_28557[(7)] = inst_28370__$1);

return statearr_28557;
})();
if(inst_28373){
var statearr_28558_28616 = state_28505__$1;
(statearr_28558_28616[(1)] = (6));

} else {
var statearr_28559_28617 = state_28505__$1;
(statearr_28559_28617[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28506 === (14))){
var inst_28395 = (state_28505[(20)]);
var state_28505__$1 = state_28505;
var statearr_28560_28618 = state_28505__$1;
(statearr_28560_28618[(2)] = inst_28395);

(statearr_28560_28618[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28506 === (26))){
var inst_28430 = (state_28505[(2)]);
var state_28505__$1 = state_28505;
var statearr_28561_28619 = state_28505__$1;
(statearr_28561_28619[(2)] = inst_28430);

(statearr_28561_28619[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28506 === (16))){
var inst_28406 = (state_28505[(8)]);
var inst_28408 = (inst_28406 instanceof Error);
var state_28505__$1 = state_28505;
if(cljs.core.truth_(inst_28408)){
var statearr_28562_28620 = state_28505__$1;
(statearr_28562_28620[(1)] = (19));

} else {
var statearr_28563_28621 = state_28505__$1;
(statearr_28563_28621[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28506 === (38))){
var inst_28479 = (state_28505[(2)]);
var state_28505__$1 = state_28505;
var statearr_28564_28622 = state_28505__$1;
(statearr_28564_28622[(2)] = inst_28479);

(statearr_28564_28622[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28506 === (30))){
var inst_28457 = (state_28505[(16)]);
var inst_28456 = (state_28505[(2)]);
var inst_28457__$1 = superv.async.throw_if_exception.call(null,S,inst_28456);
var state_28505__$1 = (function (){var statearr_28565 = state_28505;
(statearr_28565[(16)] = inst_28457__$1);

return statearr_28565;
})();
if(cljs.core.truth_(inst_28457__$1)){
var statearr_28566_28623 = state_28505__$1;
(statearr_28566_28623[(1)] = (31));

} else {
var statearr_28567_28624 = state_28505__$1;
(statearr_28567_28624[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28506 === (10))){
var inst_28389 = (state_28505[(19)]);
var inst_28389__$1 = superv.async._abort.call(null,S);
var inst_28390 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28391 = [inst_28389__$1,in_ch];
var inst_28392 = (new cljs.core.PersistentVector(null,2,(5),inst_28390,inst_28391,null));
var state_28505__$1 = (function (){var statearr_28568 = state_28505;
(statearr_28568[(19)] = inst_28389__$1);

return statearr_28568;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_28505__$1,(12),inst_28392,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_28506 === (18))){
var inst_28491 = (state_28505[(2)]);
var state_28505__$1 = state_28505;
var statearr_28569_28625 = state_28505__$1;
(statearr_28569_28625[(2)] = inst_28491);

(statearr_28569_28625[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28506 === (37))){
var inst_28481 = (state_28505[(2)]);
var inst_28482 = superv.async.throw_if_exception.call(null,S,inst_28481);
var state_28505__$1 = state_28505;
var statearr_28570_28626 = state_28505__$1;
(statearr_28570_28626[(2)] = inst_28482);

(statearr_28570_28626[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28506 === (8))){
var inst_28370 = (state_28505[(7)]);
var inst_28378 = (state_28505[(2)]);
var state_28505__$1 = (function (){var statearr_28571 = state_28505;
(statearr_28571[(22)] = inst_28378);

return statearr_28571;
})();
var statearr_28572_28627 = state_28505__$1;
(statearr_28572_28627[(2)] = inst_28370);

(statearr_28572_28627[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(__28580,c__21592__auto___28583,c__14578__auto___28581,id__14579__auto___28582,n__5593__auto___28579,threads))
;
return ((function (__28580,switch__21467__auto__,c__21592__auto___28583,c__14578__auto___28581,id__14579__auto___28582,n__5593__auto___28579,threads){
return (function() {
var superv$async$state_machine__21468__auto__ = null;
var superv$async$state_machine__21468__auto____0 = (function (){
var statearr_28573 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28573[(0)] = superv$async$state_machine__21468__auto__);

(statearr_28573[(1)] = (1));

return statearr_28573;
});
var superv$async$state_machine__21468__auto____1 = (function (state_28505){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_28505);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e28574){var ex__21471__auto__ = e28574;
var statearr_28575_28628 = state_28505;
(statearr_28575_28628[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_28505[(4)]))){
var statearr_28576_28629 = state_28505;
(statearr_28576_28629[(1)] = cljs.core.first.call(null,(state_28505[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28630 = state_28505;
state_28505 = G__28630;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
superv$async$state_machine__21468__auto__ = function(state_28505){
switch(arguments.length){
case 0:
return superv$async$state_machine__21468__auto____0.call(this);
case 1:
return superv$async$state_machine__21468__auto____1.call(this,state_28505);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__21468__auto____0;
superv$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__21468__auto____1;
return superv$async$state_machine__21468__auto__;
})()
;})(__28580,switch__21467__auto__,c__21592__auto___28583,c__14578__auto___28581,id__14579__auto___28582,n__5593__auto___28579,threads))
})();
var state__21594__auto__ = (function (){var statearr_28577 = f__21593__auto__.call(null);
(statearr_28577[(6)] = c__21592__auto___28583);

return statearr_28577;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
});})(__28580,c__21592__auto___28583,c__14578__auto___28581,id__14579__auto___28582,n__5593__auto___28579,threads))
);


var G__28631 = (__28580 + (1));
__28580 = G__28631;
continue;
} else {
}
break;
}

return out_ch;
}));

(superv.async.pmap_GT__GT_.cljs$lang$maxFixedArity = 5);

/**
 * Similiar to dorun. Simply takes messages from channels but does nothing with
 *   them. Returns channel that will close when all messages have been consumed.
 */
superv.async.engulf = (function superv$async$engulf(var_args){
var args__5732__auto__ = [];
var len__5726__auto___28725 = arguments.length;
var i__5727__auto___28726 = (0);
while(true){
if((i__5727__auto___28726 < len__5726__auto___28725)){
args__5732__auto__.push((arguments[i__5727__auto___28726]));

var G__28727 = (i__5727__auto___28726 + (1));
i__5727__auto___28726 = G__28727;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return superv.async.engulf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(superv.async.engulf.cljs$core$IFn$_invoke$arity$variadic = (function (S,cs){
var ch = cljs.core.async.merge.call(null,cs);
var c__14578__auto__ = superv.async.check_supervisor.call(null,superv.async.S);
var id__14579__auto__ = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null))))));
var c__21592__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = (function (state_28687){
var state_val_28688 = (state_28687[(1)]);
if((state_val_28688 === (7))){
var inst_28639 = (state_28687[(7)]);
var inst_28645 = superv.async._track_exception.call(null,S,inst_28639);
var state_28687__$1 = state_28687;
var statearr_28689_28728 = state_28687__$1;
(statearr_28689_28728[(2)] = inst_28645);

(statearr_28689_28728[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28688 === (1))){
var state_28687__$1 = state_28687;
var statearr_28690_28729 = state_28687__$1;
(statearr_28690_28729[(2)] = null);

(statearr_28690_28729[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28688 === (4))){
var _ = (function (){var statearr_28691 = state_28687;
(statearr_28691[(4)] = cljs.core.rest.call(null,(state_28687[(4)])));

return statearr_28691;
})();
var inst_28635 = (state_28687[(2)]);
var inst_28636 = superv.async._unregister_go.call(null,S,id__14579__auto__);
var ___$1 = (function (){var temp__5804__auto__ = (state_28687[(5)]);
if(cljs.core.truth_(temp__5804__auto__)){
var e__20700__auto__ = temp__5804__auto__;
throw e__20700__auto__;
} else {
return null;
}
})();
var state_28687__$1 = (function (){var statearr_28692 = state_28687;
(statearr_28692[(8)] = inst_28636);

return statearr_28692;
})();
var statearr_28693_28730 = state_28687__$1;
(statearr_28693_28730[(2)] = inst_28635);

(statearr_28693_28730[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28688 === (15))){
var inst_28674 = (state_28687[(2)]);
var inst_28675 = superv.async.throw_if_exception.call(null,S,inst_28674);
var state_28687__$1 = state_28687;
if(cljs.core.truth_(inst_28675)){
var statearr_28694_28731 = state_28687__$1;
(statearr_28694_28731[(1)] = (16));

} else {
var statearr_28695_28732 = state_28687__$1;
(statearr_28695_28732[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28688 === (13))){
var inst_28668 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_28669 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_28670 = cljs.core.PersistentHashMap.fromArrays(inst_28668,inst_28669);
var inst_28671 = cljs.core.ex_info.call(null,"Aborted operations",inst_28670);
var state_28687__$1 = state_28687;
var statearr_28696_28733 = state_28687__$1;
(statearr_28696_28733[(2)] = inst_28671);

(statearr_28696_28733[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28688 === (6))){
var state_28687__$1 = state_28687;
var statearr_28697_28734 = state_28687__$1;
(statearr_28697_28734[(2)] = null);

(statearr_28697_28734[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28688 === (17))){
var state_28687__$1 = state_28687;
var statearr_28698_28735 = state_28687__$1;
(statearr_28698_28735[(2)] = null);

(statearr_28698_28735[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28688 === (3))){
var inst_28685 = (state_28687[(2)]);
var state_28687__$1 = state_28687;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28687__$1,inst_28685);
} else {
if((state_val_28688 === (12))){
var inst_28658 = (state_28687[(9)]);
var inst_28663 = (state_28687[(2)]);
var inst_28664 = cljs.core.nth.call(null,inst_28663,(0),null);
var inst_28665 = cljs.core.nth.call(null,inst_28663,(1),null);
var inst_28666 = cljs.core._EQ_.call(null,inst_28665,inst_28658);
var state_28687__$1 = (function (){var statearr_28699 = state_28687;
(statearr_28699[(10)] = inst_28664);

return statearr_28699;
})();
if(inst_28666){
var statearr_28700_28736 = state_28687__$1;
(statearr_28700_28736[(1)] = (13));

} else {
var statearr_28701_28737 = state_28687__$1;
(statearr_28701_28737[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28688 === (2))){
var _ = (function (){var statearr_28703 = state_28687;
(statearr_28703[(4)] = cljs.core.cons.call(null,(4),(state_28687[(4)])));

return statearr_28703;
})();
var ___$1 = (function (){var statearr_28704 = state_28687;
(statearr_28704[(4)] = cljs.core.cons.call(null,(9),(state_28687[(4)])));

return statearr_28704;
})();
var state_28687__$1 = state_28687;
var statearr_28705_28738 = state_28687__$1;
(statearr_28705_28738[(2)] = null);

(statearr_28705_28738[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28688 === (11))){
var inst_28682 = (state_28687[(2)]);
var _ = (function (){var statearr_28706 = state_28687;
(statearr_28706[(4)] = cljs.core.rest.call(null,(state_28687[(4)])));

return statearr_28706;
})();
var state_28687__$1 = state_28687;
var statearr_28707_28739 = state_28687__$1;
(statearr_28707_28739[(2)] = inst_28682);

(statearr_28707_28739[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28688 === (9))){
var _ = (function (){var statearr_28708 = state_28687;
(statearr_28708[(4)] = cljs.core.rest.call(null,(state_28687[(4)])));

return statearr_28708;
})();
var state_28687__$1 = state_28687;
var ex28702 = (state_28687__$1[(2)]);
var statearr_28709_28740 = state_28687__$1;
(statearr_28709_28740[(5)] = ex28702);


if((ex28702 instanceof Error)){
var statearr_28710_28741 = state_28687__$1;
(statearr_28710_28741[(1)] = (5));

(statearr_28710_28741[(5)] = null);

} else {
throw ex28702;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28688 === (5))){
var inst_28639 = (state_28687[(7)]);
var inst_28639__$1 = (state_28687[(2)]);
var inst_28640 = cljs.core.ex_data.call(null,inst_28639__$1);
var inst_28641 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_28640);
var inst_28642 = cljs.core._EQ_.call(null,inst_28641,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_28687__$1 = (function (){var statearr_28711 = state_28687;
(statearr_28711[(7)] = inst_28639__$1);

return statearr_28711;
})();
if(inst_28642){
var statearr_28712_28742 = state_28687__$1;
(statearr_28712_28742[(1)] = (6));

} else {
var statearr_28713_28743 = state_28687__$1;
(statearr_28713_28743[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28688 === (14))){
var inst_28664 = (state_28687[(10)]);
var state_28687__$1 = state_28687;
var statearr_28714_28744 = state_28687__$1;
(statearr_28714_28744[(2)] = inst_28664);

(statearr_28714_28744[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28688 === (16))){
var state_28687__$1 = state_28687;
var statearr_28715_28745 = state_28687__$1;
(statearr_28715_28745[(2)] = null);

(statearr_28715_28745[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28688 === (10))){
var inst_28658 = (state_28687[(9)]);
var inst_28658__$1 = superv.async._abort.call(null,S);
var inst_28659 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28660 = [inst_28658__$1,ch];
var inst_28661 = (new cljs.core.PersistentVector(null,2,(5),inst_28659,inst_28660,null));
var state_28687__$1 = (function (){var statearr_28716 = state_28687;
(statearr_28716[(9)] = inst_28658__$1);

return statearr_28716;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_28687__$1,(12),inst_28661,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_28688 === (18))){
var inst_28680 = (state_28687[(2)]);
var state_28687__$1 = state_28687;
var statearr_28717_28746 = state_28687__$1;
(statearr_28717_28746[(2)] = inst_28680);

(statearr_28717_28746[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28688 === (8))){
var inst_28639 = (state_28687[(7)]);
var inst_28647 = (state_28687[(2)]);
var state_28687__$1 = (function (){var statearr_28718 = state_28687;
(statearr_28718[(11)] = inst_28647);

return statearr_28718;
})();
var statearr_28719_28747 = state_28687__$1;
(statearr_28719_28747[(2)] = inst_28639);

(statearr_28719_28747[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var superv$async$state_machine__21468__auto__ = null;
var superv$async$state_machine__21468__auto____0 = (function (){
var statearr_28720 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28720[(0)] = superv$async$state_machine__21468__auto__);

(statearr_28720[(1)] = (1));

return statearr_28720;
});
var superv$async$state_machine__21468__auto____1 = (function (state_28687){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_28687);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e28721){var ex__21471__auto__ = e28721;
var statearr_28722_28748 = state_28687;
(statearr_28722_28748[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_28687[(4)]))){
var statearr_28723_28749 = state_28687;
(statearr_28723_28749[(1)] = cljs.core.first.call(null,(state_28687[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28750 = state_28687;
state_28687 = G__28750;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
superv$async$state_machine__21468__auto__ = function(state_28687){
switch(arguments.length){
case 0:
return superv$async$state_machine__21468__auto____0.call(this);
case 1:
return superv$async$state_machine__21468__auto____1.call(this,state_28687);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__21468__auto____0;
superv$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__21468__auto____1;
return superv$async$state_machine__21468__auto__;
})()
})();
var state__21594__auto__ = (function (){var statearr_28724 = f__21593__auto__.call(null);
(statearr_28724[(6)] = c__21592__auto__);

return statearr_28724;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
}));

return c__21592__auto__;
}));

(superv.async.engulf.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(superv.async.engulf.cljs$lang$applyTo = (function (seq28632){
var G__28633 = cljs.core.first.call(null,seq28632);
var seq28632__$1 = cljs.core.next.call(null,seq28632);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28633,seq28632__$1);
}));

/**
 * Performs a reduce on objects from ch with the function f> (which
 *   should return a channel). Returns a channel with the resulting
 *   value.
 */
superv.async.reduce_GT_ = (function superv$async$reduce_GT_(S,f_GT_,acc,ch){
var result = cljs.core.async.chan.call(null);
var c__14578__auto___28948 = superv.async.check_supervisor.call(null,superv.async.S);
var id__14579__auto___28949 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"acc","acc",-1815869457,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null)], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),new cljs.core.Symbol(null,"x","x",-555367584,null)),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"result","result",-1239343558,null),new cljs.core.Symbol(null,"x","x",-555367584,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"result","result",-1239343558,null))),cljs.core.list(new cljs.core.Symbol(null,"->>","->>",-1874332161,null),cljs.core.list(new cljs.core.Symbol(null,"f>","f>",-1169871571,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null),new cljs.core.Symbol(null,"x","x",-555367584,null)),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null)),new cljs.core.Symbol(null,"recur","recur",1202958259,null))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"result","result",-1239343558,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"result","result",-1239343558,null)))))));
var c__21592__auto___28950 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = (function (state_28883){
var state_val_28884 = (state_28883[(1)]);
if((state_val_28884 === (7))){
var inst_28756 = (state_28883[(7)]);
var inst_28762 = superv.async._track_exception.call(null,S,inst_28756);
var state_28883__$1 = state_28883;
var statearr_28885_28951 = state_28883__$1;
(statearr_28885_28951[(2)] = inst_28762);

(statearr_28885_28951[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28884 === (20))){
var inst_28772 = (state_28883[(8)]);
var inst_28794 = (state_28883[(9)]);
var inst_28827 = (state_28883[(10)]);
var inst_28827__$1 = superv.async._abort.call(null,S);
var inst_28828 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28829 = f_GT_.call(null,inst_28772,inst_28794);
var inst_28830 = [inst_28827__$1,inst_28829];
var inst_28831 = (new cljs.core.PersistentVector(null,2,(5),inst_28828,inst_28830,null));
var state_28883__$1 = (function (){var statearr_28886 = state_28883;
(statearr_28886[(10)] = inst_28827__$1);

return statearr_28886;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_28883__$1,(27),inst_28831,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_28884 === (27))){
var inst_28827 = (state_28883[(10)]);
var inst_28833 = (state_28883[(2)]);
var inst_28834 = cljs.core.nth.call(null,inst_28833,(0),null);
var inst_28835 = cljs.core.nth.call(null,inst_28833,(1),null);
var inst_28836 = cljs.core._EQ_.call(null,inst_28835,inst_28827);
var state_28883__$1 = (function (){var statearr_28887 = state_28883;
(statearr_28887[(11)] = inst_28834);

return statearr_28887;
})();
if(inst_28836){
var statearr_28888_28952 = state_28883__$1;
(statearr_28888_28952[(1)] = (28));

} else {
var statearr_28889_28953 = state_28883__$1;
(statearr_28889_28953[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28884 === (1))){
var state_28883__$1 = state_28883;
var statearr_28890_28954 = state_28883__$1;
(statearr_28890_28954[(2)] = null);

(statearr_28890_28954[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28884 === (24))){
var inst_28794 = (state_28883[(9)]);
var state_28883__$1 = state_28883;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28883__$1,(26),result,inst_28794);
} else {
if((state_val_28884 === (4))){
var _ = (function (){var statearr_28891 = state_28883;
(statearr_28891[(4)] = cljs.core.rest.call(null,(state_28883[(4)])));

return statearr_28891;
})();
var inst_28752 = (state_28883[(2)]);
var inst_28753 = superv.async._unregister_go.call(null,S,id__14579__auto___28949);
var ___$1 = (function (){var temp__5804__auto__ = (state_28883[(5)]);
if(cljs.core.truth_(temp__5804__auto__)){
var e__20700__auto__ = temp__5804__auto__;
throw e__20700__auto__;
} else {
return null;
}
})();
var state_28883__$1 = (function (){var statearr_28892 = state_28883;
(statearr_28892[(12)] = inst_28753);

return statearr_28892;
})();
var statearr_28893_28955 = state_28883__$1;
(statearr_28893_28955[(2)] = inst_28752);

(statearr_28893_28955[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28884 === (15))){
var inst_28794 = (state_28883[(9)]);
var inst_28793 = (state_28883[(2)]);
var inst_28794__$1 = superv.async.throw_if_exception.call(null,S,inst_28793);
var state_28883__$1 = (function (){var statearr_28894 = state_28883;
(statearr_28894[(9)] = inst_28794__$1);

return statearr_28894;
})();
if(cljs.core.truth_(inst_28794__$1)){
var statearr_28895_28956 = state_28883__$1;
(statearr_28895_28956[(1)] = (16));

} else {
var statearr_28896_28957 = state_28883__$1;
(statearr_28896_28957[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28884 === (21))){
var inst_28848 = (state_28883[(2)]);
var state_28883__$1 = state_28883;
var statearr_28897_28958 = state_28883__$1;
(statearr_28897_28958[(2)] = inst_28848);

(statearr_28897_28958[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28884 === (31))){
var inst_28853 = (state_28883[(13)]);
var inst_28859 = (state_28883[(2)]);
var inst_28860 = cljs.core.nth.call(null,inst_28859,(0),null);
var inst_28861 = cljs.core.nth.call(null,inst_28859,(1),null);
var inst_28862 = cljs.core._EQ_.call(null,inst_28861,inst_28853);
var state_28883__$1 = (function (){var statearr_28898 = state_28883;
(statearr_28898[(14)] = inst_28860);

return statearr_28898;
})();
if(inst_28862){
var statearr_28899_28959 = state_28883__$1;
(statearr_28899_28959[(1)] = (32));

} else {
var statearr_28900_28960 = state_28883__$1;
(statearr_28900_28960[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28884 === (32))){
var inst_28864 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_28865 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_28866 = cljs.core.PersistentHashMap.fromArrays(inst_28864,inst_28865);
var inst_28867 = cljs.core.ex_info.call(null,"Aborted operations",inst_28866);
var state_28883__$1 = state_28883;
var statearr_28901_28961 = state_28883__$1;
(statearr_28901_28961[(2)] = inst_28867);

(statearr_28901_28961[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28884 === (33))){
var inst_28772 = (state_28883[(8)]);
var state_28883__$1 = state_28883;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28883__$1,(35),result,inst_28772);
} else {
if((state_val_28884 === (13))){
var inst_28787 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_28788 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_28789 = cljs.core.PersistentHashMap.fromArrays(inst_28787,inst_28788);
var inst_28790 = cljs.core.ex_info.call(null,"Aborted operations",inst_28789);
var state_28883__$1 = state_28883;
var statearr_28902_28962 = state_28883__$1;
(statearr_28902_28962[(2)] = inst_28790);

(statearr_28902_28962[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28884 === (22))){
var inst_28801 = (state_28883[(15)]);
var inst_28807 = (state_28883[(2)]);
var inst_28808 = cljs.core.nth.call(null,inst_28807,(0),null);
var inst_28809 = cljs.core.nth.call(null,inst_28807,(1),null);
var inst_28810 = cljs.core._EQ_.call(null,inst_28809,inst_28801);
var state_28883__$1 = (function (){var statearr_28903 = state_28883;
(statearr_28903[(16)] = inst_28808);

return statearr_28903;
})();
if(inst_28810){
var statearr_28904_28963 = state_28883__$1;
(statearr_28904_28963[(1)] = (23));

} else {
var statearr_28905_28964 = state_28883__$1;
(statearr_28905_28964[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28884 === (29))){
var inst_28834 = (state_28883[(11)]);
var state_28883__$1 = state_28883;
var statearr_28906_28965 = state_28883__$1;
(statearr_28906_28965[(2)] = inst_28834);

(statearr_28906_28965[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28884 === (6))){
var state_28883__$1 = state_28883;
var statearr_28907_28966 = state_28883__$1;
(statearr_28907_28966[(2)] = null);

(statearr_28907_28966[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28884 === (28))){
var inst_28838 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_28839 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_28840 = cljs.core.PersistentHashMap.fromArrays(inst_28838,inst_28839);
var inst_28841 = cljs.core.ex_info.call(null,"Aborted operations",inst_28840);
var state_28883__$1 = state_28883;
var statearr_28908_28967 = state_28883__$1;
(statearr_28908_28967[(2)] = inst_28841);

(statearr_28908_28967[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28884 === (25))){
var inst_28820 = (state_28883[(2)]);
var inst_28821 = superv.async.throw_if_exception.call(null,S,inst_28820);
var inst_28822 = cljs.core.async.close_BANG_.call(null,result);
var state_28883__$1 = (function (){var statearr_28909 = state_28883;
(statearr_28909[(17)] = inst_28821);

return statearr_28909;
})();
var statearr_28910_28968 = state_28883__$1;
(statearr_28910_28968[(2)] = inst_28822);

(statearr_28910_28968[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28884 === (34))){
var inst_28872 = (state_28883[(2)]);
var inst_28873 = superv.async.throw_if_exception.call(null,S,inst_28872);
var inst_28874 = cljs.core.async.close_BANG_.call(null,result);
var state_28883__$1 = (function (){var statearr_28911 = state_28883;
(statearr_28911[(18)] = inst_28873);

return statearr_28911;
})();
var statearr_28912_28969 = state_28883__$1;
(statearr_28912_28969[(2)] = inst_28874);

(statearr_28912_28969[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28884 === (17))){
var inst_28853 = (state_28883[(13)]);
var inst_28853__$1 = superv.async._abort.call(null,S);
var inst_28854 = cljs.core.async.timeout.call(null,(0));
var inst_28855 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28856 = [inst_28853__$1,inst_28854];
var inst_28857 = (new cljs.core.PersistentVector(null,2,(5),inst_28855,inst_28856,null));
var state_28883__$1 = (function (){var statearr_28913 = state_28883;
(statearr_28913[(13)] = inst_28853__$1);

return statearr_28913;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_28883__$1,(31),inst_28857,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_28884 === (3))){
var inst_28881 = (state_28883[(2)]);
var state_28883__$1 = state_28883;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28883__$1,inst_28881);
} else {
if((state_val_28884 === (12))){
var inst_28777 = (state_28883[(19)]);
var inst_28782 = (state_28883[(2)]);
var inst_28783 = cljs.core.nth.call(null,inst_28782,(0),null);
var inst_28784 = cljs.core.nth.call(null,inst_28782,(1),null);
var inst_28785 = cljs.core._EQ_.call(null,inst_28784,inst_28777);
var state_28883__$1 = (function (){var statearr_28914 = state_28883;
(statearr_28914[(20)] = inst_28783);

return statearr_28914;
})();
if(inst_28785){
var statearr_28915_28970 = state_28883__$1;
(statearr_28915_28970[(1)] = (13));

} else {
var statearr_28916_28971 = state_28883__$1;
(statearr_28916_28971[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28884 === (2))){
var _ = (function (){var statearr_28917 = state_28883;
(statearr_28917[(4)] = cljs.core.cons.call(null,(4),(state_28883[(4)])));

return statearr_28917;
})();
var ___$1 = (function (){var statearr_28918 = state_28883;
(statearr_28918[(4)] = cljs.core.cons.call(null,(9),(state_28883[(4)])));

return statearr_28918;
})();
var inst_28771 = acc;
var inst_28772 = inst_28771;
var state_28883__$1 = (function (){var statearr_28919 = state_28883;
(statearr_28919[(8)] = inst_28772);

return statearr_28919;
})();
var statearr_28920_28972 = state_28883__$1;
(statearr_28920_28972[(2)] = null);

(statearr_28920_28972[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28884 === (23))){
var inst_28812 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_28813 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_28814 = cljs.core.PersistentHashMap.fromArrays(inst_28812,inst_28813);
var inst_28815 = cljs.core.ex_info.call(null,"Aborted operations",inst_28814);
var state_28883__$1 = state_28883;
var statearr_28921_28973 = state_28883__$1;
(statearr_28921_28973[(2)] = inst_28815);

(statearr_28921_28973[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28884 === (35))){
var inst_28870 = (state_28883[(2)]);
var state_28883__$1 = state_28883;
var statearr_28922_28974 = state_28883__$1;
(statearr_28922_28974[(2)] = inst_28870);

(statearr_28922_28974[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28884 === (19))){
var inst_28801 = (state_28883[(15)]);
var inst_28801__$1 = superv.async._abort.call(null,S);
var inst_28802 = cljs.core.async.timeout.call(null,(0));
var inst_28803 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28804 = [inst_28801__$1,inst_28802];
var inst_28805 = (new cljs.core.PersistentVector(null,2,(5),inst_28803,inst_28804,null));
var state_28883__$1 = (function (){var statearr_28924 = state_28883;
(statearr_28924[(15)] = inst_28801__$1);

return statearr_28924;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_28883__$1,(22),inst_28805,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_28884 === (11))){
var inst_28878 = (state_28883[(2)]);
var _ = (function (){var statearr_28925 = state_28883;
(statearr_28925[(4)] = cljs.core.rest.call(null,(state_28883[(4)])));

return statearr_28925;
})();
var state_28883__$1 = state_28883;
var statearr_28926_28975 = state_28883__$1;
(statearr_28926_28975[(2)] = inst_28878);

(statearr_28926_28975[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28884 === (9))){
var _ = (function (){var statearr_28927 = state_28883;
(statearr_28927[(4)] = cljs.core.rest.call(null,(state_28883[(4)])));

return statearr_28927;
})();
var state_28883__$1 = state_28883;
var ex28923 = (state_28883__$1[(2)]);
var statearr_28928_28976 = state_28883__$1;
(statearr_28928_28976[(5)] = ex28923);


if((ex28923 instanceof Error)){
var statearr_28929_28977 = state_28883__$1;
(statearr_28929_28977[(1)] = (5));

(statearr_28929_28977[(5)] = null);

} else {
throw ex28923;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28884 === (5))){
var inst_28756 = (state_28883[(7)]);
var inst_28756__$1 = (state_28883[(2)]);
var inst_28757 = cljs.core.ex_data.call(null,inst_28756__$1);
var inst_28758 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_28757);
var inst_28759 = cljs.core._EQ_.call(null,inst_28758,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_28883__$1 = (function (){var statearr_28930 = state_28883;
(statearr_28930[(7)] = inst_28756__$1);

return statearr_28930;
})();
if(inst_28759){
var statearr_28931_28978 = state_28883__$1;
(statearr_28931_28978[(1)] = (6));

} else {
var statearr_28932_28979 = state_28883__$1;
(statearr_28932_28979[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28884 === (14))){
var inst_28783 = (state_28883[(20)]);
var state_28883__$1 = state_28883;
var statearr_28933_28980 = state_28883__$1;
(statearr_28933_28980[(2)] = inst_28783);

(statearr_28933_28980[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28884 === (26))){
var inst_28818 = (state_28883[(2)]);
var state_28883__$1 = state_28883;
var statearr_28934_28981 = state_28883__$1;
(statearr_28934_28981[(2)] = inst_28818);

(statearr_28934_28981[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28884 === (16))){
var inst_28794 = (state_28883[(9)]);
var inst_28796 = (inst_28794 instanceof Error);
var state_28883__$1 = state_28883;
if(cljs.core.truth_(inst_28796)){
var statearr_28935_28982 = state_28883__$1;
(statearr_28935_28982[(1)] = (19));

} else {
var statearr_28936_28983 = state_28883__$1;
(statearr_28936_28983[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28884 === (30))){
var inst_28844 = (state_28883[(2)]);
var inst_28845 = superv.async.throw_if_exception.call(null,S,inst_28844);
var inst_28772 = inst_28845;
var state_28883__$1 = (function (){var statearr_28937 = state_28883;
(statearr_28937[(8)] = inst_28772);

return statearr_28937;
})();
var statearr_28938_28984 = state_28883__$1;
(statearr_28938_28984[(2)] = null);

(statearr_28938_28984[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28884 === (10))){
var inst_28777 = (state_28883[(19)]);
var inst_28777__$1 = superv.async._abort.call(null,S);
var inst_28778 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28779 = [inst_28777__$1,ch];
var inst_28780 = (new cljs.core.PersistentVector(null,2,(5),inst_28778,inst_28779,null));
var state_28883__$1 = (function (){var statearr_28939 = state_28883;
(statearr_28939[(19)] = inst_28777__$1);

return statearr_28939;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_28883__$1,(12),inst_28780,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_28884 === (18))){
var inst_28876 = (state_28883[(2)]);
var state_28883__$1 = state_28883;
var statearr_28940_28985 = state_28883__$1;
(statearr_28940_28985[(2)] = inst_28876);

(statearr_28940_28985[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28884 === (8))){
var inst_28756 = (state_28883[(7)]);
var inst_28764 = (state_28883[(2)]);
var state_28883__$1 = (function (){var statearr_28941 = state_28883;
(statearr_28941[(21)] = inst_28764);

return statearr_28941;
})();
var statearr_28942_28986 = state_28883__$1;
(statearr_28942_28986[(2)] = inst_28756);

(statearr_28942_28986[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var superv$async$reduce_GT__$_state_machine__21468__auto__ = null;
var superv$async$reduce_GT__$_state_machine__21468__auto____0 = (function (){
var statearr_28943 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28943[(0)] = superv$async$reduce_GT__$_state_machine__21468__auto__);

(statearr_28943[(1)] = (1));

return statearr_28943;
});
var superv$async$reduce_GT__$_state_machine__21468__auto____1 = (function (state_28883){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_28883);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e28944){var ex__21471__auto__ = e28944;
var statearr_28945_28987 = state_28883;
(statearr_28945_28987[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_28883[(4)]))){
var statearr_28946_28988 = state_28883;
(statearr_28946_28988[(1)] = cljs.core.first.call(null,(state_28883[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28989 = state_28883;
state_28883 = G__28989;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
superv$async$reduce_GT__$_state_machine__21468__auto__ = function(state_28883){
switch(arguments.length){
case 0:
return superv$async$reduce_GT__$_state_machine__21468__auto____0.call(this);
case 1:
return superv$async$reduce_GT__$_state_machine__21468__auto____1.call(this,state_28883);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$reduce_GT__$_state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$reduce_GT__$_state_machine__21468__auto____0;
superv$async$reduce_GT__$_state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$reduce_GT__$_state_machine__21468__auto____1;
return superv$async$reduce_GT__$_state_machine__21468__auto__;
})()
})();
var state__21594__auto__ = (function (){var statearr_28947 = f__21593__auto__.call(null);
(statearr_28947[(6)] = c__21592__auto___28950);

return statearr_28947;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
}));


return result;
});
/**
 * Concatenates two or more channels. First takes all values from first channel
 *   and supplies to output channel, then takes all values from second channel and
 *   so on. Similiar to core.async/merge but maintains the order of values.
 */
superv.async.concat_GT__GT_ = (function superv$async$concat_GT__GT_(var_args){
var args__5732__auto__ = [];
var len__5726__auto___29133 = arguments.length;
var i__5727__auto___29134 = (0);
while(true){
if((i__5727__auto___29134 < len__5726__auto___29133)){
args__5732__auto__.push((arguments[i__5727__auto___29134]));

var G__29135 = (i__5727__auto___29134 + (1));
i__5727__auto___29134 = G__29135;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return superv.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(superv.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (S,cs){
var out = cljs.core.async.chan.call(null);
var c__14578__auto___29136 = superv.async.check_supervisor.call(null,superv.async.S);
var id__14579__auto___29137 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"loop","loop",1244978678,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null)], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"c","c",-122660552,null),cljs.core.list(new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"c","c",-122660552,null))], null),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"v","v",1661996586,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null))),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),cljs.core.list(new cljs.core.Symbol(null,"rest","rest",398835108,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null)))),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out","out",729986010,null))))));
var c__21592__auto___29138 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = (function (state_29079){
var state_val_29080 = (state_29079[(1)]);
if((state_val_29080 === (7))){
var inst_28997 = (state_29079[(7)]);
var inst_29003 = superv.async._track_exception.call(null,S,inst_28997);
var state_29079__$1 = state_29079;
var statearr_29081_29139 = state_29079__$1;
(statearr_29081_29139[(2)] = inst_29003);

(statearr_29081_29139[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29080 === (20))){
var inst_29013 = (state_29079[(8)]);
var inst_29065 = cljs.core.rest.call(null,inst_29013);
var inst_29013__$1 = inst_29065;
var state_29079__$1 = (function (){var statearr_29082 = state_29079;
(statearr_29082[(8)] = inst_29013__$1);

return statearr_29082;
})();
var statearr_29083_29140 = state_29079__$1;
(statearr_29083_29140[(2)] = null);

(statearr_29083_29140[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29080 === (1))){
var state_29079__$1 = state_29079;
var statearr_29084_29141 = state_29079__$1;
(statearr_29084_29141[(2)] = null);

(statearr_29084_29141[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29080 === (24))){
var inst_29037 = (state_29079[(9)]);
var state_29079__$1 = state_29079;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29079__$1,(26),out,inst_29037);
} else {
if((state_val_29080 === (4))){
var _ = (function (){var statearr_29085 = state_29079;
(statearr_29085[(4)] = cljs.core.rest.call(null,(state_29079[(4)])));

return statearr_29085;
})();
var inst_28993 = (state_29079[(2)]);
var inst_28994 = superv.async._unregister_go.call(null,S,id__14579__auto___29137);
var ___$1 = (function (){var temp__5804__auto__ = (state_29079[(5)]);
if(cljs.core.truth_(temp__5804__auto__)){
var e__20700__auto__ = temp__5804__auto__;
throw e__20700__auto__;
} else {
return null;
}
})();
var state_29079__$1 = (function (){var statearr_29086 = state_29079;
(statearr_29086[(10)] = inst_28994);

return statearr_29086;
})();
var statearr_29087_29142 = state_29079__$1;
(statearr_29087_29142[(2)] = inst_28993);

(statearr_29087_29142[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29080 === (15))){
var inst_29020 = (state_29079[(11)]);
var inst_29025 = (state_29079[(2)]);
var inst_29026 = cljs.core.nth.call(null,inst_29025,(0),null);
var inst_29027 = cljs.core.nth.call(null,inst_29025,(1),null);
var inst_29028 = cljs.core._EQ_.call(null,inst_29027,inst_29020);
var state_29079__$1 = (function (){var statearr_29088 = state_29079;
(statearr_29088[(12)] = inst_29026);

return statearr_29088;
})();
if(inst_29028){
var statearr_29089_29143 = state_29079__$1;
(statearr_29089_29143[(1)] = (16));

} else {
var statearr_29090_29144 = state_29079__$1;
(statearr_29090_29144[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29080 === (21))){
var inst_29068 = (state_29079[(2)]);
var state_29079__$1 = state_29079;
var statearr_29091_29145 = state_29079__$1;
(statearr_29091_29145[(2)] = inst_29068);

(statearr_29091_29145[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29080 === (13))){
var inst_29070 = cljs.core.async.close_BANG_.call(null,out);
var state_29079__$1 = state_29079;
var statearr_29092_29146 = state_29079__$1;
(statearr_29092_29146[(2)] = inst_29070);

(statearr_29092_29146[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29080 === (22))){
var inst_29042 = (state_29079[(13)]);
var inst_29048 = (state_29079[(2)]);
var inst_29049 = cljs.core.nth.call(null,inst_29048,(0),null);
var inst_29050 = cljs.core.nth.call(null,inst_29048,(1),null);
var inst_29051 = cljs.core._EQ_.call(null,inst_29050,inst_29042);
var state_29079__$1 = (function (){var statearr_29094 = state_29079;
(statearr_29094[(14)] = inst_29049);

return statearr_29094;
})();
if(inst_29051){
var statearr_29095_29147 = state_29079__$1;
(statearr_29095_29147[(1)] = (23));

} else {
var statearr_29096_29148 = state_29079__$1;
(statearr_29096_29148[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29080 === (6))){
var state_29079__$1 = state_29079;
var statearr_29097_29149 = state_29079__$1;
(statearr_29097_29149[(2)] = null);

(statearr_29097_29149[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29080 === (25))){
var inst_29013 = (state_29079[(8)]);
var inst_29061 = (state_29079[(2)]);
var inst_29062 = superv.async.throw_if_exception.call(null,S,inst_29061);
var tmp29093 = inst_29013;
var inst_29013__$1 = tmp29093;
var state_29079__$1 = (function (){var statearr_29098 = state_29079;
(statearr_29098[(15)] = inst_29062);

(statearr_29098[(8)] = inst_29013__$1);

return statearr_29098;
})();
var statearr_29099_29150 = state_29079__$1;
(statearr_29099_29150[(2)] = null);

(statearr_29099_29150[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29080 === (17))){
var inst_29026 = (state_29079[(12)]);
var state_29079__$1 = state_29079;
var statearr_29100_29151 = state_29079__$1;
(statearr_29100_29151[(2)] = inst_29026);

(statearr_29100_29151[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29080 === (3))){
var inst_29077 = (state_29079[(2)]);
var state_29079__$1 = state_29079;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29079__$1,inst_29077);
} else {
if((state_val_29080 === (12))){
var inst_29020 = (state_29079[(11)]);
var inst_29015 = (state_29079[(16)]);
var inst_29020__$1 = superv.async._abort.call(null,S);
var inst_29021 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29022 = [inst_29020__$1,inst_29015];
var inst_29023 = (new cljs.core.PersistentVector(null,2,(5),inst_29021,inst_29022,null));
var state_29079__$1 = (function (){var statearr_29101 = state_29079;
(statearr_29101[(11)] = inst_29020__$1);

return statearr_29101;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_29079__$1,(15),inst_29023,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_29080 === (2))){
var _ = (function (){var statearr_29102 = state_29079;
(statearr_29102[(4)] = cljs.core.cons.call(null,(4),(state_29079[(4)])));

return statearr_29102;
})();
var ___$1 = (function (){var statearr_29103 = state_29079;
(statearr_29103[(4)] = cljs.core.cons.call(null,(9),(state_29079[(4)])));

return statearr_29103;
})();
var inst_29012 = cs;
var inst_29013 = inst_29012;
var state_29079__$1 = (function (){var statearr_29104 = state_29079;
(statearr_29104[(8)] = inst_29013);

return statearr_29104;
})();
var statearr_29105_29152 = state_29079__$1;
(statearr_29105_29152[(2)] = null);

(statearr_29105_29152[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29080 === (23))){
var inst_29053 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_29054 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_29055 = cljs.core.PersistentHashMap.fromArrays(inst_29053,inst_29054);
var inst_29056 = cljs.core.ex_info.call(null,"Aborted operations",inst_29055);
var state_29079__$1 = state_29079;
var statearr_29106_29153 = state_29079__$1;
(statearr_29106_29153[(2)] = inst_29056);

(statearr_29106_29153[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29080 === (19))){
var inst_29042 = (state_29079[(13)]);
var inst_29042__$1 = superv.async._abort.call(null,S);
var inst_29043 = cljs.core.async.timeout.call(null,(0));
var inst_29044 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29045 = [inst_29042__$1,inst_29043];
var inst_29046 = (new cljs.core.PersistentVector(null,2,(5),inst_29044,inst_29045,null));
var state_29079__$1 = (function (){var statearr_29108 = state_29079;
(statearr_29108[(13)] = inst_29042__$1);

return statearr_29108;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_29079__$1,(22),inst_29046,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_29080 === (11))){
var inst_29074 = (state_29079[(2)]);
var _ = (function (){var statearr_29109 = state_29079;
(statearr_29109[(4)] = cljs.core.rest.call(null,(state_29079[(4)])));

return statearr_29109;
})();
var state_29079__$1 = state_29079;
var statearr_29110_29154 = state_29079__$1;
(statearr_29110_29154[(2)] = inst_29074);

(statearr_29110_29154[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29080 === (9))){
var _ = (function (){var statearr_29111 = state_29079;
(statearr_29111[(4)] = cljs.core.rest.call(null,(state_29079[(4)])));

return statearr_29111;
})();
var state_29079__$1 = state_29079;
var ex29107 = (state_29079__$1[(2)]);
var statearr_29112_29155 = state_29079__$1;
(statearr_29112_29155[(5)] = ex29107);


if((ex29107 instanceof Error)){
var statearr_29113_29156 = state_29079__$1;
(statearr_29113_29156[(1)] = (5));

(statearr_29113_29156[(5)] = null);

} else {
throw ex29107;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29080 === (5))){
var inst_28997 = (state_29079[(7)]);
var inst_28997__$1 = (state_29079[(2)]);
var inst_28998 = cljs.core.ex_data.call(null,inst_28997__$1);
var inst_28999 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_28998);
var inst_29000 = cljs.core._EQ_.call(null,inst_28999,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_29079__$1 = (function (){var statearr_29114 = state_29079;
(statearr_29114[(7)] = inst_28997__$1);

return statearr_29114;
})();
if(inst_29000){
var statearr_29115_29157 = state_29079__$1;
(statearr_29115_29157[(1)] = (6));

} else {
var statearr_29116_29158 = state_29079__$1;
(statearr_29116_29158[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29080 === (14))){
var inst_29072 = (state_29079[(2)]);
var state_29079__$1 = state_29079;
var statearr_29117_29159 = state_29079__$1;
(statearr_29117_29159[(2)] = inst_29072);

(statearr_29117_29159[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29080 === (26))){
var inst_29059 = (state_29079[(2)]);
var state_29079__$1 = state_29079;
var statearr_29118_29160 = state_29079__$1;
(statearr_29118_29160[(2)] = inst_29059);

(statearr_29118_29160[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29080 === (16))){
var inst_29030 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_29031 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_29032 = cljs.core.PersistentHashMap.fromArrays(inst_29030,inst_29031);
var inst_29033 = cljs.core.ex_info.call(null,"Aborted operations",inst_29032);
var state_29079__$1 = state_29079;
var statearr_29119_29161 = state_29079__$1;
(statearr_29119_29161[(2)] = inst_29033);

(statearr_29119_29161[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29080 === (10))){
var inst_29013 = (state_29079[(8)]);
var inst_29015 = (state_29079[(16)]);
var inst_29015__$1 = cljs.core.first.call(null,inst_29013);
var state_29079__$1 = (function (){var statearr_29120 = state_29079;
(statearr_29120[(16)] = inst_29015__$1);

return statearr_29120;
})();
if(cljs.core.truth_(inst_29015__$1)){
var statearr_29121_29162 = state_29079__$1;
(statearr_29121_29162[(1)] = (12));

} else {
var statearr_29122_29163 = state_29079__$1;
(statearr_29122_29163[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29080 === (18))){
var inst_29037 = (state_29079[(9)]);
var inst_29036 = (state_29079[(2)]);
var inst_29037__$1 = superv.async.throw_if_exception.call(null,S,inst_29036);
var state_29079__$1 = (function (){var statearr_29123 = state_29079;
(statearr_29123[(9)] = inst_29037__$1);

return statearr_29123;
})();
if(cljs.core.truth_(inst_29037__$1)){
var statearr_29124_29164 = state_29079__$1;
(statearr_29124_29164[(1)] = (19));

} else {
var statearr_29125_29165 = state_29079__$1;
(statearr_29125_29165[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29080 === (8))){
var inst_28997 = (state_29079[(7)]);
var inst_29005 = (state_29079[(2)]);
var state_29079__$1 = (function (){var statearr_29126 = state_29079;
(statearr_29126[(17)] = inst_29005);

return statearr_29126;
})();
var statearr_29127_29166 = state_29079__$1;
(statearr_29127_29166[(2)] = inst_28997);

(statearr_29127_29166[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var superv$async$state_machine__21468__auto__ = null;
var superv$async$state_machine__21468__auto____0 = (function (){
var statearr_29128 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29128[(0)] = superv$async$state_machine__21468__auto__);

(statearr_29128[(1)] = (1));

return statearr_29128;
});
var superv$async$state_machine__21468__auto____1 = (function (state_29079){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_29079);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e29129){var ex__21471__auto__ = e29129;
var statearr_29130_29167 = state_29079;
(statearr_29130_29167[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_29079[(4)]))){
var statearr_29131_29168 = state_29079;
(statearr_29131_29168[(1)] = cljs.core.first.call(null,(state_29079[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29169 = state_29079;
state_29079 = G__29169;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
superv$async$state_machine__21468__auto__ = function(state_29079){
switch(arguments.length){
case 0:
return superv$async$state_machine__21468__auto____0.call(this);
case 1:
return superv$async$state_machine__21468__auto____1.call(this,state_29079);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__21468__auto____0;
superv$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__21468__auto____1;
return superv$async$state_machine__21468__auto__;
})()
})();
var state__21594__auto__ = (function (){var statearr_29132 = f__21593__auto__.call(null);
(statearr_29132[(6)] = c__21592__auto___29138);

return statearr_29132;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
}));


return out;
}));

(superv.async.concat_GT__GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(superv.async.concat_GT__GT_.cljs$lang$applyTo = (function (seq28990){
var G__28991 = cljs.core.first.call(null,seq28990);
var seq28990__$1 = cljs.core.next.call(null,seq28990);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28991,seq28990__$1);
}));

superv.async.partition_all_GT__GT_ = (function superv$async$partition_all_GT__GT_(var_args){
var args__5732__auto__ = [];
var len__5726__auto___29399 = arguments.length;
var i__5727__auto___29400 = (0);
while(true){
if((i__5727__auto___29400 < len__5726__auto___29399)){
args__5732__auto__.push((arguments[i__5727__auto___29400]));

var G__29401 = (i__5727__auto___29400 + (1));
i__5727__auto___29400 = G__29401;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((3) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((3)),(0),null)):null);
return superv.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5733__auto__);
});

(superv.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (S,n,in_ch,p__29174){
var map__29175 = p__29174;
var map__29175__$1 = cljs.core.__destructure_map.call(null,map__29175);
var out_ch = cljs.core.get.call(null,map__29175__$1,new cljs.core.Keyword(null,"out-ch","out-ch",-189045854));
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}


var out_ch__$1 = (function (){var or__5002__auto__ = out_ch;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.async.chan.call(null);
}
})();
var c__14578__auto___29402 = superv.async.check_supervisor.call(null,superv.async.S);
var id__14579__auto___29403 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"batch","batch",977610327,null),cljs.core.PersistentVector.EMPTY], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"obj","obj",-1672671807,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"in-ch","in-ch",-1757981794,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null))),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null),cljs.core.list(new cljs.core.Symbol(null,"conj","conj",-1127293942,null),new cljs.core.Symbol(null,"batch","batch",977610327,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),cljs.core.PersistentVector.EMPTY)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null))))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"not-empty","not-empty",2029453590,null),new cljs.core.Symbol(null,"batch","batch",977610327,null)),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"batch","batch",977610327,null))),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null)))))));
var c__21592__auto___29404 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = (function (state_29324){
var state_val_29325 = (state_29324[(1)]);
if((state_val_29325 === (7))){
var inst_29181 = (state_29324[(7)]);
var inst_29187 = superv.async._track_exception.call(null,S,inst_29181);
var state_29324__$1 = state_29324;
var statearr_29326_29405 = state_29324__$1;
(statearr_29326_29405[(2)] = inst_29187);

(statearr_29326_29405[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29325 === (20))){
var inst_29197 = (state_29324[(8)]);
var inst_29219 = (state_29324[(9)]);
var inst_29249 = (state_29324[(10)]);
var inst_29249__$1 = cljs.core.conj.call(null,inst_29197,inst_29219);
var inst_29250 = cljs.core.count.call(null,inst_29249__$1);
var inst_29251 = cljs.core._EQ_.call(null,n,inst_29250);
var state_29324__$1 = (function (){var statearr_29327 = state_29324;
(statearr_29327[(10)] = inst_29249__$1);

return statearr_29327;
})();
if(inst_29251){
var statearr_29328_29406 = state_29324__$1;
(statearr_29328_29406[(1)] = (27));

} else {
var statearr_29329_29407 = state_29324__$1;
(statearr_29329_29407[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29325 === (27))){
var inst_29256 = (state_29324[(11)]);
var inst_29256__$1 = superv.async._abort.call(null,S);
var inst_29257 = cljs.core.async.timeout.call(null,(0));
var inst_29258 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29259 = [inst_29256__$1,inst_29257];
var inst_29260 = (new cljs.core.PersistentVector(null,2,(5),inst_29258,inst_29259,null));
var state_29324__$1 = (function (){var statearr_29330 = state_29324;
(statearr_29330[(11)] = inst_29256__$1);

return statearr_29330;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_29324__$1,(30),inst_29260,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_29325 === (1))){
var state_29324__$1 = state_29324;
var statearr_29331_29408 = state_29324__$1;
(statearr_29331_29408[(2)] = null);

(statearr_29331_29408[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29325 === (24))){
var inst_29219 = (state_29324[(9)]);
var state_29324__$1 = state_29324;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29324__$1,(26),out_ch__$1,inst_29219);
} else {
if((state_val_29325 === (39))){
var inst_29302 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_29303 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_29304 = cljs.core.PersistentHashMap.fromArrays(inst_29302,inst_29303);
var inst_29305 = cljs.core.ex_info.call(null,"Aborted operations",inst_29304);
var state_29324__$1 = state_29324;
var statearr_29332_29409 = state_29324__$1;
(statearr_29332_29409[(2)] = inst_29305);

(statearr_29332_29409[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29325 === (4))){
var _ = (function (){var statearr_29333 = state_29324;
(statearr_29333[(4)] = cljs.core.rest.call(null,(state_29324[(4)])));

return statearr_29333;
})();
var inst_29177 = (state_29324[(2)]);
var inst_29178 = superv.async._unregister_go.call(null,S,id__14579__auto___29403);
var ___$1 = (function (){var temp__5804__auto__ = (state_29324[(5)]);
if(cljs.core.truth_(temp__5804__auto__)){
var e__20700__auto__ = temp__5804__auto__;
throw e__20700__auto__;
} else {
return null;
}
})();
var state_29324__$1 = (function (){var statearr_29334 = state_29324;
(statearr_29334[(12)] = inst_29178);

return statearr_29334;
})();
var statearr_29335_29410 = state_29324__$1;
(statearr_29335_29410[(2)] = inst_29177);

(statearr_29335_29410[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29325 === (15))){
var inst_29219 = (state_29324[(9)]);
var inst_29218 = (state_29324[(2)]);
var inst_29219__$1 = superv.async.throw_if_exception.call(null,S,inst_29218);
var state_29324__$1 = (function (){var statearr_29336 = state_29324;
(statearr_29336[(9)] = inst_29219__$1);

return statearr_29336;
})();
if(cljs.core.truth_(inst_29219__$1)){
var statearr_29337_29411 = state_29324__$1;
(statearr_29337_29411[(1)] = (16));

} else {
var statearr_29338_29412 = state_29324__$1;
(statearr_29338_29412[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29325 === (21))){
var inst_29284 = (state_29324[(2)]);
var state_29324__$1 = state_29324;
var statearr_29339_29413 = state_29324__$1;
(statearr_29339_29413[(2)] = inst_29284);

(statearr_29339_29413[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29325 === (31))){
var inst_29267 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_29268 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_29269 = cljs.core.PersistentHashMap.fromArrays(inst_29267,inst_29268);
var inst_29270 = cljs.core.ex_info.call(null,"Aborted operations",inst_29269);
var state_29324__$1 = state_29324;
var statearr_29340_29414 = state_29324__$1;
(statearr_29340_29414[(2)] = inst_29270);

(statearr_29340_29414[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29325 === (32))){
var inst_29249 = (state_29324[(10)]);
var state_29324__$1 = state_29324;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29324__$1,(34),out_ch__$1,inst_29249);
} else {
if((state_val_29325 === (40))){
var inst_29197 = (state_29324[(8)]);
var state_29324__$1 = state_29324;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29324__$1,(42),out_ch__$1,inst_29197);
} else {
if((state_val_29325 === (33))){
var inst_29275 = (state_29324[(2)]);
var inst_29276 = superv.async.throw_if_exception.call(null,S,inst_29275);
var inst_29277 = cljs.core.PersistentVector.EMPTY;
var inst_29197 = inst_29277;
var state_29324__$1 = (function (){var statearr_29341 = state_29324;
(statearr_29341[(13)] = inst_29276);

(statearr_29341[(8)] = inst_29197);

return statearr_29341;
})();
var statearr_29342_29415 = state_29324__$1;
(statearr_29342_29415[(2)] = null);

(statearr_29342_29415[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29325 === (13))){
var inst_29212 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_29213 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_29214 = cljs.core.PersistentHashMap.fromArrays(inst_29212,inst_29213);
var inst_29215 = cljs.core.ex_info.call(null,"Aborted operations",inst_29214);
var state_29324__$1 = state_29324;
var statearr_29343_29416 = state_29324__$1;
(statearr_29343_29416[(2)] = inst_29215);

(statearr_29343_29416[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29325 === (22))){
var inst_29226 = (state_29324[(14)]);
var inst_29232 = (state_29324[(2)]);
var inst_29233 = cljs.core.nth.call(null,inst_29232,(0),null);
var inst_29234 = cljs.core.nth.call(null,inst_29232,(1),null);
var inst_29235 = cljs.core._EQ_.call(null,inst_29234,inst_29226);
var state_29324__$1 = (function (){var statearr_29344 = state_29324;
(statearr_29344[(15)] = inst_29233);

return statearr_29344;
})();
if(inst_29235){
var statearr_29345_29417 = state_29324__$1;
(statearr_29345_29417[(1)] = (23));

} else {
var statearr_29346_29418 = state_29324__$1;
(statearr_29346_29418[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29325 === (36))){
var state_29324__$1 = state_29324;
var statearr_29347_29419 = state_29324__$1;
(statearr_29347_29419[(2)] = null);

(statearr_29347_29419[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29325 === (41))){
var inst_29310 = (state_29324[(2)]);
var inst_29311 = superv.async.throw_if_exception.call(null,S,inst_29310);
var state_29324__$1 = state_29324;
var statearr_29348_29420 = state_29324__$1;
(statearr_29348_29420[(2)] = inst_29311);

(statearr_29348_29420[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29325 === (29))){
var inst_29282 = (state_29324[(2)]);
var state_29324__$1 = state_29324;
var statearr_29349_29421 = state_29324__$1;
(statearr_29349_29421[(2)] = inst_29282);

(statearr_29349_29421[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29325 === (6))){
var state_29324__$1 = state_29324;
var statearr_29350_29422 = state_29324__$1;
(statearr_29350_29422[(2)] = null);

(statearr_29350_29422[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29325 === (28))){
var inst_29249 = (state_29324[(10)]);
var inst_29197 = inst_29249;
var state_29324__$1 = (function (){var statearr_29351 = state_29324;
(statearr_29351[(8)] = inst_29197);

return statearr_29351;
})();
var statearr_29352_29423 = state_29324__$1;
(statearr_29352_29423[(2)] = null);

(statearr_29352_29423[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29325 === (25))){
var inst_29245 = (state_29324[(2)]);
var inst_29246 = superv.async.throw_if_exception.call(null,S,inst_29245);
var inst_29247 = cljs.core.async.close_BANG_.call(null,out_ch__$1);
var state_29324__$1 = (function (){var statearr_29353 = state_29324;
(statearr_29353[(16)] = inst_29246);

return statearr_29353;
})();
var statearr_29354_29424 = state_29324__$1;
(statearr_29354_29424[(2)] = inst_29247);

(statearr_29354_29424[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29325 === (34))){
var inst_29273 = (state_29324[(2)]);
var state_29324__$1 = state_29324;
var statearr_29355_29425 = state_29324__$1;
(statearr_29355_29425[(2)] = inst_29273);

(statearr_29355_29425[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29325 === (17))){
var inst_29197 = (state_29324[(8)]);
var inst_29286 = cljs.core.not_empty.call(null,inst_29197);
var state_29324__$1 = state_29324;
if(cljs.core.truth_(inst_29286)){
var statearr_29356_29426 = state_29324__$1;
(statearr_29356_29426[(1)] = (35));

} else {
var statearr_29357_29427 = state_29324__$1;
(statearr_29357_29427[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29325 === (3))){
var inst_29322 = (state_29324[(2)]);
var state_29324__$1 = state_29324;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29324__$1,inst_29322);
} else {
if((state_val_29325 === (12))){
var inst_29202 = (state_29324[(17)]);
var inst_29207 = (state_29324[(2)]);
var inst_29208 = cljs.core.nth.call(null,inst_29207,(0),null);
var inst_29209 = cljs.core.nth.call(null,inst_29207,(1),null);
var inst_29210 = cljs.core._EQ_.call(null,inst_29209,inst_29202);
var state_29324__$1 = (function (){var statearr_29358 = state_29324;
(statearr_29358[(18)] = inst_29208);

return statearr_29358;
})();
if(inst_29210){
var statearr_29359_29428 = state_29324__$1;
(statearr_29359_29428[(1)] = (13));

} else {
var statearr_29360_29429 = state_29324__$1;
(statearr_29360_29429[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29325 === (2))){
var _ = (function (){var statearr_29361 = state_29324;
(statearr_29361[(4)] = cljs.core.cons.call(null,(4),(state_29324[(4)])));

return statearr_29361;
})();
var ___$1 = (function (){var statearr_29362 = state_29324;
(statearr_29362[(4)] = cljs.core.cons.call(null,(9),(state_29324[(4)])));

return statearr_29362;
})();
var inst_29196 = cljs.core.PersistentVector.EMPTY;
var inst_29197 = inst_29196;
var state_29324__$1 = (function (){var statearr_29363 = state_29324;
(statearr_29363[(8)] = inst_29197);

return statearr_29363;
})();
var statearr_29364_29430 = state_29324__$1;
(statearr_29364_29430[(2)] = null);

(statearr_29364_29430[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29325 === (23))){
var inst_29237 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_29238 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_29239 = cljs.core.PersistentHashMap.fromArrays(inst_29237,inst_29238);
var inst_29240 = cljs.core.ex_info.call(null,"Aborted operations",inst_29239);
var state_29324__$1 = state_29324;
var statearr_29365_29431 = state_29324__$1;
(statearr_29365_29431[(2)] = inst_29240);

(statearr_29365_29431[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29325 === (35))){
var inst_29291 = (state_29324[(19)]);
var inst_29291__$1 = superv.async._abort.call(null,S);
var inst_29292 = cljs.core.async.timeout.call(null,(0));
var inst_29293 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29294 = [inst_29291__$1,inst_29292];
var inst_29295 = (new cljs.core.PersistentVector(null,2,(5),inst_29293,inst_29294,null));
var state_29324__$1 = (function (){var statearr_29366 = state_29324;
(statearr_29366[(19)] = inst_29291__$1);

return statearr_29366;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_29324__$1,(38),inst_29295,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_29325 === (19))){
var inst_29226 = (state_29324[(14)]);
var inst_29226__$1 = superv.async._abort.call(null,S);
var inst_29227 = cljs.core.async.timeout.call(null,(0));
var inst_29228 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29229 = [inst_29226__$1,inst_29227];
var inst_29230 = (new cljs.core.PersistentVector(null,2,(5),inst_29228,inst_29229,null));
var state_29324__$1 = (function (){var statearr_29368 = state_29324;
(statearr_29368[(14)] = inst_29226__$1);

return statearr_29368;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_29324__$1,(22),inst_29230,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_29325 === (11))){
var inst_29319 = (state_29324[(2)]);
var _ = (function (){var statearr_29369 = state_29324;
(statearr_29369[(4)] = cljs.core.rest.call(null,(state_29324[(4)])));

return statearr_29369;
})();
var state_29324__$1 = state_29324;
var statearr_29370_29432 = state_29324__$1;
(statearr_29370_29432[(2)] = inst_29319);

(statearr_29370_29432[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29325 === (9))){
var _ = (function (){var statearr_29371 = state_29324;
(statearr_29371[(4)] = cljs.core.rest.call(null,(state_29324[(4)])));

return statearr_29371;
})();
var state_29324__$1 = state_29324;
var ex29367 = (state_29324__$1[(2)]);
var statearr_29372_29433 = state_29324__$1;
(statearr_29372_29433[(5)] = ex29367);


if((ex29367 instanceof Error)){
var statearr_29373_29434 = state_29324__$1;
(statearr_29373_29434[(1)] = (5));

(statearr_29373_29434[(5)] = null);

} else {
throw ex29367;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29325 === (5))){
var inst_29181 = (state_29324[(7)]);
var inst_29181__$1 = (state_29324[(2)]);
var inst_29182 = cljs.core.ex_data.call(null,inst_29181__$1);
var inst_29183 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_29182);
var inst_29184 = cljs.core._EQ_.call(null,inst_29183,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_29324__$1 = (function (){var statearr_29374 = state_29324;
(statearr_29374[(7)] = inst_29181__$1);

return statearr_29374;
})();
if(inst_29184){
var statearr_29375_29435 = state_29324__$1;
(statearr_29375_29435[(1)] = (6));

} else {
var statearr_29376_29436 = state_29324__$1;
(statearr_29376_29436[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29325 === (14))){
var inst_29208 = (state_29324[(18)]);
var state_29324__$1 = state_29324;
var statearr_29377_29437 = state_29324__$1;
(statearr_29377_29437[(2)] = inst_29208);

(statearr_29377_29437[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29325 === (26))){
var inst_29243 = (state_29324[(2)]);
var state_29324__$1 = state_29324;
var statearr_29378_29438 = state_29324__$1;
(statearr_29378_29438[(2)] = inst_29243);

(statearr_29378_29438[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29325 === (16))){
var inst_29219 = (state_29324[(9)]);
var inst_29221 = (inst_29219 instanceof Error);
var state_29324__$1 = state_29324;
if(cljs.core.truth_(inst_29221)){
var statearr_29379_29439 = state_29324__$1;
(statearr_29379_29439[(1)] = (19));

} else {
var statearr_29380_29440 = state_29324__$1;
(statearr_29380_29440[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29325 === (38))){
var inst_29291 = (state_29324[(19)]);
var inst_29297 = (state_29324[(2)]);
var inst_29298 = cljs.core.nth.call(null,inst_29297,(0),null);
var inst_29299 = cljs.core.nth.call(null,inst_29297,(1),null);
var inst_29300 = cljs.core._EQ_.call(null,inst_29299,inst_29291);
var state_29324__$1 = (function (){var statearr_29381 = state_29324;
(statearr_29381[(20)] = inst_29298);

return statearr_29381;
})();
if(inst_29300){
var statearr_29382_29441 = state_29324__$1;
(statearr_29382_29441[(1)] = (39));

} else {
var statearr_29383_29442 = state_29324__$1;
(statearr_29383_29442[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29325 === (30))){
var inst_29256 = (state_29324[(11)]);
var inst_29262 = (state_29324[(2)]);
var inst_29263 = cljs.core.nth.call(null,inst_29262,(0),null);
var inst_29264 = cljs.core.nth.call(null,inst_29262,(1),null);
var inst_29265 = cljs.core._EQ_.call(null,inst_29264,inst_29256);
var state_29324__$1 = (function (){var statearr_29384 = state_29324;
(statearr_29384[(21)] = inst_29263);

return statearr_29384;
})();
if(inst_29265){
var statearr_29385_29443 = state_29324__$1;
(statearr_29385_29443[(1)] = (31));

} else {
var statearr_29386_29444 = state_29324__$1;
(statearr_29386_29444[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29325 === (10))){
var inst_29202 = (state_29324[(17)]);
var inst_29202__$1 = superv.async._abort.call(null,S);
var inst_29203 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29204 = [inst_29202__$1,in_ch];
var inst_29205 = (new cljs.core.PersistentVector(null,2,(5),inst_29203,inst_29204,null));
var state_29324__$1 = (function (){var statearr_29387 = state_29324;
(statearr_29387[(17)] = inst_29202__$1);

return statearr_29387;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_29324__$1,(12),inst_29205,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_29325 === (18))){
var inst_29317 = (state_29324[(2)]);
var state_29324__$1 = state_29324;
var statearr_29388_29445 = state_29324__$1;
(statearr_29388_29445[(2)] = inst_29317);

(statearr_29388_29445[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29325 === (42))){
var inst_29308 = (state_29324[(2)]);
var state_29324__$1 = state_29324;
var statearr_29389_29446 = state_29324__$1;
(statearr_29389_29446[(2)] = inst_29308);

(statearr_29389_29446[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29325 === (37))){
var inst_29314 = (state_29324[(2)]);
var inst_29315 = cljs.core.async.close_BANG_.call(null,out_ch__$1);
var state_29324__$1 = (function (){var statearr_29390 = state_29324;
(statearr_29390[(22)] = inst_29314);

return statearr_29390;
})();
var statearr_29391_29447 = state_29324__$1;
(statearr_29391_29447[(2)] = inst_29315);

(statearr_29391_29447[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29325 === (8))){
var inst_29181 = (state_29324[(7)]);
var inst_29189 = (state_29324[(2)]);
var state_29324__$1 = (function (){var statearr_29392 = state_29324;
(statearr_29392[(23)] = inst_29189);

return statearr_29392;
})();
var statearr_29393_29448 = state_29324__$1;
(statearr_29393_29448[(2)] = inst_29181);

(statearr_29393_29448[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var superv$async$state_machine__21468__auto__ = null;
var superv$async$state_machine__21468__auto____0 = (function (){
var statearr_29394 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29394[(0)] = superv$async$state_machine__21468__auto__);

(statearr_29394[(1)] = (1));

return statearr_29394;
});
var superv$async$state_machine__21468__auto____1 = (function (state_29324){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_29324);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e29395){var ex__21471__auto__ = e29395;
var statearr_29396_29449 = state_29324;
(statearr_29396_29449[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_29324[(4)]))){
var statearr_29397_29450 = state_29324;
(statearr_29397_29450[(1)] = cljs.core.first.call(null,(state_29324[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29451 = state_29324;
state_29324 = G__29451;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
superv$async$state_machine__21468__auto__ = function(state_29324){
switch(arguments.length){
case 0:
return superv$async$state_machine__21468__auto____0.call(this);
case 1:
return superv$async$state_machine__21468__auto____1.call(this,state_29324);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__21468__auto____0;
superv$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__21468__auto____1;
return superv$async$state_machine__21468__auto__;
})()
})();
var state__21594__auto__ = (function (){var statearr_29398 = f__21593__auto__.call(null);
(statearr_29398[(6)] = c__21592__auto___29404);

return statearr_29398;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
}));


return out_ch__$1;
}));

(superv.async.partition_all_GT__GT_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(superv.async.partition_all_GT__GT_.cljs$lang$applyTo = (function (seq29170){
var G__29171 = cljs.core.first.call(null,seq29170);
var seq29170__$1 = cljs.core.next.call(null,seq29170);
var G__29172 = cljs.core.first.call(null,seq29170__$1);
var seq29170__$2 = cljs.core.next.call(null,seq29170__$1);
var G__29173 = cljs.core.first.call(null,seq29170__$2);
var seq29170__$3 = cljs.core.next.call(null,seq29170__$2);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29171,G__29172,G__29173,seq29170__$3);
}));

/**
 * Counts items in a channel. Returns a channel with the item count.
 */
superv.async.count_GT_ = (function superv$async$count_GT_(S,ch){
return cljs.core.async.reduce.call(null,(function (acc,obj){
if((obj instanceof Error)){
return superv.async.put_QMARK_.call(null,S,superv.async._error.call(null,S),obj);
} else {
return (acc + (1));
}
}),(0),ch);
});
/**
 * Debounces channel. Forwards first item from input channel to output
 *   immediately. After that one item every interval ms (if any). If there are more
 *   items in between, they are dropped.
 */
superv.async.debounce_GT__GT_ = (function superv$async$debounce_GT__GT_(S,ch,interval){
var out = cljs.core.async.chan.call(null);
var c__14578__auto___29640 = superv.async.check_supervisor.call(null,superv.async.S);
var id__14579__auto___29641 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"last-val","last-val",-1727586789,null),null], null),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),cljs.core.list(new cljs.core.Symbol(null,"or","or",1876275696,null),new cljs.core.Symbol(null,"last-val","last-val",-1727586789,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))),new cljs.core.Symbol(null,"timer","timer",373563788,null),cljs.core.list(new cljs.core.Symbol("async","timeout","async/timeout",1951904349,null),new cljs.core.Symbol(null,"interval","interval",-945940352,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.Symbol(null,"val","val",1769233139,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out","out",729986010,null)),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"new-val","new-val",902372928,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null),cljs.core.list(new cljs.core.Symbol(null,"alts?","alts?",1625745590,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"timer","timer",373563788,null)], null))], null),cljs.core.list(new cljs.core.Symbol(null,"condp","condp",1054325175,null),new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"timer","timer",373563788,null),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"val","val",1769233139,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)))))))));
var c__21592__auto___29642 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = (function (state_29579){
var state_val_29580 = (state_29579[(1)]);
if((state_val_29580 === (7))){
var inst_29457 = (state_29579[(7)]);
var inst_29463 = superv.async._track_exception.call(null,S,inst_29457);
var state_29579__$1 = state_29579;
var statearr_29581_29643 = state_29579__$1;
(statearr_29581_29643[(2)] = inst_29463);

(statearr_29581_29643[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29580 === (20))){
var inst_29499 = (state_29579[(8)]);
var inst_29510 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29511 = superv.async._abort.call(null,S);
var inst_29512 = [inst_29511];
var inst_29513 = (new cljs.core.PersistentVector(null,1,(5),inst_29510,inst_29512,null));
var inst_29514 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29515 = [ch,inst_29499];
var inst_29516 = (new cljs.core.PersistentVector(null,2,(5),inst_29514,inst_29515,null));
var inst_29517 = cljs.core.concat.call(null,inst_29513,inst_29516);
var state_29579__$1 = state_29579;
return cljs.core.async.ioc_alts_BANG_.call(null,state_29579__$1,(22),inst_29517);
} else {
if((state_val_29580 === (27))){
var inst_29548 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_29549 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_29550 = cljs.core.PersistentHashMap.fromArrays(inst_29548,inst_29549);
var inst_29551 = cljs.core.ex_info.call(null,"Aborted operations",inst_29550);
var state_29579__$1 = state_29579;
var statearr_29582_29644 = state_29579__$1;
(statearr_29582_29644[(2)] = inst_29551);

(statearr_29582_29644[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29580 === (1))){
var state_29579__$1 = state_29579;
var statearr_29583_29645 = state_29579__$1;
(statearr_29583_29645[(2)] = null);

(statearr_29583_29645[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29580 === (24))){
var inst_29531 = (state_29579[(9)]);
var inst_29527 = (state_29579[(10)]);
var inst_29560 = inst_29531.call(null,inst_29527,inst_29527);
var state_29579__$1 = state_29579;
if(cljs.core.truth_(inst_29560)){
var statearr_29584_29646 = state_29579__$1;
(statearr_29584_29646[(1)] = (31));

} else {
var statearr_29585_29647 = state_29579__$1;
(statearr_29585_29647[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29580 === (4))){
var _ = (function (){var statearr_29586 = state_29579;
(statearr_29586[(4)] = cljs.core.rest.call(null,(state_29579[(4)])));

return statearr_29586;
})();
var inst_29453 = (state_29579[(2)]);
var inst_29454 = superv.async._unregister_go.call(null,S,id__14579__auto___29641);
var ___$1 = (function (){var temp__5804__auto__ = (state_29579[(5)]);
if(cljs.core.truth_(temp__5804__auto__)){
var e__20700__auto__ = temp__5804__auto__;
throw e__20700__auto__;
} else {
return null;
}
})();
var state_29579__$1 = (function (){var statearr_29587 = state_29579;
(statearr_29587[(11)] = inst_29454);

return statearr_29587;
})();
var statearr_29588_29648 = state_29579__$1;
(statearr_29588_29648[(2)] = inst_29453);

(statearr_29588_29648[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29580 === (15))){
var inst_29479 = (state_29579[(12)]);
var inst_29484 = (state_29579[(2)]);
var inst_29485 = cljs.core.nth.call(null,inst_29484,(0),null);
var inst_29486 = cljs.core.nth.call(null,inst_29484,(1),null);
var inst_29487 = cljs.core._EQ_.call(null,inst_29486,inst_29479);
var state_29579__$1 = (function (){var statearr_29589 = state_29579;
(statearr_29589[(13)] = inst_29485);

return statearr_29589;
})();
if(inst_29487){
var statearr_29590_29649 = state_29579__$1;
(statearr_29590_29649[(1)] = (16));

} else {
var statearr_29591_29650 = state_29579__$1;
(statearr_29591_29650[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29580 === (21))){
var inst_29572 = (state_29579[(2)]);
var state_29579__$1 = state_29579;
var statearr_29592_29651 = state_29579__$1;
(statearr_29592_29651[(2)] = inst_29572);

(statearr_29592_29651[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29580 === (31))){
var inst_29526 = (state_29579[(14)]);
var inst_29472 = inst_29526;
var state_29579__$1 = (function (){var statearr_29593 = state_29579;
(statearr_29593[(15)] = inst_29472);

return statearr_29593;
})();
var statearr_29594_29652 = state_29579__$1;
(statearr_29594_29652[(2)] = null);

(statearr_29594_29652[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29580 === (32))){
var inst_29527 = (state_29579[(10)]);
var inst_29564 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29527)].join('');
var inst_29565 = (new Error(inst_29564));
var inst_29566 = (function(){throw inst_29565})();
var state_29579__$1 = state_29579;
var statearr_29595_29653 = state_29579__$1;
(statearr_29595_29653[(2)] = inst_29566);

(statearr_29595_29653[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29580 === (33))){
var inst_29568 = (state_29579[(2)]);
var state_29579__$1 = state_29579;
var statearr_29596_29654 = state_29579__$1;
(statearr_29596_29654[(2)] = inst_29568);

(statearr_29596_29654[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29580 === (13))){
var inst_29479 = (state_29579[(12)]);
var inst_29479__$1 = superv.async._abort.call(null,S);
var inst_29480 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29481 = [inst_29479__$1,ch];
var inst_29482 = (new cljs.core.PersistentVector(null,2,(5),inst_29480,inst_29481,null));
var state_29579__$1 = (function (){var statearr_29597 = state_29579;
(statearr_29597[(12)] = inst_29479__$1);

return statearr_29597;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_29579__$1,(15),inst_29482,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_29580 === (22))){
var inst_29531 = (state_29579[(9)]);
var inst_29499 = (state_29579[(8)]);
var inst_29527 = (state_29579[(10)]);
var inst_29519 = (state_29579[(2)]);
var inst_29520 = cljs.core.nth.call(null,inst_29519,(0),null);
var inst_29521 = cljs.core.nth.call(null,inst_29519,(1),null);
var inst_29522 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29523 = superv.async.throw_if_exception.call(null,S,inst_29520);
var inst_29524 = [inst_29523,inst_29521];
var inst_29525 = (new cljs.core.PersistentVector(null,2,(5),inst_29522,inst_29524,null));
var inst_29526 = cljs.core.nth.call(null,inst_29525,(0),null);
var inst_29527__$1 = cljs.core.nth.call(null,inst_29525,(1),null);
var inst_29531__$1 = cljs.core._EQ_;
var inst_29532 = inst_29531__$1.call(null,inst_29499,inst_29527__$1);
var state_29579__$1 = (function (){var statearr_29598 = state_29579;
(statearr_29598[(14)] = inst_29526);

(statearr_29598[(10)] = inst_29527__$1);

(statearr_29598[(9)] = inst_29531__$1);

return statearr_29598;
})();
if(cljs.core.truth_(inst_29532)){
var statearr_29599_29655 = state_29579__$1;
(statearr_29599_29655[(1)] = (23));

} else {
var statearr_29600_29656 = state_29579__$1;
(statearr_29600_29656[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29580 === (29))){
var inst_29556 = (state_29579[(2)]);
var inst_29557 = superv.async.throw_if_exception.call(null,S,inst_29556);
var inst_29472 = null;
var state_29579__$1 = (function (){var statearr_29601 = state_29579;
(statearr_29601[(16)] = inst_29557);

(statearr_29601[(15)] = inst_29472);

return statearr_29601;
})();
var statearr_29602_29657 = state_29579__$1;
(statearr_29602_29657[(2)] = null);

(statearr_29602_29657[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29580 === (6))){
var state_29579__$1 = state_29579;
var statearr_29603_29658 = state_29579__$1;
(statearr_29603_29658[(2)] = null);

(statearr_29603_29658[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29580 === (28))){
var inst_29498 = (state_29579[(17)]);
var state_29579__$1 = state_29579;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29579__$1,(30),out,inst_29498);
} else {
if((state_val_29580 === (25))){
var inst_29570 = (state_29579[(2)]);
var state_29579__$1 = state_29579;
var statearr_29604_29659 = state_29579__$1;
(statearr_29604_29659[(2)] = inst_29570);

(statearr_29604_29659[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29580 === (17))){
var inst_29485 = (state_29579[(13)]);
var state_29579__$1 = state_29579;
var statearr_29605_29660 = state_29579__$1;
(statearr_29605_29660[(2)] = inst_29485);

(statearr_29605_29660[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29580 === (3))){
var inst_29577 = (state_29579[(2)]);
var state_29579__$1 = state_29579;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29579__$1,inst_29577);
} else {
if((state_val_29580 === (12))){
var inst_29472 = (state_29579[(15)]);
var state_29579__$1 = state_29579;
var statearr_29606_29661 = state_29579__$1;
(statearr_29606_29661[(2)] = inst_29472);

(statearr_29606_29661[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29580 === (2))){
var _ = (function (){var statearr_29607 = state_29579;
(statearr_29607[(4)] = cljs.core.cons.call(null,(4),(state_29579[(4)])));

return statearr_29607;
})();
var ___$1 = (function (){var statearr_29608 = state_29579;
(statearr_29608[(4)] = cljs.core.cons.call(null,(9),(state_29579[(4)])));

return statearr_29608;
})();
var inst_29472 = null;
var state_29579__$1 = (function (){var statearr_29609 = state_29579;
(statearr_29609[(15)] = inst_29472);

return statearr_29609;
})();
var statearr_29610_29662 = state_29579__$1;
(statearr_29610_29662[(2)] = null);

(statearr_29610_29662[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29580 === (23))){
var inst_29537 = (state_29579[(18)]);
var inst_29537__$1 = superv.async._abort.call(null,S);
var inst_29538 = cljs.core.async.timeout.call(null,(0));
var inst_29539 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29540 = [inst_29537__$1,inst_29538];
var inst_29541 = (new cljs.core.PersistentVector(null,2,(5),inst_29539,inst_29540,null));
var state_29579__$1 = (function (){var statearr_29611 = state_29579;
(statearr_29611[(18)] = inst_29537__$1);

return statearr_29611;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_29579__$1,(26),inst_29541,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_29580 === (19))){
var inst_29502 = cljs.core.async.close_BANG_.call(null,out);
var state_29579__$1 = state_29579;
var statearr_29613_29663 = state_29579__$1;
(statearr_29613_29663[(2)] = inst_29502);

(statearr_29613_29663[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29580 === (11))){
var inst_29574 = (state_29579[(2)]);
var _ = (function (){var statearr_29614 = state_29579;
(statearr_29614[(4)] = cljs.core.rest.call(null,(state_29579[(4)])));

return statearr_29614;
})();
var state_29579__$1 = state_29579;
var statearr_29615_29664 = state_29579__$1;
(statearr_29615_29664[(2)] = inst_29574);

(statearr_29615_29664[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29580 === (9))){
var _ = (function (){var statearr_29616 = state_29579;
(statearr_29616[(4)] = cljs.core.rest.call(null,(state_29579[(4)])));

return statearr_29616;
})();
var state_29579__$1 = state_29579;
var ex29612 = (state_29579__$1[(2)]);
var statearr_29617_29665 = state_29579__$1;
(statearr_29617_29665[(5)] = ex29612);


if((ex29612 instanceof Error)){
var statearr_29618_29666 = state_29579__$1;
(statearr_29618_29666[(1)] = (5));

(statearr_29618_29666[(5)] = null);

} else {
throw ex29612;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29580 === (5))){
var inst_29457 = (state_29579[(7)]);
var inst_29457__$1 = (state_29579[(2)]);
var inst_29458 = cljs.core.ex_data.call(null,inst_29457__$1);
var inst_29459 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_29458);
var inst_29460 = cljs.core._EQ_.call(null,inst_29459,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_29579__$1 = (function (){var statearr_29619 = state_29579;
(statearr_29619[(7)] = inst_29457__$1);

return statearr_29619;
})();
if(inst_29460){
var statearr_29620_29667 = state_29579__$1;
(statearr_29620_29667[(1)] = (6));

} else {
var statearr_29621_29668 = state_29579__$1;
(statearr_29621_29668[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29580 === (14))){
var inst_29498 = (state_29579[(17)]);
var inst_29498__$1 = (state_29579[(2)]);
var inst_29499 = cljs.core.async.timeout.call(null,interval);
var inst_29500 = (inst_29498__$1 == null);
var state_29579__$1 = (function (){var statearr_29622 = state_29579;
(statearr_29622[(17)] = inst_29498__$1);

(statearr_29622[(8)] = inst_29499);

return statearr_29622;
})();
if(cljs.core.truth_(inst_29500)){
var statearr_29623_29669 = state_29579__$1;
(statearr_29623_29669[(1)] = (19));

} else {
var statearr_29624_29670 = state_29579__$1;
(statearr_29624_29670[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29580 === (26))){
var inst_29537 = (state_29579[(18)]);
var inst_29543 = (state_29579[(2)]);
var inst_29544 = cljs.core.nth.call(null,inst_29543,(0),null);
var inst_29545 = cljs.core.nth.call(null,inst_29543,(1),null);
var inst_29546 = cljs.core._EQ_.call(null,inst_29545,inst_29537);
var state_29579__$1 = (function (){var statearr_29625 = state_29579;
(statearr_29625[(19)] = inst_29544);

return statearr_29625;
})();
if(inst_29546){
var statearr_29626_29671 = state_29579__$1;
(statearr_29626_29671[(1)] = (27));

} else {
var statearr_29627_29672 = state_29579__$1;
(statearr_29627_29672[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29580 === (16))){
var inst_29489 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_29490 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_29491 = cljs.core.PersistentHashMap.fromArrays(inst_29489,inst_29490);
var inst_29492 = cljs.core.ex_info.call(null,"Aborted operations",inst_29491);
var state_29579__$1 = state_29579;
var statearr_29628_29673 = state_29579__$1;
(statearr_29628_29673[(2)] = inst_29492);

(statearr_29628_29673[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29580 === (30))){
var inst_29554 = (state_29579[(2)]);
var state_29579__$1 = state_29579;
var statearr_29629_29674 = state_29579__$1;
(statearr_29629_29674[(2)] = inst_29554);

(statearr_29629_29674[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29580 === (10))){
var inst_29472 = (state_29579[(15)]);
var state_29579__$1 = state_29579;
if(cljs.core.truth_(inst_29472)){
var statearr_29630_29675 = state_29579__$1;
(statearr_29630_29675[(1)] = (12));

} else {
var statearr_29631_29676 = state_29579__$1;
(statearr_29631_29676[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29580 === (18))){
var inst_29495 = (state_29579[(2)]);
var inst_29496 = superv.async.throw_if_exception.call(null,S,inst_29495);
var state_29579__$1 = state_29579;
var statearr_29632_29677 = state_29579__$1;
(statearr_29632_29677[(2)] = inst_29496);

(statearr_29632_29677[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29580 === (8))){
var inst_29457 = (state_29579[(7)]);
var inst_29465 = (state_29579[(2)]);
var state_29579__$1 = (function (){var statearr_29633 = state_29579;
(statearr_29633[(20)] = inst_29465);

return statearr_29633;
})();
var statearr_29634_29678 = state_29579__$1;
(statearr_29634_29678[(2)] = inst_29457);

(statearr_29634_29678[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var superv$async$debounce_GT__GT__$_state_machine__21468__auto__ = null;
var superv$async$debounce_GT__GT__$_state_machine__21468__auto____0 = (function (){
var statearr_29635 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29635[(0)] = superv$async$debounce_GT__GT__$_state_machine__21468__auto__);

(statearr_29635[(1)] = (1));

return statearr_29635;
});
var superv$async$debounce_GT__GT__$_state_machine__21468__auto____1 = (function (state_29579){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_29579);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e29636){var ex__21471__auto__ = e29636;
var statearr_29637_29679 = state_29579;
(statearr_29637_29679[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_29579[(4)]))){
var statearr_29638_29680 = state_29579;
(statearr_29638_29680[(1)] = cljs.core.first.call(null,(state_29579[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29681 = state_29579;
state_29579 = G__29681;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
superv$async$debounce_GT__GT__$_state_machine__21468__auto__ = function(state_29579){
switch(arguments.length){
case 0:
return superv$async$debounce_GT__GT__$_state_machine__21468__auto____0.call(this);
case 1:
return superv$async$debounce_GT__GT__$_state_machine__21468__auto____1.call(this,state_29579);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$debounce_GT__GT__$_state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$debounce_GT__GT__$_state_machine__21468__auto____0;
superv$async$debounce_GT__GT__$_state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$debounce_GT__GT__$_state_machine__21468__auto____1;
return superv$async$debounce_GT__GT__$_state_machine__21468__auto__;
})()
})();
var state__21594__auto__ = (function (){var statearr_29639 = f__21593__auto__.call(null);
(statearr_29639[(6)] = c__21592__auto___29642);

return statearr_29639;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
}));


return out;
});
/**
 * Safely managed tap. The channel is closed on abortion and all
 *   pending puts are flushed.
 */
superv.async.tap = (function superv$async$tap(var_args){
var G__29683 = arguments.length;
switch (G__29683) {
case 3:
return superv.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.tap.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(superv.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (S,mult,ch){
return superv.async.tap.call(null,S,mult,ch,false);
}));

(superv.async.tap.cljs$core$IFn$_invoke$arity$4 = (function (S,mult,ch,close_QMARK_){
var c__14578__auto___29846 = superv.async.check_supervisor.call(null,superv.async.S);
var id__14579__auto___29847 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core.async","<!","clojure.core.async/<!",901491658,null),cljs.core.list(new cljs.core.Symbol("superv.async","-abort","superv.async/-abort",-365058004,null),new cljs.core.Symbol(null,"S","S",-1387142461,null))),cljs.core.list(new cljs.core.Symbol(null,"close!","close!",-438778971,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)),cljs.core.list(new cljs.core.Symbol(null,"go-try","go-try",1412345407,null),cljs.core.list(new cljs.core.Symbol(null,"while","while",-1691317983,null),cljs.core.list(new cljs.core.Symbol(null,"<!","<!",-1961915773,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))))));
var c__21592__auto___29848 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = (function (state_29774){
var state_val_29775 = (state_29774[(1)]);
if((state_val_29775 === (7))){
var inst_29689 = (state_29774[(7)]);
var inst_29695 = superv.async._track_exception.call(null,S,inst_29689);
var state_29774__$1 = state_29774;
var statearr_29776_29849 = state_29774__$1;
(statearr_29776_29849[(2)] = inst_29695);

(statearr_29776_29849[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29775 === (1))){
var state_29774__$1 = state_29774;
var statearr_29777_29850 = state_29774__$1;
(statearr_29777_29850[(2)] = null);

(statearr_29777_29850[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29775 === (4))){
var _ = (function (){var statearr_29778 = state_29774;
(statearr_29778[(4)] = cljs.core.rest.call(null,(state_29774[(4)])));

return statearr_29778;
})();
var inst_29685 = (state_29774[(2)]);
var inst_29686 = superv.async._unregister_go.call(null,S,id__14579__auto___29847);
var ___$1 = (function (){var temp__5804__auto__ = (state_29774[(5)]);
if(cljs.core.truth_(temp__5804__auto__)){
var e__20700__auto__ = temp__5804__auto__;
throw e__20700__auto__;
} else {
return null;
}
})();
var state_29774__$1 = (function (){var statearr_29779 = state_29774;
(statearr_29779[(8)] = inst_29686);

return statearr_29779;
})();
var statearr_29780_29851 = state_29774__$1;
(statearr_29780_29851[(2)] = inst_29685);

(statearr_29780_29851[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29775 === (15))){
var state_29774__$1 = state_29774;
var statearr_29781_29852 = state_29774__$1;
(statearr_29781_29852[(2)] = null);

(statearr_29781_29852[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29775 === (13))){
var inst_29711 = (state_29774[(2)]);
var state_29774__$1 = state_29774;
if(cljs.core.truth_(inst_29711)){
var statearr_29782_29853 = state_29774__$1;
(statearr_29782_29853[(1)] = (14));

} else {
var statearr_29783_29854 = state_29774__$1;
(statearr_29783_29854[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29775 === (6))){
var state_29774__$1 = state_29774;
var statearr_29784_29855 = state_29774__$1;
(statearr_29784_29855[(2)] = null);

(statearr_29784_29855[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29775 === (3))){
var inst_29772 = (state_29774[(2)]);
var state_29774__$1 = state_29774;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29774__$1,inst_29772);
} else {
if((state_val_29775 === (12))){
var inst_29708 = (state_29774[(9)]);
var inst_29718 = (state_29774[(2)]);
var inst_29719 = null;
var inst_29720 = superv.async._register_go.call(null,inst_29718,inst_29719);
var inst_29767 = cljs.core.async.chan.call(null,(1));
var inst_29768 = (function (){var c__14578__auto____$1 = inst_29708;
var id__14579__auto____$1 = inst_29720;
var c__21592__auto____$1 = inst_29767;
return (function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = (function (state_29765){
var state_val_29766 = (state_29765[(1)]);
if((state_val_29766 === (7))){
var inst_29725 = (state_29765[(2)]);
var state_29765__$1 = state_29765;
if(cljs.core.truth_(inst_29725)){
var statearr_29785_29856 = state_29765__$1;
(statearr_29785_29856[(1)] = (8));

} else {
var statearr_29786_29857 = state_29765__$1;
(statearr_29786_29857[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (20))){
var inst_29749 = (state_29765[(2)]);
var state_29765__$1 = state_29765;
var statearr_29787_29858 = state_29765__$1;
(statearr_29787_29858[(2)] = inst_29749);

(statearr_29787_29858[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (1))){
var state_29765__$1 = state_29765;
var statearr_29788_29859 = state_29765__$1;
(statearr_29788_29859[(2)] = null);

(statearr_29788_29859[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (4))){
var _ = (function (){var statearr_29790 = state_29765;
(statearr_29790[(4)] = cljs.core.rest.call(null,(state_29765[(4)])));

return statearr_29790;
})();
var inst_29722 = (state_29765[(2)]);
var state_29765__$1 = (function (){var statearr_29791 = state_29765;
(statearr_29791[(7)] = inst_29722);

return statearr_29791;
})();
var statearr_29792_29860 = state_29765__$1;
(statearr_29792_29860[(2)] = null);

(statearr_29792_29860[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (15))){
var state_29765__$1 = state_29765;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29765__$1,(17),ch);
} else {
if((state_val_29766 === (21))){
var _ = (function (){var statearr_29793 = state_29765;
(statearr_29793[(4)] = cljs.core.rest.call(null,(state_29765[(4)])));

return statearr_29793;
})();
var state_29765__$1 = state_29765;
var ex29789 = (state_29765__$1[(2)]);
var statearr_29794_29861 = state_29765__$1;
(statearr_29794_29861[(5)] = ex29789);


if((ex29789 instanceof Error)){
var statearr_29795_29862 = state_29765__$1;
(statearr_29795_29862[(1)] = (11));

(statearr_29795_29862[(5)] = null);

} else {
throw ex29789;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (13))){
var state_29765__$1 = state_29765;
var statearr_29796_29863 = state_29765__$1;
(statearr_29796_29863[(2)] = null);

(statearr_29796_29863[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (6))){
var inst_29722 = (state_29765[(7)]);
var inst_29732 = (state_29765[(2)]);
var inst_29733 = superv.async._unregister_go.call(null,inst_29732,id__14579__auto____$1);
var _ = (function (){var temp__5804__auto__ = (state_29765[(5)]);
if(cljs.core.truth_(temp__5804__auto__)){
var e__20700__auto__ = temp__5804__auto__;
throw e__20700__auto__;
} else {
return null;
}
})();
var state_29765__$1 = (function (){var statearr_29797 = state_29765;
(statearr_29797[(8)] = inst_29733);

return statearr_29797;
})();
var statearr_29798_29864 = state_29765__$1;
(statearr_29798_29864[(2)] = inst_29722);

(statearr_29798_29864[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (17))){
var inst_29744 = (state_29765[(2)]);
var state_29765__$1 = state_29765;
if(cljs.core.truth_(inst_29744)){
var statearr_29799_29865 = state_29765__$1;
(statearr_29799_29865[(1)] = (18));

} else {
var statearr_29800_29866 = state_29765__$1;
(statearr_29800_29866[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (3))){
var inst_29763 = (state_29765[(2)]);
var state_29765__$1 = state_29765;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29765__$1,inst_29763);
} else {
if((state_val_29766 === (12))){
var state_29765__$1 = state_29765;
var statearr_29801_29867 = state_29765__$1;
(statearr_29801_29867[(2)] = null);

(statearr_29801_29867[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (2))){
var _ = (function (){var statearr_29802 = state_29765;
(statearr_29802[(4)] = cljs.core.cons.call(null,(4),(state_29765[(4)])));

return statearr_29802;
})();
var ___$1 = (function (){var statearr_29803 = state_29765;
(statearr_29803[(4)] = cljs.core.cons.call(null,(21),(state_29765[(4)])));

return statearr_29803;
})();
var ___$2 = (function (){var statearr_29804 = state_29765;
(statearr_29804[(4)] = cljs.core.rest.call(null,(state_29765[(4)])));

return statearr_29804;
})();
var state_29765__$1 = state_29765;
var statearr_29805_29868 = state_29765__$1;
(statearr_29805_29868[(2)] = null);

(statearr_29805_29868[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (19))){
var state_29765__$1 = state_29765;
var statearr_29806_29869 = state_29765__$1;
(statearr_29806_29869[(2)] = null);

(statearr_29806_29869[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (11))){
var inst_29736 = (state_29765[(9)]);
var inst_29736__$1 = (state_29765[(2)]);
var inst_29737 = cljs.core.ex_data.call(null,inst_29736__$1);
var inst_29738 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_29737);
var inst_29739 = cljs.core._EQ_.call(null,inst_29738,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_29765__$1 = (function (){var statearr_29807 = state_29765;
(statearr_29807[(9)] = inst_29736__$1);

return statearr_29807;
})();
if(inst_29739){
var statearr_29808_29870 = state_29765__$1;
(statearr_29808_29870[(1)] = (12));

} else {
var statearr_29809_29871 = state_29765__$1;
(statearr_29809_29871[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (9))){
var state_29765__$1 = state_29765;
var statearr_29810_29872 = state_29765__$1;
(statearr_29810_29872[(2)] = null);

(statearr_29810_29872[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (5))){
var state_29765__$1 = state_29765;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29765__$1,(7),ch);
} else {
if((state_val_29766 === (14))){
var inst_29736 = (state_29765[(9)]);
var inst_29754 = (state_29765[(2)]);
var state_29765__$1 = (function (){var statearr_29811 = state_29765;
(statearr_29811[(10)] = inst_29754);

return statearr_29811;
})();
var statearr_29812_29873 = state_29765__$1;
(statearr_29812_29873[(2)] = inst_29736);

(statearr_29812_29873[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (16))){
var inst_29736 = (state_29765[(9)]);
var inst_29751 = (state_29765[(2)]);
var inst_29752 = superv.async._track_exception.call(null,inst_29751,inst_29736);
var state_29765__$1 = state_29765;
var statearr_29813_29874 = state_29765__$1;
(statearr_29813_29874[(2)] = inst_29752);

(statearr_29813_29874[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (10))){
var inst_29730 = (state_29765[(2)]);
var state_29765__$1 = state_29765;
var statearr_29814_29875 = state_29765__$1;
(statearr_29814_29875[(2)] = inst_29730);

(statearr_29814_29875[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (18))){
var state_29765__$1 = state_29765;
var statearr_29815_29876 = state_29765__$1;
(statearr_29815_29876[(2)] = null);

(statearr_29815_29876[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (8))){
var state_29765__$1 = state_29765;
var statearr_29816_29877 = state_29765__$1;
(statearr_29816_29877[(2)] = null);

(statearr_29816_29877[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var superv$async$state_machine__21468__auto__ = null;
var superv$async$state_machine__21468__auto____0 = (function (){
var statearr_29817 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29817[(0)] = superv$async$state_machine__21468__auto__);

(statearr_29817[(1)] = (1));

return statearr_29817;
});
var superv$async$state_machine__21468__auto____1 = (function (state_29765){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_29765);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e29818){var ex__21471__auto__ = e29818;
var statearr_29819_29878 = state_29765;
(statearr_29819_29878[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_29765[(4)]))){
var statearr_29820_29879 = state_29765;
(statearr_29820_29879[(1)] = cljs.core.first.call(null,(state_29765[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29880 = state_29765;
state_29765 = G__29880;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
superv$async$state_machine__21468__auto__ = function(state_29765){
switch(arguments.length){
case 0:
return superv$async$state_machine__21468__auto____0.call(this);
case 1:
return superv$async$state_machine__21468__auto____1.call(this,state_29765);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__21468__auto____0;
superv$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__21468__auto____1;
return superv$async$state_machine__21468__auto__;
})()
})();
var state__21594__auto__ = (function (){var statearr_29821 = f__21593__auto__.call(null);
(statearr_29821[(6)] = c__21592__auto____$1);

return statearr_29821;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
});
})();
var inst_29769 = cljs.core.async.impl.dispatch.run.call(null,inst_29768);
var _ = (function (){var statearr_29822 = state_29774;
(statearr_29822[(4)] = cljs.core.rest.call(null,(state_29774[(4)])));

return statearr_29822;
})();
var state_29774__$1 = (function (){var statearr_29823 = state_29774;
(statearr_29823[(10)] = inst_29769);

return statearr_29823;
})();
var statearr_29824_29881 = state_29774__$1;
(statearr_29824_29881[(2)] = inst_29767);

(statearr_29824_29881[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29775 === (2))){
var _ = (function (){var statearr_29826 = state_29774;
(statearr_29826[(4)] = cljs.core.cons.call(null,(4),(state_29774[(4)])));

return statearr_29826;
})();
var ___$1 = (function (){var statearr_29827 = state_29774;
(statearr_29827[(4)] = cljs.core.cons.call(null,(9),(state_29774[(4)])));

return statearr_29827;
})();
var inst_29704 = superv.async._abort.call(null,S);
var state_29774__$1 = state_29774;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29774__$1,(10),inst_29704);
} else {
if((state_val_29775 === (11))){
var state_29774__$1 = state_29774;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29774__$1,(13),ch);
} else {
if((state_val_29775 === (9))){
var _ = (function (){var statearr_29828 = state_29774;
(statearr_29828[(4)] = cljs.core.rest.call(null,(state_29774[(4)])));

return statearr_29828;
})();
var state_29774__$1 = state_29774;
var ex29825 = (state_29774__$1[(2)]);
var statearr_29829_29882 = state_29774__$1;
(statearr_29829_29882[(5)] = ex29825);


if((ex29825 instanceof Error)){
var statearr_29830_29883 = state_29774__$1;
(statearr_29830_29883[(1)] = (5));

(statearr_29830_29883[(5)] = null);

} else {
throw ex29825;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29775 === (5))){
var inst_29689 = (state_29774[(7)]);
var inst_29689__$1 = (state_29774[(2)]);
var inst_29690 = cljs.core.ex_data.call(null,inst_29689__$1);
var inst_29691 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_29690);
var inst_29692 = cljs.core._EQ_.call(null,inst_29691,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_29774__$1 = (function (){var statearr_29831 = state_29774;
(statearr_29831[(7)] = inst_29689__$1);

return statearr_29831;
})();
if(inst_29692){
var statearr_29832_29884 = state_29774__$1;
(statearr_29832_29884[(1)] = (6));

} else {
var statearr_29833_29885 = state_29774__$1;
(statearr_29833_29885[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29775 === (14))){
var state_29774__$1 = state_29774;
var statearr_29834_29886 = state_29774__$1;
(statearr_29834_29886[(2)] = null);

(statearr_29834_29886[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29775 === (16))){
var inst_29716 = (state_29774[(2)]);
var state_29774__$1 = state_29774;
var statearr_29835_29887 = state_29774__$1;
(statearr_29835_29887[(2)] = inst_29716);

(statearr_29835_29887[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29775 === (10))){
var inst_29706 = (state_29774[(2)]);
var inst_29707 = cljs.core.async.close_BANG_.call(null,ch);
var inst_29708 = superv.async.check_supervisor.call(null,superv.async.S);
var state_29774__$1 = (function (){var statearr_29836 = state_29774;
(statearr_29836[(11)] = inst_29706);

(statearr_29836[(12)] = inst_29707);

(statearr_29836[(9)] = inst_29708);

return statearr_29836;
})();
var statearr_29837_29888 = state_29774__$1;
(statearr_29837_29888[(2)] = null);

(statearr_29837_29888[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29775 === (8))){
var inst_29689 = (state_29774[(7)]);
var inst_29697 = (state_29774[(2)]);
var state_29774__$1 = (function (){var statearr_29838 = state_29774;
(statearr_29838[(13)] = inst_29697);

return statearr_29838;
})();
var statearr_29839_29889 = state_29774__$1;
(statearr_29839_29889[(2)] = inst_29689);

(statearr_29839_29889[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var superv$async$state_machine__21468__auto__ = null;
var superv$async$state_machine__21468__auto____0 = (function (){
var statearr_29840 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29840[(0)] = superv$async$state_machine__21468__auto__);

(statearr_29840[(1)] = (1));

return statearr_29840;
});
var superv$async$state_machine__21468__auto____1 = (function (state_29774){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_29774);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e29841){var ex__21471__auto__ = e29841;
var statearr_29842_29890 = state_29774;
(statearr_29842_29890[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_29774[(4)]))){
var statearr_29843_29891 = state_29774;
(statearr_29843_29891[(1)] = cljs.core.first.call(null,(state_29774[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29892 = state_29774;
state_29774 = G__29892;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
superv$async$state_machine__21468__auto__ = function(state_29774){
switch(arguments.length){
case 0:
return superv$async$state_machine__21468__auto____0.call(this);
case 1:
return superv$async$state_machine__21468__auto____1.call(this,state_29774);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__21468__auto____0;
superv$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__21468__auto____1;
return superv$async$state_machine__21468__auto__;
})()
})();
var state__21594__auto__ = (function (){var statearr_29844 = f__21593__auto__.call(null);
(statearr_29844[(6)] = c__21592__auto___29848);

return statearr_29844;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
}));


return cljs.core.async.tap.call(null,mult,ch,close_QMARK_);
}));

(superv.async.tap.cljs$lang$maxFixedArity = 4);

/**
 * Safely managed subscription. The channel is closed on abortion and
 *   all pending puts are flushed.
 */
superv.async.sub = (function superv$async$sub(var_args){
var G__29894 = arguments.length;
switch (G__29894) {
case 4:
return superv.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return superv.async.sub.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(superv.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (S,p,topic,ch){
return superv.async.sub.call(null,S,p,topic,ch,false);
}));

(superv.async.sub.cljs$core$IFn$_invoke$arity$5 = (function (S,p,topic,ch,close_QMARK_){
var c__14578__auto___30023 = superv.async.check_supervisor.call(null,superv.async.S);
var id__14579__auto___30024 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core.async","<!","clojure.core.async/<!",901491658,null),cljs.core.list(new cljs.core.Symbol("superv.async","-abort","superv.async/-abort",-365058004,null),new cljs.core.Symbol(null,"S","S",-1387142461,null))),cljs.core.list(new cljs.core.Symbol(null,"close!","close!",-438778971,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)),cljs.core.list(new cljs.core.Symbol(null,"go-try","go-try",1412345407,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),cljs.core.list(new cljs.core.Symbol(null,"while","while",-1691317983,null),cljs.core.list(new cljs.core.Symbol(null,"<!","<!",-1961915773,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))))));
var c__21592__auto___30025 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = (function (state_29965){
var state_val_29966 = (state_29965[(1)]);
if((state_val_29966 === (7))){
var inst_29900 = (state_29965[(7)]);
var inst_29906 = superv.async._track_exception.call(null,S,inst_29900);
var state_29965__$1 = state_29965;
var statearr_29967_30026 = state_29965__$1;
(statearr_29967_30026[(2)] = inst_29906);

(statearr_29967_30026[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29966 === (1))){
var state_29965__$1 = state_29965;
var statearr_29968_30027 = state_29965__$1;
(statearr_29968_30027[(2)] = null);

(statearr_29968_30027[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29966 === (4))){
var _ = (function (){var statearr_29969 = state_29965;
(statearr_29969[(4)] = cljs.core.rest.call(null,(state_29965[(4)])));

return statearr_29969;
})();
var inst_29896 = (state_29965[(2)]);
var inst_29897 = superv.async._unregister_go.call(null,S,id__14579__auto___30024);
var ___$1 = (function (){var temp__5804__auto__ = (state_29965[(5)]);
if(cljs.core.truth_(temp__5804__auto__)){
var e__20700__auto__ = temp__5804__auto__;
throw e__20700__auto__;
} else {
return null;
}
})();
var state_29965__$1 = (function (){var statearr_29970 = state_29965;
(statearr_29970[(8)] = inst_29897);

return statearr_29970;
})();
var statearr_29971_30028 = state_29965__$1;
(statearr_29971_30028[(2)] = inst_29896);

(statearr_29971_30028[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29966 === (6))){
var state_29965__$1 = state_29965;
var statearr_29972_30029 = state_29965__$1;
(statearr_29972_30029[(2)] = null);

(statearr_29972_30029[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29966 === (3))){
var inst_29963 = (state_29965[(2)]);
var state_29965__$1 = state_29965;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29965__$1,inst_29963);
} else {
if((state_val_29966 === (2))){
var _ = (function (){var statearr_29974 = state_29965;
(statearr_29974[(4)] = cljs.core.cons.call(null,(4),(state_29965[(4)])));

return statearr_29974;
})();
var ___$1 = (function (){var statearr_29975 = state_29965;
(statearr_29975[(4)] = cljs.core.cons.call(null,(9),(state_29965[(4)])));

return statearr_29975;
})();
var inst_29915 = superv.async._abort.call(null,S);
var state_29965__$1 = state_29965;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29965__$1,(10),inst_29915);
} else {
if((state_val_29966 === (9))){
var _ = (function (){var statearr_29976 = state_29965;
(statearr_29976[(4)] = cljs.core.rest.call(null,(state_29965[(4)])));

return statearr_29976;
})();
var state_29965__$1 = state_29965;
var ex29973 = (state_29965__$1[(2)]);
var statearr_29977_30030 = state_29965__$1;
(statearr_29977_30030[(5)] = ex29973);


if((ex29973 instanceof Error)){
var statearr_29978_30031 = state_29965__$1;
(statearr_29978_30031[(1)] = (5));

(statearr_29978_30031[(5)] = null);

} else {
throw ex29973;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29966 === (5))){
var inst_29900 = (state_29965[(7)]);
var inst_29900__$1 = (state_29965[(2)]);
var inst_29901 = cljs.core.ex_data.call(null,inst_29900__$1);
var inst_29902 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_29901);
var inst_29903 = cljs.core._EQ_.call(null,inst_29902,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_29965__$1 = (function (){var statearr_29979 = state_29965;
(statearr_29979[(7)] = inst_29900__$1);

return statearr_29979;
})();
if(inst_29903){
var statearr_29980_30032 = state_29965__$1;
(statearr_29980_30032[(1)] = (6));

} else {
var statearr_29981_30033 = state_29965__$1;
(statearr_29981_30033[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29966 === (10))){
var inst_29917 = (state_29965[(2)]);
var inst_29918 = cljs.core.async.close_BANG_.call(null,ch);
var inst_29919 = superv.async.check_supervisor.call(null,superv.async.S);
var inst_29920 = cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"while","while",-1691317983,null),cljs.core.list(new cljs.core.Symbol(null,"<!","<!",-1961915773,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))));
var inst_29921 = superv.async._register_go.call(null,S,inst_29920);
var inst_29958 = cljs.core.async.chan.call(null,(1));
var inst_29959 = (function (){var c__14578__auto____$1 = inst_29919;
var id__14579__auto____$1 = inst_29921;
var c__21592__auto____$1 = inst_29958;
return (function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = (function (state_29956){
var state_val_29957 = (state_29956[(1)]);
if((state_val_29957 === (7))){
var inst_29927 = (state_29956[(7)]);
var inst_29933 = superv.async._track_exception.call(null,S,inst_29927);
var state_29956__$1 = state_29956;
var statearr_29982_30034 = state_29956__$1;
(statearr_29982_30034[(2)] = inst_29933);

(statearr_29982_30034[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29957 === (1))){
var state_29956__$1 = state_29956;
var statearr_29983_30035 = state_29956__$1;
(statearr_29983_30035[(2)] = null);

(statearr_29983_30035[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29957 === (4))){
var _ = (function (){var statearr_29984 = state_29956;
(statearr_29984[(4)] = cljs.core.rest.call(null,(state_29956[(4)])));

return statearr_29984;
})();
var inst_29923 = (state_29956[(2)]);
var inst_29924 = superv.async._unregister_go.call(null,S,id__14579__auto____$1);
var ___$1 = (function (){var temp__5804__auto__ = (state_29956[(5)]);
if(cljs.core.truth_(temp__5804__auto__)){
var e__20700__auto__ = temp__5804__auto__;
throw e__20700__auto__;
} else {
return null;
}
})();
var state_29956__$1 = (function (){var statearr_29985 = state_29956;
(statearr_29985[(8)] = inst_29924);

return statearr_29985;
})();
var statearr_29986_30036 = state_29956__$1;
(statearr_29986_30036[(2)] = inst_29923);

(statearr_29986_30036[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29957 === (15))){
var inst_29949 = (state_29956[(2)]);
var state_29956__$1 = state_29956;
var statearr_29987_30037 = state_29956__$1;
(statearr_29987_30037[(2)] = inst_29949);

(statearr_29987_30037[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29957 === (13))){
var state_29956__$1 = state_29956;
var statearr_29988_30038 = state_29956__$1;
(statearr_29988_30038[(2)] = null);

(statearr_29988_30038[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29957 === (6))){
var state_29956__$1 = state_29956;
var statearr_29989_30039 = state_29956__$1;
(statearr_29989_30039[(2)] = null);

(statearr_29989_30039[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29957 === (3))){
var inst_29954 = (state_29956[(2)]);
var state_29956__$1 = state_29956;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29956__$1,inst_29954);
} else {
if((state_val_29957 === (12))){
var inst_29944 = (state_29956[(2)]);
var state_29956__$1 = state_29956;
if(cljs.core.truth_(inst_29944)){
var statearr_29990_30040 = state_29956__$1;
(statearr_29990_30040[(1)] = (13));

} else {
var statearr_29991_30041 = state_29956__$1;
(statearr_29991_30041[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29957 === (2))){
var _ = (function (){var statearr_29993 = state_29956;
(statearr_29993[(4)] = cljs.core.cons.call(null,(4),(state_29956[(4)])));

return statearr_29993;
})();
var ___$1 = (function (){var statearr_29994 = state_29956;
(statearr_29994[(4)] = cljs.core.cons.call(null,(9),(state_29956[(4)])));

return statearr_29994;
})();
var state_29956__$1 = state_29956;
var statearr_29995_30042 = state_29956__$1;
(statearr_29995_30042[(2)] = null);

(statearr_29995_30042[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29957 === (11))){
var inst_29951 = (state_29956[(2)]);
var _ = (function (){var statearr_29996 = state_29956;
(statearr_29996[(4)] = cljs.core.rest.call(null,(state_29956[(4)])));

return statearr_29996;
})();
var state_29956__$1 = state_29956;
var statearr_29997_30043 = state_29956__$1;
(statearr_29997_30043[(2)] = inst_29951);

(statearr_29997_30043[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29957 === (9))){
var _ = (function (){var statearr_29998 = state_29956;
(statearr_29998[(4)] = cljs.core.rest.call(null,(state_29956[(4)])));

return statearr_29998;
})();
var state_29956__$1 = state_29956;
var ex29992 = (state_29956__$1[(2)]);
var statearr_29999_30044 = state_29956__$1;
(statearr_29999_30044[(5)] = ex29992);


if((ex29992 instanceof Error)){
var statearr_30000_30045 = state_29956__$1;
(statearr_30000_30045[(1)] = (5));

(statearr_30000_30045[(5)] = null);

} else {
throw ex29992;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29957 === (5))){
var inst_29927 = (state_29956[(7)]);
var inst_29927__$1 = (state_29956[(2)]);
var inst_29928 = cljs.core.ex_data.call(null,inst_29927__$1);
var inst_29929 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_29928);
var inst_29930 = cljs.core._EQ_.call(null,inst_29929,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_29956__$1 = (function (){var statearr_30001 = state_29956;
(statearr_30001[(7)] = inst_29927__$1);

return statearr_30001;
})();
if(inst_29930){
var statearr_30002_30046 = state_29956__$1;
(statearr_30002_30046[(1)] = (6));

} else {
var statearr_30003_30047 = state_29956__$1;
(statearr_30003_30047[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29957 === (14))){
var state_29956__$1 = state_29956;
var statearr_30004_30048 = state_29956__$1;
(statearr_30004_30048[(2)] = null);

(statearr_30004_30048[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29957 === (10))){
var state_29956__$1 = state_29956;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29956__$1,(12),ch);
} else {
if((state_val_29957 === (8))){
var inst_29927 = (state_29956[(7)]);
var inst_29935 = (state_29956[(2)]);
var state_29956__$1 = (function (){var statearr_30005 = state_29956;
(statearr_30005[(9)] = inst_29935);

return statearr_30005;
})();
var statearr_30006_30049 = state_29956__$1;
(statearr_30006_30049[(2)] = inst_29927);

(statearr_30006_30049[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var superv$async$state_machine__21468__auto__ = null;
var superv$async$state_machine__21468__auto____0 = (function (){
var statearr_30007 = [null,null,null,null,null,null,null,null,null,null];
(statearr_30007[(0)] = superv$async$state_machine__21468__auto__);

(statearr_30007[(1)] = (1));

return statearr_30007;
});
var superv$async$state_machine__21468__auto____1 = (function (state_29956){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_29956);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e30008){var ex__21471__auto__ = e30008;
var statearr_30009_30050 = state_29956;
(statearr_30009_30050[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_29956[(4)]))){
var statearr_30010_30051 = state_29956;
(statearr_30010_30051[(1)] = cljs.core.first.call(null,(state_29956[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30052 = state_29956;
state_29956 = G__30052;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
superv$async$state_machine__21468__auto__ = function(state_29956){
switch(arguments.length){
case 0:
return superv$async$state_machine__21468__auto____0.call(this);
case 1:
return superv$async$state_machine__21468__auto____1.call(this,state_29956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__21468__auto____0;
superv$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__21468__auto____1;
return superv$async$state_machine__21468__auto__;
})()
})();
var state__21594__auto__ = (function (){var statearr_30011 = f__21593__auto__.call(null);
(statearr_30011[(6)] = c__21592__auto____$1);

return statearr_30011;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
});
})();
var inst_29960 = cljs.core.async.impl.dispatch.run.call(null,inst_29959);
var _ = (function (){var statearr_30012 = state_29965;
(statearr_30012[(4)] = cljs.core.rest.call(null,(state_29965[(4)])));

return statearr_30012;
})();
var state_29965__$1 = (function (){var statearr_30013 = state_29965;
(statearr_30013[(9)] = inst_29917);

(statearr_30013[(10)] = inst_29918);

(statearr_30013[(11)] = inst_29960);

return statearr_30013;
})();
var statearr_30014_30053 = state_29965__$1;
(statearr_30014_30053[(2)] = inst_29958);

(statearr_30014_30053[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29966 === (8))){
var inst_29900 = (state_29965[(7)]);
var inst_29908 = (state_29965[(2)]);
var state_29965__$1 = (function (){var statearr_30015 = state_29965;
(statearr_30015[(12)] = inst_29908);

return statearr_30015;
})();
var statearr_30016_30054 = state_29965__$1;
(statearr_30016_30054[(2)] = inst_29900);

(statearr_30016_30054[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var superv$async$state_machine__21468__auto__ = null;
var superv$async$state_machine__21468__auto____0 = (function (){
var statearr_30017 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30017[(0)] = superv$async$state_machine__21468__auto__);

(statearr_30017[(1)] = (1));

return statearr_30017;
});
var superv$async$state_machine__21468__auto____1 = (function (state_29965){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_29965);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e30018){var ex__21471__auto__ = e30018;
var statearr_30019_30055 = state_29965;
(statearr_30019_30055[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_29965[(4)]))){
var statearr_30020_30056 = state_29965;
(statearr_30020_30056[(1)] = cljs.core.first.call(null,(state_29965[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30057 = state_29965;
state_29965 = G__30057;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
superv$async$state_machine__21468__auto__ = function(state_29965){
switch(arguments.length){
case 0:
return superv$async$state_machine__21468__auto____0.call(this);
case 1:
return superv$async$state_machine__21468__auto____1.call(this,state_29965);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__21468__auto____0;
superv$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__21468__auto____1;
return superv$async$state_machine__21468__auto__;
})()
})();
var state__21594__auto__ = (function (){var statearr_30021 = f__21593__auto__.call(null);
(statearr_30021[(6)] = c__21592__auto___30025);

return statearr_30021;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
}));


return cljs.core.async.sub.call(null,p,topic,ch,close_QMARK_);
}));

(superv.async.sub.cljs$lang$maxFixedArity = 5);

/**
 * Creates a supervised channel for transducer xform. Exceptions
 *   immediatly propagate to the supervisor.
 */
superv.async.chan_super = (function superv$async$chan_super(S,buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,(function (e){
return cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(S),e);
}));
});
/**
 * Starts a subsystem with supervised go-routines initialized by start-fn.
 *   Restarts the system on error for retries times with a potential delay in
 *   milliseconds, an optional error-fn predicate determining the retry and a
 *   optional filter by exception type. You can optionally pass a supervisor to
 *   form a supervision tree. Whenever this passed supervisor aborts the context,
 *   this supervisor will close as well. You still need to block on the result of
 *   this supervisor if you want a clean synchronized shutdown. The concept is
 *   similar to http://learnyousomeerlang.com/supervisors
 * 
 *   All blocking channel ops in the subroutines (supervised context) are
 *   aborted with an exception on error to force total termination. The
 *   supervisor waits until all supervised go-routines are finished and
 *   have freed resources before restarting.
 * 
 *   If exceptions are not taken from go-try channels (by error), they become stale
 *   after the stale-timeout and trigger a restart or are propagated to the parent
 *   supervisor (if available) and the return value.
 * 
 *   Note: The signature and behaviour of this function might still change.
 */
superv.async.restarting_supervisor = (function superv$async$restarting_supervisor(var_args){
var args__5732__auto__ = [];
var len__5726__auto___30525 = arguments.length;
var i__5727__auto___30526 = (0);
while(true){
if((i__5727__auto___30526 < len__5726__auto___30525)){
args__5732__auto__.push((arguments[i__5727__auto___30526]));

var G__30527 = (i__5727__auto___30526 + (1));
i__5727__auto___30526 = G__30527;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return superv.async.restarting_supervisor.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(superv.async.restarting_supervisor.cljs$core$IFn$_invoke$arity$variadic = (function (start_fn,p__30072){
var map__30073 = p__30072;
var map__30073__$1 = cljs.core.__destructure_map.call(null,map__30073);
var retries = cljs.core.get.call(null,map__30073__$1,new cljs.core.Keyword(null,"retries","retries",1888092808),Infinity);
var delay = cljs.core.get.call(null,map__30073__$1,new cljs.core.Keyword(null,"delay","delay",-574225219),(0));
var error_fn = cljs.core.get.call(null,map__30073__$1,new cljs.core.Keyword(null,"error-fn","error-fn",-171437615),null);
var exception = cljs.core.get.call(null,map__30073__$1,new cljs.core.Keyword(null,"exception","exception",-335277064),Error);
var stale_timeout = cljs.core.get.call(null,map__30073__$1,new cljs.core.Keyword(null,"stale-timeout","stale-timeout",-468804294),((60) * (1000)));
var log_fn = cljs.core.get.call(null,map__30073__$1,new cljs.core.Keyword(null,"log-fn","log-fn",-2003241282),(function (level,msg){
return cljs.core.println.call(null,level,msg);
}));
var supervisor = cljs.core.get.call(null,map__30073__$1,new cljs.core.Keyword(null,"supervisor","supervisor",-134060208));
var retries__$1 = (function (){var or__5002__auto__ = retries;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return Infinity;
}
})();
var out_ch = cljs.core.async.chan.call(null);
var c__21592__auto___30528 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = (function (state_30365){
var state_val_30366 = (state_30365[(1)]);
if((state_val_30366 === (7))){
var inst_30081 = (state_30365[(7)]);
var inst_30259 = (state_30365[(2)]);
var inst_30260 = cljs.core.nth.call(null,inst_30259,(0),null);
var inst_30261 = cljs.core.nth.call(null,inst_30259,(1),null);
var inst_30262 = cljs.core._EQ_.call(null,inst_30261,inst_30081);
var inst_30263 = (!(inst_30262));
var state_30365__$1 = (function (){var statearr_30367 = state_30365;
(statearr_30367[(8)] = inst_30260);

return statearr_30367;
})();
if(inst_30263){
var statearr_30368_30529 = state_30365__$1;
(statearr_30368_30529[(1)] = (8));

} else {
var statearr_30369_30530 = state_30365__$1;
(statearr_30369_30530[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (20))){
var inst_30285 = (state_30365[(9)]);
var inst_30294 = cljs.core.first.call(null,inst_30285);
var inst_30295 = cljs.core.async.put_BANG_.call(null,inst_30294,new cljs.core.Keyword(null,"abort","abort",521193198));
var inst_30296 = cljs.core.async.close_BANG_.call(null,inst_30294);
var inst_30297 = cljs.core.next.call(null,inst_30285);
var inst_30271 = inst_30297;
var inst_30272 = null;
var inst_30273 = (0);
var inst_30274 = (0);
var state_30365__$1 = (function (){var statearr_30370 = state_30365;
(statearr_30370[(10)] = inst_30295);

(statearr_30370[(11)] = inst_30296);

(statearr_30370[(12)] = inst_30271);

(statearr_30370[(13)] = inst_30272);

(statearr_30370[(14)] = inst_30273);

(statearr_30370[(15)] = inst_30274);

return statearr_30370;
})();
var statearr_30371_30531 = state_30365__$1;
(statearr_30371_30531[(2)] = null);

(statearr_30371_30531[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (27))){
var inst_30260 = (state_30365[(8)]);
var inst_30317 = error_fn.call(null,inst_30260);
var state_30365__$1 = state_30365;
var statearr_30372_30532 = state_30365__$1;
(statearr_30372_30532[(2)] = inst_30317);

(statearr_30372_30532[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (1))){
var inst_30074 = retries__$1;
var inst_30075 = inst_30074;
var state_30365__$1 = (function (){var statearr_30373 = state_30365;
(statearr_30373[(16)] = inst_30075);

return statearr_30373;
})();
var statearr_30374_30533 = state_30365__$1;
(statearr_30374_30533[(2)] = null);

(statearr_30374_30533[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (24))){
var inst_30314 = (state_30365[(17)]);
var inst_30314__$1 = cljs.core.not.call(null,error_fn);
var state_30365__$1 = (function (){var statearr_30375 = state_30365;
(statearr_30375[(17)] = inst_30314__$1);

return statearr_30375;
})();
if(inst_30314__$1){
var statearr_30376_30534 = state_30365__$1;
(statearr_30376_30534[(1)] = (26));

} else {
var statearr_30377_30535 = state_30365__$1;
(statearr_30377_30535[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (39))){
var inst_30357 = (state_30365[(2)]);
var inst_30358 = cljs.core.async.put_BANG_.call(null,out_ch,inst_30357);
var inst_30359 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_30365__$1 = (function (){var statearr_30378 = state_30365;
(statearr_30378[(18)] = inst_30358);

return statearr_30378;
})();
var statearr_30379_30536 = state_30365__$1;
(statearr_30379_30536[(2)] = inst_30359);

(statearr_30379_30536[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (4))){
var inst_30077 = (state_30365[(19)]);
var inst_30080 = (state_30365[(20)]);
var inst_30090 = (state_30365[(21)]);
var inst_30081 = (state_30365[(7)]);
var inst_30075 = (state_30365[(16)]);
var inst_30089 = (state_30365[(22)]);
var inst_30092 = superv.async.check_supervisor.call(null,superv.async.S);
var inst_30093 = cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core.async","<!","clojure.core.async/<!",901491658,null),cljs.core.list(new cljs.core.Symbol("superv.async","-abort","superv.async/-abort",-365058004,null),new cljs.core.Symbol(null,"supervisor","supervisor",1506471319,null))),cljs.core.list(new cljs.core.Symbol(null,"doseq","doseq",221164135,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"ab-chs","ab-chs",-2000988533,null)], null),cljs.core.list(new cljs.core.Symbol(null,"put!","put!",-531220546,null),new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Keyword(null,"abort","abort",521193198)),cljs.core.list(new cljs.core.Symbol(null,"close!","close!",-438778971,null),new cljs.core.Symbol(null,"a","a",-482876059,null))));
var inst_30094 = superv.async._register_go.call(null,supervisor,inst_30093);
var inst_30166 = cljs.core.async.chan.call(null,(1));
var inst_30167 = (function (){var stale_timeout__$1 = (1000);
var err_ch = inst_30077;
var ab_chs = inst_30080;
var res_ch = inst_30090;
var close_ch = inst_30081;
var retries__$2 = inst_30075;
var c__21592__auto____$1 = inst_30166;
var id__14579__auto__ = inst_30094;
var s = inst_30089;
var c__14578__auto__ = inst_30092;
return (function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = (function (state_30164){
var state_val_30165 = (state_30164[(1)]);
if((state_val_30165 === (7))){
var inst_30100 = (state_30164[(7)]);
var inst_30106 = superv.async._track_exception.call(null,supervisor,inst_30100);
var state_30164__$1 = state_30164;
var statearr_30380_30537 = state_30164__$1;
(statearr_30380_30537[(2)] = inst_30106);

(statearr_30380_30537[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30165 === (20))){
var inst_30137 = (state_30164[(8)]);
var inst_30146 = cljs.core.first.call(null,inst_30137);
var inst_30147 = cljs.core.async.put_BANG_.call(null,inst_30146,new cljs.core.Keyword(null,"abort","abort",521193198));
var inst_30148 = cljs.core.async.close_BANG_.call(null,inst_30146);
var inst_30149 = cljs.core.next.call(null,inst_30137);
var inst_30123 = inst_30149;
var inst_30124 = null;
var inst_30125 = (0);
var inst_30126 = (0);
var state_30164__$1 = (function (){var statearr_30381 = state_30164;
(statearr_30381[(9)] = inst_30147);

(statearr_30381[(10)] = inst_30148);

(statearr_30381[(11)] = inst_30123);

(statearr_30381[(12)] = inst_30124);

(statearr_30381[(13)] = inst_30125);

(statearr_30381[(14)] = inst_30126);

return statearr_30381;
})();
var statearr_30382_30538 = state_30164__$1;
(statearr_30382_30538[(2)] = null);

(statearr_30382_30538[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30165 === (1))){
var state_30164__$1 = state_30164;
var statearr_30383_30539 = state_30164__$1;
(statearr_30383_30539[(2)] = null);

(statearr_30383_30539[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30165 === (4))){
var _ = (function (){var statearr_30384 = state_30164;
(statearr_30384[(4)] = cljs.core.rest.call(null,(state_30164[(4)])));

return statearr_30384;
})();
var inst_30096 = (state_30164[(2)]);
var inst_30097 = superv.async._unregister_go.call(null,supervisor,id__14579__auto__);
var ___$1 = (function (){var temp__5804__auto__ = (state_30164[(5)]);
if(cljs.core.truth_(temp__5804__auto__)){
var e__20700__auto__ = temp__5804__auto__;
throw e__20700__auto__;
} else {
return null;
}
})();
var state_30164__$1 = (function (){var statearr_30385 = state_30164;
(statearr_30385[(15)] = inst_30097);

return statearr_30385;
})();
var statearr_30386_30540 = state_30164__$1;
(statearr_30386_30540[(2)] = inst_30096);

(statearr_30386_30540[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30165 === (15))){
var inst_30157 = (state_30164[(2)]);
var state_30164__$1 = state_30164;
var statearr_30390_30541 = state_30164__$1;
(statearr_30390_30541[(2)] = inst_30157);

(statearr_30390_30541[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30165 === (21))){
var inst_30152 = (state_30164[(2)]);
var state_30164__$1 = state_30164;
var statearr_30391_30542 = state_30164__$1;
(statearr_30391_30542[(2)] = inst_30152);

(statearr_30391_30542[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30165 === (13))){
var inst_30124 = (state_30164[(12)]);
var inst_30126 = (state_30164[(14)]);
var inst_30123 = (state_30164[(11)]);
var inst_30125 = (state_30164[(13)]);
var inst_30131 = cljs.core._nth.call(null,inst_30124,inst_30126);
var inst_30132 = cljs.core.async.put_BANG_.call(null,inst_30131,new cljs.core.Keyword(null,"abort","abort",521193198));
var inst_30133 = cljs.core.async.close_BANG_.call(null,inst_30131);
var inst_30134 = (inst_30126 + (1));
var tmp30387 = inst_30124;
var tmp30388 = inst_30123;
var tmp30389 = inst_30125;
var inst_30123__$1 = tmp30388;
var inst_30124__$1 = tmp30387;
var inst_30125__$1 = tmp30389;
var inst_30126__$1 = inst_30134;
var state_30164__$1 = (function (){var statearr_30392 = state_30164;
(statearr_30392[(16)] = inst_30132);

(statearr_30392[(17)] = inst_30133);

(statearr_30392[(11)] = inst_30123__$1);

(statearr_30392[(12)] = inst_30124__$1);

(statearr_30392[(13)] = inst_30125__$1);

(statearr_30392[(14)] = inst_30126__$1);

return statearr_30392;
})();
var statearr_30393_30543 = state_30164__$1;
(statearr_30393_30543[(2)] = null);

(statearr_30393_30543[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30165 === (6))){
var state_30164__$1 = state_30164;
var statearr_30394_30544 = state_30164__$1;
(statearr_30394_30544[(2)] = null);

(statearr_30394_30544[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30165 === (17))){
var state_30164__$1 = state_30164;
var statearr_30395_30545 = state_30164__$1;
(statearr_30395_30545[(2)] = null);

(statearr_30395_30545[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30165 === (3))){
var inst_30162 = (state_30164[(2)]);
var state_30164__$1 = state_30164;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30164__$1,inst_30162);
} else {
if((state_val_30165 === (12))){
var inst_30159 = (state_30164[(2)]);
var _ = (function (){var statearr_30396 = state_30164;
(statearr_30396[(4)] = cljs.core.rest.call(null,(state_30164[(4)])));

return statearr_30396;
})();
var state_30164__$1 = state_30164;
var statearr_30397_30546 = state_30164__$1;
(statearr_30397_30546[(2)] = inst_30159);

(statearr_30397_30546[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30165 === (2))){
var _ = (function (){var statearr_30398 = state_30164;
(statearr_30398[(4)] = cljs.core.cons.call(null,(4),(state_30164[(4)])));

return statearr_30398;
})();
var ___$1 = (function (){var statearr_30399 = state_30164;
(statearr_30399[(4)] = cljs.core.cons.call(null,(9),(state_30164[(4)])));

return statearr_30399;
})();
var inst_30115 = superv.async._abort.call(null,supervisor);
var state_30164__$1 = state_30164;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30164__$1,(10),inst_30115);
} else {
if((state_val_30165 === (19))){
var inst_30137 = (state_30164[(8)]);
var inst_30141 = cljs.core.chunk_first.call(null,inst_30137);
var inst_30142 = cljs.core.chunk_rest.call(null,inst_30137);
var inst_30143 = cljs.core.count.call(null,inst_30141);
var inst_30123 = inst_30142;
var inst_30124 = inst_30141;
var inst_30125 = inst_30143;
var inst_30126 = (0);
var state_30164__$1 = (function (){var statearr_30401 = state_30164;
(statearr_30401[(11)] = inst_30123);

(statearr_30401[(12)] = inst_30124);

(statearr_30401[(13)] = inst_30125);

(statearr_30401[(14)] = inst_30126);

return statearr_30401;
})();
var statearr_30402_30547 = state_30164__$1;
(statearr_30402_30547[(2)] = null);

(statearr_30402_30547[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30165 === (11))){
var inst_30126 = (state_30164[(14)]);
var inst_30125 = (state_30164[(13)]);
var inst_30128 = (inst_30126 < inst_30125);
var inst_30129 = inst_30128;
var state_30164__$1 = state_30164;
if(cljs.core.truth_(inst_30129)){
var statearr_30403_30548 = state_30164__$1;
(statearr_30403_30548[(1)] = (13));

} else {
var statearr_30404_30549 = state_30164__$1;
(statearr_30404_30549[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30165 === (9))){
var _ = (function (){var statearr_30405 = state_30164;
(statearr_30405[(4)] = cljs.core.rest.call(null,(state_30164[(4)])));

return statearr_30405;
})();
var state_30164__$1 = state_30164;
var ex30400 = (state_30164__$1[(2)]);
var statearr_30406_30550 = state_30164__$1;
(statearr_30406_30550[(5)] = ex30400);


if((ex30400 instanceof Error)){
var statearr_30407_30551 = state_30164__$1;
(statearr_30407_30551[(1)] = (5));

(statearr_30407_30551[(5)] = null);

} else {
throw ex30400;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30165 === (5))){
var inst_30100 = (state_30164[(7)]);
var inst_30100__$1 = (state_30164[(2)]);
var inst_30101 = cljs.core.ex_data.call(null,inst_30100__$1);
var inst_30102 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_30101);
var inst_30103 = cljs.core._EQ_.call(null,inst_30102,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_30164__$1 = (function (){var statearr_30408 = state_30164;
(statearr_30408[(7)] = inst_30100__$1);

return statearr_30408;
})();
if(inst_30103){
var statearr_30409_30552 = state_30164__$1;
(statearr_30409_30552[(1)] = (6));

} else {
var statearr_30410_30553 = state_30164__$1;
(statearr_30410_30553[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30165 === (14))){
var inst_30123 = (state_30164[(11)]);
var inst_30137 = (state_30164[(8)]);
var inst_30137__$1 = cljs.core.seq.call(null,inst_30123);
var state_30164__$1 = (function (){var statearr_30411 = state_30164;
(statearr_30411[(8)] = inst_30137__$1);

return statearr_30411;
})();
if(inst_30137__$1){
var statearr_30412_30554 = state_30164__$1;
(statearr_30412_30554[(1)] = (16));

} else {
var statearr_30413_30555 = state_30164__$1;
(statearr_30413_30555[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30165 === (16))){
var inst_30137 = (state_30164[(8)]);
var inst_30139 = cljs.core.chunked_seq_QMARK_.call(null,inst_30137);
var state_30164__$1 = state_30164;
if(inst_30139){
var statearr_30414_30556 = state_30164__$1;
(statearr_30414_30556[(1)] = (19));

} else {
var statearr_30415_30557 = state_30164__$1;
(statearr_30415_30557[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30165 === (10))){
var inst_30117 = (state_30164[(2)]);
var inst_30122 = cljs.core.seq.call(null,ab_chs);
var inst_30123 = inst_30122;
var inst_30124 = null;
var inst_30125 = (0);
var inst_30126 = (0);
var state_30164__$1 = (function (){var statearr_30416 = state_30164;
(statearr_30416[(18)] = inst_30117);

(statearr_30416[(11)] = inst_30123);

(statearr_30416[(12)] = inst_30124);

(statearr_30416[(13)] = inst_30125);

(statearr_30416[(14)] = inst_30126);

return statearr_30416;
})();
var statearr_30417_30558 = state_30164__$1;
(statearr_30417_30558[(2)] = null);

(statearr_30417_30558[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30165 === (18))){
var inst_30155 = (state_30164[(2)]);
var state_30164__$1 = state_30164;
var statearr_30418_30559 = state_30164__$1;
(statearr_30418_30559[(2)] = inst_30155);

(statearr_30418_30559[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30165 === (8))){
var inst_30100 = (state_30164[(7)]);
var inst_30108 = (state_30164[(2)]);
var state_30164__$1 = (function (){var statearr_30419 = state_30164;
(statearr_30419[(19)] = inst_30108);

return statearr_30419;
})();
var statearr_30420_30560 = state_30164__$1;
(statearr_30420_30560[(2)] = inst_30100);

(statearr_30420_30560[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var superv$async$state_machine__21468__auto__ = null;
var superv$async$state_machine__21468__auto____0 = (function (){
var statearr_30421 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30421[(0)] = superv$async$state_machine__21468__auto__);

(statearr_30421[(1)] = (1));

return statearr_30421;
});
var superv$async$state_machine__21468__auto____1 = (function (state_30164){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_30164);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e30422){var ex__21471__auto__ = e30422;
var statearr_30423_30561 = state_30164;
(statearr_30423_30561[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_30164[(4)]))){
var statearr_30424_30562 = state_30164;
(statearr_30424_30562[(1)] = cljs.core.first.call(null,(state_30164[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30563 = state_30164;
state_30164 = G__30563;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
superv$async$state_machine__21468__auto__ = function(state_30164){
switch(arguments.length){
case 0:
return superv$async$state_machine__21468__auto____0.call(this);
case 1:
return superv$async$state_machine__21468__auto____1.call(this,state_30164);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__21468__auto____0;
superv$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__21468__auto____1;
return superv$async$state_machine__21468__auto__;
})()
})();
var state__21594__auto__ = (function (){var statearr_30425 = f__21593__auto__.call(null);
(statearr_30425[(6)] = c__21592__auto____$1);

return statearr_30425;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
});
})();
var inst_30168 = cljs.core.async.impl.dispatch.run.call(null,inst_30167);
var state_30365__$1 = (function (){var statearr_30426 = state_30365;
(statearr_30426[(23)] = inst_30168);

return statearr_30426;
})();
var statearr_30427_30564 = state_30365__$1;
(statearr_30427_30564[(2)] = inst_30166);

(statearr_30427_30564[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (15))){
var inst_30305 = (state_30365[(2)]);
var state_30365__$1 = state_30365;
var statearr_30428_30565 = state_30365__$1;
(statearr_30428_30565[(2)] = inst_30305);

(statearr_30428_30565[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (21))){
var inst_30300 = (state_30365[(2)]);
var state_30365__$1 = state_30365;
var statearr_30429_30566 = state_30365__$1;
(statearr_30429_30566[(2)] = inst_30300);

(statearr_30429_30566[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (31))){
var inst_30326 = (state_30365[(2)]);
var state_30365__$1 = state_30365;
var statearr_30430_30567 = state_30365__$1;
(statearr_30430_30567[(2)] = inst_30326);

(statearr_30430_30567[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (32))){
var inst_30260 = (state_30365[(8)]);
var inst_30330 = [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30331 = [new cljs.core.Keyword(null,"passing-error","passing-error",-1357712542),inst_30260];
var inst_30332 = cljs.core.PersistentHashMap.fromArrays(inst_30330,inst_30331);
var inst_30333 = log_fn.call(null,new cljs.core.Keyword(null,"error","error",-978969032),inst_30332);
var state_30365__$1 = (function (){var statearr_30434 = state_30365;
(statearr_30434[(24)] = inst_30333);

return statearr_30434;
})();
if(cljs.core.truth_(supervisor)){
var statearr_30435_30568 = state_30365__$1;
(statearr_30435_30568[(1)] = (35));

} else {
var statearr_30436_30569 = state_30365__$1;
(statearr_30436_30569[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (33))){
var inst_30343 = cljs.core.async.timeout.call(null,delay);
var state_30365__$1 = state_30365;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30365__$1,(38),inst_30343);
} else {
if((state_val_30366 === (13))){
var inst_30272 = (state_30365[(13)]);
var inst_30274 = (state_30365[(15)]);
var inst_30271 = (state_30365[(12)]);
var inst_30273 = (state_30365[(14)]);
var inst_30279 = cljs.core._nth.call(null,inst_30272,inst_30274);
var inst_30280 = cljs.core.async.put_BANG_.call(null,inst_30279,new cljs.core.Keyword(null,"abort","abort",521193198));
var inst_30281 = cljs.core.async.close_BANG_.call(null,inst_30279);
var inst_30282 = (inst_30274 + (1));
var tmp30431 = inst_30272;
var tmp30432 = inst_30271;
var tmp30433 = inst_30273;
var inst_30271__$1 = tmp30432;
var inst_30272__$1 = tmp30431;
var inst_30273__$1 = tmp30433;
var inst_30274__$1 = inst_30282;
var state_30365__$1 = (function (){var statearr_30437 = state_30365;
(statearr_30437[(25)] = inst_30280);

(statearr_30437[(26)] = inst_30281);

(statearr_30437[(12)] = inst_30271__$1);

(statearr_30437[(13)] = inst_30272__$1);

(statearr_30437[(14)] = inst_30273__$1);

(statearr_30437[(15)] = inst_30274__$1);

return statearr_30437;
})();
var statearr_30438_30570 = state_30365__$1;
(statearr_30438_30570[(2)] = null);

(statearr_30438_30570[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (22))){
var inst_30260 = (state_30365[(8)]);
var inst_30311 = (state_30365[(27)]);
var inst_30309 = (state_30365[(2)]);
var inst_30310 = (inst_30260 instanceof exception);
var inst_30311__$1 = cljs.core.not.call(null,inst_30310);
var state_30365__$1 = (function (){var statearr_30439 = state_30365;
(statearr_30439[(28)] = inst_30309);

(statearr_30439[(27)] = inst_30311__$1);

return statearr_30439;
})();
if(inst_30311__$1){
var statearr_30440_30571 = state_30365__$1;
(statearr_30440_30571[(1)] = (23));

} else {
var statearr_30441_30572 = state_30365__$1;
(statearr_30441_30572[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (36))){
var state_30365__$1 = state_30365;
var statearr_30442_30573 = state_30365__$1;
(statearr_30442_30573[(2)] = null);

(statearr_30442_30573[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (29))){
var inst_30320 = (state_30365[(29)]);
var state_30365__$1 = state_30365;
var statearr_30443_30574 = state_30365__$1;
(statearr_30443_30574[(2)] = inst_30320);

(statearr_30443_30574[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (6))){
var inst_30075 = (state_30365[(16)]);
var inst_30077 = (state_30365[(19)]);
var inst_30080 = (state_30365[(20)]);
var inst_30081 = (state_30365[(7)]);
var inst_30089 = (state_30365[(22)]);
var inst_30090 = (state_30365[(21)]);
var inst_30171 = (state_30365[(2)]);
var inst_30218 = cljs.core.async.chan.call(null,(1));
var inst_30219 = (function (){var retries__$2 = inst_30075;
var err_ch = inst_30077;
var ab_chs = inst_30080;
var close_ch = inst_30081;
var s = inst_30089;
var res_ch = inst_30090;
var stale_timeout__$1 = (1000);
var c__21592__auto____$1 = inst_30218;
return (function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = (function (state_30216){
var state_val_30217 = (state_30216[(1)]);
if((state_val_30217 === (7))){
var inst_30191 = (state_30216[(7)]);
var inst_30178 = (state_30216[(2)]);
var inst_30186 = (function (){return (function (p__30185){
var vec__30444 = p__30185;
var k = cljs.core.nth.call(null,vec__30444,(0),null);
var v = cljs.core.nth.call(null,vec__30444,(1),null);
return ((superv.async.now.call(null).getTime() - stale_timeout__$1) > v.getTime());
});
})();
var inst_30187 = new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s);
var inst_30188 = cljs.core.deref.call(null,inst_30187);
var inst_30189 = cljs.core.filter.call(null,inst_30186,inst_30188);
var inst_30190 = cljs.core.nth.call(null,inst_30189,(0),null);
var inst_30191__$1 = cljs.core.nth.call(null,inst_30190,(0),null);
var inst_30192 = cljs.core.nth.call(null,inst_30190,(1),null);
var state_30216__$1 = (function (){var statearr_30447 = state_30216;
(statearr_30447[(8)] = inst_30178);

(statearr_30447[(7)] = inst_30191__$1);

(statearr_30447[(9)] = inst_30192);

return statearr_30447;
})();
if(cljs.core.truth_(inst_30191__$1)){
var statearr_30448_30575 = state_30216__$1;
(statearr_30448_30575[(1)] = (8));

} else {
var statearr_30449_30576 = state_30216__$1;
(statearr_30449_30576[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30217 === (1))){
var state_30216__$1 = state_30216;
var statearr_30450_30577 = state_30216__$1;
(statearr_30450_30577[(2)] = null);

(statearr_30450_30577[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30217 === (4))){
var state_30216__$1 = state_30216;
var statearr_30451_30578 = state_30216__$1;
(statearr_30451_30578[(2)] = null);

(statearr_30451_30578[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30217 === (13))){
var inst_30191 = (state_30216[(7)]);
var inst_30204 = (state_30216[(2)]);
var inst_30205 = superv.async._free_exception.call(null,s,inst_30191);
var inst_30206 = cljs.core.async.put_BANG_.call(null,err_ch,inst_30191);
var state_30216__$1 = (function (){var statearr_30452 = state_30216;
(statearr_30452[(10)] = inst_30204);

(statearr_30452[(11)] = inst_30205);

return statearr_30452;
})();
var statearr_30453_30579 = state_30216__$1;
(statearr_30453_30579[(2)] = inst_30206);

(statearr_30453_30579[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30217 === (6))){
var inst_30212 = (state_30216[(2)]);
var state_30216__$1 = state_30216;
var statearr_30454_30580 = state_30216__$1;
(statearr_30454_30580[(2)] = inst_30212);

(statearr_30454_30580[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30217 === (3))){
var inst_30214 = (state_30216[(2)]);
var state_30216__$1 = state_30216;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30216__$1,inst_30214);
} else {
if((state_val_30217 === (12))){
var inst_30191 = (state_30216[(7)]);
var inst_30199 = [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30200 = [new cljs.core.Keyword(null,"stale-error-in-supervisor","stale-error-in-supervisor",-123257662),inst_30191];
var inst_30201 = cljs.core.PersistentHashMap.fromArrays(inst_30199,inst_30200);
var inst_30202 = log_fn.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_30201);
var state_30216__$1 = state_30216;
var statearr_30455_30581 = state_30216__$1;
(statearr_30455_30581[(2)] = inst_30202);

(statearr_30455_30581[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30217 === (2))){
var inst_30173 = cljs.core.some.call(null,cljs.core.async.poll_BANG_,ab_chs);
var state_30216__$1 = state_30216;
if(cljs.core.truth_(inst_30173)){
var statearr_30456_30582 = state_30216__$1;
(statearr_30456_30582[(1)] = (4));

} else {
var statearr_30457_30583 = state_30216__$1;
(statearr_30457_30583[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30217 === (11))){
var state_30216__$1 = state_30216;
var statearr_30458_30584 = state_30216__$1;
(statearr_30458_30584[(2)] = null);

(statearr_30458_30584[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30217 === (9))){
var state_30216__$1 = state_30216;
var statearr_30459_30585 = state_30216__$1;
(statearr_30459_30585[(2)] = null);

(statearr_30459_30585[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30217 === (5))){
var inst_30176 = cljs.core.async.timeout.call(null,stale_timeout__$1);
var state_30216__$1 = state_30216;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30216__$1,(7),inst_30176);
} else {
if((state_val_30217 === (10))){
var inst_30210 = (state_30216[(2)]);
var state_30216__$1 = state_30216;
var statearr_30460_30586 = state_30216__$1;
(statearr_30460_30586[(2)] = inst_30210);

(statearr_30460_30586[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30217 === (8))){
var inst_30191 = (state_30216[(7)]);
var inst_30194 = cljs.core.ex_data.call(null,inst_30191);
var inst_30195 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_30194);
var inst_30196 = cljs.core._EQ_.call(null,inst_30195,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_30216__$1 = state_30216;
if(inst_30196){
var statearr_30461_30587 = state_30216__$1;
(statearr_30461_30587[(1)] = (11));

} else {
var statearr_30462_30588 = state_30216__$1;
(statearr_30462_30588[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var superv$async$state_machine__21468__auto__ = null;
var superv$async$state_machine__21468__auto____0 = (function (){
var statearr_30463 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30463[(0)] = superv$async$state_machine__21468__auto__);

(statearr_30463[(1)] = (1));

return statearr_30463;
});
var superv$async$state_machine__21468__auto____1 = (function (state_30216){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_30216);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e30464){var ex__21471__auto__ = e30464;
var statearr_30465_30589 = state_30216;
(statearr_30465_30589[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_30216[(4)]))){
var statearr_30466_30590 = state_30216;
(statearr_30466_30590[(1)] = cljs.core.first.call(null,(state_30216[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30591 = state_30216;
state_30216 = G__30591;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
superv$async$state_machine__21468__auto__ = function(state_30216){
switch(arguments.length){
case 0:
return superv$async$state_machine__21468__auto____0.call(this);
case 1:
return superv$async$state_machine__21468__auto____1.call(this,state_30216);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__21468__auto____0;
superv$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__21468__auto____1;
return superv$async$state_machine__21468__auto__;
})()
})();
var state__21594__auto__ = (function (){var statearr_30467 = f__21593__auto__.call(null);
(statearr_30467[(6)] = c__21592__auto____$1);

return statearr_30467;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
});
})();
var inst_30220 = cljs.core.async.impl.dispatch.run.call(null,inst_30219);
var inst_30249 = cljs.core.async.chan.call(null,(1));
var inst_30250 = (function (){var retries__$2 = inst_30075;
var err_ch = inst_30077;
var ab_chs = inst_30080;
var close_ch = inst_30081;
var s = inst_30089;
var res_ch = inst_30090;
var stale_timeout__$1 = (1000);
var c__21592__auto____$1 = inst_30249;
return (function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = (function (state_30247){
var state_val_30248 = (state_30247[(1)]);
if((state_val_30248 === (7))){
var inst_30235 = cljs.core.async.timeout.call(null,(100));
var state_30247__$1 = state_30247;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30247__$1,(10),inst_30235);
} else {
if((state_val_30248 === (1))){
var inst_30221 = (0);
var state_30247__$1 = (function (){var statearr_30468 = state_30247;
(statearr_30468[(7)] = inst_30221);

return statearr_30468;
})();
var statearr_30469_30592 = state_30247__$1;
(statearr_30469_30592[(2)] = null);

(statearr_30469_30592[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30248 === (4))){
var inst_30227 = new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s);
var inst_30228 = cljs.core.deref.call(null,inst_30227);
var inst_30229 = cljs.core.empty_QMARK_.call(null,inst_30228);
var state_30247__$1 = state_30247;
var statearr_30470_30593 = state_30247__$1;
(statearr_30470_30593[(2)] = inst_30229);

(statearr_30470_30593[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30248 === (6))){
var inst_30232 = (state_30247[(2)]);
var inst_30233 = cljs.core.not.call(null,inst_30232);
var state_30247__$1 = state_30247;
if(inst_30233){
var statearr_30471_30594 = state_30247__$1;
(statearr_30471_30594[(1)] = (7));

} else {
var statearr_30472_30595 = state_30247__$1;
(statearr_30472_30595[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30248 === (3))){
var inst_30245 = (state_30247[(2)]);
var state_30247__$1 = state_30247;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30247__$1,inst_30245);
} else {
if((state_val_30248 === (2))){
var inst_30225 = (state_30247[(8)]);
var inst_30223 = new cljs.core.Keyword(null,"registered","registered",-388600037).cljs$core$IFn$_invoke$arity$1(s);
var inst_30224 = cljs.core.deref.call(null,inst_30223);
var inst_30225__$1 = cljs.core.empty_QMARK_.call(null,inst_30224);
var state_30247__$1 = (function (){var statearr_30473 = state_30247;
(statearr_30473[(8)] = inst_30225__$1);

return statearr_30473;
})();
if(inst_30225__$1){
var statearr_30474_30596 = state_30247__$1;
(statearr_30474_30596[(1)] = (4));

} else {
var statearr_30475_30597 = state_30247__$1;
(statearr_30475_30597[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30248 === (9))){
var inst_30243 = (state_30247[(2)]);
var state_30247__$1 = state_30247;
var statearr_30476_30598 = state_30247__$1;
(statearr_30476_30598[(2)] = inst_30243);

(statearr_30476_30598[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30248 === (5))){
var inst_30225 = (state_30247[(8)]);
var state_30247__$1 = state_30247;
var statearr_30477_30599 = state_30247__$1;
(statearr_30477_30599[(2)] = inst_30225);

(statearr_30477_30599[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30248 === (10))){
var inst_30221 = (state_30247[(7)]);
var inst_30237 = (state_30247[(2)]);
var inst_30238 = (inst_30221 + (1));
var inst_30221__$1 = inst_30238;
var state_30247__$1 = (function (){var statearr_30478 = state_30247;
(statearr_30478[(9)] = inst_30237);

(statearr_30478[(7)] = inst_30221__$1);

return statearr_30478;
})();
var statearr_30479_30600 = state_30247__$1;
(statearr_30479_30600[(2)] = null);

(statearr_30479_30600[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30248 === (8))){
var inst_30241 = cljs.core.async.close_BANG_.call(null,close_ch);
var state_30247__$1 = state_30247;
var statearr_30480_30601 = state_30247__$1;
(statearr_30480_30601[(2)] = inst_30241);

(statearr_30480_30601[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var superv$async$state_machine__21468__auto__ = null;
var superv$async$state_machine__21468__auto____0 = (function (){
var statearr_30481 = [null,null,null,null,null,null,null,null,null,null];
(statearr_30481[(0)] = superv$async$state_machine__21468__auto__);

(statearr_30481[(1)] = (1));

return statearr_30481;
});
var superv$async$state_machine__21468__auto____1 = (function (state_30247){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_30247);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e30482){var ex__21471__auto__ = e30482;
var statearr_30483_30602 = state_30247;
(statearr_30483_30602[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_30247[(4)]))){
var statearr_30484_30603 = state_30247;
(statearr_30484_30603[(1)] = cljs.core.first.call(null,(state_30247[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30604 = state_30247;
state_30247 = G__30604;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
superv$async$state_machine__21468__auto__ = function(state_30247){
switch(arguments.length){
case 0:
return superv$async$state_machine__21468__auto____0.call(this);
case 1:
return superv$async$state_machine__21468__auto____1.call(this,state_30247);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__21468__auto____0;
superv$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__21468__auto____1;
return superv$async$state_machine__21468__auto__;
})()
})();
var state__21594__auto__ = (function (){var statearr_30485 = f__21593__auto__.call(null);
(statearr_30485[(6)] = c__21592__auto____$1);

return statearr_30485;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
});
})();
var inst_30251 = cljs.core.async.impl.dispatch.run.call(null,inst_30250);
var inst_30255 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30256 = [inst_30077,inst_30081];
var inst_30257 = (new cljs.core.PersistentVector(null,2,(5),inst_30255,inst_30256,null));
var state_30365__$1 = (function (){var statearr_30486 = state_30365;
(statearr_30486[(30)] = inst_30171);

(statearr_30486[(31)] = inst_30220);

(statearr_30486[(32)] = inst_30251);

return statearr_30486;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_30365__$1,(7),inst_30257,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_30366 === (28))){
var inst_30320 = (state_30365[(29)]);
var inst_30319 = (state_30365[(2)]);
var inst_30320__$1 = cljs.core.not.call(null,inst_30319);
var state_30365__$1 = (function (){var statearr_30487 = state_30365;
(statearr_30487[(29)] = inst_30320__$1);

return statearr_30487;
})();
if(inst_30320__$1){
var statearr_30488_30605 = state_30365__$1;
(statearr_30488_30605[(1)] = (29));

} else {
var statearr_30489_30606 = state_30365__$1;
(statearr_30489_30606[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (25))){
var inst_30328 = (state_30365[(2)]);
var state_30365__$1 = state_30365;
if(cljs.core.truth_(inst_30328)){
var statearr_30490_30607 = state_30365__$1;
(statearr_30490_30607[(1)] = (32));

} else {
var statearr_30491_30608 = state_30365__$1;
(statearr_30491_30608[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (34))){
var inst_30354 = (state_30365[(2)]);
var state_30365__$1 = state_30365;
var statearr_30492_30609 = state_30365__$1;
(statearr_30492_30609[(2)] = inst_30354);

(statearr_30492_30609[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (17))){
var state_30365__$1 = state_30365;
var statearr_30493_30610 = state_30365__$1;
(statearr_30493_30610[(2)] = null);

(statearr_30493_30610[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (3))){
var inst_30363 = (state_30365[(2)]);
var state_30365__$1 = state_30365;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30365__$1,inst_30363);
} else {
if((state_val_30366 === (12))){
var inst_30081 = (state_30365[(7)]);
var inst_30307 = (state_30365[(2)]);
var state_30365__$1 = (function (){var statearr_30494 = state_30365;
(statearr_30494[(33)] = inst_30307);

return statearr_30494;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30365__$1,(22),inst_30081);
} else {
if((state_val_30366 === (2))){
var inst_30075 = (state_30365[(16)]);
var inst_30077 = (state_30365[(19)]);
var inst_30080 = (state_30365[(20)]);
var inst_30089 = (state_30365[(22)]);
var inst_30077__$1 = cljs.core.async.chan.call(null);
var inst_30078 = (function (){var retries__$2 = inst_30075;
var err_ch = inst_30077__$1;
return (function (){
return cljs.core.async.promise_chan.call(null);
});
})();
var inst_30079 = cljs.core.repeatedly.call(null,(1000),inst_30078);
var inst_30080__$1 = cljs.core.vec.call(null,inst_30079);
var inst_30081 = cljs.core.async.chan.call(null);
var inst_30082 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"aborts","aborts",-277478143),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),new cljs.core.Keyword(null,"restarting","restarting",760677572)];
var inst_30083 = cljs.core.PersistentHashMap.EMPTY;
var inst_30084 = cljs.core.atom.call(null,inst_30083);
var inst_30085 = cljs.core.PersistentHashMap.EMPTY;
var inst_30086 = cljs.core.atom.call(null,inst_30085);
var inst_30087 = [inst_30077__$1,inst_30080__$1,inst_30084,inst_30086,true];
var inst_30088 = cljs.core.PersistentHashMap.fromArrays(inst_30082,inst_30087);
var inst_30089__$1 = superv.async.map__GT_TrackingSupervisor.call(null,inst_30088);
var inst_30090 = start_fn.call(null,inst_30089__$1);
var state_30365__$1 = (function (){var statearr_30495 = state_30365;
(statearr_30495[(19)] = inst_30077__$1);

(statearr_30495[(20)] = inst_30080__$1);

(statearr_30495[(7)] = inst_30081);

(statearr_30495[(22)] = inst_30089__$1);

(statearr_30495[(21)] = inst_30090);

return statearr_30495;
})();
if(cljs.core.truth_(supervisor)){
var statearr_30496_30611 = state_30365__$1;
(statearr_30496_30611[(1)] = (4));

} else {
var statearr_30497_30612 = state_30365__$1;
(statearr_30497_30612[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (23))){
var inst_30311 = (state_30365[(27)]);
var state_30365__$1 = state_30365;
var statearr_30498_30613 = state_30365__$1;
(statearr_30498_30613[(2)] = inst_30311);

(statearr_30498_30613[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (35))){
var inst_30260 = (state_30365[(8)]);
var inst_30335 = superv.async._error.call(null,supervisor);
var inst_30336 = cljs.core.async.put_BANG_.call(null,inst_30335,inst_30260);
var state_30365__$1 = state_30365;
var statearr_30499_30614 = state_30365__$1;
(statearr_30499_30614[(2)] = inst_30336);

(statearr_30499_30614[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (19))){
var inst_30285 = (state_30365[(9)]);
var inst_30289 = cljs.core.chunk_first.call(null,inst_30285);
var inst_30290 = cljs.core.chunk_rest.call(null,inst_30285);
var inst_30291 = cljs.core.count.call(null,inst_30289);
var inst_30271 = inst_30290;
var inst_30272 = inst_30289;
var inst_30273 = inst_30291;
var inst_30274 = (0);
var state_30365__$1 = (function (){var statearr_30500 = state_30365;
(statearr_30500[(12)] = inst_30271);

(statearr_30500[(13)] = inst_30272);

(statearr_30500[(14)] = inst_30273);

(statearr_30500[(15)] = inst_30274);

return statearr_30500;
})();
var statearr_30501_30615 = state_30365__$1;
(statearr_30501_30615[(2)] = null);

(statearr_30501_30615[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (11))){
var inst_30274 = (state_30365[(15)]);
var inst_30273 = (state_30365[(14)]);
var inst_30276 = (inst_30274 < inst_30273);
var inst_30277 = inst_30276;
var state_30365__$1 = state_30365;
if(cljs.core.truth_(inst_30277)){
var statearr_30502_30616 = state_30365__$1;
(statearr_30502_30616[(1)] = (13));

} else {
var statearr_30503_30617 = state_30365__$1;
(statearr_30503_30617[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (9))){
var inst_30090 = (state_30365[(21)]);
var state_30365__$1 = state_30365;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30365__$1,(39),inst_30090);
} else {
if((state_val_30366 === (5))){
var state_30365__$1 = state_30365;
var statearr_30504_30618 = state_30365__$1;
(statearr_30504_30618[(2)] = null);

(statearr_30504_30618[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (14))){
var inst_30271 = (state_30365[(12)]);
var inst_30285 = (state_30365[(9)]);
var inst_30285__$1 = cljs.core.seq.call(null,inst_30271);
var state_30365__$1 = (function (){var statearr_30505 = state_30365;
(statearr_30505[(9)] = inst_30285__$1);

return statearr_30505;
})();
if(inst_30285__$1){
var statearr_30506_30619 = state_30365__$1;
(statearr_30506_30619[(1)] = (16));

} else {
var statearr_30507_30620 = state_30365__$1;
(statearr_30507_30620[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (26))){
var inst_30314 = (state_30365[(17)]);
var state_30365__$1 = state_30365;
var statearr_30508_30621 = state_30365__$1;
(statearr_30508_30621[(2)] = inst_30314);

(statearr_30508_30621[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (16))){
var inst_30285 = (state_30365[(9)]);
var inst_30287 = cljs.core.chunked_seq_QMARK_.call(null,inst_30285);
var state_30365__$1 = state_30365;
if(inst_30287){
var statearr_30509_30622 = state_30365__$1;
(statearr_30509_30622[(1)] = (19));

} else {
var statearr_30510_30623 = state_30365__$1;
(statearr_30510_30623[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (38))){
var inst_30260 = (state_30365[(8)]);
var inst_30075 = (state_30365[(16)]);
var inst_30345 = (state_30365[(2)]);
var inst_30346 = [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"further-retries","further-retries",1297645153)];
var inst_30347 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_30260);
var inst_30348 = [new cljs.core.Keyword(null,"retry","retry",-614012896),inst_30347,inst_30075];
var inst_30349 = cljs.core.PersistentHashMap.fromArrays(inst_30346,inst_30348);
var inst_30350 = log_fn.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),inst_30349);
var inst_30351 = (inst_30075 - (1));
var inst_30075__$1 = inst_30351;
var state_30365__$1 = (function (){var statearr_30511 = state_30365;
(statearr_30511[(34)] = inst_30345);

(statearr_30511[(35)] = inst_30350);

(statearr_30511[(16)] = inst_30075__$1);

return statearr_30511;
})();
var statearr_30512_30624 = state_30365__$1;
(statearr_30512_30624[(2)] = null);

(statearr_30512_30624[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (30))){
var inst_30075 = (state_30365[(16)]);
var inst_30323 = (inst_30075 > (0));
var inst_30324 = cljs.core.not.call(null,inst_30323);
var state_30365__$1 = state_30365;
var statearr_30513_30625 = state_30365__$1;
(statearr_30513_30625[(2)] = inst_30324);

(statearr_30513_30625[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (10))){
var inst_30361 = (state_30365[(2)]);
var state_30365__$1 = state_30365;
var statearr_30514_30626 = state_30365__$1;
(statearr_30514_30626[(2)] = inst_30361);

(statearr_30514_30626[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (18))){
var inst_30303 = (state_30365[(2)]);
var state_30365__$1 = state_30365;
var statearr_30515_30627 = state_30365__$1;
(statearr_30515_30627[(2)] = inst_30303);

(statearr_30515_30627[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (37))){
var inst_30260 = (state_30365[(8)]);
var inst_30339 = (state_30365[(2)]);
var inst_30340 = cljs.core.async.put_BANG_.call(null,out_ch,inst_30260);
var inst_30341 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_30365__$1 = (function (){var statearr_30516 = state_30365;
(statearr_30516[(36)] = inst_30339);

(statearr_30516[(37)] = inst_30340);

return statearr_30516;
})();
var statearr_30517_30628 = state_30365__$1;
(statearr_30517_30628[(2)] = inst_30341);

(statearr_30517_30628[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (8))){
var inst_30077 = (state_30365[(19)]);
var inst_30080 = (state_30365[(20)]);
var inst_30265 = cljs.core.async.close_BANG_.call(null,inst_30077);
var inst_30270 = cljs.core.seq.call(null,inst_30080);
var inst_30271 = inst_30270;
var inst_30272 = null;
var inst_30273 = (0);
var inst_30274 = (0);
var state_30365__$1 = (function (){var statearr_30518 = state_30365;
(statearr_30518[(38)] = inst_30265);

(statearr_30518[(12)] = inst_30271);

(statearr_30518[(13)] = inst_30272);

(statearr_30518[(14)] = inst_30273);

(statearr_30518[(15)] = inst_30274);

return statearr_30518;
})();
var statearr_30519_30629 = state_30365__$1;
(statearr_30519_30629[(2)] = null);

(statearr_30519_30629[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var superv$async$state_machine__21468__auto__ = null;
var superv$async$state_machine__21468__auto____0 = (function (){
var statearr_30520 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30520[(0)] = superv$async$state_machine__21468__auto__);

(statearr_30520[(1)] = (1));

return statearr_30520;
});
var superv$async$state_machine__21468__auto____1 = (function (state_30365){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_30365);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e30521){var ex__21471__auto__ = e30521;
var statearr_30522_30630 = state_30365;
(statearr_30522_30630[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_30365[(4)]))){
var statearr_30523_30631 = state_30365;
(statearr_30523_30631[(1)] = cljs.core.first.call(null,(state_30365[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30632 = state_30365;
state_30365 = G__30632;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
superv$async$state_machine__21468__auto__ = function(state_30365){
switch(arguments.length){
case 0:
return superv$async$state_machine__21468__auto____0.call(this);
case 1:
return superv$async$state_machine__21468__auto____1.call(this,state_30365);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
superv$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__21468__auto____0;
superv$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__21468__auto____1;
return superv$async$state_machine__21468__auto__;
})()
})();
var state__21594__auto__ = (function (){var statearr_30524 = f__21593__auto__.call(null);
(statearr_30524[(6)] = c__21592__auto___30528);

return statearr_30524;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
}));


return out_ch;
}));

(superv.async.restarting_supervisor.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(superv.async.restarting_supervisor.cljs$lang$applyTo = (function (seq30070){
var G__30071 = cljs.core.first.call(null,seq30070);
var seq30070__$1 = cljs.core.next.call(null,seq30070);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30071,seq30070__$1);
}));


//# sourceMappingURL=async.js.map
