// Compiled by ClojureScript 1.11.132 {:optimizations :none}
goog.provide('kabel.client');
goog.require('cljs.core');
goog.require('kabel.binary');
goog.require('kabel.util');
goog.require('goog.net.WebSocket');
goog.require('goog.Uri');
goog.require('goog.events');
goog.require('cljs.core.async');
goog.require('superv.async');
if(kabel.util.on_node_QMARK_.call(null)){
console.log("Patching global env for: W3C WebSocket API.");

(WebSocket = require("websocket").w3cwebsocket);
} else {
}
/**
 * Connects to url. Puts [in out] channels on return channel when ready.
 * Only supports websocket at the moment, but is supposed to dispatch on
 *   protocol of url. read-opts is ignored on cljs for now, use the
 *   platform-wide reader setup.
 */
kabel.client.client_connect_BANG_ = (function kabel$client$client_connect_BANG_(var_args){
var G__22124 = arguments.length;
switch (G__22124) {
case 3:
return kabel.client.client_connect_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return kabel.client.client_connect_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(kabel.client.client_connect_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (S,url,peer_id){
return kabel.client.client_connect_BANG_.call(null,S,url,peer_id,cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY));
}));

(kabel.client.client_connect_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (S,url,peer_id,read_handlers,write_handlers){
var channel = (new goog.net.WebSocket(false));
var in_buffer = cljs.core.async.buffer.call(null,(1024));
var in$ = cljs.core.async.chan.call(null,in_buffer);
var out = cljs.core.async.chan.call(null);
var opener = cljs.core.async.chan.call(null);
var host = (new goog.Uri(url.replace("ws","http"))).getDomain();
taoensso.timbre._log_BANG_(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"kabel.client",null,null,null,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"connecting-to","connecting-to",-1991299113),new cljs.core.Keyword(null,"url","url",276297046),url], null)], null);
}),null)),null,(13),null,null,null);

var G__22125_22204 = channel;
goog.events.listen(G__22125_22204,goog.net.WebSocket.EventType.MESSAGE,(function (evt){
var v = evt.message;
try{if((cljs.core.count.call(null,in_buffer) > (100))){
channel.close();

throw cljs.core.ex_info.call(null,["incoming buffer for ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)," too full:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,in_buffer))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"count","count",2139924085),cljs.core.count.call(null,in_buffer)], null));
} else {
}

if(typeof v === 'string'){
return cljs.core.async.put_BANG_.call(null,in$,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("kabel","serialization","kabel/serialization",437520425),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword("kabel","payload","kabel/payload",251259889),v], null));
} else {
return kabel.binary.from_binary.call(null,v,(function (p1__22122_SHARP_){
return cljs.core.async.put_BANG_.call(null,in$,((cljs.core.map_QMARK_.call(null,p1__22122_SHARP_))?cljs.core.assoc.call(null,p1__22122_SHARP_,new cljs.core.Keyword("kabel","host","kabel/host",-1456877872),host):p1__22122_SHARP_));
}));
}
}catch (e22126){if((e22126 instanceof Error)){
var e = e22126;
taoensso.timbre._log_BANG_(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"kabel.client",null,null,null,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"cannot-read-message","cannot-read-message",-543619229),new cljs.core.Keyword(null,"error","error",-978969032),e], null)], null);
}),null)),null,(14),null,null,null);

channel.close();

cljs.core.async.close_BANG_.call(null,opener);

return cljs.core.async.put_BANG_.call(null,superv.async._error.call(null,S),e);
} else {
throw e22126;

}
}}));

goog.events.listen(G__22125_22204,goog.net.WebSocket.EventType.CLOSED,(function (evt){
var e = cljs.core.ex_info.call(null,"Connection closed!",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"event","event",301435442),evt], null));
taoensso.timbre._log_BANG_(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"kabel.client",null,null,null,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"connection-closed","connection-closed",579733998),new cljs.core.Keyword(null,"url","url",276297046),url], null)], null);
}),null)),null,(15),null,null,null);

cljs.core.async.close_BANG_.call(null,in$);

cljs.core.async.put_BANG_.call(null,superv.async._error.call(null,S),e);

try{cljs.core.async.put_BANG_.call(null,opener,e);
}catch (e22127){if((e22127 instanceof Object)){
var e_22205__$1 = e22127;
} else {
throw e22127;

}
}
channel.close();

return cljs.core.async.close_BANG_.call(null,opener);
}));

goog.events.listen(G__22125_22204,goog.net.WebSocket.EventType.OPENED,(function (evt){
cljs.core.async.put_BANG_.call(null,opener,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [in$,out], null));

return cljs.core.async.close_BANG_.call(null,opener);
}));

goog.events.listen(G__22125_22204,goog.net.WebSocket.EventType.ERROR,(function (evt){
var e = cljs.core.ex_info.call(null,"Connection error!",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"event","event",301435442),evt], null));
taoensso.timbre._log_BANG_(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"kabel.client",null,null,null,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"websocket-error","websocket-error",941100166),new cljs.core.Keyword(null,"url","url",276297046),url], null)], null);
}),null)),null,(16),null,null,null);

cljs.core.async.put_BANG_.call(null,superv.async._error.call(null,S),e);

try{cljs.core.async.put_BANG_.call(null,opener,e);
}catch (e22128){if((e22128 instanceof Object)){
var e_22206__$1 = e22128;
} else {
throw e22128;

}
}
return cljs.core.async.close_BANG_.call(null,opener);
}));

try{
channel.open(url);
}catch (e22129){if((e22129 instanceof Object)){
var e_22207 = e22129;
var e_22208__$1 = cljs.core.ex_info.call(null,"Connection failed!",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"connection-failed","connection-failed",-1910345930),new cljs.core.Keyword(null,"error","error",-978969032),e_22207], null));
cljs.core.async.put_BANG_.call(null,superv.async._error.call(null,S),e_22208__$1);

cljs.core.async.put_BANG_.call(null,opener,e_22208__$1);

cljs.core.async.close_BANG_.call(null,opener);
} else {
throw e22129;

}
}

(function kabel$client$sender(){
return cljs.core.async.take_BANG_.call(null,out,(function (m){
if(cljs.core.truth_(m)){
var c__22044__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__22045__auto__ = (function (){var switch__22021__auto__ = (function (state_22172){
var state_val_22173 = (state_22172[(1)]);
if((state_val_22173 === (7))){
var inst_22139 = (state_22172[(2)]);
var state_22172__$1 = (function (){var statearr_22174 = state_22172;
(statearr_22174[(7)] = inst_22139);

return statearr_22174;
})();
var statearr_22175_22209 = state_22172__$1;
(statearr_22175_22209[(2)] = null);

(statearr_22175_22209[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22173 === (1))){
var state_22172__$1 = state_22172;
var statearr_22176_22210 = state_22172__$1;
(statearr_22176_22210[(2)] = null);

(statearr_22176_22210[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22173 === (4))){
var inst_22134 = (function (){return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"output-blocked","output-blocked",-122311417),new cljs.core.Keyword(null,"buffered-amount","buffered-amount",-665650460),channel.getBufferedAmount()], null)], null);
});
})();
var inst_22135 = (new cljs.core.Delay(inst_22134,null));
var inst_22136 = taoensso.timbre._log_BANG_(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"kabel.client",null,null,null,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),inst_22135,null,(17),null,null,null);
var inst_22137 = cljs.core.async.timeout.call(null,(100));
var state_22172__$1 = (function (){var statearr_22177 = state_22172;
(statearr_22177[(8)] = inst_22136);

return statearr_22177;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22172__$1,(7),inst_22137);
} else {
if((state_val_22173 === (13))){
var inst_22163 = kabel.binary.to_binary.call(null,m);
var inst_22164 = channel.send(inst_22163);
var state_22172__$1 = state_22172;
var statearr_22178_22211 = state_22172__$1;
(statearr_22178_22211[(2)] = inst_22164);

(statearr_22178_22211[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22173 === (6))){
var inst_22143 = (state_22172[(2)]);
var state_22172__$1 = state_22172;
var statearr_22179_22212 = state_22172__$1;
(statearr_22179_22212[(2)] = inst_22143);

(statearr_22179_22212[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22173 === (3))){
var inst_22145 = (state_22172[(2)]);
var state_22172__$1 = (function (){var statearr_22180 = state_22172;
(statearr_22180[(9)] = inst_22145);

return statearr_22180;
})();
var statearr_22181_22213 = state_22172__$1;
(statearr_22181_22213[(2)] = null);

(statearr_22181_22213[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22173 === (12))){
var inst_22160 = new cljs.core.Keyword("kabel","payload","kabel/payload",251259889).cljs$core$IFn$_invoke$arity$1(m);
var inst_22161 = channel.send(inst_22160);
var state_22172__$1 = state_22172;
var statearr_22183_22214 = state_22172__$1;
(statearr_22183_22214[(2)] = inst_22161);

(statearr_22183_22214[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22173 === (2))){
var inst_22131 = channel.getBufferedAmount();
var inst_22132 = (inst_22131 > (0));
var state_22172__$1 = state_22172;
if(cljs.core.truth_(inst_22132)){
var statearr_22184_22215 = state_22172__$1;
(statearr_22184_22215[(1)] = (4));

} else {
var statearr_22185_22216 = state_22172__$1;
(statearr_22185_22216[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22173 === (11))){
var _ = (function (){var statearr_22186 = state_22172;
(statearr_22186[(4)] = cljs.core.rest.call(null,(state_22172[(4)])));

return statearr_22186;
})();
var state_22172__$1 = state_22172;
var ex22182 = (state_22172__$1[(2)]);
var statearr_22187_22217 = state_22172__$1;
(statearr_22187_22217[(5)] = ex22182);


if((ex22182 instanceof Error)){
var statearr_22188_22218 = state_22172__$1;
(statearr_22188_22218[(1)] = (10));

(statearr_22188_22218[(5)] = null);

} else {
throw ex22182;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22173 === (9))){
var inst_22169 = (state_22172[(2)]);
var inst_22170 = kabel$client$sender.call(null);
var state_22172__$1 = (function (){var statearr_22189 = state_22172;
(statearr_22189[(10)] = inst_22169);

return statearr_22189;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22172__$1,inst_22170);
} else {
if((state_val_22173 === (5))){
var state_22172__$1 = state_22172;
var statearr_22190_22219 = state_22172__$1;
(statearr_22190_22219[(2)] = null);

(statearr_22190_22219[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22173 === (14))){
var inst_22166 = (state_22172[(2)]);
var _ = (function (){var statearr_22191 = state_22172;
(statearr_22191[(4)] = cljs.core.rest.call(null,(state_22172[(4)])));

return statearr_22191;
})();
var state_22172__$1 = state_22172;
var statearr_22192_22220 = state_22172__$1;
(statearr_22192_22220[(2)] = inst_22166);

(statearr_22192_22220[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22173 === (10))){
var inst_22146 = (state_22172[(2)]);
var inst_22147 = (function (){var e = inst_22146;
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"cannot-send-transit-message","cannot-send-transit-message",-1612316504),new cljs.core.Keyword(null,"error","error",-978969032),e], null)], null);
});
})();
var inst_22148 = (new cljs.core.Delay(inst_22147,null));
var inst_22149 = taoensso.timbre._log_BANG_(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"kabel.client",null,null,null,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),inst_22148,null,(18),null,null,null);
var inst_22150 = superv.async._error.call(null,S);
var inst_22151 = cljs.core.async.put_BANG_.call(null,inst_22150,inst_22146);
var state_22172__$1 = (function (){var statearr_22193 = state_22172;
(statearr_22193[(11)] = inst_22149);

return statearr_22193;
})();
var statearr_22194_22221 = state_22172__$1;
(statearr_22194_22221[(2)] = inst_22151);

(statearr_22194_22221[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22173 === (8))){
var _ = (function (){var statearr_22195 = state_22172;
(statearr_22195[(4)] = cljs.core.cons.call(null,(11),(state_22172[(4)])));

return statearr_22195;
})();
var inst_22157 = new cljs.core.Keyword("kabel","serialization","kabel/serialization",437520425).cljs$core$IFn$_invoke$arity$1(m);
var inst_22158 = cljs.core._EQ_.call(null,inst_22157,new cljs.core.Keyword(null,"string","string",-1989541586));
var state_22172__$1 = state_22172;
if(inst_22158){
var statearr_22196_22222 = state_22172__$1;
(statearr_22196_22222[(1)] = (12));

} else {
var statearr_22197_22223 = state_22172__$1;
(statearr_22197_22223[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var kabel$client$sender_$_state_machine__22022__auto__ = null;
var kabel$client$sender_$_state_machine__22022__auto____0 = (function (){
var statearr_22198 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22198[(0)] = kabel$client$sender_$_state_machine__22022__auto__);

(statearr_22198[(1)] = (1));

return statearr_22198;
});
var kabel$client$sender_$_state_machine__22022__auto____1 = (function (state_22172){
while(true){
var ret_value__22023__auto__ = (function (){try{while(true){
var result__22024__auto__ = switch__22021__auto__.call(null,state_22172);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22024__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22024__auto__;
}
break;
}
}catch (e22199){var ex__22025__auto__ = e22199;
var statearr_22200_22224 = state_22172;
(statearr_22200_22224[(2)] = ex__22025__auto__);


if(cljs.core.seq.call(null,(state_22172[(4)]))){
var statearr_22201_22225 = state_22172;
(statearr_22201_22225[(1)] = cljs.core.first.call(null,(state_22172[(4)])));

} else {
throw ex__22025__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22023__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22226 = state_22172;
state_22172 = G__22226;
continue;
} else {
return ret_value__22023__auto__;
}
break;
}
});
kabel$client$sender_$_state_machine__22022__auto__ = function(state_22172){
switch(arguments.length){
case 0:
return kabel$client$sender_$_state_machine__22022__auto____0.call(this);
case 1:
return kabel$client$sender_$_state_machine__22022__auto____1.call(this,state_22172);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
kabel$client$sender_$_state_machine__22022__auto__.cljs$core$IFn$_invoke$arity$0 = kabel$client$sender_$_state_machine__22022__auto____0;
kabel$client$sender_$_state_machine__22022__auto__.cljs$core$IFn$_invoke$arity$1 = kabel$client$sender_$_state_machine__22022__auto____1;
return kabel$client$sender_$_state_machine__22022__auto__;
})()
})();
var state__22046__auto__ = (function (){var statearr_22202 = f__22045__auto__.call(null);
(statearr_22202[(6)] = c__22044__auto__);

return statearr_22202;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__22046__auto__);
}));

return c__22044__auto__;
} else {
return channel.close();
}
}));
}).call(null);

return opener;
}));

(kabel.client.client_connect_BANG_.cljs$lang$maxFixedArity = 5);


//# sourceMappingURL=client.js.map
