// Compiled by ClojureScript 1.11.132 {:optimizations :none}
goog.provide('hasch.benc');
goog.require('cljs.core');

/**
 * @interface
 */
hasch.benc.PHashCoercion = function(){};

var hasch$benc$PHashCoercion$_coerce$dyn_30637 = (function (this$,md_create_fn,write_handlers){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (hasch.benc._coerce[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return m__5351__auto__.call(null,this$,md_create_fn,write_handlers);
} else {
var m__5349__auto__ = (hasch.benc._coerce["_"]);
if((!((m__5349__auto__ == null)))){
return m__5349__auto__.call(null,this$,md_create_fn,write_handlers);
} else {
throw cljs.core.missing_protocol.call(null,"PHashCoercion.-coerce",this$);
}
}
});
hasch.benc._coerce = (function hasch$benc$_coerce(this$,md_create_fn,write_handlers){
if((((!((this$ == null)))) && ((!((this$.hasch$benc$PHashCoercion$_coerce$arity$3 == null)))))){
return this$.hasch$benc$PHashCoercion$_coerce$arity$3(this$,md_create_fn,write_handlers);
} else {
return hasch$benc$PHashCoercion$_coerce$dyn_30637.call(null,this$,md_create_fn,write_handlers);
}
});

hasch.benc.magics = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"binary","binary",-1802232288),new cljs.core.Keyword(null,"inst","inst",645962501),new cljs.core.Keyword(null,"number","number",1570378438),new cljs.core.Keyword(null,"symbol","symbol",-1038572696),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"vector","vector",1902966158),new cljs.core.Keyword(null,"keyword","keyword",811389747),new cljs.core.Keyword(null,"nil","nil",99600501),new cljs.core.Keyword(null,"literal","literal",1664775605),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"seq","seq",-1817803783),new cljs.core.Keyword(null,"set","set",304602554),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"map","map",1371690461)],[(13),(6),(2),(4),(3),(9),(5),(0),(12),(7),(8),(11),(1),(10)]);
hasch.benc.split_size = (1024);
hasch.benc.max_entropy_byte_count = (32);
hasch.benc.byte_array = (function hasch$benc$byte_array(len){
return cljs.core.into_array.call(null,cljs.core.repeat.call(null,len,(0)));
});
hasch.benc.digest = (function hasch$benc$digest(bytes_or_seq_of_bytes,md_create_fn){
var md = md_create_fn.call(null);
if(cljs.core.seq_QMARK_.call(null,bytes_or_seq_of_bytes)){
var seq__30638_30642 = cljs.core.seq.call(null,bytes_or_seq_of_bytes);
var chunk__30639_30643 = null;
var count__30640_30644 = (0);
var i__30641_30645 = (0);
while(true){
if((i__30641_30645 < count__30640_30644)){
var bs_30646 = cljs.core._nth.call(null,chunk__30639_30643,i__30641_30645);
md.update(bs_30646);


var G__30647 = seq__30638_30642;
var G__30648 = chunk__30639_30643;
var G__30649 = count__30640_30644;
var G__30650 = (i__30641_30645 + (1));
seq__30638_30642 = G__30647;
chunk__30639_30643 = G__30648;
count__30640_30644 = G__30649;
i__30641_30645 = G__30650;
continue;
} else {
var temp__5804__auto___30651 = cljs.core.seq.call(null,seq__30638_30642);
if(temp__5804__auto___30651){
var seq__30638_30652__$1 = temp__5804__auto___30651;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30638_30652__$1)){
var c__5525__auto___30653 = cljs.core.chunk_first.call(null,seq__30638_30652__$1);
var G__30654 = cljs.core.chunk_rest.call(null,seq__30638_30652__$1);
var G__30655 = c__5525__auto___30653;
var G__30656 = cljs.core.count.call(null,c__5525__auto___30653);
var G__30657 = (0);
seq__30638_30642 = G__30654;
chunk__30639_30643 = G__30655;
count__30640_30644 = G__30656;
i__30641_30645 = G__30657;
continue;
} else {
var bs_30658 = cljs.core.first.call(null,seq__30638_30652__$1);
md.update(bs_30658);


var G__30659 = cljs.core.next.call(null,seq__30638_30652__$1);
var G__30660 = null;
var G__30661 = (0);
var G__30662 = (0);
seq__30638_30642 = G__30659;
chunk__30639_30643 = G__30660;
count__30640_30644 = G__30661;
i__30641_30645 = G__30662;
continue;
}
} else {
}
}
break;
}
} else {
md.update(bytes_or_seq_of_bytes);
}

return md.digest();
});
hasch.benc.coerce_seq = (function hasch$benc$coerce_seq(seq,md_create_fn,write_handlers){
var seq_md = md_create_fn.call(null);
var s_30666 = seq;
while(true){
var vec__30663_30667 = s_30666;
var seq__30664_30668 = cljs.core.seq.call(null,vec__30663_30667);
var first__30665_30669 = cljs.core.first.call(null,seq__30664_30668);
var seq__30664_30670__$1 = cljs.core.next.call(null,seq__30664_30668);
var f_30671 = first__30665_30669;
var r_30672 = seq__30664_30670__$1;
seq_md.update(hasch.benc._coerce.call(null,f_30671,md_create_fn,write_handlers));

if(cljs.core.empty_QMARK_.call(null,r_30672)){
} else {
var G__30673 = cljs.core.rest.call(null,s_30666);
s_30666 = G__30673;
continue;
}
break;
}

return seq_md.digest();
});
/**
 * Commutatively coerces elements of collection, seq entries must already be crypto hashes
 *   to avoid collisions in XOR. Takes at maximum 32 bytes into account.
 */
hasch.benc.xor_hashes = (function hasch$benc$xor_hashes(seq){
var len = (function (){var x__5090__auto__ = cljs.core.count.call(null,cljs.core.first.call(null,seq));
var y__5091__auto__ = hasch.benc.max_entropy_byte_count;
return ((x__5090__auto__ < y__5091__auto__) ? x__5090__auto__ : y__5091__auto__);
})();
return cljs.core.reduce.call(null,(function (acc,elem){
var i_30674 = (0);
while(true){
if((i_30674 < len)){
(acc[i_30674] = ((acc[i_30674]) ^ (elem[i_30674])));

var G__30675 = (i_30674 + (1));
i_30674 = G__30675;
continue;
} else {
}
break;
}

return acc;
}),hasch.benc.byte_array.call(null,len),seq);
});
hasch.benc.encode_safe = (function hasch$benc$encode_safe(a,md_create_fn){
if((cljs.core.count.call(null,a) < hasch.benc.split_size)){
var len = cljs.core.long$.call(null,a.length);
var ea = hasch.benc.byte_array.call(null,len);
var i_30676 = (0);
while(true){
if(cljs.core._EQ_.call(null,i_30676,len)){
} else {
var e_30677 = (a[i_30676]);
if((((e_30677 > (0))) && ((e_30677 < (30))))){
(ea[i_30676] = (1));
} else {
}

var G__30678 = (i_30676 + (1));
i_30676 = G__30678;
continue;
}
break;
}

return a.concat(ea);
} else {
return hasch.benc.digest.call(null,a,md_create_fn);
}
});

//# sourceMappingURL=benc.js.map
