// Compiled by ClojureScript 1.9.542 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('figwheel.client.utils');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.net.jsloader');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.core.async');
goog.require('goog.async.Deferred');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__40882__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__40882__auto__){
return or__40882__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__40882__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 10, ["svgpan.SvgPan",null,"far.out",null,"cljs.nodejs",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__40882__auto__)){
return or__40882__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__50728_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__50728_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([name]));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([parent_ns]));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__50733 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__50734 = null;
var count__50735 = (0);
var i__50736 = (0);
while(true){
if((i__50736 < count__50735)){
var n = cljs.core._nth.call(null,chunk__50734,i__50736);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__50737 = seq__50733;
var G__50738 = chunk__50734;
var G__50739 = count__50735;
var G__50740 = (i__50736 + (1));
seq__50733 = G__50737;
chunk__50734 = G__50738;
count__50735 = G__50739;
i__50736 = G__50740;
continue;
} else {
var temp__6738__auto__ = cljs.core.seq.call(null,seq__50733);
if(temp__6738__auto__){
var seq__50733__$1 = temp__6738__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__50733__$1)){
var c__41793__auto__ = cljs.core.chunk_first.call(null,seq__50733__$1);
var G__50741 = cljs.core.chunk_rest.call(null,seq__50733__$1);
var G__50742 = c__41793__auto__;
var G__50743 = cljs.core.count.call(null,c__41793__auto__);
var G__50744 = (0);
seq__50733 = G__50741;
chunk__50734 = G__50742;
count__50735 = G__50743;
i__50736 = G__50744;
continue;
} else {
var n = cljs.core.first.call(null,seq__50733__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__50745 = cljs.core.next.call(null,seq__50733__$1);
var G__50746 = null;
var G__50747 = (0);
var G__50748 = (0);
seq__50733 = G__50745;
chunk__50734 = G__50746;
count__50735 = G__50747;
i__50736 = G__50748;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__50799_50810 = cljs.core.seq.call(null,deps);
var chunk__50800_50811 = null;
var count__50801_50812 = (0);
var i__50802_50813 = (0);
while(true){
if((i__50802_50813 < count__50801_50812)){
var dep_50814 = cljs.core._nth.call(null,chunk__50800_50811,i__50802_50813);
topo_sort_helper_STAR_.call(null,dep_50814,(depth + (1)),state);

var G__50815 = seq__50799_50810;
var G__50816 = chunk__50800_50811;
var G__50817 = count__50801_50812;
var G__50818 = (i__50802_50813 + (1));
seq__50799_50810 = G__50815;
chunk__50800_50811 = G__50816;
count__50801_50812 = G__50817;
i__50802_50813 = G__50818;
continue;
} else {
var temp__6738__auto___50819 = cljs.core.seq.call(null,seq__50799_50810);
if(temp__6738__auto___50819){
var seq__50799_50820__$1 = temp__6738__auto___50819;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__50799_50820__$1)){
var c__41793__auto___50821 = cljs.core.chunk_first.call(null,seq__50799_50820__$1);
var G__50822 = cljs.core.chunk_rest.call(null,seq__50799_50820__$1);
var G__50823 = c__41793__auto___50821;
var G__50824 = cljs.core.count.call(null,c__41793__auto___50821);
var G__50825 = (0);
seq__50799_50810 = G__50822;
chunk__50800_50811 = G__50823;
count__50801_50812 = G__50824;
i__50802_50813 = G__50825;
continue;
} else {
var dep_50826 = cljs.core.first.call(null,seq__50799_50820__$1);
topo_sort_helper_STAR_.call(null,dep_50826,(depth + (1)),state);

var G__50827 = cljs.core.next.call(null,seq__50799_50820__$1);
var G__50828 = null;
var G__50829 = (0);
var G__50830 = (0);
seq__50799_50810 = G__50827;
chunk__50800_50811 = G__50828;
count__50801_50812 = G__50829;
i__50802_50813 = G__50830;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__50803){
var vec__50807 = p__50803;
var seq__50808 = cljs.core.seq.call(null,vec__50807);
var first__50809 = cljs.core.first.call(null,seq__50808);
var seq__50808__$1 = cljs.core.next.call(null,seq__50808);
var x = first__50809;
var xs = seq__50808__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__50807,seq__50808,first__50809,seq__50808__$1,x,xs,get_deps__$1){
return (function (p1__50749_SHARP_){
return clojure.set.difference.call(null,p1__50749_SHARP_,x);
});})(vec__50807,seq__50808,first__50809,seq__50808__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,figwheel.client.file_reloading.immutable_ns_QMARK_),cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss)))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__50843 = cljs.core.seq.call(null,provides);
var chunk__50844 = null;
var count__50845 = (0);
var i__50846 = (0);
while(true){
if((i__50846 < count__50845)){
var prov = cljs.core._nth.call(null,chunk__50844,i__50846);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__50847_50855 = cljs.core.seq.call(null,requires);
var chunk__50848_50856 = null;
var count__50849_50857 = (0);
var i__50850_50858 = (0);
while(true){
if((i__50850_50858 < count__50849_50857)){
var req_50859 = cljs.core._nth.call(null,chunk__50848_50856,i__50850_50858);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_50859,prov);

var G__50860 = seq__50847_50855;
var G__50861 = chunk__50848_50856;
var G__50862 = count__50849_50857;
var G__50863 = (i__50850_50858 + (1));
seq__50847_50855 = G__50860;
chunk__50848_50856 = G__50861;
count__50849_50857 = G__50862;
i__50850_50858 = G__50863;
continue;
} else {
var temp__6738__auto___50864 = cljs.core.seq.call(null,seq__50847_50855);
if(temp__6738__auto___50864){
var seq__50847_50865__$1 = temp__6738__auto___50864;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__50847_50865__$1)){
var c__41793__auto___50866 = cljs.core.chunk_first.call(null,seq__50847_50865__$1);
var G__50867 = cljs.core.chunk_rest.call(null,seq__50847_50865__$1);
var G__50868 = c__41793__auto___50866;
var G__50869 = cljs.core.count.call(null,c__41793__auto___50866);
var G__50870 = (0);
seq__50847_50855 = G__50867;
chunk__50848_50856 = G__50868;
count__50849_50857 = G__50869;
i__50850_50858 = G__50870;
continue;
} else {
var req_50871 = cljs.core.first.call(null,seq__50847_50865__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_50871,prov);

var G__50872 = cljs.core.next.call(null,seq__50847_50865__$1);
var G__50873 = null;
var G__50874 = (0);
var G__50875 = (0);
seq__50847_50855 = G__50872;
chunk__50848_50856 = G__50873;
count__50849_50857 = G__50874;
i__50850_50858 = G__50875;
continue;
}
} else {
}
}
break;
}

var G__50876 = seq__50843;
var G__50877 = chunk__50844;
var G__50878 = count__50845;
var G__50879 = (i__50846 + (1));
seq__50843 = G__50876;
chunk__50844 = G__50877;
count__50845 = G__50878;
i__50846 = G__50879;
continue;
} else {
var temp__6738__auto__ = cljs.core.seq.call(null,seq__50843);
if(temp__6738__auto__){
var seq__50843__$1 = temp__6738__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__50843__$1)){
var c__41793__auto__ = cljs.core.chunk_first.call(null,seq__50843__$1);
var G__50880 = cljs.core.chunk_rest.call(null,seq__50843__$1);
var G__50881 = c__41793__auto__;
var G__50882 = cljs.core.count.call(null,c__41793__auto__);
var G__50883 = (0);
seq__50843 = G__50880;
chunk__50844 = G__50881;
count__50845 = G__50882;
i__50846 = G__50883;
continue;
} else {
var prov = cljs.core.first.call(null,seq__50843__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__50851_50884 = cljs.core.seq.call(null,requires);
var chunk__50852_50885 = null;
var count__50853_50886 = (0);
var i__50854_50887 = (0);
while(true){
if((i__50854_50887 < count__50853_50886)){
var req_50888 = cljs.core._nth.call(null,chunk__50852_50885,i__50854_50887);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_50888,prov);

var G__50889 = seq__50851_50884;
var G__50890 = chunk__50852_50885;
var G__50891 = count__50853_50886;
var G__50892 = (i__50854_50887 + (1));
seq__50851_50884 = G__50889;
chunk__50852_50885 = G__50890;
count__50853_50886 = G__50891;
i__50854_50887 = G__50892;
continue;
} else {
var temp__6738__auto___50893__$1 = cljs.core.seq.call(null,seq__50851_50884);
if(temp__6738__auto___50893__$1){
var seq__50851_50894__$1 = temp__6738__auto___50893__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__50851_50894__$1)){
var c__41793__auto___50895 = cljs.core.chunk_first.call(null,seq__50851_50894__$1);
var G__50896 = cljs.core.chunk_rest.call(null,seq__50851_50894__$1);
var G__50897 = c__41793__auto___50895;
var G__50898 = cljs.core.count.call(null,c__41793__auto___50895);
var G__50899 = (0);
seq__50851_50884 = G__50896;
chunk__50852_50885 = G__50897;
count__50853_50886 = G__50898;
i__50854_50887 = G__50899;
continue;
} else {
var req_50900 = cljs.core.first.call(null,seq__50851_50894__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_50900,prov);

var G__50901 = cljs.core.next.call(null,seq__50851_50894__$1);
var G__50902 = null;
var G__50903 = (0);
var G__50904 = (0);
seq__50851_50884 = G__50901;
chunk__50852_50885 = G__50902;
count__50853_50886 = G__50903;
i__50854_50887 = G__50904;
continue;
}
} else {
}
}
break;
}

var G__50905 = cljs.core.next.call(null,seq__50843__$1);
var G__50906 = null;
var G__50907 = (0);
var G__50908 = (0);
seq__50843 = G__50905;
chunk__50844 = G__50906;
count__50845 = G__50907;
i__50846 = G__50908;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__50913_50917 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__50914_50918 = null;
var count__50915_50919 = (0);
var i__50916_50920 = (0);
while(true){
if((i__50916_50920 < count__50915_50919)){
var ns_50921 = cljs.core._nth.call(null,chunk__50914_50918,i__50916_50920);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_50921);

var G__50922 = seq__50913_50917;
var G__50923 = chunk__50914_50918;
var G__50924 = count__50915_50919;
var G__50925 = (i__50916_50920 + (1));
seq__50913_50917 = G__50922;
chunk__50914_50918 = G__50923;
count__50915_50919 = G__50924;
i__50916_50920 = G__50925;
continue;
} else {
var temp__6738__auto___50926 = cljs.core.seq.call(null,seq__50913_50917);
if(temp__6738__auto___50926){
var seq__50913_50927__$1 = temp__6738__auto___50926;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__50913_50927__$1)){
var c__41793__auto___50928 = cljs.core.chunk_first.call(null,seq__50913_50927__$1);
var G__50929 = cljs.core.chunk_rest.call(null,seq__50913_50927__$1);
var G__50930 = c__41793__auto___50928;
var G__50931 = cljs.core.count.call(null,c__41793__auto___50928);
var G__50932 = (0);
seq__50913_50917 = G__50929;
chunk__50914_50918 = G__50930;
count__50915_50919 = G__50931;
i__50916_50920 = G__50932;
continue;
} else {
var ns_50933 = cljs.core.first.call(null,seq__50913_50927__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_50933);

var G__50934 = cljs.core.next.call(null,seq__50913_50927__$1);
var G__50935 = null;
var G__50936 = (0);
var G__50937 = (0);
seq__50913_50917 = G__50934;
chunk__50914_50918 = G__50935;
count__50915_50919 = G__50936;
i__50916_50920 = G__50937;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__40882__auto__ = goog.require__;
if(cljs.core.truth_(or__40882__auto__)){
return or__40882__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__50938__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__50938 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__50939__i = 0, G__50939__a = new Array(arguments.length -  0);
while (G__50939__i < G__50939__a.length) {G__50939__a[G__50939__i] = arguments[G__50939__i + 0]; ++G__50939__i;}
  args = new cljs.core.IndexedSeq(G__50939__a,0,null);
} 
return G__50938__delegate.call(this,args);};
G__50938.cljs$lang$maxFixedArity = 0;
G__50938.cljs$lang$applyTo = (function (arglist__50940){
var args = cljs.core.seq(arglist__50940);
return G__50938__delegate(args);
});
G__50938.cljs$core$IFn$_invoke$arity$variadic = G__50938__delegate;
return G__50938;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.reload_file_in_html_env = (function figwheel$client$file_reloading$reload_file_in_html_env(request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
deferred.addCallback(((function (deferred){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred))
);

return deferred.addErrback(((function (deferred){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred))
);
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__50941 = cljs.core._EQ_;
var expr__50942 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__50941.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__50942))){
var node_path_lib = require("path");
var util_pattern = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.sep),cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.join("goog","bootstrap","nodejs.js"))].join('');
var util_path = goog.object.findKey(require.cache,((function (node_path_lib,util_pattern,pred__50941,expr__50942){
return (function (v,k,o){
return goog.string.endsWith(k,util_pattern);
});})(node_path_lib,util_pattern,pred__50941,expr__50942))
);
var parts = cljs.core.pop.call(null,cljs.core.pop.call(null,clojure.string.split.call(null,util_path,/[\/\\]/)));
var root_path = clojure.string.join.call(null,node_path_lib.sep,parts);
return ((function (node_path_lib,util_pattern,util_path,parts,root_path,pred__50941,expr__50942){
return (function (request_url,callback){

var cache_path = node_path_lib.resolve(root_path,request_url);
goog.object.remove(require.cache,cache_path);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e50944){if((e50944 instanceof Error)){
var e = e50944;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Error loading file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e50944;

}
}})());
});
;})(node_path_lib,util_pattern,util_path,parts,root_path,pred__50941,expr__50942))
} else {
if(cljs.core.truth_(pred__50941.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__50942))){
return figwheel.client.file_reloading.reload_file_in_html_env;
} else {
if(cljs.core.truth_(pred__50941.call(null,new cljs.core.Keyword(null,"react-native","react-native",-1543085138),expr__50942))){
return figwheel.client.file_reloading.reload_file_in_html_env;
} else {
if(cljs.core.truth_(pred__50941.call(null,new cljs.core.Keyword(null,"worker","worker",938239996),expr__50942))){
return ((function (pred__50941,expr__50942){
return (function (request_url,callback){

return callback.call(null,(function (){try{self.importScripts(figwheel.client.file_reloading.add_cache_buster.call(null,request_url));

return true;
}catch (e50945){if((e50945 instanceof Error)){
var e = e50945;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Error loading file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e50945;

}
}})());
});
;})(pred__50941,expr__50942))
} else {
return ((function (pred__50941,expr__50942){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__50941,expr__50942))
}
}
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__50946,callback){
var map__50949 = p__50946;
var map__50949__$1 = ((((!((map__50949 == null)))?((((map__50949.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50949.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50949):map__50949);
var file_msg = map__50949__$1;
var request_url = cljs.core.get.call(null,map__50949__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("FigWheel: Attempting to load "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__50949,map__50949__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("FigWheel: Successfully loaded "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Error loading file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__50949,map__50949__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__43449__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__43449__auto__){
return (function (){
var f__43450__auto__ = (function (){var switch__43426__auto__ = ((function (c__43449__auto__){
return (function (state_50973){
var state_val_50974 = (state_50973[(1)]);
if((state_val_50974 === (7))){
var inst_50969 = (state_50973[(2)]);
var state_50973__$1 = state_50973;
var statearr_50975_50995 = state_50973__$1;
(statearr_50975_50995[(2)] = inst_50969);

(statearr_50975_50995[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50974 === (1))){
var state_50973__$1 = state_50973;
var statearr_50976_50996 = state_50973__$1;
(statearr_50976_50996[(2)] = null);

(statearr_50976_50996[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50974 === (4))){
var inst_50953 = (state_50973[(7)]);
var inst_50953__$1 = (state_50973[(2)]);
var state_50973__$1 = (function (){var statearr_50977 = state_50973;
(statearr_50977[(7)] = inst_50953__$1);

return statearr_50977;
})();
if(cljs.core.truth_(inst_50953__$1)){
var statearr_50978_50997 = state_50973__$1;
(statearr_50978_50997[(1)] = (5));

} else {
var statearr_50979_50998 = state_50973__$1;
(statearr_50979_50998[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50974 === (6))){
var state_50973__$1 = state_50973;
var statearr_50980_50999 = state_50973__$1;
(statearr_50980_50999[(2)] = null);

(statearr_50980_50999[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50974 === (3))){
var inst_50971 = (state_50973[(2)]);
var state_50973__$1 = state_50973;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_50973__$1,inst_50971);
} else {
if((state_val_50974 === (2))){
var state_50973__$1 = state_50973;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50973__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_50974 === (11))){
var inst_50965 = (state_50973[(2)]);
var state_50973__$1 = (function (){var statearr_50981 = state_50973;
(statearr_50981[(8)] = inst_50965);

return statearr_50981;
})();
var statearr_50982_51000 = state_50973__$1;
(statearr_50982_51000[(2)] = null);

(statearr_50982_51000[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50974 === (9))){
var inst_50957 = (state_50973[(9)]);
var inst_50959 = (state_50973[(10)]);
var inst_50961 = inst_50959.call(null,inst_50957);
var state_50973__$1 = state_50973;
var statearr_50983_51001 = state_50973__$1;
(statearr_50983_51001[(2)] = inst_50961);

(statearr_50983_51001[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50974 === (5))){
var inst_50953 = (state_50973[(7)]);
var inst_50955 = figwheel.client.file_reloading.blocking_load.call(null,inst_50953);
var state_50973__$1 = state_50973;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50973__$1,(8),inst_50955);
} else {
if((state_val_50974 === (10))){
var inst_50957 = (state_50973[(9)]);
var inst_50963 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_50957);
var state_50973__$1 = state_50973;
var statearr_50984_51002 = state_50973__$1;
(statearr_50984_51002[(2)] = inst_50963);

(statearr_50984_51002[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50974 === (8))){
var inst_50959 = (state_50973[(10)]);
var inst_50953 = (state_50973[(7)]);
var inst_50957 = (state_50973[(2)]);
var inst_50958 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_50959__$1 = cljs.core.get.call(null,inst_50958,inst_50953);
var state_50973__$1 = (function (){var statearr_50985 = state_50973;
(statearr_50985[(9)] = inst_50957);

(statearr_50985[(10)] = inst_50959__$1);

return statearr_50985;
})();
if(cljs.core.truth_(inst_50959__$1)){
var statearr_50986_51003 = state_50973__$1;
(statearr_50986_51003[(1)] = (9));

} else {
var statearr_50987_51004 = state_50973__$1;
(statearr_50987_51004[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__43449__auto__))
;
return ((function (switch__43426__auto__,c__43449__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__43427__auto__ = null;
var figwheel$client$file_reloading$state_machine__43427__auto____0 = (function (){
var statearr_50991 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_50991[(0)] = figwheel$client$file_reloading$state_machine__43427__auto__);

(statearr_50991[(1)] = (1));

return statearr_50991;
});
var figwheel$client$file_reloading$state_machine__43427__auto____1 = (function (state_50973){
while(true){
var ret_value__43428__auto__ = (function (){try{while(true){
var result__43429__auto__ = switch__43426__auto__.call(null,state_50973);
if(cljs.core.keyword_identical_QMARK_.call(null,result__43429__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43429__auto__;
}
break;
}
}catch (e50992){if((e50992 instanceof Object)){
var ex__43430__auto__ = e50992;
var statearr_50993_51005 = state_50973;
(statearr_50993_51005[(5)] = ex__43430__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_50973);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e50992;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__43428__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51006 = state_50973;
state_50973 = G__51006;
continue;
} else {
return ret_value__43428__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__43427__auto__ = function(state_50973){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__43427__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__43427__auto____1.call(this,state_50973);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$state_machine__43427__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__43427__auto____0;
figwheel$client$file_reloading$state_machine__43427__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__43427__auto____1;
return figwheel$client$file_reloading$state_machine__43427__auto__;
})()
;})(switch__43426__auto__,c__43449__auto__))
})();
var state__43451__auto__ = (function (){var statearr_50994 = f__43450__auto__.call(null);
(statearr_50994[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__43449__auto__);

return statearr_50994;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__43451__auto__);
});})(c__43449__auto__))
);

return c__43449__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__51007,callback){
var map__51010 = p__51007;
var map__51010__$1 = ((((!((map__51010 == null)))?((((map__51010.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51010.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__51010):map__51010);
var file_msg = map__51010__$1;
var namespace = cljs.core.get.call(null,map__51010__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__51010,map__51010__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__51010,map__51010__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.figwheel_no_load_QMARK_ = (function figwheel$client$file_reloading$figwheel_no_load_QMARK_(p__51012){
var map__51015 = p__51012;
var map__51015__$1 = ((((!((map__51015 == null)))?((((map__51015.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51015.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__51015):map__51015);
var file_msg = map__51015__$1;
var namespace = cljs.core.get.call(null,map__51015__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__51017){
var map__51020 = p__51017;
var map__51020__$1 = ((((!((map__51020 == null)))?((((map__51020.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51020.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__51020):map__51020);
var file_msg = map__51020__$1;
var namespace = cljs.core.get.call(null,map__51020__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__40870__auto__ = cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,file_msg));
if(and__40870__auto__){
var or__40882__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__40882__auto__)){
return or__40882__auto__;
} else {
var or__40882__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__40882__auto____$1)){
return or__40882__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__40870__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__51022,callback){
var map__51025 = p__51022;
var map__51025__$1 = ((((!((map__51025 == null)))?((((map__51025.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51025.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__51025):map__51025);
var file_msg = map__51025__$1;
var request_url = cljs.core.get.call(null,map__51025__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__51025__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Not trying to load file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__43449__auto___51129 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__43449__auto___51129,out){
return (function (){
var f__43450__auto__ = (function (){var switch__43426__auto__ = ((function (c__43449__auto___51129,out){
return (function (state_51111){
var state_val_51112 = (state_51111[(1)]);
if((state_val_51112 === (1))){
var inst_51085 = cljs.core.seq.call(null,files);
var inst_51086 = cljs.core.first.call(null,inst_51085);
var inst_51087 = cljs.core.next.call(null,inst_51085);
var inst_51088 = files;
var state_51111__$1 = (function (){var statearr_51113 = state_51111;
(statearr_51113[(7)] = inst_51087);

(statearr_51113[(8)] = inst_51086);

(statearr_51113[(9)] = inst_51088);

return statearr_51113;
})();
var statearr_51114_51130 = state_51111__$1;
(statearr_51114_51130[(2)] = null);

(statearr_51114_51130[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51112 === (2))){
var inst_51094 = (state_51111[(10)]);
var inst_51088 = (state_51111[(9)]);
var inst_51093 = cljs.core.seq.call(null,inst_51088);
var inst_51094__$1 = cljs.core.first.call(null,inst_51093);
var inst_51095 = cljs.core.next.call(null,inst_51093);
var inst_51096 = (inst_51094__$1 == null);
var inst_51097 = cljs.core.not.call(null,inst_51096);
var state_51111__$1 = (function (){var statearr_51115 = state_51111;
(statearr_51115[(10)] = inst_51094__$1);

(statearr_51115[(11)] = inst_51095);

return statearr_51115;
})();
if(inst_51097){
var statearr_51116_51131 = state_51111__$1;
(statearr_51116_51131[(1)] = (4));

} else {
var statearr_51117_51132 = state_51111__$1;
(statearr_51117_51132[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51112 === (3))){
var inst_51109 = (state_51111[(2)]);
var state_51111__$1 = state_51111;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_51111__$1,inst_51109);
} else {
if((state_val_51112 === (4))){
var inst_51094 = (state_51111[(10)]);
var inst_51099 = figwheel.client.file_reloading.reload_js_file.call(null,inst_51094);
var state_51111__$1 = state_51111;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51111__$1,(7),inst_51099);
} else {
if((state_val_51112 === (5))){
var inst_51105 = cljs.core.async.close_BANG_.call(null,out);
var state_51111__$1 = state_51111;
var statearr_51118_51133 = state_51111__$1;
(statearr_51118_51133[(2)] = inst_51105);

(statearr_51118_51133[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51112 === (6))){
var inst_51107 = (state_51111[(2)]);
var state_51111__$1 = state_51111;
var statearr_51119_51134 = state_51111__$1;
(statearr_51119_51134[(2)] = inst_51107);

(statearr_51119_51134[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51112 === (7))){
var inst_51095 = (state_51111[(11)]);
var inst_51101 = (state_51111[(2)]);
var inst_51102 = cljs.core.async.put_BANG_.call(null,out,inst_51101);
var inst_51088 = inst_51095;
var state_51111__$1 = (function (){var statearr_51120 = state_51111;
(statearr_51120[(12)] = inst_51102);

(statearr_51120[(9)] = inst_51088);

return statearr_51120;
})();
var statearr_51121_51135 = state_51111__$1;
(statearr_51121_51135[(2)] = null);

(statearr_51121_51135[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__43449__auto___51129,out))
;
return ((function (switch__43426__auto__,c__43449__auto___51129,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__43427__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__43427__auto____0 = (function (){
var statearr_51125 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_51125[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__43427__auto__);

(statearr_51125[(1)] = (1));

return statearr_51125;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__43427__auto____1 = (function (state_51111){
while(true){
var ret_value__43428__auto__ = (function (){try{while(true){
var result__43429__auto__ = switch__43426__auto__.call(null,state_51111);
if(cljs.core.keyword_identical_QMARK_.call(null,result__43429__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43429__auto__;
}
break;
}
}catch (e51126){if((e51126 instanceof Object)){
var ex__43430__auto__ = e51126;
var statearr_51127_51136 = state_51111;
(statearr_51127_51136[(5)] = ex__43430__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_51111);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e51126;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__43428__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51137 = state_51111;
state_51111 = G__51137;
continue;
} else {
return ret_value__43428__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__43427__auto__ = function(state_51111){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__43427__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__43427__auto____1.call(this,state_51111);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__43427__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__43427__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__43427__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__43427__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__43427__auto__;
})()
;})(switch__43426__auto__,c__43449__auto___51129,out))
})();
var state__43451__auto__ = (function (){var statearr_51128 = f__43450__auto__.call(null);
(statearr_51128[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__43449__auto___51129);

return statearr_51128;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__43451__auto__);
});})(c__43449__auto___51129,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__51138,opts){
var map__51142 = p__51138;
var map__51142__$1 = ((((!((map__51142 == null)))?((((map__51142.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51142.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__51142):map__51142);
var eval_body = cljs.core.get.call(null,map__51142__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__51142__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__40870__auto__ = eval_body;
if(cljs.core.truth_(and__40870__auto__)){
return typeof eval_body === 'string';
} else {
return and__40870__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Evaling file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e51144){var e = e51144;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Unable to evaluate "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,cljs.core.partial.call(null,cljs.core.re_matches,/figwheel\.connect.*/),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__6736__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__51145_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__51145_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__6736__auto__)){
var file_msg = temp__6736__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__51154){
var vec__51155 = p__51154;
var k = cljs.core.nth.call(null,vec__51155,(0),null);
var v = cljs.core.nth.call(null,vec__51155,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__51158){
var vec__51159 = p__51158;
var k = cljs.core.nth.call(null,vec__51159,(0),null);
var v = cljs.core.nth.call(null,vec__51159,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__51165,p__51166){
var map__51414 = p__51165;
var map__51414__$1 = ((((!((map__51414 == null)))?((((map__51414.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51414.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__51414):map__51414);
var opts = map__51414__$1;
var before_jsload = cljs.core.get.call(null,map__51414__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__51414__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__51414__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__51415 = p__51166;
var map__51415__$1 = ((((!((map__51415 == null)))?((((map__51415.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51415.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__51415):map__51415);
var msg = map__51415__$1;
var files = cljs.core.get.call(null,map__51415__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__51415__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__51415__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__43449__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__43449__auto__,map__51414,map__51414__$1,opts,before_jsload,on_jsload,reload_dependents,map__51415,map__51415__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__43450__auto__ = (function (){var switch__43426__auto__ = ((function (c__43449__auto__,map__51414,map__51414__$1,opts,before_jsload,on_jsload,reload_dependents,map__51415,map__51415__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_51569){
var state_val_51570 = (state_51569[(1)]);
if((state_val_51570 === (7))){
var inst_51431 = (state_51569[(7)]);
var inst_51430 = (state_51569[(8)]);
var inst_51429 = (state_51569[(9)]);
var inst_51432 = (state_51569[(10)]);
var inst_51437 = cljs.core._nth.call(null,inst_51430,inst_51432);
var inst_51438 = figwheel.client.file_reloading.eval_body.call(null,inst_51437,opts);
var inst_51439 = (inst_51432 + (1));
var tmp51571 = inst_51431;
var tmp51572 = inst_51430;
var tmp51573 = inst_51429;
var inst_51429__$1 = tmp51573;
var inst_51430__$1 = tmp51572;
var inst_51431__$1 = tmp51571;
var inst_51432__$1 = inst_51439;
var state_51569__$1 = (function (){var statearr_51574 = state_51569;
(statearr_51574[(7)] = inst_51431__$1);

(statearr_51574[(11)] = inst_51438);

(statearr_51574[(8)] = inst_51430__$1);

(statearr_51574[(9)] = inst_51429__$1);

(statearr_51574[(10)] = inst_51432__$1);

return statearr_51574;
})();
var statearr_51575_51661 = state_51569__$1;
(statearr_51575_51661[(2)] = null);

(statearr_51575_51661[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (20))){
var inst_51472 = (state_51569[(12)]);
var inst_51480 = figwheel.client.file_reloading.sort_files.call(null,inst_51472);
var state_51569__$1 = state_51569;
var statearr_51576_51662 = state_51569__$1;
(statearr_51576_51662[(2)] = inst_51480);

(statearr_51576_51662[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (27))){
var state_51569__$1 = state_51569;
var statearr_51577_51663 = state_51569__$1;
(statearr_51577_51663[(2)] = null);

(statearr_51577_51663[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (1))){
var inst_51421 = (state_51569[(13)]);
var inst_51418 = before_jsload.call(null,files);
var inst_51419 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_51420 = (function (){return ((function (inst_51421,inst_51418,inst_51419,state_val_51570,c__43449__auto__,map__51414,map__51414__$1,opts,before_jsload,on_jsload,reload_dependents,map__51415,map__51415__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__51162_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__51162_SHARP_);
});
;})(inst_51421,inst_51418,inst_51419,state_val_51570,c__43449__auto__,map__51414,map__51414__$1,opts,before_jsload,on_jsload,reload_dependents,map__51415,map__51415__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_51421__$1 = cljs.core.filter.call(null,inst_51420,files);
var inst_51422 = cljs.core.not_empty.call(null,inst_51421__$1);
var state_51569__$1 = (function (){var statearr_51578 = state_51569;
(statearr_51578[(14)] = inst_51418);

(statearr_51578[(15)] = inst_51419);

(statearr_51578[(13)] = inst_51421__$1);

return statearr_51578;
})();
if(cljs.core.truth_(inst_51422)){
var statearr_51579_51664 = state_51569__$1;
(statearr_51579_51664[(1)] = (2));

} else {
var statearr_51580_51665 = state_51569__$1;
(statearr_51580_51665[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (24))){
var state_51569__$1 = state_51569;
var statearr_51581_51666 = state_51569__$1;
(statearr_51581_51666[(2)] = null);

(statearr_51581_51666[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (39))){
var inst_51522 = (state_51569[(16)]);
var state_51569__$1 = state_51569;
var statearr_51582_51667 = state_51569__$1;
(statearr_51582_51667[(2)] = inst_51522);

(statearr_51582_51667[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (46))){
var inst_51564 = (state_51569[(2)]);
var state_51569__$1 = state_51569;
var statearr_51583_51668 = state_51569__$1;
(statearr_51583_51668[(2)] = inst_51564);

(statearr_51583_51668[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (4))){
var inst_51466 = (state_51569[(2)]);
var inst_51467 = cljs.core.List.EMPTY;
var inst_51468 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_51467);
var inst_51469 = (function (){return ((function (inst_51466,inst_51467,inst_51468,state_val_51570,c__43449__auto__,map__51414,map__51414__$1,opts,before_jsload,on_jsload,reload_dependents,map__51415,map__51415__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__51163_SHARP_){
var and__40870__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__51163_SHARP_);
if(cljs.core.truth_(and__40870__auto__)){
return (cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__51163_SHARP_))) && (cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,p1__51163_SHARP_)));
} else {
return and__40870__auto__;
}
});
;})(inst_51466,inst_51467,inst_51468,state_val_51570,c__43449__auto__,map__51414,map__51414__$1,opts,before_jsload,on_jsload,reload_dependents,map__51415,map__51415__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_51470 = cljs.core.filter.call(null,inst_51469,files);
var inst_51471 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_51472 = cljs.core.concat.call(null,inst_51470,inst_51471);
var state_51569__$1 = (function (){var statearr_51584 = state_51569;
(statearr_51584[(17)] = inst_51468);

(statearr_51584[(12)] = inst_51472);

(statearr_51584[(18)] = inst_51466);

return statearr_51584;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_51585_51669 = state_51569__$1;
(statearr_51585_51669[(1)] = (16));

} else {
var statearr_51586_51670 = state_51569__$1;
(statearr_51586_51670[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (15))){
var inst_51456 = (state_51569[(2)]);
var state_51569__$1 = state_51569;
var statearr_51587_51671 = state_51569__$1;
(statearr_51587_51671[(2)] = inst_51456);

(statearr_51587_51671[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (21))){
var inst_51482 = (state_51569[(19)]);
var inst_51482__$1 = (state_51569[(2)]);
var inst_51483 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_51482__$1);
var state_51569__$1 = (function (){var statearr_51588 = state_51569;
(statearr_51588[(19)] = inst_51482__$1);

return statearr_51588;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51569__$1,(22),inst_51483);
} else {
if((state_val_51570 === (31))){
var inst_51567 = (state_51569[(2)]);
var state_51569__$1 = state_51569;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_51569__$1,inst_51567);
} else {
if((state_val_51570 === (32))){
var inst_51522 = (state_51569[(16)]);
var inst_51527 = inst_51522.cljs$lang$protocol_mask$partition0$;
var inst_51528 = (inst_51527 & (64));
var inst_51529 = inst_51522.cljs$core$ISeq$;
var inst_51530 = (cljs.core.PROTOCOL_SENTINEL === inst_51529);
var inst_51531 = (inst_51528) || (inst_51530);
var state_51569__$1 = state_51569;
if(cljs.core.truth_(inst_51531)){
var statearr_51589_51672 = state_51569__$1;
(statearr_51589_51672[(1)] = (35));

} else {
var statearr_51590_51673 = state_51569__$1;
(statearr_51590_51673[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (40))){
var inst_51544 = (state_51569[(20)]);
var inst_51543 = (state_51569[(2)]);
var inst_51544__$1 = cljs.core.get.call(null,inst_51543,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_51545 = cljs.core.get.call(null,inst_51543,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_51546 = cljs.core.not_empty.call(null,inst_51544__$1);
var state_51569__$1 = (function (){var statearr_51591 = state_51569;
(statearr_51591[(20)] = inst_51544__$1);

(statearr_51591[(21)] = inst_51545);

return statearr_51591;
})();
if(cljs.core.truth_(inst_51546)){
var statearr_51592_51674 = state_51569__$1;
(statearr_51592_51674[(1)] = (41));

} else {
var statearr_51593_51675 = state_51569__$1;
(statearr_51593_51675[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (33))){
var state_51569__$1 = state_51569;
var statearr_51594_51676 = state_51569__$1;
(statearr_51594_51676[(2)] = false);

(statearr_51594_51676[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (13))){
var inst_51442 = (state_51569[(22)]);
var inst_51446 = cljs.core.chunk_first.call(null,inst_51442);
var inst_51447 = cljs.core.chunk_rest.call(null,inst_51442);
var inst_51448 = cljs.core.count.call(null,inst_51446);
var inst_51429 = inst_51447;
var inst_51430 = inst_51446;
var inst_51431 = inst_51448;
var inst_51432 = (0);
var state_51569__$1 = (function (){var statearr_51595 = state_51569;
(statearr_51595[(7)] = inst_51431);

(statearr_51595[(8)] = inst_51430);

(statearr_51595[(9)] = inst_51429);

(statearr_51595[(10)] = inst_51432);

return statearr_51595;
})();
var statearr_51596_51677 = state_51569__$1;
(statearr_51596_51677[(2)] = null);

(statearr_51596_51677[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (22))){
var inst_51490 = (state_51569[(23)]);
var inst_51486 = (state_51569[(24)]);
var inst_51482 = (state_51569[(19)]);
var inst_51485 = (state_51569[(25)]);
var inst_51485__$1 = (state_51569[(2)]);
var inst_51486__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_51485__$1);
var inst_51487 = (function (){var all_files = inst_51482;
var res_SINGLEQUOTE_ = inst_51485__$1;
var res = inst_51486__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_51490,inst_51486,inst_51482,inst_51485,inst_51485__$1,inst_51486__$1,state_val_51570,c__43449__auto__,map__51414,map__51414__$1,opts,before_jsload,on_jsload,reload_dependents,map__51415,map__51415__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__51164_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__51164_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_51490,inst_51486,inst_51482,inst_51485,inst_51485__$1,inst_51486__$1,state_val_51570,c__43449__auto__,map__51414,map__51414__$1,opts,before_jsload,on_jsload,reload_dependents,map__51415,map__51415__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_51488 = cljs.core.filter.call(null,inst_51487,inst_51485__$1);
var inst_51489 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_51490__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_51489);
var inst_51491 = cljs.core.not_empty.call(null,inst_51490__$1);
var state_51569__$1 = (function (){var statearr_51597 = state_51569;
(statearr_51597[(23)] = inst_51490__$1);

(statearr_51597[(24)] = inst_51486__$1);

(statearr_51597[(26)] = inst_51488);

(statearr_51597[(25)] = inst_51485__$1);

return statearr_51597;
})();
if(cljs.core.truth_(inst_51491)){
var statearr_51598_51678 = state_51569__$1;
(statearr_51598_51678[(1)] = (23));

} else {
var statearr_51599_51679 = state_51569__$1;
(statearr_51599_51679[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (36))){
var state_51569__$1 = state_51569;
var statearr_51600_51680 = state_51569__$1;
(statearr_51600_51680[(2)] = false);

(statearr_51600_51680[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (41))){
var inst_51544 = (state_51569[(20)]);
var inst_51548 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_51549 = cljs.core.map.call(null,inst_51548,inst_51544);
var inst_51550 = cljs.core.pr_str.call(null,inst_51549);
var inst_51551 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("figwheel-no-load meta-data: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_51550)].join('');
var inst_51552 = figwheel.client.utils.log.call(null,inst_51551);
var state_51569__$1 = state_51569;
var statearr_51601_51681 = state_51569__$1;
(statearr_51601_51681[(2)] = inst_51552);

(statearr_51601_51681[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (43))){
var inst_51545 = (state_51569[(21)]);
var inst_51555 = (state_51569[(2)]);
var inst_51556 = cljs.core.not_empty.call(null,inst_51545);
var state_51569__$1 = (function (){var statearr_51602 = state_51569;
(statearr_51602[(27)] = inst_51555);

return statearr_51602;
})();
if(cljs.core.truth_(inst_51556)){
var statearr_51603_51682 = state_51569__$1;
(statearr_51603_51682[(1)] = (44));

} else {
var statearr_51604_51683 = state_51569__$1;
(statearr_51604_51683[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (29))){
var inst_51522 = (state_51569[(16)]);
var inst_51490 = (state_51569[(23)]);
var inst_51486 = (state_51569[(24)]);
var inst_51482 = (state_51569[(19)]);
var inst_51488 = (state_51569[(26)]);
var inst_51485 = (state_51569[(25)]);
var inst_51518 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_51521 = (function (){var all_files = inst_51482;
var res_SINGLEQUOTE_ = inst_51485;
var res = inst_51486;
var files_not_loaded = inst_51488;
var dependencies_that_loaded = inst_51490;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_51522,inst_51490,inst_51486,inst_51482,inst_51488,inst_51485,inst_51518,state_val_51570,c__43449__auto__,map__51414,map__51414__$1,opts,before_jsload,on_jsload,reload_dependents,map__51415,map__51415__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__51520){
var map__51605 = p__51520;
var map__51605__$1 = ((((!((map__51605 == null)))?((((map__51605.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51605.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__51605):map__51605);
var namespace = cljs.core.get.call(null,map__51605__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_51522,inst_51490,inst_51486,inst_51482,inst_51488,inst_51485,inst_51518,state_val_51570,c__43449__auto__,map__51414,map__51414__$1,opts,before_jsload,on_jsload,reload_dependents,map__51415,map__51415__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_51522__$1 = cljs.core.group_by.call(null,inst_51521,inst_51488);
var inst_51524 = (inst_51522__$1 == null);
var inst_51525 = cljs.core.not.call(null,inst_51524);
var state_51569__$1 = (function (){var statearr_51607 = state_51569;
(statearr_51607[(16)] = inst_51522__$1);

(statearr_51607[(28)] = inst_51518);

return statearr_51607;
})();
if(inst_51525){
var statearr_51608_51684 = state_51569__$1;
(statearr_51608_51684[(1)] = (32));

} else {
var statearr_51609_51685 = state_51569__$1;
(statearr_51609_51685[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (44))){
var inst_51545 = (state_51569[(21)]);
var inst_51558 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_51545);
var inst_51559 = cljs.core.pr_str.call(null,inst_51558);
var inst_51560 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("not required: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_51559)].join('');
var inst_51561 = figwheel.client.utils.log.call(null,inst_51560);
var state_51569__$1 = state_51569;
var statearr_51610_51686 = state_51569__$1;
(statearr_51610_51686[(2)] = inst_51561);

(statearr_51610_51686[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (6))){
var inst_51463 = (state_51569[(2)]);
var state_51569__$1 = state_51569;
var statearr_51611_51687 = state_51569__$1;
(statearr_51611_51687[(2)] = inst_51463);

(statearr_51611_51687[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (28))){
var inst_51488 = (state_51569[(26)]);
var inst_51515 = (state_51569[(2)]);
var inst_51516 = cljs.core.not_empty.call(null,inst_51488);
var state_51569__$1 = (function (){var statearr_51612 = state_51569;
(statearr_51612[(29)] = inst_51515);

return statearr_51612;
})();
if(cljs.core.truth_(inst_51516)){
var statearr_51613_51688 = state_51569__$1;
(statearr_51613_51688[(1)] = (29));

} else {
var statearr_51614_51689 = state_51569__$1;
(statearr_51614_51689[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (25))){
var inst_51486 = (state_51569[(24)]);
var inst_51502 = (state_51569[(2)]);
var inst_51503 = cljs.core.not_empty.call(null,inst_51486);
var state_51569__$1 = (function (){var statearr_51615 = state_51569;
(statearr_51615[(30)] = inst_51502);

return statearr_51615;
})();
if(cljs.core.truth_(inst_51503)){
var statearr_51616_51690 = state_51569__$1;
(statearr_51616_51690[(1)] = (26));

} else {
var statearr_51617_51691 = state_51569__$1;
(statearr_51617_51691[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (34))){
var inst_51538 = (state_51569[(2)]);
var state_51569__$1 = state_51569;
if(cljs.core.truth_(inst_51538)){
var statearr_51618_51692 = state_51569__$1;
(statearr_51618_51692[(1)] = (38));

} else {
var statearr_51619_51693 = state_51569__$1;
(statearr_51619_51693[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (17))){
var state_51569__$1 = state_51569;
var statearr_51620_51694 = state_51569__$1;
(statearr_51620_51694[(2)] = recompile_dependents);

(statearr_51620_51694[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (3))){
var state_51569__$1 = state_51569;
var statearr_51621_51695 = state_51569__$1;
(statearr_51621_51695[(2)] = null);

(statearr_51621_51695[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (12))){
var inst_51459 = (state_51569[(2)]);
var state_51569__$1 = state_51569;
var statearr_51622_51696 = state_51569__$1;
(statearr_51622_51696[(2)] = inst_51459);

(statearr_51622_51696[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (2))){
var inst_51421 = (state_51569[(13)]);
var inst_51428 = cljs.core.seq.call(null,inst_51421);
var inst_51429 = inst_51428;
var inst_51430 = null;
var inst_51431 = (0);
var inst_51432 = (0);
var state_51569__$1 = (function (){var statearr_51623 = state_51569;
(statearr_51623[(7)] = inst_51431);

(statearr_51623[(8)] = inst_51430);

(statearr_51623[(9)] = inst_51429);

(statearr_51623[(10)] = inst_51432);

return statearr_51623;
})();
var statearr_51624_51697 = state_51569__$1;
(statearr_51624_51697[(2)] = null);

(statearr_51624_51697[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (23))){
var inst_51490 = (state_51569[(23)]);
var inst_51486 = (state_51569[(24)]);
var inst_51482 = (state_51569[(19)]);
var inst_51488 = (state_51569[(26)]);
var inst_51485 = (state_51569[(25)]);
var inst_51493 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_51495 = (function (){var all_files = inst_51482;
var res_SINGLEQUOTE_ = inst_51485;
var res = inst_51486;
var files_not_loaded = inst_51488;
var dependencies_that_loaded = inst_51490;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_51490,inst_51486,inst_51482,inst_51488,inst_51485,inst_51493,state_val_51570,c__43449__auto__,map__51414,map__51414__$1,opts,before_jsload,on_jsload,reload_dependents,map__51415,map__51415__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__51494){
var map__51625 = p__51494;
var map__51625__$1 = ((((!((map__51625 == null)))?((((map__51625.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51625.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__51625):map__51625);
var request_url = cljs.core.get.call(null,map__51625__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_51490,inst_51486,inst_51482,inst_51488,inst_51485,inst_51493,state_val_51570,c__43449__auto__,map__51414,map__51414__$1,opts,before_jsload,on_jsload,reload_dependents,map__51415,map__51415__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_51496 = cljs.core.reverse.call(null,inst_51490);
var inst_51497 = cljs.core.map.call(null,inst_51495,inst_51496);
var inst_51498 = cljs.core.pr_str.call(null,inst_51497);
var inst_51499 = figwheel.client.utils.log.call(null,inst_51498);
var state_51569__$1 = (function (){var statearr_51627 = state_51569;
(statearr_51627[(31)] = inst_51493);

return statearr_51627;
})();
var statearr_51628_51698 = state_51569__$1;
(statearr_51628_51698[(2)] = inst_51499);

(statearr_51628_51698[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (35))){
var state_51569__$1 = state_51569;
var statearr_51629_51699 = state_51569__$1;
(statearr_51629_51699[(2)] = true);

(statearr_51629_51699[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (19))){
var inst_51472 = (state_51569[(12)]);
var inst_51478 = figwheel.client.file_reloading.expand_files.call(null,inst_51472);
var state_51569__$1 = state_51569;
var statearr_51630_51700 = state_51569__$1;
(statearr_51630_51700[(2)] = inst_51478);

(statearr_51630_51700[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (11))){
var state_51569__$1 = state_51569;
var statearr_51631_51701 = state_51569__$1;
(statearr_51631_51701[(2)] = null);

(statearr_51631_51701[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (9))){
var inst_51461 = (state_51569[(2)]);
var state_51569__$1 = state_51569;
var statearr_51632_51702 = state_51569__$1;
(statearr_51632_51702[(2)] = inst_51461);

(statearr_51632_51702[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (5))){
var inst_51431 = (state_51569[(7)]);
var inst_51432 = (state_51569[(10)]);
var inst_51434 = (inst_51432 < inst_51431);
var inst_51435 = inst_51434;
var state_51569__$1 = state_51569;
if(cljs.core.truth_(inst_51435)){
var statearr_51633_51703 = state_51569__$1;
(statearr_51633_51703[(1)] = (7));

} else {
var statearr_51634_51704 = state_51569__$1;
(statearr_51634_51704[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (14))){
var inst_51442 = (state_51569[(22)]);
var inst_51451 = cljs.core.first.call(null,inst_51442);
var inst_51452 = figwheel.client.file_reloading.eval_body.call(null,inst_51451,opts);
var inst_51453 = cljs.core.next.call(null,inst_51442);
var inst_51429 = inst_51453;
var inst_51430 = null;
var inst_51431 = (0);
var inst_51432 = (0);
var state_51569__$1 = (function (){var statearr_51635 = state_51569;
(statearr_51635[(7)] = inst_51431);

(statearr_51635[(8)] = inst_51430);

(statearr_51635[(32)] = inst_51452);

(statearr_51635[(9)] = inst_51429);

(statearr_51635[(10)] = inst_51432);

return statearr_51635;
})();
var statearr_51636_51705 = state_51569__$1;
(statearr_51636_51705[(2)] = null);

(statearr_51636_51705[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (45))){
var state_51569__$1 = state_51569;
var statearr_51637_51706 = state_51569__$1;
(statearr_51637_51706[(2)] = null);

(statearr_51637_51706[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (26))){
var inst_51490 = (state_51569[(23)]);
var inst_51486 = (state_51569[(24)]);
var inst_51482 = (state_51569[(19)]);
var inst_51488 = (state_51569[(26)]);
var inst_51485 = (state_51569[(25)]);
var inst_51505 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_51507 = (function (){var all_files = inst_51482;
var res_SINGLEQUOTE_ = inst_51485;
var res = inst_51486;
var files_not_loaded = inst_51488;
var dependencies_that_loaded = inst_51490;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_51490,inst_51486,inst_51482,inst_51488,inst_51485,inst_51505,state_val_51570,c__43449__auto__,map__51414,map__51414__$1,opts,before_jsload,on_jsload,reload_dependents,map__51415,map__51415__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__51506){
var map__51638 = p__51506;
var map__51638__$1 = ((((!((map__51638 == null)))?((((map__51638.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51638.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__51638):map__51638);
var namespace = cljs.core.get.call(null,map__51638__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__51638__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_51490,inst_51486,inst_51482,inst_51488,inst_51485,inst_51505,state_val_51570,c__43449__auto__,map__51414,map__51414__$1,opts,before_jsload,on_jsload,reload_dependents,map__51415,map__51415__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_51508 = cljs.core.map.call(null,inst_51507,inst_51486);
var inst_51509 = cljs.core.pr_str.call(null,inst_51508);
var inst_51510 = figwheel.client.utils.log.call(null,inst_51509);
var inst_51511 = (function (){var all_files = inst_51482;
var res_SINGLEQUOTE_ = inst_51485;
var res = inst_51486;
var files_not_loaded = inst_51488;
var dependencies_that_loaded = inst_51490;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_51490,inst_51486,inst_51482,inst_51488,inst_51485,inst_51505,inst_51507,inst_51508,inst_51509,inst_51510,state_val_51570,c__43449__auto__,map__51414,map__51414__$1,opts,before_jsload,on_jsload,reload_dependents,map__51415,map__51415__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_51490,inst_51486,inst_51482,inst_51488,inst_51485,inst_51505,inst_51507,inst_51508,inst_51509,inst_51510,state_val_51570,c__43449__auto__,map__51414,map__51414__$1,opts,before_jsload,on_jsload,reload_dependents,map__51415,map__51415__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_51512 = setTimeout(inst_51511,(10));
var state_51569__$1 = (function (){var statearr_51640 = state_51569;
(statearr_51640[(33)] = inst_51505);

(statearr_51640[(34)] = inst_51510);

return statearr_51640;
})();
var statearr_51641_51707 = state_51569__$1;
(statearr_51641_51707[(2)] = inst_51512);

(statearr_51641_51707[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (16))){
var state_51569__$1 = state_51569;
var statearr_51642_51708 = state_51569__$1;
(statearr_51642_51708[(2)] = reload_dependents);

(statearr_51642_51708[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (38))){
var inst_51522 = (state_51569[(16)]);
var inst_51540 = cljs.core.apply.call(null,cljs.core.hash_map,inst_51522);
var state_51569__$1 = state_51569;
var statearr_51643_51709 = state_51569__$1;
(statearr_51643_51709[(2)] = inst_51540);

(statearr_51643_51709[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (30))){
var state_51569__$1 = state_51569;
var statearr_51644_51710 = state_51569__$1;
(statearr_51644_51710[(2)] = null);

(statearr_51644_51710[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (10))){
var inst_51442 = (state_51569[(22)]);
var inst_51444 = cljs.core.chunked_seq_QMARK_.call(null,inst_51442);
var state_51569__$1 = state_51569;
if(inst_51444){
var statearr_51645_51711 = state_51569__$1;
(statearr_51645_51711[(1)] = (13));

} else {
var statearr_51646_51712 = state_51569__$1;
(statearr_51646_51712[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (18))){
var inst_51476 = (state_51569[(2)]);
var state_51569__$1 = state_51569;
if(cljs.core.truth_(inst_51476)){
var statearr_51647_51713 = state_51569__$1;
(statearr_51647_51713[(1)] = (19));

} else {
var statearr_51648_51714 = state_51569__$1;
(statearr_51648_51714[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (42))){
var state_51569__$1 = state_51569;
var statearr_51649_51715 = state_51569__$1;
(statearr_51649_51715[(2)] = null);

(statearr_51649_51715[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (37))){
var inst_51535 = (state_51569[(2)]);
var state_51569__$1 = state_51569;
var statearr_51650_51716 = state_51569__$1;
(statearr_51650_51716[(2)] = inst_51535);

(statearr_51650_51716[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51570 === (8))){
var inst_51429 = (state_51569[(9)]);
var inst_51442 = (state_51569[(22)]);
var inst_51442__$1 = cljs.core.seq.call(null,inst_51429);
var state_51569__$1 = (function (){var statearr_51651 = state_51569;
(statearr_51651[(22)] = inst_51442__$1);

return statearr_51651;
})();
if(inst_51442__$1){
var statearr_51652_51717 = state_51569__$1;
(statearr_51652_51717[(1)] = (10));

} else {
var statearr_51653_51718 = state_51569__$1;
(statearr_51653_51718[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__43449__auto__,map__51414,map__51414__$1,opts,before_jsload,on_jsload,reload_dependents,map__51415,map__51415__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__43426__auto__,c__43449__auto__,map__51414,map__51414__$1,opts,before_jsload,on_jsload,reload_dependents,map__51415,map__51415__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__43427__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__43427__auto____0 = (function (){
var statearr_51657 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_51657[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__43427__auto__);

(statearr_51657[(1)] = (1));

return statearr_51657;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__43427__auto____1 = (function (state_51569){
while(true){
var ret_value__43428__auto__ = (function (){try{while(true){
var result__43429__auto__ = switch__43426__auto__.call(null,state_51569);
if(cljs.core.keyword_identical_QMARK_.call(null,result__43429__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43429__auto__;
}
break;
}
}catch (e51658){if((e51658 instanceof Object)){
var ex__43430__auto__ = e51658;
var statearr_51659_51719 = state_51569;
(statearr_51659_51719[(5)] = ex__43430__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_51569);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e51658;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__43428__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51720 = state_51569;
state_51569 = G__51720;
continue;
} else {
return ret_value__43428__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__43427__auto__ = function(state_51569){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__43427__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__43427__auto____1.call(this,state_51569);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__43427__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__43427__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__43427__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__43427__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__43427__auto__;
})()
;})(switch__43426__auto__,c__43449__auto__,map__51414,map__51414__$1,opts,before_jsload,on_jsload,reload_dependents,map__51415,map__51415__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__43451__auto__ = (function (){var statearr_51660 = f__43450__auto__.call(null);
(statearr_51660[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__43449__auto__);

return statearr_51660;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__43451__auto__);
});})(c__43449__auto__,map__51414,map__51414__$1,opts,before_jsload,on_jsload,reload_dependents,map__51415,map__51415__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__43449__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),cljs.core.str.cljs$core$IFn$_invoke$arity$1("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__51723,link){
var map__51726 = p__51723;
var map__51726__$1 = ((((!((map__51726 == null)))?((((map__51726.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51726.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__51726):map__51726);
var file = cljs.core.get.call(null,map__51726__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__6738__auto__ = link.href;
if(cljs.core.truth_(temp__6738__auto__)){
var link_href = temp__6738__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__6738__auto__,map__51726,map__51726__$1,file){
return (function (p1__51721_SHARP_,p2__51722_SHARP_){
if(cljs.core._EQ_.call(null,p1__51721_SHARP_,p2__51722_SHARP_)){
return p1__51721_SHARP_;
} else {
return false;
}
});})(link_href,temp__6738__auto__,map__51726,map__51726__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__6738__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__51732){
var map__51733 = p__51732;
var map__51733__$1 = ((((!((map__51733 == null)))?((((map__51733.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51733.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__51733):map__51733);
var match_length = cljs.core.get.call(null,map__51733__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__51733__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__51728_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__51728_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__6738__auto__)){
var res = temp__6738__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.distinctify = (function figwheel$client$file_reloading$distinctify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__51735_SHARP_,p2__51736_SHARP_){
return cljs.core.assoc.call(null,p1__51735_SHARP_,cljs.core.get.call(null,p2__51736_SHARP_,key),p2__51736_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.add_link_to_document = (function figwheel$client$file_reloading$add_link_to_document(orig_link,klone,finished_fn){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
parent.removeChild(orig_link);

return finished_fn.call(null);
});})(parent))
,(300));
});
if(typeof figwheel.client.file_reloading.reload_css_deferred_chain !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_css_deferred_chain = cljs.core.atom.call(null,goog.async.Deferred.succeed());
}
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(f_data,fin){
var temp__6736__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__6736__auto__)){
var link = temp__6736__auto__;
return figwheel.client.file_reloading.add_link_to_document.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href),((function (link,temp__6736__auto__){
return (function (){
return fin.call(null,cljs.core.assoc.call(null,f_data,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),true));
});})(link,temp__6736__auto__))
);
} else {
return fin.call(null,f_data);
}
});
figwheel.client.file_reloading.reload_css_files_STAR_ = (function figwheel$client$file_reloading$reload_css_files_STAR_(deferred,f_datas,on_cssload){
return figwheel.client.utils.liftContD.call(null,figwheel.client.utils.mapConcatD.call(null,deferred,figwheel.client.file_reloading.reload_css_file,f_datas),(function (f_datas_SINGLEQUOTE_,fin){
var loaded_f_datas_51737 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),f_datas_SINGLEQUOTE_);
figwheel.client.file_reloading.on_cssload_custom_event.call(null,loaded_f_datas_51737);

if(cljs.core.fn_QMARK_.call(null,on_cssload)){
on_cssload.call(null,loaded_f_datas_51737);
} else {
}

return fin.call(null);
}));
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__51738,p__51739){
var map__51744 = p__51738;
var map__51744__$1 = ((((!((map__51744 == null)))?((((map__51744.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51744.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__51744):map__51744);
var on_cssload = cljs.core.get.call(null,map__51744__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__51745 = p__51739;
var map__51745__$1 = ((((!((map__51745 == null)))?((((map__51745.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51745.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__51745):map__51745);
var files_msg = map__51745__$1;
var files = cljs.core.get.call(null,map__51745__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var temp__6738__auto__ = cljs.core.not_empty.call(null,figwheel.client.file_reloading.distinctify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
if(cljs.core.truth_(temp__6738__auto__)){
var f_datas = temp__6738__auto__;
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.reload_css_deferred_chain,figwheel.client.file_reloading.reload_css_files_STAR_,f_datas,on_cssload);
} else {
return null;
}
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1523205758245