// Compiled by ClojureScript 1.9.542 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.userAgent.product');
goog.require('goog.object');
goog.require('cljs.reader');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.utils');
goog.require('figwheel.client.heads_up');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('cljs.repl');
figwheel.client._figwheel_version_ = "0.5.10";
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(var_args){
var args53606 = [];
var len__42103__auto___53609 = arguments.length;
var i__42104__auto___53610 = (0);
while(true){
if((i__42104__auto___53610 < len__42103__auto___53609)){
args53606.push((arguments[i__42104__auto___53610]));

var G__53611 = (i__42104__auto___53610 + (1));
i__42104__auto___53610 = G__53611;
continue;
} else {
}
break;
}

var G__53608 = args53606.length;
switch (G__53608) {
case 2:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args53606.length)].join('')));

}
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2 = (function (stream,args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"stream","stream",1534941648),stream,new cljs.core.Keyword(null,"args","args",1315556576),args], null)], null));

return null;
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1 = (function (args){
return figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);
});

figwheel.client.figwheel_repl_print.cljs$lang$maxFixedArity = 2;

figwheel.client.console_out_print = (function figwheel$client$console_out_print(args){
return console.log.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.console_err_print = (function figwheel$client$console_err_print(args){
return console.error.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.repl_out_print_fn = (function figwheel$client$repl_out_print_fn(var_args){
var args__42110__auto__ = [];
var len__42103__auto___53614 = arguments.length;
var i__42104__auto___53615 = (0);
while(true){
if((i__42104__auto___53615 < len__42103__auto___53614)){
args__42110__auto__.push((arguments[i__42104__auto___53615]));

var G__53616 = (i__42104__auto___53615 + (1));
i__42104__auto___53615 = G__53616;
continue;
} else {
}
break;
}

var argseq__42111__auto__ = ((((0) < args__42110__auto__.length))?(new cljs.core.IndexedSeq(args__42110__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__42111__auto__);
});

figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_out_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);

return null;
});

figwheel.client.repl_out_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_out_print_fn.cljs$lang$applyTo = (function (seq53613){
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq53613));
});

figwheel.client.repl_err_print_fn = (function figwheel$client$repl_err_print_fn(var_args){
var args__42110__auto__ = [];
var len__42103__auto___53618 = arguments.length;
var i__42104__auto___53619 = (0);
while(true){
if((i__42104__auto___53619 < len__42103__auto___53618)){
args__42110__auto__.push((arguments[i__42104__auto___53619]));

var G__53620 = (i__42104__auto___53619 + (1));
i__42104__auto___53619 = G__53620;
continue;
} else {
}
break;
}

var argseq__42111__auto__ = ((((0) < args__42110__auto__.length))?(new cljs.core.IndexedSeq(args__42110__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__42111__auto__);
});

figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_err_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"err","err",-2089457205),args);

return null;
});

figwheel.client.repl_err_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_err_print_fn.cljs$lang$applyTo = (function (seq53617){
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq53617));
});

figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core.set_print_fn_BANG_.call(null,figwheel.client.repl_out_print_fn);

cljs.core.set_print_err_fn_BANG_.call(null,figwheel.client.repl_err_print_fn);

return null;
});
figwheel.client.autoload_QMARK_ = (function figwheel$client$autoload_QMARK_(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),true);
});
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
var res = figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Toggle autoload deprecated! Use (figwheel.client/set-autoload! false)")].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel autoloading "),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));

return res;
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
/**
 * Figwheel by default loads code changes as you work. Sometimes you
 *   just want to work on your code without the ramifications of
 *   autoloading and simply load your code piecemeal in the REPL. You can
 *   turn autoloading on and of with this method. 
 * 
 *   (figwheel.client/set-autoload false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_autoload = (function figwheel$client$set_autoload(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),b);
});
goog.exportSymbol('figwheel.client.set_autoload', figwheel.client.set_autoload);
figwheel.client.repl_pprint = (function figwheel$client$repl_pprint(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),true);
});
goog.exportSymbol('figwheel.client.repl_pprint', figwheel.client.repl_pprint);
/**
 * This method gives you the ability to turn the pretty printing of
 *   the REPL's return value on and off.
 *   
 *   (figwheel.client/set-repl-pprint false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_repl_pprint = (function figwheel$client$set_repl_pprint(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),b);
});
goog.exportSymbol('figwheel.client.set_repl_pprint', figwheel.client.set_repl_pprint);
figwheel.client.repl_result_pr_str = (function figwheel$client$repl_result_pr_str(v){
if(cljs.core.truth_(figwheel.client.repl_pprint.call(null))){
return figwheel.client.utils.pprint_to_string.call(null,v);
} else {
return cljs.core.pr_str.call(null,v);
}
});
goog.exportSymbol('figwheel.client.repl_result_pr_str', figwheel.client.repl_result_pr_str);
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel.client.get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__53621){
var map__53624 = p__53621;
var map__53624__$1 = ((((!((map__53624 == null)))?((((map__53624.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53624.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53624):map__53624);
var message = cljs.core.get.call(null,map__53624__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__53624__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" : "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__40882__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__40882__auto__)){
return or__40882__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__40870__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__40870__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__40870__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return (cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts)));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__43449__auto___53786 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__43449__auto___53786,ch){
return (function (){
var f__43450__auto__ = (function (){var switch__43426__auto__ = ((function (c__43449__auto___53786,ch){
return (function (state_53755){
var state_val_53756 = (state_53755[(1)]);
if((state_val_53756 === (7))){
var inst_53751 = (state_53755[(2)]);
var state_53755__$1 = state_53755;
var statearr_53757_53787 = state_53755__$1;
(statearr_53757_53787[(2)] = inst_53751);

(statearr_53757_53787[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53756 === (1))){
var state_53755__$1 = state_53755;
var statearr_53758_53788 = state_53755__$1;
(statearr_53758_53788[(2)] = null);

(statearr_53758_53788[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53756 === (4))){
var inst_53708 = (state_53755[(7)]);
var inst_53708__$1 = (state_53755[(2)]);
var state_53755__$1 = (function (){var statearr_53759 = state_53755;
(statearr_53759[(7)] = inst_53708__$1);

return statearr_53759;
})();
if(cljs.core.truth_(inst_53708__$1)){
var statearr_53760_53789 = state_53755__$1;
(statearr_53760_53789[(1)] = (5));

} else {
var statearr_53761_53790 = state_53755__$1;
(statearr_53761_53790[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53756 === (15))){
var inst_53715 = (state_53755[(8)]);
var inst_53730 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_53715);
var inst_53731 = cljs.core.first.call(null,inst_53730);
var inst_53732 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_53731);
var inst_53733 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Not loading code with warnings - "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_53732)].join('');
var inst_53734 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_53733);
var state_53755__$1 = state_53755;
var statearr_53762_53791 = state_53755__$1;
(statearr_53762_53791[(2)] = inst_53734);

(statearr_53762_53791[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53756 === (13))){
var inst_53739 = (state_53755[(2)]);
var state_53755__$1 = state_53755;
var statearr_53763_53792 = state_53755__$1;
(statearr_53763_53792[(2)] = inst_53739);

(statearr_53763_53792[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53756 === (6))){
var state_53755__$1 = state_53755;
var statearr_53764_53793 = state_53755__$1;
(statearr_53764_53793[(2)] = null);

(statearr_53764_53793[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53756 === (17))){
var inst_53737 = (state_53755[(2)]);
var state_53755__$1 = state_53755;
var statearr_53765_53794 = state_53755__$1;
(statearr_53765_53794[(2)] = inst_53737);

(statearr_53765_53794[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53756 === (3))){
var inst_53753 = (state_53755[(2)]);
var state_53755__$1 = state_53755;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53755__$1,inst_53753);
} else {
if((state_val_53756 === (12))){
var inst_53714 = (state_53755[(9)]);
var inst_53728 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_53714,opts);
var state_53755__$1 = state_53755;
if(cljs.core.truth_(inst_53728)){
var statearr_53766_53795 = state_53755__$1;
(statearr_53766_53795[(1)] = (15));

} else {
var statearr_53767_53796 = state_53755__$1;
(statearr_53767_53796[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53756 === (2))){
var state_53755__$1 = state_53755;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53755__$1,(4),ch);
} else {
if((state_val_53756 === (11))){
var inst_53715 = (state_53755[(8)]);
var inst_53720 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53721 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_53715);
var inst_53722 = cljs.core.async.timeout.call(null,(1000));
var inst_53723 = [inst_53721,inst_53722];
var inst_53724 = (new cljs.core.PersistentVector(null,2,(5),inst_53720,inst_53723,null));
var state_53755__$1 = state_53755;
return cljs.core.async.ioc_alts_BANG_.call(null,state_53755__$1,(14),inst_53724);
} else {
if((state_val_53756 === (9))){
var inst_53715 = (state_53755[(8)]);
var inst_53741 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_53742 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_53715);
var inst_53743 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_53742);
var inst_53744 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("Not loading: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_53743)].join('');
var inst_53745 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_53744);
var state_53755__$1 = (function (){var statearr_53768 = state_53755;
(statearr_53768[(10)] = inst_53741);

return statearr_53768;
})();
var statearr_53769_53797 = state_53755__$1;
(statearr_53769_53797[(2)] = inst_53745);

(statearr_53769_53797[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53756 === (5))){
var inst_53708 = (state_53755[(7)]);
var inst_53710 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_53711 = (new cljs.core.PersistentArrayMap(null,2,inst_53710,null));
var inst_53712 = (new cljs.core.PersistentHashSet(null,inst_53711,null));
var inst_53713 = figwheel.client.focus_msgs.call(null,inst_53712,inst_53708);
var inst_53714 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_53713);
var inst_53715 = cljs.core.first.call(null,inst_53713);
var inst_53716 = figwheel.client.autoload_QMARK_.call(null);
var state_53755__$1 = (function (){var statearr_53770 = state_53755;
(statearr_53770[(9)] = inst_53714);

(statearr_53770[(8)] = inst_53715);

return statearr_53770;
})();
if(cljs.core.truth_(inst_53716)){
var statearr_53771_53798 = state_53755__$1;
(statearr_53771_53798[(1)] = (8));

} else {
var statearr_53772_53799 = state_53755__$1;
(statearr_53772_53799[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53756 === (14))){
var inst_53726 = (state_53755[(2)]);
var state_53755__$1 = state_53755;
var statearr_53773_53800 = state_53755__$1;
(statearr_53773_53800[(2)] = inst_53726);

(statearr_53773_53800[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53756 === (16))){
var state_53755__$1 = state_53755;
var statearr_53774_53801 = state_53755__$1;
(statearr_53774_53801[(2)] = null);

(statearr_53774_53801[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53756 === (10))){
var inst_53747 = (state_53755[(2)]);
var state_53755__$1 = (function (){var statearr_53775 = state_53755;
(statearr_53775[(11)] = inst_53747);

return statearr_53775;
})();
var statearr_53776_53802 = state_53755__$1;
(statearr_53776_53802[(2)] = null);

(statearr_53776_53802[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53756 === (8))){
var inst_53714 = (state_53755[(9)]);
var inst_53718 = figwheel.client.reload_file_state_QMARK_.call(null,inst_53714,opts);
var state_53755__$1 = state_53755;
if(cljs.core.truth_(inst_53718)){
var statearr_53777_53803 = state_53755__$1;
(statearr_53777_53803[(1)] = (11));

} else {
var statearr_53778_53804 = state_53755__$1;
(statearr_53778_53804[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__43449__auto___53786,ch))
;
return ((function (switch__43426__auto__,c__43449__auto___53786,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__43427__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__43427__auto____0 = (function (){
var statearr_53782 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_53782[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__43427__auto__);

(statearr_53782[(1)] = (1));

return statearr_53782;
});
var figwheel$client$file_reloader_plugin_$_state_machine__43427__auto____1 = (function (state_53755){
while(true){
var ret_value__43428__auto__ = (function (){try{while(true){
var result__43429__auto__ = switch__43426__auto__.call(null,state_53755);
if(cljs.core.keyword_identical_QMARK_.call(null,result__43429__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43429__auto__;
}
break;
}
}catch (e53783){if((e53783 instanceof Object)){
var ex__43430__auto__ = e53783;
var statearr_53784_53805 = state_53755;
(statearr_53784_53805[(5)] = ex__43430__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53755);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e53783;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__43428__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53806 = state_53755;
state_53755 = G__53806;
continue;
} else {
return ret_value__43428__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__43427__auto__ = function(state_53755){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__43427__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__43427__auto____1.call(this,state_53755);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloader_plugin_$_state_machine__43427__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__43427__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__43427__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__43427__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__43427__auto__;
})()
;})(switch__43426__auto__,c__43449__auto___53786,ch))
})();
var state__43451__auto__ = (function (){var statearr_53785 = f__43450__auto__.call(null);
(statearr_53785[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__43449__auto___53786);

return statearr_53785;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__43451__auto__);
});})(c__43449__auto___53786,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__53807_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__53807_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_53810 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_53810){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{figwheel.client.enable_repl_print_BANG_.call(null);

var result_value = figwheel.client.utils.eval_helper.call(null,code,opts);
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),result_value], null));
}catch (e53809){if((e53809 instanceof Error)){
var e = e53809;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_53810], null));
} else {
var e = e53809;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}finally {figwheel.client.enable_repl_print_BANG_.call(null);
}});})(base_path_53810))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = ({});
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__53811){
var map__53820 = p__53811;
var map__53820__$1 = ((((!((map__53820 == null)))?((((map__53820.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53820.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53820):map__53820);
var opts = map__53820__$1;
var build_id = cljs.core.get.call(null,map__53820__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__53820,map__53820__$1,opts,build_id){
return (function (p__53822){
var vec__53823 = p__53822;
var seq__53824 = cljs.core.seq.call(null,vec__53823);
var first__53825 = cljs.core.first.call(null,seq__53824);
var seq__53824__$1 = cljs.core.next.call(null,seq__53824);
var map__53826 = first__53825;
var map__53826__$1 = ((((!((map__53826 == null)))?((((map__53826.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53826.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53826):map__53826);
var msg = map__53826__$1;
var msg_name = cljs.core.get.call(null,map__53826__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__53824__$1;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__53823,seq__53824,first__53825,seq__53824__$1,map__53826,map__53826__$1,msg,msg_name,_,map__53820,map__53820__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__53823,seq__53824,first__53825,seq__53824__$1,map__53826,map__53826__$1,msg,msg_name,_,map__53820,map__53820__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__53820,map__53820__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__53834){
var vec__53835 = p__53834;
var seq__53836 = cljs.core.seq.call(null,vec__53835);
var first__53837 = cljs.core.first.call(null,seq__53836);
var seq__53836__$1 = cljs.core.next.call(null,seq__53836);
var map__53838 = first__53837;
var map__53838__$1 = ((((!((map__53838 == null)))?((((map__53838.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53838.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53838):map__53838);
var msg = map__53838__$1;
var msg_name = cljs.core.get.call(null,map__53838__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__53836__$1;
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__53840){
var map__53852 = p__53840;
var map__53852__$1 = ((((!((map__53852 == null)))?((((map__53852.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53852.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53852):map__53852);
var on_compile_warning = cljs.core.get.call(null,map__53852__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__53852__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__53852,map__53852__$1,on_compile_warning,on_compile_fail){
return (function (p__53854){
var vec__53855 = p__53854;
var seq__53856 = cljs.core.seq.call(null,vec__53855);
var first__53857 = cljs.core.first.call(null,seq__53856);
var seq__53856__$1 = cljs.core.next.call(null,seq__53856);
var map__53858 = first__53857;
var map__53858__$1 = ((((!((map__53858 == null)))?((((map__53858.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53858.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53858):map__53858);
var msg = map__53858__$1;
var msg_name = cljs.core.get.call(null,map__53858__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__53856__$1;
var pred__53860 = cljs.core._EQ_;
var expr__53861 = msg_name;
if(cljs.core.truth_(pred__53860.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__53861))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__53860.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__53861))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__53852,map__53852__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.auto_jump_to_error = (function figwheel$client$auto_jump_to_error(opts,error){
if(cljs.core.truth_(new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920).cljs$core$IFn$_invoke$arity$1(opts))){
return figwheel.client.heads_up.auto_notify_source_file_line.call(null,error);
} else {
return null;
}
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__43449__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__43449__auto__,msg_hist,msg_names,msg){
return (function (){
var f__43450__auto__ = (function (){var switch__43426__auto__ = ((function (c__43449__auto__,msg_hist,msg_names,msg){
return (function (state_54089){
var state_val_54090 = (state_54089[(1)]);
if((state_val_54090 === (7))){
var inst_54009 = (state_54089[(2)]);
var state_54089__$1 = state_54089;
if(cljs.core.truth_(inst_54009)){
var statearr_54091_54141 = state_54089__$1;
(statearr_54091_54141[(1)] = (8));

} else {
var statearr_54092_54142 = state_54089__$1;
(statearr_54092_54142[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54090 === (20))){
var inst_54083 = (state_54089[(2)]);
var state_54089__$1 = state_54089;
var statearr_54093_54143 = state_54089__$1;
(statearr_54093_54143[(2)] = inst_54083);

(statearr_54093_54143[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54090 === (27))){
var inst_54079 = (state_54089[(2)]);
var state_54089__$1 = state_54089;
var statearr_54094_54144 = state_54089__$1;
(statearr_54094_54144[(2)] = inst_54079);

(statearr_54094_54144[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54090 === (1))){
var inst_54002 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_54089__$1 = state_54089;
if(cljs.core.truth_(inst_54002)){
var statearr_54095_54145 = state_54089__$1;
(statearr_54095_54145[(1)] = (2));

} else {
var statearr_54096_54146 = state_54089__$1;
(statearr_54096_54146[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54090 === (24))){
var inst_54081 = (state_54089[(2)]);
var state_54089__$1 = state_54089;
var statearr_54097_54147 = state_54089__$1;
(statearr_54097_54147[(2)] = inst_54081);

(statearr_54097_54147[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54090 === (4))){
var inst_54087 = (state_54089[(2)]);
var state_54089__$1 = state_54089;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54089__$1,inst_54087);
} else {
if((state_val_54090 === (15))){
var inst_54085 = (state_54089[(2)]);
var state_54089__$1 = state_54089;
var statearr_54098_54148 = state_54089__$1;
(statearr_54098_54148[(2)] = inst_54085);

(statearr_54098_54148[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54090 === (21))){
var inst_54038 = (state_54089[(2)]);
var inst_54039 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_54040 = figwheel.client.auto_jump_to_error.call(null,opts,inst_54039);
var state_54089__$1 = (function (){var statearr_54099 = state_54089;
(statearr_54099[(7)] = inst_54038);

return statearr_54099;
})();
var statearr_54100_54149 = state_54089__$1;
(statearr_54100_54149[(2)] = inst_54040);

(statearr_54100_54149[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54090 === (31))){
var inst_54068 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_54089__$1 = state_54089;
if(cljs.core.truth_(inst_54068)){
var statearr_54101_54150 = state_54089__$1;
(statearr_54101_54150[(1)] = (34));

} else {
var statearr_54102_54151 = state_54089__$1;
(statearr_54102_54151[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54090 === (32))){
var inst_54077 = (state_54089[(2)]);
var state_54089__$1 = state_54089;
var statearr_54103_54152 = state_54089__$1;
(statearr_54103_54152[(2)] = inst_54077);

(statearr_54103_54152[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54090 === (33))){
var inst_54064 = (state_54089[(2)]);
var inst_54065 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_54066 = figwheel.client.auto_jump_to_error.call(null,opts,inst_54065);
var state_54089__$1 = (function (){var statearr_54104 = state_54089;
(statearr_54104[(8)] = inst_54064);

return statearr_54104;
})();
var statearr_54105_54153 = state_54089__$1;
(statearr_54105_54153[(2)] = inst_54066);

(statearr_54105_54153[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54090 === (13))){
var inst_54023 = figwheel.client.heads_up.clear.call(null);
var state_54089__$1 = state_54089;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54089__$1,(16),inst_54023);
} else {
if((state_val_54090 === (22))){
var inst_54044 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_54045 = figwheel.client.heads_up.append_warning_message.call(null,inst_54044);
var state_54089__$1 = state_54089;
var statearr_54106_54154 = state_54089__$1;
(statearr_54106_54154[(2)] = inst_54045);

(statearr_54106_54154[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54090 === (36))){
var inst_54075 = (state_54089[(2)]);
var state_54089__$1 = state_54089;
var statearr_54107_54155 = state_54089__$1;
(statearr_54107_54155[(2)] = inst_54075);

(statearr_54107_54155[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54090 === (29))){
var inst_54055 = (state_54089[(2)]);
var inst_54056 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_54057 = figwheel.client.auto_jump_to_error.call(null,opts,inst_54056);
var state_54089__$1 = (function (){var statearr_54108 = state_54089;
(statearr_54108[(9)] = inst_54055);

return statearr_54108;
})();
var statearr_54109_54156 = state_54089__$1;
(statearr_54109_54156[(2)] = inst_54057);

(statearr_54109_54156[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54090 === (6))){
var inst_54004 = (state_54089[(10)]);
var state_54089__$1 = state_54089;
var statearr_54110_54157 = state_54089__$1;
(statearr_54110_54157[(2)] = inst_54004);

(statearr_54110_54157[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54090 === (28))){
var inst_54051 = (state_54089[(2)]);
var inst_54052 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_54053 = figwheel.client.heads_up.display_warning.call(null,inst_54052);
var state_54089__$1 = (function (){var statearr_54111 = state_54089;
(statearr_54111[(11)] = inst_54051);

return statearr_54111;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54089__$1,(29),inst_54053);
} else {
if((state_val_54090 === (25))){
var inst_54049 = figwheel.client.heads_up.clear.call(null);
var state_54089__$1 = state_54089;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54089__$1,(28),inst_54049);
} else {
if((state_val_54090 === (34))){
var inst_54070 = figwheel.client.heads_up.flash_loaded.call(null);
var state_54089__$1 = state_54089;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54089__$1,(37),inst_54070);
} else {
if((state_val_54090 === (17))){
var inst_54029 = (state_54089[(2)]);
var inst_54030 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_54031 = figwheel.client.auto_jump_to_error.call(null,opts,inst_54030);
var state_54089__$1 = (function (){var statearr_54112 = state_54089;
(statearr_54112[(12)] = inst_54029);

return statearr_54112;
})();
var statearr_54113_54158 = state_54089__$1;
(statearr_54113_54158[(2)] = inst_54031);

(statearr_54113_54158[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54090 === (3))){
var inst_54021 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_54089__$1 = state_54089;
if(cljs.core.truth_(inst_54021)){
var statearr_54114_54159 = state_54089__$1;
(statearr_54114_54159[(1)] = (13));

} else {
var statearr_54115_54160 = state_54089__$1;
(statearr_54115_54160[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54090 === (12))){
var inst_54017 = (state_54089[(2)]);
var state_54089__$1 = state_54089;
var statearr_54116_54161 = state_54089__$1;
(statearr_54116_54161[(2)] = inst_54017);

(statearr_54116_54161[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54090 === (2))){
var inst_54004 = (state_54089[(10)]);
var inst_54004__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_54089__$1 = (function (){var statearr_54117 = state_54089;
(statearr_54117[(10)] = inst_54004__$1);

return statearr_54117;
})();
if(cljs.core.truth_(inst_54004__$1)){
var statearr_54118_54162 = state_54089__$1;
(statearr_54118_54162[(1)] = (5));

} else {
var statearr_54119_54163 = state_54089__$1;
(statearr_54119_54163[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54090 === (23))){
var inst_54047 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_54089__$1 = state_54089;
if(cljs.core.truth_(inst_54047)){
var statearr_54120_54164 = state_54089__$1;
(statearr_54120_54164[(1)] = (25));

} else {
var statearr_54121_54165 = state_54089__$1;
(statearr_54121_54165[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54090 === (35))){
var state_54089__$1 = state_54089;
var statearr_54122_54166 = state_54089__$1;
(statearr_54122_54166[(2)] = null);

(statearr_54122_54166[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54090 === (19))){
var inst_54042 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_54089__$1 = state_54089;
if(cljs.core.truth_(inst_54042)){
var statearr_54123_54167 = state_54089__$1;
(statearr_54123_54167[(1)] = (22));

} else {
var statearr_54124_54168 = state_54089__$1;
(statearr_54124_54168[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54090 === (11))){
var inst_54013 = (state_54089[(2)]);
var state_54089__$1 = state_54089;
var statearr_54125_54169 = state_54089__$1;
(statearr_54125_54169[(2)] = inst_54013);

(statearr_54125_54169[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54090 === (9))){
var inst_54015 = figwheel.client.heads_up.clear.call(null);
var state_54089__$1 = state_54089;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54089__$1,(12),inst_54015);
} else {
if((state_val_54090 === (5))){
var inst_54006 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_54089__$1 = state_54089;
var statearr_54126_54170 = state_54089__$1;
(statearr_54126_54170[(2)] = inst_54006);

(statearr_54126_54170[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54090 === (14))){
var inst_54033 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_54089__$1 = state_54089;
if(cljs.core.truth_(inst_54033)){
var statearr_54127_54171 = state_54089__$1;
(statearr_54127_54171[(1)] = (18));

} else {
var statearr_54128_54172 = state_54089__$1;
(statearr_54128_54172[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54090 === (26))){
var inst_54059 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_54089__$1 = state_54089;
if(cljs.core.truth_(inst_54059)){
var statearr_54129_54173 = state_54089__$1;
(statearr_54129_54173[(1)] = (30));

} else {
var statearr_54130_54174 = state_54089__$1;
(statearr_54130_54174[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54090 === (16))){
var inst_54025 = (state_54089[(2)]);
var inst_54026 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_54027 = figwheel.client.heads_up.display_exception.call(null,inst_54026);
var state_54089__$1 = (function (){var statearr_54131 = state_54089;
(statearr_54131[(13)] = inst_54025);

return statearr_54131;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54089__$1,(17),inst_54027);
} else {
if((state_val_54090 === (30))){
var inst_54061 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_54062 = figwheel.client.heads_up.display_warning.call(null,inst_54061);
var state_54089__$1 = state_54089;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54089__$1,(33),inst_54062);
} else {
if((state_val_54090 === (10))){
var inst_54019 = (state_54089[(2)]);
var state_54089__$1 = state_54089;
var statearr_54132_54175 = state_54089__$1;
(statearr_54132_54175[(2)] = inst_54019);

(statearr_54132_54175[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54090 === (18))){
var inst_54035 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_54036 = figwheel.client.heads_up.display_exception.call(null,inst_54035);
var state_54089__$1 = state_54089;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54089__$1,(21),inst_54036);
} else {
if((state_val_54090 === (37))){
var inst_54072 = (state_54089[(2)]);
var state_54089__$1 = state_54089;
var statearr_54133_54176 = state_54089__$1;
(statearr_54133_54176[(2)] = inst_54072);

(statearr_54133_54176[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54090 === (8))){
var inst_54011 = figwheel.client.heads_up.flash_loaded.call(null);
var state_54089__$1 = state_54089;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54089__$1,(11),inst_54011);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__43449__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__43426__auto__,c__43449__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__43427__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__43427__auto____0 = (function (){
var statearr_54137 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54137[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__43427__auto__);

(statearr_54137[(1)] = (1));

return statearr_54137;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__43427__auto____1 = (function (state_54089){
while(true){
var ret_value__43428__auto__ = (function (){try{while(true){
var result__43429__auto__ = switch__43426__auto__.call(null,state_54089);
if(cljs.core.keyword_identical_QMARK_.call(null,result__43429__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43429__auto__;
}
break;
}
}catch (e54138){if((e54138 instanceof Object)){
var ex__43430__auto__ = e54138;
var statearr_54139_54177 = state_54089;
(statearr_54139_54177[(5)] = ex__43430__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54089);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54138;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__43428__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54178 = state_54089;
state_54089 = G__54178;
continue;
} else {
return ret_value__43428__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__43427__auto__ = function(state_54089){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__43427__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__43427__auto____1.call(this,state_54089);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__43427__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__43427__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__43427__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__43427__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__43427__auto__;
})()
;})(switch__43426__auto__,c__43449__auto__,msg_hist,msg_names,msg))
})();
var state__43451__auto__ = (function (){var statearr_54140 = f__43450__auto__.call(null);
(statearr_54140[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__43449__auto__);

return statearr_54140;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__43451__auto__);
});})(c__43449__auto__,msg_hist,msg_names,msg))
);

return c__43449__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__43449__auto___54241 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__43449__auto___54241,ch){
return (function (){
var f__43450__auto__ = (function (){var switch__43426__auto__ = ((function (c__43449__auto___54241,ch){
return (function (state_54224){
var state_val_54225 = (state_54224[(1)]);
if((state_val_54225 === (1))){
var state_54224__$1 = state_54224;
var statearr_54226_54242 = state_54224__$1;
(statearr_54226_54242[(2)] = null);

(statearr_54226_54242[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54225 === (2))){
var state_54224__$1 = state_54224;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54224__$1,(4),ch);
} else {
if((state_val_54225 === (3))){
var inst_54222 = (state_54224[(2)]);
var state_54224__$1 = state_54224;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54224__$1,inst_54222);
} else {
if((state_val_54225 === (4))){
var inst_54212 = (state_54224[(7)]);
var inst_54212__$1 = (state_54224[(2)]);
var state_54224__$1 = (function (){var statearr_54227 = state_54224;
(statearr_54227[(7)] = inst_54212__$1);

return statearr_54227;
})();
if(cljs.core.truth_(inst_54212__$1)){
var statearr_54228_54243 = state_54224__$1;
(statearr_54228_54243[(1)] = (5));

} else {
var statearr_54229_54244 = state_54224__$1;
(statearr_54229_54244[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54225 === (5))){
var inst_54212 = (state_54224[(7)]);
var inst_54214 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_54212);
var state_54224__$1 = state_54224;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54224__$1,(8),inst_54214);
} else {
if((state_val_54225 === (6))){
var state_54224__$1 = state_54224;
var statearr_54230_54245 = state_54224__$1;
(statearr_54230_54245[(2)] = null);

(statearr_54230_54245[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54225 === (7))){
var inst_54220 = (state_54224[(2)]);
var state_54224__$1 = state_54224;
var statearr_54231_54246 = state_54224__$1;
(statearr_54231_54246[(2)] = inst_54220);

(statearr_54231_54246[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54225 === (8))){
var inst_54216 = (state_54224[(2)]);
var state_54224__$1 = (function (){var statearr_54232 = state_54224;
(statearr_54232[(8)] = inst_54216);

return statearr_54232;
})();
var statearr_54233_54247 = state_54224__$1;
(statearr_54233_54247[(2)] = null);

(statearr_54233_54247[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__43449__auto___54241,ch))
;
return ((function (switch__43426__auto__,c__43449__auto___54241,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__43427__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__43427__auto____0 = (function (){
var statearr_54237 = [null,null,null,null,null,null,null,null,null];
(statearr_54237[(0)] = figwheel$client$heads_up_plugin_$_state_machine__43427__auto__);

(statearr_54237[(1)] = (1));

return statearr_54237;
});
var figwheel$client$heads_up_plugin_$_state_machine__43427__auto____1 = (function (state_54224){
while(true){
var ret_value__43428__auto__ = (function (){try{while(true){
var result__43429__auto__ = switch__43426__auto__.call(null,state_54224);
if(cljs.core.keyword_identical_QMARK_.call(null,result__43429__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43429__auto__;
}
break;
}
}catch (e54238){if((e54238 instanceof Object)){
var ex__43430__auto__ = e54238;
var statearr_54239_54248 = state_54224;
(statearr_54239_54248[(5)] = ex__43430__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54224);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54238;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__43428__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54249 = state_54224;
state_54224 = G__54249;
continue;
} else {
return ret_value__43428__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__43427__auto__ = function(state_54224){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__43427__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__43427__auto____1.call(this,state_54224);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_$_state_machine__43427__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__43427__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__43427__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__43427__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__43427__auto__;
})()
;})(switch__43426__auto__,c__43449__auto___54241,ch))
})();
var state__43451__auto__ = (function (){var statearr_54240 = f__43450__auto__.call(null);
(statearr_54240[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__43449__auto___54241);

return statearr_54240;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__43451__auto__);
});})(c__43449__auto___54241,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__43449__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__43449__auto__){
return (function (){
var f__43450__auto__ = (function (){var switch__43426__auto__ = ((function (c__43449__auto__){
return (function (state_54270){
var state_val_54271 = (state_54270[(1)]);
if((state_val_54271 === (1))){
var inst_54265 = cljs.core.async.timeout.call(null,(3000));
var state_54270__$1 = state_54270;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54270__$1,(2),inst_54265);
} else {
if((state_val_54271 === (2))){
var inst_54267 = (state_54270[(2)]);
var inst_54268 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_54270__$1 = (function (){var statearr_54272 = state_54270;
(statearr_54272[(7)] = inst_54267);

return statearr_54272;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54270__$1,inst_54268);
} else {
return null;
}
}
});})(c__43449__auto__))
;
return ((function (switch__43426__auto__,c__43449__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__43427__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__43427__auto____0 = (function (){
var statearr_54276 = [null,null,null,null,null,null,null,null];
(statearr_54276[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__43427__auto__);

(statearr_54276[(1)] = (1));

return statearr_54276;
});
var figwheel$client$enforce_project_plugin_$_state_machine__43427__auto____1 = (function (state_54270){
while(true){
var ret_value__43428__auto__ = (function (){try{while(true){
var result__43429__auto__ = switch__43426__auto__.call(null,state_54270);
if(cljs.core.keyword_identical_QMARK_.call(null,result__43429__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43429__auto__;
}
break;
}
}catch (e54277){if((e54277 instanceof Object)){
var ex__43430__auto__ = e54277;
var statearr_54278_54280 = state_54270;
(statearr_54278_54280[(5)] = ex__43430__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54270);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54277;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__43428__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54281 = state_54270;
state_54270 = G__54281;
continue;
} else {
return ret_value__43428__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__43427__auto__ = function(state_54270){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__43427__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__43427__auto____1.call(this,state_54270);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_project_plugin_$_state_machine__43427__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__43427__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__43427__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__43427__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__43427__auto__;
})()
;})(switch__43426__auto__,c__43449__auto__))
})();
var state__43451__auto__ = (function (){var statearr_54279 = f__43450__auto__.call(null);
(statearr_54279[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__43449__auto__);

return statearr_54279;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__43451__auto__);
});})(c__43449__auto__))
);

return c__43449__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.enforce_figwheel_version_plugin = (function figwheel$client$enforce_figwheel_version_plugin(opts){
return (function (msg_hist){
var temp__6738__auto__ = new cljs.core.Keyword(null,"figwheel-version","figwheel-version",1409553832).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,msg_hist));
if(cljs.core.truth_(temp__6738__auto__)){
var figwheel_version = temp__6738__auto__;
if(cljs.core.not_EQ_.call(null,figwheel_version,figwheel.client._figwheel_version_)){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different version of Figwheel.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__43449__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__43449__auto__,figwheel_version,temp__6738__auto__){
return (function (){
var f__43450__auto__ = (function (){var switch__43426__auto__ = ((function (c__43449__auto__,figwheel_version,temp__6738__auto__){
return (function (state_54304){
var state_val_54305 = (state_54304[(1)]);
if((state_val_54305 === (1))){
var inst_54298 = cljs.core.async.timeout.call(null,(2000));
var state_54304__$1 = state_54304;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54304__$1,(2),inst_54298);
} else {
if((state_val_54305 === (2))){
var inst_54300 = (state_54304[(2)]);
var inst_54301 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel Client Version <strong>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client._figwheel_version_),cljs.core.str.cljs$core$IFn$_invoke$arity$1("</strong> is not equal to "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel Sidecar Version <strong>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel_version),cljs.core.str.cljs$core$IFn$_invoke$arity$1("</strong>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(".  Shutting down Websocket Connection!"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("<h4>To fix try:</h4>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("<ol><li>Reload this page and make sure you are not getting a cached version of the client.</li>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("<li>You may have to clean (delete compiled assets) and rebuild to make sure that the new client code is being used.</li>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("<li>Also, make sure you have consistent Figwheel dependencies.</li></ol>")].join('');
var inst_54302 = figwheel.client.heads_up.display_system_warning.call(null,"Figwheel Client and Server have different versions!!",inst_54301);
var state_54304__$1 = (function (){var statearr_54306 = state_54304;
(statearr_54306[(7)] = inst_54300);

return statearr_54306;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54304__$1,inst_54302);
} else {
return null;
}
}
});})(c__43449__auto__,figwheel_version,temp__6738__auto__))
;
return ((function (switch__43426__auto__,c__43449__auto__,figwheel_version,temp__6738__auto__){
return (function() {
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__43427__auto__ = null;
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__43427__auto____0 = (function (){
var statearr_54310 = [null,null,null,null,null,null,null,null];
(statearr_54310[(0)] = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__43427__auto__);

(statearr_54310[(1)] = (1));

return statearr_54310;
});
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__43427__auto____1 = (function (state_54304){
while(true){
var ret_value__43428__auto__ = (function (){try{while(true){
var result__43429__auto__ = switch__43426__auto__.call(null,state_54304);
if(cljs.core.keyword_identical_QMARK_.call(null,result__43429__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43429__auto__;
}
break;
}
}catch (e54311){if((e54311 instanceof Object)){
var ex__43430__auto__ = e54311;
var statearr_54312_54314 = state_54304;
(statearr_54312_54314[(5)] = ex__43430__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54304);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54311;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__43428__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54315 = state_54304;
state_54304 = G__54315;
continue;
} else {
return ret_value__43428__auto__;
}
break;
}
});
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__43427__auto__ = function(state_54304){
switch(arguments.length){
case 0:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__43427__auto____0.call(this);
case 1:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__43427__auto____1.call(this,state_54304);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__43427__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__43427__auto____0;
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__43427__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__43427__auto____1;
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__43427__auto__;
})()
;})(switch__43426__auto__,c__43449__auto__,figwheel_version,temp__6738__auto__))
})();
var state__43451__auto__ = (function (){var statearr_54313 = f__43450__auto__.call(null);
(statearr_54313[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__43449__auto__);

return statearr_54313;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__43451__auto__);
});})(c__43449__auto__,figwheel_version,temp__6738__auto__))
);

return c__43449__auto__;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.file_line_column = (function figwheel$client$file_line_column(p__54316){
var map__54320 = p__54316;
var map__54320__$1 = ((((!((map__54320 == null)))?((((map__54320.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54320.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54320):map__54320);
var file = cljs.core.get.call(null,map__54320__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__54320__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__54320__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var G__54322 = "";
var G__54322__$1 = (cljs.core.truth_(file)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__54322),cljs.core.str.cljs$core$IFn$_invoke$arity$1("file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''):G__54322);
var G__54322__$2 = (cljs.core.truth_(line)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__54322__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" at line "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):G__54322__$1);
if(cljs.core.truth_((function (){var and__40870__auto__ = line;
if(cljs.core.truth_(and__40870__auto__)){
return column;
} else {
return and__40870__auto__;
}
})())){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__54322__$2),cljs.core.str.cljs$core$IFn$_invoke$arity$1(", column "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join('');
} else {
return G__54322__$2;
}
});
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__54323){
var map__54330 = p__54323;
var map__54330__$1 = ((((!((map__54330 == null)))?((((map__54330.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54330.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54330):map__54330);
var ed = map__54330__$1;
var formatted_exception = cljs.core.get.call(null,map__54330__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__54330__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__54330__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__54332_54336 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__54333_54337 = null;
var count__54334_54338 = (0);
var i__54335_54339 = (0);
while(true){
if((i__54335_54339 < count__54334_54338)){
var msg_54340 = cljs.core._nth.call(null,chunk__54333_54337,i__54335_54339);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_54340);

var G__54341 = seq__54332_54336;
var G__54342 = chunk__54333_54337;
var G__54343 = count__54334_54338;
var G__54344 = (i__54335_54339 + (1));
seq__54332_54336 = G__54341;
chunk__54333_54337 = G__54342;
count__54334_54338 = G__54343;
i__54335_54339 = G__54344;
continue;
} else {
var temp__6738__auto___54345 = cljs.core.seq.call(null,seq__54332_54336);
if(temp__6738__auto___54345){
var seq__54332_54346__$1 = temp__6738__auto___54345;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__54332_54346__$1)){
var c__41793__auto___54347 = cljs.core.chunk_first.call(null,seq__54332_54346__$1);
var G__54348 = cljs.core.chunk_rest.call(null,seq__54332_54346__$1);
var G__54349 = c__41793__auto___54347;
var G__54350 = cljs.core.count.call(null,c__41793__auto___54347);
var G__54351 = (0);
seq__54332_54336 = G__54348;
chunk__54333_54337 = G__54349;
count__54334_54338 = G__54350;
i__54335_54339 = G__54351;
continue;
} else {
var msg_54352 = cljs.core.first.call(null,seq__54332_54346__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_54352);

var G__54353 = cljs.core.next.call(null,seq__54332_54346__$1);
var G__54354 = null;
var G__54355 = (0);
var G__54356 = (0);
seq__54332_54336 = G__54353;
chunk__54333_54337 = G__54354;
count__54334_54338 = G__54355;
i__54335_54339 = G__54356;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Error on "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,ed))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__54357){
var map__54360 = p__54357;
var map__54360__$1 = ((((!((map__54360 == null)))?((((map__54360.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54360.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54360):map__54360);
var w = map__54360__$1;
var message = cljs.core.get.call(null,map__54360__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Compile Warning - "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(message)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" in "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,message))].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if(typeof figwheel.client.config_defaults !== 'undefined'){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[new cljs.core.Var(function(){return figwheel.client.default_on_compile_warning;},new cljs.core.Symbol("figwheel.client","default-on-compile-warning","figwheel.client/default-on-compile-warning",584144208,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-warning","default-on-compile-warning",-18911586,null),"resources/public/js/out/figwheel/client.cljs",33,1,357,357,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"message","message",1234475525,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"w","w",1994700528,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_warning)?figwheel.client.default_on_compile_warning.cljs$lang$test:null)])),figwheel.client.default_on_jsload,true,new cljs.core.Var(function(){return figwheel.client.default_on_compile_fail;},new cljs.core.Symbol("figwheel.client","default-on-compile-fail","figwheel.client/default-on-compile-fail",1384826337,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-fail","default-on-compile-fail",-158814813,null),"resources/public/js/out/figwheel/client.cljs",30,1,349,349,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"formatted-exception","formatted-exception",1524042501,null),new cljs.core.Symbol(null,"exception-data","exception-data",1128056641,null),new cljs.core.Symbol(null,"cause","cause",1872432779,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"ed","ed",2076825751,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_fail)?figwheel.client.default_on_compile_fail.cljs$lang$test:null)])),false,true,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("ws://"),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),cljs.core.str.cljs$core$IFn$_invoke$arity$1("/figwheel-ws")].join(''),false,figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.fill_url_template = (function figwheel$client$fill_url_template(config){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
return cljs.core.update_in.call(null,config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938)], null),(function (x){
return clojure.string.replace.call(null,clojure.string.replace.call(null,x,"[[client-hostname]]",location.hostname),"[[client-port]]",location.port);
}));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"enforce-figwheel-version-plugin","enforce-figwheel-version-plugin",-1916185220),figwheel.client.enforce_figwheel_version_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__40870__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__40870__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__40870__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__54372 = cljs.core.seq.call(null,plugins);
var chunk__54373 = null;
var count__54374 = (0);
var i__54375 = (0);
while(true){
if((i__54375 < count__54374)){
var vec__54376 = cljs.core._nth.call(null,chunk__54373,i__54375);
var k = cljs.core.nth.call(null,vec__54376,(0),null);
var plugin = cljs.core.nth.call(null,vec__54376,(1),null);
if(cljs.core.truth_(plugin)){
var pl_54382 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__54372,chunk__54373,count__54374,i__54375,pl_54382,vec__54376,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_54382.call(null,msg_hist);
});})(seq__54372,chunk__54373,count__54374,i__54375,pl_54382,vec__54376,k,plugin))
);
} else {
}

var G__54383 = seq__54372;
var G__54384 = chunk__54373;
var G__54385 = count__54374;
var G__54386 = (i__54375 + (1));
seq__54372 = G__54383;
chunk__54373 = G__54384;
count__54374 = G__54385;
i__54375 = G__54386;
continue;
} else {
var temp__6738__auto__ = cljs.core.seq.call(null,seq__54372);
if(temp__6738__auto__){
var seq__54372__$1 = temp__6738__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__54372__$1)){
var c__41793__auto__ = cljs.core.chunk_first.call(null,seq__54372__$1);
var G__54387 = cljs.core.chunk_rest.call(null,seq__54372__$1);
var G__54388 = c__41793__auto__;
var G__54389 = cljs.core.count.call(null,c__41793__auto__);
var G__54390 = (0);
seq__54372 = G__54387;
chunk__54373 = G__54388;
count__54374 = G__54389;
i__54375 = G__54390;
continue;
} else {
var vec__54379 = cljs.core.first.call(null,seq__54372__$1);
var k = cljs.core.nth.call(null,vec__54379,(0),null);
var plugin = cljs.core.nth.call(null,vec__54379,(1),null);
if(cljs.core.truth_(plugin)){
var pl_54391 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__54372,chunk__54373,count__54374,i__54375,pl_54391,vec__54379,k,plugin,seq__54372__$1,temp__6738__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_54391.call(null,msg_hist);
});})(seq__54372,chunk__54373,count__54374,i__54375,pl_54391,vec__54379,k,plugin,seq__54372__$1,temp__6738__auto__))
);
} else {
}

var G__54392 = cljs.core.next.call(null,seq__54372__$1);
var G__54393 = null;
var G__54394 = (0);
var G__54395 = (0);
seq__54372 = G__54392;
chunk__54373 = G__54393;
count__54374 = G__54394;
i__54375 = G__54395;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var args54396 = [];
var len__42103__auto___54403 = arguments.length;
var i__42104__auto___54404 = (0);
while(true){
if((i__42104__auto___54404 < len__42103__auto___54403)){
args54396.push((arguments[i__42104__auto___54404]));

var G__54405 = (i__42104__auto___54404 + (1));
i__42104__auto___54404 = G__54405;
continue;
} else {
}
break;
}

var G__54398 = args54396.length;
switch (G__54398) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args54396.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if(typeof figwheel.client.__figwheel_start_once__ !== 'undefined'){
return null;
} else {
return (
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.fill_url_template.call(null,figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370)))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.enable_repl_print_BANG_.call(null);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

var seq__54399_54407 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"initial-messages","initial-messages",2057377771).cljs$core$IFn$_invoke$arity$1(system_options));
var chunk__54400_54408 = null;
var count__54401_54409 = (0);
var i__54402_54410 = (0);
while(true){
if((i__54402_54410 < count__54401_54409)){
var msg_54411 = cljs.core._nth.call(null,chunk__54400_54408,i__54402_54410);
figwheel.client.socket.handle_incoming_message.call(null,msg_54411);

var G__54412 = seq__54399_54407;
var G__54413 = chunk__54400_54408;
var G__54414 = count__54401_54409;
var G__54415 = (i__54402_54410 + (1));
seq__54399_54407 = G__54412;
chunk__54400_54408 = G__54413;
count__54401_54409 = G__54414;
i__54402_54410 = G__54415;
continue;
} else {
var temp__6738__auto___54416 = cljs.core.seq.call(null,seq__54399_54407);
if(temp__6738__auto___54416){
var seq__54399_54417__$1 = temp__6738__auto___54416;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__54399_54417__$1)){
var c__41793__auto___54418 = cljs.core.chunk_first.call(null,seq__54399_54417__$1);
var G__54419 = cljs.core.chunk_rest.call(null,seq__54399_54417__$1);
var G__54420 = c__41793__auto___54418;
var G__54421 = cljs.core.count.call(null,c__41793__auto___54418);
var G__54422 = (0);
seq__54399_54407 = G__54419;
chunk__54400_54408 = G__54420;
count__54401_54409 = G__54421;
i__54402_54410 = G__54422;
continue;
} else {
var msg_54423 = cljs.core.first.call(null,seq__54399_54417__$1);
figwheel.client.socket.handle_incoming_message.call(null,msg_54423);

var G__54424 = cljs.core.next.call(null,seq__54399_54417__$1);
var G__54425 = null;
var G__54426 = (0);
var G__54427 = (0);
seq__54399_54407 = G__54424;
chunk__54400_54408 = G__54425;
count__54401_54409 = G__54426;
i__54402_54410 = G__54427;
continue;
}
} else {
}
}
break;
}

return figwheel.client.socket.open.call(null,system_options);
})))
;
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;

figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__42110__auto__ = [];
var len__42103__auto___54432 = arguments.length;
var i__42104__auto___54433 = (0);
while(true){
if((i__42104__auto___54433 < len__42103__auto___54432)){
args__42110__auto__.push((arguments[i__42104__auto___54433]));

var G__54434 = (i__42104__auto___54433 + (1));
i__42104__auto___54433 = G__54434;
continue;
} else {
}
break;
}

var argseq__42111__auto__ = ((((0) < args__42110__auto__.length))?(new cljs.core.IndexedSeq(args__42110__auto__.slice((0)),(0),null)):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__42111__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__54429){
var map__54430 = p__54429;
var map__54430__$1 = ((((!((map__54430 == null)))?((((map__54430.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54430.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54430):map__54430);
var opts = map__54430__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq54428){
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq54428));
});

figwheel.client.fetch_data_from_env = (function figwheel$client$fetch_data_from_env(){
try{return cljs.reader.read_string.call(null,goog.object.get(window,"FIGWHEEL_CLIENT_CONFIGURATION"));
}catch (e54436){if((e54436 instanceof Error)){
var e = e54436;
cljs.core._STAR_print_err_fn_STAR_.call(null,"Unable to load FIGWHEEL_CLIENT_CONFIGURATION from the environment");

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"autoload","autoload",-354122500),false], null);
} else {
throw e54436;

}
}});
figwheel.client.console_intro_message = "Figwheel has compiled a temporary helper application to your :output-file.\n\nThe code currently in your configured output file does not\nrepresent the code that you are trying to compile.\n\nThis temporary application is intended to help you continue to get\nfeedback from Figwheel until the build you are working on compiles\ncorrectly.\n\nWhen your ClojureScript source code compiles correctly this helper\napplication will auto-reload and pick up your freshly compiled\nClojureScript program.";
figwheel.client.bad_compile_helper_app = (function figwheel$client$bad_compile_helper_app(){
cljs.core.enable_console_print_BANG_.call(null);

var config = figwheel.client.fetch_data_from_env.call(null);
cljs.core.println.call(null,figwheel.client.console_intro_message);

figwheel.client.heads_up.bad_compile_screen.call(null);

if(cljs.core.truth_(goog.dependencies_)){
} else {
goog.dependencies_ = true;
}

figwheel.client.start.call(null,config);

return figwheel.client.add_message_watch.call(null,new cljs.core.Keyword(null,"listen-for-successful-compile","listen-for-successful-compile",-995277603),((function (config){
return (function (p__54440){
var map__54441 = p__54440;
var map__54441__$1 = ((((!((map__54441 == null)))?((((map__54441.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54441.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54441):map__54441);
var msg_name = cljs.core.get.call(null,map__54441__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))){
return location.href = location.href;
} else {
return null;
}
});})(config))
);
});

//# sourceMappingURL=client.js.map?rel=1523205761321