// Compiled by ClojureScript 1.11.132 {:optimizations :none}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
goog.scope(function(){
cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__23525 = arguments.length;
switch (G__23525) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async23526 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23526 = (function (f,blockable,meta23527){
this.f = f;
this.blockable = blockable;
this.meta23527 = meta23527;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async23526.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23528,meta23527__$1){
var self__ = this;
var _23528__$1 = this;
return (new cljs.core.async.t_cljs$core$async23526(self__.f,self__.blockable,meta23527__$1));
}));

(cljs.core.async.t_cljs$core$async23526.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23528){
var self__ = this;
var _23528__$1 = this;
return self__.meta23527;
}));

(cljs.core.async.t_cljs$core$async23526.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async23526.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async23526.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async23526.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async23526.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta23527","meta23527",-1086211707,null)], null);
}));

(cljs.core.async.t_cljs$core$async23526.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async23526.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23526");

(cljs.core.async.t_cljs$core$async23526.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write.call(null,writer__5288__auto__,"cljs.core.async/t_cljs$core$async23526");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async23526.
 */
cljs.core.async.__GT_t_cljs$core$async23526 = (function cljs$core$async$__GT_t_cljs$core$async23526(f__$1,blockable__$1,meta23527){
return (new cljs.core.async.t_cljs$core$async23526(f__$1,blockable__$1,meta23527));
});

}

return (new cljs.core.async.t_cljs$core$async23526(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__23532 = arguments.length;
switch (G__23532) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__23535 = arguments.length;
switch (G__23535) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__23538 = arguments.length;
switch (G__23538) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_23540 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_23540);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,val_23540);
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__23542 = arguments.length;
switch (G__23542) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5802__auto__)){
var ret = temp__5802__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5802__auto__)){
var retb = temp__5802__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,ret);
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5593__auto___23544 = n;
var x_23545 = (0);
while(true){
if((x_23545 < n__5593__auto___23544)){
(a[x_23545] = x_23545);

var G__23546 = (x_23545 + (1));
x_23545 = G__23546;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle.call(null,a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async23547 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23547 = (function (flag,meta23548){
this.flag = flag;
this.meta23548 = meta23548;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async23547.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23549,meta23548__$1){
var self__ = this;
var _23549__$1 = this;
return (new cljs.core.async.t_cljs$core$async23547(self__.flag,meta23548__$1));
}));

(cljs.core.async.t_cljs$core$async23547.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23549){
var self__ = this;
var _23549__$1 = this;
return self__.meta23548;
}));

(cljs.core.async.t_cljs$core$async23547.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async23547.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async23547.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async23547.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async23547.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta23548","meta23548",-1112025103,null)], null);
}));

(cljs.core.async.t_cljs$core$async23547.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async23547.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23547");

(cljs.core.async.t_cljs$core$async23547.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write.call(null,writer__5288__auto__,"cljs.core.async/t_cljs$core$async23547");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async23547.
 */
cljs.core.async.__GT_t_cljs$core$async23547 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async23547(flag__$1,meta23548){
return (new cljs.core.async.t_cljs$core$async23547(flag__$1,meta23548));
});

}

return (new cljs.core.async.t_cljs$core$async23547(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async23550 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23550 = (function (flag,cb,meta23551){
this.flag = flag;
this.cb = cb;
this.meta23551 = meta23551;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async23550.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23552,meta23551__$1){
var self__ = this;
var _23552__$1 = this;
return (new cljs.core.async.t_cljs$core$async23550(self__.flag,self__.cb,meta23551__$1));
}));

(cljs.core.async.t_cljs$core$async23550.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23552){
var self__ = this;
var _23552__$1 = this;
return self__.meta23551;
}));

(cljs.core.async.t_cljs$core$async23550.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async23550.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async23550.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async23550.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async23550.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta23551","meta23551",-191785414,null)], null);
}));

(cljs.core.async.t_cljs$core$async23550.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async23550.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23550");

(cljs.core.async.t_cljs$core$async23550.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write.call(null,writer__5288__auto__,"cljs.core.async/t_cljs$core$async23550");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async23550.
 */
cljs.core.async.__GT_t_cljs$core$async23550 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async23550(flag__$1,cb__$1,meta23551){
return (new cljs.core.async.t_cljs$core$async23550(flag__$1,cb__$1,meta23551));
});

}

return (new cljs.core.async.t_cljs$core$async23550(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count.call(null,ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag.call(null);
var ports__$1 = cljs.core.vec.call(null,ports);
var n = cljs.core.count.call(null,ports__$1);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports__$1,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,ports__$1,n,idxs,priority){
return (function (p1__23553_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__23553_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,ports__$1,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,ports__$1,n,idxs,priority){
return (function (p1__23554_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__23554_SHARP_,port], null));
});})(i,idx,port,wport,flag,ports__$1,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__5002__auto__ = wport;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return port;
}
})()], null));
} else {
var G__23555 = (i + (1));
i = G__23555;
continue;
}
} else {
return null;
}
break;
}
})();
var or__5002__auto__ = ret;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5804__auto__ = (function (){var and__5000__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__5000__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__5000__auto__;
}
})();
if(cljs.core.truth_(temp__5804__auto__)){
var got = temp__5804__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5732__auto__ = [];
var len__5726__auto___23560 = arguments.length;
var i__5727__auto___23561 = (0);
while(true){
if((i__5727__auto___23561 < len__5726__auto___23560)){
args__5732__auto__.push((arguments[i__5727__auto___23561]));

var G__23562 = (i__5727__auto___23561 + (1));
i__5727__auto___23561 = G__23562;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__23558){
var map__23559 = p__23558;
var map__23559__$1 = cljs.core.__destructure_map.call(null,map__23559);
var opts = map__23559__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq23556){
var G__23557 = cljs.core.first.call(null,seq23556);
var seq23556__$1 = cljs.core.next.call(null,seq23556);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__23557,seq23556__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__23564 = arguments.length;
switch (G__23564) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__21592__auto___23611 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = (function (state_23588){
var state_val_23589 = (state_23588[(1)]);
if((state_val_23589 === (7))){
var inst_23584 = (state_23588[(2)]);
var state_23588__$1 = state_23588;
var statearr_23590_23612 = state_23588__$1;
(statearr_23590_23612[(2)] = inst_23584);

(statearr_23590_23612[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23589 === (1))){
var state_23588__$1 = state_23588;
var statearr_23591_23613 = state_23588__$1;
(statearr_23591_23613[(2)] = null);

(statearr_23591_23613[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23589 === (4))){
var inst_23567 = (state_23588[(7)]);
var inst_23567__$1 = (state_23588[(2)]);
var inst_23568 = (inst_23567__$1 == null);
var state_23588__$1 = (function (){var statearr_23592 = state_23588;
(statearr_23592[(7)] = inst_23567__$1);

return statearr_23592;
})();
if(cljs.core.truth_(inst_23568)){
var statearr_23593_23614 = state_23588__$1;
(statearr_23593_23614[(1)] = (5));

} else {
var statearr_23594_23615 = state_23588__$1;
(statearr_23594_23615[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23589 === (13))){
var state_23588__$1 = state_23588;
var statearr_23595_23616 = state_23588__$1;
(statearr_23595_23616[(2)] = null);

(statearr_23595_23616[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23589 === (6))){
var inst_23567 = (state_23588[(7)]);
var state_23588__$1 = state_23588;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23588__$1,(11),to,inst_23567);
} else {
if((state_val_23589 === (3))){
var inst_23586 = (state_23588[(2)]);
var state_23588__$1 = state_23588;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23588__$1,inst_23586);
} else {
if((state_val_23589 === (12))){
var state_23588__$1 = state_23588;
var statearr_23596_23617 = state_23588__$1;
(statearr_23596_23617[(2)] = null);

(statearr_23596_23617[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23589 === (2))){
var state_23588__$1 = state_23588;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23588__$1,(4),from);
} else {
if((state_val_23589 === (11))){
var inst_23577 = (state_23588[(2)]);
var state_23588__$1 = state_23588;
if(cljs.core.truth_(inst_23577)){
var statearr_23597_23618 = state_23588__$1;
(statearr_23597_23618[(1)] = (12));

} else {
var statearr_23598_23619 = state_23588__$1;
(statearr_23598_23619[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23589 === (9))){
var state_23588__$1 = state_23588;
var statearr_23599_23620 = state_23588__$1;
(statearr_23599_23620[(2)] = null);

(statearr_23599_23620[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23589 === (5))){
var state_23588__$1 = state_23588;
if(cljs.core.truth_(close_QMARK_)){
var statearr_23600_23621 = state_23588__$1;
(statearr_23600_23621[(1)] = (8));

} else {
var statearr_23601_23622 = state_23588__$1;
(statearr_23601_23622[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23589 === (14))){
var inst_23582 = (state_23588[(2)]);
var state_23588__$1 = state_23588;
var statearr_23602_23623 = state_23588__$1;
(statearr_23602_23623[(2)] = inst_23582);

(statearr_23602_23623[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23589 === (10))){
var inst_23574 = (state_23588[(2)]);
var state_23588__$1 = state_23588;
var statearr_23603_23624 = state_23588__$1;
(statearr_23603_23624[(2)] = inst_23574);

(statearr_23603_23624[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23589 === (8))){
var inst_23571 = cljs.core.async.close_BANG_.call(null,to);
var state_23588__$1 = state_23588;
var statearr_23604_23625 = state_23588__$1;
(statearr_23604_23625[(2)] = inst_23571);

(statearr_23604_23625[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__21468__auto__ = null;
var cljs$core$async$state_machine__21468__auto____0 = (function (){
var statearr_23605 = [null,null,null,null,null,null,null,null];
(statearr_23605[(0)] = cljs$core$async$state_machine__21468__auto__);

(statearr_23605[(1)] = (1));

return statearr_23605;
});
var cljs$core$async$state_machine__21468__auto____1 = (function (state_23588){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_23588);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e23606){var ex__21471__auto__ = e23606;
var statearr_23607_23626 = state_23588;
(statearr_23607_23626[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_23588[(4)]))){
var statearr_23608_23627 = state_23588;
(statearr_23608_23627[(1)] = cljs.core.first.call(null,(state_23588[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23628 = state_23588;
state_23588 = G__23628;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
cljs$core$async$state_machine__21468__auto__ = function(state_23588){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__21468__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__21468__auto____1.call(this,state_23588);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__21468__auto____0;
cljs$core$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__21468__auto____1;
return cljs$core$async$state_machine__21468__auto__;
})()
})();
var state__21594__auto__ = (function (){var statearr_23609 = f__21593__auto__.call(null);
(statearr_23609[(6)] = c__21592__auto___23611);

return statearr_23609;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process__$1 = (function (p__23629){
var vec__23630 = p__23629;
var v = cljs.core.nth.call(null,vec__23630,(0),null);
var p = cljs.core.nth.call(null,vec__23630,(1),null);
var job = vec__23630;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__21592__auto___23806 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = (function (state_23637){
var state_val_23638 = (state_23637[(1)]);
if((state_val_23638 === (1))){
var state_23637__$1 = state_23637;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23637__$1,(2),res,v);
} else {
if((state_val_23638 === (2))){
var inst_23634 = (state_23637[(2)]);
var inst_23635 = cljs.core.async.close_BANG_.call(null,res);
var state_23637__$1 = (function (){var statearr_23639 = state_23637;
(statearr_23639[(7)] = inst_23634);

return statearr_23639;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23637__$1,inst_23635);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__21468__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__21468__auto____0 = (function (){
var statearr_23640 = [null,null,null,null,null,null,null,null];
(statearr_23640[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__21468__auto__);

(statearr_23640[(1)] = (1));

return statearr_23640;
});
var cljs$core$async$pipeline_STAR__$_state_machine__21468__auto____1 = (function (state_23637){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_23637);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e23641){var ex__21471__auto__ = e23641;
var statearr_23642_23807 = state_23637;
(statearr_23642_23807[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_23637[(4)]))){
var statearr_23643_23808 = state_23637;
(statearr_23643_23808[(1)] = cljs.core.first.call(null,(state_23637[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23809 = state_23637;
state_23637 = G__23809;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__21468__auto__ = function(state_23637){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__21468__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__21468__auto____1.call(this,state_23637);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__21468__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__21468__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__21468__auto__;
})()
})();
var state__21594__auto__ = (function (){var statearr_23644 = f__21593__auto__.call(null);
(statearr_23644[(6)] = c__21592__auto___23806);

return statearr_23644;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
}));


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var async = (function (p__23645){
var vec__23646 = p__23645;
var v = cljs.core.nth.call(null,vec__23646,(0),null);
var p = cljs.core.nth.call(null,vec__23646,(1),null);
var job = vec__23646;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var n__5593__auto___23810 = n;
var __23811 = (0);
while(true){
if((__23811 < n__5593__auto___23810)){
var G__23649_23812 = type;
var G__23649_23813__$1 = (((G__23649_23812 instanceof cljs.core.Keyword))?G__23649_23812.fqn:null);
switch (G__23649_23813__$1) {
case "compute":
var c__21592__auto___23815 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__23811,c__21592__auto___23815,G__23649_23812,G__23649_23813__$1,n__5593__auto___23810,jobs,results,process__$1,async){
return (function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = ((function (__23811,c__21592__auto___23815,G__23649_23812,G__23649_23813__$1,n__5593__auto___23810,jobs,results,process__$1,async){
return (function (state_23662){
var state_val_23663 = (state_23662[(1)]);
if((state_val_23663 === (1))){
var state_23662__$1 = state_23662;
var statearr_23664_23816 = state_23662__$1;
(statearr_23664_23816[(2)] = null);

(statearr_23664_23816[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23663 === (2))){
var state_23662__$1 = state_23662;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23662__$1,(4),jobs);
} else {
if((state_val_23663 === (3))){
var inst_23660 = (state_23662[(2)]);
var state_23662__$1 = state_23662;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23662__$1,inst_23660);
} else {
if((state_val_23663 === (4))){
var inst_23652 = (state_23662[(2)]);
var inst_23653 = process__$1.call(null,inst_23652);
var state_23662__$1 = state_23662;
if(cljs.core.truth_(inst_23653)){
var statearr_23665_23817 = state_23662__$1;
(statearr_23665_23817[(1)] = (5));

} else {
var statearr_23666_23818 = state_23662__$1;
(statearr_23666_23818[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23663 === (5))){
var state_23662__$1 = state_23662;
var statearr_23667_23819 = state_23662__$1;
(statearr_23667_23819[(2)] = null);

(statearr_23667_23819[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23663 === (6))){
var state_23662__$1 = state_23662;
var statearr_23668_23820 = state_23662__$1;
(statearr_23668_23820[(2)] = null);

(statearr_23668_23820[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23663 === (7))){
var inst_23658 = (state_23662[(2)]);
var state_23662__$1 = state_23662;
var statearr_23669_23821 = state_23662__$1;
(statearr_23669_23821[(2)] = inst_23658);

(statearr_23669_23821[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__23811,c__21592__auto___23815,G__23649_23812,G__23649_23813__$1,n__5593__auto___23810,jobs,results,process__$1,async))
;
return ((function (__23811,switch__21467__auto__,c__21592__auto___23815,G__23649_23812,G__23649_23813__$1,n__5593__auto___23810,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__21468__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__21468__auto____0 = (function (){
var statearr_23670 = [null,null,null,null,null,null,null];
(statearr_23670[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__21468__auto__);

(statearr_23670[(1)] = (1));

return statearr_23670;
});
var cljs$core$async$pipeline_STAR__$_state_machine__21468__auto____1 = (function (state_23662){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_23662);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e23671){var ex__21471__auto__ = e23671;
var statearr_23672_23822 = state_23662;
(statearr_23672_23822[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_23662[(4)]))){
var statearr_23673_23823 = state_23662;
(statearr_23673_23823[(1)] = cljs.core.first.call(null,(state_23662[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23824 = state_23662;
state_23662 = G__23824;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__21468__auto__ = function(state_23662){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__21468__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__21468__auto____1.call(this,state_23662);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__21468__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__21468__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__21468__auto__;
})()
;})(__23811,switch__21467__auto__,c__21592__auto___23815,G__23649_23812,G__23649_23813__$1,n__5593__auto___23810,jobs,results,process__$1,async))
})();
var state__21594__auto__ = (function (){var statearr_23674 = f__21593__auto__.call(null);
(statearr_23674[(6)] = c__21592__auto___23815);

return statearr_23674;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
});})(__23811,c__21592__auto___23815,G__23649_23812,G__23649_23813__$1,n__5593__auto___23810,jobs,results,process__$1,async))
);


break;
case "async":
var c__21592__auto___23825 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__23811,c__21592__auto___23825,G__23649_23812,G__23649_23813__$1,n__5593__auto___23810,jobs,results,process__$1,async){
return (function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = ((function (__23811,c__21592__auto___23825,G__23649_23812,G__23649_23813__$1,n__5593__auto___23810,jobs,results,process__$1,async){
return (function (state_23687){
var state_val_23688 = (state_23687[(1)]);
if((state_val_23688 === (1))){
var state_23687__$1 = state_23687;
var statearr_23689_23826 = state_23687__$1;
(statearr_23689_23826[(2)] = null);

(statearr_23689_23826[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23688 === (2))){
var state_23687__$1 = state_23687;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23687__$1,(4),jobs);
} else {
if((state_val_23688 === (3))){
var inst_23685 = (state_23687[(2)]);
var state_23687__$1 = state_23687;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23687__$1,inst_23685);
} else {
if((state_val_23688 === (4))){
var inst_23677 = (state_23687[(2)]);
var inst_23678 = async.call(null,inst_23677);
var state_23687__$1 = state_23687;
if(cljs.core.truth_(inst_23678)){
var statearr_23690_23827 = state_23687__$1;
(statearr_23690_23827[(1)] = (5));

} else {
var statearr_23691_23828 = state_23687__$1;
(statearr_23691_23828[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23688 === (5))){
var state_23687__$1 = state_23687;
var statearr_23692_23829 = state_23687__$1;
(statearr_23692_23829[(2)] = null);

(statearr_23692_23829[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23688 === (6))){
var state_23687__$1 = state_23687;
var statearr_23693_23830 = state_23687__$1;
(statearr_23693_23830[(2)] = null);

(statearr_23693_23830[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23688 === (7))){
var inst_23683 = (state_23687[(2)]);
var state_23687__$1 = state_23687;
var statearr_23694_23831 = state_23687__$1;
(statearr_23694_23831[(2)] = inst_23683);

(statearr_23694_23831[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__23811,c__21592__auto___23825,G__23649_23812,G__23649_23813__$1,n__5593__auto___23810,jobs,results,process__$1,async))
;
return ((function (__23811,switch__21467__auto__,c__21592__auto___23825,G__23649_23812,G__23649_23813__$1,n__5593__auto___23810,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__21468__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__21468__auto____0 = (function (){
var statearr_23695 = [null,null,null,null,null,null,null];
(statearr_23695[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__21468__auto__);

(statearr_23695[(1)] = (1));

return statearr_23695;
});
var cljs$core$async$pipeline_STAR__$_state_machine__21468__auto____1 = (function (state_23687){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_23687);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e23696){var ex__21471__auto__ = e23696;
var statearr_23697_23832 = state_23687;
(statearr_23697_23832[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_23687[(4)]))){
var statearr_23698_23833 = state_23687;
(statearr_23698_23833[(1)] = cljs.core.first.call(null,(state_23687[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23834 = state_23687;
state_23687 = G__23834;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__21468__auto__ = function(state_23687){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__21468__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__21468__auto____1.call(this,state_23687);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__21468__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__21468__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__21468__auto__;
})()
;})(__23811,switch__21467__auto__,c__21592__auto___23825,G__23649_23812,G__23649_23813__$1,n__5593__auto___23810,jobs,results,process__$1,async))
})();
var state__21594__auto__ = (function (){var statearr_23699 = f__21593__auto__.call(null);
(statearr_23699[(6)] = c__21592__auto___23825);

return statearr_23699;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
});})(__23811,c__21592__auto___23825,G__23649_23812,G__23649_23813__$1,n__5593__auto___23810,jobs,results,process__$1,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__23649_23813__$1)].join('')));

}

var G__23835 = (__23811 + (1));
__23811 = G__23835;
continue;
} else {
}
break;
}

var c__21592__auto___23836 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = (function (state_23721){
var state_val_23722 = (state_23721[(1)]);
if((state_val_23722 === (7))){
var inst_23717 = (state_23721[(2)]);
var state_23721__$1 = state_23721;
var statearr_23723_23837 = state_23721__$1;
(statearr_23723_23837[(2)] = inst_23717);

(statearr_23723_23837[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23722 === (1))){
var state_23721__$1 = state_23721;
var statearr_23724_23838 = state_23721__$1;
(statearr_23724_23838[(2)] = null);

(statearr_23724_23838[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23722 === (4))){
var inst_23702 = (state_23721[(7)]);
var inst_23702__$1 = (state_23721[(2)]);
var inst_23703 = (inst_23702__$1 == null);
var state_23721__$1 = (function (){var statearr_23725 = state_23721;
(statearr_23725[(7)] = inst_23702__$1);

return statearr_23725;
})();
if(cljs.core.truth_(inst_23703)){
var statearr_23726_23839 = state_23721__$1;
(statearr_23726_23839[(1)] = (5));

} else {
var statearr_23727_23840 = state_23721__$1;
(statearr_23727_23840[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23722 === (6))){
var inst_23702 = (state_23721[(7)]);
var inst_23707 = (state_23721[(8)]);
var inst_23707__$1 = cljs.core.async.chan.call(null,(1));
var inst_23708 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23709 = [inst_23702,inst_23707__$1];
var inst_23710 = (new cljs.core.PersistentVector(null,2,(5),inst_23708,inst_23709,null));
var state_23721__$1 = (function (){var statearr_23728 = state_23721;
(statearr_23728[(8)] = inst_23707__$1);

return statearr_23728;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23721__$1,(8),jobs,inst_23710);
} else {
if((state_val_23722 === (3))){
var inst_23719 = (state_23721[(2)]);
var state_23721__$1 = state_23721;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23721__$1,inst_23719);
} else {
if((state_val_23722 === (2))){
var state_23721__$1 = state_23721;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23721__$1,(4),from);
} else {
if((state_val_23722 === (9))){
var inst_23714 = (state_23721[(2)]);
var state_23721__$1 = (function (){var statearr_23729 = state_23721;
(statearr_23729[(9)] = inst_23714);

return statearr_23729;
})();
var statearr_23730_23841 = state_23721__$1;
(statearr_23730_23841[(2)] = null);

(statearr_23730_23841[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23722 === (5))){
var inst_23705 = cljs.core.async.close_BANG_.call(null,jobs);
var state_23721__$1 = state_23721;
var statearr_23731_23842 = state_23721__$1;
(statearr_23731_23842[(2)] = inst_23705);

(statearr_23731_23842[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23722 === (8))){
var inst_23707 = (state_23721[(8)]);
var inst_23712 = (state_23721[(2)]);
var state_23721__$1 = (function (){var statearr_23732 = state_23721;
(statearr_23732[(10)] = inst_23712);

return statearr_23732;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23721__$1,(9),results,inst_23707);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__21468__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__21468__auto____0 = (function (){
var statearr_23733 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_23733[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__21468__auto__);

(statearr_23733[(1)] = (1));

return statearr_23733;
});
var cljs$core$async$pipeline_STAR__$_state_machine__21468__auto____1 = (function (state_23721){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_23721);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e23734){var ex__21471__auto__ = e23734;
var statearr_23735_23843 = state_23721;
(statearr_23735_23843[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_23721[(4)]))){
var statearr_23736_23844 = state_23721;
(statearr_23736_23844[(1)] = cljs.core.first.call(null,(state_23721[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23845 = state_23721;
state_23721 = G__23845;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__21468__auto__ = function(state_23721){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__21468__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__21468__auto____1.call(this,state_23721);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__21468__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__21468__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__21468__auto__;
})()
})();
var state__21594__auto__ = (function (){var statearr_23737 = f__21593__auto__.call(null);
(statearr_23737[(6)] = c__21592__auto___23836);

return statearr_23737;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
}));


var c__21592__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = (function (state_23775){
var state_val_23776 = (state_23775[(1)]);
if((state_val_23776 === (7))){
var inst_23771 = (state_23775[(2)]);
var state_23775__$1 = state_23775;
var statearr_23777_23846 = state_23775__$1;
(statearr_23777_23846[(2)] = inst_23771);

(statearr_23777_23846[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23776 === (20))){
var state_23775__$1 = state_23775;
var statearr_23778_23847 = state_23775__$1;
(statearr_23778_23847[(2)] = null);

(statearr_23778_23847[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23776 === (1))){
var state_23775__$1 = state_23775;
var statearr_23779_23848 = state_23775__$1;
(statearr_23779_23848[(2)] = null);

(statearr_23779_23848[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23776 === (4))){
var inst_23740 = (state_23775[(7)]);
var inst_23740__$1 = (state_23775[(2)]);
var inst_23741 = (inst_23740__$1 == null);
var state_23775__$1 = (function (){var statearr_23780 = state_23775;
(statearr_23780[(7)] = inst_23740__$1);

return statearr_23780;
})();
if(cljs.core.truth_(inst_23741)){
var statearr_23781_23849 = state_23775__$1;
(statearr_23781_23849[(1)] = (5));

} else {
var statearr_23782_23850 = state_23775__$1;
(statearr_23782_23850[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23776 === (15))){
var inst_23753 = (state_23775[(8)]);
var state_23775__$1 = state_23775;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23775__$1,(18),to,inst_23753);
} else {
if((state_val_23776 === (21))){
var inst_23766 = (state_23775[(2)]);
var state_23775__$1 = state_23775;
var statearr_23783_23851 = state_23775__$1;
(statearr_23783_23851[(2)] = inst_23766);

(statearr_23783_23851[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23776 === (13))){
var inst_23768 = (state_23775[(2)]);
var state_23775__$1 = (function (){var statearr_23784 = state_23775;
(statearr_23784[(9)] = inst_23768);

return statearr_23784;
})();
var statearr_23785_23852 = state_23775__$1;
(statearr_23785_23852[(2)] = null);

(statearr_23785_23852[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23776 === (6))){
var inst_23740 = (state_23775[(7)]);
var state_23775__$1 = state_23775;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23775__$1,(11),inst_23740);
} else {
if((state_val_23776 === (17))){
var inst_23761 = (state_23775[(2)]);
var state_23775__$1 = state_23775;
if(cljs.core.truth_(inst_23761)){
var statearr_23786_23853 = state_23775__$1;
(statearr_23786_23853[(1)] = (19));

} else {
var statearr_23787_23854 = state_23775__$1;
(statearr_23787_23854[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23776 === (3))){
var inst_23773 = (state_23775[(2)]);
var state_23775__$1 = state_23775;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23775__$1,inst_23773);
} else {
if((state_val_23776 === (12))){
var inst_23750 = (state_23775[(10)]);
var state_23775__$1 = state_23775;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23775__$1,(14),inst_23750);
} else {
if((state_val_23776 === (2))){
var state_23775__$1 = state_23775;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23775__$1,(4),results);
} else {
if((state_val_23776 === (19))){
var state_23775__$1 = state_23775;
var statearr_23788_23855 = state_23775__$1;
(statearr_23788_23855[(2)] = null);

(statearr_23788_23855[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23776 === (11))){
var inst_23750 = (state_23775[(2)]);
var state_23775__$1 = (function (){var statearr_23789 = state_23775;
(statearr_23789[(10)] = inst_23750);

return statearr_23789;
})();
var statearr_23790_23856 = state_23775__$1;
(statearr_23790_23856[(2)] = null);

(statearr_23790_23856[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23776 === (9))){
var state_23775__$1 = state_23775;
var statearr_23791_23857 = state_23775__$1;
(statearr_23791_23857[(2)] = null);

(statearr_23791_23857[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23776 === (5))){
var state_23775__$1 = state_23775;
if(cljs.core.truth_(close_QMARK_)){
var statearr_23792_23858 = state_23775__$1;
(statearr_23792_23858[(1)] = (8));

} else {
var statearr_23793_23859 = state_23775__$1;
(statearr_23793_23859[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23776 === (14))){
var inst_23753 = (state_23775[(8)]);
var inst_23755 = (state_23775[(11)]);
var inst_23753__$1 = (state_23775[(2)]);
var inst_23754 = (inst_23753__$1 == null);
var inst_23755__$1 = cljs.core.not.call(null,inst_23754);
var state_23775__$1 = (function (){var statearr_23794 = state_23775;
(statearr_23794[(8)] = inst_23753__$1);

(statearr_23794[(11)] = inst_23755__$1);

return statearr_23794;
})();
if(inst_23755__$1){
var statearr_23795_23860 = state_23775__$1;
(statearr_23795_23860[(1)] = (15));

} else {
var statearr_23796_23861 = state_23775__$1;
(statearr_23796_23861[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23776 === (16))){
var inst_23755 = (state_23775[(11)]);
var state_23775__$1 = state_23775;
var statearr_23797_23862 = state_23775__$1;
(statearr_23797_23862[(2)] = inst_23755);

(statearr_23797_23862[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23776 === (10))){
var inst_23747 = (state_23775[(2)]);
var state_23775__$1 = state_23775;
var statearr_23798_23863 = state_23775__$1;
(statearr_23798_23863[(2)] = inst_23747);

(statearr_23798_23863[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23776 === (18))){
var inst_23758 = (state_23775[(2)]);
var state_23775__$1 = state_23775;
var statearr_23799_23864 = state_23775__$1;
(statearr_23799_23864[(2)] = inst_23758);

(statearr_23799_23864[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23776 === (8))){
var inst_23744 = cljs.core.async.close_BANG_.call(null,to);
var state_23775__$1 = state_23775;
var statearr_23800_23865 = state_23775__$1;
(statearr_23800_23865[(2)] = inst_23744);

(statearr_23800_23865[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__21468__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__21468__auto____0 = (function (){
var statearr_23801 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23801[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__21468__auto__);

(statearr_23801[(1)] = (1));

return statearr_23801;
});
var cljs$core$async$pipeline_STAR__$_state_machine__21468__auto____1 = (function (state_23775){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_23775);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e23802){var ex__21471__auto__ = e23802;
var statearr_23803_23866 = state_23775;
(statearr_23803_23866[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_23775[(4)]))){
var statearr_23804_23867 = state_23775;
(statearr_23804_23867[(1)] = cljs.core.first.call(null,(state_23775[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23868 = state_23775;
state_23775 = G__23868;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__21468__auto__ = function(state_23775){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__21468__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__21468__auto____1.call(this,state_23775);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__21468__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__21468__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__21468__auto__;
})()
})();
var state__21594__auto__ = (function (){var statearr_23805 = f__21593__auto__.call(null);
(statearr_23805[(6)] = c__21592__auto__);

return statearr_23805;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
}));

return c__21592__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__23870 = arguments.length;
switch (G__23870) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__23873 = arguments.length;
switch (G__23873) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__23876 = arguments.length;
switch (G__23876) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__21592__auto___23926 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = (function (state_23902){
var state_val_23903 = (state_23902[(1)]);
if((state_val_23903 === (7))){
var inst_23898 = (state_23902[(2)]);
var state_23902__$1 = state_23902;
var statearr_23904_23927 = state_23902__$1;
(statearr_23904_23927[(2)] = inst_23898);

(statearr_23904_23927[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23903 === (1))){
var state_23902__$1 = state_23902;
var statearr_23905_23928 = state_23902__$1;
(statearr_23905_23928[(2)] = null);

(statearr_23905_23928[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23903 === (4))){
var inst_23879 = (state_23902[(7)]);
var inst_23879__$1 = (state_23902[(2)]);
var inst_23880 = (inst_23879__$1 == null);
var state_23902__$1 = (function (){var statearr_23906 = state_23902;
(statearr_23906[(7)] = inst_23879__$1);

return statearr_23906;
})();
if(cljs.core.truth_(inst_23880)){
var statearr_23907_23929 = state_23902__$1;
(statearr_23907_23929[(1)] = (5));

} else {
var statearr_23908_23930 = state_23902__$1;
(statearr_23908_23930[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23903 === (13))){
var state_23902__$1 = state_23902;
var statearr_23909_23931 = state_23902__$1;
(statearr_23909_23931[(2)] = null);

(statearr_23909_23931[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23903 === (6))){
var inst_23879 = (state_23902[(7)]);
var inst_23885 = p.call(null,inst_23879);
var state_23902__$1 = state_23902;
if(cljs.core.truth_(inst_23885)){
var statearr_23910_23932 = state_23902__$1;
(statearr_23910_23932[(1)] = (9));

} else {
var statearr_23911_23933 = state_23902__$1;
(statearr_23911_23933[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23903 === (3))){
var inst_23900 = (state_23902[(2)]);
var state_23902__$1 = state_23902;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23902__$1,inst_23900);
} else {
if((state_val_23903 === (12))){
var state_23902__$1 = state_23902;
var statearr_23912_23934 = state_23902__$1;
(statearr_23912_23934[(2)] = null);

(statearr_23912_23934[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23903 === (2))){
var state_23902__$1 = state_23902;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23902__$1,(4),ch);
} else {
if((state_val_23903 === (11))){
var inst_23879 = (state_23902[(7)]);
var inst_23889 = (state_23902[(2)]);
var state_23902__$1 = state_23902;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23902__$1,(8),inst_23889,inst_23879);
} else {
if((state_val_23903 === (9))){
var state_23902__$1 = state_23902;
var statearr_23913_23935 = state_23902__$1;
(statearr_23913_23935[(2)] = tc);

(statearr_23913_23935[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23903 === (5))){
var inst_23882 = cljs.core.async.close_BANG_.call(null,tc);
var inst_23883 = cljs.core.async.close_BANG_.call(null,fc);
var state_23902__$1 = (function (){var statearr_23914 = state_23902;
(statearr_23914[(8)] = inst_23882);

return statearr_23914;
})();
var statearr_23915_23936 = state_23902__$1;
(statearr_23915_23936[(2)] = inst_23883);

(statearr_23915_23936[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23903 === (14))){
var inst_23896 = (state_23902[(2)]);
var state_23902__$1 = state_23902;
var statearr_23916_23937 = state_23902__$1;
(statearr_23916_23937[(2)] = inst_23896);

(statearr_23916_23937[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23903 === (10))){
var state_23902__$1 = state_23902;
var statearr_23917_23938 = state_23902__$1;
(statearr_23917_23938[(2)] = fc);

(statearr_23917_23938[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23903 === (8))){
var inst_23891 = (state_23902[(2)]);
var state_23902__$1 = state_23902;
if(cljs.core.truth_(inst_23891)){
var statearr_23918_23939 = state_23902__$1;
(statearr_23918_23939[(1)] = (12));

} else {
var statearr_23919_23940 = state_23902__$1;
(statearr_23919_23940[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__21468__auto__ = null;
var cljs$core$async$state_machine__21468__auto____0 = (function (){
var statearr_23920 = [null,null,null,null,null,null,null,null,null];
(statearr_23920[(0)] = cljs$core$async$state_machine__21468__auto__);

(statearr_23920[(1)] = (1));

return statearr_23920;
});
var cljs$core$async$state_machine__21468__auto____1 = (function (state_23902){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_23902);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e23921){var ex__21471__auto__ = e23921;
var statearr_23922_23941 = state_23902;
(statearr_23922_23941[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_23902[(4)]))){
var statearr_23923_23942 = state_23902;
(statearr_23923_23942[(1)] = cljs.core.first.call(null,(state_23902[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23943 = state_23902;
state_23902 = G__23943;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
cljs$core$async$state_machine__21468__auto__ = function(state_23902){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__21468__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__21468__auto____1.call(this,state_23902);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__21468__auto____0;
cljs$core$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__21468__auto____1;
return cljs$core$async$state_machine__21468__auto__;
})()
})();
var state__21594__auto__ = (function (){var statearr_23924 = f__21593__auto__.call(null);
(statearr_23924[(6)] = c__21592__auto___23926);

return statearr_23924;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__21592__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = (function (state_23965){
var state_val_23966 = (state_23965[(1)]);
if((state_val_23966 === (7))){
var inst_23961 = (state_23965[(2)]);
var state_23965__$1 = state_23965;
var statearr_23967_23986 = state_23965__$1;
(statearr_23967_23986[(2)] = inst_23961);

(statearr_23967_23986[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23966 === (1))){
var inst_23944 = init;
var inst_23945 = inst_23944;
var state_23965__$1 = (function (){var statearr_23968 = state_23965;
(statearr_23968[(7)] = inst_23945);

return statearr_23968;
})();
var statearr_23969_23987 = state_23965__$1;
(statearr_23969_23987[(2)] = null);

(statearr_23969_23987[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23966 === (4))){
var inst_23948 = (state_23965[(8)]);
var inst_23948__$1 = (state_23965[(2)]);
var inst_23949 = (inst_23948__$1 == null);
var state_23965__$1 = (function (){var statearr_23970 = state_23965;
(statearr_23970[(8)] = inst_23948__$1);

return statearr_23970;
})();
if(cljs.core.truth_(inst_23949)){
var statearr_23971_23988 = state_23965__$1;
(statearr_23971_23988[(1)] = (5));

} else {
var statearr_23972_23989 = state_23965__$1;
(statearr_23972_23989[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23966 === (6))){
var inst_23945 = (state_23965[(7)]);
var inst_23948 = (state_23965[(8)]);
var inst_23952 = (state_23965[(9)]);
var inst_23952__$1 = f.call(null,inst_23945,inst_23948);
var inst_23953 = cljs.core.reduced_QMARK_.call(null,inst_23952__$1);
var state_23965__$1 = (function (){var statearr_23973 = state_23965;
(statearr_23973[(9)] = inst_23952__$1);

return statearr_23973;
})();
if(inst_23953){
var statearr_23974_23990 = state_23965__$1;
(statearr_23974_23990[(1)] = (8));

} else {
var statearr_23975_23991 = state_23965__$1;
(statearr_23975_23991[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23966 === (3))){
var inst_23963 = (state_23965[(2)]);
var state_23965__$1 = state_23965;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23965__$1,inst_23963);
} else {
if((state_val_23966 === (2))){
var state_23965__$1 = state_23965;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23965__$1,(4),ch);
} else {
if((state_val_23966 === (9))){
var inst_23952 = (state_23965[(9)]);
var inst_23945 = inst_23952;
var state_23965__$1 = (function (){var statearr_23976 = state_23965;
(statearr_23976[(7)] = inst_23945);

return statearr_23976;
})();
var statearr_23977_23992 = state_23965__$1;
(statearr_23977_23992[(2)] = null);

(statearr_23977_23992[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23966 === (5))){
var inst_23945 = (state_23965[(7)]);
var state_23965__$1 = state_23965;
var statearr_23978_23993 = state_23965__$1;
(statearr_23978_23993[(2)] = inst_23945);

(statearr_23978_23993[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23966 === (10))){
var inst_23959 = (state_23965[(2)]);
var state_23965__$1 = state_23965;
var statearr_23979_23994 = state_23965__$1;
(statearr_23979_23994[(2)] = inst_23959);

(statearr_23979_23994[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23966 === (8))){
var inst_23952 = (state_23965[(9)]);
var inst_23955 = cljs.core.deref.call(null,inst_23952);
var state_23965__$1 = state_23965;
var statearr_23980_23995 = state_23965__$1;
(statearr_23980_23995[(2)] = inst_23955);

(statearr_23980_23995[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__21468__auto__ = null;
var cljs$core$async$reduce_$_state_machine__21468__auto____0 = (function (){
var statearr_23981 = [null,null,null,null,null,null,null,null,null,null];
(statearr_23981[(0)] = cljs$core$async$reduce_$_state_machine__21468__auto__);

(statearr_23981[(1)] = (1));

return statearr_23981;
});
var cljs$core$async$reduce_$_state_machine__21468__auto____1 = (function (state_23965){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_23965);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e23982){var ex__21471__auto__ = e23982;
var statearr_23983_23996 = state_23965;
(statearr_23983_23996[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_23965[(4)]))){
var statearr_23984_23997 = state_23965;
(statearr_23984_23997[(1)] = cljs.core.first.call(null,(state_23965[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23998 = state_23965;
state_23965 = G__23998;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__21468__auto__ = function(state_23965){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__21468__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__21468__auto____1.call(this,state_23965);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__21468__auto____0;
cljs$core$async$reduce_$_state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__21468__auto____1;
return cljs$core$async$reduce_$_state_machine__21468__auto__;
})()
})();
var state__21594__auto__ = (function (){var statearr_23985 = f__21593__auto__.call(null);
(statearr_23985[(6)] = c__21592__auto__);

return statearr_23985;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
}));

return c__21592__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__21592__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = (function (state_24004){
var state_val_24005 = (state_24004[(1)]);
if((state_val_24005 === (1))){
var inst_23999 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_24004__$1 = state_24004;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24004__$1,(2),inst_23999);
} else {
if((state_val_24005 === (2))){
var inst_24001 = (state_24004[(2)]);
var inst_24002 = f__$1.call(null,inst_24001);
var state_24004__$1 = state_24004;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24004__$1,inst_24002);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__21468__auto__ = null;
var cljs$core$async$transduce_$_state_machine__21468__auto____0 = (function (){
var statearr_24006 = [null,null,null,null,null,null,null];
(statearr_24006[(0)] = cljs$core$async$transduce_$_state_machine__21468__auto__);

(statearr_24006[(1)] = (1));

return statearr_24006;
});
var cljs$core$async$transduce_$_state_machine__21468__auto____1 = (function (state_24004){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_24004);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e24007){var ex__21471__auto__ = e24007;
var statearr_24008_24011 = state_24004;
(statearr_24008_24011[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_24004[(4)]))){
var statearr_24009_24012 = state_24004;
(statearr_24009_24012[(1)] = cljs.core.first.call(null,(state_24004[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24013 = state_24004;
state_24004 = G__24013;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__21468__auto__ = function(state_24004){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__21468__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__21468__auto____1.call(this,state_24004);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__21468__auto____0;
cljs$core$async$transduce_$_state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__21468__auto____1;
return cljs$core$async$transduce_$_state_machine__21468__auto__;
})()
})();
var state__21594__auto__ = (function (){var statearr_24010 = f__21593__auto__.call(null);
(statearr_24010[(6)] = c__21592__auto__);

return statearr_24010;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
}));

return c__21592__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__24015 = arguments.length;
switch (G__24015) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__21592__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = (function (state_24040){
var state_val_24041 = (state_24040[(1)]);
if((state_val_24041 === (7))){
var inst_24022 = (state_24040[(2)]);
var state_24040__$1 = state_24040;
var statearr_24042_24064 = state_24040__$1;
(statearr_24042_24064[(2)] = inst_24022);

(statearr_24042_24064[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24041 === (1))){
var inst_24016 = cljs.core.seq.call(null,coll);
var inst_24017 = inst_24016;
var state_24040__$1 = (function (){var statearr_24043 = state_24040;
(statearr_24043[(7)] = inst_24017);

return statearr_24043;
})();
var statearr_24044_24065 = state_24040__$1;
(statearr_24044_24065[(2)] = null);

(statearr_24044_24065[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24041 === (4))){
var inst_24017 = (state_24040[(7)]);
var inst_24020 = cljs.core.first.call(null,inst_24017);
var state_24040__$1 = state_24040;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24040__$1,(7),ch,inst_24020);
} else {
if((state_val_24041 === (13))){
var inst_24034 = (state_24040[(2)]);
var state_24040__$1 = state_24040;
var statearr_24045_24066 = state_24040__$1;
(statearr_24045_24066[(2)] = inst_24034);

(statearr_24045_24066[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24041 === (6))){
var inst_24025 = (state_24040[(2)]);
var state_24040__$1 = state_24040;
if(cljs.core.truth_(inst_24025)){
var statearr_24046_24067 = state_24040__$1;
(statearr_24046_24067[(1)] = (8));

} else {
var statearr_24047_24068 = state_24040__$1;
(statearr_24047_24068[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24041 === (3))){
var inst_24038 = (state_24040[(2)]);
var state_24040__$1 = state_24040;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24040__$1,inst_24038);
} else {
if((state_val_24041 === (12))){
var state_24040__$1 = state_24040;
var statearr_24048_24069 = state_24040__$1;
(statearr_24048_24069[(2)] = null);

(statearr_24048_24069[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24041 === (2))){
var inst_24017 = (state_24040[(7)]);
var state_24040__$1 = state_24040;
if(cljs.core.truth_(inst_24017)){
var statearr_24049_24070 = state_24040__$1;
(statearr_24049_24070[(1)] = (4));

} else {
var statearr_24050_24071 = state_24040__$1;
(statearr_24050_24071[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24041 === (11))){
var inst_24031 = cljs.core.async.close_BANG_.call(null,ch);
var state_24040__$1 = state_24040;
var statearr_24051_24072 = state_24040__$1;
(statearr_24051_24072[(2)] = inst_24031);

(statearr_24051_24072[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24041 === (9))){
var state_24040__$1 = state_24040;
if(cljs.core.truth_(close_QMARK_)){
var statearr_24052_24073 = state_24040__$1;
(statearr_24052_24073[(1)] = (11));

} else {
var statearr_24053_24074 = state_24040__$1;
(statearr_24053_24074[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24041 === (5))){
var inst_24017 = (state_24040[(7)]);
var state_24040__$1 = state_24040;
var statearr_24054_24075 = state_24040__$1;
(statearr_24054_24075[(2)] = inst_24017);

(statearr_24054_24075[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24041 === (10))){
var inst_24036 = (state_24040[(2)]);
var state_24040__$1 = state_24040;
var statearr_24055_24076 = state_24040__$1;
(statearr_24055_24076[(2)] = inst_24036);

(statearr_24055_24076[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24041 === (8))){
var inst_24017 = (state_24040[(7)]);
var inst_24027 = cljs.core.next.call(null,inst_24017);
var inst_24017__$1 = inst_24027;
var state_24040__$1 = (function (){var statearr_24056 = state_24040;
(statearr_24056[(7)] = inst_24017__$1);

return statearr_24056;
})();
var statearr_24057_24077 = state_24040__$1;
(statearr_24057_24077[(2)] = null);

(statearr_24057_24077[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__21468__auto__ = null;
var cljs$core$async$state_machine__21468__auto____0 = (function (){
var statearr_24058 = [null,null,null,null,null,null,null,null];
(statearr_24058[(0)] = cljs$core$async$state_machine__21468__auto__);

(statearr_24058[(1)] = (1));

return statearr_24058;
});
var cljs$core$async$state_machine__21468__auto____1 = (function (state_24040){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_24040);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e24059){var ex__21471__auto__ = e24059;
var statearr_24060_24078 = state_24040;
(statearr_24060_24078[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_24040[(4)]))){
var statearr_24061_24079 = state_24040;
(statearr_24061_24079[(1)] = cljs.core.first.call(null,(state_24040[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24080 = state_24040;
state_24040 = G__24080;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
cljs$core$async$state_machine__21468__auto__ = function(state_24040){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__21468__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__21468__auto____1.call(this,state_24040);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__21468__auto____0;
cljs$core$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__21468__auto____1;
return cljs$core$async$state_machine__21468__auto__;
})()
})();
var state__21594__auto__ = (function (){var statearr_24062 = f__21593__auto__.call(null);
(statearr_24062[(6)] = c__21592__auto__);

return statearr_24062;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
}));

return c__21592__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan_BANG_.call(null,ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__24082 = arguments.length;
switch (G__24082) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_.call(null,coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_24084 = (function (_){
var x__5350__auto__ = (((_ == null))?null:_);
var m__5351__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return m__5351__auto__.call(null,_);
} else {
var m__5349__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return m__5349__auto__.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_24084.call(null,_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_24085 = (function (m,ch,close_QMARK_){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return m__5351__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5349__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return m__5349__auto__.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_24085.call(null,m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_24086 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return m__5351__auto__.call(null,m,ch);
} else {
var m__5349__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return m__5349__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_24086.call(null,m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_24087 = (function (m){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return m__5351__auto__.call(null,m);
} else {
var m__5349__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return m__5349__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_24087.call(null,m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async24088 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24088 = (function (ch,cs,meta24089){
this.ch = ch;
this.cs = cs;
this.meta24089 = meta24089;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async24088.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24090,meta24089__$1){
var self__ = this;
var _24090__$1 = this;
return (new cljs.core.async.t_cljs$core$async24088(self__.ch,self__.cs,meta24089__$1));
}));

(cljs.core.async.t_cljs$core$async24088.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24090){
var self__ = this;
var _24090__$1 = this;
return self__.meta24089;
}));

(cljs.core.async.t_cljs$core$async24088.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24088.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async24088.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24088.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async24088.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async24088.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async24088.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta24089","meta24089",1721810909,null)], null);
}));

(cljs.core.async.t_cljs$core$async24088.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async24088.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24088");

(cljs.core.async.t_cljs$core$async24088.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write.call(null,writer__5288__auto__,"cljs.core.async/t_cljs$core$async24088");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async24088.
 */
cljs.core.async.__GT_t_cljs$core$async24088 = (function cljs$core$async$mult_$___GT_t_cljs$core$async24088(ch__$1,cs__$1,meta24089){
return (new cljs.core.async.t_cljs$core$async24088(ch__$1,cs__$1,meta24089));
});

}

return (new cljs.core.async.t_cljs$core$async24088(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});
var c__21592__auto___24307 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = (function (state_24223){
var state_val_24224 = (state_24223[(1)]);
if((state_val_24224 === (7))){
var inst_24219 = (state_24223[(2)]);
var state_24223__$1 = state_24223;
var statearr_24225_24308 = state_24223__$1;
(statearr_24225_24308[(2)] = inst_24219);

(statearr_24225_24308[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (20))){
var inst_24124 = (state_24223[(7)]);
var inst_24136 = cljs.core.first.call(null,inst_24124);
var inst_24137 = cljs.core.nth.call(null,inst_24136,(0),null);
var inst_24138 = cljs.core.nth.call(null,inst_24136,(1),null);
var state_24223__$1 = (function (){var statearr_24226 = state_24223;
(statearr_24226[(8)] = inst_24137);

return statearr_24226;
})();
if(cljs.core.truth_(inst_24138)){
var statearr_24227_24309 = state_24223__$1;
(statearr_24227_24309[(1)] = (22));

} else {
var statearr_24228_24310 = state_24223__$1;
(statearr_24228_24310[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (27))){
var inst_24166 = (state_24223[(9)]);
var inst_24168 = (state_24223[(10)]);
var inst_24173 = (state_24223[(11)]);
var inst_24093 = (state_24223[(12)]);
var inst_24173__$1 = cljs.core._nth.call(null,inst_24166,inst_24168);
var inst_24174 = cljs.core.async.put_BANG_.call(null,inst_24173__$1,inst_24093,done);
var state_24223__$1 = (function (){var statearr_24229 = state_24223;
(statearr_24229[(11)] = inst_24173__$1);

return statearr_24229;
})();
if(cljs.core.truth_(inst_24174)){
var statearr_24230_24311 = state_24223__$1;
(statearr_24230_24311[(1)] = (30));

} else {
var statearr_24231_24312 = state_24223__$1;
(statearr_24231_24312[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (1))){
var state_24223__$1 = state_24223;
var statearr_24232_24313 = state_24223__$1;
(statearr_24232_24313[(2)] = null);

(statearr_24232_24313[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (24))){
var inst_24124 = (state_24223[(7)]);
var inst_24143 = (state_24223[(2)]);
var inst_24144 = cljs.core.next.call(null,inst_24124);
var inst_24102 = inst_24144;
var inst_24103 = null;
var inst_24104 = (0);
var inst_24105 = (0);
var state_24223__$1 = (function (){var statearr_24233 = state_24223;
(statearr_24233[(13)] = inst_24143);

(statearr_24233[(14)] = inst_24102);

(statearr_24233[(15)] = inst_24103);

(statearr_24233[(16)] = inst_24104);

(statearr_24233[(17)] = inst_24105);

return statearr_24233;
})();
var statearr_24234_24314 = state_24223__$1;
(statearr_24234_24314[(2)] = null);

(statearr_24234_24314[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (39))){
var state_24223__$1 = state_24223;
var statearr_24238_24315 = state_24223__$1;
(statearr_24238_24315[(2)] = null);

(statearr_24238_24315[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (4))){
var inst_24093 = (state_24223[(12)]);
var inst_24093__$1 = (state_24223[(2)]);
var inst_24094 = (inst_24093__$1 == null);
var state_24223__$1 = (function (){var statearr_24239 = state_24223;
(statearr_24239[(12)] = inst_24093__$1);

return statearr_24239;
})();
if(cljs.core.truth_(inst_24094)){
var statearr_24240_24316 = state_24223__$1;
(statearr_24240_24316[(1)] = (5));

} else {
var statearr_24241_24317 = state_24223__$1;
(statearr_24241_24317[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (15))){
var inst_24105 = (state_24223[(17)]);
var inst_24102 = (state_24223[(14)]);
var inst_24103 = (state_24223[(15)]);
var inst_24104 = (state_24223[(16)]);
var inst_24120 = (state_24223[(2)]);
var inst_24121 = (inst_24105 + (1));
var tmp24235 = inst_24103;
var tmp24236 = inst_24102;
var tmp24237 = inst_24104;
var inst_24102__$1 = tmp24236;
var inst_24103__$1 = tmp24235;
var inst_24104__$1 = tmp24237;
var inst_24105__$1 = inst_24121;
var state_24223__$1 = (function (){var statearr_24242 = state_24223;
(statearr_24242[(18)] = inst_24120);

(statearr_24242[(14)] = inst_24102__$1);

(statearr_24242[(15)] = inst_24103__$1);

(statearr_24242[(16)] = inst_24104__$1);

(statearr_24242[(17)] = inst_24105__$1);

return statearr_24242;
})();
var statearr_24243_24318 = state_24223__$1;
(statearr_24243_24318[(2)] = null);

(statearr_24243_24318[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (21))){
var inst_24147 = (state_24223[(2)]);
var state_24223__$1 = state_24223;
var statearr_24247_24319 = state_24223__$1;
(statearr_24247_24319[(2)] = inst_24147);

(statearr_24247_24319[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (31))){
var inst_24173 = (state_24223[(11)]);
var inst_24177 = cljs.core.async.untap_STAR_.call(null,m,inst_24173);
var state_24223__$1 = state_24223;
var statearr_24248_24320 = state_24223__$1;
(statearr_24248_24320[(2)] = inst_24177);

(statearr_24248_24320[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (32))){
var inst_24168 = (state_24223[(10)]);
var inst_24165 = (state_24223[(19)]);
var inst_24166 = (state_24223[(9)]);
var inst_24167 = (state_24223[(20)]);
var inst_24179 = (state_24223[(2)]);
var inst_24180 = (inst_24168 + (1));
var tmp24244 = inst_24165;
var tmp24245 = inst_24167;
var tmp24246 = inst_24166;
var inst_24165__$1 = tmp24244;
var inst_24166__$1 = tmp24246;
var inst_24167__$1 = tmp24245;
var inst_24168__$1 = inst_24180;
var state_24223__$1 = (function (){var statearr_24249 = state_24223;
(statearr_24249[(21)] = inst_24179);

(statearr_24249[(19)] = inst_24165__$1);

(statearr_24249[(9)] = inst_24166__$1);

(statearr_24249[(20)] = inst_24167__$1);

(statearr_24249[(10)] = inst_24168__$1);

return statearr_24249;
})();
var statearr_24250_24321 = state_24223__$1;
(statearr_24250_24321[(2)] = null);

(statearr_24250_24321[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (40))){
var inst_24192 = (state_24223[(22)]);
var inst_24196 = cljs.core.async.untap_STAR_.call(null,m,inst_24192);
var state_24223__$1 = state_24223;
var statearr_24251_24322 = state_24223__$1;
(statearr_24251_24322[(2)] = inst_24196);

(statearr_24251_24322[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (33))){
var inst_24183 = (state_24223[(23)]);
var inst_24185 = cljs.core.chunked_seq_QMARK_.call(null,inst_24183);
var state_24223__$1 = state_24223;
if(inst_24185){
var statearr_24252_24323 = state_24223__$1;
(statearr_24252_24323[(1)] = (36));

} else {
var statearr_24253_24324 = state_24223__$1;
(statearr_24253_24324[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (13))){
var inst_24114 = (state_24223[(24)]);
var inst_24117 = cljs.core.async.close_BANG_.call(null,inst_24114);
var state_24223__$1 = state_24223;
var statearr_24254_24325 = state_24223__$1;
(statearr_24254_24325[(2)] = inst_24117);

(statearr_24254_24325[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (22))){
var inst_24137 = (state_24223[(8)]);
var inst_24140 = cljs.core.async.close_BANG_.call(null,inst_24137);
var state_24223__$1 = state_24223;
var statearr_24255_24326 = state_24223__$1;
(statearr_24255_24326[(2)] = inst_24140);

(statearr_24255_24326[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (36))){
var inst_24183 = (state_24223[(23)]);
var inst_24187 = cljs.core.chunk_first.call(null,inst_24183);
var inst_24188 = cljs.core.chunk_rest.call(null,inst_24183);
var inst_24189 = cljs.core.count.call(null,inst_24187);
var inst_24165 = inst_24188;
var inst_24166 = inst_24187;
var inst_24167 = inst_24189;
var inst_24168 = (0);
var state_24223__$1 = (function (){var statearr_24256 = state_24223;
(statearr_24256[(19)] = inst_24165);

(statearr_24256[(9)] = inst_24166);

(statearr_24256[(20)] = inst_24167);

(statearr_24256[(10)] = inst_24168);

return statearr_24256;
})();
var statearr_24257_24327 = state_24223__$1;
(statearr_24257_24327[(2)] = null);

(statearr_24257_24327[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (41))){
var inst_24183 = (state_24223[(23)]);
var inst_24198 = (state_24223[(2)]);
var inst_24199 = cljs.core.next.call(null,inst_24183);
var inst_24165 = inst_24199;
var inst_24166 = null;
var inst_24167 = (0);
var inst_24168 = (0);
var state_24223__$1 = (function (){var statearr_24258 = state_24223;
(statearr_24258[(25)] = inst_24198);

(statearr_24258[(19)] = inst_24165);

(statearr_24258[(9)] = inst_24166);

(statearr_24258[(20)] = inst_24167);

(statearr_24258[(10)] = inst_24168);

return statearr_24258;
})();
var statearr_24259_24328 = state_24223__$1;
(statearr_24259_24328[(2)] = null);

(statearr_24259_24328[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (43))){
var state_24223__$1 = state_24223;
var statearr_24260_24329 = state_24223__$1;
(statearr_24260_24329[(2)] = null);

(statearr_24260_24329[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (29))){
var inst_24207 = (state_24223[(2)]);
var state_24223__$1 = state_24223;
var statearr_24261_24330 = state_24223__$1;
(statearr_24261_24330[(2)] = inst_24207);

(statearr_24261_24330[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (44))){
var inst_24216 = (state_24223[(2)]);
var state_24223__$1 = (function (){var statearr_24262 = state_24223;
(statearr_24262[(26)] = inst_24216);

return statearr_24262;
})();
var statearr_24263_24331 = state_24223__$1;
(statearr_24263_24331[(2)] = null);

(statearr_24263_24331[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (6))){
var inst_24157 = (state_24223[(27)]);
var inst_24156 = cljs.core.deref.call(null,cs);
var inst_24157__$1 = cljs.core.keys.call(null,inst_24156);
var inst_24158 = cljs.core.count.call(null,inst_24157__$1);
var inst_24159 = cljs.core.reset_BANG_.call(null,dctr,inst_24158);
var inst_24164 = cljs.core.seq.call(null,inst_24157__$1);
var inst_24165 = inst_24164;
var inst_24166 = null;
var inst_24167 = (0);
var inst_24168 = (0);
var state_24223__$1 = (function (){var statearr_24264 = state_24223;
(statearr_24264[(27)] = inst_24157__$1);

(statearr_24264[(28)] = inst_24159);

(statearr_24264[(19)] = inst_24165);

(statearr_24264[(9)] = inst_24166);

(statearr_24264[(20)] = inst_24167);

(statearr_24264[(10)] = inst_24168);

return statearr_24264;
})();
var statearr_24265_24332 = state_24223__$1;
(statearr_24265_24332[(2)] = null);

(statearr_24265_24332[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (28))){
var inst_24165 = (state_24223[(19)]);
var inst_24183 = (state_24223[(23)]);
var inst_24183__$1 = cljs.core.seq.call(null,inst_24165);
var state_24223__$1 = (function (){var statearr_24266 = state_24223;
(statearr_24266[(23)] = inst_24183__$1);

return statearr_24266;
})();
if(inst_24183__$1){
var statearr_24267_24333 = state_24223__$1;
(statearr_24267_24333[(1)] = (33));

} else {
var statearr_24268_24334 = state_24223__$1;
(statearr_24268_24334[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (25))){
var inst_24168 = (state_24223[(10)]);
var inst_24167 = (state_24223[(20)]);
var inst_24170 = (inst_24168 < inst_24167);
var inst_24171 = inst_24170;
var state_24223__$1 = state_24223;
if(cljs.core.truth_(inst_24171)){
var statearr_24269_24335 = state_24223__$1;
(statearr_24269_24335[(1)] = (27));

} else {
var statearr_24270_24336 = state_24223__$1;
(statearr_24270_24336[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (34))){
var state_24223__$1 = state_24223;
var statearr_24271_24337 = state_24223__$1;
(statearr_24271_24337[(2)] = null);

(statearr_24271_24337[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (17))){
var state_24223__$1 = state_24223;
var statearr_24272_24338 = state_24223__$1;
(statearr_24272_24338[(2)] = null);

(statearr_24272_24338[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (3))){
var inst_24221 = (state_24223[(2)]);
var state_24223__$1 = state_24223;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24223__$1,inst_24221);
} else {
if((state_val_24224 === (12))){
var inst_24152 = (state_24223[(2)]);
var state_24223__$1 = state_24223;
var statearr_24273_24339 = state_24223__$1;
(statearr_24273_24339[(2)] = inst_24152);

(statearr_24273_24339[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (2))){
var state_24223__$1 = state_24223;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24223__$1,(4),ch);
} else {
if((state_val_24224 === (23))){
var state_24223__$1 = state_24223;
var statearr_24274_24340 = state_24223__$1;
(statearr_24274_24340[(2)] = null);

(statearr_24274_24340[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (35))){
var inst_24205 = (state_24223[(2)]);
var state_24223__$1 = state_24223;
var statearr_24275_24341 = state_24223__$1;
(statearr_24275_24341[(2)] = inst_24205);

(statearr_24275_24341[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (19))){
var inst_24124 = (state_24223[(7)]);
var inst_24128 = cljs.core.chunk_first.call(null,inst_24124);
var inst_24129 = cljs.core.chunk_rest.call(null,inst_24124);
var inst_24130 = cljs.core.count.call(null,inst_24128);
var inst_24102 = inst_24129;
var inst_24103 = inst_24128;
var inst_24104 = inst_24130;
var inst_24105 = (0);
var state_24223__$1 = (function (){var statearr_24276 = state_24223;
(statearr_24276[(14)] = inst_24102);

(statearr_24276[(15)] = inst_24103);

(statearr_24276[(16)] = inst_24104);

(statearr_24276[(17)] = inst_24105);

return statearr_24276;
})();
var statearr_24277_24342 = state_24223__$1;
(statearr_24277_24342[(2)] = null);

(statearr_24277_24342[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (11))){
var inst_24102 = (state_24223[(14)]);
var inst_24124 = (state_24223[(7)]);
var inst_24124__$1 = cljs.core.seq.call(null,inst_24102);
var state_24223__$1 = (function (){var statearr_24278 = state_24223;
(statearr_24278[(7)] = inst_24124__$1);

return statearr_24278;
})();
if(inst_24124__$1){
var statearr_24279_24343 = state_24223__$1;
(statearr_24279_24343[(1)] = (16));

} else {
var statearr_24280_24344 = state_24223__$1;
(statearr_24280_24344[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (9))){
var inst_24154 = (state_24223[(2)]);
var state_24223__$1 = state_24223;
var statearr_24281_24345 = state_24223__$1;
(statearr_24281_24345[(2)] = inst_24154);

(statearr_24281_24345[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (5))){
var inst_24100 = cljs.core.deref.call(null,cs);
var inst_24101 = cljs.core.seq.call(null,inst_24100);
var inst_24102 = inst_24101;
var inst_24103 = null;
var inst_24104 = (0);
var inst_24105 = (0);
var state_24223__$1 = (function (){var statearr_24282 = state_24223;
(statearr_24282[(14)] = inst_24102);

(statearr_24282[(15)] = inst_24103);

(statearr_24282[(16)] = inst_24104);

(statearr_24282[(17)] = inst_24105);

return statearr_24282;
})();
var statearr_24283_24346 = state_24223__$1;
(statearr_24283_24346[(2)] = null);

(statearr_24283_24346[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (14))){
var state_24223__$1 = state_24223;
var statearr_24284_24347 = state_24223__$1;
(statearr_24284_24347[(2)] = null);

(statearr_24284_24347[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (45))){
var inst_24213 = (state_24223[(2)]);
var state_24223__$1 = state_24223;
var statearr_24285_24348 = state_24223__$1;
(statearr_24285_24348[(2)] = inst_24213);

(statearr_24285_24348[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (26))){
var inst_24157 = (state_24223[(27)]);
var inst_24209 = (state_24223[(2)]);
var inst_24210 = cljs.core.seq.call(null,inst_24157);
var state_24223__$1 = (function (){var statearr_24286 = state_24223;
(statearr_24286[(29)] = inst_24209);

return statearr_24286;
})();
if(inst_24210){
var statearr_24287_24349 = state_24223__$1;
(statearr_24287_24349[(1)] = (42));

} else {
var statearr_24288_24350 = state_24223__$1;
(statearr_24288_24350[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (16))){
var inst_24124 = (state_24223[(7)]);
var inst_24126 = cljs.core.chunked_seq_QMARK_.call(null,inst_24124);
var state_24223__$1 = state_24223;
if(inst_24126){
var statearr_24289_24351 = state_24223__$1;
(statearr_24289_24351[(1)] = (19));

} else {
var statearr_24290_24352 = state_24223__$1;
(statearr_24290_24352[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (38))){
var inst_24202 = (state_24223[(2)]);
var state_24223__$1 = state_24223;
var statearr_24291_24353 = state_24223__$1;
(statearr_24291_24353[(2)] = inst_24202);

(statearr_24291_24353[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (30))){
var state_24223__$1 = state_24223;
var statearr_24292_24354 = state_24223__$1;
(statearr_24292_24354[(2)] = null);

(statearr_24292_24354[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (10))){
var inst_24103 = (state_24223[(15)]);
var inst_24105 = (state_24223[(17)]);
var inst_24113 = cljs.core._nth.call(null,inst_24103,inst_24105);
var inst_24114 = cljs.core.nth.call(null,inst_24113,(0),null);
var inst_24115 = cljs.core.nth.call(null,inst_24113,(1),null);
var state_24223__$1 = (function (){var statearr_24293 = state_24223;
(statearr_24293[(24)] = inst_24114);

return statearr_24293;
})();
if(cljs.core.truth_(inst_24115)){
var statearr_24294_24355 = state_24223__$1;
(statearr_24294_24355[(1)] = (13));

} else {
var statearr_24295_24356 = state_24223__$1;
(statearr_24295_24356[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (18))){
var inst_24150 = (state_24223[(2)]);
var state_24223__$1 = state_24223;
var statearr_24296_24357 = state_24223__$1;
(statearr_24296_24357[(2)] = inst_24150);

(statearr_24296_24357[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (42))){
var state_24223__$1 = state_24223;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24223__$1,(45),dchan);
} else {
if((state_val_24224 === (37))){
var inst_24183 = (state_24223[(23)]);
var inst_24192 = (state_24223[(22)]);
var inst_24093 = (state_24223[(12)]);
var inst_24192__$1 = cljs.core.first.call(null,inst_24183);
var inst_24193 = cljs.core.async.put_BANG_.call(null,inst_24192__$1,inst_24093,done);
var state_24223__$1 = (function (){var statearr_24297 = state_24223;
(statearr_24297[(22)] = inst_24192__$1);

return statearr_24297;
})();
if(cljs.core.truth_(inst_24193)){
var statearr_24298_24358 = state_24223__$1;
(statearr_24298_24358[(1)] = (39));

} else {
var statearr_24299_24359 = state_24223__$1;
(statearr_24299_24359[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24224 === (8))){
var inst_24105 = (state_24223[(17)]);
var inst_24104 = (state_24223[(16)]);
var inst_24107 = (inst_24105 < inst_24104);
var inst_24108 = inst_24107;
var state_24223__$1 = state_24223;
if(cljs.core.truth_(inst_24108)){
var statearr_24300_24360 = state_24223__$1;
(statearr_24300_24360[(1)] = (10));

} else {
var statearr_24301_24361 = state_24223__$1;
(statearr_24301_24361[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__21468__auto__ = null;
var cljs$core$async$mult_$_state_machine__21468__auto____0 = (function (){
var statearr_24302 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24302[(0)] = cljs$core$async$mult_$_state_machine__21468__auto__);

(statearr_24302[(1)] = (1));

return statearr_24302;
});
var cljs$core$async$mult_$_state_machine__21468__auto____1 = (function (state_24223){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_24223);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e24303){var ex__21471__auto__ = e24303;
var statearr_24304_24362 = state_24223;
(statearr_24304_24362[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_24223[(4)]))){
var statearr_24305_24363 = state_24223;
(statearr_24305_24363[(1)] = cljs.core.first.call(null,(state_24223[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24364 = state_24223;
state_24223 = G__24364;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__21468__auto__ = function(state_24223){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__21468__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__21468__auto____1.call(this,state_24223);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__21468__auto____0;
cljs$core$async$mult_$_state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__21468__auto____1;
return cljs$core$async$mult_$_state_machine__21468__auto__;
})()
})();
var state__21594__auto__ = (function (){var statearr_24306 = f__21593__auto__.call(null);
(statearr_24306[(6)] = c__21592__auto___24307);

return statearr_24306;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__24366 = arguments.length;
switch (G__24366) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_24368 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return m__5351__auto__.call(null,m,ch);
} else {
var m__5349__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return m__5349__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_24368.call(null,m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_24369 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return m__5351__auto__.call(null,m,ch);
} else {
var m__5349__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return m__5349__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_24369.call(null,m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_24370 = (function (m){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return m__5351__auto__.call(null,m);
} else {
var m__5349__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return m__5349__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_24370.call(null,m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_24371 = (function (m,state_map){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return m__5351__auto__.call(null,m,state_map);
} else {
var m__5349__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return m__5349__auto__.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_24371.call(null,m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_24372 = (function (m,mode){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return m__5351__auto__.call(null,m,mode);
} else {
var m__5349__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return m__5349__auto__.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_24372.call(null,m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5732__auto__ = [];
var len__5726__auto___24382 = arguments.length;
var i__5727__auto___24383 = (0);
while(true){
if((i__5727__auto___24383 < len__5726__auto___24382)){
args__5732__auto__.push((arguments[i__5727__auto___24383]));

var G__24384 = (i__5727__auto___24383 + (1));
i__5727__auto___24383 = G__24384;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((3) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5733__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__24377){
var map__24378 = p__24377;
var map__24378__$1 = cljs.core.__destructure_map.call(null,map__24378);
var opts = map__24378__$1;
var statearr_24379_24385 = state;
(statearr_24379_24385[(1)] = cont_block);


var temp__5804__auto__ = cljs.core.async.do_alts.call(null,(function (val){
var statearr_24380_24386 = state;
(statearr_24380_24386[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
}),ports,opts);
if(cljs.core.truth_(temp__5804__auto__)){
var cb = temp__5804__auto__;
var statearr_24381_24387 = state;
(statearr_24381_24387[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq24373){
var G__24374 = cljs.core.first.call(null,seq24373);
var seq24373__$1 = cljs.core.next.call(null,seq24373);
var G__24375 = cljs.core.first.call(null,seq24373__$1);
var seq24373__$2 = cljs.core.next.call(null,seq24373__$1);
var G__24376 = cljs.core.first.call(null,seq24373__$2);
var seq24373__$3 = cljs.core.next.call(null,seq24373__$2);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__24374,G__24375,G__24376,seq24373__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null,cljs.core.async.sliding_buffer.call(null,(1)));
var changed = (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv.call(null,(function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (cljs.core.seq.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async24388 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24388 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta24389){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta24389 = meta24389;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async24388.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24390,meta24389__$1){
var self__ = this;
var _24390__$1 = this;
return (new cljs.core.async.t_cljs$core$async24388(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta24389__$1));
}));

(cljs.core.async.t_cljs$core$async24388.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24390){
var self__ = this;
var _24390__$1 = this;
return self__.meta24389;
}));

(cljs.core.async.t_cljs$core$async24388.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24388.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async24388.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24388.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async24388.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async24388.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async24388.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async24388.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async24388.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta24389","meta24389",971329590,null)], null);
}));

(cljs.core.async.t_cljs$core$async24388.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async24388.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24388");

(cljs.core.async.t_cljs$core$async24388.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write.call(null,writer__5288__auto__,"cljs.core.async/t_cljs$core$async24388");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async24388.
 */
cljs.core.async.__GT_t_cljs$core$async24388 = (function cljs$core$async$mix_$___GT_t_cljs$core$async24388(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta24389){
return (new cljs.core.async.t_cljs$core$async24388(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta24389));
});

}

return (new cljs.core.async.t_cljs$core$async24388(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__21592__auto___24503 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = (function (state_24458){
var state_val_24459 = (state_24458[(1)]);
if((state_val_24459 === (7))){
var inst_24418 = (state_24458[(2)]);
var state_24458__$1 = state_24458;
if(cljs.core.truth_(inst_24418)){
var statearr_24460_24504 = state_24458__$1;
(statearr_24460_24504[(1)] = (8));

} else {
var statearr_24461_24505 = state_24458__$1;
(statearr_24461_24505[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24459 === (20))){
var inst_24411 = (state_24458[(7)]);
var state_24458__$1 = state_24458;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24458__$1,(23),out,inst_24411);
} else {
if((state_val_24459 === (1))){
var inst_24394 = calc_state.call(null);
var inst_24395 = cljs.core.__destructure_map.call(null,inst_24394);
var inst_24396 = cljs.core.get.call(null,inst_24395,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_24397 = cljs.core.get.call(null,inst_24395,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_24398 = cljs.core.get.call(null,inst_24395,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_24399 = inst_24394;
var state_24458__$1 = (function (){var statearr_24462 = state_24458;
(statearr_24462[(8)] = inst_24396);

(statearr_24462[(9)] = inst_24397);

(statearr_24462[(10)] = inst_24398);

(statearr_24462[(11)] = inst_24399);

return statearr_24462;
})();
var statearr_24463_24506 = state_24458__$1;
(statearr_24463_24506[(2)] = null);

(statearr_24463_24506[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24459 === (24))){
var inst_24402 = (state_24458[(12)]);
var inst_24399 = inst_24402;
var state_24458__$1 = (function (){var statearr_24464 = state_24458;
(statearr_24464[(11)] = inst_24399);

return statearr_24464;
})();
var statearr_24465_24507 = state_24458__$1;
(statearr_24465_24507[(2)] = null);

(statearr_24465_24507[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24459 === (4))){
var inst_24411 = (state_24458[(7)]);
var inst_24413 = (state_24458[(13)]);
var inst_24410 = (state_24458[(2)]);
var inst_24411__$1 = cljs.core.nth.call(null,inst_24410,(0),null);
var inst_24412 = cljs.core.nth.call(null,inst_24410,(1),null);
var inst_24413__$1 = (inst_24411__$1 == null);
var state_24458__$1 = (function (){var statearr_24466 = state_24458;
(statearr_24466[(7)] = inst_24411__$1);

(statearr_24466[(14)] = inst_24412);

(statearr_24466[(13)] = inst_24413__$1);

return statearr_24466;
})();
if(cljs.core.truth_(inst_24413__$1)){
var statearr_24467_24508 = state_24458__$1;
(statearr_24467_24508[(1)] = (5));

} else {
var statearr_24468_24509 = state_24458__$1;
(statearr_24468_24509[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24459 === (15))){
var inst_24403 = (state_24458[(15)]);
var inst_24432 = (state_24458[(16)]);
var inst_24432__$1 = cljs.core.empty_QMARK_.call(null,inst_24403);
var state_24458__$1 = (function (){var statearr_24469 = state_24458;
(statearr_24469[(16)] = inst_24432__$1);

return statearr_24469;
})();
if(inst_24432__$1){
var statearr_24470_24510 = state_24458__$1;
(statearr_24470_24510[(1)] = (17));

} else {
var statearr_24471_24511 = state_24458__$1;
(statearr_24471_24511[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24459 === (21))){
var inst_24402 = (state_24458[(12)]);
var inst_24399 = inst_24402;
var state_24458__$1 = (function (){var statearr_24472 = state_24458;
(statearr_24472[(11)] = inst_24399);

return statearr_24472;
})();
var statearr_24473_24512 = state_24458__$1;
(statearr_24473_24512[(2)] = null);

(statearr_24473_24512[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24459 === (13))){
var inst_24425 = (state_24458[(2)]);
var inst_24426 = calc_state.call(null);
var inst_24399 = inst_24426;
var state_24458__$1 = (function (){var statearr_24474 = state_24458;
(statearr_24474[(17)] = inst_24425);

(statearr_24474[(11)] = inst_24399);

return statearr_24474;
})();
var statearr_24475_24513 = state_24458__$1;
(statearr_24475_24513[(2)] = null);

(statearr_24475_24513[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24459 === (22))){
var inst_24452 = (state_24458[(2)]);
var state_24458__$1 = state_24458;
var statearr_24476_24514 = state_24458__$1;
(statearr_24476_24514[(2)] = inst_24452);

(statearr_24476_24514[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24459 === (6))){
var inst_24412 = (state_24458[(14)]);
var inst_24416 = cljs.core._EQ_.call(null,inst_24412,change);
var state_24458__$1 = state_24458;
var statearr_24477_24515 = state_24458__$1;
(statearr_24477_24515[(2)] = inst_24416);

(statearr_24477_24515[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24459 === (25))){
var state_24458__$1 = state_24458;
var statearr_24478_24516 = state_24458__$1;
(statearr_24478_24516[(2)] = null);

(statearr_24478_24516[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24459 === (17))){
var inst_24404 = (state_24458[(18)]);
var inst_24412 = (state_24458[(14)]);
var inst_24434 = inst_24404.call(null,inst_24412);
var inst_24435 = cljs.core.not.call(null,inst_24434);
var state_24458__$1 = state_24458;
var statearr_24479_24517 = state_24458__$1;
(statearr_24479_24517[(2)] = inst_24435);

(statearr_24479_24517[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24459 === (3))){
var inst_24456 = (state_24458[(2)]);
var state_24458__$1 = state_24458;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24458__$1,inst_24456);
} else {
if((state_val_24459 === (12))){
var state_24458__$1 = state_24458;
var statearr_24480_24518 = state_24458__$1;
(statearr_24480_24518[(2)] = null);

(statearr_24480_24518[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24459 === (2))){
var inst_24399 = (state_24458[(11)]);
var inst_24402 = (state_24458[(12)]);
var inst_24402__$1 = cljs.core.__destructure_map.call(null,inst_24399);
var inst_24403 = cljs.core.get.call(null,inst_24402__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_24404 = cljs.core.get.call(null,inst_24402__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_24405 = cljs.core.get.call(null,inst_24402__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_24458__$1 = (function (){var statearr_24481 = state_24458;
(statearr_24481[(12)] = inst_24402__$1);

(statearr_24481[(15)] = inst_24403);

(statearr_24481[(18)] = inst_24404);

return statearr_24481;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_24458__$1,(4),inst_24405);
} else {
if((state_val_24459 === (23))){
var inst_24443 = (state_24458[(2)]);
var state_24458__$1 = state_24458;
if(cljs.core.truth_(inst_24443)){
var statearr_24482_24519 = state_24458__$1;
(statearr_24482_24519[(1)] = (24));

} else {
var statearr_24483_24520 = state_24458__$1;
(statearr_24483_24520[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24459 === (19))){
var inst_24438 = (state_24458[(2)]);
var state_24458__$1 = state_24458;
var statearr_24484_24521 = state_24458__$1;
(statearr_24484_24521[(2)] = inst_24438);

(statearr_24484_24521[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24459 === (11))){
var inst_24412 = (state_24458[(14)]);
var inst_24422 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_24412);
var state_24458__$1 = state_24458;
var statearr_24485_24522 = state_24458__$1;
(statearr_24485_24522[(2)] = inst_24422);

(statearr_24485_24522[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24459 === (9))){
var inst_24403 = (state_24458[(15)]);
var inst_24412 = (state_24458[(14)]);
var inst_24429 = (state_24458[(19)]);
var inst_24429__$1 = inst_24403.call(null,inst_24412);
var state_24458__$1 = (function (){var statearr_24486 = state_24458;
(statearr_24486[(19)] = inst_24429__$1);

return statearr_24486;
})();
if(cljs.core.truth_(inst_24429__$1)){
var statearr_24487_24523 = state_24458__$1;
(statearr_24487_24523[(1)] = (14));

} else {
var statearr_24488_24524 = state_24458__$1;
(statearr_24488_24524[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24459 === (5))){
var inst_24413 = (state_24458[(13)]);
var state_24458__$1 = state_24458;
var statearr_24489_24525 = state_24458__$1;
(statearr_24489_24525[(2)] = inst_24413);

(statearr_24489_24525[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24459 === (14))){
var inst_24429 = (state_24458[(19)]);
var state_24458__$1 = state_24458;
var statearr_24490_24526 = state_24458__$1;
(statearr_24490_24526[(2)] = inst_24429);

(statearr_24490_24526[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24459 === (26))){
var inst_24448 = (state_24458[(2)]);
var state_24458__$1 = state_24458;
var statearr_24491_24527 = state_24458__$1;
(statearr_24491_24527[(2)] = inst_24448);

(statearr_24491_24527[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24459 === (16))){
var inst_24440 = (state_24458[(2)]);
var state_24458__$1 = state_24458;
if(cljs.core.truth_(inst_24440)){
var statearr_24492_24528 = state_24458__$1;
(statearr_24492_24528[(1)] = (20));

} else {
var statearr_24493_24529 = state_24458__$1;
(statearr_24493_24529[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24459 === (10))){
var inst_24454 = (state_24458[(2)]);
var state_24458__$1 = state_24458;
var statearr_24494_24530 = state_24458__$1;
(statearr_24494_24530[(2)] = inst_24454);

(statearr_24494_24530[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24459 === (18))){
var inst_24432 = (state_24458[(16)]);
var state_24458__$1 = state_24458;
var statearr_24495_24531 = state_24458__$1;
(statearr_24495_24531[(2)] = inst_24432);

(statearr_24495_24531[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24459 === (8))){
var inst_24411 = (state_24458[(7)]);
var inst_24420 = (inst_24411 == null);
var state_24458__$1 = state_24458;
if(cljs.core.truth_(inst_24420)){
var statearr_24496_24532 = state_24458__$1;
(statearr_24496_24532[(1)] = (11));

} else {
var statearr_24497_24533 = state_24458__$1;
(statearr_24497_24533[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__21468__auto__ = null;
var cljs$core$async$mix_$_state_machine__21468__auto____0 = (function (){
var statearr_24498 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24498[(0)] = cljs$core$async$mix_$_state_machine__21468__auto__);

(statearr_24498[(1)] = (1));

return statearr_24498;
});
var cljs$core$async$mix_$_state_machine__21468__auto____1 = (function (state_24458){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_24458);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e24499){var ex__21471__auto__ = e24499;
var statearr_24500_24534 = state_24458;
(statearr_24500_24534[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_24458[(4)]))){
var statearr_24501_24535 = state_24458;
(statearr_24501_24535[(1)] = cljs.core.first.call(null,(state_24458[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24536 = state_24458;
state_24458 = G__24536;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__21468__auto__ = function(state_24458){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__21468__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__21468__auto____1.call(this,state_24458);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__21468__auto____0;
cljs$core$async$mix_$_state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__21468__auto____1;
return cljs$core$async$mix_$_state_machine__21468__auto__;
})()
})();
var state__21594__auto__ = (function (){var statearr_24502 = f__21593__auto__.call(null);
(statearr_24502[(6)] = c__21592__auto___24503);

return statearr_24502;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_24539 = (function (p,v,ch,close_QMARK_){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return m__5351__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5349__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return m__5349__auto__.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_24539.call(null,p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_24540 = (function (p,v,ch){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return m__5351__auto__.call(null,p,v,ch);
} else {
var m__5349__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return m__5349__auto__.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_24540.call(null,p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_24541 = (function() {
var G__24542 = null;
var G__24542__1 = (function (p){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return m__5351__auto__.call(null,p);
} else {
var m__5349__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return m__5349__auto__.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
});
var G__24542__2 = (function (p,v){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return m__5351__auto__.call(null,p,v);
} else {
var m__5349__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return m__5349__auto__.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
});
G__24542 = function(p,v){
switch(arguments.length){
case 1:
return G__24542__1.call(this,p);
case 2:
return G__24542__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24542.cljs$core$IFn$_invoke$arity$1 = G__24542__1;
G__24542.cljs$core$IFn$_invoke$arity$2 = G__24542__2;
return G__24542;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__24538 = arguments.length;
switch (G__24538) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_24541.call(null,p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_24541.call(null,p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__24546 = arguments.length;
switch (G__24546) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__5002__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,(function (p1__24544_SHARP_){
if(cljs.core.truth_(p1__24544_SHARP_.call(null,topic))){
return p1__24544_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__24544_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async24547 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24547 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta24548){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta24548 = meta24548;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async24547.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24549,meta24548__$1){
var self__ = this;
var _24549__$1 = this;
return (new cljs.core.async.t_cljs$core$async24547(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta24548__$1));
}));

(cljs.core.async.t_cljs$core$async24547.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24549){
var self__ = this;
var _24549__$1 = this;
return self__.meta24548;
}));

(cljs.core.async.t_cljs$core$async24547.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24547.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async24547.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24547.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async24547.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5804__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5804__auto__)){
var m = temp__5804__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async24547.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async24547.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async24547.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta24548","meta24548",1122683785,null)], null);
}));

(cljs.core.async.t_cljs$core$async24547.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async24547.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24547");

(cljs.core.async.t_cljs$core$async24547.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write.call(null,writer__5288__auto__,"cljs.core.async/t_cljs$core$async24547");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async24547.
 */
cljs.core.async.__GT_t_cljs$core$async24547 = (function cljs$core$async$__GT_t_cljs$core$async24547(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta24548){
return (new cljs.core.async.t_cljs$core$async24547(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta24548));
});

}

return (new cljs.core.async.t_cljs$core$async24547(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__21592__auto___24668 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = (function (state_24621){
var state_val_24622 = (state_24621[(1)]);
if((state_val_24622 === (7))){
var inst_24617 = (state_24621[(2)]);
var state_24621__$1 = state_24621;
var statearr_24623_24669 = state_24621__$1;
(statearr_24623_24669[(2)] = inst_24617);

(statearr_24623_24669[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24622 === (20))){
var state_24621__$1 = state_24621;
var statearr_24624_24670 = state_24621__$1;
(statearr_24624_24670[(2)] = null);

(statearr_24624_24670[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24622 === (1))){
var state_24621__$1 = state_24621;
var statearr_24625_24671 = state_24621__$1;
(statearr_24625_24671[(2)] = null);

(statearr_24625_24671[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24622 === (24))){
var inst_24600 = (state_24621[(7)]);
var inst_24609 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_24600);
var state_24621__$1 = state_24621;
var statearr_24626_24672 = state_24621__$1;
(statearr_24626_24672[(2)] = inst_24609);

(statearr_24626_24672[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24622 === (4))){
var inst_24552 = (state_24621[(8)]);
var inst_24552__$1 = (state_24621[(2)]);
var inst_24553 = (inst_24552__$1 == null);
var state_24621__$1 = (function (){var statearr_24627 = state_24621;
(statearr_24627[(8)] = inst_24552__$1);

return statearr_24627;
})();
if(cljs.core.truth_(inst_24553)){
var statearr_24628_24673 = state_24621__$1;
(statearr_24628_24673[(1)] = (5));

} else {
var statearr_24629_24674 = state_24621__$1;
(statearr_24629_24674[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24622 === (15))){
var inst_24594 = (state_24621[(2)]);
var state_24621__$1 = state_24621;
var statearr_24630_24675 = state_24621__$1;
(statearr_24630_24675[(2)] = inst_24594);

(statearr_24630_24675[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24622 === (21))){
var inst_24614 = (state_24621[(2)]);
var state_24621__$1 = (function (){var statearr_24631 = state_24621;
(statearr_24631[(9)] = inst_24614);

return statearr_24631;
})();
var statearr_24632_24676 = state_24621__$1;
(statearr_24632_24676[(2)] = null);

(statearr_24632_24676[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24622 === (13))){
var inst_24576 = (state_24621[(10)]);
var inst_24578 = cljs.core.chunked_seq_QMARK_.call(null,inst_24576);
var state_24621__$1 = state_24621;
if(inst_24578){
var statearr_24633_24677 = state_24621__$1;
(statearr_24633_24677[(1)] = (16));

} else {
var statearr_24634_24678 = state_24621__$1;
(statearr_24634_24678[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24622 === (22))){
var inst_24606 = (state_24621[(2)]);
var state_24621__$1 = state_24621;
if(cljs.core.truth_(inst_24606)){
var statearr_24635_24679 = state_24621__$1;
(statearr_24635_24679[(1)] = (23));

} else {
var statearr_24636_24680 = state_24621__$1;
(statearr_24636_24680[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24622 === (6))){
var inst_24552 = (state_24621[(8)]);
var inst_24600 = (state_24621[(7)]);
var inst_24602 = (state_24621[(11)]);
var inst_24600__$1 = topic_fn.call(null,inst_24552);
var inst_24601 = cljs.core.deref.call(null,mults);
var inst_24602__$1 = cljs.core.get.call(null,inst_24601,inst_24600__$1);
var state_24621__$1 = (function (){var statearr_24637 = state_24621;
(statearr_24637[(7)] = inst_24600__$1);

(statearr_24637[(11)] = inst_24602__$1);

return statearr_24637;
})();
if(cljs.core.truth_(inst_24602__$1)){
var statearr_24638_24681 = state_24621__$1;
(statearr_24638_24681[(1)] = (19));

} else {
var statearr_24639_24682 = state_24621__$1;
(statearr_24639_24682[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24622 === (25))){
var inst_24611 = (state_24621[(2)]);
var state_24621__$1 = state_24621;
var statearr_24640_24683 = state_24621__$1;
(statearr_24640_24683[(2)] = inst_24611);

(statearr_24640_24683[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24622 === (17))){
var inst_24576 = (state_24621[(10)]);
var inst_24585 = cljs.core.first.call(null,inst_24576);
var inst_24586 = cljs.core.async.muxch_STAR_.call(null,inst_24585);
var inst_24587 = cljs.core.async.close_BANG_.call(null,inst_24586);
var inst_24588 = cljs.core.next.call(null,inst_24576);
var inst_24562 = inst_24588;
var inst_24563 = null;
var inst_24564 = (0);
var inst_24565 = (0);
var state_24621__$1 = (function (){var statearr_24641 = state_24621;
(statearr_24641[(12)] = inst_24587);

(statearr_24641[(13)] = inst_24562);

(statearr_24641[(14)] = inst_24563);

(statearr_24641[(15)] = inst_24564);

(statearr_24641[(16)] = inst_24565);

return statearr_24641;
})();
var statearr_24642_24684 = state_24621__$1;
(statearr_24642_24684[(2)] = null);

(statearr_24642_24684[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24622 === (3))){
var inst_24619 = (state_24621[(2)]);
var state_24621__$1 = state_24621;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24621__$1,inst_24619);
} else {
if((state_val_24622 === (12))){
var inst_24596 = (state_24621[(2)]);
var state_24621__$1 = state_24621;
var statearr_24643_24685 = state_24621__$1;
(statearr_24643_24685[(2)] = inst_24596);

(statearr_24643_24685[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24622 === (2))){
var state_24621__$1 = state_24621;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24621__$1,(4),ch);
} else {
if((state_val_24622 === (23))){
var state_24621__$1 = state_24621;
var statearr_24644_24686 = state_24621__$1;
(statearr_24644_24686[(2)] = null);

(statearr_24644_24686[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24622 === (19))){
var inst_24602 = (state_24621[(11)]);
var inst_24552 = (state_24621[(8)]);
var inst_24604 = cljs.core.async.muxch_STAR_.call(null,inst_24602);
var state_24621__$1 = state_24621;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24621__$1,(22),inst_24604,inst_24552);
} else {
if((state_val_24622 === (11))){
var inst_24562 = (state_24621[(13)]);
var inst_24576 = (state_24621[(10)]);
var inst_24576__$1 = cljs.core.seq.call(null,inst_24562);
var state_24621__$1 = (function (){var statearr_24645 = state_24621;
(statearr_24645[(10)] = inst_24576__$1);

return statearr_24645;
})();
if(inst_24576__$1){
var statearr_24646_24687 = state_24621__$1;
(statearr_24646_24687[(1)] = (13));

} else {
var statearr_24647_24688 = state_24621__$1;
(statearr_24647_24688[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24622 === (9))){
var inst_24598 = (state_24621[(2)]);
var state_24621__$1 = state_24621;
var statearr_24648_24689 = state_24621__$1;
(statearr_24648_24689[(2)] = inst_24598);

(statearr_24648_24689[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24622 === (5))){
var inst_24559 = cljs.core.deref.call(null,mults);
var inst_24560 = cljs.core.vals.call(null,inst_24559);
var inst_24561 = cljs.core.seq.call(null,inst_24560);
var inst_24562 = inst_24561;
var inst_24563 = null;
var inst_24564 = (0);
var inst_24565 = (0);
var state_24621__$1 = (function (){var statearr_24649 = state_24621;
(statearr_24649[(13)] = inst_24562);

(statearr_24649[(14)] = inst_24563);

(statearr_24649[(15)] = inst_24564);

(statearr_24649[(16)] = inst_24565);

return statearr_24649;
})();
var statearr_24650_24690 = state_24621__$1;
(statearr_24650_24690[(2)] = null);

(statearr_24650_24690[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24622 === (14))){
var state_24621__$1 = state_24621;
var statearr_24654_24691 = state_24621__$1;
(statearr_24654_24691[(2)] = null);

(statearr_24654_24691[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24622 === (16))){
var inst_24576 = (state_24621[(10)]);
var inst_24580 = cljs.core.chunk_first.call(null,inst_24576);
var inst_24581 = cljs.core.chunk_rest.call(null,inst_24576);
var inst_24582 = cljs.core.count.call(null,inst_24580);
var inst_24562 = inst_24581;
var inst_24563 = inst_24580;
var inst_24564 = inst_24582;
var inst_24565 = (0);
var state_24621__$1 = (function (){var statearr_24655 = state_24621;
(statearr_24655[(13)] = inst_24562);

(statearr_24655[(14)] = inst_24563);

(statearr_24655[(15)] = inst_24564);

(statearr_24655[(16)] = inst_24565);

return statearr_24655;
})();
var statearr_24656_24692 = state_24621__$1;
(statearr_24656_24692[(2)] = null);

(statearr_24656_24692[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24622 === (10))){
var inst_24563 = (state_24621[(14)]);
var inst_24565 = (state_24621[(16)]);
var inst_24562 = (state_24621[(13)]);
var inst_24564 = (state_24621[(15)]);
var inst_24570 = cljs.core._nth.call(null,inst_24563,inst_24565);
var inst_24571 = cljs.core.async.muxch_STAR_.call(null,inst_24570);
var inst_24572 = cljs.core.async.close_BANG_.call(null,inst_24571);
var inst_24573 = (inst_24565 + (1));
var tmp24651 = inst_24564;
var tmp24652 = inst_24562;
var tmp24653 = inst_24563;
var inst_24562__$1 = tmp24652;
var inst_24563__$1 = tmp24653;
var inst_24564__$1 = tmp24651;
var inst_24565__$1 = inst_24573;
var state_24621__$1 = (function (){var statearr_24657 = state_24621;
(statearr_24657[(17)] = inst_24572);

(statearr_24657[(13)] = inst_24562__$1);

(statearr_24657[(14)] = inst_24563__$1);

(statearr_24657[(15)] = inst_24564__$1);

(statearr_24657[(16)] = inst_24565__$1);

return statearr_24657;
})();
var statearr_24658_24693 = state_24621__$1;
(statearr_24658_24693[(2)] = null);

(statearr_24658_24693[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24622 === (18))){
var inst_24591 = (state_24621[(2)]);
var state_24621__$1 = state_24621;
var statearr_24659_24694 = state_24621__$1;
(statearr_24659_24694[(2)] = inst_24591);

(statearr_24659_24694[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24622 === (8))){
var inst_24565 = (state_24621[(16)]);
var inst_24564 = (state_24621[(15)]);
var inst_24567 = (inst_24565 < inst_24564);
var inst_24568 = inst_24567;
var state_24621__$1 = state_24621;
if(cljs.core.truth_(inst_24568)){
var statearr_24660_24695 = state_24621__$1;
(statearr_24660_24695[(1)] = (10));

} else {
var statearr_24661_24696 = state_24621__$1;
(statearr_24661_24696[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__21468__auto__ = null;
var cljs$core$async$state_machine__21468__auto____0 = (function (){
var statearr_24662 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24662[(0)] = cljs$core$async$state_machine__21468__auto__);

(statearr_24662[(1)] = (1));

return statearr_24662;
});
var cljs$core$async$state_machine__21468__auto____1 = (function (state_24621){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_24621);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e24663){var ex__21471__auto__ = e24663;
var statearr_24664_24697 = state_24621;
(statearr_24664_24697[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_24621[(4)]))){
var statearr_24665_24698 = state_24621;
(statearr_24665_24698[(1)] = cljs.core.first.call(null,(state_24621[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24699 = state_24621;
state_24621 = G__24699;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
cljs$core$async$state_machine__21468__auto__ = function(state_24621){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__21468__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__21468__auto____1.call(this,state_24621);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__21468__auto____0;
cljs$core$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__21468__auto____1;
return cljs$core$async$state_machine__21468__auto__;
})()
})();
var state__21594__auto__ = (function (){var statearr_24666 = f__21593__auto__.call(null);
(statearr_24666[(6)] = c__21592__auto___24668);

return statearr_24666;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__24701 = arguments.length;
switch (G__24701) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__24704 = arguments.length;
switch (G__24704) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__24707 = arguments.length;
switch (G__24707) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,(function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.call(null,cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_.call(null,out);
} else {
var c__21592__auto___24785 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = (function (state_24750){
var state_val_24751 = (state_24750[(1)]);
if((state_val_24751 === (7))){
var state_24750__$1 = state_24750;
var statearr_24752_24786 = state_24750__$1;
(statearr_24752_24786[(2)] = null);

(statearr_24752_24786[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24751 === (1))){
var state_24750__$1 = state_24750;
var statearr_24753_24787 = state_24750__$1;
(statearr_24753_24787[(2)] = null);

(statearr_24753_24787[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24751 === (4))){
var inst_24711 = (state_24750[(7)]);
var inst_24710 = (state_24750[(8)]);
var inst_24713 = (inst_24711 < inst_24710);
var state_24750__$1 = state_24750;
if(cljs.core.truth_(inst_24713)){
var statearr_24754_24788 = state_24750__$1;
(statearr_24754_24788[(1)] = (6));

} else {
var statearr_24755_24789 = state_24750__$1;
(statearr_24755_24789[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24751 === (15))){
var inst_24736 = (state_24750[(9)]);
var inst_24741 = cljs.core.apply.call(null,f,inst_24736);
var state_24750__$1 = state_24750;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24750__$1,(17),out,inst_24741);
} else {
if((state_val_24751 === (13))){
var inst_24736 = (state_24750[(9)]);
var inst_24736__$1 = (state_24750[(2)]);
var inst_24737 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_24736__$1);
var state_24750__$1 = (function (){var statearr_24756 = state_24750;
(statearr_24756[(9)] = inst_24736__$1);

return statearr_24756;
})();
if(cljs.core.truth_(inst_24737)){
var statearr_24757_24790 = state_24750__$1;
(statearr_24757_24790[(1)] = (14));

} else {
var statearr_24758_24791 = state_24750__$1;
(statearr_24758_24791[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24751 === (6))){
var state_24750__$1 = state_24750;
var statearr_24759_24792 = state_24750__$1;
(statearr_24759_24792[(2)] = null);

(statearr_24759_24792[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24751 === (17))){
var inst_24743 = (state_24750[(2)]);
var state_24750__$1 = (function (){var statearr_24761 = state_24750;
(statearr_24761[(10)] = inst_24743);

return statearr_24761;
})();
var statearr_24762_24793 = state_24750__$1;
(statearr_24762_24793[(2)] = null);

(statearr_24762_24793[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24751 === (3))){
var inst_24748 = (state_24750[(2)]);
var state_24750__$1 = state_24750;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24750__$1,inst_24748);
} else {
if((state_val_24751 === (12))){
var _ = (function (){var statearr_24763 = state_24750;
(statearr_24763[(4)] = cljs.core.rest.call(null,(state_24750[(4)])));

return statearr_24763;
})();
var state_24750__$1 = state_24750;
var ex24760 = (state_24750__$1[(2)]);
var statearr_24764_24794 = state_24750__$1;
(statearr_24764_24794[(5)] = ex24760);


if((ex24760 instanceof Object)){
var statearr_24765_24795 = state_24750__$1;
(statearr_24765_24795[(1)] = (11));

(statearr_24765_24795[(5)] = null);

} else {
throw ex24760;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24751 === (2))){
var inst_24709 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_24710 = cnt;
var inst_24711 = (0);
var state_24750__$1 = (function (){var statearr_24766 = state_24750;
(statearr_24766[(11)] = inst_24709);

(statearr_24766[(8)] = inst_24710);

(statearr_24766[(7)] = inst_24711);

return statearr_24766;
})();
var statearr_24767_24796 = state_24750__$1;
(statearr_24767_24796[(2)] = null);

(statearr_24767_24796[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24751 === (11))){
var inst_24715 = (state_24750[(2)]);
var inst_24716 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_24750__$1 = (function (){var statearr_24768 = state_24750;
(statearr_24768[(12)] = inst_24715);

return statearr_24768;
})();
var statearr_24769_24797 = state_24750__$1;
(statearr_24769_24797[(2)] = inst_24716);

(statearr_24769_24797[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24751 === (9))){
var inst_24711 = (state_24750[(7)]);
var _ = (function (){var statearr_24770 = state_24750;
(statearr_24770[(4)] = cljs.core.cons.call(null,(12),(state_24750[(4)])));

return statearr_24770;
})();
var inst_24722 = chs__$1.call(null,inst_24711);
var inst_24723 = done.call(null,inst_24711);
var inst_24724 = cljs.core.async.take_BANG_.call(null,inst_24722,inst_24723);
var ___$1 = (function (){var statearr_24771 = state_24750;
(statearr_24771[(4)] = cljs.core.rest.call(null,(state_24750[(4)])));

return statearr_24771;
})();
var state_24750__$1 = state_24750;
var statearr_24772_24798 = state_24750__$1;
(statearr_24772_24798[(2)] = inst_24724);

(statearr_24772_24798[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24751 === (5))){
var inst_24734 = (state_24750[(2)]);
var state_24750__$1 = (function (){var statearr_24773 = state_24750;
(statearr_24773[(13)] = inst_24734);

return statearr_24773;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24750__$1,(13),dchan);
} else {
if((state_val_24751 === (14))){
var inst_24739 = cljs.core.async.close_BANG_.call(null,out);
var state_24750__$1 = state_24750;
var statearr_24774_24799 = state_24750__$1;
(statearr_24774_24799[(2)] = inst_24739);

(statearr_24774_24799[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24751 === (16))){
var inst_24746 = (state_24750[(2)]);
var state_24750__$1 = state_24750;
var statearr_24775_24800 = state_24750__$1;
(statearr_24775_24800[(2)] = inst_24746);

(statearr_24775_24800[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24751 === (10))){
var inst_24711 = (state_24750[(7)]);
var inst_24727 = (state_24750[(2)]);
var inst_24728 = (inst_24711 + (1));
var inst_24711__$1 = inst_24728;
var state_24750__$1 = (function (){var statearr_24776 = state_24750;
(statearr_24776[(14)] = inst_24727);

(statearr_24776[(7)] = inst_24711__$1);

return statearr_24776;
})();
var statearr_24777_24801 = state_24750__$1;
(statearr_24777_24801[(2)] = null);

(statearr_24777_24801[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24751 === (8))){
var inst_24732 = (state_24750[(2)]);
var state_24750__$1 = state_24750;
var statearr_24778_24802 = state_24750__$1;
(statearr_24778_24802[(2)] = inst_24732);

(statearr_24778_24802[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__21468__auto__ = null;
var cljs$core$async$state_machine__21468__auto____0 = (function (){
var statearr_24779 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24779[(0)] = cljs$core$async$state_machine__21468__auto__);

(statearr_24779[(1)] = (1));

return statearr_24779;
});
var cljs$core$async$state_machine__21468__auto____1 = (function (state_24750){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_24750);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e24780){var ex__21471__auto__ = e24780;
var statearr_24781_24803 = state_24750;
(statearr_24781_24803[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_24750[(4)]))){
var statearr_24782_24804 = state_24750;
(statearr_24782_24804[(1)] = cljs.core.first.call(null,(state_24750[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24805 = state_24750;
state_24750 = G__24805;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
cljs$core$async$state_machine__21468__auto__ = function(state_24750){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__21468__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__21468__auto____1.call(this,state_24750);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__21468__auto____0;
cljs$core$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__21468__auto____1;
return cljs$core$async$state_machine__21468__auto__;
})()
})();
var state__21594__auto__ = (function (){var statearr_24783 = f__21593__auto__.call(null);
(statearr_24783[(6)] = c__21592__auto___24785);

return statearr_24783;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__24808 = arguments.length;
switch (G__24808) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__21592__auto___24863 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = (function (state_24840){
var state_val_24841 = (state_24840[(1)]);
if((state_val_24841 === (7))){
var inst_24819 = (state_24840[(7)]);
var inst_24820 = (state_24840[(8)]);
var inst_24819__$1 = (state_24840[(2)]);
var inst_24820__$1 = cljs.core.nth.call(null,inst_24819__$1,(0),null);
var inst_24821 = cljs.core.nth.call(null,inst_24819__$1,(1),null);
var inst_24822 = (inst_24820__$1 == null);
var state_24840__$1 = (function (){var statearr_24842 = state_24840;
(statearr_24842[(7)] = inst_24819__$1);

(statearr_24842[(8)] = inst_24820__$1);

(statearr_24842[(9)] = inst_24821);

return statearr_24842;
})();
if(cljs.core.truth_(inst_24822)){
var statearr_24843_24864 = state_24840__$1;
(statearr_24843_24864[(1)] = (8));

} else {
var statearr_24844_24865 = state_24840__$1;
(statearr_24844_24865[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24841 === (1))){
var inst_24809 = cljs.core.vec.call(null,chs);
var inst_24810 = inst_24809;
var state_24840__$1 = (function (){var statearr_24845 = state_24840;
(statearr_24845[(10)] = inst_24810);

return statearr_24845;
})();
var statearr_24846_24866 = state_24840__$1;
(statearr_24846_24866[(2)] = null);

(statearr_24846_24866[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24841 === (4))){
var inst_24810 = (state_24840[(10)]);
var state_24840__$1 = state_24840;
return cljs.core.async.ioc_alts_BANG_.call(null,state_24840__$1,(7),inst_24810);
} else {
if((state_val_24841 === (6))){
var inst_24836 = (state_24840[(2)]);
var state_24840__$1 = state_24840;
var statearr_24847_24867 = state_24840__$1;
(statearr_24847_24867[(2)] = inst_24836);

(statearr_24847_24867[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24841 === (3))){
var inst_24838 = (state_24840[(2)]);
var state_24840__$1 = state_24840;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24840__$1,inst_24838);
} else {
if((state_val_24841 === (2))){
var inst_24810 = (state_24840[(10)]);
var inst_24812 = cljs.core.count.call(null,inst_24810);
var inst_24813 = (inst_24812 > (0));
var state_24840__$1 = state_24840;
if(cljs.core.truth_(inst_24813)){
var statearr_24849_24868 = state_24840__$1;
(statearr_24849_24868[(1)] = (4));

} else {
var statearr_24850_24869 = state_24840__$1;
(statearr_24850_24869[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24841 === (11))){
var inst_24810 = (state_24840[(10)]);
var inst_24829 = (state_24840[(2)]);
var tmp24848 = inst_24810;
var inst_24810__$1 = tmp24848;
var state_24840__$1 = (function (){var statearr_24851 = state_24840;
(statearr_24851[(11)] = inst_24829);

(statearr_24851[(10)] = inst_24810__$1);

return statearr_24851;
})();
var statearr_24852_24870 = state_24840__$1;
(statearr_24852_24870[(2)] = null);

(statearr_24852_24870[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24841 === (9))){
var inst_24820 = (state_24840[(8)]);
var state_24840__$1 = state_24840;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24840__$1,(11),out,inst_24820);
} else {
if((state_val_24841 === (5))){
var inst_24834 = cljs.core.async.close_BANG_.call(null,out);
var state_24840__$1 = state_24840;
var statearr_24853_24871 = state_24840__$1;
(statearr_24853_24871[(2)] = inst_24834);

(statearr_24853_24871[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24841 === (10))){
var inst_24832 = (state_24840[(2)]);
var state_24840__$1 = state_24840;
var statearr_24854_24872 = state_24840__$1;
(statearr_24854_24872[(2)] = inst_24832);

(statearr_24854_24872[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24841 === (8))){
var inst_24810 = (state_24840[(10)]);
var inst_24819 = (state_24840[(7)]);
var inst_24820 = (state_24840[(8)]);
var inst_24821 = (state_24840[(9)]);
var inst_24824 = (function (){var cs = inst_24810;
var vec__24815 = inst_24819;
var v = inst_24820;
var c = inst_24821;
return (function (p1__24806_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__24806_SHARP_);
});
})();
var inst_24825 = cljs.core.filterv.call(null,inst_24824,inst_24810);
var inst_24810__$1 = inst_24825;
var state_24840__$1 = (function (){var statearr_24855 = state_24840;
(statearr_24855[(10)] = inst_24810__$1);

return statearr_24855;
})();
var statearr_24856_24873 = state_24840__$1;
(statearr_24856_24873[(2)] = null);

(statearr_24856_24873[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__21468__auto__ = null;
var cljs$core$async$state_machine__21468__auto____0 = (function (){
var statearr_24857 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24857[(0)] = cljs$core$async$state_machine__21468__auto__);

(statearr_24857[(1)] = (1));

return statearr_24857;
});
var cljs$core$async$state_machine__21468__auto____1 = (function (state_24840){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_24840);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e24858){var ex__21471__auto__ = e24858;
var statearr_24859_24874 = state_24840;
(statearr_24859_24874[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_24840[(4)]))){
var statearr_24860_24875 = state_24840;
(statearr_24860_24875[(1)] = cljs.core.first.call(null,(state_24840[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24876 = state_24840;
state_24840 = G__24876;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
cljs$core$async$state_machine__21468__auto__ = function(state_24840){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__21468__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__21468__auto____1.call(this,state_24840);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__21468__auto____0;
cljs$core$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__21468__auto____1;
return cljs$core$async$state_machine__21468__auto__;
})()
})();
var state__21594__auto__ = (function (){var statearr_24861 = f__21593__auto__.call(null);
(statearr_24861[(6)] = c__21592__auto___24863);

return statearr_24861;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__24878 = arguments.length;
switch (G__24878) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__21592__auto___24924 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = (function (state_24902){
var state_val_24903 = (state_24902[(1)]);
if((state_val_24903 === (7))){
var inst_24884 = (state_24902[(7)]);
var inst_24884__$1 = (state_24902[(2)]);
var inst_24885 = (inst_24884__$1 == null);
var inst_24886 = cljs.core.not.call(null,inst_24885);
var state_24902__$1 = (function (){var statearr_24904 = state_24902;
(statearr_24904[(7)] = inst_24884__$1);

return statearr_24904;
})();
if(inst_24886){
var statearr_24905_24925 = state_24902__$1;
(statearr_24905_24925[(1)] = (8));

} else {
var statearr_24906_24926 = state_24902__$1;
(statearr_24906_24926[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24903 === (1))){
var inst_24879 = (0);
var state_24902__$1 = (function (){var statearr_24907 = state_24902;
(statearr_24907[(8)] = inst_24879);

return statearr_24907;
})();
var statearr_24908_24927 = state_24902__$1;
(statearr_24908_24927[(2)] = null);

(statearr_24908_24927[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24903 === (4))){
var state_24902__$1 = state_24902;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24902__$1,(7),ch);
} else {
if((state_val_24903 === (6))){
var inst_24897 = (state_24902[(2)]);
var state_24902__$1 = state_24902;
var statearr_24909_24928 = state_24902__$1;
(statearr_24909_24928[(2)] = inst_24897);

(statearr_24909_24928[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24903 === (3))){
var inst_24899 = (state_24902[(2)]);
var inst_24900 = cljs.core.async.close_BANG_.call(null,out);
var state_24902__$1 = (function (){var statearr_24910 = state_24902;
(statearr_24910[(9)] = inst_24899);

return statearr_24910;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24902__$1,inst_24900);
} else {
if((state_val_24903 === (2))){
var inst_24879 = (state_24902[(8)]);
var inst_24881 = (inst_24879 < n);
var state_24902__$1 = state_24902;
if(cljs.core.truth_(inst_24881)){
var statearr_24911_24929 = state_24902__$1;
(statearr_24911_24929[(1)] = (4));

} else {
var statearr_24912_24930 = state_24902__$1;
(statearr_24912_24930[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24903 === (11))){
var inst_24879 = (state_24902[(8)]);
var inst_24889 = (state_24902[(2)]);
var inst_24890 = (inst_24879 + (1));
var inst_24879__$1 = inst_24890;
var state_24902__$1 = (function (){var statearr_24913 = state_24902;
(statearr_24913[(10)] = inst_24889);

(statearr_24913[(8)] = inst_24879__$1);

return statearr_24913;
})();
var statearr_24914_24931 = state_24902__$1;
(statearr_24914_24931[(2)] = null);

(statearr_24914_24931[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24903 === (9))){
var state_24902__$1 = state_24902;
var statearr_24915_24932 = state_24902__$1;
(statearr_24915_24932[(2)] = null);

(statearr_24915_24932[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24903 === (5))){
var state_24902__$1 = state_24902;
var statearr_24916_24933 = state_24902__$1;
(statearr_24916_24933[(2)] = null);

(statearr_24916_24933[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24903 === (10))){
var inst_24894 = (state_24902[(2)]);
var state_24902__$1 = state_24902;
var statearr_24917_24934 = state_24902__$1;
(statearr_24917_24934[(2)] = inst_24894);

(statearr_24917_24934[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24903 === (8))){
var inst_24884 = (state_24902[(7)]);
var state_24902__$1 = state_24902;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24902__$1,(11),out,inst_24884);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__21468__auto__ = null;
var cljs$core$async$state_machine__21468__auto____0 = (function (){
var statearr_24918 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24918[(0)] = cljs$core$async$state_machine__21468__auto__);

(statearr_24918[(1)] = (1));

return statearr_24918;
});
var cljs$core$async$state_machine__21468__auto____1 = (function (state_24902){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_24902);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e24919){var ex__21471__auto__ = e24919;
var statearr_24920_24935 = state_24902;
(statearr_24920_24935[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_24902[(4)]))){
var statearr_24921_24936 = state_24902;
(statearr_24921_24936[(1)] = cljs.core.first.call(null,(state_24902[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24937 = state_24902;
state_24902 = G__24937;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
cljs$core$async$state_machine__21468__auto__ = function(state_24902){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__21468__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__21468__auto____1.call(this,state_24902);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__21468__auto____0;
cljs$core$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__21468__auto____1;
return cljs$core$async$state_machine__21468__auto__;
})()
})();
var state__21594__auto__ = (function (){var statearr_24922 = f__21593__auto__.call(null);
(statearr_24922[(6)] = c__21592__auto___24924);

return statearr_24922;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async24939 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24939 = (function (f,ch,meta24940){
this.f = f;
this.ch = ch;
this.meta24940 = meta24940;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async24939.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24941,meta24940__$1){
var self__ = this;
var _24941__$1 = this;
return (new cljs.core.async.t_cljs$core$async24939(self__.f,self__.ch,meta24940__$1));
}));

(cljs.core.async.t_cljs$core$async24939.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24941){
var self__ = this;
var _24941__$1 = this;
return self__.meta24940;
}));

(cljs.core.async.t_cljs$core$async24939.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24939.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async24939.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async24939.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24939.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async24942 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24942 = (function (f,ch,meta24940,_,fn1,meta24943){
this.f = f;
this.ch = ch;
this.meta24940 = meta24940;
this._ = _;
this.fn1 = fn1;
this.meta24943 = meta24943;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async24942.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24944,meta24943__$1){
var self__ = this;
var _24944__$1 = this;
return (new cljs.core.async.t_cljs$core$async24942(self__.f,self__.ch,self__.meta24940,self__._,self__.fn1,meta24943__$1));
}));

(cljs.core.async.t_cljs$core$async24942.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24944){
var self__ = this;
var _24944__$1 = this;
return self__.meta24943;
}));

(cljs.core.async.t_cljs$core$async24942.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24942.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
}));

(cljs.core.async.t_cljs$core$async24942.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async24942.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return (function (p1__24938_SHARP_){
return f1.call(null,(((p1__24938_SHARP_ == null))?null:self__.f.call(null,p1__24938_SHARP_)));
});
}));

(cljs.core.async.t_cljs$core$async24942.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta24940","meta24940",-325740042,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async24939","cljs.core.async/t_cljs$core$async24939",-442328053,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta24943","meta24943",267641038,null)], null);
}));

(cljs.core.async.t_cljs$core$async24942.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async24942.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24942");

(cljs.core.async.t_cljs$core$async24942.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write.call(null,writer__5288__auto__,"cljs.core.async/t_cljs$core$async24942");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async24942.
 */
cljs.core.async.__GT_t_cljs$core$async24942 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async24942(f__$1,ch__$1,meta24940__$1,___$2,fn1__$1,meta24943){
return (new cljs.core.async.t_cljs$core$async24942(f__$1,ch__$1,meta24940__$1,___$2,fn1__$1,meta24943));
});

}

return (new cljs.core.async.t_cljs$core$async24942(self__.f,self__.ch,self__.meta24940,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__5000__auto__ = ret;
if(cljs.core.truth_(and__5000__auto__)){
return (!((cljs.core.deref.call(null,ret) == null)));
} else {
return and__5000__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async24939.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24939.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async24939.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta24940","meta24940",-325740042,null)], null);
}));

(cljs.core.async.t_cljs$core$async24939.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async24939.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24939");

(cljs.core.async.t_cljs$core$async24939.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write.call(null,writer__5288__auto__,"cljs.core.async/t_cljs$core$async24939");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async24939.
 */
cljs.core.async.__GT_t_cljs$core$async24939 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async24939(f__$1,ch__$1,meta24940){
return (new cljs.core.async.t_cljs$core$async24939(f__$1,ch__$1,meta24940));
});

}

return (new cljs.core.async.t_cljs$core$async24939(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async24945 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24945 = (function (f,ch,meta24946){
this.f = f;
this.ch = ch;
this.meta24946 = meta24946;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async24945.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24947,meta24946__$1){
var self__ = this;
var _24947__$1 = this;
return (new cljs.core.async.t_cljs$core$async24945(self__.f,self__.ch,meta24946__$1));
}));

(cljs.core.async.t_cljs$core$async24945.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24947){
var self__ = this;
var _24947__$1 = this;
return self__.meta24946;
}));

(cljs.core.async.t_cljs$core$async24945.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24945.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async24945.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24945.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async24945.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24945.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
}));

(cljs.core.async.t_cljs$core$async24945.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta24946","meta24946",129143883,null)], null);
}));

(cljs.core.async.t_cljs$core$async24945.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async24945.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24945");

(cljs.core.async.t_cljs$core$async24945.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write.call(null,writer__5288__auto__,"cljs.core.async/t_cljs$core$async24945");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async24945.
 */
cljs.core.async.__GT_t_cljs$core$async24945 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async24945(f__$1,ch__$1,meta24946){
return (new cljs.core.async.t_cljs$core$async24945(f__$1,ch__$1,meta24946));
});

}

return (new cljs.core.async.t_cljs$core$async24945(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async24948 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24948 = (function (p,ch,meta24949){
this.p = p;
this.ch = ch;
this.meta24949 = meta24949;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async24948.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24950,meta24949__$1){
var self__ = this;
var _24950__$1 = this;
return (new cljs.core.async.t_cljs$core$async24948(self__.p,self__.ch,meta24949__$1));
}));

(cljs.core.async.t_cljs$core$async24948.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24950){
var self__ = this;
var _24950__$1 = this;
return self__.meta24949;
}));

(cljs.core.async.t_cljs$core$async24948.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24948.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async24948.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async24948.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24948.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async24948.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async24948.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async24948.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta24949","meta24949",-310308695,null)], null);
}));

(cljs.core.async.t_cljs$core$async24948.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async24948.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24948");

(cljs.core.async.t_cljs$core$async24948.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write.call(null,writer__5288__auto__,"cljs.core.async/t_cljs$core$async24948");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async24948.
 */
cljs.core.async.__GT_t_cljs$core$async24948 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async24948(p__$1,ch__$1,meta24949){
return (new cljs.core.async.t_cljs$core$async24948(p__$1,ch__$1,meta24949));
});

}

return (new cljs.core.async.t_cljs$core$async24948(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__24952 = arguments.length;
switch (G__24952) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__21592__auto___24993 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = (function (state_24973){
var state_val_24974 = (state_24973[(1)]);
if((state_val_24974 === (7))){
var inst_24969 = (state_24973[(2)]);
var state_24973__$1 = state_24973;
var statearr_24975_24994 = state_24973__$1;
(statearr_24975_24994[(2)] = inst_24969);

(statearr_24975_24994[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24974 === (1))){
var state_24973__$1 = state_24973;
var statearr_24976_24995 = state_24973__$1;
(statearr_24976_24995[(2)] = null);

(statearr_24976_24995[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24974 === (4))){
var inst_24955 = (state_24973[(7)]);
var inst_24955__$1 = (state_24973[(2)]);
var inst_24956 = (inst_24955__$1 == null);
var state_24973__$1 = (function (){var statearr_24977 = state_24973;
(statearr_24977[(7)] = inst_24955__$1);

return statearr_24977;
})();
if(cljs.core.truth_(inst_24956)){
var statearr_24978_24996 = state_24973__$1;
(statearr_24978_24996[(1)] = (5));

} else {
var statearr_24979_24997 = state_24973__$1;
(statearr_24979_24997[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24974 === (6))){
var inst_24955 = (state_24973[(7)]);
var inst_24960 = p.call(null,inst_24955);
var state_24973__$1 = state_24973;
if(cljs.core.truth_(inst_24960)){
var statearr_24980_24998 = state_24973__$1;
(statearr_24980_24998[(1)] = (8));

} else {
var statearr_24981_24999 = state_24973__$1;
(statearr_24981_24999[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24974 === (3))){
var inst_24971 = (state_24973[(2)]);
var state_24973__$1 = state_24973;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24973__$1,inst_24971);
} else {
if((state_val_24974 === (2))){
var state_24973__$1 = state_24973;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24973__$1,(4),ch);
} else {
if((state_val_24974 === (11))){
var inst_24963 = (state_24973[(2)]);
var state_24973__$1 = state_24973;
var statearr_24982_25000 = state_24973__$1;
(statearr_24982_25000[(2)] = inst_24963);

(statearr_24982_25000[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24974 === (9))){
var state_24973__$1 = state_24973;
var statearr_24983_25001 = state_24973__$1;
(statearr_24983_25001[(2)] = null);

(statearr_24983_25001[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24974 === (5))){
var inst_24958 = cljs.core.async.close_BANG_.call(null,out);
var state_24973__$1 = state_24973;
var statearr_24984_25002 = state_24973__$1;
(statearr_24984_25002[(2)] = inst_24958);

(statearr_24984_25002[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24974 === (10))){
var inst_24966 = (state_24973[(2)]);
var state_24973__$1 = (function (){var statearr_24985 = state_24973;
(statearr_24985[(8)] = inst_24966);

return statearr_24985;
})();
var statearr_24986_25003 = state_24973__$1;
(statearr_24986_25003[(2)] = null);

(statearr_24986_25003[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24974 === (8))){
var inst_24955 = (state_24973[(7)]);
var state_24973__$1 = state_24973;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24973__$1,(11),out,inst_24955);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__21468__auto__ = null;
var cljs$core$async$state_machine__21468__auto____0 = (function (){
var statearr_24987 = [null,null,null,null,null,null,null,null,null];
(statearr_24987[(0)] = cljs$core$async$state_machine__21468__auto__);

(statearr_24987[(1)] = (1));

return statearr_24987;
});
var cljs$core$async$state_machine__21468__auto____1 = (function (state_24973){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_24973);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e24988){var ex__21471__auto__ = e24988;
var statearr_24989_25004 = state_24973;
(statearr_24989_25004[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_24973[(4)]))){
var statearr_24990_25005 = state_24973;
(statearr_24990_25005[(1)] = cljs.core.first.call(null,(state_24973[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25006 = state_24973;
state_24973 = G__25006;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
cljs$core$async$state_machine__21468__auto__ = function(state_24973){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__21468__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__21468__auto____1.call(this,state_24973);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__21468__auto____0;
cljs$core$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__21468__auto____1;
return cljs$core$async$state_machine__21468__auto__;
})()
})();
var state__21594__auto__ = (function (){var statearr_24991 = f__21593__auto__.call(null);
(statearr_24991[(6)] = c__21592__auto___24993);

return statearr_24991;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__25008 = arguments.length;
switch (G__25008) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__21592__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = (function (state_25071){
var state_val_25072 = (state_25071[(1)]);
if((state_val_25072 === (7))){
var inst_25067 = (state_25071[(2)]);
var state_25071__$1 = state_25071;
var statearr_25073_25112 = state_25071__$1;
(statearr_25073_25112[(2)] = inst_25067);

(statearr_25073_25112[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25072 === (20))){
var inst_25037 = (state_25071[(7)]);
var inst_25048 = (state_25071[(2)]);
var inst_25049 = cljs.core.next.call(null,inst_25037);
var inst_25023 = inst_25049;
var inst_25024 = null;
var inst_25025 = (0);
var inst_25026 = (0);
var state_25071__$1 = (function (){var statearr_25074 = state_25071;
(statearr_25074[(8)] = inst_25048);

(statearr_25074[(9)] = inst_25023);

(statearr_25074[(10)] = inst_25024);

(statearr_25074[(11)] = inst_25025);

(statearr_25074[(12)] = inst_25026);

return statearr_25074;
})();
var statearr_25075_25113 = state_25071__$1;
(statearr_25075_25113[(2)] = null);

(statearr_25075_25113[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25072 === (1))){
var state_25071__$1 = state_25071;
var statearr_25076_25114 = state_25071__$1;
(statearr_25076_25114[(2)] = null);

(statearr_25076_25114[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25072 === (4))){
var inst_25012 = (state_25071[(13)]);
var inst_25012__$1 = (state_25071[(2)]);
var inst_25013 = (inst_25012__$1 == null);
var state_25071__$1 = (function (){var statearr_25077 = state_25071;
(statearr_25077[(13)] = inst_25012__$1);

return statearr_25077;
})();
if(cljs.core.truth_(inst_25013)){
var statearr_25078_25115 = state_25071__$1;
(statearr_25078_25115[(1)] = (5));

} else {
var statearr_25079_25116 = state_25071__$1;
(statearr_25079_25116[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25072 === (15))){
var state_25071__$1 = state_25071;
var statearr_25083_25117 = state_25071__$1;
(statearr_25083_25117[(2)] = null);

(statearr_25083_25117[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25072 === (21))){
var state_25071__$1 = state_25071;
var statearr_25084_25118 = state_25071__$1;
(statearr_25084_25118[(2)] = null);

(statearr_25084_25118[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25072 === (13))){
var inst_25026 = (state_25071[(12)]);
var inst_25023 = (state_25071[(9)]);
var inst_25024 = (state_25071[(10)]);
var inst_25025 = (state_25071[(11)]);
var inst_25033 = (state_25071[(2)]);
var inst_25034 = (inst_25026 + (1));
var tmp25080 = inst_25024;
var tmp25081 = inst_25023;
var tmp25082 = inst_25025;
var inst_25023__$1 = tmp25081;
var inst_25024__$1 = tmp25080;
var inst_25025__$1 = tmp25082;
var inst_25026__$1 = inst_25034;
var state_25071__$1 = (function (){var statearr_25085 = state_25071;
(statearr_25085[(14)] = inst_25033);

(statearr_25085[(9)] = inst_25023__$1);

(statearr_25085[(10)] = inst_25024__$1);

(statearr_25085[(11)] = inst_25025__$1);

(statearr_25085[(12)] = inst_25026__$1);

return statearr_25085;
})();
var statearr_25086_25119 = state_25071__$1;
(statearr_25086_25119[(2)] = null);

(statearr_25086_25119[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25072 === (22))){
var state_25071__$1 = state_25071;
var statearr_25087_25120 = state_25071__$1;
(statearr_25087_25120[(2)] = null);

(statearr_25087_25120[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25072 === (6))){
var inst_25012 = (state_25071[(13)]);
var inst_25021 = f.call(null,inst_25012);
var inst_25022 = cljs.core.seq.call(null,inst_25021);
var inst_25023 = inst_25022;
var inst_25024 = null;
var inst_25025 = (0);
var inst_25026 = (0);
var state_25071__$1 = (function (){var statearr_25088 = state_25071;
(statearr_25088[(9)] = inst_25023);

(statearr_25088[(10)] = inst_25024);

(statearr_25088[(11)] = inst_25025);

(statearr_25088[(12)] = inst_25026);

return statearr_25088;
})();
var statearr_25089_25121 = state_25071__$1;
(statearr_25089_25121[(2)] = null);

(statearr_25089_25121[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25072 === (17))){
var inst_25037 = (state_25071[(7)]);
var inst_25041 = cljs.core.chunk_first.call(null,inst_25037);
var inst_25042 = cljs.core.chunk_rest.call(null,inst_25037);
var inst_25043 = cljs.core.count.call(null,inst_25041);
var inst_25023 = inst_25042;
var inst_25024 = inst_25041;
var inst_25025 = inst_25043;
var inst_25026 = (0);
var state_25071__$1 = (function (){var statearr_25090 = state_25071;
(statearr_25090[(9)] = inst_25023);

(statearr_25090[(10)] = inst_25024);

(statearr_25090[(11)] = inst_25025);

(statearr_25090[(12)] = inst_25026);

return statearr_25090;
})();
var statearr_25091_25122 = state_25071__$1;
(statearr_25091_25122[(2)] = null);

(statearr_25091_25122[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25072 === (3))){
var inst_25069 = (state_25071[(2)]);
var state_25071__$1 = state_25071;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25071__$1,inst_25069);
} else {
if((state_val_25072 === (12))){
var inst_25057 = (state_25071[(2)]);
var state_25071__$1 = state_25071;
var statearr_25092_25123 = state_25071__$1;
(statearr_25092_25123[(2)] = inst_25057);

(statearr_25092_25123[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25072 === (2))){
var state_25071__$1 = state_25071;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25071__$1,(4),in$);
} else {
if((state_val_25072 === (23))){
var inst_25065 = (state_25071[(2)]);
var state_25071__$1 = state_25071;
var statearr_25093_25124 = state_25071__$1;
(statearr_25093_25124[(2)] = inst_25065);

(statearr_25093_25124[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25072 === (19))){
var inst_25052 = (state_25071[(2)]);
var state_25071__$1 = state_25071;
var statearr_25094_25125 = state_25071__$1;
(statearr_25094_25125[(2)] = inst_25052);

(statearr_25094_25125[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25072 === (11))){
var inst_25023 = (state_25071[(9)]);
var inst_25037 = (state_25071[(7)]);
var inst_25037__$1 = cljs.core.seq.call(null,inst_25023);
var state_25071__$1 = (function (){var statearr_25095 = state_25071;
(statearr_25095[(7)] = inst_25037__$1);

return statearr_25095;
})();
if(inst_25037__$1){
var statearr_25096_25126 = state_25071__$1;
(statearr_25096_25126[(1)] = (14));

} else {
var statearr_25097_25127 = state_25071__$1;
(statearr_25097_25127[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25072 === (9))){
var inst_25059 = (state_25071[(2)]);
var inst_25060 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_25071__$1 = (function (){var statearr_25098 = state_25071;
(statearr_25098[(15)] = inst_25059);

return statearr_25098;
})();
if(cljs.core.truth_(inst_25060)){
var statearr_25099_25128 = state_25071__$1;
(statearr_25099_25128[(1)] = (21));

} else {
var statearr_25100_25129 = state_25071__$1;
(statearr_25100_25129[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25072 === (5))){
var inst_25015 = cljs.core.async.close_BANG_.call(null,out);
var state_25071__$1 = state_25071;
var statearr_25101_25130 = state_25071__$1;
(statearr_25101_25130[(2)] = inst_25015);

(statearr_25101_25130[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25072 === (14))){
var inst_25037 = (state_25071[(7)]);
var inst_25039 = cljs.core.chunked_seq_QMARK_.call(null,inst_25037);
var state_25071__$1 = state_25071;
if(inst_25039){
var statearr_25102_25131 = state_25071__$1;
(statearr_25102_25131[(1)] = (17));

} else {
var statearr_25103_25132 = state_25071__$1;
(statearr_25103_25132[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25072 === (16))){
var inst_25055 = (state_25071[(2)]);
var state_25071__$1 = state_25071;
var statearr_25104_25133 = state_25071__$1;
(statearr_25104_25133[(2)] = inst_25055);

(statearr_25104_25133[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25072 === (10))){
var inst_25024 = (state_25071[(10)]);
var inst_25026 = (state_25071[(12)]);
var inst_25031 = cljs.core._nth.call(null,inst_25024,inst_25026);
var state_25071__$1 = state_25071;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25071__$1,(13),out,inst_25031);
} else {
if((state_val_25072 === (18))){
var inst_25037 = (state_25071[(7)]);
var inst_25046 = cljs.core.first.call(null,inst_25037);
var state_25071__$1 = state_25071;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25071__$1,(20),out,inst_25046);
} else {
if((state_val_25072 === (8))){
var inst_25026 = (state_25071[(12)]);
var inst_25025 = (state_25071[(11)]);
var inst_25028 = (inst_25026 < inst_25025);
var inst_25029 = inst_25028;
var state_25071__$1 = state_25071;
if(cljs.core.truth_(inst_25029)){
var statearr_25105_25134 = state_25071__$1;
(statearr_25105_25134[(1)] = (10));

} else {
var statearr_25106_25135 = state_25071__$1;
(statearr_25106_25135[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__21468__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__21468__auto____0 = (function (){
var statearr_25107 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25107[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__21468__auto__);

(statearr_25107[(1)] = (1));

return statearr_25107;
});
var cljs$core$async$mapcat_STAR__$_state_machine__21468__auto____1 = (function (state_25071){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_25071);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e25108){var ex__21471__auto__ = e25108;
var statearr_25109_25136 = state_25071;
(statearr_25109_25136[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_25071[(4)]))){
var statearr_25110_25137 = state_25071;
(statearr_25110_25137[(1)] = cljs.core.first.call(null,(state_25071[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25138 = state_25071;
state_25071 = G__25138;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__21468__auto__ = function(state_25071){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__21468__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__21468__auto____1.call(this,state_25071);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__21468__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__21468__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__21468__auto__;
})()
})();
var state__21594__auto__ = (function (){var statearr_25111 = f__21593__auto__.call(null);
(statearr_25111[(6)] = c__21592__auto__);

return statearr_25111;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
}));

return c__21592__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__25140 = arguments.length;
switch (G__25140) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__25143 = arguments.length;
switch (G__25143) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__25146 = arguments.length;
switch (G__25146) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__21592__auto___25194 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = (function (state_25170){
var state_val_25171 = (state_25170[(1)]);
if((state_val_25171 === (7))){
var inst_25165 = (state_25170[(2)]);
var state_25170__$1 = state_25170;
var statearr_25172_25195 = state_25170__$1;
(statearr_25172_25195[(2)] = inst_25165);

(statearr_25172_25195[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25171 === (1))){
var inst_25147 = null;
var state_25170__$1 = (function (){var statearr_25173 = state_25170;
(statearr_25173[(7)] = inst_25147);

return statearr_25173;
})();
var statearr_25174_25196 = state_25170__$1;
(statearr_25174_25196[(2)] = null);

(statearr_25174_25196[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25171 === (4))){
var inst_25150 = (state_25170[(8)]);
var inst_25150__$1 = (state_25170[(2)]);
var inst_25151 = (inst_25150__$1 == null);
var inst_25152 = cljs.core.not.call(null,inst_25151);
var state_25170__$1 = (function (){var statearr_25175 = state_25170;
(statearr_25175[(8)] = inst_25150__$1);

return statearr_25175;
})();
if(inst_25152){
var statearr_25176_25197 = state_25170__$1;
(statearr_25176_25197[(1)] = (5));

} else {
var statearr_25177_25198 = state_25170__$1;
(statearr_25177_25198[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25171 === (6))){
var state_25170__$1 = state_25170;
var statearr_25178_25199 = state_25170__$1;
(statearr_25178_25199[(2)] = null);

(statearr_25178_25199[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25171 === (3))){
var inst_25167 = (state_25170[(2)]);
var inst_25168 = cljs.core.async.close_BANG_.call(null,out);
var state_25170__$1 = (function (){var statearr_25179 = state_25170;
(statearr_25179[(9)] = inst_25167);

return statearr_25179;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25170__$1,inst_25168);
} else {
if((state_val_25171 === (2))){
var state_25170__$1 = state_25170;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25170__$1,(4),ch);
} else {
if((state_val_25171 === (11))){
var inst_25150 = (state_25170[(8)]);
var inst_25159 = (state_25170[(2)]);
var inst_25147 = inst_25150;
var state_25170__$1 = (function (){var statearr_25180 = state_25170;
(statearr_25180[(10)] = inst_25159);

(statearr_25180[(7)] = inst_25147);

return statearr_25180;
})();
var statearr_25181_25200 = state_25170__$1;
(statearr_25181_25200[(2)] = null);

(statearr_25181_25200[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25171 === (9))){
var inst_25150 = (state_25170[(8)]);
var state_25170__$1 = state_25170;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25170__$1,(11),out,inst_25150);
} else {
if((state_val_25171 === (5))){
var inst_25150 = (state_25170[(8)]);
var inst_25147 = (state_25170[(7)]);
var inst_25154 = cljs.core._EQ_.call(null,inst_25150,inst_25147);
var state_25170__$1 = state_25170;
if(inst_25154){
var statearr_25183_25201 = state_25170__$1;
(statearr_25183_25201[(1)] = (8));

} else {
var statearr_25184_25202 = state_25170__$1;
(statearr_25184_25202[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25171 === (10))){
var inst_25162 = (state_25170[(2)]);
var state_25170__$1 = state_25170;
var statearr_25185_25203 = state_25170__$1;
(statearr_25185_25203[(2)] = inst_25162);

(statearr_25185_25203[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25171 === (8))){
var inst_25147 = (state_25170[(7)]);
var tmp25182 = inst_25147;
var inst_25147__$1 = tmp25182;
var state_25170__$1 = (function (){var statearr_25186 = state_25170;
(statearr_25186[(7)] = inst_25147__$1);

return statearr_25186;
})();
var statearr_25187_25204 = state_25170__$1;
(statearr_25187_25204[(2)] = null);

(statearr_25187_25204[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__21468__auto__ = null;
var cljs$core$async$state_machine__21468__auto____0 = (function (){
var statearr_25188 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_25188[(0)] = cljs$core$async$state_machine__21468__auto__);

(statearr_25188[(1)] = (1));

return statearr_25188;
});
var cljs$core$async$state_machine__21468__auto____1 = (function (state_25170){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_25170);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e25189){var ex__21471__auto__ = e25189;
var statearr_25190_25205 = state_25170;
(statearr_25190_25205[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_25170[(4)]))){
var statearr_25191_25206 = state_25170;
(statearr_25191_25206[(1)] = cljs.core.first.call(null,(state_25170[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25207 = state_25170;
state_25170 = G__25207;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
cljs$core$async$state_machine__21468__auto__ = function(state_25170){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__21468__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__21468__auto____1.call(this,state_25170);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__21468__auto____0;
cljs$core$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__21468__auto____1;
return cljs$core$async$state_machine__21468__auto__;
})()
})();
var state__21594__auto__ = (function (){var statearr_25192 = f__21593__auto__.call(null);
(statearr_25192[(6)] = c__21592__auto___25194);

return statearr_25192;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__25209 = arguments.length;
switch (G__25209) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__21592__auto___25276 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = (function (state_25247){
var state_val_25248 = (state_25247[(1)]);
if((state_val_25248 === (7))){
var inst_25243 = (state_25247[(2)]);
var state_25247__$1 = state_25247;
var statearr_25249_25277 = state_25247__$1;
(statearr_25249_25277[(2)] = inst_25243);

(statearr_25249_25277[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25248 === (1))){
var inst_25210 = (new Array(n));
var inst_25211 = inst_25210;
var inst_25212 = (0);
var state_25247__$1 = (function (){var statearr_25250 = state_25247;
(statearr_25250[(7)] = inst_25211);

(statearr_25250[(8)] = inst_25212);

return statearr_25250;
})();
var statearr_25251_25278 = state_25247__$1;
(statearr_25251_25278[(2)] = null);

(statearr_25251_25278[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25248 === (4))){
var inst_25215 = (state_25247[(9)]);
var inst_25215__$1 = (state_25247[(2)]);
var inst_25216 = (inst_25215__$1 == null);
var inst_25217 = cljs.core.not.call(null,inst_25216);
var state_25247__$1 = (function (){var statearr_25252 = state_25247;
(statearr_25252[(9)] = inst_25215__$1);

return statearr_25252;
})();
if(inst_25217){
var statearr_25253_25279 = state_25247__$1;
(statearr_25253_25279[(1)] = (5));

} else {
var statearr_25254_25280 = state_25247__$1;
(statearr_25254_25280[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25248 === (15))){
var inst_25237 = (state_25247[(2)]);
var state_25247__$1 = state_25247;
var statearr_25255_25281 = state_25247__$1;
(statearr_25255_25281[(2)] = inst_25237);

(statearr_25255_25281[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25248 === (13))){
var state_25247__$1 = state_25247;
var statearr_25256_25282 = state_25247__$1;
(statearr_25256_25282[(2)] = null);

(statearr_25256_25282[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25248 === (6))){
var inst_25212 = (state_25247[(8)]);
var inst_25233 = (inst_25212 > (0));
var state_25247__$1 = state_25247;
if(cljs.core.truth_(inst_25233)){
var statearr_25257_25283 = state_25247__$1;
(statearr_25257_25283[(1)] = (12));

} else {
var statearr_25258_25284 = state_25247__$1;
(statearr_25258_25284[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25248 === (3))){
var inst_25245 = (state_25247[(2)]);
var state_25247__$1 = state_25247;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25247__$1,inst_25245);
} else {
if((state_val_25248 === (12))){
var inst_25211 = (state_25247[(7)]);
var inst_25235 = cljs.core.vec.call(null,inst_25211);
var state_25247__$1 = state_25247;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25247__$1,(15),out,inst_25235);
} else {
if((state_val_25248 === (2))){
var state_25247__$1 = state_25247;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25247__$1,(4),ch);
} else {
if((state_val_25248 === (11))){
var inst_25227 = (state_25247[(2)]);
var inst_25228 = (new Array(n));
var inst_25211 = inst_25228;
var inst_25212 = (0);
var state_25247__$1 = (function (){var statearr_25259 = state_25247;
(statearr_25259[(10)] = inst_25227);

(statearr_25259[(7)] = inst_25211);

(statearr_25259[(8)] = inst_25212);

return statearr_25259;
})();
var statearr_25260_25285 = state_25247__$1;
(statearr_25260_25285[(2)] = null);

(statearr_25260_25285[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25248 === (9))){
var inst_25211 = (state_25247[(7)]);
var inst_25225 = cljs.core.vec.call(null,inst_25211);
var state_25247__$1 = state_25247;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25247__$1,(11),out,inst_25225);
} else {
if((state_val_25248 === (5))){
var inst_25211 = (state_25247[(7)]);
var inst_25212 = (state_25247[(8)]);
var inst_25215 = (state_25247[(9)]);
var inst_25220 = (state_25247[(11)]);
var inst_25219 = (inst_25211[inst_25212] = inst_25215);
var inst_25220__$1 = (inst_25212 + (1));
var inst_25221 = (inst_25220__$1 < n);
var state_25247__$1 = (function (){var statearr_25261 = state_25247;
(statearr_25261[(12)] = inst_25219);

(statearr_25261[(11)] = inst_25220__$1);

return statearr_25261;
})();
if(cljs.core.truth_(inst_25221)){
var statearr_25262_25286 = state_25247__$1;
(statearr_25262_25286[(1)] = (8));

} else {
var statearr_25263_25287 = state_25247__$1;
(statearr_25263_25287[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25248 === (14))){
var inst_25240 = (state_25247[(2)]);
var inst_25241 = cljs.core.async.close_BANG_.call(null,out);
var state_25247__$1 = (function (){var statearr_25265 = state_25247;
(statearr_25265[(13)] = inst_25240);

return statearr_25265;
})();
var statearr_25266_25288 = state_25247__$1;
(statearr_25266_25288[(2)] = inst_25241);

(statearr_25266_25288[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25248 === (10))){
var inst_25231 = (state_25247[(2)]);
var state_25247__$1 = state_25247;
var statearr_25267_25289 = state_25247__$1;
(statearr_25267_25289[(2)] = inst_25231);

(statearr_25267_25289[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25248 === (8))){
var inst_25211 = (state_25247[(7)]);
var inst_25220 = (state_25247[(11)]);
var tmp25264 = inst_25211;
var inst_25211__$1 = tmp25264;
var inst_25212 = inst_25220;
var state_25247__$1 = (function (){var statearr_25268 = state_25247;
(statearr_25268[(7)] = inst_25211__$1);

(statearr_25268[(8)] = inst_25212);

return statearr_25268;
})();
var statearr_25269_25290 = state_25247__$1;
(statearr_25269_25290[(2)] = null);

(statearr_25269_25290[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__21468__auto__ = null;
var cljs$core$async$state_machine__21468__auto____0 = (function (){
var statearr_25270 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25270[(0)] = cljs$core$async$state_machine__21468__auto__);

(statearr_25270[(1)] = (1));

return statearr_25270;
});
var cljs$core$async$state_machine__21468__auto____1 = (function (state_25247){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_25247);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e25271){var ex__21471__auto__ = e25271;
var statearr_25272_25291 = state_25247;
(statearr_25272_25291[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_25247[(4)]))){
var statearr_25273_25292 = state_25247;
(statearr_25273_25292[(1)] = cljs.core.first.call(null,(state_25247[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25293 = state_25247;
state_25247 = G__25293;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
cljs$core$async$state_machine__21468__auto__ = function(state_25247){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__21468__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__21468__auto____1.call(this,state_25247);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__21468__auto____0;
cljs$core$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__21468__auto____1;
return cljs$core$async$state_machine__21468__auto__;
})()
})();
var state__21594__auto__ = (function (){var statearr_25274 = f__21593__auto__.call(null);
(statearr_25274[(6)] = c__21592__auto___25276);

return statearr_25274;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__25295 = arguments.length;
switch (G__25295) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__21592__auto___25373 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__21593__auto__ = (function (){var switch__21467__auto__ = (function (state_25340){
var state_val_25341 = (state_25340[(1)]);
if((state_val_25341 === (7))){
var inst_25336 = (state_25340[(2)]);
var state_25340__$1 = state_25340;
var statearr_25342_25374 = state_25340__$1;
(statearr_25342_25374[(2)] = inst_25336);

(statearr_25342_25374[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25341 === (1))){
var inst_25296 = [];
var inst_25297 = inst_25296;
var inst_25298 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_25340__$1 = (function (){var statearr_25343 = state_25340;
(statearr_25343[(7)] = inst_25297);

(statearr_25343[(8)] = inst_25298);

return statearr_25343;
})();
var statearr_25344_25375 = state_25340__$1;
(statearr_25344_25375[(2)] = null);

(statearr_25344_25375[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25341 === (4))){
var inst_25301 = (state_25340[(9)]);
var inst_25301__$1 = (state_25340[(2)]);
var inst_25302 = (inst_25301__$1 == null);
var inst_25303 = cljs.core.not.call(null,inst_25302);
var state_25340__$1 = (function (){var statearr_25345 = state_25340;
(statearr_25345[(9)] = inst_25301__$1);

return statearr_25345;
})();
if(inst_25303){
var statearr_25346_25376 = state_25340__$1;
(statearr_25346_25376[(1)] = (5));

} else {
var statearr_25347_25377 = state_25340__$1;
(statearr_25347_25377[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25341 === (15))){
var inst_25297 = (state_25340[(7)]);
var inst_25328 = cljs.core.vec.call(null,inst_25297);
var state_25340__$1 = state_25340;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25340__$1,(18),out,inst_25328);
} else {
if((state_val_25341 === (13))){
var inst_25323 = (state_25340[(2)]);
var state_25340__$1 = state_25340;
var statearr_25348_25378 = state_25340__$1;
(statearr_25348_25378[(2)] = inst_25323);

(statearr_25348_25378[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25341 === (6))){
var inst_25297 = (state_25340[(7)]);
var inst_25325 = inst_25297.length;
var inst_25326 = (inst_25325 > (0));
var state_25340__$1 = state_25340;
if(cljs.core.truth_(inst_25326)){
var statearr_25349_25379 = state_25340__$1;
(statearr_25349_25379[(1)] = (15));

} else {
var statearr_25350_25380 = state_25340__$1;
(statearr_25350_25380[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25341 === (17))){
var inst_25333 = (state_25340[(2)]);
var inst_25334 = cljs.core.async.close_BANG_.call(null,out);
var state_25340__$1 = (function (){var statearr_25351 = state_25340;
(statearr_25351[(10)] = inst_25333);

return statearr_25351;
})();
var statearr_25352_25381 = state_25340__$1;
(statearr_25352_25381[(2)] = inst_25334);

(statearr_25352_25381[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25341 === (3))){
var inst_25338 = (state_25340[(2)]);
var state_25340__$1 = state_25340;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25340__$1,inst_25338);
} else {
if((state_val_25341 === (12))){
var inst_25297 = (state_25340[(7)]);
var inst_25316 = cljs.core.vec.call(null,inst_25297);
var state_25340__$1 = state_25340;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25340__$1,(14),out,inst_25316);
} else {
if((state_val_25341 === (2))){
var state_25340__$1 = state_25340;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25340__$1,(4),ch);
} else {
if((state_val_25341 === (11))){
var inst_25297 = (state_25340[(7)]);
var inst_25301 = (state_25340[(9)]);
var inst_25305 = (state_25340[(11)]);
var inst_25313 = inst_25297.push(inst_25301);
var tmp25353 = inst_25297;
var inst_25297__$1 = tmp25353;
var inst_25298 = inst_25305;
var state_25340__$1 = (function (){var statearr_25354 = state_25340;
(statearr_25354[(12)] = inst_25313);

(statearr_25354[(7)] = inst_25297__$1);

(statearr_25354[(8)] = inst_25298);

return statearr_25354;
})();
var statearr_25355_25382 = state_25340__$1;
(statearr_25355_25382[(2)] = null);

(statearr_25355_25382[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25341 === (9))){
var inst_25298 = (state_25340[(8)]);
var inst_25309 = cljs.core.keyword_identical_QMARK_.call(null,inst_25298,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_25340__$1 = state_25340;
var statearr_25356_25383 = state_25340__$1;
(statearr_25356_25383[(2)] = inst_25309);

(statearr_25356_25383[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25341 === (5))){
var inst_25301 = (state_25340[(9)]);
var inst_25305 = (state_25340[(11)]);
var inst_25298 = (state_25340[(8)]);
var inst_25306 = (state_25340[(13)]);
var inst_25305__$1 = f.call(null,inst_25301);
var inst_25306__$1 = cljs.core._EQ_.call(null,inst_25305__$1,inst_25298);
var state_25340__$1 = (function (){var statearr_25357 = state_25340;
(statearr_25357[(11)] = inst_25305__$1);

(statearr_25357[(13)] = inst_25306__$1);

return statearr_25357;
})();
if(inst_25306__$1){
var statearr_25358_25384 = state_25340__$1;
(statearr_25358_25384[(1)] = (8));

} else {
var statearr_25359_25385 = state_25340__$1;
(statearr_25359_25385[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25341 === (14))){
var inst_25301 = (state_25340[(9)]);
var inst_25305 = (state_25340[(11)]);
var inst_25318 = (state_25340[(2)]);
var inst_25319 = [];
var inst_25320 = inst_25319.push(inst_25301);
var inst_25297 = inst_25319;
var inst_25298 = inst_25305;
var state_25340__$1 = (function (){var statearr_25360 = state_25340;
(statearr_25360[(14)] = inst_25318);

(statearr_25360[(15)] = inst_25320);

(statearr_25360[(7)] = inst_25297);

(statearr_25360[(8)] = inst_25298);

return statearr_25360;
})();
var statearr_25361_25386 = state_25340__$1;
(statearr_25361_25386[(2)] = null);

(statearr_25361_25386[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25341 === (16))){
var state_25340__$1 = state_25340;
var statearr_25362_25387 = state_25340__$1;
(statearr_25362_25387[(2)] = null);

(statearr_25362_25387[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25341 === (10))){
var inst_25311 = (state_25340[(2)]);
var state_25340__$1 = state_25340;
if(cljs.core.truth_(inst_25311)){
var statearr_25363_25388 = state_25340__$1;
(statearr_25363_25388[(1)] = (11));

} else {
var statearr_25364_25389 = state_25340__$1;
(statearr_25364_25389[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25341 === (18))){
var inst_25330 = (state_25340[(2)]);
var state_25340__$1 = state_25340;
var statearr_25365_25390 = state_25340__$1;
(statearr_25365_25390[(2)] = inst_25330);

(statearr_25365_25390[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25341 === (8))){
var inst_25306 = (state_25340[(13)]);
var state_25340__$1 = state_25340;
var statearr_25366_25391 = state_25340__$1;
(statearr_25366_25391[(2)] = inst_25306);

(statearr_25366_25391[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__21468__auto__ = null;
var cljs$core$async$state_machine__21468__auto____0 = (function (){
var statearr_25367 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25367[(0)] = cljs$core$async$state_machine__21468__auto__);

(statearr_25367[(1)] = (1));

return statearr_25367;
});
var cljs$core$async$state_machine__21468__auto____1 = (function (state_25340){
while(true){
var ret_value__21469__auto__ = (function (){try{while(true){
var result__21470__auto__ = switch__21467__auto__.call(null,state_25340);
if(cljs.core.keyword_identical_QMARK_.call(null,result__21470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__21470__auto__;
}
break;
}
}catch (e25368){var ex__21471__auto__ = e25368;
var statearr_25369_25392 = state_25340;
(statearr_25369_25392[(2)] = ex__21471__auto__);


if(cljs.core.seq.call(null,(state_25340[(4)]))){
var statearr_25370_25393 = state_25340;
(statearr_25370_25393[(1)] = cljs.core.first.call(null,(state_25340[(4)])));

} else {
throw ex__21471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__21469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25394 = state_25340;
state_25340 = G__25394;
continue;
} else {
return ret_value__21469__auto__;
}
break;
}
});
cljs$core$async$state_machine__21468__auto__ = function(state_25340){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__21468__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__21468__auto____1.call(this,state_25340);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__21468__auto____0;
cljs$core$async$state_machine__21468__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__21468__auto____1;
return cljs$core$async$state_machine__21468__auto__;
})()
})();
var state__21594__auto__ = (function (){var statearr_25371 = f__21593__auto__.call(null);
(statearr_25371[(6)] = c__21592__auto___25373);

return statearr_25371;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__21594__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=async.js.map
