goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = true;

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_36225 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (shadow.dom._to_dom[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null, this$));
} else {
var m__5349__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null, this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_36225(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_36231 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (shadow.dom._to_svg[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null, this$));
} else {
var m__5349__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null, this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_36231(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__34523 = coll;
var G__34524 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__34523,G__34524) : shadow.dom.lazy_native_coll_seq.call(null, G__34523,G__34524));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__5002__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null, );
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__34587 = arguments.length;
switch (G__34587) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__34595 = arguments.length;
switch (G__34595) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__34605 = arguments.length;
switch (G__34605) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__34615 = arguments.length;
switch (G__34615) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__34621 = arguments.length;
switch (G__34621) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__34625 = arguments.length;
switch (G__34625) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__5002__auto__ = (!((typeof document !== 'undefined')));
if(or__5002__auto__){
return or__5002__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null, e,el));
}));
}catch (e34639){if((e34639 instanceof Object)){
var e = e34639;
return console.log("didnt support attachEvent",el,e);
} else {
throw e34639;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__5002__auto__ = (!((typeof document !== 'undefined')));
if(or__5002__auto__){
return or__5002__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__34640 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__34641 = null;
var count__34642 = (0);
var i__34643 = (0);
while(true){
if((i__34643 < count__34642)){
var el = chunk__34641.cljs$core$IIndexed$_nth$arity$2(null, i__34643);
var handler_36295__$1 = ((function (seq__34640,chunk__34641,count__34642,i__34643,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null, e,el));
});})(seq__34640,chunk__34641,count__34642,i__34643,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_36295__$1);


var G__36296 = seq__34640;
var G__36297 = chunk__34641;
var G__36298 = count__34642;
var G__36299 = (i__34643 + (1));
seq__34640 = G__36296;
chunk__34641 = G__36297;
count__34642 = G__36298;
i__34643 = G__36299;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__34640);
if(temp__5823__auto__){
var seq__34640__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34640__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__34640__$1);
var G__36300 = cljs.core.chunk_rest(seq__34640__$1);
var G__36301 = c__5525__auto__;
var G__36302 = cljs.core.count(c__5525__auto__);
var G__36303 = (0);
seq__34640 = G__36300;
chunk__34641 = G__36301;
count__34642 = G__36302;
i__34643 = G__36303;
continue;
} else {
var el = cljs.core.first(seq__34640__$1);
var handler_36304__$1 = ((function (seq__34640,chunk__34641,count__34642,i__34643,el,seq__34640__$1,temp__5823__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null, e,el));
});})(seq__34640,chunk__34641,count__34642,i__34643,el,seq__34640__$1,temp__5823__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_36304__$1);


var G__36305 = cljs.core.next(seq__34640__$1);
var G__36306 = null;
var G__36307 = (0);
var G__36308 = (0);
seq__34640 = G__36305;
chunk__34641 = G__36306;
count__34642 = G__36307;
i__34643 = G__36308;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__34662 = arguments.length;
switch (G__34662) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null, e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__34679 = cljs.core.seq(events);
var chunk__34680 = null;
var count__34681 = (0);
var i__34682 = (0);
while(true){
if((i__34682 < count__34681)){
var vec__34713 = chunk__34680.cljs$core$IIndexed$_nth$arity$2(null, i__34682);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34713,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34713,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__36319 = seq__34679;
var G__36320 = chunk__34680;
var G__36321 = count__34681;
var G__36322 = (i__34682 + (1));
seq__34679 = G__36319;
chunk__34680 = G__36320;
count__34681 = G__36321;
i__34682 = G__36322;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__34679);
if(temp__5823__auto__){
var seq__34679__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34679__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__34679__$1);
var G__36325 = cljs.core.chunk_rest(seq__34679__$1);
var G__36326 = c__5525__auto__;
var G__36327 = cljs.core.count(c__5525__auto__);
var G__36328 = (0);
seq__34679 = G__36325;
chunk__34680 = G__36326;
count__34681 = G__36327;
i__34682 = G__36328;
continue;
} else {
var vec__34718 = cljs.core.first(seq__34679__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34718,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34718,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__36332 = cljs.core.next(seq__34679__$1);
var G__36333 = null;
var G__36334 = (0);
var G__36335 = (0);
seq__34679 = G__36332;
chunk__34680 = G__36333;
count__34681 = G__36334;
i__34682 = G__36335;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__34757 = cljs.core.seq(styles);
var chunk__34758 = null;
var count__34759 = (0);
var i__34760 = (0);
while(true){
if((i__34760 < count__34759)){
var vec__34856 = chunk__34758.cljs$core$IIndexed$_nth$arity$2(null, i__34760);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34856,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34856,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__36338 = seq__34757;
var G__36339 = chunk__34758;
var G__36340 = count__34759;
var G__36341 = (i__34760 + (1));
seq__34757 = G__36338;
chunk__34758 = G__36339;
count__34759 = G__36340;
i__34760 = G__36341;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__34757);
if(temp__5823__auto__){
var seq__34757__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34757__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__34757__$1);
var G__36342 = cljs.core.chunk_rest(seq__34757__$1);
var G__36343 = c__5525__auto__;
var G__36344 = cljs.core.count(c__5525__auto__);
var G__36345 = (0);
seq__34757 = G__36342;
chunk__34758 = G__36343;
count__34759 = G__36344;
i__34760 = G__36345;
continue;
} else {
var vec__34868 = cljs.core.first(seq__34757__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34868,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34868,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__36347 = cljs.core.next(seq__34757__$1);
var G__36348 = null;
var G__36349 = (0);
var G__36350 = (0);
seq__34757 = G__36347;
chunk__34758 = G__36348;
count__34759 = G__36349;
i__34760 = G__36350;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__34913_36353 = key;
var G__34913_36354__$1 = (((G__34913_36353 instanceof cljs.core.Keyword))?G__34913_36353.fqn:null);
switch (G__34913_36354__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_36360 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__5002__auto__ = goog.string.startsWith(ks_36360,"data-");
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return goog.string.startsWith(ks_36360,"aria-");
}
})())){
el.setAttribute(ks_36360,value);
} else {
(el[ks_36360] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__35011){
var map__35012 = p__35011;
var map__35012__$1 = cljs.core.__destructure_map(map__35012);
var props = map__35012__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35012__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__35014 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35014,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35014,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35014,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__35019 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__35019,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__35019;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__35032 = arguments.length;
switch (G__35032) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5823__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5823__auto__)){
var n = temp__5823__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5823__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5823__auto__)){
var n = temp__5823__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__35085){
var vec__35087 = p__35085;
var seq__35088 = cljs.core.seq(vec__35087);
var first__35089 = cljs.core.first(seq__35088);
var seq__35088__$1 = cljs.core.next(seq__35088);
var nn = first__35089;
var first__35089__$1 = cljs.core.first(seq__35088__$1);
var seq__35088__$2 = cljs.core.next(seq__35088__$1);
var np = first__35089__$1;
var nc = seq__35088__$2;
var node = vec__35087;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__35125 = nn;
var G__35126 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__35125,G__35126) : create_fn.call(null, G__35125,G__35126));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null, nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__35131 = nn;
var G__35132 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__35131,G__35132) : create_fn.call(null, G__35131,G__35132));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__35194 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35194,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35194,(1),null);
var seq__35197_36383 = cljs.core.seq(node_children);
var chunk__35198_36384 = null;
var count__35199_36385 = (0);
var i__35200_36386 = (0);
while(true){
if((i__35200_36386 < count__35199_36385)){
var child_struct_36387 = chunk__35198_36384.cljs$core$IIndexed$_nth$arity$2(null, i__35200_36386);
var children_36388 = shadow.dom.dom_node(child_struct_36387);
if(cljs.core.seq_QMARK_(children_36388)){
var seq__35276_36389 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_36388));
var chunk__35278_36390 = null;
var count__35279_36391 = (0);
var i__35280_36392 = (0);
while(true){
if((i__35280_36392 < count__35279_36391)){
var child_36393 = chunk__35278_36390.cljs$core$IIndexed$_nth$arity$2(null, i__35280_36392);
if(cljs.core.truth_(child_36393)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_36393);


var G__36394 = seq__35276_36389;
var G__36395 = chunk__35278_36390;
var G__36396 = count__35279_36391;
var G__36397 = (i__35280_36392 + (1));
seq__35276_36389 = G__36394;
chunk__35278_36390 = G__36395;
count__35279_36391 = G__36396;
i__35280_36392 = G__36397;
continue;
} else {
var G__36398 = seq__35276_36389;
var G__36399 = chunk__35278_36390;
var G__36400 = count__35279_36391;
var G__36401 = (i__35280_36392 + (1));
seq__35276_36389 = G__36398;
chunk__35278_36390 = G__36399;
count__35279_36391 = G__36400;
i__35280_36392 = G__36401;
continue;
}
} else {
var temp__5823__auto___36402 = cljs.core.seq(seq__35276_36389);
if(temp__5823__auto___36402){
var seq__35276_36403__$1 = temp__5823__auto___36402;
if(cljs.core.chunked_seq_QMARK_(seq__35276_36403__$1)){
var c__5525__auto___36404 = cljs.core.chunk_first(seq__35276_36403__$1);
var G__36405 = cljs.core.chunk_rest(seq__35276_36403__$1);
var G__36406 = c__5525__auto___36404;
var G__36407 = cljs.core.count(c__5525__auto___36404);
var G__36408 = (0);
seq__35276_36389 = G__36405;
chunk__35278_36390 = G__36406;
count__35279_36391 = G__36407;
i__35280_36392 = G__36408;
continue;
} else {
var child_36409 = cljs.core.first(seq__35276_36403__$1);
if(cljs.core.truth_(child_36409)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_36409);


var G__36412 = cljs.core.next(seq__35276_36403__$1);
var G__36413 = null;
var G__36414 = (0);
var G__36415 = (0);
seq__35276_36389 = G__36412;
chunk__35278_36390 = G__36413;
count__35279_36391 = G__36414;
i__35280_36392 = G__36415;
continue;
} else {
var G__36416 = cljs.core.next(seq__35276_36403__$1);
var G__36417 = null;
var G__36418 = (0);
var G__36419 = (0);
seq__35276_36389 = G__36416;
chunk__35278_36390 = G__36417;
count__35279_36391 = G__36418;
i__35280_36392 = G__36419;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_36388);
}


var G__36420 = seq__35197_36383;
var G__36421 = chunk__35198_36384;
var G__36422 = count__35199_36385;
var G__36423 = (i__35200_36386 + (1));
seq__35197_36383 = G__36420;
chunk__35198_36384 = G__36421;
count__35199_36385 = G__36422;
i__35200_36386 = G__36423;
continue;
} else {
var temp__5823__auto___36424 = cljs.core.seq(seq__35197_36383);
if(temp__5823__auto___36424){
var seq__35197_36425__$1 = temp__5823__auto___36424;
if(cljs.core.chunked_seq_QMARK_(seq__35197_36425__$1)){
var c__5525__auto___36428 = cljs.core.chunk_first(seq__35197_36425__$1);
var G__36429 = cljs.core.chunk_rest(seq__35197_36425__$1);
var G__36430 = c__5525__auto___36428;
var G__36431 = cljs.core.count(c__5525__auto___36428);
var G__36432 = (0);
seq__35197_36383 = G__36429;
chunk__35198_36384 = G__36430;
count__35199_36385 = G__36431;
i__35200_36386 = G__36432;
continue;
} else {
var child_struct_36433 = cljs.core.first(seq__35197_36425__$1);
var children_36434 = shadow.dom.dom_node(child_struct_36433);
if(cljs.core.seq_QMARK_(children_36434)){
var seq__35314_36435 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_36434));
var chunk__35316_36436 = null;
var count__35317_36437 = (0);
var i__35318_36438 = (0);
while(true){
if((i__35318_36438 < count__35317_36437)){
var child_36439 = chunk__35316_36436.cljs$core$IIndexed$_nth$arity$2(null, i__35318_36438);
if(cljs.core.truth_(child_36439)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_36439);


var G__36440 = seq__35314_36435;
var G__36441 = chunk__35316_36436;
var G__36442 = count__35317_36437;
var G__36443 = (i__35318_36438 + (1));
seq__35314_36435 = G__36440;
chunk__35316_36436 = G__36441;
count__35317_36437 = G__36442;
i__35318_36438 = G__36443;
continue;
} else {
var G__36444 = seq__35314_36435;
var G__36445 = chunk__35316_36436;
var G__36446 = count__35317_36437;
var G__36447 = (i__35318_36438 + (1));
seq__35314_36435 = G__36444;
chunk__35316_36436 = G__36445;
count__35317_36437 = G__36446;
i__35318_36438 = G__36447;
continue;
}
} else {
var temp__5823__auto___36449__$1 = cljs.core.seq(seq__35314_36435);
if(temp__5823__auto___36449__$1){
var seq__35314_36450__$1 = temp__5823__auto___36449__$1;
if(cljs.core.chunked_seq_QMARK_(seq__35314_36450__$1)){
var c__5525__auto___36451 = cljs.core.chunk_first(seq__35314_36450__$1);
var G__36452 = cljs.core.chunk_rest(seq__35314_36450__$1);
var G__36453 = c__5525__auto___36451;
var G__36454 = cljs.core.count(c__5525__auto___36451);
var G__36455 = (0);
seq__35314_36435 = G__36452;
chunk__35316_36436 = G__36453;
count__35317_36437 = G__36454;
i__35318_36438 = G__36455;
continue;
} else {
var child_36456 = cljs.core.first(seq__35314_36450__$1);
if(cljs.core.truth_(child_36456)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_36456);


var G__36457 = cljs.core.next(seq__35314_36450__$1);
var G__36458 = null;
var G__36459 = (0);
var G__36460 = (0);
seq__35314_36435 = G__36457;
chunk__35316_36436 = G__36458;
count__35317_36437 = G__36459;
i__35318_36438 = G__36460;
continue;
} else {
var G__36461 = cljs.core.next(seq__35314_36450__$1);
var G__36462 = null;
var G__36463 = (0);
var G__36464 = (0);
seq__35314_36435 = G__36461;
chunk__35316_36436 = G__36462;
count__35317_36437 = G__36463;
i__35318_36438 = G__36464;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_36434);
}


var G__36466 = cljs.core.next(seq__35197_36425__$1);
var G__36467 = null;
var G__36468 = (0);
var G__36469 = (0);
seq__35197_36383 = G__36466;
chunk__35198_36384 = G__36467;
count__35199_36385 = G__36468;
i__35200_36386 = G__36469;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__35378 = cljs.core.seq(node);
var chunk__35379 = null;
var count__35380 = (0);
var i__35381 = (0);
while(true){
if((i__35381 < count__35380)){
var n = chunk__35379.cljs$core$IIndexed$_nth$arity$2(null, i__35381);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null, n));


var G__36476 = seq__35378;
var G__36477 = chunk__35379;
var G__36478 = count__35380;
var G__36479 = (i__35381 + (1));
seq__35378 = G__36476;
chunk__35379 = G__36477;
count__35380 = G__36478;
i__35381 = G__36479;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__35378);
if(temp__5823__auto__){
var seq__35378__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__35378__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__35378__$1);
var G__36481 = cljs.core.chunk_rest(seq__35378__$1);
var G__36482 = c__5525__auto__;
var G__36483 = cljs.core.count(c__5525__auto__);
var G__36484 = (0);
seq__35378 = G__36481;
chunk__35379 = G__36482;
count__35380 = G__36483;
i__35381 = G__36484;
continue;
} else {
var n = cljs.core.first(seq__35378__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null, n));


var G__36486 = cljs.core.next(seq__35378__$1);
var G__36487 = null;
var G__36488 = (0);
var G__36489 = (0);
seq__35378 = G__36486;
chunk__35379 = G__36487;
count__35380 = G__36488;
i__35381 = G__36489;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__35423 = arguments.length;
switch (G__35423) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__35455 = arguments.length;
switch (G__35455) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__35511 = arguments.length;
switch (G__35511) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__5002__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__5732__auto__ = [];
var len__5726__auto___36504 = arguments.length;
var i__5727__auto___36505 = (0);
while(true){
if((i__5727__auto___36505 < len__5726__auto___36504)){
args__5732__auto__.push((arguments[i__5727__auto___36505]));

var G__36506 = (i__5727__auto___36505 + (1));
i__5727__auto___36505 = G__36506;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((0) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__5733__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__35602_36507 = cljs.core.seq(nodes);
var chunk__35603_36508 = null;
var count__35604_36509 = (0);
var i__35605_36510 = (0);
while(true){
if((i__35605_36510 < count__35604_36509)){
var node_36513 = chunk__35603_36508.cljs$core$IIndexed$_nth$arity$2(null, i__35605_36510);
fragment.appendChild(shadow.dom._to_dom(node_36513));


var G__36514 = seq__35602_36507;
var G__36515 = chunk__35603_36508;
var G__36516 = count__35604_36509;
var G__36517 = (i__35605_36510 + (1));
seq__35602_36507 = G__36514;
chunk__35603_36508 = G__36515;
count__35604_36509 = G__36516;
i__35605_36510 = G__36517;
continue;
} else {
var temp__5823__auto___36518 = cljs.core.seq(seq__35602_36507);
if(temp__5823__auto___36518){
var seq__35602_36519__$1 = temp__5823__auto___36518;
if(cljs.core.chunked_seq_QMARK_(seq__35602_36519__$1)){
var c__5525__auto___36520 = cljs.core.chunk_first(seq__35602_36519__$1);
var G__36521 = cljs.core.chunk_rest(seq__35602_36519__$1);
var G__36522 = c__5525__auto___36520;
var G__36523 = cljs.core.count(c__5525__auto___36520);
var G__36524 = (0);
seq__35602_36507 = G__36521;
chunk__35603_36508 = G__36522;
count__35604_36509 = G__36523;
i__35605_36510 = G__36524;
continue;
} else {
var node_36525 = cljs.core.first(seq__35602_36519__$1);
fragment.appendChild(shadow.dom._to_dom(node_36525));


var G__36526 = cljs.core.next(seq__35602_36519__$1);
var G__36527 = null;
var G__36528 = (0);
var G__36529 = (0);
seq__35602_36507 = G__36526;
chunk__35603_36508 = G__36527;
count__35604_36509 = G__36528;
i__35605_36510 = G__36529;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq35591){
var self__5712__auto__ = this;
return self__5712__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq35591));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__35638_36531 = cljs.core.seq(scripts);
var chunk__35639_36532 = null;
var count__35640_36533 = (0);
var i__35641_36534 = (0);
while(true){
if((i__35641_36534 < count__35640_36533)){
var vec__35670_36536 = chunk__35639_36532.cljs$core$IIndexed$_nth$arity$2(null, i__35641_36534);
var script_tag_36537 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35670_36536,(0),null);
var script_body_36538 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35670_36536,(1),null);
eval(script_body_36538);


var G__36539 = seq__35638_36531;
var G__36540 = chunk__35639_36532;
var G__36541 = count__35640_36533;
var G__36542 = (i__35641_36534 + (1));
seq__35638_36531 = G__36539;
chunk__35639_36532 = G__36540;
count__35640_36533 = G__36541;
i__35641_36534 = G__36542;
continue;
} else {
var temp__5823__auto___36545 = cljs.core.seq(seq__35638_36531);
if(temp__5823__auto___36545){
var seq__35638_36547__$1 = temp__5823__auto___36545;
if(cljs.core.chunked_seq_QMARK_(seq__35638_36547__$1)){
var c__5525__auto___36548 = cljs.core.chunk_first(seq__35638_36547__$1);
var G__36549 = cljs.core.chunk_rest(seq__35638_36547__$1);
var G__36550 = c__5525__auto___36548;
var G__36551 = cljs.core.count(c__5525__auto___36548);
var G__36552 = (0);
seq__35638_36531 = G__36549;
chunk__35639_36532 = G__36550;
count__35640_36533 = G__36551;
i__35641_36534 = G__36552;
continue;
} else {
var vec__35685_36553 = cljs.core.first(seq__35638_36547__$1);
var script_tag_36554 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35685_36553,(0),null);
var script_body_36555 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35685_36553,(1),null);
eval(script_body_36555);


var G__36556 = cljs.core.next(seq__35638_36547__$1);
var G__36557 = null;
var G__36558 = (0);
var G__36559 = (0);
seq__35638_36531 = G__36556;
chunk__35639_36532 = G__36557;
count__35640_36533 = G__36558;
i__35641_36534 = G__36559;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__35692){
var vec__35693 = p__35692;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35693,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35693,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__35750 = arguments.length;
switch (G__35750) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__35775 = cljs.core.seq(style_keys);
var chunk__35776 = null;
var count__35777 = (0);
var i__35778 = (0);
while(true){
if((i__35778 < count__35777)){
var it = chunk__35776.cljs$core$IIndexed$_nth$arity$2(null, i__35778);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__36562 = seq__35775;
var G__36563 = chunk__35776;
var G__36564 = count__35777;
var G__36565 = (i__35778 + (1));
seq__35775 = G__36562;
chunk__35776 = G__36563;
count__35777 = G__36564;
i__35778 = G__36565;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__35775);
if(temp__5823__auto__){
var seq__35775__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__35775__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__35775__$1);
var G__36566 = cljs.core.chunk_rest(seq__35775__$1);
var G__36567 = c__5525__auto__;
var G__36568 = cljs.core.count(c__5525__auto__);
var G__36569 = (0);
seq__35775 = G__36566;
chunk__35776 = G__36567;
count__35777 = G__36568;
i__35778 = G__36569;
continue;
} else {
var it = cljs.core.first(seq__35775__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__36570 = cljs.core.next(seq__35775__$1);
var G__36571 = null;
var G__36572 = (0);
var G__36573 = (0);
seq__35775 = G__36570;
chunk__35776 = G__36571;
count__35777 = G__36572;
i__35778 = G__36573;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5300__auto__,k__5301__auto__){
var self__ = this;
var this__5300__auto____$1 = this;
return this__5300__auto____$1.cljs$core$ILookup$_lookup$arity$3(null, k__5301__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5302__auto__,k35797,else__5303__auto__){
var self__ = this;
var this__5302__auto____$1 = this;
var G__35886 = k35797;
var G__35886__$1 = (((G__35886 instanceof cljs.core.Keyword))?G__35886.fqn:null);
switch (G__35886__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k35797,else__5303__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5320__auto__,f__5321__auto__,init__5322__auto__){
var self__ = this;
var this__5320__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5323__auto__,p__35916){
var vec__35917 = p__35916;
var k__5324__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35917,(0),null);
var v__5325__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35917,(1),null);
return (f__5321__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5321__auto__.cljs$core$IFn$_invoke$arity$3(ret__5323__auto__,k__5324__auto__,v__5325__auto__) : f__5321__auto__.call(null, ret__5323__auto__,k__5324__auto__,v__5325__auto__));
}),init__5322__auto__,this__5320__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5315__auto__,writer__5316__auto__,opts__5317__auto__){
var self__ = this;
var this__5315__auto____$1 = this;
var pr_pair__5318__auto__ = (function (keyval__5319__auto__){
return cljs.core.pr_sequential_writer(writer__5316__auto__,cljs.core.pr_writer,""," ","",opts__5317__auto__,keyval__5319__auto__);
});
return cljs.core.pr_sequential_writer(writer__5316__auto__,pr_pair__5318__auto__,"#shadow.dom.Coordinate{",", ","}",opts__5317__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__35796){
var self__ = this;
var G__35796__$1 = this;
return (new cljs.core.RecordIter((0),G__35796__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5298__auto__){
var self__ = this;
var this__5298__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5295__auto__){
var self__ = this;
var this__5295__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5304__auto__){
var self__ = this;
var this__5304__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5296__auto__){
var self__ = this;
var this__5296__auto____$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = (function (coll__5297__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__5297__auto__));
})(this__5296__auto____$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this35798,other35799){
var self__ = this;
var this35798__$1 = this;
return (((!((other35799 == null)))) && ((((this35798__$1.constructor === other35799.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35798__$1.x,other35799.x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35798__$1.y,other35799.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35798__$1.__extmap,other35799.__extmap)))))))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5310__auto__,k__5311__auto__){
var self__ = this;
var this__5310__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__5311__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5310__auto____$1),self__.__meta),k__5311__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5311__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5307__auto__,k35797){
var self__ = this;
var this__5307__auto____$1 = this;
var G__35928 = k35797;
var G__35928__$1 = (((G__35928 instanceof cljs.core.Keyword))?G__35928.fqn:null);
switch (G__35928__$1) {
case "x":
case "y":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k35797);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5308__auto__,k__5309__auto__,G__35796){
var self__ = this;
var this__5308__auto____$1 = this;
var pred__35929 = cljs.core.keyword_identical_QMARK_;
var expr__35930 = k__5309__auto__;
if(cljs.core.truth_((pred__35929.cljs$core$IFn$_invoke$arity$2 ? pred__35929.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__35930) : pred__35929.call(null, new cljs.core.Keyword(null,"x","x",2099068185),expr__35930)))){
return (new shadow.dom.Coordinate(G__35796,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__35929.cljs$core$IFn$_invoke$arity$2 ? pred__35929.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__35930) : pred__35929.call(null, new cljs.core.Keyword(null,"y","y",-1757859776),expr__35930)))){
return (new shadow.dom.Coordinate(self__.x,G__35796,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5309__auto__,G__35796),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5313__auto__){
var self__ = this;
var this__5313__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5299__auto__,G__35796){
var self__ = this;
var this__5299__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__35796,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5305__auto__,entry__5306__auto__){
var self__ = this;
var this__5305__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5306__auto__)){
return this__5305__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null, cljs.core._nth(entry__5306__auto__,(0)),cljs.core._nth(entry__5306__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5305__auto____$1,entry__5306__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__5346__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__5346__auto__,writer__5347__auto__){
return cljs.core._write(writer__5347__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__35845){
var extmap__5342__auto__ = (function (){var G__35934 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__35845,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__35845)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__35934);
} else {
return G__35934;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__35845),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__35845),null,cljs.core.not_empty(extmap__5342__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5300__auto__,k__5301__auto__){
var self__ = this;
var this__5300__auto____$1 = this;
return this__5300__auto____$1.cljs$core$ILookup$_lookup$arity$3(null, k__5301__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5302__auto__,k35945,else__5303__auto__){
var self__ = this;
var this__5302__auto____$1 = this;
var G__35959 = k35945;
var G__35959__$1 = (((G__35959 instanceof cljs.core.Keyword))?G__35959.fqn:null);
switch (G__35959__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k35945,else__5303__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5320__auto__,f__5321__auto__,init__5322__auto__){
var self__ = this;
var this__5320__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5323__auto__,p__35963){
var vec__35964 = p__35963;
var k__5324__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35964,(0),null);
var v__5325__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35964,(1),null);
return (f__5321__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5321__auto__.cljs$core$IFn$_invoke$arity$3(ret__5323__auto__,k__5324__auto__,v__5325__auto__) : f__5321__auto__.call(null, ret__5323__auto__,k__5324__auto__,v__5325__auto__));
}),init__5322__auto__,this__5320__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5315__auto__,writer__5316__auto__,opts__5317__auto__){
var self__ = this;
var this__5315__auto____$1 = this;
var pr_pair__5318__auto__ = (function (keyval__5319__auto__){
return cljs.core.pr_sequential_writer(writer__5316__auto__,cljs.core.pr_writer,""," ","",opts__5317__auto__,keyval__5319__auto__);
});
return cljs.core.pr_sequential_writer(writer__5316__auto__,pr_pair__5318__auto__,"#shadow.dom.Size{",", ","}",opts__5317__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__35944){
var self__ = this;
var G__35944__$1 = this;
return (new cljs.core.RecordIter((0),G__35944__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5298__auto__){
var self__ = this;
var this__5298__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5295__auto__){
var self__ = this;
var this__5295__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5304__auto__){
var self__ = this;
var this__5304__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5296__auto__){
var self__ = this;
var this__5296__auto____$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = (function (coll__5297__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__5297__auto__));
})(this__5296__auto____$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this35946,other35947){
var self__ = this;
var this35946__$1 = this;
return (((!((other35947 == null)))) && ((((this35946__$1.constructor === other35947.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35946__$1.w,other35947.w)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35946__$1.h,other35947.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35946__$1.__extmap,other35947.__extmap)))))))));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5310__auto__,k__5311__auto__){
var self__ = this;
var this__5310__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__5311__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5310__auto____$1),self__.__meta),k__5311__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5311__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5307__auto__,k35945){
var self__ = this;
var this__5307__auto____$1 = this;
var G__35987 = k35945;
var G__35987__$1 = (((G__35987 instanceof cljs.core.Keyword))?G__35987.fqn:null);
switch (G__35987__$1) {
case "w":
case "h":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k35945);

}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5308__auto__,k__5309__auto__,G__35944){
var self__ = this;
var this__5308__auto____$1 = this;
var pred__35991 = cljs.core.keyword_identical_QMARK_;
var expr__35992 = k__5309__auto__;
if(cljs.core.truth_((pred__35991.cljs$core$IFn$_invoke$arity$2 ? pred__35991.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__35992) : pred__35991.call(null, new cljs.core.Keyword(null,"w","w",354169001),expr__35992)))){
return (new shadow.dom.Size(G__35944,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__35991.cljs$core$IFn$_invoke$arity$2 ? pred__35991.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__35992) : pred__35991.call(null, new cljs.core.Keyword(null,"h","h",1109658740),expr__35992)))){
return (new shadow.dom.Size(self__.w,G__35944,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5309__auto__,G__35944),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5313__auto__){
var self__ = this;
var this__5313__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5299__auto__,G__35944){
var self__ = this;
var this__5299__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__35944,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5305__auto__,entry__5306__auto__){
var self__ = this;
var this__5305__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5306__auto__)){
return this__5305__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null, cljs.core._nth(entry__5306__auto__,(0)),cljs.core._nth(entry__5306__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5305__auto____$1,entry__5306__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__5346__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__5346__auto__,writer__5347__auto__){
return cljs.core._write(writer__5347__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__35948){
var extmap__5342__auto__ = (function (){var G__36008 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__35948,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__35948)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__36008);
} else {
return G__36008;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__35948),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__35948),null,cljs.core.not_empty(extmap__5342__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__5590__auto__ = opts;
var l__5591__auto__ = a__5590__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__5591__auto__)){
var G__36655 = (i + (1));
var G__36656 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__36655;
ret = G__36656;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__36045){
var vec__36046 = p__36045;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36046,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36046,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__36054 = arguments.length;
switch (G__36054) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5821__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5821__auto__)){
var child = temp__5821__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__36672 = ps;
var G__36673 = (i + (1));
el__$1 = G__36672;
i = G__36673;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null, parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__36094 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36094,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36094,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36094,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__36100_36686 = cljs.core.seq(props);
var chunk__36102_36687 = null;
var count__36103_36688 = (0);
var i__36104_36689 = (0);
while(true){
if((i__36104_36689 < count__36103_36688)){
var vec__36112_36690 = chunk__36102_36687.cljs$core$IIndexed$_nth$arity$2(null, i__36104_36689);
var k_36691 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36112_36690,(0),null);
var v_36692 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36112_36690,(1),null);
el.setAttributeNS((function (){var temp__5823__auto__ = cljs.core.namespace(k_36691);
if(cljs.core.truth_(temp__5823__auto__)){
var ns = temp__5823__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_36691),v_36692);


var G__36694 = seq__36100_36686;
var G__36695 = chunk__36102_36687;
var G__36696 = count__36103_36688;
var G__36697 = (i__36104_36689 + (1));
seq__36100_36686 = G__36694;
chunk__36102_36687 = G__36695;
count__36103_36688 = G__36696;
i__36104_36689 = G__36697;
continue;
} else {
var temp__5823__auto___36698 = cljs.core.seq(seq__36100_36686);
if(temp__5823__auto___36698){
var seq__36100_36699__$1 = temp__5823__auto___36698;
if(cljs.core.chunked_seq_QMARK_(seq__36100_36699__$1)){
var c__5525__auto___36700 = cljs.core.chunk_first(seq__36100_36699__$1);
var G__36701 = cljs.core.chunk_rest(seq__36100_36699__$1);
var G__36702 = c__5525__auto___36700;
var G__36703 = cljs.core.count(c__5525__auto___36700);
var G__36704 = (0);
seq__36100_36686 = G__36701;
chunk__36102_36687 = G__36702;
count__36103_36688 = G__36703;
i__36104_36689 = G__36704;
continue;
} else {
var vec__36118_36705 = cljs.core.first(seq__36100_36699__$1);
var k_36706 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36118_36705,(0),null);
var v_36707 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36118_36705,(1),null);
el.setAttributeNS((function (){var temp__5823__auto____$1 = cljs.core.namespace(k_36706);
if(cljs.core.truth_(temp__5823__auto____$1)){
var ns = temp__5823__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_36706),v_36707);


var G__36709 = cljs.core.next(seq__36100_36699__$1);
var G__36710 = null;
var G__36711 = (0);
var G__36712 = (0);
seq__36100_36686 = G__36709;
chunk__36102_36687 = G__36710;
count__36103_36688 = G__36711;
i__36104_36689 = G__36712;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null, );
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__36126 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36126,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36126,(1),null);
var seq__36129_36724 = cljs.core.seq(node_children);
var chunk__36131_36725 = null;
var count__36132_36726 = (0);
var i__36133_36727 = (0);
while(true){
if((i__36133_36727 < count__36132_36726)){
var child_struct_36730 = chunk__36131_36725.cljs$core$IIndexed$_nth$arity$2(null, i__36133_36727);
if((!((child_struct_36730 == null)))){
if(typeof child_struct_36730 === 'string'){
var text_36732 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_36732),child_struct_36730].join(''));
} else {
var children_36796 = shadow.dom.svg_node(child_struct_36730);
if(cljs.core.seq_QMARK_(children_36796)){
var seq__36161_36797 = cljs.core.seq(children_36796);
var chunk__36163_36798 = null;
var count__36164_36799 = (0);
var i__36165_36800 = (0);
while(true){
if((i__36165_36800 < count__36164_36799)){
var child_36802 = chunk__36163_36798.cljs$core$IIndexed$_nth$arity$2(null, i__36165_36800);
if(cljs.core.truth_(child_36802)){
node.appendChild(child_36802);


var G__36803 = seq__36161_36797;
var G__36804 = chunk__36163_36798;
var G__36805 = count__36164_36799;
var G__36806 = (i__36165_36800 + (1));
seq__36161_36797 = G__36803;
chunk__36163_36798 = G__36804;
count__36164_36799 = G__36805;
i__36165_36800 = G__36806;
continue;
} else {
var G__36809 = seq__36161_36797;
var G__36810 = chunk__36163_36798;
var G__36811 = count__36164_36799;
var G__36812 = (i__36165_36800 + (1));
seq__36161_36797 = G__36809;
chunk__36163_36798 = G__36810;
count__36164_36799 = G__36811;
i__36165_36800 = G__36812;
continue;
}
} else {
var temp__5823__auto___36813 = cljs.core.seq(seq__36161_36797);
if(temp__5823__auto___36813){
var seq__36161_36818__$1 = temp__5823__auto___36813;
if(cljs.core.chunked_seq_QMARK_(seq__36161_36818__$1)){
var c__5525__auto___36819 = cljs.core.chunk_first(seq__36161_36818__$1);
var G__36820 = cljs.core.chunk_rest(seq__36161_36818__$1);
var G__36821 = c__5525__auto___36819;
var G__36822 = cljs.core.count(c__5525__auto___36819);
var G__36823 = (0);
seq__36161_36797 = G__36820;
chunk__36163_36798 = G__36821;
count__36164_36799 = G__36822;
i__36165_36800 = G__36823;
continue;
} else {
var child_36824 = cljs.core.first(seq__36161_36818__$1);
if(cljs.core.truth_(child_36824)){
node.appendChild(child_36824);


var G__36826 = cljs.core.next(seq__36161_36818__$1);
var G__36827 = null;
var G__36828 = (0);
var G__36829 = (0);
seq__36161_36797 = G__36826;
chunk__36163_36798 = G__36827;
count__36164_36799 = G__36828;
i__36165_36800 = G__36829;
continue;
} else {
var G__36830 = cljs.core.next(seq__36161_36818__$1);
var G__36831 = null;
var G__36832 = (0);
var G__36833 = (0);
seq__36161_36797 = G__36830;
chunk__36163_36798 = G__36831;
count__36164_36799 = G__36832;
i__36165_36800 = G__36833;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_36796);
}
}


var G__36840 = seq__36129_36724;
var G__36841 = chunk__36131_36725;
var G__36842 = count__36132_36726;
var G__36843 = (i__36133_36727 + (1));
seq__36129_36724 = G__36840;
chunk__36131_36725 = G__36841;
count__36132_36726 = G__36842;
i__36133_36727 = G__36843;
continue;
} else {
var G__36844 = seq__36129_36724;
var G__36845 = chunk__36131_36725;
var G__36846 = count__36132_36726;
var G__36847 = (i__36133_36727 + (1));
seq__36129_36724 = G__36844;
chunk__36131_36725 = G__36845;
count__36132_36726 = G__36846;
i__36133_36727 = G__36847;
continue;
}
} else {
var temp__5823__auto___36848 = cljs.core.seq(seq__36129_36724);
if(temp__5823__auto___36848){
var seq__36129_36853__$1 = temp__5823__auto___36848;
if(cljs.core.chunked_seq_QMARK_(seq__36129_36853__$1)){
var c__5525__auto___36854 = cljs.core.chunk_first(seq__36129_36853__$1);
var G__36855 = cljs.core.chunk_rest(seq__36129_36853__$1);
var G__36856 = c__5525__auto___36854;
var G__36857 = cljs.core.count(c__5525__auto___36854);
var G__36858 = (0);
seq__36129_36724 = G__36855;
chunk__36131_36725 = G__36856;
count__36132_36726 = G__36857;
i__36133_36727 = G__36858;
continue;
} else {
var child_struct_36859 = cljs.core.first(seq__36129_36853__$1);
if((!((child_struct_36859 == null)))){
if(typeof child_struct_36859 === 'string'){
var text_36861 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_36861),child_struct_36859].join(''));
} else {
var children_36862 = shadow.dom.svg_node(child_struct_36859);
if(cljs.core.seq_QMARK_(children_36862)){
var seq__36175_36863 = cljs.core.seq(children_36862);
var chunk__36177_36864 = null;
var count__36178_36865 = (0);
var i__36179_36866 = (0);
while(true){
if((i__36179_36866 < count__36178_36865)){
var child_36867 = chunk__36177_36864.cljs$core$IIndexed$_nth$arity$2(null, i__36179_36866);
if(cljs.core.truth_(child_36867)){
node.appendChild(child_36867);


var G__36868 = seq__36175_36863;
var G__36869 = chunk__36177_36864;
var G__36870 = count__36178_36865;
var G__36871 = (i__36179_36866 + (1));
seq__36175_36863 = G__36868;
chunk__36177_36864 = G__36869;
count__36178_36865 = G__36870;
i__36179_36866 = G__36871;
continue;
} else {
var G__36873 = seq__36175_36863;
var G__36874 = chunk__36177_36864;
var G__36875 = count__36178_36865;
var G__36876 = (i__36179_36866 + (1));
seq__36175_36863 = G__36873;
chunk__36177_36864 = G__36874;
count__36178_36865 = G__36875;
i__36179_36866 = G__36876;
continue;
}
} else {
var temp__5823__auto___36878__$1 = cljs.core.seq(seq__36175_36863);
if(temp__5823__auto___36878__$1){
var seq__36175_36886__$1 = temp__5823__auto___36878__$1;
if(cljs.core.chunked_seq_QMARK_(seq__36175_36886__$1)){
var c__5525__auto___36890 = cljs.core.chunk_first(seq__36175_36886__$1);
var G__36891 = cljs.core.chunk_rest(seq__36175_36886__$1);
var G__36892 = c__5525__auto___36890;
var G__36893 = cljs.core.count(c__5525__auto___36890);
var G__36894 = (0);
seq__36175_36863 = G__36891;
chunk__36177_36864 = G__36892;
count__36178_36865 = G__36893;
i__36179_36866 = G__36894;
continue;
} else {
var child_36895 = cljs.core.first(seq__36175_36886__$1);
if(cljs.core.truth_(child_36895)){
node.appendChild(child_36895);


var G__36896 = cljs.core.next(seq__36175_36886__$1);
var G__36897 = null;
var G__36898 = (0);
var G__36899 = (0);
seq__36175_36863 = G__36896;
chunk__36177_36864 = G__36897;
count__36178_36865 = G__36898;
i__36179_36866 = G__36899;
continue;
} else {
var G__36900 = cljs.core.next(seq__36175_36886__$1);
var G__36901 = null;
var G__36902 = (0);
var G__36903 = (0);
seq__36175_36863 = G__36900;
chunk__36177_36864 = G__36901;
count__36178_36865 = G__36902;
i__36179_36866 = G__36903;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_36862);
}
}


var G__36904 = cljs.core.next(seq__36129_36853__$1);
var G__36905 = null;
var G__36906 = (0);
var G__36907 = (0);
seq__36129_36724 = G__36904;
chunk__36131_36725 = G__36905;
count__36132_36726 = G__36906;
i__36133_36727 = G__36907;
continue;
} else {
var G__36909 = cljs.core.next(seq__36129_36853__$1);
var G__36910 = null;
var G__36911 = (0);
var G__36912 = (0);
seq__36129_36724 = G__36909;
chunk__36131_36725 = G__36910;
count__36132_36726 = G__36911;
i__36133_36727 = G__36912;
continue;
}
}
} else {
}
}
break;
}

return node;
});
(shadow.dom.SVGElement["string"] = true);

(shadow.dom._to_svg["string"] = (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

(shadow.dom.SVGElement["null"] = true);

(shadow.dom._to_svg["null"] = (function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__5732__auto__ = [];
var len__5726__auto___36928 = arguments.length;
var i__5727__auto___36929 = (0);
while(true){
if((i__5727__auto___36929 < len__5726__auto___36928)){
args__5732__auto__.push((arguments[i__5727__auto___36929]));

var G__36930 = (i__5727__auto___36929 + (1));
i__5727__auto___36929 = G__36930;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq36197){
var G__36198 = cljs.core.first(seq36197);
var seq36197__$1 = cljs.core.next(seq36197);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__36198,seq36197__$1);
}));


//# sourceMappingURL=shadow.dom.js.map
