goog.provide('kabel.client');
if(kabel.util.on_node_QMARK_()){
console.log("Patching global env for: W3C WebSocket API.");

(WebSocket = require("websocket").w3cwebsocket);
} else {
}
/**
 * Connects to url. Puts [in out] channels on return channel when ready.
 * Only supports websocket at the moment, but is supposed to dispatch on
 *   protocol of url. read-opts is ignored on cljs for now, use the
 *   platform-wide reader setup.
 */
kabel.client.client_connect_BANG_ = (function kabel$client$client_connect_BANG_(var_args){
var G__38605 = arguments.length;
switch (G__38605) {
case 3:
return kabel.client.client_connect_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return kabel.client.client_connect_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(kabel.client.client_connect_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (S,url,peer_id){
return kabel.client.client_connect_BANG_.cljs$core$IFn$_invoke$arity$5(S,url,peer_id,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY));
}));

(kabel.client.client_connect_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (S,url,peer_id,read_handlers,write_handlers){
var channel = (new goog.net.WebSocket(false));
var in_buffer = cljs.core.async.buffer((1024));
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(in_buffer);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var opener = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var host = (new goog.Uri(url.replace("ws","http"))).getDomain();
(function (){
var __run_fn_form = null;
var __kind = new cljs.core.Keyword(null,"log","log",-1595516004);
var __ns = "kabel.client";
var __id = null;
var __level = new cljs.core.Keyword(null,"info","info",-317069002);
if(cljs.core.truth_((function (){var sf = taoensso.telemere.impl._STAR_rt_call_filter_STAR_;
if(cljs.core.truth_(sf)){
return (sf.cljs$core$IFn$_invoke$arity$4 ? sf.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"log","log",-1595516004),__ns,__id,__level) : sf.call(null, new cljs.core.Keyword(null,"log","log",-1595516004),__ns,__id,__level));
} else {
return true;
}
})())){
var __inst = (new Date());
var __thread = null;
var __root0 = taoensso.telemere.impl._STAR_trace_root_STAR_;
var __otel_context1 = null;
var __uid = null;
var __root1 = __root0;
var __run_result = null;
var signal__37491__auto__ = (new cljs.core.Delay((function (){

var signal__37482__auto__ = (new taoensso.telemere.impl.Signal((1),__inst,__uid,__ns,null,null,__kind,__id,__level,taoensso.telemere._STAR_ctx_STAR_,taoensso.telemere.impl._STAR_trace_parent_STAR_,__root1,null,null,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"connecting-to","connecting-to",-1991299113),new cljs.core.Keyword(null,"url","url",276297046),url], null)], 0)),null,null,null,null,null,null,null,null));
var temp__5821__auto__ = taoensso.telemere._STAR_xfn_STAR_;
if(cljs.core.truth_(temp__5821__auto__)){
var xfn__37483__auto__ = temp__5821__auto__;
return (xfn__37483__auto__.cljs$core$IFn$_invoke$arity$1 ? xfn__37483__auto__.cljs$core$IFn$_invoke$arity$1(signal__37482__auto__) : xfn__37483__auto__.call(null, signal__37482__auto__));
} else {
return signal__37482__auto__;
}
}),null));
taoensso.telemere.impl.dispatch_signal_BANG_((new taoensso.telemere.impl.WrappedSignal(__kind,__ns,__id,__level,signal__37491__auto__)));

if(cljs.core.truth_(__run_result)){
return (__run_result.cljs$core$IFn$_invoke$arity$1 ? __run_result.cljs$core$IFn$_invoke$arity$1(signal__37491__auto__) : __run_result.call(null, signal__37491__auto__));
} else {
return true;
}
} else {
return null;
}
})();


var G__38606_38683 = channel;
goog.events.listen(G__38606_38683,goog.net.WebSocket.EventType.MESSAGE,(function (evt){
var v = evt.message;
try{if((cljs.core.count(in_buffer) > (100))){
channel.close();

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["incoming buffer for ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)," too full:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(in_buffer))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"count","count",2139924085),cljs.core.count(in_buffer)], null));
} else {
}

if(typeof v === 'string'){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(in$,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("kabel","serialization","kabel/serialization",437520425),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword("kabel","payload","kabel/payload",251259889),v], null));
} else {
return kabel.binary.from_binary(v,(function (p1__38603_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(in$,((cljs.core.map_QMARK_(p1__38603_SHARP_))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__38603_SHARP_,new cljs.core.Keyword("kabel","host","kabel/host",-1456877872),host):p1__38603_SHARP_));
}));
}
}catch (e38607){if((e38607 instanceof Error)){
var e = e38607;
(function (){
var __run_fn_form = null;
var __kind = new cljs.core.Keyword(null,"log","log",-1595516004);
var __ns = "kabel.client";
var __id = null;
var __level = new cljs.core.Keyword(null,"error","error",-978969032);
if(cljs.core.truth_((function (){var sf = taoensso.telemere.impl._STAR_rt_call_filter_STAR_;
if(cljs.core.truth_(sf)){
return (sf.cljs$core$IFn$_invoke$arity$4 ? sf.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"log","log",-1595516004),__ns,__id,__level) : sf.call(null, new cljs.core.Keyword(null,"log","log",-1595516004),__ns,__id,__level));
} else {
return true;
}
})())){
var __inst = (new Date());
var __thread = null;
var __root0 = taoensso.telemere.impl._STAR_trace_root_STAR_;
var __otel_context1 = null;
var __uid = null;
var __root1 = __root0;
var __run_result = null;
var signal__37491__auto__ = (new cljs.core.Delay((function (){

var signal__37482__auto__ = (new taoensso.telemere.impl.Signal((1),__inst,__uid,__ns,null,null,__kind,__id,__level,taoensso.telemere._STAR_ctx_STAR_,taoensso.telemere.impl._STAR_trace_parent_STAR_,__root1,null,null,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"cannot-read-message","cannot-read-message",-543619229),new cljs.core.Keyword(null,"error","error",-978969032),e], null)], 0)),null,null,null,null,null,null,null,null));
var temp__5821__auto__ = taoensso.telemere._STAR_xfn_STAR_;
if(cljs.core.truth_(temp__5821__auto__)){
var xfn__37483__auto__ = temp__5821__auto__;
return (xfn__37483__auto__.cljs$core$IFn$_invoke$arity$1 ? xfn__37483__auto__.cljs$core$IFn$_invoke$arity$1(signal__37482__auto__) : xfn__37483__auto__.call(null, signal__37482__auto__));
} else {
return signal__37482__auto__;
}
}),null));
taoensso.telemere.impl.dispatch_signal_BANG_((new taoensso.telemere.impl.WrappedSignal(__kind,__ns,__id,__level,signal__37491__auto__)));

if(cljs.core.truth_(__run_result)){
return (__run_result.cljs$core$IFn$_invoke$arity$1 ? __run_result.cljs$core$IFn$_invoke$arity$1(signal__37491__auto__) : __run_result.call(null, signal__37491__auto__));
} else {
return true;
}
} else {
return null;
}
})();


channel.close();

cljs.core.async.close_BANG_(opener);

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(superv.async._error(S),e);
} else {
throw e38607;

}
}}));

goog.events.listen(G__38606_38683,goog.net.WebSocket.EventType.CLOSED,(function (evt){
var e = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection closed!",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"event","event",301435442),evt], null));
(function (){
var __run_fn_form = null;
var __kind = new cljs.core.Keyword(null,"log","log",-1595516004);
var __ns = "kabel.client";
var __id = null;
var __level = new cljs.core.Keyword(null,"info","info",-317069002);
if(cljs.core.truth_((function (){var sf = taoensso.telemere.impl._STAR_rt_call_filter_STAR_;
if(cljs.core.truth_(sf)){
return (sf.cljs$core$IFn$_invoke$arity$4 ? sf.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"log","log",-1595516004),__ns,__id,__level) : sf.call(null, new cljs.core.Keyword(null,"log","log",-1595516004),__ns,__id,__level));
} else {
return true;
}
})())){
var __inst = (new Date());
var __thread = null;
var __root0 = taoensso.telemere.impl._STAR_trace_root_STAR_;
var __otel_context1 = null;
var __uid = null;
var __root1 = __root0;
var __run_result = null;
var signal__37491__auto__ = (new cljs.core.Delay((function (){

var signal__37482__auto__ = (new taoensso.telemere.impl.Signal((1),__inst,__uid,__ns,null,null,__kind,__id,__level,taoensso.telemere._STAR_ctx_STAR_,taoensso.telemere.impl._STAR_trace_parent_STAR_,__root1,null,null,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"connection-closed","connection-closed",579733998),new cljs.core.Keyword(null,"url","url",276297046),url], null)], 0)),null,null,null,null,null,null,null,null));
var temp__5821__auto__ = taoensso.telemere._STAR_xfn_STAR_;
if(cljs.core.truth_(temp__5821__auto__)){
var xfn__37483__auto__ = temp__5821__auto__;
return (xfn__37483__auto__.cljs$core$IFn$_invoke$arity$1 ? xfn__37483__auto__.cljs$core$IFn$_invoke$arity$1(signal__37482__auto__) : xfn__37483__auto__.call(null, signal__37482__auto__));
} else {
return signal__37482__auto__;
}
}),null));
taoensso.telemere.impl.dispatch_signal_BANG_((new taoensso.telemere.impl.WrappedSignal(__kind,__ns,__id,__level,signal__37491__auto__)));

if(cljs.core.truth_(__run_result)){
return (__run_result.cljs$core$IFn$_invoke$arity$1 ? __run_result.cljs$core$IFn$_invoke$arity$1(signal__37491__auto__) : __run_result.call(null, signal__37491__auto__));
} else {
return true;
}
} else {
return null;
}
})();


cljs.core.async.close_BANG_(in$);

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(superv.async._error(S),e);

try{cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(opener,e);
}catch (e38608){if((e38608 instanceof Object)){
var e_38684__$1 = e38608;
} else {
throw e38608;

}
}
channel.close();

return cljs.core.async.close_BANG_(opener);
}));

goog.events.listen(G__38606_38683,goog.net.WebSocket.EventType.OPENED,(function (evt){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(opener,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [in$,out], null));

return cljs.core.async.close_BANG_(opener);
}));

goog.events.listen(G__38606_38683,goog.net.WebSocket.EventType.ERROR,(function (evt){
var e = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection error!",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"event","event",301435442),evt], null));
(function (){
var __run_fn_form = null;
var __kind = new cljs.core.Keyword(null,"log","log",-1595516004);
var __ns = "kabel.client";
var __id = null;
var __level = new cljs.core.Keyword(null,"error","error",-978969032);
if(cljs.core.truth_((function (){var sf = taoensso.telemere.impl._STAR_rt_call_filter_STAR_;
if(cljs.core.truth_(sf)){
return (sf.cljs$core$IFn$_invoke$arity$4 ? sf.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"log","log",-1595516004),__ns,__id,__level) : sf.call(null, new cljs.core.Keyword(null,"log","log",-1595516004),__ns,__id,__level));
} else {
return true;
}
})())){
var __inst = (new Date());
var __thread = null;
var __root0 = taoensso.telemere.impl._STAR_trace_root_STAR_;
var __otel_context1 = null;
var __uid = null;
var __root1 = __root0;
var __run_result = null;
var signal__37491__auto__ = (new cljs.core.Delay((function (){

var signal__37482__auto__ = (new taoensso.telemere.impl.Signal((1),__inst,__uid,__ns,null,null,__kind,__id,__level,taoensso.telemere._STAR_ctx_STAR_,taoensso.telemere.impl._STAR_trace_parent_STAR_,__root1,null,null,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"websocket-error","websocket-error",941100166),new cljs.core.Keyword(null,"url","url",276297046),url], null)], 0)),null,null,null,null,null,null,null,null));
var temp__5821__auto__ = taoensso.telemere._STAR_xfn_STAR_;
if(cljs.core.truth_(temp__5821__auto__)){
var xfn__37483__auto__ = temp__5821__auto__;
return (xfn__37483__auto__.cljs$core$IFn$_invoke$arity$1 ? xfn__37483__auto__.cljs$core$IFn$_invoke$arity$1(signal__37482__auto__) : xfn__37483__auto__.call(null, signal__37482__auto__));
} else {
return signal__37482__auto__;
}
}),null));
taoensso.telemere.impl.dispatch_signal_BANG_((new taoensso.telemere.impl.WrappedSignal(__kind,__ns,__id,__level,signal__37491__auto__)));

if(cljs.core.truth_(__run_result)){
return (__run_result.cljs$core$IFn$_invoke$arity$1 ? __run_result.cljs$core$IFn$_invoke$arity$1(signal__37491__auto__) : __run_result.call(null, signal__37491__auto__));
} else {
return true;
}
} else {
return null;
}
})();


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(superv.async._error(S),e);

try{cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(opener,e);
}catch (e38609){if((e38609 instanceof Object)){
var e_38685__$1 = e38609;
} else {
throw e38609;

}
}
return cljs.core.async.close_BANG_(opener);
}));

try{
channel.open(url);
}catch (e38610){if((e38610 instanceof Object)){
var e_38686 = e38610;
var e_38687__$1 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection failed!",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"connection-failed","connection-failed",-1910345930),new cljs.core.Keyword(null,"error","error",-978969032),e_38686], null));
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(superv.async._error(S),e_38687__$1);

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(opener,e_38687__$1);

cljs.core.async.close_BANG_(opener);
} else {
throw e38610;

}
}

(function kabel$client$sender(){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(out,(function (m){
if(cljs.core.truth_(m)){
var c__28177__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28178__auto__ = (function (){var switch__28013__auto__ = (function (state_38651){
var state_val_38652 = (state_38651[(1)]);
if((state_val_38652 === (7))){
var inst_38619 = (state_38651[(2)]);
var state_38651__$1 = (function (){var statearr_38653 = state_38651;
(statearr_38653[(7)] = inst_38619);

return statearr_38653;
})();
var statearr_38654_38688 = state_38651__$1;
(statearr_38654_38688[(2)] = null);

(statearr_38654_38688[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38652 === (1))){
var state_38651__$1 = state_38651;
var statearr_38655_38689 = state_38651__$1;
(statearr_38655_38689[(2)] = null);

(statearr_38655_38689[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38652 === (4))){
var inst_38615 = (function (){return (function (){
var __run_fn_form = null;
var __kind = new cljs.core.Keyword(null,"log","log",-1595516004);
var __ns = "kabel.client";
var __id = null;
var __level = new cljs.core.Keyword(null,"debug","debug",-1608172596);
if(cljs.core.truth_((function (){var sf = taoensso.telemere.impl._STAR_rt_call_filter_STAR_;
if(cljs.core.truth_(sf)){
return (sf.cljs$core$IFn$_invoke$arity$4 ? sf.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"log","log",-1595516004),__ns,__id,__level) : sf.call(null, new cljs.core.Keyword(null,"log","log",-1595516004),__ns,__id,__level));
} else {
return true;
}
})())){
var __inst = (new Date());
var __thread = null;
var __root0 = taoensso.telemere.impl._STAR_trace_root_STAR_;
var __otel_context1 = null;
var __uid = null;
var __root1 = __root0;
var __run_result = null;
var signal__37491__auto__ = (new cljs.core.Delay((function (){

var signal__37482__auto__ = (new taoensso.telemere.impl.Signal((1),__inst,__uid,__ns,null,null,__kind,__id,__level,taoensso.telemere._STAR_ctx_STAR_,taoensso.telemere.impl._STAR_trace_parent_STAR_,__root1,null,null,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"output-blocked","output-blocked",-122311417),new cljs.core.Keyword(null,"buffered-amount","buffered-amount",-665650460),channel.getBufferedAmount()], null)], 0)),null,null,null,null,null,null,null,null));
var temp__5821__auto__ = taoensso.telemere._STAR_xfn_STAR_;
if(cljs.core.truth_(temp__5821__auto__)){
var xfn__37483__auto__ = temp__5821__auto__;
return (xfn__37483__auto__.cljs$core$IFn$_invoke$arity$1 ? xfn__37483__auto__.cljs$core$IFn$_invoke$arity$1(signal__37482__auto__) : xfn__37483__auto__.call(null, signal__37482__auto__));
} else {
return signal__37482__auto__;
}
}),null));
taoensso.telemere.impl.dispatch_signal_BANG_((new taoensso.telemere.impl.WrappedSignal(__kind,__ns,__id,__level,signal__37491__auto__)));

if(cljs.core.truth_(__run_result)){
return (__run_result.cljs$core$IFn$_invoke$arity$1 ? __run_result.cljs$core$IFn$_invoke$arity$1(signal__37491__auto__) : __run_result.call(null, signal__37491__auto__));
} else {
return true;
}
} else {
return null;
}
});
})();
var inst_38616 = inst_38615();
var inst_38617 = cljs.core.async.timeout((100));
var state_38651__$1 = (function (){var statearr_38656 = state_38651;
(statearr_38656[(8)] = inst_38616);

return statearr_38656;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38651__$1,(7),inst_38617);
} else {
if((state_val_38652 === (13))){
var inst_38642 = kabel.binary.to_binary(m);
var inst_38643 = channel.send(inst_38642);
var state_38651__$1 = state_38651;
var statearr_38657_38690 = state_38651__$1;
(statearr_38657_38690[(2)] = inst_38643);

(statearr_38657_38690[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38652 === (6))){
var inst_38623 = (state_38651[(2)]);
var state_38651__$1 = state_38651;
var statearr_38658_38691 = state_38651__$1;
(statearr_38658_38691[(2)] = inst_38623);

(statearr_38658_38691[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38652 === (3))){
var inst_38625 = (state_38651[(2)]);
var state_38651__$1 = (function (){var statearr_38659 = state_38651;
(statearr_38659[(9)] = inst_38625);

return statearr_38659;
})();
var statearr_38660_38692 = state_38651__$1;
(statearr_38660_38692[(2)] = null);

(statearr_38660_38692[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38652 === (12))){
var inst_38639 = new cljs.core.Keyword("kabel","payload","kabel/payload",251259889).cljs$core$IFn$_invoke$arity$1(m);
var inst_38640 = channel.send(inst_38639);
var state_38651__$1 = state_38651;
var statearr_38662_38693 = state_38651__$1;
(statearr_38662_38693[(2)] = inst_38640);

(statearr_38662_38693[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38652 === (2))){
var inst_38612 = channel.getBufferedAmount();
var inst_38613 = (inst_38612 > (0));
var state_38651__$1 = state_38651;
if(cljs.core.truth_(inst_38613)){
var statearr_38663_38694 = state_38651__$1;
(statearr_38663_38694[(1)] = (4));

} else {
var statearr_38664_38695 = state_38651__$1;
(statearr_38664_38695[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38652 === (11))){
var _ = (function (){var statearr_38665 = state_38651;
(statearr_38665[(4)] = cljs.core.rest((state_38651[(4)])));

return statearr_38665;
})();
var state_38651__$1 = state_38651;
var ex38661 = (state_38651__$1[(2)]);
var statearr_38666_38696 = state_38651__$1;
(statearr_38666_38696[(5)] = ex38661);


if((ex38661 instanceof Error)){
var statearr_38667_38697 = state_38651__$1;
(statearr_38667_38697[(1)] = (10));

(statearr_38667_38697[(5)] = null);

} else {
throw ex38661;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38652 === (9))){
var inst_38648 = (state_38651[(2)]);
var inst_38649 = kabel$client$sender();
var state_38651__$1 = (function (){var statearr_38668 = state_38651;
(statearr_38668[(10)] = inst_38648);

return statearr_38668;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_38651__$1,inst_38649);
} else {
if((state_val_38652 === (5))){
var state_38651__$1 = state_38651;
var statearr_38669_38698 = state_38651__$1;
(statearr_38669_38698[(2)] = null);

(statearr_38669_38698[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38652 === (14))){
var inst_38645 = (state_38651[(2)]);
var _ = (function (){var statearr_38670 = state_38651;
(statearr_38670[(4)] = cljs.core.rest((state_38651[(4)])));

return statearr_38670;
})();
var state_38651__$1 = state_38651;
var statearr_38671_38699 = state_38651__$1;
(statearr_38671_38699[(2)] = inst_38645);

(statearr_38671_38699[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38652 === (10))){
var inst_38626 = (state_38651[(2)]);
var inst_38627 = (function (){var e = inst_38626;
return (function (){
var __run_fn_form = null;
var __kind = new cljs.core.Keyword(null,"log","log",-1595516004);
var __ns = "kabel.client";
var __id = null;
var __level = new cljs.core.Keyword(null,"error","error",-978969032);
if(cljs.core.truth_((function (){var sf = taoensso.telemere.impl._STAR_rt_call_filter_STAR_;
if(cljs.core.truth_(sf)){
return (sf.cljs$core$IFn$_invoke$arity$4 ? sf.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"log","log",-1595516004),__ns,__id,__level) : sf.call(null, new cljs.core.Keyword(null,"log","log",-1595516004),__ns,__id,__level));
} else {
return true;
}
})())){
var __inst = (new Date());
var __thread = null;
var __root0 = taoensso.telemere.impl._STAR_trace_root_STAR_;
var __otel_context1 = null;
var __uid = null;
var __root1 = __root0;
var __run_result = null;
var signal__37491__auto__ = (new cljs.core.Delay((function (){

var signal__37482__auto__ = (new taoensso.telemere.impl.Signal((1),__inst,__uid,__ns,null,null,__kind,__id,__level,taoensso.telemere._STAR_ctx_STAR_,taoensso.telemere.impl._STAR_trace_parent_STAR_,__root1,null,null,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"cannot-send-transit-message","cannot-send-transit-message",-1612316504),new cljs.core.Keyword(null,"error","error",-978969032),e], null)], 0)),null,null,null,null,null,null,null,null));
var temp__5821__auto__ = taoensso.telemere._STAR_xfn_STAR_;
if(cljs.core.truth_(temp__5821__auto__)){
var xfn__37483__auto__ = temp__5821__auto__;
return (xfn__37483__auto__.cljs$core$IFn$_invoke$arity$1 ? xfn__37483__auto__.cljs$core$IFn$_invoke$arity$1(signal__37482__auto__) : xfn__37483__auto__.call(null, signal__37482__auto__));
} else {
return signal__37482__auto__;
}
}),null));
taoensso.telemere.impl.dispatch_signal_BANG_((new taoensso.telemere.impl.WrappedSignal(__kind,__ns,__id,__level,signal__37491__auto__)));

if(cljs.core.truth_(__run_result)){
return (__run_result.cljs$core$IFn$_invoke$arity$1 ? __run_result.cljs$core$IFn$_invoke$arity$1(signal__37491__auto__) : __run_result.call(null, signal__37491__auto__));
} else {
return true;
}
} else {
return null;
}
});
})();
var inst_38628 = inst_38627();
var inst_38629 = superv.async._error(S);
var inst_38630 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_38629,inst_38626);
var state_38651__$1 = (function (){var statearr_38672 = state_38651;
(statearr_38672[(11)] = inst_38628);

return statearr_38672;
})();
var statearr_38673_38700 = state_38651__$1;
(statearr_38673_38700[(2)] = inst_38630);

(statearr_38673_38700[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38652 === (8))){
var _ = (function (){var statearr_38674 = state_38651;
(statearr_38674[(4)] = cljs.core.cons((11),(state_38651[(4)])));

return statearr_38674;
})();
var inst_38636 = new cljs.core.Keyword("kabel","serialization","kabel/serialization",437520425).cljs$core$IFn$_invoke$arity$1(m);
var inst_38637 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_38636,new cljs.core.Keyword(null,"string","string",-1989541586));
var state_38651__$1 = state_38651;
if(inst_38637){
var statearr_38675_38701 = state_38651__$1;
(statearr_38675_38701[(1)] = (12));

} else {
var statearr_38676_38702 = state_38651__$1;
(statearr_38676_38702[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var kabel$client$sender_$_state_machine__28014__auto__ = null;
var kabel$client$sender_$_state_machine__28014__auto____0 = (function (){
var statearr_38677 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38677[(0)] = kabel$client$sender_$_state_machine__28014__auto__);

(statearr_38677[(1)] = (1));

return statearr_38677;
});
var kabel$client$sender_$_state_machine__28014__auto____1 = (function (state_38651){
while(true){
var ret_value__28015__auto__ = (function (){try{while(true){
var result__28016__auto__ = switch__28013__auto__(state_38651);
if(cljs.core.keyword_identical_QMARK_(result__28016__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28016__auto__;
}
break;
}
}catch (e38678){var ex__28017__auto__ = e38678;
var statearr_38679_38703 = state_38651;
(statearr_38679_38703[(2)] = ex__28017__auto__);


if(cljs.core.seq((state_38651[(4)]))){
var statearr_38680_38704 = state_38651;
(statearr_38680_38704[(1)] = cljs.core.first((state_38651[(4)])));

} else {
throw ex__28017__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28015__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38705 = state_38651;
state_38651 = G__38705;
continue;
} else {
return ret_value__28015__auto__;
}
break;
}
});
kabel$client$sender_$_state_machine__28014__auto__ = function(state_38651){
switch(arguments.length){
case 0:
return kabel$client$sender_$_state_machine__28014__auto____0.call(this);
case 1:
return kabel$client$sender_$_state_machine__28014__auto____1.call(this,state_38651);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
kabel$client$sender_$_state_machine__28014__auto__.cljs$core$IFn$_invoke$arity$0 = kabel$client$sender_$_state_machine__28014__auto____0;
kabel$client$sender_$_state_machine__28014__auto__.cljs$core$IFn$_invoke$arity$1 = kabel$client$sender_$_state_machine__28014__auto____1;
return kabel$client$sender_$_state_machine__28014__auto__;
})()
})();
var state__28179__auto__ = (function (){var statearr_38681 = f__28178__auto__();
(statearr_38681[(6)] = c__28177__auto__);

return statearr_38681;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28179__auto__);
}));

return c__28177__auto__;
} else {
return channel.close();
}
}));
})();

return opener;
}));

(kabel.client.client_connect_BANG_.cljs$lang$maxFixedArity = 5);


//# sourceMappingURL=kabel.client.js.map
