goog.provide('cljs.core');
goog.scope(function(){
  cljs.core.goog$module$goog$math$Long = goog.module.get('goog.math.Long');
  cljs.core.goog$module$goog$object = goog.module.get('goog.object');
  cljs.core.goog$module$goog$array = goog.module.get('goog.array');
});
cljs.core._STAR_clojurescript_version_STAR_ = "1.11.132";
cljs.core._STAR_unchecked_if_STAR_ = false;
cljs.core._STAR_unchecked_arrays_STAR_ = false;
cljs.core._STAR_warn_on_infer_STAR_ = false;
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.PROTOCOL_SENTINEL !== 'undefined')){
} else {
cljs.core.PROTOCOL_SENTINEL = ({});
}
cljs.core.MODULE_URIS = null;
cljs.core.MODULE_INFOS = null;
/**
 * Var bound to the name value of the compiler build :target option.
 *   For example, if the compiler build :target is :nodejs, *target* will be bound
 *   to "nodejs". *target* is a Google Closure define and can be set by compiler
 *   :closure-defines option.
 * @define {string}
 */
cljs.core._STAR_target_STAR_ = goog.define("cljs.core._STAR_target_STAR_","default");
/**
 * Manually set the JavaScript global context. Only "window", "self"
 *   , and "global" supported. 
 * @define {string}
 */
cljs.core._STAR_global_STAR_ = goog.define("cljs.core._STAR_global_STAR_","default");
/**
 * Var bound to the current namespace. Only used for bootstrapping.
 * @type {*}
 */
cljs.core._STAR_ns_STAR_ = null;
/**
 * @type {*}
 */
cljs.core._STAR_out_STAR_ = null;
cljs.core._STAR_assert_STAR_ = true;
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core._STAR_print_fn_STAR_ !== 'undefined')){
} else {
/**
 * Each runtime environment provides a different way to print output.
 *   Whatever function *print-fn* is bound to will be passed any
 *   Strings which should be printed.
 */
cljs.core._STAR_print_fn_STAR_ = null;
}
/**
 * Arranges to have tap functions executed via the supplied f, a
 *   function of no arguments. Returns true if successful, false otherwise.
 */
cljs.core._STAR_exec_tap_fn_STAR_ = (function cljs$core$_STAR_exec_tap_fn_STAR_(f){
var and__5000__auto__ = (typeof setTimeout !== 'undefined');
if(and__5000__auto__){
var G__32934 = setTimeout(f,(0));
return (cljs.core.boolean$.cljs$core$IFn$_invoke$arity$1 ? cljs.core.boolean$.cljs$core$IFn$_invoke$arity$1(G__32934) : cljs.core.boolean$.call(null, G__32934));
} else {
return and__5000__auto__;
}
});
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core._STAR_print_err_fn_STAR_ !== 'undefined')){
} else {
/**
 * Each runtime environment provides a different way to print error output.
 *   Whatever function *print-err-fn* is bound to will be passed any
 *   Strings which should be printed.
 */
cljs.core._STAR_print_err_fn_STAR_ = null;
}
/**
 * Set *print-fn* to f.
 */
cljs.core.set_print_fn_BANG_ = (function cljs$core$set_print_fn_BANG_(f){
return (cljs.core._STAR_print_fn_STAR_ = f);
});
/**
 * Set *print-err-fn* to f.
 */
cljs.core.set_print_err_fn_BANG_ = (function cljs$core$set_print_err_fn_BANG_(f){
return (cljs.core._STAR_print_err_fn_STAR_ = f);
});
/**
 * When set to true, output will be flushed whenever a newline is printed.
 * 
 *   Defaults to true.
 */
cljs.core._STAR_flush_on_newline_STAR_ = true;
/**
 * When set to logical false will drop newlines from printing calls.
 *   This is to work around the implicit newlines emitted by standard JavaScript
 *   console objects.
 */
cljs.core._STAR_print_newline_STAR_ = true;
/**
 * When set to logical false, strings and characters will be printed with
 *   non-alphanumeric characters converted to the appropriate escape sequences.
 * 
 *   Defaults to true
 */
cljs.core._STAR_print_readably_STAR_ = true;
/**
 * If set to logical true, when printing an object, its metadata will also
 *   be printed in a form that can be read back by the reader.
 * 
 *   Defaults to false.
 */
cljs.core._STAR_print_meta_STAR_ = false;
/**
 * When set to logical true, objects will be printed in a way that preserves
 *   their type when read in later.
 * 
 *   Defaults to false.
 */
cljs.core._STAR_print_dup_STAR_ = false;
/**
 * *print-namespace-maps* controls whether the printer will print
 *   namespace map literal syntax.
 * 
 *   Defaults to false, but the REPL binds it to true.
 */
cljs.core._STAR_print_namespace_maps_STAR_ = false;
/**
 * *print-length* controls how many items of each collection the
 *   printer will print. If it is bound to logical false, there is no
 *   limit. Otherwise, it must be bound to an integer indicating the maximum
 *   number of items of each collection to print. If a collection contains
 *   more items, the printer will print items up to the limit followed by
 *   '...' to represent the remaining items. The root binding is nil
 *   indicating no limit.
 * @type {null|number}
 */
cljs.core._STAR_print_length_STAR_ = null;
/**
 * *print-level* controls how many levels deep the printer will
 *   print nested objects. If it is bound to logical false, there is no
 *   limit. Otherwise, it must be bound to an integer indicating the maximum
 *   level to print. Each argument to print is at level 0; if an argument is a
 *   collection, its items are at level 1; and so on. If an object is a
 *   collection and is at a level greater than or equal to the value bound to
 *   *print-level*, the printer prints '#' to represent it. The root binding
 *   is nil indicating no limit.
 * @type {null|number}
 */
cljs.core._STAR_print_level_STAR_ = null;
/**
 * *print-fns-bodies* controls whether functions print their source or
 *  only their names.
 */
cljs.core._STAR_print_fn_bodies_STAR_ = false;
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core._STAR_loaded_libs_STAR_ !== 'undefined')){
} else {
/**
 * @type {*}
 */
cljs.core._STAR_loaded_libs_STAR_ = null;
}
cljs.core.pr_opts = (function cljs$core$pr_opts(){
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"flush-on-newline","flush-on-newline",-151457939),cljs.core._STAR_flush_on_newline_STAR_,new cljs.core.Keyword(null,"readably","readably",1129599760),cljs.core._STAR_print_readably_STAR_,new cljs.core.Keyword(null,"meta","meta",1499536964),cljs.core._STAR_print_meta_STAR_,new cljs.core.Keyword(null,"dup","dup",556298533),cljs.core._STAR_print_dup_STAR_,new cljs.core.Keyword(null,"print-length","print-length",1931866356),cljs.core._STAR_print_length_STAR_], null);
});
/**
 * Set *print-fn* to console.log
 */
cljs.core.enable_console_print_BANG_ = (function cljs$core$enable_console_print_BANG_(){
(cljs.core._STAR_print_newline_STAR_ = false);

cljs.core.set_print_fn_BANG_((function (){
var xs = arguments;
return console.log.apply(console,cljs.core.goog$module$goog$array.clone(xs));
}));

cljs.core.set_print_err_fn_BANG_((function (){
var xs = arguments;
return console.error.apply(console,cljs.core.goog$module$goog$array.clone(xs));
}));

return null;
});
/**
 * Internal - do not use!
 */
cljs.core.truth_ = (function cljs$core$truth_(x){
return (x != null && x !== false);
});
cljs.core.not_native = null;

/**
 * Tests if 2 arguments are the same object
 */
cljs.core.identical_QMARK_ = (function cljs$core$identical_QMARK_(x,y){
return (x === y);
});
/**
 * Returns true if x is nil, false otherwise.
 */
cljs.core.nil_QMARK_ = (function cljs$core$nil_QMARK_(x){
return (x == null);
});
/**
 * Returns true if x is a JavaScript array.
 */
cljs.core.array_QMARK_ = (function cljs$core$array_QMARK_(x){
if((cljs.core._STAR_target_STAR_ === "nodejs")){
return Array.isArray(x);
} else {
return (x instanceof Array);
}
});
/**
 * Returns true if x is a JavaScript number.
 */
cljs.core.number_QMARK_ = (function cljs$core$number_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true if x is logical false, false otherwise.
 */
cljs.core.not = (function cljs$core$not(x){
if((x == null)){
return true;
} else {
if(x === false){
return true;
} else {
return false;

}
}
});
/**
 * Returns true if x is not nil, false otherwise.
 */
cljs.core.some_QMARK_ = (function cljs$core$some_QMARK_(x){
return (!((x == null)));
});
/**
 * Returns true if x's constructor is Object
 */
cljs.core.object_QMARK_ = (function cljs$core$object_QMARK_(x){
if((!((x == null)))){
return (x.constructor === Object);
} else {
return false;
}
});
/**
 * Returns true if x is a JavaScript string.
 */
cljs.core.string_QMARK_ = (function cljs$core$string_QMARK_(x){
return ("string" === goog.typeOf(x));
});
/**
 * Returns true if x is a JavaScript string of length one.
 */
cljs.core.char_QMARK_ = (function cljs$core$char_QMARK_(x){
return ((typeof x === 'string') && (((1) === x.length)));
});
/**
 * Returns true if given any argument.
 */
cljs.core.any_QMARK_ = (function cljs$core$any_QMARK_(x){
return true;
});
/**
 * Internal - do not use!
 */
cljs.core.native_satisfies_QMARK_ = (function cljs$core$native_satisfies_QMARK_(p,x){
var x__$1 = (((x == null))?null:x);
if((p[goog.typeOf(x__$1)])){
return true;
} else {
if((p["_"])){
return true;
} else {
return false;

}
}
});
cljs.core.is_proto_ = (function cljs$core$is_proto_(x){
return (x.constructor.prototype === x);
});
/**
 * When compiled for a command-line target, whatever function
 *   *main-cli-fn* is set to will be called with the command-line
 *   argv as arguments
 */
cljs.core._STAR_main_cli_fn_STAR_ = null;
/**
 * A sequence of the supplied command line arguments, or nil if
 *   none were supplied
 */
cljs.core._STAR_command_line_args_STAR_ = null;
/**
 * Return x's constructor.
 */
cljs.core.type = (function cljs$core$type(x){
if((x == null)){
return null;
} else {
return x.constructor;
}
});
cljs.core.missing_protocol = (function cljs$core$missing_protocol(proto,obj){
var ty = cljs.core.type(obj);
var ty__$1 = (cljs.core.truth_((function (){var and__5000__auto__ = ty;
if(cljs.core.truth_(and__5000__auto__)){
return ty.cljs$lang$type;
} else {
return and__5000__auto__;
}
})())?ty.cljs$lang$ctorStr:goog.typeOf(obj));
return (new Error(["No protocol method ",proto," defined for type ",ty__$1,": ",obj].join("")));
});
cljs.core.type__GT_str = (function cljs$core$type__GT_str(ty){
var temp__5821__auto__ = ty.cljs$lang$ctorStr;
if(cljs.core.truth_(temp__5821__auto__)){
var s = temp__5821__auto__;
return s;
} else {
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(ty);
}
});
cljs.core.load_file = (function cljs$core$load_file(file){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
return goog.nodeGlobalRequire(file);
}
});
if((((typeof Symbol !== 'undefined')) && ((goog.typeOf(Symbol) === "function")))){
cljs.core.ITER_SYMBOL = Symbol.iterator;
} else {
cljs.core.ITER_SYMBOL = "@@iterator";
}
/**
 * @enum {string}
 */
cljs.core.CHAR_MAP = ({"]": "_RBRACK_", "'": "_SINGLEQUOTE_", "=": "_EQ_", "\"": "_DOUBLEQUOTE_", "!": "_BANG_", "*": "_STAR_", "%": "_PERCENT_", "|": "_BAR_", "~": "_TILDE_", "/": "_SLASH_", "\\": "_BSLASH_", "-": "_", "?": "_QMARK_", "&": "_AMPERSAND_", ":": "_COLON_", "<": "_LT_", "{": "_LBRACE_", "}": "_RBRACE_", "[": "_LBRACK_", "#": "_SHARP_", "^": "_CARET_", "+": "_PLUS_", "@": "_CIRCA_", ">": "_GT_"});
/**
 * @enum {string}
 */
cljs.core.DEMUNGE_MAP = ({"_RBRACE_": "}", "_COLON_": ":", "_BANG_": "!", "_QMARK_": "?", "_BSLASH_": "\\\\", "_SLASH_": "/", "_PERCENT_": "%", "_PLUS_": "+", "_SHARP_": "#", "_LBRACE_": "{", "_BAR_": "|", "_LBRACK_": "[", "_EQ_": "=", "_": "-", "_TILDE_": "~", "_RBRACK_": "]", "_GT_": ">", "_SINGLEQUOTE_": "'", "_CIRCA_": "@", "_AMPERSAND_": "&", "_DOUBLEQUOTE_": "\\\"", "_CARET_": "^", "_LT_": "<", "_STAR_": "*"});
cljs.core.DEMUNGE_PATTERN = null;
/**
 * Returns highest resolution time offered by host in milliseconds.
 */
cljs.core.system_time = (function cljs$core$system_time(){
if((((typeof performance !== 'undefined')) && ((!((performance.now == null)))))){
return performance.now();
} else {
if((((typeof process !== 'undefined')) && ((!((process.hrtime == null)))))){
var t = process.hrtime();
return ((((t[(0)]) * 1.0E9) + (t[(1)])) / 1000000.0);
} else {
return (new Date()).getTime();

}
}
});
/**
 * Construct a JavaScript array of the specified dimensions. Accepts ignored
 *   type argument for compatibility with Clojure. Note that there is no efficient
 *   way to allocate multi-dimensional arrays in JavaScript; as such, this function
 *   will run in polynomial time when called with 3 or more arguments.
 */
cljs.core.make_array = (function cljs$core$make_array(var_args){
var G__32939 = arguments.length;
switch (G__32939) {
case 1:
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___34479 = arguments.length;
var i__5727__auto___34483 = (0);
while(true){
if((i__5727__auto___34483 < len__5726__auto___34479)){
args_arr__5751__auto__.push((arguments[i__5727__auto___34483]));

var G__34489 = (i__5727__auto___34483 + (1));
i__5727__auto___34483 = G__34489;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.make_array.cljs$core$IFn$_invoke$arity$1 = (function (size){
return (new Array(size));
}));

(cljs.core.make_array.cljs$core$IFn$_invoke$arity$2 = (function (type,size){
return (new Array(size));
}));

(cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic = (function (type,size,more_sizes){
var dims = more_sizes;
var dimarray = (new Array(size));
var n__5593__auto___34499 = dimarray.length;
var i_34500 = (0);
while(true){
if((i_34500 < n__5593__auto___34499)){
(dimarray[i_34500] = (cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.make_array,null,dims) : cljs.core.apply.call(null, cljs.core.make_array,null,dims)));

var G__34502 = (i_34500 + (1));
i_34500 = G__34502;
continue;
} else {
}
break;
}

return dimarray;
}));

/** @this {Function} */
(cljs.core.make_array.cljs$lang$applyTo = (function (seq32936){
var G__32937 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq32936) : cljs.core.first.call(null, seq32936));
var seq32936__$1 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq32936) : cljs.core.next.call(null, seq32936));
var G__32938 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq32936__$1) : cljs.core.first.call(null, seq32936__$1));
var seq32936__$2 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq32936__$1) : cljs.core.next.call(null, seq32936__$1));
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32937,G__32938,seq32936__$2);
}));

(cljs.core.make_array.cljs$lang$maxFixedArity = (2));

/**
 * Returns a javascript array, cloned from the passed in array
 */
cljs.core.aclone = (function cljs$core$aclone(arr){
var len = arr.length;
var new_arr = (new Array(len));
var n__5593__auto___34504 = len;
var i_34505 = (0);
while(true){
if((i_34505 < n__5593__auto___34504)){
(new_arr[i_34505] = (arr[i_34505]));

var G__34506 = (i_34505 + (1));
i_34505 = G__34506;
continue;
} else {
}
break;
}

return new_arr;
});
/**
 * Creates a new javascript array.
 * @param {...*} var_args
 */
cljs.core.array = (function cljs$core$array(var_args){
var a = (new Array(arguments.length));
var i = (0);
while(true){
if((i < a.length)){
(a[i] = (arguments[i]));

var G__34510 = (i + (1));
i = G__34510;
continue;
} else {
return a;
}
break;
}
});
cljs.core.maybe_warn = (function cljs$core$maybe_warn(e){
if(cljs.core.truth_(cljs.core._STAR_print_err_fn_STAR_)){
return cljs.core._STAR_print_err_fn_STAR_.call(null, e);
} else {
return null;
}
});
cljs.core.checked_aget = (function cljs$core$checked_aget(var_args){
var G__32944 = arguments.length;
switch (G__32944) {
case 2:
return cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___34516 = arguments.length;
var i__5727__auto___34517 = (0);
while(true){
if((i__5727__auto___34517 < len__5726__auto___34516)){
args_arr__5751__auto__.push((arguments[i__5727__auto___34517]));

var G__34518 = (i__5727__auto___34517 + (1));
i__5727__auto___34517 = G__34518;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2 = (function (array,idx){
try{if(cljs.core.truth_((function (){var or__5002__auto__ = cljs.core.array_QMARK_(array);
if(or__5002__auto__){
return or__5002__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}
}catch (e32945){var e_34525 = e32945;
cljs.core.maybe_warn(e_34525);
}
return (array[idx]);
}));

(cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idxs){
var G__32946 = cljs.core.checked_aget;
var G__32947 = cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2(array,idx);
var G__32948 = idxs;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(G__32946,G__32947,G__32948) : cljs.core.apply.call(null, G__32946,G__32947,G__32948));
}));

/** @this {Function} */
(cljs.core.checked_aget.cljs$lang$applyTo = (function (seq32941){
var G__32942 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq32941) : cljs.core.first.call(null, seq32941));
var seq32941__$1 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq32941) : cljs.core.next.call(null, seq32941));
var G__32943 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq32941__$1) : cljs.core.first.call(null, seq32941__$1));
var seq32941__$2 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq32941__$1) : cljs.core.next.call(null, seq32941__$1));
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32942,G__32943,seq32941__$2);
}));

(cljs.core.checked_aget.cljs$lang$maxFixedArity = (2));

cljs.core.checked_aset = (function cljs$core$checked_aset(var_args){
var G__32954 = arguments.length;
switch (G__32954) {
case 3:
return cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___34528 = arguments.length;
var i__5727__auto___34530 = (0);
while(true){
if((i__5727__auto___34530 < len__5726__auto___34528)){
args_arr__5751__auto__.push((arguments[i__5727__auto___34530]));

var G__34533 = (i__5727__auto___34530 + (1));
i__5727__auto___34530 = G__34533;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((3) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((3)),(0),null)):null);
return cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5752__auto__);

}
});

(cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$3 = (function (array,idx,val){
try{if(cljs.core.truth_((function (){var or__5002__auto__ = cljs.core.array_QMARK_(array);
if(or__5002__auto__){
return or__5002__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}
}catch (e32955){var e_34546 = e32955;
cljs.core.maybe_warn(e_34546);
}
return (array[idx] = val);
}));

(cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idx2,idxv){
var G__32956 = cljs.core.checked_aset;
var G__32957 = cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2(array,idx);
var G__32958 = idx2;
var G__32959 = idxv;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$4 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$4(G__32956,G__32957,G__32958,G__32959) : cljs.core.apply.call(null, G__32956,G__32957,G__32958,G__32959));
}));

/** @this {Function} */
(cljs.core.checked_aset.cljs$lang$applyTo = (function (seq32950){
var G__32951 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq32950) : cljs.core.first.call(null, seq32950));
var seq32950__$1 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq32950) : cljs.core.next.call(null, seq32950));
var G__32952 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq32950__$1) : cljs.core.first.call(null, seq32950__$1));
var seq32950__$2 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq32950__$1) : cljs.core.next.call(null, seq32950__$1));
var G__32953 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq32950__$2) : cljs.core.first.call(null, seq32950__$2));
var seq32950__$3 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq32950__$2) : cljs.core.next.call(null, seq32950__$2));
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32951,G__32952,G__32953,seq32950__$3);
}));

(cljs.core.checked_aset.cljs$lang$maxFixedArity = (3));

cljs.core.checked_aget_SINGLEQUOTE_ = (function cljs$core$checked_aget_SINGLEQUOTE_(var_args){
var G__32964 = arguments.length;
switch (G__32964) {
case 2:
return cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___34558 = arguments.length;
var i__5727__auto___34559 = (0);
while(true){
if((i__5727__auto___34559 < len__5726__auto___34558)){
args_arr__5751__auto__.push((arguments[i__5727__auto___34559]));

var G__34561 = (i__5727__auto___34559 + (1));
i__5727__auto___34559 = G__34561;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2 = (function (array,idx){
if(cljs.core.truth_((function (){var or__5002__auto__ = cljs.core.array_QMARK_(array);
if(or__5002__auto__){
return or__5002__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}

return (array[idx]);
}));

(cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idxs){
var G__32965 = cljs.core.checked_aget_SINGLEQUOTE_;
var G__32966 = cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2(array,idx);
var G__32967 = idxs;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(G__32965,G__32966,G__32967) : cljs.core.apply.call(null, G__32965,G__32966,G__32967));
}));

/** @this {Function} */
(cljs.core.checked_aget_SINGLEQUOTE_.cljs$lang$applyTo = (function (seq32961){
var G__32962 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq32961) : cljs.core.first.call(null, seq32961));
var seq32961__$1 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq32961) : cljs.core.next.call(null, seq32961));
var G__32963 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq32961__$1) : cljs.core.first.call(null, seq32961__$1));
var seq32961__$2 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq32961__$1) : cljs.core.next.call(null, seq32961__$1));
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32962,G__32963,seq32961__$2);
}));

(cljs.core.checked_aget_SINGLEQUOTE_.cljs$lang$maxFixedArity = (2));

cljs.core.checked_aset_SINGLEQUOTE_ = (function cljs$core$checked_aset_SINGLEQUOTE_(var_args){
var G__32973 = arguments.length;
switch (G__32973) {
case 3:
return cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___34568 = arguments.length;
var i__5727__auto___34569 = (0);
while(true){
if((i__5727__auto___34569 < len__5726__auto___34568)){
args_arr__5751__auto__.push((arguments[i__5727__auto___34569]));

var G__34570 = (i__5727__auto___34569 + (1));
i__5727__auto___34569 = G__34570;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((3) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((3)),(0),null)):null);
return cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5752__auto__);

}
});

(cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$3 = (function (array,idx,val){
if(cljs.core.truth_((function (){var or__5002__auto__ = cljs.core.array_QMARK_(array);
if(or__5002__auto__){
return or__5002__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}

return (array[idx] = val);
}));

(cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idx2,idxv){
var G__32974 = cljs.core.checked_aset_SINGLEQUOTE_;
var G__32975 = cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2(array,idx);
var G__32976 = idx2;
var G__32977 = idxv;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$4 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$4(G__32974,G__32975,G__32976,G__32977) : cljs.core.apply.call(null, G__32974,G__32975,G__32976,G__32977));
}));

/** @this {Function} */
(cljs.core.checked_aset_SINGLEQUOTE_.cljs$lang$applyTo = (function (seq32969){
var G__32970 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq32969) : cljs.core.first.call(null, seq32969));
var seq32969__$1 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq32969) : cljs.core.next.call(null, seq32969));
var G__32971 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq32969__$1) : cljs.core.first.call(null, seq32969__$1));
var seq32969__$2 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq32969__$1) : cljs.core.next.call(null, seq32969__$1));
var G__32972 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq32969__$2) : cljs.core.first.call(null, seq32969__$2));
var seq32969__$3 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq32969__$2) : cljs.core.next.call(null, seq32969__$2));
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32970,G__32971,G__32972,seq32969__$3);
}));

(cljs.core.checked_aset_SINGLEQUOTE_.cljs$lang$maxFixedArity = (3));

/**
 * Returns the value at the index/indices. Works on JavaScript arrays.
 */
cljs.core.aget = (function cljs$core$aget(var_args){
var G__32982 = arguments.length;
switch (G__32982) {
case 2:
return cljs.core.aget.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___34575 = arguments.length;
var i__5727__auto___34576 = (0);
while(true){
if((i__5727__auto___34576 < len__5726__auto___34575)){
args_arr__5751__auto__.push((arguments[i__5727__auto___34576]));

var G__34577 = (i__5727__auto___34576 + (1));
i__5727__auto___34576 = G__34577;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.aget.cljs$core$IFn$_invoke$arity$2 = (function (array,idx){
return (array[idx]);
}));

(cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idxs){
var G__32983 = cljs.core.aget;
var G__32984 = (array[idx]);
var G__32985 = idxs;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(G__32983,G__32984,G__32985) : cljs.core.apply.call(null, G__32983,G__32984,G__32985));
}));

/** @this {Function} */
(cljs.core.aget.cljs$lang$applyTo = (function (seq32979){
var G__32980 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq32979) : cljs.core.first.call(null, seq32979));
var seq32979__$1 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq32979) : cljs.core.next.call(null, seq32979));
var G__32981 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq32979__$1) : cljs.core.first.call(null, seq32979__$1));
var seq32979__$2 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq32979__$1) : cljs.core.next.call(null, seq32979__$1));
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32980,G__32981,seq32979__$2);
}));

(cljs.core.aget.cljs$lang$maxFixedArity = (2));

/**
 * Sets the value at the index/indices. Works on JavaScript arrays.
 *   Returns val.
 */
cljs.core.aset = (function cljs$core$aset(var_args){
var G__32991 = arguments.length;
switch (G__32991) {
case 3:
return cljs.core.aset.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___34581 = arguments.length;
var i__5727__auto___34582 = (0);
while(true){
if((i__5727__auto___34582 < len__5726__auto___34581)){
args_arr__5751__auto__.push((arguments[i__5727__auto___34582]));

var G__34583 = (i__5727__auto___34582 + (1));
i__5727__auto___34582 = G__34583;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((3) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((3)),(0),null)):null);
return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5752__auto__);

}
});

(cljs.core.aset.cljs$core$IFn$_invoke$arity$3 = (function (array,idx,val){
return (array[idx] = val);
}));

(cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idx2,idxv){
var G__32992 = cljs.core.aset;
var G__32993 = (array[idx]);
var G__32994 = idx2;
var G__32995 = idxv;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$4 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$4(G__32992,G__32993,G__32994,G__32995) : cljs.core.apply.call(null, G__32992,G__32993,G__32994,G__32995));
}));

/** @this {Function} */
(cljs.core.aset.cljs$lang$applyTo = (function (seq32987){
var G__32988 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq32987) : cljs.core.first.call(null, seq32987));
var seq32987__$1 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq32987) : cljs.core.next.call(null, seq32987));
var G__32989 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq32987__$1) : cljs.core.first.call(null, seq32987__$1));
var seq32987__$2 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq32987__$1) : cljs.core.next.call(null, seq32987__$1));
var G__32990 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq32987__$2) : cljs.core.first.call(null, seq32987__$2));
var seq32987__$3 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq32987__$2) : cljs.core.next.call(null, seq32987__$2));
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32988,G__32989,G__32990,seq32987__$3);
}));

(cljs.core.aset.cljs$lang$maxFixedArity = (3));

/**
 * Returns the length of the array. Works on arrays of all types.
 */
cljs.core.alength = (function cljs$core$alength(array){
return array.length;
});
/**
 * Returns an array with components set to the values in aseq. Optional type
 *   argument accepted for compatibility with Clojure.
 */
cljs.core.into_array = (function cljs$core$into_array(var_args){
var G__32997 = arguments.length;
switch (G__32997) {
case 1:
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 = (function (aseq){
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(null,aseq);
}));

(cljs.core.into_array.cljs$core$IFn$_invoke$arity$2 = (function (type,aseq){
var G__32998 = (function (a,x){
a.push(x);

return a;
});
var G__32999 = [];
var G__33000 = aseq;
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__32998,G__32999,G__33000) : cljs.core.reduce.call(null, G__32998,G__32999,G__33000));
}));

(cljs.core.into_array.cljs$lang$maxFixedArity = 2);

/**
 * Invoke JavaScript object method via string. Needed when the
 *   string is not a valid unquoted property name.
 */
cljs.core.js_invoke = (function cljs$core$js_invoke(var_args){
var args__5732__auto__ = [];
var len__5726__auto___34586 = arguments.length;
var i__5727__auto___34588 = (0);
while(true){
if((i__5727__auto___34588 < len__5726__auto___34586)){
args__5732__auto__.push((arguments[i__5727__auto___34588]));

var G__34589 = (i__5727__auto___34588 + (1));
i__5727__auto___34588 = G__34589;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((2) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((2)),(0),null)):null);
return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5733__auto__);
});

(cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic = (function (obj,s,args){
return (obj[s]).apply(obj,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args));
}));

(cljs.core.js_invoke.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(cljs.core.js_invoke.cljs$lang$applyTo = (function (seq33001){
var G__33002 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq33001) : cljs.core.first.call(null, seq33001));
var seq33001__$1 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq33001) : cljs.core.next.call(null, seq33001));
var G__33003 = (cljs.core.first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.first.cljs$core$IFn$_invoke$arity$1(seq33001__$1) : cljs.core.first.call(null, seq33001__$1));
var seq33001__$2 = (cljs.core.next.cljs$core$IFn$_invoke$arity$1 ? cljs.core.next.cljs$core$IFn$_invoke$arity$1(seq33001__$1) : cljs.core.next.call(null, seq33001__$1));
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33002,G__33003,seq33001__$2);
}));

/**
 * Returns true if x is an instance of Symbol
 */
cljs.core.js_symbol_QMARK_ = (function cljs$core$js_symbol_QMARK_(x){
return (((goog.typeOf(x) === "symbol")) || ((((typeof Symbol !== 'undefined')) && ((x instanceof Symbol)))));
});

/**
 * Marker protocol
 * @interface
 */
cljs.core.Fn = function(){};


/**
 * Protocol for adding the ability to invoke an object as a function.
 *   For example, a vector can also be used to look up a value:
 *   ([1 2 3 4] 1) => 2
 * @interface
 */
cljs.core.IFn = function(){};

var cljs$core$IFn$_invoke$dyn_34592 = (function() {
var G__34593 = null;
var G__34593__1 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null, this$));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null, this$));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__34593__2 = (function (this$,a){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(this$,a) : m__5351__auto__.call(null, this$,a));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(this$,a) : m__5349__auto__.call(null, this$,a));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__34593__3 = (function (this$,a,b){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(this$,a,b) : m__5351__auto__.call(null, this$,a,b));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(this$,a,b) : m__5349__auto__.call(null, this$,a,b));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__34593__4 = (function (this$,a,b,c){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$4(this$,a,b,c) : m__5351__auto__.call(null, this$,a,b,c));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$4(this$,a,b,c) : m__5349__auto__.call(null, this$,a,b,c));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__34593__5 = (function (this$,a,b,c,d){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$5 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d) : m__5351__auto__.call(null, this$,a,b,c,d));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$5 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d) : m__5349__auto__.call(null, this$,a,b,c,d));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__34593__6 = (function (this$,a,b,c,d,e){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$6 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e) : m__5351__auto__.call(null, this$,a,b,c,d,e));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$6 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e) : m__5349__auto__.call(null, this$,a,b,c,d,e));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__34593__7 = (function (this$,a,b,c,d,e,f){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$7 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f) : m__5351__auto__.call(null, this$,a,b,c,d,e,f));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$7 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f) : m__5349__auto__.call(null, this$,a,b,c,d,e,f));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__34593__8 = (function (this$,a,b,c,d,e,f,g){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$8 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g) : m__5351__auto__.call(null, this$,a,b,c,d,e,f,g));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$8 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g) : m__5349__auto__.call(null, this$,a,b,c,d,e,f,g));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__34593__9 = (function (this$,a,b,c,d,e,f,g,h){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$9 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h) : m__5351__auto__.call(null, this$,a,b,c,d,e,f,g,h));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$9 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h) : m__5349__auto__.call(null, this$,a,b,c,d,e,f,g,h));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__34593__10 = (function (this$,a,b,c,d,e,f,g,h,i){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$10 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i) : m__5351__auto__.call(null, this$,a,b,c,d,e,f,g,h,i));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$10 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i) : m__5349__auto__.call(null, this$,a,b,c,d,e,f,g,h,i));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__34593__11 = (function (this$,a,b,c,d,e,f,g,h,i,j){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$11 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j) : m__5351__auto__.call(null, this$,a,b,c,d,e,f,g,h,i,j));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$11 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j) : m__5349__auto__.call(null, this$,a,b,c,d,e,f,g,h,i,j));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__34593__12 = (function (this$,a,b,c,d,e,f,g,h,i,j,k){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$12 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k) : m__5351__auto__.call(null, this$,a,b,c,d,e,f,g,h,i,j,k));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$12 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k) : m__5349__auto__.call(null, this$,a,b,c,d,e,f,g,h,i,j,k));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__34593__13 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$13 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l) : m__5351__auto__.call(null, this$,a,b,c,d,e,f,g,h,i,j,k,l));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$13 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l) : m__5349__auto__.call(null, this$,a,b,c,d,e,f,g,h,i,j,k,l));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__34593__14 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$14 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m) : m__5351__auto__.call(null, this$,a,b,c,d,e,f,g,h,i,j,k,l,m));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$14 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m) : m__5349__auto__.call(null, this$,a,b,c,d,e,f,g,h,i,j,k,l,m));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__34593__15 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$15 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n) : m__5351__auto__.call(null, this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$15 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n) : m__5349__auto__.call(null, this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__34593__16 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$16 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : m__5351__auto__.call(null, this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$16 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : m__5349__auto__.call(null, this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__34593__17 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$17 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : m__5351__auto__.call(null, this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$17 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : m__5349__auto__.call(null, this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__34593__18 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$18 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : m__5351__auto__.call(null, this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$18 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : m__5349__auto__.call(null, this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__34593__19 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$19 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : m__5351__auto__.call(null, this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$19 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : m__5349__auto__.call(null, this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__34593__20 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$20 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : m__5351__auto__.call(null, this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$20 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : m__5349__auto__.call(null, this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__34593__21 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$21 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s, new cljs.core.IndexedSeq([t],0,null)) : m__5351__auto__.call(null, this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$21 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s, new cljs.core.IndexedSeq([t],0,null)) : m__5349__auto__.call(null, this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__34593__22 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._invoke[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$21 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s, new cljs.core.IndexedSeq([t,rest],0,null)) : m__5351__auto__.call(null, this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
} else {
var m__5349__auto__ = (cljs.core._invoke["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$21 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s, new cljs.core.IndexedSeq([t,rest],0,null)) : m__5349__auto__.call(null, this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
G__34593 = function(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__34593__1.call(this,this$);
case 2:
return G__34593__2.call(this,this$,a);
case 3:
return G__34593__3.call(this,this$,a,b);
case 4:
return G__34593__4.call(this,this$,a,b,c);
case 5:
return G__34593__5.call(this,this$,a,b,c,d);
case 6:
return G__34593__6.call(this,this$,a,b,c,d,e);
case 7:
return G__34593__7.call(this,this$,a,b,c,d,e,f);
case 8:
return G__34593__8.call(this,this$,a,b,c,d,e,f,g);
case 9:
return G__34593__9.call(this,this$,a,b,c,d,e,f,g,h);
case 10:
return G__34593__10.call(this,this$,a,b,c,d,e,f,g,h,i);
case 11:
return G__34593__11.call(this,this$,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__34593__12.call(this,this$,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__34593__13.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__34593__14.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__34593__15.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__34593__16.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__34593__17.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__34593__18.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__34593__19.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__34593__20.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__34593__21.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__34593__22.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34593.cljs$core$IFn$_invoke$arity$1 = G__34593__1;
G__34593.cljs$core$IFn$_invoke$arity$2 = G__34593__2;
G__34593.cljs$core$IFn$_invoke$arity$3 = G__34593__3;
G__34593.cljs$core$IFn$_invoke$arity$4 = G__34593__4;
G__34593.cljs$core$IFn$_invoke$arity$5 = G__34593__5;
G__34593.cljs$core$IFn$_invoke$arity$6 = G__34593__6;
G__34593.cljs$core$IFn$_invoke$arity$7 = G__34593__7;
G__34593.cljs$core$IFn$_invoke$arity$8 = G__34593__8;
G__34593.cljs$core$IFn$_invoke$arity$9 = G__34593__9;
G__34593.cljs$core$IFn$_invoke$arity$10 = G__34593__10;
G__34593.cljs$core$IFn$_invoke$arity$11 = G__34593__11;
G__34593.cljs$core$IFn$_invoke$arity$12 = G__34593__12;
G__34593.cljs$core$IFn$_invoke$arity$13 = G__34593__13;
G__34593.cljs$core$IFn$_invoke$arity$14 = G__34593__14;
G__34593.cljs$core$IFn$_invoke$arity$15 = G__34593__15;
G__34593.cljs$core$IFn$_invoke$arity$16 = G__34593__16;
G__34593.cljs$core$IFn$_invoke$arity$17 = G__34593__17;
G__34593.cljs$core$IFn$_invoke$arity$18 = G__34593__18;
G__34593.cljs$core$IFn$_invoke$arity$19 = G__34593__19;
G__34593.cljs$core$IFn$_invoke$arity$20 = G__34593__20;
G__34593.cljs$core$IFn$_invoke$arity$21 = G__34593__21;
G__34593.cljs$core$IFn$_invoke$arity$22 = G__34593__22;
return G__34593;
})()
;
cljs.core._invoke = (function cljs$core$_invoke(var_args){
var G__33005 = arguments.length;
switch (G__33005) {
case 1:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
case 9:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
case 11:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$11((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]));

break;
case 12:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$12((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]));

break;
case 13:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$13((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]));

break;
case 14:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$14((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]));

break;
case 15:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$15((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]));

break;
case 16:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$16((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]));

break;
case 17:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$17((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]));

break;
case 18:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$18((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]));

break;
case 19:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$19((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]));

break;
case 20:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$20((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]));

break;
case 21:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$21((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]));

break;
case 22:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$22((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]),(arguments[(21)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$1 = (function (this$){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$1 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$1(this$);
} else {
return cljs$core$IFn$_invoke$dyn_34592(this$);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$2 = (function (this$,a){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$2 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$2(this$,a);
} else {
return cljs$core$IFn$_invoke$dyn_34592(this$,a);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$3 = (function (this$,a,b){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$3 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$3(this$,a,b);
} else {
return cljs$core$IFn$_invoke$dyn_34592(this$,a,b);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$4 = (function (this$,a,b,c){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$4 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$4(this$,a,b,c);
} else {
return cljs$core$IFn$_invoke$dyn_34592(this$,a,b,c);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$5 = (function (this$,a,b,c,d){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$5 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d);
} else {
return cljs$core$IFn$_invoke$dyn_34592(this$,a,b,c,d);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$6 = (function (this$,a,b,c,d,e){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$6 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e);
} else {
return cljs$core$IFn$_invoke$dyn_34592(this$,a,b,c,d,e);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$7 = (function (this$,a,b,c,d,e,f){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$7 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f);
} else {
return cljs$core$IFn$_invoke$dyn_34592(this$,a,b,c,d,e,f);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$8 = (function (this$,a,b,c,d,e,f,g){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$8 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g);
} else {
return cljs$core$IFn$_invoke$dyn_34592(this$,a,b,c,d,e,f,g);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$9 = (function (this$,a,b,c,d,e,f,g,h){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$9 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h);
} else {
return cljs$core$IFn$_invoke$dyn_34592(this$,a,b,c,d,e,f,g,h);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$10 = (function (this$,a,b,c,d,e,f,g,h,i){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$10 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i);
} else {
return cljs$core$IFn$_invoke$dyn_34592(this$,a,b,c,d,e,f,g,h,i);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$11 = (function (this$,a,b,c,d,e,f,g,h,i,j){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$11 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j);
} else {
return cljs$core$IFn$_invoke$dyn_34592(this$,a,b,c,d,e,f,g,h,i,j);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$12 = (function (this$,a,b,c,d,e,f,g,h,i,j,k){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$12 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k);
} else {
return cljs$core$IFn$_invoke$dyn_34592(this$,a,b,c,d,e,f,g,h,i,j,k);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$13 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$13 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l);
} else {
return cljs$core$IFn$_invoke$dyn_34592(this$,a,b,c,d,e,f,g,h,i,j,k,l);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$14 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$14 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
} else {
return cljs$core$IFn$_invoke$dyn_34592(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$15 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$15 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
} else {
return cljs$core$IFn$_invoke$dyn_34592(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$16 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$16 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
} else {
return cljs$core$IFn$_invoke$dyn_34592(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$17 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$17 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
} else {
return cljs$core$IFn$_invoke$dyn_34592(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$18 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$18 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
} else {
return cljs$core$IFn$_invoke$dyn_34592(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$19 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$19 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
} else {
return cljs$core$IFn$_invoke$dyn_34592(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$20 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$20 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
} else {
return cljs$core$IFn$_invoke$dyn_34592(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$21 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$21 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
} else {
return cljs$core$IFn$_invoke$dyn_34592(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$22 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$22 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
} else {
return cljs$core$IFn$_invoke$dyn_34592(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
}));

(cljs.core._invoke.cljs$lang$maxFixedArity = 22);



/**
 * Protocol for cloning a value.
 * @interface
 */
cljs.core.ICloneable = function(){};

var cljs$core$ICloneable$_clone$dyn_34707 = (function (value){
var x__5350__auto__ = (((value == null))?null:value);
var m__5351__auto__ = (cljs.core._clone[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(value) : m__5351__auto__.call(null, value));
} else {
var m__5349__auto__ = (cljs.core._clone["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(value) : m__5349__auto__.call(null, value));
} else {
throw cljs.core.missing_protocol("ICloneable.-clone",value);
}
}
});
/**
 * Creates a clone of value.
 */
cljs.core._clone = (function cljs$core$_clone(value){
if((((!((value == null)))) && ((!((value.cljs$core$ICloneable$_clone$arity$1 == null)))))){
return value.cljs$core$ICloneable$_clone$arity$1(value);
} else {
return cljs$core$ICloneable$_clone$dyn_34707(value);
}
});


/**
 * Protocol for adding the ability to count a collection in constant time.
 * @interface
 */
cljs.core.ICounted = function(){};

var cljs$core$ICounted$_count$dyn_34712 = (function (coll){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._count[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5351__auto__.call(null, coll));
} else {
var m__5349__auto__ = (cljs.core._count["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5349__auto__.call(null, coll));
} else {
throw cljs.core.missing_protocol("ICounted.-count",coll);
}
}
});
/**
 * Calculates the count of coll in constant time. Used by cljs.core/count.
 */
cljs.core._count = (function cljs$core$_count(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ICounted$_count$arity$1 == null)))))){
return coll.cljs$core$ICounted$_count$arity$1(coll);
} else {
return cljs$core$ICounted$_count$dyn_34712(coll);
}
});


/**
 * Protocol for creating an empty collection.
 * @interface
 */
cljs.core.IEmptyableCollection = function(){};

var cljs$core$IEmptyableCollection$_empty$dyn_34716 = (function (coll){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._empty[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5351__auto__.call(null, coll));
} else {
var m__5349__auto__ = (cljs.core._empty["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5349__auto__.call(null, coll));
} else {
throw cljs.core.missing_protocol("IEmptyableCollection.-empty",coll);
}
}
});
/**
 * Returns an empty collection of the same category as coll. Used
 *   by cljs.core/empty.
 */
cljs.core._empty = (function cljs$core$_empty(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IEmptyableCollection$_empty$arity$1 == null)))))){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);
} else {
return cljs$core$IEmptyableCollection$_empty$dyn_34716(coll);
}
});


/**
 * Protocol for adding to a collection.
 * @interface
 */
cljs.core.ICollection = function(){};

var cljs$core$ICollection$_conj$dyn_34717 = (function (coll,o){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._conj[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(coll,o) : m__5351__auto__.call(null, coll,o));
} else {
var m__5349__auto__ = (cljs.core._conj["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(coll,o) : m__5349__auto__.call(null, coll,o));
} else {
throw cljs.core.missing_protocol("ICollection.-conj",coll);
}
}
});
/**
 * Returns a new collection of coll with o added to it. The new item
 *   should be added to the most efficient place, e.g.
 *   (conj [1 2 3 4] 5) => [1 2 3 4 5]
 *   (conj '(2 3 4 5) 1) => '(1 2 3 4 5)
 */
cljs.core._conj = (function cljs$core$_conj(coll,o){
if((((!((coll == null)))) && ((!((coll.cljs$core$ICollection$_conj$arity$2 == null)))))){
return coll.cljs$core$ICollection$_conj$arity$2(coll,o);
} else {
return cljs$core$ICollection$_conj$dyn_34717(coll,o);
}
});


/**
 * Protocol for collections to provide indexed-based access to their items.
 * @interface
 */
cljs.core.IIndexed = function(){};

var cljs$core$IIndexed$_nth$dyn_34724 = (function() {
var G__34725 = null;
var G__34725__2 = (function (coll,n){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._nth[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__5351__auto__.call(null, coll,n));
} else {
var m__5349__auto__ = (cljs.core._nth["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__5349__auto__.call(null, coll,n));
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
});
var G__34725__3 = (function (coll,n,not_found){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._nth[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,not_found) : m__5351__auto__.call(null, coll,n,not_found));
} else {
var m__5349__auto__ = (cljs.core._nth["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,not_found) : m__5349__auto__.call(null, coll,n,not_found));
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
});
G__34725 = function(coll,n,not_found){
switch(arguments.length){
case 2:
return G__34725__2.call(this,coll,n);
case 3:
return G__34725__3.call(this,coll,n,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34725.cljs$core$IFn$_invoke$arity$2 = G__34725__2;
G__34725.cljs$core$IFn$_invoke$arity$3 = G__34725__3;
return G__34725;
})()
;
/**
 * Returns the value at the index n in the collection coll.
 *   Returns not-found if index n is out of bounds and not-found is supplied.
 */
cljs.core._nth = (function cljs$core$_nth(var_args){
var G__33007 = arguments.length;
switch (G__33007) {
case 2:
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
if((((!((coll == null)))) && ((!((coll.cljs$core$IIndexed$_nth$arity$2 == null)))))){
return coll.cljs$core$IIndexed$_nth$arity$2(coll,n);
} else {
return cljs$core$IIndexed$_nth$dyn_34724(coll,n);
}
}));

(cljs.core._nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
if((((!((coll == null)))) && ((!((coll.cljs$core$IIndexed$_nth$arity$3 == null)))))){
return coll.cljs$core$IIndexed$_nth$arity$3(coll,n,not_found);
} else {
return cljs$core$IIndexed$_nth$dyn_34724(coll,n,not_found);
}
}));

(cljs.core._nth.cljs$lang$maxFixedArity = 3);



/**
 * Marker protocol indicating an array sequence.
 * @interface
 */
cljs.core.ASeq = function(){};


/**
 * Protocol for collections to provide access to their items as sequences.
 * @interface
 */
cljs.core.ISeq = function(){};

var cljs$core$ISeq$_first$dyn_34729 = (function (coll){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._first[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5351__auto__.call(null, coll));
} else {
var m__5349__auto__ = (cljs.core._first["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5349__auto__.call(null, coll));
} else {
throw cljs.core.missing_protocol("ISeq.-first",coll);
}
}
});
/**
 * Returns the first item in the collection coll. Used by cljs.core/first.
 */
cljs.core._first = (function cljs$core$_first(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISeq$_first$arity$1 == null)))))){
return coll.cljs$core$ISeq$_first$arity$1(coll);
} else {
return cljs$core$ISeq$_first$dyn_34729(coll);
}
});

var cljs$core$ISeq$_rest$dyn_34738 = (function (coll){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._rest[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5351__auto__.call(null, coll));
} else {
var m__5349__auto__ = (cljs.core._rest["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5349__auto__.call(null, coll));
} else {
throw cljs.core.missing_protocol("ISeq.-rest",coll);
}
}
});
/**
 * Returns a new collection of coll without the first item. It should
 *   always return a seq, e.g.
 *   (rest []) => ()
 *   (rest nil) => ()
 */
cljs.core._rest = (function cljs$core$_rest(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISeq$_rest$arity$1 == null)))))){
return coll.cljs$core$ISeq$_rest$arity$1(coll);
} else {
return cljs$core$ISeq$_rest$dyn_34738(coll);
}
});


/**
 * Protocol for accessing the next items of a collection.
 * @interface
 */
cljs.core.INext = function(){};

var cljs$core$INext$_next$dyn_34741 = (function (coll){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._next[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5351__auto__.call(null, coll));
} else {
var m__5349__auto__ = (cljs.core._next["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5349__auto__.call(null, coll));
} else {
throw cljs.core.missing_protocol("INext.-next",coll);
}
}
});
/**
 * Returns a new collection of coll without the first item. In contrast to
 *   rest, it should return nil if there are no more items, e.g.
 *   (next []) => nil
 *   (next nil) => nil
 */
cljs.core._next = (function cljs$core$_next(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$INext$_next$arity$1 == null)))))){
return coll.cljs$core$INext$_next$arity$1(coll);
} else {
return cljs$core$INext$_next$dyn_34741(coll);
}
});


/**
 * Protocol for looking up a value in a data structure.
 * @interface
 */
cljs.core.ILookup = function(){};

var cljs$core$ILookup$_lookup$dyn_34748 = (function() {
var G__34749 = null;
var G__34749__2 = (function (o,k){
var x__5350__auto__ = (((o == null))?null:o);
var m__5351__auto__ = (cljs.core._lookup[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(o,k) : m__5351__auto__.call(null, o,k));
} else {
var m__5349__auto__ = (cljs.core._lookup["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(o,k) : m__5349__auto__.call(null, o,k));
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
});
var G__34749__3 = (function (o,k,not_found){
var x__5350__auto__ = (((o == null))?null:o);
var m__5351__auto__ = (cljs.core._lookup[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(o,k,not_found) : m__5351__auto__.call(null, o,k,not_found));
} else {
var m__5349__auto__ = (cljs.core._lookup["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(o,k,not_found) : m__5349__auto__.call(null, o,k,not_found));
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
});
G__34749 = function(o,k,not_found){
switch(arguments.length){
case 2:
return G__34749__2.call(this,o,k);
case 3:
return G__34749__3.call(this,o,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34749.cljs$core$IFn$_invoke$arity$2 = G__34749__2;
G__34749.cljs$core$IFn$_invoke$arity$3 = G__34749__3;
return G__34749;
})()
;
/**
 * Use k to look up a value in o. If not-found is supplied and k is not
 *   a valid value that can be used for look up, not-found is returned.
 */
cljs.core._lookup = (function cljs$core$_lookup(var_args){
var G__33009 = arguments.length;
switch (G__33009) {
case 2:
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._lookup.cljs$core$IFn$_invoke$arity$2 = (function (o,k){
if((((!((o == null)))) && ((!((o.cljs$core$ILookup$_lookup$arity$2 == null)))))){
return o.cljs$core$ILookup$_lookup$arity$2(o,k);
} else {
return cljs$core$ILookup$_lookup$dyn_34748(o,k);
}
}));

(cljs.core._lookup.cljs$core$IFn$_invoke$arity$3 = (function (o,k,not_found){
if((((!((o == null)))) && ((!((o.cljs$core$ILookup$_lookup$arity$3 == null)))))){
return o.cljs$core$ILookup$_lookup$arity$3(o,k,not_found);
} else {
return cljs$core$ILookup$_lookup$dyn_34748(o,k,not_found);
}
}));

(cljs.core._lookup.cljs$lang$maxFixedArity = 3);



/**
 * Protocol for adding associativity to collections.
 * @interface
 */
cljs.core.IAssociative = function(){};

var cljs$core$IAssociative$_contains_key_QMARK_$dyn_34773 = (function (coll,k){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._contains_key_QMARK_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__5351__auto__.call(null, coll,k));
} else {
var m__5349__auto__ = (cljs.core._contains_key_QMARK_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__5349__auto__.call(null, coll,k));
} else {
throw cljs.core.missing_protocol("IAssociative.-contains-key?",coll);
}
}
});
/**
 * Returns true if k is a key in coll.
 */
cljs.core._contains_key_QMARK_ = (function cljs$core$_contains_key_QMARK_(coll,k){
if((((!((coll == null)))) && ((!((coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 == null)))))){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll,k);
} else {
return cljs$core$IAssociative$_contains_key_QMARK_$dyn_34773(coll,k);
}
});

var cljs$core$IAssociative$_assoc$dyn_34774 = (function (coll,k,v){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._assoc[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,v) : m__5351__auto__.call(null, coll,k,v));
} else {
var m__5349__auto__ = (cljs.core._assoc["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,v) : m__5349__auto__.call(null, coll,k,v));
} else {
throw cljs.core.missing_protocol("IAssociative.-assoc",coll);
}
}
});
/**
 * Returns a new collection of coll with a mapping from key k to
 *   value v added to it.
 */
cljs.core._assoc = (function cljs$core$_assoc(coll,k,v){
if((((!((coll == null)))) && ((!((coll.cljs$core$IAssociative$_assoc$arity$3 == null)))))){
return coll.cljs$core$IAssociative$_assoc$arity$3(coll,k,v);
} else {
return cljs$core$IAssociative$_assoc$dyn_34774(coll,k,v);
}
});


/**
 * Protocol for implementing entry finding in collections.
 * @interface
 */
cljs.core.IFind = function(){};

var cljs$core$IFind$_find$dyn_34779 = (function (coll,k){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._find[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__5351__auto__.call(null, coll,k));
} else {
var m__5349__auto__ = (cljs.core._find["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__5349__auto__.call(null, coll,k));
} else {
throw cljs.core.missing_protocol("IFind.-find",coll);
}
}
});
/**
 * Returns the map entry for key, or nil if key not present.
 */
cljs.core._find = (function cljs$core$_find(coll,k){
if((((!((coll == null)))) && ((!((coll.cljs$core$IFind$_find$arity$2 == null)))))){
return coll.cljs$core$IFind$_find$arity$2(coll,k);
} else {
return cljs$core$IFind$_find$dyn_34779(coll,k);
}
});


/**
 * Protocol for adding mapping functionality to collections.
 * @interface
 */
cljs.core.IMap = function(){};

var cljs$core$IMap$_dissoc$dyn_34785 = (function (coll,k){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._dissoc[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__5351__auto__.call(null, coll,k));
} else {
var m__5349__auto__ = (cljs.core._dissoc["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__5349__auto__.call(null, coll,k));
} else {
throw cljs.core.missing_protocol("IMap.-dissoc",coll);
}
}
});
/**
 * Returns a new collection of coll without the mapping for key k.
 */
cljs.core._dissoc = (function cljs$core$_dissoc(coll,k){
if((((!((coll == null)))) && ((!((coll.cljs$core$IMap$_dissoc$arity$2 == null)))))){
return coll.cljs$core$IMap$_dissoc$arity$2(coll,k);
} else {
return cljs$core$IMap$_dissoc$dyn_34785(coll,k);
}
});


/**
 * Protocol for examining a map entry.
 * @interface
 */
cljs.core.IMapEntry = function(){};

var cljs$core$IMapEntry$_key$dyn_34789 = (function (coll){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._key[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5351__auto__.call(null, coll));
} else {
var m__5349__auto__ = (cljs.core._key["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5349__auto__.call(null, coll));
} else {
throw cljs.core.missing_protocol("IMapEntry.-key",coll);
}
}
});
/**
 * Returns the key of the map entry.
 */
cljs.core._key = (function cljs$core$_key(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IMapEntry$_key$arity$1 == null)))))){
return coll.cljs$core$IMapEntry$_key$arity$1(coll);
} else {
return cljs$core$IMapEntry$_key$dyn_34789(coll);
}
});

var cljs$core$IMapEntry$_val$dyn_34791 = (function (coll){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._val[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5351__auto__.call(null, coll));
} else {
var m__5349__auto__ = (cljs.core._val["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5349__auto__.call(null, coll));
} else {
throw cljs.core.missing_protocol("IMapEntry.-val",coll);
}
}
});
/**
 * Returns the value of the map entry.
 */
cljs.core._val = (function cljs$core$_val(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IMapEntry$_val$arity$1 == null)))))){
return coll.cljs$core$IMapEntry$_val$arity$1(coll);
} else {
return cljs$core$IMapEntry$_val$dyn_34791(coll);
}
});


/**
 * Protocol for adding set functionality to a collection.
 * @interface
 */
cljs.core.ISet = function(){};

var cljs$core$ISet$_disjoin$dyn_34792 = (function (coll,v){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._disjoin[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(coll,v) : m__5351__auto__.call(null, coll,v));
} else {
var m__5349__auto__ = (cljs.core._disjoin["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(coll,v) : m__5349__auto__.call(null, coll,v));
} else {
throw cljs.core.missing_protocol("ISet.-disjoin",coll);
}
}
});
/**
 * Returns a new collection of coll that does not contain v.
 */
cljs.core._disjoin = (function cljs$core$_disjoin(coll,v){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISet$_disjoin$arity$2 == null)))))){
return coll.cljs$core$ISet$_disjoin$arity$2(coll,v);
} else {
return cljs$core$ISet$_disjoin$dyn_34792(coll,v);
}
});


/**
 * Protocol for collections to provide access to their items as stacks. The top
 *   of the stack should be accessed in the most efficient way for the different
 *   data structures.
 * @interface
 */
cljs.core.IStack = function(){};

var cljs$core$IStack$_peek$dyn_34796 = (function (coll){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._peek[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5351__auto__.call(null, coll));
} else {
var m__5349__auto__ = (cljs.core._peek["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5349__auto__.call(null, coll));
} else {
throw cljs.core.missing_protocol("IStack.-peek",coll);
}
}
});
/**
 * Returns the item from the top of the stack. Is used by cljs.core/peek.
 */
cljs.core._peek = (function cljs$core$_peek(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IStack$_peek$arity$1 == null)))))){
return coll.cljs$core$IStack$_peek$arity$1(coll);
} else {
return cljs$core$IStack$_peek$dyn_34796(coll);
}
});

var cljs$core$IStack$_pop$dyn_34800 = (function (coll){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._pop[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5351__auto__.call(null, coll));
} else {
var m__5349__auto__ = (cljs.core._pop["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5349__auto__.call(null, coll));
} else {
throw cljs.core.missing_protocol("IStack.-pop",coll);
}
}
});
/**
 * Returns a new stack without the item on top of the stack. Is used
 *   by cljs.core/pop.
 */
cljs.core._pop = (function cljs$core$_pop(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IStack$_pop$arity$1 == null)))))){
return coll.cljs$core$IStack$_pop$arity$1(coll);
} else {
return cljs$core$IStack$_pop$dyn_34800(coll);
}
});


/**
 * Protocol for adding vector functionality to collections.
 * @interface
 */
cljs.core.IVector = function(){};

var cljs$core$IVector$_assoc_n$dyn_34806 = (function (coll,n,val){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._assoc_n[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,val) : m__5351__auto__.call(null, coll,n,val));
} else {
var m__5349__auto__ = (cljs.core._assoc_n["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,val) : m__5349__auto__.call(null, coll,n,val));
} else {
throw cljs.core.missing_protocol("IVector.-assoc-n",coll);
}
}
});
/**
 * Returns a new vector with value val added at position n.
 */
cljs.core._assoc_n = (function cljs$core$_assoc_n(coll,n,val){
if((((!((coll == null)))) && ((!((coll.cljs$core$IVector$_assoc_n$arity$3 == null)))))){
return coll.cljs$core$IVector$_assoc_n$arity$3(coll,n,val);
} else {
return cljs$core$IVector$_assoc_n$dyn_34806(coll,n,val);
}
});


/**
 * Protocol for adding dereference functionality to a reference.
 * @interface
 */
cljs.core.IDeref = function(){};

var cljs$core$IDeref$_deref$dyn_34811 = (function (o){
var x__5350__auto__ = (((o == null))?null:o);
var m__5351__auto__ = (cljs.core._deref[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__5351__auto__.call(null, o));
} else {
var m__5349__auto__ = (cljs.core._deref["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__5349__auto__.call(null, o));
} else {
throw cljs.core.missing_protocol("IDeref.-deref",o);
}
}
});
/**
 * Returns the value of the reference o.
 */
cljs.core._deref = (function cljs$core$_deref(o){
if((((!((o == null)))) && ((!((o.cljs$core$IDeref$_deref$arity$1 == null)))))){
return o.cljs$core$IDeref$_deref$arity$1(o);
} else {
return cljs$core$IDeref$_deref$dyn_34811(o);
}
});


/**
 * @interface
 */
cljs.core.IDerefWithTimeout = function(){};

var cljs$core$IDerefWithTimeout$_deref_with_timeout$dyn_34818 = (function (o,msec,timeout_val){
var x__5350__auto__ = (((o == null))?null:o);
var m__5351__auto__ = (cljs.core._deref_with_timeout[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(o,msec,timeout_val) : m__5351__auto__.call(null, o,msec,timeout_val));
} else {
var m__5349__auto__ = (cljs.core._deref_with_timeout["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(o,msec,timeout_val) : m__5349__auto__.call(null, o,msec,timeout_val));
} else {
throw cljs.core.missing_protocol("IDerefWithTimeout.-deref-with-timeout",o);
}
}
});
cljs.core._deref_with_timeout = (function cljs$core$_deref_with_timeout(o,msec,timeout_val){
if((((!((o == null)))) && ((!((o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3 == null)))))){
return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o,msec,timeout_val);
} else {
return cljs$core$IDerefWithTimeout$_deref_with_timeout$dyn_34818(o,msec,timeout_val);
}
});


/**
 * Protocol for accessing the metadata of an object.
 * @interface
 */
cljs.core.IMeta = function(){};

var cljs$core$IMeta$_meta$dyn_34821 = (function (o){
var x__5350__auto__ = (((o == null))?null:o);
var m__5351__auto__ = (cljs.core._meta[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__5351__auto__.call(null, o));
} else {
var m__5349__auto__ = (cljs.core._meta["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__5349__auto__.call(null, o));
} else {
throw cljs.core.missing_protocol("IMeta.-meta",o);
}
}
});
/**
 * Returns the metadata of object o.
 */
cljs.core._meta = (function cljs$core$_meta(o){
if((((!((o == null)))) && ((!((o.cljs$core$IMeta$_meta$arity$1 == null)))))){
return o.cljs$core$IMeta$_meta$arity$1(o);
} else {
return cljs$core$IMeta$_meta$dyn_34821(o);
}
});


/**
 * Protocol for adding metadata to an object.
 * @interface
 */
cljs.core.IWithMeta = function(){};

var cljs$core$IWithMeta$_with_meta$dyn_34838 = (function (o,meta){
var x__5350__auto__ = (((o == null))?null:o);
var m__5351__auto__ = (cljs.core._with_meta[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(o,meta) : m__5351__auto__.call(null, o,meta));
} else {
var m__5349__auto__ = (cljs.core._with_meta["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(o,meta) : m__5349__auto__.call(null, o,meta));
} else {
throw cljs.core.missing_protocol("IWithMeta.-with-meta",o);
}
}
});
/**
 * Returns a new object with value of o and metadata meta added to it.
 */
cljs.core._with_meta = (function cljs$core$_with_meta(o,meta){
if((((!((o == null)))) && ((!((o.cljs$core$IWithMeta$_with_meta$arity$2 == null)))))){
return o.cljs$core$IWithMeta$_with_meta$arity$2(o,meta);
} else {
return cljs$core$IWithMeta$_with_meta$dyn_34838(o,meta);
}
});


/**
 * Protocol for seq types that can reduce themselves.
 *   Called by cljs.core/reduce.
 * @interface
 */
cljs.core.IReduce = function(){};

var cljs$core$IReduce$_reduce$dyn_34854 = (function() {
var G__34855 = null;
var G__34855__2 = (function (coll,f){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._reduce[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(coll,f) : m__5351__auto__.call(null, coll,f));
} else {
var m__5349__auto__ = (cljs.core._reduce["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(coll,f) : m__5349__auto__.call(null, coll,f));
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
});
var G__34855__3 = (function (coll,f,start){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._reduce[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,start) : m__5351__auto__.call(null, coll,f,start));
} else {
var m__5349__auto__ = (cljs.core._reduce["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,start) : m__5349__auto__.call(null, coll,f,start));
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
});
G__34855 = function(coll,f,start){
switch(arguments.length){
case 2:
return G__34855__2.call(this,coll,f);
case 3:
return G__34855__3.call(this,coll,f,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34855.cljs$core$IFn$_invoke$arity$2 = G__34855__2;
G__34855.cljs$core$IFn$_invoke$arity$3 = G__34855__3;
return G__34855;
})()
;
/**
 * f should be a function of 2 arguments. If start is not supplied,
 *   returns the result of applying f to the first 2 items in coll, then
 *   applying f to that result and the 3rd item, etc.
 */
cljs.core._reduce = (function cljs$core$_reduce(var_args){
var G__33015 = arguments.length;
switch (G__33015) {
case 2:
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._reduce.cljs$core$IFn$_invoke$arity$2 = (function (coll,f){
if((((!((coll == null)))) && ((!((coll.cljs$core$IReduce$_reduce$arity$2 == null)))))){
return coll.cljs$core$IReduce$_reduce$arity$2(coll,f);
} else {
return cljs$core$IReduce$_reduce$dyn_34854(coll,f);
}
}));

(cljs.core._reduce.cljs$core$IFn$_invoke$arity$3 = (function (coll,f,start){
if((((!((coll == null)))) && ((!((coll.cljs$core$IReduce$_reduce$arity$3 == null)))))){
return coll.cljs$core$IReduce$_reduce$arity$3(coll,f,start);
} else {
return cljs$core$IReduce$_reduce$dyn_34854(coll,f,start);
}
}));

(cljs.core._reduce.cljs$lang$maxFixedArity = 3);



/**
 * Protocol for associative types that can reduce themselves
 *   via a function of key and val. Called by cljs.core/reduce-kv.
 * @interface
 */
cljs.core.IKVReduce = function(){};

var cljs$core$IKVReduce$_kv_reduce$dyn_34871 = (function (coll,f,init){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._kv_reduce[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,init) : m__5351__auto__.call(null, coll,f,init));
} else {
var m__5349__auto__ = (cljs.core._kv_reduce["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,init) : m__5349__auto__.call(null, coll,f,init));
} else {
throw cljs.core.missing_protocol("IKVReduce.-kv-reduce",coll);
}
}
});
/**
 * Reduces an associative collection and returns the result. f should be
 *   a function that takes three arguments.
 */
cljs.core._kv_reduce = (function cljs$core$_kv_reduce(coll,f,init){
if((((!((coll == null)))) && ((!((coll.cljs$core$IKVReduce$_kv_reduce$arity$3 == null)))))){
return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll,f,init);
} else {
return cljs$core$IKVReduce$_kv_reduce$dyn_34871(coll,f,init);
}
});


/**
 * Protocol for adding value comparison functionality to a type.
 * @interface
 */
cljs.core.IEquiv = function(){};

var cljs$core$IEquiv$_equiv$dyn_34891 = (function (o,other){
var x__5350__auto__ = (((o == null))?null:o);
var m__5351__auto__ = (cljs.core._equiv[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(o,other) : m__5351__auto__.call(null, o,other));
} else {
var m__5349__auto__ = (cljs.core._equiv["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(o,other) : m__5349__auto__.call(null, o,other));
} else {
throw cljs.core.missing_protocol("IEquiv.-equiv",o);
}
}
});
/**
 * Returns true if o and other are equal, false otherwise.
 */
cljs.core._equiv = (function cljs$core$_equiv(o,other){
if((((!((o == null)))) && ((!((o.cljs$core$IEquiv$_equiv$arity$2 == null)))))){
return o.cljs$core$IEquiv$_equiv$arity$2(o,other);
} else {
return cljs$core$IEquiv$_equiv$dyn_34891(o,other);
}
});


/**
 * Protocol for adding hashing functionality to a type.
 * @interface
 */
cljs.core.IHash = function(){};

var cljs$core$IHash$_hash$dyn_34902 = (function (o){
var x__5350__auto__ = (((o == null))?null:o);
var m__5351__auto__ = (cljs.core._hash[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__5351__auto__.call(null, o));
} else {
var m__5349__auto__ = (cljs.core._hash["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__5349__auto__.call(null, o));
} else {
throw cljs.core.missing_protocol("IHash.-hash",o);
}
}
});
/**
 * Returns the hash code of o.
 */
cljs.core._hash = (function cljs$core$_hash(o){
if((((!((o == null)))) && ((!((o.cljs$core$IHash$_hash$arity$1 == null)))))){
return o.cljs$core$IHash$_hash$arity$1(o);
} else {
return cljs$core$IHash$_hash$dyn_34902(o);
}
});


/**
 * Protocol for adding the ability to a type to be transformed into a sequence.
 * @interface
 */
cljs.core.ISeqable = function(){};

var cljs$core$ISeqable$_seq$dyn_34907 = (function (o){
var x__5350__auto__ = (((o == null))?null:o);
var m__5351__auto__ = (cljs.core._seq[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__5351__auto__.call(null, o));
} else {
var m__5349__auto__ = (cljs.core._seq["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__5349__auto__.call(null, o));
} else {
throw cljs.core.missing_protocol("ISeqable.-seq",o);
}
}
});
/**
 * Returns a seq of o, or nil if o is empty.
 */
cljs.core._seq = (function cljs$core$_seq(o){
if((((!((o == null)))) && ((!((o.cljs$core$ISeqable$_seq$arity$1 == null)))))){
return o.cljs$core$ISeqable$_seq$arity$1(o);
} else {
return cljs$core$ISeqable$_seq$dyn_34907(o);
}
});


/**
 * Marker interface indicating a persistent collection of sequential items
 * @interface
 */
cljs.core.ISequential = function(){};


/**
 * Marker interface indicating a persistent list
 * @interface
 */
cljs.core.IList = function(){};


/**
 * Marker interface indicating a record object
 * @interface
 */
cljs.core.IRecord = function(){};


/**
 * Protocol for reversing a seq.
 * @interface
 */
cljs.core.IReversible = function(){};

var cljs$core$IReversible$_rseq$dyn_34912 = (function (coll){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._rseq[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5351__auto__.call(null, coll));
} else {
var m__5349__auto__ = (cljs.core._rseq["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5349__auto__.call(null, coll));
} else {
throw cljs.core.missing_protocol("IReversible.-rseq",coll);
}
}
});
/**
 * Returns a seq of the items in coll in reversed order.
 */
cljs.core._rseq = (function cljs$core$_rseq(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IReversible$_rseq$arity$1 == null)))))){
return coll.cljs$core$IReversible$_rseq$arity$1(coll);
} else {
return cljs$core$IReversible$_rseq$dyn_34912(coll);
}
});


/**
 * Protocol for a collection which can represent their items
 *   in a sorted manner. 
 * @interface
 */
cljs.core.ISorted = function(){};

var cljs$core$ISorted$_sorted_seq$dyn_34914 = (function (coll,ascending_QMARK_){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._sorted_seq[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(coll,ascending_QMARK_) : m__5351__auto__.call(null, coll,ascending_QMARK_));
} else {
var m__5349__auto__ = (cljs.core._sorted_seq["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(coll,ascending_QMARK_) : m__5349__auto__.call(null, coll,ascending_QMARK_));
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq",coll);
}
}
});
/**
 * Returns a sorted seq from coll in either ascending or descending order.
 */
cljs.core._sorted_seq = (function cljs$core$_sorted_seq(coll,ascending_QMARK_){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_sorted_seq$arity$2 == null)))))){
return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll,ascending_QMARK_);
} else {
return cljs$core$ISorted$_sorted_seq$dyn_34914(coll,ascending_QMARK_);
}
});

var cljs$core$ISorted$_sorted_seq_from$dyn_34925 = (function (coll,k,ascending_QMARK_){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._sorted_seq_from[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,ascending_QMARK_) : m__5351__auto__.call(null, coll,k,ascending_QMARK_));
} else {
var m__5349__auto__ = (cljs.core._sorted_seq_from["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,ascending_QMARK_) : m__5349__auto__.call(null, coll,k,ascending_QMARK_));
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq-from",coll);
}
}
});
/**
 * Returns a sorted seq from coll in either ascending or descending order.
 *   If ascending is true, the result should contain all items which are > or >=
 *   than k. If ascending is false, the result should contain all items which
 *   are < or <= than k, e.g.
 *   (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 true) => (3 4 5)
 *   (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 false) => (3 2 1)
 */
cljs.core._sorted_seq_from = (function cljs$core$_sorted_seq_from(coll,k,ascending_QMARK_){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_sorted_seq_from$arity$3 == null)))))){
return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll,k,ascending_QMARK_);
} else {
return cljs$core$ISorted$_sorted_seq_from$dyn_34925(coll,k,ascending_QMARK_);
}
});

var cljs$core$ISorted$_entry_key$dyn_34931 = (function (coll,entry){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._entry_key[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(coll,entry) : m__5351__auto__.call(null, coll,entry));
} else {
var m__5349__auto__ = (cljs.core._entry_key["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(coll,entry) : m__5349__auto__.call(null, coll,entry));
} else {
throw cljs.core.missing_protocol("ISorted.-entry-key",coll);
}
}
});
/**
 * Returns the key for entry.
 */
cljs.core._entry_key = (function cljs$core$_entry_key(coll,entry){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_entry_key$arity$2 == null)))))){
return coll.cljs$core$ISorted$_entry_key$arity$2(coll,entry);
} else {
return cljs$core$ISorted$_entry_key$dyn_34931(coll,entry);
}
});

var cljs$core$ISorted$_comparator$dyn_34950 = (function (coll){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._comparator[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5351__auto__.call(null, coll));
} else {
var m__5349__auto__ = (cljs.core._comparator["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5349__auto__.call(null, coll));
} else {
throw cljs.core.missing_protocol("ISorted.-comparator",coll);
}
}
});
/**
 * Returns the comparator for coll.
 */
cljs.core._comparator = (function cljs$core$_comparator(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_comparator$arity$1 == null)))))){
return coll.cljs$core$ISorted$_comparator$arity$1(coll);
} else {
return cljs$core$ISorted$_comparator$dyn_34950(coll);
}
});


/**
 * Protocol for writing. Currently only implemented by StringBufferWriter.
 * @interface
 */
cljs.core.IWriter = function(){};

var cljs$core$IWriter$_write$dyn_34954 = (function (writer,s){
var x__5350__auto__ = (((writer == null))?null:writer);
var m__5351__auto__ = (cljs.core._write[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(writer,s) : m__5351__auto__.call(null, writer,s));
} else {
var m__5349__auto__ = (cljs.core._write["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(writer,s) : m__5349__auto__.call(null, writer,s));
} else {
throw cljs.core.missing_protocol("IWriter.-write",writer);
}
}
});
/**
 * Writes s with writer and returns the result.
 */
cljs.core._write = (function cljs$core$_write(writer,s){
if((((!((writer == null)))) && ((!((writer.cljs$core$IWriter$_write$arity$2 == null)))))){
return writer.cljs$core$IWriter$_write$arity$2(writer,s);
} else {
return cljs$core$IWriter$_write$dyn_34954(writer,s);
}
});

var cljs$core$IWriter$_flush$dyn_34959 = (function (writer){
var x__5350__auto__ = (((writer == null))?null:writer);
var m__5351__auto__ = (cljs.core._flush[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(writer) : m__5351__auto__.call(null, writer));
} else {
var m__5349__auto__ = (cljs.core._flush["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(writer) : m__5349__auto__.call(null, writer));
} else {
throw cljs.core.missing_protocol("IWriter.-flush",writer);
}
}
});
/**
 * Flush writer.
 */
cljs.core._flush = (function cljs$core$_flush(writer){
if((((!((writer == null)))) && ((!((writer.cljs$core$IWriter$_flush$arity$1 == null)))))){
return writer.cljs$core$IWriter$_flush$arity$1(writer);
} else {
return cljs$core$IWriter$_flush$dyn_34959(writer);
}
});


/**
 * The old IPrintable protocol's implementation consisted of building a giant
 * list of strings to concatenate.  This involved lots of concat calls,
 * intermediate vectors, and lazy-seqs, and was very slow in some older JS
 * engines.  IPrintWithWriter implements printing via the IWriter protocol, so it
 * be implemented efficiently in terms of e.g. a StringBuffer append.
 * @interface
 */
cljs.core.IPrintWithWriter = function(){};

var cljs$core$IPrintWithWriter$_pr_writer$dyn_34984 = (function (o,writer,opts){
var x__5350__auto__ = (((o == null))?null:o);
var m__5351__auto__ = (cljs.core._pr_writer[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(o,writer,opts) : m__5351__auto__.call(null, o,writer,opts));
} else {
var m__5349__auto__ = (cljs.core._pr_writer["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(o,writer,opts) : m__5349__auto__.call(null, o,writer,opts));
} else {
throw cljs.core.missing_protocol("IPrintWithWriter.-pr-writer",o);
}
}
});
cljs.core._pr_writer = (function cljs$core$_pr_writer(o,writer,opts){
if((((!((o == null)))) && ((!((o.cljs$core$IPrintWithWriter$_pr_writer$arity$3 == null)))))){
return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o,writer,opts);
} else {
return cljs$core$IPrintWithWriter$_pr_writer$dyn_34984(o,writer,opts);
}
});


/**
 * Protocol for types which can have a deferred realization. Currently only
 *   implemented by Delay and LazySeq.
 * @interface
 */
cljs.core.IPending = function(){};

var cljs$core$IPending$_realized_QMARK_$dyn_34985 = (function (x){
var x__5350__auto__ = (((x == null))?null:x);
var m__5351__auto__ = (cljs.core._realized_QMARK_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__5351__auto__.call(null, x));
} else {
var m__5349__auto__ = (cljs.core._realized_QMARK_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__5349__auto__.call(null, x));
} else {
throw cljs.core.missing_protocol("IPending.-realized?",x);
}
}
});
/**
 * Returns true if a value for x has been produced, false otherwise.
 */
cljs.core._realized_QMARK_ = (function cljs$core$_realized_QMARK_(x){
if((((!((x == null)))) && ((!((x.cljs$core$IPending$_realized_QMARK_$arity$1 == null)))))){
return x.cljs$core$IPending$_realized_QMARK_$arity$1(x);
} else {
return cljs$core$IPending$_realized_QMARK_$dyn_34985(x);
}
});


/**
 * Protocol for types that can be watched. Currently only implemented by Atom.
 * @interface
 */
cljs.core.IWatchable = function(){};

var cljs$core$IWatchable$_notify_watches$dyn_34986 = (function (this$,oldval,newval){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._notify_watches[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(this$,oldval,newval) : m__5351__auto__.call(null, this$,oldval,newval));
} else {
var m__5349__auto__ = (cljs.core._notify_watches["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(this$,oldval,newval) : m__5349__auto__.call(null, this$,oldval,newval));
} else {
throw cljs.core.missing_protocol("IWatchable.-notify-watches",this$);
}
}
});
/**
 * Calls all watchers with this, oldval and newval.
 */
cljs.core._notify_watches = (function cljs$core$_notify_watches(this$,oldval,newval){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IWatchable$_notify_watches$arity$3 == null)))))){
return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$,oldval,newval);
} else {
return cljs$core$IWatchable$_notify_watches$dyn_34986(this$,oldval,newval);
}
});

var cljs$core$IWatchable$_add_watch$dyn_34988 = (function (this$,key,f){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._add_watch[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(this$,key,f) : m__5351__auto__.call(null, this$,key,f));
} else {
var m__5349__auto__ = (cljs.core._add_watch["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(this$,key,f) : m__5349__auto__.call(null, this$,key,f));
} else {
throw cljs.core.missing_protocol("IWatchable.-add-watch",this$);
}
}
});
/**
 * Adds a watcher function f to this. Keys must be unique per reference,
 *   and can be used to remove the watch with -remove-watch.
 */
cljs.core._add_watch = (function cljs$core$_add_watch(this$,key,f){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IWatchable$_add_watch$arity$3 == null)))))){
return this$.cljs$core$IWatchable$_add_watch$arity$3(this$,key,f);
} else {
return cljs$core$IWatchable$_add_watch$dyn_34988(this$,key,f);
}
});

var cljs$core$IWatchable$_remove_watch$dyn_34991 = (function (this$,key){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (cljs.core._remove_watch[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(this$,key) : m__5351__auto__.call(null, this$,key));
} else {
var m__5349__auto__ = (cljs.core._remove_watch["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(this$,key) : m__5349__auto__.call(null, this$,key));
} else {
throw cljs.core.missing_protocol("IWatchable.-remove-watch",this$);
}
}
});
/**
 * Removes watcher that corresponds to key from this.
 */
cljs.core._remove_watch = (function cljs$core$_remove_watch(this$,key){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IWatchable$_remove_watch$arity$2 == null)))))){
return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$,key);
} else {
return cljs$core$IWatchable$_remove_watch$dyn_34991(this$,key);
}
});


/**
 * Protocol for collections which can transformed to transients.
 * @interface
 */
cljs.core.IEditableCollection = function(){};

var cljs$core$IEditableCollection$_as_transient$dyn_35000 = (function (coll){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._as_transient[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5351__auto__.call(null, coll));
} else {
var m__5349__auto__ = (cljs.core._as_transient["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5349__auto__.call(null, coll));
} else {
throw cljs.core.missing_protocol("IEditableCollection.-as-transient",coll);
}
}
});
/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core._as_transient = (function cljs$core$_as_transient(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IEditableCollection$_as_transient$arity$1 == null)))))){
return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);
} else {
return cljs$core$IEditableCollection$_as_transient$dyn_35000(coll);
}
});


/**
 * Protocol for adding basic functionality to transient collections.
 * @interface
 */
cljs.core.ITransientCollection = function(){};

var cljs$core$ITransientCollection$_conj_BANG_$dyn_35010 = (function (tcoll,val){
var x__5350__auto__ = (((tcoll == null))?null:tcoll);
var m__5351__auto__ = (cljs.core._conj_BANG_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,val) : m__5351__auto__.call(null, tcoll,val));
} else {
var m__5349__auto__ = (cljs.core._conj_BANG_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,val) : m__5349__auto__.call(null, tcoll,val));
} else {
throw cljs.core.missing_protocol("ITransientCollection.-conj!",tcoll);
}
}
});
/**
 * Adds value val to tcoll and returns tcoll.
 */
cljs.core._conj_BANG_ = (function cljs$core$_conj_BANG_(tcoll,val){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2 == null)))))){
return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll,val);
} else {
return cljs$core$ITransientCollection$_conj_BANG_$dyn_35010(tcoll,val);
}
});

var cljs$core$ITransientCollection$_persistent_BANG_$dyn_35013 = (function (tcoll){
var x__5350__auto__ = (((tcoll == null))?null:tcoll);
var m__5351__auto__ = (cljs.core._persistent_BANG_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__5351__auto__.call(null, tcoll));
} else {
var m__5349__auto__ = (cljs.core._persistent_BANG_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__5349__auto__.call(null, tcoll));
} else {
throw cljs.core.missing_protocol("ITransientCollection.-persistent!",tcoll);
}
}
});
/**
 * Creates a persistent data structure from tcoll and returns it.
 */
cljs.core._persistent_BANG_ = (function cljs$core$_persistent_BANG_(tcoll){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 == null)))))){
return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);
} else {
return cljs$core$ITransientCollection$_persistent_BANG_$dyn_35013(tcoll);
}
});


/**
 * Protocol for adding associativity to transient collections.
 * @interface
 */
cljs.core.ITransientAssociative = function(){};

var cljs$core$ITransientAssociative$_assoc_BANG_$dyn_35017 = (function (tcoll,key,val){
var x__5350__auto__ = (((tcoll == null))?null:tcoll);
var m__5351__auto__ = (cljs.core._assoc_BANG_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,key,val) : m__5351__auto__.call(null, tcoll,key,val));
} else {
var m__5349__auto__ = (cljs.core._assoc_BANG_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,key,val) : m__5349__auto__.call(null, tcoll,key,val));
} else {
throw cljs.core.missing_protocol("ITransientAssociative.-assoc!",tcoll);
}
}
});
/**
 * Returns a new transient collection of tcoll with a mapping from key to
 *   val added to it.
 */
cljs.core._assoc_BANG_ = (function cljs$core$_assoc_BANG_(tcoll,key,val){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 == null)))))){
return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll,key,val);
} else {
return cljs$core$ITransientAssociative$_assoc_BANG_$dyn_35017(tcoll,key,val);
}
});


/**
 * Protocol for adding mapping functionality to transient collections.
 * @interface
 */
cljs.core.ITransientMap = function(){};

var cljs$core$ITransientMap$_dissoc_BANG_$dyn_35018 = (function (tcoll,key){
var x__5350__auto__ = (((tcoll == null))?null:tcoll);
var m__5351__auto__ = (cljs.core._dissoc_BANG_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,key) : m__5351__auto__.call(null, tcoll,key));
} else {
var m__5349__auto__ = (cljs.core._dissoc_BANG_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,key) : m__5349__auto__.call(null, tcoll,key));
} else {
throw cljs.core.missing_protocol("ITransientMap.-dissoc!",tcoll);
}
}
});
/**
 * Returns a new transient collection of tcoll without the mapping for key.
 */
cljs.core._dissoc_BANG_ = (function cljs$core$_dissoc_BANG_(tcoll,key){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 == null)))))){
return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll,key);
} else {
return cljs$core$ITransientMap$_dissoc_BANG_$dyn_35018(tcoll,key);
}
});


/**
 * Protocol for adding vector functionality to transient collections.
 * @interface
 */
cljs.core.ITransientVector = function(){};

var cljs$core$ITransientVector$_assoc_n_BANG_$dyn_35022 = (function (tcoll,n,val){
var x__5350__auto__ = (((tcoll == null))?null:tcoll);
var m__5351__auto__ = (cljs.core._assoc_n_BANG_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,n,val) : m__5351__auto__.call(null, tcoll,n,val));
} else {
var m__5349__auto__ = (cljs.core._assoc_n_BANG_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,n,val) : m__5349__auto__.call(null, tcoll,n,val));
} else {
throw cljs.core.missing_protocol("ITransientVector.-assoc-n!",tcoll);
}
}
});
/**
 * Returns tcoll with value val added at position n.
 */
cljs.core._assoc_n_BANG_ = (function cljs$core$_assoc_n_BANG_(tcoll,n,val){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 == null)))))){
return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll,n,val);
} else {
return cljs$core$ITransientVector$_assoc_n_BANG_$dyn_35022(tcoll,n,val);
}
});

var cljs$core$ITransientVector$_pop_BANG_$dyn_35026 = (function (tcoll){
var x__5350__auto__ = (((tcoll == null))?null:tcoll);
var m__5351__auto__ = (cljs.core._pop_BANG_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__5351__auto__.call(null, tcoll));
} else {
var m__5349__auto__ = (cljs.core._pop_BANG_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__5349__auto__.call(null, tcoll));
} else {
throw cljs.core.missing_protocol("ITransientVector.-pop!",tcoll);
}
}
});
/**
 * Returns tcoll with the last item removed from it.
 */
cljs.core._pop_BANG_ = (function cljs$core$_pop_BANG_(tcoll){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1 == null)))))){
return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);
} else {
return cljs$core$ITransientVector$_pop_BANG_$dyn_35026(tcoll);
}
});


/**
 * Protocol for adding set functionality to a transient collection.
 * @interface
 */
cljs.core.ITransientSet = function(){};

var cljs$core$ITransientSet$_disjoin_BANG_$dyn_35033 = (function (tcoll,v){
var x__5350__auto__ = (((tcoll == null))?null:tcoll);
var m__5351__auto__ = (cljs.core._disjoin_BANG_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,v) : m__5351__auto__.call(null, tcoll,v));
} else {
var m__5349__auto__ = (cljs.core._disjoin_BANG_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,v) : m__5349__auto__.call(null, tcoll,v));
} else {
throw cljs.core.missing_protocol("ITransientSet.-disjoin!",tcoll);
}
}
});
/**
 * Returns tcoll without v.
 */
cljs.core._disjoin_BANG_ = (function cljs$core$_disjoin_BANG_(tcoll,v){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 == null)))))){
return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll,v);
} else {
return cljs$core$ITransientSet$_disjoin_BANG_$dyn_35033(tcoll,v);
}
});


/**
 * Protocol for values that can be compared.
 * @interface
 */
cljs.core.IComparable = function(){};

var cljs$core$IComparable$_compare$dyn_35034 = (function (x,y){
var x__5350__auto__ = (((x == null))?null:x);
var m__5351__auto__ = (cljs.core._compare[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(x,y) : m__5351__auto__.call(null, x,y));
} else {
var m__5349__auto__ = (cljs.core._compare["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(x,y) : m__5349__auto__.call(null, x,y));
} else {
throw cljs.core.missing_protocol("IComparable.-compare",x);
}
}
});
/**
 * Returns a negative number, zero, or a positive number when x is logically
 *   'less than', 'equal to', or 'greater than' y.
 */
cljs.core._compare = (function cljs$core$_compare(x,y){
if((((!((x == null)))) && ((!((x.cljs$core$IComparable$_compare$arity$2 == null)))))){
return x.cljs$core$IComparable$_compare$arity$2(x,y);
} else {
return cljs$core$IComparable$_compare$dyn_35034(x,y);
}
});


/**
 * Protocol for accessing the items of a chunk.
 * @interface
 */
cljs.core.IChunk = function(){};

var cljs$core$IChunk$_drop_first$dyn_35035 = (function (coll){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._drop_first[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5351__auto__.call(null, coll));
} else {
var m__5349__auto__ = (cljs.core._drop_first["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5349__auto__.call(null, coll));
} else {
throw cljs.core.missing_protocol("IChunk.-drop-first",coll);
}
}
});
/**
 * Return a new chunk of coll with the first item removed.
 */
cljs.core._drop_first = (function cljs$core$_drop_first(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunk$_drop_first$arity$1 == null)))))){
return coll.cljs$core$IChunk$_drop_first$arity$1(coll);
} else {
return cljs$core$IChunk$_drop_first$dyn_35035(coll);
}
});


/**
 * Protocol for accessing a collection as sequential chunks.
 * @interface
 */
cljs.core.IChunkedSeq = function(){};

var cljs$core$IChunkedSeq$_chunked_first$dyn_35036 = (function (coll){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._chunked_first[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5351__auto__.call(null, coll));
} else {
var m__5349__auto__ = (cljs.core._chunked_first["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5349__auto__.call(null, coll));
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-first",coll);
}
}
});
/**
 * Returns the first chunk in coll.
 */
cljs.core._chunked_first = (function cljs$core$_chunked_first(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunkedSeq$_chunked_first$arity$1 == null)))))){
return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);
} else {
return cljs$core$IChunkedSeq$_chunked_first$dyn_35036(coll);
}
});

var cljs$core$IChunkedSeq$_chunked_rest$dyn_35042 = (function (coll){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._chunked_rest[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5351__auto__.call(null, coll));
} else {
var m__5349__auto__ = (cljs.core._chunked_rest["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5349__auto__.call(null, coll));
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-rest",coll);
}
}
});
/**
 * Return a new collection of coll with the first chunk removed.
 */
cljs.core._chunked_rest = (function cljs$core$_chunked_rest(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1 == null)))))){
return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);
} else {
return cljs$core$IChunkedSeq$_chunked_rest$dyn_35042(coll);
}
});


/**
 * Protocol for accessing the chunks of a collection.
 * @interface
 */
cljs.core.IChunkedNext = function(){};

var cljs$core$IChunkedNext$_chunked_next$dyn_35055 = (function (coll){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._chunked_next[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5351__auto__.call(null, coll));
} else {
var m__5349__auto__ = (cljs.core._chunked_next["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5349__auto__.call(null, coll));
} else {
throw cljs.core.missing_protocol("IChunkedNext.-chunked-next",coll);
}
}
});
/**
 * Returns a new collection of coll without the first chunk.
 */
cljs.core._chunked_next = (function cljs$core$_chunked_next(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunkedNext$_chunked_next$arity$1 == null)))))){
return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);
} else {
return cljs$core$IChunkedNext$_chunked_next$dyn_35055(coll);
}
});


/**
 * Protocol for adding a name.
 * @interface
 */
cljs.core.INamed = function(){};

var cljs$core$INamed$_name$dyn_35069 = (function (x){
var x__5350__auto__ = (((x == null))?null:x);
var m__5351__auto__ = (cljs.core._name[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__5351__auto__.call(null, x));
} else {
var m__5349__auto__ = (cljs.core._name["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__5349__auto__.call(null, x));
} else {
throw cljs.core.missing_protocol("INamed.-name",x);
}
}
});
/**
 * Returns the name String of x.
 */
cljs.core._name = (function cljs$core$_name(x){
if((((!((x == null)))) && ((!((x.cljs$core$INamed$_name$arity$1 == null)))))){
return x.cljs$core$INamed$_name$arity$1(x);
} else {
return cljs$core$INamed$_name$dyn_35069(x);
}
});

var cljs$core$INamed$_namespace$dyn_35072 = (function (x){
var x__5350__auto__ = (((x == null))?null:x);
var m__5351__auto__ = (cljs.core._namespace[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__5351__auto__.call(null, x));
} else {
var m__5349__auto__ = (cljs.core._namespace["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__5349__auto__.call(null, x));
} else {
throw cljs.core.missing_protocol("INamed.-namespace",x);
}
}
});
/**
 * Returns the namespace String of x.
 */
cljs.core._namespace = (function cljs$core$_namespace(x){
if((((!((x == null)))) && ((!((x.cljs$core$INamed$_namespace$arity$1 == null)))))){
return x.cljs$core$INamed$_namespace$arity$1(x);
} else {
return cljs$core$INamed$_namespace$dyn_35072(x);
}
});


/**
 * Marker protocol indicating an atom.
 * @interface
 */
cljs.core.IAtom = function(){};


/**
 * Protocol for adding resetting functionality.
 * @interface
 */
cljs.core.IReset = function(){};

var cljs$core$IReset$_reset_BANG_$dyn_35078 = (function (o,new_value){
var x__5350__auto__ = (((o == null))?null:o);
var m__5351__auto__ = (cljs.core._reset_BANG_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__5351__auto__.call(null, o,new_value));
} else {
var m__5349__auto__ = (cljs.core._reset_BANG_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__5349__auto__.call(null, o,new_value));
} else {
throw cljs.core.missing_protocol("IReset.-reset!",o);
}
}
});
/**
 * Sets the value of o to new-value.
 */
cljs.core._reset_BANG_ = (function cljs$core$_reset_BANG_(o,new_value){
if((((!((o == null)))) && ((!((o.cljs$core$IReset$_reset_BANG_$arity$2 == null)))))){
return o.cljs$core$IReset$_reset_BANG_$arity$2(o,new_value);
} else {
return cljs$core$IReset$_reset_BANG_$dyn_35078(o,new_value);
}
});


/**
 * Protocol for adding swapping functionality.
 * @interface
 */
cljs.core.ISwap = function(){};

var cljs$core$ISwap$_swap_BANG_$dyn_35079 = (function() {
var G__35080 = null;
var G__35080__2 = (function (o,f){
var x__5350__auto__ = (((o == null))?null:o);
var m__5351__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(o,f) : m__5351__auto__.call(null, o,f));
} else {
var m__5349__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(o,f) : m__5349__auto__.call(null, o,f));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
});
var G__35080__3 = (function (o,f,a){
var x__5350__auto__ = (((o == null))?null:o);
var m__5351__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(o,f,a) : m__5351__auto__.call(null, o,f,a));
} else {
var m__5349__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(o,f,a) : m__5349__auto__.call(null, o,f,a));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
});
var G__35080__4 = (function (o,f,a,b){
var x__5350__auto__ = (((o == null))?null:o);
var m__5351__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$4(o,f,a,b) : m__5351__auto__.call(null, o,f,a,b));
} else {
var m__5349__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$4(o,f,a,b) : m__5349__auto__.call(null, o,f,a,b));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
});
var G__35080__5 = (function (o,f,a,b,xs){
var x__5350__auto__ = (((o == null))?null:o);
var m__5351__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$5 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs) : m__5351__auto__.call(null, o,f,a,b,xs));
} else {
var m__5349__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$5 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs) : m__5349__auto__.call(null, o,f,a,b,xs));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
});
G__35080 = function(o,f,a,b,xs){
switch(arguments.length){
case 2:
return G__35080__2.call(this,o,f);
case 3:
return G__35080__3.call(this,o,f,a);
case 4:
return G__35080__4.call(this,o,f,a,b);
case 5:
return G__35080__5.call(this,o,f,a,b,xs);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35080.cljs$core$IFn$_invoke$arity$2 = G__35080__2;
G__35080.cljs$core$IFn$_invoke$arity$3 = G__35080__3;
G__35080.cljs$core$IFn$_invoke$arity$4 = G__35080__4;
G__35080.cljs$core$IFn$_invoke$arity$5 = G__35080__5;
return G__35080;
})()
;
/**
 * Swaps the value of o to be (apply f current-value-of-atom args).
 */
cljs.core._swap_BANG_ = (function cljs$core$_swap_BANG_(var_args){
var G__33017 = arguments.length;
switch (G__33017) {
case 2:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (o,f){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$2 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$2(o,f);
} else {
return cljs$core$ISwap$_swap_BANG_$dyn_35079(o,f);
}
}));

(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (o,f,a){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$3 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$3(o,f,a);
} else {
return cljs$core$ISwap$_swap_BANG_$dyn_35079(o,f,a);
}
}));

(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (o,f,a,b){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$4 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$4(o,f,a,b);
} else {
return cljs$core$ISwap$_swap_BANG_$dyn_35079(o,f,a,b);
}
}));

(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (o,f,a,b,xs){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$5 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$5(o,f,a,b,xs);
} else {
return cljs$core$ISwap$_swap_BANG_$dyn_35079(o,f,a,b,xs);
}
}));

(cljs.core._swap_BANG_.cljs$lang$maxFixedArity = 5);



/**
 * Protocol for adding volatile functionality.
 * @interface
 */
cljs.core.IVolatile = function(){};

var cljs$core$IVolatile$_vreset_BANG_$dyn_35094 = (function (o,new_value){
var x__5350__auto__ = (((o == null))?null:o);
var m__5351__auto__ = (cljs.core._vreset_BANG_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__5351__auto__.call(null, o,new_value));
} else {
var m__5349__auto__ = (cljs.core._vreset_BANG_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__5349__auto__.call(null, o,new_value));
} else {
throw cljs.core.missing_protocol("IVolatile.-vreset!",o);
}
}
});
/**
 * Sets the value of volatile o to new-value without regard for the
 *   current value. Returns new-value.
 */
cljs.core._vreset_BANG_ = (function cljs$core$_vreset_BANG_(o,new_value){
if((((!((o == null)))) && ((!((o.cljs$core$IVolatile$_vreset_BANG_$arity$2 == null)))))){
return o.cljs$core$IVolatile$_vreset_BANG_$arity$2(o,new_value);
} else {
return cljs$core$IVolatile$_vreset_BANG_$dyn_35094(o,new_value);
}
});


/**
 * Protocol for iterating over a collection.
 * @interface
 */
cljs.core.IIterable = function(){};

var cljs$core$IIterable$_iterator$dyn_35098 = (function (coll){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._iterator[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5351__auto__.call(null, coll));
} else {
var m__5349__auto__ = (cljs.core._iterator["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5349__auto__.call(null, coll));
} else {
throw cljs.core.missing_protocol("IIterable.-iterator",coll);
}
}
});
/**
 * Returns an iterator for coll.
 */
cljs.core._iterator = (function cljs$core$_iterator(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IIterable$_iterator$arity$1 == null)))))){
return coll.cljs$core$IIterable$_iterator$arity$1(coll);
} else {
return cljs$core$IIterable$_iterator$dyn_35098(coll);
}
});


/**
 * Protocol for persistent or algorithmically defined collections to provide a
 *   means of dropping N items that is more efficient than sequential walking.
 * @interface
 */
cljs.core.IDrop = function(){};

var cljs$core$IDrop$_drop$dyn_35099 = (function (coll,n){
var x__5350__auto__ = (((coll == null))?null:coll);
var m__5351__auto__ = (cljs.core._drop[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__5351__auto__.call(null, coll,n));
} else {
var m__5349__auto__ = (cljs.core._drop["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__5349__auto__.call(null, coll,n));
} else {
throw cljs.core.missing_protocol("IDrop.-drop",coll);
}
}
});
/**
 * Returns a collection that is ISequential, ISeq, and IReduce, or nil if past
 *   the end. The number of items to drop n must be > 0. It is also useful if the
 *   returned coll implements IDrop for subsequent use in a partition-like scenario.
 */
cljs.core._drop = (function cljs$core$_drop(coll,n){
if((((!((coll == null)))) && ((!((coll.cljs$core$IDrop$_drop$arity$2 == null)))))){
return coll.cljs$core$IDrop$_drop$arity$2(coll,n);
} else {
return cljs$core$IDrop$_drop$dyn_35099(coll,n);
}
});


/**
* @constructor
 * @implements {cljs.core.IWriter}
*/
cljs.core.StringBufferWriter = (function (sb){
this.sb = sb;
this.cljs$lang$protocol_mask$partition0$ = 1073741824;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2 = (function (_,s){
var self__ = this;
var ___$1 = this;
return self__.sb.append(s);
}));

(cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return null;
}));

(cljs.core.StringBufferWriter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"sb","sb",-1249746442,null)], null);
}));

(cljs.core.StringBufferWriter.cljs$lang$type = true);

(cljs.core.StringBufferWriter.cljs$lang$ctorStr = "cljs.core/StringBufferWriter");

(cljs.core.StringBufferWriter.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/StringBufferWriter");
}));

/**
 * Positional factory function for cljs.core/StringBufferWriter.
 */
cljs.core.__GT_StringBufferWriter = (function cljs$core$__GT_StringBufferWriter(sb){
return (new cljs.core.StringBufferWriter(sb));
});

/**
 * Support so that collections can implement toString without
 * loading all the printing machinery.
 */
cljs.core.pr_str_STAR_ = (function cljs$core$pr_str_STAR_(obj){
var sb = (new goog.string.StringBuffer());
var writer = (new cljs.core.StringBufferWriter(sb));
obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null, writer,cljs.core.pr_opts());

writer.cljs$core$IWriter$_flush$arity$1(null, );

return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb);
});
cljs.core.int_rotate_left = (function cljs$core$int_rotate_left(x,n){
return ((x << n) | (x >>> (- n)));
});
if((((typeof Math !== 'undefined') && (typeof Math.imul !== 'undefined')) && ((!((Math.imul((4294967295),(5)) === (0))))))){
cljs.core.imul = (function cljs$core$imul(a,b){
return Math.imul(a,b);
});
} else {
cljs.core.imul = (function cljs$core$imul(a,b){
var ah = ((a >>> (16)) & (65535));
var al = (a & (65535));
var bh = ((b >>> (16)) & (65535));
var bl = (b & (65535));
return (((al * bl) + ((((ah * bl) + (al * bh)) << (16)) >>> (0))) | (0));
});
}
cljs.core.m3_seed = (0);
cljs.core.m3_C1 = ((3432918353) | (0));
cljs.core.m3_C2 = ((461845907) | (0));
cljs.core.m3_mix_K1 = (function cljs$core$m3_mix_K1(k1){
return cljs.core.imul(cljs.core.int_rotate_left(cljs.core.imul((k1 | (0)),cljs.core.m3_C1),(15)),cljs.core.m3_C2);
});
cljs.core.m3_mix_H1 = (function cljs$core$m3_mix_H1(h1,k1){
return ((cljs.core.imul(cljs.core.int_rotate_left(((h1 | (0)) ^ (k1 | (0))),(13)),(5)) + ((3864292196) | (0))) | (0));
});
cljs.core.m3_fmix = (function cljs$core$m3_fmix(h1,len){
var h1__$1 = (h1 | (0));
var h1__$2 = (h1__$1 ^ len);
var h1__$3 = (h1__$2 ^ (h1__$2 >>> (16)));
var h1__$4 = cljs.core.imul(h1__$3,((2246822507) | (0)));
var h1__$5 = (h1__$4 ^ (h1__$4 >>> (13)));
var h1__$6 = cljs.core.imul(h1__$5,((3266489909) | (0)));
return (h1__$6 ^ (h1__$6 >>> (16)));
});
cljs.core.m3_hash_int = (function cljs$core$m3_hash_int(in$){
if((in$ === (0))){
return in$;
} else {
var k1 = cljs.core.m3_mix_K1(in$);
var h1 = cljs.core.m3_mix_H1(cljs.core.m3_seed,k1);
return cljs.core.m3_fmix(h1,(4));
}
});
cljs.core.hash_long = (function cljs$core$hash_long(high,low){
return (high ^ low);
});
cljs.core.hash_double = (function cljs$core$hash_double(f){
var arr = (function (){var G__33018 = (new Float64Array((1)));
(G__33018[(0)] = f);

return G__33018;
})();
var buf = arr.buffer;
var high = (new DataView(buf,(0),(4))).getInt32();
var low = (new DataView(buf,(4),(4))).getInt32();
return cljs.core.hash_long(high,low);
});
cljs.core.m3_hash_unencoded_chars = (function cljs$core$m3_hash_unencoded_chars(in$){
var h1 = (function (){var i = (1);
var h1 = cljs.core.m3_seed;
while(true){
if((i < in$.length)){
var G__35118 = (i + (2));
var G__35119 = cljs.core.m3_mix_H1(h1,cljs.core.m3_mix_K1((in$.charCodeAt((i - (1))) | (in$.charCodeAt(i) << (16)))));
i = G__35118;
h1 = G__35119;
continue;
} else {
return h1;
}
break;
}
})();
var h1__$1 = ((((in$.length & (1)) === (1)))?(h1 ^ cljs.core.m3_mix_K1(in$.charCodeAt((in$.length - (1))))):h1);
return cljs.core.m3_fmix(h1__$1,cljs.core.imul((2),in$.length));
});



cljs.core.string_hash_cache = ({});
cljs.core.string_hash_cache_count = (0);
cljs.core.hash_string_STAR_ = (function cljs$core$hash_string_STAR_(s){
if((!((s == null)))){
var len = s.length;
if((len > (0))){
var i = (0);
var hash = (0);
while(true){
if((i < len)){
var G__35129 = (i + (1));
var G__35130 = (cljs.core.imul((31),hash) + s.charCodeAt(i));
i = G__35129;
hash = G__35130;
continue;
} else {
return hash;
}
break;
}
} else {
return (0);
}
} else {
return (0);
}
});
cljs.core.add_to_string_hash_cache = (function cljs$core$add_to_string_hash_cache(k){
var h = cljs.core.hash_string_STAR_(k);
cljs.core.goog$module$goog$object.set(cljs.core.string_hash_cache,k,h);

(cljs.core.string_hash_cache_count = (cljs.core.string_hash_cache_count + (1)));

return h;
});
cljs.core.hash_string = (function cljs$core$hash_string(k){
if((cljs.core.string_hash_cache_count > (255))){
(cljs.core.string_hash_cache = ({}));

(cljs.core.string_hash_cache_count = (0));
} else {
}

if((k == null)){
return (0);
} else {
var h = (cljs.core.string_hash_cache[k]);
if(typeof h === 'number'){
return h;
} else {
return cljs.core.add_to_string_hash_cache(k);
}
}
});
/**
 * Returns the hash code of its argument. Note this is the hash code
 * consistent with =.
 */
cljs.core.hash = (function cljs$core$hash(o){
if((((!((o == null))))?(((((o.cljs$lang$protocol_mask$partition0$ & (4194304))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IHash$))))?true:false):false)){
return (o.cljs$core$IHash$_hash$arity$1(null, ) ^ (0));
} else {
if(typeof o === 'number'){
if(isFinite(o)){
if((!(Number.isSafeInteger(o)))){
return cljs.core.hash_double(o);
} else {
return (Math.floor(o) % (2147483647));
}
} else {
var G__33024 = o;
switch (G__33024) {
case Infinity:
return (2146435072);

break;
case -Infinity:
return (-1048576);

break;
default:
return (2146959360);

}
}
} else {
if(o === true){
return (1231);
} else {
if(o === false){
return (1237);
} else {
if(typeof o === 'string'){
return cljs.core.m3_hash_int(cljs.core.hash_string(o));
} else {
if((o instanceof Date)){
return (o.valueOf() ^ (0));
} else {
if((o == null)){
return (0);
} else {
return (cljs.core._hash(o) ^ (0));

}
}
}
}
}
}
}
});
cljs.core.hash_combine = (function cljs$core$hash_combine(seed,hash){
return (seed ^ (((hash + (2654435769)) + (seed << (6))) + (seed >> (2))));
});
/**
 * Evaluates x and tests if it is an instance of the type
 *   c. Returns true or false
 */
cljs.core.instance_QMARK_ = (function cljs$core$instance_QMARK_(c,x){
return (x instanceof c);
});
/**
 * Return true if x is a Symbol
 */
cljs.core.symbol_QMARK_ = (function cljs$core$symbol_QMARK_(x){
return (x instanceof cljs.core.Symbol);
});
cljs.core.hash_symbol = (function cljs$core$hash_symbol(sym){
return cljs.core.hash_combine(cljs.core.m3_hash_unencoded_chars(sym.name),cljs.core.hash_string(sym.ns));
});
cljs.core.compare_symbols = (function cljs$core$compare_symbols(a,b){
if((a.str === b.str)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__5000__auto__ = cljs.core.not(a.ns);
if(and__5000__auto__){
return b.ns;
} else {
return and__5000__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = cljs.core.goog$module$goog$array.defaultCompare(a.ns,b.ns);
if(((0) === nsc)){
return cljs.core.goog$module$goog$array.defaultCompare(a.name,b.name);
} else {
return nsc;
}
}
} else {
return cljs.core.goog$module$goog$array.defaultCompare(a.name,b.name);

}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.INamed}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.Symbol = (function (ns,name,str,_hash,_meta){
this.ns = ns;
this.name = name;
this.str = str;
this._hash = _hash;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 2154168321;
this.cljs$lang$protocol_mask$partition1$ = 4096;
});
(cljs.core.Symbol.prototype.toString = (function (){
var self__ = this;
var _ = this;
return self__.str;
}));

(cljs.core.Symbol.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
}));

(cljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Symbol)){
return (self__.str === other.str);
} else {
return false;
}
}));

(cljs.core.Symbol.prototype.call = (function (unused__11804__auto__){
var self__ = this;
var self__ = this;
var G__33026 = (arguments.length - (1));
switch (G__33026) {
case (1):
return self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));

break;
case (2):
return self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(cljs.core.Symbol.prototype.apply = (function (self__,args33025){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args33025)));
}));

(cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var sym = this;
return (cljs.core.get.cljs$core$IFn$_invoke$arity$2 ? cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,sym) : cljs.core.get.call(null, coll,sym));
}));

(cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var sym = this;
return (cljs.core.get.cljs$core$IFn$_invoke$arity$3 ? cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found) : cljs.core.get.call(null, coll,sym,not_found));
}));

(cljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
}));

(cljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Symbol(self__.ns,self__.name,self__.str,self__._hash,new_meta));
}));

(cljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1 = (function (sym){
var self__ = this;
var sym__$1 = this;
var h__5111__auto__ = self__._hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_symbol(sym__$1);
(self__._hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
}));

(cljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
}));

(cljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,self__.str);
}));

(cljs.core.Symbol.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ns","ns",2082130287,null),new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_hash","_hash",-2130838312,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
}));

(cljs.core.Symbol.cljs$lang$type = true);

(cljs.core.Symbol.cljs$lang$ctorStr = "cljs.core/Symbol");

(cljs.core.Symbol.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/Symbol");
}));

/**
 * Positional factory function for cljs.core/Symbol.
 */
cljs.core.__GT_Symbol = (function cljs$core$__GT_Symbol(ns,name,str,_hash,_meta){
return (new cljs.core.Symbol(ns,name,str,_hash,_meta));
});

/**
 * Returns true if v is of type cljs.core.Var
 */
cljs.core.var_QMARK_ = (function cljs$core$var_QMARK_(v){
return (v instanceof cljs.core.Var);
});
/**
 * Returns a Symbol with the given namespace and name. Arity-1 works
 *   on strings, keywords, and vars.
 */
cljs.core.symbol = (function cljs$core$symbol(var_args){
var G__33028 = arguments.length;
switch (G__33028) {
case 1:
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1 = (function (name){
while(true){
if((name instanceof cljs.core.Symbol)){
return name;
} else {
if(typeof name === 'string'){
var idx = name.indexOf("/");
if((idx < (1))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(null,name);
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(name.substring((0),idx),name.substring((idx + (1)),name.length));
}
} else {
if(cljs.core.var_QMARK_(name)){
return name.sym;
} else {
if((name instanceof cljs.core.Keyword)){
var G__35191 = name.fqn;
name = G__35191;
continue;
} else {
throw (new Error("no conversion to symbol"));

}
}
}
}
break;
}
}));

(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2 = (function (ns,name){
var sym_str = (((!((ns == null))))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):name);
return (new cljs.core.Symbol(ns,name,sym_str,null,null));
}));

(cljs.core.symbol.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.Fn}
 * @implements {cljs.core.IDeref}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.Var = (function (val,sym,_meta){
this.val = val;
this.sym = sym;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 6717441;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.Var.prototype.isMacro = (function (){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null, )).cljs$lang$macro;
}));

(cljs.core.Var.prototype.toString = (function (){
var self__ = this;
var _ = this;
return ["#'",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.sym)].join('');
}));

(cljs.core.Var.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null, ));
}));

(cljs.core.Var.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
}));

(cljs.core.Var.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Var(self__.val,self__.sym,new_meta));
}));

(cljs.core.Var.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
if((other instanceof cljs.core.Var)){
var G__33030 = this$__$1.sym;
var G__33031 = other.sym;
return (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 ? cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(G__33030,G__33031) : cljs.core._EQ_.call(null, G__33030,G__33031));
} else {
return false;
}
}));

(cljs.core.Var.prototype.cljs$core$IHash$_hash$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.hash_symbol(self__.sym);
}));

(cljs.core.Var.prototype.cljs$core$Fn$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Var.prototype.call = (function (unused__11804__auto__){
var self__ = this;
var self__ = this;
var G__33032 = (arguments.length - (1));
switch (G__33032) {
case (0):
return self__.cljs$core$IFn$_invoke$arity$0();

break;
case (1):
return self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));

break;
case (2):
return self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));

break;
case (3):
return self__.cljs$core$IFn$_invoke$arity$3((arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case (4):
return self__.cljs$core$IFn$_invoke$arity$4((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case (5):
return self__.cljs$core$IFn$_invoke$arity$5((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case (6):
return self__.cljs$core$IFn$_invoke$arity$6((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case (7):
return self__.cljs$core$IFn$_invoke$arity$7((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
case (8):
return self__.cljs$core$IFn$_invoke$arity$8((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case (9):
return self__.cljs$core$IFn$_invoke$arity$9((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
case (10):
return self__.cljs$core$IFn$_invoke$arity$10((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]));

break;
case (11):
return self__.cljs$core$IFn$_invoke$arity$11((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]));

break;
case (12):
return self__.cljs$core$IFn$_invoke$arity$12((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]));

break;
case (13):
return self__.cljs$core$IFn$_invoke$arity$13((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]));

break;
case (14):
return self__.cljs$core$IFn$_invoke$arity$14((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]));

break;
case (15):
return self__.cljs$core$IFn$_invoke$arity$15((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]));

break;
case (16):
return self__.cljs$core$IFn$_invoke$arity$16((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]));

break;
case (17):
return self__.cljs$core$IFn$_invoke$arity$17((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]));

break;
case (18):
return self__.cljs$core$IFn$_invoke$arity$18((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]));

break;
case (19):
return self__.cljs$core$IFn$_invoke$arity$19((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]));

break;
case (20):
return self__.cljs$core$IFn$_invoke$arity$20((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]));

break;
case (21):
return self__.cljs$core$IFn$_invoke$arity$21((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]),(arguments[(21)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(cljs.core.Var.prototype.apply = (function (self__,args33029){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args33029)));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
var fexpr__33033 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null, ));
return (fexpr__33033.cljs$core$IFn$_invoke$arity$0 ? fexpr__33033.cljs$core$IFn$_invoke$arity$0() : fexpr__33033.call(null, ));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
var fexpr__33034 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null, ));
return (fexpr__33034.cljs$core$IFn$_invoke$arity$1 ? fexpr__33034.cljs$core$IFn$_invoke$arity$1(a) : fexpr__33034.call(null, a));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
var fexpr__33035 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null, ));
return (fexpr__33035.cljs$core$IFn$_invoke$arity$2 ? fexpr__33035.cljs$core$IFn$_invoke$arity$2(a,b) : fexpr__33035.call(null, a,b));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
var fexpr__33036 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null, ));
return (fexpr__33036.cljs$core$IFn$_invoke$arity$3 ? fexpr__33036.cljs$core$IFn$_invoke$arity$3(a,b,c) : fexpr__33036.call(null, a,b,c));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
var fexpr__33037 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null, ));
return (fexpr__33037.cljs$core$IFn$_invoke$arity$4 ? fexpr__33037.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : fexpr__33037.call(null, a,b,c,d));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
var fexpr__33038 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null, ));
return (fexpr__33038.cljs$core$IFn$_invoke$arity$5 ? fexpr__33038.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : fexpr__33038.call(null, a,b,c,d,e));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
var fexpr__33039 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null, ));
return (fexpr__33039.cljs$core$IFn$_invoke$arity$6 ? fexpr__33039.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : fexpr__33039.call(null, a,b,c,d,e,f));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
var fexpr__33040 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null, ));
return (fexpr__33040.cljs$core$IFn$_invoke$arity$7 ? fexpr__33040.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : fexpr__33040.call(null, a,b,c,d,e,f,g));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
var fexpr__33041 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null, ));
return (fexpr__33041.cljs$core$IFn$_invoke$arity$8 ? fexpr__33041.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : fexpr__33041.call(null, a,b,c,d,e,f,g,h));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
var fexpr__33042 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null, ));
return (fexpr__33042.cljs$core$IFn$_invoke$arity$9 ? fexpr__33042.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : fexpr__33042.call(null, a,b,c,d,e,f,g,h,i));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
var fexpr__33043 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null, ));
return (fexpr__33043.cljs$core$IFn$_invoke$arity$10 ? fexpr__33043.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : fexpr__33043.call(null, a,b,c,d,e,f,g,h,i,j));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
var fexpr__33044 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null, ));
return (fexpr__33044.cljs$core$IFn$_invoke$arity$11 ? fexpr__33044.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : fexpr__33044.call(null, a,b,c,d,e,f,g,h,i,j,k));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
var fexpr__33045 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null, ));
return (fexpr__33045.cljs$core$IFn$_invoke$arity$12 ? fexpr__33045.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : fexpr__33045.call(null, a,b,c,d,e,f,g,h,i,j,k,l));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
var fexpr__33046 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null, ));
return (fexpr__33046.cljs$core$IFn$_invoke$arity$13 ? fexpr__33046.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : fexpr__33046.call(null, a,b,c,d,e,f,g,h,i,j,k,l,m));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
var fexpr__33047 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null, ));
return (fexpr__33047.cljs$core$IFn$_invoke$arity$14 ? fexpr__33047.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : fexpr__33047.call(null, a,b,c,d,e,f,g,h,i,j,k,l,m,n));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
var fexpr__33048 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null, ));
return (fexpr__33048.cljs$core$IFn$_invoke$arity$15 ? fexpr__33048.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : fexpr__33048.call(null, a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
var fexpr__33049 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null, ));
return (fexpr__33049.cljs$core$IFn$_invoke$arity$16 ? fexpr__33049.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : fexpr__33049.call(null, a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
var fexpr__33050 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null, ));
return (fexpr__33050.cljs$core$IFn$_invoke$arity$17 ? fexpr__33050.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : fexpr__33050.call(null, a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
var fexpr__33051 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null, ));
return (fexpr__33051.cljs$core$IFn$_invoke$arity$18 ? fexpr__33051.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : fexpr__33051.call(null, a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
var fexpr__33052 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null, ));
return (fexpr__33052.cljs$core$IFn$_invoke$arity$19 ? fexpr__33052.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : fexpr__33052.call(null, a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
var fexpr__33053 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null, ));
return (fexpr__33053.cljs$core$IFn$_invoke$arity$20 ? fexpr__33053.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : fexpr__33053.call(null, a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
var G__33054 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null, ));
var G__33055 = a;
var G__33056 = b;
var G__33057 = c;
var G__33058 = d;
var G__33059 = e;
var G__33060 = f;
var G__33061 = g;
var G__33062 = h;
var G__33063 = i;
var G__33064 = j;
var G__33065 = k;
var G__33066 = l;
var G__33067 = m;
var G__33068 = n;
var G__33069 = o;
var G__33070 = p;
var G__33071 = q;
var G__33072 = r;
var G__33073 = s;
var G__33074 = t;
var G__33075 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$21 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$21(G__33054,G__33055,G__33056,G__33057,G__33058,G__33059,G__33060,G__33061,G__33062,G__33063,G__33064,G__33065,G__33066,G__33067,G__33068,G__33069,G__33070,G__33071,G__33072,G__33073, new cljs.core.IndexedSeq([G__33074,G__33075],0,null)) : cljs.core.apply.call(null, G__33054,G__33055,G__33056,G__33057,G__33058,G__33059,G__33060,G__33061,G__33062,G__33063,G__33064,G__33065,G__33066,G__33067,G__33068,G__33069,G__33070,G__33071,G__33072,G__33073,G__33074,G__33075));
}));

(cljs.core.Var.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"sym","sym",195671222,null),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
}));

(cljs.core.Var.cljs$lang$type = true);

(cljs.core.Var.cljs$lang$ctorStr = "cljs.core/Var");

(cljs.core.Var.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/Var");
}));

/**
 * Positional factory function for cljs.core/Var.
 */
cljs.core.__GT_Var = (function cljs$core$__GT_Var(val,sym,_meta){
return (new cljs.core.Var(val,sym,_meta));
});



/**
 * Return true if x implements IIterable protocol.
 */
cljs.core.iterable_QMARK_ = (function cljs$core$iterable_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition1$ & (131072))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IIterable$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,x);
}
});
/**
 * Return true if x has a JavaScript iterator property
 */
cljs.core.js_iterable_QMARK_ = (function cljs$core$js_iterable_QMARK_(x){
return (((!((x == null)))) && ((!((x[cljs.core.ITER_SYMBOL] == null)))));
});
/**
 * Clone the supplied value which must implement ICloneable.
 */
cljs.core.clone = (function cljs$core$clone(value){
return cljs.core._clone(value);
});
/**
 * Return true if x implements ICloneable protocol.
 */
cljs.core.cloneable_QMARK_ = (function cljs$core$cloneable_QMARK_(value){
if((!((value == null)))){
if((((value.cljs$lang$protocol_mask$partition1$ & (8192))) || ((cljs.core.PROTOCOL_SENTINEL === value.cljs$core$ICloneable$)))){
return true;
} else {
if((!value.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,value);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,value);
}
});
/**
 * Returns a seq on the collection. If the collection is
 *   empty, returns nil.  (seq nil) returns nil. seq also works on
 *   Strings.
 */
cljs.core.seq = (function cljs$core$seq(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeqable$))))?true:false):false)){
return coll.cljs$core$ISeqable$_seq$arity$1(null, );
} else {
if(cljs.core.array_QMARK_(coll)){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0),null));
}
} else {
if(typeof coll === 'string'){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0),null));
}
} else {
if(cljs.core.js_iterable_QMARK_(coll)){
var G__33079 = cljs.core.goog$module$goog$object.get(coll,cljs.core.ITER_SYMBOL).call(coll);
return (cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1(G__33079) : cljs.core.es6_iterator_seq.call(null, G__33079));
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,coll)){
return cljs.core._seq(coll);
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll)," is not ISeqable"].join('')));

}
}
}
}
}
}
});
/**
 * Returns the first item in the collection. Calls seq on its
 *   argument. If coll is nil, returns nil.
 */
cljs.core.first = (function cljs$core$first(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false)){
return coll.cljs$core$ISeq$_first$arity$1(null, );
} else {
var s = cljs.core.seq(coll);
if((s == null)){
return null;
} else {
return cljs.core._first(s);
}
}
}
});
/**
 * Returns a possibly empty seq of the items after the first. Calls seq on its
 *   argument.
 */
cljs.core.rest = (function cljs$core$rest(coll){
if((!((coll == null)))){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false)){
return coll.cljs$core$ISeq$_rest$arity$1(null, );
} else {
var s = cljs.core.seq(coll);
if(s){
return s.cljs$core$ISeq$_rest$arity$1(null, );
} else {
return cljs.core.List.EMPTY;
}
}
} else {
return cljs.core.List.EMPTY;
}
});
/**
 * Returns a seq of the items after the first. Calls seq on its
 *   argument.  If there are no more items, returns nil
 */
cljs.core.next = (function cljs$core$next(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$INext$))))?true:false):false)){
return coll.cljs$core$INext$_next$arity$1(null, );
} else {
return cljs.core.seq(cljs.core.rest(coll));
}
}
});
/**
 * Equality. Returns true if x equals y, false if not. Compares
 *   numbers and collections in a type-independent manner.  Clojure's immutable data
 *   structures define -equiv (and thus =) as a value, not an identity,
 *   comparison.
 */
cljs.core._EQ_ = (function cljs$core$_EQ_(var_args){
var G__33087 = arguments.length;
switch (G__33087) {
case 1:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35223 = arguments.length;
var i__5727__auto___35224 = (0);
while(true){
if((i__5727__auto___35224 < len__5726__auto___35223)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35224]));

var G__35225 = (i__5727__auto___35224 + (1));
i__5727__auto___35224 = G__35225;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
}));

(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
if((x == null)){
return (y == null);
} else {
return (((x === y)) || (cljs.core._equiv(x,y)));
}
}));

(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
if(cljs.core.next(more)){
var G__35226 = y;
var G__35227 = cljs.core.first(more);
var G__35228 = cljs.core.next(more);
x = G__35226;
y = G__35227;
more = G__35228;
continue;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(y,cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._EQ_.cljs$lang$applyTo = (function (seq33084){
var G__33085 = cljs.core.first(seq33084);
var seq33084__$1 = cljs.core.next(seq33084);
var G__33086 = cljs.core.first(seq33084__$1);
var seq33084__$2 = cljs.core.next(seq33084__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33085,G__33086,seq33084__$2);
}));

(cljs.core._EQ_.cljs$lang$maxFixedArity = (2));


/**
* @constructor
*/
cljs.core.ES6Iterator = (function (s){
this.s = s;
});
(cljs.core.ES6Iterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if((!((self__.s == null)))){
var x = cljs.core.first(self__.s);
(self__.s = cljs.core.next(self__.s));

return ({"value": x, "done": false});
} else {
return ({"value": null, "done": true});
}
}));

(cljs.core.ES6Iterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ES6Iterator.cljs$lang$type = true);

(cljs.core.ES6Iterator.cljs$lang$ctorStr = "cljs.core/ES6Iterator");

(cljs.core.ES6Iterator.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/ES6Iterator");
}));

/**
 * Positional factory function for cljs.core/ES6Iterator.
 */
cljs.core.__GT_ES6Iterator = (function cljs$core$__GT_ES6Iterator(s){
return (new cljs.core.ES6Iterator(s));
});

/**
 * Return a ES2015+ compatible iterator for coll.
 */
cljs.core.es6_iterator = (function cljs$core$es6_iterator(coll){
return (new cljs.core.ES6Iterator(cljs.core.seq(coll)));
});

/**
* @constructor
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
*/
cljs.core.ES6IteratorSeq = (function (value,iter,_rest){
this.value = value;
this.iter = iter;
this._rest = _rest;
this.cljs$lang$protocol_mask$partition0$ = 8388672;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.value;
}));

(cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if((self__._rest == null)){
(self__._rest = (cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1(self__.iter) : cljs.core.es6_iterator_seq.call(null, self__.iter)));
} else {
}

return self__._rest;
}));

(cljs.core.ES6IteratorSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"value","value",1946509744,null),new cljs.core.Symbol(null,"iter","iter",-1346195486,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_rest","_rest",-2100466189,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ES6IteratorSeq.cljs$lang$type = true);

(cljs.core.ES6IteratorSeq.cljs$lang$ctorStr = "cljs.core/ES6IteratorSeq");

(cljs.core.ES6IteratorSeq.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/ES6IteratorSeq");
}));

/**
 * Positional factory function for cljs.core/ES6IteratorSeq.
 */
cljs.core.__GT_ES6IteratorSeq = (function cljs$core$__GT_ES6IteratorSeq(value,iter,_rest){
return (new cljs.core.ES6IteratorSeq(value,iter,_rest));
});

/**
 * Given an ES2015+ compatible iterator return a seq.
 */
cljs.core.es6_iterator_seq = (function cljs$core$es6_iterator_seq(iter){
var v = iter.next();
if(cljs.core.truth_(v.done)){
return null;
} else {
return (new cljs.core.ES6IteratorSeq(v.value,iter,null));
}
});
/**
 * Mix final collection hash for ordered or unordered collections.
 * hash-basis is the combined collection hash, count is the number
 * of elements included in the basis. Note this is the hash code
 * consistent with =, different from .hashCode.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.mix_collection_hash = (function cljs$core$mix_collection_hash(hash_basis,count){
var h1 = cljs.core.m3_seed;
var k1 = cljs.core.m3_mix_K1(hash_basis);
var h1__$1 = cljs.core.m3_mix_H1(h1,k1);
return cljs.core.m3_fmix(h1__$1,count);
});
/**
 * Returns the hash code, consistent with =, for an external ordered
 * collection implementing Iterable.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_ordered_coll = (function cljs$core$hash_ordered_coll(coll){
var n = (0);
var hash_code = (1);
var coll__$1 = cljs.core.seq(coll);
while(true){
if((!((coll__$1 == null)))){
var G__35229 = (n + (1));
var G__35230 = ((cljs.core.imul((31),hash_code) + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__35231 = cljs.core.next(coll__$1);
n = G__35229;
hash_code = G__35230;
coll__$1 = G__35231;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_ordered_hash = cljs.core.mix_collection_hash((1),(0));
/**
 * Returns the hash code, consistent with =, for an external unordered
 * collection implementing Iterable. For maps, the iterator should
 * return map entries whose hash is computed as
 *   (hash-ordered-coll [k v]).
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_unordered_coll = (function cljs$core$hash_unordered_coll(coll){
var n = (0);
var hash_code = (0);
var coll__$1 = cljs.core.seq(coll);
while(true){
if((!((coll__$1 == null)))){
var G__35232 = (n + (1));
var G__35233 = ((hash_code + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__35234 = cljs.core.next(coll__$1);
n = G__35232;
hash_code = G__35233;
coll__$1 = G__35234;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_unordered_hash = cljs.core.mix_collection_hash((0),(0));


(cljs.core.ICounted["null"] = true);

(cljs.core._count["null"] = (function (_){
return (0);
}));
(Date.prototype.cljs$core$IEquiv$ = cljs.core.PROTOCOL_SENTINEL);

(Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var o__$1 = this;
return (((other instanceof Date)) && ((o__$1.valueOf() === other.valueOf())));
}));

(Date.prototype.cljs$core$IComparable$ = cljs.core.PROTOCOL_SENTINEL);

(Date.prototype.cljs$core$IComparable$_compare$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof Date)){
return cljs.core.goog$module$goog$array.defaultCompare(this$__$1.valueOf(),other.valueOf());
} else {
throw (new Error(["Cannot compare ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(this$__$1)," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(other)].join('')));
}
}));

/**
 * @interface
 */
cljs.core.Inst = function(){};

var cljs$core$Inst$inst_ms_STAR_$dyn_35235 = (function (inst){
var x__5350__auto__ = (((inst == null))?null:inst);
var m__5351__auto__ = (cljs.core.inst_ms_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(inst) : m__5351__auto__.call(null, inst));
} else {
var m__5349__auto__ = (cljs.core.inst_ms_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(inst) : m__5349__auto__.call(null, inst));
} else {
throw cljs.core.missing_protocol("Inst.inst-ms*",inst);
}
}
});
cljs.core.inst_ms_STAR_ = (function cljs$core$inst_ms_STAR_(inst){
if((((!((inst == null)))) && ((!((inst.cljs$core$Inst$inst_ms_STAR_$arity$1 == null)))))){
return inst.cljs$core$Inst$inst_ms_STAR_$arity$1(inst);
} else {
return cljs$core$Inst$inst_ms_STAR_$dyn_35235(inst);
}
});

(Date.prototype.cljs$core$Inst$ = cljs.core.PROTOCOL_SENTINEL);

(Date.prototype.cljs$core$Inst$inst_ms_STAR_$arity$1 = (function (inst){
var inst__$1 = this;
return inst__$1.getTime();
}));
/**
 * Return the number of milliseconds since January 1, 1970, 00:00:00 GMT
 */
cljs.core.inst_ms = (function cljs$core$inst_ms(inst){
return cljs.core.inst_ms_STAR_(inst);
});
/**
 * Return true if x satisfies Inst
 */
cljs.core.inst_QMARK_ = (function cljs$core$inst_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$Inst$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.Inst,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.Inst,x);
}
});
(cljs.core.IEquiv["number"] = true);

(cljs.core._equiv["number"] = (function (x,o){
return (x === o);
}));
(cljs.core.Fn["function"] = true);

(cljs.core.IMeta["function"] = true);

(cljs.core._meta["function"] = (function (_){
return null;
}));
(cljs.core.IHash["_"] = true);

(cljs.core._hash["_"] = (function (o){
return goog.getUid(o);
}));
/**
 * Returns a number one greater than num.
 */
cljs.core.inc = (function cljs$core$inc(x){
return (x + (1));
});

/**
* @constructor
 * @implements {cljs.core.IDeref}
*/
cljs.core.Reduced = (function (val){
this.val = val;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = (function (o){
var self__ = this;
var o__$1 = this;
return self__.val;
}));

(cljs.core.Reduced.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null)], null);
}));

(cljs.core.Reduced.cljs$lang$type = true);

(cljs.core.Reduced.cljs$lang$ctorStr = "cljs.core/Reduced");

(cljs.core.Reduced.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/Reduced");
}));

/**
 * Positional factory function for cljs.core/Reduced.
 */
cljs.core.__GT_Reduced = (function cljs$core$__GT_Reduced(val){
return (new cljs.core.Reduced(val));
});

/**
 * Wraps x in a way such that a reduce will terminate with the value x
 */
cljs.core.reduced = (function cljs$core$reduced(x){
return (new cljs.core.Reduced(x));
});
/**
 * Returns true if x is the result of a call to reduced
 */
cljs.core.reduced_QMARK_ = (function cljs$core$reduced_QMARK_(r){
return (r instanceof cljs.core.Reduced);
});
/**
 * If x is already reduced?, returns it, else returns (reduced x)
 */
cljs.core.ensure_reduced = (function cljs$core$ensure_reduced(x){
if(cljs.core.reduced_QMARK_(x)){
return x;
} else {
return cljs.core.reduced(x);
}
});
/**
 * If x is reduced?, returns (deref x), else returns x
 */
cljs.core.unreduced = (function cljs$core$unreduced(x){
if(cljs.core.reduced_QMARK_(x)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(x) : cljs.core.deref.call(null, x));
} else {
return x;
}
});
/**
 * Also reader macro: @var/@atom/@delay. Returns the
 * most-recently-committed value of ref. When applied to a var
 * or atom, returns its current state. When applied to a delay, forces
 * it if not already forced. See also - realized?.
 */
cljs.core.deref = (function cljs$core$deref(o){
return cljs.core._deref(o);
});
/**
 * Accepts any collection which satisfies the ICount and IIndexed protocols and
 * reduces them without incurring seq initialization
 */
cljs.core.ci_reduce = (function cljs$core$ci_reduce(var_args){
var G__33090 = arguments.length;
switch (G__33090) {
case 2:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2 = (function (cicoll,f){
var cnt = cicoll.cljs$core$ICounted$_count$arity$1(null, );
if((cnt === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null, ));
} else {
var val = cicoll.cljs$core$IIndexed$_nth$arity$2(null, (0));
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__33091 = val;
var G__33092 = cicoll.cljs$core$IIndexed$_nth$arity$2(null, n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__33091,G__33092) : f.call(null, G__33091,G__33092));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__35247 = nval;
var G__35248 = (n + (1));
val = G__35247;
n = G__35248;
continue;
}
} else {
return val;
}
break;
}
}
}));

(cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3 = (function (cicoll,f,val){
var cnt = cicoll.cljs$core$ICounted$_count$arity$1(null, );
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__33093 = val__$1;
var G__33094 = cicoll.cljs$core$IIndexed$_nth$arity$2(null, n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__33093,G__33094) : f.call(null, G__33093,G__33094));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__35249 = nval;
var G__35250 = (n + (1));
val__$1 = G__35249;
n = G__35250;
continue;
}
} else {
return val__$1;
}
break;
}
}));

(cljs.core.ci_reduce.cljs$lang$maxFixedArity = 3);

cljs.core.array_reduce = (function cljs$core$array_reduce(var_args){
var G__33096 = arguments.length;
switch (G__33096) {
case 2:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2 = (function (arr,f){
var cnt = arr.length;
if((arr.length === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null, ));
} else {
var val = (arr[(0)]);
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__33097 = val;
var G__33098 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__33097,G__33098) : f.call(null, G__33097,G__33098));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__35254 = nval;
var G__35255 = (n + (1));
val = G__35254;
n = G__35255;
continue;
}
} else {
return val;
}
break;
}
}
}));

(cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3 = (function (arr,f,val){
var cnt = arr.length;
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__33099 = val__$1;
var G__33100 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__33099,G__33100) : f.call(null, G__33099,G__33100));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__35256 = nval;
var G__35257 = (n + (1));
val__$1 = G__35256;
n = G__35257;
continue;
}
} else {
return val__$1;
}
break;
}
}));

(cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4 = (function (arr,f,val,idx){
var cnt = arr.length;
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__33101 = val__$1;
var G__33102 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__33101,G__33102) : f.call(null, G__33101,G__33102));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__35260 = nval;
var G__35261 = (n + (1));
val__$1 = G__35260;
n = G__35261;
continue;
}
} else {
return val__$1;
}
break;
}
}));

(cljs.core.array_reduce.cljs$lang$maxFixedArity = 4);







/**
 * Returns true if coll implements count in constant time
 */
cljs.core.counted_QMARK_ = (function cljs$core$counted_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (2))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ICounted$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,x);
}
});
/**
 * Returns true if coll implements nth in constant time
 */
cljs.core.indexed_QMARK_ = (function cljs$core$indexed_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IIndexed$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,x);
}
});
cljs.core._indexOf = (function cljs$core$_indexOf(var_args){
var G__33106 = arguments.length;
switch (G__33106) {
case 2:
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2 = (function (coll,x){
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
}));

(cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3 = (function (coll,x,start){
var len = (cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null, coll));
if((start >= len)){
return (-1);
} else {
var idx = (((start > (0)))?start:(((start < (0)))?(function (){var x__5087__auto__ = (0);
var y__5088__auto__ = (start + len);
return ((x__5087__auto__ > y__5088__auto__) ? x__5087__auto__ : y__5088__auto__);
})():start
));
while(true){
if((idx < len)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((cljs.core.nth.cljs$core$IFn$_invoke$arity$2 ? cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,idx) : cljs.core.nth.call(null, coll,idx)),x)){
return idx;
} else {
var G__35267 = (idx + (1));
idx = G__35267;
continue;
}
} else {
return (-1);
}
break;
}
}
}));

(cljs.core._indexOf.cljs$lang$maxFixedArity = 3);

cljs.core._lastIndexOf = (function cljs$core$_lastIndexOf(var_args){
var G__33108 = arguments.length;
switch (G__33108) {
case 2:
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2 = (function (coll,x){
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null, coll)));
}));

(cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3 = (function (coll,x,start){
var len = (cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null, coll));
if((len === (0))){
return (-1);
} else {
var idx = (((start > (0)))?(function (){var x__5090__auto__ = (len - (1));
var y__5091__auto__ = start;
return ((x__5090__auto__ < y__5091__auto__) ? x__5090__auto__ : y__5091__auto__);
})():(((start < (0)))?(len + start):start
));
while(true){
if((idx >= (0))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((cljs.core.nth.cljs$core$IFn$_invoke$arity$2 ? cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,idx) : cljs.core.nth.call(null, coll,idx)),x)){
return idx;
} else {
var G__35273 = (idx - (1));
idx = G__35273;
continue;
}
} else {
return (-1);
}
break;
}
}
}));

(cljs.core._lastIndexOf.cljs$lang$maxFixedArity = 3);


/**
* @constructor
*/
cljs.core.IndexedSeqIterator = (function (arr,i){
this.arr = arr;
this.i = i;
});
(cljs.core.IndexedSeqIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
}));

(cljs.core.IndexedSeqIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
(self__.i = (self__.i + (1)));

return ret;
}));

(cljs.core.IndexedSeqIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.IndexedSeqIterator.cljs$lang$type = true);

(cljs.core.IndexedSeqIterator.cljs$lang$ctorStr = "cljs.core/IndexedSeqIterator");

(cljs.core.IndexedSeqIterator.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/IndexedSeqIterator");
}));

/**
 * Positional factory function for cljs.core/IndexedSeqIterator.
 */
cljs.core.__GT_IndexedSeqIterator = (function cljs$core$__GT_IndexedSeqIterator(arr,i){
return (new cljs.core.IndexedSeqIterator(arr,i));
});


/**
* @constructor
 * @implements {cljs.core.IDrop}
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.IndexedSeq = (function (arr,i,meta){
this.arr = arr;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 166592766;
this.cljs$lang$protocol_mask$partition1$ = 401408;
});
(cljs.core.IndexedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.IndexedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
}));

(cljs.core.IndexedSeq.prototype.indexOf = (function() {
var G__35274 = null;
var G__35274__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__35274__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__35274 = function(x,start){
switch(arguments.length){
case 1:
return G__35274__1.call(this,x);
case 2:
return G__35274__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35274.cljs$core$IFn$_invoke$arity$1 = G__35274__1;
G__35274.cljs$core$IFn$_invoke$arity$2 = G__35274__2;
return G__35274;
})()
);

(cljs.core.IndexedSeq.prototype.lastIndexOf = (function() {
var G__35275 = null;
var G__35275__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null, coll)));
});
var G__35275__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__35275 = function(x,start){
switch(arguments.length){
case 1:
return G__35275__1.call(this,x);
case 2:
return G__35275__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35275.cljs$core$IFn$_invoke$arity$1 = G__35275__1;
G__35275.cljs$core$IFn$_invoke$arity$2 = G__35275__2;
return G__35275;
})()
);

(cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if(((((0) <= i__$1)) && ((i__$1 < self__.arr.length)))){
return (self__.arr[i__$1]);
} else {
throw (new Error("Index out of bounds"));
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if(((((0) <= i__$1)) && ((i__$1 < self__.arr.length)))){
return (self__.arr[i__$1]);
} else {
return not_found;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.IndexedSeqIterator(self__.arr,self__.i));
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.IndexedSeq(self__.arr,self__.i,self__.meta));
}));

(cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1)),null));
} else {
return null;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var x__5087__auto__ = (0);
var y__5088__auto__ = (self__.arr.length - self__.i);
return ((x__5087__auto__ > y__5088__auto__) ? x__5087__auto__ : y__5088__auto__);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var c = coll__$1.cljs$core$ICounted$_count$arity$1(null, );
if((c > (0))){
return (new cljs.core.RSeq(coll__$1,(c - (1)),null));
} else {
return null;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(coll__$1,other) : cljs.core.equiv_sequential.call(null, coll__$1,other));
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.i]),(self__.i + (1)));
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.i);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.arr[self__.i]);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1)),null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.i < self__.arr.length)){
return this$__$1;
} else {
return null;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.IndexedSeq(self__.arr,self__.i,new_meta));
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(o,coll__$1) : cljs.core.cons.call(null, o,coll__$1));
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IDrop$_drop$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if((n > (0))){
if(((self__.i + n) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + n),null));
} else {
return null;
}
} else {
return coll__$1;
}
}));

(cljs.core.IndexedSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
}));

(cljs.core.IndexedSeq.cljs$lang$type = true);

(cljs.core.IndexedSeq.cljs$lang$ctorStr = "cljs.core/IndexedSeq");

(cljs.core.IndexedSeq.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/IndexedSeq");
}));

/**
 * Positional factory function for cljs.core/IndexedSeq.
 */
cljs.core.__GT_IndexedSeq = (function cljs$core$__GT_IndexedSeq(arr,i,meta){
return (new cljs.core.IndexedSeq(arr,i,meta));
});

(cljs.core.IndexedSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));
/**
 * Create seq from a primitive JavaScript Array-like.
 */
cljs.core.prim_seq = (function cljs$core$prim_seq(var_args){
var G__33110 = arguments.length;
switch (G__33110) {
case 1:
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1 = (function (prim){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(prim,(0));
}));

(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2 = (function (prim,i){
if((i < prim.length)){
return (new cljs.core.IndexedSeq(prim,i,null));
} else {
return null;
}
}));

(cljs.core.prim_seq.cljs$lang$maxFixedArity = 2);

/**
 * Create a seq from a JavaScript array.
 */
cljs.core.array_seq = (function cljs$core$array_seq(var_args){
var G__33112 = arguments.length;
switch (G__33112) {
case 1:
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1 = (function (array){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,(0));
}));

(cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2 = (function (array,i){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,i);
}));

(cljs.core.array_seq.cljs$lang$maxFixedArity = 2);



/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.RSeq = (function (ci,i,meta){
this.ci = ci;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.RSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.RSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
}));

(cljs.core.RSeq.prototype.indexOf = (function() {
var G__35284 = null;
var G__35284__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__35284__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__35284 = function(x,start){
switch(arguments.length){
case 1:
return G__35284__1.call(this,x);
case 2:
return G__35284__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35284.cljs$core$IFn$_invoke$arity$1 = G__35284__1;
G__35284.cljs$core$IFn$_invoke$arity$2 = G__35284__2;
return G__35284;
})()
);

(cljs.core.RSeq.prototype.lastIndexOf = (function() {
var G__35286 = null;
var G__35286__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null, coll)));
});
var G__35286__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__35286 = function(x,start){
switch(arguments.length){
case 1:
return G__35286__1.call(this,x);
case 2:
return G__35286__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35286.cljs$core$IFn$_invoke$arity$1 = G__35286__1;
G__35286.cljs$core$IFn$_invoke$arity$2 = G__35286__2;
return G__35286;
})()
);

(cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,self__.meta));
}));

(cljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return null;
}
}));

(cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.i + (1));
}));

(cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
}));

(cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(coll__$1,other) : cljs.core.equiv_sequential.call(null, coll__$1,other));
}));

(cljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (col,f){
var self__ = this;
var col__$1 = this;
return (cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,col__$1) : cljs.core.seq_reduce.call(null, f,col__$1));
}));

(cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (col,f,start){
var self__ = this;
var col__$1 = this;
return (cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,col__$1) : cljs.core.seq_reduce.call(null, f,start,col__$1));
}));

(cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth(self__.ci,self__.i);
}));

(cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.RSeq(self__.ci,self__.i,new_meta));
}
}));

(cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(o,coll__$1) : cljs.core.cons.call(null, o,coll__$1));
}));

(cljs.core.RSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ci","ci",2049808339,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
}));

(cljs.core.RSeq.cljs$lang$type = true);

(cljs.core.RSeq.cljs$lang$ctorStr = "cljs.core/RSeq");

(cljs.core.RSeq.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/RSeq");
}));

/**
 * Positional factory function for cljs.core/RSeq.
 */
cljs.core.__GT_RSeq = (function cljs$core$__GT_RSeq(ci,i,meta){
return (new cljs.core.RSeq(ci,i,meta));
});

(cljs.core.RSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));
/**
 * Same as (first (next x))
 */
cljs.core.second = (function cljs$core$second(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (first (first x))
 */
cljs.core.ffirst = (function cljs$core$ffirst(coll){
return cljs.core.first(cljs.core.first(coll));
});
/**
 * Same as (next (first x))
 */
cljs.core.nfirst = (function cljs$core$nfirst(coll){
return cljs.core.next(cljs.core.first(coll));
});
/**
 * Same as (first (next x))
 */
cljs.core.fnext = (function cljs$core$fnext(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (next (next x))
 */
cljs.core.nnext = (function cljs$core$nnext(coll){
return cljs.core.next(cljs.core.next(coll));
});
/**
 * Return the last item in coll, in linear time
 */
cljs.core.last = (function cljs$core$last(s){
while(true){
var sn = cljs.core.next(s);
if((!((sn == null)))){
var G__35301 = sn;
s = G__35301;
continue;
} else {
return cljs.core.first(s);
}
break;
}
});
(cljs.core.IEquiv["_"] = true);

(cljs.core._equiv["_"] = (function (x,o){
return (x === o);
}));
/**
 * conj[oin]. Returns a new collection with the xs
 *   'added'. (conj nil item) returns (item).
 *   (conj coll) returns coll. (conj) returns [].
 *   The 'addition' may happen at different 'places' depending
 *   on the concrete type.
 */
cljs.core.conj = (function cljs$core$conj(var_args){
var G__33117 = arguments.length;
switch (G__33117) {
case 0:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35303 = arguments.length;
var i__5727__auto___35304 = (0);
while(true){
if((i__5727__auto___35304 < len__5726__auto___35303)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35304]));

var G__35305 = (i__5727__auto___35304 + (1));
i__5727__auto___35304 = G__35305;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.conj.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentVector.EMPTY;
}));

(cljs.core.conj.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
}));

(cljs.core.conj.cljs$core$IFn$_invoke$arity$2 = (function (coll,x){
if((!((coll == null)))){
return cljs.core._conj(coll,x);
} else {
return (new cljs.core.List(null,x,null,(1),null));
}
}));

(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic = (function (coll,x,xs){
while(true){
if(cljs.core.truth_(xs)){
var G__35306 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
var G__35307 = cljs.core.first(xs);
var G__35308 = cljs.core.next(xs);
coll = G__35306;
x = G__35307;
xs = G__35308;
continue;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
break;
}
}));

/** @this {Function} */
(cljs.core.conj.cljs$lang$applyTo = (function (seq33114){
var G__33115 = cljs.core.first(seq33114);
var seq33114__$1 = cljs.core.next(seq33114);
var G__33116 = cljs.core.first(seq33114__$1);
var seq33114__$2 = cljs.core.next(seq33114__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33115,G__33116,seq33114__$2);
}));

(cljs.core.conj.cljs$lang$maxFixedArity = (2));

/**
 * Returns an empty collection of the same category as coll, or nil
 */
cljs.core.empty = (function cljs$core$empty(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IEmptyableCollection$))))?true:false):false)){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1(null, );
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IEmptyableCollection$))))?true:(((!coll.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IEmptyableCollection,coll):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IEmptyableCollection,coll))){
return cljs.core._empty(coll);
} else {
return null;

}
}
}
});
cljs.core.accumulating_seq_count = (function cljs$core$accumulating_seq_count(coll){
var s = cljs.core.seq(coll);
var acc = (0);
while(true){
if(cljs.core.counted_QMARK_(s)){
return (acc + cljs.core._count(s));
} else {
var G__35309 = cljs.core.next(s);
var G__35310 = (acc + (1));
s = G__35309;
acc = G__35310;
continue;
}
break;
}
});
/**
 * Returns the number of items in the collection. (count nil) returns
 *   0.  Also works on strings, arrays, and Maps
 */
cljs.core.count = (function cljs$core$count(coll){
if((!((coll == null)))){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (2))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ICounted$))))?true:false):false)){
return coll.cljs$core$ICounted$_count$arity$1(null, );
} else {
if(cljs.core.array_QMARK_(coll)){
return coll.length;
} else {
if(typeof coll === 'string'){
return coll.length;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeqable$))))?true:false):false)){
return cljs.core.accumulating_seq_count(coll);
} else {
return cljs.core._count(coll);

}
}
}
}
} else {
return (0);
}
});
cljs.core.linear_traversal_nth = (function cljs$core$linear_traversal_nth(var_args){
var G__33123 = arguments.length;
switch (G__33123) {
case 2:
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
while(true){
if((coll == null)){
throw (new Error("Index out of bounds"));
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth(coll,n);
} else {
if(cljs.core.seq(coll)){
var G__35312 = cljs.core.next(coll);
var G__35313 = (n - (1));
coll = G__35312;
n = G__35313;
continue;
} else {
throw (new Error("Index out of bounds"));

}
}
}
}
break;
}
}));

(cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
while(true){
if((coll == null)){
return not_found;
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
return not_found;
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth(coll,n,not_found);
} else {
if(cljs.core.seq(coll)){
var G__35320 = cljs.core.next(coll);
var G__35321 = (n - (1));
var G__35322 = not_found;
coll = G__35320;
n = G__35321;
not_found = G__35322;
continue;
} else {
return not_found;

}
}
}
}
break;
}
}));

(cljs.core.linear_traversal_nth.cljs$lang$maxFixedArity = 3);

/**
 * Returns the value at the index. get returns nil if index out of
 *   bounds, nth throws an exception unless not-found is supplied.  nth
 *   also works for strings, arrays, regex Matchers and Lists, and,
 *   in O(n) time, for sequences.
 */
cljs.core.nth = (function cljs$core$nth(var_args){
var G__33125 = arguments.length;
switch (G__33125) {
case 2:
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
if((!(typeof n === 'number'))){
throw (new Error("Index argument to nth must be a number"));
} else {
if((coll == null)){
return coll;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IIndexed$))))?true:false):false)){
return coll.cljs$core$IIndexed$_nth$arity$2(null, n);
} else {
if(cljs.core.array_QMARK_(coll)){
if(((((-1) < n)) && ((n < coll.length)))){
return (coll[(n | (0))]);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(typeof coll === 'string'){
if(((((-1) < n)) && ((n < coll.length)))){
return coll.charAt((n | (0)));
} else {
throw (new Error("Index out of bounds"));
}
} else {
if((function (){var or__5002__auto__ = (((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false);
if(or__5002__auto__){
return or__5002__auto__;
} else {
if((!((coll == null)))){
if((((coll.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISequential$)))){
return true;
} else {
return false;
}
} else {
return false;
}
}
})()){
if((n < (0))){
throw (new Error("Index out of bounds"));
} else {
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(coll,n);
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth(coll,n);
} else {
throw (new Error(["nth not supported on this type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
}));

(cljs.core.nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
if((!(typeof n === 'number'))){
throw (new Error("Index argument to nth must be a number."));
} else {
if((coll == null)){
return not_found;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IIndexed$))))?true:false):false)){
return coll.cljs$core$IIndexed$_nth$arity$3(null, n,not_found);
} else {
if(cljs.core.array_QMARK_(coll)){
if(((((-1) < n)) && ((n < coll.length)))){
return (coll[(n | (0))]);
} else {
return not_found;
}
} else {
if(typeof coll === 'string'){
if(((((-1) < n)) && ((n < coll.length)))){
return coll.charAt((n | (0)));
} else {
return not_found;
}
} else {
if((function (){var or__5002__auto__ = (((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false);
if(or__5002__auto__){
return or__5002__auto__;
} else {
if((!((coll == null)))){
if((((coll.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISequential$)))){
return true;
} else {
return false;
}
} else {
return false;
}
}
})()){
if((n < (0))){
return not_found;
} else {
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth(coll,n,not_found);
} else {
throw (new Error(["nth not supported on this type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
}));

(cljs.core.nth.cljs$lang$maxFixedArity = 3);

/**
 * Returns the nth rest of coll, coll when n is 0.
 */
cljs.core.nthrest = (function cljs$core$nthrest(coll,n){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition1$ & (262144))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IDrop$))))?true:false):false)){
if((n > (0))){
var or__5002__auto__ = coll.cljs$core$IDrop$_drop$arity$2(null, Math.ceil(n));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.List.EMPTY;
}
} else {
return coll;
}
} else {
var n__$1 = n;
var xs = coll;
while(true){
var temp__5821__auto__ = (((n__$1 > (0))) && (cljs.core.seq(xs)));
if(temp__5821__auto__){
var xs__$1 = temp__5821__auto__;
var G__35331 = (n__$1 - (1));
var G__35332 = cljs.core.rest(xs__$1);
n__$1 = G__35331;
xs = G__35332;
continue;
} else {
return xs;
}
break;
}
}
});
/**
 * Returns the value mapped to key, not-found or nil if key not present
 *   in associative collection, set, string, array, or ILookup instance.
 */
cljs.core.get = (function cljs$core$get(var_args){
var G__33134 = arguments.length;
switch (G__33134) {
case 2:
return cljs.core.get.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.get.cljs$core$IFn$_invoke$arity$2 = (function (o,k){
if((o == null)){
return null;
} else {
if((((!((o == null))))?(((((o.cljs$lang$protocol_mask$partition0$ & (256))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$ILookup$))))?true:false):false)){
return o.cljs$core$ILookup$_lookup$arity$2(null, k);
} else {
if(cljs.core.array_QMARK_(o)){
if((((!((k == null)))) && ((k < o.length)))){
return (o[(k | (0))]);
} else {
return null;
}
} else {
if(typeof o === 'string'){
if((((!((k == null)))) && (((((-1) < k)) && ((k < o.length)))))){
return o.charAt((k | (0)));
} else {
return null;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup(o,k);
} else {
return null;

}
}
}
}
}
}));

(cljs.core.get.cljs$core$IFn$_invoke$arity$3 = (function (o,k,not_found){
if((!((o == null)))){
if((((!((o == null))))?(((((o.cljs$lang$protocol_mask$partition0$ & (256))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$ILookup$))))?true:false):false)){
return o.cljs$core$ILookup$_lookup$arity$3(null, k,not_found);
} else {
if(cljs.core.array_QMARK_(o)){
if((((!((k == null)))) && (((((-1) < k)) && ((k < o.length)))))){
return (o[(k | (0))]);
} else {
return not_found;
}
} else {
if(typeof o === 'string'){
if((((!((k == null)))) && (((((-1) < k)) && ((k < o.length)))))){
return o.charAt((k | (0)));
} else {
return not_found;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup(o,k,not_found);
} else {
return not_found;

}
}
}
}
} else {
return not_found;
}
}));

(cljs.core.get.cljs$lang$maxFixedArity = 3);



/**
 * assoc[iate]. When applied to a map, returns a new map of the
 * same (hashed/sorted) type, that contains the mapping of key(s) to
 * val(s). When applied to a vector, returns a new vector that
 * contains val at index. Note - index must be <= (count vector).
 */
cljs.core.assoc = (function cljs$core$assoc(var_args){
var G__33142 = arguments.length;
switch (G__33142) {
case 3:
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35337 = arguments.length;
var i__5727__auto___35338 = (0);
while(true){
if((i__5727__auto___35338 < len__5726__auto___35337)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35338]));

var G__35339 = (i__5727__auto___35338 + (1));
i__5727__auto___35338 = G__35339;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((3) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((3)),(0),null)):null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5752__auto__);

}
});

(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3 = (function (coll,k,v){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IAssociative$))))?true:false):false)){
return coll.cljs$core$IAssociative$_assoc$arity$3(null, k,v);
} else {
if((!((coll == null)))){
return cljs.core._assoc(coll,k,v);
} else {
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k,v]);
}
}
}));

(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,v,kvs){
while(true){
var ret = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(coll,k,v);
if(cljs.core.truth_(kvs)){
var G__35340 = ret;
var G__35341 = cljs.core.first(kvs);
var G__35342 = cljs.core.second(kvs);
var G__35343 = cljs.core.nnext(kvs);
coll = G__35340;
k = G__35341;
v = G__35342;
kvs = G__35343;
continue;
} else {
return ret;
}
break;
}
}));

/** @this {Function} */
(cljs.core.assoc.cljs$lang$applyTo = (function (seq33138){
var G__33139 = cljs.core.first(seq33138);
var seq33138__$1 = cljs.core.next(seq33138);
var G__33140 = cljs.core.first(seq33138__$1);
var seq33138__$2 = cljs.core.next(seq33138__$1);
var G__33141 = cljs.core.first(seq33138__$2);
var seq33138__$3 = cljs.core.next(seq33138__$2);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33139,G__33140,G__33141,seq33138__$3);
}));

(cljs.core.assoc.cljs$lang$maxFixedArity = (3));

/**
 * dissoc[iate]. Returns a new map of the same (hashed/sorted) type,
 *   that does not contain a mapping for key(s).
 */
cljs.core.dissoc = (function cljs$core$dissoc(var_args){
var G__33148 = arguments.length;
switch (G__33148) {
case 1:
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35347 = arguments.length;
var i__5727__auto___35348 = (0);
while(true){
if((i__5727__auto___35348 < len__5726__auto___35347)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35348]));

var G__35349 = (i__5727__auto___35348 + (1));
i__5727__auto___35348 = G__35349;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
}));

(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._dissoc(coll,k);
}
}));

(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__35352 = ret;
var G__35353 = cljs.core.first(ks);
var G__35354 = cljs.core.next(ks);
coll = G__35352;
k = G__35353;
ks = G__35354;
continue;
} else {
return ret;
}
}
break;
}
}));

/** @this {Function} */
(cljs.core.dissoc.cljs$lang$applyTo = (function (seq33145){
var G__33146 = cljs.core.first(seq33145);
var seq33145__$1 = cljs.core.next(seq33145);
var G__33147 = cljs.core.first(seq33145__$1);
var seq33145__$2 = cljs.core.next(seq33145__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33146,G__33147,seq33145__$2);
}));

(cljs.core.dissoc.cljs$lang$maxFixedArity = (2));

/**
 * Return true if f is a JavaScript function or satisfies the Fn protocol.
 */
cljs.core.fn_QMARK_ = (function cljs$core$fn_QMARK_(f){
var or__5002__auto__ = typeof f === 'function';
if(or__5002__auto__){
return or__5002__auto__;
} else {
if((!((f == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === f.cljs$core$Fn$)))){
return true;
} else {
if((!f.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,f);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,f);
}
}
});

/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.Fn}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.MetaFn = (function (afn,meta){
this.afn = afn;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 393217;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
}));

(cljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.MetaFn(self__.afn,new_meta));
}));

(cljs.core.MetaFn.prototype.cljs$core$Fn$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.MetaFn.prototype.call = (function (unused__11804__auto__){
var self__ = this;
var self__ = this;
var G__33151 = (arguments.length - (1));
switch (G__33151) {
case (0):
return self__.cljs$core$IFn$_invoke$arity$0();

break;
case (1):
return self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));

break;
case (2):
return self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));

break;
case (3):
return self__.cljs$core$IFn$_invoke$arity$3((arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case (4):
return self__.cljs$core$IFn$_invoke$arity$4((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case (5):
return self__.cljs$core$IFn$_invoke$arity$5((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case (6):
return self__.cljs$core$IFn$_invoke$arity$6((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case (7):
return self__.cljs$core$IFn$_invoke$arity$7((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
case (8):
return self__.cljs$core$IFn$_invoke$arity$8((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case (9):
return self__.cljs$core$IFn$_invoke$arity$9((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
case (10):
return self__.cljs$core$IFn$_invoke$arity$10((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]));

break;
case (11):
return self__.cljs$core$IFn$_invoke$arity$11((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]));

break;
case (12):
return self__.cljs$core$IFn$_invoke$arity$12((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]));

break;
case (13):
return self__.cljs$core$IFn$_invoke$arity$13((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]));

break;
case (14):
return self__.cljs$core$IFn$_invoke$arity$14((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]));

break;
case (15):
return self__.cljs$core$IFn$_invoke$arity$15((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]));

break;
case (16):
return self__.cljs$core$IFn$_invoke$arity$16((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]));

break;
case (17):
return self__.cljs$core$IFn$_invoke$arity$17((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]));

break;
case (18):
return self__.cljs$core$IFn$_invoke$arity$18((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]));

break;
case (19):
return self__.cljs$core$IFn$_invoke$arity$19((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]));

break;
case (20):
return self__.cljs$core$IFn$_invoke$arity$20((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]));

break;
case (21):
return self__.cljs$core$IFn$_invoke$arity$21((arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]),(arguments[(21)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(cljs.core.MetaFn.prototype.apply = (function (self__,args33150){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args33150)));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null, ));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null, a));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a,b) : self__.afn.call(null, a,b));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a,b,c) : self__.afn.call(null, a,b,c));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : self__.afn.call(null, a,b,c,d));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : self__.afn.call(null, a,b,c,d,e));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : self__.afn.call(null, a,b,c,d,e,f));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : self__.afn.call(null, a,b,c,d,e,f,g));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : self__.afn.call(null, a,b,c,d,e,f,g,h));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : self__.afn.call(null, a,b,c,d,e,f,g,h,i));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : self__.afn.call(null, a,b,c,d,e,f,g,h,i,j));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : self__.afn.call(null, a,b,c,d,e,f,g,h,i,j,k));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : self__.afn.call(null, a,b,c,d,e,f,g,h,i,j,k,l));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : self__.afn.call(null, a,b,c,d,e,f,g,h,i,j,k,l,m));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : self__.afn.call(null, a,b,c,d,e,f,g,h,i,j,k,l,m,n));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : self__.afn.call(null, a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : self__.afn.call(null, a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : self__.afn.call(null, a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : self__.afn.call(null, a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : self__.afn.call(null, a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : self__.afn.call(null, a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$21 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$21(self__.afn,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s, new cljs.core.IndexedSeq([t,rest],0,null)) : cljs.core.apply.call(null, self__.afn,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
}));

(cljs.core.MetaFn.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
}));

(cljs.core.MetaFn.cljs$lang$type = true);

(cljs.core.MetaFn.cljs$lang$ctorStr = "cljs.core/MetaFn");

(cljs.core.MetaFn.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/MetaFn");
}));

/**
 * Positional factory function for cljs.core/MetaFn.
 */
cljs.core.__GT_MetaFn = (function cljs$core$__GT_MetaFn(afn,meta){
return (new cljs.core.MetaFn(afn,meta));
});

/**
 * Returns an object of the same type and value as obj, with
 *   map m as its metadata.
 */
cljs.core.with_meta = (function cljs$core$with_meta(o,meta){
if(typeof o === 'function'){
return (new cljs.core.MetaFn(o,meta));
} else {
if((o == null)){
return null;
} else {
return cljs.core._with_meta(o,meta);
}
}
});
/**
 * Returns the metadata of obj, returns nil if there is no metadata.
 */
cljs.core.meta = (function cljs$core$meta(o){
if((function (){var and__5000__auto__ = (!((o == null)));
if(and__5000__auto__){
if((!((o == null)))){
if((((o.cljs$lang$protocol_mask$partition0$ & (131072))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IMeta$)))){
return true;
} else {
if((!o.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,o);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,o);
}
} else {
return and__5000__auto__;
}
})()){
return cljs.core._meta(o);
} else {
return null;
}
});
/**
 * For a list or queue, same as first, for a vector, same as, but much
 *   more efficient than, last. If the collection is empty, returns nil.
 */
cljs.core.peek = (function cljs$core$peek(coll){
if((coll == null)){
return null;
} else {
return cljs.core._peek(coll);
}
});
/**
 * For a list or queue, returns a new list/queue without the first
 *   item, for a vector, returns a new vector without the last item.
 *   Note - not the same as next/butlast.
 */
cljs.core.pop = (function cljs$core$pop(coll){
if((coll == null)){
return null;
} else {
return cljs.core._pop(coll);
}
});
/**
 * disj[oin]. Returns a new set of the same (hashed/sorted) type, that
 *   does not contain key(s).
 */
cljs.core.disj = (function cljs$core$disj(var_args){
var G__33157 = arguments.length;
switch (G__33157) {
case 1:
return cljs.core.disj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35383 = arguments.length;
var i__5727__auto___35384 = (0);
while(true){
if((i__5727__auto___35384 < len__5726__auto___35383)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35384]));

var G__35385 = (i__5727__auto___35384 + (1));
i__5727__auto___35384 = G__35385;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.disj.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
}));

(cljs.core.disj.cljs$core$IFn$_invoke$arity$2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._disjoin(coll,k);
}
}));

(cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__35387 = ret;
var G__35388 = cljs.core.first(ks);
var G__35389 = cljs.core.next(ks);
coll = G__35387;
k = G__35388;
ks = G__35389;
continue;
} else {
return ret;
}
}
break;
}
}));

/** @this {Function} */
(cljs.core.disj.cljs$lang$applyTo = (function (seq33154){
var G__33155 = cljs.core.first(seq33154);
var seq33154__$1 = cljs.core.next(seq33154);
var G__33156 = cljs.core.first(seq33154__$1);
var seq33154__$2 = cljs.core.next(seq33154__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33155,G__33156,seq33154__$2);
}));

(cljs.core.disj.cljs$lang$maxFixedArity = (2));

/**
 * Returns true if coll has no items. To check the emptiness of a seq,
 *   please use the idiom (seq x) rather than (not (empty? x))
 */
cljs.core.empty_QMARK_ = (function cljs$core$empty_QMARK_(coll){
if((coll == null)){
return true;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (2))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ICounted$))))?true:(((!coll.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,coll):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,coll))){
return (cljs.core._count(coll) === (0));
} else {
return cljs.core.not(cljs.core.seq(coll));

}
}
});
/**
 * Returns true if x satisfies ICollection
 */
cljs.core.coll_QMARK_ = (function cljs$core$coll_QMARK_(x){
if((x == null)){
return false;
} else {
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (8))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ICollection$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,x);
}
}
});
/**
 * Returns true if x satisfies ISet
 */
cljs.core.set_QMARK_ = (function cljs$core$set_QMARK_(x){
if((x == null)){
return false;
} else {
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISet$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x);
}
}
});
/**
 * Returns true if coll implements IAssociative
 */
cljs.core.associative_QMARK_ = (function cljs$core$associative_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IAssociative$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,x);
}
});
/**
 * Returns true if coll implements IFind
 */
cljs.core.ifind_QMARK_ = (function cljs$core$ifind_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IFind$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IFind,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IFind,x);
}
});
/**
 * Returns true if coll satisfies ISequential
 */
cljs.core.sequential_QMARK_ = (function cljs$core$sequential_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISequential$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x);
}
});
/**
 * Returns true if coll satisfies ISorted
 */
cljs.core.sorted_QMARK_ = (function cljs$core$sorted_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (268435456))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISorted$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,x);
}
});
/**
 * Returns true if coll satisfies IReduce
 */
cljs.core.reduceable_QMARK_ = (function cljs$core$reduceable_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IReduce$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,x);
}
});
/**
 * Return true if x satisfies IMap
 */
cljs.core.map_QMARK_ = (function cljs$core$map_QMARK_(x){
if((x == null)){
return false;
} else {
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMap$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x);
}
}
});
/**
 * Return true if x satisfies IRecord
 */
cljs.core.record_QMARK_ = (function cljs$core$record_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (67108864))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IRecord$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord,x);
}
});
/**
 * Return true if x satisfies IVector
 */
cljs.core.vector_QMARK_ = (function cljs$core$vector_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (16384))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IVector$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,x);
}
});

/**
 * Return true if x satisfies IChunkedSeq.
 */
cljs.core.chunked_seq_QMARK_ = (function cljs$core$chunked_seq_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition1$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IChunkedSeq$)))){
return true;
} else {
return false;
}
} else {
return false;
}
});
/**
 * Create JavaSript object from an even number arguments representing
 *   interleaved keys and values.
 */
cljs.core.js_obj = (function cljs$core$js_obj(var_args){
var G__33172 = arguments.length;
switch (G__33172) {
case 0:
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0();

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35406 = arguments.length;
var i__5727__auto___35407 = (0);
while(true){
if((i__5727__auto___35407 < len__5726__auto___35406)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35407]));

var G__35408 = (i__5727__auto___35407 + (1));
i__5727__auto___35407 = G__35408;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((0) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((0)),(0),null)):null);
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(argseq__5752__auto__);

}
});

(cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0 = (function (){
return ({});
}));

(cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$2 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.goog$module$goog$object.create,keyvals) : cljs.core.apply.call(null, cljs.core.goog$module$goog$object.create,keyvals));
}));

/** @this {Function} */
(cljs.core.js_obj.cljs$lang$applyTo = (function (seq33171){
var self__5712__auto__ = this;
return self__5712__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq33171));
}));

(cljs.core.js_obj.cljs$lang$maxFixedArity = (0));

/**
 * Return the JavaScript keys for an object.
 */
cljs.core.js_keys = (function cljs$core$js_keys(obj){
return cljs.core.goog$module$goog$object.getKeys(obj);
});
/**
 * Delete a property from a JavaScript object.
 *   Returns true upon success, false otherwise.
 */
cljs.core.js_delete = (function cljs$core$js_delete(obj,key){
return delete obj[key];
});
cljs.core.array_copy = (function cljs$core$array_copy(from,i,to,j,len){
var i__$1 = i;
var j__$1 = j;
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__35410 = (i__$1 + (1));
var G__35411 = (j__$1 + (1));
var G__35412 = (len__$1 - (1));
i__$1 = G__35410;
j__$1 = G__35411;
len__$1 = G__35412;
continue;
}
break;
}
});
cljs.core.array_copy_downward = (function cljs$core$array_copy_downward(from,i,to,j,len){
var i__$1 = (i + (len - (1)));
var j__$1 = (j + (len - (1)));
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__35414 = (i__$1 - (1));
var G__35415 = (j__$1 - (1));
var G__35416 = (len__$1 - (1));
i__$1 = G__35414;
j__$1 = G__35415;
len__$1 = G__35416;
continue;
}
break;
}
});
cljs.core.lookup_sentinel = ({});
/**
 * Returns true if x is the value false, false otherwise.
 */
cljs.core.false_QMARK_ = (function cljs$core$false_QMARK_(x){
return x === false;
});
/**
 * Returns true if x is the value true, false otherwise.
 */
cljs.core.true_QMARK_ = (function cljs$core$true_QMARK_(x){
return x === true;
});
/**
 * Return true if x is a Boolean
 */
cljs.core.boolean_QMARK_ = (function cljs$core$boolean_QMARK_(x){
return ((x === true) || (x === false));
});
/**
 * Returns true if x identical to the JavaScript undefined value.
 */
cljs.core.undefined_QMARK_ = (function cljs$core$undefined_QMARK_(x){
return (void 0 === x);
});
/**
 * Return true if s satisfies ISeq
 */
cljs.core.seq_QMARK_ = (function cljs$core$seq_QMARK_(s){
if((s == null)){
return false;
} else {
if((!((s == null)))){
if((((s.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$ISeq$)))){
return true;
} else {
if((!s.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,s);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,s);
}
}
});
/**
 * Return true if the seq function is supported for s
 */
cljs.core.seqable_QMARK_ = (function cljs$core$seqable_QMARK_(s){
var or__5002__auto__ = (s == null);
if(or__5002__auto__){
return or__5002__auto__;
} else {
var or__5002__auto____$1 = (((!((s == null))))?(((((s.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$ISeqable$))))?true:(((!s.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,s):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,s));
if(or__5002__auto____$1){
return or__5002__auto____$1;
} else {
return ((cljs.core.array_QMARK_(s)) || (typeof s === 'string'));
}
}
});
/**
 * Coerce to boolean
 */
cljs.core.boolean$ = (function cljs$core$boolean(x){
if((x == null)){
return false;
} else {
if(x === false){
return false;
} else {
return true;

}
}
});
/**
 * Returns true if f returns true for fn? or satisfies IFn.
 */
cljs.core.ifn_QMARK_ = (function cljs$core$ifn_QMARK_(f){
var or__5002__auto__ = cljs.core.fn_QMARK_(f);
if(or__5002__auto__){
return or__5002__auto__;
} else {
if((!((f == null)))){
if((((f.cljs$lang$protocol_mask$partition0$ & (1))) || ((cljs.core.PROTOCOL_SENTINEL === f.cljs$core$IFn$)))){
return true;
} else {
if((!f.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,f);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,f);
}
}
});
/**
 * Returns true if n is a JavaScript number with no decimal part.
 */
cljs.core.integer_QMARK_ = (function cljs$core$integer_QMARK_(n){
return ((typeof n === 'number') && ((((!(isNaN(n)))) && ((((!((n === Infinity)))) && ((parseFloat(n) === parseInt(n,(10)))))))));
});
/**
 * INTERNAL: do not use
 */
cljs.core.LongImpl = cljs.core.goog$module$goog$math$Long;
/**
 * Return true if x satisfies integer? or is an instance of goog.math.Integer
 * or goog.math.Long.
 */
cljs.core.int_QMARK_ = (function cljs$core$int_QMARK_(x){
return ((cljs.core.integer_QMARK_(x)) || ((((x instanceof goog.math.Integer)) || ((x instanceof cljs.core.goog$module$goog$math$Long)))));
});
/**
 * Return true if x satisfies int? and is positive.
 */
cljs.core.pos_int_QMARK_ = (function cljs$core$pos_int_QMARK_(x){
if(cljs.core.integer_QMARK_(x)){
return (x > (0));
} else {
if((x instanceof goog.math.Integer)){
return ((cljs.core.not(x.isNegative())) && (cljs.core.not(x.isZero())));
} else {
if((x instanceof cljs.core.goog$module$goog$math$Long)){
return ((cljs.core.not(x.isNegative())) && (cljs.core.not(x.isZero())));
} else {
return false;

}
}
}
});
/**
 * Return true if x satisfies int? and is negative.
 */
cljs.core.neg_int_QMARK_ = (function cljs$core$neg_int_QMARK_(x){
if(cljs.core.integer_QMARK_(x)){
return (x < (0));
} else {
if((x instanceof goog.math.Integer)){
return x.isNegative();
} else {
if((x instanceof cljs.core.goog$module$goog$math$Long)){
return x.isNegative();
} else {
return false;

}
}
}
});
/**
 * Return true if x satisfies int? and is a natural integer value.
 */
cljs.core.nat_int_QMARK_ = (function cljs$core$nat_int_QMARK_(x){
if(cljs.core.integer_QMARK_(x)){
return (!((x < (0))));
} else {
if((x instanceof goog.math.Integer)){
return cljs.core.not(x.isNegative());
} else {
if((x instanceof cljs.core.goog$module$goog$math$Long)){
return cljs.core.not(x.isNegative());
} else {
return false;

}
}
}
});
/**
 * Returns true for JavaScript numbers, false otherwise.
 */
cljs.core.float_QMARK_ = (function cljs$core$float_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true for JavaScript numbers, false otherwise.
 */
cljs.core.double_QMARK_ = (function cljs$core$double_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true for Infinity and -Infinity values.
 */
cljs.core.infinite_QMARK_ = (function cljs$core$infinite_QMARK_(x){
return (((x === Number.POSITIVE_INFINITY)) || ((x === Number.NEGATIVE_INFINITY)));
});
/**
 * Returns true if key is present in the given collection, otherwise
 *   returns false.  Note that for numerically indexed collections like
 *   vectors and arrays, this tests if the numeric key is within the
 *   range of indexes. 'contains?' operates constant or logarithmic time;
 *   it will not perform a linear search for a value.  See also 'some'.
 */
cljs.core.contains_QMARK_ = (function cljs$core$contains_QMARK_(coll,v){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IAssociative$))))?true:false):false)){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(null, v);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,coll)){
return cljs.core._contains_key_QMARK_(coll,v);
} else {
if((cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return false;
} else {
return true;

}
}
}
});
/**
 * Returns the map entry for key, or nil if key not present.
 */
cljs.core.find = (function cljs$core$find(coll,k){
if(cljs.core.ifind_QMARK_(coll)){
return cljs.core._find(coll,k);
} else {
if((((!((coll == null)))) && (((cljs.core.associative_QMARK_(coll)) && (cljs.core.contains_QMARK_(coll,k)))))){
return (new cljs.core.MapEntry(k,cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,k),null));
} else {
return null;
}
}
});
/**
 * Returns true if no two of the arguments are =
 */
cljs.core.distinct_QMARK_ = (function cljs$core$distinct_QMARK_(var_args){
var G__33185 = arguments.length;
switch (G__33185) {
case 1:
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35429 = arguments.length;
var i__5727__auto___35430 = (0);
while(true){
if((i__5727__auto___35430 < len__5726__auto___35429)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35430]));

var G__35432 = (i__5727__auto___35430 + (1));
i__5727__auto___35430 = G__35432;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
}));

(cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)));
}));

(cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
if((!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)))){
var s = cljs.core.PersistentHashSet.createAsIfByAssoc([x,y]);
var xs = more;
while(true){
var x__$1 = cljs.core.first(xs);
var etc = cljs.core.next(xs);
if(cljs.core.truth_(xs)){
if(cljs.core.contains_QMARK_(s,x__$1)){
return false;
} else {
var G__35437 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s,x__$1);
var G__35438 = etc;
s = G__35437;
xs = G__35438;
continue;
}
} else {
return true;
}
break;
}
} else {
return false;
}
}));

/** @this {Function} */
(cljs.core.distinct_QMARK_.cljs$lang$applyTo = (function (seq33182){
var G__33183 = cljs.core.first(seq33182);
var seq33182__$1 = cljs.core.next(seq33182);
var G__33184 = cljs.core.first(seq33182__$1);
var seq33182__$2 = cljs.core.next(seq33182__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33183,G__33184,seq33182__$2);
}));

(cljs.core.distinct_QMARK_.cljs$lang$maxFixedArity = (2));

/**
 * Comparator. Returns a negative number, zero, or a positive number
 *   when x is logically 'less than', 'equal to', or 'greater than'
 *   y. Uses IComparable if available and google.array.defaultCompare for objects
 *  of the same type and special-cases nil to be less than any other object.
 */
cljs.core.compare = (function cljs$core$compare(x,y){
if((x === y)){
return (0);
} else {
if((x == null)){
return (-1);
} else {
if((y == null)){
return (1);
} else {
if(typeof x === 'number'){
if(typeof y === 'number'){
return cljs.core.goog$module$goog$array.defaultCompare(x,y);
} else {
throw (new Error(["Cannot compare ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(y)].join('')));
}
} else {
if((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition1$ & (2048))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IComparable$))))?true:(((!x.cljs$lang$protocol_mask$partition1$))?cljs.core.native_satisfies_QMARK_(cljs.core.IComparable,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IComparable,x))){
return cljs.core._compare(x,y);
} else {
if(((((typeof x === 'string') || (((cljs.core.array_QMARK_(x)) || (((x === true) || (x === false))))))) && ((cljs.core.type(x) === cljs.core.type(y))))){
return cljs.core.goog$module$goog$array.defaultCompare(x,y);
} else {
throw (new Error(["Cannot compare ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(y)].join('')));
}

}
}
}
}
}
});
/**
 * Compare indexed collection.
 */
cljs.core.compare_indexed = (function cljs$core$compare_indexed(var_args){
var G__33188 = arguments.length;
switch (G__33188) {
case 2:
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2 = (function (xs,ys){
var xl = cljs.core.count(xs);
var yl = cljs.core.count(ys);
if((xl < yl)){
return (-1);
} else {
if((xl > yl)){
return (1);
} else {
if((xl === (0))){
return (0);
} else {
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(xs,ys,xl,(0));

}
}
}
}));

(cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4 = (function (xs,ys,len,n){
while(true){
var d = cljs.core.compare(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(xs,n),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ys,n));
if((((d === (0))) && (((n + (1)) < len)))){
var G__35451 = xs;
var G__35452 = ys;
var G__35453 = len;
var G__35454 = (n + (1));
xs = G__35451;
ys = G__35452;
len = G__35453;
n = G__35454;
continue;
} else {
return d;
}
break;
}
}));

(cljs.core.compare_indexed.cljs$lang$maxFixedArity = 4);

/**
 * Given a fn that might be boolean valued or a comparator,
 * return a fn that is a comparator.
 */
cljs.core.fn__GT_comparator = (function cljs$core$fn__GT_comparator(f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f,cljs.core.compare)){
return cljs.core.compare;
} else {
return (function (x,y){
var r = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null, x,y));
if(typeof r === 'number'){
return r;
} else {
if(cljs.core.truth_(r)){
return (-1);
} else {
if(cljs.core.truth_((f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(y,x) : f.call(null, y,x)))){
return (1);
} else {
return (0);
}
}
}
});
}
});
/**
 * Returns a sorted sequence of the items in coll. Comp can be
 * boolean-valued comparison function, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort = (function cljs$core$sort(var_args){
var G__33190 = arguments.length;
switch (G__33190) {
case 1:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.sort.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,coll);
}));

(cljs.core.sort.cljs$core$IFn$_invoke$arity$2 = (function (comp,coll){
if(cljs.core.seq(coll)){
var a = (cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.to_array.call(null, coll));
cljs.core.goog$module$goog$array.stableSort(a,cljs.core.fn__GT_comparator(comp));

return cljs.core.with_meta(cljs.core.seq(a),cljs.core.meta(coll));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.sort.cljs$lang$maxFixedArity = 2);

/**
 * Returns a sorted sequence of the items in coll, where the sort
 * order is determined by comparing (keyfn item).  Comp can be
 * boolean-valued comparison function, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort_by = (function cljs$core$sort_by(var_args){
var G__33192 = arguments.length;
switch (G__33192) {
case 2:
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,coll){
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,cljs.core.compare,coll);
}));

(cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3 = (function (keyfn,comp,coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((function (x,y){
var G__33194 = (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(x) : keyfn.call(null, x));
var G__33195 = (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(y) : keyfn.call(null, y));
var fexpr__33193 = cljs.core.fn__GT_comparator(comp);
return (fexpr__33193.cljs$core$IFn$_invoke$arity$2 ? fexpr__33193.cljs$core$IFn$_invoke$arity$2(G__33194,G__33195) : fexpr__33193.call(null, G__33194,G__33195));
}),coll);
}));

(cljs.core.sort_by.cljs$lang$maxFixedArity = 3);

cljs.core.seq_reduce = (function cljs$core$seq_reduce(var_args){
var G__33197 = arguments.length;
switch (G__33197) {
case 2:
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var temp__5821__auto__ = cljs.core.seq(coll);
if(temp__5821__auto__){
var s = temp__5821__auto__;
var G__33198 = f;
var G__33199 = cljs.core.first(s);
var G__33200 = cljs.core.next(s);
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__33198,G__33199,G__33200) : cljs.core.reduce.call(null, G__33198,G__33199,G__33200));
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null, ));
}
}));

(cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 = (function (f,val,coll){
var val__$1 = val;
var coll__$1 = cljs.core.seq(coll);
while(true){
if(coll__$1){
var nval = (function (){var G__33201 = val__$1;
var G__33202 = cljs.core.first(coll__$1);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__33201,G__33202) : f.call(null, G__33201,G__33202));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__35469 = nval;
var G__35470 = cljs.core.next(coll__$1);
val__$1 = G__35469;
coll__$1 = G__35470;
continue;
}
} else {
return val__$1;
}
break;
}
}));

(cljs.core.seq_reduce.cljs$lang$maxFixedArity = 3);

/**
 * Return a random permutation of coll
 */
cljs.core.shuffle = (function cljs$core$shuffle(coll){
var a = (cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.to_array.call(null, coll));
cljs.core.goog$module$goog$array.shuffle(a);

return (cljs.core.vec.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vec.cljs$core$IFn$_invoke$arity$1(a) : cljs.core.vec.call(null, a));
});
cljs.core.iter_reduce = (function cljs$core$iter_reduce(var_args){
var G__33204 = arguments.length;
switch (G__33204) {
case 2:
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2 = (function (coll,f){
var iter = cljs.core._iterator(coll);
if(cljs.core.truth_(iter.hasNext())){
var init = iter.next();
var acc = init;
while(true){
if(iter.hasNext()){
var nacc = (function (){var G__33205 = acc;
var G__33206 = iter.next();
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__33205,G__33206) : f.call(null, G__33205,G__33206));
})();
if(cljs.core.reduced_QMARK_(nacc)){
return cljs.core.deref(nacc);
} else {
var G__35474 = nacc;
acc = G__35474;
continue;
}
} else {
return acc;
}
break;
}
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null, ));
}
}));

(cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3 = (function (coll,f,init){
var iter = cljs.core._iterator(coll);
var acc = init;
while(true){
if(iter.hasNext()){
var nacc = (function (){var G__33207 = acc;
var G__33208 = iter.next();
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__33207,G__33208) : f.call(null, G__33207,G__33208));
})();
if(cljs.core.reduced_QMARK_(nacc)){
return cljs.core.deref(nacc);
} else {
var G__35476 = nacc;
acc = G__35476;
continue;
}
} else {
return acc;
}
break;
}
}));

(cljs.core.iter_reduce.cljs$lang$maxFixedArity = 3);

/**
 * f should be a function of 2 arguments. If val is not supplied,
 *   returns the result of applying f to the first 2 items in coll, then
 *   applying f to that result and the 3rd item, etc. If coll contains no
 *   items, f must accept no arguments as well, and reduce returns the
 *   result of calling f with no arguments.  If coll has only 1 item, it
 *   is returned and f is not called.  If val is supplied, returns the
 *   result of applying f to val and the first item in coll, then
 *   applying f to that result and the 2nd item, etc. If coll contains no
 *   items, returns val and f is not called.
 */
cljs.core.reduce = (function cljs$core$reduce(var_args){
var G__33210 = arguments.length;
switch (G__33210) {
case 2:
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.reduce.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReduce$))))?true:false):false)){
return coll.cljs$core$IReduce$_reduce$arity$2(null, f);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce(coll,f);
} else {
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll);

}
}
}
}
}
}));

(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 = (function (f,val,coll){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReduce$))))?true:false):false)){
return coll.cljs$core$IReduce$_reduce$arity$3(null, f,val);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce(coll,f,val);
} else {
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,val,coll);

}
}
}
}
}
}));

(cljs.core.reduce.cljs$lang$maxFixedArity = 3);

/**
 * Reduces an associative collection. f should be a function of 3
 *   arguments. Returns the result of applying f to init, the first key
 *   and the first value in coll, then applying f to that result and the
 *   2nd key and value, etc. If coll contains no entries, returns init
 *   and f is not called. Note that reduce-kv is supported on vectors,
 *   where the keys will be the ordinals.
 */
cljs.core.reduce_kv = (function cljs$core$reduce_kv(f,init,coll){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (1048576))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IKVReduce$))))?true:(((!coll.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IKVReduce,coll):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IKVReduce,coll))){
return cljs.core._kv_reduce(coll,f,init);
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret,me){
var G__33214 = ret;
var G__33215 = cljs.core._key(me);
var G__33216 = cljs.core._val(me);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__33214,G__33215,G__33216) : f.call(null, G__33214,G__33215,G__33216));
}),init,coll);
}
});
/**
 * Returns its argument.
 */
cljs.core.identity = (function cljs$core$identity(x){
return x;
});
/**
 * Takes a reducing function f of 2 args and returns a fn suitable for
 *   transduce by adding an arity-1 signature that calls cf (default -
 *   identity) on the result argument.
 */
cljs.core.completing = (function cljs$core$completing(var_args){
var G__33218 = arguments.length;
switch (G__33218) {
case 1:
return cljs.core.completing.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.completing.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.completing.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(f,cljs.core.identity);
}));

(cljs.core.completing.cljs$core$IFn$_invoke$arity$2 = (function (f,cf){
return (function() {
var G__35484 = null;
var G__35484__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null, ));
});
var G__35484__1 = (function (x){
return (cf.cljs$core$IFn$_invoke$arity$1 ? cf.cljs$core$IFn$_invoke$arity$1(x) : cf.call(null, x));
});
var G__35484__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null, x,y));
});
G__35484 = function(x,y){
switch(arguments.length){
case 0:
return G__35484__0.call(this);
case 1:
return G__35484__1.call(this,x);
case 2:
return G__35484__2.call(this,x,y);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35484.cljs$core$IFn$_invoke$arity$0 = G__35484__0;
G__35484.cljs$core$IFn$_invoke$arity$1 = G__35484__1;
G__35484.cljs$core$IFn$_invoke$arity$2 = G__35484__2;
return G__35484;
})()
}));

(cljs.core.completing.cljs$lang$maxFixedArity = 2);

/**
 * reduce with a transformation of f (xf). If init is not
 *   supplied, (f) will be called to produce it. f should be a reducing
 *   step function that accepts both 1 and 2 arguments, if it accepts
 *   only 2 you can add the arity-1 with 'completing'. Returns the result
 *   of applying (the transformed) xf to init and the first item in coll,
 *   then applying xf to that result and the 2nd item, etc. If coll
 *   contains no items, returns init and f is not called. Note that
 *   certain transforms may inject or skip items.
 */
cljs.core.transduce = (function cljs$core$transduce(var_args){
var G__33220 = arguments.length;
switch (G__33220) {
case 3:
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.transduce.cljs$core$IFn$_invoke$arity$3 = (function (xform,f,coll){
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,f,(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null, )),coll);
}));

(cljs.core.transduce.cljs$core$IFn$_invoke$arity$4 = (function (xform,f,init,coll){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null, f));
var ret = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f__$1,init,coll);
return (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(ret) : f__$1.call(null, ret));
}));

(cljs.core.transduce.cljs$lang$maxFixedArity = 4);

/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core._PLUS_ = (function cljs$core$_PLUS_(var_args){
var G__33225 = arguments.length;
switch (G__33225) {
case 0:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35493 = arguments.length;
var i__5727__auto___35494 = (0);
while(true){
if((i__5727__auto___35494 < len__5726__auto___35493)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35494]));

var G__35499 = (i__5727__auto___35494 + (1));
i__5727__auto___35494 = G__35499;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
}));

(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
}));

(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
}));

(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(x + y),more);
}));

/** @this {Function} */
(cljs.core._PLUS_.cljs$lang$applyTo = (function (seq33222){
var G__33223 = cljs.core.first(seq33222);
var seq33222__$1 = cljs.core.next(seq33222);
var G__33224 = cljs.core.first(seq33222__$1);
var seq33222__$2 = cljs.core.next(seq33222__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33223,G__33224,seq33222__$2);
}));

(cljs.core._PLUS_.cljs$lang$maxFixedArity = (2));

/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core._ = (function cljs$core$_(var_args){
var G__33230 = arguments.length;
switch (G__33230) {
case 1:
return cljs.core._.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35506 = arguments.length;
var i__5727__auto___35507 = (0);
while(true){
if((i__5727__auto___35507 < len__5726__auto___35506)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35507]));

var G__35509 = (i__5727__auto___35507 + (1));
i__5727__auto___35507 = G__35509;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core._.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
}));

(cljs.core._.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
}));

(cljs.core._.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._,(x - y),more);
}));

/** @this {Function} */
(cljs.core._.cljs$lang$applyTo = (function (seq33227){
var G__33228 = cljs.core.first(seq33227);
var seq33227__$1 = cljs.core.next(seq33227);
var G__33229 = cljs.core.first(seq33227__$1);
var seq33227__$2 = cljs.core.next(seq33227__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33228,G__33229,seq33227__$2);
}));

(cljs.core._.cljs$lang$maxFixedArity = (2));

/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core._STAR_ = (function cljs$core$_STAR_(var_args){
var G__33235 = arguments.length;
switch (G__33235) {
case 0:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35514 = arguments.length;
var i__5727__auto___35515 = (0);
while(true){
if((i__5727__auto___35515 < len__5726__auto___35514)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35515]));

var G__35517 = (i__5727__auto___35515 + (1));
i__5727__auto___35515 = G__35517;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
}));

(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
}));

(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
}));

(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,(x * y),more);
}));

/** @this {Function} */
(cljs.core._STAR_.cljs$lang$applyTo = (function (seq33232){
var G__33233 = cljs.core.first(seq33232);
var seq33232__$1 = cljs.core.next(seq33232);
var G__33234 = cljs.core.first(seq33232__$1);
var seq33232__$2 = cljs.core.next(seq33232__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33233,G__33234,seq33232__$2);
}));

(cljs.core._STAR_.cljs$lang$maxFixedArity = (2));

/**
 * If no denominators are supplied, returns 1/numerator,
 *   else returns numerator divided by all of the denominators.
 */
cljs.core._SLASH_ = (function cljs$core$_SLASH_(var_args){
var G__33240 = arguments.length;
switch (G__33240) {
case 1:
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35521 = arguments.length;
var i__5727__auto___35522 = (0);
while(true){
if((i__5727__auto___35522 < len__5726__auto___35521)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35522]));

var G__35523 = (i__5727__auto___35522 + (1));
i__5727__auto___35522 = G__35523;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return ((1) / x);
}));

(cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x / y);
}));

(cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,(x / y),more);
}));

/** @this {Function} */
(cljs.core._SLASH_.cljs$lang$applyTo = (function (seq33237){
var G__33238 = cljs.core.first(seq33237);
var seq33237__$1 = cljs.core.next(seq33237);
var G__33239 = cljs.core.first(seq33237__$1);
var seq33237__$2 = cljs.core.next(seq33237__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33238,G__33239,seq33237__$2);
}));

(cljs.core._SLASH_.cljs$lang$maxFixedArity = (2));

/**
 * Returns non-nil if nums are in monotonically increasing order,
 *   otherwise false.
 */
cljs.core._LT_ = (function cljs$core$_LT_(var_args){
var G__33245 = arguments.length;
switch (G__33245) {
case 1:
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35527 = arguments.length;
var i__5727__auto___35528 = (0);
while(true){
if((i__5727__auto___35528 < len__5726__auto___35527)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35528]));

var G__35529 = (i__5727__auto___35528 + (1));
i__5727__auto___35528 = G__35529;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core._LT_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
}));

(cljs.core._LT_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x < y);
}));

(cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x < y)){
if(cljs.core.next(more)){
var G__35530 = y;
var G__35531 = cljs.core.first(more);
var G__35532 = cljs.core.next(more);
x = G__35530;
y = G__35531;
more = G__35532;
continue;
} else {
return (y < cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._LT_.cljs$lang$applyTo = (function (seq33242){
var G__33243 = cljs.core.first(seq33242);
var seq33242__$1 = cljs.core.next(seq33242);
var G__33244 = cljs.core.first(seq33242__$1);
var seq33242__$2 = cljs.core.next(seq33242__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33243,G__33244,seq33242__$2);
}));

(cljs.core._LT_.cljs$lang$maxFixedArity = (2));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 *   otherwise false.
 */
cljs.core._LT__EQ_ = (function cljs$core$_LT__EQ_(var_args){
var G__33250 = arguments.length;
switch (G__33250) {
case 1:
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35536 = arguments.length;
var i__5727__auto___35537 = (0);
while(true){
if((i__5727__auto___35537 < len__5726__auto___35536)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35537]));

var G__35538 = (i__5727__auto___35537 + (1));
i__5727__auto___35537 = G__35538;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
}));

(cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x <= y);
}));

(cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x <= y)){
if(cljs.core.next(more)){
var G__35557 = y;
var G__35558 = cljs.core.first(more);
var G__35559 = cljs.core.next(more);
x = G__35557;
y = G__35558;
more = G__35559;
continue;
} else {
return (y <= cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._LT__EQ_.cljs$lang$applyTo = (function (seq33247){
var G__33248 = cljs.core.first(seq33247);
var seq33247__$1 = cljs.core.next(seq33247);
var G__33249 = cljs.core.first(seq33247__$1);
var seq33247__$2 = cljs.core.next(seq33247__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33248,G__33249,seq33247__$2);
}));

(cljs.core._LT__EQ_.cljs$lang$maxFixedArity = (2));

/**
 * Returns non-nil if nums are in monotonically decreasing order,
 *   otherwise false.
 */
cljs.core._GT_ = (function cljs$core$_GT_(var_args){
var G__33255 = arguments.length;
switch (G__33255) {
case 1:
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35561 = arguments.length;
var i__5727__auto___35562 = (0);
while(true){
if((i__5727__auto___35562 < len__5726__auto___35561)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35562]));

var G__35563 = (i__5727__auto___35562 + (1));
i__5727__auto___35562 = G__35563;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core._GT_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
}));

(cljs.core._GT_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x > y);
}));

(cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x > y)){
if(cljs.core.next(more)){
var G__35564 = y;
var G__35565 = cljs.core.first(more);
var G__35566 = cljs.core.next(more);
x = G__35564;
y = G__35565;
more = G__35566;
continue;
} else {
return (y > cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._GT_.cljs$lang$applyTo = (function (seq33252){
var G__33253 = cljs.core.first(seq33252);
var seq33252__$1 = cljs.core.next(seq33252);
var G__33254 = cljs.core.first(seq33252__$1);
var seq33252__$2 = cljs.core.next(seq33252__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33253,G__33254,seq33252__$2);
}));

(cljs.core._GT_.cljs$lang$maxFixedArity = (2));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 *   otherwise false.
 */
cljs.core._GT__EQ_ = (function cljs$core$_GT__EQ_(var_args){
var G__33260 = arguments.length;
switch (G__33260) {
case 1:
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35568 = arguments.length;
var i__5727__auto___35569 = (0);
while(true){
if((i__5727__auto___35569 < len__5726__auto___35568)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35569]));

var G__35570 = (i__5727__auto___35569 + (1));
i__5727__auto___35569 = G__35570;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
}));

(cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x >= y);
}));

(cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x >= y)){
if(cljs.core.next(more)){
var G__35572 = y;
var G__35573 = cljs.core.first(more);
var G__35574 = cljs.core.next(more);
x = G__35572;
y = G__35573;
more = G__35574;
continue;
} else {
return (y >= cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._GT__EQ_.cljs$lang$applyTo = (function (seq33257){
var G__33258 = cljs.core.first(seq33257);
var seq33257__$1 = cljs.core.next(seq33257);
var G__33259 = cljs.core.first(seq33257__$1);
var seq33257__$2 = cljs.core.next(seq33257__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33258,G__33259,seq33257__$2);
}));

(cljs.core._GT__EQ_.cljs$lang$maxFixedArity = (2));

/**
 * Returns a number one less than num.
 */
cljs.core.dec = (function cljs$core$dec(x){
return (x - (1));
});
/**
 * Returns the absolute value of a.
 */
cljs.core.abs = (function cljs$core$abs(a){
return Math.abs(a);
});
/**
 * Returns the greatest of the nums.
 */
cljs.core.max = (function cljs$core$max(var_args){
var G__33265 = arguments.length;
switch (G__33265) {
case 1:
return cljs.core.max.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.max.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35577 = arguments.length;
var i__5727__auto___35578 = (0);
while(true){
if((i__5727__auto___35578 < len__5726__auto___35577)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35578]));

var G__35579 = (i__5727__auto___35578 + (1));
i__5727__auto___35578 = G__35579;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.max.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
}));

(cljs.core.max.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
var x__5087__auto__ = x;
var y__5088__auto__ = y;
return ((x__5087__auto__ > y__5088__auto__) ? x__5087__auto__ : y__5088__auto__);
}));

(cljs.core.max.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max,(function (){var x__5087__auto__ = x;
var y__5088__auto__ = y;
return ((x__5087__auto__ > y__5088__auto__) ? x__5087__auto__ : y__5088__auto__);
})(),more);
}));

/** @this {Function} */
(cljs.core.max.cljs$lang$applyTo = (function (seq33262){
var G__33263 = cljs.core.first(seq33262);
var seq33262__$1 = cljs.core.next(seq33262);
var G__33264 = cljs.core.first(seq33262__$1);
var seq33262__$2 = cljs.core.next(seq33262__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33263,G__33264,seq33262__$2);
}));

(cljs.core.max.cljs$lang$maxFixedArity = (2));

/**
 * Returns the least of the nums.
 */
cljs.core.min = (function cljs$core$min(var_args){
var G__33270 = arguments.length;
switch (G__33270) {
case 1:
return cljs.core.min.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.min.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35582 = arguments.length;
var i__5727__auto___35583 = (0);
while(true){
if((i__5727__auto___35583 < len__5726__auto___35582)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35583]));

var G__35584 = (i__5727__auto___35583 + (1));
i__5727__auto___35583 = G__35584;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.min.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
}));

(cljs.core.min.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
var x__5090__auto__ = x;
var y__5091__auto__ = y;
return ((x__5090__auto__ < y__5091__auto__) ? x__5090__auto__ : y__5091__auto__);
}));

(cljs.core.min.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.min,(function (){var x__5090__auto__ = x;
var y__5091__auto__ = y;
return ((x__5090__auto__ < y__5091__auto__) ? x__5090__auto__ : y__5091__auto__);
})(),more);
}));

/** @this {Function} */
(cljs.core.min.cljs$lang$applyTo = (function (seq33267){
var G__33268 = cljs.core.first(seq33267);
var seq33267__$1 = cljs.core.next(seq33267);
var G__33269 = cljs.core.first(seq33267__$1);
var seq33267__$2 = cljs.core.next(seq33267__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33268,G__33269,seq33267__$2);
}));

(cljs.core.min.cljs$lang$maxFixedArity = (2));

cljs.core.byte$ = (function cljs$core$byte(x){
return x;
});
/**
 * Coerce to char
 */
cljs.core.char$ = (function cljs$core$char(x){
if(typeof x === 'number'){
return String.fromCharCode(x);
} else {
if(((typeof x === 'string') && ((x.length === (1))))){
return x;
} else {
throw (new Error("Argument to char must be a character or number"));

}
}
});
cljs.core.short$ = (function cljs$core$short(x){
return x;
});
cljs.core.float$ = (function cljs$core$float(x){
return x;
});
cljs.core.double$ = (function cljs$core$double(x){
return x;
});
cljs.core.unchecked_byte = (function cljs$core$unchecked_byte(x){
return x;
});
cljs.core.unchecked_char = (function cljs$core$unchecked_char(x){
return x;
});
cljs.core.unchecked_short = (function cljs$core$unchecked_short(x){
return x;
});
cljs.core.unchecked_float = (function cljs$core$unchecked_float(x){
return x;
});
cljs.core.unchecked_double = (function cljs$core$unchecked_double(x){
return x;
});
/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core.unchecked_add = (function cljs$core$unchecked_add(var_args){
var G__33275 = arguments.length;
switch (G__33275) {
case 0:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35588 = arguments.length;
var i__5727__auto___35589 = (0);
while(true){
if((i__5727__auto___35589 < len__5726__auto___35588)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35589]));

var G__35590 = (i__5727__auto___35589 + (1));
i__5727__auto___35589 = G__35590;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
}));

(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
}));

(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
}));

(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add,(x + y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_add.cljs$lang$applyTo = (function (seq33272){
var G__33273 = cljs.core.first(seq33272);
var seq33272__$1 = cljs.core.next(seq33272);
var G__33274 = cljs.core.first(seq33272__$1);
var seq33272__$2 = cljs.core.next(seq33272__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33273,G__33274,seq33272__$2);
}));

(cljs.core.unchecked_add.cljs$lang$maxFixedArity = (2));

/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core.unchecked_add_int = (function cljs$core$unchecked_add_int(var_args){
var G__33280 = arguments.length;
switch (G__33280) {
case 0:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35594 = arguments.length;
var i__5727__auto___35595 = (0);
while(true){
if((i__5727__auto___35595 < len__5726__auto___35594)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35595]));

var G__35596 = (i__5727__auto___35595 + (1));
i__5727__auto___35595 = G__35596;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
}));

(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
}));

(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
}));

(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add_int,(x + y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_add_int.cljs$lang$applyTo = (function (seq33277){
var G__33278 = cljs.core.first(seq33277);
var seq33277__$1 = cljs.core.next(seq33277);
var G__33279 = cljs.core.first(seq33277__$1);
var seq33277__$2 = cljs.core.next(seq33277__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33278,G__33279,seq33277__$2);
}));

(cljs.core.unchecked_add_int.cljs$lang$maxFixedArity = (2));

/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec = (function cljs$core$unchecked_dec(x){
return (x - (1));
});
/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec_int = (function cljs$core$unchecked_dec_int(x){
return (x - (1));
});
/**
 * If no denominators are supplied, returns 1/numerator,
 *   else returns numerator divided by all of the denominators.
 */
cljs.core.unchecked_divide_int = (function cljs$core$unchecked_divide_int(var_args){
var G__33285 = arguments.length;
switch (G__33285) {
case 1:
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35599 = arguments.length;
var i__5727__auto___35600 = (0);
while(true){
if((i__5727__auto___35600 < len__5726__auto___35599)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35600]));

var G__35601 = (i__5727__auto___35600 + (1));
i__5727__auto___35600 = G__35601;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return ((1) / x);
}));

(cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x / y);
}));

(cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_divide_int,(x / y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_divide_int.cljs$lang$applyTo = (function (seq33282){
var G__33283 = cljs.core.first(seq33282);
var seq33282__$1 = cljs.core.next(seq33282);
var G__33284 = cljs.core.first(seq33282__$1);
var seq33282__$2 = cljs.core.next(seq33282__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33283,G__33284,seq33282__$2);
}));

(cljs.core.unchecked_divide_int.cljs$lang$maxFixedArity = (2));

cljs.core.unchecked_inc = (function cljs$core$unchecked_inc(x){
return (x + (1));
});
cljs.core.unchecked_inc_int = (function cljs$core$unchecked_inc_int(x){
return (x + (1));
});
/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core.unchecked_multiply = (function cljs$core$unchecked_multiply(var_args){
var G__33290 = arguments.length;
switch (G__33290) {
case 0:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35607 = arguments.length;
var i__5727__auto___35608 = (0);
while(true){
if((i__5727__auto___35608 < len__5726__auto___35607)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35608]));

var G__35611 = (i__5727__auto___35608 + (1));
i__5727__auto___35608 = G__35611;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
}));

(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
}));

(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
}));

(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply,(x * y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_multiply.cljs$lang$applyTo = (function (seq33287){
var G__33288 = cljs.core.first(seq33287);
var seq33287__$1 = cljs.core.next(seq33287);
var G__33289 = cljs.core.first(seq33287__$1);
var seq33287__$2 = cljs.core.next(seq33287__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33288,G__33289,seq33287__$2);
}));

(cljs.core.unchecked_multiply.cljs$lang$maxFixedArity = (2));

/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core.unchecked_multiply_int = (function cljs$core$unchecked_multiply_int(var_args){
var G__33295 = arguments.length;
switch (G__33295) {
case 0:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35613 = arguments.length;
var i__5727__auto___35614 = (0);
while(true){
if((i__5727__auto___35614 < len__5726__auto___35613)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35614]));

var G__35615 = (i__5727__auto___35614 + (1));
i__5727__auto___35614 = G__35615;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
}));

(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
}));

(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
}));

(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply_int,(x * y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_multiply_int.cljs$lang$applyTo = (function (seq33292){
var G__33293 = cljs.core.first(seq33292);
var seq33292__$1 = cljs.core.next(seq33292);
var G__33294 = cljs.core.first(seq33292__$1);
var seq33292__$2 = cljs.core.next(seq33292__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33293,G__33294,seq33292__$2);
}));

(cljs.core.unchecked_multiply_int.cljs$lang$maxFixedArity = (2));

cljs.core.unchecked_negate = (function cljs$core$unchecked_negate(x){
return (- x);
});
cljs.core.unchecked_negate_int = (function cljs$core$unchecked_negate_int(x){
return (- x);
});
cljs.core.unchecked_remainder_int = (function cljs$core$unchecked_remainder_int(x,n){
return (cljs.core.mod.cljs$core$IFn$_invoke$arity$2 ? cljs.core.mod.cljs$core$IFn$_invoke$arity$2(x,n) : cljs.core.mod.call(null, x,n));
});
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core.unchecked_subtract = (function cljs$core$unchecked_subtract(var_args){
var G__33300 = arguments.length;
switch (G__33300) {
case 1:
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35618 = arguments.length;
var i__5727__auto___35619 = (0);
while(true){
if((i__5727__auto___35619 < len__5726__auto___35618)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35619]));

var G__35620 = (i__5727__auto___35619 + (1));
i__5727__auto___35619 = G__35620;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
}));

(cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
}));

(cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract,(x - y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_subtract.cljs$lang$applyTo = (function (seq33297){
var G__33298 = cljs.core.first(seq33297);
var seq33297__$1 = cljs.core.next(seq33297);
var G__33299 = cljs.core.first(seq33297__$1);
var seq33297__$2 = cljs.core.next(seq33297__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33298,G__33299,seq33297__$2);
}));

(cljs.core.unchecked_subtract.cljs$lang$maxFixedArity = (2));

/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core.unchecked_subtract_int = (function cljs$core$unchecked_subtract_int(var_args){
var G__33305 = arguments.length;
switch (G__33305) {
case 1:
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35623 = arguments.length;
var i__5727__auto___35625 = (0);
while(true){
if((i__5727__auto___35625 < len__5726__auto___35623)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35625]));

var G__35626 = (i__5727__auto___35625 + (1));
i__5727__auto___35625 = G__35626;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
}));

(cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
}));

(cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract_int,(x - y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_subtract_int.cljs$lang$applyTo = (function (seq33302){
var G__33303 = cljs.core.first(seq33302);
var seq33302__$1 = cljs.core.next(seq33302);
var G__33304 = cljs.core.first(seq33302__$1);
var seq33302__$2 = cljs.core.next(seq33302__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33303,G__33304,seq33302__$2);
}));

(cljs.core.unchecked_subtract_int.cljs$lang$maxFixedArity = (2));

cljs.core.fix = (function cljs$core$fix(q){
if((q >= (0))){
return Math.floor(q);
} else {
return Math.ceil(q);
}
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.int$ = (function cljs$core$int(x){
return (x | (0));
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.unchecked_int = (function cljs$core$unchecked_int(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.long$ = (function cljs$core$long(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.unchecked_long = (function cljs$core$unchecked_long(x){
return cljs.core.fix(x);
});
cljs.core.booleans = (function cljs$core$booleans(x){
return x;
});
cljs.core.bytes = (function cljs$core$bytes(x){
return x;
});
cljs.core.chars = (function cljs$core$chars(x){
return x;
});
cljs.core.shorts = (function cljs$core$shorts(x){
return x;
});
cljs.core.ints = (function cljs$core$ints(x){
return x;
});
cljs.core.floats = (function cljs$core$floats(x){
return x;
});
cljs.core.doubles = (function cljs$core$doubles(x){
return x;
});
cljs.core.longs = (function cljs$core$longs(x){
return x;
});
/**
 * Modulus of num and div with original javascript behavior. i.e. bug for negative numbers
 */
cljs.core.js_mod = (function cljs$core$js_mod(n,d){
return (n % d);
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
cljs.core.mod = (function cljs$core$mod(n,d){
return (((n % d) + d) % d);
});
/**
 * quot[ient] of dividing numerator by denominator.
 */
cljs.core.quot = (function cljs$core$quot(n,d){
var rem = (n % d);
return cljs.core.fix(((n - rem) / d));
});
/**
 * remainder of dividing numerator by denominator.
 */
cljs.core.rem = (function cljs$core$rem(n,d){
var q = cljs.core.quot(n,d);
return (n - (d * q));
});
/**
 * Bitwise exclusive or
 */
cljs.core.bit_xor = (function cljs$core$bit_xor(var_args){
var G__33310 = arguments.length;
switch (G__33310) {
case 2:
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35631 = arguments.length;
var i__5727__auto___35632 = (0);
while(true){
if((i__5727__auto___35632 < len__5726__auto___35631)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35632]));

var G__35633 = (i__5727__auto___35632 + (1));
i__5727__auto___35632 = G__35633;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x ^ y);
}));

(cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_xor,(x ^ y),more);
}));

/** @this {Function} */
(cljs.core.bit_xor.cljs$lang$applyTo = (function (seq33307){
var G__33308 = cljs.core.first(seq33307);
var seq33307__$1 = cljs.core.next(seq33307);
var G__33309 = cljs.core.first(seq33307__$1);
var seq33307__$2 = cljs.core.next(seq33307__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33308,G__33309,seq33307__$2);
}));

(cljs.core.bit_xor.cljs$lang$maxFixedArity = (2));

/**
 * Bitwise and
 */
cljs.core.bit_and = (function cljs$core$bit_and(var_args){
var G__33315 = arguments.length;
switch (G__33315) {
case 2:
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35635 = arguments.length;
var i__5727__auto___35636 = (0);
while(true){
if((i__5727__auto___35636 < len__5726__auto___35635)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35636]));

var G__35637 = (i__5727__auto___35636 + (1));
i__5727__auto___35636 = G__35637;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x & y);
}));

(cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and,(x & y),more);
}));

/** @this {Function} */
(cljs.core.bit_and.cljs$lang$applyTo = (function (seq33312){
var G__33313 = cljs.core.first(seq33312);
var seq33312__$1 = cljs.core.next(seq33312);
var G__33314 = cljs.core.first(seq33312__$1);
var seq33312__$2 = cljs.core.next(seq33312__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33313,G__33314,seq33312__$2);
}));

(cljs.core.bit_and.cljs$lang$maxFixedArity = (2));

/**
 * Bitwise or
 */
cljs.core.bit_or = (function cljs$core$bit_or(var_args){
var G__33320 = arguments.length;
switch (G__33320) {
case 2:
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35651 = arguments.length;
var i__5727__auto___35652 = (0);
while(true){
if((i__5727__auto___35652 < len__5726__auto___35651)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35652]));

var G__35653 = (i__5727__auto___35652 + (1));
i__5727__auto___35652 = G__35653;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x | y);
}));

(cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_or,(x | y),more);
}));

/** @this {Function} */
(cljs.core.bit_or.cljs$lang$applyTo = (function (seq33317){
var G__33318 = cljs.core.first(seq33317);
var seq33317__$1 = cljs.core.next(seq33317);
var G__33319 = cljs.core.first(seq33317__$1);
var seq33317__$2 = cljs.core.next(seq33317__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33318,G__33319,seq33317__$2);
}));

(cljs.core.bit_or.cljs$lang$maxFixedArity = (2));

/**
 * Bitwise and with complement
 */
cljs.core.bit_and_not = (function cljs$core$bit_and_not(var_args){
var G__33325 = arguments.length;
switch (G__33325) {
case 2:
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35659 = arguments.length;
var i__5727__auto___35660 = (0);
while(true){
if((i__5727__auto___35660 < len__5726__auto___35659)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35660]));

var G__35661 = (i__5727__auto___35660 + (1));
i__5727__auto___35660 = G__35661;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x & ~y);
}));

(cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and_not,(x & ~y),more);
}));

/** @this {Function} */
(cljs.core.bit_and_not.cljs$lang$applyTo = (function (seq33322){
var G__33323 = cljs.core.first(seq33322);
var seq33322__$1 = cljs.core.next(seq33322);
var G__33324 = cljs.core.first(seq33322__$1);
var seq33322__$2 = cljs.core.next(seq33322__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33323,G__33324,seq33322__$2);
}));

(cljs.core.bit_and_not.cljs$lang$maxFixedArity = (2));

/**
 * Clear bit at index n
 */
cljs.core.bit_clear = (function cljs$core$bit_clear(x,n){
return (x & ~(1 << n));
});
/**
 * Flip bit at index n
 */
cljs.core.bit_flip = (function cljs$core$bit_flip(x,n){
return (x ^ (1 << n));
});
/**
 * Bitwise complement
 */
cljs.core.bit_not = (function cljs$core$bit_not(x){
return (~ x);
});
/**
 * Set bit at index n
 */
cljs.core.bit_set = (function cljs$core$bit_set(x,n){
return (x | (1 << n));
});
/**
 * Test bit at index n
 */
cljs.core.bit_test = (function cljs$core$bit_test(x,n){
return ((x & (1 << n)) != 0);
});
/**
 * Bitwise shift left
 */
cljs.core.bit_shift_left = (function cljs$core$bit_shift_left(x,n){
return (x << n);
});
/**
 * Bitwise shift right
 */
cljs.core.bit_shift_right = (function cljs$core$bit_shift_right(x,n){
return (x >> n);
});
/**
 * DEPRECATED: Bitwise shift right with zero fill
 */
cljs.core.bit_shift_right_zero_fill = (function cljs$core$bit_shift_right_zero_fill(x,n){
return (x >>> n);
});
/**
 * Bitwise shift right with zero fill
 */
cljs.core.unsigned_bit_shift_right = (function cljs$core$unsigned_bit_shift_right(x,n){
return (x >>> n);
});
/**
 * Counts the number of bits set in n
 */
cljs.core.bit_count = (function cljs$core$bit_count(v){
var v__$1 = (v - ((v >> (1)) & (1431655765)));
var v__$2 = ((v__$1 & (858993459)) + ((v__$1 >> (2)) & (858993459)));
return ((((v__$2 + (v__$2 >> (4))) & (252645135)) * (16843009)) >> (24));
});
/**
 * Returns non-nil if nums all have the equivalent
 *   value, otherwise false. Behavior on non nums is
 *   undefined.
 */
cljs.core._EQ__EQ_ = (function cljs$core$_EQ__EQ_(var_args){
var G__33330 = arguments.length;
switch (G__33330) {
case 1:
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35667 = arguments.length;
var i__5727__auto___35668 = (0);
while(true){
if((i__5727__auto___35668 < len__5726__auto___35667)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35668]));

var G__35669 = (i__5727__auto___35668 + (1));
i__5727__auto___35668 = G__35669;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
}));

(cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return cljs.core._equiv(x,y);
}));

(cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x === y)){
if(cljs.core.next(more)){
var G__35674 = y;
var G__35675 = cljs.core.first(more);
var G__35676 = cljs.core.next(more);
x = G__35674;
y = G__35675;
more = G__35676;
continue;
} else {
return (y === cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._EQ__EQ_.cljs$lang$applyTo = (function (seq33327){
var G__33328 = cljs.core.first(seq33327);
var seq33327__$1 = cljs.core.next(seq33327);
var G__33329 = cljs.core.first(seq33327__$1);
var seq33327__$2 = cljs.core.next(seq33327__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33328,G__33329,seq33327__$2);
}));

(cljs.core._EQ__EQ_.cljs$lang$maxFixedArity = (2));

/**
 * Returns true if num is greater than zero, else false
 */
cljs.core.pos_QMARK_ = (function cljs$core$pos_QMARK_(x){
return (x > (0));
});
/**
 * Returns true if num is zero, else false
 */
cljs.core.zero_QMARK_ = (function cljs$core$zero_QMARK_(x){
return (x === (0));
});
/**
 * Returns true if num is less than zero, else false
 */
cljs.core.neg_QMARK_ = (function cljs$core$neg_QMARK_(x){
return (x < (0));
});
/**
 * Returns the nth next of coll, (seq coll) when n is 0.
 */
cljs.core.nthnext = (function cljs$core$nthnext(coll,n){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition1$ & (262144))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IDrop$))))?true:false):false)){
if((n > (0))){
return coll.cljs$core$IDrop$_drop$arity$2(null, Math.ceil(n));
} else {
return cljs.core.seq(coll);
}
} else {
var n__$1 = n;
var xs = cljs.core.seq(coll);
while(true){
if(((xs) && ((n__$1 > (0))))){
var G__35679 = (n__$1 - (1));
var G__35680 = cljs.core.next(xs);
n__$1 = G__35679;
xs = G__35680;
continue;
} else {
return xs;
}
break;
}
}
});
/**
 * With no args, returns the empty string. With one arg x, returns
 *   x.toString().  (str nil) returns the empty string. With more than
 *   one arg, returns the concatenation of the str values of the args.
 */
cljs.core.str = (function cljs$core$str(var_args){
var G__33335 = arguments.length;
switch (G__33335) {
case 0:
return cljs.core.str.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35682 = arguments.length;
var i__5727__auto___35683 = (0);
while(true){
if((i__5727__auto___35683 < len__5726__auto___35682)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35683]));

var G__35684 = (i__5727__auto___35683 + (1));
i__5727__auto___35683 = G__35684;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((1) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((1)),(0),null)):null);
return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5752__auto__);

}
});

(cljs.core.str.cljs$core$IFn$_invoke$arity$0 = (function (){
return "";
}));

(cljs.core.str.cljs$core$IFn$_invoke$arity$1 = (function (x){
if((x == null)){
return "";
} else {
return [x].join("");
}
}));

(cljs.core.str.cljs$core$IFn$_invoke$arity$variadic = (function (x,ys){
var sb = (new goog.string.StringBuffer(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)));
var more = ys;
while(true){
if(cljs.core.truth_(more)){
var G__35689 = sb.append(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(more)));
var G__35690 = cljs.core.next(more);
sb = G__35689;
more = G__35690;
continue;
} else {
return sb.toString();
}
break;
}
}));

/** @this {Function} */
(cljs.core.str.cljs$lang$applyTo = (function (seq33333){
var G__33334 = cljs.core.first(seq33333);
var seq33333__$1 = cljs.core.next(seq33333);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33334,seq33333__$1);
}));

(cljs.core.str.cljs$lang$maxFixedArity = (1));

/**
 * Returns the substring of s beginning at start inclusive, and ending
 *   at end (defaults to length of string), exclusive.
 */
cljs.core.subs = (function cljs$core$subs(var_args){
var G__33337 = arguments.length;
switch (G__33337) {
case 2:
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.subs.cljs$core$IFn$_invoke$arity$2 = (function (s,start){
return s.substring(start);
}));

(cljs.core.subs.cljs$core$IFn$_invoke$arity$3 = (function (s,start,end){
return s.substring(start,end);
}));

(cljs.core.subs.cljs$lang$maxFixedArity = 3);


/**
 * Assumes x is sequential. Returns true if x equals y, otherwise
 *   returns false.
 */
cljs.core.equiv_sequential = (function cljs$core$equiv_sequential(x,y){
return cljs.core.boolean$(((cljs.core.sequential_QMARK_(y))?((((cljs.core.counted_QMARK_(x)) && (((cljs.core.counted_QMARK_(y)) && ((!((cljs.core.count(x) === cljs.core.count(y)))))))))?false:(function (){var xs = cljs.core.seq(x);
var ys = cljs.core.seq(y);
while(true){
if((xs == null)){
return (ys == null);
} else {
if((ys == null)){
return false;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(xs),cljs.core.first(ys))){
var G__35696 = cljs.core.next(xs);
var G__35697 = cljs.core.next(ys);
xs = G__35696;
ys = G__35697;
continue;
} else {
return false;

}
}
}
break;
}
})()):null));
});
cljs.core.hash_coll = (function cljs$core$hash_coll(coll){
if(cljs.core.seq(coll)){
var res = cljs.core.hash(cljs.core.first(coll));
var s = cljs.core.next(coll);
while(true){
if((s == null)){
return res;
} else {
var G__35699 = cljs.core.hash_combine(res,cljs.core.hash(cljs.core.first(s)));
var G__35700 = cljs.core.next(s);
res = G__35699;
s = G__35700;
continue;
}
break;
}
} else {
return (0);
}
});

cljs.core.hash_imap = (function cljs$core$hash_imap(m){
var h = (0);
var s = cljs.core.seq(m);
while(true){
if(s){
var e = cljs.core.first(s);
var G__35701 = ((h + (cljs.core.hash((cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.key.call(null, e))) ^ cljs.core.hash((cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.val.call(null, e))))) % (4503599627370496));
var G__35702 = cljs.core.next(s);
h = G__35701;
s = G__35702;
continue;
} else {
return h;
}
break;
}
});
cljs.core.hash_iset = (function cljs$core$hash_iset(s){
var h = (0);
var s__$1 = cljs.core.seq(s);
while(true){
if(s__$1){
var e = cljs.core.first(s__$1);
var G__35704 = ((h + cljs.core.hash(e)) % (4503599627370496));
var G__35705 = cljs.core.next(s__$1);
h = G__35704;
s__$1 = G__35705;
continue;
} else {
return h;
}
break;
}
});


/**
 * Takes a JavaScript object and a map of names to functions and
 *   attaches said functions as methods on the object.  Any references to
 *   JavaScript's implicit this (via the this-as macro) will resolve to the
 *   object that the function is attached.
 */
cljs.core.extend_object_BANG_ = (function cljs$core$extend_object_BANG_(obj,fn_map){
var seq__33338_35706 = cljs.core.seq(fn_map);
var chunk__33339_35707 = null;
var count__33340_35708 = (0);
var i__33341_35709 = (0);
while(true){
if((i__33341_35709 < count__33340_35708)){
var vec__33348_35710 = chunk__33339_35707.cljs$core$IIndexed$_nth$arity$2(null, i__33341_35709);
var key_name_35711 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33348_35710,(0),null);
var f_35712 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33348_35710,(1),null);
var str_name_35713 = (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(key_name_35711) : cljs.core.name.call(null, key_name_35711));
cljs.core.goog$module$goog$object.set(obj,str_name_35713,f_35712);


var G__35714 = seq__33338_35706;
var G__35715 = chunk__33339_35707;
var G__35716 = count__33340_35708;
var G__35717 = (i__33341_35709 + (1));
seq__33338_35706 = G__35714;
chunk__33339_35707 = G__35715;
count__33340_35708 = G__35716;
i__33341_35709 = G__35717;
continue;
} else {
var temp__5823__auto___35718 = cljs.core.seq(seq__33338_35706);
if(temp__5823__auto___35718){
var seq__33338_35719__$1 = temp__5823__auto___35718;
if(cljs.core.chunked_seq_QMARK_(seq__33338_35719__$1)){
var c__5525__auto___35720 = (cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1(seq__33338_35719__$1) : cljs.core.chunk_first.call(null, seq__33338_35719__$1));
var G__35721 = (cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1(seq__33338_35719__$1) : cljs.core.chunk_rest.call(null, seq__33338_35719__$1));
var G__35722 = c__5525__auto___35720;
var G__35723 = cljs.core.count(c__5525__auto___35720);
var G__35724 = (0);
seq__33338_35706 = G__35721;
chunk__33339_35707 = G__35722;
count__33340_35708 = G__35723;
i__33341_35709 = G__35724;
continue;
} else {
var vec__33351_35725 = cljs.core.first(seq__33338_35719__$1);
var key_name_35726 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33351_35725,(0),null);
var f_35727 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33351_35725,(1),null);
var str_name_35728 = (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(key_name_35726) : cljs.core.name.call(null, key_name_35726));
cljs.core.goog$module$goog$object.set(obj,str_name_35728,f_35727);


var G__35729 = cljs.core.next(seq__33338_35719__$1);
var G__35730 = null;
var G__35731 = (0);
var G__35732 = (0);
seq__33338_35706 = G__35729;
chunk__33339_35707 = G__35730;
count__33340_35708 = G__35731;
i__33341_35709 = G__35732;
continue;
}
} else {
}
}
break;
}

return obj;
});

/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.List = (function (meta,first,rest,count,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.count = count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65937646;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.List.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.List.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
}));

(cljs.core.List.prototype.indexOf = (function() {
var G__35733 = null;
var G__35733__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__35733__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__35733 = function(x,start){
switch(arguments.length){
case 1:
return G__35733__1.call(this,x);
case 2:
return G__35733__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35733.cljs$core$IFn$_invoke$arity$1 = G__35733__1;
G__35733.cljs$core$IFn$_invoke$arity$2 = G__35733__2;
return G__35733;
})()
);

(cljs.core.List.prototype.lastIndexOf = (function() {
var G__35736 = null;
var G__35736__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,self__.count);
});
var G__35736__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__35736 = function(x,start){
switch(arguments.length){
case 1:
return G__35736__1.call(this,x);
case 2:
return G__35736__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35736.cljs$core$IFn$_invoke$arity$1 = G__35736__1;
G__35736.cljs$core$IFn$_invoke$arity$2 = G__35736__2;
return G__35736;
})()
);

(cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.List(self__.meta,self__.first,self__.rest,self__.count,self__.__hash));
}));

(cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return null;
} else {
return self__.rest;
}
}));

(cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
}));

(cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
}));

(cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ISeq$_rest$arity$1(null, );
}));

(cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
}));

(cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
}));

(cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
}));

(cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.List(new_meta,self__.first,self__.rest,self__.count,self__.__hash));
}
}));

(cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,coll__$1,(self__.count + (1)),null));
}));

(cljs.core.List.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rest","rest",398835108,null),new cljs.core.Symbol(null,"count","count",-514511684,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.List.cljs$lang$type = true);

(cljs.core.List.cljs$lang$ctorStr = "cljs.core/List");

(cljs.core.List.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/List");
}));

/**
 * Positional factory function for cljs.core/List.
 */
cljs.core.__GT_List = (function cljs$core$__GT_List(meta,first,rest,count,__hash){
return (new cljs.core.List(meta,first,rest,count,__hash));
});

/**
 * Returns true if x implements IList
 */
cljs.core.list_QMARK_ = (function cljs$core$list_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (33554432))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IList$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,x);
}
});
(cljs.core.List.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.EmptyList = (function (meta){
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 65937614;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.EmptyList.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.EmptyList.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
}));

(cljs.core.EmptyList.prototype.indexOf = (function() {
var G__35740 = null;
var G__35740__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__35740__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__35740 = function(x,start){
switch(arguments.length){
case 1:
return G__35740__1.call(this,x);
case 2:
return G__35740__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35740.cljs$core$IFn$_invoke$arity$1 = G__35740__1;
G__35740.cljs$core$IFn$_invoke$arity$2 = G__35740__2;
return G__35740;
})()
);

(cljs.core.EmptyList.prototype.lastIndexOf = (function() {
var G__35741 = null;
var G__35741__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__35741__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__35741 = function(x,start){
switch(arguments.length){
case 1:
return G__35741__1.call(this,x);
case 2:
return G__35741__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35741.cljs$core$IFn$_invoke$arity$1 = G__35741__1;
G__35741.cljs$core$IFn$_invoke$arity$2 = G__35741__2;
return G__35741;
})()
);

(cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.EmptyList(self__.meta));
}));

(cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
}));

(cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (0);
}));

(cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
}));

(cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
throw (new Error("Can't pop empty list"));
}));

(cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.empty_ordered_hash;
}));

(cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if(((cljs.core.list_QMARK_(other)) || (cljs.core.sequential_QMARK_(other)))){
return (cljs.core.seq(other) == null);
} else {
return false;
}
}));

(cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
}));

(cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
}));

(cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.EmptyList(new_meta));
}
}));

(cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,null,(1),null));
}));

(cljs.core.EmptyList.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
}));

(cljs.core.EmptyList.cljs$lang$type = true);

(cljs.core.EmptyList.cljs$lang$ctorStr = "cljs.core/EmptyList");

(cljs.core.EmptyList.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/EmptyList");
}));

/**
 * Positional factory function for cljs.core/EmptyList.
 */
cljs.core.__GT_EmptyList = (function cljs$core$__GT_EmptyList(meta){
return (new cljs.core.EmptyList(meta));
});

(cljs.core.List.EMPTY = (new cljs.core.EmptyList(null)));
(cljs.core.EmptyList.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));
/**
 * Returns true if coll satisfies? IReversible.
 */
cljs.core.reversible_QMARK_ = (function cljs$core$reversible_QMARK_(coll){
if((!((coll == null)))){
if((((coll.cljs$lang$protocol_mask$partition0$ & (134217728))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReversible$)))){
return true;
} else {
if((!coll.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,coll);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,coll);
}
});
/**
 * Returns, in constant time, a seq of the items in rev (which
 *   can be a vector or sorted-map), in reverse order. If rev is empty returns nil
 */
cljs.core.rseq = (function cljs$core$rseq(rev){
return cljs.core._rseq(rev);
});
/**
 * Returns a seq of the items in coll in reverse order. Not lazy.
 */
cljs.core.reverse = (function cljs$core$reverse(coll){
if(cljs.core.reversible_QMARK_(coll)){
var or__5002__auto__ = cljs.core.rseq(coll);
if(or__5002__auto__){
return or__5002__auto__;
} else {
return cljs.core.List.EMPTY;
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,coll);
}
});
/**
 * Creates a new list containing the items.
 */
cljs.core.list = (function cljs$core$list(var_args){
var args__5732__auto__ = [];
var len__5726__auto___35754 = arguments.length;
var i__5727__auto___35755 = (0);
while(true){
if((i__5727__auto___35755 < len__5726__auto___35754)){
args__5732__auto__.push((arguments[i__5727__auto___35755]));

var G__35756 = (i__5727__auto___35755 + (1));
i__5727__auto___35755 = G__35756;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((0) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((0)),(0),null)):null);
return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(argseq__5733__auto__);
});

(cljs.core.list.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
var arr = (((((xs instanceof cljs.core.IndexedSeq)) && ((xs.i === (0)))))?xs.arr:(function (){var arr = [];
var xs__$1 = xs;
while(true){
if((!((xs__$1 == null)))){
arr.push(cljs.core._first(xs__$1));

var G__35757 = cljs.core._next(xs__$1);
xs__$1 = G__35757;
continue;
} else {
return arr;
}
break;
}
})());
var i = arr.length;
var r = cljs.core.List.EMPTY;
while(true){
if((i > (0))){
var G__35758 = (i - (1));
var G__35759 = cljs.core._conj(r,(arr[(i - (1))]));
i = G__35758;
r = G__35759;
continue;
} else {
return r;
}
break;
}
}));

(cljs.core.list.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.list.cljs$lang$applyTo = (function (seq33356){
var self__5712__auto__ = this;
return self__5712__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq33356));
}));


/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Cons = (function (meta,first,rest,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65929452;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.Cons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Cons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
}));

(cljs.core.Cons.prototype.indexOf = (function() {
var G__35760 = null;
var G__35760__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__35760__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__35760 = function(x,start){
switch(arguments.length){
case 1:
return G__35760__1.call(this,x);
case 2:
return G__35760__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35760.cljs$core$IFn$_invoke$arity$1 = G__35760__1;
G__35760.cljs$core$IFn$_invoke$arity$2 = G__35760__2;
return G__35760;
})()
);

(cljs.core.Cons.prototype.lastIndexOf = (function() {
var G__35761 = null;
var G__35761__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__35761__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__35761 = function(x,start){
switch(arguments.length){
case 1:
return G__35761__1.call(this,x);
case 2:
return G__35761__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35761.cljs$core$IFn$_invoke$arity$1 = G__35761__1;
G__35761.cljs$core$IFn$_invoke$arity$2 = G__35761__2;
return G__35761;
})()
);

(cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Cons(self__.meta,self__.first,self__.rest,self__.__hash));
}));

(cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return null;
} else {
return cljs.core.seq(self__.rest);
}
}));

(cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
}));

(cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
}));

(cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Cons(new_meta,self__.first,self__.rest,self__.__hash));
}
}));

(cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(null,o,coll__$1,null));
}));

(cljs.core.Cons.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rest","rest",398835108,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Cons.cljs$lang$type = true);

(cljs.core.Cons.cljs$lang$ctorStr = "cljs.core/Cons");

(cljs.core.Cons.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/Cons");
}));

/**
 * Positional factory function for cljs.core/Cons.
 */
cljs.core.__GT_Cons = (function cljs$core$__GT_Cons(meta,first,rest,__hash){
return (new cljs.core.Cons(meta,first,rest,__hash));
});

(cljs.core.Cons.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));
/**
 * Returns a new seq where x is the first element and coll is the rest.
 */
cljs.core.cons = (function cljs$core$cons(x,coll){
if((coll == null)){
return (new cljs.core.List(null,x,null,(1),null));
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false)){
return (new cljs.core.Cons(null,x,coll,null));
} else {
return (new cljs.core.Cons(null,x,cljs.core.seq(coll),null));

}
}
});
cljs.core.hash_keyword = (function cljs$core$hash_keyword(k){
return ((cljs.core.hash_symbol(k) + (2654435769)) | (0));
});
cljs.core.compare_keywords = (function cljs$core$compare_keywords(a,b){
if((a.fqn === b.fqn)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__5000__auto__ = cljs.core.not(a.ns);
if(and__5000__auto__){
return b.ns;
} else {
return and__5000__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = cljs.core.goog$module$goog$array.defaultCompare(a.ns,b.ns);
if(((0) === nsc)){
return cljs.core.goog$module$goog$array.defaultCompare(a.name,b.name);
} else {
return nsc;
}
}
} else {
return cljs.core.goog$module$goog$array.defaultCompare(a.name,b.name);

}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.INamed}
 * @implements {cljs.core.IPrintWithWriter}
*/
cljs.core.Keyword = (function (ns,name,fqn,_hash){
this.ns = ns;
this.name = name;
this.fqn = fqn;
this._hash = _hash;
this.cljs$lang$protocol_mask$partition0$ = 2153775105;
this.cljs$lang$protocol_mask$partition1$ = 4096;
});
(cljs.core.Keyword.prototype.toString = (function (){
var self__ = this;
var _ = this;
return [":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.fqn)].join('');
}));

(cljs.core.Keyword.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
}));

(cljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Keyword)){
return (self__.fqn === other.fqn);
} else {
return false;
}
}));

(cljs.core.Keyword.prototype.call = (function (unused__11804__auto__){
var self__ = this;
var self__ = this;
var G__33359 = (arguments.length - (1));
switch (G__33359) {
case (1):
return self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));

break;
case (2):
return self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(cljs.core.Keyword.prototype.apply = (function (self__,args33358){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args33358)));
}));

(cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
}));

(cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
}));

(cljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__5111__auto__ = self__._hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_keyword(this$__$1);
(self__._hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
}));

(cljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
}));

(cljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,[":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.fqn)].join(''));
}));

(cljs.core.Keyword.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ns","ns",2082130287,null),new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"fqn","fqn",-1749334463,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_hash","_hash",-2130838312,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Keyword.cljs$lang$type = true);

(cljs.core.Keyword.cljs$lang$ctorStr = "cljs.core/Keyword");

(cljs.core.Keyword.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/Keyword");
}));

/**
 * Positional factory function for cljs.core/Keyword.
 */
cljs.core.__GT_Keyword = (function cljs$core$__GT_Keyword(ns,name,fqn,_hash){
return (new cljs.core.Keyword(ns,name,fqn,_hash));
});

/**
 * Return true if x is a Keyword
 */
cljs.core.keyword_QMARK_ = (function cljs$core$keyword_QMARK_(x){
return (x instanceof cljs.core.Keyword);
});
/**
 * Efficient test to determine that two keywords are identical.
 */
cljs.core.keyword_identical_QMARK_ = (function cljs$core$keyword_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if((((x instanceof cljs.core.Keyword)) && ((y instanceof cljs.core.Keyword)))){
return (x.fqn === y.fqn);
} else {
return false;
}
}
});
/**
 * Efficient test to determine that two symbols are identical.
 */
cljs.core.symbol_identical_QMARK_ = (function cljs$core$symbol_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if((((x instanceof cljs.core.Symbol)) && ((y instanceof cljs.core.Symbol)))){
return (x.str === y.str);
} else {
return false;
}
}
});
/**
 * Returns the namespace String of a symbol or keyword, or nil if not present.
 */
cljs.core.namespace = (function cljs$core$namespace(x){
if((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition1$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$INamed$))))?true:false):false)){
return x.cljs$core$INamed$_namespace$arity$1(null, );
} else {
throw (new Error(["Doesn't support namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('')));
}
});
/**
 * Return true if x is a symbol or keyword
 */
cljs.core.ident_QMARK_ = (function cljs$core$ident_QMARK_(x){
return (((x instanceof cljs.core.Keyword)) || ((x instanceof cljs.core.Symbol)));
});
/**
 * Return true if x is a symbol or keyword without a namespace
 */
cljs.core.simple_ident_QMARK_ = (function cljs$core$simple_ident_QMARK_(x){
return ((cljs.core.ident_QMARK_(x)) && ((cljs.core.namespace(x) == null)));
});
/**
 * Return true if x is a symbol or keyword with a namespace
 */
cljs.core.qualified_ident_QMARK_ = (function cljs$core$qualified_ident_QMARK_(x){
return cljs.core.boolean$((function (){var and__5000__auto__ = cljs.core.ident_QMARK_(x);
if(and__5000__auto__){
var and__5000__auto____$1 = cljs.core.namespace(x);
if(cljs.core.truth_(and__5000__auto____$1)){
return true;
} else {
return and__5000__auto____$1;
}
} else {
return and__5000__auto__;
}
})());
});
/**
 * Return true if x is a symbol without a namespace
 */
cljs.core.simple_symbol_QMARK_ = (function cljs$core$simple_symbol_QMARK_(x){
return (((x instanceof cljs.core.Symbol)) && ((cljs.core.namespace(x) == null)));
});
/**
 * Return true if x is a symbol with a namespace
 */
cljs.core.qualified_symbol_QMARK_ = (function cljs$core$qualified_symbol_QMARK_(x){
return cljs.core.boolean$((function (){var and__5000__auto__ = (x instanceof cljs.core.Symbol);
if(and__5000__auto__){
var and__5000__auto____$1 = cljs.core.namespace(x);
if(cljs.core.truth_(and__5000__auto____$1)){
return true;
} else {
return and__5000__auto____$1;
}
} else {
return and__5000__auto__;
}
})());
});
/**
 * Return true if x is a keyword without a namespace
 */
cljs.core.simple_keyword_QMARK_ = (function cljs$core$simple_keyword_QMARK_(x){
return (((x instanceof cljs.core.Keyword)) && ((cljs.core.namespace(x) == null)));
});
/**
 * Return true if x is a keyword with a namespace
 */
cljs.core.qualified_keyword_QMARK_ = (function cljs$core$qualified_keyword_QMARK_(x){
return cljs.core.boolean$((function (){var and__5000__auto__ = (x instanceof cljs.core.Keyword);
if(and__5000__auto__){
var and__5000__auto____$1 = cljs.core.namespace(x);
if(cljs.core.truth_(and__5000__auto____$1)){
return true;
} else {
return and__5000__auto____$1;
}
} else {
return and__5000__auto__;
}
})());
});
/**
 * Returns a Keyword with the given namespace and name.  Do not use :
 *   in the keyword strings, it will be added automatically.
 */
cljs.core.keyword = (function cljs$core$keyword(var_args){
var G__33362 = arguments.length;
switch (G__33362) {
case 1:
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1 = (function (name){
if((name instanceof cljs.core.Keyword)){
return name;
} else {
if((name instanceof cljs.core.Symbol)){
return (new cljs.core.Keyword(cljs.core.namespace(name),(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(name) : cljs.core.name.call(null, name)),name.str,null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("/",name)){
return (new cljs.core.Keyword(null,name,name,null));
} else {
if(typeof name === 'string'){
var parts = name.split("/");
if((parts.length === (2))){
return (new cljs.core.Keyword((parts[(0)]),(parts[(1)]),name,null));
} else {
return (new cljs.core.Keyword(null,(parts[(0)]),name,null));
}
} else {
return null;
}
}
}
}
}));

(cljs.core.keyword.cljs$core$IFn$_invoke$arity$2 = (function (ns,name){
var ns__$1 = (((ns instanceof cljs.core.Keyword))?(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(ns) : cljs.core.name.call(null, ns)):(((ns instanceof cljs.core.Symbol))?(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(ns) : cljs.core.name.call(null, ns)):ns
));
var name__$1 = (((name instanceof cljs.core.Keyword))?(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(name) : cljs.core.name.call(null, name)):(((name instanceof cljs.core.Symbol))?(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(name) : cljs.core.name.call(null, name)):name
));
return (new cljs.core.Keyword(ns__$1,name__$1,[(cljs.core.truth_(ns__$1)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns__$1),"/"].join(''):null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(name__$1)].join(''),null));
}));

(cljs.core.keyword.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.LazySeq = (function (meta,fn,s,__hash){
this.meta = meta;
this.fn = fn;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 1;
});
(cljs.core.LazySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.LazySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
}));

(cljs.core.LazySeq.prototype.sval = (function (){
var self__ = this;
var coll = this;
if((self__.fn == null)){
return self__.s;
} else {
(self__.s = (self__.fn.cljs$core$IFn$_invoke$arity$0 ? self__.fn.cljs$core$IFn$_invoke$arity$0() : self__.fn.call(null, )));

(self__.fn = null);

return self__.s;
}
}));

(cljs.core.LazySeq.prototype.indexOf = (function() {
var G__35773 = null;
var G__35773__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__35773__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__35773 = function(x,start){
switch(arguments.length){
case 1:
return G__35773__1.call(this,x);
case 2:
return G__35773__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35773.cljs$core$IFn$_invoke$arity$1 = G__35773__1;
G__35773.cljs$core$IFn$_invoke$arity$2 = G__35773__2;
return G__35773;
})()
);

(cljs.core.LazySeq.prototype.lastIndexOf = (function() {
var G__35774 = null;
var G__35774__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__35774__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__35774 = function(x,start){
switch(arguments.length){
case 1:
return G__35774__1.call(this,x);
case 2:
return G__35774__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35774.cljs$core$IFn$_invoke$arity$1 = G__35774__1;
G__35774.cljs$core$IFn$_invoke$arity$2 = G__35774__2;
return G__35774;
})()
);

(cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
coll__$1.cljs$core$ISeqable$_seq$arity$1(null, );

if((self__.s == null)){
return null;
} else {
return cljs.core.next(self__.s);
}
}));

(cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
}));

(cljs.core.LazySeq.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.not(self__.fn);
}));

(cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
coll__$1.cljs$core$ISeqable$_seq$arity$1(null, );

if((self__.s == null)){
return null;
} else {
return cljs.core.first(self__.s);
}
}));

(cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
coll__$1.cljs$core$ISeqable$_seq$arity$1(null, );

if((!((self__.s == null)))){
return cljs.core.rest(self__.s);
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
coll__$1.sval();

if((self__.s == null)){
return null;
} else {
var ls = self__.s;
while(true){
if((ls instanceof cljs.core.LazySeq)){
var G__35779 = ls.sval();
ls = G__35779;
continue;
} else {
(self__.s = ls);

return cljs.core.seq(self__.s);
}
break;
}
}
}));

(cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.LazySeq(new_meta,(function (){
return coll__$1.cljs$core$ISeqable$_seq$arity$1(null, );
}),null,self__.__hash));
}
}));

(cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.LazySeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,"fn","fn",465265323,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.LazySeq.cljs$lang$type = true);

(cljs.core.LazySeq.cljs$lang$ctorStr = "cljs.core/LazySeq");

(cljs.core.LazySeq.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/LazySeq");
}));

/**
 * Positional factory function for cljs.core/LazySeq.
 */
cljs.core.__GT_LazySeq = (function cljs$core$__GT_LazySeq(meta,fn,s,__hash){
return (new cljs.core.LazySeq(meta,fn,s,__hash));
});

(cljs.core.LazySeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.ICounted}
*/
cljs.core.ChunkBuffer = (function (buf,end){
this.buf = buf;
this.end = end;
this.cljs$lang$protocol_mask$partition0$ = 2;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ChunkBuffer.prototype.add = (function (o){
var self__ = this;
var _ = this;
(self__.buf[self__.end] = o);

return (self__.end = (self__.end + (1)));
}));

(cljs.core.ChunkBuffer.prototype.chunk = (function (){
var self__ = this;
var _ = this;
var ret = (new cljs.core.ArrayChunk(self__.buf,(0),self__.end));
(self__.buf = null);

return ret;
}));

(cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.end;
}));

(cljs.core.ChunkBuffer.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"buf","buf",1426618187,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ChunkBuffer.cljs$lang$type = true);

(cljs.core.ChunkBuffer.cljs$lang$ctorStr = "cljs.core/ChunkBuffer");

(cljs.core.ChunkBuffer.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/ChunkBuffer");
}));

/**
 * Positional factory function for cljs.core/ChunkBuffer.
 */
cljs.core.__GT_ChunkBuffer = (function cljs$core$__GT_ChunkBuffer(buf,end){
return (new cljs.core.ChunkBuffer(buf,end));
});

cljs.core.chunk_buffer = (function cljs$core$chunk_buffer(capacity){
return (new cljs.core.ChunkBuffer((new Array(capacity)),(0)));
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.IChunk}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ArrayChunk = (function (arr,off,end){
this.arr = arr;
this.off = off;
this.end = end;
this.cljs$lang$protocol_mask$partition0$ = 524306;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.end - self__.off);
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,i){
var self__ = this;
var coll__$1 = this;
return (self__.arr[(self__.off + i)]);
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,i,not_found){
var self__ = this;
var coll__$1 = this;
if((((i >= (0))) && ((i < (self__.end - self__.off))))){
return (self__.arr[(self__.off + i)]);
} else {
return not_found;
}
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.off === self__.end)){
throw (new Error("-drop-first of empty chunk"));
} else {
return (new cljs.core.ArrayChunk(self__.arr,(self__.off + (1)),self__.end));
}
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.off]),(self__.off + (1)));
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.off);
}));

(cljs.core.ArrayChunk.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"off","off",-2047994980,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null);
}));

(cljs.core.ArrayChunk.cljs$lang$type = true);

(cljs.core.ArrayChunk.cljs$lang$ctorStr = "cljs.core/ArrayChunk");

(cljs.core.ArrayChunk.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/ArrayChunk");
}));

/**
 * Positional factory function for cljs.core/ArrayChunk.
 */
cljs.core.__GT_ArrayChunk = (function cljs$core$__GT_ArrayChunk(arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});

cljs.core.array_chunk = (function cljs$core$array_chunk(var_args){
var G__33364 = arguments.length;
switch (G__33364) {
case 1:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1 = (function (arr){
return (new cljs.core.ArrayChunk(arr,(0),arr.length));
}));

(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2 = (function (arr,off){
return (new cljs.core.ArrayChunk(arr,off,arr.length));
}));

(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3 = (function (arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
}));

(cljs.core.array_chunk.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IChunkedNext}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IChunkedSeq}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.ChunkedCons = (function (chunk,more,meta,__hash){
this.chunk = chunk;
this.more = more;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850732;
this.cljs$lang$protocol_mask$partition1$ = 1536;
});
(cljs.core.ChunkedCons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.ChunkedCons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
}));

(cljs.core.ChunkedCons.prototype.indexOf = (function() {
var G__35789 = null;
var G__35789__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__35789__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__35789 = function(x,start){
switch(arguments.length){
case 1:
return G__35789__1.call(this,x);
case 2:
return G__35789__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35789.cljs$core$IFn$_invoke$arity$1 = G__35789__1;
G__35789.cljs$core$IFn$_invoke$arity$2 = G__35789__2;
return G__35789;
})()
);

(cljs.core.ChunkedCons.prototype.lastIndexOf = (function() {
var G__35790 = null;
var G__35790__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__35790__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__35790 = function(x,start){
switch(arguments.length){
case 1:
return G__35790__1.call(this,x);
case 2:
return G__35790__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35790.cljs$core$IFn$_invoke$arity$1 = G__35790__1;
G__35790.cljs$core$IFn$_invoke$arity$2 = G__35790__2;
return G__35790;
})()
);

(cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,null,null));
} else {
if((self__.more == null)){
return null;
} else {
return cljs.core._seq(self__.more);
}
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth(self__.chunk,(0));
}));

(cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,null,null));
} else {
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.chunk;
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.ChunkedCons(self__.chunk,self__.more,new_meta,self__.__hash));
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,this$__$1);
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return null;
} else {
return self__.more;
}
}));

(cljs.core.ChunkedCons.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"chunk","chunk",449371907,null),new cljs.core.Symbol(null,"more","more",-418290273,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ChunkedCons.cljs$lang$type = true);

(cljs.core.ChunkedCons.cljs$lang$ctorStr = "cljs.core/ChunkedCons");

(cljs.core.ChunkedCons.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/ChunkedCons");
}));

/**
 * Positional factory function for cljs.core/ChunkedCons.
 */
cljs.core.__GT_ChunkedCons = (function cljs$core$__GT_ChunkedCons(chunk,more,meta,__hash){
return (new cljs.core.ChunkedCons(chunk,more,meta,__hash));
});

(cljs.core.ChunkedCons.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));
cljs.core.chunk_cons = (function cljs$core$chunk_cons(chunk,rest){
if((cljs.core._count(chunk) === (0))){
return rest;
} else {
return (new cljs.core.ChunkedCons(chunk,rest,null,null));
}
});
cljs.core.chunk_append = (function cljs$core$chunk_append(b,x){
return b.add(x);
});
cljs.core.chunk = (function cljs$core$chunk(b){
return b.chunk();
});
cljs.core.chunk_first = (function cljs$core$chunk_first(s){
return cljs.core._chunked_first(s);
});
cljs.core.chunk_rest = (function cljs$core$chunk_rest(s){
return cljs.core._chunked_rest(s);
});
cljs.core.chunk_next = (function cljs$core$chunk_next(s){
if((((!((s == null))))?(((((s.cljs$lang$protocol_mask$partition1$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$IChunkedNext$))))?true:false):false)){
return s.cljs$core$IChunkedNext$_chunked_next$arity$1(null, );
} else {
return cljs.core.seq(cljs.core._chunked_rest(s));
}
});
/**
 * Returns an array containing the contents of coll.
 */
cljs.core.to_array = (function cljs$core$to_array(coll){
var ary = [];
var s = cljs.core.seq(coll);
while(true){
if((!((s == null)))){
ary.push(cljs.core.first(s));

var G__35805 = cljs.core.next(s);
s = G__35805;
continue;
} else {
return ary;
}
break;
}
});
/**
 * Returns a (potentially-ragged) 2-dimensional array
 *   containing the contents of coll.
 */
cljs.core.to_array_2d = (function cljs$core$to_array_2d(coll){
var ret = (new Array(cljs.core.count(coll)));
var i_35806 = (0);
var xs_35807 = cljs.core.seq(coll);
while(true){
if((xs_35807 == null)){
} else {
(ret[i_35806] = cljs.core.to_array(cljs.core.first(xs_35807)));

var G__35808 = (i_35806 + (1));
var G__35809 = cljs.core.next(xs_35807);
i_35806 = G__35808;
xs_35807 = G__35809;
continue;
}
break;
}

return ret;
});
/**
 * Creates an array of ints. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.int_array = (function cljs$core$int_array(var_args){
var G__33367 = arguments.length;
switch (G__33367) {
case 1:
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.int_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
}));

(cljs.core.int_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first(s__$1));

var G__35811 = (i + (1));
var G__35812 = cljs.core.next(s__$1);
i = G__35811;
s__$1 = G__35812;
continue;
} else {
return a;
}
break;
}
} else {
var n__5593__auto___35813 = size;
var i_35814 = (0);
while(true){
if((i_35814 < n__5593__auto___35813)){
(a[i_35814] = init_val_or_seq);

var G__35815 = (i_35814 + (1));
i_35814 = G__35815;
continue;
} else {
}
break;
}

return a;
}
}));

(cljs.core.int_array.cljs$lang$maxFixedArity = 2);

/**
 * Creates an array of longs. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.long_array = (function cljs$core$long_array(var_args){
var G__33369 = arguments.length;
switch (G__33369) {
case 1:
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.long_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
}));

(cljs.core.long_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first(s__$1));

var G__35818 = (i + (1));
var G__35819 = cljs.core.next(s__$1);
i = G__35818;
s__$1 = G__35819;
continue;
} else {
return a;
}
break;
}
} else {
var n__5593__auto___35820 = size;
var i_35821 = (0);
while(true){
if((i_35821 < n__5593__auto___35820)){
(a[i_35821] = init_val_or_seq);

var G__35822 = (i_35821 + (1));
i_35821 = G__35822;
continue;
} else {
}
break;
}

return a;
}
}));

(cljs.core.long_array.cljs$lang$maxFixedArity = 2);

/**
 * Creates an array of doubles. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.double_array = (function cljs$core$double_array(var_args){
var G__33371 = arguments.length;
switch (G__33371) {
case 1:
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.double_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
}));

(cljs.core.double_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first(s__$1));

var G__35826 = (i + (1));
var G__35827 = cljs.core.next(s__$1);
i = G__35826;
s__$1 = G__35827;
continue;
} else {
return a;
}
break;
}
} else {
var n__5593__auto___35828 = size;
var i_35829 = (0);
while(true){
if((i_35829 < n__5593__auto___35828)){
(a[i_35829] = init_val_or_seq);

var G__35830 = (i_35829 + (1));
i_35829 = G__35830;
continue;
} else {
}
break;
}

return a;
}
}));

(cljs.core.double_array.cljs$lang$maxFixedArity = 2);

/**
 * Creates an array of objects. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.object_array = (function cljs$core$object_array(var_args){
var G__33373 = arguments.length;
switch (G__33373) {
case 1:
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.object_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
}));

(cljs.core.object_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first(s__$1));

var G__35833 = (i + (1));
var G__35834 = cljs.core.next(s__$1);
i = G__35833;
s__$1 = G__35834;
continue;
} else {
return a;
}
break;
}
} else {
var n__5593__auto___35835 = size;
var i_35836 = (0);
while(true){
if((i_35836 < n__5593__auto___35835)){
(a[i_35836] = init_val_or_seq);

var G__35837 = (i_35836 + (1));
i_35836 = G__35837;
continue;
} else {
}
break;
}

return a;
}
}));

(cljs.core.object_array.cljs$lang$maxFixedArity = 2);

/**
 * If coll is counted? returns its count, else will count at most the first n
 * elements of coll using its seq
 */
cljs.core.bounded_count = (function cljs$core$bounded_count(n,coll){
if(cljs.core.counted_QMARK_(coll)){
return cljs.core.count(coll);
} else {
var i = (0);
var s = cljs.core.seq(coll);
while(true){
if((((!((s == null)))) && ((i < n)))){
var G__35838 = (i + (1));
var G__35839 = cljs.core.next(s);
i = G__35838;
s = G__35839;
continue;
} else {
return i;
}
break;
}
}
});
cljs.core.spread = (function cljs$core$spread(arglist){
if((arglist == null)){
return null;
} else {
var n = cljs.core.next(arglist);
if((n == null)){
return cljs.core.seq(cljs.core.first(arglist));
} else {
return cljs.core.cons(cljs.core.first(arglist),(cljs.core.spread.cljs$core$IFn$_invoke$arity$1 ? cljs.core.spread.cljs$core$IFn$_invoke$arity$1(n) : cljs.core.spread.call(null, n)));
}
}
});
/**
 * Returns a lazy seq representing the concatenation of the elements in the supplied colls.
 */
cljs.core.concat = (function cljs$core$concat(var_args){
var G__33378 = arguments.length;
switch (G__33378) {
case 0:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35842 = arguments.length;
var i__5727__auto___35843 = (0);
while(true){
if((i__5727__auto___35843 < len__5726__auto___35842)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35843]));

var G__35844 = (i__5727__auto___35843 + (1));
i__5727__auto___35843 = G__35844;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.concat.cljs$core$IFn$_invoke$arity$0 = (function (){
return (new cljs.core.LazySeq(null,(function (){
return null;
}),null,null));
}));

(cljs.core.concat.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.LazySeq(null,(function (){
return x;
}),null,null));
}));

(cljs.core.concat.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (new cljs.core.LazySeq(null,(function (){
var s = cljs.core.seq(x);
if(s){
if(cljs.core.chunked_seq_QMARK_(s)){
return cljs.core.chunk_cons(cljs.core.chunk_first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.chunk_rest(s),y));
} else {
return cljs.core.cons(cljs.core.first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s),y));
}
} else {
return y;
}
}),null,null));
}));

(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,zs){
var cat = (function cljs$core$cat(xys,zs__$1){
return (new cljs.core.LazySeq(null,(function (){
var xys__$1 = cljs.core.seq(xys);
if(xys__$1){
if(cljs.core.chunked_seq_QMARK_(xys__$1)){
return cljs.core.chunk_cons(cljs.core.chunk_first(xys__$1),cljs$core$cat(cljs.core.chunk_rest(xys__$1),zs__$1));
} else {
return cljs.core.cons(cljs.core.first(xys__$1),cljs$core$cat(cljs.core.rest(xys__$1),zs__$1));
}
} else {
if(cljs.core.truth_(zs__$1)){
return cljs$core$cat(cljs.core.first(zs__$1),cljs.core.next(zs__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(x,y),zs);
}));

/** @this {Function} */
(cljs.core.concat.cljs$lang$applyTo = (function (seq33375){
var G__33376 = cljs.core.first(seq33375);
var seq33375__$1 = cljs.core.next(seq33375);
var G__33377 = cljs.core.first(seq33375__$1);
var seq33375__$2 = cljs.core.next(seq33375__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33376,G__33377,seq33375__$2);
}));

(cljs.core.concat.cljs$lang$maxFixedArity = (2));

/**
 * Creates a new list containing the items prepended to the rest, the
 *   last of which will be treated as a sequence.
 */
cljs.core.list_STAR_ = (function cljs$core$list_STAR_(var_args){
var G__33385 = arguments.length;
switch (G__33385) {
case 1:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35848 = arguments.length;
var i__5727__auto___35849 = (0);
while(true){
if((i__5727__auto___35849 < len__5726__auto___35848)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35849]));

var G__35850 = (i__5727__auto___35849 + (1));
i__5727__auto___35849 = G__35850;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((4) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((4)),(0),null)):null);
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5752__auto__);

}
});

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (args){
return cljs.core.seq(args);
}));

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (a,args){
return cljs.core.cons(a,args);
}));

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (a,b,args){
return cljs.core.cons(a,cljs.core.cons(b,args));
}));

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,args){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,args)));
}));

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,more){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(more)))));
}));

/** @this {Function} */
(cljs.core.list_STAR_.cljs$lang$applyTo = (function (seq33380){
var G__33381 = cljs.core.first(seq33380);
var seq33380__$1 = cljs.core.next(seq33380);
var G__33382 = cljs.core.first(seq33380__$1);
var seq33380__$2 = cljs.core.next(seq33380__$1);
var G__33383 = cljs.core.first(seq33380__$2);
var seq33380__$3 = cljs.core.next(seq33380__$2);
var G__33384 = cljs.core.first(seq33380__$3);
var seq33380__$4 = cljs.core.next(seq33380__$3);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33381,G__33382,G__33383,G__33384,seq33380__$4);
}));

(cljs.core.list_STAR_.cljs$lang$maxFixedArity = (4));

/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core.transient$ = (function cljs$core$transient(coll){
return cljs.core._as_transient(coll);
});
/**
 * Returns a new, persistent version of the transient collection, in
 *   constant time. The transient collection cannot be used after this
 *   call, any such use will throw an exception.
 */
cljs.core.persistent_BANG_ = (function cljs$core$persistent_BANG_(tcoll){
return cljs.core._persistent_BANG_(tcoll);
});
/**
 * Adds val to the transient collection, and return tcoll. The 'addition'
 *   may happen at different 'places' depending on the concrete type.
 */
cljs.core.conj_BANG_ = (function cljs$core$conj_BANG_(var_args){
var G__33390 = arguments.length;
switch (G__33390) {
case 0:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35853 = arguments.length;
var i__5727__auto___35854 = (0);
while(true){
if((i__5727__auto___35854 < len__5726__auto___35853)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35854]));

var G__35855 = (i__5727__auto___35854 + (1));
i__5727__auto___35854 = G__35855;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
}));

(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (tcoll){
return tcoll;
}));

(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,val){
return cljs.core._conj_BANG_(tcoll,val);
}));

(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._conj_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__35856 = ntcoll;
var G__35857 = cljs.core.first(vals);
var G__35858 = cljs.core.next(vals);
tcoll = G__35856;
val = G__35857;
vals = G__35858;
continue;
} else {
return ntcoll;
}
break;
}
}));

/** @this {Function} */
(cljs.core.conj_BANG_.cljs$lang$applyTo = (function (seq33387){
var G__33388 = cljs.core.first(seq33387);
var seq33387__$1 = cljs.core.next(seq33387);
var G__33389 = cljs.core.first(seq33387__$1);
var seq33387__$2 = cljs.core.next(seq33387__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33388,G__33389,seq33387__$2);
}));

(cljs.core.conj_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * When applied to a transient map, adds mapping of key(s) to
 *   val(s). When applied to a transient vector, sets the val at index.
 *   Note - index must be <= (count vector). Returns coll.
 */
cljs.core.assoc_BANG_ = (function cljs$core$assoc_BANG_(var_args){
var G__33396 = arguments.length;
switch (G__33396) {
case 3:
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35862 = arguments.length;
var i__5727__auto___35863 = (0);
while(true){
if((i__5727__auto___35863 < len__5726__auto___35862)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35863]));

var G__35864 = (i__5727__auto___35863 + (1));
i__5727__auto___35863 = G__35864;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((3) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((3)),(0),null)):null);
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5752__auto__);

}
});

(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (tcoll,key,val){
return cljs.core._assoc_BANG_(tcoll,key,val);
}));

(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,key,val,kvs){
while(true){
var ntcoll = cljs.core._assoc_BANG_(tcoll,key,val);
if(cljs.core.truth_(kvs)){
var G__35865 = ntcoll;
var G__35866 = cljs.core.first(kvs);
var G__35867 = cljs.core.second(kvs);
var G__35868 = cljs.core.nnext(kvs);
tcoll = G__35865;
key = G__35866;
val = G__35867;
kvs = G__35868;
continue;
} else {
return ntcoll;
}
break;
}
}));

/** @this {Function} */
(cljs.core.assoc_BANG_.cljs$lang$applyTo = (function (seq33392){
var G__33393 = cljs.core.first(seq33392);
var seq33392__$1 = cljs.core.next(seq33392);
var G__33394 = cljs.core.first(seq33392__$1);
var seq33392__$2 = cljs.core.next(seq33392__$1);
var G__33395 = cljs.core.first(seq33392__$2);
var seq33392__$3 = cljs.core.next(seq33392__$2);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33393,G__33394,G__33395,seq33392__$3);
}));

(cljs.core.assoc_BANG_.cljs$lang$maxFixedArity = (3));

/**
 * Returns a transient map that doesn't contain a mapping for key(s).
 */
cljs.core.dissoc_BANG_ = (function cljs$core$dissoc_BANG_(var_args){
var G__33401 = arguments.length;
switch (G__33401) {
case 2:
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35870 = arguments.length;
var i__5727__auto___35871 = (0);
while(true){
if((i__5727__auto___35871 < len__5726__auto___35870)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35871]));

var G__35872 = (i__5727__auto___35871 + (1));
i__5727__auto___35871 = G__35872;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,key){
return cljs.core._dissoc_BANG_(tcoll,key);
}));

(cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,key,ks){
while(true){
var ntcoll = cljs.core._dissoc_BANG_(tcoll,key);
if(cljs.core.truth_(ks)){
var G__35873 = ntcoll;
var G__35874 = cljs.core.first(ks);
var G__35875 = cljs.core.next(ks);
tcoll = G__35873;
key = G__35874;
ks = G__35875;
continue;
} else {
return ntcoll;
}
break;
}
}));

/** @this {Function} */
(cljs.core.dissoc_BANG_.cljs$lang$applyTo = (function (seq33398){
var G__33399 = cljs.core.first(seq33398);
var seq33398__$1 = cljs.core.next(seq33398);
var G__33400 = cljs.core.first(seq33398__$1);
var seq33398__$2 = cljs.core.next(seq33398__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33399,G__33400,seq33398__$2);
}));

(cljs.core.dissoc_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * Removes the last item from a transient vector. If
 *   the collection is empty, throws an exception. Returns tcoll
 */
cljs.core.pop_BANG_ = (function cljs$core$pop_BANG_(tcoll){
return cljs.core._pop_BANG_(tcoll);
});
/**
 * disj[oin]. Returns a transient set of the same (hashed/sorted) type, that
 *   does not contain key(s).
 */
cljs.core.disj_BANG_ = (function cljs$core$disj_BANG_(var_args){
var G__33406 = arguments.length;
switch (G__33406) {
case 2:
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35878 = arguments.length;
var i__5727__auto___35879 = (0);
while(true){
if((i__5727__auto___35879 < len__5726__auto___35878)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35879]));

var G__35880 = (i__5727__auto___35879 + (1));
i__5727__auto___35879 = G__35880;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,val){
return cljs.core._disjoin_BANG_(tcoll,val);
}));

(cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._disjoin_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__35882 = ntcoll;
var G__35883 = cljs.core.first(vals);
var G__35884 = cljs.core.next(vals);
tcoll = G__35882;
val = G__35883;
vals = G__35884;
continue;
} else {
return ntcoll;
}
break;
}
}));

/** @this {Function} */
(cljs.core.disj_BANG_.cljs$lang$applyTo = (function (seq33403){
var G__33404 = cljs.core.first(seq33403);
var seq33403__$1 = cljs.core.next(seq33403);
var G__33405 = cljs.core.first(seq33403__$1);
var seq33403__$2 = cljs.core.next(seq33403__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33404,G__33405,seq33403__$2);
}));

(cljs.core.disj_BANG_.cljs$lang$maxFixedArity = (2));


cljs.core.apply_to = (function cljs$core$apply_to(f,argc,args){
var args__$1 = cljs.core.seq(args);
if((argc === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null, ));
} else {
var a265 = cljs.core._first(args__$1);
var args__$2 = cljs.core._rest(args__$1);
if((argc === (1))){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(a265) : f.call(null, a265));
} else {
var b266 = cljs.core._first(args__$2);
var args__$3 = cljs.core._rest(args__$2);
if((argc === (2))){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(a265,b266) : f.call(null, a265,b266));
} else {
var c267 = cljs.core._first(args__$3);
var args__$4 = cljs.core._rest(args__$3);
if((argc === (3))){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(a265,b266,c267) : f.call(null, a265,b266,c267));
} else {
var d268 = cljs.core._first(args__$4);
var args__$5 = cljs.core._rest(args__$4);
if((argc === (4))){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(a265,b266,c267,d268) : f.call(null, a265,b266,c267,d268));
} else {
var e269 = cljs.core._first(args__$5);
var args__$6 = cljs.core._rest(args__$5);
if((argc === (5))){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(a265,b266,c267,d268,e269) : f.call(null, a265,b266,c267,d268,e269));
} else {
var f270 = cljs.core._first(args__$6);
var args__$7 = cljs.core._rest(args__$6);
if((argc === (6))){
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(a265,b266,c267,d268,e269,f270) : f.call(null, a265,b266,c267,d268,e269,f270));
} else {
var g271 = cljs.core._first(args__$7);
var args__$8 = cljs.core._rest(args__$7);
if((argc === (7))){
return (f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(a265,b266,c267,d268,e269,f270,g271) : f.call(null, a265,b266,c267,d268,e269,f270,g271));
} else {
var h272 = cljs.core._first(args__$8);
var args__$9 = cljs.core._rest(args__$8);
if((argc === (8))){
return (f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(a265,b266,c267,d268,e269,f270,g271,h272) : f.call(null, a265,b266,c267,d268,e269,f270,g271,h272));
} else {
var i273 = cljs.core._first(args__$9);
var args__$10 = cljs.core._rest(args__$9);
if((argc === (9))){
return (f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(a265,b266,c267,d268,e269,f270,g271,h272,i273) : f.call(null, a265,b266,c267,d268,e269,f270,g271,h272,i273));
} else {
var j274 = cljs.core._first(args__$10);
var args__$11 = cljs.core._rest(args__$10);
if((argc === (10))){
return (f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(a265,b266,c267,d268,e269,f270,g271,h272,i273,j274) : f.call(null, a265,b266,c267,d268,e269,f270,g271,h272,i273,j274));
} else {
var k275 = cljs.core._first(args__$11);
var args__$12 = cljs.core._rest(args__$11);
if((argc === (11))){
return (f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(a265,b266,c267,d268,e269,f270,g271,h272,i273,j274,k275) : f.call(null, a265,b266,c267,d268,e269,f270,g271,h272,i273,j274,k275));
} else {
var l276 = cljs.core._first(args__$12);
var args__$13 = cljs.core._rest(args__$12);
if((argc === (12))){
return (f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(a265,b266,c267,d268,e269,f270,g271,h272,i273,j274,k275,l276) : f.call(null, a265,b266,c267,d268,e269,f270,g271,h272,i273,j274,k275,l276));
} else {
var m277 = cljs.core._first(args__$13);
var args__$14 = cljs.core._rest(args__$13);
if((argc === (13))){
return (f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(a265,b266,c267,d268,e269,f270,g271,h272,i273,j274,k275,l276,m277) : f.call(null, a265,b266,c267,d268,e269,f270,g271,h272,i273,j274,k275,l276,m277));
} else {
var n278 = cljs.core._first(args__$14);
var args__$15 = cljs.core._rest(args__$14);
if((argc === (14))){
return (f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(a265,b266,c267,d268,e269,f270,g271,h272,i273,j274,k275,l276,m277,n278) : f.call(null, a265,b266,c267,d268,e269,f270,g271,h272,i273,j274,k275,l276,m277,n278));
} else {
var o279 = cljs.core._first(args__$15);
var args__$16 = cljs.core._rest(args__$15);
if((argc === (15))){
return (f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(a265,b266,c267,d268,e269,f270,g271,h272,i273,j274,k275,l276,m277,n278,o279) : f.call(null, a265,b266,c267,d268,e269,f270,g271,h272,i273,j274,k275,l276,m277,n278,o279));
} else {
var p280 = cljs.core._first(args__$16);
var args__$17 = cljs.core._rest(args__$16);
if((argc === (16))){
return (f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(a265,b266,c267,d268,e269,f270,g271,h272,i273,j274,k275,l276,m277,n278,o279,p280) : f.call(null, a265,b266,c267,d268,e269,f270,g271,h272,i273,j274,k275,l276,m277,n278,o279,p280));
} else {
var q281 = cljs.core._first(args__$17);
var args__$18 = cljs.core._rest(args__$17);
if((argc === (17))){
return (f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(a265,b266,c267,d268,e269,f270,g271,h272,i273,j274,k275,l276,m277,n278,o279,p280,q281) : f.call(null, a265,b266,c267,d268,e269,f270,g271,h272,i273,j274,k275,l276,m277,n278,o279,p280,q281));
} else {
var r282 = cljs.core._first(args__$18);
var args__$19 = cljs.core._rest(args__$18);
if((argc === (18))){
return (f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(a265,b266,c267,d268,e269,f270,g271,h272,i273,j274,k275,l276,m277,n278,o279,p280,q281,r282) : f.call(null, a265,b266,c267,d268,e269,f270,g271,h272,i273,j274,k275,l276,m277,n278,o279,p280,q281,r282));
} else {
var s283 = cljs.core._first(args__$19);
var args__$20 = cljs.core._rest(args__$19);
if((argc === (19))){
return (f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(a265,b266,c267,d268,e269,f270,g271,h272,i273,j274,k275,l276,m277,n278,o279,p280,q281,r282,s283) : f.call(null, a265,b266,c267,d268,e269,f270,g271,h272,i273,j274,k275,l276,m277,n278,o279,p280,q281,r282,s283));
} else {
var t284 = cljs.core._first(args__$20);
var args__$21 = cljs.core._rest(args__$20);
if((argc === (20))){
return (f.cljs$core$IFn$_invoke$arity$20 ? f.cljs$core$IFn$_invoke$arity$20(a265,b266,c267,d268,e269,f270,g271,h272,i273,j274,k275,l276,m277,n278,o279,p280,q281,r282,s283,t284) : f.call(null, a265,b266,c267,d268,e269,f270,g271,h272,i273,j274,k275,l276,m277,n278,o279,p280,q281,r282,s283,t284));
} else {
throw (new Error("Only up to 20 arguments supported on functions"));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});

/**
 * Internal. DO NOT USE! Next without the nil? check.
 */
cljs.core.next_STAR_ = (function cljs$core$next_STAR_(coll){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$INext$))))?true:false):false)){
return coll.cljs$core$INext$_next$arity$1(null, );
} else {
return cljs.core.seq(cljs.core.rest(coll));
}
});
/**
 * Internal. DO NOT USE!
 *   Assumes args was already called with seq beforehand!
 */
cljs.core.apply_to_simple = (function cljs$core$apply_to_simple(var_args){
var G__33409 = arguments.length;
switch (G__33409) {
case 2:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2 = (function (f,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$0){
return f.cljs$core$IFn$_invoke$arity$0();
} else {
return f.call(f);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3(f,cljs.core._first(args),cljs.core.next_STAR_(args));
}
}));

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3 = (function (f,a0,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$1){
return f.cljs$core$IFn$_invoke$arity$1(a0);
} else {
return f.call(f,a0);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4(f,a0,cljs.core._first(args),cljs.core.next_STAR_(args));
}
}));

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4 = (function (f,a0,a1,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$2){
return f.cljs$core$IFn$_invoke$arity$2(a0,a1);
} else {
return f.call(f,a0,a1);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5(f,a0,a1,cljs.core._first(args),cljs.core.next_STAR_(args));
}
}));

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5 = (function (f,a0,a1,a2,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$3){
return f.cljs$core$IFn$_invoke$arity$3(a0,a1,a2);
} else {
return f.call(f,a0,a1,a2);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6(f,a0,a1,a2,cljs.core._first(args),cljs.core.next_STAR_(args));
}
}));

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6 = (function (f,a0,a1,a2,a3,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$4){
return f.cljs$core$IFn$_invoke$arity$4(a0,a1,a2,a3);
} else {
return f.call(f,a0,a1,a2,a3);
}
} else {
var a4 = cljs.core._first(args);
var next_4 = cljs.core.next(args);
if((next_4 == null)){
if(f.cljs$core$IFn$_invoke$arity$5){
return f.cljs$core$IFn$_invoke$arity$5(a0,a1,a2,a3,a4);
} else {
return f.call(f,a0,a1,a2,a3,a4);
}
} else {
var a5 = cljs.core._first(next_4);
var next_5 = cljs.core.next(next_4);
if((next_5 == null)){
if(f.cljs$core$IFn$_invoke$arity$6){
return f.cljs$core$IFn$_invoke$arity$6(a0,a1,a2,a3,a4,a5);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5);
}
} else {
var a6 = cljs.core._first(next_5);
var next_6 = cljs.core.next(next_5);
if((next_6 == null)){
if(f.cljs$core$IFn$_invoke$arity$7){
return f.cljs$core$IFn$_invoke$arity$7(a0,a1,a2,a3,a4,a5,a6);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6);
}
} else {
var a7 = cljs.core._first(next_6);
var next_7 = cljs.core.next(next_6);
if((next_7 == null)){
if(f.cljs$core$IFn$_invoke$arity$8){
return f.cljs$core$IFn$_invoke$arity$8(a0,a1,a2,a3,a4,a5,a6,a7);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7);
}
} else {
var a8 = cljs.core._first(next_7);
var next_8 = cljs.core.next(next_7);
if((next_8 == null)){
if(f.cljs$core$IFn$_invoke$arity$9){
return f.cljs$core$IFn$_invoke$arity$9(a0,a1,a2,a3,a4,a5,a6,a7,a8);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8);
}
} else {
var a9 = cljs.core._first(next_8);
var next_9 = cljs.core.next(next_8);
if((next_9 == null)){
if(f.cljs$core$IFn$_invoke$arity$10){
return f.cljs$core$IFn$_invoke$arity$10(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9);
}
} else {
var a10 = cljs.core._first(next_9);
var next_10 = cljs.core.next(next_9);
if((next_10 == null)){
if(f.cljs$core$IFn$_invoke$arity$11){
return f.cljs$core$IFn$_invoke$arity$11(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10);
}
} else {
var a11 = cljs.core._first(next_10);
var next_11 = cljs.core.next(next_10);
if((next_11 == null)){
if(f.cljs$core$IFn$_invoke$arity$12){
return f.cljs$core$IFn$_invoke$arity$12(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11);
}
} else {
var a12 = cljs.core._first(next_11);
var next_12 = cljs.core.next(next_11);
if((next_12 == null)){
if(f.cljs$core$IFn$_invoke$arity$13){
return f.cljs$core$IFn$_invoke$arity$13(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12);
}
} else {
var a13 = cljs.core._first(next_12);
var next_13 = cljs.core.next(next_12);
if((next_13 == null)){
if(f.cljs$core$IFn$_invoke$arity$14){
return f.cljs$core$IFn$_invoke$arity$14(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13);
}
} else {
var a14 = cljs.core._first(next_13);
var next_14 = cljs.core.next(next_13);
if((next_14 == null)){
if(f.cljs$core$IFn$_invoke$arity$15){
return f.cljs$core$IFn$_invoke$arity$15(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14);
}
} else {
var a15 = cljs.core._first(next_14);
var next_15 = cljs.core.next(next_14);
if((next_15 == null)){
if(f.cljs$core$IFn$_invoke$arity$16){
return f.cljs$core$IFn$_invoke$arity$16(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15);
}
} else {
var a16 = cljs.core._first(next_15);
var next_16 = cljs.core.next(next_15);
if((next_16 == null)){
if(f.cljs$core$IFn$_invoke$arity$17){
return f.cljs$core$IFn$_invoke$arity$17(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16);
}
} else {
var a17 = cljs.core._first(next_16);
var next_17 = cljs.core.next(next_16);
if((next_17 == null)){
if(f.cljs$core$IFn$_invoke$arity$18){
return f.cljs$core$IFn$_invoke$arity$18(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17);
}
} else {
var a18 = cljs.core._first(next_17);
var next_18 = cljs.core.next(next_17);
if((next_18 == null)){
if(f.cljs$core$IFn$_invoke$arity$19){
return f.cljs$core$IFn$_invoke$arity$19(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18);
}
} else {
var a19 = cljs.core._first(next_18);
var next_19 = cljs.core.next(next_18);
if((next_19 == null)){
if(f.cljs$core$IFn$_invoke$arity$20){
return f.cljs$core$IFn$_invoke$arity$20(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19);
}
} else {
var arr__5641__auto__ = [a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19];
var s__5642__auto___35908 = next_19;
while(true){
if(s__5642__auto___35908){
arr__5641__auto__.push(cljs.core._first(s__5642__auto___35908));

var G__35909 = cljs.core.next(s__5642__auto___35908);
s__5642__auto___35908 = G__35909;
continue;
} else {
}
break;
}

return f.apply(f,arr__5641__auto__);
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(cljs.core.apply_to_simple.cljs$lang$maxFixedArity = 6);

/**
 * Applies fn f to the argument list formed by prepending intervening arguments to args.
 */
cljs.core.apply = (function cljs$core$apply(var_args){
var G__33417 = arguments.length;
switch (G__33417) {
case 2:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35912 = arguments.length;
var i__5727__auto___35913 = (0);
while(true){
if((i__5727__auto___35913 < len__5726__auto___35912)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35913]));

var G__35914 = (i__5727__auto___35913 + (1));
i__5727__auto___35913 = G__35914;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((5) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((5)),(0),null)):null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__5752__auto__);

}
});

(cljs.core.apply.cljs$core$IFn$_invoke$arity$2 = (function (f,args){
if(f.cljs$lang$applyTo){
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = cljs.core.bounded_count((fixed_arity + (1)),args);
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,args);
} else {
return f.cljs$lang$applyTo(args);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2(f,cljs.core.seq(args));
}
}));

(cljs.core.apply.cljs$core$IFn$_invoke$arity$3 = (function (f,x,args){
if(f.cljs$lang$applyTo){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(x,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = (cljs.core.bounded_count(fixed_arity,args) + (1));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3(f,x,cljs.core.seq(args));
}
}));

(cljs.core.apply.cljs$core$IFn$_invoke$arity$4 = (function (f,x,y,args){
if(f.cljs$lang$applyTo){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(x,y,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = ((2) + cljs.core.bounded_count((fixed_arity - (1)),args));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4(f,x,y,cljs.core.seq(args));
}
}));

(cljs.core.apply.cljs$core$IFn$_invoke$arity$5 = (function (f,x,y,z,args){
if(f.cljs$lang$applyTo){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(x,y,z,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = ((3) + cljs.core.bounded_count((fixed_arity - (2)),args));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5(f,x,y,z,cljs.core.seq(args));
}
}));

(cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic = (function (f,a,b,c,d,args){
if(f.cljs$lang$applyTo){
var spread_args = cljs.core.spread(args);
var arglist = cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,spread_args))));
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = ((4) + cljs.core.bounded_count((fixed_arity - (3)),spread_args));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6(f,a,b,c,d,cljs.core.spread(args));
}
}));

/** @this {Function} */
(cljs.core.apply.cljs$lang$applyTo = (function (seq33411){
var G__33412 = cljs.core.first(seq33411);
var seq33411__$1 = cljs.core.next(seq33411);
var G__33413 = cljs.core.first(seq33411__$1);
var seq33411__$2 = cljs.core.next(seq33411__$1);
var G__33414 = cljs.core.first(seq33411__$2);
var seq33411__$3 = cljs.core.next(seq33411__$2);
var G__33415 = cljs.core.first(seq33411__$3);
var seq33411__$4 = cljs.core.next(seq33411__$3);
var G__33416 = cljs.core.first(seq33411__$4);
var seq33411__$5 = cljs.core.next(seq33411__$4);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33412,G__33413,G__33414,G__33415,G__33416,seq33411__$5);
}));

(cljs.core.apply.cljs$lang$maxFixedArity = (5));

cljs.core.__destructure_map = (function cljs$core$__destructure_map(gmap){
if((((!((gmap == null))))?(((((gmap.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === gmap.cljs$core$ISeq$))))?true:false):false)){
if(cljs.core.next(gmap)){
return cljs.core.PersistentArrayMap.createAsIfByAssoc(cljs.core.to_array(gmap));
} else {
if(cljs.core.seq(gmap)){
return cljs.core.first(gmap);
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
}
} else {
return gmap;
}
});
/**
 * Returns an object of the same type and value as obj, with
 *   (apply f (meta obj) args) as its metadata.
 */
cljs.core.vary_meta = (function cljs$core$vary_meta(var_args){
var G__33427 = arguments.length;
switch (G__33427) {
case 2:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35921 = arguments.length;
var i__5727__auto___35922 = (0);
while(true){
if((i__5727__auto___35922 < len__5726__auto___35921)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35922]));

var G__35923 = (i__5727__auto___35922 + (1));
i__5727__auto___35922 = G__35923;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((6) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((6)),(0),null)):null);
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__5752__auto__);

}
});

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2 = (function (obj,f){
return cljs.core.with_meta(obj,(function (){var G__33428 = cljs.core.meta(obj);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__33428) : f.call(null, G__33428));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3 = (function (obj,f,a){
return cljs.core.with_meta(obj,(function (){var G__33429 = cljs.core.meta(obj);
var G__33430 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__33429,G__33430) : f.call(null, G__33429,G__33430));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4 = (function (obj,f,a,b){
return cljs.core.with_meta(obj,(function (){var G__33431 = cljs.core.meta(obj);
var G__33432 = a;
var G__33433 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__33431,G__33432,G__33433) : f.call(null, G__33431,G__33432,G__33433));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5 = (function (obj,f,a,b,c){
return cljs.core.with_meta(obj,(function (){var G__33434 = cljs.core.meta(obj);
var G__33435 = a;
var G__33436 = b;
var G__33437 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__33434,G__33435,G__33436,G__33437) : f.call(null, G__33434,G__33435,G__33436,G__33437));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6 = (function (obj,f,a,b,c,d){
return cljs.core.with_meta(obj,(function (){var G__33438 = cljs.core.meta(obj);
var G__33439 = a;
var G__33440 = b;
var G__33441 = c;
var G__33442 = d;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__33438,G__33439,G__33440,G__33441,G__33442) : f.call(null, G__33438,G__33439,G__33440,G__33441,G__33442));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic = (function (obj,f,a,b,c,d,args){
return cljs.core.with_meta(obj,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.meta(obj),a,b,c,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([d,args], 0)));
}));

/** @this {Function} */
(cljs.core.vary_meta.cljs$lang$applyTo = (function (seq33420){
var G__33421 = cljs.core.first(seq33420);
var seq33420__$1 = cljs.core.next(seq33420);
var G__33422 = cljs.core.first(seq33420__$1);
var seq33420__$2 = cljs.core.next(seq33420__$1);
var G__33423 = cljs.core.first(seq33420__$2);
var seq33420__$3 = cljs.core.next(seq33420__$2);
var G__33424 = cljs.core.first(seq33420__$3);
var seq33420__$4 = cljs.core.next(seq33420__$3);
var G__33425 = cljs.core.first(seq33420__$4);
var seq33420__$5 = cljs.core.next(seq33420__$4);
var G__33426 = cljs.core.first(seq33420__$5);
var seq33420__$6 = cljs.core.next(seq33420__$5);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33421,G__33422,G__33423,G__33424,G__33425,G__33426,seq33420__$6);
}));

(cljs.core.vary_meta.cljs$lang$maxFixedArity = (6));

/**
 * Same as (not (= obj1 obj2))
 */
cljs.core.not_EQ_ = (function cljs$core$not_EQ_(var_args){
var G__33447 = arguments.length;
switch (G__33447) {
case 1:
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35925 = arguments.length;
var i__5727__auto___35926 = (0);
while(true){
if((i__5727__auto___35926 < len__5726__auto___35925)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35926]));

var G__35927 = (i__5727__auto___35926 + (1));
i__5727__auto___35926 = G__35927;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return false;
}));

(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)));
}));

(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_,x,y,more));
}));

/** @this {Function} */
(cljs.core.not_EQ_.cljs$lang$applyTo = (function (seq33444){
var G__33445 = cljs.core.first(seq33444);
var seq33444__$1 = cljs.core.next(seq33444);
var G__33446 = cljs.core.first(seq33444__$1);
var seq33444__$2 = cljs.core.next(seq33444__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33445,G__33446,seq33444__$2);
}));

(cljs.core.not_EQ_.cljs$lang$maxFixedArity = (2));

/**
 * If coll is empty, returns nil, else coll
 */
cljs.core.not_empty = (function cljs$core$not_empty(coll){
if(cljs.core.seq(coll)){
return coll;
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.t_cljs$core33448 = (function (meta33449){
this.meta33449 = meta33449;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.t_cljs$core33448.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33450,meta33449__$1){
var self__ = this;
var _33450__$1 = this;
return (new cljs.core.t_cljs$core33448(meta33449__$1));
}));

(cljs.core.t_cljs$core33448.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33450){
var self__ = this;
var _33450__$1 = this;
return self__.meta33449;
}));

(cljs.core.t_cljs$core33448.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return false;
}));

(cljs.core.t_cljs$core33448.prototype.next = (function (){
var self__ = this;
var _ = this;
return (new Error("No such element"));
}));

(cljs.core.t_cljs$core33448.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.t_cljs$core33448.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta33449","meta33449",1141903957,null)], null);
}));

(cljs.core.t_cljs$core33448.cljs$lang$type = true);

(cljs.core.t_cljs$core33448.cljs$lang$ctorStr = "cljs.core/t_cljs$core33448");

(cljs.core.t_cljs$core33448.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/t_cljs$core33448");
}));

/**
 * Positional factory function for cljs.core/t_cljs$core33448.
 */
cljs.core.__GT_t_cljs$core33448 = (function cljs$core$__GT_t_cljs$core33448(meta33449){
return (new cljs.core.t_cljs$core33448(meta33449));
});


cljs.core.nil_iter = (function cljs$core$nil_iter(){
return (new cljs.core.t_cljs$core33448(cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
*/
cljs.core.StringIter = (function (s,i){
this.s = s;
this.i = i;
});
(cljs.core.StringIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.s.length);
}));

(cljs.core.StringIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = self__.s.charAt(self__.i);
(self__.i = (self__.i + (1)));

return ret;
}));

(cljs.core.StringIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.StringIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.StringIter.cljs$lang$type = true);

(cljs.core.StringIter.cljs$lang$ctorStr = "cljs.core/StringIter");

(cljs.core.StringIter.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/StringIter");
}));

/**
 * Positional factory function for cljs.core/StringIter.
 */
cljs.core.__GT_StringIter = (function cljs$core$__GT_StringIter(s,i){
return (new cljs.core.StringIter(s,i));
});

cljs.core.string_iter = (function cljs$core$string_iter(x){
return (new cljs.core.StringIter(x,(0)));
});

/**
* @constructor
*/
cljs.core.ArrayIter = (function (arr,i){
this.arr = arr;
this.i = i;
});
(cljs.core.ArrayIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
}));

(cljs.core.ArrayIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
(self__.i = (self__.i + (1)));

return ret;
}));

(cljs.core.ArrayIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.ArrayIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ArrayIter.cljs$lang$type = true);

(cljs.core.ArrayIter.cljs$lang$ctorStr = "cljs.core/ArrayIter");

(cljs.core.ArrayIter.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/ArrayIter");
}));

/**
 * Positional factory function for cljs.core/ArrayIter.
 */
cljs.core.__GT_ArrayIter = (function cljs$core$__GT_ArrayIter(arr,i){
return (new cljs.core.ArrayIter(arr,i));
});

cljs.core.array_iter = (function cljs$core$array_iter(x){
return (new cljs.core.ArrayIter(x,(0)));
});
cljs.core.INIT = ({});
cljs.core.START = ({});

/**
* @constructor
*/
cljs.core.SeqIter = (function (_seq,_next){
this._seq = _seq;
this._next = _next;
});
(cljs.core.SeqIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
if((self__._seq === cljs.core.INIT)){
(self__._seq = cljs.core.START);

(self__._next = cljs.core.seq(self__._next));
} else {
if((self__._seq === self__._next)){
(self__._next = cljs.core.next(self__._seq));
} else {
}
}

return (!((self__._next == null)));
}));

(cljs.core.SeqIter.prototype.next = (function (){
var self__ = this;
var this$ = this;
if((!(this$.hasNext()))){
throw (new Error("No such element"));
} else {
(self__._seq = self__._next);

return cljs.core.first(self__._next);
}
}));

(cljs.core.SeqIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.SeqIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"_seq","_seq",-449557847,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"_next","_next",101877036,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.SeqIter.cljs$lang$type = true);

(cljs.core.SeqIter.cljs$lang$ctorStr = "cljs.core/SeqIter");

(cljs.core.SeqIter.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/SeqIter");
}));

/**
 * Positional factory function for cljs.core/SeqIter.
 */
cljs.core.__GT_SeqIter = (function cljs$core$__GT_SeqIter(_seq,_next){
return (new cljs.core.SeqIter(_seq,_next));
});

cljs.core.seq_iter = (function cljs$core$seq_iter(coll){
return (new cljs.core.SeqIter(cljs.core.INIT,coll));
});
cljs.core.iter = (function cljs$core$iter(coll){
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core._iterator(coll);
} else {
if((coll == null)){
return cljs.core.nil_iter();
} else {
if(typeof coll === 'string'){
return cljs.core.string_iter(coll);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_iter(coll);
} else {
if(cljs.core.seqable_QMARK_(coll)){
return cljs.core.seq_iter(coll);
} else {
throw (new Error(["Cannot create iterator from ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll)].join('')));

}
}
}
}
}
});

/**
* @constructor
*/
cljs.core.Many = (function (vals){
this.vals = vals;
});
(cljs.core.Many.prototype.add = (function (o){
var self__ = this;
var this$ = this;
self__.vals.push(o);

return this$;
}));

(cljs.core.Many.prototype.remove = (function (){
var self__ = this;
var this$ = this;
return self__.vals.shift();
}));

(cljs.core.Many.prototype.isEmpty = (function (){
var self__ = this;
var this$ = this;
return (self__.vals.length === (0));
}));

(cljs.core.Many.prototype.toString = (function (){
var self__ = this;
var this$ = this;
return ["Many: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.vals)].join('');
}));

(cljs.core.Many.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"vals","vals",-1886377036,null)], null);
}));

(cljs.core.Many.cljs$lang$type = true);

(cljs.core.Many.cljs$lang$ctorStr = "cljs.core/Many");

(cljs.core.Many.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/Many");
}));

/**
 * Positional factory function for cljs.core/Many.
 */
cljs.core.__GT_Many = (function cljs$core$__GT_Many(vals){
return (new cljs.core.Many(vals));
});

cljs.core.NONE = ({});

/**
* @constructor
*/
cljs.core.Single = (function (val){
this.val = val;
});
(cljs.core.Single.prototype.add = (function (o){
var self__ = this;
var this$ = this;
if((self__.val === cljs.core.NONE)){
(self__.val = o);

return this$;
} else {
return (new cljs.core.Many([self__.val,o]));
}
}));

(cljs.core.Single.prototype.remove = (function (){
var self__ = this;
var this$ = this;
if((self__.val === cljs.core.NONE)){
throw (new Error("Removing object from empty buffer"));
} else {
var ret = self__.val;
(self__.val = cljs.core.NONE);

return ret;
}
}));

(cljs.core.Single.prototype.isEmpty = (function (){
var self__ = this;
var this$ = this;
return (self__.val === cljs.core.NONE);
}));

(cljs.core.Single.prototype.toString = (function (){
var self__ = this;
var this$ = this;
return ["Single: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.val)].join('');
}));

(cljs.core.Single.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Single.cljs$lang$type = true);

(cljs.core.Single.cljs$lang$ctorStr = "cljs.core/Single");

(cljs.core.Single.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/Single");
}));

/**
 * Positional factory function for cljs.core/Single.
 */
cljs.core.__GT_Single = (function cljs$core$__GT_Single(val){
return (new cljs.core.Single(val));
});


/**
* @constructor
*/
cljs.core.Empty = (function (){
});
(cljs.core.Empty.prototype.add = (function (o){
var self__ = this;
var this$ = this;
return (new cljs.core.Single(o));
}));

(cljs.core.Empty.prototype.remove = (function (){
var self__ = this;
var this$ = this;
throw (new Error("Removing object from empty buffer"));
}));

(cljs.core.Empty.prototype.isEmpty = (function (){
var self__ = this;
var this$ = this;
return true;
}));

(cljs.core.Empty.prototype.toString = (function (){
var self__ = this;
var this$ = this;
return "Empty";
}));

(cljs.core.Empty.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
}));

(cljs.core.Empty.cljs$lang$type = true);

(cljs.core.Empty.cljs$lang$ctorStr = "cljs.core/Empty");

(cljs.core.Empty.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/Empty");
}));

/**
 * Positional factory function for cljs.core/Empty.
 */
cljs.core.__GT_Empty = (function cljs$core$__GT_Empty(){
return (new cljs.core.Empty());
});

cljs.core.EMPTY = (new cljs.core.Empty());

/**
* @constructor
*/
cljs.core.MultiIterator = (function (iters){
this.iters = iters;
});
(cljs.core.MultiIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var iters__$1 = cljs.core.seq(self__.iters);
while(true){
if((!((iters__$1 == null)))){
var iter = cljs.core.first(iters__$1);
if((!(iter.hasNext()))){
return false;
} else {
var G__35935 = cljs.core.next(iters__$1);
iters__$1 = G__35935;
continue;
}
} else {
return true;
}
break;
}
}));

(cljs.core.MultiIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var nexts = [];
var n__5593__auto___35937 = self__.iters.length;
var i_35938 = (0);
while(true){
if((i_35938 < n__5593__auto___35937)){
(nexts[i_35938] = (self__.iters[i_35938]).next());

var G__35939 = (i_35938 + (1));
i_35938 = G__35939;
continue;
} else {
}
break;
}

return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(nexts,(0));
}));

(cljs.core.MultiIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"iters","iters",719353031,null)], null);
}));

(cljs.core.MultiIterator.cljs$lang$type = true);

(cljs.core.MultiIterator.cljs$lang$ctorStr = "cljs.core/MultiIterator");

(cljs.core.MultiIterator.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/MultiIterator");
}));

/**
 * Positional factory function for cljs.core/MultiIterator.
 */
cljs.core.__GT_MultiIterator = (function cljs$core$__GT_MultiIterator(iters){
return (new cljs.core.MultiIterator(iters));
});

cljs.core.chunkIteratorSeq = (function cljs$core$chunkIteratorSeq(iter){
return (new cljs.core.LazySeq(null,(function (){
if(iter.hasNext()){
var arr = [];
var n = (0);
while(true){
if(cljs.core.truth_((function (){var and__5000__auto__ = iter.hasNext();
if(cljs.core.truth_(and__5000__auto__)){
return (n < (32));
} else {
return and__5000__auto__;
}
})())){
(arr[n] = iter.next());

var G__35942 = (n + (1));
n = G__35942;
continue;
} else {
return cljs.core.chunk_cons(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3(arr,(0),n),(cljs.core.chunkIteratorSeq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunkIteratorSeq.cljs$core$IFn$_invoke$arity$1(iter) : cljs.core.chunkIteratorSeq.call(null, iter)));
}
break;
}
} else {
return null;
}
}),null,null));
});

/**
* @constructor
*/
cljs.core.TransformerIterator = (function (buffer,_next,completed,xf,sourceIter,multi){
this.buffer = buffer;
this._next = _next;
this.completed = completed;
this.xf = xf;
this.sourceIter = sourceIter;
this.multi = multi;
});
(cljs.core.TransformerIterator.prototype.step = (function (){
var self__ = this;
var this$ = this;
if((!((self__._next === cljs.core.NONE)))){
return true;
} else {
while(true){
if((self__._next === cljs.core.NONE)){
if(self__.buffer.isEmpty()){
if(self__.completed){
return false;
} else {
if(self__.sourceIter.hasNext()){
var iter = ((self__.multi)?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.xf,cljs.core.cons(null,self__.sourceIter.next())):(function (){var G__33451 = null;
var G__33452 = self__.sourceIter.next();
return (self__.xf.cljs$core$IFn$_invoke$arity$2 ? self__.xf.cljs$core$IFn$_invoke$arity$2(G__33451,G__33452) : self__.xf.call(null, G__33451,G__33452));
})());
if(cljs.core.reduced_QMARK_(iter)){
(self__.xf.cljs$core$IFn$_invoke$arity$1 ? self__.xf.cljs$core$IFn$_invoke$arity$1(null) : self__.xf.call(null, null));

(self__.completed = true);
} else {
}

continue;
} else {
(self__.xf.cljs$core$IFn$_invoke$arity$1 ? self__.xf.cljs$core$IFn$_invoke$arity$1(null) : self__.xf.call(null, null));

(self__.completed = true);

continue;
}
}
} else {
(self__._next = self__.buffer.remove());

continue;
}
} else {
return true;
}
break;
}
}
}));

(cljs.core.TransformerIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
return this$.step();
}));

(cljs.core.TransformerIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(this$.hasNext()){
var ret = self__._next;
(self__._next = cljs.core.NONE);

return ret;
} else {
throw (new Error("No such element"));
}
}));

(cljs.core.TransformerIterator.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.TransformerIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"buffer","buffer",-2037140571,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"_next","_next",101877036,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"completed","completed",1154475024,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"xf","xf",2042434515,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"sourceIter","sourceIter",1068220306,null),new cljs.core.Symbol(null,"multi","multi",1450238522,null)], null);
}));

(cljs.core.TransformerIterator.cljs$lang$type = true);

(cljs.core.TransformerIterator.cljs$lang$ctorStr = "cljs.core/TransformerIterator");

(cljs.core.TransformerIterator.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/TransformerIterator");
}));

/**
 * Positional factory function for cljs.core/TransformerIterator.
 */
cljs.core.__GT_TransformerIterator = (function cljs$core$__GT_TransformerIterator(buffer,_next,completed,xf,sourceIter,multi){
return (new cljs.core.TransformerIterator(buffer,_next,completed,xf,sourceIter,multi));
});

(cljs.core.TransformerIterator.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));
cljs.core.transformer_iterator = (function cljs$core$transformer_iterator(xform,sourceIter,multi){
var iterator = (new cljs.core.TransformerIterator(cljs.core.EMPTY,cljs.core.NONE,false,null,sourceIter,multi));
(iterator.xf = (function (){var G__33453 = (function() {
var G__35949 = null;
var G__35949__0 = (function (){
return null;
});
var G__35949__1 = (function (acc){
return acc;
});
var G__35949__2 = (function (acc,o){
(iterator.buffer = iterator.buffer.add(o));

return acc;
});
G__35949 = function(acc,o){
switch(arguments.length){
case 0:
return G__35949__0.call(this);
case 1:
return G__35949__1.call(this,acc);
case 2:
return G__35949__2.call(this,acc,o);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35949.cljs$core$IFn$_invoke$arity$0 = G__35949__0;
G__35949.cljs$core$IFn$_invoke$arity$1 = G__35949__1;
G__35949.cljs$core$IFn$_invoke$arity$2 = G__35949__2;
return G__35949;
})()
;
return (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__33453) : xform.call(null, G__33453));
})());

return iterator;
});
(cljs.core.TransformerIterator.create = (function (xform,source){
return cljs.core.transformer_iterator(xform,source,false);
}));
(cljs.core.TransformerIterator.createMulti = (function (xform,sources){
return cljs.core.transformer_iterator(xform,(new cljs.core.MultiIterator(cljs.core.to_array(sources))),true);
}));
/**
 * Coerces coll to a (possibly empty) sequence, if it is not already
 *   one. Will not force a lazy seq. (sequence nil) yields (), When a
 *   transducer is supplied, returns a lazy sequence of applications of
 *   the transform to the items in coll(s), i.e. to the set of first
 *   items of each coll, followed by the set of second
 *   items in each coll, until any one of the colls is exhausted.  Any
 *   remaining items in other colls are ignored. The transform should accept
 *   number-of-colls arguments
 */
cljs.core.sequence = (function cljs$core$sequence(var_args){
var G__33458 = arguments.length;
switch (G__33458) {
case 1:
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35952 = arguments.length;
var i__5727__auto___35953 = (0);
while(true){
if((i__5727__auto___35953 < len__5726__auto___35952)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35953]));

var G__35958 = (i__5727__auto___35953 + (1));
i__5727__auto___35953 = G__35958;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1 = (function (coll){
if(cljs.core.seq_QMARK_(coll)){
return coll;
} else {
var or__5002__auto__ = cljs.core.seq(coll);
if(or__5002__auto__){
return or__5002__auto__;
} else {
return cljs.core.List.EMPTY;
}
}
}));

(cljs.core.sequence.cljs$core$IFn$_invoke$arity$2 = (function (xform,coll){
var or__5002__auto__ = cljs.core.chunkIteratorSeq(cljs.core.TransformerIterator.create(xform,cljs.core.iter(coll)));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic = (function (xform,coll,colls){
var or__5002__auto__ = cljs.core.chunkIteratorSeq(cljs.core.TransformerIterator.createMulti(xform,(function (){var G__33459 = cljs.core.iter;
var G__33460 = cljs.core.cons(coll,colls);
return (cljs.core.map.cljs$core$IFn$_invoke$arity$2 ? cljs.core.map.cljs$core$IFn$_invoke$arity$2(G__33459,G__33460) : cljs.core.map.call(null, G__33459,G__33460));
})()));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.List.EMPTY;
}
}));

/** @this {Function} */
(cljs.core.sequence.cljs$lang$applyTo = (function (seq33455){
var G__33456 = cljs.core.first(seq33455);
var seq33455__$1 = cljs.core.next(seq33455);
var G__33457 = cljs.core.first(seq33455__$1);
var seq33455__$2 = cljs.core.next(seq33455__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33456,G__33457,seq33455__$2);
}));

(cljs.core.sequence.cljs$lang$maxFixedArity = (2));

/**
 * Returns true if (pred x) is logical true for every x in coll, else
 *   false.
 */
cljs.core.every_QMARK_ = (function cljs$core$every_QMARK_(pred,coll){
while(true){
if((cljs.core.seq(coll) == null)){
return true;
} else {
if(cljs.core.truth_((function (){var G__33461 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__33461) : pred.call(null, G__33461));
})())){
var G__35967 = pred;
var G__35968 = cljs.core.next(coll);
pred = G__35967;
coll = G__35968;
continue;
} else {
return false;

}
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for every x in
 *   coll, else true.
 */
cljs.core.not_every_QMARK_ = (function cljs$core$not_every_QMARK_(pred,coll){
return (!(cljs.core.every_QMARK_(pred,coll)));
});
/**
 * Returns the first logical true value of (pred x) for any x in coll,
 *   else nil.  One common idiom is to use a set as pred, for example
 *   this will return :fred if :fred is in the sequence, otherwise nil:
 *   (some #{:fred} coll)
 */
cljs.core.some = (function cljs$core$some(pred,coll){
while(true){
var temp__5823__auto__ = cljs.core.seq(coll);
if(temp__5823__auto__){
var s = temp__5823__auto__;
var or__5002__auto__ = (function (){var G__33462 = cljs.core.first(s);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__33462) : pred.call(null, G__33462));
})();
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
var G__35969 = pred;
var G__35970 = cljs.core.next(s);
pred = G__35969;
coll = G__35970;
continue;
}
} else {
return null;
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for any x in coll,
 *   else true.
 */
cljs.core.not_any_QMARK_ = (function cljs$core$not_any_QMARK_(pred,coll){
return cljs.core.not(cljs.core.some(pred,coll));
});
/**
 * Returns true if n is even, throws an exception if n is not an integer
 */
cljs.core.even_QMARK_ = (function cljs$core$even_QMARK_(n){
if(cljs.core.integer_QMARK_(n)){
return ((n & (1)) === (0));
} else {
throw (new Error(["Argument must be an integer: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)].join('')));
}
});
/**
 * Returns true if n is odd, throws an exception if n is not an integer
 */
cljs.core.odd_QMARK_ = (function cljs$core$odd_QMARK_(n){
return (!(cljs.core.even_QMARK_(n)));
});
/**
 * Takes a fn f and returns a fn that takes the same arguments as f,
 *   has the same effects, if any, and returns the opposite truth value.
 */
cljs.core.complement = (function cljs$core$complement(f){
return (function() {
var G__35971 = null;
var G__35971__0 = (function (){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null, )));
});
var G__35971__1 = (function (x){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null, x)));
});
var G__35971__2 = (function (x,y){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null, x,y)));
});
var G__35971__3 = (function() { 
var G__35972__delegate = function (x,y,zs){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f,x,y,zs));
};
var G__35972 = function (x,y,var_args){
var zs = null;
if (arguments.length > 2) {
var G__35973__i = 0, G__35973__a = new Array(arguments.length -  2);
while (G__35973__i < G__35973__a.length) {G__35973__a[G__35973__i] = arguments[G__35973__i + 2]; ++G__35973__i;}
  zs = new cljs.core.IndexedSeq(G__35973__a,0,null);
} 
return G__35972__delegate.call(this,x,y,zs);};
G__35972.cljs$lang$maxFixedArity = 2;
G__35972.cljs$lang$applyTo = (function (arglist__35974){
var x = cljs.core.first(arglist__35974);
arglist__35974 = cljs.core.next(arglist__35974);
var y = cljs.core.first(arglist__35974);
var zs = cljs.core.rest(arglist__35974);
return G__35972__delegate(x,y,zs);
});
G__35972.cljs$core$IFn$_invoke$arity$variadic = G__35972__delegate;
return G__35972;
})()
;
G__35971 = function(x,y,var_args){
var zs = var_args;
switch(arguments.length){
case 0:
return G__35971__0.call(this);
case 1:
return G__35971__1.call(this,x);
case 2:
return G__35971__2.call(this,x,y);
default:
var G__35976 = null;
if (arguments.length > 2) {
var G__35977__i = 0, G__35977__a = new Array(arguments.length -  2);
while (G__35977__i < G__35977__a.length) {G__35977__a[G__35977__i] = arguments[G__35977__i + 2]; ++G__35977__i;}
G__35976 = new cljs.core.IndexedSeq(G__35977__a,0,null);
}
return G__35971__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__35976);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35971.cljs$lang$maxFixedArity = 2;
G__35971.cljs$lang$applyTo = G__35971__3.cljs$lang$applyTo;
G__35971.cljs$core$IFn$_invoke$arity$0 = G__35971__0;
G__35971.cljs$core$IFn$_invoke$arity$1 = G__35971__1;
G__35971.cljs$core$IFn$_invoke$arity$2 = G__35971__2;
G__35971.cljs$core$IFn$_invoke$arity$variadic = G__35971__3.cljs$core$IFn$_invoke$arity$variadic;
return G__35971;
})()
});
/**
 * Returns a function that takes any number of arguments and returns x.
 */
cljs.core.constantly = (function cljs$core$constantly(x){
return (function() { 
var G__35979__delegate = function (args){
return x;
};
var G__35979 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__35980__i = 0, G__35980__a = new Array(arguments.length -  0);
while (G__35980__i < G__35980__a.length) {G__35980__a[G__35980__i] = arguments[G__35980__i + 0]; ++G__35980__i;}
  args = new cljs.core.IndexedSeq(G__35980__a,0,null);
} 
return G__35979__delegate.call(this,args);};
G__35979.cljs$lang$maxFixedArity = 0;
G__35979.cljs$lang$applyTo = (function (arglist__35981){
var args = cljs.core.seq(arglist__35981);
return G__35979__delegate(args);
});
G__35979.cljs$core$IFn$_invoke$arity$variadic = G__35979__delegate;
return G__35979;
})()
;
});
/**
 * Takes a set of functions and returns a fn that is the composition
 *   of those fns.  The returned fn takes a variable number of args,
 *   applies the rightmost of fns to the args, the next
 *   fn (right-to-left) to the result, etc.
 */
cljs.core.comp = (function cljs$core$comp(var_args){
var G__33468 = arguments.length;
switch (G__33468) {
case 0:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___35983 = arguments.length;
var i__5727__auto___35984 = (0);
while(true){
if((i__5727__auto___35984 < len__5726__auto___35983)){
args_arr__5751__auto__.push((arguments[i__5727__auto___35984]));

var G__35985 = (i__5727__auto___35984 + (1));
i__5727__auto___35984 = G__35985;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((3) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((3)),(0),null)):null);
return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5752__auto__);

}
});

(cljs.core.comp.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.identity;
}));

(cljs.core.comp.cljs$core$IFn$_invoke$arity$1 = (function (f){
return f;
}));

(cljs.core.comp.cljs$core$IFn$_invoke$arity$2 = (function (f,g){
return (function() {
var G__35986 = null;
var G__35986__0 = (function (){
var G__33469 = (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null, ));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__33469) : f.call(null, G__33469));
});
var G__35986__1 = (function (x){
var G__33470 = (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(x) : g.call(null, x));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__33470) : f.call(null, G__33470));
});
var G__35986__2 = (function (x,y){
var G__33471 = (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(x,y) : g.call(null, x,y));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__33471) : f.call(null, G__33471));
});
var G__35986__3 = (function (x,y,z){
var G__33472 = (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(x,y,z) : g.call(null, x,y,z));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__33472) : f.call(null, G__33472));
});
var G__35986__4 = (function() { 
var G__35988__delegate = function (x,y,z,args){
var G__33473 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__33473) : f.call(null, G__33473));
};
var G__35988 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__35989__i = 0, G__35989__a = new Array(arguments.length -  3);
while (G__35989__i < G__35989__a.length) {G__35989__a[G__35989__i] = arguments[G__35989__i + 3]; ++G__35989__i;}
  args = new cljs.core.IndexedSeq(G__35989__a,0,null);
} 
return G__35988__delegate.call(this,x,y,z,args);};
G__35988.cljs$lang$maxFixedArity = 3;
G__35988.cljs$lang$applyTo = (function (arglist__35990){
var x = cljs.core.first(arglist__35990);
arglist__35990 = cljs.core.next(arglist__35990);
var y = cljs.core.first(arglist__35990);
arglist__35990 = cljs.core.next(arglist__35990);
var z = cljs.core.first(arglist__35990);
var args = cljs.core.rest(arglist__35990);
return G__35988__delegate(x,y,z,args);
});
G__35988.cljs$core$IFn$_invoke$arity$variadic = G__35988__delegate;
return G__35988;
})()
;
G__35986 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__35986__0.call(this);
case 1:
return G__35986__1.call(this,x);
case 2:
return G__35986__2.call(this,x,y);
case 3:
return G__35986__3.call(this,x,y,z);
default:
var G__35994 = null;
if (arguments.length > 3) {
var G__35995__i = 0, G__35995__a = new Array(arguments.length -  3);
while (G__35995__i < G__35995__a.length) {G__35995__a[G__35995__i] = arguments[G__35995__i + 3]; ++G__35995__i;}
G__35994 = new cljs.core.IndexedSeq(G__35995__a,0,null);
}
return G__35986__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__35994);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35986.cljs$lang$maxFixedArity = 3;
G__35986.cljs$lang$applyTo = G__35986__4.cljs$lang$applyTo;
G__35986.cljs$core$IFn$_invoke$arity$0 = G__35986__0;
G__35986.cljs$core$IFn$_invoke$arity$1 = G__35986__1;
G__35986.cljs$core$IFn$_invoke$arity$2 = G__35986__2;
G__35986.cljs$core$IFn$_invoke$arity$3 = G__35986__3;
G__35986.cljs$core$IFn$_invoke$arity$variadic = G__35986__4.cljs$core$IFn$_invoke$arity$variadic;
return G__35986;
})()
}));

(cljs.core.comp.cljs$core$IFn$_invoke$arity$3 = (function (f,g,h){
return (function() {
var G__35996 = null;
var G__35996__0 = (function (){
var G__33474 = (function (){var G__33475 = (h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null, ));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__33475) : g.call(null, G__33475));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__33474) : f.call(null, G__33474));
});
var G__35996__1 = (function (x){
var G__33476 = (function (){var G__33477 = (h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(x) : h.call(null, x));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__33477) : g.call(null, G__33477));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__33476) : f.call(null, G__33476));
});
var G__35996__2 = (function (x,y){
var G__33478 = (function (){var G__33479 = (h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(x,y) : h.call(null, x,y));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__33479) : g.call(null, G__33479));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__33478) : f.call(null, G__33478));
});
var G__35996__3 = (function (x,y,z){
var G__33480 = (function (){var G__33481 = (h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(x,y,z) : h.call(null, x,y,z));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__33481) : g.call(null, G__33481));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__33480) : f.call(null, G__33480));
});
var G__35996__4 = (function() { 
var G__35997__delegate = function (x,y,z,args){
var G__33482 = (function (){var G__33483 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args);
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__33483) : g.call(null, G__33483));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__33482) : f.call(null, G__33482));
};
var G__35997 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__35998__i = 0, G__35998__a = new Array(arguments.length -  3);
while (G__35998__i < G__35998__a.length) {G__35998__a[G__35998__i] = arguments[G__35998__i + 3]; ++G__35998__i;}
  args = new cljs.core.IndexedSeq(G__35998__a,0,null);
} 
return G__35997__delegate.call(this,x,y,z,args);};
G__35997.cljs$lang$maxFixedArity = 3;
G__35997.cljs$lang$applyTo = (function (arglist__35999){
var x = cljs.core.first(arglist__35999);
arglist__35999 = cljs.core.next(arglist__35999);
var y = cljs.core.first(arglist__35999);
arglist__35999 = cljs.core.next(arglist__35999);
var z = cljs.core.first(arglist__35999);
var args = cljs.core.rest(arglist__35999);
return G__35997__delegate(x,y,z,args);
});
G__35997.cljs$core$IFn$_invoke$arity$variadic = G__35997__delegate;
return G__35997;
})()
;
G__35996 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__35996__0.call(this);
case 1:
return G__35996__1.call(this,x);
case 2:
return G__35996__2.call(this,x,y);
case 3:
return G__35996__3.call(this,x,y,z);
default:
var G__36000 = null;
if (arguments.length > 3) {
var G__36001__i = 0, G__36001__a = new Array(arguments.length -  3);
while (G__36001__i < G__36001__a.length) {G__36001__a[G__36001__i] = arguments[G__36001__i + 3]; ++G__36001__i;}
G__36000 = new cljs.core.IndexedSeq(G__36001__a,0,null);
}
return G__35996__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__36000);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35996.cljs$lang$maxFixedArity = 3;
G__35996.cljs$lang$applyTo = G__35996__4.cljs$lang$applyTo;
G__35996.cljs$core$IFn$_invoke$arity$0 = G__35996__0;
G__35996.cljs$core$IFn$_invoke$arity$1 = G__35996__1;
G__35996.cljs$core$IFn$_invoke$arity$2 = G__35996__2;
G__35996.cljs$core$IFn$_invoke$arity$3 = G__35996__3;
G__35996.cljs$core$IFn$_invoke$arity$variadic = G__35996__4.cljs$core$IFn$_invoke$arity$variadic;
return G__35996;
})()
}));

(cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic = (function (f1,f2,f3,fs){
var fs__$1 = cljs.core.reverse(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f1,f2,f3,fs));
return (function() { 
var G__36002__delegate = function (args){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.first(fs__$1),args);
var fs__$2 = cljs.core.next(fs__$1);
while(true){
if(fs__$2){
var G__36003 = (function (){var fexpr__33484 = cljs.core.first(fs__$2);
return (fexpr__33484.cljs$core$IFn$_invoke$arity$1 ? fexpr__33484.cljs$core$IFn$_invoke$arity$1(ret) : fexpr__33484.call(null, ret));
})();
var G__36004 = cljs.core.next(fs__$2);
ret = G__36003;
fs__$2 = G__36004;
continue;
} else {
return ret;
}
break;
}
};
var G__36002 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__36005__i = 0, G__36005__a = new Array(arguments.length -  0);
while (G__36005__i < G__36005__a.length) {G__36005__a[G__36005__i] = arguments[G__36005__i + 0]; ++G__36005__i;}
  args = new cljs.core.IndexedSeq(G__36005__a,0,null);
} 
return G__36002__delegate.call(this,args);};
G__36002.cljs$lang$maxFixedArity = 0;
G__36002.cljs$lang$applyTo = (function (arglist__36006){
var args = cljs.core.seq(arglist__36006);
return G__36002__delegate(args);
});
G__36002.cljs$core$IFn$_invoke$arity$variadic = G__36002__delegate;
return G__36002;
})()
;
}));

/** @this {Function} */
(cljs.core.comp.cljs$lang$applyTo = (function (seq33464){
var G__33465 = cljs.core.first(seq33464);
var seq33464__$1 = cljs.core.next(seq33464);
var G__33466 = cljs.core.first(seq33464__$1);
var seq33464__$2 = cljs.core.next(seq33464__$1);
var G__33467 = cljs.core.first(seq33464__$2);
var seq33464__$3 = cljs.core.next(seq33464__$2);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33465,G__33466,G__33467,seq33464__$3);
}));

(cljs.core.comp.cljs$lang$maxFixedArity = (3));

/**
 * Takes a function f and fewer than the normal arguments to f, and
 *   returns a fn that takes a variable number of additional args. When
 *   called, the returned function calls f with args + additional args.
 */
cljs.core.partial = (function cljs$core$partial(var_args){
var G__33491 = arguments.length;
switch (G__33491) {
case 1:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___36009 = arguments.length;
var i__5727__auto___36010 = (0);
while(true){
if((i__5727__auto___36010 < len__5726__auto___36009)){
args_arr__5751__auto__.push((arguments[i__5727__auto___36010]));

var G__36011 = (i__5727__auto___36010 + (1));
i__5727__auto___36010 = G__36011;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((4) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((4)),(0),null)):null);
return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5752__auto__);

}
});

(cljs.core.partial.cljs$core$IFn$_invoke$arity$1 = (function (f){
return f;
}));

(cljs.core.partial.cljs$core$IFn$_invoke$arity$2 = (function (f,arg1){
return (function() {
var G__36012 = null;
var G__36012__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(arg1) : f.call(null, arg1));
});
var G__36012__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1,x) : f.call(null, arg1,x));
});
var G__36012__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,x,y) : f.call(null, arg1,x,y));
});
var G__36012__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,x,y,z) : f.call(null, arg1,x,y,z));
});
var G__36012__4 = (function() { 
var G__36013__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,x,y,z,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
};
var G__36013 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__36014__i = 0, G__36014__a = new Array(arguments.length -  3);
while (G__36014__i < G__36014__a.length) {G__36014__a[G__36014__i] = arguments[G__36014__i + 3]; ++G__36014__i;}
  args = new cljs.core.IndexedSeq(G__36014__a,0,null);
} 
return G__36013__delegate.call(this,x,y,z,args);};
G__36013.cljs$lang$maxFixedArity = 3;
G__36013.cljs$lang$applyTo = (function (arglist__36015){
var x = cljs.core.first(arglist__36015);
arglist__36015 = cljs.core.next(arglist__36015);
var y = cljs.core.first(arglist__36015);
arglist__36015 = cljs.core.next(arglist__36015);
var z = cljs.core.first(arglist__36015);
var args = cljs.core.rest(arglist__36015);
return G__36013__delegate(x,y,z,args);
});
G__36013.cljs$core$IFn$_invoke$arity$variadic = G__36013__delegate;
return G__36013;
})()
;
G__36012 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__36012__0.call(this);
case 1:
return G__36012__1.call(this,x);
case 2:
return G__36012__2.call(this,x,y);
case 3:
return G__36012__3.call(this,x,y,z);
default:
var G__36017 = null;
if (arguments.length > 3) {
var G__36018__i = 0, G__36018__a = new Array(arguments.length -  3);
while (G__36018__i < G__36018__a.length) {G__36018__a[G__36018__i] = arguments[G__36018__i + 3]; ++G__36018__i;}
G__36017 = new cljs.core.IndexedSeq(G__36018__a,0,null);
}
return G__36012__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__36017);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36012.cljs$lang$maxFixedArity = 3;
G__36012.cljs$lang$applyTo = G__36012__4.cljs$lang$applyTo;
G__36012.cljs$core$IFn$_invoke$arity$0 = G__36012__0;
G__36012.cljs$core$IFn$_invoke$arity$1 = G__36012__1;
G__36012.cljs$core$IFn$_invoke$arity$2 = G__36012__2;
G__36012.cljs$core$IFn$_invoke$arity$3 = G__36012__3;
G__36012.cljs$core$IFn$_invoke$arity$variadic = G__36012__4.cljs$core$IFn$_invoke$arity$variadic;
return G__36012;
})()
}));

(cljs.core.partial.cljs$core$IFn$_invoke$arity$3 = (function (f,arg1,arg2){
return (function() {
var G__36019 = null;
var G__36019__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1,arg2) : f.call(null, arg1,arg2));
});
var G__36019__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,arg2,x) : f.call(null, arg1,arg2,x));
});
var G__36019__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,arg2,x,y) : f.call(null, arg1,arg2,x,y));
});
var G__36019__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1,arg2,x,y,z) : f.call(null, arg1,arg2,x,y,z));
});
var G__36019__4 = (function() { 
var G__36020__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,x,y,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([z,args], 0));
};
var G__36020 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__36021__i = 0, G__36021__a = new Array(arguments.length -  3);
while (G__36021__i < G__36021__a.length) {G__36021__a[G__36021__i] = arguments[G__36021__i + 3]; ++G__36021__i;}
  args = new cljs.core.IndexedSeq(G__36021__a,0,null);
} 
return G__36020__delegate.call(this,x,y,z,args);};
G__36020.cljs$lang$maxFixedArity = 3;
G__36020.cljs$lang$applyTo = (function (arglist__36022){
var x = cljs.core.first(arglist__36022);
arglist__36022 = cljs.core.next(arglist__36022);
var y = cljs.core.first(arglist__36022);
arglist__36022 = cljs.core.next(arglist__36022);
var z = cljs.core.first(arglist__36022);
var args = cljs.core.rest(arglist__36022);
return G__36020__delegate(x,y,z,args);
});
G__36020.cljs$core$IFn$_invoke$arity$variadic = G__36020__delegate;
return G__36020;
})()
;
G__36019 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__36019__0.call(this);
case 1:
return G__36019__1.call(this,x);
case 2:
return G__36019__2.call(this,x,y);
case 3:
return G__36019__3.call(this,x,y,z);
default:
var G__36023 = null;
if (arguments.length > 3) {
var G__36024__i = 0, G__36024__a = new Array(arguments.length -  3);
while (G__36024__i < G__36024__a.length) {G__36024__a[G__36024__i] = arguments[G__36024__i + 3]; ++G__36024__i;}
G__36023 = new cljs.core.IndexedSeq(G__36024__a,0,null);
}
return G__36019__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__36023);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36019.cljs$lang$maxFixedArity = 3;
G__36019.cljs$lang$applyTo = G__36019__4.cljs$lang$applyTo;
G__36019.cljs$core$IFn$_invoke$arity$0 = G__36019__0;
G__36019.cljs$core$IFn$_invoke$arity$1 = G__36019__1;
G__36019.cljs$core$IFn$_invoke$arity$2 = G__36019__2;
G__36019.cljs$core$IFn$_invoke$arity$3 = G__36019__3;
G__36019.cljs$core$IFn$_invoke$arity$variadic = G__36019__4.cljs$core$IFn$_invoke$arity$variadic;
return G__36019;
})()
}));

(cljs.core.partial.cljs$core$IFn$_invoke$arity$4 = (function (f,arg1,arg2,arg3){
return (function() {
var G__36025 = null;
var G__36025__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,arg2,arg3) : f.call(null, arg1,arg2,arg3));
});
var G__36025__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,arg2,arg3,x) : f.call(null, arg1,arg2,arg3,x));
});
var G__36025__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1,arg2,arg3,x,y) : f.call(null, arg1,arg2,arg3,x,y));
});
var G__36025__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(arg1,arg2,arg3,x,y,z) : f.call(null, arg1,arg2,arg3,x,y,z));
});
var G__36025__4 = (function() { 
var G__36026__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,arg3,x,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([y,z,args], 0));
};
var G__36026 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__36027__i = 0, G__36027__a = new Array(arguments.length -  3);
while (G__36027__i < G__36027__a.length) {G__36027__a[G__36027__i] = arguments[G__36027__i + 3]; ++G__36027__i;}
  args = new cljs.core.IndexedSeq(G__36027__a,0,null);
} 
return G__36026__delegate.call(this,x,y,z,args);};
G__36026.cljs$lang$maxFixedArity = 3;
G__36026.cljs$lang$applyTo = (function (arglist__36028){
var x = cljs.core.first(arglist__36028);
arglist__36028 = cljs.core.next(arglist__36028);
var y = cljs.core.first(arglist__36028);
arglist__36028 = cljs.core.next(arglist__36028);
var z = cljs.core.first(arglist__36028);
var args = cljs.core.rest(arglist__36028);
return G__36026__delegate(x,y,z,args);
});
G__36026.cljs$core$IFn$_invoke$arity$variadic = G__36026__delegate;
return G__36026;
})()
;
G__36025 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__36025__0.call(this);
case 1:
return G__36025__1.call(this,x);
case 2:
return G__36025__2.call(this,x,y);
case 3:
return G__36025__3.call(this,x,y,z);
default:
var G__36029 = null;
if (arguments.length > 3) {
var G__36030__i = 0, G__36030__a = new Array(arguments.length -  3);
while (G__36030__i < G__36030__a.length) {G__36030__a[G__36030__i] = arguments[G__36030__i + 3]; ++G__36030__i;}
G__36029 = new cljs.core.IndexedSeq(G__36030__a,0,null);
}
return G__36025__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__36029);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36025.cljs$lang$maxFixedArity = 3;
G__36025.cljs$lang$applyTo = G__36025__4.cljs$lang$applyTo;
G__36025.cljs$core$IFn$_invoke$arity$0 = G__36025__0;
G__36025.cljs$core$IFn$_invoke$arity$1 = G__36025__1;
G__36025.cljs$core$IFn$_invoke$arity$2 = G__36025__2;
G__36025.cljs$core$IFn$_invoke$arity$3 = G__36025__3;
G__36025.cljs$core$IFn$_invoke$arity$variadic = G__36025__4.cljs$core$IFn$_invoke$arity$variadic;
return G__36025;
})()
}));

(cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic = (function (f,arg1,arg2,arg3,more){
return (function() { 
var G__36031__delegate = function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,arg1,arg2,arg3,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(more,args));
};
var G__36031 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__36032__i = 0, G__36032__a = new Array(arguments.length -  0);
while (G__36032__i < G__36032__a.length) {G__36032__a[G__36032__i] = arguments[G__36032__i + 0]; ++G__36032__i;}
  args = new cljs.core.IndexedSeq(G__36032__a,0,null);
} 
return G__36031__delegate.call(this,args);};
G__36031.cljs$lang$maxFixedArity = 0;
G__36031.cljs$lang$applyTo = (function (arglist__36033){
var args = cljs.core.seq(arglist__36033);
return G__36031__delegate(args);
});
G__36031.cljs$core$IFn$_invoke$arity$variadic = G__36031__delegate;
return G__36031;
})()
;
}));

/** @this {Function} */
(cljs.core.partial.cljs$lang$applyTo = (function (seq33486){
var G__33487 = cljs.core.first(seq33486);
var seq33486__$1 = cljs.core.next(seq33486);
var G__33488 = cljs.core.first(seq33486__$1);
var seq33486__$2 = cljs.core.next(seq33486__$1);
var G__33489 = cljs.core.first(seq33486__$2);
var seq33486__$3 = cljs.core.next(seq33486__$2);
var G__33490 = cljs.core.first(seq33486__$3);
var seq33486__$4 = cljs.core.next(seq33486__$3);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33487,G__33488,G__33489,G__33490,seq33486__$4);
}));

(cljs.core.partial.cljs$lang$maxFixedArity = (4));

/**
 * Takes a function f, and returns a function that calls f, replacing
 *   a nil first argument to f with the supplied value x. Higher arity
 *   versions can replace arguments in the second and third
 *   positions (y, z). Note that the function f can take any number of
 *   arguments, not just the one(s) being nil-patched.
 */
cljs.core.fnil = (function cljs$core$fnil(var_args){
var G__33493 = arguments.length;
switch (G__33493) {
case 2:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.fnil.cljs$core$IFn$_invoke$arity$2 = (function (f,x){
return (function() {
var G__36035 = null;
var G__36035__1 = (function (a){
var G__33494 = (((a == null))?x:a);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__33494) : f.call(null, G__33494));
});
var G__36035__2 = (function (a,b){
var G__33495 = (((a == null))?x:a);
var G__33496 = b;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__33495,G__33496) : f.call(null, G__33495,G__33496));
});
var G__36035__3 = (function (a,b,c){
var G__33497 = (((a == null))?x:a);
var G__33498 = b;
var G__33499 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__33497,G__33498,G__33499) : f.call(null, G__33497,G__33498,G__33499));
});
var G__36035__4 = (function() { 
var G__36040__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),b,c,ds);
};
var G__36040 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__36041__i = 0, G__36041__a = new Array(arguments.length -  3);
while (G__36041__i < G__36041__a.length) {G__36041__a[G__36041__i] = arguments[G__36041__i + 3]; ++G__36041__i;}
  ds = new cljs.core.IndexedSeq(G__36041__a,0,null);
} 
return G__36040__delegate.call(this,a,b,c,ds);};
G__36040.cljs$lang$maxFixedArity = 3;
G__36040.cljs$lang$applyTo = (function (arglist__36042){
var a = cljs.core.first(arglist__36042);
arglist__36042 = cljs.core.next(arglist__36042);
var b = cljs.core.first(arglist__36042);
arglist__36042 = cljs.core.next(arglist__36042);
var c = cljs.core.first(arglist__36042);
var ds = cljs.core.rest(arglist__36042);
return G__36040__delegate(a,b,c,ds);
});
G__36040.cljs$core$IFn$_invoke$arity$variadic = G__36040__delegate;
return G__36040;
})()
;
G__36035 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 1:
return G__36035__1.call(this,a);
case 2:
return G__36035__2.call(this,a,b);
case 3:
return G__36035__3.call(this,a,b,c);
default:
var G__36043 = null;
if (arguments.length > 3) {
var G__36044__i = 0, G__36044__a = new Array(arguments.length -  3);
while (G__36044__i < G__36044__a.length) {G__36044__a[G__36044__i] = arguments[G__36044__i + 3]; ++G__36044__i;}
G__36043 = new cljs.core.IndexedSeq(G__36044__a,0,null);
}
return G__36035__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__36043);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36035.cljs$lang$maxFixedArity = 3;
G__36035.cljs$lang$applyTo = G__36035__4.cljs$lang$applyTo;
G__36035.cljs$core$IFn$_invoke$arity$1 = G__36035__1;
G__36035.cljs$core$IFn$_invoke$arity$2 = G__36035__2;
G__36035.cljs$core$IFn$_invoke$arity$3 = G__36035__3;
G__36035.cljs$core$IFn$_invoke$arity$variadic = G__36035__4.cljs$core$IFn$_invoke$arity$variadic;
return G__36035;
})()
}));

(cljs.core.fnil.cljs$core$IFn$_invoke$arity$3 = (function (f,x,y){
return (function() {
var G__36049 = null;
var G__36049__2 = (function (a,b){
var G__33500 = (((a == null))?x:a);
var G__33501 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__33500,G__33501) : f.call(null, G__33500,G__33501));
});
var G__36049__3 = (function (a,b,c){
var G__33502 = (((a == null))?x:a);
var G__33503 = (((b == null))?y:b);
var G__33504 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__33502,G__33503,G__33504) : f.call(null, G__33502,G__33503,G__33504));
});
var G__36049__4 = (function() { 
var G__36050__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),c,ds);
};
var G__36050 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__36052__i = 0, G__36052__a = new Array(arguments.length -  3);
while (G__36052__i < G__36052__a.length) {G__36052__a[G__36052__i] = arguments[G__36052__i + 3]; ++G__36052__i;}
  ds = new cljs.core.IndexedSeq(G__36052__a,0,null);
} 
return G__36050__delegate.call(this,a,b,c,ds);};
G__36050.cljs$lang$maxFixedArity = 3;
G__36050.cljs$lang$applyTo = (function (arglist__36053){
var a = cljs.core.first(arglist__36053);
arglist__36053 = cljs.core.next(arglist__36053);
var b = cljs.core.first(arglist__36053);
arglist__36053 = cljs.core.next(arglist__36053);
var c = cljs.core.first(arglist__36053);
var ds = cljs.core.rest(arglist__36053);
return G__36050__delegate(a,b,c,ds);
});
G__36050.cljs$core$IFn$_invoke$arity$variadic = G__36050__delegate;
return G__36050;
})()
;
G__36049 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__36049__2.call(this,a,b);
case 3:
return G__36049__3.call(this,a,b,c);
default:
var G__36055 = null;
if (arguments.length > 3) {
var G__36056__i = 0, G__36056__a = new Array(arguments.length -  3);
while (G__36056__i < G__36056__a.length) {G__36056__a[G__36056__i] = arguments[G__36056__i + 3]; ++G__36056__i;}
G__36055 = new cljs.core.IndexedSeq(G__36056__a,0,null);
}
return G__36049__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__36055);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36049.cljs$lang$maxFixedArity = 3;
G__36049.cljs$lang$applyTo = G__36049__4.cljs$lang$applyTo;
G__36049.cljs$core$IFn$_invoke$arity$2 = G__36049__2;
G__36049.cljs$core$IFn$_invoke$arity$3 = G__36049__3;
G__36049.cljs$core$IFn$_invoke$arity$variadic = G__36049__4.cljs$core$IFn$_invoke$arity$variadic;
return G__36049;
})()
}));

(cljs.core.fnil.cljs$core$IFn$_invoke$arity$4 = (function (f,x,y,z){
return (function() {
var G__36057 = null;
var G__36057__2 = (function (a,b){
var G__33505 = (((a == null))?x:a);
var G__33506 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__33505,G__33506) : f.call(null, G__33505,G__33506));
});
var G__36057__3 = (function (a,b,c){
var G__33507 = (((a == null))?x:a);
var G__33508 = (((b == null))?y:b);
var G__33509 = (((c == null))?z:c);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__33507,G__33508,G__33509) : f.call(null, G__33507,G__33508,G__33509));
});
var G__36057__4 = (function() { 
var G__36058__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),(((c == null))?z:c),ds);
};
var G__36058 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__36060__i = 0, G__36060__a = new Array(arguments.length -  3);
while (G__36060__i < G__36060__a.length) {G__36060__a[G__36060__i] = arguments[G__36060__i + 3]; ++G__36060__i;}
  ds = new cljs.core.IndexedSeq(G__36060__a,0,null);
} 
return G__36058__delegate.call(this,a,b,c,ds);};
G__36058.cljs$lang$maxFixedArity = 3;
G__36058.cljs$lang$applyTo = (function (arglist__36061){
var a = cljs.core.first(arglist__36061);
arglist__36061 = cljs.core.next(arglist__36061);
var b = cljs.core.first(arglist__36061);
arglist__36061 = cljs.core.next(arglist__36061);
var c = cljs.core.first(arglist__36061);
var ds = cljs.core.rest(arglist__36061);
return G__36058__delegate(a,b,c,ds);
});
G__36058.cljs$core$IFn$_invoke$arity$variadic = G__36058__delegate;
return G__36058;
})()
;
G__36057 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__36057__2.call(this,a,b);
case 3:
return G__36057__3.call(this,a,b,c);
default:
var G__36062 = null;
if (arguments.length > 3) {
var G__36063__i = 0, G__36063__a = new Array(arguments.length -  3);
while (G__36063__i < G__36063__a.length) {G__36063__a[G__36063__i] = arguments[G__36063__i + 3]; ++G__36063__i;}
G__36062 = new cljs.core.IndexedSeq(G__36063__a,0,null);
}
return G__36057__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__36062);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36057.cljs$lang$maxFixedArity = 3;
G__36057.cljs$lang$applyTo = G__36057__4.cljs$lang$applyTo;
G__36057.cljs$core$IFn$_invoke$arity$2 = G__36057__2;
G__36057.cljs$core$IFn$_invoke$arity$3 = G__36057__3;
G__36057.cljs$core$IFn$_invoke$arity$variadic = G__36057__4.cljs$core$IFn$_invoke$arity$variadic;
return G__36057;
})()
}));

(cljs.core.fnil.cljs$lang$maxFixedArity = 4);

/**
 * Returns a lazy sequence consisting of the result of applying f to 0
 *   and the first item of coll, followed by applying f to 1 and the second
 *   item in coll, etc, until coll is exhausted. Thus function f should
 *   accept 2 arguments, index and item. Returns a stateful transducer when
 *   no collection is provided.
 */
cljs.core.map_indexed = (function cljs$core$map_indexed(var_args){
var G__33511 = arguments.length;
switch (G__33511) {
case 1:
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var i = (cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1 ? cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1((-1)) : cljs.core.volatile_BANG_.call(null, (-1)));
return (function() {
var G__36066 = null;
var G__36066__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null, ));
});
var G__36066__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result));
});
var G__36066__2 = (function (result,input){
var G__33512 = result;
var G__33513 = (function (){var G__33514 = cljs.core._vreset_BANG_(i,(cljs.core._deref(i) + (1)));
var G__33515 = input;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__33514,G__33515) : f.call(null, G__33514,G__33515));
})();
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__33512,G__33513) : rf.call(null, G__33512,G__33513));
});
G__36066 = function(result,input){
switch(arguments.length){
case 0:
return G__36066__0.call(this);
case 1:
return G__36066__1.call(this,result);
case 2:
return G__36066__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36066.cljs$core$IFn$_invoke$arity$0 = G__36066__0;
G__36066.cljs$core$IFn$_invoke$arity$1 = G__36066__1;
G__36066.cljs$core$IFn$_invoke$arity$2 = G__36066__2;
return G__36066;
})()
});
}));

(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var mapi = (function cljs$core$mapi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__5823__auto__ = cljs.core.seq(coll__$1);
if(temp__5823__auto__){
var s = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__5593__auto___36067 = size;
var i_36068 = (0);
while(true){
if((i_36068 < n__5593__auto___36067)){
cljs.core.chunk_append(b,(function (){var G__33520 = (idx + i_36068);
var G__33521 = cljs.core._nth(c,i_36068);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__33520,G__33521) : f.call(null, G__33520,G__33521));
})());

var G__36069 = (i_36068 + (1));
i_36068 = G__36069;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$mapi((idx + size),cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__33522 = idx;
var G__33523 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__33522,G__33523) : f.call(null, G__33522,G__33523));
})(),cljs$core$mapi((idx + (1)),cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});
return mapi((0),coll);
}));

(cljs.core.map_indexed.cljs$lang$maxFixedArity = 2);

/**
 * Returns a lazy sequence of the non-nil results of (f item). Note,
 *   this means false return values will be included.  f must be free of
 *   side-effects.  Returns a transducer when no collection is provided.
 */
cljs.core.keep = (function cljs$core$keep(var_args){
var G__33525 = arguments.length;
switch (G__33525) {
case 1:
return cljs.core.keep.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.keep.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
return (function() {
var G__36073 = null;
var G__36073__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null, ));
});
var G__36073__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result));
});
var G__36073__2 = (function (result,input){
var v = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null, input));
if((v == null)){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null, result,v));
}
});
G__36073 = function(result,input){
switch(arguments.length){
case 0:
return G__36073__0.call(this);
case 1:
return G__36073__1.call(this,result);
case 2:
return G__36073__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36073.cljs$core$IFn$_invoke$arity$0 = G__36073__0;
G__36073.cljs$core$IFn$_invoke$arity$1 = G__36073__1;
G__36073.cljs$core$IFn$_invoke$arity$2 = G__36073__2;
return G__36073;
})()
});
}));

(cljs.core.keep.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__5823__auto__ = cljs.core.seq(coll);
if(temp__5823__auto__){
var s = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__5593__auto___36074 = size;
var i_36075 = (0);
while(true){
if((i_36075 < n__5593__auto___36074)){
var x_36076 = (function (){var G__33526 = cljs.core._nth(c,i_36075);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__33526) : f.call(null, G__33526));
})();
if((x_36076 == null)){
} else {
cljs.core.chunk_append(b,x_36076);
}

var G__36077 = (i_36075 + (1));
i_36075 = G__36077;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__33527 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__33527) : f.call(null, G__33527));
})();
if((x == null)){
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.keep.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.IWatchable}
 * @implements {cljs.core.IAtom}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IDeref}
*/
cljs.core.Atom = (function (state,meta,validator,watches){
this.state = state;
this.meta = meta;
this.validator = validator;
this.watches = watches;
this.cljs$lang$protocol_mask$partition1$ = 16386;
this.cljs$lang$protocol_mask$partition0$ = 6455296;
});
(cljs.core.Atom.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
}));

(cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return (o__$1 === other);
}));

(cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
}));

(cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
}));

(cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (this$,oldval,newval){
var self__ = this;
var this$__$1 = this;
var seq__33528 = cljs.core.seq(self__.watches);
var chunk__33529 = null;
var count__33530 = (0);
var i__33531 = (0);
while(true){
if((i__33531 < count__33530)){
var vec__33538 = chunk__33529.cljs$core$IIndexed$_nth$arity$2(null, i__33531);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33538,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33538,(1),null);
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key,this$__$1,oldval,newval) : f.call(null, key,this$__$1,oldval,newval));


var G__36080 = seq__33528;
var G__36081 = chunk__33529;
var G__36082 = count__33530;
var G__36083 = (i__33531 + (1));
seq__33528 = G__36080;
chunk__33529 = G__36081;
count__33530 = G__36082;
i__33531 = G__36083;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__33528);
if(temp__5823__auto__){
var seq__33528__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__33528__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__33528__$1);
var G__36084 = cljs.core.chunk_rest(seq__33528__$1);
var G__36085 = c__5525__auto__;
var G__36086 = cljs.core.count(c__5525__auto__);
var G__36087 = (0);
seq__33528 = G__36084;
chunk__33529 = G__36085;
count__33530 = G__36086;
i__33531 = G__36087;
continue;
} else {
var vec__33541 = cljs.core.first(seq__33528__$1);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33541,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33541,(1),null);
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key,this$__$1,oldval,newval) : f.call(null, key,this$__$1,oldval,newval));


var G__36088 = cljs.core.next(seq__33528__$1);
var G__36089 = null;
var G__36090 = (0);
var G__36091 = (0);
seq__33528 = G__36088;
chunk__33529 = G__36089;
count__33530 = G__36090;
i__33531 = G__36091;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (this$,key,f){
var self__ = this;
var this$__$1 = this;
(this$__$1.watches = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.watches,key,f));

return this$__$1;
}));

(cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
return (this$__$1.watches = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.watches,key));
}));

(cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return goog.getUid(this$__$1);
}));

(cljs.core.Atom.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"validator","validator",-325659154,null),new cljs.core.Symbol(null,"watches","watches",1367433992,null)], null);
}));

(cljs.core.Atom.cljs$lang$type = true);

(cljs.core.Atom.cljs$lang$ctorStr = "cljs.core/Atom");

(cljs.core.Atom.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/Atom");
}));

/**
 * Positional factory function for cljs.core/Atom.
 */
cljs.core.__GT_Atom = (function cljs$core$__GT_Atom(state,meta,validator,watches){
return (new cljs.core.Atom(state,meta,validator,watches));
});

/**
 * Creates and returns an Atom with an initial value of x and zero or
 *   more options (in any order):
 * 
 *   :meta metadata-map
 * 
 *   :validator validate-fn
 * 
 *   If metadata-map is supplied, it will become the metadata on the
 *   atom. validate-fn must be nil or a side-effect-free fn of one
 *   argument, which will be passed the intended new state on any state
 *   change. If the new state is unacceptable, the validate-fn should
 *   return false or throw an Error.  If either of these error conditions
 *   occur, then the value of the atom will not change.
 */
cljs.core.atom = (function cljs$core$atom(var_args){
var G__33547 = arguments.length;
switch (G__33547) {
case 1:
return cljs.core.atom.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___36098 = arguments.length;
var i__5727__auto___36099 = (0);
while(true){
if((i__5727__auto___36099 < len__5726__auto___36098)){
args_arr__5751__auto__.push((arguments[i__5727__auto___36099]));

var G__36101 = (i__5727__auto___36099 + (1));
i__5727__auto___36099 = G__36101;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((1) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((1)),(0),null)):null);
return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5752__auto__);

}
});

(cljs.core.atom.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.Atom(x,null,null,null));
}));

(cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic = (function (x,p__33548){
var map__33549 = p__33548;
var map__33549__$1 = cljs.core.__destructure_map(map__33549);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33549__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var validator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33549__$1,new cljs.core.Keyword(null,"validator","validator",-1966190681));
return (new cljs.core.Atom(x,meta,validator,null));
}));

/** @this {Function} */
(cljs.core.atom.cljs$lang$applyTo = (function (seq33545){
var G__33546 = cljs.core.first(seq33545);
var seq33545__$1 = cljs.core.next(seq33545);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33546,seq33545__$1);
}));

(cljs.core.atom.cljs$lang$maxFixedArity = (1));

/**
 * Sets the value of atom to newval without regard for the
 *   current value. Returns new-value.
 */
cljs.core.reset_BANG_ = (function cljs$core$reset_BANG_(a,new_value){
if((a instanceof cljs.core.Atom)){
var validate = a.validator;
if((validate == null)){
} else {
if(cljs.core.truth_((validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(new_value) : validate.call(null, new_value)))){
} else {
throw (new Error("Validator rejected reference state"));
}
}

var old_value = a.state;
(a.state = new_value);

if((a.watches == null)){
} else {
a.cljs$core$IWatchable$_notify_watches$arity$3(null, old_value,new_value);
}

return new_value;
} else {
return cljs.core._reset_BANG_(a,new_value);
}
});
/**
 * Sets the value of atom to newval. Returns [old new], the value of the
 * atom before and after the reset.
 */
cljs.core.reset_vals_BANG_ = (function cljs$core$reset_vals_BANG_(a,new_value){
if((a instanceof cljs.core.Atom)){
var validate = a.validator;
if((validate == null)){
} else {
if(cljs.core.truth_((validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(new_value) : validate.call(null, new_value)))){
} else {
throw (new Error("Validator rejected reference state"));
}
}

var old_value = a.state;
(a.state = new_value);

if((a.watches == null)){
} else {
a.cljs$core$IWatchable$_notify_watches$arity$3(null, old_value,new_value);
}

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [old_value,new_value], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._deref(a),cljs.core._reset_BANG_(a,new_value)], null);
}
});
/**
 * Atomically swaps the value of atom to be:
 *   (apply f current-value-of-atom args). Note that f may be called
 *   multiple times, and thus should be free of side effects.  Returns
 *   the value that was swapped in.
 */
cljs.core.swap_BANG_ = (function cljs$core$swap_BANG_(var_args){
var G__33556 = arguments.length;
switch (G__33556) {
case 2:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___36115 = arguments.length;
var i__5727__auto___36116 = (0);
while(true){
if((i__5727__auto___36116 < len__5726__auto___36115)){
args_arr__5751__auto__.push((arguments[i__5727__auto___36116]));

var G__36117 = (i__5727__auto___36116 + (1));
i__5727__auto___36116 = G__36117;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((4) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((4)),(0),null)):null);
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5752__auto__);

}
});

(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (a,f){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__33557 = a.state;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__33557) : f.call(null, G__33557));
})());
} else {
return cljs.core._swap_BANG_(a,f);
}
}));

(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (a,f,x){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__33558 = a.state;
var G__33559 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__33558,G__33559) : f.call(null, G__33558,G__33559));
})());
} else {
return cljs.core._swap_BANG_(a,f,x);
}
}));

(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (a,f,x,y){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__33560 = a.state;
var G__33561 = x;
var G__33562 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__33560,G__33561,G__33562) : f.call(null, G__33560,G__33561,G__33562));
})());
} else {
return cljs.core._swap_BANG_(a,f,x,y);
}
}));

(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (a,f,x,y,more){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,a.state,x,y,more));
} else {
return cljs.core._swap_BANG_(a,f,x,y,more);
}
}));

/** @this {Function} */
(cljs.core.swap_BANG_.cljs$lang$applyTo = (function (seq33551){
var G__33552 = cljs.core.first(seq33551);
var seq33551__$1 = cljs.core.next(seq33551);
var G__33553 = cljs.core.first(seq33551__$1);
var seq33551__$2 = cljs.core.next(seq33551__$1);
var G__33554 = cljs.core.first(seq33551__$2);
var seq33551__$3 = cljs.core.next(seq33551__$2);
var G__33555 = cljs.core.first(seq33551__$3);
var seq33551__$4 = cljs.core.next(seq33551__$3);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33552,G__33553,G__33554,G__33555,seq33551__$4);
}));

(cljs.core.swap_BANG_.cljs$lang$maxFixedArity = (4));

/**
 * Atomically swaps the value of atom to be:
 *   (apply f current-value-of-atom args). Note that f may be called
 *   multiple times, and thus should be free of side effects.
 *   Returns [old new], the value of the atom before and after the swap.
 */
cljs.core.swap_vals_BANG_ = (function cljs$core$swap_vals_BANG_(var_args){
var G__33569 = arguments.length;
switch (G__33569) {
case 2:
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___36123 = arguments.length;
var i__5727__auto___36124 = (0);
while(true){
if((i__5727__auto___36124 < len__5726__auto___36123)){
args_arr__5751__auto__.push((arguments[i__5727__auto___36124]));

var G__36125 = (i__5727__auto___36124 + (1));
i__5727__auto___36124 = G__36125;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((4) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((4)),(0),null)):null);
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5752__auto__);

}
});

(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (a,f){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_vals_BANG_(a,(function (){var G__33570 = a.state;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__33570) : f.call(null, G__33570));
})());
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._deref(a),cljs.core._swap_BANG_(a,f)], null);
}
}));

(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (a,f,x){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_vals_BANG_(a,(function (){var G__33571 = a.state;
var G__33572 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__33571,G__33572) : f.call(null, G__33571,G__33572));
})());
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._deref(a),cljs.core._swap_BANG_(a,f,x)], null);
}
}));

(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (a,f,x,y){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_vals_BANG_(a,(function (){var G__33573 = a.state;
var G__33574 = x;
var G__33575 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__33573,G__33574,G__33575) : f.call(null, G__33573,G__33574,G__33575));
})());
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._deref(a),cljs.core._swap_BANG_(a,f,x,y)], null);
}
}));

(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (a,f,x,y,more){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_vals_BANG_(a,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,a.state,x,y,more));
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._deref(a),cljs.core._swap_BANG_(a,f,x,y,more)], null);
}
}));

/** @this {Function} */
(cljs.core.swap_vals_BANG_.cljs$lang$applyTo = (function (seq33564){
var G__33565 = cljs.core.first(seq33564);
var seq33564__$1 = cljs.core.next(seq33564);
var G__33566 = cljs.core.first(seq33564__$1);
var seq33564__$2 = cljs.core.next(seq33564__$1);
var G__33567 = cljs.core.first(seq33564__$2);
var seq33564__$3 = cljs.core.next(seq33564__$2);
var G__33568 = cljs.core.first(seq33564__$3);
var seq33564__$4 = cljs.core.next(seq33564__$3);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33565,G__33566,G__33567,G__33568,seq33564__$4);
}));

(cljs.core.swap_vals_BANG_.cljs$lang$maxFixedArity = (4));

/**
 * Atomically sets the value of atom to newval if and only if the
 *   current value of the atom is equal to oldval. Returns true if
 *   set happened, else false.
 */
cljs.core.compare_and_set_BANG_ = (function cljs$core$compare_and_set_BANG_(a,oldval,newval){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a.cljs$core$IDeref$_deref$arity$1(null, ),oldval)){
cljs.core.reset_BANG_(a,newval);

return true;
} else {
return false;
}
});
/**
 * Sets the validator-fn for an atom. validator-fn must be nil or a
 *   side-effect-free fn of one argument, which will be passed the intended
 *   new state on any state change. If the new state is unacceptable, the
 *   validator-fn should return false or throw an Error. If the current state
 *   is not acceptable to the new validator, an Error will be thrown and the
 *   validator will not be changed.
 */
cljs.core.set_validator_BANG_ = (function cljs$core$set_validator_BANG_(iref,val){
if((((!((val == null)))) && (cljs.core.not((function (){var G__33576 = cljs.core._deref(iref);
return (val.cljs$core$IFn$_invoke$arity$1 ? val.cljs$core$IFn$_invoke$arity$1(G__33576) : val.call(null, G__33576));
})())))){
throw (new Error("Validator rejected reference state"));
} else {
}

return (iref.validator = val);
});
/**
 * Gets the validator-fn for a var/ref/agent/atom.
 */
cljs.core.get_validator = (function cljs$core$get_validator(iref){
return iref.validator;
});

/**
* @constructor
 * @implements {cljs.core.IVolatile}
 * @implements {cljs.core.IDeref}
*/
cljs.core.Volatile = (function (state){
this.state = state;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.Volatile.prototype.cljs$core$IVolatile$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Volatile.prototype.cljs$core$IVolatile$_vreset_BANG_$arity$2 = (function (_,new_state){
var self__ = this;
var ___$1 = this;
return (self__.state = new_state);
}));

(cljs.core.Volatile.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
}));

(cljs.core.Volatile.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Volatile.cljs$lang$type = true);

(cljs.core.Volatile.cljs$lang$ctorStr = "cljs.core/Volatile");

(cljs.core.Volatile.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/Volatile");
}));

/**
 * Positional factory function for cljs.core/Volatile.
 */
cljs.core.__GT_Volatile = (function cljs$core$__GT_Volatile(state){
return (new cljs.core.Volatile(state));
});

/**
 * Creates and returns a Volatile with an initial value of val.
 */
cljs.core.volatile_BANG_ = (function cljs$core$volatile_BANG_(val){
return (new cljs.core.Volatile(val));
});
/**
 * Returns true if x is a volatile.
 */
cljs.core.volatile_QMARK_ = (function cljs$core$volatile_QMARK_(x){
return (x instanceof cljs.core.Volatile);
});
/**
 * Sets the value of volatile to newval without regard for the
 * current value. Returns newval.
 */
cljs.core.vreset_BANG_ = (function cljs$core$vreset_BANG_(vol,newval){
return cljs.core._vreset_BANG_(vol,newval);
});
/**
 * Returns a lazy sequence of the non-nil results of (f index item). Note,
 *   this means false return values will be included.  f must be free of
 *   side-effects.  Returns a stateful transducer when no collection is
 *   provided.
 */
cljs.core.keep_indexed = (function cljs$core$keep_indexed(var_args){
var G__33578 = arguments.length;
switch (G__33578) {
case 1:
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var ia = cljs.core.volatile_BANG_((-1));
return (function() {
var G__36155 = null;
var G__36155__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null, ));
});
var G__36155__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result));
});
var G__36155__2 = (function (result,input){
var i = ia.cljs$core$IVolatile$_vreset_BANG_$arity$2(null, (ia.cljs$core$IDeref$_deref$arity$1(null, ) + (1)));
var v = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(i,input) : f.call(null, i,input));
if((v == null)){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null, result,v));
}
});
G__36155 = function(result,input){
switch(arguments.length){
case 0:
return G__36155__0.call(this);
case 1:
return G__36155__1.call(this,result);
case 2:
return G__36155__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36155.cljs$core$IFn$_invoke$arity$0 = G__36155__0;
G__36155.cljs$core$IFn$_invoke$arity$1 = G__36155__1;
G__36155.cljs$core$IFn$_invoke$arity$2 = G__36155__2;
return G__36155;
})()
});
}));

(cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var keepi = (function cljs$core$keepi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__5823__auto__ = cljs.core.seq(coll__$1);
if(temp__5823__auto__){
var s = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__5593__auto___36156 = size;
var i_36157 = (0);
while(true){
if((i_36157 < n__5593__auto___36156)){
var x_36158 = (function (){var G__33583 = (idx + i_36157);
var G__33584 = cljs.core._nth(c,i_36157);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__33583,G__33584) : f.call(null, G__33583,G__33584));
})();
if((x_36158 == null)){
} else {
cljs.core.chunk_append(b,x_36158);
}

var G__36159 = (i_36157 + (1));
i_36157 = G__36159;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$keepi((idx + size),cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__33585 = idx;
var G__33586 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__33585,G__33586) : f.call(null, G__33585,G__33586));
})();
if((x == null)){
return cljs$core$keepi((idx + (1)),cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs$core$keepi((idx + (1)),cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});
return keepi((0),coll);
}));

(cljs.core.keep_indexed.cljs$lang$maxFixedArity = 2);

/**
 * Takes a set of predicates and returns a function f that returns true if all of its
 *   composing predicates return a logical true value against all of its arguments, else it returns
 *   false. Note that f is short-circuiting in that it will stop execution on the first
 *   argument that triggers a logical false result against the original predicates.
 */
cljs.core.every_pred = (function cljs$core$every_pred(var_args){
var G__33598 = arguments.length;
switch (G__33598) {
case 1:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___36167 = arguments.length;
var i__5727__auto___36168 = (0);
while(true){
if((i__5727__auto___36168 < len__5726__auto___36167)){
args_arr__5751__auto__.push((arguments[i__5727__auto___36168]));

var G__36169 = (i__5727__auto___36168 + (1));
i__5727__auto___36168 = G__36169;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((3) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((3)),(0),null)):null);
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5752__auto__);

}
});

(cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1 = (function (p){
return (function() {
var cljs$core$ep1 = null;
var cljs$core$ep1__0 = (function (){
return true;
});
var cljs$core$ep1__1 = (function (x){
return cljs.core.boolean$((p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null, x)));
});
var cljs$core$ep1__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__5000__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null, x));
if(cljs.core.truth_(and__5000__auto__)){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null, y));
} else {
return and__5000__auto__;
}
})());
});
var cljs$core$ep1__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__5000__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null, x));
if(cljs.core.truth_(and__5000__auto__)){
var and__5000__auto____$1 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null, y));
if(cljs.core.truth_(and__5000__auto____$1)){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null, z));
} else {
return and__5000__auto____$1;
}
} else {
return and__5000__auto__;
}
})());
});
var cljs$core$ep1__4 = (function() { 
var G__36170__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__5000__auto__ = cljs$core$ep1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__5000__auto__)){
return cljs.core.every_QMARK_(p,args);
} else {
return and__5000__auto__;
}
})());
};
var G__36170 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__36171__i = 0, G__36171__a = new Array(arguments.length -  3);
while (G__36171__i < G__36171__a.length) {G__36171__a[G__36171__i] = arguments[G__36171__i + 3]; ++G__36171__i;}
  args = new cljs.core.IndexedSeq(G__36171__a,0,null);
} 
return G__36170__delegate.call(this,x,y,z,args);};
G__36170.cljs$lang$maxFixedArity = 3;
G__36170.cljs$lang$applyTo = (function (arglist__36172){
var x = cljs.core.first(arglist__36172);
arglist__36172 = cljs.core.next(arglist__36172);
var y = cljs.core.first(arglist__36172);
arglist__36172 = cljs.core.next(arglist__36172);
var z = cljs.core.first(arglist__36172);
var args = cljs.core.rest(arglist__36172);
return G__36170__delegate(x,y,z,args);
});
G__36170.cljs$core$IFn$_invoke$arity$variadic = G__36170__delegate;
return G__36170;
})()
;
cljs$core$ep1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep1__0.call(this);
case 1:
return cljs$core$ep1__1.call(this,x);
case 2:
return cljs$core$ep1__2.call(this,x,y);
case 3:
return cljs$core$ep1__3.call(this,x,y,z);
default:
var G__36173 = null;
if (arguments.length > 3) {
var G__36174__i = 0, G__36174__a = new Array(arguments.length -  3);
while (G__36174__i < G__36174__a.length) {G__36174__a[G__36174__i] = arguments[G__36174__i + 3]; ++G__36174__i;}
G__36173 = new cljs.core.IndexedSeq(G__36174__a,0,null);
}
return cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__36173);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ep1.cljs$lang$maxFixedArity = 3;
cljs$core$ep1.cljs$lang$applyTo = cljs$core$ep1__4.cljs$lang$applyTo;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep1__0;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep1__1;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep1__2;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep1__3;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep1;
})()
}));

(cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2 = (function (p1,p2){
return (function() {
var cljs$core$ep2 = null;
var cljs$core$ep2__0 = (function (){
return true;
});
var cljs$core$ep2__1 = (function (x){
return cljs.core.boolean$((function (){var and__5000__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x));
if(cljs.core.truth_(and__5000__auto__)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x));
} else {
return and__5000__auto__;
}
})());
});
var cljs$core$ep2__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__5000__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x));
if(cljs.core.truth_(and__5000__auto__)){
var and__5000__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y));
if(cljs.core.truth_(and__5000__auto____$1)){
var and__5000__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x));
if(cljs.core.truth_(and__5000__auto____$2)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y));
} else {
return and__5000__auto____$2;
}
} else {
return and__5000__auto____$1;
}
} else {
return and__5000__auto__;
}
})());
});
var cljs$core$ep2__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__5000__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x));
if(cljs.core.truth_(and__5000__auto__)){
var and__5000__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y));
if(cljs.core.truth_(and__5000__auto____$1)){
var and__5000__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null, z));
if(cljs.core.truth_(and__5000__auto____$2)){
var and__5000__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x));
if(cljs.core.truth_(and__5000__auto____$3)){
var and__5000__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y));
if(cljs.core.truth_(and__5000__auto____$4)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null, z));
} else {
return and__5000__auto____$4;
}
} else {
return and__5000__auto____$3;
}
} else {
return and__5000__auto____$2;
}
} else {
return and__5000__auto____$1;
}
} else {
return and__5000__auto__;
}
})());
});
var cljs$core$ep2__4 = (function() { 
var G__36181__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__5000__auto__ = cljs$core$ep2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__5000__auto__)){
return cljs.core.every_QMARK_((function (p1__33587_SHARP_){
var and__5000__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__33587_SHARP_) : p1.call(null, p1__33587_SHARP_));
if(cljs.core.truth_(and__5000__auto____$1)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__33587_SHARP_) : p2.call(null, p1__33587_SHARP_));
} else {
return and__5000__auto____$1;
}
}),args);
} else {
return and__5000__auto__;
}
})());
};
var G__36181 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__36182__i = 0, G__36182__a = new Array(arguments.length -  3);
while (G__36182__i < G__36182__a.length) {G__36182__a[G__36182__i] = arguments[G__36182__i + 3]; ++G__36182__i;}
  args = new cljs.core.IndexedSeq(G__36182__a,0,null);
} 
return G__36181__delegate.call(this,x,y,z,args);};
G__36181.cljs$lang$maxFixedArity = 3;
G__36181.cljs$lang$applyTo = (function (arglist__36183){
var x = cljs.core.first(arglist__36183);
arglist__36183 = cljs.core.next(arglist__36183);
var y = cljs.core.first(arglist__36183);
arglist__36183 = cljs.core.next(arglist__36183);
var z = cljs.core.first(arglist__36183);
var args = cljs.core.rest(arglist__36183);
return G__36181__delegate(x,y,z,args);
});
G__36181.cljs$core$IFn$_invoke$arity$variadic = G__36181__delegate;
return G__36181;
})()
;
cljs$core$ep2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep2__0.call(this);
case 1:
return cljs$core$ep2__1.call(this,x);
case 2:
return cljs$core$ep2__2.call(this,x,y);
case 3:
return cljs$core$ep2__3.call(this,x,y,z);
default:
var G__36185 = null;
if (arguments.length > 3) {
var G__36186__i = 0, G__36186__a = new Array(arguments.length -  3);
while (G__36186__i < G__36186__a.length) {G__36186__a[G__36186__i] = arguments[G__36186__i + 3]; ++G__36186__i;}
G__36185 = new cljs.core.IndexedSeq(G__36186__a,0,null);
}
return cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__36185);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ep2.cljs$lang$maxFixedArity = 3;
cljs$core$ep2.cljs$lang$applyTo = cljs$core$ep2__4.cljs$lang$applyTo;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep2__0;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep2__1;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep2__2;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep2__3;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep2;
})()
}));

(cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3 = (function (p1,p2,p3){
return (function() {
var cljs$core$ep3 = null;
var cljs$core$ep3__0 = (function (){
return true;
});
var cljs$core$ep3__1 = (function (x){
return cljs.core.boolean$((function (){var and__5000__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x));
if(cljs.core.truth_(and__5000__auto__)){
var and__5000__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x));
if(cljs.core.truth_(and__5000__auto____$1)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null, x));
} else {
return and__5000__auto____$1;
}
} else {
return and__5000__auto__;
}
})());
});
var cljs$core$ep3__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__5000__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x));
if(cljs.core.truth_(and__5000__auto__)){
var and__5000__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y));
if(cljs.core.truth_(and__5000__auto____$1)){
var and__5000__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x));
if(cljs.core.truth_(and__5000__auto____$2)){
var and__5000__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y));
if(cljs.core.truth_(and__5000__auto____$3)){
var and__5000__auto____$4 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null, x));
if(cljs.core.truth_(and__5000__auto____$4)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null, y));
} else {
return and__5000__auto____$4;
}
} else {
return and__5000__auto____$3;
}
} else {
return and__5000__auto____$2;
}
} else {
return and__5000__auto____$1;
}
} else {
return and__5000__auto__;
}
})());
});
var cljs$core$ep3__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__5000__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x));
if(cljs.core.truth_(and__5000__auto__)){
var and__5000__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y));
if(cljs.core.truth_(and__5000__auto____$1)){
var and__5000__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null, z));
if(cljs.core.truth_(and__5000__auto____$2)){
var and__5000__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x));
if(cljs.core.truth_(and__5000__auto____$3)){
var and__5000__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y));
if(cljs.core.truth_(and__5000__auto____$4)){
var and__5000__auto____$5 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null, z));
if(cljs.core.truth_(and__5000__auto____$5)){
var and__5000__auto____$6 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null, x));
if(cljs.core.truth_(and__5000__auto____$6)){
var and__5000__auto____$7 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null, y));
if(cljs.core.truth_(and__5000__auto____$7)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null, z));
} else {
return and__5000__auto____$7;
}
} else {
return and__5000__auto____$6;
}
} else {
return and__5000__auto____$5;
}
} else {
return and__5000__auto____$4;
}
} else {
return and__5000__auto____$3;
}
} else {
return and__5000__auto____$2;
}
} else {
return and__5000__auto____$1;
}
} else {
return and__5000__auto__;
}
})());
});
var cljs$core$ep3__4 = (function() { 
var G__36189__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__5000__auto__ = cljs$core$ep3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__5000__auto__)){
return cljs.core.every_QMARK_((function (p1__33588_SHARP_){
var and__5000__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__33588_SHARP_) : p1.call(null, p1__33588_SHARP_));
if(cljs.core.truth_(and__5000__auto____$1)){
var and__5000__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__33588_SHARP_) : p2.call(null, p1__33588_SHARP_));
if(cljs.core.truth_(and__5000__auto____$2)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__33588_SHARP_) : p3.call(null, p1__33588_SHARP_));
} else {
return and__5000__auto____$2;
}
} else {
return and__5000__auto____$1;
}
}),args);
} else {
return and__5000__auto__;
}
})());
};
var G__36189 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__36191__i = 0, G__36191__a = new Array(arguments.length -  3);
while (G__36191__i < G__36191__a.length) {G__36191__a[G__36191__i] = arguments[G__36191__i + 3]; ++G__36191__i;}
  args = new cljs.core.IndexedSeq(G__36191__a,0,null);
} 
return G__36189__delegate.call(this,x,y,z,args);};
G__36189.cljs$lang$maxFixedArity = 3;
G__36189.cljs$lang$applyTo = (function (arglist__36192){
var x = cljs.core.first(arglist__36192);
arglist__36192 = cljs.core.next(arglist__36192);
var y = cljs.core.first(arglist__36192);
arglist__36192 = cljs.core.next(arglist__36192);
var z = cljs.core.first(arglist__36192);
var args = cljs.core.rest(arglist__36192);
return G__36189__delegate(x,y,z,args);
});
G__36189.cljs$core$IFn$_invoke$arity$variadic = G__36189__delegate;
return G__36189;
})()
;
cljs$core$ep3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep3__0.call(this);
case 1:
return cljs$core$ep3__1.call(this,x);
case 2:
return cljs$core$ep3__2.call(this,x,y);
case 3:
return cljs$core$ep3__3.call(this,x,y,z);
default:
var G__36193 = null;
if (arguments.length > 3) {
var G__36194__i = 0, G__36194__a = new Array(arguments.length -  3);
while (G__36194__i < G__36194__a.length) {G__36194__a[G__36194__i] = arguments[G__36194__i + 3]; ++G__36194__i;}
G__36193 = new cljs.core.IndexedSeq(G__36194__a,0,null);
}
return cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__36193);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ep3.cljs$lang$maxFixedArity = 3;
cljs$core$ep3.cljs$lang$applyTo = cljs$core$ep3__4.cljs$lang$applyTo;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep3__0;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep3__1;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep3__2;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep3__3;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep3;
})()
}));

(cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic = (function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return (function() {
var cljs$core$epn = null;
var cljs$core$epn__0 = (function (){
return true;
});
var cljs$core$epn__1 = (function (x){
return cljs.core.every_QMARK_((function (p1__33589_SHARP_){
return (p1__33589_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__33589_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__33589_SHARP_.call(null, x));
}),ps__$1);
});
var cljs$core$epn__2 = (function (x,y){
return cljs.core.every_QMARK_((function (p1__33590_SHARP_){
var and__5000__auto__ = (p1__33590_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__33590_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__33590_SHARP_.call(null, x));
if(cljs.core.truth_(and__5000__auto__)){
return (p1__33590_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__33590_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__33590_SHARP_.call(null, y));
} else {
return and__5000__auto__;
}
}),ps__$1);
});
var cljs$core$epn__3 = (function (x,y,z){
return cljs.core.every_QMARK_((function (p1__33591_SHARP_){
var and__5000__auto__ = (p1__33591_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__33591_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__33591_SHARP_.call(null, x));
if(cljs.core.truth_(and__5000__auto__)){
var and__5000__auto____$1 = (p1__33591_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__33591_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__33591_SHARP_.call(null, y));
if(cljs.core.truth_(and__5000__auto____$1)){
return (p1__33591_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__33591_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__33591_SHARP_.call(null, z));
} else {
return and__5000__auto____$1;
}
} else {
return and__5000__auto__;
}
}),ps__$1);
});
var cljs$core$epn__4 = (function() { 
var G__36196__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__5000__auto__ = cljs$core$epn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__5000__auto__)){
return cljs.core.every_QMARK_((function (p1__33592_SHARP_){
return cljs.core.every_QMARK_(p1__33592_SHARP_,args);
}),ps__$1);
} else {
return and__5000__auto__;
}
})());
};
var G__36196 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__36199__i = 0, G__36199__a = new Array(arguments.length -  3);
while (G__36199__i < G__36199__a.length) {G__36199__a[G__36199__i] = arguments[G__36199__i + 3]; ++G__36199__i;}
  args = new cljs.core.IndexedSeq(G__36199__a,0,null);
} 
return G__36196__delegate.call(this,x,y,z,args);};
G__36196.cljs$lang$maxFixedArity = 3;
G__36196.cljs$lang$applyTo = (function (arglist__36200){
var x = cljs.core.first(arglist__36200);
arglist__36200 = cljs.core.next(arglist__36200);
var y = cljs.core.first(arglist__36200);
arglist__36200 = cljs.core.next(arglist__36200);
var z = cljs.core.first(arglist__36200);
var args = cljs.core.rest(arglist__36200);
return G__36196__delegate(x,y,z,args);
});
G__36196.cljs$core$IFn$_invoke$arity$variadic = G__36196__delegate;
return G__36196;
})()
;
cljs$core$epn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$epn__0.call(this);
case 1:
return cljs$core$epn__1.call(this,x);
case 2:
return cljs$core$epn__2.call(this,x,y);
case 3:
return cljs$core$epn__3.call(this,x,y,z);
default:
var G__36201 = null;
if (arguments.length > 3) {
var G__36202__i = 0, G__36202__a = new Array(arguments.length -  3);
while (G__36202__i < G__36202__a.length) {G__36202__a[G__36202__i] = arguments[G__36202__i + 3]; ++G__36202__i;}
G__36201 = new cljs.core.IndexedSeq(G__36202__a,0,null);
}
return cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__36201);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$epn.cljs$lang$maxFixedArity = 3;
cljs$core$epn.cljs$lang$applyTo = cljs$core$epn__4.cljs$lang$applyTo;
cljs$core$epn.cljs$core$IFn$_invoke$arity$0 = cljs$core$epn__0;
cljs$core$epn.cljs$core$IFn$_invoke$arity$1 = cljs$core$epn__1;
cljs$core$epn.cljs$core$IFn$_invoke$arity$2 = cljs$core$epn__2;
cljs$core$epn.cljs$core$IFn$_invoke$arity$3 = cljs$core$epn__3;
cljs$core$epn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$epn;
})()
}));

/** @this {Function} */
(cljs.core.every_pred.cljs$lang$applyTo = (function (seq33594){
var G__33595 = cljs.core.first(seq33594);
var seq33594__$1 = cljs.core.next(seq33594);
var G__33596 = cljs.core.first(seq33594__$1);
var seq33594__$2 = cljs.core.next(seq33594__$1);
var G__33597 = cljs.core.first(seq33594__$2);
var seq33594__$3 = cljs.core.next(seq33594__$2);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33595,G__33596,G__33597,seq33594__$3);
}));

(cljs.core.every_pred.cljs$lang$maxFixedArity = (3));

/**
 * Takes a set of predicates and returns a function f that returns the first logical true value
 *   returned by one of its composing predicates against any of its arguments, else it returns
 *   logical false. Note that f is short-circuiting in that it will stop execution on the first
 *   argument that triggers a logical true result against the original predicates.
 */
cljs.core.some_fn = (function cljs$core$some_fn(var_args){
var G__33610 = arguments.length;
switch (G__33610) {
case 1:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___36204 = arguments.length;
var i__5727__auto___36206 = (0);
while(true){
if((i__5727__auto___36206 < len__5726__auto___36204)){
args_arr__5751__auto__.push((arguments[i__5727__auto___36206]));

var G__36207 = (i__5727__auto___36206 + (1));
i__5727__auto___36206 = G__36207;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((3) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((3)),(0),null)):null);
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5752__auto__);

}
});

(cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1 = (function (p){
return (function() {
var cljs$core$sp1 = null;
var cljs$core$sp1__0 = (function (){
return null;
});
var cljs$core$sp1__1 = (function (x){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null, x));
});
var cljs$core$sp1__2 = (function (x,y){
var or__5002__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null, x));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null, y));
}
});
var cljs$core$sp1__3 = (function (x,y,z){
var or__5002__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null, x));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
var or__5002__auto____$1 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null, y));
if(cljs.core.truth_(or__5002__auto____$1)){
return or__5002__auto____$1;
} else {
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null, z));
}
}
});
var cljs$core$sp1__4 = (function() { 
var G__36209__delegate = function (x,y,z,args){
var or__5002__auto__ = cljs$core$sp1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.some(p,args);
}
};
var G__36209 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__36210__i = 0, G__36210__a = new Array(arguments.length -  3);
while (G__36210__i < G__36210__a.length) {G__36210__a[G__36210__i] = arguments[G__36210__i + 3]; ++G__36210__i;}
  args = new cljs.core.IndexedSeq(G__36210__a,0,null);
} 
return G__36209__delegate.call(this,x,y,z,args);};
G__36209.cljs$lang$maxFixedArity = 3;
G__36209.cljs$lang$applyTo = (function (arglist__36211){
var x = cljs.core.first(arglist__36211);
arglist__36211 = cljs.core.next(arglist__36211);
var y = cljs.core.first(arglist__36211);
arglist__36211 = cljs.core.next(arglist__36211);
var z = cljs.core.first(arglist__36211);
var args = cljs.core.rest(arglist__36211);
return G__36209__delegate(x,y,z,args);
});
G__36209.cljs$core$IFn$_invoke$arity$variadic = G__36209__delegate;
return G__36209;
})()
;
cljs$core$sp1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp1__0.call(this);
case 1:
return cljs$core$sp1__1.call(this,x);
case 2:
return cljs$core$sp1__2.call(this,x,y);
case 3:
return cljs$core$sp1__3.call(this,x,y,z);
default:
var G__36212 = null;
if (arguments.length > 3) {
var G__36213__i = 0, G__36213__a = new Array(arguments.length -  3);
while (G__36213__i < G__36213__a.length) {G__36213__a[G__36213__i] = arguments[G__36213__i + 3]; ++G__36213__i;}
G__36212 = new cljs.core.IndexedSeq(G__36213__a,0,null);
}
return cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__36212);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sp1.cljs$lang$maxFixedArity = 3;
cljs$core$sp1.cljs$lang$applyTo = cljs$core$sp1__4.cljs$lang$applyTo;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp1__0;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp1__1;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp1__2;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp1__3;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp1;
})()
}));

(cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2 = (function (p1,p2){
return (function() {
var cljs$core$sp2 = null;
var cljs$core$sp2__0 = (function (){
return null;
});
var cljs$core$sp2__1 = (function (x){
var or__5002__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x));
}
});
var cljs$core$sp2__2 = (function (x,y){
var or__5002__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
var or__5002__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y));
if(cljs.core.truth_(or__5002__auto____$1)){
return or__5002__auto____$1;
} else {
var or__5002__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x));
if(cljs.core.truth_(or__5002__auto____$2)){
return or__5002__auto____$2;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y));
}
}
}
});
var cljs$core$sp2__3 = (function (x,y,z){
var or__5002__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
var or__5002__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y));
if(cljs.core.truth_(or__5002__auto____$1)){
return or__5002__auto____$1;
} else {
var or__5002__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null, z));
if(cljs.core.truth_(or__5002__auto____$2)){
return or__5002__auto____$2;
} else {
var or__5002__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x));
if(cljs.core.truth_(or__5002__auto____$3)){
return or__5002__auto____$3;
} else {
var or__5002__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y));
if(cljs.core.truth_(or__5002__auto____$4)){
return or__5002__auto____$4;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null, z));
}
}
}
}
}
});
var cljs$core$sp2__4 = (function() { 
var G__36214__delegate = function (x,y,z,args){
var or__5002__auto__ = cljs$core$sp2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.some((function (p1__33599_SHARP_){
var or__5002__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__33599_SHARP_) : p1.call(null, p1__33599_SHARP_));
if(cljs.core.truth_(or__5002__auto____$1)){
return or__5002__auto____$1;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__33599_SHARP_) : p2.call(null, p1__33599_SHARP_));
}
}),args);
}
};
var G__36214 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__36217__i = 0, G__36217__a = new Array(arguments.length -  3);
while (G__36217__i < G__36217__a.length) {G__36217__a[G__36217__i] = arguments[G__36217__i + 3]; ++G__36217__i;}
  args = new cljs.core.IndexedSeq(G__36217__a,0,null);
} 
return G__36214__delegate.call(this,x,y,z,args);};
G__36214.cljs$lang$maxFixedArity = 3;
G__36214.cljs$lang$applyTo = (function (arglist__36218){
var x = cljs.core.first(arglist__36218);
arglist__36218 = cljs.core.next(arglist__36218);
var y = cljs.core.first(arglist__36218);
arglist__36218 = cljs.core.next(arglist__36218);
var z = cljs.core.first(arglist__36218);
var args = cljs.core.rest(arglist__36218);
return G__36214__delegate(x,y,z,args);
});
G__36214.cljs$core$IFn$_invoke$arity$variadic = G__36214__delegate;
return G__36214;
})()
;
cljs$core$sp2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp2__0.call(this);
case 1:
return cljs$core$sp2__1.call(this,x);
case 2:
return cljs$core$sp2__2.call(this,x,y);
case 3:
return cljs$core$sp2__3.call(this,x,y,z);
default:
var G__36219 = null;
if (arguments.length > 3) {
var G__36220__i = 0, G__36220__a = new Array(arguments.length -  3);
while (G__36220__i < G__36220__a.length) {G__36220__a[G__36220__i] = arguments[G__36220__i + 3]; ++G__36220__i;}
G__36219 = new cljs.core.IndexedSeq(G__36220__a,0,null);
}
return cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__36219);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sp2.cljs$lang$maxFixedArity = 3;
cljs$core$sp2.cljs$lang$applyTo = cljs$core$sp2__4.cljs$lang$applyTo;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp2__0;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp2__1;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp2__2;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp2__3;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp2;
})()
}));

(cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3 = (function (p1,p2,p3){
return (function() {
var cljs$core$sp3 = null;
var cljs$core$sp3__0 = (function (){
return null;
});
var cljs$core$sp3__1 = (function (x){
var or__5002__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
var or__5002__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x));
if(cljs.core.truth_(or__5002__auto____$1)){
return or__5002__auto____$1;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null, x));
}
}
});
var cljs$core$sp3__2 = (function (x,y){
var or__5002__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
var or__5002__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y));
if(cljs.core.truth_(or__5002__auto____$1)){
return or__5002__auto____$1;
} else {
var or__5002__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x));
if(cljs.core.truth_(or__5002__auto____$2)){
return or__5002__auto____$2;
} else {
var or__5002__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y));
if(cljs.core.truth_(or__5002__auto____$3)){
return or__5002__auto____$3;
} else {
var or__5002__auto____$4 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null, x));
if(cljs.core.truth_(or__5002__auto____$4)){
return or__5002__auto____$4;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null, y));
}
}
}
}
}
});
var cljs$core$sp3__3 = (function (x,y,z){
var or__5002__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
var or__5002__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y));
if(cljs.core.truth_(or__5002__auto____$1)){
return or__5002__auto____$1;
} else {
var or__5002__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null, z));
if(cljs.core.truth_(or__5002__auto____$2)){
return or__5002__auto____$2;
} else {
var or__5002__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x));
if(cljs.core.truth_(or__5002__auto____$3)){
return or__5002__auto____$3;
} else {
var or__5002__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y));
if(cljs.core.truth_(or__5002__auto____$4)){
return or__5002__auto____$4;
} else {
var or__5002__auto____$5 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null, z));
if(cljs.core.truth_(or__5002__auto____$5)){
return or__5002__auto____$5;
} else {
var or__5002__auto____$6 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null, x));
if(cljs.core.truth_(or__5002__auto____$6)){
return or__5002__auto____$6;
} else {
var or__5002__auto____$7 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null, y));
if(cljs.core.truth_(or__5002__auto____$7)){
return or__5002__auto____$7;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null, z));
}
}
}
}
}
}
}
}
});
var cljs$core$sp3__4 = (function() { 
var G__36222__delegate = function (x,y,z,args){
var or__5002__auto__ = cljs$core$sp3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.some((function (p1__33600_SHARP_){
var or__5002__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__33600_SHARP_) : p1.call(null, p1__33600_SHARP_));
if(cljs.core.truth_(or__5002__auto____$1)){
return or__5002__auto____$1;
} else {
var or__5002__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__33600_SHARP_) : p2.call(null, p1__33600_SHARP_));
if(cljs.core.truth_(or__5002__auto____$2)){
return or__5002__auto____$2;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__33600_SHARP_) : p3.call(null, p1__33600_SHARP_));
}
}
}),args);
}
};
var G__36222 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__36226__i = 0, G__36226__a = new Array(arguments.length -  3);
while (G__36226__i < G__36226__a.length) {G__36226__a[G__36226__i] = arguments[G__36226__i + 3]; ++G__36226__i;}
  args = new cljs.core.IndexedSeq(G__36226__a,0,null);
} 
return G__36222__delegate.call(this,x,y,z,args);};
G__36222.cljs$lang$maxFixedArity = 3;
G__36222.cljs$lang$applyTo = (function (arglist__36227){
var x = cljs.core.first(arglist__36227);
arglist__36227 = cljs.core.next(arglist__36227);
var y = cljs.core.first(arglist__36227);
arglist__36227 = cljs.core.next(arglist__36227);
var z = cljs.core.first(arglist__36227);
var args = cljs.core.rest(arglist__36227);
return G__36222__delegate(x,y,z,args);
});
G__36222.cljs$core$IFn$_invoke$arity$variadic = G__36222__delegate;
return G__36222;
})()
;
cljs$core$sp3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp3__0.call(this);
case 1:
return cljs$core$sp3__1.call(this,x);
case 2:
return cljs$core$sp3__2.call(this,x,y);
case 3:
return cljs$core$sp3__3.call(this,x,y,z);
default:
var G__36228 = null;
if (arguments.length > 3) {
var G__36229__i = 0, G__36229__a = new Array(arguments.length -  3);
while (G__36229__i < G__36229__a.length) {G__36229__a[G__36229__i] = arguments[G__36229__i + 3]; ++G__36229__i;}
G__36228 = new cljs.core.IndexedSeq(G__36229__a,0,null);
}
return cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__36228);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sp3.cljs$lang$maxFixedArity = 3;
cljs$core$sp3.cljs$lang$applyTo = cljs$core$sp3__4.cljs$lang$applyTo;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp3__0;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp3__1;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp3__2;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp3__3;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp3;
})()
}));

(cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic = (function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return (function() {
var cljs$core$spn = null;
var cljs$core$spn__0 = (function (){
return null;
});
var cljs$core$spn__1 = (function (x){
return cljs.core.some((function (p1__33601_SHARP_){
return (p1__33601_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__33601_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__33601_SHARP_.call(null, x));
}),ps__$1);
});
var cljs$core$spn__2 = (function (x,y){
return cljs.core.some((function (p1__33602_SHARP_){
var or__5002__auto__ = (p1__33602_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__33602_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__33602_SHARP_.call(null, x));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return (p1__33602_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__33602_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__33602_SHARP_.call(null, y));
}
}),ps__$1);
});
var cljs$core$spn__3 = (function (x,y,z){
return cljs.core.some((function (p1__33603_SHARP_){
var or__5002__auto__ = (p1__33603_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__33603_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__33603_SHARP_.call(null, x));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
var or__5002__auto____$1 = (p1__33603_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__33603_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__33603_SHARP_.call(null, y));
if(cljs.core.truth_(or__5002__auto____$1)){
return or__5002__auto____$1;
} else {
return (p1__33603_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__33603_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__33603_SHARP_.call(null, z));
}
}
}),ps__$1);
});
var cljs$core$spn__4 = (function() { 
var G__36232__delegate = function (x,y,z,args){
var or__5002__auto__ = cljs$core$spn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.some((function (p1__33604_SHARP_){
return cljs.core.some(p1__33604_SHARP_,args);
}),ps__$1);
}
};
var G__36232 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__36233__i = 0, G__36233__a = new Array(arguments.length -  3);
while (G__36233__i < G__36233__a.length) {G__36233__a[G__36233__i] = arguments[G__36233__i + 3]; ++G__36233__i;}
  args = new cljs.core.IndexedSeq(G__36233__a,0,null);
} 
return G__36232__delegate.call(this,x,y,z,args);};
G__36232.cljs$lang$maxFixedArity = 3;
G__36232.cljs$lang$applyTo = (function (arglist__36234){
var x = cljs.core.first(arglist__36234);
arglist__36234 = cljs.core.next(arglist__36234);
var y = cljs.core.first(arglist__36234);
arglist__36234 = cljs.core.next(arglist__36234);
var z = cljs.core.first(arglist__36234);
var args = cljs.core.rest(arglist__36234);
return G__36232__delegate(x,y,z,args);
});
G__36232.cljs$core$IFn$_invoke$arity$variadic = G__36232__delegate;
return G__36232;
})()
;
cljs$core$spn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$spn__0.call(this);
case 1:
return cljs$core$spn__1.call(this,x);
case 2:
return cljs$core$spn__2.call(this,x,y);
case 3:
return cljs$core$spn__3.call(this,x,y,z);
default:
var G__36241 = null;
if (arguments.length > 3) {
var G__36242__i = 0, G__36242__a = new Array(arguments.length -  3);
while (G__36242__i < G__36242__a.length) {G__36242__a[G__36242__i] = arguments[G__36242__i + 3]; ++G__36242__i;}
G__36241 = new cljs.core.IndexedSeq(G__36242__a,0,null);
}
return cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__36241);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$spn.cljs$lang$maxFixedArity = 3;
cljs$core$spn.cljs$lang$applyTo = cljs$core$spn__4.cljs$lang$applyTo;
cljs$core$spn.cljs$core$IFn$_invoke$arity$0 = cljs$core$spn__0;
cljs$core$spn.cljs$core$IFn$_invoke$arity$1 = cljs$core$spn__1;
cljs$core$spn.cljs$core$IFn$_invoke$arity$2 = cljs$core$spn__2;
cljs$core$spn.cljs$core$IFn$_invoke$arity$3 = cljs$core$spn__3;
cljs$core$spn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$spn;
})()
}));

/** @this {Function} */
(cljs.core.some_fn.cljs$lang$applyTo = (function (seq33606){
var G__33607 = cljs.core.first(seq33606);
var seq33606__$1 = cljs.core.next(seq33606);
var G__33608 = cljs.core.first(seq33606__$1);
var seq33606__$2 = cljs.core.next(seq33606__$1);
var G__33609 = cljs.core.first(seq33606__$2);
var seq33606__$3 = cljs.core.next(seq33606__$2);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33607,G__33608,G__33609,seq33606__$3);
}));

(cljs.core.some_fn.cljs$lang$maxFixedArity = (3));

/**
 * Returns a lazy sequence consisting of the result of applying f to
 *   the set of first items of each coll, followed by applying f to the
 *   set of second items in each coll, until any one of the colls is
 *   exhausted.  Any remaining items in other colls are ignored. Function
 *   f should accept number-of-colls arguments. Returns a transducer when
 *   no collection is provided.
 */
cljs.core.map = (function cljs$core$map(var_args){
var G__33618 = arguments.length;
switch (G__33618) {
case 1:
return cljs.core.map.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.map.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___36249 = arguments.length;
var i__5727__auto___36250 = (0);
while(true){
if((i__5727__auto___36250 < len__5726__auto___36249)){
args_arr__5751__auto__.push((arguments[i__5727__auto___36250]));

var G__36251 = (i__5727__auto___36250 + (1));
i__5727__auto___36250 = G__36251;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((4) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((4)),(0),null)):null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5752__auto__);

}
});

(cljs.core.map.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
return (function() {
var G__36254 = null;
var G__36254__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null, ));
});
var G__36254__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result));
});
var G__36254__2 = (function (result,input){
var G__33619 = result;
var G__33620 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null, input));
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__33619,G__33620) : rf.call(null, G__33619,G__33620));
});
var G__36254__3 = (function() { 
var G__36256__delegate = function (result,input,inputs){
var G__33621 = result;
var G__33622 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,input,inputs);
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__33621,G__33622) : rf.call(null, G__33621,G__33622));
};
var G__36256 = function (result,input,var_args){
var inputs = null;
if (arguments.length > 2) {
var G__36257__i = 0, G__36257__a = new Array(arguments.length -  2);
while (G__36257__i < G__36257__a.length) {G__36257__a[G__36257__i] = arguments[G__36257__i + 2]; ++G__36257__i;}
  inputs = new cljs.core.IndexedSeq(G__36257__a,0,null);
} 
return G__36256__delegate.call(this,result,input,inputs);};
G__36256.cljs$lang$maxFixedArity = 2;
G__36256.cljs$lang$applyTo = (function (arglist__36258){
var result = cljs.core.first(arglist__36258);
arglist__36258 = cljs.core.next(arglist__36258);
var input = cljs.core.first(arglist__36258);
var inputs = cljs.core.rest(arglist__36258);
return G__36256__delegate(result,input,inputs);
});
G__36256.cljs$core$IFn$_invoke$arity$variadic = G__36256__delegate;
return G__36256;
})()
;
G__36254 = function(result,input,var_args){
var inputs = var_args;
switch(arguments.length){
case 0:
return G__36254__0.call(this);
case 1:
return G__36254__1.call(this,result);
case 2:
return G__36254__2.call(this,result,input);
default:
var G__36260 = null;
if (arguments.length > 2) {
var G__36261__i = 0, G__36261__a = new Array(arguments.length -  2);
while (G__36261__i < G__36261__a.length) {G__36261__a[G__36261__i] = arguments[G__36261__i + 2]; ++G__36261__i;}
G__36260 = new cljs.core.IndexedSeq(G__36261__a,0,null);
}
return G__36254__3.cljs$core$IFn$_invoke$arity$variadic(result,input, G__36260);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36254.cljs$lang$maxFixedArity = 2;
G__36254.cljs$lang$applyTo = G__36254__3.cljs$lang$applyTo;
G__36254.cljs$core$IFn$_invoke$arity$0 = G__36254__0;
G__36254.cljs$core$IFn$_invoke$arity$1 = G__36254__1;
G__36254.cljs$core$IFn$_invoke$arity$2 = G__36254__2;
G__36254.cljs$core$IFn$_invoke$arity$variadic = G__36254__3.cljs$core$IFn$_invoke$arity$variadic;
return G__36254;
})()
});
}));

(cljs.core.map.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__5823__auto__ = cljs.core.seq(coll);
if(temp__5823__auto__){
var s = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__5593__auto___36263 = size;
var i_36264 = (0);
while(true){
if((i_36264 < n__5593__auto___36263)){
cljs.core.chunk_append(b,(function (){var G__33623 = cljs.core._nth(c,i_36264);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__33623) : f.call(null, G__33623));
})());

var G__36266 = (i_36264 + (1));
i_36264 = G__36266;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__33624 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__33624) : f.call(null, G__33624));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.map.cljs$core$IFn$_invoke$arity$3 = (function (f,c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if(((s1) && (s2))){
return cljs.core.cons((function (){var G__33625 = cljs.core.first(s1);
var G__33626 = cljs.core.first(s2);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__33625,G__33626) : f.call(null, G__33625,G__33626));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,cljs.core.rest(s1),cljs.core.rest(s2)));
} else {
return null;
}
}),null,null));
}));

(cljs.core.map.cljs$core$IFn$_invoke$arity$4 = (function (f,c1,c2,c3){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
var s3 = cljs.core.seq(c3);
if(((s1) && (((s2) && (s3))))){
return cljs.core.cons((function (){var G__33627 = cljs.core.first(s1);
var G__33628 = cljs.core.first(s2);
var G__33629 = cljs.core.first(s3);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__33627,G__33628,G__33629) : f.call(null, G__33627,G__33628,G__33629));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,cljs.core.rest(s1),cljs.core.rest(s2),cljs.core.rest(s3)));
} else {
return null;
}
}),null,null));
}));

(cljs.core.map.cljs$core$IFn$_invoke$arity$variadic = (function (f,c1,c2,c3,colls){
var step = (function cljs$core$step(cs){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cs);
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.cons(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs$core$step(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
});
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__33611_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,p1__33611_SHARP_);
}),step(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c3,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c2,c1], 0))));
}));

/** @this {Function} */
(cljs.core.map.cljs$lang$applyTo = (function (seq33613){
var G__33614 = cljs.core.first(seq33613);
var seq33613__$1 = cljs.core.next(seq33613);
var G__33615 = cljs.core.first(seq33613__$1);
var seq33613__$2 = cljs.core.next(seq33613__$1);
var G__33616 = cljs.core.first(seq33613__$2);
var seq33613__$3 = cljs.core.next(seq33613__$2);
var G__33617 = cljs.core.first(seq33613__$3);
var seq33613__$4 = cljs.core.next(seq33613__$3);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33614,G__33615,G__33616,G__33617,seq33613__$4);
}));

(cljs.core.map.cljs$lang$maxFixedArity = (4));

/**
 * Returns a lazy sequence of the first n items in coll, or all items if
 *   there are fewer than n.  Returns a stateful transducer when
 *   no collection is provided.
 */
cljs.core.take = (function cljs$core$take(var_args){
var G__33631 = arguments.length;
switch (G__33631) {
case 1:
return cljs.core.take.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.take.cljs$core$IFn$_invoke$arity$1 = (function (n){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (function (rf){
var na = cljs.core.volatile_BANG_(n);
return (function() {
var G__36285 = null;
var G__36285__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null, ));
});
var G__36285__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result));
});
var G__36285__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
var nn = na.cljs$core$IVolatile$_vreset_BANG_$arity$2(null, (na.cljs$core$IDeref$_deref$arity$1(null, ) - (1)));
var result__$1 = (((n__$1 > (0)))?(rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null, result,input)):result);
if((!((nn > (0))))){
return cljs.core.ensure_reduced(result__$1);
} else {
return result__$1;
}
});
G__36285 = function(result,input){
switch(arguments.length){
case 0:
return G__36285__0.call(this);
case 1:
return G__36285__1.call(this,result);
case 2:
return G__36285__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36285.cljs$core$IFn$_invoke$arity$0 = G__36285__0;
G__36285.cljs$core$IFn$_invoke$arity$1 = G__36285__1;
G__36285.cljs$core$IFn$_invoke$arity$2 = G__36285__2;
return G__36285;
})()
});
}));

(cljs.core.take.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (new cljs.core.LazySeq(null,(function (){
if((n > (0))){
var temp__5823__auto__ = cljs.core.seq(coll);
if(temp__5823__auto__){
var s = temp__5823__auto__;
return cljs.core.cons(cljs.core.first(s),cljs.core.take.cljs$core$IFn$_invoke$arity$2((n - (1)),cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.take.cljs$lang$maxFixedArity = 2);

/**
 * Returns a laziness-preserving sequence of all but the first n items in coll.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.drop = (function cljs$core$drop(var_args){
var G__33633 = arguments.length;
switch (G__33633) {
case 1:
return cljs.core.drop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.drop.cljs$core$IFn$_invoke$arity$1 = (function (n){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (function (rf){
var na = cljs.core.volatile_BANG_(n);
return (function() {
var G__36294 = null;
var G__36294__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null, ));
});
var G__36294__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result));
});
var G__36294__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
na.cljs$core$IVolatile$_vreset_BANG_$arity$2(null, (na.cljs$core$IDeref$_deref$arity$1(null, ) - (1)));

if((n__$1 > (0))){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null, result,input));
}
});
G__36294 = function(result,input){
switch(arguments.length){
case 0:
return G__36294__0.call(this);
case 1:
return G__36294__1.call(this,result);
case 2:
return G__36294__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36294.cljs$core$IFn$_invoke$arity$0 = G__36294__0;
G__36294.cljs$core$IFn$_invoke$arity$1 = G__36294__1;
G__36294.cljs$core$IFn$_invoke$arity$2 = G__36294__2;
return G__36294;
})()
});
}));

(cljs.core.drop.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition1$ & (262144))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IDrop$))))?true:false):false)){
var or__5002__auto__ = (((n > (0)))?coll.cljs$core$IDrop$_drop$arity$2(null, Math.ceil(n)):cljs.core.seq(coll));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.List.EMPTY;
}
} else {
var step = (function (n__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if((((n__$1 > (0))) && (s))){
var G__36310 = (n__$1 - (1));
var G__36311 = cljs.core.rest(s);
n__$1 = G__36310;
coll__$1 = G__36311;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,(function (){
return step(n,coll);
}),null,null));
}
}));

(cljs.core.drop.cljs$lang$maxFixedArity = 2);

/**
 * Return a lazy sequence of all but the last n (default 1) items in coll
 */
cljs.core.drop_last = (function cljs$core$drop_last(var_args){
var G__33636 = arguments.length;
switch (G__33636) {
case 1:
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((1),s);
}));

(cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2 = (function (n,s){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((function (x,_){
return x;
}),s,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s));
}));

(cljs.core.drop_last.cljs$lang$maxFixedArity = 2);

/**
 * Returns a seq of the last n items in coll.  Depending on the type
 *   of coll may be no better than linear time.  For vectors, see also subvec.
 */
cljs.core.take_last = (function cljs$core$take_last(n,coll){
var s = cljs.core.seq(coll);
var lead = cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll));
while(true){
if(lead){
var G__36315 = cljs.core.next(s);
var G__36316 = cljs.core.next(lead);
s = G__36315;
lead = G__36316;
continue;
} else {
return s;
}
break;
}
});
/**
 * Returns a lazy sequence of the items in coll starting from the
 *   first item for which (pred item) returns logical false.  Returns a
 *   stateful transducer when no collection is provided.
 */
cljs.core.drop_while = (function cljs$core$drop_while(var_args){
var G__33638 = arguments.length;
switch (G__33638) {
case 1:
return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (rf){
var da = cljs.core.volatile_BANG_(true);
return (function() {
var G__36323 = null;
var G__36323__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null, ));
});
var G__36323__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result));
});
var G__36323__2 = (function (result,input){
var drop_QMARK_ = cljs.core.deref(da);
if(cljs.core.truth_((function (){var and__5000__auto__ = drop_QMARK_;
if(cljs.core.truth_(and__5000__auto__)){
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null, input));
} else {
return and__5000__auto__;
}
})())){
return result;
} else {
cljs.core.vreset_BANG_(da,null);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null, result,input));
}
});
G__36323 = function(result,input){
switch(arguments.length){
case 0:
return G__36323__0.call(this);
case 1:
return G__36323__1.call(this,result);
case 2:
return G__36323__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36323.cljs$core$IFn$_invoke$arity$0 = G__36323__0;
G__36323.cljs$core$IFn$_invoke$arity$1 = G__36323__1;
G__36323.cljs$core$IFn$_invoke$arity$2 = G__36323__2;
return G__36323;
})()
});
}));

(cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
var step = (function (pred__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(cljs.core.truth_((function (){var and__5000__auto__ = s;
if(and__5000__auto__){
var G__33639 = cljs.core.first(s);
return (pred__$1.cljs$core$IFn$_invoke$arity$1 ? pred__$1.cljs$core$IFn$_invoke$arity$1(G__33639) : pred__$1.call(null, G__33639));
} else {
return and__5000__auto__;
}
})())){
var G__36329 = pred__$1;
var G__36330 = cljs.core.rest(s);
pred__$1 = G__36329;
coll__$1 = G__36330;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,(function (){
return step(pred,coll);
}),null,null));
}));

(cljs.core.drop_while.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Cycle = (function (meta,all,prev,current,_next){
this.meta = meta;
this.all = all;
this.prev = prev;
this.current = current;
this._next = _next;
this.cljs$lang$protocol_mask$partition0$ = 26083532;
this.cljs$lang$protocol_mask$partition1$ = 1;
});
(cljs.core.Cycle.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Cycle.prototype.currentval = (function (){
var self__ = this;
var coll = this;
if(self__.current){
} else {
var temp__5821__auto___36336 = cljs.core.next(self__.prev);
if(temp__5821__auto___36336){
var c_36337 = temp__5821__auto___36336;
(self__.current = c_36337);
} else {
(self__.current = self__.all);
}
}

return self__.current;
}));

(cljs.core.Cycle.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Cycle.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ISeq$_rest$arity$1(null, );
}));

(cljs.core.Cycle.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Cycle.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (!((self__.current == null)));
}));

(cljs.core.Cycle.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
var s = coll__$1.currentval();
var ret = cljs.core.first(s);
while(true){
var s__$1 = (function (){var or__5002__auto__ = cljs.core.next(s);
if(or__5002__auto__){
return or__5002__auto__;
} else {
return self__.all;
}
})();
var ret__$1 = (function (){var G__33642 = ret;
var G__33643 = cljs.core.first(s__$1);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__33642,G__33643) : f.call(null, G__33642,G__33643));
})();
if(cljs.core.reduced_QMARK_(ret__$1)){
return cljs.core.deref(ret__$1);
} else {
var G__36351 = s__$1;
var G__36352 = ret__$1;
s = G__36351;
ret = G__36352;
continue;
}
break;
}
}));

(cljs.core.Cycle.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
var s = coll__$1.currentval();
var ret = start;
while(true){
var ret__$1 = (function (){var G__33644 = ret;
var G__33645 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__33644,G__33645) : f.call(null, G__33644,G__33645));
})();
if(cljs.core.reduced_QMARK_(ret__$1)){
return cljs.core.deref(ret__$1);
} else {
var G__36357 = (function (){var or__5002__auto__ = cljs.core.next(s);
if(or__5002__auto__){
return or__5002__auto__;
} else {
return self__.all;
}
})();
var G__36358 = ret__$1;
s = G__36357;
ret = G__36358;
continue;
}
break;
}
}));

(cljs.core.Cycle.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(coll__$1.currentval());
}));

(cljs.core.Cycle.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__._next == null)){
(self__._next = (new cljs.core.Cycle(null,self__.all,coll__$1.currentval(),null,null)));
} else {
}

return self__._next;
}));

(cljs.core.Cycle.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.Cycle.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Cycle(new_meta,self__.all,self__.prev,self__.current,self__._next));
}
}));

(cljs.core.Cycle.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.Cycle.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"all","all",-1762306027,null),new cljs.core.Symbol(null,"prev","prev",43462301,null),cljs.core.with_meta(new cljs.core.Symbol(null,"current","current",552492924,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"_next","_next",101877036,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Cycle.cljs$lang$type = true);

(cljs.core.Cycle.cljs$lang$ctorStr = "cljs.core/Cycle");

(cljs.core.Cycle.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/Cycle");
}));

/**
 * Positional factory function for cljs.core/Cycle.
 */
cljs.core.__GT_Cycle = (function cljs$core$__GT_Cycle(meta,all,prev,current,_next){
return (new cljs.core.Cycle(meta,all,prev,current,_next));
});

/**
 * Returns a lazy (infinite!) sequence of repetitions of the items in coll.
 */
cljs.core.cycle = (function cljs$core$cycle(coll){
var temp__5821__auto__ = cljs.core.seq(coll);
if(temp__5821__auto__){
var vals = temp__5821__auto__;
return (new cljs.core.Cycle(null,vals,null,vals,null));
} else {
return cljs.core.List.EMPTY;
}
});
/**
 * Returns a vector of [(take n coll) (drop n coll)]
 */
cljs.core.split_at = (function cljs$core$split_at(n,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,coll),cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll)], null);
});

/**
* @constructor
 * @implements {cljs.core.IDrop}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Repeat = (function (meta,count,val,next,__hash){
this.meta = meta;
this.count = count;
this.val = val;
this.next = next;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 262145;
});
(cljs.core.Repeat.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Repeat.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
}));

(cljs.core.Repeat.prototype.indexOf = (function() {
var G__36363 = null;
var G__36363__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__36363__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__36363 = function(x,start){
switch(arguments.length){
case 1:
return G__36363__1.call(this,x);
case 2:
return G__36363__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36363.cljs$core$IFn$_invoke$arity$1 = G__36363__1;
G__36363.cljs$core$IFn$_invoke$arity$2 = G__36363__2;
return G__36363;
})()
);

(cljs.core.Repeat.prototype.lastIndexOf = (function() {
var G__36364 = null;
var G__36364__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,self__.count);
});
var G__36364__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__36364 = function(x,start){
switch(arguments.length){
case 1:
return G__36364__1.call(this,x);
case 2:
return G__36364__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36364.cljs$core$IFn$_invoke$arity$1 = G__36364__1;
G__36364.cljs$core$IFn$_invoke$arity$2 = G__36364__2;
return G__36364;
})()
);

(cljs.core.Repeat.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Repeat.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.next == null)){
if((self__.count > (1))){
(self__.next = (new cljs.core.Repeat(null,(self__.count - (1)),self__.val,null,null)));

return self__.next;
} else {
if(((-1) === self__.count)){
return coll__$1;
} else {
return null;
}
}
} else {
return self__.next;
}
}));

(cljs.core.Repeat.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.Repeat.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.Repeat.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Repeat.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return false;
}));

(cljs.core.Repeat.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
if((self__.count === (-1))){
var ret = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(self__.val,self__.val) : f.call(null, self__.val,self__.val));
while(true){
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.deref(ret);
} else {
var G__36368 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,self__.val) : f.call(null, ret,self__.val));
ret = G__36368;
continue;
}
break;
}
} else {
var i = (1);
var ret = self__.val;
while(true){
if((i < self__.count)){
var ret__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,self__.val) : f.call(null, ret,self__.val));
if(cljs.core.reduced_QMARK_(ret__$1)){
return cljs.core.deref(ret__$1);
} else {
var G__36369 = (i + (1));
var G__36370 = ret__$1;
i = G__36369;
ret = G__36370;
continue;
}
} else {
return ret;
}
break;
}
}
}));

(cljs.core.Repeat.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
if((self__.count === (-1))){
var ret = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(start,self__.val) : f.call(null, start,self__.val));
while(true){
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.deref(ret);
} else {
var G__36372 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,self__.val) : f.call(null, ret,self__.val));
ret = G__36372;
continue;
}
break;
}
} else {
var i = (0);
var ret = start;
while(true){
if((i < self__.count)){
var ret__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,self__.val) : f.call(null, ret,self__.val));
if(cljs.core.reduced_QMARK_(ret__$1)){
return cljs.core.deref(ret__$1);
} else {
var G__36375 = (i + (1));
var G__36376 = ret__$1;
i = G__36375;
ret = G__36376;
continue;
}
} else {
return ret;
}
break;
}
}
}));

(cljs.core.Repeat.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.val;
}));

(cljs.core.Repeat.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.next == null)){
if((self__.count > (1))){
(self__.next = (new cljs.core.Repeat(null,(self__.count - (1)),self__.val,null,null)));

return self__.next;
} else {
if(((-1) === self__.count)){
return coll__$1;
} else {
return cljs.core.List.EMPTY;
}
}
} else {
return self__.next;
}
}));

(cljs.core.Repeat.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.Repeat.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Repeat(new_meta,self__.count,self__.val,self__.next,null));
}
}));

(cljs.core.Repeat.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.Repeat.prototype.cljs$core$IDrop$_drop$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if((self__.count === (-1))){
return coll__$1;
} else {
var dropped_count = (self__.count - n);
if((dropped_count > (0))){
return (new cljs.core.Repeat(null,dropped_count,self__.val,null,null));
} else {
return null;
}
}
}));

(cljs.core.Repeat.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"val","val",1769233139,null),cljs.core.with_meta(new cljs.core.Symbol(null,"next","next",1522830042,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Repeat.cljs$lang$type = true);

(cljs.core.Repeat.cljs$lang$ctorStr = "cljs.core/Repeat");

(cljs.core.Repeat.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/Repeat");
}));

/**
 * Positional factory function for cljs.core/Repeat.
 */
cljs.core.__GT_Repeat = (function cljs$core$__GT_Repeat(meta,count,val,next,__hash){
return (new cljs.core.Repeat(meta,count,val,next,__hash));
});

/**
 * Returns a lazy (infinite!, or length n if supplied) sequence of xs.
 */
cljs.core.repeat = (function cljs$core$repeat(var_args){
var G__33647 = arguments.length;
switch (G__33647) {
case 1:
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.Repeat(null,(-1),x,null,null));
}));

(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2 = (function (n,x){
if((n > (0))){
return (new cljs.core.Repeat(null,n,x,null,null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.repeat.cljs$lang$maxFixedArity = 2);

/**
 * DEPRECATED: Use 'repeat' instead.
 *   Returns a lazy seq of n xs.
 */
cljs.core.replicate = (function cljs$core$replicate(n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
});
/**
 * Takes a function of no args, presumably with side effects, and
 *   returns an infinite (or length n if supplied) lazy sequence of calls
 *   to it
 */
cljs.core.repeatedly = (function cljs$core$repeatedly(var_args){
var G__33649 = arguments.length;
switch (G__33649) {
case 1:
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null, )),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
}),null,null));
}));

(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2 = (function (n,f){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
}));

(cljs.core.repeatedly.cljs$lang$maxFixedArity = 2);

cljs.core.UNREALIZED_SEED = ({});

/**
* @constructor
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Iterate = (function (meta,f,prev_seed,seed,next){
this.meta = meta;
this.f = f;
this.prev_seed = prev_seed;
this.seed = seed;
this.next = next;
this.cljs$lang$protocol_mask$partition0$ = 26083532;
this.cljs$lang$protocol_mask$partition1$ = 1;
});
(cljs.core.Iterate.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Iterate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Iterate.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ISeq$_rest$arity$1(null, );
}));

(cljs.core.Iterate.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Iterate.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (!((self__.seed === cljs.core.UNREALIZED_SEED)));
}));

(cljs.core.Iterate.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,rf){
var self__ = this;
var coll__$1 = this;
var first = coll__$1.cljs$core$ISeq$_first$arity$1(null, );
var v = (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(first) : self__.f.call(null, first));
var ret = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(first,v) : rf.call(null, first,v));
var v__$1 = v;
while(true){
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.deref(ret);
} else {
var v__$2 = (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(v__$1) : self__.f.call(null, v__$1));
var G__36410 = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(ret,v__$2) : rf.call(null, ret,v__$2));
var G__36411 = v__$2;
ret = G__36410;
v__$1 = G__36411;
continue;
}
break;
}
}));

(cljs.core.Iterate.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,rf,start){
var self__ = this;
var coll__$1 = this;
var v = coll__$1.cljs$core$ISeq$_first$arity$1(null, );
var ret = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(start,v) : rf.call(null, start,v));
var v__$1 = v;
while(true){
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.deref(ret);
} else {
var v__$2 = (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(v__$1) : self__.f.call(null, v__$1));
var G__36426 = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(ret,v__$2) : rf.call(null, ret,v__$2));
var G__36427 = v__$2;
ret = G__36426;
v__$1 = G__36427;
continue;
}
break;
}
}));

(cljs.core.Iterate.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core.UNREALIZED_SEED === self__.seed)){
(self__.seed = (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(self__.prev_seed) : self__.f.call(null, self__.prev_seed)));
} else {
}

return self__.seed;
}));

(cljs.core.Iterate.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.next == null)){
(self__.next = (new cljs.core.Iterate(null,self__.f,coll__$1.cljs$core$ISeq$_first$arity$1(null, ),cljs.core.UNREALIZED_SEED,null)));
} else {
}

return self__.next;
}));

(cljs.core.Iterate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.Iterate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Iterate(new_meta,self__.f,self__.prev_seed,self__.seed,self__.next));
}
}));

(cljs.core.Iterate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.Iterate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"prev-seed","prev-seed",2126381367,null),cljs.core.with_meta(new cljs.core.Symbol(null,"seed","seed",1709144854,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"next","next",1522830042,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Iterate.cljs$lang$type = true);

(cljs.core.Iterate.cljs$lang$ctorStr = "cljs.core/Iterate");

(cljs.core.Iterate.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/Iterate");
}));

/**
 * Positional factory function for cljs.core/Iterate.
 */
cljs.core.__GT_Iterate = (function cljs$core$__GT_Iterate(meta,f,prev_seed,seed,next){
return (new cljs.core.Iterate(meta,f,prev_seed,seed,next));
});

/**
 * Returns a lazy sequence of x, (f x), (f (f x)) etc. f must be free of side-effects
 */
cljs.core.iterate = (function cljs$core$iterate(f,x){
return (new cljs.core.Iterate(null,f,null,x,null));
});
/**
 * Returns a lazy seq of the first item in each coll, then the second etc.
 */
cljs.core.interleave = (function cljs$core$interleave(var_args){
var G__33654 = arguments.length;
switch (G__33654) {
case 0:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___36472 = arguments.length;
var i__5727__auto___36473 = (0);
while(true){
if((i__5727__auto___36473 < len__5726__auto___36472)){
args_arr__5751__auto__.push((arguments[i__5727__auto___36473]));

var G__36474 = (i__5727__auto___36473 + (1));
i__5727__auto___36473 = G__36474;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((2) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((2)),(0),null)):null);
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5752__auto__);

}
});

(cljs.core.interleave.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.List.EMPTY;
}));

(cljs.core.interleave.cljs$core$IFn$_invoke$arity$1 = (function (c1){
return (new cljs.core.LazySeq(null,(function (){
return c1;
}),null,null));
}));

(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2 = (function (c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if(((s1) && (s2))){
return cljs.core.cons(cljs.core.first(s1),cljs.core.cons(cljs.core.first(s2),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1),cljs.core.rest(s2))));
} else {
return null;
}
}),null,null));
}));

(cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic = (function (c1,c2,colls){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c2,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c1], 0)));
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.interleave,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
}));

/** @this {Function} */
(cljs.core.interleave.cljs$lang$applyTo = (function (seq33651){
var G__33652 = cljs.core.first(seq33651);
var seq33651__$1 = cljs.core.next(seq33651);
var G__33653 = cljs.core.first(seq33651__$1);
var seq33651__$2 = cljs.core.next(seq33651__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33652,G__33653,seq33651__$2);
}));

(cljs.core.interleave.cljs$lang$maxFixedArity = (2));

/**
 * Returns a lazy seq of the elements of coll separated by sep.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.interpose = (function cljs$core$interpose(var_args){
var G__33656 = arguments.length;
switch (G__33656) {
case 1:
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.interpose.cljs$core$IFn$_invoke$arity$1 = (function (sep){
return (function (rf){
var started = cljs.core.volatile_BANG_(false);
return (function() {
var G__36485 = null;
var G__36485__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null, ));
});
var G__36485__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result));
});
var G__36485__2 = (function (result,input){
if(cljs.core.truth_(cljs.core.deref(started))){
var sepr = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,sep) : rf.call(null, result,sep));
if(cljs.core.reduced_QMARK_(sepr)){
return sepr;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(sepr,input) : rf.call(null, sepr,input));
}
} else {
cljs.core.vreset_BANG_(started,true);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null, result,input));
}
});
G__36485 = function(result,input){
switch(arguments.length){
case 0:
return G__36485__0.call(this);
case 1:
return G__36485__1.call(this,result);
case 2:
return G__36485__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36485.cljs$core$IFn$_invoke$arity$0 = G__36485__0;
G__36485.cljs$core$IFn$_invoke$arity$1 = G__36485__1;
G__36485.cljs$core$IFn$_invoke$arity$2 = G__36485__2;
return G__36485;
})()
});
}));

(cljs.core.interpose.cljs$core$IFn$_invoke$arity$2 = (function (sep,coll){
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(sep),coll));
}));

(cljs.core.interpose.cljs$lang$maxFixedArity = 2);

/**
 * Take a collection of collections, and return a lazy seq
 *   of items from the inner collection
 */
cljs.core.flatten1 = (function cljs$core$flatten1(colls){
var cat = (function cljs$core$flatten1_$_cat(coll,colls__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__5821__auto__ = cljs.core.seq(coll);
if(temp__5821__auto__){
var coll__$1 = temp__5821__auto__;
return cljs.core.cons(cljs.core.first(coll__$1),cljs$core$flatten1_$_cat(cljs.core.rest(coll__$1),colls__$1));
} else {
if(cljs.core.seq(colls__$1)){
return cljs$core$flatten1_$_cat(cljs.core.first(colls__$1),cljs.core.rest(colls__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(null,colls);
});
/**
 * Returns the result of applying concat to the result of applying map
 *   to f and colls.  Thus function f should return a collection. Returns
 *   a transducer when no collections are provided
 */
cljs.core.mapcat = (function cljs$core$mapcat(var_args){
var G__33660 = arguments.length;
switch (G__33660) {
case 1:
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___36492 = arguments.length;
var i__5727__auto___36493 = (0);
while(true){
if((i__5727__auto___36493 < len__5726__auto___36492)){
args_arr__5751__auto__.push((arguments[i__5727__auto___36493]));

var G__36494 = (i__5727__auto___36493 + (1));
i__5727__auto___36493 = G__36494;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((1) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((1)),(0),null)):null);
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5752__auto__);

}
});

(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(f),cljs.core.cat);
}));

(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic = (function (f,colls){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.map,f,colls));
}));

/** @this {Function} */
(cljs.core.mapcat.cljs$lang$applyTo = (function (seq33658){
var G__33659 = cljs.core.first(seq33658);
var seq33658__$1 = cljs.core.next(seq33658);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33659,seq33658__$1);
}));

(cljs.core.mapcat.cljs$lang$maxFixedArity = (1));

/**
 * Returns a lazy sequence of the items in coll for which
 *   (pred item) returns logical true. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.filter = (function cljs$core$filter(var_args){
var G__33662 = arguments.length;
switch (G__33662) {
case 1:
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.filter.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (rf){
return (function() {
var G__36497 = null;
var G__36497__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null, ));
});
var G__36497__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result));
});
var G__36497__2 = (function (result,input){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null, input)))){
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null, result,input));
} else {
return result;
}
});
G__36497 = function(result,input){
switch(arguments.length){
case 0:
return G__36497__0.call(this);
case 1:
return G__36497__1.call(this,result);
case 2:
return G__36497__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36497.cljs$core$IFn$_invoke$arity$0 = G__36497__0;
G__36497.cljs$core$IFn$_invoke$arity$1 = G__36497__1;
G__36497.cljs$core$IFn$_invoke$arity$2 = G__36497__2;
return G__36497;
})()
});
}));

(cljs.core.filter.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__5823__auto__ = cljs.core.seq(coll);
if(temp__5823__auto__){
var s = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__5593__auto___36498 = size;
var i_36499 = (0);
while(true){
if((i_36499 < n__5593__auto___36498)){
if(cljs.core.truth_((function (){var G__33663 = cljs.core._nth(c,i_36499);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__33663) : pred.call(null, G__33663));
})())){
cljs.core.chunk_append(b,cljs.core._nth(c,i_36499));
} else {
}

var G__36501 = (i_36499 + (1));
i_36499 = G__36501;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.chunk_rest(s)));
} else {
var f = cljs.core.first(s);
var r = cljs.core.rest(s);
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(f) : pred.call(null, f)))){
return cljs.core.cons(f,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,r));
} else {
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,r);
}
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.filter.cljs$lang$maxFixedArity = 2);

/**
 * Returns a lazy sequence of the items in coll for which
 *   (pred item) returns logical false. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.remove = (function cljs$core$remove(var_args){
var G__33665 = arguments.length;
switch (G__33665) {
case 1:
return cljs.core.remove.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.remove.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(cljs.core.complement(pred));
}));

(cljs.core.remove.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(pred),coll);
}));

(cljs.core.remove.cljs$lang$maxFixedArity = 2);

/**
 * Returns a lazy sequence of the nodes in a tree, via a depth-first walk.
 *   branch? must be a fn of one arg that returns true if passed a node
 *   that can have children (but may not).  children must be a fn of one
 *   arg that returns a sequence of the children. Will only be called on
 *   nodes for which branch? returns true. Root is the root node of the
 *   tree.
 */
cljs.core.tree_seq = (function cljs$core$tree_seq(branch_QMARK_,children,root){
var walk = (function cljs$core$tree_seq_$_walk(node){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons(node,(cljs.core.truth_((branch_QMARK_.cljs$core$IFn$_invoke$arity$1 ? branch_QMARK_.cljs$core$IFn$_invoke$arity$1(node) : branch_QMARK_.call(null, node)))?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs$core$tree_seq_$_walk,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(children.cljs$core$IFn$_invoke$arity$1 ? children.cljs$core$IFn$_invoke$arity$1(node) : children.call(null, node))], 0)):null));
}),null,null));
});
return walk(root);
});
/**
 * Takes any nested combination of sequential things (lists, vectors,
 *   etc.) and returns their contents as a single, flat sequence.
 *   (flatten nil) returns nil.
 */
cljs.core.flatten = (function cljs$core$flatten(x){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__33666_SHARP_){
return (!(cljs.core.sequential_QMARK_(p1__33666_SHARP_)));
}),cljs.core.rest(cljs.core.tree_seq(cljs.core.sequential_QMARK_,cljs.core.seq,x)));
});
/**
 * Returns a new coll consisting of to-coll with all of the items of
 *   from-coll conjoined. A transducer may be supplied.
 */
cljs.core.into = (function cljs$core$into(var_args){
var G__33668 = arguments.length;
switch (G__33668) {
case 0:
return cljs.core.into.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.into.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.into.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.into.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.into.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentVector.EMPTY;
}));

(cljs.core.into.cljs$core$IFn$_invoke$arity$1 = (function (to){
return to;
}));

(cljs.core.into.cljs$core$IFn$_invoke$arity$2 = (function (to,from){
if((!((to == null)))){
if((((!((to == null))))?(((((to.cljs$lang$protocol_mask$partition1$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === to.cljs$core$IEditableCollection$))))?true:false):false)){
return cljs.core._with_meta(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,to,from);
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,to,from);
}
}));

(cljs.core.into.cljs$core$IFn$_invoke$arity$3 = (function (to,xform,from){
if((((!((to == null))))?(((((to.cljs$lang$protocol_mask$partition1$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === to.cljs$core$IEditableCollection$))))?true:false):false)){
var tm = cljs.core.meta(to);
var rf = (function() {
var G__36530 = null;
var G__36530__1 = (function (coll){
return cljs.core._with_meta(cljs.core.persistent_BANG_(coll),tm);
});
var G__36530__2 = (function (coll,v){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(coll,v);
});
G__36530 = function(coll,v){
switch(arguments.length){
case 1:
return G__36530__1.call(this,coll);
case 2:
return G__36530__2.call(this,coll,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36530.cljs$core$IFn$_invoke$arity$1 = G__36530__1;
G__36530.cljs$core$IFn$_invoke$arity$2 = G__36530__2;
return G__36530;
})()
;
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,rf,cljs.core.transient$(to),from);
} else {
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj,to,from);
}
}));

(cljs.core.into.cljs$lang$maxFixedArity = 3);

/**
 * Returns a vector consisting of the result of applying f to the
 *   set of first items of each coll, followed by applying f to the set
 *   of second items in each coll, until any one of the colls is
 *   exhausted.  Any remaining items in other colls are ignored. Function
 *   f should accept number-of-colls arguments.
 */
cljs.core.mapv = (function cljs$core$mapv(var_args){
var G__33677 = arguments.length;
switch (G__33677) {
case 2:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___36543 = arguments.length;
var i__5727__auto___36544 = (0);
while(true){
if((i__5727__auto___36544 < len__5726__auto___36543)){
args_arr__5751__auto__.push((arguments[i__5727__auto___36544]));

var G__36546 = (i__5727__auto___36544 + (1));
i__5727__auto___36544 = G__36546;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((4) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((4)),(0),null)):null);
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5752__auto__);

}
});

(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,o){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(o) : f.call(null, o)));
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
}));

(cljs.core.mapv.cljs$core$IFn$_invoke$arity$3 = (function (f,c1,c2){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,c1,c2));
}));

(cljs.core.mapv.cljs$core$IFn$_invoke$arity$4 = (function (f,c1,c2,c3){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,c1,c2,c3));
}));

(cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic = (function (f,c1,c2,c3,colls){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.map,f,c1,c2,c3,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([colls], 0)));
}));

/** @this {Function} */
(cljs.core.mapv.cljs$lang$applyTo = (function (seq33672){
var G__33673 = cljs.core.first(seq33672);
var seq33672__$1 = cljs.core.next(seq33672);
var G__33674 = cljs.core.first(seq33672__$1);
var seq33672__$2 = cljs.core.next(seq33672__$1);
var G__33675 = cljs.core.first(seq33672__$2);
var seq33672__$3 = cljs.core.next(seq33672__$2);
var G__33676 = cljs.core.first(seq33672__$3);
var seq33672__$4 = cljs.core.next(seq33672__$3);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33673,G__33674,G__33675,G__33676,seq33672__$4);
}));

(cljs.core.mapv.cljs$lang$maxFixedArity = (4));

/**
 * Returns a vector of the items in coll for which
 *   (pred item) returns logical true. pred must be free of side-effects.
 */
cljs.core.filterv = (function cljs$core$filterv(pred,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,o){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(o) : pred.call(null, o)))){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,o);
} else {
return v;
}
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});
/**
 * Returns a lazy sequence of lists of n items each, at offsets step
 *   apart. If step is not supplied, defaults to n, i.e. the partitions
 *   do not overlap. If a pad collection is supplied, use its elements as
 *   necessary to complete last partition up to n items. In case there are
 *   not enough padding elements, return a partition with less than n items.
 */
cljs.core.partition = (function cljs$core$partition(var_args){
var G__33679 = arguments.length;
switch (G__33679) {
case 2:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n,n,coll);
}));

(cljs.core.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__5823__auto__ = cljs.core.seq(coll);
if(temp__5823__auto__){
var s = temp__5823__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.partition.cljs$core$IFn$_invoke$arity$4 = (function (n,step,pad,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__5823__auto__ = cljs.core.seq(coll);
if(temp__5823__auto__){
var s = temp__5823__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs.core.partition.cljs$core$IFn$_invoke$arity$4(n,step,pad,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return (new cljs.core.List(null,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(p,pad)),null,(1),null));
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.partition.cljs$lang$maxFixedArity = 4);

/**
 * Returns the value in a nested associative structure,
 *   where ks is a sequence of keys. Returns nil if the key is not present,
 *   or the not-found value if supplied.
 */
cljs.core.get_in = (function cljs$core$get_in(var_args){
var G__33681 = arguments.length;
switch (G__33681) {
case 2:
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2 = (function (m,ks){
var m__$1 = m;
var ks__$1 = cljs.core.seq(ks);
while(true){
if((ks__$1 == null)){
return m__$1;
} else {
var G__36575 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m__$1,cljs.core.first(ks__$1));
var G__36576 = cljs.core.next(ks__$1);
m__$1 = G__36575;
ks__$1 = G__36576;
continue;
}
break;
}
}));

(cljs.core.get_in.cljs$core$IFn$_invoke$arity$3 = (function (m,ks,not_found){
var sentinel = cljs.core.lookup_sentinel;
var m__$1 = m;
var ks__$1 = cljs.core.seq(ks);
while(true){
if((!((ks__$1 == null)))){
var m__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1,cljs.core.first(ks__$1),sentinel);
if((sentinel === m__$2)){
return not_found;
} else {
var G__36577 = sentinel;
var G__36578 = m__$2;
var G__36579 = cljs.core.next(ks__$1);
sentinel = G__36577;
m__$1 = G__36578;
ks__$1 = G__36579;
continue;
}
} else {
return m__$1;
}
break;
}
}));

(cljs.core.get_in.cljs$lang$maxFixedArity = 3);

/**
 * Associates a value in a nested associative structure, where ks is a
 *   sequence of keys and v is the new value and returns a new nested structure.
 *   If any levels do not exist, hash-maps will be created.
 */
cljs.core.assoc_in = (function cljs$core$assoc_in(m,p__33682,v){
var vec__33683 = p__33682;
var seq__33684 = cljs.core.seq(vec__33683);
var first__33685 = cljs.core.first(seq__33684);
var seq__33684__$1 = cljs.core.next(seq__33684);
var k = first__33685;
var ks = seq__33684__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__33686 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__33687 = ks;
var G__33688 = v;
return (cljs.core.assoc_in.cljs$core$IFn$_invoke$arity$3 ? cljs.core.assoc_in.cljs$core$IFn$_invoke$arity$3(G__33686,G__33687,G__33688) : cljs.core.assoc_in.call(null, G__33686,G__33687,G__33688));
})());
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
/**
 * 'Updates' a value in a nested associative structure, where ks is a
 *   sequence of keys and f is a function that will take the old value
 *   and any supplied args and return the new value, and returns a new
 *   nested structure.  If any levels do not exist, hash-maps will be
 *   created.
 */
cljs.core.update_in = (function cljs$core$update_in(var_args){
var G__33697 = arguments.length;
switch (G__33697) {
case 3:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___36581 = arguments.length;
var i__5727__auto___36583 = (0);
while(true){
if((i__5727__auto___36583 < len__5726__auto___36581)){
args_arr__5751__auto__.push((arguments[i__5727__auto___36583]));

var G__36584 = (i__5727__auto___36583 + (1));
i__5727__auto___36583 = G__36584;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((6) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((6)),(0),null)):null);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__5752__auto__);

}
});

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$3 = (function (m,p__33698,f){
var vec__33699 = p__33698;
var seq__33700 = cljs.core.seq(vec__33699);
var first__33701 = cljs.core.first(seq__33700);
var seq__33700__$1 = cljs.core.next(seq__33700);
var k = first__33701;
var ks = seq__33700__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__33702 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__33702) : f.call(null, G__33702));
})());
}
}));

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$4 = (function (m,p__33703,f,a){
var vec__33704 = p__33703;
var seq__33705 = cljs.core.seq(vec__33704);
var first__33706 = cljs.core.first(seq__33705);
var seq__33705__$1 = cljs.core.next(seq__33705);
var k = first__33706;
var ks = seq__33705__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__33707 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__33708 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__33707,G__33708) : f.call(null, G__33707,G__33708));
})());
}
}));

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$5 = (function (m,p__33709,f,a,b){
var vec__33710 = p__33709;
var seq__33711 = cljs.core.seq(vec__33710);
var first__33712 = cljs.core.first(seq__33711);
var seq__33711__$1 = cljs.core.next(seq__33711);
var k = first__33712;
var ks = seq__33711__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__33713 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__33714 = a;
var G__33715 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__33713,G__33714,G__33715) : f.call(null, G__33713,G__33714,G__33715));
})());
}
}));

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$6 = (function (m,p__33716,f,a,b,c){
var vec__33717 = p__33716;
var seq__33718 = cljs.core.seq(vec__33717);
var first__33719 = cljs.core.first(seq__33718);
var seq__33718__$1 = cljs.core.next(seq__33718);
var k = first__33719;
var ks = seq__33718__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b,c));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__33720 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__33721 = a;
var G__33722 = b;
var G__33723 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__33720,G__33721,G__33722,G__33723) : f.call(null, G__33720,G__33721,G__33722,G__33723));
})());
}
}));

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic = (function (m,p__33724,f,a,b,c,args){
var vec__33725 = p__33724;
var seq__33726 = cljs.core.seq(vec__33725);
var first__33727 = cljs.core.first(seq__33726);
var seq__33726__$1 = cljs.core.next(seq__33726);
var k = first__33727;
var ks = seq__33726__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.update_in,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([b,c,args], 0)));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),a,b,c,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0)));
}
}));

/** @this {Function} */
(cljs.core.update_in.cljs$lang$applyTo = (function (seq33690){
var G__33691 = cljs.core.first(seq33690);
var seq33690__$1 = cljs.core.next(seq33690);
var G__33692 = cljs.core.first(seq33690__$1);
var seq33690__$2 = cljs.core.next(seq33690__$1);
var G__33693 = cljs.core.first(seq33690__$2);
var seq33690__$3 = cljs.core.next(seq33690__$2);
var G__33694 = cljs.core.first(seq33690__$3);
var seq33690__$4 = cljs.core.next(seq33690__$3);
var G__33695 = cljs.core.first(seq33690__$4);
var seq33690__$5 = cljs.core.next(seq33690__$4);
var G__33696 = cljs.core.first(seq33690__$5);
var seq33690__$6 = cljs.core.next(seq33690__$5);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33691,G__33692,G__33693,G__33694,G__33695,G__33696,seq33690__$6);
}));

(cljs.core.update_in.cljs$lang$maxFixedArity = (6));

/**
 * 'Updates' a value in an associative structure, where k is a
 *   key and f is a function that will take the old value
 *   and any supplied args and return the new value, and returns a new
 *   structure.  If the key does not exist, nil is passed as the old value.
 */
cljs.core.update = (function cljs$core$update(var_args){
var G__33736 = arguments.length;
switch (G__33736) {
case 3:
return cljs.core.update.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.update.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.update.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.update.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___36591 = arguments.length;
var i__5727__auto___36592 = (0);
while(true){
if((i__5727__auto___36592 < len__5726__auto___36591)){
args_arr__5751__auto__.push((arguments[i__5727__auto___36592]));

var G__36594 = (i__5727__auto___36592 + (1));
i__5727__auto___36592 = G__36594;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((6) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((6)),(0),null)):null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__5752__auto__);

}
});

(cljs.core.update.cljs$core$IFn$_invoke$arity$3 = (function (m,k,f){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__33737 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__33737) : f.call(null, G__33737));
})());
}));

(cljs.core.update.cljs$core$IFn$_invoke$arity$4 = (function (m,k,f,x){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__33738 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__33739 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__33738,G__33739) : f.call(null, G__33738,G__33739));
})());
}));

(cljs.core.update.cljs$core$IFn$_invoke$arity$5 = (function (m,k,f,x,y){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__33740 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__33741 = x;
var G__33742 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__33740,G__33741,G__33742) : f.call(null, G__33740,G__33741,G__33742));
})());
}));

(cljs.core.update.cljs$core$IFn$_invoke$arity$6 = (function (m,k,f,x,y,z){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__33743 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__33744 = x;
var G__33745 = y;
var G__33746 = z;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__33743,G__33744,G__33745,G__33746) : f.call(null, G__33743,G__33744,G__33745,G__33746));
})());
}));

(cljs.core.update.cljs$core$IFn$_invoke$arity$variadic = (function (m,k,f,x,y,z,more){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),x,y,z,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([more], 0)));
}));

/** @this {Function} */
(cljs.core.update.cljs$lang$applyTo = (function (seq33729){
var G__33730 = cljs.core.first(seq33729);
var seq33729__$1 = cljs.core.next(seq33729);
var G__33731 = cljs.core.first(seq33729__$1);
var seq33729__$2 = cljs.core.next(seq33729__$1);
var G__33732 = cljs.core.first(seq33729__$2);
var seq33729__$3 = cljs.core.next(seq33729__$2);
var G__33733 = cljs.core.first(seq33729__$3);
var seq33729__$4 = cljs.core.next(seq33729__$3);
var G__33734 = cljs.core.first(seq33729__$4);
var seq33729__$5 = cljs.core.next(seq33729__$4);
var G__33735 = cljs.core.first(seq33729__$5);
var seq33729__$6 = cljs.core.next(seq33729__$5);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33730,G__33731,G__33732,G__33733,G__33734,G__33735,seq33729__$6);
}));

(cljs.core.update.cljs$lang$maxFixedArity = (6));


/**
* @constructor
*/
cljs.core.VectorNode = (function (edit,arr){
this.edit = edit;
this.arr = arr;
});

(cljs.core.VectorNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),new cljs.core.Symbol(null,"arr","arr",2115492975,null)], null);
}));

(cljs.core.VectorNode.cljs$lang$type = true);

(cljs.core.VectorNode.cljs$lang$ctorStr = "cljs.core/VectorNode");

(cljs.core.VectorNode.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/VectorNode");
}));

/**
 * Positional factory function for cljs.core/VectorNode.
 */
cljs.core.__GT_VectorNode = (function cljs$core$__GT_VectorNode(edit,arr){
return (new cljs.core.VectorNode(edit,arr));
});

cljs.core.pv_fresh_node = (function cljs$core$pv_fresh_node(edit){
return (new cljs.core.VectorNode(edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
});
cljs.core.pv_aget = (function cljs$core$pv_aget(node,idx){
return (node.arr[idx]);
});
cljs.core.pv_aset = (function cljs$core$pv_aset(node,idx,val){
return (node.arr[idx] = val);
});
cljs.core.pv_clone_node = (function cljs$core$pv_clone_node(node){
return (new cljs.core.VectorNode(node.edit,cljs.core.aclone(node.arr)));
});
cljs.core.tail_off = (function cljs$core$tail_off(pv){
var cnt = pv.cnt;
if((cnt < (32))){
return (0);
} else {
return (((cnt - (1)) >>> (5)) << (5));
}
});
cljs.core.new_path = (function cljs$core$new_path(edit,level,node){
var ll = level;
var ret = node;
while(true){
if((ll === (0))){
return ret;
} else {
var embed = ret;
var r = cljs.core.pv_fresh_node(edit);
var _ = cljs.core.pv_aset(r,(0),embed);
var G__36607 = (ll - (5));
var G__36608 = r;
ll = G__36607;
ret = G__36608;
continue;
}
break;
}
});
cljs.core.push_tail = (function cljs$core$push_tail(pv,level,parent,tailnode){
var ret = cljs.core.pv_clone_node(parent);
var subidx = (((pv.cnt - (1)) >>> level) & (31));
if(((5) === level)){
cljs.core.pv_aset(ret,subidx,tailnode);

return ret;
} else {
var child = cljs.core.pv_aget(parent,subidx);
if((!((child == null)))){
var node_to_insert = (function (){var G__33747 = pv;
var G__33748 = (level - (5));
var G__33749 = child;
var G__33750 = tailnode;
return (cljs.core.push_tail.cljs$core$IFn$_invoke$arity$4 ? cljs.core.push_tail.cljs$core$IFn$_invoke$arity$4(G__33747,G__33748,G__33749,G__33750) : cljs.core.push_tail.call(null, G__33747,G__33748,G__33749,G__33750));
})();
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
} else {
var node_to_insert = cljs.core.new_path(null,(level - (5)),tailnode);
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
}
}
});
cljs.core.vector_index_out_of_bounds = (function cljs$core$vector_index_out_of_bounds(i,cnt){
throw (new Error(["No item ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(i)," in vector of length ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cnt)].join('')));
});
cljs.core.first_array_for_longvec = (function cljs$core$first_array_for_longvec(pv){
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__36618 = cljs.core.pv_aget(node,(0));
var G__36619 = (level - (5));
node = G__36618;
level = G__36619;
continue;
} else {
return node.arr;
}
break;
}
});
cljs.core.unchecked_array_for = (function cljs$core$unchecked_array_for(pv,i){
if((i >= cljs.core.tail_off(pv))){
return pv.tail;
} else {
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__36621 = cljs.core.pv_aget(node,((i >>> level) & (31)));
var G__36622 = (level - (5));
node = G__36621;
level = G__36622;
continue;
} else {
return node.arr;
}
break;
}
}
});
cljs.core.array_for = (function cljs$core$array_for(pv,i){
if(((((0) <= i)) && ((i < pv.cnt)))){
return cljs.core.unchecked_array_for(pv,i);
} else {
return cljs.core.vector_index_out_of_bounds(i,pv.cnt);
}
});
cljs.core.do_assoc = (function cljs$core$do_assoc(pv,level,node,i,val){
var ret = cljs.core.pv_clone_node(node);
if((level === (0))){
cljs.core.pv_aset(ret,(i & (31)),val);

return ret;
} else {
var subidx = ((i >>> level) & (31));
cljs.core.pv_aset(ret,subidx,(function (){var G__33751 = pv;
var G__33752 = (level - (5));
var G__33753 = cljs.core.pv_aget(node,subidx);
var G__33754 = i;
var G__33755 = val;
return (cljs.core.do_assoc.cljs$core$IFn$_invoke$arity$5 ? cljs.core.do_assoc.cljs$core$IFn$_invoke$arity$5(G__33751,G__33752,G__33753,G__33754,G__33755) : cljs.core.do_assoc.call(null, G__33751,G__33752,G__33753,G__33754,G__33755));
})());

return ret;
}
});
cljs.core.pop_tail = (function cljs$core$pop_tail(pv,level,node){
var subidx = (((pv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = (function (){var G__33756 = pv;
var G__33757 = (level - (5));
var G__33758 = cljs.core.pv_aget(node,subidx);
return (cljs.core.pop_tail.cljs$core$IFn$_invoke$arity$3 ? cljs.core.pop_tail.cljs$core$IFn$_invoke$arity$3(G__33756,G__33757,G__33758) : cljs.core.pop_tail.call(null, G__33756,G__33757,G__33758));
})();
if((((new_child == null)) && ((subidx === (0))))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,new_child);

return ret;
}
} else {
if((subidx === (0))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,null);

return ret;

}
}
});

/**
* @constructor
*/
cljs.core.RangedIterator = (function (i,base,arr,v,start,end){
this.i = i;
this.base = base;
this.arr = arr;
this.v = v;
this.start = start;
this.end = end;
});
(cljs.core.RangedIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
return (self__.i < self__.end);
}));

(cljs.core.RangedIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(((self__.i - self__.base) === (32))){
(self__.arr = cljs.core.unchecked_array_for(self__.v,self__.i));

(self__.base = (self__.base + (32)));
} else {
}

var ret = (self__.arr[(self__.i & (31))]);
(self__.i = (self__.i + (1)));

return ret;
}));

(cljs.core.RangedIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"base","base",1825810849,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null);
}));

(cljs.core.RangedIterator.cljs$lang$type = true);

(cljs.core.RangedIterator.cljs$lang$ctorStr = "cljs.core/RangedIterator");

(cljs.core.RangedIterator.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/RangedIterator");
}));

/**
 * Positional factory function for cljs.core/RangedIterator.
 */
cljs.core.__GT_RangedIterator = (function cljs$core$__GT_RangedIterator(i,base,arr,v,start,end){
return (new cljs.core.RangedIterator(i,base,arr,v,start,end));
});

cljs.core.ranged_iterator = (function cljs$core$ranged_iterator(v,start,end){
var i = start;
return (new cljs.core.RangedIterator(i,(i - (i % (32))),(((start < cljs.core.count(v)))?cljs.core.unchecked_array_for(v,i):null),v,start,end));
});
cljs.core.pv_reduce = (function cljs$core$pv_reduce(var_args){
var G__33760 = arguments.length;
switch (G__33760) {
case 4:
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4 = (function (pv,f,start,end){
if((start < end)){
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5(pv,f,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pv,start),(start + (1)),end);
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null, ));
}
}));

(cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5 = (function (pv,f,init,start,end){
var acc = init;
var i = start;
var arr = cljs.core.unchecked_array_for(pv,start);
while(true){
if((i < end)){
var j = (i & (31));
var arr__$1 = (((j === (0)))?cljs.core.unchecked_array_for(pv,i):arr);
var nacc = (function (){var G__33761 = acc;
var G__33762 = (arr__$1[j]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__33761,G__33762) : f.call(null, G__33761,G__33762));
})();
if(cljs.core.reduced_QMARK_(nacc)){
return cljs.core.deref(nacc);
} else {
var G__36650 = nacc;
var G__36651 = (i + (1));
var G__36652 = arr__$1;
acc = G__36650;
i = G__36651;
arr = G__36652;
continue;
}
} else {
return acc;
}
break;
}
}));

(cljs.core.pv_reduce.cljs$lang$maxFixedArity = 5);







/**
 * Marker protocol
 * @interface
 */
cljs.core.APersistentVector = function(){};


/**
* @constructor
 * @implements {cljs.core.IDrop}
 * @implements {cljs.core.APersistentVector}
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentVector = (function (meta,cnt,shift,root,tail,__hash){
this.meta = meta;
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167666463;
this.cljs$lang$protocol_mask$partition1$ = 401412;
});
(cljs.core.PersistentVector.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.cljs$core$IFind$_find$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
return (new cljs.core.MapEntry(n,(cljs.core.unchecked_array_for(coll__$1,n)[(n & (31))]),null));
} else {
return null;
}
}));

(cljs.core.PersistentVector.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentVector.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
}));

(cljs.core.PersistentVector.prototype.indexOf = (function() {
var G__36657 = null;
var G__36657__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__36657__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__36657 = function(x,start){
switch(arguments.length){
case 1:
return G__36657__1.call(this,x);
case 2:
return G__36657__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36657.cljs$core$IFn$_invoke$arity$1 = G__36657__1;
G__36657.cljs$core$IFn$_invoke$arity$2 = G__36657__2;
return G__36657;
})()
);

(cljs.core.PersistentVector.prototype.lastIndexOf = (function() {
var G__36659 = null;
var G__36659__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__36659__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__36659 = function(x,start){
switch(arguments.length){
case 1:
return G__36659__1.call(this,x);
case 2:
return G__36659__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36659.cljs$core$IFn$_invoke$arity$1 = G__36659__1;
G__36659.cljs$core$IFn$_invoke$arity$2 = G__36659__2;
return G__36659;
})()
);

(cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null, k,null);
}));

(cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return coll__$1.cljs$core$IIndexed$_nth$arity$3(null, k,not_found);
} else {
return not_found;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__33764 = init__$2;
var G__33765 = (j + i);
var G__33766 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__33764,G__33765,G__33766) : f.call(null, G__33764,G__33765,G__33766));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__36666 = (j + (1));
var G__36667 = init__$3;
j = G__36666;
init__$2 = G__36667;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__36669 = (i + len);
var G__36670 = init__$2;
i = G__36669;
init__$1 = G__36670;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$APersistentVector$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
return (cljs.core.unchecked_array_for(coll__$1,n)[(n & (31))]);
} else {
return not_found;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
if((cljs.core.tail_off(coll__$1) <= n)){
var new_tail = cljs.core.aclone(self__.tail);
(new_tail[(n & (31))] = val);

return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,cljs.core.do_assoc(coll__$1,self__.shift,self__.root,n,val),self__.tail,null));
}
} else {
if((n === self__.cnt)){
return coll__$1.cljs$core$ICollection$_conj$arity$2(null, val);
} else {
throw (new Error(["Index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)," out of bounds  [0,",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.cnt),"]"].join('')));

}
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.ranged_iterator(this$__$1,(0),self__.cnt);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentVector.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
}));

(cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
}));

(cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return coll__$1.cljs$core$IIndexed$_nth$arity$2(null, (self__.cnt - (1)));
} else {
return null;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
} else {
if(((1) < (self__.cnt - cljs.core.tail_off(coll__$1)))){
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt - (1)),self__.shift,self__.root,self__.tail.slice((0),(-1)),null));
} else {
var new_tail = cljs.core.unchecked_array_for(coll__$1,(self__.cnt - (2)));
var nr = cljs.core.pop_tail(coll__$1,self__.shift,self__.root);
var new_root = (((nr == null))?cljs.core.PersistentVector.EMPTY_NODE:nr);
var cnt_1 = (self__.cnt - (1));
if(((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null)))){
return (new cljs.core.PersistentVector(self__.meta,cnt_1,(self__.shift - (5)),cljs.core.pv_aget(new_root,(0)),new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,cnt_1,self__.shift,new_root,new_tail,null));
}

}
}
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return (new cljs.core.RSeq(coll__$1,(self__.cnt - (1)),null));
} else {
return null;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if((other instanceof cljs.core.PersistentVector)){
if((self__.cnt === cljs.core.count(other))){
var me_iter = coll__$1.cljs$core$IIterable$_iterator$arity$1(null, );
var you_iter = other.cljs$core$IIterable$_iterator$arity$1(null, );
while(true){
if(me_iter.hasNext()){
var x = me_iter.next();
var y = you_iter.next();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_sequential(coll__$1,other);
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientVector(self__.cnt,self__.shift,(cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1(self__.root) : cljs.core.tv_editable_root.call(null, self__.root)),(cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1(self__.tail) : cljs.core.tv_editable_tail.call(null, self__.tail))));
}));

(cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (v,f){
var self__ = this;
var v__$1 = this;
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4(v__$1,f,(0),self__.cnt);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__33767 = init__$2;
var G__33768 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__33767,G__33768) : f.call(null, G__33767,G__33768));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__36713 = (j + (1));
var G__36714 = init__$3;
j = G__36713;
init__$2 = G__36714;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__36716 = (i + len);
var G__36717 = init__$2;
i = G__36716;
init__$1 = G__36717;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return coll__$1.cljs$core$IVector$_assoc_n$arity$3(null, k,v);
} else {
throw (new Error("Vector's key for assoc must be a number."));
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(cljs.core.integer_QMARK_(k)){
return ((((0) <= k)) && ((k < self__.cnt)));
} else {
return false;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
return null;
} else {
if((self__.cnt <= (32))){
return (new cljs.core.IndexedSeq(self__.tail,(0),null));
} else {
var G__33769 = coll__$1;
var G__33770 = cljs.core.first_array_for_longvec(coll__$1);
var G__33771 = (0);
var G__33772 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__33769,G__33770,G__33771,G__33772) : cljs.core.chunked_seq.call(null, G__33769,G__33770,G__33771,G__33772));

}
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentVector(new_meta,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(((self__.cnt - cljs.core.tail_off(coll__$1)) < (32))){
var len = self__.tail.length;
var new_tail = (new Array((len + (1))));
var n__5593__auto___36728 = len;
var i_36729 = (0);
while(true){
if((i_36729 < n__5593__auto___36728)){
(new_tail[i_36729] = (self__.tail[i_36729]));

var G__36731 = (i_36729 + (1));
i_36729 = G__36731;
continue;
} else {
}
break;
}

(new_tail[len] = o);

return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),self__.shift,self__.root,new_tail,null));
} else {
var root_overflow_QMARK_ = ((self__.cnt >>> (5)) > ((1) << self__.shift));
var new_shift = ((root_overflow_QMARK_)?(self__.shift + (5)):self__.shift);
var new_root = ((root_overflow_QMARK_)?(function (){var n_r = cljs.core.pv_fresh_node(null);
cljs.core.pv_aset(n_r,(0),self__.root);

cljs.core.pv_aset(n_r,(1),cljs.core.new_path(null,self__.shift,(new cljs.core.VectorNode(null,self__.tail))));

return n_r;
})():cljs.core.push_tail(coll__$1,self__.shift,self__.root,(new cljs.core.VectorNode(null,self__.tail))));
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),new_shift,new_root,[o],null));
}
}));

(cljs.core.PersistentVector.prototype.call = (function (unused__11804__auto__){
var self__ = this;
var self__ = this;
var G__33773 = (arguments.length - (1));
switch (G__33773) {
case (1):
return self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(cljs.core.PersistentVector.prototype.apply = (function (self__,args33763){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args33763)));
}));

(cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
if(typeof k === 'number'){
return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
} else {
throw (new Error("Key must be integer"));
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IDrop$_drop$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if((n < self__.cnt)){
var offset = (n % (32));
var G__33774 = coll__$1;
var G__33775 = cljs.core.unchecked_array_for(coll__$1,n);
var G__33776 = (n - offset);
var G__33777 = offset;
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__33774,G__33775,G__33776,G__33777) : cljs.core.chunked_seq.call(null, G__33774,G__33775,G__33776,G__33777));
} else {
return null;
}
}));

(cljs.core.PersistentVector.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"shift","shift",-1657295705,null),new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.Symbol(null,"tail","tail",494507963,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentVector.cljs$lang$type = true);

(cljs.core.PersistentVector.cljs$lang$ctorStr = "cljs.core/PersistentVector");

(cljs.core.PersistentVector.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/PersistentVector");
}));

/**
 * Positional factory function for cljs.core/PersistentVector.
 */
cljs.core.__GT_PersistentVector = (function cljs$core$__GT_PersistentVector(meta,cnt,shift,root,tail,__hash){
return (new cljs.core.PersistentVector(meta,cnt,shift,root,tail,__hash));
});

(cljs.core.PersistentVector.EMPTY_NODE = (new cljs.core.VectorNode(null,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null])));
(cljs.core.PersistentVector.EMPTY = (new cljs.core.PersistentVector(null,(0),(5),cljs.core.PersistentVector.EMPTY_NODE,[],cljs.core.empty_ordered_hash)));
(cljs.core.PersistentVector.fromArray = (function (xs,no_clone){
var l = xs.length;
var xs__$1 = ((no_clone)?xs:cljs.core.aclone(xs));
if((l < (32))){
return (new cljs.core.PersistentVector(null,l,(5),cljs.core.PersistentVector.EMPTY_NODE,xs__$1,null));
} else {
var node = xs__$1.slice((0),(32));
var v = (new cljs.core.PersistentVector(null,(32),(5),cljs.core.PersistentVector.EMPTY_NODE,node,null));
var i = (32);
var out = v.cljs$core$IEditableCollection$_as_transient$arity$1(null, );
while(true){
if((i < l)){
var G__36807 = (i + (1));
var G__36808 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(out,(xs__$1[i]));
i = G__36807;
out = G__36808;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
}
}));
(cljs.core.PersistentVector.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));
/**
 * Creates a new vector containing the contents of coll. JavaScript arrays
 *   will be aliased and should not be modified.
 */
cljs.core.vec = (function cljs$core$vec(coll){
if(cljs.core.truth_((cljs.core.map_entry_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.core.map_entry_QMARK_.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.map_entry_QMARK_.call(null, coll)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.key.call(null, coll)),(cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.val.call(null, coll))], null);
} else {
if(cljs.core.vector_QMARK_(coll)){
return cljs.core.with_meta(coll,null);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.PersistentVector.fromArray(coll,true);
} else {
return cljs.core._persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core._as_transient(cljs.core.PersistentVector.EMPTY),coll));

}
}
}
});
/**
 * Creates a new vector containing the args.
 */
cljs.core.vector = (function cljs$core$vector(var_args){
var args__5732__auto__ = [];
var len__5726__auto___36835 = arguments.length;
var i__5727__auto___36836 = (0);
while(true){
if((i__5727__auto___36836 < len__5726__auto___36835)){
args__5732__auto__.push((arguments[i__5727__auto___36836]));

var G__36837 = (i__5727__auto___36836 + (1));
i__5727__auto___36836 = G__36837;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((0) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((0)),(0),null)):null);
return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(argseq__5733__auto__);
});

(cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic = (function (args){
if((((args instanceof cljs.core.IndexedSeq)) && ((args.i === (0))))){
return cljs.core.PersistentVector.fromArray(args.arr,(!(cljs.core.array_QMARK_(args.arr))));
} else {
return cljs.core.vec(args);
}
}));

(cljs.core.vector.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.vector.cljs$lang$applyTo = (function (seq33778){
var self__5712__auto__ = this;
return self__5712__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq33778));
}));


/**
* @constructor
 * @implements {cljs.core.IDrop}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IChunkedNext}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IChunkedSeq}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ChunkedSeq = (function (vec,node,i,off,meta,__hash){
this.vec = vec;
this.node = node;
this.i = i;
this.off = off;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375020;
this.cljs$lang$protocol_mask$partition1$ = 263680;
});
(cljs.core.ChunkedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.ChunkedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
}));

(cljs.core.ChunkedSeq.prototype.indexOf = (function() {
var G__36872 = null;
var G__36872__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__36872__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__36872 = function(x,start){
switch(arguments.length){
case 1:
return G__36872__1.call(this,x);
case 2:
return G__36872__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36872.cljs$core$IFn$_invoke$arity$1 = G__36872__1;
G__36872.cljs$core$IFn$_invoke$arity$2 = G__36872__2;
return G__36872;
})()
);

(cljs.core.ChunkedSeq.prototype.lastIndexOf = (function() {
var G__36877 = null;
var G__36877__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__36877__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__36877 = function(x,start){
switch(arguments.length){
case 1:
return G__36877__1.call(this,x);
case 2:
return G__36877__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36877.cljs$core$IFn$_invoke$arity$1 = G__36877__1;
G__36877.cljs$core$IFn$_invoke$arity$2 = G__36877__2;
return G__36877;
})()
);

(cljs.core.ChunkedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = (function (){var G__33779 = self__.vec;
var G__33780 = self__.node;
var G__33781 = self__.i;
var G__33782 = (self__.off + (1));
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__33779,G__33780,G__33781,G__33782) : cljs.core.chunked_seq.call(null, G__33779,G__33780,G__33781,G__33782));
})();
if((s == null)){
return null;
} else {
return s;
}
} else {
return coll__$1.cljs$core$IChunkedNext$_chunked_next$arity$1(null, );
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4(self__.vec,f,(self__.i + self__.off),cljs.core.count(self__.vec));
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5(self__.vec,f,start,(self__.i + self__.off),cljs.core.count(self__.vec));
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.node[self__.off]);
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = (function (){var G__33783 = self__.vec;
var G__33784 = self__.node;
var G__33785 = self__.i;
var G__33786 = (self__.off + (1));
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__33783,G__33784,G__33785,G__33786) : cljs.core.chunked_seq.call(null, G__33783,G__33784,G__33785,G__33786));
})();
if((s == null)){
return cljs.core.List.EMPTY;
} else {
return s;
}
} else {
return coll__$1.cljs$core$IChunkedSeq$_chunked_rest$arity$1(null, );
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(self__.node,self__.off);
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
var G__33787 = self__.vec;
var G__33788 = cljs.core.unchecked_array_for(self__.vec,end);
var G__33789 = end;
var G__33790 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__33787,G__33788,G__33789,G__33790) : cljs.core.chunked_seq.call(null, G__33787,G__33788,G__33789,G__33790));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(self__.vec,self__.node,self__.i,self__.off,new_meta) : cljs.core.chunked_seq.call(null, self__.vec,self__.node,self__.i,self__.off,new_meta));
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IDrop$_drop$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
var o = (self__.off + n);
if((o < self__.node.length)){
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,self__.node,self__.i,o) : cljs.core.chunked_seq.call(null, self__.vec,self__.node,self__.i,o));
} else {
var i__$1 = (self__.i + o);
if((i__$1 < cljs.core._count(self__.vec))){
var new_offset = (i__$1 % (32));
var G__33791 = self__.vec;
var G__33792 = cljs.core.unchecked_array_for(self__.vec,i__$1);
var G__33793 = (i__$1 - new_offset);
var G__33794 = new_offset;
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__33791,G__33792,G__33793,G__33794) : cljs.core.chunked_seq.call(null, G__33791,G__33792,G__33793,G__33794));
} else {
return null;
}
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
var G__33795 = self__.vec;
var G__33796 = cljs.core.unchecked_array_for(self__.vec,end);
var G__33797 = end;
var G__33798 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__33795,G__33796,G__33797,G__33798) : cljs.core.chunked_seq.call(null, G__33795,G__33796,G__33797,G__33798));
} else {
return null;
}
}));

(cljs.core.ChunkedSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"vec","vec",982683596,null),new cljs.core.Symbol(null,"node","node",-2073234571,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"off","off",-2047994980,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ChunkedSeq.cljs$lang$type = true);

(cljs.core.ChunkedSeq.cljs$lang$ctorStr = "cljs.core/ChunkedSeq");

(cljs.core.ChunkedSeq.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/ChunkedSeq");
}));

/**
 * Positional factory function for cljs.core/ChunkedSeq.
 */
cljs.core.__GT_ChunkedSeq = (function cljs$core$__GT_ChunkedSeq(vec,node,i,off,meta,__hash){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,__hash));
});

(cljs.core.ChunkedSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));
cljs.core.chunked_seq = (function cljs$core$chunked_seq(var_args){
var G__33800 = arguments.length;
switch (G__33800) {
case 3:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3 = (function (vec,i,off){
return (new cljs.core.ChunkedSeq(vec,cljs.core.array_for(vec,i),i,off,null,null));
}));

(cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 = (function (vec,node,i,off){
return (new cljs.core.ChunkedSeq(vec,node,i,off,null,null));
}));

(cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 = (function (vec,node,i,off,meta){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,null));
}));

(cljs.core.chunked_seq.cljs$lang$maxFixedArity = 5);


/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Subvec = (function (meta,v,start,end,__hash){
this.meta = meta;
this.v = v;
this.start = start;
this.end = end;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167666463;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(cljs.core.Subvec.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Subvec.prototype.cljs$core$IFind$_find$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if((n < (0))){
return null;
} else {
var idx = (self__.start + n);
if((idx < self__.end)){
return (new cljs.core.MapEntry(n,cljs.core._lookup(self__.v,idx),null));
} else {
return null;
}
}
}));

(cljs.core.Subvec.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Subvec.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
}));

(cljs.core.Subvec.prototype.indexOf = (function() {
var G__36948 = null;
var G__36948__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__36948__2 = (function (x,start__$1){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start__$1);
});
G__36948 = function(x,start__$1){
switch(arguments.length){
case 1:
return G__36948__1.call(this,x);
case 2:
return G__36948__2.call(this,x,start__$1);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36948.cljs$core$IFn$_invoke$arity$1 = G__36948__1;
G__36948.cljs$core$IFn$_invoke$arity$2 = G__36948__2;
return G__36948;
})()
);

(cljs.core.Subvec.prototype.lastIndexOf = (function() {
var G__36949 = null;
var G__36949__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__36949__2 = (function (x,start__$1){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start__$1);
});
G__36949 = function(x,start__$1){
switch(arguments.length){
case 1:
return G__36949__1.call(this,x);
case 2:
return G__36949__2.call(this,x,start__$1);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36949.cljs$core$IFn$_invoke$arity$1 = G__36949__1;
G__36949.cljs$core$IFn$_invoke$arity$2 = G__36949__2;
return G__36949;
})()
);

(cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null, k,null);
}));

(cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return coll__$1.cljs$core$IIndexed$_nth$arity$3(null, k,not_found);
} else {
return not_found;
}
}));

(cljs.core.Subvec.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var i = self__.start;
var j = (0);
var init__$1 = init;
while(true){
if((i < self__.end)){
var init__$2 = (function (){var G__33802 = init__$1;
var G__33803 = j;
var G__33804 = cljs.core._nth(self__.v,i);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__33802,G__33803,G__33804) : f.call(null, G__33802,G__33803,G__33804));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__36950 = (i + (1));
var G__36951 = (j + (1));
var G__36952 = init__$2;
i = G__36950;
j = G__36951;
init__$1 = G__36952;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if((((n < (0))) || ((self__.end <= (self__.start + n))))){
return cljs.core.vector_index_out_of_bounds(n,(self__.end - self__.start));
} else {
return cljs.core._nth(self__.v,(self__.start + n));
}
}));

(cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((n < (0))) || ((self__.end <= (self__.start + n))))){
return not_found;
} else {
return cljs.core._nth(self__.v,(self__.start + n),not_found);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
var v_pos = (self__.start + n);
if((((n < (0))) || (((self__.end + (1)) <= v_pos)))){
throw (new Error(["Index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)," out of bounds [0,",cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll__$1.cljs$core$ICounted$_count$arity$1(null, )),"]"].join('')));
} else {
var G__33805 = self__.meta;
var G__33806 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.v,v_pos,val);
var G__33807 = self__.start;
var G__33808 = (function (){var x__5087__auto__ = self__.end;
var y__5088__auto__ = (v_pos + (1));
return ((x__5087__auto__ > y__5088__auto__) ? x__5087__auto__ : y__5088__auto__);
})();
var G__33809 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__33805,G__33806,G__33807,G__33808,G__33809) : cljs.core.build_subvec.call(null, G__33805,G__33806,G__33807,G__33808,G__33809));
}
}));

(cljs.core.Subvec.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((((!((self__.v == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === self__.v.cljs$core$APersistentVector$))))?true:false):false)){
return cljs.core.ranged_iterator(self__.v,self__.start,self__.end);
} else {
return cljs.core.seq_iter(coll__$1);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Subvec.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Subvec(self__.meta,self__.v,self__.start,self__.end,self__.__hash));
}));

(cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.end - self__.start);
}));

(cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.start === self__.end)){
return null;
} else {
return cljs.core._nth(self__.v,(self__.end - (1)));
}
}));

(cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.start === self__.end)){
throw (new Error("Can't pop empty vector"));
} else {
var G__33811 = self__.meta;
var G__33812 = self__.v;
var G__33813 = self__.start;
var G__33814 = (self__.end - (1));
var G__33815 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__33811,G__33812,G__33813,G__33814,G__33815) : cljs.core.build_subvec.call(null, G__33811,G__33812,G__33813,G__33814,G__33815));
}
}));

(cljs.core.Subvec.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((!((self__.start === self__.end)))){
return (new cljs.core.RSeq(coll__$1,((self__.end - self__.start) - (1)),null));
} else {
return null;
}
}));

(cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
}));

(cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
if((((!((self__.v == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === self__.v.cljs$core$APersistentVector$))))?true:false):false)){
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4(self__.v,f,self__.start,self__.end);
} else {
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1,f);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
if((((!((self__.v == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === self__.v.cljs$core$APersistentVector$))))?true:false):false)){
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5(self__.v,f,init,self__.start,self__.end);
} else {
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1,f,init);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,key,val){
var self__ = this;
var coll__$1 = this;
if(typeof key === 'number'){
return coll__$1.cljs$core$IVector$_assoc_n$arity$3(null, key,val);
} else {
throw (new Error("Subvec's key for assoc must be a number."));
}
}));

(cljs.core.Subvec.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,key){
var self__ = this;
var coll__$1 = this;
if(cljs.core.integer_QMARK_(key)){
return ((((0) <= key)) && ((key < (self__.end - self__.start))));
} else {
return false;
}
}));

(cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var subvec_seq = (function cljs$core$subvec_seq(i){
if((i === self__.end)){
return null;
} else {
return cljs.core.cons(cljs.core._nth(self__.v,i),(new cljs.core.LazySeq(null,(function (){
return cljs$core$subvec_seq((i + (1)));
}),null,null)));
}
});
return subvec_seq(self__.start);
}));

(cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(new_meta,self__.v,self__.start,self__.end,self__.__hash) : cljs.core.build_subvec.call(null, new_meta,self__.v,self__.start,self__.end,self__.__hash));
}
}));

(cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
var G__33818 = self__.meta;
var G__33819 = cljs.core._assoc_n(self__.v,self__.end,o);
var G__33820 = self__.start;
var G__33821 = (self__.end + (1));
var G__33822 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__33818,G__33819,G__33820,G__33821,G__33822) : cljs.core.build_subvec.call(null, G__33818,G__33819,G__33820,G__33821,G__33822));
}));

(cljs.core.Subvec.prototype.call = (function (unused__11804__auto__){
var self__ = this;
var self__ = this;
var G__33823 = (arguments.length - (1));
switch (G__33823) {
case (1):
return self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));

break;
case (2):
return self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(cljs.core.Subvec.prototype.apply = (function (self__,args33801){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args33801)));
}));

(cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
}));

(cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null, k,not_found);
}));

(cljs.core.Subvec.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Subvec.cljs$lang$type = true);

(cljs.core.Subvec.cljs$lang$ctorStr = "cljs.core/Subvec");

(cljs.core.Subvec.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/Subvec");
}));

/**
 * Positional factory function for cljs.core/Subvec.
 */
cljs.core.__GT_Subvec = (function cljs$core$__GT_Subvec(meta,v,start,end,__hash){
return (new cljs.core.Subvec(meta,v,start,end,__hash));
});

(cljs.core.Subvec.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));
cljs.core.build_subvec = (function cljs$core$build_subvec(meta,v,start,end,__hash){
while(true){
if((v instanceof cljs.core.Subvec)){
var G__37027 = meta;
var G__37028 = v.v;
var G__37029 = (v.start + start);
var G__37030 = (v.start + end);
var G__37031 = __hash;
meta = G__37027;
v = G__37028;
start = G__37029;
end = G__37030;
__hash = G__37031;
continue;
} else {
if(cljs.core.vector_QMARK_(v)){
} else {
throw (new Error("v must satisfy IVector"));
}

if((((start < (0))) || ((((end < start)) || ((end > cljs.core.count(v))))))){
throw (new Error("Index out of bounds"));
} else {
}

return (new cljs.core.Subvec(meta,v,start,end,__hash));
}
break;
}
});
/**
 * Returns a persistent vector of the items in vector from
 *   start (inclusive) to end (exclusive).  If end is not supplied,
 *   defaults to (count vector). This operation is O(1) and very fast, as
 *   the resulting vector shares structure with the original and no
 *   trimming is done.
 */
cljs.core.subvec = (function cljs$core$subvec(var_args){
var G__33825 = arguments.length;
switch (G__33825) {
case 2:
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.subvec.cljs$core$IFn$_invoke$arity$2 = (function (v,start){
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(v,start,cljs.core.count(v));
}));

(cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 = (function (v,start,end){
if((((!((start == null)))) && ((!((end == null)))))){
} else {
throw (new Error("Assert failed: (and (not (nil? start)) (not (nil? end)))"));
}

return cljs.core.build_subvec(null,v,(start | (0)),(end | (0)),null);
}));

(cljs.core.subvec.cljs$lang$maxFixedArity = 3);

cljs.core.tv_ensure_editable = (function cljs$core$tv_ensure_editable(edit,node){
if((edit === node.edit)){
return node;
} else {
return (new cljs.core.VectorNode(edit,cljs.core.aclone(node.arr)));
}
});
cljs.core.tv_editable_root = (function cljs$core$tv_editable_root(node){
return (new cljs.core.VectorNode(({}),cljs.core.aclone(node.arr)));
});
cljs.core.tv_editable_tail = (function cljs$core$tv_editable_tail(tl){
var ret = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
cljs.core.array_copy(tl,(0),ret,(0),tl.length);

return ret;
});
cljs.core.tv_push_tail = (function cljs$core$tv_push_tail(tv,level,parent,tail_node){
var ret = cljs.core.tv_ensure_editable(tv.root.edit,parent);
var subidx = (((tv.cnt - (1)) >>> level) & (31));
cljs.core.pv_aset(ret,subidx,(((level === (5)))?tail_node:(function (){var child = cljs.core.pv_aget(ret,subidx);
if((!((child == null)))){
var G__33828 = tv;
var G__33829 = (level - (5));
var G__33830 = child;
var G__33831 = tail_node;
return (cljs.core.tv_push_tail.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tv_push_tail.cljs$core$IFn$_invoke$arity$4(G__33828,G__33829,G__33830,G__33831) : cljs.core.tv_push_tail.call(null, G__33828,G__33829,G__33830,G__33831));
} else {
return cljs.core.new_path(tv.root.edit,(level - (5)),tail_node);
}
})()));

return ret;
});
cljs.core.tv_pop_tail = (function cljs$core$tv_pop_tail(tv,level,node){
var node__$1 = cljs.core.tv_ensure_editable(tv.root.edit,node);
var subidx = (((tv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = (function (){var G__33832 = tv;
var G__33833 = (level - (5));
var G__33834 = cljs.core.pv_aget(node__$1,subidx);
return (cljs.core.tv_pop_tail.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tv_pop_tail.cljs$core$IFn$_invoke$arity$3(G__33832,G__33833,G__33834) : cljs.core.tv_pop_tail.call(null, G__33832,G__33833,G__33834));
})();
if((((new_child == null)) && ((subidx === (0))))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,new_child);

return node__$1;
}
} else {
if((subidx === (0))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,null);

return node__$1;

}
}
});
cljs.core.unchecked_editable_array_for = (function cljs$core$unchecked_editable_array_for(tv,i){
if((i >= cljs.core.tail_off(tv))){
return tv.tail;
} else {
var root = tv.root;
var node = root;
var level = tv.shift;
while(true){
if((level > (0))){
var G__37064 = cljs.core.tv_ensure_editable(root.edit,cljs.core.pv_aget(node,((i >>> level) & (31))));
var G__37065 = (level - (5));
node = G__37064;
level = G__37065;
continue;
} else {
return node.arr;
}
break;
}
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientVector}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientVector = (function (cnt,shift,root,tail){
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.cljs$lang$protocol_mask$partition1$ = 88;
this.cljs$lang$protocol_mask$partition0$ = 275;
});
(cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if(((self__.cnt - cljs.core.tail_off(tcoll__$1)) < (32))){
(self__.tail[(self__.cnt & (31))] = o);

(self__.cnt = (self__.cnt + (1)));

return tcoll__$1;
} else {
var tail_node = (new cljs.core.VectorNode(self__.root.edit,self__.tail));
var new_tail = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(new_tail[(0)] = o);

(self__.tail = new_tail);

if(((self__.cnt >>> (5)) > ((1) << self__.shift))){
var new_root_array = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var new_shift = (self__.shift + (5));
(new_root_array[(0)] = self__.root);

(new_root_array[(1)] = cljs.core.new_path(self__.root.edit,self__.shift,tail_node));

(self__.root = (new cljs.core.VectorNode(self__.root.edit,new_root_array)));

(self__.shift = new_shift);

(self__.cnt = (self__.cnt + (1)));

return tcoll__$1;
} else {
var new_root = cljs.core.tv_push_tail(tcoll__$1,self__.shift,self__.root,tail_node);
(self__.root = new_root);

(self__.cnt = (self__.cnt + (1)));

return tcoll__$1;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
(self__.root.edit = null);

var len = (self__.cnt - cljs.core.tail_off(tcoll__$1));
var trimmed_tail = (new Array(len));
cljs.core.array_copy(self__.tail,(0),trimmed_tail,(0),len);

return (new cljs.core.PersistentVector(null,self__.cnt,self__.shift,self__.root,trimmed_tail,null));
} else {
throw (new Error("persistent! called twice"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(typeof key === 'number'){
return tcoll__$1.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(null, key,val);
} else {
throw (new Error("TransientVector's key for assoc! must be a number."));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = (function (tcoll,n,val){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if(((((0) <= n)) && ((n < self__.cnt)))){
if((cljs.core.tail_off(tcoll__$1) <= n)){
(self__.tail[(n & (31))] = val);

return tcoll__$1;
} else {
var new_root = (function cljs$core$go(level,node){
var node__$1 = cljs.core.tv_ensure_editable(self__.root.edit,node);
if((level === (0))){
cljs.core.pv_aset(node__$1,(n & (31)),val);

return node__$1;
} else {
var subidx = ((n >>> level) & (31));
cljs.core.pv_aset(node__$1,subidx,cljs$core$go((level - (5)),cljs.core.pv_aget(node__$1,subidx)));

return node__$1;
}
})(self__.shift,self__.root);
(self__.root = new_root);

return tcoll__$1;
}
} else {
if((n === self__.cnt)){
return tcoll__$1.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null, val);
} else {
throw (new Error(["Index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)," out of bounds for TransientVector of length",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.cnt)].join('')));

}
}
} else {
throw (new Error("assoc! after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
(self__.cnt = (0));

return tcoll__$1;
} else {
if((((self__.cnt - (1)) & (31)) > (0))){
(self__.cnt = (self__.cnt - (1)));

return tcoll__$1;
} else {
var new_tail = cljs.core.unchecked_editable_array_for(tcoll__$1,(self__.cnt - (2)));
var new_root = (function (){var nr = cljs.core.tv_pop_tail(tcoll__$1,self__.shift,self__.root);
if((!((nr == null)))){
return nr;
} else {
return (new cljs.core.VectorNode(self__.root.edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
}
})();
if(((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null)))){
var new_root__$1 = cljs.core.tv_ensure_editable(self__.root.edit,cljs.core.pv_aget(new_root,(0)));
(self__.root = new_root__$1);

(self__.shift = (self__.shift - (5)));

(self__.cnt = (self__.cnt - (1)));

(self__.tail = new_tail);

return tcoll__$1;
} else {
(self__.root = new_root);

(self__.cnt = (self__.cnt - (1)));

(self__.tail = new_tail);

return tcoll__$1;
}

}
}
}
} else {
throw (new Error("pop! after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return self__.cnt;
} else {
throw (new Error("count after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
} else {
throw (new Error("nth after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
return coll__$1.cljs$core$IIndexed$_nth$arity$2(null, n);
} else {
return not_found;
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null, k,null);
}));

(cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((!(self__.root.edit))){
throw (new Error("lookup after persistent!"));
} else {
if(typeof k === 'number'){
return coll__$1.cljs$core$IIndexed$_nth$arity$3(null, k,not_found);
} else {
return not_found;

}
}
}));

(cljs.core.TransientVector.prototype.call = (function (unused__11804__auto__){
var self__ = this;
var self__ = this;
var G__33836 = (arguments.length - (1));
switch (G__33836) {
case (1):
return self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));

break;
case (2):
return self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(cljs.core.TransientVector.prototype.apply = (function (self__,args33835){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args33835)));
}));

(cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
}));

(cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null, k,not_found);
}));

(cljs.core.TransientVector.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"shift","shift",-1657295705,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"tail","tail",494507963,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.TransientVector.cljs$lang$type = true);

(cljs.core.TransientVector.cljs$lang$ctorStr = "cljs.core/TransientVector");

(cljs.core.TransientVector.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/TransientVector");
}));

/**
 * Positional factory function for cljs.core/TransientVector.
 */
cljs.core.__GT_TransientVector = (function cljs$core$__GT_TransientVector(cnt,shift,root,tail){
return (new cljs.core.TransientVector(cnt,shift,root,tail));
});


/**
* @constructor
*/
cljs.core.PersistentQueueIter = (function (fseq,riter){
this.fseq = fseq;
this.riter = riter;
});
(cljs.core.PersistentQueueIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var or__5002__auto__ = (((!((self__.fseq == null)))) && (cljs.core.seq(self__.fseq)));
if(or__5002__auto__){
return or__5002__auto__;
} else {
var and__5000__auto__ = (!((self__.riter == null)));
if(and__5000__auto__){
return self__.riter.hasNext();
} else {
return and__5000__auto__;
}
}
}));

(cljs.core.PersistentQueueIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if((!((self__.fseq == null)))){
var ret = cljs.core.first(self__.fseq);
(self__.fseq = cljs.core.next(self__.fseq));

return ret;
} else {
if((((!((self__.riter == null)))) && (self__.riter.hasNext()))){
return self__.riter.next();
} else {
throw (new Error("No such element"));

}
}
}));

(cljs.core.PersistentQueueIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.PersistentQueueIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"fseq","fseq",-1466412450,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"riter","riter",-237834262,null)], null);
}));

(cljs.core.PersistentQueueIter.cljs$lang$type = true);

(cljs.core.PersistentQueueIter.cljs$lang$ctorStr = "cljs.core/PersistentQueueIter");

(cljs.core.PersistentQueueIter.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/PersistentQueueIter");
}));

/**
 * Positional factory function for cljs.core/PersistentQueueIter.
 */
cljs.core.__GT_PersistentQueueIter = (function cljs$core$__GT_PersistentQueueIter(fseq,riter){
return (new cljs.core.PersistentQueueIter(fseq,riter));
});


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.PersistentQueueSeq = (function (meta,front,rear,__hash){
this.meta = meta;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850700;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.PersistentQueueSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentQueueSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
}));

(cljs.core.PersistentQueueSeq.prototype.indexOf = (function() {
var G__37213 = null;
var G__37213__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__37213__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__37213 = function(x,start){
switch(arguments.length){
case 1:
return G__37213__1.call(this,x);
case 2:
return G__37213__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__37213.cljs$core$IFn$_invoke$arity$1 = G__37213__1;
G__37213.cljs$core$IFn$_invoke$arity$2 = G__37213__2;
return G__37213;
})()
);

(cljs.core.PersistentQueueSeq.prototype.lastIndexOf = (function() {
var G__37219 = null;
var G__37219__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__37219__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__37219 = function(x,start){
switch(arguments.length){
case 1:
return G__37219__1.call(this,x);
case 2:
return G__37219__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__37219.cljs$core$IFn$_invoke$arity$1 = G__37219__1;
G__37219.cljs$core$IFn$_invoke$arity$2 = G__37219__2;
return G__37219;
})()
);

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var temp__5821__auto__ = cljs.core.next(self__.front);
if(temp__5821__auto__){
var f1 = temp__5821__auto__;
return (new cljs.core.PersistentQueueSeq(self__.meta,f1,self__.rear,null));
} else {
if((!((self__.rear == null)))){
return (new cljs.core.PersistentQueueSeq(self__.meta,self__.rear,null,null));
} else {
return null;
}
}
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var temp__5821__auto__ = cljs.core.next(self__.front);
if(temp__5821__auto__){
var f1 = temp__5821__auto__;
return (new cljs.core.PersistentQueueSeq(self__.meta,f1,self__.rear,null));
} else {
if((self__.rear == null)){
return coll__$1.cljs$core$IEmptyableCollection$_empty$arity$1(null, );
} else {
return (new cljs.core.PersistentQueueSeq(self__.meta,self__.rear,null,null));
}
}
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentQueueSeq(new_meta,self__.front,self__.rear,self__.__hash));
}
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.PersistentQueueSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"front","front",117022539,null),new cljs.core.Symbol(null,"rear","rear",-900164830,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentQueueSeq.cljs$lang$type = true);

(cljs.core.PersistentQueueSeq.cljs$lang$ctorStr = "cljs.core/PersistentQueueSeq");

(cljs.core.PersistentQueueSeq.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/PersistentQueueSeq");
}));

/**
 * Positional factory function for cljs.core/PersistentQueueSeq.
 */
cljs.core.__GT_PersistentQueueSeq = (function cljs$core$__GT_PersistentQueueSeq(meta,front,rear,__hash){
return (new cljs.core.PersistentQueueSeq(meta,front,rear,__hash));
});

(cljs.core.PersistentQueueSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.PersistentQueue = (function (meta,count,front,rear,__hash){
this.meta = meta;
this.count = count;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 139264;
this.cljs$lang$protocol_mask$partition0$ = 31858766;
});
(cljs.core.PersistentQueue.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentQueue.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
}));

(cljs.core.PersistentQueue.prototype.indexOf = (function() {
var G__37257 = null;
var G__37257__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__37257__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__37257 = function(x,start){
switch(arguments.length){
case 1:
return G__37257__1.call(this,x);
case 2:
return G__37257__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__37257.cljs$core$IFn$_invoke$arity$1 = G__37257__1;
G__37257.cljs$core$IFn$_invoke$arity$2 = G__37257__2;
return G__37257;
})()
);

(cljs.core.PersistentQueue.prototype.lastIndexOf = (function() {
var G__37259 = null;
var G__37259__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(self__.count.cljs$core$IFn$_invoke$arity$1 ? self__.count.cljs$core$IFn$_invoke$arity$1(coll) : self__.count.call(null, coll)));
});
var G__37259__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__37259 = function(x,start){
switch(arguments.length){
case 1:
return G__37259__1.call(this,x);
case 2:
return G__37259__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__37259.cljs$core$IFn$_invoke$arity$1 = G__37259__1;
G__37259.cljs$core$IFn$_invoke$arity$2 = G__37259__2;
return G__37259;
})()
);

(cljs.core.PersistentQueue.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueueIter(self__.front,cljs.core._iterator(self__.rear)));
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(self__.meta,self__.count,self__.front,self__.rear,self__.__hash));
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
var temp__5821__auto__ = cljs.core.next(self__.front);
if(temp__5821__auto__){
var f1 = temp__5821__auto__;
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),f1,self__.rear,null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),cljs.core.seq(self__.rear),cljs.core.PersistentVector.EMPTY,null));
}
} else {
return coll__$1;
}
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentQueue.EMPTY,self__.meta);
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.rest(cljs.core.seq(coll__$1));
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var rear__$1 = cljs.core.seq(self__.rear);
if(cljs.core.truth_((function (){var or__5002__auto__ = self__.front;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return rear__$1;
}
})())){
return (new cljs.core.PersistentQueueSeq(null,self__.front,cljs.core.seq(rear__$1),null));
} else {
return null;
}
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentQueue(new_meta,self__.count,self__.front,self__.rear,self__.__hash));
}
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),self__.front,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__5002__auto__ = self__.rear;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),o),null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(self__.front,o),cljs.core.PersistentVector.EMPTY,null));
}
}));

(cljs.core.PersistentQueue.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"front","front",117022539,null),new cljs.core.Symbol(null,"rear","rear",-900164830,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentQueue.cljs$lang$type = true);

(cljs.core.PersistentQueue.cljs$lang$ctorStr = "cljs.core/PersistentQueue");

(cljs.core.PersistentQueue.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/PersistentQueue");
}));

/**
 * Positional factory function for cljs.core/PersistentQueue.
 */
cljs.core.__GT_PersistentQueue = (function cljs$core$__GT_PersistentQueue(meta,count,front,rear,__hash){
return (new cljs.core.PersistentQueue(meta,count,front,rear,__hash));
});

(cljs.core.PersistentQueue.EMPTY = (new cljs.core.PersistentQueue(null,(0),null,cljs.core.PersistentVector.EMPTY,cljs.core.empty_ordered_hash)));
(cljs.core.PersistentQueue.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IEquiv}
*/
cljs.core.NeverEquiv = (function (){
this.cljs$lang$protocol_mask$partition0$ = 2097152;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.NeverEquiv.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
}));

(cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return false;
}));

(cljs.core.NeverEquiv.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
}));

(cljs.core.NeverEquiv.cljs$lang$type = true);

(cljs.core.NeverEquiv.cljs$lang$ctorStr = "cljs.core/NeverEquiv");

(cljs.core.NeverEquiv.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/NeverEquiv");
}));

/**
 * Positional factory function for cljs.core/NeverEquiv.
 */
cljs.core.__GT_NeverEquiv = (function cljs$core$__GT_NeverEquiv(){
return (new cljs.core.NeverEquiv());
});

cljs.core.never_equiv = (new cljs.core.NeverEquiv());
/**
 * Test map equivalence. Returns true if x equals y, otherwise returns false.
 */
cljs.core.equiv_map = (function cljs$core$equiv_map(x,y){
return cljs.core.boolean$(((((cljs.core.map_QMARK_(y)) && ((!(cljs.core.record_QMARK_(y))))))?(((cljs.core.count(x) === cljs.core.count(y)))?(((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition0$ & (1048576))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IKVReduce$))))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IKVReduce,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IKVReduce,x)))?cljs.core.reduce_kv((function (_,k,v){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y,k,cljs.core.never_equiv),v)){
return true;
} else {
return cljs.core.reduced(false);
}
}),true,x):cljs.core.every_QMARK_((function (xkv){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y,cljs.core.first(xkv),cljs.core.never_equiv),cljs.core.second(xkv));
}),x)):null):null));
});
cljs.core.scan_array = (function cljs$core$scan_array(incr,k,array){
var len = array.length;
var i = (0);
while(true){
if((i < len)){
if((k === (array[i]))){
return i;
} else {
var G__37348 = (i + incr);
i = G__37348;
continue;
}
} else {
return null;
}
break;
}
});
cljs.core.obj_map_compare_keys = (function cljs$core$obj_map_compare_keys(a,b){
var a__$1 = cljs.core.hash(a);
var b__$1 = cljs.core.hash(b);
if((a__$1 < b__$1)){
return (-1);
} else {
if((a__$1 > b__$1)){
return (1);
} else {
return (0);

}
}
});
cljs.core.obj_map__GT_hash_map = (function cljs$core$obj_map__GT_hash_map(m,k,v){
var ks = m.keys;
var len = ks.length;
var so = m.strobj;
var mm = cljs.core.meta(m);
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var k__$1 = (ks[i]);
var G__37352 = (i + (1));
var G__37353 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k__$1,cljs.core.goog$module$goog$object.get(so,k__$1));
i = G__37352;
out = G__37353;
continue;
} else {
return cljs.core._with_meta(cljs.core.persistent_BANG_(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k,v)),mm);
}
break;
}
});
cljs.core.obj_clone = (function cljs$core$obj_clone(obj,ks){
var new_obj = ({});
var l = ks.length;
var i_37357 = (0);
while(true){
if((i_37357 < l)){
var k_37364 = (ks[i_37357]);
cljs.core.goog$module$goog$object.set(new_obj,k_37364,cljs.core.goog$module$goog$object.get(obj,k_37364));

var G__37365 = (i_37357 + (1));
i_37357 = G__37365;
continue;
} else {
}
break;
}

return new_obj;
});

/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.ObjMap = (function (meta,keys,strobj,update_count,__hash){
this.meta = meta;
this.keys = keys;
this.strobj = strobj;
this.update_count = update_count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 4;
});
(cljs.core.ObjMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.ObjMap.prototype.cljs$core$IFind$_find$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(((typeof k === 'string') && ((!((cljs.core.scan_array((1),k,self__.keys) == null)))))){
return (new cljs.core.MapEntry(k,(self__.strobj[k]),null));
} else {
return null;
}
}));

(cljs.core.ObjMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.ObjMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
}));

(cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null, k,null);
}));

(cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(((typeof k === 'string') && ((!((cljs.core.scan_array((1),k,self__.keys) == null)))))){
return (self__.strobj[k]);
} else {
return not_found;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.keys.length;
var keys__$1 = self__.keys.sort(cljs.core.obj_map_compare_keys);
var init__$1 = init;
while(true){
if(cljs.core.seq(keys__$1)){
var k = cljs.core.first(keys__$1);
var init__$2 = (function (){var G__33842 = init__$1;
var G__33843 = k;
var G__33844 = (self__.strobj[k]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__33842,G__33843,G__33844) : f.call(null, G__33842,G__33843,G__33844));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__37374 = cljs.core.rest(keys__$1);
var G__37375 = init__$2;
keys__$1 = G__37374;
init__$1 = G__37375;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.keys.length;
}));

(cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
}));

(cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.transient$(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1));
}));

(cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.ObjMap.EMPTY,self__.meta);
}));

(cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(((typeof k === 'string') && ((!((cljs.core.scan_array((1),k,self__.keys) == null)))))){
var new_keys = cljs.core.aclone(self__.keys);
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
new_keys.splice(cljs.core.scan_array((1),k,new_keys),(1));

delete new_strobj[k];

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
} else {
return coll__$1;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'string'){
if((((self__.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD)) || ((self__.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD)))){
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
} else {
if((!((cljs.core.scan_array((1),k,self__.keys) == null)))){
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
cljs.core.goog$module$goog$object.set(new_strobj,k,v);

return (new cljs.core.ObjMap(self__.meta,self__.keys,new_strobj,(self__.update_count + (1)),null));
} else {
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
var new_keys = cljs.core.aclone(self__.keys);
cljs.core.goog$module$goog$object.set(new_strobj,k,v);

new_keys.push(k);

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
}
}
} else {
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(((typeof k === 'string') && ((!((cljs.core.scan_array((1),k,self__.keys) == null)))))){
return true;
} else {
return false;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.keys.length > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__33840_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__33840_SHARP_,(self__.strobj[p1__33840_SHARP_])],null));
}),self__.keys.sort(cljs.core.obj_map_compare_keys));
} else {
return null;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.ObjMap(new_meta,self__.keys,self__.strobj,self__.update_count,self__.__hash));
}
}));

(cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null, cljs.core._nth(entry,(0)),cljs.core._nth(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,coll__$1,entry);
}
}));

(cljs.core.ObjMap.prototype.call = (function (unused__11804__auto__){
var self__ = this;
var self__ = this;
var G__33845 = (arguments.length - (1));
switch (G__33845) {
case (1):
return self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));

break;
case (2):
return self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(cljs.core.ObjMap.prototype.apply = (function (self__,args33841){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args33841)));
}));

(cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
}));

(cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null, k,not_found);
}));

(cljs.core.ObjMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"keys","keys",-1586012071,null),new cljs.core.Symbol(null,"strobj","strobj",1088091283,null),new cljs.core.Symbol(null,"update-count","update-count",-411982269,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ObjMap.cljs$lang$type = true);

(cljs.core.ObjMap.cljs$lang$ctorStr = "cljs.core/ObjMap");

(cljs.core.ObjMap.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/ObjMap");
}));

/**
 * Positional factory function for cljs.core/ObjMap.
 */
cljs.core.__GT_ObjMap = (function cljs$core$__GT_ObjMap(meta,keys,strobj,update_count,__hash){
return (new cljs.core.ObjMap(meta,keys,strobj,update_count,__hash));
});

(cljs.core.ObjMap.EMPTY = (new cljs.core.ObjMap(null,[],({}),(0),cljs.core.empty_unordered_hash)));
(cljs.core.ObjMap.HASHMAP_THRESHOLD = (8));
(cljs.core.ObjMap.fromObject = (function (ks,obj){
return (new cljs.core.ObjMap(null,ks,obj,(0),null));
}));

/**
* @constructor
*/
cljs.core.RecordIter = (function (i,record,base_count,fields,ext_map_iter){
this.i = i;
this.record = record;
this.base_count = base_count;
this.fields = fields;
this.ext_map_iter = ext_map_iter;
});
(cljs.core.RecordIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var or__5002__auto__ = (self__.i < self__.base_count);
if(or__5002__auto__){
return or__5002__auto__;
} else {
return self__.ext_map_iter.hasNext();
}
}));

(cljs.core.RecordIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if((self__.i < self__.base_count)){
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.fields,self__.i);
(self__.i = (self__.i + (1)));

return (new cljs.core.MapEntry(k,cljs.core._lookup(self__.record,k),null));
} else {
return self__.ext_map_iter.next();
}
}));

(cljs.core.RecordIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.RecordIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"record","record",861424668,null),new cljs.core.Symbol(null,"base-count","base-count",-1180647182,null),new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.Symbol(null,"ext-map-iter","ext-map-iter",-1215982757,null)], null);
}));

(cljs.core.RecordIter.cljs$lang$type = true);

(cljs.core.RecordIter.cljs$lang$ctorStr = "cljs.core/RecordIter");

(cljs.core.RecordIter.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/RecordIter");
}));

/**
 * Positional factory function for cljs.core/RecordIter.
 */
cljs.core.__GT_RecordIter = (function cljs$core$__GT_RecordIter(i,record,base_count,fields,ext_map_iter){
return (new cljs.core.RecordIter(i,record,base_count,fields,ext_map_iter));
});


/**
* @constructor
*/
cljs.core.ES6EntriesIterator = (function (s){
this.s = s;
});
(cljs.core.ES6EntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if((!((self__.s == null)))){
var vec__33848 = cljs.core.first(self__.s);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33848,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33848,(1),null);
(self__.s = cljs.core.next(self__.s));

return ({"value": [k,v], "done": false});
} else {
return ({"value": null, "done": true});
}
}));

(cljs.core.ES6EntriesIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ES6EntriesIterator.cljs$lang$type = true);

(cljs.core.ES6EntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6EntriesIterator");

(cljs.core.ES6EntriesIterator.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/ES6EntriesIterator");
}));

/**
 * Positional factory function for cljs.core/ES6EntriesIterator.
 */
cljs.core.__GT_ES6EntriesIterator = (function cljs$core$__GT_ES6EntriesIterator(s){
return (new cljs.core.ES6EntriesIterator(s));
});

cljs.core.es6_entries_iterator = (function cljs$core$es6_entries_iterator(coll){
return (new cljs.core.ES6EntriesIterator(cljs.core.seq(coll)));
});

/**
* @constructor
*/
cljs.core.ES6SetEntriesIterator = (function (s){
this.s = s;
});
(cljs.core.ES6SetEntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if((!((self__.s == null)))){
var x = cljs.core.first(self__.s);
(self__.s = cljs.core.next(self__.s));

return ({"value": [x,x], "done": false});
} else {
return ({"value": null, "done": true});
}
}));

(cljs.core.ES6SetEntriesIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ES6SetEntriesIterator.cljs$lang$type = true);

(cljs.core.ES6SetEntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6SetEntriesIterator");

(cljs.core.ES6SetEntriesIterator.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/ES6SetEntriesIterator");
}));

/**
 * Positional factory function for cljs.core/ES6SetEntriesIterator.
 */
cljs.core.__GT_ES6SetEntriesIterator = (function cljs$core$__GT_ES6SetEntriesIterator(s){
return (new cljs.core.ES6SetEntriesIterator(s));
});

cljs.core.es6_set_entries_iterator = (function cljs$core$es6_set_entries_iterator(coll){
return (new cljs.core.ES6SetEntriesIterator(cljs.core.seq(coll)));
});
cljs.core.array_index_of_nil_QMARK_ = (function cljs$core$array_index_of_nil_QMARK_(arr){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((arr[i]) == null)){
return i;
} else {
var G__37445 = (i + (2));
i = G__37445;
continue;

}
}
break;
}
});
cljs.core.array_index_of_keyword_QMARK_ = (function cljs$core$array_index_of_keyword_QMARK_(arr,k){
var len = arr.length;
var kstr = k.fqn;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((((arr[i]) instanceof cljs.core.Keyword)) && ((kstr === (arr[i]).fqn)))){
return i;
} else {
var G__37447 = (i + (2));
i = G__37447;
continue;

}
}
break;
}
});
cljs.core.array_index_of_symbol_QMARK_ = (function cljs$core$array_index_of_symbol_QMARK_(arr,k){
var len = arr.length;
var kstr = k.str;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((((arr[i]) instanceof cljs.core.Symbol)) && ((kstr === (arr[i]).str)))){
return i;
} else {
var G__37451 = (i + (2));
i = G__37451;
continue;

}
}
break;
}
});
cljs.core.array_index_of_identical_QMARK_ = (function cljs$core$array_index_of_identical_QMARK_(arr,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((k === (arr[i]))){
return i;
} else {
var G__37452 = (i + (2));
i = G__37452;
continue;

}
}
break;
}
});
cljs.core.array_index_of_equiv_QMARK_ = (function cljs$core$array_index_of_equiv_QMARK_(arr,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(arr[i]))){
return i;
} else {
var G__37455 = (i + (2));
i = G__37455;
continue;

}
}
break;
}
});
cljs.core.array_index_of = (function cljs$core$array_index_of(arr,k){
if((k instanceof cljs.core.Keyword)){
return cljs.core.array_index_of_keyword_QMARK_(arr,k);
} else {
if(((typeof k === 'string') || (typeof k === 'number'))){
return cljs.core.array_index_of_identical_QMARK_(arr,k);
} else {
if((k instanceof cljs.core.Symbol)){
return cljs.core.array_index_of_symbol_QMARK_(arr,k);
} else {
if((k == null)){
return cljs.core.array_index_of_nil_QMARK_(arr);
} else {
return cljs.core.array_index_of_equiv_QMARK_(arr,k);

}
}
}
}
});
cljs.core.array_map_index_of = (function cljs$core$array_map_index_of(m,k){
return cljs.core.array_index_of(m.arr,k);
});
cljs.core.array_extend_kv = (function cljs$core$array_extend_kv(arr,k,v){
var l = arr.length;
var narr = (new Array((l + (2))));
var i_37463 = (0);
while(true){
if((i_37463 < l)){
(narr[i_37463] = (arr[i_37463]));

var G__37465 = (i_37463 + (1));
i_37463 = G__37465;
continue;
} else {
}
break;
}

(narr[l] = k);

(narr[(l + (1))] = v);

return narr;
});
cljs.core.array_map_extend_kv = (function cljs$core$array_map_extend_kv(m,k,v){
return cljs.core.array_extend_kv(m.arr,k,v);
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.MapEntry = (function (key,val,__hash){
this.key = key;
this.val = val;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 166619935;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.MapEntry.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.MapEntry.prototype.cljs$core$IFind$_find$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
var G__33852 = k;
switch (G__33852) {
case (0):
return (new cljs.core.MapEntry((0),self__.key,null));

break;
case (1):
return (new cljs.core.MapEntry((1),self__.val,null));

break;
default:
return null;

}
}));

(cljs.core.MapEntry.prototype.indexOf = (function() {
var G__37471 = null;
var G__37471__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__37471__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__37471 = function(x,start){
switch(arguments.length){
case 1:
return G__37471__1.call(this,x);
case 2:
return G__37471__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__37471.cljs$core$IFn$_invoke$arity$1 = G__37471__1;
G__37471.cljs$core$IFn$_invoke$arity$2 = G__37471__2;
return G__37471;
})()
);

(cljs.core.MapEntry.prototype.lastIndexOf = (function() {
var G__37472 = null;
var G__37472__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__37472__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__37472 = function(x,start){
switch(arguments.length){
case 1:
return G__37472__1.call(this,x);
case 2:
return G__37472__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__37472.cljs$core$IFn$_invoke$arity$1 = G__37472__1;
G__37472.cljs$core$IFn$_invoke$arity$2 = G__37472__2;
return G__37472;
})()
);

(cljs.core.MapEntry.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null, k,null);
}));

(cljs.core.MapEntry.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null, k,not_found);
}));

(cljs.core.MapEntry.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
throw (new Error("Index out of bounds"));

}
}
}));

(cljs.core.MapEntry.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
}));

(cljs.core.MapEntry.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null, n,v);
}));

(cljs.core.MapEntry.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.MapEntry.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
}));

(cljs.core.MapEntry.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
}));

(cljs.core.MapEntry.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.MapEntry.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.MapEntry.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
}));

(cljs.core.MapEntry.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.val,self__.key],(0),null));
}));

(cljs.core.MapEntry.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.MapEntry.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.MapEntry.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.MapEntry.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
}));

(cljs.core.MapEntry.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
}));

(cljs.core.MapEntry.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
}));

(cljs.core.MapEntry.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return (((k === (0))) || ((k === (1))));
}));

(cljs.core.MapEntry.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.key,self__.val],(0),null));
}));

(cljs.core.MapEntry.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
}));

(cljs.core.MapEntry.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
}));

(cljs.core.MapEntry.prototype.call = (function (unused__11804__auto__){
var self__ = this;
var self__ = this;
var G__33853 = (arguments.length - (1));
switch (G__33853) {
case (1):
return self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));

break;
case (2):
return self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(cljs.core.MapEntry.prototype.apply = (function (self__,args33851){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args33851)));
}));

(cljs.core.MapEntry.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$2(null, k);
}));

(cljs.core.MapEntry.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$3(null, k,not_found);
}));

(cljs.core.MapEntry.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"val","val",1769233139,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.MapEntry.cljs$lang$type = true);

(cljs.core.MapEntry.cljs$lang$ctorStr = "cljs.core/MapEntry");

(cljs.core.MapEntry.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/MapEntry");
}));

/**
 * Positional factory function for cljs.core/MapEntry.
 */
cljs.core.__GT_MapEntry = (function cljs$core$__GT_MapEntry(key,val,__hash){
return (new cljs.core.MapEntry(key,val,__hash));
});

/**
 * Returns true if x satisfies IMapEntry
 */
cljs.core.map_entry_QMARK_ = (function cljs$core$map_entry_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (2048))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMapEntry$)))){
return true;
} else {
return false;
}
} else {
return false;
}
});

/**
* @constructor
 * @implements {cljs.core.IDrop}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentArrayMapSeq = (function (arr,i,_meta){
this.arr = arr;
this.i = i;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 262144;
});
(cljs.core.PersistentArrayMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentArrayMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
}));

(cljs.core.PersistentArrayMapSeq.prototype.indexOf = (function() {
var G__37519 = null;
var G__37519__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__37519__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__37519 = function(x,start){
switch(arguments.length){
case 1:
return G__37519__1.call(this,x);
case 2:
return G__37519__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__37519.cljs$core$IFn$_invoke$arity$1 = G__37519__1;
G__37519.cljs$core$IFn$_invoke$arity$2 = G__37519__2;
return G__37519;
})()
);

(cljs.core.PersistentArrayMapSeq.prototype.lastIndexOf = (function() {
var G__37520 = null;
var G__37520__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__37520__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__37520 = function(x,start){
switch(arguments.length){
case 1:
return G__37520__1.call(this,x);
case 2:
return G__37520__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__37520.cljs$core$IFn$_invoke$arity$1 = G__37520__1;
G__37520.cljs$core$IFn$_invoke$arity$2 = G__37520__2;
return G__37520;
})()
);

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),null));
} else {
return null;
}
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return ((self__.arr.length - self__.i) / (2));
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.MapEntry((self__.arr[self__.i]),(self__.arr[(self__.i + (1))]),null));
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__._meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentArrayMapSeq(self__.arr,self__.i,new_meta));
}
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IDrop$_drop$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if((n < coll__$1.cljs$core$ICounted$_count$arity$1(null, ))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + ((2) * n)),null));
} else {
return null;
}
}));

(cljs.core.PersistentArrayMapSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
}));

(cljs.core.PersistentArrayMapSeq.cljs$lang$type = true);

(cljs.core.PersistentArrayMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapSeq");

(cljs.core.PersistentArrayMapSeq.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/PersistentArrayMapSeq");
}));

/**
 * Positional factory function for cljs.core/PersistentArrayMapSeq.
 */
cljs.core.__GT_PersistentArrayMapSeq = (function cljs$core$__GT_PersistentArrayMapSeq(arr,i,_meta){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
});

(cljs.core.PersistentArrayMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));
cljs.core.persistent_array_map_seq = (function cljs$core$persistent_array_map_seq(arr,i,_meta){
if((i <= (arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
} else {
return null;
}
});


/**
* @constructor
*/
cljs.core.PersistentArrayMapIterator = (function (arr,i,cnt){
this.arr = arr;
this.i = i;
this.cnt = cnt;
});
(cljs.core.PersistentArrayMapIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.cnt);
}));

(cljs.core.PersistentArrayMapIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (new cljs.core.MapEntry((self__.arr[self__.i]),(self__.arr[(self__.i + (1))]),null));
(self__.i = (self__.i + (2)));

return ret;
}));

(cljs.core.PersistentArrayMapIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null)], null);
}));

(cljs.core.PersistentArrayMapIterator.cljs$lang$type = true);

(cljs.core.PersistentArrayMapIterator.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapIterator");

(cljs.core.PersistentArrayMapIterator.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/PersistentArrayMapIterator");
}));

/**
 * Positional factory function for cljs.core/PersistentArrayMapIterator.
 */
cljs.core.__GT_PersistentArrayMapIterator = (function cljs$core$__GT_PersistentArrayMapIterator(arr,i,cnt){
return (new cljs.core.PersistentArrayMapIterator(arr,i,cnt));
});


/**
* @constructor
 * @implements {cljs.core.IDrop}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentArrayMap = (function (meta,cnt,arr,__hash){
this.meta = meta;
this.cnt = cnt;
this.arr = arr;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16647951;
this.cljs$lang$protocol_mask$partition1$ = 401412;
});
(cljs.core.PersistentArrayMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentArrayMap.prototype.cljs$core$IFind$_find$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
return null;
} else {
return (new cljs.core.MapEntry((self__.arr[idx]),(self__.arr[(idx + (1))]),null));
}
}));

(cljs.core.PersistentArrayMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentArrayMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
}));

(cljs.core.PersistentArrayMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.keys.call(null, coll)));
}));

(cljs.core.PersistentArrayMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
}));

(cljs.core.PersistentArrayMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.vals.call(null, coll)));
}));

(cljs.core.PersistentArrayMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
}));

(cljs.core.PersistentArrayMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null, k,not_found);
}));

(cljs.core.PersistentArrayMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__33856 = cljs.core.seq(coll);
var chunk__33857 = null;
var count__33858 = (0);
var i__33859 = (0);
while(true){
if((i__33859 < count__33858)){
var vec__33866 = chunk__33857.cljs$core$IIndexed$_nth$arity$2(null, i__33859);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33866,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33866,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null, v,k));


var G__37532 = seq__33856;
var G__37533 = chunk__33857;
var G__37534 = count__33858;
var G__37535 = (i__33859 + (1));
seq__33856 = G__37532;
chunk__33857 = G__37533;
count__33858 = G__37534;
i__33859 = G__37535;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__33856);
if(temp__5823__auto__){
var seq__33856__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__33856__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__33856__$1);
var G__37538 = cljs.core.chunk_rest(seq__33856__$1);
var G__37539 = c__5525__auto__;
var G__37540 = cljs.core.count(c__5525__auto__);
var G__37541 = (0);
seq__33856 = G__37538;
chunk__33857 = G__37539;
count__33858 = G__37540;
i__33859 = G__37541;
continue;
} else {
var vec__33869 = cljs.core.first(seq__33856__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33869,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33869,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null, v,k));


var G__37543 = cljs.core.next(seq__33856__$1);
var G__37544 = null;
var G__37545 = (0);
var G__37546 = (0);
seq__33856 = G__37543;
chunk__33857 = G__37544;
count__33858 = G__37545;
i__33859 = G__37546;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null, k,null);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var G__33872 = init__$1;
var G__33873 = (self__.arr[i]);
var G__33874 = (self__.arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__33872,G__33873,G__33874) : f.call(null, G__33872,G__33873,G__33874));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__37548 = (i + (2));
var G__37549 = init__$2;
i = G__37548;
init__$1 = G__37549;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.PersistentArrayMapIterator(self__.arr,(0),(self__.cnt * (2))));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,self__.arr,self__.__hash));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if(((cljs.core.map_QMARK_(other)) && ((!(cljs.core.record_QMARK_(other)))))){
var alen = self__.arr.length;
var other__$1 = other;
if((self__.cnt === other__$1.cljs$core$ICounted$_count$arity$1(null, ))){
var i = (0);
while(true){
if((i < alen)){
var v = other__$1.cljs$core$ILookup$_lookup$arity$3(null, (self__.arr[i]),cljs.core.lookup_sentinel);
if((!((v === cljs.core.lookup_sentinel)))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[(i + (1))]),v)){
var G__37555 = (i + (2));
i = G__37555;
continue;
} else {
return false;
}
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return false;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientArrayMap(({}),self__.arr.length,cljs.core.aclone(self__.arr)));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentArrayMap.EMPTY,self__.meta);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1,f);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1,f,start);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx >= (0))){
var len = self__.arr.length;
var new_len = (len - (2));
if((new_len === (0))){
return coll__$1.cljs$core$IEmptyableCollection$_empty$arity$1(null, );
} else {
var new_arr = (new Array(new_len));
var s = (0);
var d = (0);
while(true){
if((s >= len)){
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt - (1)),new_arr,null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(self__.arr[s]))){
var G__37562 = (s + (2));
var G__37563 = d;
s = G__37562;
d = G__37563;
continue;
} else {
(new_arr[d] = (self__.arr[s]));

(new_arr[(d + (1))] = (self__.arr[(s + (1))]));

var G__37564 = (s + (2));
var G__37565 = (d + (2));
s = G__37564;
d = G__37565;
continue;

}
}
break;
}
}
} else {
return coll__$1;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
if((self__.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr__$1 = cljs.core.array_map_extend_kv(coll__$1,k,v);
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt + (1)),arr__$1,null));
} else {
return cljs.core._with_meta(cljs.core._assoc(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1),k,v),self__.meta);
}
} else {
if((v === (self__.arr[(idx + (1))]))){
return coll__$1;
} else {
var arr__$1 = (function (){var G__33877 = cljs.core.aclone(self__.arr);
(G__33877[(idx + (1))] = v);

return G__33877;
})();
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,arr__$1,null));

}
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return (!((cljs.core.array_map_index_of(coll__$1,k) === (-1))));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.persistent_array_map_seq(self__.arr,(0),null);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentArrayMap(new_meta,self__.cnt,self__.arr,self__.__hash));
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null, cljs.core._nth(entry,(0)),cljs.core._nth(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__37567 = cljs.core._assoc(ret,cljs.core._nth(e,(0)),cljs.core._nth(e,(1)));
var G__37568 = cljs.core.next(es);
ret = G__37567;
es = G__37568;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
}));

(cljs.core.PersistentArrayMap.prototype.call = (function (unused__11804__auto__){
var self__ = this;
var self__ = this;
var G__33878 = (arguments.length - (1));
switch (G__33878) {
case (1):
return self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));

break;
case (2):
return self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(cljs.core.PersistentArrayMap.prototype.apply = (function (self__,args33855){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args33855)));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null, k,not_found);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IDrop$_drop$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
var temp__5827__auto__ = coll__$1.cljs$core$ISeqable$_seq$arity$1(null, );
if((temp__5827__auto__ == null)){
return null;
} else {
var s = temp__5827__auto__;
return cljs.core._drop(s,n);
}
}));

(cljs.core.PersistentArrayMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentArrayMap.cljs$lang$type = true);

(cljs.core.PersistentArrayMap.cljs$lang$ctorStr = "cljs.core/PersistentArrayMap");

(cljs.core.PersistentArrayMap.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/PersistentArrayMap");
}));

/**
 * Positional factory function for cljs.core/PersistentArrayMap.
 */
cljs.core.__GT_PersistentArrayMap = (function cljs$core$__GT_PersistentArrayMap(meta,cnt,arr,__hash){
return (new cljs.core.PersistentArrayMap(meta,cnt,arr,__hash));
});

(cljs.core.PersistentArrayMap.EMPTY = (new cljs.core.PersistentArrayMap(null,(0),[],cljs.core.empty_unordered_hash)));
(cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = (8));
(cljs.core.PersistentArrayMap.fromArray = (function (arr,no_clone,no_check){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var arr__$2 = ((no_check)?arr__$1:(function (){var ret = [];
var i_37571 = (0);
while(true){
if((i_37571 < arr__$1.length)){
var k_37572 = (arr__$1[i_37571]);
var v_37573 = (arr__$1[(i_37571 + (1))]);
var idx_37574 = cljs.core.array_index_of(ret,k_37572);
if((idx_37574 === (-1))){
ret.push(k_37572);

ret.push(v_37573);
} else {
}

var G__37575 = (i_37571 + (2));
i_37571 = G__37575;
continue;
} else {
}
break;
}

return ret;
})());
var cnt = (arr__$2.length / (2));
return (new cljs.core.PersistentArrayMap(null,cnt,arr__$2,null));
}));
(cljs.core.PersistentArrayMap.createWithCheck = (function (arr){
var ret = [];
var i_37576 = (0);
while(true){
if((i_37576 < arr.length)){
var k_37577 = (arr[i_37576]);
var v_37578 = (arr[(i_37576 + (1))]);
var idx_37579 = cljs.core.array_index_of(ret,k_37577);
if((idx_37579 === (-1))){
var G__33879_37580 = ret;
G__33879_37580.push(k_37577);

G__33879_37580.push(v_37578);

} else {
throw (new Error(["Duplicate key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k_37577)].join('')));
}

var G__37581 = (i_37576 + (2));
i_37576 = G__37581;
continue;
} else {
}
break;
}

var cnt = (arr.length / (2));
return (new cljs.core.PersistentArrayMap(null,cnt,arr,null));
}));
cljs.core.key_test = (function cljs$core$key_test(key,other){
if((key === other)){
return true;
} else {
if(cljs.core.keyword_identical_QMARK_(key,other)){
return true;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,other);

}
}
});
cljs.core.pam_dupes_QMARK_ = (function cljs$core$pam_dupes_QMARK_(arr){
var i = (0);
while(true){
if((i < arr.length)){
var dupe_QMARK_ = (function (){var j = (0);
while(true){
if((j < i)){
var or__5002__auto__ = cljs.core.key_test((arr[i]),(arr[j]));
if(or__5002__auto__){
return or__5002__auto__;
} else {
var G__37582 = ((2) + j);
j = G__37582;
continue;
}
} else {
return false;
}
break;
}
})();
var or__5002__auto__ = dupe_QMARK_;
if(or__5002__auto__){
return or__5002__auto__;
} else {
var G__37583 = ((2) + i);
i = G__37583;
continue;
}
} else {
return false;
}
break;
}
});
cljs.core.pam_new_size = (function cljs$core$pam_new_size(arr){
var i = (0);
var n = (0);
while(true){
if((i < arr.length)){
var dupe_QMARK_ = (function (){var j = (0);
while(true){
if((j < i)){
var or__5002__auto__ = cljs.core.key_test((arr[i]),(arr[j]));
if(or__5002__auto__){
return or__5002__auto__;
} else {
var G__37584 = ((2) + j);
j = G__37584;
continue;
}
} else {
return false;
}
break;
}
})();
var G__37585 = ((2) + i);
var G__37586 = ((dupe_QMARK_)?n:(n + (2)));
i = G__37585;
n = G__37586;
continue;
} else {
return n;
}
break;
}
});
cljs.core.pam_grow_seed_array = (function cljs$core$pam_grow_seed_array(seed,trailing){
var seed_cnt = (seed.length - (1));
var extra_kvs = cljs.core.seq(trailing);
var ret = (new Array((seed_cnt + ((2) * cljs.core.count(extra_kvs)))));
var ret__$1 = cljs.core.array_copy(seed,(0),ret,(0),seed_cnt);
var i = seed_cnt;
var extra_kvs__$1 = extra_kvs;
while(true){
if(extra_kvs__$1){
var kv = cljs.core.first(extra_kvs__$1);
(ret__$1[i] = cljs.core._key(kv));

(ret__$1[(i + (1))] = cljs.core._val(kv));

var G__37589 = ((2) + seed_cnt);
var G__37590 = cljs.core.next(extra_kvs__$1);
i = G__37589;
extra_kvs__$1 = G__37590;
continue;
} else {
return ret__$1;
}
break;
}
});
(cljs.core.PersistentArrayMap.createAsIfByAssoc = (function (init){
var len = init.length;
var has_trailing_QMARK_ = ((1) === (len & (1)));
if((!(((has_trailing_QMARK_) || (cljs.core.pam_dupes_QMARK_(init)))))){
return (new cljs.core.PersistentArrayMap(null,(len / (2)),init,null));
} else {
return cljs.core.PersistentArrayMap.createAsIfByAssocComplexPath(init,has_trailing_QMARK_);
}
}));
(cljs.core.PersistentArrayMap.createAsIfByAssocComplexPath = (function (init,has_trailing_QMARK_){
var init__$1 = ((has_trailing_QMARK_)?cljs.core.pam_grow_seed_array(init,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(init[(init.length - (1))]))):init);
var n = cljs.core.pam_new_size(init__$1);
var len = init__$1.length;
if((n < len)){
var nodups = (new Array(n));
var i_37591 = (0);
var m_37592 = (0);
while(true){
if((i_37591 < len)){
var dupe_QMARK__37593 = (function (){var j = (0);
while(true){
if((j < m_37592)){
var or__5002__auto__ = cljs.core.key_test((init__$1[i_37591]),(init__$1[j]));
if(or__5002__auto__){
return or__5002__auto__;
} else {
var G__37594 = ((2) + j);
j = G__37594;
continue;
}
} else {
return false;
}
break;
}
})();
if((!(dupe_QMARK__37593))){
var j_37595 = (function (){var j_37595 = (len - (2));
while(true){
if((j_37595 >= i_37591)){
if(cljs.core.key_test((init__$1[i_37591]),(init__$1[j_37595]))){
return j_37595;
} else {
var G__37596 = (j_37595 - (2));
j_37595 = G__37596;
continue;
}
} else {
return j_37595;
}
break;
}
})();
(nodups[m_37592] = (init__$1[i_37591]));

(nodups[(m_37592 + (1))] = (init__$1[(j_37595 + (1))]));

var G__37597 = ((2) + i_37591);
var G__37598 = ((2) + m_37592);
i_37591 = G__37597;
m_37592 = G__37598;
continue;
} else {
var G__37599 = ((2) + i_37591);
var G__37600 = m_37592;
i_37591 = G__37599;
m_37592 = G__37600;
continue;
}
} else {
}
break;
}

return (new cljs.core.PersistentArrayMap(null,(nodups.length / (2)),nodups,null));
} else {
return (new cljs.core.PersistentArrayMap(null,(init__$1.length / (2)),init__$1,null));
}
}));
(cljs.core.PersistentArrayMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ITransientMap}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientArrayMap = (function (editable_QMARK_,len,arr){
this.editable_QMARK_ = editable_QMARK_;
this.len = len;
this.arr = arr;
this.cljs$lang$protocol_mask$partition0$ = 259;
this.cljs$lang$protocol_mask$partition1$ = 56;
});
(cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
return cljs.core.quot(self__.len,(2));
} else {
throw (new Error("count after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.cljs$core$ILookup$_lookup$arity$3(null, k,null);
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
var idx = cljs.core.array_map_index_of(tcoll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
} else {
throw (new Error("lookup after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
if(cljs.core.map_entry_QMARK_(o)){
return tcoll__$1.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null, (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.key.call(null, o)),(cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.val.call(null, o)));
} else {
if(cljs.core.vector_QMARK_(o)){
return tcoll__$1.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null, (o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1((0)) : o.call(null, (0))),(o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1((1)) : o.call(null, (1))));
} else {
var es = cljs.core.seq(o);
var tcoll__$2 = tcoll__$1;
while(true){
var temp__5821__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__5821__auto__)){
var e = temp__5821__auto__;
var G__37605 = cljs.core.next(es);
var G__37606 = cljs.core._assoc_BANG_(tcoll__$2,(cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.key.call(null, e)),(cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.val.call(null, e)));
es = G__37605;
tcoll__$2 = G__37606;
continue;
} else {
return tcoll__$2;
}
break;
}

}
}
} else {
throw (new Error("conj! after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
(self__.editable_QMARK_ = false);

return (new cljs.core.PersistentArrayMap(null,cljs.core.quot(self__.len,(2)),self__.arr,null));
} else {
throw (new Error("persistent! called twice"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx === (-1))){
if(((self__.len + (2)) <= ((2) * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD))){
(self__.len = (self__.len + (2)));

self__.arr.push(key);

self__.arr.push(val);

return tcoll__$1;
} else {
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3((cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2 ? cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2(self__.len,self__.arr) : cljs.core.array__GT_transient_hash_map.call(null, self__.len,self__.arr)),key,val);
}
} else {
if((val === (self__.arr[(idx + (1))]))){
return tcoll__$1;
} else {
(self__.arr[(idx + (1))] = val);

return tcoll__$1;
}
}
} else {
throw (new Error("assoc! after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx >= (0))){
(self__.arr[idx] = (self__.arr[(self__.len - (2))]));

(self__.arr[(idx + (1))] = (self__.arr[(self__.len - (1))]));

var G__33881_37610 = self__.arr;
G__33881_37610.pop();

G__33881_37610.pop();


(self__.len = (self__.len - (2)));
} else {
}

return tcoll__$1;
} else {
throw (new Error("dissoc! after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.call = (function (unused__11804__auto__){
var self__ = this;
var self__ = this;
var G__33882 = (arguments.length - (1));
switch (G__33882) {
case (1):
return self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));

break;
case (2):
return self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(cljs.core.TransientArrayMap.prototype.apply = (function (self__,args33880){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args33880)));
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (key){
var self__ = this;
var tcoll = this;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null, key,null);
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (key,not_found){
var self__ = this;
var tcoll = this;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null, key,not_found);
}));

(cljs.core.TransientArrayMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"editable?","editable?",-164945806,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"len","len",-1230778691,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"arr","arr",2115492975,null)], null);
}));

(cljs.core.TransientArrayMap.cljs$lang$type = true);

(cljs.core.TransientArrayMap.cljs$lang$ctorStr = "cljs.core/TransientArrayMap");

(cljs.core.TransientArrayMap.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/TransientArrayMap");
}));

/**
 * Positional factory function for cljs.core/TransientArrayMap.
 */
cljs.core.__GT_TransientArrayMap = (function cljs$core$__GT_TransientArrayMap(editable_QMARK_,len,arr){
return (new cljs.core.TransientArrayMap(editable_QMARK_,len,arr));
});

cljs.core.array__GT_transient_hash_map = (function cljs$core$array__GT_transient_hash_map(len,arr){
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
var i = (0);
while(true){
if((i < len)){
var G__37612 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,(arr[i]),(arr[(i + (1))]));
var G__37613 = (i + (2));
out = G__37612;
i = G__37613;
continue;
} else {
return out;
}
break;
}
});

/**
* @constructor
*/
cljs.core.Box = (function (val){
this.val = val;
});

(cljs.core.Box.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Box.cljs$lang$type = true);

(cljs.core.Box.cljs$lang$ctorStr = "cljs.core/Box");

(cljs.core.Box.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/Box");
}));

/**
 * Positional factory function for cljs.core/Box.
 */
cljs.core.__GT_Box = (function cljs$core$__GT_Box(val){
return (new cljs.core.Box(val));
});



cljs.core.mask = (function cljs$core$mask(hash,shift){
return ((hash >>> shift) & (31));
});
cljs.core.clone_and_set = (function cljs$core$clone_and_set(var_args){
var G__33884 = arguments.length;
switch (G__33884) {
case 3:
return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3 = (function (arr,i,a){
var G__33885 = cljs.core.aclone(arr);
(G__33885[i] = a);

return G__33885;
}));

(cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5 = (function (arr,i,a,j,b){
var G__33886 = cljs.core.aclone(arr);
(G__33886[i] = a);

(G__33886[j] = b);

return G__33886;
}));

(cljs.core.clone_and_set.cljs$lang$maxFixedArity = 5);

cljs.core.remove_pair = (function cljs$core$remove_pair(arr,i){
var new_arr = (new Array((arr.length - (2))));
cljs.core.array_copy(arr,(0),new_arr,(0),((2) * i));

cljs.core.array_copy(arr,((2) * (i + (1))),new_arr,((2) * i),(new_arr.length - ((2) * i)));

return new_arr;
});
cljs.core.bitmap_indexed_node_index = (function cljs$core$bitmap_indexed_node_index(bitmap,bit){
return cljs.core.bit_count((bitmap & (bit - (1))));
});
cljs.core.bitpos = (function cljs$core$bitpos(hash,shift){
return ((1) << ((hash >>> shift) & 0x01f));
});
cljs.core.edit_and_set = (function cljs$core$edit_and_set(var_args){
var G__33888 = arguments.length;
switch (G__33888) {
case 4:
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4 = (function (inode,edit,i,a){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

return editable;
}));

(cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6 = (function (inode,edit,i,a,j,b){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

(editable.arr[j] = b);

return editable;
}));

(cljs.core.edit_and_set.cljs$lang$maxFixedArity = 6);

cljs.core.inode_kv_reduce = (function cljs$core$inode_kv_reduce(arr,f,init){
var len = arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var k = (arr[i]);
if((!((k == null)))){
var G__33889 = init__$1;
var G__33890 = k;
var G__33891 = (arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__33889,G__33890,G__33891) : f.call(null, G__33889,G__33890,G__33891));
} else {
var node = (arr[(i + (1))]);
if((!((node == null)))){
return node.kv_reduce(f,init__$1);
} else {
return init__$1;
}
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return init__$2;
} else {
var G__37623 = (i + (2));
var G__37624 = init__$2;
i = G__37623;
init__$1 = G__37624;
continue;
}
} else {
return init__$1;
}
break;
}
});

/**
* @constructor
*/
cljs.core.NodeIterator = (function (arr,i,next_entry,next_iter){
this.arr = arr;
this.i = i;
this.next_entry = next_entry;
this.next_iter = next_iter;
});
(cljs.core.NodeIterator.prototype.advance = (function (){
var self__ = this;
var this$ = this;
var len = self__.arr.length;
while(true){
if((self__.i < len)){
var key = (self__.arr[self__.i]);
var node_or_val = (self__.arr[(self__.i + (1))]);
var found = (((!((key == null))))?(self__.next_entry = (new cljs.core.MapEntry(key,node_or_val,null))):(((!((node_or_val == null))))?(function (){var new_iter = cljs.core._iterator(node_or_val);
if(new_iter.hasNext()){
return (self__.next_iter = new_iter);
} else {
return false;
}
})():false
));
(self__.i = (self__.i + (2)));

if(found){
return true;
} else {
continue;
}
} else {
return false;
}
break;
}
}));

(cljs.core.NodeIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
var or__5002__auto__ = (!((self__.next_entry == null)));
if(or__5002__auto__){
return or__5002__auto__;
} else {
var or__5002__auto____$1 = (!((self__.next_iter == null)));
if(or__5002__auto____$1){
return or__5002__auto____$1;
} else {
return this$.advance();
}
}
}));

(cljs.core.NodeIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if((!((self__.next_entry == null)))){
var ret = self__.next_entry;
(self__.next_entry = null);

return ret;
} else {
if((!((self__.next_iter == null)))){
var ret = self__.next_iter.next();
if(self__.next_iter.hasNext()){
} else {
(self__.next_iter = null);
}

return ret;
} else {
if(this$.advance()){
return this$.next();
} else {
throw (new Error("No such element"));

}
}
}
}));

(cljs.core.NodeIterator.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.NodeIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"next-entry","next-entry",1091342476,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"next-iter","next-iter",1526626239,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.NodeIterator.cljs$lang$type = true);

(cljs.core.NodeIterator.cljs$lang$ctorStr = "cljs.core/NodeIterator");

(cljs.core.NodeIterator.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/NodeIterator");
}));

/**
 * Positional factory function for cljs.core/NodeIterator.
 */
cljs.core.__GT_NodeIterator = (function cljs$core$__GT_NodeIterator(arr,i,next_entry,next_iter){
return (new cljs.core.NodeIterator(arr,i,next_entry,next_iter));
});


/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.BitmapIndexedNode = (function (edit,bitmap,arr){
this.edit = edit;
this.bitmap = bitmap;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 131072;
this.cljs$lang$protocol_mask$partition0$ = 0;
});
(cljs.core.BitmapIndexedNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var n = cljs.core.bit_count(self__.bitmap);
var new_arr = (new Array((((n < (0)))?(4):((2) * (n + (1))))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * n));

return (new cljs.core.BitmapIndexedNode(e,self__.bitmap,new_arr));
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
if((!((n == null)))){
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
} else {
if((self__.bitmap === bit)){
return null;
} else {
return inode.edit_and_remove_pair(edit__$1,bit,idx);

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
(removed_leaf_QMARK_.val = true);

return inode.edit_and_remove_pair(edit__$1,bit,idx);
} else {
return inode;

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = (function (e,bit,i){
var self__ = this;
var inode = this;
if((self__.bitmap === bit)){
return null;
} else {
var editable = inode.ensure_editable(e);
var earr = editable.arr;
var len = earr.length;
(editable.bitmap = (bit ^ editable.bitmap));

cljs.core.array_copy(earr,((2) * (i + (1))),earr,((2) * i),(len - ((2) * (i + (1)))));

(earr[(len - (2))] = null);

(earr[(len - (1))] = null);

return editable;
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr) : cljs.core.create_inode_seq.call(null, self__.arr));
}));

(cljs.core.BitmapIndexedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
}));

(cljs.core.BitmapIndexedNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return val_or_node;
} else {
return not_found;

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((((2) * n) < self__.arr.length)){
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
(added_leaf_QMARK_.val = true);

cljs.core.array_copy_downward(earr,((2) * idx),earr,((2) * (idx + (1))),((2) * (n - idx)));

(earr[((2) * idx)] = key);

(earr[(((2) * idx) + (1))] = val);

(editable.bitmap = (editable.bitmap | bit));

return editable;
} else {
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_37632 = (0);
var j_37633 = (0);
while(true){
if((i_37632 < (32))){
if((((self__.bitmap >>> i_37632) & (1)) === (0))){
var G__37634 = (i_37632 + (1));
var G__37635 = j_37633;
i_37632 = G__37634;
j_37633 = G__37635;
continue;
} else {
(nodes[i_37632] = (((!(((self__.arr[j_37633]) == null))))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),cljs.core.hash((self__.arr[j_37633])),(self__.arr[j_37633]),(self__.arr[(j_37633 + (1))]),added_leaf_QMARK_):(self__.arr[(j_37633 + (1))])));

var G__37636 = (i_37632 + (1));
var G__37637 = (j_37633 + (2));
i_37632 = G__37636;
j_37633 = G__37637;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(edit__$1,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (4)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

(added_leaf_QMARK_.val = true);

var editable = inode.ensure_editable(edit__$1);
(editable.arr = new_arr);

(editable.bitmap = (editable.bitmap | bit));

return editable;

}
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),val);
}
} else {
(added_leaf_QMARK_.val = true);

return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * idx),null,(((2) * idx) + (1)),(function (){var G__33892 = edit__$1;
var G__33893 = (shift + (5));
var G__33894 = key_or_nil;
var G__33895 = val_or_node;
var G__33896 = hash;
var G__33897 = key;
var G__33898 = val;
return (cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(G__33892,G__33893,G__33894,G__33895,G__33896,G__33897,G__33898) : cljs.core.create_node.call(null, G__33892,G__33893,G__33894,G__33895,G__33896,G__33897,G__33898));
})());

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_37639 = (0);
var j_37640 = (0);
while(true){
if((i_37639 < (32))){
if((((self__.bitmap >>> i_37639) & (1)) === (0))){
var G__37641 = (i_37639 + (1));
var G__37642 = j_37640;
i_37639 = G__37641;
j_37640 = G__37642;
continue;
} else {
(nodes[i_37639] = (((!(((self__.arr[j_37640]) == null))))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),cljs.core.hash((self__.arr[j_37640])),(self__.arr[j_37640]),(self__.arr[(j_37640 + (1))]),added_leaf_QMARK_):(self__.arr[(j_37640 + (1))])));

var G__37644 = (i_37639 + (1));
var G__37645 = (j_37640 + (2));
i_37639 = G__37644;
j_37640 = G__37645;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(null,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

(added_leaf_QMARK_.val = true);

return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap | bit),new_arr));
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),val)));
}
} else {
(added_leaf_QMARK_.val = true);

return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(self__.arr,((2) * idx),null,(((2) * idx) + (1)),(function (){var G__33899 = (shift + (5));
var G__33900 = key_or_nil;
var G__33901 = val_or_node;
var G__33902 = hash;
var G__33903 = key;
var G__33904 = val;
return (cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$6(G__33899,G__33900,G__33901,G__33902,G__33903,G__33904) : cljs.core.create_node.call(null, G__33899,G__33900,G__33901,G__33902,G__33903,G__33904));
})())));

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_find((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return (new cljs.core.MapEntry(key_or_nil,val_or_node,null));
} else {
return not_found;

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without((shift + (5)),hash,key);
if((n === val_or_node)){
return inode;
} else {
if((!((n == null)))){
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
} else {
if((self__.bitmap === bit)){
return null;
} else {
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((self__.bitmap === bit)){
return null;
} else {
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));
}
} else {
return inode;

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeIterator(self__.arr,(0),null,null));
}));

(cljs.core.BitmapIndexedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),cljs.core.with_meta(new cljs.core.Symbol(null,"bitmap","bitmap",501334601,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.BitmapIndexedNode.cljs$lang$type = true);

(cljs.core.BitmapIndexedNode.cljs$lang$ctorStr = "cljs.core/BitmapIndexedNode");

(cljs.core.BitmapIndexedNode.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/BitmapIndexedNode");
}));

/**
 * Positional factory function for cljs.core/BitmapIndexedNode.
 */
cljs.core.__GT_BitmapIndexedNode = (function cljs$core$__GT_BitmapIndexedNode(edit,bitmap,arr){
return (new cljs.core.BitmapIndexedNode(edit,bitmap,arr));
});

(cljs.core.BitmapIndexedNode.EMPTY = (new cljs.core.BitmapIndexedNode(null,(0),[])));
cljs.core.pack_array_node = (function cljs$core$pack_array_node(array_node,edit,idx){
var arr = array_node.arr;
var len = arr.length;
var new_arr = (new Array(((2) * (array_node.cnt - (1)))));
var i = (0);
var j = (1);
var bitmap = (0);
while(true){
if((i < len)){
if((((!((i === idx)))) && ((!(((arr[i]) == null)))))){
(new_arr[j] = (arr[i]));

var G__37655 = (i + (1));
var G__37656 = (j + (2));
var G__37657 = (bitmap | ((1) << i));
i = G__37655;
j = G__37656;
bitmap = G__37657;
continue;
} else {
var G__37658 = (i + (1));
var G__37659 = j;
var G__37660 = bitmap;
i = G__37658;
j = G__37659;
bitmap = G__37660;
continue;
}
} else {
return (new cljs.core.BitmapIndexedNode(edit,bitmap,new_arr));
}
break;
}
});

/**
* @constructor
*/
cljs.core.ArrayNodeIterator = (function (arr,i,next_iter){
this.arr = arr;
this.i = i;
this.next_iter = next_iter;
});
(cljs.core.ArrayNodeIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
var len = self__.arr.length;
while(true){
if((!((((!((self__.next_iter == null)))) && (self__.next_iter.hasNext()))))){
if((self__.i < len)){
var node = (self__.arr[self__.i]);
(self__.i = (self__.i + (1)));

if((!((node == null)))){
(self__.next_iter = cljs.core._iterator(node));
} else {
}

continue;
} else {
return false;
}
} else {
return true;
}
break;
}
}));

(cljs.core.ArrayNodeIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(this$.hasNext()){
return self__.next_iter.next();
} else {
throw (new Error("No such element"));
}
}));

(cljs.core.ArrayNodeIterator.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.ArrayNodeIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"next-iter","next-iter",1526626239,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ArrayNodeIterator.cljs$lang$type = true);

(cljs.core.ArrayNodeIterator.cljs$lang$ctorStr = "cljs.core/ArrayNodeIterator");

(cljs.core.ArrayNodeIterator.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/ArrayNodeIterator");
}));

/**
 * Positional factory function for cljs.core/ArrayNodeIterator.
 */
cljs.core.__GT_ArrayNodeIterator = (function cljs$core$__GT_ArrayNodeIterator(arr,i,next_iter){
return (new cljs.core.ArrayNodeIterator(arr,i,next_iter));
});


/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.ArrayNode = (function (edit,cnt,arr){
this.edit = edit;
this.cnt = cnt;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 131072;
this.cljs$lang$protocol_mask$partition0$ = 0;
});
(cljs.core.ArrayNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
return (new cljs.core.ArrayNode(e,self__.cnt,cljs.core.aclone(self__.arr)));
}
}));

(cljs.core.ArrayNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return inode;
} else {
var n = node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,edit__$1,idx);
} else {
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
(editable.cnt = (editable.cnt - (1)));

return editable;
}
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);

}
}
}
}));

(cljs.core.ArrayNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
return (cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(self__.arr) : cljs.core.create_array_node_seq.call(null, self__.arr));
}));

(cljs.core.ArrayNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var node = (self__.arr[i]);
if((!((node == null)))){
var init__$2 = node.kv_reduce(f,init__$1);
if(cljs.core.reduced_QMARK_(init__$2)){
return init__$2;
} else {
var G__37676 = (i + (1));
var G__37677 = init__$2;
i = G__37676;
init__$1 = G__37677;
continue;
}
} else {
var G__37678 = (i + (1));
var G__37679 = init__$1;
i = G__37678;
init__$1 = G__37679;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.ArrayNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((!((node == null)))){
return node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
}));

(cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));
(editable.cnt = (editable.cnt + (1)));

return editable;
} else {
var n = node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
}
}
}));

(cljs.core.ArrayNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return (new cljs.core.ArrayNode(null,(self__.cnt + (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_))));
} else {
var n = node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
}
}));

(cljs.core.ArrayNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((!((node == null)))){
return node.inode_find((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
}));

(cljs.core.ArrayNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((!((node == null)))){
var n = node.inode_without((shift + (5)),hash,key);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,null,idx);
} else {
return (new cljs.core.ArrayNode(null,(self__.cnt - (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));

}
}
} else {
return inode;
}
}));

(cljs.core.ArrayNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ArrayNodeIterator(self__.arr,(0),null));
}));

(cljs.core.ArrayNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),cljs.core.with_meta(new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ArrayNode.cljs$lang$type = true);

(cljs.core.ArrayNode.cljs$lang$ctorStr = "cljs.core/ArrayNode");

(cljs.core.ArrayNode.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/ArrayNode");
}));

/**
 * Positional factory function for cljs.core/ArrayNode.
 */
cljs.core.__GT_ArrayNode = (function cljs$core$__GT_ArrayNode(edit,cnt,arr){
return (new cljs.core.ArrayNode(edit,cnt,arr));
});

cljs.core.hash_collision_node_find_index = (function cljs$core$hash_collision_node_find_index(arr,cnt,key){
var lim = ((2) * cnt);
var i = (0);
while(true){
if((i < lim)){
if(cljs.core.key_test(key,(arr[i]))){
return i;
} else {
var G__37689 = (i + (2));
i = G__37689;
continue;
}
} else {
return (-1);
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.HashCollisionNode = (function (edit,collision_hash,cnt,arr){
this.edit = edit;
this.collision_hash = collision_hash;
this.cnt = cnt;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 131072;
this.cljs$lang$protocol_mask$partition0$ = 0;
});
(cljs.core.HashCollisionNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var new_arr = (new Array(((2) * (self__.cnt + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * self__.cnt));

return (new cljs.core.HashCollisionNode(e,self__.collision_hash,self__.cnt,new_arr));
}
}));

(cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
(removed_leaf_QMARK_.val = true);

if((self__.cnt === (1))){
return null;
} else {
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
(earr[idx] = (earr[(((2) * self__.cnt) - (2))]));

(earr[(idx + (1))] = (earr[(((2) * self__.cnt) - (1))]));

(earr[(((2) * self__.cnt) - (1))] = null);

(earr[(((2) * self__.cnt) - (2))] = null);

(editable.cnt = (editable.cnt - (1)));

return editable;
}
}
}));

(cljs.core.HashCollisionNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr) : cljs.core.create_inode_seq.call(null, self__.arr));
}));

(cljs.core.HashCollisionNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
}));

(cljs.core.HashCollisionNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return (self__.arr[(idx + (1))]);
} else {
return not_found;

}
}
}));

(cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
if((self__.arr.length > ((2) * self__.cnt))){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * self__.cnt),key,(((2) * self__.cnt) + (1)),val);
(added_leaf_QMARK_.val = true);

(editable.cnt = (editable.cnt + (1)));

return editable;
} else {
var len = self__.arr.length;
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

(added_leaf_QMARK_.val = true);

return inode.ensure_editable_array(edit__$1,(self__.cnt + (1)),new_arr);
}
} else {
if(((self__.arr[(idx + (1))]) === val)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(idx + (1)),val);
}
}
} else {
return (new cljs.core.BitmapIndexedNode(edit__$1,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode,null,null])).inode_assoc_BANG_(edit__$1,shift,hash,key,val,added_leaf_QMARK_);
}
}));

(cljs.core.HashCollisionNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
var len = ((2) * self__.cnt);
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

(added_leaf_QMARK_.val = true);

return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt + (1)),new_arr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[(idx + (1))]),val)){
return inode;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(idx + (1)),val)));
}
}
} else {
return (new cljs.core.BitmapIndexedNode(null,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode])).inode_assoc(shift,hash,key,val,added_leaf_QMARK_);
}
}));

(cljs.core.HashCollisionNode.prototype.ensure_editable_array = (function (e,count,array){
var self__ = this;
var inode = this;
if((e === self__.edit)){
(self__.arr = array);

(self__.cnt = count);

return inode;
} else {
return (new cljs.core.HashCollisionNode(self__.edit,self__.collision_hash,count,array));
}
}));

(cljs.core.HashCollisionNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return (new cljs.core.MapEntry((self__.arr[idx]),(self__.arr[(idx + (1))]),null));
} else {
return not_found;

}
}
}));

(cljs.core.HashCollisionNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
if((self__.cnt === (1))){
return null;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt - (1)),cljs.core.remove_pair(self__.arr,cljs.core.quot(idx,(2)))));

}
}
}));

(cljs.core.HashCollisionNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeIterator(self__.arr,(0),null,null));
}));

(cljs.core.HashCollisionNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),cljs.core.with_meta(new cljs.core.Symbol(null,"collision-hash","collision-hash",-35831342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.HashCollisionNode.cljs$lang$type = true);

(cljs.core.HashCollisionNode.cljs$lang$ctorStr = "cljs.core/HashCollisionNode");

(cljs.core.HashCollisionNode.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/HashCollisionNode");
}));

/**
 * Positional factory function for cljs.core/HashCollisionNode.
 */
cljs.core.__GT_HashCollisionNode = (function cljs$core$__GT_HashCollisionNode(edit,collision_hash,cnt,arr){
return (new cljs.core.HashCollisionNode(edit,collision_hash,cnt,arr));
});

cljs.core.create_node = (function cljs$core$create_node(var_args){
var G__33906 = arguments.length;
switch (G__33906) {
case 6:
return cljs.core.create_node.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs.core.create_node.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 = (function (shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc(shift,key2hash,key2,val2,added_leaf_QMARK_);
}
}));

(cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 = (function (edit,shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit,shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc_BANG_(edit,shift,key2hash,key2,val2,added_leaf_QMARK_);
}
}));

(cljs.core.create_node.cljs$lang$maxFixedArity = 7);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.NodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.NodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.NodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
}));

(cljs.core.NodeSeq.prototype.indexOf = (function() {
var G__37723 = null;
var G__37723__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__37723__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__37723 = function(x,start){
switch(arguments.length){
case 1:
return G__37723__1.call(this,x);
case 2:
return G__37723__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__37723.cljs$core$IFn$_invoke$arity$1 = G__37723__1;
G__37723.cljs$core$IFn$_invoke$arity$2 = G__37723__2;
return G__37723;
})()
);

(cljs.core.NodeSeq.prototype.lastIndexOf = (function() {
var G__37724 = null;
var G__37724__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__37724__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__37724 = function(x,start){
switch(arguments.length){
case 1:
return G__37724__1.call(this,x);
case 2:
return G__37724__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__37724.cljs$core$IFn$_invoke$arity$1 = G__37724__1;
G__37724.cljs$core$IFn$_invoke$arity$2 = G__37724__2;
return G__37724;
})()
);

(cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.NodeSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
var G__33907 = self__.nodes;
var G__33908 = (self__.i + (2));
var G__33909 = null;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__33907,G__33908,G__33909) : cljs.core.create_inode_seq.call(null, G__33907,G__33908,G__33909));
} else {
var G__33910 = self__.nodes;
var G__33911 = self__.i;
var G__33912 = cljs.core.next(self__.s);
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__33910,G__33911,G__33912) : cljs.core.create_inode_seq.call(null, G__33910,G__33911,G__33912));
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
return (new cljs.core.MapEntry((self__.nodes[self__.i]),(self__.nodes[(self__.i + (1))]),null));
} else {
return cljs.core.first(self__.s);
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var ret = (((self__.s == null))?(function (){var G__33913 = self__.nodes;
var G__33914 = (self__.i + (2));
var G__33915 = null;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__33913,G__33914,G__33915) : cljs.core.create_inode_seq.call(null, G__33913,G__33914,G__33915));
})():(function (){var G__33916 = self__.nodes;
var G__33917 = self__.i;
var G__33918 = cljs.core.next(self__.s);
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__33916,G__33917,G__33918) : cljs.core.create_inode_seq.call(null, G__33916,G__33917,G__33918));
})());
if((!((ret == null)))){
return ret;
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.NodeSeq(new_meta,self__.nodes,self__.i,self__.s,self__.__hash));
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.NodeSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"nodes","nodes",-459054278,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"s","s",-948495851,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.NodeSeq.cljs$lang$type = true);

(cljs.core.NodeSeq.cljs$lang$ctorStr = "cljs.core/NodeSeq");

(cljs.core.NodeSeq.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/NodeSeq");
}));

/**
 * Positional factory function for cljs.core/NodeSeq.
 */
cljs.core.__GT_NodeSeq = (function cljs$core$__GT_NodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.NodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.NodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));
cljs.core.create_inode_seq = (function cljs$core$create_inode_seq(var_args){
var G__33920 = arguments.length;
switch (G__33920) {
case 1:
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 = (function (nodes){
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(nodes,(0),null);
}));

(cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 = (function (nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
if((!(((nodes[j]) == null)))){
return (new cljs.core.NodeSeq(null,nodes,j,null,null));
} else {
var temp__5821__auto__ = (nodes[(j + (1))]);
if(cljs.core.truth_(temp__5821__auto__)){
var node = temp__5821__auto__;
var temp__5821__auto____$1 = node.inode_seq();
if(cljs.core.truth_(temp__5821__auto____$1)){
var node_seq = temp__5821__auto____$1;
return (new cljs.core.NodeSeq(null,nodes,(j + (2)),node_seq,null));
} else {
var G__37740 = (j + (2));
j = G__37740;
continue;
}
} else {
var G__37741 = (j + (2));
j = G__37741;
continue;
}
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.NodeSeq(null,nodes,i,s,null));
}
}));

(cljs.core.create_inode_seq.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ArrayNodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ArrayNodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.ArrayNodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
}));

(cljs.core.ArrayNodeSeq.prototype.indexOf = (function() {
var G__37742 = null;
var G__37742__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__37742__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__37742 = function(x,start){
switch(arguments.length){
case 1:
return G__37742__1.call(this,x);
case 2:
return G__37742__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__37742.cljs$core$IFn$_invoke$arity$1 = G__37742__1;
G__37742.cljs$core$IFn$_invoke$arity$2 = G__37742__2;
return G__37742;
})()
);

(cljs.core.ArrayNodeSeq.prototype.lastIndexOf = (function() {
var G__37743 = null;
var G__37743__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__37743__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__37743 = function(x,start){
switch(arguments.length){
case 1:
return G__37743__1.call(this,x);
case 2:
return G__37743__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__37743.cljs$core$IFn$_invoke$arity$1 = G__37743__1;
G__37743.cljs$core$IFn$_invoke$arity$2 = G__37743__2;
return G__37743;
})()
);

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var G__33921 = self__.nodes;
var G__33922 = self__.i;
var G__33923 = cljs.core.next(self__.s);
return (cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3(G__33921,G__33922,G__33923) : cljs.core.create_array_node_seq.call(null, G__33921,G__33922,G__33923));
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.s);
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var ret = (function (){var G__33924 = self__.nodes;
var G__33925 = self__.i;
var G__33926 = cljs.core.next(self__.s);
return (cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3(G__33924,G__33925,G__33926) : cljs.core.create_array_node_seq.call(null, G__33924,G__33925,G__33926));
})();
if((!((ret == null)))){
return ret;
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.ArrayNodeSeq(new_meta,self__.nodes,self__.i,self__.s,self__.__hash));
}
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.ArrayNodeSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"nodes","nodes",-459054278,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"s","s",-948495851,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ArrayNodeSeq.cljs$lang$type = true);

(cljs.core.ArrayNodeSeq.cljs$lang$ctorStr = "cljs.core/ArrayNodeSeq");

(cljs.core.ArrayNodeSeq.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/ArrayNodeSeq");
}));

/**
 * Positional factory function for cljs.core/ArrayNodeSeq.
 */
cljs.core.__GT_ArrayNodeSeq = (function cljs$core$__GT_ArrayNodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.ArrayNodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));
cljs.core.create_array_node_seq = (function cljs$core$create_array_node_seq(var_args){
var G__33928 = arguments.length;
switch (G__33928) {
case 1:
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 = (function (nodes){
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3(nodes,(0),null);
}));

(cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3 = (function (nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
var temp__5821__auto__ = (nodes[j]);
if(cljs.core.truth_(temp__5821__auto__)){
var nj = temp__5821__auto__;
var temp__5821__auto____$1 = nj.inode_seq();
if(cljs.core.truth_(temp__5821__auto____$1)){
var ns = temp__5821__auto____$1;
return (new cljs.core.ArrayNodeSeq(null,nodes,(j + (1)),ns,null));
} else {
var G__37745 = (j + (1));
j = G__37745;
continue;
}
} else {
var G__37746 = (j + (1));
j = G__37746;
continue;
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.ArrayNodeSeq(null,nodes,i,s,null));
}
}));

(cljs.core.create_array_node_seq.cljs$lang$maxFixedArity = 3);


/**
* @constructor
*/
cljs.core.HashMapIter = (function (nil_val,root_iter,seen){
this.nil_val = nil_val;
this.root_iter = root_iter;
this.seen = seen;
});
(cljs.core.HashMapIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (((!(self__.seen))) || (self__.root_iter.hasNext()));
}));

(cljs.core.HashMapIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if((!(self__.seen))){
(self__.seen = true);

return (new cljs.core.MapEntry(null,self__.nil_val,null));
} else {
return self__.root_iter.next();
}
}));

(cljs.core.HashMapIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.HashMapIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nil-val","nil-val",-513933559,null),new cljs.core.Symbol(null,"root-iter","root-iter",1974672108,null),cljs.core.with_meta(new cljs.core.Symbol(null,"seen","seen",1121531738,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.HashMapIter.cljs$lang$type = true);

(cljs.core.HashMapIter.cljs$lang$ctorStr = "cljs.core/HashMapIter");

(cljs.core.HashMapIter.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/HashMapIter");
}));

/**
 * Positional factory function for cljs.core/HashMapIter.
 */
cljs.core.__GT_HashMapIter = (function cljs$core$__GT_HashMapIter(nil_val,root_iter,seen){
return (new cljs.core.HashMapIter(nil_val,root_iter,seen));
});


/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentHashMap = (function (meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
this.meta = meta;
this.cnt = cnt;
this.root = root;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 139268;
});
(cljs.core.PersistentHashMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentHashMap.prototype.cljs$core$IFind$_find$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return (new cljs.core.MapEntry(null,self__.nil_val,null));
} else {
return null;
}
} else {
if((self__.root == null)){
return null;
} else {
return self__.root.inode_find((0),cljs.core.hash(k),k,null);

}
}
}));

(cljs.core.PersistentHashMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentHashMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
}));

(cljs.core.PersistentHashMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.keys.call(null, coll)));
}));

(cljs.core.PersistentHashMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
}));

(cljs.core.PersistentHashMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.vals.call(null, coll)));
}));

(cljs.core.PersistentHashMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
}));

(cljs.core.PersistentHashMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null, k,not_found);
}));

(cljs.core.PersistentHashMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__33930 = cljs.core.seq(coll);
var chunk__33931 = null;
var count__33932 = (0);
var i__33933 = (0);
while(true){
if((i__33933 < count__33932)){
var vec__33940 = chunk__33931.cljs$core$IIndexed$_nth$arity$2(null, i__33933);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33940,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33940,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null, v,k));


var G__37750 = seq__33930;
var G__37751 = chunk__33931;
var G__37752 = count__33932;
var G__37753 = (i__33933 + (1));
seq__33930 = G__37750;
chunk__33931 = G__37751;
count__33932 = G__37752;
i__33933 = G__37753;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__33930);
if(temp__5823__auto__){
var seq__33930__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__33930__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__33930__$1);
var G__37754 = cljs.core.chunk_rest(seq__33930__$1);
var G__37755 = c__5525__auto__;
var G__37756 = cljs.core.count(c__5525__auto__);
var G__37757 = (0);
seq__33930 = G__37754;
chunk__33931 = G__37755;
count__33932 = G__37756;
i__33933 = G__37757;
continue;
} else {
var vec__33943 = cljs.core.first(seq__33930__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33943,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33943,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null, v,k));


var G__37758 = cljs.core.next(seq__33930__$1);
var G__37759 = null;
var G__37760 = (0);
var G__37761 = (0);
seq__33930 = G__37758;
chunk__33931 = G__37759;
count__33932 = G__37760;
i__33933 = G__37761;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null, k,null);
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);

}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var init__$1 = ((self__.has_nil_QMARK_)?(f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(init,null,self__.nil_val) : f.call(null, init,null,self__.nil_val)):init);
if(cljs.core.reduced_QMARK_(init__$1)){
return cljs.core.deref(init__$1);
} else {
if((!((self__.root == null)))){
return cljs.core.unreduced(self__.root.kv_reduce(f,init__$1));
} else {
return init__$1;

}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var root_iter = ((self__.root)?cljs.core._iterator(self__.root):cljs.core.nil_iter());
if(self__.has_nil_QMARK_){
return (new cljs.core.HashMapIter(self__.nil_val,root_iter,false));
} else {
return root_iter;
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashMap(self__.meta,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashMap(({}),self__.root,self__.cnt,self__.has_nil_QMARK_,self__.nil_val));
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentHashMap.EMPTY,self__.meta);
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),self__.root,false,null,null));
} else {
return coll__$1;
}
} else {
if((self__.root == null)){
return coll__$1;
} else {
var new_root = self__.root.inode_without((0),cljs.core.hash(k),k);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}

}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(((self__.has_nil_QMARK_) && ((v === self__.nil_val)))){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((self__.has_nil_QMARK_)?self__.cnt:(self__.cnt + (1))),self__.root,true,v,null));
}
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var new_root = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc((0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((added_leaf_QMARK_.val)?(self__.cnt + (1)):self__.cnt),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
return self__.has_nil_QMARK_;
} else {
if((self__.root == null)){
return false;
} else {
return (!((self__.root.inode_lookup((0),cljs.core.hash(k),k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)));

}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var s = (((!((self__.root == null))))?self__.root.inode_seq():null);
if(self__.has_nil_QMARK_){
return cljs.core.cons((new cljs.core.MapEntry(null,self__.nil_val,null)),s);
} else {
return s;
}
} else {
return null;
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(new_meta,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null, cljs.core._nth(entry,(0)),cljs.core._nth(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__37777 = cljs.core._assoc(ret,cljs.core._nth(e,(0)),cljs.core._nth(e,(1)));
var G__37778 = cljs.core.next(es);
ret = G__37777;
es = G__37778;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
}));

(cljs.core.PersistentHashMap.prototype.call = (function (unused__11804__auto__){
var self__ = this;
var self__ = this;
var G__33948 = (arguments.length - (1));
switch (G__33948) {
case (1):
return self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));

break;
case (2):
return self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(cljs.core.PersistentHashMap.prototype.apply = (function (self__,args33929){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args33929)));
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null, k,not_found);
}));

(cljs.core.PersistentHashMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"root","root",1191874074,null),cljs.core.with_meta(new cljs.core.Symbol(null,"has-nil?","has-nil?",825886722,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null)], null)),new cljs.core.Symbol(null,"nil-val","nil-val",-513933559,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentHashMap.cljs$lang$type = true);

(cljs.core.PersistentHashMap.cljs$lang$ctorStr = "cljs.core/PersistentHashMap");

(cljs.core.PersistentHashMap.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/PersistentHashMap");
}));

/**
 * Positional factory function for cljs.core/PersistentHashMap.
 */
cljs.core.__GT_PersistentHashMap = (function cljs$core$__GT_PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
return (new cljs.core.PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash));
});

(cljs.core.PersistentHashMap.EMPTY = (new cljs.core.PersistentHashMap(null,(0),null,false,null,cljs.core.empty_unordered_hash)));
(cljs.core.PersistentHashMap.fromArray = (function (arr,no_clone){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var len = arr__$1.length;
var i = (0);
var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__37781 = (i + (2));
var G__37782 = cljs.core._assoc_BANG_(ret,(arr__$1[i]),(arr__$1[(i + (1))]));
i = G__37781;
ret = G__37782;
continue;
} else {
return cljs.core._persistent_BANG_(ret);
}
break;
}
}));
(cljs.core.PersistentHashMap.fromArrays = (function (ks,vs){
var len = ks.length;
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
if((vs.length <= i)){
throw (new Error(["No value supplied for key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((ks[i]))].join('')));
} else {
var G__37783 = (i + (1));
var G__37784 = cljs.core._assoc_BANG_(out,(ks[i]),(vs[i]));
i = G__37783;
out = G__37784;
continue;
}
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
}));
(cljs.core.PersistentHashMap.createWithCheck = (function (arr){
var len = arr.length;
var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
var i_37785 = (0);
while(true){
if((i_37785 < len)){
cljs.core._assoc_BANG_(ret,(arr[i_37785]),(arr[(i_37785 + (1))]));

if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core._count(ret),((i_37785 / (2)) + (1)))){
throw (new Error(["Duplicate key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arr[i_37785]))].join('')));
} else {
var G__37787 = (i_37785 + (2));
i_37785 = G__37787;
continue;
}
} else {
}
break;
}

return cljs.core._persistent_BANG_(ret);
}));
(cljs.core.PersistentHashMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ITransientMap}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientHashMap = (function (edit,root,count,has_nil_QMARK_,nil_val){
this.edit = edit;
this.root = root;
this.count = count;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.cljs$lang$protocol_mask$partition0$ = 259;
this.cljs$lang$protocol_mask$partition1$ = 56;
});
(cljs.core.TransientHashMap.prototype.conj_BANG_ = (function (o){
var self__ = this;
var tcoll = this;
if(self__.edit){
if(cljs.core.map_entry_QMARK_(o)){
return tcoll.assoc_BANG_((cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.key.call(null, o)),(cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.val.call(null, o)));
} else {
if(cljs.core.vector_QMARK_(o)){
return tcoll.assoc_BANG_((o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1((0)) : o.call(null, (0))),(o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1((1)) : o.call(null, (1))));
} else {
var es = cljs.core.seq(o);
var tcoll__$1 = tcoll;
while(true){
var temp__5821__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__5821__auto__)){
var e = temp__5821__auto__;
var G__37790 = cljs.core.next(es);
var G__37791 = tcoll__$1.assoc_BANG_((cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.key.call(null, e)),(cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.val.call(null, e)));
es = G__37790;
tcoll__$1 = G__37791;
continue;
} else {
return tcoll__$1;
}
break;
}

}
}
} else {
throw (new Error("conj! after persistent"));
}
}));

(cljs.core.TransientHashMap.prototype.assoc_BANG_ = (function (k,v){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if((self__.nil_val === v)){
} else {
(self__.nil_val = v);
}

if(self__.has_nil_QMARK_){
} else {
(self__.count = (self__.count + (1)));

(self__.has_nil_QMARK_ = true);
}

return tcoll;
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var node = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc_BANG_(self__.edit,(0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((node === self__.root)){
} else {
(self__.root = node);
}

if(added_leaf_QMARK_.val){
(self__.count = (self__.count + (1)));
} else {
}

return tcoll;
}
} else {
throw (new Error("assoc! after persistent!"));
}
}));

(cljs.core.TransientHashMap.prototype.without_BANG_ = (function (k){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if(self__.has_nil_QMARK_){
(self__.has_nil_QMARK_ = false);

(self__.nil_val = null);

(self__.count = (self__.count - (1)));

return tcoll;
} else {
return tcoll;
}
} else {
if((self__.root == null)){
return tcoll;
} else {
var removed_leaf_QMARK_ = (new cljs.core.Box(false));
var node = self__.root.inode_without_BANG_(self__.edit,(0),cljs.core.hash(k),k,removed_leaf_QMARK_);
if((node === self__.root)){
} else {
(self__.root = node);
}

if(removed_leaf_QMARK_.val){
(self__.count = (self__.count - (1)));
} else {
}

return tcoll;
}
}
} else {
throw (new Error("dissoc! after persistent!"));
}
}));

(cljs.core.TransientHashMap.prototype.persistent_BANG_ = (function (){
var self__ = this;
var tcoll = this;
if(self__.edit){
(self__.edit = null);

return (new cljs.core.PersistentHashMap(null,self__.count,self__.root,self__.has_nil_QMARK_,self__.nil_val,null));
} else {
throw (new Error("persistent! called twice"));
}
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.edit){
return self__.count;
} else {
throw (new Error("count after persistent!"));
}
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return null;
}
} else {
if((self__.root == null)){
return null;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k);
}
}
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);
}
}
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.conj_BANG_(val);
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.persistent_BANG_();
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.assoc_BANG_(key,val);
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.without_BANG_(key);
}));

(cljs.core.TransientHashMap.prototype.call = (function (unused__11804__auto__){
var self__ = this;
var self__ = this;
var G__33950 = (arguments.length - (1));
switch (G__33950) {
case (1):
return self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));

break;
case (2):
return self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(cljs.core.TransientHashMap.prototype.apply = (function (self__,args33949){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args33949)));
}));

(cljs.core.TransientHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (key){
var self__ = this;
var tcoll = this;
return tcoll.cljs$core$ILookup$_lookup$arity$2(null, key);
}));

(cljs.core.TransientHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (key,not_found){
var self__ = this;
var tcoll = this;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null, key,not_found);
}));

(cljs.core.TransientHashMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"edit","edit",-1302639,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"has-nil?","has-nil?",825886722,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"nil-val","nil-val",-513933559,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.TransientHashMap.cljs$lang$type = true);

(cljs.core.TransientHashMap.cljs$lang$ctorStr = "cljs.core/TransientHashMap");

(cljs.core.TransientHashMap.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/TransientHashMap");
}));

/**
 * Positional factory function for cljs.core/TransientHashMap.
 */
cljs.core.__GT_TransientHashMap = (function cljs$core$__GT_TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val){
return (new cljs.core.TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val));
});

cljs.core.tree_map_seq_push = (function cljs$core$tree_map_seq_push(node,stack,ascending_QMARK_){
var t = node;
var stack__$1 = stack;
while(true){
if((!((t == null)))){
var G__37803 = ((ascending_QMARK_)?t.left:t.right);
var G__37804 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack__$1,t);
t = G__37803;
stack__$1 = G__37804;
continue;
} else {
return stack__$1;
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentTreeMapSeq = (function (meta,stack,ascending_QMARK_,cnt,__hash){
this.meta = meta;
this.stack = stack;
this.ascending_QMARK_ = ascending_QMARK_;
this.cnt = cnt;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.PersistentTreeMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentTreeMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
}));

(cljs.core.PersistentTreeMapSeq.prototype.indexOf = (function() {
var G__37807 = null;
var G__37807__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__37807__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__37807 = function(x,start){
switch(arguments.length){
case 1:
return G__37807__1.call(this,x);
case 2:
return G__37807__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__37807.cljs$core$IFn$_invoke$arity$1 = G__37807__1;
G__37807.cljs$core$IFn$_invoke$arity$2 = G__37807__2;
return G__37807;
})()
);

(cljs.core.PersistentTreeMapSeq.prototype.lastIndexOf = (function() {
var G__37809 = null;
var G__37809__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__37809__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__37809 = function(x,start){
switch(arguments.length){
case 1:
return G__37809__1.call(this,x);
case 2:
return G__37809__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__37809.cljs$core$IFn$_invoke$arity$1 = G__37809__1;
G__37809.cljs$core$IFn$_invoke$arity$2 = G__37809__2;
return G__37809;
})()
);

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$INext$_next$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var t = cljs.core.first(self__.stack);
var next_stack = cljs.core.tree_map_seq_push(((self__.ascending_QMARK_)?t.right:t.left),cljs.core.next(self__.stack),self__.ascending_QMARK_);
if((next_stack == null)){
return null;
} else {
return (new cljs.core.PersistentTreeMapSeq(null,next_stack,self__.ascending_QMARK_,(self__.cnt - (1)),null));
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt < (0))){
return (cljs.core.count(cljs.core.next(coll__$1)) + (1));
} else {
return self__.cnt;
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.peek(self__.stack);
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var t = cljs.core.first(self__.stack);
var next_stack = cljs.core.tree_map_seq_push(((self__.ascending_QMARK_)?t.right:t.left),cljs.core.next(self__.stack),self__.ascending_QMARK_);
if((!((next_stack == null)))){
return (new cljs.core.PersistentTreeMapSeq(null,next_stack,self__.ascending_QMARK_,(self__.cnt - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMapSeq(new_meta,self__.stack,self__.ascending_QMARK_,self__.cnt,self__.__hash));
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.PersistentTreeMapSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"stack","stack",847125597,null),cljs.core.with_meta(new cljs.core.Symbol(null,"ascending?","ascending?",-1938452653,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null)], null)),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentTreeMapSeq.cljs$lang$type = true);

(cljs.core.PersistentTreeMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentTreeMapSeq");

(cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/PersistentTreeMapSeq");
}));

/**
 * Positional factory function for cljs.core/PersistentTreeMapSeq.
 */
cljs.core.__GT_PersistentTreeMapSeq = (function cljs$core$__GT_PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash){
return (new cljs.core.PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash));
});

(cljs.core.PersistentTreeMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));
cljs.core.create_tree_map_seq = (function cljs$core$create_tree_map_seq(tree,ascending_QMARK_,cnt){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.tree_map_seq_push(tree,null,ascending_QMARK_),ascending_QMARK_,cnt,null));
});

cljs.core.balance_left = (function cljs$core$balance_left(key,val,ins,right){
if((ins instanceof cljs.core.RedNode)){
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,ins.left.blacken(),(new cljs.core.BlackNode(key,val,ins.right,right,null)),null));
} else {
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.right.key,ins.right.val,(new cljs.core.BlackNode(ins.key,ins.val,ins.left,ins.right.left,null)),(new cljs.core.BlackNode(key,val,ins.right.right,right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));
}
});
cljs.core.balance_right = (function cljs$core$balance_right(key,val,left,ins){
if((ins instanceof cljs.core.RedNode)){
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,(new cljs.core.BlackNode(key,val,left,ins.left,null)),ins.right.blacken(),null));
} else {
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.left.key,ins.left.val,(new cljs.core.BlackNode(key,val,left,ins.left.left,null)),(new cljs.core.BlackNode(ins.key,ins.val,ins.left.right,ins.right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));
}
});
cljs.core.balance_left_del = (function cljs$core$balance_left_del(key,val,del,right){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,del.blacken(),right,null));
} else {
if((right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right(key,val,del,right.redden());
} else {
if((((right instanceof cljs.core.RedNode)) && ((right.left instanceof cljs.core.BlackNode)))){
return (new cljs.core.RedNode(right.left.key,right.left.val,(new cljs.core.BlackNode(key,val,del,right.left.left,null)),cljs.core.balance_right(right.key,right.val,right.left.right,right.right.redden()),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.balance_right_del = (function cljs$core$balance_right_del(key,val,left,del){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,left,del.blacken(),null));
} else {
if((left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left(key,val,left.redden(),del);
} else {
if((((left instanceof cljs.core.RedNode)) && ((left.right instanceof cljs.core.BlackNode)))){
return (new cljs.core.RedNode(left.right.key,left.right.val,cljs.core.balance_left(left.key,left.val,left.left.redden(),left.right.left),(new cljs.core.BlackNode(key,val,left.right.right,del,null)),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.tree_map_kv_reduce = (function cljs$core$tree_map_kv_reduce(node,f,init){
var init__$1 = (((!((node.left == null))))?(function (){var G__33951 = node.left;
var G__33952 = f;
var G__33953 = init;
return (cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3(G__33951,G__33952,G__33953) : cljs.core.tree_map_kv_reduce.call(null, G__33951,G__33952,G__33953));
})():init);
if(cljs.core.reduced_QMARK_(init__$1)){
return init__$1;
} else {
var init__$2 = (function (){var G__33954 = init__$1;
var G__33955 = node.key;
var G__33956 = node.val;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__33954,G__33955,G__33956) : f.call(null, G__33954,G__33955,G__33956));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return init__$2;
} else {
if((!((node.right == null)))){
var G__33957 = node.right;
var G__33958 = f;
var G__33959 = init__$2;
return (cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3(G__33957,G__33958,G__33959) : cljs.core.tree_map_kv_reduce.call(null, G__33957,G__33958,G__33959));
} else {
return init__$2;
}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.BlackNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 166619935;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.BlackNode.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.BlackNode.prototype.cljs$core$IFind$_find$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
var G__33961 = k;
switch (G__33961) {
case (0):
return (new cljs.core.MapEntry((0),self__.key,null));

break;
case (1):
return (new cljs.core.MapEntry((1),self__.val,null));

break;
default:
return null;

}
}));

(cljs.core.BlackNode.prototype.lastIndexOf = (function() {
var G__37857 = null;
var G__37857__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__37857__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__37857 = function(x,start){
switch(arguments.length){
case 1:
return G__37857__1.call(this,x);
case 2:
return G__37857__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__37857.cljs$core$IFn$_invoke$arity$1 = G__37857__1;
G__37857.cljs$core$IFn$_invoke$arity$2 = G__37857__2;
return G__37857;
})()
);

(cljs.core.BlackNode.prototype.indexOf = (function() {
var G__37858 = null;
var G__37858__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__37858__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__37858 = function(x,start){
switch(arguments.length){
case 1:
return G__37858__1.call(this,x);
case 2:
return G__37858__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__37858.cljs$core$IFn$_invoke$arity$1 = G__37858__1;
G__37858.cljs$core$IFn$_invoke$arity$2 = G__37858__2;
return G__37858;
})()
);

(cljs.core.BlackNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return ins.balance_right(node);
}));

(cljs.core.BlackNode.prototype.redden = (function (){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,self__.right,null));
}));

(cljs.core.BlackNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return node;
}));

(cljs.core.BlackNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return ins.balance_left(node);
}));

(cljs.core.BlackNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(key__$1,val__$1,left__$1,right__$1,null));
}));

(cljs.core.BlackNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));
}));

(cljs.core.BlackNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));
}));

(cljs.core.BlackNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_left_del(self__.key,self__.val,del,self__.right);
}));

(cljs.core.BlackNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
}));

(cljs.core.BlackNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_right_del(self__.key,self__.val,self__.left,del);
}));

(cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null, k,null);
}));

(cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null, k,not_found);
}));

(cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
throw (new Error("Index out of bounds"));

}
}
}));

(cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
}));

(cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null, n,v);
}));

(cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
}));

(cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
}));

(cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
}));

(cljs.core.BlackNode.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.val,self__.key],(0),null));
}));

(cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
}));

(cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
}));

(cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
}));

(cljs.core.BlackNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return (((k === (0))) || ((k === (1))));
}));

(cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.key,self__.val],(0),null));
}));

(cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core._with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
}));

(cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
}));

(cljs.core.BlackNode.prototype.call = (function (unused__11804__auto__){
var self__ = this;
var self__ = this;
var G__33962 = (arguments.length - (1));
switch (G__33962) {
case (1):
return self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));

break;
case (2):
return self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(cljs.core.BlackNode.prototype.apply = (function (self__,args33960){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args33960)));
}));

(cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$2(null, k);
}));

(cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$3(null, k,not_found);
}));

(cljs.core.BlackNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"left","left",1241415590,null),new cljs.core.Symbol(null,"right","right",1187949694,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.BlackNode.cljs$lang$type = true);

(cljs.core.BlackNode.cljs$lang$ctorStr = "cljs.core/BlackNode");

(cljs.core.BlackNode.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/BlackNode");
}));

/**
 * Positional factory function for cljs.core/BlackNode.
 */
cljs.core.__GT_BlackNode = (function cljs$core$__GT_BlackNode(key,val,left,right,__hash){
return (new cljs.core.BlackNode(key,val,left,right,__hash));
});

(cljs.core.BlackNode.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.RedNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 166619935;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.RedNode.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.RedNode.prototype.cljs$core$IFind$_find$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
var G__33964 = k;
switch (G__33964) {
case (0):
return (new cljs.core.MapEntry((0),self__.key,null));

break;
case (1):
return (new cljs.core.MapEntry((1),self__.val,null));

break;
default:
return null;

}
}));

(cljs.core.RedNode.prototype.lastIndexOf = (function() {
var G__37877 = null;
var G__37877__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__37877__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__37877 = function(x,start){
switch(arguments.length){
case 1:
return G__37877__1.call(this,x);
case 2:
return G__37877__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__37877.cljs$core$IFn$_invoke$arity$1 = G__37877__1;
G__37877.cljs$core$IFn$_invoke$arity$2 = G__37877__2;
return G__37877;
})()
);

(cljs.core.RedNode.prototype.indexOf = (function() {
var G__37878 = null;
var G__37878__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__37878__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__37878 = function(x,start){
switch(arguments.length){
case 1:
return G__37878__1.call(this,x);
case 2:
return G__37878__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__37878.cljs$core$IFn$_invoke$arity$1 = G__37878__1;
G__37878.cljs$core$IFn$_invoke$arity$2 = G__37878__2;
return G__37878;
})()
);

(cljs.core.RedNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,ins,null));
}));

(cljs.core.RedNode.prototype.redden = (function (){
var self__ = this;
var node = this;
throw (new Error("red-black tree invariant violation"));
}));

(cljs.core.RedNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right,null));
}));

(cljs.core.RedNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,ins,self__.right,null));
}));

(cljs.core.RedNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(key__$1,val__$1,left__$1,right__$1,null));
}));

(cljs.core.RedNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,self__.left.blacken(),(new cljs.core.BlackNode(parent.key,parent.val,self__.right,parent.right,null)),null));
} else {
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.right.key,self__.right.val,(new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right.left,null)),(new cljs.core.BlackNode(parent.key,parent.val,self__.right.right,parent.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));

}
}
}));

(cljs.core.RedNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left,null)),self__.right.blacken(),null));
} else {
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.left.key,self__.left.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left.left,null)),(new cljs.core.BlackNode(self__.key,self__.val,self__.left.right,self__.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));

}
}
}));

(cljs.core.RedNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,del,self__.right,null));
}));

(cljs.core.RedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
}));

(cljs.core.RedNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,del,null));
}));

(cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null, k,null);
}));

(cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null, k,not_found);
}));

(cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
throw (new Error("Index out of bounds"));

}
}
}));

(cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
}));

(cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null, n,v);
}));

(cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
}));

(cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
}));

(cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
}));

(cljs.core.RedNode.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.val,self__.key],(0),null));
}));

(cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
}));

(cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
}));

(cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
}));

(cljs.core.RedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return (((k === (0))) || ((k === (1))));
}));

(cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.key,self__.val],(0),null));
}));

(cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core._with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
}));

(cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
}));

(cljs.core.RedNode.prototype.call = (function (unused__11804__auto__){
var self__ = this;
var self__ = this;
var G__33965 = (arguments.length - (1));
switch (G__33965) {
case (1):
return self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));

break;
case (2):
return self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(cljs.core.RedNode.prototype.apply = (function (self__,args33963){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args33963)));
}));

(cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$2(null, k);
}));

(cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$3(null, k,not_found);
}));

(cljs.core.RedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"left","left",1241415590,null),new cljs.core.Symbol(null,"right","right",1187949694,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.RedNode.cljs$lang$type = true);

(cljs.core.RedNode.cljs$lang$ctorStr = "cljs.core/RedNode");

(cljs.core.RedNode.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/RedNode");
}));

/**
 * Positional factory function for cljs.core/RedNode.
 */
cljs.core.__GT_RedNode = (function cljs$core$__GT_RedNode(key,val,left,right,__hash){
return (new cljs.core.RedNode(key,val,left,right,__hash));
});

(cljs.core.RedNode.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));
cljs.core.tree_map_add = (function cljs$core$tree_map_add(comp,tree,k,v,found){
if((tree == null)){
return (new cljs.core.RedNode(k,v,null,null,null));
} else {
var c = (function (){var G__33966 = k;
var G__33967 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__33966,G__33967) : comp.call(null, G__33966,G__33967));
})();
if((c === (0))){
(found[(0)] = tree);

return null;
} else {
if((c < (0))){
var ins = (function (){var G__33968 = comp;
var G__33969 = tree.left;
var G__33970 = k;
var G__33971 = v;
var G__33972 = found;
return (cljs.core.tree_map_add.cljs$core$IFn$_invoke$arity$5 ? cljs.core.tree_map_add.cljs$core$IFn$_invoke$arity$5(G__33968,G__33969,G__33970,G__33971,G__33972) : cljs.core.tree_map_add.call(null, G__33968,G__33969,G__33970,G__33971,G__33972));
})();
if((!((ins == null)))){
return tree.add_left(ins);
} else {
return null;
}
} else {
var ins = (function (){var G__33973 = comp;
var G__33974 = tree.right;
var G__33975 = k;
var G__33976 = v;
var G__33977 = found;
return (cljs.core.tree_map_add.cljs$core$IFn$_invoke$arity$5 ? cljs.core.tree_map_add.cljs$core$IFn$_invoke$arity$5(G__33973,G__33974,G__33975,G__33976,G__33977) : cljs.core.tree_map_add.call(null, G__33973,G__33974,G__33975,G__33976,G__33977));
})();
if((!((ins == null)))){
return tree.add_right(ins);
} else {
return null;
}

}
}
}
});
cljs.core.tree_map_append = (function cljs$core$tree_map_append(left,right){
if((left == null)){
return right;
} else {
if((right == null)){
return left;
} else {
if((left instanceof cljs.core.RedNode)){
if((right instanceof cljs.core.RedNode)){
var app = (function (){var G__33978 = left.right;
var G__33979 = right.left;
return (cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2 ? cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2(G__33978,G__33979) : cljs.core.tree_map_append.call(null, G__33978,G__33979));
})();
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.RedNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.RedNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,(new cljs.core.RedNode(right.key,right.val,app,right.right,null)),null));
}
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,(function (){var G__33980 = left.right;
var G__33981 = right;
return (cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2 ? cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2(G__33980,G__33981) : cljs.core.tree_map_append.call(null, G__33980,G__33981));
})(),null));
}
} else {
if((right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(right.key,right.val,(function (){var G__33982 = left;
var G__33983 = right.left;
return (cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2 ? cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2(G__33982,G__33983) : cljs.core.tree_map_append.call(null, G__33982,G__33983));
})(),right.right,null));
} else {
var app = (function (){var G__33984 = left.right;
var G__33985 = right.left;
return (cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2 ? cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2(G__33984,G__33985) : cljs.core.tree_map_append.call(null, G__33984,G__33985));
})();
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.BlackNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.BlackNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return cljs.core.balance_left_del(left.key,left.val,left.left,(new cljs.core.BlackNode(right.key,right.val,app,right.right,null)));
}

}
}
}
}
});
cljs.core.tree_map_remove = (function cljs$core$tree_map_remove(comp,tree,k,found){
if((!((tree == null)))){
var c = (function (){var G__33986 = k;
var G__33987 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__33986,G__33987) : comp.call(null, G__33986,G__33987));
})();
if((c === (0))){
(found[(0)] = tree);

return cljs.core.tree_map_append(tree.left,tree.right);
} else {
if((c < (0))){
var del = (function (){var G__33988 = comp;
var G__33989 = tree.left;
var G__33990 = k;
var G__33991 = found;
return (cljs.core.tree_map_remove.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tree_map_remove.cljs$core$IFn$_invoke$arity$4(G__33988,G__33989,G__33990,G__33991) : cljs.core.tree_map_remove.call(null, G__33988,G__33989,G__33990,G__33991));
})();
if((((!((del == null)))) || ((!(((found[(0)]) == null)))))){
if((tree.left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left_del(tree.key,tree.val,del,tree.right);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,del,tree.right,null));
}
} else {
return null;
}
} else {
var del = (function (){var G__33992 = comp;
var G__33993 = tree.right;
var G__33994 = k;
var G__33995 = found;
return (cljs.core.tree_map_remove.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tree_map_remove.cljs$core$IFn$_invoke$arity$4(G__33992,G__33993,G__33994,G__33995) : cljs.core.tree_map_remove.call(null, G__33992,G__33993,G__33994,G__33995));
})();
if((((!((del == null)))) || ((!(((found[(0)]) == null)))))){
if((tree.right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right_del(tree.key,tree.val,tree.left,del);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,tree.left,del,null));
}
} else {
return null;
}

}
}
} else {
return null;
}
});
cljs.core.tree_map_replace = (function cljs$core$tree_map_replace(comp,tree,k,v){
var tk = tree.key;
var c = (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(k,tk) : comp.call(null, k,tk));
if((c === (0))){
return tree.replace(tk,v,tree.left,tree.right);
} else {
if((c < (0))){
return tree.replace(tk,tree.val,(function (){var G__33996 = comp;
var G__33997 = tree.left;
var G__33998 = k;
var G__33999 = v;
return (cljs.core.tree_map_replace.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tree_map_replace.cljs$core$IFn$_invoke$arity$4(G__33996,G__33997,G__33998,G__33999) : cljs.core.tree_map_replace.call(null, G__33996,G__33997,G__33998,G__33999));
})(),tree.right);
} else {
return tree.replace(tk,tree.val,tree.left,(function (){var G__34000 = comp;
var G__34001 = tree.right;
var G__34002 = k;
var G__34003 = v;
return (cljs.core.tree_map_replace.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tree_map_replace.cljs$core$IFn$_invoke$arity$4(G__34000,G__34001,G__34002,G__34003) : cljs.core.tree_map_replace.call(null, G__34000,G__34001,G__34002,G__34003));
})());

}
}
});

/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentTreeMap = (function (comp,tree,cnt,meta,__hash){
this.comp = comp;
this.tree = tree;
this.cnt = cnt;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 418776847;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.PersistentTreeMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentTreeMap.prototype.cljs$core$IFind$_find$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.entry_at(k);
}));

(cljs.core.PersistentTreeMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__34005 = cljs.core.seq(coll);
var chunk__34006 = null;
var count__34007 = (0);
var i__34008 = (0);
while(true){
if((i__34008 < count__34007)){
var vec__34015 = chunk__34006.cljs$core$IIndexed$_nth$arity$2(null, i__34008);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34015,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34015,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null, v,k));


var G__37886 = seq__34005;
var G__37887 = chunk__34006;
var G__37888 = count__34007;
var G__37889 = (i__34008 + (1));
seq__34005 = G__37886;
chunk__34006 = G__37887;
count__34007 = G__37888;
i__34008 = G__37889;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__34005);
if(temp__5823__auto__){
var seq__34005__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34005__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__34005__$1);
var G__37890 = cljs.core.chunk_rest(seq__34005__$1);
var G__37891 = c__5525__auto__;
var G__37892 = cljs.core.count(c__5525__auto__);
var G__37893 = (0);
seq__34005 = G__37890;
chunk__34006 = G__37891;
count__34007 = G__37892;
i__34008 = G__37893;
continue;
} else {
var vec__34018 = cljs.core.first(seq__34005__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34018,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34018,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null, v,k));


var G__37894 = cljs.core.next(seq__34005__$1);
var G__37895 = null;
var G__37896 = (0);
var G__37897 = (0);
seq__34005 = G__37894;
chunk__34006 = G__37895;
count__34007 = G__37896;
i__34008 = G__37897;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.PersistentTreeMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null, k,not_found);
}));

(cljs.core.PersistentTreeMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
}));

(cljs.core.PersistentTreeMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentTreeMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.keys.call(null, coll)));
}));

(cljs.core.PersistentTreeMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.vals.call(null, coll)));
}));

(cljs.core.PersistentTreeMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
}));

(cljs.core.PersistentTreeMap.prototype.entry_at = (function (k){
var self__ = this;
var coll = this;
var t = self__.tree;
while(true){
if((!((t == null)))){
var c = (function (){var G__34021 = k;
var G__34022 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__34021,G__34022) : self__.comp.call(null, G__34021,G__34022));
})();
if((c === (0))){
return t;
} else {
if((c < (0))){
var G__37898 = t.left;
t = G__37898;
continue;
} else {
var G__37899 = t.right;
t = G__37899;
continue;

}
}
} else {
return null;
}
break;
}
}));

(cljs.core.PersistentTreeMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null, k,null);
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var n = coll__$1.entry_at(k);
if((!((n == null)))){
return n.val;
} else {
return not_found;
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
if((!((self__.tree == null)))){
return cljs.core.unreduced(cljs.core.tree_map_kv_reduce(self__.tree,f,init));
} else {
return init;
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,self__.meta,self__.__hash));
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,false,self__.cnt);
} else {
return null;
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,(0)));
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_remove(self__.comp,self__.tree,k,found);
if((t == null)){
if((cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found,(0)) == null)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt - (1)),self__.meta,null));
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_add(self__.comp,self__.tree,k,v,found);
if((t == null)){
var found_node = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found,(0));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(v,found_node.val)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,cljs.core.tree_map_replace(self__.comp,self__.tree,k,v),self__.cnt,self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt + (1)),self__.meta,null));
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return (!((coll__$1.entry_at(k) == null)));
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,true,self__.cnt);
} else {
return null;
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,new_meta,self__.__hash));
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null, cljs.core._nth(entry,(0)),cljs.core._nth(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__37901 = cljs.core._assoc(ret,cljs.core._nth(e,(0)),cljs.core._nth(e,(1)));
var G__37902 = cljs.core.next(es);
ret = G__37901;
es = G__37902;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
}));

(cljs.core.PersistentTreeMap.prototype.call = (function (unused__11804__auto__){
var self__ = this;
var self__ = this;
var G__34023 = (arguments.length - (1));
switch (G__34023) {
case (1):
return self__.cljs$core$IFn$_invoke$arity$1((arguments[(1)]));

break;
case (2):
return self__.cljs$core$IFn$_invoke$arity$2((arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments.length - (1)))].join('')));

}
}));

(cljs.core.PersistentTreeMap.prototype.apply = (function (self__,args34004){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args34004)));
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null, k,not_found);
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,ascending_QMARK_,self__.cnt);
} else {
return null;
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var stack = null;
var t = self__.tree;
while(true){
if((!((t == null)))){
var c = (function (){var G__34026 = k;
var G__34027 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__34026,G__34027) : self__.comp.call(null, G__34026,G__34027));
})();
if((c === (0))){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t),ascending_QMARK_,(-1),null));
} else {
if(cljs.core.truth_(ascending_QMARK_)){
if((c < (0))){
var G__37906 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__37907 = t.left;
stack = G__37906;
t = G__37907;
continue;
} else {
var G__37908 = stack;
var G__37909 = t.right;
stack = G__37908;
t = G__37909;
continue;
}
} else {
if((c > (0))){
var G__37910 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__37911 = t.right;
stack = G__37910;
t = G__37911;
continue;
} else {
var G__37912 = stack;
var G__37913 = t.left;
stack = G__37912;
t = G__37913;
continue;
}

}
}
} else {
if((stack == null)){
return null;
} else {
return (new cljs.core.PersistentTreeMapSeq(null,stack,ascending_QMARK_,(-1),null));
}
}
break;
}
} else {
return null;
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(entry) : cljs.core.key.call(null, entry));
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.comp;
}));

(cljs.core.PersistentTreeMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"comp","comp",-1462482139,null),new cljs.core.Symbol(null,"tree","tree",1444219499,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentTreeMap.cljs$lang$type = true);

(cljs.core.PersistentTreeMap.cljs$lang$ctorStr = "cljs.core/PersistentTreeMap");

(cljs.core.PersistentTreeMap.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/PersistentTreeMap");
}));

/**
 * Positional factory function for cljs.core/PersistentTreeMap.
 */
cljs.core.__GT_PersistentTreeMap = (function cljs$core$__GT_PersistentTreeMap(comp,tree,cnt,meta,__hash){
return (new cljs.core.PersistentTreeMap(comp,tree,cnt,meta,__hash));
});

(cljs.core.PersistentTreeMap.EMPTY = (new cljs.core.PersistentTreeMap(cljs.core.compare,null,(0),null,cljs.core.empty_unordered_hash)));
(cljs.core.PersistentTreeMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));
/**
 * keyval => key val
 *   Returns a new hash map with supplied mappings.
 */
cljs.core.hash_map = (function cljs$core$hash_map(var_args){
var args__5732__auto__ = [];
var len__5726__auto___37914 = arguments.length;
var i__5727__auto___37915 = (0);
while(true){
if((i__5727__auto___37915 < len__5726__auto___37914)){
args__5732__auto__.push((arguments[i__5727__auto___37915]));

var G__37916 = (i__5727__auto___37915 + (1));
i__5727__auto___37915 = G__37916;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((0) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((0)),(0),null)):null);
return cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic(argseq__5733__auto__);
});

(cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if(in$){
var in_SINGLEQUOTE_ = cljs.core.next(in$);
if((in_SINGLEQUOTE_ == null)){
throw (new Error(["No value supplied for key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(in$))].join('')));
} else {
var G__37917 = cljs.core.next(in_SINGLEQUOTE_);
var G__37918 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.first(in_SINGLEQUOTE_));
in$ = G__37917;
out = G__37918;
continue;
}
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
}));

(cljs.core.hash_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.hash_map.cljs$lang$applyTo = (function (seq34028){
var self__5712__auto__ = this;
return self__5712__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34028));
}));

/**
 * keyval => key val
 *   Returns a new array map with supplied mappings.
 */
cljs.core.array_map = (function cljs$core$array_map(var_args){
var args__5732__auto__ = [];
var len__5726__auto___37919 = arguments.length;
var i__5727__auto___37920 = (0);
while(true){
if((i__5727__auto___37920 < len__5726__auto___37919)){
args__5732__auto__.push((arguments[i__5727__auto___37920]));

var G__37921 = (i__5727__auto___37920 + (1));
i__5727__auto___37920 = G__37921;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((0) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((0)),(0),null)):null);
return cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic(argseq__5733__auto__);
});

(cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var arr = (((((keyvals instanceof cljs.core.IndexedSeq)) && ((keyvals.i === (0)))))?keyvals.arr:cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(keyvals));
if(cljs.core.odd_QMARK_(arr.length)){
throw (new Error(["No value supplied for key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(arr))].join('')));
} else {
return cljs.core.PersistentArrayMap.createAsIfByAssoc(arr);
}
}));

(cljs.core.array_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.array_map.cljs$lang$applyTo = (function (seq34029){
var self__5712__auto__ = this;
return self__5712__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34029));
}));

/**
 * Builds a map from a seq as described in
 *   https://clojure.org/reference/special_forms#keyword-arguments
 */
cljs.core.seq_to_map_for_destructuring = (function cljs$core$seq_to_map_for_destructuring(s){
if(cljs.core.next(s)){
return cljs.core.PersistentArrayMap.createAsIfByAssoc(cljs.core.to_array(s));
} else {
if(cljs.core.seq(s)){
return cljs.core.first(s);
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
}
});
/**
 * keyval => key val
 *   Returns a new object map with supplied mappings.
 */
cljs.core.obj_map = (function cljs$core$obj_map(var_args){
var args__5732__auto__ = [];
var len__5726__auto___37922 = arguments.length;
var i__5727__auto___37923 = (0);
while(true){
if((i__5727__auto___37923 < len__5726__auto___37922)){
args__5732__auto__.push((arguments[i__5727__auto___37923]));

var G__37924 = (i__5727__auto___37923 + (1));
i__5727__auto___37923 = G__37924;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((0) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((0)),(0),null)):null);
return cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic(argseq__5733__auto__);
});

(cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var ks = [];
var obj = ({});
var kvs = cljs.core.seq(keyvals);
while(true){
if(kvs){
ks.push(cljs.core.first(kvs));

cljs.core.goog$module$goog$object.set(obj,cljs.core.first(kvs),cljs.core.second(kvs));

var G__37925 = cljs.core.nnext(kvs);
kvs = G__37925;
continue;
} else {
return cljs.core.ObjMap.fromObject(ks,obj);
}
break;
}
}));

(cljs.core.obj_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.obj_map.cljs$lang$applyTo = (function (seq34030){
var self__5712__auto__ = this;
return self__5712__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34030));
}));

/**
 * keyval => key val
 *   Returns a new sorted map with supplied mappings.
 */
cljs.core.sorted_map = (function cljs$core$sorted_map(var_args){
var args__5732__auto__ = [];
var len__5726__auto___37926 = arguments.length;
var i__5727__auto___37927 = (0);
while(true){
if((i__5727__auto___37927 < len__5726__auto___37926)){
args__5732__auto__.push((arguments[i__5727__auto___37927]));

var G__37928 = (i__5727__auto___37927 + (1));
i__5727__auto___37927 = G__37928;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((0) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((0)),(0),null)):null);
return cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic(argseq__5733__auto__);
});

(cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.PersistentTreeMap.EMPTY;
while(true){
if(in$){
var G__37933 = cljs.core.nnext(in$);
var G__37934 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__37933;
out = G__37934;
continue;
} else {
return out;
}
break;
}
}));

(cljs.core.sorted_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.sorted_map.cljs$lang$applyTo = (function (seq34033){
var self__5712__auto__ = this;
return self__5712__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34033));
}));

/**
 * keyval => key val
 *   Returns a new sorted map with supplied mappings, using the supplied comparator.
 */
cljs.core.sorted_map_by = (function cljs$core$sorted_map_by(var_args){
var args__5732__auto__ = [];
var len__5726__auto___37936 = arguments.length;
var i__5727__auto___37937 = (0);
while(true){
if((i__5727__auto___37937 < len__5726__auto___37936)){
args__5732__auto__.push((arguments[i__5727__auto___37937]));

var G__37938 = (i__5727__auto___37937 + (1));
i__5727__auto___37937 = G__37938;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = (new cljs.core.PersistentTreeMap(cljs.core.fn__GT_comparator(comparator),null,(0),null,(0)));
while(true){
if(in$){
var G__37940 = cljs.core.nnext(in$);
var G__37941 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__37940;
out = G__37941;
continue;
} else {
return out;
}
break;
}
}));

(cljs.core.sorted_map_by.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.sorted_map_by.cljs$lang$applyTo = (function (seq34034){
var G__34035 = cljs.core.first(seq34034);
var seq34034__$1 = cljs.core.next(seq34034);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__34035,seq34034__$1);
}));


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.KeySeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.KeySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.KeySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
}));

(cljs.core.KeySeq.prototype.indexOf = (function() {
var G__37942 = null;
var G__37942__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__37942__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__37942 = function(x,start){
switch(arguments.length){
case 1:
return G__37942__1.call(this,x);
case 2:
return G__37942__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__37942.cljs$core$IFn$_invoke$arity$1 = G__37942__1;
G__37942.cljs$core$IFn$_invoke$arity$2 = G__37942__2;
return G__37942;
})()
);

(cljs.core.KeySeq.prototype.lastIndexOf = (function() {
var G__37943 = null;
var G__37943__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__37943__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__37943 = function(x,start){
switch(arguments.length){
case 1:
return G__37943__1.call(this,x);
case 2:
return G__37943__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__37943.cljs$core$IFn$_invoke$arity$1 = G__37943__1;
G__37943.cljs$core$IFn$_invoke$arity$2 = G__37943__2;
return G__37943;
})()
);

(cljs.core.KeySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
}));

(cljs.core.KeySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((((!((self__.mseq == null))))?(((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === self__.mseq.cljs$core$INext$))))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq)))?self__.mseq.cljs$core$INext$_next$arity$1(null, ):cljs.core.next(self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.KeySeq(nseq,null));
}
}));

(cljs.core.KeySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
}));

(cljs.core.KeySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.KeySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.KeySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null, );
return me.cljs$core$IMapEntry$_key$arity$1(null, );
}));

(cljs.core.KeySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((((!((self__.mseq == null))))?(((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === self__.mseq.cljs$core$INext$))))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq)))?self__.mseq.cljs$core$INext$_next$arity$1(null, ):cljs.core.next(self__.mseq));
if((!((nseq == null)))){
return (new cljs.core.KeySeq(nseq,null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.KeySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.KeySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__._meta)){
return coll__$1;
} else {
return (new cljs.core.KeySeq(self__.mseq,new_meta));
}
}));

(cljs.core.KeySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.KeySeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mseq","mseq",1602647196,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"not-native","not-native",-236392494,null)], null)),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
}));

(cljs.core.KeySeq.cljs$lang$type = true);

(cljs.core.KeySeq.cljs$lang$ctorStr = "cljs.core/KeySeq");

(cljs.core.KeySeq.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/KeySeq");
}));

/**
 * Positional factory function for cljs.core/KeySeq.
 */
cljs.core.__GT_KeySeq = (function cljs$core$__GT_KeySeq(mseq,_meta){
return (new cljs.core.KeySeq(mseq,_meta));
});

(cljs.core.KeySeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));
/**
 * Returns a sequence of the map's keys, in the same order as (seq map).
 */
cljs.core.keys = (function cljs$core$keys(map){
var temp__5823__auto__ = cljs.core.seq(map);
if(temp__5823__auto__){
var mseq = temp__5823__auto__;
return (new cljs.core.KeySeq(mseq,null));
} else {
return null;
}
});
/**
 * Returns the key of the map entry.
 */
cljs.core.key = (function cljs$core$key(map_entry){
return cljs.core._key(map_entry);
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ValSeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ValSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.ValSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
}));

(cljs.core.ValSeq.prototype.indexOf = (function() {
var G__37944 = null;
var G__37944__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__37944__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__37944 = function(x,start){
switch(arguments.length){
case 1:
return G__37944__1.call(this,x);
case 2:
return G__37944__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__37944.cljs$core$IFn$_invoke$arity$1 = G__37944__1;
G__37944.cljs$core$IFn$_invoke$arity$2 = G__37944__2;
return G__37944;
})()
);

(cljs.core.ValSeq.prototype.lastIndexOf = (function() {
var G__37945 = null;
var G__37945__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__37945__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__37945 = function(x,start){
switch(arguments.length){
case 1:
return G__37945__1.call(this,x);
case 2:
return G__37945__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__37945.cljs$core$IFn$_invoke$arity$1 = G__37945__1;
G__37945.cljs$core$IFn$_invoke$arity$2 = G__37945__2;
return G__37945;
})()
);

(cljs.core.ValSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
}));

(cljs.core.ValSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((((!((self__.mseq == null))))?(((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === self__.mseq.cljs$core$INext$))))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq)))?self__.mseq.cljs$core$INext$_next$arity$1(null, ):cljs.core.next(self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.ValSeq(nseq,null));
}
}));

(cljs.core.ValSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
}));

(cljs.core.ValSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.ValSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.ValSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null, );
return me.cljs$core$IMapEntry$_val$arity$1(null, );
}));

(cljs.core.ValSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((((!((self__.mseq == null))))?(((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === self__.mseq.cljs$core$INext$))))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq)))?self__.mseq.cljs$core$INext$_next$arity$1(null, ):cljs.core.next(self__.mseq));
if((!((nseq == null)))){
return (new cljs.core.ValSeq(nseq,null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.ValSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.ValSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__._meta)){
return coll__$1;
} else {
return (new cljs.core.ValSeq(self__.mseq,new_meta));
}
}));

(cljs.core.ValSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.ValSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mseq","mseq",1602647196,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"not-native","not-native",-236392494,null)], null)),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
}));

(cljs.core.ValSeq.cljs$lang$type = true);

(cljs.core.ValSeq.cljs$lang$ctorStr = "cljs.core/ValSeq");

(cljs.core.ValSeq.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/ValSeq");
}));

/**
 * Positional factory function for cljs.core/ValSeq.
 */
cljs.core.__GT_ValSeq = (function cljs$core$__GT_ValSeq(mseq,_meta){
return (new cljs.core.ValSeq(mseq,_meta));
});

(cljs.core.ValSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5655__auto__ = this;
return cljs.core.es6_iterator(this__5655__auto__);
}));
/**
 * Returns a sequence of the map's values, in the same order as (seq map).
 */
cljs.core.vals = (function cljs$core$vals(map){
var temp__5823__auto__ = cljs.core.seq(map);
if(temp__5823__auto__){
var mseq = temp__5823__auto__;
return (new cljs.core.ValSeq(mseq,null));
} else {
return null;
}
});
/**
 * Returns the value in the map entry.
 */
cljs.core.val = (function cljs$core$val(map_entry){
return cljs.core._val(map_entry);
});
/**
 * Returns a map that consists of the rest of the maps conj-ed onto
 *   the first.  If a key occurs in more than one map, the mapping from
 *   the latter (left-to-right) will be the mapping in the result.
 */
cljs.core.merge = (function cljs$core$merge(var_args){
var args__5732__auto__ = [];
var len__5726__auto___37948 = arguments.length;
var i__5727__auto___37949 = (0);
while(true){
if((i__5727__auto___37949 < len__5726__auto___37948)){
args__5732__auto__.push((arguments[i__5727__auto___37949]));

var G__37950 = (i__5727__auto___37949 + (1));
i__5727__auto___37949 = G__37950;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((0) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((0)),(0),null)):null);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(argseq__5733__auto__);
});

(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic = (function (maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__34040_SHARP_,p2__34041_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__5002__auto__ = p1__34040_SHARP_;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),p2__34041_SHARP_);
}),maps);
} else {
return null;
}
}));

(cljs.core.merge.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.merge.cljs$lang$applyTo = (function (seq34042){
var self__5712__auto__ = this;
return self__5712__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34042));
}));

/**
 * Returns a map that consists of the rest of the maps conj-ed onto
 *   the first.  If a key occurs in more than one map, the mapping(s)
 *   from the latter (left-to-right) will be combined with the mapping in
 *   the result by calling (f val-in-result val-in-latter).
 */
cljs.core.merge_with = (function cljs$core$merge_with(var_args){
var args__5732__auto__ = [];
var len__5726__auto___37951 = arguments.length;
var i__5727__auto___37952 = (0);
while(true){
if((i__5727__auto___37952 < len__5726__auto___37951)){
args__5732__auto__.push((arguments[i__5727__auto___37952]));

var G__37953 = (i__5727__auto___37952 + (1));
i__5727__auto___37952 = G__37953;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic = (function (f,maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
var merge_entry = (function (m,e){
var k = cljs.core.key(e);
var v = cljs.core.val(e);
if(cljs.core.contains_QMARK_(m,k)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__34045 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__34046 = v;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__34045,G__34046) : f.call(null, G__34045,G__34046));
})());
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
var merge2 = (function (m1,m2){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(merge_entry,(function (){var or__5002__auto__ = m1;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.seq(m2));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(merge2,maps);
} else {
return null;
}
}));

(cljs.core.merge_with.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.merge_with.cljs$lang$applyTo = (function (seq34043){
var G__34044 = cljs.core.first(seq34043);
var seq34043__$1 = cljs.core.next(seq34043);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__34044,seq34043__$1);
}));

/**
 * Returns a map containing only those entries in map whose key is in keys
 */
cljs.core.select_keys = (function cljs$core$select_keys(map,keyseq){
var ret = cljs.core.PersistentArrayMap.EMPTY;
var keys = cljs.core.seq(keyseq);
while(true){
if(keys){
var key = cljs.core.first(keys);
var entry = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map,key,new cljs.core.Keyword("cljs.core","not-found","cljs.core/not-found",-1572889185));
var G__37954 = ((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(entry,new cljs.core.Keyword("cljs.core","not-found","cljs.core/not-found",-1572889185)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret,key,entry):ret);
var G__37955 = cljs.core.next(keys);
ret = G__37954;
keys = G__37955;
continue;
} else {
return cljs.core._with_meta(ret,cljs.core.meta(map));
}
break;
}
});

/**
* @constructor
*/
cljs.core.HashSetIter = (function (iter){
this.iter = iter;
});
(cljs.core.HashSetIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return self__.iter.hasNext();
}));

(cljs.core.HashSetIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if(self__.iter.hasNext()){
return self__.iter.next().key;
} else {
throw (new Error("No such element"));
}
}));

(cljs.core.HashSetIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.HashSetIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"iter","iter",-1346195486,null)], null);
}));

(cljs.core.HashSetIter.cljs$lang$type = true);

(cljs.core.HashSetIter.cljs$lang$ctorStr = "cljs.core/HashSetIter");

(cljs.core.HashSetIter.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core/HashSetIter");
}));

/**
 * Positional factory function for cljs.core/HashSetIter.
 */
cljs.core.__GT_HashSetIter = (function cljs$core$__GT_HashSetIter(iter){
return (new cljs.core.HashSetIter(iter));
});


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.ISet}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentHashSet = (function (meta,hash_map,__hash){
this.meta = meta;
this.hash_map = hash_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 15077647;
this.cljs$lang$protocol_mask$partition1$ = 139268;
});
(cljs.core.PersistentHashSet.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentHashSet.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
}));

(cljs.core.PersistentHashSet.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
}));

(cljs.core.PersistentHashSet.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
}));

(cljs.core.PersistentHashSet.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
}));

(cljs.core.PersistentHashSet.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
}));

(cljs.core.PersistentHashSet.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__34050 = cljs.core.seq(coll);
var chunk__34051 = null;
var count__34052 = (0);
var i__34053 = (0);
while(true){
if((i__34053 < count__34052)){
var vec__34060 = chunk__34051.cljs$core$IIndexed$_nth$arity$2(null, i__34053);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34060,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34060,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null, v,k));


var G__37