goog.provide('cljs.core.async');
goog.scope(function(){
  cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37882 = (function (f,blockable,meta37883){
this.f = f;
this.blockable = blockable;
this.meta37883 = meta37883;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async37882.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_37884,meta37883__$1){
var self__ = this;
var _37884__$1 = this;
return (new cljs.core.async.t_cljs$core$async37882(self__.f,self__.blockable,meta37883__$1));
}));

(cljs.core.async.t_cljs$core$async37882.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_37884){
var self__ = this;
var _37884__$1 = this;
return self__.meta37883;
}));

(cljs.core.async.t_cljs$core$async37882.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async37882.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async37882.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async37882.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async37882.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta37883","meta37883",-1678041699,null)], null);
}));

(cljs.core.async.t_cljs$core$async37882.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async37882.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37882");

(cljs.core.async.t_cljs$core$async37882.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async37882");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async37882.
 */
cljs.core.async.__GT_t_cljs$core$async37882 = (function cljs$core$async$__GT_t_cljs$core$async37882(f,blockable,meta37883){
return (new cljs.core.async.t_cljs$core$async37882(f,blockable,meta37883));
});


cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__37880 = arguments.length;
switch (G__37880) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
return (new cljs.core.async.t_cljs$core$async37882(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__37905 = arguments.length;
switch (G__37905) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__37939 = arguments.length;
switch (G__37939) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__37947 = arguments.length;
switch (G__37947) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_41704 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_41704) : fn1.call(null, val_41704));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_41704) : fn1.call(null, val_41704));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__37969 = arguments.length;
switch (G__37969) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5821__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5821__auto__)){
var ret = temp__5821__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5821__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5821__auto__)){
var retb = temp__5821__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null, ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null, ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5593__auto___41715 = n;
var x_41716 = (0);
while(true){
if((x_41716 < n__5593__auto___41715)){
(a[x_41716] = x_41716);

var G__41717 = (x_41716 + (1));
x_41716 = G__41717;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle(a);

return a;
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37999 = (function (flag,meta38000){
this.flag = flag;
this.meta38000 = meta38000;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async37999.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38001,meta38000__$1){
var self__ = this;
var _38001__$1 = this;
return (new cljs.core.async.t_cljs$core$async37999(self__.flag,meta38000__$1));
}));

(cljs.core.async.t_cljs$core$async37999.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38001){
var self__ = this;
var _38001__$1 = this;
return self__.meta38000;
}));

(cljs.core.async.t_cljs$core$async37999.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async37999.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async37999.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async37999.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async37999.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta38000","meta38000",1786447982,null)], null);
}));

(cljs.core.async.t_cljs$core$async37999.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async37999.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37999");

(cljs.core.async.t_cljs$core$async37999.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async37999");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async37999.
 */
cljs.core.async.__GT_t_cljs$core$async37999 = (function cljs$core$async$__GT_t_cljs$core$async37999(flag,meta38000){
return (new cljs.core.async.t_cljs$core$async37999(flag,meta38000));
});


cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
return (new cljs.core.async.t_cljs$core$async37999(flag,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38024 = (function (flag,cb,meta38025){
this.flag = flag;
this.cb = cb;
this.meta38025 = meta38025;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async38024.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38026,meta38025__$1){
var self__ = this;
var _38026__$1 = this;
return (new cljs.core.async.t_cljs$core$async38024(self__.flag,self__.cb,meta38025__$1));
}));

(cljs.core.async.t_cljs$core$async38024.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38026){
var self__ = this;
var _38026__$1 = this;
return self__.meta38025;
}));

(cljs.core.async.t_cljs$core$async38024.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38024.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async38024.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async38024.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async38024.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta38025","meta38025",-559561373,null)], null);
}));

(cljs.core.async.t_cljs$core$async38024.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async38024.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38024");

(cljs.core.async.t_cljs$core$async38024.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async38024");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async38024.
 */
cljs.core.async.__GT_t_cljs$core$async38024 = (function cljs$core$async$__GT_t_cljs$core$async38024(flag,cb,meta38025){
return (new cljs.core.async.t_cljs$core$async38024(flag,cb,meta38025));
});


cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
return (new cljs.core.async.t_cljs$core$async38024(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var ports__$1 = cljs.core.vec(ports);
var n = cljs.core.count(ports__$1);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports__$1,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null, (0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null, (1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,ports__$1,n,idxs,priority){
return (function (p1__38062_SHARP_){
var G__38078 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__38062_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__38078) : fret.call(null, G__38078));
});})(i,val,idx,port,wport,flag,ports__$1,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,ports__$1,n,idxs,priority){
return (function (p1__38063_SHARP_){
var G__38079 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__38063_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__38079) : fret.call(null, G__38079));
});})(i,idx,port,wport,flag,ports__$1,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__5002__auto__ = wport;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return port;
}
})()], null));
} else {
var G__41732 = (i + (1));
i = G__41732;
continue;
}
} else {
return null;
}
break;
}
})();
var or__5002__auto__ = ret;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5823__auto__ = (function (){var and__5000__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null, );
if(cljs.core.truth_(and__5000__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null, );
} else {
return and__5000__auto__;
}
})();
if(cljs.core.truth_(temp__5823__auto__)){
var got = temp__5823__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5732__auto__ = [];
var len__5726__auto___41734 = arguments.length;
var i__5727__auto___41739 = (0);
while(true){
if((i__5727__auto___41739 < len__5726__auto___41734)){
args__5732__auto__.push((arguments[i__5727__auto___41739]));

var G__41740 = (i__5727__auto___41739 + (1));
i__5727__auto___41739 = G__41740;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__38101){
var map__38102 = p__38101;
var map__38102__$1 = cljs.core.__destructure_map(map__38102);
var opts = map__38102__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq38092){
var G__38096 = cljs.core.first(seq38092);
var seq38092__$1 = cljs.core.next(seq38092);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__38096,seq38092__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__38128 = arguments.length;
switch (G__38128) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__37794__auto___41750 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37795__auto__ = (function (){var switch__37550__auto__ = (function (state_38211){
var state_val_38212 = (state_38211[(1)]);
if((state_val_38212 === (7))){
var inst_38205 = (state_38211[(2)]);
var state_38211__$1 = state_38211;
var statearr_38214_41755 = state_38211__$1;
(statearr_38214_41755[(2)] = inst_38205);

(statearr_38214_41755[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38212 === (1))){
var state_38211__$1 = state_38211;
var statearr_38217_41756 = state_38211__$1;
(statearr_38217_41756[(2)] = null);

(statearr_38217_41756[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38212 === (4))){
var inst_38164 = (state_38211[(7)]);
var inst_38164__$1 = (state_38211[(2)]);
var inst_38185 = (inst_38164__$1 == null);
var state_38211__$1 = (function (){var statearr_38221 = state_38211;
(statearr_38221[(7)] = inst_38164__$1);

return statearr_38221;
})();
if(cljs.core.truth_(inst_38185)){
var statearr_38224_41760 = state_38211__$1;
(statearr_38224_41760[(1)] = (5));

} else {
var statearr_38225_41761 = state_38211__$1;
(statearr_38225_41761[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38212 === (13))){
var state_38211__$1 = state_38211;
var statearr_38248_41762 = state_38211__$1;
(statearr_38248_41762[(2)] = null);

(statearr_38248_41762[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38212 === (6))){
var inst_38164 = (state_38211[(7)]);
var state_38211__$1 = state_38211;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38211__$1,(11),to,inst_38164);
} else {
if((state_val_38212 === (3))){
var inst_38207 = (state_38211[(2)]);
var state_38211__$1 = state_38211;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38211__$1,inst_38207);
} else {
if((state_val_38212 === (12))){
var state_38211__$1 = state_38211;
var statearr_38254_41763 = state_38211__$1;
(statearr_38254_41763[(2)] = null);

(statearr_38254_41763[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38212 === (2))){
var state_38211__$1 = state_38211;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38211__$1,(4),from);
} else {
if((state_val_38212 === (11))){
var inst_38198 = (state_38211[(2)]);
var state_38211__$1 = state_38211;
if(cljs.core.truth_(inst_38198)){
var statearr_38258_41764 = state_38211__$1;
(statearr_38258_41764[(1)] = (12));

} else {
var statearr_38259_41765 = state_38211__$1;
(statearr_38259_41765[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38212 === (9))){
var state_38211__$1 = state_38211;
var statearr_38263_41766 = state_38211__$1;
(statearr_38263_41766[(2)] = null);

(statearr_38263_41766[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38212 === (5))){
var state_38211__$1 = state_38211;
if(cljs.core.truth_(close_QMARK_)){
var statearr_38264_41767 = state_38211__$1;
(statearr_38264_41767[(1)] = (8));

} else {
var statearr_38265_41768 = state_38211__$1;
(statearr_38265_41768[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38212 === (14))){
var inst_38203 = (state_38211[(2)]);
var state_38211__$1 = state_38211;
var statearr_38266_41769 = state_38211__$1;
(statearr_38266_41769[(2)] = inst_38203);

(statearr_38266_41769[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38212 === (10))){
var inst_38195 = (state_38211[(2)]);
var state_38211__$1 = state_38211;
var statearr_38267_41771 = state_38211__$1;
(statearr_38267_41771[(2)] = inst_38195);

(statearr_38267_41771[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38212 === (8))){
var inst_38188 = cljs.core.async.close_BANG_(to);
var state_38211__$1 = state_38211;
var statearr_38268_41772 = state_38211__$1;
(statearr_38268_41772[(2)] = inst_38188);

(statearr_38268_41772[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__37551__auto__ = null;
var cljs$core$async$state_machine__37551__auto____0 = (function (){
var statearr_38272 = [null,null,null,null,null,null,null,null];
(statearr_38272[(0)] = cljs$core$async$state_machine__37551__auto__);

(statearr_38272[(1)] = (1));

return statearr_38272;
});
var cljs$core$async$state_machine__37551__auto____1 = (function (state_38211){
while(true){
var ret_value__37552__auto__ = (function (){try{while(true){
var result__37553__auto__ = switch__37550__auto__(state_38211);
if(cljs.core.keyword_identical_QMARK_(result__37553__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37553__auto__;
}
break;
}
}catch (e38273){var ex__37554__auto__ = e38273;
var statearr_38274_41774 = state_38211;
(statearr_38274_41774[(2)] = ex__37554__auto__);


if(cljs.core.seq((state_38211[(4)]))){
var statearr_38275_41775 = state_38211;
(statearr_38275_41775[(1)] = cljs.core.first((state_38211[(4)])));

} else {
throw ex__37554__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41776 = state_38211;
state_38211 = G__41776;
continue;
} else {
return ret_value__37552__auto__;
}
break;
}
});
cljs$core$async$state_machine__37551__auto__ = function(state_38211){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__37551__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__37551__auto____1.call(this,state_38211);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__37551__auto____0;
cljs$core$async$state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__37551__auto____1;
return cljs$core$async$state_machine__37551__auto__;
})()
})();
var state__37796__auto__ = (function (){var statearr_38285 = f__37795__auto__();
(statearr_38285[(6)] = c__37794__auto___41750);

return statearr_38285;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37796__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process__$1 = (function (p__38291){
var vec__38293 = p__38291;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38293,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38293,(1),null);
var job = vec__38293;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__37794__auto___41782 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37795__auto__ = (function (){var switch__37550__auto__ = (function (state_38302){
var state_val_38303 = (state_38302[(1)]);
if((state_val_38303 === (1))){
var state_38302__$1 = state_38302;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38302__$1,(2),res,v);
} else {
if((state_val_38303 === (2))){
var inst_38298 = (state_38302[(2)]);
var inst_38299 = cljs.core.async.close_BANG_(res);
var state_38302__$1 = (function (){var statearr_38320 = state_38302;
(statearr_38320[(7)] = inst_38298);

return statearr_38320;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_38302__$1,inst_38299);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__37551__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__37551__auto____0 = (function (){
var statearr_38332 = [null,null,null,null,null,null,null,null];
(statearr_38332[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__37551__auto__);

(statearr_38332[(1)] = (1));

return statearr_38332;
});
var cljs$core$async$pipeline_STAR__$_state_machine__37551__auto____1 = (function (state_38302){
while(true){
var ret_value__37552__auto__ = (function (){try{while(true){
var result__37553__auto__ = switch__37550__auto__(state_38302);
if(cljs.core.keyword_identical_QMARK_(result__37553__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37553__auto__;
}
break;
}
}catch (e38335){var ex__37554__auto__ = e38335;
var statearr_38337_41785 = state_38302;
(statearr_38337_41785[(2)] = ex__37554__auto__);


if(cljs.core.seq((state_38302[(4)]))){
var statearr_38343_41786 = state_38302;
(statearr_38343_41786[(1)] = cljs.core.first((state_38302[(4)])));

} else {
throw ex__37554__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41789 = state_38302;
state_38302 = G__41789;
continue;
} else {
return ret_value__37552__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__37551__auto__ = function(state_38302){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__37551__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__37551__auto____1.call(this,state_38302);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__37551__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__37551__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__37551__auto__;
})()
})();
var state__37796__auto__ = (function (){var statearr_38357 = f__37795__auto__();
(statearr_38357[(6)] = c__37794__auto___41782);

return statearr_38357;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37796__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__38363){
var vec__38364 = p__38363;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38364,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38364,(1),null);
var job = vec__38364;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null, v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__5593__auto___41795 = n;
var __41796 = (0);
while(true){
if((__41796 < n__5593__auto___41795)){
var G__38401_41797 = type;
var G__38401_41798__$1 = (((G__38401_41797 instanceof cljs.core.Keyword))?G__38401_41797.fqn:null);
switch (G__38401_41798__$1) {
case "compute":
var c__37794__auto___41803 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__41796,c__37794__auto___41803,G__38401_41797,G__38401_41798__$1,n__5593__auto___41795,jobs,results,process__$1,async){
return (function (){
var f__37795__auto__ = (function (){var switch__37550__auto__ = ((function (__41796,c__37794__auto___41803,G__38401_41797,G__38401_41798__$1,n__5593__auto___41795,jobs,results,process__$1,async){
return (function (state_38425){
var state_val_38426 = (state_38425[(1)]);
if((state_val_38426 === (1))){
var state_38425__$1 = state_38425;
var statearr_38430_41808 = state_38425__$1;
(statearr_38430_41808[(2)] = null);

(statearr_38430_41808[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38426 === (2))){
var state_38425__$1 = state_38425;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38425__$1,(4),jobs);
} else {
if((state_val_38426 === (3))){
var inst_38422 = (state_38425[(2)]);
var state_38425__$1 = state_38425;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38425__$1,inst_38422);
} else {
if((state_val_38426 === (4))){
var inst_38411 = (state_38425[(2)]);
var inst_38412 = process__$1(inst_38411);
var state_38425__$1 = state_38425;
if(cljs.core.truth_(inst_38412)){
var statearr_38446_41812 = state_38425__$1;
(statearr_38446_41812[(1)] = (5));

} else {
var statearr_38451_41814 = state_38425__$1;
(statearr_38451_41814[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38426 === (5))){
var state_38425__$1 = state_38425;
var statearr_38461_41819 = state_38425__$1;
(statearr_38461_41819[(2)] = null);

(statearr_38461_41819[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38426 === (6))){
var state_38425__$1 = state_38425;
var statearr_38469_41820 = state_38425__$1;
(statearr_38469_41820[(2)] = null);

(statearr_38469_41820[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38426 === (7))){
var inst_38418 = (state_38425[(2)]);
var state_38425__$1 = state_38425;
var statearr_38486_41821 = state_38425__$1;
(statearr_38486_41821[(2)] = inst_38418);

(statearr_38486_41821[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__41796,c__37794__auto___41803,G__38401_41797,G__38401_41798__$1,n__5593__auto___41795,jobs,results,process__$1,async))
;
return ((function (__41796,switch__37550__auto__,c__37794__auto___41803,G__38401_41797,G__38401_41798__$1,n__5593__auto___41795,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__37551__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__37551__auto____0 = (function (){
var statearr_38490 = [null,null,null,null,null,null,null];
(statearr_38490[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__37551__auto__);

(statearr_38490[(1)] = (1));

return statearr_38490;
});
var cljs$core$async$pipeline_STAR__$_state_machine__37551__auto____1 = (function (state_38425){
while(true){
var ret_value__37552__auto__ = (function (){try{while(true){
var result__37553__auto__ = switch__37550__auto__(state_38425);
if(cljs.core.keyword_identical_QMARK_(result__37553__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37553__auto__;
}
break;
}
}catch (e38494){var ex__37554__auto__ = e38494;
var statearr_38495_41830 = state_38425;
(statearr_38495_41830[(2)] = ex__37554__auto__);


if(cljs.core.seq((state_38425[(4)]))){
var statearr_38500_41831 = state_38425;
(statearr_38500_41831[(1)] = cljs.core.first((state_38425[(4)])));

} else {
throw ex__37554__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41832 = state_38425;
state_38425 = G__41832;
continue;
} else {
return ret_value__37552__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__37551__auto__ = function(state_38425){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__37551__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__37551__auto____1.call(this,state_38425);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__37551__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__37551__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__37551__auto__;
})()
;})(__41796,switch__37550__auto__,c__37794__auto___41803,G__38401_41797,G__38401_41798__$1,n__5593__auto___41795,jobs,results,process__$1,async))
})();
var state__37796__auto__ = (function (){var statearr_38503 = f__37795__auto__();
(statearr_38503[(6)] = c__37794__auto___41803);

return statearr_38503;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37796__auto__);
});})(__41796,c__37794__auto___41803,G__38401_41797,G__38401_41798__$1,n__5593__auto___41795,jobs,results,process__$1,async))
);


break;
case "async":
var c__37794__auto___41833 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__41796,c__37794__auto___41833,G__38401_41797,G__38401_41798__$1,n__5593__auto___41795,jobs,results,process__$1,async){
return (function (){
var f__37795__auto__ = (function (){var switch__37550__auto__ = ((function (__41796,c__37794__auto___41833,G__38401_41797,G__38401_41798__$1,n__5593__auto___41795,jobs,results,process__$1,async){
return (function (state_38536){
var state_val_38542 = (state_38536[(1)]);
if((state_val_38542 === (1))){
var state_38536__$1 = state_38536;
var statearr_38574_41834 = state_38536__$1;
(statearr_38574_41834[(2)] = null);

(statearr_38574_41834[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38542 === (2))){
var state_38536__$1 = state_38536;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38536__$1,(4),jobs);
} else {
if((state_val_38542 === (3))){
var inst_38528 = (state_38536[(2)]);
var state_38536__$1 = state_38536;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38536__$1,inst_38528);
} else {
if((state_val_38542 === (4))){
var inst_38515 = (state_38536[(2)]);
var inst_38516 = async(inst_38515);
var state_38536__$1 = state_38536;
if(cljs.core.truth_(inst_38516)){
var statearr_38600_41836 = state_38536__$1;
(statearr_38600_41836[(1)] = (5));

} else {
var statearr_38601_41837 = state_38536__$1;
(statearr_38601_41837[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38542 === (5))){
var state_38536__$1 = state_38536;
var statearr_38604_41838 = state_38536__$1;
(statearr_38604_41838[(2)] = null);

(statearr_38604_41838[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38542 === (6))){
var state_38536__$1 = state_38536;
var statearr_38605_41839 = state_38536__$1;
(statearr_38605_41839[(2)] = null);

(statearr_38605_41839[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38542 === (7))){
var inst_38526 = (state_38536[(2)]);
var state_38536__$1 = state_38536;
var statearr_38608_41841 = state_38536__$1;
(statearr_38608_41841[(2)] = inst_38526);

(statearr_38608_41841[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__41796,c__37794__auto___41833,G__38401_41797,G__38401_41798__$1,n__5593__auto___41795,jobs,results,process__$1,async))
;
return ((function (__41796,switch__37550__auto__,c__37794__auto___41833,G__38401_41797,G__38401_41798__$1,n__5593__auto___41795,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__37551__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__37551__auto____0 = (function (){
var statearr_38620 = [null,null,null,null,null,null,null];
(statearr_38620[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__37551__auto__);

(statearr_38620[(1)] = (1));

return statearr_38620;
});
var cljs$core$async$pipeline_STAR__$_state_machine__37551__auto____1 = (function (state_38536){
while(true){
var ret_value__37552__auto__ = (function (){try{while(true){
var result__37553__auto__ = switch__37550__auto__(state_38536);
if(cljs.core.keyword_identical_QMARK_(result__37553__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37553__auto__;
}
break;
}
}catch (e38632){var ex__37554__auto__ = e38632;
var statearr_38633_41843 = state_38536;
(statearr_38633_41843[(2)] = ex__37554__auto__);


if(cljs.core.seq((state_38536[(4)]))){
var statearr_38635_41844 = state_38536;
(statearr_38635_41844[(1)] = cljs.core.first((state_38536[(4)])));

} else {
throw ex__37554__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41846 = state_38536;
state_38536 = G__41846;
continue;
} else {
return ret_value__37552__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__37551__auto__ = function(state_38536){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__37551__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__37551__auto____1.call(this,state_38536);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__37551__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__37551__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__37551__auto__;
})()
;})(__41796,switch__37550__auto__,c__37794__auto___41833,G__38401_41797,G__38401_41798__$1,n__5593__auto___41795,jobs,results,process__$1,async))
})();
var state__37796__auto__ = (function (){var statearr_38639 = f__37795__auto__();
(statearr_38639[(6)] = c__37794__auto___41833);

return statearr_38639;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37796__auto__);
});})(__41796,c__37794__auto___41833,G__38401_41797,G__38401_41798__$1,n__5593__auto___41795,jobs,results,process__$1,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__38401_41798__$1)].join('')));

}

var G__41847 = (__41796 + (1));
__41796 = G__41847;
continue;
} else {
}
break;
}

var c__37794__auto___41848 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37795__auto__ = (function (){var switch__37550__auto__ = (function (state_38676){
var state_val_38677 = (state_38676[(1)]);
if((state_val_38677 === (7))){
var inst_38672 = (state_38676[(2)]);
var state_38676__$1 = state_38676;
var statearr_38688_41852 = state_38676__$1;
(statearr_38688_41852[(2)] = inst_38672);

(statearr_38688_41852[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38677 === (1))){
var state_38676__$1 = state_38676;
var statearr_38690_41853 = state_38676__$1;
(statearr_38690_41853[(2)] = null);

(statearr_38690_41853[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38677 === (4))){
var inst_38648 = (state_38676[(7)]);
var inst_38648__$1 = (state_38676[(2)]);
var inst_38650 = (inst_38648__$1 == null);
var state_38676__$1 = (function (){var statearr_38694 = state_38676;
(statearr_38694[(7)] = inst_38648__$1);

return statearr_38694;
})();
if(cljs.core.truth_(inst_38650)){
var statearr_38697_41854 = state_38676__$1;
(statearr_38697_41854[(1)] = (5));

} else {
var statearr_38698_41855 = state_38676__$1;
(statearr_38698_41855[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38677 === (6))){
var inst_38648 = (state_38676[(7)]);
var inst_38654 = (state_38676[(8)]);
var inst_38654__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_38659 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38661 = [inst_38648,inst_38654__$1];
var inst_38662 = (new cljs.core.PersistentVector(null,2,(5),inst_38659,inst_38661,null));
var state_38676__$1 = (function (){var statearr_38704 = state_38676;
(statearr_38704[(8)] = inst_38654__$1);

return statearr_38704;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38676__$1,(8),jobs,inst_38662);
} else {
if((state_val_38677 === (3))){
var inst_38674 = (state_38676[(2)]);
var state_38676__$1 = state_38676;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38676__$1,inst_38674);
} else {
if((state_val_38677 === (2))){
var state_38676__$1 = state_38676;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38676__$1,(4),from);
} else {
if((state_val_38677 === (9))){
var inst_38667 = (state_38676[(2)]);
var state_38676__$1 = (function (){var statearr_38712 = state_38676;
(statearr_38712[(9)] = inst_38667);

return statearr_38712;
})();
var statearr_38713_41859 = state_38676__$1;
(statearr_38713_41859[(2)] = null);

(statearr_38713_41859[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38677 === (5))){
var inst_38652 = cljs.core.async.close_BANG_(jobs);
var state_38676__$1 = state_38676;
var statearr_38715_41860 = state_38676__$1;
(statearr_38715_41860[(2)] = inst_38652);

(statearr_38715_41860[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38677 === (8))){
var inst_38654 = (state_38676[(8)]);
var inst_38665 = (state_38676[(2)]);
var state_38676__$1 = (function (){var statearr_38717 = state_38676;
(statearr_38717[(10)] = inst_38665);

return statearr_38717;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38676__$1,(9),results,inst_38654);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__37551__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__37551__auto____0 = (function (){
var statearr_38721 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_38721[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__37551__auto__);

(statearr_38721[(1)] = (1));

return statearr_38721;
});
var cljs$core$async$pipeline_STAR__$_state_machine__37551__auto____1 = (function (state_38676){
while(true){
var ret_value__37552__auto__ = (function (){try{while(true){
var result__37553__auto__ = switch__37550__auto__(state_38676);
if(cljs.core.keyword_identical_QMARK_(result__37553__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37553__auto__;
}
break;
}
}catch (e38740){var ex__37554__auto__ = e38740;
var statearr_38744_41864 = state_38676;
(statearr_38744_41864[(2)] = ex__37554__auto__);


if(cljs.core.seq((state_38676[(4)]))){
var statearr_38759_41868 = state_38676;
(statearr_38759_41868[(1)] = cljs.core.first((state_38676[(4)])));

} else {
throw ex__37554__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41872 = state_38676;
state_38676 = G__41872;
continue;
} else {
return ret_value__37552__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__37551__auto__ = function(state_38676){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__37551__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__37551__auto____1.call(this,state_38676);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__37551__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__37551__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__37551__auto__;
})()
})();
var state__37796__auto__ = (function (){var statearr_38773 = f__37795__auto__();
(statearr_38773[(6)] = c__37794__auto___41848);

return statearr_38773;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37796__auto__);
}));


var c__37794__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37795__auto__ = (function (){var switch__37550__auto__ = (function (state_38844){
var state_val_38845 = (state_38844[(1)]);
if((state_val_38845 === (7))){
var inst_38840 = (state_38844[(2)]);
var state_38844__$1 = state_38844;
var statearr_38851_41873 = state_38844__$1;
(statearr_38851_41873[(2)] = inst_38840);

(statearr_38851_41873[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38845 === (20))){
var state_38844__$1 = state_38844;
var statearr_38855_41874 = state_38844__$1;
(statearr_38855_41874[(2)] = null);

(statearr_38855_41874[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38845 === (1))){
var state_38844__$1 = state_38844;
var statearr_38857_41879 = state_38844__$1;
(statearr_38857_41879[(2)] = null);

(statearr_38857_41879[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38845 === (4))){
var inst_38780 = (state_38844[(7)]);
var inst_38780__$1 = (state_38844[(2)]);
var inst_38781 = (inst_38780__$1 == null);
var state_38844__$1 = (function (){var statearr_38860 = state_38844;
(statearr_38860[(7)] = inst_38780__$1);

return statearr_38860;
})();
if(cljs.core.truth_(inst_38781)){
var statearr_38862_41884 = state_38844__$1;
(statearr_38862_41884[(1)] = (5));

} else {
var statearr_38863_41885 = state_38844__$1;
(statearr_38863_41885[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38845 === (15))){
var inst_38810 = (state_38844[(8)]);
var state_38844__$1 = state_38844;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38844__$1,(18),to,inst_38810);
} else {
if((state_val_38845 === (21))){
var inst_38835 = (state_38844[(2)]);
var state_38844__$1 = state_38844;
var statearr_38864_41889 = state_38844__$1;
(statearr_38864_41889[(2)] = inst_38835);

(statearr_38864_41889[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38845 === (13))){
var inst_38837 = (state_38844[(2)]);
var state_38844__$1 = (function (){var statearr_38866 = state_38844;
(statearr_38866[(9)] = inst_38837);

return statearr_38866;
})();
var statearr_38867_41897 = state_38844__$1;
(statearr_38867_41897[(2)] = null);

(statearr_38867_41897[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38845 === (6))){
var inst_38780 = (state_38844[(7)]);
var state_38844__$1 = state_38844;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38844__$1,(11),inst_38780);
} else {
if((state_val_38845 === (17))){
var inst_38830 = (state_38844[(2)]);
var state_38844__$1 = state_38844;
if(cljs.core.truth_(inst_38830)){
var statearr_38875_41899 = state_38844__$1;
(statearr_38875_41899[(1)] = (19));

} else {
var statearr_38877_41900 = state_38844__$1;
(statearr_38877_41900[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38845 === (3))){
var inst_38842 = (state_38844[(2)]);
var state_38844__$1 = state_38844;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38844__$1,inst_38842);
} else {
if((state_val_38845 === (12))){
var inst_38794 = (state_38844[(10)]);
var state_38844__$1 = state_38844;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38844__$1,(14),inst_38794);
} else {
if((state_val_38845 === (2))){
var state_38844__$1 = state_38844;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38844__$1,(4),results);
} else {
if((state_val_38845 === (19))){
var state_38844__$1 = state_38844;
var statearr_38888_41902 = state_38844__$1;
(statearr_38888_41902[(2)] = null);

(statearr_38888_41902[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38845 === (11))){
var inst_38794 = (state_38844[(2)]);
var state_38844__$1 = (function (){var statearr_38895 = state_38844;
(statearr_38895[(10)] = inst_38794);

return statearr_38895;
})();
var statearr_38896_41904 = state_38844__$1;
(statearr_38896_41904[(2)] = null);

(statearr_38896_41904[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38845 === (9))){
var state_38844__$1 = state_38844;
var statearr_38902_41905 = state_38844__$1;
(statearr_38902_41905[(2)] = null);

(statearr_38902_41905[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38845 === (5))){
var state_38844__$1 = state_38844;
if(cljs.core.truth_(close_QMARK_)){
var statearr_38905_41907 = state_38844__$1;
(statearr_38905_41907[(1)] = (8));

} else {
var statearr_38907_41908 = state_38844__$1;
(statearr_38907_41908[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38845 === (14))){
var inst_38810 = (state_38844[(8)]);
var inst_38822 = (state_38844[(11)]);
var inst_38810__$1 = (state_38844[(2)]);
var inst_38821 = (inst_38810__$1 == null);
var inst_38822__$1 = cljs.core.not(inst_38821);
var state_38844__$1 = (function (){var statearr_38922 = state_38844;
(statearr_38922[(8)] = inst_38810__$1);

(statearr_38922[(11)] = inst_38822__$1);

return statearr_38922;
})();
if(inst_38822__$1){
var statearr_38927_41910 = state_38844__$1;
(statearr_38927_41910[(1)] = (15));

} else {
var statearr_38929_41912 = state_38844__$1;
(statearr_38929_41912[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38845 === (16))){
var inst_38822 = (state_38844[(11)]);
var state_38844__$1 = state_38844;
var statearr_38936_41914 = state_38844__$1;
(statearr_38936_41914[(2)] = inst_38822);

(statearr_38936_41914[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38845 === (10))){
var inst_38787 = (state_38844[(2)]);
var state_38844__$1 = state_38844;
var statearr_38943_41916 = state_38844__$1;
(statearr_38943_41916[(2)] = inst_38787);

(statearr_38943_41916[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38845 === (18))){
var inst_38827 = (state_38844[(2)]);
var state_38844__$1 = state_38844;
var statearr_38948_41917 = state_38844__$1;
(statearr_38948_41917[(2)] = inst_38827);

(statearr_38948_41917[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38845 === (8))){
var inst_38784 = cljs.core.async.close_BANG_(to);
var state_38844__$1 = state_38844;
var statearr_38952_41918 = state_38844__$1;
(statearr_38952_41918[(2)] = inst_38784);

(statearr_38952_41918[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__37551__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__37551__auto____0 = (function (){
var statearr_38956 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38956[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__37551__auto__);

(statearr_38956[(1)] = (1));

return statearr_38956;
});
var cljs$core$async$pipeline_STAR__$_state_machine__37551__auto____1 = (function (state_38844){
while(true){
var ret_value__37552__auto__ = (function (){try{while(true){
var result__37553__auto__ = switch__37550__auto__(state_38844);
if(cljs.core.keyword_identical_QMARK_(result__37553__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37553__auto__;
}
break;
}
}catch (e38957){var ex__37554__auto__ = e38957;
var statearr_38958_41919 = state_38844;
(statearr_38958_41919[(2)] = ex__37554__auto__);


if(cljs.core.seq((state_38844[(4)]))){
var statearr_38959_41920 = state_38844;
(statearr_38959_41920[(1)] = cljs.core.first((state_38844[(4)])));

} else {
throw ex__37554__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41921 = state_38844;
state_38844 = G__41921;
continue;
} else {
return ret_value__37552__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__37551__auto__ = function(state_38844){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__37551__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__37551__auto____1.call(this,state_38844);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__37551__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__37551__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__37551__auto__;
})()
})();
var state__37796__auto__ = (function (){var statearr_38960 = f__37795__auto__();
(statearr_38960[(6)] = c__37794__auto__);

return statearr_38960;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37796__auto__);
}));

return c__37794__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__38965 = arguments.length;
switch (G__38965) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__38970 = arguments.length;
switch (G__38970) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__38975 = arguments.length;
switch (G__38975) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__37794__auto___41934 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37795__auto__ = (function (){var switch__37550__auto__ = (function (state_39005){
var state_val_39006 = (state_39005[(1)]);
if((state_val_39006 === (7))){
var inst_39001 = (state_39005[(2)]);
var state_39005__$1 = state_39005;
var statearr_39007_41936 = state_39005__$1;
(statearr_39007_41936[(2)] = inst_39001);

(statearr_39007_41936[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39006 === (1))){
var state_39005__$1 = state_39005;
var statearr_39009_41937 = state_39005__$1;
(statearr_39009_41937[(2)] = null);

(statearr_39009_41937[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39006 === (4))){
var inst_38980 = (state_39005[(7)]);
var inst_38980__$1 = (state_39005[(2)]);
var inst_38983 = (inst_38980__$1 == null);
var state_39005__$1 = (function (){var statearr_39013 = state_39005;
(statearr_39013[(7)] = inst_38980__$1);

return statearr_39013;
})();
if(cljs.core.truth_(inst_38983)){
var statearr_39015_41938 = state_39005__$1;
(statearr_39015_41938[(1)] = (5));

} else {
var statearr_39016_41939 = state_39005__$1;
(statearr_39016_41939[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39006 === (13))){
var state_39005__$1 = state_39005;
var statearr_39020_41940 = state_39005__$1;
(statearr_39020_41940[(2)] = null);

(statearr_39020_41940[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39006 === (6))){
var inst_38980 = (state_39005[(7)]);
var inst_38988 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_38980) : p.call(null, inst_38980));
var state_39005__$1 = state_39005;
if(cljs.core.truth_(inst_38988)){
var statearr_39027_41941 = state_39005__$1;
(statearr_39027_41941[(1)] = (9));

} else {
var statearr_39028_41942 = state_39005__$1;
(statearr_39028_41942[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39006 === (3))){
var inst_39003 = (state_39005[(2)]);
var state_39005__$1 = state_39005;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39005__$1,inst_39003);
} else {
if((state_val_39006 === (12))){
var state_39005__$1 = state_39005;
var statearr_39034_41943 = state_39005__$1;
(statearr_39034_41943[(2)] = null);

(statearr_39034_41943[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39006 === (2))){
var state_39005__$1 = state_39005;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39005__$1,(4),ch);
} else {
if((state_val_39006 === (11))){
var inst_38980 = (state_39005[(7)]);
var inst_38992 = (state_39005[(2)]);
var state_39005__$1 = state_39005;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_39005__$1,(8),inst_38992,inst_38980);
} else {
if((state_val_39006 === (9))){
var state_39005__$1 = state_39005;
var statearr_39049_41944 = state_39005__$1;
(statearr_39049_41944[(2)] = tc);

(statearr_39049_41944[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39006 === (5))){
var inst_38985 = cljs.core.async.close_BANG_(tc);
var inst_38986 = cljs.core.async.close_BANG_(fc);
var state_39005__$1 = (function (){var statearr_39054 = state_39005;
(statearr_39054[(8)] = inst_38985);

return statearr_39054;
})();
var statearr_39057_41945 = state_39005__$1;
(statearr_39057_41945[(2)] = inst_38986);

(statearr_39057_41945[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39006 === (14))){
var inst_38999 = (state_39005[(2)]);
var state_39005__$1 = state_39005;
var statearr_39058_41946 = state_39005__$1;
(statearr_39058_41946[(2)] = inst_38999);

(statearr_39058_41946[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39006 === (10))){
var state_39005__$1 = state_39005;
var statearr_39061_41948 = state_39005__$1;
(statearr_39061_41948[(2)] = fc);

(statearr_39061_41948[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39006 === (8))){
var inst_38994 = (state_39005[(2)]);
var state_39005__$1 = state_39005;
if(cljs.core.truth_(inst_38994)){
var statearr_39064_41949 = state_39005__$1;
(statearr_39064_41949[(1)] = (12));

} else {
var statearr_39065_41950 = state_39005__$1;
(statearr_39065_41950[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__37551__auto__ = null;
var cljs$core$async$state_machine__37551__auto____0 = (function (){
var statearr_39071 = [null,null,null,null,null,null,null,null,null];
(statearr_39071[(0)] = cljs$core$async$state_machine__37551__auto__);

(statearr_39071[(1)] = (1));

return statearr_39071;
});
var cljs$core$async$state_machine__37551__auto____1 = (function (state_39005){
while(true){
var ret_value__37552__auto__ = (function (){try{while(true){
var result__37553__auto__ = switch__37550__auto__(state_39005);
if(cljs.core.keyword_identical_QMARK_(result__37553__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37553__auto__;
}
break;
}
}catch (e39072){var ex__37554__auto__ = e39072;
var statearr_39073_41953 = state_39005;
(statearr_39073_41953[(2)] = ex__37554__auto__);


if(cljs.core.seq((state_39005[(4)]))){
var statearr_39074_41954 = state_39005;
(statearr_39074_41954[(1)] = cljs.core.first((state_39005[(4)])));

} else {
throw ex__37554__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41957 = state_39005;
state_39005 = G__41957;
continue;
} else {
return ret_value__37552__auto__;
}
break;
}
});
cljs$core$async$state_machine__37551__auto__ = function(state_39005){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__37551__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__37551__auto____1.call(this,state_39005);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__37551__auto____0;
cljs$core$async$state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__37551__auto____1;
return cljs$core$async$state_machine__37551__auto__;
})()
})();
var state__37796__auto__ = (function (){var statearr_39077 = f__37795__auto__();
(statearr_39077[(6)] = c__37794__auto___41934);

return statearr_39077;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37796__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__37794__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37795__auto__ = (function (){var switch__37550__auto__ = (function (state_39103){
var state_val_39104 = (state_39103[(1)]);
if((state_val_39104 === (7))){
var inst_39099 = (state_39103[(2)]);
var state_39103__$1 = state_39103;
var statearr_39106_41959 = state_39103__$1;
(statearr_39106_41959[(2)] = inst_39099);

(statearr_39106_41959[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39104 === (1))){
var inst_39078 = init;
var inst_39079 = inst_39078;
var state_39103__$1 = (function (){var statearr_39108 = state_39103;
(statearr_39108[(7)] = inst_39079);

return statearr_39108;
})();
var statearr_39109_41960 = state_39103__$1;
(statearr_39109_41960[(2)] = null);

(statearr_39109_41960[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39104 === (4))){
var inst_39083 = (state_39103[(8)]);
var inst_39083__$1 = (state_39103[(2)]);
var inst_39084 = (inst_39083__$1 == null);
var state_39103__$1 = (function (){var statearr_39110 = state_39103;
(statearr_39110[(8)] = inst_39083__$1);

return statearr_39110;
})();
if(cljs.core.truth_(inst_39084)){
var statearr_39111_41961 = state_39103__$1;
(statearr_39111_41961[(1)] = (5));

} else {
var statearr_39112_41962 = state_39103__$1;
(statearr_39112_41962[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39104 === (6))){
var inst_39079 = (state_39103[(7)]);
var inst_39083 = (state_39103[(8)]);
var inst_39090 = (state_39103[(9)]);
var inst_39090__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_39079,inst_39083) : f.call(null, inst_39079,inst_39083));
var inst_39091 = cljs.core.reduced_QMARK_(inst_39090__$1);
var state_39103__$1 = (function (){var statearr_39117 = state_39103;
(statearr_39117[(9)] = inst_39090__$1);

return statearr_39117;
})();
if(inst_39091){
var statearr_39119_41964 = state_39103__$1;
(statearr_39119_41964[(1)] = (8));

} else {
var statearr_39120_41965 = state_39103__$1;
(statearr_39120_41965[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39104 === (3))){
var inst_39101 = (state_39103[(2)]);
var state_39103__$1 = state_39103;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39103__$1,inst_39101);
} else {
if((state_val_39104 === (2))){
var state_39103__$1 = state_39103;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39103__$1,(4),ch);
} else {
if((state_val_39104 === (9))){
var inst_39090 = (state_39103[(9)]);
var inst_39079 = inst_39090;
var state_39103__$1 = (function (){var statearr_39127 = state_39103;
(statearr_39127[(7)] = inst_39079);

return statearr_39127;
})();
var statearr_39128_41966 = state_39103__$1;
(statearr_39128_41966[(2)] = null);

(statearr_39128_41966[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39104 === (5))){
var inst_39079 = (state_39103[(7)]);
var state_39103__$1 = state_39103;
var statearr_39129_41967 = state_39103__$1;
(statearr_39129_41967[(2)] = inst_39079);

(statearr_39129_41967[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39104 === (10))){
var inst_39097 = (state_39103[(2)]);
var state_39103__$1 = state_39103;
var statearr_39130_41968 = state_39103__$1;
(statearr_39130_41968[(2)] = inst_39097);

(statearr_39130_41968[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39104 === (8))){
var inst_39090 = (state_39103[(9)]);
var inst_39093 = cljs.core.deref(inst_39090);
var state_39103__$1 = state_39103;
var statearr_39131_41969 = state_39103__$1;
(statearr_39131_41969[(2)] = inst_39093);

(statearr_39131_41969[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__37551__auto__ = null;
var cljs$core$async$reduce_$_state_machine__37551__auto____0 = (function (){
var statearr_39132 = [null,null,null,null,null,null,null,null,null,null];
(statearr_39132[(0)] = cljs$core$async$reduce_$_state_machine__37551__auto__);

(statearr_39132[(1)] = (1));

return statearr_39132;
});
var cljs$core$async$reduce_$_state_machine__37551__auto____1 = (function (state_39103){
while(true){
var ret_value__37552__auto__ = (function (){try{while(true){
var result__37553__auto__ = switch__37550__auto__(state_39103);
if(cljs.core.keyword_identical_QMARK_(result__37553__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37553__auto__;
}
break;
}
}catch (e39133){var ex__37554__auto__ = e39133;
var statearr_39134_41973 = state_39103;
(statearr_39134_41973[(2)] = ex__37554__auto__);


if(cljs.core.seq((state_39103[(4)]))){
var statearr_39135_41974 = state_39103;
(statearr_39135_41974[(1)] = cljs.core.first((state_39103[(4)])));

} else {
throw ex__37554__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41976 = state_39103;
state_39103 = G__41976;
continue;
} else {
return ret_value__37552__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__37551__auto__ = function(state_39103){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__37551__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__37551__auto____1.call(this,state_39103);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__37551__auto____0;
cljs$core$async$reduce_$_state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__37551__auto____1;
return cljs$core$async$reduce_$_state_machine__37551__auto__;
})()
})();
var state__37796__auto__ = (function (){var statearr_39141 = f__37795__auto__();
(statearr_39141[(6)] = c__37794__auto__);

return statearr_39141;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37796__auto__);
}));

return c__37794__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null, f));
var c__37794__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37795__auto__ = (function (){var switch__37550__auto__ = (function (state_39148){
var state_val_39149 = (state_39148[(1)]);
if((state_val_39149 === (1))){
var inst_39142 = cljs.core.async.reduce(f__$1,init,ch);
var state_39148__$1 = state_39148;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39148__$1,(2),inst_39142);
} else {
if((state_val_39149 === (2))){
var inst_39144 = (state_39148[(2)]);
var inst_39146 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_39144) : f__$1.call(null, inst_39144));
var state_39148__$1 = state_39148;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39148__$1,inst_39146);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__37551__auto__ = null;
var cljs$core$async$transduce_$_state_machine__37551__auto____0 = (function (){
var statearr_39156 = [null,null,null,null,null,null,null];
(statearr_39156[(0)] = cljs$core$async$transduce_$_state_machine__37551__auto__);

(statearr_39156[(1)] = (1));

return statearr_39156;
});
var cljs$core$async$transduce_$_state_machine__37551__auto____1 = (function (state_39148){
while(true){
var ret_value__37552__auto__ = (function (){try{while(true){
var result__37553__auto__ = switch__37550__auto__(state_39148);
if(cljs.core.keyword_identical_QMARK_(result__37553__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37553__auto__;
}
break;
}
}catch (e39158){var ex__37554__auto__ = e39158;
var statearr_39159_41980 = state_39148;
(statearr_39159_41980[(2)] = ex__37554__auto__);


if(cljs.core.seq((state_39148[(4)]))){
var statearr_39161_41982 = state_39148;
(statearr_39161_41982[(1)] = cljs.core.first((state_39148[(4)])));

} else {
throw ex__37554__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41984 = state_39148;
state_39148 = G__41984;
continue;
} else {
return ret_value__37552__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__37551__auto__ = function(state_39148){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__37551__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__37551__auto____1.call(this,state_39148);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__37551__auto____0;
cljs$core$async$transduce_$_state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__37551__auto____1;
return cljs$core$async$transduce_$_state_machine__37551__auto__;
})()
})();
var state__37796__auto__ = (function (){var statearr_39165 = f__37795__auto__();
(statearr_39165[(6)] = c__37794__auto__);

return statearr_39165;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37796__auto__);
}));

return c__37794__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__39168 = arguments.length;
switch (G__39168) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__37794__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37795__auto__ = (function (){var switch__37550__auto__ = (function (state_39198){
var state_val_39199 = (state_39198[(1)]);
if((state_val_39199 === (7))){
var inst_39179 = (state_39198[(2)]);
var state_39198__$1 = state_39198;
var statearr_39201_41987 = state_39198__$1;
(statearr_39201_41987[(2)] = inst_39179);

(statearr_39201_41987[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39199 === (1))){
var inst_39170 = cljs.core.seq(coll);
var inst_39174 = inst_39170;
var state_39198__$1 = (function (){var statearr_39206 = state_39198;
(statearr_39206[(7)] = inst_39174);

return statearr_39206;
})();
var statearr_39208_41988 = state_39198__$1;
(statearr_39208_41988[(2)] = null);

(statearr_39208_41988[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39199 === (4))){
var inst_39174 = (state_39198[(7)]);
var inst_39177 = cljs.core.first(inst_39174);
var state_39198__$1 = state_39198;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_39198__$1,(7),ch,inst_39177);
} else {
if((state_val_39199 === (13))){
var inst_39192 = (state_39198[(2)]);
var state_39198__$1 = state_39198;
var statearr_39210_41991 = state_39198__$1;
(statearr_39210_41991[(2)] = inst_39192);

(statearr_39210_41991[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39199 === (6))){
var inst_39182 = (state_39198[(2)]);
var state_39198__$1 = state_39198;
if(cljs.core.truth_(inst_39182)){
var statearr_39216_41992 = state_39198__$1;
(statearr_39216_41992[(1)] = (8));

} else {
var statearr_39217_41993 = state_39198__$1;
(statearr_39217_41993[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39199 === (3))){
var inst_39196 = (state_39198[(2)]);
var state_39198__$1 = state_39198;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39198__$1,inst_39196);
} else {
if((state_val_39199 === (12))){
var state_39198__$1 = state_39198;
var statearr_39218_41994 = state_39198__$1;
(statearr_39218_41994[(2)] = null);

(statearr_39218_41994[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39199 === (2))){
var inst_39174 = (state_39198[(7)]);
var state_39198__$1 = state_39198;
if(cljs.core.truth_(inst_39174)){
var statearr_39219_41995 = state_39198__$1;
(statearr_39219_41995[(1)] = (4));

} else {
var statearr_39220_41996 = state_39198__$1;
(statearr_39220_41996[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39199 === (11))){
var inst_39189 = cljs.core.async.close_BANG_(ch);
var state_39198__$1 = state_39198;
var statearr_39221_41997 = state_39198__$1;
(statearr_39221_41997[(2)] = inst_39189);

(statearr_39221_41997[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39199 === (9))){
var state_39198__$1 = state_39198;
if(cljs.core.truth_(close_QMARK_)){
var statearr_39222_41999 = state_39198__$1;
(statearr_39222_41999[(1)] = (11));

} else {
var statearr_39223_42000 = state_39198__$1;
(statearr_39223_42000[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39199 === (5))){
var inst_39174 = (state_39198[(7)]);
var state_39198__$1 = state_39198;
var statearr_39225_42002 = state_39198__$1;
(statearr_39225_42002[(2)] = inst_39174);

(statearr_39225_42002[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39199 === (10))){
var inst_39194 = (state_39198[(2)]);
var state_39198__$1 = state_39198;
var statearr_39230_42003 = state_39198__$1;
(statearr_39230_42003[(2)] = inst_39194);

(statearr_39230_42003[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39199 === (8))){
var inst_39174 = (state_39198[(7)]);
var inst_39184 = cljs.core.next(inst_39174);
var inst_39174__$1 = inst_39184;
var state_39198__$1 = (function (){var statearr_39231 = state_39198;
(statearr_39231[(7)] = inst_39174__$1);

return statearr_39231;
})();
var statearr_39232_42008 = state_39198__$1;
(statearr_39232_42008[(2)] = null);

(statearr_39232_42008[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__37551__auto__ = null;
var cljs$core$async$state_machine__37551__auto____0 = (function (){
var statearr_39233 = [null,null,null,null,null,null,null,null];
(statearr_39233[(0)] = cljs$core$async$state_machine__37551__auto__);

(statearr_39233[(1)] = (1));

return statearr_39233;
});
var cljs$core$async$state_machine__37551__auto____1 = (function (state_39198){
while(true){
var ret_value__37552__auto__ = (function (){try{while(true){
var result__37553__auto__ = switch__37550__auto__(state_39198);
if(cljs.core.keyword_identical_QMARK_(result__37553__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37553__auto__;
}
break;
}
}catch (e39235){var ex__37554__auto__ = e39235;
var statearr_39236_42013 = state_39198;
(statearr_39236_42013[(2)] = ex__37554__auto__);


if(cljs.core.seq((state_39198[(4)]))){
var statearr_39237_42015 = state_39198;
(statearr_39237_42015[(1)] = cljs.core.first((state_39198[(4)])));

} else {
throw ex__37554__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42016 = state_39198;
state_39198 = G__42016;
continue;
} else {
return ret_value__37552__auto__;
}
break;
}
});
cljs$core$async$state_machine__37551__auto__ = function(state_39198){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__37551__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__37551__auto____1.call(this,state_39198);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__37551__auto____0;
cljs$core$async$state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__37551__auto____1;
return cljs$core$async$state_machine__37551__auto__;
})()
})();
var state__37796__auto__ = (function (){var statearr_39243 = f__37795__auto__();
(statearr_39243[(6)] = c__37794__auto__);

return statearr_39243;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37796__auto__);
}));

return c__37794__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__39251 = arguments.length;
switch (G__39251) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_42024 = (function (_){
var x__5350__auto__ = (((_ == null))?null:_);
var m__5351__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5351__auto__.call(null, _));
} else {
var m__5349__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5349__auto__.call(null, _));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_42024(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_42039 = (function (m,ch,close_QMARK_){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5351__auto__.call(null, m,ch,close_QMARK_));
} else {
var m__5349__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5349__auto__.call(null, m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_42039(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_42044 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5351__auto__.call(null, m,ch));
} else {
var m__5349__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5349__auto__.call(null, m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_42044(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_42047 = (function (m){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5351__auto__.call(null, m));
} else {
var m__5349__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5349__auto__.call(null, m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_42047(m);
}
});


/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async39276 = (function (ch,cs,meta39277){
this.ch = ch;
this.cs = cs;
this.meta39277 = meta39277;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async39276.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39278,meta39277__$1){
var self__ = this;
var _39278__$1 = this;
return (new cljs.core.async.t_cljs$core$async39276(self__.ch,self__.cs,meta39277__$1));
}));

(cljs.core.async.t_cljs$core$async39276.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39278){
var self__ = this;
var _39278__$1 = this;
return self__.meta39277;
}));

(cljs.core.async.t_cljs$core$async39276.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async39276.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async39276.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async39276.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async39276.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async39276.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async39276.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta39277","meta39277",1385146611,null)], null);
}));

(cljs.core.async.t_cljs$core$async39276.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async39276.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async39276");

(cljs.core.async.t_cljs$core$async39276.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async39276");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async39276.
 */
cljs.core.async.__GT_t_cljs$core$async39276 = (function cljs$core$async$__GT_t_cljs$core$async39276(ch,cs,meta39277){
return (new cljs.core.async.t_cljs$core$async39276(ch,cs,meta39277));
});


/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (new cljs.core.async.t_cljs$core$async39276(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__37794__auto___42049 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37795__auto__ = (function (){var switch__37550__auto__ = (function (state_39425){
var state_val_39426 = (state_39425[(1)]);
if((state_val_39426 === (7))){
var inst_39421 = (state_39425[(2)]);
var state_39425__$1 = state_39425;
var statearr_39430_42050 = state_39425__$1;
(statearr_39430_42050[(2)] = inst_39421);

(statearr_39430_42050[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (20))){
var inst_39324 = (state_39425[(7)]);
var inst_39336 = cljs.core.first(inst_39324);
var inst_39337 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39336,(0),null);
var inst_39338 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39336,(1),null);
var state_39425__$1 = (function (){var statearr_39431 = state_39425;
(statearr_39431[(8)] = inst_39337);

return statearr_39431;
})();
if(cljs.core.truth_(inst_39338)){
var statearr_39432_42051 = state_39425__$1;
(statearr_39432_42051[(1)] = (22));

} else {
var statearr_39433_42052 = state_39425__$1;
(statearr_39433_42052[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (27))){
var inst_39366 = (state_39425[(9)]);
var inst_39368 = (state_39425[(10)]);
var inst_39374 = (state_39425[(11)]);
var inst_39293 = (state_39425[(12)]);
var inst_39374__$1 = cljs.core._nth(inst_39366,inst_39368);
var inst_39375 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_39374__$1,inst_39293,done);
var state_39425__$1 = (function (){var statearr_39434 = state_39425;
(statearr_39434[(11)] = inst_39374__$1);

return statearr_39434;
})();
if(cljs.core.truth_(inst_39375)){
var statearr_39436_42054 = state_39425__$1;
(statearr_39436_42054[(1)] = (30));

} else {
var statearr_39437_42056 = state_39425__$1;
(statearr_39437_42056[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (1))){
var state_39425__$1 = state_39425;
var statearr_39439_42058 = state_39425__$1;
(statearr_39439_42058[(2)] = null);

(statearr_39439_42058[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (24))){
var inst_39324 = (state_39425[(7)]);
var inst_39343 = (state_39425[(2)]);
var inst_39344 = cljs.core.next(inst_39324);
var inst_39302 = inst_39344;
var inst_39303 = null;
var inst_39304 = (0);
var inst_39305 = (0);
var state_39425__$1 = (function (){var statearr_39446 = state_39425;
(statearr_39446[(13)] = inst_39343);

(statearr_39446[(14)] = inst_39302);

(statearr_39446[(15)] = inst_39303);

(statearr_39446[(16)] = inst_39304);

(statearr_39446[(17)] = inst_39305);

return statearr_39446;
})();
var statearr_39447_42061 = state_39425__$1;
(statearr_39447_42061[(2)] = null);

(statearr_39447_42061[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (39))){
var state_39425__$1 = state_39425;
var statearr_39451_42063 = state_39425__$1;
(statearr_39451_42063[(2)] = null);

(statearr_39451_42063[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (4))){
var inst_39293 = (state_39425[(12)]);
var inst_39293__$1 = (state_39425[(2)]);
var inst_39294 = (inst_39293__$1 == null);
var state_39425__$1 = (function (){var statearr_39452 = state_39425;
(statearr_39452[(12)] = inst_39293__$1);

return statearr_39452;
})();
if(cljs.core.truth_(inst_39294)){
var statearr_39453_42064 = state_39425__$1;
(statearr_39453_42064[(1)] = (5));

} else {
var statearr_39454_42065 = state_39425__$1;
(statearr_39454_42065[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (15))){
var inst_39305 = (state_39425[(17)]);
var inst_39302 = (state_39425[(14)]);
var inst_39303 = (state_39425[(15)]);
var inst_39304 = (state_39425[(16)]);
var inst_39320 = (state_39425[(2)]);
var inst_39321 = (inst_39305 + (1));
var tmp39448 = inst_39303;
var tmp39449 = inst_39304;
var tmp39450 = inst_39302;
var inst_39302__$1 = tmp39450;
var inst_39303__$1 = tmp39448;
var inst_39304__$1 = tmp39449;
var inst_39305__$1 = inst_39321;
var state_39425__$1 = (function (){var statearr_39456 = state_39425;
(statearr_39456[(18)] = inst_39320);

(statearr_39456[(14)] = inst_39302__$1);

(statearr_39456[(15)] = inst_39303__$1);

(statearr_39456[(16)] = inst_39304__$1);

(statearr_39456[(17)] = inst_39305__$1);

return statearr_39456;
})();
var statearr_39457_42075 = state_39425__$1;
(statearr_39457_42075[(2)] = null);

(statearr_39457_42075[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (21))){
var inst_39347 = (state_39425[(2)]);
var state_39425__$1 = state_39425;
var statearr_39465_42081 = state_39425__$1;
(statearr_39465_42081[(2)] = inst_39347);

(statearr_39465_42081[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (31))){
var inst_39374 = (state_39425[(11)]);
var inst_39378 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null, inst_39374);
var state_39425__$1 = state_39425;
var statearr_39466_42088 = state_39425__$1;
(statearr_39466_42088[(2)] = inst_39378);

(statearr_39466_42088[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (32))){
var inst_39368 = (state_39425[(10)]);
var inst_39365 = (state_39425[(19)]);
var inst_39366 = (state_39425[(9)]);
var inst_39367 = (state_39425[(20)]);
var inst_39380 = (state_39425[(2)]);
var inst_39381 = (inst_39368 + (1));
var tmp39462 = inst_39366;
var tmp39463 = inst_39367;
var tmp39464 = inst_39365;
var inst_39365__$1 = tmp39464;
var inst_39366__$1 = tmp39462;
var inst_39367__$1 = tmp39463;
var inst_39368__$1 = inst_39381;
var state_39425__$1 = (function (){var statearr_39467 = state_39425;
(statearr_39467[(21)] = inst_39380);

(statearr_39467[(19)] = inst_39365__$1);

(statearr_39467[(9)] = inst_39366__$1);

(statearr_39467[(20)] = inst_39367__$1);

(statearr_39467[(10)] = inst_39368__$1);

return statearr_39467;
})();
var statearr_39468_42095 = state_39425__$1;
(statearr_39468_42095[(2)] = null);

(statearr_39468_42095[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (40))){
var inst_39393 = (state_39425[(22)]);
var inst_39398 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null, inst_39393);
var state_39425__$1 = state_39425;
var statearr_39470_42096 = state_39425__$1;
(statearr_39470_42096[(2)] = inst_39398);

(statearr_39470_42096[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (33))){
var inst_39384 = (state_39425[(23)]);
var inst_39386 = cljs.core.chunked_seq_QMARK_(inst_39384);
var state_39425__$1 = state_39425;
if(inst_39386){
var statearr_39471_42097 = state_39425__$1;
(statearr_39471_42097[(1)] = (36));

} else {
var statearr_39472_42098 = state_39425__$1;
(statearr_39472_42098[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (13))){
var inst_39314 = (state_39425[(24)]);
var inst_39317 = cljs.core.async.close_BANG_(inst_39314);
var state_39425__$1 = state_39425;
var statearr_39476_42099 = state_39425__$1;
(statearr_39476_42099[(2)] = inst_39317);

(statearr_39476_42099[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (22))){
var inst_39337 = (state_39425[(8)]);
var inst_39340 = cljs.core.async.close_BANG_(inst_39337);
var state_39425__$1 = state_39425;
var statearr_39477_42100 = state_39425__$1;
(statearr_39477_42100[(2)] = inst_39340);

(statearr_39477_42100[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (36))){
var inst_39384 = (state_39425[(23)]);
var inst_39388 = cljs.core.chunk_first(inst_39384);
var inst_39389 = cljs.core.chunk_rest(inst_39384);
var inst_39390 = cljs.core.count(inst_39388);
var inst_39365 = inst_39389;
var inst_39366 = inst_39388;
var inst_39367 = inst_39390;
var inst_39368 = (0);
var state_39425__$1 = (function (){var statearr_39481 = state_39425;
(statearr_39481[(19)] = inst_39365);

(statearr_39481[(9)] = inst_39366);

(statearr_39481[(20)] = inst_39367);

(statearr_39481[(10)] = inst_39368);

return statearr_39481;
})();
var statearr_39482_42103 = state_39425__$1;
(statearr_39482_42103[(2)] = null);

(statearr_39482_42103[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (41))){
var inst_39384 = (state_39425[(23)]);
var inst_39400 = (state_39425[(2)]);
var inst_39401 = cljs.core.next(inst_39384);
var inst_39365 = inst_39401;
var inst_39366 = null;
var inst_39367 = (0);
var inst_39368 = (0);
var state_39425__$1 = (function (){var statearr_39484 = state_39425;
(statearr_39484[(25)] = inst_39400);

(statearr_39484[(19)] = inst_39365);

(statearr_39484[(9)] = inst_39366);

(statearr_39484[(20)] = inst_39367);

(statearr_39484[(10)] = inst_39368);

return statearr_39484;
})();
var statearr_39485_42106 = state_39425__$1;
(statearr_39485_42106[(2)] = null);

(statearr_39485_42106[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (43))){
var state_39425__$1 = state_39425;
var statearr_39486_42107 = state_39425__$1;
(statearr_39486_42107[(2)] = null);

(statearr_39486_42107[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (29))){
var inst_39409 = (state_39425[(2)]);
var state_39425__$1 = state_39425;
var statearr_39487_42109 = state_39425__$1;
(statearr_39487_42109[(2)] = inst_39409);

(statearr_39487_42109[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (44))){
var inst_39418 = (state_39425[(2)]);
var state_39425__$1 = (function (){var statearr_39488 = state_39425;
(statearr_39488[(26)] = inst_39418);

return statearr_39488;
})();
var statearr_39489_42110 = state_39425__$1;
(statearr_39489_42110[(2)] = null);

(statearr_39489_42110[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (6))){
var inst_39357 = (state_39425[(27)]);
var inst_39356 = cljs.core.deref(cs);
var inst_39357__$1 = cljs.core.keys(inst_39356);
var inst_39358 = cljs.core.count(inst_39357__$1);
var inst_39359 = cljs.core.reset_BANG_(dctr,inst_39358);
var inst_39364 = cljs.core.seq(inst_39357__$1);
var inst_39365 = inst_39364;
var inst_39366 = null;
var inst_39367 = (0);
var inst_39368 = (0);
var state_39425__$1 = (function (){var statearr_39490 = state_39425;
(statearr_39490[(27)] = inst_39357__$1);

(statearr_39490[(28)] = inst_39359);

(statearr_39490[(19)] = inst_39365);

(statearr_39490[(9)] = inst_39366);

(statearr_39490[(20)] = inst_39367);

(statearr_39490[(10)] = inst_39368);

return statearr_39490;
})();
var statearr_39492_42117 = state_39425__$1;
(statearr_39492_42117[(2)] = null);

(statearr_39492_42117[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (28))){
var inst_39365 = (state_39425[(19)]);
var inst_39384 = (state_39425[(23)]);
var inst_39384__$1 = cljs.core.seq(inst_39365);
var state_39425__$1 = (function (){var statearr_39493 = state_39425;
(statearr_39493[(23)] = inst_39384__$1);

return statearr_39493;
})();
if(inst_39384__$1){
var statearr_39494_42123 = state_39425__$1;
(statearr_39494_42123[(1)] = (33));

} else {
var statearr_39495_42126 = state_39425__$1;
(statearr_39495_42126[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (25))){
var inst_39368 = (state_39425[(10)]);
var inst_39367 = (state_39425[(20)]);
var inst_39370 = (inst_39368 < inst_39367);
var inst_39371 = inst_39370;
var state_39425__$1 = state_39425;
if(cljs.core.truth_(inst_39371)){
var statearr_39496_42137 = state_39425__$1;
(statearr_39496_42137[(1)] = (27));

} else {
var statearr_39500_42138 = state_39425__$1;
(statearr_39500_42138[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (34))){
var state_39425__$1 = state_39425;
var statearr_39501_42139 = state_39425__$1;
(statearr_39501_42139[(2)] = null);

(statearr_39501_42139[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (17))){
var state_39425__$1 = state_39425;
var statearr_39502_42144 = state_39425__$1;
(statearr_39502_42144[(2)] = null);

(statearr_39502_42144[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (3))){
var inst_39423 = (state_39425[(2)]);
var state_39425__$1 = state_39425;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39425__$1,inst_39423);
} else {
if((state_val_39426 === (12))){
var inst_39352 = (state_39425[(2)]);
var state_39425__$1 = state_39425;
var statearr_39503_42153 = state_39425__$1;
(statearr_39503_42153[(2)] = inst_39352);

(statearr_39503_42153[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (2))){
var state_39425__$1 = state_39425;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39425__$1,(4),ch);
} else {
if((state_val_39426 === (23))){
var state_39425__$1 = state_39425;
var statearr_39506_42163 = state_39425__$1;
(statearr_39506_42163[(2)] = null);

(statearr_39506_42163[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (35))){
var inst_39407 = (state_39425[(2)]);
var state_39425__$1 = state_39425;
var statearr_39508_42165 = state_39425__$1;
(statearr_39508_42165[(2)] = inst_39407);

(statearr_39508_42165[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (19))){
var inst_39324 = (state_39425[(7)]);
var inst_39328 = cljs.core.chunk_first(inst_39324);
var inst_39329 = cljs.core.chunk_rest(inst_39324);
var inst_39330 = cljs.core.count(inst_39328);
var inst_39302 = inst_39329;
var inst_39303 = inst_39328;
var inst_39304 = inst_39330;
var inst_39305 = (0);
var state_39425__$1 = (function (){var statearr_39509 = state_39425;
(statearr_39509[(14)] = inst_39302);

(statearr_39509[(15)] = inst_39303);

(statearr_39509[(16)] = inst_39304);

(statearr_39509[(17)] = inst_39305);

return statearr_39509;
})();
var statearr_39510_42166 = state_39425__$1;
(statearr_39510_42166[(2)] = null);

(statearr_39510_42166[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (11))){
var inst_39302 = (state_39425[(14)]);
var inst_39324 = (state_39425[(7)]);
var inst_39324__$1 = cljs.core.seq(inst_39302);
var state_39425__$1 = (function (){var statearr_39511 = state_39425;
(statearr_39511[(7)] = inst_39324__$1);

return statearr_39511;
})();
if(inst_39324__$1){
var statearr_39512_42167 = state_39425__$1;
(statearr_39512_42167[(1)] = (16));

} else {
var statearr_39513_42173 = state_39425__$1;
(statearr_39513_42173[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (9))){
var inst_39354 = (state_39425[(2)]);
var state_39425__$1 = state_39425;
var statearr_39517_42181 = state_39425__$1;
(statearr_39517_42181[(2)] = inst_39354);

(statearr_39517_42181[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (5))){
var inst_39300 = cljs.core.deref(cs);
var inst_39301 = cljs.core.seq(inst_39300);
var inst_39302 = inst_39301;
var inst_39303 = null;
var inst_39304 = (0);
var inst_39305 = (0);
var state_39425__$1 = (function (){var statearr_39518 = state_39425;
(statearr_39518[(14)] = inst_39302);

(statearr_39518[(15)] = inst_39303);

(statearr_39518[(16)] = inst_39304);

(statearr_39518[(17)] = inst_39305);

return statearr_39518;
})();
var statearr_39543_42188 = state_39425__$1;
(statearr_39543_42188[(2)] = null);

(statearr_39543_42188[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (14))){
var state_39425__$1 = state_39425;
var statearr_39544_42193 = state_39425__$1;
(statearr_39544_42193[(2)] = null);

(statearr_39544_42193[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (45))){
var inst_39415 = (state_39425[(2)]);
var state_39425__$1 = state_39425;
var statearr_39545_42194 = state_39425__$1;
(statearr_39545_42194[(2)] = inst_39415);

(statearr_39545_42194[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (26))){
var inst_39357 = (state_39425[(27)]);
var inst_39411 = (state_39425[(2)]);
var inst_39412 = cljs.core.seq(inst_39357);
var state_39425__$1 = (function (){var statearr_39548 = state_39425;
(statearr_39548[(29)] = inst_39411);

return statearr_39548;
})();
if(inst_39412){
var statearr_39551_42210 = state_39425__$1;
(statearr_39551_42210[(1)] = (42));

} else {
var statearr_39552_42212 = state_39425__$1;
(statearr_39552_42212[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (16))){
var inst_39324 = (state_39425[(7)]);
var inst_39326 = cljs.core.chunked_seq_QMARK_(inst_39324);
var state_39425__$1 = state_39425;
if(inst_39326){
var statearr_39555_42224 = state_39425__$1;
(statearr_39555_42224[(1)] = (19));

} else {
var statearr_39557_42225 = state_39425__$1;
(statearr_39557_42225[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (38))){
var inst_39404 = (state_39425[(2)]);
var state_39425__$1 = state_39425;
var statearr_39558_42226 = state_39425__$1;
(statearr_39558_42226[(2)] = inst_39404);

(statearr_39558_42226[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (30))){
var state_39425__$1 = state_39425;
var statearr_39561_42227 = state_39425__$1;
(statearr_39561_42227[(2)] = null);

(statearr_39561_42227[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (10))){
var inst_39303 = (state_39425[(15)]);
var inst_39305 = (state_39425[(17)]);
var inst_39313 = cljs.core._nth(inst_39303,inst_39305);
var inst_39314 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39313,(0),null);
var inst_39315 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39313,(1),null);
var state_39425__$1 = (function (){var statearr_39566 = state_39425;
(statearr_39566[(24)] = inst_39314);

return statearr_39566;
})();
if(cljs.core.truth_(inst_39315)){
var statearr_39567_42235 = state_39425__$1;
(statearr_39567_42235[(1)] = (13));

} else {
var statearr_39568_42236 = state_39425__$1;
(statearr_39568_42236[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (18))){
var inst_39350 = (state_39425[(2)]);
var state_39425__$1 = state_39425;
var statearr_39569_42239 = state_39425__$1;
(statearr_39569_42239[(2)] = inst_39350);

(statearr_39569_42239[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (42))){
var state_39425__$1 = state_39425;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39425__$1,(45),dchan);
} else {
if((state_val_39426 === (37))){
var inst_39384 = (state_39425[(23)]);
var inst_39393 = (state_39425[(22)]);
var inst_39293 = (state_39425[(12)]);
var inst_39393__$1 = cljs.core.first(inst_39384);
var inst_39394 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_39393__$1,inst_39293,done);
var state_39425__$1 = (function (){var statearr_39571 = state_39425;
(statearr_39571[(22)] = inst_39393__$1);

return statearr_39571;
})();
if(cljs.core.truth_(inst_39394)){
var statearr_39572_42251 = state_39425__$1;
(statearr_39572_42251[(1)] = (39));

} else {
var statearr_39573_42256 = state_39425__$1;
(statearr_39573_42256[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39426 === (8))){
var inst_39305 = (state_39425[(17)]);
var inst_39304 = (state_39425[(16)]);
var inst_39307 = (inst_39305 < inst_39304);
var inst_39308 = inst_39307;
var state_39425__$1 = state_39425;
if(cljs.core.truth_(inst_39308)){
var statearr_39574_42261 = state_39425__$1;
(statearr_39574_42261[(1)] = (10));

} else {
var statearr_39575_42264 = state_39425__$1;
(statearr_39575_42264[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__37551__auto__ = null;
var cljs$core$async$mult_$_state_machine__37551__auto____0 = (function (){
var statearr_39579 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39579[(0)] = cljs$core$async$mult_$_state_machine__37551__auto__);

(statearr_39579[(1)] = (1));

return statearr_39579;
});
var cljs$core$async$mult_$_state_machine__37551__auto____1 = (function (state_39425){
while(true){
var ret_value__37552__auto__ = (function (){try{while(true){
var result__37553__auto__ = switch__37550__auto__(state_39425);
if(cljs.core.keyword_identical_QMARK_(result__37553__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37553__auto__;
}
break;
}
}catch (e39580){var ex__37554__auto__ = e39580;
var statearr_39581_42268 = state_39425;
(statearr_39581_42268[(2)] = ex__37554__auto__);


if(cljs.core.seq((state_39425[(4)]))){
var statearr_39583_42272 = state_39425;
(statearr_39583_42272[(1)] = cljs.core.first((state_39425[(4)])));

} else {
throw ex__37554__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42274 = state_39425;
state_39425 = G__42274;
continue;
} else {
return ret_value__37552__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__37551__auto__ = function(state_39425){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__37551__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__37551__auto____1.call(this,state_39425);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__37551__auto____0;
cljs$core$async$mult_$_state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__37551__auto____1;
return cljs$core$async$mult_$_state_machine__37551__auto__;
})()
})();
var state__37796__auto__ = (function (){var statearr_39584 = f__37795__auto__();
(statearr_39584[(6)] = c__37794__auto___42049);

return statearr_39584;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37796__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__39592 = arguments.length;
switch (G__39592) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_42276 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5351__auto__.call(null, m,ch));
} else {
var m__5349__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5349__auto__.call(null, m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_42276(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_42279 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5351__auto__.call(null, m,ch));
} else {
var m__5349__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5349__auto__.call(null, m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_42279(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_42282 = (function (m){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5351__auto__.call(null, m));
} else {
var m__5349__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5349__auto__.call(null, m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_42282(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_42283 = (function (m,state_map){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5351__auto__.call(null, m,state_map));
} else {
var m__5349__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5349__auto__.call(null, m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_42283(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_42284 = (function (m,mode){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5351__auto__.call(null, m,mode));
} else {
var m__5349__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5349__auto__.call(null, m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_42284(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5732__auto__ = [];
var len__5726__auto___42295 = arguments.length;
var i__5727__auto___42296 = (0);
while(true){
if((i__5727__auto___42296 < len__5726__auto___42295)){
args__5732__auto__.push((arguments[i__5727__auto___42296]));

var G__42297 = (i__5727__auto___42296 + (1));
i__5727__auto___42296 = G__42297;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((3) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5733__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__39631){
var map__39633 = p__39631;
var map__39633__$1 = cljs.core.__destructure_map(map__39633);
var opts = map__39633__$1;
var statearr_39641_42314 = state;
(statearr_39641_42314[(1)] = cont_block);


var temp__5823__auto__ = cljs.core.async.do_alts((function (val){
var statearr_39645_42317 = state;
(statearr_39645_42317[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5823__auto__)){
var cb = temp__5823__auto__;
var statearr_39649_42322 = state;
(statearr_39649_42322[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq39626){
var G__39627 = cljs.core.first(seq39626);
var seq39626__$1 = cljs.core.next(seq39626);
var G__39628 = cljs.core.first(seq39626__$1);
var seq39626__$2 = cljs.core.next(seq39626__$1);
var G__39629 = cljs.core.first(seq39626__$2);
var seq39626__$3 = cljs.core.next(seq39626__$2);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__39627,G__39628,G__39629,seq39626__$3);
}));


/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async39661 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta39662){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta39662 = meta39662;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async39661.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39663,meta39662__$1){
var self__ = this;
var _39663__$1 = this;
return (new cljs.core.async.t_cljs$core$async39661(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta39662__$1));
}));

(cljs.core.async.t_cljs$core$async39661.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39663){
var self__ = this;
var _39663__$1 = this;
return self__.meta39662;
}));

(cljs.core.async.t_cljs$core$async39661.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async39661.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async39661.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async39661.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null, ));
}));

(cljs.core.async.t_cljs$core$async39661.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null, ));
}));

(cljs.core.async.t_cljs$core$async39661.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null, ));
}));

(cljs.core.async.t_cljs$core$async39661.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null, ));
}));

(cljs.core.async.t_cljs$core$async39661.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null, mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null, ));
}));

(cljs.core.async.t_cljs$core$async39661.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta39662","meta39662",-941707614,null)], null);
}));

(cljs.core.async.t_cljs$core$async39661.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async39661.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async39661");

(cljs.core.async.t_cljs$core$async39661.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async39661");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async39661.
 */
cljs.core.async.__GT_t_cljs$core$async39661 = (function cljs$core$async$__GT_t_cljs$core$async39661(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta39662){
return (new cljs.core.async.t_cljs$core$async39661(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta39662));
});


/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null, v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (cljs.core.seq(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (new cljs.core.async.t_cljs$core$async39661(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
var c__37794__auto___42346 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37795__auto__ = (function (){var switch__37550__auto__ = (function (state_39742){
var state_val_39743 = (state_39742[(1)]);
if((state_val_39743 === (7))){
var inst_39699 = (state_39742[(2)]);
var state_39742__$1 = state_39742;
if(cljs.core.truth_(inst_39699)){
var statearr_39746_42355 = state_39742__$1;
(statearr_39746_42355[(1)] = (8));

} else {
var statearr_39747_42357 = state_39742__$1;
(statearr_39747_42357[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39743 === (20))){
var inst_39690 = (state_39742[(7)]);
var state_39742__$1 = state_39742;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_39742__$1,(23),out,inst_39690);
} else {
if((state_val_39743 === (1))){
var inst_39673 = calc_state();
var inst_39674 = cljs.core.__destructure_map(inst_39673);
var inst_39675 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39674,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_39676 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39674,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_39677 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39674,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_39678 = inst_39673;
var state_39742__$1 = (function (){var statearr_39748 = state_39742;
(statearr_39748[(8)] = inst_39675);

(statearr_39748[(9)] = inst_39676);

(statearr_39748[(10)] = inst_39677);

(statearr_39748[(11)] = inst_39678);

return statearr_39748;
})();
var statearr_39752_42358 = state_39742__$1;
(statearr_39752_42358[(2)] = null);

(statearr_39752_42358[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39743 === (24))){
var inst_39681 = (state_39742[(12)]);
var inst_39678 = inst_39681;
var state_39742__$1 = (function (){var statearr_39755 = state_39742;
(statearr_39755[(11)] = inst_39678);

return statearr_39755;
})();
var statearr_39757_42359 = state_39742__$1;
(statearr_39757_42359[(2)] = null);

(statearr_39757_42359[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39743 === (4))){
var inst_39690 = (state_39742[(7)]);
var inst_39694 = (state_39742[(13)]);
var inst_39689 = (state_39742[(2)]);
var inst_39690__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39689,(0),null);
var inst_39691 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39689,(1),null);
var inst_39694__$1 = (inst_39690__$1 == null);
var state_39742__$1 = (function (){var statearr_39758 = state_39742;
(statearr_39758[(7)] = inst_39690__$1);

(statearr_39758[(14)] = inst_39691);

(statearr_39758[(13)] = inst_39694__$1);

return statearr_39758;
})();
if(cljs.core.truth_(inst_39694__$1)){
var statearr_39759_42393 = state_39742__$1;
(statearr_39759_42393[(1)] = (5));

} else {
var statearr_39762_42394 = state_39742__$1;
(statearr_39762_42394[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39743 === (15))){
var inst_39682 = (state_39742[(15)]);
var inst_39713 = (state_39742[(16)]);
var inst_39713__$1 = cljs.core.empty_QMARK_(inst_39682);
var state_39742__$1 = (function (){var statearr_39767 = state_39742;
(statearr_39767[(16)] = inst_39713__$1);

return statearr_39767;
})();
if(inst_39713__$1){
var statearr_39768_42395 = state_39742__$1;
(statearr_39768_42395[(1)] = (17));

} else {
var statearr_39769_42396 = state_39742__$1;
(statearr_39769_42396[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39743 === (21))){
var inst_39681 = (state_39742[(12)]);
var inst_39678 = inst_39681;
var state_39742__$1 = (function (){var statearr_39770 = state_39742;
(statearr_39770[(11)] = inst_39678);

return statearr_39770;
})();
var statearr_39771_42397 = state_39742__$1;
(statearr_39771_42397[(2)] = null);

(statearr_39771_42397[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39743 === (13))){
var inst_39706 = (state_39742[(2)]);
var inst_39707 = calc_state();
var inst_39678 = inst_39707;
var state_39742__$1 = (function (){var statearr_39772 = state_39742;
(statearr_39772[(17)] = inst_39706);

(statearr_39772[(11)] = inst_39678);

return statearr_39772;
})();
var statearr_39773_42401 = state_39742__$1;
(statearr_39773_42401[(2)] = null);

(statearr_39773_42401[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39743 === (22))){
var inst_39733 = (state_39742[(2)]);
var state_39742__$1 = state_39742;
var statearr_39775_42402 = state_39742__$1;
(statearr_39775_42402[(2)] = inst_39733);

(statearr_39775_42402[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39743 === (6))){
var inst_39691 = (state_39742[(14)]);
var inst_39697 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_39691,change);
var state_39742__$1 = state_39742;
var statearr_39779_42403 = state_39742__$1;
(statearr_39779_42403[(2)] = inst_39697);

(statearr_39779_42403[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39743 === (25))){
var state_39742__$1 = state_39742;
var statearr_39781_42409 = state_39742__$1;
(statearr_39781_42409[(2)] = null);

(statearr_39781_42409[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39743 === (17))){
var inst_39683 = (state_39742[(18)]);
var inst_39691 = (state_39742[(14)]);
var inst_39715 = (inst_39683.cljs$core$IFn$_invoke$arity$1 ? inst_39683.cljs$core$IFn$_invoke$arity$1(inst_39691) : inst_39683.call(null, inst_39691));
var inst_39716 = cljs.core.not(inst_39715);
var state_39742__$1 = state_39742;
var statearr_39785_42410 = state_39742__$1;
(statearr_39785_42410[(2)] = inst_39716);

(statearr_39785_42410[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39743 === (3))){
var inst_39737 = (state_39742[(2)]);
var state_39742__$1 = state_39742;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39742__$1,inst_39737);
} else {
if((state_val_39743 === (12))){
var state_39742__$1 = state_39742;
var statearr_39788_42412 = state_39742__$1;
(statearr_39788_42412[(2)] = null);

(statearr_39788_42412[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39743 === (2))){
var inst_39678 = (state_39742[(11)]);
var inst_39681 = (state_39742[(12)]);
var inst_39681__$1 = cljs.core.__destructure_map(inst_39678);
var inst_39682 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39681__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_39683 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39681__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_39684 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39681__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_39742__$1 = (function (){var statearr_39791 = state_39742;
(statearr_39791[(12)] = inst_39681__$1);

(statearr_39791[(15)] = inst_39682);

(statearr_39791[(18)] = inst_39683);

return statearr_39791;
})();
return cljs.core.async.ioc_alts_BANG_(state_39742__$1,(4),inst_39684);
} else {
if((state_val_39743 === (23))){
var inst_39724 = (state_39742[(2)]);
var state_39742__$1 = state_39742;
if(cljs.core.truth_(inst_39724)){
var statearr_39795_42413 = state_39742__$1;
(statearr_39795_42413[(1)] = (24));

} else {
var statearr_39797_42414 = state_39742__$1;
(statearr_39797_42414[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39743 === (19))){
var inst_39719 = (state_39742[(2)]);
var state_39742__$1 = state_39742;
var statearr_39801_42415 = state_39742__$1;
(statearr_39801_42415[(2)] = inst_39719);

(statearr_39801_42415[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39743 === (11))){
var inst_39691 = (state_39742[(14)]);
var inst_39703 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_39691);
var state_39742__$1 = state_39742;
var statearr_39803_42417 = state_39742__$1;
(statearr_39803_42417[(2)] = inst_39703);

(statearr_39803_42417[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39743 === (9))){
var inst_39682 = (state_39742[(15)]);
var inst_39691 = (state_39742[(14)]);
var inst_39710 = (state_39742[(19)]);
var inst_39710__$1 = (inst_39682.cljs$core$IFn$_invoke$arity$1 ? inst_39682.cljs$core$IFn$_invoke$arity$1(inst_39691) : inst_39682.call(null, inst_39691));
var state_39742__$1 = (function (){var statearr_39807 = state_39742;
(statearr_39807[(19)] = inst_39710__$1);

return statearr_39807;
})();
if(cljs.core.truth_(inst_39710__$1)){
var statearr_39809_42419 = state_39742__$1;
(statearr_39809_42419[(1)] = (14));

} else {
var statearr_39810_42420 = state_39742__$1;
(statearr_39810_42420[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39743 === (5))){
var inst_39694 = (state_39742[(13)]);
var state_39742__$1 = state_39742;
var statearr_39814_42421 = state_39742__$1;
(statearr_39814_42421[(2)] = inst_39694);

(statearr_39814_42421[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39743 === (14))){
var inst_39710 = (state_39742[(19)]);
var state_39742__$1 = state_39742;
var statearr_39816_42425 = state_39742__$1;
(statearr_39816_42425[(2)] = inst_39710);

(statearr_39816_42425[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39743 === (26))){
var inst_39729 = (state_39742[(2)]);
var state_39742__$1 = state_39742;
var statearr_39817_42429 = state_39742__$1;
(statearr_39817_42429[(2)] = inst_39729);

(statearr_39817_42429[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39743 === (16))){
var inst_39721 = (state_39742[(2)]);
var state_39742__$1 = state_39742;
if(cljs.core.truth_(inst_39721)){
var statearr_39820_42434 = state_39742__$1;
(statearr_39820_42434[(1)] = (20));

} else {
var statearr_39821_42435 = state_39742__$1;
(statearr_39821_42435[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39743 === (10))){
var inst_39735 = (state_39742[(2)]);
var state_39742__$1 = state_39742;
var statearr_39826_42436 = state_39742__$1;
(statearr_39826_42436[(2)] = inst_39735);

(statearr_39826_42436[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39743 === (18))){
var inst_39713 = (state_39742[(16)]);
var state_39742__$1 = state_39742;
var statearr_39827_42437 = state_39742__$1;
(statearr_39827_42437[(2)] = inst_39713);

(statearr_39827_42437[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39743 === (8))){
var inst_39690 = (state_39742[(7)]);
var inst_39701 = (inst_39690 == null);
var state_39742__$1 = state_39742;
if(cljs.core.truth_(inst_39701)){
var statearr_39829_42438 = state_39742__$1;
(statearr_39829_42438[(1)] = (11));

} else {
var statearr_39830_42442 = state_39742__$1;
(statearr_39830_42442[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__37551__auto__ = null;
var cljs$core$async$mix_$_state_machine__37551__auto____0 = (function (){
var statearr_39841 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39841[(0)] = cljs$core$async$mix_$_state_machine__37551__auto__);

(statearr_39841[(1)] = (1));

return statearr_39841;
});
var cljs$core$async$mix_$_state_machine__37551__auto____1 = (function (state_39742){
while(true){
var ret_value__37552__auto__ = (function (){try{while(true){
var result__37553__auto__ = switch__37550__auto__(state_39742);
if(cljs.core.keyword_identical_QMARK_(result__37553__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37553__auto__;
}
break;
}
}catch (e39846){var ex__37554__auto__ = e39846;
var statearr_39847_42443 = state_39742;
(statearr_39847_42443[(2)] = ex__37554__auto__);


if(cljs.core.seq((state_39742[(4)]))){
var statearr_39851_42444 = state_39742;
(statearr_39851_42444[(1)] = cljs.core.first((state_39742[(4)])));

} else {
throw ex__37554__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42445 = state_39742;
state_39742 = G__42445;
continue;
} else {
return ret_value__37552__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__37551__auto__ = function(state_39742){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__37551__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__37551__auto____1.call(this,state_39742);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__37551__auto____0;
cljs$core$async$mix_$_state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__37551__auto____1;
return cljs$core$async$mix_$_state_machine__37551__auto__;
})()
})();
var state__37796__auto__ = (function (){var statearr_39857 = f__37795__auto__();
(statearr_39857[(6)] = c__37794__auto___42346);

return statearr_39857;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37796__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_42446 = (function (p,v,ch,close_QMARK_){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5351__auto__.call(null, p,v,ch,close_QMARK_));
} else {
var m__5349__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5349__auto__.call(null, p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_42446(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_42449 = (function (p,v,ch){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5351__auto__.call(null, p,v,ch));
} else {
var m__5349__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5349__auto__.call(null, p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_42449(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_42452 = (function() {
var G__42453 = null;
var G__42453__1 = (function (p){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5351__auto__.call(null, p));
} else {
var m__5349__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5349__auto__.call(null, p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__42453__2 = (function (p,v){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5351__auto__.call(null, p,v));
} else {
var m__5349__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5349__auto__.call(null, p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__42453 = function(p,v){
switch(arguments.length){
case 1:
return G__42453__1.call(this,p);
case 2:
return G__42453__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__42453.cljs$core$IFn$_invoke$arity$1 = G__42453__1;
G__42453.cljs$core$IFn$_invoke$arity$2 = G__42453__2;
return G__42453;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__39915 = arguments.length;
switch (G__39915) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_42452(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_42452(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);



/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async39957 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta39958){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta39958 = meta39958;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async39957.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39959,meta39958__$1){
var self__ = this;
var _39959__$1 = this;
return (new cljs.core.async.t_cljs$core$async39957(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta39958__$1));
}));

(cljs.core.async.t_cljs$core$async39957.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39959){
var self__ = this;
var _39959__$1 = this;
return self__.meta39958;
}));

(cljs.core.async.t_cljs$core$async39957.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async39957.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async39957.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async39957.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null, topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async39957.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5823__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5823__auto__)){
var m = temp__5823__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async39957.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async39957.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async39957.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta39958","meta39958",13341630,null)], null);
}));

(cljs.core.async.t_cljs$core$async39957.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async39957.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async39957");

(cljs.core.async.t_cljs$core$async39957.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async39957");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async39957.
 */
cljs.core.async.__GT_t_cljs$core$async39957 = (function cljs$core$async$__GT_t_cljs$core$async39957(ch,topic_fn,buf_fn,mults,ensure_mult,meta39958){
return (new cljs.core.async.t_cljs$core$async39957(ch,topic_fn,buf_fn,mults,ensure_mult,meta39958));
});


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__39936 = arguments.length;
switch (G__39936) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__5002__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__39929_SHARP_){
if(cljs.core.truth_((p1__39929_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__39929_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__39929_SHARP_.call(null, topic)))){
return p1__39929_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__39929_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null, topic)))));
}
})),topic);
}
});
var p = (new cljs.core.async.t_cljs$core$async39957(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
var c__37794__auto___42473 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37795__auto__ = (function (){var switch__37550__auto__ = (function (state_40110){
var state_val_40111 = (state_40110[(1)]);
if((state_val_40111 === (7))){
var inst_40099 = (state_40110[(2)]);
var state_40110__$1 = state_40110;
var statearr_40117_42474 = state_40110__$1;
(statearr_40117_42474[(2)] = inst_40099);

(statearr_40117_42474[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40111 === (20))){
var state_40110__$1 = state_40110;
var statearr_40131_42479 = state_40110__$1;
(statearr_40131_42479[(2)] = null);

(statearr_40131_42479[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40111 === (1))){
var state_40110__$1 = state_40110;
var statearr_40135_42480 = state_40110__$1;
(statearr_40135_42480[(2)] = null);

(statearr_40135_42480[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40111 === (24))){
var inst_40080 = (state_40110[(7)]);
var inst_40091 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_40080);
var state_40110__$1 = state_40110;
var statearr_40141_42484 = state_40110__$1;
(statearr_40141_42484[(2)] = inst_40091);

(statearr_40141_42484[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40111 === (4))){
var inst_40007 = (state_40110[(8)]);
var inst_40007__$1 = (state_40110[(2)]);
var inst_40013 = (inst_40007__$1 == null);
var state_40110__$1 = (function (){var statearr_40149 = state_40110;
(statearr_40149[(8)] = inst_40007__$1);

return statearr_40149;
})();
if(cljs.core.truth_(inst_40013)){
var statearr_40150_42486 = state_40110__$1;
(statearr_40150_42486[(1)] = (5));

} else {
var statearr_40155_42487 = state_40110__$1;
(statearr_40155_42487[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40111 === (15))){
var inst_40070 = (state_40110[(2)]);
var state_40110__$1 = state_40110;
var statearr_40157_42488 = state_40110__$1;
(statearr_40157_42488[(2)] = inst_40070);

(statearr_40157_42488[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40111 === (21))){
var inst_40096 = (state_40110[(2)]);
var state_40110__$1 = (function (){var statearr_40165 = state_40110;
(statearr_40165[(9)] = inst_40096);

return statearr_40165;
})();
var statearr_40166_42489 = state_40110__$1;
(statearr_40166_42489[(2)] = null);

(statearr_40166_42489[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40111 === (13))){
var inst_40045 = (state_40110[(10)]);
var inst_40048 = cljs.core.chunked_seq_QMARK_(inst_40045);
var state_40110__$1 = state_40110;
if(inst_40048){
var statearr_40171_42493 = state_40110__$1;
(statearr_40171_42493[(1)] = (16));

} else {
var statearr_40172_42494 = state_40110__$1;
(statearr_40172_42494[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40111 === (22))){
var inst_40087 = (state_40110[(2)]);
var state_40110__$1 = state_40110;
if(cljs.core.truth_(inst_40087)){
var statearr_40177_42496 = state_40110__$1;
(statearr_40177_42496[(1)] = (23));

} else {
var statearr_40178_42497 = state_40110__$1;
(statearr_40178_42497[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40111 === (6))){
var inst_40007 = (state_40110[(8)]);
var inst_40080 = (state_40110[(7)]);
var inst_40082 = (state_40110[(11)]);
var inst_40080__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_40007) : topic_fn.call(null, inst_40007));
var inst_40081 = cljs.core.deref(mults);
var inst_40082__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40081,inst_40080__$1);
var state_40110__$1 = (function (){var statearr_40183 = state_40110;
(statearr_40183[(7)] = inst_40080__$1);

(statearr_40183[(11)] = inst_40082__$1);

return statearr_40183;
})();
if(cljs.core.truth_(inst_40082__$1)){
var statearr_40185_42502 = state_40110__$1;
(statearr_40185_42502[(1)] = (19));

} else {
var statearr_40190_42503 = state_40110__$1;
(statearr_40190_42503[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40111 === (25))){
var inst_40093 = (state_40110[(2)]);
var state_40110__$1 = state_40110;
var statearr_40196_42504 = state_40110__$1;
(statearr_40196_42504[(2)] = inst_40093);

(statearr_40196_42504[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40111 === (17))){
var inst_40045 = (state_40110[(10)]);
var inst_40059 = cljs.core.first(inst_40045);
var inst_40061 = cljs.core.async.muxch_STAR_(inst_40059);
var inst_40062 = cljs.core.async.close_BANG_(inst_40061);
var inst_40064 = cljs.core.next(inst_40045);
var inst_40026 = inst_40064;
var inst_40027 = null;
var inst_40028 = (0);
var inst_40029 = (0);
var state_40110__$1 = (function (){var statearr_40204 = state_40110;
(statearr_40204[(12)] = inst_40062);

(statearr_40204[(13)] = inst_40026);

(statearr_40204[(14)] = inst_40027);

(statearr_40204[(15)] = inst_40028);

(statearr_40204[(16)] = inst_40029);

return statearr_40204;
})();
var statearr_40208_42508 = state_40110__$1;
(statearr_40208_42508[(2)] = null);

(statearr_40208_42508[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40111 === (3))){
var inst_40104 = (state_40110[(2)]);
var state_40110__$1 = state_40110;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40110__$1,inst_40104);
} else {
if((state_val_40111 === (12))){
var inst_40073 = (state_40110[(2)]);
var state_40110__$1 = state_40110;
var statearr_40217_42509 = state_40110__$1;
(statearr_40217_42509[(2)] = inst_40073);

(statearr_40217_42509[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40111 === (2))){
var state_40110__$1 = state_40110;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40110__$1,(4),ch);
} else {
if((state_val_40111 === (23))){
var state_40110__$1 = state_40110;
var statearr_40218_42510 = state_40110__$1;
(statearr_40218_42510[(2)] = null);

(statearr_40218_42510[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40111 === (19))){
var inst_40082 = (state_40110[(11)]);
var inst_40007 = (state_40110[(8)]);
var inst_40085 = cljs.core.async.muxch_STAR_(inst_40082);
var state_40110__$1 = state_40110;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_40110__$1,(22),inst_40085,inst_40007);
} else {
if((state_val_40111 === (11))){
var inst_40026 = (state_40110[(13)]);
var inst_40045 = (state_40110[(10)]);
var inst_40045__$1 = cljs.core.seq(inst_40026);
var state_40110__$1 = (function (){var statearr_40219 = state_40110;
(statearr_40219[(10)] = inst_40045__$1);

return statearr_40219;
})();
if(inst_40045__$1){
var statearr_40220_42515 = state_40110__$1;
(statearr_40220_42515[(1)] = (13));

} else {
var statearr_40221_42516 = state_40110__$1;
(statearr_40221_42516[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40111 === (9))){
var inst_40075 = (state_40110[(2)]);
var state_40110__$1 = state_40110;
var statearr_40236_42517 = state_40110__$1;
(statearr_40236_42517[(2)] = inst_40075);

(statearr_40236_42517[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40111 === (5))){
var inst_40023 = cljs.core.deref(mults);
var inst_40024 = cljs.core.vals(inst_40023);
var inst_40025 = cljs.core.seq(inst_40024);
var inst_40026 = inst_40025;
var inst_40027 = null;
var inst_40028 = (0);
var inst_40029 = (0);
var state_40110__$1 = (function (){var statearr_40241 = state_40110;
(statearr_40241[(13)] = inst_40026);

(statearr_40241[(14)] = inst_40027);

(statearr_40241[(15)] = inst_40028);

(statearr_40241[(16)] = inst_40029);

return statearr_40241;
})();
var statearr_40242_42518 = state_40110__$1;
(statearr_40242_42518[(2)] = null);

(statearr_40242_42518[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40111 === (14))){
var state_40110__$1 = state_40110;
var statearr_40246_42519 = state_40110__$1;
(statearr_40246_42519[(2)] = null);

(statearr_40246_42519[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40111 === (16))){
var inst_40045 = (state_40110[(10)]);
var inst_40050 = cljs.core.chunk_first(inst_40045);
var inst_40051 = cljs.core.chunk_rest(inst_40045);
var inst_40055 = cljs.core.count(inst_40050);
var inst_40026 = inst_40051;
var inst_40027 = inst_40050;
var inst_40028 = inst_40055;
var inst_40029 = (0);
var state_40110__$1 = (function (){var statearr_40251 = state_40110;
(statearr_40251[(13)] = inst_40026);

(statearr_40251[(14)] = inst_40027);

(statearr_40251[(15)] = inst_40028);

(statearr_40251[(16)] = inst_40029);

return statearr_40251;
})();
var statearr_40253_42521 = state_40110__$1;
(statearr_40253_42521[(2)] = null);

(statearr_40253_42521[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40111 === (10))){
var inst_40027 = (state_40110[(14)]);
var inst_40029 = (state_40110[(16)]);
var inst_40026 = (state_40110[(13)]);
var inst_40028 = (state_40110[(15)]);
var inst_40035 = cljs.core._nth(inst_40027,inst_40029);
var inst_40036 = cljs.core.async.muxch_STAR_(inst_40035);
var inst_40038 = cljs.core.async.close_BANG_(inst_40036);
var inst_40041 = (inst_40029 + (1));
var tmp40243 = inst_40027;
var tmp40244 = inst_40026;
var tmp40245 = inst_40028;
var inst_40026__$1 = tmp40244;
var inst_40027__$1 = tmp40243;
var inst_40028__$1 = tmp40245;
var inst_40029__$1 = inst_40041;
var state_40110__$1 = (function (){var statearr_40254 = state_40110;
(statearr_40254[(17)] = inst_40038);

(statearr_40254[(13)] = inst_40026__$1);

(statearr_40254[(14)] = inst_40027__$1);

(statearr_40254[(15)] = inst_40028__$1);

(statearr_40254[(16)] = inst_40029__$1);

return statearr_40254;
})();
var statearr_40255_42525 = state_40110__$1;
(statearr_40255_42525[(2)] = null);

(statearr_40255_42525[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40111 === (18))){
var inst_40067 = (state_40110[(2)]);
var state_40110__$1 = state_40110;
var statearr_40256_42526 = state_40110__$1;
(statearr_40256_42526[(2)] = inst_40067);

(statearr_40256_42526[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40111 === (8))){
var inst_40029 = (state_40110[(16)]);
var inst_40028 = (state_40110[(15)]);
var inst_40032 = (inst_40029 < inst_40028);
var inst_40033 = inst_40032;
var state_40110__$1 = state_40110;
if(cljs.core.truth_(inst_40033)){
var statearr_40257_42527 = state_40110__$1;
(statearr_40257_42527[(1)] = (10));

} else {
var statearr_40258_42528 = state_40110__$1;
(statearr_40258_42528[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__37551__auto__ = null;
var cljs$core$async$state_machine__37551__auto____0 = (function (){
var statearr_40259 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40259[(0)] = cljs$core$async$state_machine__37551__auto__);

(statearr_40259[(1)] = (1));

return statearr_40259;
});
var cljs$core$async$state_machine__37551__auto____1 = (function (state_40110){
while(true){
var ret_value__37552__auto__ = (function (){try{while(true){
var result__37553__auto__ = switch__37550__auto__(state_40110);
if(cljs.core.keyword_identical_QMARK_(result__37553__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37553__auto__;
}
break;
}
}catch (e40260){var ex__37554__auto__ = e40260;
var statearr_40261_42529 = state_40110;
(statearr_40261_42529[(2)] = ex__37554__auto__);


if(cljs.core.seq((state_40110[(4)]))){
var statearr_40262_42530 = state_40110;
(statearr_40262_42530[(1)] = cljs.core.first((state_40110[(4)])));

} else {
throw ex__37554__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42531 = state_40110;
state_40110 = G__42531;
continue;
} else {
return ret_value__37552__auto__;
}
break;
}
});
cljs$core$async$state_machine__37551__auto__ = function(state_40110){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__37551__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__37551__auto____1.call(this,state_40110);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__37551__auto____0;
cljs$core$async$state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__37551__auto____1;
return cljs$core$async$state_machine__37551__auto__;
})()
})();
var state__37796__auto__ = (function (){var statearr_40263 = f__37795__auto__();
(statearr_40263[(6)] = c__37794__auto___42473);

return statearr_40263;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37796__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__40265 = arguments.length;
switch (G__40265) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__40273 = arguments.length;
switch (G__40273) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__40283 = arguments.length;
switch (G__40283) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_(out);
} else {
var c__37794__auto___42550 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37795__auto__ = (function (){var switch__37550__auto__ = (function (state_40366){
var state_val_40367 = (state_40366[(1)]);
if((state_val_40367 === (7))){
var state_40366__$1 = state_40366;
var statearr_40371_42551 = state_40366__$1;
(statearr_40371_42551[(2)] = null);

(statearr_40371_42551[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40367 === (1))){
var state_40366__$1 = state_40366;
var statearr_40372_42553 = state_40366__$1;
(statearr_40372_42553[(2)] = null);

(statearr_40372_42553[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40367 === (4))){
var inst_40305 = (state_40366[(7)]);
var inst_40304 = (state_40366[(8)]);
var inst_40310 = (inst_40305 < inst_40304);
var state_40366__$1 = state_40366;
if(cljs.core.truth_(inst_40310)){
var statearr_40383_42555 = state_40366__$1;
(statearr_40383_42555[(1)] = (6));

} else {
var statearr_40384_42556 = state_40366__$1;
(statearr_40384_42556[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40367 === (15))){
var inst_40333 = (state_40366[(9)]);
var inst_40351 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_40333);
var state_40366__$1 = state_40366;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_40366__$1,(17),out,inst_40351);
} else {
if((state_val_40367 === (13))){
var inst_40333 = (state_40366[(9)]);
var inst_40333__$1 = (state_40366[(2)]);
var inst_40340 = cljs.core.some(cljs.core.nil_QMARK_,inst_40333__$1);
var state_40366__$1 = (function (){var statearr_40388 = state_40366;
(statearr_40388[(9)] = inst_40333__$1);

return statearr_40388;
})();
if(cljs.core.truth_(inst_40340)){
var statearr_40390_42559 = state_40366__$1;
(statearr_40390_42559[(1)] = (14));

} else {
var statearr_40394_42560 = state_40366__$1;
(statearr_40394_42560[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40367 === (6))){
var state_40366__$1 = state_40366;
var statearr_40395_42561 = state_40366__$1;
(statearr_40395_42561[(2)] = null);

(statearr_40395_42561[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40367 === (17))){
var inst_40353 = (state_40366[(2)]);
var state_40366__$1 = (function (){var statearr_40409 = state_40366;
(statearr_40409[(10)] = inst_40353);

return statearr_40409;
})();
var statearr_40411_42562 = state_40366__$1;
(statearr_40411_42562[(2)] = null);

(statearr_40411_42562[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40367 === (3))){
var inst_40358 = (state_40366[(2)]);
var state_40366__$1 = state_40366;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40366__$1,inst_40358);
} else {
if((state_val_40367 === (12))){
var _ = (function (){var statearr_40413 = state_40366;
(statearr_40413[(4)] = cljs.core.rest((state_40366[(4)])));

return statearr_40413;
})();
var state_40366__$1 = state_40366;
var ex40403 = (state_40366__$1[(2)]);
var statearr_40414_42563 = state_40366__$1;
(statearr_40414_42563[(5)] = ex40403);


if((ex40403 instanceof Object)){
var statearr_40422_42564 = state_40366__$1;
(statearr_40422_42564[(1)] = (11));

(statearr_40422_42564[(5)] = null);

} else {
throw ex40403;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40367 === (2))){
var inst_40303 = cljs.core.reset_BANG_(dctr,cnt);
var inst_40304 = cnt;
var inst_40305 = (0);
var state_40366__$1 = (function (){var statearr_40429 = state_40366;
(statearr_40429[(11)] = inst_40303);

(statearr_40429[(8)] = inst_40304);

(statearr_40429[(7)] = inst_40305);

return statearr_40429;
})();
var statearr_40430_42565 = state_40366__$1;
(statearr_40430_42565[(2)] = null);

(statearr_40430_42565[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40367 === (11))){
var inst_40312 = (state_40366[(2)]);
var inst_40313 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_40366__$1 = (function (){var statearr_40431 = state_40366;
(statearr_40431[(12)] = inst_40312);

return statearr_40431;
})();
var statearr_40432_42566 = state_40366__$1;
(statearr_40432_42566[(2)] = inst_40313);

(statearr_40432_42566[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40367 === (9))){
var inst_40305 = (state_40366[(7)]);
var _ = (function (){var statearr_40433 = state_40366;
(statearr_40433[(4)] = cljs.core.cons((12),(state_40366[(4)])));

return statearr_40433;
})();
var inst_40319 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_40305) : chs__$1.call(null, inst_40305));
var inst_40320 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_40305) : done.call(null, inst_40305));
var inst_40321 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_40319,inst_40320);
var ___$1 = (function (){var statearr_40434 = state_40366;
(statearr_40434[(4)] = cljs.core.rest((state_40366[(4)])));

return statearr_40434;
})();
var state_40366__$1 = state_40366;
var statearr_40435_42569 = state_40366__$1;
(statearr_40435_42569[(2)] = inst_40321);

(statearr_40435_42569[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40367 === (5))){
var inst_40331 = (state_40366[(2)]);
var state_40366__$1 = (function (){var statearr_40436 = state_40366;
(statearr_40436[(13)] = inst_40331);

return statearr_40436;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40366__$1,(13),dchan);
} else {
if((state_val_40367 === (14))){
var inst_40343 = cljs.core.async.close_BANG_(out);
var state_40366__$1 = state_40366;
var statearr_40437_42570 = state_40366__$1;
(statearr_40437_42570[(2)] = inst_40343);

(statearr_40437_42570[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40367 === (16))){
var inst_40356 = (state_40366[(2)]);
var state_40366__$1 = state_40366;
var statearr_40440_42571 = state_40366__$1;
(statearr_40440_42571[(2)] = inst_40356);

(statearr_40440_42571[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40367 === (10))){
var inst_40305 = (state_40366[(7)]);
var inst_40324 = (state_40366[(2)]);
var inst_40325 = (inst_40305 + (1));
var inst_40305__$1 = inst_40325;
var state_40366__$1 = (function (){var statearr_40443 = state_40366;
(statearr_40443[(14)] = inst_40324);

(statearr_40443[(7)] = inst_40305__$1);

return statearr_40443;
})();
var statearr_40445_42576 = state_40366__$1;
(statearr_40445_42576[(2)] = null);

(statearr_40445_42576[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40367 === (8))){
var inst_40329 = (state_40366[(2)]);
var state_40366__$1 = state_40366;
var statearr_40446_42577 = state_40366__$1;
(statearr_40446_42577[(2)] = inst_40329);

(statearr_40446_42577[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__37551__auto__ = null;
var cljs$core$async$state_machine__37551__auto____0 = (function (){
var statearr_40449 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40449[(0)] = cljs$core$async$state_machine__37551__auto__);

(statearr_40449[(1)] = (1));

return statearr_40449;
});
var cljs$core$async$state_machine__37551__auto____1 = (function (state_40366){
while(true){
var ret_value__37552__auto__ = (function (){try{while(true){
var result__37553__auto__ = switch__37550__auto__(state_40366);
if(cljs.core.keyword_identical_QMARK_(result__37553__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37553__auto__;
}
break;
}
}catch (e40450){var ex__37554__auto__ = e40450;
var statearr_40451_42580 = state_40366;
(statearr_40451_42580[(2)] = ex__37554__auto__);


if(cljs.core.seq((state_40366[(4)]))){
var statearr_40453_42581 = state_40366;
(statearr_40453_42581[(1)] = cljs.core.first((state_40366[(4)])));

} else {
throw ex__37554__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42582 = state_40366;
state_40366 = G__42582;
continue;
} else {
return ret_value__37552__auto__;
}
break;
}
});
cljs$core$async$state_machine__37551__auto__ = function(state_40366){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__37551__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__37551__auto____1.call(this,state_40366);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__37551__auto____0;
cljs$core$async$state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__37551__auto____1;
return cljs$core$async$state_machine__37551__auto__;
})()
})();
var state__37796__auto__ = (function (){var statearr_40458 = f__37795__auto__();
(statearr_40458[(6)] = c__37794__auto___42550);

return statearr_40458;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37796__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__40467 = arguments.length;
switch (G__40467) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__37794__auto___42586 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37795__auto__ = (function (){var switch__37550__auto__ = (function (state_40512){
var state_val_40513 = (state_40512[(1)]);
if((state_val_40513 === (7))){
var inst_40486 = (state_40512[(7)]);
var inst_40487 = (state_40512[(8)]);
var inst_40486__$1 = (state_40512[(2)]);
var inst_40487__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40486__$1,(0),null);
var inst_40488 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40486__$1,(1),null);
var inst_40489 = (inst_40487__$1 == null);
var state_40512__$1 = (function (){var statearr_40514 = state_40512;
(statearr_40514[(7)] = inst_40486__$1);

(statearr_40514[(8)] = inst_40487__$1);

(statearr_40514[(9)] = inst_40488);

return statearr_40514;
})();
if(cljs.core.truth_(inst_40489)){
var statearr_40515_42597 = state_40512__$1;
(statearr_40515_42597[(1)] = (8));

} else {
var statearr_40516_42598 = state_40512__$1;
(statearr_40516_42598[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40513 === (1))){
var inst_40476 = cljs.core.vec(chs);
var inst_40477 = inst_40476;
var state_40512__$1 = (function (){var statearr_40517 = state_40512;
(statearr_40517[(10)] = inst_40477);

return statearr_40517;
})();
var statearr_40518_42599 = state_40512__$1;
(statearr_40518_42599[(2)] = null);

(statearr_40518_42599[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40513 === (4))){
var inst_40477 = (state_40512[(10)]);
var state_40512__$1 = state_40512;
return cljs.core.async.ioc_alts_BANG_(state_40512__$1,(7),inst_40477);
} else {
if((state_val_40513 === (6))){
var inst_40505 = (state_40512[(2)]);
var state_40512__$1 = state_40512;
var statearr_40519_42601 = state_40512__$1;
(statearr_40519_42601[(2)] = inst_40505);

(statearr_40519_42601[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40513 === (3))){
var inst_40510 = (state_40512[(2)]);
var state_40512__$1 = state_40512;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40512__$1,inst_40510);
} else {
if((state_val_40513 === (2))){
var inst_40477 = (state_40512[(10)]);
var inst_40479 = cljs.core.count(inst_40477);
var inst_40480 = (inst_40479 > (0));
var state_40512__$1 = state_40512;
if(cljs.core.truth_(inst_40480)){
var statearr_40521_42605 = state_40512__$1;
(statearr_40521_42605[(1)] = (4));

} else {
var statearr_40522_42606 = state_40512__$1;
(statearr_40522_42606[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40513 === (11))){
var inst_40477 = (state_40512[(10)]);
var inst_40498 = (state_40512[(2)]);
var tmp40520 = inst_40477;
var inst_40477__$1 = tmp40520;
var state_40512__$1 = (function (){var statearr_40523 = state_40512;
(statearr_40523[(11)] = inst_40498);

(statearr_40523[(10)] = inst_40477__$1);

return statearr_40523;
})();
var statearr_40524_42610 = state_40512__$1;
(statearr_40524_42610[(2)] = null);

(statearr_40524_42610[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40513 === (9))){
var inst_40487 = (state_40512[(8)]);
var state_40512__$1 = state_40512;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_40512__$1,(11),out,inst_40487);
} else {
if((state_val_40513 === (5))){
var inst_40503 = cljs.core.async.close_BANG_(out);
var state_40512__$1 = state_40512;
var statearr_40525_42615 = state_40512__$1;
(statearr_40525_42615[(2)] = inst_40503);

(statearr_40525_42615[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40513 === (10))){
var inst_40501 = (state_40512[(2)]);
var state_40512__$1 = state_40512;
var statearr_40526_42617 = state_40512__$1;
(statearr_40526_42617[(2)] = inst_40501);

(statearr_40526_42617[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40513 === (8))){
var inst_40477 = (state_40512[(10)]);
var inst_40486 = (state_40512[(7)]);
var inst_40487 = (state_40512[(8)]);
var inst_40488 = (state_40512[(9)]);
var inst_40493 = (function (){var cs = inst_40477;
var vec__40482 = inst_40486;
var v = inst_40487;
var c = inst_40488;
return (function (p1__40459_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__40459_SHARP_);
});
})();
var inst_40494 = cljs.core.filterv(inst_40493,inst_40477);
var inst_40477__$1 = inst_40494;
var state_40512__$1 = (function (){var statearr_40538 = state_40512;
(statearr_40538[(10)] = inst_40477__$1);

return statearr_40538;
})();
var statearr_40539_42626 = state_40512__$1;
(statearr_40539_42626[(2)] = null);

(statearr_40539_42626[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__37551__auto__ = null;
var cljs$core$async$state_machine__37551__auto____0 = (function (){
var statearr_40540 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40540[(0)] = cljs$core$async$state_machine__37551__auto__);

(statearr_40540[(1)] = (1));

return statearr_40540;
});
var cljs$core$async$state_machine__37551__auto____1 = (function (state_40512){
while(true){
var ret_value__37552__auto__ = (function (){try{while(true){
var result__37553__auto__ = switch__37550__auto__(state_40512);
if(cljs.core.keyword_identical_QMARK_(result__37553__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37553__auto__;
}
break;
}
}catch (e40541){var ex__37554__auto__ = e40541;
var statearr_40542_42628 = state_40512;
(statearr_40542_42628[(2)] = ex__37554__auto__);


if(cljs.core.seq((state_40512[(4)]))){
var statearr_40543_42630 = state_40512;
(statearr_40543_42630[(1)] = cljs.core.first((state_40512[(4)])));

} else {
throw ex__37554__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42634 = state_40512;
state_40512 = G__42634;
continue;
} else {
return ret_value__37552__auto__;
}
break;
}
});
cljs$core$async$state_machine__37551__auto__ = function(state_40512){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__37551__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__37551__auto____1.call(this,state_40512);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__37551__auto____0;
cljs$core$async$state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__37551__auto____1;
return cljs$core$async$state_machine__37551__auto__;
})()
})();
var state__37796__auto__ = (function (){var statearr_40544 = f__37795__auto__();
(statearr_40544[(6)] = c__37794__auto___42586);

return statearr_40544;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37796__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__40546 = arguments.length;
switch (G__40546) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__37794__auto___42638 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37795__auto__ = (function (){var switch__37550__auto__ = (function (state_40590){
var state_val_40591 = (state_40590[(1)]);
if((state_val_40591 === (7))){
var inst_40566 = (state_40590[(7)]);
var inst_40566__$1 = (state_40590[(2)]);
var inst_40567 = (inst_40566__$1 == null);
var inst_40568 = cljs.core.not(inst_40567);
var state_40590__$1 = (function (){var statearr_40598 = state_40590;
(statearr_40598[(7)] = inst_40566__$1);

return statearr_40598;
})();
if(inst_40568){
var statearr_40601_42640 = state_40590__$1;
(statearr_40601_42640[(1)] = (8));

} else {
var statearr_40608_42641 = state_40590__$1;
(statearr_40608_42641[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40591 === (1))){
var inst_40547 = (0);
var state_40590__$1 = (function (){var statearr_40609 = state_40590;
(statearr_40609[(8)] = inst_40547);

return statearr_40609;
})();
var statearr_40610_42643 = state_40590__$1;
(statearr_40610_42643[(2)] = null);

(statearr_40610_42643[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40591 === (4))){
var state_40590__$1 = state_40590;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40590__$1,(7),ch);
} else {
if((state_val_40591 === (6))){
var inst_40585 = (state_40590[(2)]);
var state_40590__$1 = state_40590;
var statearr_40617_42644 = state_40590__$1;
(statearr_40617_42644[(2)] = inst_40585);

(statearr_40617_42644[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40591 === (3))){
var inst_40587 = (state_40590[(2)]);
var inst_40588 = cljs.core.async.close_BANG_(out);
var state_40590__$1 = (function (){var statearr_40618 = state_40590;
(statearr_40618[(9)] = inst_40587);

return statearr_40618;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_40590__$1,inst_40588);
} else {
if((state_val_40591 === (2))){
var inst_40547 = (state_40590[(8)]);
var inst_40557 = (inst_40547 < n);
var state_40590__$1 = state_40590;
if(cljs.core.truth_(inst_40557)){
var statearr_40622_42646 = state_40590__$1;
(statearr_40622_42646[(1)] = (4));

} else {
var statearr_40623_42647 = state_40590__$1;
(statearr_40623_42647[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40591 === (11))){
var inst_40547 = (state_40590[(8)]);
var inst_40571 = (state_40590[(2)]);
var inst_40572 = (inst_40547 + (1));
var inst_40547__$1 = inst_40572;
var state_40590__$1 = (function (){var statearr_40626 = state_40590;
(statearr_40626[(10)] = inst_40571);

(statearr_40626[(8)] = inst_40547__$1);

return statearr_40626;
})();
var statearr_40627_42653 = state_40590__$1;
(statearr_40627_42653[(2)] = null);

(statearr_40627_42653[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40591 === (9))){
var state_40590__$1 = state_40590;
var statearr_40628_42654 = state_40590__$1;
(statearr_40628_42654[(2)] = null);

(statearr_40628_42654[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40591 === (5))){
var state_40590__$1 = state_40590;
var statearr_40629_42655 = state_40590__$1;
(statearr_40629_42655[(2)] = null);

(statearr_40629_42655[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40591 === (10))){
var inst_40582 = (state_40590[(2)]);
var state_40590__$1 = state_40590;
var statearr_40630_42656 = state_40590__$1;
(statearr_40630_42656[(2)] = inst_40582);

(statearr_40630_42656[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40591 === (8))){
var inst_40566 = (state_40590[(7)]);
var state_40590__$1 = state_40590;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_40590__$1,(11),out,inst_40566);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__37551__auto__ = null;
var cljs$core$async$state_machine__37551__auto____0 = (function (){
var statearr_40632 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_40632[(0)] = cljs$core$async$state_machine__37551__auto__);

(statearr_40632[(1)] = (1));

return statearr_40632;
});
var cljs$core$async$state_machine__37551__auto____1 = (function (state_40590){
while(true){
var ret_value__37552__auto__ = (function (){try{while(true){
var result__37553__auto__ = switch__37550__auto__(state_40590);
if(cljs.core.keyword_identical_QMARK_(result__37553__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37553__auto__;
}
break;
}
}catch (e40633){var ex__37554__auto__ = e40633;
var statearr_40634_42659 = state_40590;
(statearr_40634_42659[(2)] = ex__37554__auto__);


if(cljs.core.seq((state_40590[(4)]))){
var statearr_40635_42660 = state_40590;
(statearr_40635_42660[(1)] = cljs.core.first((state_40590[(4)])));

} else {
throw ex__37554__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42661 = state_40590;
state_40590 = G__42661;
continue;
} else {
return ret_value__37552__auto__;
}
break;
}
});
cljs$core$async$state_machine__37551__auto__ = function(state_40590){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__37551__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__37551__auto____1.call(this,state_40590);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__37551__auto____0;
cljs$core$async$state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__37551__auto____1;
return cljs$core$async$state_machine__37551__auto__;
})()
})();
var state__37796__auto__ = (function (){var statearr_40636 = f__37795__auto__();
(statearr_40636[(6)] = c__37794__auto___42638);

return statearr_40636;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37796__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async40647 = (function (f,ch,meta40645,_,fn1,meta40648){
this.f = f;
this.ch = ch;
this.meta40645 = meta40645;
this._ = _;
this.fn1 = fn1;
this.meta40648 = meta40648;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async40647.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_40649,meta40648__$1){
var self__ = this;
var _40649__$1 = this;
return (new cljs.core.async.t_cljs$core$async40647(self__.f,self__.ch,self__.meta40645,self__._,self__.fn1,meta40648__$1));
}));

(cljs.core.async.t_cljs$core$async40647.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_40649){
var self__ = this;
var _40649__$1 = this;
return self__.meta40648;
}));

(cljs.core.async.t_cljs$core$async40647.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async40647.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async40647.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async40647.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__40640_SHARP_){
var G__40653 = (((p1__40640_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__40640_SHARP_) : self__.f.call(null, p1__40640_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__40653) : f1.call(null, G__40653));
});
}));

(cljs.core.async.t_cljs$core$async40647.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta40645","meta40645",-480027603,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async40644","cljs.core.async/t_cljs$core$async40644",1040760776,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta40648","meta40648",942239105,null)], null);
}));

(cljs.core.async.t_cljs$core$async40647.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async40647.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async40647");

(cljs.core.async.t_cljs$core$async40647.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async40647");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async40647.
 */
cljs.core.async.__GT_t_cljs$core$async40647 = (function cljs$core$async$__GT_t_cljs$core$async40647(f,ch,meta40645,_,fn1,meta40648){
return (new cljs.core.async.t_cljs$core$async40647(f,ch,meta40645,_,fn1,meta40648));
});



/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async40644 = (function (f,ch,meta40645){
this.f = f;
this.ch = ch;
this.meta40645 = meta40645;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async40644.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_40646,meta40645__$1){
var self__ = this;
var _40646__$1 = this;
return (new cljs.core.async.t_cljs$core$async40644(self__.f,self__.ch,meta40645__$1));
}));

(cljs.core.async.t_cljs$core$async40644.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_40646){
var self__ = this;
var _40646__$1 = this;
return self__.meta40645;
}));

(cljs.core.async.t_cljs$core$async40644.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async40644.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async40644.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async40644.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async40644.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(new cljs.core.async.t_cljs$core$async40647(self__.f,self__.ch,self__.meta40645,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY)));
if(cljs.core.truth_((function (){var and__5000__auto__ = ret;
if(cljs.core.truth_(and__5000__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__5000__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__40654 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__40654) : self__.f.call(null, G__40654));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async40644.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async40644.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async40644.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta40645","meta40645",-480027603,null)], null);
}));

(cljs.core.async.t_cljs$core$async40644.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async40644.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async40644");

(cljs.core.async.t_cljs$core$async40644.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async40644");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async40644.
 */
cljs.core.async.__GT_t_cljs$core$async40644 = (function cljs$core$async$__GT_t_cljs$core$async40644(f,ch,meta40645){
return (new cljs.core.async.t_cljs$core$async40644(f,ch,meta40645));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
return (new cljs.core.async.t_cljs$core$async40644(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async40655 = (function (f,ch,meta40656){
this.f = f;
this.ch = ch;
this.meta40656 = meta40656;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async40655.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_40657,meta40656__$1){
var self__ = this;
var _40657__$1 = this;
return (new cljs.core.async.t_cljs$core$async40655(self__.f,self__.ch,meta40656__$1));
}));

(cljs.core.async.t_cljs$core$async40655.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_40657){
var self__ = this;
var _40657__$1 = this;
return self__.meta40656;
}));

(cljs.core.async.t_cljs$core$async40655.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async40655.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async40655.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async40655.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async40655.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async40655.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null, val)),fn1);
}));

(cljs.core.async.t_cljs$core$async40655.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta40656","meta40656",1453514911,null)], null);
}));

(cljs.core.async.t_cljs$core$async40655.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async40655.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async40655");

(cljs.core.async.t_cljs$core$async40655.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async40655");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async40655.
 */
cljs.core.async.__GT_t_cljs$core$async40655 = (function cljs$core$async$__GT_t_cljs$core$async40655(f,ch,meta40656){
return (new cljs.core.async.t_cljs$core$async40655(f,ch,meta40656));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
return (new cljs.core.async.t_cljs$core$async40655(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async40674 = (function (p,ch,meta40675){
this.p = p;
this.ch = ch;
this.meta40675 = meta40675;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async40674.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_40676,meta40675__$1){
var self__ = this;
var _40676__$1 = this;
return (new cljs.core.async.t_cljs$core$async40674(self__.p,self__.ch,meta40675__$1));
}));

(cljs.core.async.t_cljs$core$async40674.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_40676){
var self__ = this;
var _40676__$1 = this;
return self__.meta40675;
}));

(cljs.core.async.t_cljs$core$async40674.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async40674.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async40674.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async40674.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async40674.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async40674.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async40674.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null, val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async40674.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta40675","meta40675",-48949902,null)], null);
}));

(cljs.core.async.t_cljs$core$async40674.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async40674.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async40674");

(cljs.core.async.t_cljs$core$async40674.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async40674");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async40674.
 */
cljs.core.async.__GT_t_cljs$core$async40674 = (function cljs$core$async$__GT_t_cljs$core$async40674(p,ch,meta40675){
return (new cljs.core.async.t_cljs$core$async40674(p,ch,meta40675));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
return (new cljs.core.async.t_cljs$core$async40674(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__40685 = arguments.length;
switch (G__40685) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__37794__auto___42674 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37795__auto__ = (function (){var switch__37550__auto__ = (function (state_40724){
var state_val_40725 = (state_40724[(1)]);
if((state_val_40725 === (7))){
var inst_40720 = (state_40724[(2)]);
var state_40724__$1 = state_40724;
var statearr_40729_42675 = state_40724__$1;
(statearr_40729_42675[(2)] = inst_40720);

(statearr_40729_42675[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40725 === (1))){
var state_40724__$1 = state_40724;
var statearr_40730_42677 = state_40724__$1;
(statearr_40730_42677[(2)] = null);

(statearr_40730_42677[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40725 === (4))){
var inst_40706 = (state_40724[(7)]);
var inst_40706__$1 = (state_40724[(2)]);
var inst_40707 = (inst_40706__$1 == null);
var state_40724__$1 = (function (){var statearr_40734 = state_40724;
(statearr_40734[(7)] = inst_40706__$1);

return statearr_40734;
})();
if(cljs.core.truth_(inst_40707)){
var statearr_40735_42678 = state_40724__$1;
(statearr_40735_42678[(1)] = (5));

} else {
var statearr_40736_42679 = state_40724__$1;
(statearr_40736_42679[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40725 === (6))){
var inst_40706 = (state_40724[(7)]);
var inst_40711 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_40706) : p.call(null, inst_40706));
var state_40724__$1 = state_40724;
if(cljs.core.truth_(inst_40711)){
var statearr_40737_42684 = state_40724__$1;
(statearr_40737_42684[(1)] = (8));

} else {
var statearr_40741_42685 = state_40724__$1;
(statearr_40741_42685[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40725 === (3))){
var inst_40722 = (state_40724[(2)]);
var state_40724__$1 = state_40724;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40724__$1,inst_40722);
} else {
if((state_val_40725 === (2))){
var state_40724__$1 = state_40724;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40724__$1,(4),ch);
} else {
if((state_val_40725 === (11))){
var inst_40714 = (state_40724[(2)]);
var state_40724__$1 = state_40724;
var statearr_40749_42687 = state_40724__$1;
(statearr_40749_42687[(2)] = inst_40714);

(statearr_40749_42687[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40725 === (9))){
var state_40724__$1 = state_40724;
var statearr_40754_42688 = state_40724__$1;
(statearr_40754_42688[(2)] = null);

(statearr_40754_42688[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40725 === (5))){
var inst_40709 = cljs.core.async.close_BANG_(out);
var state_40724__$1 = state_40724;
var statearr_40761_42689 = state_40724__$1;
(statearr_40761_42689[(2)] = inst_40709);

(statearr_40761_42689[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40725 === (10))){
var inst_40717 = (state_40724[(2)]);
var state_40724__$1 = (function (){var statearr_40762 = state_40724;
(statearr_40762[(8)] = inst_40717);

return statearr_40762;
})();
var statearr_40763_42690 = state_40724__$1;
(statearr_40763_42690[(2)] = null);

(statearr_40763_42690[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40725 === (8))){
var inst_40706 = (state_40724[(7)]);
var state_40724__$1 = state_40724;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_40724__$1,(11),out,inst_40706);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__37551__auto__ = null;
var cljs$core$async$state_machine__37551__auto____0 = (function (){
var statearr_40781 = [null,null,null,null,null,null,null,null,null];
(statearr_40781[(0)] = cljs$core$async$state_machine__37551__auto__);

(statearr_40781[(1)] = (1));

return statearr_40781;
});
var cljs$core$async$state_machine__37551__auto____1 = (function (state_40724){
while(true){
var ret_value__37552__auto__ = (function (){try{while(true){
var result__37553__auto__ = switch__37550__auto__(state_40724);
if(cljs.core.keyword_identical_QMARK_(result__37553__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37553__auto__;
}
break;
}
}catch (e40784){var ex__37554__auto__ = e40784;
var statearr_40785_42691 = state_40724;
(statearr_40785_42691[(2)] = ex__37554__auto__);


if(cljs.core.seq((state_40724[(4)]))){
var statearr_40786_42693 = state_40724;
(statearr_40786_42693[(1)] = cljs.core.first((state_40724[(4)])));

} else {
throw ex__37554__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42695 = state_40724;
state_40724 = G__42695;
continue;
} else {
return ret_value__37552__auto__;
}
break;
}
});
cljs$core$async$state_machine__37551__auto__ = function(state_40724){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__37551__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__37551__auto____1.call(this,state_40724);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__37551__auto____0;
cljs$core$async$state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__37551__auto____1;
return cljs$core$async$state_machine__37551__auto__;
})()
})();
var state__37796__auto__ = (function (){var statearr_40787 = f__37795__auto__();
(statearr_40787[(6)] = c__37794__auto___42674);

return statearr_40787;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37796__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__40792 = arguments.length;
switch (G__40792) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__37794__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37795__auto__ = (function (){var switch__37550__auto__ = (function (state_40875){
var state_val_40876 = (state_40875[(1)]);
if((state_val_40876 === (7))){
var inst_40871 = (state_40875[(2)]);
var state_40875__$1 = state_40875;
var statearr_40877_42702 = state_40875__$1;
(statearr_40877_42702[(2)] = inst_40871);

(statearr_40877_42702[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40876 === (20))){
var inst_40836 = (state_40875[(7)]);
var inst_40849 = (state_40875[(2)]);
var inst_40850 = cljs.core.next(inst_40836);
var inst_40811 = inst_40850;
var inst_40812 = null;
var inst_40813 = (0);
var inst_40814 = (0);
var state_40875__$1 = (function (){var statearr_40881 = state_40875;
(statearr_40881[(8)] = inst_40849);

(statearr_40881[(9)] = inst_40811);

(statearr_40881[(10)] = inst_40812);

(statearr_40881[(11)] = inst_40813);

(statearr_40881[(12)] = inst_40814);

return statearr_40881;
})();
var statearr_40884_42704 = state_40875__$1;
(statearr_40884_42704[(2)] = null);

(statearr_40884_42704[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40876 === (1))){
var state_40875__$1 = state_40875;
var statearr_40885_42706 = state_40875__$1;
(statearr_40885_42706[(2)] = null);

(statearr_40885_42706[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40876 === (4))){
var inst_40798 = (state_40875[(13)]);
var inst_40798__$1 = (state_40875[(2)]);
var inst_40800 = (inst_40798__$1 == null);
var state_40875__$1 = (function (){var statearr_40887 = state_40875;
(statearr_40887[(13)] = inst_40798__$1);

return statearr_40887;
})();
if(cljs.core.truth_(inst_40800)){
var statearr_40888_42707 = state_40875__$1;
(statearr_40888_42707[(1)] = (5));

} else {
var statearr_40898_42711 = state_40875__$1;
(statearr_40898_42711[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40876 === (15))){
var state_40875__$1 = state_40875;
var statearr_40903_42712 = state_40875__$1;
(statearr_40903_42712[(2)] = null);

(statearr_40903_42712[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40876 === (21))){
var state_40875__$1 = state_40875;
var statearr_40904_42716 = state_40875__$1;
(statearr_40904_42716[(2)] = null);

(statearr_40904_42716[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40876 === (13))){
var inst_40814 = (state_40875[(12)]);
var inst_40811 = (state_40875[(9)]);
var inst_40812 = (state_40875[(10)]);
var inst_40813 = (state_40875[(11)]);
var inst_40832 = (state_40875[(2)]);
var inst_40833 = (inst_40814 + (1));
var tmp40899 = inst_40811;
var tmp40900 = inst_40812;
var tmp40901 = inst_40813;
var inst_40811__$1 = tmp40899;
var inst_40812__$1 = tmp40900;
var inst_40813__$1 = tmp40901;
var inst_40814__$1 = inst_40833;
var state_40875__$1 = (function (){var statearr_40905 = state_40875;
(statearr_40905[(14)] = inst_40832);

(statearr_40905[(9)] = inst_40811__$1);

(statearr_40905[(10)] = inst_40812__$1);

(statearr_40905[(11)] = inst_40813__$1);

(statearr_40905[(12)] = inst_40814__$1);

return statearr_40905;
})();
var statearr_40906_42717 = state_40875__$1;
(statearr_40906_42717[(2)] = null);

(statearr_40906_42717[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40876 === (22))){
var state_40875__$1 = state_40875;
var statearr_40907_42718 = state_40875__$1;
(statearr_40907_42718[(2)] = null);

(statearr_40907_42718[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40876 === (6))){
var inst_40798 = (state_40875[(13)]);
var inst_40809 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_40798) : f.call(null, inst_40798));
var inst_40810 = cljs.core.seq(inst_40809);
var inst_40811 = inst_40810;
var inst_40812 = null;
var inst_40813 = (0);
var inst_40814 = (0);
var state_40875__$1 = (function (){var statearr_40910 = state_40875;
(statearr_40910[(9)] = inst_40811);

(statearr_40910[(10)] = inst_40812);

(statearr_40910[(11)] = inst_40813);

(statearr_40910[(12)] = inst_40814);

return statearr_40910;
})();
var statearr_40911_42722 = state_40875__$1;
(statearr_40911_42722[(2)] = null);

(statearr_40911_42722[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40876 === (17))){
var inst_40836 = (state_40875[(7)]);
var inst_40841 = cljs.core.chunk_first(inst_40836);
var inst_40843 = cljs.core.chunk_rest(inst_40836);
var inst_40844 = cljs.core.count(inst_40841);
var inst_40811 = inst_40843;
var inst_40812 = inst_40841;
var inst_40813 = inst_40844;
var inst_40814 = (0);
var state_40875__$1 = (function (){var statearr_40914 = state_40875;
(statearr_40914[(9)] = inst_40811);

(statearr_40914[(10)] = inst_40812);

(statearr_40914[(11)] = inst_40813);

(statearr_40914[(12)] = inst_40814);

return statearr_40914;
})();
var statearr_40918_42723 = state_40875__$1;
(statearr_40918_42723[(2)] = null);

(statearr_40918_42723[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40876 === (3))){
var inst_40873 = (state_40875[(2)]);
var state_40875__$1 = state_40875;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40875__$1,inst_40873);
} else {
if((state_val_40876 === (12))){
var inst_40861 = (state_40875[(2)]);
var state_40875__$1 = state_40875;
var statearr_40927_42724 = state_40875__$1;
(statearr_40927_42724[(2)] = inst_40861);

(statearr_40927_42724[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40876 === (2))){
var state_40875__$1 = state_40875;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40875__$1,(4),in$);
} else {
if((state_val_40876 === (23))){
var inst_40869 = (state_40875[(2)]);
var state_40875__$1 = state_40875;
var statearr_40937_42725 = state_40875__$1;
(statearr_40937_42725[(2)] = inst_40869);

(statearr_40937_42725[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40876 === (19))){
var inst_40856 = (state_40875[(2)]);
var state_40875__$1 = state_40875;
var statearr_40945_42726 = state_40875__$1;
(statearr_40945_42726[(2)] = inst_40856);

(statearr_40945_42726[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40876 === (11))){
var inst_40811 = (state_40875[(9)]);
var inst_40836 = (state_40875[(7)]);
var inst_40836__$1 = cljs.core.seq(inst_40811);
var state_40875__$1 = (function (){var statearr_40953 = state_40875;
(statearr_40953[(7)] = inst_40836__$1);

return statearr_40953;
})();
if(inst_40836__$1){
var statearr_40954_42727 = state_40875__$1;
(statearr_40954_42727[(1)] = (14));

} else {
var statearr_40956_42728 = state_40875__$1;
(statearr_40956_42728[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40876 === (9))){
var inst_40863 = (state_40875[(2)]);
var inst_40864 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_40875__$1 = (function (){var statearr_40957 = state_40875;
(statearr_40957[(15)] = inst_40863);

return statearr_40957;
})();
if(cljs.core.truth_(inst_40864)){
var statearr_40960_42729 = state_40875__$1;
(statearr_40960_42729[(1)] = (21));

} else {
var statearr_40961_42730 = state_40875__$1;
(statearr_40961_42730[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40876 === (5))){
var inst_40803 = cljs.core.async.close_BANG_(out);
var state_40875__$1 = state_40875;
var statearr_40967_42731 = state_40875__$1;
(statearr_40967_42731[(2)] = inst_40803);

(statearr_40967_42731[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40876 === (14))){
var inst_40836 = (state_40875[(7)]);
var inst_40839 = cljs.core.chunked_seq_QMARK_(inst_40836);
var state_40875__$1 = state_40875;
if(inst_40839){
var statearr_40969_42733 = state_40875__$1;
(statearr_40969_42733[(1)] = (17));

} else {
var statearr_40973_42734 = state_40875__$1;
(statearr_40973_42734[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40876 === (16))){
var inst_40859 = (state_40875[(2)]);
var state_40875__$1 = state_40875;
var statearr_40975_42739 = state_40875__$1;
(statearr_40975_42739[(2)] = inst_40859);

(statearr_40975_42739[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40876 === (10))){
var inst_40812 = (state_40875[(10)]);
var inst_40814 = (state_40875[(12)]);
var inst_40820 = cljs.core._nth(inst_40812,inst_40814);
var state_40875__$1 = state_40875;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_40875__$1,(13),out,inst_40820);
} else {
if((state_val_40876 === (18))){
var inst_40836 = (state_40875[(7)]);
var inst_40847 = cljs.core.first(inst_40836);
var state_40875__$1 = state_40875;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_40875__$1,(20),out,inst_40847);
} else {
if((state_val_40876 === (8))){
var inst_40814 = (state_40875[(12)]);
var inst_40813 = (state_40875[(11)]);
var inst_40816 = (inst_40814 < inst_40813);
var inst_40817 = inst_40816;
var state_40875__$1 = state_40875;
if(cljs.core.truth_(inst_40817)){
var statearr_40984_42749 = state_40875__$1;
(statearr_40984_42749[(1)] = (10));

} else {
var statearr_40985_42750 = state_40875__$1;
(statearr_40985_42750[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__37551__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__37551__auto____0 = (function (){
var statearr_40992 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40992[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__37551__auto__);

(statearr_40992[(1)] = (1));

return statearr_40992;
});
var cljs$core$async$mapcat_STAR__$_state_machine__37551__auto____1 = (function (state_40875){
while(true){
var ret_value__37552__auto__ = (function (){try{while(true){
var result__37553__auto__ = switch__37550__auto__(state_40875);
if(cljs.core.keyword_identical_QMARK_(result__37553__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37553__auto__;
}
break;
}
}catch (e40995){var ex__37554__auto__ = e40995;
var statearr_40996_42751 = state_40875;
(statearr_40996_42751[(2)] = ex__37554__auto__);


if(cljs.core.seq((state_40875[(4)]))){
var statearr_40997_42753 = state_40875;
(statearr_40997_42753[(1)] = cljs.core.first((state_40875[(4)])));

} else {
throw ex__37554__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42754 = state_40875;
state_40875 = G__42754;
continue;
} else {
return ret_value__37552__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__37551__auto__ = function(state_40875){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__37551__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__37551__auto____1.call(this,state_40875);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__37551__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__37551__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__37551__auto__;
})()
})();
var state__37796__auto__ = (function (){var statearr_41000 = f__37795__auto__();
(statearr_41000[(6)] = c__37794__auto__);

return statearr_41000;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37796__auto__);
}));

return c__37794__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__41005 = arguments.length;
switch (G__41005) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__41031 = arguments.length;
switch (G__41031) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__41054 = arguments.length;
switch (G__41054) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__37794__auto___42765 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37795__auto__ = (function (){var switch__37550__auto__ = (function (state_41145){
var state_val_41146 = (state_41145[(1)]);
if((state_val_41146 === (7))){
var inst_41134 = (state_41145[(2)]);
var state_41145__$1 = state_41145;
var statearr_41153_42766 = state_41145__$1;
(statearr_41153_42766[(2)] = inst_41134);

(statearr_41153_42766[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41146 === (1))){
var inst_41077 = null;
var state_41145__$1 = (function (){var statearr_41154 = state_41145;
(statearr_41154[(7)] = inst_41077);

return statearr_41154;
})();
var statearr_41155_42770 = state_41145__$1;
(statearr_41155_42770[(2)] = null);

(statearr_41155_42770[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41146 === (4))){
var inst_41104 = (state_41145[(8)]);
var inst_41104__$1 = (state_41145[(2)]);
var inst_41115 = (inst_41104__$1 == null);
var inst_41118 = cljs.core.not(inst_41115);
var state_41145__$1 = (function (){var statearr_41156 = state_41145;
(statearr_41156[(8)] = inst_41104__$1);

return statearr_41156;
})();
if(inst_41118){
var statearr_41157_42771 = state_41145__$1;
(statearr_41157_42771[(1)] = (5));

} else {
var statearr_41158_42772 = state_41145__$1;
(statearr_41158_42772[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41146 === (6))){
var state_41145__$1 = state_41145;
var statearr_41159_42773 = state_41145__$1;
(statearr_41159_42773[(2)] = null);

(statearr_41159_42773[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41146 === (3))){
var inst_41136 = (state_41145[(2)]);
var inst_41137 = cljs.core.async.close_BANG_(out);
var state_41145__$1 = (function (){var statearr_41160 = state_41145;
(statearr_41160[(9)] = inst_41136);

return statearr_41160;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_41145__$1,inst_41137);
} else {
if((state_val_41146 === (2))){
var state_41145__$1 = state_41145;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41145__$1,(4),ch);
} else {
if((state_val_41146 === (11))){
var inst_41104 = (state_41145[(8)]);
var inst_41128 = (state_41145[(2)]);
var inst_41077 = inst_41104;
var state_41145__$1 = (function (){var statearr_41161 = state_41145;
(statearr_41161[(10)] = inst_41128);

(statearr_41161[(7)] = inst_41077);

return statearr_41161;
})();
var statearr_41162_42782 = state_41145__$1;
(statearr_41162_42782[(2)] = null);

(statearr_41162_42782[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41146 === (9))){
var inst_41104 = (state_41145[(8)]);
var state_41145__$1 = state_41145;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_41145__$1,(11),out,inst_41104);
} else {
if((state_val_41146 === (5))){
var inst_41104 = (state_41145[(8)]);
var inst_41077 = (state_41145[(7)]);
var inst_41123 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_41104,inst_41077);
var state_41145__$1 = state_41145;
if(inst_41123){
var statearr_41168_42792 = state_41145__$1;
(statearr_41168_42792[(1)] = (8));

} else {
var statearr_41172_42795 = state_41145__$1;
(statearr_41172_42795[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41146 === (10))){
var inst_41131 = (state_41145[(2)]);
var state_41145__$1 = state_41145;
var statearr_41173_42796 = state_41145__$1;
(statearr_41173_42796[(2)] = inst_41131);

(statearr_41173_42796[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41146 === (8))){
var inst_41077 = (state_41145[(7)]);
var tmp41167 = inst_41077;
var inst_41077__$1 = tmp41167;
var state_41145__$1 = (function (){var statearr_41174 = state_41145;
(statearr_41174[(7)] = inst_41077__$1);

return statearr_41174;
})();
var statearr_41175_42801 = state_41145__$1;
(statearr_41175_42801[(2)] = null);

(statearr_41175_42801[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__37551__auto__ = null;
var cljs$core$async$state_machine__37551__auto____0 = (function (){
var statearr_41179 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_41179[(0)] = cljs$core$async$state_machine__37551__auto__);

(statearr_41179[(1)] = (1));

return statearr_41179;
});
var cljs$core$async$state_machine__37551__auto____1 = (function (state_41145){
while(true){
var ret_value__37552__auto__ = (function (){try{while(true){
var result__37553__auto__ = switch__37550__auto__(state_41145);
if(cljs.core.keyword_identical_QMARK_(result__37553__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37553__auto__;
}
break;
}
}catch (e41180){var ex__37554__auto__ = e41180;
var statearr_41181_42810 = state_41145;
(statearr_41181_42810[(2)] = ex__37554__auto__);


if(cljs.core.seq((state_41145[(4)]))){
var statearr_41182_42811 = state_41145;
(statearr_41182_42811[(1)] = cljs.core.first((state_41145[(4)])));

} else {
throw ex__37554__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42812 = state_41145;
state_41145 = G__42812;
continue;
} else {
return ret_value__37552__auto__;
}
break;
}
});
cljs$core$async$state_machine__37551__auto__ = function(state_41145){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__37551__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__37551__auto____1.call(this,state_41145);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__37551__auto____0;
cljs$core$async$state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__37551__auto____1;
return cljs$core$async$state_machine__37551__auto__;
})()
})();
var state__37796__auto__ = (function (){var statearr_41183 = f__37795__auto__();
(statearr_41183[(6)] = c__37794__auto___42765);

return statearr_41183;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37796__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__41195 = arguments.length;
switch (G__41195) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__37794__auto___42815 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37795__auto__ = (function (){var switch__37550__auto__ = (function (state_41249){
var state_val_41250 = (state_41249[(1)]);
if((state_val_41250 === (7))){
var inst_41240 = (state_41249[(2)]);
var state_41249__$1 = state_41249;
var statearr_41255_42816 = state_41249__$1;
(statearr_41255_42816[(2)] = inst_41240);

(statearr_41255_42816[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41250 === (1))){
var inst_41204 = (new Array(n));
var inst_41205 = inst_41204;
var inst_41206 = (0);
var state_41249__$1 = (function (){var statearr_41256 = state_41249;
(statearr_41256[(7)] = inst_41205);

(statearr_41256[(8)] = inst_41206);

return statearr_41256;
})();
var statearr_41257_42817 = state_41249__$1;
(statearr_41257_42817[(2)] = null);

(statearr_41257_42817[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41250 === (4))){
var inst_41209 = (state_41249[(9)]);
var inst_41209__$1 = (state_41249[(2)]);
var inst_41210 = (inst_41209__$1 == null);
var inst_41211 = cljs.core.not(inst_41210);
var state_41249__$1 = (function (){var statearr_41258 = state_41249;
(statearr_41258[(9)] = inst_41209__$1);

return statearr_41258;
})();
if(inst_41211){
var statearr_41263_42818 = state_41249__$1;
(statearr_41263_42818[(1)] = (5));

} else {
var statearr_41264_42819 = state_41249__$1;
(statearr_41264_42819[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41250 === (15))){
var inst_41234 = (state_41249[(2)]);
var state_41249__$1 = state_41249;
var statearr_41265_42820 = state_41249__$1;
(statearr_41265_42820[(2)] = inst_41234);

(statearr_41265_42820[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41250 === (13))){
var state_41249__$1 = state_41249;
var statearr_41266_42823 = state_41249__$1;
(statearr_41266_42823[(2)] = null);

(statearr_41266_42823[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41250 === (6))){
var inst_41206 = (state_41249[(8)]);
var inst_41230 = (inst_41206 > (0));
var state_41249__$1 = state_41249;
if(cljs.core.truth_(inst_41230)){
var statearr_41271_42826 = state_41249__$1;
(statearr_41271_42826[(1)] = (12));

} else {
var statearr_41272_42827 = state_41249__$1;
(statearr_41272_42827[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41250 === (3))){
var inst_41245 = (state_41249[(2)]);
var state_41249__$1 = state_41249;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41249__$1,inst_41245);
} else {
if((state_val_41250 === (12))){
var inst_41205 = (state_41249[(7)]);
var inst_41232 = cljs.core.vec(inst_41205);
var state_41249__$1 = state_41249;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_41249__$1,(15),out,inst_41232);
} else {
if((state_val_41250 === (2))){
var state_41249__$1 = state_41249;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41249__$1,(4),ch);
} else {
if((state_val_41250 === (11))){
var inst_41224 = (state_41249[(2)]);
var inst_41225 = (new Array(n));
var inst_41205 = inst_41225;
var inst_41206 = (0);
var state_41249__$1 = (function (){var statearr_41285 = state_41249;
(statearr_41285[(10)] = inst_41224);

(statearr_41285[(7)] = inst_41205);

(statearr_41285[(8)] = inst_41206);

return statearr_41285;
})();
var statearr_41286_42828 = state_41249__$1;
(statearr_41286_42828[(2)] = null);

(statearr_41286_42828[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41250 === (9))){
var inst_41205 = (state_41249[(7)]);
var inst_41222 = cljs.core.vec(inst_41205);
var state_41249__$1 = state_41249;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_41249__$1,(11),out,inst_41222);
} else {
if((state_val_41250 === (5))){
var inst_41205 = (state_41249[(7)]);
var inst_41206 = (state_41249[(8)]);
var inst_41209 = (state_41249[(9)]);
var inst_41214 = (state_41249[(11)]);
var inst_41213 = (inst_41205[inst_41206] = inst_41209);
var inst_41214__$1 = (inst_41206 + (1));
var inst_41215 = (inst_41214__$1 < n);
var state_41249__$1 = (function (){var statearr_41291 = state_41249;
(statearr_41291[(12)] = inst_41213);

(statearr_41291[(11)] = inst_41214__$1);

return statearr_41291;
})();
if(cljs.core.truth_(inst_41215)){
var statearr_41293_42832 = state_41249__$1;
(statearr_41293_42832[(1)] = (8));

} else {
var statearr_41294_42833 = state_41249__$1;
(statearr_41294_42833[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41250 === (14))){
var inst_41237 = (state_41249[(2)]);
var inst_41238 = cljs.core.async.close_BANG_(out);
var state_41249__$1 = (function (){var statearr_41302 = state_41249;
(statearr_41302[(13)] = inst_41237);

return statearr_41302;
})();
var statearr_41309_42837 = state_41249__$1;
(statearr_41309_42837[(2)] = inst_41238);

(statearr_41309_42837[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41250 === (10))){
var inst_41228 = (state_41249[(2)]);
var state_41249__$1 = state_41249;
var statearr_41310_42841 = state_41249__$1;
(statearr_41310_42841[(2)] = inst_41228);

(statearr_41310_42841[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41250 === (8))){
var inst_41205 = (state_41249[(7)]);
var inst_41214 = (state_41249[(11)]);
var tmp41301 = inst_41205;
var inst_41205__$1 = tmp41301;
var inst_41206 = inst_41214;
var state_41249__$1 = (function (){var statearr_41314 = state_41249;
(statearr_41314[(7)] = inst_41205__$1);

(statearr_41314[(8)] = inst_41206);

return statearr_41314;
})();
var statearr_41315_42843 = state_41249__$1;
(statearr_41315_42843[(2)] = null);

(statearr_41315_42843[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__37551__auto__ = null;
var cljs$core$async$state_machine__37551__auto____0 = (function (){
var statearr_41329 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41329[(0)] = cljs$core$async$state_machine__37551__auto__);

(statearr_41329[(1)] = (1));

return statearr_41329;
});
var cljs$core$async$state_machine__37551__auto____1 = (function (state_41249){
while(true){
var ret_value__37552__auto__ = (function (){try{while(true){
var result__37553__auto__ = switch__37550__auto__(state_41249);
if(cljs.core.keyword_identical_QMARK_(result__37553__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37553__auto__;
}
break;
}
}catch (e41330){var ex__37554__auto__ = e41330;
var statearr_41331_42848 = state_41249;
(statearr_41331_42848[(2)] = ex__37554__auto__);


if(cljs.core.seq((state_41249[(4)]))){
var statearr_41332_42849 = state_41249;
(statearr_41332_42849[(1)] = cljs.core.first((state_41249[(4)])));

} else {
throw ex__37554__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42851 = state_41249;
state_41249 = G__42851;
continue;
} else {
return ret_value__37552__auto__;
}
break;
}
});
cljs$core$async$state_machine__37551__auto__ = function(state_41249){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__37551__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__37551__auto____1.call(this,state_41249);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__37551__auto____0;
cljs$core$async$state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__37551__auto____1;
return cljs$core$async$state_machine__37551__auto__;
})()
})();
var state__37796__auto__ = (function (){var statearr_41333 = f__37795__auto__();
(statearr_41333[(6)] = c__37794__auto___42815);

return statearr_41333;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37796__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__41341 = arguments.length;
switch (G__41341) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__37794__auto___42854 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37795__auto__ = (function (){var switch__37550__auto__ = (function (state_41406){
var state_val_41407 = (state_41406[(1)]);
if((state_val_41407 === (7))){
var inst_41402 = (state_41406[(2)]);
var state_41406__$1 = state_41406;
var statearr_41414_42857 = state_41406__$1;
(statearr_41414_42857[(2)] = inst_41402);

(statearr_41414_42857[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41407 === (1))){
var inst_41352 = [];
var inst_41353 = inst_41352;
var inst_41354 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_41406__$1 = (function (){var statearr_41417 = state_41406;
(statearr_41417[(7)] = inst_41353);

(statearr_41417[(8)] = inst_41354);

return statearr_41417;
})();
var statearr_41418_42862 = state_41406__$1;
(statearr_41418_42862[(2)] = null);

(statearr_41418_42862[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41407 === (4))){
var inst_41359 = (state_41406[(9)]);
var inst_41359__$1 = (state_41406[(2)]);
var inst_41360 = (inst_41359__$1 == null);
var inst_41361 = cljs.core.not(inst_41360);
var state_41406__$1 = (function (){var statearr_41425 = state_41406;
(statearr_41425[(9)] = inst_41359__$1);

return statearr_41425;
})();
if(inst_41361){
var statearr_41426_42863 = state_41406__$1;
(statearr_41426_42863[(1)] = (5));

} else {
var statearr_41427_42866 = state_41406__$1;
(statearr_41427_42866[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41407 === (15))){
var inst_41353 = (state_41406[(7)]);
var inst_41394 = cljs.core.vec(inst_41353);
var state_41406__$1 = state_41406;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_41406__$1,(18),out,inst_41394);
} else {
if((state_val_41407 === (13))){
var inst_41385 = (state_41406[(2)]);
var state_41406__$1 = state_41406;
var statearr_41433_42870 = state_41406__$1;
(statearr_41433_42870[(2)] = inst_41385);

(statearr_41433_42870[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41407 === (6))){
var inst_41353 = (state_41406[(7)]);
var inst_41387 = inst_41353.length;
var inst_41388 = (inst_41387 > (0));
var state_41406__$1 = state_41406;
if(cljs.core.truth_(inst_41388)){
var statearr_41436_42871 = state_41406__$1;
(statearr_41436_42871[(1)] = (15));

} else {
var statearr_41438_42872 = state_41406__$1;
(statearr_41438_42872[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41407 === (17))){
var inst_41399 = (state_41406[(2)]);
var inst_41400 = cljs.core.async.close_BANG_(out);
var state_41406__$1 = (function (){var statearr_41441 = state_41406;
(statearr_41441[(10)] = inst_41399);

return statearr_41441;
})();
var statearr_41442_42873 = state_41406__$1;
(statearr_41442_42873[(2)] = inst_41400);

(statearr_41442_42873[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41407 === (3))){
var inst_41404 = (state_41406[(2)]);
var state_41406__$1 = state_41406;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41406__$1,inst_41404);
} else {
if((state_val_41407 === (12))){
var inst_41353 = (state_41406[(7)]);
var inst_41378 = cljs.core.vec(inst_41353);
var state_41406__$1 = state_41406;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_41406__$1,(14),out,inst_41378);
} else {
if((state_val_41407 === (2))){
var state_41406__$1 = state_41406;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41406__$1,(4),ch);
} else {
if((state_val_41407 === (11))){
var inst_41353 = (state_41406[(7)]);
var inst_41359 = (state_41406[(9)]);
var inst_41363 = (state_41406[(11)]);
var inst_41375 = inst_41353.push(inst_41359);
var tmp41449 = inst_41353;
var inst_41353__$1 = tmp41449;
var inst_41354 = inst_41363;
var state_41406__$1 = (function (){var statearr_41484 = state_41406;
(statearr_41484[(12)] = inst_41375);

(statearr_41484[(7)] = inst_41353__$1);

(statearr_41484[(8)] = inst_41354);

return statearr_41484;
})();
var statearr_41494_42905 = state_41406__$1;
(statearr_41494_42905[(2)] = null);

(statearr_41494_42905[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41407 === (9))){
var inst_41354 = (state_41406[(8)]);
var inst_41371 = cljs.core.keyword_identical_QMARK_(inst_41354,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_41406__$1 = state_41406;
var statearr_41503_42906 = state_41406__$1;
(statearr_41503_42906[(2)] = inst_41371);

(statearr_41503_42906[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41407 === (5))){
var inst_41359 = (state_41406[(9)]);
var inst_41363 = (state_41406[(11)]);
var inst_41354 = (state_41406[(8)]);
var inst_41368 = (state_41406[(13)]);
var inst_41363__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_41359) : f.call(null, inst_41359));
var inst_41368__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_41363__$1,inst_41354);
var state_41406__$1 = (function (){var statearr_41508 = state_41406;
(statearr_41508[(11)] = inst_41363__$1);

(statearr_41508[(13)] = inst_41368__$1);

return statearr_41508;
})();
if(inst_41368__$1){
var statearr_41515_42908 = state_41406__$1;
(statearr_41515_42908[(1)] = (8));

} else {
var statearr_41524_42909 = state_41406__$1;
(statearr_41524_42909[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41407 === (14))){
var inst_41359 = (state_41406[(9)]);
var inst_41363 = (state_41406[(11)]);
var inst_41380 = (state_41406[(2)]);
var inst_41381 = [];
var inst_41382 = inst_41381.push(inst_41359);
var inst_41353 = inst_41381;
var inst_41354 = inst_41363;
var state_41406__$1 = (function (){var statearr_41550 = state_41406;
(statearr_41550[(14)] = inst_41380);

(statearr_41550[(15)] = inst_41382);

(statearr_41550[(7)] = inst_41353);

(statearr_41550[(8)] = inst_41354);

return statearr_41550;
})();
var statearr_41551_42911 = state_41406__$1;
(statearr_41551_42911[(2)] = null);

(statearr_41551_42911[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41407 === (16))){
var state_41406__$1 = state_41406;
var statearr_41559_42912 = state_41406__$1;
(statearr_41559_42912[(2)] = null);

(statearr_41559_42912[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41407 === (10))){
var inst_41373 = (state_41406[(2)]);
var state_41406__$1 = state_41406;
if(cljs.core.truth_(inst_41373)){
var statearr_41575_42913 = state_41406__$1;
(statearr_41575_42913[(1)] = (11));

} else {
var statearr_41576_42914 = state_41406__$1;
(statearr_41576_42914[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41407 === (18))){
var inst_41396 = (state_41406[(2)]);
var state_41406__$1 = state_41406;
var statearr_41602_42916 = state_41406__$1;
(statearr_41602_42916[(2)] = inst_41396);

(statearr_41602_42916[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41407 === (8))){
var inst_41368 = (state_41406[(13)]);
var state_41406__$1 = state_41406;
var statearr_41609_42921 = state_41406__$1;
(statearr_41609_42921[(2)] = inst_41368);

(statearr_41609_42921[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__37551__auto__ = null;
var cljs$core$async$state_machine__37551__auto____0 = (function (){
var statearr_41615 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41615[(0)] = cljs$core$async$state_machine__37551__auto__);

(statearr_41615[(1)] = (1));

return statearr_41615;
});
var cljs$core$async$state_machine__37551__auto____1 = (function (state_41406){
while(true){
var ret_value__37552__auto__ = (function (){try{while(true){
var result__37553__auto__ = switch__37550__auto__(state_41406);
if(cljs.core.keyword_identical_QMARK_(result__37553__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__37553__auto__;
}
break;
}
}catch (e41620){var ex__37554__auto__ = e41620;
var statearr_41621_42923 = state_41406;
(statearr_41621_42923[(2)] = ex__37554__auto__);


if(cljs.core.seq((state_41406[(4)]))){
var statearr_41626_42924 = state_41406;
(statearr_41626_42924[(1)] = cljs.core.first((state_41406[(4)])));

} else {
throw ex__37554__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42925 = state_41406;
state_41406 = G__42925;
continue;
} else {
return ret_value__37552__auto__;
}
break;
}
});
cljs$core$async$state_machine__37551__auto__ = function(state_41406){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__37551__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__37551__auto____1.call(this,state_41406);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__37551__auto____0;
cljs$core$async$state_machine__37551__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__37551__auto____1;
return cljs$core$async$state_machine__37551__auto__;
})()
})();
var state__37796__auto__ = (function (){var statearr_41641 = f__37795__auto__();
(statearr_41641[(6)] = c__37794__auto___42854);

return statearr_41641;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37796__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
