if(typeof Math.imul == "undefined" || (Math.imul(0xffffffff,5) == 0)) {
    Math.imul = function (a, b) {
        var ah  = (a >>> 16) & 0xffff;
        var al = a & 0xffff;
        var bh  = (b >>> 16) & 0xffff;
        var bl = b & 0xffff;
        // the shift by 0 fixes the sign on the high part
        // the final |0 converts the unsigned value into a signed value
        return ((al * bl) + (((ah * bl + al * bh) << 16) >>> 0)|0);
    }
}


var CLOSURE_NO_DEPS = true;
var COMPILED = false;
var goog = goog || {};
goog.global = this;
goog.global.CLOSURE_UNCOMPILED_DEFINES;
goog.global.CLOSURE_DEFINES;
goog.isDef = function(val) {
  return val !== void 0;
};
goog.exportPath_ = function(name, opt_object, opt_objectToExportTo) {
  var parts = name.split(".");
  var cur = opt_objectToExportTo || goog.global;
  if (!(parts[0] in cur) && cur.execScript) {
    cur.execScript("var " + parts[0]);
  }
  for (var part; parts.length && (part = parts.shift());) {
    if (!parts.length && goog.isDef(opt_object)) {
      cur[part] = opt_object;
    } else {
      if (cur[part]) {
        cur = cur[part];
      } else {
        cur = cur[part] = {};
      }
    }
  }
};
goog.define = function(name, defaultValue) {
  var value = defaultValue;
  if (!COMPILED) {
    if (goog.global.CLOSURE_UNCOMPILED_DEFINES && Object.prototype.hasOwnProperty.call(goog.global.CLOSURE_UNCOMPILED_DEFINES, name)) {
      value = goog.global.CLOSURE_UNCOMPILED_DEFINES[name];
    } else {
      if (goog.global.CLOSURE_DEFINES && Object.prototype.hasOwnProperty.call(goog.global.CLOSURE_DEFINES, name)) {
        value = goog.global.CLOSURE_DEFINES[name];
      }
    }
  }
  goog.exportPath_(name, value);
};
goog.define("goog.DEBUG", true);
goog.define("goog.LOCALE", "en");
goog.define("goog.TRUSTED_SITE", true);
goog.define("goog.STRICT_MODE_COMPATIBLE", false);
goog.define("goog.DISALLOW_TEST_ONLY_CODE", COMPILED && !goog.DEBUG);
goog.define("goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING", false);
goog.provide = function(name) {
  if (goog.isInModuleLoader_()) {
    throw Error("goog.provide can not be used within a goog.module.");
  }
  if (!COMPILED) {
    if (goog.isProvided_(name)) {
      throw Error('Namespace "' + name + '" already declared.');
    }
  }
  goog.constructNamespace_(name);
};
goog.constructNamespace_ = function(name, opt_obj) {
  if (!COMPILED) {
    delete goog.implicitNamespaces_[name];
    var namespace = name;
    while (namespace = namespace.substring(0, namespace.lastIndexOf("."))) {
      if (goog.getObjectByName(namespace)) {
        break;
      }
      goog.implicitNamespaces_[namespace] = true;
    }
  }
  goog.exportPath_(name, opt_obj);
};
goog.VALID_MODULE_RE_ = /^[a-zA-Z_$][a-zA-Z0-9._$]*$/;
goog.module = function(name) {
  if (!goog.isString(name) || !name || name.search(goog.VALID_MODULE_RE_) == -1) {
    throw Error("Invalid module identifier");
  }
  if (!goog.isInModuleLoader_()) {
    throw Error("Module " + name + " has been loaded incorrectly.");
  }
  if (goog.moduleLoaderState_.moduleName) {
    throw Error("goog.module may only be called once per module.");
  }
  goog.moduleLoaderState_.moduleName = name;
  if (!COMPILED) {
    if (goog.isProvided_(name)) {
      throw Error('Namespace "' + name + '" already declared.');
    }
    delete goog.implicitNamespaces_[name];
  }
};
goog.module.get = function(name) {
  return goog.module.getInternal_(name);
};
goog.module.getInternal_ = function(name) {
  if (!COMPILED) {
    if (goog.isProvided_(name)) {
      return name in goog.loadedModules_ ? goog.loadedModules_[name] : goog.getObjectByName(name);
    } else {
      return null;
    }
  }
};
goog.moduleLoaderState_ = null;
goog.isInModuleLoader_ = function() {
  return goog.moduleLoaderState_ != null;
};
goog.module.declareLegacyNamespace = function() {
  if (!COMPILED && !goog.isInModuleLoader_()) {
    throw new Error("goog.module.declareLegacyNamespace must be called from " + "within a goog.module");
  }
  if (!COMPILED && !goog.moduleLoaderState_.moduleName) {
    throw Error("goog.module must be called prior to " + "goog.module.declareLegacyNamespace.");
  }
  goog.moduleLoaderState_.declareLegacyNamespace = true;
};
goog.setTestOnly = function(opt_message) {
  if (goog.DISALLOW_TEST_ONLY_CODE) {
    opt_message = opt_message || "";
    throw Error("Importing test-only code into non-debug environment" + (opt_message ? ": " + opt_message : "."));
  }
};
goog.forwardDeclare = function(name) {
};
goog.forwardDeclare("Document");
goog.forwardDeclare("HTMLScriptElement");
goog.forwardDeclare("XMLHttpRequest");
if (!COMPILED) {
  goog.isProvided_ = function(name) {
    return name in goog.loadedModules_ || !goog.implicitNamespaces_[name] && goog.isDefAndNotNull(goog.getObjectByName(name));
  };
  goog.implicitNamespaces_ = {"goog.module":true};
}
goog.getObjectByName = function(name, opt_obj) {
  var parts = name.split(".");
  var cur = opt_obj || goog.global;
  for (var part; part = parts.shift();) {
    if (goog.isDefAndNotNull(cur[part])) {
      cur = cur[part];
    } else {
      return null;
    }
  }
  return cur;
};
goog.globalize = function(obj, opt_global) {
  var global = opt_global || goog.global;
  for (var x in obj) {
    global[x] = obj[x];
  }
};
goog.addDependency = function(relPath, provides, requires, opt_loadFlags) {
  if (goog.DEPENDENCIES_ENABLED) {
    var provide, require;
    var path = relPath.replace(/\\/g, "/");
    var deps = goog.dependencies_;
    if (!opt_loadFlags || typeof opt_loadFlags === "boolean") {
      opt_loadFlags = opt_loadFlags ? {"module":"goog"} : {};
    }
    for (var i = 0; provide = provides[i]; i++) {
      deps.nameToPath[provide] = path;
      deps.loadFlags[path] = opt_loadFlags;
    }
    for (var j = 0; require = requires[j]; j++) {
      if (!(path in deps.requires)) {
        deps.requires[path] = {};
      }
      deps.requires[path][require] = true;
    }
  }
};
goog.define("goog.ENABLE_DEBUG_LOADER", true);
goog.logToConsole_ = function(msg) {
  if (goog.global.console) {
    goog.global.console["error"](msg);
  }
};
goog.require = function(name) {
  if (!COMPILED) {
    if (goog.ENABLE_DEBUG_LOADER && goog.IS_OLD_IE_) {
      goog.maybeProcessDeferredDep_(name);
    }
    if (goog.isProvided_(name)) {
      if (goog.isInModuleLoader_()) {
        return goog.module.getInternal_(name);
      } else {
        return null;
      }
    }
    if (goog.ENABLE_DEBUG_LOADER) {
      var path = goog.getPathFromDeps_(name);
      if (path) {
        goog.writeScripts_(path);
        return null;
      }
    }
    var errorMessage = "goog.require could not find: " + name;
    goog.logToConsole_(errorMessage);
    throw Error(errorMessage);
  }
};
goog.basePath = "";
goog.global.CLOSURE_BASE_PATH;
goog.global.CLOSURE_NO_DEPS;
goog.global.CLOSURE_IMPORT_SCRIPT;
goog.nullFunction = function() {
};
goog.abstractMethod = function() {
  throw Error("unimplemented abstract method");
};
goog.addSingletonGetter = function(ctor) {
  ctor.getInstance = function() {
    if (ctor.instance_) {
      return ctor.instance_;
    }
    if (goog.DEBUG) {
      goog.instantiatedSingletons_[goog.instantiatedSingletons_.length] = ctor;
    }
    return ctor.instance_ = new ctor;
  };
};
goog.instantiatedSingletons_ = [];
goog.define("goog.LOAD_MODULE_USING_EVAL", true);
goog.define("goog.SEAL_MODULE_EXPORTS", goog.DEBUG);
goog.loadedModules_ = {};
goog.DEPENDENCIES_ENABLED = !COMPILED && goog.ENABLE_DEBUG_LOADER;
goog.define("goog.TRANSPILE", "detect");
goog.define("goog.TRANSPILER", "transpile.js");
if (goog.DEPENDENCIES_ENABLED) {
  goog.dependencies_ = {loadFlags:{}, nameToPath:{}, requires:{}, visited:{}, written:{}, deferred:{}};
  goog.inHtmlDocument_ = function() {
    var doc = goog.global.document;
    return doc != null && "write" in doc;
  };
  goog.findBasePath_ = function() {
    if (goog.isDef(goog.global.CLOSURE_BASE_PATH)) {
      goog.basePath = goog.global.CLOSURE_BASE_PATH;
      return;
    } else {
      if (!goog.inHtmlDocument_()) {
        return;
      }
    }
    var doc = goog.global.document;
    var scripts = doc.getElementsByTagName("SCRIPT");
    for (var i = scripts.length - 1; i >= 0; --i) {
      var script = (scripts[i]);
      var src = script.src;
      var qmark = src.lastIndexOf("?");
      var l = qmark == -1 ? src.length : qmark;
      if (src.substr(l - 7, 7) == "base.js") {
        goog.basePath = src.substr(0, l - 7);
        return;
      }
    }
  };
  goog.importScript_ = function(src, opt_sourceText) {
    var importScript = goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_;
    if (importScript(src, opt_sourceText)) {
      goog.dependencies_.written[src] = true;
    }
  };
  goog.IS_OLD_IE_ = !!(!goog.global.atob && goog.global.document && goog.global.document.all);
  goog.importProcessedScript_ = function(src, isModule, needsTranspile) {
    var bootstrap = 'goog.retrieveAndExec_("' + src + '", ' + isModule + ", " + needsTranspile + ");";
    goog.importScript_("", bootstrap);
  };
  goog.queuedModules_ = [];
  goog.wrapModule_ = function(srcUrl, scriptText) {
    if (!goog.LOAD_MODULE_USING_EVAL || !goog.isDef(goog.global.JSON)) {
      return "" + "goog.loadModule(function(exports) {" + '"use strict";' + scriptText + "\n" + ";return exports" + "});" + "\n//# sourceURL\x3d" + srcUrl + "\n";
    } else {
      return "" + "goog.loadModule(" + goog.global.JSON.stringify(scriptText + "\n//# sourceURL\x3d" + srcUrl + "\n") + ");";
    }
  };
  goog.loadQueuedModules_ = function() {
    var count = goog.queuedModules_.length;
    if (count > 0) {
      var queue = goog.queuedModules_;
      goog.queuedModules_ = [];
      for (var i = 0; i < count; i++) {
        var path = queue[i];
        goog.maybeProcessDeferredPath_(path);
      }
    }
  };
  goog.maybeProcessDeferredDep_ = function(name) {
    if (goog.isDeferredModule_(name) && goog.allDepsAreAvailable_(name)) {
      var path = goog.getPathFromDeps_(name);
      goog.maybeProcessDeferredPath_(goog.basePath + path);
    }
  };
  goog.isDeferredModule_ = function(name) {
    var path = goog.getPathFromDeps_(name);
    var loadFlags = path && goog.dependencies_.loadFlags[path] || {};
    if (path && (loadFlags["module"] == "goog" || goog.needsTranspile_(loadFlags["lang"]))) {
      var abspath = goog.basePath + path;
      return abspath in goog.dependencies_.deferred;
    }
    return false;
  };
  goog.allDepsAreAvailable_ = function(name) {
    var path = goog.getPathFromDeps_(name);
    if (path && path in goog.dependencies_.requires) {
      for (var requireName in goog.dependencies_.requires[path]) {
        if (!goog.isProvided_(requireName) && !goog.isDeferredModule_(requireName)) {
          return false;
        }
      }
    }
    return true;
  };
  goog.maybeProcessDeferredPath_ = function(abspath) {
    if (abspath in goog.dependencies_.deferred) {
      var src = goog.dependencies_.deferred[abspath];
      delete goog.dependencies_.deferred[abspath];
      goog.globalEval(src);
    }
  };
  goog.loadModuleFromUrl = function(url) {
    goog.retrieveAndExec_(url, true, false);
  };
  goog.loadModule = function(moduleDef) {
    var previousState = goog.moduleLoaderState_;
    try {
      goog.moduleLoaderState_ = {moduleName:undefined, declareLegacyNamespace:false};
      var exports;
      if (goog.isFunction(moduleDef)) {
        exports = moduleDef.call(goog.global, {});
      } else {
        if (goog.isString(moduleDef)) {
          exports = goog.loadModuleFromSource_.call(goog.global, moduleDef);
        } else {
          throw Error("Invalid module definition");
        }
      }
      var moduleName = goog.moduleLoaderState_.moduleName;
      if (!goog.isString(moduleName) || !moduleName) {
        throw Error('Invalid module name "' + moduleName + '"');
      }
      if (goog.moduleLoaderState_.declareLegacyNamespace) {
        goog.constructNamespace_(moduleName, exports);
      } else {
        if (goog.SEAL_MODULE_EXPORTS && Object.seal) {
          Object.seal(exports);
        }
      }
      goog.loadedModules_[moduleName] = exports;
    } finally {
      goog.moduleLoaderState_ = previousState;
    }
  };
  goog.loadModuleFromSource_ = function() {
    var exports = {};
    eval(arguments[0]);
    return exports;
  };
  goog.writeScriptSrcNode_ = function(src) {
    goog.global.document.write('\x3cscript type\x3d"text/javascript" src\x3d"' + src + '"\x3e\x3c/' + "script\x3e");
  };
  goog.appendScriptSrcNode_ = function(src) {
    var doc = goog.global.document;
    var scriptEl = (doc.createElement("script"));
    scriptEl.type = "text/javascript";
    scriptEl.src = src;
    scriptEl.defer = false;
    scriptEl.async = false;
    doc.head.appendChild(scriptEl);
  };
  goog.writeScriptTag_ = function(src, opt_sourceText) {
    if (goog.inHtmlDocument_()) {
      var doc = goog.global.document;
      if (!goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING && doc.readyState == "complete") {
        var isDeps = /\bdeps.js$/.test(src);
        if (isDeps) {
          return false;
        } else {
          throw Error('Cannot write "' + src + '" after document load');
        }
      }
      if (opt_sourceText === undefined) {
        if (!goog.IS_OLD_IE_) {
          if (goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING) {
            goog.appendScriptSrcNode_(src);
          } else {
            goog.writeScriptSrcNode_(src);
          }
        } else {
          var state = " onreadystatechange\x3d'goog.onScriptLoad_(this, " + ++goog.lastNonModuleScriptIndex_ + ")' ";
          doc.write('\x3cscript type\x3d"text/javascript" src\x3d"' + src + '"' + state + "\x3e\x3c/" + "script\x3e");
        }
      } else {
        doc.write('\x3cscript type\x3d"text/javascript"\x3e' + opt_sourceText + "\x3c/" + "script\x3e");
      }
      return true;
    } else {
      return false;
    }
  };
  goog.needsTranspile_ = function(lang) {
    if (goog.TRANSPILE == "always") {
      return true;
    } else {
      if (goog.TRANSPILE == "never") {
        return false;
      } else {
        if (!goog.transpiledLanguages_) {
          goog.transpiledLanguages_ = {"es5":true, "es6":true, "es6-impl":true};
          try {
            goog.transpiledLanguages_["es5"] = eval("[1,].length!\x3d1");
            var es6implTest = "let a\x3d{};const X\x3dclass{constructor(){}x(z){return new Map([" + "...arguments]).get(z[0])\x3d\x3d3}};return new X().x([a,3])";
            var es6fullTest = "class X{constructor(){if(new.target!\x3dString)throw 1;this.x\x3d42}}" + "let q\x3dReflect.construct(X,[],String);if(q.x!\x3d42||!(q instanceof " + "String))throw 1;for(const a of[2,3]){if(a\x3d\x3d2)continue;function " + "f(z\x3d{a}){let a\x3d0;return z.a}{function f(){return 0;}}return f()" + "\x3d\x3d3}";
            if (eval('(()\x3d\x3e{"use strict";' + es6implTest + "})()")) {
              goog.transpiledLanguages_["es6-impl"] = false;
            }
            if (eval('(()\x3d\x3e{"use strict";' + es6fullTest + "})()")) {
              goog.transpiledLanguages_["es6"] = false;
            }
          } catch (err) {
          }
        }
      }
    }
    return !!goog.transpiledLanguages_[lang];
  };
  goog.transpiledLanguages_ = null;
  goog.lastNonModuleScriptIndex_ = 0;
  goog.onScriptLoad_ = function(script, scriptIndex) {
    if (script.readyState == "complete" && goog.lastNonModuleScriptIndex_ == scriptIndex) {
      goog.loadQueuedModules_();
    }
    return true;
  };
  goog.writeScripts_ = function(pathToLoad) {
    var scripts = [];
    var seenScript = {};
    var deps = goog.dependencies_;
    function visitNode(path) {
      if (path in deps.written) {
        return;
      }
      if (path in deps.visited) {
        return;
      }
      deps.visited[path] = true;
      if (path in deps.requires) {
        for (var requireName in deps.requires[path]) {
          if (!goog.isProvided_(requireName)) {
            if (requireName in deps.nameToPath) {
              visitNode(deps.nameToPath[requireName]);
            } else {
              throw Error("Undefined nameToPath for " + requireName);
            }
          }
        }
      }
      if (!(path in seenScript)) {
        seenScript[path] = true;
        scripts.push(path);
      }
    }
    visitNode(pathToLoad);
    for (var i = 0; i < scripts.length; i++) {
      var path = scripts[i];
      goog.dependencies_.written[path] = true;
    }
    var moduleState = goog.moduleLoaderState_;
    goog.moduleLoaderState_ = null;
    for (var i = 0; i < scripts.length; i++) {
      var path = scripts[i];
      if (path) {
        var loadFlags = deps.loadFlags[path] || {};
        var needsTranspile = goog.needsTranspile_(loadFlags["lang"]);
        if (loadFlags["module"] == "goog" || needsTranspile) {
          goog.importProcessedScript_(goog.basePath + path, loadFlags["module"] == "goog", needsTranspile);
        } else {
          goog.importScript_(goog.basePath + path);
        }
      } else {
        goog.moduleLoaderState_ = moduleState;
        throw Error("Undefined script input");
      }
    }
    goog.moduleLoaderState_ = moduleState;
  };
  goog.getPathFromDeps_ = function(rule) {
    if (rule in goog.dependencies_.nameToPath) {
      return goog.dependencies_.nameToPath[rule];
    } else {
      return null;
    }
  };
  goog.findBasePath_();
  if (!goog.global.CLOSURE_NO_DEPS) {
    goog.importScript_(goog.basePath + "deps.js");
  }
}
goog.normalizePath_ = function(path) {
  var components = path.split("/");
  var i = 0;
  while (i < components.length) {
    if (components[i] == ".") {
      components.splice(i, 1);
    } else {
      if (i && components[i] == ".." && components[i - 1] && components[i - 1] != "..") {
        components.splice(--i, 2);
      } else {
        i++;
      }
    }
  }
  return components.join("/");
};
goog.loadFileSync_ = function(src) {
  if (goog.global.CLOSURE_LOAD_FILE_SYNC) {
    return goog.global.CLOSURE_LOAD_FILE_SYNC(src);
  } else {
    try {
      var xhr = new goog.global["XMLHttpRequest"];
      xhr.open("get", src, false);
      xhr.send();
      return xhr.status == 0 || xhr.status == 200 ? xhr.responseText : null;
    } catch (err) {
      return null;
    }
  }
};
goog.retrieveAndExec_ = function(src, isModule, needsTranspile) {
  if (!COMPILED) {
    var originalPath = src;
    src = goog.normalizePath_(src);
    var importScript = goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_;
    var scriptText = goog.loadFileSync_(src);
    if (scriptText == null) {
      throw new Error('Load of "' + src + '" failed');
    }
    if (needsTranspile) {
      scriptText = goog.transpile_.call(goog.global, scriptText, src);
    }
    if (isModule) {
      scriptText = goog.wrapModule_(src, scriptText);
    } else {
      scriptText += "\n//# sourceURL\x3d" + src;
    }
    var isOldIE = goog.IS_OLD_IE_;
    if (isOldIE) {
      goog.dependencies_.deferred[originalPath] = scriptText;
      goog.queuedModules_.push(originalPath);
    } else {
      importScript(src, scriptText);
    }
  }
};
goog.transpile_ = function(code, path) {
  var jscomp = goog.global["$jscomp"];
  if (!jscomp) {
    goog.global["$jscomp"] = jscomp = {};
  }
  var transpile = jscomp.transpile;
  if (!transpile) {
    var transpilerPath = goog.basePath + goog.TRANSPILER;
    var transpilerCode = goog.loadFileSync_(transpilerPath);
    if (transpilerCode) {
      eval(transpilerCode + "\n//# sourceURL\x3d" + transpilerPath);
      jscomp = goog.global["$jscomp"];
      transpile = jscomp.transpile;
    }
  }
  if (!transpile) {
    var suffix = " requires transpilation but no transpiler was found.";
    transpile = jscomp.transpile = function(code, path) {
      goog.logToConsole_(path + suffix);
      return code;
    };
  }
  return transpile(code, path);
};
goog.typeOf = function(value) {
  var s = typeof value;
  if (s == "object") {
    if (value) {
      if (value instanceof Array) {
        return "array";
      } else {
        if (value instanceof Object) {
          return s;
        }
      }
      var className = Object.prototype.toString.call((value));
      if (className == "[object Window]") {
        return "object";
      }
      if (className == "[object Array]" || typeof value.length == "number" && typeof value.splice != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("splice")) {
        return "array";
      }
      if (className == "[object Function]" || typeof value.call != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("call")) {
        return "function";
      }
    } else {
      return "null";
    }
  } else {
    if (s == "function" && typeof value.call == "undefined") {
      return "object";
    }
  }
  return s;
};
goog.isNull = function(val) {
  return val === null;
};
goog.isDefAndNotNull = function(val) {
  return val != null;
};
goog.isArray = function(val) {
  return goog.typeOf(val) == "array";
};
goog.isArrayLike = function(val) {
  var type = goog.typeOf(val);
  return type == "array" || type == "object" && typeof val.length == "number";
};
goog.isDateLike = function(val) {
  return goog.isObject(val) && typeof val.getFullYear == "function";
};
goog.isString = function(val) {
  return typeof val == "string";
};
goog.isBoolean = function(val) {
  return typeof val == "boolean";
};
goog.isNumber = function(val) {
  return typeof val == "number";
};
goog.isFunction = function(val) {
  return goog.typeOf(val) == "function";
};
goog.isObject = function(val) {
  var type = typeof val;
  return type == "object" && val != null || type == "function";
};
goog.getUid = function(obj) {
  return obj[goog.UID_PROPERTY_] || (obj[goog.UID_PROPERTY_] = ++goog.uidCounter_);
};
goog.hasUid = function(obj) {
  return !!obj[goog.UID_PROPERTY_];
};
goog.removeUid = function(obj) {
  if (obj !== null && "removeAttribute" in obj) {
    obj.removeAttribute(goog.UID_PROPERTY_);
  }
  try {
    delete obj[goog.UID_PROPERTY_];
  } catch (ex) {
  }
};
goog.UID_PROPERTY_ = "closure_uid_" + (Math.random() * 1e9 >>> 0);
goog.uidCounter_ = 0;
goog.getHashCode = goog.getUid;
goog.removeHashCode = goog.removeUid;
goog.cloneObject = function(obj) {
  var type = goog.typeOf(obj);
  if (type == "object" || type == "array") {
    if (obj.clone) {
      return obj.clone();
    }
    var clone = type == "array" ? [] : {};
    for (var key in obj) {
      clone[key] = goog.cloneObject(obj[key]);
    }
    return clone;
  }
  return obj;
};
goog.bindNative_ = function(fn, selfObj, var_args) {
  return (fn.call.apply(fn.bind, arguments));
};
goog.bindJs_ = function(fn, selfObj, var_args) {
  if (!fn) {
    throw new Error;
  }
  if (arguments.length > 2) {
    var boundArgs = Array.prototype.slice.call(arguments, 2);
    return function() {
      var newArgs = Array.prototype.slice.call(arguments);
      Array.prototype.unshift.apply(newArgs, boundArgs);
      return fn.apply(selfObj, newArgs);
    };
  } else {
    return function() {
      return fn.apply(selfObj, arguments);
    };
  }
};
goog.bind = function(fn, selfObj, var_args) {
  if (Function.prototype.bind && Function.prototype.bind.toString().indexOf("native code") != -1) {
    goog.bind = goog.bindNative_;
  } else {
    goog.bind = goog.bindJs_;
  }
  return goog.bind.apply(null, arguments);
};
goog.partial = function(fn, var_args) {
  var args = Array.prototype.slice.call(arguments, 1);
  return function() {
    var newArgs = args.slice();
    newArgs.push.apply(newArgs, arguments);
    return fn.apply(this, newArgs);
  };
};
goog.mixin = function(target, source) {
  for (var x in source) {
    target[x] = source[x];
  }
};
goog.now = goog.TRUSTED_SITE && Date.now || function() {
  return +new Date;
};
goog.globalEval = function(script) {
  if (goog.global.execScript) {
    goog.global.execScript(script, "JavaScript");
  } else {
    if (goog.global.eval) {
      if (goog.evalWorksForGlobals_ == null) {
        goog.global.eval("var _evalTest_ \x3d 1;");
        if (typeof goog.global["_evalTest_"] != "undefined") {
          try {
            delete goog.global["_evalTest_"];
          } catch (ignore) {
          }
          goog.evalWorksForGlobals_ = true;
        } else {
          goog.evalWorksForGlobals_ = false;
        }
      }
      if (goog.evalWorksForGlobals_) {
        goog.global.eval(script);
      } else {
        var doc = goog.global.document;
        var scriptElt = (doc.createElement("SCRIPT"));
        scriptElt.type = "text/javascript";
        scriptElt.defer = false;
        scriptElt.appendChild(doc.createTextNode(script));
        doc.body.appendChild(scriptElt);
        doc.body.removeChild(scriptElt);
      }
    } else {
      throw Error("goog.globalEval not available");
    }
  }
};
goog.evalWorksForGlobals_ = null;
goog.cssNameMapping_;
goog.cssNameMappingStyle_;
goog.getCssName = function(className, opt_modifier) {
  var getMapping = function(cssName) {
    return goog.cssNameMapping_[cssName] || cssName;
  };
  var renameByParts = function(cssName) {
    var parts = cssName.split("-");
    var mapped = [];
    for (var i = 0; i < parts.length; i++) {
      mapped.push(getMapping(parts[i]));
    }
    return mapped.join("-");
  };
  var rename;
  if (goog.cssNameMapping_) {
    rename = goog.cssNameMappingStyle_ == "BY_WHOLE" ? getMapping : renameByParts;
  } else {
    rename = function(a) {
      return a;
    };
  }
  if (opt_modifier) {
    return className + "-" + rename(opt_modifier);
  } else {
    return rename(className);
  }
};
goog.setCssNameMapping = function(mapping, opt_style) {
  goog.cssNameMapping_ = mapping;
  goog.cssNameMappingStyle_ = opt_style;
};
goog.global.CLOSURE_CSS_NAME_MAPPING;
if (!COMPILED && goog.global.CLOSURE_CSS_NAME_MAPPING) {
  goog.cssNameMapping_ = goog.global.CLOSURE_CSS_NAME_MAPPING;
}
goog.getMsg = function(str, opt_values) {
  if (opt_values) {
    str = str.replace(/\{\$([^}]+)}/g, function(match, key) {
      return opt_values != null && key in opt_values ? opt_values[key] : match;
    });
  }
  return str;
};
goog.getMsgWithFallback = function(a, b) {
  return a;
};
goog.exportSymbol = function(publicPath, object, opt_objectToExportTo) {
  goog.exportPath_(publicPath, object, opt_objectToExportTo);
};
goog.exportProperty = function(object, publicName, symbol) {
  object[publicName] = symbol;
};
goog.inherits = function(childCtor, parentCtor) {
  function tempCtor() {
  }
  tempCtor.prototype = parentCtor.prototype;
  childCtor.superClass_ = parentCtor.prototype;
  childCtor.prototype = new tempCtor;
  childCtor.prototype.constructor = childCtor;
  childCtor.base = function(me, methodName, var_args) {
    var args = new Array(arguments.length - 2);
    for (var i = 2; i < arguments.length; i++) {
      args[i - 2] = arguments[i];
    }
    return parentCtor.prototype[methodName].apply(me, args);
  };
};
goog.base = function(me, opt_methodName, var_args) {
  var caller = arguments.callee.caller;
  if (goog.STRICT_MODE_COMPATIBLE || goog.DEBUG && !caller) {
    throw Error("arguments.caller not defined.  goog.base() cannot be used " + "with strict mode code. See " + "http://www.ecma-international.org/ecma-262/5.1/#sec-C");
  }
  if (caller.superClass_) {
    var ctorArgs = new Array(arguments.length - 1);
    for (var i = 1; i < arguments.length; i++) {
      ctorArgs[i - 1] = arguments[i];
    }
    return caller.superClass_.constructor.apply(me, ctorArgs);
  }
  var args = new Array(arguments.length - 2);
  for (var i = 2; i < arguments.length; i++) {
    args[i - 2] = arguments[i];
  }
  var foundCaller = false;
  for (var ctor = me.constructor; ctor; ctor = ctor.superClass_ && ctor.superClass_.constructor) {
    if (ctor.prototype[opt_methodName] === caller) {
      foundCaller = true;
    } else {
      if (foundCaller) {
        return ctor.prototype[opt_methodName].apply(me, args);
      }
    }
  }
  if (me[opt_methodName] === caller) {
    return me.constructor.prototype[opt_methodName].apply(me, args);
  } else {
    throw Error("goog.base called from a method of one name " + "to a method of a different name");
  }
};
goog.scope = function(fn) {
  if (goog.isInModuleLoader_()) {
    throw Error("goog.scope is not supported within a goog.module.");
  }
  fn.call(goog.global);
};
if (!COMPILED) {
  goog.global["COMPILED"] = COMPILED;
}
goog.defineClass = function(superClass, def) {
  var constructor = def.constructor;
  var statics = def.statics;
  if (!constructor || constructor == Object.prototype.constructor) {
    constructor = function() {
      throw Error("cannot instantiate an interface (no constructor defined).");
    };
  }
  var cls = goog.defineClass.createSealingConstructor_(constructor, superClass);
  if (superClass) {
    goog.inherits(cls, superClass);
  }
  delete def.constructor;
  delete def.statics;
  goog.defineClass.applyProperties_(cls.prototype, def);
  if (statics != null) {
    if (statics instanceof Function) {
      statics(cls);
    } else {
      goog.defineClass.applyProperties_(cls, statics);
    }
  }
  return cls;
};
goog.defineClass.ClassDescriptor;
goog.define("goog.defineClass.SEAL_CLASS_INSTANCES", goog.DEBUG);
goog.defineClass.createSealingConstructor_ = function(ctr, superClass) {
  if (!goog.defineClass.SEAL_CLASS_INSTANCES) {
    return ctr;
  }
  var superclassSealable = !goog.defineClass.isUnsealable_(superClass);
  var wrappedCtr = function() {
    var instance = ctr.apply(this, arguments) || this;
    instance[goog.UID_PROPERTY_] = instance[goog.UID_PROPERTY_];
    if (this.constructor === wrappedCtr && superclassSealable && Object.seal instanceof Function) {
      Object.seal(instance);
    }
    return instance;
  };
  return wrappedCtr;
};
goog.defineClass.isUnsealable_ = function(ctr) {
  return ctr && ctr.prototype && ctr.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_];
};
goog.defineClass.OBJECT_PROTOTYPE_FIELDS_ = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"];
goog.defineClass.applyProperties_ = function(target, source) {
  var key;
  for (key in source) {
    if (Object.prototype.hasOwnProperty.call(source, key)) {
      target[key] = source[key];
    }
  }
  for (var i = 0; i < goog.defineClass.OBJECT_PROTOTYPE_FIELDS_.length; i++) {
    key = goog.defineClass.OBJECT_PROTOTYPE_FIELDS_[i];
    if (Object.prototype.hasOwnProperty.call(source, key)) {
      target[key] = source[key];
    }
  }
};
goog.tagUnsealableClass = function(ctr) {
  if (!COMPILED && goog.defineClass.SEAL_CLASS_INSTANCES) {
    ctr.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_] = true;
  }
};
goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_ = "goog_defineClass_legacy_unsealable";
goog.provide("goog.string");
goog.provide("goog.string.Unicode");
goog.define("goog.string.DETECT_DOUBLE_ESCAPING", false);
goog.define("goog.string.FORCE_NON_DOM_HTML_UNESCAPING", false);
goog.string.Unicode = {NBSP:" "};
goog.string.startsWith = function(str, prefix) {
  return str.lastIndexOf(prefix, 0) == 0;
};
goog.string.endsWith = function(str, suffix) {
  var l = str.length - suffix.length;
  return l >= 0 && str.indexOf(suffix, l) == l;
};
goog.string.caseInsensitiveStartsWith = function(str, prefix) {
  return goog.string.caseInsensitiveCompare(prefix, str.substr(0, prefix.length)) == 0;
};
goog.string.caseInsensitiveEndsWith = function(str, suffix) {
  return goog.string.caseInsensitiveCompare(suffix, str.substr(str.length - suffix.length, suffix.length)) == 0;
};
goog.string.caseInsensitiveEquals = function(str1, str2) {
  return str1.toLowerCase() == str2.toLowerCase();
};
goog.string.subs = function(str, var_args) {
  var splitParts = str.split("%s");
  var returnString = "";
  var subsArguments = Array.prototype.slice.call(arguments, 1);
  while (subsArguments.length && splitParts.length > 1) {
    returnString += splitParts.shift() + subsArguments.shift();
  }
  return returnString + splitParts.join("%s");
};
goog.string.collapseWhitespace = function(str) {
  return str.replace(/[\s\xa0]+/g, " ").replace(/^\s+|\s+$/g, "");
};
goog.string.isEmptyOrWhitespace = function(str) {
  return /^[\s\xa0]*$/.test(str);
};
goog.string.isEmptyString = function(str) {
  return str.length == 0;
};
goog.string.isEmpty = goog.string.isEmptyOrWhitespace;
goog.string.isEmptyOrWhitespaceSafe = function(str) {
  return goog.string.isEmptyOrWhitespace(goog.string.makeSafe(str));
};
goog.string.isEmptySafe = goog.string.isEmptyOrWhitespaceSafe;
goog.string.isBreakingWhitespace = function(str) {
  return !/[^\t\n\r ]/.test(str);
};
goog.string.isAlpha = function(str) {
  return !/[^a-zA-Z]/.test(str);
};
goog.string.isNumeric = function(str) {
  return !/[^0-9]/.test(str);
};
goog.string.isAlphaNumeric = function(str) {
  return !/[^a-zA-Z0-9]/.test(str);
};
goog.string.isSpace = function(ch) {
  return ch == " ";
};
goog.string.isUnicodeChar = function(ch) {
  return ch.length == 1 && ch >= " " && ch <= "~" || ch >= "" && ch <= "�";
};
goog.string.stripNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)+/g, " ");
};
goog.string.canonicalizeNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)/g, "\n");
};
goog.string.normalizeWhitespace = function(str) {
  return str.replace(/\xa0|\s/g, " ");
};
goog.string.normalizeSpaces = function(str) {
  return str.replace(/\xa0|[ \t]+/g, " ");
};
goog.string.collapseBreakingSpaces = function(str) {
  return str.replace(/[\t\r\n ]+/g, " ").replace(/^[\t\r\n ]+|[\t\r\n ]+$/g, "");
};
goog.string.trim = goog.TRUSTED_SITE && String.prototype.trim ? function(str) {
  return str.trim();
} : function(str) {
  return str.replace(/^[\s\xa0]+|[\s\xa0]+$/g, "");
};
goog.string.trimLeft = function(str) {
  return str.replace(/^[\s\xa0]+/, "");
};
goog.string.trimRight = function(str) {
  return str.replace(/[\s\xa0]+$/, "");
};
goog.string.caseInsensitiveCompare = function(str1, str2) {
  var test1 = String(str1).toLowerCase();
  var test2 = String(str2).toLowerCase();
  if (test1 < test2) {
    return -1;
  } else {
    if (test1 == test2) {
      return 0;
    } else {
      return 1;
    }
  }
};
goog.string.numberAwareCompare_ = function(str1, str2, tokenizerRegExp) {
  if (str1 == str2) {
    return 0;
  }
  if (!str1) {
    return -1;
  }
  if (!str2) {
    return 1;
  }
  var tokens1 = str1.toLowerCase().match(tokenizerRegExp);
  var tokens2 = str2.toLowerCase().match(tokenizerRegExp);
  var count = Math.min(tokens1.length, tokens2.length);
  for (var i = 0; i < count; i++) {
    var a = tokens1[i];
    var b = tokens2[i];
    if (a != b) {
      var num1 = parseInt(a, 10);
      if (!isNaN(num1)) {
        var num2 = parseInt(b, 10);
        if (!isNaN(num2) && num1 - num2) {
          return num1 - num2;
        }
      }
      return a < b ? -1 : 1;
    }
  }
  if (tokens1.length != tokens2.length) {
    return tokens1.length - tokens2.length;
  }
  return str1 < str2 ? -1 : 1;
};
goog.string.intAwareCompare = function(str1, str2) {
  return goog.string.numberAwareCompare_(str1, str2, /\d+|\D+/g);
};
goog.string.floatAwareCompare = function(str1, str2) {
  return goog.string.numberAwareCompare_(str1, str2, /\d+|\.\d+|\D+/g);
};
goog.string.numerateCompare = goog.string.floatAwareCompare;
goog.string.urlEncode = function(str) {
  return encodeURIComponent(String(str));
};
goog.string.urlDecode = function(str) {
  return decodeURIComponent(str.replace(/\+/g, " "));
};
goog.string.newLineToBr = function(str, opt_xml) {
  return str.replace(/(\r\n|\r|\n)/g, opt_xml ? "\x3cbr /\x3e" : "\x3cbr\x3e");
};
goog.string.htmlEscape = function(str, opt_isLikelyToContainHtmlChars) {
  if (opt_isLikelyToContainHtmlChars) {
    str = str.replace(goog.string.AMP_RE_, "\x26amp;").replace(goog.string.LT_RE_, "\x26lt;").replace(goog.string.GT_RE_, "\x26gt;").replace(goog.string.QUOT_RE_, "\x26quot;").replace(goog.string.SINGLE_QUOTE_RE_, "\x26#39;").replace(goog.string.NULL_RE_, "\x26#0;");
    if (goog.string.DETECT_DOUBLE_ESCAPING) {
      str = str.replace(goog.string.E_RE_, "\x26#101;");
    }
    return str;
  } else {
    if (!goog.string.ALL_RE_.test(str)) {
      return str;
    }
    if (str.indexOf("\x26") != -1) {
      str = str.replace(goog.string.AMP_RE_, "\x26amp;");
    }
    if (str.indexOf("\x3c") != -1) {
      str = str.replace(goog.string.LT_RE_, "\x26lt;");
    }
    if (str.indexOf("\x3e") != -1) {
      str = str.replace(goog.string.GT_RE_, "\x26gt;");
    }
    if (str.indexOf('"') != -1) {
      str = str.replace(goog.string.QUOT_RE_, "\x26quot;");
    }
    if (str.indexOf("'") != -1) {
      str = str.replace(goog.string.SINGLE_QUOTE_RE_, "\x26#39;");
    }
    if (str.indexOf("\x00") != -1) {
      str = str.replace(goog.string.NULL_RE_, "\x26#0;");
    }
    if (goog.string.DETECT_DOUBLE_ESCAPING && str.indexOf("e") != -1) {
      str = str.replace(goog.string.E_RE_, "\x26#101;");
    }
    return str;
  }
};
goog.string.AMP_RE_ = /&/g;
goog.string.LT_RE_ = /</g;
goog.string.GT_RE_ = />/g;
goog.string.QUOT_RE_ = /"/g;
goog.string.SINGLE_QUOTE_RE_ = /'/g;
goog.string.NULL_RE_ = /\x00/g;
goog.string.E_RE_ = /e/g;
goog.string.ALL_RE_ = goog.string.DETECT_DOUBLE_ESCAPING ? /[\x00&<>"'e]/ : /[\x00&<>"']/;
goog.string.unescapeEntities = function(str) {
  if (goog.string.contains(str, "\x26")) {
    if (!goog.string.FORCE_NON_DOM_HTML_UNESCAPING && "document" in goog.global) {
      return goog.string.unescapeEntitiesUsingDom_(str);
    } else {
      return goog.string.unescapePureXmlEntities_(str);
    }
  }
  return str;
};
goog.string.unescapeEntitiesWithDocument = function(str, document) {
  if (goog.string.contains(str, "\x26")) {
    return goog.string.unescapeEntitiesUsingDom_(str, document);
  }
  return str;
};
goog.string.unescapeEntitiesUsingDom_ = function(str, opt_document) {
  var seen = {"\x26amp;":"\x26", "\x26lt;":"\x3c", "\x26gt;":"\x3e", "\x26quot;":'"'};
  var div;
  if (opt_document) {
    div = opt_document.createElement("div");
  } else {
    div = goog.global.document.createElement("div");
  }
  return str.replace(goog.string.HTML_ENTITY_PATTERN_, function(s, entity) {
    var value = seen[s];
    if (value) {
      return value;
    }
    if (entity.charAt(0) == "#") {
      var n = Number("0" + entity.substr(1));
      if (!isNaN(n)) {
        value = String.fromCharCode(n);
      }
    }
    if (!value) {
      div.innerHTML = s + " ";
      value = div.firstChild.nodeValue.slice(0, -1);
    }
    return seen[s] = value;
  });
};
goog.string.unescapePureXmlEntities_ = function(str) {
  return str.replace(/&([^;]+);/g, function(s, entity) {
    switch(entity) {
      case "amp":
        return "\x26";
      case "lt":
        return "\x3c";
      case "gt":
        return "\x3e";
      case "quot":
        return '"';
      default:
        if (entity.charAt(0) == "#") {
          var n = Number("0" + entity.substr(1));
          if (!isNaN(n)) {
            return String.fromCharCode(n);
          }
        }
        return s;
    }
  });
};
goog.string.HTML_ENTITY_PATTERN_ = /&([^;\s<&]+);?/g;
goog.string.whitespaceEscape = function(str, opt_xml) {
  return goog.string.newLineToBr(str.replace(/  /g, " \x26#160;"), opt_xml);
};
goog.string.preserveSpaces = function(str) {
  return str.replace(/(^|[\n ]) /g, "$1" + goog.string.Unicode.NBSP);
};
goog.string.stripQuotes = function(str, quoteChars) {
  var length = quoteChars.length;
  for (var i = 0; i < length; i++) {
    var quoteChar = length == 1 ? quoteChars : quoteChars.charAt(i);
    if (str.charAt(0) == quoteChar && str.charAt(str.length - 1) == quoteChar) {
      return str.substring(1, str.length - 1);
    }
  }
  return str;
};
goog.string.truncate = function(str, chars, opt_protectEscapedCharacters) {
  if (opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str);
  }
  if (str.length > chars) {
    str = str.substring(0, chars - 3) + "...";
  }
  if (opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str);
  }
  return str;
};
goog.string.truncateMiddle = function(str, chars, opt_protectEscapedCharacters, opt_trailingChars) {
  if (opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str);
  }
  if (opt_trailingChars && str.length > chars) {
    if (opt_trailingChars > chars) {
      opt_trailingChars = chars;
    }
    var endPoint = str.length - opt_trailingChars;
    var startPoint = chars - opt_trailingChars;
    str = str.substring(0, startPoint) + "..." + str.substring(endPoint);
  } else {
    if (str.length > chars) {
      var half = Math.floor(chars / 2);
      var endPos = str.length - half;
      half += chars % 2;
      str = str.substring(0, half) + "..." + str.substring(endPos);
    }
  }
  if (opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str);
  }
  return str;
};
goog.string.specialEscapeChars_ = {"\x00":"\\0", "\b":"\\b", "\f":"\\f", "\n":"\\n", "\r":"\\r", "\t":"\\t", "\x0B":"\\x0B", '"':'\\"', "\\":"\\\\", "\x3c":"\x3c"};
goog.string.jsEscapeCache_ = {"'":"\\'"};
goog.string.quote = function(s) {
  s = String(s);
  var sb = ['"'];
  for (var i = 0; i < s.length; i++) {
    var ch = s.charAt(i);
    var cc = ch.charCodeAt(0);
    sb[i + 1] = goog.string.specialEscapeChars_[ch] || (cc > 31 && cc < 127 ? ch : goog.string.escapeChar(ch));
  }
  sb.push('"');
  return sb.join("");
};
goog.string.escapeString = function(str) {
  var sb = [];
  for (var i = 0; i < str.length; i++) {
    sb[i] = goog.string.escapeChar(str.charAt(i));
  }
  return sb.join("");
};
goog.string.escapeChar = function(c) {
  if (c in goog.string.jsEscapeCache_) {
    return goog.string.jsEscapeCache_[c];
  }
  if (c in goog.string.specialEscapeChars_) {
    return goog.string.jsEscapeCache_[c] = goog.string.specialEscapeChars_[c];
  }
  var rv = c;
  var cc = c.charCodeAt(0);
  if (cc > 31 && cc < 127) {
    rv = c;
  } else {
    if (cc < 256) {
      rv = "\\x";
      if (cc < 16 || cc > 256) {
        rv += "0";
      }
    } else {
      rv = "\\u";
      if (cc < 4096) {
        rv += "0";
      }
    }
    rv += cc.toString(16).toUpperCase();
  }
  return goog.string.jsEscapeCache_[c] = rv;
};
goog.string.contains = function(str, subString) {
  return str.indexOf(subString) != -1;
};
goog.string.caseInsensitiveContains = function(str, subString) {
  return goog.string.contains(str.toLowerCase(), subString.toLowerCase());
};
goog.string.countOf = function(s, ss) {
  return s && ss ? s.split(ss).length - 1 : 0;
};
goog.string.removeAt = function(s, index, stringLength) {
  var resultStr = s;
  if (index >= 0 && index < s.length && stringLength > 0) {
    resultStr = s.substr(0, index) + s.substr(index + stringLength, s.length - index - stringLength);
  }
  return resultStr;
};
goog.string.remove = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "");
  return s.replace(re, "");
};
goog.string.removeAll = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "g");
  return s.replace(re, "");
};
goog.string.regExpEscape = function(s) {
  return String(s).replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g, "\\$1").replace(/\x08/g, "\\x08");
};
goog.string.repeat = String.prototype.repeat ? function(string, length) {
  return string.repeat(length);
} : function(string, length) {
  return (new Array(length + 1)).join(string);
};
goog.string.padNumber = function(num, length, opt_precision) {
  var s = goog.isDef(opt_precision) ? num.toFixed(opt_precision) : String(num);
  var index = s.indexOf(".");
  if (index == -1) {
    index = s.length;
  }
  return goog.string.repeat("0", Math.max(0, length - index)) + s;
};
goog.string.makeSafe = function(obj) {
  return obj == null ? "" : String(obj);
};
goog.string.buildString = function(var_args) {
  return Array.prototype.join.call(arguments, "");
};
goog.string.getRandomString = function() {
  var x = 2147483648;
  return Math.floor(Math.random() * x).toString(36) + Math.abs(Math.floor(Math.random() * x) ^ goog.now()).toString(36);
};
goog.string.compareVersions = function(version1, version2) {
  var order = 0;
  var v1Subs = goog.string.trim(String(version1)).split(".");
  var v2Subs = goog.string.trim(String(version2)).split(".");
  var subCount = Math.max(v1Subs.length, v2Subs.length);
  for (var subIdx = 0; order == 0 && subIdx < subCount; subIdx++) {
    var v1Sub = v1Subs[subIdx] || "";
    var v2Sub = v2Subs[subIdx] || "";
    var v1CompParser = new RegExp("(\\d*)(\\D*)", "g");
    var v2CompParser = new RegExp("(\\d*)(\\D*)", "g");
    do {
      var v1Comp = v1CompParser.exec(v1Sub) || ["", "", ""];
      var v2Comp = v2CompParser.exec(v2Sub) || ["", "", ""];
      if (v1Comp[0].length == 0 && v2Comp[0].length == 0) {
        break;
      }
      var v1CompNum = v1Comp[1].length == 0 ? 0 : parseInt(v1Comp[1], 10);
      var v2CompNum = v2Comp[1].length == 0 ? 0 : parseInt(v2Comp[1], 10);
      order = goog.string.compareElements_(v1CompNum, v2CompNum) || goog.string.compareElements_(v1Comp[2].length == 0, v2Comp[2].length == 0) || goog.string.compareElements_(v1Comp[2], v2Comp[2]);
    } while (order == 0);
  }
  return order;
};
goog.string.compareElements_ = function(left, right) {
  if (left < right) {
    return -1;
  } else {
    if (left > right) {
      return 1;
    }
  }
  return 0;
};
goog.string.hashCode = function(str) {
  var result = 0;
  for (var i = 0; i < str.length; ++i) {
    result = 31 * result + str.charCodeAt(i) >>> 0;
  }
  return result;
};
goog.string.uniqueStringCounter_ = Math.random() * 2147483648 | 0;
goog.string.createUniqueString = function() {
  return "goog_" + goog.string.uniqueStringCounter_++;
};
goog.string.toNumber = function(str) {
  var num = Number(str);
  if (num == 0 && goog.string.isEmptyOrWhitespace(str)) {
    return NaN;
  }
  return num;
};
goog.string.isLowerCamelCase = function(str) {
  return /^[a-z]+([A-Z][a-z]*)*$/.test(str);
};
goog.string.isUpperCamelCase = function(str) {
  return /^([A-Z][a-z]*)+$/.test(str);
};
goog.string.toCamelCase = function(str) {
  return String(str).replace(/\-([a-z])/g, function(all, match) {
    return match.toUpperCase();
  });
};
goog.string.toSelectorCase = function(str) {
  return String(str).replace(/([A-Z])/g, "-$1").toLowerCase();
};
goog.string.toTitleCase = function(str, opt_delimiters) {
  var delimiters = goog.isString(opt_delimiters) ? goog.string.regExpEscape(opt_delimiters) : "\\s";
  delimiters = delimiters ? "|[" + delimiters + "]+" : "";
  var regexp = new RegExp("(^" + delimiters + ")([a-z])", "g");
  return str.replace(regexp, function(all, p1, p2) {
    return p1 + p2.toUpperCase();
  });
};
goog.string.capitalize = function(str) {
  return String(str.charAt(0)).toUpperCase() + String(str.substr(1)).toLowerCase();
};
goog.string.parseInt = function(value) {
  if (isFinite(value)) {
    value = String(value);
  }
  if (goog.isString(value)) {
    return /^\s*-?0x/i.test(value) ? parseInt(value, 16) : parseInt(value, 10);
  }
  return NaN;
};
goog.string.splitLimit = function(str, separator, limit) {
  var parts = str.split(separator);
  var returnVal = [];
  while (limit > 0 && parts.length) {
    returnVal.push(parts.shift());
    limit--;
  }
  if (parts.length) {
    returnVal.push(parts.join(separator));
  }
  return returnVal;
};
goog.string.lastComponent = function(str, separators) {
  if (!separators) {
    return str;
  } else {
    if (typeof separators == "string") {
      separators = [separators];
    }
  }
  var lastSeparatorIndex = -1;
  for (var i = 0; i < separators.length; i++) {
    if (separators[i] == "") {
      continue;
    }
    var currentSeparatorIndex = str.lastIndexOf(separators[i]);
    if (currentSeparatorIndex > lastSeparatorIndex) {
      lastSeparatorIndex = currentSeparatorIndex;
    }
  }
  if (lastSeparatorIndex == -1) {
    return str;
  }
  return str.slice(lastSeparatorIndex + 1);
};
goog.string.editDistance = function(a, b) {
  var v0 = [];
  var v1 = [];
  if (a == b) {
    return 0;
  }
  if (!a.length || !b.length) {
    return Math.max(a.length, b.length);
  }
  for (var i = 0; i < b.length + 1; i++) {
    v0[i] = i;
  }
  for (var i = 0; i < a.length; i++) {
    v1[0] = i + 1;
    for (var j = 0; j < b.length; j++) {
      var cost = Number(a[i] != b[j]);
      v1[j + 1] = Math.min(v1[j] + 1, v0[j + 1] + 1, v0[j] + cost);
    }
    for (var j = 0; j < v0.length; j++) {
      v0[j] = v1[j];
    }
  }
  return v1[b.length];
};
goog.provide("goog.object");
goog.object.is = function(v, v2) {
  if (v === v2) {
    return v !== 0 || 1 / v === 1 / (v2);
  }
  return v !== v && v2 !== v2;
};
goog.object.forEach = function(obj, f, opt_obj) {
  for (var key in obj) {
    f.call((opt_obj), obj[key], key, obj);
  }
};
goog.object.filter = function(obj, f, opt_obj) {
  var res = {};
  for (var key in obj) {
    if (f.call((opt_obj), obj[key], key, obj)) {
      res[key] = obj[key];
    }
  }
  return res;
};
goog.object.map = function(obj, f, opt_obj) {
  var res = {};
  for (var key in obj) {
    res[key] = f.call((opt_obj), obj[key], key, obj);
  }
  return res;
};
goog.object.some = function(obj, f, opt_obj) {
  for (var key in obj) {
    if (f.call((opt_obj), obj[key], key, obj)) {
      return true;
    }
  }
  return false;
};
goog.object.every = function(obj, f, opt_obj) {
  for (var key in obj) {
    if (!f.call((opt_obj), obj[key], key, obj)) {
      return false;
    }
  }
  return true;
};
goog.object.getCount = function(obj) {
  var rv = 0;
  for (var key in obj) {
    rv++;
  }
  return rv;
};
goog.object.getAnyKey = function(obj) {
  for (var key in obj) {
    return key;
  }
};
goog.object.getAnyValue = function(obj) {
  for (var key in obj) {
    return obj[key];
  }
};
goog.object.contains = function(obj, val) {
  return goog.object.containsValue(obj, val);
};
goog.object.getValues = function(obj) {
  var res = [];
  var i = 0;
  for (var key in obj) {
    res[i++] = obj[key];
  }
  return res;
};
goog.object.getKeys = function(obj) {
  var res = [];
  var i = 0;
  for (var key in obj) {
    res[i++] = key;
  }
  return res;
};
goog.object.getValueByKeys = function(obj, var_args) {
  var isArrayLike = goog.isArrayLike(var_args);
  var keys = isArrayLike ? var_args : arguments;
  for (var i = isArrayLike ? 0 : 1; i < keys.length; i++) {
    obj = obj[keys[i]];
    if (!goog.isDef(obj)) {
      break;
    }
  }
  return obj;
};
goog.object.containsKey = function(obj, key) {
  return obj !== null && key in obj;
};
goog.object.containsValue = function(obj, val) {
  for (var key in obj) {
    if (obj[key] == val) {
      return true;
    }
  }
  return false;
};
goog.object.findKey = function(obj, f, opt_this) {
  for (var key in obj) {
    if (f.call((opt_this), obj[key], key, obj)) {
      return key;
    }
  }
  return undefined;
};
goog.object.findValue = function(obj, f, opt_this) {
  var key = goog.object.findKey(obj, f, opt_this);
  return key && obj[key];
};
goog.object.isEmpty = function(obj) {
  for (var key in obj) {
    return false;
  }
  return true;
};
goog.object.clear = function(obj) {
  for (var i in obj) {
    delete obj[i];
  }
};
goog.object.remove = function(obj, key) {
  var rv;
  if (rv = key in (obj)) {
    delete obj[key];
  }
  return rv;
};
goog.object.add = function(obj, key, val) {
  if (obj !== null && key in obj) {
    throw Error('The object already contains the key "' + key + '"');
  }
  goog.object.set(obj, key, val);
};
goog.object.get = function(obj, key, opt_val) {
  if (obj !== null && key in obj) {
    return obj[key];
  }
  return opt_val;
};
goog.object.set = function(obj, key, value) {
  obj[key] = value;
};
goog.object.setIfUndefined = function(obj, key, value) {
  return key in (obj) ? obj[key] : obj[key] = value;
};
goog.object.setWithReturnValueIfNotSet = function(obj, key, f) {
  if (key in obj) {
    return obj[key];
  }
  var val = f();
  obj[key] = val;
  return val;
};
goog.object.equals = function(a, b) {
  for (var k in a) {
    if (!(k in b) || a[k] !== b[k]) {
      return false;
    }
  }
  for (var k in b) {
    if (!(k in a)) {
      return false;
    }
  }
  return true;
};
goog.object.clone = function(obj) {
  var res = {};
  for (var key in obj) {
    res[key] = obj[key];
  }
  return res;
};
goog.object.unsafeClone = function(obj) {
  var type = goog.typeOf(obj);
  if (type == "object" || type == "array") {
    if (goog.isFunction(obj.clone)) {
      return obj.clone();
    }
    var clone = type == "array" ? [] : {};
    for (var key in obj) {
      clone[key] = goog.object.unsafeClone(obj[key]);
    }
    return clone;
  }
  return obj;
};
goog.object.transpose = function(obj) {
  var transposed = {};
  for (var key in obj) {
    transposed[obj[key]] = key;
  }
  return transposed;
};
goog.object.PROTOTYPE_FIELDS_ = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"];
goog.object.extend = function(target, var_args) {
  var key, source;
  for (var i = 1; i < arguments.length; i++) {
    source = arguments[i];
    for (key in source) {
      target[key] = source[key];
    }
    for (var j = 0; j < goog.object.PROTOTYPE_FIELDS_.length; j++) {
      key = goog.object.PROTOTYPE_FIELDS_[j];
      if (Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key];
      }
    }
  }
};
goog.object.create = function(var_args) {
  var argLength = arguments.length;
  if (argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.create.apply(null, arguments[0]);
  }
  if (argLength % 2) {
    throw Error("Uneven number of arguments");
  }
  var rv = {};
  for (var i = 0; i < argLength; i += 2) {
    rv[arguments[i]] = arguments[i + 1];
  }
  return rv;
};
goog.object.createSet = function(var_args) {
  var argLength = arguments.length;
  if (argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.createSet.apply(null, arguments[0]);
  }
  var rv = {};
  for (var i = 0; i < argLength; i++) {
    rv[arguments[i]] = true;
  }
  return rv;
};
goog.object.createImmutableView = function(obj) {
  var result = obj;
  if (Object.isFrozen && !Object.isFrozen(obj)) {
    result = Object.create(obj);
    Object.freeze(result);
  }
  return result;
};
goog.object.isImmutableView = function(obj) {
  return !!Object.isFrozen && Object.isFrozen(obj);
};
goog.provide("goog.math.Integer");
goog.math.Integer = function(bits, sign) {
  this.bits_ = [];
  this.sign_ = sign;
  var top = true;
  for (var i = bits.length - 1; i >= 0; i--) {
    var val = bits[i] | 0;
    if (!top || val != sign) {
      this.bits_[i] = val;
      top = false;
    }
  }
};
goog.math.Integer.IntCache_ = {};
goog.math.Integer.fromInt = function(value) {
  if (-128 <= value && value < 128) {
    var cachedObj = goog.math.Integer.IntCache_[value];
    if (cachedObj) {
      return cachedObj;
    }
  }
  var obj = new goog.math.Integer([value | 0], value < 0 ? -1 : 0);
  if (-128 <= value && value < 128) {
    goog.math.Integer.IntCache_[value] = obj;
  }
  return obj;
};
goog.math.Integer.fromNumber = function(value) {
  if (isNaN(value) || !isFinite(value)) {
    return goog.math.Integer.ZERO;
  } else {
    if (value < 0) {
      return goog.math.Integer.fromNumber(-value).negate();
    } else {
      var bits = [];
      var pow = 1;
      for (var i = 0; value >= pow; i++) {
        bits[i] = value / pow | 0;
        pow *= goog.math.Integer.TWO_PWR_32_DBL_;
      }
      return new goog.math.Integer(bits, 0);
    }
  }
};
goog.math.Integer.fromBits = function(bits) {
  var high = bits[bits.length - 1];
  return new goog.math.Integer(bits, high & 1 << 31 ? -1 : 0);
};
goog.math.Integer.fromString = function(str, opt_radix) {
  if (str.length == 0) {
    throw Error("number format error: empty string");
  }
  var radix = opt_radix || 10;
  if (radix < 2 || 36 < radix) {
    throw Error("radix out of range: " + radix);
  }
  if (str.charAt(0) == "-") {
    return goog.math.Integer.fromString(str.substring(1), radix).negate();
  } else {
    if (str.indexOf("-") >= 0) {
      throw Error('number format error: interior "-" character');
    }
  }
  var radixToPower = goog.math.Integer.fromNumber(Math.pow(radix, 8));
  var result = goog.math.Integer.ZERO;
  for (var i = 0; i < str.length; i += 8) {
    var size = Math.min(8, str.length - i);
    var value = parseInt(str.substring(i, i + size), radix);
    if (size < 8) {
      var power = goog.math.Integer.fromNumber(Math.pow(radix, size));
      result = result.multiply(power).add(goog.math.Integer.fromNumber(value));
    } else {
      result = result.multiply(radixToPower);
      result = result.add(goog.math.Integer.fromNumber(value));
    }
  }
  return result;
};
goog.math.Integer.TWO_PWR_32_DBL_ = (1 << 16) * (1 << 16);
goog.math.Integer.ZERO = goog.math.Integer.fromInt(0);
goog.math.Integer.ONE = goog.math.Integer.fromInt(1);
goog.math.Integer.TWO_PWR_24_ = goog.math.Integer.fromInt(1 << 24);
goog.math.Integer.prototype.toInt = function() {
  return this.bits_.length > 0 ? this.bits_[0] : this.sign_;
};
goog.math.Integer.prototype.toNumber = function() {
  if (this.isNegative()) {
    return -this.negate().toNumber();
  } else {
    var val = 0;
    var pow = 1;
    for (var i = 0; i < this.bits_.length; i++) {
      val += this.getBitsUnsigned(i) * pow;
      pow *= goog.math.Integer.TWO_PWR_32_DBL_;
    }
    return val;
  }
};
goog.math.Integer.prototype.toString = function(opt_radix) {
  var radix = opt_radix || 10;
  if (radix < 2 || 36 < radix) {
    throw Error("radix out of range: " + radix);
  }
  if (this.isZero()) {
    return "0";
  } else {
    if (this.isNegative()) {
      return "-" + this.negate().toString(radix);
    }
  }
  var radixToPower = goog.math.Integer.fromNumber(Math.pow(radix, 6));
  var rem = this;
  var result = "";
  while (true) {
    var remDiv = rem.divide(radixToPower);
    var intval = rem.subtract(remDiv.multiply(radixToPower)).toInt() >>> 0;
    var digits = intval.toString(radix);
    rem = remDiv;
    if (rem.isZero()) {
      return digits + result;
    } else {
      while (digits.length < 6) {
        digits = "0" + digits;
      }
      result = "" + digits + result;
    }
  }
};
goog.math.Integer.prototype.getBits = function(index) {
  if (index < 0) {
    return 0;
  } else {
    if (index < this.bits_.length) {
      return this.bits_[index];
    } else {
      return this.sign_;
    }
  }
};
goog.math.Integer.prototype.getBitsUnsigned = function(index) {
  var val = this.getBits(index);
  return val >= 0 ? val : goog.math.Integer.TWO_PWR_32_DBL_ + val;
};
goog.math.Integer.prototype.getSign = function() {
  return this.sign_;
};
goog.math.Integer.prototype.isZero = function() {
  if (this.sign_ != 0) {
    return false;
  }
  for (var i = 0; i < this.bits_.length; i++) {
    if (this.bits_[i] != 0) {
      return false;
    }
  }
  return true;
};
goog.math.Integer.prototype.isNegative = function() {
  return this.sign_ == -1;
};
goog.math.Integer.prototype.isOdd = function() {
  return this.bits_.length == 0 && this.sign_ == -1 || this.bits_.length > 0 && (this.bits_[0] & 1) != 0;
};
goog.math.Integer.prototype.equals = function(other) {
  if (this.sign_ != other.sign_) {
    return false;
  }
  var len = Math.max(this.bits_.length, other.bits_.length);
  for (var i = 0; i < len; i++) {
    if (this.getBits(i) != other.getBits(i)) {
      return false;
    }
  }
  return true;
};
goog.math.Integer.prototype.notEquals = function(other) {
  return !this.equals(other);
};
goog.math.Integer.prototype.greaterThan = function(other) {
  return this.compare(other) > 0;
};
goog.math.Integer.prototype.greaterThanOrEqual = function(other) {
  return this.compare(other) >= 0;
};
goog.math.Integer.prototype.lessThan = function(other) {
  return this.compare(other) < 0;
};
goog.math.Integer.prototype.lessThanOrEqual = function(other) {
  return this.compare(other) <= 0;
};
goog.math.Integer.prototype.compare = function(other) {
  var diff = this.subtract(other);
  if (diff.isNegative()) {
    return -1;
  } else {
    if (diff.isZero()) {
      return 0;
    } else {
      return +1;
    }
  }
};
goog.math.Integer.prototype.shorten = function(numBits) {
  var arr_index = numBits - 1 >> 5;
  var bit_index = (numBits - 1) % 32;
  var bits = [];
  for (var i = 0; i < arr_index; i++) {
    bits[i] = this.getBits(i);
  }
  var sigBits = bit_index == 31 ? 4294967295 : (1 << bit_index + 1) - 1;
  var val = this.getBits(arr_index) & sigBits;
  if (val & 1 << bit_index) {
    val |= 4294967295 - sigBits;
    bits[arr_index] = val;
    return new goog.math.Integer(bits, -1);
  } else {
    bits[arr_index] = val;
    return new goog.math.Integer(bits, 0);
  }
};
goog.math.Integer.prototype.negate = function() {
  return this.not().add(goog.math.Integer.ONE);
};
goog.math.Integer.prototype.add = function(other) {
  var len = Math.max(this.bits_.length, other.bits_.length);
  var arr = [];
  var carry = 0;
  for (var i = 0; i <= len; i++) {
    var a1 = this.getBits(i) >>> 16;
    var a0 = this.getBits(i) & 65535;
    var b1 = other.getBits(i) >>> 16;
    var b0 = other.getBits(i) & 65535;
    var c0 = carry + a0 + b0;
    var c1 = (c0 >>> 16) + a1 + b1;
    carry = c1 >>> 16;
    c0 &= 65535;
    c1 &= 65535;
    arr[i] = c1 << 16 | c0;
  }
  return goog.math.Integer.fromBits(arr);
};
goog.math.Integer.prototype.subtract = function(other) {
  return this.add(other.negate());
};
goog.math.Integer.prototype.multiply = function(other) {
  if (this.isZero()) {
    return goog.math.Integer.ZERO;
  } else {
    if (other.isZero()) {
      return goog.math.Integer.ZERO;
    }
  }
  if (this.isNegative()) {
    if (other.isNegative()) {
      return this.negate().multiply(other.negate());
    } else {
      return this.negate().multiply(other).negate();
    }
  } else {
    if (other.isNegative()) {
      return this.multiply(other.negate()).negate();
    }
  }
  if (this.lessThan(goog.math.Integer.TWO_PWR_24_) && other.lessThan(goog.math.Integer.TWO_PWR_24_)) {
    return goog.math.Integer.fromNumber(this.toNumber() * other.toNumber());
  }
  var len = this.bits_.length + other.bits_.length;
  var arr = [];
  for (var i = 0; i < 2 * len; i++) {
    arr[i] = 0;
  }
  for (var i = 0; i < this.bits_.length; i++) {
    for (var j = 0; j < other.bits_.length; j++) {
      var a1 = this.getBits(i) >>> 16;
      var a0 = this.getBits(i) & 65535;
      var b1 = other.getBits(j) >>> 16;
      var b0 = other.getBits(j) & 65535;
      arr[2 * i + 2 * j] += a0 * b0;
      goog.math.Integer.carry16_(arr, 2 * i + 2 * j);
      arr[2 * i + 2 * j + 1] += a1 * b0;
      goog.math.Integer.carry16_(arr, 2 * i + 2 * j + 1);
      arr[2 * i + 2 * j + 1] += a0 * b1;
      goog.math.Integer.carry16_(arr, 2 * i + 2 * j + 1);
      arr[2 * i + 2 * j + 2] += a1 * b1;
      goog.math.Integer.carry16_(arr, 2 * i + 2 * j + 2);
    }
  }
  for (var i = 0; i < len; i++) {
    arr[i] = arr[2 * i + 1] << 16 | arr[2 * i];
  }
  for (var i = len; i < 2 * len; i++) {
    arr[i] = 0;
  }
  return new goog.math.Integer(arr, 0);
};
goog.math.Integer.carry16_ = function(bits, index) {
  while ((bits[index] & 65535) != bits[index]) {
    bits[index + 1] += bits[index] >>> 16;
    bits[index] &= 65535;
  }
};
goog.math.Integer.prototype.slowDivide_ = function(other) {
  if (this.isNegative() || other.isNegative()) {
    throw Error("slowDivide_ only works with positive integers.");
  }
  var twoPower = goog.math.Integer.ONE;
  var multiple = other;
  while (multiple.lessThanOrEqual(this)) {
    twoPower = twoPower.shiftLeft(1);
    multiple = multiple.shiftLeft(1);
  }
  var res = twoPower.shiftRight(1);
  var total = multiple.shiftRight(1);
  var total2;
  multiple = multiple.shiftRight(2);
  twoPower = twoPower.shiftRight(2);
  while (!multiple.isZero()) {
    total2 = total.add(multiple);
    if (total2.lessThanOrEqual(this)) {
      res = res.add(twoPower);
      total = total2;
    }
    multiple = multiple.shiftRight(1);
    twoPower = twoPower.shiftRight(1);
  }
  return res;
};
goog.math.Integer.prototype.divide = function(other) {
  if (other.isZero()) {
    throw Error("division by zero");
  } else {
    if (this.isZero()) {
      return goog.math.Integer.ZERO;
    }
  }
  if (this.isNegative()) {
    if (other.isNegative()) {
      return this.negate().divide(other.negate());
    } else {
      return this.negate().divide(other).negate();
    }
  } else {
    if (other.isNegative()) {
      return this.divide(other.negate()).negate();
    }
  }
  if (this.bits_.length > 30) {
    return this.slowDivide_(other);
  }
  var res = goog.math.Integer.ZERO;
  var rem = this;
  while (rem.greaterThanOrEqual(other)) {
    var approx = Math.max(1, Math.floor(rem.toNumber() / other.toNumber()));
    var log2 = Math.ceil(Math.log(approx) / Math.LN2);
    var delta = log2 <= 48 ? 1 : Math.pow(2, log2 - 48);
    var approxRes = goog.math.Integer.fromNumber(approx);
    var approxRem = approxRes.multiply(other);
    while (approxRem.isNegative() || approxRem.greaterThan(rem)) {
      approx -= delta;
      approxRes = goog.math.Integer.fromNumber(approx);
      approxRem = approxRes.multiply(other);
    }
    if (approxRes.isZero()) {
      approxRes = goog.math.Integer.ONE;
    }
    res = res.add(approxRes);
    rem = rem.subtract(approxRem);
  }
  return res;
};
goog.math.Integer.prototype.modulo = function(other) {
  return this.subtract(this.divide(other).multiply(other));
};
goog.math.Integer.prototype.not = function() {
  var len = this.bits_.length;
  var arr = [];
  for (var i = 0; i < len; i++) {
    arr[i] = ~this.bits_[i];
  }
  return new goog.math.Integer(arr, ~this.sign_);
};
goog.math.Integer.prototype.and = function(other) {
  var len = Math.max(this.bits_.length, other.bits_.length);
  var arr = [];
  for (var i = 0; i < len; i++) {
    arr[i] = this.getBits(i) & other.getBits(i);
  }
  return new goog.math.Integer(arr, this.sign_ & other.sign_);
};
goog.math.Integer.prototype.or = function(other) {
  var len = Math.max(this.bits_.length, other.bits_.length);
  var arr = [];
  for (var i = 0; i < len; i++) {
    arr[i] = this.getBits(i) | other.getBits(i);
  }
  return new goog.math.Integer(arr, this.sign_ | other.sign_);
};
goog.math.Integer.prototype.xor = function(other) {
  var len = Math.max(this.bits_.length, other.bits_.length);
  var arr = [];
  for (var i = 0; i < len; i++) {
    arr[i] = this.getBits(i) ^ other.getBits(i);
  }
  return new goog.math.Integer(arr, this.sign_ ^ other.sign_);
};
goog.math.Integer.prototype.shiftLeft = function(numBits) {
  var arr_delta = numBits >> 5;
  var bit_delta = numBits % 32;
  var len = this.bits_.length + arr_delta + (bit_delta > 0 ? 1 : 0);
  var arr = [];
  for (var i = 0; i < len; i++) {
    if (bit_delta > 0) {
      arr[i] = this.getBits(i - arr_delta) << bit_delta | this.getBits(i - arr_delta - 1) >>> 32 - bit_delta;
    } else {
      arr[i] = this.getBits(i - arr_delta);
    }
  }
  return new goog.math.Integer(arr, this.sign_);
};
goog.math.Integer.prototype.shiftRight = function(numBits) {
  var arr_delta = numBits >> 5;
  var bit_delta = numBits % 32;
  var len = this.bits_.length - arr_delta;
  var arr = [];
  for (var i = 0; i < len; i++) {
    if (bit_delta > 0) {
      arr[i] = this.getBits(i + arr_delta) >>> bit_delta | this.getBits(i + arr_delta + 1) << 32 - bit_delta;
    } else {
      arr[i] = this.getBits(i + arr_delta);
    }
  }
  return new goog.math.Integer(arr, this.sign_);
};
goog.provide("goog.string.StringBuffer");
goog.string.StringBuffer = function(opt_a1, var_args) {
  if (opt_a1 != null) {
    this.append.apply(this, arguments);
  }
};
goog.string.StringBuffer.prototype.buffer_ = "";
goog.string.StringBuffer.prototype.set = function(s) {
  this.buffer_ = "" + s;
};
goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
  this.buffer_ += String(a1);
  if (opt_a2 != null) {
    for (var i = 1; i < arguments.length; i++) {
      this.buffer_ += arguments[i];
    }
  }
  return this;
};
goog.string.StringBuffer.prototype.clear = function() {
  this.buffer_ = "";
};
goog.string.StringBuffer.prototype.getLength = function() {
  return this.buffer_.length;
};
goog.string.StringBuffer.prototype.toString = function() {
  return this.buffer_;
};
goog.provide("goog.debug.Error");
goog.debug.Error = function(opt_msg) {
  if (Error.captureStackTrace) {
    Error.captureStackTrace(this, goog.debug.Error);
  } else {
    var stack = (new Error).stack;
    if (stack) {
      this.stack = stack;
    }
  }
  if (opt_msg) {
    this.message = String(opt_msg);
  }
  this.reportErrorToServer = true;
};
goog.inherits(goog.debug.Error, Error);
goog.debug.Error.prototype.name = "CustomError";
goog.provide("goog.dom.NodeType");
goog.dom.NodeType = {ELEMENT:1, ATTRIBUTE:2, TEXT:3, CDATA_SECTION:4, ENTITY_REFERENCE:5, ENTITY:6, PROCESSING_INSTRUCTION:7, COMMENT:8, DOCUMENT:9, DOCUMENT_TYPE:10, DOCUMENT_FRAGMENT:11, NOTATION:12};
goog.provide("goog.asserts");
goog.provide("goog.asserts.AssertionError");
goog.require("goog.debug.Error");
goog.require("goog.dom.NodeType");
goog.require("goog.string");
goog.define("goog.asserts.ENABLE_ASSERTS", goog.DEBUG);
goog.asserts.AssertionError = function(messagePattern, messageArgs) {
  messageArgs.unshift(messagePattern);
  goog.debug.Error.call(this, goog.string.subs.apply(null, messageArgs));
  messageArgs.shift();
  this.messagePattern = messagePattern;
};
goog.inherits(goog.asserts.AssertionError, goog.debug.Error);
goog.asserts.AssertionError.prototype.name = "AssertionError";
goog.asserts.DEFAULT_ERROR_HANDLER = function(e) {
  throw e;
};
goog.asserts.errorHandler_ = goog.asserts.DEFAULT_ERROR_HANDLER;
goog.asserts.doAssertFailure_ = function(defaultMessage, defaultArgs, givenMessage, givenArgs) {
  var message = "Assertion failed";
  if (givenMessage) {
    message += ": " + givenMessage;
    var args = givenArgs;
  } else {
    if (defaultMessage) {
      message += ": " + defaultMessage;
      args = defaultArgs;
    }
  }
  var e = new goog.asserts.AssertionError("" + message, args || []);
  goog.asserts.errorHandler_(e);
};
goog.asserts.setErrorHandler = function(errorHandler) {
  if (goog.asserts.ENABLE_ASSERTS) {
    goog.asserts.errorHandler_ = errorHandler;
  }
};
goog.asserts.assert = function(condition, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !condition) {
    goog.asserts.doAssertFailure_("", null, opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return condition;
};
goog.asserts.fail = function(opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS) {
    goog.asserts.errorHandler_(new goog.asserts.AssertionError("Failure" + (opt_message ? ": " + opt_message : ""), Array.prototype.slice.call(arguments, 1)));
  }
};
goog.asserts.assertNumber = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isNumber(value)) {
    goog.asserts.doAssertFailure_("Expected number but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertString = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isString(value)) {
    goog.asserts.doAssertFailure_("Expected string but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertFunction = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isFunction(value)) {
    goog.asserts.doAssertFailure_("Expected function but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertObject = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isObject(value)) {
    goog.asserts.doAssertFailure_("Expected object but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertArray = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isArray(value)) {
    goog.asserts.doAssertFailure_("Expected array but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertBoolean = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isBoolean(value)) {
    goog.asserts.doAssertFailure_("Expected boolean but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertElement = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && (!goog.isObject(value) || value.nodeType != goog.dom.NodeType.ELEMENT)) {
    goog.asserts.doAssertFailure_("Expected Element but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertInstanceof = function(value, type, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !(value instanceof type)) {
    goog.asserts.doAssertFailure_("Expected instanceof %s but got %s.", [goog.asserts.getType_(type), goog.asserts.getType_(value)], opt_message, Array.prototype.slice.call(arguments, 3));
  }
  return value;
};
goog.asserts.assertObjectPrototypeIsIntact = function() {
  for (var key in Object.prototype) {
    goog.asserts.fail(key + " should not be enumerable in Object.prototype.");
  }
};
goog.asserts.getType_ = function(value) {
  if (value instanceof Function) {
    return value.displayName || value.name || "unknown type name";
  } else {
    if (value instanceof Object) {
      return value.constructor.displayName || value.constructor.name || Object.prototype.toString.call(value);
    } else {
      return value === null ? "null" : typeof value;
    }
  }
};
goog.provide("goog.array");
goog.require("goog.asserts");
goog.define("goog.NATIVE_ARRAY_PROTOTYPES", goog.TRUSTED_SITE);
goog.define("goog.array.ASSUME_NATIVE_FUNCTIONS", false);
goog.array.peek = function(array) {
  return array[array.length - 1];
};
goog.array.last = goog.array.peek;
goog.array.indexOf = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.indexOf) ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  return Array.prototype.indexOf.call(arr, obj, opt_fromIndex);
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? 0 : opt_fromIndex < 0 ? Math.max(0, arr.length + opt_fromIndex) : opt_fromIndex;
  if (goog.isString(arr)) {
    if (!goog.isString(obj) || obj.length != 1) {
      return -1;
    }
    return arr.indexOf(obj, fromIndex);
  }
  for (var i = fromIndex; i < arr.length; i++) {
    if (i in arr && arr[i] === obj) {
      return i;
    }
  }
  return -1;
};
goog.array.lastIndexOf = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.lastIndexOf) ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  return Array.prototype.lastIndexOf.call(arr, obj, fromIndex);
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  if (fromIndex < 0) {
    fromIndex = Math.max(0, arr.length + fromIndex);
  }
  if (goog.isString(arr)) {
    if (!goog.isString(obj) || obj.length != 1) {
      return -1;
    }
    return arr.lastIndexOf(obj, fromIndex);
  }
  for (var i = fromIndex; i >= 0; i--) {
    if (i in arr && arr[i] === obj) {
      return i;
    }
  }
  return -1;
};
goog.array.forEach = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.forEach) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  Array.prototype.forEach.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0; i < l; i++) {
    if (i in arr2) {
      f.call((opt_obj), arr2[i], i, arr);
    }
  }
};
goog.array.forEachRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = l - 1; i >= 0; --i) {
    if (i in arr2) {
      f.call((opt_obj), arr2[i], i, arr);
    }
  }
};
goog.array.filter = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.filter) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return Array.prototype.filter.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = [];
  var resLength = 0;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0; i < l; i++) {
    if (i in arr2) {
      var val = arr2[i];
      if (f.call((opt_obj), val, i, arr)) {
        res[resLength++] = val;
      }
    }
  }
  return res;
};
goog.array.map = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.map) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return Array.prototype.map.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = new Array(l);
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0; i < l; i++) {
    if (i in arr2) {
      res[i] = f.call((opt_obj), arr2[i], i, arr);
    }
  }
  return res;
};
goog.array.reduce = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.reduce) ? function(arr, f, val, opt_obj) {
  goog.asserts.assert(arr.length != null);
  if (opt_obj) {
    f = goog.bind(f, opt_obj);
  }
  return Array.prototype.reduce.call(arr, f, val);
} : function(arr, f, val, opt_obj) {
  var rval = val;
  goog.array.forEach(arr, function(val, index) {
    rval = f.call((opt_obj), rval, val, index, arr);
  });
  return rval;
};
goog.array.reduceRight = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.reduceRight) ? function(arr, f, val, opt_obj) {
  goog.asserts.assert(arr.length != null);
  goog.asserts.assert(f != null);
  if (opt_obj) {
    f = goog.bind(f, opt_obj);
  }
  return Array.prototype.reduceRight.call(arr, f, val);
} : function(arr, f, val, opt_obj) {
  var rval = val;
  goog.array.forEachRight(arr, function(val, index) {
    rval = f.call((opt_obj), rval, val, index, arr);
  });
  return rval;
};
goog.array.some = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.some) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return Array.prototype.some.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0; i < l; i++) {
    if (i in arr2 && f.call((opt_obj), arr2[i], i, arr)) {
      return true;
    }
  }
  return false;
};
goog.array.every = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.every) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return Array.prototype.every.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0; i < l; i++) {
    if (i in arr2 && !f.call((opt_obj), arr2[i], i, arr)) {
      return false;
    }
  }
  return true;
};
goog.array.count = function(arr, f, opt_obj) {
  var count = 0;
  goog.array.forEach(arr, function(element, index, arr) {
    if (f.call((opt_obj), element, index, arr)) {
      ++count;
    }
  }, opt_obj);
  return count;
};
goog.array.find = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i];
};
goog.array.findIndex = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0; i < l; i++) {
    if (i in arr2 && f.call((opt_obj), arr2[i], i, arr)) {
      return i;
    }
  }
  return -1;
};
goog.array.findRight = function(arr, f, opt_obj) {
  var i = goog.array.findIndexRight(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i];
};
goog.array.findIndexRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = l - 1; i >= 0; i--) {
    if (i in arr2 && f.call((opt_obj), arr2[i], i, arr)) {
      return i;
    }
  }
  return -1;
};
goog.array.contains = function(arr, obj) {
  return goog.array.indexOf(arr, obj) >= 0;
};
goog.array.isEmpty = function(arr) {
  return arr.length == 0;
};
goog.array.clear = function(arr) {
  if (!goog.isArray(arr)) {
    for (var i = arr.length - 1; i >= 0; i--) {
      delete arr[i];
    }
  }
  arr.length = 0;
};
goog.array.insert = function(arr, obj) {
  if (!goog.array.contains(arr, obj)) {
    arr.push(obj);
  }
};
goog.array.insertAt = function(arr, obj, opt_i) {
  goog.array.splice(arr, opt_i, 0, obj);
};
goog.array.insertArrayAt = function(arr, elementsToAdd, opt_i) {
  goog.partial(goog.array.splice, arr, opt_i, 0).apply(null, elementsToAdd);
};
goog.array.insertBefore = function(arr, obj, opt_obj2) {
  var i;
  if (arguments.length == 2 || (i = goog.array.indexOf(arr, opt_obj2)) < 0) {
    arr.push(obj);
  } else {
    goog.array.insertAt(arr, obj, i);
  }
};
goog.array.remove = function(arr, obj) {
  var i = goog.array.indexOf(arr, obj);
  var rv;
  if (rv = i >= 0) {
    goog.array.removeAt(arr, i);
  }
  return rv;
};
goog.array.removeLast = function(arr, obj) {
  var i = goog.array.lastIndexOf(arr, obj);
  if (i >= 0) {
    goog.array.removeAt(arr, i);
    return true;
  }
  return false;
};
goog.array.removeAt = function(arr, i) {
  goog.asserts.assert(arr.length != null);
  return Array.prototype.splice.call(arr, i, 1).length == 1;
};
goog.array.removeIf = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  if (i >= 0) {
    goog.array.removeAt(arr, i);
    return true;
  }
  return false;
};
goog.array.removeAllIf = function(arr, f, opt_obj) {
  var removedCount = 0;
  goog.array.forEachRight(arr, function(val, index) {
    if (f.call((opt_obj), val, index, arr)) {
      if (goog.array.removeAt(arr, index)) {
        removedCount++;
      }
    }
  });
  return removedCount;
};
goog.array.concat = function(var_args) {
  return Array.prototype.concat.apply(Array.prototype, arguments);
};
goog.array.join = function(var_args) {
  return Array.prototype.concat.apply(Array.prototype, arguments);
};
goog.array.toArray = function(object) {
  var length = object.length;
  if (length > 0) {
    var rv = new Array(length);
    for (var i = 0; i < length; i++) {
      rv[i] = object[i];
    }
    return rv;
  }
  return [];
};
goog.array.clone = goog.array.toArray;
goog.array.extend = function(arr1, var_args) {
  for (var i = 1; i < arguments.length; i++) {
    var arr2 = arguments[i];
    if (goog.isArrayLike(arr2)) {
      var len1 = arr1.length || 0;
      var len2 = arr2.length || 0;
      arr1.length = len1 + len2;
      for (var j = 0; j < len2; j++) {
        arr1[len1 + j] = arr2[j];
      }
    } else {
      arr1.push(arr2);
    }
  }
};
goog.array.splice = function(arr, index, howMany, var_args) {
  goog.asserts.assert(arr.length != null);
  return Array.prototype.splice.apply(arr, goog.array.slice(arguments, 1));
};
goog.array.slice = function(arr, start, opt_end) {
  goog.asserts.assert(arr.length != null);
  if (arguments.length <= 2) {
    return Array.prototype.slice.call(arr, start);
  } else {
    return Array.prototype.slice.call(arr, start, opt_end);
  }
};
goog.array.removeDuplicates = function(arr, opt_rv, opt_hashFn) {
  var returnArray = opt_rv || arr;
  var defaultHashFn = function(item) {
    return goog.isObject(item) ? "o" + goog.getUid(item) : (typeof item).charAt(0) + item;
  };
  var hashFn = opt_hashFn || defaultHashFn;
  var seen = {}, cursorInsert = 0, cursorRead = 0;
  while (cursorRead < arr.length) {
    var current = arr[cursorRead++];
    var key = hashFn(current);
    if (!Object.prototype.hasOwnProperty.call(seen, key)) {
      seen[key] = true;
      returnArray[cursorInsert++] = current;
    }
  }
  returnArray.length = cursorInsert;
};
goog.array.binarySearch = function(arr, target, opt_compareFn) {
  return goog.array.binarySearch_(arr, opt_compareFn || goog.array.defaultCompare, false, target);
};
goog.array.binarySelect = function(arr, evaluator, opt_obj) {
  return goog.array.binarySearch_(arr, evaluator, true, undefined, opt_obj);
};
goog.array.binarySearch_ = function(arr, compareFn, isEvaluator, opt_target, opt_selfObj) {
  var left = 0;
  var right = arr.length;
  var found;
  while (left < right) {
    var middle = left + right >> 1;
    var compareResult;
    if (isEvaluator) {
      compareResult = compareFn.call(opt_selfObj, arr[middle], middle, arr);
    } else {
      compareResult = (compareFn)(opt_target, arr[middle]);
    }
    if (compareResult > 0) {
      left = middle + 1;
    } else {
      right = middle;
      found = !compareResult;
    }
  }
  return found ? left : ~left;
};
goog.array.sort = function(arr, opt_compareFn) {
  arr.sort(opt_compareFn || goog.array.defaultCompare);
};
goog.array.stableSort = function(arr, opt_compareFn) {
  var compArr = new Array(arr.length);
  for (var i = 0; i < arr.length; i++) {
    compArr[i] = {index:i, value:arr[i]};
  }
  var valueCompareFn = opt_compareFn || goog.array.defaultCompare;
  function stableCompareFn(obj1, obj2) {
    return valueCompareFn(obj1.value, obj2.value) || obj1.index - obj2.index;
  }
  goog.array.sort(compArr, stableCompareFn);
  for (var i = 0; i < arr.length; i++) {
    arr[i] = compArr[i].value;
  }
};
goog.array.sortByKey = function(arr, keyFn, opt_compareFn) {
  var keyCompareFn = opt_compareFn || goog.array.defaultCompare;
  goog.array.sort(arr, function(a, b) {
    return keyCompareFn(keyFn(a), keyFn(b));
  });
};
goog.array.sortObjectsByKey = function(arr, key, opt_compareFn) {
  goog.array.sortByKey(arr, function(obj) {
    return obj[key];
  }, opt_compareFn);
};
goog.array.isSorted = function(arr, opt_compareFn, opt_strict) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  for (var i = 1; i < arr.length; i++) {
    var compareResult = compare(arr[i - 1], arr[i]);
    if (compareResult > 0 || compareResult == 0 && opt_strict) {
      return false;
    }
  }
  return true;
};
goog.array.equals = function(arr1, arr2, opt_equalsFn) {
  if (!goog.isArrayLike(arr1) || !goog.isArrayLike(arr2) || arr1.length != arr2.length) {
    return false;
  }
  var l = arr1.length;
  var equalsFn = opt_equalsFn || goog.array.defaultCompareEquality;
  for (var i = 0; i < l; i++) {
    if (!equalsFn(arr1[i], arr2[i])) {
      return false;
    }
  }
  return true;
};
goog.array.compare3 = function(arr1, arr2, opt_compareFn) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  var l = Math.min(arr1.length, arr2.length);
  for (var i = 0; i < l; i++) {
    var result = compare(arr1[i], arr2[i]);
    if (result != 0) {
      return result;
    }
  }
  return goog.array.defaultCompare(arr1.length, arr2.length);
};
goog.array.defaultCompare = function(a, b) {
  return a > b ? 1 : a < b ? -1 : 0;
};
goog.array.inverseDefaultCompare = function(a, b) {
  return -goog.array.defaultCompare(a, b);
};
goog.array.defaultCompareEquality = function(a, b) {
  return a === b;
};
goog.array.binaryInsert = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  if (index < 0) {
    goog.array.insertAt(array, value, -(index + 1));
    return true;
  }
  return false;
};
goog.array.binaryRemove = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  return index >= 0 ? goog.array.removeAt(array, index) : false;
};
goog.array.bucket = function(array, sorter, opt_obj) {
  var buckets = {};
  for (var i = 0; i < array.length; i++) {
    var value = array[i];
    var key = sorter.call((opt_obj), value, i, array);
    if (goog.isDef(key)) {
      var bucket = buckets[key] || (buckets[key] = []);
      bucket.push(value);
    }
  }
  return buckets;
};
goog.array.toObject = function(arr, keyFunc, opt_obj) {
  var ret = {};
  goog.array.forEach(arr, function(element, index) {
    ret[keyFunc.call((opt_obj), element, index, arr)] = element;
  });
  return ret;
};
goog.array.range = function(startOrEnd, opt_end, opt_step) {
  var array = [];
  var start = 0;
  var end = startOrEnd;
  var step = opt_step || 1;
  if (opt_end !== undefined) {
    start = startOrEnd;
    end = opt_end;
  }
  if (step * (end - start) < 0) {
    return [];
  }
  if (step > 0) {
    for (var i = start; i < end; i += step) {
      array.push(i);
    }
  } else {
    for (var i = start; i > end; i += step) {
      array.push(i);
    }
  }
  return array;
};
goog.array.repeat = function(value, n) {
  var array = [];
  for (var i = 0; i < n; i++) {
    array[i] = value;
  }
  return array;
};
goog.array.flatten = function(var_args) {
  var CHUNK_SIZE = 8192;
  var result = [];
  for (var i = 0; i < arguments.length; i++) {
    var element = arguments[i];
    if (goog.isArray(element)) {
      for (var c = 0; c < element.length; c += CHUNK_SIZE) {
        var chunk = goog.array.slice(element, c, c + CHUNK_SIZE);
        var recurseResult = goog.array.flatten.apply(null, chunk);
        for (var r = 0; r < recurseResult.length; r++) {
          result.push(recurseResult[r]);
        }
      }
    } else {
      result.push(element);
    }
  }
  return result;
};
goog.array.rotate = function(array, n) {
  goog.asserts.assert(array.length != null);
  if (array.length) {
    n %= array.length;
    if (n > 0) {
      Array.prototype.unshift.apply(array, array.splice(-n, n));
    } else {
      if (n < 0) {
        Array.prototype.push.apply(array, array.splice(0, -n));
      }
    }
  }
  return array;
};
goog.array.moveItem = function(arr, fromIndex, toIndex) {
  goog.asserts.assert(fromIndex >= 0 && fromIndex < arr.length);
  goog.asserts.assert(toIndex >= 0 && toIndex < arr.length);
  var removedItems = Array.prototype.splice.call(arr, fromIndex, 1);
  Array.prototype.splice.call(arr, toIndex, 0, removedItems[0]);
};
goog.array.zip = function(var_args) {
  if (!arguments.length) {
    return [];
  }
  var result = [];
  var minLen = arguments[0].length;
  for (var i = 1; i < arguments.length; i++) {
    if (arguments[i].length < minLen) {
      minLen = arguments[i].length;
    }
  }
  for (var i = 0; i < minLen; i++) {
    var value = [];
    for (var j = 0; j < arguments.length; j++) {
      value.push(arguments[j][i]);
    }
    result.push(value);
  }
  return result;
};
goog.array.shuffle = function(arr, opt_randFn) {
  var randFn = opt_randFn || Math.random;
  for (var i = arr.length - 1; i > 0; i--) {
    var j = Math.floor(randFn() * (i + 1));
    var tmp = arr[i];
    arr[i] = arr[j];
    arr[j] = tmp;
  }
};
goog.array.copyByIndex = function(arr, index_arr) {
  var result = [];
  goog.array.forEach(index_arr, function(index) {
    result.push(arr[index]);
  });
  return result;
};
goog.array.concatMap = function(arr, f, opt_obj) {
  return goog.array.concat.apply([], goog.array.map(arr, f, opt_obj));
};
goog.provide("goog.reflect");
goog.reflect.object = function(type, object) {
  return object;
};
goog.reflect.objectProperty = function(prop, object) {
  return prop;
};
goog.reflect.sinkValue = function(x) {
  goog.reflect.sinkValue[" "](x);
  return x;
};
goog.reflect.sinkValue[" "] = goog.nullFunction;
goog.reflect.canAccessProperty = function(obj, prop) {
  try {
    goog.reflect.sinkValue(obj[prop]);
    return true;
  } catch (e) {
  }
  return false;
};
goog.reflect.cache = function(cacheObj, key, valueFn, opt_keyFn) {
  var storedKey = opt_keyFn ? opt_keyFn(key) : key;
  if (Object.prototype.hasOwnProperty.call(cacheObj, storedKey)) {
    return cacheObj[storedKey];
  }
  return cacheObj[storedKey] = valueFn(key);
};
goog.provide("goog.math.Long");
goog.require("goog.reflect");
goog.math.Long = function(low, high) {
  this.low_ = low | 0;
  this.high_ = high | 0;
};
goog.math.Long.IntCache_ = {};
goog.math.Long.valueCache_ = {};
goog.math.Long.fromInt = function(value) {
  if (-128 <= value && value < 128) {
    return goog.reflect.cache(goog.math.Long.IntCache_, value, function(val) {
      return new goog.math.Long(val | 0, val < 0 ? -1 : 0);
    });
  } else {
    return new goog.math.Long(value | 0, value < 0 ? -1 : 0);
  }
};
goog.math.Long.fromNumber = function(value) {
  if (isNaN(value)) {
    return goog.math.Long.getZero();
  } else {
    if (value <= -goog.math.Long.TWO_PWR_63_DBL_) {
      return goog.math.Long.getMinValue();
    } else {
      if (value + 1 >= goog.math.Long.TWO_PWR_63_DBL_) {
        return goog.math.Long.getMaxValue();
      } else {
        if (value < 0) {
          return goog.math.Long.fromNumber(-value).negate();
        } else {
          return new goog.math.Long(value % goog.math.Long.TWO_PWR_32_DBL_ | 0, value / goog.math.Long.TWO_PWR_32_DBL_ | 0);
        }
      }
    }
  }
};
goog.math.Long.fromBits = function(lowBits, highBits) {
  return new goog.math.Long(lowBits, highBits);
};
goog.math.Long.fromString = function(str, opt_radix) {
  if (str.length == 0) {
    throw Error("number format error: empty string");
  }
  var radix = opt_radix || 10;
  if (radix < 2 || 36 < radix) {
    throw Error("radix out of range: " + radix);
  }
  if (str.charAt(0) == "-") {
    return goog.math.Long.fromString(str.substring(1), radix).negate();
  } else {
    if (str.indexOf("-") >= 0) {
      throw Error('number format error: interior "-" character: ' + str);
    }
  }
  var radixToPower = goog.math.Long.fromNumber(Math.pow(radix, 8));
  var result = goog.math.Long.getZero();
  for (var i = 0; i < str.length; i += 8) {
    var size = Math.min(8, str.length - i);
    var value = parseInt(str.substring(i, i + size), radix);
    if (size < 8) {
      var power = goog.math.Long.fromNumber(Math.pow(radix, size));
      result = result.multiply(power).add(goog.math.Long.fromNumber(value));
    } else {
      result = result.multiply(radixToPower);
      result = result.add(goog.math.Long.fromNumber(value));
    }
  }
  return result;
};
goog.math.Long.TWO_PWR_16_DBL_ = 1 << 16;
goog.math.Long.TWO_PWR_32_DBL_ = goog.math.Long.TWO_PWR_16_DBL_ * goog.math.Long.TWO_PWR_16_DBL_;
goog.math.Long.TWO_PWR_64_DBL_ = goog.math.Long.TWO_PWR_32_DBL_ * goog.math.Long.TWO_PWR_32_DBL_;
goog.math.Long.TWO_PWR_63_DBL_ = goog.math.Long.TWO_PWR_64_DBL_ / 2;
goog.math.Long.getZero = function() {
  return goog.reflect.cache(goog.math.Long.valueCache_, goog.math.Long.ValueCacheId_.ZERO, function() {
    return goog.math.Long.fromInt(0);
  });
};
goog.math.Long.getOne = function() {
  return goog.reflect.cache(goog.math.Long.valueCache_, goog.math.Long.ValueCacheId_.ONE, function() {
    return goog.math.Long.fromInt(1);
  });
};
goog.math.Long.getNegOne = function() {
  return goog.reflect.cache(goog.math.Long.valueCache_, goog.math.Long.ValueCacheId_.NEG_ONE, function() {
    return goog.math.Long.fromInt(-1);
  });
};
goog.math.Long.getMaxValue = function() {
  return goog.reflect.cache(goog.math.Long.valueCache_, goog.math.Long.ValueCacheId_.MAX_VALUE, function() {
    return goog.math.Long.fromBits(4294967295 | 0, 2147483647 | 0);
  });
};
goog.math.Long.getMinValue = function() {
  return goog.reflect.cache(goog.math.Long.valueCache_, goog.math.Long.ValueCacheId_.MIN_VALUE, function() {
    return goog.math.Long.fromBits(0, 2147483648 | 0);
  });
};
goog.math.Long.getTwoPwr24 = function() {
  return goog.reflect.cache(goog.math.Long.valueCache_, goog.math.Long.ValueCacheId_.TWO_PWR_24, function() {
    return goog.math.Long.fromInt(1 << 24);
  });
};
goog.math.Long.prototype.toInt = function() {
  return this.low_;
};
goog.math.Long.prototype.toNumber = function() {
  return this.high_ * goog.math.Long.TWO_PWR_32_DBL_ + this.getLowBitsUnsigned();
};
goog.math.Long.prototype.toString = function(opt_radix) {
  var radix = opt_radix || 10;
  if (radix < 2 || 36 < radix) {
    throw Error("radix out of range: " + radix);
  }
  if (this.isZero()) {
    return "0";
  }
  if (this.isNegative()) {
    if (this.equals(goog.math.Long.getMinValue())) {
      var radixLong = goog.math.Long.fromNumber(radix);
      var div = this.div(radixLong);
      var rem = div.multiply(radixLong).subtract(this);
      return div.toString(radix) + rem.toInt().toString(radix);
    } else {
      return "-" + this.negate().toString(radix);
    }
  }
  var radixToPower = goog.math.Long.fromNumber(Math.pow(radix, 6));
  var rem = this;
  var result = "";
  while (true) {
    var remDiv = rem.div(radixToPower);
    var intval = rem.subtract(remDiv.multiply(radixToPower)).toInt() >>> 0;
    var digits = intval.toString(radix);
    rem = remDiv;
    if (rem.isZero()) {
      return digits + result;
    } else {
      while (digits.length < 6) {
        digits = "0" + digits;
      }
      result = "" + digits + result;
    }
  }
};
goog.math.Long.prototype.getHighBits = function() {
  return this.high_;
};
goog.math.Long.prototype.getLowBits = function() {
  return this.low_;
};
goog.math.Long.prototype.getLowBitsUnsigned = function() {
  return this.low_ >= 0 ? this.low_ : goog.math.Long.TWO_PWR_32_DBL_ + this.low_;
};
goog.math.Long.prototype.getNumBitsAbs = function() {
  if (this.isNegative()) {
    if (this.equals(goog.math.Long.getMinValue())) {
      return 64;
    } else {
      return this.negate().getNumBitsAbs();
    }
  } else {
    var val = this.high_ != 0 ? this.high_ : this.low_;
    for (var bit = 31; bit > 0; bit--) {
      if ((val & 1 << bit) != 0) {
        break;
      }
    }
    return this.high_ != 0 ? bit + 33 : bit + 1;
  }
};
goog.math.Long.prototype.isZero = function() {
  return this.high_ == 0 && this.low_ == 0;
};
goog.math.Long.prototype.isNegative = function() {
  return this.high_ < 0;
};
goog.math.Long.prototype.isOdd = function() {
  return (this.low_ & 1) == 1;
};
goog.math.Long.prototype.equals = function(other) {
  return this.high_ == other.high_ && this.low_ == other.low_;
};
goog.math.Long.prototype.notEquals = function(other) {
  return this.high_ != other.high_ || this.low_ != other.low_;
};
goog.math.Long.prototype.lessThan = function(other) {
  return this.compare(other) < 0;
};
goog.math.Long.prototype.lessThanOrEqual = function(other) {
  return this.compare(other) <= 0;
};
goog.math.Long.prototype.greaterThan = function(other) {
  return this.compare(other) > 0;
};
goog.math.Long.prototype.greaterThanOrEqual = function(other) {
  return this.compare(other) >= 0;
};
goog.math.Long.prototype.compare = function(other) {
  if (this.equals(other)) {
    return 0;
  }
  var thisNeg = this.isNegative();
  var otherNeg = other.isNegative();
  if (thisNeg && !otherNeg) {
    return -1;
  }
  if (!thisNeg && otherNeg) {
    return 1;
  }
  if (this.subtract(other).isNegative()) {
    return -1;
  } else {
    return 1;
  }
};
goog.math.Long.prototype.negate = function() {
  if (this.equals(goog.math.Long.getMinValue())) {
    return goog.math.Long.getMinValue();
  } else {
    return this.not().add(goog.math.Long.getOne());
  }
};
goog.math.Long.prototype.add = function(other) {
  var a48 = this.high_ >>> 16;
  var a32 = this.high_ & 65535;
  var a16 = this.low_ >>> 16;
  var a00 = this.low_ & 65535;
  var b48 = other.high_ >>> 16;
  var b32 = other.high_ & 65535;
  var b16 = other.low_ >>> 16;
  var b00 = other.low_ & 65535;
  var c48 = 0, c32 = 0, c16 = 0, c00 = 0;
  c00 += a00 + b00;
  c16 += c00 >>> 16;
  c00 &= 65535;
  c16 += a16 + b16;
  c32 += c16 >>> 16;
  c16 &= 65535;
  c32 += a32 + b32;
  c48 += c32 >>> 16;
  c32 &= 65535;
  c48 += a48 + b48;
  c48 &= 65535;
  return goog.math.Long.fromBits(c16 << 16 | c00, c48 << 16 | c32);
};
goog.math.Long.prototype.subtract = function(other) {
  return this.add(other.negate());
};
goog.math.Long.prototype.multiply = function(other) {
  if (this.isZero()) {
    return goog.math.Long.getZero();
  } else {
    if (other.isZero()) {
      return goog.math.Long.getZero();
    }
  }
  if (this.equals(goog.math.Long.getMinValue())) {
    return other.isOdd() ? goog.math.Long.getMinValue() : goog.math.Long.getZero();
  } else {
    if (other.equals(goog.math.Long.getMinValue())) {
      return this.isOdd() ? goog.math.Long.getMinValue() : goog.math.Long.getZero();
    }
  }
  if (this.isNegative()) {
    if (other.isNegative()) {
      return this.negate().multiply(other.negate());
    } else {
      return this.negate().multiply(other).negate();
    }
  } else {
    if (other.isNegative()) {
      return this.multiply(other.negate()).negate();
    }
  }
  if (this.lessThan(goog.math.Long.getTwoPwr24()) && other.lessThan(goog.math.Long.getTwoPwr24())) {
    return goog.math.Long.fromNumber(this.toNumber() * other.toNumber());
  }
  var a48 = this.high_ >>> 16;
  var a32 = this.high_ & 65535;
  var a16 = this.low_ >>> 16;
  var a00 = this.low_ & 65535;
  var b48 = other.high_ >>> 16;
  var b32 = other.high_ & 65535;
  var b16 = other.low_ >>> 16;
  var b00 = other.low_ & 65535;
  var c48 = 0, c32 = 0, c16 = 0, c00 = 0;
  c00 += a00 * b00;
  c16 += c00 >>> 16;
  c00 &= 65535;
  c16 += a16 * b00;
  c32 += c16 >>> 16;
  c16 &= 65535;
  c16 += a00 * b16;
  c32 += c16 >>> 16;
  c16 &= 65535;
  c32 += a32 * b00;
  c48 += c32 >>> 16;
  c32 &= 65535;
  c32 += a16 * b16;
  c48 += c32 >>> 16;
  c32 &= 65535;
  c32 += a00 * b32;
  c48 += c32 >>> 16;
  c32 &= 65535;
  c48 += a48 * b00 + a32 * b16 + a16 * b32 + a00 * b48;
  c48 &= 65535;
  return goog.math.Long.fromBits(c16 << 16 | c00, c48 << 16 | c32);
};
goog.math.Long.prototype.div = function(other) {
  if (other.isZero()) {
    throw Error("division by zero");
  } else {
    if (this.isZero()) {
      return goog.math.Long.getZero();
    }
  }
  if (this.equals(goog.math.Long.getMinValue())) {
    if (other.equals(goog.math.Long.getOne()) || other.equals(goog.math.Long.getNegOne())) {
      return goog.math.Long.getMinValue();
    } else {
      if (other.equals(goog.math.Long.getMinValue())) {
        return goog.math.Long.getOne();
      } else {
        var halfThis = this.shiftRight(1);
        var approx = halfThis.div(other).shiftLeft(1);
        if (approx.equals(goog.math.Long.getZero())) {
          return other.isNegative() ? goog.math.Long.getOne() : goog.math.Long.getNegOne();
        } else {
          var rem = this.subtract(other.multiply(approx));
          var result = approx.add(rem.div(other));
          return result;
        }
      }
    }
  } else {
    if (other.equals(goog.math.Long.getMinValue())) {
      return goog.math.Long.getZero();
    }
  }
  if (this.isNegative()) {
    if (other.isNegative()) {
      return this.negate().div(other.negate());
    } else {
      return this.negate().div(other).negate();
    }
  } else {
    if (other.isNegative()) {
      return this.div(other.negate()).negate();
    }
  }
  var res = goog.math.Long.getZero();
  var rem = this;
  while (rem.greaterThanOrEqual(other)) {
    var approx = Math.max(1, Math.floor(rem.toNumber() / other.toNumber()));
    var log2 = Math.ceil(Math.log(approx) / Math.LN2);
    var delta = log2 <= 48 ? 1 : Math.pow(2, log2 - 48);
    var approxRes = goog.math.Long.fromNumber(approx);
    var approxRem = approxRes.multiply(other);
    while (approxRem.isNegative() || approxRem.greaterThan(rem)) {
      approx -= delta;
      approxRes = goog.math.Long.fromNumber(approx);
      approxRem = approxRes.multiply(other);
    }
    if (approxRes.isZero()) {
      approxRes = goog.math.Long.getOne();
    }
    res = res.add(approxRes);
    rem = rem.subtract(approxRem);
  }
  return res;
};
goog.math.Long.prototype.modulo = function(other) {
  return this.subtract(this.div(other).multiply(other));
};
goog.math.Long.prototype.not = function() {
  return goog.math.Long.fromBits(~this.low_, ~this.high_);
};
goog.math.Long.prototype.and = function(other) {
  return goog.math.Long.fromBits(this.low_ & other.low_, this.high_ & other.high_);
};
goog.math.Long.prototype.or = function(other) {
  return goog.math.Long.fromBits(this.low_ | other.low_, this.high_ | other.high_);
};
goog.math.Long.prototype.xor = function(other) {
  return goog.math.Long.fromBits(this.low_ ^ other.low_, this.high_ ^ other.high_);
};
goog.math.Long.prototype.shiftLeft = function(numBits) {
  numBits &= 63;
  if (numBits == 0) {
    return this;
  } else {
    var low = this.low_;
    if (numBits < 32) {
      var high = this.high_;
      return goog.math.Long.fromBits(low << numBits, high << numBits | low >>> 32 - numBits);
    } else {
      return goog.math.Long.fromBits(0, low << numBits - 32);
    }
  }
};
goog.math.Long.prototype.shiftRight = function(numBits) {
  numBits &= 63;
  if (numBits == 0) {
    return this;
  } else {
    var high = this.high_;
    if (numBits < 32) {
      var low = this.low_;
      return goog.math.Long.fromBits(low >>> numBits | high << 32 - numBits, high >> numBits);
    } else {
      return goog.math.Long.fromBits(high >> numBits - 32, high >= 0 ? 0 : -1);
    }
  }
};
goog.math.Long.prototype.shiftRightUnsigned = function(numBits) {
  numBits &= 63;
  if (numBits == 0) {
    return this;
  } else {
    var high = this.high_;
    if (numBits < 32) {
      var low = this.low_;
      return goog.math.Long.fromBits(low >>> numBits | high << 32 - numBits, high >>> numBits);
    } else {
      if (numBits == 32) {
        return goog.math.Long.fromBits(high, 0);
      } else {
        return goog.math.Long.fromBits(high >>> numBits - 32, 0);
      }
    }
  }
};
goog.math.Long.ValueCacheId_ = {MAX_VALUE:1, MIN_VALUE:2, ZERO:3, ONE:4, NEG_ONE:5, TWO_PWR_24:6};
goog.provide("cljs.core");
goog.require("goog.math.Long");
goog.require("goog.math.Integer");
goog.require("goog.string");
goog.require("goog.object");
goog.require("goog.array");
goog.require("goog.string.StringBuffer");
cljs.core._STAR_clojurescript_version_STAR_ = "1.9.542";
cljs.core._STAR_unchecked_if_STAR_ = false;
cljs.core._STAR_warn_on_infer_STAR_ = false;
if (typeof cljs.core.PROTOCOL_SENTINEL !== "undefined") {
} else {
  cljs.core.PROTOCOL_SENTINEL = {};
}
goog.define("cljs.core._STAR_target_STAR_", "default");
cljs.core._STAR_ns_STAR_ = null;
cljs.core._STAR_out_STAR_ = null;
cljs.core._STAR_assert_STAR_ = true;
if (typeof cljs.core._STAR_print_fn_STAR_ !== "undefined") {
} else {
  cljs.core._STAR_print_fn_STAR_ = function cljs$core$_STAR_print_fn_STAR_(_) {
    throw new Error("No *print-fn* fn set for evaluation environment");
  };
}
if (typeof cljs.core._STAR_print_err_fn_STAR_ !== "undefined") {
} else {
  cljs.core._STAR_print_err_fn_STAR_ = function cljs$core$_STAR_print_err_fn_STAR_(_) {
    throw new Error("No *print-err-fn* fn set for evaluation environment");
  };
}
cljs.core.set_print_fn_BANG_ = function cljs$core$set_print_fn_BANG_(f) {
  return cljs.core._STAR_print_fn_STAR_ = f;
};
cljs.core.set_print_err_fn_BANG_ = function cljs$core$set_print_err_fn_BANG_(f) {
  return cljs.core._STAR_print_err_fn_STAR_ = f;
};
cljs.core._STAR_flush_on_newline_STAR_ = true;
cljs.core._STAR_print_newline_STAR_ = true;
cljs.core._STAR_print_readably_STAR_ = true;
cljs.core._STAR_print_meta_STAR_ = false;
cljs.core._STAR_print_dup_STAR_ = false;
cljs.core._STAR_print_namespace_maps_STAR_ = false;
cljs.core._STAR_print_length_STAR_ = null;
cljs.core._STAR_print_level_STAR_ = null;
if (typeof cljs.core._STAR_loaded_libs_STAR_ !== "undefined") {
} else {
  cljs.core._STAR_loaded_libs_STAR_ = null;
}
cljs.core.pr_opts = function cljs$core$pr_opts() {
  return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null, "flush-on-newline", "flush-on-newline", -151457939), cljs.core._STAR_flush_on_newline_STAR_, new cljs.core.Keyword(null, "readably", "readably", 1129599760), cljs.core._STAR_print_readably_STAR_, new cljs.core.Keyword(null, "meta", "meta", 1499536964), cljs.core._STAR_print_meta_STAR_, new cljs.core.Keyword(null, "dup", "dup", 556298533), cljs.core._STAR_print_dup_STAR_, new cljs.core.Keyword(null, "print-length", "print-length", 
  1931866356), cljs.core._STAR_print_length_STAR_], null);
};
cljs.core.enable_console_print_BANG_ = function cljs$core$enable_console_print_BANG_() {
  cljs.core._STAR_print_newline_STAR_ = false;
  cljs.core._STAR_print_fn_STAR_ = function() {
    var G__45902__delegate = function(args) {
      return console.log.apply(console, cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args) : cljs.core.into_array.call(null, args));
    };
    var G__45902 = function(var_args) {
      var args = null;
      if (arguments.length > 0) {
        var G__45903__i = 0, G__45903__a = new Array(arguments.length - 0);
        while (G__45903__i < G__45903__a.length) {
          G__45903__a[G__45903__i] = arguments[G__45903__i + 0];
          ++G__45903__i;
        }
        args = new cljs.core.IndexedSeq(G__45903__a, 0, null);
      }
      return G__45902__delegate.call(this, args);
    };
    G__45902.cljs$lang$maxFixedArity = 0;
    G__45902.cljs$lang$applyTo = function(arglist__45904) {
      var args = cljs.core.seq(arglist__45904);
      return G__45902__delegate(args);
    };
    G__45902.cljs$core$IFn$_invoke$arity$variadic = G__45902__delegate;
    return G__45902;
  }();
  cljs.core._STAR_print_err_fn_STAR_ = function() {
    var G__45905__delegate = function(args) {
      return console.error.apply(console, cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args) : cljs.core.into_array.call(null, args));
    };
    var G__45905 = function(var_args) {
      var args = null;
      if (arguments.length > 0) {
        var G__45906__i = 0, G__45906__a = new Array(arguments.length - 0);
        while (G__45906__i < G__45906__a.length) {
          G__45906__a[G__45906__i] = arguments[G__45906__i + 0];
          ++G__45906__i;
        }
        args = new cljs.core.IndexedSeq(G__45906__a, 0, null);
      }
      return G__45905__delegate.call(this, args);
    };
    G__45905.cljs$lang$maxFixedArity = 0;
    G__45905.cljs$lang$applyTo = function(arglist__45907) {
      var args = cljs.core.seq(arglist__45907);
      return G__45905__delegate(args);
    };
    G__45905.cljs$core$IFn$_invoke$arity$variadic = G__45905__delegate;
    return G__45905;
  }();
  return null;
};
cljs.core.truth_ = function cljs$core$truth_(x) {
  return x != null && x !== false;
};
cljs.core.not_native = null;
cljs.core.identical_QMARK_ = function cljs$core$identical_QMARK_(x, y) {
  return x === y;
};
cljs.core.nil_QMARK_ = function cljs$core$nil_QMARK_(x) {
  return x == null;
};
cljs.core.array_QMARK_ = function cljs$core$array_QMARK_(x) {
  if (cljs.core._STAR_target_STAR_ === "nodejs") {
    return Array.isArray(x);
  } else {
    return x instanceof Array;
  }
};
cljs.core.number_QMARK_ = function cljs$core$number_QMARK_(x) {
  return typeof x === "number";
};
cljs.core.not = function cljs$core$not(x) {
  if (x == null) {
    return true;
  } else {
    if (x === false) {
      return true;
    } else {
      return false;
    }
  }
};
cljs.core.some_QMARK_ = function cljs$core$some_QMARK_(x) {
  return !(x == null);
};
cljs.core.object_QMARK_ = function cljs$core$object_QMARK_(x) {
  if (!(x == null)) {
    return x.constructor === Object;
  } else {
    return false;
  }
};
cljs.core.string_QMARK_ = function cljs$core$string_QMARK_(x) {
  return goog.isString(x);
};
cljs.core.char_QMARK_ = function cljs$core$char_QMARK_(x) {
  return typeof x === "string" && 1 === x.length;
};
cljs.core.any_QMARK_ = function cljs$core$any_QMARK_(x) {
  return true;
};
cljs.core.native_satisfies_QMARK_ = function cljs$core$native_satisfies_QMARK_(p, x) {
  var x__$1 = x == null ? null : x;
  if (p[goog.typeOf(x__$1)]) {
    return true;
  } else {
    if (p["_"]) {
      return true;
    } else {
      return false;
    }
  }
};
cljs.core.is_proto_ = function cljs$core$is_proto_(x) {
  return x.constructor.prototype === x;
};
cljs.core._STAR_main_cli_fn_STAR_ = null;
cljs.core.type = function cljs$core$type(x) {
  if (x == null) {
    return null;
  } else {
    return x.constructor;
  }
};
cljs.core.missing_protocol = function cljs$core$missing_protocol(proto, obj) {
  var ty = cljs.core.type(obj);
  var ty__$1 = cljs.core.truth_(function() {
    var and__9142__auto__ = ty;
    if (cljs.core.truth_(and__9142__auto__)) {
      return ty.cljs$lang$type;
    } else {
      return and__9142__auto__;
    }
  }()) ? ty.cljs$lang$ctorStr : goog.typeOf(obj);
  return new Error(["No protocol method ", proto, " defined for type ", ty__$1, ": ", obj].join(""));
};
cljs.core.type__GT_str = function cljs$core$type__GT_str(ty) {
  var temp__6736__auto__ = ty.cljs$lang$ctorStr;
  if (cljs.core.truth_(temp__6736__auto__)) {
    var s = temp__6736__auto__;
    return s;
  } else {
    return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ty)].join("");
  }
};
cljs.core.load_file = function cljs$core$load_file(file) {
  if (cljs.core.truth_(COMPILED)) {
    return null;
  } else {
    return goog.nodeGlobalRequire(file);
  }
};
if (typeof Symbol !== "undefined" && goog.typeOf(Symbol) === "function") {
  cljs.core.ITER_SYMBOL = Symbol.iterator;
} else {
  cljs.core.ITER_SYMBOL = "@@iterator";
}
cljs.core.CHAR_MAP = {"]":"_RBRACK_", "'":"_SINGLEQUOTE_", "\x3d":"_EQ_", '"':"_DOUBLEQUOTE_", "!":"_BANG_", "*":"_STAR_", "%":"_PERCENT_", "|":"_BAR_", "~":"_TILDE_", "/":"_SLASH_", "\\":"_BSLASH_", "-":"_", "?":"_QMARK_", "\x26":"_AMPERSAND_", ":":"_COLON_", "\x3c":"_LT_", "{":"_LBRACE_", "}":"_RBRACE_", "[":"_LBRACK_", "#":"_SHARP_", "^":"_CARET_", "+":"_PLUS_", "@":"_CIRCA_", "\x3e":"_GT_"};
cljs.core.DEMUNGE_MAP = {"_RBRACE_":"}", "_COLON_":":", "_BANG_":"!", "_QMARK_":"?", "_BSLASH_":"\\\\", "_SLASH_":"/", "_PERCENT_":"%", "_PLUS_":"+", "_SHARP_":"#", "_LBRACE_":"{", "_BAR_":"|", "_LBRACK_":"[", "_EQ_":"\x3d", "_":"-", "_TILDE_":"~", "_RBRACK_":"]", "_GT_":"\x3e", "_SINGLEQUOTE_":"'", "_CIRCA_":"@", "_AMPERSAND_":"\x26", "_DOUBLEQUOTE_":'\\"', "_CARET_":"^", "_LT_":"\x3c", "_STAR_":"*"};
cljs.core.DEMUNGE_PATTERN = null;
cljs.core.system_time = function cljs$core$system_time() {
  if (typeof performance !== "undefined" && !(performance.now == null)) {
    return performance.now();
  } else {
    if (typeof process !== "undefined" && !(process.hrtime == null)) {
      var t = process.hrtime();
      return (t[0] * 1.0E9 + t[1]) / 1000000.0;
    } else {
      return (new Date).getTime();
    }
  }
};
cljs.core.make_array = function cljs$core$make_array(var_args) {
  var args45908 = [];
  var len__10375__auto___45914 = arguments.length;
  var i__10376__auto___45915 = 0;
  while (true) {
    if (i__10376__auto___45915 < len__10375__auto___45914) {
      args45908.push(arguments[i__10376__auto___45915]);
      var G__45916 = i__10376__auto___45915 + 1;
      i__10376__auto___45915 = G__45916;
      continue;
    } else {
    }
    break;
  }
  var G__45913 = args45908.length;
  switch(G__45913) {
    case 1:
      return cljs.core.make_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.make_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args45908.slice(2), 0, null);
      return cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10398__auto__);
  }
};
cljs.core.make_array.cljs$core$IFn$_invoke$arity$1 = function(size) {
  return new Array(size);
};
cljs.core.make_array.cljs$core$IFn$_invoke$arity$2 = function(type, size) {
  return new Array(size);
};
cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic = function(type, size, more_sizes) {
  var dims = more_sizes;
  var dimarray = new Array(size);
  var n__10175__auto___45918 = dimarray.length;
  var i_45919 = 0;
  while (true) {
    if (i_45919 < n__10175__auto___45918) {
      dimarray[i_45919] = cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.make_array, null, dims) : cljs.core.apply.call(null, cljs.core.make_array, null, dims);
      var G__45920 = i_45919 + 1;
      i_45919 = G__45920;
      continue;
    } else {
    }
    break;
  }
  return dimarray;
};
cljs.core.make_array.cljs$lang$applyTo = function(seq45909) {
  var G__45910 = cljs.core.first(seq45909);
  var seq45909__$1 = cljs.core.next(seq45909);
  var G__45911 = cljs.core.first(seq45909__$1);
  var seq45909__$2 = cljs.core.next(seq45909__$1);
  return cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic(G__45910, G__45911, seq45909__$2);
};
cljs.core.make_array.cljs$lang$maxFixedArity = 2;
cljs.core.aclone = function cljs$core$aclone(arr) {
  var len = arr.length;
  var new_arr = new Array(len);
  var n__10175__auto___45921 = len;
  var i_45922 = 0;
  while (true) {
    if (i_45922 < n__10175__auto___45921) {
      new_arr[i_45922] = arr[i_45922];
      var G__45923 = i_45922 + 1;
      i_45922 = G__45923;
      continue;
    } else {
    }
    break;
  }
  return new_arr;
};
cljs.core.array = function cljs$core$array(var_args) {
  var a = new Array(arguments.length);
  var i = 0;
  while (true) {
    if (i < a.length) {
      a[i] = arguments[i];
      var G__45924 = i + 1;
      i = G__45924;
      continue;
    } else {
      return a;
    }
    break;
  }
};
cljs.core.aget = function cljs$core$aget(var_args) {
  var args45925 = [];
  var len__10375__auto___45934 = arguments.length;
  var i__10376__auto___45935 = 0;
  while (true) {
    if (i__10376__auto___45935 < len__10375__auto___45934) {
      args45925.push(arguments[i__10376__auto___45935]);
      var G__45936 = i__10376__auto___45935 + 1;
      i__10376__auto___45935 = G__45936;
      continue;
    } else {
    }
    break;
  }
  var G__45930 = args45925.length;
  switch(G__45930) {
    case 2:
      return cljs.core.aget.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args45925.slice(2), 0, null);
      return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10398__auto__);
  }
};
cljs.core.aget.cljs$core$IFn$_invoke$arity$2 = function(array, i) {
  return array[i];
};
cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic = function(array, i, idxs) {
  var G__45931 = cljs.core.aget;
  var G__45932 = array[i];
  var G__45933 = idxs;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(G__45931, G__45932, G__45933) : cljs.core.apply.call(null, G__45931, G__45932, G__45933);
};
cljs.core.aget.cljs$lang$applyTo = function(seq45926) {
  var G__45927 = cljs.core.first(seq45926);
  var seq45926__$1 = cljs.core.next(seq45926);
  var G__45928 = cljs.core.first(seq45926__$1);
  var seq45926__$2 = cljs.core.next(seq45926__$1);
  return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic(G__45927, G__45928, seq45926__$2);
};
cljs.core.aget.cljs$lang$maxFixedArity = 2;
cljs.core.aset = function cljs$core$aset(var_args) {
  var args45938 = [];
  var len__10375__auto___45949 = arguments.length;
  var i__10376__auto___45950 = 0;
  while (true) {
    if (i__10376__auto___45950 < len__10375__auto___45949) {
      args45938.push(arguments[i__10376__auto___45950]);
      var G__45951 = i__10376__auto___45950 + 1;
      i__10376__auto___45950 = G__45951;
      continue;
    } else {
    }
    break;
  }
  var G__45944 = args45938.length;
  switch(G__45944) {
    case 3:
      return cljs.core.aset.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args45938.slice(3), 0, null);
      return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__10398__auto__);
  }
};
cljs.core.aset.cljs$core$IFn$_invoke$arity$3 = function(array, i, val) {
  return array[i] = val;
};
cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic = function(array, idx, idx2, idxv) {
  var G__45945 = cljs.core.aset;
  var G__45946 = array[idx];
  var G__45947 = idx2;
  var G__45948 = idxv;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$4 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$4(G__45945, G__45946, G__45947, G__45948) : cljs.core.apply.call(null, G__45945, G__45946, G__45947, G__45948);
};
cljs.core.aset.cljs$lang$applyTo = function(seq45939) {
  var G__45940 = cljs.core.first(seq45939);
  var seq45939__$1 = cljs.core.next(seq45939);
  var G__45941 = cljs.core.first(seq45939__$1);
  var seq45939__$2 = cljs.core.next(seq45939__$1);
  var G__45942 = cljs.core.first(seq45939__$2);
  var seq45939__$3 = cljs.core.next(seq45939__$2);
  return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic(G__45940, G__45941, G__45942, seq45939__$3);
};
cljs.core.aset.cljs$lang$maxFixedArity = 3;
cljs.core.alength = function cljs$core$alength(array) {
  return array.length;
};
cljs.core.into_array = function cljs$core$into_array(var_args) {
  var args45953 = [];
  var len__10375__auto___45959 = arguments.length;
  var i__10376__auto___45960 = 0;
  while (true) {
    if (i__10376__auto___45960 < len__10375__auto___45959) {
      args45953.push(arguments[i__10376__auto___45960]);
      var G__45961 = i__10376__auto___45960 + 1;
      i__10376__auto___45960 = G__45961;
      continue;
    } else {
    }
    break;
  }
  var G__45955 = args45953.length;
  switch(G__45955) {
    case 1:
      return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args45953.length)].join(""));
  }
};
cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 = function(aseq) {
  return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(null, aseq);
};
cljs.core.into_array.cljs$core$IFn$_invoke$arity$2 = function(type, aseq) {
  var G__45956 = function(a, x) {
    a.push(x);
    return a;
  };
  var G__45957 = [];
  var G__45958 = aseq;
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__45956, G__45957, G__45958) : cljs.core.reduce.call(null, G__45956, G__45957, G__45958);
};
cljs.core.into_array.cljs$lang$maxFixedArity = 2;
cljs.core.js_invoke = function cljs$core$js_invoke(var_args) {
  var args__10382__auto__ = [];
  var len__10375__auto___45966 = arguments.length;
  var i__10376__auto___45967 = 0;
  while (true) {
    if (i__10376__auto___45967 < len__10375__auto___45966) {
      args__10382__auto__.push(arguments[i__10376__auto___45967]);
      var G__45968 = i__10376__auto___45967 + 1;
      i__10376__auto___45967 = G__45968;
      continue;
    } else {
    }
    break;
  }
  var argseq__10383__auto__ = 2 < args__10382__auto__.length ? new cljs.core.IndexedSeq(args__10382__auto__.slice(2), 0, null) : null;
  return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10383__auto__);
};
cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic = function(obj, s, args) {
  return obj[s].apply(obj, cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args));
};
cljs.core.js_invoke.cljs$lang$maxFixedArity = 2;
cljs.core.js_invoke.cljs$lang$applyTo = function(seq45963) {
  var G__45964 = cljs.core.first(seq45963);
  var seq45963__$1 = cljs.core.next(seq45963);
  var G__45965 = cljs.core.first(seq45963__$1);
  var seq45963__$2 = cljs.core.next(seq45963__$1);
  return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic(G__45964, G__45965, seq45963__$2);
};
cljs.core.Fn = function() {
};
cljs.core.IFn = function() {
};
cljs.core._invoke = function cljs$core$_invoke(var_args) {
  var args45969 = [];
  var len__10375__auto___45972 = arguments.length;
  var i__10376__auto___45973 = 0;
  while (true) {
    if (i__10376__auto___45973 < len__10375__auto___45972) {
      args45969.push(arguments[i__10376__auto___45973]);
      var G__45974 = i__10376__auto___45973 + 1;
      i__10376__auto___45973 = G__45974;
      continue;
    } else {
    }
    break;
  }
  var G__45971 = args45969.length;
  switch(G__45971) {
    case 1:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    case 7:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$7(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6]);
      break;
    case 8:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$8(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7]);
      break;
    case 9:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$9(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8]);
      break;
    case 10:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$10(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9]);
      break;
    case 11:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$11(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10]);
      break;
    case 12:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$12(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11]);
      break;
    case 13:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$13(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12]);
      break;
    case 14:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$14(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13]);
      break;
    case 15:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$15(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14]);
      break;
    case 16:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$16(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15]);
      break;
    case 17:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$17(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16]);
      break;
    case 18:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$18(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17]);
      break;
    case 19:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$19(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17], arguments[18]);
      break;
    case 20:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$20(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17], arguments[18], arguments[19]);
      break;
    case 21:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$21(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17], arguments[18], arguments[19], arguments[20]);
      break;
    case 22:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$22(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17], arguments[18], arguments[19], arguments[20], arguments[21]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args45969.length)].join(""));
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$1 = function(this$) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$1 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$1(this$);
  } else {
    var x__9872__auto__ = this$ == null ? null : this$;
    var m__9873__auto__ = cljs.core._invoke[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__9873__auto__.call(null, this$);
    } else {
      var m__9873__auto____$1 = cljs.core._invoke["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__9873__auto____$1.call(null, this$);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$2 = function(this$, a) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$2 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$2(this$, a);
  } else {
    var x__9872__auto__ = this$ == null ? null : this$;
    var m__9873__auto__ = cljs.core._invoke[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$2(this$, a) : m__9873__auto__.call(null, this$, a);
    } else {
      var m__9873__auto____$1 = cljs.core._invoke["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2(this$, a) : m__9873__auto____$1.call(null, this$, a);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$3 = function(this$, a, b) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$3 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$3(this$, a, b);
  } else {
    var x__9872__auto__ = this$ == null ? null : this$;
    var m__9873__auto__ = cljs.core._invoke[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$3 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$3(this$, a, b) : m__9873__auto__.call(null, this$, a, b);
    } else {
      var m__9873__auto____$1 = cljs.core._invoke["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$3(this$, a, b) : m__9873__auto____$1.call(null, this$, a, b);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$4 = function(this$, a, b, c) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$4 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$4(this$, a, b, c);
  } else {
    var x__9872__auto__ = this$ == null ? null : this$;
    var m__9873__auto__ = cljs.core._invoke[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$4 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$4(this$, a, b, c) : m__9873__auto__.call(null, this$, a, b, c);
    } else {
      var m__9873__auto____$1 = cljs.core._invoke["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$4(this$, a, b, c) : m__9873__auto____$1.call(null, this$, a, b, c);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$5 = function(this$, a, b, c, d) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$5 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$5(this$, a, b, c, d);
  } else {
    var x__9872__auto__ = this$ == null ? null : this$;
    var m__9873__auto__ = cljs.core._invoke[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$5 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$5(this$, a, b, c, d) : m__9873__auto__.call(null, this$, a, b, c, d);
    } else {
      var m__9873__auto____$1 = cljs.core._invoke["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$5 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$5(this$, a, b, c, d) : m__9873__auto____$1.call(null, this$, a, b, c, d);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$6 = function(this$, a, b, c, d, e) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$6 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$6(this$, a, b, c, d, e);
  } else {
    var x__9872__auto__ = this$ == null ? null : this$;
    var m__9873__auto__ = cljs.core._invoke[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$6 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$6(this$, a, b, c, d, e) : m__9873__auto__.call(null, this$, a, b, c, d, e);
    } else {
      var m__9873__auto____$1 = cljs.core._invoke["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$6 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$6(this$, a, b, c, d, e) : m__9873__auto____$1.call(null, this$, a, b, c, d, e);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$7 = function(this$, a, b, c, d, e, f) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$7 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$7(this$, a, b, c, d, e, f);
  } else {
    var x__9872__auto__ = this$ == null ? null : this$;
    var m__9873__auto__ = cljs.core._invoke[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$7 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$7(this$, a, b, c, d, e, f) : m__9873__auto__.call(null, this$, a, b, c, d, e, f);
    } else {
      var m__9873__auto____$1 = cljs.core._invoke["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$7 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$7(this$, a, b, c, d, e, f) : m__9873__auto____$1.call(null, this$, a, b, c, d, e, f);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$8 = function(this$, a, b, c, d, e, f, g) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$8 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$8(this$, a, b, c, d, e, f, g);
  } else {
    var x__9872__auto__ = this$ == null ? null : this$;
    var m__9873__auto__ = cljs.core._invoke[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$8 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$8(this$, a, b, c, d, e, f, g) : m__9873__auto__.call(null, this$, a, b, c, d, e, f, g);
    } else {
      var m__9873__auto____$1 = cljs.core._invoke["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$8 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$8(this$, a, b, c, d, e, f, g) : m__9873__auto____$1.call(null, this$, a, b, c, d, e, f, g);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$9 = function(this$, a, b, c, d, e, f, g, h) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$9 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$9(this$, a, b, c, d, e, f, g, h);
  } else {
    var x__9872__auto__ = this$ == null ? null : this$;
    var m__9873__auto__ = cljs.core._invoke[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$9 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$9(this$, a, b, c, d, e, f, g, h) : m__9873__auto__.call(null, this$, a, b, c, d, e, f, g, h);
    } else {
      var m__9873__auto____$1 = cljs.core._invoke["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$9 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$9(this$, a, b, c, d, e, f, g, h) : m__9873__auto____$1.call(null, this$, a, b, c, d, e, f, g, h);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$10 = function(this$, a, b, c, d, e, f, g, h, i) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$10 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$10(this$, a, b, c, d, e, f, g, h, i);
  } else {
    var x__9872__auto__ = this$ == null ? null : this$;
    var m__9873__auto__ = cljs.core._invoke[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$10 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$10(this$, a, b, c, d, e, f, g, h, i) : m__9873__auto__.call(null, this$, a, b, c, d, e, f, g, h, i);
    } else {
      var m__9873__auto____$1 = cljs.core._invoke["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$10 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$10(this$, a, b, c, d, e, f, g, h, i) : m__9873__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$11 = function(this$, a, b, c, d, e, f, g, h, i, j) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$11 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$11(this$, a, b, c, d, e, f, g, h, i, j);
  } else {
    var x__9872__auto__ = this$ == null ? null : this$;
    var m__9873__auto__ = cljs.core._invoke[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$11 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$11(this$, a, b, c, d, e, f, g, h, i, j) : m__9873__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j);
    } else {
      var m__9873__auto____$1 = cljs.core._invoke["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$11 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$11(this$, a, b, c, d, e, f, g, h, i, j) : m__9873__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$12 = function(this$, a, b, c, d, e, f, g, h, i, j, k) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$12 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$12(this$, a, b, c, d, e, f, g, h, i, j, k);
  } else {
    var x__9872__auto__ = this$ == null ? null : this$;
    var m__9873__auto__ = cljs.core._invoke[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$12 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$12(this$, a, b, c, d, e, f, g, h, i, j, k) : m__9873__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k);
    } else {
      var m__9873__auto____$1 = cljs.core._invoke["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$12 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$12(this$, a, b, c, d, e, f, g, h, i, j, k) : m__9873__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$13 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$13 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$13(this$, a, b, c, d, e, f, g, h, i, j, k, l);
  } else {
    var x__9872__auto__ = this$ == null ? null : this$;
    var m__9873__auto__ = cljs.core._invoke[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$13 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$13(this$, a, b, c, d, e, f, g, h, i, j, k, l) : m__9873__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l);
    } else {
      var m__9873__auto____$1 = cljs.core._invoke["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$13 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$13(this$, a, b, c, d, e, f, g, h, i, j, k, l) : m__9873__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$14 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$14 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$14(this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
  } else {
    var x__9872__auto__ = this$ == null ? null : this$;
    var m__9873__auto__ = cljs.core._invoke[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$14 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$14(this$, a, b, c, d, e, f, g, h, i, j, k, l, m) : m__9873__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
    } else {
      var m__9873__auto____$1 = cljs.core._invoke["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$14 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$14(this$, a, b, c, d, e, f, g, h, i, j, k, l, m) : m__9873__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$15 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$15 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$15(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
  } else {
    var x__9872__auto__ = this$ == null ? null : this$;
    var m__9873__auto__ = cljs.core._invoke[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$15 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$15(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n) : m__9873__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
    } else {
      var m__9873__auto____$1 = cljs.core._invoke["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$15 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$15(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n) : m__9873__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$16 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$16 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$16(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
  } else {
    var x__9872__auto__ = this$ == null ? null : this$;
    var m__9873__auto__ = cljs.core._invoke[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$16 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$16(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) : m__9873__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
    } else {
      var m__9873__auto____$1 = cljs.core._invoke["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$16 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$16(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) : m__9873__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$17 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$17 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$17(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
  } else {
    var x__9872__auto__ = this$ == null ? null : this$;
    var m__9873__auto__ = cljs.core._invoke[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$17 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$17(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) : m__9873__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
    } else {
      var m__9873__auto____$1 = cljs.core._invoke["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$17 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$17(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) : m__9873__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$18 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$18 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$18(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
  } else {
    var x__9872__auto__ = this$ == null ? null : this$;
    var m__9873__auto__ = cljs.core._invoke[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$18 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$18(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) : m__9873__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
    } else {
      var m__9873__auto____$1 = cljs.core._invoke["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$18 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$18(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) : m__9873__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$19 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$19 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$19(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
  } else {
    var x__9872__auto__ = this$ == null ? null : this$;
    var m__9873__auto__ = cljs.core._invoke[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$19 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$19(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) : m__9873__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
    } else {
      var m__9873__auto____$1 = cljs.core._invoke["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$19 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$19(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) : m__9873__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$20 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$20 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$20(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
  } else {
    var x__9872__auto__ = this$ == null ? null : this$;
    var m__9873__auto__ = cljs.core._invoke[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$20 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$20(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) : m__9873__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
    } else {
      var m__9873__auto____$1 = cljs.core._invoke["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$20 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$20(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) : m__9873__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$21 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$21 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$21(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
  } else {
    var x__9872__auto__ = this$ == null ? null : this$;
    var m__9873__auto__ = cljs.core._invoke[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$21 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$21(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) : m__9873__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
    } else {
      var m__9873__auto____$1 = cljs.core._invoke["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$21 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$21(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) : m__9873__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$22 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$22 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$22(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
  } else {
    var x__9872__auto__ = this$ == null ? null : this$;
    var m__9873__auto__ = cljs.core._invoke[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$22 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$22(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) : m__9873__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
    } else {
      var m__9873__auto____$1 = cljs.core._invoke["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$22 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$22(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) : m__9873__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$lang$maxFixedArity = 22;
cljs.core.ICloneable = function() {
};
cljs.core._clone = function cljs$core$_clone(value) {
  if (!(value == null) && !(value.cljs$core$ICloneable$_clone$arity$1 == null)) {
    return value.cljs$core$ICloneable$_clone$arity$1(value);
  } else {
    var x__9872__auto__ = value == null ? null : value;
    var m__9873__auto__ = cljs.core._clone[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$1(value) : m__9873__auto__.call(null, value);
    } else {
      var m__9873__auto____$1 = cljs.core._clone["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1(value) : m__9873__auto____$1.call(null, value);
      } else {
        throw cljs.core.missing_protocol("ICloneable.-clone", value);
      }
    }
  }
};
cljs.core.ICounted = function() {
};
cljs.core._count = function cljs$core$_count(coll) {
  if (!(coll == null) && !(coll.cljs$core$ICounted$_count$arity$1 == null)) {
    return coll.cljs$core$ICounted$_count$arity$1(coll);
  } else {
    var x__9872__auto__ = coll == null ? null : coll;
    var m__9873__auto__ = cljs.core._count[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__9873__auto__.call(null, coll);
    } else {
      var m__9873__auto____$1 = cljs.core._count["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__9873__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("ICounted.-count", coll);
      }
    }
  }
};
cljs.core.IEmptyableCollection = function() {
};
cljs.core._empty = function cljs$core$_empty(coll) {
  if (!(coll == null) && !(coll.cljs$core$IEmptyableCollection$_empty$arity$1 == null)) {
    return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);
  } else {
    var x__9872__auto__ = coll == null ? null : coll;
    var m__9873__auto__ = cljs.core._empty[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__9873__auto__.call(null, coll);
    } else {
      var m__9873__auto____$1 = cljs.core._empty["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__9873__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IEmptyableCollection.-empty", coll);
      }
    }
  }
};
cljs.core.ICollection = function() {
};
cljs.core._conj = function cljs$core$_conj(coll, o) {
  if (!(coll == null) && !(coll.cljs$core$ICollection$_conj$arity$2 == null)) {
    return coll.cljs$core$ICollection$_conj$arity$2(coll, o);
  } else {
    var x__9872__auto__ = coll == null ? null : coll;
    var m__9873__auto__ = cljs.core._conj[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$2(coll, o) : m__9873__auto__.call(null, coll, o);
    } else {
      var m__9873__auto____$1 = cljs.core._conj["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, o) : m__9873__auto____$1.call(null, coll, o);
      } else {
        throw cljs.core.missing_protocol("ICollection.-conj", coll);
      }
    }
  }
};
cljs.core.IIndexed = function() {
};
cljs.core._nth = function cljs$core$_nth(var_args) {
  var args45976 = [];
  var len__10375__auto___45979 = arguments.length;
  var i__10376__auto___45980 = 0;
  while (true) {
    if (i__10376__auto___45980 < len__10375__auto___45979) {
      args45976.push(arguments[i__10376__auto___45980]);
      var G__45981 = i__10376__auto___45980 + 1;
      i__10376__auto___45980 = G__45981;
      continue;
    } else {
    }
    break;
  }
  var G__45978 = args45976.length;
  switch(G__45978) {
    case 2:
      return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args45976.length)].join(""));
  }
};
cljs.core._nth.cljs$core$IFn$_invoke$arity$2 = function(coll, n) {
  if (!(coll == null) && !(coll.cljs$core$IIndexed$_nth$arity$2 == null)) {
    return coll.cljs$core$IIndexed$_nth$arity$2(coll, n);
  } else {
    var x__9872__auto__ = coll == null ? null : coll;
    var m__9873__auto__ = cljs.core._nth[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$2(coll, n) : m__9873__auto__.call(null, coll, n);
    } else {
      var m__9873__auto____$1 = cljs.core._nth["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, n) : m__9873__auto____$1.call(null, coll, n);
      } else {
        throw cljs.core.missing_protocol("IIndexed.-nth", coll);
      }
    }
  }
};
cljs.core._nth.cljs$core$IFn$_invoke$arity$3 = function(coll, n, not_found) {
  if (!(coll == null) && !(coll.cljs$core$IIndexed$_nth$arity$3 == null)) {
    return coll.cljs$core$IIndexed$_nth$arity$3(coll, n, not_found);
  } else {
    var x__9872__auto__ = coll == null ? null : coll;
    var m__9873__auto__ = cljs.core._nth[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$3 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$3(coll, n, not_found) : m__9873__auto__.call(null, coll, n, not_found);
    } else {
      var m__9873__auto____$1 = cljs.core._nth["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$3(coll, n, not_found) : m__9873__auto____$1.call(null, coll, n, not_found);
      } else {
        throw cljs.core.missing_protocol("IIndexed.-nth", coll);
      }
    }
  }
};
cljs.core._nth.cljs$lang$maxFixedArity = 3;
cljs.core.ASeq = function() {
};
cljs.core.ISeq = function() {
};
cljs.core._first = function cljs$core$_first(coll) {
  if (!(coll == null) && !(coll.cljs$core$ISeq$_first$arity$1 == null)) {
    return coll.cljs$core$ISeq$_first$arity$1(coll);
  } else {
    var x__9872__auto__ = coll == null ? null : coll;
    var m__9873__auto__ = cljs.core._first[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__9873__auto__.call(null, coll);
    } else {
      var m__9873__auto____$1 = cljs.core._first["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__9873__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("ISeq.-first", coll);
      }
    }
  }
};
cljs.core._rest = function cljs$core$_rest(coll) {
  if (!(coll == null) && !(coll.cljs$core$ISeq$_rest$arity$1 == null)) {
    return coll.cljs$core$ISeq$_rest$arity$1(coll);
  } else {
    var x__9872__auto__ = coll == null ? null : coll;
    var m__9873__auto__ = cljs.core._rest[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__9873__auto__.call(null, coll);
    } else {
      var m__9873__auto____$1 = cljs.core._rest["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__9873__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("ISeq.-rest", coll);
      }
    }
  }
};
cljs.core.INext = function() {
};
cljs.core._next = function cljs$core$_next(coll) {
  if (!(coll == null) && !(coll.cljs$core$INext$_next$arity$1 == null)) {
    return coll.cljs$core$INext$_next$arity$1(coll);
  } else {
    var x__9872__auto__ = coll == null ? null : coll;
    var m__9873__auto__ = cljs.core._next[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__9873__auto__.call(null, coll);
    } else {
      var m__9873__auto____$1 = cljs.core._next["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__9873__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("INext.-next", coll);
      }
    }
  }
};
cljs.core.ILookup = function() {
};
cljs.core._lookup = function cljs$core$_lookup(var_args) {
  var args45983 = [];
  var len__10375__auto___45986 = arguments.length;
  var i__10376__auto___45987 = 0;
  while (true) {
    if (i__10376__auto___45987 < len__10375__auto___45986) {
      args45983.push(arguments[i__10376__auto___45987]);
      var G__45988 = i__10376__auto___45987 + 1;
      i__10376__auto___45987 = G__45988;
      continue;
    } else {
    }
    break;
  }
  var G__45985 = args45983.length;
  switch(G__45985) {
    case 2:
      return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args45983.length)].join(""));
  }
};
cljs.core._lookup.cljs$core$IFn$_invoke$arity$2 = function(o, k) {
  if (!(o == null) && !(o.cljs$core$ILookup$_lookup$arity$2 == null)) {
    return o.cljs$core$ILookup$_lookup$arity$2(o, k);
  } else {
    var x__9872__auto__ = o == null ? null : o;
    var m__9873__auto__ = cljs.core._lookup[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$2(o, k) : m__9873__auto__.call(null, o, k);
    } else {
      var m__9873__auto____$1 = cljs.core._lookup["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2(o, k) : m__9873__auto____$1.call(null, o, k);
      } else {
        throw cljs.core.missing_protocol("ILookup.-lookup", o);
      }
    }
  }
};
cljs.core._lookup.cljs$core$IFn$_invoke$arity$3 = function(o, k, not_found) {
  if (!(o == null) && !(o.cljs$core$ILookup$_lookup$arity$3 == null)) {
    return o.cljs$core$ILookup$_lookup$arity$3(o, k, not_found);
  } else {
    var x__9872__auto__ = o == null ? null : o;
    var m__9873__auto__ = cljs.core._lookup[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$3 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$3(o, k, not_found) : m__9873__auto__.call(null, o, k, not_found);
    } else {
      var m__9873__auto____$1 = cljs.core._lookup["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$3(o, k, not_found) : m__9873__auto____$1.call(null, o, k, not_found);
      } else {
        throw cljs.core.missing_protocol("ILookup.-lookup", o);
      }
    }
  }
};
cljs.core._lookup.cljs$lang$maxFixedArity = 3;
cljs.core.IAssociative = function() {
};
cljs.core._contains_key_QMARK_ = function cljs$core$_contains_key_QMARK_(coll, k) {
  if (!(coll == null) && !(coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 == null)) {
    return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll, k);
  } else {
    var x__9872__auto__ = coll == null ? null : coll;
    var m__9873__auto__ = cljs.core._contains_key_QMARK_[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$2(coll, k) : m__9873__auto__.call(null, coll, k);
    } else {
      var m__9873__auto____$1 = cljs.core._contains_key_QMARK_["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, k) : m__9873__auto____$1.call(null, coll, k);
      } else {
        throw cljs.core.missing_protocol("IAssociative.-contains-key?", coll);
      }
    }
  }
};
cljs.core._assoc = function cljs$core$_assoc(coll, k, v) {
  if (!(coll == null) && !(coll.cljs$core$IAssociative$_assoc$arity$3 == null)) {
    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, k, v);
  } else {
    var x__9872__auto__ = coll == null ? null : coll;
    var m__9873__auto__ = cljs.core._assoc[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$3 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$3(coll, k, v) : m__9873__auto__.call(null, coll, k, v);
    } else {
      var m__9873__auto____$1 = cljs.core._assoc["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$3(coll, k, v) : m__9873__auto____$1.call(null, coll, k, v);
      } else {
        throw cljs.core.missing_protocol("IAssociative.-assoc", coll);
      }
    }
  }
};
cljs.core.IFind = function() {
};
cljs.core._find = function cljs$core$_find(coll, k) {
  if (!(coll == null) && !(coll.cljs$core$IFind$_find$arity$2 == null)) {
    return coll.cljs$core$IFind$_find$arity$2(coll, k);
  } else {
    var x__9872__auto__ = coll == null ? null : coll;
    var m__9873__auto__ = cljs.core._find[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$2(coll, k) : m__9873__auto__.call(null, coll, k);
    } else {
      var m__9873__auto____$1 = cljs.core._find["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, k) : m__9873__auto____$1.call(null, coll, k);
      } else {
        throw cljs.core.missing_protocol("IFind.-find", coll);
      }
    }
  }
};
cljs.core.IMap = function() {
};
cljs.core._dissoc = function cljs$core$_dissoc(coll, k) {
  if (!(coll == null) && !(coll.cljs$core$IMap$_dissoc$arity$2 == null)) {
    return coll.cljs$core$IMap$_dissoc$arity$2(coll, k);
  } else {
    var x__9872__auto__ = coll == null ? null : coll;
    var m__9873__auto__ = cljs.core._dissoc[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$2(coll, k) : m__9873__auto__.call(null, coll, k);
    } else {
      var m__9873__auto____$1 = cljs.core._dissoc["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, k) : m__9873__auto____$1.call(null, coll, k);
      } else {
        throw cljs.core.missing_protocol("IMap.-dissoc", coll);
      }
    }
  }
};
cljs.core.IMapEntry = function() {
};
cljs.core._key = function cljs$core$_key(coll) {
  if (!(coll == null) && !(coll.cljs$core$IMapEntry$_key$arity$1 == null)) {
    return coll.cljs$core$IMapEntry$_key$arity$1(coll);
  } else {
    var x__9872__auto__ = coll == null ? null : coll;
    var m__9873__auto__ = cljs.core._key[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__9873__auto__.call(null, coll);
    } else {
      var m__9873__auto____$1 = cljs.core._key["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__9873__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IMapEntry.-key", coll);
      }
    }
  }
};
cljs.core._val = function cljs$core$_val(coll) {
  if (!(coll == null) && !(coll.cljs$core$IMapEntry$_val$arity$1 == null)) {
    return coll.cljs$core$IMapEntry$_val$arity$1(coll);
  } else {
    var x__9872__auto__ = coll == null ? null : coll;
    var m__9873__auto__ = cljs.core._val[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__9873__auto__.call(null, coll);
    } else {
      var m__9873__auto____$1 = cljs.core._val["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__9873__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IMapEntry.-val", coll);
      }
    }
  }
};
cljs.core.ISet = function() {
};
cljs.core._disjoin = function cljs$core$_disjoin(coll, v) {
  if (!(coll == null) && !(coll.cljs$core$ISet$_disjoin$arity$2 == null)) {
    return coll.cljs$core$ISet$_disjoin$arity$2(coll, v);
  } else {
    var x__9872__auto__ = coll == null ? null : coll;
    var m__9873__auto__ = cljs.core._disjoin[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$2(coll, v) : m__9873__auto__.call(null, coll, v);
    } else {
      var m__9873__auto____$1 = cljs.core._disjoin["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, v) : m__9873__auto____$1.call(null, coll, v);
      } else {
        throw cljs.core.missing_protocol("ISet.-disjoin", coll);
      }
    }
  }
};
cljs.core.IStack = function() {
};
cljs.core._peek = function cljs$core$_peek(coll) {
  if (!(coll == null) && !(coll.cljs$core$IStack$_peek$arity$1 == null)) {
    return coll.cljs$core$IStack$_peek$arity$1(coll);
  } else {
    var x__9872__auto__ = coll == null ? null : coll;
    var m__9873__auto__ = cljs.core._peek[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__9873__auto__.call(null, coll);
    } else {
      var m__9873__auto____$1 = cljs.core._peek["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__9873__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IStack.-peek", coll);
      }
    }
  }
};
cljs.core._pop = function cljs$core$_pop(coll) {
  if (!(coll == null) && !(coll.cljs$core$IStack$_pop$arity$1 == null)) {
    return coll.cljs$core$IStack$_pop$arity$1(coll);
  } else {
    var x__9872__auto__ = coll == null ? null : coll;
    var m__9873__auto__ = cljs.core._pop[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__9873__auto__.call(null, coll);
    } else {
      var m__9873__auto____$1 = cljs.core._pop["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__9873__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IStack.-pop", coll);
      }
    }
  }
};
cljs.core.IVector = function() {
};
cljs.core._assoc_n = function cljs$core$_assoc_n(coll, n, val) {
  if (!(coll == null) && !(coll.cljs$core$IVector$_assoc_n$arity$3 == null)) {
    return coll.cljs$core$IVector$_assoc_n$arity$3(coll, n, val);
  } else {
    var x__9872__auto__ = coll == null ? null : coll;
    var m__9873__auto__ = cljs.core._assoc_n[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$3 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$3(coll, n, val) : m__9873__auto__.call(null, coll, n, val);
    } else {
      var m__9873__auto____$1 = cljs.core._assoc_n["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$3(coll, n, val) : m__9873__auto____$1.call(null, coll, n, val);
      } else {
        throw cljs.core.missing_protocol("IVector.-assoc-n", coll);
      }
    }
  }
};
cljs.core.IDeref = function() {
};
cljs.core._deref = function cljs$core$_deref(o) {
  if (!(o == null) && !(o.cljs$core$IDeref$_deref$arity$1 == null)) {
    return o.cljs$core$IDeref$_deref$arity$1(o);
  } else {
    var x__9872__auto__ = o == null ? null : o;
    var m__9873__auto__ = cljs.core._deref[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__9873__auto__.call(null, o);
    } else {
      var m__9873__auto____$1 = cljs.core._deref["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__9873__auto____$1.call(null, o);
      } else {
        throw cljs.core.missing_protocol("IDeref.-deref", o);
      }
    }
  }
};
cljs.core.IDerefWithTimeout = function() {
};
cljs.core._deref_with_timeout = function cljs$core$_deref_with_timeout(o, msec, timeout_val) {
  if (!(o == null) && !(o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3 == null)) {
    return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o, msec, timeout_val);
  } else {
    var x__9872__auto__ = o == null ? null : o;
    var m__9873__auto__ = cljs.core._deref_with_timeout[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$3 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$3(o, msec, timeout_val) : m__9873__auto__.call(null, o, msec, timeout_val);
    } else {
      var m__9873__auto____$1 = cljs.core._deref_with_timeout["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$3(o, msec, timeout_val) : m__9873__auto____$1.call(null, o, msec, timeout_val);
      } else {
        throw cljs.core.missing_protocol("IDerefWithTimeout.-deref-with-timeout", o);
      }
    }
  }
};
cljs.core.IMeta = function() {
};
cljs.core._meta = function cljs$core$_meta(o) {
  if (!(o == null) && !(o.cljs$core$IMeta$_meta$arity$1 == null)) {
    return o.cljs$core$IMeta$_meta$arity$1(o);
  } else {
    var x__9872__auto__ = o == null ? null : o;
    var m__9873__auto__ = cljs.core._meta[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__9873__auto__.call(null, o);
    } else {
      var m__9873__auto____$1 = cljs.core._meta["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__9873__auto____$1.call(null, o);
      } else {
        throw cljs.core.missing_protocol("IMeta.-meta", o);
      }
    }
  }
};
cljs.core.IWithMeta = function() {
};
cljs.core._with_meta = function cljs$core$_with_meta(o, meta) {
  if (!(o == null) && !(o.cljs$core$IWithMeta$_with_meta$arity$2 == null)) {
    return o.cljs$core$IWithMeta$_with_meta$arity$2(o, meta);
  } else {
    var x__9872__auto__ = o == null ? null : o;
    var m__9873__auto__ = cljs.core._with_meta[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$2(o, meta) : m__9873__auto__.call(null, o, meta);
    } else {
      var m__9873__auto____$1 = cljs.core._with_meta["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2(o, meta) : m__9873__auto____$1.call(null, o, meta);
      } else {
        throw cljs.core.missing_protocol("IWithMeta.-with-meta", o);
      }
    }
  }
};
cljs.core.IReduce = function() {
};
cljs.core._reduce = function cljs$core$_reduce(var_args) {
  var args45990 = [];
  var len__10375__auto___45993 = arguments.length;
  var i__10376__auto___45994 = 0;
  while (true) {
    if (i__10376__auto___45994 < len__10375__auto___45993) {
      args45990.push(arguments[i__10376__auto___45994]);
      var G__45995 = i__10376__auto___45994 + 1;
      i__10376__auto___45994 = G__45995;
      continue;
    } else {
    }
    break;
  }
  var G__45992 = args45990.length;
  switch(G__45992) {
    case 2:
      return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args45990.length)].join(""));
  }
};
cljs.core._reduce.cljs$core$IFn$_invoke$arity$2 = function(coll, f) {
  if (!(coll == null) && !(coll.cljs$core$IReduce$_reduce$arity$2 == null)) {
    return coll.cljs$core$IReduce$_reduce$arity$2(coll, f);
  } else {
    var x__9872__auto__ = coll == null ? null : coll;
    var m__9873__auto__ = cljs.core._reduce[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$2(coll, f) : m__9873__auto__.call(null, coll, f);
    } else {
      var m__9873__auto____$1 = cljs.core._reduce["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, f) : m__9873__auto____$1.call(null, coll, f);
      } else {
        throw cljs.core.missing_protocol("IReduce.-reduce", coll);
      }
    }
  }
};
cljs.core._reduce.cljs$core$IFn$_invoke$arity$3 = function(coll, f, start) {
  if (!(coll == null) && !(coll.cljs$core$IReduce$_reduce$arity$3 == null)) {
    return coll.cljs$core$IReduce$_reduce$arity$3(coll, f, start);
  } else {
    var x__9872__auto__ = coll == null ? null : coll;
    var m__9873__auto__ = cljs.core._reduce[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$3 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$3(coll, f, start) : m__9873__auto__.call(null, coll, f, start);
    } else {
      var m__9873__auto____$1 = cljs.core._reduce["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$3(coll, f, start) : m__9873__auto____$1.call(null, coll, f, start);
      } else {
        throw cljs.core.missing_protocol("IReduce.-reduce", coll);
      }
    }
  }
};
cljs.core._reduce.cljs$lang$maxFixedArity = 3;
cljs.core.IKVReduce = function() {
};
cljs.core._kv_reduce = function cljs$core$_kv_reduce(coll, f, init) {
  if (!(coll == null) && !(coll.cljs$core$IKVReduce$_kv_reduce$arity$3 == null)) {
    return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll, f, init);
  } else {
    var x__9872__auto__ = coll == null ? null : coll;
    var m__9873__auto__ = cljs.core._kv_reduce[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$3 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$3(coll, f, init) : m__9873__auto__.call(null, coll, f, init);
    } else {
      var m__9873__auto____$1 = cljs.core._kv_reduce["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$3(coll, f, init) : m__9873__auto____$1.call(null, coll, f, init);
      } else {
        throw cljs.core.missing_protocol("IKVReduce.-kv-reduce", coll);
      }
    }
  }
};
cljs.core.IEquiv = function() {
};
cljs.core._equiv = function cljs$core$_equiv(o, other) {
  if (!(o == null) && !(o.cljs$core$IEquiv$_equiv$arity$2 == null)) {
    return o.cljs$core$IEquiv$_equiv$arity$2(o, other);
  } else {
    var x__9872__auto__ = o == null ? null : o;
    var m__9873__auto__ = cljs.core._equiv[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$2(o, other) : m__9873__auto__.call(null, o, other);
    } else {
      var m__9873__auto____$1 = cljs.core._equiv["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2(o, other) : m__9873__auto____$1.call(null, o, other);
      } else {
        throw cljs.core.missing_protocol("IEquiv.-equiv", o);
      }
    }
  }
};
cljs.core.IHash = function() {
};
cljs.core._hash = function cljs$core$_hash(o) {
  if (!(o == null) && !(o.cljs$core$IHash$_hash$arity$1 == null)) {
    return o.cljs$core$IHash$_hash$arity$1(o);
  } else {
    var x__9872__auto__ = o == null ? null : o;
    var m__9873__auto__ = cljs.core._hash[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__9873__auto__.call(null, o);
    } else {
      var m__9873__auto____$1 = cljs.core._hash["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__9873__auto____$1.call(null, o);
      } else {
        throw cljs.core.missing_protocol("IHash.-hash", o);
      }
    }
  }
};
cljs.core.ISeqable = function() {
};
cljs.core._seq = function cljs$core$_seq(o) {
  if (!(o == null) && !(o.cljs$core$ISeqable$_seq$arity$1 == null)) {
    return o.cljs$core$ISeqable$_seq$arity$1(o);
  } else {
    var x__9872__auto__ = o == null ? null : o;
    var m__9873__auto__ = cljs.core._seq[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__9873__auto__.call(null, o);
    } else {
      var m__9873__auto____$1 = cljs.core._seq["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__9873__auto____$1.call(null, o);
      } else {
        throw cljs.core.missing_protocol("ISeqable.-seq", o);
      }
    }
  }
};
cljs.core.ISequential = function() {
};
cljs.core.IList = function() {
};
cljs.core.IRecord = function() {
};
cljs.core.IReversible = function() {
};
cljs.core._rseq = function cljs$core$_rseq(coll) {
  if (!(coll == null) && !(coll.cljs$core$IReversible$_rseq$arity$1 == null)) {
    return coll.cljs$core$IReversible$_rseq$arity$1(coll);
  } else {
    var x__9872__auto__ = coll == null ? null : coll;
    var m__9873__auto__ = cljs.core._rseq[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__9873__auto__.call(null, coll);
    } else {
      var m__9873__auto____$1 = cljs.core._rseq["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__9873__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IReversible.-rseq", coll);
      }
    }
  }
};
cljs.core.ISorted = function() {
};
cljs.core._sorted_seq = function cljs$core$_sorted_seq(coll, ascending_QMARK_) {
  if (!(coll == null) && !(coll.cljs$core$ISorted$_sorted_seq$arity$2 == null)) {
    return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll, ascending_QMARK_);
  } else {
    var x__9872__auto__ = coll == null ? null : coll;
    var m__9873__auto__ = cljs.core._sorted_seq[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$2(coll, ascending_QMARK_) : m__9873__auto__.call(null, coll, ascending_QMARK_);
    } else {
      var m__9873__auto____$1 = cljs.core._sorted_seq["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, ascending_QMARK_) : m__9873__auto____$1.call(null, coll, ascending_QMARK_);
      } else {
        throw cljs.core.missing_protocol("ISorted.-sorted-seq", coll);
      }
    }
  }
};
cljs.core._sorted_seq_from = function cljs$core$_sorted_seq_from(coll, k, ascending_QMARK_) {
  if (!(coll == null) && !(coll.cljs$core$ISorted$_sorted_seq_from$arity$3 == null)) {
    return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll, k, ascending_QMARK_);
  } else {
    var x__9872__auto__ = coll == null ? null : coll;
    var m__9873__auto__ = cljs.core._sorted_seq_from[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$3 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$3(coll, k, ascending_QMARK_) : m__9873__auto__.call(null, coll, k, ascending_QMARK_);
    } else {
      var m__9873__auto____$1 = cljs.core._sorted_seq_from["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$3(coll, k, ascending_QMARK_) : m__9873__auto____$1.call(null, coll, k, ascending_QMARK_);
      } else {
        throw cljs.core.missing_protocol("ISorted.-sorted-seq-from", coll);
      }
    }
  }
};
cljs.core._entry_key = function cljs$core$_entry_key(coll, entry) {
  if (!(coll == null) && !(coll.cljs$core$ISorted$_entry_key$arity$2 == null)) {
    return coll.cljs$core$ISorted$_entry_key$arity$2(coll, entry);
  } else {
    var x__9872__auto__ = coll == null ? null : coll;
    var m__9873__auto__ = cljs.core._entry_key[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$2(coll, entry) : m__9873__auto__.call(null, coll, entry);
    } else {
      var m__9873__auto____$1 = cljs.core._entry_key["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, entry) : m__9873__auto____$1.call(null, coll, entry);
      } else {
        throw cljs.core.missing_protocol("ISorted.-entry-key", coll);
      }
    }
  }
};
cljs.core._comparator = function cljs$core$_comparator(coll) {
  if (!(coll == null) && !(coll.cljs$core$ISorted$_comparator$arity$1 == null)) {
    return coll.cljs$core$ISorted$_comparator$arity$1(coll);
  } else {
    var x__9872__auto__ = coll == null ? null : coll;
    var m__9873__auto__ = cljs.core._comparator[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__9873__auto__.call(null, coll);
    } else {
      var m__9873__auto____$1 = cljs.core._comparator["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__9873__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("ISorted.-comparator", coll);
      }
    }
  }
};
cljs.core.IWriter = function() {
};
cljs.core._write = function cljs$core$_write(writer, s) {
  if (!(writer == null) && !(writer.cljs$core$IWriter$_write$arity$2 == null)) {
    return writer.cljs$core$IWriter$_write$arity$2(writer, s);
  } else {
    var x__9872__auto__ = writer == null ? null : writer;
    var m__9873__auto__ = cljs.core._write[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$2(writer, s) : m__9873__auto__.call(null, writer, s);
    } else {
      var m__9873__auto____$1 = cljs.core._write["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2(writer, s) : m__9873__auto____$1.call(null, writer, s);
      } else {
        throw cljs.core.missing_protocol("IWriter.-write", writer);
      }
    }
  }
};
cljs.core._flush = function cljs$core$_flush(writer) {
  if (!(writer == null) && !(writer.cljs$core$IWriter$_flush$arity$1 == null)) {
    return writer.cljs$core$IWriter$_flush$arity$1(writer);
  } else {
    var x__9872__auto__ = writer == null ? null : writer;
    var m__9873__auto__ = cljs.core._flush[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$1(writer) : m__9873__auto__.call(null, writer);
    } else {
      var m__9873__auto____$1 = cljs.core._flush["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1(writer) : m__9873__auto____$1.call(null, writer);
      } else {
        throw cljs.core.missing_protocol("IWriter.-flush", writer);
      }
    }
  }
};
cljs.core.IPrintWithWriter = function() {
};
cljs.core._pr_writer = function cljs$core$_pr_writer(o, writer, opts) {
  if (!(o == null) && !(o.cljs$core$IPrintWithWriter$_pr_writer$arity$3 == null)) {
    return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o, writer, opts);
  } else {
    var x__9872__auto__ = o == null ? null : o;
    var m__9873__auto__ = cljs.core._pr_writer[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$3 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$3(o, writer, opts) : m__9873__auto__.call(null, o, writer, opts);
    } else {
      var m__9873__auto____$1 = cljs.core._pr_writer["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$3(o, writer, opts) : m__9873__auto____$1.call(null, o, writer, opts);
      } else {
        throw cljs.core.missing_protocol("IPrintWithWriter.-pr-writer", o);
      }
    }
  }
};
cljs.core.IPending = function() {
};
cljs.core._realized_QMARK_ = function cljs$core$_realized_QMARK_(x) {
  if (!(x == null) && !(x.cljs$core$IPending$_realized_QMARK_$arity$1 == null)) {
    return x.cljs$core$IPending$_realized_QMARK_$arity$1(x);
  } else {
    var x__9872__auto__ = x == null ? null : x;
    var m__9873__auto__ = cljs.core._realized_QMARK_[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__9873__auto__.call(null, x);
    } else {
      var m__9873__auto____$1 = cljs.core._realized_QMARK_["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__9873__auto____$1.call(null, x);
      } else {
        throw cljs.core.missing_protocol("IPending.-realized?", x);
      }
    }
  }
};
cljs.core.IWatchable = function() {
};
cljs.core._notify_watches = function cljs$core$_notify_watches(this$, oldval, newval) {
  if (!(this$ == null) && !(this$.cljs$core$IWatchable$_notify_watches$arity$3 == null)) {
    return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$, oldval, newval);
  } else {
    var x__9872__auto__ = this$ == null ? null : this$;
    var m__9873__auto__ = cljs.core._notify_watches[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$3 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$3(this$, oldval, newval) : m__9873__auto__.call(null, this$, oldval, newval);
    } else {
      var m__9873__auto____$1 = cljs.core._notify_watches["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$3(this$, oldval, newval) : m__9873__auto____$1.call(null, this$, oldval, newval);
      } else {
        throw cljs.core.missing_protocol("IWatchable.-notify-watches", this$);
      }
    }
  }
};
cljs.core._add_watch = function cljs$core$_add_watch(this$, key, f) {
  if (!(this$ == null) && !(this$.cljs$core$IWatchable$_add_watch$arity$3 == null)) {
    return this$.cljs$core$IWatchable$_add_watch$arity$3(this$, key, f);
  } else {
    var x__9872__auto__ = this$ == null ? null : this$;
    var m__9873__auto__ = cljs.core._add_watch[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$3 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$3(this$, key, f) : m__9873__auto__.call(null, this$, key, f);
    } else {
      var m__9873__auto____$1 = cljs.core._add_watch["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$3(this$, key, f) : m__9873__auto____$1.call(null, this$, key, f);
      } else {
        throw cljs.core.missing_protocol("IWatchable.-add-watch", this$);
      }
    }
  }
};
cljs.core._remove_watch = function cljs$core$_remove_watch(this$, key) {
  if (!(this$ == null) && !(this$.cljs$core$IWatchable$_remove_watch$arity$2 == null)) {
    return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$, key);
  } else {
    var x__9872__auto__ = this$ == null ? null : this$;
    var m__9873__auto__ = cljs.core._remove_watch[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$2(this$, key) : m__9873__auto__.call(null, this$, key);
    } else {
      var m__9873__auto____$1 = cljs.core._remove_watch["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2(this$, key) : m__9873__auto____$1.call(null, this$, key);
      } else {
        throw cljs.core.missing_protocol("IWatchable.-remove-watch", this$);
      }
    }
  }
};
cljs.core.IEditableCollection = function() {
};
cljs.core._as_transient = function cljs$core$_as_transient(coll) {
  if (!(coll == null) && !(coll.cljs$core$IEditableCollection$_as_transient$arity$1 == null)) {
    return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);
  } else {
    var x__9872__auto__ = coll == null ? null : coll;
    var m__9873__auto__ = cljs.core._as_transient[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__9873__auto__.call(null, coll);
    } else {
      var m__9873__auto____$1 = cljs.core._as_transient["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__9873__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IEditableCollection.-as-transient", coll);
      }
    }
  }
};
cljs.core.ITransientCollection = function() {
};
cljs.core._conj_BANG_ = function cljs$core$_conj_BANG_(tcoll, val) {
  if (!(tcoll == null) && !(tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2 == null)) {
    return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll, val);
  } else {
    var x__9872__auto__ = tcoll == null ? null : tcoll;
    var m__9873__auto__ = cljs.core._conj_BANG_[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$2(tcoll, val) : m__9873__auto__.call(null, tcoll, val);
    } else {
      var m__9873__auto____$1 = cljs.core._conj_BANG_["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2(tcoll, val) : m__9873__auto____$1.call(null, tcoll, val);
      } else {
        throw cljs.core.missing_protocol("ITransientCollection.-conj!", tcoll);
      }
    }
  }
};
cljs.core._persistent_BANG_ = function cljs$core$_persistent_BANG_(tcoll) {
  if (!(tcoll == null) && !(tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 == null)) {
    return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);
  } else {
    var x__9872__auto__ = tcoll == null ? null : tcoll;
    var m__9873__auto__ = cljs.core._persistent_BANG_[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__9873__auto__.call(null, tcoll);
    } else {
      var m__9873__auto____$1 = cljs.core._persistent_BANG_["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1(tcoll) : m__9873__auto____$1.call(null, tcoll);
      } else {
        throw cljs.core.missing_protocol("ITransientCollection.-persistent!", tcoll);
      }
    }
  }
};
cljs.core.ITransientAssociative = function() {
};
cljs.core._assoc_BANG_ = function cljs$core$_assoc_BANG_(tcoll, key, val) {
  if (!(tcoll == null) && !(tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 == null)) {
    return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll, key, val);
  } else {
    var x__9872__auto__ = tcoll == null ? null : tcoll;
    var m__9873__auto__ = cljs.core._assoc_BANG_[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$3 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$3(tcoll, key, val) : m__9873__auto__.call(null, tcoll, key, val);
    } else {
      var m__9873__auto____$1 = cljs.core._assoc_BANG_["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$3(tcoll, key, val) : m__9873__auto____$1.call(null, tcoll, key, val);
      } else {
        throw cljs.core.missing_protocol("ITransientAssociative.-assoc!", tcoll);
      }
    }
  }
};
cljs.core.ITransientMap = function() {
};
cljs.core._dissoc_BANG_ = function cljs$core$_dissoc_BANG_(tcoll, key) {
  if (!(tcoll == null) && !(tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 == null)) {
    return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll, key);
  } else {
    var x__9872__auto__ = tcoll == null ? null : tcoll;
    var m__9873__auto__ = cljs.core._dissoc_BANG_[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$2(tcoll, key) : m__9873__auto__.call(null, tcoll, key);
    } else {
      var m__9873__auto____$1 = cljs.core._dissoc_BANG_["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2(tcoll, key) : m__9873__auto____$1.call(null, tcoll, key);
      } else {
        throw cljs.core.missing_protocol("ITransientMap.-dissoc!", tcoll);
      }
    }
  }
};
cljs.core.ITransientVector = function() {
};
cljs.core._assoc_n_BANG_ = function cljs$core$_assoc_n_BANG_(tcoll, n, val) {
  if (!(tcoll == null) && !(tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 == null)) {
    return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll, n, val);
  } else {
    var x__9872__auto__ = tcoll == null ? null : tcoll;
    var m__9873__auto__ = cljs.core._assoc_n_BANG_[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$3 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$3(tcoll, n, val) : m__9873__auto__.call(null, tcoll, n, val);
    } else {
      var m__9873__auto____$1 = cljs.core._assoc_n_BANG_["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$3(tcoll, n, val) : m__9873__auto____$1.call(null, tcoll, n, val);
      } else {
        throw cljs.core.missing_protocol("ITransientVector.-assoc-n!", tcoll);
      }
    }
  }
};
cljs.core._pop_BANG_ = function cljs$core$_pop_BANG_(tcoll) {
  if (!(tcoll == null) && !(tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1 == null)) {
    return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);
  } else {
    var x__9872__auto__ = tcoll == null ? null : tcoll;
    var m__9873__auto__ = cljs.core._pop_BANG_[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__9873__auto__.call(null, tcoll);
    } else {
      var m__9873__auto____$1 = cljs.core._pop_BANG_["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1(tcoll) : m__9873__auto____$1.call(null, tcoll);
      } else {
        throw cljs.core.missing_protocol("ITransientVector.-pop!", tcoll);
      }
    }
  }
};
cljs.core.ITransientSet = function() {
};
cljs.core._disjoin_BANG_ = function cljs$core$_disjoin_BANG_(tcoll, v) {
  if (!(tcoll == null) && !(tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 == null)) {
    return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll, v);
  } else {
    var x__9872__auto__ = tcoll == null ? null : tcoll;
    var m__9873__auto__ = cljs.core._disjoin_BANG_[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$2(tcoll, v) : m__9873__auto__.call(null, tcoll, v);
    } else {
      var m__9873__auto____$1 = cljs.core._disjoin_BANG_["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2(tcoll, v) : m__9873__auto____$1.call(null, tcoll, v);
      } else {
        throw cljs.core.missing_protocol("ITransientSet.-disjoin!", tcoll);
      }
    }
  }
};
cljs.core.IComparable = function() {
};
cljs.core._compare = function cljs$core$_compare(x, y) {
  if (!(x == null) && !(x.cljs$core$IComparable$_compare$arity$2 == null)) {
    return x.cljs$core$IComparable$_compare$arity$2(x, y);
  } else {
    var x__9872__auto__ = x == null ? null : x;
    var m__9873__auto__ = cljs.core._compare[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$2(x, y) : m__9873__auto__.call(null, x, y);
    } else {
      var m__9873__auto____$1 = cljs.core._compare["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2(x, y) : m__9873__auto____$1.call(null, x, y);
      } else {
        throw cljs.core.missing_protocol("IComparable.-compare", x);
      }
    }
  }
};
cljs.core.IChunk = function() {
};
cljs.core._drop_first = function cljs$core$_drop_first(coll) {
  if (!(coll == null) && !(coll.cljs$core$IChunk$_drop_first$arity$1 == null)) {
    return coll.cljs$core$IChunk$_drop_first$arity$1(coll);
  } else {
    var x__9872__auto__ = coll == null ? null : coll;
    var m__9873__auto__ = cljs.core._drop_first[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__9873__auto__.call(null, coll);
    } else {
      var m__9873__auto____$1 = cljs.core._drop_first["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__9873__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IChunk.-drop-first", coll);
      }
    }
  }
};
cljs.core.IChunkedSeq = function() {
};
cljs.core._chunked_first = function cljs$core$_chunked_first(coll) {
  if (!(coll == null) && !(coll.cljs$core$IChunkedSeq$_chunked_first$arity$1 == null)) {
    return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);
  } else {
    var x__9872__auto__ = coll == null ? null : coll;
    var m__9873__auto__ = cljs.core._chunked_first[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__9873__auto__.call(null, coll);
    } else {
      var m__9873__auto____$1 = cljs.core._chunked_first["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__9873__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IChunkedSeq.-chunked-first", coll);
      }
    }
  }
};
cljs.core._chunked_rest = function cljs$core$_chunked_rest(coll) {
  if (!(coll == null) && !(coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1 == null)) {
    return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);
  } else {
    var x__9872__auto__ = coll == null ? null : coll;
    var m__9873__auto__ = cljs.core._chunked_rest[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__9873__auto__.call(null, coll);
    } else {
      var m__9873__auto____$1 = cljs.core._chunked_rest["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__9873__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IChunkedSeq.-chunked-rest", coll);
      }
    }
  }
};
cljs.core.IChunkedNext = function() {
};
cljs.core._chunked_next = function cljs$core$_chunked_next(coll) {
  if (!(coll == null) && !(coll.cljs$core$IChunkedNext$_chunked_next$arity$1 == null)) {
    return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);
  } else {
    var x__9872__auto__ = coll == null ? null : coll;
    var m__9873__auto__ = cljs.core._chunked_next[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__9873__auto__.call(null, coll);
    } else {
      var m__9873__auto____$1 = cljs.core._chunked_next["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__9873__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IChunkedNext.-chunked-next", coll);
      }
    }
  }
};
cljs.core.INamed = function() {
};
cljs.core._name = function cljs$core$_name(x) {
  if (!(x == null) && !(x.cljs$core$INamed$_name$arity$1 == null)) {
    return x.cljs$core$INamed$_name$arity$1(x);
  } else {
    var x__9872__auto__ = x == null ? null : x;
    var m__9873__auto__ = cljs.core._name[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__9873__auto__.call(null, x);
    } else {
      var m__9873__auto____$1 = cljs.core._name["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__9873__auto____$1.call(null, x);
      } else {
        throw cljs.core.missing_protocol("INamed.-name", x);
      }
    }
  }
};
cljs.core._namespace = function cljs$core$_namespace(x) {
  if (!(x == null) && !(x.cljs$core$INamed$_namespace$arity$1 == null)) {
    return x.cljs$core$INamed$_namespace$arity$1(x);
  } else {
    var x__9872__auto__ = x == null ? null : x;
    var m__9873__auto__ = cljs.core._namespace[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__9873__auto__.call(null, x);
    } else {
      var m__9873__auto____$1 = cljs.core._namespace["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__9873__auto____$1.call(null, x);
      } else {
        throw cljs.core.missing_protocol("INamed.-namespace", x);
      }
    }
  }
};
cljs.core.IAtom = function() {
};
cljs.core.IReset = function() {
};
cljs.core._reset_BANG_ = function cljs$core$_reset_BANG_(o, new_value) {
  if (!(o == null) && !(o.cljs$core$IReset$_reset_BANG_$arity$2 == null)) {
    return o.cljs$core$IReset$_reset_BANG_$arity$2(o, new_value);
  } else {
    var x__9872__auto__ = o == null ? null : o;
    var m__9873__auto__ = cljs.core._reset_BANG_[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$2(o, new_value) : m__9873__auto__.call(null, o, new_value);
    } else {
      var m__9873__auto____$1 = cljs.core._reset_BANG_["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2(o, new_value) : m__9873__auto____$1.call(null, o, new_value);
      } else {
        throw cljs.core.missing_protocol("IReset.-reset!", o);
      }
    }
  }
};
cljs.core.ISwap = function() {
};
cljs.core._swap_BANG_ = function cljs$core$_swap_BANG_(var_args) {
  var args45997 = [];
  var len__10375__auto___46000 = arguments.length;
  var i__10376__auto___46001 = 0;
  while (true) {
    if (i__10376__auto___46001 < len__10375__auto___46000) {
      args45997.push(arguments[i__10376__auto___46001]);
      var G__46002 = i__10376__auto___46001 + 1;
      i__10376__auto___46001 = G__46002;
      continue;
    } else {
    }
    break;
  }
  var G__45999 = args45997.length;
  switch(G__45999) {
    case 2:
      return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args45997.length)].join(""));
  }
};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2 = function(o, f) {
  if (!(o == null) && !(o.cljs$core$ISwap$_swap_BANG_$arity$2 == null)) {
    return o.cljs$core$ISwap$_swap_BANG_$arity$2(o, f);
  } else {
    var x__9872__auto__ = o == null ? null : o;
    var m__9873__auto__ = cljs.core._swap_BANG_[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$2(o, f) : m__9873__auto__.call(null, o, f);
    } else {
      var m__9873__auto____$1 = cljs.core._swap_BANG_["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2(o, f) : m__9873__auto____$1.call(null, o, f);
      } else {
        throw cljs.core.missing_protocol("ISwap.-swap!", o);
      }
    }
  }
};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3 = function(o, f, a) {
  if (!(o == null) && !(o.cljs$core$ISwap$_swap_BANG_$arity$3 == null)) {
    return o.cljs$core$ISwap$_swap_BANG_$arity$3(o, f, a);
  } else {
    var x__9872__auto__ = o == null ? null : o;
    var m__9873__auto__ = cljs.core._swap_BANG_[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$3 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$3(o, f, a) : m__9873__auto__.call(null, o, f, a);
    } else {
      var m__9873__auto____$1 = cljs.core._swap_BANG_["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$3(o, f, a) : m__9873__auto____$1.call(null, o, f, a);
      } else {
        throw cljs.core.missing_protocol("ISwap.-swap!", o);
      }
    }
  }
};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4 = function(o, f, a, b) {
  if (!(o == null) && !(o.cljs$core$ISwap$_swap_BANG_$arity$4 == null)) {
    return o.cljs$core$ISwap$_swap_BANG_$arity$4(o, f, a, b);
  } else {
    var x__9872__auto__ = o == null ? null : o;
    var m__9873__auto__ = cljs.core._swap_BANG_[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$4 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$4(o, f, a, b) : m__9873__auto__.call(null, o, f, a, b);
    } else {
      var m__9873__auto____$1 = cljs.core._swap_BANG_["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$4(o, f, a, b) : m__9873__auto____$1.call(null, o, f, a, b);
      } else {
        throw cljs.core.missing_protocol("ISwap.-swap!", o);
      }
    }
  }
};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5 = function(o, f, a, b, xs) {
  if (!(o == null) && !(o.cljs$core$ISwap$_swap_BANG_$arity$5 == null)) {
    return o.cljs$core$ISwap$_swap_BANG_$arity$5(o, f, a, b, xs);
  } else {
    var x__9872__auto__ = o == null ? null : o;
    var m__9873__auto__ = cljs.core._swap_BANG_[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$5 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$5(o, f, a, b, xs) : m__9873__auto__.call(null, o, f, a, b, xs);
    } else {
      var m__9873__auto____$1 = cljs.core._swap_BANG_["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$5 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$5(o, f, a, b, xs) : m__9873__auto____$1.call(null, o, f, a, b, xs);
      } else {
        throw cljs.core.missing_protocol("ISwap.-swap!", o);
      }
    }
  }
};
cljs.core._swap_BANG_.cljs$lang$maxFixedArity = 5;
cljs.core.IVolatile = function() {
};
cljs.core._vreset_BANG_ = function cljs$core$_vreset_BANG_(o, new_value) {
  if (!(o == null) && !(o.cljs$core$IVolatile$_vreset_BANG_$arity$2 == null)) {
    return o.cljs$core$IVolatile$_vreset_BANG_$arity$2(o, new_value);
  } else {
    var x__9872__auto__ = o == null ? null : o;
    var m__9873__auto__ = cljs.core._vreset_BANG_[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$2(o, new_value) : m__9873__auto__.call(null, o, new_value);
    } else {
      var m__9873__auto____$1 = cljs.core._vreset_BANG_["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$2(o, new_value) : m__9873__auto____$1.call(null, o, new_value);
      } else {
        throw cljs.core.missing_protocol("IVolatile.-vreset!", o);
      }
    }
  }
};
cljs.core.IIterable = function() {
};
cljs.core._iterator = function cljs$core$_iterator(coll) {
  if (!(coll == null) && !(coll.cljs$core$IIterable$_iterator$arity$1 == null)) {
    return coll.cljs$core$IIterable$_iterator$arity$1(coll);
  } else {
    var x__9872__auto__ = coll == null ? null : coll;
    var m__9873__auto__ = cljs.core._iterator[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__9873__auto__.call(null, coll);
    } else {
      var m__9873__auto____$1 = cljs.core._iterator["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__9873__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IIterable.-iterator", coll);
      }
    }
  }
};
cljs.core.StringBufferWriter = function(sb) {
  this.sb = sb;
  this.cljs$lang$protocol_mask$partition0$ = 1073741824;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2 = function(_, s) {
  var self__ = this;
  var ___$1 = this;
  return self__.sb.append(s);
};
cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return null;
};
cljs.core.StringBufferWriter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "sb", "sb", -1249746442, null)], null);
};
cljs.core.StringBufferWriter.cljs$lang$type = true;
cljs.core.StringBufferWriter.cljs$lang$ctorStr = "cljs.core/StringBufferWriter";
cljs.core.StringBufferWriter.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/StringBufferWriter");
};
cljs.core.__GT_StringBufferWriter = function cljs$core$__GT_StringBufferWriter(sb) {
  return new cljs.core.StringBufferWriter(sb);
};
cljs.core.pr_str_STAR_ = function cljs$core$pr_str_STAR_(obj) {
  var sb = new goog.string.StringBuffer;
  var writer = new cljs.core.StringBufferWriter(sb);
  obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null, writer, cljs.core.pr_opts());
  writer.cljs$core$IWriter$_flush$arity$1(null);
  return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb)].join("");
};
cljs.core.int_rotate_left = function cljs$core$int_rotate_left(x, n) {
  return x << n | x >>> -n;
};
if (typeof Math.imul !== "undefined" && !(Math.imul(4294967295, 5) === 0)) {
  cljs.core.imul = function cljs$core$imul(a, b) {
    return Math.imul(a, b);
  };
} else {
  cljs.core.imul = function cljs$core$imul(a, b) {
    var ah = a >>> 16 & 65535;
    var al = a & 65535;
    var bh = b >>> 16 & 65535;
    var bl = b & 65535;
    return al * bl + (ah * bl + al * bh << 16 >>> 0) | 0;
  };
}
cljs.core.m3_seed = 0;
cljs.core.m3_C1 = 3432918353 | 0;
cljs.core.m3_C2 = 461845907 | 0;
cljs.core.m3_mix_K1 = function cljs$core$m3_mix_K1(k1) {
  return cljs.core.imul(cljs.core.int_rotate_left(cljs.core.imul(k1 | 0, cljs.core.m3_C1), 15), cljs.core.m3_C2);
};
cljs.core.m3_mix_H1 = function cljs$core$m3_mix_H1(h1, k1) {
  return cljs.core.imul(cljs.core.int_rotate_left((h1 | 0) ^ (k1 | 0), 13), 5) + (3864292196 | 0) | 0;
};
cljs.core.m3_fmix = function cljs$core$m3_fmix(h1, len) {
  var h1__$1 = h1 | 0;
  var h1__$2 = h1__$1 ^ len;
  var h1__$3 = h1__$2 ^ h1__$2 >>> 16;
  var h1__$4 = cljs.core.imul(h1__$3, 2246822507 | 0);
  var h1__$5 = h1__$4 ^ h1__$4 >>> 13;
  var h1__$6 = cljs.core.imul(h1__$5, 3266489909 | 0);
  return h1__$6 ^ h1__$6 >>> 16;
};
cljs.core.m3_hash_int = function cljs$core$m3_hash_int(in$) {
  if (in$ === 0) {
    return in$;
  } else {
    var k1 = cljs.core.m3_mix_K1(in$);
    var h1 = cljs.core.m3_mix_H1(cljs.core.m3_seed, k1);
    return cljs.core.m3_fmix(h1, 4);
  }
};
cljs.core.m3_hash_unencoded_chars = function cljs$core$m3_hash_unencoded_chars(in$) {
  var h1 = function() {
    var i = 1;
    var h1 = cljs.core.m3_seed;
    while (true) {
      if (i < in$.length) {
        var G__46004 = i + 2;
        var G__46005 = cljs.core.m3_mix_H1(h1, cljs.core.m3_mix_K1(in$.charCodeAt(i - 1) | in$.charCodeAt(i) << 16));
        i = G__46004;
        h1 = G__46005;
        continue;
      } else {
        return h1;
      }
      break;
    }
  }();
  var h1__$1 = (in$.length & 1) === 1 ? h1 ^ cljs.core.m3_mix_K1(in$.charCodeAt(in$.length - 1)) : h1;
  return cljs.core.m3_fmix(h1__$1, cljs.core.imul(2, in$.length));
};
cljs.core.string_hash_cache = {};
cljs.core.string_hash_cache_count = 0;
cljs.core.hash_string_STAR_ = function cljs$core$hash_string_STAR_(s) {
  if (!(s == null)) {
    var len = s.length;
    if (len > 0) {
      var i = 0;
      var hash = 0;
      while (true) {
        if (i < len) {
          var G__46008 = i + 1;
          var G__46009 = cljs.core.imul(31, hash) + s.charCodeAt(i);
          i = G__46008;
          hash = G__46009;
          continue;
        } else {
          return hash;
        }
        break;
      }
    } else {
      return 0;
    }
  } else {
    return 0;
  }
};
cljs.core.add_to_string_hash_cache = function cljs$core$add_to_string_hash_cache(k) {
  var h = cljs.core.hash_string_STAR_(k);
  cljs.core.string_hash_cache[k] = h;
  cljs.core.string_hash_cache_count = cljs.core.string_hash_cache_count + 1;
  return h;
};
cljs.core.hash_string = function cljs$core$hash_string(k) {
  if (cljs.core.string_hash_cache_count > 255) {
    cljs.core.string_hash_cache = {};
    cljs.core.string_hash_cache_count = 0;
  } else {
  }
  if (k == null) {
    return 0;
  } else {
    var h = cljs.core.string_hash_cache[k];
    if (typeof h === "number") {
      return h;
    } else {
      return cljs.core.add_to_string_hash_cache(k);
    }
  }
};
cljs.core.hash = function cljs$core$hash(o) {
  if (!(o == null) ? o.cljs$lang$protocol_mask$partition0$ & 4194304 || cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IHash$ ? true : false : false) {
    return o.cljs$core$IHash$_hash$arity$1(null) ^ 0;
  } else {
    if (typeof o === "number") {
      if (cljs.core.truth_(isFinite(o))) {
        return Math.floor(o) % 2147483647;
      } else {
        var G__46017 = o;
        switch(G__46017) {
          case Infinity:
            return 2146435072;
            break;
          case -Infinity:
            return -1048576;
            break;
          default:
            return 2146959360;
        }
      }
    } else {
      if (o === true) {
        return 1231;
      } else {
        if (o === false) {
          return 1237;
        } else {
          if (typeof o === "string") {
            return cljs.core.m3_hash_int(cljs.core.hash_string(o));
          } else {
            if (o instanceof Date) {
              return o.valueOf() ^ 0;
            } else {
              if (o == null) {
                return 0;
              } else {
                return cljs.core._hash(o) ^ 0;
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.hash_combine = function cljs$core$hash_combine(seed, hash) {
  return seed ^ hash + 2654435769 + (seed << 6) + (seed >> 2);
};
cljs.core.instance_QMARK_ = function cljs$core$instance_QMARK_(c, x) {
  return x instanceof c;
};
cljs.core.symbol_QMARK_ = function cljs$core$symbol_QMARK_(x) {
  return x instanceof cljs.core.Symbol;
};
cljs.core.hash_symbol = function cljs$core$hash_symbol(sym) {
  return cljs.core.hash_combine(cljs.core.m3_hash_unencoded_chars(sym.name), cljs.core.hash_string(sym.ns));
};
cljs.core.compare_symbols = function cljs$core$compare_symbols(a, b) {
  if (a.str === b.str) {
    return 0;
  } else {
    if (cljs.core.truth_(function() {
      var and__9142__auto__ = cljs.core.not(a.ns);
      if (and__9142__auto__) {
        return b.ns;
      } else {
        return and__9142__auto__;
      }
    }())) {
      return -1;
    } else {
      if (cljs.core.truth_(a.ns)) {
        if (cljs.core.not(b.ns)) {
          return 1;
        } else {
          var nsc = function() {
            var G__46025 = a.ns;
            var G__46026 = b.ns;
            return goog.array.defaultCompare(G__46025, G__46026);
          }();
          if (0 === nsc) {
            var G__46027 = a.name;
            var G__46028 = b.name;
            return goog.array.defaultCompare(G__46027, G__46028);
          } else {
            return nsc;
          }
        }
      } else {
        var G__46029 = a.name;
        var G__46030 = b.name;
        return goog.array.defaultCompare(G__46029, G__46030);
      }
    }
  }
};
cljs.core.Symbol = function(ns, name, str, _hash, _meta) {
  this.ns = ns;
  this.name = name;
  this.str = str;
  this._hash = _hash;
  this._meta = _meta;
  this.cljs$lang$protocol_mask$partition0$ = 2154168321;
  this.cljs$lang$protocol_mask$partition1$ = 4096;
};
cljs.core.Symbol.prototype.toString = function() {
  var self__ = this;
  var _ = this;
  return self__.str;
};
cljs.core.Symbol.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(_, other) {
  var self__ = this;
  var ___$1 = this;
  if (other instanceof cljs.core.Symbol) {
    return self__.str === other.str;
  } else {
    return false;
  }
};
cljs.core.Symbol.prototype.call = function() {
  var G__46032 = null;
  var G__46032__2 = function(self__, coll) {
    var self__ = this;
    var self____$1 = this;
    var sym = self____$1;
    return cljs.core.get.cljs$core$IFn$_invoke$arity$2 ? cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, sym) : cljs.core.get.call(null, coll, sym);
  };
  var G__46032__3 = function(self__, coll, not_found) {
    var self__ = this;
    var self____$1 = this;
    var sym = self____$1;
    return cljs.core.get.cljs$core$IFn$_invoke$arity$3 ? cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, sym, not_found) : cljs.core.get.call(null, coll, sym, not_found);
  };
  G__46032 = function(self__, coll, not_found) {
    switch(arguments.length) {
      case 2:
        return G__46032__2.call(this, self__, coll);
      case 3:
        return G__46032__3.call(this, self__, coll, not_found);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__46032.cljs$core$IFn$_invoke$arity$2 = G__46032__2;
  G__46032.cljs$core$IFn$_invoke$arity$3 = G__46032__3;
  return G__46032;
}();
cljs.core.Symbol.prototype.apply = function(self__, args46031) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args46031)));
};
cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  var self__ = this;
  var sym = this;
  return cljs.core.get.cljs$core$IFn$_invoke$arity$2 ? cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, sym) : cljs.core.get.call(null, coll, sym);
};
cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2 = function(coll, not_found) {
  var self__ = this;
  var sym = this;
  return cljs.core.get.cljs$core$IFn$_invoke$arity$3 ? cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, sym, not_found) : cljs.core.get.call(null, coll, sym, not_found);
};
cljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__._meta;
};
cljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(_, new_meta) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.Symbol(self__.ns, self__.name, self__.str, self__._hash, new_meta);
};
cljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1 = function(sym) {
  var self__ = this;
  var sym__$1 = this;
  var h__9596__auto__ = self__._hash;
  if (!(h__9596__auto__ == null)) {
    return h__9596__auto__;
  } else {
    var h__9596__auto____$1 = cljs.core.hash_symbol(sym__$1);
    self__._hash = h__9596__auto____$1;
    return h__9596__auto____$1;
  }
};
cljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.name;
};
cljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.ns;
};
cljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = function(o, writer, _) {
  var self__ = this;
  var o__$1 = this;
  return cljs.core._write(writer, self__.str);
};
cljs.core.Symbol.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "ns", "ns", 2082130287, null), new cljs.core.Symbol(null, "name", "name", -810760592, null), new cljs.core.Symbol(null, "str", "str", -1564826950, null), cljs.core.with_meta(new cljs.core.Symbol(null, "_hash", "_hash", -2130838312, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), new cljs.core.Symbol(null, 
  "_meta", "_meta", -1716892533, null)], null);
};
cljs.core.Symbol.cljs$lang$type = true;
cljs.core.Symbol.cljs$lang$ctorStr = "cljs.core/Symbol";
cljs.core.Symbol.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/Symbol");
};
cljs.core.__GT_Symbol = function cljs$core$__GT_Symbol(ns, name, str, _hash, _meta) {
  return new cljs.core.Symbol(ns, name, str, _hash, _meta);
};
cljs.core.symbol = function cljs$core$symbol(var_args) {
  var args46033 = [];
  var len__10375__auto___46036 = arguments.length;
  var i__10376__auto___46037 = 0;
  while (true) {
    if (i__10376__auto___46037 < len__10375__auto___46036) {
      args46033.push(arguments[i__10376__auto___46037]);
      var G__46038 = i__10376__auto___46037 + 1;
      i__10376__auto___46037 = G__46038;
      continue;
    } else {
    }
    break;
  }
  var G__46035 = args46033.length;
  switch(G__46035) {
    case 1:
      return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args46033.length)].join(""));
  }
};
cljs.core.symbol.cljs$core$IFn$_invoke$arity$1 = function(name) {
  if (name instanceof cljs.core.Symbol) {
    return name;
  } else {
    var idx = name.indexOf("/");
    if (idx < 1) {
      return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(null, name);
    } else {
      return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(name.substring(0, idx), name.substring(idx + 1, name.length));
    }
  }
};
cljs.core.symbol.cljs$core$IFn$_invoke$arity$2 = function(ns, name) {
  var sym_str = !(ns == null) ? [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns), cljs.core.str.cljs$core$IFn$_invoke$arity$1("/"), cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join("") : name;
  return new cljs.core.Symbol(ns, name, sym_str, null, null);
};
cljs.core.symbol.cljs$lang$maxFixedArity = 2;
cljs.core.Var = function(val, sym, _meta) {
  this.val = val;
  this.sym = sym;
  this._meta = _meta;
  this.cljs$lang$protocol_mask$partition0$ = 6717441;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.Var.prototype.isMacro = function() {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).cljs$lang$macro;
};
cljs.core.Var.prototype.toString = function() {
  var self__ = this;
  var _ = this;
  return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("#'"), cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.sym)].join("");
};
cljs.core.Var.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
};
cljs.core.Var.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__._meta;
};
cljs.core.Var.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(_, new_meta) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.Var(self__.val, self__.sym, new_meta);
};
cljs.core.Var.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(this$, other) {
  var self__ = this;
  var this$__$1 = this;
  if (other instanceof cljs.core.Var) {
    var G__46041 = this$__$1.sym;
    var G__46042 = other.sym;
    return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 ? cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(G__46041, G__46042) : cljs.core._EQ_.call(null, G__46041, G__46042);
  } else {
    return false;
  }
};
cljs.core.Var.prototype.cljs$core$IHash$_hash$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return cljs.core.hash_symbol(self__.sym);
};
cljs.core.Var.prototype.cljs$core$Fn$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.Var.prototype.call = function() {
  var G__46087 = null;
  var G__46087__1 = function(self__) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null);
  };
  var G__46087__2 = function(self__, a) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a);
  };
  var G__46087__3 = function(self__, a, b) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b);
  };
  var G__46087__4 = function(self__, a, b, c) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c);
  };
  var G__46087__5 = function(self__, a, b, c, d) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d);
  };
  var G__46087__6 = function(self__, a, b, c, d, e) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e);
  };
  var G__46087__7 = function(self__, a, b, c, d, e, f) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f);
  };
  var G__46087__8 = function(self__, a, b, c, d, e, f, g) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g);
  };
  var G__46087__9 = function(self__, a, b, c, d, e, f, g, h) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h);
  };
  var G__46087__10 = function(self__, a, b, c, d, e, f, g, h, i) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i);
  };
  var G__46087__11 = function(self__, a, b, c, d, e, f, g, h, i, j) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j);
  };
  var G__46087__12 = function(self__, a, b, c, d, e, f, g, h, i, j, k) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k);
  };
  var G__46087__13 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l);
  };
  var G__46087__14 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m);
  };
  var G__46087__15 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
  };
  var G__46087__16 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
  };
  var G__46087__17 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
  };
  var G__46087__18 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
  };
  var G__46087__19 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
  };
  var G__46087__20 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
  };
  var G__46087__21 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
  };
  var G__46087__22 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__46043 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    var G__46044 = a;
    var G__46045 = b;
    var G__46046 = c;
    var G__46047 = d;
    var G__46048 = e;
    var G__46049 = f;
    var G__46050 = g;
    var G__46051 = h;
    var G__46052 = i;
    var G__46053 = j;
    var G__46054 = k;
    var G__46055 = l;
    var G__46056 = m;
    var G__46057 = n;
    var G__46058 = o;
    var G__46059 = p;
    var G__46060 = q;
    var G__46061 = r;
    var G__46062 = s;
    var G__46063 = t;
    var G__46064 = rest;
    return cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__46043, G__46044, G__46045, G__46046, G__46047, G__46048, G__46049, G__46050, G__46051, G__46052, G__46053, G__46054, G__46055, G__46056, G__46057, G__46058, G__46059, G__46060, G__46061, G__46062, G__46063, G__46064) : cljs.core.apply.call(null, G__46043, G__46044, G__46045, G__46046, G__46047, G__46048, G__46049, G__46050, G__46051, G__46052, G__46053, G__46054, G__46055, G__46056, G__46057, 
    G__46058, G__46059, G__46060, G__46061, G__46062, G__46063, G__46064);
  };
  G__46087 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
    switch(arguments.length) {
      case 1:
        return G__46087__1.call(this, self__);
      case 2:
        return G__46087__2.call(this, self__, a);
      case 3:
        return G__46087__3.call(this, self__, a, b);
      case 4:
        return G__46087__4.call(this, self__, a, b, c);
      case 5:
        return G__46087__5.call(this, self__, a, b, c, d);
      case 6:
        return G__46087__6.call(this, self__, a, b, c, d, e);
      case 7:
        return G__46087__7.call(this, self__, a, b, c, d, e, f);
      case 8:
        return G__46087__8.call(this, self__, a, b, c, d, e, f, g);
      case 9:
        return G__46087__9.call(this, self__, a, b, c, d, e, f, g, h);
      case 10:
        return G__46087__10.call(this, self__, a, b, c, d, e, f, g, h, i);
      case 11:
        return G__46087__11.call(this, self__, a, b, c, d, e, f, g, h, i, j);
      case 12:
        return G__46087__12.call(this, self__, a, b, c, d, e, f, g, h, i, j, k);
      case 13:
        return G__46087__13.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l);
      case 14:
        return G__46087__14.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m);
      case 15:
        return G__46087__15.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      case 16:
        return G__46087__16.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      case 17:
        return G__46087__17.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      case 18:
        return G__46087__18.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      case 19:
        return G__46087__19.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
      case 20:
        return G__46087__20.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
      case 21:
        return G__46087__21.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
      case 22:
        return G__46087__22.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__46087.cljs$core$IFn$_invoke$arity$1 = G__46087__1;
  G__46087.cljs$core$IFn$_invoke$arity$2 = G__46087__2;
  G__46087.cljs$core$IFn$_invoke$arity$3 = G__46087__3;
  G__46087.cljs$core$IFn$_invoke$arity$4 = G__46087__4;
  G__46087.cljs$core$IFn$_invoke$arity$5 = G__46087__5;
  G__46087.cljs$core$IFn$_invoke$arity$6 = G__46087__6;
  G__46087.cljs$core$IFn$_invoke$arity$7 = G__46087__7;
  G__46087.cljs$core$IFn$_invoke$arity$8 = G__46087__8;
  G__46087.cljs$core$IFn$_invoke$arity$9 = G__46087__9;
  G__46087.cljs$core$IFn$_invoke$arity$10 = G__46087__10;
  G__46087.cljs$core$IFn$_invoke$arity$11 = G__46087__11;
  G__46087.cljs$core$IFn$_invoke$arity$12 = G__46087__12;
  G__46087.cljs$core$IFn$_invoke$arity$13 = G__46087__13;
  G__46087.cljs$core$IFn$_invoke$arity$14 = G__46087__14;
  G__46087.cljs$core$IFn$_invoke$arity$15 = G__46087__15;
  G__46087.cljs$core$IFn$_invoke$arity$16 = G__46087__16;
  G__46087.cljs$core$IFn$_invoke$arity$17 = G__46087__17;
  G__46087.cljs$core$IFn$_invoke$arity$18 = G__46087__18;
  G__46087.cljs$core$IFn$_invoke$arity$19 = G__46087__19;
  G__46087.cljs$core$IFn$_invoke$arity$20 = G__46087__20;
  G__46087.cljs$core$IFn$_invoke$arity$21 = G__46087__21;
  G__46087.cljs$core$IFn$_invoke$arity$22 = G__46087__22;
  return G__46087;
}();
cljs.core.Var.prototype.apply = function(self__, args46040) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args46040)));
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$0 = function() {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$1 = function(a) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$2 = function(a, b) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$3 = function(a, b, c) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$4 = function(a, b, c, d) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$5 = function(a, b, c, d, e) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$6 = function(a, b, c, d, e, f) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$7 = function(a, b, c, d, e, f, g) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$8 = function(a, b, c, d, e, f, g, h) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$9 = function(a, b, c, d, e, f, g, h, i) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$10 = function(a, b, c, d, e, f, g, h, i, j) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$11 = function(a, b, c, d, e, f, g, h, i, j, k) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$12 = function(a, b, c, d, e, f, g, h, i, j, k, l) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$13 = function(a, b, c, d, e, f, g, h, i, j, k, l, m) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$14 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$15 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$16 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$17 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$18 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$19 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$20 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$21 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
  var self__ = this;
  var _ = this;
  var G__46065 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  var G__46066 = a;
  var G__46067 = b;
  var G__46068 = c;
  var G__46069 = d;
  var G__46070 = e;
  var G__46071 = f;
  var G__46072 = g;
  var G__46073 = h;
  var G__46074 = i;
  var G__46075 = j;
  var G__46076 = k;
  var G__46077 = l;
  var G__46078 = m;
  var G__46079 = n;
  var G__46080 = o;
  var G__46081 = p;
  var G__46082 = q;
  var G__46083 = r;
  var G__46084 = s;
  var G__46085 = t;
  var G__46086 = rest;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__46065, G__46066, G__46067, G__46068, G__46069, G__46070, G__46071, G__46072, G__46073, G__46074, G__46075, G__46076, G__46077, G__46078, G__46079, G__46080, G__46081, G__46082, G__46083, G__46084, G__46085, G__46086) : cljs.core.apply.call(null, G__46065, G__46066, G__46067, G__46068, G__46069, G__46070, G__46071, G__46072, G__46073, G__46074, G__46075, G__46076, G__46077, G__46078, G__46079, 
  G__46080, G__46081, G__46082, G__46083, G__46084, G__46085, G__46086);
};
cljs.core.Var.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "val", "val", 1769233139, null), new cljs.core.Symbol(null, "sym", "sym", 195671222, null), new cljs.core.Symbol(null, "_meta", "_meta", -1716892533, null)], null);
};
cljs.core.Var.cljs$lang$type = true;
cljs.core.Var.cljs$lang$ctorStr = "cljs.core/Var";
cljs.core.Var.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/Var");
};
cljs.core.__GT_Var = function cljs$core$__GT_Var(val, sym, _meta) {
  return new cljs.core.Var(val, sym, _meta);
};
cljs.core.var_QMARK_ = function cljs$core$var_QMARK_(v) {
  return v instanceof cljs.core.Var;
};
cljs.core.iterable_QMARK_ = function cljs$core$iterable_QMARK_(x) {
  if (!(x == null)) {
    if (false || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IIterable$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable, x);
  }
};
cljs.core.clone = function cljs$core$clone(value) {
  return cljs.core._clone(value);
};
cljs.core.cloneable_QMARK_ = function cljs$core$cloneable_QMARK_(value) {
  if (!(value == null)) {
    if (value.cljs$lang$protocol_mask$partition1$ & 8192 || cljs.core.PROTOCOL_SENTINEL === value.cljs$core$ICloneable$) {
      return true;
    } else {
      if (!value.cljs$lang$protocol_mask$partition1$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable, value);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable, value);
  }
};
cljs.core.seq = function cljs$core$seq(coll) {
  if (coll == null) {
    return null;
  } else {
    if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 8388608 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeqable$ ? true : false : false) {
      return coll.cljs$core$ISeqable$_seq$arity$1(null);
    } else {
      if (cljs.core.array_QMARK_(coll)) {
        if (coll.length === 0) {
          return null;
        } else {
          return new cljs.core.IndexedSeq(coll, 0, null);
        }
      } else {
        if (typeof coll === "string") {
          if (coll.length === 0) {
            return null;
          } else {
            return new cljs.core.IndexedSeq(coll, 0, null);
          }
        } else {
          if (cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable, coll)) {
            return cljs.core._seq(coll);
          } else {
            throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll), cljs.core.str.cljs$core$IFn$_invoke$arity$1(" is not ISeqable")].join(""));
          }
        }
      }
    }
  }
};
cljs.core.first = function cljs$core$first(coll) {
  if (coll == null) {
    return null;
  } else {
    if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 64 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$ ? true : false : false) {
      return coll.cljs$core$ISeq$_first$arity$1(null);
    } else {
      var s = cljs.core.seq(coll);
      if (s == null) {
        return null;
      } else {
        return cljs.core._first(s);
      }
    }
  }
};
cljs.core.rest = function cljs$core$rest(coll) {
  if (!(coll == null)) {
    if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 64 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$ ? true : false : false) {
      return coll.cljs$core$ISeq$_rest$arity$1(null);
    } else {
      var s = cljs.core.seq(coll);
      if (s) {
        return cljs.core._rest(s);
      } else {
        return cljs.core.List.EMPTY;
      }
    }
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.next = function cljs$core$next(coll) {
  if (coll == null) {
    return null;
  } else {
    if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 128 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$INext$ ? true : false : false) {
      return coll.cljs$core$INext$_next$arity$1(null);
    } else {
      return cljs.core.seq(cljs.core.rest(coll));
    }
  }
};
cljs.core._EQ_ = function cljs$core$_EQ_(var_args) {
  var args46100 = [];
  var len__10375__auto___46106 = arguments.length;
  var i__10376__auto___46107 = 0;
  while (true) {
    if (i__10376__auto___46107 < len__10375__auto___46106) {
      args46100.push(arguments[i__10376__auto___46107]);
      var G__46108 = i__10376__auto___46107 + 1;
      i__10376__auto___46107 = G__46108;
      continue;
    } else {
    }
    break;
  }
  var G__46105 = args46100.length;
  switch(G__46105) {
    case 1:
      return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46100.slice(2), 0, null);
      return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10398__auto__);
  }
};
cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  if (x == null) {
    return y == null;
  } else {
    return x === y || cljs.core._equiv(x, y);
  }
};
cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y)) {
      if (cljs.core.next(more)) {
        var G__46110 = y;
        var G__46111 = cljs.core.first(more);
        var G__46112 = cljs.core.next(more);
        x = G__46110;
        y = G__46111;
        more = G__46112;
        continue;
      } else {
        return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(y, cljs.core.first(more));
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._EQ_.cljs$lang$applyTo = function(seq46101) {
  var G__46102 = cljs.core.first(seq46101);
  var seq46101__$1 = cljs.core.next(seq46101);
  var G__46103 = cljs.core.first(seq46101__$1);
  var seq46101__$2 = cljs.core.next(seq46101__$1);
  return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(G__46102, G__46103, seq46101__$2);
};
cljs.core._EQ_.cljs$lang$maxFixedArity = 2;
cljs.core.ES6Iterator = function(s) {
  this.s = s;
};
cljs.core.ES6Iterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (!(self__.s == null)) {
    var x = cljs.core.first(self__.s);
    self__.s = cljs.core.next(self__.s);
    return {"value":x, "done":false};
  } else {
    return {"value":null, "done":true};
  }
};
cljs.core.ES6Iterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "s", "s", -948495851, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ES6Iterator.cljs$lang$type = true;
cljs.core.ES6Iterator.cljs$lang$ctorStr = "cljs.core/ES6Iterator";
cljs.core.ES6Iterator.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/ES6Iterator");
};
cljs.core.__GT_ES6Iterator = function cljs$core$__GT_ES6Iterator(s) {
  return new cljs.core.ES6Iterator(s);
};
cljs.core.es6_iterator = function cljs$core$es6_iterator(coll) {
  return new cljs.core.ES6Iterator(cljs.core.seq(coll));
};
cljs.core.ES6IteratorSeq = function(value, iter, _rest) {
  this.value = value;
  this.iter = iter;
  this._rest = _rest;
  this.cljs$lang$protocol_mask$partition0$ = 8388672;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1;
};
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.value;
};
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  if (self__._rest == null) {
    self__._rest = cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1(self__.iter) : cljs.core.es6_iterator_seq.call(null, self__.iter);
  } else {
  }
  return self__._rest;
};
cljs.core.ES6IteratorSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "value", "value", 1946509744, null), new cljs.core.Symbol(null, "iter", "iter", -1346195486, null), cljs.core.with_meta(new cljs.core.Symbol(null, "_rest", "_rest", -2100466189, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ES6IteratorSeq.cljs$lang$type = true;
cljs.core.ES6IteratorSeq.cljs$lang$ctorStr = "cljs.core/ES6IteratorSeq";
cljs.core.ES6IteratorSeq.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/ES6IteratorSeq");
};
cljs.core.__GT_ES6IteratorSeq = function cljs$core$__GT_ES6IteratorSeq(value, iter, _rest) {
  return new cljs.core.ES6IteratorSeq(value, iter, _rest);
};
cljs.core.es6_iterator_seq = function cljs$core$es6_iterator_seq(iter) {
  var v = iter.next();
  if (cljs.core.truth_(v.done)) {
    return cljs.core.List.EMPTY;
  } else {
    return new cljs.core.ES6IteratorSeq(v.value, iter, null);
  }
};
cljs.core.mix_collection_hash = function cljs$core$mix_collection_hash(hash_basis, count) {
  var h1 = cljs.core.m3_seed;
  var k1 = cljs.core.m3_mix_K1(hash_basis);
  var h1__$1 = cljs.core.m3_mix_H1(h1, k1);
  return cljs.core.m3_fmix(h1__$1, count);
};
cljs.core.hash_ordered_coll = function cljs$core$hash_ordered_coll(coll) {
  var n = 0;
  var hash_code = 1;
  var coll__$1 = cljs.core.seq(coll);
  while (true) {
    if (!(coll__$1 == null)) {
      var G__46113 = n + 1;
      var G__46114 = cljs.core.imul(31, hash_code) + cljs.core.hash(cljs.core.first(coll__$1)) | 0;
      var G__46115 = cljs.core.next(coll__$1);
      n = G__46113;
      hash_code = G__46114;
      coll__$1 = G__46115;
      continue;
    } else {
      return cljs.core.mix_collection_hash(hash_code, n);
    }
    break;
  }
};
cljs.core.empty_ordered_hash = cljs.core.mix_collection_hash(1, 0);
cljs.core.hash_unordered_coll = function cljs$core$hash_unordered_coll(coll) {
  var n = 0;
  var hash_code = 0;
  var coll__$1 = cljs.core.seq(coll);
  while (true) {
    if (!(coll__$1 == null)) {
      var G__46116 = n + 1;
      var G__46117 = hash_code + cljs.core.hash(cljs.core.first(coll__$1)) | 0;
      var G__46118 = cljs.core.next(coll__$1);
      n = G__46116;
      hash_code = G__46117;
      coll__$1 = G__46118;
      continue;
    } else {
      return cljs.core.mix_collection_hash(hash_code, n);
    }
    break;
  }
};
cljs.core.empty_unordered_hash = cljs.core.mix_collection_hash(0, 0);
cljs.core.ICounted["null"] = true;
cljs.core._count["null"] = function(_) {
  return 0;
};
Date.prototype.cljs$core$IEquiv$ = cljs.core.PROTOCOL_SENTINEL;
Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var o__$1 = this;
  return other instanceof Date && o__$1.valueOf() === other.valueOf();
};
Date.prototype.cljs$core$IComparable$ = cljs.core.PROTOCOL_SENTINEL;
Date.prototype.cljs$core$IComparable$_compare$arity$2 = function(this$, other) {
  var this$__$1 = this;
  if (other instanceof Date) {
    var G__46119 = this$__$1.valueOf();
    var G__46120 = other.valueOf();
    return goog.array.defaultCompare(G__46119, G__46120);
  } else {
    throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Cannot compare "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(this$__$1), cljs.core.str.cljs$core$IFn$_invoke$arity$1(" to "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(other)].join(""));
  }
};
cljs.core.Inst = function() {
};
cljs.core.inst_ms_STAR_ = function cljs$core$inst_ms_STAR_(inst) {
  if (!(inst == null) && !(inst.cljs$core$Inst$inst_ms_STAR_$arity$1 == null)) {
    return inst.cljs$core$Inst$inst_ms_STAR_$arity$1(inst);
  } else {
    var x__9872__auto__ = inst == null ? null : inst;
    var m__9873__auto__ = cljs.core.inst_ms_STAR_[goog.typeOf(x__9872__auto__)];
    if (!(m__9873__auto__ == null)) {
      return m__9873__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto__.cljs$core$IFn$_invoke$arity$1(inst) : m__9873__auto__.call(null, inst);
    } else {
      var m__9873__auto____$1 = cljs.core.inst_ms_STAR_["_"];
      if (!(m__9873__auto____$1 == null)) {
        return m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9873__auto____$1.cljs$core$IFn$_invoke$arity$1(inst) : m__9873__auto____$1.call(null, inst);
      } else {
        throw cljs.core.missing_protocol("Inst.inst-ms*", inst);
      }
    }
  }
};
Date.prototype.cljs$core$Inst$ = cljs.core.PROTOCOL_SENTINEL;
Date.prototype.cljs$core$Inst$inst_ms_STAR_$arity$1 = function(inst) {
  var inst__$1 = this;
  return inst__$1.getTime();
};
cljs.core.inst_ms = function cljs$core$inst_ms(inst) {
  return cljs.core.inst_ms_STAR_(inst);
};
cljs.core.inst_QMARK_ = function cljs$core$inst_QMARK_(x) {
  if (!(x == null)) {
    if (false || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$Inst$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.Inst, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.Inst, x);
  }
};
cljs.core.IEquiv["number"] = true;
cljs.core._equiv["number"] = function(x, o) {
  return x === o;
};
cljs.core.Fn["function"] = true;
cljs.core.IMeta["function"] = true;
cljs.core._meta["function"] = function(_) {
  return null;
};
cljs.core.IHash["_"] = true;
cljs.core._hash["_"] = function(o) {
  return goog.getUid(o);
};
cljs.core.inc = function cljs$core$inc(x) {
  return x + 1;
};
cljs.core.Reduced = function(val) {
  this.val = val;
  this.cljs$lang$protocol_mask$partition0$ = 32768;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = function(o) {
  var self__ = this;
  var o__$1 = this;
  return self__.val;
};
cljs.core.Reduced.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "val", "val", 1769233139, null)], null);
};
cljs.core.Reduced.cljs$lang$type = true;
cljs.core.Reduced.cljs$lang$ctorStr = "cljs.core/Reduced";
cljs.core.Reduced.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/Reduced");
};
cljs.core.__GT_Reduced = function cljs$core$__GT_Reduced(val) {
  return new cljs.core.Reduced(val);
};
cljs.core.reduced = function cljs$core$reduced(x) {
  return new cljs.core.Reduced(x);
};
cljs.core.reduced_QMARK_ = function cljs$core$reduced_QMARK_(r) {
  return r instanceof cljs.core.Reduced;
};
cljs.core.ensure_reduced = function cljs$core$ensure_reduced(x) {
  if (cljs.core.reduced_QMARK_(x)) {
    return x;
  } else {
    return cljs.core.reduced(x);
  }
};
cljs.core.unreduced = function cljs$core$unreduced(x) {
  if (cljs.core.reduced_QMARK_(x)) {
    return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(x) : cljs.core.deref.call(null, x);
  } else {
    return x;
  }
};
cljs.core.deref = function cljs$core$deref(o) {
  return cljs.core._deref(o);
};
cljs.core.ci_reduce = function cljs$core$ci_reduce(var_args) {
  var args46123 = [];
  var len__10375__auto___46132 = arguments.length;
  var i__10376__auto___46133 = 0;
  while (true) {
    if (i__10376__auto___46133 < len__10375__auto___46132) {
      args46123.push(arguments[i__10376__auto___46133]);
      var G__46134 = i__10376__auto___46133 + 1;
      i__10376__auto___46133 = G__46134;
      continue;
    } else {
    }
    break;
  }
  var G__46125 = args46123.length;
  switch(G__46125) {
    case 2:
      return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args46123.length)].join(""));
  }
};
cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2 = function(cicoll, f) {
  var cnt = cljs.core._count(cicoll);
  if (cnt === 0) {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  } else {
    var val = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll, 0);
    var n = 1;
    while (true) {
      if (n < cnt) {
        var nval = function() {
          var G__46126 = val;
          var G__46127 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll, n);
          return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__46126, G__46127) : f.call(null, G__46126, G__46127);
        }();
        if (cljs.core.reduced_QMARK_(nval)) {
          return cljs.core.deref(nval);
        } else {
          var G__46136 = nval;
          var G__46137 = n + 1;
          val = G__46136;
          n = G__46137;
          continue;
        }
      } else {
        return val;
      }
      break;
    }
  }
};
cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3 = function(cicoll, f, val) {
  var cnt = cljs.core._count(cicoll);
  var val__$1 = val;
  var n = 0;
  while (true) {
    if (n < cnt) {
      var nval = function() {
        var G__46128 = val__$1;
        var G__46129 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll, n);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__46128, G__46129) : f.call(null, G__46128, G__46129);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__46138 = nval;
        var G__46139 = n + 1;
        val__$1 = G__46138;
        n = G__46139;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4 = function(cicoll, f, val, idx) {
  var cnt = cljs.core._count(cicoll);
  var val__$1 = val;
  var n = idx;
  while (true) {
    if (n < cnt) {
      var nval = function() {
        var G__46130 = val__$1;
        var G__46131 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll, n);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__46130, G__46131) : f.call(null, G__46130, G__46131);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__46140 = nval;
        var G__46141 = n + 1;
        val__$1 = G__46140;
        n = G__46141;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.ci_reduce.cljs$lang$maxFixedArity = 4;
cljs.core.array_reduce = function cljs$core$array_reduce(var_args) {
  var args46142 = [];
  var len__10375__auto___46151 = arguments.length;
  var i__10376__auto___46152 = 0;
  while (true) {
    if (i__10376__auto___46152 < len__10375__auto___46151) {
      args46142.push(arguments[i__10376__auto___46152]);
      var G__46153 = i__10376__auto___46152 + 1;
      i__10376__auto___46152 = G__46153;
      continue;
    } else {
    }
    break;
  }
  var G__46144 = args46142.length;
  switch(G__46144) {
    case 2:
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args46142.length)].join(""));
  }
};
cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2 = function(arr, f) {
  var cnt = arr.length;
  if (arr.length === 0) {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  } else {
    var val = arr[0];
    var n = 1;
    while (true) {
      if (n < cnt) {
        var nval = function() {
          var G__46145 = val;
          var G__46146 = arr[n];
          return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__46145, G__46146) : f.call(null, G__46145, G__46146);
        }();
        if (cljs.core.reduced_QMARK_(nval)) {
          return cljs.core.deref(nval);
        } else {
          var G__46155 = nval;
          var G__46156 = n + 1;
          val = G__46155;
          n = G__46156;
          continue;
        }
      } else {
        return val;
      }
      break;
    }
  }
};
cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3 = function(arr, f, val) {
  var cnt = arr.length;
  var val__$1 = val;
  var n = 0;
  while (true) {
    if (n < cnt) {
      var nval = function() {
        var G__46147 = val__$1;
        var G__46148 = arr[n];
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__46147, G__46148) : f.call(null, G__46147, G__46148);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__46157 = nval;
        var G__46158 = n + 1;
        val__$1 = G__46157;
        n = G__46158;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4 = function(arr, f, val, idx) {
  var cnt = arr.length;
  var val__$1 = val;
  var n = idx;
  while (true) {
    if (n < cnt) {
      var nval = function() {
        var G__46149 = val__$1;
        var G__46150 = arr[n];
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__46149, G__46150) : f.call(null, G__46149, G__46150);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__46159 = nval;
        var G__46160 = n + 1;
        val__$1 = G__46159;
        n = G__46160;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.array_reduce.cljs$lang$maxFixedArity = 4;
cljs.core.counted_QMARK_ = function cljs$core$counted_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 2 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ICounted$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted, x);
  }
};
cljs.core.indexed_QMARK_ = function cljs$core$indexed_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 16 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IIndexed$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed, x);
  }
};
cljs.core._indexOf = function cljs$core$_indexOf(var_args) {
  var args46165 = [];
  var len__10375__auto___46168 = arguments.length;
  var i__10376__auto___46169 = 0;
  while (true) {
    if (i__10376__auto___46169 < len__10375__auto___46168) {
      args46165.push(arguments[i__10376__auto___46169]);
      var G__46170 = i__10376__auto___46169 + 1;
      i__10376__auto___46169 = G__46170;
      continue;
    } else {
    }
    break;
  }
  var G__46167 = args46165.length;
  switch(G__46167) {
    case 2:
      return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args46165.length)].join(""));
  }
};
cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2 = function(coll, x) {
  return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
};
cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3 = function(coll, x, start) {
  var len = cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null, coll);
  if (start >= len) {
    return -1;
  } else {
    var idx = start > 0 ? start : start < 0 ? function() {
      var x__9492__auto__ = 0;
      var y__9493__auto__ = start + len;
      return x__9492__auto__ > y__9493__auto__ ? x__9492__auto__ : y__9493__auto__;
    }() : start;
    while (true) {
      if (idx < len) {
        if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.nth.cljs$core$IFn$_invoke$arity$2 ? cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll, idx) : cljs.core.nth.call(null, coll, idx), x)) {
          return idx;
        } else {
          var G__46172 = idx + 1;
          idx = G__46172;
          continue;
        }
      } else {
        return -1;
      }
      break;
    }
  }
};
cljs.core._indexOf.cljs$lang$maxFixedArity = 3;
cljs.core._lastIndexOf = function cljs$core$_lastIndexOf(var_args) {
  var args46173 = [];
  var len__10375__auto___46176 = arguments.length;
  var i__10376__auto___46177 = 0;
  while (true) {
    if (i__10376__auto___46177 < len__10375__auto___46176) {
      args46173.push(arguments[i__10376__auto___46177]);
      var G__46178 = i__10376__auto___46177 + 1;
      i__10376__auto___46177 = G__46178;
      continue;
    } else {
    }
    break;
  }
  var G__46175 = args46173.length;
  switch(G__46175) {
    case 2:
      return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args46173.length)].join(""));
  }
};
cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2 = function(coll, x) {
  return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null, coll));
};
cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3 = function(coll, x, start) {
  var len = cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null, coll);
  if (len === 0) {
    return -1;
  } else {
    var idx = start > 0 ? function() {
      var x__9499__auto__ = len - 1;
      var y__9500__auto__ = start;
      return x__9499__auto__ < y__9500__auto__ ? x__9499__auto__ : y__9500__auto__;
    }() : start < 0 ? len + start : start;
    while (true) {
      if (idx >= 0) {
        if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.nth.cljs$core$IFn$_invoke$arity$2 ? cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll, idx) : cljs.core.nth.call(null, coll, idx), x)) {
          return idx;
        } else {
          var G__46180 = idx - 1;
          idx = G__46180;
          continue;
        }
      } else {
        return -1;
      }
      break;
    }
  }
};
cljs.core._lastIndexOf.cljs$lang$maxFixedArity = 3;
cljs.core.IndexedSeqIterator = function(arr, i) {
  this.arr = arr;
  this.i = i;
};
cljs.core.IndexedSeqIterator.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.i < self__.arr.length;
};
cljs.core.IndexedSeqIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = self__.arr[self__.i];
  self__.i = self__.i + 1;
  return ret;
};
cljs.core.IndexedSeqIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.IndexedSeqIterator.cljs$lang$type = true;
cljs.core.IndexedSeqIterator.cljs$lang$ctorStr = "cljs.core/IndexedSeqIterator";
cljs.core.IndexedSeqIterator.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/IndexedSeqIterator");
};
cljs.core.__GT_IndexedSeqIterator = function cljs$core$__GT_IndexedSeqIterator(arr, i) {
  return new cljs.core.IndexedSeqIterator(arr, i);
};
cljs.core.IndexedSeq = function(arr, i, meta) {
  this.arr = arr;
  this.i = i;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 166592766;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.IndexedSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.IndexedSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.IndexedSeq.prototype.indexOf = function() {
  var G__46181 = null;
  var G__46181__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__46181__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__46181 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__46181__1.call(this, x);
      case 2:
        return G__46181__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__46181.cljs$core$IFn$_invoke$arity$1 = G__46181__1;
  G__46181.cljs$core$IFn$_invoke$arity$2 = G__46181__2;
  return G__46181;
}();
cljs.core.IndexedSeq.prototype.lastIndexOf = function() {
  var G__46182 = null;
  var G__46182__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null, coll));
  };
  var G__46182__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__46182 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__46182__1.call(this, x);
      case 2:
        return G__46182__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__46182.cljs$core$IFn$_invoke$arity$1 = G__46182__1;
  G__46182.cljs$core$IFn$_invoke$arity$2 = G__46182__2;
  return G__46182;
}();
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  var i__$1 = n + self__.i;
  if (0 <= i__$1 && i__$1 < self__.arr.length) {
    return self__.arr[i__$1];
  } else {
    throw new Error("Index out of bounds");
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var self__ = this;
  var coll__$1 = this;
  var i__$1 = n + self__.i;
  if (0 <= i__$1 && i__$1 < self__.arr.length) {
    return self__.arr[i__$1];
  } else {
    return not_found;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.IndexedSeq.prototype.cljs$core$IIterable$_iterator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.IndexedSeqIterator(self__.arr, self__.i);
};
cljs.core.IndexedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.IndexedSeq(self__.arr, self__.i, self__.meta);
};
cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  if (self__.i + 1 < self__.arr.length) {
    return new cljs.core.IndexedSeq(self__.arr, self__.i + 1, null);
  } else {
    return null;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  var x__9492__auto__ = 0;
  var y__9493__auto__ = self__.arr.length - self__.i;
  return x__9492__auto__ > y__9493__auto__ ? x__9492__auto__ : y__9493__auto__;
};
cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var c = coll__$1.cljs$core$ICounted$_count$arity$1(null);
  if (c > 0) {
    return new cljs.core.RSeq(coll__$1, c - 1, null);
  } else {
    return null;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.hash_ordered_coll(coll__$1);
};
cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(coll__$1, other) : cljs.core.equiv_sequential.call(null, coll__$1, other);
};
cljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.List.EMPTY;
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr, f, self__.arr[self__.i], self__.i + 1);
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr, f, start, self__.i);
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.arr[self__.i];
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  if (self__.i + 1 < self__.arr.length) {
    return new cljs.core.IndexedSeq(self__.arr, self__.i + 1, null);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.i < self__.arr.length) {
    return this$__$1;
  } else {
    return null;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, new_meta) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.IndexedSeq(self__.arr, self__.i, new_meta);
};
cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(o, coll__$1) : cljs.core.cons.call(null, o, coll__$1);
};
cljs.core.IndexedSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null)], null);
};
cljs.core.IndexedSeq.cljs$lang$type = true;
cljs.core.IndexedSeq.cljs$lang$ctorStr = "cljs.core/IndexedSeq";
cljs.core.IndexedSeq.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/IndexedSeq");
};
cljs.core.__GT_IndexedSeq = function cljs$core$__GT_IndexedSeq(arr, i, meta) {
  return new cljs.core.IndexedSeq(arr, i, meta);
};
cljs.core.IndexedSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__10266__auto__ = this;
  return cljs.core.es6_iterator(this__10266__auto__);
};
cljs.core.prim_seq = function cljs$core$prim_seq(var_args) {
  var args46183 = [];
  var len__10375__auto___46186 = arguments.length;
  var i__10376__auto___46187 = 0;
  while (true) {
    if (i__10376__auto___46187 < len__10375__auto___46186) {
      args46183.push(arguments[i__10376__auto___46187]);
      var G__46188 = i__10376__auto___46187 + 1;
      i__10376__auto___46187 = G__46188;
      continue;
    } else {
    }
    break;
  }
  var G__46185 = args46183.length;
  switch(G__46185) {
    case 1:
      return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args46183.length)].join(""));
  }
};
cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1 = function(prim) {
  return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(prim, 0);
};
cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2 = function(prim, i) {
  if (i < prim.length) {
    return new cljs.core.IndexedSeq(prim, i, null);
  } else {
    return null;
  }
};
cljs.core.prim_seq.cljs$lang$maxFixedArity = 2;
cljs.core.array_seq = function cljs$core$array_seq(var_args) {
  var args46190 = [];
  var len__10375__auto___46193 = arguments.length;
  var i__10376__auto___46194 = 0;
  while (true) {
    if (i__10376__auto___46194 < len__10375__auto___46193) {
      args46190.push(arguments[i__10376__auto___46194]);
      var G__46195 = i__10376__auto___46194 + 1;
      i__10376__auto___46194 = G__46195;
      continue;
    } else {
    }
    break;
  }
  var G__46192 = args46190.length;
  switch(G__46192) {
    case 1:
      return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args46190.length)].join(""));
  }
};
cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1 = function(array) {
  return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array, 0);
};
cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2 = function(array, i) {
  return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array, i);
};
cljs.core.array_seq.cljs$lang$maxFixedArity = 2;
cljs.core.RSeq = function(ci, i, meta) {
  this.ci = ci;
  this.i = i;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 32374990;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.RSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.RSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.RSeq.prototype.indexOf = function() {
  var G__46199 = null;
  var G__46199__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__46199__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__46199 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__46199__1.call(this, x);
      case 2:
        return G__46199__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__46199.cljs$core$IFn$_invoke$arity$1 = G__46199__1;
  G__46199.cljs$core$IFn$_invoke$arity$2 = G__46199__2;
  return G__46199;
}();
cljs.core.RSeq.prototype.lastIndexOf = function() {
  var G__46200 = null;
  var G__46200__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null, coll));
  };
  var G__46200__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__46200 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__46200__1.call(this, x);
      case 2:
        return G__46200__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__46200.cljs$core$IFn$_invoke$arity$1 = G__46200__1;
  G__46200.cljs$core$IFn$_invoke$arity$2 = G__46200__2;
  return G__46200;
}();
cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.RSeq(self__.ci, self__.i, self__.meta);
};
cljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.i > 0) {
    return new cljs.core.RSeq(self__.ci, self__.i - 1, null);
  } else {
    return null;
  }
};
cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.i + 1;
};
cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.hash_ordered_coll(coll__$1);
};
cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(coll__$1, other) : cljs.core.equiv_sequential.call(null, coll__$1, other);
};
cljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var G__46197 = cljs.core.List.EMPTY;
  var G__46198 = self__.meta;
  return cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2(G__46197, G__46198) : cljs.core.with_meta.call(null, G__46197, G__46198);
};
cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(col, f) {
  var self__ = this;
  var col__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, col__$1) : cljs.core.seq_reduce.call(null, f, col__$1);
};
cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(col, f, start) {
  var self__ = this;
  var col__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, col__$1) : cljs.core.seq_reduce.call(null, f, start, col__$1);
};
cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.ci, self__.i);
};
cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.i > 0) {
    return new cljs.core.RSeq(self__.ci, self__.i - 1, null);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, new_meta) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.RSeq(self__.ci, self__.i, new_meta);
};
cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(o, coll__$1) : cljs.core.cons.call(null, o, coll__$1);
};
cljs.core.RSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "ci", "ci", 2049808339, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null)], null);
};
cljs.core.RSeq.cljs$lang$type = true;
cljs.core.RSeq.cljs$lang$ctorStr = "cljs.core/RSeq";
cljs.core.RSeq.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/RSeq");
};
cljs.core.__GT_RSeq = function cljs$core$__GT_RSeq(ci, i, meta) {
  return new cljs.core.RSeq(ci, i, meta);
};
cljs.core.RSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__10266__auto__ = this;
  return cljs.core.es6_iterator(this__10266__auto__);
};
cljs.core.second = function cljs$core$second(coll) {
  return cljs.core.first(cljs.core.next(coll));
};
cljs.core.ffirst = function cljs$core$ffirst(coll) {
  return cljs.core.first(cljs.core.first(coll));
};
cljs.core.nfirst = function cljs$core$nfirst(coll) {
  return cljs.core.next(cljs.core.first(coll));
};
cljs.core.fnext = function cljs$core$fnext(coll) {
  return cljs.core.first(cljs.core.next(coll));
};
cljs.core.nnext = function cljs$core$nnext(coll) {
  return cljs.core.next(cljs.core.next(coll));
};
cljs.core.last = function cljs$core$last(s) {
  while (true) {
    var sn = cljs.core.next(s);
    if (!(sn == null)) {
      var G__46201 = sn;
      s = G__46201;
      continue;
    } else {
      return cljs.core.first(s);
    }
    break;
  }
};
cljs.core.IEquiv["_"] = true;
cljs.core._equiv["_"] = function(x, o) {
  return x === o;
};
cljs.core.conj = function cljs$core$conj(var_args) {
  var args46202 = [];
  var len__10375__auto___46208 = arguments.length;
  var i__10376__auto___46209 = 0;
  while (true) {
    if (i__10376__auto___46209 < len__10375__auto___46208) {
      args46202.push(arguments[i__10376__auto___46209]);
      var G__46210 = i__10376__auto___46209 + 1;
      i__10376__auto___46209 = G__46210;
      continue;
    } else {
    }
    break;
  }
  var G__46207 = args46202.length;
  switch(G__46207) {
    case 0:
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46202.slice(2), 0, null);
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10398__auto__);
  }
};
cljs.core.conj.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.PersistentVector.EMPTY;
};
cljs.core.conj.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return coll;
};
cljs.core.conj.cljs$core$IFn$_invoke$arity$2 = function(coll, x) {
  if (!(coll == null)) {
    return cljs.core._conj(coll, x);
  } else {
    var x__10088__auto__ = x;
    return cljs.core._conj(cljs.core.List.EMPTY, x__10088__auto__);
  }
};
cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic = function(coll, x, xs) {
  while (true) {
    if (cljs.core.truth_(xs)) {
      var G__46212 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll, x);
      var G__46213 = cljs.core.first(xs);
      var G__46214 = cljs.core.next(xs);
      coll = G__46212;
      x = G__46213;
      xs = G__46214;
      continue;
    } else {
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll, x);
    }
    break;
  }
};
cljs.core.conj.cljs$lang$applyTo = function(seq46203) {
  var G__46204 = cljs.core.first(seq46203);
  var seq46203__$1 = cljs.core.next(seq46203);
  var G__46205 = cljs.core.first(seq46203__$1);
  var seq46203__$2 = cljs.core.next(seq46203__$1);
  return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(G__46204, G__46205, seq46203__$2);
};
cljs.core.conj.cljs$lang$maxFixedArity = 2;
cljs.core.empty = function cljs$core$empty(coll) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._empty(coll);
  }
};
cljs.core.accumulating_seq_count = function cljs$core$accumulating_seq_count(coll) {
  var s = cljs.core.seq(coll);
  var acc = 0;
  while (true) {
    if (cljs.core.counted_QMARK_(s)) {
      return acc + cljs.core._count(s);
    } else {
      var G__46215 = cljs.core.next(s);
      var G__46216 = acc + 1;
      s = G__46215;
      acc = G__46216;
      continue;
    }
    break;
  }
};
cljs.core.count = function cljs$core$count(coll) {
  if (!(coll == null)) {
    if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 2 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ICounted$ ? true : false : false) {
      return coll.cljs$core$ICounted$_count$arity$1(null);
    } else {
      if (cljs.core.array_QMARK_(coll)) {
        return coll.length;
      } else {
        if (typeof coll === "string") {
          return coll.length;
        } else {
          if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 8388608 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeqable$ ? true : false : false) {
            return cljs.core.accumulating_seq_count(coll);
          } else {
            return cljs.core._count(coll);
          }
        }
      }
    }
  } else {
    return 0;
  }
};
cljs.core.linear_traversal_nth = function cljs$core$linear_traversal_nth(var_args) {
  var args46221 = [];
  var len__10375__auto___46224 = arguments.length;
  var i__10376__auto___46225 = 0;
  while (true) {
    if (i__10376__auto___46225 < len__10375__auto___46224) {
      args46221.push(arguments[i__10376__auto___46225]);
      var G__46226 = i__10376__auto___46225 + 1;
      i__10376__auto___46225 = G__46226;
      continue;
    } else {
    }
    break;
  }
  var G__46223 = args46221.length;
  switch(G__46223) {
    case 2:
      return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args46221.length)].join(""));
  }
};
cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2 = function(coll, n) {
  while (true) {
    if (coll == null) {
      throw new Error("Index out of bounds");
    } else {
      if (n === 0) {
        if (cljs.core.seq(coll)) {
          return cljs.core.first(coll);
        } else {
          throw new Error("Index out of bounds");
        }
      } else {
        if (cljs.core.indexed_QMARK_(coll)) {
          return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll, n);
        } else {
          if (cljs.core.seq(coll)) {
            var G__46228 = cljs.core.next(coll);
            var G__46229 = n - 1;
            coll = G__46228;
            n = G__46229;
            continue;
          } else {
            throw new Error("Index out of bounds");
          }
        }
      }
    }
    break;
  }
};
cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3 = function(coll, n, not_found) {
  while (true) {
    if (coll == null) {
      return not_found;
    } else {
      if (n === 0) {
        if (cljs.core.seq(coll)) {
          return cljs.core.first(coll);
        } else {
          return not_found;
        }
      } else {
        if (cljs.core.indexed_QMARK_(coll)) {
          return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll, n, not_found);
        } else {
          if (cljs.core.seq(coll)) {
            var G__46230 = cljs.core.next(coll);
            var G__46231 = n - 1;
            var G__46232 = not_found;
            coll = G__46230;
            n = G__46231;
            not_found = G__46232;
            continue;
          } else {
            return not_found;
          }
        }
      }
    }
    break;
  }
};
cljs.core.linear_traversal_nth.cljs$lang$maxFixedArity = 3;
cljs.core.nth = function cljs$core$nth(var_args) {
  var args46233 = [];
  var len__10375__auto___46240 = arguments.length;
  var i__10376__auto___46241 = 0;
  while (true) {
    if (i__10376__auto___46241 < len__10375__auto___46240) {
      args46233.push(arguments[i__10376__auto___46241]);
      var G__46242 = i__10376__auto___46241 + 1;
      i__10376__auto___46241 = G__46242;
      continue;
    } else {
    }
    break;
  }
  var G__46235 = args46233.length;
  switch(G__46235) {
    case 2:
      return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.nth.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args46233.length)].join(""));
  }
};
cljs.core.nth.cljs$core$IFn$_invoke$arity$2 = function(coll, n) {
  if (!(typeof n === "number")) {
    throw new Error("Index argument to nth must be a number");
  } else {
    if (coll == null) {
      return coll;
    } else {
      if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 16 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IIndexed$ ? true : false : false) {
        return coll.cljs$core$IIndexed$_nth$arity$2(null, n);
      } else {
        if (cljs.core.array_QMARK_(coll)) {
          if (n >= 0 && n < coll.length) {
            return coll[n];
          } else {
            throw new Error("Index out of bounds");
          }
        } else {
          if (typeof coll === "string") {
            if (n >= 0 && n < coll.length) {
              return coll.charAt(n);
            } else {
              throw new Error("Index out of bounds");
            }
          } else {
            if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 64 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$ ? true : false : false) {
              return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(coll, n);
            } else {
              if (cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed, coll)) {
                return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll, n);
              } else {
                throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("nth not supported on this type "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type__GT_str(cljs.core.type(coll)))].join(""));
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.nth.cljs$core$IFn$_invoke$arity$3 = function(coll, n, not_found) {
  if (!(typeof n === "number")) {
    throw new Error("Index argument to nth must be a number.");
  } else {
    if (coll == null) {
      return not_found;
    } else {
      if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 16 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IIndexed$ ? true : false : false) {
        return coll.cljs$core$IIndexed$_nth$arity$3(null, n, not_found);
      } else {
        if (cljs.core.array_QMARK_(coll)) {
          if (n >= 0 && n < coll.length) {
            return coll[n];
          } else {
            return not_found;
          }
        } else {
          if (typeof coll === "string") {
            if (n >= 0 && n < coll.length) {
              return coll.charAt(n);
            } else {
              return not_found;
            }
          } else {
            if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 64 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$ ? true : false : false) {
              return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(coll, n, not_found);
            } else {
              if (cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed, coll)) {
                return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll, n);
              } else {
                throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("nth not supported on this type "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type__GT_str(cljs.core.type(coll)))].join(""));
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.nth.cljs$lang$maxFixedArity = 3;
cljs.core.nthrest = function cljs$core$nthrest(coll, n) {
  var n__$1 = n;
  var xs = coll;
  while (true) {
    if (n__$1 > 0 && cljs.core.seq(xs)) {
      var G__46244 = n__$1 - 1;
      var G__46245 = cljs.core.rest(xs);
      n__$1 = G__46244;
      xs = G__46245;
      continue;
    } else {
      return xs;
    }
    break;
  }
};
cljs.core.get = function cljs$core$get(var_args) {
  var args46246 = [];
  var len__10375__auto___46251 = arguments.length;
  var i__10376__auto___46252 = 0;
  while (true) {
    if (i__10376__auto___46252 < len__10375__auto___46251) {
      args46246.push(arguments[i__10376__auto___46252]);
      var G__46253 = i__10376__auto___46252 + 1;
      i__10376__auto___46252 = G__46253;
      continue;
    } else {
    }
    break;
  }
  var G__46248 = args46246.length;
  switch(G__46248) {
    case 2:
      return cljs.core.get.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.get.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args46246.length)].join(""));
  }
};
cljs.core.get.cljs$core$IFn$_invoke$arity$2 = function(o, k) {
  if (o == null) {
    return null;
  } else {
    if (!(o == null) ? o.cljs$lang$protocol_mask$partition0$ & 256 || cljs.core.PROTOCOL_SENTINEL === o.cljs$core$ILookup$ ? true : false : false) {
      return o.cljs$core$ILookup$_lookup$arity$2(null, k);
    } else {
      if (cljs.core.array_QMARK_(o)) {
        if (!(k == null) && k < o.length) {
          return o[k | 0];
        } else {
          return null;
        }
      } else {
        if (typeof o === "string") {
          if (!(k == null) && k < o.length) {
            return o.charAt(k | 0);
          } else {
            return null;
          }
        } else {
          if (cljs.core.native_satisfies_QMARK_(cljs.core.ILookup, o)) {
            return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(o, k);
          } else {
            return null;
          }
        }
      }
    }
  }
};
cljs.core.get.cljs$core$IFn$_invoke$arity$3 = function(o, k, not_found) {
  if (!(o == null)) {
    if (!(o == null) ? o.cljs$lang$protocol_mask$partition0$ & 256 || cljs.core.PROTOCOL_SENTINEL === o.cljs$core$ILookup$ ? true : false : false) {
      return o.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
    } else {
      if (cljs.core.array_QMARK_(o)) {
        if (!(k == null) && k >= 0 && k < o.length) {
          return o[k | 0];
        } else {
          return not_found;
        }
      } else {
        if (typeof o === "string") {
          if (!(k == null) && k >= 0 && k < o.length) {
            return o.charAt(k | 0);
          } else {
            return not_found;
          }
        } else {
          if (cljs.core.native_satisfies_QMARK_(cljs.core.ILookup, o)) {
            return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(o, k, not_found);
          } else {
            return not_found;
          }
        }
      }
    }
  } else {
    return not_found;
  }
};
cljs.core.get.cljs$lang$maxFixedArity = 3;
cljs.core.assoc = function cljs$core$assoc(var_args) {
  var args46255 = [];
  var len__10375__auto___46262 = arguments.length;
  var i__10376__auto___46263 = 0;
  while (true) {
    if (i__10376__auto___46263 < len__10375__auto___46262) {
      args46255.push(arguments[i__10376__auto___46263]);
      var G__46264 = i__10376__auto___46263 + 1;
      i__10376__auto___46263 = G__46264;
      continue;
    } else {
    }
    break;
  }
  var G__46261 = args46255.length;
  switch(G__46261) {
    case 3:
      return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46255.slice(3), 0, null);
      return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__10398__auto__);
  }
};
cljs.core.assoc.cljs$core$IFn$_invoke$arity$3 = function(coll, k, v) {
  if (!(coll == null)) {
    return cljs.core._assoc(coll, k, v);
  } else {
    return cljs.core.PersistentArrayMap.createAsIfByAssoc([k, v]);
  }
};
cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic = function(coll, k, v, kvs) {
  while (true) {
    var ret = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(coll, k, v);
    if (cljs.core.truth_(kvs)) {
      var G__46266 = ret;
      var G__46267 = cljs.core.first(kvs);
      var G__46268 = cljs.core.second(kvs);
      var G__46269 = cljs.core.nnext(kvs);
      coll = G__46266;
      k = G__46267;
      v = G__46268;
      kvs = G__46269;
      continue;
    } else {
      return ret;
    }
    break;
  }
};
cljs.core.assoc.cljs$lang$applyTo = function(seq46256) {
  var G__46257 = cljs.core.first(seq46256);
  var seq46256__$1 = cljs.core.next(seq46256);
  var G__46258 = cljs.core.first(seq46256__$1);
  var seq46256__$2 = cljs.core.next(seq46256__$1);
  var G__46259 = cljs.core.first(seq46256__$2);
  var seq46256__$3 = cljs.core.next(seq46256__$2);
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(G__46257, G__46258, G__46259, seq46256__$3);
};
cljs.core.assoc.cljs$lang$maxFixedArity = 3;
cljs.core.dissoc = function cljs$core$dissoc(var_args) {
  var args46270 = [];
  var len__10375__auto___46276 = arguments.length;
  var i__10376__auto___46277 = 0;
  while (true) {
    if (i__10376__auto___46277 < len__10375__auto___46276) {
      args46270.push(arguments[i__10376__auto___46277]);
      var G__46278 = i__10376__auto___46277 + 1;
      i__10376__auto___46277 = G__46278;
      continue;
    } else {
    }
    break;
  }
  var G__46275 = args46270.length;
  switch(G__46275) {
    case 1:
      return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46270.slice(2), 0, null);
      return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10398__auto__);
  }
};
cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return coll;
};
cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2 = function(coll, k) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._dissoc(coll, k);
  }
};
cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic = function(coll, k, ks) {
  while (true) {
    if (coll == null) {
      return null;
    } else {
      var ret = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(coll, k);
      if (cljs.core.truth_(ks)) {
        var G__46280 = ret;
        var G__46281 = cljs.core.first(ks);
        var G__46282 = cljs.core.next(ks);
        coll = G__46280;
        k = G__46281;
        ks = G__46282;
        continue;
      } else {
        return ret;
      }
    }
    break;
  }
};
cljs.core.dissoc.cljs$lang$applyTo = function(seq46271) {
  var G__46272 = cljs.core.first(seq46271);
  var seq46271__$1 = cljs.core.next(seq46271);
  var G__46273 = cljs.core.first(seq46271__$1);
  var seq46271__$2 = cljs.core.next(seq46271__$1);
  return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__46272, G__46273, seq46271__$2);
};
cljs.core.dissoc.cljs$lang$maxFixedArity = 2;
cljs.core.fn_QMARK_ = function cljs$core$fn_QMARK_(f) {
  var or__9154__auto__ = goog.isFunction(f);
  if (or__9154__auto__) {
    return or__9154__auto__;
  } else {
    if (!(f == null)) {
      if (false || cljs.core.PROTOCOL_SENTINEL === f.cljs$core$Fn$) {
        return true;
      } else {
        if (!f.cljs$lang$protocol_mask$partition$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.Fn, f);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.Fn, f);
    }
  }
};
cljs.core.MetaFn = function(afn, meta) {
  this.afn = afn;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 393217;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.meta;
};
cljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(_, new_meta) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.MetaFn(self__.afn, new_meta);
};
cljs.core.MetaFn.prototype.cljs$core$Fn$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.MetaFn.prototype.call = function() {
  var G__46288 = null;
  var G__46288__1 = function(self__) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null);
  };
  var G__46288__2 = function(self__, a) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null, a);
  };
  var G__46288__3 = function(self__, a, b) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a, b) : self__.afn.call(null, a, b);
  };
  var G__46288__4 = function(self__, a, b, c) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a, b, c) : self__.afn.call(null, a, b, c);
  };
  var G__46288__5 = function(self__, a, b, c, d) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a, b, c, d) : self__.afn.call(null, a, b, c, d);
  };
  var G__46288__6 = function(self__, a, b, c, d, e) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a, b, c, d, e) : self__.afn.call(null, a, b, c, d, e);
  };
  var G__46288__7 = function(self__, a, b, c, d, e, f) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a, b, c, d, e, f) : self__.afn.call(null, a, b, c, d, e, f);
  };
  var G__46288__8 = function(self__, a, b, c, d, e, f, g) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a, b, c, d, e, f, g) : self__.afn.call(null, a, b, c, d, e, f, g);
  };
  var G__46288__9 = function(self__, a, b, c, d, e, f, g, h) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a, b, c, d, e, f, g, h) : self__.afn.call(null, a, b, c, d, e, f, g, h);
  };
  var G__46288__10 = function(self__, a, b, c, d, e, f, g, h, i) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a, b, c, d, e, f, g, h, i) : self__.afn.call(null, a, b, c, d, e, f, g, h, i);
  };
  var G__46288__11 = function(self__, a, b, c, d, e, f, g, h, i, j) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a, b, c, d, e, f, g, h, i, j) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j);
  };
  var G__46288__12 = function(self__, a, b, c, d, e, f, g, h, i, j, k) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a, b, c, d, e, f, g, h, i, j, k) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k);
  };
  var G__46288__13 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a, b, c, d, e, f, g, h, i, j, k, l) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l);
  };
  var G__46288__14 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a, b, c, d, e, f, g, h, i, j, k, l, m) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m);
  };
  var G__46288__15 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a, b, c, d, e, f, g, h, i, j, k, l, m, n) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
  };
  var G__46288__16 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
  };
  var G__46288__17 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
  };
  var G__46288__18 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
  };
  var G__46288__19 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
  };
  var G__46288__20 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
  };
  var G__46288__21 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
  };
  var G__46288__22 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(self__.afn, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) : cljs.core.apply.call(null, self__.afn, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
  };
  G__46288 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
    switch(arguments.length) {
      case 1:
        return G__46288__1.call(this, self__);
      case 2:
        return G__46288__2.call(this, self__, a);
      case 3:
        return G__46288__3.call(this, self__, a, b);
      case 4:
        return G__46288__4.call(this, self__, a, b, c);
      case 5:
        return G__46288__5.call(this, self__, a, b, c, d);
      case 6:
        return G__46288__6.call(this, self__, a, b, c, d, e);
      case 7:
        return G__46288__7.call(this, self__, a, b, c, d, e, f);
      case 8:
        return G__46288__8.call(this, self__, a, b, c, d, e, f, g);
      case 9:
        return G__46288__9.call(this, self__, a, b, c, d, e, f, g, h);
      case 10:
        return G__46288__10.call(this, self__, a, b, c, d, e, f, g, h, i);
      case 11:
        return G__46288__11.call(this, self__, a, b, c, d, e, f, g, h, i, j);
      case 12:
        return G__46288__12.call(this, self__, a, b, c, d, e, f, g, h, i, j, k);
      case 13:
        return G__46288__13.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l);
      case 14:
        return G__46288__14.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m);
      case 15:
        return G__46288__15.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      case 16:
        return G__46288__16.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      case 17:
        return G__46288__17.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      case 18:
        return G__46288__18.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      case 19:
        return G__46288__19.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
      case 20:
        return G__46288__20.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
      case 21:
        return G__46288__21.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
      case 22:
        return G__46288__22.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__46288.cljs$core$IFn$_invoke$arity$1 = G__46288__1;
  G__46288.cljs$core$IFn$_invoke$arity$2 = G__46288__2;
  G__46288.cljs$core$IFn$_invoke$arity$3 = G__46288__3;
  G__46288.cljs$core$IFn$_invoke$arity$4 = G__46288__4;
  G__46288.cljs$core$IFn$_invoke$arity$5 = G__46288__5;
  G__46288.cljs$core$IFn$_invoke$arity$6 = G__46288__6;
  G__46288.cljs$core$IFn$_invoke$arity$7 = G__46288__7;
  G__46288.cljs$core$IFn$_invoke$arity$8 = G__46288__8;
  G__46288.cljs$core$IFn$_invoke$arity$9 = G__46288__9;
  G__46288.cljs$core$IFn$_invoke$arity$10 = G__46288__10;
  G__46288.cljs$core$IFn$_invoke$arity$11 = G__46288__11;
  G__46288.cljs$core$IFn$_invoke$arity$12 = G__46288__12;
  G__46288.cljs$core$IFn$_invoke$arity$13 = G__46288__13;
  G__46288.cljs$core$IFn$_invoke$arity$14 = G__46288__14;
  G__46288.cljs$core$IFn$_invoke$arity$15 = G__46288__15;
  G__46288.cljs$core$IFn$_invoke$arity$16 = G__46288__16;
  G__46288.cljs$core$IFn$_invoke$arity$17 = G__46288__17;
  G__46288.cljs$core$IFn$_invoke$arity$18 = G__46288__18;
  G__46288.cljs$core$IFn$_invoke$arity$19 = G__46288__19;
  G__46288.cljs$core$IFn$_invoke$arity$20 = G__46288__20;
  G__46288.cljs$core$IFn$_invoke$arity$21 = G__46288__21;
  G__46288.cljs$core$IFn$_invoke$arity$22 = G__46288__22;
  return G__46288;
}();
cljs.core.MetaFn.prototype.apply = function(self__, args46287) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args46287)));
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0 = function() {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1 = function(a) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null, a);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2 = function(a, b) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a, b) : self__.afn.call(null, a, b);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3 = function(a, b, c) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a, b, c) : self__.afn.call(null, a, b, c);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4 = function(a, b, c, d) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a, b, c, d) : self__.afn.call(null, a, b, c, d);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5 = function(a, b, c, d, e) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a, b, c, d, e) : self__.afn.call(null, a, b, c, d, e);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6 = function(a, b, c, d, e, f) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a, b, c, d, e, f) : self__.afn.call(null, a, b, c, d, e, f);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7 = function(a, b, c, d, e, f, g) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a, b, c, d, e, f, g) : self__.afn.call(null, a, b, c, d, e, f, g);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8 = function(a, b, c, d, e, f, g, h) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a, b, c, d, e, f, g, h) : self__.afn.call(null, a, b, c, d, e, f, g, h);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9 = function(a, b, c, d, e, f, g, h, i) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a, b, c, d, e, f, g, h, i) : self__.afn.call(null, a, b, c, d, e, f, g, h, i);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10 = function(a, b, c, d, e, f, g, h, i, j) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a, b, c, d, e, f, g, h, i, j) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11 = function(a, b, c, d, e, f, g, h, i, j, k) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a, b, c, d, e, f, g, h, i, j, k) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12 = function(a, b, c, d, e, f, g, h, i, j, k, l) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a, b, c, d, e, f, g, h, i, j, k, l) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13 = function(a, b, c, d, e, f, g, h, i, j, k, l, m) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a, b, c, d, e, f, g, h, i, j, k, l, m) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a, b, c, d, e, f, g, h, i, j, k, l, m, n) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
  var self__ = this;
  var _ = this;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(self__.afn, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) : cljs.core.apply.call(null, self__.afn, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
};
cljs.core.MetaFn.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "afn", "afn", 216963467, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null)], null);
};
cljs.core.MetaFn.cljs$lang$type = true;
cljs.core.MetaFn.cljs$lang$ctorStr = "cljs.core/MetaFn";
cljs.core.MetaFn.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/MetaFn");
};
cljs.core.__GT_MetaFn = function cljs$core$__GT_MetaFn(afn, meta) {
  return new cljs.core.MetaFn(afn, meta);
};
cljs.core.with_meta = function cljs$core$with_meta(o, meta) {
  if (goog.isFunction(o)) {
    return new cljs.core.MetaFn(o, meta);
  } else {
    if (o == null) {
      return null;
    } else {
      return cljs.core._with_meta(o, meta);
    }
  }
};
cljs.core.meta = function cljs$core$meta(o) {
  if (function() {
    var and__9142__auto__ = !(o == null);
    if (and__9142__auto__) {
      if (!(o == null)) {
        if (o.cljs$lang$protocol_mask$partition0$ & 131072 || cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IMeta$) {
          return true;
        } else {
          if (!o.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta, o);
          } else {
            return false;
          }
        }
      } else {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta, o);
      }
    } else {
      return and__9142__auto__;
    }
  }()) {
    return cljs.core._meta(o);
  } else {
    return null;
  }
};
cljs.core.peek = function cljs$core$peek(coll) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._peek(coll);
  }
};
cljs.core.pop = function cljs$core$pop(coll) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._pop(coll);
  }
};
cljs.core.disj = function cljs$core$disj(var_args) {
  var args46293 = [];
  var len__10375__auto___46299 = arguments.length;
  var i__10376__auto___46300 = 0;
  while (true) {
    if (i__10376__auto___46300 < len__10375__auto___46299) {
      args46293.push(arguments[i__10376__auto___46300]);
      var G__46301 = i__10376__auto___46300 + 1;
      i__10376__auto___46300 = G__46301;
      continue;
    } else {
    }
    break;
  }
  var G__46298 = args46293.length;
  switch(G__46298) {
    case 1:
      return cljs.core.disj.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46293.slice(2), 0, null);
      return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10398__auto__);
  }
};
cljs.core.disj.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return coll;
};
cljs.core.disj.cljs$core$IFn$_invoke$arity$2 = function(coll, k) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._disjoin(coll, k);
  }
};
cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic = function(coll, k, ks) {
  while (true) {
    if (coll == null) {
      return null;
    } else {
      var ret = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(coll, k);
      if (cljs.core.truth_(ks)) {
        var G__46303 = ret;
        var G__46304 = cljs.core.first(ks);
        var G__46305 = cljs.core.next(ks);
        coll = G__46303;
        k = G__46304;
        ks = G__46305;
        continue;
      } else {
        return ret;
      }
    }
    break;
  }
};
cljs.core.disj.cljs$lang$applyTo = function(seq46294) {
  var G__46295 = cljs.core.first(seq46294);
  var seq46294__$1 = cljs.core.next(seq46294);
  var G__46296 = cljs.core.first(seq46294__$1);
  var seq46294__$2 = cljs.core.next(seq46294__$1);
  return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic(G__46295, G__46296, seq46294__$2);
};
cljs.core.disj.cljs$lang$maxFixedArity = 2;
cljs.core.empty_QMARK_ = function cljs$core$empty_QMARK_(coll) {
  return coll == null || cljs.core.not(cljs.core.seq(coll));
};
cljs.core.coll_QMARK_ = function cljs$core$coll_QMARK_(x) {
  if (x == null) {
    return false;
  } else {
    if (!(x == null)) {
      if (x.cljs$lang$protocol_mask$partition0$ & 8 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ICollection$) {
        return true;
      } else {
        if (!x.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection, x);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection, x);
    }
  }
};
cljs.core.set_QMARK_ = function cljs$core$set_QMARK_(x) {
  if (x == null) {
    return false;
  } else {
    if (!(x == null)) {
      if (x.cljs$lang$protocol_mask$partition0$ & 4096 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISet$) {
        return true;
      } else {
        if (!x.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.ISet, x);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.ISet, x);
    }
  }
};
cljs.core.associative_QMARK_ = function cljs$core$associative_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 512 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IAssociative$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative, x);
  }
};
cljs.core.ifind_QMARK_ = function cljs$core$ifind_QMARK_(x) {
  if (!(x == null)) {
    if (false || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IFind$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IFind, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IFind, x);
  }
};
cljs.core.sequential_QMARK_ = function cljs$core$sequential_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 16777216 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISequential$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential, x);
  }
};
cljs.core.sorted_QMARK_ = function cljs$core$sorted_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 268435456 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISorted$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted, x);
  }
};
cljs.core.reduceable_QMARK_ = function cljs$core$reduceable_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 524288 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IReduce$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce, x);
  }
};
cljs.core.map_QMARK_ = function cljs$core$map_QMARK_(x) {
  if (x == null) {
    return false;
  } else {
    if (!(x == null)) {
      if (x.cljs$lang$protocol_mask$partition0$ & 1024 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMap$) {
        return true;
      } else {
        if (!x.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.IMap, x);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.IMap, x);
    }
  }
};
cljs.core.record_QMARK_ = function cljs$core$record_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 67108864 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IRecord$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord, x);
  }
};
cljs.core.vector_QMARK_ = function cljs$core$vector_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 16384 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IVector$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IVector, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IVector, x);
  }
};
cljs.core.chunked_seq_QMARK_ = function cljs$core$chunked_seq_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition1$ & 512 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IChunkedSeq$) {
      return true;
    } else {
      return false;
    }
  } else {
    return false;
  }
};
cljs.core.js_obj = function cljs$core$js_obj(var_args) {
  var args46328 = [];
  var len__10375__auto___46334 = arguments.length;
  var i__10376__auto___46335 = 0;
  while (true) {
    if (i__10376__auto___46335 < len__10375__auto___46334) {
      args46328.push(arguments[i__10376__auto___46335]);
      var G__46336 = i__10376__auto___46335 + 1;
      i__10376__auto___46335 = G__46336;
      continue;
    } else {
    }
    break;
  }
  var G__46331 = args46328.length;
  switch(G__46331) {
    case 0:
      return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0();
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46328.slice(0), 0, null);
      return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(argseq__10398__auto__);
  }
};
cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0 = function() {
  return {};
};
cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic = function(keyvals) {
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$2 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$2(goog.object.create, keyvals) : cljs.core.apply.call(null, goog.object.create, keyvals);
};
cljs.core.js_obj.cljs$lang$applyTo = function(seq46329) {
  return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46329));
};
cljs.core.js_obj.cljs$lang$maxFixedArity = 0;
cljs.core.js_keys = function cljs$core$js_keys(obj) {
  var keys = [];
  var G__46340_46342 = obj;
  var G__46341_46343 = function(G__46340_46342, keys) {
    return function(val, key, obj__$1) {
      return keys.push(key);
    };
  }(G__46340_46342, keys);
  goog.object.forEach(G__46340_46342, G__46341_46343);
  return keys;
};
cljs.core.js_delete = function cljs$core$js_delete(obj, key) {
  return delete obj[key];
};
cljs.core.array_copy = function cljs$core$array_copy(from, i, to, j, len) {
  var i__$1 = i;
  var j__$1 = j;
  var len__$1 = len;
  while (true) {
    if (len__$1 === 0) {
      return to;
    } else {
      to[j__$1] = from[i__$1];
      var G__46344 = i__$1 + 1;
      var G__46345 = j__$1 + 1;
      var G__46346 = len__$1 - 1;
      i__$1 = G__46344;
      j__$1 = G__46345;
      len__$1 = G__46346;
      continue;
    }
    break;
  }
};
cljs.core.array_copy_downward = function cljs$core$array_copy_downward(from, i, to, j, len) {
  var i__$1 = i + (len - 1);
  var j__$1 = j + (len - 1);
  var len__$1 = len;
  while (true) {
    if (len__$1 === 0) {
      return to;
    } else {
      to[j__$1] = from[i__$1];
      var G__46347 = i__$1 - 1;
      var G__46348 = j__$1 - 1;
      var G__46349 = len__$1 - 1;
      i__$1 = G__46347;
      j__$1 = G__46348;
      len__$1 = G__46349;
      continue;
    }
    break;
  }
};
cljs.core.lookup_sentinel = {};
cljs.core.false_QMARK_ = function cljs$core$false_QMARK_(x) {
  return x === false;
};
cljs.core.true_QMARK_ = function cljs$core$true_QMARK_(x) {
  return x === true;
};
cljs.core.boolean_QMARK_ = function cljs$core$boolean_QMARK_(x) {
  return x === true || x === false;
};
cljs.core.undefined_QMARK_ = function cljs$core$undefined_QMARK_(x) {
  return void 0 === x;
};
cljs.core.seq_QMARK_ = function cljs$core$seq_QMARK_(s) {
  if (s == null) {
    return false;
  } else {
    if (!(s == null)) {
      if (s.cljs$lang$protocol_mask$partition0$ & 64 || cljs.core.PROTOCOL_SENTINEL === s.cljs$core$ISeq$) {
        return true;
      } else {
        if (!s.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq, s);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq, s);
    }
  }
};
cljs.core.seqable_QMARK_ = function cljs$core$seqable_QMARK_(s) {
  var or__9154__auto__ = !(s == null) ? s.cljs$lang$protocol_mask$partition0$ & 8388608 || cljs.core.PROTOCOL_SENTINEL === s.cljs$core$ISeqable$ ? true : !s.cljs$lang$protocol_mask$partition0$ ? cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable, s) : false : cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable, s);
  if (or__9154__auto__) {
    return or__9154__auto__;
  } else {
    return cljs.core.array_QMARK_(s) || typeof s === "string";
  }
};
cljs.core.boolean$ = function cljs$core$boolean(x) {
  if (x == null) {
    return false;
  } else {
    if (x === false) {
      return false;
    } else {
      return true;
    }
  }
};
cljs.core.ifn_QMARK_ = function cljs$core$ifn_QMARK_(f) {
  var or__9154__auto__ = cljs.core.fn_QMARK_(f);
  if (or__9154__auto__) {
    return or__9154__auto__;
  } else {
    if (!(f == null)) {
      if (f.cljs$lang$protocol_mask$partition0$ & 1 || cljs.core.PROTOCOL_SENTINEL === f.cljs$core$IFn$) {
        return true;
      } else {
        if (!f.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.IFn, f);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.IFn, f);
    }
  }
};
cljs.core.integer_QMARK_ = function cljs$core$integer_QMARK_(n) {
  return typeof n === "number" && !isNaN(n) && !(n === Infinity) && parseFloat(n) === parseInt(n, 10);
};
cljs.core.int_QMARK_ = function cljs$core$int_QMARK_(x) {
  return cljs.core.integer_QMARK_(x) || x instanceof goog.math.Integer || x instanceof goog.math.Long;
};
cljs.core.pos_int_QMARK_ = function cljs$core$pos_int_QMARK_(x) {
  if (cljs.core.integer_QMARK_(x)) {
    return x > 0;
  } else {
    if (x instanceof goog.math.Integer) {
      return cljs.core.not(x.isNegative()) && cljs.core.not(x.isZero());
    } else {
      if (x instanceof goog.math.Long) {
        return cljs.core.not(x.isNegative()) && cljs.core.not(x.isZero());
      } else {
        return false;
      }
    }
  }
};
cljs.core.neg_int_QMARK_ = function cljs$core$neg_int_QMARK_(x) {
  if (cljs.core.integer_QMARK_(x)) {
    return x < 0;
  } else {
    if (x instanceof goog.math.Integer) {
      return x.isNegative();
    } else {
      if (x instanceof goog.math.Long) {
        return x.isNegative();
      } else {
        return false;
      }
    }
  }
};
cljs.core.nat_int_QMARK_ = function cljs$core$nat_int_QMARK_(x) {
  if (cljs.core.integer_QMARK_(x)) {
    return !(x < 0) || x === 0;
  } else {
    if (x instanceof goog.math.Integer) {
      var or__9154__auto__ = cljs.core.not(x.isNegative());
      if (or__9154__auto__) {
        return or__9154__auto__;
      } else {
        return x.isZero();
      }
    } else {
      if (x instanceof goog.math.Long) {
        var or__9154__auto__ = cljs.core.not(x.isNegative());
        if (or__9154__auto__) {
          return or__9154__auto__;
        } else {
          return x.isZero();
        }
      } else {
        return false;
      }
    }
  }
};
cljs.core.float_QMARK_ = function cljs$core$float_QMARK_(x) {
  return typeof x === "number";
};
cljs.core.double_QMARK_ = function cljs$core$double_QMARK_(x) {
  return typeof x === "number";
};
cljs.core.infinite_QMARK_ = function cljs$core$infinite_QMARK_(x) {
  return x === Number.POSITIVE_INFINITY || x === Number.NEGATIVE_INFINITY;
};
cljs.core.contains_QMARK_ = function cljs$core$contains_QMARK_(coll, v) {
  if (cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return false;
  } else {
    return true;
  }
};
cljs.core.find = function cljs$core$find(coll, k) {
  if (!(coll == null) && cljs.core.associative_QMARK_(coll) && cljs.core.contains_QMARK_(coll, k)) {
    if (cljs.core.ifind_QMARK_(coll)) {
      return cljs.core._find(coll, k);
    } else {
      return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k, cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, k)], null);
    }
  } else {
    return null;
  }
};
cljs.core.distinct_QMARK_ = function cljs$core$distinct_QMARK_(var_args) {
  var args46362 = [];
  var len__10375__auto___46368 = arguments.length;
  var i__10376__auto___46369 = 0;
  while (true) {
    if (i__10376__auto___46369 < len__10375__auto___46368) {
      args46362.push(arguments[i__10376__auto___46369]);
      var G__46370 = i__10376__auto___46369 + 1;
      i__10376__auto___46369 = G__46370;
      continue;
    } else {
    }
    break;
  }
  var G__46367 = args46362.length;
  switch(G__46367) {
    case 1:
      return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46362.slice(2), 0, null);
      return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10398__auto__);
  }
};
cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return !cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y);
};
cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  if (!cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y)) {
    var s = cljs.core.PersistentHashSet.createAsIfByAssoc([x, y]);
    var xs = more;
    while (true) {
      var x__$1 = cljs.core.first(xs);
      var etc = cljs.core.next(xs);
      if (cljs.core.truth_(xs)) {
        if (cljs.core.contains_QMARK_(s, x__$1)) {
          return false;
        } else {
          var G__46372 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s, x__$1);
          var G__46373 = etc;
          s = G__46372;
          xs = G__46373;
          continue;
        }
      } else {
        return true;
      }
      break;
    }
  } else {
    return false;
  }
};
cljs.core.distinct_QMARK_.cljs$lang$applyTo = function(seq46363) {
  var G__46364 = cljs.core.first(seq46363);
  var seq46363__$1 = cljs.core.next(seq46363);
  var G__46365 = cljs.core.first(seq46363__$1);
  var seq46363__$2 = cljs.core.next(seq46363__$1);
  return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__46364, G__46365, seq46363__$2);
};
cljs.core.distinct_QMARK_.cljs$lang$maxFixedArity = 2;
cljs.core.compare = function cljs$core$compare(x, y) {
  if (x === y) {
    return 0;
  } else {
    if (x == null) {
      return -1;
    } else {
      if (y == null) {
        return 1;
      } else {
        if (typeof x === "number") {
          if (typeof y === "number") {
            return goog.array.defaultCompare(x, y);
          } else {
            throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Cannot compare "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(x), cljs.core.str.cljs$core$IFn$_invoke$arity$1(" to "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(y)].join(""));
          }
        } else {
          if (!(x == null) ? x.cljs$lang$protocol_mask$partition1$ & 2048 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IComparable$ ? true : !x.cljs$lang$protocol_mask$partition1$ ? cljs.core.native_satisfies_QMARK_(cljs.core.IComparable, x) : false : cljs.core.native_satisfies_QMARK_(cljs.core.IComparable, x)) {
            return cljs.core._compare(x, y);
          } else {
            if ((typeof x === "string" || cljs.core.array_QMARK_(x) || x === true || x === false) && cljs.core.type(x) === cljs.core.type(y)) {
              return goog.array.defaultCompare(x, y);
            } else {
              throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Cannot compare "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(x), cljs.core.str.cljs$core$IFn$_invoke$arity$1(" to "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(y)].join(""));
            }
          }
        }
      }
    }
  }
};
cljs.core.compare_indexed = function cljs$core$compare_indexed(var_args) {
  var args46376 = [];
  var len__10375__auto___46379 = arguments.length;
  var i__10376__auto___46380 = 0;
  while (true) {
    if (i__10376__auto___46380 < len__10375__auto___46379) {
      args46376.push(arguments[i__10376__auto___46380]);
      var G__46381 = i__10376__auto___46380 + 1;
      i__10376__auto___46380 = G__46381;
      continue;
    } else {
    }
    break;
  }
  var G__46378 = args46376.length;
  switch(G__46378) {
    case 2:
      return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 4:
      return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args46376.length)].join(""));
  }
};
cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2 = function(xs, ys) {
  var xl = cljs.core.count(xs);
  var yl = cljs.core.count(ys);
  if (xl < yl) {
    return -1;
  } else {
    if (xl > yl) {
      return 1;
    } else {
      if (xl === 0) {
        return 0;
      } else {
        return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(xs, ys, xl, 0);
      }
    }
  }
};
cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4 = function(xs, ys, len, n) {
  while (true) {
    var d = cljs.core.compare(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(xs, n), cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ys, n));
    if (d === 0 && n + 1 < len) {
      var G__46383 = xs;
      var G__46384 = ys;
      var G__46385 = len;
      var G__46386 = n + 1;
      xs = G__46383;
      ys = G__46384;
      len = G__46385;
      n = G__46386;
      continue;
    } else {
      return d;
    }
    break;
  }
};
cljs.core.compare_indexed.cljs$lang$maxFixedArity = 4;
cljs.core.fn__GT_comparator = function cljs$core$fn__GT_comparator(f) {
  if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f, cljs.core.compare)) {
    return cljs.core.compare;
  } else {
    return function(x, y) {
      var r = f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x, y) : f.call(null, x, y);
      if (typeof r === "number") {
        return r;
      } else {
        if (cljs.core.truth_(r)) {
          return -1;
        } else {
          if (cljs.core.truth_(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(y, x) : f.call(null, y, x))) {
            return 1;
          } else {
            return 0;
          }
        }
      }
    };
  }
};
cljs.core.sort = function cljs$core$sort(var_args) {
  var args46387 = [];
  var len__10375__auto___46392 = arguments.length;
  var i__10376__auto___46393 = 0;
  while (true) {
    if (i__10376__auto___46393 < len__10375__auto___46392) {
      args46387.push(arguments[i__10376__auto___46393]);
      var G__46394 = i__10376__auto___46393 + 1;
      i__10376__auto___46393 = G__46394;
      continue;
    } else {
    }
    break;
  }
  var G__46389 = args46387.length;
  switch(G__46389) {
    case 1:
      return cljs.core.sort.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args46387.length)].join(""));
  }
};
cljs.core.sort.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare, coll);
};
cljs.core.sort.cljs$core$IFn$_invoke$arity$2 = function(comp, coll) {
  if (cljs.core.seq(coll)) {
    var a = cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.to_array.call(null, coll);
    var G__46390_46396 = a;
    var G__46391_46397 = cljs.core.fn__GT_comparator(comp);
    goog.array.stableSort(G__46390_46396, G__46391_46397);
    return cljs.core.seq(a);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.sort.cljs$lang$maxFixedArity = 2;
cljs.core.sort_by = function cljs$core$sort_by(var_args) {
  var args46398 = [];
  var len__10375__auto___46401 = arguments.length;
  var i__10376__auto___46402 = 0;
  while (true) {
    if (i__10376__auto___46402 < len__10375__auto___46401) {
      args46398.push(arguments[i__10376__auto___46402]);
      var G__46403 = i__10376__auto___46402 + 1;
      i__10376__auto___46402 = G__46403;
      continue;
    } else {
    }
    break;
  }
  var G__46400 = args46398.length;
  switch(G__46400) {
    case 2:
      return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args46398.length)].join(""));
  }
};
cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2 = function(keyfn, coll) {
  return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn, cljs.core.compare, coll);
};
cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3 = function(keyfn, comp, coll) {
  return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(function(x, y) {
    return cljs.core.fn__GT_comparator(comp).call(null, keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(x) : keyfn.call(null, x), keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(y) : keyfn.call(null, y));
  }, coll);
};
cljs.core.sort_by.cljs$lang$maxFixedArity = 3;
cljs.core.seq_reduce = function cljs$core$seq_reduce(var_args) {
  var args46405 = [];
  var len__10375__auto___46413 = arguments.length;
  var i__10376__auto___46414 = 0;
  while (true) {
    if (i__10376__auto___46414 < len__10375__auto___46413) {
      args46405.push(arguments[i__10376__auto___46414]);
      var G__46415 = i__10376__auto___46414 + 1;
      i__10376__auto___46414 = G__46415;
      continue;
    } else {
    }
    break;
  }
  var G__46407 = args46405.length;
  switch(G__46407) {
    case 2:
      return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args46405.length)].join(""));
  }
};
cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  var temp__6736__auto__ = cljs.core.seq(coll);
  if (temp__6736__auto__) {
    var s = temp__6736__auto__;
    var G__46408 = f;
    var G__46409 = cljs.core.first(s);
    var G__46410 = cljs.core.next(s);
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__46408, G__46409, G__46410) : cljs.core.reduce.call(null, G__46408, G__46409, G__46410);
  } else {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  }
};
cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 = function(f, val, coll) {
  var val__$1 = val;
  var coll__$1 = cljs.core.seq(coll);
  while (true) {
    if (coll__$1) {
      var nval = function() {
        var G__46411 = val__$1;
        var G__46412 = cljs.core.first(coll__$1);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__46411, G__46412) : f.call(null, G__46411, G__46412);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__46417 = nval;
        var G__46418 = cljs.core.next(coll__$1);
        val__$1 = G__46417;
        coll__$1 = G__46418;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.seq_reduce.cljs$lang$maxFixedArity = 3;
cljs.core.shuffle = function cljs$core$shuffle(coll) {
  var a = cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.to_array.call(null, coll);
  goog.array.shuffle(a);
  return cljs.core.vec.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vec.cljs$core$IFn$_invoke$arity$1(a) : cljs.core.vec.call(null, a);
};
cljs.core.reduce = function cljs$core$reduce(var_args) {
  var args46419 = [];
  var len__10375__auto___46424 = arguments.length;
  var i__10376__auto___46425 = 0;
  while (true) {
    if (i__10376__auto___46425 < len__10375__auto___46424) {
      args46419.push(arguments[i__10376__auto___46425]);
      var G__46426 = i__10376__auto___46425 + 1;
      i__10376__auto___46425 = G__46426;
      continue;
    } else {
    }
    break;
  }
  var G__46421 = args46419.length;
  switch(G__46421) {
    case 2:
      return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args46419.length)].join(""));
  }
};
cljs.core.reduce.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 524288 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReduce$ ? true : false : false) {
    return coll.cljs$core$IReduce$_reduce$arity$2(null, f);
  } else {
    if (cljs.core.array_QMARK_(coll)) {
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll, f);
    } else {
      if (typeof coll === "string") {
        return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll, f);
      } else {
        if (cljs.core.native_satisfies_QMARK_(cljs.core.IReduce, coll)) {
          return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(coll, f);
        } else {
          return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll);
        }
      }
    }
  }
};
cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 = function(f, val, coll) {
  if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 524288 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReduce$ ? true : false : false) {
    return coll.cljs$core$IReduce$_reduce$arity$3(null, f, val);
  } else {
    if (cljs.core.array_QMARK_(coll)) {
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll, f, val);
    } else {
      if (typeof coll === "string") {
        return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll, f, val);
      } else {
        if (cljs.core.native_satisfies_QMARK_(cljs.core.IReduce, coll)) {
          return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(coll, f, val);
        } else {
          return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, val, coll);
        }
      }
    }
  }
};
cljs.core.reduce.cljs$lang$maxFixedArity = 3;
cljs.core.reduce_kv = function cljs$core$reduce_kv(f, init, coll) {
  if (!(coll == null)) {
    return cljs.core._kv_reduce(coll, f, init);
  } else {
    return init;
  }
};
cljs.core.identity = function cljs$core$identity(x) {
  return x;
};
cljs.core.completing = function cljs$core$completing(var_args) {
  var args46428 = [];
  var len__10375__auto___46431 = arguments.length;
  var i__10376__auto___46432 = 0;
  while (true) {
    if (i__10376__auto___46432 < len__10375__auto___46431) {
      args46428.push(arguments[i__10376__auto___46432]);
      var G__46433 = i__10376__auto___46432 + 1;
      i__10376__auto___46432 = G__46433;
      continue;
    } else {
    }
    break;
  }
  var G__46430 = args46428.length;
  switch(G__46430) {
    case 1:
      return cljs.core.completing.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args46428.length)].join(""));
  }
};
cljs.core.completing.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(f, cljs.core.identity);
};
cljs.core.completing.cljs$core$IFn$_invoke$arity$2 = function(f, cf) {
  return function() {
    var G__46435 = null;
    var G__46435__0 = function() {
      return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
    };
    var G__46435__1 = function(x) {
      return cf.cljs$core$IFn$_invoke$arity$1 ? cf.cljs$core$IFn$_invoke$arity$1(x) : cf.call(null, x);
    };
    var G__46435__2 = function(x, y) {
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x, y) : f.call(null, x, y);
    };
    G__46435 = function(x, y) {
      switch(arguments.length) {
        case 0:
          return G__46435__0.call(this);
        case 1:
          return G__46435__1.call(this, x);
        case 2:
          return G__46435__2.call(this, x, y);
      }
      throw new Error("Invalid arity: " + (arguments.length - 1));
    };
    G__46435.cljs$core$IFn$_invoke$arity$0 = G__46435__0;
    G__46435.cljs$core$IFn$_invoke$arity$1 = G__46435__1;
    G__46435.cljs$core$IFn$_invoke$arity$2 = G__46435__2;
    return G__46435;
  }();
};
cljs.core.completing.cljs$lang$maxFixedArity = 2;
cljs.core.transduce = function cljs$core$transduce(var_args) {
  var args46436 = [];
  var len__10375__auto___46439 = arguments.length;
  var i__10376__auto___46440 = 0;
  while (true) {
    if (i__10376__auto___46440 < len__10375__auto___46439) {
      args46436.push(arguments[i__10376__auto___46440]);
      var G__46441 = i__10376__auto___46440 + 1;
      i__10376__auto___46440 = G__46441;
      continue;
    } else {
    }
    break;
  }
  var G__46438 = args46436.length;
  switch(G__46438) {
    case 3:
      return cljs.core.transduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args46436.length)].join(""));
  }
};
cljs.core.transduce.cljs$core$IFn$_invoke$arity$3 = function(xform, f, coll) {
  return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform, f, f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null), coll);
};
cljs.core.transduce.cljs$core$IFn$_invoke$arity$4 = function(xform, f, init, coll) {
  var f__$1 = xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null, f);
  var ret = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f__$1, init, coll);
  return f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(ret) : f__$1.call(null, ret);
};
cljs.core.transduce.cljs$lang$maxFixedArity = 4;
cljs.core._PLUS_ = function cljs$core$_PLUS_(var_args) {
  var args46443 = [];
  var len__10375__auto___46449 = arguments.length;
  var i__10376__auto___46450 = 0;
  while (true) {
    if (i__10376__auto___46450 < len__10375__auto___46449) {
      args46443.push(arguments[i__10376__auto___46450]);
      var G__46451 = i__10376__auto___46450 + 1;
      i__10376__auto___46450 = G__46451;
      continue;
    } else {
    }
    break;
  }
  var G__46448 = args46443.length;
  switch(G__46448) {
    case 0:
      return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46443.slice(2), 0, null);
      return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10398__auto__);
  }
};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0 = function() {
  return 0;
};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x + y;
};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_, x + y, more);
};
cljs.core._PLUS_.cljs$lang$applyTo = function(seq46444) {
  var G__46445 = cljs.core.first(seq46444);
  var seq46444__$1 = cljs.core.next(seq46444);
  var G__46446 = cljs.core.first(seq46444__$1);
  var seq46444__$2 = cljs.core.next(seq46444__$1);
  return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic(G__46445, G__46446, seq46444__$2);
};
cljs.core._PLUS_.cljs$lang$maxFixedArity = 2;
cljs.core._ = function cljs$core$_(var_args) {
  var args46453 = [];
  var len__10375__auto___46459 = arguments.length;
  var i__10376__auto___46460 = 0;
  while (true) {
    if (i__10376__auto___46460 < len__10375__auto___46459) {
      args46453.push(arguments[i__10376__auto___46460]);
      var G__46461 = i__10376__auto___46460 + 1;
      i__10376__auto___46460 = G__46461;
      continue;
    } else {
    }
    break;
  }
  var G__46458 = args46453.length;
  switch(G__46458) {
    case 1:
      return cljs.core._.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46453.slice(2), 0, null);
      return cljs.core._.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10398__auto__);
  }
};
cljs.core._.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return -x;
};
cljs.core._.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x - y;
};
cljs.core._.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._, x - y, more);
};
cljs.core._.cljs$lang$applyTo = function(seq46454) {
  var G__46455 = cljs.core.first(seq46454);
  var seq46454__$1 = cljs.core.next(seq46454);
  var G__46456 = cljs.core.first(seq46454__$1);
  var seq46454__$2 = cljs.core.next(seq46454__$1);
  return cljs.core._.cljs$core$IFn$_invoke$arity$variadic(G__46455, G__46456, seq46454__$2);
};
cljs.core._.cljs$lang$maxFixedArity = 2;
cljs.core._STAR_ = function cljs$core$_STAR_(var_args) {
  var args46463 = [];
  var len__10375__auto___46469 = arguments.length;
  var i__10376__auto___46470 = 0;
  while (true) {
    if (i__10376__auto___46470 < len__10375__auto___46469) {
      args46463.push(arguments[i__10376__auto___46470]);
      var G__46471 = i__10376__auto___46470 + 1;
      i__10376__auto___46470 = G__46471;
      continue;
    } else {
    }
    break;
  }
  var G__46468 = args46463.length;
  switch(G__46468) {
    case 0:
      return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46463.slice(2), 0, null);
      return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10398__auto__);
  }
};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0 = function() {
  return 1;
};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x * y;
};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_, x * y, more);
};
cljs.core._STAR_.cljs$lang$applyTo = function(seq46464) {
  var G__46465 = cljs.core.first(seq46464);
  var seq46464__$1 = cljs.core.next(seq46464);
  var G__46466 = cljs.core.first(seq46464__$1);
  var seq46464__$2 = cljs.core.next(seq46464__$1);
  return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic(G__46465, G__46466, seq46464__$2);
};
cljs.core._STAR_.cljs$lang$maxFixedArity = 2;
cljs.core._SLASH_ = function cljs$core$_SLASH_(var_args) {
  var args46473 = [];
  var len__10375__auto___46479 = arguments.length;
  var i__10376__auto___46480 = 0;
  while (true) {
    if (i__10376__auto___46480 < len__10375__auto___46479) {
      args46473.push(arguments[i__10376__auto___46480]);
      var G__46481 = i__10376__auto___46480 + 1;
      i__10376__auto___46480 = G__46481;
      continue;
    } else {
    }
    break;
  }
  var G__46478 = args46473.length;
  switch(G__46478) {
    case 1:
      return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46473.slice(2), 0, null);
      return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10398__auto__);
  }
};
cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return 1 / x;
};
cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x / y;
};
cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_, x / y, more);
};
cljs.core._SLASH_.cljs$lang$applyTo = function(seq46474) {
  var G__46475 = cljs.core.first(seq46474);
  var seq46474__$1 = cljs.core.next(seq46474);
  var G__46476 = cljs.core.first(seq46474__$1);
  var seq46474__$2 = cljs.core.next(seq46474__$1);
  return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic(G__46475, G__46476, seq46474__$2);
};
cljs.core._SLASH_.cljs$lang$maxFixedArity = 2;
cljs.core._LT_ = function cljs$core$_LT_(var_args) {
  var args46483 = [];
  var len__10375__auto___46489 = arguments.length;
  var i__10376__auto___46490 = 0;
  while (true) {
    if (i__10376__auto___46490 < len__10375__auto___46489) {
      args46483.push(arguments[i__10376__auto___46490]);
      var G__46491 = i__10376__auto___46490 + 1;
      i__10376__auto___46490 = G__46491;
      continue;
    } else {
    }
    break;
  }
  var G__46488 = args46483.length;
  switch(G__46488) {
    case 1:
      return cljs.core._LT_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._LT_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46483.slice(2), 0, null);
      return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10398__auto__);
  }
};
cljs.core._LT_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._LT_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x < y;
};
cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x < y) {
      if (cljs.core.next(more)) {
        var G__46493 = y;
        var G__46494 = cljs.core.first(more);
        var G__46495 = cljs.core.next(more);
        x = G__46493;
        y = G__46494;
        more = G__46495;
        continue;
      } else {
        return y < cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._LT_.cljs$lang$applyTo = function(seq46484) {
  var G__46485 = cljs.core.first(seq46484);
  var seq46484__$1 = cljs.core.next(seq46484);
  var G__46486 = cljs.core.first(seq46484__$1);
  var seq46484__$2 = cljs.core.next(seq46484__$1);
  return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic(G__46485, G__46486, seq46484__$2);
};
cljs.core._LT_.cljs$lang$maxFixedArity = 2;
cljs.core._LT__EQ_ = function cljs$core$_LT__EQ_(var_args) {
  var args46496 = [];
  var len__10375__auto___46502 = arguments.length;
  var i__10376__auto___46503 = 0;
  while (true) {
    if (i__10376__auto___46503 < len__10375__auto___46502) {
      args46496.push(arguments[i__10376__auto___46503]);
      var G__46504 = i__10376__auto___46503 + 1;
      i__10376__auto___46503 = G__46504;
      continue;
    } else {
    }
    break;
  }
  var G__46501 = args46496.length;
  switch(G__46501) {
    case 1:
      return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46496.slice(2), 0, null);
      return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10398__auto__);
  }
};
cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x <= y;
};
cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x <= y) {
      if (cljs.core.next(more)) {
        var G__46506 = y;
        var G__46507 = cljs.core.first(more);
        var G__46508 = cljs.core.next(more);
        x = G__46506;
        y = G__46507;
        more = G__46508;
        continue;
      } else {
        return y <= cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._LT__EQ_.cljs$lang$applyTo = function(seq46497) {
  var G__46498 = cljs.core.first(seq46497);
  var seq46497__$1 = cljs.core.next(seq46497);
  var G__46499 = cljs.core.first(seq46497__$1);
  var seq46497__$2 = cljs.core.next(seq46497__$1);
  return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__46498, G__46499, seq46497__$2);
};
cljs.core._LT__EQ_.cljs$lang$maxFixedArity = 2;
cljs.core._GT_ = function cljs$core$_GT_(var_args) {
  var args46509 = [];
  var len__10375__auto___46515 = arguments.length;
  var i__10376__auto___46516 = 0;
  while (true) {
    if (i__10376__auto___46516 < len__10375__auto___46515) {
      args46509.push(arguments[i__10376__auto___46516]);
      var G__46517 = i__10376__auto___46516 + 1;
      i__10376__auto___46516 = G__46517;
      continue;
    } else {
    }
    break;
  }
  var G__46514 = args46509.length;
  switch(G__46514) {
    case 1:
      return cljs.core._GT_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._GT_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46509.slice(2), 0, null);
      return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10398__auto__);
  }
};
cljs.core._GT_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._GT_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x > y;
};
cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x > y) {
      if (cljs.core.next(more)) {
        var G__46519 = y;
        var G__46520 = cljs.core.first(more);
        var G__46521 = cljs.core.next(more);
        x = G__46519;
        y = G__46520;
        more = G__46521;
        continue;
      } else {
        return y > cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._GT_.cljs$lang$applyTo = function(seq46510) {
  var G__46511 = cljs.core.first(seq46510);
  var seq46510__$1 = cljs.core.next(seq46510);
  var G__46512 = cljs.core.first(seq46510__$1);
  var seq46510__$2 = cljs.core.next(seq46510__$1);
  return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic(G__46511, G__46512, seq46510__$2);
};
cljs.core._GT_.cljs$lang$maxFixedArity = 2;
cljs.core._GT__EQ_ = function cljs$core$_GT__EQ_(var_args) {
  var args46522 = [];
  var len__10375__auto___46528 = arguments.length;
  var i__10376__auto___46529 = 0;
  while (true) {
    if (i__10376__auto___46529 < len__10375__auto___46528) {
      args46522.push(arguments[i__10376__auto___46529]);
      var G__46530 = i__10376__auto___46529 + 1;
      i__10376__auto___46529 = G__46530;
      continue;
    } else {
    }
    break;
  }
  var G__46527 = args46522.length;
  switch(G__46527) {
    case 1:
      return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46522.slice(2), 0, null);
      return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10398__auto__);
  }
};
cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x >= y;
};
cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x >= y) {
      if (cljs.core.next(more)) {
        var G__46532 = y;
        var G__46533 = cljs.core.first(more);
        var G__46534 = cljs.core.next(more);
        x = G__46532;
        y = G__46533;
        more = G__46534;
        continue;
      } else {
        return y >= cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._GT__EQ_.cljs$lang$applyTo = function(seq46523) {
  var G__46524 = cljs.core.first(seq46523);
  var seq46523__$1 = cljs.core.next(seq46523);
  var G__46525 = cljs.core.first(seq46523__$1);
  var seq46523__$2 = cljs.core.next(seq46523__$1);
  return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__46524, G__46525, seq46523__$2);
};
cljs.core._GT__EQ_.cljs$lang$maxFixedArity = 2;
cljs.core.dec = function cljs$core$dec(x) {
  return x - 1;
};
cljs.core.max = function cljs$core$max(var_args) {
  var args46535 = [];
  var len__10375__auto___46541 = arguments.length;
  var i__10376__auto___46542 = 0;
  while (true) {
    if (i__10376__auto___46542 < len__10375__auto___46541) {
      args46535.push(arguments[i__10376__auto___46542]);
      var G__46543 = i__10376__auto___46542 + 1;
      i__10376__auto___46542 = G__46543;
      continue;
    } else {
    }
    break;
  }
  var G__46540 = args46535.length;
  switch(G__46540) {
    case 1:
      return cljs.core.max.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.max.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46535.slice(2), 0, null);
      return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10398__auto__);
  }
};
cljs.core.max.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.max.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  var x__9492__auto__ = x;
  var y__9493__auto__ = y;
  return x__9492__auto__ > y__9493__auto__ ? x__9492__auto__ : y__9493__auto__;
};
cljs.core.max.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max, function() {
    var x__9492__auto__ = x;
    var y__9493__auto__ = y;
    return x__9492__auto__ > y__9493__auto__ ? x__9492__auto__ : y__9493__auto__;
  }(), more);
};
cljs.core.max.cljs$lang$applyTo = function(seq46536) {
  var G__46537 = cljs.core.first(seq46536);
  var seq46536__$1 = cljs.core.next(seq46536);
  var G__46538 = cljs.core.first(seq46536__$1);
  var seq46536__$2 = cljs.core.next(seq46536__$1);
  return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic(G__46537, G__46538, seq46536__$2);
};
cljs.core.max.cljs$lang$maxFixedArity = 2;
cljs.core.min = function cljs$core$min(var_args) {
  var args46545 = [];
  var len__10375__auto___46551 = arguments.length;
  var i__10376__auto___46552 = 0;
  while (true) {
    if (i__10376__auto___46552 < len__10375__auto___46551) {
      args46545.push(arguments[i__10376__auto___46552]);
      var G__46553 = i__10376__auto___46552 + 1;
      i__10376__auto___46552 = G__46553;
      continue;
    } else {
    }
    break;
  }
  var G__46550 = args46545.length;
  switch(G__46550) {
    case 1:
      return cljs.core.min.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.min.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46545.slice(2), 0, null);
      return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10398__auto__);
  }
};
cljs.core.min.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.min.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  var x__9499__auto__ = x;
  var y__9500__auto__ = y;
  return x__9499__auto__ < y__9500__auto__ ? x__9499__auto__ : y__9500__auto__;
};
cljs.core.min.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.min, function() {
    var x__9499__auto__ = x;
    var y__9500__auto__ = y;
    return x__9499__auto__ < y__9500__auto__ ? x__9499__auto__ : y__9500__auto__;
  }(), more);
};
cljs.core.min.cljs$lang$applyTo = function(seq46546) {
  var G__46547 = cljs.core.first(seq46546);
  var seq46546__$1 = cljs.core.next(seq46546);
  var G__46548 = cljs.core.first(seq46546__$1);
  var seq46546__$2 = cljs.core.next(seq46546__$1);
  return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic(G__46547, G__46548, seq46546__$2);
};
cljs.core.min.cljs$lang$maxFixedArity = 2;
cljs.core.byte$ = function cljs$core$byte(x) {
  return x;
};
cljs.core.char$ = function cljs$core$char(x) {
  if (typeof x === "number") {
    return String.fromCharCode(x);
  } else {
    if (typeof x === "string" && x.length === 1) {
      return x;
    } else {
      throw new Error("Argument to char must be a character or number");
    }
  }
};
cljs.core.short$ = function cljs$core$short(x) {
  return x;
};
cljs.core.float$ = function cljs$core$float(x) {
  return x;
};
cljs.core.double$ = function cljs$core$double(x) {
  return x;
};
cljs.core.unchecked_byte = function cljs$core$unchecked_byte(x) {
  return x;
};
cljs.core.unchecked_char = function cljs$core$unchecked_char(x) {
  return x;
};
cljs.core.unchecked_short = function cljs$core$unchecked_short(x) {
  return x;
};
cljs.core.unchecked_float = function cljs$core$unchecked_float(x) {
  return x;
};
cljs.core.unchecked_double = function cljs$core$unchecked_double(x) {
  return x;
};
cljs.core.unchecked_add = function cljs$core$unchecked_add(var_args) {
  var args46555 = [];
  var len__10375__auto___46561 = arguments.length;
  var i__10376__auto___46562 = 0;
  while (true) {
    if (i__10376__auto___46562 < len__10375__auto___46561) {
      args46555.push(arguments[i__10376__auto___46562]);
      var G__46563 = i__10376__auto___46562 + 1;
      i__10376__auto___46562 = G__46563;
      continue;
    } else {
    }
    break;
  }
  var G__46560 = args46555.length;
  switch(G__46560) {
    case 0:
      return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46555.slice(2), 0, null);
      return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10398__auto__);
  }
};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0 = function() {
  return 0;
};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x + y;
};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add, x + y, more);
};
cljs.core.unchecked_add.cljs$lang$applyTo = function(seq46556) {
  var G__46557 = cljs.core.first(seq46556);
  var seq46556__$1 = cljs.core.next(seq46556);
  var G__46558 = cljs.core.first(seq46556__$1);
  var seq46556__$2 = cljs.core.next(seq46556__$1);
  return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic(G__46557, G__46558, seq46556__$2);
};
cljs.core.unchecked_add.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_add_int = function cljs$core$unchecked_add_int(var_args) {
  var args46565 = [];
  var len__10375__auto___46571 = arguments.length;
  var i__10376__auto___46572 = 0;
  while (true) {
    if (i__10376__auto___46572 < len__10375__auto___46571) {
      args46565.push(arguments[i__10376__auto___46572]);
      var G__46573 = i__10376__auto___46572 + 1;
      i__10376__auto___46572 = G__46573;
      continue;
    } else {
    }
    break;
  }
  var G__46570 = args46565.length;
  switch(G__46570) {
    case 0:
      return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46565.slice(2), 0, null);
      return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10398__auto__);
  }
};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0 = function() {
  return 0;
};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x + y;
};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add_int, x + y, more);
};
cljs.core.unchecked_add_int.cljs$lang$applyTo = function(seq46566) {
  var G__46567 = cljs.core.first(seq46566);
  var seq46566__$1 = cljs.core.next(seq46566);
  var G__46568 = cljs.core.first(seq46566__$1);
  var seq46566__$2 = cljs.core.next(seq46566__$1);
  return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic(G__46567, G__46568, seq46566__$2);
};
cljs.core.unchecked_add_int.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_dec = function cljs$core$unchecked_dec(x) {
  return x - 1;
};
cljs.core.unchecked_dec_int = function cljs$core$unchecked_dec_int(x) {
  return x - 1;
};
cljs.core.unchecked_divide_int = function cljs$core$unchecked_divide_int(var_args) {
  var args46575 = [];
  var len__10375__auto___46581 = arguments.length;
  var i__10376__auto___46582 = 0;
  while (true) {
    if (i__10376__auto___46582 < len__10375__auto___46581) {
      args46575.push(arguments[i__10376__auto___46582]);
      var G__46583 = i__10376__auto___46582 + 1;
      i__10376__auto___46582 = G__46583;
      continue;
    } else {
    }
    break;
  }
  var G__46580 = args46575.length;
  switch(G__46580) {
    case 1:
      return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46575.slice(2), 0, null);
      return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10398__auto__);
  }
};
cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return 1 / x;
};
cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x / y;
};
cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_divide_int, x / y, more);
};
cljs.core.unchecked_divide_int.cljs$lang$applyTo = function(seq46576) {
  var G__46577 = cljs.core.first(seq46576);
  var seq46576__$1 = cljs.core.next(seq46576);
  var G__46578 = cljs.core.first(seq46576__$1);
  var seq46576__$2 = cljs.core.next(seq46576__$1);
  return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic(G__46577, G__46578, seq46576__$2);
};
cljs.core.unchecked_divide_int.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_inc = function cljs$core$unchecked_inc(x) {
  return x + 1;
};
cljs.core.unchecked_inc_int = function cljs$core$unchecked_inc_int(x) {
  return x + 1;
};
cljs.core.unchecked_multiply = function cljs$core$unchecked_multiply(var_args) {
  var args46585 = [];
  var len__10375__auto___46591 = arguments.length;
  var i__10376__auto___46592 = 0;
  while (true) {
    if (i__10376__auto___46592 < len__10375__auto___46591) {
      args46585.push(arguments[i__10376__auto___46592]);
      var G__46593 = i__10376__auto___46592 + 1;
      i__10376__auto___46592 = G__46593;
      continue;
    } else {
    }
    break;
  }
  var G__46590 = args46585.length;
  switch(G__46590) {
    case 0:
      return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46585.slice(2), 0, null);
      return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10398__auto__);
  }
};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0 = function() {
  return 1;
};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x * y;
};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply, x * y, more);
};
cljs.core.unchecked_multiply.cljs$lang$applyTo = function(seq46586) {
  var G__46587 = cljs.core.first(seq46586);
  var seq46586__$1 = cljs.core.next(seq46586);
  var G__46588 = cljs.core.first(seq46586__$1);
  var seq46586__$2 = cljs.core.next(seq46586__$1);
  return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic(G__46587, G__46588, seq46586__$2);
};
cljs.core.unchecked_multiply.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_multiply_int = function cljs$core$unchecked_multiply_int(var_args) {
  var args46595 = [];
  var len__10375__auto___46601 = arguments.length;
  var i__10376__auto___46602 = 0;
  while (true) {
    if (i__10376__auto___46602 < len__10375__auto___46601) {
      args46595.push(arguments[i__10376__auto___46602]);
      var G__46603 = i__10376__auto___46602 + 1;
      i__10376__auto___46602 = G__46603;
      continue;
    } else {
    }
    break;
  }
  var G__46600 = args46595.length;
  switch(G__46600) {
    case 0:
      return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46595.slice(2), 0, null);
      return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10398__auto__);
  }
};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0 = function() {
  return 1;
};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x * y;
};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply_int, x * y, more);
};
cljs.core.unchecked_multiply_int.cljs$lang$applyTo = function(seq46596) {
  var G__46597 = cljs.core.first(seq46596);
  var seq46596__$1 = cljs.core.next(seq46596);
  var G__46598 = cljs.core.first(seq46596__$1);
  var seq46596__$2 = cljs.core.next(seq46596__$1);
  return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic(G__46597, G__46598, seq46596__$2);
};
cljs.core.unchecked_multiply_int.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_negate = function cljs$core$unchecked_negate(x) {
  return -x;
};
cljs.core.unchecked_negate_int = function cljs$core$unchecked_negate_int(x) {
  return -x;
};
cljs.core.unchecked_remainder_int = function cljs$core$unchecked_remainder_int(x, n) {
  return cljs.core.mod.cljs$core$IFn$_invoke$arity$2 ? cljs.core.mod.cljs$core$IFn$_invoke$arity$2(x, n) : cljs.core.mod.call(null, x, n);
};
cljs.core.unchecked_subtract = function cljs$core$unchecked_subtract(var_args) {
  var args46605 = [];
  var len__10375__auto___46611 = arguments.length;
  var i__10376__auto___46612 = 0;
  while (true) {
    if (i__10376__auto___46612 < len__10375__auto___46611) {
      args46605.push(arguments[i__10376__auto___46612]);
      var G__46613 = i__10376__auto___46612 + 1;
      i__10376__auto___46612 = G__46613;
      continue;
    } else {
    }
    break;
  }
  var G__46610 = args46605.length;
  switch(G__46610) {
    case 1:
      return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46605.slice(2), 0, null);
      return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10398__auto__);
  }
};
cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return -x;
};
cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x - y;
};
cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract, x - y, more);
};
cljs.core.unchecked_subtract.cljs$lang$applyTo = function(seq46606) {
  var G__46607 = cljs.core.first(seq46606);
  var seq46606__$1 = cljs.core.next(seq46606);
  var G__46608 = cljs.core.first(seq46606__$1);
  var seq46606__$2 = cljs.core.next(seq46606__$1);
  return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic(G__46607, G__46608, seq46606__$2);
};
cljs.core.unchecked_subtract.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_subtract_int = function cljs$core$unchecked_subtract_int(var_args) {
  var args46615 = [];
  var len__10375__auto___46621 = arguments.length;
  var i__10376__auto___46622 = 0;
  while (true) {
    if (i__10376__auto___46622 < len__10375__auto___46621) {
      args46615.push(arguments[i__10376__auto___46622]);
      var G__46623 = i__10376__auto___46622 + 1;
      i__10376__auto___46622 = G__46623;
      continue;
    } else {
    }
    break;
  }
  var G__46620 = args46615.length;
  switch(G__46620) {
    case 1:
      return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46615.slice(2), 0, null);
      return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10398__auto__);
  }
};
cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return -x;
};
cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x - y;
};
cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract_int, x - y, more);
};
cljs.core.unchecked_subtract_int.cljs$lang$applyTo = function(seq46616) {
  var G__46617 = cljs.core.first(seq46616);
  var seq46616__$1 = cljs.core.next(seq46616);
  var G__46618 = cljs.core.first(seq46616__$1);
  var seq46616__$2 = cljs.core.next(seq46616__$1);
  return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic(G__46617, G__46618, seq46616__$2);
};
cljs.core.unchecked_subtract_int.cljs$lang$maxFixedArity = 2;
cljs.core.fix = function cljs$core$fix(q) {
  if (q >= 0) {
    return Math.floor(q);
  } else {
    return Math.ceil(q);
  }
};
cljs.core.int$ = function cljs$core$int(x) {
  return x | 0;
};
cljs.core.unchecked_int = function cljs$core$unchecked_int(x) {
  return cljs.core.fix(x);
};
cljs.core.long$ = function cljs$core$long(x) {
  return cljs.core.fix(x);
};
cljs.core.unchecked_long = function cljs$core$unchecked_long(x) {
  return cljs.core.fix(x);
};
cljs.core.booleans = function cljs$core$booleans(x) {
  return x;
};
cljs.core.bytes = function cljs$core$bytes(x) {
  return x;
};
cljs.core.chars = function cljs$core$chars(x) {
  return x;
};
cljs.core.shorts = function cljs$core$shorts(x) {
  return x;
};
cljs.core.ints = function cljs$core$ints(x) {
  return x;
};
cljs.core.floats = function cljs$core$floats(x) {
  return x;
};
cljs.core.doubles = function cljs$core$doubles(x) {
  return x;
};
cljs.core.longs = function cljs$core$longs(x) {
  return x;
};
cljs.core.js_mod = function cljs$core$js_mod(n, d) {
  return n % d;
};
cljs.core.mod = function cljs$core$mod(n, d) {
  return (n % d + d) % d;
};
cljs.core.quot = function cljs$core$quot(n, d) {
  var rem = n % d;
  return cljs.core.fix((n - rem) / d);
};
cljs.core.rem = function cljs$core$rem(n, d) {
  var q = cljs.core.quot(n, d);
  return n - d * q;
};
cljs.core.bit_xor = function cljs$core$bit_xor(var_args) {
  var args46625 = [];
  var len__10375__auto___46631 = arguments.length;
  var i__10376__auto___46632 = 0;
  while (true) {
    if (i__10376__auto___46632 < len__10375__auto___46631) {
      args46625.push(arguments[i__10376__auto___46632]);
      var G__46633 = i__10376__auto___46632 + 1;
      i__10376__auto___46632 = G__46633;
      continue;
    } else {
    }
    break;
  }
  var G__46630 = args46625.length;
  switch(G__46630) {
    case 2:
      return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46625.slice(2), 0, null);
      return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10398__auto__);
  }
};
cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x ^ y;
};
cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_xor, x ^ y, more);
};
cljs.core.bit_xor.cljs$lang$applyTo = function(seq46626) {
  var G__46627 = cljs.core.first(seq46626);
  var seq46626__$1 = cljs.core.next(seq46626);
  var G__46628 = cljs.core.first(seq46626__$1);
  var seq46626__$2 = cljs.core.next(seq46626__$1);
  return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic(G__46627, G__46628, seq46626__$2);
};
cljs.core.bit_xor.cljs$lang$maxFixedArity = 2;
cljs.core.bit_and = function cljs$core$bit_and(var_args) {
  var args46635 = [];
  var len__10375__auto___46641 = arguments.length;
  var i__10376__auto___46642 = 0;
  while (true) {
    if (i__10376__auto___46642 < len__10375__auto___46641) {
      args46635.push(arguments[i__10376__auto___46642]);
      var G__46643 = i__10376__auto___46642 + 1;
      i__10376__auto___46642 = G__46643;
      continue;
    } else {
    }
    break;
  }
  var G__46640 = args46635.length;
  switch(G__46640) {
    case 2:
      return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46635.slice(2), 0, null);
      return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10398__auto__);
  }
};
cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x & y;
};
cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and, x & y, more);
};
cljs.core.bit_and.cljs$lang$applyTo = function(seq46636) {
  var G__46637 = cljs.core.first(seq46636);
  var seq46636__$1 = cljs.core.next(seq46636);
  var G__46638 = cljs.core.first(seq46636__$1);
  var seq46636__$2 = cljs.core.next(seq46636__$1);
  return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic(G__46637, G__46638, seq46636__$2);
};
cljs.core.bit_and.cljs$lang$maxFixedArity = 2;
cljs.core.bit_or = function cljs$core$bit_or(var_args) {
  var args46645 = [];
  var len__10375__auto___46651 = arguments.length;
  var i__10376__auto___46652 = 0;
  while (true) {
    if (i__10376__auto___46652 < len__10375__auto___46651) {
      args46645.push(arguments[i__10376__auto___46652]);
      var G__46653 = i__10376__auto___46652 + 1;
      i__10376__auto___46652 = G__46653;
      continue;
    } else {
    }
    break;
  }
  var G__46650 = args46645.length;
  switch(G__46650) {
    case 2:
      return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46645.slice(2), 0, null);
      return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10398__auto__);
  }
};
cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x | y;
};
cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_or, x | y, more);
};
cljs.core.bit_or.cljs$lang$applyTo = function(seq46646) {
  var G__46647 = cljs.core.first(seq46646);
  var seq46646__$1 = cljs.core.next(seq46646);
  var G__46648 = cljs.core.first(seq46646__$1);
  var seq46646__$2 = cljs.core.next(seq46646__$1);
  return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic(G__46647, G__46648, seq46646__$2);
};
cljs.core.bit_or.cljs$lang$maxFixedArity = 2;
cljs.core.bit_and_not = function cljs$core$bit_and_not(var_args) {
  var args46655 = [];
  var len__10375__auto___46661 = arguments.length;
  var i__10376__auto___46662 = 0;
  while (true) {
    if (i__10376__auto___46662 < len__10375__auto___46661) {
      args46655.push(arguments[i__10376__auto___46662]);
      var G__46663 = i__10376__auto___46662 + 1;
      i__10376__auto___46662 = G__46663;
      continue;
    } else {
    }
    break;
  }
  var G__46660 = args46655.length;
  switch(G__46660) {
    case 2:
      return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46655.slice(2), 0, null);
      return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10398__auto__);
  }
};
cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x & ~y;
};
cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and_not, x & ~y, more);
};
cljs.core.bit_and_not.cljs$lang$applyTo = function(seq46656) {
  var G__46657 = cljs.core.first(seq46656);
  var seq46656__$1 = cljs.core.next(seq46656);
  var G__46658 = cljs.core.first(seq46656__$1);
  var seq46656__$2 = cljs.core.next(seq46656__$1);
  return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic(G__46657, G__46658, seq46656__$2);
};
cljs.core.bit_and_not.cljs$lang$maxFixedArity = 2;
cljs.core.bit_clear = function cljs$core$bit_clear(x, n) {
  return x & ~(1 << n);
};
cljs.core.bit_flip = function cljs$core$bit_flip(x, n) {
  return x ^ 1 << n;
};
cljs.core.bit_not = function cljs$core$bit_not(x) {
  return ~x;
};
cljs.core.bit_set = function cljs$core$bit_set(x, n) {
  return x | 1 << n;
};
cljs.core.bit_test = function cljs$core$bit_test(x, n) {
  return (x & 1 << n) != 0;
};
cljs.core.bit_shift_left = function cljs$core$bit_shift_left(x, n) {
  return x << n;
};
cljs.core.bit_shift_right = function cljs$core$bit_shift_right(x, n) {
  return x >> n;
};
cljs.core.bit_shift_right_zero_fill = function cljs$core$bit_shift_right_zero_fill(x, n) {
  return x >>> n;
};
cljs.core.unsigned_bit_shift_right = function cljs$core$unsigned_bit_shift_right(x, n) {
  return x >>> n;
};
cljs.core.bit_count = function cljs$core$bit_count(v) {
  var v__$1 = v - (v >> 1 & 1431655765);
  var v__$2 = (v__$1 & 858993459) + (v__$1 >> 2 & 858993459);
  return (v__$2 + (v__$2 >> 4) & 252645135) * 16843009 >> 24;
};
cljs.core._EQ__EQ_ = function cljs$core$_EQ__EQ_(var_args) {
  var args46665 = [];
  var len__10375__auto___46671 = arguments.length;
  var i__10376__auto___46672 = 0;
  while (true) {
    if (i__10376__auto___46672 < len__10375__auto___46671) {
      args46665.push(arguments[i__10376__auto___46672]);
      var G__46673 = i__10376__auto___46672 + 1;
      i__10376__auto___46672 = G__46673;
      continue;
    } else {
    }
    break;
  }
  var G__46670 = args46665.length;
  switch(G__46670) {
    case 1:
      return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46665.slice(2), 0, null);
      return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10398__auto__);
  }
};
cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return cljs.core._equiv(x, y);
};
cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x === y) {
      if (cljs.core.next(more)) {
        var G__46675 = y;
        var G__46676 = cljs.core.first(more);
        var G__46677 = cljs.core.next(more);
        x = G__46675;
        y = G__46676;
        more = G__46677;
        continue;
      } else {
        return y === cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._EQ__EQ_.cljs$lang$applyTo = function(seq46666) {
  var G__46667 = cljs.core.first(seq46666);
  var seq46666__$1 = cljs.core.next(seq46666);
  var G__46668 = cljs.core.first(seq46666__$1);
  var seq46666__$2 = cljs.core.next(seq46666__$1);
  return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__46667, G__46668, seq46666__$2);
};
cljs.core._EQ__EQ_.cljs$lang$maxFixedArity = 2;
cljs.core.pos_QMARK_ = function cljs$core$pos_QMARK_(x) {
  return x > 0;
};
cljs.core.zero_QMARK_ = function cljs$core$zero_QMARK_(x) {
  return x === 0;
};
cljs.core.neg_QMARK_ = function cljs$core$neg_QMARK_(x) {
  return x < 0;
};
cljs.core.nthnext = function cljs$core$nthnext(coll, n) {
  var n__$1 = n;
  var xs = cljs.core.seq(coll);
  while (true) {
    if (xs && n__$1 > 0) {
      var G__46678 = n__$1 - 1;
      var G__46679 = cljs.core.next(xs);
      n__$1 = G__46678;
      xs = G__46679;
      continue;
    } else {
      return xs;
    }
    break;
  }
};
cljs.core.str = function cljs$core$str(var_args) {
  var args46680 = [];
  var len__10375__auto___46685 = arguments.length;
  var i__10376__auto___46686 = 0;
  while (true) {
    if (i__10376__auto___46686 < len__10375__auto___46685) {
      args46680.push(arguments[i__10376__auto___46686]);
      var G__46687 = i__10376__auto___46686 + 1;
      i__10376__auto___46686 = G__46687;
      continue;
    } else {
    }
    break;
  }
  var G__46684 = args46680.length;
  switch(G__46684) {
    case 0:
      return cljs.core.str.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46680.slice(1), 0, null);
      return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__10398__auto__);
  }
};
cljs.core.str.cljs$core$IFn$_invoke$arity$0 = function() {
  return "";
};
cljs.core.str.cljs$core$IFn$_invoke$arity$1 = function(x) {
  if (x == null) {
    return "";
  } else {
    return [x].join("");
  }
};
cljs.core.str.cljs$core$IFn$_invoke$arity$variadic = function(x, ys) {
  var sb = new goog.string.StringBuffer([cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(""));
  var more = ys;
  while (true) {
    if (cljs.core.truth_(more)) {
      var G__46689 = sb.append([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(more))].join(""));
      var G__46690 = cljs.core.next(more);
      sb = G__46689;
      more = G__46690;
      continue;
    } else {
      return sb.toString();
    }
    break;
  }
};
cljs.core.str.cljs$lang$applyTo = function(seq46681) {
  var G__46682 = cljs.core.first(seq46681);
  var seq46681__$1 = cljs.core.next(seq46681);
  return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic(G__46682, seq46681__$1);
};
cljs.core.str.cljs$lang$maxFixedArity = 1;
cljs.core.subs = function cljs$core$subs(var_args) {
  var args46691 = [];
  var len__10375__auto___46694 = arguments.length;
  var i__10376__auto___46695 = 0;
  while (true) {
    if (i__10376__auto___46695 < len__10375__auto___46694) {
      args46691.push(arguments[i__10376__auto___46695]);
      var G__46696 = i__10376__auto___46695 + 1;
      i__10376__auto___46695 = G__46696;
      continue;
    } else {
    }
    break;
  }
  var G__46693 = args46691.length;
  switch(G__46693) {
    case 2:
      return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args46691.length)].join(""));
  }
};
cljs.core.subs.cljs$core$IFn$_invoke$arity$2 = function(s, start) {
  return s.substring(start);
};
cljs.core.subs.cljs$core$IFn$_invoke$arity$3 = function(s, start, end) {
  return s.substring(start, end);
};
cljs.core.subs.cljs$lang$maxFixedArity = 3;
cljs.core.equiv_sequential = function cljs$core$equiv_sequential(x, y) {
  return cljs.core.boolean$(cljs.core.sequential_QMARK_(y) ? cljs.core.counted_QMARK_(x) && cljs.core.counted_QMARK_(y) && !(cljs.core.count(x) === cljs.core.count(y)) ? false : function() {
    var xs = cljs.core.seq(x);
    var ys = cljs.core.seq(y);
    while (true) {
      if (xs == null) {
        return ys == null;
      } else {
        if (ys == null) {
          return false;
        } else {
          if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(xs), cljs.core.first(ys))) {
            var G__46698 = cljs.core.next(xs);
            var G__46699 = cljs.core.next(ys);
            xs = G__46698;
            ys = G__46699;
            continue;
          } else {
            return false;
          }
        }
      }
      break;
    }
  }() : null);
};
cljs.core.hash_coll = function cljs$core$hash_coll(coll) {
  if (cljs.core.seq(coll)) {
    var res = cljs.core.hash(cljs.core.first(coll));
    var s = cljs.core.next(coll);
    while (true) {
      if (s == null) {
        return res;
      } else {
        var G__46700 = cljs.core.hash_combine(res, cljs.core.hash(cljs.core.first(s)));
        var G__46701 = cljs.core.next(s);
        res = G__46700;
        s = G__46701;
        continue;
      }
      break;
    }
  } else {
    return 0;
  }
};
cljs.core.hash_imap = function cljs$core$hash_imap(m) {
  var h = 0;
  var s = cljs.core.seq(m);
  while (true) {
    if (s) {
      var e = cljs.core.first(s);
      var G__46702 = (h + (cljs.core.hash(cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.key.call(null, e)) ^ cljs.core.hash(cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.val.call(null, e)))) % 4503599627370496;
      var G__46703 = cljs.core.next(s);
      h = G__46702;
      s = G__46703;
      continue;
    } else {
      return h;
    }
    break;
  }
};
cljs.core.hash_iset = function cljs$core$hash_iset(s) {
  var h = 0;
  var s__$1 = cljs.core.seq(s);
  while (true) {
    if (s__$1) {
      var e = cljs.core.first(s__$1);
      var G__46704 = (h + cljs.core.hash(e)) % 4503599627370496;
      var G__46705 = cljs.core.next(s__$1);
      h = G__46704;
      s__$1 = G__46705;
      continue;
    } else {
      return h;
    }
    break;
  }
};
cljs.core.extend_object_BANG_ = function cljs$core$extend_object_BANG_(obj, fn_map) {
  var seq__46716_46726 = cljs.core.seq(fn_map);
  var chunk__46717_46727 = null;
  var count__46718_46728 = 0;
  var i__46719_46729 = 0;
  while (true) {
    if (i__46719_46729 < count__46718_46728) {
      var vec__46720_46730 = chunk__46717_46727.cljs$core$IIndexed$_nth$arity$2(null, i__46719_46729);
      var key_name_46731 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46720_46730, 0, null);
      var f_46732 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46720_46730, 1, null);
      var str_name_46733 = cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(key_name_46731) : cljs.core.name.call(null, key_name_46731);
      obj[str_name_46733] = f_46732;
      var G__46734 = seq__46716_46726;
      var G__46735 = chunk__46717_46727;
      var G__46736 = count__46718_46728;
      var G__46737 = i__46719_46729 + 1;
      seq__46716_46726 = G__46734;
      chunk__46717_46727 = G__46735;
      count__46718_46728 = G__46736;
      i__46719_46729 = G__46737;
      continue;
    } else {
      var temp__6738__auto___46738 = cljs.core.seq(seq__46716_46726);
      if (temp__6738__auto___46738) {
        var seq__46716_46739__$1 = temp__6738__auto___46738;
        if (cljs.core.chunked_seq_QMARK_(seq__46716_46739__$1)) {
          var c__10065__auto___46740 = cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1(seq__46716_46739__$1) : cljs.core.chunk_first.call(null, seq__46716_46739__$1);
          var G__46741 = cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1(seq__46716_46739__$1) : cljs.core.chunk_rest.call(null, seq__46716_46739__$1);
          var G__46742 = c__10065__auto___46740;
          var G__46743 = cljs.core.count(c__10065__auto___46740);
          var G__46744 = 0;
          seq__46716_46726 = G__46741;
          chunk__46717_46727 = G__46742;
          count__46718_46728 = G__46743;
          i__46719_46729 = G__46744;
          continue;
        } else {
          var vec__46723_46745 = cljs.core.first(seq__46716_46739__$1);
          var key_name_46746 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46723_46745, 0, null);
          var f_46747 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46723_46745, 1, null);
          var str_name_46748 = cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(key_name_46746) : cljs.core.name.call(null, key_name_46746);
          obj[str_name_46748] = f_46747;
          var G__46749 = cljs.core.next(seq__46716_46739__$1);
          var G__46750 = null;
          var G__46751 = 0;
          var G__46752 = 0;
          seq__46716_46726 = G__46749;
          chunk__46717_46727 = G__46750;
          count__46718_46728 = G__46751;
          i__46719_46729 = G__46752;
          continue;
        }
      } else {
      }
    }
    break;
  }
  return obj;
};
cljs.core.List = function(meta, first, rest, count, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.count = count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 65937646;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.List.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.List.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.List.prototype.indexOf = function() {
  var G__46753 = null;
  var G__46753__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__46753__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__46753 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__46753__1.call(this, x);
      case 2:
        return G__46753__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__46753.cljs$core$IFn$_invoke$arity$1 = G__46753__1;
  G__46753.cljs$core$IFn$_invoke$arity$2 = G__46753__2;
  return G__46753;
}();
cljs.core.List.prototype.lastIndexOf = function() {
  var G__46754 = null;
  var G__46754__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, self__.count);
  };
  var G__46754__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__46754 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__46754__1.call(this, x);
      case 2:
        return G__46754__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__46754.cljs$core$IFn$_invoke$arity$1 = G__46754__1;
  G__46754.cljs$core$IFn$_invoke$arity$2 = G__46754__2;
  return G__46754;
}();
cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.List(self__.meta, self__.first, self__.rest, self__.count, self__.__hash);
};
cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.count === 1) {
    return null;
  } else {
    return self__.rest;
  }
};
cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.count;
};
cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.first;
};
cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1.cljs$core$ISeq$_rest$arity$1(null);
};
cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__9596__auto__ = self__.__hash;
  if (!(h__9596__auto__ == null)) {
    return h__9596__auto__;
  } else {
    var h__9596__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__9596__auto____$1;
    return h__9596__auto____$1;
  }
};
cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.first;
};
cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.count === 1) {
    return cljs.core.List.EMPTY;
  } else {
    return self__.rest;
  }
};
cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.List(meta__$1, self__.first, self__.rest, self__.count, self__.__hash);
};
cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.List(self__.meta, o, coll__$1, self__.count + 1, null);
};
cljs.core.List.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "first", "first", 996428481, null), new cljs.core.Symbol(null, "rest", "rest", 398835108, null), new cljs.core.Symbol(null, "count", "count", -514511684, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, 
  "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.List.cljs$lang$type = true;
cljs.core.List.cljs$lang$ctorStr = "cljs.core/List";
cljs.core.List.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/List");
};
cljs.core.__GT_List = function cljs$core$__GT_List(meta, first, rest, count, __hash) {
  return new cljs.core.List(meta, first, rest, count, __hash);
};
cljs.core.list_QMARK_ = function cljs$core$list_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 33554432 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IList$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IList, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IList, x);
  }
};
cljs.core.List.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__10266__auto__ = this;
  return cljs.core.es6_iterator(this__10266__auto__);
};
cljs.core.EmptyList = function(meta) {
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 65937614;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.EmptyList.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.EmptyList.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.EmptyList.prototype.indexOf = function() {
  var G__46757 = null;
  var G__46757__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__46757__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__46757 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__46757__1.call(this, x);
      case 2:
        return G__46757__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__46757.cljs$core$IFn$_invoke$arity$1 = G__46757__1;
  G__46757.cljs$core$IFn$_invoke$arity$2 = G__46757__2;
  return G__46757;
}();
cljs.core.EmptyList.prototype.lastIndexOf = function() {
  var G__46758 = null;
  var G__46758__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__46758__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__46758 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__46758__1.call(this, x);
      case 2:
        return G__46758__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__46758.cljs$core$IFn$_invoke$arity$1 = G__46758__1;
  G__46758.cljs$core$IFn$_invoke$arity$2 = G__46758__2;
  return G__46758;
}();
cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.EmptyList(self__.meta);
};
cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return null;
};
cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return 0;
};
cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return null;
};
cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  throw new Error("Can't pop empty list");
};
cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.empty_ordered_hash;
};
cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.list_QMARK_(other) || cljs.core.sequential_QMARK_(other)) {
    return cljs.core.seq(other) == null;
  } else {
    return false;
  }
};
cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return null;
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.List.EMPTY;
};
cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return null;
};
cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.EmptyList(meta__$1);
};
cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.List(self__.meta, o, null, 1, null);
};
cljs.core.EmptyList.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null)], null);
};
cljs.core.EmptyList.cljs$lang$type = true;
cljs.core.EmptyList.cljs$lang$ctorStr = "cljs.core/EmptyList";
cljs.core.EmptyList.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/EmptyList");
};
cljs.core.__GT_EmptyList = function cljs$core$__GT_EmptyList(meta) {
  return new cljs.core.EmptyList(meta);
};
cljs.core.List.EMPTY = new cljs.core.EmptyList(null);
cljs.core.EmptyList.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__10266__auto__ = this;
  return cljs.core.es6_iterator(this__10266__auto__);
};
cljs.core.reversible_QMARK_ = function cljs$core$reversible_QMARK_(coll) {
  if (!(coll == null)) {
    if (coll.cljs$lang$protocol_mask$partition0$ & 134217728 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReversible$) {
      return true;
    } else {
      if (!coll.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible, coll);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible, coll);
  }
};
cljs.core.rseq = function cljs$core$rseq(rev) {
  return cljs.core._rseq(rev);
};
cljs.core.reverse = function cljs$core$reverse(coll) {
  if (cljs.core.reversible_QMARK_(coll)) {
    return cljs.core.rseq(coll);
  } else {
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj, cljs.core.List.EMPTY, coll);
  }
};
cljs.core.list = function cljs$core$list(var_args) {
  var args__10382__auto__ = [];
  var len__10375__auto___46762 = arguments.length;
  var i__10376__auto___46763 = 0;
  while (true) {
    if (i__10376__auto___46763 < len__10375__auto___46762) {
      args__10382__auto__.push(arguments[i__10376__auto___46763]);
      var G__46764 = i__10376__auto___46763 + 1;
      i__10376__auto___46763 = G__46764;
      continue;
    } else {
    }
    break;
  }
  var argseq__10383__auto__ = 0 < args__10382__auto__.length ? new cljs.core.IndexedSeq(args__10382__auto__.slice(0), 0, null) : null;
  return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(argseq__10383__auto__);
};
cljs.core.list.cljs$core$IFn$_invoke$arity$variadic = function(xs) {
  var arr = xs instanceof cljs.core.IndexedSeq && xs.i === 0 ? xs.arr : function() {
    var arr = [];
    var xs__$1 = xs;
    while (true) {
      if (!(xs__$1 == null)) {
        arr.push(xs__$1.cljs$core$ISeq$_first$arity$1(null));
        var G__46765 = xs__$1.cljs$core$INext$_next$arity$1(null);
        xs__$1 = G__46765;
        continue;
      } else {
        return arr;
      }
      break;
    }
  }();
  var i = arr.length;
  var r = cljs.core.List.EMPTY;
  while (true) {
    if (i > 0) {
      var G__46766 = i - 1;
      var G__46767 = r.cljs$core$ICollection$_conj$arity$2(null, arr[i - 1]);
      i = G__46766;
      r = G__46767;
      continue;
    } else {
      return r;
    }
    break;
  }
};
cljs.core.list.cljs$lang$maxFixedArity = 0;
cljs.core.list.cljs$lang$applyTo = function(seq46761) {
  return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46761));
};
cljs.core.Cons = function(meta, first, rest, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 65929452;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.Cons.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.Cons.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Cons.prototype.indexOf = function() {
  var G__46768 = null;
  var G__46768__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__46768__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__46768 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__46768__1.call(this, x);
      case 2:
        return G__46768__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__46768.cljs$core$IFn$_invoke$arity$1 = G__46768__1;
  G__46768.cljs$core$IFn$_invoke$arity$2 = G__46768__2;
  return G__46768;
}();
cljs.core.Cons.prototype.lastIndexOf = function() {
  var G__46769 = null;
  var G__46769__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__46769__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__46769 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__46769__1.call(this, x);
      case 2:
        return G__46769__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__46769.cljs$core$IFn$_invoke$arity$1 = G__46769__1;
  G__46769.cljs$core$IFn$_invoke$arity$2 = G__46769__2;
  return G__46769;
}();
cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.Cons(self__.meta, self__.first, self__.rest, self__.__hash);
};
cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.rest == null) {
    return null;
  } else {
    return cljs.core.seq(self__.rest);
  }
};
cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__9596__auto__ = self__.__hash;
  if (!(h__9596__auto__ == null)) {
    return h__9596__auto__;
  } else {
    var h__9596__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__9596__auto____$1;
    return h__9596__auto____$1;
  }
};
cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.first;
};
cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.rest == null) {
    return cljs.core.List.EMPTY;
  } else {
    return self__.rest;
  }
};
cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.Cons(meta__$1, self__.first, self__.rest, self__.__hash);
};
cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.Cons(null, o, coll__$1, null);
};
cljs.core.Cons.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "first", "first", 996428481, null), new cljs.core.Symbol(null, "rest", "rest", 398835108, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.Cons.cljs$lang$type = true;
cljs.core.Cons.cljs$lang$ctorStr = "cljs.core/Cons";
cljs.core.Cons.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/Cons");
};
cljs.core.__GT_Cons = function cljs$core$__GT_Cons(meta, first, rest, __hash) {
  return new cljs.core.Cons(meta, first, rest, __hash);
};
cljs.core.Cons.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__10266__auto__ = this;
  return cljs.core.es6_iterator(this__10266__auto__);
};
cljs.core.cons = function cljs$core$cons(x, coll) {
  if (function() {
    var or__9154__auto__ = coll == null;
    if (or__9154__auto__) {
      return or__9154__auto__;
    } else {
      if (!(coll == null)) {
        if (coll.cljs$lang$protocol_mask$partition0$ & 64 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }
  }()) {
    return new cljs.core.Cons(null, x, coll, null);
  } else {
    return new cljs.core.Cons(null, x, cljs.core.seq(coll), null);
  }
};
cljs.core.hash_keyword = function cljs$core$hash_keyword(k) {
  return cljs.core.hash_symbol(k) + 2654435769 | 0;
};
cljs.core.compare_keywords = function cljs$core$compare_keywords(a, b) {
  if (a.fqn === b.fqn) {
    return 0;
  } else {
    if (cljs.core.truth_(function() {
      var and__9142__auto__ = cljs.core.not(a.ns);
      if (and__9142__auto__) {
        return b.ns;
      } else {
        return and__9142__auto__;
      }
    }())) {
      return -1;
    } else {
      if (cljs.core.truth_(a.ns)) {
        if (cljs.core.not(b.ns)) {
          return 1;
        } else {
          var nsc = function() {
            var G__46780 = a.ns;
            var G__46781 = b.ns;
            return goog.array.defaultCompare(G__46780, G__46781);
          }();
          if (0 === nsc) {
            var G__46782 = a.name;
            var G__46783 = b.name;
            return goog.array.defaultCompare(G__46782, G__46783);
          } else {
            return nsc;
          }
        }
      } else {
        var G__46784 = a.name;
        var G__46785 = b.name;
        return goog.array.defaultCompare(G__46784, G__46785);
      }
    }
  }
};
cljs.core.Keyword = function(ns, name, fqn, _hash) {
  this.ns = ns;
  this.name = name;
  this.fqn = fqn;
  this._hash = _hash;
  this.cljs$lang$protocol_mask$partition0$ = 2153775105;
  this.cljs$lang$protocol_mask$partition1$ = 4096;
};
cljs.core.Keyword.prototype.toString = function() {
  var self__ = this;
  var _ = this;
  return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(":"), cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.fqn)].join("");
};
cljs.core.Keyword.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(_, other) {
  var self__ = this;
  var ___$1 = this;
  if (other instanceof cljs.core.Keyword) {
    return self__.fqn === other.fqn;
  } else {
    return false;
  }
};
cljs.core.Keyword.prototype.call = function() {
  var G__46787 = null;
  var G__46787__2 = function(self__, coll) {
    var self__ = this;
    var self____$1 = this;
    var kw = self____$1;
    return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, kw);
  };
  var G__46787__3 = function(self__, coll, not_found) {
    var self__ = this;
    var self____$1 = this;
    var kw = self____$1;
    return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, kw, not_found);
  };
  G__46787 = function(self__, coll, not_found) {
    switch(arguments.length) {
      case 2:
        return G__46787__2.call(this, self__, coll);
      case 3:
        return G__46787__3.call(this, self__, coll, not_found);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__46787.cljs$core$IFn$_invoke$arity$2 = G__46787__2;
  G__46787.cljs$core$IFn$_invoke$arity$3 = G__46787__3;
  return G__46787;
}();
cljs.core.Keyword.prototype.apply = function(self__, args46786) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args46786)));
};
cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  var self__ = this;
  var kw = this;
  return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, kw);
};
cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2 = function(coll, not_found) {
  var self__ = this;
  var kw = this;
  return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, kw, not_found);
};
cljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  var h__9596__auto__ = self__._hash;
  if (!(h__9596__auto__ == null)) {
    return h__9596__auto__;
  } else {
    var h__9596__auto____$1 = cljs.core.hash_keyword(this$__$1);
    self__._hash = h__9596__auto____$1;
    return h__9596__auto____$1;
  }
};
cljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.name;
};
cljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.ns;
};
cljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = function(o, writer, _) {
  var self__ = this;
  var o__$1 = this;
  return cljs.core._write(writer, [cljs.core.str.cljs$core$IFn$_invoke$arity$1(":"), cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.fqn)].join(""));
};
cljs.core.Keyword.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "ns", "ns", 2082130287, null), new cljs.core.Symbol(null, "name", "name", -810760592, null), new cljs.core.Symbol(null, "fqn", "fqn", -1749334463, null), cljs.core.with_meta(new cljs.core.Symbol(null, "_hash", "_hash", -2130838312, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.Keyword.cljs$lang$type = true;
cljs.core.Keyword.cljs$lang$ctorStr = "cljs.core/Keyword";
cljs.core.Keyword.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/Keyword");
};
cljs.core.__GT_Keyword = function cljs$core$__GT_Keyword(ns, name, fqn, _hash) {
  return new cljs.core.Keyword(ns, name, fqn, _hash);
};
cljs.core.keyword_QMARK_ = function cljs$core$keyword_QMARK_(x) {
  return x instanceof cljs.core.Keyword;
};
cljs.core.keyword_identical_QMARK_ = function cljs$core$keyword_identical_QMARK_(x, y) {
  if (x === y) {
    return true;
  } else {
    if (x instanceof cljs.core.Keyword && y instanceof cljs.core.Keyword) {
      return x.fqn === y.fqn;
    } else {
      return false;
    }
  }
};
cljs.core.symbol_identical_QMARK_ = function cljs$core$symbol_identical_QMARK_(x, y) {
  if (x === y) {
    return true;
  } else {
    if (x instanceof cljs.core.Symbol && y instanceof cljs.core.Symbol) {
      return x.str === y.str;
    } else {
      return false;
    }
  }
};
cljs.core.namespace = function cljs$core$namespace(x) {
  if (!(x == null) ? x.cljs$lang$protocol_mask$partition1$ & 4096 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$INamed$ ? true : false : false) {
    return x.cljs$core$INamed$_namespace$arity$1(null);
  } else {
    throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Doesn't support namespace: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(""));
  }
};
cljs.core.ident_QMARK_ = function cljs$core$ident_QMARK_(x) {
  return x instanceof cljs.core.Keyword || x instanceof cljs.core.Symbol;
};
cljs.core.simple_ident_QMARK_ = function cljs$core$simple_ident_QMARK_(x) {
  return cljs.core.ident_QMARK_(x) && cljs.core.namespace(x) == null;
};
cljs.core.qualified_ident_QMARK_ = function cljs$core$qualified_ident_QMARK_(x) {
  var and__9142__auto__ = cljs.core.ident_QMARK_(x);
  if (and__9142__auto__) {
    var and__9142__auto____$1 = cljs.core.namespace(x);
    if (cljs.core.truth_(and__9142__auto____$1)) {
      return true;
    } else {
      return and__9142__auto____$1;
    }
  } else {
    return and__9142__auto__;
  }
};
cljs.core.simple_symbol_QMARK_ = function cljs$core$simple_symbol_QMARK_(x) {
  return x instanceof cljs.core.Symbol && cljs.core.namespace(x) == null;
};
cljs.core.qualified_symbol_QMARK_ = function cljs$core$qualified_symbol_QMARK_(x) {
  var and__9142__auto__ = x instanceof cljs.core.Symbol;
  if (and__9142__auto__) {
    var and__9142__auto____$1 = cljs.core.namespace(x);
    if (cljs.core.truth_(and__9142__auto____$1)) {
      return true;
    } else {
      return and__9142__auto____$1;
    }
  } else {
    return and__9142__auto__;
  }
};
cljs.core.simple_keyword_QMARK_ = function cljs$core$simple_keyword_QMARK_(x) {
  return x instanceof cljs.core.Keyword && cljs.core.namespace(x) == null;
};
cljs.core.qualified_keyword_QMARK_ = function cljs$core$qualified_keyword_QMARK_(x) {
  var and__9142__auto__ = x instanceof cljs.core.Keyword;
  if (and__9142__auto__) {
    var and__9142__auto____$1 = cljs.core.namespace(x);
    if (cljs.core.truth_(and__9142__auto____$1)) {
      return true;
    } else {
      return and__9142__auto____$1;
    }
  } else {
    return and__9142__auto__;
  }
};
cljs.core.keyword = function cljs$core$keyword(var_args) {
  var args46790 = [];
  var len__10375__auto___46793 = arguments.length;
  var i__10376__auto___46794 = 0;
  while (true) {
    if (i__10376__auto___46794 < len__10375__auto___46793) {
      args46790.push(arguments[i__10376__auto___46794]);
      var G__46795 = i__10376__auto___46794 + 1;
      i__10376__auto___46794 = G__46795;
      continue;
    } else {
    }
    break;
  }
  var G__46792 = args46790.length;
  switch(G__46792) {
    case 1:
      return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args46790.length)].join(""));
  }
};
cljs.core.keyword.cljs$core$IFn$_invoke$arity$1 = function(name) {
  if (name instanceof cljs.core.Keyword) {
    return name;
  } else {
    if (name instanceof cljs.core.Symbol) {
      return new cljs.core.Keyword(cljs.core.namespace(name), cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(name) : cljs.core.name.call(null, name), name.str, null);
    } else {
      if (typeof name === "string") {
        var parts = name.split("/");
        if (parts.length === 2) {
          return new cljs.core.Keyword(parts[0], parts[1], name, null);
        } else {
          return new cljs.core.Keyword(null, parts[0], name, null);
        }
      } else {
        return null;
      }
    }
  }
};
cljs.core.keyword.cljs$core$IFn$_invoke$arity$2 = function(ns, name) {
  var ns__$1 = ns instanceof cljs.core.Keyword ? cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(ns) : cljs.core.name.call(null, ns) : ns instanceof cljs.core.Symbol ? cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(ns) : cljs.core.name.call(null, ns) : ns;
  var name__$1 = name instanceof cljs.core.Keyword ? cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(name) : cljs.core.name.call(null, name) : name instanceof cljs.core.Symbol ? cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(name) : cljs.core.name.call(null, name) : name;
  return new cljs.core.Keyword(ns__$1, name__$1, [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.truth_(ns__$1) ? [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns__$1), cljs.core.str.cljs$core$IFn$_invoke$arity$1("/")].join("") : null), cljs.core.str.cljs$core$IFn$_invoke$arity$1(name__$1)].join(""), null);
};
cljs.core.keyword.cljs$lang$maxFixedArity = 2;
cljs.core.LazySeq = function(meta, fn, s, __hash) {
  this.meta = meta;
  this.fn = fn;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32374988;
  this.cljs$lang$protocol_mask$partition1$ = 1;
};
cljs.core.LazySeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.LazySeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.LazySeq.prototype.sval = function() {
  var self__ = this;
  var coll = this;
  if (self__.fn == null) {
    return self__.s;
  } else {
    self__.s = self__.fn.cljs$core$IFn$_invoke$arity$0 ? self__.fn.cljs$core$IFn$_invoke$arity$0() : self__.fn.call(null);
    self__.fn = null;
    return self__.s;
  }
};
cljs.core.LazySeq.prototype.indexOf = function() {
  var G__46797 = null;
  var G__46797__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__46797__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__46797 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__46797__1.call(this, x);
      case 2:
        return G__46797__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__46797.cljs$core$IFn$_invoke$arity$1 = G__46797__1;
  G__46797.cljs$core$IFn$_invoke$arity$2 = G__46797__2;
  return G__46797;
}();
cljs.core.LazySeq.prototype.lastIndexOf = function() {
  var G__46798 = null;
  var G__46798__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__46798__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__46798 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__46798__1.call(this, x);
      case 2:
        return G__46798__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__46798.cljs$core$IFn$_invoke$arity$1 = G__46798__1;
  G__46798.cljs$core$IFn$_invoke$arity$2 = G__46798__2;
  return G__46798;
}();
cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  coll__$1.cljs$core$ISeqable$_seq$arity$1(null);
  if (self__.s == null) {
    return null;
  } else {
    return cljs.core.next(self__.s);
  }
};
cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__9596__auto__ = self__.__hash;
  if (!(h__9596__auto__ == null)) {
    return h__9596__auto__;
  } else {
    var h__9596__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__9596__auto____$1;
    return h__9596__auto____$1;
  }
};
cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.LazySeq.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.not(self__.fn);
};
cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  coll__$1.cljs$core$ISeqable$_seq$arity$1(null);
  if (self__.s == null) {
    return null;
  } else {
    return cljs.core.first(self__.s);
  }
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  coll__$1.cljs$core$ISeqable$_seq$arity$1(null);
  if (!(self__.s == null)) {
    return cljs.core.rest(self__.s);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  coll__$1.sval();
  if (self__.s == null) {
    return null;
  } else {
    var ls = self__.s;
    while (true) {
      if (ls instanceof cljs.core.LazySeq) {
        var G__46799 = ls.sval();
        ls = G__46799;
        continue;
      } else {
        self__.s = ls;
        return cljs.core.seq(self__.s);
      }
      break;
    }
  }
};
cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.LazySeq(meta__$1, self__.fn, self__.s, self__.__hash);
};
cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.LazySeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), cljs.core.with_meta(new cljs.core.Symbol(null, "fn", "fn", 465265323, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "s", "s", -948495851, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", 
  "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.LazySeq.cljs$lang$type = true;
cljs.core.LazySeq.cljs$lang$ctorStr = "cljs.core/LazySeq";
cljs.core.LazySeq.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/LazySeq");
};
cljs.core.__GT_LazySeq = function cljs$core$__GT_LazySeq(meta, fn, s, __hash) {
  return new cljs.core.LazySeq(meta, fn, s, __hash);
};
cljs.core.LazySeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__10266__auto__ = this;
  return cljs.core.es6_iterator(this__10266__auto__);
};
cljs.core.ChunkBuffer = function(buf, end) {
  this.buf = buf;
  this.end = end;
  this.cljs$lang$protocol_mask$partition0$ = 2;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.ChunkBuffer.prototype.add = function(o) {
  var self__ = this;
  var _ = this;
  self__.buf[self__.end] = o;
  return self__.end = self__.end + 1;
};
cljs.core.ChunkBuffer.prototype.chunk = function(o) {
  var self__ = this;
  var _ = this;
  var ret = new cljs.core.ArrayChunk(self__.buf, 0, self__.end);
  self__.buf = null;
  return ret;
};
cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.end;
};
cljs.core.ChunkBuffer.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "buf", "buf", 1426618187, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "end", "end", 1372345569, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ChunkBuffer.cljs$lang$type = true;
cljs.core.ChunkBuffer.cljs$lang$ctorStr = "cljs.core/ChunkBuffer";
cljs.core.ChunkBuffer.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/ChunkBuffer");
};
cljs.core.__GT_ChunkBuffer = function cljs$core$__GT_ChunkBuffer(buf, end) {
  return new cljs.core.ChunkBuffer(buf, end);
};
cljs.core.chunk_buffer = function cljs$core$chunk_buffer(capacity) {
  return new cljs.core.ChunkBuffer(new Array(capacity), 0);
};
cljs.core.ArrayChunk = function(arr, off, end) {
  this.arr = arr;
  this.off = off;
  this.end = end;
  this.cljs$lang$protocol_mask$partition0$ = 524306;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.end - self__.off;
};
cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, i) {
  var self__ = this;
  var coll__$1 = this;
  return self__.arr[self__.off + i];
};
cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, i, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (i >= 0 && i < self__.end - self__.off) {
    return self__.arr[self__.off + i];
  } else {
    return not_found;
  }
};
cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.off === self__.end) {
    throw new Error("-drop-first of empty chunk");
  } else {
    return new cljs.core.ArrayChunk(self__.arr, self__.off + 1, self__.end);
  }
};
cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr, f, self__.arr[self__.off], self__.off + 1);
};
cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr, f, start, self__.off);
};
cljs.core.ArrayChunk.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "off", "off", -2047994980, null), new cljs.core.Symbol(null, "end", "end", 1372345569, null)], null);
};
cljs.core.ArrayChunk.cljs$lang$type = true;
cljs.core.ArrayChunk.cljs$lang$ctorStr = "cljs.core/ArrayChunk";
cljs.core.ArrayChunk.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/ArrayChunk");
};
cljs.core.__GT_ArrayChunk = function cljs$core$__GT_ArrayChunk(arr, off, end) {
  return new cljs.core.ArrayChunk(arr, off, end);
};
cljs.core.array_chunk = function cljs$core$array_chunk(var_args) {
  var args46800 = [];
  var len__10375__auto___46803 = arguments.length;
  var i__10376__auto___46804 = 0;
  while (true) {
    if (i__10376__auto___46804 < len__10375__auto___46803) {
      args46800.push(arguments[i__10376__auto___46804]);
      var G__46805 = i__10376__auto___46804 + 1;
      i__10376__auto___46804 = G__46805;
      continue;
    } else {
    }
    break;
  }
  var G__46802 = args46800.length;
  switch(G__46802) {
    case 1:
      return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args46800.length)].join(""));
  }
};
cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1 = function(arr) {
  return new cljs.core.ArrayChunk(arr, 0, arr.length);
};
cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2 = function(arr, off) {
  return new cljs.core.ArrayChunk(arr, off, arr.length);
};
cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3 = function(arr, off, end) {
  return new cljs.core.ArrayChunk(arr, off, end);
};
cljs.core.array_chunk.cljs$lang$maxFixedArity = 3;
cljs.core.ChunkedCons = function(chunk, more, meta, __hash) {
  this.chunk = chunk;
  this.more = more;
  this.meta = meta;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 31850732;
  this.cljs$lang$protocol_mask$partition1$ = 1536;
};
cljs.core.ChunkedCons.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ChunkedCons.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ChunkedCons.prototype.indexOf = function() {
  var G__46807 = null;
  var G__46807__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__46807__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__46807 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__46807__1.call(this, x);
      case 2:
        return G__46807__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__46807.cljs$core$IFn$_invoke$arity$1 = G__46807__1;
  G__46807.cljs$core$IFn$_invoke$arity$2 = G__46807__2;
  return G__46807;
}();
cljs.core.ChunkedCons.prototype.lastIndexOf = function() {
  var G__46808 = null;
  var G__46808__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__46808__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__46808 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__46808__1.call(this, x);
      case 2:
        return G__46808__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__46808.cljs$core$IFn$_invoke$arity$1 = G__46808__1;
  G__46808.cljs$core$IFn$_invoke$arity$2 = G__46808__2;
  return G__46808;
}();
cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core._count(self__.chunk) > 1) {
    return new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk), self__.more, self__.meta, null);
  } else {
    var more__$1 = cljs.core._seq(self__.more);
    if (more__$1 == null) {
      return null;
    } else {
      return more__$1;
    }
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__9596__auto__ = self__.__hash;
  if (!(h__9596__auto__ == null)) {
    return h__9596__auto__;
  } else {
    var h__9596__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__9596__auto____$1;
    return h__9596__auto____$1;
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.chunk, 0);
};
cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core._count(self__.chunk) > 1) {
    return new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk), self__.more, self__.meta, null);
  } else {
    if (self__.more == null) {
      return cljs.core.List.EMPTY;
    } else {
      return self__.more;
    }
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.chunk;
};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.more == null) {
    return cljs.core.List.EMPTY;
  } else {
    return self__.more;
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, m) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.ChunkedCons(self__.chunk, self__.more, m, self__.__hash);
};
cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = function(this$, o) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.cons(o, this$__$1);
};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.more == null) {
    return null;
  } else {
    return self__.more;
  }
};
cljs.core.ChunkedCons.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "chunk", "chunk", 449371907, null), new cljs.core.Symbol(null, "more", "more", -418290273, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ChunkedCons.cljs$lang$type = true;
cljs.core.ChunkedCons.cljs$lang$ctorStr = "cljs.core/ChunkedCons";
cljs.core.ChunkedCons.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/ChunkedCons");
};
cljs.core.__GT_ChunkedCons = function cljs$core$__GT_ChunkedCons(chunk, more, meta, __hash) {
  return new cljs.core.ChunkedCons(chunk, more, meta, __hash);
};
cljs.core.ChunkedCons.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__10266__auto__ = this;
  return cljs.core.es6_iterator(this__10266__auto__);
};
cljs.core.chunk_cons = function cljs$core$chunk_cons(chunk, rest) {
  if (cljs.core._count(chunk) === 0) {
    return rest;
  } else {
    return new cljs.core.ChunkedCons(chunk, rest, null, null);
  }
};
cljs.core.chunk_append = function cljs$core$chunk_append(b, x) {
  return b.add(x);
};
cljs.core.chunk = function cljs$core$chunk(b) {
  return b.chunk();
};
cljs.core.chunk_first = function cljs$core$chunk_first(s) {
  return cljs.core._chunked_first(s);
};
cljs.core.chunk_rest = function cljs$core$chunk_rest(s) {
  return cljs.core._chunked_rest(s);
};
cljs.core.chunk_next = function cljs$core$chunk_next(s) {
  if (!(s == null) ? s.cljs$lang$protocol_mask$partition1$ & 1024 || cljs.core.PROTOCOL_SENTINEL === s.cljs$core$IChunkedNext$ ? true : false : false) {
    return cljs.core._chunked_next(s);
  } else {
    return cljs.core.seq(cljs.core._chunked_rest(s));
  }
};
cljs.core.to_array = function cljs$core$to_array(s) {
  var ary = [];
  var s__$1 = s;
  while (true) {
    if (cljs.core.seq(s__$1)) {
      ary.push(cljs.core.first(s__$1));
      var G__46811 = cljs.core.next(s__$1);
      s__$1 = G__46811;
      continue;
    } else {
      return ary;
    }
    break;
  }
};
cljs.core.to_array_2d = function cljs$core$to_array_2d(coll) {
  var ret = new Array(cljs.core.count(coll));
  var i_46812 = 0;
  var xs_46813 = cljs.core.seq(coll);
  while (true) {
    if (xs_46813) {
      ret[i_46812] = cljs.core.to_array(cljs.core.first(xs_46813));
      var G__46814 = i_46812 + 1;
      var G__46815 = cljs.core.next(xs_46813);
      i_46812 = G__46814;
      xs_46813 = G__46815;
      continue;
    } else {
    }
    break;
  }
  return ret;
};
cljs.core.int_array = function cljs$core$int_array(var_args) {
  var args46816 = [];
  var len__10375__auto___46819 = arguments.length;
  var i__10376__auto___46820 = 0;
  while (true) {
    if (i__10376__auto___46820 < len__10375__auto___46819) {
      args46816.push(arguments[i__10376__auto___46820]);
      var G__46821 = i__10376__auto___46820 + 1;
      i__10376__auto___46820 = G__46821;
      continue;
    } else {
    }
    break;
  }
  var G__46818 = args46816.length;
  switch(G__46818) {
    case 1:
      return cljs.core.int_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args46816.length)].join(""));
  }
};
cljs.core.int_array.cljs$core$IFn$_invoke$arity$1 = function(size_or_seq) {
  if (typeof size_or_seq === "number") {
    return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(size_or_seq, null);
  } else {
    return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
  }
};
cljs.core.int_array.cljs$core$IFn$_invoke$arity$2 = function(size, init_val_or_seq) {
  var a = new Array(size);
  if (cljs.core.seq_QMARK_(init_val_or_seq)) {
    var s = cljs.core.seq(init_val_or_seq);
    var i = 0;
    var s__$1 = s;
    while (true) {
      if (s__$1 && i < size) {
        a[i] = cljs.core.first(s__$1);
        var G__46823 = i + 1;
        var G__46824 = cljs.core.next(s__$1);
        i = G__46823;
        s__$1 = G__46824;
        continue;
      } else {
        return a;
      }
      break;
    }
  } else {
    var n__10175__auto___46825 = size;
    var i_46826 = 0;
    while (true) {
      if (i_46826 < n__10175__auto___46825) {
        a[i_46826] = init_val_or_seq;
        var G__46827 = i_46826 + 1;
        i_46826 = G__46827;
        continue;
      } else {
      }
      break;
    }
    return a;
  }
};
cljs.core.int_array.cljs$lang$maxFixedArity = 2;
cljs.core.long_array = function cljs$core$long_array(var_args) {
  var args46828 = [];
  var len__10375__auto___46831 = arguments.length;
  var i__10376__auto___46832 = 0;
  while (true) {
    if (i__10376__auto___46832 < len__10375__auto___46831) {
      args46828.push(arguments[i__10376__auto___46832]);
      var G__46833 = i__10376__auto___46832 + 1;
      i__10376__auto___46832 = G__46833;
      continue;
    } else {
    }
    break;
  }
  var G__46830 = args46828.length;
  switch(G__46830) {
    case 1:
      return cljs.core.long_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args46828.length)].join(""));
  }
};
cljs.core.long_array.cljs$core$IFn$_invoke$arity$1 = function(size_or_seq) {
  if (typeof size_or_seq === "number") {
    return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(size_or_seq, null);
  } else {
    return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
  }
};
cljs.core.long_array.cljs$core$IFn$_invoke$arity$2 = function(size, init_val_or_seq) {
  var a = new Array(size);
  if (cljs.core.seq_QMARK_(init_val_or_seq)) {
    var s = cljs.core.seq(init_val_or_seq);
    var i = 0;
    var s__$1 = s;
    while (true) {
      if (s__$1 && i < size) {
        a[i] = cljs.core.first(s__$1);
        var G__46835 = i + 1;
        var G__46836 = cljs.core.next(s__$1);
        i = G__46835;
        s__$1 = G__46836;
        continue;
      } else {
        return a;
      }
      break;
    }
  } else {
    var n__10175__auto___46837 = size;
    var i_46838 = 0;
    while (true) {
      if (i_46838 < n__10175__auto___46837) {
        a[i_46838] = init_val_or_seq;
        var G__46839 = i_46838 + 1;
        i_46838 = G__46839;
        continue;
      } else {
      }
      break;
    }
    return a;
  }
};
cljs.core.long_array.cljs$lang$maxFixedArity = 2;
cljs.core.double_array = function cljs$core$double_array(var_args) {
  var args46840 = [];
  var len__10375__auto___46843 = arguments.length;
  var i__10376__auto___46844 = 0;
  while (true) {
    if (i__10376__auto___46844 < len__10375__auto___46843) {
      args46840.push(arguments[i__10376__auto___46844]);
      var G__46845 = i__10376__auto___46844 + 1;
      i__10376__auto___46844 = G__46845;
      continue;
    } else {
    }
    break;
  }
  var G__46842 = args46840.length;
  switch(G__46842) {
    case 1:
      return cljs.core.double_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args46840.length)].join(""));
  }
};
cljs.core.double_array.cljs$core$IFn$_invoke$arity$1 = function(size_or_seq) {
  if (typeof size_or_seq === "number") {
    return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(size_or_seq, null);
  } else {
    return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
  }
};
cljs.core.double_array.cljs$core$IFn$_invoke$arity$2 = function(size, init_val_or_seq) {
  var a = new Array(size);
  if (cljs.core.seq_QMARK_(init_val_or_seq)) {
    var s = cljs.core.seq(init_val_or_seq);
    var i = 0;
    var s__$1 = s;
    while (true) {
      if (s__$1 && i < size) {
        a[i] = cljs.core.first(s__$1);
        var G__46847 = i + 1;
        var G__46848 = cljs.core.next(s__$1);
        i = G__46847;
        s__$1 = G__46848;
        continue;
      } else {
        return a;
      }
      break;
    }
  } else {
    var n__10175__auto___46849 = size;
    var i_46850 = 0;
    while (true) {
      if (i_46850 < n__10175__auto___46849) {
        a[i_46850] = init_val_or_seq;
        var G__46851 = i_46850 + 1;
        i_46850 = G__46851;
        continue;
      } else {
      }
      break;
    }
    return a;
  }
};
cljs.core.double_array.cljs$lang$maxFixedArity = 2;
cljs.core.object_array = function cljs$core$object_array(var_args) {
  var args46852 = [];
  var len__10375__auto___46855 = arguments.length;
  var i__10376__auto___46856 = 0;
  while (true) {
    if (i__10376__auto___46856 < len__10375__auto___46855) {
      args46852.push(arguments[i__10376__auto___46856]);
      var G__46857 = i__10376__auto___46856 + 1;
      i__10376__auto___46856 = G__46857;
      continue;
    } else {
    }
    break;
  }
  var G__46854 = args46852.length;
  switch(G__46854) {
    case 1:
      return cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args46852.length)].join(""));
  }
};
cljs.core.object_array.cljs$core$IFn$_invoke$arity$1 = function(size_or_seq) {
  if (typeof size_or_seq === "number") {
    return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(size_or_seq, null);
  } else {
    return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
  }
};
cljs.core.object_array.cljs$core$IFn$_invoke$arity$2 = function(size, init_val_or_seq) {
  var a = new Array(size);
  if (cljs.core.seq_QMARK_(init_val_or_seq)) {
    var s = cljs.core.seq(init_val_or_seq);
    var i = 0;
    var s__$1 = s;
    while (true) {
      if (s__$1 && i < size) {
        a[i] = cljs.core.first(s__$1);
        var G__46859 = i + 1;
        var G__46860 = cljs.core.next(s__$1);
        i = G__46859;
        s__$1 = G__46860;
        continue;
      } else {
        return a;
      }
      break;
    }
  } else {
    var n__10175__auto___46861 = size;
    var i_46862 = 0;
    while (true) {
      if (i_46862 < n__10175__auto___46861) {
        a[i_46862] = init_val_or_seq;
        var G__46863 = i_46862 + 1;
        i_46862 = G__46863;
        continue;
      } else {
      }
      break;
    }
    return a;
  }
};
cljs.core.object_array.cljs$lang$maxFixedArity = 2;
cljs.core.bounded_count = function cljs$core$bounded_count(n, coll) {
  if (cljs.core.counted_QMARK_(coll)) {
    return cljs.core.count(coll);
  } else {
    var i = 0;
    var s = cljs.core.seq(coll);
    while (true) {
      if (!(s == null) && i < n) {
        var G__46864 = i + 1;
        var G__46865 = cljs.core.next(s);
        i = G__46864;
        s = G__46865;
        continue;
      } else {
        return i;
      }
      break;
    }
  }
};
cljs.core.spread = function cljs$core$spread(arglist) {
  if (arglist == null) {
    return null;
  } else {
    if (cljs.core.next(arglist) == null) {
      return cljs.core.seq(cljs.core.first(arglist));
    } else {
      return cljs.core.cons(cljs.core.first(arglist), function() {
        var G__46867 = cljs.core.next(arglist);
        return cljs.core.spread.cljs$core$IFn$_invoke$arity$1 ? cljs.core.spread.cljs$core$IFn$_invoke$arity$1(G__46867) : cljs.core.spread.call(null, G__46867);
      }());
    }
  }
};
cljs.core.concat = function cljs$core$concat(var_args) {
  var args46868 = [];
  var len__10375__auto___46880 = arguments.length;
  var i__10376__auto___46881 = 0;
  while (true) {
    if (i__10376__auto___46881 < len__10375__auto___46880) {
      args46868.push(arguments[i__10376__auto___46881]);
      var G__46882 = i__10376__auto___46881 + 1;
      i__10376__auto___46881 = G__46882;
      continue;
    } else {
    }
    break;
  }
  var G__46873 = args46868.length;
  switch(G__46873) {
    case 0:
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46868.slice(2), 0, null);
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10398__auto__);
  }
};
cljs.core.concat.cljs$core$IFn$_invoke$arity$0 = function() {
  return new cljs.core.LazySeq(null, function() {
    return null;
  }, null, null);
};
cljs.core.concat.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return new cljs.core.LazySeq(null, function() {
    return x;
  }, null, null);
};
cljs.core.concat.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return new cljs.core.LazySeq(null, function() {
    var s = cljs.core.seq(x);
    if (s) {
      if (cljs.core.chunked_seq_QMARK_(s)) {
        return cljs.core.chunk_cons(cljs.core.chunk_first(s), cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.chunk_rest(s), y));
      } else {
        return cljs.core.cons(cljs.core.first(s), cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s), y));
      }
    } else {
      return y;
    }
  }, null, null);
};
cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic = function(x, y, zs) {
  var cat = function cljs$core$cat(xys, zs__$1) {
    return new cljs.core.LazySeq(null, function() {
      var xys__$1 = cljs.core.seq(xys);
      if (xys__$1) {
        if (cljs.core.chunked_seq_QMARK_(xys__$1)) {
          return cljs.core.chunk_cons(cljs.core.chunk_first(xys__$1), cljs$core$cat(cljs.core.chunk_rest(xys__$1), zs__$1));
        } else {
          return cljs.core.cons(cljs.core.first(xys__$1), cljs$core$cat(cljs.core.rest(xys__$1), zs__$1));
        }
      } else {
        if (cljs.core.truth_(zs__$1)) {
          return cljs$core$cat(cljs.core.first(zs__$1), cljs.core.next(zs__$1));
        } else {
          return null;
        }
      }
    }, null, null);
  };
  return cat(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(x, y), zs);
};
cljs.core.concat.cljs$lang$applyTo = function(seq46869) {
  var G__46870 = cljs.core.first(seq46869);
  var seq46869__$1 = cljs.core.next(seq46869);
  var G__46871 = cljs.core.first(seq46869__$1);
  var seq46869__$2 = cljs.core.next(seq46869__$1);
  return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(G__46870, G__46871, seq46869__$2);
};
cljs.core.concat.cljs$lang$maxFixedArity = 2;
cljs.core.list_STAR_ = function cljs$core$list_STAR_(var_args) {
  var args46884 = [];
  var len__10375__auto___46892 = arguments.length;
  var i__10376__auto___46893 = 0;
  while (true) {
    if (i__10376__auto___46893 < len__10375__auto___46892) {
      args46884.push(arguments[i__10376__auto___46893]);
      var G__46894 = i__10376__auto___46893 + 1;
      i__10376__auto___46893 = G__46894;
      continue;
    } else {
    }
    break;
  }
  var G__46891 = args46884.length;
  switch(G__46891) {
    case 1:
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46884.slice(4), 0, null);
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__10398__auto__);
  }
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1 = function(args) {
  return cljs.core.seq(args);
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2 = function(a, args) {
  return cljs.core.cons(a, args);
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3 = function(a, b, args) {
  return cljs.core.cons(a, cljs.core.cons(b, args));
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4 = function(a, b, c, args) {
  return cljs.core.cons(a, cljs.core.cons(b, cljs.core.cons(c, args)));
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic = function(a, b, c, d, more) {
  return cljs.core.cons(a, cljs.core.cons(b, cljs.core.cons(c, cljs.core.cons(d, cljs.core.spread(more)))));
};
cljs.core.list_STAR_.cljs$lang$applyTo = function(seq46885) {
  var G__46886 = cljs.core.first(seq46885);
  var seq46885__$1 = cljs.core.next(seq46885);
  var G__46887 = cljs.core.first(seq46885__$1);
  var seq46885__$2 = cljs.core.next(seq46885__$1);
  var G__46888 = cljs.core.first(seq46885__$2);
  var seq46885__$3 = cljs.core.next(seq46885__$2);
  var G__46889 = cljs.core.first(seq46885__$3);
  var seq46885__$4 = cljs.core.next(seq46885__$3);
  return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic(G__46886, G__46887, G__46888, G__46889, seq46885__$4);
};
cljs.core.list_STAR_.cljs$lang$maxFixedArity = 4;
cljs.core.transient$ = function cljs$core$transient(coll) {
  return cljs.core._as_transient(coll);
};
cljs.core.persistent_BANG_ = function cljs$core$persistent_BANG_(tcoll) {
  return cljs.core._persistent_BANG_(tcoll);
};
cljs.core.conj_BANG_ = function cljs$core$conj_BANG_(var_args) {
  var args46896 = [];
  var len__10375__auto___46902 = arguments.length;
  var i__10376__auto___46903 = 0;
  while (true) {
    if (i__10376__auto___46903 < len__10375__auto___46902) {
      args46896.push(arguments[i__10376__auto___46903]);
      var G__46904 = i__10376__auto___46903 + 1;
      i__10376__auto___46903 = G__46904;
      continue;
    } else {
    }
    break;
  }
  var G__46901 = args46896.length;
  switch(G__46901) {
    case 0:
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46896.slice(2), 0, null);
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10398__auto__);
  }
};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1 = function(tcoll) {
  return tcoll;
};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2 = function(tcoll, val) {
  return cljs.core._conj_BANG_(tcoll, val);
};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(tcoll, val, vals) {
  while (true) {
    var ntcoll = cljs.core._conj_BANG_(tcoll, val);
    if (cljs.core.truth_(vals)) {
      var G__46906 = ntcoll;
      var G__46907 = cljs.core.first(vals);
      var G__46908 = cljs.core.next(vals);
      tcoll = G__46906;
      val = G__46907;
      vals = G__46908;
      continue;
    } else {
      return ntcoll;
    }
    break;
  }
};
cljs.core.conj_BANG_.cljs$lang$applyTo = function(seq46897) {
  var G__46898 = cljs.core.first(seq46897);
  var seq46897__$1 = cljs.core.next(seq46897);
  var G__46899 = cljs.core.first(seq46897__$1);
  var seq46897__$2 = cljs.core.next(seq46897__$1);
  return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__46898, G__46899, seq46897__$2);
};
cljs.core.conj_BANG_.cljs$lang$maxFixedArity = 2;
cljs.core.assoc_BANG_ = function cljs$core$assoc_BANG_(var_args) {
  var args46909 = [];
  var len__10375__auto___46916 = arguments.length;
  var i__10376__auto___46917 = 0;
  while (true) {
    if (i__10376__auto___46917 < len__10375__auto___46916) {
      args46909.push(arguments[i__10376__auto___46917]);
      var G__46918 = i__10376__auto___46917 + 1;
      i__10376__auto___46917 = G__46918;
      continue;
    } else {
    }
    break;
  }
  var G__46915 = args46909.length;
  switch(G__46915) {
    case 3:
      return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46909.slice(3), 0, null);
      return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__10398__auto__);
  }
};
cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3 = function(tcoll, key, val) {
  return cljs.core._assoc_BANG_(tcoll, key, val);
};
cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(tcoll, key, val, kvs) {
  while (true) {
    var ntcoll = cljs.core._assoc_BANG_(tcoll, key, val);
    if (cljs.core.truth_(kvs)) {
      var G__46920 = ntcoll;
      var G__46921 = cljs.core.first(kvs);
      var G__46922 = cljs.core.second(kvs);
      var G__46923 = cljs.core.nnext(kvs);
      tcoll = G__46920;
      key = G__46921;
      val = G__46922;
      kvs = G__46923;
      continue;
    } else {
      return ntcoll;
    }
    break;
  }
};
cljs.core.assoc_BANG_.cljs$lang$applyTo = function(seq46910) {
  var G__46911 = cljs.core.first(seq46910);
  var seq46910__$1 = cljs.core.next(seq46910);
  var G__46912 = cljs.core.first(seq46910__$1);
  var seq46910__$2 = cljs.core.next(seq46910__$1);
  var G__46913 = cljs.core.first(seq46910__$2);
  var seq46910__$3 = cljs.core.next(seq46910__$2);
  return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__46911, G__46912, G__46913, seq46910__$3);
};
cljs.core.assoc_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.dissoc_BANG_ = function cljs$core$dissoc_BANG_(var_args) {
  var args46924 = [];
  var len__10375__auto___46930 = arguments.length;
  var i__10376__auto___46931 = 0;
  while (true) {
    if (i__10376__auto___46931 < len__10375__auto___46930) {
      args46924.push(arguments[i__10376__auto___46931]);
      var G__46932 = i__10376__auto___46931 + 1;
      i__10376__auto___46931 = G__46932;
      continue;
    } else {
    }
    break;
  }
  var G__46929 = args46924.length;
  switch(G__46929) {
    case 2:
      return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46924.slice(2), 0, null);
      return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10398__auto__);
  }
};
cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2 = function(tcoll, key) {
  return cljs.core._dissoc_BANG_(tcoll, key);
};
cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(tcoll, key, ks) {
  while (true) {
    var ntcoll = cljs.core._dissoc_BANG_(tcoll, key);
    if (cljs.core.truth_(ks)) {
      var G__46934 = ntcoll;
      var G__46935 = cljs.core.first(ks);
      var G__46936 = cljs.core.next(ks);
      tcoll = G__46934;
      key = G__46935;
      ks = G__46936;
      continue;
    } else {
      return ntcoll;
    }
    break;
  }
};
cljs.core.dissoc_BANG_.cljs$lang$applyTo = function(seq46925) {
  var G__46926 = cljs.core.first(seq46925);
  var seq46925__$1 = cljs.core.next(seq46925);
  var G__46927 = cljs.core.first(seq46925__$1);
  var seq46925__$2 = cljs.core.next(seq46925__$1);
  return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__46926, G__46927, seq46925__$2);
};
cljs.core.dissoc_BANG_.cljs$lang$maxFixedArity = 2;
cljs.core.pop_BANG_ = function cljs$core$pop_BANG_(tcoll) {
  return cljs.core._pop_BANG_(tcoll);
};
cljs.core.disj_BANG_ = function cljs$core$disj_BANG_(var_args) {
  var args46937 = [];
  var len__10375__auto___46943 = arguments.length;
  var i__10376__auto___46944 = 0;
  while (true) {
    if (i__10376__auto___46944 < len__10375__auto___46943) {
      args46937.push(arguments[i__10376__auto___46944]);
      var G__46945 = i__10376__auto___46944 + 1;
      i__10376__auto___46944 = G__46945;
      continue;
    } else {
    }
    break;
  }
  var G__46942 = args46937.length;
  switch(G__46942) {
    case 2:
      return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46937.slice(2), 0, null);
      return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10398__auto__);
  }
};
cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2 = function(tcoll, val) {
  return cljs.core._disjoin_BANG_(tcoll, val);
};
cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(tcoll, val, vals) {
  while (true) {
    var ntcoll = cljs.core._disjoin_BANG_(tcoll, val);
    if (cljs.core.truth_(vals)) {
      var G__46947 = ntcoll;
      var G__46948 = cljs.core.first(vals);
      var G__46949 = cljs.core.next(vals);
      tcoll = G__46947;
      val = G__46948;
      vals = G__46949;
      continue;
    } else {
      return ntcoll;
    }
    break;
  }
};
cljs.core.disj_BANG_.cljs$lang$applyTo = function(seq46938) {
  var G__46939 = cljs.core.first(seq46938);
  var seq46938__$1 = cljs.core.next(seq46938);
  var G__46940 = cljs.core.first(seq46938__$1);
  var seq46938__$2 = cljs.core.next(seq46938__$1);
  return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__46939, G__46940, seq46938__$2);
};
cljs.core.disj_BANG_.cljs$lang$maxFixedArity = 2;
cljs.core.apply_to = function cljs$core$apply_to(f, argc, args) {
  var args__$1 = cljs.core.seq(args);
  if (argc === 0) {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  } else {
    var a10219 = cljs.core._first(args__$1);
    var args__$2 = cljs.core._rest(args__$1);
    if (argc === 1) {
      if (f.cljs$core$IFn$_invoke$arity$1) {
        return f.cljs$core$IFn$_invoke$arity$1(a10219);
      } else {
        return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(a10219) : f.call(null, a10219);
      }
    } else {
      var b10220 = cljs.core._first(args__$2);
      var args__$3 = cljs.core._rest(args__$2);
      if (argc === 2) {
        if (f.cljs$core$IFn$_invoke$arity$2) {
          return f.cljs$core$IFn$_invoke$arity$2(a10219, b10220);
        } else {
          return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(a10219, b10220) : f.call(null, a10219, b10220);
        }
      } else {
        var c10221 = cljs.core._first(args__$3);
        var args__$4 = cljs.core._rest(args__$3);
        if (argc === 3) {
          if (f.cljs$core$IFn$_invoke$arity$3) {
            return f.cljs$core$IFn$_invoke$arity$3(a10219, b10220, c10221);
          } else {
            return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(a10219, b10220, c10221) : f.call(null, a10219, b10220, c10221);
          }
        } else {
          var d10222 = cljs.core._first(args__$4);
          var args__$5 = cljs.core._rest(args__$4);
          if (argc === 4) {
            if (f.cljs$core$IFn$_invoke$arity$4) {
              return f.cljs$core$IFn$_invoke$arity$4(a10219, b10220, c10221, d10222);
            } else {
              return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(a10219, b10220, c10221, d10222) : f.call(null, a10219, b10220, c10221, d10222);
            }
          } else {
            var e10223 = cljs.core._first(args__$5);
            var args__$6 = cljs.core._rest(args__$5);
            if (argc === 5) {
              if (f.cljs$core$IFn$_invoke$arity$5) {
                return f.cljs$core$IFn$_invoke$arity$5(a10219, b10220, c10221, d10222, e10223);
              } else {
                return f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(a10219, b10220, c10221, d10222, e10223) : f.call(null, a10219, b10220, c10221, d10222, e10223);
              }
            } else {
              var f10224 = cljs.core._first(args__$6);
              var args__$7 = cljs.core._rest(args__$6);
              if (argc === 6) {
                if (f.cljs$core$IFn$_invoke$arity$6) {
                  return f.cljs$core$IFn$_invoke$arity$6(a10219, b10220, c10221, d10222, e10223, f10224);
                } else {
                  return f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(a10219, b10220, c10221, d10222, e10223, f10224) : f.call(null, a10219, b10220, c10221, d10222, e10223, f10224);
                }
              } else {
                var g10225 = cljs.core._first(args__$7);
                var args__$8 = cljs.core._rest(args__$7);
                if (argc === 7) {
                  if (f.cljs$core$IFn$_invoke$arity$7) {
                    return f.cljs$core$IFn$_invoke$arity$7(a10219, b10220, c10221, d10222, e10223, f10224, g10225);
                  } else {
                    return f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(a10219, b10220, c10221, d10222, e10223, f10224, g10225) : f.call(null, a10219, b10220, c10221, d10222, e10223, f10224, g10225);
                  }
                } else {
                  var h10226 = cljs.core._first(args__$8);
                  var args__$9 = cljs.core._rest(args__$8);
                  if (argc === 8) {
                    if (f.cljs$core$IFn$_invoke$arity$8) {
                      return f.cljs$core$IFn$_invoke$arity$8(a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226);
                    } else {
                      return f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226) : f.call(null, a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226);
                    }
                  } else {
                    var i10227 = cljs.core._first(args__$9);
                    var args__$10 = cljs.core._rest(args__$9);
                    if (argc === 9) {
                      if (f.cljs$core$IFn$_invoke$arity$9) {
                        return f.cljs$core$IFn$_invoke$arity$9(a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226, i10227);
                      } else {
                        return f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226, i10227) : f.call(null, a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226, i10227);
                      }
                    } else {
                      var j10228 = cljs.core._first(args__$10);
                      var args__$11 = cljs.core._rest(args__$10);
                      if (argc === 10) {
                        if (f.cljs$core$IFn$_invoke$arity$10) {
                          return f.cljs$core$IFn$_invoke$arity$10(a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226, i10227, j10228);
                        } else {
                          return f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226, i10227, j10228) : f.call(null, a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226, i10227, j10228);
                        }
                      } else {
                        var k10229 = cljs.core._first(args__$11);
                        var args__$12 = cljs.core._rest(args__$11);
                        if (argc === 11) {
                          if (f.cljs$core$IFn$_invoke$arity$11) {
                            return f.cljs$core$IFn$_invoke$arity$11(a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226, i10227, j10228, k10229);
                          } else {
                            return f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226, i10227, j10228, k10229) : f.call(null, a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226, i10227, j10228, k10229);
                          }
                        } else {
                          var l10230 = cljs.core._first(args__$12);
                          var args__$13 = cljs.core._rest(args__$12);
                          if (argc === 12) {
                            if (f.cljs$core$IFn$_invoke$arity$12) {
                              return f.cljs$core$IFn$_invoke$arity$12(a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226, i10227, j10228, k10229, l10230);
                            } else {
                              return f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226, i10227, j10228, k10229, l10230) : f.call(null, a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226, i10227, j10228, k10229, l10230);
                            }
                          } else {
                            var m10231 = cljs.core._first(args__$13);
                            var args__$14 = cljs.core._rest(args__$13);
                            if (argc === 13) {
                              if (f.cljs$core$IFn$_invoke$arity$13) {
                                return f.cljs$core$IFn$_invoke$arity$13(a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226, i10227, j10228, k10229, l10230, m10231);
                              } else {
                                return f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226, i10227, j10228, k10229, l10230, m10231) : f.call(null, a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226, i10227, j10228, k10229, l10230, m10231);
                              }
                            } else {
                              var n10232 = cljs.core._first(args__$14);
                              var args__$15 = cljs.core._rest(args__$14);
                              if (argc === 14) {
                                if (f.cljs$core$IFn$_invoke$arity$14) {
                                  return f.cljs$core$IFn$_invoke$arity$14(a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226, i10227, j10228, k10229, l10230, m10231, n10232);
                                } else {
                                  return f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226, i10227, j10228, k10229, l10230, m10231, n10232) : f.call(null, a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226, i10227, j10228, k10229, l10230, m10231, n10232);
                                }
                              } else {
                                var o10233 = cljs.core._first(args__$15);
                                var args__$16 = cljs.core._rest(args__$15);
                                if (argc === 15) {
                                  if (f.cljs$core$IFn$_invoke$arity$15) {
                                    return f.cljs$core$IFn$_invoke$arity$15(a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226, i10227, j10228, k10229, l10230, m10231, n10232, o10233);
                                  } else {
                                    return f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226, i10227, j10228, k10229, l10230, m10231, n10232, o10233) : f.call(null, a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226, i10227, j10228, k10229, l10230, m10231, n10232, o10233);
                                  }
                                } else {
                                  var p10234 = cljs.core._first(args__$16);
                                  var args__$17 = cljs.core._rest(args__$16);
                                  if (argc === 16) {
                                    if (f.cljs$core$IFn$_invoke$arity$16) {
                                      return f.cljs$core$IFn$_invoke$arity$16(a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226, i10227, j10228, k10229, l10230, m10231, n10232, o10233, p10234);
                                    } else {
                                      return f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226, i10227, j10228, k10229, l10230, m10231, n10232, o10233, p10234) : f.call(null, a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226, i10227, j10228, k10229, l10230, m10231, n10232, o10233, p10234);
                                    }
                                  } else {
                                    var q10235 = cljs.core._first(args__$17);
                                    var args__$18 = cljs.core._rest(args__$17);
                                    if (argc === 17) {
                                      if (f.cljs$core$IFn$_invoke$arity$17) {
                                        return f.cljs$core$IFn$_invoke$arity$17(a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226, i10227, j10228, k10229, l10230, m10231, n10232, o10233, p10234, q10235);
                                      } else {
                                        return f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226, i10227, j10228, k10229, l10230, m10231, n10232, o10233, p10234, q10235) : f.call(null, a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226, i10227, j10228, k10229, l10230, m10231, n10232, o10233, p10234, q10235);
                                      }
                                    } else {
                                      var r10236 = cljs.core._first(args__$18);
                                      var args__$19 = cljs.core._rest(args__$18);
                                      if (argc === 18) {
                                        if (f.cljs$core$IFn$_invoke$arity$18) {
                                          return f.cljs$core$IFn$_invoke$arity$18(a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226, i10227, j10228, k10229, l10230, m10231, n10232, o10233, p10234, q10235, r10236);
                                        } else {
                                          return f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226, i10227, j10228, k10229, l10230, m10231, n10232, o10233, p10234, q10235, r10236) : f.call(null, a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226, i10227, j10228, k10229, l10230, m10231, n10232, o10233, p10234, q10235, r10236);
                                        }
                                      } else {
                                        var s10237 = cljs.core._first(args__$19);
                                        var args__$20 = cljs.core._rest(args__$19);
                                        if (argc === 19) {
                                          if (f.cljs$core$IFn$_invoke$arity$19) {
                                            return f.cljs$core$IFn$_invoke$arity$19(a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226, i10227, j10228, k10229, l10230, m10231, n10232, o10233, p10234, q10235, r10236, s10237);
                                          } else {
                                            return f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226, i10227, j10228, k10229, l10230, m10231, n10232, o10233, p10234, q10235, r10236, s10237) : f.call(null, a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226, i10227, j10228, k10229, l10230, m10231, n10232, o10233, p10234, q10235, r10236, s10237);
                                          }
                                        } else {
                                          var t10238 = cljs.core._first(args__$20);
                                          var args__$21 = cljs.core._rest(args__$20);
                                          if (argc === 20) {
                                            if (f.cljs$core$IFn$_invoke$arity$20) {
                                              return f.cljs$core$IFn$_invoke$arity$20(a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226, i10227, j10228, k10229, l10230, m10231, n10232, o10233, p10234, q10235, r10236, s10237, t10238);
                                            } else {
                                              return f.cljs$core$IFn$_invoke$arity$20 ? f.cljs$core$IFn$_invoke$arity$20(a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226, i10227, j10228, k10229, l10230, m10231, n10232, o10233, p10234, q10235, r10236, s10237, t10238) : f.call(null, a10219, b10220, c10221, d10222, e10223, f10224, g10225, h10226, i10227, j10228, k10229, l10230, m10231, n10232, o10233, p10234, q10235, r10236, s10237, t10238);
                                            }
                                          } else {
                                            throw new Error("Only up to 20 arguments supported on functions");
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.apply = function cljs$core$apply(var_args) {
  var args46950 = [];
  var len__10375__auto___46959 = arguments.length;
  var i__10376__auto___46960 = 0;
  while (true) {
    if (i__10376__auto___46960 < len__10375__auto___46959) {
      args46950.push(arguments[i__10376__auto___46960]);
      var G__46961 = i__10376__auto___46960 + 1;
      i__10376__auto___46960 = G__46961;
      continue;
    } else {
    }
    break;
  }
  var G__46958 = args46950.length;
  switch(G__46958) {
    case 2:
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46950.slice(5), 0, null);
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], argseq__10398__auto__);
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$2 = function(f, args) {
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(fixed_arity + 1, args);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, args);
    } else {
      return f.cljs$lang$applyTo(args);
    }
  } else {
    return f.apply(f, cljs.core.to_array(args));
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$3 = function(f, x, args) {
  var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(x, args);
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(fixed_arity + 1, arglist);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, arglist);
    } else {
      return f.cljs$lang$applyTo(arglist);
    }
  } else {
    return f.apply(f, cljs.core.to_array(arglist));
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$4 = function(f, x, y, args) {
  var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(x, y, args);
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(fixed_arity + 1, arglist);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, arglist);
    } else {
      return f.cljs$lang$applyTo(arglist);
    }
  } else {
    return f.apply(f, cljs.core.to_array(arglist));
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$5 = function(f, x, y, z, args) {
  var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(x, y, z, args);
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(fixed_arity + 1, arglist);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, arglist);
    } else {
      return f.cljs$lang$applyTo(arglist);
    }
  } else {
    return f.apply(f, cljs.core.to_array(arglist));
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic = function(f, a, b, c, d, args) {
  var arglist = cljs.core.cons(a, cljs.core.cons(b, cljs.core.cons(c, cljs.core.cons(d, cljs.core.spread(args)))));
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(fixed_arity + 1, arglist);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, arglist);
    } else {
      return f.cljs$lang$applyTo(arglist);
    }
  } else {
    return f.apply(f, cljs.core.to_array(arglist));
  }
};
cljs.core.apply.cljs$lang$applyTo = function(seq46951) {
  var G__46952 = cljs.core.first(seq46951);
  var seq46951__$1 = cljs.core.next(seq46951);
  var G__46953 = cljs.core.first(seq46951__$1);
  var seq46951__$2 = cljs.core.next(seq46951__$1);
  var G__46954 = cljs.core.first(seq46951__$2);
  var seq46951__$3 = cljs.core.next(seq46951__$2);
  var G__46955 = cljs.core.first(seq46951__$3);
  var seq46951__$4 = cljs.core.next(seq46951__$3);
  var G__46956 = cljs.core.first(seq46951__$4);
  var seq46951__$5 = cljs.core.next(seq46951__$4);
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(G__46952, G__46953, G__46954, G__46955, G__46956, seq46951__$5);
};
cljs.core.apply.cljs$lang$maxFixedArity = 5;
cljs.core.vary_meta = function cljs$core$vary_meta(var_args) {
  var args46963 = [];
  var len__10375__auto___46988 = arguments.length;
  var i__10376__auto___46989 = 0;
  while (true) {
    if (i__10376__auto___46989 < len__10375__auto___46988) {
      args46963.push(arguments[i__10376__auto___46989]);
      var G__46990 = i__10376__auto___46989 + 1;
      i__10376__auto___46989 = G__46990;
      continue;
    } else {
    }
    break;
  }
  var G__46972 = args46963.length;
  switch(G__46972) {
    case 2:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46963.slice(6), 0, null);
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], argseq__10398__auto__);
  }
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2 = function(obj, f) {
  return cljs.core.with_meta(obj, function() {
    var G__46973 = cljs.core.meta(obj);
    return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__46973) : f.call(null, G__46973);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3 = function(obj, f, a) {
  return cljs.core.with_meta(obj, function() {
    var G__46974 = cljs.core.meta(obj);
    var G__46975 = a;
    return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__46974, G__46975) : f.call(null, G__46974, G__46975);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4 = function(obj, f, a, b) {
  return cljs.core.with_meta(obj, function() {
    var G__46976 = cljs.core.meta(obj);
    var G__46977 = a;
    var G__46978 = b;
    return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__46976, G__46977, G__46978) : f.call(null, G__46976, G__46977, G__46978);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5 = function(obj, f, a, b, c) {
  return cljs.core.with_meta(obj, function() {
    var G__46979 = cljs.core.meta(obj);
    var G__46980 = a;
    var G__46981 = b;
    var G__46982 = c;
    return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__46979, G__46980, G__46981, G__46982) : f.call(null, G__46979, G__46980, G__46981, G__46982);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6 = function(obj, f, a, b, c, d) {
  return cljs.core.with_meta(obj, function() {
    var G__46983 = cljs.core.meta(obj);
    var G__46984 = a;
    var G__46985 = b;
    var G__46986 = c;
    var G__46987 = d;
    return f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__46983, G__46984, G__46985, G__46986, G__46987) : f.call(null, G__46983, G__46984, G__46985, G__46986, G__46987);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic = function(obj, f, a, b, c, d, args) {
  return cljs.core.with_meta(obj, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, cljs.core.meta(obj), a, b, c, cljs.core.array_seq([d, args], 0)));
};
cljs.core.vary_meta.cljs$lang$applyTo = function(seq46964) {
  var G__46965 = cljs.core.first(seq46964);
  var seq46964__$1 = cljs.core.next(seq46964);
  var G__46966 = cljs.core.first(seq46964__$1);
  var seq46964__$2 = cljs.core.next(seq46964__$1);
  var G__46967 = cljs.core.first(seq46964__$2);
  var seq46964__$3 = cljs.core.next(seq46964__$2);
  var G__46968 = cljs.core.first(seq46964__$3);
  var seq46964__$4 = cljs.core.next(seq46964__$3);
  var G__46969 = cljs.core.first(seq46964__$4);
  var seq46964__$5 = cljs.core.next(seq46964__$4);
  var G__46970 = cljs.core.first(seq46964__$5);
  var seq46964__$6 = cljs.core.next(seq46964__$5);
  return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic(G__46965, G__46966, G__46967, G__46968, G__46969, G__46970, seq46964__$6);
};
cljs.core.vary_meta.cljs$lang$maxFixedArity = 6;
cljs.core.not_EQ_ = function cljs$core$not_EQ_(var_args) {
  var args46992 = [];
  var len__10375__auto___46998 = arguments.length;
  var i__10376__auto___46999 = 0;
  while (true) {
    if (i__10376__auto___46999 < len__10375__auto___46998) {
      args46992.push(arguments[i__10376__auto___46999]);
      var G__47000 = i__10376__auto___46999 + 1;
      i__10376__auto___46999 = G__47000;
      continue;
    } else {
    }
    break;
  }
  var G__46997 = args46992.length;
  switch(G__46997) {
    case 1:
      return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args46992.slice(2), 0, null);
      return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10398__auto__);
  }
};
cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return false;
};
cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return !cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y);
};
cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_, x, y, more));
};
cljs.core.not_EQ_.cljs$lang$applyTo = function(seq46993) {
  var G__46994 = cljs.core.first(seq46993);
  var seq46993__$1 = cljs.core.next(seq46993);
  var G__46995 = cljs.core.first(seq46993__$1);
  var seq46993__$2 = cljs.core.next(seq46993__$1);
  return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(G__46994, G__46995, seq46993__$2);
};
cljs.core.not_EQ_.cljs$lang$maxFixedArity = 2;
cljs.core.not_empty = function cljs$core$not_empty(coll) {
  if (cljs.core.seq(coll)) {
    return coll;
  } else {
    return null;
  }
};
cljs.core.nil_iter = function cljs$core$nil_iter() {
  if (typeof cljs.core.t_cljs$core47005 !== "undefined") {
  } else {
    cljs.core.t_cljs$core47005 = function(meta47006) {
      this.meta47006 = meta47006;
      this.cljs$lang$protocol_mask$partition0$ = 393216;
      this.cljs$lang$protocol_mask$partition1$ = 0;
    };
    cljs.core.t_cljs$core47005.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(_47007, meta47006__$1) {
      var self__ = this;
      var _47007__$1 = this;
      return new cljs.core.t_cljs$core47005(meta47006__$1);
    };
    cljs.core.t_cljs$core47005.prototype.cljs$core$IMeta$_meta$arity$1 = function(_47007) {
      var self__ = this;
      var _47007__$1 = this;
      return self__.meta47006;
    };
    cljs.core.t_cljs$core47005.prototype.hasNext = function() {
      var self__ = this;
      var _ = this;
      return false;
    };
    cljs.core.t_cljs$core47005.prototype.next = function() {
      var self__ = this;
      var _ = this;
      return new Error("No such element");
    };
    cljs.core.t_cljs$core47005.prototype.remove = function() {
      var self__ = this;
      var _ = this;
      return new Error("Unsupported operation");
    };
    cljs.core.t_cljs$core47005.getBasis = function() {
      return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta47006", "meta47006", 1301297905, null)], null);
    };
    cljs.core.t_cljs$core47005.cljs$lang$type = true;
    cljs.core.t_cljs$core47005.cljs$lang$ctorStr = "cljs.core/t_cljs$core47005";
    cljs.core.t_cljs$core47005.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
      return cljs.core._write(writer__9812__auto__, "cljs.core/t_cljs$core47005");
    };
    cljs.core.__GT_t_cljs$core47005 = function cljs$core$nil_iter_$___GT_t_cljs$core47005(meta47006) {
      return new cljs.core.t_cljs$core47005(meta47006);
    };
  }
  return new cljs.core.t_cljs$core47005(cljs.core.PersistentArrayMap.EMPTY);
};
cljs.core.StringIter = function(s, i) {
  this.s = s;
  this.i = i;
};
cljs.core.StringIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.i < self__.s.length;
};
cljs.core.StringIter.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = self__.s.charAt(self__.i);
  self__.i = self__.i + 1;
  return ret;
};
cljs.core.StringIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.StringIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "s", "s", -948495851, null), cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.StringIter.cljs$lang$type = true;
cljs.core.StringIter.cljs$lang$ctorStr = "cljs.core/StringIter";
cljs.core.StringIter.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/StringIter");
};
cljs.core.__GT_StringIter = function cljs$core$__GT_StringIter(s, i) {
  return new cljs.core.StringIter(s, i);
};
cljs.core.string_iter = function cljs$core$string_iter(x) {
  return new cljs.core.StringIter(x, 0);
};
cljs.core.ArrayIter = function(arr, i) {
  this.arr = arr;
  this.i = i;
};
cljs.core.ArrayIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.i < self__.arr.length;
};
cljs.core.ArrayIter.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = self__.arr[self__.i];
  self__.i = self__.i + 1;
  return ret;
};
cljs.core.ArrayIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.ArrayIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ArrayIter.cljs$lang$type = true;
cljs.core.ArrayIter.cljs$lang$ctorStr = "cljs.core/ArrayIter";
cljs.core.ArrayIter.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/ArrayIter");
};
cljs.core.__GT_ArrayIter = function cljs$core$__GT_ArrayIter(arr, i) {
  return new cljs.core.ArrayIter(arr, i);
};
cljs.core.array_iter = function cljs$core$array_iter(x) {
  return new cljs.core.ArrayIter(x, 0);
};
cljs.core.INIT = {};
cljs.core.START = {};
cljs.core.SeqIter = function(_seq, _next) {
  this._seq = _seq;
  this._next = _next;
};
cljs.core.SeqIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  if (self__._seq === cljs.core.INIT) {
    self__._seq = cljs.core.START;
    self__._next = cljs.core.seq(self__._next);
  } else {
    if (self__._seq === self__._next) {
      self__._next = cljs.core.next(self__._seq);
    } else {
    }
  }
  return !(self__._next == null);
};
cljs.core.SeqIter.prototype.next = function() {
  var self__ = this;
  var this$ = this;
  if (!this$.hasNext()) {
    throw new Error("No such element");
  } else {
    self__._seq = self__._next;
    return cljs.core.first(self__._next);
  }
};
cljs.core.SeqIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.SeqIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "_seq", "_seq", -449557847, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "_next", "_next", 101877036, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.SeqIter.cljs$lang$type = true;
cljs.core.SeqIter.cljs$lang$ctorStr = "cljs.core/SeqIter";
cljs.core.SeqIter.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/SeqIter");
};
cljs.core.__GT_SeqIter = function cljs$core$__GT_SeqIter(_seq, _next) {
  return new cljs.core.SeqIter(_seq, _next);
};
cljs.core.seq_iter = function cljs$core$seq_iter(coll) {
  return new cljs.core.SeqIter(cljs.core.INIT, coll);
};
cljs.core.iter = function cljs$core$iter(coll) {
  if (coll == null) {
    return cljs.core.nil_iter();
  } else {
    if (typeof coll === "string") {
      return cljs.core.string_iter(coll);
    } else {
      if (cljs.core.array_QMARK_(coll)) {
        return cljs.core.array_iter(coll);
      } else {
        if (cljs.core.iterable_QMARK_(coll)) {
          return cljs.core._iterator(coll);
        } else {
          if (cljs.core.seqable_QMARK_(coll)) {
            return cljs.core.seq_iter(coll);
          } else {
            throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Cannot create iterator from "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll)].join(""));
          }
        }
      }
    }
  }
};
cljs.core.lazy_transformer = function cljs$core$lazy_transformer(stepper) {
  return new cljs.core.LazyTransformer(stepper, null, null, null);
};
cljs.core.Stepper = function(xform, iter) {
  this.xform = xform;
  this.iter = iter;
};
cljs.core.Stepper.prototype.step = function(lt) {
  var self__ = this;
  var this$ = this;
  while (true) {
    if (cljs.core.truth_(function() {
      var and__9142__auto__ = !(lt.stepper == null);
      if (and__9142__auto__) {
        return self__.iter.hasNext();
      } else {
        return and__9142__auto__;
      }
    }())) {
      if (cljs.core.reduced_QMARK_(function() {
        var G__47008 = lt;
        var G__47009 = self__.iter.next();
        return self__.xform.cljs$core$IFn$_invoke$arity$2 ? self__.xform.cljs$core$IFn$_invoke$arity$2(G__47008, G__47009) : self__.xform.call(null, G__47008, G__47009);
      }())) {
        if (lt.rest == null) {
        } else {
          lt.rest.stepper = null;
        }
      } else {
        continue;
      }
    } else {
    }
    break;
  }
  if (lt.stepper == null) {
    return null;
  } else {
    return self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(lt) : self__.xform.call(null, lt);
  }
};
cljs.core.Stepper.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "xform", "xform", -85179481, null), new cljs.core.Symbol(null, "iter", "iter", -1346195486, null)], null);
};
cljs.core.Stepper.cljs$lang$type = true;
cljs.core.Stepper.cljs$lang$ctorStr = "cljs.core/Stepper";
cljs.core.Stepper.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/Stepper");
};
cljs.core.__GT_Stepper = function cljs$core$__GT_Stepper(xform, iter) {
  return new cljs.core.Stepper(xform, iter);
};
cljs.core.stepper = function cljs$core$stepper(xform, iter) {
  var stepfn = function() {
    var cljs$core$stepper_$_stepfn = null;
    var cljs$core$stepper_$_stepfn__1 = function(result) {
      var lt = cljs.core.reduced_QMARK_(result) ? cljs.core.deref(result) : result;
      lt.stepper = null;
      return result;
    };
    var cljs$core$stepper_$_stepfn__2 = function(result, input) {
      var lt = result;
      lt.first = input;
      lt.rest = cljs.core.lazy_transformer(lt.stepper);
      lt.stepper = null;
      return lt.rest;
    };
    cljs$core$stepper_$_stepfn = function(result, input) {
      switch(arguments.length) {
        case 1:
          return cljs$core$stepper_$_stepfn__1.call(this, result);
        case 2:
          return cljs$core$stepper_$_stepfn__2.call(this, result, input);
      }
      throw new Error("Invalid arity: " + (arguments.length - 1));
    };
    cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$stepper_$_stepfn__1;
    cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$stepper_$_stepfn__2;
    return cljs$core$stepper_$_stepfn;
  }();
  return new cljs.core.Stepper(xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(stepfn) : xform.call(null, stepfn), iter);
};
cljs.core.MultiStepper = function(xform, iters, nexts) {
  this.xform = xform;
  this.iters = iters;
  this.nexts = nexts;
};
cljs.core.MultiStepper.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  var iters__$1 = cljs.core.seq(self__.iters);
  while (true) {
    if (!(iters__$1 == null)) {
      var iter = cljs.core.first(iters__$1);
      if (!iter.hasNext()) {
        return false;
      } else {
        var G__47010 = cljs.core.next(iters__$1);
        iters__$1 = G__47010;
        continue;
      }
    } else {
      return true;
    }
    break;
  }
};
cljs.core.MultiStepper.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var n__10175__auto___47011 = self__.iters.length;
  var i_47012 = 0;
  while (true) {
    if (i_47012 < n__10175__auto___47011) {
      self__.nexts[i_47012] = self__.iters[i_47012].next();
      var G__47013 = i_47012 + 1;
      i_47012 = G__47013;
      continue;
    } else {
    }
    break;
  }
  return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(self__.nexts, 0);
};
cljs.core.MultiStepper.prototype.step = function(lt) {
  var self__ = this;
  var this$ = this;
  while (true) {
    if (cljs.core.truth_(function() {
      var and__9142__auto__ = !(lt.stepper == null);
      if (and__9142__auto__) {
        return this$.hasNext();
      } else {
        return and__9142__auto__;
      }
    }())) {
      if (cljs.core.reduced_QMARK_(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.xform, cljs.core.cons(lt, this$.next())))) {
        if (lt.rest == null) {
        } else {
          lt.rest.stepper = null;
        }
      } else {
        continue;
      }
    } else {
    }
    break;
  }
  if (lt.stepper == null) {
    return null;
  } else {
    return self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(lt) : self__.xform.call(null, lt);
  }
};
cljs.core.MultiStepper.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "xform", "xform", -85179481, null), new cljs.core.Symbol(null, "iters", "iters", 719353031, null), new cljs.core.Symbol(null, "nexts", "nexts", -1683579407, null)], null);
};
cljs.core.MultiStepper.cljs$lang$type = true;
cljs.core.MultiStepper.cljs$lang$ctorStr = "cljs.core/MultiStepper";
cljs.core.MultiStepper.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/MultiStepper");
};
cljs.core.__GT_MultiStepper = function cljs$core$__GT_MultiStepper(xform, iters, nexts) {
  return new cljs.core.MultiStepper(xform, iters, nexts);
};
cljs.core.multi_stepper = function cljs$core$multi_stepper(var_args) {
  var args47014 = [];
  var len__10375__auto___47017 = arguments.length;
  var i__10376__auto___47018 = 0;
  while (true) {
    if (i__10376__auto___47018 < len__10375__auto___47017) {
      args47014.push(arguments[i__10376__auto___47018]);
      var G__47019 = i__10376__auto___47018 + 1;
      i__10376__auto___47018 = G__47019;
      continue;
    } else {
    }
    break;
  }
  var G__47016 = args47014.length;
  switch(G__47016) {
    case 2:
      return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args47014.length)].join(""));
  }
};
cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$2 = function(xform, iters) {
  return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform, iters, new Array(iters.length));
};
cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3 = function(xform, iters, nexts) {
  var stepfn = function() {
    var cljs$core$stepfn = null;
    var cljs$core$stepfn__1 = function(result) {
      var lt = cljs.core.reduced_QMARK_(result) ? cljs.core.deref(result) : result;
      lt.stepper = null;
      return lt;
    };
    var cljs$core$stepfn__2 = function(result, input) {
      var lt = result;
      lt.first = input;
      lt.rest = cljs.core.lazy_transformer(lt.stepper);
      lt.stepper = null;
      return lt.rest;
    };
    cljs$core$stepfn = function(result, input) {
      switch(arguments.length) {
        case 1:
          return cljs$core$stepfn__1.call(this, result);
        case 2:
          return cljs$core$stepfn__2.call(this, result, input);
      }
      throw new Error("Invalid arity: " + (arguments.length - 1));
    };
    cljs$core$stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$stepfn__1;
    cljs$core$stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$stepfn__2;
    return cljs$core$stepfn;
  }();
  return new cljs.core.MultiStepper(xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(stepfn) : xform.call(null, stepfn), iters, nexts);
};
cljs.core.multi_stepper.cljs$lang$maxFixedArity = 3;
cljs.core.LazyTransformer = function(stepper, first, rest, meta) {
  this.stepper = stepper;
  this.first = first;
  this.rest = rest;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 31850700;
  this.cljs$lang$protocol_mask$partition1$ = 1;
};
cljs.core.LazyTransformer.prototype.indexOf = function() {
  var G__47021 = null;
  var G__47021__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__47021__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__47021 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__47021__1.call(this, x);
      case 2:
        return G__47021__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__47021.cljs$core$IFn$_invoke$arity$1 = G__47021__1;
  G__47021.cljs$core$IFn$_invoke$arity$2 = G__47021__2;
  return G__47021;
}();
cljs.core.LazyTransformer.prototype.lastIndexOf = function() {
  var G__47022 = null;
  var G__47022__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__47022__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__47022 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__47022__1.call(this, x);
      case 2:
        return G__47022__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__47022.cljs$core$IFn$_invoke$arity$1 = G__47022__1;
  G__47022.cljs$core$IFn$_invoke$arity$2 = G__47022__2;
  return G__47022;
}();
cljs.core.LazyTransformer.prototype.cljs$core$IMeta$_meta$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return self__.meta;
};
cljs.core.LazyTransformer.prototype.cljs$core$INext$_next$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.stepper == null) {
  } else {
    this$__$1.cljs$core$ISeqable$_seq$arity$1(null);
  }
  if (self__.rest == null) {
    return null;
  } else {
    return cljs.core._seq(self__.rest);
  }
};
cljs.core.LazyTransformer.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.hash_ordered_coll(this$__$1);
};
cljs.core.LazyTransformer.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(this$, other) {
  var self__ = this;
  var this$__$1 = this;
  var s = this$__$1.cljs$core$ISeqable$_seq$arity$1(null);
  if (!(s == null)) {
    return cljs.core.equiv_sequential(this$__$1, other);
  } else {
    return cljs.core.sequential_QMARK_(other) && cljs.core.seq(other) == null;
  }
};
cljs.core.LazyTransformer.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.List.EMPTY;
};
cljs.core.LazyTransformer.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.stepper == null;
};
cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.stepper == null) {
  } else {
    this$__$1.cljs$core$ISeqable$_seq$arity$1(null);
  }
  if (self__.rest == null) {
    return null;
  } else {
    return self__.first;
  }
};
cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.stepper == null) {
  } else {
    this$__$1.cljs$core$ISeqable$_seq$arity$1(null);
  }
  if (self__.rest == null) {
    return cljs.core.List.EMPTY;
  } else {
    return self__.rest;
  }
};
cljs.core.LazyTransformer.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.stepper == null) {
  } else {
    self__.stepper.step(this$__$1);
  }
  if (self__.rest == null) {
    return null;
  } else {
    return this$__$1;
  }
};
cljs.core.LazyTransformer.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(this$, new_meta) {
  var self__ = this;
  var this$__$1 = this;
  return new cljs.core.LazyTransformer(self__.stepper, self__.first, self__.rest, new_meta);
};
cljs.core.LazyTransformer.prototype.cljs$core$ICollection$_conj$arity$2 = function(this$, o) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.cons(o, this$__$1.cljs$core$ISeqable$_seq$arity$1(null));
};
cljs.core.LazyTransformer.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "stepper", "stepper", 1159163296, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "first", "first", 996428481, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), 
  cljs.core.with_meta(new cljs.core.Symbol(null, "rest", "rest", 398835108, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null)], null);
};
cljs.core.LazyTransformer.cljs$lang$type = true;
cljs.core.LazyTransformer.cljs$lang$ctorStr = "cljs.core/LazyTransformer";
cljs.core.LazyTransformer.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/LazyTransformer");
};
cljs.core.__GT_LazyTransformer = function cljs$core$__GT_LazyTransformer(stepper, first, rest, meta) {
  return new cljs.core.LazyTransformer(stepper, first, rest, meta);
};
cljs.core.LazyTransformer.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__10266__auto__ = this;
  return cljs.core.es6_iterator(this__10266__auto__);
};
cljs.core.LazyTransformer.create = function(xform, coll) {
  return new cljs.core.LazyTransformer(cljs.core.stepper(xform, cljs.core.iter(coll)), null, null, null);
};
cljs.core.LazyTransformer.createMulti = function(xform, colls) {
  var iters = [];
  var seq__47023_47027 = cljs.core.seq(colls);
  var chunk__47024_47028 = null;
  var count__47025_47029 = 0;
  var i__47026_47030 = 0;
  while (true) {
    if (i__47026_47030 < count__47025_47029) {
      var coll_47031 = chunk__47024_47028.cljs$core$IIndexed$_nth$arity$2(null, i__47026_47030);
      iters.push(cljs.core.iter(coll_47031));
      var G__47032 = seq__47023_47027;
      var G__47033 = chunk__47024_47028;
      var G__47034 = count__47025_47029;
      var G__47035 = i__47026_47030 + 1;
      seq__47023_47027 = G__47032;
      chunk__47024_47028 = G__47033;
      count__47025_47029 = G__47034;
      i__47026_47030 = G__47035;
      continue;
    } else {
      var temp__6738__auto___47036 = cljs.core.seq(seq__47023_47027);
      if (temp__6738__auto___47036) {
        var seq__47023_47037__$1 = temp__6738__auto___47036;
        if (cljs.core.chunked_seq_QMARK_(seq__47023_47037__$1)) {
          var c__10065__auto___47038 = cljs.core.chunk_first(seq__47023_47037__$1);
          var G__47039 = cljs.core.chunk_rest(seq__47023_47037__$1);
          var G__47040 = c__10065__auto___47038;
          var G__47041 = cljs.core.count(c__10065__auto___47038);
          var G__47042 = 0;
          seq__47023_47027 = G__47039;
          chunk__47024_47028 = G__47040;
          count__47025_47029 = G__47041;
          i__47026_47030 = G__47042;
          continue;
        } else {
          var coll_47043 = cljs.core.first(seq__47023_47037__$1);
          iters.push(cljs.core.iter(coll_47043));
          var G__47044 = cljs.core.next(seq__47023_47037__$1);
          var G__47045 = null;
          var G__47046 = 0;
          var G__47047 = 0;
          seq__47023_47027 = G__47044;
          chunk__47024_47028 = G__47045;
          count__47025_47029 = G__47046;
          i__47026_47030 = G__47047;
          continue;
        }
      } else {
      }
    }
    break;
  }
  return new cljs.core.LazyTransformer(cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform, iters, new Array(iters.length)), null, null, null);
};
cljs.core.sequence = function cljs$core$sequence(var_args) {
  var args47048 = [];
  var len__10375__auto___47054 = arguments.length;
  var i__10376__auto___47055 = 0;
  while (true) {
    if (i__10376__auto___47055 < len__10375__auto___47054) {
      args47048.push(arguments[i__10376__auto___47055]);
      var G__47056 = i__10376__auto___47055 + 1;
      i__10376__auto___47055 = G__47056;
      continue;
    } else {
    }
    break;
  }
  var G__47053 = args47048.length;
  switch(G__47053) {
    case 1:
      return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args47048.slice(2), 0, null);
      return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10398__auto__);
  }
};
cljs.core.sequence.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  if (cljs.core.seq_QMARK_(coll)) {
    return coll;
  } else {
    var or__9154__auto__ = cljs.core.seq(coll);
    if (or__9154__auto__) {
      return or__9154__auto__;
    } else {
      return cljs.core.List.EMPTY;
    }
  }
};
cljs.core.sequence.cljs$core$IFn$_invoke$arity$2 = function(xform, coll) {
  return cljs.core.LazyTransformer.create(xform, coll);
};
cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic = function(xform, coll, colls) {
  return cljs.core.LazyTransformer.createMulti(xform, cljs.core.to_array(cljs.core.cons(coll, colls)));
};
cljs.core.sequence.cljs$lang$applyTo = function(seq47049) {
  var G__47050 = cljs.core.first(seq47049);
  var seq47049__$1 = cljs.core.next(seq47049);
  var G__47051 = cljs.core.first(seq47049__$1);
  var seq47049__$2 = cljs.core.next(seq47049__$1);
  return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic(G__47050, G__47051, seq47049__$2);
};
cljs.core.sequence.cljs$lang$maxFixedArity = 2;
cljs.core.every_QMARK_ = function cljs$core$every_QMARK_(pred, coll) {
  while (true) {
    if (cljs.core.seq(coll) == null) {
      return true;
    } else {
      if (cljs.core.truth_(function() {
        var G__47059 = cljs.core.first(coll);
        return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__47059) : pred.call(null, G__47059);
      }())) {
        var G__47060 = pred;
        var G__47061 = cljs.core.next(coll);
        pred = G__47060;
        coll = G__47061;
        continue;
      } else {
        return false;
      }
    }
    break;
  }
};
cljs.core.not_every_QMARK_ = function cljs$core$not_every_QMARK_(pred, coll) {
  return !cljs.core.every_QMARK_(pred, coll);
};
cljs.core.some = function cljs$core$some(pred, coll) {
  while (true) {
    if (cljs.core.seq(coll)) {
      var or__9154__auto__ = function() {
        var G__47065 = cljs.core.first(coll);
        return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__47065) : pred.call(null, G__47065);
      }();
      if (cljs.core.truth_(or__9154__auto__)) {
        return or__9154__auto__;
      } else {
        var G__47066 = pred;
        var G__47067 = cljs.core.next(coll);
        pred = G__47066;
        coll = G__47067;
        continue;
      }
    } else {
      return null;
    }
    break;
  }
};
cljs.core.not_any_QMARK_ = function cljs$core$not_any_QMARK_(pred, coll) {
  return cljs.core.not(cljs.core.some(pred, coll));
};
cljs.core.even_QMARK_ = function cljs$core$even_QMARK_(n) {
  if (cljs.core.integer_QMARK_(n)) {
    return (n & 1) === 0;
  } else {
    throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Argument must be an integer: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)].join(""));
  }
};
cljs.core.odd_QMARK_ = function cljs$core$odd_QMARK_(n) {
  return !cljs.core.even_QMARK_(n);
};
cljs.core.complement = function cljs$core$complement(f) {
  return function() {
    var G__47068 = null;
    var G__47068__0 = function() {
      return cljs.core.not(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
    };
    var G__47068__1 = function(x) {
      return cljs.core.not(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null, x));
    };
    var G__47068__2 = function(x, y) {
      return cljs.core.not(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x, y) : f.call(null, x, y));
    };
    var G__47068__3 = function() {
      var G__47069__delegate = function(x, y, zs) {
        return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f, x, y, zs));
      };
      var G__47069 = function(x, y, var_args) {
        var zs = null;
        if (arguments.length > 2) {
          var G__47070__i = 0, G__47070__a = new Array(arguments.length - 2);
          while (G__47070__i < G__47070__a.length) {
            G__47070__a[G__47070__i] = arguments[G__47070__i + 2];
            ++G__47070__i;
          }
          zs = new cljs.core.IndexedSeq(G__47070__a, 0, null);
        }
        return G__47069__delegate.call(this, x, y, zs);
      };
      G__47069.cljs$lang$maxFixedArity = 2;
      G__47069.cljs$lang$applyTo = function(arglist__47071) {
        var x = cljs.core.first(arglist__47071);
        arglist__47071 = cljs.core.next(arglist__47071);
        var y = cljs.core.first(arglist__47071);
        var zs = cljs.core.rest(arglist__47071);
        return G__47069__delegate(x, y, zs);
      };
      G__47069.cljs$core$IFn$_invoke$arity$variadic = G__47069__delegate;
      return G__47069;
    }();
    G__47068 = function(x, y, var_args) {
      var zs = var_args;
      switch(arguments.length) {
        case 0:
          return G__47068__0.call(this);
        case 1:
          return G__47068__1.call(this, x);
        case 2:
          return G__47068__2.call(this, x, y);
        default:
          var G__47072 = null;
          if (arguments.length > 2) {
            var G__47073__i = 0, G__47073__a = new Array(arguments.length - 2);
            while (G__47073__i < G__47073__a.length) {
              G__47073__a[G__47073__i] = arguments[G__47073__i + 2];
              ++G__47073__i;
            }
            G__47072 = new cljs.core.IndexedSeq(G__47073__a, 0, null);
          }
          return G__47068__3.cljs$core$IFn$_invoke$arity$variadic(x, y, G__47072);
      }
      throw new Error("Invalid arity: " + (arguments.length - 1));
    };
    G__47068.cljs$lang$maxFixedArity = 2;
    G__47068.cljs$lang$applyTo = G__47068__3.cljs$lang$applyTo;
    G__47068.cljs$core$IFn$_invoke$arity$0 = G__47068__0;
    G__47068.cljs$core$IFn$_invoke$arity$1 = G__47068__1;
    G__47068.cljs$core$IFn$_invoke$arity$2 = G__47068__2;
    G__47068.cljs$core$IFn$_invoke$arity$variadic = G__47068__3.cljs$core$IFn$_invoke$arity$variadic;
    return G__47068;
  }();
};
cljs.core.constantly = function cljs$core$constantly(x) {
  return function() {
    var G__47074__delegate = function(args) {
      return x;
    };
    var G__47074 = function(var_args) {
      var args = null;
      if (arguments.length > 0) {
        var G__47075__i = 0, G__47075__a = new Array(arguments.length - 0);
        while (G__47075__i < G__47075__a.length) {
          G__47075__a[G__47075__i] = arguments[G__47075__i + 0];
          ++G__47075__i;
        }
        args = new cljs.core.IndexedSeq(G__47075__a, 0, null);
      }
      return G__47074__delegate.call(this, args);
    };
    G__47074.cljs$lang$maxFixedArity = 0;
    G__47074.cljs$lang$applyTo = function(arglist__47076) {
      var args = cljs.core.seq(arglist__47076);
      return G__47074__delegate(args);
    };
    G__47074.cljs$core$IFn$_invoke$arity$variadic = G__47074__delegate;
    return G__47074;
  }();
};
cljs.core.comp = function cljs$core$comp(var_args) {
  var args47077 = [];
  var len__10375__auto___47099 = arguments.length;
  var i__10376__auto___47100 = 0;
  while (true) {
    if (i__10376__auto___47100 < len__10375__auto___47099) {
      args47077.push(arguments[i__10376__auto___47100]);
      var G__47101 = i__10376__auto___47100 + 1;
      i__10376__auto___47100 = G__47101;
      continue;
    } else {
    }
    break;
  }
  var G__47083 = args47077.length;
  switch(G__47083) {
    case 0:
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args47077.slice(3), 0, null);
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__10398__auto__);
  }
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.identity;
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return f;
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$2 = function(f, g) {
  return function() {
    var G__47103 = null;
    var G__47103__0 = function() {
      var G__47084 = g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null);
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__47084) : f.call(null, G__47084);
    };
    var G__47103__1 = function(x) {
      var G__47085 = g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(x) : g.call(null, x);
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__47085) : f.call(null, G__47085);
    };
    var G__47103__2 = function(x, y) {
      var G__47086 = g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(x, y) : g.call(null, x, y);
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__47086) : f.call(null, G__47086);
    };
    var G__47103__3 = function(x, y, z) {
      var G__47087 = g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(x, y, z) : g.call(null, x, y, z);
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__47087) : f.call(null, G__47087);
    };
    var G__47103__4 = function() {
      var G__47104__delegate = function(x, y, z, args) {
        var G__47088 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g, x, y, z, args);
        return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__47088) : f.call(null, G__47088);
      };
      var G__47104 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__47105__i = 0, G__47105__a = new Array(arguments.length - 3);
          while (G__47105__i < G__47105__a.length) {
            G__47105__a[G__47105__i] = arguments[G__47105__i + 3];
            ++G__47105__i;
          }
          args = new cljs.core.IndexedSeq(G__47105__a, 0, null);
        }
        return G__47104__delegate.call(this, x, y, z, args);
      };
      G__47104.cljs$lang$maxFixedArity = 3;
      G__47104.cljs$lang$applyTo = function(arglist__47106) {
        var x = cljs.core.first(arglist__47106);
        arglist__47106 = cljs.core.next(arglist__47106);
        var y = cljs.core.first(arglist__47106);
        arglist__47106 = cljs.core.next(arglist__47106);
        var z = cljs.core.first(arglist__47106);
        var args = cljs.core.rest(arglist__47106);
        return G__47104__delegate(x, y, z, args);
      };
      G__47104.cljs$core$IFn$_invoke$arity$variadic = G__47104__delegate;
      return G__47104;
    }();
    G__47103 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__47103__0.call(this);
        case 1:
          return G__47103__1.call(this, x);
        case 2:
          return G__47103__2.call(this, x, y);
        case 3:
          return G__47103__3.call(this, x, y, z);
        default:
          var G__47107 = null;
          if (arguments.length > 3) {
            var G__47108__i = 0, G__47108__a = new Array(arguments.length - 3);
            while (G__47108__i < G__47108__a.length) {
              G__47108__a[G__47108__i] = arguments[G__47108__i + 3];
              ++G__47108__i;
            }
            G__47107 = new cljs.core.IndexedSeq(G__47108__a, 0, null);
          }
          return G__47103__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__47107);
      }
      throw new Error("Invalid arity: " + (arguments.length - 1));
    };
    G__47103.cljs$lang$maxFixedArity = 3;
    G__47103.cljs$lang$applyTo = G__47103__4.cljs$lang$applyTo;
    G__47103.cljs$core$IFn$_invoke$arity$0 = G__47103__0;
    G__47103.cljs$core$IFn$_invoke$arity$1 = G__47103__1;
    G__47103.cljs$core$IFn$_invoke$arity$2 = G__47103__2;
    G__47103.cljs$core$IFn$_invoke$arity$3 = G__47103__3;
    G__47103.cljs$core$IFn$_invoke$arity$variadic = G__47103__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__47103;
  }();
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$3 = function(f, g, h) {
  return function() {
    var G__47109 = null;
    var G__47109__0 = function() {
      var G__47089 = function() {
        var G__47090 = h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null);
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__47090) : g.call(null, G__47090);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__47089) : f.call(null, G__47089);
    };
    var G__47109__1 = function(x) {
      var G__47091 = function() {
        var G__47092 = h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(x) : h.call(null, x);
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__47092) : g.call(null, G__47092);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__47091) : f.call(null, G__47091);
    };
    var G__47109__2 = function(x, y) {
      var G__47093 = function() {
        var G__47094 = h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(x, y) : h.call(null, x, y);
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__47094) : g.call(null, G__47094);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__47093) : f.call(null, G__47093);
    };
    var G__47109__3 = function(x, y, z) {
      var G__47095 = function() {
        var G__47096 = h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(x, y, z) : h.call(null, x, y, z);
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__47096) : g.call(null, G__47096);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__47095) : f.call(null, G__47095);
    };
    var G__47109__4 = function() {
      var G__47110__delegate = function(x, y, z, args) {
        var G__47097 = function() {
          var G__47098 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h, x, y, z, args);
          return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__47098) : g.call(null, G__47098);
        }();
        return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__47097) : f.call(null, G__47097);
      };
      var G__47110 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__47111__i = 0, G__47111__a = new Array(arguments.length - 3);
          while (G__47111__i < G__47111__a.length) {
            G__47111__a[G__47111__i] = arguments[G__47111__i + 3];
            ++G__47111__i;
          }
          args = new cljs.core.IndexedSeq(G__47111__a, 0, null);
        }
        return G__47110__delegate.call(this, x, y, z, args);
      };
      G__47110.cljs$lang$maxFixedArity = 3;
      G__47110.cljs$lang$applyTo = function(arglist__47112) {
        var x = cljs.core.first(arglist__47112);
        arglist__47112 = cljs.core.next(arglist__47112);
        var y = cljs.core.first(arglist__47112);
        arglist__47112 = cljs.core.next(arglist__47112);
        var z = cljs.core.first(arglist__47112);
        var args = cljs.core.rest(arglist__47112);
        return G__47110__delegate(x, y, z, args);
      };
      G__47110.cljs$core$IFn$_invoke$arity$variadic = G__47110__delegate;
      return G__47110;
    }();
    G__47109 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__47109__0.call(this);
        case 1:
          return G__47109__1.call(this, x);
        case 2:
          return G__47109__2.call(this, x, y);
        case 3:
          return G__47109__3.call(this, x, y, z);
        default:
          var G__47113 = null;
          if (arguments.length > 3) {
            var G__47114__i = 0, G__47114__a = new Array(arguments.length - 3);
            while (G__47114__i < G__47114__a.length) {
              G__47114__a[G__47114__i] = arguments[G__47114__i + 3];
              ++G__47114__i;
            }
            G__47113 = new cljs.core.IndexedSeq(G__47114__a, 0, null);
          }
          return G__47109__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__47113);
      }
      throw new Error("Invalid arity: " + (arguments.length - 1));
    };
    G__47109.cljs$lang$maxFixedArity = 3;
    G__47109.cljs$lang$applyTo = G__47109__4.cljs$lang$applyTo;
    G__47109.cljs$core$IFn$_invoke$arity$0 = G__47109__0;
    G__47109.cljs$core$IFn$_invoke$arity$1 = G__47109__1;
    G__47109.cljs$core$IFn$_invoke$arity$2 = G__47109__2;
    G__47109.cljs$core$IFn$_invoke$arity$3 = G__47109__3;
    G__47109.cljs$core$IFn$_invoke$arity$variadic = G__47109__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__47109;
  }();
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic = function(f1, f2, f3, fs) {
  var fs__$1 = cljs.core.reverse(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f1, f2, f3, fs));
  return function(fs__$1) {
    return function() {
      var G__47115__delegate = function(args) {
        var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.first(fs__$1), args);
        var fs__$2 = cljs.core.next(fs__$1);
        while (true) {
          if (fs__$2) {
            var G__47116 = cljs.core.first(fs__$2).call(null, ret);
            var G__47117 = cljs.core.next(fs__$2);
            ret = G__47116;
            fs__$2 = G__47117;
            continue;
          } else {
            return ret;
          }
          break;
        }
      };
      var G__47115 = function(var_args) {
        var args = null;
        if (arguments.length > 0) {
          var G__47118__i = 0, G__47118__a = new Array(arguments.length - 0);
          while (G__47118__i < G__47118__a.length) {
            G__47118__a[G__47118__i] = arguments[G__47118__i + 0];
            ++G__47118__i;
          }
          args = new cljs.core.IndexedSeq(G__47118__a, 0, null);
        }
        return G__47115__delegate.call(this, args);
      };
      G__47115.cljs$lang$maxFixedArity = 0;
      G__47115.cljs$lang$applyTo = function(arglist__47119) {
        var args = cljs.core.seq(arglist__47119);
        return G__47115__delegate(args);
      };
      G__47115.cljs$core$IFn$_invoke$arity$variadic = G__47115__delegate;
      return G__47115;
    }();
  }(fs__$1);
};
cljs.core.comp.cljs$lang$applyTo = function(seq47078) {
  var G__47079 = cljs.core.first(seq47078);
  var seq47078__$1 = cljs.core.next(seq47078);
  var G__47080 = cljs.core.first(seq47078__$1);
  var seq47078__$2 = cljs.core.next(seq47078__$1);
  var G__47081 = cljs.core.first(seq47078__$2);
  var seq47078__$3 = cljs.core.next(seq47078__$2);
  return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic(G__47079, G__47080, G__47081, seq47078__$3);
};
cljs.core.comp.cljs$lang$maxFixedArity = 3;
cljs.core.partial = function cljs$core$partial(var_args) {
  var args47120 = [];
  var len__10375__auto___47128 = arguments.length;
  var i__10376__auto___47129 = 0;
  while (true) {
    if (i__10376__auto___47129 < len__10375__auto___47128) {
      args47120.push(arguments[i__10376__auto___47129]);
      var G__47130 = i__10376__auto___47129 + 1;
      i__10376__auto___47129 = G__47130;
      continue;
    } else {
    }
    break;
  }
  var G__47127 = args47120.length;
  switch(G__47127) {
    case 1:
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args47120.slice(4), 0, null);
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__10398__auto__);
  }
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return f;
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$2 = function(f, arg1) {
  return function() {
    var G__47132 = null;
    var G__47132__0 = function() {
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(arg1) : f.call(null, arg1);
    };
    var G__47132__1 = function(x) {
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1, x) : f.call(null, arg1, x);
    };
    var G__47132__2 = function(x, y) {
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1, x, y) : f.call(null, arg1, x, y);
    };
    var G__47132__3 = function(x, y, z) {
      return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1, x, y, z) : f.call(null, arg1, x, y, z);
    };
    var G__47132__4 = function() {
      var G__47133__delegate = function(x, y, z, args) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, arg1, x, y, z, cljs.core.array_seq([args], 0));
      };
      var G__47133 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__47134__i = 0, G__47134__a = new Array(arguments.length - 3);
          while (G__47134__i < G__47134__a.length) {
            G__47134__a[G__47134__i] = arguments[G__47134__i + 3];
            ++G__47134__i;
          }
          args = new cljs.core.IndexedSeq(G__47134__a, 0, null);
        }
        return G__47133__delegate.call(this, x, y, z, args);
      };
      G__47133.cljs$lang$maxFixedArity = 3;
      G__47133.cljs$lang$applyTo = function(arglist__47135) {
        var x = cljs.core.first(arglist__47135);
        arglist__47135 = cljs.core.next(arglist__47135);
        var y = cljs.core.first(arglist__47135);
        arglist__47135 = cljs.core.next(arglist__47135);
        var z = cljs.core.first(arglist__47135);
        var args = cljs.core.rest(arglist__47135);
        return G__47133__delegate(x, y, z, args);
      };
      G__47133.cljs$core$IFn$_invoke$arity$variadic = G__47133__delegate;
      return G__47133;
    }();
    G__47132 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__47132__0.call(this);
        case 1:
          return G__47132__1.call(this, x);
        case 2:
          return G__47132__2.call(this, x, y);
        case 3:
          return G__47132__3.call(this, x, y, z);
        default:
          var G__47136 = null;
          if (arguments.length > 3) {
            var G__47137__i = 0, G__47137__a = new Array(arguments.length - 3);
            while (G__47137__i < G__47137__a.length) {
              G__47137__a[G__47137__i] = arguments[G__47137__i + 3];
              ++G__47137__i;
            }
            G__47136 = new cljs.core.IndexedSeq(G__47137__a, 0, null);
          }
          return G__47132__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__47136);
      }
      throw new Error("Invalid arity: " + (arguments.length - 1));
    };
    G__47132.cljs$lang$maxFixedArity = 3;
    G__47132.cljs$lang$applyTo = G__47132__4.cljs$lang$applyTo;
    G__47132.cljs$core$IFn$_invoke$arity$0 = G__47132__0;
    G__47132.cljs$core$IFn$_invoke$arity$1 = G__47132__1;
    G__47132.cljs$core$IFn$_invoke$arity$2 = G__47132__2;
    G__47132.cljs$core$IFn$_invoke$arity$3 = G__47132__3;
    G__47132.cljs$core$IFn$_invoke$arity$variadic = G__47132__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__47132;
  }();
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$3 = function(f, arg1, arg2) {
  return function() {
    var G__47138 = null;
    var G__47138__0 = function() {
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1, arg2) : f.call(null, arg1, arg2);
    };
    var G__47138__1 = function(x) {
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1, arg2, x) : f.call(null, arg1, arg2, x);
    };
    var G__47138__2 = function(x, y) {
      return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1, arg2, x, y) : f.call(null, arg1, arg2, x, y);
    };
    var G__47138__3 = function(x, y, z) {
      return f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1, arg2, x, y, z) : f.call(null, arg1, arg2, x, y, z);
    };
    var G__47138__4 = function() {
      var G__47139__delegate = function(x, y, z, args) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, arg1, arg2, x, y, cljs.core.array_seq([z, args], 0));
      };
      var G__47139 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__47140__i = 0, G__47140__a = new Array(arguments.length - 3);
          while (G__47140__i < G__47140__a.length) {
            G__47140__a[G__47140__i] = arguments[G__47140__i + 3];
            ++G__47140__i;
          }
          args = new cljs.core.IndexedSeq(G__47140__a, 0, null);
        }
        return G__47139__delegate.call(this, x, y, z, args);
      };
      G__47139.cljs$lang$maxFixedArity = 3;
      G__47139.cljs$lang$applyTo = function(arglist__47141) {
        var x = cljs.core.first(arglist__47141);
        arglist__47141 = cljs.core.next(arglist__47141);
        var y = cljs.core.first(arglist__47141);
        arglist__47141 = cljs.core.next(arglist__47141);
        var z = cljs.core.first(arglist__47141);
        var args = cljs.core.rest(arglist__47141);
        return G__47139__delegate(x, y, z, args);
      };
      G__47139.cljs$core$IFn$_invoke$arity$variadic = G__47139__delegate;
      return G__47139;
    }();
    G__47138 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__47138__0.call(this);
        case 1:
          return G__47138__1.call(this, x);
        case 2:
          return G__47138__2.call(this, x, y);
        case 3:
          return G__47138__3.call(this, x, y, z);
        default:
          var G__47142 = null;
          if (arguments.length > 3) {
            var G__47143__i = 0, G__47143__a = new Array(arguments.length - 3);
            while (G__47143__i < G__47143__a.length) {
              G__47143__a[G__47143__i] = arguments[G__47143__i + 3];
              ++G__47143__i;
            }
            G__47142 = new cljs.core.IndexedSeq(G__47143__a, 0, null);
          }
          return G__47138__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__47142);
      }
      throw new Error("Invalid arity: " + (arguments.length - 1));
    };
    G__47138.cljs$lang$maxFixedArity = 3;
    G__47138.cljs$lang$applyTo = G__47138__4.cljs$lang$applyTo;
    G__47138.cljs$core$IFn$_invoke$arity$0 = G__47138__0;
    G__47138.cljs$core$IFn$_invoke$arity$1 = G__47138__1;
    G__47138.cljs$core$IFn$_invoke$arity$2 = G__47138__2;
    G__47138.cljs$core$IFn$_invoke$arity$3 = G__47138__3;
    G__47138.cljs$core$IFn$_invoke$arity$variadic = G__47138__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__47138;
  }();
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$4 = function(f, arg1, arg2, arg3) {
  return function() {
    var G__47144 = null;
    var G__47144__0 = function() {
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1, arg2, arg3) : f.call(null, arg1, arg2, arg3);
    };
    var G__47144__1 = function(x) {
      return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1, arg2, arg3, x) : f.call(null, arg1, arg2, arg3, x);
    };
    var G__47144__2 = function(x, y) {
      return f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1, arg2, arg3, x, y) : f.call(null, arg1, arg2, arg3, x, y);
    };
    var G__47144__3 = function(x, y, z) {
      return f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(arg1, arg2, arg3, x, y, z) : f.call(null, arg1, arg2, arg3, x, y, z);
    };
    var G__47144__4 = function() {
      var G__47145__delegate = function(x, y, z, args) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, arg1, arg2, arg3, x, cljs.core.array_seq([y, z, args], 0));
      };
      var G__47145 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__47146__i = 0, G__47146__a = new Array(arguments.length - 3);
          while (G__47146__i < G__47146__a.length) {
            G__47146__a[G__47146__i] = arguments[G__47146__i + 3];
            ++G__47146__i;
          }
          args = new cljs.core.IndexedSeq(G__47146__a, 0, null);
        }
        return G__47145__delegate.call(this, x, y, z, args);
      };
      G__47145.cljs$lang$maxFixedArity = 3;
      G__47145.cljs$lang$applyTo = function(arglist__47147) {
        var x = cljs.core.first(arglist__47147);
        arglist__47147 = cljs.core.next(arglist__47147);
        var y = cljs.core.first(arglist__47147);
        arglist__47147 = cljs.core.next(arglist__47147);
        var z = cljs.core.first(arglist__47147);
        var args = cljs.core.rest(arglist__47147);
        return G__47145__delegate(x, y, z, args);
      };
      G__47145.cljs$core$IFn$_invoke$arity$variadic = G__47145__delegate;
      return G__47145;
    }();
    G__47144 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__47144__0.call(this);
        case 1:
          return G__47144__1.call(this, x);
        case 2:
          return G__47144__2.call(this, x, y);
        case 3:
          return G__47144__3.call(this, x, y, z);
        default:
          var G__47148 = null;
          if (arguments.length > 3) {
            var G__47149__i = 0, G__47149__a = new Array(arguments.length - 3);
            while (G__47149__i < G__47149__a.length) {
              G__47149__a[G__47149__i] = arguments[G__47149__i + 3];
              ++G__47149__i;
            }
            G__47148 = new cljs.core.IndexedSeq(G__47149__a, 0, null);
          }
          return G__47144__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__47148);
      }
      throw new Error("Invalid arity: " + (arguments.length - 1));
    };
    G__47144.cljs$lang$maxFixedArity = 3;
    G__47144.cljs$lang$applyTo = G__47144__4.cljs$lang$applyTo;
    G__47144.cljs$core$IFn$_invoke$arity$0 = G__47144__0;
    G__47144.cljs$core$IFn$_invoke$arity$1 = G__47144__1;
    G__47144.cljs$core$IFn$_invoke$arity$2 = G__47144__2;
    G__47144.cljs$core$IFn$_invoke$arity$3 = G__47144__3;
    G__47144.cljs$core$IFn$_invoke$arity$variadic = G__47144__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__47144;
  }();
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic = function(f, arg1, arg2, arg3, more) {
  return function() {
    var G__47150__delegate = function(args) {
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, arg1, arg2, arg3, cljs.core.concat.cljs$core$IFn$_invoke$arity$2(more, args));
    };
    var G__47150 = function(var_args) {
      var args = null;
      if (arguments.length > 0) {
        var G__47151__i = 0, G__47151__a = new Array(arguments.length - 0);
        while (G__47151__i < G__47151__a.length) {
          G__47151__a[G__47151__i] = arguments[G__47151__i + 0];
          ++G__47151__i;
        }
        args = new cljs.core.IndexedSeq(G__47151__a, 0, null);
      }
      return G__47150__delegate.call(this, args);
    };
    G__47150.cljs$lang$maxFixedArity = 0;
    G__47150.cljs$lang$applyTo = function(arglist__47152) {
      var args = cljs.core.seq(arglist__47152);
      return G__47150__delegate(args);
    };
    G__47150.cljs$core$IFn$_invoke$arity$variadic = G__47150__delegate;
    return G__47150;
  }();
};
cljs.core.partial.cljs$lang$applyTo = function(seq47121) {
  var G__47122 = cljs.core.first(seq47121);
  var seq47121__$1 = cljs.core.next(seq47121);
  var G__47123 = cljs.core.first(seq47121__$1);
  var seq47121__$2 = cljs.core.next(seq47121__$1);
  var G__47124 = cljs.core.first(seq47121__$2);
  var seq47121__$3 = cljs.core.next(seq47121__$2);
  var G__47125 = cljs.core.first(seq47121__$3);
  var seq47121__$4 = cljs.core.next(seq47121__$3);
  return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic(G__47122, G__47123, G__47124, G__47125, seq47121__$4);
};
cljs.core.partial.cljs$lang$maxFixedArity = 4;
cljs.core.fnil = function cljs$core$fnil(var_args) {
  var args47153 = [];
  var len__10375__auto___47172 = arguments.length;
  var i__10376__auto___47173 = 0;
  while (true) {
    if (i__10376__auto___47173 < len__10375__auto___47172) {
      args47153.push(arguments[i__10376__auto___47173]);
      var G__47174 = i__10376__auto___47173 + 1;
      i__10376__auto___47173 = G__47174;
      continue;
    } else {
    }
    break;
  }
  var G__47155 = args47153.length;
  switch(G__47155) {
    case 2:
      return cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.fnil.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.fnil.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args47153.length)].join(""));
  }
};
cljs.core.fnil.cljs$core$IFn$_invoke$arity$2 = function(f, x) {
  return function() {
    var G__47176 = null;
    var G__47176__1 = function(a) {
      var G__47156 = a == null ? x : a;
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__47156) : f.call(null, G__47156);
    };
    var G__47176__2 = function(a, b) {
      var G__47157 = a == null ? x : a;
      var G__47158 = b;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__47157, G__47158) : f.call(null, G__47157, G__47158);
    };
    var G__47176__3 = function(a, b, c) {
      var G__47159 = a == null ? x : a;
      var G__47160 = b;
      var G__47161 = c;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__47159, G__47160, G__47161) : f.call(null, G__47159, G__47160, G__47161);
    };
    var G__47176__4 = function() {
      var G__47177__delegate = function(a, b, c, ds) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a == null ? x : a, b, c, ds);
      };
      var G__47177 = function(a, b, c, var_args) {
        var ds = null;
        if (arguments.length > 3) {
          var G__47178__i = 0, G__47178__a = new Array(arguments.length - 3);
          while (G__47178__i < G__47178__a.length) {
            G__47178__a[G__47178__i] = arguments[G__47178__i + 3];
            ++G__47178__i;
          }
          ds = new cljs.core.IndexedSeq(G__47178__a, 0, null);
        }
        return G__47177__delegate.call(this, a, b, c, ds);
      };
      G__47177.cljs$lang$maxFixedArity = 3;
      G__47177.cljs$lang$applyTo = function(arglist__47179) {
        var a = cljs.core.first(arglist__47179);
        arglist__47179 = cljs.core.next(arglist__47179);
        var b = cljs.core.first(arglist__47179);
        arglist__47179 = cljs.core.next(arglist__47179);
        var c = cljs.core.first(arglist__47179);
        var ds = cljs.core.rest(arglist__47179);
        return G__47177__delegate(a, b, c, ds);
      };
      G__47177.cljs$core$IFn$_invoke$arity$variadic = G__47177__delegate;
      return G__47177;
    }();
    G__47176 = function(a, b, c, var_args) {
      var ds = var_args;
      switch(arguments.length) {
        case 1:
          return G__47176__1.call(this, a);
        case 2:
          return G__47176__2.call(this, a, b);
        case 3:
          return G__47176__3.call(this, a, b, c);
        default:
          var G__47180 = null;
          if (arguments.length > 3) {
            var G__47181__i = 0, G__47181__a = new Array(arguments.length - 3);
            while (G__47181__i < G__47181__a.length) {
              G__47181__a[G__47181__i] = arguments[G__47181__i + 3];
              ++G__47181__i;
            }
            G__47180 = new cljs.core.IndexedSeq(G__47181__a, 0, null);
          }
          return G__47176__4.cljs$core$IFn$_invoke$arity$variadic(a, b, c, G__47180);
      }
      throw new Error("Invalid arity: " + (arguments.length - 1));
    };
    G__47176.cljs$lang$maxFixedArity = 3;
    G__47176.cljs$lang$applyTo = G__47176__4.cljs$lang$applyTo;
    G__47176.cljs$core$IFn$_invoke$arity$1 = G__47176__1;
    G__47176.cljs$core$IFn$_invoke$arity$2 = G__47176__2;
    G__47176.cljs$core$IFn$_invoke$arity$3 = G__47176__3;
    G__47176.cljs$core$IFn$_invoke$arity$variadic = G__47176__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__47176;
  }();
};
cljs.core.fnil.cljs$core$IFn$_invoke$arity$3 = function(f, x, y) {
  return function() {
    var G__47182 = null;
    var G__47182__2 = function(a, b) {
      var G__47162 = a == null ? x : a;
      var G__47163 = b == null ? y : b;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__47162, G__47163) : f.call(null, G__47162, G__47163);
    };
    var G__47182__3 = function(a, b, c) {
      var G__47164 = a == null ? x : a;
      var G__47165 = b == null ? y : b;
      var G__47166 = c;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__47164, G__47165, G__47166) : f.call(null, G__47164, G__47165, G__47166);
    };
    var G__47182__4 = function() {
      var G__47183__delegate = function(a, b, c, ds) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a == null ? x : a, b == null ? y : b, c, ds);
      };
      var G__47183 = function(a, b, c, var_args) {
        var ds = null;
        if (arguments.length > 3) {
          var G__47184__i = 0, G__47184__a = new Array(arguments.length - 3);
          while (G__47184__i < G__47184__a.length) {
            G__47184__a[G__47184__i] = arguments[G__47184__i + 3];
            ++G__47184__i;
          }
          ds = new cljs.core.IndexedSeq(G__47184__a, 0, null);
        }
        return G__47183__delegate.call(this, a, b, c, ds);
      };
      G__47183.cljs$lang$maxFixedArity = 3;
      G__47183.cljs$lang$applyTo = function(arglist__47185) {
        var a = cljs.core.first(arglist__47185);
        arglist__47185 = cljs.core.next(arglist__47185);
        var b = cljs.core.first(arglist__47185);
        arglist__47185 = cljs.core.next(arglist__47185);
        var c = cljs.core.first(arglist__47185);
        var ds = cljs.core.rest(arglist__47185);
        return G__47183__delegate(a, b, c, ds);
      };
      G__47183.cljs$core$IFn$_invoke$arity$variadic = G__47183__delegate;
      return G__47183;
    }();
    G__47182 = function(a, b, c, var_args) {
      var ds = var_args;
      switch(arguments.length) {
        case 2:
          return G__47182__2.call(this, a, b);
        case 3:
          return G__47182__3.call(this, a, b, c);
        default:
          var G__47186 = null;
          if (arguments.length > 3) {
            var G__47187__i = 0, G__47187__a = new Array(arguments.length - 3);
            while (G__47187__i < G__47187__a.length) {
              G__47187__a[G__47187__i] = arguments[G__47187__i + 3];
              ++G__47187__i;
            }
            G__47186 = new cljs.core.IndexedSeq(G__47187__a, 0, null);
          }
          return G__47182__4.cljs$core$IFn$_invoke$arity$variadic(a, b, c, G__47186);
      }
      throw new Error("Invalid arity: " + (arguments.length - 1));
    };
    G__47182.cljs$lang$maxFixedArity = 3;
    G__47182.cljs$lang$applyTo = G__47182__4.cljs$lang$applyTo;
    G__47182.cljs$core$IFn$_invoke$arity$2 = G__47182__2;
    G__47182.cljs$core$IFn$_invoke$arity$3 = G__47182__3;
    G__47182.cljs$core$IFn$_invoke$arity$variadic = G__47182__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__47182;
  }();
};
cljs.core.fnil.cljs$core$IFn$_invoke$arity$4 = function(f, x, y, z) {
  return function() {
    var G__47188 = null;
    var G__47188__2 = function(a, b) {
      var G__47167 = a == null ? x : a;
      var G__47168 = b == null ? y : b;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__47167, G__47168) : f.call(null, G__47167, G__47168);
    };
    var G__47188__3 = function(a, b, c) {
      var G__47169 = a == null ? x : a;
      var G__47170 = b == null ? y : b;
      var G__47171 = c == null ? z : c;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__47169, G__47170, G__47171) : f.call(null, G__47169, G__47170, G__47171);
    };
    var G__47188__4 = function() {
      var G__47189__delegate = function(a, b, c, ds) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a == null ? x : a, b == null ? y : b, c == null ? z : c, ds);
      };
      var G__47189 = function(a, b, c, var_args) {
        var ds = null;
        if (arguments.length > 3) {
          var G__47190__i = 0, G__47190__a = new Array(arguments.length - 3);
          while (G__47190__i < G__47190__a.length) {
            G__47190__a[G__47190__i] = arguments[G__47190__i + 3];
            ++G__47190__i;
          }
          ds = new cljs.core.IndexedSeq(G__47190__a, 0, null);
        }
        return G__47189__delegate.call(this, a, b, c, ds);
      };
      G__47189.cljs$lang$maxFixedArity = 3;
      G__47189.cljs$lang$applyTo = function(arglist__47191) {
        var a = cljs.core.first(arglist__47191);
        arglist__47191 = cljs.core.next(arglist__47191);
        var b = cljs.core.first(arglist__47191);
        arglist__47191 = cljs.core.next(arglist__47191);
        var c = cljs.core.first(arglist__47191);
        var ds = cljs.core.rest(arglist__47191);
        return G__47189__delegate(a, b, c, ds);
      };
      G__47189.cljs$core$IFn$_invoke$arity$variadic = G__47189__delegate;
      return G__47189;
    }();
    G__47188 = function(a, b, c, var_args) {
      var ds = var_args;
      switch(arguments.length) {
        case 2:
          return G__47188__2.call(this, a, b);
        case 3:
          return G__47188__3.call(this, a, b, c);
        default:
          var G__47192 = null;
          if (arguments.length > 3) {
            var G__47193__i = 0, G__47193__a = new Array(arguments.length - 3);
            while (G__47193__i < G__47193__a.length) {
              G__47193__a[G__47193__i] = arguments[G__47193__i + 3];
              ++G__47193__i;
            }
            G__47192 = new cljs.core.IndexedSeq(G__47193__a, 0, null);
          }
          return G__47188__4.cljs$core$IFn$_invoke$arity$variadic(a, b, c, G__47192);
      }
      throw new Error("Invalid arity: " + (arguments.length - 1));
    };
    G__47188.cljs$lang$maxFixedArity = 3;
    G__47188.cljs$lang$applyTo = G__47188__4.cljs$lang$applyTo;
    G__47188.cljs$core$IFn$_invoke$arity$2 = G__47188__2;
    G__47188.cljs$core$IFn$_invoke$arity$3 = G__47188__3;
    G__47188.cljs$core$IFn$_invoke$arity$variadic = G__47188__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__47188;
  }();
};
cljs.core.fnil.cljs$lang$maxFixedArity = 4;
cljs.core.map_indexed = function cljs$core$map_indexed(var_args) {
  var args47194 = [];
  var len__10375__auto___47225 = arguments.length;
  var i__10376__auto___47226 = 0;
  while (true) {
    if (i__10376__auto___47226 < len__10375__auto___47225) {
      args47194.push(arguments[i__10376__auto___47226]);
      var G__47227 = i__10376__auto___47226 + 1;
      i__10376__auto___47226 = G__47227;
      continue;
    } else {
    }
    break;
  }
  var G__47196 = args47194.length;
  switch(G__47196) {
    case 1:
      return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args47194.length)].join(""));
  }
};
cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    var i = cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1 ? cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1(-1) : cljs.core.volatile_BANG_.call(null, -1);
    return function(i) {
      return function() {
        var G__47229 = null;
        var G__47229__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__47229__1 = function(result) {
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
        };
        var G__47229__2 = function(result, input) {
          var G__47197 = result;
          var G__47198 = function() {
            var G__47199 = cljs.core._vreset_BANG_(i, cljs.core._deref(i) + 1);
            var G__47200 = input;
            return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__47199, G__47200) : f.call(null, G__47199, G__47200);
          }();
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__47197, G__47198) : rf.call(null, G__47197, G__47198);
        };
        G__47229 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__47229__0.call(this);
            case 1:
              return G__47229__1.call(this, result);
            case 2:
              return G__47229__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + (arguments.length - 1));
        };
        G__47229.cljs$core$IFn$_invoke$arity$0 = G__47229__0;
        G__47229.cljs$core$IFn$_invoke$arity$1 = G__47229__1;
        G__47229.cljs$core$IFn$_invoke$arity$2 = G__47229__2;
        return G__47229;
      }();
    }(i);
  };
};
cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  var mapi = function cljs$core$mapi(idx, coll__$1) {
    return new cljs.core.LazySeq(null, function() {
      var temp__6738__auto__ = cljs.core.seq(coll__$1);
      if (temp__6738__auto__) {
        var s = temp__6738__auto__;
        if (cljs.core.chunked_seq_QMARK_(s)) {
          var c = cljs.core.chunk_first(s);
          var size = cljs.core.count(c);
          var b = cljs.core.chunk_buffer(size);
          var n__10175__auto___47230 = size;
          var i_47231 = 0;
          while (true) {
            if (i_47231 < n__10175__auto___47230) {
              cljs.core.chunk_append(b, function() {
                var G__47221 = idx + i_47231;
                var G__47222 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_47231);
                return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__47221, G__47222) : f.call(null, G__47221, G__47222);
              }());
              var G__47232 = i_47231 + 1;
              i_47231 = G__47232;
              continue;
            } else {
            }
            break;
          }
          return cljs.core.chunk_cons(cljs.core.chunk(b), cljs$core$mapi(idx + size, cljs.core.chunk_rest(s)));
        } else {
          return cljs.core.cons(function() {
            var G__47223 = idx;
            var G__47224 = cljs.core.first(s);
            return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__47223, G__47224) : f.call(null, G__47223, G__47224);
          }(), cljs$core$mapi(idx + 1, cljs.core.rest(s)));
        }
      } else {
        return null;
      }
    }, null, null);
  };
  return mapi(0, coll);
};
cljs.core.map_indexed.cljs$lang$maxFixedArity = 2;
cljs.core.keep = function cljs$core$keep(var_args) {
  var args47233 = [];
  var len__10375__auto___47238 = arguments.length;
  var i__10376__auto___47239 = 0;
  while (true) {
    if (i__10376__auto___47239 < len__10375__auto___47238) {
      args47233.push(arguments[i__10376__auto___47239]);
      var G__47240 = i__10376__auto___47239 + 1;
      i__10376__auto___47239 = G__47240;
      continue;
    } else {
    }
    break;
  }
  var G__47235 = args47233.length;
  switch(G__47235) {
    case 1:
      return cljs.core.keep.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args47233.length)].join(""));
  }
};
cljs.core.keep.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    return function() {
      var G__47242 = null;
      var G__47242__0 = function() {
        return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
      };
      var G__47242__1 = function(result) {
        return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
      };
      var G__47242__2 = function(result, input) {
        var v = f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null, input);
        if (v == null) {
          return result;
        } else {
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, v) : rf.call(null, result, v);
        }
      };
      G__47242 = function(result, input) {
        switch(arguments.length) {
          case 0:
            return G__47242__0.call(this);
          case 1:
            return G__47242__1.call(this, result);
          case 2:
            return G__47242__2.call(this, result, input);
        }
        throw new Error("Invalid arity: " + (arguments.length - 1));
      };
      G__47242.cljs$core$IFn$_invoke$arity$0 = G__47242__0;
      G__47242.cljs$core$IFn$_invoke$arity$1 = G__47242__1;
      G__47242.cljs$core$IFn$_invoke$arity$2 = G__47242__2;
      return G__47242;
    }();
  };
};
cljs.core.keep.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__6738__auto__ = cljs.core.seq(coll);
    if (temp__6738__auto__) {
      var s = temp__6738__auto__;
      if (cljs.core.chunked_seq_QMARK_(s)) {
        var c = cljs.core.chunk_first(s);
        var size = cljs.core.count(c);
        var b = cljs.core.chunk_buffer(size);
        var n__10175__auto___47243 = size;
        var i_47244 = 0;
        while (true) {
          if (i_47244 < n__10175__auto___47243) {
            var x_47245 = function() {
              var G__47236 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_47244);
              return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__47236) : f.call(null, G__47236);
            }();
            if (x_47245 == null) {
            } else {
              cljs.core.chunk_append(b, x_47245);
            }
            var G__47246 = i_47244 + 1;
            i_47244 = G__47246;
            continue;
          } else {
          }
          break;
        }
        return cljs.core.chunk_cons(cljs.core.chunk(b), cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f, cljs.core.chunk_rest(s)));
      } else {
        var x = function() {
          var G__47237 = cljs.core.first(s);
          return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__47237) : f.call(null, G__47237);
        }();
        if (x == null) {
          return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f, cljs.core.rest(s));
        } else {
          return cljs.core.cons(x, cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f, cljs.core.rest(s)));
        }
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.keep.cljs$lang$maxFixedArity = 2;
cljs.core.Atom = function(state, meta, validator, watches) {
  this.state = state;
  this.meta = meta;
  this.validator = validator;
  this.watches = watches;
  this.cljs$lang$protocol_mask$partition1$ = 16386;
  this.cljs$lang$protocol_mask$partition0$ = 6455296;
};
cljs.core.Atom.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var self__ = this;
  var o__$1 = this;
  return o__$1 === other;
};
cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.state;
};
cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.meta;
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = function(this$, oldval, newval) {
  var self__ = this;
  var this$__$1 = this;
  var seq__47247 = cljs.core.seq(self__.watches);
  var chunk__47248 = null;
  var count__47249 = 0;
  var i__47250 = 0;
  while (true) {
    if (i__47250 < count__47249) {
      var vec__47251 = chunk__47248.cljs$core$IIndexed$_nth$arity$2(null, i__47250);
      var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47251, 0, null);
      var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47251, 1, null);
      f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key, this$__$1, oldval, newval) : f.call(null, key, this$__$1, oldval, newval);
      var G__47257 = seq__47247;
      var G__47258 = chunk__47248;
      var G__47259 = count__47249;
      var G__47260 = i__47250 + 1;
      seq__47247 = G__47257;
      chunk__47248 = G__47258;
      count__47249 = G__47259;
      i__47250 = G__47260;
      continue;
    } else {
      var temp__6738__auto__ = cljs.core.seq(seq__47247);
      if (temp__6738__auto__) {
        var seq__47247__$1 = temp__6738__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__47247__$1)) {
          var c__10065__auto__ = cljs.core.chunk_first(seq__47247__$1);
          var G__47261 = cljs.core.chunk_rest(seq__47247__$1);
          var G__47262 = c__10065__auto__;
          var G__47263 = cljs.core.count(c__10065__auto__);
          var G__47264 = 0;
          seq__47247 = G__47261;
          chunk__47248 = G__47262;
          count__47249 = G__47263;
          i__47250 = G__47264;
          continue;
        } else {
          var vec__47254 = cljs.core.first(seq__47247__$1);
          var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47254, 0, null);
          var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47254, 1, null);
          f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key, this$__$1, oldval, newval) : f.call(null, key, this$__$1, oldval, newval);
          var G__47265 = cljs.core.next(seq__47247__$1);
          var G__47266 = null;
          var G__47267 = 0;
          var G__47268 = 0;
          seq__47247 = G__47265;
          chunk__47248 = G__47266;
          count__47249 = G__47267;
          i__47250 = G__47268;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = function(this$, key, f) {
  var self__ = this;
  var this$__$1 = this;
  this$__$1.watches = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.watches, key, f);
  return this$__$1;
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = function(this$, key) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1.watches = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.watches, key);
};
cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return goog.getUid(this$__$1);
};
cljs.core.Atom.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "state", "state", -348086572, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "validator", "validator", -325659154, null), new cljs.core.Symbol(null, "watches", "watches", 1367433992, null)], null);
};
cljs.core.Atom.cljs$lang$type = true;
cljs.core.Atom.cljs$lang$ctorStr = "cljs.core/Atom";
cljs.core.Atom.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/Atom");
};
cljs.core.__GT_Atom = function cljs$core$__GT_Atom(state, meta, validator, watches) {
  return new cljs.core.Atom(state, meta, validator, watches);
};
cljs.core.atom = function cljs$core$atom(var_args) {
  var args47269 = [];
  var len__10375__auto___47277 = arguments.length;
  var i__10376__auto___47278 = 0;
  while (true) {
    if (i__10376__auto___47278 < len__10375__auto___47277) {
      args47269.push(arguments[i__10376__auto___47278]);
      var G__47279 = i__10376__auto___47278 + 1;
      i__10376__auto___47278 = G__47279;
      continue;
    } else {
    }
    break;
  }
  var G__47273 = args47269.length;
  switch(G__47273) {
    case 1:
      return cljs.core.atom.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args47269.slice(1), 0, null);
      return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__10398__auto__);
  }
};
cljs.core.atom.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return new cljs.core.Atom(x, null, null, null);
};
cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic = function(x, p__47274) {
  var map__47275 = p__47274;
  var map__47275__$1 = (!(map__47275 == null) ? map__47275.cljs$lang$protocol_mask$partition0$ & 64 || cljs.core.PROTOCOL_SENTINEL === map__47275.cljs$core$ISeq$ ? true : false : false) ? cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map, map__47275) : map__47275;
  var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47275__$1, new cljs.core.Keyword(null, "meta", "meta", 1499536964));
  var validator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47275__$1, new cljs.core.Keyword(null, "validator", "validator", -1966190681));
  return new cljs.core.Atom(x, meta, validator, null);
};
cljs.core.atom.cljs$lang$applyTo = function(seq47270) {
  var G__47271 = cljs.core.first(seq47270);
  var seq47270__$1 = cljs.core.next(seq47270);
  return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic(G__47271, seq47270__$1);
};
cljs.core.atom.cljs$lang$maxFixedArity = 1;
cljs.core.reset_BANG_ = function cljs$core$reset_BANG_(a, new_value) {
  if (a instanceof cljs.core.Atom) {
    var validate = a.validator;
    if (validate == null) {
    } else {
      if (cljs.core.truth_(validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(new_value) : validate.call(null, new_value))) {
      } else {
        throw new Error("Validator rejected reference state");
      }
    }
    var old_value = a.state;
    a.state = new_value;
    if (a.watches == null) {
    } else {
      cljs.core._notify_watches(a, old_value, new_value);
    }
    return new_value;
  } else {
    return cljs.core._reset_BANG_(a, new_value);
  }
};
cljs.core.swap_BANG_ = function cljs$core$swap_BANG_(var_args) {
  var args47281 = [];
  var len__10375__auto___47295 = arguments.length;
  var i__10376__auto___47296 = 0;
  while (true) {
    if (i__10376__auto___47296 < len__10375__auto___47295) {
      args47281.push(arguments[i__10376__auto___47296]);
      var G__47297 = i__10376__auto___47296 + 1;
      i__10376__auto___47296 = G__47297;
      continue;
    } else {
    }
    break;
  }
  var G__47288 = args47281.length;
  switch(G__47288) {
    case 2:
      return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args47281.slice(4), 0, null);
      return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__10398__auto__);
  }
};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2 = function(a, f) {
  if (a instanceof cljs.core.Atom) {
    return cljs.core.reset_BANG_(a, function() {
      var G__47289 = a.state;
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__47289) : f.call(null, G__47289);
    }());
  } else {
    return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(a, f);
  }
};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3 = function(a, f, x) {
  if (a instanceof cljs.core.Atom) {
    return cljs.core.reset_BANG_(a, function() {
      var G__47290 = a.state;
      var G__47291 = x;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__47290, G__47291) : f.call(null, G__47290, G__47291);
    }());
  } else {
    return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(a, f, x);
  }
};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4 = function(a, f, x, y) {
  if (a instanceof cljs.core.Atom) {
    return cljs.core.reset_BANG_(a, function() {
      var G__47292 = a.state;
      var G__47293 = x;
      var G__47294 = y;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__47292, G__47293, G__47294) : f.call(null, G__47292, G__47293, G__47294);
    }());
  } else {
    return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(a, f, x, y);
  }
};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(a, f, x, y, more) {
  if (a instanceof cljs.core.Atom) {
    return cljs.core.reset_BANG_(a, cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a.state, x, y, more));
  } else {
    return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(a, f, x, y, more);
  }
};
cljs.core.swap_BANG_.cljs$lang$applyTo = function(seq47282) {
  var G__47283 = cljs.core.first(seq47282);
  var seq47282__$1 = cljs.core.next(seq47282);
  var G__47284 = cljs.core.first(seq47282__$1);
  var seq47282__$2 = cljs.core.next(seq47282__$1);
  var G__47285 = cljs.core.first(seq47282__$2);
  var seq47282__$3 = cljs.core.next(seq47282__$2);
  var G__47286 = cljs.core.first(seq47282__$3);
  var seq47282__$4 = cljs.core.next(seq47282__$3);
  return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__47283, G__47284, G__47285, G__47286, seq47282__$4);
};
cljs.core.swap_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.compare_and_set_BANG_ = function cljs$core$compare_and_set_BANG_(a, oldval, newval) {
  if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a.cljs$core$IDeref$_deref$arity$1(null), oldval)) {
    cljs.core.reset_BANG_(a, newval);
    return true;
  } else {
    return false;
  }
};
cljs.core.set_validator_BANG_ = function cljs$core$set_validator_BANG_(iref, val) {
  return iref.validator = val;
};
cljs.core.get_validator = function cljs$core$get_validator(iref) {
  return iref.validator;
};
cljs.core.Volatile = function(state) {
  this.state = state;
  this.cljs$lang$protocol_mask$partition0$ = 32768;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.Volatile.prototype.cljs$core$IVolatile$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.Volatile.prototype.cljs$core$IVolatile$_vreset_BANG_$arity$2 = function(_, new_state) {
  var self__ = this;
  var ___$1 = this;
  return self__.state = new_state;
};
cljs.core.Volatile.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.state;
};
cljs.core.Volatile.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "state", "state", -348086572, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.Volatile.cljs$lang$type = true;
cljs.core.Volatile.cljs$lang$ctorStr = "cljs.core/Volatile";
cljs.core.Volatile.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/Volatile");
};
cljs.core.__GT_Volatile = function cljs$core$__GT_Volatile(state) {
  return new cljs.core.Volatile(state);
};
cljs.core.volatile_BANG_ = function cljs$core$volatile_BANG_(val) {
  return new cljs.core.Volatile(val);
};
cljs.core.volatile_QMARK_ = function cljs$core$volatile_QMARK_(x) {
  return x instanceof cljs.core.Volatile;
};
cljs.core.vreset_BANG_ = function cljs$core$vreset_BANG_(vol, newval) {
  return cljs.core._vreset_BANG_(vol, newval);
};
cljs.core.keep_indexed = function cljs$core$keep_indexed(var_args) {
  var args47299 = [];
  var len__10375__auto___47330 = arguments.length;
  var i__10376__auto___47331 = 0;
  while (true) {
    if (i__10376__auto___47331 < len__10375__auto___47330) {
      args47299.push(arguments[i__10376__auto___47331]);
      var G__47332 = i__10376__auto___47331 + 1;
      i__10376__auto___47331 = G__47332;
      continue;
    } else {
    }
    break;
  }
  var G__47301 = args47299.length;
  switch(G__47301) {
    case 1:
      return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args47299.length)].join(""));
  }
};
cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    var ia = cljs.core.volatile_BANG_(-1);
    return function(ia) {
      return function() {
        var G__47334 = null;
        var G__47334__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__47334__1 = function(result) {
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
        };
        var G__47334__2 = function(result, input) {
          var i = cljs.core._vreset_BANG_(ia, cljs.core._deref(ia) + 1);
          var v = f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(i, input) : f.call(null, i, input);
          if (v == null) {
            return result;
          } else {
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, v) : rf.call(null, result, v);
          }
        };
        G__47334 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__47334__0.call(this);
            case 1:
              return G__47334__1.call(this, result);
            case 2:
              return G__47334__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + (arguments.length - 1));
        };
        G__47334.cljs$core$IFn$_invoke$arity$0 = G__47334__0;
        G__47334.cljs$core$IFn$_invoke$arity$1 = G__47334__1;
        G__47334.cljs$core$IFn$_invoke$arity$2 = G__47334__2;
        return G__47334;
      }();
    }(ia);
  };
};
cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  var keepi = function cljs$core$keepi(idx, coll__$1) {
    return new cljs.core.LazySeq(null, function() {
      var temp__6738__auto__ = cljs.core.seq(coll__$1);
      if (temp__6738__auto__) {
        var s = temp__6738__auto__;
        if (cljs.core.chunked_seq_QMARK_(s)) {
          var c = cljs.core.chunk_first(s);
          var size = cljs.core.count(c);
          var b = cljs.core.chunk_buffer(size);
          var n__10175__auto___47335 = size;
          var i_47336 = 0;
          while (true) {
            if (i_47336 < n__10175__auto___47335) {
              var x_47337 = function() {
                var G__47326 = idx + i_47336;
                var G__47327 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_47336);
                return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__47326, G__47327) : f.call(null, G__47326, G__47327);
              }();
              if (x_47337 == null) {
              } else {
                cljs.core.chunk_append(b, x_47337);
              }
              var G__47338 = i_47336 + 1;
              i_47336 = G__47338;
              continue;
            } else {
            }
            break;
          }
          return cljs.core.chunk_cons(cljs.core.chunk(b), cljs$core$keepi(idx + size, cljs.core.chunk_rest(s)));
        } else {
          var x = function() {
            var G__47328 = idx;
            var G__47329 = cljs.core.first(s);
            return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__47328, G__47329) : f.call(null, G__47328, G__47329);
          }();
          if (x == null) {
            return cljs$core$keepi(idx + 1, cljs.core.rest(s));
          } else {
            return cljs.core.cons(x, cljs$core$keepi(idx + 1, cljs.core.rest(s)));
          }
        }
      } else {
        return null;
      }
    }, null, null);
  };
  return keepi(0, coll);
};
cljs.core.keep_indexed.cljs$lang$maxFixedArity = 2;
cljs.core.every_pred = function cljs$core$every_pred(var_args) {
  var args47345 = [];
  var len__10375__auto___47352 = arguments.length;
  var i__10376__auto___47353 = 0;
  while (true) {
    if (i__10376__auto___47353 < len__10375__auto___47352) {
      args47345.push(arguments[i__10376__auto___47353]);
      var G__47354 = i__10376__auto___47353 + 1;
      i__10376__auto___47353 = G__47354;
      continue;
    } else {
    }
    break;
  }
  var G__47351 = args47345.length;
  switch(G__47351) {
    case 1:
      return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args47345.slice(3), 0, null);
      return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__10398__auto__);
  }
};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1 = function(p) {
  return function() {
    var cljs$core$ep1 = null;
    var cljs$core$ep1__0 = function() {
      return true;
    };
    var cljs$core$ep1__1 = function(x) {
      return cljs.core.boolean$(p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null, x));
    };
    var cljs$core$ep1__2 = function(x, y) {
      return cljs.core.boolean$(function() {
        var and__9142__auto__ = p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null, x);
        if (cljs.core.truth_(and__9142__auto__)) {
          return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null, y);
        } else {
          return and__9142__auto__;
        }
      }());
    };
    var cljs$core$ep1__3 = function(x, y, z) {
      return cljs.core.boolean$(function() {
        var and__9142__auto__ = p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null, x);
        if (cljs.core.truth_(and__9142__auto__)) {
          var and__9142__auto____$1 = p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null, y);
          if (cljs.core.truth_(and__9142__auto____$1)) {
            return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null, z);
          } else {
            return and__9142__auto____$1;
          }
        } else {
          return and__9142__auto__;
        }
      }());
    };
    var cljs$core$ep1__4 = function() {
      var G__47356__delegate = function(x, y, z, args) {
        return cljs.core.boolean$(function() {
          var and__9142__auto__ = cljs$core$ep1.cljs$core$IFn$_invoke$arity$3(x, y, z);
          if (cljs.core.truth_(and__9142__auto__)) {
            return cljs.core.every_QMARK_(p, args);
          } else {
            return and__9142__auto__;
          }
        }());
      };
      var G__47356 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__47357__i = 0, G__47357__a = new Array(arguments.length - 3);
          while (G__47357__i < G__47357__a.length) {
            G__47357__a[G__47357__i] = arguments[G__47357__i + 3];
            ++G__47357__i;
          }
          args = new cljs.core.IndexedSeq(G__47357__a, 0, null);
        }
        return G__47356__delegate.call(this, x, y, z, args);
      };
      G__47356.cljs$lang$maxFixedArity = 3;
      G__47356.cljs$lang$applyTo = function(arglist__47358) {
        var x = cljs.core.first(arglist__47358);
        arglist__47358 = cljs.core.next(arglist__47358);
        var y = cljs.core.first(arglist__47358);
        arglist__47358 = cljs.core.next(arglist__47358);
        var z = cljs.core.first(arglist__47358);
        var args = cljs.core.rest(arglist__47358);
        return G__47356__delegate(x, y, z, args);
      };
      G__47356.cljs$core$IFn$_invoke$arity$variadic = G__47356__delegate;
      return G__47356;
    }();
    cljs$core$ep1 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$ep1__0.call(this);
        case 1:
          return cljs$core$ep1__1.call(this, x);
        case 2:
          return cljs$core$ep1__2.call(this, x, y);
        case 3:
          return cljs$core$ep1__3.call(this, x, y, z);
        default:
          var G__47359 = null;
          if (arguments.length > 3) {
            var G__47360__i = 0, G__47360__a = new Array(arguments.length - 3);
            while (G__47360__i < G__47360__a.length) {
              G__47360__a[G__47360__i] = arguments[G__47360__i + 3];
              ++G__47360__i;
            }
            G__47359 = new cljs.core.IndexedSeq(G__47360__a, 0, null);
          }
          return cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__47359);
      }
      throw new Error("Invalid arity: " + (arguments.length - 1));
    };
    cljs$core$ep1.cljs$lang$maxFixedArity = 3;
    cljs$core$ep1.cljs$lang$applyTo = cljs$core$ep1__4.cljs$lang$applyTo;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep1__0;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep1__1;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep1__2;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep1__3;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$ep1;
  }();
};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2 = function(p1, p2) {
  return function() {
    var cljs$core$ep2 = null;
    var cljs$core$ep2__0 = function() {
      return true;
    };
    var cljs$core$ep2__1 = function(x) {
      return cljs.core.boolean$(function() {
        var and__9142__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
        if (cljs.core.truth_(and__9142__auto__)) {
          return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
        } else {
          return and__9142__auto__;
        }
      }());
    };
    var cljs$core$ep2__2 = function(x, y) {
      return cljs.core.boolean$(function() {
        var and__9142__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
        if (cljs.core.truth_(and__9142__auto__)) {
          var and__9142__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
          if (cljs.core.truth_(and__9142__auto____$1)) {
            var and__9142__auto____$2 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
            if (cljs.core.truth_(and__9142__auto____$2)) {
              return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
            } else {
              return and__9142__auto____$2;
            }
          } else {
            return and__9142__auto____$1;
          }
        } else {
          return and__9142__auto__;
        }
      }());
    };
    var cljs$core$ep2__3 = function(x, y, z) {
      return cljs.core.boolean$(function() {
        var and__9142__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
        if (cljs.core.truth_(and__9142__auto__)) {
          var and__9142__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
          if (cljs.core.truth_(and__9142__auto____$1)) {
            var and__9142__auto____$2 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null, z);
            if (cljs.core.truth_(and__9142__auto____$2)) {
              var and__9142__auto____$3 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
              if (cljs.core.truth_(and__9142__auto____$3)) {
                var and__9142__auto____$4 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
                if (cljs.core.truth_(and__9142__auto____$4)) {
                  return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null, z);
                } else {
                  return and__9142__auto____$4;
                }
              } else {
                return and__9142__auto____$3;
              }
            } else {
              return and__9142__auto____$2;
            }
          } else {
            return and__9142__auto____$1;
          }
        } else {
          return and__9142__auto__;
        }
      }());
    };
    var cljs$core$ep2__4 = function() {
      var G__47361__delegate = function(x, y, z, args) {
        return cljs.core.boolean$(function() {
          var and__9142__auto__ = cljs$core$ep2.cljs$core$IFn$_invoke$arity$3(x, y, z);
          if (cljs.core.truth_(and__9142__auto__)) {
            return cljs.core.every_QMARK_(function(and__9142__auto__) {
              return function(p1__47339_SHARP_) {
                var and__9142__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__47339_SHARP_) : p1.call(null, p1__47339_SHARP_);
                if (cljs.core.truth_(and__9142__auto____$1)) {
                  return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__47339_SHARP_) : p2.call(null, p1__47339_SHARP_);
                } else {
                  return and__9142__auto____$1;
                }
              };
            }(and__9142__auto__), args);
          } else {
            return and__9142__auto__;
          }
        }());
      };
      var G__47361 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__47362__i = 0, G__47362__a = new Array(arguments.length - 3);
          while (G__47362__i < G__47362__a.length) {
            G__47362__a[G__47362__i] = arguments[G__47362__i + 3];
            ++G__47362__i;
          }
          args = new cljs.core.IndexedSeq(G__47362__a, 0, null);
        }
        return G__47361__delegate.call(this, x, y, z, args);
      };
      G__47361.cljs$lang$maxFixedArity = 3;
      G__47361.cljs$lang$applyTo = function(arglist__47363) {
        var x = cljs.core.first(arglist__47363);
        arglist__47363 = cljs.core.next(arglist__47363);
        var y = cljs.core.first(arglist__47363);
        arglist__47363 = cljs.core.next(arglist__47363);
        var z = cljs.core.first(arglist__47363);
        var args = cljs.core.rest(arglist__47363);
        return G__47361__delegate(x, y, z, args);
      };
      G__47361.cljs$core$IFn$_invoke$arity$variadic = G__47361__delegate;
      return G__47361;
    }();
    cljs$core$ep2 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$ep2__0.call(this);
        case 1:
          return cljs$core$ep2__1.call(this, x);
        case 2:
          return cljs$core$ep2__2.call(this, x, y);
        case 3:
          return cljs$core$ep2__3.call(this, x, y, z);
        default:
          var G__47364 = null;
          if (arguments.length > 3) {
            var G__47365__i = 0, G__47365__a = new Array(arguments.length - 3);
            while (G__47365__i < G__47365__a.length) {
              G__47365__a[G__47365__i] = arguments[G__47365__i + 3];
              ++G__47365__i;
            }
            G__47364 = new cljs.core.IndexedSeq(G__47365__a, 0, null);
          }
          return cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__47364);
      }
      throw new Error("Invalid arity: " + (arguments.length - 1));
    };
    cljs$core$ep2.cljs$lang$maxFixedArity = 3;
    cljs$core$ep2.cljs$lang$applyTo = cljs$core$ep2__4.cljs$lang$applyTo;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep2__0;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep2__1;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep2__2;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep2__3;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$ep2;
  }();
};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3 = function(p1, p2, p3) {
  return function() {
    var cljs$core$ep3 = null;
    var cljs$core$ep3__0 = function() {
      return true;
    };
    var cljs$core$ep3__1 = function(x) {
      return cljs.core.boolean$(function() {
        var and__9142__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
        if (cljs.core.truth_(and__9142__auto__)) {
          var and__9142__auto____$1 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
          if (cljs.core.truth_(and__9142__auto____$1)) {
            return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null, x);
          } else {
            return and__9142__auto____$1;
          }
        } else {
          return and__9142__auto__;
        }
      }());
    };
    var cljs$core$ep3__2 = function(x, y) {
      return cljs.core.boolean$(function() {
        var and__9142__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
        if (cljs.core.truth_(and__9142__auto__)) {
          var and__9142__auto____$1 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
          if (cljs.core.truth_(and__9142__auto____$1)) {
            var and__9142__auto____$2 = p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null, x);
            if (cljs.core.truth_(and__9142__auto____$2)) {
              var and__9142__auto____$3 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
              if (cljs.core.truth_(and__9142__auto____$3)) {
                var and__9142__auto____$4 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
                if (cljs.core.truth_(and__9142__auto____$4)) {
                  return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null, y);
                } else {
                  return and__9142__auto____$4;
                }
              } else {
                return and__9142__auto____$3;
              }
            } else {
              return and__9142__auto____$2;
            }
          } else {
            return and__9142__auto____$1;
          }
        } else {
          return and__9142__auto__;
        }
      }());
    };
    var cljs$core$ep3__3 = function(x, y, z) {
      return cljs.core.boolean$(function() {
        var and__9142__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
        if (cljs.core.truth_(and__9142__auto__)) {
          var and__9142__auto____$1 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
          if (cljs.core.truth_(and__9142__auto____$1)) {
            var and__9142__auto____$2 = p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null, x);
            if (cljs.core.truth_(and__9142__auto____$2)) {
              var and__9142__auto____$3 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
              if (cljs.core.truth_(and__9142__auto____$3)) {
                var and__9142__auto____$4 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
                if (cljs.core.truth_(and__9142__auto____$4)) {
                  var and__9142__auto____$5 = p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null, y);
                  if (cljs.core.truth_(and__9142__auto____$5)) {
                    var and__9142__auto____$6 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null, z);
                    if (cljs.core.truth_(and__9142__auto____$6)) {
                      var and__9142__auto____$7 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null, z);
                      if (cljs.core.truth_(and__9142__auto____$7)) {
                        return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null, z);
                      } else {
                        return and__9142__auto____$7;
                      }
                    } else {
                      return and__9142__auto____$6;
                    }
                  } else {
                    return and__9142__auto____$5;
                  }
                } else {
                  return and__9142__auto____$4;
                }
              } else {
                return and__9142__auto____$3;
              }
            } else {
              return and__9142__auto____$2;
            }
          } else {
            return and__9142__auto____$1;
          }
        } else {
          return and__9142__auto__;
        }
      }());
    };
    var cljs$core$ep3__4 = function() {
      var G__47366__delegate = function(x, y, z, args) {
        return cljs.core.boolean$(function() {
          var and__9142__auto__ = cljs$core$ep3.cljs$core$IFn$_invoke$arity$3(x, y, z);
          if (cljs.core.truth_(and__9142__auto__)) {
            return cljs.core.every_QMARK_(function(and__9142__auto__) {
              return function(p1__47340_SHARP_) {
                var and__9142__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__47340_SHARP_) : p1.call(null, p1__47340_SHARP_);
                if (cljs.core.truth_(and__9142__auto____$1)) {
                  var and__9142__auto____$2 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__47340_SHARP_) : p2.call(null, p1__47340_SHARP_);
                  if (cljs.core.truth_(and__9142__auto____$2)) {
                    return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__47340_SHARP_) : p3.call(null, p1__47340_SHARP_);
                  } else {
                    return and__9142__auto____$2;
                  }
                } else {
                  return and__9142__auto____$1;
                }
              };
            }(and__9142__auto__), args);
          } else {
            return and__9142__auto__;
          }
        }());
      };
      var G__47366 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__47367__i = 0, G__47367__a = new Array(arguments.length - 3);
          while (G__47367__i < G__47367__a.length) {
            G__47367__a[G__47367__i] = arguments[G__47367__i + 3];
            ++G__47367__i;
          }
          args = new cljs.core.IndexedSeq(G__47367__a, 0, null);
        }
        return G__47366__delegate.call(this, x, y, z, args);
      };
      G__47366.cljs$lang$maxFixedArity = 3;
      G__47366.cljs$lang$applyTo = function(arglist__47368) {
        var x = cljs.core.first(arglist__47368);
        arglist__47368 = cljs.core.next(arglist__47368);
        var y = cljs.core.first(arglist__47368);
        arglist__47368 = cljs.core.next(arglist__47368);
        var z = cljs.core.first(arglist__47368);
        var args = cljs.core.rest(arglist__47368);
        return G__47366__delegate(x, y, z, args);
      };
      G__47366.cljs$core$IFn$_invoke$arity$variadic = G__47366__delegate;
      return G__47366;
    }();
    cljs$core$ep3 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$ep3__0.call(this);
        case 1:
          return cljs$core$ep3__1.call(this, x);
        case 2:
          return cljs$core$ep3__2.call(this, x, y);
        case 3:
          return cljs$core$ep3__3.call(this, x, y, z);
        default:
          var G__47369 = null;
          if (arguments.length > 3) {
            var G__47370__i = 0, G__47370__a = new Array(arguments.length - 3);
            while (G__47370__i < G__47370__a.length) {
              G__47370__a[G__47370__i] = arguments[G__47370__i + 3];
              ++G__47370__i;
            }
            G__47369 = new cljs.core.IndexedSeq(G__47370__a, 0, null);
          }
          return cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__47369);
      }
      throw new Error("Invalid arity: " + (arguments.length - 1));
    };
    cljs$core$ep3.cljs$lang$maxFixedArity = 3;
    cljs$core$ep3.cljs$lang$applyTo = cljs$core$ep3__4.cljs$lang$applyTo;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep3__0;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep3__1;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep3__2;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep3__3;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$ep3;
  }();
};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic = function(p1, p2, p3, ps) {
  var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1, p2, p3, ps);
  return function(ps__$1) {
    return function() {
      var cljs$core$epn = null;
      var cljs$core$epn__0 = function() {
        return true;
      };
      var cljs$core$epn__1 = function(x) {
        return cljs.core.every_QMARK_(function(ps__$1) {
          return function(p1__47341_SHARP_) {
            return p1__47341_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__47341_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__47341_SHARP_.call(null, x);
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$epn__2 = function(x, y) {
        return cljs.core.every_QMARK_(function(ps__$1) {
          return function(p1__47342_SHARP_) {
            var and__9142__auto__ = p1__47342_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__47342_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__47342_SHARP_.call(null, x);
            if (cljs.core.truth_(and__9142__auto__)) {
              return p1__47342_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__47342_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__47342_SHARP_.call(null, y);
            } else {
              return and__9142__auto__;
            }
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$epn__3 = function(x, y, z) {
        return cljs.core.every_QMARK_(function(ps__$1) {
          return function(p1__47343_SHARP_) {
            var and__9142__auto__ = p1__47343_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__47343_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__47343_SHARP_.call(null, x);
            if (cljs.core.truth_(and__9142__auto__)) {
              var and__9142__auto____$1 = p1__47343_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__47343_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__47343_SHARP_.call(null, y);
              if (cljs.core.truth_(and__9142__auto____$1)) {
                return p1__47343_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__47343_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__47343_SHARP_.call(null, z);
              } else {
                return and__9142__auto____$1;
              }
            } else {
              return and__9142__auto__;
            }
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$epn__4 = function() {
        var G__47371__delegate = function(x, y, z, args) {
          return cljs.core.boolean$(function() {
            var and__9142__auto__ = cljs$core$epn.cljs$core$IFn$_invoke$arity$3(x, y, z);
            if (cljs.core.truth_(and__9142__auto__)) {
              return cljs.core.every_QMARK_(function(and__9142__auto__, ps__$1) {
                return function(p1__47344_SHARP_) {
                  return cljs.core.every_QMARK_(p1__47344_SHARP_, args);
                };
              }(and__9142__auto__, ps__$1), ps__$1);
            } else {
              return and__9142__auto__;
            }
          }());
        };
        var G__47371 = function(x, y, z, var_args) {
          var args = null;
          if (arguments.length > 3) {
            var G__47372__i = 0, G__47372__a = new Array(arguments.length - 3);
            while (G__47372__i < G__47372__a.length) {
              G__47372__a[G__47372__i] = arguments[G__47372__i + 3];
              ++G__47372__i;
            }
            args = new cljs.core.IndexedSeq(G__47372__a, 0, null);
          }
          return G__47371__delegate.call(this, x, y, z, args);
        };
        G__47371.cljs$lang$maxFixedArity = 3;
        G__47371.cljs$lang$applyTo = function(arglist__47373) {
          var x = cljs.core.first(arglist__47373);
          arglist__47373 = cljs.core.next(arglist__47373);
          var y = cljs.core.first(arglist__47373);
          arglist__47373 = cljs.core.next(arglist__47373);
          var z = cljs.core.first(arglist__47373);
          var args = cljs.core.rest(arglist__47373);
          return G__47371__delegate(x, y, z, args);
        };
        G__47371.cljs$core$IFn$_invoke$arity$variadic = G__47371__delegate;
        return G__47371;
      }();
      cljs$core$epn = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return cljs$core$epn__0.call(this);
          case 1:
            return cljs$core$epn__1.call(this, x);
          case 2:
            return cljs$core$epn__2.call(this, x, y);
          case 3:
            return cljs$core$epn__3.call(this, x, y, z);
          default:
            var G__47374 = null;
            if (arguments.length > 3) {
              var G__47375__i = 0, G__47375__a = new Array(arguments.length - 3);
              while (G__47375__i < G__47375__a.length) {
                G__47375__a[G__47375__i] = arguments[G__47375__i + 3];
                ++G__47375__i;
              }
              G__47374 = new cljs.core.IndexedSeq(G__47375__a, 0, null);
            }
            return cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__47374);
        }
        throw new Error("Invalid arity: " + (arguments.length - 1));
      };
      cljs$core$epn.cljs$lang$maxFixedArity = 3;
      cljs$core$epn.cljs$lang$applyTo = cljs$core$epn__4.cljs$lang$applyTo;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$0 = cljs$core$epn__0;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$1 = cljs$core$epn__1;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$2 = cljs$core$epn__2;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$3 = cljs$core$epn__3;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic;
      return cljs$core$epn;
    }();
  }(ps__$1);
};
cljs.core.every_pred.cljs$lang$applyTo = function(seq47346) {
  var G__47347 = cljs.core.first(seq47346);
  var seq47346__$1 = cljs.core.next(seq47346);
  var G__47348 = cljs.core.first(seq47346__$1);
  var seq47346__$2 = cljs.core.next(seq47346__$1);
  var G__47349 = cljs.core.first(seq47346__$2);
  var seq47346__$3 = cljs.core.next(seq47346__$2);
  return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic(G__47347, G__47348, G__47349, seq47346__$3);
};
cljs.core.every_pred.cljs$lang$maxFixedArity = 3;
cljs.core.some_fn = function cljs$core$some_fn(var_args) {
  var args47382 = [];
  var len__10375__auto___47389 = arguments.length;
  var i__10376__auto___47390 = 0;
  while (true) {
    if (i__10376__auto___47390 < len__10375__auto___47389) {
      args47382.push(arguments[i__10376__auto___47390]);
      var G__47391 = i__10376__auto___47390 + 1;
      i__10376__auto___47390 = G__47391;
      continue;
    } else {
    }
    break;
  }
  var G__47388 = args47382.length;
  switch(G__47388) {
    case 1:
      return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args47382.slice(3), 0, null);
      return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__10398__auto__);
  }
};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1 = function(p) {
  return function() {
    var cljs$core$sp1 = null;
    var cljs$core$sp1__0 = function() {
      return null;
    };
    var cljs$core$sp1__1 = function(x) {
      return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null, x);
    };
    var cljs$core$sp1__2 = function(x, y) {
      var or__9154__auto__ = p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null, x);
      if (cljs.core.truth_(or__9154__auto__)) {
        return or__9154__auto__;
      } else {
        return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null, y);
      }
    };
    var cljs$core$sp1__3 = function(x, y, z) {
      var or__9154__auto__ = p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null, x);
      if (cljs.core.truth_(or__9154__auto__)) {
        return or__9154__auto__;
      } else {
        var or__9154__auto____$1 = p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null, y);
        if (cljs.core.truth_(or__9154__auto____$1)) {
          return or__9154__auto____$1;
        } else {
          return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null, z);
        }
      }
    };
    var cljs$core$sp1__4 = function() {
      var G__47393__delegate = function(x, y, z, args) {
        var or__9154__auto__ = cljs$core$sp1.cljs$core$IFn$_invoke$arity$3(x, y, z);
        if (cljs.core.truth_(or__9154__auto__)) {
          return or__9154__auto__;
        } else {
          return cljs.core.some(p, args);
        }
      };
      var G__47393 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__47394__i = 0, G__47394__a = new Array(arguments.length - 3);
          while (G__47394__i < G__47394__a.length) {
            G__47394__a[G__47394__i] = arguments[G__47394__i + 3];
            ++G__47394__i;
          }
          args = new cljs.core.IndexedSeq(G__47394__a, 0, null);
        }
        return G__47393__delegate.call(this, x, y, z, args);
      };
      G__47393.cljs$lang$maxFixedArity = 3;
      G__47393.cljs$lang$applyTo = function(arglist__47395) {
        var x = cljs.core.first(arglist__47395);
        arglist__47395 = cljs.core.next(arglist__47395);
        var y = cljs.core.first(arglist__47395);
        arglist__47395 = cljs.core.next(arglist__47395);
        var z = cljs.core.first(arglist__47395);
        var args = cljs.core.rest(arglist__47395);
        return G__47393__delegate(x, y, z, args);
      };
      G__47393.cljs$core$IFn$_invoke$arity$variadic = G__47393__delegate;
      return G__47393;
    }();
    cljs$core$sp1 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$sp1__0.call(this);
        case 1:
          return cljs$core$sp1__1.call(this, x);
        case 2:
          return cljs$core$sp1__2.call(this, x, y);
        case 3:
          return cljs$core$sp1__3.call(this, x, y, z);
        default:
          var G__47396 = null;
          if (arguments.length > 3) {
            var G__47397__i = 0, G__47397__a = new Array(arguments.length - 3);
            while (G__47397__i < G__47397__a.length) {
              G__47397__a[G__47397__i] = arguments[G__47397__i + 3];
              ++G__47397__i;
            }
            G__47396 = new cljs.core.IndexedSeq(G__47397__a, 0, null);
          }
          return cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__47396);
      }
      throw new Error("Invalid arity: " + (arguments.length - 1));
    };
    cljs$core$sp1.cljs$lang$maxFixedArity = 3;
    cljs$core$sp1.cljs$lang$applyTo = cljs$core$sp1__4.cljs$lang$applyTo;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp1__0;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp1__1;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp1__2;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp1__3;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$sp1;
  }();
};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2 = function(p1, p2) {
  return function() {
    var cljs$core$sp2 = null;
    var cljs$core$sp2__0 = function() {
      return null;
    };
    var cljs$core$sp2__1 = function(x) {
      var or__9154__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
      if (cljs.core.truth_(or__9154__auto__)) {
        return or__9154__auto__;
      } else {
        return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
      }
    };
    var cljs$core$sp2__2 = function(x, y) {
      var or__9154__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
      if (cljs.core.truth_(or__9154__auto__)) {
        return or__9154__auto__;
      } else {
        var or__9154__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
        if (cljs.core.truth_(or__9154__auto____$1)) {
          return or__9154__auto____$1;
        } else {
          var or__9154__auto____$2 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
          if (cljs.core.truth_(or__9154__auto____$2)) {
            return or__9154__auto____$2;
          } else {
            return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
          }
        }
      }
    };
    var cljs$core$sp2__3 = function(x, y, z) {
      var or__9154__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
      if (cljs.core.truth_(or__9154__auto__)) {
        return or__9154__auto__;
      } else {
        var or__9154__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
        if (cljs.core.truth_(or__9154__auto____$1)) {
          return or__9154__auto____$1;
        } else {
          var or__9154__auto____$2 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null, z);
          if (cljs.core.truth_(or__9154__auto____$2)) {
            return or__9154__auto____$2;
          } else {
            var or__9154__auto____$3 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
            if (cljs.core.truth_(or__9154__auto____$3)) {
              return or__9154__auto____$3;
            } else {
              var or__9154__auto____$4 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
              if (cljs.core.truth_(or__9154__auto____$4)) {
                return or__9154__auto____$4;
              } else {
                return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null, z);
              }
            }
          }
        }
      }
    };
    var cljs$core$sp2__4 = function() {
      var G__47398__delegate = function(x, y, z, args) {
        var or__9154__auto__ = cljs$core$sp2.cljs$core$IFn$_invoke$arity$3(x, y, z);
        if (cljs.core.truth_(or__9154__auto__)) {
          return or__9154__auto__;
        } else {
          return cljs.core.some(function(or__9154__auto__) {
            return function(p1__47376_SHARP_) {
              var or__9154__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__47376_SHARP_) : p1.call(null, p1__47376_SHARP_);
              if (cljs.core.truth_(or__9154__auto____$1)) {
                return or__9154__auto____$1;
              } else {
                return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__47376_SHARP_) : p2.call(null, p1__47376_SHARP_);
              }
            };
          }(or__9154__auto__), args);
        }
      };
      var G__47398 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__47399__i = 0, G__47399__a = new Array(arguments.length - 3);
          while (G__47399__i < G__47399__a.length) {
            G__47399__a[G__47399__i] = arguments[G__47399__i + 3];
            ++G__47399__i;
          }
          args = new cljs.core.IndexedSeq(G__47399__a, 0, null);
        }
        return G__47398__delegate.call(this, x, y, z, args);
      };
      G__47398.cljs$lang$maxFixedArity = 3;
      G__47398.cljs$lang$applyTo = function(arglist__47400) {
        var x = cljs.core.first(arglist__47400);
        arglist__47400 = cljs.core.next(arglist__47400);
        var y = cljs.core.first(arglist__47400);
        arglist__47400 = cljs.core.next(arglist__47400);
        var z = cljs.core.first(arglist__47400);
        var args = cljs.core.rest(arglist__47400);
        return G__47398__delegate(x, y, z, args);
      };
      G__47398.cljs$core$IFn$_invoke$arity$variadic = G__47398__delegate;
      return G__47398;
    }();
    cljs$core$sp2 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$sp2__0.call(this);
        case 1:
          return cljs$core$sp2__1.call(this, x);
        case 2:
          return cljs$core$sp2__2.call(this, x, y);
        case 3:
          return cljs$core$sp2__3.call(this, x, y, z);
        default:
          var G__47401 = null;
          if (arguments.length > 3) {
            var G__47402__i = 0, G__47402__a = new Array(arguments.length - 3);
            while (G__47402__i < G__47402__a.length) {
              G__47402__a[G__47402__i] = arguments[G__47402__i + 3];
              ++G__47402__i;
            }
            G__47401 = new cljs.core.IndexedSeq(G__47402__a, 0, null);
          }
          return cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__47401);
      }
      throw new Error("Invalid arity: " + (arguments.length - 1));
    };
    cljs$core$sp2.cljs$lang$maxFixedArity = 3;
    cljs$core$sp2.cljs$lang$applyTo = cljs$core$sp2__4.cljs$lang$applyTo;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp2__0;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp2__1;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp2__2;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp2__3;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$sp2;
  }();
};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3 = function(p1, p2, p3) {
  return function() {
    var cljs$core$sp3 = null;
    var cljs$core$sp3__0 = function() {
      return null;
    };
    var cljs$core$sp3__1 = function(x) {
      var or__9154__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
      if (cljs.core.truth_(or__9154__auto__)) {
        return or__9154__auto__;
      } else {
        var or__9154__auto____$1 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
        if (cljs.core.truth_(or__9154__auto____$1)) {
          return or__9154__auto____$1;
        } else {
          return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null, x);
        }
      }
    };
    var cljs$core$sp3__2 = function(x, y) {
      var or__9154__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
      if (cljs.core.truth_(or__9154__auto__)) {
        return or__9154__auto__;
      } else {
        var or__9154__auto____$1 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
        if (cljs.core.truth_(or__9154__auto____$1)) {
          return or__9154__auto____$1;
        } else {
          var or__9154__auto____$2 = p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null, x);
          if (cljs.core.truth_(or__9154__auto____$2)) {
            return or__9154__auto____$2;
          } else {
            var or__9154__auto____$3 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
            if (cljs.core.truth_(or__9154__auto____$3)) {
              return or__9154__auto____$3;
            } else {
              var or__9154__auto____$4 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
              if (cljs.core.truth_(or__9154__auto____$4)) {
                return or__9154__auto____$4;
              } else {
                return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null, y);
              }
            }
          }
        }
      }
    };
    var cljs$core$sp3__3 = function(x, y, z) {
      var or__9154__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
      if (cljs.core.truth_(or__9154__auto__)) {
        return or__9154__auto__;
      } else {
        var or__9154__auto____$1 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
        if (cljs.core.truth_(or__9154__auto____$1)) {
          return or__9154__auto____$1;
        } else {
          var or__9154__auto____$2 = p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null, x);
          if (cljs.core.truth_(or__9154__auto____$2)) {
            return or__9154__auto____$2;
          } else {
            var or__9154__auto____$3 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
            if (cljs.core.truth_(or__9154__auto____$3)) {
              return or__9154__auto____$3;
            } else {
              var or__9154__auto____$4 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
              if (cljs.core.truth_(or__9154__auto____$4)) {
                return or__9154__auto____$4;
              } else {
                var or__9154__auto____$5 = p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null, y);
                if (cljs.core.truth_(or__9154__auto____$5)) {
                  return or__9154__auto____$5;
                } else {
                  var or__9154__auto____$6 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null, z);
                  if (cljs.core.truth_(or__9154__auto____$6)) {
                    return or__9154__auto____$6;
                  } else {
                    var or__9154__auto____$7 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null, z);
                    if (cljs.core.truth_(or__9154__auto____$7)) {
                      return or__9154__auto____$7;
                    } else {
                      return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null, z);
                    }
                  }
                }
              }
            }
          }
        }
      }
    };
    var cljs$core$sp3__4 = function() {
      var G__47403__delegate = function(x, y, z, args) {
        var or__9154__auto__ = cljs$core$sp3.cljs$core$IFn$_invoke$arity$3(x, y, z);
        if (cljs.core.truth_(or__9154__auto__)) {
          return or__9154__auto__;
        } else {
          return cljs.core.some(function(or__9154__auto__) {
            return function(p1__47377_SHARP_) {
              var or__9154__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__47377_SHARP_) : p1.call(null, p1__47377_SHARP_);
              if (cljs.core.truth_(or__9154__auto____$1)) {
                return or__9154__auto____$1;
              } else {
                var or__9154__auto____$2 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__47377_SHARP_) : p2.call(null, p1__47377_SHARP_);
                if (cljs.core.truth_(or__9154__auto____$2)) {
                  return or__9154__auto____$2;
                } else {
                  return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__47377_SHARP_) : p3.call(null, p1__47377_SHARP_);
                }
              }
            };
          }(or__9154__auto__), args);
        }
      };
      var G__47403 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__47404__i = 0, G__47404__a = new Array(arguments.length - 3);
          while (G__47404__i < G__47404__a.length) {
            G__47404__a[G__47404__i] = arguments[G__47404__i + 3];
            ++G__47404__i;
          }
          args = new cljs.core.IndexedSeq(G__47404__a, 0, null);
        }
        return G__47403__delegate.call(this, x, y, z, args);
      };
      G__47403.cljs$lang$maxFixedArity = 3;
      G__47403.cljs$lang$applyTo = function(arglist__47405) {
        var x = cljs.core.first(arglist__47405);
        arglist__47405 = cljs.core.next(arglist__47405);
        var y = cljs.core.first(arglist__47405);
        arglist__47405 = cljs.core.next(arglist__47405);
        var z = cljs.core.first(arglist__47405);
        var args = cljs.core.rest(arglist__47405);
        return G__47403__delegate(x, y, z, args);
      };
      G__47403.cljs$core$IFn$_invoke$arity$variadic = G__47403__delegate;
      return G__47403;
    }();
    cljs$core$sp3 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$sp3__0.call(this);
        case 1:
          return cljs$core$sp3__1.call(this, x);
        case 2:
          return cljs$core$sp3__2.call(this, x, y);
        case 3:
          return cljs$core$sp3__3.call(this, x, y, z);
        default:
          var G__47406 = null;
          if (arguments.length > 3) {
            var G__47407__i = 0, G__47407__a = new Array(arguments.length - 3);
            while (G__47407__i < G__47407__a.length) {
              G__47407__a[G__47407__i] = arguments[G__47407__i + 3];
              ++G__47407__i;
            }
            G__47406 = new cljs.core.IndexedSeq(G__47407__a, 0, null);
          }
          return cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__47406);
      }
      throw new Error("Invalid arity: " + (arguments.length - 1));
    };
    cljs$core$sp3.cljs$lang$maxFixedArity = 3;
    cljs$core$sp3.cljs$lang$applyTo = cljs$core$sp3__4.cljs$lang$applyTo;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp3__0;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp3__1;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp3__2;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp3__3;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$sp3;
  }();
};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic = function(p1, p2, p3, ps) {
  var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1, p2, p3, ps);
  return function(ps__$1) {
    return function() {
      var cljs$core$spn = null;
      var cljs$core$spn__0 = function() {
        return null;
      };
      var cljs$core$spn__1 = function(x) {
        return cljs.core.some(function(ps__$1) {
          return function(p1__47378_SHARP_) {
            return p1__47378_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__47378_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__47378_SHARP_.call(null, x);
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$spn__2 = function(x, y) {
        return cljs.core.some(function(ps__$1) {
          return function(p1__47379_SHARP_) {
            var or__9154__auto__ = p1__47379_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__47379_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__47379_SHARP_.call(null, x);
            if (cljs.core.truth_(or__9154__auto__)) {
              return or__9154__auto__;
            } else {
              return p1__47379_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__47379_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__47379_SHARP_.call(null, y);
            }
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$spn__3 = function(x, y, z) {
        return cljs.core.some(function(ps__$1) {
          return function(p1__47380_SHARP_) {
            var or__9154__auto__ = p1__47380_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__47380_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__47380_SHARP_.call(null, x);
            if (cljs.core.truth_(or__9154__auto__)) {
              return or__9154__auto__;
            } else {
              var or__9154__auto____$1 = p1__47380_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__47380_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__47380_SHARP_.call(null, y);
              if (cljs.core.truth_(or__9154__auto____$1)) {
                return or__9154__auto____$1;
              } else {
                return p1__47380_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__47380_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__47380_SHARP_.call(null, z);
              }
            }
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$spn__4 = function() {
        var G__47408__delegate = function(x, y, z, args) {
          var or__9154__auto__ = cljs$core$spn.cljs$core$IFn$_invoke$arity$3(x, y, z);
          if (cljs.core.truth_(or__9154__auto__)) {
            return or__9154__auto__;
          } else {
            return cljs.core.some(function(or__9154__auto__, ps__$1) {
              return function(p1__47381_SHARP_) {
                return cljs.core.some(p1__47381_SHARP_, args);
              };
            }(or__9154__auto__, ps__$1), ps__$1);
          }
        };
        var G__47408 = function(x, y, z, var_args) {
          var args = null;
          if (arguments.length > 3) {
            var G__47409__i = 0, G__47409__a = new Array(arguments.length - 3);
            while (G__47409__i < G__47409__a.length) {
              G__47409__a[G__47409__i] = arguments[G__47409__i + 3];
              ++G__47409__i;
            }
            args = new cljs.core.IndexedSeq(G__47409__a, 0, null);
          }
          return G__47408__delegate.call(this, x, y, z, args);
        };
        G__47408.cljs$lang$maxFixedArity = 3;
        G__47408.cljs$lang$applyTo = function(arglist__47410) {
          var x = cljs.core.first(arglist__47410);
          arglist__47410 = cljs.core.next(arglist__47410);
          var y = cljs.core.first(arglist__47410);
          arglist__47410 = cljs.core.next(arglist__47410);
          var z = cljs.core.first(arglist__47410);
          var args = cljs.core.rest(arglist__47410);
          return G__47408__delegate(x, y, z, args);
        };
        G__47408.cljs$core$IFn$_invoke$arity$variadic = G__47408__delegate;
        return G__47408;
      }();
      cljs$core$spn = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return cljs$core$spn__0.call(this);
          case 1:
            return cljs$core$spn__1.call(this, x);
          case 2:
            return cljs$core$spn__2.call(this, x, y);
          case 3:
            return cljs$core$spn__3.call(this, x, y, z);
          default:
            var G__47411 = null;
            if (arguments.length > 3) {
              var G__47412__i = 0, G__47412__a = new Array(arguments.length - 3);
              while (G__47412__i < G__47412__a.length) {
                G__47412__a[G__47412__i] = arguments[G__47412__i + 3];
                ++G__47412__i;
              }
              G__47411 = new cljs.core.IndexedSeq(G__47412__a, 0, null);
            }
            return cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__47411);
        }
        throw new Error("Invalid arity: " + (arguments.length - 1));
      };
      cljs$core$spn.cljs$lang$maxFixedArity = 3;
      cljs$core$spn.cljs$lang$applyTo = cljs$core$spn__4.cljs$lang$applyTo;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$0 = cljs$core$spn__0;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$1 = cljs$core$spn__1;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$2 = cljs$core$spn__2;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$3 = cljs$core$spn__3;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic;
      return cljs$core$spn;
    }();
  }(ps__$1);
};
cljs.core.some_fn.cljs$lang$applyTo = function(seq47383) {
  var G__47384 = cljs.core.first(seq47383);
  var seq47383__$1 = cljs.core.next(seq47383);
  var G__47385 = cljs.core.first(seq47383__$1);
  var seq47383__$2 = cljs.core.next(seq47383__$1);
  var G__47386 = cljs.core.first(seq47383__$2);
  var seq47383__$3 = cljs.core.next(seq47383__$2);
  return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic(G__47384, G__47385, G__47386, seq47383__$3);
};
cljs.core.some_fn.cljs$lang$maxFixedArity = 3;
cljs.core.map = function cljs$core$map(var_args) {
  var args47414 = [];
  var len__10375__auto___47434 = arguments.length;
  var i__10376__auto___47435 = 0;
  while (true) {
    if (i__10376__auto___47435 < len__10375__auto___47434) {
      args47414.push(arguments[i__10376__auto___47435]);
      var G__47436 = i__10376__auto___47435 + 1;
      i__10376__auto___47435 = G__47436;
      continue;
    } else {
    }
    break;
  }
  var G__47421 = args47414.length;
  switch(G__47421) {
    case 1:
      return cljs.core.map.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.map.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.map.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.map.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args47414.slice(4), 0, null);
      return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__10398__auto__);
  }
};
cljs.core.map.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    return function() {
      var G__47438 = null;
      var G__47438__0 = function() {
        return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
      };
      var G__47438__1 = function(result) {
        return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
      };
      var G__47438__2 = function(result, input) {
        var G__47422 = result;
        var G__47423 = f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null, input);
        return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__47422, G__47423) : rf.call(null, G__47422, G__47423);
      };
      var G__47438__3 = function() {
        var G__47439__delegate = function(result, input, inputs) {
          var G__47424 = result;
          var G__47425 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f, input, inputs);
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__47424, G__47425) : rf.call(null, G__47424, G__47425);
        };
        var G__47439 = function(result, input, var_args) {
          var inputs = null;
          if (arguments.length > 2) {
            var G__47440__i = 0, G__47440__a = new Array(arguments.length - 2);
            while (G__47440__i < G__47440__a.length) {
              G__47440__a[G__47440__i] = arguments[G__47440__i + 2];
              ++G__47440__i;
            }
            inputs = new cljs.core.IndexedSeq(G__47440__a, 0, null);
          }
          return G__47439__delegate.call(this, result, input, inputs);
        };
        G__47439.cljs$lang$maxFixedArity = 2;
        G__47439.cljs$lang$applyTo = function(arglist__47441) {
          var result = cljs.core.first(arglist__47441);
          arglist__47441 = cljs.core.next(arglist__47441);
          var input = cljs.core.first(arglist__47441);
          var inputs = cljs.core.rest(arglist__47441);
          return G__47439__delegate(result, input, inputs);
        };
        G__47439.cljs$core$IFn$_invoke$arity$variadic = G__47439__delegate;
        return G__47439;
      }();
      G__47438 = function(result, input, var_args) {
        var inputs = var_args;
        switch(arguments.length) {
          case 0:
            return G__47438__0.call(this);
          case 1:
            return G__47438__1.call(this, result);
          case 2:
            return G__47438__2.call(this, result, input);
          default:
            var G__47442 = null;
            if (arguments.length > 2) {
              var G__47443__i = 0, G__47443__a = new Array(arguments.length - 2);
              while (G__47443__i < G__47443__a.length) {
                G__47443__a[G__47443__i] = arguments[G__47443__i + 2];
                ++G__47443__i;
              }
              G__47442 = new cljs.core.IndexedSeq(G__47443__a, 0, null);
            }
            return G__47438__3.cljs$core$IFn$_invoke$arity$variadic(result, input, G__47442);
        }
        throw new Error("Invalid arity: " + (arguments.length - 1));
      };
      G__47438.cljs$lang$maxFixedArity = 2;
      G__47438.cljs$lang$applyTo = G__47438__3.cljs$lang$applyTo;
      G__47438.cljs$core$IFn$_invoke$arity$0 = G__47438__0;
      G__47438.cljs$core$IFn$_invoke$arity$1 = G__47438__1;
      G__47438.cljs$core$IFn$_invoke$arity$2 = G__47438__2;
      G__47438.cljs$core$IFn$_invoke$arity$variadic = G__47438__3.cljs$core$IFn$_invoke$arity$variadic;
      return G__47438;
    }();
  };
};
cljs.core.map.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__6738__auto__ = cljs.core.seq(coll);
    if (temp__6738__auto__) {
      var s = temp__6738__auto__;
      if (cljs.core.chunked_seq_QMARK_(s)) {
        var c = cljs.core.chunk_first(s);
        var size = cljs.core.count(c);
        var b = cljs.core.chunk_buffer(size);
        var n__10175__auto___47444 = size;
        var i_47445 = 0;
        while (true) {
          if (i_47445 < n__10175__auto___47444) {
            cljs.core.chunk_append(b, function() {
              var G__47426 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_47445);
              return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__47426) : f.call(null, G__47426);
            }());
            var G__47446 = i_47445 + 1;
            i_47445 = G__47446;
            continue;
          } else {
          }
          break;
        }
        return cljs.core.chunk_cons(cljs.core.chunk(b), cljs.core.map.cljs$core$IFn$_invoke$arity$2(f, cljs.core.chunk_rest(s)));
      } else {
        return cljs.core.cons(function() {
          var G__47427 = cljs.core.first(s);
          return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__47427) : f.call(null, G__47427);
        }(), cljs.core.map.cljs$core$IFn$_invoke$arity$2(f, cljs.core.rest(s)));
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.map.cljs$core$IFn$_invoke$arity$3 = function(f, c1, c2) {
  return new cljs.core.LazySeq(null, function() {
    var s1 = cljs.core.seq(c1);
    var s2 = cljs.core.seq(c2);
    if (s1 && s2) {
      return cljs.core.cons(function() {
        var G__47428 = cljs.core.first(s1);
        var G__47429 = cljs.core.first(s2);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__47428, G__47429) : f.call(null, G__47428, G__47429);
      }(), cljs.core.map.cljs$core$IFn$_invoke$arity$3(f, cljs.core.rest(s1), cljs.core.rest(s2)));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.map.cljs$core$IFn$_invoke$arity$4 = function(f, c1, c2, c3) {
  return new cljs.core.LazySeq(null, function() {
    var s1 = cljs.core.seq(c1);
    var s2 = cljs.core.seq(c2);
    var s3 = cljs.core.seq(c3);
    if (s1 && s2 && s3) {
      return cljs.core.cons(function() {
        var G__47430 = cljs.core.first(s1);
        var G__47431 = cljs.core.first(s2);
        var G__47432 = cljs.core.first(s3);
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__47430, G__47431, G__47432) : f.call(null, G__47430, G__47431, G__47432);
      }(), cljs.core.map.cljs$core$IFn$_invoke$arity$4(f, cljs.core.rest(s1), cljs.core.rest(s2), cljs.core.rest(s3)));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.map.cljs$core$IFn$_invoke$arity$variadic = function(f, c1, c2, c3, colls) {
  var step = function cljs$core$step(cs) {
    return new cljs.core.LazySeq(null, function() {
      var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq, cs);
      if (cljs.core.every_QMARK_(cljs.core.identity, ss)) {
        return cljs.core.cons(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first, ss), cljs$core$step(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest, ss)));
      } else {
        return null;
      }
    }, null, null);
  };
  return cljs.core.map.cljs$core$IFn$_invoke$arity$2(function(step) {
    return function(p1__47413_SHARP_) {
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f, p1__47413_SHARP_);
    };
  }(step), step(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls, c3, cljs.core.array_seq([c2, c1], 0))));
};
cljs.core.map.cljs$lang$applyTo = function(seq47415) {
  var G__47416 = cljs.core.first(seq47415);
  var seq47415__$1 = cljs.core.next(seq47415);
  var G__47417 = cljs.core.first(seq47415__$1);
  var seq47415__$2 = cljs.core.next(seq47415__$1);
  var G__47418 = cljs.core.first(seq47415__$2);
  var seq47415__$3 = cljs.core.next(seq47415__$2);
  var G__47419 = cljs.core.first(seq47415__$3);
  var seq47415__$4 = cljs.core.next(seq47415__$3);
  return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic(G__47416, G__47417, G__47418, G__47419, seq47415__$4);
};
cljs.core.map.cljs$lang$maxFixedArity = 4;
cljs.core.take = function cljs$core$take(var_args) {
  var args47447 = [];
  var len__10375__auto___47450 = arguments.length;
  var i__10376__auto___47451 = 0;
  while (true) {
    if (i__10376__auto___47451 < len__10375__auto___47450) {
      args47447.push(arguments[i__10376__auto___47451]);
      var G__47452 = i__10376__auto___47451 + 1;
      i__10376__auto___47451 = G__47452;
      continue;
    } else {
    }
    break;
  }
  var G__47449 = args47447.length;
  switch(G__47449) {
    case 1:
      return cljs.core.take.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.take.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args47447.length)].join(""));
  }
};
cljs.core.take.cljs$core$IFn$_invoke$arity$1 = function(n) {
  if (typeof n === "number") {
  } else {
    throw new Error("Assert failed: (number? n)");
  }
  return function(rf) {
    var na = cljs.core.volatile_BANG_(n);
    return function(na) {
      return function() {
        var G__47454 = null;
        var G__47454__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__47454__1 = function(result) {
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
        };
        var G__47454__2 = function(result, input) {
          var n__$1 = cljs.core.deref(na);
          var nn = cljs.core._vreset_BANG_(na, cljs.core._deref(na) - 1);
          var result__$1 = n__$1 > 0 ? rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, input) : rf.call(null, result, input) : result;
          if (!(nn > 0)) {
            return cljs.core.ensure_reduced(result__$1);
          } else {
            return result__$1;
          }
        };
        G__47454 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__47454__0.call(this);
            case 1:
              return G__47454__1.call(this, result);
            case 2:
              return G__47454__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + (arguments.length - 1));
        };
        G__47454.cljs$core$IFn$_invoke$arity$0 = G__47454__0;
        G__47454.cljs$core$IFn$_invoke$arity$1 = G__47454__1;
        G__47454.cljs$core$IFn$_invoke$arity$2 = G__47454__2;
        return G__47454;
      }();
    }(na);
  };
};
cljs.core.take.cljs$core$IFn$_invoke$arity$2 = function(n, coll) {
  if (typeof n === "number") {
  } else {
    throw new Error("Assert failed: (number? n)");
  }
  return new cljs.core.LazySeq(null, function() {
    if (n > 0) {
      var temp__6738__auto__ = cljs.core.seq(coll);
      if (temp__6738__auto__) {
        var s = temp__6738__auto__;
        return cljs.core.cons(cljs.core.first(s), cljs.core.take.cljs$core$IFn$_invoke$arity$2(n - 1, cljs.core.rest(s)));
      } else {
        return null;
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.take.cljs$lang$maxFixedArity = 2;
cljs.core.drop = function cljs$core$drop(var_args) {
  var args47455 = [];
  var len__10375__auto___47458 = arguments.length;
  var i__10376__auto___47459 = 0;
  while (true) {
    if (i__10376__auto___47459 < len__10375__auto___47458) {
      args47455.push(arguments[i__10376__auto___47459]);
      var G__47460 = i__10376__auto___47459 + 1;
      i__10376__auto___47459 = G__47460;
      continue;
    } else {
    }
    break;
  }
  var G__47457 = args47455.length;
  switch(G__47457) {
    case 1:
      return cljs.core.drop.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.drop.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args47455.length)].join(""));
  }
};
cljs.core.drop.cljs$core$IFn$_invoke$arity$1 = function(n) {
  if (typeof n === "number") {
  } else {
    throw new Error("Assert failed: (number? n)");
  }
  return function(rf) {
    var na = cljs.core.volatile_BANG_(n);
    return function(na) {
      return function() {
        var G__47462 = null;
        var G__47462__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__47462__1 = function(result) {
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
        };
        var G__47462__2 = function(result, input) {
          var n__$1 = cljs.core.deref(na);
          cljs.core._vreset_BANG_(na, cljs.core._deref(na) - 1);
          if (n__$1 > 0) {
            return result;
          } else {
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, input) : rf.call(null, result, input);
          }
        };
        G__47462 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__47462__0.call(this);
            case 1:
              return G__47462__1.call(this, result);
            case 2:
              return G__47462__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + (arguments.length - 1));
        };
        G__47462.cljs$core$IFn$_invoke$arity$0 = G__47462__0;
        G__47462.cljs$core$IFn$_invoke$arity$1 = G__47462__1;
        G__47462.cljs$core$IFn$_invoke$arity$2 = G__47462__2;
        return G__47462;
      }();
    }(na);
  };
};
cljs.core.drop.cljs$core$IFn$_invoke$arity$2 = function(n, coll) {
  if (typeof n === "number") {
  } else {
    throw new Error("Assert failed: (number? n)");
  }
  var step = function(n__$1, coll__$1) {
    while (true) {
      var s = cljs.core.seq(coll__$1);
      if (n__$1 > 0 && s) {
        var G__47463 = n__$1 - 1;
        var G__47464 = cljs.core.rest(s);
        n__$1 = G__47463;
        coll__$1 = G__47464;
        continue;
      } else {
        return s;
      }
      break;
    }
  };
  return new cljs.core.LazySeq(null, function(step) {
    return function() {
      return step(n, coll);
    };
  }(step), null, null);
};
cljs.core.drop.cljs$lang$maxFixedArity = 2;
cljs.core.drop_last = function cljs$core$drop_last(var_args) {
  var args47465 = [];
  var len__10375__auto___47468 = arguments.length;
  var i__10376__auto___47469 = 0;
  while (true) {
    if (i__10376__auto___47469 < len__10375__auto___47468) {
      args47465.push(arguments[i__10376__auto___47469]);
      var G__47470 = i__10376__auto___47469 + 1;
      i__10376__auto___47469 = G__47470;
      continue;
    } else {
    }
    break;
  }
  var G__47467 = args47465.length;
  switch(G__47467) {
    case 1:
      return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args47465.length)].join(""));
  }
};
cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1 = function(s) {
  return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2(1, s);
};
cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2 = function(n, s) {
  return cljs.core.map.cljs$core$IFn$_invoke$arity$3(function(x, _) {
    return x;
  }, s, cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n, s));
};
cljs.core.drop_last.cljs$lang$maxFixedArity = 2;
cljs.core.take_last = function cljs$core$take_last(n, coll) {
  var s = cljs.core.seq(coll);
  var lead = cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n, coll));
  while (true) {
    if (lead) {
      var G__47472 = cljs.core.next(s);
      var G__47473 = cljs.core.next(lead);
      s = G__47472;
      lead = G__47473;
      continue;
    } else {
      return s;
    }
    break;
  }
};
cljs.core.drop_while = function cljs$core$drop_while(var_args) {
  var args47474 = [];
  var len__10375__auto___47479 = arguments.length;
  var i__10376__auto___47480 = 0;
  while (true) {
    if (i__10376__auto___47480 < len__10375__auto___47479) {
      args47474.push(arguments[i__10376__auto___47480]);
      var G__47481 = i__10376__auto___47480 + 1;
      i__10376__auto___47480 = G__47481;
      continue;
    } else {
    }
    break;
  }
  var G__47476 = args47474.length;
  switch(G__47476) {
    case 1:
      return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args47474.length)].join(""));
  }
};
cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1 = function(pred) {
  return function(rf) {
    var da = cljs.core.volatile_BANG_(true);
    return function(da) {
      return function() {
        var G__47483 = null;
        var G__47483__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__47483__1 = function(result) {
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
        };
        var G__47483__2 = function(result, input) {
          var drop_QMARK_ = cljs.core.deref(da);
          if (cljs.core.truth_(function() {
            var and__9142__auto__ = drop_QMARK_;
            if (cljs.core.truth_(and__9142__auto__)) {
              return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null, input);
            } else {
              return and__9142__auto__;
            }
          }())) {
            return result;
          } else {
            cljs.core.vreset_BANG_(da, null);
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, input) : rf.call(null, result, input);
          }
        };
        G__47483 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__47483__0.call(this);
            case 1:
              return G__47483__1.call(this, result);
            case 2:
              return G__47483__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + (arguments.length - 1));
        };
        G__47483.cljs$core$IFn$_invoke$arity$0 = G__47483__0;
        G__47483.cljs$core$IFn$_invoke$arity$1 = G__47483__1;
        G__47483.cljs$core$IFn$_invoke$arity$2 = G__47483__2;
        return G__47483;
      }();
    }(da);
  };
};
cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2 = function(pred, coll) {
  var step = function(pred__$1, coll__$1) {
    while (true) {
      var s = cljs.core.seq(coll__$1);
      if (cljs.core.truth_(function() {
        var and__9142__auto__ = s;
        if (and__9142__auto__) {
          var G__47478 = cljs.core.first(s);
          return pred__$1.cljs$core$IFn$_invoke$arity$1 ? pred__$1.cljs$core$IFn$_invoke$arity$1(G__47478) : pred__$1.call(null, G__47478);
        } else {
          return and__9142__auto__;
        }
      }())) {
        var G__47484 = pred__$1;
        var G__47485 = cljs.core.rest(s);
        pred__$1 = G__47484;
        coll__$1 = G__47485;
        continue;
      } else {
        return s;
      }
      break;
    }
  };
  return new cljs.core.LazySeq(null, function(step) {
    return function() {
      return step(pred, coll);
    };
  }(step), null, null);
};
cljs.core.drop_while.cljs$lang$maxFixedArity = 2;
cljs.core.cycle = function cljs$core$cycle(coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__6738__auto__ = cljs.core.seq(coll);
    if (temp__6738__auto__) {
      var s = temp__6738__auto__;
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(s, cljs.core.cycle.cljs$core$IFn$_invoke$arity$1 ? cljs.core.cycle.cljs$core$IFn$_invoke$arity$1(s) : cljs.core.cycle.call(null, s));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.split_at = function cljs$core$split_at(n, coll) {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, coll), cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n, coll)], null);
};
cljs.core.repeat = function cljs$core$repeat(var_args) {
  var args47486 = [];
  var len__10375__auto___47489 = arguments.length;
  var i__10376__auto___47490 = 0;
  while (true) {
    if (i__10376__auto___47490 < len__10375__auto___47489) {
      args47486.push(arguments[i__10376__auto___47490]);
      var G__47491 = i__10376__auto___47490 + 1;
      i__10376__auto___47490 = G__47491;
      continue;
    } else {
    }
    break;
  }
  var G__47488 = args47486.length;
  switch(G__47488) {
    case 1:
      return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args47486.length)].join(""));
  }
};
cljs.core.repeat.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return new cljs.core.LazySeq(null, function() {
    return cljs.core.cons(x, cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
  }, null, null);
};
cljs.core.repeat.cljs$core$IFn$_invoke$arity$2 = function(n, x) {
  return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
};
cljs.core.repeat.cljs$lang$maxFixedArity = 2;
cljs.core.replicate = function cljs$core$replicate(n, x) {
  return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
};
cljs.core.repeatedly = function cljs$core$repeatedly(var_args) {
  var args47493 = [];
  var len__10375__auto___47496 = arguments.length;
  var i__10376__auto___47497 = 0;
  while (true) {
    if (i__10376__auto___47497 < len__10375__auto___47496) {
      args47493.push(arguments[i__10376__auto___47497]);
      var G__47498 = i__10376__auto___47497 + 1;
      i__10376__auto___47497 = G__47498;
      continue;
    } else {
    }
    break;
  }
  var G__47495 = args47493.length;
  switch(G__47495) {
    case 1:
      return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args47493.length)].join(""));
  }
};
cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return new cljs.core.LazySeq(null, function() {
    return cljs.core.cons(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null), cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
  }, null, null);
};
cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2 = function(n, f) {
  return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
};
cljs.core.repeatedly.cljs$lang$maxFixedArity = 2;
cljs.core.iterate = function cljs$core$iterate(f, x) {
  return cljs.core.cons(x, new cljs.core.LazySeq(null, function() {
    var G__47502 = f;
    var G__47503 = f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null, x);
    return cljs.core.iterate.cljs$core$IFn$_invoke$arity$2 ? cljs.core.iterate.cljs$core$IFn$_invoke$arity$2(G__47502, G__47503) : cljs.core.iterate.call(null, G__47502, G__47503);
  }, null, null));
};
cljs.core.interleave = function cljs$core$interleave(var_args) {
  var args47504 = [];
  var len__10375__auto___47510 = arguments.length;
  var i__10376__auto___47511 = 0;
  while (true) {
    if (i__10376__auto___47511 < len__10375__auto___47510) {
      args47504.push(arguments[i__10376__auto___47511]);
      var G__47512 = i__10376__auto___47511 + 1;
      i__10376__auto___47511 = G__47512;
      continue;
    } else {
    }
    break;
  }
  var G__47509 = args47504.length;
  switch(G__47509) {
    case 0:
      return cljs.core.interleave.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.interleave.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args47504.slice(2), 0, null);
      return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__10398__auto__);
  }
};
cljs.core.interleave.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.List.EMPTY;
};
cljs.core.interleave.cljs$core$IFn$_invoke$arity$1 = function(c1) {
  return new cljs.core.LazySeq(null, function() {
    return c1;
  }, null, null);
};
cljs.core.interleave.cljs$core$IFn$_invoke$arity$2 = function(c1, c2) {
  return new cljs.core.LazySeq(null, function() {
    var s1 = cljs.core.seq(c1);
    var s2 = cljs.core.seq(c2);
    if (s1 && s2) {
      return cljs.core.cons(cljs.core.first(s1), cljs.core.cons(cljs.core.first(s2), cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1), cljs.core.rest(s2))));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic = function(c1, c2, colls) {
  return new cljs.core.LazySeq(null, function() {
    var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq, cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls, c2, cljs.core.array_seq([c1], 0)));
    if (cljs.core.every_QMARK_(cljs.core.identity, ss)) {
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first, ss), cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.interleave, cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest, ss)));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.interleave.cljs$lang$applyTo = function(seq47505) {
  var G__47506 = cljs.core.first(seq47505);
  var seq47505__$1 = cljs.core.next(seq47505);
  var G__47507 = cljs.core.first(seq47505__$1);
  var seq47505__$2 = cljs.core.next(seq47505__$1);
  return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic(G__47506, G__47507, seq47505__$2);
};
cljs.core.interleave.cljs$lang$maxFixedArity = 2;
cljs.core.interpose = function cljs$core$interpose(var_args) {
  var args47514 = [];
  var len__10375__auto___47517 = arguments.length;
  var i__10376__auto___47518 = 0;
  while (true) {
    if (i__10376__auto___47518 < len__10375__auto___47517) {
      args47514.push(arguments[i__10376__auto___47518]);
      var G__47519 = i__10376__auto___47518 + 1;
      i__10376__auto___47518 = G__47519;
      continue;
    } else {
    }
    break;
  }
  var G__47516 = args47514.length;
  switch(G__47516) {
    case 1:
      return cljs.core.interpose.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args47514.length)].join(""));
  }
};
cljs.core.interpose.cljs$core$IFn$_invoke$arity$1 = function(sep) {
  return function(rf) {
    var started = cljs.core.volatile_BANG_(false);
    return function(started) {
      return function() {
        var G__47521 = null;
        var G__47521__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__47521__1 = function(result) {
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
        };
        var G__47521__2 = function(result, input) {
          if (cljs.core.truth_(cljs.core.deref(started))) {
            var sepr = rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, sep) : rf.call(null, result, sep);
            if (cljs.core.reduced_QMARK_(sepr)) {
              return sepr;
            } else {
              return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(sepr, input) : rf.call(null, sepr, input);
            }
          } else {
            cljs.core.vreset_BANG_(started, true);
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, input) : rf.call(null, result, input);
          }
        };
        G__47521 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__47521__0.call(this);
            case 1:
              return G__47521__1.call(this, result);
            case 2:
              return G__47521__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + (arguments.length - 1));
        };
        G__47521.cljs$core$IFn$_invoke$arity$0 = G__47521__0;
        G__47521.cljs$core$IFn$_invoke$arity$1 = G__47521__1;
        G__47521.cljs$core$IFn$_invoke$arity$2 = G__47521__2;
        return G__47521;
      }();
    }(started);
  };
};
cljs.core.interpose.cljs$core$IFn$_invoke$arity$2 = function(sep, coll) {
  return cljs.core.drop.cljs$core$IFn$_invoke$arity$2(1, cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(sep), coll));
};
cljs.core.interpose.cljs$lang$maxFixedArity = 2;
cljs.core.flatten1 = function cljs$core$flatten1(colls) {
  var cat = function cljs$core$flatten1_$_cat(coll, colls__$1) {
    return new cljs.core.LazySeq(null, function() {
      var temp__6736__auto__ = cljs.core.seq(coll);
      if (temp__6736__auto__) {
        var coll__$1 = temp__6736__auto__;
        return cljs.core.cons(cljs.core.first(coll__$1), cljs$core$flatten1_$_cat(cljs.core.rest(coll__$1), colls__$1));
      } else {
        if (cljs.core.seq(colls__$1)) {
          return cljs$core$flatten1_$_cat(cljs.core.first(colls__$1), cljs.core.rest(colls__$1));
        } else {
          return null;
        }
      }
    }, null, null);
  };
  return cat(null, colls);
};
cljs.core.mapcat = function cljs$core$mapcat(var_args) {
  var args47530 = [];
  var len__10375__auto___47535 = arguments.length;
  var i__10376__auto___47536 = 0;
  while (true) {
    if (i__10376__auto___47536 < len__10375__auto___47535) {
      args47530.push(arguments[i__10376__auto___47536]);
      var G__47537 = i__10376__auto___47536 + 1;
      i__10376__auto___47536 = G__47537;
      continue;
    } else {
    }
    break;
  }
  var G__47534 = args47530.length;
  switch(G__47534) {
    case 1:
      return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args47530.slice(1), 0, null);
      return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__10398__auto__);
  }
};
cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(f), cljs.core.cat);
};
cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic = function(f, colls) {
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat, cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.map, f, colls));
};
cljs.core.mapcat.cljs$lang$applyTo = function(seq47531) {
  var G__47532 = cljs.core.first(seq47531);
  var seq47531__$1 = cljs.core.next(seq47531);
  return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(G__47532, seq47531__$1);
};
cljs.core.mapcat.cljs$lang$maxFixedArity = 1;
cljs.core.filter = function cljs$core$filter(var_args) {
  var args47539 = [];
  var len__10375__auto___47543 = arguments.length;
  var i__10376__auto___47544 = 0;
  while (true) {
    if (i__10376__auto___47544 < len__10375__auto___47543) {
      args47539.push(arguments[i__10376__auto___47544]);
      var G__47545 = i__10376__auto___47544 + 1;
      i__10376__auto___47544 = G__47545;
      continue;
    } else {
    }
    break;
  }
  var G__47541 = args47539.length;
  switch(G__47541) {
    case 1:
      return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args47539.length)].join(""));
  }
};
cljs.core.filter.cljs$core$IFn$_invoke$arity$1 = function(pred) {
  return function(rf) {
    return function() {
      var G__47547 = null;
      var G__47547__0 = function() {
        return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
      };
      var G__47547__1 = function(result) {
        return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
      };
      var G__47547__2 = function(result, input) {
        if (cljs.core.truth_(pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null, input))) {
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, input) : rf.call(null, result, input);
        } else {
          return result;
        }
      };
      G__47547 = function(result, input) {
        switch(arguments.length) {
          case 0:
            return G__47547__0.call(this);
          case 1:
            return G__47547__1.call(this, result);
          case 2:
            return G__47547__2.call(this, result, input);
        }
        throw new Error("Invalid arity: " + (arguments.length - 1));
      };
      G__47547.cljs$core$IFn$_invoke$arity$0 = G__47547__0;
      G__47547.cljs$core$IFn$_invoke$arity$1 = G__47547__1;
      G__47547.cljs$core$IFn$_invoke$arity$2 = G__47547__2;
      return G__47547;
    }();
  };
};
cljs.core.filter.cljs$core$IFn$_invoke$arity$2 = function(pred, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__6738__auto__ = cljs.core.seq(coll);
    if (temp__6738__auto__) {
      var s = temp__6738__auto__;
      if (cljs.core.chunked_seq_QMARK_(s)) {
        var c = cljs.core.chunk_first(s);
        var size = cljs.core.count(c);
        var b = cljs.core.chunk_buffer(size);
        var n__10175__auto___47548 = size;
        var i_47549 = 0;
        while (true) {
          if (i_47549 < n__10175__auto___47548) {
            if (cljs.core.truth_(function() {
              var G__47542 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_47549);
              return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__47542) : pred.call(null, G__47542);
            }())) {
              cljs.core.chunk_append(b, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_47549));
            } else {
            }
            var G__47550 = i_47549 + 1;
            i_47549 = G__47550;
            continue;
          } else {
          }
          break;
        }
        return cljs.core.chunk_cons(cljs.core.chunk(b), cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred, cljs.core.chunk_rest(s)));
      } else {
        var f = cljs.core.first(s);
        var r = cljs.core.rest(s);
        if (cljs.core.truth_(pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(f) : pred.call(null, f))) {
          return cljs.core.cons(f, cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred, r));
        } else {
          return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred, r);
        }
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.filter.cljs$lang$maxFixedArity = 2;
cljs.core.remove = function cljs$core$remove(var_args) {
  var args47551 = [];
  var len__10375__auto___47554 = arguments.length;
  var i__10376__auto___47555 = 0;
  while (true) {
    if (i__10376__auto___47555 < len__10375__auto___47554) {
      args47551.push(arguments[i__10376__auto___47555]);
      var G__47556 = i__10376__auto___47555 + 1;
      i__10376__auto___47555 = G__47556;
      continue;
    } else {
    }
    break;
  }
  var G__47553 = args47551.length;
  switch(G__47553) {
    case 1:
      return cljs.core.remove.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args47551.length)].join(""));
  }
};
cljs.core.remove.cljs$core$IFn$_invoke$arity$1 = function(pred) {
  return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(cljs.core.complement(pred));
};
cljs.core.remove.cljs$core$IFn$_invoke$arity$2 = function(pred, coll) {
  return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(pred), coll);
};
cljs.core.remove.cljs$lang$maxFixedArity = 2;
cljs.core.tree_seq = function cljs$core$tree_seq(branch_QMARK_, children, root) {
  var walk = function cljs$core$tree_seq_$_walk(node) {
    return new cljs.core.LazySeq(null, function() {
      return cljs.core.cons(node, cljs.core.truth_(branch_QMARK_.cljs$core$IFn$_invoke$arity$1 ? branch_QMARK_.cljs$core$IFn$_invoke$arity$1(node) : branch_QMARK_.call(null, node)) ? cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs$core$tree_seq_$_walk, cljs.core.array_seq([children.cljs$core$IFn$_invoke$arity$1 ? children.cljs$core$IFn$_invoke$arity$1(node) : children.call(null, node)], 0)) : null);
    }, null, null);
  };
  return walk(root);
};
cljs.core.flatten = function cljs$core$flatten(x) {
  return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(function(p1__47558_SHARP_) {
    return !cljs.core.sequential_QMARK_(p1__47558_SHARP_);
  }, cljs.core.rest(cljs.core.tree_seq(cljs.core.sequential_QMARK_, cljs.core.seq, x)));
};
cljs.core.into = function cljs$core$into(var_args) {
  var args47559 = [];
  var len__10375__auto___47564 = arguments.length;
  var i__10376__auto___47565 = 0;
  while (true) {
    if (i__10376__auto___47565 < len__10375__auto___47564) {
      args47559.push(arguments[i__10376__auto___47565]);
      var G__47566 = i__10376__auto___47565 + 1;
      i__10376__auto___47565 = G__47566;
      continue;
    } else {
    }
    break;
  }
  var G__47561 = args47559.length;
  switch(G__47561) {
    case 0:
      return cljs.core.into.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.into.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.into.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.into.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args47559.length)].join(""));
  }
};
cljs.core.into.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.PersistentVector.EMPTY;
};
cljs.core.into.cljs$core$IFn$_invoke$arity$1 = function(to) {
  return to;
};
cljs.core.into.cljs$core$IFn$_invoke$arity$2 = function(to, from) {
  if (!(to == null)) {
    if (!(to == null) ? to.cljs$lang$protocol_mask$partition1$ & 4 || cljs.core.PROTOCOL_SENTINEL === to.cljs$core$IEditableCollection$ ? true : false : false) {
      return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_, cljs.core.transient$(to), from)), cljs.core.meta(to));
    } else {
      return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj, to, from);
    }
  } else {
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj, cljs.core.List.EMPTY, from);
  }
};
cljs.core.into.cljs$core$IFn$_invoke$arity$3 = function(to, xform, from) {
  if (!(to == null) ? to.cljs$lang$protocol_mask$partition1$ & 4 || cljs.core.PROTOCOL_SENTINEL === to.cljs$core$IEditableCollection$ ? true : false : false) {
    return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform, cljs.core.conj_BANG_, cljs.core.transient$(to), from)), cljs.core.meta(to));
  } else {
    return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform, cljs.core.conj, to, from);
  }
};
cljs.core.into.cljs$lang$maxFixedArity = 3;
cljs.core.mapv = function cljs$core$mapv(var_args) {
  var args47568 = [];
  var len__10375__auto___47576 = arguments.length;
  var i__10376__auto___47577 = 0;
  while (true) {
    if (i__10376__auto___47577 < len__10375__auto___47576) {
      args47568.push(arguments[i__10376__auto___47577]);
      var G__47578 = i__10376__auto___47577 + 1;
      i__10376__auto___47577 = G__47578;
      continue;
    } else {
    }
    break;
  }
  var G__47575 = args47568.length;
  switch(G__47575) {
    case 2:
      return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.mapv.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.mapv.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args47568.slice(4), 0, null);
      return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__10398__auto__);
  }
};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(v, o) {
    return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v, f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(o) : f.call(null, o));
  }, cljs.core.transient$(cljs.core.PersistentVector.EMPTY), coll));
};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$3 = function(f, c1, c2) {
  return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY, cljs.core.map.cljs$core$IFn$_invoke$arity$3(f, c1, c2));
};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$4 = function(f, c1, c2, c3) {
  return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY, cljs.core.map.cljs$core$IFn$_invoke$arity$4(f, c1, c2, c3));
};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic = function(f, c1, c2, c3, colls) {
  return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.map, f, c1, c2, c3, cljs.core.array_seq([colls], 0)));
};
cljs.core.mapv.cljs$lang$applyTo = function(seq47569) {
  var G__47570 = cljs.core.first(seq47569);
  var seq47569__$1 = cljs.core.next(seq47569);
  var G__47571 = cljs.core.first(seq47569__$1);
  var seq47569__$2 = cljs.core.next(seq47569__$1);
  var G__47572 = cljs.core.first(seq47569__$2);
  var seq47569__$3 = cljs.core.next(seq47569__$2);
  var G__47573 = cljs.core.first(seq47569__$3);
  var seq47569__$4 = cljs.core.next(seq47569__$3);
  return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic(G__47570, G__47571, G__47572, G__47573, seq47569__$4);
};
cljs.core.mapv.cljs$lang$maxFixedArity = 4;
cljs.core.filterv = function cljs$core$filterv(pred, coll) {
  return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(v, o) {
    if (cljs.core.truth_(pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(o) : pred.call(null, o))) {
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v, o);
    } else {
      return v;
    }
  }, cljs.core.transient$(cljs.core.PersistentVector.EMPTY), coll));
};
cljs.core.partition = function cljs$core$partition(var_args) {
  var args47580 = [];
  var len__10375__auto___47583 = arguments.length;
  var i__10376__auto___47584 = 0;
  while (true) {
    if (i__10376__auto___47584 < len__10375__auto___47583) {
      args47580.push(arguments[i__10376__auto___47584]);
      var G__47585 = i__10376__auto___47584 + 1;
      i__10376__auto___47584 = G__47585;
      continue;
    } else {
    }
    break;
  }
  var G__47582 = args47580.length;
  switch(G__47582) {
    case 2:
      return cljs.core.partition.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.partition.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args47580.length)].join(""));
  }
};
cljs.core.partition.cljs$core$IFn$_invoke$arity$2 = function(n, coll) {
  return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n, n, coll);
};
cljs.core.partition.cljs$core$IFn$_invoke$arity$3 = function(n, step, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__6738__auto__ = cljs.core.seq(coll);
    if (temp__6738__auto__) {
      var s = temp__6738__auto__;
      var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, s);
      if (n === cljs.core.count(p)) {
        return cljs.core.cons(p, cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n, step, cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step, s)));
      } else {
        return null;
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.partition.cljs$core$IFn$_invoke$arity$4 = function(n, step, pad, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__6738__auto__ = cljs.core.seq(coll);
    if (temp__6738__auto__) {
      var s = temp__6738__auto__;
      var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, s);
      if (n === cljs.core.count(p)) {
        return cljs.core.cons(p, cljs.core.partition.cljs$core$IFn$_invoke$arity$4(n, step, pad, cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step, s)));
      } else {
        var x__10088__auto__ = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.concat.cljs$core$IFn$_invoke$arity$2(p, pad));
        return cljs.core._conj(cljs.core.List.EMPTY, x__10088__auto__);
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.partition.cljs$lang$maxFixedArity = 4;
cljs.core.get_in = function cljs$core$get_in(var_args) {
  var args47587 = [];
  var len__10375__auto___47590 = arguments.length;
  var i__10376__auto___47591 = 0;
  while (true) {
    if (i__10376__auto___47591 < len__10375__auto___47590) {
      args47587.push(arguments[i__10376__auto___47591]);
      var G__47592 = i__10376__auto___47591 + 1;
      i__10376__auto___47591 = G__47592;
      continue;
    } else {
    }
    break;
  }
  var G__47589 = args47587.length;
  switch(G__47589) {
    case 2:
      return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args47587.length)].join(""));
  }
};
cljs.core.get_in.cljs$core$IFn$_invoke$arity$2 = function(m, ks) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.get, m, ks);
};
cljs.core.get_in.cljs$core$IFn$_invoke$arity$3 = function(m, ks, not_found) {
  var sentinel = cljs.core.lookup_sentinel;
  var m__$1 = m;
  var ks__$1 = cljs.core.seq(ks);
  while (true) {
    if (!(ks__$1 == null)) {
      var m__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1, cljs.core.first(ks__$1), sentinel);
      if (sentinel === m__$2) {
        return not_found;
      } else {
        var G__47594 = sentinel;
        var G__47595 = m__$2;
        var G__47596 = cljs.core.next(ks__$1);
        sentinel = G__47594;
        m__$1 = G__47595;
        ks__$1 = G__47596;
        continue;
      }
    } else {
      return m__$1;
    }
    break;
  }
};
cljs.core.get_in.cljs$lang$maxFixedArity = 3;
cljs.core.assoc_in = function cljs$core$assoc_in(m, p__47597, v) {
  var vec__47604 = p__47597;
  var seq__47605 = cljs.core.seq(vec__47604);
  var first__47606 = cljs.core.first(seq__47605);
  var seq__47605__$1 = cljs.core.next(seq__47605);
  var k = first__47606;
  var ks = seq__47605__$1;
  if (ks) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__47607 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      var G__47608 = ks;
      var G__47609 = v;
      return cljs.core.assoc_in.cljs$core$IFn$_invoke$arity$3 ? cljs.core.assoc_in.cljs$core$IFn$_invoke$arity$3(G__47607, G__47608, G__47609) : cljs.core.assoc_in.call(null, G__47607, G__47608, G__47609);
    }());
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, v);
  }
};
cljs.core.update_in = function cljs$core$update_in(var_args) {
  var args47610 = [];
  var len__10375__auto___47650 = arguments.length;
  var i__10376__auto___47651 = 0;
  while (true) {
    if (i__10376__auto___47651 < len__10375__auto___47650) {
      args47610.push(arguments[i__10376__auto___47651]);
      var G__47652 = i__10376__auto___47651 + 1;
      i__10376__auto___47651 = G__47652;
      continue;
    } else {
    }
    break;
  }
  var G__47619 = args47610.length;
  switch(G__47619) {
    case 3:
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args47610.slice(6), 0, null);
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], argseq__10398__auto__);
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$3 = function(m, p__47620, f) {
  var vec__47621 = p__47620;
  var seq__47622 = cljs.core.seq(vec__47621);
  var first__47623 = cljs.core.first(seq__47622);
  var seq__47622__$1 = cljs.core.next(seq__47622);
  var k = first__47623;
  var ks = seq__47622__$1;
  if (ks) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__47624 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__47624) : f.call(null, G__47624);
    }());
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$4 = function(m, p__47625, f, a) {
  var vec__47626 = p__47625;
  var seq__47627 = cljs.core.seq(vec__47626);
  var first__47628 = cljs.core.first(seq__47627);
  var seq__47627__$1 = cljs.core.next(seq__47627);
  var k = first__47628;
  var ks = seq__47627__$1;
  if (ks) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f, a));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__47629 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      var G__47630 = a;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__47629, G__47630) : f.call(null, G__47629, G__47630);
    }());
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$5 = function(m, p__47631, f, a, b) {
  var vec__47632 = p__47631;
  var seq__47633 = cljs.core.seq(vec__47632);
  var first__47634 = cljs.core.first(seq__47633);
  var seq__47633__$1 = cljs.core.next(seq__47633);
  var k = first__47634;
  var ks = seq__47633__$1;
  if (ks) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f, a, b));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__47635 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      var G__47636 = a;
      var G__47637 = b;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__47635, G__47636, G__47637) : f.call(null, G__47635, G__47636, G__47637);
    }());
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$6 = function(m, p__47638, f, a, b, c) {
  var vec__47639 = p__47638;
  var seq__47640 = cljs.core.seq(vec__47639);
  var first__47641 = cljs.core.first(seq__47640);
  var seq__47640__$1 = cljs.core.next(seq__47640);
  var k = first__47641;
  var ks = seq__47640__$1;
  if (ks) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f, a, b, c));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__47642 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      var G__47643 = a;
      var G__47644 = b;
      var G__47645 = c;
      return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__47642, G__47643, G__47644, G__47645) : f.call(null, G__47642, G__47643, G__47644, G__47645);
    }());
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic = function(m, p__47646, f, a, b, c, args) {
  var vec__47647 = p__47646;
  var seq__47648 = cljs.core.seq(vec__47647);
  var first__47649 = cljs.core.first(seq__47648);
  var seq__47648__$1 = cljs.core.next(seq__47648);
  var k = first__47649;
  var ks = seq__47648__$1;
  if (ks) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.update_in, cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f, a, cljs.core.array_seq([b, c, args], 0)));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), a, b, c, cljs.core.array_seq([args], 0)));
  }
};
cljs.core.update_in.cljs$lang$applyTo = function(seq47611) {
  var G__47612 = cljs.core.first(seq47611);
  var seq47611__$1 = cljs.core.next(seq47611);
  var G__47613 = cljs.core.first(seq47611__$1);
  var seq47611__$2 = cljs.core.next(seq47611__$1);
  var G__47614 = cljs.core.first(seq47611__$2);
  var seq47611__$3 = cljs.core.next(seq47611__$2);
  var G__47615 = cljs.core.first(seq47611__$3);
  var seq47611__$4 = cljs.core.next(seq47611__$3);
  var G__47616 = cljs.core.first(seq47611__$4);
  var seq47611__$5 = cljs.core.next(seq47611__$4);
  var G__47617 = cljs.core.first(seq47611__$5);
  var seq47611__$6 = cljs.core.next(seq47611__$5);
  return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic(G__47612, G__47613, G__47614, G__47615, G__47616, G__47617, seq47611__$6);
};
cljs.core.update_in.cljs$lang$maxFixedArity = 6;
cljs.core.update = function cljs$core$update(var_args) {
  var args47654 = [];
  var len__10375__auto___47674 = arguments.length;
  var i__10376__auto___47675 = 0;
  while (true) {
    if (i__10376__auto___47675 < len__10375__auto___47674) {
      args47654.push(arguments[i__10376__auto___47675]);
      var G__47676 = i__10376__auto___47675 + 1;
      i__10376__auto___47675 = G__47676;
      continue;
    } else {
    }
    break;
  }
  var G__47663 = args47654.length;
  switch(G__47663) {
    case 3:
      return cljs.core.update.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.update.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.update.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core.update.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      var argseq__10398__auto__ = new cljs.core.IndexedSeq(args47654.slice(6), 0, null);
      return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], argseq__10398__auto__);
  }
};
cljs.core.update.cljs$core$IFn$_invoke$arity$3 = function(m, k, f) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
    var G__47664 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
    return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__47664) : f.call(null, G__47664);
  }());
};
cljs.core.update.cljs$core$IFn$_invoke$arity$4 = function(m, k, f, x) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
    var G__47665 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
    var G__47666 = x;
    return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__47665, G__47666) : f.call(null, G__47665, G__47666);
  }());
};
cljs.core.update.cljs$core$IFn$_invoke$arity$5 = function(m, k, f, x, y) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
    var G__47667 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
    var G__47668 = x;
    var G__47669 = y;
    return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__47667, G__47668, G__47669) : f.call(null, G__47667, G__47668, G__47669);
  }());
};
cljs.core.update.cljs$core$IFn$_invoke$arity$6 = function(m, k, f, x, y, z) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
    var G__47670 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
    var G__47671 = x;
    var G__47672 = y;
    var G__47673 = z;
    return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__47670, G__47671, G__47672, G__47673) : f.call(null, G__47670, G__47671, G__47672, G__47673);
  }());
};
cljs.core.update.cljs$core$IFn$_invoke$arity$variadic = function(m, k, f, x, y, z, more) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), x, y, z, cljs.core.array_seq([more], 0)));
};
cljs.core.update.cljs$lang$applyTo = function(seq47655) {
  var G__47656 = cljs.core.first(seq47655);
  var seq47655__$1 = cljs.core.next(seq47655);
  var G__47657 = cljs.core.first(seq47655__$1);
  var seq47655__$2 = cljs.core.next(seq47655__$1);
  var G__47658 = cljs.core.first(seq47655__$2);
  var seq47655__$3 = cljs.core.next(seq47655__$2);
  var G__47659 = cljs.core.first(seq47655__$3);
  var seq47655__$4 = cljs.core.next(seq47655__$3);
  var G__47660 = cljs.core.first(seq47655__$4);
  var seq47655__$5 = cljs.core.next(seq47655__$4);
  var G__47661 = cljs.core.first(seq47655__$5);
  var seq47655__$6 = cljs.core.next(seq47655__$5);
  return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic(G__47656, G__47657, G__47658, G__47659, G__47660, G__47661, seq47655__$6);
};
cljs.core.update.cljs$lang$maxFixedArity = 6;
cljs.core.VectorNode = function(edit, arr) {
  this.edit = edit;
  this.arr = arr;
};
cljs.core.VectorNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "edit", "edit", -1302639, null), new cljs.core.Symbol(null, "arr", "arr", 2115492975, null)], null);
};
cljs.core.VectorNode.cljs$lang$type = true;
cljs.core.VectorNode.cljs$lang$ctorStr = "cljs.core/VectorNode";
cljs.core.VectorNode.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/VectorNode");
};
cljs.core.__GT_VectorNode = function cljs$core$__GT_VectorNode(edit, arr) {
  return new cljs.core.VectorNode(edit, arr);
};
cljs.core.pv_fresh_node = function cljs$core$pv_fresh_node(edit) {
  return new cljs.core.VectorNode(edit, [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null]);
};
cljs.core.pv_aget = function cljs$core$pv_aget(node, idx) {
  return node.arr[idx];
};
cljs.core.pv_aset = function cljs$core$pv_aset(node, idx, val) {
  return node.arr[idx] = val;
};
cljs.core.pv_clone_node = function cljs$core$pv_clone_node(node) {
  return new cljs.core.VectorNode(node.edit, cljs.core.aclone(node.arr));
};
cljs.core.tail_off = function cljs$core$tail_off(pv) {
  var cnt = pv.cnt;
  if (cnt < 32) {
    return 0;
  } else {
    return cnt - 1 >>> 5 << 5;
  }
};
cljs.core.new_path = function cljs$core$new_path(edit, level, node) {
  var ll = level;
  var ret = node;
  while (true) {
    if (ll === 0) {
      return ret;
    } else {
      var embed = ret;
      var r = cljs.core.pv_fresh_node(edit);
      var _ = cljs.core.pv_aset(r, 0, embed);
      var G__47678 = ll - 5;
      var G__47679 = r;
      ll = G__47678;
      ret = G__47679;
      continue;
    }
    break;
  }
};
cljs.core.push_tail = function cljs$core$push_tail(pv, level, parent, tailnode) {
  var ret = cljs.core.pv_clone_node(parent);
  var subidx = pv.cnt - 1 >>> level & 31;
  if (5 === level) {
    cljs.core.pv_aset(ret, subidx, tailnode);
    return ret;
  } else {
    var child = cljs.core.pv_aget(parent, subidx);
    if (!(child == null)) {
      var node_to_insert = function() {
        var G__47684 = pv;
        var G__47685 = level - 5;
        var G__47686 = child;
        var G__47687 = tailnode;
        return cljs.core.push_tail.cljs$core$IFn$_invoke$arity$4 ? cljs.core.push_tail.cljs$core$IFn$_invoke$arity$4(G__47684, G__47685, G__47686, G__47687) : cljs.core.push_tail.call(null, G__47684, G__47685, G__47686, G__47687);
      }();
      cljs.core.pv_aset(ret, subidx, node_to_insert);
      return ret;
    } else {
      var node_to_insert = cljs.core.new_path(null, level - 5, tailnode);
      cljs.core.pv_aset(ret, subidx, node_to_insert);
      return ret;
    }
  }
};
cljs.core.vector_index_out_of_bounds = function cljs$core$vector_index_out_of_bounds(i, cnt) {
  throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No item "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(i), cljs.core.str.cljs$core$IFn$_invoke$arity$1(" in vector of length "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(cnt)].join(""));
};
cljs.core.first_array_for_longvec = function cljs$core$first_array_for_longvec(pv) {
  var node = pv.root;
  var level = pv.shift;
  while (true) {
    if (level > 0) {
      var G__47688 = cljs.core.pv_aget(node, 0);
      var G__47689 = level - 5;
      node = G__47688;
      level = G__47689;
      continue;
    } else {
      return node.arr;
    }
    break;
  }
};
cljs.core.unchecked_array_for = function cljs$core$unchecked_array_for(pv, i) {
  if (i >= cljs.core.tail_off(pv)) {
    return pv.tail;
  } else {
    var node = pv.root;
    var level = pv.shift;
    while (true) {
      if (level > 0) {
        var G__47690 = cljs.core.pv_aget(node, i >>> level & 31);
        var G__47691 = level - 5;
        node = G__47690;
        level = G__47691;
        continue;
      } else {
        return node.arr;
      }
      break;
    }
  }
};
cljs.core.array_for = function cljs$core$array_for(pv, i) {
  if (0 <= i && i < pv.cnt) {
    return cljs.core.unchecked_array_for(pv, i);
  } else {
    return cljs.core.vector_index_out_of_bounds(i, pv.cnt);
  }
};
cljs.core.do_assoc = function cljs$core$do_assoc(pv, level, node, i, val) {
  var ret = cljs.core.pv_clone_node(node);
  if (level === 0) {
    cljs.core.pv_aset(ret, i & 31, val);
    return ret;
  } else {
    var subidx = i >>> level & 31;
    cljs.core.pv_aset(ret, subidx, function() {
      var G__47697 = pv;
      var G__47698 = level - 5;
      var G__47699 = cljs.core.pv_aget(node, subidx);
      var G__47700 = i;
      var G__47701 = val;
      return cljs.core.do_assoc.cljs$core$IFn$_invoke$arity$5 ? cljs.core.do_assoc.cljs$core$IFn$_invoke$arity$5(G__47697, G__47698, G__47699, G__47700, G__47701) : cljs.core.do_assoc.call(null, G__47697, G__47698, G__47699, G__47700, G__47701);
    }());
    return ret;
  }
};
cljs.core.pop_tail = function cljs$core$pop_tail(pv, level, node) {
  var subidx = pv.cnt - 2 >>> level & 31;
  if (level > 5) {
    var new_child = function() {
      var G__47705 = pv;
      var G__47706 = level - 5;
      var G__47707 = cljs.core.pv_aget(node, subidx);
      return cljs.core.pop_tail.cljs$core$IFn$_invoke$arity$3 ? cljs.core.pop_tail.cljs$core$IFn$_invoke$arity$3(G__47705, G__47706, G__47707) : cljs.core.pop_tail.call(null, G__47705, G__47706, G__47707);
    }();
    if (new_child == null && subidx === 0) {
      return null;
    } else {
      var ret = cljs.core.pv_clone_node(node);
      cljs.core.pv_aset(ret, subidx, new_child);
      return ret;
    }
  } else {
    if (subidx === 0) {
      return null;
    } else {
      var ret = cljs.core.pv_clone_node(node);
      cljs.core.pv_aset(ret, subidx, null);
      return ret;
    }
  }
};
cljs.core.RangedIterator = function(i, base, arr, v, start, end) {
  this.i = i;
  this.base = base;
  this.arr = arr;
  this.v = v;
  this.start = start;
  this.end = end;
};
cljs.core.RangedIterator.prototype.hasNext = function() {
  var self__ = this;
  var this$ = this;
  return self__.i < self__.end;
};
cljs.core.RangedIterator.prototype.next = function() {
  var self__ = this;
  var this$ = this;
  if (self__.i - self__.base === 32) {
    self__.arr = cljs.core.unchecked_array_for(self__.v, self__.i);
    self__.base = self__.base + 32;
  } else {
  }
  var ret = self__.arr[self__.i & 31];
  self__.i = self__.i + 1;
  return ret;
};
cljs.core.RangedIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "base", "base", 1825810849, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, 
  "arr", "arr", 2115492975, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), new cljs.core.Symbol(null, "v", "v", 1661996586, null), new cljs.core.Symbol(null, "start", "start", 1285322546, null), new cljs.core.Symbol(null, "end", "end", 1372345569, null)], null);
};
cljs.core.RangedIterator.cljs$lang$type = true;
cljs.core.RangedIterator.cljs$lang$ctorStr = "cljs.core/RangedIterator";
cljs.core.RangedIterator.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/RangedIterator");
};
cljs.core.__GT_RangedIterator = function cljs$core$__GT_RangedIterator(i, base, arr, v, start, end) {
  return new cljs.core.RangedIterator(i, base, arr, v, start, end);
};
cljs.core.ranged_iterator = function cljs$core$ranged_iterator(v, start, end) {
  var i = start;
  return new cljs.core.RangedIterator(i, i - i % 32, start < cljs.core.count(v) ? cljs.core.unchecked_array_for(v, i) : null, v, start, end);
};
cljs.core.PersistentVector = function(meta, cnt, shift, root, tail, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 167668511;
  this.cljs$lang$protocol_mask$partition1$ = 8196;
};
cljs.core.PersistentVector.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.PersistentVector.prototype.cljs$core$IFind$_find$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k, cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll__$1, k)], null);
};
cljs.core.PersistentVector.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentVector.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentVector.prototype.indexOf = function() {
  var G__47718 = null;
  var G__47718__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__47718__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__47718 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__47718__1.call(this, x);
      case 2:
        return G__47718__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__47718.cljs$core$IFn$_invoke$arity$1 = G__47718__1;
  G__47718.cljs$core$IFn$_invoke$arity$2 = G__47718__2;
  return G__47718;
}();
cljs.core.PersistentVector.prototype.lastIndexOf = function() {
  var G__47719 = null;
  var G__47719__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__47719__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__47719 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__47719__1.call(this, x);
      case 2:
        return G__47719__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__47719.cljs$core$IFn$_invoke$arity$1 = G__47719__1;
  G__47719.cljs$core$IFn$_invoke$arity$2 = G__47719__2;
  return G__47719;
}();
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1.cljs$core$ILookup$_lookup$arity$3(null, k, null);
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof k === "number") {
    return coll__$1.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
  } else {
    return not_found;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(v, f, init) {
  var self__ = this;
  var v__$1 = this;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < self__.cnt) {
      var arr = cljs.core.unchecked_array_for(v__$1, i);
      var len = arr.length;
      var init__$2 = function() {
        var j = 0;
        var init__$2 = init__$1;
        while (true) {
          if (j < len) {
            var init__$3 = function() {
              var G__47709 = init__$2;
              var G__47710 = j + i;
              var G__47711 = arr[j];
              return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__47709, G__47710, G__47711) : f.call(null, G__47709, G__47710, G__47711);
            }();
            if (cljs.core.reduced_QMARK_(init__$3)) {
              return init__$3;
            } else {
              var G__47720 = j + 1;
              var G__47721 = init__$3;
              j = G__47720;
              init__$2 = G__47721;
              continue;
            }
          } else {
            return init__$2;
          }
          break;
        }
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null, init__$2);
      } else {
        var G__47722 = i + len;
        var G__47723 = init__$2;
        i = G__47722;
        init__$1 = G__47723;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_for(coll__$1, n)[n & 31];
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (0 <= n && n < self__.cnt) {
    return cljs.core.unchecked_array_for(coll__$1, n)[n & 31];
  } else {
    return not_found;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var self__ = this;
  var coll__$1 = this;
  if (0 <= n && n < self__.cnt) {
    if (cljs.core.tail_off(coll__$1) <= n) {
      var new_tail = cljs.core.aclone(self__.tail);
      new_tail[n & 31] = val;
      return new cljs.core.PersistentVector(self__.meta, self__.cnt, self__.shift, self__.root, new_tail, null);
    } else {
      return new cljs.core.PersistentVector(self__.meta, self__.cnt, self__.shift, cljs.core.do_assoc(coll__$1, self__.shift, self__.root, n, val), self__.tail, null);
    }
  } else {
    if (n === self__.cnt) {
      return coll__$1.cljs$core$ICollection$_conj$arity$2(null, val);
    } else {
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Index "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(n), cljs.core.str.cljs$core$IFn$_invoke$arity$1(" out of bounds  [0,"), cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.cnt), cljs.core.str.cljs$core$IFn$_invoke$arity$1("]")].join(""));
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.PersistentVector.prototype.cljs$core$IIterable$_iterator$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.ranged_iterator(this$__$1, 0, self__.cnt);
};
cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentVector.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentVector(self__.meta, self__.cnt, self__.shift, self__.root, self__.tail, self__.__hash);
};
cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.cnt;
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_key$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1.cljs$core$IIndexed$_nth$arity$2(null, 0);
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_val$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1.cljs$core$IIndexed$_nth$arity$2(null, 1);
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    return coll__$1.cljs$core$IIndexed$_nth$arity$2(null, self__.cnt - 1);
  } else {
    return null;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt === 0) {
    throw new Error("Can't pop empty vector");
  } else {
    if (1 === self__.cnt) {
      return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY, self__.meta);
    } else {
      if (1 < self__.cnt - cljs.core.tail_off(coll__$1)) {
        return new cljs.core.PersistentVector(self__.meta, self__.cnt - 1, self__.shift, self__.root, self__.tail.slice(0, -1), null);
      } else {
        var new_tail = cljs.core.unchecked_array_for(coll__$1, self__.cnt - 2);
        var nr = cljs.core.pop_tail(coll__$1, self__.shift, self__.root);
        var new_root = nr == null ? cljs.core.PersistentVector.EMPTY_NODE : nr;
        var cnt_1 = self__.cnt - 1;
        if (5 < self__.shift && cljs.core.pv_aget(new_root, 1) == null) {
          return new cljs.core.PersistentVector(self__.meta, cnt_1, self__.shift - 5, cljs.core.pv_aget(new_root, 0), new_tail, null);
        } else {
          return new cljs.core.PersistentVector(self__.meta, cnt_1, self__.shift, new_root, new_tail, null);
        }
      }
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    return new cljs.core.RSeq(coll__$1, self__.cnt - 1, null);
  } else {
    return null;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__9596__auto__ = self__.__hash;
  if (!(h__9596__auto__ == null)) {
    return h__9596__auto__;
  } else {
    var h__9596__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__9596__auto____$1;
    return h__9596__auto____$1;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  if (other instanceof cljs.core.PersistentVector) {
    if (self__.cnt === cljs.core.count(other)) {
      var me_iter = coll__$1.cljs$core$IIterable$_iterator$arity$1(null);
      var you_iter = cljs.core._iterator(other);
      while (true) {
        if (me_iter.hasNext()) {
          var x = me_iter.next();
          var y = you_iter.next();
          if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y)) {
            continue;
          } else {
            return false;
          }
        } else {
          return true;
        }
        break;
      }
    } else {
      return false;
    }
  } else {
    return cljs.core.equiv_sequential(coll__$1, other);
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.TransientVector(self__.cnt, self__.shift, cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1(self__.root) : cljs.core.tv_editable_root.call(null, self__.root), cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1(self__.tail) : cljs.core.tv_editable_tail.call(null, self__.tail));
};
cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY, self__.meta);
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = function(v, f) {
  var self__ = this;
  var v__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(v__$1, f);
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = function(v, f, init) {
  var self__ = this;
  var v__$1 = this;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < self__.cnt) {
      var arr = cljs.core.unchecked_array_for(v__$1, i);
      var len = arr.length;
      var init__$2 = function() {
        var j = 0;
        var init__$2 = init__$1;
        while (true) {
          if (j < len) {
            var init__$3 = function() {
              var G__47712 = init__$2;
              var G__47713 = arr[j];
              return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__47712, G__47713) : f.call(null, G__47712, G__47713);
            }();
            if (cljs.core.reduced_QMARK_(init__$3)) {
              return init__$3;
            } else {
              var G__47724 = j + 1;
              var G__47725 = init__$3;
              j = G__47724;
              init__$2 = G__47725;
              continue;
            }
          } else {
            return init__$2;
          }
          break;
        }
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null, init__$2);
      } else {
        var G__47726 = i + len;
        var G__47727 = init__$2;
        i = G__47726;
        init__$1 = G__47727;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof k === "number") {
    return coll__$1.cljs$core$IVector$_assoc_n$arity$3(null, k, v);
  } else {
    throw new Error("Vector's key for assoc must be a number.");
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.integer_QMARK_(k)) {
    return 0 <= k && k < self__.cnt;
  } else {
    return false;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt === 0) {
    return null;
  } else {
    if (self__.cnt <= 32) {
      return new cljs.core.IndexedSeq(self__.tail, 0, null);
    } else {
      var G__47714 = coll__$1;
      var G__47715 = cljs.core.first_array_for_longvec(coll__$1);
      var G__47716 = 0;
      var G__47717 = 0;
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__47714, G__47715, G__47716, G__47717) : cljs.core.chunked_seq.call(null, G__47714, G__47715, G__47716, G__47717);
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentVector(meta__$1, self__.cnt, self__.shift, self__.root, self__.tail, self__.__hash);
};
cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt - cljs.core.tail_off(coll__$1) < 32) {
    var len = self__.tail.length;
    var new_tail = new Array(len + 1);
    var n__10175__auto___47728 = len;
    var i_47729 = 0;
    while (true) {
      if (i_47729 < n__10175__auto___47728) {
        new_tail[i_47729] = self__.tail[i_47729];
        var G__47730 = i_47729 + 1;
        i_47729 = G__47730;
        continue;
      } else {
      }
      break;
    }
    new_tail[len] = o;
    return new cljs.core.PersistentVector(self__.meta, self__.cnt + 1, self__.shift, self__.root, new_tail, null);
  } else {
    var root_overflow_QMARK_ = self__.cnt >>> 5 > 1 << self__.shift;
    var new_shift = root_overflow_QMARK_ ? self__.shift + 5 : self__.shift;
    var new_root = root_overflow_QMARK_ ? function() {
      var n_r = cljs.core.pv_fresh_node(null);
      cljs.core.pv_aset(n_r, 0, self__.root);
      cljs.core.pv_aset(n_r, 1, cljs.core.new_path(null, self__.shift, new cljs.core.VectorNode(null, self__.tail)));
      return n_r;
    }() : cljs.core.push_tail(coll__$1, self__.shift, self__.root, new cljs.core.VectorNode(null, self__.tail));
    return new cljs.core.PersistentVector(self__.meta, self__.cnt + 1, new_shift, new_root, [o], null);
  }
};
cljs.core.PersistentVector.prototype.call = function() {
  var G__47731 = null;
  var G__47731__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
  };
  var G__47731__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
  };
  G__47731 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__47731__2.call(this, self__, k);
      case 3:
        return G__47731__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__47731.cljs$core$IFn$_invoke$arity$2 = G__47731__2;
  G__47731.cljs$core$IFn$_invoke$arity$3 = G__47731__3;
  return G__47731;
}();
cljs.core.PersistentVector.prototype.apply = function(self__, args47708) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args47708)));
};
cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
};
cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
};
cljs.core.PersistentVector.getBasis = function() {
  return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "shift", "shift", -1657295705, null), new cljs.core.Symbol(null, "root", "root", 1191874074, null), new cljs.core.Symbol(null, "tail", "tail", 494507963, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 
  1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.PersistentVector.cljs$lang$type = true;
cljs.core.PersistentVector.cljs$lang$ctorStr = "cljs.core/PersistentVector";
cljs.core.PersistentVector.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/PersistentVector");
};
cljs.core.__GT_PersistentVector = function cljs$core$__GT_PersistentVector(meta, cnt, shift, root, tail, __hash) {
  return new cljs.core.PersistentVector(meta, cnt, shift, root, tail, __hash);
};
cljs.core.PersistentVector.EMPTY_NODE = new cljs.core.VectorNode(null, [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null]);
cljs.core.PersistentVector.EMPTY = new cljs.core.PersistentVector(null, 0, 5, cljs.core.PersistentVector.EMPTY_NODE, [], cljs.core.empty_ordered_hash);
cljs.core.PersistentVector.fromArray = function(xs, no_clone) {
  var l = xs.length;
  var xs__$1 = no_clone ? xs : cljs.core.aclone(xs);
  if (l < 32) {
    return new cljs.core.PersistentVector(null, l, 5, cljs.core.PersistentVector.EMPTY_NODE, xs__$1, null);
  } else {
    var node = xs__$1.slice(0, 32);
    var v = new cljs.core.PersistentVector(null, 32, 5, cljs.core.PersistentVector.EMPTY_NODE, node, null);
    var i = 32;
    var out = v.cljs$core$IEditableCollection$_as_transient$arity$1(null);
    while (true) {
      if (i < l) {
        var G__47732 = i + 1;
        var G__47733 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(out, xs__$1[i]);
        i = G__47732;
        out = G__47733;
        continue;
      } else {
        return cljs.core.persistent_BANG_(out);
      }
      break;
    }
  }
};
cljs.core.PersistentVector.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__10266__auto__ = this;
  return cljs.core.es6_iterator(this__10266__auto__);
};
cljs.core.vec = function cljs$core$vec(coll) {
  if (cljs.core.array_QMARK_(coll)) {
    return cljs.core.PersistentVector.fromArray(coll, true);
  } else {
    return cljs.core._persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_, cljs.core._as_transient(cljs.core.PersistentVector.EMPTY), coll));
  }
};
cljs.core.vector = function cljs$core$vector(var_args) {
  var args__10382__auto__ = [];
  var len__10375__auto___47735 = arguments.length;
  var i__10376__auto___47736 = 0;
  while (true) {
    if (i__10376__auto___47736 < len__10375__auto___47735) {
      args__10382__auto__.push(arguments[i__10376__auto___47736]);
      var G__47737 = i__10376__auto___47736 + 1;
      i__10376__auto___47736 = G__47737;
      continue;
    } else {
    }
    break;
  }
  var argseq__10383__auto__ = 0 < args__10382__auto__.length ? new cljs.core.IndexedSeq(args__10382__auto__.slice(0), 0, null) : null;
  return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(argseq__10383__auto__);
};
cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic = function(args) {
  if (args instanceof cljs.core.IndexedSeq && args.i === 0) {
    return cljs.core.PersistentVector.fromArray(args.arr, true);
  } else {
    return cljs.core.vec(args);
  }
};
cljs.core.vector.cljs$lang$maxFixedArity = 0;
cljs.core.vector.cljs$lang$applyTo = function(seq47734) {
  return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq47734));
};
cljs.core.ChunkedSeq = function(vec, node, i, off, meta, __hash) {
  this.vec = vec;
  this.node = node;
  this.i = i;
  this.off = off;
  this.meta = meta;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32375020;
  this.cljs$lang$protocol_mask$partition1$ = 1536;
};
cljs.core.ChunkedSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ChunkedSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ChunkedSeq.prototype.indexOf = function() {
  var G__47760 = null;
  var G__47760__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__47760__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__47760 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__47760__1.call(this, x);
      case 2:
        return G__47760__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__47760.cljs$core$IFn$_invoke$arity$1 = G__47760__1;
  G__47760.cljs$core$IFn$_invoke$arity$2 = G__47760__2;
  return G__47760;
}();
cljs.core.ChunkedSeq.prototype.lastIndexOf = function() {
  var G__47761 = null;
  var G__47761__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__47761__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__47761 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__47761__1.call(this, x);
      case 2:
        return G__47761__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__47761.cljs$core$IFn$_invoke$arity$1 = G__47761__1;
  G__47761.cljs$core$IFn$_invoke$arity$2 = G__47761__2;
  return G__47761;
}();
cljs.core.ChunkedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.off + 1 < self__.node.length) {
    var s = function() {
      var G__47738 = self__.vec;
      var G__47739 = self__.node;
      var G__47740 = self__.i;
      var G__47741 = self__.off + 1;
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__47738, G__47739, G__47740, G__47741) : cljs.core.chunked_seq.call(null, G__47738, G__47739, G__47740, G__47741);
    }();
    if (s == null) {
      return null;
    } else {
      return s;
    }
  } else {
    return coll__$1.cljs$core$IChunkedNext$_chunked_next$arity$1(null);
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__9596__auto__ = self__.__hash;
  if (!(h__9596__auto__ == null)) {
    return h__9596__auto__;
  } else {
    var h__9596__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__9596__auto____$1;
    return h__9596__auto____$1;
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY, self__.meta);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(function() {
    var G__47742 = self__.vec;
    var G__47743 = self__.i + self__.off;
    var G__47744 = cljs.core.count(self__.vec);
    return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__47742, G__47743, G__47744) : cljs.core.subvec.call(null, G__47742, G__47743, G__47744);
  }(), f);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(function() {
    var G__47745 = self__.vec;
    var G__47746 = self__.i + self__.off;
    var G__47747 = cljs.core.count(self__.vec);
    return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__47745, G__47746, G__47747) : cljs.core.subvec.call(null, G__47745, G__47746, G__47747);
  }(), f, start);
};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.node[self__.off];
};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.off + 1 < self__.node.length) {
    var s = function() {
      var G__47748 = self__.vec;
      var G__47749 = self__.node;
      var G__47750 = self__.i;
      var G__47751 = self__.off + 1;
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__47748, G__47749, G__47750, G__47751) : cljs.core.chunked_seq.call(null, G__47748, G__47749, G__47750, G__47751);
    }();
    if (s == null) {
      return cljs.core.List.EMPTY;
    } else {
      return s;
    }
  } else {
    return coll__$1.cljs$core$IChunkedSeq$_chunked_rest$arity$1(null);
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(self__.node, self__.off);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var end = self__.i + self__.node.length;
  if (end < cljs.core._count(self__.vec)) {
    var G__47752 = self__.vec;
    var G__47753 = cljs.core.unchecked_array_for(self__.vec, end);
    var G__47754 = end;
    var G__47755 = 0;
    return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__47752, G__47753, G__47754, G__47755) : cljs.core.chunked_seq.call(null, G__47752, G__47753, G__47754, G__47755);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, m) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(self__.vec, self__.node, self__.i, self__.off, m) : cljs.core.chunked_seq.call(null, self__.vec, self__.node, self__.i, self__.off, m);
};
cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var end = self__.i + self__.node.length;
  if (end < cljs.core._count(self__.vec)) {
    var G__47756 = self__.vec;
    var G__47757 = cljs.core.unchecked_array_for(self__.vec, end);
    var G__47758 = end;
    var G__47759 = 0;
    return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__47756, G__47757, G__47758, G__47759) : cljs.core.chunked_seq.call(null, G__47756, G__47757, G__47758, G__47759);
  } else {
    return null;
  }
};
cljs.core.ChunkedSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "vec", "vec", 982683596, null), new cljs.core.Symbol(null, "node", "node", -2073234571, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "off", "off", -2047994980, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 
  1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ChunkedSeq.cljs$lang$type = true;
cljs.core.ChunkedSeq.cljs$lang$ctorStr = "cljs.core/ChunkedSeq";
cljs.core.ChunkedSeq.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/ChunkedSeq");
};
cljs.core.__GT_ChunkedSeq = function cljs$core$__GT_ChunkedSeq(vec, node, i, off, meta, __hash) {
  return new cljs.core.ChunkedSeq(vec, node, i, off, meta, __hash);
};
cljs.core.ChunkedSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__10266__auto__ = this;
  return cljs.core.es6_iterator(this__10266__auto__);
};
cljs.core.chunked_seq = function cljs$core$chunked_seq(var_args) {
  var args47762 = [];
  var len__10375__auto___47765 = arguments.length;
  var i__10376__auto___47766 = 0;
  while (true) {
    if (i__10376__auto___47766 < len__10375__auto___47765) {
      args47762.push(arguments[i__10376__auto___47766]);
      var G__47767 = i__10376__auto___47766 + 1;
      i__10376__auto___47766 = G__47767;
      continue;
    } else {
    }
    break;
  }
  var G__47764 = args47762.length;
  switch(G__47764) {
    case 3:
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args47762.length)].join(""));
  }
};
cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3 = function(vec, i, off) {
  return new cljs.core.ChunkedSeq(vec, cljs.core.array_for(vec, i), i, off, null, null);
};
cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 = function(vec, node, i, off) {
  return new cljs.core.ChunkedSeq(vec, node, i, off, null, null);
};
cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 = function(vec, node, i, off, meta) {
  return new cljs.core.ChunkedSeq(vec, node, i, off, meta, null);
};
cljs.core.chunked_seq.cljs$lang$maxFixedArity = 5;
cljs.core.Subvec = function(meta, v, start, end, __hash) {
  this.meta = meta;
  this.v = v;
  this.start = start;
  this.end = end;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 167666463;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.Subvec.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.Subvec.prototype.cljs$core$IFind$_find$arity$2 = function(coll, key) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key, cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll__$1, key)], null);
};
cljs.core.Subvec.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.Subvec.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Subvec.prototype.indexOf = function() {
  var G__47789 = null;
  var G__47789__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__47789__2 = function(x, start__$1) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start__$1);
  };
  G__47789 = function(x, start__$1) {
    switch(arguments.length) {
      case 1:
        return G__47789__1.call(this, x);
      case 2:
        return G__47789__2.call(this, x, start__$1);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__47789.cljs$core$IFn$_invoke$arity$1 = G__47789__1;
  G__47789.cljs$core$IFn$_invoke$arity$2 = G__47789__2;
  return G__47789;
}();
cljs.core.Subvec.prototype.lastIndexOf = function() {
  var G__47790 = null;
  var G__47790__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__47790__2 = function(x, start__$1) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start__$1);
  };
  G__47790 = function(x, start__$1) {
    switch(arguments.length) {
      case 1:
        return G__47790__1.call(this, x);
      case 2:
        return G__47790__2.call(this, x, start__$1);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__47790.cljs$core$IFn$_invoke$arity$1 = G__47790__1;
  G__47790.cljs$core$IFn$_invoke$arity$2 = G__47790__2;
  return G__47790;
}();
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1.cljs$core$ILookup$_lookup$arity$3(null, k, null);
};
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof k === "number") {
    return coll__$1.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
  } else {
    return not_found;
  }
};
cljs.core.Subvec.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  var i = self__.start;
  var j = 0;
  var init__$1 = init;
  while (true) {
    if (i < self__.end) {
      var init__$2 = function() {
        var G__47770 = init__$1;
        var G__47771 = j;
        var G__47772 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v, i);
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__47770, G__47771, G__47772) : f.call(null, G__47770, G__47771, G__47772);
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null, init__$2);
      } else {
        var G__47791 = i + 1;
        var G__47792 = j + 1;
        var G__47793 = init__$2;
        i = G__47791;
        j = G__47792;
        init__$1 = G__47793;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  if (n < 0 || self__.end <= self__.start + n) {
    return cljs.core.vector_index_out_of_bounds(n, self__.end - self__.start);
  } else {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v, self__.start + n);
  }
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (n < 0 || self__.end <= self__.start + n) {
    return not_found;
  } else {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(self__.v, self__.start + n, not_found);
  }
};
cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var self__ = this;
  var coll__$1 = this;
  var v_pos = self__.start + n;
  if (n < 0 || self__.end + 1 <= v_pos) {
    throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Index "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(n), cljs.core.str.cljs$core$IFn$_invoke$arity$1(" out of bounds [0,"), cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll__$1.cljs$core$ICounted$_count$arity$1(null)), cljs.core.str.cljs$core$IFn$_invoke$arity$1("]")].join(""));
  } else {
    var G__47773 = self__.meta;
    var G__47774 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.v, v_pos, val);
    var G__47775 = self__.start;
    var G__47776 = function() {
      var x__9492__auto__ = self__.end;
      var y__9493__auto__ = v_pos + 1;
      return x__9492__auto__ > y__9493__auto__ ? x__9492__auto__ : y__9493__auto__;
    }();
    var G__47777 = null;
    return cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__47773, G__47774, G__47775, G__47776, G__47777) : cljs.core.build_subvec.call(null, G__47773, G__47774, G__47775, G__47776, G__47777);
  }
};
cljs.core.Subvec.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.Subvec.prototype.cljs$core$IIterable$_iterator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.ranged_iterator(self__.v, self__.start, self__.end);
};
cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.Subvec.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.Subvec(self__.meta, self__.v, self__.start, self__.end, self__.__hash);
};
cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.end - self__.start;
};
cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v, self__.end - 1);
};
cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.start === self__.end) {
    throw new Error("Can't pop empty vector");
  } else {
    var G__47778 = self__.meta;
    var G__47779 = self__.v;
    var G__47780 = self__.start;
    var G__47781 = self__.end - 1;
    var G__47782 = null;
    return cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__47778, G__47779, G__47780, G__47781, G__47782) : cljs.core.build_subvec.call(null, G__47778, G__47779, G__47780, G__47781, G__47782);
  }
};
cljs.core.Subvec.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (!(self__.start === self__.end)) {
    return new cljs.core.RSeq(coll__$1, self__.end - self__.start - 1, null);
  } else {
    return null;
  }
};
cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__9596__auto__ = self__.__hash;
  if (!(h__9596__auto__ == null)) {
    return h__9596__auto__;
  } else {
    var h__9596__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__9596__auto____$1;
    return h__9596__auto____$1;
  }
};
cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY, self__.meta);
};
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1, f);
};
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start__$1) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1, f, start__$1);
};
cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, key, val) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof key === "number") {
    return coll__$1.cljs$core$IVector$_assoc_n$arity$3(null, key, val);
  } else {
    throw new Error("Subvec's key for assoc must be a number.");
  }
};
cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var subvec_seq = function(coll__$1) {
    return function cljs$core$subvec_seq(i) {
      if (i === self__.end) {
        return null;
      } else {
        return cljs.core.cons(cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v, i), new cljs.core.LazySeq(null, function(coll__$1) {
          return function() {
            return cljs$core$subvec_seq(i + 1);
          };
        }(coll__$1), null, null));
      }
    };
  }(coll__$1);
  return subvec_seq(self__.start);
};
cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(meta__$1, self__.v, self__.start, self__.end, self__.__hash) : cljs.core.build_subvec.call(null, meta__$1, self__.v, self__.start, self__.end, self__.__hash);
};
cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  var G__47784 = self__.meta;
  var G__47785 = cljs.core._assoc_n(self__.v, self__.end, o);
  var G__47786 = self__.start;
  var G__47787 = self__.end + 1;
  var G__47788 = null;
  return cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__47784, G__47785, G__47786, G__47787, G__47788) : cljs.core.build_subvec.call(null, G__47784, G__47785, G__47786, G__47787, G__47788);
};
cljs.core.Subvec.prototype.call = function() {
  var G__47794 = null;
  var G__47794__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
  };
  var G__47794__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
  };
  G__47794 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__47794__2.call(this, self__, k);
      case 3:
        return G__47794__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__47794.cljs$core$IFn$_invoke$arity$2 = G__47794__2;
  G__47794.cljs$core$IFn$_invoke$arity$3 = G__47794__3;
  return G__47794;
}();
cljs.core.Subvec.prototype.apply = function(self__, args47769) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args47769)));
};
cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
};
cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
};
cljs.core.Subvec.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "v", "v", 1661996586, null), new cljs.core.Symbol(null, "start", "start", 1285322546, null), new cljs.core.Symbol(null, "end", "end", 1372345569, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", 
  "mutable", 875778266), true], null))], null);
};
cljs.core.Subvec.cljs$lang$type = true;
cljs.core.Subvec.cljs$lang$ctorStr = "cljs.core/Subvec";
cljs.core.Subvec.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/Subvec");
};
cljs.core.__GT_Subvec = function cljs$core$__GT_Subvec(meta, v, start, end, __hash) {
  return new cljs.core.Subvec(meta, v, start, end, __hash);
};
cljs.core.Subvec.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__10266__auto__ = this;
  return cljs.core.es6_iterator(this__10266__auto__);
};
cljs.core.build_subvec = function cljs$core$build_subvec(meta, v, start, end, __hash) {
  while (true) {
    if (v instanceof cljs.core.Subvec) {
      var G__47795 = meta;
      var G__47796 = v.v;
      var G__47797 = v.start + start;
      var G__47798 = v.start + end;
      var G__47799 = __hash;
      meta = G__47795;
      v = G__47796;
      start = G__47797;
      end = G__47798;
      __hash = G__47799;
      continue;
    } else {
      var c = cljs.core.count(v);
      if (start < 0 || end < 0 || start > c || end > c) {
        throw new Error("Index out of bounds");
      } else {
      }
      return new cljs.core.Subvec(meta, v, start, end, __hash);
    }
    break;
  }
};
cljs.core.subvec = function cljs$core$subvec(var_args) {
  var args47800 = [];
  var len__10375__auto___47803 = arguments.length;
  var i__10376__auto___47804 = 0;
  while (true) {
    if (i__10376__auto___47804 < len__10375__auto___47803) {
      args47800.push(arguments[i__10376__auto___47804]);
      var G__47805 = i__10376__auto___47804 + 1;
      i__10376__auto___47804 = G__47805;
      continue;
    } else {
    }
    break;
  }
  var G__47802 = args47800.length;
  switch(G__47802) {
    case 2:
      return cljs.core.subvec.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args47800.length)].join(""));
  }
};
cljs.core.subvec.cljs$core$IFn$_invoke$arity$2 = function(v, start) {
  return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(v, start, cljs.core.count(v));
};
cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 = function(v, start, end) {
  return cljs.core.build_subvec(null, v, start, end, null);
};
cljs.core.subvec.cljs$lang$maxFixedArity = 3;
cljs.core.tv_ensure_editable = function cljs$core$tv_ensure_editable(edit, node) {
  if (edit === node.edit) {
    return node;
  } else {
    return new cljs.core.VectorNode(edit, cljs.core.aclone(node.arr));
  }
};
cljs.core.tv_editable_root = function cljs$core$tv_editable_root(node) {
  return new cljs.core.VectorNode({}, cljs.core.aclone(node.arr));
};
cljs.core.tv_editable_tail = function cljs$core$tv_editable_tail(tl) {
  var ret = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
  cljs.core.array_copy(tl, 0, ret, 0, tl.length);
  return ret;
};
cljs.core.tv_push_tail = function cljs$core$tv_push_tail(tv, level, parent, tail_node) {
  var ret = cljs.core.tv_ensure_editable(tv.root.edit, parent);
  var subidx = tv.cnt - 1 >>> level & 31;
  cljs.core.pv_aset(ret, subidx, level === 5 ? tail_node : function() {
    var child = cljs.core.pv_aget(ret, subidx);
    if (!(child == null)) {
      var G__47815 = tv;
      var G__47816 = level - 5;
      var G__47817 = child;
      var G__47818 = tail_node;
      return cljs.core.tv_push_tail.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tv_push_tail.cljs$core$IFn$_invoke$arity$4(G__47815, G__47816, G__47817, G__47818) : cljs.core.tv_push_tail.call(null, G__47815, G__47816, G__47817, G__47818);
    } else {
      return cljs.core.new_path(tv.root.edit, level - 5, tail_node);
    }
  }());
  return ret;
};
cljs.core.tv_pop_tail = function cljs$core$tv_pop_tail(tv, level, node) {
  var node__$1 = cljs.core.tv_ensure_editable(tv.root.edit, node);
  var subidx = tv.cnt - 2 >>> level & 31;
  if (level > 5) {
    var new_child = function() {
      var G__47822 = tv;
      var G__47823 = level - 5;
      var G__47824 = cljs.core.pv_aget(node__$1, subidx);
      return cljs.core.tv_pop_tail.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tv_pop_tail.cljs$core$IFn$_invoke$arity$3(G__47822, G__47823, G__47824) : cljs.core.tv_pop_tail.call(null, G__47822, G__47823, G__47824);
    }();
    if (new_child == null && subidx === 0) {
      return null;
    } else {
      cljs.core.pv_aset(node__$1, subidx, new_child);
      return node__$1;
    }
  } else {
    if (subidx === 0) {
      return null;
    } else {
      cljs.core.pv_aset(node__$1, subidx, null);
      return node__$1;
    }
  }
};
cljs.core.unchecked_editable_array_for = function cljs$core$unchecked_editable_array_for(tv, i) {
  if (i >= cljs.core.tail_off(tv)) {
    return tv.tail;
  } else {
    var root = tv.root;
    var node = root;
    var level = tv.shift;
    while (true) {
      if (level > 0) {
        var G__47825 = cljs.core.tv_ensure_editable(root.edit, cljs.core.pv_aget(node, i >>> level & 31));
        var G__47826 = level - 5;
        node = G__47825;
        level = G__47826;
        continue;
      } else {
        return node.arr;
      }
      break;
    }
  }
};
cljs.core.TransientVector = function(cnt, shift, root, tail) {
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.cljs$lang$protocol_mask$partition1$ = 88;
  this.cljs$lang$protocol_mask$partition0$ = 275;
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var self__ = this;
  var tcoll__$1 = this;
  if (self__.root.edit) {
    if (self__.cnt - cljs.core.tail_off(tcoll__$1) < 32) {
      self__.tail[self__.cnt & 31] = o;
      self__.cnt = self__.cnt + 1;
      return tcoll__$1;
    } else {
      var tail_node = new cljs.core.VectorNode(self__.root.edit, self__.tail);
      var new_tail = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
      new_tail[0] = o;
      self__.tail = new_tail;
      if (self__.cnt >>> 5 > 1 << self__.shift) {
        var new_root_array = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
        var new_shift = self__.shift + 5;
        new_root_array[0] = self__.root;
        new_root_array[1] = cljs.core.new_path(self__.root.edit, self__.shift, tail_node);
        self__.root = new cljs.core.VectorNode(self__.root.edit, new_root_array);
        self__.shift = new_shift;
        self__.cnt = self__.cnt + 1;
        return tcoll__$1;
      } else {
        var new_root = cljs.core.tv_push_tail(tcoll__$1, self__.shift, self__.root, tail_node);
        self__.root = new_root;
        self__.cnt = self__.cnt + 1;
        return tcoll__$1;
      }
    }
  } else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  if (self__.root.edit) {
    self__.root.edit = null;
    var len = self__.cnt - cljs.core.tail_off(tcoll__$1);
    var trimmed_tail = new Array(len);
    cljs.core.array_copy(self__.tail, 0, trimmed_tail, 0, len);
    return new cljs.core.PersistentVector(null, self__.cnt, self__.shift, self__.root, trimmed_tail, null);
  } else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var self__ = this;
  var tcoll__$1 = this;
  if (typeof key === "number") {
    return tcoll__$1.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(null, key, val);
  } else {
    throw new Error("TransientVector's key for assoc! must be a number.");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = function(tcoll, n, val) {
  var self__ = this;
  var tcoll__$1 = this;
  if (self__.root.edit) {
    if (0 <= n && n < self__.cnt) {
      if (cljs.core.tail_off(tcoll__$1) <= n) {
        self__.tail[n & 31] = val;
        return tcoll__$1;
      } else {
        var new_root = function(tcoll__$1) {
          return function cljs$core$go(level, node) {
            var node__$1 = cljs.core.tv_ensure_editable(self__.root.edit, node);
            if (level === 0) {
              cljs.core.pv_aset(node__$1, n & 31, val);
              return node__$1;
            } else {
              var subidx = n >>> level & 31;
              cljs.core.pv_aset(node__$1, subidx, cljs$core$go(level - 5, cljs.core.pv_aget(node__$1, subidx)));
              return node__$1;
            }
          };
        }(tcoll__$1).call(null, self__.shift, self__.root);
        self__.root = new_root;
        return tcoll__$1;
      }
    } else {
      if (n === self__.cnt) {
        return tcoll__$1.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null, val);
      } else {
        throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Index "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(n), cljs.core.str.cljs$core$IFn$_invoke$arity$1(" out of bounds for TransientVector of length"), cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.cnt)].join(""));
      }
    }
  } else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  if (self__.root.edit) {
    if (self__.cnt === 0) {
      throw new Error("Can't pop empty vector");
    } else {
      if (1 === self__.cnt) {
        self__.cnt = 0;
        return tcoll__$1;
      } else {
        if ((self__.cnt - 1 & 31) > 0) {
          self__.cnt = self__.cnt - 1;
          return tcoll__$1;
        } else {
          var new_tail = cljs.core.unchecked_editable_array_for(tcoll__$1, self__.cnt - 2);
          var new_root = function() {
            var nr = cljs.core.tv_pop_tail(tcoll__$1, self__.shift, self__.root);
            if (!(nr == null)) {
              return nr;
            } else {
              return new cljs.core.VectorNode(self__.root.edit, [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null]);
            }
          }();
          if (5 < self__.shift && cljs.core.pv_aget(new_root, 1) == null) {
            var new_root__$1 = cljs.core.tv_ensure_editable(self__.root.edit, cljs.core.pv_aget(new_root, 0));
            self__.root = new_root__$1;
            self__.shift = self__.shift - 5;
            self__.cnt = self__.cnt - 1;
            self__.tail = new_tail;
            return tcoll__$1;
          } else {
            self__.root = new_root;
            self__.cnt = self__.cnt - 1;
            self__.tail = new_tail;
            return tcoll__$1;
          }
        }
      }
    }
  } else {
    throw new Error("pop! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.root.edit) {
    return self__.cnt;
  } else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.root.edit) {
    return cljs.core.array_for(coll__$1, n)[n & 31];
  } else {
    throw new Error("nth after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (0 <= n && n < self__.cnt) {
    return coll__$1.cljs$core$IIndexed$_nth$arity$2(null, n);
  } else {
    return not_found;
  }
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1.cljs$core$ILookup$_lookup$arity$3(null, k, null);
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof k === "number") {
    return coll__$1.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
  } else {
    return not_found;
  }
};
cljs.core.TransientVector.prototype.call = function() {
  var G__47830 = null;
  var G__47830__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__47830__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__47830 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__47830__2.call(this, self__, k);
      case 3:
        return G__47830__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__47830.cljs$core$IFn$_invoke$arity$2 = G__47830__2;
  G__47830.cljs$core$IFn$_invoke$arity$3 = G__47830__3;
  return G__47830;
}();
cljs.core.TransientVector.prototype.apply = function(self__, args47827) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args47827)));
};
cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.TransientVector.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "shift", "shift", -1657295705, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, 
  "root", "root", 1191874074, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "tail", "tail", 494507963, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.TransientVector.cljs$lang$type = true;
cljs.core.TransientVector.cljs$lang$ctorStr = "cljs.core/TransientVector";
cljs.core.TransientVector.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/TransientVector");
};
cljs.core.__GT_TransientVector = function cljs$core$__GT_TransientVector(cnt, shift, root, tail) {
  return new cljs.core.TransientVector(cnt, shift, root, tail);
};
cljs.core.PersistentQueueIter = function(fseq, riter) {
  this.fseq = fseq;
  this.riter = riter;
};
cljs.core.PersistentQueueIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  var or__9154__auto__ = !(self__.fseq == null) && cljs.core.seq(self__.fseq);
  if (or__9154__auto__) {
    return or__9154__auto__;
  } else {
    var and__9142__auto__ = !(self__.riter == null);
    if (and__9142__auto__) {
      return self__.riter.hasNext();
    } else {
      return and__9142__auto__;
    }
  }
};
cljs.core.PersistentQueueIter.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (!(self__.fseq == null)) {
    var ret = cljs.core.first(self__.fseq);
    self__.fseq = cljs.core.next(self__.fseq);
    return ret;
  } else {
    if (!(self__.riter == null) && self__.riter.hasNext()) {
      return self__.riter.next();
    } else {
      throw new Error("No such element");
    }
  }
};
cljs.core.PersistentQueueIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.PersistentQueueIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "fseq", "fseq", -1466412450, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), new cljs.core.Symbol(null, "riter", "riter", -237834262, null)], null);
};
cljs.core.PersistentQueueIter.cljs$lang$type = true;
cljs.core.PersistentQueueIter.cljs$lang$ctorStr = "cljs.core/PersistentQueueIter";
cljs.core.PersistentQueueIter.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/PersistentQueueIter");
};
cljs.core.__GT_PersistentQueueIter = function cljs$core$__GT_PersistentQueueIter(fseq, riter) {
  return new cljs.core.PersistentQueueIter(fseq, riter);
};
cljs.core.PersistentQueueSeq = function(meta, front, rear, __hash) {
  this.meta = meta;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 31850572;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.PersistentQueueSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentQueueSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentQueueSeq.prototype.indexOf = function() {
  var G__47831 = null;
  var G__47831__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__47831__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__47831 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__47831__1.call(this, x);
      case 2:
        return G__47831__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__47831.cljs$core$IFn$_invoke$arity$1 = G__47831__1;
  G__47831.cljs$core$IFn$_invoke$arity$2 = G__47831__2;
  return G__47831;
}();
cljs.core.PersistentQueueSeq.prototype.lastIndexOf = function() {
  var G__47832 = null;
  var G__47832__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__47832__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__47832 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__47832__1.call(this, x);
      case 2:
        return G__47832__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__47832.cljs$core$IFn$_invoke$arity$1 = G__47832__1;
  G__47832.cljs$core$IFn$_invoke$arity$2 = G__47832__2;
  return G__47832;
}();
cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__9596__auto__ = self__.__hash;
  if (!(h__9596__auto__ == null)) {
    return h__9596__auto__;
  } else {
    var h__9596__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__9596__auto____$1;
    return h__9596__auto____$1;
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.first(self__.front);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var temp__6736__auto__ = cljs.core.next(self__.front);
  if (temp__6736__auto__) {
    var f1 = temp__6736__auto__;
    return new cljs.core.PersistentQueueSeq(self__.meta, f1, self__.rear, null);
  } else {
    if (self__.rear == null) {
      return coll__$1.cljs$core$IEmptyableCollection$_empty$arity$1(null);
    } else {
      return new cljs.core.PersistentQueueSeq(self__.meta, self__.rear, null, null);
    }
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentQueueSeq(meta__$1, self__.front, self__.rear, self__.__hash);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.PersistentQueueSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "front", "front", 117022539, null), new cljs.core.Symbol(null, "rear", "rear", -900164830, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.PersistentQueueSeq.cljs$lang$type = true;
cljs.core.PersistentQueueSeq.cljs$lang$ctorStr = "cljs.core/PersistentQueueSeq";
cljs.core.PersistentQueueSeq.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/PersistentQueueSeq");
};
cljs.core.__GT_PersistentQueueSeq = function cljs$core$__GT_PersistentQueueSeq(meta, front, rear, __hash) {
  return new cljs.core.PersistentQueueSeq(meta, front, rear, __hash);
};
cljs.core.PersistentQueueSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__10266__auto__ = this;
  return cljs.core.es6_iterator(this__10266__auto__);
};
cljs.core.PersistentQueue = function(meta, count, front, rear, __hash) {
  this.meta = meta;
  this.count = count;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 31858766;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.PersistentQueue.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentQueue.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentQueue.prototype.indexOf = function() {
  var G__47833 = null;
  var G__47833__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__47833__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__47833 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__47833__1.call(this, x);
      case 2:
        return G__47833__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__47833.cljs$core$IFn$_invoke$arity$1 = G__47833__1;
  G__47833.cljs$core$IFn$_invoke$arity$2 = G__47833__2;
  return G__47833;
}();
cljs.core.PersistentQueue.prototype.lastIndexOf = function() {
  var G__47834 = null;
  var G__47834__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, self__.count.cljs$core$IFn$_invoke$arity$1 ? self__.count.cljs$core$IFn$_invoke$arity$1(coll) : self__.count.call(null, coll));
  };
  var G__47834__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__47834 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__47834__1.call(this, x);
      case 2:
        return G__47834__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__47834.cljs$core$IFn$_invoke$arity$1 = G__47834__1;
  G__47834.cljs$core$IFn$_invoke$arity$2 = G__47834__2;
  return G__47834;
}();
cljs.core.PersistentQueue.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.PersistentQueue.prototype.cljs$core$IIterable$_iterator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentQueueIter(self__.front, cljs.core._iterator(self__.rear));
};
cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentQueue(self__.meta, self__.count, self__.front, self__.rear, self__.__hash);
};
cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.count;
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.first(self__.front);
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.truth_(self__.front)) {
    var temp__6736__auto__ = cljs.core.next(self__.front);
    if (temp__6736__auto__) {
      var f1 = temp__6736__auto__;
      return new cljs.core.PersistentQueue(self__.meta, self__.count - 1, f1, self__.rear, null);
    } else {
      return new cljs.core.PersistentQueue(self__.meta, self__.count - 1, cljs.core.seq(self__.rear), cljs.core.PersistentVector.EMPTY, null);
    }
  } else {
    return coll__$1;
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__9596__auto__ = self__.__hash;
  if (!(h__9596__auto__ == null)) {
    return h__9596__auto__;
  } else {
    var h__9596__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__9596__auto____$1;
    return h__9596__auto____$1;
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.PersistentQueue.EMPTY, self__.meta);
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.first(self__.front);
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.rest(cljs.core.seq(coll__$1));
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var rear__$1 = cljs.core.seq(self__.rear);
  if (cljs.core.truth_(function() {
    var or__9154__auto__ = self__.front;
    if (cljs.core.truth_(or__9154__auto__)) {
      return or__9154__auto__;
    } else {
      return rear__$1;
    }
  }())) {
    return new cljs.core.PersistentQueueSeq(null, self__.front, cljs.core.seq(rear__$1), null);
  } else {
    return null;
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentQueue(meta__$1, self__.count, self__.front, self__.rear, self__.__hash);
};
cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.truth_(self__.front)) {
    return new cljs.core.PersistentQueue(self__.meta, self__.count + 1, self__.front, cljs.core.conj.cljs$core$IFn$_invoke$arity$2(function() {
      var or__9154__auto__ = self__.rear;
      if (cljs.core.truth_(or__9154__auto__)) {
        return or__9154__auto__;
      } else {
        return cljs.core.PersistentVector.EMPTY;
      }
    }(), o), null);
  } else {
    return new cljs.core.PersistentQueue(self__.meta, self__.count + 1, cljs.core.conj.cljs$core$IFn$_invoke$arity$2(self__.front, o), cljs.core.PersistentVector.EMPTY, null);
  }
};
cljs.core.PersistentQueue.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "count", "count", -514511684, null), new cljs.core.Symbol(null, "front", "front", 117022539, null), new cljs.core.Symbol(null, "rear", "rear", -900164830, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, 
  "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.PersistentQueue.cljs$lang$type = true;
cljs.core.PersistentQueue.cljs$lang$ctorStr = "cljs.core/PersistentQueue";
cljs.core.PersistentQueue.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/PersistentQueue");
};
cljs.core.__GT_PersistentQueue = function cljs$core$__GT_PersistentQueue(meta, count, front, rear, __hash) {
  return new cljs.core.PersistentQueue(meta, count, front, rear, __hash);
};
cljs.core.PersistentQueue.EMPTY = new cljs.core.PersistentQueue(null, 0, null, cljs.core.PersistentVector.EMPTY, cljs.core.empty_ordered_hash);
cljs.core.PersistentQueue.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__10266__auto__ = this;
  return cljs.core.es6_iterator(this__10266__auto__);
};
cljs.core.NeverEquiv = function() {
  this.cljs$lang$protocol_mask$partition0$ = 2097152;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.NeverEquiv.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var self__ = this;
  var o__$1 = this;
  return false;
};
cljs.core.NeverEquiv.getBasis = function() {
  return cljs.core.PersistentVector.EMPTY;
};
cljs.core.NeverEquiv.cljs$lang$type = true;
cljs.core.NeverEquiv.cljs$lang$ctorStr = "cljs.core/NeverEquiv";
cljs.core.NeverEquiv.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/NeverEquiv");
};
cljs.core.__GT_NeverEquiv = function cljs$core$__GT_NeverEquiv() {
  return new cljs.core.NeverEquiv;
};
cljs.core.never_equiv = new cljs.core.NeverEquiv;
cljs.core.equiv_map = function cljs$core$equiv_map(x, y) {
  return cljs.core.boolean$(cljs.core.map_QMARK_(y) ? cljs.core.count(x) === cljs.core.count(y) ? cljs.core.every_QMARK_(function(xkv) {
    return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y, cljs.core.first(xkv), cljs.core.never_equiv), cljs.core.second(xkv));
  }, x) : null : null);
};
cljs.core.scan_array = function cljs$core$scan_array(incr, k, array) {
  var len = array.length;
  var i = 0;
  while (true) {
    if (i < len) {
      if (k === array[i]) {
        return i;
      } else {
        var G__47835 = i + incr;
        i = G__47835;
        continue;
      }
    } else {
      return null;
    }
    break;
  }
};
cljs.core.obj_map_compare_keys = function cljs$core$obj_map_compare_keys(a, b) {
  var a__$1 = cljs.core.hash(a);
  var b__$1 = cljs.core.hash(b);
  if (a__$1 < b__$1) {
    return -1;
  } else {
    if (a__$1 > b__$1) {
      return 1;
    } else {
      return 0;
    }
  }
};
cljs.core.obj_map__GT_hash_map = function cljs$core$obj_map__GT_hash_map(m, k, v) {
  var ks = m.keys;
  var len = ks.length;
  var so = m.strobj;
  var mm = cljs.core.meta(m);
  var i = 0;
  var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  while (true) {
    if (i < len) {
      var k__$1 = ks[i];
      var G__47836 = i + 1;
      var G__47837 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out, k__$1, so[k__$1]);
      i = G__47836;
      out = G__47837;
      continue;
    } else {
      return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out, k, v)), mm);
    }
    break;
  }
};
cljs.core.obj_clone = function cljs$core$obj_clone(obj, ks) {
  var new_obj = {};
  var l = ks.length;
  var i_47842 = 0;
  while (true) {
    if (i_47842 < l) {
      var k_47843 = ks[i_47842];
      new_obj[k_47843] = obj[k_47843];
      var G__47844 = i_47842 + 1;
      i_47842 = G__47844;
      continue;
    } else {
    }
    break;
  }
  return new_obj;
};
cljs.core.ObjMap = function(meta, keys, strobj, update_count, __hash) {
  this.meta = meta;
  this.keys = keys;
  this.strobj = strobj;
  this.update_count = update_count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 16123663;
  this.cljs$lang$protocol_mask$partition1$ = 4;
};
cljs.core.ObjMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.ObjMap.prototype.cljs$core$IFind$_find$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k, cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll__$1, k)], null);
};
cljs.core.ObjMap.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ObjMap.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1.cljs$core$ILookup$_lookup$arity$3(null, k, null);
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (goog.isString(k) && !(cljs.core.scan_array(1, k, self__.keys) == null)) {
    return self__.strobj[k];
  } else {
    return not_found;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  var len = self__.keys.length;
  var keys__$1 = self__.keys.sort(cljs.core.obj_map_compare_keys);
  var init__$1 = init;
  while (true) {
    if (cljs.core.seq(keys__$1)) {
      var k = cljs.core.first(keys__$1);
      var init__$2 = function() {
        var G__47847 = init__$1;
        var G__47848 = k;
        var G__47849 = self__.strobj[k];
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__47847, G__47848, G__47849) : f.call(null, G__47847, G__47848, G__47849);
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null, init__$2);
      } else {
        var G__47850 = cljs.core.rest(keys__$1);
        var G__47851 = init__$2;
        keys__$1 = G__47850;
        init__$1 = G__47851;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.keys.length;
};
cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__9596__auto__ = self__.__hash;
  if (!(h__9596__auto__ == null)) {
    return h__9596__auto__;
  } else {
    var h__9596__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__9596__auto____$1;
    return h__9596__auto____$1;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_map(coll__$1, other);
};
cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.transient$(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY, coll__$1));
};
cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.ObjMap.EMPTY, self__.meta);
};
cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (goog.isString(k) && !(cljs.core.scan_array(1, k, self__.keys) == null)) {
    var new_keys = cljs.core.aclone(self__.keys);
    var new_strobj = cljs.core.obj_clone(self__.strobj, self__.keys);
    new_keys.splice(cljs.core.scan_array(1, k, new_keys), 1);
    delete new_strobj[k];
    return new cljs.core.ObjMap(self__.meta, new_keys, new_strobj, self__.update_count + 1, null);
  } else {
    return coll__$1;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  if (goog.isString(k)) {
    if (self__.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD || self__.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD) {
      return cljs.core.obj_map__GT_hash_map(coll__$1, k, v);
    } else {
      if (!(cljs.core.scan_array(1, k, self__.keys) == null)) {
        var new_strobj = cljs.core.obj_clone(self__.strobj, self__.keys);
        new_strobj[k] = v;
        return new cljs.core.ObjMap(self__.meta, self__.keys, new_strobj, self__.update_count + 1, null);
      } else {
        var new_strobj = cljs.core.obj_clone(self__.strobj, self__.keys);
        var new_keys = cljs.core.aclone(self__.keys);
        new_strobj[k] = v;
        new_keys.push(k);
        return new cljs.core.ObjMap(self__.meta, new_keys, new_strobj, self__.update_count + 1, null);
      }
    }
  } else {
    return cljs.core.obj_map__GT_hash_map(coll__$1, k, v);
  }
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (goog.isString(k) && !(cljs.core.scan_array(1, k, self__.keys) == null)) {
    return true;
  } else {
    return false;
  }
};
cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.keys.length > 0) {
    return cljs.core.map.cljs$core$IFn$_invoke$arity$2(function(coll__$1) {
      return function(p1__47845_SHARP_) {
        return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__47845_SHARP_, self__.strobj[p1__47845_SHARP_]], null);
      };
    }(coll__$1), self__.keys.sort(cljs.core.obj_map_compare_keys));
  } else {
    return null;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.ObjMap(meta__$1, self__.keys, self__.strobj, self__.update_count, self__.__hash);
};
cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.vector_QMARK_(entry)) {
    return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 1));
  } else {
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj, coll__$1, entry);
  }
};
cljs.core.ObjMap.prototype.call = function() {
  var G__47852 = null;
  var G__47852__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__47852__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__47852 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__47852__2.call(this, self__, k);
      case 3:
        return G__47852__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__47852.cljs$core$IFn$_invoke$arity$2 = G__47852__2;
  G__47852.cljs$core$IFn$_invoke$arity$3 = G__47852__3;
  return G__47852;
}();
cljs.core.ObjMap.prototype.apply = function(self__, args47846) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args47846)));
};
cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.ObjMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "keys", "keys", -1586012071, null), new cljs.core.Symbol(null, "strobj", "strobj", 1088091283, null), new cljs.core.Symbol(null, "update-count", "update-count", -411982269, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, 
  "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ObjMap.cljs$lang$type = true;
cljs.core.ObjMap.cljs$lang$ctorStr = "cljs.core/ObjMap";
cljs.core.ObjMap.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/ObjMap");
};
cljs.core.__GT_ObjMap = function cljs$core$__GT_ObjMap(meta, keys, strobj, update_count, __hash) {
  return new cljs.core.ObjMap(meta, keys, strobj, update_count, __hash);
};
cljs.core.ObjMap.EMPTY = new cljs.core.ObjMap(null, [], {}, 0, cljs.core.empty_unordered_hash);
cljs.core.ObjMap.HASHMAP_THRESHOLD = 8;
cljs.core.ObjMap.fromObject = function(ks, obj) {
  return new cljs.core.ObjMap(null, ks, obj, 0, null);
};
cljs.core.RecordIter = function(i, record, base_count, fields, ext_map_iter) {
  this.i = i;
  this.record = record;
  this.base_count = base_count;
  this.fields = fields;
  this.ext_map_iter = ext_map_iter;
};
cljs.core.RecordIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  var or__9154__auto__ = self__.i < self__.base_count;
  if (or__9154__auto__) {
    return or__9154__auto__;
  } else {
    return self__.ext_map_iter.hasNext();
  }
};
cljs.core.RecordIter.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (self__.i < self__.base_count) {
    var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.fields, self__.i);
    self__.i = self__.i + 1;
    return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k, cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(self__.record, k)], null);
  } else {
    return self__.ext_map_iter.next();
  }
};
cljs.core.RecordIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.RecordIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), new cljs.core.Symbol(null, "record", "record", 861424668, null), new cljs.core.Symbol(null, "base-count", "base-count", -1180647182, null), new cljs.core.Symbol(null, "fields", "fields", -291534703, null), new cljs.core.Symbol(null, 
  "ext-map-iter", "ext-map-iter", -1215982757, null)], null);
};
cljs.core.RecordIter.cljs$lang$type = true;
cljs.core.RecordIter.cljs$lang$ctorStr = "cljs.core/RecordIter";
cljs.core.RecordIter.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/RecordIter");
};
cljs.core.__GT_RecordIter = function cljs$core$__GT_RecordIter(i, record, base_count, fields, ext_map_iter) {
  return new cljs.core.RecordIter(i, record, base_count, fields, ext_map_iter);
};
cljs.core.ES6EntriesIterator = function(s) {
  this.s = s;
};
cljs.core.ES6EntriesIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (!(self__.s == null)) {
    var vec__47855 = cljs.core.first(self__.s);
    var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47855, 0, null);
    var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47855, 1, null);
    self__.s = cljs.core.next(self__.s);
    return {"value":[k, v], "done":false};
  } else {
    return {"value":null, "done":true};
  }
};
cljs.core.ES6EntriesIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "s", "s", -948495851, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ES6EntriesIterator.cljs$lang$type = true;
cljs.core.ES6EntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6EntriesIterator";
cljs.core.ES6EntriesIterator.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/ES6EntriesIterator");
};
cljs.core.__GT_ES6EntriesIterator = function cljs$core$__GT_ES6EntriesIterator(s) {
  return new cljs.core.ES6EntriesIterator(s);
};
cljs.core.es6_entries_iterator = function cljs$core$es6_entries_iterator(coll) {
  return new cljs.core.ES6EntriesIterator(cljs.core.seq(coll));
};
cljs.core.ES6SetEntriesIterator = function(s) {
  this.s = s;
};
cljs.core.ES6SetEntriesIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (!(self__.s == null)) {
    var x = cljs.core.first(self__.s);
    self__.s = cljs.core.next(self__.s);
    return {"value":[x, x], "done":false};
  } else {
    return {"value":null, "done":true};
  }
};
cljs.core.ES6SetEntriesIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "s", "s", -948495851, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ES6SetEntriesIterator.cljs$lang$type = true;
cljs.core.ES6SetEntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6SetEntriesIterator";
cljs.core.ES6SetEntriesIterator.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/ES6SetEntriesIterator");
};
cljs.core.__GT_ES6SetEntriesIterator = function cljs$core$__GT_ES6SetEntriesIterator(s) {
  return new cljs.core.ES6SetEntriesIterator(s);
};
cljs.core.es6_set_entries_iterator = function cljs$core$es6_set_entries_iterator(coll) {
  return new cljs.core.ES6SetEntriesIterator(cljs.core.seq(coll));
};
cljs.core.array_index_of_nil_QMARK_ = function cljs$core$array_index_of_nil_QMARK_(arr) {
  var len = arr.length;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (arr[i] == null) {
        return i;
      } else {
        var G__47858 = i + 2;
        i = G__47858;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of_keyword_QMARK_ = function cljs$core$array_index_of_keyword_QMARK_(arr, k) {
  var len = arr.length;
  var kstr = k.fqn;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (arr[i] instanceof cljs.core.Keyword && kstr === arr[i].fqn) {
        return i;
      } else {
        var G__47859 = i + 2;
        i = G__47859;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of_symbol_QMARK_ = function cljs$core$array_index_of_symbol_QMARK_(arr, k) {
  var len = arr.length;
  var kstr = k.str;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (arr[i] instanceof cljs.core.Symbol && kstr === arr[i].str) {
        return i;
      } else {
        var G__47860 = i + 2;
        i = G__47860;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of_identical_QMARK_ = function cljs$core$array_index_of_identical_QMARK_(arr, k) {
  var len = arr.length;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (k === arr[i]) {
        return i;
      } else {
        var G__47861 = i + 2;
        i = G__47861;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of_equiv_QMARK_ = function cljs$core$array_index_of_equiv_QMARK_(arr, k) {
  var len = arr.length;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k, arr[i])) {
        return i;
      } else {
        var G__47862 = i + 2;
        i = G__47862;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of = function cljs$core$array_index_of(arr, k) {
  if (k instanceof cljs.core.Keyword) {
    return cljs.core.array_index_of_keyword_QMARK_(arr, k);
  } else {
    if (goog.isString(k) || typeof k === "number") {
      return cljs.core.array_index_of_identical_QMARK_(arr, k);
    } else {
      if (k instanceof cljs.core.Symbol) {
        return cljs.core.array_index_of_symbol_QMARK_(arr, k);
      } else {
        if (k == null) {
          return cljs.core.array_index_of_nil_QMARK_(arr);
        } else {
          return cljs.core.array_index_of_equiv_QMARK_(arr, k);
        }
      }
    }
  }
};
cljs.core.array_map_index_of = function cljs$core$array_map_index_of(m, k) {
  return cljs.core.array_index_of(m.arr, k);
};
cljs.core.array_extend_kv = function cljs$core$array_extend_kv(arr, k, v) {
  var l = arr.length;
  var narr = new Array(l + 2);
  var i_47863 = 0;
  while (true) {
    if (i_47863 < l) {
      narr[i_47863] = arr[i_47863];
      var G__47864 = i_47863 + 1;
      i_47863 = G__47864;
      continue;
    } else {
    }
    break;
  }
  narr[l] = k;
  narr[l + 1] = v;
  return narr;
};
cljs.core.array_map_extend_kv = function cljs$core$array_map_extend_kv(m, k, v) {
  return cljs.core.array_extend_kv(m.arr, k, v);
};
cljs.core.MapEntry = function(key, val, __hash) {
  this.key = key;
  this.val = val;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32402207;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.MapEntry.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.MapEntry.prototype.cljs$core$IFind$_find$arity$2 = function(node, k) {
  var self__ = this;
  var node__$1 = this;
  if (k === 0) {
    return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [0, self__.key], null);
  } else {
    if (k === 1) {
      return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [1, self__.val], null);
    } else {
      return null;
    }
  }
};
cljs.core.MapEntry.prototype.indexOf = function() {
  var G__47866 = null;
  var G__47866__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__47866__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__47866 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__47866__1.call(this, x);
      case 2:
        return G__47866__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__47866.cljs$core$IFn$_invoke$arity$1 = G__47866__1;
  G__47866.cljs$core$IFn$_invoke$arity$2 = G__47866__2;
  return G__47866;
}();
cljs.core.MapEntry.prototype.lastIndexOf = function() {
  var G__47867 = null;
  var G__47867__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__47867__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__47867 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__47867__1.call(this, x);
      case 2:
        return G__47867__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__47867.cljs$core$IFn$_invoke$arity$1 = G__47867__1;
  G__47867.cljs$core$IFn$_invoke$arity$2 = G__47867__2;
  return G__47867;
}();
cljs.core.MapEntry.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var self__ = this;
  var node__$1 = this;
  return node__$1.cljs$core$IIndexed$_nth$arity$3(null, k, null);
};
cljs.core.MapEntry.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var self__ = this;
  var node__$1 = this;
  return node__$1.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
};
cljs.core.MapEntry.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var self__ = this;
  var node__$1 = this;
  if (n === 0) {
    return self__.key;
  } else {
    if (n === 1) {
      return self__.val;
    } else {
      throw new Error("Index out of bounds");
    }
  }
};
cljs.core.MapEntry.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var self__ = this;
  var node__$1 = this;
  if (n === 0) {
    return self__.key;
  } else {
    if (n === 1) {
      return self__.val;
    } else {
      return not_found;
    }
  }
};
cljs.core.MapEntry.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var self__ = this;
  var node__$1 = this;
  return (new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null)).cljs$core$IVector$_assoc_n$arity$3(null, n, v);
};
cljs.core.MapEntry.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return null;
};
cljs.core.MapEntry.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return 2;
};
cljs.core.MapEntry.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.key;
};
cljs.core.MapEntry.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.val;
};
cljs.core.MapEntry.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.val;
};
cljs.core.MapEntry.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
};
cljs.core.MapEntry.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__9596__auto__ = self__.__hash;
  if (!(h__9596__auto__ == null)) {
    return h__9596__auto__;
  } else {
    var h__9596__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__9596__auto____$1;
    return h__9596__auto____$1;
  }
};
cljs.core.MapEntry.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.MapEntry.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.PersistentVector.EMPTY;
};
cljs.core.MapEntry.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1, f);
};
cljs.core.MapEntry.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1, f, start);
};
cljs.core.MapEntry.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null), k, v);
};
cljs.core.MapEntry.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(node, k) {
  var self__ = this;
  var node__$1 = this;
  return k === 0 || k === 1;
};
cljs.core.MapEntry.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  var x__10088__auto__ = self__.key;
  return cljs.core._conj(function() {
    var x__10088__auto____$1 = self__.val;
    return cljs.core._conj(cljs.core.List.EMPTY, x__10088__auto____$1);
  }(), x__10088__auto__);
};
cljs.core.MapEntry.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null), meta);
};
cljs.core.MapEntry.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var self__ = this;
  var node__$1 = this;
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val, o], null);
};
cljs.core.MapEntry.prototype.call = function() {
  var G__47868 = null;
  var G__47868__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var node = self____$1;
    return node.cljs$core$IIndexed$_nth$arity$2(null, k);
  };
  var G__47868__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var node = self____$1;
    return node.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
  };
  G__47868 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__47868__2.call(this, self__, k);
      case 3:
        return G__47868__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__47868.cljs$core$IFn$_invoke$arity$2 = G__47868__2;
  G__47868.cljs$core$IFn$_invoke$arity$3 = G__47868__3;
  return G__47868;
}();
cljs.core.MapEntry.prototype.apply = function(self__, args47865) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args47865)));
};
cljs.core.MapEntry.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var node = this;
  return node.cljs$core$IIndexed$_nth$arity$2(null, k);
};
cljs.core.MapEntry.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var node = this;
  return node.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
};
cljs.core.MapEntry.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "key", "key", 124488940, null), new cljs.core.Symbol(null, "val", "val", 1769233139, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.MapEntry.cljs$lang$type = true;
cljs.core.MapEntry.cljs$lang$ctorStr = "cljs.core/MapEntry";
cljs.core.MapEntry.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/MapEntry");
};
cljs.core.__GT_MapEntry = function cljs$core$__GT_MapEntry(key, val, __hash) {
  return new cljs.core.MapEntry(key, val, __hash);
};
cljs.core.PersistentArrayMapSeq = function(arr, i, _meta) {
  this.arr = arr;
  this.i = i;
  this._meta = _meta;
  this.cljs$lang$protocol_mask$partition0$ = 32374990;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.PersistentArrayMapSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentArrayMapSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentArrayMapSeq.prototype.indexOf = function() {
  var G__47869 = null;
  var G__47869__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__47869__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__47869 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__47869__1.call(this, x);
      case 2:
        return G__47869__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__47869.cljs$core$IFn$_invoke$arity$1 = G__47869__1;
  G__47869.cljs$core$IFn$_invoke$arity$2 = G__47869__2;
  return G__47869;
}();
cljs.core.PersistentArrayMapSeq.prototype.lastIndexOf = function() {
  var G__47870 = null;
  var G__47870__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__47870__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__47870 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__47870__1.call(this, x);
      case 2:
        return G__47870__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__47870.cljs$core$IFn$_invoke$arity$1 = G__47870__1;
  G__47870.cljs$core$IFn$_invoke$arity$2 = G__47870__2;
  return G__47870;
}();
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__._meta;
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.i < self__.arr.length - 2) {
    return new cljs.core.PersistentArrayMapSeq(self__.arr, self__.i + 2, self__._meta);
  } else {
    return null;
  }
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return (self__.arr.length - self__.i) / 2;
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.hash_ordered_coll(coll__$1);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__._meta);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.arr[self__.i], self__.arr[self__.i + 1]], null);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.i < self__.arr.length - 2) {
    return new cljs.core.PersistentArrayMapSeq(self__.arr, self__.i + 2, self__._meta);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, new_meta) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentArrayMapSeq(self__.arr, self__.i, new_meta);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.PersistentArrayMapSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "_meta", "_meta", -1716892533, null)], null);
};
cljs.core.PersistentArrayMapSeq.cljs$lang$type = true;
cljs.core.PersistentArrayMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapSeq";
cljs.core.PersistentArrayMapSeq.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/PersistentArrayMapSeq");
};
cljs.core.__GT_PersistentArrayMapSeq = function cljs$core$__GT_PersistentArrayMapSeq(arr, i, _meta) {
  return new cljs.core.PersistentArrayMapSeq(arr, i, _meta);
};
cljs.core.PersistentArrayMapSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__10266__auto__ = this;
  return cljs.core.es6_iterator(this__10266__auto__);
};
cljs.core.persistent_array_map_seq = function cljs$core$persistent_array_map_seq(arr, i, _meta) {
  if (i <= arr.length - 2) {
    return new cljs.core.PersistentArrayMapSeq(arr, i, _meta);
  } else {
    return null;
  }
};
cljs.core.PersistentArrayMapIterator = function(arr, i, cnt) {
  this.arr = arr;
  this.i = i;
  this.cnt = cnt;
};
cljs.core.PersistentArrayMapIterator.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.i < self__.cnt;
};
cljs.core.PersistentArrayMapIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.arr[self__.i], self__.arr[self__.i + 1]], null);
  self__.i = self__.i + 2;
  return ret;
};
cljs.core.PersistentArrayMapIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null)], null);
};
cljs.core.PersistentArrayMapIterator.cljs$lang$type = true;
cljs.core.PersistentArrayMapIterator.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapIterator";
cljs.core.PersistentArrayMapIterator.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/PersistentArrayMapIterator");
};
cljs.core.__GT_PersistentArrayMapIterator = function cljs$core$__GT_PersistentArrayMapIterator(arr, i, cnt) {
  return new cljs.core.PersistentArrayMapIterator(arr, i, cnt);
};
cljs.core.PersistentArrayMap = function(meta, cnt, arr, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.arr = arr;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 16647951;
  this.cljs$lang$protocol_mask$partition1$ = 8196;
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.PersistentArrayMap.prototype.cljs$core$IFind$_find$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  var idx = cljs.core.array_map_index_of(coll__$1, k);
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.arr[idx], cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll__$1, k)], null);
};
cljs.core.PersistentArrayMap.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentArrayMap.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentArrayMap.prototype.keys = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.keys.call(null, coll));
};
cljs.core.PersistentArrayMap.prototype.entries = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentArrayMap.prototype.values = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.vals.call(null, coll));
};
cljs.core.PersistentArrayMap.prototype.has = function(k) {
  var self__ = this;
  var coll = this;
  return cljs.core.contains_QMARK_(coll, k);
};
cljs.core.PersistentArrayMap.prototype.get = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentArrayMap.prototype.forEach = function(f) {
  var self__ = this;
  var coll = this;
  var seq__47872 = cljs.core.seq(coll);
  var chunk__47873 = null;
  var count__47874 = 0;
  var i__47875 = 0;
  while (true) {
    if (i__47875 < count__47874) {
      var vec__47876 = chunk__47873.cljs$core$IIndexed$_nth$arity$2(null, i__47875);
      var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47876, 0, null);
      var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47876, 1, null);
      f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v, k) : f.call(null, v, k);
      var G__47889 = seq__47872;
      var G__47890 = chunk__47873;
      var G__47891 = count__47874;
      var G__47892 = i__47875 + 1;
      seq__47872 = G__47889;
      chunk__47873 = G__47890;
      count__47874 = G__47891;
      i__47875 = G__47892;
      continue;
    } else {
      var temp__6738__auto__ = cljs.core.seq(seq__47872);
      if (temp__6738__auto__) {
        var seq__47872__$1 = temp__6738__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__47872__$1)) {
          var c__10065__auto__ = cljs.core.chunk_first(seq__47872__$1);
          var G__47893 = cljs.core.chunk_rest(seq__47872__$1);
          var G__47894 = c__10065__auto__;
          var G__47895 = cljs.core.count(c__10065__auto__);
          var G__47896 = 0;
          seq__47872 = G__47893;
          chunk__47873 = G__47894;
          count__47874 = G__47895;
          i__47875 = G__47896;
          continue;
        } else {
          var vec__47879 = cljs.core.first(seq__47872__$1);
          var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47879, 0, null);
          var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47879, 1, null);
          f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v, k) : f.call(null, v, k);
          var G__47897 = cljs.core.next(seq__47872__$1);
          var G__47898 = null;
          var G__47899 = 0;
          var G__47900 = 0;
          seq__47872 = G__47897;
          chunk__47873 = G__47898;
          count__47874 = G__47899;
          i__47875 = G__47900;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1.cljs$core$ILookup$_lookup$arity$3(null, k, null);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  var idx = cljs.core.array_map_index_of(coll__$1, k);
  if (idx === -1) {
    return not_found;
  } else {
    return self__.arr[idx + 1];
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  var len = self__.arr.length;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < len) {
      var init__$2 = function() {
        var G__47882 = init__$1;
        var G__47883 = self__.arr[i];
        var G__47884 = self__.arr[i + 1];
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__47882, G__47883, G__47884) : f.call(null, G__47882, G__47883, G__47884);
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null, init__$2);
      } else {
        var G__47901 = i + 2;
        var G__47902 = init__$2;
        i = G__47901;
        init__$1 = G__47902;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$_iterator$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return new cljs.core.PersistentArrayMapIterator(self__.arr, 0, self__.cnt * 2);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentArrayMap(self__.meta, self__.cnt, self__.arr, self__.__hash);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.cnt;
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__9596__auto__ = self__.__hash;
  if (!(h__9596__auto__ == null)) {
    return h__9596__auto__;
  } else {
    var h__9596__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__9596__auto____$1;
    return h__9596__auto____$1;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  if (!(other == null) ? other.cljs$lang$protocol_mask$partition0$ & 1024 || cljs.core.PROTOCOL_SENTINEL === other.cljs$core$IMap$ ? true : false : false) {
    var alen = self__.arr.length;
    var other__$1 = other;
    if (self__.cnt === other__$1.cljs$core$ICounted$_count$arity$1(null)) {
      var i = 0;
      while (true) {
        if (i < alen) {
          var v = other__$1.cljs$core$ILookup$_lookup$arity$3(null, self__.arr[i], cljs.core.lookup_sentinel);
          if (!(v === cljs.core.lookup_sentinel)) {
            if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(self__.arr[i + 1], v)) {
              var G__47903 = i + 2;
              i = G__47903;
              continue;
            } else {
              return false;
            }
          } else {
            return false;
          }
        } else {
          return true;
        }
        break;
      }
    } else {
      return false;
    }
  } else {
    return cljs.core.equiv_map(coll__$1, other);
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.TransientArrayMap({}, self__.arr.length, cljs.core.aclone(self__.arr));
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.PersistentArrayMap.EMPTY, self__.meta);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  var idx = cljs.core.array_map_index_of(coll__$1, k);
  if (idx >= 0) {
    var len = self__.arr.length;
    var new_len = len - 2;
    if (new_len === 0) {
      return coll__$1.cljs$core$IEmptyableCollection$_empty$arity$1(null);
    } else {
      var new_arr = new Array(new_len);
      var s = 0;
      var d = 0;
      while (true) {
        if (s >= len) {
          return new cljs.core.PersistentArrayMap(self__.meta, self__.cnt - 1, new_arr, null);
        } else {
          if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k, self__.arr[s])) {
            var G__47904 = s + 2;
            var G__47905 = d;
            s = G__47904;
            d = G__47905;
            continue;
          } else {
            new_arr[d] = self__.arr[s];
            new_arr[d + 1] = self__.arr[s + 1];
            var G__47906 = s + 2;
            var G__47907 = d + 2;
            s = G__47906;
            d = G__47907;
            continue;
          }
        }
        break;
      }
    }
  } else {
    return coll__$1;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  var idx = cljs.core.array_map_index_of(coll__$1, k);
  if (idx === -1) {
    if (self__.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
      var arr__$1 = cljs.core.array_map_extend_kv(coll__$1, k, v);
      return new cljs.core.PersistentArrayMap(self__.meta, self__.cnt + 1, arr__$1, null);
    } else {
      return cljs.core._with_meta(cljs.core._assoc(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY, coll__$1), k, v), self__.meta);
    }
  } else {
    if (v === self__.arr[idx + 1]) {
      return coll__$1;
    } else {
      var arr__$1 = function() {
        var G__47888 = cljs.core.aclone(self__.arr);
        G__47888[idx + 1] = v;
        return G__47888;
      }();
      return new cljs.core.PersistentArrayMap(self__.meta, self__.cnt, arr__$1, null);
    }
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return !(cljs.core.array_map_index_of(coll__$1, k) === -1);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.persistent_array_map_seq(self__.arr, 0, null);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentArrayMap(meta__$1, self__.cnt, self__.arr, self__.__hash);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.vector_QMARK_(entry)) {
    return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 1));
  } else {
    var ret = coll__$1;
    var es = cljs.core.seq(entry);
    while (true) {
      if (es == null) {
        return ret;
      } else {
        var e = cljs.core.first(es);
        if (cljs.core.vector_QMARK_(e)) {
          var G__47908 = ret.cljs$core$IAssociative$_assoc$arity$3(null, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 1));
          var G__47909 = cljs.core.next(es);
          ret = G__47908;
          es = G__47909;
          continue;
        } else {
          throw new Error("conj on a map takes map entries or seqables of map entries");
        }
      }
      break;
    }
  }
};
cljs.core.PersistentArrayMap.prototype.call = function() {
  var G__47910 = null;
  var G__47910__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__47910__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__47910 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__47910__2.call(this, self__, k);
      case 3:
        return G__47910__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__47910.cljs$core$IFn$_invoke$arity$2 = G__47910__2;
  G__47910.cljs$core$IFn$_invoke$arity$3 = G__47910__3;
  return G__47910;
}();
cljs.core.PersistentArrayMap.prototype.apply = function(self__, args47871) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args47871)));
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentArrayMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.PersistentArrayMap.cljs$lang$type = true;
cljs.core.PersistentArrayMap.cljs$lang$ctorStr = "cljs.core/PersistentArrayMap";
cljs.core.PersistentArrayMap.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/PersistentArrayMap");
};
cljs.core.__GT_PersistentArrayMap = function cljs$core$__GT_PersistentArrayMap(meta, cnt, arr, __hash) {
  return new cljs.core.PersistentArrayMap(meta, cnt, arr, __hash);
};
cljs.core.PersistentArrayMap.EMPTY = new cljs.core.PersistentArrayMap(null, 0, [], cljs.core.empty_unordered_hash);
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = 8;
cljs.core.PersistentArrayMap.fromArray = function(arr, no_clone, no_check) {
  var arr__$1 = no_clone ? arr : cljs.core.aclone(arr);
  var arr__$2 = no_check ? arr__$1 : function() {
    var ret = [];
    var i_47911 = 0;
    while (true) {
      if (i_47911 < arr__$1.length) {
        var k_47912 = arr__$1[i_47911];
        var v_47913 = arr__$1[i_47911 + 1];
        var idx_47914 = cljs.core.array_index_of(ret, k_47912);
        if (idx_47914 === -1) {
          ret.push(k_47912);
          ret.push(v_47913);
        } else {
        }
        var G__47915 = i_47911 + 2;
        i_47911 = G__47915;
        continue;
      } else {
      }
      break;
    }
    return ret;
  }();
  var cnt = arr__$2.length / 2;
  return new cljs.core.PersistentArrayMap(null, cnt, arr__$2, null);
};
cljs.core.PersistentArrayMap.createWithCheck = function(arr) {
  var ret = [];
  var i_47917 = 0;
  while (true) {
    if (i_47917 < arr.length) {
      var k_47918 = arr[i_47917];
      var v_47919 = arr[i_47917 + 1];
      var idx_47920 = cljs.core.array_index_of(ret, k_47918);
      if (idx_47920 === -1) {
        var G__47916_47921 = ret;
        G__47916_47921.push(k_47918);
        G__47916_47921.push(v_47919);
      } else {
        throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Duplicate key: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(k_47918)].join(""));
      }
      var G__47922 = i_47917 + 2;
      i_47917 = G__47922;
      continue;
    } else {
    }
    break;
  }
  var cnt = arr.length / 2;
  return new cljs.core.PersistentArrayMap(null, cnt, arr, null);
};
cljs.core.PersistentArrayMap.createAsIfByAssoc = function(arr) {
  var ret = [];
  var i_47924 = 0;
  while (true) {
    if (i_47924 < arr.length) {
      var k_47925 = arr[i_47924];
      var v_47926 = arr[i_47924 + 1];
      var idx_47927 = cljs.core.array_index_of(ret, k_47925);
      if (idx_47927 === -1) {
        var G__47923_47928 = ret;
        G__47923_47928.push(k_47925);
        G__47923_47928.push(v_47926);
      } else {
        ret[idx_47927 + 1] = v_47926;
      }
      var G__47929 = i_47924 + 2;
      i_47924 = G__47929;
      continue;
    } else {
    }
    break;
  }
  return new cljs.core.PersistentArrayMap(null, ret.length / 2, ret, null);
};
cljs.core.PersistentArrayMap.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__10266__auto__ = this;
  return cljs.core.es6_iterator(this__10266__auto__);
};
cljs.core.TransientArrayMap = function(editable_QMARK_, len, arr) {
  this.editable_QMARK_ = editable_QMARK_;
  this.len = len;
  this.arr = arr;
  this.cljs$lang$protocol_mask$partition0$ = 258;
  this.cljs$lang$protocol_mask$partition1$ = 56;
};
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    return cljs.core.quot(self__.len, 2);
  } else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var self__ = this;
  var tcoll__$1 = this;
  return tcoll__$1.cljs$core$ILookup$_lookup$arity$3(null, k, null);
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    var idx = cljs.core.array_map_index_of(tcoll__$1, k);
    if (idx === -1) {
      return not_found;
    } else {
      return self__.arr[idx + 1];
    }
  } else {
    throw new Error("lookup after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    if (!(o == null) ? o.cljs$lang$protocol_mask$partition0$ & 2048 || cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IMapEntry$ ? true : !o.cljs$lang$protocol_mask$partition0$ ? cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry, o) : false : cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry, o)) {
      return tcoll__$1.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null, cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.key.call(null, o), cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.val.call(null, o));
    } else {
      var es = cljs.core.seq(o);
      var tcoll__$2 = tcoll__$1;
      while (true) {
        var temp__6736__auto__ = cljs.core.first(es);
        if (cljs.core.truth_(temp__6736__auto__)) {
          var e = temp__6736__auto__;
          var G__47932 = cljs.core.next(es);
          var G__47933 = tcoll__$2.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null, cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.key.call(null, e), cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.val.call(null, e));
          es = G__47932;
          tcoll__$2 = G__47933;
          continue;
        } else {
          return tcoll__$2;
        }
        break;
      }
    }
  } else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    self__.editable_QMARK_ = false;
    return new cljs.core.PersistentArrayMap(null, cljs.core.quot(self__.len, 2), self__.arr, null);
  } else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    var idx = cljs.core.array_map_index_of(tcoll__$1, key);
    if (idx === -1) {
      if (self__.len + 2 <= 2 * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
        self__.len = self__.len + 2;
        self__.arr.push(key);
        self__.arr.push(val);
        return tcoll__$1;
      } else {
        return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2 ? cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2(self__.len, self__.arr) : cljs.core.array__GT_transient_hash_map.call(null, self__.len, self__.arr), key, val);
      }
    } else {
      if (val === self__.arr[idx + 1]) {
        return tcoll__$1;
      } else {
        self__.arr[idx + 1] = val;
        return tcoll__$1;
      }
    }
  } else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    var idx = cljs.core.array_map_index_of(tcoll__$1, key);
    if (idx >= 0) {
      self__.arr[idx] = self__.arr[self__.len - 2];
      self__.arr[idx + 1] = self__.arr[self__.len - 1];
      var G__47931_47934 = self__.arr;
      G__47931_47934.pop();
      G__47931_47934.pop();
      self__.len = self__.len - 2;
    } else {
    }
    return tcoll__$1;
  } else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "editable?", "editable?", -164945806, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "len", "len", -1230778691, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), 
  new cljs.core.Symbol(null, "arr", "arr", 2115492975, null)], null);
};
cljs.core.TransientArrayMap.cljs$lang$type = true;
cljs.core.TransientArrayMap.cljs$lang$ctorStr = "cljs.core/TransientArrayMap";
cljs.core.TransientArrayMap.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/TransientArrayMap");
};
cljs.core.__GT_TransientArrayMap = function cljs$core$__GT_TransientArrayMap(editable_QMARK_, len, arr) {
  return new cljs.core.TransientArrayMap(editable_QMARK_, len, arr);
};
cljs.core.array__GT_transient_hash_map = function cljs$core$array__GT_transient_hash_map(len, arr) {
  var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  var i = 0;
  while (true) {
    if (i < len) {
      var G__47935 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out, arr[i], arr[i + 1]);
      var G__47936 = i + 2;
      out = G__47935;
      i = G__47936;
      continue;
    } else {
      return out;
    }
    break;
  }
};
cljs.core.Box = function(val) {
  this.val = val;
};
cljs.core.Box.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "val", "val", 1769233139, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.Box.cljs$lang$type = true;
cljs.core.Box.cljs$lang$ctorStr = "cljs.core/Box";
cljs.core.Box.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/Box");
};
cljs.core.__GT_Box = function cljs$core$__GT_Box(val) {
  return new cljs.core.Box(val);
};
cljs.core.key_test = function cljs$core$key_test(key, other) {
  if (key === other) {
    return true;
  } else {
    if (cljs.core.keyword_identical_QMARK_(key, other)) {
      return true;
    } else {
      return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key, other);
    }
  }
};
cljs.core.mask = function cljs$core$mask(hash, shift) {
  return hash >>> shift & 31;
};
cljs.core.clone_and_set = function cljs$core$clone_and_set(var_args) {
  var args47937 = [];
  var len__10375__auto___47942 = arguments.length;
  var i__10376__auto___47943 = 0;
  while (true) {
    if (i__10376__auto___47943 < len__10375__auto___47942) {
      args47937.push(arguments[i__10376__auto___47943]);
      var G__47944 = i__10376__auto___47943 + 1;
      i__10376__auto___47943 = G__47944;
      continue;
    } else {
    }
    break;
  }
  var G__47939 = args47937.length;
  switch(G__47939) {
    case 3:
      return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 5:
      return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args47937.length)].join(""));
  }
};
cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3 = function(arr, i, a) {
  var G__47940 = cljs.core.aclone(arr);
  G__47940[i] = a;
  return G__47940;
};
cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5 = function(arr, i, a, j, b) {
  var G__47941 = cljs.core.aclone(arr);
  G__47941[i] = a;
  G__47941[j] = b;
  return G__47941;
};
cljs.core.clone_and_set.cljs$lang$maxFixedArity = 5;
cljs.core.remove_pair = function cljs$core$remove_pair(arr, i) {
  var new_arr = new Array(arr.length - 2);
  cljs.core.array_copy(arr, 0, new_arr, 0, 2 * i);
  cljs.core.array_copy(arr, 2 * (i + 1), new_arr, 2 * i, new_arr.length - 2 * i);
  return new_arr;
};
cljs.core.bitmap_indexed_node_index = function cljs$core$bitmap_indexed_node_index(bitmap, bit) {
  return cljs.core.bit_count(bitmap & bit - 1);
};
cljs.core.bitpos = function cljs$core$bitpos(hash, shift) {
  return 1 << (hash >>> shift & 31);
};
cljs.core.edit_and_set = function cljs$core$edit_and_set(var_args) {
  var args47946 = [];
  var len__10375__auto___47949 = arguments.length;
  var i__10376__auto___47950 = 0;
  while (true) {
    if (i__10376__auto___47950 < len__10375__auto___47949) {
      args47946.push(arguments[i__10376__auto___47950]);
      var G__47951 = i__10376__auto___47950 + 1;
      i__10376__auto___47950 = G__47951;
      continue;
    } else {
    }
    break;
  }
  var G__47948 = args47946.length;
  switch(G__47948) {
    case 4:
      return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 6:
      return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args47946.length)].join(""));
  }
};
cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4 = function(inode, edit, i, a) {
  var editable = inode.ensure_editable(edit);
  editable.arr[i] = a;
  return editable;
};
cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6 = function(inode, edit, i, a, j, b) {
  var editable = inode.ensure_editable(edit);
  editable.arr[i] = a;
  editable.arr[j] = b;
  return editable;
};
cljs.core.edit_and_set.cljs$lang$maxFixedArity = 6;
cljs.core.inode_kv_reduce = function cljs$core$inode_kv_reduce(arr, f, init) {
  var len = arr.length;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < len) {
      var init__$2 = function() {
        var k = arr[i];
        if (!(k == null)) {
          var G__47956 = init__$1;
          var G__47957 = k;
          var G__47958 = arr[i + 1];
          return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__47956, G__47957, G__47958) : f.call(null, G__47956, G__47957, G__47958);
        } else {
          var node = arr[i + 1];
          if (!(node == null)) {
            return node.kv_reduce(f, init__$1);
          } else {
            return init__$1;
          }
        }
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null, init__$2);
      } else {
        var G__47959 = i + 2;
        var G__47960 = init__$2;
        i = G__47959;
        init__$1 = G__47960;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.NodeIterator = function(arr, i, next_entry, next_iter) {
  this.arr = arr;
  this.i = i;
  this.next_entry = next_entry;
  this.next_iter = next_iter;
};
cljs.core.NodeIterator.prototype.advance = function() {
  var self__ = this;
  var this$ = this;
  var len = self__.arr.length;
  while (true) {
    if (self__.i < len) {
      var key = self__.arr[self__.i];
      var node_or_val = self__.arr[self__.i + 1];
      var found = !(key == null) ? self__.next_entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key, node_or_val], null) : !(node_or_val == null) ? function() {
        var new_iter = cljs.core._iterator(node_or_val);
        if (new_iter.hasNext()) {
          return self__.next_iter = new_iter;
        } else {
          return false;
        }
      }() : false;
      self__.i = self__.i + 2;
      if (found) {
        return true;
      } else {
        continue;
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core.NodeIterator.prototype.hasNext = function() {
  var self__ = this;
  var this$ = this;
  var or__9154__auto__ = !(self__.next_entry == null);
  if (or__9154__auto__) {
    return or__9154__auto__;
  } else {
    var or__9154__auto____$1 = !(self__.next_iter == null);
    if (or__9154__auto____$1) {
      return or__9154__auto____$1;
    } else {
      return this$.advance();
    }
  }
};
cljs.core.NodeIterator.prototype.next = function() {
  var self__ = this;
  var this$ = this;
  if (!(self__.next_entry == null)) {
    var ret = self__.next_entry;
    self__.next_entry = null;
    return ret;
  } else {
    if (!(self__.next_iter == null)) {
      var ret = self__.next_iter.next();
      if (self__.next_iter.hasNext()) {
      } else {
        self__.next_iter = null;
      }
      return ret;
    } else {
      if (this$.advance()) {
        return this$.next();
      } else {
        throw new Error("No such element");
      }
    }
  }
};
cljs.core.NodeIterator.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.NodeIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "next-entry", "next-entry", 1091342476, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, 
  "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "next-iter", "next-iter", 1526626239, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.NodeIterator.cljs$lang$type = true;
cljs.core.NodeIterator.cljs$lang$ctorStr = "cljs.core/NodeIterator";
cljs.core.NodeIterator.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/NodeIterator");
};
cljs.core.__GT_NodeIterator = function cljs$core$__GT_NodeIterator(arr, i, next_entry, next_iter) {
  return new cljs.core.NodeIterator(arr, i, next_entry, next_iter);
};
cljs.core.BitmapIndexedNode = function(edit, bitmap, arr) {
  this.edit = edit;
  this.bitmap = bitmap;
  this.arr = arr;
};
cljs.core.BitmapIndexedNode.prototype.ensure_editable = function(e) {
  var self__ = this;
  var inode = this;
  if (e === self__.edit) {
    return inode;
  } else {
    var n = cljs.core.bit_count(self__.bitmap);
    var new_arr = new Array(n < 0 ? 4 : 2 * (n + 1));
    cljs.core.array_copy(self__.arr, 0, new_arr, 0, 2 * n);
    return new cljs.core.BitmapIndexedNode(e, self__.bitmap, new_arr);
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = function(edit__$1, shift, hash, key, removed_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  if ((self__.bitmap & bit) === 0) {
    return inode;
  } else {
    var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      var n = val_or_node.inode_without_BANG_(edit__$1, shift + 5, hash, key, removed_leaf_QMARK_);
      if (n === val_or_node) {
        return inode;
      } else {
        if (!(n == null)) {
          return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, 2 * idx + 1, n);
        } else {
          if (self__.bitmap === bit) {
            return null;
          } else {
            return inode.edit_and_remove_pair(edit__$1, bit, idx);
          }
        }
      }
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        removed_leaf_QMARK_.val = true;
        return inode.edit_and_remove_pair(edit__$1, bit, idx);
      } else {
        return inode;
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = function(e, bit, i) {
  var self__ = this;
  var inode = this;
  if (self__.bitmap === bit) {
    return null;
  } else {
    var editable = inode.ensure_editable(e);
    var earr = editable.arr;
    var len = earr.length;
    editable.bitmap = bit ^ editable.bitmap;
    cljs.core.array_copy(earr, 2 * (i + 1), earr, 2 * i, len - 2 * (i + 1));
    earr[len - 2] = null;
    earr[len - 1] = null;
    return editable;
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_seq = function() {
  var self__ = this;
  var inode = this;
  return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr) : cljs.core.create_inode_seq.call(null, self__.arr);
};
cljs.core.BitmapIndexedNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var inode = this;
  return cljs.core.inode_kv_reduce(self__.arr, f, init);
};
cljs.core.BitmapIndexedNode.prototype.inode_lookup = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  if ((self__.bitmap & bit) === 0) {
    return not_found;
  } else {
    var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      return val_or_node.inode_lookup(shift + 5, hash, key, not_found);
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        return val_or_node;
      } else {
        return not_found;
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = function(edit__$1, shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
  if ((self__.bitmap & bit) === 0) {
    var n = cljs.core.bit_count(self__.bitmap);
    if (2 * n < self__.arr.length) {
      var editable = inode.ensure_editable(edit__$1);
      var earr = editable.arr;
      added_leaf_QMARK_.val = true;
      cljs.core.array_copy_downward(earr, 2 * idx, earr, 2 * (idx + 1), 2 * (n - idx));
      earr[2 * idx] = key;
      earr[2 * idx + 1] = val;
      editable.bitmap = editable.bitmap | bit;
      return editable;
    } else {
      if (n >= 16) {
        var nodes = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
        var jdx = hash >>> shift & 31;
        nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1, shift + 5, hash, key, val, added_leaf_QMARK_);
        var i_47974 = 0;
        var j_47975 = 0;
        while (true) {
          if (i_47974 < 32) {
            if ((self__.bitmap >>> i_47974 & 1) === 0) {
              var G__47976 = i_47974 + 1;
              var G__47977 = j_47975;
              i_47974 = G__47976;
              j_47975 = G__47977;
              continue;
            } else {
              nodes[i_47974] = !(self__.arr[j_47975] == null) ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1, shift + 5, cljs.core.hash(self__.arr[j_47975]), self__.arr[j_47975], self__.arr[j_47975 + 1], added_leaf_QMARK_) : self__.arr[j_47975 + 1];
              var G__47978 = i_47974 + 1;
              var G__47979 = j_47975 + 2;
              i_47974 = G__47978;
              j_47975 = G__47979;
              continue;
            }
          } else {
          }
          break;
        }
        return new cljs.core.ArrayNode(edit__$1, n + 1, nodes);
      } else {
        var new_arr = new Array(2 * (n + 4));
        cljs.core.array_copy(self__.arr, 0, new_arr, 0, 2 * idx);
        new_arr[2 * idx] = key;
        new_arr[2 * idx + 1] = val;
        cljs.core.array_copy(self__.arr, 2 * idx, new_arr, 2 * (idx + 1), 2 * (n - idx));
        added_leaf_QMARK_.val = true;
        var editable = inode.ensure_editable(edit__$1);
        editable.arr = new_arr;
        editable.bitmap = editable.bitmap | bit;
        return editable;
      }
    }
  } else {
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      var n = val_or_node.inode_assoc_BANG_(edit__$1, shift + 5, hash, key, val, added_leaf_QMARK_);
      if (n === val_or_node) {
        return inode;
      } else {
        return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, 2 * idx + 1, n);
      }
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        if (val === val_or_node) {
          return inode;
        } else {
          return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, 2 * idx + 1, val);
        }
      } else {
        added_leaf_QMARK_.val = true;
        return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode, edit__$1, 2 * idx, null, 2 * idx + 1, function() {
          var G__47961 = edit__$1;
          var G__47962 = shift + 5;
          var G__47963 = key_or_nil;
          var G__47964 = val_or_node;
          var G__47965 = hash;
          var G__47966 = key;
          var G__47967 = val;
          return cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(G__47961, G__47962, G__47963, G__47964, G__47965, G__47966, G__47967) : cljs.core.create_node.call(null, G__47961, G__47962, G__47963, G__47964, G__47965, G__47966, G__47967);
        }());
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
  if ((self__.bitmap & bit) === 0) {
    var n = cljs.core.bit_count(self__.bitmap);
    if (n >= 16) {
      var nodes = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
      var jdx = hash >>> shift & 31;
      nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      var i_47980 = 0;
      var j_47981 = 0;
      while (true) {
        if (i_47980 < 32) {
          if ((self__.bitmap >>> i_47980 & 1) === 0) {
            var G__47982 = i_47980 + 1;
            var G__47983 = j_47981;
            i_47980 = G__47982;
            j_47981 = G__47983;
            continue;
          } else {
            nodes[i_47980] = !(self__.arr[j_47981] == null) ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, cljs.core.hash(self__.arr[j_47981]), self__.arr[j_47981], self__.arr[j_47981 + 1], added_leaf_QMARK_) : self__.arr[j_47981 + 1];
            var G__47984 = i_47980 + 1;
            var G__47985 = j_47981 + 2;
            i_47980 = G__47984;
            j_47981 = G__47985;
            continue;
          }
        } else {
        }
        break;
      }
      return new cljs.core.ArrayNode(null, n + 1, nodes);
    } else {
      var new_arr = new Array(2 * (n + 1));
      cljs.core.array_copy(self__.arr, 0, new_arr, 0, 2 * idx);
      new_arr[2 * idx] = key;
      new_arr[2 * idx + 1] = val;
      cljs.core.array_copy(self__.arr, 2 * idx, new_arr, 2 * (idx + 1), 2 * (n - idx));
      added_leaf_QMARK_.val = true;
      return new cljs.core.BitmapIndexedNode(null, self__.bitmap | bit, new_arr);
    }
  } else {
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      var n = val_or_node.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      if (n === val_or_node) {
        return inode;
      } else {
        return new cljs.core.BitmapIndexedNode(null, self__.bitmap, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, 2 * idx + 1, n));
      }
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        if (val === val_or_node) {
          return inode;
        } else {
          return new cljs.core.BitmapIndexedNode(null, self__.bitmap, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, 2 * idx + 1, val));
        }
      } else {
        added_leaf_QMARK_.val = true;
        return new cljs.core.BitmapIndexedNode(null, self__.bitmap, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(self__.arr, 2 * idx, null, 2 * idx + 1, function() {
          var G__47968 = shift + 5;
          var G__47969 = key_or_nil;
          var G__47970 = val_or_node;
          var G__47971 = hash;
          var G__47972 = key;
          var G__47973 = val;
          return cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$6(G__47968, G__47969, G__47970, G__47971, G__47972, G__47973) : cljs.core.create_node.call(null, G__47968, G__47969, G__47970, G__47971, G__47972, G__47973);
        }()));
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_find = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  if ((self__.bitmap & bit) === 0) {
    return not_found;
  } else {
    var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      return val_or_node.inode_find(shift + 5, hash, key, not_found);
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_or_nil, val_or_node], null);
      } else {
        return not_found;
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_without = function(shift, hash, key) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  if ((self__.bitmap & bit) === 0) {
    return inode;
  } else {
    var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      var n = val_or_node.inode_without(shift + 5, hash, key);
      if (n === val_or_node) {
        return inode;
      } else {
        if (!(n == null)) {
          return new cljs.core.BitmapIndexedNode(null, self__.bitmap, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, 2 * idx + 1, n));
        } else {
          if (self__.bitmap === bit) {
            return null;
          } else {
            return new cljs.core.BitmapIndexedNode(null, self__.bitmap ^ bit, cljs.core.remove_pair(self__.arr, idx));
          }
        }
      }
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        return new cljs.core.BitmapIndexedNode(null, self__.bitmap ^ bit, cljs.core.remove_pair(self__.arr, idx));
      } else {
        return inode;
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.BitmapIndexedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.NodeIterator(self__.arr, 0, null, null);
};
cljs.core.BitmapIndexedNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "edit", "edit", -1302639, null), cljs.core.with_meta(new cljs.core.Symbol(null, "bitmap", "bitmap", 501334601, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, 
  "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.BitmapIndexedNode.cljs$lang$type = true;
cljs.core.BitmapIndexedNode.cljs$lang$ctorStr = "cljs.core/BitmapIndexedNode";
cljs.core.BitmapIndexedNode.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/BitmapIndexedNode");
};
cljs.core.__GT_BitmapIndexedNode = function cljs$core$__GT_BitmapIndexedNode(edit, bitmap, arr) {
  return new cljs.core.BitmapIndexedNode(edit, bitmap, arr);
};
cljs.core.BitmapIndexedNode.EMPTY = new cljs.core.BitmapIndexedNode(null, 0, []);
cljs.core.pack_array_node = function cljs$core$pack_array_node(array_node, edit, idx) {
  var arr = array_node.arr;
  var len = arr.length;
  var new_arr = new Array(2 * (array_node.cnt - 1));
  var i = 0;
  var j = 1;
  var bitmap = 0;
  while (true) {
    if (i < len) {
      if (!(i === idx) && !(arr[i] == null)) {
        new_arr[j] = arr[i];
        var G__47986 = i + 1;
        var G__47987 = j + 2;
        var G__47988 = bitmap | 1 << i;
        i = G__47986;
        j = G__47987;
        bitmap = G__47988;
        continue;
      } else {
        var G__47989 = i + 1;
        var G__47990 = j;
        var G__47991 = bitmap;
        i = G__47989;
        j = G__47990;
        bitmap = G__47991;
        continue;
      }
    } else {
      return new cljs.core.BitmapIndexedNode(edit, bitmap, new_arr);
    }
    break;
  }
};
cljs.core.ArrayNodeIterator = function(arr, i, next_iter) {
  this.arr = arr;
  this.i = i;
  this.next_iter = next_iter;
};
cljs.core.ArrayNodeIterator.prototype.hasNext = function() {
  var self__ = this;
  var this$ = this;
  var len = self__.arr.length;
  while (true) {
    if (!(!(self__.next_iter == null) && self__.next_iter.hasNext())) {
      if (self__.i < len) {
        var node = self__.arr[self__.i];
        self__.i = self__.i + 1;
        if (!(node == null)) {
          self__.next_iter = cljs.core._iterator(node);
        } else {
        }
        continue;
      } else {
        return false;
      }
    } else {
      return true;
    }
    break;
  }
};
cljs.core.ArrayNodeIterator.prototype.next = function() {
  var self__ = this;
  var this$ = this;
  if (this$.hasNext()) {
    return self__.next_iter.next();
  } else {
    throw new Error("No such element");
  }
};
cljs.core.ArrayNodeIterator.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.ArrayNodeIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "next-iter", "next-iter", 1526626239, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, 
  "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ArrayNodeIterator.cljs$lang$type = true;
cljs.core.ArrayNodeIterator.cljs$lang$ctorStr = "cljs.core/ArrayNodeIterator";
cljs.core.ArrayNodeIterator.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/ArrayNodeIterator");
};
cljs.core.__GT_ArrayNodeIterator = function cljs$core$__GT_ArrayNodeIterator(arr, i, next_iter) {
  return new cljs.core.ArrayNodeIterator(arr, i, next_iter);
};
cljs.core.ArrayNode = function(edit, cnt, arr) {
  this.edit = edit;
  this.cnt = cnt;
  this.arr = arr;
};
cljs.core.ArrayNode.prototype.ensure_editable = function(e) {
  var self__ = this;
  var inode = this;
  if (e === self__.edit) {
    return inode;
  } else {
    return new cljs.core.ArrayNode(e, self__.cnt, cljs.core.aclone(self__.arr));
  }
};
cljs.core.ArrayNode.prototype.inode_without_BANG_ = function(edit__$1, shift, hash, key, removed_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (node == null) {
    return inode;
  } else {
    var n = node.inode_without_BANG_(edit__$1, shift + 5, hash, key, removed_leaf_QMARK_);
    if (n === node) {
      return inode;
    } else {
      if (n == null) {
        if (self__.cnt <= 8) {
          return cljs.core.pack_array_node(inode, edit__$1, idx);
        } else {
          var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx, n);
          editable.cnt = editable.cnt - 1;
          return editable;
        }
      } else {
        return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx, n);
      }
    }
  }
};
cljs.core.ArrayNode.prototype.inode_seq = function() {
  var self__ = this;
  var inode = this;
  return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(self__.arr) : cljs.core.create_array_node_seq.call(null, self__.arr);
};
cljs.core.ArrayNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var inode = this;
  var len = self__.arr.length;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < len) {
      var node = self__.arr[i];
      if (!(node == null)) {
        var init__$2 = node.kv_reduce(f, init__$1);
        if (cljs.core.reduced_QMARK_(init__$2)) {
          return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null, init__$2);
        } else {
          var G__47992 = i + 1;
          var G__47993 = init__$2;
          i = G__47992;
          init__$1 = G__47993;
          continue;
        }
      } else {
        var G__47994 = i + 1;
        var G__47995 = init__$1;
        i = G__47994;
        init__$1 = G__47995;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.ArrayNode.prototype.inode_lookup = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (!(node == null)) {
    return node.inode_lookup(shift + 5, hash, key, not_found);
  } else {
    return not_found;
  }
};
cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = function(edit__$1, shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (node == null) {
    var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1, shift + 5, hash, key, val, added_leaf_QMARK_));
    editable.cnt = editable.cnt + 1;
    return editable;
  } else {
    var n = node.inode_assoc_BANG_(edit__$1, shift + 5, hash, key, val, added_leaf_QMARK_);
    if (n === node) {
      return inode;
    } else {
      return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx, n);
    }
  }
};
cljs.core.ArrayNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (node == null) {
    return new cljs.core.ArrayNode(null, self__.cnt + 1, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_)));
  } else {
    var n = node.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
    if (n === node) {
      return inode;
    } else {
      return new cljs.core.ArrayNode(null, self__.cnt, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx, n));
    }
  }
};
cljs.core.ArrayNode.prototype.inode_find = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (!(node == null)) {
    return node.inode_find(shift + 5, hash, key, not_found);
  } else {
    return not_found;
  }
};
cljs.core.ArrayNode.prototype.inode_without = function(shift, hash, key) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (!(node == null)) {
    var n = node.inode_without(shift + 5, hash, key);
    if (n === node) {
      return inode;
    } else {
      if (n == null) {
        if (self__.cnt <= 8) {
          return cljs.core.pack_array_node(inode, null, idx);
        } else {
          return new cljs.core.ArrayNode(null, self__.cnt - 1, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx, n));
        }
      } else {
        return new cljs.core.ArrayNode(null, self__.cnt, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx, n));
      }
    }
  } else {
    return inode;
  }
};
cljs.core.ArrayNode.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.ArrayNode.prototype.cljs$core$IIterable$_iterator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.ArrayNodeIterator(self__.arr, 0, null);
};
cljs.core.ArrayNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "edit", "edit", -1302639, null), cljs.core.with_meta(new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, 
  "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ArrayNode.cljs$lang$type = true;
cljs.core.ArrayNode.cljs$lang$ctorStr = "cljs.core/ArrayNode";
cljs.core.ArrayNode.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/ArrayNode");
};
cljs.core.__GT_ArrayNode = function cljs$core$__GT_ArrayNode(edit, cnt, arr) {
  return new cljs.core.ArrayNode(edit, cnt, arr);
};
cljs.core.hash_collision_node_find_index = function cljs$core$hash_collision_node_find_index(arr, cnt, key) {
  var lim = 2 * cnt;
  var i = 0;
  while (true) {
    if (i < lim) {
      if (cljs.core.key_test(key, arr[i])) {
        return i;
      } else {
        var G__47996 = i + 2;
        i = G__47996;
        continue;
      }
    } else {
      return -1;
    }
    break;
  }
};
cljs.core.HashCollisionNode = function(edit, collision_hash, cnt, arr) {
  this.edit = edit;
  this.collision_hash = collision_hash;
  this.cnt = cnt;
  this.arr = arr;
};
cljs.core.HashCollisionNode.prototype.ensure_editable = function(e) {
  var self__ = this;
  var inode = this;
  if (e === self__.edit) {
    return inode;
  } else {
    var new_arr = new Array(2 * (self__.cnt + 1));
    cljs.core.array_copy(self__.arr, 0, new_arr, 0, 2 * self__.cnt);
    return new cljs.core.HashCollisionNode(e, self__.collision_hash, self__.cnt, new_arr);
  }
};
cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = function(edit__$1, shift, hash, key, removed_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
  if (idx === -1) {
    return inode;
  } else {
    removed_leaf_QMARK_.val = true;
    if (self__.cnt === 1) {
      return null;
    } else {
      var editable = inode.ensure_editable(edit__$1);
      var earr = editable.arr;
      earr[idx] = earr[2 * self__.cnt - 2];
      earr[idx + 1] = earr[2 * self__.cnt - 1];
      earr[2 * self__.cnt - 1] = null;
      earr[2 * self__.cnt - 2] = null;
      editable.cnt = editable.cnt - 1;
      return editable;
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_seq = function() {
  var self__ = this;
  var inode = this;
  return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr) : cljs.core.create_inode_seq.call(null, self__.arr);
};
cljs.core.HashCollisionNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var inode = this;
  return cljs.core.inode_kv_reduce(self__.arr, f, init);
};
cljs.core.HashCollisionNode.prototype.inode_lookup = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
  if (idx < 0) {
    return not_found;
  } else {
    if (cljs.core.key_test(key, self__.arr[idx])) {
      return self__.arr[idx + 1];
    } else {
      return not_found;
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = function(edit__$1, shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  if (hash === self__.collision_hash) {
    var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
    if (idx === -1) {
      if (self__.arr.length > 2 * self__.cnt) {
        var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode, edit__$1, 2 * self__.cnt, key, 2 * self__.cnt + 1, val);
        added_leaf_QMARK_.val = true;
        editable.cnt = editable.cnt + 1;
        return editable;
      } else {
        var len = self__.arr.length;
        var new_arr = new Array(len + 2);
        cljs.core.array_copy(self__.arr, 0, new_arr, 0, len);
        new_arr[len] = key;
        new_arr[len + 1] = val;
        added_leaf_QMARK_.val = true;
        return inode.ensure_editable_array(edit__$1, self__.cnt + 1, new_arr);
      }
    } else {
      if (self__.arr[idx + 1] === val) {
        return inode;
      } else {
        return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx + 1, val);
      }
    }
  } else {
    return (new cljs.core.BitmapIndexedNode(edit__$1, 1 << (self__.collision_hash >>> shift & 31), [null, inode, null, null])).inode_assoc_BANG_(edit__$1, shift, hash, key, val, added_leaf_QMARK_);
  }
};
cljs.core.HashCollisionNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  if (hash === self__.collision_hash) {
    var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
    if (idx === -1) {
      var len = 2 * self__.cnt;
      var new_arr = new Array(len + 2);
      cljs.core.array_copy(self__.arr, 0, new_arr, 0, len);
      new_arr[len] = key;
      new_arr[len + 1] = val;
      added_leaf_QMARK_.val = true;
      return new cljs.core.HashCollisionNode(null, self__.collision_hash, self__.cnt + 1, new_arr);
    } else {
      if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(self__.arr[idx + 1], val)) {
        return inode;
      } else {
        return new cljs.core.HashCollisionNode(null, self__.collision_hash, self__.cnt, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx + 1, val));
      }
    }
  } else {
    return (new cljs.core.BitmapIndexedNode(null, 1 << (self__.collision_hash >>> shift & 31), [null, inode])).inode_assoc(shift, hash, key, val, added_leaf_QMARK_);
  }
};
cljs.core.HashCollisionNode.prototype.ensure_editable_array = function(e, count, array) {
  var self__ = this;
  var inode = this;
  if (e === self__.edit) {
    self__.arr = array;
    self__.cnt = count;
    return inode;
  } else {
    return new cljs.core.HashCollisionNode(self__.edit, self__.collision_hash, count, array);
  }
};
cljs.core.HashCollisionNode.prototype.inode_find = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
  if (idx < 0) {
    return not_found;
  } else {
    if (cljs.core.key_test(key, self__.arr[idx])) {
      return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.arr[idx], self__.arr[idx + 1]], null);
    } else {
      return not_found;
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_without = function(shift, hash, key) {
  var self__ = this;
  var inode = this;
  var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
  if (idx === -1) {
    return inode;
  } else {
    if (self__.cnt === 1) {
      return null;
    } else {
      return new cljs.core.HashCollisionNode(null, self__.collision_hash, self__.cnt - 1, cljs.core.remove_pair(self__.arr, cljs.core.quot(idx, 2)));
    }
  }
};
cljs.core.HashCollisionNode.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.HashCollisionNode.prototype.cljs$core$IIterable$_iterator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.NodeIterator(self__.arr, 0, null, null);
};
cljs.core.HashCollisionNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "edit", "edit", -1302639, null), cljs.core.with_meta(new cljs.core.Symbol(null, "collision-hash", "collision-hash", -35831342, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, 
  "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.HashCollisionNode.cljs$lang$type = true;
cljs.core.HashCollisionNode.cljs$lang$ctorStr = "cljs.core/HashCollisionNode";
cljs.core.HashCollisionNode.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/HashCollisionNode");
};
cljs.core.__GT_HashCollisionNode = function cljs$core$__GT_HashCollisionNode(edit, collision_hash, cnt, arr) {
  return new cljs.core.HashCollisionNode(edit, collision_hash, cnt, arr);
};
cljs.core.create_node = function cljs$core$create_node(var_args) {
  var args47997 = [];
  var len__10375__auto___48000 = arguments.length;
  var i__10376__auto___48001 = 0;
  while (true) {
    if (i__10376__auto___48001 < len__10375__auto___48000) {
      args47997.push(arguments[i__10376__auto___48001]);
      var G__48002 = i__10376__auto___48001 + 1;
      i__10376__auto___48001 = G__48002;
      continue;
    } else {
    }
    break;
  }
  var G__47999 = args47997.length;
  switch(G__47999) {
    case 6:
      return cljs.core.create_node.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    case 7:
      return cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args47997.length)].join(""));
  }
};
cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 = function(shift, key1, val1, key2hash, key2, val2) {
  var key1hash = cljs.core.hash(key1);
  if (key1hash === key2hash) {
    return new cljs.core.HashCollisionNode(null, key1hash, 2, [key1, val1, key2, val2]);
  } else {
    var added_leaf_QMARK_ = new cljs.core.Box(false);
    return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift, key1hash, key1, val1, added_leaf_QMARK_).inode_assoc(shift, key2hash, key2, val2, added_leaf_QMARK_);
  }
};
cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 = function(edit, shift, key1, val1, key2hash, key2, val2) {
  var key1hash = cljs.core.hash(key1);
  if (key1hash === key2hash) {
    return new cljs.core.HashCollisionNode(null, key1hash, 2, [key1, val1, key2, val2]);
  } else {
    var added_leaf_QMARK_ = new cljs.core.Box(false);
    return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift, key1hash, key1, val1, added_leaf_QMARK_).inode_assoc_BANG_(edit, shift, key2hash, key2, val2, added_leaf_QMARK_);
  }
};
cljs.core.create_node.cljs$lang$maxFixedArity = 7;
cljs.core.NodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32374860;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.NodeSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.NodeSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.NodeSeq.prototype.indexOf = function() {
  var G__48010 = null;
  var G__48010__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__48010__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__48010 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__48010__1.call(this, x);
      case 2:
        return G__48010__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__48010.cljs$core$IFn$_invoke$arity$1 = G__48010__1;
  G__48010.cljs$core$IFn$_invoke$arity$2 = G__48010__2;
  return G__48010;
}();
cljs.core.NodeSeq.prototype.lastIndexOf = function() {
  var G__48011 = null;
  var G__48011__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__48011__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__48011 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__48011__1.call(this, x);
      case 2:
        return G__48011__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__48011.cljs$core$IFn$_invoke$arity$1 = G__48011__1;
  G__48011.cljs$core$IFn$_invoke$arity$2 = G__48011__2;
  return G__48011;
}();
cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__9596__auto__ = self__.__hash;
  if (!(h__9596__auto__ == null)) {
    return h__9596__auto__;
  } else {
    var h__9596__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__9596__auto____$1;
    return h__9596__auto____$1;
  }
};
cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.s == null) {
    return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.nodes[self__.i], self__.nodes[self__.i + 1]], null);
  } else {
    return cljs.core.first(self__.s);
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var ret = self__.s == null ? function() {
    var G__48004 = self__.nodes;
    var G__48005 = self__.i + 2;
    var G__48006 = null;
    return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__48004, G__48005, G__48006) : cljs.core.create_inode_seq.call(null, G__48004, G__48005, G__48006);
  }() : function() {
    var G__48007 = self__.nodes;
    var G__48008 = self__.i;
    var G__48009 = cljs.core.next(self__.s);
    return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__48007, G__48008, G__48009) : cljs.core.create_inode_seq.call(null, G__48007, G__48008, G__48009);
  }();
  if (!(ret == null)) {
    return ret;
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1;
};
cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.NodeSeq(meta__$1, self__.nodes, self__.i, self__.s, self__.__hash);
};
cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.NodeSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "nodes", "nodes", -459054278, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "s", "s", -948495851, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 
  875778266), true], null))], null);
};
cljs.core.NodeSeq.cljs$lang$type = true;
cljs.core.NodeSeq.cljs$lang$ctorStr = "cljs.core/NodeSeq";
cljs.core.NodeSeq.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/NodeSeq");
};
cljs.core.__GT_NodeSeq = function cljs$core$__GT_NodeSeq(meta, nodes, i, s, __hash) {
  return new cljs.core.NodeSeq(meta, nodes, i, s, __hash);
};
cljs.core.NodeSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__10266__auto__ = this;
  return cljs.core.es6_iterator(this__10266__auto__);
};
cljs.core.create_inode_seq = function cljs$core$create_inode_seq(var_args) {
  var args48012 = [];
  var len__10375__auto___48015 = arguments.length;
  var i__10376__auto___48016 = 0;
  while (true) {
    if (i__10376__auto___48016 < len__10375__auto___48015) {
      args48012.push(arguments[i__10376__auto___48016]);
      var G__48017 = i__10376__auto___48016 + 1;
      i__10376__auto___48016 = G__48017;
      continue;
    } else {
    }
    break;
  }
  var G__48014 = args48012.length;
  switch(G__48014) {
    case 1:
      return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 3:
      return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args48012.length)].join(""));
  }
};
cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 = function(nodes) {
  return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(nodes, 0, null);
};
cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 = function(nodes, i, s) {
  if (s == null) {
    var len = nodes.length;
    var j = i;
    while (true) {
      if (j < len) {
        if (!(nodes[j] == null)) {
          return new cljs.core.NodeSeq(null, nodes, j, null, null);
        } else {
          var temp__6736__auto__ = nodes[j + 1];
          if (cljs.core.truth_(temp__6736__auto__)) {
            var node = temp__6736__auto__;
            var temp__6736__auto____$1 = node.inode_seq();
            if (cljs.core.truth_(temp__6736__auto____$1)) {
              var node_seq = temp__6736__auto____$1;
              return new cljs.core.NodeSeq(null, nodes, j + 2, node_seq, null);
            } else {
              var G__48019 = j + 2;
              j = G__48019;
              continue;
            }
          } else {
            var G__48020 = j + 2;
            j = G__48020;
            continue;
          }
        }
      } else {
        return null;
      }
      break;
    }
  } else {
    return new cljs.core.NodeSeq(null, nodes, i, s, null);
  }
};
cljs.core.create_inode_seq.cljs$lang$maxFixedArity = 3;
cljs.core.ArrayNodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32374860;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.ArrayNodeSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ArrayNodeSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ArrayNodeSeq.prototype.indexOf = function() {
  var G__48025 = null;
  var G__48025__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__48025__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__48025 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__48025__1.call(this, x);
      case 2:
        return G__48025__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__48025.cljs$core$IFn$_invoke$arity$1 = G__48025__1;
  G__48025.cljs$core$IFn$_invoke$arity$2 = G__48025__2;
  return G__48025;
}();
cljs.core.ArrayNodeSeq.prototype.lastIndexOf = function() {
  var G__48026 = null;
  var G__48026__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__48026__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__48026 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__48026__1.call(this, x);
      case 2:
        return G__48026__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__48026.cljs$core$IFn$_invoke$arity$1 = G__48026__1;
  G__48026.cljs$core$IFn$_invoke$arity$2 = G__48026__2;
  return G__48026;
}();
cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__9596__auto__ = self__.__hash;
  if (!(h__9596__auto__ == null)) {
    return h__9596__auto__;
  } else {
    var h__9596__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__9596__auto____$1;
    return h__9596__auto____$1;
  }
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.first(self__.s);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var ret = function() {
    var G__48021 = null;
    var G__48022 = self__.nodes;
    var G__48023 = self__.i;
    var G__48024 = cljs.core.next(self__.s);
    return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(G__48021, G__48022, G__48023, G__48024) : cljs.core.create_array_node_seq.call(null, G__48021, G__48022, G__48023, G__48024);
  }();
  if (!(ret == null)) {
    return ret;
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1;
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.ArrayNodeSeq(meta__$1, self__.nodes, self__.i, self__.s, self__.__hash);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.ArrayNodeSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "nodes", "nodes", -459054278, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "s", "s", -948495851, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 
  875778266), true], null))], null);
};
cljs.core.ArrayNodeSeq.cljs$lang$type = true;
cljs.core.ArrayNodeSeq.cljs$lang$ctorStr = "cljs.core/ArrayNodeSeq";
cljs.core.ArrayNodeSeq.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/ArrayNodeSeq");
};
cljs.core.__GT_ArrayNodeSeq = function cljs$core$__GT_ArrayNodeSeq(meta, nodes, i, s, __hash) {
  return new cljs.core.ArrayNodeSeq(meta, nodes, i, s, __hash);
};
cljs.core.ArrayNodeSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__10266__auto__ = this;
  return cljs.core.es6_iterator(this__10266__auto__);
};
cljs.core.create_array_node_seq = function cljs$core$create_array_node_seq(var_args) {
  var args48027 = [];
  var len__10375__auto___48030 = arguments.length;
  var i__10376__auto___48031 = 0;
  while (true) {
    if (i__10376__auto___48031 < len__10375__auto___48030) {
      args48027.push(arguments[i__10376__auto___48031]);
      var G__48032 = i__10376__auto___48031 + 1;
      i__10376__auto___48031 = G__48032;
      continue;
    } else {
    }
    break;
  }
  var G__48029 = args48027.length;
  switch(G__48029) {
    case 1:
      return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 4:
      return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(args48027.length)].join(""));
  }
};
cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 = function(nodes) {
  return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(null, nodes, 0, null);
};
cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 = function(meta, nodes, i, s) {
  if (s == null) {
    var len = nodes.length;
    var j = i;
    while (true) {
      if (j < len) {
        var temp__6736__auto__ = nodes[j];
        if (cljs.core.truth_(temp__6736__auto__)) {
          var nj = temp__6736__auto__;
          var temp__6736__auto____$1 = nj.inode_seq();
          if (cljs.core.truth_(temp__6736__auto____$1)) {
            var ns = temp__6736__auto____$1;
            return new cljs.core.ArrayNodeSeq(meta, nodes, j + 1, ns, null);
          } else {
            var G__48034 = j + 1;
            j = G__48034;
            continue;
          }
        } else {
          var G__48035 = j + 1;
          j = G__48035;
          continue;
        }
      } else {
        return null;
      }
      break;
    }
  } else {
    return new cljs.core.ArrayNodeSeq(meta, nodes, i, s, null);
  }
};
cljs.core.create_array_node_seq.cljs$lang$maxFixedArity = 4;
cljs.core.HashMapIter = function(nil_val, root_iter, seen) {
  this.nil_val = nil_val;
  this.root_iter = root_iter;
  this.seen = seen;
};
cljs.core.HashMapIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return !self__.seen || self__.root_iter.hasNext();
};
cljs.core.HashMapIter.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (!self__.seen) {
    self__.seen = true;
    return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null, self__.nil_val], null);
  } else {
    return self__.root_iter.next();
  }
};
cljs.core.HashMapIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.HashMapIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "nil-val", "nil-val", -513933559, null), new cljs.core.Symbol(null, "root-iter", "root-iter", 1974672108, null), cljs.core.with_meta(new cljs.core.Symbol(null, "seen", "seen", 1121531738, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.HashMapIter.cljs$lang$type = true;
cljs.core.HashMapIter.cljs$lang$ctorStr = "cljs.core/HashMapIter";
cljs.core.HashMapIter.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/HashMapIter");
};
cljs.core.__GT_HashMapIter = function cljs$core$__GT_HashMapIter(nil_val, root_iter, seen) {
  return new cljs.core.HashMapIter(nil_val, root_iter, seen);
};
cljs.core.PersistentHashMap = function(meta, cnt, root, has_nil_QMARK_, nil_val, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.root = root;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 16123663;
  this.cljs$lang$protocol_mask$partition1$ = 8196;
};
cljs.core.PersistentHashMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.PersistentHashMap.prototype.cljs$core$IFind$_find$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.has_nil_QMARK_) {
    return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null, self__.nil_val], null);
  } else {
    return self__.root.inode_find(0, cljs.core.hash(k), k, null);
  }
};
cljs.core.PersistentHashMap.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentHashMap.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentHashMap.prototype.keys = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.keys.call(null, coll));
};
cljs.core.PersistentHashMap.prototype.entries = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentHashMap.prototype.values = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.vals.call(null, coll));
};
cljs.core.PersistentHashMap.prototype.has = function(k) {
  var self__ = this;
  var coll = this;
  return cljs.core.contains_QMARK_(coll, k);
};
cljs.core.PersistentHashMap.prototype.get = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentHashMap.prototype.forEach = function(f) {
  var self__ = this;
  var coll = this;
  var seq__48037 = cljs.core.seq(coll);
  var chunk__48038 = null;
  var count__48039 = 0;
  var i__48040 = 0;
  while (true) {
    if (i__48040 < count__48039) {
      var vec__48041 = chunk__48038.cljs$core$IIndexed$_nth$arity$2(null, i__48040);
      var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48041, 0, null);
      var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48041, 1, null);
      f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v, k) : f.call(null, v, k);
      var G__48049 = seq__48037;
      var G__48050 = chunk__48038;
      var G__48051 = count__48039;
      var G__48052 = i__48040 + 1;
      seq__48037 = G__48049;
      chunk__48038 = G__48050;
      count__48039 = G__48051;
      i__48040 = G__48052;
      continue;
    } else {
      var temp__6738__auto__ = cljs.core.seq(seq__48037);
      if (temp__6738__auto__) {
        var seq__48037__$1 = temp__6738__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__48037__$1)) {
          var c__10065__auto__ = cljs.core.chunk_first(seq__48037__$1);
          var G__48053 = cljs.core.chunk_rest(seq__48037__$1);
          var G__48054 = c__10065__auto__;
          var G__48055 = cljs.core.count(c__10065__auto__);
          var G__48056 = 0;
          seq__48037 = G__48053;
          chunk__48038 = G__48054;
          count__48039 = G__48055;
          i__48040 = G__48056;
          continue;
        } else {
          var vec__48044 = cljs.core.first(seq__48037__$1);
          var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48044, 0, null);
          var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48044, 1, null);
          f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v, k) : f.call(null, v, k);
          var G__48057 = cljs.core.next(seq__48037__$1);
          var G__48058 = null;
          var G__48059 = 0;
          var G__48060 = 0;
          seq__48037 = G__48057;
          chunk__48038 = G__48058;
          count__48039 = G__48059;
          i__48040 = G__48060;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1.cljs$core$ILookup$_lookup$arity$3(null, k, null);
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_) {
      return self__.nil_val;
    } else {
      return not_found;
    }
  } else {
    if (self__.root == null) {
      return not_found;
    } else {
      return self__.root.inode_lookup(0, cljs.core.hash(k), k, not_found);
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  var init__$1 = self__.has_nil_QMARK_ ? f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(init, null, self__.nil_val) : f.call(null, init, null, self__.nil_val) : init;
  if (cljs.core.reduced_QMARK_(init__$1)) {
    return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$1) : cljs.core.deref.call(null, init__$1);
  } else {
    if (!(self__.root == null)) {
      return self__.root.kv_reduce(f, init__$1);
    } else {
      return init__$1;
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.PersistentHashMap.prototype.cljs$core$IIterable$_iterator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var root_iter = self__.root ? cljs.core._iterator(self__.root) : cljs.core.nil_iter();
  if (self__.has_nil_QMARK_) {
    return new cljs.core.HashMapIter(self__.nil_val, root_iter, false);
  } else {
    return root_iter;
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentHashMap(self__.meta, self__.cnt, self__.root, self__.has_nil_QMARK_, self__.nil_val, self__.__hash);
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.cnt;
};
cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__9596__auto__ = self__.__hash;
  if (!(h__9596__auto__ == null)) {
    return h__9596__auto__;
  } else {
    var h__9596__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__9596__auto____$1;
    return h__9596__auto____$1;
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_map(coll__$1, other);
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.TransientHashMap({}, self__.root, self__.cnt, self__.has_nil_QMARK_, self__.nil_val);
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.PersistentHashMap.EMPTY, self__.meta);
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_) {
      return new cljs.core.PersistentHashMap(self__.meta, self__.cnt - 1, self__.root, false, null, null);
    } else {
      return coll__$1;
    }
  } else {
    if (self__.root == null) {
      return coll__$1;
    } else {
      var new_root = self__.root.inode_without(0, cljs.core.hash(k), k);
      if (new_root === self__.root) {
        return coll__$1;
      } else {
        return new cljs.core.PersistentHashMap(self__.meta, self__.cnt - 1, new_root, self__.has_nil_QMARK_, self__.nil_val, null);
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_ && v === self__.nil_val) {
      return coll__$1;
    } else {
      return new cljs.core.PersistentHashMap(self__.meta, self__.has_nil_QMARK_ ? self__.cnt : self__.cnt + 1, self__.root, true, v, null);
    }
  } else {
    var added_leaf_QMARK_ = new cljs.core.Box(false);
    var new_root = (self__.root == null ? cljs.core.BitmapIndexedNode.EMPTY : self__.root).inode_assoc(0, cljs.core.hash(k), k, v, added_leaf_QMARK_);
    if (new_root === self__.root) {
      return coll__$1;
    } else {
      return new cljs.core.PersistentHashMap(self__.meta, added_leaf_QMARK_.val ? self__.cnt + 1 : self__.cnt, new_root, self__.has_nil_QMARK_, self__.nil_val, null);
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (k == null) {
    return self__.has_nil_QMARK_;
  } else {
    if (self__.root == null) {
      return false;
    } else {
      return !(self__.root.inode_lookup(0, cljs.core.hash(k), k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel);
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    var s = !(self__.root == null) ? self__.root.inode_seq() : null;
    if (self__.has_nil_QMARK_) {
      return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null, self__.nil_val], null), s);
    } else {
      return s;
    }
  } else {
    return null;
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentHashMap(meta__$1, self__.cnt, self__.root, self__.has_nil_QMARK_, self__.nil_val, self__.__hash);
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.vector_QMARK_(entry)) {
    return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 1));
  } else {
    var ret = coll__$1;
    var es = cljs.core.seq(entry);
    while (true) {
      if (es == null) {
        return ret;
      } else {
        var e = cljs.core.first(es);
        if (cljs.core.vector_QMARK_(e)) {
          var G__48061 = ret.cljs$core$IAssociative$_assoc$arity$3(null, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 1));
          var G__48062 = cljs.core.next(es);
          ret = G__48061;
          es = G__48062;
          continue;
        } else {
          throw new Error("conj on a map takes map entries or seqables of map entries");
        }
      }
      break;
    }
  }
};
cljs.core.PersistentHashMap.prototype.call = function() {
  var G__48063 = null;
  var G__48063__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__48063__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__48063 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__48063__2.call(this, self__, k);
      case 3:
        return G__48063__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__48063.cljs$core$IFn$_invoke$arity$2 = G__48063__2;
  G__48063.cljs$core$IFn$_invoke$arity$3 = G__48063__3;
  return G__48063;
}();
cljs.core.PersistentHashMap.prototype.apply = function(self__, args48036) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args48036)));
};
cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentHashMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "root", "root", 1191874074, null), cljs.core.with_meta(new cljs.core.Symbol(null, "has-nil?", "has-nil?", 825886722, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "tag", "tag", -1290361223), new cljs.core.Symbol(null, "boolean", 
  "boolean", -278886877, null)], null)), new cljs.core.Symbol(null, "nil-val", "nil-val", -513933559, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.PersistentHashMap.cljs$lang$type = true;
cljs.core.PersistentHashMap.cljs$lang$ctorStr = "cljs.core/PersistentHashMap";
cljs.core.PersistentHashMap.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/PersistentHashMap");
};
cljs.core.__GT_PersistentHashMap = function cljs$core$__GT_PersistentHashMap(meta, cnt, root, has_nil_QMARK_, nil_val, __hash) {
  return new cljs.core.PersistentHashMap(meta, cnt, root, has_nil_QMARK_, nil_val, __hash);
};
cljs.core.PersistentHashMap.EMPTY = new cljs.core.PersistentHashMap(null, 0, null, false, null, cljs.core.empty_unordered_hash);
cljs.core.PersistentHashMap.fromArray = function(arr, no_clone) {
  var arr__$1 = no_clone ? arr : cljs.core.aclone(arr);
  var len = arr__$1.length;
  var i = 0;
  var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  while (true) {
    if (i < len) {
      var G__48064 = i + 2;
      var G__48065 = cljs.core._assoc_BANG_(ret, arr__$1[i], arr__$1[i + 1]);
      i = G__48064;
      ret = G__48065;
      continue;
    } else {
      return cljs.core._persistent_BANG_(ret);
    }
    break;
  }
};
cljs.core.PersistentHashMap.fromArrays = function(ks, vs) {
  var len = ks.length;
  var i = 0;
  var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  while (true) {
    if (i < len) {
      var G__48066 = i + 1;
      var G__48067 = out.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null, ks[i], vs[i]);
      i = G__48066;
      out = G__48067;
      continue;
    } else {
      return cljs.core.persistent_BANG_(out);
    }
    break;
  }
};
cljs.core.PersistentHashMap.createWithCheck = function(arr) {
  var len = arr.length;
  var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  var i_48068 = 0;
  while (true) {
    if (i_48068 < len) {
      cljs.core._assoc_BANG_(ret, arr[i_48068], arr[i_48068 + 1]);
      if (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core._count(ret), i_48068 / 2 + 1)) {
        throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Duplicate key: "), cljs.core.str.cljs$core$IFn$_invoke$arity$1(arr[i_48068])].join(""));
      } else {
        var G__48069 = i_48068 + 2;
        i_48068 = G__48069;
        continue;
      }
    } else {
    }
    break;
  }
  return cljs.core._persistent_BANG_(ret);
};
cljs.core.PersistentHashMap.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__10266__auto__ = this;
  return cljs.core.es6_iterator(this__10266__auto__);
};
cljs.core.TransientHashMap = function(edit, root, count, has_nil_QMARK_, nil_val) {
  this.edit = edit;
  this.root = root;
  this.count = count;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.cljs$lang$protocol_mask$partition0$ = 258;
  this.cljs$lang$protocol_mask$partition1$ = 56;
};
cljs.core.TransientHashMap.prototype.conj_BANG_ = function(o) {
  var self__ = this;
  var tcoll = this;
  if (self__.edit) {
    if (!(o == null) ? o.cljs$lang$protocol_mask$partition0$ & 2048 || cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IMapEntry$ ? true : !o.cljs$lang$protocol_mask$partition0$ ? cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry, o) : false : cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry, o)) {
      return tcoll.assoc_BANG_(cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.key.call(null, o), cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.val.call(null, o));
    } else {
      var es = cljs.core.seq(o);
      var tcoll__$1 = tcoll;
      while (true) {
        var temp__6736__auto__ = cljs.core.first(es);
        if (cljs.core.truth_(temp__6736__auto__)) {
          var e = temp__6736__auto__;
          var G__48071 = cljs.core.next(es);
          var G__48072 = tcoll__$1.assoc_BANG_(cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.key.call(null, e), cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.val.call(null, e));
          es = G__48071;
          tcoll__$1 = G__48072;
          continue;
        } else {
          return tcoll__$1;
        }
        break;
      }
    }
  } else {
    throw new Error("conj! after persistent");
  }
};
cljs.core.TransientHashMap.prototype.assoc_BANG_ = function(k, v) {
  var self__ = this;
  var tcoll = this;
  if (self__.edit) {
    if (k == null) {
      if (self__.nil_val === v) {
      } else {
        self__.nil_val = v;
      }
      if (self__.has_nil_QMARK_) {
      } else {
        self__.count = self__.count + 1;
        self__.has_nil_QMARK_ = true;
      }
      return tcoll;
    } else {
      var added_leaf_QMARK_ = new cljs.core.Box(false);
      var node = (self__.root == null ? cljs.core.BitmapIndexedNode.EMPTY : self__.root).inode_assoc_BANG_(self__.edit, 0, cljs.core.hash(k), k, v, added_leaf_QMARK_);
      if (node === self__.root) {
      } else {
        self__.root = node;
      }
      if (added_leaf_QMARK_.val) {
        self__.count = self__.count + 1;
      } else {
      }
      return tcoll;
    }
  } else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.without_BANG_ = function(k) {
  var self__ = this;
  var tcoll = this;
  if (self__.edit) {
    if (k == null) {
      if (self__.has_nil_QMARK_) {
        self__.has_nil_QMARK_ = false;
        self__.nil_val = null;
        self__.count = self__.count - 1;
        return tcoll;
      } else {
        return tcoll;
      }
    } else {
      if (self__.root == null) {
        return tcoll;
      } else {
        var removed_leaf_QMARK_ = new cljs.core.Box(false);
        var node = self__.root.inode_without_BANG_(self__.edit, 0, cljs.core.hash(k), k, removed_leaf_QMARK_);
        if (node === self__.root) {
        } else {
          self__.root = node;
        }
        if (removed_leaf_QMARK_.val) {
          self__.count = self__.count - 1;
        } else {
        }
        return tcoll;
      }
    }
  } else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.persistent_BANG_ = function() {
  var self__ = this;
  var tcoll = this;
  if (self__.edit) {
    self__.edit = null;
    return new cljs.core.PersistentHashMap(null, self__.count, self__.root, self__.has_nil_QMARK_, self__.nil_val, null);
  } else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.edit) {
    return self__.count;
  } else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var self__ = this;
  var tcoll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_) {
      return self__.nil_val;
    } else {
      return null;
    }
  } else {
    if (self__.root == null) {
      return null;
    } else {
      return self__.root.inode_lookup(0, cljs.core.hash(k), k);
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var self__ = this;
  var tcoll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_) {
      return self__.nil_val;
    } else {
      return not_found;
    }
  } else {
    if (self__.root == null) {
      return not_found;
    } else {
      return self__.root.inode_lookup(0, cljs.core.hash(k), k, not_found);
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, val) {
  var self__ = this;
  var tcoll__$1 = this;
  return tcoll__$1.conj_BANG_(val);
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  return tcoll__$1.persistent_BANG_();
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var self__ = this;
  var tcoll__$1 = this;
  return tcoll__$1.assoc_BANG_(key, val);
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var self__ = this;
  var tcoll__$1 = this;
  return tcoll__$1.without_BANG_(key);
};
cljs.core.TransientHashMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "edit", "edit", -1302639, null), new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null, "tag", "tag", -1290361223), new cljs.core.Symbol(null, "boolean", "boolean", -278886877, null), new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "root", "root", 1191874074, null), new cljs.core.PersistentArrayMap(null, 
  1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "count", "count", -514511684, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "has-nil?", "has-nil?", 825886722, null), new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null, "tag", "tag", -1290361223), new cljs.core.Symbol(null, 
  "boolean", "boolean", -278886877, null), new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "nil-val", "nil-val", -513933559, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.TransientHashMap.cljs$lang$type = true;
cljs.core.TransientHashMap.cljs$lang$ctorStr = "cljs.core/TransientHashMap";
cljs.core.TransientHashMap.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/TransientHashMap");
};
cljs.core.__GT_TransientHashMap = function cljs$core$__GT_TransientHashMap(edit, root, count, has_nil_QMARK_, nil_val) {
  return new cljs.core.TransientHashMap(edit, root, count, has_nil_QMARK_, nil_val);
};
cljs.core.tree_map_seq_push = function cljs$core$tree_map_seq_push(node, stack, ascending_QMARK_) {
  var t = node;
  var stack__$1 = stack;
  while (true) {
    if (!(t == null)) {
      var G__48073 = ascending_QMARK_ ? t.left : t.right;
      var G__48074 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack__$1, t);
      t = G__48073;
      stack__$1 = G__48074;
      continue;
    } else {
      return stack__$1;
    }
    break;
  }
};
cljs.core.PersistentTreeMapSeq = function(meta, stack, ascending_QMARK_, cnt, __hash) {
  this.meta = meta;
  this.stack = stack;
  this.ascending_QMARK_ = ascending_QMARK_;
  this.cnt = cnt;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32374862;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.PersistentTreeMapSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentTreeMapSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentTreeMapSeq.prototype.indexOf = function() {
  var G__48075 = null;
  var G__48075__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__48075__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__48075 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__48075__1.call(this, x);
      case 2:
        return G__48075__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__48075.cljs$core$IFn$_invoke$arity$1 = G__48075__1;
  G__48075.cljs$core$IFn$_invoke$arity$2 = G__48075__2;
  return G__48075;
}();
cljs.core.PersistentTreeMapSeq.prototype.lastIndexOf = function() {
  var G__48076 = null;
  var G__48076__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__48076__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__48076 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__48076__1.call(this, x);
      case 2:
        return G__48076__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__48076.cljs$core$IFn$_invoke$arity$1 = G__48076__1;
  G__48076.cljs$core$IFn$_invoke$arity$2 = G__48076__2;
  return G__48076;
}();
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt < 0) {
    return cljs.core.count(cljs.core.next(coll__$1)) + 1;
  } else {
    return self__.cnt;
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__9596__auto__ = self__.__hash;
  if (!(h__9596__auto__ == null)) {
    return h__9596__auto__;
  } else {
    var h__9596__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__9596__auto____$1;
    return h__9596__auto____$1;
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.peek(self__.stack);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  var t = cljs.core.first(self__.stack);
  var next_stack = cljs.core.tree_map_seq_push(self__.ascending_QMARK_ ? t.right : t.left, cljs.core.next(self__.stack), self__.ascending_QMARK_);
  if (!(next_stack == null)) {
    return new cljs.core.PersistentTreeMapSeq(null, next_stack, self__.ascending_QMARK_, self__.cnt - 1, null);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1;
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentTreeMapSeq(meta__$1, self__.stack, self__.ascending_QMARK_, self__.cnt, self__.__hash);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.PersistentTreeMapSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "stack", "stack", 847125597, null), cljs.core.with_meta(new cljs.core.Symbol(null, "ascending?", "ascending?", -1938452653, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "tag", "tag", -1290361223), new cljs.core.Symbol(null, "boolean", "boolean", -278886877, null)], null)), new cljs.core.Symbol(null, 
  "cnt", "cnt", 1924510325, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.PersistentTreeMapSeq.cljs$lang$type = true;
cljs.core.PersistentTreeMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentTreeMapSeq";
cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrWriter = function(this__9811__auto__, writer__9812__auto__, opt__9813__auto__) {
  return cljs.core._write(writer__9812__auto__, "cljs.core/PersistentTreeMapSeq");
};
cljs.core.__GT_PersistentTreeMapSeq = function cljs$core$__GT_PersistentTreeMapSeq(meta, stack, ascending_QMARK_, cnt, __hash) {
  return new cljs.core.PersistentTreeMapSeq(meta, stack, ascending_QMARK_, cnt, __hash);
};
cljs.core.PersistentTreeMapSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__10266__auto__ = this;
  return cljs.core.es6_iterator(this__10266__auto__);
};
cljs.core.create_tree_map_seq = function cljs$core$create_tree_map_seq(tree, ascending_QMARK_, cnt) {
  return new cljs.core.PersistentTreeMapSeq(null, cljs.core.tree_map_seq_push(tree, null, ascending_QMARK_), ascending_QMARK_, cnt, null);
};
cljs.core.balance_left = function cljs$core$balance_left(key, val, ins, right) {
  if (ins instanceof cljs.core.RedNode) {
    if (ins.left instanceof cljs.core.RedNode) {
      return new cljs.core.RedNode(ins.key, ins.val, ins.left.blacken(), new cljs.core.BlackNode(key, val, ins.right, right, null), null);
    } else {
      if (ins.right instanceof cljs.core.RedNode) {
        return new cljs.core.RedNode(ins.right.key, ins.right.val, new cljs.core.BlackNode(ins.key, ins.val, ins.left, ins.right.left, null), new cljs.core.BlackNode(key, val, ins.right.right, right, null), null);
      } else {
        return new cljs.core.BlackNode(key, val, ins, right, null);
      }
    }
  } else {
    return new cljs.core.BlackNode(key, val, ins, right, null);
  }
};
cljs.core.balance_right = function cljs$core$balance_right(key, val, left, ins) {
  if (ins instanceof cljs.core.RedNode) {
    if (ins.right instanceof cljs.core.RedNode) {
      return new cljs.core.RedNode(ins.key, ins.val, new cljs.core.BlackNode(key, val, left, ins.left, null), ins.right.blacken(), null);
    } else {
      if (ins.left instanceof cljs.core.RedNode) {
        return new cljs.core.RedNode(ins.left.key, ins.left.val, new cljs.core.BlackNode(key, val, left, ins.left.left, null), new cljs.core.BlackNode(ins.key, ins.val, ins.left.right, ins.right, null), null);
      } else {
        return new cljs.core.BlackNode(key, val, left, ins, null);
      }
    }
  } else {
    return new cljs.core.BlackNode(key, val, left, ins, null);
  }
};
cljs.core.balance_left_del = function cljs$core$balance_left_del(key, val, del, right) {
  if (del instanceof cljs.core.RedNode) {
    return new cljs.core.RedNode(key, val, del.blacken(), right, null);
  } else {
    if (right instanceof cljs.core.BlackNode) {
      return cljs.core.balance_right(key, val, del, right.redden());
    } else {
      if (right instanceof cljs.core.RedNode && right.left instanceof cljs.core.BlackNode) {
        return new cljs.core.RedNode(right.left.key, right.left.val, new cljs.core.BlackNode(key, val, del, right.left.left, null), cljs.core.balance_right(right.key, right.val, right.left.right, right.right.redden()), null);
      } else {
        throw new Error("red-black tree invariant violation");
      }
    }
  }
};
cljs.core.balance_right_del = function cljs$core$balance_right_del(key, val, left, del) {
  if (del instanceof cljs.core.RedNode) {
    return new cljs.core.RedNode(key, val, left, del.blacken(), null);
  } else {
    if (left instanceof cljs.core.BlackNode) {
      return cljs.core.balance_left(key, val, left.redden(), del);
    } else {
      if (left instanceof cljs.core.RedNode && left.right instanceof cljs.core.BlackNode) {
        return new cljs.core.RedNode(left.right.key, left.right.val, cljs.core.balance_left(left.key, left.val, left.left.redden(), left.right.left), new cljs.core.BlackNode(key, val, left.right.right, del, null), null);
      } else {
        throw new Error("red-black tree invariant violation");
      }
    }
  }
};
cljs.core.tree_map_kv_reduce = function cljs$core$tree_map_kv_reduce(node, f, init) {
  var init__$1 = !(node.left == null) ? function() {
    var G__48086 = node.left;
    var G__48087 = f;
    var G__48088 = init;
    return cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3(G__48086, G__48087, G__48088) : cljs.core.tree_map_kv_reduce.call(null, G__48086, G__48087, G__48088);
  }() : init;
  if (cljs.core.reduced_QMARK_(init__$1)) {
    return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$1) : cljs.core.deref.call(null, init__$1);
  } else {
    var init__$2 = function() {
      var G__48089 = init__$1;
      var G__48090 = node.key;
      var G__48091 = node.val;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__48089, G__48090, G__48091) : f.call(null, G__48089, G__48090, G__48091);
    }();
    if (cljs.core.reduced_QMARK_(init__$2)) {
      return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null, init__$2);
    } else {
      var init__$3 = !(node.right == null) ? function() {
        var G__48092 = node.right;
        var G__48093 = f;
        var G__48094 = init__$2;
        return cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3(G__48092, G__48093, G__48094) : cljs.core.tree_map_kv_reduce.call(null, G__48092, G__48093, G__48094);
      }() : init__$2;
      if (cljs.core.reduced_QMARK_(init__$3)) {
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$3) : cljs.core.deref.call(null, init__$3);
      } else {
        return init__$3;
      }
    }
  }
};
cljs.core.BlackNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32402207;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.BlackNode.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.BlackNode.prototype.cljs$core$IFind$_find$arity$2 = function(node, k) {
  var self__ = this;
  var node__$1 = this;
  if (k === 0) {
    return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [0, self__.key], null);
  } else {
    if (k === 1) {
      return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [1, self__.val], null);
    } else {
      return null;
    }
  }
};
cljs.core.BlackNode.prototype.lastIndexOf = function() {
  var G__48096 = null;
  var G__48096__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__48096__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__48096 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__48096__1.call(this, x);
      case 2:
        return G__48096__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__48096.cljs$core$IFn$_invoke$arity$1 = G__48096__1;
  G__48096.cljs$core$IFn$_invoke$arity$2 = G__48096__2;
  return G__48096;
}();
cljs.core.BlackNode.prototype.indexOf = function() {
  var G__48097 = null;
  var G__48097__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__48097__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__48097 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__48097__1.call(this, x);
      case 2:
        return G__48097__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__48097.cljs$core$IFn$_invoke$arity$1 = G__48097__1;
  G__48097.cljs$core$IFn$_invoke$arity$2 = G__48097__2;
  return G__48097;
}();
cljs.core.BlackNode.prototype.add_right = function(ins) {
  var self__ = this;
  var node = this;
  return ins.balance_right(node);
};
cljs.core.BlackNode.prototype.redden = function() {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(self__.key, self__.val, self__.left, self__.right, null);
};
cljs.core.BlackNode.prototype.blacken = function() {
  var self__ = this;
  var node = this;
  return node;
};
cljs.core.BlackNode.prototype.add_left = function(ins) {
  var self__ = this;
  var node = this;
  return ins.balance_left(node);
};
cljs.core.BlackNode.prototype.replace = function(key__$1, val__$1, left__$1, right__$1) {
  var self__ = this;
  var node = this;
  return new cljs.core.BlackNode(key__$1, val__$1, left__$1, right__$1, null);
};
cljs.core.BlackNode.prototype.balance_left = function(parent) {
  var self__ = this;
  var node = this;
  return new cljs.core.BlackNode(parent.key, parent.val, node, parent.right, null);
};
cljs.core.BlackNode.prototype.balance_right = function(parent) {
  var self__ = this;
  var node = this;
  return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node, null);
};
cljs.core.BlackNode.prototype.remove_left = function(del) {
  var self__ = this;
  var node = this;
  return cljs.core.balance_left_del(self__.key, self__.val, del, self__.right);
};
cljs.core.BlackNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var node = this;
  return cljs.core.tree_map_kv_reduce(node, f, init);
};
cljs.core.BlackNode.prototype.remove_right = function(del) {
  var self__ = this;
  var node = this;
  return cljs.core.balance_right_del(self__.key, self__.val, self__.left, del);
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var self__ = this;
  var node__$1 = this;
  return node__$1.cljs$core$IIndexed$_nth$arity$3(null, k, null);
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var self__ = this;
  var node__$1 = this;
  return node__$1.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var self__ = this;
  var node__$1 = this;
  if (n === 0) {
    return self__.key;
  } else {
    if (n === 1) {
      return self__.val;
    } else {
      throw new Error("Index out of bounds");
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var self__ = this;
  var node__$1 = this;
  if (n === 0) {
    return self__.key;
  } else {
    if (n === 1) {
      return self__.val;
    } else {
      return not_found;
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var self__ = this;
  var node__$1 = this;
  return (new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null)).cljs$core$IVector$_assoc_n$arity$3(null, n, v);
};
cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return null;
};
cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return 2;
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.key;
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.val;
};
cljs.cor