// Compiled by ClojureScript 1.9.542 {}
goog.provide('superv.async');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
/**
 * Take the &env from a macro, and tell whether we are expanding into cljs.
 */
superv.async.cljs_env_QMARK_ = (function superv$async$cljs_env_QMARK_(env){
return cljs.core.boolean$.call(null,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(env));
});

/**
 * @interface
 */
superv.async.PSupervisor = function(){};

superv.async._error = (function superv$async$_error(this$){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_error$arity$1 == null)))){
return this$.superv$async$PSupervisor$_error$arity$1(this$);
} else {
var x__9872__auto__ = (((this$ == null))?null:this$);
var m__9873__auto__ = (superv.async._error[goog.typeOf(x__9872__auto__)]);
if(!((m__9873__auto__ == null))){
return m__9873__auto__.call(null,this$);
} else {
var m__9873__auto____$1 = (superv.async._error["_"]);
if(!((m__9873__auto____$1 == null))){
return m__9873__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-error",this$);
}
}
}
});

superv.async._abort = (function superv$async$_abort(this$){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_abort$arity$1 == null)))){
return this$.superv$async$PSupervisor$_abort$arity$1(this$);
} else {
var x__9872__auto__ = (((this$ == null))?null:this$);
var m__9873__auto__ = (superv.async._abort[goog.typeOf(x__9872__auto__)]);
if(!((m__9873__auto__ == null))){
return m__9873__auto__.call(null,this$);
} else {
var m__9873__auto____$1 = (superv.async._abort["_"]);
if(!((m__9873__auto____$1 == null))){
return m__9873__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-abort",this$);
}
}
}
});

superv.async._register_go = (function superv$async$_register_go(this$,body){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_register_go$arity$2 == null)))){
return this$.superv$async$PSupervisor$_register_go$arity$2(this$,body);
} else {
var x__9872__auto__ = (((this$ == null))?null:this$);
var m__9873__auto__ = (superv.async._register_go[goog.typeOf(x__9872__auto__)]);
if(!((m__9873__auto__ == null))){
return m__9873__auto__.call(null,this$,body);
} else {
var m__9873__auto____$1 = (superv.async._register_go["_"]);
if(!((m__9873__auto____$1 == null))){
return m__9873__auto____$1.call(null,this$,body);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-register-go",this$);
}
}
}
});

superv.async._unregister_go = (function superv$async$_unregister_go(this$,id){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_unregister_go$arity$2 == null)))){
return this$.superv$async$PSupervisor$_unregister_go$arity$2(this$,id);
} else {
var x__9872__auto__ = (((this$ == null))?null:this$);
var m__9873__auto__ = (superv.async._unregister_go[goog.typeOf(x__9872__auto__)]);
if(!((m__9873__auto__ == null))){
return m__9873__auto__.call(null,this$,id);
} else {
var m__9873__auto____$1 = (superv.async._unregister_go["_"]);
if(!((m__9873__auto____$1 == null))){
return m__9873__auto____$1.call(null,this$,id);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-unregister-go",this$);
}
}
}
});

superv.async._track_exception = (function superv$async$_track_exception(this$,e){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_track_exception$arity$2 == null)))){
return this$.superv$async$PSupervisor$_track_exception$arity$2(this$,e);
} else {
var x__9872__auto__ = (((this$ == null))?null:this$);
var m__9873__auto__ = (superv.async._track_exception[goog.typeOf(x__9872__auto__)]);
if(!((m__9873__auto__ == null))){
return m__9873__auto__.call(null,this$,e);
} else {
var m__9873__auto____$1 = (superv.async._track_exception["_"]);
if(!((m__9873__auto____$1 == null))){
return m__9873__auto____$1.call(null,this$,e);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-track-exception",this$);
}
}
}
});

superv.async._free_exception = (function superv$async$_free_exception(this$,e){
if((!((this$ == null))) && (!((this$.superv$async$PSupervisor$_free_exception$arity$2 == null)))){
return this$.superv$async$PSupervisor$_free_exception$arity$2(this$,e);
} else {
var x__9872__auto__ = (((this$ == null))?null:this$);
var m__9873__auto__ = (superv.async._free_exception[goog.typeOf(x__9872__auto__)]);
if(!((m__9873__auto__ == null))){
return m__9873__auto__.call(null,this$,e);
} else {
var m__9873__auto____$1 = (superv.async._free_exception["_"]);
if(!((m__9873__auto____$1 == null))){
return m__9873__auto____$1.call(null,this$,e);
} else {
throw cljs.core.missing_protocol.call(null,"PSupervisor.-free-exception",this$);
}
}
}
});

superv.async.now = (function superv$async$now(){
return (new Date());
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {superv.async.PSupervisor}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
superv.async.TrackingSupervisor = (function (error,abort,registered,pending_exceptions,__meta,__extmap,__hash){
this.error = error;
this.abort = abort;
this.registered = registered;
this.pending_exceptions = pending_exceptions;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
superv.async.TrackingSupervisor.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__9829__auto__,k__9830__auto__){
var self__ = this;
var this__9829__auto____$1 = this;
return this__9829__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__9830__auto__,null);
});

superv.async.TrackingSupervisor.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__9831__auto__,k52101,else__9832__auto__){
var self__ = this;
var this__9831__auto____$1 = this;
var G__52103 = k52101;
var G__52103__$1 = (((G__52103 instanceof cljs.core.Keyword))?G__52103.fqn:null);
switch (G__52103__$1) {
case "error":
return self__.error;

break;
case "abort":
return self__.abort;

break;
case "registered":
return self__.registered;

break;
case "pending-exceptions":
return self__.pending_exceptions;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k52101,else__9832__auto__);

}
});

superv.async.TrackingSupervisor.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__9843__auto__,writer__9844__auto__,opts__9845__auto__){
var self__ = this;
var this__9843__auto____$1 = this;
var pr_pair__9846__auto__ = ((function (this__9843__auto____$1){
return (function (keyval__9847__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__9844__auto__,cljs.core.pr_writer,""," ","",opts__9845__auto__,keyval__9847__auto__);
});})(this__9843__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__9844__auto__,pr_pair__9846__auto__,"#superv.async.TrackingSupervisor{",", ","}",opts__9845__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error","error",-978969032),self__.error],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abort","abort",521193198),self__.abort],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"registered","registered",-388600037),self__.registered],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),self__.pending_exceptions],null))], null),self__.__extmap));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

superv.async.TrackingSupervisor.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__52100){
var self__ = this;
var G__52100__$1 = this;
return (new cljs.core.RecordIter((0),G__52100__$1,4,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__9827__auto__){
var self__ = this;
var this__9827__auto____$1 = this;
return self__.__meta;
});

superv.async.TrackingSupervisor.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__9823__auto__){
var self__ = this;
var this__9823__auto____$1 = this;
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,self__.__hash));
});

superv.async.TrackingSupervisor.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__9833__auto__){
var self__ = this;
var this__9833__auto____$1 = this;
return (4 + cljs.core.count.call(null,self__.__extmap));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__9824__auto__){
var self__ = this;
var this__9824__auto____$1 = this;
var h__9596__auto__ = self__.__hash;
if(!((h__9596__auto__ == null))){
return h__9596__auto__;
} else {
var h__9596__auto____$1 = cljs.core.hash_imap.call(null,this__9824__auto____$1);
self__.__hash = h__9596__auto____$1;

return h__9596__auto____$1;
}
});

superv.async.TrackingSupervisor.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__9825__auto__,other__9826__auto__){
var self__ = this;
var this__9825__auto____$1 = this;
if(cljs.core.truth_((function (){var and__9142__auto__ = other__9826__auto__;
if(cljs.core.truth_(and__9142__auto__)){
return ((this__9825__auto____$1.constructor === other__9826__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__9825__auto____$1,other__9826__auto__));
} else {
return and__9142__auto__;
}
})())){
return true;
} else {
return false;
}
});

superv.async.TrackingSupervisor.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__9838__auto__,k__9839__auto__){
var self__ = this;
var this__9838__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),null,new cljs.core.Keyword(null,"abort","abort",521193198),null,new cljs.core.Keyword(null,"error","error",-978969032),null,new cljs.core.Keyword(null,"registered","registered",-388600037),null], null), null),k__9839__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__9838__auto____$1),self__.__meta),k__9839__auto__);
} else {
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__9839__auto__)),null));
}
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$ = cljs.core.PROTOCOL_SENTINEL;

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_error$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.error;
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_abort$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.abort;
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_register_go$arity$2 = (function (this$,body){
var self__ = this;
var this$__$1 = this;
var id = cljs.core.random_uuid.call(null);
cljs.core.swap_BANG_.call(null,self__.registered,cljs.core.assoc,id,body);

return id;
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_unregister_go$arity$2 = (function (this$,id){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.registered,cljs.core.dissoc,id);
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_track_exception$arity$2 = (function (this$,e){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.pending_exceptions,cljs.core.assoc,e,superv.async.now.call(null));
});

superv.async.TrackingSupervisor.prototype.superv$async$PSupervisor$_free_exception$arity$2 = (function (this$,e){
var self__ = this;
var this$__$1 = this;
return cljs.core.swap_BANG_.call(null,self__.pending_exceptions,cljs.core.dissoc,e);
});

superv.async.TrackingSupervisor.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__9836__auto__,k__9837__auto__,G__52100){
var self__ = this;
var this__9836__auto____$1 = this;
var pred__52104 = cljs.core.keyword_identical_QMARK_;
var expr__52105 = k__9837__auto__;
if(cljs.core.truth_(pred__52104.call(null,new cljs.core.Keyword(null,"error","error",-978969032),expr__52105))){
return (new superv.async.TrackingSupervisor(G__52100,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__52104.call(null,new cljs.core.Keyword(null,"abort","abort",521193198),expr__52105))){
return (new superv.async.TrackingSupervisor(self__.error,G__52100,self__.registered,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__52104.call(null,new cljs.core.Keyword(null,"registered","registered",-388600037),expr__52105))){
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,G__52100,self__.pending_exceptions,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__52104.call(null,new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),expr__52105))){
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,G__52100,self__.__meta,self__.__extmap,null));
} else {
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__9837__auto__,G__52100),null));
}
}
}
}
});

superv.async.TrackingSupervisor.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__9841__auto__){
var self__ = this;
var this__9841__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error","error",-978969032),self__.error],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abort","abort",521193198),self__.abort],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"registered","registered",-388600037),self__.registered],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),self__.pending_exceptions],null))], null),self__.__extmap));
});

superv.async.TrackingSupervisor.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__9828__auto__,G__52100){
var self__ = this;
var this__9828__auto____$1 = this;
return (new superv.async.TrackingSupervisor(self__.error,self__.abort,self__.registered,self__.pending_exceptions,G__52100,self__.__extmap,self__.__hash));
});

superv.async.TrackingSupervisor.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__9834__auto__,entry__9835__auto__){
var self__ = this;
var this__9834__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__9835__auto__)){
return this__9834__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__9835__auto__,(0)),cljs.core._nth.call(null,entry__9835__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__9834__auto____$1,entry__9835__auto__);
}
});

superv.async.TrackingSupervisor.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"error","error",661562495,null),new cljs.core.Symbol(null,"abort","abort",-2133242571,null),new cljs.core.Symbol(null,"registered","registered",1251931490,null),new cljs.core.Symbol(null,"pending-exceptions","pending-exceptions",-247748567,null)], null);
});

superv.async.TrackingSupervisor.cljs$lang$type = true;

superv.async.TrackingSupervisor.cljs$lang$ctorPrSeq = (function (this__9865__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"superv.async/TrackingSupervisor");
});

superv.async.TrackingSupervisor.cljs$lang$ctorPrWriter = (function (this__9865__auto__,writer__9866__auto__){
return cljs.core._write.call(null,writer__9866__auto__,"superv.async/TrackingSupervisor");
});

superv.async.__GT_TrackingSupervisor = (function superv$async$__GT_TrackingSupervisor(error,abort,registered,pending_exceptions){
return (new superv.async.TrackingSupervisor(error,abort,registered,pending_exceptions,null,null,null));
});

superv.async.map__GT_TrackingSupervisor = (function superv$async$map__GT_TrackingSupervisor(G__52102){
return (new superv.async.TrackingSupervisor(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(G__52102),new cljs.core.Keyword(null,"abort","abort",521193198).cljs$core$IFn$_invoke$arity$1(G__52102),new cljs.core.Keyword(null,"registered","registered",-388600037).cljs$core$IFn$_invoke$arity$1(G__52102),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(G__52102),null,cljs.core.dissoc.call(null,G__52102,new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094)),null));
});

cljs.core.enable_console_print_BANG_.call(null);
/**
 * A simple supervisor which deals with errors through callbacks. You need to
 *   close its abort channel manually if you want the context to stop. It is
 *   supposed to be used at a boundary to an unsupervised system. If you want
 *   strong supervision, use the restarting-supervisor instead.
 */
superv.async.simple_supervisor = (function superv$async$simple_supervisor(var_args){
var args__10382__auto__ = [];
var len__10375__auto___52132 = arguments.length;
var i__10376__auto___52133 = (0);
while(true){
if((i__10376__auto___52133 < len__10375__auto___52132)){
args__10382__auto__.push((arguments[i__10376__auto___52133]));

var G__52134 = (i__10376__auto___52133 + (1));
i__10376__auto___52133 = G__52134;
continue;
} else {
}
break;
}

var argseq__10383__auto__ = ((((0) < args__10382__auto__.length))?(new cljs.core.IndexedSeq(args__10382__auto__.slice((0)),(0),null)):null);
return superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic(argseq__10383__auto__);
});

superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic = (function (p__52109){
var map__52110 = p__52109;
var map__52110__$1 = ((((!((map__52110 == null)))?((((map__52110.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52110.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__52110):map__52110);
var stale_timeout = cljs.core.get.call(null,map__52110__$1,new cljs.core.Keyword(null,"stale-timeout","stale-timeout",-468804294),((10) * (1000)));
var error_fn = cljs.core.get.call(null,map__52110__$1,new cljs.core.Keyword(null,"error-fn","error-fn",-171437615),((function (map__52110,map__52110__$1,stale_timeout){
return (function (e){
return cljs.core.println.call(null,"Supervisor:",e,e.stack);
});})(map__52110,map__52110__$1,stale_timeout))
);
var pending_fn = cljs.core.get.call(null,map__52110__$1,new cljs.core.Keyword(null,"pending-fn","pending-fn",1734381755));
var s = superv.async.map__GT_TrackingSupervisor.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.async.chan.call(null),new cljs.core.Keyword(null,"abort","abort",521193198),cljs.core.async.chan.call(null),new cljs.core.Keyword(null,"registered","registered",-388600037),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)], null));
var err_ch = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(s);
cljs.core.async.take_BANG_.call(null,err_ch,((function (s,err_ch,map__52110,map__52110__$1,stale_timeout,error_fn,pending_fn){
return (function superv$async$loop_fn(e){
error_fn.call(null,e);

return cljs.core.async.take_BANG_.call(null,err_ch,superv$async$loop_fn);
});})(s,err_ch,map__52110,map__52110__$1,stale_timeout,error_fn,pending_fn))
);

((function (s,err_ch,map__52110,map__52110__$1,stale_timeout,error_fn,pending_fn){
return (function superv$async$pending(_){
var vec__52122 = cljs.core.filter.call(null,((function (s,err_ch,map__52110,map__52110__$1,stale_timeout,error_fn,pending_fn){
return (function (p__52128){
var vec__52129 = p__52128;
var k = cljs.core.nth.call(null,vec__52129,(0),null);
var v = cljs.core.nth.call(null,vec__52129,(1),null);
return ((superv.async.now.call(null).getTime() - stale_timeout) > v.getTime());
});})(s,err_ch,map__52110,map__52110__$1,stale_timeout,error_fn,pending_fn))
,cljs.core.deref.call(null,new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s)));
var vec__52125 = cljs.core.nth.call(null,vec__52122,(0),null);
var e = cljs.core.nth.call(null,vec__52125,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__52125,(1),null);
if(cljs.core.truth_(e)){
error_fn.call(null,e);

superv.async._free_exception.call(null,s,e);
} else {
}

return cljs.core.async.take_BANG_.call(null,cljs.core.async.timeout.call(null,stale_timeout),superv$async$pending);
});})(s,err_ch,map__52110,map__52110__$1,stale_timeout,error_fn,pending_fn))
.call(null,null);

return s;
});

superv.async.simple_supervisor.cljs$lang$maxFixedArity = (0);

superv.async.simple_supervisor.cljs$lang$applyTo = (function (seq52108){
return superv.async.simple_supervisor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq52108));
});

superv.async.S = superv.async.simple_supervisor.call(null);
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
superv.async.throw_if_exception = (function superv$async$throw_if_exception(S,x){
if((x instanceof Error)){
superv.async._free_exception.call(null,S,x);

throw cljs.core.ex_info.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),(function (){var or__9154__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__9154__auto__)){
return or__9154__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
superv.async.superv_init = (function superv$async$superv_init(){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [superv.async._error,superv.async._abort,superv.async._register_go,superv.async._unregister_go,superv.async._track_exception,superv.async._free_exception,superv.async.throw_if_exception], null);
});
goog.exportSymbol('superv.async.superv_init', superv.async.superv_init);
superv.async.superv_init.call(null);
superv.async.supervisor_QMARK_ = (function superv$async$supervisor_QMARK_(x){
if(!((x == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === x.superv$async$PSupervisor$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,superv.async.PSupervisor,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,superv.async.PSupervisor,x);
}
});
superv.async.check_supervisor = (function superv$async$check_supervisor(x){
if(cljs.core.truth_(superv.async.supervisor_QMARK_.call(null,x))){
return null;
} else {
throw cljs.core.ex_info.call(null,"First argument is not a supervisor.",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"argument","argument",1183001841),x], null));
}
});
/**
 * Here until http://dev.clojure.org/jira/browse/ASYNC-74 is resolved.
 */
superv.async.chan_QMARK_ = (function superv$async$chan_QMARK_(x){
if(!((x == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$ReadPort$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.ReadPort,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.ReadPort,x);
}
});
/**
 * Same as core.async/take!, but tracks exceptions in supervisor. TODO
 * deal with abortion.
 */
superv.async.take_QMARK_ = (function superv$async$take_QMARK_(var_args){
var args52152 = [];
var len__10375__auto___52155 = arguments.length;
var i__10376__auto___52156 = (0);
while(true){
if((i__10376__auto___52156 < len__10375__auto___52155)){
args52152.push((arguments[i__10376__auto___52156]));

var G__52157 = (i__10376__auto___52156 + (1));
i__10376__auto___52156 = G__52157;
continue;
} else {
}
break;
}

var G__52154 = args52152.length;
switch (G__52154) {
case 3:
return superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52152.length)].join('')));

}
});

superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (S,port,fn1){
return superv.async.take_QMARK_.call(null,S,port,fn1,true);
});

superv.async.take_QMARK_.cljs$core$IFn$_invoke$arity$4 = (function (S,port,fn1,on_caller_QMARK_){
return cljs.core.async.take_BANG_.call(null,port,(function (v){
if((v instanceof Error)){
superv.async._free_exception.call(null,S,v);
} else {
}

return fn1.call(null,v);
}),on_caller_QMARK_);
});

superv.async.take_QMARK_.cljs$lang$maxFixedArity = 4;

/**
 * Same as core.async/put!, but tracks exceptions in supervisor. TODO
 * deal with abortion.
 */
superv.async.put_QMARK_ = (function superv$async$put_QMARK_(var_args){
var args52159 = [];
var len__10375__auto___52162 = arguments.length;
var i__10376__auto___52163 = (0);
while(true){
if((i__10376__auto___52163 < len__10375__auto___52162)){
args52159.push((arguments[i__10376__auto___52163]));

var G__52164 = (i__10376__auto___52163 + (1));
i__10376__auto___52163 = G__52164;
continue;
} else {
}
break;
}

var G__52161 = args52159.length;
switch (G__52161) {
case 3:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52159.length)].join('')));

}
});

superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (S,port,val){
return superv.async.put_QMARK_.call(null,S,port,val,(function superv$async$noop(_){
return null;
}));
});

superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$4 = (function (S,port,val,fn1){
return superv.async.put_QMARK_.call(null,S,port,val,fn1,true);
});

superv.async.put_QMARK_.cljs$core$IFn$_invoke$arity$5 = (function (S,port,val,fn1,on_caller_QMARK_){
return cljs.core.async.put_BANG_.call(null,port,val,(function (ret){
if(((val instanceof Error)) && (!(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data.call(null,val)),new cljs.core.Keyword(null,"aborted","aborted",1775972619))))){
superv.async._track_exception.call(null,S,val);
} else {
}

return fn1.call(null,ret);
}),on_caller_QMARK_);
});

superv.async.put_QMARK_.cljs$lang$maxFixedArity = 5;

/**
 * Takes objects from in-ch, asynchrously applies function f> (function should
 *   return a channel), takes the result from the returned channel and if it's
 *   truthy, puts it in the out-ch. Returns the closed out-ch. Closes the
 *   returned channel when the input channel has been completely consumed and all
 *   objects have been processed.
 *   If out-ch is not provided, an unbuffered one will be used.
 */
superv.async.pmap_GT__GT_ = (function superv$async$pmap_GT__GT_(var_args){
var args52177 = [];
var len__10375__auto___52380 = arguments.length;
var i__10376__auto___52381 = (0);
while(true){
if((i__10376__auto___52381 < len__10375__auto___52380)){
args52177.push((arguments[i__10376__auto___52381]));

var G__52382 = (i__10376__auto___52381 + (1));
i__10376__auto___52381 = G__52382;
continue;
} else {
}
break;
}

var G__52179 = args52177.length;
switch (G__52179) {
case 4:
return superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52177.length)].join('')));

}
});

superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$4 = (function (S,f_GT_,parallelism,in_ch){
return superv.async.pmap_GT__GT_.call(null,S,f_GT_,parallelism,cljs.core.async.chan.call(null),in_ch);
});

superv.async.pmap_GT__GT_.cljs$core$IFn$_invoke$arity$5 = (function (S,f_GT_,parallelism,out_ch,in_ch){
if(cljs.core.fn_QMARK_.call(null,f_GT_)){
} else {
throw (new Error("Assert failed: (fn? f>)"));
}

if((cljs.core.integer_QMARK_.call(null,parallelism)) && ((parallelism > (0)))){
} else {
throw (new Error("Assert failed: (and (integer? parallelism) (pos? parallelism))"));
}

if((in_ch instanceof cljs.core.async.impl.protocols.ReadPort)){
} else {
throw (new Error("Assert failed: (instance? ReadPort in-ch)"));
}

var threads = cljs.core.atom.call(null,parallelism);
var n__10175__auto___52384 = parallelism;
var __52385 = (0);
while(true){
if((__52385 < n__10175__auto___52384)){
var c__21755__auto___52386 = superv.async.check_supervisor.call(null,superv.async.S);
var id__21756__auto___52387 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"loop","loop",1244978678,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol(null,"when-let","when-let",-1383043480,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"obj","obj",-1672671807,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"in-ch","in-ch",-1757981794,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,"when-let","when-let",-1383043480,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"result","result",-1239343558,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),cljs.core.list(new cljs.core.Symbol(null,"f>","f>",-1169871571,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)))], null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"result","result",-1239343558,null))),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null)))))),cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"zero?","zero?",325758897,null),cljs.core.list(new cljs.core.Symbol(null,"swap!","swap!",-655677516,null),new cljs.core.Symbol(null,"threads","threads",-77267207,null),new cljs.core.Symbol(null,"dec","dec",-766002333,null))),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null)))));
var c__33866__auto___52388 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__52385,c__33866__auto___52388,c__21755__auto___52386,id__21756__auto___52387,n__10175__auto___52384,threads){
return (function (){
var f__33867__auto__ = (function (){var switch__33843__auto__ = ((function (__52385,c__33866__auto___52388,c__21755__auto___52386,id__21756__auto___52387,n__10175__auto___52384,threads){
return (function (state_52314){
var state_val_52315 = (state_52314[(1)]);
if((state_val_52315 === (7))){
var inst_52183 = (state_52314[(7)]);
var inst_52191 = (state_52314[(2)]);
var state_52314__$1 = (function (){var statearr_52316 = state_52314;
(statearr_52316[(8)] = inst_52191);

return statearr_52316;
})();
var statearr_52317_52389 = state_52314__$1;
(statearr_52317_52389[(2)] = inst_52183);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_52314__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52315 === (20))){
var inst_52298 = (state_52314[(2)]);
var state_52314__$1 = state_52314;
var statearr_52318_52390 = state_52314__$1;
(statearr_52318_52390[(2)] = inst_52298);

(statearr_52318_52390[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52315 === (27))){
var inst_52260 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_52261 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_52262 = cljs.core.PersistentHashMap.fromArrays(inst_52260,inst_52261);
var inst_52263 = cljs.core.ex_info.call(null,"Aborted operations",inst_52262);
var state_52314__$1 = state_52314;
var statearr_52319_52391 = state_52314__$1;
(statearr_52319_52391[(2)] = inst_52263);

(statearr_52319_52391[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52315 === (1))){
var state_52314__$1 = state_52314;
var statearr_52320_52392 = state_52314__$1;
(statearr_52320_52392[(2)] = null);

(statearr_52320_52392[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52315 === (24))){
var inst_52242 = (state_52314[(2)]);
var inst_52243 = superv.async.throw_if_exception.call(null,S,inst_52242);
var inst_52244 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_52314__$1 = (function (){var statearr_52321 = state_52314;
(statearr_52321[(9)] = inst_52243);

return statearr_52321;
})();
var statearr_52322_52393 = state_52314__$1;
(statearr_52322_52393[(2)] = inst_52244);

(statearr_52322_52393[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52315 === (39))){
var state_52314__$1 = state_52314;
var statearr_52323_52394 = state_52314__$1;
(statearr_52323_52394[(2)] = null);

(statearr_52323_52394[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52315 === (4))){
var inst_52183 = (state_52314[(7)]);
var inst_52183__$1 = (state_52314[(2)]);
var inst_52184 = cljs.core.ex_data.call(null,inst_52183__$1);
var inst_52185 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_52184);
var inst_52186 = cljs.core._EQ_.call(null,inst_52185,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_52314__$1 = (function (){var statearr_52324 = state_52314;
(statearr_52324[(7)] = inst_52183__$1);

return statearr_52324;
})();
if(inst_52186){
var statearr_52325_52395 = state_52314__$1;
(statearr_52325_52395[(1)] = (5));

} else {
var statearr_52326_52396 = state_52314__$1;
(statearr_52326_52396[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52315 === (15))){
var inst_52216 = (state_52314[(10)]);
var inst_52218 = (inst_52216 instanceof Error);
var state_52314__$1 = state_52314;
if(cljs.core.truth_(inst_52218)){
var statearr_52327_52397 = state_52314__$1;
(statearr_52327_52397[(1)] = (18));

} else {
var statearr_52328_52398 = state_52314__$1;
(statearr_52328_52398[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52315 === (21))){
var inst_52223 = (state_52314[(11)]);
var inst_52229 = (state_52314[(2)]);
var inst_52230 = cljs.core.nth.call(null,inst_52229,(0),null);
var inst_52231 = cljs.core.nth.call(null,inst_52229,(1),null);
var inst_52232 = cljs.core._EQ_.call(null,inst_52231,inst_52223);
var state_52314__$1 = (function (){var statearr_52329 = state_52314;
(statearr_52329[(12)] = inst_52230);

return statearr_52329;
})();
if(inst_52232){
var statearr_52330_52399 = state_52314__$1;
(statearr_52330_52399[(1)] = (22));

} else {
var statearr_52331_52400 = state_52314__$1;
(statearr_52331_52400[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52315 === (31))){
var state_52314__$1 = state_52314;
var statearr_52332_52401 = state_52314__$1;
(statearr_52332_52401[(2)] = null);

(statearr_52332_52401[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52315 === (32))){
var inst_52295 = (state_52314[(2)]);
var state_52314__$1 = (function (){var statearr_52333 = state_52314;
(statearr_52333[(13)] = inst_52295);

return statearr_52333;
})();
var statearr_52334_52402 = state_52314__$1;
(statearr_52334_52402[(2)] = null);

(statearr_52334_52402[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52315 === (40))){
var inst_52310 = (state_52314[(2)]);
var state_52314__$1 = state_52314;
var statearr_52335_52403 = state_52314__$1;
(statearr_52335_52403[(2)] = inst_52310);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_52314__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52315 === (33))){
var inst_52272 = (state_52314[(14)]);
var inst_52278 = (state_52314[(2)]);
var inst_52279 = cljs.core.nth.call(null,inst_52278,(0),null);
var inst_52280 = cljs.core.nth.call(null,inst_52278,(1),null);
var inst_52281 = cljs.core._EQ_.call(null,inst_52280,inst_52272);
var state_52314__$1 = (function (){var statearr_52336 = state_52314;
(statearr_52336[(15)] = inst_52279);

return statearr_52336;
})();
if(inst_52281){
var statearr_52337_52404 = state_52314__$1;
(statearr_52337_52404[(1)] = (34));

} else {
var statearr_52338_52405 = state_52314__$1;
(statearr_52338_52405[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52315 === (13))){
var inst_52205 = (state_52314[(16)]);
var state_52314__$1 = state_52314;
var statearr_52339_52406 = state_52314__$1;
(statearr_52339_52406[(2)] = inst_52205);

(statearr_52339_52406[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52315 === (22))){
var inst_52234 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_52235 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_52236 = cljs.core.PersistentHashMap.fromArrays(inst_52234,inst_52235);
var inst_52237 = cljs.core.ex_info.call(null,"Aborted operations",inst_52236);
var state_52314__$1 = state_52314;
var statearr_52340_52407 = state_52314__$1;
(statearr_52340_52407[(2)] = inst_52237);

(statearr_52340_52407[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52315 === (36))){
var inst_52291 = (state_52314[(2)]);
var inst_52292 = superv.async.throw_if_exception.call(null,S,inst_52291);
var state_52314__$1 = state_52314;
var statearr_52341_52408 = state_52314__$1;
(statearr_52341_52408[(2)] = inst_52292);

(statearr_52341_52408[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52315 === (29))){
var inst_52267 = (state_52314[(17)]);
var inst_52266 = (state_52314[(2)]);
var inst_52267__$1 = superv.async.throw_if_exception.call(null,S,inst_52266);
var state_52314__$1 = (function (){var statearr_52342 = state_52314;
(statearr_52342[(17)] = inst_52267__$1);

return statearr_52342;
})();
if(cljs.core.truth_(inst_52267__$1)){
var statearr_52343_52409 = state_52314__$1;
(statearr_52343_52409[(1)] = (30));

} else {
var statearr_52344_52410 = state_52314__$1;
(statearr_52344_52410[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52315 === (6))){
var inst_52183 = (state_52314[(7)]);
var inst_52189 = superv.async._track_exception.call(null,S,inst_52183);
var state_52314__$1 = state_52314;
var statearr_52345_52411 = state_52314__$1;
(statearr_52345_52411[(2)] = inst_52189);

(statearr_52345_52411[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52315 === (28))){
var inst_52256 = (state_52314[(18)]);
var state_52314__$1 = state_52314;
var statearr_52346_52412 = state_52314__$1;
(statearr_52346_52412[(2)] = inst_52256);

(statearr_52346_52412[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52315 === (25))){
var inst_52240 = (state_52314[(2)]);
var state_52314__$1 = state_52314;
var statearr_52347_52413 = state_52314__$1;
(statearr_52347_52413[(2)] = inst_52240);

(statearr_52347_52413[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52315 === (34))){
var inst_52283 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_52284 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_52285 = cljs.core.PersistentHashMap.fromArrays(inst_52283,inst_52284);
var inst_52286 = cljs.core.ex_info.call(null,"Aborted operations",inst_52285);
var state_52314__$1 = state_52314;
var statearr_52348_52414 = state_52314__$1;
(statearr_52348_52414[(2)] = inst_52286);

(statearr_52348_52414[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52315 === (17))){
var inst_52301 = (state_52314[(2)]);
var state_52314__$1 = state_52314;
var statearr_52349_52415 = state_52314__$1;
(statearr_52349_52415[(2)] = inst_52301);

(statearr_52349_52415[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52315 === (3))){
var inst_52180 = (state_52314[(2)]);
var inst_52181 = superv.async._unregister_go.call(null,S,id__21756__auto___52387);
var state_52314__$1 = (function (){var statearr_52350 = state_52314;
(statearr_52350[(19)] = inst_52181);

(statearr_52350[(20)] = inst_52180);

return statearr_52350;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_52314__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52315 === (12))){
var inst_52209 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_52210 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_52211 = cljs.core.PersistentHashMap.fromArrays(inst_52209,inst_52210);
var inst_52212 = cljs.core.ex_info.call(null,"Aborted operations",inst_52211);
var state_52314__$1 = state_52314;
var statearr_52351_52416 = state_52314__$1;
(statearr_52351_52416[(2)] = inst_52212);

(statearr_52351_52416[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52315 === (2))){
var inst_52312 = (state_52314[(2)]);
var state_52314__$1 = state_52314;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_52314__$1,inst_52312);
} else {
if((state_val_52315 === (23))){
var inst_52216 = (state_52314[(10)]);
var state_52314__$1 = state_52314;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_52314__$1,(25),out_ch,inst_52216);
} else {
if((state_val_52315 === (35))){
var inst_52267 = (state_52314[(17)]);
var state_52314__$1 = state_52314;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_52314__$1,(37),out_ch,inst_52267);
} else {
if((state_val_52315 === (19))){
var inst_52216 = (state_52314[(10)]);
var inst_52249 = (state_52314[(21)]);
var inst_52249__$1 = superv.async._abort.call(null,S);
var inst_52250 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52251 = f_GT_.call(null,inst_52216);
var inst_52252 = [inst_52249__$1,inst_52251];
var inst_52253 = (new cljs.core.PersistentVector(null,2,(5),inst_52250,inst_52252,null));
var state_52314__$1 = (function (){var statearr_52352 = state_52314;
(statearr_52352[(21)] = inst_52249__$1);

return statearr_52352;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_52314__$1,(26),inst_52253,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_52315 === (11))){
var inst_52199 = (state_52314[(22)]);
var inst_52204 = (state_52314[(2)]);
var inst_52205 = cljs.core.nth.call(null,inst_52204,(0),null);
var inst_52206 = cljs.core.nth.call(null,inst_52204,(1),null);
var inst_52207 = cljs.core._EQ_.call(null,inst_52206,inst_52199);
var state_52314__$1 = (function (){var statearr_52353 = state_52314;
(statearr_52353[(16)] = inst_52205);

return statearr_52353;
})();
if(inst_52207){
var statearr_52354_52417 = state_52314__$1;
(statearr_52354_52417[(1)] = (12));

} else {
var statearr_52355_52418 = state_52314__$1;
(statearr_52355_52418[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52315 === (9))){
var inst_52199 = (state_52314[(22)]);
var inst_52199__$1 = superv.async._abort.call(null,S);
var inst_52200 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52201 = [inst_52199__$1,in_ch];
var inst_52202 = (new cljs.core.PersistentVector(null,2,(5),inst_52200,inst_52201,null));
var state_52314__$1 = (function (){var statearr_52356 = state_52314;
(statearr_52356[(22)] = inst_52199__$1);

return statearr_52356;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_52314__$1,(11),inst_52202,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_52315 === (5))){
var state_52314__$1 = state_52314;
var statearr_52357_52419 = state_52314__$1;
(statearr_52357_52419[(2)] = null);

(statearr_52357_52419[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52315 === (14))){
var inst_52216 = (state_52314[(10)]);
var inst_52215 = (state_52314[(2)]);
var inst_52216__$1 = superv.async.throw_if_exception.call(null,S,inst_52215);
var state_52314__$1 = (function (){var statearr_52358 = state_52314;
(statearr_52358[(10)] = inst_52216__$1);

return statearr_52358;
})();
if(cljs.core.truth_(inst_52216__$1)){
var statearr_52359_52420 = state_52314__$1;
(statearr_52359_52420[(1)] = (15));

} else {
var statearr_52360_52421 = state_52314__$1;
(statearr_52360_52421[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52315 === (26))){
var inst_52249 = (state_52314[(21)]);
var inst_52255 = (state_52314[(2)]);
var inst_52256 = cljs.core.nth.call(null,inst_52255,(0),null);
var inst_52257 = cljs.core.nth.call(null,inst_52255,(1),null);
var inst_52258 = cljs.core._EQ_.call(null,inst_52257,inst_52249);
var state_52314__$1 = (function (){var statearr_52361 = state_52314;
(statearr_52361[(18)] = inst_52256);

return statearr_52361;
})();
if(inst_52258){
var statearr_52362_52422 = state_52314__$1;
(statearr_52362_52422[(1)] = (27));

} else {
var statearr_52363_52423 = state_52314__$1;
(statearr_52363_52423[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52315 === (16))){
var state_52314__$1 = state_52314;
var statearr_52364_52424 = state_52314__$1;
(statearr_52364_52424[(2)] = null);

(statearr_52364_52424[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52315 === (38))){
var inst_52307 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_52314__$1 = state_52314;
var statearr_52365_52425 = state_52314__$1;
(statearr_52365_52425[(2)] = inst_52307);

(statearr_52365_52425[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52315 === (30))){
var inst_52272 = (state_52314[(14)]);
var inst_52272__$1 = superv.async._abort.call(null,S);
var inst_52273 = cljs.core.async.timeout.call(null,(0));
var inst_52274 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52275 = [inst_52272__$1,inst_52273];
var inst_52276 = (new cljs.core.PersistentVector(null,2,(5),inst_52274,inst_52275,null));
var state_52314__$1 = (function (){var statearr_52366 = state_52314;
(statearr_52366[(14)] = inst_52272__$1);

return statearr_52366;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_52314__$1,(33),inst_52276,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_52315 === (10))){
var inst_52303 = (state_52314[(2)]);
var inst_52304 = cljs.core.swap_BANG_.call(null,threads,cljs.core.dec);
var inst_52305 = (inst_52304 === (0));
var state_52314__$1 = (function (){var statearr_52367 = state_52314;
(statearr_52367[(23)] = inst_52303);

return statearr_52367;
})();
if(cljs.core.truth_(inst_52305)){
var statearr_52368_52426 = state_52314__$1;
(statearr_52368_52426[(1)] = (38));

} else {
var statearr_52369_52427 = state_52314__$1;
(statearr_52369_52427[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52315 === (18))){
var inst_52223 = (state_52314[(11)]);
var inst_52223__$1 = superv.async._abort.call(null,S);
var inst_52224 = cljs.core.async.timeout.call(null,(0));
var inst_52225 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52226 = [inst_52223__$1,inst_52224];
var inst_52227 = (new cljs.core.PersistentVector(null,2,(5),inst_52225,inst_52226,null));
var state_52314__$1 = (function (){var statearr_52370 = state_52314;
(statearr_52370[(11)] = inst_52223__$1);

return statearr_52370;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_52314__$1,(21),inst_52227,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_52315 === (37))){
var inst_52289 = (state_52314[(2)]);
var state_52314__$1 = state_52314;
var statearr_52371_52428 = state_52314__$1;
(statearr_52371_52428[(2)] = inst_52289);

(statearr_52371_52428[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52315 === (8))){
var ___$1 = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_52314,(4),Error,(3),(2));
var state_52314__$1 = state_52314;
var statearr_52372_52429 = state_52314__$1;
(statearr_52372_52429[(2)] = null);

(statearr_52372_52429[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(__52385,c__33866__auto___52388,c__21755__auto___52386,id__21756__auto___52387,n__10175__auto___52384,threads))
;
return ((function (__52385,switch__33843__auto__,c__33866__auto___52388,c__21755__auto___52386,id__21756__auto___52387,n__10175__auto___52384,threads){
return (function() {
var superv$async$state_machine__33844__auto__ = null;
var superv$async$state_machine__33844__auto____0 = (function (){
var statearr_52376 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_52376[(0)] = superv$async$state_machine__33844__auto__);

(statearr_52376[(1)] = (1));

return statearr_52376;
});
var superv$async$state_machine__33844__auto____1 = (function (state_52314){
while(true){
var ret_value__33845__auto__ = (function (){try{while(true){
var result__33846__auto__ = switch__33843__auto__.call(null,state_52314);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33846__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33846__auto__;
}
break;
}
}catch (e52377){if((e52377 instanceof Object)){
var ex__33847__auto__ = e52377;
var statearr_52378_52430 = state_52314;
(statearr_52378_52430[(5)] = ex__33847__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_52314);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e52377;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33845__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52431 = state_52314;
state_52314 = G__52431;
continue;
} else {
return ret_value__33845__auto__;
}
break;
}
});
superv$async$state_machine__33844__auto__ = function(state_52314){
switch(arguments.length){
case 0:
return superv$async$state_machine__33844__auto____0.call(this);
case 1:
return superv$async$state_machine__33844__auto____1.call(this,state_52314);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__33844__auto____0;
superv$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__33844__auto____1;
return superv$async$state_machine__33844__auto__;
})()
;})(__52385,switch__33843__auto__,c__33866__auto___52388,c__21755__auto___52386,id__21756__auto___52387,n__10175__auto___52384,threads))
})();
var state__33868__auto__ = (function (){var statearr_52379 = f__33867__auto__.call(null);
(statearr_52379[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33866__auto___52388);

return statearr_52379;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33868__auto__);
});})(__52385,c__33866__auto___52388,c__21755__auto___52386,id__21756__auto___52387,n__10175__auto___52384,threads))
);


var G__52432 = (__52385 + (1));
__52385 = G__52432;
continue;
} else {
}
break;
}

return out_ch;
});

superv.async.pmap_GT__GT_.cljs$lang$maxFixedArity = 5;

/**
 * Similiar to dorun. Simply takes messages from channels but does nothing with
 *   them. Returns channel that will close when all messages have been consumed.
 */
superv.async.engulf = (function superv$async$engulf(var_args){
var args__10382__auto__ = [];
var len__10375__auto___52513 = arguments.length;
var i__10376__auto___52514 = (0);
while(true){
if((i__10376__auto___52514 < len__10375__auto___52513)){
args__10382__auto__.push((arguments[i__10376__auto___52514]));

var G__52515 = (i__10376__auto___52514 + (1));
i__10376__auto___52514 = G__52515;
continue;
} else {
}
break;
}

var argseq__10383__auto__ = ((((1) < args__10382__auto__.length))?(new cljs.core.IndexedSeq(args__10382__auto__.slice((1)),(0),null)):null);
return superv.async.engulf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10383__auto__);
});

superv.async.engulf.cljs$core$IFn$_invoke$arity$variadic = (function (S,cs){
var ch = cljs.core.async.merge.call(null,cs);
var c__21755__auto__ = superv.async.check_supervisor.call(null,superv.async.S);
var id__21756__auto__ = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null))))));
var c__33866__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33866__auto__,c__21755__auto__,id__21756__auto__,ch){
return (function (){
var f__33867__auto__ = (function (){var switch__33843__auto__ = ((function (c__33866__auto__,c__21755__auto__,id__21756__auto__,ch){
return (function (state_52482){
var state_val_52483 = (state_52482[(1)]);
if((state_val_52483 === (7))){
var inst_52438 = (state_52482[(7)]);
var inst_52446 = (state_52482[(2)]);
var state_52482__$1 = (function (){var statearr_52484 = state_52482;
(statearr_52484[(8)] = inst_52446);

return statearr_52484;
})();
var statearr_52485_52516 = state_52482__$1;
(statearr_52485_52516[(2)] = inst_52438);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_52482__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52483 === (1))){
var state_52482__$1 = state_52482;
var statearr_52486_52517 = state_52482__$1;
(statearr_52486_52517[(2)] = null);

(statearr_52486_52517[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52483 === (4))){
var inst_52438 = (state_52482[(7)]);
var inst_52438__$1 = (state_52482[(2)]);
var inst_52439 = cljs.core.ex_data.call(null,inst_52438__$1);
var inst_52440 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_52439);
var inst_52441 = cljs.core._EQ_.call(null,inst_52440,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_52482__$1 = (function (){var statearr_52487 = state_52482;
(statearr_52487[(7)] = inst_52438__$1);

return statearr_52487;
})();
if(inst_52441){
var statearr_52488_52518 = state_52482__$1;
(statearr_52488_52518[(1)] = (5));

} else {
var statearr_52489_52519 = state_52482__$1;
(statearr_52489_52519[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52483 === (15))){
var state_52482__$1 = state_52482;
var statearr_52490_52520 = state_52482__$1;
(statearr_52490_52520[(2)] = null);

(statearr_52490_52520[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52483 === (13))){
var inst_52460 = (state_52482[(9)]);
var state_52482__$1 = state_52482;
var statearr_52491_52521 = state_52482__$1;
(statearr_52491_52521[(2)] = inst_52460);

(statearr_52491_52521[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52483 === (6))){
var inst_52438 = (state_52482[(7)]);
var inst_52444 = superv.async._track_exception.call(null,S,inst_52438);
var state_52482__$1 = state_52482;
var statearr_52492_52522 = state_52482__$1;
(statearr_52492_52522[(2)] = inst_52444);

(statearr_52492_52522[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52483 === (17))){
var inst_52476 = (state_52482[(2)]);
var state_52482__$1 = state_52482;
var statearr_52493_52523 = state_52482__$1;
(statearr_52493_52523[(2)] = inst_52476);

(statearr_52493_52523[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52483 === (3))){
var inst_52435 = (state_52482[(2)]);
var inst_52436 = superv.async._unregister_go.call(null,S,id__21756__auto__);
var state_52482__$1 = (function (){var statearr_52494 = state_52482;
(statearr_52494[(10)] = inst_52436);

(statearr_52494[(11)] = inst_52435);

return statearr_52494;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_52482__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52483 === (12))){
var inst_52464 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_52465 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_52466 = cljs.core.PersistentHashMap.fromArrays(inst_52464,inst_52465);
var inst_52467 = cljs.core.ex_info.call(null,"Aborted operations",inst_52466);
var state_52482__$1 = state_52482;
var statearr_52495_52524 = state_52482__$1;
(statearr_52495_52524[(2)] = inst_52467);

(statearr_52495_52524[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52483 === (2))){
var inst_52480 = (state_52482[(2)]);
var state_52482__$1 = state_52482;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_52482__$1,inst_52480);
} else {
if((state_val_52483 === (11))){
var inst_52454 = (state_52482[(12)]);
var inst_52459 = (state_52482[(2)]);
var inst_52460 = cljs.core.nth.call(null,inst_52459,(0),null);
var inst_52461 = cljs.core.nth.call(null,inst_52459,(1),null);
var inst_52462 = cljs.core._EQ_.call(null,inst_52461,inst_52454);
var state_52482__$1 = (function (){var statearr_52496 = state_52482;
(statearr_52496[(9)] = inst_52460);

return statearr_52496;
})();
if(inst_52462){
var statearr_52497_52525 = state_52482__$1;
(statearr_52497_52525[(1)] = (12));

} else {
var statearr_52498_52526 = state_52482__$1;
(statearr_52498_52526[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52483 === (9))){
var inst_52454 = (state_52482[(12)]);
var inst_52454__$1 = superv.async._abort.call(null,S);
var inst_52455 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52456 = [inst_52454__$1,ch];
var inst_52457 = (new cljs.core.PersistentVector(null,2,(5),inst_52455,inst_52456,null));
var state_52482__$1 = (function (){var statearr_52499 = state_52482;
(statearr_52499[(12)] = inst_52454__$1);

return statearr_52499;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_52482__$1,(11),inst_52457,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_52483 === (5))){
var state_52482__$1 = state_52482;
var statearr_52500_52527 = state_52482__$1;
(statearr_52500_52527[(2)] = null);

(statearr_52500_52527[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52483 === (14))){
var inst_52470 = (state_52482[(2)]);
var inst_52471 = superv.async.throw_if_exception.call(null,S,inst_52470);
var state_52482__$1 = state_52482;
if(cljs.core.truth_(inst_52471)){
var statearr_52501_52528 = state_52482__$1;
(statearr_52501_52528[(1)] = (15));

} else {
var statearr_52502_52529 = state_52482__$1;
(statearr_52502_52529[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52483 === (16))){
var state_52482__$1 = state_52482;
var statearr_52503_52530 = state_52482__$1;
(statearr_52503_52530[(2)] = null);

(statearr_52503_52530[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52483 === (10))){
var inst_52478 = (state_52482[(2)]);
var state_52482__$1 = state_52482;
var statearr_52504_52531 = state_52482__$1;
(statearr_52504_52531[(2)] = inst_52478);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_52482__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52483 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_52482,(4),Error,(3),(2));
var state_52482__$1 = state_52482;
var statearr_52505_52532 = state_52482__$1;
(statearr_52505_52532[(2)] = null);

(statearr_52505_52532[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33866__auto__,c__21755__auto__,id__21756__auto__,ch))
;
return ((function (switch__33843__auto__,c__33866__auto__,c__21755__auto__,id__21756__auto__,ch){
return (function() {
var superv$async$state_machine__33844__auto__ = null;
var superv$async$state_machine__33844__auto____0 = (function (){
var statearr_52509 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_52509[(0)] = superv$async$state_machine__33844__auto__);

(statearr_52509[(1)] = (1));

return statearr_52509;
});
var superv$async$state_machine__33844__auto____1 = (function (state_52482){
while(true){
var ret_value__33845__auto__ = (function (){try{while(true){
var result__33846__auto__ = switch__33843__auto__.call(null,state_52482);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33846__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33846__auto__;
}
break;
}
}catch (e52510){if((e52510 instanceof Object)){
var ex__33847__auto__ = e52510;
var statearr_52511_52533 = state_52482;
(statearr_52511_52533[(5)] = ex__33847__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_52482);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e52510;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33845__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52534 = state_52482;
state_52482 = G__52534;
continue;
} else {
return ret_value__33845__auto__;
}
break;
}
});
superv$async$state_machine__33844__auto__ = function(state_52482){
switch(arguments.length){
case 0:
return superv$async$state_machine__33844__auto____0.call(this);
case 1:
return superv$async$state_machine__33844__auto____1.call(this,state_52482);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__33844__auto____0;
superv$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__33844__auto____1;
return superv$async$state_machine__33844__auto__;
})()
;})(switch__33843__auto__,c__33866__auto__,c__21755__auto__,id__21756__auto__,ch))
})();
var state__33868__auto__ = (function (){var statearr_52512 = f__33867__auto__.call(null);
(statearr_52512[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33866__auto__);

return statearr_52512;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33868__auto__);
});})(c__33866__auto__,c__21755__auto__,id__21756__auto__,ch))
);

return c__33866__auto__;
});

superv.async.engulf.cljs$lang$maxFixedArity = (1);

superv.async.engulf.cljs$lang$applyTo = (function (seq52433){
var G__52434 = cljs.core.first.call(null,seq52433);
var seq52433__$1 = cljs.core.next.call(null,seq52433);
return superv.async.engulf.cljs$core$IFn$_invoke$arity$variadic(G__52434,seq52433__$1);
});

/**
 * Performs a reduce on objects from ch with the function f> (which
 *   should return a channel). Returns a channel with the resulting
 *   value.
 */
superv.async.reduce_GT_ = (function superv$async$reduce_GT_(S,f_GT_,acc,ch){
var result = cljs.core.async.chan.call(null);
var c__21755__auto___52901 = superv.async.check_supervisor.call(null,superv.async.S);
var id__21756__auto___52902 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"acc","acc",-1815869457,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null)], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),new cljs.core.Symbol(null,"x","x",-555367584,null)),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"result","result",-1239343558,null),new cljs.core.Symbol(null,"x","x",-555367584,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"result","result",-1239343558,null))),cljs.core.list(new cljs.core.Symbol(null,"->>","->>",-1874332161,null),cljs.core.list(new cljs.core.Symbol(null,"f>","f>",-1169871571,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null),new cljs.core.Symbol(null,"x","x",-555367584,null)),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null)),new cljs.core.Symbol(null,"recur","recur",1202958259,null))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"result","result",-1239343558,null),new cljs.core.Symbol(null,"acc","acc",-1815869457,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"result","result",-1239343558,null)))))));
var c__33866__auto___52903 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33866__auto___52903,c__21755__auto___52901,id__21756__auto___52902,result){
return (function (){
var f__33867__auto__ = (function (){var switch__33843__auto__ = ((function (c__33866__auto___52903,c__21755__auto___52901,id__21756__auto___52902,result){
return (function (state_52843){
var state_val_52844 = (state_52843[(1)]);
if((state_val_52844 === (7))){
var inst_52721 = (state_52843[(7)]);
var inst_52729 = (state_52843[(2)]);
var state_52843__$1 = (function (){var statearr_52845 = state_52843;
(statearr_52845[(8)] = inst_52729);

return statearr_52845;
})();
var statearr_52846_52904 = state_52843__$1;
(statearr_52846_52904[(2)] = inst_52721);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_52843__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52844 === (20))){
var inst_52809 = (state_52843[(2)]);
var state_52843__$1 = state_52843;
var statearr_52847_52905 = state_52843__$1;
(statearr_52847_52905[(2)] = inst_52809);

(statearr_52847_52905[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52844 === (27))){
var inst_52799 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_52800 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_52801 = cljs.core.PersistentHashMap.fromArrays(inst_52799,inst_52800);
var inst_52802 = cljs.core.ex_info.call(null,"Aborted operations",inst_52801);
var state_52843__$1 = state_52843;
var statearr_52848_52906 = state_52843__$1;
(statearr_52848_52906[(2)] = inst_52802);

(statearr_52848_52906[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52844 === (1))){
var state_52843__$1 = state_52843;
var statearr_52849_52907 = state_52843__$1;
(statearr_52849_52907[(2)] = null);

(statearr_52849_52907[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52844 === (24))){
var inst_52781 = (state_52843[(2)]);
var inst_52782 = superv.async.throw_if_exception.call(null,S,inst_52781);
var inst_52783 = cljs.core.async.close_BANG_.call(null,result);
var state_52843__$1 = (function (){var statearr_52850 = state_52843;
(statearr_52850[(9)] = inst_52782);

return statearr_52850;
})();
var statearr_52851_52908 = state_52843__$1;
(statearr_52851_52908[(2)] = inst_52783);

(statearr_52851_52908[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52844 === (4))){
var inst_52721 = (state_52843[(7)]);
var inst_52721__$1 = (state_52843[(2)]);
var inst_52722 = cljs.core.ex_data.call(null,inst_52721__$1);
var inst_52723 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_52722);
var inst_52724 = cljs.core._EQ_.call(null,inst_52723,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_52843__$1 = (function (){var statearr_52852 = state_52843;
(statearr_52852[(7)] = inst_52721__$1);

return statearr_52852;
})();
if(inst_52724){
var statearr_52853_52909 = state_52843__$1;
(statearr_52853_52909[(1)] = (5));

} else {
var statearr_52854_52910 = state_52843__$1;
(statearr_52854_52910[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52844 === (15))){
var inst_52755 = (state_52843[(10)]);
var inst_52757 = (inst_52755 instanceof Error);
var state_52843__$1 = state_52843;
if(cljs.core.truth_(inst_52757)){
var statearr_52855_52911 = state_52843__$1;
(statearr_52855_52911[(1)] = (18));

} else {
var statearr_52856_52912 = state_52843__$1;
(statearr_52856_52912[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52844 === (21))){
var inst_52762 = (state_52843[(11)]);
var inst_52768 = (state_52843[(2)]);
var inst_52769 = cljs.core.nth.call(null,inst_52768,(0),null);
var inst_52770 = cljs.core.nth.call(null,inst_52768,(1),null);
var inst_52771 = cljs.core._EQ_.call(null,inst_52770,inst_52762);
var state_52843__$1 = (function (){var statearr_52857 = state_52843;
(statearr_52857[(12)] = inst_52769);

return statearr_52857;
})();
if(inst_52771){
var statearr_52858_52913 = state_52843__$1;
(statearr_52858_52913[(1)] = (22));

} else {
var statearr_52859_52914 = state_52843__$1;
(statearr_52859_52914[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52844 === (31))){
var inst_52825 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_52826 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_52827 = cljs.core.PersistentHashMap.fromArrays(inst_52825,inst_52826);
var inst_52828 = cljs.core.ex_info.call(null,"Aborted operations",inst_52827);
var state_52843__$1 = state_52843;
var statearr_52860_52915 = state_52843__$1;
(statearr_52860_52915[(2)] = inst_52828);

(statearr_52860_52915[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52844 === (32))){
var inst_52733 = (state_52843[(13)]);
var state_52843__$1 = state_52843;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_52843__$1,(34),result,inst_52733);
} else {
if((state_val_52844 === (33))){
var inst_52833 = (state_52843[(2)]);
var inst_52834 = superv.async.throw_if_exception.call(null,S,inst_52833);
var inst_52835 = cljs.core.async.close_BANG_.call(null,result);
var state_52843__$1 = (function (){var statearr_52861 = state_52843;
(statearr_52861[(14)] = inst_52834);

return statearr_52861;
})();
var statearr_52862_52916 = state_52843__$1;
(statearr_52862_52916[(2)] = inst_52835);

(statearr_52862_52916[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52844 === (13))){
var inst_52744 = (state_52843[(15)]);
var state_52843__$1 = state_52843;
var statearr_52863_52917 = state_52843__$1;
(statearr_52863_52917[(2)] = inst_52744);

(statearr_52863_52917[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52844 === (22))){
var inst_52773 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_52774 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_52775 = cljs.core.PersistentHashMap.fromArrays(inst_52773,inst_52774);
var inst_52776 = cljs.core.ex_info.call(null,"Aborted operations",inst_52775);
var state_52843__$1 = state_52843;
var statearr_52864_52918 = state_52843__$1;
(statearr_52864_52918[(2)] = inst_52776);

(statearr_52864_52918[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52844 === (29))){
var inst_52805 = (state_52843[(2)]);
var inst_52806 = superv.async.throw_if_exception.call(null,S,inst_52805);
var inst_52733 = inst_52806;
var state_52843__$1 = (function (){var statearr_52865 = state_52843;
(statearr_52865[(13)] = inst_52733);

return statearr_52865;
})();
var statearr_52866_52919 = state_52843__$1;
(statearr_52866_52919[(2)] = null);

(statearr_52866_52919[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52844 === (6))){
var inst_52721 = (state_52843[(7)]);
var inst_52727 = superv.async._track_exception.call(null,S,inst_52721);
var state_52843__$1 = state_52843;
var statearr_52867_52920 = state_52843__$1;
(statearr_52867_52920[(2)] = inst_52727);

(statearr_52867_52920[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52844 === (28))){
var inst_52795 = (state_52843[(16)]);
var state_52843__$1 = state_52843;
var statearr_52868_52921 = state_52843__$1;
(statearr_52868_52921[(2)] = inst_52795);

(statearr_52868_52921[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52844 === (25))){
var inst_52779 = (state_52843[(2)]);
var state_52843__$1 = state_52843;
var statearr_52869_52922 = state_52843__$1;
(statearr_52869_52922[(2)] = inst_52779);

(statearr_52869_52922[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52844 === (34))){
var inst_52831 = (state_52843[(2)]);
var state_52843__$1 = state_52843;
var statearr_52870_52923 = state_52843__$1;
(statearr_52870_52923[(2)] = inst_52831);

(statearr_52870_52923[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52844 === (17))){
var inst_52837 = (state_52843[(2)]);
var state_52843__$1 = state_52843;
var statearr_52871_52924 = state_52843__$1;
(statearr_52871_52924[(2)] = inst_52837);

(statearr_52871_52924[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52844 === (3))){
var inst_52718 = (state_52843[(2)]);
var inst_52719 = superv.async._unregister_go.call(null,S,id__21756__auto___52902);
var state_52843__$1 = (function (){var statearr_52872 = state_52843;
(statearr_52872[(17)] = inst_52718);

(statearr_52872[(18)] = inst_52719);

return statearr_52872;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_52843__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52844 === (12))){
var inst_52748 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_52749 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_52750 = cljs.core.PersistentHashMap.fromArrays(inst_52748,inst_52749);
var inst_52751 = cljs.core.ex_info.call(null,"Aborted operations",inst_52750);
var state_52843__$1 = state_52843;
var statearr_52873_52925 = state_52843__$1;
(statearr_52873_52925[(2)] = inst_52751);

(statearr_52873_52925[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52844 === (2))){
var inst_52841 = (state_52843[(2)]);
var state_52843__$1 = state_52843;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_52843__$1,inst_52841);
} else {
if((state_val_52844 === (23))){
var inst_52755 = (state_52843[(10)]);
var state_52843__$1 = state_52843;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_52843__$1,(25),result,inst_52755);
} else {
if((state_val_52844 === (19))){
var inst_52788 = (state_52843[(19)]);
var inst_52755 = (state_52843[(10)]);
var inst_52733 = (state_52843[(13)]);
var inst_52788__$1 = superv.async._abort.call(null,S);
var inst_52789 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52790 = f_GT_.call(null,inst_52733,inst_52755);
var inst_52791 = [inst_52788__$1,inst_52790];
var inst_52792 = (new cljs.core.PersistentVector(null,2,(5),inst_52789,inst_52791,null));
var state_52843__$1 = (function (){var statearr_52874 = state_52843;
(statearr_52874[(19)] = inst_52788__$1);

return statearr_52874;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_52843__$1,(26),inst_52792,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_52844 === (11))){
var inst_52738 = (state_52843[(20)]);
var inst_52743 = (state_52843[(2)]);
var inst_52744 = cljs.core.nth.call(null,inst_52743,(0),null);
var inst_52745 = cljs.core.nth.call(null,inst_52743,(1),null);
var inst_52746 = cljs.core._EQ_.call(null,inst_52745,inst_52738);
var state_52843__$1 = (function (){var statearr_52875 = state_52843;
(statearr_52875[(15)] = inst_52744);

return statearr_52875;
})();
if(inst_52746){
var statearr_52876_52926 = state_52843__$1;
(statearr_52876_52926[(1)] = (12));

} else {
var statearr_52877_52927 = state_52843__$1;
(statearr_52877_52927[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52844 === (9))){
var inst_52738 = (state_52843[(20)]);
var inst_52738__$1 = superv.async._abort.call(null,S);
var inst_52739 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52740 = [inst_52738__$1,ch];
var inst_52741 = (new cljs.core.PersistentVector(null,2,(5),inst_52739,inst_52740,null));
var state_52843__$1 = (function (){var statearr_52878 = state_52843;
(statearr_52878[(20)] = inst_52738__$1);

return statearr_52878;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_52843__$1,(11),inst_52741,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_52844 === (5))){
var state_52843__$1 = state_52843;
var statearr_52879_52928 = state_52843__$1;
(statearr_52879_52928[(2)] = null);

(statearr_52879_52928[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52844 === (14))){
var inst_52755 = (state_52843[(10)]);
var inst_52754 = (state_52843[(2)]);
var inst_52755__$1 = superv.async.throw_if_exception.call(null,S,inst_52754);
var state_52843__$1 = (function (){var statearr_52880 = state_52843;
(statearr_52880[(10)] = inst_52755__$1);

return statearr_52880;
})();
if(cljs.core.truth_(inst_52755__$1)){
var statearr_52881_52929 = state_52843__$1;
(statearr_52881_52929[(1)] = (15));

} else {
var statearr_52882_52930 = state_52843__$1;
(statearr_52882_52930[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52844 === (26))){
var inst_52788 = (state_52843[(19)]);
var inst_52794 = (state_52843[(2)]);
var inst_52795 = cljs.core.nth.call(null,inst_52794,(0),null);
var inst_52796 = cljs.core.nth.call(null,inst_52794,(1),null);
var inst_52797 = cljs.core._EQ_.call(null,inst_52796,inst_52788);
var state_52843__$1 = (function (){var statearr_52883 = state_52843;
(statearr_52883[(16)] = inst_52795);

return statearr_52883;
})();
if(inst_52797){
var statearr_52884_52931 = state_52843__$1;
(statearr_52884_52931[(1)] = (27));

} else {
var statearr_52885_52932 = state_52843__$1;
(statearr_52885_52932[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52844 === (16))){
var inst_52814 = (state_52843[(21)]);
var inst_52814__$1 = superv.async._abort.call(null,S);
var inst_52815 = cljs.core.async.timeout.call(null,(0));
var inst_52816 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52817 = [inst_52814__$1,inst_52815];
var inst_52818 = (new cljs.core.PersistentVector(null,2,(5),inst_52816,inst_52817,null));
var state_52843__$1 = (function (){var statearr_52886 = state_52843;
(statearr_52886[(21)] = inst_52814__$1);

return statearr_52886;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_52843__$1,(30),inst_52818,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_52844 === (30))){
var inst_52814 = (state_52843[(21)]);
var inst_52820 = (state_52843[(2)]);
var inst_52821 = cljs.core.nth.call(null,inst_52820,(0),null);
var inst_52822 = cljs.core.nth.call(null,inst_52820,(1),null);
var inst_52823 = cljs.core._EQ_.call(null,inst_52822,inst_52814);
var state_52843__$1 = (function (){var statearr_52887 = state_52843;
(statearr_52887[(22)] = inst_52821);

return statearr_52887;
})();
if(inst_52823){
var statearr_52888_52933 = state_52843__$1;
(statearr_52888_52933[(1)] = (31));

} else {
var statearr_52889_52934 = state_52843__$1;
(statearr_52889_52934[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52844 === (10))){
var inst_52839 = (state_52843[(2)]);
var state_52843__$1 = state_52843;
var statearr_52890_52935 = state_52843__$1;
(statearr_52890_52935[(2)] = inst_52839);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_52843__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52844 === (18))){
var inst_52762 = (state_52843[(11)]);
var inst_52762__$1 = superv.async._abort.call(null,S);
var inst_52763 = cljs.core.async.timeout.call(null,(0));
var inst_52764 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52765 = [inst_52762__$1,inst_52763];
var inst_52766 = (new cljs.core.PersistentVector(null,2,(5),inst_52764,inst_52765,null));
var state_52843__$1 = (function (){var statearr_52891 = state_52843;
(statearr_52891[(11)] = inst_52762__$1);

return statearr_52891;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_52843__$1,(21),inst_52766,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_52844 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_52843,(4),Error,(3),(2));
var inst_52733 = acc;
var state_52843__$1 = (function (){var statearr_52892 = state_52843;
(statearr_52892[(13)] = inst_52733);

return statearr_52892;
})();
var statearr_52893_52936 = state_52843__$1;
(statearr_52893_52936[(2)] = null);

(statearr_52893_52936[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33866__auto___52903,c__21755__auto___52901,id__21756__auto___52902,result))
;
return ((function (switch__33843__auto__,c__33866__auto___52903,c__21755__auto___52901,id__21756__auto___52902,result){
return (function() {
var superv$async$reduce_GT__$_state_machine__33844__auto__ = null;
var superv$async$reduce_GT__$_state_machine__33844__auto____0 = (function (){
var statearr_52897 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_52897[(0)] = superv$async$reduce_GT__$_state_machine__33844__auto__);

(statearr_52897[(1)] = (1));

return statearr_52897;
});
var superv$async$reduce_GT__$_state_machine__33844__auto____1 = (function (state_52843){
while(true){
var ret_value__33845__auto__ = (function (){try{while(true){
var result__33846__auto__ = switch__33843__auto__.call(null,state_52843);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33846__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33846__auto__;
}
break;
}
}catch (e52898){if((e52898 instanceof Object)){
var ex__33847__auto__ = e52898;
var statearr_52899_52937 = state_52843;
(statearr_52899_52937[(5)] = ex__33847__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_52843);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e52898;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33845__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52938 = state_52843;
state_52843 = G__52938;
continue;
} else {
return ret_value__33845__auto__;
}
break;
}
});
superv$async$reduce_GT__$_state_machine__33844__auto__ = function(state_52843){
switch(arguments.length){
case 0:
return superv$async$reduce_GT__$_state_machine__33844__auto____0.call(this);
case 1:
return superv$async$reduce_GT__$_state_machine__33844__auto____1.call(this,state_52843);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$reduce_GT__$_state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$reduce_GT__$_state_machine__33844__auto____0;
superv$async$reduce_GT__$_state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$reduce_GT__$_state_machine__33844__auto____1;
return superv$async$reduce_GT__$_state_machine__33844__auto__;
})()
;})(switch__33843__auto__,c__33866__auto___52903,c__21755__auto___52901,id__21756__auto___52902,result))
})();
var state__33868__auto__ = (function (){var statearr_52900 = f__33867__auto__.call(null);
(statearr_52900[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33866__auto___52903);

return statearr_52900;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33868__auto__);
});})(c__33866__auto___52903,c__21755__auto___52901,id__21756__auto___52902,result))
);


return result;
});
/**
 * Concatenates two or more channels. First takes all values from first channel
 *   and supplies to output channel, then takes all values from second channel and
 *   so on. Similiar to core.async/merge but maintains the order of values.
 */
superv.async.concat_GT__GT_ = (function superv$async$concat_GT__GT_(var_args){
var args__10382__auto__ = [];
var len__10375__auto___53068 = arguments.length;
var i__10376__auto___53069 = (0);
while(true){
if((i__10376__auto___53069 < len__10375__auto___53068)){
args__10382__auto__.push((arguments[i__10376__auto___53069]));

var G__53070 = (i__10376__auto___53069 + (1));
i__10376__auto___53069 = G__53070;
continue;
} else {
}
break;
}

var argseq__10383__auto__ = ((((1) < args__10382__auto__.length))?(new cljs.core.IndexedSeq(args__10382__auto__.slice((1)),(0),null)):null);
return superv.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10383__auto__);
});

superv.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (S,cs){
var out = cljs.core.async.chan.call(null);
var c__21755__auto___53071 = superv.async.check_supervisor.call(null,superv.async.S);
var id__21756__auto___53072 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"loop","loop",1244978678,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null)], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"c","c",-122660552,null),cljs.core.list(new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"c","c",-122660552,null))], null),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"v","v",1661996586,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null))),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),cljs.core.list(new cljs.core.Symbol(null,"rest","rest",398835108,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null)))),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out","out",729986010,null))))));
var c__33866__auto___53073 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33866__auto___53073,c__21755__auto___53071,id__21756__auto___53072,out){
return (function (){
var f__33867__auto__ = (function (){var switch__33843__auto__ = ((function (c__33866__auto___53073,c__21755__auto___53071,id__21756__auto___53072,out){
return (function (state_53021){
var state_val_53022 = (state_53021[(1)]);
if((state_val_53022 === (7))){
var inst_52944 = (state_53021[(7)]);
var inst_52952 = (state_53021[(2)]);
var state_53021__$1 = (function (){var statearr_53024 = state_53021;
(statearr_53024[(8)] = inst_52952);

return statearr_53024;
})();
var statearr_53025_53074 = state_53021__$1;
(statearr_53025_53074[(2)] = inst_52944);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53021__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53022 === (20))){
var inst_53011 = (state_53021[(2)]);
var state_53021__$1 = state_53021;
var statearr_53026_53075 = state_53021__$1;
(statearr_53026_53075[(2)] = inst_53011);

(statearr_53026_53075[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53022 === (1))){
var state_53021__$1 = state_53021;
var statearr_53027_53076 = state_53021__$1;
(statearr_53027_53076[(2)] = null);

(statearr_53027_53076[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53022 === (24))){
var inst_52956 = (state_53021[(9)]);
var inst_53004 = (state_53021[(2)]);
var inst_53005 = superv.async.throw_if_exception.call(null,S,inst_53004);
var tmp53023 = inst_52956;
var inst_52956__$1 = tmp53023;
var state_53021__$1 = (function (){var statearr_53028 = state_53021;
(statearr_53028[(9)] = inst_52956__$1);

(statearr_53028[(10)] = inst_53005);

return statearr_53028;
})();
var statearr_53029_53077 = state_53021__$1;
(statearr_53029_53077[(2)] = null);

(statearr_53029_53077[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53022 === (4))){
var inst_52944 = (state_53021[(7)]);
var inst_52944__$1 = (state_53021[(2)]);
var inst_52945 = cljs.core.ex_data.call(null,inst_52944__$1);
var inst_52946 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_52945);
var inst_52947 = cljs.core._EQ_.call(null,inst_52946,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_53021__$1 = (function (){var statearr_53030 = state_53021;
(statearr_53030[(7)] = inst_52944__$1);

return statearr_53030;
})();
if(inst_52947){
var statearr_53031_53078 = state_53021__$1;
(statearr_53031_53078[(1)] = (5));

} else {
var statearr_53032_53079 = state_53021__$1;
(statearr_53032_53079[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53022 === (15))){
var inst_52973 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_52974 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_52975 = cljs.core.PersistentHashMap.fromArrays(inst_52973,inst_52974);
var inst_52976 = cljs.core.ex_info.call(null,"Aborted operations",inst_52975);
var state_53021__$1 = state_53021;
var statearr_53033_53080 = state_53021__$1;
(statearr_53033_53080[(2)] = inst_52976);

(statearr_53033_53080[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53022 === (21))){
var inst_52985 = (state_53021[(11)]);
var inst_52991 = (state_53021[(2)]);
var inst_52992 = cljs.core.nth.call(null,inst_52991,(0),null);
var inst_52993 = cljs.core.nth.call(null,inst_52991,(1),null);
var inst_52994 = cljs.core._EQ_.call(null,inst_52993,inst_52985);
var state_53021__$1 = (function (){var statearr_53034 = state_53021;
(statearr_53034[(12)] = inst_52992);

return statearr_53034;
})();
if(inst_52994){
var statearr_53035_53081 = state_53021__$1;
(statearr_53035_53081[(1)] = (22));

} else {
var statearr_53036_53082 = state_53021__$1;
(statearr_53036_53082[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53022 === (13))){
var inst_53015 = (state_53021[(2)]);
var state_53021__$1 = state_53021;
var statearr_53037_53083 = state_53021__$1;
(statearr_53037_53083[(2)] = inst_53015);

(statearr_53037_53083[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53022 === (22))){
var inst_52996 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_52997 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_52998 = cljs.core.PersistentHashMap.fromArrays(inst_52996,inst_52997);
var inst_52999 = cljs.core.ex_info.call(null,"Aborted operations",inst_52998);
var state_53021__$1 = state_53021;
var statearr_53038_53084 = state_53021__$1;
(statearr_53038_53084[(2)] = inst_52999);

(statearr_53038_53084[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53022 === (6))){
var inst_52944 = (state_53021[(7)]);
var inst_52950 = superv.async._track_exception.call(null,S,inst_52944);
var state_53021__$1 = state_53021;
var statearr_53039_53085 = state_53021__$1;
(statearr_53039_53085[(2)] = inst_52950);

(statearr_53039_53085[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53022 === (25))){
var inst_53002 = (state_53021[(2)]);
var state_53021__$1 = state_53021;
var statearr_53040_53086 = state_53021__$1;
(statearr_53040_53086[(2)] = inst_53002);

(statearr_53040_53086[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53022 === (17))){
var inst_52980 = (state_53021[(13)]);
var inst_52979 = (state_53021[(2)]);
var inst_52980__$1 = superv.async.throw_if_exception.call(null,S,inst_52979);
var state_53021__$1 = (function (){var statearr_53041 = state_53021;
(statearr_53041[(13)] = inst_52980__$1);

return statearr_53041;
})();
if(cljs.core.truth_(inst_52980__$1)){
var statearr_53042_53087 = state_53021__$1;
(statearr_53042_53087[(1)] = (18));

} else {
var statearr_53043_53088 = state_53021__$1;
(statearr_53043_53088[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53022 === (3))){
var inst_52941 = (state_53021[(2)]);
var inst_52942 = superv.async._unregister_go.call(null,S,id__21756__auto___53072);
var state_53021__$1 = (function (){var statearr_53044 = state_53021;
(statearr_53044[(14)] = inst_52942);

(statearr_53044[(15)] = inst_52941);

return statearr_53044;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53021__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53022 === (12))){
var inst_53013 = cljs.core.async.close_BANG_.call(null,out);
var state_53021__$1 = state_53021;
var statearr_53045_53089 = state_53021__$1;
(statearr_53045_53089[(2)] = inst_53013);

(statearr_53045_53089[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53022 === (2))){
var inst_53019 = (state_53021[(2)]);
var state_53021__$1 = state_53021;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53021__$1,inst_53019);
} else {
if((state_val_53022 === (23))){
var inst_52980 = (state_53021[(13)]);
var state_53021__$1 = state_53021;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_53021__$1,(25),out,inst_52980);
} else {
if((state_val_53022 === (19))){
var inst_52956 = (state_53021[(9)]);
var inst_53008 = cljs.core.rest.call(null,inst_52956);
var inst_52956__$1 = inst_53008;
var state_53021__$1 = (function (){var statearr_53046 = state_53021;
(statearr_53046[(9)] = inst_52956__$1);

return statearr_53046;
})();
var statearr_53047_53090 = state_53021__$1;
(statearr_53047_53090[(2)] = null);

(statearr_53047_53090[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53022 === (11))){
var inst_52963 = (state_53021[(16)]);
var inst_52958 = (state_53021[(17)]);
var inst_52963__$1 = superv.async._abort.call(null,S);
var inst_52964 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52965 = [inst_52963__$1,inst_52958];
var inst_52966 = (new cljs.core.PersistentVector(null,2,(5),inst_52964,inst_52965,null));
var state_53021__$1 = (function (){var statearr_53048 = state_53021;
(statearr_53048[(16)] = inst_52963__$1);

return statearr_53048;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_53021__$1,(14),inst_52966,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_53022 === (9))){
var inst_52956 = (state_53021[(9)]);
var inst_52958 = (state_53021[(17)]);
var inst_52958__$1 = cljs.core.first.call(null,inst_52956);
var state_53021__$1 = (function (){var statearr_53049 = state_53021;
(statearr_53049[(17)] = inst_52958__$1);

return statearr_53049;
})();
if(cljs.core.truth_(inst_52958__$1)){
var statearr_53050_53091 = state_53021__$1;
(statearr_53050_53091[(1)] = (11));

} else {
var statearr_53051_53092 = state_53021__$1;
(statearr_53051_53092[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53022 === (5))){
var state_53021__$1 = state_53021;
var statearr_53052_53093 = state_53021__$1;
(statearr_53052_53093[(2)] = null);

(statearr_53052_53093[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53022 === (14))){
var inst_52963 = (state_53021[(16)]);
var inst_52968 = (state_53021[(2)]);
var inst_52969 = cljs.core.nth.call(null,inst_52968,(0),null);
var inst_52970 = cljs.core.nth.call(null,inst_52968,(1),null);
var inst_52971 = cljs.core._EQ_.call(null,inst_52970,inst_52963);
var state_53021__$1 = (function (){var statearr_53053 = state_53021;
(statearr_53053[(18)] = inst_52969);

return statearr_53053;
})();
if(inst_52971){
var statearr_53054_53094 = state_53021__$1;
(statearr_53054_53094[(1)] = (15));

} else {
var statearr_53055_53095 = state_53021__$1;
(statearr_53055_53095[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53022 === (16))){
var inst_52969 = (state_53021[(18)]);
var state_53021__$1 = state_53021;
var statearr_53056_53096 = state_53021__$1;
(statearr_53056_53096[(2)] = inst_52969);

(statearr_53056_53096[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53022 === (10))){
var inst_53017 = (state_53021[(2)]);
var state_53021__$1 = state_53021;
var statearr_53057_53097 = state_53021__$1;
(statearr_53057_53097[(2)] = inst_53017);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53021__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53022 === (18))){
var inst_52985 = (state_53021[(11)]);
var inst_52985__$1 = superv.async._abort.call(null,S);
var inst_52986 = cljs.core.async.timeout.call(null,(0));
var inst_52987 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52988 = [inst_52985__$1,inst_52986];
var inst_52989 = (new cljs.core.PersistentVector(null,2,(5),inst_52987,inst_52988,null));
var state_53021__$1 = (function (){var statearr_53058 = state_53021;
(statearr_53058[(11)] = inst_52985__$1);

return statearr_53058;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_53021__$1,(21),inst_52989,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_53022 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_53021,(4),Error,(3),(2));
var inst_52956 = cs;
var state_53021__$1 = (function (){var statearr_53059 = state_53021;
(statearr_53059[(9)] = inst_52956);

return statearr_53059;
})();
var statearr_53060_53098 = state_53021__$1;
(statearr_53060_53098[(2)] = null);

(statearr_53060_53098[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33866__auto___53073,c__21755__auto___53071,id__21756__auto___53072,out))
;
return ((function (switch__33843__auto__,c__33866__auto___53073,c__21755__auto___53071,id__21756__auto___53072,out){
return (function() {
var superv$async$state_machine__33844__auto__ = null;
var superv$async$state_machine__33844__auto____0 = (function (){
var statearr_53064 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_53064[(0)] = superv$async$state_machine__33844__auto__);

(statearr_53064[(1)] = (1));

return statearr_53064;
});
var superv$async$state_machine__33844__auto____1 = (function (state_53021){
while(true){
var ret_value__33845__auto__ = (function (){try{while(true){
var result__33846__auto__ = switch__33843__auto__.call(null,state_53021);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33846__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33846__auto__;
}
break;
}
}catch (e53065){if((e53065 instanceof Object)){
var ex__33847__auto__ = e53065;
var statearr_53066_53099 = state_53021;
(statearr_53066_53099[(5)] = ex__33847__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53021);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e53065;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33845__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53100 = state_53021;
state_53021 = G__53100;
continue;
} else {
return ret_value__33845__auto__;
}
break;
}
});
superv$async$state_machine__33844__auto__ = function(state_53021){
switch(arguments.length){
case 0:
return superv$async$state_machine__33844__auto____0.call(this);
case 1:
return superv$async$state_machine__33844__auto____1.call(this,state_53021);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__33844__auto____0;
superv$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__33844__auto____1;
return superv$async$state_machine__33844__auto__;
})()
;})(switch__33843__auto__,c__33866__auto___53073,c__21755__auto___53071,id__21756__auto___53072,out))
})();
var state__33868__auto__ = (function (){var statearr_53067 = f__33867__auto__.call(null);
(statearr_53067[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33866__auto___53073);

return statearr_53067;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33868__auto__);
});})(c__33866__auto___53073,c__21755__auto___53071,id__21756__auto___53072,out))
);


return out;
});

superv.async.concat_GT__GT_.cljs$lang$maxFixedArity = (1);

superv.async.concat_GT__GT_.cljs$lang$applyTo = (function (seq52939){
var G__52940 = cljs.core.first.call(null,seq52939);
var seq52939__$1 = cljs.core.next.call(null,seq52939);
return superv.async.concat_GT__GT_.cljs$core$IFn$_invoke$arity$variadic(G__52940,seq52939__$1);
});

superv.async.partition_all_GT__GT_ = (function superv$async$partition_all_GT__GT_(var_args){
var args__10382__auto__ = [];
var len__10375__auto___53318 = arguments.length;
var i__10376__auto___53319 = (0);
while(true){
if((i__10376__auto___53319 < len__10375__auto___53318)){
args__10382__auto__.push((arguments[i__10376__auto___53319]));

var G__53320 = (i__10376__auto___53319 + (1));
i__10376__auto___53319 = G__53320;
continue;
} else {
}
break;
}

var argseq__10383__auto__ = ((((3) < args__10382__auto__.length))?(new cljs.core.IndexedSeq(args__10382__auto__.slice((3)),(0),null)):null);
return superv.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10383__auto__);
});

superv.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (S,n,in_ch,p__53105){
var map__53106 = p__53105;
var map__53106__$1 = ((((!((map__53106 == null)))?((((map__53106.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53106.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53106):map__53106);
var out_ch = cljs.core.get.call(null,map__53106__$1,new cljs.core.Keyword(null,"out-ch","out-ch",-189045854));

new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(n > (0))], null)], null);

var out_ch__$1 = (function (){var or__9154__auto__ = out_ch;
if(cljs.core.truth_(or__9154__auto__)){
return or__9154__auto__;
} else {
return cljs.core.async.chan.call(null);
}
})();
var c__21755__auto___53321 = superv.async.check_supervisor.call(null,superv.async.S);
var id__21756__auto___53322 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"batch","batch",977610327,null),cljs.core.PersistentVector.EMPTY], null),cljs.core.list(new cljs.core.Symbol(null,"if-let","if-let",1803593690,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"obj","obj",-1672671807,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"in-ch","in-ch",-1757981794,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"instance?","instance?",1075939923,null),new cljs.core.Symbol("js","Error","js/Error",-1692659266,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null))),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null),cljs.core.list(new cljs.core.Symbol(null,"conj","conj",-1127293942,null),new cljs.core.Symbol(null,"batch","batch",977610327,null),new cljs.core.Symbol(null,"obj","obj",-1672671807,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),cljs.core.PersistentVector.EMPTY)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),new cljs.core.Symbol(null,"new-batch","new-batch",720019835,null))))),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,"when","when",1064114221,null),cljs.core.list(new cljs.core.Symbol(null,"not-empty","not-empty",2029453590,null),new cljs.core.Symbol(null,"batch","batch",977610327,null)),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null),new cljs.core.Symbol(null,"batch","batch",977610327,null))),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out-ch","out-ch",1451485673,null)))))));
var c__33866__auto___53323 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33866__auto___53323,c__21755__auto___53321,id__21756__auto___53322,out_ch__$1,map__53106,map__53106__$1,out_ch){
return (function (){
var f__33867__auto__ = (function (){var switch__33843__auto__ = ((function (c__33866__auto___53323,c__21755__auto___53321,id__21756__auto___53322,out_ch__$1,map__53106,map__53106__$1,out_ch){
return (function (state_53250){
var state_val_53251 = (state_53250[(1)]);
if((state_val_53251 === (7))){
var inst_53111 = (state_53250[(7)]);
var inst_53119 = (state_53250[(2)]);
var state_53250__$1 = (function (){var statearr_53252 = state_53250;
(statearr_53252[(8)] = inst_53119);

return statearr_53252;
})();
var statearr_53253_53324 = state_53250__$1;
(statearr_53253_53324[(2)] = inst_53111);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53250__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (20))){
var inst_53211 = (state_53250[(2)]);
var state_53250__$1 = state_53250;
var statearr_53254_53325 = state_53250__$1;
(statearr_53254_53325[(2)] = inst_53211);

(statearr_53254_53325[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (27))){
var inst_53176 = (state_53250[(9)]);
var inst_53124 = inst_53176;
var state_53250__$1 = (function (){var statearr_53255 = state_53250;
(statearr_53255[(10)] = inst_53124);

return statearr_53255;
})();
var statearr_53256_53326 = state_53250__$1;
(statearr_53256_53326[(2)] = null);

(statearr_53256_53326[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (1))){
var state_53250__$1 = state_53250;
var statearr_53257_53327 = state_53250__$1;
(statearr_53257_53327[(2)] = null);

(statearr_53257_53327[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (24))){
var inst_53172 = (state_53250[(2)]);
var inst_53173 = superv.async.throw_if_exception.call(null,S,inst_53172);
var inst_53174 = cljs.core.async.close_BANG_.call(null,out_ch__$1);
var state_53250__$1 = (function (){var statearr_53258 = state_53250;
(statearr_53258[(11)] = inst_53173);

return statearr_53258;
})();
var statearr_53259_53328 = state_53250__$1;
(statearr_53259_53328[(2)] = inst_53174);

(statearr_53259_53328[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (39))){
var inst_53124 = (state_53250[(10)]);
var state_53250__$1 = state_53250;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_53250__$1,(41),out_ch__$1,inst_53124);
} else {
if((state_val_53251 === (4))){
var inst_53111 = (state_53250[(7)]);
var inst_53111__$1 = (state_53250[(2)]);
var inst_53112 = cljs.core.ex_data.call(null,inst_53111__$1);
var inst_53113 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_53112);
var inst_53114 = cljs.core._EQ_.call(null,inst_53113,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_53250__$1 = (function (){var statearr_53260 = state_53250;
(statearr_53260[(7)] = inst_53111__$1);

return statearr_53260;
})();
if(inst_53114){
var statearr_53261_53329 = state_53250__$1;
(statearr_53261_53329[(1)] = (5));

} else {
var statearr_53262_53330 = state_53250__$1;
(statearr_53262_53330[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (15))){
var inst_53146 = (state_53250[(12)]);
var inst_53148 = (inst_53146 instanceof Error);
var state_53250__$1 = state_53250;
if(cljs.core.truth_(inst_53148)){
var statearr_53263_53331 = state_53250__$1;
(statearr_53263_53331[(1)] = (18));

} else {
var statearr_53264_53332 = state_53250__$1;
(statearr_53264_53332[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (21))){
var inst_53153 = (state_53250[(13)]);
var inst_53159 = (state_53250[(2)]);
var inst_53160 = cljs.core.nth.call(null,inst_53159,(0),null);
var inst_53161 = cljs.core.nth.call(null,inst_53159,(1),null);
var inst_53162 = cljs.core._EQ_.call(null,inst_53161,inst_53153);
var state_53250__$1 = (function (){var statearr_53265 = state_53250;
(statearr_53265[(14)] = inst_53160);

return statearr_53265;
})();
if(inst_53162){
var statearr_53266_53333 = state_53250__$1;
(statearr_53266_53333[(1)] = (22));

} else {
var statearr_53267_53334 = state_53250__$1;
(statearr_53267_53334[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (31))){
var inst_53176 = (state_53250[(9)]);
var state_53250__$1 = state_53250;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_53250__$1,(33),out_ch__$1,inst_53176);
} else {
if((state_val_53251 === (32))){
var inst_53202 = (state_53250[(2)]);
var inst_53203 = superv.async.throw_if_exception.call(null,S,inst_53202);
var inst_53204 = cljs.core.PersistentVector.EMPTY;
var inst_53124 = inst_53204;
var state_53250__$1 = (function (){var statearr_53268 = state_53250;
(statearr_53268[(10)] = inst_53124);

(statearr_53268[(15)] = inst_53203);

return statearr_53268;
})();
var statearr_53269_53335 = state_53250__$1;
(statearr_53269_53335[(2)] = null);

(statearr_53269_53335[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (40))){
var inst_53237 = (state_53250[(2)]);
var inst_53238 = superv.async.throw_if_exception.call(null,S,inst_53237);
var state_53250__$1 = state_53250;
var statearr_53270_53336 = state_53250__$1;
(statearr_53270_53336[(2)] = inst_53238);

(statearr_53270_53336[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (33))){
var inst_53200 = (state_53250[(2)]);
var state_53250__$1 = state_53250;
var statearr_53271_53337 = state_53250__$1;
(statearr_53271_53337[(2)] = inst_53200);

(statearr_53271_53337[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (13))){
var inst_53135 = (state_53250[(16)]);
var state_53250__$1 = state_53250;
var statearr_53272_53338 = state_53250__$1;
(statearr_53272_53338[(2)] = inst_53135);

(statearr_53272_53338[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (22))){
var inst_53164 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_53165 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_53166 = cljs.core.PersistentHashMap.fromArrays(inst_53164,inst_53165);
var inst_53167 = cljs.core.ex_info.call(null,"Aborted operations",inst_53166);
var state_53250__$1 = state_53250;
var statearr_53273_53339 = state_53250__$1;
(statearr_53273_53339[(2)] = inst_53167);

(statearr_53273_53339[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (36))){
var inst_53241 = (state_53250[(2)]);
var inst_53242 = cljs.core.async.close_BANG_.call(null,out_ch__$1);
var state_53250__$1 = (function (){var statearr_53274 = state_53250;
(statearr_53274[(17)] = inst_53241);

return statearr_53274;
})();
var statearr_53275_53340 = state_53250__$1;
(statearr_53275_53340[(2)] = inst_53242);

(statearr_53275_53340[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (41))){
var inst_53235 = (state_53250[(2)]);
var state_53250__$1 = state_53250;
var statearr_53276_53341 = state_53250__$1;
(statearr_53276_53341[(2)] = inst_53235);

(statearr_53276_53341[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (29))){
var inst_53183 = (state_53250[(18)]);
var inst_53189 = (state_53250[(2)]);
var inst_53190 = cljs.core.nth.call(null,inst_53189,(0),null);
var inst_53191 = cljs.core.nth.call(null,inst_53189,(1),null);
var inst_53192 = cljs.core._EQ_.call(null,inst_53191,inst_53183);
var state_53250__$1 = (function (){var statearr_53277 = state_53250;
(statearr_53277[(19)] = inst_53190);

return statearr_53277;
})();
if(inst_53192){
var statearr_53278_53342 = state_53250__$1;
(statearr_53278_53342[(1)] = (30));

} else {
var statearr_53279_53343 = state_53250__$1;
(statearr_53279_53343[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (6))){
var inst_53111 = (state_53250[(7)]);
var inst_53117 = superv.async._track_exception.call(null,S,inst_53111);
var state_53250__$1 = state_53250;
var statearr_53280_53344 = state_53250__$1;
(statearr_53280_53344[(2)] = inst_53117);

(statearr_53280_53344[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (28))){
var inst_53209 = (state_53250[(2)]);
var state_53250__$1 = state_53250;
var statearr_53281_53345 = state_53250__$1;
(statearr_53281_53345[(2)] = inst_53209);

(statearr_53281_53345[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (25))){
var inst_53170 = (state_53250[(2)]);
var state_53250__$1 = state_53250;
var statearr_53282_53346 = state_53250__$1;
(statearr_53282_53346[(2)] = inst_53170);

(statearr_53282_53346[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (34))){
var inst_53218 = (state_53250[(20)]);
var inst_53218__$1 = superv.async._abort.call(null,S);
var inst_53219 = cljs.core.async.timeout.call(null,(0));
var inst_53220 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53221 = [inst_53218__$1,inst_53219];
var inst_53222 = (new cljs.core.PersistentVector(null,2,(5),inst_53220,inst_53221,null));
var state_53250__$1 = (function (){var statearr_53283 = state_53250;
(statearr_53283[(20)] = inst_53218__$1);

return statearr_53283;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_53250__$1,(37),inst_53222,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_53251 === (17))){
var inst_53244 = (state_53250[(2)]);
var state_53250__$1 = state_53250;
var statearr_53284_53347 = state_53250__$1;
(statearr_53284_53347[(2)] = inst_53244);

(statearr_53284_53347[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (3))){
var inst_53108 = (state_53250[(2)]);
var inst_53109 = superv.async._unregister_go.call(null,S,id__21756__auto___53322);
var state_53250__$1 = (function (){var statearr_53285 = state_53250;
(statearr_53285[(21)] = inst_53108);

(statearr_53285[(22)] = inst_53109);

return statearr_53285;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53250__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (12))){
var inst_53139 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_53140 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_53141 = cljs.core.PersistentHashMap.fromArrays(inst_53139,inst_53140);
var inst_53142 = cljs.core.ex_info.call(null,"Aborted operations",inst_53141);
var state_53250__$1 = state_53250;
var statearr_53286_53348 = state_53250__$1;
(statearr_53286_53348[(2)] = inst_53142);

(statearr_53286_53348[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (2))){
var inst_53248 = (state_53250[(2)]);
var state_53250__$1 = state_53250;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53250__$1,inst_53248);
} else {
if((state_val_53251 === (23))){
var inst_53146 = (state_53250[(12)]);
var state_53250__$1 = state_53250;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_53250__$1,(25),out_ch__$1,inst_53146);
} else {
if((state_val_53251 === (35))){
var state_53250__$1 = state_53250;
var statearr_53287_53349 = state_53250__$1;
(statearr_53287_53349[(2)] = null);

(statearr_53287_53349[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (19))){
var inst_53124 = (state_53250[(10)]);
var inst_53146 = (state_53250[(12)]);
var inst_53176 = (state_53250[(9)]);
var inst_53176__$1 = cljs.core.conj.call(null,inst_53124,inst_53146);
var inst_53177 = cljs.core.count.call(null,inst_53176__$1);
var inst_53178 = cljs.core._EQ_.call(null,n,inst_53177);
var state_53250__$1 = (function (){var statearr_53288 = state_53250;
(statearr_53288[(9)] = inst_53176__$1);

return statearr_53288;
})();
if(inst_53178){
var statearr_53289_53350 = state_53250__$1;
(statearr_53289_53350[(1)] = (26));

} else {
var statearr_53290_53351 = state_53250__$1;
(statearr_53290_53351[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (11))){
var inst_53129 = (state_53250[(23)]);
var inst_53134 = (state_53250[(2)]);
var inst_53135 = cljs.core.nth.call(null,inst_53134,(0),null);
var inst_53136 = cljs.core.nth.call(null,inst_53134,(1),null);
var inst_53137 = cljs.core._EQ_.call(null,inst_53136,inst_53129);
var state_53250__$1 = (function (){var statearr_53291 = state_53250;
(statearr_53291[(16)] = inst_53135);

return statearr_53291;
})();
if(inst_53137){
var statearr_53292_53352 = state_53250__$1;
(statearr_53292_53352[(1)] = (12));

} else {
var statearr_53293_53353 = state_53250__$1;
(statearr_53293_53353[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (9))){
var inst_53129 = (state_53250[(23)]);
var inst_53129__$1 = superv.async._abort.call(null,S);
var inst_53130 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53131 = [inst_53129__$1,in_ch];
var inst_53132 = (new cljs.core.PersistentVector(null,2,(5),inst_53130,inst_53131,null));
var state_53250__$1 = (function (){var statearr_53294 = state_53250;
(statearr_53294[(23)] = inst_53129__$1);

return statearr_53294;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_53250__$1,(11),inst_53132,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_53251 === (5))){
var state_53250__$1 = state_53250;
var statearr_53295_53354 = state_53250__$1;
(statearr_53295_53354[(2)] = null);

(statearr_53295_53354[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (14))){
var inst_53146 = (state_53250[(12)]);
var inst_53145 = (state_53250[(2)]);
var inst_53146__$1 = superv.async.throw_if_exception.call(null,S,inst_53145);
var state_53250__$1 = (function (){var statearr_53296 = state_53250;
(statearr_53296[(12)] = inst_53146__$1);

return statearr_53296;
})();
if(cljs.core.truth_(inst_53146__$1)){
var statearr_53297_53355 = state_53250__$1;
(statearr_53297_53355[(1)] = (15));

} else {
var statearr_53298_53356 = state_53250__$1;
(statearr_53298_53356[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (26))){
var inst_53183 = (state_53250[(18)]);
var inst_53183__$1 = superv.async._abort.call(null,S);
var inst_53184 = cljs.core.async.timeout.call(null,(0));
var inst_53185 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53186 = [inst_53183__$1,inst_53184];
var inst_53187 = (new cljs.core.PersistentVector(null,2,(5),inst_53185,inst_53186,null));
var state_53250__$1 = (function (){var statearr_53299 = state_53250;
(statearr_53299[(18)] = inst_53183__$1);

return statearr_53299;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_53250__$1,(29),inst_53187,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_53251 === (16))){
var inst_53124 = (state_53250[(10)]);
var inst_53213 = cljs.core.not_empty.call(null,inst_53124);
var state_53250__$1 = state_53250;
if(cljs.core.truth_(inst_53213)){
var statearr_53300_53357 = state_53250__$1;
(statearr_53300_53357[(1)] = (34));

} else {
var statearr_53301_53358 = state_53250__$1;
(statearr_53301_53358[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (38))){
var inst_53229 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_53230 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_53231 = cljs.core.PersistentHashMap.fromArrays(inst_53229,inst_53230);
var inst_53232 = cljs.core.ex_info.call(null,"Aborted operations",inst_53231);
var state_53250__$1 = state_53250;
var statearr_53302_53359 = state_53250__$1;
(statearr_53302_53359[(2)] = inst_53232);

(statearr_53302_53359[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (30))){
var inst_53194 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_53195 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_53196 = cljs.core.PersistentHashMap.fromArrays(inst_53194,inst_53195);
var inst_53197 = cljs.core.ex_info.call(null,"Aborted operations",inst_53196);
var state_53250__$1 = state_53250;
var statearr_53303_53360 = state_53250__$1;
(statearr_53303_53360[(2)] = inst_53197);

(statearr_53303_53360[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (10))){
var inst_53246 = (state_53250[(2)]);
var state_53250__$1 = state_53250;
var statearr_53304_53361 = state_53250__$1;
(statearr_53304_53361[(2)] = inst_53246);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53250__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (18))){
var inst_53153 = (state_53250[(13)]);
var inst_53153__$1 = superv.async._abort.call(null,S);
var inst_53154 = cljs.core.async.timeout.call(null,(0));
var inst_53155 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53156 = [inst_53153__$1,inst_53154];
var inst_53157 = (new cljs.core.PersistentVector(null,2,(5),inst_53155,inst_53156,null));
var state_53250__$1 = (function (){var statearr_53305 = state_53250;
(statearr_53305[(13)] = inst_53153__$1);

return statearr_53305;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_53250__$1,(21),inst_53157,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_53251 === (37))){
var inst_53218 = (state_53250[(20)]);
var inst_53224 = (state_53250[(2)]);
var inst_53225 = cljs.core.nth.call(null,inst_53224,(0),null);
var inst_53226 = cljs.core.nth.call(null,inst_53224,(1),null);
var inst_53227 = cljs.core._EQ_.call(null,inst_53226,inst_53218);
var state_53250__$1 = (function (){var statearr_53306 = state_53250;
(statearr_53306[(24)] = inst_53225);

return statearr_53306;
})();
if(inst_53227){
var statearr_53307_53362 = state_53250__$1;
(statearr_53307_53362[(1)] = (38));

} else {
var statearr_53308_53363 = state_53250__$1;
(statearr_53308_53363[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_53250,(4),Error,(3),(2));
var inst_53123 = cljs.core.PersistentVector.EMPTY;
var inst_53124 = inst_53123;
var state_53250__$1 = (function (){var statearr_53309 = state_53250;
(statearr_53309[(10)] = inst_53124);

return statearr_53309;
})();
var statearr_53310_53364 = state_53250__$1;
(statearr_53310_53364[(2)] = null);

(statearr_53310_53364[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33866__auto___53323,c__21755__auto___53321,id__21756__auto___53322,out_ch__$1,map__53106,map__53106__$1,out_ch))
;
return ((function (switch__33843__auto__,c__33866__auto___53323,c__21755__auto___53321,id__21756__auto___53322,out_ch__$1,map__53106,map__53106__$1,out_ch){
return (function() {
var superv$async$state_machine__33844__auto__ = null;
var superv$async$state_machine__33844__auto____0 = (function (){
var statearr_53314 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_53314[(0)] = superv$async$state_machine__33844__auto__);

(statearr_53314[(1)] = (1));

return statearr_53314;
});
var superv$async$state_machine__33844__auto____1 = (function (state_53250){
while(true){
var ret_value__33845__auto__ = (function (){try{while(true){
var result__33846__auto__ = switch__33843__auto__.call(null,state_53250);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33846__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33846__auto__;
}
break;
}
}catch (e53315){if((e53315 instanceof Object)){
var ex__33847__auto__ = e53315;
var statearr_53316_53365 = state_53250;
(statearr_53316_53365[(5)] = ex__33847__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53250);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e53315;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33845__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53366 = state_53250;
state_53250 = G__53366;
continue;
} else {
return ret_value__33845__auto__;
}
break;
}
});
superv$async$state_machine__33844__auto__ = function(state_53250){
switch(arguments.length){
case 0:
return superv$async$state_machine__33844__auto____0.call(this);
case 1:
return superv$async$state_machine__33844__auto____1.call(this,state_53250);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__33844__auto____0;
superv$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__33844__auto____1;
return superv$async$state_machine__33844__auto__;
})()
;})(switch__33843__auto__,c__33866__auto___53323,c__21755__auto___53321,id__21756__auto___53322,out_ch__$1,map__53106,map__53106__$1,out_ch))
})();
var state__33868__auto__ = (function (){var statearr_53317 = f__33867__auto__.call(null);
(statearr_53317[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33866__auto___53323);

return statearr_53317;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33868__auto__);
});})(c__33866__auto___53323,c__21755__auto___53321,id__21756__auto___53322,out_ch__$1,map__53106,map__53106__$1,out_ch))
);


return out_ch__$1;
});

superv.async.partition_all_GT__GT_.cljs$lang$maxFixedArity = (3);

superv.async.partition_all_GT__GT_.cljs$lang$applyTo = (function (seq53101){
var G__53102 = cljs.core.first.call(null,seq53101);
var seq53101__$1 = cljs.core.next.call(null,seq53101);
var G__53103 = cljs.core.first.call(null,seq53101__$1);
var seq53101__$2 = cljs.core.next.call(null,seq53101__$1);
var G__53104 = cljs.core.first.call(null,seq53101__$2);
var seq53101__$3 = cljs.core.next.call(null,seq53101__$2);
return superv.async.partition_all_GT__GT_.cljs$core$IFn$_invoke$arity$variadic(G__53102,G__53103,G__53104,seq53101__$3);
});

/**
 * Counts items in a channel. Returns a channel with the item count.
 */
superv.async.count_GT_ = (function superv$async$count_GT_(S,ch){
return cljs.core.async.reduce.call(null,(function (acc,obj){
if((obj instanceof Error)){
return superv.async.put_QMARK_.call(null,S,superv.async._error.call(null,S),obj);
} else {
return (acc + (1));
}
}),(0),ch);
});
/**
 * Debounces channel. Forwards first item from input channel to output
 *   immediately. After that one item every interval ms (if any). If there are more
 *   items in between, they are dropped.
 */
superv.async.debounce_GT__GT_ = (function superv$async$debounce_GT__GT_(S,ch,interval){
var out = cljs.core.async.chan.call(null);
var c__21755__auto___53715 = superv.async.check_supervisor.call(null,superv.async.S);
var id__21756__auto___53716 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("clojure.core","loop","clojure.core/loop",-1797836771,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"last-val","last-val",-1727586789,null),null], null),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),cljs.core.list(new cljs.core.Symbol(null,"or","or",1876275696,null),new cljs.core.Symbol(null,"last-val","last-val",-1727586789,null),cljs.core.list(new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))),new cljs.core.Symbol(null,"timer","timer",373563788,null),cljs.core.list(new cljs.core.Symbol("async","timeout","async/timeout",1951904349,null),new cljs.core.Symbol(null,"interval","interval",-945940352,null))], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.Symbol(null,"val","val",1769233139,null)),cljs.core.list(new cljs.core.Symbol("async","close!","async/close!",-546451935,null),new cljs.core.Symbol(null,"out","out",729986010,null)),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"new-val","new-val",902372928,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null),cljs.core.list(new cljs.core.Symbol(null,"alts?","alts?",1625745590,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"timer","timer",373563788,null)], null))], null),cljs.core.list(new cljs.core.Symbol(null,"condp","condp",1054325175,null),new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"timer","timer",373563788,null),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),cljs.core.list(new cljs.core.Symbol(null,">?",">?",-766996309,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"val","val",1769233139,null)),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),cljs.core.list(new cljs.core.Symbol(null,"recur","recur",1202958259,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)))))))));
var c__33866__auto___53717 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33866__auto___53717,c__21755__auto___53715,id__21756__auto___53716,out){
return (function (){
var f__33867__auto__ = (function (){var switch__33843__auto__ = ((function (c__33866__auto___53717,c__21755__auto___53715,id__21756__auto___53716,out){
return (function (state_53661){
var state_val_53662 = (state_53661[(1)]);
if((state_val_53662 === (7))){
var inst_53544 = (state_53661[(7)]);
var inst_53552 = (state_53661[(2)]);
var state_53661__$1 = (function (){var statearr_53663 = state_53661;
(statearr_53663[(8)] = inst_53552);

return statearr_53663;
})();
var statearr_53664_53718 = state_53661__$1;
(statearr_53664_53718[(2)] = inst_53544);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53661__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53662 === (20))){
var inst_53655 = (state_53661[(2)]);
var state_53661__$1 = state_53661;
var statearr_53665_53719 = state_53661__$1;
(statearr_53665_53719[(2)] = inst_53655);

(statearr_53665_53719[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53662 === (27))){
var inst_53582 = (state_53661[(9)]);
var state_53661__$1 = state_53661;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_53661__$1,(29),out,inst_53582);
} else {
if((state_val_53662 === (1))){
var state_53661__$1 = state_53661;
var statearr_53666_53720 = state_53661__$1;
(statearr_53666_53720[(2)] = null);

(statearr_53666_53720[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53662 === (24))){
var inst_53653 = (state_53661[(2)]);
var state_53661__$1 = state_53661;
var statearr_53667_53721 = state_53661__$1;
(statearr_53667_53721[(2)] = inst_53653);

(statearr_53667_53721[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53662 === (4))){
var inst_53544 = (state_53661[(7)]);
var inst_53544__$1 = (state_53661[(2)]);
var inst_53545 = cljs.core.ex_data.call(null,inst_53544__$1);
var inst_53546 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_53545);
var inst_53547 = cljs.core._EQ_.call(null,inst_53546,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_53661__$1 = (function (){var statearr_53668 = state_53661;
(statearr_53668[(7)] = inst_53544__$1);

return statearr_53668;
})();
if(inst_53547){
var statearr_53669_53722 = state_53661__$1;
(statearr_53669_53722[(1)] = (5));

} else {
var statearr_53670_53723 = state_53661__$1;
(statearr_53670_53723[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53662 === (15))){
var inst_53573 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_53574 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_53575 = cljs.core.PersistentHashMap.fromArrays(inst_53573,inst_53574);
var inst_53576 = cljs.core.ex_info.call(null,"Aborted operations",inst_53575);
var state_53661__$1 = state_53661;
var statearr_53671_53724 = state_53661__$1;
(statearr_53671_53724[(2)] = inst_53576);

(statearr_53671_53724[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53662 === (21))){
var inst_53583 = (state_53661[(10)]);
var inst_53611 = (state_53661[(11)]);
var inst_53603 = (state_53661[(2)]);
var inst_53604 = cljs.core.nth.call(null,inst_53603,(0),null);
var inst_53605 = cljs.core.nth.call(null,inst_53603,(1),null);
var inst_53606 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53607 = superv.async.throw_if_exception.call(null,S,inst_53604);
var inst_53608 = [inst_53607,inst_53605];
var inst_53609 = (new cljs.core.PersistentVector(null,2,(5),inst_53606,inst_53608,null));
var inst_53610 = cljs.core.nth.call(null,inst_53609,(0),null);
var inst_53611__$1 = cljs.core.nth.call(null,inst_53609,(1),null);
var inst_53615 = cljs.core._EQ_.call(null,inst_53583,inst_53611__$1);
var state_53661__$1 = (function (){var statearr_53672 = state_53661;
(statearr_53672[(11)] = inst_53611__$1);

(statearr_53672[(12)] = inst_53610);

return statearr_53672;
})();
if(inst_53615){
var statearr_53673_53725 = state_53661__$1;
(statearr_53673_53725[(1)] = (22));

} else {
var statearr_53674_53726 = state_53661__$1;
(statearr_53674_53726[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53662 === (31))){
var inst_53611 = (state_53661[(11)]);
var inst_53647 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_53611)].join('');
var inst_53648 = (new Error(inst_53647));
var inst_53649 = (function(){throw inst_53648})();
var state_53661__$1 = state_53661;
var statearr_53675_53727 = state_53661__$1;
(statearr_53675_53727[(2)] = inst_53649);

(statearr_53675_53727[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53662 === (32))){
var inst_53651 = (state_53661[(2)]);
var state_53661__$1 = state_53661;
var statearr_53676_53728 = state_53661__$1;
(statearr_53676_53728[(2)] = inst_53651);

(statearr_53676_53728[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53662 === (13))){
var inst_53582 = (state_53661[(9)]);
var inst_53582__$1 = (state_53661[(2)]);
var inst_53583 = cljs.core.async.timeout.call(null,interval);
var inst_53584 = (inst_53582__$1 == null);
var state_53661__$1 = (function (){var statearr_53677 = state_53661;
(statearr_53677[(10)] = inst_53583);

(statearr_53677[(9)] = inst_53582__$1);

return statearr_53677;
})();
if(cljs.core.truth_(inst_53584)){
var statearr_53678_53729 = state_53661__$1;
(statearr_53678_53729[(1)] = (18));

} else {
var statearr_53679_53730 = state_53661__$1;
(statearr_53679_53730[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53662 === (22))){
var inst_53620 = (state_53661[(13)]);
var inst_53620__$1 = superv.async._abort.call(null,S);
var inst_53621 = cljs.core.async.timeout.call(null,(0));
var inst_53622 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53623 = [inst_53620__$1,inst_53621];
var inst_53624 = (new cljs.core.PersistentVector(null,2,(5),inst_53622,inst_53623,null));
var state_53661__$1 = (function (){var statearr_53680 = state_53661;
(statearr_53680[(13)] = inst_53620__$1);

return statearr_53680;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_53661__$1,(25),inst_53624,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_53662 === (29))){
var inst_53637 = (state_53661[(2)]);
var state_53661__$1 = state_53661;
var statearr_53681_53731 = state_53661__$1;
(statearr_53681_53731[(2)] = inst_53637);

(statearr_53681_53731[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53662 === (6))){
var inst_53544 = (state_53661[(7)]);
var inst_53550 = superv.async._track_exception.call(null,S,inst_53544);
var state_53661__$1 = state_53661;
var statearr_53682_53732 = state_53661__$1;
(statearr_53682_53732[(2)] = inst_53550);

(statearr_53682_53732[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53662 === (28))){
var inst_53639 = (state_53661[(2)]);
var inst_53640 = superv.async.throw_if_exception.call(null,S,inst_53639);
var inst_53556 = null;
var state_53661__$1 = (function (){var statearr_53683 = state_53661;
(statearr_53683[(14)] = inst_53640);

(statearr_53683[(15)] = inst_53556);

return statearr_53683;
})();
var statearr_53684_53733 = state_53661__$1;
(statearr_53684_53733[(2)] = null);

(statearr_53684_53733[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53662 === (25))){
var inst_53620 = (state_53661[(13)]);
var inst_53626 = (state_53661[(2)]);
var inst_53627 = cljs.core.nth.call(null,inst_53626,(0),null);
var inst_53628 = cljs.core.nth.call(null,inst_53626,(1),null);
var inst_53629 = cljs.core._EQ_.call(null,inst_53628,inst_53620);
var state_53661__$1 = (function (){var statearr_53685 = state_53661;
(statearr_53685[(16)] = inst_53627);

return statearr_53685;
})();
if(inst_53629){
var statearr_53686_53734 = state_53661__$1;
(statearr_53686_53734[(1)] = (26));

} else {
var statearr_53687_53735 = state_53661__$1;
(statearr_53687_53735[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53662 === (17))){
var inst_53579 = (state_53661[(2)]);
var inst_53580 = superv.async.throw_if_exception.call(null,S,inst_53579);
var state_53661__$1 = state_53661;
var statearr_53688_53736 = state_53661__$1;
(statearr_53688_53736[(2)] = inst_53580);

(statearr_53688_53736[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53662 === (3))){
var inst_53541 = (state_53661[(2)]);
var inst_53542 = superv.async._unregister_go.call(null,S,id__21756__auto___53716);
var state_53661__$1 = (function (){var statearr_53689 = state_53661;
(statearr_53689[(17)] = inst_53541);

(statearr_53689[(18)] = inst_53542);

return statearr_53689;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53661__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53662 === (12))){
var inst_53563 = (state_53661[(19)]);
var inst_53563__$1 = superv.async._abort.call(null,S);
var inst_53564 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53565 = [inst_53563__$1,ch];
var inst_53566 = (new cljs.core.PersistentVector(null,2,(5),inst_53564,inst_53565,null));
var state_53661__$1 = (function (){var statearr_53690 = state_53661;
(statearr_53690[(19)] = inst_53563__$1);

return statearr_53690;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_53661__$1,(14),inst_53566,new cljs.core.Keyword(null,"priority","priority",1431093715),new cljs.core.Keyword(null,"true","true",-1114210334));
} else {
if((state_val_53662 === (2))){
var inst_53659 = (state_53661[(2)]);
var state_53661__$1 = state_53661;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53661__$1,inst_53659);
} else {
if((state_val_53662 === (23))){
var inst_53611 = (state_53661[(11)]);
var inst_53643 = cljs.core._EQ_.call(null,inst_53611,inst_53611);
var state_53661__$1 = state_53661;
if(inst_53643){
var statearr_53691_53737 = state_53661__$1;
(statearr_53691_53737[(1)] = (30));

} else {
var statearr_53692_53738 = state_53661__$1;
(statearr_53692_53738[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53662 === (19))){
var inst_53583 = (state_53661[(10)]);
var inst_53594 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53595 = superv.async._abort.call(null,S);
var inst_53596 = [inst_53595];
var inst_53597 = (new cljs.core.PersistentVector(null,1,(5),inst_53594,inst_53596,null));
var inst_53598 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53599 = [ch,inst_53583];
var inst_53600 = (new cljs.core.PersistentVector(null,2,(5),inst_53598,inst_53599,null));
var inst_53601 = cljs.core.concat.call(null,inst_53597,inst_53600);
var state_53661__$1 = state_53661;
return cljs.core.async.ioc_alts_BANG_.call(null,state_53661__$1,(21),inst_53601);
} else {
if((state_val_53662 === (11))){
var inst_53556 = (state_53661[(15)]);
var state_53661__$1 = state_53661;
var statearr_53693_53739 = state_53661__$1;
(statearr_53693_53739[(2)] = inst_53556);

(statearr_53693_53739[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53662 === (9))){
var inst_53556 = (state_53661[(15)]);
var state_53661__$1 = state_53661;
if(cljs.core.truth_(inst_53556)){
var statearr_53694_53740 = state_53661__$1;
(statearr_53694_53740[(1)] = (11));

} else {
var statearr_53695_53741 = state_53661__$1;
(statearr_53695_53741[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53662 === (5))){
var state_53661__$1 = state_53661;
var statearr_53696_53742 = state_53661__$1;
(statearr_53696_53742[(2)] = null);

(statearr_53696_53742[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53662 === (14))){
var inst_53563 = (state_53661[(19)]);
var inst_53568 = (state_53661[(2)]);
var inst_53569 = cljs.core.nth.call(null,inst_53568,(0),null);
var inst_53570 = cljs.core.nth.call(null,inst_53568,(1),null);
var inst_53571 = cljs.core._EQ_.call(null,inst_53570,inst_53563);
var state_53661__$1 = (function (){var statearr_53697 = state_53661;
(statearr_53697[(20)] = inst_53569);

return statearr_53697;
})();
if(inst_53571){
var statearr_53698_53743 = state_53661__$1;
(statearr_53698_53743[(1)] = (15));

} else {
var statearr_53699_53744 = state_53661__$1;
(statearr_53699_53744[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53662 === (26))){
var inst_53631 = [new cljs.core.Keyword(null,"type","type",1174270348)];
var inst_53632 = [new cljs.core.Keyword(null,"aborted","aborted",1775972619)];
var inst_53633 = cljs.core.PersistentHashMap.fromArrays(inst_53631,inst_53632);
var inst_53634 = cljs.core.ex_info.call(null,"Aborted operations",inst_53633);
var state_53661__$1 = state_53661;
var statearr_53700_53745 = state_53661__$1;
(statearr_53700_53745[(2)] = inst_53634);

(statearr_53700_53745[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53662 === (16))){
var inst_53569 = (state_53661[(20)]);
var state_53661__$1 = state_53661;
var statearr_53701_53746 = state_53661__$1;
(statearr_53701_53746[(2)] = inst_53569);

(statearr_53701_53746[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53662 === (30))){
var inst_53610 = (state_53661[(12)]);
var inst_53556 = inst_53610;
var state_53661__$1 = (function (){var statearr_53702 = state_53661;
(statearr_53702[(15)] = inst_53556);

return statearr_53702;
})();
var statearr_53703_53747 = state_53661__$1;
(statearr_53703_53747[(2)] = null);

(statearr_53703_53747[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53662 === (10))){
var inst_53657 = (state_53661[(2)]);
var state_53661__$1 = state_53661;
var statearr_53704_53748 = state_53661__$1;
(statearr_53704_53748[(2)] = inst_53657);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53661__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53662 === (18))){
var inst_53586 = cljs.core.async.close_BANG_.call(null,out);
var state_53661__$1 = state_53661;
var statearr_53705_53749 = state_53661__$1;
(statearr_53705_53749[(2)] = inst_53586);

(statearr_53705_53749[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53662 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_53661,(4),Error,(3),(2));
var inst_53556 = null;
var state_53661__$1 = (function (){var statearr_53706 = state_53661;
(statearr_53706[(15)] = inst_53556);

return statearr_53706;
})();
var statearr_53707_53750 = state_53661__$1;
(statearr_53707_53750[(2)] = null);

(statearr_53707_53750[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33866__auto___53717,c__21755__auto___53715,id__21756__auto___53716,out))
;
return ((function (switch__33843__auto__,c__33866__auto___53717,c__21755__auto___53715,id__21756__auto___53716,out){
return (function() {
var superv$async$debounce_GT__GT__$_state_machine__33844__auto__ = null;
var superv$async$debounce_GT__GT__$_state_machine__33844__auto____0 = (function (){
var statearr_53711 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_53711[(0)] = superv$async$debounce_GT__GT__$_state_machine__33844__auto__);

(statearr_53711[(1)] = (1));

return statearr_53711;
});
var superv$async$debounce_GT__GT__$_state_machine__33844__auto____1 = (function (state_53661){
while(true){
var ret_value__33845__auto__ = (function (){try{while(true){
var result__33846__auto__ = switch__33843__auto__.call(null,state_53661);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33846__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33846__auto__;
}
break;
}
}catch (e53712){if((e53712 instanceof Object)){
var ex__33847__auto__ = e53712;
var statearr_53713_53751 = state_53661;
(statearr_53713_53751[(5)] = ex__33847__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53661);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e53712;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33845__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53752 = state_53661;
state_53661 = G__53752;
continue;
} else {
return ret_value__33845__auto__;
}
break;
}
});
superv$async$debounce_GT__GT__$_state_machine__33844__auto__ = function(state_53661){
switch(arguments.length){
case 0:
return superv$async$debounce_GT__GT__$_state_machine__33844__auto____0.call(this);
case 1:
return superv$async$debounce_GT__GT__$_state_machine__33844__auto____1.call(this,state_53661);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$debounce_GT__GT__$_state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$debounce_GT__GT__$_state_machine__33844__auto____0;
superv$async$debounce_GT__GT__$_state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$debounce_GT__GT__$_state_machine__33844__auto____1;
return superv$async$debounce_GT__GT__$_state_machine__33844__auto__;
})()
;})(switch__33843__auto__,c__33866__auto___53717,c__21755__auto___53715,id__21756__auto___53716,out))
})();
var state__33868__auto__ = (function (){var statearr_53714 = f__33867__auto__.call(null);
(statearr_53714[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33866__auto___53717);

return statearr_53714;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33868__auto__);
});})(c__33866__auto___53717,c__21755__auto___53715,id__21756__auto___53716,out))
);


return out;
});
/**
 * Safely managed tap. The channel is closed on abortion and all
 *   pending puts are flushed.
 */
superv.async.tap = (function superv$async$tap(var_args){
var args53753 = [];
var len__10375__auto___53891 = arguments.length;
var i__10376__auto___53892 = (0);
while(true){
if((i__10376__auto___53892 < len__10375__auto___53891)){
args53753.push((arguments[i__10376__auto___53892]));

var G__53893 = (i__10376__auto___53892 + (1));
i__10376__auto___53892 = G__53893;
continue;
} else {
}
break;
}

var G__53755 = args53753.length;
switch (G__53755) {
case 3:
return superv.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return superv.async.tap.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args53753.length)].join('')));

}
});

superv.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (S,mult,ch){
return superv.async.tap.call(null,S,mult,ch,false);
});

superv.async.tap.cljs$core$IFn$_invoke$arity$4 = (function (S,mult,ch,close_QMARK_){
var c__21755__auto___53895 = superv.async.check_supervisor.call(null,superv.async.S);
var id__21756__auto___53896 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("cljs.core.async","<!","cljs.core.async/<!",1278951036,null),cljs.core.list(new cljs.core.Symbol("superv.async","-abort","superv.async/-abort",-365058004,null),new cljs.core.Symbol(null,"S","S",-1387142461,null))),cljs.core.list(new cljs.core.Symbol(null,"close!","close!",-438778971,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)),cljs.core.list(new cljs.core.Symbol(null,"go-try","go-try",1412345407,null),cljs.core.list(new cljs.core.Symbol(null,"while","while",-1691317983,null),cljs.core.list(new cljs.core.Symbol(null,"<!","<!",-1961915773,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))))));
var c__33866__auto___53897 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33866__auto___53897,c__21755__auto___53895,id__21756__auto___53896){
return (function (){
var f__33867__auto__ = (function (){var switch__33843__auto__ = ((function (c__33866__auto___53897,c__21755__auto___53895,id__21756__auto___53896){
return (function (state_53834){
var state_val_53835 = (state_53834[(1)]);
if((state_val_53835 === (7))){
var inst_53759 = (state_53834[(7)]);
var inst_53767 = (state_53834[(2)]);
var state_53834__$1 = (function (){var statearr_53836 = state_53834;
(statearr_53836[(8)] = inst_53767);

return statearr_53836;
})();
var statearr_53837_53898 = state_53834__$1;
(statearr_53837_53898[(2)] = inst_53759);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53834__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53835 === (1))){
var state_53834__$1 = state_53834;
var statearr_53838_53899 = state_53834__$1;
(statearr_53838_53899[(2)] = null);

(statearr_53838_53899[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53835 === (4))){
var inst_53759 = (state_53834[(7)]);
var inst_53759__$1 = (state_53834[(2)]);
var inst_53760 = cljs.core.ex_data.call(null,inst_53759__$1);
var inst_53761 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_53760);
var inst_53762 = cljs.core._EQ_.call(null,inst_53761,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_53834__$1 = (function (){var statearr_53839 = state_53834;
(statearr_53839[(7)] = inst_53759__$1);

return statearr_53839;
})();
if(inst_53762){
var statearr_53840_53900 = state_53834__$1;
(statearr_53840_53900[(1)] = (5));

} else {
var statearr_53841_53901 = state_53834__$1;
(statearr_53841_53901[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53835 === (15))){
var inst_53783 = (state_53834[(2)]);
var state_53834__$1 = state_53834;
var statearr_53842_53902 = state_53834__$1;
(statearr_53842_53902[(2)] = inst_53783);

(statearr_53842_53902[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53835 === (13))){
var state_53834__$1 = state_53834;
var statearr_53843_53903 = state_53834__$1;
(statearr_53843_53903[(2)] = null);

(statearr_53843_53903[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53835 === (6))){
var inst_53759 = (state_53834[(7)]);
var inst_53765 = superv.async._track_exception.call(null,S,inst_53759);
var state_53834__$1 = state_53834;
var statearr_53844_53904 = state_53834__$1;
(statearr_53844_53904[(2)] = inst_53765);

(statearr_53844_53904[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53835 === (3))){
var inst_53756 = (state_53834[(2)]);
var inst_53757 = superv.async._unregister_go.call(null,S,id__21756__auto___53896);
var state_53834__$1 = (function (){var statearr_53845 = state_53834;
(statearr_53845[(9)] = inst_53757);

(statearr_53845[(10)] = inst_53756);

return statearr_53845;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53834__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53835 === (12))){
var inst_53778 = (state_53834[(2)]);
var state_53834__$1 = state_53834;
if(cljs.core.truth_(inst_53778)){
var statearr_53846_53905 = state_53834__$1;
(statearr_53846_53905[(1)] = (13));

} else {
var statearr_53847_53906 = state_53834__$1;
(statearr_53847_53906[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53835 === (2))){
var inst_53832 = (state_53834[(2)]);
var state_53834__$1 = state_53834;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53834__$1,inst_53832);
} else {
if((state_val_53835 === (11))){
var inst_53775 = (state_53834[(11)]);
var inst_53785 = (state_53834[(2)]);
var inst_53786 = null;
var inst_53787 = superv.async._register_go.call(null,inst_53785,inst_53786);
var inst_53828 = cljs.core.async.chan.call(null,(1));
var inst_53829 = (function (){var c__21755__auto____$1 = inst_53775;
var id__21756__auto____$1 = inst_53787;
var c__33866__auto____$1 = inst_53828;
return ((function (c__21755__auto____$1,id__21756__auto____$1,c__33866__auto____$1,inst_53775,inst_53785,inst_53786,inst_53787,inst_53828,state_val_53835,c__33866__auto___53897,c__21755__auto___53895,id__21756__auto___53896){
return (function (){
var f__33867__auto__ = (function (){var switch__33843__auto__ = ((function (c__21755__auto____$1,id__21756__auto____$1,c__33866__auto____$1,inst_53775,inst_53785,inst_53786,inst_53787,inst_53828,state_val_53835,c__33866__auto___53897,c__21755__auto___53895,id__21756__auto___53896){
return (function (state_53826){
var state_val_53827 = (state_53826[(1)]);
if((state_val_53827 === (7))){
var state_53826__$1 = state_53826;
var statearr_53848_53907 = state_53826__$1;
(statearr_53848_53907[(2)] = null);

(statearr_53848_53907[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53827 === (20))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_53826,(10),Error,(3),(2));
var state_53826__$1 = state_53826;
var statearr_53849_53908 = state_53826__$1;
(statearr_53849_53908[(2)] = null);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53826__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53827 === (1))){
var state_53826__$1 = state_53826;
var statearr_53850_53909 = state_53826__$1;
(statearr_53850_53909[(2)] = null);

(statearr_53850_53909[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53827 === (4))){
var state_53826__$1 = state_53826;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53826__$1,(6),ch);
} else {
if((state_val_53827 === (15))){
var inst_53801 = (state_53826[(7)]);
var inst_53816 = (state_53826[(2)]);
var inst_53817 = superv.async._track_exception.call(null,inst_53816,inst_53801);
var state_53826__$1 = state_53826;
var statearr_53851_53910 = state_53826__$1;
(statearr_53851_53910[(2)] = inst_53817);

(statearr_53851_53910[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53827 === (13))){
var inst_53801 = (state_53826[(7)]);
var inst_53819 = (state_53826[(2)]);
var state_53826__$1 = (function (){var statearr_53852 = state_53826;
(statearr_53852[(8)] = inst_53819);

return statearr_53852;
})();
var statearr_53853_53911 = state_53826__$1;
(statearr_53853_53911[(2)] = inst_53801);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53826__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53827 === (6))){
var inst_53791 = (state_53826[(2)]);
var state_53826__$1 = state_53826;
if(cljs.core.truth_(inst_53791)){
var statearr_53854_53912 = state_53826__$1;
(statearr_53854_53912[(1)] = (7));

} else {
var statearr_53855_53913 = state_53826__$1;
(statearr_53855_53913[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53827 === (17))){
var state_53826__$1 = state_53826;
var statearr_53856_53914 = state_53826__$1;
(statearr_53856_53914[(2)] = null);

(statearr_53856_53914[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53827 === (3))){
var inst_53788 = (state_53826[(2)]);
var state_53826__$1 = (function (){var statearr_53857 = state_53826;
(statearr_53857[(9)] = inst_53788);

return statearr_53857;
})();
var statearr_53858_53915 = state_53826__$1;
(statearr_53858_53915[(2)] = null);

(statearr_53858_53915[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53827 === (12))){
var state_53826__$1 = state_53826;
var statearr_53859_53916 = state_53826__$1;
(statearr_53859_53916[(2)] = null);

(statearr_53859_53916[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53827 === (2))){
var inst_53824 = (state_53826[(2)]);
var state_53826__$1 = state_53826;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53826__$1,inst_53824);
} else {
if((state_val_53827 === (19))){
var inst_53814 = (state_53826[(2)]);
var state_53826__$1 = state_53826;
var statearr_53860_53917 = state_53826__$1;
(statearr_53860_53917[(2)] = inst_53814);

(statearr_53860_53917[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53827 === (11))){
var state_53826__$1 = state_53826;
var statearr_53861_53918 = state_53826__$1;
(statearr_53861_53918[(2)] = null);

(statearr_53861_53918[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53827 === (9))){
var inst_53796 = (state_53826[(2)]);
var state_53826__$1 = state_53826;
var statearr_53862_53919 = state_53826__$1;
(statearr_53862_53919[(2)] = inst_53796);

(statearr_53862_53919[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53827 === (5))){
var inst_53798 = (state_53826[(2)]);
var inst_53799 = superv.async._unregister_go.call(null,inst_53798,id__21756__auto____$1);
var state_53826__$1 = (function (){var statearr_53863 = state_53826;
(statearr_53863[(10)] = inst_53799);

return statearr_53863;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53826__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53827 === (14))){
var state_53826__$1 = state_53826;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53826__$1,(16),ch);
} else {
if((state_val_53827 === (16))){
var inst_53809 = (state_53826[(2)]);
var state_53826__$1 = state_53826;
if(cljs.core.truth_(inst_53809)){
var statearr_53864_53920 = state_53826__$1;
(statearr_53864_53920[(1)] = (17));

} else {
var statearr_53865_53921 = state_53826__$1;
(statearr_53865_53921[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53827 === (10))){
var inst_53801 = (state_53826[(7)]);
var inst_53801__$1 = (state_53826[(2)]);
var inst_53802 = cljs.core.ex_data.call(null,inst_53801__$1);
var inst_53803 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_53802);
var inst_53804 = cljs.core._EQ_.call(null,inst_53803,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_53826__$1 = (function (){var statearr_53866 = state_53826;
(statearr_53866[(7)] = inst_53801__$1);

return statearr_53866;
})();
if(inst_53804){
var statearr_53867_53922 = state_53826__$1;
(statearr_53867_53922[(1)] = (11));

} else {
var statearr_53868_53923 = state_53826__$1;
(statearr_53868_53923[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53827 === (18))){
var state_53826__$1 = state_53826;
var statearr_53869_53924 = state_53826__$1;
(statearr_53869_53924[(2)] = null);

(statearr_53869_53924[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53827 === (8))){
var state_53826__$1 = state_53826;
var statearr_53870_53925 = state_53826__$1;
(statearr_53870_53925[(2)] = null);

(statearr_53870_53925[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__21755__auto____$1,id__21756__auto____$1,c__33866__auto____$1,inst_53775,inst_53785,inst_53786,inst_53787,inst_53828,state_val_53835,c__33866__auto___53897,c__21755__auto___53895,id__21756__auto___53896))
;
return ((function (switch__33843__auto__,c__21755__auto____$1,id__21756__auto____$1,c__33866__auto____$1,inst_53775,inst_53785,inst_53786,inst_53787,inst_53828,state_val_53835,c__33866__auto___53897,c__21755__auto___53895,id__21756__auto___53896){
return (function() {
var superv$async$state_machine__33844__auto__ = null;
var superv$async$state_machine__33844__auto____0 = (function (){
var statearr_53874 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_53874[(0)] = superv$async$state_machine__33844__auto__);

(statearr_53874[(1)] = (1));

return statearr_53874;
});
var superv$async$state_machine__33844__auto____1 = (function (state_53826){
while(true){
var ret_value__33845__auto__ = (function (){try{while(true){
var result__33846__auto__ = switch__33843__auto__.call(null,state_53826);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33846__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33846__auto__;
}
break;
}
}catch (e53875){if((e53875 instanceof Object)){
var ex__33847__auto__ = e53875;
var statearr_53876_53926 = state_53826;
(statearr_53876_53926[(5)] = ex__33847__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53826);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e53875;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33845__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53927 = state_53826;
state_53826 = G__53927;
continue;
} else {
return ret_value__33845__auto__;
}
break;
}
});
superv$async$state_machine__33844__auto__ = function(state_53826){
switch(arguments.length){
case 0:
return superv$async$state_machine__33844__auto____0.call(this);
case 1:
return superv$async$state_machine__33844__auto____1.call(this,state_53826);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__33844__auto____0;
superv$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__33844__auto____1;
return superv$async$state_machine__33844__auto__;
})()
;})(switch__33843__auto__,c__21755__auto____$1,id__21756__auto____$1,c__33866__auto____$1,inst_53775,inst_53785,inst_53786,inst_53787,inst_53828,state_val_53835,c__33866__auto___53897,c__21755__auto___53895,id__21756__auto___53896))
})();
var state__33868__auto__ = (function (){var statearr_53877 = f__33867__auto__.call(null);
(statearr_53877[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33866__auto____$1);

return statearr_53877;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33868__auto__);
});
;})(c__21755__auto____$1,id__21756__auto____$1,c__33866__auto____$1,inst_53775,inst_53785,inst_53786,inst_53787,inst_53828,state_val_53835,c__33866__auto___53897,c__21755__auto___53895,id__21756__auto___53896))
})();
var inst_53830 = cljs.core.async.impl.dispatch.run.call(null,inst_53829);
var state_53834__$1 = (function (){var statearr_53878 = state_53834;
(statearr_53878[(12)] = inst_53830);

return statearr_53878;
})();
var statearr_53879_53928 = state_53834__$1;
(statearr_53879_53928[(2)] = inst_53828);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53834__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53835 === (9))){
var inst_53773 = (state_53834[(2)]);
var inst_53774 = cljs.core.async.close_BANG_.call(null,ch);
var inst_53775 = superv.async.check_supervisor.call(null,superv.async.S);
var state_53834__$1 = (function (){var statearr_53880 = state_53834;
(statearr_53880[(11)] = inst_53775);

(statearr_53880[(13)] = inst_53774);

(statearr_53880[(14)] = inst_53773);

return statearr_53880;
})();
var statearr_53881_53929 = state_53834__$1;
(statearr_53881_53929[(2)] = null);

(statearr_53881_53929[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53835 === (5))){
var state_53834__$1 = state_53834;
var statearr_53882_53930 = state_53834__$1;
(statearr_53882_53930[(2)] = null);

(statearr_53882_53930[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53835 === (14))){
var state_53834__$1 = state_53834;
var statearr_53883_53931 = state_53834__$1;
(statearr_53883_53931[(2)] = null);

(statearr_53883_53931[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53835 === (10))){
var state_53834__$1 = state_53834;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53834__$1,(12),ch);
} else {
if((state_val_53835 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_53834,(4),Error,(3),(2));
var inst_53771 = superv.async._abort.call(null,S);
var state_53834__$1 = state_53834;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53834__$1,(9),inst_53771);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33866__auto___53897,c__21755__auto___53895,id__21756__auto___53896))
;
return ((function (switch__33843__auto__,c__33866__auto___53897,c__21755__auto___53895,id__21756__auto___53896){
return (function() {
var superv$async$state_machine__33844__auto__ = null;
var superv$async$state_machine__33844__auto____0 = (function (){
var statearr_53887 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_53887[(0)] = superv$async$state_machine__33844__auto__);

(statearr_53887[(1)] = (1));

return statearr_53887;
});
var superv$async$state_machine__33844__auto____1 = (function (state_53834){
while(true){
var ret_value__33845__auto__ = (function (){try{while(true){
var result__33846__auto__ = switch__33843__auto__.call(null,state_53834);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33846__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33846__auto__;
}
break;
}
}catch (e53888){if((e53888 instanceof Object)){
var ex__33847__auto__ = e53888;
var statearr_53889_53932 = state_53834;
(statearr_53889_53932[(5)] = ex__33847__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53834);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e53888;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33845__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53933 = state_53834;
state_53834 = G__53933;
continue;
} else {
return ret_value__33845__auto__;
}
break;
}
});
superv$async$state_machine__33844__auto__ = function(state_53834){
switch(arguments.length){
case 0:
return superv$async$state_machine__33844__auto____0.call(this);
case 1:
return superv$async$state_machine__33844__auto____1.call(this,state_53834);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__33844__auto____0;
superv$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__33844__auto____1;
return superv$async$state_machine__33844__auto__;
})()
;})(switch__33843__auto__,c__33866__auto___53897,c__21755__auto___53895,id__21756__auto___53896))
})();
var state__33868__auto__ = (function (){var statearr_53890 = f__33867__auto__.call(null);
(statearr_53890[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33866__auto___53897);

return statearr_53890;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33868__auto__);
});})(c__33866__auto___53897,c__21755__auto___53895,id__21756__auto___53896))
);


return cljs.core.async.tap.call(null,mult,ch,close_QMARK_);
});

superv.async.tap.cljs$lang$maxFixedArity = 4;

/**
 * Safely managed subscription. The channel is closed on abortion and
 *   all pending puts are flushed.
 */
superv.async.sub = (function superv$async$sub(var_args){
var args53934 = [];
var len__10375__auto___54038 = arguments.length;
var i__10376__auto___54039 = (0);
while(true){
if((i__10376__auto___54039 < len__10375__auto___54038)){
args53934.push((arguments[i__10376__auto___54039]));

var G__54040 = (i__10376__auto___54039 + (1));
i__10376__auto___54039 = G__54040;
continue;
} else {
}
break;
}

var G__53936 = args53934.length;
switch (G__53936) {
case 4:
return superv.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return superv.async.sub.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args53934.length)].join('')));

}
});

superv.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (S,p,topic,ch){
return superv.async.sub.call(null,S,p,topic,ch,false);
});

superv.async.sub.cljs$core$IFn$_invoke$arity$5 = (function (S,p,topic,ch,close_QMARK_){
var c__21755__auto___54042 = superv.async.check_supervisor.call(null,superv.async.S);
var id__21756__auto___54043 = superv.async._register_go.call(null,S,cljs.core.list(cljs.core.list(new cljs.core.Symbol("cljs.core.async","<!","cljs.core.async/<!",1278951036,null),cljs.core.list(new cljs.core.Symbol("superv.async","-abort","superv.async/-abort",-365058004,null),new cljs.core.Symbol(null,"S","S",-1387142461,null))),cljs.core.list(new cljs.core.Symbol(null,"close!","close!",-438778971,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)),cljs.core.list(new cljs.core.Symbol(null,"go-try","go-try",1412345407,null),new cljs.core.Symbol(null,"S","S",-1387142461,null),cljs.core.list(new cljs.core.Symbol(null,"while","while",-1691317983,null),cljs.core.list(new cljs.core.Symbol(null,"<!","<!",-1961915773,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))))));
var c__33866__auto___54044 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33866__auto___54044,c__21755__auto___54042,id__21756__auto___54043){
return (function (){
var f__33867__auto__ = (function (){var switch__33843__auto__ = ((function (c__33866__auto___54044,c__21755__auto___54042,id__21756__auto___54043){
return (function (state_53995){
var state_val_53996 = (state_53995[(1)]);
if((state_val_53996 === (1))){
var state_53995__$1 = state_53995;
var statearr_53997_54045 = state_53995__$1;
(statearr_53997_54045[(2)] = null);

(statearr_53997_54045[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53996 === (2))){
var inst_53993 = (state_53995[(2)]);
var state_53995__$1 = state_53995;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53995__$1,inst_53993);
} else {
if((state_val_53996 === (3))){
var inst_53937 = (state_53995[(2)]);
var inst_53938 = superv.async._unregister_go.call(null,S,id__21756__auto___54043);
var state_53995__$1 = (function (){var statearr_53998 = state_53995;
(statearr_53998[(7)] = inst_53937);

(statearr_53998[(8)] = inst_53938);

return statearr_53998;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53995__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53996 === (4))){
var inst_53940 = (state_53995[(9)]);
var inst_53940__$1 = (state_53995[(2)]);
var inst_53941 = cljs.core.ex_data.call(null,inst_53940__$1);
var inst_53942 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_53941);
var inst_53943 = cljs.core._EQ_.call(null,inst_53942,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_53995__$1 = (function (){var statearr_53999 = state_53995;
(statearr_53999[(9)] = inst_53940__$1);

return statearr_53999;
})();
if(inst_53943){
var statearr_54000_54046 = state_53995__$1;
(statearr_54000_54046[(1)] = (5));

} else {
var statearr_54001_54047 = state_53995__$1;
(statearr_54001_54047[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53996 === (5))){
var state_53995__$1 = state_53995;
var statearr_54002_54048 = state_53995__$1;
(statearr_54002_54048[(2)] = null);

(statearr_54002_54048[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53996 === (6))){
var inst_53940 = (state_53995[(9)]);
var inst_53946 = superv.async._track_exception.call(null,S,inst_53940);
var state_53995__$1 = state_53995;
var statearr_54003_54049 = state_53995__$1;
(statearr_54003_54049[(2)] = inst_53946);

(statearr_54003_54049[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53996 === (7))){
var inst_53940 = (state_53995[(9)]);
var inst_53948 = (state_53995[(2)]);
var state_53995__$1 = (function (){var statearr_54004 = state_53995;
(statearr_54004[(10)] = inst_53948);

return statearr_54004;
})();
var statearr_54005_54050 = state_53995__$1;
(statearr_54005_54050[(2)] = inst_53940);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53995__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53996 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_53995,(4),Error,(3),(2));
var inst_53952 = superv.async._abort.call(null,S);
var state_53995__$1 = state_53995;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53995__$1,(9),inst_53952);
} else {
if((state_val_53996 === (9))){
var inst_53954 = (state_53995[(2)]);
var inst_53955 = cljs.core.async.close_BANG_.call(null,ch);
var inst_53956 = superv.async.check_supervisor.call(null,superv.async.S);
var inst_53957 = cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"while","while",-1691317983,null),cljs.core.list(new cljs.core.Symbol(null,"<!","<!",-1961915773,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null))));
var inst_53958 = superv.async._register_go.call(null,S,inst_53957);
var inst_53989 = cljs.core.async.chan.call(null,(1));
var inst_53990 = (function (){var c__21755__auto____$1 = inst_53956;
var id__21756__auto____$1 = inst_53958;
var c__33866__auto____$1 = inst_53989;
return ((function (c__21755__auto____$1,id__21756__auto____$1,c__33866__auto____$1,inst_53954,inst_53955,inst_53956,inst_53957,inst_53958,inst_53989,state_val_53996,c__33866__auto___54044,c__21755__auto___54042,id__21756__auto___54043){
return (function (){
var f__33867__auto__ = (function (){var switch__33843__auto__ = ((function (c__21755__auto____$1,id__21756__auto____$1,c__33866__auto____$1,inst_53954,inst_53955,inst_53956,inst_53957,inst_53958,inst_53989,state_val_53996,c__33866__auto___54044,c__21755__auto___54042,id__21756__auto___54043){
return (function (state_53987){
var state_val_53988 = (state_53987[(1)]);
if((state_val_53988 === (7))){
var inst_53962 = (state_53987[(7)]);
var inst_53970 = (state_53987[(2)]);
var state_53987__$1 = (function (){var statearr_54006 = state_53987;
(statearr_54006[(8)] = inst_53970);

return statearr_54006;
})();
var statearr_54007_54051 = state_53987__$1;
(statearr_54007_54051[(2)] = inst_53962);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53987__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53988 === (1))){
var state_53987__$1 = state_53987;
var statearr_54008_54052 = state_53987__$1;
(statearr_54008_54052[(2)] = null);

(statearr_54008_54052[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53988 === (4))){
var inst_53962 = (state_53987[(7)]);
var inst_53962__$1 = (state_53987[(2)]);
var inst_53963 = cljs.core.ex_data.call(null,inst_53962__$1);
var inst_53964 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_53963);
var inst_53965 = cljs.core._EQ_.call(null,inst_53964,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_53987__$1 = (function (){var statearr_54009 = state_53987;
(statearr_54009[(7)] = inst_53962__$1);

return statearr_54009;
})();
if(inst_53965){
var statearr_54010_54053 = state_53987__$1;
(statearr_54010_54053[(1)] = (5));

} else {
var statearr_54011_54054 = state_53987__$1;
(statearr_54011_54054[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53988 === (13))){
var state_53987__$1 = state_53987;
var statearr_54012_54055 = state_53987__$1;
(statearr_54012_54055[(2)] = null);

(statearr_54012_54055[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53988 === (6))){
var inst_53962 = (state_53987[(7)]);
var inst_53968 = superv.async._track_exception.call(null,S,inst_53962);
var state_53987__$1 = state_53987;
var statearr_54013_54056 = state_53987__$1;
(statearr_54013_54056[(2)] = inst_53968);

(statearr_54013_54056[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53988 === (3))){
var inst_53959 = (state_53987[(2)]);
var inst_53960 = superv.async._unregister_go.call(null,S,id__21756__auto____$1);
var state_53987__$1 = (function (){var statearr_54014 = state_53987;
(statearr_54014[(9)] = inst_53959);

(statearr_54014[(10)] = inst_53960);

return statearr_54014;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53987__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53988 === (12))){
var state_53987__$1 = state_53987;
var statearr_54015_54057 = state_53987__$1;
(statearr_54015_54057[(2)] = null);

(statearr_54015_54057[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53988 === (2))){
var inst_53985 = (state_53987[(2)]);
var state_53987__$1 = state_53987;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53987__$1,inst_53985);
} else {
if((state_val_53988 === (11))){
var inst_53976 = (state_53987[(2)]);
var state_53987__$1 = state_53987;
if(cljs.core.truth_(inst_53976)){
var statearr_54016_54058 = state_53987__$1;
(statearr_54016_54058[(1)] = (12));

} else {
var statearr_54017_54059 = state_53987__$1;
(statearr_54017_54059[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53988 === (9))){
var state_53987__$1 = state_53987;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53987__$1,(11),ch);
} else {
if((state_val_53988 === (5))){
var state_53987__$1 = state_53987;
var statearr_54018_54060 = state_53987__$1;
(statearr_54018_54060[(2)] = null);

(statearr_54018_54060[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53988 === (14))){
var inst_53981 = (state_53987[(2)]);
var state_53987__$1 = state_53987;
var statearr_54019_54061 = state_53987__$1;
(statearr_54019_54061[(2)] = inst_53981);

(statearr_54019_54061[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53988 === (10))){
var inst_53983 = (state_53987[(2)]);
var state_53987__$1 = state_53987;
var statearr_54020_54062 = state_53987__$1;
(statearr_54020_54062[(2)] = inst_53983);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53987__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53988 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_53987,(4),Error,(3),(2));
var state_53987__$1 = state_53987;
var statearr_54021_54063 = state_53987__$1;
(statearr_54021_54063[(2)] = null);

(statearr_54021_54063[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__21755__auto____$1,id__21756__auto____$1,c__33866__auto____$1,inst_53954,inst_53955,inst_53956,inst_53957,inst_53958,inst_53989,state_val_53996,c__33866__auto___54044,c__21755__auto___54042,id__21756__auto___54043))
;
return ((function (switch__33843__auto__,c__21755__auto____$1,id__21756__auto____$1,c__33866__auto____$1,inst_53954,inst_53955,inst_53956,inst_53957,inst_53958,inst_53989,state_val_53996,c__33866__auto___54044,c__21755__auto___54042,id__21756__auto___54043){
return (function() {
var superv$async$state_machine__33844__auto__ = null;
var superv$async$state_machine__33844__auto____0 = (function (){
var statearr_54025 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_54025[(0)] = superv$async$state_machine__33844__auto__);

(statearr_54025[(1)] = (1));

return statearr_54025;
});
var superv$async$state_machine__33844__auto____1 = (function (state_53987){
while(true){
var ret_value__33845__auto__ = (function (){try{while(true){
var result__33846__auto__ = switch__33843__auto__.call(null,state_53987);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33846__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33846__auto__;
}
break;
}
}catch (e54026){if((e54026 instanceof Object)){
var ex__33847__auto__ = e54026;
var statearr_54027_54064 = state_53987;
(statearr_54027_54064[(5)] = ex__33847__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53987);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54026;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33845__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54065 = state_53987;
state_53987 = G__54065;
continue;
} else {
return ret_value__33845__auto__;
}
break;
}
});
superv$async$state_machine__33844__auto__ = function(state_53987){
switch(arguments.length){
case 0:
return superv$async$state_machine__33844__auto____0.call(this);
case 1:
return superv$async$state_machine__33844__auto____1.call(this,state_53987);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__33844__auto____0;
superv$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__33844__auto____1;
return superv$async$state_machine__33844__auto__;
})()
;})(switch__33843__auto__,c__21755__auto____$1,id__21756__auto____$1,c__33866__auto____$1,inst_53954,inst_53955,inst_53956,inst_53957,inst_53958,inst_53989,state_val_53996,c__33866__auto___54044,c__21755__auto___54042,id__21756__auto___54043))
})();
var state__33868__auto__ = (function (){var statearr_54028 = f__33867__auto__.call(null);
(statearr_54028[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33866__auto____$1);

return statearr_54028;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33868__auto__);
});
;})(c__21755__auto____$1,id__21756__auto____$1,c__33866__auto____$1,inst_53954,inst_53955,inst_53956,inst_53957,inst_53958,inst_53989,state_val_53996,c__33866__auto___54044,c__21755__auto___54042,id__21756__auto___54043))
})();
var inst_53991 = cljs.core.async.impl.dispatch.run.call(null,inst_53990);
var state_53995__$1 = (function (){var statearr_54029 = state_53995;
(statearr_54029[(11)] = inst_53955);

(statearr_54029[(12)] = inst_53954);

(statearr_54029[(13)] = inst_53991);

return statearr_54029;
})();
var statearr_54030_54066 = state_53995__$1;
(statearr_54030_54066[(2)] = inst_53989);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53995__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__33866__auto___54044,c__21755__auto___54042,id__21756__auto___54043))
;
return ((function (switch__33843__auto__,c__33866__auto___54044,c__21755__auto___54042,id__21756__auto___54043){
return (function() {
var superv$async$state_machine__33844__auto__ = null;
var superv$async$state_machine__33844__auto____0 = (function (){
var statearr_54034 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54034[(0)] = superv$async$state_machine__33844__auto__);

(statearr_54034[(1)] = (1));

return statearr_54034;
});
var superv$async$state_machine__33844__auto____1 = (function (state_53995){
while(true){
var ret_value__33845__auto__ = (function (){try{while(true){
var result__33846__auto__ = switch__33843__auto__.call(null,state_53995);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33846__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33846__auto__;
}
break;
}
}catch (e54035){if((e54035 instanceof Object)){
var ex__33847__auto__ = e54035;
var statearr_54036_54067 = state_53995;
(statearr_54036_54067[(5)] = ex__33847__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53995);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54035;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33845__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54068 = state_53995;
state_53995 = G__54068;
continue;
} else {
return ret_value__33845__auto__;
}
break;
}
});
superv$async$state_machine__33844__auto__ = function(state_53995){
switch(arguments.length){
case 0:
return superv$async$state_machine__33844__auto____0.call(this);
case 1:
return superv$async$state_machine__33844__auto____1.call(this,state_53995);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__33844__auto____0;
superv$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__33844__auto____1;
return superv$async$state_machine__33844__auto__;
})()
;})(switch__33843__auto__,c__33866__auto___54044,c__21755__auto___54042,id__21756__auto___54043))
})();
var state__33868__auto__ = (function (){var statearr_54037 = f__33867__auto__.call(null);
(statearr_54037[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33866__auto___54044);

return statearr_54037;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33868__auto__);
});})(c__33866__auto___54044,c__21755__auto___54042,id__21756__auto___54043))
);


return cljs.core.async.sub.call(null,p,topic,ch,close_QMARK_);
});

superv.async.sub.cljs$lang$maxFixedArity = 5;

/**
 * Creates a supervised channel for transducer xform. Exceptions
 *   immediatly propagate to the supervisor.
 */
superv.async.chan_super = (function superv$async$chan_super(S,buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,(function (e){
return cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(S),e);
}));
});
/**
 * Starts a subsystem with supervised go-routines initialized by start-fn.
 *   Restarts the system on error for retries times with a potential delay in
 *   milliseconds, an optional error-fn predicate determining the retry and a
 *   optional filter by exception type. You can optionally pass a supervisor to
 *   form a supervision tree. Whenever this passed supervisor aborts the context,
 *   this supervisor will close as well. You still need to block on the result of
 *   this supervisor if you want a clean synchronized shutdown. The concept is
 *   similar to http://learnyousomeerlang.com/supervisors
 * 
 *   All blocking channel ops in the subroutines (supervised context) are
 *   aborted with an exception on error to force total termination. The
 *   supervisor waits until all supervised go-routines are finished and
 *   have freed resources before restarting.
 * 
 *   If exceptions are not taken from go-try channels (by error), they become stale
 *   after the stale-timeout and trigger a restart or are propagated to the parent
 *   supervisor (if available) and the return value.
 * 
 *   Note: The signature and behaviour of this function might still change.
 */
superv.async.restarting_supervisor = (function superv$async$restarting_supervisor(var_args){
var args__10382__auto__ = [];
var len__10375__auto___54376 = arguments.length;
var i__10376__auto___54377 = (0);
while(true){
if((i__10376__auto___54377 < len__10375__auto___54376)){
args__10382__auto__.push((arguments[i__10376__auto___54377]));

var G__54378 = (i__10376__auto___54377 + (1));
i__10376__auto___54377 = G__54378;
continue;
} else {
}
break;
}

var argseq__10383__auto__ = ((((1) < args__10382__auto__.length))?(new cljs.core.IndexedSeq(args__10382__auto__.slice((1)),(0),null)):null);
return superv.async.restarting_supervisor.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10383__auto__);
});

superv.async.restarting_supervisor.cljs$core$IFn$_invoke$arity$variadic = (function (start_fn,p__54083){
var map__54084 = p__54083;
var map__54084__$1 = ((((!((map__54084 == null)))?((((map__54084.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54084.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54084):map__54084);
var retries = cljs.core.get.call(null,map__54084__$1,new cljs.core.Keyword(null,"retries","retries",1888092808),Infinity);
var delay = cljs.core.get.call(null,map__54084__$1,new cljs.core.Keyword(null,"delay","delay",-574225219),(0));
var error_fn = cljs.core.get.call(null,map__54084__$1,new cljs.core.Keyword(null,"error-fn","error-fn",-171437615),null);
var exception = cljs.core.get.call(null,map__54084__$1,new cljs.core.Keyword(null,"exception","exception",-335277064),Error);
var stale_timeout = cljs.core.get.call(null,map__54084__$1,new cljs.core.Keyword(null,"stale-timeout","stale-timeout",-468804294),((60) * (1000)));
var log_fn = cljs.core.get.call(null,map__54084__$1,new cljs.core.Keyword(null,"log-fn","log-fn",-2003241282),((function (map__54084,map__54084__$1,retries,delay,error_fn,exception,stale_timeout){
return (function (level,msg){
return cljs.core.println.call(null,level,msg);
});})(map__54084,map__54084__$1,retries,delay,error_fn,exception,stale_timeout))
);
var supervisor = cljs.core.get.call(null,map__54084__$1,new cljs.core.Keyword(null,"supervisor","supervisor",-134060208));
var retries__$1 = (function (){var or__9154__auto__ = retries;
if(cljs.core.truth_(or__9154__auto__)){
return or__9154__auto__;
} else {
return Infinity;
}
})();
var out_ch = cljs.core.async.chan.call(null);
var c__33866__auto___54379 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33866__auto___54379,retries__$1,out_ch,map__54084,map__54084__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (){
var f__33867__auto__ = (function (){var switch__33843__auto__ = ((function (c__33866__auto___54379,retries__$1,out_ch,map__54084,map__54084__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (state_54275){
var state_val_54276 = (state_54275[(1)]);
if((state_val_54276 === (7))){
var inst_54090 = (state_54275[(7)]);
var inst_54218 = (state_54275[(2)]);
var inst_54219 = cljs.core.nth.call(null,inst_54218,(0),null);
var inst_54220 = cljs.core.nth.call(null,inst_54218,(1),null);
var inst_54221 = cljs.core._EQ_.call(null,inst_54220,inst_54090);
var inst_54222 = !(inst_54221);
var state_54275__$1 = (function (){var statearr_54277 = state_54275;
(statearr_54277[(8)] = inst_54219);

return statearr_54277;
})();
if(inst_54222){
var statearr_54278_54380 = state_54275__$1;
(statearr_54278_54380[(1)] = (8));

} else {
var statearr_54279_54381 = state_54275__$1;
(statearr_54279_54381[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54276 === (20))){
var inst_54219 = (state_54275[(8)]);
var inst_54250 = (state_54275[(2)]);
var inst_54251 = cljs.core.async.put_BANG_.call(null,out_ch,inst_54219);
var inst_54252 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_54275__$1 = (function (){var statearr_54280 = state_54275;
(statearr_54280[(9)] = inst_54250);

(statearr_54280[(10)] = inst_54251);

return statearr_54280;
})();
var statearr_54281_54382 = state_54275__$1;
(statearr_54281_54382[(2)] = inst_54252);

(statearr_54281_54382[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54276 === (1))){
var inst_54086 = retries__$1;
var state_54275__$1 = (function (){var statearr_54282 = state_54275;
(statearr_54282[(11)] = inst_54086);

return statearr_54282;
})();
var statearr_54283_54383 = state_54275__$1;
(statearr_54283_54383[(2)] = null);

(statearr_54283_54383[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54276 === (4))){
var inst_54090 = (state_54275[(7)]);
var inst_54099 = (state_54275[(12)]);
var inst_54089 = (state_54275[(13)]);
var inst_54098 = (state_54275[(14)]);
var inst_54088 = (state_54275[(15)]);
var inst_54086 = (state_54275[(11)]);
var inst_54101 = superv.async.check_supervisor.call(null,superv.async.S);
var inst_54102 = cljs.core.list(cljs.core.list(new cljs.core.Symbol("cljs.core.async","<!","cljs.core.async/<!",1278951036,null),cljs.core.list(new cljs.core.Symbol("superv.async","-abort","superv.async/-abort",-365058004,null),new cljs.core.Symbol(null,"supervisor","supervisor",1506471319,null))),cljs.core.list(new cljs.core.Symbol(null,"close!","close!",-438778971,null),new cljs.core.Symbol(null,"ab-ch","ab-ch",-698106711,null)));
var inst_54103 = superv.async._register_go.call(null,supervisor,inst_54102);
var inst_54128 = cljs.core.async.chan.call(null,(1));
var inst_54129 = (function (){var stale_timeout__$1 = (1000);
var err_ch = inst_54088;
var ab_ch = inst_54089;
var res_ch = inst_54099;
var id__21756__auto__ = inst_54103;
var close_ch = inst_54090;
var retries__$2 = inst_54086;
var c__21755__auto__ = inst_54101;
var s = inst_54098;
var c__33866__auto____$1 = inst_54128;
return ((function (stale_timeout__$1,err_ch,ab_ch,res_ch,id__21756__auto__,close_ch,retries__$2,c__21755__auto__,s,c__33866__auto____$1,inst_54090,inst_54099,inst_54089,inst_54098,inst_54088,inst_54086,inst_54101,inst_54102,inst_54103,inst_54128,state_val_54276,c__33866__auto___54379,retries__$1,out_ch,map__54084,map__54084__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (){
var f__33867__auto__ = (function (){var switch__33843__auto__ = ((function (stale_timeout__$1,err_ch,ab_ch,res_ch,id__21756__auto__,close_ch,retries__$2,c__21755__auto__,s,c__33866__auto____$1,inst_54090,inst_54099,inst_54089,inst_54098,inst_54088,inst_54086,inst_54101,inst_54102,inst_54103,inst_54128,state_val_54276,c__33866__auto___54379,retries__$1,out_ch,map__54084,map__54084__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (state_54126){
var state_val_54127 = (state_54126[(1)]);
if((state_val_54127 === (1))){
var state_54126__$1 = state_54126;
var statearr_54284_54384 = state_54126__$1;
(statearr_54284_54384[(2)] = null);

(statearr_54284_54384[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54127 === (2))){
var inst_54124 = (state_54126[(2)]);
var state_54126__$1 = state_54126;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54126__$1,inst_54124);
} else {
if((state_val_54127 === (3))){
var inst_54104 = (state_54126[(2)]);
var inst_54105 = superv.async._unregister_go.call(null,supervisor,id__21756__auto__);
var state_54126__$1 = (function (){var statearr_54285 = state_54126;
(statearr_54285[(7)] = inst_54104);

(statearr_54285[(8)] = inst_54105);

return statearr_54285;
})();
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54126__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54127 === (4))){
var inst_54107 = (state_54126[(9)]);
var inst_54107__$1 = (state_54126[(2)]);
var inst_54108 = cljs.core.ex_data.call(null,inst_54107__$1);
var inst_54109 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_54108);
var inst_54110 = cljs.core._EQ_.call(null,inst_54109,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_54126__$1 = (function (){var statearr_54286 = state_54126;
(statearr_54286[(9)] = inst_54107__$1);

return statearr_54286;
})();
if(inst_54110){
var statearr_54287_54385 = state_54126__$1;
(statearr_54287_54385[(1)] = (5));

} else {
var statearr_54288_54386 = state_54126__$1;
(statearr_54288_54386[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54127 === (5))){
var state_54126__$1 = state_54126;
var statearr_54289_54387 = state_54126__$1;
(statearr_54289_54387[(2)] = null);

(statearr_54289_54387[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54127 === (6))){
var inst_54107 = (state_54126[(9)]);
var inst_54113 = superv.async._track_exception.call(null,supervisor,inst_54107);
var state_54126__$1 = state_54126;
var statearr_54290_54388 = state_54126__$1;
(statearr_54290_54388[(2)] = inst_54113);

(statearr_54290_54388[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54127 === (7))){
var inst_54107 = (state_54126[(9)]);
var inst_54115 = (state_54126[(2)]);
var state_54126__$1 = (function (){var statearr_54291 = state_54126;
(statearr_54291[(10)] = inst_54115);

return statearr_54291;
})();
var statearr_54292_54389 = state_54126__$1;
(statearr_54292_54389[(2)] = inst_54107);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54126__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54127 === (8))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_54126,(4),Error,(3),(2));
var inst_54119 = superv.async._abort.call(null,supervisor);
var state_54126__$1 = state_54126;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54126__$1,(9),inst_54119);
} else {
if((state_val_54127 === (9))){
var inst_54121 = (state_54126[(2)]);
var inst_54122 = cljs.core.async.close_BANG_.call(null,ab_ch);
var state_54126__$1 = (function (){var statearr_54293 = state_54126;
(statearr_54293[(11)] = inst_54121);

return statearr_54293;
})();
var statearr_54294_54390 = state_54126__$1;
(statearr_54294_54390[(2)] = inst_54122);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54126__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(stale_timeout__$1,err_ch,ab_ch,res_ch,id__21756__auto__,close_ch,retries__$2,c__21755__auto__,s,c__33866__auto____$1,inst_54090,inst_54099,inst_54089,inst_54098,inst_54088,inst_54086,inst_54101,inst_54102,inst_54103,inst_54128,state_val_54276,c__33866__auto___54379,retries__$1,out_ch,map__54084,map__54084__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
;
return ((function (switch__33843__auto__,stale_timeout__$1,err_ch,ab_ch,res_ch,id__21756__auto__,close_ch,retries__$2,c__21755__auto__,s,c__33866__auto____$1,inst_54090,inst_54099,inst_54089,inst_54098,inst_54088,inst_54086,inst_54101,inst_54102,inst_54103,inst_54128,state_val_54276,c__33866__auto___54379,retries__$1,out_ch,map__54084,map__54084__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function() {
var superv$async$state_machine__33844__auto__ = null;
var superv$async$state_machine__33844__auto____0 = (function (){
var statearr_54298 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54298[(0)] = superv$async$state_machine__33844__auto__);

(statearr_54298[(1)] = (1));

return statearr_54298;
});
var superv$async$state_machine__33844__auto____1 = (function (state_54126){
while(true){
var ret_value__33845__auto__ = (function (){try{while(true){
var result__33846__auto__ = switch__33843__auto__.call(null,state_54126);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33846__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33846__auto__;
}
break;
}
}catch (e54299){if((e54299 instanceof Object)){
var ex__33847__auto__ = e54299;
var statearr_54300_54391 = state_54126;
(statearr_54300_54391[(5)] = ex__33847__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54126);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54299;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33845__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54392 = state_54126;
state_54126 = G__54392;
continue;
} else {
return ret_value__33845__auto__;
}
break;
}
});
superv$async$state_machine__33844__auto__ = function(state_54126){
switch(arguments.length){
case 0:
return superv$async$state_machine__33844__auto____0.call(this);
case 1:
return superv$async$state_machine__33844__auto____1.call(this,state_54126);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__33844__auto____0;
superv$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__33844__auto____1;
return superv$async$state_machine__33844__auto__;
})()
;})(switch__33843__auto__,stale_timeout__$1,err_ch,ab_ch,res_ch,id__21756__auto__,close_ch,retries__$2,c__21755__auto__,s,c__33866__auto____$1,inst_54090,inst_54099,inst_54089,inst_54098,inst_54088,inst_54086,inst_54101,inst_54102,inst_54103,inst_54128,state_val_54276,c__33866__auto___54379,retries__$1,out_ch,map__54084,map__54084__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var state__33868__auto__ = (function (){var statearr_54301 = f__33867__auto__.call(null);
(statearr_54301[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33866__auto____$1);

return statearr_54301;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33868__auto__);
});
;})(stale_timeout__$1,err_ch,ab_ch,res_ch,id__21756__auto__,close_ch,retries__$2,c__21755__auto__,s,c__33866__auto____$1,inst_54090,inst_54099,inst_54089,inst_54098,inst_54088,inst_54086,inst_54101,inst_54102,inst_54103,inst_54128,state_val_54276,c__33866__auto___54379,retries__$1,out_ch,map__54084,map__54084__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var inst_54130 = cljs.core.async.impl.dispatch.run.call(null,inst_54129);
var state_54275__$1 = (function (){var statearr_54302 = state_54275;
(statearr_54302[(16)] = inst_54130);

return statearr_54302;
})();
var statearr_54303_54393 = state_54275__$1;
(statearr_54303_54393[(2)] = inst_54128);

(statearr_54303_54393[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54276 === (15))){
var inst_54219 = (state_54275[(8)]);
var inst_54241 = [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_54242 = [new cljs.core.Keyword(null,"passing-error","passing-error",-1357712542),inst_54219];
var inst_54243 = cljs.core.PersistentHashMap.fromArrays(inst_54241,inst_54242);
var inst_54244 = log_fn.call(null,new cljs.core.Keyword(null,"error","error",-978969032),inst_54243);
var state_54275__$1 = (function (){var statearr_54304 = state_54275;
(statearr_54304[(17)] = inst_54244);

return statearr_54304;
})();
if(cljs.core.truth_(supervisor)){
var statearr_54305_54394 = state_54275__$1;
(statearr_54305_54394[(1)] = (18));

} else {
var statearr_54306_54395 = state_54275__$1;
(statearr_54306_54395[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54276 === (21))){
var inst_54219 = (state_54275[(8)]);
var inst_54086 = (state_54275[(11)]);
var inst_54256 = (state_54275[(2)]);
var inst_54257 = [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"further-retries","further-retries",1297645153)];
var inst_54258 = [new cljs.core.Keyword(null,"retry","retry",-614012896),inst_54219,inst_54086];
var inst_54259 = cljs.core.PersistentHashMap.fromArrays(inst_54257,inst_54258);
var inst_54260 = log_fn.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),inst_54259);
var inst_54261 = (inst_54086 - (1));
var inst_54086__$1 = inst_54261;
var state_54275__$1 = (function (){var statearr_54307 = state_54275;
(statearr_54307[(11)] = inst_54086__$1);

(statearr_54307[(18)] = inst_54260);

(statearr_54307[(19)] = inst_54256);

return statearr_54307;
})();
var statearr_54308_54396 = state_54275__$1;
(statearr_54308_54396[(2)] = null);

(statearr_54308_54396[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54276 === (13))){
var inst_54219 = (state_54275[(8)]);
var inst_54233 = error_fn.call(null,inst_54219);
var state_54275__$1 = state_54275;
var statearr_54309_54397 = state_54275__$1;
(statearr_54309_54397[(2)] = inst_54233);

(statearr_54309_54397[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54276 === (22))){
var inst_54267 = (state_54275[(2)]);
var inst_54268 = cljs.core.async.put_BANG_.call(null,out_ch,inst_54267);
var inst_54269 = cljs.core.async.close_BANG_.call(null,out_ch);
var state_54275__$1 = (function (){var statearr_54310 = state_54275;
(statearr_54310[(20)] = inst_54268);

return statearr_54310;
})();
var statearr_54311_54398 = state_54275__$1;
(statearr_54311_54398[(2)] = inst_54269);

(statearr_54311_54398[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54276 === (6))){
var inst_54090 = (state_54275[(7)]);
var inst_54099 = (state_54275[(12)]);
var inst_54089 = (state_54275[(13)]);
var inst_54098 = (state_54275[(14)]);
var inst_54088 = (state_54275[(15)]);
var inst_54086 = (state_54275[(11)]);
var inst_54133 = (state_54275[(2)]);
var inst_54180 = cljs.core.async.chan.call(null,(1));
var inst_54181 = (function (){var retries__$2 = inst_54086;
var err_ch = inst_54088;
var ab_ch = inst_54089;
var close_ch = inst_54090;
var s = inst_54098;
var res_ch = inst_54099;
var stale_timeout__$1 = (1000);
var c__33866__auto____$1 = inst_54180;
return ((function (retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33866__auto____$1,inst_54090,inst_54099,inst_54089,inst_54098,inst_54088,inst_54086,inst_54133,inst_54180,state_val_54276,c__33866__auto___54379,retries__$1,out_ch,map__54084,map__54084__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (){
var f__33867__auto__ = (function (){var switch__33843__auto__ = ((function (retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33866__auto____$1,inst_54090,inst_54099,inst_54089,inst_54098,inst_54088,inst_54086,inst_54133,inst_54180,state_val_54276,c__33866__auto___54379,retries__$1,out_ch,map__54084,map__54084__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (state_54178){
var state_val_54179 = (state_54178[(1)]);
if((state_val_54179 === (7))){
var inst_54153 = (state_54178[(7)]);
var inst_54140 = (state_54178[(2)]);
var inst_54148 = (function (){return ((function (inst_54153,inst_54140,state_val_54179,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33866__auto____$1,inst_54090,inst_54099,inst_54089,inst_54098,inst_54088,inst_54086,inst_54133,inst_54180,state_val_54276,c__33866__auto___54379,retries__$1,out_ch,map__54084,map__54084__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (p__54147){
var vec__54312 = p__54147;
var k = cljs.core.nth.call(null,vec__54312,(0),null);
var v = cljs.core.nth.call(null,vec__54312,(1),null);
return ((superv.async.now.call(null).getTime() - stale_timeout__$1) > v.getTime());
});
;})(inst_54153,inst_54140,state_val_54179,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33866__auto____$1,inst_54090,inst_54099,inst_54089,inst_54098,inst_54088,inst_54086,inst_54133,inst_54180,state_val_54276,c__33866__auto___54379,retries__$1,out_ch,map__54084,map__54084__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var inst_54149 = new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s);
var inst_54150 = cljs.core.deref.call(null,inst_54149);
var inst_54151 = cljs.core.filter.call(null,inst_54148,inst_54150);
var inst_54152 = cljs.core.nth.call(null,inst_54151,(0),null);
var inst_54153__$1 = cljs.core.nth.call(null,inst_54152,(0),null);
var inst_54154 = cljs.core.nth.call(null,inst_54152,(1),null);
var state_54178__$1 = (function (){var statearr_54315 = state_54178;
(statearr_54315[(8)] = inst_54154);

(statearr_54315[(7)] = inst_54153__$1);

(statearr_54315[(9)] = inst_54140);

return statearr_54315;
})();
if(cljs.core.truth_(inst_54153__$1)){
var statearr_54316_54399 = state_54178__$1;
(statearr_54316_54399[(1)] = (8));

} else {
var statearr_54317_54400 = state_54178__$1;
(statearr_54317_54400[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54179 === (1))){
var state_54178__$1 = state_54178;
var statearr_54318_54401 = state_54178__$1;
(statearr_54318_54401[(2)] = null);

(statearr_54318_54401[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54179 === (4))){
var state_54178__$1 = state_54178;
var statearr_54319_54402 = state_54178__$1;
(statearr_54319_54402[(2)] = null);

(statearr_54319_54402[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54179 === (13))){
var inst_54153 = (state_54178[(7)]);
var inst_54166 = (state_54178[(2)]);
var inst_54167 = superv.async._free_exception.call(null,s,inst_54153);
var inst_54168 = cljs.core.async.put_BANG_.call(null,err_ch,inst_54153);
var state_54178__$1 = (function (){var statearr_54320 = state_54178;
(statearr_54320[(10)] = inst_54167);

(statearr_54320[(11)] = inst_54166);

return statearr_54320;
})();
var statearr_54321_54403 = state_54178__$1;
(statearr_54321_54403[(2)] = inst_54168);

(statearr_54321_54403[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54179 === (6))){
var inst_54174 = (state_54178[(2)]);
var state_54178__$1 = state_54178;
var statearr_54322_54404 = state_54178__$1;
(statearr_54322_54404[(2)] = inst_54174);

(statearr_54322_54404[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54179 === (3))){
var inst_54176 = (state_54178[(2)]);
var state_54178__$1 = state_54178;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54178__$1,inst_54176);
} else {
if((state_val_54179 === (12))){
var inst_54153 = (state_54178[(7)]);
var inst_54161 = [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_54162 = [new cljs.core.Keyword(null,"stale-error-in-supervisor","stale-error-in-supervisor",-123257662),inst_54153];
var inst_54163 = cljs.core.PersistentHashMap.fromArrays(inst_54161,inst_54162);
var inst_54164 = log_fn.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_54163);
var state_54178__$1 = state_54178;
var statearr_54323_54405 = state_54178__$1;
(statearr_54323_54405[(2)] = inst_54164);

(statearr_54323_54405[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54179 === (2))){
var inst_54135 = cljs.core.async.poll_BANG_.call(null,ab_ch);
var state_54178__$1 = state_54178;
if(cljs.core.truth_(inst_54135)){
var statearr_54324_54406 = state_54178__$1;
(statearr_54324_54406[(1)] = (4));

} else {
var statearr_54325_54407 = state_54178__$1;
(statearr_54325_54407[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54179 === (11))){
var state_54178__$1 = state_54178;
var statearr_54326_54408 = state_54178__$1;
(statearr_54326_54408[(2)] = null);

(statearr_54326_54408[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54179 === (9))){
var state_54178__$1 = state_54178;
var statearr_54327_54409 = state_54178__$1;
(statearr_54327_54409[(2)] = null);

(statearr_54327_54409[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54179 === (5))){
var inst_54138 = cljs.core.async.timeout.call(null,stale_timeout__$1);
var state_54178__$1 = state_54178;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54178__$1,(7),inst_54138);
} else {
if((state_val_54179 === (10))){
var inst_54172 = (state_54178[(2)]);
var state_54178__$1 = state_54178;
var statearr_54328_54410 = state_54178__$1;
(statearr_54328_54410[(2)] = inst_54172);

(statearr_54328_54410[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54179 === (8))){
var inst_54153 = (state_54178[(7)]);
var inst_54156 = cljs.core.ex_data.call(null,inst_54153);
var inst_54157 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_54156);
var inst_54158 = cljs.core._EQ_.call(null,inst_54157,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_54178__$1 = state_54178;
if(inst_54158){
var statearr_54329_54411 = state_54178__$1;
(statearr_54329_54411[(1)] = (11));

} else {
var statearr_54330_54412 = state_54178__$1;
(statearr_54330_54412[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33866__auto____$1,inst_54090,inst_54099,inst_54089,inst_54098,inst_54088,inst_54086,inst_54133,inst_54180,state_val_54276,c__33866__auto___54379,retries__$1,out_ch,map__54084,map__54084__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
;
return ((function (switch__33843__auto__,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33866__auto____$1,inst_54090,inst_54099,inst_54089,inst_54098,inst_54088,inst_54086,inst_54133,inst_54180,state_val_54276,c__33866__auto___54379,retries__$1,out_ch,map__54084,map__54084__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function() {
var superv$async$state_machine__33844__auto__ = null;
var superv$async$state_machine__33844__auto____0 = (function (){
var statearr_54334 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54334[(0)] = superv$async$state_machine__33844__auto__);

(statearr_54334[(1)] = (1));

return statearr_54334;
});
var superv$async$state_machine__33844__auto____1 = (function (state_54178){
while(true){
var ret_value__33845__auto__ = (function (){try{while(true){
var result__33846__auto__ = switch__33843__auto__.call(null,state_54178);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33846__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33846__auto__;
}
break;
}
}catch (e54335){if((e54335 instanceof Object)){
var ex__33847__auto__ = e54335;
var statearr_54336_54413 = state_54178;
(statearr_54336_54413[(5)] = ex__33847__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54178);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54335;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33845__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54414 = state_54178;
state_54178 = G__54414;
continue;
} else {
return ret_value__33845__auto__;
}
break;
}
});
superv$async$state_machine__33844__auto__ = function(state_54178){
switch(arguments.length){
case 0:
return superv$async$state_machine__33844__auto____0.call(this);
case 1:
return superv$async$state_machine__33844__auto____1.call(this,state_54178);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__33844__auto____0;
superv$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__33844__auto____1;
return superv$async$state_machine__33844__auto__;
})()
;})(switch__33843__auto__,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33866__auto____$1,inst_54090,inst_54099,inst_54089,inst_54098,inst_54088,inst_54086,inst_54133,inst_54180,state_val_54276,c__33866__auto___54379,retries__$1,out_ch,map__54084,map__54084__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var state__33868__auto__ = (function (){var statearr_54337 = f__33867__auto__.call(null);
(statearr_54337[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33866__auto____$1);

return statearr_54337;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33868__auto__);
});
;})(retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33866__auto____$1,inst_54090,inst_54099,inst_54089,inst_54098,inst_54088,inst_54086,inst_54133,inst_54180,state_val_54276,c__33866__auto___54379,retries__$1,out_ch,map__54084,map__54084__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var inst_54182 = cljs.core.async.impl.dispatch.run.call(null,inst_54181);
var inst_54208 = cljs.core.async.chan.call(null,(1));
var inst_54209 = (function (){var retries__$2 = inst_54086;
var err_ch = inst_54088;
var ab_ch = inst_54089;
var close_ch = inst_54090;
var s = inst_54098;
var res_ch = inst_54099;
var stale_timeout__$1 = (1000);
var c__33866__auto____$1 = inst_54208;
return ((function (retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33866__auto____$1,inst_54090,inst_54099,inst_54089,inst_54098,inst_54088,inst_54086,inst_54133,inst_54180,inst_54181,inst_54182,inst_54208,state_val_54276,c__33866__auto___54379,retries__$1,out_ch,map__54084,map__54084__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (){
var f__33867__auto__ = (function (){var switch__33843__auto__ = ((function (retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33866__auto____$1,inst_54090,inst_54099,inst_54089,inst_54098,inst_54088,inst_54086,inst_54133,inst_54180,inst_54181,inst_54182,inst_54208,state_val_54276,c__33866__auto___54379,retries__$1,out_ch,map__54084,map__54084__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function (state_54206){
var state_val_54207 = (state_54206[(1)]);
if((state_val_54207 === (1))){
var inst_54183 = (0);
var state_54206__$1 = (function (){var statearr_54338 = state_54206;
(statearr_54338[(7)] = inst_54183);

return statearr_54338;
})();
var statearr_54339_54415 = state_54206__$1;
(statearr_54339_54415[(2)] = null);

(statearr_54339_54415[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54207 === (2))){
var inst_54185 = new cljs.core.Keyword(null,"registered","registered",-388600037).cljs$core$IFn$_invoke$arity$1(s);
var inst_54186 = cljs.core.deref.call(null,inst_54185);
var inst_54187 = cljs.core.empty_QMARK_.call(null,inst_54186);
var inst_54188 = new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094).cljs$core$IFn$_invoke$arity$1(s);
var inst_54189 = cljs.core.deref.call(null,inst_54188);
var inst_54190 = cljs.core.empty_QMARK_.call(null,inst_54189);
var inst_54191 = (inst_54187) && (inst_54190);
var inst_54192 = cljs.core.not.call(null,inst_54191);
var state_54206__$1 = state_54206;
if(inst_54192){
var statearr_54340_54416 = state_54206__$1;
(statearr_54340_54416[(1)] = (4));

} else {
var statearr_54341_54417 = state_54206__$1;
(statearr_54341_54417[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54207 === (3))){
var inst_54204 = (state_54206[(2)]);
var state_54206__$1 = state_54206;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54206__$1,inst_54204);
} else {
if((state_val_54207 === (4))){
var inst_54194 = cljs.core.async.timeout.call(null,(100));
var state_54206__$1 = state_54206;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54206__$1,(7),inst_54194);
} else {
if((state_val_54207 === (5))){
var inst_54200 = cljs.core.async.close_BANG_.call(null,close_ch);
var state_54206__$1 = state_54206;
var statearr_54342_54418 = state_54206__$1;
(statearr_54342_54418[(2)] = inst_54200);

(statearr_54342_54418[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54207 === (6))){
var inst_54202 = (state_54206[(2)]);
var state_54206__$1 = state_54206;
var statearr_54343_54419 = state_54206__$1;
(statearr_54343_54419[(2)] = inst_54202);

(statearr_54343_54419[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54207 === (7))){
var inst_54183 = (state_54206[(7)]);
var inst_54196 = (state_54206[(2)]);
var inst_54197 = (inst_54183 + (1));
var inst_54183__$1 = inst_54197;
var state_54206__$1 = (function (){var statearr_54344 = state_54206;
(statearr_54344[(8)] = inst_54196);

(statearr_54344[(7)] = inst_54183__$1);

return statearr_54344;
})();
var statearr_54345_54420 = state_54206__$1;
(statearr_54345_54420[(2)] = null);

(statearr_54345_54420[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33866__auto____$1,inst_54090,inst_54099,inst_54089,inst_54098,inst_54088,inst_54086,inst_54133,inst_54180,inst_54181,inst_54182,inst_54208,state_val_54276,c__33866__auto___54379,retries__$1,out_ch,map__54084,map__54084__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
;
return ((function (switch__33843__auto__,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33866__auto____$1,inst_54090,inst_54099,inst_54089,inst_54098,inst_54088,inst_54086,inst_54133,inst_54180,inst_54181,inst_54182,inst_54208,state_val_54276,c__33866__auto___54379,retries__$1,out_ch,map__54084,map__54084__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function() {
var superv$async$state_machine__33844__auto__ = null;
var superv$async$state_machine__33844__auto____0 = (function (){
var statearr_54349 = [null,null,null,null,null,null,null,null,null];
(statearr_54349[(0)] = superv$async$state_machine__33844__auto__);

(statearr_54349[(1)] = (1));

return statearr_54349;
});
var superv$async$state_machine__33844__auto____1 = (function (state_54206){
while(true){
var ret_value__33845__auto__ = (function (){try{while(true){
var result__33846__auto__ = switch__33843__auto__.call(null,state_54206);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33846__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33846__auto__;
}
break;
}
}catch (e54350){if((e54350 instanceof Object)){
var ex__33847__auto__ = e54350;
var statearr_54351_54421 = state_54206;
(statearr_54351_54421[(5)] = ex__33847__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54206);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54350;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33845__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54422 = state_54206;
state_54206 = G__54422;
continue;
} else {
return ret_value__33845__auto__;
}
break;
}
});
superv$async$state_machine__33844__auto__ = function(state_54206){
switch(arguments.length){
case 0:
return superv$async$state_machine__33844__auto____0.call(this);
case 1:
return superv$async$state_machine__33844__auto____1.call(this,state_54206);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__33844__auto____0;
superv$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__33844__auto____1;
return superv$async$state_machine__33844__auto__;
})()
;})(switch__33843__auto__,retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33866__auto____$1,inst_54090,inst_54099,inst_54089,inst_54098,inst_54088,inst_54086,inst_54133,inst_54180,inst_54181,inst_54182,inst_54208,state_val_54276,c__33866__auto___54379,retries__$1,out_ch,map__54084,map__54084__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var state__33868__auto__ = (function (){var statearr_54352 = f__33867__auto__.call(null);
(statearr_54352[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33866__auto____$1);

return statearr_54352;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33868__auto__);
});
;})(retries__$2,err_ch,ab_ch,close_ch,s,res_ch,stale_timeout__$1,c__33866__auto____$1,inst_54090,inst_54099,inst_54089,inst_54098,inst_54088,inst_54086,inst_54133,inst_54180,inst_54181,inst_54182,inst_54208,state_val_54276,c__33866__auto___54379,retries__$1,out_ch,map__54084,map__54084__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var inst_54210 = cljs.core.async.impl.dispatch.run.call(null,inst_54209);
var inst_54214 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54215 = [inst_54088,inst_54090];
var inst_54216 = (new cljs.core.PersistentVector(null,2,(5),inst_54214,inst_54215,null));
var state_54275__$1 = (function (){var statearr_54353 = state_54275;
(statearr_54353[(21)] = inst_54133);

(statearr_54353[(22)] = inst_54182);

(statearr_54353[(23)] = inst_54210);

return statearr_54353;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_54275__$1,(7),inst_54216,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_54276 === (17))){
var inst_54264 = (state_54275[(2)]);
var state_54275__$1 = state_54275;
var statearr_54354_54423 = state_54275__$1;
(statearr_54354_54423[(2)] = inst_54264);

(statearr_54354_54423[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54276 === (3))){
var inst_54273 = (state_54275[(2)]);
var state_54275__$1 = state_54275;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54275__$1,inst_54273);
} else {
if((state_val_54276 === (12))){
var inst_54230 = (state_54275[(24)]);
var state_54275__$1 = state_54275;
var statearr_54355_54424 = state_54275__$1;
(statearr_54355_54424[(2)] = inst_54230);

(statearr_54355_54424[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54276 === (2))){
var inst_54089 = (state_54275[(13)]);
var inst_54098 = (state_54275[(14)]);
var inst_54088 = (state_54275[(15)]);
var inst_54088__$1 = cljs.core.async.chan.call(null);
var inst_54089__$1 = cljs.core.async.chan.call(null);
var inst_54090 = cljs.core.async.chan.call(null);
var inst_54091 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"registered","registered",-388600037),new cljs.core.Keyword(null,"pending-exceptions","pending-exceptions",-1888280094),new cljs.core.Keyword(null,"restarting","restarting",760677572)];
var inst_54092 = cljs.core.PersistentHashMap.EMPTY;
var inst_54093 = cljs.core.atom.call(null,inst_54092);
var inst_54094 = cljs.core.PersistentHashMap.EMPTY;
var inst_54095 = cljs.core.atom.call(null,inst_54094);
var inst_54096 = [inst_54088__$1,inst_54089__$1,inst_54093,inst_54095,true];
var inst_54097 = cljs.core.PersistentHashMap.fromArrays(inst_54091,inst_54096);
var inst_54098__$1 = superv.async.map__GT_TrackingSupervisor.call(null,inst_54097);
var inst_54099 = start_fn.call(null,inst_54098__$1);
var state_54275__$1 = (function (){var statearr_54356 = state_54275;
(statearr_54356[(7)] = inst_54090);

(statearr_54356[(12)] = inst_54099);

(statearr_54356[(13)] = inst_54089__$1);

(statearr_54356[(14)] = inst_54098__$1);

(statearr_54356[(15)] = inst_54088__$1);

return statearr_54356;
})();
if(cljs.core.truth_(supervisor)){
var statearr_54357_54425 = state_54275__$1;
(statearr_54357_54425[(1)] = (4));

} else {
var statearr_54358_54426 = state_54275__$1;
(statearr_54358_54426[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54276 === (19))){
var state_54275__$1 = state_54275;
var statearr_54359_54427 = state_54275__$1;
(statearr_54359_54427[(2)] = null);

(statearr_54359_54427[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54276 === (11))){
var inst_54219 = (state_54275[(8)]);
var inst_54230 = (state_54275[(24)]);
var inst_54227 = (state_54275[(2)]);
var inst_54228 = (inst_54219 instanceof exception);
var inst_54229 = cljs.core.not.call(null,inst_54228);
var inst_54230__$1 = cljs.core.not.call(null,error_fn);
var state_54275__$1 = (function (){var statearr_54360 = state_54275;
(statearr_54360[(25)] = inst_54229);

(statearr_54360[(24)] = inst_54230__$1);

(statearr_54360[(26)] = inst_54227);

return statearr_54360;
})();
if(inst_54230__$1){
var statearr_54361_54428 = state_54275__$1;
(statearr_54361_54428[(1)] = (12));

} else {
var statearr_54362_54429 = state_54275__$1;
(statearr_54362_54429[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54276 === (9))){
var inst_54099 = (state_54275[(12)]);
var state_54275__$1 = state_54275;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54275__$1,(22),inst_54099);
} else {
if((state_val_54276 === (5))){
var state_54275__$1 = state_54275;
var statearr_54363_54430 = state_54275__$1;
(statearr_54363_54430[(2)] = null);

(statearr_54363_54430[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54276 === (14))){
var inst_54229 = (state_54275[(25)]);
var inst_54086 = (state_54275[(11)]);
var inst_54235 = (state_54275[(2)]);
var inst_54236 = cljs.core.not.call(null,inst_54235);
var inst_54237 = (inst_54086 > (0));
var inst_54238 = cljs.core.not.call(null,inst_54237);
var inst_54239 = (inst_54229) || (inst_54236) || (inst_54238);
var state_54275__$1 = state_54275;
if(cljs.core.truth_(inst_54239)){
var statearr_54364_54431 = state_54275__$1;
(statearr_54364_54431[(1)] = (15));

} else {
var statearr_54365_54432 = state_54275__$1;
(statearr_54365_54432[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54276 === (16))){
var inst_54254 = cljs.core.async.timeout.call(null,delay);
var state_54275__$1 = state_54275;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54275__$1,(21),inst_54254);
} else {
if((state_val_54276 === (10))){
var inst_54271 = (state_54275[(2)]);
var state_54275__$1 = state_54275;
var statearr_54366_54433 = state_54275__$1;
(statearr_54366_54433[(2)] = inst_54271);

(statearr_54366_54433[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54276 === (18))){
var inst_54219 = (state_54275[(8)]);
var inst_54246 = superv.async._error.call(null,supervisor);
var inst_54247 = cljs.core.async.put_BANG_.call(null,inst_54246,inst_54219);
var state_54275__$1 = state_54275;
var statearr_54367_54434 = state_54275__$1;
(statearr_54367_54434[(2)] = inst_54247);

(statearr_54367_54434[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54276 === (8))){
var inst_54090 = (state_54275[(7)]);
var inst_54089 = (state_54275[(13)]);
var inst_54088 = (state_54275[(15)]);
var inst_54224 = cljs.core.async.close_BANG_.call(null,inst_54088);
var inst_54225 = cljs.core.async.close_BANG_.call(null,inst_54089);
var state_54275__$1 = (function (){var statearr_54368 = state_54275;
(statearr_54368[(27)] = inst_54225);

(statearr_54368[(28)] = inst_54224);

return statearr_54368;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54275__$1,(11),inst_54090);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33866__auto___54379,retries__$1,out_ch,map__54084,map__54084__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
;
return ((function (switch__33843__auto__,c__33866__auto___54379,retries__$1,out_ch,map__54084,map__54084__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor){
return (function() {
var superv$async$state_machine__33844__auto__ = null;
var superv$async$state_machine__33844__auto____0 = (function (){
var statearr_54372 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54372[(0)] = superv$async$state_machine__33844__auto__);

(statearr_54372[(1)] = (1));

return statearr_54372;
});
var superv$async$state_machine__33844__auto____1 = (function (state_54275){
while(true){
var ret_value__33845__auto__ = (function (){try{while(true){
var result__33846__auto__ = switch__33843__auto__.call(null,state_54275);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33846__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33846__auto__;
}
break;
}
}catch (e54373){if((e54373 instanceof Object)){
var ex__33847__auto__ = e54373;
var statearr_54374_54435 = state_54275;
(statearr_54374_54435[(5)] = ex__33847__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54275);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54373;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33845__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54436 = state_54275;
state_54275 = G__54436;
continue;
} else {
return ret_value__33845__auto__;
}
break;
}
});
superv$async$state_machine__33844__auto__ = function(state_54275){
switch(arguments.length){
case 0:
return superv$async$state_machine__33844__auto____0.call(this);
case 1:
return superv$async$state_machine__33844__auto____1.call(this,state_54275);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
superv$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$0 = superv$async$state_machine__33844__auto____0;
superv$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$1 = superv$async$state_machine__33844__auto____1;
return superv$async$state_machine__33844__auto__;
})()
;})(switch__33843__auto__,c__33866__auto___54379,retries__$1,out_ch,map__54084,map__54084__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
})();
var state__33868__auto__ = (function (){var statearr_54375 = f__33867__auto__.call(null);
(statearr_54375[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33866__auto___54379);

return statearr_54375;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33868__auto__);
});})(c__33866__auto___54379,retries__$1,out_ch,map__54084,map__54084__$1,retries,delay,error_fn,exception,stale_timeout,log_fn,supervisor))
);


return out_ch;
});

superv.async.restarting_supervisor.cljs$lang$maxFixedArity = (1);

superv.async.restarting_supervisor.cljs$lang$applyTo = (function (seq54081){
var G__54082 = cljs.core.first.call(null,seq54081);
var seq54081__$1 = cljs.core.next.call(null,seq54081);
return superv.async.restarting_supervisor.cljs$core$IFn$_invoke$arity$variadic(G__54082,seq54081__$1);
});

