// Compiled by ClojureScript 1.9.542 {}
goog.provide('kabel.client');
goog.require('cljs.core');
goog.require('kabel.binary');
goog.require('kabel.util');
goog.require('goog.net.WebSocket');
goog.require('goog.Uri');
goog.require('goog.events');
goog.require('cljs.core.async');
goog.require('superv.async');
if(cljs.core.truth_(kabel.util.on_node_QMARK_.call(null))){
console.log("Patching global env for: W3C WebSocket API.");

WebSocket = require("websocket").w3cwebsocket;
} else {
}
/**
 * Connects to url. Puts [in out] channels on return channel when ready.
 * Only supports websocket at the moment, but is supposed to dispatch on
 *   protocol of url. read-opts is ignored on cljs for now, use the
 *   platform-wide reader setup.
 */
kabel.client.client_connect_BANG_ = (function kabel$client$client_connect_BANG_(var_args){
var args55998 = [];
var len__10398__auto___56138 = arguments.length;
var i__10399__auto___56139 = (0);
while(true){
if((i__10399__auto___56139 < len__10398__auto___56138)){
args55998.push((arguments[i__10399__auto___56139]));

var G__56140 = (i__10399__auto___56139 + (1));
i__10399__auto___56139 = G__56140;
continue;
} else {
}
break;
}

var G__56000 = args55998.length;
switch (G__56000) {
case 3:
return kabel.client.client_connect_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return kabel.client.client_connect_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args55998.length)].join('')));

}
});

kabel.client.client_connect_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (S,url,peer_id){
return kabel.client.client_connect_BANG_.call(null,S,url,peer_id,cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY));
});

kabel.client.client_connect_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (S,url,peer_id,read_handlers,write_handlers){
var channel = (new goog.net.WebSocket(false));
var in_buffer = cljs.core.async.buffer.call(null,(1024));
var in$ = cljs.core.async.chan.call(null,in_buffer);
var out = cljs.core.async.chan.call(null);
var opener = cljs.core.async.chan.call(null);
var host = (new goog.Uri(url.replace("ws","http"))).getDomain();
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"kabel.client","/tmp/form-init5553882511645273596.clj",null,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (channel,in_buffer,in$,out,opener,host){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"connecting-to","connecting-to",-1991299113),new cljs.core.Keyword(null,"url","url",276297046),url], null)], null);
});})(channel,in_buffer,in$,out,opener,host))
,null)),null,1390001632);

var G__56001_56142 = channel;
goog.events.listen(G__56001_56142,goog.net.WebSocket.EventType.MESSAGE,((function (G__56001_56142,channel,in_buffer,in$,out,opener,host){
return (function (evt){
var v = evt.message;
try{if((cljs.core.count.call(null,in_buffer) > (100))){
channel.close();

throw cljs.core.ex_info.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("incoming buffer for "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" too full:"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,in_buffer))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"count","count",2139924085),cljs.core.count.call(null,in_buffer)], null));
} else {
}

if(typeof v === 'string'){
return cljs.core.async.put_BANG_.call(null,in$,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("kabel","serialization","kabel/serialization",437520425),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword("kabel","payload","kabel/payload",251259889),v], null));
} else {
return kabel.binary.from_binary.call(null,v,((function (v,G__56001_56142,channel,in_buffer,in$,out,opener,host){
return (function (p1__55997_SHARP_){
return cljs.core.async.put_BANG_.call(null,in$,((cljs.core.map_QMARK_.call(null,p1__55997_SHARP_))?cljs.core.assoc.call(null,p1__55997_SHARP_,new cljs.core.Keyword("kabel","host","kabel/host",-1456877872),host):p1__55997_SHARP_));
});})(v,G__56001_56142,channel,in_buffer,in$,out,opener,host))
);
}
}catch (e56002){if((e56002 instanceof Error)){
var e = e56002;
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"kabel.client","/tmp/form-init5553882511645273596.clj",null,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (e,v,G__56001_56142,channel,in_buffer,in$,out,opener,host){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"cannot-read-message","cannot-read-message",-543619229),new cljs.core.Keyword(null,"error","error",-978969032),e], null)], null);
});})(e,v,G__56001_56142,channel,in_buffer,in$,out,opener,host))
,null)),null,351017937);

channel.close();

cljs.core.async.close_BANG_.call(null,opener);

return cljs.core.async.put_BANG_.call(null,superv.async._error.call(null,S),e);
} else {
throw e56002;

}
}});})(G__56001_56142,channel,in_buffer,in$,out,opener,host))
);

goog.events.listen(G__56001_56142,goog.net.WebSocket.EventType.CLOSED,((function (G__56001_56142,channel,in_buffer,in$,out,opener,host){
return (function (evt){
var e = cljs.core.ex_info.call(null,"Connection closed!",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"event","event",301435442),evt], null));
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"kabel.client","/tmp/form-init5553882511645273596.clj",null,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (e,G__56001_56142,channel,in_buffer,in$,out,opener,host){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"connection-closed","connection-closed",579733998),new cljs.core.Keyword(null,"url","url",276297046),url], null)], null);
});})(e,G__56001_56142,channel,in_buffer,in$,out,opener,host))
,null)),null,-286232575);

cljs.core.async.close_BANG_.call(null,in$);

cljs.core.async.put_BANG_.call(null,superv.async._error.call(null,S),e);

try{cljs.core.async.put_BANG_.call(null,opener,e);
}catch (e56003){if((e56003 instanceof Object)){
var e_56143__$1 = e56003;
} else {
throw e56003;

}
}
channel.close();

return cljs.core.async.close_BANG_.call(null,opener);
});})(G__56001_56142,channel,in_buffer,in$,out,opener,host))
);

goog.events.listen(G__56001_56142,goog.net.WebSocket.EventType.OPENED,((function (G__56001_56142,channel,in_buffer,in$,out,opener,host){
return (function (evt){
cljs.core.async.put_BANG_.call(null,opener,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [in$,out], null));

return cljs.core.async.close_BANG_.call(null,opener);
});})(G__56001_56142,channel,in_buffer,in$,out,opener,host))
);

goog.events.listen(G__56001_56142,goog.net.WebSocket.EventType.ERROR,((function (G__56001_56142,channel,in_buffer,in$,out,opener,host){
return (function (evt){
var e = cljs.core.ex_info.call(null,"Connection error!",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"event","event",301435442),evt], null));
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"kabel.client","/tmp/form-init5553882511645273596.clj",null,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (e,G__56001_56142,channel,in_buffer,in$,out,opener,host){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"websocket-error","websocket-error",941100166),new cljs.core.Keyword(null,"url","url",276297046),url], null)], null);
});})(e,G__56001_56142,channel,in_buffer,in$,out,opener,host))
,null)),null,642344712);

cljs.core.async.put_BANG_.call(null,superv.async._error.call(null,S),e);

try{cljs.core.async.put_BANG_.call(null,opener,e);
}catch (e56004){if((e56004 instanceof Object)){
var e_56144__$1 = e56004;
} else {
throw e56004;

}
}
return cljs.core.async.close_BANG_.call(null,opener);
});})(G__56001_56142,channel,in_buffer,in$,out,opener,host))
);

try{
channel.open(url);
}catch (e56005){if((e56005 instanceof Object)){
var e_56145 = e56005;
var e_56146__$1 = cljs.core.ex_info.call(null,"Connection failed!",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"connection-failed","connection-failed",-1910345930),new cljs.core.Keyword(null,"error","error",-978969032),e_56145], null));
cljs.core.async.put_BANG_.call(null,superv.async._error.call(null,S),e_56146__$1);

cljs.core.async.put_BANG_.call(null,opener,e_56146__$1);

cljs.core.async.close_BANG_.call(null,opener);
} else {
throw e56005;

}
}

((function (channel,in_buffer,in$,out,opener,host){
return (function kabel$client$sender(){
return cljs.core.async.take_BANG_.call(null,out,((function (channel,in_buffer,in$,out,opener,host){
return (function (m){
if(cljs.core.truth_(m)){
var c__33847__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33847__auto__,channel,in_buffer,in$,out,opener,host){
return (function (){
var f__33848__auto__ = (function (){var switch__33824__auto__ = ((function (c__33847__auto__,channel,in_buffer,in$,out,opener,host){
return (function (state_56111){
var state_val_56112 = (state_56111[(1)]);
if((state_val_56112 === (7))){
var inst_56081 = (state_56111[(2)]);
var state_56111__$1 = (function (){var statearr_56113 = state_56111;
(statearr_56113[(7)] = inst_56081);

return statearr_56113;
})();
var statearr_56114_56147 = state_56111__$1;
(statearr_56114_56147[(2)] = null);

(statearr_56114_56147[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56112 === (1))){
var state_56111__$1 = state_56111;
var statearr_56115_56148 = state_56111__$1;
(statearr_56115_56148[(2)] = null);

(statearr_56115_56148[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56112 === (4))){
var inst_56076 = (function (){return ((function (state_val_56112,c__33847__auto__,channel,in_buffer,in$,out,opener,host){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"output-blocked","output-blocked",-122311417),new cljs.core.Keyword(null,"buffered-amount","buffered-amount",-665650460),channel.getBufferedAmount()], null)], null);
});
;})(state_val_56112,c__33847__auto__,channel,in_buffer,in$,out,opener,host))
})();
var inst_56077 = (new cljs.core.Delay(inst_56076,null));
var inst_56078 = taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"kabel.client","/tmp/form-init5553882511645273596.clj",null,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),inst_56077,null,-100987728);
var inst_56079 = kabel.client.timeout.call(null,(100));
var state_56111__$1 = (function (){var statearr_56116 = state_56111;
(statearr_56116[(8)] = inst_56078);

return statearr_56116;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56111__$1,(7),inst_56079);
} else {
if((state_val_56112 === (13))){
var inst_56106 = (state_56111[(2)]);
var state_56111__$1 = state_56111;
var statearr_56117_56149 = state_56111__$1;
(statearr_56117_56149[(2)] = inst_56106);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56111__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56112 === (6))){
var inst_56085 = (state_56111[(2)]);
var state_56111__$1 = state_56111;
var statearr_56118_56150 = state_56111__$1;
(statearr_56118_56150[(2)] = inst_56085);

(statearr_56118_56150[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56112 === (3))){
var inst_56087 = (state_56111[(2)]);
var state_56111__$1 = (function (){var statearr_56119 = state_56111;
(statearr_56119[(9)] = inst_56087);

return statearr_56119;
})();
var statearr_56120_56151 = state_56111__$1;
(statearr_56120_56151[(2)] = null);

(statearr_56120_56151[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56112 === (12))){
var inst_56103 = kabel.binary.to_binary.call(null,m);
var inst_56104 = channel.send(inst_56103);
var state_56111__$1 = state_56111;
var statearr_56121_56152 = state_56111__$1;
(statearr_56121_56152[(2)] = inst_56104);

(statearr_56121_56152[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56112 === (2))){
var inst_56073 = channel.getBufferedAmount();
var inst_56074 = (inst_56073 > (0));
var state_56111__$1 = state_56111;
if(cljs.core.truth_(inst_56074)){
var statearr_56122_56153 = state_56111__$1;
(statearr_56122_56153[(1)] = (4));

} else {
var statearr_56123_56154 = state_56111__$1;
(statearr_56123_56154[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56112 === (11))){
var inst_56100 = new cljs.core.Keyword("kabel","payload","kabel/payload",251259889).cljs$core$IFn$_invoke$arity$1(m);
var inst_56101 = channel.send(inst_56100);
var state_56111__$1 = state_56111;
var statearr_56124_56155 = state_56111__$1;
(statearr_56124_56155[(2)] = inst_56101);

(statearr_56124_56155[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56112 === (9))){
var inst_56088 = (state_56111[(2)]);
var inst_56089 = (function (){var e = inst_56088;
return ((function (e,inst_56088,state_val_56112,c__33847__auto__,channel,in_buffer,in$,out,opener,host){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"cannot-send-transit-message","cannot-send-transit-message",-1612316504),new cljs.core.Keyword(null,"error","error",-978969032),e], null)], null);
});
;})(e,inst_56088,state_val_56112,c__33847__auto__,channel,in_buffer,in$,out,opener,host))
})();
var inst_56090 = (new cljs.core.Delay(inst_56089,null));
var inst_56091 = taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"kabel.client","/tmp/form-init5553882511645273596.clj",null,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),inst_56090,null,1333740417);
var inst_56092 = superv.async._error.call(null,S);
var inst_56093 = cljs.core.async.put_BANG_.call(null,inst_56092,inst_56088);
var state_56111__$1 = (function (){var statearr_56125 = state_56111;
(statearr_56125[(10)] = inst_56091);

return statearr_56125;
})();
var statearr_56126_56156 = state_56111__$1;
(statearr_56126_56156[(2)] = inst_56093);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56111__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56112 === (5))){
var state_56111__$1 = state_56111;
var statearr_56127_56157 = state_56111__$1;
(statearr_56127_56157[(2)] = null);

(statearr_56127_56157[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56112 === (10))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_56111,(9),Error,null,(8));
var inst_56097 = new cljs.core.Keyword("kabel","serialization","kabel/serialization",437520425).cljs$core$IFn$_invoke$arity$1(m);
var inst_56098 = cljs.core._EQ_.call(null,inst_56097,new cljs.core.Keyword(null,"string","string",-1989541586));
var state_56111__$1 = state_56111;
if(inst_56098){
var statearr_56128_56158 = state_56111__$1;
(statearr_56128_56158[(1)] = (11));

} else {
var statearr_56129_56159 = state_56111__$1;
(statearr_56129_56159[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56112 === (8))){
var inst_56108 = (state_56111[(2)]);
var inst_56109 = kabel$client$sender.call(null);
var state_56111__$1 = (function (){var statearr_56130 = state_56111;
(statearr_56130[(11)] = inst_56108);

return statearr_56130;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56111__$1,inst_56109);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33847__auto__,channel,in_buffer,in$,out,opener,host))
;
return ((function (switch__33824__auto__,c__33847__auto__,channel,in_buffer,in$,out,opener,host){
return (function() {
var kabel$client$sender_$_state_machine__33825__auto__ = null;
var kabel$client$sender_$_state_machine__33825__auto____0 = (function (){
var statearr_56134 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56134[(0)] = kabel$client$sender_$_state_machine__33825__auto__);

(statearr_56134[(1)] = (1));

return statearr_56134;
});
var kabel$client$sender_$_state_machine__33825__auto____1 = (function (state_56111){
while(true){
var ret_value__33826__auto__ = (function (){try{while(true){
var result__33827__auto__ = switch__33824__auto__.call(null,state_56111);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33827__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33827__auto__;
}
break;
}
}catch (e56135){if((e56135 instanceof Object)){
var ex__33828__auto__ = e56135;
var statearr_56136_56160 = state_56111;
(statearr_56136_56160[(5)] = ex__33828__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56111);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56135;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33826__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56161 = state_56111;
state_56111 = G__56161;
continue;
} else {
return ret_value__33826__auto__;
}
break;
}
});
kabel$client$sender_$_state_machine__33825__auto__ = function(state_56111){
switch(arguments.length){
case 0:
return kabel$client$sender_$_state_machine__33825__auto____0.call(this);
case 1:
return kabel$client$sender_$_state_machine__33825__auto____1.call(this,state_56111);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
kabel$client$sender_$_state_machine__33825__auto__.cljs$core$IFn$_invoke$arity$0 = kabel$client$sender_$_state_machine__33825__auto____0;
kabel$client$sender_$_state_machine__33825__auto__.cljs$core$IFn$_invoke$arity$1 = kabel$client$sender_$_state_machine__33825__auto____1;
return kabel$client$sender_$_state_machine__33825__auto__;
})()
;})(switch__33824__auto__,c__33847__auto__,channel,in_buffer,in$,out,opener,host))
})();
var state__33849__auto__ = (function (){var statearr_56137 = f__33848__auto__.call(null);
(statearr_56137[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33847__auto__);

return statearr_56137;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33849__auto__);
});})(c__33847__auto__,channel,in_buffer,in$,out,opener,host))
);

return c__33847__auto__;
} else {
return channel.close();
}
});})(channel,in_buffer,in$,out,opener,host))
);
});})(channel,in_buffer,in$,out,opener,host))
.call(null);

return opener;
});

kabel.client.client_connect_BANG_.cljs$lang$maxFixedArity = 5;

