// Compiled by ClojureScript 1.9.542 {}
goog.provide('kabel.binary');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('hasch.platform');
goog.require('kabel.util');
goog.require('goog.crypt');
kabel.binary.encoding_table = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"binary","binary",-1802232288),(0),new cljs.core.Keyword(null,"string","string",-1989541586),(1),new cljs.core.Keyword(null,"pr-str","pr-str",587523624),(2),new cljs.core.Keyword(null,"transit-json","transit-json",1168016579),(11),new cljs.core.Keyword(null,"transit-msgpack","transit-msgpack",-127166965),(12)], null);
kabel.binary.decoding_table = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (p__55979){
var vec__55980 = p__55979;
var k = cljs.core.nth.call(null,vec__55980,(0),null);
var v = cljs.core.nth.call(null,vec__55980,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [v,k], null);
})),kabel.binary.encoding_table);
kabel.binary.to_binary = (function kabel$binary$to_binary(p__55983){
var map__55986 = p__55983;
var map__55986__$1 = ((((!((map__55986 == null)))?((((map__55986.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55986.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55986):map__55986);
var m = map__55986__$1;
var serialization = cljs.core.get.call(null,map__55986__$1,new cljs.core.Keyword("kabel","serialization","kabel/serialization",437520425));
var payload = cljs.core.get.call(null,map__55986__$1,new cljs.core.Keyword("kabel","payload","kabel/payload",251259889));
var payload__$1 = ((cljs.core.not.call(null,serialization))?hasch.platform.utf8.call(null,cljs.core.pr_str.call(null,m)):payload);
var serialization__$1 = ((cljs.core.not.call(null,serialization))?new cljs.core.Keyword(null,"pr-str","pr-str",587523624):serialization);
var header = [(0),(0),(0),kabel.binary.encoding_table.call(null,serialization__$1)];
var wrapped = (new Uint8Array(((4) + payload__$1.length)));
var _ = wrapped.set((new Uint8Array(header)),(0));
var ___$1 = wrapped.set((new Uint8Array(payload__$1)),(4));
if(cljs.core.not.call(null,kabel.util.on_node_QMARK_.call(null))){
if(typeof Blob !== 'undefined'){
return (new Blob([wrapped]));
} else {
return wrapped;
}
} else {
return (new Buffer(wrapped));
}
});
kabel.binary.from_binary = (function kabel$binary$from_binary(binary,cb){
var l = (cljs.core.truth_(kabel.util.on_node_QMARK_.call(null))?binary.length:((typeof Blob !== 'undefined')?binary.size:binary.byteLength));
if(cljs.core.truth_(kabel.util.on_node_QMARK_.call(null))){
return cb.call(null,(function (){var encoding = kabel.binary.decoding_table.call(null,((new Uint8Array(binary.slice((0),(4))))[(3)]));
var payload = binary.slice((4),l);
try{if(cljs.core._EQ_.call(null,encoding,new cljs.core.Keyword(null,"pr-str","pr-str",587523624))){
return cljs.reader.read_string.call(null,Buffer.from(payload).toString("utf8"));
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("kabel","serialization","kabel/serialization",437520425),encoding,new cljs.core.Keyword("kabel","payload","kabel/payload",251259889),Buffer.from(payload)], null);
}
}catch (e55992){if((e55992 instanceof Error)){
var e = e55992;
return cljs.core.ex_info.call(null,"Cannot parse binary.",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"error","error",-978969032),e], null));
} else {
throw e55992;

}
}})());
} else {
if(typeof Blob !== 'undefined'){
var fr = (new FileReader());
fr.onload = ((function (fr,l){
return (function (p1__55988_SHARP_){
var b = p1__55988_SHARP_.target.result;
var encoding = kabel.binary.decoding_table.call(null,((new Uint8Array(b.slice((0),(4))))[(3)]));
var payload = (new Uint8Array(b.slice((4),l)));
return cb.call(null,(function (){try{if(cljs.core._EQ_.call(null,encoding,new cljs.core.Keyword(null,"pr-str","pr-str",587523624))){
return cljs.reader.read_string.call(null,goog.crypt.utf8ByteArrayToString(payload));
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("kabel","serialization","kabel/serialization",437520425),encoding,new cljs.core.Keyword("kabel","payload","kabel/payload",251259889),payload], null);
}
}catch (e55993){if((e55993 instanceof Error)){
var e = e55993;
return cljs.core.ex_info.call(null,"Cannot parse binary.",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"error","error",-978969032),e], null));
} else {
throw e55993;

}
}})());
});})(fr,l))
;

return fr.readAsArrayBuffer(binary);
} else {
var b = binary;
var encoding = kabel.binary.decoding_table.call(null,((new Uint8Array(b.slice((0),(4))))[(3)]));
var payload = (new Uint8Array(b.slice((4),l)));
return cb.call(null,(function (){try{if(cljs.core._EQ_.call(null,encoding,new cljs.core.Keyword(null,"pr-str","pr-str",587523624))){
return cljs.reader.read_string.call(null,goog.crypt.utf8ByteArrayToString(payload));
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("kabel","serialization","kabel/serialization",437520425),encoding,new cljs.core.Keyword("kabel","payload","kabel/payload",251259889),payload], null);
}
}catch (e55994){if((e55994 instanceof Error)){
var e = e55994;
return cljs.core.ex_info.call(null,"Cannot parse binary.",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"error","error",-978969032),e], null));
} else {
throw e55994;

}
}})());
}
}
});
