// Compiled by ClojureScript 1.9.542 {}
goog.provide('hasch.benc');
goog.require('cljs.core');

/**
 * @interface
 */
hasch.benc.PHashCoercion = function(){};

hasch.benc._coerce = (function hasch$benc$_coerce(this$,md_create_fn,write_handlers){
if((!((this$ == null))) && (!((this$.hasch$benc$PHashCoercion$_coerce$arity$3 == null)))){
return this$.hasch$benc$PHashCoercion$_coerce$arity$3(this$,md_create_fn,write_handlers);
} else {
var x__9872__auto__ = (((this$ == null))?null:this$);
var m__9873__auto__ = (hasch.benc._coerce[goog.typeOf(x__9872__auto__)]);
if(!((m__9873__auto__ == null))){
return m__9873__auto__.call(null,this$,md_create_fn,write_handlers);
} else {
var m__9873__auto____$1 = (hasch.benc._coerce["_"]);
if(!((m__9873__auto____$1 == null))){
return m__9873__auto____$1.call(null,this$,md_create_fn,write_handlers);
} else {
throw cljs.core.missing_protocol.call(null,"PHashCoercion.-coerce",this$);
}
}
}
});

hasch.benc.magics = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"binary","binary",-1802232288),new cljs.core.Keyword(null,"inst","inst",645962501),new cljs.core.Keyword(null,"number","number",1570378438),new cljs.core.Keyword(null,"symbol","symbol",-1038572696),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"vector","vector",1902966158),new cljs.core.Keyword(null,"keyword","keyword",811389747),new cljs.core.Keyword(null,"nil","nil",99600501),new cljs.core.Keyword(null,"literal","literal",1664775605),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"seq","seq",-1817803783),new cljs.core.Keyword(null,"set","set",304602554),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"map","map",1371690461)],[(13),(6),(2),(4),(3),(9),(5),(0),(12),(7),(8),(11),(1),(10)]);
hasch.benc.split_size = (1024);
hasch.benc.max_entropy_byte_count = (32);
hasch.benc.byte_array = (function hasch$benc$byte_array(len){
return cljs.core.into_array.call(null,cljs.core.repeat.call(null,len,(0)));
});
hasch.benc.digest = (function hasch$benc$digest(bytes_or_seq_of_bytes,md_create_fn){
var md = md_create_fn.call(null);
if(cljs.core.seq_QMARK_.call(null,bytes_or_seq_of_bytes)){
var seq__60705_60709 = cljs.core.seq.call(null,bytes_or_seq_of_bytes);
var chunk__60706_60710 = null;
var count__60707_60711 = (0);
var i__60708_60712 = (0);
while(true){
if((i__60708_60712 < count__60707_60711)){
var bs_60713 = cljs.core._nth.call(null,chunk__60706_60710,i__60708_60712);
md.update(bs_60713);

var G__60714 = seq__60705_60709;
var G__60715 = chunk__60706_60710;
var G__60716 = count__60707_60711;
var G__60717 = (i__60708_60712 + (1));
seq__60705_60709 = G__60714;
chunk__60706_60710 = G__60715;
count__60707_60711 = G__60716;
i__60708_60712 = G__60717;
continue;
} else {
var temp__6738__auto___60718 = cljs.core.seq.call(null,seq__60705_60709);
if(temp__6738__auto___60718){
var seq__60705_60719__$1 = temp__6738__auto___60718;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__60705_60719__$1)){
var c__10065__auto___60720 = cljs.core.chunk_first.call(null,seq__60705_60719__$1);
var G__60721 = cljs.core.chunk_rest.call(null,seq__60705_60719__$1);
var G__60722 = c__10065__auto___60720;
var G__60723 = cljs.core.count.call(null,c__10065__auto___60720);
var G__60724 = (0);
seq__60705_60709 = G__60721;
chunk__60706_60710 = G__60722;
count__60707_60711 = G__60723;
i__60708_60712 = G__60724;
continue;
} else {
var bs_60725 = cljs.core.first.call(null,seq__60705_60719__$1);
md.update(bs_60725);

var G__60726 = cljs.core.next.call(null,seq__60705_60719__$1);
var G__60727 = null;
var G__60728 = (0);
var G__60729 = (0);
seq__60705_60709 = G__60726;
chunk__60706_60710 = G__60727;
count__60707_60711 = G__60728;
i__60708_60712 = G__60729;
continue;
}
} else {
}
}
break;
}
} else {
md.update(bytes_or_seq_of_bytes);
}

return md.digest();
});
hasch.benc.coerce_seq = (function hasch$benc$coerce_seq(seq,md_create_fn,write_handlers){
var seq_md = md_create_fn.call(null);
var s_60736 = seq;
while(true){
var vec__60733_60737 = s_60736;
var seq__60734_60738 = cljs.core.seq.call(null,vec__60733_60737);
var first__60735_60739 = cljs.core.first.call(null,seq__60734_60738);
var seq__60734_60740__$1 = cljs.core.next.call(null,seq__60734_60738);
var f_60741 = first__60735_60739;
var r_60742 = seq__60734_60740__$1;
seq_md.update(hasch.benc._coerce.call(null,f_60741,md_create_fn,write_handlers));

if(cljs.core.empty_QMARK_.call(null,r_60742)){
} else {
var G__60743 = cljs.core.rest.call(null,s_60736);
s_60736 = G__60743;
continue;
}
break;
}

return seq_md.digest();
});
/**
 * Commutatively coerces elements of collection, seq entries must already be crypto hashes
 *   to avoid collisions in XOR. Takes at maximum 32 bytes into account.
 */
hasch.benc.xor_hashes = (function hasch$benc$xor_hashes(seq){
var len = (function (){var x__9499__auto__ = cljs.core.count.call(null,cljs.core.first.call(null,seq));
var y__9500__auto__ = hasch.benc.max_entropy_byte_count;
return ((x__9499__auto__ < y__9500__auto__) ? x__9499__auto__ : y__9500__auto__);
})();
return cljs.core.reduce.call(null,((function (len){
return (function (acc,elem){
var i_60744 = (0);
while(true){
if((i_60744 < len)){
(acc[i_60744] = ((acc[i_60744]) ^ (elem[i_60744])));

var G__60745 = (i_60744 + (1));
i_60744 = G__60745;
continue;
} else {
}
break;
}

return acc;
});})(len))
,hasch.benc.byte_array.call(null,len),seq);
});
hasch.benc.encode_safe = (function hasch$benc$encode_safe(a,md_create_fn){
if((cljs.core.count.call(null,a) < hasch.benc.split_size)){
var len = cljs.core.long$.call(null,a.length);
var ea = hasch.benc.byte_array.call(null,len);
var i_60746 = (0);
while(true){
if(cljs.core._EQ_.call(null,i_60746,len)){
} else {
var e_60747 = (a[i_60746]);
if(((e_60747 > (0))) && ((e_60747 < (30)))){
(ea[i_60746] = (1));
} else {
}

var G__60748 = (i_60746 + (1));
i_60746 = G__60748;
continue;
}
break;
}

return a.concat(ea);
} else {
return hasch.benc.digest.call(null,a,md_create_fn);
}
});
