// Compiled by ClojureScript 1.9.542 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args49314 = [];
var len__10375__auto___49320 = arguments.length;
var i__10376__auto___49321 = (0);
while(true){
if((i__10376__auto___49321 < len__10375__auto___49320)){
args49314.push((arguments[i__10376__auto___49321]));

var G__49322 = (i__10376__auto___49321 + (1));
i__10376__auto___49321 = G__49322;
continue;
} else {
}
break;
}

var G__49316 = args49314.length;
switch (G__49316) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args49314.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async49317 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async49317 = (function (f,blockable,meta49318){
this.f = f;
this.blockable = blockable;
this.meta49318 = meta49318;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async49317.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_49319,meta49318__$1){
var self__ = this;
var _49319__$1 = this;
return (new cljs.core.async.t_cljs$core$async49317(self__.f,self__.blockable,meta49318__$1));
});

cljs.core.async.t_cljs$core$async49317.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_49319){
var self__ = this;
var _49319__$1 = this;
return self__.meta49318;
});

cljs.core.async.t_cljs$core$async49317.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async49317.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async49317.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async49317.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async49317.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta49318","meta49318",-414813274,null)], null);
});

cljs.core.async.t_cljs$core$async49317.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async49317.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async49317";

cljs.core.async.t_cljs$core$async49317.cljs$lang$ctorPrWriter = (function (this__9811__auto__,writer__9812__auto__,opt__9813__auto__){
return cljs.core._write.call(null,writer__9812__auto__,"cljs.core.async/t_cljs$core$async49317");
});

cljs.core.async.__GT_t_cljs$core$async49317 = (function cljs$core$async$__GT_t_cljs$core$async49317(f__$1,blockable__$1,meta49318){
return (new cljs.core.async.t_cljs$core$async49317(f__$1,blockable__$1,meta49318));
});

}

return (new cljs.core.async.t_cljs$core$async49317(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args49326 = [];
var len__10375__auto___49329 = arguments.length;
var i__10376__auto___49330 = (0);
while(true){
if((i__10376__auto___49330 < len__10375__auto___49329)){
args49326.push((arguments[i__10376__auto___49330]));

var G__49331 = (i__10376__auto___49330 + (1));
i__10376__auto___49330 = G__49331;
continue;
} else {
}
break;
}

var G__49328 = args49326.length;
switch (G__49328) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args49326.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buffer must be supplied when transducer is"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args49333 = [];
var len__10375__auto___49336 = arguments.length;
var i__10376__auto___49337 = (0);
while(true){
if((i__10376__auto___49337 < len__10375__auto___49336)){
args49333.push((arguments[i__10376__auto___49337]));

var G__49338 = (i__10376__auto___49337 + (1));
i__10376__auto___49337 = G__49338;
continue;
} else {
}
break;
}

var G__49335 = args49333.length;
switch (G__49335) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args49333.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args49340 = [];
var len__10375__auto___49343 = arguments.length;
var i__10376__auto___49344 = (0);
while(true){
if((i__10376__auto___49344 < len__10375__auto___49343)){
args49340.push((arguments[i__10376__auto___49344]));

var G__49345 = (i__10376__auto___49344 + (1));
i__10376__auto___49344 = G__49345;
continue;
} else {
}
break;
}

var G__49342 = args49340.length;
switch (G__49342) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args49340.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_49347 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_49347);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_49347,ret){
return (function (){
return fn1.call(null,val_49347);
});})(val_49347,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args49348 = [];
var len__10375__auto___49351 = arguments.length;
var i__10376__auto___49352 = (0);
while(true){
if((i__10376__auto___49352 < len__10375__auto___49351)){
args49348.push((arguments[i__10376__auto___49352]));

var G__49353 = (i__10376__auto___49352 + (1));
i__10376__auto___49352 = G__49353;
continue;
} else {
}
break;
}

var G__49350 = args49348.length;
switch (G__49350) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args49348.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__6736__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__6736__auto__)){
var ret = temp__6736__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__6736__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__6736__auto__)){
var retb = temp__6736__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__6736__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__6736__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__10175__auto___49355 = n;
var x_49356 = (0);
while(true){
if((x_49356 < n__10175__auto___49355)){
(a[x_49356] = (0));

var G__49357 = (x_49356 + (1));
x_49356 = G__49357;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__49358 = (i + (1));
i = G__49358;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async49362 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async49362 = (function (flag,meta49363){
this.flag = flag;
this.meta49363 = meta49363;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async49362.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_49364,meta49363__$1){
var self__ = this;
var _49364__$1 = this;
return (new cljs.core.async.t_cljs$core$async49362(self__.flag,meta49363__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async49362.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_49364){
var self__ = this;
var _49364__$1 = this;
return self__.meta49363;
});})(flag))
;

cljs.core.async.t_cljs$core$async49362.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async49362.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async49362.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async49362.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async49362.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta49363","meta49363",490613593,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async49362.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async49362.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async49362";

cljs.core.async.t_cljs$core$async49362.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__9811__auto__,writer__9812__auto__,opt__9813__auto__){
return cljs.core._write.call(null,writer__9812__auto__,"cljs.core.async/t_cljs$core$async49362");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async49362 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async49362(flag__$1,meta49363){
return (new cljs.core.async.t_cljs$core$async49362(flag__$1,meta49363));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async49362(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async49368 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async49368 = (function (flag,cb,meta49369){
this.flag = flag;
this.cb = cb;
this.meta49369 = meta49369;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async49368.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_49370,meta49369__$1){
var self__ = this;
var _49370__$1 = this;
return (new cljs.core.async.t_cljs$core$async49368(self__.flag,self__.cb,meta49369__$1));
});

cljs.core.async.t_cljs$core$async49368.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_49370){
var self__ = this;
var _49370__$1 = this;
return self__.meta49369;
});

cljs.core.async.t_cljs$core$async49368.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async49368.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async49368.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async49368.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async49368.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta49369","meta49369",292243924,null)], null);
});

cljs.core.async.t_cljs$core$async49368.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async49368.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async49368";

cljs.core.async.t_cljs$core$async49368.cljs$lang$ctorPrWriter = (function (this__9811__auto__,writer__9812__auto__,opt__9813__auto__){
return cljs.core._write.call(null,writer__9812__auto__,"cljs.core.async/t_cljs$core$async49368");
});

cljs.core.async.__GT_t_cljs$core$async49368 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async49368(flag__$1,cb__$1,meta49369){
return (new cljs.core.async.t_cljs$core$async49368(flag__$1,cb__$1,meta49369));
});

}

return (new cljs.core.async.t_cljs$core$async49368(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__49371_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__49371_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__49372_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__49372_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__9154__auto__ = wport;
if(cljs.core.truth_(or__9154__auto__)){
return or__9154__auto__;
} else {
return port;
}
})()], null));
} else {
var G__49373 = (i + (1));
i = G__49373;
continue;
}
} else {
return null;
}
break;
}
})();
var or__9154__auto__ = ret;
if(cljs.core.truth_(or__9154__auto__)){
return or__9154__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__6738__auto__ = (function (){var and__9142__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__9142__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__9142__auto__;
}
})();
if(cljs.core.truth_(temp__6738__auto__)){
var got = temp__6738__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__10382__auto__ = [];
var len__10375__auto___49379 = arguments.length;
var i__10376__auto___49380 = (0);
while(true){
if((i__10376__auto___49380 < len__10375__auto___49379)){
args__10382__auto__.push((arguments[i__10376__auto___49380]));

var G__49381 = (i__10376__auto___49380 + (1));
i__10376__auto___49380 = G__49381;
continue;
} else {
}
break;
}

var argseq__10383__auto__ = ((((1) < args__10382__auto__.length))?(new cljs.core.IndexedSeq(args__10382__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10383__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__49376){
var map__49377 = p__49376;
var map__49377__$1 = ((((!((map__49377 == null)))?((((map__49377.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49377.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49377):map__49377);
var opts = map__49377__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq49374){
var G__49375 = cljs.core.first.call(null,seq49374);
var seq49374__$1 = cljs.core.next.call(null,seq49374);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__49375,seq49374__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args49382 = [];
var len__10375__auto___49432 = arguments.length;
var i__10376__auto___49433 = (0);
while(true){
if((i__10376__auto___49433 < len__10375__auto___49432)){
args49382.push((arguments[i__10376__auto___49433]));

var G__49434 = (i__10376__auto___49433 + (1));
i__10376__auto___49433 = G__49434;
continue;
} else {
}
break;
}

var G__49384 = args49382.length;
switch (G__49384) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args49382.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__33866__auto___49436 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33866__auto___49436){
return (function (){
var f__33867__auto__ = (function (){var switch__33843__auto__ = ((function (c__33866__auto___49436){
return (function (state_49408){
var state_val_49409 = (state_49408[(1)]);
if((state_val_49409 === (7))){
var inst_49404 = (state_49408[(2)]);
var state_49408__$1 = state_49408;
var statearr_49410_49437 = state_49408__$1;
(statearr_49410_49437[(2)] = inst_49404);

(statearr_49410_49437[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49409 === (1))){
var state_49408__$1 = state_49408;
var statearr_49411_49438 = state_49408__$1;
(statearr_49411_49438[(2)] = null);

(statearr_49411_49438[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49409 === (4))){
var inst_49387 = (state_49408[(7)]);
var inst_49387__$1 = (state_49408[(2)]);
var inst_49388 = (inst_49387__$1 == null);
var state_49408__$1 = (function (){var statearr_49412 = state_49408;
(statearr_49412[(7)] = inst_49387__$1);

return statearr_49412;
})();
if(cljs.core.truth_(inst_49388)){
var statearr_49413_49439 = state_49408__$1;
(statearr_49413_49439[(1)] = (5));

} else {
var statearr_49414_49440 = state_49408__$1;
(statearr_49414_49440[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49409 === (13))){
var state_49408__$1 = state_49408;
var statearr_49415_49441 = state_49408__$1;
(statearr_49415_49441[(2)] = null);

(statearr_49415_49441[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49409 === (6))){
var inst_49387 = (state_49408[(7)]);
var state_49408__$1 = state_49408;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_49408__$1,(11),to,inst_49387);
} else {
if((state_val_49409 === (3))){
var inst_49406 = (state_49408[(2)]);
var state_49408__$1 = state_49408;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_49408__$1,inst_49406);
} else {
if((state_val_49409 === (12))){
var state_49408__$1 = state_49408;
var statearr_49416_49442 = state_49408__$1;
(statearr_49416_49442[(2)] = null);

(statearr_49416_49442[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49409 === (2))){
var state_49408__$1 = state_49408;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_49408__$1,(4),from);
} else {
if((state_val_49409 === (11))){
var inst_49397 = (state_49408[(2)]);
var state_49408__$1 = state_49408;
if(cljs.core.truth_(inst_49397)){
var statearr_49417_49443 = state_49408__$1;
(statearr_49417_49443[(1)] = (12));

} else {
var statearr_49418_49444 = state_49408__$1;
(statearr_49418_49444[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49409 === (9))){
var state_49408__$1 = state_49408;
var statearr_49419_49445 = state_49408__$1;
(statearr_49419_49445[(2)] = null);

(statearr_49419_49445[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49409 === (5))){
var state_49408__$1 = state_49408;
if(cljs.core.truth_(close_QMARK_)){
var statearr_49420_49446 = state_49408__$1;
(statearr_49420_49446[(1)] = (8));

} else {
var statearr_49421_49447 = state_49408__$1;
(statearr_49421_49447[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49409 === (14))){
var inst_49402 = (state_49408[(2)]);
var state_49408__$1 = state_49408;
var statearr_49422_49448 = state_49408__$1;
(statearr_49422_49448[(2)] = inst_49402);

(statearr_49422_49448[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49409 === (10))){
var inst_49394 = (state_49408[(2)]);
var state_49408__$1 = state_49408;
var statearr_49423_49449 = state_49408__$1;
(statearr_49423_49449[(2)] = inst_49394);

(statearr_49423_49449[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49409 === (8))){
var inst_49391 = cljs.core.async.close_BANG_.call(null,to);
var state_49408__$1 = state_49408;
var statearr_49424_49450 = state_49408__$1;
(statearr_49424_49450[(2)] = inst_49391);

(statearr_49424_49450[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33866__auto___49436))
;
return ((function (switch__33843__auto__,c__33866__auto___49436){
return (function() {
var cljs$core$async$state_machine__33844__auto__ = null;
var cljs$core$async$state_machine__33844__auto____0 = (function (){
var statearr_49428 = [null,null,null,null,null,null,null,null];
(statearr_49428[(0)] = cljs$core$async$state_machine__33844__auto__);

(statearr_49428[(1)] = (1));

return statearr_49428;
});
var cljs$core$async$state_machine__33844__auto____1 = (function (state_49408){
while(true){
var ret_value__33845__auto__ = (function (){try{while(true){
var result__33846__auto__ = switch__33843__auto__.call(null,state_49408);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33846__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33846__auto__;
}
break;
}
}catch (e49429){if((e49429 instanceof Object)){
var ex__33847__auto__ = e49429;
var statearr_49430_49451 = state_49408;
(statearr_49430_49451[(5)] = ex__33847__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_49408);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e49429;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33845__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49452 = state_49408;
state_49408 = G__49452;
continue;
} else {
return ret_value__33845__auto__;
}
break;
}
});
cljs$core$async$state_machine__33844__auto__ = function(state_49408){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33844__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33844__auto____1.call(this,state_49408);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33844__auto____0;
cljs$core$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33844__auto____1;
return cljs$core$async$state_machine__33844__auto__;
})()
;})(switch__33843__auto__,c__33866__auto___49436))
})();
var state__33868__auto__ = (function (){var statearr_49431 = f__33867__auto__.call(null);
(statearr_49431[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33866__auto___49436);

return statearr_49431;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33868__auto__);
});})(c__33866__auto___49436))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__49640){
var vec__49641 = p__49640;
var v = cljs.core.nth.call(null,vec__49641,(0),null);
var p = cljs.core.nth.call(null,vec__49641,(1),null);
var job = vec__49641;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__33866__auto___49827 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33866__auto___49827,res,vec__49641,v,p,job,jobs,results){
return (function (){
var f__33867__auto__ = (function (){var switch__33843__auto__ = ((function (c__33866__auto___49827,res,vec__49641,v,p,job,jobs,results){
return (function (state_49648){
var state_val_49649 = (state_49648[(1)]);
if((state_val_49649 === (1))){
var state_49648__$1 = state_49648;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_49648__$1,(2),res,v);
} else {
if((state_val_49649 === (2))){
var inst_49645 = (state_49648[(2)]);
var inst_49646 = cljs.core.async.close_BANG_.call(null,res);
var state_49648__$1 = (function (){var statearr_49650 = state_49648;
(statearr_49650[(7)] = inst_49645);

return statearr_49650;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_49648__$1,inst_49646);
} else {
return null;
}
}
});})(c__33866__auto___49827,res,vec__49641,v,p,job,jobs,results))
;
return ((function (switch__33843__auto__,c__33866__auto___49827,res,vec__49641,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__33844__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__33844__auto____0 = (function (){
var statearr_49654 = [null,null,null,null,null,null,null,null];
(statearr_49654[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__33844__auto__);

(statearr_49654[(1)] = (1));

return statearr_49654;
});
var cljs$core$async$pipeline_STAR__$_state_machine__33844__auto____1 = (function (state_49648){
while(true){
var ret_value__33845__auto__ = (function (){try{while(true){
var result__33846__auto__ = switch__33843__auto__.call(null,state_49648);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33846__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33846__auto__;
}
break;
}
}catch (e49655){if((e49655 instanceof Object)){
var ex__33847__auto__ = e49655;
var statearr_49656_49828 = state_49648;
(statearr_49656_49828[(5)] = ex__33847__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_49648);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e49655;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33845__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49829 = state_49648;
state_49648 = G__49829;
continue;
} else {
return ret_value__33845__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__33844__auto__ = function(state_49648){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__33844__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__33844__auto____1.call(this,state_49648);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__33844__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__33844__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__33844__auto__;
})()
;})(switch__33843__auto__,c__33866__auto___49827,res,vec__49641,v,p,job,jobs,results))
})();
var state__33868__auto__ = (function (){var statearr_49657 = f__33867__auto__.call(null);
(statearr_49657[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33866__auto___49827);

return statearr_49657;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33868__auto__);
});})(c__33866__auto___49827,res,vec__49641,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__49658){
var vec__49659 = p__49658;
var v = cljs.core.nth.call(null,vec__49659,(0),null);
var p = cljs.core.nth.call(null,vec__49659,(1),null);
var job = vec__49659;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__10175__auto___49830 = n;
var __49831 = (0);
while(true){
if((__49831 < n__10175__auto___49830)){
var G__49662_49832 = type;
var G__49662_49833__$1 = (((G__49662_49832 instanceof cljs.core.Keyword))?G__49662_49832.fqn:null);
switch (G__49662_49833__$1) {
case "compute":
var c__33866__auto___49835 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__49831,c__33866__auto___49835,G__49662_49832,G__49662_49833__$1,n__10175__auto___49830,jobs,results,process,async){
return (function (){
var f__33867__auto__ = (function (){var switch__33843__auto__ = ((function (__49831,c__33866__auto___49835,G__49662_49832,G__49662_49833__$1,n__10175__auto___49830,jobs,results,process,async){
return (function (state_49675){
var state_val_49676 = (state_49675[(1)]);
if((state_val_49676 === (1))){
var state_49675__$1 = state_49675;
var statearr_49677_49836 = state_49675__$1;
(statearr_49677_49836[(2)] = null);

(statearr_49677_49836[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49676 === (2))){
var state_49675__$1 = state_49675;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_49675__$1,(4),jobs);
} else {
if((state_val_49676 === (3))){
var inst_49673 = (state_49675[(2)]);
var state_49675__$1 = state_49675;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_49675__$1,inst_49673);
} else {
if((state_val_49676 === (4))){
var inst_49665 = (state_49675[(2)]);
var inst_49666 = process.call(null,inst_49665);
var state_49675__$1 = state_49675;
if(cljs.core.truth_(inst_49666)){
var statearr_49678_49837 = state_49675__$1;
(statearr_49678_49837[(1)] = (5));

} else {
var statearr_49679_49838 = state_49675__$1;
(statearr_49679_49838[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49676 === (5))){
var state_49675__$1 = state_49675;
var statearr_49680_49839 = state_49675__$1;
(statearr_49680_49839[(2)] = null);

(statearr_49680_49839[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49676 === (6))){
var state_49675__$1 = state_49675;
var statearr_49681_49840 = state_49675__$1;
(statearr_49681_49840[(2)] = null);

(statearr_49681_49840[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49676 === (7))){
var inst_49671 = (state_49675[(2)]);
var state_49675__$1 = state_49675;
var statearr_49682_49841 = state_49675__$1;
(statearr_49682_49841[(2)] = inst_49671);

(statearr_49682_49841[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__49831,c__33866__auto___49835,G__49662_49832,G__49662_49833__$1,n__10175__auto___49830,jobs,results,process,async))
;
return ((function (__49831,switch__33843__auto__,c__33866__auto___49835,G__49662_49832,G__49662_49833__$1,n__10175__auto___49830,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__33844__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__33844__auto____0 = (function (){
var statearr_49686 = [null,null,null,null,null,null,null];
(statearr_49686[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__33844__auto__);

(statearr_49686[(1)] = (1));

return statearr_49686;
});
var cljs$core$async$pipeline_STAR__$_state_machine__33844__auto____1 = (function (state_49675){
while(true){
var ret_value__33845__auto__ = (function (){try{while(true){
var result__33846__auto__ = switch__33843__auto__.call(null,state_49675);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33846__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33846__auto__;
}
break;
}
}catch (e49687){if((e49687 instanceof Object)){
var ex__33847__auto__ = e49687;
var statearr_49688_49842 = state_49675;
(statearr_49688_49842[(5)] = ex__33847__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_49675);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e49687;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33845__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49843 = state_49675;
state_49675 = G__49843;
continue;
} else {
return ret_value__33845__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__33844__auto__ = function(state_49675){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__33844__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__33844__auto____1.call(this,state_49675);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__33844__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__33844__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__33844__auto__;
})()
;})(__49831,switch__33843__auto__,c__33866__auto___49835,G__49662_49832,G__49662_49833__$1,n__10175__auto___49830,jobs,results,process,async))
})();
var state__33868__auto__ = (function (){var statearr_49689 = f__33867__auto__.call(null);
(statearr_49689[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33866__auto___49835);

return statearr_49689;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33868__auto__);
});})(__49831,c__33866__auto___49835,G__49662_49832,G__49662_49833__$1,n__10175__auto___49830,jobs,results,process,async))
);


break;
case "async":
var c__33866__auto___49844 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__49831,c__33866__auto___49844,G__49662_49832,G__49662_49833__$1,n__10175__auto___49830,jobs,results,process,async){
return (function (){
var f__33867__auto__ = (function (){var switch__33843__auto__ = ((function (__49831,c__33866__auto___49844,G__49662_49832,G__49662_49833__$1,n__10175__auto___49830,jobs,results,process,async){
return (function (state_49702){
var state_val_49703 = (state_49702[(1)]);
if((state_val_49703 === (1))){
var state_49702__$1 = state_49702;
var statearr_49704_49845 = state_49702__$1;
(statearr_49704_49845[(2)] = null);

(statearr_49704_49845[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49703 === (2))){
var state_49702__$1 = state_49702;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_49702__$1,(4),jobs);
} else {
if((state_val_49703 === (3))){
var inst_49700 = (state_49702[(2)]);
var state_49702__$1 = state_49702;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_49702__$1,inst_49700);
} else {
if((state_val_49703 === (4))){
var inst_49692 = (state_49702[(2)]);
var inst_49693 = async.call(null,inst_49692);
var state_49702__$1 = state_49702;
if(cljs.core.truth_(inst_49693)){
var statearr_49705_49846 = state_49702__$1;
(statearr_49705_49846[(1)] = (5));

} else {
var statearr_49706_49847 = state_49702__$1;
(statearr_49706_49847[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49703 === (5))){
var state_49702__$1 = state_49702;
var statearr_49707_49848 = state_49702__$1;
(statearr_49707_49848[(2)] = null);

(statearr_49707_49848[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49703 === (6))){
var state_49702__$1 = state_49702;
var statearr_49708_49849 = state_49702__$1;
(statearr_49708_49849[(2)] = null);

(statearr_49708_49849[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49703 === (7))){
var inst_49698 = (state_49702[(2)]);
var state_49702__$1 = state_49702;
var statearr_49709_49850 = state_49702__$1;
(statearr_49709_49850[(2)] = inst_49698);

(statearr_49709_49850[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__49831,c__33866__auto___49844,G__49662_49832,G__49662_49833__$1,n__10175__auto___49830,jobs,results,process,async))
;
return ((function (__49831,switch__33843__auto__,c__33866__auto___49844,G__49662_49832,G__49662_49833__$1,n__10175__auto___49830,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__33844__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__33844__auto____0 = (function (){
var statearr_49713 = [null,null,null,null,null,null,null];
(statearr_49713[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__33844__auto__);

(statearr_49713[(1)] = (1));

return statearr_49713;
});
var cljs$core$async$pipeline_STAR__$_state_machine__33844__auto____1 = (function (state_49702){
while(true){
var ret_value__33845__auto__ = (function (){try{while(true){
var result__33846__auto__ = switch__33843__auto__.call(null,state_49702);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33846__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33846__auto__;
}
break;
}
}catch (e49714){if((e49714 instanceof Object)){
var ex__33847__auto__ = e49714;
var statearr_49715_49851 = state_49702;
(statearr_49715_49851[(5)] = ex__33847__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_49702);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e49714;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33845__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49852 = state_49702;
state_49702 = G__49852;
continue;
} else {
return ret_value__33845__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__33844__auto__ = function(state_49702){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__33844__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__33844__auto____1.call(this,state_49702);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__33844__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__33844__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__33844__auto__;
})()
;})(__49831,switch__33843__auto__,c__33866__auto___49844,G__49662_49832,G__49662_49833__$1,n__10175__auto___49830,jobs,results,process,async))
})();
var state__33868__auto__ = (function (){var statearr_49716 = f__33867__auto__.call(null);
(statearr_49716[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33866__auto___49844);

return statearr_49716;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33868__auto__);
});})(__49831,c__33866__auto___49844,G__49662_49832,G__49662_49833__$1,n__10175__auto___49830,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join('')));

}

var G__49853 = (__49831 + (1));
__49831 = G__49853;
continue;
} else {
}
break;
}

var c__33866__auto___49854 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33866__auto___49854,jobs,results,process,async){
return (function (){
var f__33867__auto__ = (function (){var switch__33843__auto__ = ((function (c__33866__auto___49854,jobs,results,process,async){
return (function (state_49738){
var state_val_49739 = (state_49738[(1)]);
if((state_val_49739 === (1))){
var state_49738__$1 = state_49738;
var statearr_49740_49855 = state_49738__$1;
(statearr_49740_49855[(2)] = null);

(statearr_49740_49855[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49739 === (2))){
var state_49738__$1 = state_49738;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_49738__$1,(4),from);
} else {
if((state_val_49739 === (3))){
var inst_49736 = (state_49738[(2)]);
var state_49738__$1 = state_49738;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_49738__$1,inst_49736);
} else {
if((state_val_49739 === (4))){
var inst_49719 = (state_49738[(7)]);
var inst_49719__$1 = (state_49738[(2)]);
var inst_49720 = (inst_49719__$1 == null);
var state_49738__$1 = (function (){var statearr_49741 = state_49738;
(statearr_49741[(7)] = inst_49719__$1);

return statearr_49741;
})();
if(cljs.core.truth_(inst_49720)){
var statearr_49742_49856 = state_49738__$1;
(statearr_49742_49856[(1)] = (5));

} else {
var statearr_49743_49857 = state_49738__$1;
(statearr_49743_49857[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49739 === (5))){
var inst_49722 = cljs.core.async.close_BANG_.call(null,jobs);
var state_49738__$1 = state_49738;
var statearr_49744_49858 = state_49738__$1;
(statearr_49744_49858[(2)] = inst_49722);

(statearr_49744_49858[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49739 === (6))){
var inst_49719 = (state_49738[(7)]);
var inst_49724 = (state_49738[(8)]);
var inst_49724__$1 = cljs.core.async.chan.call(null,(1));
var inst_49725 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_49726 = [inst_49719,inst_49724__$1];
var inst_49727 = (new cljs.core.PersistentVector(null,2,(5),inst_49725,inst_49726,null));
var state_49738__$1 = (function (){var statearr_49745 = state_49738;
(statearr_49745[(8)] = inst_49724__$1);

return statearr_49745;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_49738__$1,(8),jobs,inst_49727);
} else {
if((state_val_49739 === (7))){
var inst_49734 = (state_49738[(2)]);
var state_49738__$1 = state_49738;
var statearr_49746_49859 = state_49738__$1;
(statearr_49746_49859[(2)] = inst_49734);

(statearr_49746_49859[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49739 === (8))){
var inst_49724 = (state_49738[(8)]);
var inst_49729 = (state_49738[(2)]);
var state_49738__$1 = (function (){var statearr_49747 = state_49738;
(statearr_49747[(9)] = inst_49729);

return statearr_49747;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_49738__$1,(9),results,inst_49724);
} else {
if((state_val_49739 === (9))){
var inst_49731 = (state_49738[(2)]);
var state_49738__$1 = (function (){var statearr_49748 = state_49738;
(statearr_49748[(10)] = inst_49731);

return statearr_49748;
})();
var statearr_49749_49860 = state_49738__$1;
(statearr_49749_49860[(2)] = null);

(statearr_49749_49860[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__33866__auto___49854,jobs,results,process,async))
;
return ((function (switch__33843__auto__,c__33866__auto___49854,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__33844__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__33844__auto____0 = (function (){
var statearr_49753 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_49753[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__33844__auto__);

(statearr_49753[(1)] = (1));

return statearr_49753;
});
var cljs$core$async$pipeline_STAR__$_state_machine__33844__auto____1 = (function (state_49738){
while(true){
var ret_value__33845__auto__ = (function (){try{while(true){
var result__33846__auto__ = switch__33843__auto__.call(null,state_49738);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33846__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33846__auto__;
}
break;
}
}catch (e49754){if((e49754 instanceof Object)){
var ex__33847__auto__ = e49754;
var statearr_49755_49861 = state_49738;
(statearr_49755_49861[(5)] = ex__33847__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_49738);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e49754;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33845__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49862 = state_49738;
state_49738 = G__49862;
continue;
} else {
return ret_value__33845__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__33844__auto__ = function(state_49738){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__33844__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__33844__auto____1.call(this,state_49738);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__33844__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__33844__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__33844__auto__;
})()
;})(switch__33843__auto__,c__33866__auto___49854,jobs,results,process,async))
})();
var state__33868__auto__ = (function (){var statearr_49756 = f__33867__auto__.call(null);
(statearr_49756[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33866__auto___49854);

return statearr_49756;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33868__auto__);
});})(c__33866__auto___49854,jobs,results,process,async))
);


var c__33866__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33866__auto__,jobs,results,process,async){
return (function (){
var f__33867__auto__ = (function (){var switch__33843__auto__ = ((function (c__33866__auto__,jobs,results,process,async){
return (function (state_49794){
var state_val_49795 = (state_49794[(1)]);
if((state_val_49795 === (7))){
var inst_49790 = (state_49794[(2)]);
var state_49794__$1 = state_49794;
var statearr_49796_49863 = state_49794__$1;
(statearr_49796_49863[(2)] = inst_49790);

(statearr_49796_49863[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49795 === (20))){
var state_49794__$1 = state_49794;
var statearr_49797_49864 = state_49794__$1;
(statearr_49797_49864[(2)] = null);

(statearr_49797_49864[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49795 === (1))){
var state_49794__$1 = state_49794;
var statearr_49798_49865 = state_49794__$1;
(statearr_49798_49865[(2)] = null);

(statearr_49798_49865[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49795 === (4))){
var inst_49759 = (state_49794[(7)]);
var inst_49759__$1 = (state_49794[(2)]);
var inst_49760 = (inst_49759__$1 == null);
var state_49794__$1 = (function (){var statearr_49799 = state_49794;
(statearr_49799[(7)] = inst_49759__$1);

return statearr_49799;
})();
if(cljs.core.truth_(inst_49760)){
var statearr_49800_49866 = state_49794__$1;
(statearr_49800_49866[(1)] = (5));

} else {
var statearr_49801_49867 = state_49794__$1;
(statearr_49801_49867[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49795 === (15))){
var inst_49772 = (state_49794[(8)]);
var state_49794__$1 = state_49794;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_49794__$1,(18),to,inst_49772);
} else {
if((state_val_49795 === (21))){
var inst_49785 = (state_49794[(2)]);
var state_49794__$1 = state_49794;
var statearr_49802_49868 = state_49794__$1;
(statearr_49802_49868[(2)] = inst_49785);

(statearr_49802_49868[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49795 === (13))){
var inst_49787 = (state_49794[(2)]);
var state_49794__$1 = (function (){var statearr_49803 = state_49794;
(statearr_49803[(9)] = inst_49787);

return statearr_49803;
})();
var statearr_49804_49869 = state_49794__$1;
(statearr_49804_49869[(2)] = null);

(statearr_49804_49869[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49795 === (6))){
var inst_49759 = (state_49794[(7)]);
var state_49794__$1 = state_49794;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_49794__$1,(11),inst_49759);
} else {
if((state_val_49795 === (17))){
var inst_49780 = (state_49794[(2)]);
var state_49794__$1 = state_49794;
if(cljs.core.truth_(inst_49780)){
var statearr_49805_49870 = state_49794__$1;
(statearr_49805_49870[(1)] = (19));

} else {
var statearr_49806_49871 = state_49794__$1;
(statearr_49806_49871[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49795 === (3))){
var inst_49792 = (state_49794[(2)]);
var state_49794__$1 = state_49794;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_49794__$1,inst_49792);
} else {
if((state_val_49795 === (12))){
var inst_49769 = (state_49794[(10)]);
var state_49794__$1 = state_49794;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_49794__$1,(14),inst_49769);
} else {
if((state_val_49795 === (2))){
var state_49794__$1 = state_49794;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_49794__$1,(4),results);
} else {
if((state_val_49795 === (19))){
var state_49794__$1 = state_49794;
var statearr_49807_49872 = state_49794__$1;
(statearr_49807_49872[(2)] = null);

(statearr_49807_49872[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49795 === (11))){
var inst_49769 = (state_49794[(2)]);
var state_49794__$1 = (function (){var statearr_49808 = state_49794;
(statearr_49808[(10)] = inst_49769);

return statearr_49808;
})();
var statearr_49809_49873 = state_49794__$1;
(statearr_49809_49873[(2)] = null);

(statearr_49809_49873[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49795 === (9))){
var state_49794__$1 = state_49794;
var statearr_49810_49874 = state_49794__$1;
(statearr_49810_49874[(2)] = null);

(statearr_49810_49874[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49795 === (5))){
var state_49794__$1 = state_49794;
if(cljs.core.truth_(close_QMARK_)){
var statearr_49811_49875 = state_49794__$1;
(statearr_49811_49875[(1)] = (8));

} else {
var statearr_49812_49876 = state_49794__$1;
(statearr_49812_49876[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49795 === (14))){
var inst_49772 = (state_49794[(8)]);
var inst_49774 = (state_49794[(11)]);
var inst_49772__$1 = (state_49794[(2)]);
var inst_49773 = (inst_49772__$1 == null);
var inst_49774__$1 = cljs.core.not.call(null,inst_49773);
var state_49794__$1 = (function (){var statearr_49813 = state_49794;
(statearr_49813[(8)] = inst_49772__$1);

(statearr_49813[(11)] = inst_49774__$1);

return statearr_49813;
})();
if(inst_49774__$1){
var statearr_49814_49877 = state_49794__$1;
(statearr_49814_49877[(1)] = (15));

} else {
var statearr_49815_49878 = state_49794__$1;
(statearr_49815_49878[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49795 === (16))){
var inst_49774 = (state_49794[(11)]);
var state_49794__$1 = state_49794;
var statearr_49816_49879 = state_49794__$1;
(statearr_49816_49879[(2)] = inst_49774);

(statearr_49816_49879[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49795 === (10))){
var inst_49766 = (state_49794[(2)]);
var state_49794__$1 = state_49794;
var statearr_49817_49880 = state_49794__$1;
(statearr_49817_49880[(2)] = inst_49766);

(statearr_49817_49880[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49795 === (18))){
var inst_49777 = (state_49794[(2)]);
var state_49794__$1 = state_49794;
var statearr_49818_49881 = state_49794__$1;
(statearr_49818_49881[(2)] = inst_49777);

(statearr_49818_49881[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49795 === (8))){
var inst_49763 = cljs.core.async.close_BANG_.call(null,to);
var state_49794__$1 = state_49794;
var statearr_49819_49882 = state_49794__$1;
(statearr_49819_49882[(2)] = inst_49763);

(statearr_49819_49882[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33866__auto__,jobs,results,process,async))
;
return ((function (switch__33843__auto__,c__33866__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__33844__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__33844__auto____0 = (function (){
var statearr_49823 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_49823[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__33844__auto__);

(statearr_49823[(1)] = (1));

return statearr_49823;
});
var cljs$core$async$pipeline_STAR__$_state_machine__33844__auto____1 = (function (state_49794){
while(true){
var ret_value__33845__auto__ = (function (){try{while(true){
var result__33846__auto__ = switch__33843__auto__.call(null,state_49794);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33846__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33846__auto__;
}
break;
}
}catch (e49824){if((e49824 instanceof Object)){
var ex__33847__auto__ = e49824;
var statearr_49825_49883 = state_49794;
(statearr_49825_49883[(5)] = ex__33847__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_49794);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e49824;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33845__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49884 = state_49794;
state_49794 = G__49884;
continue;
} else {
return ret_value__33845__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__33844__auto__ = function(state_49794){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__33844__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__33844__auto____1.call(this,state_49794);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__33844__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__33844__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__33844__auto__;
})()
;})(switch__33843__auto__,c__33866__auto__,jobs,results,process,async))
})();
var state__33868__auto__ = (function (){var statearr_49826 = f__33867__auto__.call(null);
(statearr_49826[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33866__auto__);

return statearr_49826;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33868__auto__);
});})(c__33866__auto__,jobs,results,process,async))
);

return c__33866__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args49885 = [];
var len__10375__auto___49888 = arguments.length;
var i__10376__auto___49889 = (0);
while(true){
if((i__10376__auto___49889 < len__10375__auto___49888)){
args49885.push((arguments[i__10376__auto___49889]));

var G__49890 = (i__10376__auto___49889 + (1));
i__10376__auto___49889 = G__49890;
continue;
} else {
}
break;
}

var G__49887 = args49885.length;
switch (G__49887) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args49885.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args49892 = [];
var len__10375__auto___49895 = arguments.length;
var i__10376__auto___49896 = (0);
while(true){
if((i__10376__auto___49896 < len__10375__auto___49895)){
args49892.push((arguments[i__10376__auto___49896]));

var G__49897 = (i__10376__auto___49896 + (1));
i__10376__auto___49896 = G__49897;
continue;
} else {
}
break;
}

var G__49894 = args49892.length;
switch (G__49894) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args49892.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args49899 = [];
var len__10375__auto___49952 = arguments.length;
var i__10376__auto___49953 = (0);
while(true){
if((i__10376__auto___49953 < len__10375__auto___49952)){
args49899.push((arguments[i__10376__auto___49953]));

var G__49954 = (i__10376__auto___49953 + (1));
i__10376__auto___49953 = G__49954;
continue;
} else {
}
break;
}

var G__49901 = args49899.length;
switch (G__49901) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args49899.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__33866__auto___49956 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33866__auto___49956,tc,fc){
return (function (){
var f__33867__auto__ = (function (){var switch__33843__auto__ = ((function (c__33866__auto___49956,tc,fc){
return (function (state_49927){
var state_val_49928 = (state_49927[(1)]);
if((state_val_49928 === (7))){
var inst_49923 = (state_49927[(2)]);
var state_49927__$1 = state_49927;
var statearr_49929_49957 = state_49927__$1;
(statearr_49929_49957[(2)] = inst_49923);

(statearr_49929_49957[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49928 === (1))){
var state_49927__$1 = state_49927;
var statearr_49930_49958 = state_49927__$1;
(statearr_49930_49958[(2)] = null);

(statearr_49930_49958[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49928 === (4))){
var inst_49904 = (state_49927[(7)]);
var inst_49904__$1 = (state_49927[(2)]);
var inst_49905 = (inst_49904__$1 == null);
var state_49927__$1 = (function (){var statearr_49931 = state_49927;
(statearr_49931[(7)] = inst_49904__$1);

return statearr_49931;
})();
if(cljs.core.truth_(inst_49905)){
var statearr_49932_49959 = state_49927__$1;
(statearr_49932_49959[(1)] = (5));

} else {
var statearr_49933_49960 = state_49927__$1;
(statearr_49933_49960[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49928 === (13))){
var state_49927__$1 = state_49927;
var statearr_49934_49961 = state_49927__$1;
(statearr_49934_49961[(2)] = null);

(statearr_49934_49961[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49928 === (6))){
var inst_49904 = (state_49927[(7)]);
var inst_49910 = p.call(null,inst_49904);
var state_49927__$1 = state_49927;
if(cljs.core.truth_(inst_49910)){
var statearr_49935_49962 = state_49927__$1;
(statearr_49935_49962[(1)] = (9));

} else {
var statearr_49936_49963 = state_49927__$1;
(statearr_49936_49963[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49928 === (3))){
var inst_49925 = (state_49927[(2)]);
var state_49927__$1 = state_49927;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_49927__$1,inst_49925);
} else {
if((state_val_49928 === (12))){
var state_49927__$1 = state_49927;
var statearr_49937_49964 = state_49927__$1;
(statearr_49937_49964[(2)] = null);

(statearr_49937_49964[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49928 === (2))){
var state_49927__$1 = state_49927;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_49927__$1,(4),ch);
} else {
if((state_val_49928 === (11))){
var inst_49904 = (state_49927[(7)]);
var inst_49914 = (state_49927[(2)]);
var state_49927__$1 = state_49927;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_49927__$1,(8),inst_49914,inst_49904);
} else {
if((state_val_49928 === (9))){
var state_49927__$1 = state_49927;
var statearr_49938_49965 = state_49927__$1;
(statearr_49938_49965[(2)] = tc);

(statearr_49938_49965[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49928 === (5))){
var inst_49907 = cljs.core.async.close_BANG_.call(null,tc);
var inst_49908 = cljs.core.async.close_BANG_.call(null,fc);
var state_49927__$1 = (function (){var statearr_49939 = state_49927;
(statearr_49939[(8)] = inst_49907);

return statearr_49939;
})();
var statearr_49940_49966 = state_49927__$1;
(statearr_49940_49966[(2)] = inst_49908);

(statearr_49940_49966[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49928 === (14))){
var inst_49921 = (state_49927[(2)]);
var state_49927__$1 = state_49927;
var statearr_49941_49967 = state_49927__$1;
(statearr_49941_49967[(2)] = inst_49921);

(statearr_49941_49967[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49928 === (10))){
var state_49927__$1 = state_49927;
var statearr_49942_49968 = state_49927__$1;
(statearr_49942_49968[(2)] = fc);

(statearr_49942_49968[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49928 === (8))){
var inst_49916 = (state_49927[(2)]);
var state_49927__$1 = state_49927;
if(cljs.core.truth_(inst_49916)){
var statearr_49943_49969 = state_49927__$1;
(statearr_49943_49969[(1)] = (12));

} else {
var statearr_49944_49970 = state_49927__$1;
(statearr_49944_49970[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33866__auto___49956,tc,fc))
;
return ((function (switch__33843__auto__,c__33866__auto___49956,tc,fc){
return (function() {
var cljs$core$async$state_machine__33844__auto__ = null;
var cljs$core$async$state_machine__33844__auto____0 = (function (){
var statearr_49948 = [null,null,null,null,null,null,null,null,null];
(statearr_49948[(0)] = cljs$core$async$state_machine__33844__auto__);

(statearr_49948[(1)] = (1));

return statearr_49948;
});
var cljs$core$async$state_machine__33844__auto____1 = (function (state_49927){
while(true){
var ret_value__33845__auto__ = (function (){try{while(true){
var result__33846__auto__ = switch__33843__auto__.call(null,state_49927);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33846__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33846__auto__;
}
break;
}
}catch (e49949){if((e49949 instanceof Object)){
var ex__33847__auto__ = e49949;
var statearr_49950_49971 = state_49927;
(statearr_49950_49971[(5)] = ex__33847__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_49927);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e49949;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33845__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49972 = state_49927;
state_49927 = G__49972;
continue;
} else {
return ret_value__33845__auto__;
}
break;
}
});
cljs$core$async$state_machine__33844__auto__ = function(state_49927){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33844__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33844__auto____1.call(this,state_49927);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33844__auto____0;
cljs$core$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33844__auto____1;
return cljs$core$async$state_machine__33844__auto__;
})()
;})(switch__33843__auto__,c__33866__auto___49956,tc,fc))
})();
var state__33868__auto__ = (function (){var statearr_49951 = f__33867__auto__.call(null);
(statearr_49951[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33866__auto___49956);

return statearr_49951;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33868__auto__);
});})(c__33866__auto___49956,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__33866__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33866__auto__){
return (function (){
var f__33867__auto__ = (function (){var switch__33843__auto__ = ((function (c__33866__auto__){
return (function (state_50036){
var state_val_50037 = (state_50036[(1)]);
if((state_val_50037 === (7))){
var inst_50032 = (state_50036[(2)]);
var state_50036__$1 = state_50036;
var statearr_50038_50059 = state_50036__$1;
(statearr_50038_50059[(2)] = inst_50032);

(statearr_50038_50059[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50037 === (1))){
var inst_50016 = init;
var state_50036__$1 = (function (){var statearr_50039 = state_50036;
(statearr_50039[(7)] = inst_50016);

return statearr_50039;
})();
var statearr_50040_50060 = state_50036__$1;
(statearr_50040_50060[(2)] = null);

(statearr_50040_50060[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50037 === (4))){
var inst_50019 = (state_50036[(8)]);
var inst_50019__$1 = (state_50036[(2)]);
var inst_50020 = (inst_50019__$1 == null);
var state_50036__$1 = (function (){var statearr_50041 = state_50036;
(statearr_50041[(8)] = inst_50019__$1);

return statearr_50041;
})();
if(cljs.core.truth_(inst_50020)){
var statearr_50042_50061 = state_50036__$1;
(statearr_50042_50061[(1)] = (5));

} else {
var statearr_50043_50062 = state_50036__$1;
(statearr_50043_50062[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50037 === (6))){
var inst_50019 = (state_50036[(8)]);
var inst_50023 = (state_50036[(9)]);
var inst_50016 = (state_50036[(7)]);
var inst_50023__$1 = f.call(null,inst_50016,inst_50019);
var inst_50024 = cljs.core.reduced_QMARK_.call(null,inst_50023__$1);
var state_50036__$1 = (function (){var statearr_50044 = state_50036;
(statearr_50044[(9)] = inst_50023__$1);

return statearr_50044;
})();
if(inst_50024){
var statearr_50045_50063 = state_50036__$1;
(statearr_50045_50063[(1)] = (8));

} else {
var statearr_50046_50064 = state_50036__$1;
(statearr_50046_50064[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50037 === (3))){
var inst_50034 = (state_50036[(2)]);
var state_50036__$1 = state_50036;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_50036__$1,inst_50034);
} else {
if((state_val_50037 === (2))){
var state_50036__$1 = state_50036;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50036__$1,(4),ch);
} else {
if((state_val_50037 === (9))){
var inst_50023 = (state_50036[(9)]);
var inst_50016 = inst_50023;
var state_50036__$1 = (function (){var statearr_50047 = state_50036;
(statearr_50047[(7)] = inst_50016);

return statearr_50047;
})();
var statearr_50048_50065 = state_50036__$1;
(statearr_50048_50065[(2)] = null);

(statearr_50048_50065[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50037 === (5))){
var inst_50016 = (state_50036[(7)]);
var state_50036__$1 = state_50036;
var statearr_50049_50066 = state_50036__$1;
(statearr_50049_50066[(2)] = inst_50016);

(statearr_50049_50066[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50037 === (10))){
var inst_50030 = (state_50036[(2)]);
var state_50036__$1 = state_50036;
var statearr_50050_50067 = state_50036__$1;
(statearr_50050_50067[(2)] = inst_50030);

(statearr_50050_50067[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50037 === (8))){
var inst_50023 = (state_50036[(9)]);
var inst_50026 = cljs.core.deref.call(null,inst_50023);
var state_50036__$1 = state_50036;
var statearr_50051_50068 = state_50036__$1;
(statearr_50051_50068[(2)] = inst_50026);

(statearr_50051_50068[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__33866__auto__))
;
return ((function (switch__33843__auto__,c__33866__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__33844__auto__ = null;
var cljs$core$async$reduce_$_state_machine__33844__auto____0 = (function (){
var statearr_50055 = [null,null,null,null,null,null,null,null,null,null];
(statearr_50055[(0)] = cljs$core$async$reduce_$_state_machine__33844__auto__);

(statearr_50055[(1)] = (1));

return statearr_50055;
});
var cljs$core$async$reduce_$_state_machine__33844__auto____1 = (function (state_50036){
while(true){
var ret_value__33845__auto__ = (function (){try{while(true){
var result__33846__auto__ = switch__33843__auto__.call(null,state_50036);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33846__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33846__auto__;
}
break;
}
}catch (e50056){if((e50056 instanceof Object)){
var ex__33847__auto__ = e50056;
var statearr_50057_50069 = state_50036;
(statearr_50057_50069[(5)] = ex__33847__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_50036);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e50056;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33845__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50070 = state_50036;
state_50036 = G__50070;
continue;
} else {
return ret_value__33845__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__33844__auto__ = function(state_50036){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__33844__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__33844__auto____1.call(this,state_50036);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__33844__auto____0;
cljs$core$async$reduce_$_state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__33844__auto____1;
return cljs$core$async$reduce_$_state_machine__33844__auto__;
})()
;})(switch__33843__auto__,c__33866__auto__))
})();
var state__33868__auto__ = (function (){var statearr_50058 = f__33867__auto__.call(null);
(statearr_50058[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33866__auto__);

return statearr_50058;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33868__auto__);
});})(c__33866__auto__))
);

return c__33866__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__33866__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33866__auto__,f__$1){
return (function (){
var f__33867__auto__ = (function (){var switch__33843__auto__ = ((function (c__33866__auto__,f__$1){
return (function (state_50090){
var state_val_50091 = (state_50090[(1)]);
if((state_val_50091 === (1))){
var inst_50085 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_50090__$1 = state_50090;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50090__$1,(2),inst_50085);
} else {
if((state_val_50091 === (2))){
var inst_50087 = (state_50090[(2)]);
var inst_50088 = f__$1.call(null,inst_50087);
var state_50090__$1 = state_50090;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_50090__$1,inst_50088);
} else {
return null;
}
}
});})(c__33866__auto__,f__$1))
;
return ((function (switch__33843__auto__,c__33866__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__33844__auto__ = null;
var cljs$core$async$transduce_$_state_machine__33844__auto____0 = (function (){
var statearr_50095 = [null,null,null,null,null,null,null];
(statearr_50095[(0)] = cljs$core$async$transduce_$_state_machine__33844__auto__);

(statearr_50095[(1)] = (1));

return statearr_50095;
});
var cljs$core$async$transduce_$_state_machine__33844__auto____1 = (function (state_50090){
while(true){
var ret_value__33845__auto__ = (function (){try{while(true){
var result__33846__auto__ = switch__33843__auto__.call(null,state_50090);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33846__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33846__auto__;
}
break;
}
}catch (e50096){if((e50096 instanceof Object)){
var ex__33847__auto__ = e50096;
var statearr_50097_50099 = state_50090;
(statearr_50097_50099[(5)] = ex__33847__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_50090);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e50096;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33845__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50100 = state_50090;
state_50090 = G__50100;
continue;
} else {
return ret_value__33845__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__33844__auto__ = function(state_50090){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__33844__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__33844__auto____1.call(this,state_50090);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__33844__auto____0;
cljs$core$async$transduce_$_state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__33844__auto____1;
return cljs$core$async$transduce_$_state_machine__33844__auto__;
})()
;})(switch__33843__auto__,c__33866__auto__,f__$1))
})();
var state__33868__auto__ = (function (){var statearr_50098 = f__33867__auto__.call(null);
(statearr_50098[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33866__auto__);

return statearr_50098;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33868__auto__);
});})(c__33866__auto__,f__$1))
);

return c__33866__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args50101 = [];
var len__10375__auto___50153 = arguments.length;
var i__10376__auto___50154 = (0);
while(true){
if((i__10376__auto___50154 < len__10375__auto___50153)){
args50101.push((arguments[i__10376__auto___50154]));

var G__50155 = (i__10376__auto___50154 + (1));
i__10376__auto___50154 = G__50155;
continue;
} else {
}
break;
}

var G__50103 = args50101.length;
switch (G__50103) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args50101.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__33866__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33866__auto__){
return (function (){
var f__33867__auto__ = (function (){var switch__33843__auto__ = ((function (c__33866__auto__){
return (function (state_50128){
var state_val_50129 = (state_50128[(1)]);
if((state_val_50129 === (7))){
var inst_50110 = (state_50128[(2)]);
var state_50128__$1 = state_50128;
var statearr_50130_50157 = state_50128__$1;
(statearr_50130_50157[(2)] = inst_50110);

(statearr_50130_50157[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50129 === (1))){
var inst_50104 = cljs.core.seq.call(null,coll);
var inst_50105 = inst_50104;
var state_50128__$1 = (function (){var statearr_50131 = state_50128;
(statearr_50131[(7)] = inst_50105);

return statearr_50131;
})();
var statearr_50132_50158 = state_50128__$1;
(statearr_50132_50158[(2)] = null);

(statearr_50132_50158[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50129 === (4))){
var inst_50105 = (state_50128[(7)]);
var inst_50108 = cljs.core.first.call(null,inst_50105);
var state_50128__$1 = state_50128;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_50128__$1,(7),ch,inst_50108);
} else {
if((state_val_50129 === (13))){
var inst_50122 = (state_50128[(2)]);
var state_50128__$1 = state_50128;
var statearr_50133_50159 = state_50128__$1;
(statearr_50133_50159[(2)] = inst_50122);

(statearr_50133_50159[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50129 === (6))){
var inst_50113 = (state_50128[(2)]);
var state_50128__$1 = state_50128;
if(cljs.core.truth_(inst_50113)){
var statearr_50134_50160 = state_50128__$1;
(statearr_50134_50160[(1)] = (8));

} else {
var statearr_50135_50161 = state_50128__$1;
(statearr_50135_50161[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50129 === (3))){
var inst_50126 = (state_50128[(2)]);
var state_50128__$1 = state_50128;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_50128__$1,inst_50126);
} else {
if((state_val_50129 === (12))){
var state_50128__$1 = state_50128;
var statearr_50136_50162 = state_50128__$1;
(statearr_50136_50162[(2)] = null);

(statearr_50136_50162[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50129 === (2))){
var inst_50105 = (state_50128[(7)]);
var state_50128__$1 = state_50128;
if(cljs.core.truth_(inst_50105)){
var statearr_50137_50163 = state_50128__$1;
(statearr_50137_50163[(1)] = (4));

} else {
var statearr_50138_50164 = state_50128__$1;
(statearr_50138_50164[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50129 === (11))){
var inst_50119 = cljs.core.async.close_BANG_.call(null,ch);
var state_50128__$1 = state_50128;
var statearr_50139_50165 = state_50128__$1;
(statearr_50139_50165[(2)] = inst_50119);

(statearr_50139_50165[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50129 === (9))){
var state_50128__$1 = state_50128;
if(cljs.core.truth_(close_QMARK_)){
var statearr_50140_50166 = state_50128__$1;
(statearr_50140_50166[(1)] = (11));

} else {
var statearr_50141_50167 = state_50128__$1;
(statearr_50141_50167[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50129 === (5))){
var inst_50105 = (state_50128[(7)]);
var state_50128__$1 = state_50128;
var statearr_50142_50168 = state_50128__$1;
(statearr_50142_50168[(2)] = inst_50105);

(statearr_50142_50168[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50129 === (10))){
var inst_50124 = (state_50128[(2)]);
var state_50128__$1 = state_50128;
var statearr_50143_50169 = state_50128__$1;
(statearr_50143_50169[(2)] = inst_50124);

(statearr_50143_50169[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50129 === (8))){
var inst_50105 = (state_50128[(7)]);
var inst_50115 = cljs.core.next.call(null,inst_50105);
var inst_50105__$1 = inst_50115;
var state_50128__$1 = (function (){var statearr_50144 = state_50128;
(statearr_50144[(7)] = inst_50105__$1);

return statearr_50144;
})();
var statearr_50145_50170 = state_50128__$1;
(statearr_50145_50170[(2)] = null);

(statearr_50145_50170[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33866__auto__))
;
return ((function (switch__33843__auto__,c__33866__auto__){
return (function() {
var cljs$core$async$state_machine__33844__auto__ = null;
var cljs$core$async$state_machine__33844__auto____0 = (function (){
var statearr_50149 = [null,null,null,null,null,null,null,null];
(statearr_50149[(0)] = cljs$core$async$state_machine__33844__auto__);

(statearr_50149[(1)] = (1));

return statearr_50149;
});
var cljs$core$async$state_machine__33844__auto____1 = (function (state_50128){
while(true){
var ret_value__33845__auto__ = (function (){try{while(true){
var result__33846__auto__ = switch__33843__auto__.call(null,state_50128);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33846__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33846__auto__;
}
break;
}
}catch (e50150){if((e50150 instanceof Object)){
var ex__33847__auto__ = e50150;
var statearr_50151_50171 = state_50128;
(statearr_50151_50171[(5)] = ex__33847__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_50128);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e50150;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33845__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50172 = state_50128;
state_50128 = G__50172;
continue;
} else {
return ret_value__33845__auto__;
}
break;
}
});
cljs$core$async$state_machine__33844__auto__ = function(state_50128){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33844__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33844__auto____1.call(this,state_50128);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33844__auto____0;
cljs$core$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33844__auto____1;
return cljs$core$async$state_machine__33844__auto__;
})()
;})(switch__33843__auto__,c__33866__auto__))
})();
var state__33868__auto__ = (function (){var statearr_50152 = f__33867__auto__.call(null);
(statearr_50152[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33866__auto__);

return statearr_50152;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33868__auto__);
});})(c__33866__auto__))
);

return c__33866__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__9872__auto__ = (((_ == null))?null:_);
var m__9873__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__9872__auto__)]);
if(!((m__9873__auto__ == null))){
return m__9873__auto__.call(null,_);
} else {
var m__9873__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__9873__auto____$1 == null))){
return m__9873__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__9872__auto__ = (((m == null))?null:m);
var m__9873__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__9872__auto__)]);
if(!((m__9873__auto__ == null))){
return m__9873__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__9873__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__9873__auto____$1 == null))){
return m__9873__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__9872__auto__ = (((m == null))?null:m);
var m__9873__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__9872__auto__)]);
if(!((m__9873__auto__ == null))){
return m__9873__auto__.call(null,m,ch);
} else {
var m__9873__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__9873__auto____$1 == null))){
return m__9873__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__9872__auto__ = (((m == null))?null:m);
var m__9873__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__9872__auto__)]);
if(!((m__9873__auto__ == null))){
return m__9873__auto__.call(null,m);
} else {
var m__9873__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__9873__auto____$1 == null))){
return m__9873__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async50398 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async50398 = (function (ch,cs,meta50399){
this.ch = ch;
this.cs = cs;
this.meta50399 = meta50399;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async50398.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_50400,meta50399__$1){
var self__ = this;
var _50400__$1 = this;
return (new cljs.core.async.t_cljs$core$async50398(self__.ch,self__.cs,meta50399__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async50398.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_50400){
var self__ = this;
var _50400__$1 = this;
return self__.meta50399;
});})(cs))
;

cljs.core.async.t_cljs$core$async50398.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async50398.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async50398.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async50398.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async50398.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async50398.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async50398.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta50399","meta50399",-323854004,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async50398.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async50398.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async50398";

cljs.core.async.t_cljs$core$async50398.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__9811__auto__,writer__9812__auto__,opt__9813__auto__){
return cljs.core._write.call(null,writer__9812__auto__,"cljs.core.async/t_cljs$core$async50398");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async50398 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async50398(ch__$1,cs__$1,meta50399){
return (new cljs.core.async.t_cljs$core$async50398(ch__$1,cs__$1,meta50399));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async50398(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__33866__auto___50623 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33866__auto___50623,cs,m,dchan,dctr,done){
return (function (){
var f__33867__auto__ = (function (){var switch__33843__auto__ = ((function (c__33866__auto___50623,cs,m,dchan,dctr,done){
return (function (state_50535){
var state_val_50536 = (state_50535[(1)]);
if((state_val_50536 === (7))){
var inst_50531 = (state_50535[(2)]);
var state_50535__$1 = state_50535;
var statearr_50537_50624 = state_50535__$1;
(statearr_50537_50624[(2)] = inst_50531);

(statearr_50537_50624[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (20))){
var inst_50434 = (state_50535[(7)]);
var inst_50446 = cljs.core.first.call(null,inst_50434);
var inst_50447 = cljs.core.nth.call(null,inst_50446,(0),null);
var inst_50448 = cljs.core.nth.call(null,inst_50446,(1),null);
var state_50535__$1 = (function (){var statearr_50538 = state_50535;
(statearr_50538[(8)] = inst_50447);

return statearr_50538;
})();
if(cljs.core.truth_(inst_50448)){
var statearr_50539_50625 = state_50535__$1;
(statearr_50539_50625[(1)] = (22));

} else {
var statearr_50540_50626 = state_50535__$1;
(statearr_50540_50626[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (27))){
var inst_50476 = (state_50535[(9)]);
var inst_50403 = (state_50535[(10)]);
var inst_50483 = (state_50535[(11)]);
var inst_50478 = (state_50535[(12)]);
var inst_50483__$1 = cljs.core._nth.call(null,inst_50476,inst_50478);
var inst_50484 = cljs.core.async.put_BANG_.call(null,inst_50483__$1,inst_50403,done);
var state_50535__$1 = (function (){var statearr_50541 = state_50535;
(statearr_50541[(11)] = inst_50483__$1);

return statearr_50541;
})();
if(cljs.core.truth_(inst_50484)){
var statearr_50542_50627 = state_50535__$1;
(statearr_50542_50627[(1)] = (30));

} else {
var statearr_50543_50628 = state_50535__$1;
(statearr_50543_50628[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (1))){
var state_50535__$1 = state_50535;
var statearr_50544_50629 = state_50535__$1;
(statearr_50544_50629[(2)] = null);

(statearr_50544_50629[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (24))){
var inst_50434 = (state_50535[(7)]);
var inst_50453 = (state_50535[(2)]);
var inst_50454 = cljs.core.next.call(null,inst_50434);
var inst_50412 = inst_50454;
var inst_50413 = null;
var inst_50414 = (0);
var inst_50415 = (0);
var state_50535__$1 = (function (){var statearr_50545 = state_50535;
(statearr_50545[(13)] = inst_50415);

(statearr_50545[(14)] = inst_50413);

(statearr_50545[(15)] = inst_50453);

(statearr_50545[(16)] = inst_50412);

(statearr_50545[(17)] = inst_50414);

return statearr_50545;
})();
var statearr_50546_50630 = state_50535__$1;
(statearr_50546_50630[(2)] = null);

(statearr_50546_50630[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (39))){
var state_50535__$1 = state_50535;
var statearr_50550_50631 = state_50535__$1;
(statearr_50550_50631[(2)] = null);

(statearr_50550_50631[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (4))){
var inst_50403 = (state_50535[(10)]);
var inst_50403__$1 = (state_50535[(2)]);
var inst_50404 = (inst_50403__$1 == null);
var state_50535__$1 = (function (){var statearr_50551 = state_50535;
(statearr_50551[(10)] = inst_50403__$1);

return statearr_50551;
})();
if(cljs.core.truth_(inst_50404)){
var statearr_50552_50632 = state_50535__$1;
(statearr_50552_50632[(1)] = (5));

} else {
var statearr_50553_50633 = state_50535__$1;
(statearr_50553_50633[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (15))){
var inst_50415 = (state_50535[(13)]);
var inst_50413 = (state_50535[(14)]);
var inst_50412 = (state_50535[(16)]);
var inst_50414 = (state_50535[(17)]);
var inst_50430 = (state_50535[(2)]);
var inst_50431 = (inst_50415 + (1));
var tmp50547 = inst_50413;
var tmp50548 = inst_50412;
var tmp50549 = inst_50414;
var inst_50412__$1 = tmp50548;
var inst_50413__$1 = tmp50547;
var inst_50414__$1 = tmp50549;
var inst_50415__$1 = inst_50431;
var state_50535__$1 = (function (){var statearr_50554 = state_50535;
(statearr_50554[(13)] = inst_50415__$1);

(statearr_50554[(14)] = inst_50413__$1);

(statearr_50554[(18)] = inst_50430);

(statearr_50554[(16)] = inst_50412__$1);

(statearr_50554[(17)] = inst_50414__$1);

return statearr_50554;
})();
var statearr_50555_50634 = state_50535__$1;
(statearr_50555_50634[(2)] = null);

(statearr_50555_50634[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (21))){
var inst_50457 = (state_50535[(2)]);
var state_50535__$1 = state_50535;
var statearr_50559_50635 = state_50535__$1;
(statearr_50559_50635[(2)] = inst_50457);

(statearr_50559_50635[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (31))){
var inst_50483 = (state_50535[(11)]);
var inst_50487 = done.call(null,null);
var inst_50488 = cljs.core.async.untap_STAR_.call(null,m,inst_50483);
var state_50535__$1 = (function (){var statearr_50560 = state_50535;
(statearr_50560[(19)] = inst_50487);

return statearr_50560;
})();
var statearr_50561_50636 = state_50535__$1;
(statearr_50561_50636[(2)] = inst_50488);

(statearr_50561_50636[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (32))){
var inst_50476 = (state_50535[(9)]);
var inst_50475 = (state_50535[(20)]);
var inst_50477 = (state_50535[(21)]);
var inst_50478 = (state_50535[(12)]);
var inst_50490 = (state_50535[(2)]);
var inst_50491 = (inst_50478 + (1));
var tmp50556 = inst_50476;
var tmp50557 = inst_50475;
var tmp50558 = inst_50477;
var inst_50475__$1 = tmp50557;
var inst_50476__$1 = tmp50556;
var inst_50477__$1 = tmp50558;
var inst_50478__$1 = inst_50491;
var state_50535__$1 = (function (){var statearr_50562 = state_50535;
(statearr_50562[(9)] = inst_50476__$1);

(statearr_50562[(22)] = inst_50490);

(statearr_50562[(20)] = inst_50475__$1);

(statearr_50562[(21)] = inst_50477__$1);

(statearr_50562[(12)] = inst_50478__$1);

return statearr_50562;
})();
var statearr_50563_50637 = state_50535__$1;
(statearr_50563_50637[(2)] = null);

(statearr_50563_50637[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (40))){
var inst_50503 = (state_50535[(23)]);
var inst_50507 = done.call(null,null);
var inst_50508 = cljs.core.async.untap_STAR_.call(null,m,inst_50503);
var state_50535__$1 = (function (){var statearr_50564 = state_50535;
(statearr_50564[(24)] = inst_50507);

return statearr_50564;
})();
var statearr_50565_50638 = state_50535__$1;
(statearr_50565_50638[(2)] = inst_50508);

(statearr_50565_50638[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (33))){
var inst_50494 = (state_50535[(25)]);
var inst_50496 = cljs.core.chunked_seq_QMARK_.call(null,inst_50494);
var state_50535__$1 = state_50535;
if(inst_50496){
var statearr_50566_50639 = state_50535__$1;
(statearr_50566_50639[(1)] = (36));

} else {
var statearr_50567_50640 = state_50535__$1;
(statearr_50567_50640[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (13))){
var inst_50424 = (state_50535[(26)]);
var inst_50427 = cljs.core.async.close_BANG_.call(null,inst_50424);
var state_50535__$1 = state_50535;
var statearr_50568_50641 = state_50535__$1;
(statearr_50568_50641[(2)] = inst_50427);

(statearr_50568_50641[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (22))){
var inst_50447 = (state_50535[(8)]);
var inst_50450 = cljs.core.async.close_BANG_.call(null,inst_50447);
var state_50535__$1 = state_50535;
var statearr_50569_50642 = state_50535__$1;
(statearr_50569_50642[(2)] = inst_50450);

(statearr_50569_50642[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (36))){
var inst_50494 = (state_50535[(25)]);
var inst_50498 = cljs.core.chunk_first.call(null,inst_50494);
var inst_50499 = cljs.core.chunk_rest.call(null,inst_50494);
var inst_50500 = cljs.core.count.call(null,inst_50498);
var inst_50475 = inst_50499;
var inst_50476 = inst_50498;
var inst_50477 = inst_50500;
var inst_50478 = (0);
var state_50535__$1 = (function (){var statearr_50570 = state_50535;
(statearr_50570[(9)] = inst_50476);

(statearr_50570[(20)] = inst_50475);

(statearr_50570[(21)] = inst_50477);

(statearr_50570[(12)] = inst_50478);

return statearr_50570;
})();
var statearr_50571_50643 = state_50535__$1;
(statearr_50571_50643[(2)] = null);

(statearr_50571_50643[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (41))){
var inst_50494 = (state_50535[(25)]);
var inst_50510 = (state_50535[(2)]);
var inst_50511 = cljs.core.next.call(null,inst_50494);
var inst_50475 = inst_50511;
var inst_50476 = null;
var inst_50477 = (0);
var inst_50478 = (0);
var state_50535__$1 = (function (){var statearr_50572 = state_50535;
(statearr_50572[(27)] = inst_50510);

(statearr_50572[(9)] = inst_50476);

(statearr_50572[(20)] = inst_50475);

(statearr_50572[(21)] = inst_50477);

(statearr_50572[(12)] = inst_50478);

return statearr_50572;
})();
var statearr_50573_50644 = state_50535__$1;
(statearr_50573_50644[(2)] = null);

(statearr_50573_50644[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (43))){
var state_50535__$1 = state_50535;
var statearr_50574_50645 = state_50535__$1;
(statearr_50574_50645[(2)] = null);

(statearr_50574_50645[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (29))){
var inst_50519 = (state_50535[(2)]);
var state_50535__$1 = state_50535;
var statearr_50575_50646 = state_50535__$1;
(statearr_50575_50646[(2)] = inst_50519);

(statearr_50575_50646[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (44))){
var inst_50528 = (state_50535[(2)]);
var state_50535__$1 = (function (){var statearr_50576 = state_50535;
(statearr_50576[(28)] = inst_50528);

return statearr_50576;
})();
var statearr_50577_50647 = state_50535__$1;
(statearr_50577_50647[(2)] = null);

(statearr_50577_50647[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (6))){
var inst_50467 = (state_50535[(29)]);
var inst_50466 = cljs.core.deref.call(null,cs);
var inst_50467__$1 = cljs.core.keys.call(null,inst_50466);
var inst_50468 = cljs.core.count.call(null,inst_50467__$1);
var inst_50469 = cljs.core.reset_BANG_.call(null,dctr,inst_50468);
var inst_50474 = cljs.core.seq.call(null,inst_50467__$1);
var inst_50475 = inst_50474;
var inst_50476 = null;
var inst_50477 = (0);
var inst_50478 = (0);
var state_50535__$1 = (function (){var statearr_50578 = state_50535;
(statearr_50578[(29)] = inst_50467__$1);

(statearr_50578[(9)] = inst_50476);

(statearr_50578[(20)] = inst_50475);

(statearr_50578[(30)] = inst_50469);

(statearr_50578[(21)] = inst_50477);

(statearr_50578[(12)] = inst_50478);

return statearr_50578;
})();
var statearr_50579_50648 = state_50535__$1;
(statearr_50579_50648[(2)] = null);

(statearr_50579_50648[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (28))){
var inst_50475 = (state_50535[(20)]);
var inst_50494 = (state_50535[(25)]);
var inst_50494__$1 = cljs.core.seq.call(null,inst_50475);
var state_50535__$1 = (function (){var statearr_50580 = state_50535;
(statearr_50580[(25)] = inst_50494__$1);

return statearr_50580;
})();
if(inst_50494__$1){
var statearr_50581_50649 = state_50535__$1;
(statearr_50581_50649[(1)] = (33));

} else {
var statearr_50582_50650 = state_50535__$1;
(statearr_50582_50650[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (25))){
var inst_50477 = (state_50535[(21)]);
var inst_50478 = (state_50535[(12)]);
var inst_50480 = (inst_50478 < inst_50477);
var inst_50481 = inst_50480;
var state_50535__$1 = state_50535;
if(cljs.core.truth_(inst_50481)){
var statearr_50583_50651 = state_50535__$1;
(statearr_50583_50651[(1)] = (27));

} else {
var statearr_50584_50652 = state_50535__$1;
(statearr_50584_50652[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (34))){
var state_50535__$1 = state_50535;
var statearr_50585_50653 = state_50535__$1;
(statearr_50585_50653[(2)] = null);

(statearr_50585_50653[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (17))){
var state_50535__$1 = state_50535;
var statearr_50586_50654 = state_50535__$1;
(statearr_50586_50654[(2)] = null);

(statearr_50586_50654[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (3))){
var inst_50533 = (state_50535[(2)]);
var state_50535__$1 = state_50535;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_50535__$1,inst_50533);
} else {
if((state_val_50536 === (12))){
var inst_50462 = (state_50535[(2)]);
var state_50535__$1 = state_50535;
var statearr_50587_50655 = state_50535__$1;
(statearr_50587_50655[(2)] = inst_50462);

(statearr_50587_50655[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (2))){
var state_50535__$1 = state_50535;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50535__$1,(4),ch);
} else {
if((state_val_50536 === (23))){
var state_50535__$1 = state_50535;
var statearr_50588_50656 = state_50535__$1;
(statearr_50588_50656[(2)] = null);

(statearr_50588_50656[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (35))){
var inst_50517 = (state_50535[(2)]);
var state_50535__$1 = state_50535;
var statearr_50589_50657 = state_50535__$1;
(statearr_50589_50657[(2)] = inst_50517);

(statearr_50589_50657[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (19))){
var inst_50434 = (state_50535[(7)]);
var inst_50438 = cljs.core.chunk_first.call(null,inst_50434);
var inst_50439 = cljs.core.chunk_rest.call(null,inst_50434);
var inst_50440 = cljs.core.count.call(null,inst_50438);
var inst_50412 = inst_50439;
var inst_50413 = inst_50438;
var inst_50414 = inst_50440;
var inst_50415 = (0);
var state_50535__$1 = (function (){var statearr_50590 = state_50535;
(statearr_50590[(13)] = inst_50415);

(statearr_50590[(14)] = inst_50413);

(statearr_50590[(16)] = inst_50412);

(statearr_50590[(17)] = inst_50414);

return statearr_50590;
})();
var statearr_50591_50658 = state_50535__$1;
(statearr_50591_50658[(2)] = null);

(statearr_50591_50658[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (11))){
var inst_50434 = (state_50535[(7)]);
var inst_50412 = (state_50535[(16)]);
var inst_50434__$1 = cljs.core.seq.call(null,inst_50412);
var state_50535__$1 = (function (){var statearr_50592 = state_50535;
(statearr_50592[(7)] = inst_50434__$1);

return statearr_50592;
})();
if(inst_50434__$1){
var statearr_50593_50659 = state_50535__$1;
(statearr_50593_50659[(1)] = (16));

} else {
var statearr_50594_50660 = state_50535__$1;
(statearr_50594_50660[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (9))){
var inst_50464 = (state_50535[(2)]);
var state_50535__$1 = state_50535;
var statearr_50595_50661 = state_50535__$1;
(statearr_50595_50661[(2)] = inst_50464);

(statearr_50595_50661[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (5))){
var inst_50410 = cljs.core.deref.call(null,cs);
var inst_50411 = cljs.core.seq.call(null,inst_50410);
var inst_50412 = inst_50411;
var inst_50413 = null;
var inst_50414 = (0);
var inst_50415 = (0);
var state_50535__$1 = (function (){var statearr_50596 = state_50535;
(statearr_50596[(13)] = inst_50415);

(statearr_50596[(14)] = inst_50413);

(statearr_50596[(16)] = inst_50412);

(statearr_50596[(17)] = inst_50414);

return statearr_50596;
})();
var statearr_50597_50662 = state_50535__$1;
(statearr_50597_50662[(2)] = null);

(statearr_50597_50662[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (14))){
var state_50535__$1 = state_50535;
var statearr_50598_50663 = state_50535__$1;
(statearr_50598_50663[(2)] = null);

(statearr_50598_50663[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (45))){
var inst_50525 = (state_50535[(2)]);
var state_50535__$1 = state_50535;
var statearr_50599_50664 = state_50535__$1;
(statearr_50599_50664[(2)] = inst_50525);

(statearr_50599_50664[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (26))){
var inst_50467 = (state_50535[(29)]);
var inst_50521 = (state_50535[(2)]);
var inst_50522 = cljs.core.seq.call(null,inst_50467);
var state_50535__$1 = (function (){var statearr_50600 = state_50535;
(statearr_50600[(31)] = inst_50521);

return statearr_50600;
})();
if(inst_50522){
var statearr_50601_50665 = state_50535__$1;
(statearr_50601_50665[(1)] = (42));

} else {
var statearr_50602_50666 = state_50535__$1;
(statearr_50602_50666[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (16))){
var inst_50434 = (state_50535[(7)]);
var inst_50436 = cljs.core.chunked_seq_QMARK_.call(null,inst_50434);
var state_50535__$1 = state_50535;
if(inst_50436){
var statearr_50603_50667 = state_50535__$1;
(statearr_50603_50667[(1)] = (19));

} else {
var statearr_50604_50668 = state_50535__$1;
(statearr_50604_50668[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (38))){
var inst_50514 = (state_50535[(2)]);
var state_50535__$1 = state_50535;
var statearr_50605_50669 = state_50535__$1;
(statearr_50605_50669[(2)] = inst_50514);

(statearr_50605_50669[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (30))){
var state_50535__$1 = state_50535;
var statearr_50606_50670 = state_50535__$1;
(statearr_50606_50670[(2)] = null);

(statearr_50606_50670[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (10))){
var inst_50415 = (state_50535[(13)]);
var inst_50413 = (state_50535[(14)]);
var inst_50423 = cljs.core._nth.call(null,inst_50413,inst_50415);
var inst_50424 = cljs.core.nth.call(null,inst_50423,(0),null);
var inst_50425 = cljs.core.nth.call(null,inst_50423,(1),null);
var state_50535__$1 = (function (){var statearr_50607 = state_50535;
(statearr_50607[(26)] = inst_50424);

return statearr_50607;
})();
if(cljs.core.truth_(inst_50425)){
var statearr_50608_50671 = state_50535__$1;
(statearr_50608_50671[(1)] = (13));

} else {
var statearr_50609_50672 = state_50535__$1;
(statearr_50609_50672[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (18))){
var inst_50460 = (state_50535[(2)]);
var state_50535__$1 = state_50535;
var statearr_50610_50673 = state_50535__$1;
(statearr_50610_50673[(2)] = inst_50460);

(statearr_50610_50673[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (42))){
var state_50535__$1 = state_50535;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50535__$1,(45),dchan);
} else {
if((state_val_50536 === (37))){
var inst_50503 = (state_50535[(23)]);
var inst_50403 = (state_50535[(10)]);
var inst_50494 = (state_50535[(25)]);
var inst_50503__$1 = cljs.core.first.call(null,inst_50494);
var inst_50504 = cljs.core.async.put_BANG_.call(null,inst_50503__$1,inst_50403,done);
var state_50535__$1 = (function (){var statearr_50611 = state_50535;
(statearr_50611[(23)] = inst_50503__$1);

return statearr_50611;
})();
if(cljs.core.truth_(inst_50504)){
var statearr_50612_50674 = state_50535__$1;
(statearr_50612_50674[(1)] = (39));

} else {
var statearr_50613_50675 = state_50535__$1;
(statearr_50613_50675[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50536 === (8))){
var inst_50415 = (state_50535[(13)]);
var inst_50414 = (state_50535[(17)]);
var inst_50417 = (inst_50415 < inst_50414);
var inst_50418 = inst_50417;
var state_50535__$1 = state_50535;
if(cljs.core.truth_(inst_50418)){
var statearr_50614_50676 = state_50535__$1;
(statearr_50614_50676[(1)] = (10));

} else {
var statearr_50615_50677 = state_50535__$1;
(statearr_50615_50677[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33866__auto___50623,cs,m,dchan,dctr,done))
;
return ((function (switch__33843__auto__,c__33866__auto___50623,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__33844__auto__ = null;
var cljs$core$async$mult_$_state_machine__33844__auto____0 = (function (){
var statearr_50619 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_50619[(0)] = cljs$core$async$mult_$_state_machine__33844__auto__);

(statearr_50619[(1)] = (1));

return statearr_50619;
});
var cljs$core$async$mult_$_state_machine__33844__auto____1 = (function (state_50535){
while(true){
var ret_value__33845__auto__ = (function (){try{while(true){
var result__33846__auto__ = switch__33843__auto__.call(null,state_50535);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33846__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33846__auto__;
}
break;
}
}catch (e50620){if((e50620 instanceof Object)){
var ex__33847__auto__ = e50620;
var statearr_50621_50678 = state_50535;
(statearr_50621_50678[(5)] = ex__33847__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_50535);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e50620;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33845__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50679 = state_50535;
state_50535 = G__50679;
continue;
} else {
return ret_value__33845__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__33844__auto__ = function(state_50535){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__33844__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__33844__auto____1.call(this,state_50535);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__33844__auto____0;
cljs$core$async$mult_$_state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__33844__auto____1;
return cljs$core$async$mult_$_state_machine__33844__auto__;
})()
;})(switch__33843__auto__,c__33866__auto___50623,cs,m,dchan,dctr,done))
})();
var state__33868__auto__ = (function (){var statearr_50622 = f__33867__auto__.call(null);
(statearr_50622[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33866__auto___50623);

return statearr_50622;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33868__auto__);
});})(c__33866__auto___50623,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args50680 = [];
var len__10375__auto___50683 = arguments.length;
var i__10376__auto___50684 = (0);
while(true){
if((i__10376__auto___50684 < len__10375__auto___50683)){
args50680.push((arguments[i__10376__auto___50684]));

var G__50685 = (i__10376__auto___50684 + (1));
i__10376__auto___50684 = G__50685;
continue;
} else {
}
break;
}

var G__50682 = args50680.length;
switch (G__50682) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args50680.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__9872__auto__ = (((m == null))?null:m);
var m__9873__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__9872__auto__)]);
if(!((m__9873__auto__ == null))){
return m__9873__auto__.call(null,m,ch);
} else {
var m__9873__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__9873__auto____$1 == null))){
return m__9873__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__9872__auto__ = (((m == null))?null:m);
var m__9873__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__9872__auto__)]);
if(!((m__9873__auto__ == null))){
return m__9873__auto__.call(null,m,ch);
} else {
var m__9873__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__9873__auto____$1 == null))){
return m__9873__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__9872__auto__ = (((m == null))?null:m);
var m__9873__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__9872__auto__)]);
if(!((m__9873__auto__ == null))){
return m__9873__auto__.call(null,m);
} else {
var m__9873__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__9873__auto____$1 == null))){
return m__9873__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__9872__auto__ = (((m == null))?null:m);
var m__9873__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__9872__auto__)]);
if(!((m__9873__auto__ == null))){
return m__9873__auto__.call(null,m,state_map);
} else {
var m__9873__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__9873__auto____$1 == null))){
return m__9873__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__9872__auto__ = (((m == null))?null:m);
var m__9873__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__9872__auto__)]);
if(!((m__9873__auto__ == null))){
return m__9873__auto__.call(null,m,mode);
} else {
var m__9873__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__9873__auto____$1 == null))){
return m__9873__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__10382__auto__ = [];
var len__10375__auto___50697 = arguments.length;
var i__10376__auto___50698 = (0);
while(true){
if((i__10376__auto___50698 < len__10375__auto___50697)){
args__10382__auto__.push((arguments[i__10376__auto___50698]));

var G__50699 = (i__10376__auto___50698 + (1));
i__10376__auto___50698 = G__50699;
continue;
} else {
}
break;
}

var argseq__10383__auto__ = ((((3) < args__10382__auto__.length))?(new cljs.core.IndexedSeq(args__10382__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10383__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__50691){
var map__50692 = p__50691;
var map__50692__$1 = ((((!((map__50692 == null)))?((((map__50692.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50692.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50692):map__50692);
var opts = map__50692__$1;
var statearr_50694_50700 = state;
(statearr_50694_50700[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__6738__auto__ = cljs.core.async.do_alts.call(null,((function (map__50692,map__50692__$1,opts){
return (function (val){
var statearr_50695_50701 = state;
(statearr_50695_50701[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__50692,map__50692__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__6738__auto__)){
var cb = temp__6738__auto__;
var statearr_50696_50702 = state;
(statearr_50696_50702[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq50687){
var G__50688 = cljs.core.first.call(null,seq50687);
var seq50687__$1 = cljs.core.next.call(null,seq50687);
var G__50689 = cljs.core.first.call(null,seq50687__$1);
var seq50687__$2 = cljs.core.next.call(null,seq50687__$1);
var G__50690 = cljs.core.first.call(null,seq50687__$2);
var seq50687__$3 = cljs.core.next.call(null,seq50687__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__50688,G__50689,G__50690,seq50687__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async50870 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async50870 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta50871){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta50871 = meta50871;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async50870.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_50872,meta50871__$1){
var self__ = this;
var _50872__$1 = this;
return (new cljs.core.async.t_cljs$core$async50870(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta50871__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async50870.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_50872){
var self__ = this;
var _50872__$1 = this;
return self__.meta50871;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async50870.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async50870.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async50870.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async50870.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async50870.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async50870.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async50870.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async50870.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1("mode must be one of: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async50870.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta50871","meta50871",1634864262,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async50870.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async50870.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async50870";

cljs.core.async.t_cljs$core$async50870.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__9811__auto__,writer__9812__auto__,opt__9813__auto__){
return cljs.core._write.call(null,writer__9812__auto__,"cljs.core.async/t_cljs$core$async50870");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async50870 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async50870(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta50871){
return (new cljs.core.async.t_cljs$core$async50870(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta50871));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async50870(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__33866__auto___51037 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33866__auto___51037,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__33867__auto__ = (function (){var switch__33843__auto__ = ((function (c__33866__auto___51037,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_50974){
var state_val_50975 = (state_50974[(1)]);
if((state_val_50975 === (7))){
var inst_50889 = (state_50974[(2)]);
var state_50974__$1 = state_50974;
var statearr_50976_51038 = state_50974__$1;
(statearr_50976_51038[(2)] = inst_50889);

(statearr_50976_51038[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50975 === (20))){
var inst_50901 = (state_50974[(7)]);
var state_50974__$1 = state_50974;
var statearr_50977_51039 = state_50974__$1;
(statearr_50977_51039[(2)] = inst_50901);

(statearr_50977_51039[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50975 === (27))){
var state_50974__$1 = state_50974;
var statearr_50978_51040 = state_50974__$1;
(statearr_50978_51040[(2)] = null);

(statearr_50978_51040[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50975 === (1))){
var inst_50876 = (state_50974[(8)]);
var inst_50876__$1 = calc_state.call(null);
var inst_50878 = (inst_50876__$1 == null);
var inst_50879 = cljs.core.not.call(null,inst_50878);
var state_50974__$1 = (function (){var statearr_50979 = state_50974;
(statearr_50979[(8)] = inst_50876__$1);

return statearr_50979;
})();
if(inst_50879){
var statearr_50980_51041 = state_50974__$1;
(statearr_50980_51041[(1)] = (2));

} else {
var statearr_50981_51042 = state_50974__$1;
(statearr_50981_51042[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50975 === (24))){
var inst_50925 = (state_50974[(9)]);
var inst_50934 = (state_50974[(10)]);
var inst_50948 = (state_50974[(11)]);
var inst_50948__$1 = inst_50925.call(null,inst_50934);
var state_50974__$1 = (function (){var statearr_50982 = state_50974;
(statearr_50982[(11)] = inst_50948__$1);

return statearr_50982;
})();
if(cljs.core.truth_(inst_50948__$1)){
var statearr_50983_51043 = state_50974__$1;
(statearr_50983_51043[(1)] = (29));

} else {
var statearr_50984_51044 = state_50974__$1;
(statearr_50984_51044[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50975 === (4))){
var inst_50892 = (state_50974[(2)]);
var state_50974__$1 = state_50974;
if(cljs.core.truth_(inst_50892)){
var statearr_50985_51045 = state_50974__$1;
(statearr_50985_51045[(1)] = (8));

} else {
var statearr_50986_51046 = state_50974__$1;
(statearr_50986_51046[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50975 === (15))){
var inst_50919 = (state_50974[(2)]);
var state_50974__$1 = state_50974;
if(cljs.core.truth_(inst_50919)){
var statearr_50987_51047 = state_50974__$1;
(statearr_50987_51047[(1)] = (19));

} else {
var statearr_50988_51048 = state_50974__$1;
(statearr_50988_51048[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50975 === (21))){
var inst_50924 = (state_50974[(12)]);
var inst_50924__$1 = (state_50974[(2)]);
var inst_50925 = cljs.core.get.call(null,inst_50924__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_50926 = cljs.core.get.call(null,inst_50924__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_50927 = cljs.core.get.call(null,inst_50924__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_50974__$1 = (function (){var statearr_50989 = state_50974;
(statearr_50989[(9)] = inst_50925);

(statearr_50989[(12)] = inst_50924__$1);

(statearr_50989[(13)] = inst_50926);

return statearr_50989;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_50974__$1,(22),inst_50927);
} else {
if((state_val_50975 === (31))){
var inst_50956 = (state_50974[(2)]);
var state_50974__$1 = state_50974;
if(cljs.core.truth_(inst_50956)){
var statearr_50990_51049 = state_50974__$1;
(statearr_50990_51049[(1)] = (32));

} else {
var statearr_50991_51050 = state_50974__$1;
(statearr_50991_51050[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50975 === (32))){
var inst_50933 = (state_50974[(14)]);
var state_50974__$1 = state_50974;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_50974__$1,(35),out,inst_50933);
} else {
if((state_val_50975 === (33))){
var inst_50924 = (state_50974[(12)]);
var inst_50901 = inst_50924;
var state_50974__$1 = (function (){var statearr_50992 = state_50974;
(statearr_50992[(7)] = inst_50901);

return statearr_50992;
})();
var statearr_50993_51051 = state_50974__$1;
(statearr_50993_51051[(2)] = null);

(statearr_50993_51051[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50975 === (13))){
var inst_50901 = (state_50974[(7)]);
var inst_50908 = inst_50901.cljs$lang$protocol_mask$partition0$;
var inst_50909 = (inst_50908 & (64));
var inst_50910 = inst_50901.cljs$core$ISeq$;
var inst_50911 = (cljs.core.PROTOCOL_SENTINEL === inst_50910);
var inst_50912 = (inst_50909) || (inst_50911);
var state_50974__$1 = state_50974;
if(cljs.core.truth_(inst_50912)){
var statearr_50994_51052 = state_50974__$1;
(statearr_50994_51052[(1)] = (16));

} else {
var statearr_50995_51053 = state_50974__$1;
(statearr_50995_51053[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50975 === (22))){
var inst_50934 = (state_50974[(10)]);
var inst_50933 = (state_50974[(14)]);
var inst_50932 = (state_50974[(2)]);
var inst_50933__$1 = cljs.core.nth.call(null,inst_50932,(0),null);
var inst_50934__$1 = cljs.core.nth.call(null,inst_50932,(1),null);
var inst_50935 = (inst_50933__$1 == null);
var inst_50936 = cljs.core._EQ_.call(null,inst_50934__$1,change);
var inst_50937 = (inst_50935) || (inst_50936);
var state_50974__$1 = (function (){var statearr_50996 = state_50974;
(statearr_50996[(10)] = inst_50934__$1);

(statearr_50996[(14)] = inst_50933__$1);

return statearr_50996;
})();
if(cljs.core.truth_(inst_50937)){
var statearr_50997_51054 = state_50974__$1;
(statearr_50997_51054[(1)] = (23));

} else {
var statearr_50998_51055 = state_50974__$1;
(statearr_50998_51055[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50975 === (36))){
var inst_50924 = (state_50974[(12)]);
var inst_50901 = inst_50924;
var state_50974__$1 = (function (){var statearr_50999 = state_50974;
(statearr_50999[(7)] = inst_50901);

return statearr_50999;
})();
var statearr_51000_51056 = state_50974__$1;
(statearr_51000_51056[(2)] = null);

(statearr_51000_51056[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50975 === (29))){
var inst_50948 = (state_50974[(11)]);
var state_50974__$1 = state_50974;
var statearr_51001_51057 = state_50974__$1;
(statearr_51001_51057[(2)] = inst_50948);

(statearr_51001_51057[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50975 === (6))){
var state_50974__$1 = state_50974;
var statearr_51002_51058 = state_50974__$1;
(statearr_51002_51058[(2)] = false);

(statearr_51002_51058[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50975 === (28))){
var inst_50944 = (state_50974[(2)]);
var inst_50945 = calc_state.call(null);
var inst_50901 = inst_50945;
var state_50974__$1 = (function (){var statearr_51003 = state_50974;
(statearr_51003[(15)] = inst_50944);

(statearr_51003[(7)] = inst_50901);

return statearr_51003;
})();
var statearr_51004_51059 = state_50974__$1;
(statearr_51004_51059[(2)] = null);

(statearr_51004_51059[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50975 === (25))){
var inst_50970 = (state_50974[(2)]);
var state_50974__$1 = state_50974;
var statearr_51005_51060 = state_50974__$1;
(statearr_51005_51060[(2)] = inst_50970);

(statearr_51005_51060[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50975 === (34))){
var inst_50968 = (state_50974[(2)]);
var state_50974__$1 = state_50974;
var statearr_51006_51061 = state_50974__$1;
(statearr_51006_51061[(2)] = inst_50968);

(statearr_51006_51061[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50975 === (17))){
var state_50974__$1 = state_50974;
var statearr_51007_51062 = state_50974__$1;
(statearr_51007_51062[(2)] = false);

(statearr_51007_51062[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50975 === (3))){
var state_50974__$1 = state_50974;
var statearr_51008_51063 = state_50974__$1;
(statearr_51008_51063[(2)] = false);

(statearr_51008_51063[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50975 === (12))){
var inst_50972 = (state_50974[(2)]);
var state_50974__$1 = state_50974;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_50974__$1,inst_50972);
} else {
if((state_val_50975 === (2))){
var inst_50876 = (state_50974[(8)]);
var inst_50881 = inst_50876.cljs$lang$protocol_mask$partition0$;
var inst_50882 = (inst_50881 & (64));
var inst_50883 = inst_50876.cljs$core$ISeq$;
var inst_50884 = (cljs.core.PROTOCOL_SENTINEL === inst_50883);
var inst_50885 = (inst_50882) || (inst_50884);
var state_50974__$1 = state_50974;
if(cljs.core.truth_(inst_50885)){
var statearr_51009_51064 = state_50974__$1;
(statearr_51009_51064[(1)] = (5));

} else {
var statearr_51010_51065 = state_50974__$1;
(statearr_51010_51065[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50975 === (23))){
var inst_50933 = (state_50974[(14)]);
var inst_50939 = (inst_50933 == null);
var state_50974__$1 = state_50974;
if(cljs.core.truth_(inst_50939)){
var statearr_51011_51066 = state_50974__$1;
(statearr_51011_51066[(1)] = (26));

} else {
var statearr_51012_51067 = state_50974__$1;
(statearr_51012_51067[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50975 === (35))){
var inst_50959 = (state_50974[(2)]);
var state_50974__$1 = state_50974;
if(cljs.core.truth_(inst_50959)){
var statearr_51013_51068 = state_50974__$1;
(statearr_51013_51068[(1)] = (36));

} else {
var statearr_51014_51069 = state_50974__$1;
(statearr_51014_51069[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50975 === (19))){
var inst_50901 = (state_50974[(7)]);
var inst_50921 = cljs.core.apply.call(null,cljs.core.hash_map,inst_50901);
var state_50974__$1 = state_50974;
var statearr_51015_51070 = state_50974__$1;
(statearr_51015_51070[(2)] = inst_50921);

(statearr_51015_51070[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50975 === (11))){
var inst_50901 = (state_50974[(7)]);
var inst_50905 = (inst_50901 == null);
var inst_50906 = cljs.core.not.call(null,inst_50905);
var state_50974__$1 = state_50974;
if(inst_50906){
var statearr_51016_51071 = state_50974__$1;
(statearr_51016_51071[(1)] = (13));

} else {
var statearr_51017_51072 = state_50974__$1;
(statearr_51017_51072[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50975 === (9))){
var inst_50876 = (state_50974[(8)]);
var state_50974__$1 = state_50974;
var statearr_51018_51073 = state_50974__$1;
(statearr_51018_51073[(2)] = inst_50876);

(statearr_51018_51073[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50975 === (5))){
var state_50974__$1 = state_50974;
var statearr_51019_51074 = state_50974__$1;
(statearr_51019_51074[(2)] = true);

(statearr_51019_51074[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50975 === (14))){
var state_50974__$1 = state_50974;
var statearr_51020_51075 = state_50974__$1;
(statearr_51020_51075[(2)] = false);

(statearr_51020_51075[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50975 === (26))){
var inst_50934 = (state_50974[(10)]);
var inst_50941 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_50934);
var state_50974__$1 = state_50974;
var statearr_51021_51076 = state_50974__$1;
(statearr_51021_51076[(2)] = inst_50941);

(statearr_51021_51076[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50975 === (16))){
var state_50974__$1 = state_50974;
var statearr_51022_51077 = state_50974__$1;
(statearr_51022_51077[(2)] = true);

(statearr_51022_51077[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50975 === (38))){
var inst_50964 = (state_50974[(2)]);
var state_50974__$1 = state_50974;
var statearr_51023_51078 = state_50974__$1;
(statearr_51023_51078[(2)] = inst_50964);

(statearr_51023_51078[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50975 === (30))){
var inst_50925 = (state_50974[(9)]);
var inst_50934 = (state_50974[(10)]);
var inst_50926 = (state_50974[(13)]);
var inst_50951 = cljs.core.empty_QMARK_.call(null,inst_50925);
var inst_50952 = inst_50926.call(null,inst_50934);
var inst_50953 = cljs.core.not.call(null,inst_50952);
var inst_50954 = (inst_50951) && (inst_50953);
var state_50974__$1 = state_50974;
var statearr_51024_51079 = state_50974__$1;
(statearr_51024_51079[(2)] = inst_50954);

(statearr_51024_51079[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50975 === (10))){
var inst_50876 = (state_50974[(8)]);
var inst_50897 = (state_50974[(2)]);
var inst_50898 = cljs.core.get.call(null,inst_50897,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_50899 = cljs.core.get.call(null,inst_50897,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_50900 = cljs.core.get.call(null,inst_50897,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_50901 = inst_50876;
var state_50974__$1 = (function (){var statearr_51025 = state_50974;
(statearr_51025[(16)] = inst_50898);

(statearr_51025[(17)] = inst_50899);

(statearr_51025[(7)] = inst_50901);

(statearr_51025[(18)] = inst_50900);

return statearr_51025;
})();
var statearr_51026_51080 = state_50974__$1;
(statearr_51026_51080[(2)] = null);

(statearr_51026_51080[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50975 === (18))){
var inst_50916 = (state_50974[(2)]);
var state_50974__$1 = state_50974;
var statearr_51027_51081 = state_50974__$1;
(statearr_51027_51081[(2)] = inst_50916);

(statearr_51027_51081[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50975 === (37))){
var state_50974__$1 = state_50974;
var statearr_51028_51082 = state_50974__$1;
(statearr_51028_51082[(2)] = null);

(statearr_51028_51082[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50975 === (8))){
var inst_50876 = (state_50974[(8)]);
var inst_50894 = cljs.core.apply.call(null,cljs.core.hash_map,inst_50876);
var state_50974__$1 = state_50974;
var statearr_51029_51083 = state_50974__$1;
(statearr_51029_51083[(2)] = inst_50894);

(statearr_51029_51083[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33866__auto___51037,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__33843__auto__,c__33866__auto___51037,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__33844__auto__ = null;
var cljs$core$async$mix_$_state_machine__33844__auto____0 = (function (){
var statearr_51033 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_51033[(0)] = cljs$core$async$mix_$_state_machine__33844__auto__);

(statearr_51033[(1)] = (1));

return statearr_51033;
});
var cljs$core$async$mix_$_state_machine__33844__auto____1 = (function (state_50974){
while(true){
var ret_value__33845__auto__ = (function (){try{while(true){
var result__33846__auto__ = switch__33843__auto__.call(null,state_50974);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33846__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33846__auto__;
}
break;
}
}catch (e51034){if((e51034 instanceof Object)){
var ex__33847__auto__ = e51034;
var statearr_51035_51084 = state_50974;
(statearr_51035_51084[(5)] = ex__33847__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_50974);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e51034;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33845__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51085 = state_50974;
state_50974 = G__51085;
continue;
} else {
return ret_value__33845__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__33844__auto__ = function(state_50974){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__33844__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__33844__auto____1.call(this,state_50974);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__33844__auto____0;
cljs$core$async$mix_$_state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__33844__auto____1;
return cljs$core$async$mix_$_state_machine__33844__auto__;
})()
;})(switch__33843__auto__,c__33866__auto___51037,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__33868__auto__ = (function (){var statearr_51036 = f__33867__auto__.call(null);
(statearr_51036[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33866__auto___51037);

return statearr_51036;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33868__auto__);
});})(c__33866__auto___51037,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__9872__auto__ = (((p == null))?null:p);
var m__9873__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__9872__auto__)]);
if(!((m__9873__auto__ == null))){
return m__9873__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__9873__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__9873__auto____$1 == null))){
return m__9873__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__9872__auto__ = (((p == null))?null:p);
var m__9873__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__9872__auto__)]);
if(!((m__9873__auto__ == null))){
return m__9873__auto__.call(null,p,v,ch);
} else {
var m__9873__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__9873__auto____$1 == null))){
return m__9873__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args51086 = [];
var len__10375__auto___51089 = arguments.length;
var i__10376__auto___51090 = (0);
while(true){
if((i__10376__auto___51090 < len__10375__auto___51089)){
args51086.push((arguments[i__10376__auto___51090]));

var G__51091 = (i__10376__auto___51090 + (1));
i__10376__auto___51090 = G__51091;
continue;
} else {
}
break;
}

var G__51088 = args51086.length;
switch (G__51088) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args51086.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__9872__auto__ = (((p == null))?null:p);
var m__9873__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__9872__auto__)]);
if(!((m__9873__auto__ == null))){
return m__9873__auto__.call(null,p);
} else {
var m__9873__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__9873__auto____$1 == null))){
return m__9873__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__9872__auto__ = (((p == null))?null:p);
var m__9873__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__9872__auto__)]);
if(!((m__9873__auto__ == null))){
return m__9873__auto__.call(null,p,v);
} else {
var m__9873__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__9873__auto____$1 == null))){
return m__9873__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args51094 = [];
var len__10375__auto___51219 = arguments.length;
var i__10376__auto___51220 = (0);
while(true){
if((i__10376__auto___51220 < len__10375__auto___51219)){
args51094.push((arguments[i__10376__auto___51220]));

var G__51221 = (i__10376__auto___51220 + (1));
i__10376__auto___51220 = G__51221;
continue;
} else {
}
break;
}

var G__51096 = args51094.length;
switch (G__51096) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args51094.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__9154__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__9154__auto__)){
return or__9154__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__9154__auto__,mults){
return (function (p1__51093_SHARP_){
if(cljs.core.truth_(p1__51093_SHARP_.call(null,topic))){
return p1__51093_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__51093_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__9154__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async51097 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async51097 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta51098){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta51098 = meta51098;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async51097.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_51099,meta51098__$1){
var self__ = this;
var _51099__$1 = this;
return (new cljs.core.async.t_cljs$core$async51097(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta51098__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async51097.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_51099){
var self__ = this;
var _51099__$1 = this;
return self__.meta51098;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async51097.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async51097.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async51097.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async51097.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async51097.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__6738__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__6738__auto__)){
var m = temp__6738__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async51097.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async51097.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async51097.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta51098","meta51098",1273605963,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async51097.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async51097.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async51097";

cljs.core.async.t_cljs$core$async51097.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__9811__auto__,writer__9812__auto__,opt__9813__auto__){
return cljs.core._write.call(null,writer__9812__auto__,"cljs.core.async/t_cljs$core$async51097");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async51097 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async51097(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta51098){
return (new cljs.core.async.t_cljs$core$async51097(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta51098));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async51097(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__33866__auto___51223 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33866__auto___51223,mults,ensure_mult,p){
return (function (){
var f__33867__auto__ = (function (){var switch__33843__auto__ = ((function (c__33866__auto___51223,mults,ensure_mult,p){
return (function (state_51171){
var state_val_51172 = (state_51171[(1)]);
if((state_val_51172 === (7))){
var inst_51167 = (state_51171[(2)]);
var state_51171__$1 = state_51171;
var statearr_51173_51224 = state_51171__$1;
(statearr_51173_51224[(2)] = inst_51167);

(statearr_51173_51224[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51172 === (20))){
var state_51171__$1 = state_51171;
var statearr_51174_51225 = state_51171__$1;
(statearr_51174_51225[(2)] = null);

(statearr_51174_51225[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51172 === (1))){
var state_51171__$1 = state_51171;
var statearr_51175_51226 = state_51171__$1;
(statearr_51175_51226[(2)] = null);

(statearr_51175_51226[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51172 === (24))){
var inst_51150 = (state_51171[(7)]);
var inst_51159 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_51150);
var state_51171__$1 = state_51171;
var statearr_51176_51227 = state_51171__$1;
(statearr_51176_51227[(2)] = inst_51159);

(statearr_51176_51227[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51172 === (4))){
var inst_51102 = (state_51171[(8)]);
var inst_51102__$1 = (state_51171[(2)]);
var inst_51103 = (inst_51102__$1 == null);
var state_51171__$1 = (function (){var statearr_51177 = state_51171;
(statearr_51177[(8)] = inst_51102__$1);

return statearr_51177;
})();
if(cljs.core.truth_(inst_51103)){
var statearr_51178_51228 = state_51171__$1;
(statearr_51178_51228[(1)] = (5));

} else {
var statearr_51179_51229 = state_51171__$1;
(statearr_51179_51229[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51172 === (15))){
var inst_51144 = (state_51171[(2)]);
var state_51171__$1 = state_51171;
var statearr_51180_51230 = state_51171__$1;
(statearr_51180_51230[(2)] = inst_51144);

(statearr_51180_51230[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51172 === (21))){
var inst_51164 = (state_51171[(2)]);
var state_51171__$1 = (function (){var statearr_51181 = state_51171;
(statearr_51181[(9)] = inst_51164);

return statearr_51181;
})();
var statearr_51182_51231 = state_51171__$1;
(statearr_51182_51231[(2)] = null);

(statearr_51182_51231[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51172 === (13))){
var inst_51126 = (state_51171[(10)]);
var inst_51128 = cljs.core.chunked_seq_QMARK_.call(null,inst_51126);
var state_51171__$1 = state_51171;
if(inst_51128){
var statearr_51183_51232 = state_51171__$1;
(statearr_51183_51232[(1)] = (16));

} else {
var statearr_51184_51233 = state_51171__$1;
(statearr_51184_51233[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51172 === (22))){
var inst_51156 = (state_51171[(2)]);
var state_51171__$1 = state_51171;
if(cljs.core.truth_(inst_51156)){
var statearr_51185_51234 = state_51171__$1;
(statearr_51185_51234[(1)] = (23));

} else {
var statearr_51186_51235 = state_51171__$1;
(statearr_51186_51235[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51172 === (6))){
var inst_51152 = (state_51171[(11)]);
var inst_51150 = (state_51171[(7)]);
var inst_51102 = (state_51171[(8)]);
var inst_51150__$1 = topic_fn.call(null,inst_51102);
var inst_51151 = cljs.core.deref.call(null,mults);
var inst_51152__$1 = cljs.core.get.call(null,inst_51151,inst_51150__$1);
var state_51171__$1 = (function (){var statearr_51187 = state_51171;
(statearr_51187[(11)] = inst_51152__$1);

(statearr_51187[(7)] = inst_51150__$1);

return statearr_51187;
})();
if(cljs.core.truth_(inst_51152__$1)){
var statearr_51188_51236 = state_51171__$1;
(statearr_51188_51236[(1)] = (19));

} else {
var statearr_51189_51237 = state_51171__$1;
(statearr_51189_51237[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51172 === (25))){
var inst_51161 = (state_51171[(2)]);
var state_51171__$1 = state_51171;
var statearr_51190_51238 = state_51171__$1;
(statearr_51190_51238[(2)] = inst_51161);

(statearr_51190_51238[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51172 === (17))){
var inst_51126 = (state_51171[(10)]);
var inst_51135 = cljs.core.first.call(null,inst_51126);
var inst_51136 = cljs.core.async.muxch_STAR_.call(null,inst_51135);
var inst_51137 = cljs.core.async.close_BANG_.call(null,inst_51136);
var inst_51138 = cljs.core.next.call(null,inst_51126);
var inst_51112 = inst_51138;
var inst_51113 = null;
var inst_51114 = (0);
var inst_51115 = (0);
var state_51171__$1 = (function (){var statearr_51191 = state_51171;
(statearr_51191[(12)] = inst_51112);

(statearr_51191[(13)] = inst_51114);

(statearr_51191[(14)] = inst_51113);

(statearr_51191[(15)] = inst_51137);

(statearr_51191[(16)] = inst_51115);

return statearr_51191;
})();
var statearr_51192_51239 = state_51171__$1;
(statearr_51192_51239[(2)] = null);

(statearr_51192_51239[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51172 === (3))){
var inst_51169 = (state_51171[(2)]);
var state_51171__$1 = state_51171;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_51171__$1,inst_51169);
} else {
if((state_val_51172 === (12))){
var inst_51146 = (state_51171[(2)]);
var state_51171__$1 = state_51171;
var statearr_51193_51240 = state_51171__$1;
(statearr_51193_51240[(2)] = inst_51146);

(statearr_51193_51240[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51172 === (2))){
var state_51171__$1 = state_51171;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51171__$1,(4),ch);
} else {
if((state_val_51172 === (23))){
var state_51171__$1 = state_51171;
var statearr_51194_51241 = state_51171__$1;
(statearr_51194_51241[(2)] = null);

(statearr_51194_51241[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51172 === (19))){
var inst_51152 = (state_51171[(11)]);
var inst_51102 = (state_51171[(8)]);
var inst_51154 = cljs.core.async.muxch_STAR_.call(null,inst_51152);
var state_51171__$1 = state_51171;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_51171__$1,(22),inst_51154,inst_51102);
} else {
if((state_val_51172 === (11))){
var inst_51112 = (state_51171[(12)]);
var inst_51126 = (state_51171[(10)]);
var inst_51126__$1 = cljs.core.seq.call(null,inst_51112);
var state_51171__$1 = (function (){var statearr_51195 = state_51171;
(statearr_51195[(10)] = inst_51126__$1);

return statearr_51195;
})();
if(inst_51126__$1){
var statearr_51196_51242 = state_51171__$1;
(statearr_51196_51242[(1)] = (13));

} else {
var statearr_51197_51243 = state_51171__$1;
(statearr_51197_51243[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51172 === (9))){
var inst_51148 = (state_51171[(2)]);
var state_51171__$1 = state_51171;
var statearr_51198_51244 = state_51171__$1;
(statearr_51198_51244[(2)] = inst_51148);

(statearr_51198_51244[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51172 === (5))){
var inst_51109 = cljs.core.deref.call(null,mults);
var inst_51110 = cljs.core.vals.call(null,inst_51109);
var inst_51111 = cljs.core.seq.call(null,inst_51110);
var inst_51112 = inst_51111;
var inst_51113 = null;
var inst_51114 = (0);
var inst_51115 = (0);
var state_51171__$1 = (function (){var statearr_51199 = state_51171;
(statearr_51199[(12)] = inst_51112);

(statearr_51199[(13)] = inst_51114);

(statearr_51199[(14)] = inst_51113);

(statearr_51199[(16)] = inst_51115);

return statearr_51199;
})();
var statearr_51200_51245 = state_51171__$1;
(statearr_51200_51245[(2)] = null);

(statearr_51200_51245[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51172 === (14))){
var state_51171__$1 = state_51171;
var statearr_51204_51246 = state_51171__$1;
(statearr_51204_51246[(2)] = null);

(statearr_51204_51246[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51172 === (16))){
var inst_51126 = (state_51171[(10)]);
var inst_51130 = cljs.core.chunk_first.call(null,inst_51126);
var inst_51131 = cljs.core.chunk_rest.call(null,inst_51126);
var inst_51132 = cljs.core.count.call(null,inst_51130);
var inst_51112 = inst_51131;
var inst_51113 = inst_51130;
var inst_51114 = inst_51132;
var inst_51115 = (0);
var state_51171__$1 = (function (){var statearr_51205 = state_51171;
(statearr_51205[(12)] = inst_51112);

(statearr_51205[(13)] = inst_51114);

(statearr_51205[(14)] = inst_51113);

(statearr_51205[(16)] = inst_51115);

return statearr_51205;
})();
var statearr_51206_51247 = state_51171__$1;
(statearr_51206_51247[(2)] = null);

(statearr_51206_51247[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51172 === (10))){
var inst_51112 = (state_51171[(12)]);
var inst_51114 = (state_51171[(13)]);
var inst_51113 = (state_51171[(14)]);
var inst_51115 = (state_51171[(16)]);
var inst_51120 = cljs.core._nth.call(null,inst_51113,inst_51115);
var inst_51121 = cljs.core.async.muxch_STAR_.call(null,inst_51120);
var inst_51122 = cljs.core.async.close_BANG_.call(null,inst_51121);
var inst_51123 = (inst_51115 + (1));
var tmp51201 = inst_51112;
var tmp51202 = inst_51114;
var tmp51203 = inst_51113;
var inst_51112__$1 = tmp51201;
var inst_51113__$1 = tmp51203;
var inst_51114__$1 = tmp51202;
var inst_51115__$1 = inst_51123;
var state_51171__$1 = (function (){var statearr_51207 = state_51171;
(statearr_51207[(12)] = inst_51112__$1);

(statearr_51207[(13)] = inst_51114__$1);

(statearr_51207[(14)] = inst_51113__$1);

(statearr_51207[(16)] = inst_51115__$1);

(statearr_51207[(17)] = inst_51122);

return statearr_51207;
})();
var statearr_51208_51248 = state_51171__$1;
(statearr_51208_51248[(2)] = null);

(statearr_51208_51248[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51172 === (18))){
var inst_51141 = (state_51171[(2)]);
var state_51171__$1 = state_51171;
var statearr_51209_51249 = state_51171__$1;
(statearr_51209_51249[(2)] = inst_51141);

(statearr_51209_51249[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51172 === (8))){
var inst_51114 = (state_51171[(13)]);
var inst_51115 = (state_51171[(16)]);
var inst_51117 = (inst_51115 < inst_51114);
var inst_51118 = inst_51117;
var state_51171__$1 = state_51171;
if(cljs.core.truth_(inst_51118)){
var statearr_51210_51250 = state_51171__$1;
(statearr_51210_51250[(1)] = (10));

} else {
var statearr_51211_51251 = state_51171__$1;
(statearr_51211_51251[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33866__auto___51223,mults,ensure_mult,p))
;
return ((function (switch__33843__auto__,c__33866__auto___51223,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__33844__auto__ = null;
var cljs$core$async$state_machine__33844__auto____0 = (function (){
var statearr_51215 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_51215[(0)] = cljs$core$async$state_machine__33844__auto__);

(statearr_51215[(1)] = (1));

return statearr_51215;
});
var cljs$core$async$state_machine__33844__auto____1 = (function (state_51171){
while(true){
var ret_value__33845__auto__ = (function (){try{while(true){
var result__33846__auto__ = switch__33843__auto__.call(null,state_51171);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33846__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33846__auto__;
}
break;
}
}catch (e51216){if((e51216 instanceof Object)){
var ex__33847__auto__ = e51216;
var statearr_51217_51252 = state_51171;
(statearr_51217_51252[(5)] = ex__33847__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_51171);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e51216;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33845__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51253 = state_51171;
state_51171 = G__51253;
continue;
} else {
return ret_value__33845__auto__;
}
break;
}
});
cljs$core$async$state_machine__33844__auto__ = function(state_51171){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33844__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33844__auto____1.call(this,state_51171);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33844__auto____0;
cljs$core$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33844__auto____1;
return cljs$core$async$state_machine__33844__auto__;
})()
;})(switch__33843__auto__,c__33866__auto___51223,mults,ensure_mult,p))
})();
var state__33868__auto__ = (function (){var statearr_51218 = f__33867__auto__.call(null);
(statearr_51218[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33866__auto___51223);

return statearr_51218;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33868__auto__);
});})(c__33866__auto___51223,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args51254 = [];
var len__10375__auto___51257 = arguments.length;
var i__10376__auto___51258 = (0);
while(true){
if((i__10376__auto___51258 < len__10375__auto___51257)){
args51254.push((arguments[i__10376__auto___51258]));

var G__51259 = (i__10376__auto___51258 + (1));
i__10376__auto___51258 = G__51259;
continue;
} else {
}
break;
}

var G__51256 = args51254.length;
switch (G__51256) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args51254.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args51261 = [];
var len__10375__auto___51264 = arguments.length;
var i__10376__auto___51265 = (0);
while(true){
if((i__10376__auto___51265 < len__10375__auto___51264)){
args51261.push((arguments[i__10376__auto___51265]));

var G__51266 = (i__10376__auto___51265 + (1));
i__10376__auto___51265 = G__51266;
continue;
} else {
}
break;
}

var G__51263 = args51261.length;
switch (G__51263) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args51261.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args51268 = [];
var len__10375__auto___51339 = arguments.length;
var i__10376__auto___51340 = (0);
while(true){
if((i__10376__auto___51340 < len__10375__auto___51339)){
args51268.push((arguments[i__10376__auto___51340]));

var G__51341 = (i__10376__auto___51340 + (1));
i__10376__auto___51340 = G__51341;
continue;
} else {
}
break;
}

var G__51270 = args51268.length;
switch (G__51270) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args51268.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__33866__auto___51343 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33866__auto___51343,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__33867__auto__ = (function (){var switch__33843__auto__ = ((function (c__33866__auto___51343,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_51309){
var state_val_51310 = (state_51309[(1)]);
if((state_val_51310 === (7))){
var state_51309__$1 = state_51309;
var statearr_51311_51344 = state_51309__$1;
(statearr_51311_51344[(2)] = null);

(statearr_51311_51344[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51310 === (1))){
var state_51309__$1 = state_51309;
var statearr_51312_51345 = state_51309__$1;
(statearr_51312_51345[(2)] = null);

(statearr_51312_51345[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51310 === (4))){
var inst_51273 = (state_51309[(7)]);
var inst_51275 = (inst_51273 < cnt);
var state_51309__$1 = state_51309;
if(cljs.core.truth_(inst_51275)){
var statearr_51313_51346 = state_51309__$1;
(statearr_51313_51346[(1)] = (6));

} else {
var statearr_51314_51347 = state_51309__$1;
(statearr_51314_51347[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51310 === (15))){
var inst_51305 = (state_51309[(2)]);
var state_51309__$1 = state_51309;
var statearr_51315_51348 = state_51309__$1;
(statearr_51315_51348[(2)] = inst_51305);

(statearr_51315_51348[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51310 === (13))){
var inst_51298 = cljs.core.async.close_BANG_.call(null,out);
var state_51309__$1 = state_51309;
var statearr_51316_51349 = state_51309__$1;
(statearr_51316_51349[(2)] = inst_51298);

(statearr_51316_51349[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51310 === (6))){
var state_51309__$1 = state_51309;
var statearr_51317_51350 = state_51309__$1;
(statearr_51317_51350[(2)] = null);

(statearr_51317_51350[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51310 === (3))){
var inst_51307 = (state_51309[(2)]);
var state_51309__$1 = state_51309;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_51309__$1,inst_51307);
} else {
if((state_val_51310 === (12))){
var inst_51295 = (state_51309[(8)]);
var inst_51295__$1 = (state_51309[(2)]);
var inst_51296 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_51295__$1);
var state_51309__$1 = (function (){var statearr_51318 = state_51309;
(statearr_51318[(8)] = inst_51295__$1);

return statearr_51318;
})();
if(cljs.core.truth_(inst_51296)){
var statearr_51319_51351 = state_51309__$1;
(statearr_51319_51351[(1)] = (13));

} else {
var statearr_51320_51352 = state_51309__$1;
(statearr_51320_51352[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51310 === (2))){
var inst_51272 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_51273 = (0);
var state_51309__$1 = (function (){var statearr_51321 = state_51309;
(statearr_51321[(9)] = inst_51272);

(statearr_51321[(7)] = inst_51273);

return statearr_51321;
})();
var statearr_51322_51353 = state_51309__$1;
(statearr_51322_51353[(2)] = null);

(statearr_51322_51353[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51310 === (11))){
var inst_51273 = (state_51309[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_51309,(10),Object,null,(9));
var inst_51282 = chs__$1.call(null,inst_51273);
var inst_51283 = done.call(null,inst_51273);
var inst_51284 = cljs.core.async.take_BANG_.call(null,inst_51282,inst_51283);
var state_51309__$1 = state_51309;
var statearr_51323_51354 = state_51309__$1;
(statearr_51323_51354[(2)] = inst_51284);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_51309__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51310 === (9))){
var inst_51273 = (state_51309[(7)]);
var inst_51286 = (state_51309[(2)]);
var inst_51287 = (inst_51273 + (1));
var inst_51273__$1 = inst_51287;
var state_51309__$1 = (function (){var statearr_51324 = state_51309;
(statearr_51324[(7)] = inst_51273__$1);

(statearr_51324[(10)] = inst_51286);

return statearr_51324;
})();
var statearr_51325_51355 = state_51309__$1;
(statearr_51325_51355[(2)] = null);

(statearr_51325_51355[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51310 === (5))){
var inst_51293 = (state_51309[(2)]);
var state_51309__$1 = (function (){var statearr_51326 = state_51309;
(statearr_51326[(11)] = inst_51293);

return statearr_51326;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51309__$1,(12),dchan);
} else {
if((state_val_51310 === (14))){
var inst_51295 = (state_51309[(8)]);
var inst_51300 = cljs.core.apply.call(null,f,inst_51295);
var state_51309__$1 = state_51309;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_51309__$1,(16),out,inst_51300);
} else {
if((state_val_51310 === (16))){
var inst_51302 = (state_51309[(2)]);
var state_51309__$1 = (function (){var statearr_51327 = state_51309;
(statearr_51327[(12)] = inst_51302);

return statearr_51327;
})();
var statearr_51328_51356 = state_51309__$1;
(statearr_51328_51356[(2)] = null);

(statearr_51328_51356[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51310 === (10))){
var inst_51277 = (state_51309[(2)]);
var inst_51278 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_51309__$1 = (function (){var statearr_51329 = state_51309;
(statearr_51329[(13)] = inst_51277);

return statearr_51329;
})();
var statearr_51330_51357 = state_51309__$1;
(statearr_51330_51357[(2)] = inst_51278);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_51309__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51310 === (8))){
var inst_51291 = (state_51309[(2)]);
var state_51309__$1 = state_51309;
var statearr_51331_51358 = state_51309__$1;
(statearr_51331_51358[(2)] = inst_51291);

(statearr_51331_51358[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33866__auto___51343,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__33843__auto__,c__33866__auto___51343,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__33844__auto__ = null;
var cljs$core$async$state_machine__33844__auto____0 = (function (){
var statearr_51335 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_51335[(0)] = cljs$core$async$state_machine__33844__auto__);

(statearr_51335[(1)] = (1));

return statearr_51335;
});
var cljs$core$async$state_machine__33844__auto____1 = (function (state_51309){
while(true){
var ret_value__33845__auto__ = (function (){try{while(true){
var result__33846__auto__ = switch__33843__auto__.call(null,state_51309);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33846__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33846__auto__;
}
break;
}
}catch (e51336){if((e51336 instanceof Object)){
var ex__33847__auto__ = e51336;
var statearr_51337_51359 = state_51309;
(statearr_51337_51359[(5)] = ex__33847__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_51309);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e51336;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33845__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51360 = state_51309;
state_51309 = G__51360;
continue;
} else {
return ret_value__33845__auto__;
}
break;
}
});
cljs$core$async$state_machine__33844__auto__ = function(state_51309){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33844__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33844__auto____1.call(this,state_51309);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33844__auto____0;
cljs$core$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33844__auto____1;
return cljs$core$async$state_machine__33844__auto__;
})()
;})(switch__33843__auto__,c__33866__auto___51343,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__33868__auto__ = (function (){var statearr_51338 = f__33867__auto__.call(null);
(statearr_51338[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33866__auto___51343);

return statearr_51338;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33868__auto__);
});})(c__33866__auto___51343,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args51362 = [];
var len__10375__auto___51420 = arguments.length;
var i__10376__auto___51421 = (0);
while(true){
if((i__10376__auto___51421 < len__10375__auto___51420)){
args51362.push((arguments[i__10376__auto___51421]));

var G__51422 = (i__10376__auto___51421 + (1));
i__10376__auto___51421 = G__51422;
continue;
} else {
}
break;
}

var G__51364 = args51362.length;
switch (G__51364) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args51362.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__33866__auto___51424 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33866__auto___51424,out){
return (function (){
var f__33867__auto__ = (function (){var switch__33843__auto__ = ((function (c__33866__auto___51424,out){
return (function (state_51396){
var state_val_51397 = (state_51396[(1)]);
if((state_val_51397 === (7))){
var inst_51375 = (state_51396[(7)]);
var inst_51376 = (state_51396[(8)]);
var inst_51375__$1 = (state_51396[(2)]);
var inst_51376__$1 = cljs.core.nth.call(null,inst_51375__$1,(0),null);
var inst_51377 = cljs.core.nth.call(null,inst_51375__$1,(1),null);
var inst_51378 = (inst_51376__$1 == null);
var state_51396__$1 = (function (){var statearr_51398 = state_51396;
(statearr_51398[(7)] = inst_51375__$1);

(statearr_51398[(9)] = inst_51377);

(statearr_51398[(8)] = inst_51376__$1);

return statearr_51398;
})();
if(cljs.core.truth_(inst_51378)){
var statearr_51399_51425 = state_51396__$1;
(statearr_51399_51425[(1)] = (8));

} else {
var statearr_51400_51426 = state_51396__$1;
(statearr_51400_51426[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51397 === (1))){
var inst_51365 = cljs.core.vec.call(null,chs);
var inst_51366 = inst_51365;
var state_51396__$1 = (function (){var statearr_51401 = state_51396;
(statearr_51401[(10)] = inst_51366);

return statearr_51401;
})();
var statearr_51402_51427 = state_51396__$1;
(statearr_51402_51427[(2)] = null);

(statearr_51402_51427[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51397 === (4))){
var inst_51366 = (state_51396[(10)]);
var state_51396__$1 = state_51396;
return cljs.core.async.ioc_alts_BANG_.call(null,state_51396__$1,(7),inst_51366);
} else {
if((state_val_51397 === (6))){
var inst_51392 = (state_51396[(2)]);
var state_51396__$1 = state_51396;
var statearr_51403_51428 = state_51396__$1;
(statearr_51403_51428[(2)] = inst_51392);

(statearr_51403_51428[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51397 === (3))){
var inst_51394 = (state_51396[(2)]);
var state_51396__$1 = state_51396;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_51396__$1,inst_51394);
} else {
if((state_val_51397 === (2))){
var inst_51366 = (state_51396[(10)]);
var inst_51368 = cljs.core.count.call(null,inst_51366);
var inst_51369 = (inst_51368 > (0));
var state_51396__$1 = state_51396;
if(cljs.core.truth_(inst_51369)){
var statearr_51405_51429 = state_51396__$1;
(statearr_51405_51429[(1)] = (4));

} else {
var statearr_51406_51430 = state_51396__$1;
(statearr_51406_51430[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51397 === (11))){
var inst_51366 = (state_51396[(10)]);
var inst_51385 = (state_51396[(2)]);
var tmp51404 = inst_51366;
var inst_51366__$1 = tmp51404;
var state_51396__$1 = (function (){var statearr_51407 = state_51396;
(statearr_51407[(10)] = inst_51366__$1);

(statearr_51407[(11)] = inst_51385);

return statearr_51407;
})();
var statearr_51408_51431 = state_51396__$1;
(statearr_51408_51431[(2)] = null);

(statearr_51408_51431[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51397 === (9))){
var inst_51376 = (state_51396[(8)]);
var state_51396__$1 = state_51396;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_51396__$1,(11),out,inst_51376);
} else {
if((state_val_51397 === (5))){
var inst_51390 = cljs.core.async.close_BANG_.call(null,out);
var state_51396__$1 = state_51396;
var statearr_51409_51432 = state_51396__$1;
(statearr_51409_51432[(2)] = inst_51390);

(statearr_51409_51432[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51397 === (10))){
var inst_51388 = (state_51396[(2)]);
var state_51396__$1 = state_51396;
var statearr_51410_51433 = state_51396__$1;
(statearr_51410_51433[(2)] = inst_51388);

(statearr_51410_51433[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51397 === (8))){
var inst_51375 = (state_51396[(7)]);
var inst_51377 = (state_51396[(9)]);
var inst_51366 = (state_51396[(10)]);
var inst_51376 = (state_51396[(8)]);
var inst_51380 = (function (){var cs = inst_51366;
var vec__51371 = inst_51375;
var v = inst_51376;
var c = inst_51377;
return ((function (cs,vec__51371,v,c,inst_51375,inst_51377,inst_51366,inst_51376,state_val_51397,c__33866__auto___51424,out){
return (function (p1__51361_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__51361_SHARP_);
});
;})(cs,vec__51371,v,c,inst_51375,inst_51377,inst_51366,inst_51376,state_val_51397,c__33866__auto___51424,out))
})();
var inst_51381 = cljs.core.filterv.call(null,inst_51380,inst_51366);
var inst_51366__$1 = inst_51381;
var state_51396__$1 = (function (){var statearr_51411 = state_51396;
(statearr_51411[(10)] = inst_51366__$1);

return statearr_51411;
})();
var statearr_51412_51434 = state_51396__$1;
(statearr_51412_51434[(2)] = null);

(statearr_51412_51434[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__33866__auto___51424,out))
;
return ((function (switch__33843__auto__,c__33866__auto___51424,out){
return (function() {
var cljs$core$async$state_machine__33844__auto__ = null;
var cljs$core$async$state_machine__33844__auto____0 = (function (){
var statearr_51416 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_51416[(0)] = cljs$core$async$state_machine__33844__auto__);

(statearr_51416[(1)] = (1));

return statearr_51416;
});
var cljs$core$async$state_machine__33844__auto____1 = (function (state_51396){
while(true){
var ret_value__33845__auto__ = (function (){try{while(true){
var result__33846__auto__ = switch__33843__auto__.call(null,state_51396);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33846__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33846__auto__;
}
break;
}
}catch (e51417){if((e51417 instanceof Object)){
var ex__33847__auto__ = e51417;
var statearr_51418_51435 = state_51396;
(statearr_51418_51435[(5)] = ex__33847__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_51396);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e51417;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33845__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51436 = state_51396;
state_51396 = G__51436;
continue;
} else {
return ret_value__33845__auto__;
}
break;
}
});
cljs$core$async$state_machine__33844__auto__ = function(state_51396){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33844__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33844__auto____1.call(this,state_51396);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33844__auto____0;
cljs$core$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33844__auto____1;
return cljs$core$async$state_machine__33844__auto__;
})()
;})(switch__33843__auto__,c__33866__auto___51424,out))
})();
var state__33868__auto__ = (function (){var statearr_51419 = f__33867__auto__.call(null);
(statearr_51419[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33866__auto___51424);

return statearr_51419;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33868__auto__);
});})(c__33866__auto___51424,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args51437 = [];
var len__10375__auto___51486 = arguments.length;
var i__10376__auto___51487 = (0);
while(true){
if((i__10376__auto___51487 < len__10375__auto___51486)){
args51437.push((arguments[i__10376__auto___51487]));

var G__51488 = (i__10376__auto___51487 + (1));
i__10376__auto___51487 = G__51488;
continue;
} else {
}
break;
}

var G__51439 = args51437.length;
switch (G__51439) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args51437.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__33866__auto___51490 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33866__auto___51490,out){
return (function (){
var f__33867__auto__ = (function (){var switch__33843__auto__ = ((function (c__33866__auto___51490,out){
return (function (state_51463){
var state_val_51464 = (state_51463[(1)]);
if((state_val_51464 === (7))){
var inst_51445 = (state_51463[(7)]);
var inst_51445__$1 = (state_51463[(2)]);
var inst_51446 = (inst_51445__$1 == null);
var inst_51447 = cljs.core.not.call(null,inst_51446);
var state_51463__$1 = (function (){var statearr_51465 = state_51463;
(statearr_51465[(7)] = inst_51445__$1);

return statearr_51465;
})();
if(inst_51447){
var statearr_51466_51491 = state_51463__$1;
(statearr_51466_51491[(1)] = (8));

} else {
var statearr_51467_51492 = state_51463__$1;
(statearr_51467_51492[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51464 === (1))){
var inst_51440 = (0);
var state_51463__$1 = (function (){var statearr_51468 = state_51463;
(statearr_51468[(8)] = inst_51440);

return statearr_51468;
})();
var statearr_51469_51493 = state_51463__$1;
(statearr_51469_51493[(2)] = null);

(statearr_51469_51493[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51464 === (4))){
var state_51463__$1 = state_51463;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51463__$1,(7),ch);
} else {
if((state_val_51464 === (6))){
var inst_51458 = (state_51463[(2)]);
var state_51463__$1 = state_51463;
var statearr_51470_51494 = state_51463__$1;
(statearr_51470_51494[(2)] = inst_51458);

(statearr_51470_51494[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51464 === (3))){
var inst_51460 = (state_51463[(2)]);
var inst_51461 = cljs.core.async.close_BANG_.call(null,out);
var state_51463__$1 = (function (){var statearr_51471 = state_51463;
(statearr_51471[(9)] = inst_51460);

return statearr_51471;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_51463__$1,inst_51461);
} else {
if((state_val_51464 === (2))){
var inst_51440 = (state_51463[(8)]);
var inst_51442 = (inst_51440 < n);
var state_51463__$1 = state_51463;
if(cljs.core.truth_(inst_51442)){
var statearr_51472_51495 = state_51463__$1;
(statearr_51472_51495[(1)] = (4));

} else {
var statearr_51473_51496 = state_51463__$1;
(statearr_51473_51496[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51464 === (11))){
var inst_51440 = (state_51463[(8)]);
var inst_51450 = (state_51463[(2)]);
var inst_51451 = (inst_51440 + (1));
var inst_51440__$1 = inst_51451;
var state_51463__$1 = (function (){var statearr_51474 = state_51463;
(statearr_51474[(10)] = inst_51450);

(statearr_51474[(8)] = inst_51440__$1);

return statearr_51474;
})();
var statearr_51475_51497 = state_51463__$1;
(statearr_51475_51497[(2)] = null);

(statearr_51475_51497[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51464 === (9))){
var state_51463__$1 = state_51463;
var statearr_51476_51498 = state_51463__$1;
(statearr_51476_51498[(2)] = null);

(statearr_51476_51498[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51464 === (5))){
var state_51463__$1 = state_51463;
var statearr_51477_51499 = state_51463__$1;
(statearr_51477_51499[(2)] = null);

(statearr_51477_51499[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51464 === (10))){
var inst_51455 = (state_51463[(2)]);
var state_51463__$1 = state_51463;
var statearr_51478_51500 = state_51463__$1;
(statearr_51478_51500[(2)] = inst_51455);

(statearr_51478_51500[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51464 === (8))){
var inst_51445 = (state_51463[(7)]);
var state_51463__$1 = state_51463;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_51463__$1,(11),out,inst_51445);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__33866__auto___51490,out))
;
return ((function (switch__33843__auto__,c__33866__auto___51490,out){
return (function() {
var cljs$core$async$state_machine__33844__auto__ = null;
var cljs$core$async$state_machine__33844__auto____0 = (function (){
var statearr_51482 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_51482[(0)] = cljs$core$async$state_machine__33844__auto__);

(statearr_51482[(1)] = (1));

return statearr_51482;
});
var cljs$core$async$state_machine__33844__auto____1 = (function (state_51463){
while(true){
var ret_value__33845__auto__ = (function (){try{while(true){
var result__33846__auto__ = switch__33843__auto__.call(null,state_51463);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33846__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33846__auto__;
}
break;
}
}catch (e51483){if((e51483 instanceof Object)){
var ex__33847__auto__ = e51483;
var statearr_51484_51501 = state_51463;
(statearr_51484_51501[(5)] = ex__33847__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_51463);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e51483;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33845__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51502 = state_51463;
state_51463 = G__51502;
continue;
} else {
return ret_value__33845__auto__;
}
break;
}
});
cljs$core$async$state_machine__33844__auto__ = function(state_51463){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33844__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33844__auto____1.call(this,state_51463);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33844__auto____0;
cljs$core$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33844__auto____1;
return cljs$core$async$state_machine__33844__auto__;
})()
;})(switch__33843__auto__,c__33866__auto___51490,out))
})();
var state__33868__auto__ = (function (){var statearr_51485 = f__33867__auto__.call(null);
(statearr_51485[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33866__auto___51490);

return statearr_51485;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33868__auto__);
});})(c__33866__auto___51490,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async51510 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async51510 = (function (f,ch,meta51511){
this.f = f;
this.ch = ch;
this.meta51511 = meta51511;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async51510.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_51512,meta51511__$1){
var self__ = this;
var _51512__$1 = this;
return (new cljs.core.async.t_cljs$core$async51510(self__.f,self__.ch,meta51511__$1));
});

cljs.core.async.t_cljs$core$async51510.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_51512){
var self__ = this;
var _51512__$1 = this;
return self__.meta51511;
});

cljs.core.async.t_cljs$core$async51510.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async51510.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async51510.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async51510.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async51510.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async51513 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async51513 = (function (f,ch,meta51511,_,fn1,meta51514){
this.f = f;
this.ch = ch;
this.meta51511 = meta51511;
this._ = _;
this.fn1 = fn1;
this.meta51514 = meta51514;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async51513.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_51515,meta51514__$1){
var self__ = this;
var _51515__$1 = this;
return (new cljs.core.async.t_cljs$core$async51513(self__.f,self__.ch,self__.meta51511,self__._,self__.fn1,meta51514__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async51513.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_51515){
var self__ = this;
var _51515__$1 = this;
return self__.meta51514;
});})(___$1))
;

cljs.core.async.t_cljs$core$async51513.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async51513.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async51513.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async51513.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__51503_SHARP_){
return f1.call(null,(((p1__51503_SHARP_ == null))?null:self__.f.call(null,p1__51503_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async51513.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta51511","meta51511",-1596193220,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async51510","cljs.core.async/t_cljs$core$async51510",-75217236,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta51514","meta51514",853881523,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async51513.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async51513.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async51513";

cljs.core.async.t_cljs$core$async51513.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__9811__auto__,writer__9812__auto__,opt__9813__auto__){
return cljs.core._write.call(null,writer__9812__auto__,"cljs.core.async/t_cljs$core$async51513");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async51513 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async51513(f__$1,ch__$1,meta51511__$1,___$2,fn1__$1,meta51514){
return (new cljs.core.async.t_cljs$core$async51513(f__$1,ch__$1,meta51511__$1,___$2,fn1__$1,meta51514));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async51513(self__.f,self__.ch,self__.meta51511,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__9142__auto__ = ret;
if(cljs.core.truth_(and__9142__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__9142__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async51510.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async51510.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async51510.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta51511","meta51511",-1596193220,null)], null);
});

cljs.core.async.t_cljs$core$async51510.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async51510.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async51510";

cljs.core.async.t_cljs$core$async51510.cljs$lang$ctorPrWriter = (function (this__9811__auto__,writer__9812__auto__,opt__9813__auto__){
return cljs.core._write.call(null,writer__9812__auto__,"cljs.core.async/t_cljs$core$async51510");
});

cljs.core.async.__GT_t_cljs$core$async51510 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async51510(f__$1,ch__$1,meta51511){
return (new cljs.core.async.t_cljs$core$async51510(f__$1,ch__$1,meta51511));
});

}

return (new cljs.core.async.t_cljs$core$async51510(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async51519 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async51519 = (function (f,ch,meta51520){
this.f = f;
this.ch = ch;
this.meta51520 = meta51520;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async51519.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_51521,meta51520__$1){
var self__ = this;
var _51521__$1 = this;
return (new cljs.core.async.t_cljs$core$async51519(self__.f,self__.ch,meta51520__$1));
});

cljs.core.async.t_cljs$core$async51519.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_51521){
var self__ = this;
var _51521__$1 = this;
return self__.meta51520;
});

cljs.core.async.t_cljs$core$async51519.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async51519.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async51519.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async51519.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async51519.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async51519.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async51519.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta51520","meta51520",1884162589,null)], null);
});

cljs.core.async.t_cljs$core$async51519.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async51519.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async51519";

cljs.core.async.t_cljs$core$async51519.cljs$lang$ctorPrWriter = (function (this__9811__auto__,writer__9812__auto__,opt__9813__auto__){
return cljs.core._write.call(null,writer__9812__auto__,"cljs.core.async/t_cljs$core$async51519");
});

cljs.core.async.__GT_t_cljs$core$async51519 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async51519(f__$1,ch__$1,meta51520){
return (new cljs.core.async.t_cljs$core$async51519(f__$1,ch__$1,meta51520));
});

}

return (new cljs.core.async.t_cljs$core$async51519(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async51525 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async51525 = (function (p,ch,meta51526){
this.p = p;
this.ch = ch;
this.meta51526 = meta51526;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async51525.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_51527,meta51526__$1){
var self__ = this;
var _51527__$1 = this;
return (new cljs.core.async.t_cljs$core$async51525(self__.p,self__.ch,meta51526__$1));
});

cljs.core.async.t_cljs$core$async51525.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_51527){
var self__ = this;
var _51527__$1 = this;
return self__.meta51526;
});

cljs.core.async.t_cljs$core$async51525.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async51525.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async51525.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async51525.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async51525.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async51525.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async51525.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async51525.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta51526","meta51526",1659490328,null)], null);
});

cljs.core.async.t_cljs$core$async51525.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async51525.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async51525";

cljs.core.async.t_cljs$core$async51525.cljs$lang$ctorPrWriter = (function (this__9811__auto__,writer__9812__auto__,opt__9813__auto__){
return cljs.core._write.call(null,writer__9812__auto__,"cljs.core.async/t_cljs$core$async51525");
});

cljs.core.async.__GT_t_cljs$core$async51525 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async51525(p__$1,ch__$1,meta51526){
return (new cljs.core.async.t_cljs$core$async51525(p__$1,ch__$1,meta51526));
});

}

return (new cljs.core.async.t_cljs$core$async51525(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args51528 = [];
var len__10375__auto___51572 = arguments.length;
var i__10376__auto___51573 = (0);
while(true){
if((i__10376__auto___51573 < len__10375__auto___51572)){
args51528.push((arguments[i__10376__auto___51573]));

var G__51574 = (i__10376__auto___51573 + (1));
i__10376__auto___51573 = G__51574;
continue;
} else {
}
break;
}

var G__51530 = args51528.length;
switch (G__51530) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args51528.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__33866__auto___51576 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33866__auto___51576,out){
return (function (){
var f__33867__auto__ = (function (){var switch__33843__auto__ = ((function (c__33866__auto___51576,out){
return (function (state_51551){
var state_val_51552 = (state_51551[(1)]);
if((state_val_51552 === (7))){
var inst_51547 = (state_51551[(2)]);
var state_51551__$1 = state_51551;
var statearr_51553_51577 = state_51551__$1;
(statearr_51553_51577[(2)] = inst_51547);

(statearr_51553_51577[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51552 === (1))){
var state_51551__$1 = state_51551;
var statearr_51554_51578 = state_51551__$1;
(statearr_51554_51578[(2)] = null);

(statearr_51554_51578[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51552 === (4))){
var inst_51533 = (state_51551[(7)]);
var inst_51533__$1 = (state_51551[(2)]);
var inst_51534 = (inst_51533__$1 == null);
var state_51551__$1 = (function (){var statearr_51555 = state_51551;
(statearr_51555[(7)] = inst_51533__$1);

return statearr_51555;
})();
if(cljs.core.truth_(inst_51534)){
var statearr_51556_51579 = state_51551__$1;
(statearr_51556_51579[(1)] = (5));

} else {
var statearr_51557_51580 = state_51551__$1;
(statearr_51557_51580[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51552 === (6))){
var inst_51533 = (state_51551[(7)]);
var inst_51538 = p.call(null,inst_51533);
var state_51551__$1 = state_51551;
if(cljs.core.truth_(inst_51538)){
var statearr_51558_51581 = state_51551__$1;
(statearr_51558_51581[(1)] = (8));

} else {
var statearr_51559_51582 = state_51551__$1;
(statearr_51559_51582[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51552 === (3))){
var inst_51549 = (state_51551[(2)]);
var state_51551__$1 = state_51551;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_51551__$1,inst_51549);
} else {
if((state_val_51552 === (2))){
var state_51551__$1 = state_51551;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51551__$1,(4),ch);
} else {
if((state_val_51552 === (11))){
var inst_51541 = (state_51551[(2)]);
var state_51551__$1 = state_51551;
var statearr_51560_51583 = state_51551__$1;
(statearr_51560_51583[(2)] = inst_51541);

(statearr_51560_51583[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51552 === (9))){
var state_51551__$1 = state_51551;
var statearr_51561_51584 = state_51551__$1;
(statearr_51561_51584[(2)] = null);

(statearr_51561_51584[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51552 === (5))){
var inst_51536 = cljs.core.async.close_BANG_.call(null,out);
var state_51551__$1 = state_51551;
var statearr_51562_51585 = state_51551__$1;
(statearr_51562_51585[(2)] = inst_51536);

(statearr_51562_51585[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51552 === (10))){
var inst_51544 = (state_51551[(2)]);
var state_51551__$1 = (function (){var statearr_51563 = state_51551;
(statearr_51563[(8)] = inst_51544);

return statearr_51563;
})();
var statearr_51564_51586 = state_51551__$1;
(statearr_51564_51586[(2)] = null);

(statearr_51564_51586[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51552 === (8))){
var inst_51533 = (state_51551[(7)]);
var state_51551__$1 = state_51551;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_51551__$1,(11),out,inst_51533);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__33866__auto___51576,out))
;
return ((function (switch__33843__auto__,c__33866__auto___51576,out){
return (function() {
var cljs$core$async$state_machine__33844__auto__ = null;
var cljs$core$async$state_machine__33844__auto____0 = (function (){
var statearr_51568 = [null,null,null,null,null,null,null,null,null];
(statearr_51568[(0)] = cljs$core$async$state_machine__33844__auto__);

(statearr_51568[(1)] = (1));

return statearr_51568;
});
var cljs$core$async$state_machine__33844__auto____1 = (function (state_51551){
while(true){
var ret_value__33845__auto__ = (function (){try{while(true){
var result__33846__auto__ = switch__33843__auto__.call(null,state_51551);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33846__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33846__auto__;
}
break;
}
}catch (e51569){if((e51569 instanceof Object)){
var ex__33847__auto__ = e51569;
var statearr_51570_51587 = state_51551;
(statearr_51570_51587[(5)] = ex__33847__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_51551);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e51569;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33845__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51588 = state_51551;
state_51551 = G__51588;
continue;
} else {
return ret_value__33845__auto__;
}
break;
}
});
cljs$core$async$state_machine__33844__auto__ = function(state_51551){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33844__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33844__auto____1.call(this,state_51551);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33844__auto____0;
cljs$core$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33844__auto____1;
return cljs$core$async$state_machine__33844__auto__;
})()
;})(switch__33843__auto__,c__33866__auto___51576,out))
})();
var state__33868__auto__ = (function (){var statearr_51571 = f__33867__auto__.call(null);
(statearr_51571[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33866__auto___51576);

return statearr_51571;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33868__auto__);
});})(c__33866__auto___51576,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args51589 = [];
var len__10375__auto___51592 = arguments.length;
var i__10376__auto___51593 = (0);
while(true){
if((i__10376__auto___51593 < len__10375__auto___51592)){
args51589.push((arguments[i__10376__auto___51593]));

var G__51594 = (i__10376__auto___51593 + (1));
i__10376__auto___51593 = G__51594;
continue;
} else {
}
break;
}

var G__51591 = args51589.length;
switch (G__51591) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args51589.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__33866__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33866__auto__){
return (function (){
var f__33867__auto__ = (function (){var switch__33843__auto__ = ((function (c__33866__auto__){
return (function (state_51761){
var state_val_51762 = (state_51761[(1)]);
if((state_val_51762 === (7))){
var inst_51757 = (state_51761[(2)]);
var state_51761__$1 = state_51761;
var statearr_51763_51804 = state_51761__$1;
(statearr_51763_51804[(2)] = inst_51757);

(statearr_51763_51804[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51762 === (20))){
var inst_51727 = (state_51761[(7)]);
var inst_51738 = (state_51761[(2)]);
var inst_51739 = cljs.core.next.call(null,inst_51727);
var inst_51713 = inst_51739;
var inst_51714 = null;
var inst_51715 = (0);
var inst_51716 = (0);
var state_51761__$1 = (function (){var statearr_51764 = state_51761;
(statearr_51764[(8)] = inst_51738);

(statearr_51764[(9)] = inst_51713);

(statearr_51764[(10)] = inst_51715);

(statearr_51764[(11)] = inst_51716);

(statearr_51764[(12)] = inst_51714);

return statearr_51764;
})();
var statearr_51765_51805 = state_51761__$1;
(statearr_51765_51805[(2)] = null);

(statearr_51765_51805[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51762 === (1))){
var state_51761__$1 = state_51761;
var statearr_51766_51806 = state_51761__$1;
(statearr_51766_51806[(2)] = null);

(statearr_51766_51806[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51762 === (4))){
var inst_51702 = (state_51761[(13)]);
var inst_51702__$1 = (state_51761[(2)]);
var inst_51703 = (inst_51702__$1 == null);
var state_51761__$1 = (function (){var statearr_51767 = state_51761;
(statearr_51767[(13)] = inst_51702__$1);

return statearr_51767;
})();
if(cljs.core.truth_(inst_51703)){
var statearr_51768_51807 = state_51761__$1;
(statearr_51768_51807[(1)] = (5));

} else {
var statearr_51769_51808 = state_51761__$1;
(statearr_51769_51808[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51762 === (15))){
var state_51761__$1 = state_51761;
var statearr_51773_51809 = state_51761__$1;
(statearr_51773_51809[(2)] = null);

(statearr_51773_51809[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51762 === (21))){
var state_51761__$1 = state_51761;
var statearr_51774_51810 = state_51761__$1;
(statearr_51774_51810[(2)] = null);

(statearr_51774_51810[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51762 === (13))){
var inst_51713 = (state_51761[(9)]);
var inst_51715 = (state_51761[(10)]);
var inst_51716 = (state_51761[(11)]);
var inst_51714 = (state_51761[(12)]);
var inst_51723 = (state_51761[(2)]);
var inst_51724 = (inst_51716 + (1));
var tmp51770 = inst_51713;
var tmp51771 = inst_51715;
var tmp51772 = inst_51714;
var inst_51713__$1 = tmp51770;
var inst_51714__$1 = tmp51772;
var inst_51715__$1 = tmp51771;
var inst_51716__$1 = inst_51724;
var state_51761__$1 = (function (){var statearr_51775 = state_51761;
(statearr_51775[(14)] = inst_51723);

(statearr_51775[(9)] = inst_51713__$1);

(statearr_51775[(10)] = inst_51715__$1);

(statearr_51775[(11)] = inst_51716__$1);

(statearr_51775[(12)] = inst_51714__$1);

return statearr_51775;
})();
var statearr_51776_51811 = state_51761__$1;
(statearr_51776_51811[(2)] = null);

(statearr_51776_51811[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51762 === (22))){
var state_51761__$1 = state_51761;
var statearr_51777_51812 = state_51761__$1;
(statearr_51777_51812[(2)] = null);

(statearr_51777_51812[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51762 === (6))){
var inst_51702 = (state_51761[(13)]);
var inst_51711 = f.call(null,inst_51702);
var inst_51712 = cljs.core.seq.call(null,inst_51711);
var inst_51713 = inst_51712;
var inst_51714 = null;
var inst_51715 = (0);
var inst_51716 = (0);
var state_51761__$1 = (function (){var statearr_51778 = state_51761;
(statearr_51778[(9)] = inst_51713);

(statearr_51778[(10)] = inst_51715);

(statearr_51778[(11)] = inst_51716);

(statearr_51778[(12)] = inst_51714);

return statearr_51778;
})();
var statearr_51779_51813 = state_51761__$1;
(statearr_51779_51813[(2)] = null);

(statearr_51779_51813[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51762 === (17))){
var inst_51727 = (state_51761[(7)]);
var inst_51731 = cljs.core.chunk_first.call(null,inst_51727);
var inst_51732 = cljs.core.chunk_rest.call(null,inst_51727);
var inst_51733 = cljs.core.count.call(null,inst_51731);
var inst_51713 = inst_51732;
var inst_51714 = inst_51731;
var inst_51715 = inst_51733;
var inst_51716 = (0);
var state_51761__$1 = (function (){var statearr_51780 = state_51761;
(statearr_51780[(9)] = inst_51713);

(statearr_51780[(10)] = inst_51715);

(statearr_51780[(11)] = inst_51716);

(statearr_51780[(12)] = inst_51714);

return statearr_51780;
})();
var statearr_51781_51814 = state_51761__$1;
(statearr_51781_51814[(2)] = null);

(statearr_51781_51814[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51762 === (3))){
var inst_51759 = (state_51761[(2)]);
var state_51761__$1 = state_51761;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_51761__$1,inst_51759);
} else {
if((state_val_51762 === (12))){
var inst_51747 = (state_51761[(2)]);
var state_51761__$1 = state_51761;
var statearr_51782_51815 = state_51761__$1;
(statearr_51782_51815[(2)] = inst_51747);

(statearr_51782_51815[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51762 === (2))){
var state_51761__$1 = state_51761;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51761__$1,(4),in$);
} else {
if((state_val_51762 === (23))){
var inst_51755 = (state_51761[(2)]);
var state_51761__$1 = state_51761;
var statearr_51783_51816 = state_51761__$1;
(statearr_51783_51816[(2)] = inst_51755);

(statearr_51783_51816[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51762 === (19))){
var inst_51742 = (state_51761[(2)]);
var state_51761__$1 = state_51761;
var statearr_51784_51817 = state_51761__$1;
(statearr_51784_51817[(2)] = inst_51742);

(statearr_51784_51817[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51762 === (11))){
var inst_51727 = (state_51761[(7)]);
var inst_51713 = (state_51761[(9)]);
var inst_51727__$1 = cljs.core.seq.call(null,inst_51713);
var state_51761__$1 = (function (){var statearr_51785 = state_51761;
(statearr_51785[(7)] = inst_51727__$1);

return statearr_51785;
})();
if(inst_51727__$1){
var statearr_51786_51818 = state_51761__$1;
(statearr_51786_51818[(1)] = (14));

} else {
var statearr_51787_51819 = state_51761__$1;
(statearr_51787_51819[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51762 === (9))){
var inst_51749 = (state_51761[(2)]);
var inst_51750 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_51761__$1 = (function (){var statearr_51788 = state_51761;
(statearr_51788[(15)] = inst_51749);

return statearr_51788;
})();
if(cljs.core.truth_(inst_51750)){
var statearr_51789_51820 = state_51761__$1;
(statearr_51789_51820[(1)] = (21));

} else {
var statearr_51790_51821 = state_51761__$1;
(statearr_51790_51821[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51762 === (5))){
var inst_51705 = cljs.core.async.close_BANG_.call(null,out);
var state_51761__$1 = state_51761;
var statearr_51791_51822 = state_51761__$1;
(statearr_51791_51822[(2)] = inst_51705);

(statearr_51791_51822[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51762 === (14))){
var inst_51727 = (state_51761[(7)]);
var inst_51729 = cljs.core.chunked_seq_QMARK_.call(null,inst_51727);
var state_51761__$1 = state_51761;
if(inst_51729){
var statearr_51792_51823 = state_51761__$1;
(statearr_51792_51823[(1)] = (17));

} else {
var statearr_51793_51824 = state_51761__$1;
(statearr_51793_51824[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51762 === (16))){
var inst_51745 = (state_51761[(2)]);
var state_51761__$1 = state_51761;
var statearr_51794_51825 = state_51761__$1;
(statearr_51794_51825[(2)] = inst_51745);

(statearr_51794_51825[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51762 === (10))){
var inst_51716 = (state_51761[(11)]);
var inst_51714 = (state_51761[(12)]);
var inst_51721 = cljs.core._nth.call(null,inst_51714,inst_51716);
var state_51761__$1 = state_51761;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_51761__$1,(13),out,inst_51721);
} else {
if((state_val_51762 === (18))){
var inst_51727 = (state_51761[(7)]);
var inst_51736 = cljs.core.first.call(null,inst_51727);
var state_51761__$1 = state_51761;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_51761__$1,(20),out,inst_51736);
} else {
if((state_val_51762 === (8))){
var inst_51715 = (state_51761[(10)]);
var inst_51716 = (state_51761[(11)]);
var inst_51718 = (inst_51716 < inst_51715);
var inst_51719 = inst_51718;
var state_51761__$1 = state_51761;
if(cljs.core.truth_(inst_51719)){
var statearr_51795_51826 = state_51761__$1;
(statearr_51795_51826[(1)] = (10));

} else {
var statearr_51796_51827 = state_51761__$1;
(statearr_51796_51827[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33866__auto__))
;
return ((function (switch__33843__auto__,c__33866__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__33844__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__33844__auto____0 = (function (){
var statearr_51800 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_51800[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__33844__auto__);

(statearr_51800[(1)] = (1));

return statearr_51800;
});
var cljs$core$async$mapcat_STAR__$_state_machine__33844__auto____1 = (function (state_51761){
while(true){
var ret_value__33845__auto__ = (function (){try{while(true){
var result__33846__auto__ = switch__33843__auto__.call(null,state_51761);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33846__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33846__auto__;
}
break;
}
}catch (e51801){if((e51801 instanceof Object)){
var ex__33847__auto__ = e51801;
var statearr_51802_51828 = state_51761;
(statearr_51802_51828[(5)] = ex__33847__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_51761);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e51801;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33845__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51829 = state_51761;
state_51761 = G__51829;
continue;
} else {
return ret_value__33845__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__33844__auto__ = function(state_51761){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__33844__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__33844__auto____1.call(this,state_51761);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__33844__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__33844__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__33844__auto__;
})()
;})(switch__33843__auto__,c__33866__auto__))
})();
var state__33868__auto__ = (function (){var statearr_51803 = f__33867__auto__.call(null);
(statearr_51803[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33866__auto__);

return statearr_51803;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33868__auto__);
});})(c__33866__auto__))
);

return c__33866__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args51830 = [];
var len__10375__auto___51833 = arguments.length;
var i__10376__auto___51834 = (0);
while(true){
if((i__10376__auto___51834 < len__10375__auto___51833)){
args51830.push((arguments[i__10376__auto___51834]));

var G__51835 = (i__10376__auto___51834 + (1));
i__10376__auto___51834 = G__51835;
continue;
} else {
}
break;
}

var G__51832 = args51830.length;
switch (G__51832) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args51830.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args51837 = [];
var len__10375__auto___51840 = arguments.length;
var i__10376__auto___51841 = (0);
while(true){
if((i__10376__auto___51841 < len__10375__auto___51840)){
args51837.push((arguments[i__10376__auto___51841]));

var G__51842 = (i__10376__auto___51841 + (1));
i__10376__auto___51841 = G__51842;
continue;
} else {
}
break;
}

var G__51839 = args51837.length;
switch (G__51839) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args51837.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args51844 = [];
var len__10375__auto___51895 = arguments.length;
var i__10376__auto___51896 = (0);
while(true){
if((i__10376__auto___51896 < len__10375__auto___51895)){
args51844.push((arguments[i__10376__auto___51896]));

var G__51897 = (i__10376__auto___51896 + (1));
i__10376__auto___51896 = G__51897;
continue;
} else {
}
break;
}

var G__51846 = args51844.length;
switch (G__51846) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args51844.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__33866__auto___51899 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33866__auto___51899,out){
return (function (){
var f__33867__auto__ = (function (){var switch__33843__auto__ = ((function (c__33866__auto___51899,out){
return (function (state_51870){
var state_val_51871 = (state_51870[(1)]);
if((state_val_51871 === (7))){
var inst_51865 = (state_51870[(2)]);
var state_51870__$1 = state_51870;
var statearr_51872_51900 = state_51870__$1;
(statearr_51872_51900[(2)] = inst_51865);

(statearr_51872_51900[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51871 === (1))){
var inst_51847 = null;
var state_51870__$1 = (function (){var statearr_51873 = state_51870;
(statearr_51873[(7)] = inst_51847);

return statearr_51873;
})();
var statearr_51874_51901 = state_51870__$1;
(statearr_51874_51901[(2)] = null);

(statearr_51874_51901[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51871 === (4))){
var inst_51850 = (state_51870[(8)]);
var inst_51850__$1 = (state_51870[(2)]);
var inst_51851 = (inst_51850__$1 == null);
var inst_51852 = cljs.core.not.call(null,inst_51851);
var state_51870__$1 = (function (){var statearr_51875 = state_51870;
(statearr_51875[(8)] = inst_51850__$1);

return statearr_51875;
})();
if(inst_51852){
var statearr_51876_51902 = state_51870__$1;
(statearr_51876_51902[(1)] = (5));

} else {
var statearr_51877_51903 = state_51870__$1;
(statearr_51877_51903[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51871 === (6))){
var state_51870__$1 = state_51870;
var statearr_51878_51904 = state_51870__$1;
(statearr_51878_51904[(2)] = null);

(statearr_51878_51904[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51871 === (3))){
var inst_51867 = (state_51870[(2)]);
var inst_51868 = cljs.core.async.close_BANG_.call(null,out);
var state_51870__$1 = (function (){var statearr_51879 = state_51870;
(statearr_51879[(9)] = inst_51867);

return statearr_51879;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_51870__$1,inst_51868);
} else {
if((state_val_51871 === (2))){
var state_51870__$1 = state_51870;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51870__$1,(4),ch);
} else {
if((state_val_51871 === (11))){
var inst_51850 = (state_51870[(8)]);
var inst_51859 = (state_51870[(2)]);
var inst_51847 = inst_51850;
var state_51870__$1 = (function (){var statearr_51880 = state_51870;
(statearr_51880[(7)] = inst_51847);

(statearr_51880[(10)] = inst_51859);

return statearr_51880;
})();
var statearr_51881_51905 = state_51870__$1;
(statearr_51881_51905[(2)] = null);

(statearr_51881_51905[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51871 === (9))){
var inst_51850 = (state_51870[(8)]);
var state_51870__$1 = state_51870;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_51870__$1,(11),out,inst_51850);
} else {
if((state_val_51871 === (5))){
var inst_51847 = (state_51870[(7)]);
var inst_51850 = (state_51870[(8)]);
var inst_51854 = cljs.core._EQ_.call(null,inst_51850,inst_51847);
var state_51870__$1 = state_51870;
if(inst_51854){
var statearr_51883_51906 = state_51870__$1;
(statearr_51883_51906[(1)] = (8));

} else {
var statearr_51884_51907 = state_51870__$1;
(statearr_51884_51907[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51871 === (10))){
var inst_51862 = (state_51870[(2)]);
var state_51870__$1 = state_51870;
var statearr_51885_51908 = state_51870__$1;
(statearr_51885_51908[(2)] = inst_51862);

(statearr_51885_51908[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51871 === (8))){
var inst_51847 = (state_51870[(7)]);
var tmp51882 = inst_51847;
var inst_51847__$1 = tmp51882;
var state_51870__$1 = (function (){var statearr_51886 = state_51870;
(statearr_51886[(7)] = inst_51847__$1);

return statearr_51886;
})();
var statearr_51887_51909 = state_51870__$1;
(statearr_51887_51909[(2)] = null);

(statearr_51887_51909[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__33866__auto___51899,out))
;
return ((function (switch__33843__auto__,c__33866__auto___51899,out){
return (function() {
var cljs$core$async$state_machine__33844__auto__ = null;
var cljs$core$async$state_machine__33844__auto____0 = (function (){
var statearr_51891 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_51891[(0)] = cljs$core$async$state_machine__33844__auto__);

(statearr_51891[(1)] = (1));

return statearr_51891;
});
var cljs$core$async$state_machine__33844__auto____1 = (function (state_51870){
while(true){
var ret_value__33845__auto__ = (function (){try{while(true){
var result__33846__auto__ = switch__33843__auto__.call(null,state_51870);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33846__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33846__auto__;
}
break;
}
}catch (e51892){if((e51892 instanceof Object)){
var ex__33847__auto__ = e51892;
var statearr_51893_51910 = state_51870;
(statearr_51893_51910[(5)] = ex__33847__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_51870);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e51892;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33845__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51911 = state_51870;
state_51870 = G__51911;
continue;
} else {
return ret_value__33845__auto__;
}
break;
}
});
cljs$core$async$state_machine__33844__auto__ = function(state_51870){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33844__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33844__auto____1.call(this,state_51870);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33844__auto____0;
cljs$core$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33844__auto____1;
return cljs$core$async$state_machine__33844__auto__;
})()
;})(switch__33843__auto__,c__33866__auto___51899,out))
})();
var state__33868__auto__ = (function (){var statearr_51894 = f__33867__auto__.call(null);
(statearr_51894[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33866__auto___51899);

return statearr_51894;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33868__auto__);
});})(c__33866__auto___51899,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args51912 = [];
var len__10375__auto___51982 = arguments.length;
var i__10376__auto___51983 = (0);
while(true){
if((i__10376__auto___51983 < len__10375__auto___51982)){
args51912.push((arguments[i__10376__auto___51983]));

var G__51984 = (i__10376__auto___51983 + (1));
i__10376__auto___51983 = G__51984;
continue;
} else {
}
break;
}

var G__51914 = args51912.length;
switch (G__51914) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args51912.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__33866__auto___51986 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33866__auto___51986,out){
return (function (){
var f__33867__auto__ = (function (){var switch__33843__auto__ = ((function (c__33866__auto___51986,out){
return (function (state_51952){
var state_val_51953 = (state_51952[(1)]);
if((state_val_51953 === (7))){
var inst_51948 = (state_51952[(2)]);
var state_51952__$1 = state_51952;
var statearr_51954_51987 = state_51952__$1;
(statearr_51954_51987[(2)] = inst_51948);

(statearr_51954_51987[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51953 === (1))){
var inst_51915 = (new Array(n));
var inst_51916 = inst_51915;
var inst_51917 = (0);
var state_51952__$1 = (function (){var statearr_51955 = state_51952;
(statearr_51955[(7)] = inst_51916);

(statearr_51955[(8)] = inst_51917);

return statearr_51955;
})();
var statearr_51956_51988 = state_51952__$1;
(statearr_51956_51988[(2)] = null);

(statearr_51956_51988[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51953 === (4))){
var inst_51920 = (state_51952[(9)]);
var inst_51920__$1 = (state_51952[(2)]);
var inst_51921 = (inst_51920__$1 == null);
var inst_51922 = cljs.core.not.call(null,inst_51921);
var state_51952__$1 = (function (){var statearr_51957 = state_51952;
(statearr_51957[(9)] = inst_51920__$1);

return statearr_51957;
})();
if(inst_51922){
var statearr_51958_51989 = state_51952__$1;
(statearr_51958_51989[(1)] = (5));

} else {
var statearr_51959_51990 = state_51952__$1;
(statearr_51959_51990[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51953 === (15))){
var inst_51942 = (state_51952[(2)]);
var state_51952__$1 = state_51952;
var statearr_51960_51991 = state_51952__$1;
(statearr_51960_51991[(2)] = inst_51942);

(statearr_51960_51991[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51953 === (13))){
var state_51952__$1 = state_51952;
var statearr_51961_51992 = state_51952__$1;
(statearr_51961_51992[(2)] = null);

(statearr_51961_51992[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51953 === (6))){
var inst_51917 = (state_51952[(8)]);
var inst_51938 = (inst_51917 > (0));
var state_51952__$1 = state_51952;
if(cljs.core.truth_(inst_51938)){
var statearr_51962_51993 = state_51952__$1;
(statearr_51962_51993[(1)] = (12));

} else {
var statearr_51963_51994 = state_51952__$1;
(statearr_51963_51994[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51953 === (3))){
var inst_51950 = (state_51952[(2)]);
var state_51952__$1 = state_51952;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_51952__$1,inst_51950);
} else {
if((state_val_51953 === (12))){
var inst_51916 = (state_51952[(7)]);
var inst_51940 = cljs.core.vec.call(null,inst_51916);
var state_51952__$1 = state_51952;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_51952__$1,(15),out,inst_51940);
} else {
if((state_val_51953 === (2))){
var state_51952__$1 = state_51952;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51952__$1,(4),ch);
} else {
if((state_val_51953 === (11))){
var inst_51932 = (state_51952[(2)]);
var inst_51933 = (new Array(n));
var inst_51916 = inst_51933;
var inst_51917 = (0);
var state_51952__$1 = (function (){var statearr_51964 = state_51952;
(statearr_51964[(7)] = inst_51916);

(statearr_51964[(10)] = inst_51932);

(statearr_51964[(8)] = inst_51917);

return statearr_51964;
})();
var statearr_51965_51995 = state_51952__$1;
(statearr_51965_51995[(2)] = null);

(statearr_51965_51995[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51953 === (9))){
var inst_51916 = (state_51952[(7)]);
var inst_51930 = cljs.core.vec.call(null,inst_51916);
var state_51952__$1 = state_51952;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_51952__$1,(11),out,inst_51930);
} else {
if((state_val_51953 === (5))){
var inst_51916 = (state_51952[(7)]);
var inst_51925 = (state_51952[(11)]);
var inst_51917 = (state_51952[(8)]);
var inst_51920 = (state_51952[(9)]);
var inst_51924 = (inst_51916[inst_51917] = inst_51920);
var inst_51925__$1 = (inst_51917 + (1));
var inst_51926 = (inst_51925__$1 < n);
var state_51952__$1 = (function (){var statearr_51966 = state_51952;
(statearr_51966[(11)] = inst_51925__$1);

(statearr_51966[(12)] = inst_51924);

return statearr_51966;
})();
if(cljs.core.truth_(inst_51926)){
var statearr_51967_51996 = state_51952__$1;
(statearr_51967_51996[(1)] = (8));

} else {
var statearr_51968_51997 = state_51952__$1;
(statearr_51968_51997[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51953 === (14))){
var inst_51945 = (state_51952[(2)]);
var inst_51946 = cljs.core.async.close_BANG_.call(null,out);
var state_51952__$1 = (function (){var statearr_51970 = state_51952;
(statearr_51970[(13)] = inst_51945);

return statearr_51970;
})();
var statearr_51971_51998 = state_51952__$1;
(statearr_51971_51998[(2)] = inst_51946);

(statearr_51971_51998[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51953 === (10))){
var inst_51936 = (state_51952[(2)]);
var state_51952__$1 = state_51952;
var statearr_51972_51999 = state_51952__$1;
(statearr_51972_51999[(2)] = inst_51936);

(statearr_51972_51999[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51953 === (8))){
var inst_51916 = (state_51952[(7)]);
var inst_51925 = (state_51952[(11)]);
var tmp51969 = inst_51916;
var inst_51916__$1 = tmp51969;
var inst_51917 = inst_51925;
var state_51952__$1 = (function (){var statearr_51973 = state_51952;
(statearr_51973[(7)] = inst_51916__$1);

(statearr_51973[(8)] = inst_51917);

return statearr_51973;
})();
var statearr_51974_52000 = state_51952__$1;
(statearr_51974_52000[(2)] = null);

(statearr_51974_52000[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33866__auto___51986,out))
;
return ((function (switch__33843__auto__,c__33866__auto___51986,out){
return (function() {
var cljs$core$async$state_machine__33844__auto__ = null;
var cljs$core$async$state_machine__33844__auto____0 = (function (){
var statearr_51978 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_51978[(0)] = cljs$core$async$state_machine__33844__auto__);

(statearr_51978[(1)] = (1));

return statearr_51978;
});
var cljs$core$async$state_machine__33844__auto____1 = (function (state_51952){
while(true){
var ret_value__33845__auto__ = (function (){try{while(true){
var result__33846__auto__ = switch__33843__auto__.call(null,state_51952);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33846__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33846__auto__;
}
break;
}
}catch (e51979){if((e51979 instanceof Object)){
var ex__33847__auto__ = e51979;
var statearr_51980_52001 = state_51952;
(statearr_51980_52001[(5)] = ex__33847__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_51952);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e51979;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33845__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52002 = state_51952;
state_51952 = G__52002;
continue;
} else {
return ret_value__33845__auto__;
}
break;
}
});
cljs$core$async$state_machine__33844__auto__ = function(state_51952){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33844__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33844__auto____1.call(this,state_51952);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33844__auto____0;
cljs$core$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33844__auto____1;
return cljs$core$async$state_machine__33844__auto__;
})()
;})(switch__33843__auto__,c__33866__auto___51986,out))
})();
var state__33868__auto__ = (function (){var statearr_51981 = f__33867__auto__.call(null);
(statearr_51981[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33866__auto___51986);

return statearr_51981;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33868__auto__);
});})(c__33866__auto___51986,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args52003 = [];
var len__10375__auto___52077 = arguments.length;
var i__10376__auto___52078 = (0);
while(true){
if((i__10376__auto___52078 < len__10375__auto___52077)){
args52003.push((arguments[i__10376__auto___52078]));

var G__52079 = (i__10376__auto___52078 + (1));
i__10376__auto___52078 = G__52079;
continue;
} else {
}
break;
}

var G__52005 = args52003.length;
switch (G__52005) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52003.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__33866__auto___52081 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__33866__auto___52081,out){
return (function (){
var f__33867__auto__ = (function (){var switch__33843__auto__ = ((function (c__33866__auto___52081,out){
return (function (state_52047){
var state_val_52048 = (state_52047[(1)]);
if((state_val_52048 === (7))){
var inst_52043 = (state_52047[(2)]);
var state_52047__$1 = state_52047;
var statearr_52049_52082 = state_52047__$1;
(statearr_52049_52082[(2)] = inst_52043);

(statearr_52049_52082[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52048 === (1))){
var inst_52006 = [];
var inst_52007 = inst_52006;
var inst_52008 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_52047__$1 = (function (){var statearr_52050 = state_52047;
(statearr_52050[(7)] = inst_52008);

(statearr_52050[(8)] = inst_52007);

return statearr_52050;
})();
var statearr_52051_52083 = state_52047__$1;
(statearr_52051_52083[(2)] = null);

(statearr_52051_52083[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52048 === (4))){
var inst_52011 = (state_52047[(9)]);
var inst_52011__$1 = (state_52047[(2)]);
var inst_52012 = (inst_52011__$1 == null);
var inst_52013 = cljs.core.not.call(null,inst_52012);
var state_52047__$1 = (function (){var statearr_52052 = state_52047;
(statearr_52052[(9)] = inst_52011__$1);

return statearr_52052;
})();
if(inst_52013){
var statearr_52053_52084 = state_52047__$1;
(statearr_52053_52084[(1)] = (5));

} else {
var statearr_52054_52085 = state_52047__$1;
(statearr_52054_52085[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52048 === (15))){
var inst_52037 = (state_52047[(2)]);
var state_52047__$1 = state_52047;
var statearr_52055_52086 = state_52047__$1;
(statearr_52055_52086[(2)] = inst_52037);

(statearr_52055_52086[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52048 === (13))){
var state_52047__$1 = state_52047;
var statearr_52056_52087 = state_52047__$1;
(statearr_52056_52087[(2)] = null);

(statearr_52056_52087[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52048 === (6))){
var inst_52007 = (state_52047[(8)]);
var inst_52032 = inst_52007.length;
var inst_52033 = (inst_52032 > (0));
var state_52047__$1 = state_52047;
if(cljs.core.truth_(inst_52033)){
var statearr_52057_52088 = state_52047__$1;
(statearr_52057_52088[(1)] = (12));

} else {
var statearr_52058_52089 = state_52047__$1;
(statearr_52058_52089[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52048 === (3))){
var inst_52045 = (state_52047[(2)]);
var state_52047__$1 = state_52047;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_52047__$1,inst_52045);
} else {
if((state_val_52048 === (12))){
var inst_52007 = (state_52047[(8)]);
var inst_52035 = cljs.core.vec.call(null,inst_52007);
var state_52047__$1 = state_52047;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_52047__$1,(15),out,inst_52035);
} else {
if((state_val_52048 === (2))){
var state_52047__$1 = state_52047;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_52047__$1,(4),ch);
} else {
if((state_val_52048 === (11))){
var inst_52011 = (state_52047[(9)]);
var inst_52015 = (state_52047[(10)]);
var inst_52025 = (state_52047[(2)]);
var inst_52026 = [];
var inst_52027 = inst_52026.push(inst_52011);
var inst_52007 = inst_52026;
var inst_52008 = inst_52015;
var state_52047__$1 = (function (){var statearr_52059 = state_52047;
(statearr_52059[(7)] = inst_52008);

(statearr_52059[(8)] = inst_52007);

(statearr_52059[(11)] = inst_52027);

(statearr_52059[(12)] = inst_52025);

return statearr_52059;
})();
var statearr_52060_52090 = state_52047__$1;
(statearr_52060_52090[(2)] = null);

(statearr_52060_52090[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52048 === (9))){
var inst_52007 = (state_52047[(8)]);
var inst_52023 = cljs.core.vec.call(null,inst_52007);
var state_52047__$1 = state_52047;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_52047__$1,(11),out,inst_52023);
} else {
if((state_val_52048 === (5))){
var inst_52008 = (state_52047[(7)]);
var inst_52011 = (state_52047[(9)]);
var inst_52015 = (state_52047[(10)]);
var inst_52015__$1 = f.call(null,inst_52011);
var inst_52016 = cljs.core._EQ_.call(null,inst_52015__$1,inst_52008);
var inst_52017 = cljs.core.keyword_identical_QMARK_.call(null,inst_52008,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_52018 = (inst_52016) || (inst_52017);
var state_52047__$1 = (function (){var statearr_52061 = state_52047;
(statearr_52061[(10)] = inst_52015__$1);

return statearr_52061;
})();
if(cljs.core.truth_(inst_52018)){
var statearr_52062_52091 = state_52047__$1;
(statearr_52062_52091[(1)] = (8));

} else {
var statearr_52063_52092 = state_52047__$1;
(statearr_52063_52092[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52048 === (14))){
var inst_52040 = (state_52047[(2)]);
var inst_52041 = cljs.core.async.close_BANG_.call(null,out);
var state_52047__$1 = (function (){var statearr_52065 = state_52047;
(statearr_52065[(13)] = inst_52040);

return statearr_52065;
})();
var statearr_52066_52093 = state_52047__$1;
(statearr_52066_52093[(2)] = inst_52041);

(statearr_52066_52093[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52048 === (10))){
var inst_52030 = (state_52047[(2)]);
var state_52047__$1 = state_52047;
var statearr_52067_52094 = state_52047__$1;
(statearr_52067_52094[(2)] = inst_52030);

(statearr_52067_52094[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52048 === (8))){
var inst_52011 = (state_52047[(9)]);
var inst_52007 = (state_52047[(8)]);
var inst_52015 = (state_52047[(10)]);
var inst_52020 = inst_52007.push(inst_52011);
var tmp52064 = inst_52007;
var inst_52007__$1 = tmp52064;
var inst_52008 = inst_52015;
var state_52047__$1 = (function (){var statearr_52068 = state_52047;
(statearr_52068[(7)] = inst_52008);

(statearr_52068[(14)] = inst_52020);

(statearr_52068[(8)] = inst_52007__$1);

return statearr_52068;
})();
var statearr_52069_52095 = state_52047__$1;
(statearr_52069_52095[(2)] = null);

(statearr_52069_52095[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__33866__auto___52081,out))
;
return ((function (switch__33843__auto__,c__33866__auto___52081,out){
return (function() {
var cljs$core$async$state_machine__33844__auto__ = null;
var cljs$core$async$state_machine__33844__auto____0 = (function (){
var statearr_52073 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_52073[(0)] = cljs$core$async$state_machine__33844__auto__);

(statearr_52073[(1)] = (1));

return statearr_52073;
});
var cljs$core$async$state_machine__33844__auto____1 = (function (state_52047){
while(true){
var ret_value__33845__auto__ = (function (){try{while(true){
var result__33846__auto__ = switch__33843__auto__.call(null,state_52047);
if(cljs.core.keyword_identical_QMARK_.call(null,result__33846__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__33846__auto__;
}
break;
}
}catch (e52074){if((e52074 instanceof Object)){
var ex__33847__auto__ = e52074;
var statearr_52075_52096 = state_52047;
(statearr_52075_52096[(5)] = ex__33847__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_52047);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e52074;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__33845__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52097 = state_52047;
state_52047 = G__52097;
continue;
} else {
return ret_value__33845__auto__;
}
break;
}
});
cljs$core$async$state_machine__33844__auto__ = function(state_52047){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__33844__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__33844__auto____1.call(this,state_52047);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__33844__auto____0;
cljs$core$async$state_machine__33844__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__33844__auto____1;
return cljs$core$async$state_machine__33844__auto__;
})()
;})(switch__33843__auto__,c__33866__auto___52081,out))
})();
var state__33868__auto__ = (function (){var statearr_52076 = f__33867__auto__.call(null);
(statearr_52076[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__33866__auto___52081);

return statearr_52076;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__33868__auto__);
});})(c__33866__auto___52081,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

