goog.provide('shadow.test');
/**
 * like ct/test-vars-block but more generic
 * groups vars by namespace, executes fixtures
 */
shadow.test.test_vars_grouped_block = (function shadow$test$test_vars_grouped_block(vars){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (p__43412){
var vec__43413 = p__43412;
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43413,(0),null);
var vars__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43413,(1),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.test.report.call(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-test-ns","begin-test-ns",-1701237033),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
}),(function (){
return cljs.test.block((function (){var env = cljs.test.get_current_env();
var once_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167),ns], null));
var each_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977),ns], null));
var G__43429 = cljs.test.execution_strategy(once_fixtures,each_fixtures);
var G__43429__$1 = (((G__43429 instanceof cljs.core.Keyword))?G__43429.fqn:null);
switch (G__43429__$1) {
case "async":
return cljs.test.wrap_map_fixtures(once_fixtures,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.test.wrap_map_fixtures,each_fixtures),cljs.test.test_var_block),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),cljs.core.meta),vars__$1)], 0)));

break;
case "sync":
var each_fixture_fn = cljs.test.join_fixtures(each_fixtures);
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
var G__43504 = (function (){
var seq__43505 = cljs.core.seq(vars__$1);
var chunk__43506 = null;
var count__43507 = (0);
var i__43508 = (0);
while(true){
if((i__43508 < count__43507)){
var v = chunk__43506.cljs$core$IIndexed$_nth$arity$2(null, i__43508);
var temp__5823__auto___43706 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5823__auto___43706)){
var t_43708 = temp__5823__auto___43706;
var G__43520_43709 = ((function (seq__43505,chunk__43506,count__43507,i__43508,t_43708,temp__5823__auto___43706,v,each_fixture_fn,G__43429,G__43429__$1,env,once_fixtures,each_fixtures,vec__43413,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_43708)));
});})(seq__43505,chunk__43506,count__43507,i__43508,t_43708,temp__5823__auto___43706,v,each_fixture_fn,G__43429,G__43429__$1,env,once_fixtures,each_fixtures,vec__43413,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__43520_43709) : each_fixture_fn.call(null, G__43520_43709));
} else {
}


var G__43713 = seq__43505;
var G__43714 = chunk__43506;
var G__43715 = count__43507;
var G__43716 = (i__43508 + (1));
seq__43505 = G__43713;
chunk__43506 = G__43714;
count__43507 = G__43715;
i__43508 = G__43716;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__43505);
if(temp__5823__auto__){
var seq__43505__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__43505__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__43505__$1);
var G__43717 = cljs.core.chunk_rest(seq__43505__$1);
var G__43718 = c__5525__auto__;
var G__43719 = cljs.core.count(c__5525__auto__);
var G__43720 = (0);
seq__43505 = G__43717;
chunk__43506 = G__43718;
count__43507 = G__43719;
i__43508 = G__43720;
continue;
} else {
var v = cljs.core.first(seq__43505__$1);
var temp__5823__auto___43721__$1 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5823__auto___43721__$1)){
var t_43722 = temp__5823__auto___43721__$1;
var G__43525_43723 = ((function (seq__43505,chunk__43506,count__43507,i__43508,t_43722,temp__5823__auto___43721__$1,v,seq__43505__$1,temp__5823__auto__,each_fixture_fn,G__43429,G__43429__$1,env,once_fixtures,each_fixtures,vec__43413,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_43722)));
});})(seq__43505,chunk__43506,count__43507,i__43508,t_43722,temp__5823__auto___43721__$1,v,seq__43505__$1,temp__5823__auto__,each_fixture_fn,G__43429,G__43429__$1,env,once_fixtures,each_fixtures,vec__43413,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__43525_43723) : each_fixture_fn.call(null, G__43525_43723));
} else {
}


var G__43724 = cljs.core.next(seq__43505__$1);
var G__43725 = null;
var G__43726 = (0);
var G__43727 = (0);
seq__43505 = G__43724;
chunk__43506 = G__43725;
count__43507 = G__43726;
i__43508 = G__43727;
continue;
}
} else {
return null;
}
}
break;
}
});
var fexpr__43503 = cljs.test.join_fixtures(once_fixtures);
return (fexpr__43503.cljs$core$IFn$_invoke$arity$1 ? fexpr__43503.cljs$core$IFn$_invoke$arity$1(G__43504) : fexpr__43503.call(null, G__43504));
})], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__43429__$1)].join('')));

}
})());
}),(function (){
return cljs.test.report.call(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-test-ns","end-test-ns",1620675645),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
})], null);
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.group_by((function (p1__43401_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__43401_SHARP_));
}),vars))], 0));
});
/**
 * Like test-ns, but returns a block for further composition and
 *   later execution.  Does not clear the current env.
 */
shadow.test.test_ns_block = (function shadow$test$test_ns_block(ns){
if((ns instanceof cljs.core.Symbol)){
} else {
throw (new Error("Assert failed: (symbol? ns)"));
}

var map__43535 = shadow.test.env.get_test_ns_info(ns);
var map__43535__$1 = cljs.core.__destructure_map(map__43535);
var test_ns = map__43535__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43535__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
if(cljs.core.not(test_ns)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)," not found, no tests to run."].join('')], 0));
})], null);
} else {
return shadow.test.test_vars_grouped_block(vars);
}
});
shadow.test.prepare_test_run = (function shadow$test$prepare_test_run(p__43544,vars){
var map__43546 = p__43544;
var map__43546__$1 = cljs.core.__destructure_map(map__43546);
var env = map__43546__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43546__$1,new cljs.core.Keyword(null,"report-fn","report-fn",-549046115));
var orig_report = cljs.test.report;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
cljs.test.set_env_BANG_(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061),orig_report));

if(cljs.core.truth_(report_fn)){
(cljs.test.report = report_fn);
} else {
}

var seq__43551_43728 = cljs.core.seq(shadow.test.env.get_tests());
var chunk__43553_43729 = null;
var count__43554_43730 = (0);
var i__43555_43731 = (0);
while(true){
if((i__43555_43731 < count__43554_43730)){
var vec__43579_43732 = chunk__43553_43729.cljs$core$IIndexed$_nth$arity$2(null, i__43555_43731);
var test_ns_43733 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43579_43732,(0),null);
var ns_info_43734 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43579_43732,(1),null);
var map__43582_43735 = ns_info_43734;
var map__43582_43736__$1 = cljs.core.__destructure_map(map__43582_43735);
var fixtures_43737 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43582_43736__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5823__auto___43738 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_43737);
if(cljs.core.truth_(temp__5823__auto___43738)){
var fix_43739 = temp__5823__auto___43738;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_43733,fix_43739], 0));
} else {
}

var temp__5823__auto___43740 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_43737);
if(cljs.core.truth_(temp__5823__auto___43740)){
var fix_43741 = temp__5823__auto___43740;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_43733,fix_43741], 0));
} else {
}


var G__43742 = seq__43551_43728;
var G__43743 = chunk__43553_43729;
var G__43744 = count__43554_43730;
var G__43745 = (i__43555_43731 + (1));
seq__43551_43728 = G__43742;
chunk__43553_43729 = G__43743;
count__43554_43730 = G__43744;
i__43555_43731 = G__43745;
continue;
} else {
var temp__5823__auto___43746 = cljs.core.seq(seq__43551_43728);
if(temp__5823__auto___43746){
var seq__43551_43747__$1 = temp__5823__auto___43746;
if(cljs.core.chunked_seq_QMARK_(seq__43551_43747__$1)){
var c__5525__auto___43748 = cljs.core.chunk_first(seq__43551_43747__$1);
var G__43749 = cljs.core.chunk_rest(seq__43551_43747__$1);
var G__43750 = c__5525__auto___43748;
var G__43751 = cljs.core.count(c__5525__auto___43748);
var G__43752 = (0);
seq__43551_43728 = G__43749;
chunk__43553_43729 = G__43750;
count__43554_43730 = G__43751;
i__43555_43731 = G__43752;
continue;
} else {
var vec__43588_43753 = cljs.core.first(seq__43551_43747__$1);
var test_ns_43754 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43588_43753,(0),null);
var ns_info_43755 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43588_43753,(1),null);
var map__43591_43756 = ns_info_43755;
var map__43591_43757__$1 = cljs.core.__destructure_map(map__43591_43756);
var fixtures_43758 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43591_43757__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5823__auto___43759__$1 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_43758);
if(cljs.core.truth_(temp__5823__auto___43759__$1)){
var fix_43760 = temp__5823__auto___43759__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_43754,fix_43760], 0));
} else {
}

var temp__5823__auto___43761__$1 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_43758);
if(cljs.core.truth_(temp__5823__auto___43761__$1)){
var fix_43762 = temp__5823__auto___43761__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_43754,fix_43762], 0));
} else {
}


var G__43763 = cljs.core.next(seq__43551_43747__$1);
var G__43764 = null;
var G__43765 = (0);
var G__43766 = (0);
seq__43551_43728 = G__43763;
chunk__43553_43729 = G__43764;
count__43554_43730 = G__43765;
i__43555_43731 = G__43766;
continue;
}
} else {
}
}
break;
}

return cljs.test.report.call(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-run-tests","begin-run-tests",309363062),new cljs.core.Keyword(null,"var-count","var-count",-1513152110),cljs.core.count(vars),new cljs.core.Keyword(null,"ns-count","ns-count",-1269070724),cljs.core.count(cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__43542_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__43542_SHARP_));
}),vars)))], null));
})], null);
});
shadow.test.finish_test_run = (function shadow$test$finish_test_run(block){
if(cljs.core.vector_QMARK_(block)){
} else {
throw (new Error("Assert failed: (vector? block)"));
}

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(block,(function (){
var map__43654 = cljs.test.get_current_env();
var map__43654__$1 = cljs.core.__destructure_map(map__43654);
var env = map__43654__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43654__$1,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061));
var report_counters = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43654__$1,new cljs.core.Keyword(null,"report-counters","report-counters",-1702609242));
cljs.test.report.call(null, cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"summary","summary",380847952)));

cljs.test.report.call(null, cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-run-tests","end-run-tests",267300563)));

return (cljs.test.report = report_fn);
}));
});
/**
 * tests all vars grouped by namespace, expects seq of test vars, can be obtained from env
 */
shadow.test.run_test_vars = (function shadow$test$run_test_vars(var_args){
var G__43658 = arguments.length;
switch (G__43658) {
case 1:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1 = (function (test_vars){
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),test_vars);
}));

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2 = (function (env,vars){
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_test_vars.cljs$lang$maxFixedArity = 2);

/**
 * test all vars for given namespace symbol
 */
shadow.test.test_ns = (function shadow$test$test_ns(var_args){
var G__43668 = arguments.length;
switch (G__43668) {
case 1:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1 = (function (ns){
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),ns);
}));

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2 = (function (env,ns){
var map__43676 = shadow.test.env.get_test_ns_info(ns);
var map__43676__$1 = cljs.core.__destructure_map(map__43676);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43676__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.test_ns.cljs$lang$maxFixedArity = 2);

/**
 * test all vars in specified namespace symbol set
 */
shadow.test.run_tests = (function shadow$test$run_tests(var_args){
var G__43684 = arguments.length;
switch (G__43684) {
case 0:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,shadow.test.env.get_test_namespaces());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,namespaces){
if(cljs.core.set_QMARK_(namespaces)){
} else {
throw (new Error("Assert failed: (set? namespaces)"));
}

var vars = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__43680_SHARP_){
return cljs.core.contains_QMARK_(namespaces,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__43680_SHARP_)));
}),shadow.test.env.get_test_vars());
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_tests.cljs$lang$maxFixedArity = 2);

/**
 * Runs all tests in all namespaces; prints results.
 *   Optional argument is a regular expression; only namespaces with
 *   names matching the regular expression (with re-matches) will be
 *   tested.
 */
shadow.test.run_all_tests = (function shadow$test$run_all_tests(var_args){
var G__43698 = arguments.length;
switch (G__43698) {
case 0:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(env,null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,re){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__43695_SHARP_){
var or__5002__auto__ = (re == null);
if(or__5002__auto__){
return or__5002__auto__;
} else {
return cljs.core.re_matches(re,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__43695_SHARP_));
}
}),shadow.test.env.get_test_namespaces())));
}));

(shadow.test.run_all_tests.cljs$lang$maxFixedArity = 2);


//# sourceMappingURL=shadow.test.js.map
