goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = true;

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_27865 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (shadow.dom._to_dom[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null, this$));
} else {
var m__5349__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null, this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_27865(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_27866 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (shadow.dom._to_svg[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null, this$));
} else {
var m__5349__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null, this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_27866(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__26911 = coll;
var G__26912 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__26911,G__26912) : shadow.dom.lazy_native_coll_seq.call(null, G__26911,G__26912));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__5002__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null, );
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__27028 = arguments.length;
switch (G__27028) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__27039 = arguments.length;
switch (G__27039) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__27052 = arguments.length;
switch (G__27052) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__27068 = arguments.length;
switch (G__27068) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__27109 = arguments.length;
switch (G__27109) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__27155 = arguments.length;
switch (G__27155) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__5002__auto__ = (!((typeof document !== 'undefined')));
if(or__5002__auto__){
return or__5002__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null, e,el));
}));
}catch (e27165){if((e27165 instanceof Object)){
var e = e27165;
return console.log("didnt support attachEvent",el,e);
} else {
throw e27165;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__5002__auto__ = (!((typeof document !== 'undefined')));
if(or__5002__auto__){
return or__5002__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__27195 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__27196 = null;
var count__27197 = (0);
var i__27198 = (0);
while(true){
if((i__27198 < count__27197)){
var el = chunk__27196.cljs$core$IIndexed$_nth$arity$2(null, i__27198);
var handler_27903__$1 = ((function (seq__27195,chunk__27196,count__27197,i__27198,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null, e,el));
});})(seq__27195,chunk__27196,count__27197,i__27198,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_27903__$1);


var G__27906 = seq__27195;
var G__27907 = chunk__27196;
var G__27908 = count__27197;
var G__27909 = (i__27198 + (1));
seq__27195 = G__27906;
chunk__27196 = G__27907;
count__27197 = G__27908;
i__27198 = G__27909;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__27195);
if(temp__5823__auto__){
var seq__27195__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__27195__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__27195__$1);
var G__27910 = cljs.core.chunk_rest(seq__27195__$1);
var G__27911 = c__5525__auto__;
var G__27912 = cljs.core.count(c__5525__auto__);
var G__27913 = (0);
seq__27195 = G__27910;
chunk__27196 = G__27911;
count__27197 = G__27912;
i__27198 = G__27913;
continue;
} else {
var el = cljs.core.first(seq__27195__$1);
var handler_27916__$1 = ((function (seq__27195,chunk__27196,count__27197,i__27198,el,seq__27195__$1,temp__5823__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null, e,el));
});})(seq__27195,chunk__27196,count__27197,i__27198,el,seq__27195__$1,temp__5823__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_27916__$1);


var G__27917 = cljs.core.next(seq__27195__$1);
var G__27918 = null;
var G__27919 = (0);
var G__27920 = (0);
seq__27195 = G__27917;
chunk__27196 = G__27918;
count__27197 = G__27919;
i__27198 = G__27920;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__27215 = arguments.length;
switch (G__27215) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null, e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__27220 = cljs.core.seq(events);
var chunk__27221 = null;
var count__27222 = (0);
var i__27223 = (0);
while(true){
if((i__27223 < count__27222)){
var vec__27236 = chunk__27221.cljs$core$IIndexed$_nth$arity$2(null, i__27223);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27236,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27236,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__27924 = seq__27220;
var G__27925 = chunk__27221;
var G__27926 = count__27222;
var G__27927 = (i__27223 + (1));
seq__27220 = G__27924;
chunk__27221 = G__27925;
count__27222 = G__27926;
i__27223 = G__27927;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__27220);
if(temp__5823__auto__){
var seq__27220__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__27220__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__27220__$1);
var G__27929 = cljs.core.chunk_rest(seq__27220__$1);
var G__27930 = c__5525__auto__;
var G__27931 = cljs.core.count(c__5525__auto__);
var G__27932 = (0);
seq__27220 = G__27929;
chunk__27221 = G__27930;
count__27222 = G__27931;
i__27223 = G__27932;
continue;
} else {
var vec__27240 = cljs.core.first(seq__27220__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27240,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27240,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__27933 = cljs.core.next(seq__27220__$1);
var G__27934 = null;
var G__27935 = (0);
var G__27936 = (0);
seq__27220 = G__27933;
chunk__27221 = G__27934;
count__27222 = G__27935;
i__27223 = G__27936;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__27245 = cljs.core.seq(styles);
var chunk__27246 = null;
var count__27247 = (0);
var i__27248 = (0);
while(true){
if((i__27248 < count__27247)){
var vec__27261 = chunk__27246.cljs$core$IIndexed$_nth$arity$2(null, i__27248);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27261,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27261,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__27937 = seq__27245;
var G__27938 = chunk__27246;
var G__27939 = count__27247;
var G__27940 = (i__27248 + (1));
seq__27245 = G__27937;
chunk__27246 = G__27938;
count__27247 = G__27939;
i__27248 = G__27940;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__27245);
if(temp__5823__auto__){
var seq__27245__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__27245__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__27245__$1);
var G__27941 = cljs.core.chunk_rest(seq__27245__$1);
var G__27942 = c__5525__auto__;
var G__27943 = cljs.core.count(c__5525__auto__);
var G__27944 = (0);
seq__27245 = G__27941;
chunk__27246 = G__27942;
count__27247 = G__27943;
i__27248 = G__27944;
continue;
} else {
var vec__27264 = cljs.core.first(seq__27245__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27264,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27264,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__27947 = cljs.core.next(seq__27245__$1);
var G__27948 = null;
var G__27949 = (0);
var G__27950 = (0);
seq__27245 = G__27947;
chunk__27246 = G__27948;
count__27247 = G__27949;
i__27248 = G__27950;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__27272_27951 = key;
var G__27272_27952__$1 = (((G__27272_27951 instanceof cljs.core.Keyword))?G__27272_27951.fqn:null);
switch (G__27272_27952__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_27956 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__5002__auto__ = goog.string.startsWith(ks_27956,"data-");
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return goog.string.startsWith(ks_27956,"aria-");
}
})())){
el.setAttribute(ks_27956,value);
} else {
(el[ks_27956] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__27285){
var map__27286 = p__27285;
var map__27286__$1 = cljs.core.__destructure_map(map__27286);
var props = map__27286__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27286__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__27288 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27288,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27288,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27288,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__27291 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__27291,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__27291;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__27297 = arguments.length;
switch (G__27297) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5823__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5823__auto__)){
var n = temp__5823__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5823__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5823__auto__)){
var n = temp__5823__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__27305){
var vec__27306 = p__27305;
var seq__27307 = cljs.core.seq(vec__27306);
var first__27308 = cljs.core.first(seq__27307);
var seq__27307__$1 = cljs.core.next(seq__27307);
var nn = first__27308;
var first__27308__$1 = cljs.core.first(seq__27307__$1);
var seq__27307__$2 = cljs.core.next(seq__27307__$1);
var np = first__27308__$1;
var nc = seq__27307__$2;
var node = vec__27306;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__27310 = nn;
var G__27311 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__27310,G__27311) : create_fn.call(null, G__27310,G__27311));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null, nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__27312 = nn;
var G__27313 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__27312,G__27313) : create_fn.call(null, G__27312,G__27313));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__27316 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27316,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27316,(1),null);
var seq__27319_27979 = cljs.core.seq(node_children);
var chunk__27320_27980 = null;
var count__27321_27981 = (0);
var i__27322_27982 = (0);
while(true){
if((i__27322_27982 < count__27321_27981)){
var child_struct_27987 = chunk__27320_27980.cljs$core$IIndexed$_nth$arity$2(null, i__27322_27982);
var children_27988 = shadow.dom.dom_node(child_struct_27987);
if(cljs.core.seq_QMARK_(children_27988)){
var seq__27342_27989 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_27988));
var chunk__27344_27990 = null;
var count__27345_27991 = (0);
var i__27346_27992 = (0);
while(true){
if((i__27346_27992 < count__27345_27991)){
var child_27995 = chunk__27344_27990.cljs$core$IIndexed$_nth$arity$2(null, i__27346_27992);
if(cljs.core.truth_(child_27995)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_27995);


var G__27996 = seq__27342_27989;
var G__27997 = chunk__27344_27990;
var G__27998 = count__27345_27991;
var G__27999 = (i__27346_27992 + (1));
seq__27342_27989 = G__27996;
chunk__27344_27990 = G__27997;
count__27345_27991 = G__27998;
i__27346_27992 = G__27999;
continue;
} else {
var G__28002 = seq__27342_27989;
var G__28003 = chunk__27344_27990;
var G__28004 = count__27345_27991;
var G__28005 = (i__27346_27992 + (1));
seq__27342_27989 = G__28002;
chunk__27344_27990 = G__28003;
count__27345_27991 = G__28004;
i__27346_27992 = G__28005;
continue;
}
} else {
var temp__5823__auto___28006 = cljs.core.seq(seq__27342_27989);
if(temp__5823__auto___28006){
var seq__27342_28007__$1 = temp__5823__auto___28006;
if(cljs.core.chunked_seq_QMARK_(seq__27342_28007__$1)){
var c__5525__auto___28008 = cljs.core.chunk_first(seq__27342_28007__$1);
var G__28009 = cljs.core.chunk_rest(seq__27342_28007__$1);
var G__28010 = c__5525__auto___28008;
var G__28011 = cljs.core.count(c__5525__auto___28008);
var G__28012 = (0);
seq__27342_27989 = G__28009;
chunk__27344_27990 = G__28010;
count__27345_27991 = G__28011;
i__27346_27992 = G__28012;
continue;
} else {
var child_28013 = cljs.core.first(seq__27342_28007__$1);
if(cljs.core.truth_(child_28013)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_28013);


var G__28017 = cljs.core.next(seq__27342_28007__$1);
var G__28018 = null;
var G__28019 = (0);
var G__28020 = (0);
seq__27342_27989 = G__28017;
chunk__27344_27990 = G__28018;
count__27345_27991 = G__28019;
i__27346_27992 = G__28020;
continue;
} else {
var G__28021 = cljs.core.next(seq__27342_28007__$1);
var G__28022 = null;
var G__28023 = (0);
var G__28024 = (0);
seq__27342_27989 = G__28021;
chunk__27344_27990 = G__28022;
count__27345_27991 = G__28023;
i__27346_27992 = G__28024;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_27988);
}


var G__28026 = seq__27319_27979;
var G__28027 = chunk__27320_27980;
var G__28028 = count__27321_27981;
var G__28029 = (i__27322_27982 + (1));
seq__27319_27979 = G__28026;
chunk__27320_27980 = G__28027;
count__27321_27981 = G__28028;
i__27322_27982 = G__28029;
continue;
} else {
var temp__5823__auto___28030 = cljs.core.seq(seq__27319_27979);
if(temp__5823__auto___28030){
var seq__27319_28031__$1 = temp__5823__auto___28030;
if(cljs.core.chunked_seq_QMARK_(seq__27319_28031__$1)){
var c__5525__auto___28032 = cljs.core.chunk_first(seq__27319_28031__$1);
var G__28033 = cljs.core.chunk_rest(seq__27319_28031__$1);
var G__28034 = c__5525__auto___28032;
var G__28035 = cljs.core.count(c__5525__auto___28032);
var G__28036 = (0);
seq__27319_27979 = G__28033;
chunk__27320_27980 = G__28034;
count__27321_27981 = G__28035;
i__27322_27982 = G__28036;
continue;
} else {
var child_struct_28037 = cljs.core.first(seq__27319_28031__$1);
var children_28038 = shadow.dom.dom_node(child_struct_28037);
if(cljs.core.seq_QMARK_(children_28038)){
var seq__27353_28039 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_28038));
var chunk__27356_28040 = null;
var count__27357_28041 = (0);
var i__27358_28042 = (0);
while(true){
if((i__27358_28042 < count__27357_28041)){
var child_28043 = chunk__27356_28040.cljs$core$IIndexed$_nth$arity$2(null, i__27358_28042);
if(cljs.core.truth_(child_28043)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_28043);


var G__28044 = seq__27353_28039;
var G__28045 = chunk__27356_28040;
var G__28046 = count__27357_28041;
var G__28047 = (i__27358_28042 + (1));
seq__27353_28039 = G__28044;
chunk__27356_28040 = G__28045;
count__27357_28041 = G__28046;
i__27358_28042 = G__28047;
continue;
} else {
var G__28048 = seq__27353_28039;
var G__28049 = chunk__27356_28040;
var G__28050 = count__27357_28041;
var G__28051 = (i__27358_28042 + (1));
seq__27353_28039 = G__28048;
chunk__27356_28040 = G__28049;
count__27357_28041 = G__28050;
i__27358_28042 = G__28051;
continue;
}
} else {
var temp__5823__auto___28053__$1 = cljs.core.seq(seq__27353_28039);
if(temp__5823__auto___28053__$1){
var seq__27353_28055__$1 = temp__5823__auto___28053__$1;
if(cljs.core.chunked_seq_QMARK_(seq__27353_28055__$1)){
var c__5525__auto___28056 = cljs.core.chunk_first(seq__27353_28055__$1);
var G__28057 = cljs.core.chunk_rest(seq__27353_28055__$1);
var G__28058 = c__5525__auto___28056;
var G__28059 = cljs.core.count(c__5525__auto___28056);
var G__28060 = (0);
seq__27353_28039 = G__28057;
chunk__27356_28040 = G__28058;
count__27357_28041 = G__28059;
i__27358_28042 = G__28060;
continue;
} else {
var child_28063 = cljs.core.first(seq__27353_28055__$1);
if(cljs.core.truth_(child_28063)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_28063);


var G__28064 = cljs.core.next(seq__27353_28055__$1);
var G__28065 = null;
var G__28066 = (0);
var G__28067 = (0);
seq__27353_28039 = G__28064;
chunk__27356_28040 = G__28065;
count__27357_28041 = G__28066;
i__27358_28042 = G__28067;
continue;
} else {
var G__28068 = cljs.core.next(seq__27353_28055__$1);
var G__28069 = null;
var G__28070 = (0);
var G__28071 = (0);
seq__27353_28039 = G__28068;
chunk__27356_28040 = G__28069;
count__27357_28041 = G__28070;
i__27358_28042 = G__28071;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_28038);
}


var G__28072 = cljs.core.next(seq__27319_28031__$1);
var G__28073 = null;
var G__28074 = (0);
var G__28075 = (0);
seq__27319_27979 = G__28072;
chunk__27320_27980 = G__28073;
count__27321_27981 = G__28074;
i__27322_27982 = G__28075;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__27382 = cljs.core.seq(node);
var chunk__27383 = null;
var count__27384 = (0);
var i__27385 = (0);
while(true){
if((i__27385 < count__27384)){
var n = chunk__27383.cljs$core$IIndexed$_nth$arity$2(null, i__27385);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null, n));


var G__28084 = seq__27382;
var G__28085 = chunk__27383;
var G__28086 = count__27384;
var G__28087 = (i__27385 + (1));
seq__27382 = G__28084;
chunk__27383 = G__28085;
count__27384 = G__28086;
i__27385 = G__28087;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__27382);
if(temp__5823__auto__){
var seq__27382__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__27382__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__27382__$1);
var G__28091 = cljs.core.chunk_rest(seq__27382__$1);
var G__28092 = c__5525__auto__;
var G__28093 = cljs.core.count(c__5525__auto__);
var G__28094 = (0);
seq__27382 = G__28091;
chunk__27383 = G__28092;
count__27384 = G__28093;
i__27385 = G__28094;
continue;
} else {
var n = cljs.core.first(seq__27382__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null, n));


var G__28100 = cljs.core.next(seq__27382__$1);
var G__28101 = null;
var G__28102 = (0);
var G__28103 = (0);
seq__27382 = G__28100;
chunk__27383 = G__28101;
count__27384 = G__28102;
i__27385 = G__28103;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__27399 = arguments.length;
switch (G__27399) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__27401 = arguments.length;
switch (G__27401) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__27412 = arguments.length;
switch (G__27412) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__5002__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__5732__auto__ = [];
var len__5726__auto___28120 = arguments.length;
var i__5727__auto___28122 = (0);
while(true){
if((i__5727__auto___28122 < len__5726__auto___28120)){
args__5732__auto__.push((arguments[i__5727__auto___28122]));

var G__28123 = (i__5727__auto___28122 + (1));
i__5727__auto___28122 = G__28123;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((0) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__5733__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__27424_28126 = cljs.core.seq(nodes);
var chunk__27425_28127 = null;
var count__27426_28128 = (0);
var i__27427_28129 = (0);
while(true){
if((i__27427_28129 < count__27426_28128)){
var node_28132 = chunk__27425_28127.cljs$core$IIndexed$_nth$arity$2(null, i__27427_28129);
fragment.appendChild(shadow.dom._to_dom(node_28132));


var G__28133 = seq__27424_28126;
var G__28134 = chunk__27425_28127;
var G__28135 = count__27426_28128;
var G__28136 = (i__27427_28129 + (1));
seq__27424_28126 = G__28133;
chunk__27425_28127 = G__28134;
count__27426_28128 = G__28135;
i__27427_28129 = G__28136;
continue;
} else {
var temp__5823__auto___28137 = cljs.core.seq(seq__27424_28126);
if(temp__5823__auto___28137){
var seq__27424_28138__$1 = temp__5823__auto___28137;
if(cljs.core.chunked_seq_QMARK_(seq__27424_28138__$1)){
var c__5525__auto___28139 = cljs.core.chunk_first(seq__27424_28138__$1);
var G__28140 = cljs.core.chunk_rest(seq__27424_28138__$1);
var G__28141 = c__5525__auto___28139;
var G__28142 = cljs.core.count(c__5525__auto___28139);
var G__28143 = (0);
seq__27424_28126 = G__28140;
chunk__27425_28127 = G__28141;
count__27426_28128 = G__28142;
i__27427_28129 = G__28143;
continue;
} else {
var node_28145 = cljs.core.first(seq__27424_28138__$1);
fragment.appendChild(shadow.dom._to_dom(node_28145));


var G__28146 = cljs.core.next(seq__27424_28138__$1);
var G__28147 = null;
var G__28148 = (0);
var G__28149 = (0);
seq__27424_28126 = G__28146;
chunk__27425_28127 = G__28147;
count__27426_28128 = G__28148;
i__27427_28129 = G__28149;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq27421){
var self__5712__auto__ = this;
return self__5712__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq27421));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__27440_28165 = cljs.core.seq(scripts);
var chunk__27441_28166 = null;
var count__27442_28167 = (0);
var i__27443_28168 = (0);
while(true){
if((i__27443_28168 < count__27442_28167)){
var vec__27456_28169 = chunk__27441_28166.cljs$core$IIndexed$_nth$arity$2(null, i__27443_28168);
var script_tag_28170 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27456_28169,(0),null);
var script_body_28171 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27456_28169,(1),null);
eval(script_body_28171);


var G__28173 = seq__27440_28165;
var G__28174 = chunk__27441_28166;
var G__28175 = count__27442_28167;
var G__28176 = (i__27443_28168 + (1));
seq__27440_28165 = G__28173;
chunk__27441_28166 = G__28174;
count__27442_28167 = G__28175;
i__27443_28168 = G__28176;
continue;
} else {
var temp__5823__auto___28177 = cljs.core.seq(seq__27440_28165);
if(temp__5823__auto___28177){
var seq__27440_28178__$1 = temp__5823__auto___28177;
if(cljs.core.chunked_seq_QMARK_(seq__27440_28178__$1)){
var c__5525__auto___28181 = cljs.core.chunk_first(seq__27440_28178__$1);
var G__28182 = cljs.core.chunk_rest(seq__27440_28178__$1);
var G__28183 = c__5525__auto___28181;
var G__28184 = cljs.core.count(c__5525__auto___28181);
var G__28185 = (0);
seq__27440_28165 = G__28182;
chunk__27441_28166 = G__28183;
count__27442_28167 = G__28184;
i__27443_28168 = G__28185;
continue;
} else {
var vec__27459_28186 = cljs.core.first(seq__27440_28178__$1);
var script_tag_28187 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27459_28186,(0),null);
var script_body_28188 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27459_28186,(1),null);
eval(script_body_28188);


var G__28191 = cljs.core.next(seq__27440_28178__$1);
var G__28192 = null;
var G__28193 = (0);
var G__28194 = (0);
seq__27440_28165 = G__28191;
chunk__27441_28166 = G__28192;
count__27442_28167 = G__28193;
i__27443_28168 = G__28194;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__27462){
var vec__27463 = p__27462;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27463,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27463,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__27472 = arguments.length;
switch (G__27472) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__27483 = cljs.core.seq(style_keys);
var chunk__27484 = null;
var count__27485 = (0);
var i__27486 = (0);
while(true){
if((i__27486 < count__27485)){
var it = chunk__27484.cljs$core$IIndexed$_nth$arity$2(null, i__27486);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__28199 = seq__27483;
var G__28200 = chunk__27484;
var G__28201 = count__27485;
var G__28202 = (i__27486 + (1));
seq__27483 = G__28199;
chunk__27484 = G__28200;
count__27485 = G__28201;
i__27486 = G__28202;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__27483);
if(temp__5823__auto__){
var seq__27483__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__27483__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__27483__$1);
var G__28206 = cljs.core.chunk_rest(seq__27483__$1);
var G__28207 = c__5525__auto__;
var G__28208 = cljs.core.count(c__5525__auto__);
var G__28209 = (0);
seq__27483 = G__28206;
chunk__27484 = G__28207;
count__27485 = G__28208;
i__27486 = G__28209;
continue;
} else {
var it = cljs.core.first(seq__27483__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__28210 = cljs.core.next(seq__27483__$1);
var G__28211 = null;
var G__28212 = (0);
var G__28213 = (0);
seq__27483 = G__28210;
chunk__27484 = G__28211;
count__27485 = G__28212;
i__27486 = G__28213;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5300__auto__,k__5301__auto__){
var self__ = this;
var this__5300__auto____$1 = this;
return this__5300__auto____$1.cljs$core$ILookup$_lookup$arity$3(null, k__5301__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5302__auto__,k27492,else__5303__auto__){
var self__ = this;
var this__5302__auto____$1 = this;
var G__27497 = k27492;
var G__27497__$1 = (((G__27497 instanceof cljs.core.Keyword))?G__27497.fqn:null);
switch (G__27497__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k27492,else__5303__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5320__auto__,f__5321__auto__,init__5322__auto__){
var self__ = this;
var this__5320__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5323__auto__,p__27498){
var vec__27499 = p__27498;
var k__5324__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27499,(0),null);
var v__5325__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27499,(1),null);
return (f__5321__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5321__auto__.cljs$core$IFn$_invoke$arity$3(ret__5323__auto__,k__5324__auto__,v__5325__auto__) : f__5321__auto__.call(null, ret__5323__auto__,k__5324__auto__,v__5325__auto__));
}),init__5322__auto__,this__5320__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5315__auto__,writer__5316__auto__,opts__5317__auto__){
var self__ = this;
var this__5315__auto____$1 = this;
var pr_pair__5318__auto__ = (function (keyval__5319__auto__){
return cljs.core.pr_sequential_writer(writer__5316__auto__,cljs.core.pr_writer,""," ","",opts__5317__auto__,keyval__5319__auto__);
});
return cljs.core.pr_sequential_writer(writer__5316__auto__,pr_pair__5318__auto__,"#shadow.dom.Coordinate{",", ","}",opts__5317__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27491){
var self__ = this;
var G__27491__$1 = this;
return (new cljs.core.RecordIter((0),G__27491__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5298__auto__){
var self__ = this;
var this__5298__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5295__auto__){
var self__ = this;
var this__5295__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5304__auto__){
var self__ = this;
var this__5304__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5296__auto__){
var self__ = this;
var this__5296__auto____$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = (function (coll__5297__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__5297__auto__));
})(this__5296__auto____$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27493,other27494){
var self__ = this;
var this27493__$1 = this;
return (((!((other27494 == null)))) && ((((this27493__$1.constructor === other27494.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27493__$1.x,other27494.x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27493__$1.y,other27494.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27493__$1.__extmap,other27494.__extmap)))))))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5310__auto__,k__5311__auto__){
var self__ = this;
var this__5310__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__5311__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5310__auto____$1),self__.__meta),k__5311__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5311__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5307__auto__,k27492){
var self__ = this;
var this__5307__auto____$1 = this;
var G__27553 = k27492;
var G__27553__$1 = (((G__27553 instanceof cljs.core.Keyword))?G__27553.fqn:null);
switch (G__27553__$1) {
case "x":
case "y":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k27492);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5308__auto__,k__5309__auto__,G__27491){
var self__ = this;
var this__5308__auto____$1 = this;
var pred__27559 = cljs.core.keyword_identical_QMARK_;
var expr__27560 = k__5309__auto__;
if(cljs.core.truth_((pred__27559.cljs$core$IFn$_invoke$arity$2 ? pred__27559.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__27560) : pred__27559.call(null, new cljs.core.Keyword(null,"x","x",2099068185),expr__27560)))){
return (new shadow.dom.Coordinate(G__27491,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__27559.cljs$core$IFn$_invoke$arity$2 ? pred__27559.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__27560) : pred__27559.call(null, new cljs.core.Keyword(null,"y","y",-1757859776),expr__27560)))){
return (new shadow.dom.Coordinate(self__.x,G__27491,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5309__auto__,G__27491),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5313__auto__){
var self__ = this;
var this__5313__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5299__auto__,G__27491){
var self__ = this;
var this__5299__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__27491,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5305__auto__,entry__5306__auto__){
var self__ = this;
var this__5305__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5306__auto__)){
return this__5305__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null, cljs.core._nth(entry__5306__auto__,(0)),cljs.core._nth(entry__5306__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5305__auto____$1,entry__5306__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__5346__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__5346__auto__,writer__5347__auto__){
return cljs.core._write(writer__5347__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__27496){
var extmap__5342__auto__ = (function (){var G__27576 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__27496,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__27496)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__27576);
} else {
return G__27576;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__27496),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__27496),null,cljs.core.not_empty(extmap__5342__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5300__auto__,k__5301__auto__){
var self__ = this;
var this__5300__auto____$1 = this;
return this__5300__auto____$1.cljs$core$ILookup$_lookup$arity$3(null, k__5301__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5302__auto__,k27584,else__5303__auto__){
var self__ = this;
var this__5302__auto____$1 = this;
var G__27592 = k27584;
var G__27592__$1 = (((G__27592 instanceof cljs.core.Keyword))?G__27592.fqn:null);
switch (G__27592__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k27584,else__5303__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5320__auto__,f__5321__auto__,init__5322__auto__){
var self__ = this;
var this__5320__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5323__auto__,p__27595){
var vec__27596 = p__27595;
var k__5324__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27596,(0),null);
var v__5325__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27596,(1),null);
return (f__5321__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5321__auto__.cljs$core$IFn$_invoke$arity$3(ret__5323__auto__,k__5324__auto__,v__5325__auto__) : f__5321__auto__.call(null, ret__5323__auto__,k__5324__auto__,v__5325__auto__));
}),init__5322__auto__,this__5320__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5315__auto__,writer__5316__auto__,opts__5317__auto__){
var self__ = this;
var this__5315__auto____$1 = this;
var pr_pair__5318__auto__ = (function (keyval__5319__auto__){
return cljs.core.pr_sequential_writer(writer__5316__auto__,cljs.core.pr_writer,""," ","",opts__5317__auto__,keyval__5319__auto__);
});
return cljs.core.pr_sequential_writer(writer__5316__auto__,pr_pair__5318__auto__,"#shadow.dom.Size{",", ","}",opts__5317__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27583){
var self__ = this;
var G__27583__$1 = this;
return (new cljs.core.RecordIter((0),G__27583__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5298__auto__){
var self__ = this;
var this__5298__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5295__auto__){
var self__ = this;
var this__5295__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5304__auto__){
var self__ = this;
var this__5304__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5296__auto__){
var self__ = this;
var this__5296__auto____$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = (function (coll__5297__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__5297__auto__));
})(this__5296__auto____$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27586,other27587){
var self__ = this;
var this27586__$1 = this;
return (((!((other27587 == null)))) && ((((this27586__$1.constructor === other27587.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27586__$1.w,other27587.w)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27586__$1.h,other27587.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27586__$1.__extmap,other27587.__extmap)))))))));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5310__auto__,k__5311__auto__){
var self__ = this;
var this__5310__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__5311__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5310__auto____$1),self__.__meta),k__5311__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5311__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5307__auto__,k27584){
var self__ = this;
var this__5307__auto____$1 = this;
var G__27629 = k27584;
var G__27629__$1 = (((G__27629 instanceof cljs.core.Keyword))?G__27629.fqn:null);
switch (G__27629__$1) {
case "w":
case "h":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k27584);

}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5308__auto__,k__5309__auto__,G__27583){
var self__ = this;
var this__5308__auto____$1 = this;
var pred__27630 = cljs.core.keyword_identical_QMARK_;
var expr__27631 = k__5309__auto__;
if(cljs.core.truth_((pred__27630.cljs$core$IFn$_invoke$arity$2 ? pred__27630.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__27631) : pred__27630.call(null, new cljs.core.Keyword(null,"w","w",354169001),expr__27631)))){
return (new shadow.dom.Size(G__27583,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__27630.cljs$core$IFn$_invoke$arity$2 ? pred__27630.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__27631) : pred__27630.call(null, new cljs.core.Keyword(null,"h","h",1109658740),expr__27631)))){
return (new shadow.dom.Size(self__.w,G__27583,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5309__auto__,G__27583),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5313__auto__){
var self__ = this;
var this__5313__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5299__auto__,G__27583){
var self__ = this;
var this__5299__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__27583,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5305__auto__,entry__5306__auto__){
var self__ = this;
var this__5305__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5306__auto__)){
return this__5305__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null, cljs.core._nth(entry__5306__auto__,(0)),cljs.core._nth(entry__5306__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5305__auto____$1,entry__5306__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__5346__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__5346__auto__,writer__5347__auto__){
return cljs.core._write(writer__5347__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__27590){
var extmap__5342__auto__ = (function (){var G__27650 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__27590,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__27590)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__27650);
} else {
return G__27650;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__27590),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__27590),null,cljs.core.not_empty(extmap__5342__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__5590__auto__ = opts;
var l__5591__auto__ = a__5590__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__5591__auto__)){
var G__28231 = (i + (1));
var G__28232 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__28231;
ret = G__28232;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__27679){
var vec__27680 = p__27679;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27680,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27680,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__27686 = arguments.length;
switch (G__27686) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5821__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5821__auto__)){
var child = temp__5821__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__28234 = ps;
var G__28235 = (i + (1));
el__$1 = G__28234;
i = G__28235;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null, parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__27709 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27709,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27709,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27709,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__27712_28237 = cljs.core.seq(props);
var chunk__27713_28238 = null;
var count__27714_28239 = (0);
var i__27715_28240 = (0);
while(true){
if((i__27715_28240 < count__27714_28239)){
var vec__27730_28245 = chunk__27713_28238.cljs$core$IIndexed$_nth$arity$2(null, i__27715_28240);
var k_28246 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27730_28245,(0),null);
var v_28247 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27730_28245,(1),null);
el.setAttributeNS((function (){var temp__5823__auto__ = cljs.core.namespace(k_28246);
if(cljs.core.truth_(temp__5823__auto__)){
var ns = temp__5823__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_28246),v_28247);


var G__28259 = seq__27712_28237;
var G__28260 = chunk__27713_28238;
var G__28261 = count__27714_28239;
var G__28262 = (i__27715_28240 + (1));
seq__27712_28237 = G__28259;
chunk__27713_28238 = G__28260;
count__27714_28239 = G__28261;
i__27715_28240 = G__28262;
continue;
} else {
var temp__5823__auto___28263 = cljs.core.seq(seq__27712_28237);
if(temp__5823__auto___28263){
var seq__27712_28264__$1 = temp__5823__auto___28263;
if(cljs.core.chunked_seq_QMARK_(seq__27712_28264__$1)){
var c__5525__auto___28265 = cljs.core.chunk_first(seq__27712_28264__$1);
var G__28266 = cljs.core.chunk_rest(seq__27712_28264__$1);
var G__28267 = c__5525__auto___28265;
var G__28268 = cljs.core.count(c__5525__auto___28265);
var G__28269 = (0);
seq__27712_28237 = G__28266;
chunk__27713_28238 = G__28267;
count__27714_28239 = G__28268;
i__27715_28240 = G__28269;
continue;
} else {
var vec__27739_28270 = cljs.core.first(seq__27712_28264__$1);
var k_28271 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27739_28270,(0),null);
var v_28272 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27739_28270,(1),null);
el.setAttributeNS((function (){var temp__5823__auto____$1 = cljs.core.namespace(k_28271);
if(cljs.core.truth_(temp__5823__auto____$1)){
var ns = temp__5823__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_28271),v_28272);


var G__28273 = cljs.core.next(seq__27712_28264__$1);
var G__28274 = null;
var G__28275 = (0);
var G__28276 = (0);
seq__27712_28237 = G__28273;
chunk__27713_28238 = G__28274;
count__27714_28239 = G__28275;
i__27715_28240 = G__28276;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null, );
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__27757 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27757,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27757,(1),null);
var seq__27760_28277 = cljs.core.seq(node_children);
var chunk__27762_28278 = null;
var count__27763_28279 = (0);
var i__27764_28280 = (0);
while(true){
if((i__27764_28280 < count__27763_28279)){
var child_struct_28281 = chunk__27762_28278.cljs$core$IIndexed$_nth$arity$2(null, i__27764_28280);
if((!((child_struct_28281 == null)))){
if(typeof child_struct_28281 === 'string'){
var text_28282 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_28282),child_struct_28281].join(''));
} else {
var children_28283 = shadow.dom.svg_node(child_struct_28281);
if(cljs.core.seq_QMARK_(children_28283)){
var seq__27807_28284 = cljs.core.seq(children_28283);
var chunk__27809_28285 = null;
var count__27810_28286 = (0);
var i__27811_28287 = (0);
while(true){
if((i__27811_28287 < count__27810_28286)){
var child_28288 = chunk__27809_28285.cljs$core$IIndexed$_nth$arity$2(null, i__27811_28287);
if(cljs.core.truth_(child_28288)){
node.appendChild(child_28288);


var G__28289 = seq__27807_28284;
var G__28290 = chunk__27809_28285;
var G__28291 = count__27810_28286;
var G__28292 = (i__27811_28287 + (1));
seq__27807_28284 = G__28289;
chunk__27809_28285 = G__28290;
count__27810_28286 = G__28291;
i__27811_28287 = G__28292;
continue;
} else {
var G__28293 = seq__27807_28284;
var G__28294 = chunk__27809_28285;
var G__28295 = count__27810_28286;
var G__28296 = (i__27811_28287 + (1));
seq__27807_28284 = G__28293;
chunk__27809_28285 = G__28294;
count__27810_28286 = G__28295;
i__27811_28287 = G__28296;
continue;
}
} else {
var temp__5823__auto___28297 = cljs.core.seq(seq__27807_28284);
if(temp__5823__auto___28297){
var seq__27807_28298__$1 = temp__5823__auto___28297;
if(cljs.core.chunked_seq_QMARK_(seq__27807_28298__$1)){
var c__5525__auto___28299 = cljs.core.chunk_first(seq__27807_28298__$1);
var G__28300 = cljs.core.chunk_rest(seq__27807_28298__$1);
var G__28301 = c__5525__auto___28299;
var G__28302 = cljs.core.count(c__5525__auto___28299);
var G__28303 = (0);
seq__27807_28284 = G__28300;
chunk__27809_28285 = G__28301;
count__27810_28286 = G__28302;
i__27811_28287 = G__28303;
continue;
} else {
var child_28304 = cljs.core.first(seq__27807_28298__$1);
if(cljs.core.truth_(child_28304)){
node.appendChild(child_28304);


var G__28305 = cljs.core.next(seq__27807_28298__$1);
var G__28306 = null;
var G__28307 = (0);
var G__28308 = (0);
seq__27807_28284 = G__28305;
chunk__27809_28285 = G__28306;
count__27810_28286 = G__28307;
i__27811_28287 = G__28308;
continue;
} else {
var G__28309 = cljs.core.next(seq__27807_28298__$1);
var G__28310 = null;
var G__28311 = (0);
var G__28312 = (0);
seq__27807_28284 = G__28309;
chunk__27809_28285 = G__28310;
count__27810_28286 = G__28311;
i__27811_28287 = G__28312;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_28283);
}
}


var G__28313 = seq__27760_28277;
var G__28314 = chunk__27762_28278;
var G__28315 = count__27763_28279;
var G__28316 = (i__27764_28280 + (1));
seq__27760_28277 = G__28313;
chunk__27762_28278 = G__28314;
count__27763_28279 = G__28315;
i__27764_28280 = G__28316;
continue;
} else {
var G__28317 = seq__27760_28277;
var G__28318 = chunk__27762_28278;
var G__28319 = count__27763_28279;
var G__28320 = (i__27764_28280 + (1));
seq__27760_28277 = G__28317;
chunk__27762_28278 = G__28318;
count__27763_28279 = G__28319;
i__27764_28280 = G__28320;
continue;
}
} else {
var temp__5823__auto___28321 = cljs.core.seq(seq__27760_28277);
if(temp__5823__auto___28321){
var seq__27760_28322__$1 = temp__5823__auto___28321;
if(cljs.core.chunked_seq_QMARK_(seq__27760_28322__$1)){
var c__5525__auto___28323 = cljs.core.chunk_first(seq__27760_28322__$1);
var G__28324 = cljs.core.chunk_rest(seq__27760_28322__$1);
var G__28325 = c__5525__auto___28323;
var G__28326 = cljs.core.count(c__5525__auto___28323);
var G__28327 = (0);
seq__27760_28277 = G__28324;
chunk__27762_28278 = G__28325;
count__27763_28279 = G__28326;
i__27764_28280 = G__28327;
continue;
} else {
var child_struct_28328 = cljs.core.first(seq__27760_28322__$1);
if((!((child_struct_28328 == null)))){
if(typeof child_struct_28328 === 'string'){
var text_28329 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_28329),child_struct_28328].join(''));
} else {
var children_28330 = shadow.dom.svg_node(child_struct_28328);
if(cljs.core.seq_QMARK_(children_28330)){
var seq__27829_28331 = cljs.core.seq(children_28330);
var chunk__27831_28332 = null;
var count__27832_28333 = (0);
var i__27833_28334 = (0);
while(true){
if((i__27833_28334 < count__27832_28333)){
var child_28335 = chunk__27831_28332.cljs$core$IIndexed$_nth$arity$2(null, i__27833_28334);
if(cljs.core.truth_(child_28335)){
node.appendChild(child_28335);


var G__28336 = seq__27829_28331;
var G__28337 = chunk__27831_28332;
var G__28338 = count__27832_28333;
var G__28339 = (i__27833_28334 + (1));
seq__27829_28331 = G__28336;
chunk__27831_28332 = G__28337;
count__27832_28333 = G__28338;
i__27833_28334 = G__28339;
continue;
} else {
var G__28340 = seq__27829_28331;
var G__28341 = chunk__27831_28332;
var G__28342 = count__27832_28333;
var G__28343 = (i__27833_28334 + (1));
seq__27829_28331 = G__28340;
chunk__27831_28332 = G__28341;
count__27832_28333 = G__28342;
i__27833_28334 = G__28343;
continue;
}
} else {
var temp__5823__auto___28344__$1 = cljs.core.seq(seq__27829_28331);
if(temp__5823__auto___28344__$1){
var seq__27829_28345__$1 = temp__5823__auto___28344__$1;
if(cljs.core.chunked_seq_QMARK_(seq__27829_28345__$1)){
var c__5525__auto___28346 = cljs.core.chunk_first(seq__27829_28345__$1);
var G__28347 = cljs.core.chunk_rest(seq__27829_28345__$1);
var G__28348 = c__5525__auto___28346;
var G__28349 = cljs.core.count(c__5525__auto___28346);
var G__28350 = (0);
seq__27829_28331 = G__28347;
chunk__27831_28332 = G__28348;
count__27832_28333 = G__28349;
i__27833_28334 = G__28350;
continue;
} else {
var child_28351 = cljs.core.first(seq__27829_28345__$1);
if(cljs.core.truth_(child_28351)){
node.appendChild(child_28351);


var G__28352 = cljs.core.next(seq__27829_28345__$1);
var G__28353 = null;
var G__28354 = (0);
var G__28355 = (0);
seq__27829_28331 = G__28352;
chunk__27831_28332 = G__28353;
count__27832_28333 = G__28354;
i__27833_28334 = G__28355;
continue;
} else {
var G__28356 = cljs.core.next(seq__27829_28345__$1);
var G__28357 = null;
var G__28358 = (0);
var G__28359 = (0);
seq__27829_28331 = G__28356;
chunk__27831_28332 = G__28357;
count__27832_28333 = G__28358;
i__27833_28334 = G__28359;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_28330);
}
}


var G__28360 = cljs.core.next(seq__27760_28322__$1);
var G__28361 = null;
var G__28362 = (0);
var G__28363 = (0);
seq__27760_28277 = G__28360;
chunk__27762_28278 = G__28361;
count__27763_28279 = G__28362;
i__27764_28280 = G__28363;
continue;
} else {
var G__28364 = cljs.core.next(seq__27760_28322__$1);
var G__28365 = null;
var G__28366 = (0);
var G__28367 = (0);
seq__27760_28277 = G__28364;
chunk__27762_28278 = G__28365;
count__27763_28279 = G__28366;
i__27764_28280 = G__28367;
continue;
}
}
} else {
}
}
break;
}

return node;
});
(shadow.dom.SVGElement["string"] = true);

(shadow.dom._to_svg["string"] = (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

(shadow.dom.SVGElement["null"] = true);

(shadow.dom._to_svg["null"] = (function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__5732__auto__ = [];
var len__5726__auto___28368 = arguments.length;
var i__5727__auto___28369 = (0);
while(true){
if((i__5727__auto___28369 < len__5726__auto___28368)){
args__5732__auto__.push((arguments[i__5727__auto___28369]));

var G__28370 = (i__5727__auto___28369 + (1));
i__5727__auto___28369 = G__28370;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq27848){
var G__27849 = cljs.core.first(seq27848);
var seq27848__$1 = cljs.core.next(seq27848);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__27849,seq27848__$1);
}));


//# sourceMappingURL=shadow.dom.js.map
