goog.provide('kabel.middleware.fressian');
/**
 * Merges custom and incognito read handlers following Konserve's strategy.
 * On JVM: applies associative-lookup for efficient handler dispatch.
 * On JS: simple merge is sufficient.
 */
kabel.middleware.fressian.merge_read_handlers = (function kabel$middleware$fressian$merge_read_handlers(custom_handlers,incognito_handlers_atom){
var incognito_h = incognito.fressian.incognito_read_handlers(incognito_handlers_atom);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([custom_handlers,incognito_h], 0));
});
/**
 * Merges custom and incognito write handlers following Konserve's strategy.
 * On JVM: applies associative-lookup and inheritance-lookup.
 * On JS: simple merge is sufficient.
 */
kabel.middleware.fressian.merge_write_handlers = (function kabel$middleware$fressian$merge_write_handlers(custom_handlers,incognito_handlers_atom){
var incognito_h = incognito.fressian.incognito_write_handlers(incognito_handlers_atom);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([custom_handlers,incognito_h], 0));
});
/**
 * Reads a value from Fressian-encoded bytes using the provided handlers.
 */
kabel.middleware.fressian.fressian_read = (function kabel$middleware$fressian$fressian_read(bytes,handlers){
return fress.api.read.cljs$core$IFn$_invoke$arity$variadic(bytes,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"handlers","handlers",79528781),handlers], 0));
});
/**
 * Writes a value to Fressian-encoded bytes using the provided handlers.
 */
kabel.middleware.fressian.fressian_write = (function kabel$middleware$fressian$fressian_write(val,handlers){
return fress.api.write.cljs$core$IFn$_invoke$arity$variadic(val,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"handlers","handlers",79528781),handlers], 0));
});
/**
 * Serializes all incoming and outgoing edn datastructures in Fressian format.
 * 
 * Parameters:
 * - custom-read-handlers: atom containing map of tag-name -> ReadHandler/function
 * - custom-write-handlers: atom containing map of Class/Type -> {tag WriteHandler/function}
 * - incognito-read-handlers-atom: atom for Incognito type handlers (optional, defaults to empty)
 * - incognito-write-handlers-atom: atom for Incognito type handlers (optional, defaults to empty)
 * 
 * Examples:
 * ;; Basic usage with Incognito only
 * (fressian [S peer [in out]])
 * 
 * ;; With custom handlers
 * (fressian (atom custom-read-handlers)
 *           (atom custom-write-handlers)
 *           [S peer [in out]])
 * 
 * ;; With both custom and Incognito handlers
 * (fressian (atom custom-read-handlers)
 *           (atom custom-write-handlers)
 *           incognito-read-atom
 *           incognito-write-atom
 *           [S peer [in out]])
 */
kabel.middleware.fressian.fressian = (function kabel$middleware$fressian$fressian(var_args){
var G__26907 = arguments.length;
switch (G__26907) {
case 1:
return kabel.middleware.fressian.fressian.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return kabel.middleware.fressian.fressian.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return kabel.middleware.fressian.fressian.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(kabel.middleware.fressian.fressian.cljs$core$IFn$_invoke$arity$1 = (function (p__26930){
var vec__26931 = p__26930;
var S = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26931,(0),null);
var peer = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26931,(1),null);
var vec__26935 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26931,(2),null);
var in$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26935,(0),null);
var out = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26935,(1),null);
return kabel.middleware.fressian.fressian.cljs$core$IFn$_invoke$arity$5(cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [S,peer,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [in$,out], null)], null));
}));

(kabel.middleware.fressian.fressian.cljs$core$IFn$_invoke$arity$3 = (function (custom_read_handlers,custom_write_handlers,p__26947){
var vec__26949 = p__26947;
var S = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26949,(0),null);
var peer = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26949,(1),null);
var vec__26952 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26949,(2),null);
var in$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26952,(0),null);
var out = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26952,(1),null);
return kabel.middleware.fressian.fressian.cljs$core$IFn$_invoke$arity$5(custom_read_handlers,custom_write_handlers,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [S,peer,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [in$,out], null)], null));
}));

(kabel.middleware.fressian.fressian.cljs$core$IFn$_invoke$arity$5 = (function (custom_read_handlers,custom_write_handlers,incognito_read_handlers_atom,incognito_write_handlers_atom,p__26963){
var vec__26965 = p__26963;
var S = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26965,(0),null);
var peer = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26965,(1),null);
var vec__26968 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26965,(2),null);
var in$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26968,(0),null);
var out = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26968,(1),null);
return kabel.middleware.handler.handler((function (p1__26895_SHARP_){
var c__22366__auto__ = superv.async.check_supervisor(superv.async.S);
var id__22367__auto__ = superv.async._register_go(S,cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("kabel","serialization","kabel/serialization",2078051952,null),new cljs.core.Symbol("kabel","payload","kabel/payload",1891791416,null)], null)], null),new cljs.core.Symbol(null,"p1__26895#","p1__26895#",562741244,null)], null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"serialization","serialization",1169102467,null),new cljs.core.Keyword(null,"fressian","fressian",1554168117)),cljs.core.list(new cljs.core.Symbol(null,"let","let",358118826,null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"handlers","handlers",1720060308,null),cljs.core.list(new cljs.core.Symbol(null,"merge-read-handlers","merge-read-handlers",-1432991443,null),cljs.core.list(new cljs.core.Symbol("clojure.core","deref","clojure.core/deref",188719157,null),new cljs.core.Symbol(null,"custom-read-handlers","custom-read-handlers",437860503,null)),new cljs.core.Symbol(null,"incognito-read-handlers-atom","incognito-read-handlers-atom",-151688926,null)),new cljs.core.Symbol(null,"v","v",1661996586,null),cljs.core.list(new cljs.core.Symbol(null,"fressian-read","fressian-read",272167878,null),new cljs.core.Symbol(null,"payload","payload",1257495435,null),new cljs.core.Symbol(null,"handlers","handlers",1720060308,null)),new cljs.core.Symbol(null,"merged","merged",-1005723126,null),cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Symbol(null,"map?","map?",-1780568534,null),new cljs.core.Symbol(null,"v","v",1661996586,null)),cljs.core.list(new cljs.core.Symbol(null,"merge","merge",-163787882,null),new cljs.core.Symbol(null,"v","v",1661996586,null),cljs.core.list(new cljs.core.Symbol(null,"dissoc","dissoc",1039760994,null),new cljs.core.Symbol(null,"p1__26895#","p1__26895#",562741244,null),new cljs.core.Keyword("kabel","serialization","kabel/serialization",437520425),new cljs.core.Keyword("kabel","payload","kabel/payload",251259889))),new cljs.core.Symbol(null,"v","v",1661996586,null))], null),new cljs.core.Symbol(null,"merged","merged",-1005723126,null)),new cljs.core.Symbol(null,"p1__26895#","p1__26895#",562741244,null)))));
var c__22111__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__22112__auto__ = (function (){var switch__22063__auto__ = (function (state_27055){
var state_val_27057 = (state_27055[(1)]);
if((state_val_27057 === (7))){
var inst_26998 = (state_27055[(7)]);
var inst_27006 = superv.async._track_exception(S,inst_26998);
var state_27055__$1 = state_27055;
var statearr_27076_27378 = state_27055__$1;
(statearr_27076_27378[(2)] = inst_27006);

(statearr_27076_27378[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27057 === (1))){
var state_27055__$1 = state_27055;
var statearr_27083_27379 = state_27055__$1;
(statearr_27083_27379[(2)] = null);

(statearr_27083_27379[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27057 === (4))){
var _ = (function (){var statearr_27084 = state_27055;
(statearr_27084[(4)] = cljs.core.rest((state_27055[(4)])));

return statearr_27084;
})();
var inst_26990 = (state_27055[(2)]);
var inst_26992 = superv.async._unregister_go(S,id__22367__auto__);
var ___$1 = (function (){var temp__5823__auto__ = (state_27055[(5)]);
if(cljs.core.truth_(temp__5823__auto__)){
var e__21296__auto__ = temp__5823__auto__;
throw e__21296__auto__;
} else {
return null;
}
})();
var state_27055__$1 = (function (){var statearr_27091 = state_27055;
(statearr_27091[(8)] = inst_26992);

return statearr_27091;
})();
var statearr_27094_27381 = state_27055__$1;
(statearr_27094_27381[(2)] = inst_26990);

(statearr_27094_27381[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27057 === (15))){
var inst_27043 = (state_27055[(2)]);
var state_27055__$1 = state_27055;
var statearr_27098_27383 = state_27055__$1;
(statearr_27098_27383[(2)] = inst_27043);

(statearr_27098_27383[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27057 === (13))){
var inst_27035 = (state_27055[(9)]);
var inst_27039 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(p1__26895_SHARP_,new cljs.core.Keyword("kabel","serialization","kabel/serialization",437520425),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("kabel","payload","kabel/payload",251259889)], 0));
var inst_27040 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_27035,inst_27039], 0));
var state_27055__$1 = state_27055;
var statearr_27107_27390 = state_27055__$1;
(statearr_27107_27390[(2)] = inst_27040);

(statearr_27107_27390[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27057 === (6))){
var state_27055__$1 = state_27055;
var statearr_27109_27391 = state_27055__$1;
(statearr_27109_27391[(2)] = null);

(statearr_27109_27391[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27057 === (3))){
var inst_27049 = (state_27055[(2)]);
var state_27055__$1 = state_27055;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27055__$1,inst_27049);
} else {
if((state_val_27057 === (12))){
var inst_27046 = (state_27055[(2)]);
var _ = (function (){var statearr_27132 = state_27055;
(statearr_27132[(4)] = cljs.core.rest((state_27055[(4)])));

return statearr_27132;
})();
var state_27055__$1 = state_27055;
var statearr_27133_27394 = state_27055__$1;
(statearr_27133_27394[(2)] = inst_27046);

(statearr_27133_27394[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27057 === (2))){
var _ = (function (){var statearr_27151 = state_27055;
(statearr_27151[(4)] = cljs.core.cons((4),(state_27055[(4)])));

return statearr_27151;
})();
var ___$1 = (function (){var statearr_27152 = state_27055;
(statearr_27152[(4)] = cljs.core.cons((9),(state_27055[(4)])));

return statearr_27152;
})();
var inst_27026 = p1__26895_SHARP_;
var inst_27028 = cljs.core.__destructure_map(inst_27026);
var inst_27029 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27028,new cljs.core.Keyword("kabel","serialization","kabel/serialization",437520425));
var inst_27030 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27028,new cljs.core.Keyword("kabel","payload","kabel/payload",251259889));
var inst_27031 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_27029,new cljs.core.Keyword(null,"fressian","fressian",1554168117));
var state_27055__$1 = (function (){var statearr_27154 = state_27055;
(statearr_27154[(10)] = inst_27030);

return statearr_27154;
})();
if(inst_27031){
var statearr_27155_27398 = state_27055__$1;
(statearr_27155_27398[(1)] = (10));

} else {
var statearr_27156_27399 = state_27055__$1;
(statearr_27156_27399[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27057 === (11))){
var state_27055__$1 = state_27055;
var statearr_27157_27402 = state_27055__$1;
(statearr_27157_27402[(2)] = p1__26895_SHARP_);

(statearr_27157_27402[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27057 === (9))){
var _ = (function (){var statearr_27173 = state_27055;
(statearr_27173[(4)] = cljs.core.rest((state_27055[(4)])));

return statearr_27173;
})();
var state_27055__$1 = state_27055;
var ex27135 = (state_27055__$1[(2)]);
var statearr_27174_27403 = state_27055__$1;
(statearr_27174_27403[(5)] = ex27135);


if((ex27135 instanceof Error)){
var statearr_27175_27404 = state_27055__$1;
(statearr_27175_27404[(1)] = (5));

(statearr_27175_27404[(5)] = null);

} else {
throw ex27135;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27057 === (5))){
var inst_26998 = (state_27055[(7)]);
var inst_26998__$1 = (state_27055[(2)]);
var inst_27001 = cljs.core.ex_data(inst_26998__$1);
var inst_27002 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_27001);
var inst_27003 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_27002,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_27055__$1 = (function (){var statearr_27177 = state_27055;
(statearr_27177[(7)] = inst_26998__$1);

return statearr_27177;
})();
if(inst_27003){
var statearr_27178_27417 = state_27055__$1;
(statearr_27178_27417[(1)] = (6));

} else {
var statearr_27179_27421 = state_27055__$1;
(statearr_27179_27421[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27057 === (14))){
var inst_27035 = (state_27055[(9)]);
var state_27055__$1 = state_27055;
var statearr_27188_27425 = state_27055__$1;
(statearr_27188_27425[(2)] = inst_27035);

(statearr_27188_27425[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27057 === (10))){
var inst_27030 = (state_27055[(10)]);
var inst_27035 = (state_27055[(9)]);
var inst_27033 = cljs.core.deref(custom_read_handlers);
var inst_27034 = kabel.middleware.fressian.merge_read_handlers(inst_27033,incognito_read_handlers_atom);
var inst_27035__$1 = kabel.middleware.fressian.fressian_read(inst_27030,inst_27034);
var inst_27036 = cljs.core.map_QMARK_(inst_27035__$1);
var state_27055__$1 = (function (){var statearr_27190 = state_27055;
(statearr_27190[(9)] = inst_27035__$1);

return statearr_27190;
})();
if(inst_27036){
var statearr_27197_27434 = state_27055__$1;
(statearr_27197_27434[(1)] = (13));

} else {
var statearr_27198_27436 = state_27055__$1;
(statearr_27198_27436[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27057 === (8))){
var inst_26998 = (state_27055[(7)]);
var inst_27008 = (state_27055[(2)]);
var state_27055__$1 = (function (){var statearr_27199 = state_27055;
(statearr_27199[(11)] = inst_27008);

return statearr_27199;
})();
var statearr_27204_27439 = state_27055__$1;
(statearr_27204_27439[(2)] = inst_26998);

(statearr_27204_27439[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var kabel$middleware$fressian$state_machine__22064__auto__ = null;
var kabel$middleware$fressian$state_machine__22064__auto____0 = (function (){
var statearr_27213 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27213[(0)] = kabel$middleware$fressian$state_machine__22064__auto__);

(statearr_27213[(1)] = (1));

return statearr_27213;
});
var kabel$middleware$fressian$state_machine__22064__auto____1 = (function (state_27055){
while(true){
var ret_value__22065__auto__ = (function (){try{while(true){
var result__22066__auto__ = switch__22063__auto__(state_27055);
if(cljs.core.keyword_identical_QMARK_(result__22066__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22066__auto__;
}
break;
}
}catch (e27214){var ex__22067__auto__ = e27214;
var statearr_27215_27446 = state_27055;
(statearr_27215_27446[(2)] = ex__22067__auto__);


if(cljs.core.seq((state_27055[(4)]))){
var statearr_27216_27447 = state_27055;
(statearr_27216_27447[(1)] = cljs.core.first((state_27055[(4)])));

} else {
throw ex__22067__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__22065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27448 = state_27055;
state_27055 = G__27448;
continue;
} else {
return ret_value__22065__auto__;
}
break;
}
});
kabel$middleware$fressian$state_machine__22064__auto__ = function(state_27055){
switch(arguments.length){
case 0:
return kabel$middleware$fressian$state_machine__22064__auto____0.call(this);
case 1:
return kabel$middleware$fressian$state_machine__22064__auto____1.call(this,state_27055);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
kabel$middleware$fressian$state_machine__22064__auto__.cljs$core$IFn$_invoke$arity$0 = kabel$middleware$fressian$state_machine__22064__auto____0;
kabel$middleware$fressian$state_machine__22064__auto__.cljs$core$IFn$_invoke$arity$1 = kabel$middleware$fressian$state_machine__22064__auto____1;
return kabel$middleware$fressian$state_machine__22064__auto__;
})()
})();
var state__22113__auto__ = (function (){var statearr_27219 = f__22112__auto__();
(statearr_27219[(6)] = c__22111__auto__);

return statearr_27219;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__22113__auto__);
}));

return c__22111__auto__;
}),(function (p1__26896_SHARP_){
var c__22366__auto__ = superv.async.check_supervisor(superv.async.S);
var id__22367__auto__ = superv.async._register_go(S,cljs.core.list(cljs.core.list(new cljs.core.Symbol(null,"if","if",1181717262,null),cljs.core.list(new cljs.core.Keyword("kabel","serialization","kabel/serialization",437520425),new cljs.core.Symbol(null,"p1__26896#","p1__26896#",-1530086191,null)),new cljs.core.Symbol(null,"p1__26896#","p1__26896#",-1530086191,null),cljs.core.list(new cljs.core.Symbol(null,"do","do",1686842252,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("kabel","serialization","kabel/serialization",437520425),new cljs.core.Keyword(null,"fressian","fressian",1554168117),new cljs.core.Keyword("kabel","payload","kabel/payload",251259889),cljs.core.list(new cljs.core.Symbol(null,"fressian-write","fressian-write",1488161452,null),new cljs.core.Symbol(null,"p1__26896#","p1__26896#",-1530086191,null),cljs.core.list(new cljs.core.Symbol(null,"merge-write-handlers","merge-write-handlers",759181368,null),cljs.core.list(new cljs.core.Symbol("clojure.core","deref","clojure.core/deref",188719157,null),new cljs.core.Symbol(null,"custom-write-handlers","custom-write-handlers",-2004644013,null)),new cljs.core.Symbol(null,"incognito-write-handlers-atom","incognito-write-handlers-atom",-1209586584,null)))], null)))));
var c__22111__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__22112__auto__ = (function (){var switch__22063__auto__ = (function (state_27258){
var state_val_27259 = (state_27258[(1)]);
if((state_val_27259 === (7))){
var inst_27227 = (state_27258[(7)]);
var inst_27233 = superv.async._track_exception(S,inst_27227);
var state_27258__$1 = state_27258;
var statearr_27262_27455 = state_27258__$1;
(statearr_27262_27455[(2)] = inst_27233);

(statearr_27262_27455[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27259 === (1))){
var state_27258__$1 = state_27258;
var statearr_27263_27458 = state_27258__$1;
(statearr_27263_27458[(2)] = null);

(statearr_27263_27458[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27259 === (4))){
var _ = (function (){var statearr_27266 = state_27258;
(statearr_27266[(4)] = cljs.core.rest((state_27258[(4)])));

return statearr_27266;
})();
var inst_27223 = (state_27258[(2)]);
var inst_27224 = superv.async._unregister_go(S,id__22367__auto__);
var ___$1 = (function (){var temp__5823__auto__ = (state_27258[(5)]);
if(cljs.core.truth_(temp__5823__auto__)){
var e__21296__auto__ = temp__5823__auto__;
throw e__21296__auto__;
} else {
return null;
}
})();
var state_27258__$1 = (function (){var statearr_27268 = state_27258;
(statearr_27268[(8)] = inst_27224);

return statearr_27268;
})();
var statearr_27270_27461 = state_27258__$1;
(statearr_27270_27461[(2)] = inst_27223);

(statearr_27270_27461[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27259 === (6))){
var state_27258__$1 = state_27258;
var statearr_27271_27463 = state_27258__$1;
(statearr_27271_27463[(2)] = null);

(statearr_27271_27463[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27259 === (3))){
var inst_27255 = (state_27258[(2)]);
var state_27258__$1 = state_27258;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27258__$1,inst_27255);
} else {
if((state_val_27259 === (12))){
var inst_27252 = (state_27258[(2)]);
var _ = (function (){var statearr_27276 = state_27258;
(statearr_27276[(4)] = cljs.core.rest((state_27258[(4)])));

return statearr_27276;
})();
var state_27258__$1 = state_27258;
var statearr_27278_27479 = state_27258__$1;
(statearr_27278_27479[(2)] = inst_27252);

(statearr_27278_27479[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27259 === (2))){
var _ = (function (){var statearr_27281 = state_27258;
(statearr_27281[(4)] = cljs.core.cons((4),(state_27258[(4)])));

return statearr_27281;
})();
var ___$1 = (function (){var statearr_27282 = state_27258;
(statearr_27282[(4)] = cljs.core.cons((9),(state_27258[(4)])));

return statearr_27282;
})();
var inst_27242 = new cljs.core.Keyword("kabel","serialization","kabel/serialization",437520425).cljs$core$IFn$_invoke$arity$1(p1__26896_SHARP_);
var state_27258__$1 = state_27258;
if(cljs.core.truth_(inst_27242)){
var statearr_27285_27487 = state_27258__$1;
(statearr_27285_27487[(1)] = (10));

} else {
var statearr_27286_27488 = state_27258__$1;
(statearr_27286_27488[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27259 === (11))){
var inst_27245 = [new cljs.core.Keyword("kabel","serialization","kabel/serialization",437520425),new cljs.core.Keyword("kabel","payload","kabel/payload",251259889)];
var inst_27246 = cljs.core.deref(custom_write_handlers);
var inst_27247 = kabel.middleware.fressian.merge_write_handlers(inst_27246,incognito_write_handlers_atom);
var inst_27248 = kabel.middleware.fressian.fressian_write(p1__26896_SHARP_,inst_27247);
var inst_27249 = [new cljs.core.Keyword(null,"fressian","fressian",1554168117),inst_27248];
var inst_27250 = cljs.core.PersistentHashMap.fromArrays(inst_27245,inst_27249);
var state_27258__$1 = state_27258;
var statearr_27288_27499 = state_27258__$1;
(statearr_27288_27499[(2)] = inst_27250);

(statearr_27288_27499[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27259 === (9))){
var _ = (function (){var statearr_27289 = state_27258;
(statearr_27289[(4)] = cljs.core.rest((state_27258[(4)])));

return statearr_27289;
})();
var state_27258__$1 = state_27258;
var ex27279 = (state_27258__$1[(2)]);
var statearr_27291_27500 = state_27258__$1;
(statearr_27291_27500[(5)] = ex27279);


if((ex27279 instanceof Error)){
var statearr_27292_27501 = state_27258__$1;
(statearr_27292_27501[(1)] = (5));

(statearr_27292_27501[(5)] = null);

} else {
throw ex27279;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27259 === (5))){
var inst_27227 = (state_27258[(7)]);
var inst_27227__$1 = (state_27258[(2)]);
var inst_27228 = cljs.core.ex_data(inst_27227__$1);
var inst_27229 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_27228);
var inst_27230 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_27229,new cljs.core.Keyword(null,"aborted","aborted",1775972619));
var state_27258__$1 = (function (){var statearr_27297 = state_27258;
(statearr_27297[(7)] = inst_27227__$1);

return statearr_27297;
})();
if(inst_27230){
var statearr_27307_27507 = state_27258__$1;
(statearr_27307_27507[(1)] = (6));

} else {
var statearr_27308_27508 = state_27258__$1;
(statearr_27308_27508[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27259 === (10))){
var state_27258__$1 = state_27258;
var statearr_27309_27510 = state_27258__$1;
(statearr_27309_27510[(2)] = p1__26896_SHARP_);

(statearr_27309_27510[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27259 === (8))){
var inst_27227 = (state_27258[(7)]);
var inst_27235 = (state_27258[(2)]);
var state_27258__$1 = (function (){var statearr_27310 = state_27258;
(statearr_27310[(9)] = inst_27235);

return statearr_27310;
})();
var statearr_27312_27515 = state_27258__$1;
(statearr_27312_27515[(2)] = inst_27227);

(statearr_27312_27515[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var kabel$middleware$fressian$state_machine__22064__auto__ = null;
var kabel$middleware$fressian$state_machine__22064__auto____0 = (function (){
var statearr_27315 = [null,null,null,null,null,null,null,null,null,null];
(statearr_27315[(0)] = kabel$middleware$fressian$state_machine__22064__auto__);

(statearr_27315[(1)] = (1));

return statearr_27315;
});
var kabel$middleware$fressian$state_machine__22064__auto____1 = (function (state_27258){
while(true){
var ret_value__22065__auto__ = (function (){try{while(true){
var result__22066__auto__ = switch__22063__auto__(state_27258);
if(cljs.core.keyword_identical_QMARK_(result__22066__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22066__auto__;
}
break;
}
}catch (e27318){var ex__22067__auto__ = e27318;
var statearr_27319_27523 = state_27258;
(statearr_27319_27523[(2)] = ex__22067__auto__);


if(cljs.core.seq((state_27258[(4)]))){
var statearr_27320_27524 = state_27258;
(statearr_27320_27524[(1)] = cljs.core.first((state_27258[(4)])));

} else {
throw ex__22067__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__22065__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27527 = state_27258;
state_27258 = G__27527;
continue;
} else {
return ret_value__22065__auto__;
}
break;
}
});
kabel$middleware$fressian$state_machine__22064__auto__ = function(state_27258){
switch(arguments.length){
case 0:
return kabel$middleware$fressian$state_machine__22064__auto____0.call(this);
case 1:
return kabel$middleware$fressian$state_machine__22064__auto____1.call(this,state_27258);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
kabel$middleware$fressian$state_machine__22064__auto__.cljs$core$IFn$_invoke$arity$0 = kabel$middleware$fressian$state_machine__22064__auto____0;
kabel$middleware$fressian$state_machine__22064__auto__.cljs$core$IFn$_invoke$arity$1 = kabel$middleware$fressian$state_machine__22064__auto____1;
return kabel$middleware$fressian$state_machine__22064__auto__;
})()
})();
var state__22113__auto__ = (function (){var statearr_27326 = f__22112__auto__();
(statearr_27326[(6)] = c__22111__auto__);

return statearr_27326;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__22113__auto__);
}));

return c__22111__auto__;
}),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [S,peer,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [in$,out], null)], null));
}));

(kabel.middleware.fressian.fressian.cljs$lang$maxFixedArity = 5);


//# sourceMappingURL=kabel.middleware.fressian.js.map
