goog.provide('fress.impl.hopmap');

/**
 * @interface
 */
fress.impl.hopmap.IHopMap = function(){};

var fress$impl$hopmap$IHopMap$clear$dyn_27224 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (fress.impl.hopmap.clear[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null, this$));
} else {
var m__5349__auto__ = (fress.impl.hopmap.clear["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null, this$));
} else {
throw cljs.core.missing_protocol("IHopMap.clear",this$);
}
}
});
fress.impl.hopmap.clear = (function fress$impl$hopmap$clear(this$){
if((((!((this$ == null)))) && ((!((this$.fress$impl$hopmap$IHopMap$clear$arity$1 == null)))))){
return this$.fress$impl$hopmap$IHopMap$clear$arity$1(this$);
} else {
return fress$impl$hopmap$IHopMap$clear$dyn_27224(this$);
}
});

var fress$impl$hopmap$IHopMap$oldIndex$dyn_27228 = (function (this$,k){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (fress.impl.hopmap.oldIndex[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(this$,k) : m__5351__auto__.call(null, this$,k));
} else {
var m__5349__auto__ = (fress.impl.hopmap.oldIndex["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(this$,k) : m__5349__auto__.call(null, this$,k));
} else {
throw cljs.core.missing_protocol("IHopMap.oldIndex",this$);
}
}
});
fress.impl.hopmap.oldIndex = (function fress$impl$hopmap$oldIndex(this$,k){
if((((!((this$ == null)))) && ((!((this$.fress$impl$hopmap$IHopMap$oldIndex$arity$2 == null)))))){
return this$.fress$impl$hopmap$IHopMap$oldIndex$arity$2(this$,k);
} else {
return fress$impl$hopmap$IHopMap$oldIndex$dyn_27228(this$,k);
}
});

var fress$impl$hopmap$IHopMap$isEmpty$dyn_27234 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (fress.impl.hopmap.isEmpty[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null, this$));
} else {
var m__5349__auto__ = (fress.impl.hopmap.isEmpty["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null, this$));
} else {
throw cljs.core.missing_protocol("IHopMap.isEmpty",this$);
}
}
});
fress.impl.hopmap.isEmpty = (function fress$impl$hopmap$isEmpty(this$){
if((((!((this$ == null)))) && ((!((this$.fress$impl$hopmap$IHopMap$isEmpty$arity$1 == null)))))){
return this$.fress$impl$hopmap$IHopMap$isEmpty$arity$1(this$);
} else {
return fress$impl$hopmap$IHopMap$isEmpty$dyn_27234(this$);
}
});

var fress$impl$hopmap$IHopMap$intern$dyn_27235 = (function (this$,k){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (fress.impl.hopmap.intern[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(this$,k) : m__5351__auto__.call(null, this$,k));
} else {
var m__5349__auto__ = (fress.impl.hopmap.intern["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(this$,k) : m__5349__auto__.call(null, this$,k));
} else {
throw cljs.core.missing_protocol("IHopMap.intern",this$);
}
}
});
fress.impl.hopmap.intern = (function fress$impl$hopmap$intern(this$,k){
if((((!((this$ == null)))) && ((!((this$.fress$impl$hopmap$IHopMap$intern$arity$2 == null)))))){
return this$.fress$impl$hopmap$IHopMap$intern$arity$2(this$,k);
} else {
return fress$impl$hopmap$IHopMap$intern$dyn_27235(this$,k);
}
});

var fress$impl$hopmap$IHopMap$resize$dyn_27237 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (fress.impl.hopmap.resize[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null, this$));
} else {
var m__5349__auto__ = (fress.impl.hopmap.resize["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null, this$));
} else {
throw cljs.core.missing_protocol("IHopMap.resize",this$);
}
}
});
fress.impl.hopmap.resize = (function fress$impl$hopmap$resize(this$){
if((((!((this$ == null)))) && ((!((this$.fress$impl$hopmap$IHopMap$resize$arity$1 == null)))))){
return this$.fress$impl$hopmap$IHopMap$resize$arity$1(this$);
} else {
return fress$impl$hopmap$IHopMap$resize$dyn_27237(this$);
}
});

var fress$impl$hopmap$IHopMap$findSlot$dyn_27238 = (function (this$,hash){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (fress.impl.hopmap.findSlot[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(this$,hash) : m__5351__auto__.call(null, this$,hash));
} else {
var m__5349__auto__ = (fress.impl.hopmap.findSlot["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(this$,hash) : m__5349__auto__.call(null, this$,hash));
} else {
throw cljs.core.missing_protocol("IHopMap.findSlot",this$);
}
}
});
fress.impl.hopmap.findSlot = (function fress$impl$hopmap$findSlot(this$,hash){
if((((!((this$ == null)))) && ((!((this$.fress$impl$hopmap$IHopMap$findSlot$arity$2 == null)))))){
return this$.fress$impl$hopmap$IHopMap$findSlot$arity$2(this$,hash);
} else {
return fress$impl$hopmap$IHopMap$findSlot$dyn_27238(this$,hash);
}
});

fress.impl.hopmap._hash = (function fress$impl$hopmap$_hash(k){
var h = cljs.core.hash(k);
if((h === (0))){
return (42);
} else {
return h;
}
});
/**
 * @param k, non-null
 * @return the integer associated with k, or -1 if not present
 */
fress.impl.hopmap._get = (function fress$impl$hopmap$_get(this$,k){
if((!((k == null)))){
} else {
throw (new Error("Assert failed: (some? k)"));
}

var hopidx = this$.hopidx;
var keys = this$.keys;
var hash = fress.impl.hopmap._hash(k);
var mask = (this$.cap - (1));
var bkt = (hash & mask);
var bhash = (hopidx[(bkt << (2))]);
if(((cljs.core.int_QMARK_(hash)) && (((cljs.core.int_QMARK_(mask)) && (((cljs.core.int_QMARK_(bkt)) && (cljs.core.int_QMARK_(bhash)))))))){
} else {
throw (new Error("Assert failed: (and (int? hash) (int? mask) (int? bkt) (int? bhash))"));
}

var or__5002__auto__ = (function (){var and__5000__auto__ = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),bhash);
if(and__5000__auto__){
var key_index = (hopidx[((bkt << (2)) + (1))]);
var bkey = (keys[key_index]);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(hash,bhash)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,bkey)))){
return key_index;
} else {
var bkt__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(bkt);
var increment_bkt = (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(bkt__$1,(function (n){
return ((n + (1)) & mask);
}));
});
var slot = ((cljs.core.deref(bkt__$1) << (2)) + (2));
while(true){
var bhash__$1 = (hopidx[slot]);
if((bhash__$1 === (0))){
return null;
} else {
var key_index__$1 = (hopidx[((cljs.core.deref(bkt__$1) << (2)) + (3))]);
var bkey__$1 = (keys[key_index__$1]);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(hash,bhash__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(bkey__$1,k)))){
return (hopidx[((cljs.core.deref(bkt__$1) << (2)) + (3))]);
} else {
increment_bkt();

var G__27244 = ((cljs.core.deref(bkt__$1) << (2)) + (2));
slot = G__27244;
continue;
}
}
break;
}
}
} else {
return and__5000__auto__;
}
})();
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return (-1);
}
});
fress.impl.hopmap._clear = (function fress$impl$hopmap$_clear(this$){
(this$.count = (0));

var n__5593__auto___27245 = this$.cap;
var i_27246 = (0);
while(true){
if((i_27246 < n__5593__auto___27245)){
(this$.keys[i_27246] = null);

var G__27248 = (i_27246 + (1));
i_27246 = G__27248;
continue;
} else {
}
break;
}

var cap2 = (this$.cap << (2));
var n__5593__auto__ = cap2;
var i = (0);
while(true){
if((i < n__5593__auto__)){
(this$.hopidx[i] = (0));

var G__27249 = (i + (1));
i = G__27249;
continue;
} else {
return null;
}
break;
}
});
/**
 * Puts k in the map if it was not already present.
 * Returns -1 if k was freshly added
 * Returns k's index if k was already in the map.
 * @param k, non-null
 * @return the integer associated with k or -1
 */
fress.impl.hopmap._oldIndex = (function fress$impl$hopmap$_oldIndex(this$,k){
var countBefore = this$.count;
var index = fress.impl.hopmap.intern(this$,k);
if(cljs.core.int_QMARK_(countBefore)){
} else {
throw (new Error("Assert failed: (int? countBefore)"));
}

if(cljs.core.int_QMARK_(index)){
} else {
throw (new Error("Assert failed: (int? index)"));
}

if((countBefore === this$.count)){
return index;
} else {
return (-1);
}
});
/**
 * Puts k in the map (if not present) and assigns and returns the index associated with it
 * assigns ints monotonically from 0
 * @param k, non-null
 * @return the integer associated with k
 */
fress.impl.hopmap._intern = (function fress$impl$hopmap$_intern(this$,k){
if((!((k == null)))){
} else {
throw (new Error("Assert failed: (some? k)"));
}

var _PERCENT_ = (function (){var hopidx = this$.hopidx;
var keys = this$.keys;
var hash = fress.impl.hopmap._hash(k);
var mask = (this$.cap - (1));
var bkt = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((hash & mask));
var bhash = (hopidx[(cljs.core.deref(bkt) << (2))]);
var slot = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
if((bhash === (0))){
cljs.core.reset_BANG_(slot,(cljs.core.deref(bkt) << (2)));
} else {
}

var or__5002__auto__ = (((bhash === (0)))?null:(function (){var or__5002__auto__ = (function (){var and__5000__auto__ = (hash === bhash);
if(and__5000__auto__){
var key_index = (hopidx[((cljs.core.deref(bkt) << (2)) + (1))]);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(keys[key_index]))){
return key_index;
} else {
return null;
}
} else {
return and__5000__auto__;
}
})();
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
var or__5002__auto____$1 = (function (){var increment_bkt = (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(bkt,(function (n){
return ((n + (1)) & mask);
}));
});
var slot__$1 = ((cljs.core.deref(bkt) << (2)) + (2));
while(true){
var bhash__$1 = (hopidx[slot__$1]);
if((bhash__$1 === (0))){
return null;
} else {
if((hash === bhash__$1)){
var key_index = (hopidx[((cljs.core.deref(bkt) << (2)) + (3))]);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(keys[key_index]))){
return key_index;
} else {
increment_bkt();

var G__27255 = ((cljs.core.deref(bkt) << (2)) + (2));
slot__$1 = G__27255;
continue;
}
} else {
increment_bkt();

var G__27256 = ((cljs.core.deref(bkt) << (2)) + (2));
slot__$1 = G__27256;
continue;
}
}
break;
}
})();
if(cljs.core.truth_(or__5002__auto____$1)){
return or__5002__auto____$1;
} else {
cljs.core.reset_BANG_(slot,((2) + (cljs.core.deref(bkt) << (2))));

return null;
}
}
})());
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
var i = this$.count;
(hopidx[cljs.core.deref(slot)] = hash);

(hopidx[(cljs.core.deref(slot) + (1))] = i);

(keys[i] = k);

(this$.count = (this$.count + (1)));

if((this$.count === this$.cap)){
fress.impl.hopmap.resize(this$);
} else {
}

return i;
}
})();
if(cljs.core.truth_(cljs.core.int_QMARK_)){
} else {
throw (new Error("Assert failed: int?"));
}

return _PERCENT_;
});
fress.impl.hopmap._findSlot = (function fress$impl$hopmap$_findSlot(this$,hash){
if(cljs.core.int_QMARK_(hash)){
} else {
throw (new Error("Assert failed: (int? hash)"));
}

var _PERCENT_ = (function (){var hopidx = this$.hopidx;
var cap = this$.cap;
var mask = (cap - (1));
var bkt = (hash & mask);
var bhash = (hopidx[(bkt << (2))]);
if(((cljs.core.int_QMARK_(mask)) && (((cljs.core.int_QMARK_(bkt)) && (cljs.core.int_QMARK_(bhash)))))){
} else {
throw (new Error("Assert failed: (and (int? mask) (int? bkt) (int? bhash))"));
}

if((bhash === (0))){
return (bkt << (2));
} else {
var slot = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var _ = cljs.core.set_validator_BANG_(slot,cljs.core.int_QMARK_);
var idx = (hopidx[((bkt << (2)) + (2))]);
var bkt__$1 = ((bkt + (1)) & mask);
while(true){
if((bkt__$1 === (0))){
return cljs.core.deref(slot);
} else {
cljs.core.reset_BANG_(slot,((bkt__$1 << (2)) + (2)));

var G__27259 = (hopidx[((bkt__$1 << (2)) + (2))]);
var G__27260 = ((bkt__$1 + (1)) & mask);
idx = G__27259;
bkt__$1 = G__27260;
continue;
}
break;
}
}
})();
if(cljs.core.truth_(cljs.core.int_QMARK_)){
} else {
throw (new Error("Assert failed: int?"));
}

return _PERCENT_;
});
fress.impl.hopmap._resize = (function fress$impl$hopmap$_resize(this$){
var oldhops = this$.hopidx;
(this$.hopidx = fress.util.i32_array.cljs$core$IFn$_invoke$arity$1(((2) * oldhops.length)));

(this$.cap = (this$.cap << (1)));

(this$.keys.length = this$.cap);

var slot = (0);
while(true){
if((slot < oldhops.length)){
var item = (oldhops[slot]);
var new_slot = fress.impl.hopmap.findSlot(this$,item);
(this$.hopidx[new_slot] = item);

(this$.hopidx[(new_slot + (1))] = (oldhops[(slot + (1))]));

var G__27262 = ((2) + slot);
slot = G__27262;
continue;
} else {
return null;
}
break;
}
});

/**
* @constructor
 * @implements {fress.impl.hopmap.IHopMap}
 * @implements {cljs.core.ILookup}
*/
fress.impl.hopmap.InterleavedIndexHopMap = (function (cap,hopidx,keys,count){
this.cap = cap;
this.hopidx = hopidx;
this.keys = keys;
this.count = count;
this.cljs$lang$protocol_mask$partition0$ = 256;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(fress.impl.hopmap.InterleavedIndexHopMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,k){
var self__ = this;
var this$__$1 = this;
return fress.impl.hopmap._get(this$__$1,k);
}));

(fress.impl.hopmap.InterleavedIndexHopMap.prototype.fress$impl$hopmap$IHopMap$ = cljs.core.PROTOCOL_SENTINEL);

(fress.impl.hopmap.InterleavedIndexHopMap.prototype.fress$impl$hopmap$IHopMap$isEmpty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return (self__.count === (0));
}));

(fress.impl.hopmap.InterleavedIndexHopMap.prototype.fress$impl$hopmap$IHopMap$clear$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fress.impl.hopmap._clear(this$__$1);
}));

(fress.impl.hopmap.InterleavedIndexHopMap.prototype.fress$impl$hopmap$IHopMap$oldIndex$arity$2 = (function (this$,k){
var self__ = this;
var this$__$1 = this;
return fress.impl.hopmap._oldIndex(this$__$1,k);
}));

(fress.impl.hopmap.InterleavedIndexHopMap.prototype.fress$impl$hopmap$IHopMap$intern$arity$2 = (function (this$,k){
var self__ = this;
var this$__$1 = this;
return fress.impl.hopmap._intern(this$__$1,k);
}));

(fress.impl.hopmap.InterleavedIndexHopMap.prototype.fress$impl$hopmap$IHopMap$resize$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fress.impl.hopmap._resize(this$__$1);
}));

(fress.impl.hopmap.InterleavedIndexHopMap.prototype.fress$impl$hopmap$IHopMap$findSlot$arity$2 = (function (this$,h){
var self__ = this;
var this$__$1 = this;
return fress.impl.hopmap._findSlot(this$__$1,h);
}));

(fress.impl.hopmap.InterleavedIndexHopMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"cap","cap",822909940,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"number","number",-1084057331,null)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"hopidx","hopidx",1029567171,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"array","array",-440182315,null)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"keys","keys",-1586012071,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"array","array",-440182315,null)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"number","number",-1084057331,null)], null))], null);
}));

(fress.impl.hopmap.InterleavedIndexHopMap.cljs$lang$type = true);

(fress.impl.hopmap.InterleavedIndexHopMap.cljs$lang$ctorStr = "fress.impl.hopmap/InterleavedIndexHopMap");

(fress.impl.hopmap.InterleavedIndexHopMap.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"fress.impl.hopmap/InterleavedIndexHopMap");
}));

/**
 * Positional factory function for fress.impl.hopmap/InterleavedIndexHopMap.
 */
fress.impl.hopmap.__GT_InterleavedIndexHopMap = (function fress$impl$hopmap$__GT_InterleavedIndexHopMap(cap,hopidx,keys,count){
return (new fress.impl.hopmap.InterleavedIndexHopMap(cap,hopidx,keys,count));
});

fress.impl.hopmap.hopmap = (function fress$impl$hopmap$hopmap(var_args){
var G__27209 = arguments.length;
switch (G__27209) {
case 0:
return fress.impl.hopmap.hopmap.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fress.impl.hopmap.hopmap.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fress.impl.hopmap.hopmap.cljs$core$IFn$_invoke$arity$0 = (function (){
return fress.impl.hopmap.hopmap.cljs$core$IFn$_invoke$arity$1((1024));
}));

(fress.impl.hopmap.hopmap.cljs$core$IFn$_invoke$arity$1 = (function (capacity){
var cap = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((1));
var _ = (function (){while(true){
if((cljs.core.deref(cap) < capacity)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cap,((function (cap){
return (function (p1__27204_SHARP_){
return (p1__27204_SHARP_ << (1));
});})(cap))
);

continue;
} else {
return null;
}
break;
}
})();
var cap__$1 = cljs.core.deref(cap);
var hopidx = fress.util.i32_array.cljs$core$IFn$_invoke$arity$1((cap__$1 << (2)));
var keys = (new Array(cap__$1));
return (new fress.impl.hopmap.InterleavedIndexHopMap(cap__$1,hopidx,keys,(0)));
}));

(fress.impl.hopmap.hopmap.cljs$lang$maxFixedArity = 1);


//# sourceMappingURL=fress.impl.hopmap.js.map
