goog.provide('fress.impl.buffer');

/**
 * @interface
 */
fress.impl.buffer.IBuffer = function(){};

var fress$impl$buffer$IBuffer$getByte$dyn_26280 = (function (this$,index){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (fress.impl.buffer.getByte[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(this$,index) : m__5351__auto__.call(null, this$,index));
} else {
var m__5349__auto__ = (fress.impl.buffer.getByte["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(this$,index) : m__5349__auto__.call(null, this$,index));
} else {
throw cljs.core.missing_protocol("IBuffer.getByte",this$);
}
}
});
fress.impl.buffer.getByte = (function fress$impl$buffer$getByte(this$,index){
if((((!((this$ == null)))) && ((!((this$.fress$impl$buffer$IBuffer$getByte$arity$2 == null)))))){
return this$.fress$impl$buffer$IBuffer$getByte$arity$2(this$,index);
} else {
return fress$impl$buffer$IBuffer$getByte$dyn_26280(this$,index);
}
});

var fress$impl$buffer$IBuffer$getBytes$dyn_26292 = (function (this$,off,length){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (fress.impl.buffer.getBytes[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(this$,off,length) : m__5351__auto__.call(null, this$,off,length));
} else {
var m__5349__auto__ = (fress.impl.buffer.getBytes["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(this$,off,length) : m__5349__auto__.call(null, this$,off,length));
} else {
throw cljs.core.missing_protocol("IBuffer.getBytes",this$);
}
}
});
fress.impl.buffer.getBytes = (function fress$impl$buffer$getBytes(this$,off,length){
if((((!((this$ == null)))) && ((!((this$.fress$impl$buffer$IBuffer$getBytes$arity$3 == null)))))){
return this$.fress$impl$buffer$IBuffer$getBytes$arity$3(this$,off,length);
} else {
return fress$impl$buffer$IBuffer$getBytes$dyn_26292(this$,off,length);
}
});

var fress$impl$buffer$IBuffer$reset$dyn_26296 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (fress.impl.buffer.reset[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null, this$));
} else {
var m__5349__auto__ = (fress.impl.buffer.reset["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null, this$));
} else {
throw cljs.core.missing_protocol("IBuffer.reset",this$);
}
}
});
fress.impl.buffer.reset = (function fress$impl$buffer$reset(this$){
if((((!((this$ == null)))) && ((!((this$.fress$impl$buffer$IBuffer$reset$arity$1 == null)))))){
return this$.fress$impl$buffer$IBuffer$reset$arity$1(this$);
} else {
return fress$impl$buffer$IBuffer$reset$dyn_26296(this$);
}
});


/**
 * @interface
 */
fress.impl.buffer.IBufferReader = function(){};

var fress$impl$buffer$IBufferReader$getBytesRead$dyn_26297 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (fress.impl.buffer.getBytesRead[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null, this$));
} else {
var m__5349__auto__ = (fress.impl.buffer.getBytesRead["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null, this$));
} else {
throw cljs.core.missing_protocol("IBufferReader.getBytesRead",this$);
}
}
});
fress.impl.buffer.getBytesRead = (function fress$impl$buffer$getBytesRead(this$){
if((((!((this$ == null)))) && ((!((this$.fress$impl$buffer$IBufferReader$getBytesRead$arity$1 == null)))))){
return this$.fress$impl$buffer$IBufferReader$getBytesRead$arity$1(this$);
} else {
return fress$impl$buffer$IBufferReader$getBytesRead$dyn_26297(this$);
}
});

var fress$impl$buffer$IBufferReader$notifyBytesRead$dyn_26298 = (function (this$,count){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (fress.impl.buffer.notifyBytesRead[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(this$,count) : m__5351__auto__.call(null, this$,count));
} else {
var m__5349__auto__ = (fress.impl.buffer.notifyBytesRead["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(this$,count) : m__5349__auto__.call(null, this$,count));
} else {
throw cljs.core.missing_protocol("IBufferReader.notifyBytesRead",this$);
}
}
});
fress.impl.buffer.notifyBytesRead = (function fress$impl$buffer$notifyBytesRead(this$,count){
if((((!((this$ == null)))) && ((!((this$.fress$impl$buffer$IBufferReader$notifyBytesRead$arity$2 == null)))))){
return this$.fress$impl$buffer$IBufferReader$notifyBytesRead$arity$2(this$,count);
} else {
return fress$impl$buffer$IBufferReader$notifyBytesRead$dyn_26298(this$,count);
}
});

var fress$impl$buffer$IBufferReader$readUnsignedByte$dyn_26299 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (fress.impl.buffer.readUnsignedByte[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null, this$));
} else {
var m__5349__auto__ = (fress.impl.buffer.readUnsignedByte["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null, this$));
} else {
throw cljs.core.missing_protocol("IBufferReader.readUnsignedByte",this$);
}
}
});
fress.impl.buffer.readUnsignedByte = (function fress$impl$buffer$readUnsignedByte(this$){
if((((!((this$ == null)))) && ((!((this$.fress$impl$buffer$IBufferReader$readUnsignedByte$arity$1 == null)))))){
return this$.fress$impl$buffer$IBufferReader$readUnsignedByte$arity$1(this$);
} else {
return fress$impl$buffer$IBufferReader$readUnsignedByte$dyn_26299(this$);
}
});

var fress$impl$buffer$IBufferReader$readSignedByte$dyn_26300 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (fress.impl.buffer.readSignedByte[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null, this$));
} else {
var m__5349__auto__ = (fress.impl.buffer.readSignedByte["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null, this$));
} else {
throw cljs.core.missing_protocol("IBufferReader.readSignedByte",this$);
}
}
});
fress.impl.buffer.readSignedByte = (function fress$impl$buffer$readSignedByte(this$){
if((((!((this$ == null)))) && ((!((this$.fress$impl$buffer$IBufferReader$readSignedByte$arity$1 == null)))))){
return this$.fress$impl$buffer$IBufferReader$readSignedByte$arity$1(this$);
} else {
return fress$impl$buffer$IBufferReader$readSignedByte$dyn_26300(this$);
}
});

var fress$impl$buffer$IBufferReader$readUnsignedBytes$dyn_26301 = (function (this$,length){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (fress.impl.buffer.readUnsignedBytes[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(this$,length) : m__5351__auto__.call(null, this$,length));
} else {
var m__5349__auto__ = (fress.impl.buffer.readUnsignedBytes["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(this$,length) : m__5349__auto__.call(null, this$,length));
} else {
throw cljs.core.missing_protocol("IBufferReader.readUnsignedBytes",this$);
}
}
});
/**
 * return unsigned byte view on memory
 */
fress.impl.buffer.readUnsignedBytes = (function fress$impl$buffer$readUnsignedBytes(this$,length){
if((((!((this$ == null)))) && ((!((this$.fress$impl$buffer$IBufferReader$readUnsignedBytes$arity$2 == null)))))){
return this$.fress$impl$buffer$IBufferReader$readUnsignedBytes$arity$2(this$,length);
} else {
return fress$impl$buffer$IBufferReader$readUnsignedBytes$dyn_26301(this$,length);
}
});

var fress$impl$buffer$IBufferReader$readSignedBytes$dyn_26302 = (function (this$,length){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (fress.impl.buffer.readSignedBytes[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(this$,length) : m__5351__auto__.call(null, this$,length));
} else {
var m__5349__auto__ = (fress.impl.buffer.readSignedBytes["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(this$,length) : m__5349__auto__.call(null, this$,length));
} else {
throw cljs.core.missing_protocol("IBufferReader.readSignedBytes",this$);
}
}
});
/**
 * return signed byte view on memory
 */
fress.impl.buffer.readSignedBytes = (function fress$impl$buffer$readSignedBytes(this$,length){
if((((!((this$ == null)))) && ((!((this$.fress$impl$buffer$IBufferReader$readSignedBytes$arity$2 == null)))))){
return this$.fress$impl$buffer$IBufferReader$readSignedBytes$arity$2(this$,length);
} else {
return fress$impl$buffer$IBufferReader$readSignedBytes$dyn_26302(this$,length);
}
});


/**
 * @interface
 */
fress.impl.buffer.IBufferWriter = function(){};

var fress$impl$buffer$IBufferWriter$getFreeCapacity$dyn_26303 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (fress.impl.buffer.getFreeCapacity[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null, this$));
} else {
var m__5349__auto__ = (fress.impl.buffer.getFreeCapacity["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null, this$));
} else {
throw cljs.core.missing_protocol("IBufferWriter.getFreeCapacity",this$);
}
}
});
/**
 * remaining free bytes to write
 */
fress.impl.buffer.getFreeCapacity = (function fress$impl$buffer$getFreeCapacity(this$){
if((((!((this$ == null)))) && ((!((this$.fress$impl$buffer$IBufferWriter$getFreeCapacity$arity$1 == null)))))){
return this$.fress$impl$buffer$IBufferWriter$getFreeCapacity$arity$1(this$);
} else {
return fress$impl$buffer$IBufferWriter$getFreeCapacity$dyn_26303(this$);
}
});

var fress$impl$buffer$IBufferWriter$room_QMARK_$dyn_26304 = (function (this$,length){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (fress.impl.buffer.room_QMARK_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(this$,length) : m__5351__auto__.call(null, this$,length));
} else {
var m__5349__auto__ = (fress.impl.buffer.room_QMARK_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(this$,length) : m__5349__auto__.call(null, this$,length));
} else {
throw cljs.core.missing_protocol("IBufferWriter.room?",this$);
}
}
});
fress.impl.buffer.room_QMARK_ = (function fress$impl$buffer$room_QMARK_(this$,length){
if((((!((this$ == null)))) && ((!((this$.fress$impl$buffer$IBufferWriter$room_QMARK_$arity$2 == null)))))){
return this$.fress$impl$buffer$IBufferWriter$room_QMARK_$arity$2(this$,length);
} else {
return fress$impl$buffer$IBufferWriter$room_QMARK_$dyn_26304(this$,length);
}
});

var fress$impl$buffer$IBufferWriter$getBytesWritten$dyn_26305 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (fress.impl.buffer.getBytesWritten[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null, this$));
} else {
var m__5349__auto__ = (fress.impl.buffer.getBytesWritten["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null, this$));
} else {
throw cljs.core.missing_protocol("IBufferWriter.getBytesWritten",this$);
}
}
});
fress.impl.buffer.getBytesWritten = (function fress$impl$buffer$getBytesWritten(this$){
if((((!((this$ == null)))) && ((!((this$.fress$impl$buffer$IBufferWriter$getBytesWritten$arity$1 == null)))))){
return this$.fress$impl$buffer$IBufferWriter$getBytesWritten$arity$1(this$);
} else {
return fress$impl$buffer$IBufferWriter$getBytesWritten$dyn_26305(this$);
}
});

var fress$impl$buffer$IBufferWriter$writeByte$dyn_26308 = (function (this$,byte$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (fress.impl.buffer.writeByte[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(this$,byte$) : m__5351__auto__.call(null, this$,byte$));
} else {
var m__5349__auto__ = (fress.impl.buffer.writeByte["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(this$,byte$) : m__5349__auto__.call(null, this$,byte$));
} else {
throw cljs.core.missing_protocol("IBufferWriter.writeByte",this$);
}
}
});
fress.impl.buffer.writeByte = (function fress$impl$buffer$writeByte(this$,byte$){
if((((!((this$ == null)))) && ((!((this$.fress$impl$buffer$IBufferWriter$writeByte$arity$2 == null)))))){
return this$.fress$impl$buffer$IBufferWriter$writeByte$arity$2(this$,byte$);
} else {
return fress$impl$buffer$IBufferWriter$writeByte$dyn_26308(this$,byte$);
}
});

var fress$impl$buffer$IBufferWriter$writeBytes$dyn_26309 = (function() {
var G__26310 = null;
var G__26310__2 = (function (this$,bytes){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (fress.impl.buffer.writeBytes[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(this$,bytes) : m__5351__auto__.call(null, this$,bytes));
} else {
var m__5349__auto__ = (fress.impl.buffer.writeBytes["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(this$,bytes) : m__5349__auto__.call(null, this$,bytes));
} else {
throw cljs.core.missing_protocol("IBufferWriter.writeBytes",this$);
}
}
});
var G__26310__4 = (function (this$,bytes,offset,length){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (fress.impl.buffer.writeBytes[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$4(this$,bytes,offset,length) : m__5351__auto__.call(null, this$,bytes,offset,length));
} else {
var m__5349__auto__ = (fress.impl.buffer.writeBytes["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$4(this$,bytes,offset,length) : m__5349__auto__.call(null, this$,bytes,offset,length));
} else {
throw cljs.core.missing_protocol("IBufferWriter.writeBytes",this$);
}
}
});
G__26310 = function(this$,bytes,offset,length){
switch(arguments.length){
case 2:
return G__26310__2.call(this,this$,bytes);
case 4:
return G__26310__4.call(this,this$,bytes,offset,length);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__26310.cljs$core$IFn$_invoke$arity$2 = G__26310__2;
G__26310.cljs$core$IFn$_invoke$arity$4 = G__26310__4;
return G__26310;
})()
;
fress.impl.buffer.writeBytes = (function fress$impl$buffer$writeBytes(var_args){
var G__25975 = arguments.length;
switch (G__25975) {
case 2:
return fress.impl.buffer.writeBytes.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fress.impl.buffer.writeBytes.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fress.impl.buffer.writeBytes.cljs$core$IFn$_invoke$arity$2 = (function (this$,bytes){
if((((!((this$ == null)))) && ((!((this$.fress$impl$buffer$IBufferWriter$writeBytes$arity$2 == null)))))){
return this$.fress$impl$buffer$IBufferWriter$writeBytes$arity$2(this$,bytes);
} else {
return fress$impl$buffer$IBufferWriter$writeBytes$dyn_26309(this$,bytes);
}
}));

(fress.impl.buffer.writeBytes.cljs$core$IFn$_invoke$arity$4 = (function (this$,bytes,offset,length){
if((((!((this$ == null)))) && ((!((this$.fress$impl$buffer$IBufferWriter$writeBytes$arity$4 == null)))))){
return this$.fress$impl$buffer$IBufferWriter$writeBytes$arity$4(this$,bytes,offset,length);
} else {
return fress$impl$buffer$IBufferWriter$writeBytes$dyn_26309(this$,bytes,offset,length);
}
}));

(fress.impl.buffer.writeBytes.cljs$lang$maxFixedArity = 4);


var fress$impl$buffer$IBufferWriter$notifyBytesWritten$dyn_26312 = (function (this$,count){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (fress.impl.buffer.notifyBytesWritten[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(this$,count) : m__5351__auto__.call(null, this$,count));
} else {
var m__5349__auto__ = (fress.impl.buffer.notifyBytesWritten["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(this$,count) : m__5349__auto__.call(null, this$,count));
} else {
throw cljs.core.missing_protocol("IBufferWriter.notifyBytesWritten",this$);
}
}
});
fress.impl.buffer.notifyBytesWritten = (function fress$impl$buffer$notifyBytesWritten(this$,count){
if((((!((this$ == null)))) && ((!((this$.fress$impl$buffer$IBufferWriter$notifyBytesWritten$arity$2 == null)))))){
return this$.fress$impl$buffer$IBufferWriter$notifyBytesWritten$arity$2(this$,count);
} else {
return fress$impl$buffer$IBufferWriter$notifyBytesWritten$dyn_26312(this$,count);
}
});


/**
 * @interface
 */
fress.impl.buffer.IStreamingWriter = function(){};

var fress$impl$buffer$IStreamingWriter$toByteArray$dyn_26313 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (fress.impl.buffer.toByteArray[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null, this$));
} else {
var m__5349__auto__ = (fress.impl.buffer.toByteArray["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null, this$));
} else {
throw cljs.core.missing_protocol("IStreamingWriter.toByteArray",this$);
}
}
});
/**
 * get byte-array of current buffer contents. does not close.
 */
fress.impl.buffer.toByteArray = (function fress$impl$buffer$toByteArray(this$){
if((((!((this$ == null)))) && ((!((this$.fress$impl$buffer$IStreamingWriter$toByteArray$arity$1 == null)))))){
return this$.fress$impl$buffer$IStreamingWriter$toByteArray$arity$1(this$);
} else {
return fress$impl$buffer$IStreamingWriter$toByteArray$dyn_26313(this$);
}
});

var fress$impl$buffer$IStreamingWriter$flushTo$dyn_26314 = (function() {
var G__26315 = null;
var G__26315__2 = (function (this$,out){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (fress.impl.buffer.flushTo[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(this$,out) : m__5351__auto__.call(null, this$,out));
} else {
var m__5349__auto__ = (fress.impl.buffer.flushTo["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(this$,out) : m__5349__auto__.call(null, this$,out));
} else {
throw cljs.core.missing_protocol("IStreamingWriter.flushTo",this$);
}
}
});
var G__26315__3 = (function (this$,out,offset){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (fress.impl.buffer.flushTo[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(this$,out,offset) : m__5351__auto__.call(null, this$,out,offset));
} else {
var m__5349__auto__ = (fress.impl.buffer.flushTo["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(this$,out,offset) : m__5349__auto__.call(null, this$,out,offset));
} else {
throw cljs.core.missing_protocol("IStreamingWriter.flushTo",this$);
}
}
});
G__26315 = function(this$,out,offset){
switch(arguments.length){
case 2:
return G__26315__2.call(this,this$,out);
case 3:
return G__26315__3.call(this,this$,out,offset);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__26315.cljs$core$IFn$_invoke$arity$2 = G__26315__2;
G__26315.cljs$core$IFn$_invoke$arity$3 = G__26315__3;
return G__26315;
})()
;
/**
 * write bytes to externally provided arraybuffer source at the given offset
 */
fress.impl.buffer.flushTo = (function fress$impl$buffer$flushTo(var_args){
var G__26043 = arguments.length;
switch (G__26043) {
case 2:
return fress.impl.buffer.flushTo.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fress.impl.buffer.flushTo.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fress.impl.buffer.flushTo.cljs$core$IFn$_invoke$arity$2 = (function (this$,out){
if((((!((this$ == null)))) && ((!((this$.fress$impl$buffer$IStreamingWriter$flushTo$arity$2 == null)))))){
return this$.fress$impl$buffer$IStreamingWriter$flushTo$arity$2(this$,out);
} else {
return fress$impl$buffer$IStreamingWriter$flushTo$dyn_26314(this$,out);
}
}));

(fress.impl.buffer.flushTo.cljs$core$IFn$_invoke$arity$3 = (function (this$,out,offset){
if((((!((this$ == null)))) && ((!((this$.fress$impl$buffer$IStreamingWriter$flushTo$arity$3 == null)))))){
return this$.fress$impl$buffer$IStreamingWriter$flushTo$arity$3(this$,out,offset);
} else {
return fress$impl$buffer$IStreamingWriter$flushTo$dyn_26314(this$,out,offset);
}
}));

(fress.impl.buffer.flushTo.cljs$lang$maxFixedArity = 3);



/**
* @constructor
 * @implements {fress.impl.buffer.IBuffer}
 * @implements {fress.impl.buffer.IBufferReader}
*/
fress.impl.buffer.BufferReader = (function (u8arr,backing_offset,bytesRead){
this.u8arr = u8arr;
this.backing_offset = backing_offset;
this.bytesRead = bytesRead;
});
(fress.impl.buffer.BufferReader.prototype.fress$impl$buffer$IBuffer$ = cljs.core.PROTOCOL_SENTINEL);

(fress.impl.buffer.BufferReader.prototype.fress$impl$buffer$IBuffer$reset$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
(this$__$1.bytesRead = (0));

return (this$__$1.open_QMARK_ = true);
}));

(fress.impl.buffer.BufferReader.prototype.fress$impl$buffer$IBufferReader$ = cljs.core.PROTOCOL_SENTINEL);

(fress.impl.buffer.BufferReader.prototype.fress$impl$buffer$IBufferReader$getBytesRead$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.bytesRead;
}));

(fress.impl.buffer.BufferReader.prototype.fress$impl$buffer$IBufferReader$notifyBytesRead$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (this$__$1.bytesRead = (self__.bytesRead + n));
}));

(fress.impl.buffer.BufferReader.prototype.fress$impl$buffer$IBufferReader$readUnsignedByte$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var byte$ = (self__.u8arr[(self__.backing_offset + self__.bytesRead)]);
if((void 0 === byte$)){
throw (new Error("EOF"));
} else {
this$__$1.fress$impl$buffer$IBufferReader$notifyBytesRead$arity$2(null, (1));

return byte$;
}
}));

(fress.impl.buffer.BufferReader.prototype.fress$impl$buffer$IBufferReader$readSignedByte$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var byteview = (new Int8Array(self__.u8arr.buffer));
var byte$ = (byteview[(self__.backing_offset + self__.bytesRead)]);
if((void 0 === byte$)){
throw (new Error("EOF"));
} else {
this$__$1.fress$impl$buffer$IBufferReader$notifyBytesRead$arity$2(null, (1));

return byte$;
}
}));

(fress.impl.buffer.BufferReader.prototype.fress$impl$buffer$IBufferReader$readSignedBytes$arity$2 = (function (this$,length){
var self__ = this;
var this$__$1 = this;
var bytes = (new Int8Array(self__.u8arr.buffer,(self__.backing_offset + self__.bytesRead),length));
this$__$1.fress$impl$buffer$IBufferReader$notifyBytesRead$arity$2(null, length);

return bytes;
}));

(fress.impl.buffer.BufferReader.prototype.fress$impl$buffer$IBufferReader$readUnsignedBytes$arity$2 = (function (this$,length){
var self__ = this;
var this$__$1 = this;
var bytes = (new Uint8Array(self__.u8arr.buffer,(self__.backing_offset + self__.bytesRead),length));
this$__$1.fress$impl$buffer$IBufferReader$notifyBytesRead$arity$2(null, length);

return bytes;
}));

(fress.impl.buffer.BufferReader.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"u8arr","u8arr",-1850472626,null),cljs.core.with_meta(new cljs.core.Symbol(null,"backing-offset","backing-offset",1811827358,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"number","number",-1084057331,null)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"bytesRead","bytesRead",-1969314613,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"number","number",-1084057331,null)], null))], null);
}));

(fress.impl.buffer.BufferReader.cljs$lang$type = true);

(fress.impl.buffer.BufferReader.cljs$lang$ctorStr = "fress.impl.buffer/BufferReader");

(fress.impl.buffer.BufferReader.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"fress.impl.buffer/BufferReader");
}));

/**
 * Positional factory function for fress.impl.buffer/BufferReader.
 */
fress.impl.buffer.__GT_BufferReader = (function fress$impl$buffer$__GT_BufferReader(u8arr,backing_offset,bytesRead){
return (new fress.impl.buffer.BufferReader(u8arr,backing_offset,bytesRead));
});


/**
* @constructor
 * @implements {fress.impl.buffer.IBuffer}
 * @implements {fress.impl.buffer.IBufferWriter}
 * @implements {fress.impl.buffer.IStreamingWriter}
 * @implements {cljs.core.IDeref}
*/
fress.impl.buffer.BytesOutputStream = (function (arr,bytesWritten){
this.arr = arr;
this.bytesWritten = bytesWritten;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(fress.impl.buffer.BytesOutputStream.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1.fress$impl$buffer$IStreamingWriter$toByteArray$arity$1(null, );
}));

(fress.impl.buffer.BytesOutputStream.prototype.fress$impl$buffer$IBuffer$ = cljs.core.PROTOCOL_SENTINEL);

(fress.impl.buffer.BytesOutputStream.prototype.fress$impl$buffer$IBuffer$reset$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return (this$__$1.bytesWritten = (0));
}));

(fress.impl.buffer.BytesOutputStream.prototype.fress$impl$buffer$IStreamingWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fress.impl.buffer.BytesOutputStream.prototype.fress$impl$buffer$IStreamingWriter$flushTo$arity$2 = (function (this$,buf){
var self__ = this;
var this$__$1 = this;
return this$__$1.fress$impl$buffer$IStreamingWriter$flushTo$arity$3(null, buf,(0));
}));

(fress.impl.buffer.BytesOutputStream.prototype.fress$impl$buffer$IStreamingWriter$flushTo$arity$3 = (function (this$,buf,ptr){
var self__ = this;
var this$__$1 = this;
if((!((buf.buffer == null)))){
} else {
throw (new Error(["Assert failed: ","flushTo requires an arraybuffer backed typed-array","\n","(some? (.-buffer buf))"].join('')));
}

if(cljs.core.truth_(fress.util.valid_pointer_QMARK_(ptr))){
} else {
throw (new Error(["Assert failed: ",["buffer/flushTo given invalid pointer:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ptr], 0))].join(''),"\n","(util/valid-pointer? ptr)"].join('')));
}

var bytes = (((self__.arr.length === self__.bytesWritten))?self__.arr:self__.arr.slice((0),self__.bytesWritten));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(bytes.length,self__.bytesWritten)){
} else {
throw (new Error("Assert failed: (= (alength bytes) bytesWritten)"));
}

return buf.set(bytes,ptr);
}));

(fress.impl.buffer.BytesOutputStream.prototype.fress$impl$buffer$IStreamingWriter$toByteArray$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.bytesWritten === self__.arr.length)){
return (new Uint8Array(self__.arr));
} else {
return (new Uint8Array(self__.arr.slice((0),self__.bytesWritten)));
}
}));

(fress.impl.buffer.BytesOutputStream.prototype.fress$impl$buffer$IBufferWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fress.impl.buffer.BytesOutputStream.prototype.fress$impl$buffer$IBufferWriter$room_QMARK_$arity$2 = (function (this$,_){
var self__ = this;
var this$__$1 = this;
return true;
}));

(fress.impl.buffer.BytesOutputStream.prototype.fress$impl$buffer$IBufferWriter$getBytesWritten$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.bytesWritten;
}));

(fress.impl.buffer.BytesOutputStream.prototype.fress$impl$buffer$IBufferWriter$notifyBytesWritten$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
if(cljs.core.int_QMARK_(n)){
} else {
throw (new Error(["Assert failed: ","written byte count must be an int","\n","(int? n)"].join('')));
}

return (this$__$1.bytesWritten = (n + self__.bytesWritten));
}));

(fress.impl.buffer.BytesOutputStream.prototype.fress$impl$buffer$IBufferWriter$writeByte$arity$2 = (function (this$,byte$){
var self__ = this;
var this$__$1 = this;
if((self__.bytesWritten <= self__.arr.length)){
(self__.arr[self__.bytesWritten] = byte$);
} else {
self__.arr.push(byte$);
}

return this$__$1.fress$impl$buffer$IBufferWriter$notifyBytesWritten$arity$2(null, (1));
}));

(fress.impl.buffer.BytesOutputStream.prototype.fress$impl$buffer$IBufferWriter$writeBytes$arity$2 = (function (this$,bytes){
var self__ = this;
var this$__$1 = this;
var i = (0);
while(true){
var temp__5823__auto__ = (bytes[i]);
if(cljs.core.truth_(temp__5823__auto__)){
var byte$ = temp__5823__auto__;
this$__$1.fress$impl$buffer$IBufferWriter$writeByte$arity$2(null, byte$);

var G__26327 = (i + (1));
i = G__26327;
continue;
} else {
return null;
}
break;
}
}));

(fress.impl.buffer.BytesOutputStream.prototype.fress$impl$buffer$IBufferWriter$writeBytes$arity$4 = (function (this$,bytes,offset,length){
var self__ = this;
var this$__$1 = this;
var i = offset;
while(true){
var temp__5821__auto__ = (function (){var and__5000__auto__ = ((i - offset) < length);
if(and__5000__auto__){
return (bytes[i]);
} else {
return and__5000__auto__;
}
})();
if(cljs.core.truth_(temp__5821__auto__)){
var byte$ = temp__5821__auto__;
this$__$1.fress$impl$buffer$IBufferWriter$writeByte$arity$2(null, byte$);

var G__26328 = (i + (1));
i = G__26328;
continue;
} else {
return null;
}
break;
}
}));

(fress.impl.buffer.BytesOutputStream.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"array","array",-440182315,null)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"bytesWritten","bytesWritten",-526151767,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"number","number",-1084057331,null)], null))], null);
}));

(fress.impl.buffer.BytesOutputStream.cljs$lang$type = true);

(fress.impl.buffer.BytesOutputStream.cljs$lang$ctorStr = "fress.impl.buffer/BytesOutputStream");

(fress.impl.buffer.BytesOutputStream.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"fress.impl.buffer/BytesOutputStream");
}));

/**
 * Positional factory function for fress.impl.buffer/BytesOutputStream.
 */
fress.impl.buffer.__GT_BytesOutputStream = (function fress$impl$buffer$__GT_BytesOutputStream(arr,bytesWritten){
return (new fress.impl.buffer.BytesOutputStream(arr,bytesWritten));
});

fress.impl.buffer.byte_stream = (function fress$impl$buffer$byte_stream(){
return (new fress.impl.buffer.BytesOutputStream([],(0)));
});
fress.impl.buffer.with_capacity = (function fress$impl$buffer$with_capacity(n){
return (new fress.impl.buffer.BytesOutputStream((new Array(n)),(0)));
});

/**
* @constructor
 * @implements {fress.impl.buffer.IBuffer}
 * @implements {fress.impl.buffer.IBufferWriter}
*/
fress.impl.buffer.BufferWriter = (function (backing,backing_offset,bytesWritten){
this.backing = backing;
this.backing_offset = backing_offset;
this.bytesWritten = bytesWritten;
});
(fress.impl.buffer.BufferWriter.prototype.fress$impl$buffer$IBuffer$ = cljs.core.PROTOCOL_SENTINEL);

(fress.impl.buffer.BufferWriter.prototype.fress$impl$buffer$IBuffer$reset$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return (this$__$1.bytesWritten = (0));
}));

(fress.impl.buffer.BufferWriter.prototype.fress$impl$buffer$IBuffer$getByte$arity$2 = (function (this$,index){
var self__ = this;
var this$__$1 = this;
if(((cljs.core.int_QMARK_(index)) && (((0) <= index)))){
} else {
throw (new Error("Assert failed: (and (int? index) (<= 0 index))"));
}

return ((new Uint8Array(self__.backing.buffer))[(self__.backing_offset + index)]);
}));

(fress.impl.buffer.BufferWriter.prototype.fress$impl$buffer$IBuffer$getBytes$arity$3 = (function (this$,offset,length){
var self__ = this;
var this$__$1 = this;
return (new Uint8Array(self__.backing.buffer,(offset + self__.backing_offset),length));
}));

(fress.impl.buffer.BufferWriter.prototype.fress$impl$buffer$IBufferWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fress.impl.buffer.BufferWriter.prototype.fress$impl$buffer$IBufferWriter$getFreeCapacity$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return ((self__.backing.buffer.byteLength - self__.backing_offset) - self__.bytesWritten);
}));

(fress.impl.buffer.BufferWriter.prototype.fress$impl$buffer$IBufferWriter$room_QMARK_$arity$2 = (function (this$,length){
var self__ = this;
var this$__$1 = this;
var free = this$__$1.fress$impl$buffer$IBufferWriter$getFreeCapacity$arity$1(null, );
return (length <= free);
}));

(fress.impl.buffer.BufferWriter.prototype.fress$impl$buffer$IBufferWriter$getBytesWritten$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.bytesWritten;
}));

(fress.impl.buffer.BufferWriter.prototype.fress$impl$buffer$IBufferWriter$notifyBytesWritten$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
if(cljs.core.int_QMARK_(n)){
} else {
throw (new Error(["Assert failed: ","written byte count must be an int","\n","(int? n)"].join('')));
}

return (this$__$1.bytesWritten = (n + self__.bytesWritten));
}));

(fress.impl.buffer.BufferWriter.prototype.fress$impl$buffer$IBufferWriter$writeByte$arity$2 = (function (this$,byte$){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(this$__$1.fress$impl$buffer$IBufferWriter$room_QMARK_$arity$2(null, (1)))){
((new Int8Array(self__.backing.buffer))[self__.bytesWritten] = byte$);

this$__$1.fress$impl$buffer$IBufferWriter$notifyBytesWritten$arity$2(null, (1));

return this$__$1;
} else {
throw (new Error("BufferWriter out of room"));
}
}));

(fress.impl.buffer.BufferWriter.prototype.fress$impl$buffer$IBufferWriter$writeBytes$arity$2 = (function (this$,bytes){
var self__ = this;
var this$__$1 = this;
return this$__$1.fress$impl$buffer$IBufferWriter$writeBytes$arity$4(null, bytes,(0),bytes.length);
}));

(fress.impl.buffer.BufferWriter.prototype.fress$impl$buffer$IBufferWriter$writeBytes$arity$4 = (function (this$,bytes,offset,length){
var self__ = this;
var this$__$1 = this;
if(cljs.core.int_QMARK_(length)){
} else {
throw (new Error("Assert failed: (int? length)"));
}

if(cljs.core.truth_(this$__$1.fress$impl$buffer$IBufferWriter$room_QMARK_$arity$2(null, length))){
var i8array = (new Int8Array(self__.backing.buffer));
i8array.set(bytes.subarray(offset,(offset + length)),(self__.bytesWritten + self__.backing_offset));

this$__$1.fress$impl$buffer$IBufferWriter$notifyBytesWritten$arity$2(null, length);

return this$__$1;
} else {
throw (new Error("BufferWriter out of room"));
}
}));

(fress.impl.buffer.BufferWriter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"backing","backing",1346584067,null),cljs.core.with_meta(new cljs.core.Symbol(null,"backing-offset","backing-offset",1811827358,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"number","number",-1084057331,null)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"bytesWritten","bytesWritten",-526151767,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"number","number",-1084057331,null)], null))], null);
}));

(fress.impl.buffer.BufferWriter.cljs$lang$type = true);

(fress.impl.buffer.BufferWriter.cljs$lang$ctorStr = "fress.impl.buffer/BufferWriter");

(fress.impl.buffer.BufferWriter.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"fress.impl.buffer/BufferWriter");
}));

/**
 * Positional factory function for fress.impl.buffer/BufferWriter.
 */
fress.impl.buffer.__GT_BufferWriter = (function fress$impl$buffer$__GT_BufferWriter(backing,backing_offset,bytesWritten){
return (new fress.impl.buffer.BufferWriter(backing,backing_offset,bytesWritten));
});

/**
 * Build a BufferReader over a collection of bytes.
 */
fress.impl.buffer.readable_buffer = (function fress$impl$buffer$readable_buffer(var_args){
var G__26219 = arguments.length;
switch (G__26219) {
case 1:
return fress.impl.buffer.readable_buffer.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fress.impl.buffer.readable_buffer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fress.impl.buffer.readable_buffer.cljs$core$IFn$_invoke$arity$1 = (function (backing){
return fress.impl.buffer.readable_buffer.cljs$core$IFn$_invoke$arity$2(backing,(0));
}));

(fress.impl.buffer.readable_buffer.cljs$core$IFn$_invoke$arity$2 = (function (backing,backing_offset){
if((!((backing.buffer == null)))){
return (new fress.impl.buffer.BufferReader(backing,(function (){var or__5002__auto__ = backing_offset;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return (0);
}
})(),(0)));
} else {
if((backing instanceof ArrayBuffer)){
return fress.impl.buffer.readable_buffer.cljs$core$IFn$_invoke$arity$2((new Uint8Array(backing)),backing_offset);
} else {
if((((!((backing == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === backing.fress$impl$buffer$IBufferReader$))))?true:false):false)){
return backing;
} else {
if(cljs.core.vector_QMARK_(backing)){
return fress.impl.buffer.readable_buffer.cljs$core$IFn$_invoke$arity$2((new Uint8Array(cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(backing))),backing_offset);
} else {
if(cljs.core.array_QMARK_(backing)){
return fress.impl.buffer.readable_buffer.cljs$core$IFn$_invoke$arity$2((new Uint8Array(backing)),backing_offset);
} else {
if((backing instanceof fress.impl.buffer.BytesOutputStream)){
return fress.impl.buffer.readable_buffer.cljs$core$IFn$_invoke$arity$2(backing.fress$impl$buffer$IStreamingWriter$toByteArray$arity$1(null, ),backing_offset);
} else {
if((backing instanceof fress.impl.buffer.BufferWriter)){
return fress.impl.buffer.readable_buffer.cljs$core$IFn$_invoke$arity$2(backing.backing,backing_offset);
} else {
throw (new Error(["invalid input type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(backing))," passed to readable-buffer.\n","Input must be a typed array, array-buffer, or IBufferWriter instance"].join('')));

}
}
}
}
}
}
}
}));

(fress.impl.buffer.readable_buffer.cljs$lang$maxFixedArity = 2);

/**
 * Build a BufferWriter over a typed-array. If nil, returns a BytesOutputStream.
 */
fress.impl.buffer.writable_buffer = (function fress$impl$buffer$writable_buffer(var_args){
var G__26260 = arguments.length;
switch (G__26260) {
case 0:
return fress.impl.buffer.writable_buffer.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fress.impl.buffer.writable_buffer.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fress.impl.buffer.writable_buffer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fress.impl.buffer.writable_buffer.cljs$core$IFn$_invoke$arity$0 = (function (){
return fress.impl.buffer.writable_buffer.cljs$core$IFn$_invoke$arity$2(null,null);
}));

(fress.impl.buffer.writable_buffer.cljs$core$IFn$_invoke$arity$1 = (function (backing){
return fress.impl.buffer.writable_buffer.cljs$core$IFn$_invoke$arity$2(backing,(0));
}));

(fress.impl.buffer.writable_buffer.cljs$core$IFn$_invoke$arity$2 = (function (backing,backing_offset){
if((backing == null)){
return fress.impl.buffer.byte_stream();
} else {
if((((!((backing == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === backing.fress$impl$buffer$IBufferWriter$))))?true:false):false)){
return backing;
} else {
if((backing instanceof ArrayBuffer)){
return fress.impl.buffer.writable_buffer.cljs$core$IFn$_invoke$arity$2((new Int8Array(backing)),backing_offset);
} else {
if((!((backing.buffer == null)))){
return (new fress.impl.buffer.BufferWriter(backing,((function (){var or__5002__auto__ = backing_offset;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return (0);
}
})() | (0)),(0)));
} else {
throw (new Error(["invalid input type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(backing))," passed to writable-buffer.\n","Input must be a typed array, array-buffer, or nil"].join('')));

}
}
}
}
}));

(fress.impl.buffer.writable_buffer.cljs$lang$maxFixedArity = 2);


//# sourceMappingURL=fress.impl.buffer.js.map
