goog.provide('fress.impl.bigint');
fress.impl.bigint.bigint_QMARK_ = (function fress$impl$bigint$bigint_QMARK_(n){
return (BigInt === cljs.core.type(n));
});
fress.impl.bigint.bigint = (function fress$impl$bigint$bigint(n){
return BigInt(n);
});
fress.impl.bigint.abs = (function fress$impl$bigint$abs(bn){
if((bn < (0))){
return (- bn);
} else {
return bn;
}
});
fress.impl.bigint.pow = (function fress$impl$bigint$pow(base,exponent){
return base ** BigInt(exponent);
});
fress.impl.bigint._GT__GT_ = (function fress$impl$bigint$_GT__GT_(a,b){
return a >> BigInt(b);
});
fress.impl.bigint._LT__LT_ = (function fress$impl$bigint$_LT__LT_(a,b){
return a << BigInt(b);
});
/**
 * @return {number} bits not needed to represent this number
 */
fress.impl.bigint.bit_switch = (function fress$impl$bigint$bit_switch(bn){
if(cljs.core.truth_(bn === 0n)){
return (64);
} else {
var bn__$1 = bn;
if((bn__$1 < (0))){
bn__$1 = BigInt(bn__$1) + BigInt(1);

bn__$1 = -bn__$1;
} else {
}

return ((64) - bn__$1.toString((2)).length);
}
});
fress.impl.bigint.flip_bin_string = (function fress$impl$bigint$flip_bin_string(bin){
return bin.split("").map((function (i){
if(("0" === i)){
return "1";
} else {
return "0";
}
})).join("");
});
/**
 * interprets as signed integer, use js/BigInt directly for unsigned
 */
fress.impl.bigint.hex__GT_signed_bigint = (function fress$impl$bigint$hex__GT_signed_bigint(hex){

var hex__$1 = ((cljs.core.mod(hex.length,(2)))?["0",cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex)].join(''):hex);
var high_byte = parseInt(hex__$1.slice((0),(2)),(16));
var bn = BigInt(["0x",cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex__$1)].join(''));
if(((128) & high_byte)){
var bin_25160 = ["0b",fress.impl.bigint.flip_bin_string(bn.toString((2)))].join('');
bn = -( BigInt(bin_25160) + 1n);
} else {
}


return bn;
});
fress.impl.bigint.bytes__GT_bigint = (function fress$impl$bigint$bytes__GT_bigint(bytes){
var hex = [];
var bytes__$1 = Uint8Array.from(bytes);
bytes__$1.forEach((function (i){
var h = i.toString((16));

if(cljs.core.mod(h.length,(2))){
h = '0' + h;
} else {
}


return hex.push(h);
}));

return fress.impl.bigint.hex__GT_signed_bigint(hex.join(""));
});
fress.impl.bigint.bit_not = (function fress$impl$bigint$bit_not(bn){
var bin = (- bn).toString((2));
var _ = (function (){

while(true){
if(cljs.core.mod(bin.length,(8))){
bin = '0' + bin;

continue;
} else {
}
break;
}

})()
;
var prefix = ((((("1" === (bin[(0)]))) && ((!(((-1) === bin.slice((1)).indexOf("1")))))))?"11111111":null);
return (fress.impl.bigint.bigint(["0b",prefix,fress.impl.bigint.flip_bin_string(bin)].join('')) + fress.impl.bigint.bigint((1)));
});
fress.impl.bigint.bigint__GT_hex = (function fress$impl$bigint$bigint__GT_hex(bn){
var bn__$1 = fress.impl.bigint.bigint(bn);
var pos = (((bn__$1 < (0)))?(function (){
bn__$1 = fress.impl.bigint.bit_not(bn__$1);

return false;
})()
:true);
var hex = bn__$1.toString((16));

if(cljs.core.mod(hex.length,(2))){
hex = '0' + hex;
} else {
}

if((function (){var and__5000__auto__ = pos;
if(and__5000__auto__){
return ((128) & parseInt(hex.slice((0),(2)),(16)));
} else {
return and__5000__auto__;
}
})()){
hex = '00' + hex;
} else {
}


return hex;
});
fress.impl.bigint.bigint__GT_bytes = (function fress$impl$bigint$bigint__GT_bytes(bn){

var hex = fress.impl.bigint.bigint__GT_hex(bn);
var _ = ((cljs.core.mod(hex.length,(2)))?hex = '0' + hex:null);
var byte_length = (hex.length / (2));
var bytes = (new Uint8Array(byte_length));
var i_25162 = (0);
var j_25163 = (0);
while(true){
if((i_25162 < byte_length)){
(bytes[i_25162] = parseInt(hex.slice(j_25163,(j_25163 + (2))),(16)));

var G__25164 = (i_25162 + (1));
var G__25165 = (j_25163 + (2));
i_25162 = G__25164;
j_25163 = G__25165;
continue;
} else {
}
break;
}


return bytes;
});

//# sourceMappingURL=fress.impl.bigint.js.map
