goog.provide('fress.api');
fress.api._STAR_write_utf8_tag_STAR_ = false;
fress.api.fressian_reader_QMARK_ = (function fress$api$fressian_reader_QMARK_(in$){
return (in$ instanceof fress.reader.FressianReader);
});
fress.api.fressian_writer_QMARK_ = (function fress$api$fressian_writer_QMARK_(in$){
return (in$ instanceof fress.writer.FressianWriter);
});
/**
 * Create a fressian reader targeting in.
 * - :handlers is just a map of tag->fn merged with default read handlers
 * - :checksum? {boolean} :: maintain a checksum for each byte read, validated
 *   when footer received. throws when fails. If no footer, has no effect
 * - :name->map-ctor map of record names to map->Record constructors at runtime
 *     {'string-name' map->some-record}
 * - cljs allows reading from :offset
 */
fress.api.create_reader = (function fress$api$create_reader(var_args){
var args__5732__auto__ = [];
var len__5726__auto___33810 = arguments.length;
var i__5727__auto___33811 = (0);
while(true){
if((i__5727__auto___33811 < len__5726__auto___33810)){
args__5732__auto__.push((arguments[i__5727__auto___33811]));

var G__33812 = (i__5727__auto___33811 + (1));
i__5727__auto___33811 = G__33812;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return fress.api.create_reader.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(fress.api.create_reader.cljs$core$IFn$_invoke$arity$variadic = (function (in$,opts){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fress.reader.reader,in$,opts);
}));

(fress.api.create_reader.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fress.api.create_reader.cljs$lang$applyTo = (function (seq33728){
var G__33729 = cljs.core.first(seq33728);
var seq33728__$1 = cljs.core.next(seq33728);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33729,seq33728__$1);
}));

/**
 * Read a single object from a fressian reader.
 */
fress.api.read_object = (function fress$api$read_object(rdr){
if(fress.api.fressian_reader_QMARK_(rdr)){
} else {
throw (new Error("Assert failed: (fressian-reader? rdr)"));
}

return fress.reader.readObject(rdr);
});
/**
 * Returns true if o is a tagged object, which will occur when
 * the reader does not recognized a specific type.  Use tag
 * and tagged-value to access the contents of a tagged-object.
 */
fress.api.tagged_object_QMARK_ = (function fress$api$tagged_object_QMARK_(o){
return (o instanceof fress.reader.TaggedObject);
});
/**
 * Returns the tag if object is a tagged-object, else nil.
 */
fress.api.tag = (function fress$api$tag(o){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(o,new cljs.core.Keyword(null,"tag","tag",-1290361223));
});
/**
 * Returns the value (an Object array) wrapped by obj, or nil
 * if obj is not a tagged object.
 */
fress.api.tagged_value = (function fress$api$tagged_value(o){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(o,new cljs.core.Keyword(null,"value","value",305978217));
});
/**
 * Create a fressian writer targeting out.
 *  - :handlers is just a map of {type {'tag' write-fn}} merged with default
 *    write handlers
 *  - :record->name (cljs only) map of record ctor to string-name (the string
 *    version of the record's fully resolved symbol)
 */
fress.api.create_writer = (function fress$api$create_writer(var_args){
var args__5732__auto__ = [];
var len__5726__auto___33813 = arguments.length;
var i__5727__auto___33814 = (0);
while(true){
if((i__5727__auto___33814 < len__5726__auto___33813)){
args__5732__auto__.push((arguments[i__5727__auto___33814]));

var G__33815 = (i__5727__auto___33814 + (1));
i__5727__auto___33814 = G__33815;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return fress.api.create_writer.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(fress.api.create_writer.cljs$core$IFn$_invoke$arity$variadic = (function (out,opts){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fress.writer.writer,out,opts);
}));

(fress.api.create_writer.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fress.api.create_writer.cljs$lang$applyTo = (function (seq33734){
var G__33735 = cljs.core.first(seq33734);
var seq33734__$1 = cljs.core.next(seq33734);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33735,seq33734__$1);
}));

/**
 * Write a single object to a fressian writer.
 */
fress.api.write_object = (function fress$api$write_object(var_args){
var G__33741 = arguments.length;
switch (G__33741) {
case 2:
return fress.api.write_object.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fress.api.write_object.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fress.api.write_object.cljs$core$IFn$_invoke$arity$2 = (function (writer,o){
if(fress.api.fressian_writer_QMARK_(writer)){
} else {
throw (new Error("Assert failed: (fressian-writer? writer)"));
}

return fress.writer.writeObject(writer,o);
}));

(fress.api.write_object.cljs$core$IFn$_invoke$arity$3 = (function (writer,o,cache_QMARK_){
if(fress.api.fressian_writer_QMARK_(writer)){
} else {
throw (new Error("Assert failed: (fressian-writer? writer)"));
}

return fress.writer.writeObject(writer,o,cache_QMARK_);
}));

(fress.api.write_object.cljs$lang$maxFixedArity = 3);

/**
 * write a string as raw utf-8 bytes
 */
fress.api.write_utf8 = (function fress$api$write_utf8(var_args){
var G__33744 = arguments.length;
switch (G__33744) {
case 2:
return fress.api.write_utf8.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fress.api.write_utf8.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fress.api.write_utf8.cljs$core$IFn$_invoke$arity$2 = (function (writer,s){
return fress.api.write_utf8.cljs$core$IFn$_invoke$arity$3(writer,s,false);
}));

(fress.api.write_utf8.cljs$core$IFn$_invoke$arity$3 = (function (writer,s,cache_QMARK_){
if(fress.api.fressian_writer_QMARK_(writer)){
} else {
throw (new Error("Assert failed: (fressian-writer? writer)"));
}

if(typeof s === 'string'){
} else {
throw (new Error("Assert failed: (string? s)"));
}

var _STAR_write_raw_utf8_STAR__orig_val__33750 = fress.writer._STAR_write_raw_utf8_STAR_;
var _STAR_write_utf8_tag_STAR__orig_val__33751 = fress.writer._STAR_write_utf8_tag_STAR_;
var _STAR_write_raw_utf8_STAR__temp_val__33752 = true;
var _STAR_write_utf8_tag_STAR__temp_val__33753 = fress.api._STAR_write_utf8_tag_STAR_;
(fress.writer._STAR_write_raw_utf8_STAR_ = _STAR_write_raw_utf8_STAR__temp_val__33752);

(fress.writer._STAR_write_utf8_tag_STAR_ = _STAR_write_utf8_tag_STAR__temp_val__33753);

try{return fress.api.write_object.cljs$core$IFn$_invoke$arity$3(writer,s,cache_QMARK_);
}finally {(fress.writer._STAR_write_utf8_tag_STAR_ = _STAR_write_utf8_tag_STAR__orig_val__33751);

(fress.writer._STAR_write_raw_utf8_STAR_ = _STAR_write_raw_utf8_STAR__orig_val__33750);
}}));

(fress.api.write_utf8.cljs$lang$maxFixedArity = 3);

/**
 * for use in custom write handlers
 */
fress.api.write_tag = (function fress$api$write_tag(writer,tag,field_count){
if(typeof tag === 'string'){
} else {
throw (new Error("Assert failed: (string? tag)"));
}

if(((typeof field_count === 'number') && (((1) <= field_count)))){
} else {
throw (new Error("Assert failed: (and (number? field-count) (<= 1 field-count))"));
}

return fress.writer.writeTag(writer,tag,field_count);
});
/**
 * use to seal off a writer with a final byte count & checksum for
 * verification by a reader. Induces EOF
 */
fress.api.write_footer = (function fress$api$write_footer(writer){
if(fress.api.fressian_writer_QMARK_(writer)){
} else {
throw (new Error("Assert failed: (fressian-writer? writer)"));
}

return fress.writer.writeFooter(writer);
});
/**
 * write a signal to the reader to forget established cache codes
 */
fress.api.reset_caches = (function fress$api$reset_caches(writer){
if(fress.api.fressian_writer_QMARK_(writer)){
} else {
throw (new Error("Assert failed: (fressian-writer? writer)"));
}

return fress.writer.resetCaches(writer);
});
/**
 * Begin writing a fressianed list.  To end the list, call end-list.
 * Used to write sequential data whose size is not known in advance.
 */
fress.api.begin_closed_list = (function fress$api$begin_closed_list(writer){
if(fress.api.fressian_writer_QMARK_(writer)){
} else {
throw (new Error("Assert failed: (fressian-writer? writer)"));
}

return fress.writer.beginClosedList(writer);
});
/**
 * Ends a list begun with begin-closed-list.
 */
fress.api.end_list = (function fress$api$end_list(writer){
if(fress.api.fressian_writer_QMARK_(writer)){
} else {
throw (new Error("Assert failed: (fressian-writer? writer)"));
}

return fress.writer.endList(writer);
});
/**
 * Writes fressian code to begin an open list.  An
 * open list can be terminated either by a call to end-list,
 * or by simply closing the stream.  Used to write sequential
 * data whose size is not known in advance, in contexts where
 * stream failure can safely be interpreted as end of list.
 */
fress.api.begin_open_list = (function fress$api$begin_open_list(writer){
if(fress.api.fressian_writer_QMARK_(writer)){
} else {
throw (new Error("Assert failed: (fressian-writer? writer)"));
}

return fress.writer.beginOpenList(writer);
});
/**
 * Returns a record writer that caches values for keys
 * matching cache-pred, which is typically specified
 * as a set, e.g. (field-caching-writer #{:color})
 */
fress.api.field_caching_writer = (function fress$api$field_caching_writer(cache_pred){
return (function (w,rec,record__GT_name){
fress.writer.writeTag(w,"record",(2));

fress.writer.writeObject(w,fress.writer.class_sym(rec,record__GT_name),true);

fress.writer.writeTag(w,"map",(1));

fress.writer.beginClosedList(w);

var seq__33765_33828 = cljs.core.seq(rec);
var chunk__33766_33829 = null;
var count__33767_33830 = (0);
var i__33768_33831 = (0);
while(true){
if((i__33768_33831 < count__33767_33830)){
var vec__33776_33832 = chunk__33766_33829.cljs$core$IIndexed$_nth$arity$2(null, i__33768_33831);
var field_33833 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33776_33832,(0),null);
var value_33834 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33776_33832,(1),null);
fress.writer.writeObject(w,field_33833,true);

fress.writer.writeObject(w,value_33834,cljs.core.boolean$((cache_pred.cljs$core$IFn$_invoke$arity$1 ? cache_pred.cljs$core$IFn$_invoke$arity$1(field_33833) : cache_pred.call(null, field_33833))));


var G__33835 = seq__33765_33828;
var G__33836 = chunk__33766_33829;
var G__33837 = count__33767_33830;
var G__33838 = (i__33768_33831 + (1));
seq__33765_33828 = G__33835;
chunk__33766_33829 = G__33836;
count__33767_33830 = G__33837;
i__33768_33831 = G__33838;
continue;
} else {
var temp__5823__auto___33839 = cljs.core.seq(seq__33765_33828);
if(temp__5823__auto___33839){
var seq__33765_33840__$1 = temp__5823__auto___33839;
if(cljs.core.chunked_seq_QMARK_(seq__33765_33840__$1)){
var c__5525__auto___33841 = cljs.core.chunk_first(seq__33765_33840__$1);
var G__33842 = cljs.core.chunk_rest(seq__33765_33840__$1);
var G__33843 = c__5525__auto___33841;
var G__33844 = cljs.core.count(c__5525__auto___33841);
var G__33845 = (0);
seq__33765_33828 = G__33842;
chunk__33766_33829 = G__33843;
count__33767_33830 = G__33844;
i__33768_33831 = G__33845;
continue;
} else {
var vec__33783_33846 = cljs.core.first(seq__33765_33840__$1);
var field_33847 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33783_33846,(0),null);
var value_33848 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33783_33846,(1),null);
fress.writer.writeObject(w,field_33847,true);

fress.writer.writeObject(w,value_33848,cljs.core.boolean$((cache_pred.cljs$core$IFn$_invoke$arity$1 ? cache_pred.cljs$core$IFn$_invoke$arity$1(field_33847) : cache_pred.call(null, field_33847))));


var G__33849 = cljs.core.next(seq__33765_33840__$1);
var G__33850 = null;
var G__33851 = (0);
var G__33852 = (0);
seq__33765_33828 = G__33849;
chunk__33766_33829 = G__33850;
count__33767_33830 = G__33851;
i__33768_33831 = G__33852;
continue;
}
} else {
}
}
break;
}

return fress.writer.endList(w);
});
});
fress.api.byte_stream = (function fress$api$byte_stream(){
return fress.impl.buffer.byte_stream();
});
fress.api.flush_to = (function fress$api$flush_to(var_args){
var G__33787 = arguments.length;
switch (G__33787) {
case 2:
return fress.api.flush_to.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fress.api.flush_to.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fress.api.flush_to.cljs$core$IFn$_invoke$arity$2 = (function (stream,out){
return fress.api.flush_to.cljs$core$IFn$_invoke$arity$3(stream,out,(0));
}));

(fress.api.flush_to.cljs$core$IFn$_invoke$arity$3 = (function (stream,out,offset){
if((stream instanceof fress.impl.buffer.BytesOutputStream)){
} else {
throw (new Error("Assert failed: (instance? buf/BytesOutputStream stream)"));
}

if((!((out.buffer == null)))){
} else {
throw (new Error("Assert failed: (some? (.-buffer out))"));
}

return fress.impl.buffer.flushTo(stream,out,offset);
}));

(fress.api.flush_to.cljs$lang$maxFixedArity = 3);

/**
 * Convenience method for reading a single fressian object.
 * Takes same options as create-reader
 */
fress.api.read = (function fress$api$read(var_args){
var args__5732__auto__ = [];
var len__5726__auto___33854 = arguments.length;
var i__5727__auto___33855 = (0);
while(true){
if((i__5727__auto___33855 < len__5726__auto___33854)){
args__5732__auto__.push((arguments[i__5727__auto___33855]));

var G__33856 = (i__5727__auto___33855 + (1));
i__5727__auto___33855 = G__33856;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return fress.api.read.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(fress.api.read.cljs$core$IFn$_invoke$arity$variadic = (function (readable,options){
return fress.reader.readObject(cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fress.api.create_reader,readable,options));
}));

(fress.api.read.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fress.api.read.cljs$lang$applyTo = (function (seq33792){
var G__33793 = cljs.core.first(seq33792);
var seq33792__$1 = cljs.core.next(seq33792);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33793,seq33792__$1);
}));

/**
 * Read a fressian reader fully (until eof), returning a (possibly empty)
 * vector of results.
 */
fress.api.read_batch = (function fress$api$read_batch(fin){
if(fress.api.fressian_reader_QMARK_(fin)){
} else {
throw (new Error("Assert failed: (fressian-reader? fin)"));
}

var sentinel = ({});
var objects = cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
while(true){
var obj = (function (){try{return fress.reader.readObject(fin);
}catch (e33794){if((e33794 instanceof Error)){
var e = e33794;
return sentinel;
} else {
throw e33794;

}
}})();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(obj,sentinel)){
return cljs.core.persistent_BANG_(objects);
} else {
var G__33858 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(objects,obj);
objects = G__33858;
continue;
}
break;
}
});
/**
 * like read-batch but accepts readables in addition to FressianReaders
 */
fress.api.read_all = (function fress$api$read_all(var_args){
var args__5732__auto__ = [];
var len__5726__auto___33859 = arguments.length;
var i__5727__auto___33860 = (0);
while(true){
if((i__5727__auto___33860 < len__5726__auto___33859)){
args__5732__auto__.push((arguments[i__5727__auto___33860]));

var G__33861 = (i__5727__auto___33860 + (1));
i__5727__auto___33860 = G__33861;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return fress.api.read_all.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(fress.api.read_all.cljs$core$IFn$_invoke$arity$variadic = (function (in$,options){
if(fress.api.fressian_reader_QMARK_(in$)){
return fress.api.read_batch(in$);
} else {
return fress.api.read_batch(cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fress.api.create_reader,in$,options));
}
}));

(fress.api.read_all.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fress.api.read_all.cljs$lang$applyTo = (function (seq33796){
var G__33797 = cljs.core.first(seq33796);
var seq33796__$1 = cljs.core.next(seq33796);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33797,seq33796__$1);
}));

/**
 * Convenience method for writing a single object.  Returns a
 * byte buffer.  Options are the same as for create-reader,
 * with one additional option :footer? {bool}, if specified will
 * write a fressian footer after writing the object.
 */
fress.api.write = (function fress$api$write(var_args){
var args__5732__auto__ = [];
var len__5726__auto___33862 = arguments.length;
var i__5727__auto___33863 = (0);
while(true){
if((i__5727__auto___33863 < len__5726__auto___33862)){
args__5732__auto__.push((arguments[i__5727__auto___33863]));

var G__33864 = (i__5727__auto___33863 + (1));
i__5727__auto___33863 = G__33864;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return fress.api.write.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(fress.api.write.cljs$core$IFn$_invoke$arity$variadic = (function (obj,options){
var map__33803 = (cljs.core.truth_(options)?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,options):null);
var map__33803__$1 = cljs.core.__destructure_map(map__33803);
var footer_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33803__$1,new cljs.core.Keyword(null,"footer?","footer?",-986176238));
var bos = fress.impl.buffer.byte_stream();
var writer = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fress.api.create_writer,bos,options);
fress.writer.writeObject(writer,obj);

if(cljs.core.truth_(footer_QMARK_)){
fress.writer.writeFooter(writer);
} else {
}

return cljs.core.deref(bos);
}));

(fress.api.write.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fress.api.write.cljs$lang$applyTo = (function (seq33801){
var G__33802 = cljs.core.first(seq33801);
var seq33801__$1 = cljs.core.next(seq33801);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33802,seq33801__$1);
}));


//# sourceMappingURL=fress.api.js.map
