goog.provide('cljs.core.async');
goog.scope(function(){
  cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25388 = (function (f,blockable,meta25389){
this.f = f;
this.blockable = blockable;
this.meta25389 = meta25389;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async25388.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25390,meta25389__$1){
var self__ = this;
var _25390__$1 = this;
return (new cljs.core.async.t_cljs$core$async25388(self__.f,self__.blockable,meta25389__$1));
}));

(cljs.core.async.t_cljs$core$async25388.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25390){
var self__ = this;
var _25390__$1 = this;
return self__.meta25389;
}));

(cljs.core.async.t_cljs$core$async25388.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async25388.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async25388.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async25388.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async25388.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta25389","meta25389",-814533371,null)], null);
}));

(cljs.core.async.t_cljs$core$async25388.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async25388.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25388");

(cljs.core.async.t_cljs$core$async25388.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async25388");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async25388.
 */
cljs.core.async.__GT_t_cljs$core$async25388 = (function cljs$core$async$__GT_t_cljs$core$async25388(f,blockable,meta25389){
return (new cljs.core.async.t_cljs$core$async25388(f,blockable,meta25389));
});


cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__25387 = arguments.length;
switch (G__25387) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
return (new cljs.core.async.t_cljs$core$async25388(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__25423 = arguments.length;
switch (G__25423) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__25447 = arguments.length;
switch (G__25447) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__25468 = arguments.length;
switch (G__25468) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_28314 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_28314) : fn1.call(null, val_28314));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_28314) : fn1.call(null, val_28314));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__25546 = arguments.length;
switch (G__25546) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5821__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5821__auto__)){
var ret = temp__5821__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5821__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5821__auto__)){
var retb = temp__5821__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null, ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null, ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5593__auto___28318 = n;
var x_28319 = (0);
while(true){
if((x_28319 < n__5593__auto___28318)){
(a[x_28319] = x_28319);

var G__28320 = (x_28319 + (1));
x_28319 = G__28320;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle(a);

return a;
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25596 = (function (flag,meta25597){
this.flag = flag;
this.meta25597 = meta25597;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async25596.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25598,meta25597__$1){
var self__ = this;
var _25598__$1 = this;
return (new cljs.core.async.t_cljs$core$async25596(self__.flag,meta25597__$1));
}));

(cljs.core.async.t_cljs$core$async25596.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25598){
var self__ = this;
var _25598__$1 = this;
return self__.meta25597;
}));

(cljs.core.async.t_cljs$core$async25596.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async25596.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async25596.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async25596.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async25596.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta25597","meta25597",976837496,null)], null);
}));

(cljs.core.async.t_cljs$core$async25596.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async25596.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25596");

(cljs.core.async.t_cljs$core$async25596.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async25596");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async25596.
 */
cljs.core.async.__GT_t_cljs$core$async25596 = (function cljs$core$async$__GT_t_cljs$core$async25596(flag,meta25597){
return (new cljs.core.async.t_cljs$core$async25596(flag,meta25597));
});


cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
return (new cljs.core.async.t_cljs$core$async25596(flag,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25617 = (function (flag,cb,meta25618){
this.flag = flag;
this.cb = cb;
this.meta25618 = meta25618;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async25617.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25619,meta25618__$1){
var self__ = this;
var _25619__$1 = this;
return (new cljs.core.async.t_cljs$core$async25617(self__.flag,self__.cb,meta25618__$1));
}));

(cljs.core.async.t_cljs$core$async25617.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25619){
var self__ = this;
var _25619__$1 = this;
return self__.meta25618;
}));

(cljs.core.async.t_cljs$core$async25617.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async25617.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async25617.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async25617.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async25617.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta25618","meta25618",-49197319,null)], null);
}));

(cljs.core.async.t_cljs$core$async25617.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async25617.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25617");

(cljs.core.async.t_cljs$core$async25617.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async25617");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async25617.
 */
cljs.core.async.__GT_t_cljs$core$async25617 = (function cljs$core$async$__GT_t_cljs$core$async25617(flag,cb,meta25618){
return (new cljs.core.async.t_cljs$core$async25617(flag,cb,meta25618));
});


cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
return (new cljs.core.async.t_cljs$core$async25617(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var ports__$1 = cljs.core.vec(ports);
var n = cljs.core.count(ports__$1);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports__$1,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null, (0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null, (1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,ports__$1,n,idxs,priority){
return (function (p1__25633_SHARP_){
var G__25647 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__25633_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__25647) : fret.call(null, G__25647));
});})(i,val,idx,port,wport,flag,ports__$1,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,ports__$1,n,idxs,priority){
return (function (p1__25635_SHARP_){
var G__25662 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__25635_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__25662) : fret.call(null, G__25662));
});})(i,idx,port,wport,flag,ports__$1,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__5002__auto__ = wport;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return port;
}
})()], null));
} else {
var G__28323 = (i + (1));
i = G__28323;
continue;
}
} else {
return null;
}
break;
}
})();
var or__5002__auto__ = ret;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5823__auto__ = (function (){var and__5000__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null, );
if(cljs.core.truth_(and__5000__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null, );
} else {
return and__5000__auto__;
}
})();
if(cljs.core.truth_(temp__5823__auto__)){
var got = temp__5823__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5732__auto__ = [];
var len__5726__auto___28324 = arguments.length;
var i__5727__auto___28325 = (0);
while(true){
if((i__5727__auto___28325 < len__5726__auto___28324)){
args__5732__auto__.push((arguments[i__5727__auto___28325]));

var G__28326 = (i__5727__auto___28325 + (1));
i__5727__auto___28325 = G__28326;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__25688){
var map__25700 = p__25688;
var map__25700__$1 = cljs.core.__destructure_map(map__25700);
var opts = map__25700__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq25672){
var G__25673 = cljs.core.first(seq25672);
var seq25672__$1 = cljs.core.next(seq25672);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__25673,seq25672__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__25754 = arguments.length;
switch (G__25754) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__25169__auto___28330 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25170__auto__ = (function (){var switch__24798__auto__ = (function (state_25814){
var state_val_25815 = (state_25814[(1)]);
if((state_val_25815 === (7))){
var inst_25809 = (state_25814[(2)]);
var state_25814__$1 = state_25814;
var statearr_25822_28331 = state_25814__$1;
(statearr_25822_28331[(2)] = inst_25809);

(statearr_25822_28331[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (1))){
var state_25814__$1 = state_25814;
var statearr_25823_28332 = state_25814__$1;
(statearr_25823_28332[(2)] = null);

(statearr_25823_28332[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (4))){
var inst_25781 = (state_25814[(7)]);
var inst_25781__$1 = (state_25814[(2)]);
var inst_25793 = (inst_25781__$1 == null);
var state_25814__$1 = (function (){var statearr_25824 = state_25814;
(statearr_25824[(7)] = inst_25781__$1);

return statearr_25824;
})();
if(cljs.core.truth_(inst_25793)){
var statearr_25825_28333 = state_25814__$1;
(statearr_25825_28333[(1)] = (5));

} else {
var statearr_25826_28334 = state_25814__$1;
(statearr_25826_28334[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (13))){
var state_25814__$1 = state_25814;
var statearr_25827_28335 = state_25814__$1;
(statearr_25827_28335[(2)] = null);

(statearr_25827_28335[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (6))){
var inst_25781 = (state_25814[(7)]);
var state_25814__$1 = state_25814;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_25814__$1,(11),to,inst_25781);
} else {
if((state_val_25815 === (3))){
var inst_25812 = (state_25814[(2)]);
var state_25814__$1 = state_25814;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25814__$1,inst_25812);
} else {
if((state_val_25815 === (12))){
var state_25814__$1 = state_25814;
var statearr_25828_28337 = state_25814__$1;
(statearr_25828_28337[(2)] = null);

(statearr_25828_28337[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (2))){
var state_25814__$1 = state_25814;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25814__$1,(4),from);
} else {
if((state_val_25815 === (11))){
var inst_25802 = (state_25814[(2)]);
var state_25814__$1 = state_25814;
if(cljs.core.truth_(inst_25802)){
var statearr_25829_28338 = state_25814__$1;
(statearr_25829_28338[(1)] = (12));

} else {
var statearr_25830_28339 = state_25814__$1;
(statearr_25830_28339[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (9))){
var state_25814__$1 = state_25814;
var statearr_25831_28340 = state_25814__$1;
(statearr_25831_28340[(2)] = null);

(statearr_25831_28340[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (5))){
var state_25814__$1 = state_25814;
if(cljs.core.truth_(close_QMARK_)){
var statearr_25832_28341 = state_25814__$1;
(statearr_25832_28341[(1)] = (8));

} else {
var statearr_25833_28342 = state_25814__$1;
(statearr_25833_28342[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (14))){
var inst_25807 = (state_25814[(2)]);
var state_25814__$1 = state_25814;
var statearr_25834_28343 = state_25814__$1;
(statearr_25834_28343[(2)] = inst_25807);

(statearr_25834_28343[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (10))){
var inst_25799 = (state_25814[(2)]);
var state_25814__$1 = state_25814;
var statearr_25835_28344 = state_25814__$1;
(statearr_25835_28344[(2)] = inst_25799);

(statearr_25835_28344[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (8))){
var inst_25796 = cljs.core.async.close_BANG_(to);
var state_25814__$1 = state_25814;
var statearr_25836_28345 = state_25814__$1;
(statearr_25836_28345[(2)] = inst_25796);

(statearr_25836_28345[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__24799__auto__ = null;
var cljs$core$async$state_machine__24799__auto____0 = (function (){
var statearr_25837 = [null,null,null,null,null,null,null,null];
(statearr_25837[(0)] = cljs$core$async$state_machine__24799__auto__);

(statearr_25837[(1)] = (1));

return statearr_25837;
});
var cljs$core$async$state_machine__24799__auto____1 = (function (state_25814){
while(true){
var ret_value__24800__auto__ = (function (){try{while(true){
var result__24801__auto__ = switch__24798__auto__(state_25814);
if(cljs.core.keyword_identical_QMARK_(result__24801__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24801__auto__;
}
break;
}
}catch (e25838){var ex__24802__auto__ = e25838;
var statearr_25839_28346 = state_25814;
(statearr_25839_28346[(2)] = ex__24802__auto__);


if(cljs.core.seq((state_25814[(4)]))){
var statearr_25844_28347 = state_25814;
(statearr_25844_28347[(1)] = cljs.core.first((state_25814[(4)])));

} else {
throw ex__24802__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28348 = state_25814;
state_25814 = G__28348;
continue;
} else {
return ret_value__24800__auto__;
}
break;
}
});
cljs$core$async$state_machine__24799__auto__ = function(state_25814){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24799__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24799__auto____1.call(this,state_25814);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24799__auto____0;
cljs$core$async$state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24799__auto____1;
return cljs$core$async$state_machine__24799__auto__;
})()
})();
var state__25171__auto__ = (function (){var statearr_25846 = f__25170__auto__();
(statearr_25846[(6)] = c__25169__auto___28330);

return statearr_25846;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25171__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process__$1 = (function (p__25852){
var vec__25853 = p__25852;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25853,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25853,(1),null);
var job = vec__25853;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__25169__auto___28349 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25170__auto__ = (function (){var switch__24798__auto__ = (function (state_25861){
var state_val_25862 = (state_25861[(1)]);
if((state_val_25862 === (1))){
var state_25861__$1 = state_25861;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_25861__$1,(2),res,v);
} else {
if((state_val_25862 === (2))){
var inst_25858 = (state_25861[(2)]);
var inst_25859 = cljs.core.async.close_BANG_(res);
var state_25861__$1 = (function (){var statearr_25865 = state_25861;
(statearr_25865[(7)] = inst_25858);

return statearr_25865;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_25861__$1,inst_25859);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__24799__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__24799__auto____0 = (function (){
var statearr_25870 = [null,null,null,null,null,null,null,null];
(statearr_25870[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__24799__auto__);

(statearr_25870[(1)] = (1));

return statearr_25870;
});
var cljs$core$async$pipeline_STAR__$_state_machine__24799__auto____1 = (function (state_25861){
while(true){
var ret_value__24800__auto__ = (function (){try{while(true){
var result__24801__auto__ = switch__24798__auto__(state_25861);
if(cljs.core.keyword_identical_QMARK_(result__24801__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24801__auto__;
}
break;
}
}catch (e25871){var ex__24802__auto__ = e25871;
var statearr_25872_28350 = state_25861;
(statearr_25872_28350[(2)] = ex__24802__auto__);


if(cljs.core.seq((state_25861[(4)]))){
var statearr_25873_28351 = state_25861;
(statearr_25873_28351[(1)] = cljs.core.first((state_25861[(4)])));

} else {
throw ex__24802__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28352 = state_25861;
state_25861 = G__28352;
continue;
} else {
return ret_value__24800__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__24799__auto__ = function(state_25861){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__24799__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__24799__auto____1.call(this,state_25861);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__24799__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__24799__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__24799__auto__;
})()
})();
var state__25171__auto__ = (function (){var statearr_25876 = f__25170__auto__();
(statearr_25876[(6)] = c__25169__auto___28349);

return statearr_25876;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25171__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__25882){
var vec__25883 = p__25882;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25883,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25883,(1),null);
var job = vec__25883;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null, v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__5593__auto___28354 = n;
var __28355 = (0);
while(true){
if((__28355 < n__5593__auto___28354)){
var G__25895_28356 = type;
var G__25895_28357__$1 = (((G__25895_28356 instanceof cljs.core.Keyword))?G__25895_28356.fqn:null);
switch (G__25895_28357__$1) {
case "compute":
var c__25169__auto___28359 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__28355,c__25169__auto___28359,G__25895_28356,G__25895_28357__$1,n__5593__auto___28354,jobs,results,process__$1,async){
return (function (){
var f__25170__auto__ = (function (){var switch__24798__auto__ = ((function (__28355,c__25169__auto___28359,G__25895_28356,G__25895_28357__$1,n__5593__auto___28354,jobs,results,process__$1,async){
return (function (state_25908){
var state_val_25909 = (state_25908[(1)]);
if((state_val_25909 === (1))){
var state_25908__$1 = state_25908;
var statearr_25910_28363 = state_25908__$1;
(statearr_25910_28363[(2)] = null);

(statearr_25910_28363[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25909 === (2))){
var state_25908__$1 = state_25908;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25908__$1,(4),jobs);
} else {
if((state_val_25909 === (3))){
var inst_25906 = (state_25908[(2)]);
var state_25908__$1 = state_25908;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25908__$1,inst_25906);
} else {
if((state_val_25909 === (4))){
var inst_25898 = (state_25908[(2)]);
var inst_25899 = process__$1(inst_25898);
var state_25908__$1 = state_25908;
if(cljs.core.truth_(inst_25899)){
var statearr_25914_28364 = state_25908__$1;
(statearr_25914_28364[(1)] = (5));

} else {
var statearr_25915_28365 = state_25908__$1;
(statearr_25915_28365[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25909 === (5))){
var state_25908__$1 = state_25908;
var statearr_25916_28366 = state_25908__$1;
(statearr_25916_28366[(2)] = null);

(statearr_25916_28366[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25909 === (6))){
var state_25908__$1 = state_25908;
var statearr_25917_28367 = state_25908__$1;
(statearr_25917_28367[(2)] = null);

(statearr_25917_28367[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25909 === (7))){
var inst_25904 = (state_25908[(2)]);
var state_25908__$1 = state_25908;
var statearr_25918_28368 = state_25908__$1;
(statearr_25918_28368[(2)] = inst_25904);

(statearr_25918_28368[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__28355,c__25169__auto___28359,G__25895_28356,G__25895_28357__$1,n__5593__auto___28354,jobs,results,process__$1,async))
;
return ((function (__28355,switch__24798__auto__,c__25169__auto___28359,G__25895_28356,G__25895_28357__$1,n__5593__auto___28354,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__24799__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__24799__auto____0 = (function (){
var statearr_25919 = [null,null,null,null,null,null,null];
(statearr_25919[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__24799__auto__);

(statearr_25919[(1)] = (1));

return statearr_25919;
});
var cljs$core$async$pipeline_STAR__$_state_machine__24799__auto____1 = (function (state_25908){
while(true){
var ret_value__24800__auto__ = (function (){try{while(true){
var result__24801__auto__ = switch__24798__auto__(state_25908);
if(cljs.core.keyword_identical_QMARK_(result__24801__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24801__auto__;
}
break;
}
}catch (e25922){var ex__24802__auto__ = e25922;
var statearr_25923_28369 = state_25908;
(statearr_25923_28369[(2)] = ex__24802__auto__);


if(cljs.core.seq((state_25908[(4)]))){
var statearr_25924_28370 = state_25908;
(statearr_25924_28370[(1)] = cljs.core.first((state_25908[(4)])));

} else {
throw ex__24802__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28371 = state_25908;
state_25908 = G__28371;
continue;
} else {
return ret_value__24800__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__24799__auto__ = function(state_25908){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__24799__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__24799__auto____1.call(this,state_25908);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__24799__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__24799__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__24799__auto__;
})()
;})(__28355,switch__24798__auto__,c__25169__auto___28359,G__25895_28356,G__25895_28357__$1,n__5593__auto___28354,jobs,results,process__$1,async))
})();
var state__25171__auto__ = (function (){var statearr_25925 = f__25170__auto__();
(statearr_25925[(6)] = c__25169__auto___28359);

return statearr_25925;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25171__auto__);
});})(__28355,c__25169__auto___28359,G__25895_28356,G__25895_28357__$1,n__5593__auto___28354,jobs,results,process__$1,async))
);


break;
case "async":
var c__25169__auto___28372 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__28355,c__25169__auto___28372,G__25895_28356,G__25895_28357__$1,n__5593__auto___28354,jobs,results,process__$1,async){
return (function (){
var f__25170__auto__ = (function (){var switch__24798__auto__ = ((function (__28355,c__25169__auto___28372,G__25895_28356,G__25895_28357__$1,n__5593__auto___28354,jobs,results,process__$1,async){
return (function (state_25938){
var state_val_25939 = (state_25938[(1)]);
if((state_val_25939 === (1))){
var state_25938__$1 = state_25938;
var statearr_25940_28373 = state_25938__$1;
(statearr_25940_28373[(2)] = null);

(statearr_25940_28373[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25939 === (2))){
var state_25938__$1 = state_25938;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25938__$1,(4),jobs);
} else {
if((state_val_25939 === (3))){
var inst_25936 = (state_25938[(2)]);
var state_25938__$1 = state_25938;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25938__$1,inst_25936);
} else {
if((state_val_25939 === (4))){
var inst_25928 = (state_25938[(2)]);
var inst_25929 = async(inst_25928);
var state_25938__$1 = state_25938;
if(cljs.core.truth_(inst_25929)){
var statearr_25941_28374 = state_25938__$1;
(statearr_25941_28374[(1)] = (5));

} else {
var statearr_25942_28375 = state_25938__$1;
(statearr_25942_28375[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25939 === (5))){
var state_25938__$1 = state_25938;
var statearr_25943_28376 = state_25938__$1;
(statearr_25943_28376[(2)] = null);

(statearr_25943_28376[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25939 === (6))){
var state_25938__$1 = state_25938;
var statearr_25944_28377 = state_25938__$1;
(statearr_25944_28377[(2)] = null);

(statearr_25944_28377[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25939 === (7))){
var inst_25934 = (state_25938[(2)]);
var state_25938__$1 = state_25938;
var statearr_25947_28378 = state_25938__$1;
(statearr_25947_28378[(2)] = inst_25934);

(statearr_25947_28378[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__28355,c__25169__auto___28372,G__25895_28356,G__25895_28357__$1,n__5593__auto___28354,jobs,results,process__$1,async))
;
return ((function (__28355,switch__24798__auto__,c__25169__auto___28372,G__25895_28356,G__25895_28357__$1,n__5593__auto___28354,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__24799__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__24799__auto____0 = (function (){
var statearr_25948 = [null,null,null,null,null,null,null];
(statearr_25948[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__24799__auto__);

(statearr_25948[(1)] = (1));

return statearr_25948;
});
var cljs$core$async$pipeline_STAR__$_state_machine__24799__auto____1 = (function (state_25938){
while(true){
var ret_value__24800__auto__ = (function (){try{while(true){
var result__24801__auto__ = switch__24798__auto__(state_25938);
if(cljs.core.keyword_identical_QMARK_(result__24801__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24801__auto__;
}
break;
}
}catch (e25949){var ex__24802__auto__ = e25949;
var statearr_25950_28379 = state_25938;
(statearr_25950_28379[(2)] = ex__24802__auto__);


if(cljs.core.seq((state_25938[(4)]))){
var statearr_25951_28380 = state_25938;
(statearr_25951_28380[(1)] = cljs.core.first((state_25938[(4)])));

} else {
throw ex__24802__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28381 = state_25938;
state_25938 = G__28381;
continue;
} else {
return ret_value__24800__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__24799__auto__ = function(state_25938){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__24799__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__24799__auto____1.call(this,state_25938);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__24799__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__24799__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__24799__auto__;
})()
;})(__28355,switch__24798__auto__,c__25169__auto___28372,G__25895_28356,G__25895_28357__$1,n__5593__auto___28354,jobs,results,process__$1,async))
})();
var state__25171__auto__ = (function (){var statearr_25952 = f__25170__auto__();
(statearr_25952[(6)] = c__25169__auto___28372);

return statearr_25952;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25171__auto__);
});})(__28355,c__25169__auto___28372,G__25895_28356,G__25895_28357__$1,n__5593__auto___28354,jobs,results,process__$1,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__25895_28357__$1)].join('')));

}

var G__28383 = (__28355 + (1));
__28355 = G__28383;
continue;
} else {
}
break;
}

var c__25169__auto___28384 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25170__auto__ = (function (){var switch__24798__auto__ = (function (state_25976){
var state_val_25977 = (state_25976[(1)]);
if((state_val_25977 === (7))){
var inst_25970 = (state_25976[(2)]);
var state_25976__$1 = state_25976;
var statearr_25979_28385 = state_25976__$1;
(statearr_25979_28385[(2)] = inst_25970);

(statearr_25979_28385[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25977 === (1))){
var state_25976__$1 = state_25976;
var statearr_25980_28386 = state_25976__$1;
(statearr_25980_28386[(2)] = null);

(statearr_25980_28386[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25977 === (4))){
var inst_25955 = (state_25976[(7)]);
var inst_25955__$1 = (state_25976[(2)]);
var inst_25956 = (inst_25955__$1 == null);
var state_25976__$1 = (function (){var statearr_25981 = state_25976;
(statearr_25981[(7)] = inst_25955__$1);

return statearr_25981;
})();
if(cljs.core.truth_(inst_25956)){
var statearr_25982_28387 = state_25976__$1;
(statearr_25982_28387[(1)] = (5));

} else {
var statearr_25983_28388 = state_25976__$1;
(statearr_25983_28388[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25977 === (6))){
var inst_25955 = (state_25976[(7)]);
var inst_25960 = (state_25976[(8)]);
var inst_25960__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_25961 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25962 = [inst_25955,inst_25960__$1];
var inst_25963 = (new cljs.core.PersistentVector(null,2,(5),inst_25961,inst_25962,null));
var state_25976__$1 = (function (){var statearr_25984 = state_25976;
(statearr_25984[(8)] = inst_25960__$1);

return statearr_25984;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_25976__$1,(8),jobs,inst_25963);
} else {
if((state_val_25977 === (3))){
var inst_25972 = (state_25976[(2)]);
var state_25976__$1 = state_25976;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25976__$1,inst_25972);
} else {
if((state_val_25977 === (2))){
var state_25976__$1 = state_25976;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25976__$1,(4),from);
} else {
if((state_val_25977 === (9))){
var inst_25967 = (state_25976[(2)]);
var state_25976__$1 = (function (){var statearr_25985 = state_25976;
(statearr_25985[(9)] = inst_25967);

return statearr_25985;
})();
var statearr_25986_28389 = state_25976__$1;
(statearr_25986_28389[(2)] = null);

(statearr_25986_28389[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25977 === (5))){
var inst_25958 = cljs.core.async.close_BANG_(jobs);
var state_25976__$1 = state_25976;
var statearr_25987_28390 = state_25976__$1;
(statearr_25987_28390[(2)] = inst_25958);

(statearr_25987_28390[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25977 === (8))){
var inst_25960 = (state_25976[(8)]);
var inst_25965 = (state_25976[(2)]);
var state_25976__$1 = (function (){var statearr_25988 = state_25976;
(statearr_25988[(10)] = inst_25965);

return statearr_25988;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_25976__$1,(9),results,inst_25960);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__24799__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__24799__auto____0 = (function (){
var statearr_25989 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_25989[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__24799__auto__);

(statearr_25989[(1)] = (1));

return statearr_25989;
});
var cljs$core$async$pipeline_STAR__$_state_machine__24799__auto____1 = (function (state_25976){
while(true){
var ret_value__24800__auto__ = (function (){try{while(true){
var result__24801__auto__ = switch__24798__auto__(state_25976);
if(cljs.core.keyword_identical_QMARK_(result__24801__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24801__auto__;
}
break;
}
}catch (e25990){var ex__24802__auto__ = e25990;
var statearr_25991_28391 = state_25976;
(statearr_25991_28391[(2)] = ex__24802__auto__);


if(cljs.core.seq((state_25976[(4)]))){
var statearr_25992_28392 = state_25976;
(statearr_25992_28392[(1)] = cljs.core.first((state_25976[(4)])));

} else {
throw ex__24802__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28393 = state_25976;
state_25976 = G__28393;
continue;
} else {
return ret_value__24800__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__24799__auto__ = function(state_25976){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__24799__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__24799__auto____1.call(this,state_25976);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__24799__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__24799__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__24799__auto__;
})()
})();
var state__25171__auto__ = (function (){var statearr_25993 = f__25170__auto__();
(statearr_25993[(6)] = c__25169__auto___28384);

return statearr_25993;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25171__auto__);
}));


var c__25169__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25170__auto__ = (function (){var switch__24798__auto__ = (function (state_26031){
var state_val_26032 = (state_26031[(1)]);
if((state_val_26032 === (7))){
var inst_26027 = (state_26031[(2)]);
var state_26031__$1 = state_26031;
var statearr_26033_28394 = state_26031__$1;
(statearr_26033_28394[(2)] = inst_26027);

(statearr_26033_28394[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26032 === (20))){
var state_26031__$1 = state_26031;
var statearr_26034_28395 = state_26031__$1;
(statearr_26034_28395[(2)] = null);

(statearr_26034_28395[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26032 === (1))){
var state_26031__$1 = state_26031;
var statearr_26035_28396 = state_26031__$1;
(statearr_26035_28396[(2)] = null);

(statearr_26035_28396[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26032 === (4))){
var inst_25996 = (state_26031[(7)]);
var inst_25996__$1 = (state_26031[(2)]);
var inst_25997 = (inst_25996__$1 == null);
var state_26031__$1 = (function (){var statearr_26036 = state_26031;
(statearr_26036[(7)] = inst_25996__$1);

return statearr_26036;
})();
if(cljs.core.truth_(inst_25997)){
var statearr_26037_28399 = state_26031__$1;
(statearr_26037_28399[(1)] = (5));

} else {
var statearr_26038_28400 = state_26031__$1;
(statearr_26038_28400[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26032 === (15))){
var inst_26009 = (state_26031[(8)]);
var state_26031__$1 = state_26031;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_26031__$1,(18),to,inst_26009);
} else {
if((state_val_26032 === (21))){
var inst_26022 = (state_26031[(2)]);
var state_26031__$1 = state_26031;
var statearr_26039_28401 = state_26031__$1;
(statearr_26039_28401[(2)] = inst_26022);

(statearr_26039_28401[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26032 === (13))){
var inst_26024 = (state_26031[(2)]);
var state_26031__$1 = (function (){var statearr_26041 = state_26031;
(statearr_26041[(9)] = inst_26024);

return statearr_26041;
})();
var statearr_26042_28402 = state_26031__$1;
(statearr_26042_28402[(2)] = null);

(statearr_26042_28402[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26032 === (6))){
var inst_25996 = (state_26031[(7)]);
var state_26031__$1 = state_26031;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26031__$1,(11),inst_25996);
} else {
if((state_val_26032 === (17))){
var inst_26017 = (state_26031[(2)]);
var state_26031__$1 = state_26031;
if(cljs.core.truth_(inst_26017)){
var statearr_26051_28404 = state_26031__$1;
(statearr_26051_28404[(1)] = (19));

} else {
var statearr_26052_28405 = state_26031__$1;
(statearr_26052_28405[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26032 === (3))){
var inst_26029 = (state_26031[(2)]);
var state_26031__$1 = state_26031;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26031__$1,inst_26029);
} else {
if((state_val_26032 === (12))){
var inst_26006 = (state_26031[(10)]);
var state_26031__$1 = state_26031;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26031__$1,(14),inst_26006);
} else {
if((state_val_26032 === (2))){
var state_26031__$1 = state_26031;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26031__$1,(4),results);
} else {
if((state_val_26032 === (19))){
var state_26031__$1 = state_26031;
var statearr_26053_28406 = state_26031__$1;
(statearr_26053_28406[(2)] = null);

(statearr_26053_28406[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26032 === (11))){
var inst_26006 = (state_26031[(2)]);
var state_26031__$1 = (function (){var statearr_26054 = state_26031;
(statearr_26054[(10)] = inst_26006);

return statearr_26054;
})();
var statearr_26055_28407 = state_26031__$1;
(statearr_26055_28407[(2)] = null);

(statearr_26055_28407[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26032 === (9))){
var state_26031__$1 = state_26031;
var statearr_26056_28408 = state_26031__$1;
(statearr_26056_28408[(2)] = null);

(statearr_26056_28408[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26032 === (5))){
var state_26031__$1 = state_26031;
if(cljs.core.truth_(close_QMARK_)){
var statearr_26057_28409 = state_26031__$1;
(statearr_26057_28409[(1)] = (8));

} else {
var statearr_26058_28410 = state_26031__$1;
(statearr_26058_28410[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26032 === (14))){
var inst_26009 = (state_26031[(8)]);
var inst_26011 = (state_26031[(11)]);
var inst_26009__$1 = (state_26031[(2)]);
var inst_26010 = (inst_26009__$1 == null);
var inst_26011__$1 = cljs.core.not(inst_26010);
var state_26031__$1 = (function (){var statearr_26059 = state_26031;
(statearr_26059[(8)] = inst_26009__$1);

(statearr_26059[(11)] = inst_26011__$1);

return statearr_26059;
})();
if(inst_26011__$1){
var statearr_26060_28411 = state_26031__$1;
(statearr_26060_28411[(1)] = (15));

} else {
var statearr_26061_28412 = state_26031__$1;
(statearr_26061_28412[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26032 === (16))){
var inst_26011 = (state_26031[(11)]);
var state_26031__$1 = state_26031;
var statearr_26062_28413 = state_26031__$1;
(statearr_26062_28413[(2)] = inst_26011);

(statearr_26062_28413[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26032 === (10))){
var inst_26003 = (state_26031[(2)]);
var state_26031__$1 = state_26031;
var statearr_26063_28414 = state_26031__$1;
(statearr_26063_28414[(2)] = inst_26003);

(statearr_26063_28414[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26032 === (18))){
var inst_26014 = (state_26031[(2)]);
var state_26031__$1 = state_26031;
var statearr_26064_28415 = state_26031__$1;
(statearr_26064_28415[(2)] = inst_26014);

(statearr_26064_28415[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26032 === (8))){
var inst_26000 = cljs.core.async.close_BANG_(to);
var state_26031__$1 = state_26031;
var statearr_26065_28416 = state_26031__$1;
(statearr_26065_28416[(2)] = inst_26000);

(statearr_26065_28416[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__24799__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__24799__auto____0 = (function (){
var statearr_26066 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26066[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__24799__auto__);

(statearr_26066[(1)] = (1));

return statearr_26066;
});
var cljs$core$async$pipeline_STAR__$_state_machine__24799__auto____1 = (function (state_26031){
while(true){
var ret_value__24800__auto__ = (function (){try{while(true){
var result__24801__auto__ = switch__24798__auto__(state_26031);
if(cljs.core.keyword_identical_QMARK_(result__24801__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24801__auto__;
}
break;
}
}catch (e26067){var ex__24802__auto__ = e26067;
var statearr_26068_28419 = state_26031;
(statearr_26068_28419[(2)] = ex__24802__auto__);


if(cljs.core.seq((state_26031[(4)]))){
var statearr_26069_28420 = state_26031;
(statearr_26069_28420[(1)] = cljs.core.first((state_26031[(4)])));

} else {
throw ex__24802__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28427 = state_26031;
state_26031 = G__28427;
continue;
} else {
return ret_value__24800__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__24799__auto__ = function(state_26031){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__24799__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__24799__auto____1.call(this,state_26031);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__24799__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__24799__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__24799__auto__;
})()
})();
var state__25171__auto__ = (function (){var statearr_26070 = f__25170__auto__();
(statearr_26070[(6)] = c__25169__auto__);

return statearr_26070;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25171__auto__);
}));

return c__25169__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__26072 = arguments.length;
switch (G__26072) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__26086 = arguments.length;
switch (G__26086) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__26088 = arguments.length;
switch (G__26088) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__25169__auto___28440 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25170__auto__ = (function (){var switch__24798__auto__ = (function (state_26114){
var state_val_26115 = (state_26114[(1)]);
if((state_val_26115 === (7))){
var inst_26110 = (state_26114[(2)]);
var state_26114__$1 = state_26114;
var statearr_26140_28441 = state_26114__$1;
(statearr_26140_28441[(2)] = inst_26110);

(statearr_26140_28441[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26115 === (1))){
var state_26114__$1 = state_26114;
var statearr_26144_28442 = state_26114__$1;
(statearr_26144_28442[(2)] = null);

(statearr_26144_28442[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26115 === (4))){
var inst_26091 = (state_26114[(7)]);
var inst_26091__$1 = (state_26114[(2)]);
var inst_26092 = (inst_26091__$1 == null);
var state_26114__$1 = (function (){var statearr_26145 = state_26114;
(statearr_26145[(7)] = inst_26091__$1);

return statearr_26145;
})();
if(cljs.core.truth_(inst_26092)){
var statearr_26146_28443 = state_26114__$1;
(statearr_26146_28443[(1)] = (5));

} else {
var statearr_26148_28444 = state_26114__$1;
(statearr_26148_28444[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26115 === (13))){
var state_26114__$1 = state_26114;
var statearr_26151_28445 = state_26114__$1;
(statearr_26151_28445[(2)] = null);

(statearr_26151_28445[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26115 === (6))){
var inst_26091 = (state_26114[(7)]);
var inst_26097 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_26091) : p.call(null, inst_26091));
var state_26114__$1 = state_26114;
if(cljs.core.truth_(inst_26097)){
var statearr_26152_28446 = state_26114__$1;
(statearr_26152_28446[(1)] = (9));

} else {
var statearr_26153_28447 = state_26114__$1;
(statearr_26153_28447[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26115 === (3))){
var inst_26112 = (state_26114[(2)]);
var state_26114__$1 = state_26114;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26114__$1,inst_26112);
} else {
if((state_val_26115 === (12))){
var state_26114__$1 = state_26114;
var statearr_26154_28448 = state_26114__$1;
(statearr_26154_28448[(2)] = null);

(statearr_26154_28448[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26115 === (2))){
var state_26114__$1 = state_26114;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26114__$1,(4),ch);
} else {
if((state_val_26115 === (11))){
var inst_26091 = (state_26114[(7)]);
var inst_26101 = (state_26114[(2)]);
var state_26114__$1 = state_26114;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_26114__$1,(8),inst_26101,inst_26091);
} else {
if((state_val_26115 === (9))){
var state_26114__$1 = state_26114;
var statearr_26159_28449 = state_26114__$1;
(statearr_26159_28449[(2)] = tc);

(statearr_26159_28449[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26115 === (5))){
var inst_26094 = cljs.core.async.close_BANG_(tc);
var inst_26095 = cljs.core.async.close_BANG_(fc);
var state_26114__$1 = (function (){var statearr_26160 = state_26114;
(statearr_26160[(8)] = inst_26094);

return statearr_26160;
})();
var statearr_26161_28450 = state_26114__$1;
(statearr_26161_28450[(2)] = inst_26095);

(statearr_26161_28450[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26115 === (14))){
var inst_26108 = (state_26114[(2)]);
var state_26114__$1 = state_26114;
var statearr_26162_28451 = state_26114__$1;
(statearr_26162_28451[(2)] = inst_26108);

(statearr_26162_28451[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26115 === (10))){
var state_26114__$1 = state_26114;
var statearr_26163_28452 = state_26114__$1;
(statearr_26163_28452[(2)] = fc);

(statearr_26163_28452[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26115 === (8))){
var inst_26103 = (state_26114[(2)]);
var state_26114__$1 = state_26114;
if(cljs.core.truth_(inst_26103)){
var statearr_26164_28453 = state_26114__$1;
(statearr_26164_28453[(1)] = (12));

} else {
var statearr_26165_28454 = state_26114__$1;
(statearr_26165_28454[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__24799__auto__ = null;
var cljs$core$async$state_machine__24799__auto____0 = (function (){
var statearr_26166 = [null,null,null,null,null,null,null,null,null];
(statearr_26166[(0)] = cljs$core$async$state_machine__24799__auto__);

(statearr_26166[(1)] = (1));

return statearr_26166;
});
var cljs$core$async$state_machine__24799__auto____1 = (function (state_26114){
while(true){
var ret_value__24800__auto__ = (function (){try{while(true){
var result__24801__auto__ = switch__24798__auto__(state_26114);
if(cljs.core.keyword_identical_QMARK_(result__24801__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24801__auto__;
}
break;
}
}catch (e26167){var ex__24802__auto__ = e26167;
var statearr_26168_28455 = state_26114;
(statearr_26168_28455[(2)] = ex__24802__auto__);


if(cljs.core.seq((state_26114[(4)]))){
var statearr_26171_28456 = state_26114;
(statearr_26171_28456[(1)] = cljs.core.first((state_26114[(4)])));

} else {
throw ex__24802__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28457 = state_26114;
state_26114 = G__28457;
continue;
} else {
return ret_value__24800__auto__;
}
break;
}
});
cljs$core$async$state_machine__24799__auto__ = function(state_26114){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24799__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24799__auto____1.call(this,state_26114);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24799__auto____0;
cljs$core$async$state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24799__auto____1;
return cljs$core$async$state_machine__24799__auto__;
})()
})();
var state__25171__auto__ = (function (){var statearr_26172 = f__25170__auto__();
(statearr_26172[(6)] = c__25169__auto___28440);

return statearr_26172;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25171__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__25169__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25170__auto__ = (function (){var switch__24798__auto__ = (function (state_26194){
var state_val_26195 = (state_26194[(1)]);
if((state_val_26195 === (7))){
var inst_26190 = (state_26194[(2)]);
var state_26194__$1 = state_26194;
var statearr_26196_28458 = state_26194__$1;
(statearr_26196_28458[(2)] = inst_26190);

(statearr_26196_28458[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (1))){
var inst_26173 = init;
var inst_26174 = inst_26173;
var state_26194__$1 = (function (){var statearr_26197 = state_26194;
(statearr_26197[(7)] = inst_26174);

return statearr_26197;
})();
var statearr_26198_28463 = state_26194__$1;
(statearr_26198_28463[(2)] = null);

(statearr_26198_28463[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (4))){
var inst_26177 = (state_26194[(8)]);
var inst_26177__$1 = (state_26194[(2)]);
var inst_26178 = (inst_26177__$1 == null);
var state_26194__$1 = (function (){var statearr_26199 = state_26194;
(statearr_26199[(8)] = inst_26177__$1);

return statearr_26199;
})();
if(cljs.core.truth_(inst_26178)){
var statearr_26200_28464 = state_26194__$1;
(statearr_26200_28464[(1)] = (5));

} else {
var statearr_26201_28465 = state_26194__$1;
(statearr_26201_28465[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (6))){
var inst_26174 = (state_26194[(7)]);
var inst_26177 = (state_26194[(8)]);
var inst_26181 = (state_26194[(9)]);
var inst_26181__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_26174,inst_26177) : f.call(null, inst_26174,inst_26177));
var inst_26182 = cljs.core.reduced_QMARK_(inst_26181__$1);
var state_26194__$1 = (function (){var statearr_26202 = state_26194;
(statearr_26202[(9)] = inst_26181__$1);

return statearr_26202;
})();
if(inst_26182){
var statearr_26203_28466 = state_26194__$1;
(statearr_26203_28466[(1)] = (8));

} else {
var statearr_26204_28467 = state_26194__$1;
(statearr_26204_28467[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (3))){
var inst_26192 = (state_26194[(2)]);
var state_26194__$1 = state_26194;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26194__$1,inst_26192);
} else {
if((state_val_26195 === (2))){
var state_26194__$1 = state_26194;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26194__$1,(4),ch);
} else {
if((state_val_26195 === (9))){
var inst_26181 = (state_26194[(9)]);
var inst_26174 = inst_26181;
var state_26194__$1 = (function (){var statearr_26205 = state_26194;
(statearr_26205[(7)] = inst_26174);

return statearr_26205;
})();
var statearr_26206_28468 = state_26194__$1;
(statearr_26206_28468[(2)] = null);

(statearr_26206_28468[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (5))){
var inst_26174 = (state_26194[(7)]);
var state_26194__$1 = state_26194;
var statearr_26207_28469 = state_26194__$1;
(statearr_26207_28469[(2)] = inst_26174);

(statearr_26207_28469[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (10))){
var inst_26188 = (state_26194[(2)]);
var state_26194__$1 = state_26194;
var statearr_26208_28470 = state_26194__$1;
(statearr_26208_28470[(2)] = inst_26188);

(statearr_26208_28470[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (8))){
var inst_26181 = (state_26194[(9)]);
var inst_26184 = cljs.core.deref(inst_26181);
var state_26194__$1 = state_26194;
var statearr_26209_28471 = state_26194__$1;
(statearr_26209_28471[(2)] = inst_26184);

(statearr_26209_28471[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__24799__auto__ = null;
var cljs$core$async$reduce_$_state_machine__24799__auto____0 = (function (){
var statearr_26210 = [null,null,null,null,null,null,null,null,null,null];
(statearr_26210[(0)] = cljs$core$async$reduce_$_state_machine__24799__auto__);

(statearr_26210[(1)] = (1));

return statearr_26210;
});
var cljs$core$async$reduce_$_state_machine__24799__auto____1 = (function (state_26194){
while(true){
var ret_value__24800__auto__ = (function (){try{while(true){
var result__24801__auto__ = switch__24798__auto__(state_26194);
if(cljs.core.keyword_identical_QMARK_(result__24801__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24801__auto__;
}
break;
}
}catch (e26211){var ex__24802__auto__ = e26211;
var statearr_26212_28472 = state_26194;
(statearr_26212_28472[(2)] = ex__24802__auto__);


if(cljs.core.seq((state_26194[(4)]))){
var statearr_26213_28473 = state_26194;
(statearr_26213_28473[(1)] = cljs.core.first((state_26194[(4)])));

} else {
throw ex__24802__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28474 = state_26194;
state_26194 = G__28474;
continue;
} else {
return ret_value__24800__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__24799__auto__ = function(state_26194){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__24799__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__24799__auto____1.call(this,state_26194);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__24799__auto____0;
cljs$core$async$reduce_$_state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__24799__auto____1;
return cljs$core$async$reduce_$_state_machine__24799__auto__;
})()
})();
var state__25171__auto__ = (function (){var statearr_26214 = f__25170__auto__();
(statearr_26214[(6)] = c__25169__auto__);

return statearr_26214;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25171__auto__);
}));

return c__25169__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null, f));
var c__25169__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25170__auto__ = (function (){var switch__24798__auto__ = (function (state_26225){
var state_val_26226 = (state_26225[(1)]);
if((state_val_26226 === (1))){
var inst_26220 = cljs.core.async.reduce(f__$1,init,ch);
var state_26225__$1 = state_26225;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26225__$1,(2),inst_26220);
} else {
if((state_val_26226 === (2))){
var inst_26222 = (state_26225[(2)]);
var inst_26223 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_26222) : f__$1.call(null, inst_26222));
var state_26225__$1 = state_26225;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26225__$1,inst_26223);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__24799__auto__ = null;
var cljs$core$async$transduce_$_state_machine__24799__auto____0 = (function (){
var statearr_26227 = [null,null,null,null,null,null,null];
(statearr_26227[(0)] = cljs$core$async$transduce_$_state_machine__24799__auto__);

(statearr_26227[(1)] = (1));

return statearr_26227;
});
var cljs$core$async$transduce_$_state_machine__24799__auto____1 = (function (state_26225){
while(true){
var ret_value__24800__auto__ = (function (){try{while(true){
var result__24801__auto__ = switch__24798__auto__(state_26225);
if(cljs.core.keyword_identical_QMARK_(result__24801__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24801__auto__;
}
break;
}
}catch (e26228){var ex__24802__auto__ = e26228;
var statearr_26229_28475 = state_26225;
(statearr_26229_28475[(2)] = ex__24802__auto__);


if(cljs.core.seq((state_26225[(4)]))){
var statearr_26230_28476 = state_26225;
(statearr_26230_28476[(1)] = cljs.core.first((state_26225[(4)])));

} else {
throw ex__24802__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28477 = state_26225;
state_26225 = G__28477;
continue;
} else {
return ret_value__24800__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__24799__auto__ = function(state_26225){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__24799__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__24799__auto____1.call(this,state_26225);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__24799__auto____0;
cljs$core$async$transduce_$_state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__24799__auto____1;
return cljs$core$async$transduce_$_state_machine__24799__auto__;
})()
})();
var state__25171__auto__ = (function (){var statearr_26232 = f__25170__auto__();
(statearr_26232[(6)] = c__25169__auto__);

return statearr_26232;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25171__auto__);
}));

return c__25169__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__26234 = arguments.length;
switch (G__26234) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__25169__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25170__auto__ = (function (){var switch__24798__auto__ = (function (state_26262){
var state_val_26263 = (state_26262[(1)]);
if((state_val_26263 === (7))){
var inst_26241 = (state_26262[(2)]);
var state_26262__$1 = state_26262;
var statearr_26264_28479 = state_26262__$1;
(statearr_26264_28479[(2)] = inst_26241);

(statearr_26264_28479[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26263 === (1))){
var inst_26235 = cljs.core.seq(coll);
var inst_26236 = inst_26235;
var state_26262__$1 = (function (){var statearr_26265 = state_26262;
(statearr_26265[(7)] = inst_26236);

return statearr_26265;
})();
var statearr_26266_28480 = state_26262__$1;
(statearr_26266_28480[(2)] = null);

(statearr_26266_28480[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26263 === (4))){
var inst_26236 = (state_26262[(7)]);
var inst_26239 = cljs.core.first(inst_26236);
var state_26262__$1 = state_26262;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_26262__$1,(7),ch,inst_26239);
} else {
if((state_val_26263 === (13))){
var inst_26253 = (state_26262[(2)]);
var state_26262__$1 = state_26262;
var statearr_26267_28481 = state_26262__$1;
(statearr_26267_28481[(2)] = inst_26253);

(statearr_26267_28481[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26263 === (6))){
var inst_26244 = (state_26262[(2)]);
var state_26262__$1 = state_26262;
if(cljs.core.truth_(inst_26244)){
var statearr_26268_28482 = state_26262__$1;
(statearr_26268_28482[(1)] = (8));

} else {
var statearr_26269_28483 = state_26262__$1;
(statearr_26269_28483[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26263 === (3))){
var inst_26257 = (state_26262[(2)]);
var state_26262__$1 = state_26262;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26262__$1,inst_26257);
} else {
if((state_val_26263 === (12))){
var state_26262__$1 = state_26262;
var statearr_26273_28484 = state_26262__$1;
(statearr_26273_28484[(2)] = null);

(statearr_26273_28484[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26263 === (2))){
var inst_26236 = (state_26262[(7)]);
var state_26262__$1 = state_26262;
if(cljs.core.truth_(inst_26236)){
var statearr_26274_28485 = state_26262__$1;
(statearr_26274_28485[(1)] = (4));

} else {
var statearr_26275_28486 = state_26262__$1;
(statearr_26275_28486[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26263 === (11))){
var inst_26250 = cljs.core.async.close_BANG_(ch);
var state_26262__$1 = state_26262;
var statearr_26276_28487 = state_26262__$1;
(statearr_26276_28487[(2)] = inst_26250);

(statearr_26276_28487[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26263 === (9))){
var state_26262__$1 = state_26262;
if(cljs.core.truth_(close_QMARK_)){
var statearr_26277_28489 = state_26262__$1;
(statearr_26277_28489[(1)] = (11));

} else {
var statearr_26278_28490 = state_26262__$1;
(statearr_26278_28490[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26263 === (5))){
var inst_26236 = (state_26262[(7)]);
var state_26262__$1 = state_26262;
var statearr_26279_28492 = state_26262__$1;
(statearr_26279_28492[(2)] = inst_26236);

(statearr_26279_28492[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26263 === (10))){
var inst_26255 = (state_26262[(2)]);
var state_26262__$1 = state_26262;
var statearr_26281_28493 = state_26262__$1;
(statearr_26281_28493[(2)] = inst_26255);

(statearr_26281_28493[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26263 === (8))){
var inst_26236 = (state_26262[(7)]);
var inst_26246 = cljs.core.next(inst_26236);
var inst_26236__$1 = inst_26246;
var state_26262__$1 = (function (){var statearr_26288 = state_26262;
(statearr_26288[(7)] = inst_26236__$1);

return statearr_26288;
})();
var statearr_26289_28494 = state_26262__$1;
(statearr_26289_28494[(2)] = null);

(statearr_26289_28494[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__24799__auto__ = null;
var cljs$core$async$state_machine__24799__auto____0 = (function (){
var statearr_26290 = [null,null,null,null,null,null,null,null];
(statearr_26290[(0)] = cljs$core$async$state_machine__24799__auto__);

(statearr_26290[(1)] = (1));

return statearr_26290;
});
var cljs$core$async$state_machine__24799__auto____1 = (function (state_26262){
while(true){
var ret_value__24800__auto__ = (function (){try{while(true){
var result__24801__auto__ = switch__24798__auto__(state_26262);
if(cljs.core.keyword_identical_QMARK_(result__24801__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24801__auto__;
}
break;
}
}catch (e26291){var ex__24802__auto__ = e26291;
var statearr_26293_28495 = state_26262;
(statearr_26293_28495[(2)] = ex__24802__auto__);


if(cljs.core.seq((state_26262[(4)]))){
var statearr_26294_28496 = state_26262;
(statearr_26294_28496[(1)] = cljs.core.first((state_26262[(4)])));

} else {
throw ex__24802__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28498 = state_26262;
state_26262 = G__28498;
continue;
} else {
return ret_value__24800__auto__;
}
break;
}
});
cljs$core$async$state_machine__24799__auto__ = function(state_26262){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24799__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24799__auto____1.call(this,state_26262);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24799__auto____0;
cljs$core$async$state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24799__auto____1;
return cljs$core$async$state_machine__24799__auto__;
})()
})();
var state__25171__auto__ = (function (){var statearr_26295 = f__25170__auto__();
(statearr_26295[(6)] = c__25169__auto__);

return statearr_26295;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25171__auto__);
}));

return c__25169__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__26307 = arguments.length;
switch (G__26307) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_28501 = (function (_){
var x__5350__auto__ = (((_ == null))?null:_);
var m__5351__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5351__auto__.call(null, _));
} else {
var m__5349__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5349__auto__.call(null, _));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_28501(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_28502 = (function (m,ch,close_QMARK_){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5351__auto__.call(null, m,ch,close_QMARK_));
} else {
var m__5349__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5349__auto__.call(null, m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_28502(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_28504 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5351__auto__.call(null, m,ch));
} else {
var m__5349__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5349__auto__.call(null, m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_28504(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_28508 = (function (m){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5351__auto__.call(null, m));
} else {
var m__5349__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5349__auto__.call(null, m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_28508(m);
}
});


/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26333 = (function (ch,cs,meta26334){
this.ch = ch;
this.cs = cs;
this.meta26334 = meta26334;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async26333.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26335,meta26334__$1){
var self__ = this;
var _26335__$1 = this;
return (new cljs.core.async.t_cljs$core$async26333(self__.ch,self__.cs,meta26334__$1));
}));

(cljs.core.async.t_cljs$core$async26333.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26335){
var self__ = this;
var _26335__$1 = this;
return self__.meta26334;
}));

(cljs.core.async.t_cljs$core$async26333.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async26333.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async26333.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async26333.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async26333.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async26333.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async26333.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta26334","meta26334",-1916506838,null)], null);
}));

(cljs.core.async.t_cljs$core$async26333.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async26333.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26333");

(cljs.core.async.t_cljs$core$async26333.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async26333");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async26333.
 */
cljs.core.async.__GT_t_cljs$core$async26333 = (function cljs$core$async$__GT_t_cljs$core$async26333(ch,cs,meta26334){
return (new cljs.core.async.t_cljs$core$async26333(ch,cs,meta26334));
});


/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (new cljs.core.async.t_cljs$core$async26333(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__25169__auto___28516 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25170__auto__ = (function (){var switch__24798__auto__ = (function (state_26508){
var state_val_26509 = (state_26508[(1)]);
if((state_val_26509 === (7))){
var inst_26504 = (state_26508[(2)]);
var state_26508__$1 = state_26508;
var statearr_26510_28518 = state_26508__$1;
(statearr_26510_28518[(2)] = inst_26504);

(statearr_26510_28518[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (20))){
var inst_26396 = (state_26508[(7)]);
var inst_26408 = cljs.core.first(inst_26396);
var inst_26409 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26408,(0),null);
var inst_26410 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26408,(1),null);
var state_26508__$1 = (function (){var statearr_26514 = state_26508;
(statearr_26514[(8)] = inst_26409);

return statearr_26514;
})();
if(cljs.core.truth_(inst_26410)){
var statearr_26515_28520 = state_26508__$1;
(statearr_26515_28520[(1)] = (22));

} else {
var statearr_26516_28521 = state_26508__$1;
(statearr_26516_28521[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (27))){
var inst_26438 = (state_26508[(9)]);
var inst_26440 = (state_26508[(10)]);
var inst_26445 = (state_26508[(11)]);
var inst_26349 = (state_26508[(12)]);
var inst_26445__$1 = cljs.core._nth(inst_26438,inst_26440);
var inst_26446 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_26445__$1,inst_26349,done);
var state_26508__$1 = (function (){var statearr_26517 = state_26508;
(statearr_26517[(11)] = inst_26445__$1);

return statearr_26517;
})();
if(cljs.core.truth_(inst_26446)){
var statearr_26518_28523 = state_26508__$1;
(statearr_26518_28523[(1)] = (30));

} else {
var statearr_26519_28524 = state_26508__$1;
(statearr_26519_28524[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (1))){
var state_26508__$1 = state_26508;
var statearr_26520_28527 = state_26508__$1;
(statearr_26520_28527[(2)] = null);

(statearr_26520_28527[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (24))){
var inst_26396 = (state_26508[(7)]);
var inst_26415 = (state_26508[(2)]);
var inst_26416 = cljs.core.next(inst_26396);
var inst_26362 = inst_26416;
var inst_26363 = null;
var inst_26364 = (0);
var inst_26365 = (0);
var state_26508__$1 = (function (){var statearr_26521 = state_26508;
(statearr_26521[(13)] = inst_26415);

(statearr_26521[(14)] = inst_26362);

(statearr_26521[(15)] = inst_26363);

(statearr_26521[(16)] = inst_26364);

(statearr_26521[(17)] = inst_26365);

return statearr_26521;
})();
var statearr_26522_28530 = state_26508__$1;
(statearr_26522_28530[(2)] = null);

(statearr_26522_28530[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (39))){
var state_26508__$1 = state_26508;
var statearr_26526_28531 = state_26508__$1;
(statearr_26526_28531[(2)] = null);

(statearr_26526_28531[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (4))){
var inst_26349 = (state_26508[(12)]);
var inst_26349__$1 = (state_26508[(2)]);
var inst_26350 = (inst_26349__$1 == null);
var state_26508__$1 = (function (){var statearr_26527 = state_26508;
(statearr_26527[(12)] = inst_26349__$1);

return statearr_26527;
})();
if(cljs.core.truth_(inst_26350)){
var statearr_26528_28534 = state_26508__$1;
(statearr_26528_28534[(1)] = (5));

} else {
var statearr_26529_28535 = state_26508__$1;
(statearr_26529_28535[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (15))){
var inst_26365 = (state_26508[(17)]);
var inst_26362 = (state_26508[(14)]);
var inst_26363 = (state_26508[(15)]);
var inst_26364 = (state_26508[(16)]);
var inst_26392 = (state_26508[(2)]);
var inst_26393 = (inst_26365 + (1));
var tmp26523 = inst_26364;
var tmp26524 = inst_26362;
var tmp26525 = inst_26363;
var inst_26362__$1 = tmp26524;
var inst_26363__$1 = tmp26525;
var inst_26364__$1 = tmp26523;
var inst_26365__$1 = inst_26393;
var state_26508__$1 = (function (){var statearr_26530 = state_26508;
(statearr_26530[(18)] = inst_26392);

(statearr_26530[(14)] = inst_26362__$1);

(statearr_26530[(15)] = inst_26363__$1);

(statearr_26530[(16)] = inst_26364__$1);

(statearr_26530[(17)] = inst_26365__$1);

return statearr_26530;
})();
var statearr_26532_28537 = state_26508__$1;
(statearr_26532_28537[(2)] = null);

(statearr_26532_28537[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (21))){
var inst_26419 = (state_26508[(2)]);
var state_26508__$1 = state_26508;
var statearr_26545_28538 = state_26508__$1;
(statearr_26545_28538[(2)] = inst_26419);

(statearr_26545_28538[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (31))){
var inst_26445 = (state_26508[(11)]);
var inst_26449 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null, inst_26445);
var state_26508__$1 = state_26508;
var statearr_26546_28539 = state_26508__$1;
(statearr_26546_28539[(2)] = inst_26449);

(statearr_26546_28539[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (32))){
var inst_26440 = (state_26508[(10)]);
var inst_26437 = (state_26508[(19)]);
var inst_26438 = (state_26508[(9)]);
var inst_26439 = (state_26508[(20)]);
var inst_26451 = (state_26508[(2)]);
var inst_26452 = (inst_26440 + (1));
var tmp26536 = inst_26437;
var tmp26537 = inst_26438;
var tmp26538 = inst_26439;
var inst_26437__$1 = tmp26536;
var inst_26438__$1 = tmp26537;
var inst_26439__$1 = tmp26538;
var inst_26440__$1 = inst_26452;
var state_26508__$1 = (function (){var statearr_26547 = state_26508;
(statearr_26547[(21)] = inst_26451);

(statearr_26547[(19)] = inst_26437__$1);

(statearr_26547[(9)] = inst_26438__$1);

(statearr_26547[(20)] = inst_26439__$1);

(statearr_26547[(10)] = inst_26440__$1);

return statearr_26547;
})();
var statearr_26548_28540 = state_26508__$1;
(statearr_26548_28540[(2)] = null);

(statearr_26548_28540[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (40))){
var inst_26464 = (state_26508[(22)]);
var inst_26468 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null, inst_26464);
var state_26508__$1 = state_26508;
var statearr_26549_28541 = state_26508__$1;
(statearr_26549_28541[(2)] = inst_26468);

(statearr_26549_28541[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (33))){
var inst_26455 = (state_26508[(23)]);
var inst_26457 = cljs.core.chunked_seq_QMARK_(inst_26455);
var state_26508__$1 = state_26508;
if(inst_26457){
var statearr_26553_28542 = state_26508__$1;
(statearr_26553_28542[(1)] = (36));

} else {
var statearr_26557_28543 = state_26508__$1;
(statearr_26557_28543[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (13))){
var inst_26386 = (state_26508[(24)]);
var inst_26389 = cljs.core.async.close_BANG_(inst_26386);
var state_26508__$1 = state_26508;
var statearr_26558_28546 = state_26508__$1;
(statearr_26558_28546[(2)] = inst_26389);

(statearr_26558_28546[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (22))){
var inst_26409 = (state_26508[(8)]);
var inst_26412 = cljs.core.async.close_BANG_(inst_26409);
var state_26508__$1 = state_26508;
var statearr_26559_28547 = state_26508__$1;
(statearr_26559_28547[(2)] = inst_26412);

(statearr_26559_28547[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (36))){
var inst_26455 = (state_26508[(23)]);
var inst_26459 = cljs.core.chunk_first(inst_26455);
var inst_26460 = cljs.core.chunk_rest(inst_26455);
var inst_26461 = cljs.core.count(inst_26459);
var inst_26437 = inst_26460;
var inst_26438 = inst_26459;
var inst_26439 = inst_26461;
var inst_26440 = (0);
var state_26508__$1 = (function (){var statearr_26560 = state_26508;
(statearr_26560[(19)] = inst_26437);

(statearr_26560[(9)] = inst_26438);

(statearr_26560[(20)] = inst_26439);

(statearr_26560[(10)] = inst_26440);

return statearr_26560;
})();
var statearr_26561_28548 = state_26508__$1;
(statearr_26561_28548[(2)] = null);

(statearr_26561_28548[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (41))){
var inst_26455 = (state_26508[(23)]);
var inst_26470 = (state_26508[(2)]);
var inst_26483 = cljs.core.next(inst_26455);
var inst_26437 = inst_26483;
var inst_26438 = null;
var inst_26439 = (0);
var inst_26440 = (0);
var state_26508__$1 = (function (){var statearr_26562 = state_26508;
(statearr_26562[(25)] = inst_26470);

(statearr_26562[(19)] = inst_26437);

(statearr_26562[(9)] = inst_26438);

(statearr_26562[(20)] = inst_26439);

(statearr_26562[(10)] = inst_26440);

return statearr_26562;
})();
var statearr_26563_28549 = state_26508__$1;
(statearr_26563_28549[(2)] = null);

(statearr_26563_28549[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (43))){
var state_26508__$1 = state_26508;
var statearr_26564_28550 = state_26508__$1;
(statearr_26564_28550[(2)] = null);

(statearr_26564_28550[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (29))){
var inst_26491 = (state_26508[(2)]);
var state_26508__$1 = state_26508;
var statearr_26565_28551 = state_26508__$1;
(statearr_26565_28551[(2)] = inst_26491);

(statearr_26565_28551[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (44))){
var inst_26501 = (state_26508[(2)]);
var state_26508__$1 = (function (){var statearr_26566 = state_26508;
(statearr_26566[(26)] = inst_26501);

return statearr_26566;
})();
var statearr_26568_28554 = state_26508__$1;
(statearr_26568_28554[(2)] = null);

(statearr_26568_28554[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (6))){
var inst_26429 = (state_26508[(27)]);
var inst_26428 = cljs.core.deref(cs);
var inst_26429__$1 = cljs.core.keys(inst_26428);
var inst_26430 = cljs.core.count(inst_26429__$1);
var inst_26431 = cljs.core.reset_BANG_(dctr,inst_26430);
var inst_26436 = cljs.core.seq(inst_26429__$1);
var inst_26437 = inst_26436;
var inst_26438 = null;
var inst_26439 = (0);
var inst_26440 = (0);
var state_26508__$1 = (function (){var statearr_26572 = state_26508;
(statearr_26572[(27)] = inst_26429__$1);

(statearr_26572[(28)] = inst_26431);

(statearr_26572[(19)] = inst_26437);

(statearr_26572[(9)] = inst_26438);

(statearr_26572[(20)] = inst_26439);

(statearr_26572[(10)] = inst_26440);

return statearr_26572;
})();
var statearr_26573_28555 = state_26508__$1;
(statearr_26573_28555[(2)] = null);

(statearr_26573_28555[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (28))){
var inst_26437 = (state_26508[(19)]);
var inst_26455 = (state_26508[(23)]);
var inst_26455__$1 = cljs.core.seq(inst_26437);
var state_26508__$1 = (function (){var statearr_26574 = state_26508;
(statearr_26574[(23)] = inst_26455__$1);

return statearr_26574;
})();
if(inst_26455__$1){
var statearr_26575_28556 = state_26508__$1;
(statearr_26575_28556[(1)] = (33));

} else {
var statearr_26576_28557 = state_26508__$1;
(statearr_26576_28557[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (25))){
var inst_26440 = (state_26508[(10)]);
var inst_26439 = (state_26508[(20)]);
var inst_26442 = (inst_26440 < inst_26439);
var inst_26443 = inst_26442;
var state_26508__$1 = state_26508;
if(cljs.core.truth_(inst_26443)){
var statearr_26580_28558 = state_26508__$1;
(statearr_26580_28558[(1)] = (27));

} else {
var statearr_26581_28559 = state_26508__$1;
(statearr_26581_28559[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (34))){
var state_26508__$1 = state_26508;
var statearr_26582_28560 = state_26508__$1;
(statearr_26582_28560[(2)] = null);

(statearr_26582_28560[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (17))){
var state_26508__$1 = state_26508;
var statearr_26584_28561 = state_26508__$1;
(statearr_26584_28561[(2)] = null);

(statearr_26584_28561[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (3))){
var inst_26506 = (state_26508[(2)]);
var state_26508__$1 = state_26508;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26508__$1,inst_26506);
} else {
if((state_val_26509 === (12))){
var inst_26424 = (state_26508[(2)]);
var state_26508__$1 = state_26508;
var statearr_26587_28562 = state_26508__$1;
(statearr_26587_28562[(2)] = inst_26424);

(statearr_26587_28562[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (2))){
var state_26508__$1 = state_26508;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26508__$1,(4),ch);
} else {
if((state_val_26509 === (23))){
var state_26508__$1 = state_26508;
var statearr_26596_28563 = state_26508__$1;
(statearr_26596_28563[(2)] = null);

(statearr_26596_28563[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (35))){
var inst_26489 = (state_26508[(2)]);
var state_26508__$1 = state_26508;
var statearr_26598_28564 = state_26508__$1;
(statearr_26598_28564[(2)] = inst_26489);

(statearr_26598_28564[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (19))){
var inst_26396 = (state_26508[(7)]);
var inst_26400 = cljs.core.chunk_first(inst_26396);
var inst_26401 = cljs.core.chunk_rest(inst_26396);
var inst_26402 = cljs.core.count(inst_26400);
var inst_26362 = inst_26401;
var inst_26363 = inst_26400;
var inst_26364 = inst_26402;
var inst_26365 = (0);
var state_26508__$1 = (function (){var statearr_26602 = state_26508;
(statearr_26602[(14)] = inst_26362);

(statearr_26602[(15)] = inst_26363);

(statearr_26602[(16)] = inst_26364);

(statearr_26602[(17)] = inst_26365);

return statearr_26602;
})();
var statearr_26604_28565 = state_26508__$1;
(statearr_26604_28565[(2)] = null);

(statearr_26604_28565[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (11))){
var inst_26362 = (state_26508[(14)]);
var inst_26396 = (state_26508[(7)]);
var inst_26396__$1 = cljs.core.seq(inst_26362);
var state_26508__$1 = (function (){var statearr_26606 = state_26508;
(statearr_26606[(7)] = inst_26396__$1);

return statearr_26606;
})();
if(inst_26396__$1){
var statearr_26607_28566 = state_26508__$1;
(statearr_26607_28566[(1)] = (16));

} else {
var statearr_26608_28567 = state_26508__$1;
(statearr_26608_28567[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (9))){
var inst_26426 = (state_26508[(2)]);
var state_26508__$1 = state_26508;
var statearr_26609_28568 = state_26508__$1;
(statearr_26609_28568[(2)] = inst_26426);

(statearr_26609_28568[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (5))){
var inst_26360 = cljs.core.deref(cs);
var inst_26361 = cljs.core.seq(inst_26360);
var inst_26362 = inst_26361;
var inst_26363 = null;
var inst_26364 = (0);
var inst_26365 = (0);
var state_26508__$1 = (function (){var statearr_26614 = state_26508;
(statearr_26614[(14)] = inst_26362);

(statearr_26614[(15)] = inst_26363);

(statearr_26614[(16)] = inst_26364);

(statearr_26614[(17)] = inst_26365);

return statearr_26614;
})();
var statearr_26615_28569 = state_26508__$1;
(statearr_26615_28569[(2)] = null);

(statearr_26615_28569[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (14))){
var state_26508__$1 = state_26508;
var statearr_26617_28570 = state_26508__$1;
(statearr_26617_28570[(2)] = null);

(statearr_26617_28570[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (45))){
var inst_26498 = (state_26508[(2)]);
var state_26508__$1 = state_26508;
var statearr_26618_28571 = state_26508__$1;
(statearr_26618_28571[(2)] = inst_26498);

(statearr_26618_28571[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (26))){
var inst_26429 = (state_26508[(27)]);
var inst_26493 = (state_26508[(2)]);
var inst_26494 = cljs.core.seq(inst_26429);
var state_26508__$1 = (function (){var statearr_26619 = state_26508;
(statearr_26619[(29)] = inst_26493);

return statearr_26619;
})();
if(inst_26494){
var statearr_26620_28572 = state_26508__$1;
(statearr_26620_28572[(1)] = (42));

} else {
var statearr_26621_28573 = state_26508__$1;
(statearr_26621_28573[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (16))){
var inst_26396 = (state_26508[(7)]);
var inst_26398 = cljs.core.chunked_seq_QMARK_(inst_26396);
var state_26508__$1 = state_26508;
if(inst_26398){
var statearr_26622_28574 = state_26508__$1;
(statearr_26622_28574[(1)] = (19));

} else {
var statearr_26623_28575 = state_26508__$1;
(statearr_26623_28575[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (38))){
var inst_26486 = (state_26508[(2)]);
var state_26508__$1 = state_26508;
var statearr_26626_28576 = state_26508__$1;
(statearr_26626_28576[(2)] = inst_26486);

(statearr_26626_28576[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (30))){
var state_26508__$1 = state_26508;
var statearr_26627_28577 = state_26508__$1;
(statearr_26627_28577[(2)] = null);

(statearr_26627_28577[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (10))){
var inst_26363 = (state_26508[(15)]);
var inst_26365 = (state_26508[(17)]);
var inst_26385 = cljs.core._nth(inst_26363,inst_26365);
var inst_26386 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26385,(0),null);
var inst_26387 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26385,(1),null);
var state_26508__$1 = (function (){var statearr_26632 = state_26508;
(statearr_26632[(24)] = inst_26386);

return statearr_26632;
})();
if(cljs.core.truth_(inst_26387)){
var statearr_26633_28581 = state_26508__$1;
(statearr_26633_28581[(1)] = (13));

} else {
var statearr_26634_28582 = state_26508__$1;
(statearr_26634_28582[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (18))){
var inst_26422 = (state_26508[(2)]);
var state_26508__$1 = state_26508;
var statearr_26635_28583 = state_26508__$1;
(statearr_26635_28583[(2)] = inst_26422);

(statearr_26635_28583[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (42))){
var state_26508__$1 = state_26508;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26508__$1,(45),dchan);
} else {
if((state_val_26509 === (37))){
var inst_26455 = (state_26508[(23)]);
var inst_26464 = (state_26508[(22)]);
var inst_26349 = (state_26508[(12)]);
var inst_26464__$1 = cljs.core.first(inst_26455);
var inst_26465 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_26464__$1,inst_26349,done);
var state_26508__$1 = (function (){var statearr_26636 = state_26508;
(statearr_26636[(22)] = inst_26464__$1);

return statearr_26636;
})();
if(cljs.core.truth_(inst_26465)){
var statearr_26637_28584 = state_26508__$1;
(statearr_26637_28584[(1)] = (39));

} else {
var statearr_26638_28586 = state_26508__$1;
(statearr_26638_28586[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (8))){
var inst_26365 = (state_26508[(17)]);
var inst_26364 = (state_26508[(16)]);
var inst_26367 = (inst_26365 < inst_26364);
var inst_26368 = inst_26367;
var state_26508__$1 = state_26508;
if(cljs.core.truth_(inst_26368)){
var statearr_26639_28588 = state_26508__$1;
(statearr_26639_28588[(1)] = (10));

} else {
var statearr_26640_28589 = state_26508__$1;
(statearr_26640_28589[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__24799__auto__ = null;
var cljs$core$async$mult_$_state_machine__24799__auto____0 = (function (){
var statearr_26641 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26641[(0)] = cljs$core$async$mult_$_state_machine__24799__auto__);

(statearr_26641[(1)] = (1));

return statearr_26641;
});
var cljs$core$async$mult_$_state_machine__24799__auto____1 = (function (state_26508){
while(true){
var ret_value__24800__auto__ = (function (){try{while(true){
var result__24801__auto__ = switch__24798__auto__(state_26508);
if(cljs.core.keyword_identical_QMARK_(result__24801__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24801__auto__;
}
break;
}
}catch (e26642){var ex__24802__auto__ = e26642;
var statearr_26643_28592 = state_26508;
(statearr_26643_28592[(2)] = ex__24802__auto__);


if(cljs.core.seq((state_26508[(4)]))){
var statearr_26644_28594 = state_26508;
(statearr_26644_28594[(1)] = cljs.core.first((state_26508[(4)])));

} else {
throw ex__24802__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28597 = state_26508;
state_26508 = G__28597;
continue;
} else {
return ret_value__24800__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__24799__auto__ = function(state_26508){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__24799__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__24799__auto____1.call(this,state_26508);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__24799__auto____0;
cljs$core$async$mult_$_state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__24799__auto____1;
return cljs$core$async$mult_$_state_machine__24799__auto__;
})()
})();
var state__25171__auto__ = (function (){var statearr_26650 = f__25170__auto__();
(statearr_26650[(6)] = c__25169__auto___28516);

return statearr_26650;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25171__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__26652 = arguments.length;
switch (G__26652) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_28603 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5351__auto__.call(null, m,ch));
} else {
var m__5349__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5349__auto__.call(null, m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_28603(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_28607 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5351__auto__.call(null, m,ch));
} else {
var m__5349__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5349__auto__.call(null, m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_28607(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_28611 = (function (m){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5351__auto__.call(null, m));
} else {
var m__5349__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5349__auto__.call(null, m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_28611(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_28617 = (function (m,state_map){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5351__auto__.call(null, m,state_map));
} else {
var m__5349__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5349__auto__.call(null, m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_28617(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_28621 = (function (m,mode){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5351__auto__.call(null, m,mode));
} else {
var m__5349__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5349__auto__.call(null, m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_28621(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5732__auto__ = [];
var len__5726__auto___28626 = arguments.length;
var i__5727__auto___28627 = (0);
while(true){
if((i__5727__auto___28627 < len__5726__auto___28626)){
args__5732__auto__.push((arguments[i__5727__auto___28627]));

var G__28629 = (i__5727__auto___28627 + (1));
i__5727__auto___28627 = G__28629;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((3) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5733__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__26704){
var map__26705 = p__26704;
var map__26705__$1 = cljs.core.__destructure_map(map__26705);
var opts = map__26705__$1;
var statearr_26706_28631 = state;
(statearr_26706_28631[(1)] = cont_block);


var temp__5823__auto__ = cljs.core.async.do_alts((function (val){
var statearr_26707_28632 = state;
(statearr_26707_28632[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5823__auto__)){
var cb = temp__5823__auto__;
var statearr_26708_28634 = state;
(statearr_26708_28634[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq26677){
var G__26678 = cljs.core.first(seq26677);
var seq26677__$1 = cljs.core.next(seq26677);
var G__26679 = cljs.core.first(seq26677__$1);
var seq26677__$2 = cljs.core.next(seq26677__$1);
var G__26680 = cljs.core.first(seq26677__$2);
var seq26677__$3 = cljs.core.next(seq26677__$2);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__26678,G__26679,G__26680,seq26677__$3);
}));


/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26726 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta26727){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta26727 = meta26727;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async26726.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26728,meta26727__$1){
var self__ = this;
var _26728__$1 = this;
return (new cljs.core.async.t_cljs$core$async26726(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta26727__$1));
}));

(cljs.core.async.t_cljs$core$async26726.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26728){
var self__ = this;
var _26728__$1 = this;
return self__.meta26727;
}));

(cljs.core.async.t_cljs$core$async26726.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async26726.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async26726.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async26726.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null, ));
}));

(cljs.core.async.t_cljs$core$async26726.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null, ));
}));

(cljs.core.async.t_cljs$core$async26726.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null, ));
}));

(cljs.core.async.t_cljs$core$async26726.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null, ));
}));

(cljs.core.async.t_cljs$core$async26726.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null, mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null, ));
}));

(cljs.core.async.t_cljs$core$async26726.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta26727","meta26727",-1571314034,null)], null);
}));

(cljs.core.async.t_cljs$core$async26726.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async26726.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26726");

(cljs.core.async.t_cljs$core$async26726.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async26726");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async26726.
 */
cljs.core.async.__GT_t_cljs$core$async26726 = (function cljs$core$async$__GT_t_cljs$core$async26726(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta26727){
return (new cljs.core.async.t_cljs$core$async26726(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta26727));
});


/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null, v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (cljs.core.seq(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (new cljs.core.async.t_cljs$core$async26726(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
var c__25169__auto___28657 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25170__auto__ = (function (){var switch__24798__auto__ = (function (state_26865){
var state_val_26866 = (state_26865[(1)]);
if((state_val_26866 === (7))){
var inst_26790 = (state_26865[(2)]);
var state_26865__$1 = state_26865;
if(cljs.core.truth_(inst_26790)){
var statearr_26873_28663 = state_26865__$1;
(statearr_26873_28663[(1)] = (8));

} else {
var statearr_26874_28665 = state_26865__$1;
(statearr_26874_28665[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (20))){
var inst_26779 = (state_26865[(7)]);
var state_26865__$1 = state_26865;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_26865__$1,(23),out,inst_26779);
} else {
if((state_val_26866 === (1))){
var inst_26761 = calc_state();
var inst_26762 = cljs.core.__destructure_map(inst_26761);
var inst_26763 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26762,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_26764 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26762,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_26765 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26762,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_26766 = inst_26761;
var state_26865__$1 = (function (){var statearr_26887 = state_26865;
(statearr_26887[(8)] = inst_26763);

(statearr_26887[(9)] = inst_26764);

(statearr_26887[(10)] = inst_26765);

(statearr_26887[(11)] = inst_26766);

return statearr_26887;
})();
var statearr_26888_28667 = state_26865__$1;
(statearr_26888_28667[(2)] = null);

(statearr_26888_28667[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (24))){
var inst_26769 = (state_26865[(12)]);
var inst_26766 = inst_26769;
var state_26865__$1 = (function (){var statearr_26889 = state_26865;
(statearr_26889[(11)] = inst_26766);

return statearr_26889;
})();
var statearr_26890_28669 = state_26865__$1;
(statearr_26890_28669[(2)] = null);

(statearr_26890_28669[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (4))){
var inst_26779 = (state_26865[(7)]);
var inst_26781 = (state_26865[(13)]);
var inst_26778 = (state_26865[(2)]);
var inst_26779__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26778,(0),null);
var inst_26780 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26778,(1),null);
var inst_26781__$1 = (inst_26779__$1 == null);
var state_26865__$1 = (function (){var statearr_26892 = state_26865;
(statearr_26892[(7)] = inst_26779__$1);

(statearr_26892[(14)] = inst_26780);

(statearr_26892[(13)] = inst_26781__$1);

return statearr_26892;
})();
if(cljs.core.truth_(inst_26781__$1)){
var statearr_26895_28671 = state_26865__$1;
(statearr_26895_28671[(1)] = (5));

} else {
var statearr_26896_28672 = state_26865__$1;
(statearr_26896_28672[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (15))){
var inst_26770 = (state_26865[(15)]);
var inst_26810 = (state_26865[(16)]);
var inst_26810__$1 = cljs.core.empty_QMARK_(inst_26770);
var state_26865__$1 = (function (){var statearr_26915 = state_26865;
(statearr_26915[(16)] = inst_26810__$1);

return statearr_26915;
})();
if(inst_26810__$1){
var statearr_26916_28673 = state_26865__$1;
(statearr_26916_28673[(1)] = (17));

} else {
var statearr_26917_28674 = state_26865__$1;
(statearr_26917_28674[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (21))){
var inst_26769 = (state_26865[(12)]);
var inst_26766 = inst_26769;
var state_26865__$1 = (function (){var statearr_26918 = state_26865;
(statearr_26918[(11)] = inst_26766);

return statearr_26918;
})();
var statearr_26919_28677 = state_26865__$1;
(statearr_26919_28677[(2)] = null);

(statearr_26919_28677[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (13))){
var inst_26802 = (state_26865[(2)]);
var inst_26803 = calc_state();
var inst_26766 = inst_26803;
var state_26865__$1 = (function (){var statearr_26920 = state_26865;
(statearr_26920[(17)] = inst_26802);

(statearr_26920[(11)] = inst_26766);

return statearr_26920;
})();
var statearr_26921_28679 = state_26865__$1;
(statearr_26921_28679[(2)] = null);

(statearr_26921_28679[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (22))){
var inst_26833 = (state_26865[(2)]);
var state_26865__$1 = state_26865;
var statearr_26922_28681 = state_26865__$1;
(statearr_26922_28681[(2)] = inst_26833);

(statearr_26922_28681[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (6))){
var inst_26780 = (state_26865[(14)]);
var inst_26788 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_26780,change);
var state_26865__$1 = state_26865;
var statearr_26928_28682 = state_26865__$1;
(statearr_26928_28682[(2)] = inst_26788);

(statearr_26928_28682[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (25))){
var state_26865__$1 = state_26865;
var statearr_26929_28685 = state_26865__$1;
(statearr_26929_28685[(2)] = null);

(statearr_26929_28685[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (17))){
var inst_26771 = (state_26865[(18)]);
var inst_26780 = (state_26865[(14)]);
var inst_26813 = (inst_26771.cljs$core$IFn$_invoke$arity$1 ? inst_26771.cljs$core$IFn$_invoke$arity$1(inst_26780) : inst_26771.call(null, inst_26780));
var inst_26814 = cljs.core.not(inst_26813);
var state_26865__$1 = state_26865;
var statearr_26934_28687 = state_26865__$1;
(statearr_26934_28687[(2)] = inst_26814);

(statearr_26934_28687[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (3))){
var inst_26838 = (state_26865[(2)]);
var state_26865__$1 = state_26865;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26865__$1,inst_26838);
} else {
if((state_val_26866 === (12))){
var state_26865__$1 = state_26865;
var statearr_26935_28689 = state_26865__$1;
(statearr_26935_28689[(2)] = null);

(statearr_26935_28689[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (2))){
var inst_26766 = (state_26865[(11)]);
var inst_26769 = (state_26865[(12)]);
var inst_26769__$1 = cljs.core.__destructure_map(inst_26766);
var inst_26770 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26769__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_26771 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26769__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_26773 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26769__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_26865__$1 = (function (){var statearr_26940 = state_26865;
(statearr_26940[(12)] = inst_26769__$1);

(statearr_26940[(15)] = inst_26770);

(statearr_26940[(18)] = inst_26771);

return statearr_26940;
})();
return cljs.core.async.ioc_alts_BANG_(state_26865__$1,(4),inst_26773);
} else {
if((state_val_26866 === (23))){
var inst_26824 = (state_26865[(2)]);
var state_26865__$1 = state_26865;
if(cljs.core.truth_(inst_26824)){
var statearr_26941_28692 = state_26865__$1;
(statearr_26941_28692[(1)] = (24));

} else {
var statearr_26942_28693 = state_26865__$1;
(statearr_26942_28693[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (19))){
var inst_26817 = (state_26865[(2)]);
var state_26865__$1 = state_26865;
var statearr_26943_28695 = state_26865__$1;
(statearr_26943_28695[(2)] = inst_26817);

(statearr_26943_28695[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (11))){
var inst_26780 = (state_26865[(14)]);
var inst_26799 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_26780);
var state_26865__$1 = state_26865;
var statearr_26945_28696 = state_26865__$1;
(statearr_26945_28696[(2)] = inst_26799);

(statearr_26945_28696[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (9))){
var inst_26770 = (state_26865[(15)]);
var inst_26780 = (state_26865[(14)]);
var inst_26806 = (state_26865[(19)]);
var inst_26806__$1 = (inst_26770.cljs$core$IFn$_invoke$arity$1 ? inst_26770.cljs$core$IFn$_invoke$arity$1(inst_26780) : inst_26770.call(null, inst_26780));
var state_26865__$1 = (function (){var statearr_26946 = state_26865;
(statearr_26946[(19)] = inst_26806__$1);

return statearr_26946;
})();
if(cljs.core.truth_(inst_26806__$1)){
var statearr_26947_28700 = state_26865__$1;
(statearr_26947_28700[(1)] = (14));

} else {
var statearr_26948_28701 = state_26865__$1;
(statearr_26948_28701[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (5))){
var inst_26781 = (state_26865[(13)]);
var state_26865__$1 = state_26865;
var statearr_26949_28702 = state_26865__$1;
(statearr_26949_28702[(2)] = inst_26781);

(statearr_26949_28702[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (14))){
var inst_26806 = (state_26865[(19)]);
var state_26865__$1 = state_26865;
var statearr_26953_28703 = state_26865__$1;
(statearr_26953_28703[(2)] = inst_26806);

(statearr_26953_28703[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (26))){
var inst_26829 = (state_26865[(2)]);
var state_26865__$1 = state_26865;
var statearr_26955_28705 = state_26865__$1;
(statearr_26955_28705[(2)] = inst_26829);

(statearr_26955_28705[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (16))){
var inst_26819 = (state_26865[(2)]);
var state_26865__$1 = state_26865;
if(cljs.core.truth_(inst_26819)){
var statearr_26957_28706 = state_26865__$1;
(statearr_26957_28706[(1)] = (20));

} else {
var statearr_26958_28707 = state_26865__$1;
(statearr_26958_28707[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (10))){
var inst_26836 = (state_26865[(2)]);
var state_26865__$1 = state_26865;
var statearr_26959_28708 = state_26865__$1;
(statearr_26959_28708[(2)] = inst_26836);

(statearr_26959_28708[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (18))){
var inst_26810 = (state_26865[(16)]);
var state_26865__$1 = state_26865;
var statearr_26960_28713 = state_26865__$1;
(statearr_26960_28713[(2)] = inst_26810);

(statearr_26960_28713[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (8))){
var inst_26779 = (state_26865[(7)]);
var inst_26795 = (inst_26779 == null);
var state_26865__$1 = state_26865;
if(cljs.core.truth_(inst_26795)){
var statearr_26965_28714 = state_26865__$1;
(statearr_26965_28714[(1)] = (11));

} else {
var statearr_26966_28715 = state_26865__$1;
(statearr_26966_28715[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__24799__auto__ = null;
var cljs$core$async$mix_$_state_machine__24799__auto____0 = (function (){
var statearr_26973 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26973[(0)] = cljs$core$async$mix_$_state_machine__24799__auto__);

(statearr_26973[(1)] = (1));

return statearr_26973;
});
var cljs$core$async$mix_$_state_machine__24799__auto____1 = (function (state_26865){
while(true){
var ret_value__24800__auto__ = (function (){try{while(true){
var result__24801__auto__ = switch__24798__auto__(state_26865);
if(cljs.core.keyword_identical_QMARK_(result__24801__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24801__auto__;
}
break;
}
}catch (e26979){var ex__24802__auto__ = e26979;
var statearr_26980_28717 = state_26865;
(statearr_26980_28717[(2)] = ex__24802__auto__);


if(cljs.core.seq((state_26865[(4)]))){
var statearr_26984_28718 = state_26865;
(statearr_26984_28718[(1)] = cljs.core.first((state_26865[(4)])));

} else {
throw ex__24802__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28721 = state_26865;
state_26865 = G__28721;
continue;
} else {
return ret_value__24800__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__24799__auto__ = function(state_26865){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__24799__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__24799__auto____1.call(this,state_26865);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__24799__auto____0;
cljs$core$async$mix_$_state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__24799__auto____1;
return cljs$core$async$mix_$_state_machine__24799__auto__;
})()
})();
var state__25171__auto__ = (function (){var statearr_26992 = f__25170__auto__();
(statearr_26992[(6)] = c__25169__auto___28657);

return statearr_26992;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25171__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_28725 = (function (p,v,ch,close_QMARK_){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5351__auto__.call(null, p,v,ch,close_QMARK_));
} else {
var m__5349__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5349__auto__.call(null, p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_28725(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_28729 = (function (p,v,ch){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5351__auto__.call(null, p,v,ch));
} else {
var m__5349__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5349__auto__.call(null, p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_28729(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_28735 = (function() {
var G__28736 = null;
var G__28736__1 = (function (p){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5351__auto__.call(null, p));
} else {
var m__5349__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5349__auto__.call(null, p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__28736__2 = (function (p,v){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5351__auto__.call(null, p,v));
} else {
var m__5349__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5349__auto__.call(null, p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__28736 = function(p,v){
switch(arguments.length){
case 1:
return G__28736__1.call(this,p);
case 2:
return G__28736__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__28736.cljs$core$IFn$_invoke$arity$1 = G__28736__1;
G__28736.cljs$core$IFn$_invoke$arity$2 = G__28736__2;
return G__28736;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__27026 = arguments.length;
switch (G__27026) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_28735(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_28735(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);



/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27035 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta27036){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta27036 = meta27036;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async27035.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_27037,meta27036__$1){
var self__ = this;
var _27037__$1 = this;
return (new cljs.core.async.t_cljs$core$async27035(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta27036__$1));
}));

(cljs.core.async.t_cljs$core$async27035.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_27037){
var self__ = this;
var _27037__$1 = this;
return self__.meta27036;
}));

(cljs.core.async.t_cljs$core$async27035.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async27035.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async27035.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async27035.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null, topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async27035.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5823__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5823__auto__)){
var m = temp__5823__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async27035.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async27035.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async27035.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta27036","meta27036",931705030,null)], null);
}));

(cljs.core.async.t_cljs$core$async27035.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async27035.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27035");

(cljs.core.async.t_cljs$core$async27035.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async27035");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async27035.
 */
cljs.core.async.__GT_t_cljs$core$async27035 = (function cljs$core$async$__GT_t_cljs$core$async27035(ch,topic_fn,buf_fn,mults,ensure_mult,meta27036){
return (new cljs.core.async.t_cljs$core$async27035(ch,topic_fn,buf_fn,mults,ensure_mult,meta27036));
});


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__27031 = arguments.length;
switch (G__27031) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__5002__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__27029_SHARP_){
if(cljs.core.truth_((p1__27029_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__27029_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__27029_SHARP_.call(null, topic)))){
return p1__27029_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__27029_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null, topic)))));
}
})),topic);
}
});
var p = (new cljs.core.async.t_cljs$core$async27035(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
var c__25169__auto___28756 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25170__auto__ = (function (){var switch__24798__auto__ = (function (state_27150){
var state_val_27151 = (state_27150[(1)]);
if((state_val_27151 === (7))){
var inst_27146 = (state_27150[(2)]);
var state_27150__$1 = state_27150;
var statearr_27154_28758 = state_27150__$1;
(statearr_27154_28758[(2)] = inst_27146);

(statearr_27154_28758[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27151 === (20))){
var state_27150__$1 = state_27150;
var statearr_27156_28759 = state_27150__$1;
(statearr_27156_28759[(2)] = null);

(statearr_27156_28759[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27151 === (1))){
var state_27150__$1 = state_27150;
var statearr_27159_28761 = state_27150__$1;
(statearr_27159_28761[(2)] = null);

(statearr_27159_28761[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27151 === (24))){
var inst_27122 = (state_27150[(7)]);
var inst_27138 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_27122);
var state_27150__$1 = state_27150;
var statearr_27181_28762 = state_27150__$1;
(statearr_27181_28762[(2)] = inst_27138);

(statearr_27181_28762[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27151 === (4))){
var inst_27054 = (state_27150[(8)]);
var inst_27054__$1 = (state_27150[(2)]);
var inst_27055 = (inst_27054__$1 == null);
var state_27150__$1 = (function (){var statearr_27182 = state_27150;
(statearr_27182[(8)] = inst_27054__$1);

return statearr_27182;
})();
if(cljs.core.truth_(inst_27055)){
var statearr_27183_28764 = state_27150__$1;
(statearr_27183_28764[(1)] = (5));

} else {
var statearr_27184_28765 = state_27150__$1;
(statearr_27184_28765[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27151 === (15))){
var inst_27108 = (state_27150[(2)]);
var state_27150__$1 = state_27150;
var statearr_27185_28766 = state_27150__$1;
(statearr_27185_28766[(2)] = inst_27108);

(statearr_27185_28766[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27151 === (21))){
var inst_27143 = (state_27150[(2)]);
var state_27150__$1 = (function (){var statearr_27188 = state_27150;
(statearr_27188[(9)] = inst_27143);

return statearr_27188;
})();
var statearr_27192_28769 = state_27150__$1;
(statearr_27192_28769[(2)] = null);

(statearr_27192_28769[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27151 === (13))){
var inst_27081 = (state_27150[(10)]);
var inst_27087 = cljs.core.chunked_seq_QMARK_(inst_27081);
var state_27150__$1 = state_27150;
if(inst_27087){
var statearr_27197_28772 = state_27150__$1;
(statearr_27197_28772[(1)] = (16));

} else {
var statearr_27198_28773 = state_27150__$1;
(statearr_27198_28773[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27151 === (22))){
var inst_27135 = (state_27150[(2)]);
var state_27150__$1 = state_27150;
if(cljs.core.truth_(inst_27135)){
var statearr_27199_28774 = state_27150__$1;
(statearr_27199_28774[(1)] = (23));

} else {
var statearr_27200_28775 = state_27150__$1;
(statearr_27200_28775[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27151 === (6))){
var inst_27054 = (state_27150[(8)]);
var inst_27122 = (state_27150[(7)]);
var inst_27127 = (state_27150[(11)]);
var inst_27122__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_27054) : topic_fn.call(null, inst_27054));
var inst_27125 = cljs.core.deref(mults);
var inst_27127__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27125,inst_27122__$1);
var state_27150__$1 = (function (){var statearr_27205 = state_27150;
(statearr_27205[(7)] = inst_27122__$1);

(statearr_27205[(11)] = inst_27127__$1);

return statearr_27205;
})();
if(cljs.core.truth_(inst_27127__$1)){
var statearr_27207_28776 = state_27150__$1;
(statearr_27207_28776[(1)] = (19));

} else {
var statearr_27208_28777 = state_27150__$1;
(statearr_27208_28777[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27151 === (25))){
var inst_27140 = (state_27150[(2)]);
var state_27150__$1 = state_27150;
var statearr_27214_28778 = state_27150__$1;
(statearr_27214_28778[(2)] = inst_27140);

(statearr_27214_28778[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27151 === (17))){
var inst_27081 = (state_27150[(10)]);
var inst_27094 = cljs.core.first(inst_27081);
var inst_27097 = cljs.core.async.muxch_STAR_(inst_27094);
var inst_27098 = cljs.core.async.close_BANG_(inst_27097);
var inst_27101 = cljs.core.next(inst_27081);
var inst_27064 = inst_27101;
var inst_27065 = null;
var inst_27066 = (0);
var inst_27067 = (0);
var state_27150__$1 = (function (){var statearr_27218 = state_27150;
(statearr_27218[(12)] = inst_27098);

(statearr_27218[(13)] = inst_27064);

(statearr_27218[(14)] = inst_27065);

(statearr_27218[(15)] = inst_27066);

(statearr_27218[(16)] = inst_27067);

return statearr_27218;
})();
var statearr_27222_28779 = state_27150__$1;
(statearr_27222_28779[(2)] = null);

(statearr_27222_28779[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27151 === (3))){
var inst_27148 = (state_27150[(2)]);
var state_27150__$1 = state_27150;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27150__$1,inst_27148);
} else {
if((state_val_27151 === (12))){
var inst_27110 = (state_27150[(2)]);
var state_27150__$1 = state_27150;
var statearr_27223_28782 = state_27150__$1;
(statearr_27223_28782[(2)] = inst_27110);

(statearr_27223_28782[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27151 === (2))){
var state_27150__$1 = state_27150;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27150__$1,(4),ch);
} else {
if((state_val_27151 === (23))){
var state_27150__$1 = state_27150;
var statearr_27230_28784 = state_27150__$1;
(statearr_27230_28784[(2)] = null);

(statearr_27230_28784[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27151 === (19))){
var inst_27127 = (state_27150[(11)]);
var inst_27054 = (state_27150[(8)]);
var inst_27133 = cljs.core.async.muxch_STAR_(inst_27127);
var state_27150__$1 = state_27150;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27150__$1,(22),inst_27133,inst_27054);
} else {
if((state_val_27151 === (11))){
var inst_27064 = (state_27150[(13)]);
var inst_27081 = (state_27150[(10)]);
var inst_27081__$1 = cljs.core.seq(inst_27064);
var state_27150__$1 = (function (){var statearr_27239 = state_27150;
(statearr_27239[(10)] = inst_27081__$1);

return statearr_27239;
})();
if(inst_27081__$1){
var statearr_27240_28787 = state_27150__$1;
(statearr_27240_28787[(1)] = (13));

} else {
var statearr_27241_28788 = state_27150__$1;
(statearr_27241_28788[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27151 === (9))){
var inst_27112 = (state_27150[(2)]);
var state_27150__$1 = state_27150;
var statearr_27242_28791 = state_27150__$1;
(statearr_27242_28791[(2)] = inst_27112);

(statearr_27242_28791[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27151 === (5))){
var inst_27061 = cljs.core.deref(mults);
var inst_27062 = cljs.core.vals(inst_27061);
var inst_27063 = cljs.core.seq(inst_27062);
var inst_27064 = inst_27063;
var inst_27065 = null;
var inst_27066 = (0);
var inst_27067 = (0);
var state_27150__$1 = (function (){var statearr_27247 = state_27150;
(statearr_27247[(13)] = inst_27064);

(statearr_27247[(14)] = inst_27065);

(statearr_27247[(15)] = inst_27066);

(statearr_27247[(16)] = inst_27067);

return statearr_27247;
})();
var statearr_27250_28794 = state_27150__$1;
(statearr_27250_28794[(2)] = null);

(statearr_27250_28794[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27151 === (14))){
var state_27150__$1 = state_27150;
var statearr_27254_28796 = state_27150__$1;
(statearr_27254_28796[(2)] = null);

(statearr_27254_28796[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27151 === (16))){
var inst_27081 = (state_27150[(10)]);
var inst_27089 = cljs.core.chunk_first(inst_27081);
var inst_27090 = cljs.core.chunk_rest(inst_27081);
var inst_27091 = cljs.core.count(inst_27089);
var inst_27064 = inst_27090;
var inst_27065 = inst_27089;
var inst_27066 = inst_27091;
var inst_27067 = (0);
var state_27150__$1 = (function (){var statearr_27257 = state_27150;
(statearr_27257[(13)] = inst_27064);

(statearr_27257[(14)] = inst_27065);

(statearr_27257[(15)] = inst_27066);

(statearr_27257[(16)] = inst_27067);

return statearr_27257;
})();
var statearr_27261_28808 = state_27150__$1;
(statearr_27261_28808[(2)] = null);

(statearr_27261_28808[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27151 === (10))){
var inst_27065 = (state_27150[(14)]);
var inst_27067 = (state_27150[(16)]);
var inst_27064 = (state_27150[(13)]);
var inst_27066 = (state_27150[(15)]);
var inst_27073 = cljs.core._nth(inst_27065,inst_27067);
var inst_27074 = cljs.core.async.muxch_STAR_(inst_27073);
var inst_27075 = cljs.core.async.close_BANG_(inst_27074);
var inst_27076 = (inst_27067 + (1));
var tmp27251 = inst_27066;
var tmp27252 = inst_27065;
var tmp27253 = inst_27064;
var inst_27064__$1 = tmp27253;
var inst_27065__$1 = tmp27252;
var inst_27066__$1 = tmp27251;
var inst_27067__$1 = inst_27076;
var state_27150__$1 = (function (){var statearr_27263 = state_27150;
(statearr_27263[(17)] = inst_27075);

(statearr_27263[(13)] = inst_27064__$1);

(statearr_27263[(14)] = inst_27065__$1);

(statearr_27263[(15)] = inst_27066__$1);

(statearr_27263[(16)] = inst_27067__$1);

return statearr_27263;
})();
var statearr_27265_28810 = state_27150__$1;
(statearr_27265_28810[(2)] = null);

(statearr_27265_28810[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27151 === (18))){
var inst_27105 = (state_27150[(2)]);
var state_27150__$1 = state_27150;
var statearr_27267_28811 = state_27150__$1;
(statearr_27267_28811[(2)] = inst_27105);

(statearr_27267_28811[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27151 === (8))){
var inst_27067 = (state_27150[(16)]);
var inst_27066 = (state_27150[(15)]);
var inst_27070 = (inst_27067 < inst_27066);
var inst_27071 = inst_27070;
var state_27150__$1 = state_27150;
if(cljs.core.truth_(inst_27071)){
var statearr_27268_28812 = state_27150__$1;
(statearr_27268_28812[(1)] = (10));

} else {
var statearr_27269_28813 = state_27150__$1;
(statearr_27269_28813[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__24799__auto__ = null;
var cljs$core$async$state_machine__24799__auto____0 = (function (){
var statearr_27270 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27270[(0)] = cljs$core$async$state_machine__24799__auto__);

(statearr_27270[(1)] = (1));

return statearr_27270;
});
var cljs$core$async$state_machine__24799__auto____1 = (function (state_27150){
while(true){
var ret_value__24800__auto__ = (function (){try{while(true){
var result__24801__auto__ = switch__24798__auto__(state_27150);
if(cljs.core.keyword_identical_QMARK_(result__24801__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24801__auto__;
}
break;
}
}catch (e27271){var ex__24802__auto__ = e27271;
var statearr_27272_28816 = state_27150;
(statearr_27272_28816[(2)] = ex__24802__auto__);


if(cljs.core.seq((state_27150[(4)]))){
var statearr_27273_28817 = state_27150;
(statearr_27273_28817[(1)] = cljs.core.first((state_27150[(4)])));

} else {
throw ex__24802__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28818 = state_27150;
state_27150 = G__28818;
continue;
} else {
return ret_value__24800__auto__;
}
break;
}
});
cljs$core$async$state_machine__24799__auto__ = function(state_27150){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24799__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24799__auto____1.call(this,state_27150);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24799__auto____0;
cljs$core$async$state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24799__auto____1;
return cljs$core$async$state_machine__24799__auto__;
})()
})();
var state__25171__auto__ = (function (){var statearr_27280 = f__25170__auto__();
(statearr_27280[(6)] = c__25169__auto___28756);

return statearr_27280;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25171__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__27292 = arguments.length;
switch (G__27292) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__27312 = arguments.length;
switch (G__27312) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__27348 = arguments.length;
switch (G__27348) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_(out);
} else {
var c__25169__auto___28829 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25170__auto__ = (function (){var switch__24798__auto__ = (function (state_27425){
var state_val_27426 = (state_27425[(1)]);
if((state_val_27426 === (7))){
var state_27425__$1 = state_27425;
var statearr_27436_28834 = state_27425__$1;
(statearr_27436_28834[(2)] = null);

(statearr_27436_28834[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27426 === (1))){
var state_27425__$1 = state_27425;
var statearr_27454_28838 = state_27425__$1;
(statearr_27454_28838[(2)] = null);

(statearr_27454_28838[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27426 === (4))){
var inst_27385 = (state_27425[(7)]);
var inst_27384 = (state_27425[(8)]);
var inst_27387 = (inst_27385 < inst_27384);
var state_27425__$1 = state_27425;
if(cljs.core.truth_(inst_27387)){
var statearr_27455_28839 = state_27425__$1;
(statearr_27455_28839[(1)] = (6));

} else {
var statearr_27456_28840 = state_27425__$1;
(statearr_27456_28840[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27426 === (15))){
var inst_27411 = (state_27425[(9)]);
var inst_27416 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_27411);
var state_27425__$1 = state_27425;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27425__$1,(17),out,inst_27416);
} else {
if((state_val_27426 === (13))){
var inst_27411 = (state_27425[(9)]);
var inst_27411__$1 = (state_27425[(2)]);
var inst_27412 = cljs.core.some(cljs.core.nil_QMARK_,inst_27411__$1);
var state_27425__$1 = (function (){var statearr_27457 = state_27425;
(statearr_27457[(9)] = inst_27411__$1);

return statearr_27457;
})();
if(cljs.core.truth_(inst_27412)){
var statearr_27458_28845 = state_27425__$1;
(statearr_27458_28845[(1)] = (14));

} else {
var statearr_27459_28846 = state_27425__$1;
(statearr_27459_28846[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27426 === (6))){
var state_27425__$1 = state_27425;
var statearr_27460_28847 = state_27425__$1;
(statearr_27460_28847[(2)] = null);

(statearr_27460_28847[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27426 === (17))){
var inst_27418 = (state_27425[(2)]);
var state_27425__$1 = (function (){var statearr_27463 = state_27425;
(statearr_27463[(10)] = inst_27418);

return statearr_27463;
})();
var statearr_27464_28850 = state_27425__$1;
(statearr_27464_28850[(2)] = null);

(statearr_27464_28850[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27426 === (3))){
var inst_27423 = (state_27425[(2)]);
var state_27425__$1 = state_27425;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27425__$1,inst_27423);
} else {
if((state_val_27426 === (12))){
var _ = (function (){var statearr_27465 = state_27425;
(statearr_27465[(4)] = cljs.core.rest((state_27425[(4)])));

return statearr_27465;
})();
var state_27425__$1 = state_27425;
var ex27461 = (state_27425__$1[(2)]);
var statearr_27466_28853 = state_27425__$1;
(statearr_27466_28853[(5)] = ex27461);


if((ex27461 instanceof Object)){
var statearr_27467_28854 = state_27425__$1;
(statearr_27467_28854[(1)] = (11));

(statearr_27467_28854[(5)] = null);

} else {
throw ex27461;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27426 === (2))){
var inst_27383 = cljs.core.reset_BANG_(dctr,cnt);
var inst_27384 = cnt;
var inst_27385 = (0);
var state_27425__$1 = (function (){var statearr_27550 = state_27425;
(statearr_27550[(11)] = inst_27383);

(statearr_27550[(8)] = inst_27384);

(statearr_27550[(7)] = inst_27385);

return statearr_27550;
})();
var statearr_27551_28855 = state_27425__$1;
(statearr_27551_28855[(2)] = null);

(statearr_27551_28855[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27426 === (11))){
var inst_27390 = (state_27425[(2)]);
var inst_27391 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_27425__$1 = (function (){var statearr_27552 = state_27425;
(statearr_27552[(12)] = inst_27390);

return statearr_27552;
})();
var statearr_27553_28856 = state_27425__$1;
(statearr_27553_28856[(2)] = inst_27391);

(statearr_27553_28856[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27426 === (9))){
var inst_27385 = (state_27425[(7)]);
var _ = (function (){var statearr_27558 = state_27425;
(statearr_27558[(4)] = cljs.core.cons((12),(state_27425[(4)])));

return statearr_27558;
})();
var inst_27397 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_27385) : chs__$1.call(null, inst_27385));
var inst_27398 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_27385) : done.call(null, inst_27385));
var inst_27399 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_27397,inst_27398);
var ___$1 = (function (){var statearr_27562 = state_27425;
(statearr_27562[(4)] = cljs.core.rest((state_27425[(4)])));

return statearr_27562;
})();
var state_27425__$1 = state_27425;
var statearr_27564_28857 = state_27425__$1;
(statearr_27564_28857[(2)] = inst_27399);

(statearr_27564_28857[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27426 === (5))){
var inst_27409 = (state_27425[(2)]);
var state_27425__$1 = (function (){var statearr_27567 = state_27425;
(statearr_27567[(13)] = inst_27409);

return statearr_27567;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27425__$1,(13),dchan);
} else {
if((state_val_27426 === (14))){
var inst_27414 = cljs.core.async.close_BANG_(out);
var state_27425__$1 = state_27425;
var statearr_27574_28858 = state_27425__$1;
(statearr_27574_28858[(2)] = inst_27414);

(statearr_27574_28858[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27426 === (16))){
var inst_27421 = (state_27425[(2)]);
var state_27425__$1 = state_27425;
var statearr_27577_28859 = state_27425__$1;
(statearr_27577_28859[(2)] = inst_27421);

(statearr_27577_28859[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27426 === (10))){
var inst_27385 = (state_27425[(7)]);
var inst_27402 = (state_27425[(2)]);
var inst_27403 = (inst_27385 + (1));
var inst_27385__$1 = inst_27403;
var state_27425__$1 = (function (){var statearr_27580 = state_27425;
(statearr_27580[(14)] = inst_27402);

(statearr_27580[(7)] = inst_27385__$1);

return statearr_27580;
})();
var statearr_27582_28860 = state_27425__$1;
(statearr_27582_28860[(2)] = null);

(statearr_27582_28860[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27426 === (8))){
var inst_27407 = (state_27425[(2)]);
var state_27425__$1 = state_27425;
var statearr_27586_28861 = state_27425__$1;
(statearr_27586_28861[(2)] = inst_27407);

(statearr_27586_28861[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__24799__auto__ = null;
var cljs$core$async$state_machine__24799__auto____0 = (function (){
var statearr_27594 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27594[(0)] = cljs$core$async$state_machine__24799__auto__);

(statearr_27594[(1)] = (1));

return statearr_27594;
});
var cljs$core$async$state_machine__24799__auto____1 = (function (state_27425){
while(true){
var ret_value__24800__auto__ = (function (){try{while(true){
var result__24801__auto__ = switch__24798__auto__(state_27425);
if(cljs.core.keyword_identical_QMARK_(result__24801__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24801__auto__;
}
break;
}
}catch (e27596){var ex__24802__auto__ = e27596;
var statearr_27597_28862 = state_27425;
(statearr_27597_28862[(2)] = ex__24802__auto__);


if(cljs.core.seq((state_27425[(4)]))){
var statearr_27598_28863 = state_27425;
(statearr_27598_28863[(1)] = cljs.core.first((state_27425[(4)])));

} else {
throw ex__24802__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28865 = state_27425;
state_27425 = G__28865;
continue;
} else {
return ret_value__24800__auto__;
}
break;
}
});
cljs$core$async$state_machine__24799__auto__ = function(state_27425){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24799__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24799__auto____1.call(this,state_27425);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24799__auto____0;
cljs$core$async$state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24799__auto____1;
return cljs$core$async$state_machine__24799__auto__;
})()
})();
var state__25171__auto__ = (function (){var statearr_27687 = f__25170__auto__();
(statearr_27687[(6)] = c__25169__auto___28829);

return statearr_27687;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25171__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__27702 = arguments.length;
switch (G__27702) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__25169__auto___28867 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25170__auto__ = (function (){var switch__24798__auto__ = (function (state_27739){
var state_val_27740 = (state_27739[(1)]);
if((state_val_27740 === (7))){
var inst_27713 = (state_27739[(7)]);
var inst_27714 = (state_27739[(8)]);
var inst_27713__$1 = (state_27739[(2)]);
var inst_27714__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27713__$1,(0),null);
var inst_27715 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27713__$1,(1),null);
var inst_27716 = (inst_27714__$1 == null);
var state_27739__$1 = (function (){var statearr_27741 = state_27739;
(statearr_27741[(7)] = inst_27713__$1);

(statearr_27741[(8)] = inst_27714__$1);

(statearr_27741[(9)] = inst_27715);

return statearr_27741;
})();
if(cljs.core.truth_(inst_27716)){
var statearr_27742_28868 = state_27739__$1;
(statearr_27742_28868[(1)] = (8));

} else {
var statearr_27743_28869 = state_27739__$1;
(statearr_27743_28869[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27740 === (1))){
var inst_27703 = cljs.core.vec(chs);
var inst_27704 = inst_27703;
var state_27739__$1 = (function (){var statearr_27744 = state_27739;
(statearr_27744[(10)] = inst_27704);

return statearr_27744;
})();
var statearr_27745_28870 = state_27739__$1;
(statearr_27745_28870[(2)] = null);

(statearr_27745_28870[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27740 === (4))){
var inst_27704 = (state_27739[(10)]);
var state_27739__$1 = state_27739;
return cljs.core.async.ioc_alts_BANG_(state_27739__$1,(7),inst_27704);
} else {
if((state_val_27740 === (6))){
var inst_27735 = (state_27739[(2)]);
var state_27739__$1 = state_27739;
var statearr_27746_28871 = state_27739__$1;
(statearr_27746_28871[(2)] = inst_27735);

(statearr_27746_28871[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27740 === (3))){
var inst_27737 = (state_27739[(2)]);
var state_27739__$1 = state_27739;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27739__$1,inst_27737);
} else {
if((state_val_27740 === (2))){
var inst_27704 = (state_27739[(10)]);
var inst_27706 = cljs.core.count(inst_27704);
var inst_27707 = (inst_27706 > (0));
var state_27739__$1 = state_27739;
if(cljs.core.truth_(inst_27707)){
var statearr_27748_28872 = state_27739__$1;
(statearr_27748_28872[(1)] = (4));

} else {
var statearr_27749_28873 = state_27739__$1;
(statearr_27749_28873[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27740 === (11))){
var inst_27704 = (state_27739[(10)]);
var inst_27728 = (state_27739[(2)]);
var tmp27747 = inst_27704;
var inst_27704__$1 = tmp27747;
var state_27739__$1 = (function (){var statearr_27750 = state_27739;
(statearr_27750[(11)] = inst_27728);

(statearr_27750[(10)] = inst_27704__$1);

return statearr_27750;
})();
var statearr_27751_28874 = state_27739__$1;
(statearr_27751_28874[(2)] = null);

(statearr_27751_28874[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27740 === (9))){
var inst_27714 = (state_27739[(8)]);
var state_27739__$1 = state_27739;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27739__$1,(11),out,inst_27714);
} else {
if((state_val_27740 === (5))){
var inst_27733 = cljs.core.async.close_BANG_(out);
var state_27739__$1 = state_27739;
var statearr_27759_28876 = state_27739__$1;
(statearr_27759_28876[(2)] = inst_27733);

(statearr_27759_28876[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27740 === (10))){
var inst_27731 = (state_27739[(2)]);
var state_27739__$1 = state_27739;
var statearr_27760_28877 = state_27739__$1;
(statearr_27760_28877[(2)] = inst_27731);

(statearr_27760_28877[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27740 === (8))){
var inst_27704 = (state_27739[(10)]);
var inst_27713 = (state_27739[(7)]);
var inst_27714 = (state_27739[(8)]);
var inst_27715 = (state_27739[(9)]);
var inst_27723 = (function (){var cs = inst_27704;
var vec__27709 = inst_27713;
var v = inst_27714;
var c = inst_27715;
return (function (p1__27692_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__27692_SHARP_);
});
})();
var inst_27724 = cljs.core.filterv(inst_27723,inst_27704);
var inst_27704__$1 = inst_27724;
var state_27739__$1 = (function (){var statearr_27761 = state_27739;
(statearr_27761[(10)] = inst_27704__$1);

return statearr_27761;
})();
var statearr_27762_28878 = state_27739__$1;
(statearr_27762_28878[(2)] = null);

(statearr_27762_28878[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__24799__auto__ = null;
var cljs$core$async$state_machine__24799__auto____0 = (function (){
var statearr_27763 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27763[(0)] = cljs$core$async$state_machine__24799__auto__);

(statearr_27763[(1)] = (1));

return statearr_27763;
});
var cljs$core$async$state_machine__24799__auto____1 = (function (state_27739){
while(true){
var ret_value__24800__auto__ = (function (){try{while(true){
var result__24801__auto__ = switch__24798__auto__(state_27739);
if(cljs.core.keyword_identical_QMARK_(result__24801__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24801__auto__;
}
break;
}
}catch (e27764){var ex__24802__auto__ = e27764;
var statearr_27765_28880 = state_27739;
(statearr_27765_28880[(2)] = ex__24802__auto__);


if(cljs.core.seq((state_27739[(4)]))){
var statearr_27766_28881 = state_27739;
(statearr_27766_28881[(1)] = cljs.core.first((state_27739[(4)])));

} else {
throw ex__24802__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28882 = state_27739;
state_27739 = G__28882;
continue;
} else {
return ret_value__24800__auto__;
}
break;
}
});
cljs$core$async$state_machine__24799__auto__ = function(state_27739){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24799__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24799__auto____1.call(this,state_27739);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24799__auto____0;
cljs$core$async$state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24799__auto____1;
return cljs$core$async$state_machine__24799__auto__;
})()
})();
var state__25171__auto__ = (function (){var statearr_27767 = f__25170__auto__();
(statearr_27767[(6)] = c__25169__auto___28867);

return statearr_27767;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25171__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__27769 = arguments.length;
switch (G__27769) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__25169__auto___28885 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25170__auto__ = (function (){var switch__24798__auto__ = (function (state_27799){
var state_val_27800 = (state_27799[(1)]);
if((state_val_27800 === (7))){
var inst_27781 = (state_27799[(7)]);
var inst_27781__$1 = (state_27799[(2)]);
var inst_27782 = (inst_27781__$1 == null);
var inst_27783 = cljs.core.not(inst_27782);
var state_27799__$1 = (function (){var statearr_27801 = state_27799;
(statearr_27801[(7)] = inst_27781__$1);

return statearr_27801;
})();
if(inst_27783){
var statearr_27802_28886 = state_27799__$1;
(statearr_27802_28886[(1)] = (8));

} else {
var statearr_27803_28887 = state_27799__$1;
(statearr_27803_28887[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27800 === (1))){
var inst_27776 = (0);
var state_27799__$1 = (function (){var statearr_27804 = state_27799;
(statearr_27804[(8)] = inst_27776);

return statearr_27804;
})();
var statearr_27805_28888 = state_27799__$1;
(statearr_27805_28888[(2)] = null);

(statearr_27805_28888[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27800 === (4))){
var state_27799__$1 = state_27799;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27799__$1,(7),ch);
} else {
if((state_val_27800 === (6))){
var inst_27794 = (state_27799[(2)]);
var state_27799__$1 = state_27799;
var statearr_27806_28889 = state_27799__$1;
(statearr_27806_28889[(2)] = inst_27794);

(statearr_27806_28889[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27800 === (3))){
var inst_27796 = (state_27799[(2)]);
var inst_27797 = cljs.core.async.close_BANG_(out);
var state_27799__$1 = (function (){var statearr_27807 = state_27799;
(statearr_27807[(9)] = inst_27796);

return statearr_27807;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_27799__$1,inst_27797);
} else {
if((state_val_27800 === (2))){
var inst_27776 = (state_27799[(8)]);
var inst_27778 = (inst_27776 < n);
var state_27799__$1 = state_27799;
if(cljs.core.truth_(inst_27778)){
var statearr_27808_28890 = state_27799__$1;
(statearr_27808_28890[(1)] = (4));

} else {
var statearr_27809_28891 = state_27799__$1;
(statearr_27809_28891[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27800 === (11))){
var inst_27776 = (state_27799[(8)]);
var inst_27786 = (state_27799[(2)]);
var inst_27787 = (inst_27776 + (1));
var inst_27776__$1 = inst_27787;
var state_27799__$1 = (function (){var statearr_27810 = state_27799;
(statearr_27810[(10)] = inst_27786);

(statearr_27810[(8)] = inst_27776__$1);

return statearr_27810;
})();
var statearr_27811_28951 = state_27799__$1;
(statearr_27811_28951[(2)] = null);

(statearr_27811_28951[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27800 === (9))){
var state_27799__$1 = state_27799;
var statearr_27826_28952 = state_27799__$1;
(statearr_27826_28952[(2)] = null);

(statearr_27826_28952[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27800 === (5))){
var state_27799__$1 = state_27799;
var statearr_27827_28953 = state_27799__$1;
(statearr_27827_28953[(2)] = null);

(statearr_27827_28953[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27800 === (10))){
var inst_27791 = (state_27799[(2)]);
var state_27799__$1 = state_27799;
var statearr_27828_28954 = state_27799__$1;
(statearr_27828_28954[(2)] = inst_27791);

(statearr_27828_28954[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27800 === (8))){
var inst_27781 = (state_27799[(7)]);
var state_27799__$1 = state_27799;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27799__$1,(11),out,inst_27781);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__24799__auto__ = null;
var cljs$core$async$state_machine__24799__auto____0 = (function (){
var statearr_27829 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27829[(0)] = cljs$core$async$state_machine__24799__auto__);

(statearr_27829[(1)] = (1));

return statearr_27829;
});
var cljs$core$async$state_machine__24799__auto____1 = (function (state_27799){
while(true){
var ret_value__24800__auto__ = (function (){try{while(true){
var result__24801__auto__ = switch__24798__auto__(state_27799);
if(cljs.core.keyword_identical_QMARK_(result__24801__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24801__auto__;
}
break;
}
}catch (e27830){var ex__24802__auto__ = e27830;
var statearr_27831_28955 = state_27799;
(statearr_27831_28955[(2)] = ex__24802__auto__);


if(cljs.core.seq((state_27799[(4)]))){
var statearr_27832_28958 = state_27799;
(statearr_27832_28958[(1)] = cljs.core.first((state_27799[(4)])));

} else {
throw ex__24802__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28960 = state_27799;
state_27799 = G__28960;
continue;
} else {
return ret_value__24800__auto__;
}
break;
}
});
cljs$core$async$state_machine__24799__auto__ = function(state_27799){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24799__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24799__auto____1.call(this,state_27799);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24799__auto____0;
cljs$core$async$state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24799__auto____1;
return cljs$core$async$state_machine__24799__auto__;
})()
})();
var state__25171__auto__ = (function (){var statearr_27833 = f__25170__auto__();
(statearr_27833[(6)] = c__25169__auto___28885);

return statearr_27833;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25171__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27839 = (function (f,ch,meta27836,_,fn1,meta27840){
this.f = f;
this.ch = ch;
this.meta27836 = meta27836;
this._ = _;
this.fn1 = fn1;
this.meta27840 = meta27840;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async27839.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_27841,meta27840__$1){
var self__ = this;
var _27841__$1 = this;
return (new cljs.core.async.t_cljs$core$async27839(self__.f,self__.ch,self__.meta27836,self__._,self__.fn1,meta27840__$1));
}));

(cljs.core.async.t_cljs$core$async27839.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_27841){
var self__ = this;
var _27841__$1 = this;
return self__.meta27840;
}));

(cljs.core.async.t_cljs$core$async27839.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async27839.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async27839.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async27839.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__27834_SHARP_){
var G__27843 = (((p1__27834_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__27834_SHARP_) : self__.f.call(null, p1__27834_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__27843) : f1.call(null, G__27843));
});
}));

(cljs.core.async.t_cljs$core$async27839.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta27836","meta27836",-491346652,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async27835","cljs.core.async/t_cljs$core$async27835",-1431165353,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta27840","meta27840",1837601017,null)], null);
}));

(cljs.core.async.t_cljs$core$async27839.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async27839.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27839");

(cljs.core.async.t_cljs$core$async27839.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async27839");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async27839.
 */
cljs.core.async.__GT_t_cljs$core$async27839 = (function cljs$core$async$__GT_t_cljs$core$async27839(f,ch,meta27836,_,fn1,meta27840){
return (new cljs.core.async.t_cljs$core$async27839(f,ch,meta27836,_,fn1,meta27840));
});



/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27835 = (function (f,ch,meta27836){
this.f = f;
this.ch = ch;
this.meta27836 = meta27836;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async27835.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_27837,meta27836__$1){
var self__ = this;
var _27837__$1 = this;
return (new cljs.core.async.t_cljs$core$async27835(self__.f,self__.ch,meta27836__$1));
}));

(cljs.core.async.t_cljs$core$async27835.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_27837){
var self__ = this;
var _27837__$1 = this;
return self__.meta27836;
}));

(cljs.core.async.t_cljs$core$async27835.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async27835.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async27835.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async27835.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async27835.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(new cljs.core.async.t_cljs$core$async27839(self__.f,self__.ch,self__.meta27836,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY)));
if(cljs.core.truth_((function (){var and__5000__auto__ = ret;
if(cljs.core.truth_(and__5000__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__5000__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__27844 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__27844) : self__.f.call(null, G__27844));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async27835.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async27835.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async27835.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta27836","meta27836",-491346652,null)], null);
}));

(cljs.core.async.t_cljs$core$async27835.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async27835.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27835");

(cljs.core.async.t_cljs$core$async27835.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async27835");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async27835.
 */
cljs.core.async.__GT_t_cljs$core$async27835 = (function cljs$core$async$__GT_t_cljs$core$async27835(f,ch,meta27836){
return (new cljs.core.async.t_cljs$core$async27835(f,ch,meta27836));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
return (new cljs.core.async.t_cljs$core$async27835(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27852 = (function (f,ch,meta27853){
this.f = f;
this.ch = ch;
this.meta27853 = meta27853;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async27852.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_27854,meta27853__$1){
var self__ = this;
var _27854__$1 = this;
return (new cljs.core.async.t_cljs$core$async27852(self__.f,self__.ch,meta27853__$1));
}));

(cljs.core.async.t_cljs$core$async27852.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_27854){
var self__ = this;
var _27854__$1 = this;
return self__.meta27853;
}));

(cljs.core.async.t_cljs$core$async27852.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async27852.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async27852.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async27852.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async27852.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async27852.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null, val)),fn1);
}));

(cljs.core.async.t_cljs$core$async27852.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta27853","meta27853",-844312775,null)], null);
}));

(cljs.core.async.t_cljs$core$async27852.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async27852.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27852");

(cljs.core.async.t_cljs$core$async27852.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async27852");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async27852.
 */
cljs.core.async.__GT_t_cljs$core$async27852 = (function cljs$core$async$__GT_t_cljs$core$async27852(f,ch,meta27853){
return (new cljs.core.async.t_cljs$core$async27852(f,ch,meta27853));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
return (new cljs.core.async.t_cljs$core$async27852(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27855 = (function (p,ch,meta27856){
this.p = p;
this.ch = ch;
this.meta27856 = meta27856;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async27855.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_27857,meta27856__$1){
var self__ = this;
var _27857__$1 = this;
return (new cljs.core.async.t_cljs$core$async27855(self__.p,self__.ch,meta27856__$1));
}));

(cljs.core.async.t_cljs$core$async27855.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_27857){
var self__ = this;
var _27857__$1 = this;
return self__.meta27856;
}));

(cljs.core.async.t_cljs$core$async27855.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async27855.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async27855.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async27855.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async27855.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async27855.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async27855.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null, val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async27855.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta27856","meta27856",-342219301,null)], null);
}));

(cljs.core.async.t_cljs$core$async27855.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async27855.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27855");

(cljs.core.async.t_cljs$core$async27855.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async27855");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async27855.
 */
cljs.core.async.__GT_t_cljs$core$async27855 = (function cljs$core$async$__GT_t_cljs$core$async27855(p,ch,meta27856){
return (new cljs.core.async.t_cljs$core$async27855(p,ch,meta27856));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
return (new cljs.core.async.t_cljs$core$async27855(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__27881 = arguments.length;
switch (G__27881) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__25169__auto___28994 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25170__auto__ = (function (){var switch__24798__auto__ = (function (state_27902){
var state_val_27903 = (state_27902[(1)]);
if((state_val_27903 === (7))){
var inst_27898 = (state_27902[(2)]);
var state_27902__$1 = state_27902;
var statearr_27904_28997 = state_27902__$1;
(statearr_27904_28997[(2)] = inst_27898);

(statearr_27904_28997[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27903 === (1))){
var state_27902__$1 = state_27902;
var statearr_27905_28999 = state_27902__$1;
(statearr_27905_28999[(2)] = null);

(statearr_27905_28999[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27903 === (4))){
var inst_27884 = (state_27902[(7)]);
var inst_27884__$1 = (state_27902[(2)]);
var inst_27885 = (inst_27884__$1 == null);
var state_27902__$1 = (function (){var statearr_27906 = state_27902;
(statearr_27906[(7)] = inst_27884__$1);

return statearr_27906;
})();
if(cljs.core.truth_(inst_27885)){
var statearr_27907_29001 = state_27902__$1;
(statearr_27907_29001[(1)] = (5));

} else {
var statearr_27908_29002 = state_27902__$1;
(statearr_27908_29002[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27903 === (6))){
var inst_27884 = (state_27902[(7)]);
var inst_27889 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_27884) : p.call(null, inst_27884));
var state_27902__$1 = state_27902;
if(cljs.core.truth_(inst_27889)){
var statearr_27909_29003 = state_27902__$1;
(statearr_27909_29003[(1)] = (8));

} else {
var statearr_27910_29004 = state_27902__$1;
(statearr_27910_29004[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27903 === (3))){
var inst_27900 = (state_27902[(2)]);
var state_27902__$1 = state_27902;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27902__$1,inst_27900);
} else {
if((state_val_27903 === (2))){
var state_27902__$1 = state_27902;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27902__$1,(4),ch);
} else {
if((state_val_27903 === (11))){
var inst_27892 = (state_27902[(2)]);
var state_27902__$1 = state_27902;
var statearr_27911_29006 = state_27902__$1;
(statearr_27911_29006[(2)] = inst_27892);

(statearr_27911_29006[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27903 === (9))){
var state_27902__$1 = state_27902;
var statearr_27912_29007 = state_27902__$1;
(statearr_27912_29007[(2)] = null);

(statearr_27912_29007[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27903 === (5))){
var inst_27887 = cljs.core.async.close_BANG_(out);
var state_27902__$1 = state_27902;
var statearr_27913_29010 = state_27902__$1;
(statearr_27913_29010[(2)] = inst_27887);

(statearr_27913_29010[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27903 === (10))){
var inst_27895 = (state_27902[(2)]);
var state_27902__$1 = (function (){var statearr_27914 = state_27902;
(statearr_27914[(8)] = inst_27895);

return statearr_27914;
})();
var statearr_27915_29011 = state_27902__$1;
(statearr_27915_29011[(2)] = null);

(statearr_27915_29011[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27903 === (8))){
var inst_27884 = (state_27902[(7)]);
var state_27902__$1 = state_27902;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27902__$1,(11),out,inst_27884);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__24799__auto__ = null;
var cljs$core$async$state_machine__24799__auto____0 = (function (){
var statearr_27916 = [null,null,null,null,null,null,null,null,null];
(statearr_27916[(0)] = cljs$core$async$state_machine__24799__auto__);

(statearr_27916[(1)] = (1));

return statearr_27916;
});
var cljs$core$async$state_machine__24799__auto____1 = (function (state_27902){
while(true){
var ret_value__24800__auto__ = (function (){try{while(true){
var result__24801__auto__ = switch__24798__auto__(state_27902);
if(cljs.core.keyword_identical_QMARK_(result__24801__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24801__auto__;
}
break;
}
}catch (e27917){var ex__24802__auto__ = e27917;
var statearr_27918_29012 = state_27902;
(statearr_27918_29012[(2)] = ex__24802__auto__);


if(cljs.core.seq((state_27902[(4)]))){
var statearr_27919_29013 = state_27902;
(statearr_27919_29013[(1)] = cljs.core.first((state_27902[(4)])));

} else {
throw ex__24802__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29014 = state_27902;
state_27902 = G__29014;
continue;
} else {
return ret_value__24800__auto__;
}
break;
}
});
cljs$core$async$state_machine__24799__auto__ = function(state_27902){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24799__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24799__auto____1.call(this,state_27902);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24799__auto____0;
cljs$core$async$state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24799__auto____1;
return cljs$core$async$state_machine__24799__auto__;
})()
})();
var state__25171__auto__ = (function (){var statearr_27920 = f__25170__auto__();
(statearr_27920[(6)] = c__25169__auto___28994);

return statearr_27920;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25171__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__27922 = arguments.length;
switch (G__27922) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__25169__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25170__auto__ = (function (){var switch__24798__auto__ = (function (state_27984){
var state_val_27985 = (state_27984[(1)]);
if((state_val_27985 === (7))){
var inst_27980 = (state_27984[(2)]);
var state_27984__$1 = state_27984;
var statearr_27986_29024 = state_27984__$1;
(statearr_27986_29024[(2)] = inst_27980);

(statearr_27986_29024[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27985 === (20))){
var inst_27950 = (state_27984[(7)]);
var inst_27961 = (state_27984[(2)]);
var inst_27962 = cljs.core.next(inst_27950);
var inst_27936 = inst_27962;
var inst_27937 = null;
var inst_27938 = (0);
var inst_27939 = (0);
var state_27984__$1 = (function (){var statearr_27987 = state_27984;
(statearr_27987[(8)] = inst_27961);

(statearr_27987[(9)] = inst_27936);

(statearr_27987[(10)] = inst_27937);

(statearr_27987[(11)] = inst_27938);

(statearr_27987[(12)] = inst_27939);

return statearr_27987;
})();
var statearr_27988_29026 = state_27984__$1;
(statearr_27988_29026[(2)] = null);

(statearr_27988_29026[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27985 === (1))){
var state_27984__$1 = state_27984;
var statearr_27989_29027 = state_27984__$1;
(statearr_27989_29027[(2)] = null);

(statearr_27989_29027[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27985 === (4))){
var inst_27925 = (state_27984[(13)]);
var inst_27925__$1 = (state_27984[(2)]);
var inst_27926 = (inst_27925__$1 == null);
var state_27984__$1 = (function (){var statearr_27990 = state_27984;
(statearr_27990[(13)] = inst_27925__$1);

return statearr_27990;
})();
if(cljs.core.truth_(inst_27926)){
var statearr_27991_29029 = state_27984__$1;
(statearr_27991_29029[(1)] = (5));

} else {
var statearr_27992_29030 = state_27984__$1;
(statearr_27992_29030[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27985 === (15))){
var state_27984__$1 = state_27984;
var statearr_27996_29031 = state_27984__$1;
(statearr_27996_29031[(2)] = null);

(statearr_27996_29031[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27985 === (21))){
var state_27984__$1 = state_27984;
var statearr_27997_29034 = state_27984__$1;
(statearr_27997_29034[(2)] = null);

(statearr_27997_29034[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27985 === (13))){
var inst_27939 = (state_27984[(12)]);
var inst_27936 = (state_27984[(9)]);
var inst_27937 = (state_27984[(10)]);
var inst_27938 = (state_27984[(11)]);
var inst_27946 = (state_27984[(2)]);
var inst_27947 = (inst_27939 + (1));
var tmp27993 = inst_27937;
var tmp27994 = inst_27936;
var tmp27995 = inst_27938;
var inst_27936__$1 = tmp27994;
var inst_27937__$1 = tmp27993;
var inst_27938__$1 = tmp27995;
var inst_27939__$1 = inst_27947;
var state_27984__$1 = (function (){var statearr_27998 = state_27984;
(statearr_27998[(14)] = inst_27946);

(statearr_27998[(9)] = inst_27936__$1);

(statearr_27998[(10)] = inst_27937__$1);

(statearr_27998[(11)] = inst_27938__$1);

(statearr_27998[(12)] = inst_27939__$1);

return statearr_27998;
})();
var statearr_27999_29036 = state_27984__$1;
(statearr_27999_29036[(2)] = null);

(statearr_27999_29036[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27985 === (22))){
var state_27984__$1 = state_27984;
var statearr_28000_29037 = state_27984__$1;
(statearr_28000_29037[(2)] = null);

(statearr_28000_29037[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27985 === (6))){
var inst_27925 = (state_27984[(13)]);
var inst_27934 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_27925) : f.call(null, inst_27925));
var inst_27935 = cljs.core.seq(inst_27934);
var inst_27936 = inst_27935;
var inst_27937 = null;
var inst_27938 = (0);
var inst_27939 = (0);
var state_27984__$1 = (function (){var statearr_28001 = state_27984;
(statearr_28001[(9)] = inst_27936);

(statearr_28001[(10)] = inst_27937);

(statearr_28001[(11)] = inst_27938);

(statearr_28001[(12)] = inst_27939);

return statearr_28001;
})();
var statearr_28002_29038 = state_27984__$1;
(statearr_28002_29038[(2)] = null);

(statearr_28002_29038[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27985 === (17))){
var inst_27950 = (state_27984[(7)]);
var inst_27954 = cljs.core.chunk_first(inst_27950);
var inst_27955 = cljs.core.chunk_rest(inst_27950);
var inst_27956 = cljs.core.count(inst_27954);
var inst_27936 = inst_27955;
var inst_27937 = inst_27954;
var inst_27938 = inst_27956;
var inst_27939 = (0);
var state_27984__$1 = (function (){var statearr_28003 = state_27984;
(statearr_28003[(9)] = inst_27936);

(statearr_28003[(10)] = inst_27937);

(statearr_28003[(11)] = inst_27938);

(statearr_28003[(12)] = inst_27939);

return statearr_28003;
})();
var statearr_28005_29039 = state_27984__$1;
(statearr_28005_29039[(2)] = null);

(statearr_28005_29039[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27985 === (3))){
var inst_27982 = (state_27984[(2)]);
var state_27984__$1 = state_27984;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27984__$1,inst_27982);
} else {
if((state_val_27985 === (12))){
var inst_27970 = (state_27984[(2)]);
var state_27984__$1 = state_27984;
var statearr_28006_29043 = state_27984__$1;
(statearr_28006_29043[(2)] = inst_27970);

(statearr_28006_29043[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27985 === (2))){
var state_27984__$1 = state_27984;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27984__$1,(4),in$);
} else {
if((state_val_27985 === (23))){
var inst_27978 = (state_27984[(2)]);
var state_27984__$1 = state_27984;
var statearr_28007_29044 = state_27984__$1;
(statearr_28007_29044[(2)] = inst_27978);

(statearr_28007_29044[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27985 === (19))){
var inst_27965 = (state_27984[(2)]);
var state_27984__$1 = state_27984;
var statearr_28009_29045 = state_27984__$1;
(statearr_28009_29045[(2)] = inst_27965);

(statearr_28009_29045[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27985 === (11))){
var inst_27936 = (state_27984[(9)]);
var inst_27950 = (state_27984[(7)]);
var inst_27950__$1 = cljs.core.seq(inst_27936);
var state_27984__$1 = (function (){var statearr_28010 = state_27984;
(statearr_28010[(7)] = inst_27950__$1);

return statearr_28010;
})();
if(inst_27950__$1){
var statearr_28011_29046 = state_27984__$1;
(statearr_28011_29046[(1)] = (14));

} else {
var statearr_28012_29047 = state_27984__$1;
(statearr_28012_29047[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27985 === (9))){
var inst_27972 = (state_27984[(2)]);
var inst_27973 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_27984__$1 = (function (){var statearr_28013 = state_27984;
(statearr_28013[(15)] = inst_27972);

return statearr_28013;
})();
if(cljs.core.truth_(inst_27973)){
var statearr_28014_29048 = state_27984__$1;
(statearr_28014_29048[(1)] = (21));

} else {
var statearr_28015_29049 = state_27984__$1;
(statearr_28015_29049[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27985 === (5))){
var inst_27928 = cljs.core.async.close_BANG_(out);
var state_27984__$1 = state_27984;
var statearr_28016_29050 = state_27984__$1;
(statearr_28016_29050[(2)] = inst_27928);

(statearr_28016_29050[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27985 === (14))){
var inst_27950 = (state_27984[(7)]);
var inst_27952 = cljs.core.chunked_seq_QMARK_(inst_27950);
var state_27984__$1 = state_27984;
if(inst_27952){
var statearr_28017_29051 = state_27984__$1;
(statearr_28017_29051[(1)] = (17));

} else {
var statearr_28018_29052 = state_27984__$1;
(statearr_28018_29052[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27985 === (16))){
var inst_27968 = (state_27984[(2)]);
var state_27984__$1 = state_27984;
var statearr_28019_29053 = state_27984__$1;
(statearr_28019_29053[(2)] = inst_27968);

(statearr_28019_29053[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27985 === (10))){
var inst_27937 = (state_27984[(10)]);
var inst_27939 = (state_27984[(12)]);
var inst_27944 = cljs.core._nth(inst_27937,inst_27939);
var state_27984__$1 = state_27984;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27984__$1,(13),out,inst_27944);
} else {
if((state_val_27985 === (18))){
var inst_27950 = (state_27984[(7)]);
var inst_27959 = cljs.core.first(inst_27950);
var state_27984__$1 = state_27984;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27984__$1,(20),out,inst_27959);
} else {
if((state_val_27985 === (8))){
var inst_27939 = (state_27984[(12)]);
var inst_27938 = (state_27984[(11)]);
var inst_27941 = (inst_27939 < inst_27938);
var inst_27942 = inst_27941;
var state_27984__$1 = state_27984;
if(cljs.core.truth_(inst_27942)){
var statearr_28020_29057 = state_27984__$1;
(statearr_28020_29057[(1)] = (10));

} else {
var statearr_28021_29058 = state_27984__$1;
(statearr_28021_29058[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__24799__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__24799__auto____0 = (function (){
var statearr_28023 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28023[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__24799__auto__);

(statearr_28023[(1)] = (1));

return statearr_28023;
});
var cljs$core$async$mapcat_STAR__$_state_machine__24799__auto____1 = (function (state_27984){
while(true){
var ret_value__24800__auto__ = (function (){try{while(true){
var result__24801__auto__ = switch__24798__auto__(state_27984);
if(cljs.core.keyword_identical_QMARK_(result__24801__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24801__auto__;
}
break;
}
}catch (e28024){var ex__24802__auto__ = e28024;
var statearr_28025_29059 = state_27984;
(statearr_28025_29059[(2)] = ex__24802__auto__);


if(cljs.core.seq((state_27984[(4)]))){
var statearr_28026_29060 = state_27984;
(statearr_28026_29060[(1)] = cljs.core.first((state_27984[(4)])));

} else {
throw ex__24802__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29061 = state_27984;
state_27984 = G__29061;
continue;
} else {
return ret_value__24800__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__24799__auto__ = function(state_27984){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__24799__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__24799__auto____1.call(this,state_27984);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__24799__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__24799__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__24799__auto__;
})()
})();
var state__25171__auto__ = (function (){var statearr_28027 = f__25170__auto__();
(statearr_28027[(6)] = c__25169__auto__);

return statearr_28027;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25171__auto__);
}));

return c__25169__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__28029 = arguments.length;
switch (G__28029) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__28031 = arguments.length;
switch (G__28031) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__28033 = arguments.length;
switch (G__28033) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__25169__auto___29068 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25170__auto__ = (function (){var switch__24798__auto__ = (function (state_28057){
var state_val_28058 = (state_28057[(1)]);
if((state_val_28058 === (7))){
var inst_28052 = (state_28057[(2)]);
var state_28057__$1 = state_28057;
var statearr_28059_29069 = state_28057__$1;
(statearr_28059_29069[(2)] = inst_28052);

(statearr_28059_29069[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28058 === (1))){
var inst_28034 = null;
var state_28057__$1 = (function (){var statearr_28060 = state_28057;
(statearr_28060[(7)] = inst_28034);

return statearr_28060;
})();
var statearr_28061_29070 = state_28057__$1;
(statearr_28061_29070[(2)] = null);

(statearr_28061_29070[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28058 === (4))){
var inst_28037 = (state_28057[(8)]);
var inst_28037__$1 = (state_28057[(2)]);
var inst_28038 = (inst_28037__$1 == null);
var inst_28039 = cljs.core.not(inst_28038);
var state_28057__$1 = (function (){var statearr_28062 = state_28057;
(statearr_28062[(8)] = inst_28037__$1);

return statearr_28062;
})();
if(inst_28039){
var statearr_28063_29072 = state_28057__$1;
(statearr_28063_29072[(1)] = (5));

} else {
var statearr_28064_29073 = state_28057__$1;
(statearr_28064_29073[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28058 === (6))){
var state_28057__$1 = state_28057;
var statearr_28065_29074 = state_28057__$1;
(statearr_28065_29074[(2)] = null);

(statearr_28065_29074[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28058 === (3))){
var inst_28054 = (state_28057[(2)]);
var inst_28055 = cljs.core.async.close_BANG_(out);
var state_28057__$1 = (function (){var statearr_28066 = state_28057;
(statearr_28066[(9)] = inst_28054);

return statearr_28066;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_28057__$1,inst_28055);
} else {
if((state_val_28058 === (2))){
var state_28057__$1 = state_28057;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28057__$1,(4),ch);
} else {
if((state_val_28058 === (11))){
var inst_28037 = (state_28057[(8)]);
var inst_28046 = (state_28057[(2)]);
var inst_28034 = inst_28037;
var state_28057__$1 = (function (){var statearr_28067 = state_28057;
(statearr_28067[(10)] = inst_28046);

(statearr_28067[(7)] = inst_28034);

return statearr_28067;
})();
var statearr_28068_29075 = state_28057__$1;
(statearr_28068_29075[(2)] = null);

(statearr_28068_29075[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28058 === (9))){
var inst_28037 = (state_28057[(8)]);
var state_28057__$1 = state_28057;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28057__$1,(11),out,inst_28037);
} else {
if((state_val_28058 === (5))){
var inst_28037 = (state_28057[(8)]);
var inst_28034 = (state_28057[(7)]);
var inst_28041 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_28037,inst_28034);
var state_28057__$1 = state_28057;
if(inst_28041){
var statearr_28071_29078 = state_28057__$1;
(statearr_28071_29078[(1)] = (8));

} else {
var statearr_28072_29079 = state_28057__$1;
(statearr_28072_29079[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28058 === (10))){
var inst_28049 = (state_28057[(2)]);
var state_28057__$1 = state_28057;
var statearr_28073_29082 = state_28057__$1;
(statearr_28073_29082[(2)] = inst_28049);

(statearr_28073_29082[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28058 === (8))){
var inst_28034 = (state_28057[(7)]);
var tmp28070 = inst_28034;
var inst_28034__$1 = tmp28070;
var state_28057__$1 = (function (){var statearr_28074 = state_28057;
(statearr_28074[(7)] = inst_28034__$1);

return statearr_28074;
})();
var statearr_28075_29083 = state_28057__$1;
(statearr_28075_29083[(2)] = null);

(statearr_28075_29083[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__24799__auto__ = null;
var cljs$core$async$state_machine__24799__auto____0 = (function (){
var statearr_28081 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28081[(0)] = cljs$core$async$state_machine__24799__auto__);

(statearr_28081[(1)] = (1));

return statearr_28081;
});
var cljs$core$async$state_machine__24799__auto____1 = (function (state_28057){
while(true){
var ret_value__24800__auto__ = (function (){try{while(true){
var result__24801__auto__ = switch__24798__auto__(state_28057);
if(cljs.core.keyword_identical_QMARK_(result__24801__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24801__auto__;
}
break;
}
}catch (e28083){var ex__24802__auto__ = e28083;
var statearr_28084_29087 = state_28057;
(statearr_28084_29087[(2)] = ex__24802__auto__);


if(cljs.core.seq((state_28057[(4)]))){
var statearr_28085_29088 = state_28057;
(statearr_28085_29088[(1)] = cljs.core.first((state_28057[(4)])));

} else {
throw ex__24802__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29089 = state_28057;
state_28057 = G__29089;
continue;
} else {
return ret_value__24800__auto__;
}
break;
}
});
cljs$core$async$state_machine__24799__auto__ = function(state_28057){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24799__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24799__auto____1.call(this,state_28057);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24799__auto____0;
cljs$core$async$state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24799__auto____1;
return cljs$core$async$state_machine__24799__auto__;
})()
})();
var state__25171__auto__ = (function (){var statearr_28086 = f__25170__auto__();
(statearr_28086[(6)] = c__25169__auto___29068);

return statearr_28086;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25171__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__28088 = arguments.length;
switch (G__28088) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__25169__auto___29096 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25170__auto__ = (function (){var switch__24798__auto__ = (function (state_28132){
var state_val_28133 = (state_28132[(1)]);
if((state_val_28133 === (7))){
var inst_28128 = (state_28132[(2)]);
var state_28132__$1 = state_28132;
var statearr_28137_29097 = state_28132__$1;
(statearr_28137_29097[(2)] = inst_28128);

(statearr_28137_29097[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28133 === (1))){
var inst_28094 = (new Array(n));
var inst_28095 = inst_28094;
var inst_28096 = (0);
var state_28132__$1 = (function (){var statearr_28142 = state_28132;
(statearr_28142[(7)] = inst_28095);

(statearr_28142[(8)] = inst_28096);

return statearr_28142;
})();
var statearr_28143_29099 = state_28132__$1;
(statearr_28143_29099[(2)] = null);

(statearr_28143_29099[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28133 === (4))){
var inst_28100 = (state_28132[(9)]);
var inst_28100__$1 = (state_28132[(2)]);
var inst_28101 = (inst_28100__$1 == null);
var inst_28102 = cljs.core.not(inst_28101);
var state_28132__$1 = (function (){var statearr_28144 = state_28132;
(statearr_28144[(9)] = inst_28100__$1);

return statearr_28144;
})();
if(inst_28102){
var statearr_28145_29100 = state_28132__$1;
(statearr_28145_29100[(1)] = (5));

} else {
var statearr_28146_29101 = state_28132__$1;
(statearr_28146_29101[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28133 === (15))){
var inst_28122 = (state_28132[(2)]);
var state_28132__$1 = state_28132;
var statearr_28147_29102 = state_28132__$1;
(statearr_28147_29102[(2)] = inst_28122);

(statearr_28147_29102[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28133 === (13))){
var state_28132__$1 = state_28132;
var statearr_28151_29103 = state_28132__$1;
(statearr_28151_29103[(2)] = null);

(statearr_28151_29103[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28133 === (6))){
var inst_28096 = (state_28132[(8)]);
var inst_28118 = (inst_28096 > (0));
var state_28132__$1 = state_28132;
if(cljs.core.truth_(inst_28118)){
var statearr_28156_29106 = state_28132__$1;
(statearr_28156_29106[(1)] = (12));

} else {
var statearr_28157_29107 = state_28132__$1;
(statearr_28157_29107[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28133 === (3))){
var inst_28130 = (state_28132[(2)]);
var state_28132__$1 = state_28132;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28132__$1,inst_28130);
} else {
if((state_val_28133 === (12))){
var inst_28095 = (state_28132[(7)]);
var inst_28120 = cljs.core.vec(inst_28095);
var state_28132__$1 = state_28132;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28132__$1,(15),out,inst_28120);
} else {
if((state_val_28133 === (2))){
var state_28132__$1 = state_28132;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28132__$1,(4),ch);
} else {
if((state_val_28133 === (11))){
var inst_28112 = (state_28132[(2)]);
var inst_28113 = (new Array(n));
var inst_28095 = inst_28113;
var inst_28096 = (0);
var state_28132__$1 = (function (){var statearr_28159 = state_28132;
(statearr_28159[(10)] = inst_28112);

(statearr_28159[(7)] = inst_28095);

(statearr_28159[(8)] = inst_28096);

return statearr_28159;
})();
var statearr_28160_29110 = state_28132__$1;
(statearr_28160_29110[(2)] = null);

(statearr_28160_29110[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28133 === (9))){
var inst_28095 = (state_28132[(7)]);
var inst_28110 = cljs.core.vec(inst_28095);
var state_28132__$1 = state_28132;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28132__$1,(11),out,inst_28110);
} else {
if((state_val_28133 === (5))){
var inst_28095 = (state_28132[(7)]);
var inst_28096 = (state_28132[(8)]);
var inst_28100 = (state_28132[(9)]);
var inst_28105 = (state_28132[(11)]);
var inst_28104 = (inst_28095[inst_28096] = inst_28100);
var inst_28105__$1 = (inst_28096 + (1));
var inst_28106 = (inst_28105__$1 < n);
var state_28132__$1 = (function (){var statearr_28161 = state_28132;
(statearr_28161[(12)] = inst_28104);

(statearr_28161[(11)] = inst_28105__$1);

return statearr_28161;
})();
if(cljs.core.truth_(inst_28106)){
var statearr_28162_29112 = state_28132__$1;
(statearr_28162_29112[(1)] = (8));

} else {
var statearr_28163_29113 = state_28132__$1;
(statearr_28163_29113[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28133 === (14))){
var inst_28125 = (state_28132[(2)]);
var inst_28126 = cljs.core.async.close_BANG_(out);
var state_28132__$1 = (function (){var statearr_28165 = state_28132;
(statearr_28165[(13)] = inst_28125);

return statearr_28165;
})();
var statearr_28166_29114 = state_28132__$1;
(statearr_28166_29114[(2)] = inst_28126);

(statearr_28166_29114[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28133 === (10))){
var inst_28116 = (state_28132[(2)]);
var state_28132__$1 = state_28132;
var statearr_28167_29115 = state_28132__$1;
(statearr_28167_29115[(2)] = inst_28116);

(statearr_28167_29115[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28133 === (8))){
var inst_28095 = (state_28132[(7)]);
var inst_28105 = (state_28132[(11)]);
var tmp28164 = inst_28095;
var inst_28095__$1 = tmp28164;
var inst_28096 = inst_28105;
var state_28132__$1 = (function (){var statearr_28168 = state_28132;
(statearr_28168[(7)] = inst_28095__$1);

(statearr_28168[(8)] = inst_28096);

return statearr_28168;
})();
var statearr_28169_29116 = state_28132__$1;
(statearr_28169_29116[(2)] = null);

(statearr_28169_29116[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__24799__auto__ = null;
var cljs$core$async$state_machine__24799__auto____0 = (function (){
var statearr_28170 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28170[(0)] = cljs$core$async$state_machine__24799__auto__);

(statearr_28170[(1)] = (1));

return statearr_28170;
});
var cljs$core$async$state_machine__24799__auto____1 = (function (state_28132){
while(true){
var ret_value__24800__auto__ = (function (){try{while(true){
var result__24801__auto__ = switch__24798__auto__(state_28132);
if(cljs.core.keyword_identical_QMARK_(result__24801__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24801__auto__;
}
break;
}
}catch (e28172){var ex__24802__auto__ = e28172;
var statearr_28173_29117 = state_28132;
(statearr_28173_29117[(2)] = ex__24802__auto__);


if(cljs.core.seq((state_28132[(4)]))){
var statearr_28174_29118 = state_28132;
(statearr_28174_29118[(1)] = cljs.core.first((state_28132[(4)])));

} else {
throw ex__24802__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29119 = state_28132;
state_28132 = G__29119;
continue;
} else {
return ret_value__24800__auto__;
}
break;
}
});
cljs$core$async$state_machine__24799__auto__ = function(state_28132){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24799__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24799__auto____1.call(this,state_28132);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24799__auto____0;
cljs$core$async$state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24799__auto____1;
return cljs$core$async$state_machine__24799__auto__;
})()
})();
var state__25171__auto__ = (function (){var statearr_28179 = f__25170__auto__();
(statearr_28179[(6)] = c__25169__auto___29096);

return statearr_28179;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25171__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__28182 = arguments.length;
switch (G__28182) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__25169__auto___29121 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25170__auto__ = (function (){var switch__24798__auto__ = (function (state_28240){
var state_val_28241 = (state_28240[(1)]);
if((state_val_28241 === (7))){
var inst_28235 = (state_28240[(2)]);
var state_28240__$1 = state_28240;
var statearr_28245_29122 = state_28240__$1;
(statearr_28245_29122[(2)] = inst_28235);

(statearr_28245_29122[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28241 === (1))){
var inst_28185 = [];
var inst_28186 = inst_28185;
var inst_28187 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_28240__$1 = (function (){var statearr_28247 = state_28240;
(statearr_28247[(7)] = inst_28186);

(statearr_28247[(8)] = inst_28187);

return statearr_28247;
})();
var statearr_28248_29123 = state_28240__$1;
(statearr_28248_29123[(2)] = null);

(statearr_28248_29123[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28241 === (4))){
var inst_28191 = (state_28240[(9)]);
var inst_28191__$1 = (state_28240[(2)]);
var inst_28192 = (inst_28191__$1 == null);
var inst_28193 = cljs.core.not(inst_28192);
var state_28240__$1 = (function (){var statearr_28250 = state_28240;
(statearr_28250[(9)] = inst_28191__$1);

return statearr_28250;
})();
if(inst_28193){
var statearr_28251_29124 = state_28240__$1;
(statearr_28251_29124[(1)] = (5));

} else {
var statearr_28252_29125 = state_28240__$1;
(statearr_28252_29125[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28241 === (15))){
var inst_28186 = (state_28240[(7)]);
var inst_28227 = cljs.core.vec(inst_28186);
var state_28240__$1 = state_28240;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28240__$1,(18),out,inst_28227);
} else {
if((state_val_28241 === (13))){
var inst_28222 = (state_28240[(2)]);
var state_28240__$1 = state_28240;
var statearr_28253_29126 = state_28240__$1;
(statearr_28253_29126[(2)] = inst_28222);

(statearr_28253_29126[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28241 === (6))){
var inst_28186 = (state_28240[(7)]);
var inst_28224 = inst_28186.length;
var inst_28225 = (inst_28224 > (0));
var state_28240__$1 = state_28240;
if(cljs.core.truth_(inst_28225)){
var statearr_28254_29127 = state_28240__$1;
(statearr_28254_29127[(1)] = (15));

} else {
var statearr_28255_29128 = state_28240__$1;
(statearr_28255_29128[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28241 === (17))){
var inst_28232 = (state_28240[(2)]);
var inst_28233 = cljs.core.async.close_BANG_(out);
var state_28240__$1 = (function (){var statearr_28256 = state_28240;
(statearr_28256[(10)] = inst_28232);

return statearr_28256;
})();
var statearr_28258_29129 = state_28240__$1;
(statearr_28258_29129[(2)] = inst_28233);

(statearr_28258_29129[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28241 === (3))){
var inst_28237 = (state_28240[(2)]);
var state_28240__$1 = state_28240;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28240__$1,inst_28237);
} else {
if((state_val_28241 === (12))){
var inst_28186 = (state_28240[(7)]);
var inst_28215 = cljs.core.vec(inst_28186);
var state_28240__$1 = state_28240;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28240__$1,(14),out,inst_28215);
} else {
if((state_val_28241 === (2))){
var state_28240__$1 = state_28240;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28240__$1,(4),ch);
} else {
if((state_val_28241 === (11))){
var inst_28186 = (state_28240[(7)]);
var inst_28191 = (state_28240[(9)]);
var inst_28195 = (state_28240[(11)]);
var inst_28212 = inst_28186.push(inst_28191);
var tmp28259 = inst_28186;
var inst_28186__$1 = tmp28259;
var inst_28187 = inst_28195;
var state_28240__$1 = (function (){var statearr_28260 = state_28240;
(statearr_28260[(12)] = inst_28212);

(statearr_28260[(7)] = inst_28186__$1);

(statearr_28260[(8)] = inst_28187);

return statearr_28260;
})();
var statearr_28261_29134 = state_28240__$1;
(statearr_28261_29134[(2)] = null);

(statearr_28261_29134[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28241 === (9))){
var inst_28187 = (state_28240[(8)]);
var inst_28208 = cljs.core.keyword_identical_QMARK_(inst_28187,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_28240__$1 = state_28240;
var statearr_28263_29135 = state_28240__$1;
(statearr_28263_29135[(2)] = inst_28208);

(statearr_28263_29135[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28241 === (5))){
var inst_28191 = (state_28240[(9)]);
var inst_28195 = (state_28240[(11)]);
var inst_28187 = (state_28240[(8)]);
var inst_28202 = (state_28240[(13)]);
var inst_28195__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_28191) : f.call(null, inst_28191));
var inst_28202__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_28195__$1,inst_28187);
var state_28240__$1 = (function (){var statearr_28267 = state_28240;
(statearr_28267[(11)] = inst_28195__$1);

(statearr_28267[(13)] = inst_28202__$1);

return statearr_28267;
})();
if(inst_28202__$1){
var statearr_28268_29136 = state_28240__$1;
(statearr_28268_29136[(1)] = (8));

} else {
var statearr_28269_29138 = state_28240__$1;
(statearr_28269_29138[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28241 === (14))){
var inst_28191 = (state_28240[(9)]);
var inst_28195 = (state_28240[(11)]);
var inst_28217 = (state_28240[(2)]);
var inst_28218 = [];
var inst_28219 = inst_28218.push(inst_28191);
var inst_28186 = inst_28218;
var inst_28187 = inst_28195;
var state_28240__$1 = (function (){var statearr_28271 = state_28240;
(statearr_28271[(14)] = inst_28217);

(statearr_28271[(15)] = inst_28219);

(statearr_28271[(7)] = inst_28186);

(statearr_28271[(8)] = inst_28187);

return statearr_28271;
})();
var statearr_28275_29140 = state_28240__$1;
(statearr_28275_29140[(2)] = null);

(statearr_28275_29140[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28241 === (16))){
var state_28240__$1 = state_28240;
var statearr_28278_29141 = state_28240__$1;
(statearr_28278_29141[(2)] = null);

(statearr_28278_29141[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28241 === (10))){
var inst_28210 = (state_28240[(2)]);
var state_28240__$1 = state_28240;
if(cljs.core.truth_(inst_28210)){
var statearr_28279_29142 = state_28240__$1;
(statearr_28279_29142[(1)] = (11));

} else {
var statearr_28280_29143 = state_28240__$1;
(statearr_28280_29143[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28241 === (18))){
var inst_28229 = (state_28240[(2)]);
var state_28240__$1 = state_28240;
var statearr_28281_29144 = state_28240__$1;
(statearr_28281_29144[(2)] = inst_28229);

(statearr_28281_29144[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28241 === (8))){
var inst_28202 = (state_28240[(13)]);
var state_28240__$1 = state_28240;
var statearr_28284_29146 = state_28240__$1;
(statearr_28284_29146[(2)] = inst_28202);

(statearr_28284_29146[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__24799__auto__ = null;
var cljs$core$async$state_machine__24799__auto____0 = (function (){
var statearr_28287 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28287[(0)] = cljs$core$async$state_machine__24799__auto__);

(statearr_28287[(1)] = (1));

return statearr_28287;
});
var cljs$core$async$state_machine__24799__auto____1 = (function (state_28240){
while(true){
var ret_value__24800__auto__ = (function (){try{while(true){
var result__24801__auto__ = switch__24798__auto__(state_28240);
if(cljs.core.keyword_identical_QMARK_(result__24801__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24801__auto__;
}
break;
}
}catch (e28288){var ex__24802__auto__ = e28288;
var statearr_28289_29148 = state_28240;
(statearr_28289_29148[(2)] = ex__24802__auto__);


if(cljs.core.seq((state_28240[(4)]))){
var statearr_28290_29149 = state_28240;
(statearr_28290_29149[(1)] = cljs.core.first((state_28240[(4)])));

} else {
throw ex__24802__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29150 = state_28240;
state_28240 = G__29150;
continue;
} else {
return ret_value__24800__auto__;
}
break;
}
});
cljs$core$async$state_machine__24799__auto__ = function(state_28240){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24799__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24799__auto____1.call(this,state_28240);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24799__auto____0;
cljs$core$async$state_machine__24799__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24799__auto____1;
return cljs$core$async$state_machine__24799__auto__;
})()
})();
var state__25171__auto__ = (function (){var statearr_28291 = f__25170__auto__();
(statearr_28291[(6)] = c__25169__auto___29121);

return statearr_28291;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25171__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
