// Compiled by ClojureScript 1.8.51 {}
goog.provide('hasch.core');
goog.require('cljs.core');
goog.require('hasch.benc');
goog.require('hasch.platform');
hasch.core.uuid4 = hasch.platform.uuid4;
hasch.core.uuid5 = hasch.platform.uuid5;
hasch.core.hash__GT_str = hasch.platform.hash__GT_str;
/**
 * Hash an edn value with SHA-512 by default or a compatible hash function of choice.
 */
hasch.core.edn_hash = (function hasch$core$edn_hash(var_args){
var args32071 = [];
var len__7280__auto___32074 = arguments.length;
var i__7281__auto___32075 = (0);
while(true){
if((i__7281__auto___32075 < len__7280__auto___32074)){
args32071.push((arguments[i__7281__auto___32075]));

var G__32076 = (i__7281__auto___32075 + (1));
i__7281__auto___32075 = G__32076;
continue;
} else {
}
break;
}

var G__32073 = args32071.length;
switch (G__32073) {
case 1:
return hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32071.length)].join('')));

}
});

hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$1 = (function (val){
return hasch.core.edn_hash.call(null,val,cljs.core.PersistentArrayMap.EMPTY);
});

hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$2 = (function (val,write_handlers){
return hasch.core.edn_hash.call(null,val,hasch.platform.sha512_message_digest,write_handlers);
});

hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$3 = (function (val,md_create_fn,write_handlers){
return cljs.core.map.call(null,(function (p1__32070_SHARP_){
if((p1__32070_SHARP_ < (0))){
return (p1__32070_SHARP_ + (256));
} else {
return p1__32070_SHARP_;
}
}),hasch.benc.digest.call(null,hasch.benc._coerce.call(null,val,md_create_fn,(function (){var or__6210__auto__ = write_handlers;
if(cljs.core.truth_(or__6210__auto__)){
return or__6210__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})()),md_create_fn));
});

hasch.core.edn_hash.cljs$lang$maxFixedArity = 3;
/**
 * Creates random UUID-4 without argument or UUID-5 for the argument value.
 * 
 *   Optionally an incognito-style write-handlers map can be supplied,
 *   which describes record serialization in terms of Clojure data
 *   structures.
 */
hasch.core.uuid = (function hasch$core$uuid(var_args){
var args32078 = [];
var len__7280__auto___32086 = arguments.length;
var i__7281__auto___32087 = (0);
while(true){
if((i__7281__auto___32087 < len__7280__auto___32086)){
args32078.push((arguments[i__7281__auto___32087]));

var G__32088 = (i__7281__auto___32087 + (1));
i__7281__auto___32087 = G__32088;
continue;
} else {
}
break;
}

var G__32082 = args32078.length;
switch (G__32082) {
case 0:
return hasch.core.uuid.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__7299__auto__ = (new cljs.core.IndexedSeq(args32078.slice((1)),(0),null));
return hasch.core.uuid.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7299__auto__);

}
});

hasch.core.uuid.cljs$core$IFn$_invoke$arity$0 = (function (){
return hasch.core.uuid4.call(null);
});

hasch.core.uuid.cljs$core$IFn$_invoke$arity$variadic = (function (val,p__32083){
var map__32084 = p__32083;
var map__32084__$1 = ((((!((map__32084 == null)))?((((map__32084.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32084.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32084):map__32084);
var write_handlers = cljs.core.get.call(null,map__32084__$1,new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911));
return hasch.core.uuid5.call(null,hasch.core.edn_hash.call(null,val,write_handlers));
});

hasch.core.uuid.cljs$lang$applyTo = (function (seq32079){
var G__32080 = cljs.core.first.call(null,seq32079);
var seq32079__$1 = cljs.core.next.call(null,seq32079);
return hasch.core.uuid.cljs$core$IFn$_invoke$arity$variadic(G__32080,seq32079__$1);
});

hasch.core.uuid.cljs$lang$maxFixedArity = (1);

//# sourceMappingURL=core.js.map