// Compiled by ClojureScript 1.8.51 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args28986 = [];
var len__7280__auto___28992 = arguments.length;
var i__7281__auto___28993 = (0);
while(true){
if((i__7281__auto___28993 < len__7280__auto___28992)){
args28986.push((arguments[i__7281__auto___28993]));

var G__28994 = (i__7281__auto___28993 + (1));
i__7281__auto___28993 = G__28994;
continue;
} else {
}
break;
}

var G__28988 = args28986.length;
switch (G__28988) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28986.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async28989 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28989 = (function (f,blockable,meta28990){
this.f = f;
this.blockable = blockable;
this.meta28990 = meta28990;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async28989.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28991,meta28990__$1){
var self__ = this;
var _28991__$1 = this;
return (new cljs.core.async.t_cljs$core$async28989(self__.f,self__.blockable,meta28990__$1));
});

cljs.core.async.t_cljs$core$async28989.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28991){
var self__ = this;
var _28991__$1 = this;
return self__.meta28990;
});

cljs.core.async.t_cljs$core$async28989.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async28989.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async28989.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async28989.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async28989.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta28990","meta28990",241684860,null)], null);
});

cljs.core.async.t_cljs$core$async28989.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28989.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28989";

cljs.core.async.t_cljs$core$async28989.cljs$lang$ctorPrWriter = (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write.call(null,writer__6817__auto__,"cljs.core.async/t_cljs$core$async28989");
});

cljs.core.async.__GT_t_cljs$core$async28989 = (function cljs$core$async$__GT_t_cljs$core$async28989(f__$1,blockable__$1,meta28990){
return (new cljs.core.async.t_cljs$core$async28989(f__$1,blockable__$1,meta28990));
});

}

return (new cljs.core.async.t_cljs$core$async28989(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args28998 = [];
var len__7280__auto___29001 = arguments.length;
var i__7281__auto___29002 = (0);
while(true){
if((i__7281__auto___29002 < len__7280__auto___29001)){
args28998.push((arguments[i__7281__auto___29002]));

var G__29003 = (i__7281__auto___29002 + (1));
i__7281__auto___29002 = G__29003;
continue;
} else {
}
break;
}

var G__29000 = args28998.length;
switch (G__29000) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28998.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args29005 = [];
var len__7280__auto___29008 = arguments.length;
var i__7281__auto___29009 = (0);
while(true){
if((i__7281__auto___29009 < len__7280__auto___29008)){
args29005.push((arguments[i__7281__auto___29009]));

var G__29010 = (i__7281__auto___29009 + (1));
i__7281__auto___29009 = G__29010;
continue;
} else {
}
break;
}

var G__29007 = args29005.length;
switch (G__29007) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29005.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args29012 = [];
var len__7280__auto___29015 = arguments.length;
var i__7281__auto___29016 = (0);
while(true){
if((i__7281__auto___29016 < len__7280__auto___29015)){
args29012.push((arguments[i__7281__auto___29016]));

var G__29017 = (i__7281__auto___29016 + (1));
i__7281__auto___29016 = G__29017;
continue;
} else {
}
break;
}

var G__29014 = args29012.length;
switch (G__29014) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29012.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_29019 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_29019);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_29019,ret){
return (function (){
return fn1.call(null,val_29019);
});})(val_29019,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args29020 = [];
var len__7280__auto___29023 = arguments.length;
var i__7281__auto___29024 = (0);
while(true){
if((i__7281__auto___29024 < len__7280__auto___29023)){
args29020.push((arguments[i__7281__auto___29024]));

var G__29025 = (i__7281__auto___29024 + (1));
i__7281__auto___29024 = G__29025;
continue;
} else {
}
break;
}

var G__29022 = args29020.length;
switch (G__29022) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29020.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__7125__auto___29027 = n;
var x_29028 = (0);
while(true){
if((x_29028 < n__7125__auto___29027)){
(a[x_29028] = (0));

var G__29029 = (x_29028 + (1));
x_29028 = G__29029;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__29030 = (i + (1));
i = G__29030;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async29034 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29034 = (function (alt_flag,flag,meta29035){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta29035 = meta29035;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async29034.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_29036,meta29035__$1){
var self__ = this;
var _29036__$1 = this;
return (new cljs.core.async.t_cljs$core$async29034(self__.alt_flag,self__.flag,meta29035__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async29034.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_29036){
var self__ = this;
var _29036__$1 = this;
return self__.meta29035;
});})(flag))
;

cljs.core.async.t_cljs$core$async29034.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async29034.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async29034.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async29034.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async29034.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta29035","meta29035",-1302646488,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async29034.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async29034.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29034";

cljs.core.async.t_cljs$core$async29034.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write.call(null,writer__6817__auto__,"cljs.core.async/t_cljs$core$async29034");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async29034 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async29034(alt_flag__$1,flag__$1,meta29035){
return (new cljs.core.async.t_cljs$core$async29034(alt_flag__$1,flag__$1,meta29035));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async29034(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async29040 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29040 = (function (alt_handler,flag,cb,meta29041){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta29041 = meta29041;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async29040.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29042,meta29041__$1){
var self__ = this;
var _29042__$1 = this;
return (new cljs.core.async.t_cljs$core$async29040(self__.alt_handler,self__.flag,self__.cb,meta29041__$1));
});

cljs.core.async.t_cljs$core$async29040.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29042){
var self__ = this;
var _29042__$1 = this;
return self__.meta29041;
});

cljs.core.async.t_cljs$core$async29040.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async29040.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async29040.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async29040.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async29040.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta29041","meta29041",-1790978554,null)], null);
});

cljs.core.async.t_cljs$core$async29040.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async29040.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29040";

cljs.core.async.t_cljs$core$async29040.cljs$lang$ctorPrWriter = (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write.call(null,writer__6817__auto__,"cljs.core.async/t_cljs$core$async29040");
});

cljs.core.async.__GT_t_cljs$core$async29040 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async29040(alt_handler__$1,flag__$1,cb__$1,meta29041){
return (new cljs.core.async.t_cljs$core$async29040(alt_handler__$1,flag__$1,cb__$1,meta29041));
});

}

return (new cljs.core.async.t_cljs$core$async29040(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__29043_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__29043_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__29044_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__29044_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__6210__auto__ = wport;
if(cljs.core.truth_(or__6210__auto__)){
return or__6210__auto__;
} else {
return port;
}
})()], null));
} else {
var G__29045 = (i + (1));
i = G__29045;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6210__auto__ = ret;
if(cljs.core.truth_(or__6210__auto__)){
return or__6210__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__6198__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__6198__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__6198__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7287__auto__ = [];
var len__7280__auto___29051 = arguments.length;
var i__7281__auto___29052 = (0);
while(true){
if((i__7281__auto___29052 < len__7280__auto___29051)){
args__7287__auto__.push((arguments[i__7281__auto___29052]));

var G__29053 = (i__7281__auto___29052 + (1));
i__7281__auto___29052 = G__29053;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((1) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7288__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__29048){
var map__29049 = p__29048;
var map__29049__$1 = ((((!((map__29049 == null)))?((((map__29049.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29049.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__29049):map__29049);
var opts = map__29049__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq29046){
var G__29047 = cljs.core.first.call(null,seq29046);
var seq29046__$1 = cljs.core.next.call(null,seq29046);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29047,seq29046__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args29054 = [];
var len__7280__auto___29104 = arguments.length;
var i__7281__auto___29105 = (0);
while(true){
if((i__7281__auto___29105 < len__7280__auto___29104)){
args29054.push((arguments[i__7281__auto___29105]));

var G__29106 = (i__7281__auto___29105 + (1));
i__7281__auto___29105 = G__29106;
continue;
} else {
}
break;
}

var G__29056 = args29054.length;
switch (G__29056) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29054.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__28309__auto___29108 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__28309__auto___29108){
return (function (){
var f__28310__auto__ = (function (){var switch__28294__auto__ = ((function (c__28309__auto___29108){
return (function (state_29080){
var state_val_29081 = (state_29080[(1)]);
if((state_val_29081 === (7))){
var inst_29076 = (state_29080[(2)]);
var state_29080__$1 = state_29080;
var statearr_29082_29109 = state_29080__$1;
(statearr_29082_29109[(2)] = inst_29076);

(statearr_29082_29109[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29081 === (1))){
var state_29080__$1 = state_29080;
var statearr_29083_29110 = state_29080__$1;
(statearr_29083_29110[(2)] = null);

(statearr_29083_29110[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29081 === (4))){
var inst_29059 = (state_29080[(7)]);
var inst_29059__$1 = (state_29080[(2)]);
var inst_29060 = (inst_29059__$1 == null);
var state_29080__$1 = (function (){var statearr_29084 = state_29080;
(statearr_29084[(7)] = inst_29059__$1);

return statearr_29084;
})();
if(cljs.core.truth_(inst_29060)){
var statearr_29085_29111 = state_29080__$1;
(statearr_29085_29111[(1)] = (5));

} else {
var statearr_29086_29112 = state_29080__$1;
(statearr_29086_29112[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29081 === (13))){
var state_29080__$1 = state_29080;
var statearr_29087_29113 = state_29080__$1;
(statearr_29087_29113[(2)] = null);

(statearr_29087_29113[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29081 === (6))){
var inst_29059 = (state_29080[(7)]);
var state_29080__$1 = state_29080;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29080__$1,(11),to,inst_29059);
} else {
if((state_val_29081 === (3))){
var inst_29078 = (state_29080[(2)]);
var state_29080__$1 = state_29080;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29080__$1,inst_29078);
} else {
if((state_val_29081 === (12))){
var state_29080__$1 = state_29080;
var statearr_29088_29114 = state_29080__$1;
(statearr_29088_29114[(2)] = null);

(statearr_29088_29114[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29081 === (2))){
var state_29080__$1 = state_29080;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29080__$1,(4),from);
} else {
if((state_val_29081 === (11))){
var inst_29069 = (state_29080[(2)]);
var state_29080__$1 = state_29080;
if(cljs.core.truth_(inst_29069)){
var statearr_29089_29115 = state_29080__$1;
(statearr_29089_29115[(1)] = (12));

} else {
var statearr_29090_29116 = state_29080__$1;
(statearr_29090_29116[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29081 === (9))){
var state_29080__$1 = state_29080;
var statearr_29091_29117 = state_29080__$1;
(statearr_29091_29117[(2)] = null);

(statearr_29091_29117[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29081 === (5))){
var state_29080__$1 = state_29080;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29092_29118 = state_29080__$1;
(statearr_29092_29118[(1)] = (8));

} else {
var statearr_29093_29119 = state_29080__$1;
(statearr_29093_29119[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29081 === (14))){
var inst_29074 = (state_29080[(2)]);
var state_29080__$1 = state_29080;
var statearr_29094_29120 = state_29080__$1;
(statearr_29094_29120[(2)] = inst_29074);

(statearr_29094_29120[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29081 === (10))){
var inst_29066 = (state_29080[(2)]);
var state_29080__$1 = state_29080;
var statearr_29095_29121 = state_29080__$1;
(statearr_29095_29121[(2)] = inst_29066);

(statearr_29095_29121[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29081 === (8))){
var inst_29063 = cljs.core.async.close_BANG_.call(null,to);
var state_29080__$1 = state_29080;
var statearr_29096_29122 = state_29080__$1;
(statearr_29096_29122[(2)] = inst_29063);

(statearr_29096_29122[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__28309__auto___29108))
;
return ((function (switch__28294__auto__,c__28309__auto___29108){
return (function() {
var cljs$core$async$state_machine__28295__auto__ = null;
var cljs$core$async$state_machine__28295__auto____0 = (function (){
var statearr_29100 = [null,null,null,null,null,null,null,null];
(statearr_29100[(0)] = cljs$core$async$state_machine__28295__auto__);

(statearr_29100[(1)] = (1));

return statearr_29100;
});
var cljs$core$async$state_machine__28295__auto____1 = (function (state_29080){
while(true){
var ret_value__28296__auto__ = (function (){try{while(true){
var result__28297__auto__ = switch__28294__auto__.call(null,state_29080);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28297__auto__;
}
break;
}
}catch (e29101){if((e29101 instanceof Object)){
var ex__28298__auto__ = e29101;
var statearr_29102_29123 = state_29080;
(statearr_29102_29123[(5)] = ex__28298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29080);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29101;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29124 = state_29080;
state_29080 = G__29124;
continue;
} else {
return ret_value__28296__auto__;
}
break;
}
});
cljs$core$async$state_machine__28295__auto__ = function(state_29080){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28295__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28295__auto____1.call(this,state_29080);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28295__auto____0;
cljs$core$async$state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28295__auto____1;
return cljs$core$async$state_machine__28295__auto__;
})()
;})(switch__28294__auto__,c__28309__auto___29108))
})();
var state__28311__auto__ = (function (){var statearr_29103 = f__28310__auto__.call(null);
(statearr_29103[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28309__auto___29108);

return statearr_29103;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28311__auto__);
});})(c__28309__auto___29108))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__29308){
var vec__29309 = p__29308;
var v = cljs.core.nth.call(null,vec__29309,(0),null);
var p = cljs.core.nth.call(null,vec__29309,(1),null);
var job = vec__29309;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__28309__auto___29491 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__28309__auto___29491,res,vec__29309,v,p,job,jobs,results){
return (function (){
var f__28310__auto__ = (function (){var switch__28294__auto__ = ((function (c__28309__auto___29491,res,vec__29309,v,p,job,jobs,results){
return (function (state_29314){
var state_val_29315 = (state_29314[(1)]);
if((state_val_29315 === (1))){
var state_29314__$1 = state_29314;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29314__$1,(2),res,v);
} else {
if((state_val_29315 === (2))){
var inst_29311 = (state_29314[(2)]);
var inst_29312 = cljs.core.async.close_BANG_.call(null,res);
var state_29314__$1 = (function (){var statearr_29316 = state_29314;
(statearr_29316[(7)] = inst_29311);

return statearr_29316;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29314__$1,inst_29312);
} else {
return null;
}
}
});})(c__28309__auto___29491,res,vec__29309,v,p,job,jobs,results))
;
return ((function (switch__28294__auto__,c__28309__auto___29491,res,vec__29309,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28295__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28295__auto____0 = (function (){
var statearr_29320 = [null,null,null,null,null,null,null,null];
(statearr_29320[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28295__auto__);

(statearr_29320[(1)] = (1));

return statearr_29320;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28295__auto____1 = (function (state_29314){
while(true){
var ret_value__28296__auto__ = (function (){try{while(true){
var result__28297__auto__ = switch__28294__auto__.call(null,state_29314);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28297__auto__;
}
break;
}
}catch (e29321){if((e29321 instanceof Object)){
var ex__28298__auto__ = e29321;
var statearr_29322_29492 = state_29314;
(statearr_29322_29492[(5)] = ex__28298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29314);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29321;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29493 = state_29314;
state_29314 = G__29493;
continue;
} else {
return ret_value__28296__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28295__auto__ = function(state_29314){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28295__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28295__auto____1.call(this,state_29314);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28295__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28295__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28295__auto__;
})()
;})(switch__28294__auto__,c__28309__auto___29491,res,vec__29309,v,p,job,jobs,results))
})();
var state__28311__auto__ = (function (){var statearr_29323 = f__28310__auto__.call(null);
(statearr_29323[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28309__auto___29491);

return statearr_29323;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28311__auto__);
});})(c__28309__auto___29491,res,vec__29309,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__29324){
var vec__29325 = p__29324;
var v = cljs.core.nth.call(null,vec__29325,(0),null);
var p = cljs.core.nth.call(null,vec__29325,(1),null);
var job = vec__29325;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__7125__auto___29494 = n;
var __29495 = (0);
while(true){
if((__29495 < n__7125__auto___29494)){
var G__29326_29496 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__29326_29496) {
case "compute":
var c__28309__auto___29498 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__29495,c__28309__auto___29498,G__29326_29496,n__7125__auto___29494,jobs,results,process,async){
return (function (){
var f__28310__auto__ = (function (){var switch__28294__auto__ = ((function (__29495,c__28309__auto___29498,G__29326_29496,n__7125__auto___29494,jobs,results,process,async){
return (function (state_29339){
var state_val_29340 = (state_29339[(1)]);
if((state_val_29340 === (1))){
var state_29339__$1 = state_29339;
var statearr_29341_29499 = state_29339__$1;
(statearr_29341_29499[(2)] = null);

(statearr_29341_29499[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29340 === (2))){
var state_29339__$1 = state_29339;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29339__$1,(4),jobs);
} else {
if((state_val_29340 === (3))){
var inst_29337 = (state_29339[(2)]);
var state_29339__$1 = state_29339;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29339__$1,inst_29337);
} else {
if((state_val_29340 === (4))){
var inst_29329 = (state_29339[(2)]);
var inst_29330 = process.call(null,inst_29329);
var state_29339__$1 = state_29339;
if(cljs.core.truth_(inst_29330)){
var statearr_29342_29500 = state_29339__$1;
(statearr_29342_29500[(1)] = (5));

} else {
var statearr_29343_29501 = state_29339__$1;
(statearr_29343_29501[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29340 === (5))){
var state_29339__$1 = state_29339;
var statearr_29344_29502 = state_29339__$1;
(statearr_29344_29502[(2)] = null);

(statearr_29344_29502[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29340 === (6))){
var state_29339__$1 = state_29339;
var statearr_29345_29503 = state_29339__$1;
(statearr_29345_29503[(2)] = null);

(statearr_29345_29503[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29340 === (7))){
var inst_29335 = (state_29339[(2)]);
var state_29339__$1 = state_29339;
var statearr_29346_29504 = state_29339__$1;
(statearr_29346_29504[(2)] = inst_29335);

(statearr_29346_29504[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__29495,c__28309__auto___29498,G__29326_29496,n__7125__auto___29494,jobs,results,process,async))
;
return ((function (__29495,switch__28294__auto__,c__28309__auto___29498,G__29326_29496,n__7125__auto___29494,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28295__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28295__auto____0 = (function (){
var statearr_29350 = [null,null,null,null,null,null,null];
(statearr_29350[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28295__auto__);

(statearr_29350[(1)] = (1));

return statearr_29350;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28295__auto____1 = (function (state_29339){
while(true){
var ret_value__28296__auto__ = (function (){try{while(true){
var result__28297__auto__ = switch__28294__auto__.call(null,state_29339);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28297__auto__;
}
break;
}
}catch (e29351){if((e29351 instanceof Object)){
var ex__28298__auto__ = e29351;
var statearr_29352_29505 = state_29339;
(statearr_29352_29505[(5)] = ex__28298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29339);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29351;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29506 = state_29339;
state_29339 = G__29506;
continue;
} else {
return ret_value__28296__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28295__auto__ = function(state_29339){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28295__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28295__auto____1.call(this,state_29339);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28295__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28295__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28295__auto__;
})()
;})(__29495,switch__28294__auto__,c__28309__auto___29498,G__29326_29496,n__7125__auto___29494,jobs,results,process,async))
})();
var state__28311__auto__ = (function (){var statearr_29353 = f__28310__auto__.call(null);
(statearr_29353[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28309__auto___29498);

return statearr_29353;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28311__auto__);
});})(__29495,c__28309__auto___29498,G__29326_29496,n__7125__auto___29494,jobs,results,process,async))
);


break;
case "async":
var c__28309__auto___29507 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__29495,c__28309__auto___29507,G__29326_29496,n__7125__auto___29494,jobs,results,process,async){
return (function (){
var f__28310__auto__ = (function (){var switch__28294__auto__ = ((function (__29495,c__28309__auto___29507,G__29326_29496,n__7125__auto___29494,jobs,results,process,async){
return (function (state_29366){
var state_val_29367 = (state_29366[(1)]);
if((state_val_29367 === (1))){
var state_29366__$1 = state_29366;
var statearr_29368_29508 = state_29366__$1;
(statearr_29368_29508[(2)] = null);

(statearr_29368_29508[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29367 === (2))){
var state_29366__$1 = state_29366;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29366__$1,(4),jobs);
} else {
if((state_val_29367 === (3))){
var inst_29364 = (state_29366[(2)]);
var state_29366__$1 = state_29366;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29366__$1,inst_29364);
} else {
if((state_val_29367 === (4))){
var inst_29356 = (state_29366[(2)]);
var inst_29357 = async.call(null,inst_29356);
var state_29366__$1 = state_29366;
if(cljs.core.truth_(inst_29357)){
var statearr_29369_29509 = state_29366__$1;
(statearr_29369_29509[(1)] = (5));

} else {
var statearr_29370_29510 = state_29366__$1;
(statearr_29370_29510[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29367 === (5))){
var state_29366__$1 = state_29366;
var statearr_29371_29511 = state_29366__$1;
(statearr_29371_29511[(2)] = null);

(statearr_29371_29511[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29367 === (6))){
var state_29366__$1 = state_29366;
var statearr_29372_29512 = state_29366__$1;
(statearr_29372_29512[(2)] = null);

(statearr_29372_29512[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29367 === (7))){
var inst_29362 = (state_29366[(2)]);
var state_29366__$1 = state_29366;
var statearr_29373_29513 = state_29366__$1;
(statearr_29373_29513[(2)] = inst_29362);

(statearr_29373_29513[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__29495,c__28309__auto___29507,G__29326_29496,n__7125__auto___29494,jobs,results,process,async))
;
return ((function (__29495,switch__28294__auto__,c__28309__auto___29507,G__29326_29496,n__7125__auto___29494,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28295__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28295__auto____0 = (function (){
var statearr_29377 = [null,null,null,null,null,null,null];
(statearr_29377[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28295__auto__);

(statearr_29377[(1)] = (1));

return statearr_29377;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28295__auto____1 = (function (state_29366){
while(true){
var ret_value__28296__auto__ = (function (){try{while(true){
var result__28297__auto__ = switch__28294__auto__.call(null,state_29366);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28297__auto__;
}
break;
}
}catch (e29378){if((e29378 instanceof Object)){
var ex__28298__auto__ = e29378;
var statearr_29379_29514 = state_29366;
(statearr_29379_29514[(5)] = ex__28298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29366);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29378;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29515 = state_29366;
state_29366 = G__29515;
continue;
} else {
return ret_value__28296__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28295__auto__ = function(state_29366){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28295__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28295__auto____1.call(this,state_29366);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28295__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28295__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28295__auto__;
})()
;})(__29495,switch__28294__auto__,c__28309__auto___29507,G__29326_29496,n__7125__auto___29494,jobs,results,process,async))
})();
var state__28311__auto__ = (function (){var statearr_29380 = f__28310__auto__.call(null);
(statearr_29380[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28309__auto___29507);

return statearr_29380;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28311__auto__);
});})(__29495,c__28309__auto___29507,G__29326_29496,n__7125__auto___29494,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__29516 = (__29495 + (1));
__29495 = G__29516;
continue;
} else {
}
break;
}

var c__28309__auto___29517 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__28309__auto___29517,jobs,results,process,async){
return (function (){
var f__28310__auto__ = (function (){var switch__28294__auto__ = ((function (c__28309__auto___29517,jobs,results,process,async){
return (function (state_29402){
var state_val_29403 = (state_29402[(1)]);
if((state_val_29403 === (1))){
var state_29402__$1 = state_29402;
var statearr_29404_29518 = state_29402__$1;
(statearr_29404_29518[(2)] = null);

(statearr_29404_29518[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29403 === (2))){
var state_29402__$1 = state_29402;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29402__$1,(4),from);
} else {
if((state_val_29403 === (3))){
var inst_29400 = (state_29402[(2)]);
var state_29402__$1 = state_29402;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29402__$1,inst_29400);
} else {
if((state_val_29403 === (4))){
var inst_29383 = (state_29402[(7)]);
var inst_29383__$1 = (state_29402[(2)]);
var inst_29384 = (inst_29383__$1 == null);
var state_29402__$1 = (function (){var statearr_29405 = state_29402;
(statearr_29405[(7)] = inst_29383__$1);

return statearr_29405;
})();
if(cljs.core.truth_(inst_29384)){
var statearr_29406_29519 = state_29402__$1;
(statearr_29406_29519[(1)] = (5));

} else {
var statearr_29407_29520 = state_29402__$1;
(statearr_29407_29520[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29403 === (5))){
var inst_29386 = cljs.core.async.close_BANG_.call(null,jobs);
var state_29402__$1 = state_29402;
var statearr_29408_29521 = state_29402__$1;
(statearr_29408_29521[(2)] = inst_29386);

(statearr_29408_29521[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29403 === (6))){
var inst_29383 = (state_29402[(7)]);
var inst_29388 = (state_29402[(8)]);
var inst_29388__$1 = cljs.core.async.chan.call(null,(1));
var inst_29389 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29390 = [inst_29383,inst_29388__$1];
var inst_29391 = (new cljs.core.PersistentVector(null,2,(5),inst_29389,inst_29390,null));
var state_29402__$1 = (function (){var statearr_29409 = state_29402;
(statearr_29409[(8)] = inst_29388__$1);

return statearr_29409;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29402__$1,(8),jobs,inst_29391);
} else {
if((state_val_29403 === (7))){
var inst_29398 = (state_29402[(2)]);
var state_29402__$1 = state_29402;
var statearr_29410_29522 = state_29402__$1;
(statearr_29410_29522[(2)] = inst_29398);

(statearr_29410_29522[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29403 === (8))){
var inst_29388 = (state_29402[(8)]);
var inst_29393 = (state_29402[(2)]);
var state_29402__$1 = (function (){var statearr_29411 = state_29402;
(statearr_29411[(9)] = inst_29393);

return statearr_29411;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29402__$1,(9),results,inst_29388);
} else {
if((state_val_29403 === (9))){
var inst_29395 = (state_29402[(2)]);
var state_29402__$1 = (function (){var statearr_29412 = state_29402;
(statearr_29412[(10)] = inst_29395);

return statearr_29412;
})();
var statearr_29413_29523 = state_29402__$1;
(statearr_29413_29523[(2)] = null);

(statearr_29413_29523[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__28309__auto___29517,jobs,results,process,async))
;
return ((function (switch__28294__auto__,c__28309__auto___29517,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28295__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28295__auto____0 = (function (){
var statearr_29417 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29417[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28295__auto__);

(statearr_29417[(1)] = (1));

return statearr_29417;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28295__auto____1 = (function (state_29402){
while(true){
var ret_value__28296__auto__ = (function (){try{while(true){
var result__28297__auto__ = switch__28294__auto__.call(null,state_29402);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28297__auto__;
}
break;
}
}catch (e29418){if((e29418 instanceof Object)){
var ex__28298__auto__ = e29418;
var statearr_29419_29524 = state_29402;
(statearr_29419_29524[(5)] = ex__28298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29402);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29418;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29525 = state_29402;
state_29402 = G__29525;
continue;
} else {
return ret_value__28296__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28295__auto__ = function(state_29402){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28295__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28295__auto____1.call(this,state_29402);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28295__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28295__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28295__auto__;
})()
;})(switch__28294__auto__,c__28309__auto___29517,jobs,results,process,async))
})();
var state__28311__auto__ = (function (){var statearr_29420 = f__28310__auto__.call(null);
(statearr_29420[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28309__auto___29517);

return statearr_29420;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28311__auto__);
});})(c__28309__auto___29517,jobs,results,process,async))
);


var c__28309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__28309__auto__,jobs,results,process,async){
return (function (){
var f__28310__auto__ = (function (){var switch__28294__auto__ = ((function (c__28309__auto__,jobs,results,process,async){
return (function (state_29458){
var state_val_29459 = (state_29458[(1)]);
if((state_val_29459 === (7))){
var inst_29454 = (state_29458[(2)]);
var state_29458__$1 = state_29458;
var statearr_29460_29526 = state_29458__$1;
(statearr_29460_29526[(2)] = inst_29454);

(statearr_29460_29526[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29459 === (20))){
var state_29458__$1 = state_29458;
var statearr_29461_29527 = state_29458__$1;
(statearr_29461_29527[(2)] = null);

(statearr_29461_29527[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29459 === (1))){
var state_29458__$1 = state_29458;
var statearr_29462_29528 = state_29458__$1;
(statearr_29462_29528[(2)] = null);

(statearr_29462_29528[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29459 === (4))){
var inst_29423 = (state_29458[(7)]);
var inst_29423__$1 = (state_29458[(2)]);
var inst_29424 = (inst_29423__$1 == null);
var state_29458__$1 = (function (){var statearr_29463 = state_29458;
(statearr_29463[(7)] = inst_29423__$1);

return statearr_29463;
})();
if(cljs.core.truth_(inst_29424)){
var statearr_29464_29529 = state_29458__$1;
(statearr_29464_29529[(1)] = (5));

} else {
var statearr_29465_29530 = state_29458__$1;
(statearr_29465_29530[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29459 === (15))){
var inst_29436 = (state_29458[(8)]);
var state_29458__$1 = state_29458;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29458__$1,(18),to,inst_29436);
} else {
if((state_val_29459 === (21))){
var inst_29449 = (state_29458[(2)]);
var state_29458__$1 = state_29458;
var statearr_29466_29531 = state_29458__$1;
(statearr_29466_29531[(2)] = inst_29449);

(statearr_29466_29531[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29459 === (13))){
var inst_29451 = (state_29458[(2)]);
var state_29458__$1 = (function (){var statearr_29467 = state_29458;
(statearr_29467[(9)] = inst_29451);

return statearr_29467;
})();
var statearr_29468_29532 = state_29458__$1;
(statearr_29468_29532[(2)] = null);

(statearr_29468_29532[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29459 === (6))){
var inst_29423 = (state_29458[(7)]);
var state_29458__$1 = state_29458;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29458__$1,(11),inst_29423);
} else {
if((state_val_29459 === (17))){
var inst_29444 = (state_29458[(2)]);
var state_29458__$1 = state_29458;
if(cljs.core.truth_(inst_29444)){
var statearr_29469_29533 = state_29458__$1;
(statearr_29469_29533[(1)] = (19));

} else {
var statearr_29470_29534 = state_29458__$1;
(statearr_29470_29534[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29459 === (3))){
var inst_29456 = (state_29458[(2)]);
var state_29458__$1 = state_29458;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29458__$1,inst_29456);
} else {
if((state_val_29459 === (12))){
var inst_29433 = (state_29458[(10)]);
var state_29458__$1 = state_29458;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29458__$1,(14),inst_29433);
} else {
if((state_val_29459 === (2))){
var state_29458__$1 = state_29458;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29458__$1,(4),results);
} else {
if((state_val_29459 === (19))){
var state_29458__$1 = state_29458;
var statearr_29471_29535 = state_29458__$1;
(statearr_29471_29535[(2)] = null);

(statearr_29471_29535[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29459 === (11))){
var inst_29433 = (state_29458[(2)]);
var state_29458__$1 = (function (){var statearr_29472 = state_29458;
(statearr_29472[(10)] = inst_29433);

return statearr_29472;
})();
var statearr_29473_29536 = state_29458__$1;
(statearr_29473_29536[(2)] = null);

(statearr_29473_29536[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29459 === (9))){
var state_29458__$1 = state_29458;
var statearr_29474_29537 = state_29458__$1;
(statearr_29474_29537[(2)] = null);

(statearr_29474_29537[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29459 === (5))){
var state_29458__$1 = state_29458;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29475_29538 = state_29458__$1;
(statearr_29475_29538[(1)] = (8));

} else {
var statearr_29476_29539 = state_29458__$1;
(statearr_29476_29539[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29459 === (14))){
var inst_29436 = (state_29458[(8)]);
var inst_29438 = (state_29458[(11)]);
var inst_29436__$1 = (state_29458[(2)]);
var inst_29437 = (inst_29436__$1 == null);
var inst_29438__$1 = cljs.core.not.call(null,inst_29437);
var state_29458__$1 = (function (){var statearr_29477 = state_29458;
(statearr_29477[(8)] = inst_29436__$1);

(statearr_29477[(11)] = inst_29438__$1);

return statearr_29477;
})();
if(inst_29438__$1){
var statearr_29478_29540 = state_29458__$1;
(statearr_29478_29540[(1)] = (15));

} else {
var statearr_29479_29541 = state_29458__$1;
(statearr_29479_29541[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29459 === (16))){
var inst_29438 = (state_29458[(11)]);
var state_29458__$1 = state_29458;
var statearr_29480_29542 = state_29458__$1;
(statearr_29480_29542[(2)] = inst_29438);

(statearr_29480_29542[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29459 === (10))){
var inst_29430 = (state_29458[(2)]);
var state_29458__$1 = state_29458;
var statearr_29481_29543 = state_29458__$1;
(statearr_29481_29543[(2)] = inst_29430);

(statearr_29481_29543[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29459 === (18))){
var inst_29441 = (state_29458[(2)]);
var state_29458__$1 = state_29458;
var statearr_29482_29544 = state_29458__$1;
(statearr_29482_29544[(2)] = inst_29441);

(statearr_29482_29544[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29459 === (8))){
var inst_29427 = cljs.core.async.close_BANG_.call(null,to);
var state_29458__$1 = state_29458;
var statearr_29483_29545 = state_29458__$1;
(statearr_29483_29545[(2)] = inst_29427);

(statearr_29483_29545[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__28309__auto__,jobs,results,process,async))
;
return ((function (switch__28294__auto__,c__28309__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28295__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28295__auto____0 = (function (){
var statearr_29487 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29487[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28295__auto__);

(statearr_29487[(1)] = (1));

return statearr_29487;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28295__auto____1 = (function (state_29458){
while(true){
var ret_value__28296__auto__ = (function (){try{while(true){
var result__28297__auto__ = switch__28294__auto__.call(null,state_29458);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28297__auto__;
}
break;
}
}catch (e29488){if((e29488 instanceof Object)){
var ex__28298__auto__ = e29488;
var statearr_29489_29546 = state_29458;
(statearr_29489_29546[(5)] = ex__28298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29458);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29488;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29547 = state_29458;
state_29458 = G__29547;
continue;
} else {
return ret_value__28296__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28295__auto__ = function(state_29458){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28295__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28295__auto____1.call(this,state_29458);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28295__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28295__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28295__auto__;
})()
;})(switch__28294__auto__,c__28309__auto__,jobs,results,process,async))
})();
var state__28311__auto__ = (function (){var statearr_29490 = f__28310__auto__.call(null);
(statearr_29490[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28309__auto__);

return statearr_29490;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28311__auto__);
});})(c__28309__auto__,jobs,results,process,async))
);

return c__28309__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args29548 = [];
var len__7280__auto___29551 = arguments.length;
var i__7281__auto___29552 = (0);
while(true){
if((i__7281__auto___29552 < len__7280__auto___29551)){
args29548.push((arguments[i__7281__auto___29552]));

var G__29553 = (i__7281__auto___29552 + (1));
i__7281__auto___29552 = G__29553;
continue;
} else {
}
break;
}

var G__29550 = args29548.length;
switch (G__29550) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29548.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args29555 = [];
var len__7280__auto___29558 = arguments.length;
var i__7281__auto___29559 = (0);
while(true){
if((i__7281__auto___29559 < len__7280__auto___29558)){
args29555.push((arguments[i__7281__auto___29559]));

var G__29560 = (i__7281__auto___29559 + (1));
i__7281__auto___29559 = G__29560;
continue;
} else {
}
break;
}

var G__29557 = args29555.length;
switch (G__29557) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29555.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args29562 = [];
var len__7280__auto___29615 = arguments.length;
var i__7281__auto___29616 = (0);
while(true){
if((i__7281__auto___29616 < len__7280__auto___29615)){
args29562.push((arguments[i__7281__auto___29616]));

var G__29617 = (i__7281__auto___29616 + (1));
i__7281__auto___29616 = G__29617;
continue;
} else {
}
break;
}

var G__29564 = args29562.length;
switch (G__29564) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29562.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__28309__auto___29619 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__28309__auto___29619,tc,fc){
return (function (){
var f__28310__auto__ = (function (){var switch__28294__auto__ = ((function (c__28309__auto___29619,tc,fc){
return (function (state_29590){
var state_val_29591 = (state_29590[(1)]);
if((state_val_29591 === (7))){
var inst_29586 = (state_29590[(2)]);
var state_29590__$1 = state_29590;
var statearr_29592_29620 = state_29590__$1;
(statearr_29592_29620[(2)] = inst_29586);

(statearr_29592_29620[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29591 === (1))){
var state_29590__$1 = state_29590;
var statearr_29593_29621 = state_29590__$1;
(statearr_29593_29621[(2)] = null);

(statearr_29593_29621[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29591 === (4))){
var inst_29567 = (state_29590[(7)]);
var inst_29567__$1 = (state_29590[(2)]);
var inst_29568 = (inst_29567__$1 == null);
var state_29590__$1 = (function (){var statearr_29594 = state_29590;
(statearr_29594[(7)] = inst_29567__$1);

return statearr_29594;
})();
if(cljs.core.truth_(inst_29568)){
var statearr_29595_29622 = state_29590__$1;
(statearr_29595_29622[(1)] = (5));

} else {
var statearr_29596_29623 = state_29590__$1;
(statearr_29596_29623[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29591 === (13))){
var state_29590__$1 = state_29590;
var statearr_29597_29624 = state_29590__$1;
(statearr_29597_29624[(2)] = null);

(statearr_29597_29624[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29591 === (6))){
var inst_29567 = (state_29590[(7)]);
var inst_29573 = p.call(null,inst_29567);
var state_29590__$1 = state_29590;
if(cljs.core.truth_(inst_29573)){
var statearr_29598_29625 = state_29590__$1;
(statearr_29598_29625[(1)] = (9));

} else {
var statearr_29599_29626 = state_29590__$1;
(statearr_29599_29626[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29591 === (3))){
var inst_29588 = (state_29590[(2)]);
var state_29590__$1 = state_29590;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29590__$1,inst_29588);
} else {
if((state_val_29591 === (12))){
var state_29590__$1 = state_29590;
var statearr_29600_29627 = state_29590__$1;
(statearr_29600_29627[(2)] = null);

(statearr_29600_29627[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29591 === (2))){
var state_29590__$1 = state_29590;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29590__$1,(4),ch);
} else {
if((state_val_29591 === (11))){
var inst_29567 = (state_29590[(7)]);
var inst_29577 = (state_29590[(2)]);
var state_29590__$1 = state_29590;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29590__$1,(8),inst_29577,inst_29567);
} else {
if((state_val_29591 === (9))){
var state_29590__$1 = state_29590;
var statearr_29601_29628 = state_29590__$1;
(statearr_29601_29628[(2)] = tc);

(statearr_29601_29628[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29591 === (5))){
var inst_29570 = cljs.core.async.close_BANG_.call(null,tc);
var inst_29571 = cljs.core.async.close_BANG_.call(null,fc);
var state_29590__$1 = (function (){var statearr_29602 = state_29590;
(statearr_29602[(8)] = inst_29570);

return statearr_29602;
})();
var statearr_29603_29629 = state_29590__$1;
(statearr_29603_29629[(2)] = inst_29571);

(statearr_29603_29629[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29591 === (14))){
var inst_29584 = (state_29590[(2)]);
var state_29590__$1 = state_29590;
var statearr_29604_29630 = state_29590__$1;
(statearr_29604_29630[(2)] = inst_29584);

(statearr_29604_29630[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29591 === (10))){
var state_29590__$1 = state_29590;
var statearr_29605_29631 = state_29590__$1;
(statearr_29605_29631[(2)] = fc);

(statearr_29605_29631[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29591 === (8))){
var inst_29579 = (state_29590[(2)]);
var state_29590__$1 = state_29590;
if(cljs.core.truth_(inst_29579)){
var statearr_29606_29632 = state_29590__$1;
(statearr_29606_29632[(1)] = (12));

} else {
var statearr_29607_29633 = state_29590__$1;
(statearr_29607_29633[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__28309__auto___29619,tc,fc))
;
return ((function (switch__28294__auto__,c__28309__auto___29619,tc,fc){
return (function() {
var cljs$core$async$state_machine__28295__auto__ = null;
var cljs$core$async$state_machine__28295__auto____0 = (function (){
var statearr_29611 = [null,null,null,null,null,null,null,null,null];
(statearr_29611[(0)] = cljs$core$async$state_machine__28295__auto__);

(statearr_29611[(1)] = (1));

return statearr_29611;
});
var cljs$core$async$state_machine__28295__auto____1 = (function (state_29590){
while(true){
var ret_value__28296__auto__ = (function (){try{while(true){
var result__28297__auto__ = switch__28294__auto__.call(null,state_29590);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28297__auto__;
}
break;
}
}catch (e29612){if((e29612 instanceof Object)){
var ex__28298__auto__ = e29612;
var statearr_29613_29634 = state_29590;
(statearr_29613_29634[(5)] = ex__28298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29590);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29612;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29635 = state_29590;
state_29590 = G__29635;
continue;
} else {
return ret_value__28296__auto__;
}
break;
}
});
cljs$core$async$state_machine__28295__auto__ = function(state_29590){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28295__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28295__auto____1.call(this,state_29590);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28295__auto____0;
cljs$core$async$state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28295__auto____1;
return cljs$core$async$state_machine__28295__auto__;
})()
;})(switch__28294__auto__,c__28309__auto___29619,tc,fc))
})();
var state__28311__auto__ = (function (){var statearr_29614 = f__28310__auto__.call(null);
(statearr_29614[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28309__auto___29619);

return statearr_29614;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28311__auto__);
});})(c__28309__auto___29619,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__28309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__28309__auto__){
return (function (){
var f__28310__auto__ = (function (){var switch__28294__auto__ = ((function (c__28309__auto__){
return (function (state_29699){
var state_val_29700 = (state_29699[(1)]);
if((state_val_29700 === (7))){
var inst_29695 = (state_29699[(2)]);
var state_29699__$1 = state_29699;
var statearr_29701_29722 = state_29699__$1;
(statearr_29701_29722[(2)] = inst_29695);

(statearr_29701_29722[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29700 === (1))){
var inst_29679 = init;
var state_29699__$1 = (function (){var statearr_29702 = state_29699;
(statearr_29702[(7)] = inst_29679);

return statearr_29702;
})();
var statearr_29703_29723 = state_29699__$1;
(statearr_29703_29723[(2)] = null);

(statearr_29703_29723[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29700 === (4))){
var inst_29682 = (state_29699[(8)]);
var inst_29682__$1 = (state_29699[(2)]);
var inst_29683 = (inst_29682__$1 == null);
var state_29699__$1 = (function (){var statearr_29704 = state_29699;
(statearr_29704[(8)] = inst_29682__$1);

return statearr_29704;
})();
if(cljs.core.truth_(inst_29683)){
var statearr_29705_29724 = state_29699__$1;
(statearr_29705_29724[(1)] = (5));

} else {
var statearr_29706_29725 = state_29699__$1;
(statearr_29706_29725[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29700 === (6))){
var inst_29679 = (state_29699[(7)]);
var inst_29682 = (state_29699[(8)]);
var inst_29686 = (state_29699[(9)]);
var inst_29686__$1 = f.call(null,inst_29679,inst_29682);
var inst_29687 = cljs.core.reduced_QMARK_.call(null,inst_29686__$1);
var state_29699__$1 = (function (){var statearr_29707 = state_29699;
(statearr_29707[(9)] = inst_29686__$1);

return statearr_29707;
})();
if(inst_29687){
var statearr_29708_29726 = state_29699__$1;
(statearr_29708_29726[(1)] = (8));

} else {
var statearr_29709_29727 = state_29699__$1;
(statearr_29709_29727[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29700 === (3))){
var inst_29697 = (state_29699[(2)]);
var state_29699__$1 = state_29699;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29699__$1,inst_29697);
} else {
if((state_val_29700 === (2))){
var state_29699__$1 = state_29699;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29699__$1,(4),ch);
} else {
if((state_val_29700 === (9))){
var inst_29686 = (state_29699[(9)]);
var inst_29679 = inst_29686;
var state_29699__$1 = (function (){var statearr_29710 = state_29699;
(statearr_29710[(7)] = inst_29679);

return statearr_29710;
})();
var statearr_29711_29728 = state_29699__$1;
(statearr_29711_29728[(2)] = null);

(statearr_29711_29728[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29700 === (5))){
var inst_29679 = (state_29699[(7)]);
var state_29699__$1 = state_29699;
var statearr_29712_29729 = state_29699__$1;
(statearr_29712_29729[(2)] = inst_29679);

(statearr_29712_29729[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29700 === (10))){
var inst_29693 = (state_29699[(2)]);
var state_29699__$1 = state_29699;
var statearr_29713_29730 = state_29699__$1;
(statearr_29713_29730[(2)] = inst_29693);

(statearr_29713_29730[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29700 === (8))){
var inst_29686 = (state_29699[(9)]);
var inst_29689 = cljs.core.deref.call(null,inst_29686);
var state_29699__$1 = state_29699;
var statearr_29714_29731 = state_29699__$1;
(statearr_29714_29731[(2)] = inst_29689);

(statearr_29714_29731[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__28309__auto__))
;
return ((function (switch__28294__auto__,c__28309__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__28295__auto__ = null;
var cljs$core$async$reduce_$_state_machine__28295__auto____0 = (function (){
var statearr_29718 = [null,null,null,null,null,null,null,null,null,null];
(statearr_29718[(0)] = cljs$core$async$reduce_$_state_machine__28295__auto__);

(statearr_29718[(1)] = (1));

return statearr_29718;
});
var cljs$core$async$reduce_$_state_machine__28295__auto____1 = (function (state_29699){
while(true){
var ret_value__28296__auto__ = (function (){try{while(true){
var result__28297__auto__ = switch__28294__auto__.call(null,state_29699);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28297__auto__;
}
break;
}
}catch (e29719){if((e29719 instanceof Object)){
var ex__28298__auto__ = e29719;
var statearr_29720_29732 = state_29699;
(statearr_29720_29732[(5)] = ex__28298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29699);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29719;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29733 = state_29699;
state_29699 = G__29733;
continue;
} else {
return ret_value__28296__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__28295__auto__ = function(state_29699){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__28295__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__28295__auto____1.call(this,state_29699);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__28295__auto____0;
cljs$core$async$reduce_$_state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__28295__auto____1;
return cljs$core$async$reduce_$_state_machine__28295__auto__;
})()
;})(switch__28294__auto__,c__28309__auto__))
})();
var state__28311__auto__ = (function (){var statearr_29721 = f__28310__auto__.call(null);
(statearr_29721[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28309__auto__);

return statearr_29721;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28311__auto__);
});})(c__28309__auto__))
);

return c__28309__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__28309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__28309__auto__,f__$1){
return (function (){
var f__28310__auto__ = (function (){var switch__28294__auto__ = ((function (c__28309__auto__,f__$1){
return (function (state_29753){
var state_val_29754 = (state_29753[(1)]);
if((state_val_29754 === (1))){
var inst_29748 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_29753__$1 = state_29753;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29753__$1,(2),inst_29748);
} else {
if((state_val_29754 === (2))){
var inst_29750 = (state_29753[(2)]);
var inst_29751 = f__$1.call(null,inst_29750);
var state_29753__$1 = state_29753;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29753__$1,inst_29751);
} else {
return null;
}
}
});})(c__28309__auto__,f__$1))
;
return ((function (switch__28294__auto__,c__28309__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__28295__auto__ = null;
var cljs$core$async$transduce_$_state_machine__28295__auto____0 = (function (){
var statearr_29758 = [null,null,null,null,null,null,null];
(statearr_29758[(0)] = cljs$core$async$transduce_$_state_machine__28295__auto__);

(statearr_29758[(1)] = (1));

return statearr_29758;
});
var cljs$core$async$transduce_$_state_machine__28295__auto____1 = (function (state_29753){
while(true){
var ret_value__28296__auto__ = (function (){try{while(true){
var result__28297__auto__ = switch__28294__auto__.call(null,state_29753);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28297__auto__;
}
break;
}
}catch (e29759){if((e29759 instanceof Object)){
var ex__28298__auto__ = e29759;
var statearr_29760_29762 = state_29753;
(statearr_29760_29762[(5)] = ex__28298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29753);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29759;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29763 = state_29753;
state_29753 = G__29763;
continue;
} else {
return ret_value__28296__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__28295__auto__ = function(state_29753){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__28295__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__28295__auto____1.call(this,state_29753);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__28295__auto____0;
cljs$core$async$transduce_$_state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__28295__auto____1;
return cljs$core$async$transduce_$_state_machine__28295__auto__;
})()
;})(switch__28294__auto__,c__28309__auto__,f__$1))
})();
var state__28311__auto__ = (function (){var statearr_29761 = f__28310__auto__.call(null);
(statearr_29761[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28309__auto__);

return statearr_29761;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28311__auto__);
});})(c__28309__auto__,f__$1))
);

return c__28309__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args29764 = [];
var len__7280__auto___29816 = arguments.length;
var i__7281__auto___29817 = (0);
while(true){
if((i__7281__auto___29817 < len__7280__auto___29816)){
args29764.push((arguments[i__7281__auto___29817]));

var G__29818 = (i__7281__auto___29817 + (1));
i__7281__auto___29817 = G__29818;
continue;
} else {
}
break;
}

var G__29766 = args29764.length;
switch (G__29766) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29764.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__28309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__28309__auto__){
return (function (){
var f__28310__auto__ = (function (){var switch__28294__auto__ = ((function (c__28309__auto__){
return (function (state_29791){
var state_val_29792 = (state_29791[(1)]);
if((state_val_29792 === (7))){
var inst_29773 = (state_29791[(2)]);
var state_29791__$1 = state_29791;
var statearr_29793_29820 = state_29791__$1;
(statearr_29793_29820[(2)] = inst_29773);

(statearr_29793_29820[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29792 === (1))){
var inst_29767 = cljs.core.seq.call(null,coll);
var inst_29768 = inst_29767;
var state_29791__$1 = (function (){var statearr_29794 = state_29791;
(statearr_29794[(7)] = inst_29768);

return statearr_29794;
})();
var statearr_29795_29821 = state_29791__$1;
(statearr_29795_29821[(2)] = null);

(statearr_29795_29821[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29792 === (4))){
var inst_29768 = (state_29791[(7)]);
var inst_29771 = cljs.core.first.call(null,inst_29768);
var state_29791__$1 = state_29791;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29791__$1,(7),ch,inst_29771);
} else {
if((state_val_29792 === (13))){
var inst_29785 = (state_29791[(2)]);
var state_29791__$1 = state_29791;
var statearr_29796_29822 = state_29791__$1;
(statearr_29796_29822[(2)] = inst_29785);

(statearr_29796_29822[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29792 === (6))){
var inst_29776 = (state_29791[(2)]);
var state_29791__$1 = state_29791;
if(cljs.core.truth_(inst_29776)){
var statearr_29797_29823 = state_29791__$1;
(statearr_29797_29823[(1)] = (8));

} else {
var statearr_29798_29824 = state_29791__$1;
(statearr_29798_29824[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29792 === (3))){
var inst_29789 = (state_29791[(2)]);
var state_29791__$1 = state_29791;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29791__$1,inst_29789);
} else {
if((state_val_29792 === (12))){
var state_29791__$1 = state_29791;
var statearr_29799_29825 = state_29791__$1;
(statearr_29799_29825[(2)] = null);

(statearr_29799_29825[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29792 === (2))){
var inst_29768 = (state_29791[(7)]);
var state_29791__$1 = state_29791;
if(cljs.core.truth_(inst_29768)){
var statearr_29800_29826 = state_29791__$1;
(statearr_29800_29826[(1)] = (4));

} else {
var statearr_29801_29827 = state_29791__$1;
(statearr_29801_29827[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29792 === (11))){
var inst_29782 = cljs.core.async.close_BANG_.call(null,ch);
var state_29791__$1 = state_29791;
var statearr_29802_29828 = state_29791__$1;
(statearr_29802_29828[(2)] = inst_29782);

(statearr_29802_29828[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29792 === (9))){
var state_29791__$1 = state_29791;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29803_29829 = state_29791__$1;
(statearr_29803_29829[(1)] = (11));

} else {
var statearr_29804_29830 = state_29791__$1;
(statearr_29804_29830[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29792 === (5))){
var inst_29768 = (state_29791[(7)]);
var state_29791__$1 = state_29791;
var statearr_29805_29831 = state_29791__$1;
(statearr_29805_29831[(2)] = inst_29768);

(statearr_29805_29831[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29792 === (10))){
var inst_29787 = (state_29791[(2)]);
var state_29791__$1 = state_29791;
var statearr_29806_29832 = state_29791__$1;
(statearr_29806_29832[(2)] = inst_29787);

(statearr_29806_29832[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29792 === (8))){
var inst_29768 = (state_29791[(7)]);
var inst_29778 = cljs.core.next.call(null,inst_29768);
var inst_29768__$1 = inst_29778;
var state_29791__$1 = (function (){var statearr_29807 = state_29791;
(statearr_29807[(7)] = inst_29768__$1);

return statearr_29807;
})();
var statearr_29808_29833 = state_29791__$1;
(statearr_29808_29833[(2)] = null);

(statearr_29808_29833[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__28309__auto__))
;
return ((function (switch__28294__auto__,c__28309__auto__){
return (function() {
var cljs$core$async$state_machine__28295__auto__ = null;
var cljs$core$async$state_machine__28295__auto____0 = (function (){
var statearr_29812 = [null,null,null,null,null,null,null,null];
(statearr_29812[(0)] = cljs$core$async$state_machine__28295__auto__);

(statearr_29812[(1)] = (1));

return statearr_29812;
});
var cljs$core$async$state_machine__28295__auto____1 = (function (state_29791){
while(true){
var ret_value__28296__auto__ = (function (){try{while(true){
var result__28297__auto__ = switch__28294__auto__.call(null,state_29791);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28297__auto__;
}
break;
}
}catch (e29813){if((e29813 instanceof Object)){
var ex__28298__auto__ = e29813;
var statearr_29814_29834 = state_29791;
(statearr_29814_29834[(5)] = ex__28298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29791);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29813;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29835 = state_29791;
state_29791 = G__29835;
continue;
} else {
return ret_value__28296__auto__;
}
break;
}
});
cljs$core$async$state_machine__28295__auto__ = function(state_29791){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28295__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28295__auto____1.call(this,state_29791);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28295__auto____0;
cljs$core$async$state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28295__auto____1;
return cljs$core$async$state_machine__28295__auto__;
})()
;})(switch__28294__auto__,c__28309__auto__))
})();
var state__28311__auto__ = (function (){var statearr_29815 = f__28310__auto__.call(null);
(statearr_29815[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28309__auto__);

return statearr_29815;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28311__auto__);
});})(c__28309__auto__))
);

return c__28309__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__6873__auto__ = (((_ == null))?null:_);
var m__6874__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return m__6874__auto__.call(null,_);
} else {
var m__6874__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return m__6874__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__6873__auto__ = (((m == null))?null:m);
var m__6874__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return m__6874__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__6874__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return m__6874__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__6873__auto__ = (((m == null))?null:m);
var m__6874__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return m__6874__auto__.call(null,m,ch);
} else {
var m__6874__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return m__6874__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__6873__auto__ = (((m == null))?null:m);
var m__6874__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return m__6874__auto__.call(null,m);
} else {
var m__6874__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return m__6874__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async30057 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30057 = (function (mult,ch,cs,meta30058){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta30058 = meta30058;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async30057.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_30059,meta30058__$1){
var self__ = this;
var _30059__$1 = this;
return (new cljs.core.async.t_cljs$core$async30057(self__.mult,self__.ch,self__.cs,meta30058__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async30057.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_30059){
var self__ = this;
var _30059__$1 = this;
return self__.meta30058;
});})(cs))
;

cljs.core.async.t_cljs$core$async30057.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async30057.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async30057.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async30057.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async30057.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async30057.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async30057.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta30058","meta30058",-685799075,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async30057.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30057.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30057";

cljs.core.async.t_cljs$core$async30057.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write.call(null,writer__6817__auto__,"cljs.core.async/t_cljs$core$async30057");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async30057 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async30057(mult__$1,ch__$1,cs__$1,meta30058){
return (new cljs.core.async.t_cljs$core$async30057(mult__$1,ch__$1,cs__$1,meta30058));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async30057(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__28309__auto___30278 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__28309__auto___30278,cs,m,dchan,dctr,done){
return (function (){
var f__28310__auto__ = (function (){var switch__28294__auto__ = ((function (c__28309__auto___30278,cs,m,dchan,dctr,done){
return (function (state_30190){
var state_val_30191 = (state_30190[(1)]);
if((state_val_30191 === (7))){
var inst_30186 = (state_30190[(2)]);
var state_30190__$1 = state_30190;
var statearr_30192_30279 = state_30190__$1;
(statearr_30192_30279[(2)] = inst_30186);

(statearr_30192_30279[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (20))){
var inst_30091 = (state_30190[(7)]);
var inst_30101 = cljs.core.first.call(null,inst_30091);
var inst_30102 = cljs.core.nth.call(null,inst_30101,(0),null);
var inst_30103 = cljs.core.nth.call(null,inst_30101,(1),null);
var state_30190__$1 = (function (){var statearr_30193 = state_30190;
(statearr_30193[(8)] = inst_30102);

return statearr_30193;
})();
if(cljs.core.truth_(inst_30103)){
var statearr_30194_30280 = state_30190__$1;
(statearr_30194_30280[(1)] = (22));

} else {
var statearr_30195_30281 = state_30190__$1;
(statearr_30195_30281[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (27))){
var inst_30138 = (state_30190[(9)]);
var inst_30131 = (state_30190[(10)]);
var inst_30133 = (state_30190[(11)]);
var inst_30062 = (state_30190[(12)]);
var inst_30138__$1 = cljs.core._nth.call(null,inst_30131,inst_30133);
var inst_30139 = cljs.core.async.put_BANG_.call(null,inst_30138__$1,inst_30062,done);
var state_30190__$1 = (function (){var statearr_30196 = state_30190;
(statearr_30196[(9)] = inst_30138__$1);

return statearr_30196;
})();
if(cljs.core.truth_(inst_30139)){
var statearr_30197_30282 = state_30190__$1;
(statearr_30197_30282[(1)] = (30));

} else {
var statearr_30198_30283 = state_30190__$1;
(statearr_30198_30283[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (1))){
var state_30190__$1 = state_30190;
var statearr_30199_30284 = state_30190__$1;
(statearr_30199_30284[(2)] = null);

(statearr_30199_30284[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (24))){
var inst_30091 = (state_30190[(7)]);
var inst_30108 = (state_30190[(2)]);
var inst_30109 = cljs.core.next.call(null,inst_30091);
var inst_30071 = inst_30109;
var inst_30072 = null;
var inst_30073 = (0);
var inst_30074 = (0);
var state_30190__$1 = (function (){var statearr_30200 = state_30190;
(statearr_30200[(13)] = inst_30071);

(statearr_30200[(14)] = inst_30072);

(statearr_30200[(15)] = inst_30073);

(statearr_30200[(16)] = inst_30108);

(statearr_30200[(17)] = inst_30074);

return statearr_30200;
})();
var statearr_30201_30285 = state_30190__$1;
(statearr_30201_30285[(2)] = null);

(statearr_30201_30285[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (39))){
var state_30190__$1 = state_30190;
var statearr_30205_30286 = state_30190__$1;
(statearr_30205_30286[(2)] = null);

(statearr_30205_30286[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (4))){
var inst_30062 = (state_30190[(12)]);
var inst_30062__$1 = (state_30190[(2)]);
var inst_30063 = (inst_30062__$1 == null);
var state_30190__$1 = (function (){var statearr_30206 = state_30190;
(statearr_30206[(12)] = inst_30062__$1);

return statearr_30206;
})();
if(cljs.core.truth_(inst_30063)){
var statearr_30207_30287 = state_30190__$1;
(statearr_30207_30287[(1)] = (5));

} else {
var statearr_30208_30288 = state_30190__$1;
(statearr_30208_30288[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (15))){
var inst_30071 = (state_30190[(13)]);
var inst_30072 = (state_30190[(14)]);
var inst_30073 = (state_30190[(15)]);
var inst_30074 = (state_30190[(17)]);
var inst_30087 = (state_30190[(2)]);
var inst_30088 = (inst_30074 + (1));
var tmp30202 = inst_30071;
var tmp30203 = inst_30072;
var tmp30204 = inst_30073;
var inst_30071__$1 = tmp30202;
var inst_30072__$1 = tmp30203;
var inst_30073__$1 = tmp30204;
var inst_30074__$1 = inst_30088;
var state_30190__$1 = (function (){var statearr_30209 = state_30190;
(statearr_30209[(13)] = inst_30071__$1);

(statearr_30209[(14)] = inst_30072__$1);

(statearr_30209[(15)] = inst_30073__$1);

(statearr_30209[(18)] = inst_30087);

(statearr_30209[(17)] = inst_30074__$1);

return statearr_30209;
})();
var statearr_30210_30289 = state_30190__$1;
(statearr_30210_30289[(2)] = null);

(statearr_30210_30289[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (21))){
var inst_30112 = (state_30190[(2)]);
var state_30190__$1 = state_30190;
var statearr_30214_30290 = state_30190__$1;
(statearr_30214_30290[(2)] = inst_30112);

(statearr_30214_30290[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (31))){
var inst_30138 = (state_30190[(9)]);
var inst_30142 = done.call(null,null);
var inst_30143 = cljs.core.async.untap_STAR_.call(null,m,inst_30138);
var state_30190__$1 = (function (){var statearr_30215 = state_30190;
(statearr_30215[(19)] = inst_30142);

return statearr_30215;
})();
var statearr_30216_30291 = state_30190__$1;
(statearr_30216_30291[(2)] = inst_30143);

(statearr_30216_30291[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (32))){
var inst_30130 = (state_30190[(20)]);
var inst_30131 = (state_30190[(10)]);
var inst_30133 = (state_30190[(11)]);
var inst_30132 = (state_30190[(21)]);
var inst_30145 = (state_30190[(2)]);
var inst_30146 = (inst_30133 + (1));
var tmp30211 = inst_30130;
var tmp30212 = inst_30131;
var tmp30213 = inst_30132;
var inst_30130__$1 = tmp30211;
var inst_30131__$1 = tmp30212;
var inst_30132__$1 = tmp30213;
var inst_30133__$1 = inst_30146;
var state_30190__$1 = (function (){var statearr_30217 = state_30190;
(statearr_30217[(20)] = inst_30130__$1);

(statearr_30217[(22)] = inst_30145);

(statearr_30217[(10)] = inst_30131__$1);

(statearr_30217[(11)] = inst_30133__$1);

(statearr_30217[(21)] = inst_30132__$1);

return statearr_30217;
})();
var statearr_30218_30292 = state_30190__$1;
(statearr_30218_30292[(2)] = null);

(statearr_30218_30292[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (40))){
var inst_30158 = (state_30190[(23)]);
var inst_30162 = done.call(null,null);
var inst_30163 = cljs.core.async.untap_STAR_.call(null,m,inst_30158);
var state_30190__$1 = (function (){var statearr_30219 = state_30190;
(statearr_30219[(24)] = inst_30162);

return statearr_30219;
})();
var statearr_30220_30293 = state_30190__$1;
(statearr_30220_30293[(2)] = inst_30163);

(statearr_30220_30293[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (33))){
var inst_30149 = (state_30190[(25)]);
var inst_30151 = cljs.core.chunked_seq_QMARK_.call(null,inst_30149);
var state_30190__$1 = state_30190;
if(inst_30151){
var statearr_30221_30294 = state_30190__$1;
(statearr_30221_30294[(1)] = (36));

} else {
var statearr_30222_30295 = state_30190__$1;
(statearr_30222_30295[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (13))){
var inst_30081 = (state_30190[(26)]);
var inst_30084 = cljs.core.async.close_BANG_.call(null,inst_30081);
var state_30190__$1 = state_30190;
var statearr_30223_30296 = state_30190__$1;
(statearr_30223_30296[(2)] = inst_30084);

(statearr_30223_30296[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (22))){
var inst_30102 = (state_30190[(8)]);
var inst_30105 = cljs.core.async.close_BANG_.call(null,inst_30102);
var state_30190__$1 = state_30190;
var statearr_30224_30297 = state_30190__$1;
(statearr_30224_30297[(2)] = inst_30105);

(statearr_30224_30297[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (36))){
var inst_30149 = (state_30190[(25)]);
var inst_30153 = cljs.core.chunk_first.call(null,inst_30149);
var inst_30154 = cljs.core.chunk_rest.call(null,inst_30149);
var inst_30155 = cljs.core.count.call(null,inst_30153);
var inst_30130 = inst_30154;
var inst_30131 = inst_30153;
var inst_30132 = inst_30155;
var inst_30133 = (0);
var state_30190__$1 = (function (){var statearr_30225 = state_30190;
(statearr_30225[(20)] = inst_30130);

(statearr_30225[(10)] = inst_30131);

(statearr_30225[(11)] = inst_30133);

(statearr_30225[(21)] = inst_30132);

return statearr_30225;
})();
var statearr_30226_30298 = state_30190__$1;
(statearr_30226_30298[(2)] = null);

(statearr_30226_30298[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (41))){
var inst_30149 = (state_30190[(25)]);
var inst_30165 = (state_30190[(2)]);
var inst_30166 = cljs.core.next.call(null,inst_30149);
var inst_30130 = inst_30166;
var inst_30131 = null;
var inst_30132 = (0);
var inst_30133 = (0);
var state_30190__$1 = (function (){var statearr_30227 = state_30190;
(statearr_30227[(20)] = inst_30130);

(statearr_30227[(10)] = inst_30131);

(statearr_30227[(27)] = inst_30165);

(statearr_30227[(11)] = inst_30133);

(statearr_30227[(21)] = inst_30132);

return statearr_30227;
})();
var statearr_30228_30299 = state_30190__$1;
(statearr_30228_30299[(2)] = null);

(statearr_30228_30299[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (43))){
var state_30190__$1 = state_30190;
var statearr_30229_30300 = state_30190__$1;
(statearr_30229_30300[(2)] = null);

(statearr_30229_30300[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (29))){
var inst_30174 = (state_30190[(2)]);
var state_30190__$1 = state_30190;
var statearr_30230_30301 = state_30190__$1;
(statearr_30230_30301[(2)] = inst_30174);

(statearr_30230_30301[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (44))){
var inst_30183 = (state_30190[(2)]);
var state_30190__$1 = (function (){var statearr_30231 = state_30190;
(statearr_30231[(28)] = inst_30183);

return statearr_30231;
})();
var statearr_30232_30302 = state_30190__$1;
(statearr_30232_30302[(2)] = null);

(statearr_30232_30302[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (6))){
var inst_30122 = (state_30190[(29)]);
var inst_30121 = cljs.core.deref.call(null,cs);
var inst_30122__$1 = cljs.core.keys.call(null,inst_30121);
var inst_30123 = cljs.core.count.call(null,inst_30122__$1);
var inst_30124 = cljs.core.reset_BANG_.call(null,dctr,inst_30123);
var inst_30129 = cljs.core.seq.call(null,inst_30122__$1);
var inst_30130 = inst_30129;
var inst_30131 = null;
var inst_30132 = (0);
var inst_30133 = (0);
var state_30190__$1 = (function (){var statearr_30233 = state_30190;
(statearr_30233[(20)] = inst_30130);

(statearr_30233[(29)] = inst_30122__$1);

(statearr_30233[(30)] = inst_30124);

(statearr_30233[(10)] = inst_30131);

(statearr_30233[(11)] = inst_30133);

(statearr_30233[(21)] = inst_30132);

return statearr_30233;
})();
var statearr_30234_30303 = state_30190__$1;
(statearr_30234_30303[(2)] = null);

(statearr_30234_30303[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (28))){
var inst_30130 = (state_30190[(20)]);
var inst_30149 = (state_30190[(25)]);
var inst_30149__$1 = cljs.core.seq.call(null,inst_30130);
var state_30190__$1 = (function (){var statearr_30235 = state_30190;
(statearr_30235[(25)] = inst_30149__$1);

return statearr_30235;
})();
if(inst_30149__$1){
var statearr_30236_30304 = state_30190__$1;
(statearr_30236_30304[(1)] = (33));

} else {
var statearr_30237_30305 = state_30190__$1;
(statearr_30237_30305[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (25))){
var inst_30133 = (state_30190[(11)]);
var inst_30132 = (state_30190[(21)]);
var inst_30135 = (inst_30133 < inst_30132);
var inst_30136 = inst_30135;
var state_30190__$1 = state_30190;
if(cljs.core.truth_(inst_30136)){
var statearr_30238_30306 = state_30190__$1;
(statearr_30238_30306[(1)] = (27));

} else {
var statearr_30239_30307 = state_30190__$1;
(statearr_30239_30307[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (34))){
var state_30190__$1 = state_30190;
var statearr_30240_30308 = state_30190__$1;
(statearr_30240_30308[(2)] = null);

(statearr_30240_30308[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (17))){
var state_30190__$1 = state_30190;
var statearr_30241_30309 = state_30190__$1;
(statearr_30241_30309[(2)] = null);

(statearr_30241_30309[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (3))){
var inst_30188 = (state_30190[(2)]);
var state_30190__$1 = state_30190;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30190__$1,inst_30188);
} else {
if((state_val_30191 === (12))){
var inst_30117 = (state_30190[(2)]);
var state_30190__$1 = state_30190;
var statearr_30242_30310 = state_30190__$1;
(statearr_30242_30310[(2)] = inst_30117);

(statearr_30242_30310[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (2))){
var state_30190__$1 = state_30190;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30190__$1,(4),ch);
} else {
if((state_val_30191 === (23))){
var state_30190__$1 = state_30190;
var statearr_30243_30311 = state_30190__$1;
(statearr_30243_30311[(2)] = null);

(statearr_30243_30311[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (35))){
var inst_30172 = (state_30190[(2)]);
var state_30190__$1 = state_30190;
var statearr_30244_30312 = state_30190__$1;
(statearr_30244_30312[(2)] = inst_30172);

(statearr_30244_30312[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (19))){
var inst_30091 = (state_30190[(7)]);
var inst_30095 = cljs.core.chunk_first.call(null,inst_30091);
var inst_30096 = cljs.core.chunk_rest.call(null,inst_30091);
var inst_30097 = cljs.core.count.call(null,inst_30095);
var inst_30071 = inst_30096;
var inst_30072 = inst_30095;
var inst_30073 = inst_30097;
var inst_30074 = (0);
var state_30190__$1 = (function (){var statearr_30245 = state_30190;
(statearr_30245[(13)] = inst_30071);

(statearr_30245[(14)] = inst_30072);

(statearr_30245[(15)] = inst_30073);

(statearr_30245[(17)] = inst_30074);

return statearr_30245;
})();
var statearr_30246_30313 = state_30190__$1;
(statearr_30246_30313[(2)] = null);

(statearr_30246_30313[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (11))){
var inst_30071 = (state_30190[(13)]);
var inst_30091 = (state_30190[(7)]);
var inst_30091__$1 = cljs.core.seq.call(null,inst_30071);
var state_30190__$1 = (function (){var statearr_30247 = state_30190;
(statearr_30247[(7)] = inst_30091__$1);

return statearr_30247;
})();
if(inst_30091__$1){
var statearr_30248_30314 = state_30190__$1;
(statearr_30248_30314[(1)] = (16));

} else {
var statearr_30249_30315 = state_30190__$1;
(statearr_30249_30315[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (9))){
var inst_30119 = (state_30190[(2)]);
var state_30190__$1 = state_30190;
var statearr_30250_30316 = state_30190__$1;
(statearr_30250_30316[(2)] = inst_30119);

(statearr_30250_30316[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (5))){
var inst_30069 = cljs.core.deref.call(null,cs);
var inst_30070 = cljs.core.seq.call(null,inst_30069);
var inst_30071 = inst_30070;
var inst_30072 = null;
var inst_30073 = (0);
var inst_30074 = (0);
var state_30190__$1 = (function (){var statearr_30251 = state_30190;
(statearr_30251[(13)] = inst_30071);

(statearr_30251[(14)] = inst_30072);

(statearr_30251[(15)] = inst_30073);

(statearr_30251[(17)] = inst_30074);

return statearr_30251;
})();
var statearr_30252_30317 = state_30190__$1;
(statearr_30252_30317[(2)] = null);

(statearr_30252_30317[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (14))){
var state_30190__$1 = state_30190;
var statearr_30253_30318 = state_30190__$1;
(statearr_30253_30318[(2)] = null);

(statearr_30253_30318[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (45))){
var inst_30180 = (state_30190[(2)]);
var state_30190__$1 = state_30190;
var statearr_30254_30319 = state_30190__$1;
(statearr_30254_30319[(2)] = inst_30180);

(statearr_30254_30319[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (26))){
var inst_30122 = (state_30190[(29)]);
var inst_30176 = (state_30190[(2)]);
var inst_30177 = cljs.core.seq.call(null,inst_30122);
var state_30190__$1 = (function (){var statearr_30255 = state_30190;
(statearr_30255[(31)] = inst_30176);

return statearr_30255;
})();
if(inst_30177){
var statearr_30256_30320 = state_30190__$1;
(statearr_30256_30320[(1)] = (42));

} else {
var statearr_30257_30321 = state_30190__$1;
(statearr_30257_30321[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (16))){
var inst_30091 = (state_30190[(7)]);
var inst_30093 = cljs.core.chunked_seq_QMARK_.call(null,inst_30091);
var state_30190__$1 = state_30190;
if(inst_30093){
var statearr_30258_30322 = state_30190__$1;
(statearr_30258_30322[(1)] = (19));

} else {
var statearr_30259_30323 = state_30190__$1;
(statearr_30259_30323[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (38))){
var inst_30169 = (state_30190[(2)]);
var state_30190__$1 = state_30190;
var statearr_30260_30324 = state_30190__$1;
(statearr_30260_30324[(2)] = inst_30169);

(statearr_30260_30324[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (30))){
var state_30190__$1 = state_30190;
var statearr_30261_30325 = state_30190__$1;
(statearr_30261_30325[(2)] = null);

(statearr_30261_30325[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (10))){
var inst_30072 = (state_30190[(14)]);
var inst_30074 = (state_30190[(17)]);
var inst_30080 = cljs.core._nth.call(null,inst_30072,inst_30074);
var inst_30081 = cljs.core.nth.call(null,inst_30080,(0),null);
var inst_30082 = cljs.core.nth.call(null,inst_30080,(1),null);
var state_30190__$1 = (function (){var statearr_30262 = state_30190;
(statearr_30262[(26)] = inst_30081);

return statearr_30262;
})();
if(cljs.core.truth_(inst_30082)){
var statearr_30263_30326 = state_30190__$1;
(statearr_30263_30326[(1)] = (13));

} else {
var statearr_30264_30327 = state_30190__$1;
(statearr_30264_30327[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (18))){
var inst_30115 = (state_30190[(2)]);
var state_30190__$1 = state_30190;
var statearr_30265_30328 = state_30190__$1;
(statearr_30265_30328[(2)] = inst_30115);

(statearr_30265_30328[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (42))){
var state_30190__$1 = state_30190;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30190__$1,(45),dchan);
} else {
if((state_val_30191 === (37))){
var inst_30158 = (state_30190[(23)]);
var inst_30149 = (state_30190[(25)]);
var inst_30062 = (state_30190[(12)]);
var inst_30158__$1 = cljs.core.first.call(null,inst_30149);
var inst_30159 = cljs.core.async.put_BANG_.call(null,inst_30158__$1,inst_30062,done);
var state_30190__$1 = (function (){var statearr_30266 = state_30190;
(statearr_30266[(23)] = inst_30158__$1);

return statearr_30266;
})();
if(cljs.core.truth_(inst_30159)){
var statearr_30267_30329 = state_30190__$1;
(statearr_30267_30329[(1)] = (39));

} else {
var statearr_30268_30330 = state_30190__$1;
(statearr_30268_30330[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (8))){
var inst_30073 = (state_30190[(15)]);
var inst_30074 = (state_30190[(17)]);
var inst_30076 = (inst_30074 < inst_30073);
var inst_30077 = inst_30076;
var state_30190__$1 = state_30190;
if(cljs.core.truth_(inst_30077)){
var statearr_30269_30331 = state_30190__$1;
(statearr_30269_30331[(1)] = (10));

} else {
var statearr_30270_30332 = state_30190__$1;
(statearr_30270_30332[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__28309__auto___30278,cs,m,dchan,dctr,done))
;
return ((function (switch__28294__auto__,c__28309__auto___30278,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__28295__auto__ = null;
var cljs$core$async$mult_$_state_machine__28295__auto____0 = (function (){
var statearr_30274 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30274[(0)] = cljs$core$async$mult_$_state_machine__28295__auto__);

(statearr_30274[(1)] = (1));

return statearr_30274;
});
var cljs$core$async$mult_$_state_machine__28295__auto____1 = (function (state_30190){
while(true){
var ret_value__28296__auto__ = (function (){try{while(true){
var result__28297__auto__ = switch__28294__auto__.call(null,state_30190);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28297__auto__;
}
break;
}
}catch (e30275){if((e30275 instanceof Object)){
var ex__28298__auto__ = e30275;
var statearr_30276_30333 = state_30190;
(statearr_30276_30333[(5)] = ex__28298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30190);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30275;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30334 = state_30190;
state_30190 = G__30334;
continue;
} else {
return ret_value__28296__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__28295__auto__ = function(state_30190){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__28295__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__28295__auto____1.call(this,state_30190);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__28295__auto____0;
cljs$core$async$mult_$_state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__28295__auto____1;
return cljs$core$async$mult_$_state_machine__28295__auto__;
})()
;})(switch__28294__auto__,c__28309__auto___30278,cs,m,dchan,dctr,done))
})();
var state__28311__auto__ = (function (){var statearr_30277 = f__28310__auto__.call(null);
(statearr_30277[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28309__auto___30278);

return statearr_30277;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28311__auto__);
});})(c__28309__auto___30278,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args30335 = [];
var len__7280__auto___30338 = arguments.length;
var i__7281__auto___30339 = (0);
while(true){
if((i__7281__auto___30339 < len__7280__auto___30338)){
args30335.push((arguments[i__7281__auto___30339]));

var G__30340 = (i__7281__auto___30339 + (1));
i__7281__auto___30339 = G__30340;
continue;
} else {
}
break;
}

var G__30337 = args30335.length;
switch (G__30337) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30335.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__6873__auto__ = (((m == null))?null:m);
var m__6874__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return m__6874__auto__.call(null,m,ch);
} else {
var m__6874__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return m__6874__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__6873__auto__ = (((m == null))?null:m);
var m__6874__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return m__6874__auto__.call(null,m,ch);
} else {
var m__6874__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return m__6874__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__6873__auto__ = (((m == null))?null:m);
var m__6874__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return m__6874__auto__.call(null,m);
} else {
var m__6874__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return m__6874__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__6873__auto__ = (((m == null))?null:m);
var m__6874__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return m__6874__auto__.call(null,m,state_map);
} else {
var m__6874__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return m__6874__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__6873__auto__ = (((m == null))?null:m);
var m__6874__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return m__6874__auto__.call(null,m,mode);
} else {
var m__6874__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return m__6874__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7287__auto__ = [];
var len__7280__auto___30352 = arguments.length;
var i__7281__auto___30353 = (0);
while(true){
if((i__7281__auto___30353 < len__7280__auto___30352)){
args__7287__auto__.push((arguments[i__7281__auto___30353]));

var G__30354 = (i__7281__auto___30353 + (1));
i__7281__auto___30353 = G__30354;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((3) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7288__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__30346){
var map__30347 = p__30346;
var map__30347__$1 = ((((!((map__30347 == null)))?((((map__30347.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30347.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30347):map__30347);
var opts = map__30347__$1;
var statearr_30349_30355 = state;
(statearr_30349_30355[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__30347,map__30347__$1,opts){
return (function (val){
var statearr_30350_30356 = state;
(statearr_30350_30356[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__30347,map__30347__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_30351_30357 = state;
(statearr_30351_30357[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq30342){
var G__30343 = cljs.core.first.call(null,seq30342);
var seq30342__$1 = cljs.core.next.call(null,seq30342);
var G__30344 = cljs.core.first.call(null,seq30342__$1);
var seq30342__$2 = cljs.core.next.call(null,seq30342__$1);
var G__30345 = cljs.core.first.call(null,seq30342__$2);
var seq30342__$3 = cljs.core.next.call(null,seq30342__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__30343,G__30344,G__30345,seq30342__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async30521 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30521 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta30522){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta30522 = meta30522;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async30521.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_30523,meta30522__$1){
var self__ = this;
var _30523__$1 = this;
return (new cljs.core.async.t_cljs$core$async30521(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta30522__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30521.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_30523){
var self__ = this;
var _30523__$1 = this;
return self__.meta30522;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30521.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async30521.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30521.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async30521.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30521.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30521.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30521.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30521.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30521.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta30522","meta30522",-1076525888,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30521.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30521.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30521";

cljs.core.async.t_cljs$core$async30521.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write.call(null,writer__6817__auto__,"cljs.core.async/t_cljs$core$async30521");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async30521 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async30521(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta30522){
return (new cljs.core.async.t_cljs$core$async30521(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta30522));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async30521(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__28309__auto___30684 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__28309__auto___30684,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__28310__auto__ = (function (){var switch__28294__auto__ = ((function (c__28309__auto___30684,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_30621){
var state_val_30622 = (state_30621[(1)]);
if((state_val_30622 === (7))){
var inst_30539 = (state_30621[(2)]);
var state_30621__$1 = state_30621;
var statearr_30623_30685 = state_30621__$1;
(statearr_30623_30685[(2)] = inst_30539);

(statearr_30623_30685[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30622 === (20))){
var inst_30551 = (state_30621[(7)]);
var state_30621__$1 = state_30621;
var statearr_30624_30686 = state_30621__$1;
(statearr_30624_30686[(2)] = inst_30551);

(statearr_30624_30686[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30622 === (27))){
var state_30621__$1 = state_30621;
var statearr_30625_30687 = state_30621__$1;
(statearr_30625_30687[(2)] = null);

(statearr_30625_30687[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30622 === (1))){
var inst_30527 = (state_30621[(8)]);
var inst_30527__$1 = calc_state.call(null);
var inst_30529 = (inst_30527__$1 == null);
var inst_30530 = cljs.core.not.call(null,inst_30529);
var state_30621__$1 = (function (){var statearr_30626 = state_30621;
(statearr_30626[(8)] = inst_30527__$1);

return statearr_30626;
})();
if(inst_30530){
var statearr_30627_30688 = state_30621__$1;
(statearr_30627_30688[(1)] = (2));

} else {
var statearr_30628_30689 = state_30621__$1;
(statearr_30628_30689[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30622 === (24))){
var inst_30574 = (state_30621[(9)]);
var inst_30595 = (state_30621[(10)]);
var inst_30581 = (state_30621[(11)]);
var inst_30595__$1 = inst_30574.call(null,inst_30581);
var state_30621__$1 = (function (){var statearr_30629 = state_30621;
(statearr_30629[(10)] = inst_30595__$1);

return statearr_30629;
})();
if(cljs.core.truth_(inst_30595__$1)){
var statearr_30630_30690 = state_30621__$1;
(statearr_30630_30690[(1)] = (29));

} else {
var statearr_30631_30691 = state_30621__$1;
(statearr_30631_30691[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30622 === (4))){
var inst_30542 = (state_30621[(2)]);
var state_30621__$1 = state_30621;
if(cljs.core.truth_(inst_30542)){
var statearr_30632_30692 = state_30621__$1;
(statearr_30632_30692[(1)] = (8));

} else {
var statearr_30633_30693 = state_30621__$1;
(statearr_30633_30693[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30622 === (15))){
var inst_30568 = (state_30621[(2)]);
var state_30621__$1 = state_30621;
if(cljs.core.truth_(inst_30568)){
var statearr_30634_30694 = state_30621__$1;
(statearr_30634_30694[(1)] = (19));

} else {
var statearr_30635_30695 = state_30621__$1;
(statearr_30635_30695[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30622 === (21))){
var inst_30573 = (state_30621[(12)]);
var inst_30573__$1 = (state_30621[(2)]);
var inst_30574 = cljs.core.get.call(null,inst_30573__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_30575 = cljs.core.get.call(null,inst_30573__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_30576 = cljs.core.get.call(null,inst_30573__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_30621__$1 = (function (){var statearr_30636 = state_30621;
(statearr_30636[(9)] = inst_30574);

(statearr_30636[(12)] = inst_30573__$1);

(statearr_30636[(13)] = inst_30575);

return statearr_30636;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_30621__$1,(22),inst_30576);
} else {
if((state_val_30622 === (31))){
var inst_30603 = (state_30621[(2)]);
var state_30621__$1 = state_30621;
if(cljs.core.truth_(inst_30603)){
var statearr_30637_30696 = state_30621__$1;
(statearr_30637_30696[(1)] = (32));

} else {
var statearr_30638_30697 = state_30621__$1;
(statearr_30638_30697[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30622 === (32))){
var inst_30580 = (state_30621[(14)]);
var state_30621__$1 = state_30621;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30621__$1,(35),out,inst_30580);
} else {
if((state_val_30622 === (33))){
var inst_30573 = (state_30621[(12)]);
var inst_30551 = inst_30573;
var state_30621__$1 = (function (){var statearr_30639 = state_30621;
(statearr_30639[(7)] = inst_30551);

return statearr_30639;
})();
var statearr_30640_30698 = state_30621__$1;
(statearr_30640_30698[(2)] = null);

(statearr_30640_30698[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30622 === (13))){
var inst_30551 = (state_30621[(7)]);
var inst_30558 = inst_30551.cljs$lang$protocol_mask$partition0$;
var inst_30559 = (inst_30558 & (64));
var inst_30560 = inst_30551.cljs$core$ISeq$;
var inst_30561 = (inst_30559) || (inst_30560);
var state_30621__$1 = state_30621;
if(cljs.core.truth_(inst_30561)){
var statearr_30641_30699 = state_30621__$1;
(statearr_30641_30699[(1)] = (16));

} else {
var statearr_30642_30700 = state_30621__$1;
(statearr_30642_30700[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30622 === (22))){
var inst_30580 = (state_30621[(14)]);
var inst_30581 = (state_30621[(11)]);
var inst_30579 = (state_30621[(2)]);
var inst_30580__$1 = cljs.core.nth.call(null,inst_30579,(0),null);
var inst_30581__$1 = cljs.core.nth.call(null,inst_30579,(1),null);
var inst_30582 = (inst_30580__$1 == null);
var inst_30583 = cljs.core._EQ_.call(null,inst_30581__$1,change);
var inst_30584 = (inst_30582) || (inst_30583);
var state_30621__$1 = (function (){var statearr_30643 = state_30621;
(statearr_30643[(14)] = inst_30580__$1);

(statearr_30643[(11)] = inst_30581__$1);

return statearr_30643;
})();
if(cljs.core.truth_(inst_30584)){
var statearr_30644_30701 = state_30621__$1;
(statearr_30644_30701[(1)] = (23));

} else {
var statearr_30645_30702 = state_30621__$1;
(statearr_30645_30702[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30622 === (36))){
var inst_30573 = (state_30621[(12)]);
var inst_30551 = inst_30573;
var state_30621__$1 = (function (){var statearr_30646 = state_30621;
(statearr_30646[(7)] = inst_30551);

return statearr_30646;
})();
var statearr_30647_30703 = state_30621__$1;
(statearr_30647_30703[(2)] = null);

(statearr_30647_30703[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30622 === (29))){
var inst_30595 = (state_30621[(10)]);
var state_30621__$1 = state_30621;
var statearr_30648_30704 = state_30621__$1;
(statearr_30648_30704[(2)] = inst_30595);

(statearr_30648_30704[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30622 === (6))){
var state_30621__$1 = state_30621;
var statearr_30649_30705 = state_30621__$1;
(statearr_30649_30705[(2)] = false);

(statearr_30649_30705[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30622 === (28))){
var inst_30591 = (state_30621[(2)]);
var inst_30592 = calc_state.call(null);
var inst_30551 = inst_30592;
var state_30621__$1 = (function (){var statearr_30650 = state_30621;
(statearr_30650[(7)] = inst_30551);

(statearr_30650[(15)] = inst_30591);

return statearr_30650;
})();
var statearr_30651_30706 = state_30621__$1;
(statearr_30651_30706[(2)] = null);

(statearr_30651_30706[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30622 === (25))){
var inst_30617 = (state_30621[(2)]);
var state_30621__$1 = state_30621;
var statearr_30652_30707 = state_30621__$1;
(statearr_30652_30707[(2)] = inst_30617);

(statearr_30652_30707[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30622 === (34))){
var inst_30615 = (state_30621[(2)]);
var state_30621__$1 = state_30621;
var statearr_30653_30708 = state_30621__$1;
(statearr_30653_30708[(2)] = inst_30615);

(statearr_30653_30708[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30622 === (17))){
var state_30621__$1 = state_30621;
var statearr_30654_30709 = state_30621__$1;
(statearr_30654_30709[(2)] = false);

(statearr_30654_30709[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30622 === (3))){
var state_30621__$1 = state_30621;
var statearr_30655_30710 = state_30621__$1;
(statearr_30655_30710[(2)] = false);

(statearr_30655_30710[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30622 === (12))){
var inst_30619 = (state_30621[(2)]);
var state_30621__$1 = state_30621;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30621__$1,inst_30619);
} else {
if((state_val_30622 === (2))){
var inst_30527 = (state_30621[(8)]);
var inst_30532 = inst_30527.cljs$lang$protocol_mask$partition0$;
var inst_30533 = (inst_30532 & (64));
var inst_30534 = inst_30527.cljs$core$ISeq$;
var inst_30535 = (inst_30533) || (inst_30534);
var state_30621__$1 = state_30621;
if(cljs.core.truth_(inst_30535)){
var statearr_30656_30711 = state_30621__$1;
(statearr_30656_30711[(1)] = (5));

} else {
var statearr_30657_30712 = state_30621__$1;
(statearr_30657_30712[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30622 === (23))){
var inst_30580 = (state_30621[(14)]);
var inst_30586 = (inst_30580 == null);
var state_30621__$1 = state_30621;
if(cljs.core.truth_(inst_30586)){
var statearr_30658_30713 = state_30621__$1;
(statearr_30658_30713[(1)] = (26));

} else {
var statearr_30659_30714 = state_30621__$1;
(statearr_30659_30714[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30622 === (35))){
var inst_30606 = (state_30621[(2)]);
var state_30621__$1 = state_30621;
if(cljs.core.truth_(inst_30606)){
var statearr_30660_30715 = state_30621__$1;
(statearr_30660_30715[(1)] = (36));

} else {
var statearr_30661_30716 = state_30621__$1;
(statearr_30661_30716[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30622 === (19))){
var inst_30551 = (state_30621[(7)]);
var inst_30570 = cljs.core.apply.call(null,cljs.core.hash_map,inst_30551);
var state_30621__$1 = state_30621;
var statearr_30662_30717 = state_30621__$1;
(statearr_30662_30717[(2)] = inst_30570);

(statearr_30662_30717[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30622 === (11))){
var inst_30551 = (state_30621[(7)]);
var inst_30555 = (inst_30551 == null);
var inst_30556 = cljs.core.not.call(null,inst_30555);
var state_30621__$1 = state_30621;
if(inst_30556){
var statearr_30663_30718 = state_30621__$1;
(statearr_30663_30718[(1)] = (13));

} else {
var statearr_30664_30719 = state_30621__$1;
(statearr_30664_30719[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30622 === (9))){
var inst_30527 = (state_30621[(8)]);
var state_30621__$1 = state_30621;
var statearr_30665_30720 = state_30621__$1;
(statearr_30665_30720[(2)] = inst_30527);

(statearr_30665_30720[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30622 === (5))){
var state_30621__$1 = state_30621;
var statearr_30666_30721 = state_30621__$1;
(statearr_30666_30721[(2)] = true);

(statearr_30666_30721[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30622 === (14))){
var state_30621__$1 = state_30621;
var statearr_30667_30722 = state_30621__$1;
(statearr_30667_30722[(2)] = false);

(statearr_30667_30722[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30622 === (26))){
var inst_30581 = (state_30621[(11)]);
var inst_30588 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_30581);
var state_30621__$1 = state_30621;
var statearr_30668_30723 = state_30621__$1;
(statearr_30668_30723[(2)] = inst_30588);

(statearr_30668_30723[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30622 === (16))){
var state_30621__$1 = state_30621;
var statearr_30669_30724 = state_30621__$1;
(statearr_30669_30724[(2)] = true);

(statearr_30669_30724[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30622 === (38))){
var inst_30611 = (state_30621[(2)]);
var state_30621__$1 = state_30621;
var statearr_30670_30725 = state_30621__$1;
(statearr_30670_30725[(2)] = inst_30611);

(statearr_30670_30725[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30622 === (30))){
var inst_30574 = (state_30621[(9)]);
var inst_30575 = (state_30621[(13)]);
var inst_30581 = (state_30621[(11)]);
var inst_30598 = cljs.core.empty_QMARK_.call(null,inst_30574);
var inst_30599 = inst_30575.call(null,inst_30581);
var inst_30600 = cljs.core.not.call(null,inst_30599);
var inst_30601 = (inst_30598) && (inst_30600);
var state_30621__$1 = state_30621;
var statearr_30671_30726 = state_30621__$1;
(statearr_30671_30726[(2)] = inst_30601);

(statearr_30671_30726[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30622 === (10))){
var inst_30527 = (state_30621[(8)]);
var inst_30547 = (state_30621[(2)]);
var inst_30548 = cljs.core.get.call(null,inst_30547,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_30549 = cljs.core.get.call(null,inst_30547,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_30550 = cljs.core.get.call(null,inst_30547,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_30551 = inst_30527;
var state_30621__$1 = (function (){var statearr_30672 = state_30621;
(statearr_30672[(7)] = inst_30551);

(statearr_30672[(16)] = inst_30550);

(statearr_30672[(17)] = inst_30548);

(statearr_30672[(18)] = inst_30549);

return statearr_30672;
})();
var statearr_30673_30727 = state_30621__$1;
(statearr_30673_30727[(2)] = null);

(statearr_30673_30727[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30622 === (18))){
var inst_30565 = (state_30621[(2)]);
var state_30621__$1 = state_30621;
var statearr_30674_30728 = state_30621__$1;
(statearr_30674_30728[(2)] = inst_30565);

(statearr_30674_30728[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30622 === (37))){
var state_30621__$1 = state_30621;
var statearr_30675_30729 = state_30621__$1;
(statearr_30675_30729[(2)] = null);

(statearr_30675_30729[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30622 === (8))){
var inst_30527 = (state_30621[(8)]);
var inst_30544 = cljs.core.apply.call(null,cljs.core.hash_map,inst_30527);
var state_30621__$1 = state_30621;
var statearr_30676_30730 = state_30621__$1;
(statearr_30676_30730[(2)] = inst_30544);

(statearr_30676_30730[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__28309__auto___30684,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__28294__auto__,c__28309__auto___30684,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__28295__auto__ = null;
var cljs$core$async$mix_$_state_machine__28295__auto____0 = (function (){
var statearr_30680 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30680[(0)] = cljs$core$async$mix_$_state_machine__28295__auto__);

(statearr_30680[(1)] = (1));

return statearr_30680;
});
var cljs$core$async$mix_$_state_machine__28295__auto____1 = (function (state_30621){
while(true){
var ret_value__28296__auto__ = (function (){try{while(true){
var result__28297__auto__ = switch__28294__auto__.call(null,state_30621);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28297__auto__;
}
break;
}
}catch (e30681){if((e30681 instanceof Object)){
var ex__28298__auto__ = e30681;
var statearr_30682_30731 = state_30621;
(statearr_30682_30731[(5)] = ex__28298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30621);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30681;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30732 = state_30621;
state_30621 = G__30732;
continue;
} else {
return ret_value__28296__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__28295__auto__ = function(state_30621){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__28295__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__28295__auto____1.call(this,state_30621);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__28295__auto____0;
cljs$core$async$mix_$_state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__28295__auto____1;
return cljs$core$async$mix_$_state_machine__28295__auto__;
})()
;})(switch__28294__auto__,c__28309__auto___30684,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__28311__auto__ = (function (){var statearr_30683 = f__28310__auto__.call(null);
(statearr_30683[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28309__auto___30684);

return statearr_30683;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28311__auto__);
});})(c__28309__auto___30684,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__6873__auto__ = (((p == null))?null:p);
var m__6874__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return m__6874__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__6874__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return m__6874__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__6873__auto__ = (((p == null))?null:p);
var m__6874__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return m__6874__auto__.call(null,p,v,ch);
} else {
var m__6874__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return m__6874__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args30733 = [];
var len__7280__auto___30736 = arguments.length;
var i__7281__auto___30737 = (0);
while(true){
if((i__7281__auto___30737 < len__7280__auto___30736)){
args30733.push((arguments[i__7281__auto___30737]));

var G__30738 = (i__7281__auto___30737 + (1));
i__7281__auto___30737 = G__30738;
continue;
} else {
}
break;
}

var G__30735 = args30733.length;
switch (G__30735) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30733.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__6873__auto__ = (((p == null))?null:p);
var m__6874__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return m__6874__auto__.call(null,p);
} else {
var m__6874__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return m__6874__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__6873__auto__ = (((p == null))?null:p);
var m__6874__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return m__6874__auto__.call(null,p,v);
} else {
var m__6874__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return m__6874__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args30741 = [];
var len__7280__auto___30866 = arguments.length;
var i__7281__auto___30867 = (0);
while(true){
if((i__7281__auto___30867 < len__7280__auto___30866)){
args30741.push((arguments[i__7281__auto___30867]));

var G__30868 = (i__7281__auto___30867 + (1));
i__7281__auto___30867 = G__30868;
continue;
} else {
}
break;
}

var G__30743 = args30741.length;
switch (G__30743) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30741.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__6210__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__6210__auto__)){
return or__6210__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__6210__auto__,mults){
return (function (p1__30740_SHARP_){
if(cljs.core.truth_(p1__30740_SHARP_.call(null,topic))){
return p1__30740_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__30740_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__6210__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async30744 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30744 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta30745){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta30745 = meta30745;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async30744.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_30746,meta30745__$1){
var self__ = this;
var _30746__$1 = this;
return (new cljs.core.async.t_cljs$core$async30744(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta30745__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async30744.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_30746){
var self__ = this;
var _30746__$1 = this;
return self__.meta30745;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async30744.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async30744.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async30744.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async30744.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async30744.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async30744.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async30744.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async30744.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta30745","meta30745",-852763764,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async30744.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30744.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30744";

cljs.core.async.t_cljs$core$async30744.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write.call(null,writer__6817__auto__,"cljs.core.async/t_cljs$core$async30744");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async30744 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async30744(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta30745){
return (new cljs.core.async.t_cljs$core$async30744(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta30745));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async30744(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__28309__auto___30870 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__28309__auto___30870,mults,ensure_mult,p){
return (function (){
var f__28310__auto__ = (function (){var switch__28294__auto__ = ((function (c__28309__auto___30870,mults,ensure_mult,p){
return (function (state_30818){
var state_val_30819 = (state_30818[(1)]);
if((state_val_30819 === (7))){
var inst_30814 = (state_30818[(2)]);
var state_30818__$1 = state_30818;
var statearr_30820_30871 = state_30818__$1;
(statearr_30820_30871[(2)] = inst_30814);

(statearr_30820_30871[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30819 === (20))){
var state_30818__$1 = state_30818;
var statearr_30821_30872 = state_30818__$1;
(statearr_30821_30872[(2)] = null);

(statearr_30821_30872[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30819 === (1))){
var state_30818__$1 = state_30818;
var statearr_30822_30873 = state_30818__$1;
(statearr_30822_30873[(2)] = null);

(statearr_30822_30873[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30819 === (24))){
var inst_30797 = (state_30818[(7)]);
var inst_30806 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_30797);
var state_30818__$1 = state_30818;
var statearr_30823_30874 = state_30818__$1;
(statearr_30823_30874[(2)] = inst_30806);

(statearr_30823_30874[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30819 === (4))){
var inst_30749 = (state_30818[(8)]);
var inst_30749__$1 = (state_30818[(2)]);
var inst_30750 = (inst_30749__$1 == null);
var state_30818__$1 = (function (){var statearr_30824 = state_30818;
(statearr_30824[(8)] = inst_30749__$1);

return statearr_30824;
})();
if(cljs.core.truth_(inst_30750)){
var statearr_30825_30875 = state_30818__$1;
(statearr_30825_30875[(1)] = (5));

} else {
var statearr_30826_30876 = state_30818__$1;
(statearr_30826_30876[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30819 === (15))){
var inst_30791 = (state_30818[(2)]);
var state_30818__$1 = state_30818;
var statearr_30827_30877 = state_30818__$1;
(statearr_30827_30877[(2)] = inst_30791);

(statearr_30827_30877[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30819 === (21))){
var inst_30811 = (state_30818[(2)]);
var state_30818__$1 = (function (){var statearr_30828 = state_30818;
(statearr_30828[(9)] = inst_30811);

return statearr_30828;
})();
var statearr_30829_30878 = state_30818__$1;
(statearr_30829_30878[(2)] = null);

(statearr_30829_30878[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30819 === (13))){
var inst_30773 = (state_30818[(10)]);
var inst_30775 = cljs.core.chunked_seq_QMARK_.call(null,inst_30773);
var state_30818__$1 = state_30818;
if(inst_30775){
var statearr_30830_30879 = state_30818__$1;
(statearr_30830_30879[(1)] = (16));

} else {
var statearr_30831_30880 = state_30818__$1;
(statearr_30831_30880[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30819 === (22))){
var inst_30803 = (state_30818[(2)]);
var state_30818__$1 = state_30818;
if(cljs.core.truth_(inst_30803)){
var statearr_30832_30881 = state_30818__$1;
(statearr_30832_30881[(1)] = (23));

} else {
var statearr_30833_30882 = state_30818__$1;
(statearr_30833_30882[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30819 === (6))){
var inst_30799 = (state_30818[(11)]);
var inst_30797 = (state_30818[(7)]);
var inst_30749 = (state_30818[(8)]);
var inst_30797__$1 = topic_fn.call(null,inst_30749);
var inst_30798 = cljs.core.deref.call(null,mults);
var inst_30799__$1 = cljs.core.get.call(null,inst_30798,inst_30797__$1);
var state_30818__$1 = (function (){var statearr_30834 = state_30818;
(statearr_30834[(11)] = inst_30799__$1);

(statearr_30834[(7)] = inst_30797__$1);

return statearr_30834;
})();
if(cljs.core.truth_(inst_30799__$1)){
var statearr_30835_30883 = state_30818__$1;
(statearr_30835_30883[(1)] = (19));

} else {
var statearr_30836_30884 = state_30818__$1;
(statearr_30836_30884[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30819 === (25))){
var inst_30808 = (state_30818[(2)]);
var state_30818__$1 = state_30818;
var statearr_30837_30885 = state_30818__$1;
(statearr_30837_30885[(2)] = inst_30808);

(statearr_30837_30885[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30819 === (17))){
var inst_30773 = (state_30818[(10)]);
var inst_30782 = cljs.core.first.call(null,inst_30773);
var inst_30783 = cljs.core.async.muxch_STAR_.call(null,inst_30782);
var inst_30784 = cljs.core.async.close_BANG_.call(null,inst_30783);
var inst_30785 = cljs.core.next.call(null,inst_30773);
var inst_30759 = inst_30785;
var inst_30760 = null;
var inst_30761 = (0);
var inst_30762 = (0);
var state_30818__$1 = (function (){var statearr_30838 = state_30818;
(statearr_30838[(12)] = inst_30762);

(statearr_30838[(13)] = inst_30761);

(statearr_30838[(14)] = inst_30784);

(statearr_30838[(15)] = inst_30760);

(statearr_30838[(16)] = inst_30759);

return statearr_30838;
})();
var statearr_30839_30886 = state_30818__$1;
(statearr_30839_30886[(2)] = null);

(statearr_30839_30886[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30819 === (3))){
var inst_30816 = (state_30818[(2)]);
var state_30818__$1 = state_30818;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30818__$1,inst_30816);
} else {
if((state_val_30819 === (12))){
var inst_30793 = (state_30818[(2)]);
var state_30818__$1 = state_30818;
var statearr_30840_30887 = state_30818__$1;
(statearr_30840_30887[(2)] = inst_30793);

(statearr_30840_30887[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30819 === (2))){
var state_30818__$1 = state_30818;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30818__$1,(4),ch);
} else {
if((state_val_30819 === (23))){
var state_30818__$1 = state_30818;
var statearr_30841_30888 = state_30818__$1;
(statearr_30841_30888[(2)] = null);

(statearr_30841_30888[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30819 === (19))){
var inst_30799 = (state_30818[(11)]);
var inst_30749 = (state_30818[(8)]);
var inst_30801 = cljs.core.async.muxch_STAR_.call(null,inst_30799);
var state_30818__$1 = state_30818;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30818__$1,(22),inst_30801,inst_30749);
} else {
if((state_val_30819 === (11))){
var inst_30773 = (state_30818[(10)]);
var inst_30759 = (state_30818[(16)]);
var inst_30773__$1 = cljs.core.seq.call(null,inst_30759);
var state_30818__$1 = (function (){var statearr_30842 = state_30818;
(statearr_30842[(10)] = inst_30773__$1);

return statearr_30842;
})();
if(inst_30773__$1){
var statearr_30843_30889 = state_30818__$1;
(statearr_30843_30889[(1)] = (13));

} else {
var statearr_30844_30890 = state_30818__$1;
(statearr_30844_30890[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30819 === (9))){
var inst_30795 = (state_30818[(2)]);
var state_30818__$1 = state_30818;
var statearr_30845_30891 = state_30818__$1;
(statearr_30845_30891[(2)] = inst_30795);

(statearr_30845_30891[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30819 === (5))){
var inst_30756 = cljs.core.deref.call(null,mults);
var inst_30757 = cljs.core.vals.call(null,inst_30756);
var inst_30758 = cljs.core.seq.call(null,inst_30757);
var inst_30759 = inst_30758;
var inst_30760 = null;
var inst_30761 = (0);
var inst_30762 = (0);
var state_30818__$1 = (function (){var statearr_30846 = state_30818;
(statearr_30846[(12)] = inst_30762);

(statearr_30846[(13)] = inst_30761);

(statearr_30846[(15)] = inst_30760);

(statearr_30846[(16)] = inst_30759);

return statearr_30846;
})();
var statearr_30847_30892 = state_30818__$1;
(statearr_30847_30892[(2)] = null);

(statearr_30847_30892[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30819 === (14))){
var state_30818__$1 = state_30818;
var statearr_30851_30893 = state_30818__$1;
(statearr_30851_30893[(2)] = null);

(statearr_30851_30893[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30819 === (16))){
var inst_30773 = (state_30818[(10)]);
var inst_30777 = cljs.core.chunk_first.call(null,inst_30773);
var inst_30778 = cljs.core.chunk_rest.call(null,inst_30773);
var inst_30779 = cljs.core.count.call(null,inst_30777);
var inst_30759 = inst_30778;
var inst_30760 = inst_30777;
var inst_30761 = inst_30779;
var inst_30762 = (0);
var state_30818__$1 = (function (){var statearr_30852 = state_30818;
(statearr_30852[(12)] = inst_30762);

(statearr_30852[(13)] = inst_30761);

(statearr_30852[(15)] = inst_30760);

(statearr_30852[(16)] = inst_30759);

return statearr_30852;
})();
var statearr_30853_30894 = state_30818__$1;
(statearr_30853_30894[(2)] = null);

(statearr_30853_30894[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30819 === (10))){
var inst_30762 = (state_30818[(12)]);
var inst_30761 = (state_30818[(13)]);
var inst_30760 = (state_30818[(15)]);
var inst_30759 = (state_30818[(16)]);
var inst_30767 = cljs.core._nth.call(null,inst_30760,inst_30762);
var inst_30768 = cljs.core.async.muxch_STAR_.call(null,inst_30767);
var inst_30769 = cljs.core.async.close_BANG_.call(null,inst_30768);
var inst_30770 = (inst_30762 + (1));
var tmp30848 = inst_30761;
var tmp30849 = inst_30760;
var tmp30850 = inst_30759;
var inst_30759__$1 = tmp30850;
var inst_30760__$1 = tmp30849;
var inst_30761__$1 = tmp30848;
var inst_30762__$1 = inst_30770;
var state_30818__$1 = (function (){var statearr_30854 = state_30818;
(statearr_30854[(12)] = inst_30762__$1);

(statearr_30854[(13)] = inst_30761__$1);

(statearr_30854[(17)] = inst_30769);

(statearr_30854[(15)] = inst_30760__$1);

(statearr_30854[(16)] = inst_30759__$1);

return statearr_30854;
})();
var statearr_30855_30895 = state_30818__$1;
(statearr_30855_30895[(2)] = null);

(statearr_30855_30895[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30819 === (18))){
var inst_30788 = (state_30818[(2)]);
var state_30818__$1 = state_30818;
var statearr_30856_30896 = state_30818__$1;
(statearr_30856_30896[(2)] = inst_30788);

(statearr_30856_30896[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30819 === (8))){
var inst_30762 = (state_30818[(12)]);
var inst_30761 = (state_30818[(13)]);
var inst_30764 = (inst_30762 < inst_30761);
var inst_30765 = inst_30764;
var state_30818__$1 = state_30818;
if(cljs.core.truth_(inst_30765)){
var statearr_30857_30897 = state_30818__$1;
(statearr_30857_30897[(1)] = (10));

} else {
var statearr_30858_30898 = state_30818__$1;
(statearr_30858_30898[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__28309__auto___30870,mults,ensure_mult,p))
;
return ((function (switch__28294__auto__,c__28309__auto___30870,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__28295__auto__ = null;
var cljs$core$async$state_machine__28295__auto____0 = (function (){
var statearr_30862 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30862[(0)] = cljs$core$async$state_machine__28295__auto__);

(statearr_30862[(1)] = (1));

return statearr_30862;
});
var cljs$core$async$state_machine__28295__auto____1 = (function (state_30818){
while(true){
var ret_value__28296__auto__ = (function (){try{while(true){
var result__28297__auto__ = switch__28294__auto__.call(null,state_30818);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28297__auto__;
}
break;
}
}catch (e30863){if((e30863 instanceof Object)){
var ex__28298__auto__ = e30863;
var statearr_30864_30899 = state_30818;
(statearr_30864_30899[(5)] = ex__28298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30818);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30863;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30900 = state_30818;
state_30818 = G__30900;
continue;
} else {
return ret_value__28296__auto__;
}
break;
}
});
cljs$core$async$state_machine__28295__auto__ = function(state_30818){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28295__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28295__auto____1.call(this,state_30818);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28295__auto____0;
cljs$core$async$state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28295__auto____1;
return cljs$core$async$state_machine__28295__auto__;
})()
;})(switch__28294__auto__,c__28309__auto___30870,mults,ensure_mult,p))
})();
var state__28311__auto__ = (function (){var statearr_30865 = f__28310__auto__.call(null);
(statearr_30865[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28309__auto___30870);

return statearr_30865;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28311__auto__);
});})(c__28309__auto___30870,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args30901 = [];
var len__7280__auto___30904 = arguments.length;
var i__7281__auto___30905 = (0);
while(true){
if((i__7281__auto___30905 < len__7280__auto___30904)){
args30901.push((arguments[i__7281__auto___30905]));

var G__30906 = (i__7281__auto___30905 + (1));
i__7281__auto___30905 = G__30906;
continue;
} else {
}
break;
}

var G__30903 = args30901.length;
switch (G__30903) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30901.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args30908 = [];
var len__7280__auto___30911 = arguments.length;
var i__7281__auto___30912 = (0);
while(true){
if((i__7281__auto___30912 < len__7280__auto___30911)){
args30908.push((arguments[i__7281__auto___30912]));

var G__30913 = (i__7281__auto___30912 + (1));
i__7281__auto___30912 = G__30913;
continue;
} else {
}
break;
}

var G__30910 = args30908.length;
switch (G__30910) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30908.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args30915 = [];
var len__7280__auto___30986 = arguments.length;
var i__7281__auto___30987 = (0);
while(true){
if((i__7281__auto___30987 < len__7280__auto___30986)){
args30915.push((arguments[i__7281__auto___30987]));

var G__30988 = (i__7281__auto___30987 + (1));
i__7281__auto___30987 = G__30988;
continue;
} else {
}
break;
}

var G__30917 = args30915.length;
switch (G__30917) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30915.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__28309__auto___30990 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__28309__auto___30990,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__28310__auto__ = (function (){var switch__28294__auto__ = ((function (c__28309__auto___30990,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_30956){
var state_val_30957 = (state_30956[(1)]);
if((state_val_30957 === (7))){
var state_30956__$1 = state_30956;
var statearr_30958_30991 = state_30956__$1;
(statearr_30958_30991[(2)] = null);

(statearr_30958_30991[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30957 === (1))){
var state_30956__$1 = state_30956;
var statearr_30959_30992 = state_30956__$1;
(statearr_30959_30992[(2)] = null);

(statearr_30959_30992[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30957 === (4))){
var inst_30920 = (state_30956[(7)]);
var inst_30922 = (inst_30920 < cnt);
var state_30956__$1 = state_30956;
if(cljs.core.truth_(inst_30922)){
var statearr_30960_30993 = state_30956__$1;
(statearr_30960_30993[(1)] = (6));

} else {
var statearr_30961_30994 = state_30956__$1;
(statearr_30961_30994[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30957 === (15))){
var inst_30952 = (state_30956[(2)]);
var state_30956__$1 = state_30956;
var statearr_30962_30995 = state_30956__$1;
(statearr_30962_30995[(2)] = inst_30952);

(statearr_30962_30995[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30957 === (13))){
var inst_30945 = cljs.core.async.close_BANG_.call(null,out);
var state_30956__$1 = state_30956;
var statearr_30963_30996 = state_30956__$1;
(statearr_30963_30996[(2)] = inst_30945);

(statearr_30963_30996[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30957 === (6))){
var state_30956__$1 = state_30956;
var statearr_30964_30997 = state_30956__$1;
(statearr_30964_30997[(2)] = null);

(statearr_30964_30997[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30957 === (3))){
var inst_30954 = (state_30956[(2)]);
var state_30956__$1 = state_30956;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30956__$1,inst_30954);
} else {
if((state_val_30957 === (12))){
var inst_30942 = (state_30956[(8)]);
var inst_30942__$1 = (state_30956[(2)]);
var inst_30943 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_30942__$1);
var state_30956__$1 = (function (){var statearr_30965 = state_30956;
(statearr_30965[(8)] = inst_30942__$1);

return statearr_30965;
})();
if(cljs.core.truth_(inst_30943)){
var statearr_30966_30998 = state_30956__$1;
(statearr_30966_30998[(1)] = (13));

} else {
var statearr_30967_30999 = state_30956__$1;
(statearr_30967_30999[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30957 === (2))){
var inst_30919 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_30920 = (0);
var state_30956__$1 = (function (){var statearr_30968 = state_30956;
(statearr_30968[(7)] = inst_30920);

(statearr_30968[(9)] = inst_30919);

return statearr_30968;
})();
var statearr_30969_31000 = state_30956__$1;
(statearr_30969_31000[(2)] = null);

(statearr_30969_31000[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30957 === (11))){
var inst_30920 = (state_30956[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_30956,(10),Object,null,(9));
var inst_30929 = chs__$1.call(null,inst_30920);
var inst_30930 = done.call(null,inst_30920);
var inst_30931 = cljs.core.async.take_BANG_.call(null,inst_30929,inst_30930);
var state_30956__$1 = state_30956;
var statearr_30970_31001 = state_30956__$1;
(statearr_30970_31001[(2)] = inst_30931);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30956__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30957 === (9))){
var inst_30920 = (state_30956[(7)]);
var inst_30933 = (state_30956[(2)]);
var inst_30934 = (inst_30920 + (1));
var inst_30920__$1 = inst_30934;
var state_30956__$1 = (function (){var statearr_30971 = state_30956;
(statearr_30971[(7)] = inst_30920__$1);

(statearr_30971[(10)] = inst_30933);

return statearr_30971;
})();
var statearr_30972_31002 = state_30956__$1;
(statearr_30972_31002[(2)] = null);

(statearr_30972_31002[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30957 === (5))){
var inst_30940 = (state_30956[(2)]);
var state_30956__$1 = (function (){var statearr_30973 = state_30956;
(statearr_30973[(11)] = inst_30940);

return statearr_30973;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30956__$1,(12),dchan);
} else {
if((state_val_30957 === (14))){
var inst_30942 = (state_30956[(8)]);
var inst_30947 = cljs.core.apply.call(null,f,inst_30942);
var state_30956__$1 = state_30956;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30956__$1,(16),out,inst_30947);
} else {
if((state_val_30957 === (16))){
var inst_30949 = (state_30956[(2)]);
var state_30956__$1 = (function (){var statearr_30974 = state_30956;
(statearr_30974[(12)] = inst_30949);

return statearr_30974;
})();
var statearr_30975_31003 = state_30956__$1;
(statearr_30975_31003[(2)] = null);

(statearr_30975_31003[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30957 === (10))){
var inst_30924 = (state_30956[(2)]);
var inst_30925 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_30956__$1 = (function (){var statearr_30976 = state_30956;
(statearr_30976[(13)] = inst_30924);

return statearr_30976;
})();
var statearr_30977_31004 = state_30956__$1;
(statearr_30977_31004[(2)] = inst_30925);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30956__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30957 === (8))){
var inst_30938 = (state_30956[(2)]);
var state_30956__$1 = state_30956;
var statearr_30978_31005 = state_30956__$1;
(statearr_30978_31005[(2)] = inst_30938);

(statearr_30978_31005[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__28309__auto___30990,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__28294__auto__,c__28309__auto___30990,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__28295__auto__ = null;
var cljs$core$async$state_machine__28295__auto____0 = (function (){
var statearr_30982 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30982[(0)] = cljs$core$async$state_machine__28295__auto__);

(statearr_30982[(1)] = (1));

return statearr_30982;
});
var cljs$core$async$state_machine__28295__auto____1 = (function (state_30956){
while(true){
var ret_value__28296__auto__ = (function (){try{while(true){
var result__28297__auto__ = switch__28294__auto__.call(null,state_30956);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28297__auto__;
}
break;
}
}catch (e30983){if((e30983 instanceof Object)){
var ex__28298__auto__ = e30983;
var statearr_30984_31006 = state_30956;
(statearr_30984_31006[(5)] = ex__28298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30956);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30983;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31007 = state_30956;
state_30956 = G__31007;
continue;
} else {
return ret_value__28296__auto__;
}
break;
}
});
cljs$core$async$state_machine__28295__auto__ = function(state_30956){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28295__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28295__auto____1.call(this,state_30956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28295__auto____0;
cljs$core$async$state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28295__auto____1;
return cljs$core$async$state_machine__28295__auto__;
})()
;})(switch__28294__auto__,c__28309__auto___30990,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__28311__auto__ = (function (){var statearr_30985 = f__28310__auto__.call(null);
(statearr_30985[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28309__auto___30990);

return statearr_30985;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28311__auto__);
});})(c__28309__auto___30990,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args31009 = [];
var len__7280__auto___31065 = arguments.length;
var i__7281__auto___31066 = (0);
while(true){
if((i__7281__auto___31066 < len__7280__auto___31065)){
args31009.push((arguments[i__7281__auto___31066]));

var G__31067 = (i__7281__auto___31066 + (1));
i__7281__auto___31066 = G__31067;
continue;
} else {
}
break;
}

var G__31011 = args31009.length;
switch (G__31011) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31009.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__28309__auto___31069 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__28309__auto___31069,out){
return (function (){
var f__28310__auto__ = (function (){var switch__28294__auto__ = ((function (c__28309__auto___31069,out){
return (function (state_31041){
var state_val_31042 = (state_31041[(1)]);
if((state_val_31042 === (7))){
var inst_31021 = (state_31041[(7)]);
var inst_31020 = (state_31041[(8)]);
var inst_31020__$1 = (state_31041[(2)]);
var inst_31021__$1 = cljs.core.nth.call(null,inst_31020__$1,(0),null);
var inst_31022 = cljs.core.nth.call(null,inst_31020__$1,(1),null);
var inst_31023 = (inst_31021__$1 == null);
var state_31041__$1 = (function (){var statearr_31043 = state_31041;
(statearr_31043[(7)] = inst_31021__$1);

(statearr_31043[(9)] = inst_31022);

(statearr_31043[(8)] = inst_31020__$1);

return statearr_31043;
})();
if(cljs.core.truth_(inst_31023)){
var statearr_31044_31070 = state_31041__$1;
(statearr_31044_31070[(1)] = (8));

} else {
var statearr_31045_31071 = state_31041__$1;
(statearr_31045_31071[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31042 === (1))){
var inst_31012 = cljs.core.vec.call(null,chs);
var inst_31013 = inst_31012;
var state_31041__$1 = (function (){var statearr_31046 = state_31041;
(statearr_31046[(10)] = inst_31013);

return statearr_31046;
})();
var statearr_31047_31072 = state_31041__$1;
(statearr_31047_31072[(2)] = null);

(statearr_31047_31072[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31042 === (4))){
var inst_31013 = (state_31041[(10)]);
var state_31041__$1 = state_31041;
return cljs.core.async.ioc_alts_BANG_.call(null,state_31041__$1,(7),inst_31013);
} else {
if((state_val_31042 === (6))){
var inst_31037 = (state_31041[(2)]);
var state_31041__$1 = state_31041;
var statearr_31048_31073 = state_31041__$1;
(statearr_31048_31073[(2)] = inst_31037);

(statearr_31048_31073[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31042 === (3))){
var inst_31039 = (state_31041[(2)]);
var state_31041__$1 = state_31041;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31041__$1,inst_31039);
} else {
if((state_val_31042 === (2))){
var inst_31013 = (state_31041[(10)]);
var inst_31015 = cljs.core.count.call(null,inst_31013);
var inst_31016 = (inst_31015 > (0));
var state_31041__$1 = state_31041;
if(cljs.core.truth_(inst_31016)){
var statearr_31050_31074 = state_31041__$1;
(statearr_31050_31074[(1)] = (4));

} else {
var statearr_31051_31075 = state_31041__$1;
(statearr_31051_31075[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31042 === (11))){
var inst_31013 = (state_31041[(10)]);
var inst_31030 = (state_31041[(2)]);
var tmp31049 = inst_31013;
var inst_31013__$1 = tmp31049;
var state_31041__$1 = (function (){var statearr_31052 = state_31041;
(statearr_31052[(11)] = inst_31030);

(statearr_31052[(10)] = inst_31013__$1);

return statearr_31052;
})();
var statearr_31053_31076 = state_31041__$1;
(statearr_31053_31076[(2)] = null);

(statearr_31053_31076[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31042 === (9))){
var inst_31021 = (state_31041[(7)]);
var state_31041__$1 = state_31041;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31041__$1,(11),out,inst_31021);
} else {
if((state_val_31042 === (5))){
var inst_31035 = cljs.core.async.close_BANG_.call(null,out);
var state_31041__$1 = state_31041;
var statearr_31054_31077 = state_31041__$1;
(statearr_31054_31077[(2)] = inst_31035);

(statearr_31054_31077[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31042 === (10))){
var inst_31033 = (state_31041[(2)]);
var state_31041__$1 = state_31041;
var statearr_31055_31078 = state_31041__$1;
(statearr_31055_31078[(2)] = inst_31033);

(statearr_31055_31078[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31042 === (8))){
var inst_31021 = (state_31041[(7)]);
var inst_31022 = (state_31041[(9)]);
var inst_31013 = (state_31041[(10)]);
var inst_31020 = (state_31041[(8)]);
var inst_31025 = (function (){var cs = inst_31013;
var vec__31018 = inst_31020;
var v = inst_31021;
var c = inst_31022;
return ((function (cs,vec__31018,v,c,inst_31021,inst_31022,inst_31013,inst_31020,state_val_31042,c__28309__auto___31069,out){
return (function (p1__31008_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__31008_SHARP_);
});
;})(cs,vec__31018,v,c,inst_31021,inst_31022,inst_31013,inst_31020,state_val_31042,c__28309__auto___31069,out))
})();
var inst_31026 = cljs.core.filterv.call(null,inst_31025,inst_31013);
var inst_31013__$1 = inst_31026;
var state_31041__$1 = (function (){var statearr_31056 = state_31041;
(statearr_31056[(10)] = inst_31013__$1);

return statearr_31056;
})();
var statearr_31057_31079 = state_31041__$1;
(statearr_31057_31079[(2)] = null);

(statearr_31057_31079[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__28309__auto___31069,out))
;
return ((function (switch__28294__auto__,c__28309__auto___31069,out){
return (function() {
var cljs$core$async$state_machine__28295__auto__ = null;
var cljs$core$async$state_machine__28295__auto____0 = (function (){
var statearr_31061 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31061[(0)] = cljs$core$async$state_machine__28295__auto__);

(statearr_31061[(1)] = (1));

return statearr_31061;
});
var cljs$core$async$state_machine__28295__auto____1 = (function (state_31041){
while(true){
var ret_value__28296__auto__ = (function (){try{while(true){
var result__28297__auto__ = switch__28294__auto__.call(null,state_31041);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28297__auto__;
}
break;
}
}catch (e31062){if((e31062 instanceof Object)){
var ex__28298__auto__ = e31062;
var statearr_31063_31080 = state_31041;
(statearr_31063_31080[(5)] = ex__28298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31041);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31062;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31081 = state_31041;
state_31041 = G__31081;
continue;
} else {
return ret_value__28296__auto__;
}
break;
}
});
cljs$core$async$state_machine__28295__auto__ = function(state_31041){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28295__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28295__auto____1.call(this,state_31041);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28295__auto____0;
cljs$core$async$state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28295__auto____1;
return cljs$core$async$state_machine__28295__auto__;
})()
;})(switch__28294__auto__,c__28309__auto___31069,out))
})();
var state__28311__auto__ = (function (){var statearr_31064 = f__28310__auto__.call(null);
(statearr_31064[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28309__auto___31069);

return statearr_31064;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28311__auto__);
});})(c__28309__auto___31069,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args31082 = [];
var len__7280__auto___31131 = arguments.length;
var i__7281__auto___31132 = (0);
while(true){
if((i__7281__auto___31132 < len__7280__auto___31131)){
args31082.push((arguments[i__7281__auto___31132]));

var G__31133 = (i__7281__auto___31132 + (1));
i__7281__auto___31132 = G__31133;
continue;
} else {
}
break;
}

var G__31084 = args31082.length;
switch (G__31084) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31082.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__28309__auto___31135 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__28309__auto___31135,out){
return (function (){
var f__28310__auto__ = (function (){var switch__28294__auto__ = ((function (c__28309__auto___31135,out){
return (function (state_31108){
var state_val_31109 = (state_31108[(1)]);
if((state_val_31109 === (7))){
var inst_31090 = (state_31108[(7)]);
var inst_31090__$1 = (state_31108[(2)]);
var inst_31091 = (inst_31090__$1 == null);
var inst_31092 = cljs.core.not.call(null,inst_31091);
var state_31108__$1 = (function (){var statearr_31110 = state_31108;
(statearr_31110[(7)] = inst_31090__$1);

return statearr_31110;
})();
if(inst_31092){
var statearr_31111_31136 = state_31108__$1;
(statearr_31111_31136[(1)] = (8));

} else {
var statearr_31112_31137 = state_31108__$1;
(statearr_31112_31137[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31109 === (1))){
var inst_31085 = (0);
var state_31108__$1 = (function (){var statearr_31113 = state_31108;
(statearr_31113[(8)] = inst_31085);

return statearr_31113;
})();
var statearr_31114_31138 = state_31108__$1;
(statearr_31114_31138[(2)] = null);

(statearr_31114_31138[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31109 === (4))){
var state_31108__$1 = state_31108;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31108__$1,(7),ch);
} else {
if((state_val_31109 === (6))){
var inst_31103 = (state_31108[(2)]);
var state_31108__$1 = state_31108;
var statearr_31115_31139 = state_31108__$1;
(statearr_31115_31139[(2)] = inst_31103);

(statearr_31115_31139[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31109 === (3))){
var inst_31105 = (state_31108[(2)]);
var inst_31106 = cljs.core.async.close_BANG_.call(null,out);
var state_31108__$1 = (function (){var statearr_31116 = state_31108;
(statearr_31116[(9)] = inst_31105);

return statearr_31116;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31108__$1,inst_31106);
} else {
if((state_val_31109 === (2))){
var inst_31085 = (state_31108[(8)]);
var inst_31087 = (inst_31085 < n);
var state_31108__$1 = state_31108;
if(cljs.core.truth_(inst_31087)){
var statearr_31117_31140 = state_31108__$1;
(statearr_31117_31140[(1)] = (4));

} else {
var statearr_31118_31141 = state_31108__$1;
(statearr_31118_31141[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31109 === (11))){
var inst_31085 = (state_31108[(8)]);
var inst_31095 = (state_31108[(2)]);
var inst_31096 = (inst_31085 + (1));
var inst_31085__$1 = inst_31096;
var state_31108__$1 = (function (){var statearr_31119 = state_31108;
(statearr_31119[(10)] = inst_31095);

(statearr_31119[(8)] = inst_31085__$1);

return statearr_31119;
})();
var statearr_31120_31142 = state_31108__$1;
(statearr_31120_31142[(2)] = null);

(statearr_31120_31142[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31109 === (9))){
var state_31108__$1 = state_31108;
var statearr_31121_31143 = state_31108__$1;
(statearr_31121_31143[(2)] = null);

(statearr_31121_31143[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31109 === (5))){
var state_31108__$1 = state_31108;
var statearr_31122_31144 = state_31108__$1;
(statearr_31122_31144[(2)] = null);

(statearr_31122_31144[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31109 === (10))){
var inst_31100 = (state_31108[(2)]);
var state_31108__$1 = state_31108;
var statearr_31123_31145 = state_31108__$1;
(statearr_31123_31145[(2)] = inst_31100);

(statearr_31123_31145[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31109 === (8))){
var inst_31090 = (state_31108[(7)]);
var state_31108__$1 = state_31108;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31108__$1,(11),out,inst_31090);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__28309__auto___31135,out))
;
return ((function (switch__28294__auto__,c__28309__auto___31135,out){
return (function() {
var cljs$core$async$state_machine__28295__auto__ = null;
var cljs$core$async$state_machine__28295__auto____0 = (function (){
var statearr_31127 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31127[(0)] = cljs$core$async$state_machine__28295__auto__);

(statearr_31127[(1)] = (1));

return statearr_31127;
});
var cljs$core$async$state_machine__28295__auto____1 = (function (state_31108){
while(true){
var ret_value__28296__auto__ = (function (){try{while(true){
var result__28297__auto__ = switch__28294__auto__.call(null,state_31108);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28297__auto__;
}
break;
}
}catch (e31128){if((e31128 instanceof Object)){
var ex__28298__auto__ = e31128;
var statearr_31129_31146 = state_31108;
(statearr_31129_31146[(5)] = ex__28298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31108);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31128;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31147 = state_31108;
state_31108 = G__31147;
continue;
} else {
return ret_value__28296__auto__;
}
break;
}
});
cljs$core$async$state_machine__28295__auto__ = function(state_31108){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28295__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28295__auto____1.call(this,state_31108);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28295__auto____0;
cljs$core$async$state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28295__auto____1;
return cljs$core$async$state_machine__28295__auto__;
})()
;})(switch__28294__auto__,c__28309__auto___31135,out))
})();
var state__28311__auto__ = (function (){var statearr_31130 = f__28310__auto__.call(null);
(statearr_31130[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28309__auto___31135);

return statearr_31130;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28311__auto__);
});})(c__28309__auto___31135,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async31155 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31155 = (function (map_LT_,f,ch,meta31156){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta31156 = meta31156;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31155.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31157,meta31156__$1){
var self__ = this;
var _31157__$1 = this;
return (new cljs.core.async.t_cljs$core$async31155(self__.map_LT_,self__.f,self__.ch,meta31156__$1));
});

cljs.core.async.t_cljs$core$async31155.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31157){
var self__ = this;
var _31157__$1 = this;
return self__.meta31156;
});

cljs.core.async.t_cljs$core$async31155.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async31155.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async31155.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async31155.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async31155.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async31158 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31158 = (function (map_LT_,f,ch,meta31156,_,fn1,meta31159){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta31156 = meta31156;
this._ = _;
this.fn1 = fn1;
this.meta31159 = meta31159;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31158.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_31160,meta31159__$1){
var self__ = this;
var _31160__$1 = this;
return (new cljs.core.async.t_cljs$core$async31158(self__.map_LT_,self__.f,self__.ch,self__.meta31156,self__._,self__.fn1,meta31159__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async31158.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_31160){
var self__ = this;
var _31160__$1 = this;
return self__.meta31159;
});})(___$1))
;

cljs.core.async.t_cljs$core$async31158.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async31158.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async31158.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async31158.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__31148_SHARP_){
return f1.call(null,(((p1__31148_SHARP_ == null))?null:self__.f.call(null,p1__31148_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async31158.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31156","meta31156",-247075981,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async31155","cljs.core.async/t_cljs$core$async31155",-814917202,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta31159","meta31159",-1538667700,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async31158.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31158.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31158";

cljs.core.async.t_cljs$core$async31158.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write.call(null,writer__6817__auto__,"cljs.core.async/t_cljs$core$async31158");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async31158 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async31158(map_LT___$1,f__$1,ch__$1,meta31156__$1,___$2,fn1__$1,meta31159){
return (new cljs.core.async.t_cljs$core$async31158(map_LT___$1,f__$1,ch__$1,meta31156__$1,___$2,fn1__$1,meta31159));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async31158(self__.map_LT_,self__.f,self__.ch,self__.meta31156,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6198__auto__ = ret;
if(cljs.core.truth_(and__6198__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__6198__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async31155.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async31155.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async31155.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31156","meta31156",-247075981,null)], null);
});

cljs.core.async.t_cljs$core$async31155.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31155.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31155";

cljs.core.async.t_cljs$core$async31155.cljs$lang$ctorPrWriter = (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write.call(null,writer__6817__auto__,"cljs.core.async/t_cljs$core$async31155");
});

cljs.core.async.__GT_t_cljs$core$async31155 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async31155(map_LT___$1,f__$1,ch__$1,meta31156){
return (new cljs.core.async.t_cljs$core$async31155(map_LT___$1,f__$1,ch__$1,meta31156));
});

}

return (new cljs.core.async.t_cljs$core$async31155(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async31164 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31164 = (function (map_GT_,f,ch,meta31165){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta31165 = meta31165;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31164.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31166,meta31165__$1){
var self__ = this;
var _31166__$1 = this;
return (new cljs.core.async.t_cljs$core$async31164(self__.map_GT_,self__.f,self__.ch,meta31165__$1));
});

cljs.core.async.t_cljs$core$async31164.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31166){
var self__ = this;
var _31166__$1 = this;
return self__.meta31165;
});

cljs.core.async.t_cljs$core$async31164.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async31164.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async31164.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async31164.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async31164.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async31164.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async31164.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31165","meta31165",345924979,null)], null);
});

cljs.core.async.t_cljs$core$async31164.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31164.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31164";

cljs.core.async.t_cljs$core$async31164.cljs$lang$ctorPrWriter = (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write.call(null,writer__6817__auto__,"cljs.core.async/t_cljs$core$async31164");
});

cljs.core.async.__GT_t_cljs$core$async31164 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async31164(map_GT___$1,f__$1,ch__$1,meta31165){
return (new cljs.core.async.t_cljs$core$async31164(map_GT___$1,f__$1,ch__$1,meta31165));
});

}

return (new cljs.core.async.t_cljs$core$async31164(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async31170 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31170 = (function (filter_GT_,p,ch,meta31171){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta31171 = meta31171;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31170.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31172,meta31171__$1){
var self__ = this;
var _31172__$1 = this;
return (new cljs.core.async.t_cljs$core$async31170(self__.filter_GT_,self__.p,self__.ch,meta31171__$1));
});

cljs.core.async.t_cljs$core$async31170.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31172){
var self__ = this;
var _31172__$1 = this;
return self__.meta31171;
});

cljs.core.async.t_cljs$core$async31170.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async31170.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async31170.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async31170.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async31170.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async31170.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async31170.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async31170.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31171","meta31171",-16087981,null)], null);
});

cljs.core.async.t_cljs$core$async31170.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31170.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31170";

cljs.core.async.t_cljs$core$async31170.cljs$lang$ctorPrWriter = (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write.call(null,writer__6817__auto__,"cljs.core.async/t_cljs$core$async31170");
});

cljs.core.async.__GT_t_cljs$core$async31170 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async31170(filter_GT___$1,p__$1,ch__$1,meta31171){
return (new cljs.core.async.t_cljs$core$async31170(filter_GT___$1,p__$1,ch__$1,meta31171));
});

}

return (new cljs.core.async.t_cljs$core$async31170(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args31173 = [];
var len__7280__auto___31217 = arguments.length;
var i__7281__auto___31218 = (0);
while(true){
if((i__7281__auto___31218 < len__7280__auto___31217)){
args31173.push((arguments[i__7281__auto___31218]));

var G__31219 = (i__7281__auto___31218 + (1));
i__7281__auto___31218 = G__31219;
continue;
} else {
}
break;
}

var G__31175 = args31173.length;
switch (G__31175) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31173.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__28309__auto___31221 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__28309__auto___31221,out){
return (function (){
var f__28310__auto__ = (function (){var switch__28294__auto__ = ((function (c__28309__auto___31221,out){
return (function (state_31196){
var state_val_31197 = (state_31196[(1)]);
if((state_val_31197 === (7))){
var inst_31192 = (state_31196[(2)]);
var state_31196__$1 = state_31196;
var statearr_31198_31222 = state_31196__$1;
(statearr_31198_31222[(2)] = inst_31192);

(statearr_31198_31222[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31197 === (1))){
var state_31196__$1 = state_31196;
var statearr_31199_31223 = state_31196__$1;
(statearr_31199_31223[(2)] = null);

(statearr_31199_31223[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31197 === (4))){
var inst_31178 = (state_31196[(7)]);
var inst_31178__$1 = (state_31196[(2)]);
var inst_31179 = (inst_31178__$1 == null);
var state_31196__$1 = (function (){var statearr_31200 = state_31196;
(statearr_31200[(7)] = inst_31178__$1);

return statearr_31200;
})();
if(cljs.core.truth_(inst_31179)){
var statearr_31201_31224 = state_31196__$1;
(statearr_31201_31224[(1)] = (5));

} else {
var statearr_31202_31225 = state_31196__$1;
(statearr_31202_31225[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31197 === (6))){
var inst_31178 = (state_31196[(7)]);
var inst_31183 = p.call(null,inst_31178);
var state_31196__$1 = state_31196;
if(cljs.core.truth_(inst_31183)){
var statearr_31203_31226 = state_31196__$1;
(statearr_31203_31226[(1)] = (8));

} else {
var statearr_31204_31227 = state_31196__$1;
(statearr_31204_31227[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31197 === (3))){
var inst_31194 = (state_31196[(2)]);
var state_31196__$1 = state_31196;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31196__$1,inst_31194);
} else {
if((state_val_31197 === (2))){
var state_31196__$1 = state_31196;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31196__$1,(4),ch);
} else {
if((state_val_31197 === (11))){
var inst_31186 = (state_31196[(2)]);
var state_31196__$1 = state_31196;
var statearr_31205_31228 = state_31196__$1;
(statearr_31205_31228[(2)] = inst_31186);

(statearr_31205_31228[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31197 === (9))){
var state_31196__$1 = state_31196;
var statearr_31206_31229 = state_31196__$1;
(statearr_31206_31229[(2)] = null);

(statearr_31206_31229[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31197 === (5))){
var inst_31181 = cljs.core.async.close_BANG_.call(null,out);
var state_31196__$1 = state_31196;
var statearr_31207_31230 = state_31196__$1;
(statearr_31207_31230[(2)] = inst_31181);

(statearr_31207_31230[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31197 === (10))){
var inst_31189 = (state_31196[(2)]);
var state_31196__$1 = (function (){var statearr_31208 = state_31196;
(statearr_31208[(8)] = inst_31189);

return statearr_31208;
})();
var statearr_31209_31231 = state_31196__$1;
(statearr_31209_31231[(2)] = null);

(statearr_31209_31231[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31197 === (8))){
var inst_31178 = (state_31196[(7)]);
var state_31196__$1 = state_31196;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31196__$1,(11),out,inst_31178);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__28309__auto___31221,out))
;
return ((function (switch__28294__auto__,c__28309__auto___31221,out){
return (function() {
var cljs$core$async$state_machine__28295__auto__ = null;
var cljs$core$async$state_machine__28295__auto____0 = (function (){
var statearr_31213 = [null,null,null,null,null,null,null,null,null];
(statearr_31213[(0)] = cljs$core$async$state_machine__28295__auto__);

(statearr_31213[(1)] = (1));

return statearr_31213;
});
var cljs$core$async$state_machine__28295__auto____1 = (function (state_31196){
while(true){
var ret_value__28296__auto__ = (function (){try{while(true){
var result__28297__auto__ = switch__28294__auto__.call(null,state_31196);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28297__auto__;
}
break;
}
}catch (e31214){if((e31214 instanceof Object)){
var ex__28298__auto__ = e31214;
var statearr_31215_31232 = state_31196;
(statearr_31215_31232[(5)] = ex__28298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31196);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31214;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31233 = state_31196;
state_31196 = G__31233;
continue;
} else {
return ret_value__28296__auto__;
}
break;
}
});
cljs$core$async$state_machine__28295__auto__ = function(state_31196){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28295__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28295__auto____1.call(this,state_31196);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28295__auto____0;
cljs$core$async$state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28295__auto____1;
return cljs$core$async$state_machine__28295__auto__;
})()
;})(switch__28294__auto__,c__28309__auto___31221,out))
})();
var state__28311__auto__ = (function (){var statearr_31216 = f__28310__auto__.call(null);
(statearr_31216[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28309__auto___31221);

return statearr_31216;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28311__auto__);
});})(c__28309__auto___31221,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args31234 = [];
var len__7280__auto___31237 = arguments.length;
var i__7281__auto___31238 = (0);
while(true){
if((i__7281__auto___31238 < len__7280__auto___31237)){
args31234.push((arguments[i__7281__auto___31238]));

var G__31239 = (i__7281__auto___31238 + (1));
i__7281__auto___31238 = G__31239;
continue;
} else {
}
break;
}

var G__31236 = args31234.length;
switch (G__31236) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31234.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__28309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__28309__auto__){
return (function (){
var f__28310__auto__ = (function (){var switch__28294__auto__ = ((function (c__28309__auto__){
return (function (state_31406){
var state_val_31407 = (state_31406[(1)]);
if((state_val_31407 === (7))){
var inst_31402 = (state_31406[(2)]);
var state_31406__$1 = state_31406;
var statearr_31408_31449 = state_31406__$1;
(statearr_31408_31449[(2)] = inst_31402);

(statearr_31408_31449[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31407 === (20))){
var inst_31372 = (state_31406[(7)]);
var inst_31383 = (state_31406[(2)]);
var inst_31384 = cljs.core.next.call(null,inst_31372);
var inst_31358 = inst_31384;
var inst_31359 = null;
var inst_31360 = (0);
var inst_31361 = (0);
var state_31406__$1 = (function (){var statearr_31409 = state_31406;
(statearr_31409[(8)] = inst_31360);

(statearr_31409[(9)] = inst_31383);

(statearr_31409[(10)] = inst_31361);

(statearr_31409[(11)] = inst_31359);

(statearr_31409[(12)] = inst_31358);

return statearr_31409;
})();
var statearr_31410_31450 = state_31406__$1;
(statearr_31410_31450[(2)] = null);

(statearr_31410_31450[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31407 === (1))){
var state_31406__$1 = state_31406;
var statearr_31411_31451 = state_31406__$1;
(statearr_31411_31451[(2)] = null);

(statearr_31411_31451[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31407 === (4))){
var inst_31347 = (state_31406[(13)]);
var inst_31347__$1 = (state_31406[(2)]);
var inst_31348 = (inst_31347__$1 == null);
var state_31406__$1 = (function (){var statearr_31412 = state_31406;
(statearr_31412[(13)] = inst_31347__$1);

return statearr_31412;
})();
if(cljs.core.truth_(inst_31348)){
var statearr_31413_31452 = state_31406__$1;
(statearr_31413_31452[(1)] = (5));

} else {
var statearr_31414_31453 = state_31406__$1;
(statearr_31414_31453[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31407 === (15))){
var state_31406__$1 = state_31406;
var statearr_31418_31454 = state_31406__$1;
(statearr_31418_31454[(2)] = null);

(statearr_31418_31454[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31407 === (21))){
var state_31406__$1 = state_31406;
var statearr_31419_31455 = state_31406__$1;
(statearr_31419_31455[(2)] = null);

(statearr_31419_31455[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31407 === (13))){
var inst_31360 = (state_31406[(8)]);
var inst_31361 = (state_31406[(10)]);
var inst_31359 = (state_31406[(11)]);
var inst_31358 = (state_31406[(12)]);
var inst_31368 = (state_31406[(2)]);
var inst_31369 = (inst_31361 + (1));
var tmp31415 = inst_31360;
var tmp31416 = inst_31359;
var tmp31417 = inst_31358;
var inst_31358__$1 = tmp31417;
var inst_31359__$1 = tmp31416;
var inst_31360__$1 = tmp31415;
var inst_31361__$1 = inst_31369;
var state_31406__$1 = (function (){var statearr_31420 = state_31406;
(statearr_31420[(8)] = inst_31360__$1);

(statearr_31420[(10)] = inst_31361__$1);

(statearr_31420[(11)] = inst_31359__$1);

(statearr_31420[(14)] = inst_31368);

(statearr_31420[(12)] = inst_31358__$1);

return statearr_31420;
})();
var statearr_31421_31456 = state_31406__$1;
(statearr_31421_31456[(2)] = null);

(statearr_31421_31456[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31407 === (22))){
var state_31406__$1 = state_31406;
var statearr_31422_31457 = state_31406__$1;
(statearr_31422_31457[(2)] = null);

(statearr_31422_31457[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31407 === (6))){
var inst_31347 = (state_31406[(13)]);
var inst_31356 = f.call(null,inst_31347);
var inst_31357 = cljs.core.seq.call(null,inst_31356);
var inst_31358 = inst_31357;
var inst_31359 = null;
var inst_31360 = (0);
var inst_31361 = (0);
var state_31406__$1 = (function (){var statearr_31423 = state_31406;
(statearr_31423[(8)] = inst_31360);

(statearr_31423[(10)] = inst_31361);

(statearr_31423[(11)] = inst_31359);

(statearr_31423[(12)] = inst_31358);

return statearr_31423;
})();
var statearr_31424_31458 = state_31406__$1;
(statearr_31424_31458[(2)] = null);

(statearr_31424_31458[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31407 === (17))){
var inst_31372 = (state_31406[(7)]);
var inst_31376 = cljs.core.chunk_first.call(null,inst_31372);
var inst_31377 = cljs.core.chunk_rest.call(null,inst_31372);
var inst_31378 = cljs.core.count.call(null,inst_31376);
var inst_31358 = inst_31377;
var inst_31359 = inst_31376;
var inst_31360 = inst_31378;
var inst_31361 = (0);
var state_31406__$1 = (function (){var statearr_31425 = state_31406;
(statearr_31425[(8)] = inst_31360);

(statearr_31425[(10)] = inst_31361);

(statearr_31425[(11)] = inst_31359);

(statearr_31425[(12)] = inst_31358);

return statearr_31425;
})();
var statearr_31426_31459 = state_31406__$1;
(statearr_31426_31459[(2)] = null);

(statearr_31426_31459[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31407 === (3))){
var inst_31404 = (state_31406[(2)]);
var state_31406__$1 = state_31406;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31406__$1,inst_31404);
} else {
if((state_val_31407 === (12))){
var inst_31392 = (state_31406[(2)]);
var state_31406__$1 = state_31406;
var statearr_31427_31460 = state_31406__$1;
(statearr_31427_31460[(2)] = inst_31392);

(statearr_31427_31460[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31407 === (2))){
var state_31406__$1 = state_31406;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31406__$1,(4),in$);
} else {
if((state_val_31407 === (23))){
var inst_31400 = (state_31406[(2)]);
var state_31406__$1 = state_31406;
var statearr_31428_31461 = state_31406__$1;
(statearr_31428_31461[(2)] = inst_31400);

(statearr_31428_31461[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31407 === (19))){
var inst_31387 = (state_31406[(2)]);
var state_31406__$1 = state_31406;
var statearr_31429_31462 = state_31406__$1;
(statearr_31429_31462[(2)] = inst_31387);

(statearr_31429_31462[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31407 === (11))){
var inst_31372 = (state_31406[(7)]);
var inst_31358 = (state_31406[(12)]);
var inst_31372__$1 = cljs.core.seq.call(null,inst_31358);
var state_31406__$1 = (function (){var statearr_31430 = state_31406;
(statearr_31430[(7)] = inst_31372__$1);

return statearr_31430;
})();
if(inst_31372__$1){
var statearr_31431_31463 = state_31406__$1;
(statearr_31431_31463[(1)] = (14));

} else {
var statearr_31432_31464 = state_31406__$1;
(statearr_31432_31464[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31407 === (9))){
var inst_31394 = (state_31406[(2)]);
var inst_31395 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_31406__$1 = (function (){var statearr_31433 = state_31406;
(statearr_31433[(15)] = inst_31394);

return statearr_31433;
})();
if(cljs.core.truth_(inst_31395)){
var statearr_31434_31465 = state_31406__$1;
(statearr_31434_31465[(1)] = (21));

} else {
var statearr_31435_31466 = state_31406__$1;
(statearr_31435_31466[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31407 === (5))){
var inst_31350 = cljs.core.async.close_BANG_.call(null,out);
var state_31406__$1 = state_31406;
var statearr_31436_31467 = state_31406__$1;
(statearr_31436_31467[(2)] = inst_31350);

(statearr_31436_31467[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31407 === (14))){
var inst_31372 = (state_31406[(7)]);
var inst_31374 = cljs.core.chunked_seq_QMARK_.call(null,inst_31372);
var state_31406__$1 = state_31406;
if(inst_31374){
var statearr_31437_31468 = state_31406__$1;
(statearr_31437_31468[(1)] = (17));

} else {
var statearr_31438_31469 = state_31406__$1;
(statearr_31438_31469[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31407 === (16))){
var inst_31390 = (state_31406[(2)]);
var state_31406__$1 = state_31406;
var statearr_31439_31470 = state_31406__$1;
(statearr_31439_31470[(2)] = inst_31390);

(statearr_31439_31470[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31407 === (10))){
var inst_31361 = (state_31406[(10)]);
var inst_31359 = (state_31406[(11)]);
var inst_31366 = cljs.core._nth.call(null,inst_31359,inst_31361);
var state_31406__$1 = state_31406;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31406__$1,(13),out,inst_31366);
} else {
if((state_val_31407 === (18))){
var inst_31372 = (state_31406[(7)]);
var inst_31381 = cljs.core.first.call(null,inst_31372);
var state_31406__$1 = state_31406;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31406__$1,(20),out,inst_31381);
} else {
if((state_val_31407 === (8))){
var inst_31360 = (state_31406[(8)]);
var inst_31361 = (state_31406[(10)]);
var inst_31363 = (inst_31361 < inst_31360);
var inst_31364 = inst_31363;
var state_31406__$1 = state_31406;
if(cljs.core.truth_(inst_31364)){
var statearr_31440_31471 = state_31406__$1;
(statearr_31440_31471[(1)] = (10));

} else {
var statearr_31441_31472 = state_31406__$1;
(statearr_31441_31472[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__28309__auto__))
;
return ((function (switch__28294__auto__,c__28309__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__28295__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__28295__auto____0 = (function (){
var statearr_31445 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31445[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__28295__auto__);

(statearr_31445[(1)] = (1));

return statearr_31445;
});
var cljs$core$async$mapcat_STAR__$_state_machine__28295__auto____1 = (function (state_31406){
while(true){
var ret_value__28296__auto__ = (function (){try{while(true){
var result__28297__auto__ = switch__28294__auto__.call(null,state_31406);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28297__auto__;
}
break;
}
}catch (e31446){if((e31446 instanceof Object)){
var ex__28298__auto__ = e31446;
var statearr_31447_31473 = state_31406;
(statearr_31447_31473[(5)] = ex__28298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31406);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31446;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31474 = state_31406;
state_31406 = G__31474;
continue;
} else {
return ret_value__28296__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__28295__auto__ = function(state_31406){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__28295__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__28295__auto____1.call(this,state_31406);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__28295__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__28295__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__28295__auto__;
})()
;})(switch__28294__auto__,c__28309__auto__))
})();
var state__28311__auto__ = (function (){var statearr_31448 = f__28310__auto__.call(null);
(statearr_31448[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28309__auto__);

return statearr_31448;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28311__auto__);
});})(c__28309__auto__))
);

return c__28309__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args31475 = [];
var len__7280__auto___31478 = arguments.length;
var i__7281__auto___31479 = (0);
while(true){
if((i__7281__auto___31479 < len__7280__auto___31478)){
args31475.push((arguments[i__7281__auto___31479]));

var G__31480 = (i__7281__auto___31479 + (1));
i__7281__auto___31479 = G__31480;
continue;
} else {
}
break;
}

var G__31477 = args31475.length;
switch (G__31477) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31475.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args31482 = [];
var len__7280__auto___31485 = arguments.length;
var i__7281__auto___31486 = (0);
while(true){
if((i__7281__auto___31486 < len__7280__auto___31485)){
args31482.push((arguments[i__7281__auto___31486]));

var G__31487 = (i__7281__auto___31486 + (1));
i__7281__auto___31486 = G__31487;
continue;
} else {
}
break;
}

var G__31484 = args31482.length;
switch (G__31484) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31482.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args31489 = [];
var len__7280__auto___31540 = arguments.length;
var i__7281__auto___31541 = (0);
while(true){
if((i__7281__auto___31541 < len__7280__auto___31540)){
args31489.push((arguments[i__7281__auto___31541]));

var G__31542 = (i__7281__auto___31541 + (1));
i__7281__auto___31541 = G__31542;
continue;
} else {
}
break;
}

var G__31491 = args31489.length;
switch (G__31491) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31489.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__28309__auto___31544 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__28309__auto___31544,out){
return (function (){
var f__28310__auto__ = (function (){var switch__28294__auto__ = ((function (c__28309__auto___31544,out){
return (function (state_31515){
var state_val_31516 = (state_31515[(1)]);
if((state_val_31516 === (7))){
var inst_31510 = (state_31515[(2)]);
var state_31515__$1 = state_31515;
var statearr_31517_31545 = state_31515__$1;
(statearr_31517_31545[(2)] = inst_31510);

(statearr_31517_31545[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31516 === (1))){
var inst_31492 = null;
var state_31515__$1 = (function (){var statearr_31518 = state_31515;
(statearr_31518[(7)] = inst_31492);

return statearr_31518;
})();
var statearr_31519_31546 = state_31515__$1;
(statearr_31519_31546[(2)] = null);

(statearr_31519_31546[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31516 === (4))){
var inst_31495 = (state_31515[(8)]);
var inst_31495__$1 = (state_31515[(2)]);
var inst_31496 = (inst_31495__$1 == null);
var inst_31497 = cljs.core.not.call(null,inst_31496);
var state_31515__$1 = (function (){var statearr_31520 = state_31515;
(statearr_31520[(8)] = inst_31495__$1);

return statearr_31520;
})();
if(inst_31497){
var statearr_31521_31547 = state_31515__$1;
(statearr_31521_31547[(1)] = (5));

} else {
var statearr_31522_31548 = state_31515__$1;
(statearr_31522_31548[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31516 === (6))){
var state_31515__$1 = state_31515;
var statearr_31523_31549 = state_31515__$1;
(statearr_31523_31549[(2)] = null);

(statearr_31523_31549[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31516 === (3))){
var inst_31512 = (state_31515[(2)]);
var inst_31513 = cljs.core.async.close_BANG_.call(null,out);
var state_31515__$1 = (function (){var statearr_31524 = state_31515;
(statearr_31524[(9)] = inst_31512);

return statearr_31524;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31515__$1,inst_31513);
} else {
if((state_val_31516 === (2))){
var state_31515__$1 = state_31515;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31515__$1,(4),ch);
} else {
if((state_val_31516 === (11))){
var inst_31495 = (state_31515[(8)]);
var inst_31504 = (state_31515[(2)]);
var inst_31492 = inst_31495;
var state_31515__$1 = (function (){var statearr_31525 = state_31515;
(statearr_31525[(7)] = inst_31492);

(statearr_31525[(10)] = inst_31504);

return statearr_31525;
})();
var statearr_31526_31550 = state_31515__$1;
(statearr_31526_31550[(2)] = null);

(statearr_31526_31550[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31516 === (9))){
var inst_31495 = (state_31515[(8)]);
var state_31515__$1 = state_31515;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31515__$1,(11),out,inst_31495);
} else {
if((state_val_31516 === (5))){
var inst_31492 = (state_31515[(7)]);
var inst_31495 = (state_31515[(8)]);
var inst_31499 = cljs.core._EQ_.call(null,inst_31495,inst_31492);
var state_31515__$1 = state_31515;
if(inst_31499){
var statearr_31528_31551 = state_31515__$1;
(statearr_31528_31551[(1)] = (8));

} else {
var statearr_31529_31552 = state_31515__$1;
(statearr_31529_31552[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31516 === (10))){
var inst_31507 = (state_31515[(2)]);
var state_31515__$1 = state_31515;
var statearr_31530_31553 = state_31515__$1;
(statearr_31530_31553[(2)] = inst_31507);

(statearr_31530_31553[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31516 === (8))){
var inst_31492 = (state_31515[(7)]);
var tmp31527 = inst_31492;
var inst_31492__$1 = tmp31527;
var state_31515__$1 = (function (){var statearr_31531 = state_31515;
(statearr_31531[(7)] = inst_31492__$1);

return statearr_31531;
})();
var statearr_31532_31554 = state_31515__$1;
(statearr_31532_31554[(2)] = null);

(statearr_31532_31554[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__28309__auto___31544,out))
;
return ((function (switch__28294__auto__,c__28309__auto___31544,out){
return (function() {
var cljs$core$async$state_machine__28295__auto__ = null;
var cljs$core$async$state_machine__28295__auto____0 = (function (){
var statearr_31536 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31536[(0)] = cljs$core$async$state_machine__28295__auto__);

(statearr_31536[(1)] = (1));

return statearr_31536;
});
var cljs$core$async$state_machine__28295__auto____1 = (function (state_31515){
while(true){
var ret_value__28296__auto__ = (function (){try{while(true){
var result__28297__auto__ = switch__28294__auto__.call(null,state_31515);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28297__auto__;
}
break;
}
}catch (e31537){if((e31537 instanceof Object)){
var ex__28298__auto__ = e31537;
var statearr_31538_31555 = state_31515;
(statearr_31538_31555[(5)] = ex__28298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31515);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31537;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31556 = state_31515;
state_31515 = G__31556;
continue;
} else {
return ret_value__28296__auto__;
}
break;
}
});
cljs$core$async$state_machine__28295__auto__ = function(state_31515){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28295__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28295__auto____1.call(this,state_31515);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28295__auto____0;
cljs$core$async$state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28295__auto____1;
return cljs$core$async$state_machine__28295__auto__;
})()
;})(switch__28294__auto__,c__28309__auto___31544,out))
})();
var state__28311__auto__ = (function (){var statearr_31539 = f__28310__auto__.call(null);
(statearr_31539[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28309__auto___31544);

return statearr_31539;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28311__auto__);
});})(c__28309__auto___31544,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args31557 = [];
var len__7280__auto___31627 = arguments.length;
var i__7281__auto___31628 = (0);
while(true){
if((i__7281__auto___31628 < len__7280__auto___31627)){
args31557.push((arguments[i__7281__auto___31628]));

var G__31629 = (i__7281__auto___31628 + (1));
i__7281__auto___31628 = G__31629;
continue;
} else {
}
break;
}

var G__31559 = args31557.length;
switch (G__31559) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31557.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__28309__auto___31631 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__28309__auto___31631,out){
return (function (){
var f__28310__auto__ = (function (){var switch__28294__auto__ = ((function (c__28309__auto___31631,out){
return (function (state_31597){
var state_val_31598 = (state_31597[(1)]);
if((state_val_31598 === (7))){
var inst_31593 = (state_31597[(2)]);
var state_31597__$1 = state_31597;
var statearr_31599_31632 = state_31597__$1;
(statearr_31599_31632[(2)] = inst_31593);

(statearr_31599_31632[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31598 === (1))){
var inst_31560 = (new Array(n));
var inst_31561 = inst_31560;
var inst_31562 = (0);
var state_31597__$1 = (function (){var statearr_31600 = state_31597;
(statearr_31600[(7)] = inst_31561);

(statearr_31600[(8)] = inst_31562);

return statearr_31600;
})();
var statearr_31601_31633 = state_31597__$1;
(statearr_31601_31633[(2)] = null);

(statearr_31601_31633[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31598 === (4))){
var inst_31565 = (state_31597[(9)]);
var inst_31565__$1 = (state_31597[(2)]);
var inst_31566 = (inst_31565__$1 == null);
var inst_31567 = cljs.core.not.call(null,inst_31566);
var state_31597__$1 = (function (){var statearr_31602 = state_31597;
(statearr_31602[(9)] = inst_31565__$1);

return statearr_31602;
})();
if(inst_31567){
var statearr_31603_31634 = state_31597__$1;
(statearr_31603_31634[(1)] = (5));

} else {
var statearr_31604_31635 = state_31597__$1;
(statearr_31604_31635[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31598 === (15))){
var inst_31587 = (state_31597[(2)]);
var state_31597__$1 = state_31597;
var statearr_31605_31636 = state_31597__$1;
(statearr_31605_31636[(2)] = inst_31587);

(statearr_31605_31636[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31598 === (13))){
var state_31597__$1 = state_31597;
var statearr_31606_31637 = state_31597__$1;
(statearr_31606_31637[(2)] = null);

(statearr_31606_31637[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31598 === (6))){
var inst_31562 = (state_31597[(8)]);
var inst_31583 = (inst_31562 > (0));
var state_31597__$1 = state_31597;
if(cljs.core.truth_(inst_31583)){
var statearr_31607_31638 = state_31597__$1;
(statearr_31607_31638[(1)] = (12));

} else {
var statearr_31608_31639 = state_31597__$1;
(statearr_31608_31639[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31598 === (3))){
var inst_31595 = (state_31597[(2)]);
var state_31597__$1 = state_31597;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31597__$1,inst_31595);
} else {
if((state_val_31598 === (12))){
var inst_31561 = (state_31597[(7)]);
var inst_31585 = cljs.core.vec.call(null,inst_31561);
var state_31597__$1 = state_31597;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31597__$1,(15),out,inst_31585);
} else {
if((state_val_31598 === (2))){
var state_31597__$1 = state_31597;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31597__$1,(4),ch);
} else {
if((state_val_31598 === (11))){
var inst_31577 = (state_31597[(2)]);
var inst_31578 = (new Array(n));
var inst_31561 = inst_31578;
var inst_31562 = (0);
var state_31597__$1 = (function (){var statearr_31609 = state_31597;
(statearr_31609[(7)] = inst_31561);

(statearr_31609[(10)] = inst_31577);

(statearr_31609[(8)] = inst_31562);

return statearr_31609;
})();
var statearr_31610_31640 = state_31597__$1;
(statearr_31610_31640[(2)] = null);

(statearr_31610_31640[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31598 === (9))){
var inst_31561 = (state_31597[(7)]);
var inst_31575 = cljs.core.vec.call(null,inst_31561);
var state_31597__$1 = state_31597;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31597__$1,(11),out,inst_31575);
} else {
if((state_val_31598 === (5))){
var inst_31561 = (state_31597[(7)]);
var inst_31570 = (state_31597[(11)]);
var inst_31565 = (state_31597[(9)]);
var inst_31562 = (state_31597[(8)]);
var inst_31569 = (inst_31561[inst_31562] = inst_31565);
var inst_31570__$1 = (inst_31562 + (1));
var inst_31571 = (inst_31570__$1 < n);
var state_31597__$1 = (function (){var statearr_31611 = state_31597;
(statearr_31611[(11)] = inst_31570__$1);

(statearr_31611[(12)] = inst_31569);

return statearr_31611;
})();
if(cljs.core.truth_(inst_31571)){
var statearr_31612_31641 = state_31597__$1;
(statearr_31612_31641[(1)] = (8));

} else {
var statearr_31613_31642 = state_31597__$1;
(statearr_31613_31642[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31598 === (14))){
var inst_31590 = (state_31597[(2)]);
var inst_31591 = cljs.core.async.close_BANG_.call(null,out);
var state_31597__$1 = (function (){var statearr_31615 = state_31597;
(statearr_31615[(13)] = inst_31590);

return statearr_31615;
})();
var statearr_31616_31643 = state_31597__$1;
(statearr_31616_31643[(2)] = inst_31591);

(statearr_31616_31643[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31598 === (10))){
var inst_31581 = (state_31597[(2)]);
var state_31597__$1 = state_31597;
var statearr_31617_31644 = state_31597__$1;
(statearr_31617_31644[(2)] = inst_31581);

(statearr_31617_31644[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31598 === (8))){
var inst_31561 = (state_31597[(7)]);
var inst_31570 = (state_31597[(11)]);
var tmp31614 = inst_31561;
var inst_31561__$1 = tmp31614;
var inst_31562 = inst_31570;
var state_31597__$1 = (function (){var statearr_31618 = state_31597;
(statearr_31618[(7)] = inst_31561__$1);

(statearr_31618[(8)] = inst_31562);

return statearr_31618;
})();
var statearr_31619_31645 = state_31597__$1;
(statearr_31619_31645[(2)] = null);

(statearr_31619_31645[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__28309__auto___31631,out))
;
return ((function (switch__28294__auto__,c__28309__auto___31631,out){
return (function() {
var cljs$core$async$state_machine__28295__auto__ = null;
var cljs$core$async$state_machine__28295__auto____0 = (function (){
var statearr_31623 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31623[(0)] = cljs$core$async$state_machine__28295__auto__);

(statearr_31623[(1)] = (1));

return statearr_31623;
});
var cljs$core$async$state_machine__28295__auto____1 = (function (state_31597){
while(true){
var ret_value__28296__auto__ = (function (){try{while(true){
var result__28297__auto__ = switch__28294__auto__.call(null,state_31597);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28297__auto__;
}
break;
}
}catch (e31624){if((e31624 instanceof Object)){
var ex__28298__auto__ = e31624;
var statearr_31625_31646 = state_31597;
(statearr_31625_31646[(5)] = ex__28298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31597);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31624;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31647 = state_31597;
state_31597 = G__31647;
continue;
} else {
return ret_value__28296__auto__;
}
break;
}
});
cljs$core$async$state_machine__28295__auto__ = function(state_31597){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28295__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28295__auto____1.call(this,state_31597);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28295__auto____0;
cljs$core$async$state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28295__auto____1;
return cljs$core$async$state_machine__28295__auto__;
})()
;})(switch__28294__auto__,c__28309__auto___31631,out))
})();
var state__28311__auto__ = (function (){var statearr_31626 = f__28310__auto__.call(null);
(statearr_31626[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28309__auto___31631);

return statearr_31626;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28311__auto__);
});})(c__28309__auto___31631,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args31648 = [];
var len__7280__auto___31722 = arguments.length;
var i__7281__auto___31723 = (0);
while(true){
if((i__7281__auto___31723 < len__7280__auto___31722)){
args31648.push((arguments[i__7281__auto___31723]));

var G__31724 = (i__7281__auto___31723 + (1));
i__7281__auto___31723 = G__31724;
continue;
} else {
}
break;
}

var G__31650 = args31648.length;
switch (G__31650) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31648.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__28309__auto___31726 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__28309__auto___31726,out){
return (function (){
var f__28310__auto__ = (function (){var switch__28294__auto__ = ((function (c__28309__auto___31726,out){
return (function (state_31692){
var state_val_31693 = (state_31692[(1)]);
if((state_val_31693 === (7))){
var inst_31688 = (state_31692[(2)]);
var state_31692__$1 = state_31692;
var statearr_31694_31727 = state_31692__$1;
(statearr_31694_31727[(2)] = inst_31688);

(statearr_31694_31727[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31693 === (1))){
var inst_31651 = [];
var inst_31652 = inst_31651;
var inst_31653 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_31692__$1 = (function (){var statearr_31695 = state_31692;
(statearr_31695[(7)] = inst_31652);

(statearr_31695[(8)] = inst_31653);

return statearr_31695;
})();
var statearr_31696_31728 = state_31692__$1;
(statearr_31696_31728[(2)] = null);

(statearr_31696_31728[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31693 === (4))){
var inst_31656 = (state_31692[(9)]);
var inst_31656__$1 = (state_31692[(2)]);
var inst_31657 = (inst_31656__$1 == null);
var inst_31658 = cljs.core.not.call(null,inst_31657);
var state_31692__$1 = (function (){var statearr_31697 = state_31692;
(statearr_31697[(9)] = inst_31656__$1);

return statearr_31697;
})();
if(inst_31658){
var statearr_31698_31729 = state_31692__$1;
(statearr_31698_31729[(1)] = (5));

} else {
var statearr_31699_31730 = state_31692__$1;
(statearr_31699_31730[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31693 === (15))){
var inst_31682 = (state_31692[(2)]);
var state_31692__$1 = state_31692;
var statearr_31700_31731 = state_31692__$1;
(statearr_31700_31731[(2)] = inst_31682);

(statearr_31700_31731[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31693 === (13))){
var state_31692__$1 = state_31692;
var statearr_31701_31732 = state_31692__$1;
(statearr_31701_31732[(2)] = null);

(statearr_31701_31732[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31693 === (6))){
var inst_31652 = (state_31692[(7)]);
var inst_31677 = inst_31652.length;
var inst_31678 = (inst_31677 > (0));
var state_31692__$1 = state_31692;
if(cljs.core.truth_(inst_31678)){
var statearr_31702_31733 = state_31692__$1;
(statearr_31702_31733[(1)] = (12));

} else {
var statearr_31703_31734 = state_31692__$1;
(statearr_31703_31734[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31693 === (3))){
var inst_31690 = (state_31692[(2)]);
var state_31692__$1 = state_31692;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31692__$1,inst_31690);
} else {
if((state_val_31693 === (12))){
var inst_31652 = (state_31692[(7)]);
var inst_31680 = cljs.core.vec.call(null,inst_31652);
var state_31692__$1 = state_31692;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31692__$1,(15),out,inst_31680);
} else {
if((state_val_31693 === (2))){
var state_31692__$1 = state_31692;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31692__$1,(4),ch);
} else {
if((state_val_31693 === (11))){
var inst_31656 = (state_31692[(9)]);
var inst_31660 = (state_31692[(10)]);
var inst_31670 = (state_31692[(2)]);
var inst_31671 = [];
var inst_31672 = inst_31671.push(inst_31656);
var inst_31652 = inst_31671;
var inst_31653 = inst_31660;
var state_31692__$1 = (function (){var statearr_31704 = state_31692;
(statearr_31704[(7)] = inst_31652);

(statearr_31704[(11)] = inst_31672);

(statearr_31704[(12)] = inst_31670);

(statearr_31704[(8)] = inst_31653);

return statearr_31704;
})();
var statearr_31705_31735 = state_31692__$1;
(statearr_31705_31735[(2)] = null);

(statearr_31705_31735[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31693 === (9))){
var inst_31652 = (state_31692[(7)]);
var inst_31668 = cljs.core.vec.call(null,inst_31652);
var state_31692__$1 = state_31692;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31692__$1,(11),out,inst_31668);
} else {
if((state_val_31693 === (5))){
var inst_31656 = (state_31692[(9)]);
var inst_31660 = (state_31692[(10)]);
var inst_31653 = (state_31692[(8)]);
var inst_31660__$1 = f.call(null,inst_31656);
var inst_31661 = cljs.core._EQ_.call(null,inst_31660__$1,inst_31653);
var inst_31662 = cljs.core.keyword_identical_QMARK_.call(null,inst_31653,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_31663 = (inst_31661) || (inst_31662);
var state_31692__$1 = (function (){var statearr_31706 = state_31692;
(statearr_31706[(10)] = inst_31660__$1);

return statearr_31706;
})();
if(cljs.core.truth_(inst_31663)){
var statearr_31707_31736 = state_31692__$1;
(statearr_31707_31736[(1)] = (8));

} else {
var statearr_31708_31737 = state_31692__$1;
(statearr_31708_31737[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31693 === (14))){
var inst_31685 = (state_31692[(2)]);
var inst_31686 = cljs.core.async.close_BANG_.call(null,out);
var state_31692__$1 = (function (){var statearr_31710 = state_31692;
(statearr_31710[(13)] = inst_31685);

return statearr_31710;
})();
var statearr_31711_31738 = state_31692__$1;
(statearr_31711_31738[(2)] = inst_31686);

(statearr_31711_31738[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31693 === (10))){
var inst_31675 = (state_31692[(2)]);
var state_31692__$1 = state_31692;
var statearr_31712_31739 = state_31692__$1;
(statearr_31712_31739[(2)] = inst_31675);

(statearr_31712_31739[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31693 === (8))){
var inst_31652 = (state_31692[(7)]);
var inst_31656 = (state_31692[(9)]);
var inst_31660 = (state_31692[(10)]);
var inst_31665 = inst_31652.push(inst_31656);
var tmp31709 = inst_31652;
var inst_31652__$1 = tmp31709;
var inst_31653 = inst_31660;
var state_31692__$1 = (function (){var statearr_31713 = state_31692;
(statearr_31713[(7)] = inst_31652__$1);

(statearr_31713[(14)] = inst_31665);

(statearr_31713[(8)] = inst_31653);

return statearr_31713;
})();
var statearr_31714_31740 = state_31692__$1;
(statearr_31714_31740[(2)] = null);

(statearr_31714_31740[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__28309__auto___31726,out))
;
return ((function (switch__28294__auto__,c__28309__auto___31726,out){
return (function() {
var cljs$core$async$state_machine__28295__auto__ = null;
var cljs$core$async$state_machine__28295__auto____0 = (function (){
var statearr_31718 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31718[(0)] = cljs$core$async$state_machine__28295__auto__);

(statearr_31718[(1)] = (1));

return statearr_31718;
});
var cljs$core$async$state_machine__28295__auto____1 = (function (state_31692){
while(true){
var ret_value__28296__auto__ = (function (){try{while(true){
var result__28297__auto__ = switch__28294__auto__.call(null,state_31692);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28297__auto__;
}
break;
}
}catch (e31719){if((e31719 instanceof Object)){
var ex__28298__auto__ = e31719;
var statearr_31720_31741 = state_31692;
(statearr_31720_31741[(5)] = ex__28298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31692);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31719;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31742 = state_31692;
state_31692 = G__31742;
continue;
} else {
return ret_value__28296__auto__;
}
break;
}
});
cljs$core$async$state_machine__28295__auto__ = function(state_31692){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28295__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28295__auto____1.call(this,state_31692);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28295__auto____0;
cljs$core$async$state_machine__28295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28295__auto____1;
return cljs$core$async$state_machine__28295__auto__;
})()
;})(switch__28294__auto__,c__28309__auto___31726,out))
})();
var state__28311__auto__ = (function (){var statearr_31721 = f__28310__auto__.call(null);
(statearr_31721[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28309__auto___31726);

return statearr_31721;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28311__auto__);
});})(c__28309__auto___31726,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map