(ns hasch.md5
  {:lang :core.typed}
  #?(:cljs (:require [goog.crypt.Md5]
                     [goog.crypt.Hash]
                     [goog.crypt]))
  #?(:clj (:require [clojure.core.typed :as t]))
  #?(:clj (:import [java.security MessageDigest]
                  [java.math BigInteger])))


(t/ann ^:no-check MessageDigest/getInstance [String :-> MessageDigest])
(t/non-nil-return java.security.MessageDigest/getInstance :all)
(t/ann ^:no-check MessageDigest/digest [MessageDigest (Array byte) :-> (Array byte)])
(t/non-nil-return java.security.MessageDigest/digest :all)

(t/ann ^:no-check String/getBytes [String :-> (Array byte)])


;; Start: Generated by clojure.core.typed - DO NOT EDIT
(declare)
(t/ann str->md5 [t/Str :-> (Array byte)])
;; End: Generated by clojure.core.typed - DO NOT EDIT

(defn str->md5 [^String s]
  #_(:clj
     (let [algorithm (MessageDigest/getInstance "MD5")
           raw       (.digest algorithm (.getBytes s))]
       raw)
     :cljs
     (let [bytes (goog.crypt/stringToUtf8ByteArray s)
           md5-digester (goog.crypt.Md5.)
           hashed (do
                    (.update md5-digester bytes)
                    (.digest md5-digester))]
       hashed))
  (let [algorithm (MessageDigest/getInstance "MD5")
        raw       (.digest algorithm (.getBytes s))]
    raw))




(comment

  (clojure.core.typed/check-ns))


