// Compiled by ClojureScript 1.9.293 {}
goog.provide('hasch.core');
goog.require('cljs.core');
goog.require('hasch.benc');
goog.require('hasch.base64');
goog.require('hasch.platform');
hasch.core.uuid4 = hasch.platform.uuid4;
hasch.core.uuid5 = hasch.platform.uuid5;
hasch.core.hash__GT_str = hasch.platform.hash__GT_str;
/**
 * Hash an edn value with SHA-512 by default or a compatible hash function of choice.
 * 
 *   Please use the write-handlers only in legacy cases and rather extend the PHashCoercion
 *   protocol to your own types.
 */
hasch.core.edn_hash = (function hasch$core$edn_hash(var_args){
var args9135 = [];
var len__8457__auto___9138 = arguments.length;
var i__8458__auto___9139 = (0);
while(true){
if((i__8458__auto___9139 < len__8457__auto___9138)){
args9135.push((arguments[i__8458__auto___9139]));

var G__9140 = (i__8458__auto___9139 + (1));
i__8458__auto___9139 = G__9140;
continue;
} else {
}
break;
}

var G__9137 = args9135.length;
switch (G__9137) {
case 1:
return hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args9135.length)].join('')));

}
});

hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$1 = (function (val){
return hasch.core.edn_hash.call(null,val,cljs.core.PersistentArrayMap.EMPTY);
});

hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$2 = (function (val,write_handlers){
return hasch.core.edn_hash.call(null,val,hasch.platform.sha512_message_digest,write_handlers);
});

hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$3 = (function (val,md_create_fn,write_handlers){
return cljs.core.map.call(null,(function (p1__9134_SHARP_){
if((p1__9134_SHARP_ < (0))){
return (p1__9134_SHARP_ + (256));
} else {
return p1__9134_SHARP_;
}
}),hasch.benc.digest.call(null,hasch.benc._coerce.call(null,val,md_create_fn,(function (){var or__7241__auto__ = write_handlers;
if(cljs.core.truth_(or__7241__auto__)){
return or__7241__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})()),md_create_fn));
});

hasch.core.edn_hash.cljs$lang$maxFixedArity = 3;

/**
 * Creates random UUID-4 without argument or UUID-5 for the argument value.
 * 
 *   Optionally an incognito-style write-handlers map can be supplied,
 *   which describes record serialization in terms of Clojure data
 *   structures.
 */
hasch.core.uuid = (function hasch$core$uuid(var_args){
var args9142 = [];
var len__8457__auto___9150 = arguments.length;
var i__8458__auto___9151 = (0);
while(true){
if((i__8458__auto___9151 < len__8457__auto___9150)){
args9142.push((arguments[i__8458__auto___9151]));

var G__9152 = (i__8458__auto___9151 + (1));
i__8458__auto___9151 = G__9152;
continue;
} else {
}
break;
}

var G__9146 = args9142.length;
switch (G__9146) {
case 0:
return hasch.core.uuid.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__8480__auto__ = (new cljs.core.IndexedSeq(args9142.slice((1)),(0),null));
return hasch.core.uuid.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8480__auto__);

}
});

hasch.core.uuid.cljs$core$IFn$_invoke$arity$0 = (function (){
return hasch.core.uuid4.call(null);
});

hasch.core.uuid.cljs$core$IFn$_invoke$arity$variadic = (function (val,p__9147){
var map__9148 = p__9147;
var map__9148__$1 = ((((!((map__9148 == null)))?((((map__9148.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9148.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__9148):map__9148);
var write_handlers = cljs.core.get.call(null,map__9148__$1,new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911));
return hasch.core.uuid5.call(null,hasch.core.edn_hash.call(null,val,write_handlers));
});

hasch.core.uuid.cljs$lang$applyTo = (function (seq9143){
var G__9144 = cljs.core.first.call(null,seq9143);
var seq9143__$1 = cljs.core.next.call(null,seq9143);
return hasch.core.uuid.cljs$core$IFn$_invoke$arity$variadic(G__9144,seq9143__$1);
});

hasch.core.uuid.cljs$lang$maxFixedArity = (1);

/**
 * Calculates a sequential UUID as described in
 *   https://github.com/clojure-cookbook/clojure-cookbook/blob/master/01_primitive-data/1-24_uuids.asciidoc
 */
hasch.core.squuid = (function hasch$core$squuid(var_args){
var args9154 = [];
var len__8457__auto___9157 = arguments.length;
var i__8458__auto___9158 = (0);
while(true){
if((i__8458__auto___9158 < len__8457__auto___9157)){
args9154.push((arguments[i__8458__auto___9158]));

var G__9159 = (i__8458__auto___9158 + (1));
i__8458__auto___9158 = G__9159;
continue;
} else {
}
break;
}

var G__9156 = args9154.length;
switch (G__9156) {
case 0:
return hasch.core.squuid.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return hasch.core.squuid.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args9154.length)].join('')));

}
});

hasch.core.squuid.cljs$core$IFn$_invoke$arity$0 = (function (){
return hasch.core.squuid.call(null,hasch.core.uuid4.call(null));
});

hasch.core.squuid.cljs$core$IFn$_invoke$arity$1 = (function (uuid){
var time = (new Date()).getTime();
var secs = cljs.core.quot.call(null,time,(1000));
var prefix = secs.toString((16));
return cljs.core.uuid.call(null,[cljs.core.str(prefix),cljs.core.str(cljs.core.subs.call(null,[cljs.core.str(uuid)].join(''),(8)))].join(''));
});

hasch.core.squuid.cljs$lang$maxFixedArity = 1;

/**
 * Provides a base64 encoded string of the edn-hash of a value val. This contains
 *   all bits of the hash compared to 128 bits for the UUID-5. Both should be safe,
 *   but b64-hash is safer towards collisions.
 */
hasch.core.b64_hash = (function hasch$core$b64_hash(val){
return hasch.base64.encode.call(null,hasch.core.byte_array.call(null,hasch.core.edn_hash.call(null,val)));
});

//# sourceMappingURL=core.js.map