// Compiled by ClojureScript 1.9.293 {}
goog.provide('hasch.benc');
goog.require('cljs.core');

/**
 * @interface
 */
hasch.benc.PHashCoercion = function(){};

hasch.benc._coerce = (function hasch$benc$_coerce(this$,md_create_fn,write_handlers){
if((!((this$ == null))) && (!((this$.hasch$benc$PHashCoercion$_coerce$arity$3 == null)))){
return this$.hasch$benc$PHashCoercion$_coerce$arity$3(this$,md_create_fn,write_handlers);
} else {
var x__7954__auto__ = (((this$ == null))?null:this$);
var m__7955__auto__ = (hasch.benc._coerce[goog.typeOf(x__7954__auto__)]);
if(!((m__7955__auto__ == null))){
return m__7955__auto__.call(null,this$,md_create_fn,write_handlers);
} else {
var m__7955__auto____$1 = (hasch.benc._coerce["_"]);
if(!((m__7955__auto____$1 == null))){
return m__7955__auto____$1.call(null,this$,md_create_fn,write_handlers);
} else {
throw cljs.core.missing_protocol.call(null,"PHashCoercion.-coerce",this$);
}
}
}
});

hasch.benc.magics = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"binary","binary",-1802232288),new cljs.core.Keyword(null,"inst","inst",645962501),new cljs.core.Keyword(null,"number","number",1570378438),new cljs.core.Keyword(null,"symbol","symbol",-1038572696),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"vector","vector",1902966158),new cljs.core.Keyword(null,"keyword","keyword",811389747),new cljs.core.Keyword(null,"nil","nil",99600501),new cljs.core.Keyword(null,"literal","literal",1664775605),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"seq","seq",-1817803783),new cljs.core.Keyword(null,"set","set",304602554),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"map","map",1371690461)],[(13),(6),(2),(4),(3),(9),(5),(0),(12),(7),(8),(11),(1),(10)]);
hasch.benc.split_size = (1024);
hasch.benc.max_entropy_byte_count = (32);
hasch.benc.byte_array = (function hasch$benc$byte_array(len){
return cljs.core.into_array.call(null,cljs.core.repeat.call(null,len,(0)));
});
hasch.benc.digest = (function hasch$benc$digest(bytes_or_seq_of_bytes,md_create_fn){
var md = md_create_fn.call(null);
if(cljs.core.seq_QMARK_.call(null,bytes_or_seq_of_bytes)){
var seq__9061_9065 = cljs.core.seq.call(null,bytes_or_seq_of_bytes);
var chunk__9062_9066 = null;
var count__9063_9067 = (0);
var i__9064_9068 = (0);
while(true){
if((i__9064_9068 < count__9063_9067)){
var bs_9069 = cljs.core._nth.call(null,chunk__9062_9066,i__9064_9068);
md.update(bs_9069);

var G__9070 = seq__9061_9065;
var G__9071 = chunk__9062_9066;
var G__9072 = count__9063_9067;
var G__9073 = (i__9064_9068 + (1));
seq__9061_9065 = G__9070;
chunk__9062_9066 = G__9071;
count__9063_9067 = G__9072;
i__9064_9068 = G__9073;
continue;
} else {
var temp__6753__auto___9074 = cljs.core.seq.call(null,seq__9061_9065);
if(temp__6753__auto___9074){
var seq__9061_9075__$1 = temp__6753__auto___9074;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__9061_9075__$1)){
var c__8147__auto___9076 = cljs.core.chunk_first.call(null,seq__9061_9075__$1);
var G__9077 = cljs.core.chunk_rest.call(null,seq__9061_9075__$1);
var G__9078 = c__8147__auto___9076;
var G__9079 = cljs.core.count.call(null,c__8147__auto___9076);
var G__9080 = (0);
seq__9061_9065 = G__9077;
chunk__9062_9066 = G__9078;
count__9063_9067 = G__9079;
i__9064_9068 = G__9080;
continue;
} else {
var bs_9081 = cljs.core.first.call(null,seq__9061_9075__$1);
md.update(bs_9081);

var G__9082 = cljs.core.next.call(null,seq__9061_9075__$1);
var G__9083 = null;
var G__9084 = (0);
var G__9085 = (0);
seq__9061_9065 = G__9082;
chunk__9062_9066 = G__9083;
count__9063_9067 = G__9084;
i__9064_9068 = G__9085;
continue;
}
} else {
}
}
break;
}
} else {
md.update(bytes_or_seq_of_bytes);
}

return md.digest();
});
hasch.benc.coerce_seq = (function hasch$benc$coerce_seq(seq,md_create_fn,write_handlers){
var seq_md = md_create_fn.call(null);
var s_9092 = seq;
while(true){
var vec__9089_9093 = s_9092;
var seq__9090_9094 = cljs.core.seq.call(null,vec__9089_9093);
var first__9091_9095 = cljs.core.first.call(null,seq__9090_9094);
var seq__9090_9096__$1 = cljs.core.next.call(null,seq__9090_9094);
var f_9097 = first__9091_9095;
var r_9098 = seq__9090_9096__$1;
seq_md.update(hasch.benc._coerce.call(null,f_9097,md_create_fn,write_handlers));

if(cljs.core.empty_QMARK_.call(null,r_9098)){
} else {
var G__9099 = cljs.core.rest.call(null,s_9092);
s_9092 = G__9099;
continue;
}
break;
}

return seq_md.digest();
});
/**
 * Commutatively coerces elements of collection, seq entries must already be crypto hashes
 *   to avoid collisions in XOR. Takes at maximum 32 bytes into account.
 */
hasch.benc.xor_hashes = (function hasch$benc$xor_hashes(seq){
var len = (function (){var x__7581__auto__ = cljs.core.count.call(null,cljs.core.first.call(null,seq));
var y__7582__auto__ = hasch.benc.max_entropy_byte_count;
return ((x__7581__auto__ < y__7582__auto__) ? x__7581__auto__ : y__7582__auto__);
})();
return cljs.core.reduce.call(null,((function (len){
return (function (acc,elem){
var i_9100 = (0);
while(true){
if((i_9100 < len)){
(acc[i_9100] = ((acc[i_9100]) ^ (elem[i_9100])));

var G__9101 = (i_9100 + (1));
i_9100 = G__9101;
continue;
} else {
}
break;
}

return acc;
});})(len))
,hasch.benc.byte_array.call(null,len),seq);
});
hasch.benc.encode_safe = (function hasch$benc$encode_safe(a,md_create_fn){
if((cljs.core.count.call(null,a) < hasch.benc.split_size)){
var len = cljs.core.long$.call(null,a.length);
var ea = hasch.benc.byte_array.call(null,len);
var i_9102 = (0);
while(true){
if(cljs.core._EQ_.call(null,i_9102,len)){
} else {
var e_9103 = (a[i_9102]);
if(((e_9103 > (0))) && ((e_9103 < (30)))){
(ea[i_9102] = (1));
} else {
}

var G__9104 = (i_9102 + (1));
i_9102 = G__9104;
continue;
}
break;
}

return a.concat(ea);
} else {
return hasch.benc.digest.call(null,a,md_create_fn);
}
});

//# sourceMappingURL=benc.js.map