// Compiled by ClojureScript 1.9.293 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args46641 = [];
var len__20433__auto___46647 = arguments.length;
var i__20434__auto___46648 = (0);
while(true){
if((i__20434__auto___46648 < len__20433__auto___46647)){
args46641.push((arguments[i__20434__auto___46648]));

var G__46649 = (i__20434__auto___46648 + (1));
i__20434__auto___46648 = G__46649;
continue;
} else {
}
break;
}

var G__46643 = args46641.length;
switch (G__46643) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args46641.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async46644 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46644 = (function (f,blockable,meta46645){
this.f = f;
this.blockable = blockable;
this.meta46645 = meta46645;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async46644.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46646,meta46645__$1){
var self__ = this;
var _46646__$1 = this;
return (new cljs.core.async.t_cljs$core$async46644(self__.f,self__.blockable,meta46645__$1));
});

cljs.core.async.t_cljs$core$async46644.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46646){
var self__ = this;
var _46646__$1 = this;
return self__.meta46645;
});

cljs.core.async.t_cljs$core$async46644.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async46644.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async46644.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async46644.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async46644.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta46645","meta46645",292263352,null)], null);
});

cljs.core.async.t_cljs$core$async46644.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async46644.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46644";

cljs.core.async.t_cljs$core$async46644.cljs$lang$ctorPrWriter = (function (this__19809__auto__,writer__19810__auto__,opt__19811__auto__){
return cljs.core._write.call(null,writer__19810__auto__,"cljs.core.async/t_cljs$core$async46644");
});

cljs.core.async.__GT_t_cljs$core$async46644 = (function cljs$core$async$__GT_t_cljs$core$async46644(f__$1,blockable__$1,meta46645){
return (new cljs.core.async.t_cljs$core$async46644(f__$1,blockable__$1,meta46645));
});

}

return (new cljs.core.async.t_cljs$core$async46644(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args46653 = [];
var len__20433__auto___46656 = arguments.length;
var i__20434__auto___46657 = (0);
while(true){
if((i__20434__auto___46657 < len__20433__auto___46656)){
args46653.push((arguments[i__20434__auto___46657]));

var G__46658 = (i__20434__auto___46657 + (1));
i__20434__auto___46657 = G__46658;
continue;
} else {
}
break;
}

var G__46655 = args46653.length;
switch (G__46655) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args46653.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args46660 = [];
var len__20433__auto___46663 = arguments.length;
var i__20434__auto___46664 = (0);
while(true){
if((i__20434__auto___46664 < len__20433__auto___46663)){
args46660.push((arguments[i__20434__auto___46664]));

var G__46665 = (i__20434__auto___46664 + (1));
i__20434__auto___46664 = G__46665;
continue;
} else {
}
break;
}

var G__46662 = args46660.length;
switch (G__46662) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args46660.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args46667 = [];
var len__20433__auto___46670 = arguments.length;
var i__20434__auto___46671 = (0);
while(true){
if((i__20434__auto___46671 < len__20433__auto___46670)){
args46667.push((arguments[i__20434__auto___46671]));

var G__46672 = (i__20434__auto___46671 + (1));
i__20434__auto___46671 = G__46672;
continue;
} else {
}
break;
}

var G__46669 = args46667.length;
switch (G__46669) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args46667.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_46674 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_46674);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_46674,ret){
return (function (){
return fn1.call(null,val_46674);
});})(val_46674,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args46675 = [];
var len__20433__auto___46678 = arguments.length;
var i__20434__auto___46679 = (0);
while(true){
if((i__20434__auto___46679 < len__20433__auto___46678)){
args46675.push((arguments[i__20434__auto___46679]));

var G__46680 = (i__20434__auto___46679 + (1));
i__20434__auto___46679 = G__46680;
continue;
} else {
}
break;
}

var G__46677 = args46675.length;
switch (G__46677) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args46675.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__6751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__6751__auto__)){
var ret = temp__6751__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__6751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__6751__auto__)){
var retb = temp__6751__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__6751__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__6751__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__20173__auto___46682 = n;
var x_46683 = (0);
while(true){
if((x_46683 < n__20173__auto___46682)){
(a[x_46683] = (0));

var G__46684 = (x_46683 + (1));
x_46683 = G__46684;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__46685 = (i + (1));
i = G__46685;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async46689 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46689 = (function (flag,meta46690){
this.flag = flag;
this.meta46690 = meta46690;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async46689.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_46691,meta46690__$1){
var self__ = this;
var _46691__$1 = this;
return (new cljs.core.async.t_cljs$core$async46689(self__.flag,meta46690__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async46689.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_46691){
var self__ = this;
var _46691__$1 = this;
return self__.meta46690;
});})(flag))
;

cljs.core.async.t_cljs$core$async46689.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async46689.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async46689.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async46689.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async46689.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta46690","meta46690",1215070890,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async46689.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async46689.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46689";

cljs.core.async.t_cljs$core$async46689.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__19809__auto__,writer__19810__auto__,opt__19811__auto__){
return cljs.core._write.call(null,writer__19810__auto__,"cljs.core.async/t_cljs$core$async46689");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async46689 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async46689(flag__$1,meta46690){
return (new cljs.core.async.t_cljs$core$async46689(flag__$1,meta46690));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async46689(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async46695 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46695 = (function (flag,cb,meta46696){
this.flag = flag;
this.cb = cb;
this.meta46696 = meta46696;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async46695.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46697,meta46696__$1){
var self__ = this;
var _46697__$1 = this;
return (new cljs.core.async.t_cljs$core$async46695(self__.flag,self__.cb,meta46696__$1));
});

cljs.core.async.t_cljs$core$async46695.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46697){
var self__ = this;
var _46697__$1 = this;
return self__.meta46696;
});

cljs.core.async.t_cljs$core$async46695.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async46695.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async46695.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async46695.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async46695.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta46696","meta46696",1050493993,null)], null);
});

cljs.core.async.t_cljs$core$async46695.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async46695.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46695";

cljs.core.async.t_cljs$core$async46695.cljs$lang$ctorPrWriter = (function (this__19809__auto__,writer__19810__auto__,opt__19811__auto__){
return cljs.core._write.call(null,writer__19810__auto__,"cljs.core.async/t_cljs$core$async46695");
});

cljs.core.async.__GT_t_cljs$core$async46695 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async46695(flag__$1,cb__$1,meta46696){
return (new cljs.core.async.t_cljs$core$async46695(flag__$1,cb__$1,meta46696));
});

}

return (new cljs.core.async.t_cljs$core$async46695(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__46698_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__46698_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__46699_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__46699_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__19157__auto__ = wport;
if(cljs.core.truth_(or__19157__auto__)){
return or__19157__auto__;
} else {
return port;
}
})()], null));
} else {
var G__46700 = (i + (1));
i = G__46700;
continue;
}
} else {
return null;
}
break;
}
})();
var or__19157__auto__ = ret;
if(cljs.core.truth_(or__19157__auto__)){
return or__19157__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__6753__auto__ = (function (){var and__19145__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__19145__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__19145__auto__;
}
})();
if(cljs.core.truth_(temp__6753__auto__)){
var got = temp__6753__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__20447__auto__ = [];
var len__20433__auto___46706 = arguments.length;
var i__20434__auto___46707 = (0);
while(true){
if((i__20434__auto___46707 < len__20433__auto___46706)){
args__20447__auto__.push((arguments[i__20434__auto___46707]));

var G__46708 = (i__20434__auto___46707 + (1));
i__20434__auto___46707 = G__46708;
continue;
} else {
}
break;
}

var argseq__20448__auto__ = ((((1) < args__20447__auto__.length))?(new cljs.core.IndexedSeq(args__20447__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__20448__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__46703){
var map__46704 = p__46703;
var map__46704__$1 = ((((!((map__46704 == null)))?((((map__46704.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46704.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__46704):map__46704);
var opts = map__46704__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq46701){
var G__46702 = cljs.core.first.call(null,seq46701);
var seq46701__$1 = cljs.core.next.call(null,seq46701);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__46702,seq46701__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args46709 = [];
var len__20433__auto___46759 = arguments.length;
var i__20434__auto___46760 = (0);
while(true){
if((i__20434__auto___46760 < len__20433__auto___46759)){
args46709.push((arguments[i__20434__auto___46760]));

var G__46761 = (i__20434__auto___46760 + (1));
i__20434__auto___46760 = G__46761;
continue;
} else {
}
break;
}

var G__46711 = args46709.length;
switch (G__46711) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args46709.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__46582__auto___46763 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46582__auto___46763){
return (function (){
var f__46583__auto__ = (function (){var switch__46468__auto__ = ((function (c__46582__auto___46763){
return (function (state_46735){
var state_val_46736 = (state_46735[(1)]);
if((state_val_46736 === (7))){
var inst_46731 = (state_46735[(2)]);
var state_46735__$1 = state_46735;
var statearr_46737_46764 = state_46735__$1;
(statearr_46737_46764[(2)] = inst_46731);

(statearr_46737_46764[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46736 === (1))){
var state_46735__$1 = state_46735;
var statearr_46738_46765 = state_46735__$1;
(statearr_46738_46765[(2)] = null);

(statearr_46738_46765[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46736 === (4))){
var inst_46714 = (state_46735[(7)]);
var inst_46714__$1 = (state_46735[(2)]);
var inst_46715 = (inst_46714__$1 == null);
var state_46735__$1 = (function (){var statearr_46739 = state_46735;
(statearr_46739[(7)] = inst_46714__$1);

return statearr_46739;
})();
if(cljs.core.truth_(inst_46715)){
var statearr_46740_46766 = state_46735__$1;
(statearr_46740_46766[(1)] = (5));

} else {
var statearr_46741_46767 = state_46735__$1;
(statearr_46741_46767[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46736 === (13))){
var state_46735__$1 = state_46735;
var statearr_46742_46768 = state_46735__$1;
(statearr_46742_46768[(2)] = null);

(statearr_46742_46768[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46736 === (6))){
var inst_46714 = (state_46735[(7)]);
var state_46735__$1 = state_46735;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_46735__$1,(11),to,inst_46714);
} else {
if((state_val_46736 === (3))){
var inst_46733 = (state_46735[(2)]);
var state_46735__$1 = state_46735;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46735__$1,inst_46733);
} else {
if((state_val_46736 === (12))){
var state_46735__$1 = state_46735;
var statearr_46743_46769 = state_46735__$1;
(statearr_46743_46769[(2)] = null);

(statearr_46743_46769[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46736 === (2))){
var state_46735__$1 = state_46735;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46735__$1,(4),from);
} else {
if((state_val_46736 === (11))){
var inst_46724 = (state_46735[(2)]);
var state_46735__$1 = state_46735;
if(cljs.core.truth_(inst_46724)){
var statearr_46744_46770 = state_46735__$1;
(statearr_46744_46770[(1)] = (12));

} else {
var statearr_46745_46771 = state_46735__$1;
(statearr_46745_46771[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46736 === (9))){
var state_46735__$1 = state_46735;
var statearr_46746_46772 = state_46735__$1;
(statearr_46746_46772[(2)] = null);

(statearr_46746_46772[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46736 === (5))){
var state_46735__$1 = state_46735;
if(cljs.core.truth_(close_QMARK_)){
var statearr_46747_46773 = state_46735__$1;
(statearr_46747_46773[(1)] = (8));

} else {
var statearr_46748_46774 = state_46735__$1;
(statearr_46748_46774[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46736 === (14))){
var inst_46729 = (state_46735[(2)]);
var state_46735__$1 = state_46735;
var statearr_46749_46775 = state_46735__$1;
(statearr_46749_46775[(2)] = inst_46729);

(statearr_46749_46775[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46736 === (10))){
var inst_46721 = (state_46735[(2)]);
var state_46735__$1 = state_46735;
var statearr_46750_46776 = state_46735__$1;
(statearr_46750_46776[(2)] = inst_46721);

(statearr_46750_46776[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46736 === (8))){
var inst_46718 = cljs.core.async.close_BANG_.call(null,to);
var state_46735__$1 = state_46735;
var statearr_46751_46777 = state_46735__$1;
(statearr_46751_46777[(2)] = inst_46718);

(statearr_46751_46777[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46582__auto___46763))
;
return ((function (switch__46468__auto__,c__46582__auto___46763){
return (function() {
var cljs$core$async$state_machine__46469__auto__ = null;
var cljs$core$async$state_machine__46469__auto____0 = (function (){
var statearr_46755 = [null,null,null,null,null,null,null,null];
(statearr_46755[(0)] = cljs$core$async$state_machine__46469__auto__);

(statearr_46755[(1)] = (1));

return statearr_46755;
});
var cljs$core$async$state_machine__46469__auto____1 = (function (state_46735){
while(true){
var ret_value__46470__auto__ = (function (){try{while(true){
var result__46471__auto__ = switch__46468__auto__.call(null,state_46735);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46471__auto__;
}
break;
}
}catch (e46756){if((e46756 instanceof Object)){
var ex__46472__auto__ = e46756;
var statearr_46757_46778 = state_46735;
(statearr_46757_46778[(5)] = ex__46472__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_46735);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e46756;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46779 = state_46735;
state_46735 = G__46779;
continue;
} else {
return ret_value__46470__auto__;
}
break;
}
});
cljs$core$async$state_machine__46469__auto__ = function(state_46735){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46469__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46469__auto____1.call(this,state_46735);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46469__auto____0;
cljs$core$async$state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46469__auto____1;
return cljs$core$async$state_machine__46469__auto__;
})()
;})(switch__46468__auto__,c__46582__auto___46763))
})();
var state__46584__auto__ = (function (){var statearr_46758 = f__46583__auto__.call(null);
(statearr_46758[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46582__auto___46763);

return statearr_46758;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46584__auto__);
});})(c__46582__auto___46763))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__46967){
var vec__46968 = p__46967;
var v = cljs.core.nth.call(null,vec__46968,(0),null);
var p = cljs.core.nth.call(null,vec__46968,(1),null);
var job = vec__46968;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__46582__auto___47154 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46582__auto___47154,res,vec__46968,v,p,job,jobs,results){
return (function (){
var f__46583__auto__ = (function (){var switch__46468__auto__ = ((function (c__46582__auto___47154,res,vec__46968,v,p,job,jobs,results){
return (function (state_46975){
var state_val_46976 = (state_46975[(1)]);
if((state_val_46976 === (1))){
var state_46975__$1 = state_46975;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_46975__$1,(2),res,v);
} else {
if((state_val_46976 === (2))){
var inst_46972 = (state_46975[(2)]);
var inst_46973 = cljs.core.async.close_BANG_.call(null,res);
var state_46975__$1 = (function (){var statearr_46977 = state_46975;
(statearr_46977[(7)] = inst_46972);

return statearr_46977;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46975__$1,inst_46973);
} else {
return null;
}
}
});})(c__46582__auto___47154,res,vec__46968,v,p,job,jobs,results))
;
return ((function (switch__46468__auto__,c__46582__auto___47154,res,vec__46968,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__46469__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__46469__auto____0 = (function (){
var statearr_46981 = [null,null,null,null,null,null,null,null];
(statearr_46981[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__46469__auto__);

(statearr_46981[(1)] = (1));

return statearr_46981;
});
var cljs$core$async$pipeline_STAR__$_state_machine__46469__auto____1 = (function (state_46975){
while(true){
var ret_value__46470__auto__ = (function (){try{while(true){
var result__46471__auto__ = switch__46468__auto__.call(null,state_46975);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46471__auto__;
}
break;
}
}catch (e46982){if((e46982 instanceof Object)){
var ex__46472__auto__ = e46982;
var statearr_46983_47155 = state_46975;
(statearr_46983_47155[(5)] = ex__46472__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_46975);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e46982;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47156 = state_46975;
state_46975 = G__47156;
continue;
} else {
return ret_value__46470__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__46469__auto__ = function(state_46975){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__46469__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__46469__auto____1.call(this,state_46975);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__46469__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__46469__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__46469__auto__;
})()
;})(switch__46468__auto__,c__46582__auto___47154,res,vec__46968,v,p,job,jobs,results))
})();
var state__46584__auto__ = (function (){var statearr_46984 = f__46583__auto__.call(null);
(statearr_46984[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46582__auto___47154);

return statearr_46984;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46584__auto__);
});})(c__46582__auto___47154,res,vec__46968,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__46985){
var vec__46986 = p__46985;
var v = cljs.core.nth.call(null,vec__46986,(0),null);
var p = cljs.core.nth.call(null,vec__46986,(1),null);
var job = vec__46986;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__20173__auto___47157 = n;
var __47158 = (0);
while(true){
if((__47158 < n__20173__auto___47157)){
var G__46989_47159 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__46989_47159) {
case "compute":
var c__46582__auto___47161 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__47158,c__46582__auto___47161,G__46989_47159,n__20173__auto___47157,jobs,results,process,async){
return (function (){
var f__46583__auto__ = (function (){var switch__46468__auto__ = ((function (__47158,c__46582__auto___47161,G__46989_47159,n__20173__auto___47157,jobs,results,process,async){
return (function (state_47002){
var state_val_47003 = (state_47002[(1)]);
if((state_val_47003 === (1))){
var state_47002__$1 = state_47002;
var statearr_47004_47162 = state_47002__$1;
(statearr_47004_47162[(2)] = null);

(statearr_47004_47162[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47003 === (2))){
var state_47002__$1 = state_47002;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47002__$1,(4),jobs);
} else {
if((state_val_47003 === (3))){
var inst_47000 = (state_47002[(2)]);
var state_47002__$1 = state_47002;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47002__$1,inst_47000);
} else {
if((state_val_47003 === (4))){
var inst_46992 = (state_47002[(2)]);
var inst_46993 = process.call(null,inst_46992);
var state_47002__$1 = state_47002;
if(cljs.core.truth_(inst_46993)){
var statearr_47005_47163 = state_47002__$1;
(statearr_47005_47163[(1)] = (5));

} else {
var statearr_47006_47164 = state_47002__$1;
(statearr_47006_47164[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47003 === (5))){
var state_47002__$1 = state_47002;
var statearr_47007_47165 = state_47002__$1;
(statearr_47007_47165[(2)] = null);

(statearr_47007_47165[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47003 === (6))){
var state_47002__$1 = state_47002;
var statearr_47008_47166 = state_47002__$1;
(statearr_47008_47166[(2)] = null);

(statearr_47008_47166[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47003 === (7))){
var inst_46998 = (state_47002[(2)]);
var state_47002__$1 = state_47002;
var statearr_47009_47167 = state_47002__$1;
(statearr_47009_47167[(2)] = inst_46998);

(statearr_47009_47167[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__47158,c__46582__auto___47161,G__46989_47159,n__20173__auto___47157,jobs,results,process,async))
;
return ((function (__47158,switch__46468__auto__,c__46582__auto___47161,G__46989_47159,n__20173__auto___47157,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__46469__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__46469__auto____0 = (function (){
var statearr_47013 = [null,null,null,null,null,null,null];
(statearr_47013[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__46469__auto__);

(statearr_47013[(1)] = (1));

return statearr_47013;
});
var cljs$core$async$pipeline_STAR__$_state_machine__46469__auto____1 = (function (state_47002){
while(true){
var ret_value__46470__auto__ = (function (){try{while(true){
var result__46471__auto__ = switch__46468__auto__.call(null,state_47002);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46471__auto__;
}
break;
}
}catch (e47014){if((e47014 instanceof Object)){
var ex__46472__auto__ = e47014;
var statearr_47015_47168 = state_47002;
(statearr_47015_47168[(5)] = ex__46472__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47002);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47014;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47169 = state_47002;
state_47002 = G__47169;
continue;
} else {
return ret_value__46470__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__46469__auto__ = function(state_47002){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__46469__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__46469__auto____1.call(this,state_47002);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__46469__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__46469__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__46469__auto__;
})()
;})(__47158,switch__46468__auto__,c__46582__auto___47161,G__46989_47159,n__20173__auto___47157,jobs,results,process,async))
})();
var state__46584__auto__ = (function (){var statearr_47016 = f__46583__auto__.call(null);
(statearr_47016[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46582__auto___47161);

return statearr_47016;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46584__auto__);
});})(__47158,c__46582__auto___47161,G__46989_47159,n__20173__auto___47157,jobs,results,process,async))
);


break;
case "async":
var c__46582__auto___47170 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__47158,c__46582__auto___47170,G__46989_47159,n__20173__auto___47157,jobs,results,process,async){
return (function (){
var f__46583__auto__ = (function (){var switch__46468__auto__ = ((function (__47158,c__46582__auto___47170,G__46989_47159,n__20173__auto___47157,jobs,results,process,async){
return (function (state_47029){
var state_val_47030 = (state_47029[(1)]);
if((state_val_47030 === (1))){
var state_47029__$1 = state_47029;
var statearr_47031_47171 = state_47029__$1;
(statearr_47031_47171[(2)] = null);

(statearr_47031_47171[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47030 === (2))){
var state_47029__$1 = state_47029;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47029__$1,(4),jobs);
} else {
if((state_val_47030 === (3))){
var inst_47027 = (state_47029[(2)]);
var state_47029__$1 = state_47029;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47029__$1,inst_47027);
} else {
if((state_val_47030 === (4))){
var inst_47019 = (state_47029[(2)]);
var inst_47020 = async.call(null,inst_47019);
var state_47029__$1 = state_47029;
if(cljs.core.truth_(inst_47020)){
var statearr_47032_47172 = state_47029__$1;
(statearr_47032_47172[(1)] = (5));

} else {
var statearr_47033_47173 = state_47029__$1;
(statearr_47033_47173[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47030 === (5))){
var state_47029__$1 = state_47029;
var statearr_47034_47174 = state_47029__$1;
(statearr_47034_47174[(2)] = null);

(statearr_47034_47174[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47030 === (6))){
var state_47029__$1 = state_47029;
var statearr_47035_47175 = state_47029__$1;
(statearr_47035_47175[(2)] = null);

(statearr_47035_47175[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47030 === (7))){
var inst_47025 = (state_47029[(2)]);
var state_47029__$1 = state_47029;
var statearr_47036_47176 = state_47029__$1;
(statearr_47036_47176[(2)] = inst_47025);

(statearr_47036_47176[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__47158,c__46582__auto___47170,G__46989_47159,n__20173__auto___47157,jobs,results,process,async))
;
return ((function (__47158,switch__46468__auto__,c__46582__auto___47170,G__46989_47159,n__20173__auto___47157,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__46469__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__46469__auto____0 = (function (){
var statearr_47040 = [null,null,null,null,null,null,null];
(statearr_47040[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__46469__auto__);

(statearr_47040[(1)] = (1));

return statearr_47040;
});
var cljs$core$async$pipeline_STAR__$_state_machine__46469__auto____1 = (function (state_47029){
while(true){
var ret_value__46470__auto__ = (function (){try{while(true){
var result__46471__auto__ = switch__46468__auto__.call(null,state_47029);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46471__auto__;
}
break;
}
}catch (e47041){if((e47041 instanceof Object)){
var ex__46472__auto__ = e47041;
var statearr_47042_47177 = state_47029;
(statearr_47042_47177[(5)] = ex__46472__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47029);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47041;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47178 = state_47029;
state_47029 = G__47178;
continue;
} else {
return ret_value__46470__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__46469__auto__ = function(state_47029){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__46469__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__46469__auto____1.call(this,state_47029);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__46469__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__46469__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__46469__auto__;
})()
;})(__47158,switch__46468__auto__,c__46582__auto___47170,G__46989_47159,n__20173__auto___47157,jobs,results,process,async))
})();
var state__46584__auto__ = (function (){var statearr_47043 = f__46583__auto__.call(null);
(statearr_47043[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46582__auto___47170);

return statearr_47043;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46584__auto__);
});})(__47158,c__46582__auto___47170,G__46989_47159,n__20173__auto___47157,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__47179 = (__47158 + (1));
__47158 = G__47179;
continue;
} else {
}
break;
}

var c__46582__auto___47180 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46582__auto___47180,jobs,results,process,async){
return (function (){
var f__46583__auto__ = (function (){var switch__46468__auto__ = ((function (c__46582__auto___47180,jobs,results,process,async){
return (function (state_47065){
var state_val_47066 = (state_47065[(1)]);
if((state_val_47066 === (1))){
var state_47065__$1 = state_47065;
var statearr_47067_47181 = state_47065__$1;
(statearr_47067_47181[(2)] = null);

(statearr_47067_47181[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47066 === (2))){
var state_47065__$1 = state_47065;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47065__$1,(4),from);
} else {
if((state_val_47066 === (3))){
var inst_47063 = (state_47065[(2)]);
var state_47065__$1 = state_47065;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47065__$1,inst_47063);
} else {
if((state_val_47066 === (4))){
var inst_47046 = (state_47065[(7)]);
var inst_47046__$1 = (state_47065[(2)]);
var inst_47047 = (inst_47046__$1 == null);
var state_47065__$1 = (function (){var statearr_47068 = state_47065;
(statearr_47068[(7)] = inst_47046__$1);

return statearr_47068;
})();
if(cljs.core.truth_(inst_47047)){
var statearr_47069_47182 = state_47065__$1;
(statearr_47069_47182[(1)] = (5));

} else {
var statearr_47070_47183 = state_47065__$1;
(statearr_47070_47183[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47066 === (5))){
var inst_47049 = cljs.core.async.close_BANG_.call(null,jobs);
var state_47065__$1 = state_47065;
var statearr_47071_47184 = state_47065__$1;
(statearr_47071_47184[(2)] = inst_47049);

(statearr_47071_47184[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47066 === (6))){
var inst_47046 = (state_47065[(7)]);
var inst_47051 = (state_47065[(8)]);
var inst_47051__$1 = cljs.core.async.chan.call(null,(1));
var inst_47052 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47053 = [inst_47046,inst_47051__$1];
var inst_47054 = (new cljs.core.PersistentVector(null,2,(5),inst_47052,inst_47053,null));
var state_47065__$1 = (function (){var statearr_47072 = state_47065;
(statearr_47072[(8)] = inst_47051__$1);

return statearr_47072;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_47065__$1,(8),jobs,inst_47054);
} else {
if((state_val_47066 === (7))){
var inst_47061 = (state_47065[(2)]);
var state_47065__$1 = state_47065;
var statearr_47073_47185 = state_47065__$1;
(statearr_47073_47185[(2)] = inst_47061);

(statearr_47073_47185[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47066 === (8))){
var inst_47051 = (state_47065[(8)]);
var inst_47056 = (state_47065[(2)]);
var state_47065__$1 = (function (){var statearr_47074 = state_47065;
(statearr_47074[(9)] = inst_47056);

return statearr_47074;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_47065__$1,(9),results,inst_47051);
} else {
if((state_val_47066 === (9))){
var inst_47058 = (state_47065[(2)]);
var state_47065__$1 = (function (){var statearr_47075 = state_47065;
(statearr_47075[(10)] = inst_47058);

return statearr_47075;
})();
var statearr_47076_47186 = state_47065__$1;
(statearr_47076_47186[(2)] = null);

(statearr_47076_47186[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__46582__auto___47180,jobs,results,process,async))
;
return ((function (switch__46468__auto__,c__46582__auto___47180,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__46469__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__46469__auto____0 = (function (){
var statearr_47080 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_47080[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__46469__auto__);

(statearr_47080[(1)] = (1));

return statearr_47080;
});
var cljs$core$async$pipeline_STAR__$_state_machine__46469__auto____1 = (function (state_47065){
while(true){
var ret_value__46470__auto__ = (function (){try{while(true){
var result__46471__auto__ = switch__46468__auto__.call(null,state_47065);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46471__auto__;
}
break;
}
}catch (e47081){if((e47081 instanceof Object)){
var ex__46472__auto__ = e47081;
var statearr_47082_47187 = state_47065;
(statearr_47082_47187[(5)] = ex__46472__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47065);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47081;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47188 = state_47065;
state_47065 = G__47188;
continue;
} else {
return ret_value__46470__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__46469__auto__ = function(state_47065){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__46469__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__46469__auto____1.call(this,state_47065);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__46469__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__46469__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__46469__auto__;
})()
;})(switch__46468__auto__,c__46582__auto___47180,jobs,results,process,async))
})();
var state__46584__auto__ = (function (){var statearr_47083 = f__46583__auto__.call(null);
(statearr_47083[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46582__auto___47180);

return statearr_47083;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46584__auto__);
});})(c__46582__auto___47180,jobs,results,process,async))
);


var c__46582__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46582__auto__,jobs,results,process,async){
return (function (){
var f__46583__auto__ = (function (){var switch__46468__auto__ = ((function (c__46582__auto__,jobs,results,process,async){
return (function (state_47121){
var state_val_47122 = (state_47121[(1)]);
if((state_val_47122 === (7))){
var inst_47117 = (state_47121[(2)]);
var state_47121__$1 = state_47121;
var statearr_47123_47189 = state_47121__$1;
(statearr_47123_47189[(2)] = inst_47117);

(statearr_47123_47189[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47122 === (20))){
var state_47121__$1 = state_47121;
var statearr_47124_47190 = state_47121__$1;
(statearr_47124_47190[(2)] = null);

(statearr_47124_47190[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47122 === (1))){
var state_47121__$1 = state_47121;
var statearr_47125_47191 = state_47121__$1;
(statearr_47125_47191[(2)] = null);

(statearr_47125_47191[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47122 === (4))){
var inst_47086 = (state_47121[(7)]);
var inst_47086__$1 = (state_47121[(2)]);
var inst_47087 = (inst_47086__$1 == null);
var state_47121__$1 = (function (){var statearr_47126 = state_47121;
(statearr_47126[(7)] = inst_47086__$1);

return statearr_47126;
})();
if(cljs.core.truth_(inst_47087)){
var statearr_47127_47192 = state_47121__$1;
(statearr_47127_47192[(1)] = (5));

} else {
var statearr_47128_47193 = state_47121__$1;
(statearr_47128_47193[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47122 === (15))){
var inst_47099 = (state_47121[(8)]);
var state_47121__$1 = state_47121;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_47121__$1,(18),to,inst_47099);
} else {
if((state_val_47122 === (21))){
var inst_47112 = (state_47121[(2)]);
var state_47121__$1 = state_47121;
var statearr_47129_47194 = state_47121__$1;
(statearr_47129_47194[(2)] = inst_47112);

(statearr_47129_47194[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47122 === (13))){
var inst_47114 = (state_47121[(2)]);
var state_47121__$1 = (function (){var statearr_47130 = state_47121;
(statearr_47130[(9)] = inst_47114);

return statearr_47130;
})();
var statearr_47131_47195 = state_47121__$1;
(statearr_47131_47195[(2)] = null);

(statearr_47131_47195[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47122 === (6))){
var inst_47086 = (state_47121[(7)]);
var state_47121__$1 = state_47121;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47121__$1,(11),inst_47086);
} else {
if((state_val_47122 === (17))){
var inst_47107 = (state_47121[(2)]);
var state_47121__$1 = state_47121;
if(cljs.core.truth_(inst_47107)){
var statearr_47132_47196 = state_47121__$1;
(statearr_47132_47196[(1)] = (19));

} else {
var statearr_47133_47197 = state_47121__$1;
(statearr_47133_47197[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47122 === (3))){
var inst_47119 = (state_47121[(2)]);
var state_47121__$1 = state_47121;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47121__$1,inst_47119);
} else {
if((state_val_47122 === (12))){
var inst_47096 = (state_47121[(10)]);
var state_47121__$1 = state_47121;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47121__$1,(14),inst_47096);
} else {
if((state_val_47122 === (2))){
var state_47121__$1 = state_47121;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47121__$1,(4),results);
} else {
if((state_val_47122 === (19))){
var state_47121__$1 = state_47121;
var statearr_47134_47198 = state_47121__$1;
(statearr_47134_47198[(2)] = null);

(statearr_47134_47198[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47122 === (11))){
var inst_47096 = (state_47121[(2)]);
var state_47121__$1 = (function (){var statearr_47135 = state_47121;
(statearr_47135[(10)] = inst_47096);

return statearr_47135;
})();
var statearr_47136_47199 = state_47121__$1;
(statearr_47136_47199[(2)] = null);

(statearr_47136_47199[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47122 === (9))){
var state_47121__$1 = state_47121;
var statearr_47137_47200 = state_47121__$1;
(statearr_47137_47200[(2)] = null);

(statearr_47137_47200[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47122 === (5))){
var state_47121__$1 = state_47121;
if(cljs.core.truth_(close_QMARK_)){
var statearr_47138_47201 = state_47121__$1;
(statearr_47138_47201[(1)] = (8));

} else {
var statearr_47139_47202 = state_47121__$1;
(statearr_47139_47202[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47122 === (14))){
var inst_47101 = (state_47121[(11)]);
var inst_47099 = (state_47121[(8)]);
var inst_47099__$1 = (state_47121[(2)]);
var inst_47100 = (inst_47099__$1 == null);
var inst_47101__$1 = cljs.core.not.call(null,inst_47100);
var state_47121__$1 = (function (){var statearr_47140 = state_47121;
(statearr_47140[(11)] = inst_47101__$1);

(statearr_47140[(8)] = inst_47099__$1);

return statearr_47140;
})();
if(inst_47101__$1){
var statearr_47141_47203 = state_47121__$1;
(statearr_47141_47203[(1)] = (15));

} else {
var statearr_47142_47204 = state_47121__$1;
(statearr_47142_47204[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47122 === (16))){
var inst_47101 = (state_47121[(11)]);
var state_47121__$1 = state_47121;
var statearr_47143_47205 = state_47121__$1;
(statearr_47143_47205[(2)] = inst_47101);

(statearr_47143_47205[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47122 === (10))){
var inst_47093 = (state_47121[(2)]);
var state_47121__$1 = state_47121;
var statearr_47144_47206 = state_47121__$1;
(statearr_47144_47206[(2)] = inst_47093);

(statearr_47144_47206[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47122 === (18))){
var inst_47104 = (state_47121[(2)]);
var state_47121__$1 = state_47121;
var statearr_47145_47207 = state_47121__$1;
(statearr_47145_47207[(2)] = inst_47104);

(statearr_47145_47207[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47122 === (8))){
var inst_47090 = cljs.core.async.close_BANG_.call(null,to);
var state_47121__$1 = state_47121;
var statearr_47146_47208 = state_47121__$1;
(statearr_47146_47208[(2)] = inst_47090);

(statearr_47146_47208[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46582__auto__,jobs,results,process,async))
;
return ((function (switch__46468__auto__,c__46582__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__46469__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__46469__auto____0 = (function (){
var statearr_47150 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47150[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__46469__auto__);

(statearr_47150[(1)] = (1));

return statearr_47150;
});
var cljs$core$async$pipeline_STAR__$_state_machine__46469__auto____1 = (function (state_47121){
while(true){
var ret_value__46470__auto__ = (function (){try{while(true){
var result__46471__auto__ = switch__46468__auto__.call(null,state_47121);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46471__auto__;
}
break;
}
}catch (e47151){if((e47151 instanceof Object)){
var ex__46472__auto__ = e47151;
var statearr_47152_47209 = state_47121;
(statearr_47152_47209[(5)] = ex__46472__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47121);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47151;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47210 = state_47121;
state_47121 = G__47210;
continue;
} else {
return ret_value__46470__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__46469__auto__ = function(state_47121){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__46469__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__46469__auto____1.call(this,state_47121);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__46469__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__46469__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__46469__auto__;
})()
;})(switch__46468__auto__,c__46582__auto__,jobs,results,process,async))
})();
var state__46584__auto__ = (function (){var statearr_47153 = f__46583__auto__.call(null);
(statearr_47153[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46582__auto__);

return statearr_47153;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46584__auto__);
});})(c__46582__auto__,jobs,results,process,async))
);

return c__46582__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args47211 = [];
var len__20433__auto___47214 = arguments.length;
var i__20434__auto___47215 = (0);
while(true){
if((i__20434__auto___47215 < len__20433__auto___47214)){
args47211.push((arguments[i__20434__auto___47215]));

var G__47216 = (i__20434__auto___47215 + (1));
i__20434__auto___47215 = G__47216;
continue;
} else {
}
break;
}

var G__47213 = args47211.length;
switch (G__47213) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args47211.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args47218 = [];
var len__20433__auto___47221 = arguments.length;
var i__20434__auto___47222 = (0);
while(true){
if((i__20434__auto___47222 < len__20433__auto___47221)){
args47218.push((arguments[i__20434__auto___47222]));

var G__47223 = (i__20434__auto___47222 + (1));
i__20434__auto___47222 = G__47223;
continue;
} else {
}
break;
}

var G__47220 = args47218.length;
switch (G__47220) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args47218.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args47225 = [];
var len__20433__auto___47278 = arguments.length;
var i__20434__auto___47279 = (0);
while(true){
if((i__20434__auto___47279 < len__20433__auto___47278)){
args47225.push((arguments[i__20434__auto___47279]));

var G__47280 = (i__20434__auto___47279 + (1));
i__20434__auto___47279 = G__47280;
continue;
} else {
}
break;
}

var G__47227 = args47225.length;
switch (G__47227) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args47225.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__46582__auto___47282 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46582__auto___47282,tc,fc){
return (function (){
var f__46583__auto__ = (function (){var switch__46468__auto__ = ((function (c__46582__auto___47282,tc,fc){
return (function (state_47253){
var state_val_47254 = (state_47253[(1)]);
if((state_val_47254 === (7))){
var inst_47249 = (state_47253[(2)]);
var state_47253__$1 = state_47253;
var statearr_47255_47283 = state_47253__$1;
(statearr_47255_47283[(2)] = inst_47249);

(statearr_47255_47283[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47254 === (1))){
var state_47253__$1 = state_47253;
var statearr_47256_47284 = state_47253__$1;
(statearr_47256_47284[(2)] = null);

(statearr_47256_47284[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47254 === (4))){
var inst_47230 = (state_47253[(7)]);
var inst_47230__$1 = (state_47253[(2)]);
var inst_47231 = (inst_47230__$1 == null);
var state_47253__$1 = (function (){var statearr_47257 = state_47253;
(statearr_47257[(7)] = inst_47230__$1);

return statearr_47257;
})();
if(cljs.core.truth_(inst_47231)){
var statearr_47258_47285 = state_47253__$1;
(statearr_47258_47285[(1)] = (5));

} else {
var statearr_47259_47286 = state_47253__$1;
(statearr_47259_47286[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47254 === (13))){
var state_47253__$1 = state_47253;
var statearr_47260_47287 = state_47253__$1;
(statearr_47260_47287[(2)] = null);

(statearr_47260_47287[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47254 === (6))){
var inst_47230 = (state_47253[(7)]);
var inst_47236 = p.call(null,inst_47230);
var state_47253__$1 = state_47253;
if(cljs.core.truth_(inst_47236)){
var statearr_47261_47288 = state_47253__$1;
(statearr_47261_47288[(1)] = (9));

} else {
var statearr_47262_47289 = state_47253__$1;
(statearr_47262_47289[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47254 === (3))){
var inst_47251 = (state_47253[(2)]);
var state_47253__$1 = state_47253;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47253__$1,inst_47251);
} else {
if((state_val_47254 === (12))){
var state_47253__$1 = state_47253;
var statearr_47263_47290 = state_47253__$1;
(statearr_47263_47290[(2)] = null);

(statearr_47263_47290[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47254 === (2))){
var state_47253__$1 = state_47253;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47253__$1,(4),ch);
} else {
if((state_val_47254 === (11))){
var inst_47230 = (state_47253[(7)]);
var inst_47240 = (state_47253[(2)]);
var state_47253__$1 = state_47253;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_47253__$1,(8),inst_47240,inst_47230);
} else {
if((state_val_47254 === (9))){
var state_47253__$1 = state_47253;
var statearr_47264_47291 = state_47253__$1;
(statearr_47264_47291[(2)] = tc);

(statearr_47264_47291[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47254 === (5))){
var inst_47233 = cljs.core.async.close_BANG_.call(null,tc);
var inst_47234 = cljs.core.async.close_BANG_.call(null,fc);
var state_47253__$1 = (function (){var statearr_47265 = state_47253;
(statearr_47265[(8)] = inst_47233);

return statearr_47265;
})();
var statearr_47266_47292 = state_47253__$1;
(statearr_47266_47292[(2)] = inst_47234);

(statearr_47266_47292[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47254 === (14))){
var inst_47247 = (state_47253[(2)]);
var state_47253__$1 = state_47253;
var statearr_47267_47293 = state_47253__$1;
(statearr_47267_47293[(2)] = inst_47247);

(statearr_47267_47293[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47254 === (10))){
var state_47253__$1 = state_47253;
var statearr_47268_47294 = state_47253__$1;
(statearr_47268_47294[(2)] = fc);

(statearr_47268_47294[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47254 === (8))){
var inst_47242 = (state_47253[(2)]);
var state_47253__$1 = state_47253;
if(cljs.core.truth_(inst_47242)){
var statearr_47269_47295 = state_47253__$1;
(statearr_47269_47295[(1)] = (12));

} else {
var statearr_47270_47296 = state_47253__$1;
(statearr_47270_47296[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46582__auto___47282,tc,fc))
;
return ((function (switch__46468__auto__,c__46582__auto___47282,tc,fc){
return (function() {
var cljs$core$async$state_machine__46469__auto__ = null;
var cljs$core$async$state_machine__46469__auto____0 = (function (){
var statearr_47274 = [null,null,null,null,null,null,null,null,null];
(statearr_47274[(0)] = cljs$core$async$state_machine__46469__auto__);

(statearr_47274[(1)] = (1));

return statearr_47274;
});
var cljs$core$async$state_machine__46469__auto____1 = (function (state_47253){
while(true){
var ret_value__46470__auto__ = (function (){try{while(true){
var result__46471__auto__ = switch__46468__auto__.call(null,state_47253);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46471__auto__;
}
break;
}
}catch (e47275){if((e47275 instanceof Object)){
var ex__46472__auto__ = e47275;
var statearr_47276_47297 = state_47253;
(statearr_47276_47297[(5)] = ex__46472__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47253);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47275;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47298 = state_47253;
state_47253 = G__47298;
continue;
} else {
return ret_value__46470__auto__;
}
break;
}
});
cljs$core$async$state_machine__46469__auto__ = function(state_47253){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46469__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46469__auto____1.call(this,state_47253);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46469__auto____0;
cljs$core$async$state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46469__auto____1;
return cljs$core$async$state_machine__46469__auto__;
})()
;})(switch__46468__auto__,c__46582__auto___47282,tc,fc))
})();
var state__46584__auto__ = (function (){var statearr_47277 = f__46583__auto__.call(null);
(statearr_47277[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46582__auto___47282);

return statearr_47277;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46584__auto__);
});})(c__46582__auto___47282,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__46582__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46582__auto__){
return (function (){
var f__46583__auto__ = (function (){var switch__46468__auto__ = ((function (c__46582__auto__){
return (function (state_47362){
var state_val_47363 = (state_47362[(1)]);
if((state_val_47363 === (7))){
var inst_47358 = (state_47362[(2)]);
var state_47362__$1 = state_47362;
var statearr_47364_47385 = state_47362__$1;
(statearr_47364_47385[(2)] = inst_47358);

(statearr_47364_47385[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47363 === (1))){
var inst_47342 = init;
var state_47362__$1 = (function (){var statearr_47365 = state_47362;
(statearr_47365[(7)] = inst_47342);

return statearr_47365;
})();
var statearr_47366_47386 = state_47362__$1;
(statearr_47366_47386[(2)] = null);

(statearr_47366_47386[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47363 === (4))){
var inst_47345 = (state_47362[(8)]);
var inst_47345__$1 = (state_47362[(2)]);
var inst_47346 = (inst_47345__$1 == null);
var state_47362__$1 = (function (){var statearr_47367 = state_47362;
(statearr_47367[(8)] = inst_47345__$1);

return statearr_47367;
})();
if(cljs.core.truth_(inst_47346)){
var statearr_47368_47387 = state_47362__$1;
(statearr_47368_47387[(1)] = (5));

} else {
var statearr_47369_47388 = state_47362__$1;
(statearr_47369_47388[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47363 === (6))){
var inst_47345 = (state_47362[(8)]);
var inst_47349 = (state_47362[(9)]);
var inst_47342 = (state_47362[(7)]);
var inst_47349__$1 = f.call(null,inst_47342,inst_47345);
var inst_47350 = cljs.core.reduced_QMARK_.call(null,inst_47349__$1);
var state_47362__$1 = (function (){var statearr_47370 = state_47362;
(statearr_47370[(9)] = inst_47349__$1);

return statearr_47370;
})();
if(inst_47350){
var statearr_47371_47389 = state_47362__$1;
(statearr_47371_47389[(1)] = (8));

} else {
var statearr_47372_47390 = state_47362__$1;
(statearr_47372_47390[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47363 === (3))){
var inst_47360 = (state_47362[(2)]);
var state_47362__$1 = state_47362;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47362__$1,inst_47360);
} else {
if((state_val_47363 === (2))){
var state_47362__$1 = state_47362;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47362__$1,(4),ch);
} else {
if((state_val_47363 === (9))){
var inst_47349 = (state_47362[(9)]);
var inst_47342 = inst_47349;
var state_47362__$1 = (function (){var statearr_47373 = state_47362;
(statearr_47373[(7)] = inst_47342);

return statearr_47373;
})();
var statearr_47374_47391 = state_47362__$1;
(statearr_47374_47391[(2)] = null);

(statearr_47374_47391[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47363 === (5))){
var inst_47342 = (state_47362[(7)]);
var state_47362__$1 = state_47362;
var statearr_47375_47392 = state_47362__$1;
(statearr_47375_47392[(2)] = inst_47342);

(statearr_47375_47392[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47363 === (10))){
var inst_47356 = (state_47362[(2)]);
var state_47362__$1 = state_47362;
var statearr_47376_47393 = state_47362__$1;
(statearr_47376_47393[(2)] = inst_47356);

(statearr_47376_47393[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47363 === (8))){
var inst_47349 = (state_47362[(9)]);
var inst_47352 = cljs.core.deref.call(null,inst_47349);
var state_47362__$1 = state_47362;
var statearr_47377_47394 = state_47362__$1;
(statearr_47377_47394[(2)] = inst_47352);

(statearr_47377_47394[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__46582__auto__))
;
return ((function (switch__46468__auto__,c__46582__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__46469__auto__ = null;
var cljs$core$async$reduce_$_state_machine__46469__auto____0 = (function (){
var statearr_47381 = [null,null,null,null,null,null,null,null,null,null];
(statearr_47381[(0)] = cljs$core$async$reduce_$_state_machine__46469__auto__);

(statearr_47381[(1)] = (1));

return statearr_47381;
});
var cljs$core$async$reduce_$_state_machine__46469__auto____1 = (function (state_47362){
while(true){
var ret_value__46470__auto__ = (function (){try{while(true){
var result__46471__auto__ = switch__46468__auto__.call(null,state_47362);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46471__auto__;
}
break;
}
}catch (e47382){if((e47382 instanceof Object)){
var ex__46472__auto__ = e47382;
var statearr_47383_47395 = state_47362;
(statearr_47383_47395[(5)] = ex__46472__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47362);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47382;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47396 = state_47362;
state_47362 = G__47396;
continue;
} else {
return ret_value__46470__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__46469__auto__ = function(state_47362){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__46469__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__46469__auto____1.call(this,state_47362);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__46469__auto____0;
cljs$core$async$reduce_$_state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__46469__auto____1;
return cljs$core$async$reduce_$_state_machine__46469__auto__;
})()
;})(switch__46468__auto__,c__46582__auto__))
})();
var state__46584__auto__ = (function (){var statearr_47384 = f__46583__auto__.call(null);
(statearr_47384[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46582__auto__);

return statearr_47384;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46584__auto__);
});})(c__46582__auto__))
);

return c__46582__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args47397 = [];
var len__20433__auto___47449 = arguments.length;
var i__20434__auto___47450 = (0);
while(true){
if((i__20434__auto___47450 < len__20433__auto___47449)){
args47397.push((arguments[i__20434__auto___47450]));

var G__47451 = (i__20434__auto___47450 + (1));
i__20434__auto___47450 = G__47451;
continue;
} else {
}
break;
}

var G__47399 = args47397.length;
switch (G__47399) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args47397.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__46582__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46582__auto__){
return (function (){
var f__46583__auto__ = (function (){var switch__46468__auto__ = ((function (c__46582__auto__){
return (function (state_47424){
var state_val_47425 = (state_47424[(1)]);
if((state_val_47425 === (7))){
var inst_47406 = (state_47424[(2)]);
var state_47424__$1 = state_47424;
var statearr_47426_47453 = state_47424__$1;
(statearr_47426_47453[(2)] = inst_47406);

(statearr_47426_47453[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47425 === (1))){
var inst_47400 = cljs.core.seq.call(null,coll);
var inst_47401 = inst_47400;
var state_47424__$1 = (function (){var statearr_47427 = state_47424;
(statearr_47427[(7)] = inst_47401);

return statearr_47427;
})();
var statearr_47428_47454 = state_47424__$1;
(statearr_47428_47454[(2)] = null);

(statearr_47428_47454[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47425 === (4))){
var inst_47401 = (state_47424[(7)]);
var inst_47404 = cljs.core.first.call(null,inst_47401);
var state_47424__$1 = state_47424;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_47424__$1,(7),ch,inst_47404);
} else {
if((state_val_47425 === (13))){
var inst_47418 = (state_47424[(2)]);
var state_47424__$1 = state_47424;
var statearr_47429_47455 = state_47424__$1;
(statearr_47429_47455[(2)] = inst_47418);

(statearr_47429_47455[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47425 === (6))){
var inst_47409 = (state_47424[(2)]);
var state_47424__$1 = state_47424;
if(cljs.core.truth_(inst_47409)){
var statearr_47430_47456 = state_47424__$1;
(statearr_47430_47456[(1)] = (8));

} else {
var statearr_47431_47457 = state_47424__$1;
(statearr_47431_47457[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47425 === (3))){
var inst_47422 = (state_47424[(2)]);
var state_47424__$1 = state_47424;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47424__$1,inst_47422);
} else {
if((state_val_47425 === (12))){
var state_47424__$1 = state_47424;
var statearr_47432_47458 = state_47424__$1;
(statearr_47432_47458[(2)] = null);

(statearr_47432_47458[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47425 === (2))){
var inst_47401 = (state_47424[(7)]);
var state_47424__$1 = state_47424;
if(cljs.core.truth_(inst_47401)){
var statearr_47433_47459 = state_47424__$1;
(statearr_47433_47459[(1)] = (4));

} else {
var statearr_47434_47460 = state_47424__$1;
(statearr_47434_47460[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47425 === (11))){
var inst_47415 = cljs.core.async.close_BANG_.call(null,ch);
var state_47424__$1 = state_47424;
var statearr_47435_47461 = state_47424__$1;
(statearr_47435_47461[(2)] = inst_47415);

(statearr_47435_47461[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47425 === (9))){
var state_47424__$1 = state_47424;
if(cljs.core.truth_(close_QMARK_)){
var statearr_47436_47462 = state_47424__$1;
(statearr_47436_47462[(1)] = (11));

} else {
var statearr_47437_47463 = state_47424__$1;
(statearr_47437_47463[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47425 === (5))){
var inst_47401 = (state_47424[(7)]);
var state_47424__$1 = state_47424;
var statearr_47438_47464 = state_47424__$1;
(statearr_47438_47464[(2)] = inst_47401);

(statearr_47438_47464[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47425 === (10))){
var inst_47420 = (state_47424[(2)]);
var state_47424__$1 = state_47424;
var statearr_47439_47465 = state_47424__$1;
(statearr_47439_47465[(2)] = inst_47420);

(statearr_47439_47465[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47425 === (8))){
var inst_47401 = (state_47424[(7)]);
var inst_47411 = cljs.core.next.call(null,inst_47401);
var inst_47401__$1 = inst_47411;
var state_47424__$1 = (function (){var statearr_47440 = state_47424;
(statearr_47440[(7)] = inst_47401__$1);

return statearr_47440;
})();
var statearr_47441_47466 = state_47424__$1;
(statearr_47441_47466[(2)] = null);

(statearr_47441_47466[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46582__auto__))
;
return ((function (switch__46468__auto__,c__46582__auto__){
return (function() {
var cljs$core$async$state_machine__46469__auto__ = null;
var cljs$core$async$state_machine__46469__auto____0 = (function (){
var statearr_47445 = [null,null,null,null,null,null,null,null];
(statearr_47445[(0)] = cljs$core$async$state_machine__46469__auto__);

(statearr_47445[(1)] = (1));

return statearr_47445;
});
var cljs$core$async$state_machine__46469__auto____1 = (function (state_47424){
while(true){
var ret_value__46470__auto__ = (function (){try{while(true){
var result__46471__auto__ = switch__46468__auto__.call(null,state_47424);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46471__auto__;
}
break;
}
}catch (e47446){if((e47446 instanceof Object)){
var ex__46472__auto__ = e47446;
var statearr_47447_47467 = state_47424;
(statearr_47447_47467[(5)] = ex__46472__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47424);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47446;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47468 = state_47424;
state_47424 = G__47468;
continue;
} else {
return ret_value__46470__auto__;
}
break;
}
});
cljs$core$async$state_machine__46469__auto__ = function(state_47424){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46469__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46469__auto____1.call(this,state_47424);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46469__auto____0;
cljs$core$async$state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46469__auto____1;
return cljs$core$async$state_machine__46469__auto__;
})()
;})(switch__46468__auto__,c__46582__auto__))
})();
var state__46584__auto__ = (function (){var statearr_47448 = f__46583__auto__.call(null);
(statearr_47448[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46582__auto__);

return statearr_47448;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46584__auto__);
});})(c__46582__auto__))
);

return c__46582__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__19870__auto__ = (((_ == null))?null:_);
var m__19871__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__19870__auto__)]);
if(!((m__19871__auto__ == null))){
return m__19871__auto__.call(null,_);
} else {
var m__19871__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__19871__auto____$1 == null))){
return m__19871__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__19870__auto__ = (((m == null))?null:m);
var m__19871__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__19870__auto__)]);
if(!((m__19871__auto__ == null))){
return m__19871__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__19871__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__19871__auto____$1 == null))){
return m__19871__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__19870__auto__ = (((m == null))?null:m);
var m__19871__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__19870__auto__)]);
if(!((m__19871__auto__ == null))){
return m__19871__auto__.call(null,m,ch);
} else {
var m__19871__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__19871__auto____$1 == null))){
return m__19871__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__19870__auto__ = (((m == null))?null:m);
var m__19871__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__19870__auto__)]);
if(!((m__19871__auto__ == null))){
return m__19871__auto__.call(null,m);
} else {
var m__19871__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__19871__auto____$1 == null))){
return m__19871__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async47694 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47694 = (function (ch,cs,meta47695){
this.ch = ch;
this.cs = cs;
this.meta47695 = meta47695;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async47694.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_47696,meta47695__$1){
var self__ = this;
var _47696__$1 = this;
return (new cljs.core.async.t_cljs$core$async47694(self__.ch,self__.cs,meta47695__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async47694.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_47696){
var self__ = this;
var _47696__$1 = this;
return self__.meta47695;
});})(cs))
;

cljs.core.async.t_cljs$core$async47694.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async47694.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async47694.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async47694.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async47694.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async47694.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async47694.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta47695","meta47695",1319479974,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async47694.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async47694.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47694";

cljs.core.async.t_cljs$core$async47694.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__19809__auto__,writer__19810__auto__,opt__19811__auto__){
return cljs.core._write.call(null,writer__19810__auto__,"cljs.core.async/t_cljs$core$async47694");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async47694 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async47694(ch__$1,cs__$1,meta47695){
return (new cljs.core.async.t_cljs$core$async47694(ch__$1,cs__$1,meta47695));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async47694(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__46582__auto___47919 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46582__auto___47919,cs,m,dchan,dctr,done){
return (function (){
var f__46583__auto__ = (function (){var switch__46468__auto__ = ((function (c__46582__auto___47919,cs,m,dchan,dctr,done){
return (function (state_47831){
var state_val_47832 = (state_47831[(1)]);
if((state_val_47832 === (7))){
var inst_47827 = (state_47831[(2)]);
var state_47831__$1 = state_47831;
var statearr_47833_47920 = state_47831__$1;
(statearr_47833_47920[(2)] = inst_47827);

(statearr_47833_47920[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (20))){
var inst_47730 = (state_47831[(7)]);
var inst_47742 = cljs.core.first.call(null,inst_47730);
var inst_47743 = cljs.core.nth.call(null,inst_47742,(0),null);
var inst_47744 = cljs.core.nth.call(null,inst_47742,(1),null);
var state_47831__$1 = (function (){var statearr_47834 = state_47831;
(statearr_47834[(8)] = inst_47743);

return statearr_47834;
})();
if(cljs.core.truth_(inst_47744)){
var statearr_47835_47921 = state_47831__$1;
(statearr_47835_47921[(1)] = (22));

} else {
var statearr_47836_47922 = state_47831__$1;
(statearr_47836_47922[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (27))){
var inst_47772 = (state_47831[(9)]);
var inst_47699 = (state_47831[(10)]);
var inst_47779 = (state_47831[(11)]);
var inst_47774 = (state_47831[(12)]);
var inst_47779__$1 = cljs.core._nth.call(null,inst_47772,inst_47774);
var inst_47780 = cljs.core.async.put_BANG_.call(null,inst_47779__$1,inst_47699,done);
var state_47831__$1 = (function (){var statearr_47837 = state_47831;
(statearr_47837[(11)] = inst_47779__$1);

return statearr_47837;
})();
if(cljs.core.truth_(inst_47780)){
var statearr_47838_47923 = state_47831__$1;
(statearr_47838_47923[(1)] = (30));

} else {
var statearr_47839_47924 = state_47831__$1;
(statearr_47839_47924[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (1))){
var state_47831__$1 = state_47831;
var statearr_47840_47925 = state_47831__$1;
(statearr_47840_47925[(2)] = null);

(statearr_47840_47925[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (24))){
var inst_47730 = (state_47831[(7)]);
var inst_47749 = (state_47831[(2)]);
var inst_47750 = cljs.core.next.call(null,inst_47730);
var inst_47708 = inst_47750;
var inst_47709 = null;
var inst_47710 = (0);
var inst_47711 = (0);
var state_47831__$1 = (function (){var statearr_47841 = state_47831;
(statearr_47841[(13)] = inst_47711);

(statearr_47841[(14)] = inst_47749);

(statearr_47841[(15)] = inst_47710);

(statearr_47841[(16)] = inst_47709);

(statearr_47841[(17)] = inst_47708);

return statearr_47841;
})();
var statearr_47842_47926 = state_47831__$1;
(statearr_47842_47926[(2)] = null);

(statearr_47842_47926[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (39))){
var state_47831__$1 = state_47831;
var statearr_47846_47927 = state_47831__$1;
(statearr_47846_47927[(2)] = null);

(statearr_47846_47927[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (4))){
var inst_47699 = (state_47831[(10)]);
var inst_47699__$1 = (state_47831[(2)]);
var inst_47700 = (inst_47699__$1 == null);
var state_47831__$1 = (function (){var statearr_47847 = state_47831;
(statearr_47847[(10)] = inst_47699__$1);

return statearr_47847;
})();
if(cljs.core.truth_(inst_47700)){
var statearr_47848_47928 = state_47831__$1;
(statearr_47848_47928[(1)] = (5));

} else {
var statearr_47849_47929 = state_47831__$1;
(statearr_47849_47929[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (15))){
var inst_47711 = (state_47831[(13)]);
var inst_47710 = (state_47831[(15)]);
var inst_47709 = (state_47831[(16)]);
var inst_47708 = (state_47831[(17)]);
var inst_47726 = (state_47831[(2)]);
var inst_47727 = (inst_47711 + (1));
var tmp47843 = inst_47710;
var tmp47844 = inst_47709;
var tmp47845 = inst_47708;
var inst_47708__$1 = tmp47845;
var inst_47709__$1 = tmp47844;
var inst_47710__$1 = tmp47843;
var inst_47711__$1 = inst_47727;
var state_47831__$1 = (function (){var statearr_47850 = state_47831;
(statearr_47850[(13)] = inst_47711__$1);

(statearr_47850[(18)] = inst_47726);

(statearr_47850[(15)] = inst_47710__$1);

(statearr_47850[(16)] = inst_47709__$1);

(statearr_47850[(17)] = inst_47708__$1);

return statearr_47850;
})();
var statearr_47851_47930 = state_47831__$1;
(statearr_47851_47930[(2)] = null);

(statearr_47851_47930[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (21))){
var inst_47753 = (state_47831[(2)]);
var state_47831__$1 = state_47831;
var statearr_47855_47931 = state_47831__$1;
(statearr_47855_47931[(2)] = inst_47753);

(statearr_47855_47931[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (31))){
var inst_47779 = (state_47831[(11)]);
var inst_47783 = done.call(null,null);
var inst_47784 = cljs.core.async.untap_STAR_.call(null,m,inst_47779);
var state_47831__$1 = (function (){var statearr_47856 = state_47831;
(statearr_47856[(19)] = inst_47783);

return statearr_47856;
})();
var statearr_47857_47932 = state_47831__$1;
(statearr_47857_47932[(2)] = inst_47784);

(statearr_47857_47932[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (32))){
var inst_47773 = (state_47831[(20)]);
var inst_47772 = (state_47831[(9)]);
var inst_47771 = (state_47831[(21)]);
var inst_47774 = (state_47831[(12)]);
var inst_47786 = (state_47831[(2)]);
var inst_47787 = (inst_47774 + (1));
var tmp47852 = inst_47773;
var tmp47853 = inst_47772;
var tmp47854 = inst_47771;
var inst_47771__$1 = tmp47854;
var inst_47772__$1 = tmp47853;
var inst_47773__$1 = tmp47852;
var inst_47774__$1 = inst_47787;
var state_47831__$1 = (function (){var statearr_47858 = state_47831;
(statearr_47858[(22)] = inst_47786);

(statearr_47858[(20)] = inst_47773__$1);

(statearr_47858[(9)] = inst_47772__$1);

(statearr_47858[(21)] = inst_47771__$1);

(statearr_47858[(12)] = inst_47774__$1);

return statearr_47858;
})();
var statearr_47859_47933 = state_47831__$1;
(statearr_47859_47933[(2)] = null);

(statearr_47859_47933[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (40))){
var inst_47799 = (state_47831[(23)]);
var inst_47803 = done.call(null,null);
var inst_47804 = cljs.core.async.untap_STAR_.call(null,m,inst_47799);
var state_47831__$1 = (function (){var statearr_47860 = state_47831;
(statearr_47860[(24)] = inst_47803);

return statearr_47860;
})();
var statearr_47861_47934 = state_47831__$1;
(statearr_47861_47934[(2)] = inst_47804);

(statearr_47861_47934[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (33))){
var inst_47790 = (state_47831[(25)]);
var inst_47792 = cljs.core.chunked_seq_QMARK_.call(null,inst_47790);
var state_47831__$1 = state_47831;
if(inst_47792){
var statearr_47862_47935 = state_47831__$1;
(statearr_47862_47935[(1)] = (36));

} else {
var statearr_47863_47936 = state_47831__$1;
(statearr_47863_47936[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (13))){
var inst_47720 = (state_47831[(26)]);
var inst_47723 = cljs.core.async.close_BANG_.call(null,inst_47720);
var state_47831__$1 = state_47831;
var statearr_47864_47937 = state_47831__$1;
(statearr_47864_47937[(2)] = inst_47723);

(statearr_47864_47937[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (22))){
var inst_47743 = (state_47831[(8)]);
var inst_47746 = cljs.core.async.close_BANG_.call(null,inst_47743);
var state_47831__$1 = state_47831;
var statearr_47865_47938 = state_47831__$1;
(statearr_47865_47938[(2)] = inst_47746);

(statearr_47865_47938[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (36))){
var inst_47790 = (state_47831[(25)]);
var inst_47794 = cljs.core.chunk_first.call(null,inst_47790);
var inst_47795 = cljs.core.chunk_rest.call(null,inst_47790);
var inst_47796 = cljs.core.count.call(null,inst_47794);
var inst_47771 = inst_47795;
var inst_47772 = inst_47794;
var inst_47773 = inst_47796;
var inst_47774 = (0);
var state_47831__$1 = (function (){var statearr_47866 = state_47831;
(statearr_47866[(20)] = inst_47773);

(statearr_47866[(9)] = inst_47772);

(statearr_47866[(21)] = inst_47771);

(statearr_47866[(12)] = inst_47774);

return statearr_47866;
})();
var statearr_47867_47939 = state_47831__$1;
(statearr_47867_47939[(2)] = null);

(statearr_47867_47939[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (41))){
var inst_47790 = (state_47831[(25)]);
var inst_47806 = (state_47831[(2)]);
var inst_47807 = cljs.core.next.call(null,inst_47790);
var inst_47771 = inst_47807;
var inst_47772 = null;
var inst_47773 = (0);
var inst_47774 = (0);
var state_47831__$1 = (function (){var statearr_47868 = state_47831;
(statearr_47868[(27)] = inst_47806);

(statearr_47868[(20)] = inst_47773);

(statearr_47868[(9)] = inst_47772);

(statearr_47868[(21)] = inst_47771);

(statearr_47868[(12)] = inst_47774);

return statearr_47868;
})();
var statearr_47869_47940 = state_47831__$1;
(statearr_47869_47940[(2)] = null);

(statearr_47869_47940[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (43))){
var state_47831__$1 = state_47831;
var statearr_47870_47941 = state_47831__$1;
(statearr_47870_47941[(2)] = null);

(statearr_47870_47941[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (29))){
var inst_47815 = (state_47831[(2)]);
var state_47831__$1 = state_47831;
var statearr_47871_47942 = state_47831__$1;
(statearr_47871_47942[(2)] = inst_47815);

(statearr_47871_47942[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (44))){
var inst_47824 = (state_47831[(2)]);
var state_47831__$1 = (function (){var statearr_47872 = state_47831;
(statearr_47872[(28)] = inst_47824);

return statearr_47872;
})();
var statearr_47873_47943 = state_47831__$1;
(statearr_47873_47943[(2)] = null);

(statearr_47873_47943[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (6))){
var inst_47763 = (state_47831[(29)]);
var inst_47762 = cljs.core.deref.call(null,cs);
var inst_47763__$1 = cljs.core.keys.call(null,inst_47762);
var inst_47764 = cljs.core.count.call(null,inst_47763__$1);
var inst_47765 = cljs.core.reset_BANG_.call(null,dctr,inst_47764);
var inst_47770 = cljs.core.seq.call(null,inst_47763__$1);
var inst_47771 = inst_47770;
var inst_47772 = null;
var inst_47773 = (0);
var inst_47774 = (0);
var state_47831__$1 = (function (){var statearr_47874 = state_47831;
(statearr_47874[(30)] = inst_47765);

(statearr_47874[(29)] = inst_47763__$1);

(statearr_47874[(20)] = inst_47773);

(statearr_47874[(9)] = inst_47772);

(statearr_47874[(21)] = inst_47771);

(statearr_47874[(12)] = inst_47774);

return statearr_47874;
})();
var statearr_47875_47944 = state_47831__$1;
(statearr_47875_47944[(2)] = null);

(statearr_47875_47944[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (28))){
var inst_47790 = (state_47831[(25)]);
var inst_47771 = (state_47831[(21)]);
var inst_47790__$1 = cljs.core.seq.call(null,inst_47771);
var state_47831__$1 = (function (){var statearr_47876 = state_47831;
(statearr_47876[(25)] = inst_47790__$1);

return statearr_47876;
})();
if(inst_47790__$1){
var statearr_47877_47945 = state_47831__$1;
(statearr_47877_47945[(1)] = (33));

} else {
var statearr_47878_47946 = state_47831__$1;
(statearr_47878_47946[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (25))){
var inst_47773 = (state_47831[(20)]);
var inst_47774 = (state_47831[(12)]);
var inst_47776 = (inst_47774 < inst_47773);
var inst_47777 = inst_47776;
var state_47831__$1 = state_47831;
if(cljs.core.truth_(inst_47777)){
var statearr_47879_47947 = state_47831__$1;
(statearr_47879_47947[(1)] = (27));

} else {
var statearr_47880_47948 = state_47831__$1;
(statearr_47880_47948[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (34))){
var state_47831__$1 = state_47831;
var statearr_47881_47949 = state_47831__$1;
(statearr_47881_47949[(2)] = null);

(statearr_47881_47949[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (17))){
var state_47831__$1 = state_47831;
var statearr_47882_47950 = state_47831__$1;
(statearr_47882_47950[(2)] = null);

(statearr_47882_47950[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (3))){
var inst_47829 = (state_47831[(2)]);
var state_47831__$1 = state_47831;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47831__$1,inst_47829);
} else {
if((state_val_47832 === (12))){
var inst_47758 = (state_47831[(2)]);
var state_47831__$1 = state_47831;
var statearr_47883_47951 = state_47831__$1;
(statearr_47883_47951[(2)] = inst_47758);

(statearr_47883_47951[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (2))){
var state_47831__$1 = state_47831;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47831__$1,(4),ch);
} else {
if((state_val_47832 === (23))){
var state_47831__$1 = state_47831;
var statearr_47884_47952 = state_47831__$1;
(statearr_47884_47952[(2)] = null);

(statearr_47884_47952[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (35))){
var inst_47813 = (state_47831[(2)]);
var state_47831__$1 = state_47831;
var statearr_47885_47953 = state_47831__$1;
(statearr_47885_47953[(2)] = inst_47813);

(statearr_47885_47953[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (19))){
var inst_47730 = (state_47831[(7)]);
var inst_47734 = cljs.core.chunk_first.call(null,inst_47730);
var inst_47735 = cljs.core.chunk_rest.call(null,inst_47730);
var inst_47736 = cljs.core.count.call(null,inst_47734);
var inst_47708 = inst_47735;
var inst_47709 = inst_47734;
var inst_47710 = inst_47736;
var inst_47711 = (0);
var state_47831__$1 = (function (){var statearr_47886 = state_47831;
(statearr_47886[(13)] = inst_47711);

(statearr_47886[(15)] = inst_47710);

(statearr_47886[(16)] = inst_47709);

(statearr_47886[(17)] = inst_47708);

return statearr_47886;
})();
var statearr_47887_47954 = state_47831__$1;
(statearr_47887_47954[(2)] = null);

(statearr_47887_47954[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (11))){
var inst_47730 = (state_47831[(7)]);
var inst_47708 = (state_47831[(17)]);
var inst_47730__$1 = cljs.core.seq.call(null,inst_47708);
var state_47831__$1 = (function (){var statearr_47888 = state_47831;
(statearr_47888[(7)] = inst_47730__$1);

return statearr_47888;
})();
if(inst_47730__$1){
var statearr_47889_47955 = state_47831__$1;
(statearr_47889_47955[(1)] = (16));

} else {
var statearr_47890_47956 = state_47831__$1;
(statearr_47890_47956[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (9))){
var inst_47760 = (state_47831[(2)]);
var state_47831__$1 = state_47831;
var statearr_47891_47957 = state_47831__$1;
(statearr_47891_47957[(2)] = inst_47760);

(statearr_47891_47957[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (5))){
var inst_47706 = cljs.core.deref.call(null,cs);
var inst_47707 = cljs.core.seq.call(null,inst_47706);
var inst_47708 = inst_47707;
var inst_47709 = null;
var inst_47710 = (0);
var inst_47711 = (0);
var state_47831__$1 = (function (){var statearr_47892 = state_47831;
(statearr_47892[(13)] = inst_47711);

(statearr_47892[(15)] = inst_47710);

(statearr_47892[(16)] = inst_47709);

(statearr_47892[(17)] = inst_47708);

return statearr_47892;
})();
var statearr_47893_47958 = state_47831__$1;
(statearr_47893_47958[(2)] = null);

(statearr_47893_47958[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (14))){
var state_47831__$1 = state_47831;
var statearr_47894_47959 = state_47831__$1;
(statearr_47894_47959[(2)] = null);

(statearr_47894_47959[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (45))){
var inst_47821 = (state_47831[(2)]);
var state_47831__$1 = state_47831;
var statearr_47895_47960 = state_47831__$1;
(statearr_47895_47960[(2)] = inst_47821);

(statearr_47895_47960[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (26))){
var inst_47763 = (state_47831[(29)]);
var inst_47817 = (state_47831[(2)]);
var inst_47818 = cljs.core.seq.call(null,inst_47763);
var state_47831__$1 = (function (){var statearr_47896 = state_47831;
(statearr_47896[(31)] = inst_47817);

return statearr_47896;
})();
if(inst_47818){
var statearr_47897_47961 = state_47831__$1;
(statearr_47897_47961[(1)] = (42));

} else {
var statearr_47898_47962 = state_47831__$1;
(statearr_47898_47962[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (16))){
var inst_47730 = (state_47831[(7)]);
var inst_47732 = cljs.core.chunked_seq_QMARK_.call(null,inst_47730);
var state_47831__$1 = state_47831;
if(inst_47732){
var statearr_47899_47963 = state_47831__$1;
(statearr_47899_47963[(1)] = (19));

} else {
var statearr_47900_47964 = state_47831__$1;
(statearr_47900_47964[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (38))){
var inst_47810 = (state_47831[(2)]);
var state_47831__$1 = state_47831;
var statearr_47901_47965 = state_47831__$1;
(statearr_47901_47965[(2)] = inst_47810);

(statearr_47901_47965[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (30))){
var state_47831__$1 = state_47831;
var statearr_47902_47966 = state_47831__$1;
(statearr_47902_47966[(2)] = null);

(statearr_47902_47966[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (10))){
var inst_47711 = (state_47831[(13)]);
var inst_47709 = (state_47831[(16)]);
var inst_47719 = cljs.core._nth.call(null,inst_47709,inst_47711);
var inst_47720 = cljs.core.nth.call(null,inst_47719,(0),null);
var inst_47721 = cljs.core.nth.call(null,inst_47719,(1),null);
var state_47831__$1 = (function (){var statearr_47903 = state_47831;
(statearr_47903[(26)] = inst_47720);

return statearr_47903;
})();
if(cljs.core.truth_(inst_47721)){
var statearr_47904_47967 = state_47831__$1;
(statearr_47904_47967[(1)] = (13));

} else {
var statearr_47905_47968 = state_47831__$1;
(statearr_47905_47968[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (18))){
var inst_47756 = (state_47831[(2)]);
var state_47831__$1 = state_47831;
var statearr_47906_47969 = state_47831__$1;
(statearr_47906_47969[(2)] = inst_47756);

(statearr_47906_47969[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (42))){
var state_47831__$1 = state_47831;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47831__$1,(45),dchan);
} else {
if((state_val_47832 === (37))){
var inst_47790 = (state_47831[(25)]);
var inst_47799 = (state_47831[(23)]);
var inst_47699 = (state_47831[(10)]);
var inst_47799__$1 = cljs.core.first.call(null,inst_47790);
var inst_47800 = cljs.core.async.put_BANG_.call(null,inst_47799__$1,inst_47699,done);
var state_47831__$1 = (function (){var statearr_47907 = state_47831;
(statearr_47907[(23)] = inst_47799__$1);

return statearr_47907;
})();
if(cljs.core.truth_(inst_47800)){
var statearr_47908_47970 = state_47831__$1;
(statearr_47908_47970[(1)] = (39));

} else {
var statearr_47909_47971 = state_47831__$1;
(statearr_47909_47971[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47832 === (8))){
var inst_47711 = (state_47831[(13)]);
var inst_47710 = (state_47831[(15)]);
var inst_47713 = (inst_47711 < inst_47710);
var inst_47714 = inst_47713;
var state_47831__$1 = state_47831;
if(cljs.core.truth_(inst_47714)){
var statearr_47910_47972 = state_47831__$1;
(statearr_47910_47972[(1)] = (10));

} else {
var statearr_47911_47973 = state_47831__$1;
(statearr_47911_47973[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46582__auto___47919,cs,m,dchan,dctr,done))
;
return ((function (switch__46468__auto__,c__46582__auto___47919,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__46469__auto__ = null;
var cljs$core$async$mult_$_state_machine__46469__auto____0 = (function (){
var statearr_47915 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47915[(0)] = cljs$core$async$mult_$_state_machine__46469__auto__);

(statearr_47915[(1)] = (1));

return statearr_47915;
});
var cljs$core$async$mult_$_state_machine__46469__auto____1 = (function (state_47831){
while(true){
var ret_value__46470__auto__ = (function (){try{while(true){
var result__46471__auto__ = switch__46468__auto__.call(null,state_47831);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46471__auto__;
}
break;
}
}catch (e47916){if((e47916 instanceof Object)){
var ex__46472__auto__ = e47916;
var statearr_47917_47974 = state_47831;
(statearr_47917_47974[(5)] = ex__46472__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47831);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47916;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47975 = state_47831;
state_47831 = G__47975;
continue;
} else {
return ret_value__46470__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__46469__auto__ = function(state_47831){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__46469__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__46469__auto____1.call(this,state_47831);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__46469__auto____0;
cljs$core$async$mult_$_state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__46469__auto____1;
return cljs$core$async$mult_$_state_machine__46469__auto__;
})()
;})(switch__46468__auto__,c__46582__auto___47919,cs,m,dchan,dctr,done))
})();
var state__46584__auto__ = (function (){var statearr_47918 = f__46583__auto__.call(null);
(statearr_47918[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46582__auto___47919);

return statearr_47918;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46584__auto__);
});})(c__46582__auto___47919,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args47976 = [];
var len__20433__auto___47979 = arguments.length;
var i__20434__auto___47980 = (0);
while(true){
if((i__20434__auto___47980 < len__20433__auto___47979)){
args47976.push((arguments[i__20434__auto___47980]));

var G__47981 = (i__20434__auto___47980 + (1));
i__20434__auto___47980 = G__47981;
continue;
} else {
}
break;
}

var G__47978 = args47976.length;
switch (G__47978) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args47976.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__19870__auto__ = (((m == null))?null:m);
var m__19871__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__19870__auto__)]);
if(!((m__19871__auto__ == null))){
return m__19871__auto__.call(null,m,ch);
} else {
var m__19871__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__19871__auto____$1 == null))){
return m__19871__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__19870__auto__ = (((m == null))?null:m);
var m__19871__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__19870__auto__)]);
if(!((m__19871__auto__ == null))){
return m__19871__auto__.call(null,m,ch);
} else {
var m__19871__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__19871__auto____$1 == null))){
return m__19871__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__19870__auto__ = (((m == null))?null:m);
var m__19871__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__19870__auto__)]);
if(!((m__19871__auto__ == null))){
return m__19871__auto__.call(null,m);
} else {
var m__19871__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__19871__auto____$1 == null))){
return m__19871__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__19870__auto__ = (((m == null))?null:m);
var m__19871__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__19870__auto__)]);
if(!((m__19871__auto__ == null))){
return m__19871__auto__.call(null,m,state_map);
} else {
var m__19871__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__19871__auto____$1 == null))){
return m__19871__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__19870__auto__ = (((m == null))?null:m);
var m__19871__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__19870__auto__)]);
if(!((m__19871__auto__ == null))){
return m__19871__auto__.call(null,m,mode);
} else {
var m__19871__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__19871__auto____$1 == null))){
return m__19871__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__20447__auto__ = [];
var len__20433__auto___47993 = arguments.length;
var i__20434__auto___47994 = (0);
while(true){
if((i__20434__auto___47994 < len__20433__auto___47993)){
args__20447__auto__.push((arguments[i__20434__auto___47994]));

var G__47995 = (i__20434__auto___47994 + (1));
i__20434__auto___47994 = G__47995;
continue;
} else {
}
break;
}

var argseq__20448__auto__ = ((((3) < args__20447__auto__.length))?(new cljs.core.IndexedSeq(args__20447__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__20448__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__47987){
var map__47988 = p__47987;
var map__47988__$1 = ((((!((map__47988 == null)))?((((map__47988.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47988.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__47988):map__47988);
var opts = map__47988__$1;
var statearr_47990_47996 = state;
(statearr_47990_47996[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__6753__auto__ = cljs.core.async.do_alts.call(null,((function (map__47988,map__47988__$1,opts){
return (function (val){
var statearr_47991_47997 = state;
(statearr_47991_47997[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__47988,map__47988__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__6753__auto__)){
var cb = temp__6753__auto__;
var statearr_47992_47998 = state;
(statearr_47992_47998[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq47983){
var G__47984 = cljs.core.first.call(null,seq47983);
var seq47983__$1 = cljs.core.next.call(null,seq47983);
var G__47985 = cljs.core.first.call(null,seq47983__$1);
var seq47983__$2 = cljs.core.next.call(null,seq47983__$1);
var G__47986 = cljs.core.first.call(null,seq47983__$2);
var seq47983__$3 = cljs.core.next.call(null,seq47983__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__47984,G__47985,G__47986,seq47983__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async48166 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48166 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta48167){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta48167 = meta48167;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async48166.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_48168,meta48167__$1){
var self__ = this;
var _48168__$1 = this;
return (new cljs.core.async.t_cljs$core$async48166(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta48167__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async48166.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_48168){
var self__ = this;
var _48168__$1 = this;
return self__.meta48167;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async48166.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48166.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async48166.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48166.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async48166.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async48166.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async48166.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async48166.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async48166.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta48167","meta48167",-2102255644,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async48166.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async48166.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48166";

cljs.core.async.t_cljs$core$async48166.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__19809__auto__,writer__19810__auto__,opt__19811__auto__){
return cljs.core._write.call(null,writer__19810__auto__,"cljs.core.async/t_cljs$core$async48166");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async48166 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async48166(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta48167){
return (new cljs.core.async.t_cljs$core$async48166(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta48167));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async48166(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__46582__auto___48333 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46582__auto___48333,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__46583__auto__ = (function (){var switch__46468__auto__ = ((function (c__46582__auto___48333,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_48270){
var state_val_48271 = (state_48270[(1)]);
if((state_val_48271 === (7))){
var inst_48185 = (state_48270[(2)]);
var state_48270__$1 = state_48270;
var statearr_48272_48334 = state_48270__$1;
(statearr_48272_48334[(2)] = inst_48185);

(statearr_48272_48334[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48271 === (20))){
var inst_48197 = (state_48270[(7)]);
var state_48270__$1 = state_48270;
var statearr_48273_48335 = state_48270__$1;
(statearr_48273_48335[(2)] = inst_48197);

(statearr_48273_48335[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48271 === (27))){
var state_48270__$1 = state_48270;
var statearr_48274_48336 = state_48270__$1;
(statearr_48274_48336[(2)] = null);

(statearr_48274_48336[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48271 === (1))){
var inst_48172 = (state_48270[(8)]);
var inst_48172__$1 = calc_state.call(null);
var inst_48174 = (inst_48172__$1 == null);
var inst_48175 = cljs.core.not.call(null,inst_48174);
var state_48270__$1 = (function (){var statearr_48275 = state_48270;
(statearr_48275[(8)] = inst_48172__$1);

return statearr_48275;
})();
if(inst_48175){
var statearr_48276_48337 = state_48270__$1;
(statearr_48276_48337[(1)] = (2));

} else {
var statearr_48277_48338 = state_48270__$1;
(statearr_48277_48338[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48271 === (24))){
var inst_48230 = (state_48270[(9)]);
var inst_48221 = (state_48270[(10)]);
var inst_48244 = (state_48270[(11)]);
var inst_48244__$1 = inst_48221.call(null,inst_48230);
var state_48270__$1 = (function (){var statearr_48278 = state_48270;
(statearr_48278[(11)] = inst_48244__$1);

return statearr_48278;
})();
if(cljs.core.truth_(inst_48244__$1)){
var statearr_48279_48339 = state_48270__$1;
(statearr_48279_48339[(1)] = (29));

} else {
var statearr_48280_48340 = state_48270__$1;
(statearr_48280_48340[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48271 === (4))){
var inst_48188 = (state_48270[(2)]);
var state_48270__$1 = state_48270;
if(cljs.core.truth_(inst_48188)){
var statearr_48281_48341 = state_48270__$1;
(statearr_48281_48341[(1)] = (8));

} else {
var statearr_48282_48342 = state_48270__$1;
(statearr_48282_48342[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48271 === (15))){
var inst_48215 = (state_48270[(2)]);
var state_48270__$1 = state_48270;
if(cljs.core.truth_(inst_48215)){
var statearr_48283_48343 = state_48270__$1;
(statearr_48283_48343[(1)] = (19));

} else {
var statearr_48284_48344 = state_48270__$1;
(statearr_48284_48344[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48271 === (21))){
var inst_48220 = (state_48270[(12)]);
var inst_48220__$1 = (state_48270[(2)]);
var inst_48221 = cljs.core.get.call(null,inst_48220__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_48222 = cljs.core.get.call(null,inst_48220__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_48223 = cljs.core.get.call(null,inst_48220__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_48270__$1 = (function (){var statearr_48285 = state_48270;
(statearr_48285[(10)] = inst_48221);

(statearr_48285[(12)] = inst_48220__$1);

(statearr_48285[(13)] = inst_48222);

return statearr_48285;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_48270__$1,(22),inst_48223);
} else {
if((state_val_48271 === (31))){
var inst_48252 = (state_48270[(2)]);
var state_48270__$1 = state_48270;
if(cljs.core.truth_(inst_48252)){
var statearr_48286_48345 = state_48270__$1;
(statearr_48286_48345[(1)] = (32));

} else {
var statearr_48287_48346 = state_48270__$1;
(statearr_48287_48346[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48271 === (32))){
var inst_48229 = (state_48270[(14)]);
var state_48270__$1 = state_48270;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48270__$1,(35),out,inst_48229);
} else {
if((state_val_48271 === (33))){
var inst_48220 = (state_48270[(12)]);
var inst_48197 = inst_48220;
var state_48270__$1 = (function (){var statearr_48288 = state_48270;
(statearr_48288[(7)] = inst_48197);

return statearr_48288;
})();
var statearr_48289_48347 = state_48270__$1;
(statearr_48289_48347[(2)] = null);

(statearr_48289_48347[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48271 === (13))){
var inst_48197 = (state_48270[(7)]);
var inst_48204 = inst_48197.cljs$lang$protocol_mask$partition0$;
var inst_48205 = (inst_48204 & (64));
var inst_48206 = inst_48197.cljs$core$ISeq$;
var inst_48207 = (cljs.core.PROTOCOL_SENTINEL === inst_48206);
var inst_48208 = (inst_48205) || (inst_48207);
var state_48270__$1 = state_48270;
if(cljs.core.truth_(inst_48208)){
var statearr_48290_48348 = state_48270__$1;
(statearr_48290_48348[(1)] = (16));

} else {
var statearr_48291_48349 = state_48270__$1;
(statearr_48291_48349[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48271 === (22))){
var inst_48230 = (state_48270[(9)]);
var inst_48229 = (state_48270[(14)]);
var inst_48228 = (state_48270[(2)]);
var inst_48229__$1 = cljs.core.nth.call(null,inst_48228,(0),null);
var inst_48230__$1 = cljs.core.nth.call(null,inst_48228,(1),null);
var inst_48231 = (inst_48229__$1 == null);
var inst_48232 = cljs.core._EQ_.call(null,inst_48230__$1,change);
var inst_48233 = (inst_48231) || (inst_48232);
var state_48270__$1 = (function (){var statearr_48292 = state_48270;
(statearr_48292[(9)] = inst_48230__$1);

(statearr_48292[(14)] = inst_48229__$1);

return statearr_48292;
})();
if(cljs.core.truth_(inst_48233)){
var statearr_48293_48350 = state_48270__$1;
(statearr_48293_48350[(1)] = (23));

} else {
var statearr_48294_48351 = state_48270__$1;
(statearr_48294_48351[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48271 === (36))){
var inst_48220 = (state_48270[(12)]);
var inst_48197 = inst_48220;
var state_48270__$1 = (function (){var statearr_48295 = state_48270;
(statearr_48295[(7)] = inst_48197);

return statearr_48295;
})();
var statearr_48296_48352 = state_48270__$1;
(statearr_48296_48352[(2)] = null);

(statearr_48296_48352[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48271 === (29))){
var inst_48244 = (state_48270[(11)]);
var state_48270__$1 = state_48270;
var statearr_48297_48353 = state_48270__$1;
(statearr_48297_48353[(2)] = inst_48244);

(statearr_48297_48353[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48271 === (6))){
var state_48270__$1 = state_48270;
var statearr_48298_48354 = state_48270__$1;
(statearr_48298_48354[(2)] = false);

(statearr_48298_48354[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48271 === (28))){
var inst_48240 = (state_48270[(2)]);
var inst_48241 = calc_state.call(null);
var inst_48197 = inst_48241;
var state_48270__$1 = (function (){var statearr_48299 = state_48270;
(statearr_48299[(15)] = inst_48240);

(statearr_48299[(7)] = inst_48197);

return statearr_48299;
})();
var statearr_48300_48355 = state_48270__$1;
(statearr_48300_48355[(2)] = null);

(statearr_48300_48355[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48271 === (25))){
var inst_48266 = (state_48270[(2)]);
var state_48270__$1 = state_48270;
var statearr_48301_48356 = state_48270__$1;
(statearr_48301_48356[(2)] = inst_48266);

(statearr_48301_48356[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48271 === (34))){
var inst_48264 = (state_48270[(2)]);
var state_48270__$1 = state_48270;
var statearr_48302_48357 = state_48270__$1;
(statearr_48302_48357[(2)] = inst_48264);

(statearr_48302_48357[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48271 === (17))){
var state_48270__$1 = state_48270;
var statearr_48303_48358 = state_48270__$1;
(statearr_48303_48358[(2)] = false);

(statearr_48303_48358[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48271 === (3))){
var state_48270__$1 = state_48270;
var statearr_48304_48359 = state_48270__$1;
(statearr_48304_48359[(2)] = false);

(statearr_48304_48359[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48271 === (12))){
var inst_48268 = (state_48270[(2)]);
var state_48270__$1 = state_48270;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48270__$1,inst_48268);
} else {
if((state_val_48271 === (2))){
var inst_48172 = (state_48270[(8)]);
var inst_48177 = inst_48172.cljs$lang$protocol_mask$partition0$;
var inst_48178 = (inst_48177 & (64));
var inst_48179 = inst_48172.cljs$core$ISeq$;
var inst_48180 = (cljs.core.PROTOCOL_SENTINEL === inst_48179);
var inst_48181 = (inst_48178) || (inst_48180);
var state_48270__$1 = state_48270;
if(cljs.core.truth_(inst_48181)){
var statearr_48305_48360 = state_48270__$1;
(statearr_48305_48360[(1)] = (5));

} else {
var statearr_48306_48361 = state_48270__$1;
(statearr_48306_48361[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48271 === (23))){
var inst_48229 = (state_48270[(14)]);
var inst_48235 = (inst_48229 == null);
var state_48270__$1 = state_48270;
if(cljs.core.truth_(inst_48235)){
var statearr_48307_48362 = state_48270__$1;
(statearr_48307_48362[(1)] = (26));

} else {
var statearr_48308_48363 = state_48270__$1;
(statearr_48308_48363[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48271 === (35))){
var inst_48255 = (state_48270[(2)]);
var state_48270__$1 = state_48270;
if(cljs.core.truth_(inst_48255)){
var statearr_48309_48364 = state_48270__$1;
(statearr_48309_48364[(1)] = (36));

} else {
var statearr_48310_48365 = state_48270__$1;
(statearr_48310_48365[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48271 === (19))){
var inst_48197 = (state_48270[(7)]);
var inst_48217 = cljs.core.apply.call(null,cljs.core.hash_map,inst_48197);
var state_48270__$1 = state_48270;
var statearr_48311_48366 = state_48270__$1;
(statearr_48311_48366[(2)] = inst_48217);

(statearr_48311_48366[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48271 === (11))){
var inst_48197 = (state_48270[(7)]);
var inst_48201 = (inst_48197 == null);
var inst_48202 = cljs.core.not.call(null,inst_48201);
var state_48270__$1 = state_48270;
if(inst_48202){
var statearr_48312_48367 = state_48270__$1;
(statearr_48312_48367[(1)] = (13));

} else {
var statearr_48313_48368 = state_48270__$1;
(statearr_48313_48368[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48271 === (9))){
var inst_48172 = (state_48270[(8)]);
var state_48270__$1 = state_48270;
var statearr_48314_48369 = state_48270__$1;
(statearr_48314_48369[(2)] = inst_48172);

(statearr_48314_48369[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48271 === (5))){
var state_48270__$1 = state_48270;
var statearr_48315_48370 = state_48270__$1;
(statearr_48315_48370[(2)] = true);

(statearr_48315_48370[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48271 === (14))){
var state_48270__$1 = state_48270;
var statearr_48316_48371 = state_48270__$1;
(statearr_48316_48371[(2)] = false);

(statearr_48316_48371[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48271 === (26))){
var inst_48230 = (state_48270[(9)]);
var inst_48237 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_48230);
var state_48270__$1 = state_48270;
var statearr_48317_48372 = state_48270__$1;
(statearr_48317_48372[(2)] = inst_48237);

(statearr_48317_48372[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48271 === (16))){
var state_48270__$1 = state_48270;
var statearr_48318_48373 = state_48270__$1;
(statearr_48318_48373[(2)] = true);

(statearr_48318_48373[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48271 === (38))){
var inst_48260 = (state_48270[(2)]);
var state_48270__$1 = state_48270;
var statearr_48319_48374 = state_48270__$1;
(statearr_48319_48374[(2)] = inst_48260);

(statearr_48319_48374[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48271 === (30))){
var inst_48230 = (state_48270[(9)]);
var inst_48221 = (state_48270[(10)]);
var inst_48222 = (state_48270[(13)]);
var inst_48247 = cljs.core.empty_QMARK_.call(null,inst_48221);
var inst_48248 = inst_48222.call(null,inst_48230);
var inst_48249 = cljs.core.not.call(null,inst_48248);
var inst_48250 = (inst_48247) && (inst_48249);
var state_48270__$1 = state_48270;
var statearr_48320_48375 = state_48270__$1;
(statearr_48320_48375[(2)] = inst_48250);

(statearr_48320_48375[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48271 === (10))){
var inst_48172 = (state_48270[(8)]);
var inst_48193 = (state_48270[(2)]);
var inst_48194 = cljs.core.get.call(null,inst_48193,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_48195 = cljs.core.get.call(null,inst_48193,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_48196 = cljs.core.get.call(null,inst_48193,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_48197 = inst_48172;
var state_48270__$1 = (function (){var statearr_48321 = state_48270;
(statearr_48321[(16)] = inst_48194);

(statearr_48321[(7)] = inst_48197);

(statearr_48321[(17)] = inst_48196);

(statearr_48321[(18)] = inst_48195);

return statearr_48321;
})();
var statearr_48322_48376 = state_48270__$1;
(statearr_48322_48376[(2)] = null);

(statearr_48322_48376[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48271 === (18))){
var inst_48212 = (state_48270[(2)]);
var state_48270__$1 = state_48270;
var statearr_48323_48377 = state_48270__$1;
(statearr_48323_48377[(2)] = inst_48212);

(statearr_48323_48377[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48271 === (37))){
var state_48270__$1 = state_48270;
var statearr_48324_48378 = state_48270__$1;
(statearr_48324_48378[(2)] = null);

(statearr_48324_48378[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48271 === (8))){
var inst_48172 = (state_48270[(8)]);
var inst_48190 = cljs.core.apply.call(null,cljs.core.hash_map,inst_48172);
var state_48270__$1 = state_48270;
var statearr_48325_48379 = state_48270__$1;
(statearr_48325_48379[(2)] = inst_48190);

(statearr_48325_48379[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46582__auto___48333,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__46468__auto__,c__46582__auto___48333,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__46469__auto__ = null;
var cljs$core$async$mix_$_state_machine__46469__auto____0 = (function (){
var statearr_48329 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48329[(0)] = cljs$core$async$mix_$_state_machine__46469__auto__);

(statearr_48329[(1)] = (1));

return statearr_48329;
});
var cljs$core$async$mix_$_state_machine__46469__auto____1 = (function (state_48270){
while(true){
var ret_value__46470__auto__ = (function (){try{while(true){
var result__46471__auto__ = switch__46468__auto__.call(null,state_48270);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46471__auto__;
}
break;
}
}catch (e48330){if((e48330 instanceof Object)){
var ex__46472__auto__ = e48330;
var statearr_48331_48380 = state_48270;
(statearr_48331_48380[(5)] = ex__46472__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48270);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48330;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48381 = state_48270;
state_48270 = G__48381;
continue;
} else {
return ret_value__46470__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__46469__auto__ = function(state_48270){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__46469__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__46469__auto____1.call(this,state_48270);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__46469__auto____0;
cljs$core$async$mix_$_state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__46469__auto____1;
return cljs$core$async$mix_$_state_machine__46469__auto__;
})()
;})(switch__46468__auto__,c__46582__auto___48333,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__46584__auto__ = (function (){var statearr_48332 = f__46583__auto__.call(null);
(statearr_48332[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46582__auto___48333);

return statearr_48332;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46584__auto__);
});})(c__46582__auto___48333,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__19870__auto__ = (((p == null))?null:p);
var m__19871__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__19870__auto__)]);
if(!((m__19871__auto__ == null))){
return m__19871__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__19871__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__19871__auto____$1 == null))){
return m__19871__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__19870__auto__ = (((p == null))?null:p);
var m__19871__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__19870__auto__)]);
if(!((m__19871__auto__ == null))){
return m__19871__auto__.call(null,p,v,ch);
} else {
var m__19871__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__19871__auto____$1 == null))){
return m__19871__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args48382 = [];
var len__20433__auto___48385 = arguments.length;
var i__20434__auto___48386 = (0);
while(true){
if((i__20434__auto___48386 < len__20433__auto___48385)){
args48382.push((arguments[i__20434__auto___48386]));

var G__48387 = (i__20434__auto___48386 + (1));
i__20434__auto___48386 = G__48387;
continue;
} else {
}
break;
}

var G__48384 = args48382.length;
switch (G__48384) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args48382.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__19870__auto__ = (((p == null))?null:p);
var m__19871__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__19870__auto__)]);
if(!((m__19871__auto__ == null))){
return m__19871__auto__.call(null,p);
} else {
var m__19871__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__19871__auto____$1 == null))){
return m__19871__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__19870__auto__ = (((p == null))?null:p);
var m__19871__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__19870__auto__)]);
if(!((m__19871__auto__ == null))){
return m__19871__auto__.call(null,p,v);
} else {
var m__19871__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__19871__auto____$1 == null))){
return m__19871__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args48390 = [];
var len__20433__auto___48515 = arguments.length;
var i__20434__auto___48516 = (0);
while(true){
if((i__20434__auto___48516 < len__20433__auto___48515)){
args48390.push((arguments[i__20434__auto___48516]));

var G__48517 = (i__20434__auto___48516 + (1));
i__20434__auto___48516 = G__48517;
continue;
} else {
}
break;
}

var G__48392 = args48390.length;
switch (G__48392) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args48390.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__19157__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__19157__auto__)){
return or__19157__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__19157__auto__,mults){
return (function (p1__48389_SHARP_){
if(cljs.core.truth_(p1__48389_SHARP_.call(null,topic))){
return p1__48389_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__48389_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__19157__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async48393 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48393 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta48394){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta48394 = meta48394;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async48393.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_48395,meta48394__$1){
var self__ = this;
var _48395__$1 = this;
return (new cljs.core.async.t_cljs$core$async48393(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta48394__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async48393.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_48395){
var self__ = this;
var _48395__$1 = this;
return self__.meta48394;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async48393.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48393.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async48393.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48393.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async48393.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__6753__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__6753__auto__)){
var m = temp__6753__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async48393.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async48393.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async48393.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta48394","meta48394",-547585823,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async48393.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async48393.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48393";

cljs.core.async.t_cljs$core$async48393.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__19809__auto__,writer__19810__auto__,opt__19811__auto__){
return cljs.core._write.call(null,writer__19810__auto__,"cljs.core.async/t_cljs$core$async48393");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async48393 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async48393(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta48394){
return (new cljs.core.async.t_cljs$core$async48393(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta48394));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async48393(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__46582__auto___48519 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46582__auto___48519,mults,ensure_mult,p){
return (function (){
var f__46583__auto__ = (function (){var switch__46468__auto__ = ((function (c__46582__auto___48519,mults,ensure_mult,p){
return (function (state_48467){
var state_val_48468 = (state_48467[(1)]);
if((state_val_48468 === (7))){
var inst_48463 = (state_48467[(2)]);
var state_48467__$1 = state_48467;
var statearr_48469_48520 = state_48467__$1;
(statearr_48469_48520[(2)] = inst_48463);

(statearr_48469_48520[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48468 === (20))){
var state_48467__$1 = state_48467;
var statearr_48470_48521 = state_48467__$1;
(statearr_48470_48521[(2)] = null);

(statearr_48470_48521[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48468 === (1))){
var state_48467__$1 = state_48467;
var statearr_48471_48522 = state_48467__$1;
(statearr_48471_48522[(2)] = null);

(statearr_48471_48522[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48468 === (24))){
var inst_48446 = (state_48467[(7)]);
var inst_48455 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_48446);
var state_48467__$1 = state_48467;
var statearr_48472_48523 = state_48467__$1;
(statearr_48472_48523[(2)] = inst_48455);

(statearr_48472_48523[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48468 === (4))){
var inst_48398 = (state_48467[(8)]);
var inst_48398__$1 = (state_48467[(2)]);
var inst_48399 = (inst_48398__$1 == null);
var state_48467__$1 = (function (){var statearr_48473 = state_48467;
(statearr_48473[(8)] = inst_48398__$1);

return statearr_48473;
})();
if(cljs.core.truth_(inst_48399)){
var statearr_48474_48524 = state_48467__$1;
(statearr_48474_48524[(1)] = (5));

} else {
var statearr_48475_48525 = state_48467__$1;
(statearr_48475_48525[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48468 === (15))){
var inst_48440 = (state_48467[(2)]);
var state_48467__$1 = state_48467;
var statearr_48476_48526 = state_48467__$1;
(statearr_48476_48526[(2)] = inst_48440);

(statearr_48476_48526[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48468 === (21))){
var inst_48460 = (state_48467[(2)]);
var state_48467__$1 = (function (){var statearr_48477 = state_48467;
(statearr_48477[(9)] = inst_48460);

return statearr_48477;
})();
var statearr_48478_48527 = state_48467__$1;
(statearr_48478_48527[(2)] = null);

(statearr_48478_48527[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48468 === (13))){
var inst_48422 = (state_48467[(10)]);
var inst_48424 = cljs.core.chunked_seq_QMARK_.call(null,inst_48422);
var state_48467__$1 = state_48467;
if(inst_48424){
var statearr_48479_48528 = state_48467__$1;
(statearr_48479_48528[(1)] = (16));

} else {
var statearr_48480_48529 = state_48467__$1;
(statearr_48480_48529[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48468 === (22))){
var inst_48452 = (state_48467[(2)]);
var state_48467__$1 = state_48467;
if(cljs.core.truth_(inst_48452)){
var statearr_48481_48530 = state_48467__$1;
(statearr_48481_48530[(1)] = (23));

} else {
var statearr_48482_48531 = state_48467__$1;
(statearr_48482_48531[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48468 === (6))){
var inst_48398 = (state_48467[(8)]);
var inst_48446 = (state_48467[(7)]);
var inst_48448 = (state_48467[(11)]);
var inst_48446__$1 = topic_fn.call(null,inst_48398);
var inst_48447 = cljs.core.deref.call(null,mults);
var inst_48448__$1 = cljs.core.get.call(null,inst_48447,inst_48446__$1);
var state_48467__$1 = (function (){var statearr_48483 = state_48467;
(statearr_48483[(7)] = inst_48446__$1);

(statearr_48483[(11)] = inst_48448__$1);

return statearr_48483;
})();
if(cljs.core.truth_(inst_48448__$1)){
var statearr_48484_48532 = state_48467__$1;
(statearr_48484_48532[(1)] = (19));

} else {
var statearr_48485_48533 = state_48467__$1;
(statearr_48485_48533[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48468 === (25))){
var inst_48457 = (state_48467[(2)]);
var state_48467__$1 = state_48467;
var statearr_48486_48534 = state_48467__$1;
(statearr_48486_48534[(2)] = inst_48457);

(statearr_48486_48534[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48468 === (17))){
var inst_48422 = (state_48467[(10)]);
var inst_48431 = cljs.core.first.call(null,inst_48422);
var inst_48432 = cljs.core.async.muxch_STAR_.call(null,inst_48431);
var inst_48433 = cljs.core.async.close_BANG_.call(null,inst_48432);
var inst_48434 = cljs.core.next.call(null,inst_48422);
var inst_48408 = inst_48434;
var inst_48409 = null;
var inst_48410 = (0);
var inst_48411 = (0);
var state_48467__$1 = (function (){var statearr_48487 = state_48467;
(statearr_48487[(12)] = inst_48410);

(statearr_48487[(13)] = inst_48408);

(statearr_48487[(14)] = inst_48411);

(statearr_48487[(15)] = inst_48433);

(statearr_48487[(16)] = inst_48409);

return statearr_48487;
})();
var statearr_48488_48535 = state_48467__$1;
(statearr_48488_48535[(2)] = null);

(statearr_48488_48535[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48468 === (3))){
var inst_48465 = (state_48467[(2)]);
var state_48467__$1 = state_48467;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48467__$1,inst_48465);
} else {
if((state_val_48468 === (12))){
var inst_48442 = (state_48467[(2)]);
var state_48467__$1 = state_48467;
var statearr_48489_48536 = state_48467__$1;
(statearr_48489_48536[(2)] = inst_48442);

(statearr_48489_48536[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48468 === (2))){
var state_48467__$1 = state_48467;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48467__$1,(4),ch);
} else {
if((state_val_48468 === (23))){
var state_48467__$1 = state_48467;
var statearr_48490_48537 = state_48467__$1;
(statearr_48490_48537[(2)] = null);

(statearr_48490_48537[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48468 === (19))){
var inst_48398 = (state_48467[(8)]);
var inst_48448 = (state_48467[(11)]);
var inst_48450 = cljs.core.async.muxch_STAR_.call(null,inst_48448);
var state_48467__$1 = state_48467;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48467__$1,(22),inst_48450,inst_48398);
} else {
if((state_val_48468 === (11))){
var inst_48422 = (state_48467[(10)]);
var inst_48408 = (state_48467[(13)]);
var inst_48422__$1 = cljs.core.seq.call(null,inst_48408);
var state_48467__$1 = (function (){var statearr_48491 = state_48467;
(statearr_48491[(10)] = inst_48422__$1);

return statearr_48491;
})();
if(inst_48422__$1){
var statearr_48492_48538 = state_48467__$1;
(statearr_48492_48538[(1)] = (13));

} else {
var statearr_48493_48539 = state_48467__$1;
(statearr_48493_48539[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48468 === (9))){
var inst_48444 = (state_48467[(2)]);
var state_48467__$1 = state_48467;
var statearr_48494_48540 = state_48467__$1;
(statearr_48494_48540[(2)] = inst_48444);

(statearr_48494_48540[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48468 === (5))){
var inst_48405 = cljs.core.deref.call(null,mults);
var inst_48406 = cljs.core.vals.call(null,inst_48405);
var inst_48407 = cljs.core.seq.call(null,inst_48406);
var inst_48408 = inst_48407;
var inst_48409 = null;
var inst_48410 = (0);
var inst_48411 = (0);
var state_48467__$1 = (function (){var statearr_48495 = state_48467;
(statearr_48495[(12)] = inst_48410);

(statearr_48495[(13)] = inst_48408);

(statearr_48495[(14)] = inst_48411);

(statearr_48495[(16)] = inst_48409);

return statearr_48495;
})();
var statearr_48496_48541 = state_48467__$1;
(statearr_48496_48541[(2)] = null);

(statearr_48496_48541[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48468 === (14))){
var state_48467__$1 = state_48467;
var statearr_48500_48542 = state_48467__$1;
(statearr_48500_48542[(2)] = null);

(statearr_48500_48542[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48468 === (16))){
var inst_48422 = (state_48467[(10)]);
var inst_48426 = cljs.core.chunk_first.call(null,inst_48422);
var inst_48427 = cljs.core.chunk_rest.call(null,inst_48422);
var inst_48428 = cljs.core.count.call(null,inst_48426);
var inst_48408 = inst_48427;
var inst_48409 = inst_48426;
var inst_48410 = inst_48428;
var inst_48411 = (0);
var state_48467__$1 = (function (){var statearr_48501 = state_48467;
(statearr_48501[(12)] = inst_48410);

(statearr_48501[(13)] = inst_48408);

(statearr_48501[(14)] = inst_48411);

(statearr_48501[(16)] = inst_48409);

return statearr_48501;
})();
var statearr_48502_48543 = state_48467__$1;
(statearr_48502_48543[(2)] = null);

(statearr_48502_48543[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48468 === (10))){
var inst_48410 = (state_48467[(12)]);
var inst_48408 = (state_48467[(13)]);
var inst_48411 = (state_48467[(14)]);
var inst_48409 = (state_48467[(16)]);
var inst_48416 = cljs.core._nth.call(null,inst_48409,inst_48411);
var inst_48417 = cljs.core.async.muxch_STAR_.call(null,inst_48416);
var inst_48418 = cljs.core.async.close_BANG_.call(null,inst_48417);
var inst_48419 = (inst_48411 + (1));
var tmp48497 = inst_48410;
var tmp48498 = inst_48408;
var tmp48499 = inst_48409;
var inst_48408__$1 = tmp48498;
var inst_48409__$1 = tmp48499;
var inst_48410__$1 = tmp48497;
var inst_48411__$1 = inst_48419;
var state_48467__$1 = (function (){var statearr_48503 = state_48467;
(statearr_48503[(12)] = inst_48410__$1);

(statearr_48503[(13)] = inst_48408__$1);

(statearr_48503[(14)] = inst_48411__$1);

(statearr_48503[(17)] = inst_48418);

(statearr_48503[(16)] = inst_48409__$1);

return statearr_48503;
})();
var statearr_48504_48544 = state_48467__$1;
(statearr_48504_48544[(2)] = null);

(statearr_48504_48544[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48468 === (18))){
var inst_48437 = (state_48467[(2)]);
var state_48467__$1 = state_48467;
var statearr_48505_48545 = state_48467__$1;
(statearr_48505_48545[(2)] = inst_48437);

(statearr_48505_48545[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48468 === (8))){
var inst_48410 = (state_48467[(12)]);
var inst_48411 = (state_48467[(14)]);
var inst_48413 = (inst_48411 < inst_48410);
var inst_48414 = inst_48413;
var state_48467__$1 = state_48467;
if(cljs.core.truth_(inst_48414)){
var statearr_48506_48546 = state_48467__$1;
(statearr_48506_48546[(1)] = (10));

} else {
var statearr_48507_48547 = state_48467__$1;
(statearr_48507_48547[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46582__auto___48519,mults,ensure_mult,p))
;
return ((function (switch__46468__auto__,c__46582__auto___48519,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__46469__auto__ = null;
var cljs$core$async$state_machine__46469__auto____0 = (function (){
var statearr_48511 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48511[(0)] = cljs$core$async$state_machine__46469__auto__);

(statearr_48511[(1)] = (1));

return statearr_48511;
});
var cljs$core$async$state_machine__46469__auto____1 = (function (state_48467){
while(true){
var ret_value__46470__auto__ = (function (){try{while(true){
var result__46471__auto__ = switch__46468__auto__.call(null,state_48467);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46471__auto__;
}
break;
}
}catch (e48512){if((e48512 instanceof Object)){
var ex__46472__auto__ = e48512;
var statearr_48513_48548 = state_48467;
(statearr_48513_48548[(5)] = ex__46472__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48467);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48512;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48549 = state_48467;
state_48467 = G__48549;
continue;
} else {
return ret_value__46470__auto__;
}
break;
}
});
cljs$core$async$state_machine__46469__auto__ = function(state_48467){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46469__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46469__auto____1.call(this,state_48467);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46469__auto____0;
cljs$core$async$state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46469__auto____1;
return cljs$core$async$state_machine__46469__auto__;
})()
;})(switch__46468__auto__,c__46582__auto___48519,mults,ensure_mult,p))
})();
var state__46584__auto__ = (function (){var statearr_48514 = f__46583__auto__.call(null);
(statearr_48514[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46582__auto___48519);

return statearr_48514;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46584__auto__);
});})(c__46582__auto___48519,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args48550 = [];
var len__20433__auto___48553 = arguments.length;
var i__20434__auto___48554 = (0);
while(true){
if((i__20434__auto___48554 < len__20433__auto___48553)){
args48550.push((arguments[i__20434__auto___48554]));

var G__48555 = (i__20434__auto___48554 + (1));
i__20434__auto___48554 = G__48555;
continue;
} else {
}
break;
}

var G__48552 = args48550.length;
switch (G__48552) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args48550.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args48557 = [];
var len__20433__auto___48560 = arguments.length;
var i__20434__auto___48561 = (0);
while(true){
if((i__20434__auto___48561 < len__20433__auto___48560)){
args48557.push((arguments[i__20434__auto___48561]));

var G__48562 = (i__20434__auto___48561 + (1));
i__20434__auto___48561 = G__48562;
continue;
} else {
}
break;
}

var G__48559 = args48557.length;
switch (G__48559) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args48557.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args48564 = [];
var len__20433__auto___48635 = arguments.length;
var i__20434__auto___48636 = (0);
while(true){
if((i__20434__auto___48636 < len__20433__auto___48635)){
args48564.push((arguments[i__20434__auto___48636]));

var G__48637 = (i__20434__auto___48636 + (1));
i__20434__auto___48636 = G__48637;
continue;
} else {
}
break;
}

var G__48566 = args48564.length;
switch (G__48566) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args48564.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__46582__auto___48639 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46582__auto___48639,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__46583__auto__ = (function (){var switch__46468__auto__ = ((function (c__46582__auto___48639,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_48605){
var state_val_48606 = (state_48605[(1)]);
if((state_val_48606 === (7))){
var state_48605__$1 = state_48605;
var statearr_48607_48640 = state_48605__$1;
(statearr_48607_48640[(2)] = null);

(statearr_48607_48640[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48606 === (1))){
var state_48605__$1 = state_48605;
var statearr_48608_48641 = state_48605__$1;
(statearr_48608_48641[(2)] = null);

(statearr_48608_48641[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48606 === (4))){
var inst_48569 = (state_48605[(7)]);
var inst_48571 = (inst_48569 < cnt);
var state_48605__$1 = state_48605;
if(cljs.core.truth_(inst_48571)){
var statearr_48609_48642 = state_48605__$1;
(statearr_48609_48642[(1)] = (6));

} else {
var statearr_48610_48643 = state_48605__$1;
(statearr_48610_48643[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48606 === (15))){
var inst_48601 = (state_48605[(2)]);
var state_48605__$1 = state_48605;
var statearr_48611_48644 = state_48605__$1;
(statearr_48611_48644[(2)] = inst_48601);

(statearr_48611_48644[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48606 === (13))){
var inst_48594 = cljs.core.async.close_BANG_.call(null,out);
var state_48605__$1 = state_48605;
var statearr_48612_48645 = state_48605__$1;
(statearr_48612_48645[(2)] = inst_48594);

(statearr_48612_48645[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48606 === (6))){
var state_48605__$1 = state_48605;
var statearr_48613_48646 = state_48605__$1;
(statearr_48613_48646[(2)] = null);

(statearr_48613_48646[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48606 === (3))){
var inst_48603 = (state_48605[(2)]);
var state_48605__$1 = state_48605;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48605__$1,inst_48603);
} else {
if((state_val_48606 === (12))){
var inst_48591 = (state_48605[(8)]);
var inst_48591__$1 = (state_48605[(2)]);
var inst_48592 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_48591__$1);
var state_48605__$1 = (function (){var statearr_48614 = state_48605;
(statearr_48614[(8)] = inst_48591__$1);

return statearr_48614;
})();
if(cljs.core.truth_(inst_48592)){
var statearr_48615_48647 = state_48605__$1;
(statearr_48615_48647[(1)] = (13));

} else {
var statearr_48616_48648 = state_48605__$1;
(statearr_48616_48648[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48606 === (2))){
var inst_48568 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_48569 = (0);
var state_48605__$1 = (function (){var statearr_48617 = state_48605;
(statearr_48617[(7)] = inst_48569);

(statearr_48617[(9)] = inst_48568);

return statearr_48617;
})();
var statearr_48618_48649 = state_48605__$1;
(statearr_48618_48649[(2)] = null);

(statearr_48618_48649[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48606 === (11))){
var inst_48569 = (state_48605[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_48605,(10),Object,null,(9));
var inst_48578 = chs__$1.call(null,inst_48569);
var inst_48579 = done.call(null,inst_48569);
var inst_48580 = cljs.core.async.take_BANG_.call(null,inst_48578,inst_48579);
var state_48605__$1 = state_48605;
var statearr_48619_48650 = state_48605__$1;
(statearr_48619_48650[(2)] = inst_48580);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48605__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48606 === (9))){
var inst_48569 = (state_48605[(7)]);
var inst_48582 = (state_48605[(2)]);
var inst_48583 = (inst_48569 + (1));
var inst_48569__$1 = inst_48583;
var state_48605__$1 = (function (){var statearr_48620 = state_48605;
(statearr_48620[(7)] = inst_48569__$1);

(statearr_48620[(10)] = inst_48582);

return statearr_48620;
})();
var statearr_48621_48651 = state_48605__$1;
(statearr_48621_48651[(2)] = null);

(statearr_48621_48651[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48606 === (5))){
var inst_48589 = (state_48605[(2)]);
var state_48605__$1 = (function (){var statearr_48622 = state_48605;
(statearr_48622[(11)] = inst_48589);

return statearr_48622;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48605__$1,(12),dchan);
} else {
if((state_val_48606 === (14))){
var inst_48591 = (state_48605[(8)]);
var inst_48596 = cljs.core.apply.call(null,f,inst_48591);
var state_48605__$1 = state_48605;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48605__$1,(16),out,inst_48596);
} else {
if((state_val_48606 === (16))){
var inst_48598 = (state_48605[(2)]);
var state_48605__$1 = (function (){var statearr_48623 = state_48605;
(statearr_48623[(12)] = inst_48598);

return statearr_48623;
})();
var statearr_48624_48652 = state_48605__$1;
(statearr_48624_48652[(2)] = null);

(statearr_48624_48652[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48606 === (10))){
var inst_48573 = (state_48605[(2)]);
var inst_48574 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_48605__$1 = (function (){var statearr_48625 = state_48605;
(statearr_48625[(13)] = inst_48573);

return statearr_48625;
})();
var statearr_48626_48653 = state_48605__$1;
(statearr_48626_48653[(2)] = inst_48574);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48605__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48606 === (8))){
var inst_48587 = (state_48605[(2)]);
var state_48605__$1 = state_48605;
var statearr_48627_48654 = state_48605__$1;
(statearr_48627_48654[(2)] = inst_48587);

(statearr_48627_48654[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46582__auto___48639,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__46468__auto__,c__46582__auto___48639,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__46469__auto__ = null;
var cljs$core$async$state_machine__46469__auto____0 = (function (){
var statearr_48631 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48631[(0)] = cljs$core$async$state_machine__46469__auto__);

(statearr_48631[(1)] = (1));

return statearr_48631;
});
var cljs$core$async$state_machine__46469__auto____1 = (function (state_48605){
while(true){
var ret_value__46470__auto__ = (function (){try{while(true){
var result__46471__auto__ = switch__46468__auto__.call(null,state_48605);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46471__auto__;
}
break;
}
}catch (e48632){if((e48632 instanceof Object)){
var ex__46472__auto__ = e48632;
var statearr_48633_48655 = state_48605;
(statearr_48633_48655[(5)] = ex__46472__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48605);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48632;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48656 = state_48605;
state_48605 = G__48656;
continue;
} else {
return ret_value__46470__auto__;
}
break;
}
});
cljs$core$async$state_machine__46469__auto__ = function(state_48605){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46469__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46469__auto____1.call(this,state_48605);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46469__auto____0;
cljs$core$async$state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46469__auto____1;
return cljs$core$async$state_machine__46469__auto__;
})()
;})(switch__46468__auto__,c__46582__auto___48639,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__46584__auto__ = (function (){var statearr_48634 = f__46583__auto__.call(null);
(statearr_48634[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46582__auto___48639);

return statearr_48634;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46584__auto__);
});})(c__46582__auto___48639,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args48658 = [];
var len__20433__auto___48716 = arguments.length;
var i__20434__auto___48717 = (0);
while(true){
if((i__20434__auto___48717 < len__20433__auto___48716)){
args48658.push((arguments[i__20434__auto___48717]));

var G__48718 = (i__20434__auto___48717 + (1));
i__20434__auto___48717 = G__48718;
continue;
} else {
}
break;
}

var G__48660 = args48658.length;
switch (G__48660) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args48658.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__46582__auto___48720 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46582__auto___48720,out){
return (function (){
var f__46583__auto__ = (function (){var switch__46468__auto__ = ((function (c__46582__auto___48720,out){
return (function (state_48692){
var state_val_48693 = (state_48692[(1)]);
if((state_val_48693 === (7))){
var inst_48672 = (state_48692[(7)]);
var inst_48671 = (state_48692[(8)]);
var inst_48671__$1 = (state_48692[(2)]);
var inst_48672__$1 = cljs.core.nth.call(null,inst_48671__$1,(0),null);
var inst_48673 = cljs.core.nth.call(null,inst_48671__$1,(1),null);
var inst_48674 = (inst_48672__$1 == null);
var state_48692__$1 = (function (){var statearr_48694 = state_48692;
(statearr_48694[(9)] = inst_48673);

(statearr_48694[(7)] = inst_48672__$1);

(statearr_48694[(8)] = inst_48671__$1);

return statearr_48694;
})();
if(cljs.core.truth_(inst_48674)){
var statearr_48695_48721 = state_48692__$1;
(statearr_48695_48721[(1)] = (8));

} else {
var statearr_48696_48722 = state_48692__$1;
(statearr_48696_48722[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48693 === (1))){
var inst_48661 = cljs.core.vec.call(null,chs);
var inst_48662 = inst_48661;
var state_48692__$1 = (function (){var statearr_48697 = state_48692;
(statearr_48697[(10)] = inst_48662);

return statearr_48697;
})();
var statearr_48698_48723 = state_48692__$1;
(statearr_48698_48723[(2)] = null);

(statearr_48698_48723[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48693 === (4))){
var inst_48662 = (state_48692[(10)]);
var state_48692__$1 = state_48692;
return cljs.core.async.ioc_alts_BANG_.call(null,state_48692__$1,(7),inst_48662);
} else {
if((state_val_48693 === (6))){
var inst_48688 = (state_48692[(2)]);
var state_48692__$1 = state_48692;
var statearr_48699_48724 = state_48692__$1;
(statearr_48699_48724[(2)] = inst_48688);

(statearr_48699_48724[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48693 === (3))){
var inst_48690 = (state_48692[(2)]);
var state_48692__$1 = state_48692;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48692__$1,inst_48690);
} else {
if((state_val_48693 === (2))){
var inst_48662 = (state_48692[(10)]);
var inst_48664 = cljs.core.count.call(null,inst_48662);
var inst_48665 = (inst_48664 > (0));
var state_48692__$1 = state_48692;
if(cljs.core.truth_(inst_48665)){
var statearr_48701_48725 = state_48692__$1;
(statearr_48701_48725[(1)] = (4));

} else {
var statearr_48702_48726 = state_48692__$1;
(statearr_48702_48726[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48693 === (11))){
var inst_48662 = (state_48692[(10)]);
var inst_48681 = (state_48692[(2)]);
var tmp48700 = inst_48662;
var inst_48662__$1 = tmp48700;
var state_48692__$1 = (function (){var statearr_48703 = state_48692;
(statearr_48703[(11)] = inst_48681);

(statearr_48703[(10)] = inst_48662__$1);

return statearr_48703;
})();
var statearr_48704_48727 = state_48692__$1;
(statearr_48704_48727[(2)] = null);

(statearr_48704_48727[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48693 === (9))){
var inst_48672 = (state_48692[(7)]);
var state_48692__$1 = state_48692;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48692__$1,(11),out,inst_48672);
} else {
if((state_val_48693 === (5))){
var inst_48686 = cljs.core.async.close_BANG_.call(null,out);
var state_48692__$1 = state_48692;
var statearr_48705_48728 = state_48692__$1;
(statearr_48705_48728[(2)] = inst_48686);

(statearr_48705_48728[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48693 === (10))){
var inst_48684 = (state_48692[(2)]);
var state_48692__$1 = state_48692;
var statearr_48706_48729 = state_48692__$1;
(statearr_48706_48729[(2)] = inst_48684);

(statearr_48706_48729[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48693 === (8))){
var inst_48673 = (state_48692[(9)]);
var inst_48662 = (state_48692[(10)]);
var inst_48672 = (state_48692[(7)]);
var inst_48671 = (state_48692[(8)]);
var inst_48676 = (function (){var cs = inst_48662;
var vec__48667 = inst_48671;
var v = inst_48672;
var c = inst_48673;
return ((function (cs,vec__48667,v,c,inst_48673,inst_48662,inst_48672,inst_48671,state_val_48693,c__46582__auto___48720,out){
return (function (p1__48657_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__48657_SHARP_);
});
;})(cs,vec__48667,v,c,inst_48673,inst_48662,inst_48672,inst_48671,state_val_48693,c__46582__auto___48720,out))
})();
var inst_48677 = cljs.core.filterv.call(null,inst_48676,inst_48662);
var inst_48662__$1 = inst_48677;
var state_48692__$1 = (function (){var statearr_48707 = state_48692;
(statearr_48707[(10)] = inst_48662__$1);

return statearr_48707;
})();
var statearr_48708_48730 = state_48692__$1;
(statearr_48708_48730[(2)] = null);

(statearr_48708_48730[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__46582__auto___48720,out))
;
return ((function (switch__46468__auto__,c__46582__auto___48720,out){
return (function() {
var cljs$core$async$state_machine__46469__auto__ = null;
var cljs$core$async$state_machine__46469__auto____0 = (function (){
var statearr_48712 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48712[(0)] = cljs$core$async$state_machine__46469__auto__);

(statearr_48712[(1)] = (1));

return statearr_48712;
});
var cljs$core$async$state_machine__46469__auto____1 = (function (state_48692){
while(true){
var ret_value__46470__auto__ = (function (){try{while(true){
var result__46471__auto__ = switch__46468__auto__.call(null,state_48692);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46471__auto__;
}
break;
}
}catch (e48713){if((e48713 instanceof Object)){
var ex__46472__auto__ = e48713;
var statearr_48714_48731 = state_48692;
(statearr_48714_48731[(5)] = ex__46472__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48692);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48713;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48732 = state_48692;
state_48692 = G__48732;
continue;
} else {
return ret_value__46470__auto__;
}
break;
}
});
cljs$core$async$state_machine__46469__auto__ = function(state_48692){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46469__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46469__auto____1.call(this,state_48692);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46469__auto____0;
cljs$core$async$state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46469__auto____1;
return cljs$core$async$state_machine__46469__auto__;
})()
;})(switch__46468__auto__,c__46582__auto___48720,out))
})();
var state__46584__auto__ = (function (){var statearr_48715 = f__46583__auto__.call(null);
(statearr_48715[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46582__auto___48720);

return statearr_48715;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46584__auto__);
});})(c__46582__auto___48720,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args48733 = [];
var len__20433__auto___48782 = arguments.length;
var i__20434__auto___48783 = (0);
while(true){
if((i__20434__auto___48783 < len__20433__auto___48782)){
args48733.push((arguments[i__20434__auto___48783]));

var G__48784 = (i__20434__auto___48783 + (1));
i__20434__auto___48783 = G__48784;
continue;
} else {
}
break;
}

var G__48735 = args48733.length;
switch (G__48735) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args48733.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__46582__auto___48786 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46582__auto___48786,out){
return (function (){
var f__46583__auto__ = (function (){var switch__46468__auto__ = ((function (c__46582__auto___48786,out){
return (function (state_48759){
var state_val_48760 = (state_48759[(1)]);
if((state_val_48760 === (7))){
var inst_48741 = (state_48759[(7)]);
var inst_48741__$1 = (state_48759[(2)]);
var inst_48742 = (inst_48741__$1 == null);
var inst_48743 = cljs.core.not.call(null,inst_48742);
var state_48759__$1 = (function (){var statearr_48761 = state_48759;
(statearr_48761[(7)] = inst_48741__$1);

return statearr_48761;
})();
if(inst_48743){
var statearr_48762_48787 = state_48759__$1;
(statearr_48762_48787[(1)] = (8));

} else {
var statearr_48763_48788 = state_48759__$1;
(statearr_48763_48788[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48760 === (1))){
var inst_48736 = (0);
var state_48759__$1 = (function (){var statearr_48764 = state_48759;
(statearr_48764[(8)] = inst_48736);

return statearr_48764;
})();
var statearr_48765_48789 = state_48759__$1;
(statearr_48765_48789[(2)] = null);

(statearr_48765_48789[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48760 === (4))){
var state_48759__$1 = state_48759;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48759__$1,(7),ch);
} else {
if((state_val_48760 === (6))){
var inst_48754 = (state_48759[(2)]);
var state_48759__$1 = state_48759;
var statearr_48766_48790 = state_48759__$1;
(statearr_48766_48790[(2)] = inst_48754);

(statearr_48766_48790[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48760 === (3))){
var inst_48756 = (state_48759[(2)]);
var inst_48757 = cljs.core.async.close_BANG_.call(null,out);
var state_48759__$1 = (function (){var statearr_48767 = state_48759;
(statearr_48767[(9)] = inst_48756);

return statearr_48767;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48759__$1,inst_48757);
} else {
if((state_val_48760 === (2))){
var inst_48736 = (state_48759[(8)]);
var inst_48738 = (inst_48736 < n);
var state_48759__$1 = state_48759;
if(cljs.core.truth_(inst_48738)){
var statearr_48768_48791 = state_48759__$1;
(statearr_48768_48791[(1)] = (4));

} else {
var statearr_48769_48792 = state_48759__$1;
(statearr_48769_48792[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48760 === (11))){
var inst_48736 = (state_48759[(8)]);
var inst_48746 = (state_48759[(2)]);
var inst_48747 = (inst_48736 + (1));
var inst_48736__$1 = inst_48747;
var state_48759__$1 = (function (){var statearr_48770 = state_48759;
(statearr_48770[(8)] = inst_48736__$1);

(statearr_48770[(10)] = inst_48746);

return statearr_48770;
})();
var statearr_48771_48793 = state_48759__$1;
(statearr_48771_48793[(2)] = null);

(statearr_48771_48793[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48760 === (9))){
var state_48759__$1 = state_48759;
var statearr_48772_48794 = state_48759__$1;
(statearr_48772_48794[(2)] = null);

(statearr_48772_48794[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48760 === (5))){
var state_48759__$1 = state_48759;
var statearr_48773_48795 = state_48759__$1;
(statearr_48773_48795[(2)] = null);

(statearr_48773_48795[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48760 === (10))){
var inst_48751 = (state_48759[(2)]);
var state_48759__$1 = state_48759;
var statearr_48774_48796 = state_48759__$1;
(statearr_48774_48796[(2)] = inst_48751);

(statearr_48774_48796[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48760 === (8))){
var inst_48741 = (state_48759[(7)]);
var state_48759__$1 = state_48759;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48759__$1,(11),out,inst_48741);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__46582__auto___48786,out))
;
return ((function (switch__46468__auto__,c__46582__auto___48786,out){
return (function() {
var cljs$core$async$state_machine__46469__auto__ = null;
var cljs$core$async$state_machine__46469__auto____0 = (function (){
var statearr_48778 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_48778[(0)] = cljs$core$async$state_machine__46469__auto__);

(statearr_48778[(1)] = (1));

return statearr_48778;
});
var cljs$core$async$state_machine__46469__auto____1 = (function (state_48759){
while(true){
var ret_value__46470__auto__ = (function (){try{while(true){
var result__46471__auto__ = switch__46468__auto__.call(null,state_48759);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46471__auto__;
}
break;
}
}catch (e48779){if((e48779 instanceof Object)){
var ex__46472__auto__ = e48779;
var statearr_48780_48797 = state_48759;
(statearr_48780_48797[(5)] = ex__46472__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48759);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48779;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48798 = state_48759;
state_48759 = G__48798;
continue;
} else {
return ret_value__46470__auto__;
}
break;
}
});
cljs$core$async$state_machine__46469__auto__ = function(state_48759){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46469__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46469__auto____1.call(this,state_48759);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46469__auto____0;
cljs$core$async$state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46469__auto____1;
return cljs$core$async$state_machine__46469__auto__;
})()
;})(switch__46468__auto__,c__46582__auto___48786,out))
})();
var state__46584__auto__ = (function (){var statearr_48781 = f__46583__auto__.call(null);
(statearr_48781[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46582__auto___48786);

return statearr_48781;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46584__auto__);
});})(c__46582__auto___48786,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async48806 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48806 = (function (f,ch,meta48807){
this.f = f;
this.ch = ch;
this.meta48807 = meta48807;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async48806.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48808,meta48807__$1){
var self__ = this;
var _48808__$1 = this;
return (new cljs.core.async.t_cljs$core$async48806(self__.f,self__.ch,meta48807__$1));
});

cljs.core.async.t_cljs$core$async48806.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48808){
var self__ = this;
var _48808__$1 = this;
return self__.meta48807;
});

cljs.core.async.t_cljs$core$async48806.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48806.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async48806.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async48806.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48806.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async48809 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48809 = (function (f,ch,meta48807,_,fn1,meta48810){
this.f = f;
this.ch = ch;
this.meta48807 = meta48807;
this._ = _;
this.fn1 = fn1;
this.meta48810 = meta48810;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async48809.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_48811,meta48810__$1){
var self__ = this;
var _48811__$1 = this;
return (new cljs.core.async.t_cljs$core$async48809(self__.f,self__.ch,self__.meta48807,self__._,self__.fn1,meta48810__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async48809.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_48811){
var self__ = this;
var _48811__$1 = this;
return self__.meta48810;
});})(___$1))
;

cljs.core.async.t_cljs$core$async48809.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48809.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async48809.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async48809.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__48799_SHARP_){
return f1.call(null,(((p1__48799_SHARP_ == null))?null:self__.f.call(null,p1__48799_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async48809.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48807","meta48807",869727702,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async48806","cljs.core.async/t_cljs$core$async48806",252787351,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta48810","meta48810",488313573,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async48809.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async48809.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48809";

cljs.core.async.t_cljs$core$async48809.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__19809__auto__,writer__19810__auto__,opt__19811__auto__){
return cljs.core._write.call(null,writer__19810__auto__,"cljs.core.async/t_cljs$core$async48809");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async48809 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async48809(f__$1,ch__$1,meta48807__$1,___$2,fn1__$1,meta48810){
return (new cljs.core.async.t_cljs$core$async48809(f__$1,ch__$1,meta48807__$1,___$2,fn1__$1,meta48810));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async48809(self__.f,self__.ch,self__.meta48807,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__19145__auto__ = ret;
if(cljs.core.truth_(and__19145__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__19145__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async48806.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48806.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async48806.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48807","meta48807",869727702,null)], null);
});

cljs.core.async.t_cljs$core$async48806.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async48806.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48806";

cljs.core.async.t_cljs$core$async48806.cljs$lang$ctorPrWriter = (function (this__19809__auto__,writer__19810__auto__,opt__19811__auto__){
return cljs.core._write.call(null,writer__19810__auto__,"cljs.core.async/t_cljs$core$async48806");
});

cljs.core.async.__GT_t_cljs$core$async48806 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async48806(f__$1,ch__$1,meta48807){
return (new cljs.core.async.t_cljs$core$async48806(f__$1,ch__$1,meta48807));
});

}

return (new cljs.core.async.t_cljs$core$async48806(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async48815 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48815 = (function (f,ch,meta48816){
this.f = f;
this.ch = ch;
this.meta48816 = meta48816;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async48815.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48817,meta48816__$1){
var self__ = this;
var _48817__$1 = this;
return (new cljs.core.async.t_cljs$core$async48815(self__.f,self__.ch,meta48816__$1));
});

cljs.core.async.t_cljs$core$async48815.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48817){
var self__ = this;
var _48817__$1 = this;
return self__.meta48816;
});

cljs.core.async.t_cljs$core$async48815.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48815.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async48815.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48815.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async48815.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48815.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async48815.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48816","meta48816",371203010,null)], null);
});

cljs.core.async.t_cljs$core$async48815.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async48815.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48815";

cljs.core.async.t_cljs$core$async48815.cljs$lang$ctorPrWriter = (function (this__19809__auto__,writer__19810__auto__,opt__19811__auto__){
return cljs.core._write.call(null,writer__19810__auto__,"cljs.core.async/t_cljs$core$async48815");
});

cljs.core.async.__GT_t_cljs$core$async48815 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async48815(f__$1,ch__$1,meta48816){
return (new cljs.core.async.t_cljs$core$async48815(f__$1,ch__$1,meta48816));
});

}

return (new cljs.core.async.t_cljs$core$async48815(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async48821 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48821 = (function (p,ch,meta48822){
this.p = p;
this.ch = ch;
this.meta48822 = meta48822;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async48821.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48823,meta48822__$1){
var self__ = this;
var _48823__$1 = this;
return (new cljs.core.async.t_cljs$core$async48821(self__.p,self__.ch,meta48822__$1));
});

cljs.core.async.t_cljs$core$async48821.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48823){
var self__ = this;
var _48823__$1 = this;
return self__.meta48822;
});

cljs.core.async.t_cljs$core$async48821.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48821.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async48821.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async48821.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48821.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async48821.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48821.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async48821.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48822","meta48822",-1343038226,null)], null);
});

cljs.core.async.t_cljs$core$async48821.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async48821.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48821";

cljs.core.async.t_cljs$core$async48821.cljs$lang$ctorPrWriter = (function (this__19809__auto__,writer__19810__auto__,opt__19811__auto__){
return cljs.core._write.call(null,writer__19810__auto__,"cljs.core.async/t_cljs$core$async48821");
});

cljs.core.async.__GT_t_cljs$core$async48821 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async48821(p__$1,ch__$1,meta48822){
return (new cljs.core.async.t_cljs$core$async48821(p__$1,ch__$1,meta48822));
});

}

return (new cljs.core.async.t_cljs$core$async48821(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args48824 = [];
var len__20433__auto___48868 = arguments.length;
var i__20434__auto___48869 = (0);
while(true){
if((i__20434__auto___48869 < len__20433__auto___48868)){
args48824.push((arguments[i__20434__auto___48869]));

var G__48870 = (i__20434__auto___48869 + (1));
i__20434__auto___48869 = G__48870;
continue;
} else {
}
break;
}

var G__48826 = args48824.length;
switch (G__48826) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args48824.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__46582__auto___48872 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46582__auto___48872,out){
return (function (){
var f__46583__auto__ = (function (){var switch__46468__auto__ = ((function (c__46582__auto___48872,out){
return (function (state_48847){
var state_val_48848 = (state_48847[(1)]);
if((state_val_48848 === (7))){
var inst_48843 = (state_48847[(2)]);
var state_48847__$1 = state_48847;
var statearr_48849_48873 = state_48847__$1;
(statearr_48849_48873[(2)] = inst_48843);

(statearr_48849_48873[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48848 === (1))){
var state_48847__$1 = state_48847;
var statearr_48850_48874 = state_48847__$1;
(statearr_48850_48874[(2)] = null);

(statearr_48850_48874[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48848 === (4))){
var inst_48829 = (state_48847[(7)]);
var inst_48829__$1 = (state_48847[(2)]);
var inst_48830 = (inst_48829__$1 == null);
var state_48847__$1 = (function (){var statearr_48851 = state_48847;
(statearr_48851[(7)] = inst_48829__$1);

return statearr_48851;
})();
if(cljs.core.truth_(inst_48830)){
var statearr_48852_48875 = state_48847__$1;
(statearr_48852_48875[(1)] = (5));

} else {
var statearr_48853_48876 = state_48847__$1;
(statearr_48853_48876[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48848 === (6))){
var inst_48829 = (state_48847[(7)]);
var inst_48834 = p.call(null,inst_48829);
var state_48847__$1 = state_48847;
if(cljs.core.truth_(inst_48834)){
var statearr_48854_48877 = state_48847__$1;
(statearr_48854_48877[(1)] = (8));

} else {
var statearr_48855_48878 = state_48847__$1;
(statearr_48855_48878[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48848 === (3))){
var inst_48845 = (state_48847[(2)]);
var state_48847__$1 = state_48847;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48847__$1,inst_48845);
} else {
if((state_val_48848 === (2))){
var state_48847__$1 = state_48847;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48847__$1,(4),ch);
} else {
if((state_val_48848 === (11))){
var inst_48837 = (state_48847[(2)]);
var state_48847__$1 = state_48847;
var statearr_48856_48879 = state_48847__$1;
(statearr_48856_48879[(2)] = inst_48837);

(statearr_48856_48879[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48848 === (9))){
var state_48847__$1 = state_48847;
var statearr_48857_48880 = state_48847__$1;
(statearr_48857_48880[(2)] = null);

(statearr_48857_48880[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48848 === (5))){
var inst_48832 = cljs.core.async.close_BANG_.call(null,out);
var state_48847__$1 = state_48847;
var statearr_48858_48881 = state_48847__$1;
(statearr_48858_48881[(2)] = inst_48832);

(statearr_48858_48881[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48848 === (10))){
var inst_48840 = (state_48847[(2)]);
var state_48847__$1 = (function (){var statearr_48859 = state_48847;
(statearr_48859[(8)] = inst_48840);

return statearr_48859;
})();
var statearr_48860_48882 = state_48847__$1;
(statearr_48860_48882[(2)] = null);

(statearr_48860_48882[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48848 === (8))){
var inst_48829 = (state_48847[(7)]);
var state_48847__$1 = state_48847;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48847__$1,(11),out,inst_48829);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__46582__auto___48872,out))
;
return ((function (switch__46468__auto__,c__46582__auto___48872,out){
return (function() {
var cljs$core$async$state_machine__46469__auto__ = null;
var cljs$core$async$state_machine__46469__auto____0 = (function (){
var statearr_48864 = [null,null,null,null,null,null,null,null,null];
(statearr_48864[(0)] = cljs$core$async$state_machine__46469__auto__);

(statearr_48864[(1)] = (1));

return statearr_48864;
});
var cljs$core$async$state_machine__46469__auto____1 = (function (state_48847){
while(true){
var ret_value__46470__auto__ = (function (){try{while(true){
var result__46471__auto__ = switch__46468__auto__.call(null,state_48847);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46471__auto__;
}
break;
}
}catch (e48865){if((e48865 instanceof Object)){
var ex__46472__auto__ = e48865;
var statearr_48866_48883 = state_48847;
(statearr_48866_48883[(5)] = ex__46472__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48847);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48865;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48884 = state_48847;
state_48847 = G__48884;
continue;
} else {
return ret_value__46470__auto__;
}
break;
}
});
cljs$core$async$state_machine__46469__auto__ = function(state_48847){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46469__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46469__auto____1.call(this,state_48847);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46469__auto____0;
cljs$core$async$state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46469__auto____1;
return cljs$core$async$state_machine__46469__auto__;
})()
;})(switch__46468__auto__,c__46582__auto___48872,out))
})();
var state__46584__auto__ = (function (){var statearr_48867 = f__46583__auto__.call(null);
(statearr_48867[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46582__auto___48872);

return statearr_48867;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46584__auto__);
});})(c__46582__auto___48872,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args48885 = [];
var len__20433__auto___48888 = arguments.length;
var i__20434__auto___48889 = (0);
while(true){
if((i__20434__auto___48889 < len__20433__auto___48888)){
args48885.push((arguments[i__20434__auto___48889]));

var G__48890 = (i__20434__auto___48889 + (1));
i__20434__auto___48889 = G__48890;
continue;
} else {
}
break;
}

var G__48887 = args48885.length;
switch (G__48887) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args48885.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__46582__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46582__auto__){
return (function (){
var f__46583__auto__ = (function (){var switch__46468__auto__ = ((function (c__46582__auto__){
return (function (state_49057){
var state_val_49058 = (state_49057[(1)]);
if((state_val_49058 === (7))){
var inst_49053 = (state_49057[(2)]);
var state_49057__$1 = state_49057;
var statearr_49059_49100 = state_49057__$1;
(statearr_49059_49100[(2)] = inst_49053);

(statearr_49059_49100[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49058 === (20))){
var inst_49023 = (state_49057[(7)]);
var inst_49034 = (state_49057[(2)]);
var inst_49035 = cljs.core.next.call(null,inst_49023);
var inst_49009 = inst_49035;
var inst_49010 = null;
var inst_49011 = (0);
var inst_49012 = (0);
var state_49057__$1 = (function (){var statearr_49060 = state_49057;
(statearr_49060[(8)] = inst_49009);

(statearr_49060[(9)] = inst_49011);

(statearr_49060[(10)] = inst_49034);

(statearr_49060[(11)] = inst_49012);

(statearr_49060[(12)] = inst_49010);

return statearr_49060;
})();
var statearr_49061_49101 = state_49057__$1;
(statearr_49061_49101[(2)] = null);

(statearr_49061_49101[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49058 === (1))){
var state_49057__$1 = state_49057;
var statearr_49062_49102 = state_49057__$1;
(statearr_49062_49102[(2)] = null);

(statearr_49062_49102[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49058 === (4))){
var inst_48998 = (state_49057[(13)]);
var inst_48998__$1 = (state_49057[(2)]);
var inst_48999 = (inst_48998__$1 == null);
var state_49057__$1 = (function (){var statearr_49063 = state_49057;
(statearr_49063[(13)] = inst_48998__$1);

return statearr_49063;
})();
if(cljs.core.truth_(inst_48999)){
var statearr_49064_49103 = state_49057__$1;
(statearr_49064_49103[(1)] = (5));

} else {
var statearr_49065_49104 = state_49057__$1;
(statearr_49065_49104[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49058 === (15))){
var state_49057__$1 = state_49057;
var statearr_49069_49105 = state_49057__$1;
(statearr_49069_49105[(2)] = null);

(statearr_49069_49105[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49058 === (21))){
var state_49057__$1 = state_49057;
var statearr_49070_49106 = state_49057__$1;
(statearr_49070_49106[(2)] = null);

(statearr_49070_49106[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49058 === (13))){
var inst_49009 = (state_49057[(8)]);
var inst_49011 = (state_49057[(9)]);
var inst_49012 = (state_49057[(11)]);
var inst_49010 = (state_49057[(12)]);
var inst_49019 = (state_49057[(2)]);
var inst_49020 = (inst_49012 + (1));
var tmp49066 = inst_49009;
var tmp49067 = inst_49011;
var tmp49068 = inst_49010;
var inst_49009__$1 = tmp49066;
var inst_49010__$1 = tmp49068;
var inst_49011__$1 = tmp49067;
var inst_49012__$1 = inst_49020;
var state_49057__$1 = (function (){var statearr_49071 = state_49057;
(statearr_49071[(14)] = inst_49019);

(statearr_49071[(8)] = inst_49009__$1);

(statearr_49071[(9)] = inst_49011__$1);

(statearr_49071[(11)] = inst_49012__$1);

(statearr_49071[(12)] = inst_49010__$1);

return statearr_49071;
})();
var statearr_49072_49107 = state_49057__$1;
(statearr_49072_49107[(2)] = null);

(statearr_49072_49107[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49058 === (22))){
var state_49057__$1 = state_49057;
var statearr_49073_49108 = state_49057__$1;
(statearr_49073_49108[(2)] = null);

(statearr_49073_49108[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49058 === (6))){
var inst_48998 = (state_49057[(13)]);
var inst_49007 = f.call(null,inst_48998);
var inst_49008 = cljs.core.seq.call(null,inst_49007);
var inst_49009 = inst_49008;
var inst_49010 = null;
var inst_49011 = (0);
var inst_49012 = (0);
var state_49057__$1 = (function (){var statearr_49074 = state_49057;
(statearr_49074[(8)] = inst_49009);

(statearr_49074[(9)] = inst_49011);

(statearr_49074[(11)] = inst_49012);

(statearr_49074[(12)] = inst_49010);

return statearr_49074;
})();
var statearr_49075_49109 = state_49057__$1;
(statearr_49075_49109[(2)] = null);

(statearr_49075_49109[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49058 === (17))){
var inst_49023 = (state_49057[(7)]);
var inst_49027 = cljs.core.chunk_first.call(null,inst_49023);
var inst_49028 = cljs.core.chunk_rest.call(null,inst_49023);
var inst_49029 = cljs.core.count.call(null,inst_49027);
var inst_49009 = inst_49028;
var inst_49010 = inst_49027;
var inst_49011 = inst_49029;
var inst_49012 = (0);
var state_49057__$1 = (function (){var statearr_49076 = state_49057;
(statearr_49076[(8)] = inst_49009);

(statearr_49076[(9)] = inst_49011);

(statearr_49076[(11)] = inst_49012);

(statearr_49076[(12)] = inst_49010);

return statearr_49076;
})();
var statearr_49077_49110 = state_49057__$1;
(statearr_49077_49110[(2)] = null);

(statearr_49077_49110[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49058 === (3))){
var inst_49055 = (state_49057[(2)]);
var state_49057__$1 = state_49057;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_49057__$1,inst_49055);
} else {
if((state_val_49058 === (12))){
var inst_49043 = (state_49057[(2)]);
var state_49057__$1 = state_49057;
var statearr_49078_49111 = state_49057__$1;
(statearr_49078_49111[(2)] = inst_49043);

(statearr_49078_49111[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49058 === (2))){
var state_49057__$1 = state_49057;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_49057__$1,(4),in$);
} else {
if((state_val_49058 === (23))){
var inst_49051 = (state_49057[(2)]);
var state_49057__$1 = state_49057;
var statearr_49079_49112 = state_49057__$1;
(statearr_49079_49112[(2)] = inst_49051);

(statearr_49079_49112[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49058 === (19))){
var inst_49038 = (state_49057[(2)]);
var state_49057__$1 = state_49057;
var statearr_49080_49113 = state_49057__$1;
(statearr_49080_49113[(2)] = inst_49038);

(statearr_49080_49113[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49058 === (11))){
var inst_49023 = (state_49057[(7)]);
var inst_49009 = (state_49057[(8)]);
var inst_49023__$1 = cljs.core.seq.call(null,inst_49009);
var state_49057__$1 = (function (){var statearr_49081 = state_49057;
(statearr_49081[(7)] = inst_49023__$1);

return statearr_49081;
})();
if(inst_49023__$1){
var statearr_49082_49114 = state_49057__$1;
(statearr_49082_49114[(1)] = (14));

} else {
var statearr_49083_49115 = state_49057__$1;
(statearr_49083_49115[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49058 === (9))){
var inst_49045 = (state_49057[(2)]);
var inst_49046 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_49057__$1 = (function (){var statearr_49084 = state_49057;
(statearr_49084[(15)] = inst_49045);

return statearr_49084;
})();
if(cljs.core.truth_(inst_49046)){
var statearr_49085_49116 = state_49057__$1;
(statearr_49085_49116[(1)] = (21));

} else {
var statearr_49086_49117 = state_49057__$1;
(statearr_49086_49117[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49058 === (5))){
var inst_49001 = cljs.core.async.close_BANG_.call(null,out);
var state_49057__$1 = state_49057;
var statearr_49087_49118 = state_49057__$1;
(statearr_49087_49118[(2)] = inst_49001);

(statearr_49087_49118[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49058 === (14))){
var inst_49023 = (state_49057[(7)]);
var inst_49025 = cljs.core.chunked_seq_QMARK_.call(null,inst_49023);
var state_49057__$1 = state_49057;
if(inst_49025){
var statearr_49088_49119 = state_49057__$1;
(statearr_49088_49119[(1)] = (17));

} else {
var statearr_49089_49120 = state_49057__$1;
(statearr_49089_49120[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49058 === (16))){
var inst_49041 = (state_49057[(2)]);
var state_49057__$1 = state_49057;
var statearr_49090_49121 = state_49057__$1;
(statearr_49090_49121[(2)] = inst_49041);

(statearr_49090_49121[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49058 === (10))){
var inst_49012 = (state_49057[(11)]);
var inst_49010 = (state_49057[(12)]);
var inst_49017 = cljs.core._nth.call(null,inst_49010,inst_49012);
var state_49057__$1 = state_49057;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_49057__$1,(13),out,inst_49017);
} else {
if((state_val_49058 === (18))){
var inst_49023 = (state_49057[(7)]);
var inst_49032 = cljs.core.first.call(null,inst_49023);
var state_49057__$1 = state_49057;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_49057__$1,(20),out,inst_49032);
} else {
if((state_val_49058 === (8))){
var inst_49011 = (state_49057[(9)]);
var inst_49012 = (state_49057[(11)]);
var inst_49014 = (inst_49012 < inst_49011);
var inst_49015 = inst_49014;
var state_49057__$1 = state_49057;
if(cljs.core.truth_(inst_49015)){
var statearr_49091_49122 = state_49057__$1;
(statearr_49091_49122[(1)] = (10));

} else {
var statearr_49092_49123 = state_49057__$1;
(statearr_49092_49123[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46582__auto__))
;
return ((function (switch__46468__auto__,c__46582__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__46469__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__46469__auto____0 = (function (){
var statearr_49096 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_49096[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__46469__auto__);

(statearr_49096[(1)] = (1));

return statearr_49096;
});
var cljs$core$async$mapcat_STAR__$_state_machine__46469__auto____1 = (function (state_49057){
while(true){
var ret_value__46470__auto__ = (function (){try{while(true){
var result__46471__auto__ = switch__46468__auto__.call(null,state_49057);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46471__auto__;
}
break;
}
}catch (e49097){if((e49097 instanceof Object)){
var ex__46472__auto__ = e49097;
var statearr_49098_49124 = state_49057;
(statearr_49098_49124[(5)] = ex__46472__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_49057);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e49097;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49125 = state_49057;
state_49057 = G__49125;
continue;
} else {
return ret_value__46470__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__46469__auto__ = function(state_49057){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__46469__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__46469__auto____1.call(this,state_49057);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__46469__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__46469__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__46469__auto__;
})()
;})(switch__46468__auto__,c__46582__auto__))
})();
var state__46584__auto__ = (function (){var statearr_49099 = f__46583__auto__.call(null);
(statearr_49099[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46582__auto__);

return statearr_49099;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46584__auto__);
});})(c__46582__auto__))
);

return c__46582__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args49126 = [];
var len__20433__auto___49129 = arguments.length;
var i__20434__auto___49130 = (0);
while(true){
if((i__20434__auto___49130 < len__20433__auto___49129)){
args49126.push((arguments[i__20434__auto___49130]));

var G__49131 = (i__20434__auto___49130 + (1));
i__20434__auto___49130 = G__49131;
continue;
} else {
}
break;
}

var G__49128 = args49126.length;
switch (G__49128) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args49126.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args49133 = [];
var len__20433__auto___49136 = arguments.length;
var i__20434__auto___49137 = (0);
while(true){
if((i__20434__auto___49137 < len__20433__auto___49136)){
args49133.push((arguments[i__20434__auto___49137]));

var G__49138 = (i__20434__auto___49137 + (1));
i__20434__auto___49137 = G__49138;
continue;
} else {
}
break;
}

var G__49135 = args49133.length;
switch (G__49135) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args49133.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args49140 = [];
var len__20433__auto___49191 = arguments.length;
var i__20434__auto___49192 = (0);
while(true){
if((i__20434__auto___49192 < len__20433__auto___49191)){
args49140.push((arguments[i__20434__auto___49192]));

var G__49193 = (i__20434__auto___49192 + (1));
i__20434__auto___49192 = G__49193;
continue;
} else {
}
break;
}

var G__49142 = args49140.length;
switch (G__49142) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args49140.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__46582__auto___49195 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46582__auto___49195,out){
return (function (){
var f__46583__auto__ = (function (){var switch__46468__auto__ = ((function (c__46582__auto___49195,out){
return (function (state_49166){
var state_val_49167 = (state_49166[(1)]);
if((state_val_49167 === (7))){
var inst_49161 = (state_49166[(2)]);
var state_49166__$1 = state_49166;
var statearr_49168_49196 = state_49166__$1;
(statearr_49168_49196[(2)] = inst_49161);

(statearr_49168_49196[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49167 === (1))){
var inst_49143 = null;
var state_49166__$1 = (function (){var statearr_49169 = state_49166;
(statearr_49169[(7)] = inst_49143);

return statearr_49169;
})();
var statearr_49170_49197 = state_49166__$1;
(statearr_49170_49197[(2)] = null);

(statearr_49170_49197[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49167 === (4))){
var inst_49146 = (state_49166[(8)]);
var inst_49146__$1 = (state_49166[(2)]);
var inst_49147 = (inst_49146__$1 == null);
var inst_49148 = cljs.core.not.call(null,inst_49147);
var state_49166__$1 = (function (){var statearr_49171 = state_49166;
(statearr_49171[(8)] = inst_49146__$1);

return statearr_49171;
})();
if(inst_49148){
var statearr_49172_49198 = state_49166__$1;
(statearr_49172_49198[(1)] = (5));

} else {
var statearr_49173_49199 = state_49166__$1;
(statearr_49173_49199[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49167 === (6))){
var state_49166__$1 = state_49166;
var statearr_49174_49200 = state_49166__$1;
(statearr_49174_49200[(2)] = null);

(statearr_49174_49200[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49167 === (3))){
var inst_49163 = (state_49166[(2)]);
var inst_49164 = cljs.core.async.close_BANG_.call(null,out);
var state_49166__$1 = (function (){var statearr_49175 = state_49166;
(statearr_49175[(9)] = inst_49163);

return statearr_49175;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_49166__$1,inst_49164);
} else {
if((state_val_49167 === (2))){
var state_49166__$1 = state_49166;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_49166__$1,(4),ch);
} else {
if((state_val_49167 === (11))){
var inst_49146 = (state_49166[(8)]);
var inst_49155 = (state_49166[(2)]);
var inst_49143 = inst_49146;
var state_49166__$1 = (function (){var statearr_49176 = state_49166;
(statearr_49176[(7)] = inst_49143);

(statearr_49176[(10)] = inst_49155);

return statearr_49176;
})();
var statearr_49177_49201 = state_49166__$1;
(statearr_49177_49201[(2)] = null);

(statearr_49177_49201[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49167 === (9))){
var inst_49146 = (state_49166[(8)]);
var state_49166__$1 = state_49166;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_49166__$1,(11),out,inst_49146);
} else {
if((state_val_49167 === (5))){
var inst_49143 = (state_49166[(7)]);
var inst_49146 = (state_49166[(8)]);
var inst_49150 = cljs.core._EQ_.call(null,inst_49146,inst_49143);
var state_49166__$1 = state_49166;
if(inst_49150){
var statearr_49179_49202 = state_49166__$1;
(statearr_49179_49202[(1)] = (8));

} else {
var statearr_49180_49203 = state_49166__$1;
(statearr_49180_49203[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49167 === (10))){
var inst_49158 = (state_49166[(2)]);
var state_49166__$1 = state_49166;
var statearr_49181_49204 = state_49166__$1;
(statearr_49181_49204[(2)] = inst_49158);

(statearr_49181_49204[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49167 === (8))){
var inst_49143 = (state_49166[(7)]);
var tmp49178 = inst_49143;
var inst_49143__$1 = tmp49178;
var state_49166__$1 = (function (){var statearr_49182 = state_49166;
(statearr_49182[(7)] = inst_49143__$1);

return statearr_49182;
})();
var statearr_49183_49205 = state_49166__$1;
(statearr_49183_49205[(2)] = null);

(statearr_49183_49205[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__46582__auto___49195,out))
;
return ((function (switch__46468__auto__,c__46582__auto___49195,out){
return (function() {
var cljs$core$async$state_machine__46469__auto__ = null;
var cljs$core$async$state_machine__46469__auto____0 = (function (){
var statearr_49187 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_49187[(0)] = cljs$core$async$state_machine__46469__auto__);

(statearr_49187[(1)] = (1));

return statearr_49187;
});
var cljs$core$async$state_machine__46469__auto____1 = (function (state_49166){
while(true){
var ret_value__46470__auto__ = (function (){try{while(true){
var result__46471__auto__ = switch__46468__auto__.call(null,state_49166);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46471__auto__;
}
break;
}
}catch (e49188){if((e49188 instanceof Object)){
var ex__46472__auto__ = e49188;
var statearr_49189_49206 = state_49166;
(statearr_49189_49206[(5)] = ex__46472__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_49166);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e49188;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49207 = state_49166;
state_49166 = G__49207;
continue;
} else {
return ret_value__46470__auto__;
}
break;
}
});
cljs$core$async$state_machine__46469__auto__ = function(state_49166){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46469__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46469__auto____1.call(this,state_49166);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46469__auto____0;
cljs$core$async$state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46469__auto____1;
return cljs$core$async$state_machine__46469__auto__;
})()
;})(switch__46468__auto__,c__46582__auto___49195,out))
})();
var state__46584__auto__ = (function (){var statearr_49190 = f__46583__auto__.call(null);
(statearr_49190[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46582__auto___49195);

return statearr_49190;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46584__auto__);
});})(c__46582__auto___49195,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args49208 = [];
var len__20433__auto___49278 = arguments.length;
var i__20434__auto___49279 = (0);
while(true){
if((i__20434__auto___49279 < len__20433__auto___49278)){
args49208.push((arguments[i__20434__auto___49279]));

var G__49280 = (i__20434__auto___49279 + (1));
i__20434__auto___49279 = G__49280;
continue;
} else {
}
break;
}

var G__49210 = args49208.length;
switch (G__49210) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args49208.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__46582__auto___49282 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46582__auto___49282,out){
return (function (){
var f__46583__auto__ = (function (){var switch__46468__auto__ = ((function (c__46582__auto___49282,out){
return (function (state_49248){
var state_val_49249 = (state_49248[(1)]);
if((state_val_49249 === (7))){
var inst_49244 = (state_49248[(2)]);
var state_49248__$1 = state_49248;
var statearr_49250_49283 = state_49248__$1;
(statearr_49250_49283[(2)] = inst_49244);

(statearr_49250_49283[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49249 === (1))){
var inst_49211 = (new Array(n));
var inst_49212 = inst_49211;
var inst_49213 = (0);
var state_49248__$1 = (function (){var statearr_49251 = state_49248;
(statearr_49251[(7)] = inst_49212);

(statearr_49251[(8)] = inst_49213);

return statearr_49251;
})();
var statearr_49252_49284 = state_49248__$1;
(statearr_49252_49284[(2)] = null);

(statearr_49252_49284[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49249 === (4))){
var inst_49216 = (state_49248[(9)]);
var inst_49216__$1 = (state_49248[(2)]);
var inst_49217 = (inst_49216__$1 == null);
var inst_49218 = cljs.core.not.call(null,inst_49217);
var state_49248__$1 = (function (){var statearr_49253 = state_49248;
(statearr_49253[(9)] = inst_49216__$1);

return statearr_49253;
})();
if(inst_49218){
var statearr_49254_49285 = state_49248__$1;
(statearr_49254_49285[(1)] = (5));

} else {
var statearr_49255_49286 = state_49248__$1;
(statearr_49255_49286[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49249 === (15))){
var inst_49238 = (state_49248[(2)]);
var state_49248__$1 = state_49248;
var statearr_49256_49287 = state_49248__$1;
(statearr_49256_49287[(2)] = inst_49238);

(statearr_49256_49287[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49249 === (13))){
var state_49248__$1 = state_49248;
var statearr_49257_49288 = state_49248__$1;
(statearr_49257_49288[(2)] = null);

(statearr_49257_49288[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49249 === (6))){
var inst_49213 = (state_49248[(8)]);
var inst_49234 = (inst_49213 > (0));
var state_49248__$1 = state_49248;
if(cljs.core.truth_(inst_49234)){
var statearr_49258_49289 = state_49248__$1;
(statearr_49258_49289[(1)] = (12));

} else {
var statearr_49259_49290 = state_49248__$1;
(statearr_49259_49290[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49249 === (3))){
var inst_49246 = (state_49248[(2)]);
var state_49248__$1 = state_49248;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_49248__$1,inst_49246);
} else {
if((state_val_49249 === (12))){
var inst_49212 = (state_49248[(7)]);
var inst_49236 = cljs.core.vec.call(null,inst_49212);
var state_49248__$1 = state_49248;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_49248__$1,(15),out,inst_49236);
} else {
if((state_val_49249 === (2))){
var state_49248__$1 = state_49248;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_49248__$1,(4),ch);
} else {
if((state_val_49249 === (11))){
var inst_49228 = (state_49248[(2)]);
var inst_49229 = (new Array(n));
var inst_49212 = inst_49229;
var inst_49213 = (0);
var state_49248__$1 = (function (){var statearr_49260 = state_49248;
(statearr_49260[(10)] = inst_49228);

(statearr_49260[(7)] = inst_49212);

(statearr_49260[(8)] = inst_49213);

return statearr_49260;
})();
var statearr_49261_49291 = state_49248__$1;
(statearr_49261_49291[(2)] = null);

(statearr_49261_49291[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49249 === (9))){
var inst_49212 = (state_49248[(7)]);
var inst_49226 = cljs.core.vec.call(null,inst_49212);
var state_49248__$1 = state_49248;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_49248__$1,(11),out,inst_49226);
} else {
if((state_val_49249 === (5))){
var inst_49221 = (state_49248[(11)]);
var inst_49212 = (state_49248[(7)]);
var inst_49216 = (state_49248[(9)]);
var inst_49213 = (state_49248[(8)]);
var inst_49220 = (inst_49212[inst_49213] = inst_49216);
var inst_49221__$1 = (inst_49213 + (1));
var inst_49222 = (inst_49221__$1 < n);
var state_49248__$1 = (function (){var statearr_49262 = state_49248;
(statearr_49262[(12)] = inst_49220);

(statearr_49262[(11)] = inst_49221__$1);

return statearr_49262;
})();
if(cljs.core.truth_(inst_49222)){
var statearr_49263_49292 = state_49248__$1;
(statearr_49263_49292[(1)] = (8));

} else {
var statearr_49264_49293 = state_49248__$1;
(statearr_49264_49293[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49249 === (14))){
var inst_49241 = (state_49248[(2)]);
var inst_49242 = cljs.core.async.close_BANG_.call(null,out);
var state_49248__$1 = (function (){var statearr_49266 = state_49248;
(statearr_49266[(13)] = inst_49241);

return statearr_49266;
})();
var statearr_49267_49294 = state_49248__$1;
(statearr_49267_49294[(2)] = inst_49242);

(statearr_49267_49294[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49249 === (10))){
var inst_49232 = (state_49248[(2)]);
var state_49248__$1 = state_49248;
var statearr_49268_49295 = state_49248__$1;
(statearr_49268_49295[(2)] = inst_49232);

(statearr_49268_49295[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49249 === (8))){
var inst_49221 = (state_49248[(11)]);
var inst_49212 = (state_49248[(7)]);
var tmp49265 = inst_49212;
var inst_49212__$1 = tmp49265;
var inst_49213 = inst_49221;
var state_49248__$1 = (function (){var statearr_49269 = state_49248;
(statearr_49269[(7)] = inst_49212__$1);

(statearr_49269[(8)] = inst_49213);

return statearr_49269;
})();
var statearr_49270_49296 = state_49248__$1;
(statearr_49270_49296[(2)] = null);

(statearr_49270_49296[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46582__auto___49282,out))
;
return ((function (switch__46468__auto__,c__46582__auto___49282,out){
return (function() {
var cljs$core$async$state_machine__46469__auto__ = null;
var cljs$core$async$state_machine__46469__auto____0 = (function (){
var statearr_49274 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_49274[(0)] = cljs$core$async$state_machine__46469__auto__);

(statearr_49274[(1)] = (1));

return statearr_49274;
});
var cljs$core$async$state_machine__46469__auto____1 = (function (state_49248){
while(true){
var ret_value__46470__auto__ = (function (){try{while(true){
var result__46471__auto__ = switch__46468__auto__.call(null,state_49248);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46471__auto__;
}
break;
}
}catch (e49275){if((e49275 instanceof Object)){
var ex__46472__auto__ = e49275;
var statearr_49276_49297 = state_49248;
(statearr_49276_49297[(5)] = ex__46472__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_49248);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e49275;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49298 = state_49248;
state_49248 = G__49298;
continue;
} else {
return ret_value__46470__auto__;
}
break;
}
});
cljs$core$async$state_machine__46469__auto__ = function(state_49248){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46469__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46469__auto____1.call(this,state_49248);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46469__auto____0;
cljs$core$async$state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46469__auto____1;
return cljs$core$async$state_machine__46469__auto__;
})()
;})(switch__46468__auto__,c__46582__auto___49282,out))
})();
var state__46584__auto__ = (function (){var statearr_49277 = f__46583__auto__.call(null);
(statearr_49277[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46582__auto___49282);

return statearr_49277;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46584__auto__);
});})(c__46582__auto___49282,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args49299 = [];
var len__20433__auto___49373 = arguments.length;
var i__20434__auto___49374 = (0);
while(true){
if((i__20434__auto___49374 < len__20433__auto___49373)){
args49299.push((arguments[i__20434__auto___49374]));

var G__49375 = (i__20434__auto___49374 + (1));
i__20434__auto___49374 = G__49375;
continue;
} else {
}
break;
}

var G__49301 = args49299.length;
switch (G__49301) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args49299.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__46582__auto___49377 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46582__auto___49377,out){
return (function (){
var f__46583__auto__ = (function (){var switch__46468__auto__ = ((function (c__46582__auto___49377,out){
return (function (state_49343){
var state_val_49344 = (state_49343[(1)]);
if((state_val_49344 === (7))){
var inst_49339 = (state_49343[(2)]);
var state_49343__$1 = state_49343;
var statearr_49345_49378 = state_49343__$1;
(statearr_49345_49378[(2)] = inst_49339);

(statearr_49345_49378[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49344 === (1))){
var inst_49302 = [];
var inst_49303 = inst_49302;
var inst_49304 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_49343__$1 = (function (){var statearr_49346 = state_49343;
(statearr_49346[(7)] = inst_49304);

(statearr_49346[(8)] = inst_49303);

return statearr_49346;
})();
var statearr_49347_49379 = state_49343__$1;
(statearr_49347_49379[(2)] = null);

(statearr_49347_49379[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49344 === (4))){
var inst_49307 = (state_49343[(9)]);
var inst_49307__$1 = (state_49343[(2)]);
var inst_49308 = (inst_49307__$1 == null);
var inst_49309 = cljs.core.not.call(null,inst_49308);
var state_49343__$1 = (function (){var statearr_49348 = state_49343;
(statearr_49348[(9)] = inst_49307__$1);

return statearr_49348;
})();
if(inst_49309){
var statearr_49349_49380 = state_49343__$1;
(statearr_49349_49380[(1)] = (5));

} else {
var statearr_49350_49381 = state_49343__$1;
(statearr_49350_49381[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49344 === (15))){
var inst_49333 = (state_49343[(2)]);
var state_49343__$1 = state_49343;
var statearr_49351_49382 = state_49343__$1;
(statearr_49351_49382[(2)] = inst_49333);

(statearr_49351_49382[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49344 === (13))){
var state_49343__$1 = state_49343;
var statearr_49352_49383 = state_49343__$1;
(statearr_49352_49383[(2)] = null);

(statearr_49352_49383[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49344 === (6))){
var inst_49303 = (state_49343[(8)]);
var inst_49328 = inst_49303.length;
var inst_49329 = (inst_49328 > (0));
var state_49343__$1 = state_49343;
if(cljs.core.truth_(inst_49329)){
var statearr_49353_49384 = state_49343__$1;
(statearr_49353_49384[(1)] = (12));

} else {
var statearr_49354_49385 = state_49343__$1;
(statearr_49354_49385[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49344 === (3))){
var inst_49341 = (state_49343[(2)]);
var state_49343__$1 = state_49343;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_49343__$1,inst_49341);
} else {
if((state_val_49344 === (12))){
var inst_49303 = (state_49343[(8)]);
var inst_49331 = cljs.core.vec.call(null,inst_49303);
var state_49343__$1 = state_49343;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_49343__$1,(15),out,inst_49331);
} else {
if((state_val_49344 === (2))){
var state_49343__$1 = state_49343;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_49343__$1,(4),ch);
} else {
if((state_val_49344 === (11))){
var inst_49311 = (state_49343[(10)]);
var inst_49307 = (state_49343[(9)]);
var inst_49321 = (state_49343[(2)]);
var inst_49322 = [];
var inst_49323 = inst_49322.push(inst_49307);
var inst_49303 = inst_49322;
var inst_49304 = inst_49311;
var state_49343__$1 = (function (){var statearr_49355 = state_49343;
(statearr_49355[(11)] = inst_49321);

(statearr_49355[(12)] = inst_49323);

(statearr_49355[(7)] = inst_49304);

(statearr_49355[(8)] = inst_49303);

return statearr_49355;
})();
var statearr_49356_49386 = state_49343__$1;
(statearr_49356_49386[(2)] = null);

(statearr_49356_49386[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49344 === (9))){
var inst_49303 = (state_49343[(8)]);
var inst_49319 = cljs.core.vec.call(null,inst_49303);
var state_49343__$1 = state_49343;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_49343__$1,(11),out,inst_49319);
} else {
if((state_val_49344 === (5))){
var inst_49311 = (state_49343[(10)]);
var inst_49304 = (state_49343[(7)]);
var inst_49307 = (state_49343[(9)]);
var inst_49311__$1 = f.call(null,inst_49307);
var inst_49312 = cljs.core._EQ_.call(null,inst_49311__$1,inst_49304);
var inst_49313 = cljs.core.keyword_identical_QMARK_.call(null,inst_49304,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_49314 = (inst_49312) || (inst_49313);
var state_49343__$1 = (function (){var statearr_49357 = state_49343;
(statearr_49357[(10)] = inst_49311__$1);

return statearr_49357;
})();
if(cljs.core.truth_(inst_49314)){
var statearr_49358_49387 = state_49343__$1;
(statearr_49358_49387[(1)] = (8));

} else {
var statearr_49359_49388 = state_49343__$1;
(statearr_49359_49388[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49344 === (14))){
var inst_49336 = (state_49343[(2)]);
var inst_49337 = cljs.core.async.close_BANG_.call(null,out);
var state_49343__$1 = (function (){var statearr_49361 = state_49343;
(statearr_49361[(13)] = inst_49336);

return statearr_49361;
})();
var statearr_49362_49389 = state_49343__$1;
(statearr_49362_49389[(2)] = inst_49337);

(statearr_49362_49389[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49344 === (10))){
var inst_49326 = (state_49343[(2)]);
var state_49343__$1 = state_49343;
var statearr_49363_49390 = state_49343__$1;
(statearr_49363_49390[(2)] = inst_49326);

(statearr_49363_49390[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49344 === (8))){
var inst_49311 = (state_49343[(10)]);
var inst_49307 = (state_49343[(9)]);
var inst_49303 = (state_49343[(8)]);
var inst_49316 = inst_49303.push(inst_49307);
var tmp49360 = inst_49303;
var inst_49303__$1 = tmp49360;
var inst_49304 = inst_49311;
var state_49343__$1 = (function (){var statearr_49364 = state_49343;
(statearr_49364[(7)] = inst_49304);

(statearr_49364[(14)] = inst_49316);

(statearr_49364[(8)] = inst_49303__$1);

return statearr_49364;
})();
var statearr_49365_49391 = state_49343__$1;
(statearr_49365_49391[(2)] = null);

(statearr_49365_49391[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46582__auto___49377,out))
;
return ((function (switch__46468__auto__,c__46582__auto___49377,out){
return (function() {
var cljs$core$async$state_machine__46469__auto__ = null;
var cljs$core$async$state_machine__46469__auto____0 = (function (){
var statearr_49369 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_49369[(0)] = cljs$core$async$state_machine__46469__auto__);

(statearr_49369[(1)] = (1));

return statearr_49369;
});
var cljs$core$async$state_machine__46469__auto____1 = (function (state_49343){
while(true){
var ret_value__46470__auto__ = (function (){try{while(true){
var result__46471__auto__ = switch__46468__auto__.call(null,state_49343);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46471__auto__;
}
break;
}
}catch (e49370){if((e49370 instanceof Object)){
var ex__46472__auto__ = e49370;
var statearr_49371_49392 = state_49343;
(statearr_49371_49392[(5)] = ex__46472__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_49343);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e49370;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49393 = state_49343;
state_49343 = G__49393;
continue;
} else {
return ret_value__46470__auto__;
}
break;
}
});
cljs$core$async$state_machine__46469__auto__ = function(state_49343){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46469__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46469__auto____1.call(this,state_49343);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46469__auto____0;
cljs$core$async$state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46469__auto____1;
return cljs$core$async$state_machine__46469__auto__;
})()
;})(switch__46468__auto__,c__46582__auto___49377,out))
})();
var state__46584__auto__ = (function (){var statearr_49372 = f__46583__auto__.call(null);
(statearr_49372[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46582__auto___49377);

return statearr_49372;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46584__auto__);
});})(c__46582__auto___49377,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1528140064793