// Compiled by ClojureScript 1.9.293 {}
goog.provide('hasch.benc');
goog.require('cljs.core');

/**
 * @interface
 */
hasch.benc.PHashCoercion = function(){};

hasch.benc._coerce = (function hasch$benc$_coerce(this$,md_create_fn,write_handlers){
if((!((this$ == null))) && (!((this$.hasch$benc$PHashCoercion$_coerce$arity$3 == null)))){
return this$.hasch$benc$PHashCoercion$_coerce$arity$3(this$,md_create_fn,write_handlers);
} else {
var x__7798__auto__ = (((this$ == null))?null:this$);
var m__7799__auto__ = (hasch.benc._coerce[goog.typeOf(x__7798__auto__)]);
if(!((m__7799__auto__ == null))){
return m__7799__auto__.call(null,this$,md_create_fn,write_handlers);
} else {
var m__7799__auto____$1 = (hasch.benc._coerce["_"]);
if(!((m__7799__auto____$1 == null))){
return m__7799__auto____$1.call(null,this$,md_create_fn,write_handlers);
} else {
throw cljs.core.missing_protocol.call(null,"PHashCoercion.-coerce",this$);
}
}
}
});

hasch.benc.magics = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"binary","binary",-1802232288),new cljs.core.Keyword(null,"inst","inst",645962501),new cljs.core.Keyword(null,"number","number",1570378438),new cljs.core.Keyword(null,"symbol","symbol",-1038572696),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"vector","vector",1902966158),new cljs.core.Keyword(null,"keyword","keyword",811389747),new cljs.core.Keyword(null,"nil","nil",99600501),new cljs.core.Keyword(null,"literal","literal",1664775605),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"seq","seq",-1817803783),new cljs.core.Keyword(null,"set","set",304602554),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"map","map",1371690461)],[(13),(6),(2),(4),(3),(9),(5),(0),(12),(7),(8),(11),(1),(10)]);
hasch.benc.split_size = (1024);
hasch.benc.max_entropy_byte_count = (32);
hasch.benc.byte_array = (function hasch$benc$byte_array(len){
return cljs.core.into_array.call(null,cljs.core.repeat.call(null,len,(0)));
});
hasch.benc.digest = (function hasch$benc$digest(bytes_or_seq_of_bytes,md_create_fn){
var md = md_create_fn.call(null);
if(cljs.core.seq_QMARK_.call(null,bytes_or_seq_of_bytes)){
var seq__8883_8887 = cljs.core.seq.call(null,bytes_or_seq_of_bytes);
var chunk__8884_8888 = null;
var count__8885_8889 = (0);
var i__8886_8890 = (0);
while(true){
if((i__8886_8890 < count__8885_8889)){
var bs_8891 = cljs.core._nth.call(null,chunk__8884_8888,i__8886_8890);
md.update(bs_8891);

var G__8892 = seq__8883_8887;
var G__8893 = chunk__8884_8888;
var G__8894 = count__8885_8889;
var G__8895 = (i__8886_8890 + (1));
seq__8883_8887 = G__8892;
chunk__8884_8888 = G__8893;
count__8885_8889 = G__8894;
i__8886_8890 = G__8895;
continue;
} else {
var temp__6753__auto___8896 = cljs.core.seq.call(null,seq__8883_8887);
if(temp__6753__auto___8896){
var seq__8883_8897__$1 = temp__6753__auto___8896;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__8883_8897__$1)){
var c__7991__auto___8898 = cljs.core.chunk_first.call(null,seq__8883_8897__$1);
var G__8899 = cljs.core.chunk_rest.call(null,seq__8883_8897__$1);
var G__8900 = c__7991__auto___8898;
var G__8901 = cljs.core.count.call(null,c__7991__auto___8898);
var G__8902 = (0);
seq__8883_8887 = G__8899;
chunk__8884_8888 = G__8900;
count__8885_8889 = G__8901;
i__8886_8890 = G__8902;
continue;
} else {
var bs_8903 = cljs.core.first.call(null,seq__8883_8897__$1);
md.update(bs_8903);

var G__8904 = cljs.core.next.call(null,seq__8883_8897__$1);
var G__8905 = null;
var G__8906 = (0);
var G__8907 = (0);
seq__8883_8887 = G__8904;
chunk__8884_8888 = G__8905;
count__8885_8889 = G__8906;
i__8886_8890 = G__8907;
continue;
}
} else {
}
}
break;
}
} else {
md.update(bytes_or_seq_of_bytes);
}

return md.digest();
});
hasch.benc.coerce_seq = (function hasch$benc$coerce_seq(seq,md_create_fn,write_handlers){
var seq_md = md_create_fn.call(null);
var s_8914 = seq;
while(true){
var vec__8911_8915 = s_8914;
var seq__8912_8916 = cljs.core.seq.call(null,vec__8911_8915);
var first__8913_8917 = cljs.core.first.call(null,seq__8912_8916);
var seq__8912_8918__$1 = cljs.core.next.call(null,seq__8912_8916);
var f_8919 = first__8913_8917;
var r_8920 = seq__8912_8918__$1;
seq_md.update(hasch.benc._coerce.call(null,f_8919,md_create_fn,write_handlers));

if(cljs.core.empty_QMARK_.call(null,r_8920)){
} else {
var G__8921 = cljs.core.rest.call(null,s_8914);
s_8914 = G__8921;
continue;
}
break;
}

return seq_md.digest();
});
/**
 * Commutatively coerces elements of collection, seq entries must already be crypto hashes
 *   to avoid collisions in XOR. Takes at maximum 32 bytes into account.
 */
hasch.benc.xor_hashes = (function hasch$benc$xor_hashes(seq){
var len = (function (){var x__7425__auto__ = cljs.core.count.call(null,cljs.core.first.call(null,seq));
var y__7426__auto__ = hasch.benc.max_entropy_byte_count;
return ((x__7425__auto__ < y__7426__auto__) ? x__7425__auto__ : y__7426__auto__);
})();
return cljs.core.reduce.call(null,((function (len){
return (function (acc,elem){
var i_8922 = (0);
while(true){
if((i_8922 < len)){
(acc[i_8922] = ((acc[i_8922]) ^ (elem[i_8922])));

var G__8923 = (i_8922 + (1));
i_8922 = G__8923;
continue;
} else {
}
break;
}

return acc;
});})(len))
,hasch.benc.byte_array.call(null,len),seq);
});
hasch.benc.encode_safe = (function hasch$benc$encode_safe(a,md_create_fn){
if((cljs.core.count.call(null,a) < hasch.benc.split_size)){
var len = cljs.core.long$.call(null,a.length);
var ea = hasch.benc.byte_array.call(null,len);
var i_8924 = (0);
while(true){
if(cljs.core._EQ_.call(null,i_8924,len)){
} else {
var e_8925 = (a[i_8924]);
if(((e_8925 > (0))) && ((e_8925 < (30)))){
(ea[i_8924] = (1));
} else {
}

var G__8926 = (i_8924 + (1));
i_8924 = G__8926;
continue;
}
break;
}

return a.concat(ea);
} else {
return hasch.benc.digest.call(null,a,md_create_fn);
}
});

//# sourceMappingURL=benc.js.map