// Compiled by ClojureScript 1.9.293 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('goog.Uri');
goog.require('goog.net.jsloader');
goog.require('cljs.core.async');
goog.require('goog.object');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__19157__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__19157__auto__){
return or__19157__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.fix_node_request_url = (function figwheel$client$file_reloading$fix_node_request_url(url){

if(cljs.core.truth_(goog.string.startsWith(url,"../"))){
return clojure.string.replace.call(null,url,"../","");
} else {
return [cljs.core.str("goog/"),cljs.core.str(url)].join('');
}
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__19157__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, ["svgpan.SvgPan",null,"far.out",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__19157__auto__)){
return or__19157__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__49528_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__49528_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([name], true));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([parent_ns], true));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__49533 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__49534 = null;
var count__49535 = (0);
var i__49536 = (0);
while(true){
if((i__49536 < count__49535)){
var n = cljs.core._nth.call(null,chunk__49534,i__49536);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__49537 = seq__49533;
var G__49538 = chunk__49534;
var G__49539 = count__49535;
var G__49540 = (i__49536 + (1));
seq__49533 = G__49537;
chunk__49534 = G__49538;
count__49535 = G__49539;
i__49536 = G__49540;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__49533);
if(temp__6753__auto__){
var seq__49533__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__49533__$1)){
var c__20063__auto__ = cljs.core.chunk_first.call(null,seq__49533__$1);
var G__49541 = cljs.core.chunk_rest.call(null,seq__49533__$1);
var G__49542 = c__20063__auto__;
var G__49543 = cljs.core.count.call(null,c__20063__auto__);
var G__49544 = (0);
seq__49533 = G__49541;
chunk__49534 = G__49542;
count__49535 = G__49543;
i__49536 = G__49544;
continue;
} else {
var n = cljs.core.first.call(null,seq__49533__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__49545 = cljs.core.next.call(null,seq__49533__$1);
var G__49546 = null;
var G__49547 = (0);
var G__49548 = (0);
seq__49533 = G__49545;
chunk__49534 = G__49546;
count__49535 = G__49547;
i__49536 = G__49548;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__49599_49610 = cljs.core.seq.call(null,deps);
var chunk__49600_49611 = null;
var count__49601_49612 = (0);
var i__49602_49613 = (0);
while(true){
if((i__49602_49613 < count__49601_49612)){
var dep_49614 = cljs.core._nth.call(null,chunk__49600_49611,i__49602_49613);
topo_sort_helper_STAR_.call(null,dep_49614,(depth + (1)),state);

var G__49615 = seq__49599_49610;
var G__49616 = chunk__49600_49611;
var G__49617 = count__49601_49612;
var G__49618 = (i__49602_49613 + (1));
seq__49599_49610 = G__49615;
chunk__49600_49611 = G__49616;
count__49601_49612 = G__49617;
i__49602_49613 = G__49618;
continue;
} else {
var temp__6753__auto___49619 = cljs.core.seq.call(null,seq__49599_49610);
if(temp__6753__auto___49619){
var seq__49599_49620__$1 = temp__6753__auto___49619;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__49599_49620__$1)){
var c__20063__auto___49621 = cljs.core.chunk_first.call(null,seq__49599_49620__$1);
var G__49622 = cljs.core.chunk_rest.call(null,seq__49599_49620__$1);
var G__49623 = c__20063__auto___49621;
var G__49624 = cljs.core.count.call(null,c__20063__auto___49621);
var G__49625 = (0);
seq__49599_49610 = G__49622;
chunk__49600_49611 = G__49623;
count__49601_49612 = G__49624;
i__49602_49613 = G__49625;
continue;
} else {
var dep_49626 = cljs.core.first.call(null,seq__49599_49620__$1);
topo_sort_helper_STAR_.call(null,dep_49626,(depth + (1)),state);

var G__49627 = cljs.core.next.call(null,seq__49599_49620__$1);
var G__49628 = null;
var G__49629 = (0);
var G__49630 = (0);
seq__49599_49610 = G__49627;
chunk__49600_49611 = G__49628;
count__49601_49612 = G__49629;
i__49602_49613 = G__49630;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__49603){
var vec__49607 = p__49603;
var seq__49608 = cljs.core.seq.call(null,vec__49607);
var first__49609 = cljs.core.first.call(null,seq__49608);
var seq__49608__$1 = cljs.core.next.call(null,seq__49608);
var x = first__49609;
var xs = seq__49608__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__49607,seq__49608,first__49609,seq__49608__$1,x,xs,get_deps__$1){
return (function (p1__49549_SHARP_){
return clojure.set.difference.call(null,p1__49549_SHARP_,x);
});})(vec__49607,seq__49608,first__49609,seq__49608__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str(goog.basePath),cljs.core.str(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str(goog.basePath),cljs.core.str(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__49643 = cljs.core.seq.call(null,provides);
var chunk__49644 = null;
var count__49645 = (0);
var i__49646 = (0);
while(true){
if((i__49646 < count__49645)){
var prov = cljs.core._nth.call(null,chunk__49644,i__49646);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__49647_49655 = cljs.core.seq.call(null,requires);
var chunk__49648_49656 = null;
var count__49649_49657 = (0);
var i__49650_49658 = (0);
while(true){
if((i__49650_49658 < count__49649_49657)){
var req_49659 = cljs.core._nth.call(null,chunk__49648_49656,i__49650_49658);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_49659,prov);

var G__49660 = seq__49647_49655;
var G__49661 = chunk__49648_49656;
var G__49662 = count__49649_49657;
var G__49663 = (i__49650_49658 + (1));
seq__49647_49655 = G__49660;
chunk__49648_49656 = G__49661;
count__49649_49657 = G__49662;
i__49650_49658 = G__49663;
continue;
} else {
var temp__6753__auto___49664 = cljs.core.seq.call(null,seq__49647_49655);
if(temp__6753__auto___49664){
var seq__49647_49665__$1 = temp__6753__auto___49664;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__49647_49665__$1)){
var c__20063__auto___49666 = cljs.core.chunk_first.call(null,seq__49647_49665__$1);
var G__49667 = cljs.core.chunk_rest.call(null,seq__49647_49665__$1);
var G__49668 = c__20063__auto___49666;
var G__49669 = cljs.core.count.call(null,c__20063__auto___49666);
var G__49670 = (0);
seq__49647_49655 = G__49667;
chunk__49648_49656 = G__49668;
count__49649_49657 = G__49669;
i__49650_49658 = G__49670;
continue;
} else {
var req_49671 = cljs.core.first.call(null,seq__49647_49665__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_49671,prov);

var G__49672 = cljs.core.next.call(null,seq__49647_49665__$1);
var G__49673 = null;
var G__49674 = (0);
var G__49675 = (0);
seq__49647_49655 = G__49672;
chunk__49648_49656 = G__49673;
count__49649_49657 = G__49674;
i__49650_49658 = G__49675;
continue;
}
} else {
}
}
break;
}

var G__49676 = seq__49643;
var G__49677 = chunk__49644;
var G__49678 = count__49645;
var G__49679 = (i__49646 + (1));
seq__49643 = G__49676;
chunk__49644 = G__49677;
count__49645 = G__49678;
i__49646 = G__49679;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__49643);
if(temp__6753__auto__){
var seq__49643__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__49643__$1)){
var c__20063__auto__ = cljs.core.chunk_first.call(null,seq__49643__$1);
var G__49680 = cljs.core.chunk_rest.call(null,seq__49643__$1);
var G__49681 = c__20063__auto__;
var G__49682 = cljs.core.count.call(null,c__20063__auto__);
var G__49683 = (0);
seq__49643 = G__49680;
chunk__49644 = G__49681;
count__49645 = G__49682;
i__49646 = G__49683;
continue;
} else {
var prov = cljs.core.first.call(null,seq__49643__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__49651_49684 = cljs.core.seq.call(null,requires);
var chunk__49652_49685 = null;
var count__49653_49686 = (0);
var i__49654_49687 = (0);
while(true){
if((i__49654_49687 < count__49653_49686)){
var req_49688 = cljs.core._nth.call(null,chunk__49652_49685,i__49654_49687);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_49688,prov);

var G__49689 = seq__49651_49684;
var G__49690 = chunk__49652_49685;
var G__49691 = count__49653_49686;
var G__49692 = (i__49654_49687 + (1));
seq__49651_49684 = G__49689;
chunk__49652_49685 = G__49690;
count__49653_49686 = G__49691;
i__49654_49687 = G__49692;
continue;
} else {
var temp__6753__auto___49693__$1 = cljs.core.seq.call(null,seq__49651_49684);
if(temp__6753__auto___49693__$1){
var seq__49651_49694__$1 = temp__6753__auto___49693__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__49651_49694__$1)){
var c__20063__auto___49695 = cljs.core.chunk_first.call(null,seq__49651_49694__$1);
var G__49696 = cljs.core.chunk_rest.call(null,seq__49651_49694__$1);
var G__49697 = c__20063__auto___49695;
var G__49698 = cljs.core.count.call(null,c__20063__auto___49695);
var G__49699 = (0);
seq__49651_49684 = G__49696;
chunk__49652_49685 = G__49697;
count__49653_49686 = G__49698;
i__49654_49687 = G__49699;
continue;
} else {
var req_49700 = cljs.core.first.call(null,seq__49651_49694__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_49700,prov);

var G__49701 = cljs.core.next.call(null,seq__49651_49694__$1);
var G__49702 = null;
var G__49703 = (0);
var G__49704 = (0);
seq__49651_49684 = G__49701;
chunk__49652_49685 = G__49702;
count__49653_49686 = G__49703;
i__49654_49687 = G__49704;
continue;
}
} else {
}
}
break;
}

var G__49705 = cljs.core.next.call(null,seq__49643__$1);
var G__49706 = null;
var G__49707 = (0);
var G__49708 = (0);
seq__49643 = G__49705;
chunk__49644 = G__49706;
count__49645 = G__49707;
i__49646 = G__49708;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__49713_49717 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__49714_49718 = null;
var count__49715_49719 = (0);
var i__49716_49720 = (0);
while(true){
if((i__49716_49720 < count__49715_49719)){
var ns_49721 = cljs.core._nth.call(null,chunk__49714_49718,i__49716_49720);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_49721);

var G__49722 = seq__49713_49717;
var G__49723 = chunk__49714_49718;
var G__49724 = count__49715_49719;
var G__49725 = (i__49716_49720 + (1));
seq__49713_49717 = G__49722;
chunk__49714_49718 = G__49723;
count__49715_49719 = G__49724;
i__49716_49720 = G__49725;
continue;
} else {
var temp__6753__auto___49726 = cljs.core.seq.call(null,seq__49713_49717);
if(temp__6753__auto___49726){
var seq__49713_49727__$1 = temp__6753__auto___49726;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__49713_49727__$1)){
var c__20063__auto___49728 = cljs.core.chunk_first.call(null,seq__49713_49727__$1);
var G__49729 = cljs.core.chunk_rest.call(null,seq__49713_49727__$1);
var G__49730 = c__20063__auto___49728;
var G__49731 = cljs.core.count.call(null,c__20063__auto___49728);
var G__49732 = (0);
seq__49713_49717 = G__49729;
chunk__49714_49718 = G__49730;
count__49715_49719 = G__49731;
i__49716_49720 = G__49732;
continue;
} else {
var ns_49733 = cljs.core.first.call(null,seq__49713_49727__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_49733);

var G__49734 = cljs.core.next.call(null,seq__49713_49727__$1);
var G__49735 = null;
var G__49736 = (0);
var G__49737 = (0);
seq__49713_49717 = G__49734;
chunk__49714_49718 = G__49735;
count__49715_49719 = G__49736;
i__49716_49720 = G__49737;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__19157__auto__ = goog.require__;
if(cljs.core.truth_(or__19157__auto__)){
return or__19157__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__49738__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__49738 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__49739__i = 0, G__49739__a = new Array(arguments.length -  0);
while (G__49739__i < G__49739__a.length) {G__49739__a[G__49739__i] = arguments[G__49739__i + 0]; ++G__49739__i;}
  args = new cljs.core.IndexedSeq(G__49739__a,0);
} 
return G__49738__delegate.call(this,args);};
G__49738.cljs$lang$maxFixedArity = 0;
G__49738.cljs$lang$applyTo = (function (arglist__49740){
var args = cljs.core.seq(arglist__49740);
return G__49738__delegate(args);
});
G__49738.cljs$core$IFn$_invoke$arity$variadic = G__49738__delegate;
return G__49738;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__49742 = cljs.core._EQ_;
var expr__49743 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__49742.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__49743))){
var path_parts = ((function (pred__49742,expr__49743){
return (function (p1__49741_SHARP_){
return clojure.string.split.call(null,p1__49741_SHARP_,/[\/\\]/);
});})(pred__49742,expr__49743))
;
var sep = (cljs.core.truth_(cljs.core.re_matches.call(null,/win.*/,process.platform))?"\\":"/");
var root = clojure.string.join.call(null,sep,cljs.core.pop.call(null,cljs.core.pop.call(null,path_parts.call(null,__dirname))));
return ((function (path_parts,sep,root,pred__49742,expr__49743){
return (function (request_url,callback){

var cache_path = clojure.string.join.call(null,sep,cljs.core.cons.call(null,root,path_parts.call(null,figwheel.client.file_reloading.fix_node_request_url.call(null,request_url))));
(require.cache[cache_path] = null);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e49745){if((e49745 instanceof Error)){
var e = e49745;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e49745;

}
}})());
});
;})(path_parts,sep,root,pred__49742,expr__49743))
} else {
if(cljs.core.truth_(pred__49742.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__49743))){
return ((function (pred__49742,expr__49743){
return (function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
deferred.addCallback(((function (deferred,pred__49742,expr__49743){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred,pred__49742,expr__49743))
);

return deferred.addErrback(((function (deferred,pred__49742,expr__49743){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred,pred__49742,expr__49743))
);
});
;})(pred__49742,expr__49743))
} else {
return ((function (pred__49742,expr__49743){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__49742,expr__49743))
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__49746,callback){
var map__49749 = p__49746;
var map__49749__$1 = ((((!((map__49749 == null)))?((((map__49749.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49749.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49749):map__49749);
var file_msg = map__49749__$1;
var request_url = cljs.core.get.call(null,map__49749__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Attempting to load "),cljs.core.str(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__49749,map__49749__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Successfully loaded "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__49749,map__49749__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__46582__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46582__auto__){
return (function (){
var f__46583__auto__ = (function (){var switch__46468__auto__ = ((function (c__46582__auto__){
return (function (state_49773){
var state_val_49774 = (state_49773[(1)]);
if((state_val_49774 === (7))){
var inst_49769 = (state_49773[(2)]);
var state_49773__$1 = state_49773;
var statearr_49775_49795 = state_49773__$1;
(statearr_49775_49795[(2)] = inst_49769);

(statearr_49775_49795[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49774 === (1))){
var state_49773__$1 = state_49773;
var statearr_49776_49796 = state_49773__$1;
(statearr_49776_49796[(2)] = null);

(statearr_49776_49796[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49774 === (4))){
var inst_49753 = (state_49773[(7)]);
var inst_49753__$1 = (state_49773[(2)]);
var state_49773__$1 = (function (){var statearr_49777 = state_49773;
(statearr_49777[(7)] = inst_49753__$1);

return statearr_49777;
})();
if(cljs.core.truth_(inst_49753__$1)){
var statearr_49778_49797 = state_49773__$1;
(statearr_49778_49797[(1)] = (5));

} else {
var statearr_49779_49798 = state_49773__$1;
(statearr_49779_49798[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49774 === (6))){
var state_49773__$1 = state_49773;
var statearr_49780_49799 = state_49773__$1;
(statearr_49780_49799[(2)] = null);

(statearr_49780_49799[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49774 === (3))){
var inst_49771 = (state_49773[(2)]);
var state_49773__$1 = state_49773;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_49773__$1,inst_49771);
} else {
if((state_val_49774 === (2))){
var state_49773__$1 = state_49773;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_49773__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_49774 === (11))){
var inst_49765 = (state_49773[(2)]);
var state_49773__$1 = (function (){var statearr_49781 = state_49773;
(statearr_49781[(8)] = inst_49765);

return statearr_49781;
})();
var statearr_49782_49800 = state_49773__$1;
(statearr_49782_49800[(2)] = null);

(statearr_49782_49800[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49774 === (9))){
var inst_49757 = (state_49773[(9)]);
var inst_49759 = (state_49773[(10)]);
var inst_49761 = inst_49759.call(null,inst_49757);
var state_49773__$1 = state_49773;
var statearr_49783_49801 = state_49773__$1;
(statearr_49783_49801[(2)] = inst_49761);

(statearr_49783_49801[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49774 === (5))){
var inst_49753 = (state_49773[(7)]);
var inst_49755 = figwheel.client.file_reloading.blocking_load.call(null,inst_49753);
var state_49773__$1 = state_49773;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_49773__$1,(8),inst_49755);
} else {
if((state_val_49774 === (10))){
var inst_49757 = (state_49773[(9)]);
var inst_49763 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_49757);
var state_49773__$1 = state_49773;
var statearr_49784_49802 = state_49773__$1;
(statearr_49784_49802[(2)] = inst_49763);

(statearr_49784_49802[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49774 === (8))){
var inst_49753 = (state_49773[(7)]);
var inst_49759 = (state_49773[(10)]);
var inst_49757 = (state_49773[(2)]);
var inst_49758 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_49759__$1 = cljs.core.get.call(null,inst_49758,inst_49753);
var state_49773__$1 = (function (){var statearr_49785 = state_49773;
(statearr_49785[(9)] = inst_49757);

(statearr_49785[(10)] = inst_49759__$1);

return statearr_49785;
})();
if(cljs.core.truth_(inst_49759__$1)){
var statearr_49786_49803 = state_49773__$1;
(statearr_49786_49803[(1)] = (9));

} else {
var statearr_49787_49804 = state_49773__$1;
(statearr_49787_49804[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__46582__auto__))
;
return ((function (switch__46468__auto__,c__46582__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__46469__auto__ = null;
var figwheel$client$file_reloading$state_machine__46469__auto____0 = (function (){
var statearr_49791 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_49791[(0)] = figwheel$client$file_reloading$state_machine__46469__auto__);

(statearr_49791[(1)] = (1));

return statearr_49791;
});
var figwheel$client$file_reloading$state_machine__46469__auto____1 = (function (state_49773){
while(true){
var ret_value__46470__auto__ = (function (){try{while(true){
var result__46471__auto__ = switch__46468__auto__.call(null,state_49773);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46471__auto__;
}
break;
}
}catch (e49792){if((e49792 instanceof Object)){
var ex__46472__auto__ = e49792;
var statearr_49793_49805 = state_49773;
(statearr_49793_49805[(5)] = ex__46472__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_49773);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e49792;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49806 = state_49773;
state_49773 = G__49806;
continue;
} else {
return ret_value__46470__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__46469__auto__ = function(state_49773){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__46469__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__46469__auto____1.call(this,state_49773);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__46469__auto____0;
figwheel$client$file_reloading$state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__46469__auto____1;
return figwheel$client$file_reloading$state_machine__46469__auto__;
})()
;})(switch__46468__auto__,c__46582__auto__))
})();
var state__46584__auto__ = (function (){var statearr_49794 = f__46583__auto__.call(null);
(statearr_49794[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46582__auto__);

return statearr_49794;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46584__auto__);
});})(c__46582__auto__))
);

return c__46582__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__49807,callback){
var map__49810 = p__49807;
var map__49810__$1 = ((((!((map__49810 == null)))?((((map__49810.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49810.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49810):map__49810);
var file_msg = map__49810__$1;
var namespace = cljs.core.get.call(null,map__49810__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__49810,map__49810__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__49810,map__49810__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__49812){
var map__49815 = p__49812;
var map__49815__$1 = ((((!((map__49815 == null)))?((((map__49815.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49815.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49815):map__49815);
var file_msg = map__49815__$1;
var namespace = cljs.core.get.call(null,map__49815__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__19145__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas));
if(and__19145__auto__){
var or__19157__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__19157__auto__)){
return or__19157__auto__;
} else {
var or__19157__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__19157__auto____$1)){
return or__19157__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__19145__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__49817,callback){
var map__49820 = p__49817;
var map__49820__$1 = ((((!((map__49820 == null)))?((((map__49820.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49820.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49820):map__49820);
var file_msg = map__49820__$1;
var request_url = cljs.core.get.call(null,map__49820__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__49820__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Figwheel: Not trying to load file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__46582__auto___49924 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46582__auto___49924,out){
return (function (){
var f__46583__auto__ = (function (){var switch__46468__auto__ = ((function (c__46582__auto___49924,out){
return (function (state_49906){
var state_val_49907 = (state_49906[(1)]);
if((state_val_49907 === (1))){
var inst_49880 = cljs.core.seq.call(null,files);
var inst_49881 = cljs.core.first.call(null,inst_49880);
var inst_49882 = cljs.core.next.call(null,inst_49880);
var inst_49883 = files;
var state_49906__$1 = (function (){var statearr_49908 = state_49906;
(statearr_49908[(7)] = inst_49883);

(statearr_49908[(8)] = inst_49881);

(statearr_49908[(9)] = inst_49882);

return statearr_49908;
})();
var statearr_49909_49925 = state_49906__$1;
(statearr_49909_49925[(2)] = null);

(statearr_49909_49925[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49907 === (2))){
var inst_49883 = (state_49906[(7)]);
var inst_49889 = (state_49906[(10)]);
var inst_49888 = cljs.core.seq.call(null,inst_49883);
var inst_49889__$1 = cljs.core.first.call(null,inst_49888);
var inst_49890 = cljs.core.next.call(null,inst_49888);
var inst_49891 = (inst_49889__$1 == null);
var inst_49892 = cljs.core.not.call(null,inst_49891);
var state_49906__$1 = (function (){var statearr_49910 = state_49906;
(statearr_49910[(11)] = inst_49890);

(statearr_49910[(10)] = inst_49889__$1);

return statearr_49910;
})();
if(inst_49892){
var statearr_49911_49926 = state_49906__$1;
(statearr_49911_49926[(1)] = (4));

} else {
var statearr_49912_49927 = state_49906__$1;
(statearr_49912_49927[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49907 === (3))){
var inst_49904 = (state_49906[(2)]);
var state_49906__$1 = state_49906;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_49906__$1,inst_49904);
} else {
if((state_val_49907 === (4))){
var inst_49889 = (state_49906[(10)]);
var inst_49894 = figwheel.client.file_reloading.reload_js_file.call(null,inst_49889);
var state_49906__$1 = state_49906;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_49906__$1,(7),inst_49894);
} else {
if((state_val_49907 === (5))){
var inst_49900 = cljs.core.async.close_BANG_.call(null,out);
var state_49906__$1 = state_49906;
var statearr_49913_49928 = state_49906__$1;
(statearr_49913_49928[(2)] = inst_49900);

(statearr_49913_49928[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49907 === (6))){
var inst_49902 = (state_49906[(2)]);
var state_49906__$1 = state_49906;
var statearr_49914_49929 = state_49906__$1;
(statearr_49914_49929[(2)] = inst_49902);

(statearr_49914_49929[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49907 === (7))){
var inst_49890 = (state_49906[(11)]);
var inst_49896 = (state_49906[(2)]);
var inst_49897 = cljs.core.async.put_BANG_.call(null,out,inst_49896);
var inst_49883 = inst_49890;
var state_49906__$1 = (function (){var statearr_49915 = state_49906;
(statearr_49915[(7)] = inst_49883);

(statearr_49915[(12)] = inst_49897);

return statearr_49915;
})();
var statearr_49916_49930 = state_49906__$1;
(statearr_49916_49930[(2)] = null);

(statearr_49916_49930[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__46582__auto___49924,out))
;
return ((function (switch__46468__auto__,c__46582__auto___49924,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__46469__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__46469__auto____0 = (function (){
var statearr_49920 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_49920[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__46469__auto__);

(statearr_49920[(1)] = (1));

return statearr_49920;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__46469__auto____1 = (function (state_49906){
while(true){
var ret_value__46470__auto__ = (function (){try{while(true){
var result__46471__auto__ = switch__46468__auto__.call(null,state_49906);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46471__auto__;
}
break;
}
}catch (e49921){if((e49921 instanceof Object)){
var ex__46472__auto__ = e49921;
var statearr_49922_49931 = state_49906;
(statearr_49922_49931[(5)] = ex__46472__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_49906);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e49921;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49932 = state_49906;
state_49906 = G__49932;
continue;
} else {
return ret_value__46470__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__46469__auto__ = function(state_49906){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__46469__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__46469__auto____1.call(this,state_49906);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__46469__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__46469__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__46469__auto__;
})()
;})(switch__46468__auto__,c__46582__auto___49924,out))
})();
var state__46584__auto__ = (function (){var statearr_49923 = f__46583__auto__.call(null);
(statearr_49923[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46582__auto___49924);

return statearr_49923;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46584__auto__);
});})(c__46582__auto___49924,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__49933,opts){
var map__49937 = p__49933;
var map__49937__$1 = ((((!((map__49937 == null)))?((((map__49937.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49937.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49937):map__49937);
var eval_body = cljs.core.get.call(null,map__49937__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__49937__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__19145__auto__ = eval_body;
if(cljs.core.truth_(and__19145__auto__)){
return typeof eval_body === 'string';
} else {
return and__19145__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Evaling file "),cljs.core.str(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e49939){var e = e49939;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Unable to evaluate "),cljs.core.str(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["figwheel.connect",null], null), null),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__6751__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__49940_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__49940_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__6751__auto__)){
var file_msg = temp__6751__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__49949){
var vec__49950 = p__49949;
var k = cljs.core.nth.call(null,vec__49950,(0),null);
var v = cljs.core.nth.call(null,vec__49950,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__49953){
var vec__49954 = p__49953;
var k = cljs.core.nth.call(null,vec__49954,(0),null);
var v = cljs.core.nth.call(null,vec__49954,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__49960,p__49961){
var map__50209 = p__49960;
var map__50209__$1 = ((((!((map__50209 == null)))?((((map__50209.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50209.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50209):map__50209);
var opts = map__50209__$1;
var before_jsload = cljs.core.get.call(null,map__50209__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__50209__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__50209__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__50210 = p__49961;
var map__50210__$1 = ((((!((map__50210 == null)))?((((map__50210.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50210.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50210):map__50210);
var msg = map__50210__$1;
var files = cljs.core.get.call(null,map__50210__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__50210__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__50210__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__46582__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46582__auto__,map__50209,map__50209__$1,opts,before_jsload,on_jsload,reload_dependents,map__50210,map__50210__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__46583__auto__ = (function (){var switch__46468__auto__ = ((function (c__46582__auto__,map__50209,map__50209__$1,opts,before_jsload,on_jsload,reload_dependents,map__50210,map__50210__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_50364){
var state_val_50365 = (state_50364[(1)]);
if((state_val_50365 === (7))){
var inst_50224 = (state_50364[(7)]);
var inst_50225 = (state_50364[(8)]);
var inst_50227 = (state_50364[(9)]);
var inst_50226 = (state_50364[(10)]);
var inst_50232 = cljs.core._nth.call(null,inst_50225,inst_50227);
var inst_50233 = figwheel.client.file_reloading.eval_body.call(null,inst_50232,opts);
var inst_50234 = (inst_50227 + (1));
var tmp50366 = inst_50224;
var tmp50367 = inst_50225;
var tmp50368 = inst_50226;
var inst_50224__$1 = tmp50366;
var inst_50225__$1 = tmp50367;
var inst_50226__$1 = tmp50368;
var inst_50227__$1 = inst_50234;
var state_50364__$1 = (function (){var statearr_50369 = state_50364;
(statearr_50369[(7)] = inst_50224__$1);

(statearr_50369[(8)] = inst_50225__$1);

(statearr_50369[(9)] = inst_50227__$1);

(statearr_50369[(10)] = inst_50226__$1);

(statearr_50369[(11)] = inst_50233);

return statearr_50369;
})();
var statearr_50370_50456 = state_50364__$1;
(statearr_50370_50456[(2)] = null);

(statearr_50370_50456[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (20))){
var inst_50267 = (state_50364[(12)]);
var inst_50275 = figwheel.client.file_reloading.sort_files.call(null,inst_50267);
var state_50364__$1 = state_50364;
var statearr_50371_50457 = state_50364__$1;
(statearr_50371_50457[(2)] = inst_50275);

(statearr_50371_50457[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (27))){
var state_50364__$1 = state_50364;
var statearr_50372_50458 = state_50364__$1;
(statearr_50372_50458[(2)] = null);

(statearr_50372_50458[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (1))){
var inst_50216 = (state_50364[(13)]);
var inst_50213 = before_jsload.call(null,files);
var inst_50214 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_50215 = (function (){return ((function (inst_50216,inst_50213,inst_50214,state_val_50365,c__46582__auto__,map__50209,map__50209__$1,opts,before_jsload,on_jsload,reload_dependents,map__50210,map__50210__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__49957_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__49957_SHARP_);
});
;})(inst_50216,inst_50213,inst_50214,state_val_50365,c__46582__auto__,map__50209,map__50209__$1,opts,before_jsload,on_jsload,reload_dependents,map__50210,map__50210__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_50216__$1 = cljs.core.filter.call(null,inst_50215,files);
var inst_50217 = cljs.core.not_empty.call(null,inst_50216__$1);
var state_50364__$1 = (function (){var statearr_50373 = state_50364;
(statearr_50373[(13)] = inst_50216__$1);

(statearr_50373[(14)] = inst_50214);

(statearr_50373[(15)] = inst_50213);

return statearr_50373;
})();
if(cljs.core.truth_(inst_50217)){
var statearr_50374_50459 = state_50364__$1;
(statearr_50374_50459[(1)] = (2));

} else {
var statearr_50375_50460 = state_50364__$1;
(statearr_50375_50460[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (24))){
var state_50364__$1 = state_50364;
var statearr_50376_50461 = state_50364__$1;
(statearr_50376_50461[(2)] = null);

(statearr_50376_50461[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (39))){
var inst_50317 = (state_50364[(16)]);
var state_50364__$1 = state_50364;
var statearr_50377_50462 = state_50364__$1;
(statearr_50377_50462[(2)] = inst_50317);

(statearr_50377_50462[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (46))){
var inst_50359 = (state_50364[(2)]);
var state_50364__$1 = state_50364;
var statearr_50378_50463 = state_50364__$1;
(statearr_50378_50463[(2)] = inst_50359);

(statearr_50378_50463[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (4))){
var inst_50261 = (state_50364[(2)]);
var inst_50262 = cljs.core.List.EMPTY;
var inst_50263 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_50262);
var inst_50264 = (function (){return ((function (inst_50261,inst_50262,inst_50263,state_val_50365,c__46582__auto__,map__50209,map__50209__$1,opts,before_jsload,on_jsload,reload_dependents,map__50210,map__50210__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__49958_SHARP_){
var and__19145__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__49958_SHARP_);
if(cljs.core.truth_(and__19145__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__49958_SHARP_));
} else {
return and__19145__auto__;
}
});
;})(inst_50261,inst_50262,inst_50263,state_val_50365,c__46582__auto__,map__50209,map__50209__$1,opts,before_jsload,on_jsload,reload_dependents,map__50210,map__50210__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_50265 = cljs.core.filter.call(null,inst_50264,files);
var inst_50266 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_50267 = cljs.core.concat.call(null,inst_50265,inst_50266);
var state_50364__$1 = (function (){var statearr_50379 = state_50364;
(statearr_50379[(17)] = inst_50261);

(statearr_50379[(12)] = inst_50267);

(statearr_50379[(18)] = inst_50263);

return statearr_50379;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_50380_50464 = state_50364__$1;
(statearr_50380_50464[(1)] = (16));

} else {
var statearr_50381_50465 = state_50364__$1;
(statearr_50381_50465[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (15))){
var inst_50251 = (state_50364[(2)]);
var state_50364__$1 = state_50364;
var statearr_50382_50466 = state_50364__$1;
(statearr_50382_50466[(2)] = inst_50251);

(statearr_50382_50466[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (21))){
var inst_50277 = (state_50364[(19)]);
var inst_50277__$1 = (state_50364[(2)]);
var inst_50278 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_50277__$1);
var state_50364__$1 = (function (){var statearr_50383 = state_50364;
(statearr_50383[(19)] = inst_50277__$1);

return statearr_50383;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_50364__$1,(22),inst_50278);
} else {
if((state_val_50365 === (31))){
var inst_50362 = (state_50364[(2)]);
var state_50364__$1 = state_50364;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_50364__$1,inst_50362);
} else {
if((state_val_50365 === (32))){
var inst_50317 = (state_50364[(16)]);
var inst_50322 = inst_50317.cljs$lang$protocol_mask$partition0$;
var inst_50323 = (inst_50322 & (64));
var inst_50324 = inst_50317.cljs$core$ISeq$;
var inst_50325 = (cljs.core.PROTOCOL_SENTINEL === inst_50324);
var inst_50326 = (inst_50323) || (inst_50325);
var state_50364__$1 = state_50364;
if(cljs.core.truth_(inst_50326)){
var statearr_50384_50467 = state_50364__$1;
(statearr_50384_50467[(1)] = (35));

} else {
var statearr_50385_50468 = state_50364__$1;
(statearr_50385_50468[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (40))){
var inst_50339 = (state_50364[(20)]);
var inst_50338 = (state_50364[(2)]);
var inst_50339__$1 = cljs.core.get.call(null,inst_50338,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_50340 = cljs.core.get.call(null,inst_50338,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_50341 = cljs.core.not_empty.call(null,inst_50339__$1);
var state_50364__$1 = (function (){var statearr_50386 = state_50364;
(statearr_50386[(20)] = inst_50339__$1);

(statearr_50386[(21)] = inst_50340);

return statearr_50386;
})();
if(cljs.core.truth_(inst_50341)){
var statearr_50387_50469 = state_50364__$1;
(statearr_50387_50469[(1)] = (41));

} else {
var statearr_50388_50470 = state_50364__$1;
(statearr_50388_50470[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (33))){
var state_50364__$1 = state_50364;
var statearr_50389_50471 = state_50364__$1;
(statearr_50389_50471[(2)] = false);

(statearr_50389_50471[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (13))){
var inst_50237 = (state_50364[(22)]);
var inst_50241 = cljs.core.chunk_first.call(null,inst_50237);
var inst_50242 = cljs.core.chunk_rest.call(null,inst_50237);
var inst_50243 = cljs.core.count.call(null,inst_50241);
var inst_50224 = inst_50242;
var inst_50225 = inst_50241;
var inst_50226 = inst_50243;
var inst_50227 = (0);
var state_50364__$1 = (function (){var statearr_50390 = state_50364;
(statearr_50390[(7)] = inst_50224);

(statearr_50390[(8)] = inst_50225);

(statearr_50390[(9)] = inst_50227);

(statearr_50390[(10)] = inst_50226);

return statearr_50390;
})();
var statearr_50391_50472 = state_50364__$1;
(statearr_50391_50472[(2)] = null);

(statearr_50391_50472[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (22))){
var inst_50280 = (state_50364[(23)]);
var inst_50281 = (state_50364[(24)]);
var inst_50277 = (state_50364[(19)]);
var inst_50285 = (state_50364[(25)]);
var inst_50280__$1 = (state_50364[(2)]);
var inst_50281__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_50280__$1);
var inst_50282 = (function (){var all_files = inst_50277;
var res_SINGLEQUOTE_ = inst_50280__$1;
var res = inst_50281__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_50280,inst_50281,inst_50277,inst_50285,inst_50280__$1,inst_50281__$1,state_val_50365,c__46582__auto__,map__50209,map__50209__$1,opts,before_jsload,on_jsload,reload_dependents,map__50210,map__50210__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__49959_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__49959_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_50280,inst_50281,inst_50277,inst_50285,inst_50280__$1,inst_50281__$1,state_val_50365,c__46582__auto__,map__50209,map__50209__$1,opts,before_jsload,on_jsload,reload_dependents,map__50210,map__50210__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_50283 = cljs.core.filter.call(null,inst_50282,inst_50280__$1);
var inst_50284 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_50285__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_50284);
var inst_50286 = cljs.core.not_empty.call(null,inst_50285__$1);
var state_50364__$1 = (function (){var statearr_50392 = state_50364;
(statearr_50392[(23)] = inst_50280__$1);

(statearr_50392[(24)] = inst_50281__$1);

(statearr_50392[(26)] = inst_50283);

(statearr_50392[(25)] = inst_50285__$1);

return statearr_50392;
})();
if(cljs.core.truth_(inst_50286)){
var statearr_50393_50473 = state_50364__$1;
(statearr_50393_50473[(1)] = (23));

} else {
var statearr_50394_50474 = state_50364__$1;
(statearr_50394_50474[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (36))){
var state_50364__$1 = state_50364;
var statearr_50395_50475 = state_50364__$1;
(statearr_50395_50475[(2)] = false);

(statearr_50395_50475[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (41))){
var inst_50339 = (state_50364[(20)]);
var inst_50343 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_50344 = cljs.core.map.call(null,inst_50343,inst_50339);
var inst_50345 = cljs.core.pr_str.call(null,inst_50344);
var inst_50346 = [cljs.core.str("figwheel-no-load meta-data: "),cljs.core.str(inst_50345)].join('');
var inst_50347 = figwheel.client.utils.log.call(null,inst_50346);
var state_50364__$1 = state_50364;
var statearr_50396_50476 = state_50364__$1;
(statearr_50396_50476[(2)] = inst_50347);

(statearr_50396_50476[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (43))){
var inst_50340 = (state_50364[(21)]);
var inst_50350 = (state_50364[(2)]);
var inst_50351 = cljs.core.not_empty.call(null,inst_50340);
var state_50364__$1 = (function (){var statearr_50397 = state_50364;
(statearr_50397[(27)] = inst_50350);

return statearr_50397;
})();
if(cljs.core.truth_(inst_50351)){
var statearr_50398_50477 = state_50364__$1;
(statearr_50398_50477[(1)] = (44));

} else {
var statearr_50399_50478 = state_50364__$1;
(statearr_50399_50478[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (29))){
var inst_50280 = (state_50364[(23)]);
var inst_50281 = (state_50364[(24)]);
var inst_50283 = (state_50364[(26)]);
var inst_50277 = (state_50364[(19)]);
var inst_50285 = (state_50364[(25)]);
var inst_50317 = (state_50364[(16)]);
var inst_50313 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_50316 = (function (){var all_files = inst_50277;
var res_SINGLEQUOTE_ = inst_50280;
var res = inst_50281;
var files_not_loaded = inst_50283;
var dependencies_that_loaded = inst_50285;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_50280,inst_50281,inst_50283,inst_50277,inst_50285,inst_50317,inst_50313,state_val_50365,c__46582__auto__,map__50209,map__50209__$1,opts,before_jsload,on_jsload,reload_dependents,map__50210,map__50210__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__50315){
var map__50400 = p__50315;
var map__50400__$1 = ((((!((map__50400 == null)))?((((map__50400.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50400.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50400):map__50400);
var namespace = cljs.core.get.call(null,map__50400__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_50280,inst_50281,inst_50283,inst_50277,inst_50285,inst_50317,inst_50313,state_val_50365,c__46582__auto__,map__50209,map__50209__$1,opts,before_jsload,on_jsload,reload_dependents,map__50210,map__50210__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_50317__$1 = cljs.core.group_by.call(null,inst_50316,inst_50283);
var inst_50319 = (inst_50317__$1 == null);
var inst_50320 = cljs.core.not.call(null,inst_50319);
var state_50364__$1 = (function (){var statearr_50402 = state_50364;
(statearr_50402[(28)] = inst_50313);

(statearr_50402[(16)] = inst_50317__$1);

return statearr_50402;
})();
if(inst_50320){
var statearr_50403_50479 = state_50364__$1;
(statearr_50403_50479[(1)] = (32));

} else {
var statearr_50404_50480 = state_50364__$1;
(statearr_50404_50480[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (44))){
var inst_50340 = (state_50364[(21)]);
var inst_50353 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_50340);
var inst_50354 = cljs.core.pr_str.call(null,inst_50353);
var inst_50355 = [cljs.core.str("not required: "),cljs.core.str(inst_50354)].join('');
var inst_50356 = figwheel.client.utils.log.call(null,inst_50355);
var state_50364__$1 = state_50364;
var statearr_50405_50481 = state_50364__$1;
(statearr_50405_50481[(2)] = inst_50356);

(statearr_50405_50481[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (6))){
var inst_50258 = (state_50364[(2)]);
var state_50364__$1 = state_50364;
var statearr_50406_50482 = state_50364__$1;
(statearr_50406_50482[(2)] = inst_50258);

(statearr_50406_50482[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (28))){
var inst_50283 = (state_50364[(26)]);
var inst_50310 = (state_50364[(2)]);
var inst_50311 = cljs.core.not_empty.call(null,inst_50283);
var state_50364__$1 = (function (){var statearr_50407 = state_50364;
(statearr_50407[(29)] = inst_50310);

return statearr_50407;
})();
if(cljs.core.truth_(inst_50311)){
var statearr_50408_50483 = state_50364__$1;
(statearr_50408_50483[(1)] = (29));

} else {
var statearr_50409_50484 = state_50364__$1;
(statearr_50409_50484[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (25))){
var inst_50281 = (state_50364[(24)]);
var inst_50297 = (state_50364[(2)]);
var inst_50298 = cljs.core.not_empty.call(null,inst_50281);
var state_50364__$1 = (function (){var statearr_50410 = state_50364;
(statearr_50410[(30)] = inst_50297);

return statearr_50410;
})();
if(cljs.core.truth_(inst_50298)){
var statearr_50411_50485 = state_50364__$1;
(statearr_50411_50485[(1)] = (26));

} else {
var statearr_50412_50486 = state_50364__$1;
(statearr_50412_50486[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (34))){
var inst_50333 = (state_50364[(2)]);
var state_50364__$1 = state_50364;
if(cljs.core.truth_(inst_50333)){
var statearr_50413_50487 = state_50364__$1;
(statearr_50413_50487[(1)] = (38));

} else {
var statearr_50414_50488 = state_50364__$1;
(statearr_50414_50488[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (17))){
var state_50364__$1 = state_50364;
var statearr_50415_50489 = state_50364__$1;
(statearr_50415_50489[(2)] = recompile_dependents);

(statearr_50415_50489[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (3))){
var state_50364__$1 = state_50364;
var statearr_50416_50490 = state_50364__$1;
(statearr_50416_50490[(2)] = null);

(statearr_50416_50490[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (12))){
var inst_50254 = (state_50364[(2)]);
var state_50364__$1 = state_50364;
var statearr_50417_50491 = state_50364__$1;
(statearr_50417_50491[(2)] = inst_50254);

(statearr_50417_50491[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (2))){
var inst_50216 = (state_50364[(13)]);
var inst_50223 = cljs.core.seq.call(null,inst_50216);
var inst_50224 = inst_50223;
var inst_50225 = null;
var inst_50226 = (0);
var inst_50227 = (0);
var state_50364__$1 = (function (){var statearr_50418 = state_50364;
(statearr_50418[(7)] = inst_50224);

(statearr_50418[(8)] = inst_50225);

(statearr_50418[(9)] = inst_50227);

(statearr_50418[(10)] = inst_50226);

return statearr_50418;
})();
var statearr_50419_50492 = state_50364__$1;
(statearr_50419_50492[(2)] = null);

(statearr_50419_50492[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (23))){
var inst_50280 = (state_50364[(23)]);
var inst_50281 = (state_50364[(24)]);
var inst_50283 = (state_50364[(26)]);
var inst_50277 = (state_50364[(19)]);
var inst_50285 = (state_50364[(25)]);
var inst_50288 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_50290 = (function (){var all_files = inst_50277;
var res_SINGLEQUOTE_ = inst_50280;
var res = inst_50281;
var files_not_loaded = inst_50283;
var dependencies_that_loaded = inst_50285;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_50280,inst_50281,inst_50283,inst_50277,inst_50285,inst_50288,state_val_50365,c__46582__auto__,map__50209,map__50209__$1,opts,before_jsload,on_jsload,reload_dependents,map__50210,map__50210__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__50289){
var map__50420 = p__50289;
var map__50420__$1 = ((((!((map__50420 == null)))?((((map__50420.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50420.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50420):map__50420);
var request_url = cljs.core.get.call(null,map__50420__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_50280,inst_50281,inst_50283,inst_50277,inst_50285,inst_50288,state_val_50365,c__46582__auto__,map__50209,map__50209__$1,opts,before_jsload,on_jsload,reload_dependents,map__50210,map__50210__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_50291 = cljs.core.reverse.call(null,inst_50285);
var inst_50292 = cljs.core.map.call(null,inst_50290,inst_50291);
var inst_50293 = cljs.core.pr_str.call(null,inst_50292);
var inst_50294 = figwheel.client.utils.log.call(null,inst_50293);
var state_50364__$1 = (function (){var statearr_50422 = state_50364;
(statearr_50422[(31)] = inst_50288);

return statearr_50422;
})();
var statearr_50423_50493 = state_50364__$1;
(statearr_50423_50493[(2)] = inst_50294);

(statearr_50423_50493[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (35))){
var state_50364__$1 = state_50364;
var statearr_50424_50494 = state_50364__$1;
(statearr_50424_50494[(2)] = true);

(statearr_50424_50494[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (19))){
var inst_50267 = (state_50364[(12)]);
var inst_50273 = figwheel.client.file_reloading.expand_files.call(null,inst_50267);
var state_50364__$1 = state_50364;
var statearr_50425_50495 = state_50364__$1;
(statearr_50425_50495[(2)] = inst_50273);

(statearr_50425_50495[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (11))){
var state_50364__$1 = state_50364;
var statearr_50426_50496 = state_50364__$1;
(statearr_50426_50496[(2)] = null);

(statearr_50426_50496[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (9))){
var inst_50256 = (state_50364[(2)]);
var state_50364__$1 = state_50364;
var statearr_50427_50497 = state_50364__$1;
(statearr_50427_50497[(2)] = inst_50256);

(statearr_50427_50497[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (5))){
var inst_50227 = (state_50364[(9)]);
var inst_50226 = (state_50364[(10)]);
var inst_50229 = (inst_50227 < inst_50226);
var inst_50230 = inst_50229;
var state_50364__$1 = state_50364;
if(cljs.core.truth_(inst_50230)){
var statearr_50428_50498 = state_50364__$1;
(statearr_50428_50498[(1)] = (7));

} else {
var statearr_50429_50499 = state_50364__$1;
(statearr_50429_50499[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (14))){
var inst_50237 = (state_50364[(22)]);
var inst_50246 = cljs.core.first.call(null,inst_50237);
var inst_50247 = figwheel.client.file_reloading.eval_body.call(null,inst_50246,opts);
var inst_50248 = cljs.core.next.call(null,inst_50237);
var inst_50224 = inst_50248;
var inst_50225 = null;
var inst_50226 = (0);
var inst_50227 = (0);
var state_50364__$1 = (function (){var statearr_50430 = state_50364;
(statearr_50430[(7)] = inst_50224);

(statearr_50430[(32)] = inst_50247);

(statearr_50430[(8)] = inst_50225);

(statearr_50430[(9)] = inst_50227);

(statearr_50430[(10)] = inst_50226);

return statearr_50430;
})();
var statearr_50431_50500 = state_50364__$1;
(statearr_50431_50500[(2)] = null);

(statearr_50431_50500[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (45))){
var state_50364__$1 = state_50364;
var statearr_50432_50501 = state_50364__$1;
(statearr_50432_50501[(2)] = null);

(statearr_50432_50501[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (26))){
var inst_50280 = (state_50364[(23)]);
var inst_50281 = (state_50364[(24)]);
var inst_50283 = (state_50364[(26)]);
var inst_50277 = (state_50364[(19)]);
var inst_50285 = (state_50364[(25)]);
var inst_50300 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_50302 = (function (){var all_files = inst_50277;
var res_SINGLEQUOTE_ = inst_50280;
var res = inst_50281;
var files_not_loaded = inst_50283;
var dependencies_that_loaded = inst_50285;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_50280,inst_50281,inst_50283,inst_50277,inst_50285,inst_50300,state_val_50365,c__46582__auto__,map__50209,map__50209__$1,opts,before_jsload,on_jsload,reload_dependents,map__50210,map__50210__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__50301){
var map__50433 = p__50301;
var map__50433__$1 = ((((!((map__50433 == null)))?((((map__50433.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50433.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50433):map__50433);
var namespace = cljs.core.get.call(null,map__50433__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__50433__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_50280,inst_50281,inst_50283,inst_50277,inst_50285,inst_50300,state_val_50365,c__46582__auto__,map__50209,map__50209__$1,opts,before_jsload,on_jsload,reload_dependents,map__50210,map__50210__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_50303 = cljs.core.map.call(null,inst_50302,inst_50281);
var inst_50304 = cljs.core.pr_str.call(null,inst_50303);
var inst_50305 = figwheel.client.utils.log.call(null,inst_50304);
var inst_50306 = (function (){var all_files = inst_50277;
var res_SINGLEQUOTE_ = inst_50280;
var res = inst_50281;
var files_not_loaded = inst_50283;
var dependencies_that_loaded = inst_50285;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_50280,inst_50281,inst_50283,inst_50277,inst_50285,inst_50300,inst_50302,inst_50303,inst_50304,inst_50305,state_val_50365,c__46582__auto__,map__50209,map__50209__$1,opts,before_jsload,on_jsload,reload_dependents,map__50210,map__50210__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_50280,inst_50281,inst_50283,inst_50277,inst_50285,inst_50300,inst_50302,inst_50303,inst_50304,inst_50305,state_val_50365,c__46582__auto__,map__50209,map__50209__$1,opts,before_jsload,on_jsload,reload_dependents,map__50210,map__50210__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_50307 = setTimeout(inst_50306,(10));
var state_50364__$1 = (function (){var statearr_50435 = state_50364;
(statearr_50435[(33)] = inst_50300);

(statearr_50435[(34)] = inst_50305);

return statearr_50435;
})();
var statearr_50436_50502 = state_50364__$1;
(statearr_50436_50502[(2)] = inst_50307);

(statearr_50436_50502[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (16))){
var state_50364__$1 = state_50364;
var statearr_50437_50503 = state_50364__$1;
(statearr_50437_50503[(2)] = reload_dependents);

(statearr_50437_50503[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (38))){
var inst_50317 = (state_50364[(16)]);
var inst_50335 = cljs.core.apply.call(null,cljs.core.hash_map,inst_50317);
var state_50364__$1 = state_50364;
var statearr_50438_50504 = state_50364__$1;
(statearr_50438_50504[(2)] = inst_50335);

(statearr_50438_50504[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (30))){
var state_50364__$1 = state_50364;
var statearr_50439_50505 = state_50364__$1;
(statearr_50439_50505[(2)] = null);

(statearr_50439_50505[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (10))){
var inst_50237 = (state_50364[(22)]);
var inst_50239 = cljs.core.chunked_seq_QMARK_.call(null,inst_50237);
var state_50364__$1 = state_50364;
if(inst_50239){
var statearr_50440_50506 = state_50364__$1;
(statearr_50440_50506[(1)] = (13));

} else {
var statearr_50441_50507 = state_50364__$1;
(statearr_50441_50507[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (18))){
var inst_50271 = (state_50364[(2)]);
var state_50364__$1 = state_50364;
if(cljs.core.truth_(inst_50271)){
var statearr_50442_50508 = state_50364__$1;
(statearr_50442_50508[(1)] = (19));

} else {
var statearr_50443_50509 = state_50364__$1;
(statearr_50443_50509[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (42))){
var state_50364__$1 = state_50364;
var statearr_50444_50510 = state_50364__$1;
(statearr_50444_50510[(2)] = null);

(statearr_50444_50510[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (37))){
var inst_50330 = (state_50364[(2)]);
var state_50364__$1 = state_50364;
var statearr_50445_50511 = state_50364__$1;
(statearr_50445_50511[(2)] = inst_50330);

(statearr_50445_50511[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50365 === (8))){
var inst_50224 = (state_50364[(7)]);
var inst_50237 = (state_50364[(22)]);
var inst_50237__$1 = cljs.core.seq.call(null,inst_50224);
var state_50364__$1 = (function (){var statearr_50446 = state_50364;
(statearr_50446[(22)] = inst_50237__$1);

return statearr_50446;
})();
if(inst_50237__$1){
var statearr_50447_50512 = state_50364__$1;
(statearr_50447_50512[(1)] = (10));

} else {
var statearr_50448_50513 = state_50364__$1;
(statearr_50448_50513[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46582__auto__,map__50209,map__50209__$1,opts,before_jsload,on_jsload,reload_dependents,map__50210,map__50210__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__46468__auto__,c__46582__auto__,map__50209,map__50209__$1,opts,before_jsload,on_jsload,reload_dependents,map__50210,map__50210__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__46469__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__46469__auto____0 = (function (){
var statearr_50452 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_50452[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__46469__auto__);

(statearr_50452[(1)] = (1));

return statearr_50452;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__46469__auto____1 = (function (state_50364){
while(true){
var ret_value__46470__auto__ = (function (){try{while(true){
var result__46471__auto__ = switch__46468__auto__.call(null,state_50364);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46471__auto__;
}
break;
}
}catch (e50453){if((e50453 instanceof Object)){
var ex__46472__auto__ = e50453;
var statearr_50454_50514 = state_50364;
(statearr_50454_50514[(5)] = ex__46472__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_50364);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e50453;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50515 = state_50364;
state_50364 = G__50515;
continue;
} else {
return ret_value__46470__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__46469__auto__ = function(state_50364){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__46469__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__46469__auto____1.call(this,state_50364);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__46469__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__46469__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__46469__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__46469__auto__;
})()
;})(switch__46468__auto__,c__46582__auto__,map__50209,map__50209__$1,opts,before_jsload,on_jsload,reload_dependents,map__50210,map__50210__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__46584__auto__ = (function (){var statearr_50455 = f__46583__auto__.call(null);
(statearr_50455[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46582__auto__);

return statearr_50455;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46584__auto__);
});})(c__46582__auto__,map__50209,map__50209__$1,opts,before_jsload,on_jsload,reload_dependents,map__50210,map__50210__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__46582__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str(location.protocol),cljs.core.str("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__50518,link){
var map__50521 = p__50518;
var map__50521__$1 = ((((!((map__50521 == null)))?((((map__50521.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50521.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50521):map__50521);
var file = cljs.core.get.call(null,map__50521__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__6753__auto__ = link.href;
if(cljs.core.truth_(temp__6753__auto__)){
var link_href = temp__6753__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__6753__auto__,map__50521,map__50521__$1,file){
return (function (p1__50516_SHARP_,p2__50517_SHARP_){
if(cljs.core._EQ_.call(null,p1__50516_SHARP_,p2__50517_SHARP_)){
return p1__50516_SHARP_;
} else {
return false;
}
});})(link_href,temp__6753__auto__,map__50521,map__50521__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__6753__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__50527){
var map__50528 = p__50527;
var map__50528__$1 = ((((!((map__50528 == null)))?((((map__50528.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50528.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50528):map__50528);
var match_length = cljs.core.get.call(null,map__50528__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__50528__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__50523_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__50523_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__6753__auto__)){
var res = temp__6753__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.add_link_to_doc = (function figwheel$client$file_reloading$add_link_to_doc(var_args){
var args50530 = [];
var len__20433__auto___50533 = arguments.length;
var i__20434__auto___50534 = (0);
while(true){
if((i__20434__auto___50534 < len__20433__auto___50533)){
args50530.push((arguments[i__20434__auto___50534]));

var G__50535 = (i__20434__auto___50534 + (1));
i__20434__auto___50534 = G__50535;
continue;
} else {
}
break;
}

var G__50532 = args50530.length;
switch (G__50532) {
case 1:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args50530.length)].join('')));

}
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = (function (new_link){
return (document.getElementsByTagName("head")[(0)]).appendChild(new_link);
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = (function (orig_link,klone){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
return parent.removeChild(orig_link);
});})(parent))
,(300));
});

figwheel.client.file_reloading.add_link_to_doc.cljs$lang$maxFixedArity = 2;

figwheel.client.file_reloading.distictify = (function figwheel$client$file_reloading$distictify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__50537_SHARP_,p2__50538_SHARP_){
return cljs.core.assoc.call(null,p1__50537_SHARP_,cljs.core.get.call(null,p2__50538_SHARP_,key),p2__50538_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(p__50539){
var map__50542 = p__50539;
var map__50542__$1 = ((((!((map__50542 == null)))?((((map__50542.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50542.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50542):map__50542);
var f_data = map__50542__$1;
var file = cljs.core.get.call(null,map__50542__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__6753__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__6753__auto__)){
var link = temp__6753__auto__;
return figwheel.client.file_reloading.add_link_to_doc.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href));
} else {
return null;
}
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__50544,p__50545){
var map__50554 = p__50544;
var map__50554__$1 = ((((!((map__50554 == null)))?((((map__50554.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50554.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50554):map__50554);
var opts = map__50554__$1;
var on_cssload = cljs.core.get.call(null,map__50554__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__50555 = p__50545;
var map__50555__$1 = ((((!((map__50555 == null)))?((((map__50555.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50555.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50555):map__50555);
var files_msg = map__50555__$1;
var files = cljs.core.get.call(null,map__50555__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var seq__50558_50562 = cljs.core.seq.call(null,figwheel.client.file_reloading.distictify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
var chunk__50559_50563 = null;
var count__50560_50564 = (0);
var i__50561_50565 = (0);
while(true){
if((i__50561_50565 < count__50560_50564)){
var f_50566 = cljs.core._nth.call(null,chunk__50559_50563,i__50561_50565);
figwheel.client.file_reloading.reload_css_file.call(null,f_50566);

var G__50567 = seq__50558_50562;
var G__50568 = chunk__50559_50563;
var G__50569 = count__50560_50564;
var G__50570 = (i__50561_50565 + (1));
seq__50558_50562 = G__50567;
chunk__50559_50563 = G__50568;
count__50560_50564 = G__50569;
i__50561_50565 = G__50570;
continue;
} else {
var temp__6753__auto___50571 = cljs.core.seq.call(null,seq__50558_50562);
if(temp__6753__auto___50571){
var seq__50558_50572__$1 = temp__6753__auto___50571;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__50558_50572__$1)){
var c__20063__auto___50573 = cljs.core.chunk_first.call(null,seq__50558_50572__$1);
var G__50574 = cljs.core.chunk_rest.call(null,seq__50558_50572__$1);
var G__50575 = c__20063__auto___50573;
var G__50576 = cljs.core.count.call(null,c__20063__auto___50573);
var G__50577 = (0);
seq__50558_50562 = G__50574;
chunk__50559_50563 = G__50575;
count__50560_50564 = G__50576;
i__50561_50565 = G__50577;
continue;
} else {
var f_50578 = cljs.core.first.call(null,seq__50558_50572__$1);
figwheel.client.file_reloading.reload_css_file.call(null,f_50578);

var G__50579 = cljs.core.next.call(null,seq__50558_50572__$1);
var G__50580 = null;
var G__50581 = (0);
var G__50582 = (0);
seq__50558_50562 = G__50579;
chunk__50559_50563 = G__50580;
count__50560_50564 = G__50581;
i__50561_50565 = G__50582;
continue;
}
} else {
}
}
break;
}

return setTimeout(((function (map__50554,map__50554__$1,opts,on_cssload,map__50555,map__50555__$1,files_msg,files){
return (function (){
figwheel.client.file_reloading.on_cssload_custom_event.call(null,files);

return on_cssload.call(null,files);
});})(map__50554,map__50554__$1,opts,on_cssload,map__50555,map__50555__$1,files_msg,files))
,(100));
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1528140065521