// Compiled by ClojureScript 1.9.293 {}
goog.provide('hasch.core');
goog.require('cljs.core');
goog.require('hasch.benc');
goog.require('hasch.base64');
goog.require('hasch.platform');
hasch.core.uuid4 = hasch.platform.uuid4;
hasch.core.uuid5 = hasch.platform.uuid5;
hasch.core.hash__GT_str = hasch.platform.hash__GT_str;
/**
 * Hash an edn value with SHA-512 by default or a compatible hash function of choice.
 * 
 *   Please use the write-handlers only in legacy cases and rather extend the PHashCoercion
 *   protocol to your own types.
 */
hasch.core.edn_hash = (function hasch$core$edn_hash(var_args){
var args10269 = [];
var len__8301__auto___10272 = arguments.length;
var i__8302__auto___10273 = (0);
while(true){
if((i__8302__auto___10273 < len__8301__auto___10272)){
args10269.push((arguments[i__8302__auto___10273]));

var G__10274 = (i__8302__auto___10273 + (1));
i__8302__auto___10273 = G__10274;
continue;
} else {
}
break;
}

var G__10271 = args10269.length;
switch (G__10271) {
case 1:
return hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10269.length)].join('')));

}
});

hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$1 = (function (val){
return hasch.core.edn_hash.call(null,val,cljs.core.PersistentArrayMap.EMPTY);
});

hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$2 = (function (val,write_handlers){
return hasch.core.edn_hash.call(null,val,hasch.platform.sha512_message_digest,write_handlers);
});

hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$3 = (function (val,md_create_fn,write_handlers){
return cljs.core.map.call(null,(function (p1__10268_SHARP_){
if((p1__10268_SHARP_ < (0))){
return (p1__10268_SHARP_ + (256));
} else {
return p1__10268_SHARP_;
}
}),hasch.benc.digest.call(null,hasch.benc._coerce.call(null,val,md_create_fn,(function (){var or__7085__auto__ = write_handlers;
if(cljs.core.truth_(or__7085__auto__)){
return or__7085__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})()),md_create_fn));
});

hasch.core.edn_hash.cljs$lang$maxFixedArity = 3;

/**
 * Creates random UUID-4 without argument or UUID-5 for the argument value.
 * 
 *   Optionally an incognito-style write-handlers map can be supplied,
 *   which describes record serialization in terms of Clojure data
 *   structures.
 */
hasch.core.uuid = (function hasch$core$uuid(var_args){
var args10276 = [];
var len__8301__auto___10284 = arguments.length;
var i__8302__auto___10285 = (0);
while(true){
if((i__8302__auto___10285 < len__8301__auto___10284)){
args10276.push((arguments[i__8302__auto___10285]));

var G__10286 = (i__8302__auto___10285 + (1));
i__8302__auto___10285 = G__10286;
continue;
} else {
}
break;
}

var G__10280 = args10276.length;
switch (G__10280) {
case 0:
return hasch.core.uuid.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__8324__auto__ = (new cljs.core.IndexedSeq(args10276.slice((1)),(0),null));
return hasch.core.uuid.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8324__auto__);

}
});

hasch.core.uuid.cljs$core$IFn$_invoke$arity$0 = (function (){
return hasch.core.uuid4.call(null);
});

hasch.core.uuid.cljs$core$IFn$_invoke$arity$variadic = (function (val,p__10281){
var map__10282 = p__10281;
var map__10282__$1 = ((((!((map__10282 == null)))?((((map__10282.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10282.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10282):map__10282);
var write_handlers = cljs.core.get.call(null,map__10282__$1,new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911));
return hasch.core.uuid5.call(null,hasch.core.edn_hash.call(null,val,write_handlers));
});

hasch.core.uuid.cljs$lang$applyTo = (function (seq10277){
var G__10278 = cljs.core.first.call(null,seq10277);
var seq10277__$1 = cljs.core.next.call(null,seq10277);
return hasch.core.uuid.cljs$core$IFn$_invoke$arity$variadic(G__10278,seq10277__$1);
});

hasch.core.uuid.cljs$lang$maxFixedArity = (1);

/**
 * Calculates a sequential UUID as described in
 *   https://github.com/clojure-cookbook/clojure-cookbook/blob/master/01_primitive-data/1-24_uuids.asciidoc
 */
hasch.core.squuid = (function hasch$core$squuid(var_args){
var args10288 = [];
var len__8301__auto___10291 = arguments.length;
var i__8302__auto___10292 = (0);
while(true){
if((i__8302__auto___10292 < len__8301__auto___10291)){
args10288.push((arguments[i__8302__auto___10292]));

var G__10293 = (i__8302__auto___10292 + (1));
i__8302__auto___10292 = G__10293;
continue;
} else {
}
break;
}

var G__10290 = args10288.length;
switch (G__10290) {
case 0:
return hasch.core.squuid.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return hasch.core.squuid.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10288.length)].join('')));

}
});

hasch.core.squuid.cljs$core$IFn$_invoke$arity$0 = (function (){
return hasch.core.squuid.call(null,hasch.core.uuid4.call(null));
});

hasch.core.squuid.cljs$core$IFn$_invoke$arity$1 = (function (uuid){
var time = (new Date()).getTime();
var secs = cljs.core.quot.call(null,time,(1000));
var prefix = secs.toString((16));
return cljs.core.uuid.call(null,[cljs.core.str(prefix),cljs.core.str(cljs.core.subs.call(null,[cljs.core.str(uuid)].join(''),(8)))].join(''));
});

hasch.core.squuid.cljs$lang$maxFixedArity = 1;

/**
 * Provides a base64 encoded string of the edn-hash of a value val. This contains
 *   all bits of the hash compared to 128 bits for the UUID-5. Both should be safe,
 *   but b64-hash is safer towards collisions.
 */
hasch.core.b64_hash = (function hasch$core$b64_hash(val){
return hasch.base64.encode.call(null,cljs.core.clj__GT_js.call(null,hasch.core.edn_hash.call(null,val)));
});
