# Gezwitscher

A basic wrapper around the java [twitter4j](http://twitter4j.org/en/index.html) framework for the [Twitter API](https://dev.twitter.com/docs). gezwitscher only supports [status/filter stream](https://dev.twitter.com/streaming/reference/post/statuses/filter) from the Streaming API. Furthermore [search](https://dev.twitter.com/rest/reference/get/search/tweets), [user timeline](https://dev.twitter.com/rest/reference/get/statuses/user_timeline) and [update status](https://dev.twitter.com/rest/reference/post/statuses/update) APIs are provided by the REST and POST API.

Authentification is required. Refer to the [documentation](https://dev.twitter.com/docs/auth/using-oauth) for aquiring the credentials.

A a simple slightly outdated collector using articles published on Twitter [ceres](https://github.com/kordano/ceres) is using this library. There is also [twitter-collector](https://github.com/replikativ/twitter-collector) feeding tweets into [replikativ](https://github.com/replikativ/replikativ).

## Usage

To include `gezwitscher` in your project, add the following to your project.clj dependencies:

```clojure
[gezwitscher "0.1.2-SNAPSHOT"]
```

Punch in the API keys generated by twitter. You should find them in your twitter application management. **Tip**: Do not copy your keys in any form in your code otherwise your application could be compromised if you build an open source application. Set them for example in your environment variables or read them from a local configuration file.

```clojure
(ns example.core
  (:require [gezwitscher.core :refer [gezwitscher]]))

;; the credentials should be specified as follows
(def creds
  {:consumer-key "****" 
   :consumer-secret "****"
   :access-token "****"
   :access-token-secret "****"})

(def close-stream-fn
      (stream
       credentials
       [123456 & twitter-ids-to-follow]
       ["topic1" "ecology" "politics" "arduino"]
       (fn [new-tweet] (println new-tweet))
       (fn [e] (println e))))
```

## License

Copyright © 2014-2015 Konrad Kühne, 2016 Christian Weilbach

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
