// Compiled by ClojureScript 1.8.34 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('goog.Uri');
goog.require('goog.net.jsloader');
goog.require('cljs.core.async');
goog.require('goog.object');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__18374__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__18374__auto__){
return or__18374__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.fix_node_request_url = (function figwheel$client$file_reloading$fix_node_request_url(url){

if(cljs.core.truth_(goog.string.startsWith(url,"../"))){
return clojure.string.replace.call(null,url,"../","");
} else {
return [cljs.core.str("goog/"),cljs.core.str(url)].join('');
}
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__18374__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, ["svgpan.SvgPan",null,"far.out",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__18374__auto__)){
return or__18374__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__25062_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__25062_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([name], true));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([parent_ns], true));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__25067 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__25068 = null;
var count__25069 = (0);
var i__25070 = (0);
while(true){
if((i__25070 < count__25069)){
var n = cljs.core._nth.call(null,chunk__25068,i__25070);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__25071 = seq__25067;
var G__25072 = chunk__25068;
var G__25073 = count__25069;
var G__25074 = (i__25070 + (1));
seq__25067 = G__25071;
chunk__25068 = G__25072;
count__25069 = G__25073;
i__25070 = G__25074;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__25067);
if(temp__4425__auto__){
var seq__25067__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25067__$1)){
var c__19185__auto__ = cljs.core.chunk_first.call(null,seq__25067__$1);
var G__25075 = cljs.core.chunk_rest.call(null,seq__25067__$1);
var G__25076 = c__19185__auto__;
var G__25077 = cljs.core.count.call(null,c__19185__auto__);
var G__25078 = (0);
seq__25067 = G__25075;
chunk__25068 = G__25076;
count__25069 = G__25077;
i__25070 = G__25078;
continue;
} else {
var n = cljs.core.first.call(null,seq__25067__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__25079 = cljs.core.next.call(null,seq__25067__$1);
var G__25080 = null;
var G__25081 = (0);
var G__25082 = (0);
seq__25067 = G__25079;
chunk__25068 = G__25080;
count__25069 = G__25081;
i__25070 = G__25082;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__25121_25128 = cljs.core.seq.call(null,deps);
var chunk__25122_25129 = null;
var count__25123_25130 = (0);
var i__25124_25131 = (0);
while(true){
if((i__25124_25131 < count__25123_25130)){
var dep_25132 = cljs.core._nth.call(null,chunk__25122_25129,i__25124_25131);
topo_sort_helper_STAR_.call(null,dep_25132,(depth + (1)),state);

var G__25133 = seq__25121_25128;
var G__25134 = chunk__25122_25129;
var G__25135 = count__25123_25130;
var G__25136 = (i__25124_25131 + (1));
seq__25121_25128 = G__25133;
chunk__25122_25129 = G__25134;
count__25123_25130 = G__25135;
i__25124_25131 = G__25136;
continue;
} else {
var temp__4425__auto___25137 = cljs.core.seq.call(null,seq__25121_25128);
if(temp__4425__auto___25137){
var seq__25121_25138__$1 = temp__4425__auto___25137;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25121_25138__$1)){
var c__19185__auto___25139 = cljs.core.chunk_first.call(null,seq__25121_25138__$1);
var G__25140 = cljs.core.chunk_rest.call(null,seq__25121_25138__$1);
var G__25141 = c__19185__auto___25139;
var G__25142 = cljs.core.count.call(null,c__19185__auto___25139);
var G__25143 = (0);
seq__25121_25128 = G__25140;
chunk__25122_25129 = G__25141;
count__25123_25130 = G__25142;
i__25124_25131 = G__25143;
continue;
} else {
var dep_25144 = cljs.core.first.call(null,seq__25121_25138__$1);
topo_sort_helper_STAR_.call(null,dep_25144,(depth + (1)),state);

var G__25145 = cljs.core.next.call(null,seq__25121_25138__$1);
var G__25146 = null;
var G__25147 = (0);
var G__25148 = (0);
seq__25121_25128 = G__25145;
chunk__25122_25129 = G__25146;
count__25123_25130 = G__25147;
i__25124_25131 = G__25148;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__25125){
var vec__25127 = p__25125;
var x = cljs.core.nth.call(null,vec__25127,(0),null);
var xs = cljs.core.nthnext.call(null,vec__25127,(1));
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__25127,x,xs,get_deps__$1){
return (function (p1__25083_SHARP_){
return clojure.set.difference.call(null,p1__25083_SHARP_,x);
});})(vec__25127,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str(goog.basePath),cljs.core.str(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str(goog.basePath),cljs.core.str(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__25161 = cljs.core.seq.call(null,provides);
var chunk__25162 = null;
var count__25163 = (0);
var i__25164 = (0);
while(true){
if((i__25164 < count__25163)){
var prov = cljs.core._nth.call(null,chunk__25162,i__25164);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__25165_25173 = cljs.core.seq.call(null,requires);
var chunk__25166_25174 = null;
var count__25167_25175 = (0);
var i__25168_25176 = (0);
while(true){
if((i__25168_25176 < count__25167_25175)){
var req_25177 = cljs.core._nth.call(null,chunk__25166_25174,i__25168_25176);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_25177,prov);

var G__25178 = seq__25165_25173;
var G__25179 = chunk__25166_25174;
var G__25180 = count__25167_25175;
var G__25181 = (i__25168_25176 + (1));
seq__25165_25173 = G__25178;
chunk__25166_25174 = G__25179;
count__25167_25175 = G__25180;
i__25168_25176 = G__25181;
continue;
} else {
var temp__4425__auto___25182 = cljs.core.seq.call(null,seq__25165_25173);
if(temp__4425__auto___25182){
var seq__25165_25183__$1 = temp__4425__auto___25182;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25165_25183__$1)){
var c__19185__auto___25184 = cljs.core.chunk_first.call(null,seq__25165_25183__$1);
var G__25185 = cljs.core.chunk_rest.call(null,seq__25165_25183__$1);
var G__25186 = c__19185__auto___25184;
var G__25187 = cljs.core.count.call(null,c__19185__auto___25184);
var G__25188 = (0);
seq__25165_25173 = G__25185;
chunk__25166_25174 = G__25186;
count__25167_25175 = G__25187;
i__25168_25176 = G__25188;
continue;
} else {
var req_25189 = cljs.core.first.call(null,seq__25165_25183__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_25189,prov);

var G__25190 = cljs.core.next.call(null,seq__25165_25183__$1);
var G__25191 = null;
var G__25192 = (0);
var G__25193 = (0);
seq__25165_25173 = G__25190;
chunk__25166_25174 = G__25191;
count__25167_25175 = G__25192;
i__25168_25176 = G__25193;
continue;
}
} else {
}
}
break;
}

var G__25194 = seq__25161;
var G__25195 = chunk__25162;
var G__25196 = count__25163;
var G__25197 = (i__25164 + (1));
seq__25161 = G__25194;
chunk__25162 = G__25195;
count__25163 = G__25196;
i__25164 = G__25197;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__25161);
if(temp__4425__auto__){
var seq__25161__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25161__$1)){
var c__19185__auto__ = cljs.core.chunk_first.call(null,seq__25161__$1);
var G__25198 = cljs.core.chunk_rest.call(null,seq__25161__$1);
var G__25199 = c__19185__auto__;
var G__25200 = cljs.core.count.call(null,c__19185__auto__);
var G__25201 = (0);
seq__25161 = G__25198;
chunk__25162 = G__25199;
count__25163 = G__25200;
i__25164 = G__25201;
continue;
} else {
var prov = cljs.core.first.call(null,seq__25161__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__25169_25202 = cljs.core.seq.call(null,requires);
var chunk__25170_25203 = null;
var count__25171_25204 = (0);
var i__25172_25205 = (0);
while(true){
if((i__25172_25205 < count__25171_25204)){
var req_25206 = cljs.core._nth.call(null,chunk__25170_25203,i__25172_25205);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_25206,prov);

var G__25207 = seq__25169_25202;
var G__25208 = chunk__25170_25203;
var G__25209 = count__25171_25204;
var G__25210 = (i__25172_25205 + (1));
seq__25169_25202 = G__25207;
chunk__25170_25203 = G__25208;
count__25171_25204 = G__25209;
i__25172_25205 = G__25210;
continue;
} else {
var temp__4425__auto___25211__$1 = cljs.core.seq.call(null,seq__25169_25202);
if(temp__4425__auto___25211__$1){
var seq__25169_25212__$1 = temp__4425__auto___25211__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25169_25212__$1)){
var c__19185__auto___25213 = cljs.core.chunk_first.call(null,seq__25169_25212__$1);
var G__25214 = cljs.core.chunk_rest.call(null,seq__25169_25212__$1);
var G__25215 = c__19185__auto___25213;
var G__25216 = cljs.core.count.call(null,c__19185__auto___25213);
var G__25217 = (0);
seq__25169_25202 = G__25214;
chunk__25170_25203 = G__25215;
count__25171_25204 = G__25216;
i__25172_25205 = G__25217;
continue;
} else {
var req_25218 = cljs.core.first.call(null,seq__25169_25212__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_25218,prov);

var G__25219 = cljs.core.next.call(null,seq__25169_25212__$1);
var G__25220 = null;
var G__25221 = (0);
var G__25222 = (0);
seq__25169_25202 = G__25219;
chunk__25170_25203 = G__25220;
count__25171_25204 = G__25221;
i__25172_25205 = G__25222;
continue;
}
} else {
}
}
break;
}

var G__25223 = cljs.core.next.call(null,seq__25161__$1);
var G__25224 = null;
var G__25225 = (0);
var G__25226 = (0);
seq__25161 = G__25223;
chunk__25162 = G__25224;
count__25163 = G__25225;
i__25164 = G__25226;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel$client$file_reloading$figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__25231_25235 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__25232_25236 = null;
var count__25233_25237 = (0);
var i__25234_25238 = (0);
while(true){
if((i__25234_25238 < count__25233_25237)){
var ns_25239 = cljs.core._nth.call(null,chunk__25232_25236,i__25234_25238);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_25239);

var G__25240 = seq__25231_25235;
var G__25241 = chunk__25232_25236;
var G__25242 = count__25233_25237;
var G__25243 = (i__25234_25238 + (1));
seq__25231_25235 = G__25240;
chunk__25232_25236 = G__25241;
count__25233_25237 = G__25242;
i__25234_25238 = G__25243;
continue;
} else {
var temp__4425__auto___25244 = cljs.core.seq.call(null,seq__25231_25235);
if(temp__4425__auto___25244){
var seq__25231_25245__$1 = temp__4425__auto___25244;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25231_25245__$1)){
var c__19185__auto___25246 = cljs.core.chunk_first.call(null,seq__25231_25245__$1);
var G__25247 = cljs.core.chunk_rest.call(null,seq__25231_25245__$1);
var G__25248 = c__19185__auto___25246;
var G__25249 = cljs.core.count.call(null,c__19185__auto___25246);
var G__25250 = (0);
seq__25231_25235 = G__25247;
chunk__25232_25236 = G__25248;
count__25233_25237 = G__25249;
i__25234_25238 = G__25250;
continue;
} else {
var ns_25251 = cljs.core.first.call(null,seq__25231_25245__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_25251);

var G__25252 = cljs.core.next.call(null,seq__25231_25245__$1);
var G__25253 = null;
var G__25254 = (0);
var G__25255 = (0);
seq__25231_25235 = G__25252;
chunk__25232_25236 = G__25253;
count__25233_25237 = G__25254;
i__25234_25238 = G__25255;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__18374__auto__ = goog.require__;
if(cljs.core.truth_(or__18374__auto__)){
return or__18374__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__25256__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__25256 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__25257__i = 0, G__25257__a = new Array(arguments.length -  0);
while (G__25257__i < G__25257__a.length) {G__25257__a[G__25257__i] = arguments[G__25257__i + 0]; ++G__25257__i;}
  args = new cljs.core.IndexedSeq(G__25257__a,0);
} 
return G__25256__delegate.call(this,args);};
G__25256.cljs$lang$maxFixedArity = 0;
G__25256.cljs$lang$applyTo = (function (arglist__25258){
var args = cljs.core.seq(arglist__25258);
return G__25256__delegate(args);
});
G__25256.cljs$core$IFn$_invoke$arity$variadic = G__25256__delegate;
return G__25256;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
;
}
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__25260 = cljs.core._EQ_;
var expr__25261 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__25260.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__25261))){
var path_parts = ((function (pred__25260,expr__25261){
return (function (p1__25259_SHARP_){
return clojure.string.split.call(null,p1__25259_SHARP_,/[\/\\]/);
});})(pred__25260,expr__25261))
;
var sep = (cljs.core.truth_(cljs.core.re_matches.call(null,/win.*/,process.platform))?"\\":"/");
var root = clojure.string.join.call(null,sep,cljs.core.pop.call(null,cljs.core.pop.call(null,path_parts.call(null,__dirname))));
return ((function (path_parts,sep,root,pred__25260,expr__25261){
return (function (request_url,callback){

var cache_path = clojure.string.join.call(null,sep,cljs.core.cons.call(null,root,path_parts.call(null,figwheel.client.file_reloading.fix_node_request_url.call(null,request_url))));
(require.cache[cache_path] = null);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e25263){if((e25263 instanceof Error)){
var e = e25263;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e25263;

}
}})());
});
;})(path_parts,sep,root,pred__25260,expr__25261))
} else {
if(cljs.core.truth_(pred__25260.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__25261))){
return ((function (pred__25260,expr__25261){
return (function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),{"cleanupWhenDone": true});
deferred.addCallback(((function (deferred,pred__25260,expr__25261){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred,pred__25260,expr__25261))
);

return deferred.addErrback(((function (deferred,pred__25260,expr__25261){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred,pred__25260,expr__25261))
);
});
;})(pred__25260,expr__25261))
} else {
return ((function (pred__25260,expr__25261){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__25260,expr__25261))
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__25264,callback){
var map__25267 = p__25264;
var map__25267__$1 = ((((!((map__25267 == null)))?((((map__25267.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25267.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25267):map__25267);
var file_msg = map__25267__$1;
var request_url = cljs.core.get.call(null,map__25267__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Attempting to load "),cljs.core.str(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__25267,map__25267__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Successfully loaded "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__25267,map__25267__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__20554__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20554__auto__){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (c__20554__auto__){
return (function (state_25291){
var state_val_25292 = (state_25291[(1)]);
if((state_val_25292 === (7))){
var inst_25287 = (state_25291[(2)]);
var state_25291__$1 = state_25291;
var statearr_25293_25313 = state_25291__$1;
(statearr_25293_25313[(2)] = inst_25287);

(statearr_25293_25313[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25292 === (1))){
var state_25291__$1 = state_25291;
var statearr_25294_25314 = state_25291__$1;
(statearr_25294_25314[(2)] = null);

(statearr_25294_25314[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25292 === (4))){
var inst_25271 = (state_25291[(7)]);
var inst_25271__$1 = (state_25291[(2)]);
var state_25291__$1 = (function (){var statearr_25295 = state_25291;
(statearr_25295[(7)] = inst_25271__$1);

return statearr_25295;
})();
if(cljs.core.truth_(inst_25271__$1)){
var statearr_25296_25315 = state_25291__$1;
(statearr_25296_25315[(1)] = (5));

} else {
var statearr_25297_25316 = state_25291__$1;
(statearr_25297_25316[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25292 === (6))){
var state_25291__$1 = state_25291;
var statearr_25298_25317 = state_25291__$1;
(statearr_25298_25317[(2)] = null);

(statearr_25298_25317[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25292 === (3))){
var inst_25289 = (state_25291[(2)]);
var state_25291__$1 = state_25291;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25291__$1,inst_25289);
} else {
if((state_val_25292 === (2))){
var state_25291__$1 = state_25291;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25291__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_25292 === (11))){
var inst_25283 = (state_25291[(2)]);
var state_25291__$1 = (function (){var statearr_25299 = state_25291;
(statearr_25299[(8)] = inst_25283);

return statearr_25299;
})();
var statearr_25300_25318 = state_25291__$1;
(statearr_25300_25318[(2)] = null);

(statearr_25300_25318[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25292 === (9))){
var inst_25275 = (state_25291[(9)]);
var inst_25277 = (state_25291[(10)]);
var inst_25279 = inst_25277.call(null,inst_25275);
var state_25291__$1 = state_25291;
var statearr_25301_25319 = state_25291__$1;
(statearr_25301_25319[(2)] = inst_25279);

(statearr_25301_25319[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25292 === (5))){
var inst_25271 = (state_25291[(7)]);
var inst_25273 = figwheel.client.file_reloading.blocking_load.call(null,inst_25271);
var state_25291__$1 = state_25291;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25291__$1,(8),inst_25273);
} else {
if((state_val_25292 === (10))){
var inst_25275 = (state_25291[(9)]);
var inst_25281 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_25275);
var state_25291__$1 = state_25291;
var statearr_25302_25320 = state_25291__$1;
(statearr_25302_25320[(2)] = inst_25281);

(statearr_25302_25320[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25292 === (8))){
var inst_25271 = (state_25291[(7)]);
var inst_25277 = (state_25291[(10)]);
var inst_25275 = (state_25291[(2)]);
var inst_25276 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_25277__$1 = cljs.core.get.call(null,inst_25276,inst_25271);
var state_25291__$1 = (function (){var statearr_25303 = state_25291;
(statearr_25303[(9)] = inst_25275);

(statearr_25303[(10)] = inst_25277__$1);

return statearr_25303;
})();
if(cljs.core.truth_(inst_25277__$1)){
var statearr_25304_25321 = state_25291__$1;
(statearr_25304_25321[(1)] = (9));

} else {
var statearr_25305_25322 = state_25291__$1;
(statearr_25305_25322[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__20554__auto__))
;
return ((function (switch__20400__auto__,c__20554__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__20401__auto__ = null;
var figwheel$client$file_reloading$state_machine__20401__auto____0 = (function (){
var statearr_25309 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_25309[(0)] = figwheel$client$file_reloading$state_machine__20401__auto__);

(statearr_25309[(1)] = (1));

return statearr_25309;
});
var figwheel$client$file_reloading$state_machine__20401__auto____1 = (function (state_25291){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_25291);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e25310){if((e25310 instanceof Object)){
var ex__20404__auto__ = e25310;
var statearr_25311_25323 = state_25291;
(statearr_25311_25323[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25291);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25310;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25324 = state_25291;
state_25291 = G__25324;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__20401__auto__ = function(state_25291){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__20401__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__20401__auto____1.call(this,state_25291);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__20401__auto____0;
figwheel$client$file_reloading$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__20401__auto____1;
return figwheel$client$file_reloading$state_machine__20401__auto__;
})()
;})(switch__20400__auto__,c__20554__auto__))
})();
var state__20556__auto__ = (function (){var statearr_25312 = f__20555__auto__.call(null);
(statearr_25312[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto__);

return statearr_25312;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(c__20554__auto__))
);

return c__20554__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__25325,callback){
var map__25328 = p__25325;
var map__25328__$1 = ((((!((map__25328 == null)))?((((map__25328.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25328.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25328):map__25328);
var file_msg = map__25328__$1;
var namespace = cljs.core.get.call(null,map__25328__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__25328,map__25328__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__25328,map__25328__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__25330){
var map__25333 = p__25330;
var map__25333__$1 = ((((!((map__25333 == null)))?((((map__25333.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25333.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25333):map__25333);
var file_msg = map__25333__$1;
var namespace = cljs.core.get.call(null,map__25333__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__18362__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas));
if(and__18362__auto__){
var or__18374__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__18374__auto__)){
return or__18374__auto__;
} else {
var or__18374__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__18374__auto____$1)){
return or__18374__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__18362__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__25335,callback){
var map__25338 = p__25335;
var map__25338__$1 = ((((!((map__25338 == null)))?((((map__25338.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25338.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25338):map__25338);
var file_msg = map__25338__$1;
var request_url = cljs.core.get.call(null,map__25338__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__25338__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Figwheel: Not trying to load file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__20554__auto___25426 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20554__auto___25426,out){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (c__20554__auto___25426,out){
return (function (state_25408){
var state_val_25409 = (state_25408[(1)]);
if((state_val_25409 === (1))){
var inst_25386 = cljs.core.nth.call(null,files,(0),null);
var inst_25387 = cljs.core.nthnext.call(null,files,(1));
var inst_25388 = files;
var state_25408__$1 = (function (){var statearr_25410 = state_25408;
(statearr_25410[(7)] = inst_25388);

(statearr_25410[(8)] = inst_25386);

(statearr_25410[(9)] = inst_25387);

return statearr_25410;
})();
var statearr_25411_25427 = state_25408__$1;
(statearr_25411_25427[(2)] = null);

(statearr_25411_25427[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25409 === (2))){
var inst_25391 = (state_25408[(10)]);
var inst_25388 = (state_25408[(7)]);
var inst_25391__$1 = cljs.core.nth.call(null,inst_25388,(0),null);
var inst_25392 = cljs.core.nthnext.call(null,inst_25388,(1));
var inst_25393 = (inst_25391__$1 == null);
var inst_25394 = cljs.core.not.call(null,inst_25393);
var state_25408__$1 = (function (){var statearr_25412 = state_25408;
(statearr_25412[(11)] = inst_25392);

(statearr_25412[(10)] = inst_25391__$1);

return statearr_25412;
})();
if(inst_25394){
var statearr_25413_25428 = state_25408__$1;
(statearr_25413_25428[(1)] = (4));

} else {
var statearr_25414_25429 = state_25408__$1;
(statearr_25414_25429[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25409 === (3))){
var inst_25406 = (state_25408[(2)]);
var state_25408__$1 = state_25408;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25408__$1,inst_25406);
} else {
if((state_val_25409 === (4))){
var inst_25391 = (state_25408[(10)]);
var inst_25396 = figwheel.client.file_reloading.reload_js_file.call(null,inst_25391);
var state_25408__$1 = state_25408;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25408__$1,(7),inst_25396);
} else {
if((state_val_25409 === (5))){
var inst_25402 = cljs.core.async.close_BANG_.call(null,out);
var state_25408__$1 = state_25408;
var statearr_25415_25430 = state_25408__$1;
(statearr_25415_25430[(2)] = inst_25402);

(statearr_25415_25430[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25409 === (6))){
var inst_25404 = (state_25408[(2)]);
var state_25408__$1 = state_25408;
var statearr_25416_25431 = state_25408__$1;
(statearr_25416_25431[(2)] = inst_25404);

(statearr_25416_25431[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25409 === (7))){
var inst_25392 = (state_25408[(11)]);
var inst_25398 = (state_25408[(2)]);
var inst_25399 = cljs.core.async.put_BANG_.call(null,out,inst_25398);
var inst_25388 = inst_25392;
var state_25408__$1 = (function (){var statearr_25417 = state_25408;
(statearr_25417[(12)] = inst_25399);

(statearr_25417[(7)] = inst_25388);

return statearr_25417;
})();
var statearr_25418_25432 = state_25408__$1;
(statearr_25418_25432[(2)] = null);

(statearr_25418_25432[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__20554__auto___25426,out))
;
return ((function (switch__20400__auto__,c__20554__auto___25426,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__20401__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__20401__auto____0 = (function (){
var statearr_25422 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25422[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__20401__auto__);

(statearr_25422[(1)] = (1));

return statearr_25422;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__20401__auto____1 = (function (state_25408){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_25408);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e25423){if((e25423 instanceof Object)){
var ex__20404__auto__ = e25423;
var statearr_25424_25433 = state_25408;
(statearr_25424_25433[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25408);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25423;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25434 = state_25408;
state_25408 = G__25434;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__20401__auto__ = function(state_25408){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__20401__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__20401__auto____1.call(this,state_25408);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__20401__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__20401__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__20401__auto__;
})()
;})(switch__20400__auto__,c__20554__auto___25426,out))
})();
var state__20556__auto__ = (function (){var statearr_25425 = f__20555__auto__.call(null);
(statearr_25425[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto___25426);

return statearr_25425;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(c__20554__auto___25426,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__25435,opts){
var map__25439 = p__25435;
var map__25439__$1 = ((((!((map__25439 == null)))?((((map__25439.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25439.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25439):map__25439);
var eval_body__$1 = cljs.core.get.call(null,map__25439__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__25439__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__18362__auto__ = eval_body__$1;
if(cljs.core.truth_(and__18362__auto__)){
return typeof eval_body__$1 === 'string';
} else {
return and__18362__auto__;
}
})())){
var code = eval_body__$1;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Evaling file "),cljs.core.str(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e25441){var e = e25441;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Unable to evaluate "),cljs.core.str(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["figwheel.connect",null], null), null),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__4423__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__25442_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__25442_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__4423__auto__)){
var file_msg = temp__4423__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__25447){
var vec__25448 = p__25447;
var k = cljs.core.nth.call(null,vec__25448,(0),null);
var v = cljs.core.nth.call(null,vec__25448,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__25449){
var vec__25450 = p__25449;
var k = cljs.core.nth.call(null,vec__25450,(0),null);
var v = cljs.core.nth.call(null,vec__25450,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__25454,p__25455){
var map__25702 = p__25454;
var map__25702__$1 = ((((!((map__25702 == null)))?((((map__25702.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25702.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25702):map__25702);
var opts = map__25702__$1;
var before_jsload = cljs.core.get.call(null,map__25702__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__25702__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__25702__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__25703 = p__25455;
var map__25703__$1 = ((((!((map__25703 == null)))?((((map__25703.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25703.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25703):map__25703);
var msg = map__25703__$1;
var files = cljs.core.get.call(null,map__25703__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__25703__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__25703__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__20554__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20554__auto__,map__25702,map__25702__$1,opts,before_jsload,on_jsload,reload_dependents,map__25703,map__25703__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (c__20554__auto__,map__25702,map__25702__$1,opts,before_jsload,on_jsload,reload_dependents,map__25703,map__25703__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_25856){
var state_val_25857 = (state_25856[(1)]);
if((state_val_25857 === (7))){
var inst_25720 = (state_25856[(7)]);
var inst_25718 = (state_25856[(8)]);
var inst_25719 = (state_25856[(9)]);
var inst_25717 = (state_25856[(10)]);
var inst_25725 = cljs.core._nth.call(null,inst_25718,inst_25720);
var inst_25726 = figwheel.client.file_reloading.eval_body.call(null,inst_25725,opts);
var inst_25727 = (inst_25720 + (1));
var tmp25858 = inst_25718;
var tmp25859 = inst_25719;
var tmp25860 = inst_25717;
var inst_25717__$1 = tmp25860;
var inst_25718__$1 = tmp25858;
var inst_25719__$1 = tmp25859;
var inst_25720__$1 = inst_25727;
var state_25856__$1 = (function (){var statearr_25861 = state_25856;
(statearr_25861[(7)] = inst_25720__$1);

(statearr_25861[(8)] = inst_25718__$1);

(statearr_25861[(9)] = inst_25719__$1);

(statearr_25861[(10)] = inst_25717__$1);

(statearr_25861[(11)] = inst_25726);

return statearr_25861;
})();
var statearr_25862_25948 = state_25856__$1;
(statearr_25862_25948[(2)] = null);

(statearr_25862_25948[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (20))){
var inst_25760 = (state_25856[(12)]);
var inst_25768 = figwheel.client.file_reloading.sort_files.call(null,inst_25760);
var state_25856__$1 = state_25856;
var statearr_25863_25949 = state_25856__$1;
(statearr_25863_25949[(2)] = inst_25768);

(statearr_25863_25949[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (27))){
var state_25856__$1 = state_25856;
var statearr_25864_25950 = state_25856__$1;
(statearr_25864_25950[(2)] = null);

(statearr_25864_25950[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (1))){
var inst_25709 = (state_25856[(13)]);
var inst_25706 = before_jsload.call(null,files);
var inst_25707 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_25708 = (function (){return ((function (inst_25709,inst_25706,inst_25707,state_val_25857,c__20554__auto__,map__25702,map__25702__$1,opts,before_jsload,on_jsload,reload_dependents,map__25703,map__25703__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__25451_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__25451_SHARP_);
});
;})(inst_25709,inst_25706,inst_25707,state_val_25857,c__20554__auto__,map__25702,map__25702__$1,opts,before_jsload,on_jsload,reload_dependents,map__25703,map__25703__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_25709__$1 = cljs.core.filter.call(null,inst_25708,files);
var inst_25710 = cljs.core.not_empty.call(null,inst_25709__$1);
var state_25856__$1 = (function (){var statearr_25865 = state_25856;
(statearr_25865[(13)] = inst_25709__$1);

(statearr_25865[(14)] = inst_25706);

(statearr_25865[(15)] = inst_25707);

return statearr_25865;
})();
if(cljs.core.truth_(inst_25710)){
var statearr_25866_25951 = state_25856__$1;
(statearr_25866_25951[(1)] = (2));

} else {
var statearr_25867_25952 = state_25856__$1;
(statearr_25867_25952[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (24))){
var state_25856__$1 = state_25856;
var statearr_25868_25953 = state_25856__$1;
(statearr_25868_25953[(2)] = null);

(statearr_25868_25953[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (39))){
var inst_25810 = (state_25856[(16)]);
var state_25856__$1 = state_25856;
var statearr_25869_25954 = state_25856__$1;
(statearr_25869_25954[(2)] = inst_25810);

(statearr_25869_25954[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (46))){
var inst_25851 = (state_25856[(2)]);
var state_25856__$1 = state_25856;
var statearr_25870_25955 = state_25856__$1;
(statearr_25870_25955[(2)] = inst_25851);

(statearr_25870_25955[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (4))){
var inst_25754 = (state_25856[(2)]);
var inst_25755 = cljs.core.List.EMPTY;
var inst_25756 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_25755);
var inst_25757 = (function (){return ((function (inst_25754,inst_25755,inst_25756,state_val_25857,c__20554__auto__,map__25702,map__25702__$1,opts,before_jsload,on_jsload,reload_dependents,map__25703,map__25703__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__25452_SHARP_){
var and__18362__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__25452_SHARP_);
if(cljs.core.truth_(and__18362__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__25452_SHARP_));
} else {
return and__18362__auto__;
}
});
;})(inst_25754,inst_25755,inst_25756,state_val_25857,c__20554__auto__,map__25702,map__25702__$1,opts,before_jsload,on_jsload,reload_dependents,map__25703,map__25703__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_25758 = cljs.core.filter.call(null,inst_25757,files);
var inst_25759 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_25760 = cljs.core.concat.call(null,inst_25758,inst_25759);
var state_25856__$1 = (function (){var statearr_25871 = state_25856;
(statearr_25871[(17)] = inst_25756);

(statearr_25871[(18)] = inst_25754);

(statearr_25871[(12)] = inst_25760);

return statearr_25871;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_25872_25956 = state_25856__$1;
(statearr_25872_25956[(1)] = (16));

} else {
var statearr_25873_25957 = state_25856__$1;
(statearr_25873_25957[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (15))){
var inst_25744 = (state_25856[(2)]);
var state_25856__$1 = state_25856;
var statearr_25874_25958 = state_25856__$1;
(statearr_25874_25958[(2)] = inst_25744);

(statearr_25874_25958[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (21))){
var inst_25770 = (state_25856[(19)]);
var inst_25770__$1 = (state_25856[(2)]);
var inst_25771 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_25770__$1);
var state_25856__$1 = (function (){var statearr_25875 = state_25856;
(statearr_25875[(19)] = inst_25770__$1);

return statearr_25875;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25856__$1,(22),inst_25771);
} else {
if((state_val_25857 === (31))){
var inst_25854 = (state_25856[(2)]);
var state_25856__$1 = state_25856;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25856__$1,inst_25854);
} else {
if((state_val_25857 === (32))){
var inst_25810 = (state_25856[(16)]);
var inst_25815 = inst_25810.cljs$lang$protocol_mask$partition0$;
var inst_25816 = (inst_25815 & (64));
var inst_25817 = inst_25810.cljs$core$ISeq$;
var inst_25818 = (inst_25816) || (inst_25817);
var state_25856__$1 = state_25856;
if(cljs.core.truth_(inst_25818)){
var statearr_25876_25959 = state_25856__$1;
(statearr_25876_25959[(1)] = (35));

} else {
var statearr_25877_25960 = state_25856__$1;
(statearr_25877_25960[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (40))){
var inst_25831 = (state_25856[(20)]);
var inst_25830 = (state_25856[(2)]);
var inst_25831__$1 = cljs.core.get.call(null,inst_25830,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_25832 = cljs.core.get.call(null,inst_25830,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_25833 = cljs.core.not_empty.call(null,inst_25831__$1);
var state_25856__$1 = (function (){var statearr_25878 = state_25856;
(statearr_25878[(21)] = inst_25832);

(statearr_25878[(20)] = inst_25831__$1);

return statearr_25878;
})();
if(cljs.core.truth_(inst_25833)){
var statearr_25879_25961 = state_25856__$1;
(statearr_25879_25961[(1)] = (41));

} else {
var statearr_25880_25962 = state_25856__$1;
(statearr_25880_25962[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (33))){
var state_25856__$1 = state_25856;
var statearr_25881_25963 = state_25856__$1;
(statearr_25881_25963[(2)] = false);

(statearr_25881_25963[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (13))){
var inst_25730 = (state_25856[(22)]);
var inst_25734 = cljs.core.chunk_first.call(null,inst_25730);
var inst_25735 = cljs.core.chunk_rest.call(null,inst_25730);
var inst_25736 = cljs.core.count.call(null,inst_25734);
var inst_25717 = inst_25735;
var inst_25718 = inst_25734;
var inst_25719 = inst_25736;
var inst_25720 = (0);
var state_25856__$1 = (function (){var statearr_25882 = state_25856;
(statearr_25882[(7)] = inst_25720);

(statearr_25882[(8)] = inst_25718);

(statearr_25882[(9)] = inst_25719);

(statearr_25882[(10)] = inst_25717);

return statearr_25882;
})();
var statearr_25883_25964 = state_25856__$1;
(statearr_25883_25964[(2)] = null);

(statearr_25883_25964[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (22))){
var inst_25770 = (state_25856[(19)]);
var inst_25778 = (state_25856[(23)]);
var inst_25774 = (state_25856[(24)]);
var inst_25773 = (state_25856[(25)]);
var inst_25773__$1 = (state_25856[(2)]);
var inst_25774__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_25773__$1);
var inst_25775 = (function (){var all_files = inst_25770;
var res_SINGLEQUOTE_ = inst_25773__$1;
var res = inst_25774__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_25770,inst_25778,inst_25774,inst_25773,inst_25773__$1,inst_25774__$1,state_val_25857,c__20554__auto__,map__25702,map__25702__$1,opts,before_jsload,on_jsload,reload_dependents,map__25703,map__25703__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__25453_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__25453_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_25770,inst_25778,inst_25774,inst_25773,inst_25773__$1,inst_25774__$1,state_val_25857,c__20554__auto__,map__25702,map__25702__$1,opts,before_jsload,on_jsload,reload_dependents,map__25703,map__25703__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_25776 = cljs.core.filter.call(null,inst_25775,inst_25773__$1);
var inst_25777 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_25778__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_25777);
var inst_25779 = cljs.core.not_empty.call(null,inst_25778__$1);
var state_25856__$1 = (function (){var statearr_25884 = state_25856;
(statearr_25884[(23)] = inst_25778__$1);

(statearr_25884[(24)] = inst_25774__$1);

(statearr_25884[(25)] = inst_25773__$1);

(statearr_25884[(26)] = inst_25776);

return statearr_25884;
})();
if(cljs.core.truth_(inst_25779)){
var statearr_25885_25965 = state_25856__$1;
(statearr_25885_25965[(1)] = (23));

} else {
var statearr_25886_25966 = state_25856__$1;
(statearr_25886_25966[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (36))){
var state_25856__$1 = state_25856;
var statearr_25887_25967 = state_25856__$1;
(statearr_25887_25967[(2)] = false);

(statearr_25887_25967[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (41))){
var inst_25831 = (state_25856[(20)]);
var inst_25835 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_25836 = cljs.core.map.call(null,inst_25835,inst_25831);
var inst_25837 = cljs.core.pr_str.call(null,inst_25836);
var inst_25838 = [cljs.core.str("figwheel-no-load meta-data: "),cljs.core.str(inst_25837)].join('');
var inst_25839 = figwheel.client.utils.log.call(null,inst_25838);
var state_25856__$1 = state_25856;
var statearr_25888_25968 = state_25856__$1;
(statearr_25888_25968[(2)] = inst_25839);

(statearr_25888_25968[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (43))){
var inst_25832 = (state_25856[(21)]);
var inst_25842 = (state_25856[(2)]);
var inst_25843 = cljs.core.not_empty.call(null,inst_25832);
var state_25856__$1 = (function (){var statearr_25889 = state_25856;
(statearr_25889[(27)] = inst_25842);

return statearr_25889;
})();
if(cljs.core.truth_(inst_25843)){
var statearr_25890_25969 = state_25856__$1;
(statearr_25890_25969[(1)] = (44));

} else {
var statearr_25891_25970 = state_25856__$1;
(statearr_25891_25970[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (29))){
var inst_25770 = (state_25856[(19)]);
var inst_25810 = (state_25856[(16)]);
var inst_25778 = (state_25856[(23)]);
var inst_25774 = (state_25856[(24)]);
var inst_25773 = (state_25856[(25)]);
var inst_25776 = (state_25856[(26)]);
var inst_25806 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_25809 = (function (){var all_files = inst_25770;
var res_SINGLEQUOTE_ = inst_25773;
var res = inst_25774;
var files_not_loaded = inst_25776;
var dependencies_that_loaded = inst_25778;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_25770,inst_25810,inst_25778,inst_25774,inst_25773,inst_25776,inst_25806,state_val_25857,c__20554__auto__,map__25702,map__25702__$1,opts,before_jsload,on_jsload,reload_dependents,map__25703,map__25703__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__25808){
var map__25892 = p__25808;
var map__25892__$1 = ((((!((map__25892 == null)))?((((map__25892.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25892.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25892):map__25892);
var namespace = cljs.core.get.call(null,map__25892__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_25770,inst_25810,inst_25778,inst_25774,inst_25773,inst_25776,inst_25806,state_val_25857,c__20554__auto__,map__25702,map__25702__$1,opts,before_jsload,on_jsload,reload_dependents,map__25703,map__25703__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_25810__$1 = cljs.core.group_by.call(null,inst_25809,inst_25776);
var inst_25812 = (inst_25810__$1 == null);
var inst_25813 = cljs.core.not.call(null,inst_25812);
var state_25856__$1 = (function (){var statearr_25894 = state_25856;
(statearr_25894[(16)] = inst_25810__$1);

(statearr_25894[(28)] = inst_25806);

return statearr_25894;
})();
if(inst_25813){
var statearr_25895_25971 = state_25856__$1;
(statearr_25895_25971[(1)] = (32));

} else {
var statearr_25896_25972 = state_25856__$1;
(statearr_25896_25972[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (44))){
var inst_25832 = (state_25856[(21)]);
var inst_25845 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_25832);
var inst_25846 = cljs.core.pr_str.call(null,inst_25845);
var inst_25847 = [cljs.core.str("not required: "),cljs.core.str(inst_25846)].join('');
var inst_25848 = figwheel.client.utils.log.call(null,inst_25847);
var state_25856__$1 = state_25856;
var statearr_25897_25973 = state_25856__$1;
(statearr_25897_25973[(2)] = inst_25848);

(statearr_25897_25973[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (6))){
var inst_25751 = (state_25856[(2)]);
var state_25856__$1 = state_25856;
var statearr_25898_25974 = state_25856__$1;
(statearr_25898_25974[(2)] = inst_25751);

(statearr_25898_25974[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (28))){
var inst_25776 = (state_25856[(26)]);
var inst_25803 = (state_25856[(2)]);
var inst_25804 = cljs.core.not_empty.call(null,inst_25776);
var state_25856__$1 = (function (){var statearr_25899 = state_25856;
(statearr_25899[(29)] = inst_25803);

return statearr_25899;
})();
if(cljs.core.truth_(inst_25804)){
var statearr_25900_25975 = state_25856__$1;
(statearr_25900_25975[(1)] = (29));

} else {
var statearr_25901_25976 = state_25856__$1;
(statearr_25901_25976[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (25))){
var inst_25774 = (state_25856[(24)]);
var inst_25790 = (state_25856[(2)]);
var inst_25791 = cljs.core.not_empty.call(null,inst_25774);
var state_25856__$1 = (function (){var statearr_25902 = state_25856;
(statearr_25902[(30)] = inst_25790);

return statearr_25902;
})();
if(cljs.core.truth_(inst_25791)){
var statearr_25903_25977 = state_25856__$1;
(statearr_25903_25977[(1)] = (26));

} else {
var statearr_25904_25978 = state_25856__$1;
(statearr_25904_25978[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (34))){
var inst_25825 = (state_25856[(2)]);
var state_25856__$1 = state_25856;
if(cljs.core.truth_(inst_25825)){
var statearr_25905_25979 = state_25856__$1;
(statearr_25905_25979[(1)] = (38));

} else {
var statearr_25906_25980 = state_25856__$1;
(statearr_25906_25980[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (17))){
var state_25856__$1 = state_25856;
var statearr_25907_25981 = state_25856__$1;
(statearr_25907_25981[(2)] = recompile_dependents);

(statearr_25907_25981[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (3))){
var state_25856__$1 = state_25856;
var statearr_25908_25982 = state_25856__$1;
(statearr_25908_25982[(2)] = null);

(statearr_25908_25982[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (12))){
var inst_25747 = (state_25856[(2)]);
var state_25856__$1 = state_25856;
var statearr_25909_25983 = state_25856__$1;
(statearr_25909_25983[(2)] = inst_25747);

(statearr_25909_25983[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (2))){
var inst_25709 = (state_25856[(13)]);
var inst_25716 = cljs.core.seq.call(null,inst_25709);
var inst_25717 = inst_25716;
var inst_25718 = null;
var inst_25719 = (0);
var inst_25720 = (0);
var state_25856__$1 = (function (){var statearr_25910 = state_25856;
(statearr_25910[(7)] = inst_25720);

(statearr_25910[(8)] = inst_25718);

(statearr_25910[(9)] = inst_25719);

(statearr_25910[(10)] = inst_25717);

return statearr_25910;
})();
var statearr_25911_25984 = state_25856__$1;
(statearr_25911_25984[(2)] = null);

(statearr_25911_25984[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (23))){
var inst_25770 = (state_25856[(19)]);
var inst_25778 = (state_25856[(23)]);
var inst_25774 = (state_25856[(24)]);
var inst_25773 = (state_25856[(25)]);
var inst_25776 = (state_25856[(26)]);
var inst_25781 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_25783 = (function (){var all_files = inst_25770;
var res_SINGLEQUOTE_ = inst_25773;
var res = inst_25774;
var files_not_loaded = inst_25776;
var dependencies_that_loaded = inst_25778;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_25770,inst_25778,inst_25774,inst_25773,inst_25776,inst_25781,state_val_25857,c__20554__auto__,map__25702,map__25702__$1,opts,before_jsload,on_jsload,reload_dependents,map__25703,map__25703__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__25782){
var map__25912 = p__25782;
var map__25912__$1 = ((((!((map__25912 == null)))?((((map__25912.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25912.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25912):map__25912);
var request_url = cljs.core.get.call(null,map__25912__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_25770,inst_25778,inst_25774,inst_25773,inst_25776,inst_25781,state_val_25857,c__20554__auto__,map__25702,map__25702__$1,opts,before_jsload,on_jsload,reload_dependents,map__25703,map__25703__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_25784 = cljs.core.reverse.call(null,inst_25778);
var inst_25785 = cljs.core.map.call(null,inst_25783,inst_25784);
var inst_25786 = cljs.core.pr_str.call(null,inst_25785);
var inst_25787 = figwheel.client.utils.log.call(null,inst_25786);
var state_25856__$1 = (function (){var statearr_25914 = state_25856;
(statearr_25914[(31)] = inst_25781);

return statearr_25914;
})();
var statearr_25915_25985 = state_25856__$1;
(statearr_25915_25985[(2)] = inst_25787);

(statearr_25915_25985[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (35))){
var state_25856__$1 = state_25856;
var statearr_25916_25986 = state_25856__$1;
(statearr_25916_25986[(2)] = true);

(statearr_25916_25986[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (19))){
var inst_25760 = (state_25856[(12)]);
var inst_25766 = figwheel.client.file_reloading.expand_files.call(null,inst_25760);
var state_25856__$1 = state_25856;
var statearr_25917_25987 = state_25856__$1;
(statearr_25917_25987[(2)] = inst_25766);

(statearr_25917_25987[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (11))){
var state_25856__$1 = state_25856;
var statearr_25918_25988 = state_25856__$1;
(statearr_25918_25988[(2)] = null);

(statearr_25918_25988[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (9))){
var inst_25749 = (state_25856[(2)]);
var state_25856__$1 = state_25856;
var statearr_25919_25989 = state_25856__$1;
(statearr_25919_25989[(2)] = inst_25749);

(statearr_25919_25989[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (5))){
var inst_25720 = (state_25856[(7)]);
var inst_25719 = (state_25856[(9)]);
var inst_25722 = (inst_25720 < inst_25719);
var inst_25723 = inst_25722;
var state_25856__$1 = state_25856;
if(cljs.core.truth_(inst_25723)){
var statearr_25920_25990 = state_25856__$1;
(statearr_25920_25990[(1)] = (7));

} else {
var statearr_25921_25991 = state_25856__$1;
(statearr_25921_25991[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (14))){
var inst_25730 = (state_25856[(22)]);
var inst_25739 = cljs.core.first.call(null,inst_25730);
var inst_25740 = figwheel.client.file_reloading.eval_body.call(null,inst_25739,opts);
var inst_25741 = cljs.core.next.call(null,inst_25730);
var inst_25717 = inst_25741;
var inst_25718 = null;
var inst_25719 = (0);
var inst_25720 = (0);
var state_25856__$1 = (function (){var statearr_25922 = state_25856;
(statearr_25922[(32)] = inst_25740);

(statearr_25922[(7)] = inst_25720);

(statearr_25922[(8)] = inst_25718);

(statearr_25922[(9)] = inst_25719);

(statearr_25922[(10)] = inst_25717);

return statearr_25922;
})();
var statearr_25923_25992 = state_25856__$1;
(statearr_25923_25992[(2)] = null);

(statearr_25923_25992[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (45))){
var state_25856__$1 = state_25856;
var statearr_25924_25993 = state_25856__$1;
(statearr_25924_25993[(2)] = null);

(statearr_25924_25993[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (26))){
var inst_25770 = (state_25856[(19)]);
var inst_25778 = (state_25856[(23)]);
var inst_25774 = (state_25856[(24)]);
var inst_25773 = (state_25856[(25)]);
var inst_25776 = (state_25856[(26)]);
var inst_25793 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_25795 = (function (){var all_files = inst_25770;
var res_SINGLEQUOTE_ = inst_25773;
var res = inst_25774;
var files_not_loaded = inst_25776;
var dependencies_that_loaded = inst_25778;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_25770,inst_25778,inst_25774,inst_25773,inst_25776,inst_25793,state_val_25857,c__20554__auto__,map__25702,map__25702__$1,opts,before_jsload,on_jsload,reload_dependents,map__25703,map__25703__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__25794){
var map__25925 = p__25794;
var map__25925__$1 = ((((!((map__25925 == null)))?((((map__25925.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25925.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25925):map__25925);
var namespace = cljs.core.get.call(null,map__25925__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__25925__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_25770,inst_25778,inst_25774,inst_25773,inst_25776,inst_25793,state_val_25857,c__20554__auto__,map__25702,map__25702__$1,opts,before_jsload,on_jsload,reload_dependents,map__25703,map__25703__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_25796 = cljs.core.map.call(null,inst_25795,inst_25774);
var inst_25797 = cljs.core.pr_str.call(null,inst_25796);
var inst_25798 = figwheel.client.utils.log.call(null,inst_25797);
var inst_25799 = (function (){var all_files = inst_25770;
var res_SINGLEQUOTE_ = inst_25773;
var res = inst_25774;
var files_not_loaded = inst_25776;
var dependencies_that_loaded = inst_25778;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_25770,inst_25778,inst_25774,inst_25773,inst_25776,inst_25793,inst_25795,inst_25796,inst_25797,inst_25798,state_val_25857,c__20554__auto__,map__25702,map__25702__$1,opts,before_jsload,on_jsload,reload_dependents,map__25703,map__25703__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_25770,inst_25778,inst_25774,inst_25773,inst_25776,inst_25793,inst_25795,inst_25796,inst_25797,inst_25798,state_val_25857,c__20554__auto__,map__25702,map__25702__$1,opts,before_jsload,on_jsload,reload_dependents,map__25703,map__25703__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_25800 = setTimeout(inst_25799,(10));
var state_25856__$1 = (function (){var statearr_25927 = state_25856;
(statearr_25927[(33)] = inst_25798);

(statearr_25927[(34)] = inst_25793);

return statearr_25927;
})();
var statearr_25928_25994 = state_25856__$1;
(statearr_25928_25994[(2)] = inst_25800);

(statearr_25928_25994[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (16))){
var state_25856__$1 = state_25856;
var statearr_25929_25995 = state_25856__$1;
(statearr_25929_25995[(2)] = reload_dependents);

(statearr_25929_25995[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (38))){
var inst_25810 = (state_25856[(16)]);
var inst_25827 = cljs.core.apply.call(null,cljs.core.hash_map,inst_25810);
var state_25856__$1 = state_25856;
var statearr_25930_25996 = state_25856__$1;
(statearr_25930_25996[(2)] = inst_25827);

(statearr_25930_25996[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (30))){
var state_25856__$1 = state_25856;
var statearr_25931_25997 = state_25856__$1;
(statearr_25931_25997[(2)] = null);

(statearr_25931_25997[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (10))){
var inst_25730 = (state_25856[(22)]);
var inst_25732 = cljs.core.chunked_seq_QMARK_.call(null,inst_25730);
var state_25856__$1 = state_25856;
if(inst_25732){
var statearr_25932_25998 = state_25856__$1;
(statearr_25932_25998[(1)] = (13));

} else {
var statearr_25933_25999 = state_25856__$1;
(statearr_25933_25999[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (18))){
var inst_25764 = (state_25856[(2)]);
var state_25856__$1 = state_25856;
if(cljs.core.truth_(inst_25764)){
var statearr_25934_26000 = state_25856__$1;
(statearr_25934_26000[(1)] = (19));

} else {
var statearr_25935_26001 = state_25856__$1;
(statearr_25935_26001[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (42))){
var state_25856__$1 = state_25856;
var statearr_25936_26002 = state_25856__$1;
(statearr_25936_26002[(2)] = null);

(statearr_25936_26002[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (37))){
var inst_25822 = (state_25856[(2)]);
var state_25856__$1 = state_25856;
var statearr_25937_26003 = state_25856__$1;
(statearr_25937_26003[(2)] = inst_25822);

(statearr_25937_26003[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25857 === (8))){
var inst_25717 = (state_25856[(10)]);
var inst_25730 = (state_25856[(22)]);
var inst_25730__$1 = cljs.core.seq.call(null,inst_25717);
var state_25856__$1 = (function (){var statearr_25938 = state_25856;
(statearr_25938[(22)] = inst_25730__$1);

return statearr_25938;
})();
if(inst_25730__$1){
var statearr_25939_26004 = state_25856__$1;
(statearr_25939_26004[(1)] = (10));

} else {
var statearr_25940_26005 = state_25856__$1;
(statearr_25940_26005[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20554__auto__,map__25702,map__25702__$1,opts,before_jsload,on_jsload,reload_dependents,map__25703,map__25703__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__20400__auto__,c__20554__auto__,map__25702,map__25702__$1,opts,before_jsload,on_jsload,reload_dependents,map__25703,map__25703__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__20401__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__20401__auto____0 = (function (){
var statearr_25944 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25944[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__20401__auto__);

(statearr_25944[(1)] = (1));

return statearr_25944;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__20401__auto____1 = (function (state_25856){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_25856);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e25945){if((e25945 instanceof Object)){
var ex__20404__auto__ = e25945;
var statearr_25946_26006 = state_25856;
(statearr_25946_26006[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25856);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25945;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26007 = state_25856;
state_25856 = G__26007;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__20401__auto__ = function(state_25856){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__20401__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__20401__auto____1.call(this,state_25856);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__20401__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__20401__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__20401__auto__;
})()
;})(switch__20400__auto__,c__20554__auto__,map__25702,map__25702__$1,opts,before_jsload,on_jsload,reload_dependents,map__25703,map__25703__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__20556__auto__ = (function (){var statearr_25947 = f__20555__auto__.call(null);
(statearr_25947[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto__);

return statearr_25947;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(c__20554__auto__,map__25702,map__25702__$1,opts,before_jsload,on_jsload,reload_dependents,map__25703,map__25703__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__20554__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str(location.protocol),cljs.core.str("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__26010,link){
var map__26013 = p__26010;
var map__26013__$1 = ((((!((map__26013 == null)))?((((map__26013.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26013.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26013):map__26013);
var file = cljs.core.get.call(null,map__26013__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4425__auto__ = link.href;
if(cljs.core.truth_(temp__4425__auto__)){
var link_href = temp__4425__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4425__auto__,map__26013,map__26013__$1,file){
return (function (p1__26008_SHARP_,p2__26009_SHARP_){
if(cljs.core._EQ_.call(null,p1__26008_SHARP_,p2__26009_SHARP_)){
return p1__26008_SHARP_;
} else {
return false;
}
});})(link_href,temp__4425__auto__,map__26013,map__26013__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4425__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__26019){
var map__26020 = p__26019;
var map__26020__$1 = ((((!((map__26020 == null)))?((((map__26020.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26020.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26020):map__26020);
var match_length = cljs.core.get.call(null,map__26020__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__26020__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__26015_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__26015_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4425__auto__)){
var res = temp__4425__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.add_link_to_doc = (function figwheel$client$file_reloading$add_link_to_doc(var_args){
var args26022 = [];
var len__19443__auto___26025 = arguments.length;
var i__19444__auto___26026 = (0);
while(true){
if((i__19444__auto___26026 < len__19443__auto___26025)){
args26022.push((arguments[i__19444__auto___26026]));

var G__26027 = (i__19444__auto___26026 + (1));
i__19444__auto___26026 = G__26027;
continue;
} else {
}
break;
}

var G__26024 = args26022.length;
switch (G__26024) {
case 1:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26022.length)].join('')));

}
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = (function (new_link){
return (document.getElementsByTagName("head")[(0)]).appendChild(new_link);
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = (function (orig_link,klone){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
return parent.removeChild(orig_link);
});})(parent))
,(300));
});

figwheel.client.file_reloading.add_link_to_doc.cljs$lang$maxFixedArity = 2;
figwheel.client.file_reloading.distictify = (function figwheel$client$file_reloading$distictify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__26029_SHARP_,p2__26030_SHARP_){
return cljs.core.assoc.call(null,p1__26029_SHARP_,cljs.core.get.call(null,p2__26030_SHARP_,key),p2__26030_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(p__26031){
var map__26034 = p__26031;
var map__26034__$1 = ((((!((map__26034 == null)))?((((map__26034.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26034.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26034):map__26034);
var f_data = map__26034__$1;
var file = cljs.core.get.call(null,map__26034__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4425__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4425__auto__)){
var link = temp__4425__auto__;
return figwheel.client.file_reloading.add_link_to_doc.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href));
} else {
return null;
}
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__26036,files_msg){
var map__26043 = p__26036;
var map__26043__$1 = ((((!((map__26043 == null)))?((((map__26043.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26043.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26043):map__26043);
var opts = map__26043__$1;
var on_cssload = cljs.core.get.call(null,map__26043__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var seq__26045_26049 = cljs.core.seq.call(null,figwheel.client.file_reloading.distictify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg)));
var chunk__26046_26050 = null;
var count__26047_26051 = (0);
var i__26048_26052 = (0);
while(true){
if((i__26048_26052 < count__26047_26051)){
var f_26053 = cljs.core._nth.call(null,chunk__26046_26050,i__26048_26052);
figwheel.client.file_reloading.reload_css_file.call(null,f_26053);

var G__26054 = seq__26045_26049;
var G__26055 = chunk__26046_26050;
var G__26056 = count__26047_26051;
var G__26057 = (i__26048_26052 + (1));
seq__26045_26049 = G__26054;
chunk__26046_26050 = G__26055;
count__26047_26051 = G__26056;
i__26048_26052 = G__26057;
continue;
} else {
var temp__4425__auto___26058 = cljs.core.seq.call(null,seq__26045_26049);
if(temp__4425__auto___26058){
var seq__26045_26059__$1 = temp__4425__auto___26058;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26045_26059__$1)){
var c__19185__auto___26060 = cljs.core.chunk_first.call(null,seq__26045_26059__$1);
var G__26061 = cljs.core.chunk_rest.call(null,seq__26045_26059__$1);
var G__26062 = c__19185__auto___26060;
var G__26063 = cljs.core.count.call(null,c__19185__auto___26060);
var G__26064 = (0);
seq__26045_26049 = G__26061;
chunk__26046_26050 = G__26062;
count__26047_26051 = G__26063;
i__26048_26052 = G__26064;
continue;
} else {
var f_26065 = cljs.core.first.call(null,seq__26045_26059__$1);
figwheel.client.file_reloading.reload_css_file.call(null,f_26065);

var G__26066 = cljs.core.next.call(null,seq__26045_26059__$1);
var G__26067 = null;
var G__26068 = (0);
var G__26069 = (0);
seq__26045_26049 = G__26066;
chunk__26046_26050 = G__26067;
count__26047_26051 = G__26068;
i__26048_26052 = G__26069;
continue;
}
} else {
}
}
break;
}

return setTimeout(((function (map__26043,map__26043__$1,opts,on_cssload){
return (function (){
return on_cssload.call(null,new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg));
});})(map__26043,map__26043__$1,opts,on_cssload))
,(100));
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map