// Compiled by ClojureScript 1.8.34 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('goog.Uri');
goog.require('goog.net.jsloader');
goog.require('cljs.core.async');
goog.require('goog.object');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__18374__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__18374__auto__){
return or__18374__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.fix_node_request_url = (function figwheel$client$file_reloading$fix_node_request_url(url){

if(cljs.core.truth_(goog.string.startsWith(url,"../"))){
return clojure.string.replace.call(null,url,"../","");
} else {
return [cljs.core.str("goog/"),cljs.core.str(url)].join('');
}
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__18374__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, ["svgpan.SvgPan",null,"far.out",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__18374__auto__)){
return or__18374__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__25240_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__25240_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([name], true));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([parent_ns], true));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__25245 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__25246 = null;
var count__25247 = (0);
var i__25248 = (0);
while(true){
if((i__25248 < count__25247)){
var n = cljs.core._nth.call(null,chunk__25246,i__25248);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__25249 = seq__25245;
var G__25250 = chunk__25246;
var G__25251 = count__25247;
var G__25252 = (i__25248 + (1));
seq__25245 = G__25249;
chunk__25246 = G__25250;
count__25247 = G__25251;
i__25248 = G__25252;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__25245);
if(temp__4425__auto__){
var seq__25245__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25245__$1)){
var c__19185__auto__ = cljs.core.chunk_first.call(null,seq__25245__$1);
var G__25253 = cljs.core.chunk_rest.call(null,seq__25245__$1);
var G__25254 = c__19185__auto__;
var G__25255 = cljs.core.count.call(null,c__19185__auto__);
var G__25256 = (0);
seq__25245 = G__25253;
chunk__25246 = G__25254;
count__25247 = G__25255;
i__25248 = G__25256;
continue;
} else {
var n = cljs.core.first.call(null,seq__25245__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__25257 = cljs.core.next.call(null,seq__25245__$1);
var G__25258 = null;
var G__25259 = (0);
var G__25260 = (0);
seq__25245 = G__25257;
chunk__25246 = G__25258;
count__25247 = G__25259;
i__25248 = G__25260;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__25299_25306 = cljs.core.seq.call(null,deps);
var chunk__25300_25307 = null;
var count__25301_25308 = (0);
var i__25302_25309 = (0);
while(true){
if((i__25302_25309 < count__25301_25308)){
var dep_25310 = cljs.core._nth.call(null,chunk__25300_25307,i__25302_25309);
topo_sort_helper_STAR_.call(null,dep_25310,(depth + (1)),state);

var G__25311 = seq__25299_25306;
var G__25312 = chunk__25300_25307;
var G__25313 = count__25301_25308;
var G__25314 = (i__25302_25309 + (1));
seq__25299_25306 = G__25311;
chunk__25300_25307 = G__25312;
count__25301_25308 = G__25313;
i__25302_25309 = G__25314;
continue;
} else {
var temp__4425__auto___25315 = cljs.core.seq.call(null,seq__25299_25306);
if(temp__4425__auto___25315){
var seq__25299_25316__$1 = temp__4425__auto___25315;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25299_25316__$1)){
var c__19185__auto___25317 = cljs.core.chunk_first.call(null,seq__25299_25316__$1);
var G__25318 = cljs.core.chunk_rest.call(null,seq__25299_25316__$1);
var G__25319 = c__19185__auto___25317;
var G__25320 = cljs.core.count.call(null,c__19185__auto___25317);
var G__25321 = (0);
seq__25299_25306 = G__25318;
chunk__25300_25307 = G__25319;
count__25301_25308 = G__25320;
i__25302_25309 = G__25321;
continue;
} else {
var dep_25322 = cljs.core.first.call(null,seq__25299_25316__$1);
topo_sort_helper_STAR_.call(null,dep_25322,(depth + (1)),state);

var G__25323 = cljs.core.next.call(null,seq__25299_25316__$1);
var G__25324 = null;
var G__25325 = (0);
var G__25326 = (0);
seq__25299_25306 = G__25323;
chunk__25300_25307 = G__25324;
count__25301_25308 = G__25325;
i__25302_25309 = G__25326;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__25303){
var vec__25305 = p__25303;
var x = cljs.core.nth.call(null,vec__25305,(0),null);
var xs = cljs.core.nthnext.call(null,vec__25305,(1));
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__25305,x,xs,get_deps__$1){
return (function (p1__25261_SHARP_){
return clojure.set.difference.call(null,p1__25261_SHARP_,x);
});})(vec__25305,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str(goog.basePath),cljs.core.str(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str(goog.basePath),cljs.core.str(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__25339 = cljs.core.seq.call(null,provides);
var chunk__25340 = null;
var count__25341 = (0);
var i__25342 = (0);
while(true){
if((i__25342 < count__25341)){
var prov = cljs.core._nth.call(null,chunk__25340,i__25342);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__25343_25351 = cljs.core.seq.call(null,requires);
var chunk__25344_25352 = null;
var count__25345_25353 = (0);
var i__25346_25354 = (0);
while(true){
if((i__25346_25354 < count__25345_25353)){
var req_25355 = cljs.core._nth.call(null,chunk__25344_25352,i__25346_25354);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_25355,prov);

var G__25356 = seq__25343_25351;
var G__25357 = chunk__25344_25352;
var G__25358 = count__25345_25353;
var G__25359 = (i__25346_25354 + (1));
seq__25343_25351 = G__25356;
chunk__25344_25352 = G__25357;
count__25345_25353 = G__25358;
i__25346_25354 = G__25359;
continue;
} else {
var temp__4425__auto___25360 = cljs.core.seq.call(null,seq__25343_25351);
if(temp__4425__auto___25360){
var seq__25343_25361__$1 = temp__4425__auto___25360;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25343_25361__$1)){
var c__19185__auto___25362 = cljs.core.chunk_first.call(null,seq__25343_25361__$1);
var G__25363 = cljs.core.chunk_rest.call(null,seq__25343_25361__$1);
var G__25364 = c__19185__auto___25362;
var G__25365 = cljs.core.count.call(null,c__19185__auto___25362);
var G__25366 = (0);
seq__25343_25351 = G__25363;
chunk__25344_25352 = G__25364;
count__25345_25353 = G__25365;
i__25346_25354 = G__25366;
continue;
} else {
var req_25367 = cljs.core.first.call(null,seq__25343_25361__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_25367,prov);

var G__25368 = cljs.core.next.call(null,seq__25343_25361__$1);
var G__25369 = null;
var G__25370 = (0);
var G__25371 = (0);
seq__25343_25351 = G__25368;
chunk__25344_25352 = G__25369;
count__25345_25353 = G__25370;
i__25346_25354 = G__25371;
continue;
}
} else {
}
}
break;
}

var G__25372 = seq__25339;
var G__25373 = chunk__25340;
var G__25374 = count__25341;
var G__25375 = (i__25342 + (1));
seq__25339 = G__25372;
chunk__25340 = G__25373;
count__25341 = G__25374;
i__25342 = G__25375;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__25339);
if(temp__4425__auto__){
var seq__25339__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25339__$1)){
var c__19185__auto__ = cljs.core.chunk_first.call(null,seq__25339__$1);
var G__25376 = cljs.core.chunk_rest.call(null,seq__25339__$1);
var G__25377 = c__19185__auto__;
var G__25378 = cljs.core.count.call(null,c__19185__auto__);
var G__25379 = (0);
seq__25339 = G__25376;
chunk__25340 = G__25377;
count__25341 = G__25378;
i__25342 = G__25379;
continue;
} else {
var prov = cljs.core.first.call(null,seq__25339__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__25347_25380 = cljs.core.seq.call(null,requires);
var chunk__25348_25381 = null;
var count__25349_25382 = (0);
var i__25350_25383 = (0);
while(true){
if((i__25350_25383 < count__25349_25382)){
var req_25384 = cljs.core._nth.call(null,chunk__25348_25381,i__25350_25383);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_25384,prov);

var G__25385 = seq__25347_25380;
var G__25386 = chunk__25348_25381;
var G__25387 = count__25349_25382;
var G__25388 = (i__25350_25383 + (1));
seq__25347_25380 = G__25385;
chunk__25348_25381 = G__25386;
count__25349_25382 = G__25387;
i__25350_25383 = G__25388;
continue;
} else {
var temp__4425__auto___25389__$1 = cljs.core.seq.call(null,seq__25347_25380);
if(temp__4425__auto___25389__$1){
var seq__25347_25390__$1 = temp__4425__auto___25389__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25347_25390__$1)){
var c__19185__auto___25391 = cljs.core.chunk_first.call(null,seq__25347_25390__$1);
var G__25392 = cljs.core.chunk_rest.call(null,seq__25347_25390__$1);
var G__25393 = c__19185__auto___25391;
var G__25394 = cljs.core.count.call(null,c__19185__auto___25391);
var G__25395 = (0);
seq__25347_25380 = G__25392;
chunk__25348_25381 = G__25393;
count__25349_25382 = G__25394;
i__25350_25383 = G__25395;
continue;
} else {
var req_25396 = cljs.core.first.call(null,seq__25347_25390__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_25396,prov);

var G__25397 = cljs.core.next.call(null,seq__25347_25390__$1);
var G__25398 = null;
var G__25399 = (0);
var G__25400 = (0);
seq__25347_25380 = G__25397;
chunk__25348_25381 = G__25398;
count__25349_25382 = G__25399;
i__25350_25383 = G__25400;
continue;
}
} else {
}
}
break;
}

var G__25401 = cljs.core.next.call(null,seq__25339__$1);
var G__25402 = null;
var G__25403 = (0);
var G__25404 = (0);
seq__25339 = G__25401;
chunk__25340 = G__25402;
count__25341 = G__25403;
i__25342 = G__25404;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel$client$file_reloading$figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__25409_25413 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__25410_25414 = null;
var count__25411_25415 = (0);
var i__25412_25416 = (0);
while(true){
if((i__25412_25416 < count__25411_25415)){
var ns_25417 = cljs.core._nth.call(null,chunk__25410_25414,i__25412_25416);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_25417);

var G__25418 = seq__25409_25413;
var G__25419 = chunk__25410_25414;
var G__25420 = count__25411_25415;
var G__25421 = (i__25412_25416 + (1));
seq__25409_25413 = G__25418;
chunk__25410_25414 = G__25419;
count__25411_25415 = G__25420;
i__25412_25416 = G__25421;
continue;
} else {
var temp__4425__auto___25422 = cljs.core.seq.call(null,seq__25409_25413);
if(temp__4425__auto___25422){
var seq__25409_25423__$1 = temp__4425__auto___25422;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25409_25423__$1)){
var c__19185__auto___25424 = cljs.core.chunk_first.call(null,seq__25409_25423__$1);
var G__25425 = cljs.core.chunk_rest.call(null,seq__25409_25423__$1);
var G__25426 = c__19185__auto___25424;
var G__25427 = cljs.core.count.call(null,c__19185__auto___25424);
var G__25428 = (0);
seq__25409_25413 = G__25425;
chunk__25410_25414 = G__25426;
count__25411_25415 = G__25427;
i__25412_25416 = G__25428;
continue;
} else {
var ns_25429 = cljs.core.first.call(null,seq__25409_25423__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_25429);

var G__25430 = cljs.core.next.call(null,seq__25409_25423__$1);
var G__25431 = null;
var G__25432 = (0);
var G__25433 = (0);
seq__25409_25413 = G__25430;
chunk__25410_25414 = G__25431;
count__25411_25415 = G__25432;
i__25412_25416 = G__25433;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__18374__auto__ = goog.require__;
if(cljs.core.truth_(or__18374__auto__)){
return or__18374__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__25434__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__25434 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__25435__i = 0, G__25435__a = new Array(arguments.length -  0);
while (G__25435__i < G__25435__a.length) {G__25435__a[G__25435__i] = arguments[G__25435__i + 0]; ++G__25435__i;}
  args = new cljs.core.IndexedSeq(G__25435__a,0);
} 
return G__25434__delegate.call(this,args);};
G__25434.cljs$lang$maxFixedArity = 0;
G__25434.cljs$lang$applyTo = (function (arglist__25436){
var args = cljs.core.seq(arglist__25436);
return G__25434__delegate(args);
});
G__25434.cljs$core$IFn$_invoke$arity$variadic = G__25434__delegate;
return G__25434;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
;
}
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__25438 = cljs.core._EQ_;
var expr__25439 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__25438.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__25439))){
var path_parts = ((function (pred__25438,expr__25439){
return (function (p1__25437_SHARP_){
return clojure.string.split.call(null,p1__25437_SHARP_,/[\/\\]/);
});})(pred__25438,expr__25439))
;
var sep = (cljs.core.truth_(cljs.core.re_matches.call(null,/win.*/,process.platform))?"\\":"/");
var root = clojure.string.join.call(null,sep,cljs.core.pop.call(null,cljs.core.pop.call(null,path_parts.call(null,__dirname))));
return ((function (path_parts,sep,root,pred__25438,expr__25439){
return (function (request_url,callback){

var cache_path = clojure.string.join.call(null,sep,cljs.core.cons.call(null,root,path_parts.call(null,figwheel.client.file_reloading.fix_node_request_url.call(null,request_url))));
(require.cache[cache_path] = null);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e25441){if((e25441 instanceof Error)){
var e = e25441;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e25441;

}
}})());
});
;})(path_parts,sep,root,pred__25438,expr__25439))
} else {
if(cljs.core.truth_(pred__25438.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__25439))){
return ((function (pred__25438,expr__25439){
return (function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),{"cleanupWhenDone": true});
deferred.addCallback(((function (deferred,pred__25438,expr__25439){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred,pred__25438,expr__25439))
);

return deferred.addErrback(((function (deferred,pred__25438,expr__25439){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred,pred__25438,expr__25439))
);
});
;})(pred__25438,expr__25439))
} else {
return ((function (pred__25438,expr__25439){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__25438,expr__25439))
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__25442,callback){
var map__25445 = p__25442;
var map__25445__$1 = ((((!((map__25445 == null)))?((((map__25445.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25445.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25445):map__25445);
var file_msg = map__25445__$1;
var request_url = cljs.core.get.call(null,map__25445__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Attempting to load "),cljs.core.str(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__25445,map__25445__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Successfully loaded "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__25445,map__25445__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__20554__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20554__auto__){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (c__20554__auto__){
return (function (state_25469){
var state_val_25470 = (state_25469[(1)]);
if((state_val_25470 === (7))){
var inst_25465 = (state_25469[(2)]);
var state_25469__$1 = state_25469;
var statearr_25471_25491 = state_25469__$1;
(statearr_25471_25491[(2)] = inst_25465);

(statearr_25471_25491[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25470 === (1))){
var state_25469__$1 = state_25469;
var statearr_25472_25492 = state_25469__$1;
(statearr_25472_25492[(2)] = null);

(statearr_25472_25492[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25470 === (4))){
var inst_25449 = (state_25469[(7)]);
var inst_25449__$1 = (state_25469[(2)]);
var state_25469__$1 = (function (){var statearr_25473 = state_25469;
(statearr_25473[(7)] = inst_25449__$1);

return statearr_25473;
})();
if(cljs.core.truth_(inst_25449__$1)){
var statearr_25474_25493 = state_25469__$1;
(statearr_25474_25493[(1)] = (5));

} else {
var statearr_25475_25494 = state_25469__$1;
(statearr_25475_25494[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25470 === (6))){
var state_25469__$1 = state_25469;
var statearr_25476_25495 = state_25469__$1;
(statearr_25476_25495[(2)] = null);

(statearr_25476_25495[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25470 === (3))){
var inst_25467 = (state_25469[(2)]);
var state_25469__$1 = state_25469;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25469__$1,inst_25467);
} else {
if((state_val_25470 === (2))){
var state_25469__$1 = state_25469;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25469__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_25470 === (11))){
var inst_25461 = (state_25469[(2)]);
var state_25469__$1 = (function (){var statearr_25477 = state_25469;
(statearr_25477[(8)] = inst_25461);

return statearr_25477;
})();
var statearr_25478_25496 = state_25469__$1;
(statearr_25478_25496[(2)] = null);

(statearr_25478_25496[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25470 === (9))){
var inst_25455 = (state_25469[(9)]);
var inst_25453 = (state_25469[(10)]);
var inst_25457 = inst_25455.call(null,inst_25453);
var state_25469__$1 = state_25469;
var statearr_25479_25497 = state_25469__$1;
(statearr_25479_25497[(2)] = inst_25457);

(statearr_25479_25497[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25470 === (5))){
var inst_25449 = (state_25469[(7)]);
var inst_25451 = figwheel.client.file_reloading.blocking_load.call(null,inst_25449);
var state_25469__$1 = state_25469;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25469__$1,(8),inst_25451);
} else {
if((state_val_25470 === (10))){
var inst_25453 = (state_25469[(10)]);
var inst_25459 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_25453);
var state_25469__$1 = state_25469;
var statearr_25480_25498 = state_25469__$1;
(statearr_25480_25498[(2)] = inst_25459);

(statearr_25480_25498[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25470 === (8))){
var inst_25455 = (state_25469[(9)]);
var inst_25449 = (state_25469[(7)]);
var inst_25453 = (state_25469[(2)]);
var inst_25454 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_25455__$1 = cljs.core.get.call(null,inst_25454,inst_25449);
var state_25469__$1 = (function (){var statearr_25481 = state_25469;
(statearr_25481[(9)] = inst_25455__$1);

(statearr_25481[(10)] = inst_25453);

return statearr_25481;
})();
if(cljs.core.truth_(inst_25455__$1)){
var statearr_25482_25499 = state_25469__$1;
(statearr_25482_25499[(1)] = (9));

} else {
var statearr_25483_25500 = state_25469__$1;
(statearr_25483_25500[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__20554__auto__))
;
return ((function (switch__20400__auto__,c__20554__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__20401__auto__ = null;
var figwheel$client$file_reloading$state_machine__20401__auto____0 = (function (){
var statearr_25487 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_25487[(0)] = figwheel$client$file_reloading$state_machine__20401__auto__);

(statearr_25487[(1)] = (1));

return statearr_25487;
});
var figwheel$client$file_reloading$state_machine__20401__auto____1 = (function (state_25469){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_25469);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e25488){if((e25488 instanceof Object)){
var ex__20404__auto__ = e25488;
var statearr_25489_25501 = state_25469;
(statearr_25489_25501[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25469);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25488;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25502 = state_25469;
state_25469 = G__25502;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__20401__auto__ = function(state_25469){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__20401__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__20401__auto____1.call(this,state_25469);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__20401__auto____0;
figwheel$client$file_reloading$state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__20401__auto____1;
return figwheel$client$file_reloading$state_machine__20401__auto__;
})()
;})(switch__20400__auto__,c__20554__auto__))
})();
var state__20556__auto__ = (function (){var statearr_25490 = f__20555__auto__.call(null);
(statearr_25490[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto__);

return statearr_25490;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(c__20554__auto__))
);

return c__20554__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__25503,callback){
var map__25506 = p__25503;
var map__25506__$1 = ((((!((map__25506 == null)))?((((map__25506.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25506.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25506):map__25506);
var file_msg = map__25506__$1;
var namespace = cljs.core.get.call(null,map__25506__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__25506,map__25506__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__25506,map__25506__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__25508){
var map__25511 = p__25508;
var map__25511__$1 = ((((!((map__25511 == null)))?((((map__25511.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25511.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25511):map__25511);
var file_msg = map__25511__$1;
var namespace = cljs.core.get.call(null,map__25511__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__18362__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas));
if(and__18362__auto__){
var or__18374__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__18374__auto__)){
return or__18374__auto__;
} else {
var or__18374__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__18374__auto____$1)){
return or__18374__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__18362__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__25513,callback){
var map__25516 = p__25513;
var map__25516__$1 = ((((!((map__25516 == null)))?((((map__25516.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25516.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25516):map__25516);
var file_msg = map__25516__$1;
var request_url = cljs.core.get.call(null,map__25516__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__25516__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Figwheel: Not trying to load file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__20554__auto___25604 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20554__auto___25604,out){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (c__20554__auto___25604,out){
return (function (state_25586){
var state_val_25587 = (state_25586[(1)]);
if((state_val_25587 === (1))){
var inst_25564 = cljs.core.nth.call(null,files,(0),null);
var inst_25565 = cljs.core.nthnext.call(null,files,(1));
var inst_25566 = files;
var state_25586__$1 = (function (){var statearr_25588 = state_25586;
(statearr_25588[(7)] = inst_25564);

(statearr_25588[(8)] = inst_25566);

(statearr_25588[(9)] = inst_25565);

return statearr_25588;
})();
var statearr_25589_25605 = state_25586__$1;
(statearr_25589_25605[(2)] = null);

(statearr_25589_25605[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25587 === (2))){
var inst_25569 = (state_25586[(10)]);
var inst_25566 = (state_25586[(8)]);
var inst_25569__$1 = cljs.core.nth.call(null,inst_25566,(0),null);
var inst_25570 = cljs.core.nthnext.call(null,inst_25566,(1));
var inst_25571 = (inst_25569__$1 == null);
var inst_25572 = cljs.core.not.call(null,inst_25571);
var state_25586__$1 = (function (){var statearr_25590 = state_25586;
(statearr_25590[(10)] = inst_25569__$1);

(statearr_25590[(11)] = inst_25570);

return statearr_25590;
})();
if(inst_25572){
var statearr_25591_25606 = state_25586__$1;
(statearr_25591_25606[(1)] = (4));

} else {
var statearr_25592_25607 = state_25586__$1;
(statearr_25592_25607[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25587 === (3))){
var inst_25584 = (state_25586[(2)]);
var state_25586__$1 = state_25586;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25586__$1,inst_25584);
} else {
if((state_val_25587 === (4))){
var inst_25569 = (state_25586[(10)]);
var inst_25574 = figwheel.client.file_reloading.reload_js_file.call(null,inst_25569);
var state_25586__$1 = state_25586;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25586__$1,(7),inst_25574);
} else {
if((state_val_25587 === (5))){
var inst_25580 = cljs.core.async.close_BANG_.call(null,out);
var state_25586__$1 = state_25586;
var statearr_25593_25608 = state_25586__$1;
(statearr_25593_25608[(2)] = inst_25580);

(statearr_25593_25608[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25587 === (6))){
var inst_25582 = (state_25586[(2)]);
var state_25586__$1 = state_25586;
var statearr_25594_25609 = state_25586__$1;
(statearr_25594_25609[(2)] = inst_25582);

(statearr_25594_25609[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25587 === (7))){
var inst_25570 = (state_25586[(11)]);
var inst_25576 = (state_25586[(2)]);
var inst_25577 = cljs.core.async.put_BANG_.call(null,out,inst_25576);
var inst_25566 = inst_25570;
var state_25586__$1 = (function (){var statearr_25595 = state_25586;
(statearr_25595[(12)] = inst_25577);

(statearr_25595[(8)] = inst_25566);

return statearr_25595;
})();
var statearr_25596_25610 = state_25586__$1;
(statearr_25596_25610[(2)] = null);

(statearr_25596_25610[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__20554__auto___25604,out))
;
return ((function (switch__20400__auto__,c__20554__auto___25604,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__20401__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__20401__auto____0 = (function (){
var statearr_25600 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25600[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__20401__auto__);

(statearr_25600[(1)] = (1));

return statearr_25600;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__20401__auto____1 = (function (state_25586){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_25586);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e25601){if((e25601 instanceof Object)){
var ex__20404__auto__ = e25601;
var statearr_25602_25611 = state_25586;
(statearr_25602_25611[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25586);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25601;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25612 = state_25586;
state_25586 = G__25612;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__20401__auto__ = function(state_25586){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__20401__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__20401__auto____1.call(this,state_25586);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__20401__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__20401__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__20401__auto__;
})()
;})(switch__20400__auto__,c__20554__auto___25604,out))
})();
var state__20556__auto__ = (function (){var statearr_25603 = f__20555__auto__.call(null);
(statearr_25603[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto___25604);

return statearr_25603;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(c__20554__auto___25604,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__25613,opts){
var map__25617 = p__25613;
var map__25617__$1 = ((((!((map__25617 == null)))?((((map__25617.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25617.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25617):map__25617);
var eval_body__$1 = cljs.core.get.call(null,map__25617__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__25617__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__18362__auto__ = eval_body__$1;
if(cljs.core.truth_(and__18362__auto__)){
return typeof eval_body__$1 === 'string';
} else {
return and__18362__auto__;
}
})())){
var code = eval_body__$1;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Evaling file "),cljs.core.str(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e25619){var e = e25619;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Unable to evaluate "),cljs.core.str(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["figwheel.connect",null], null), null),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__4423__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__25620_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__25620_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__4423__auto__)){
var file_msg = temp__4423__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__25625){
var vec__25626 = p__25625;
var k = cljs.core.nth.call(null,vec__25626,(0),null);
var v = cljs.core.nth.call(null,vec__25626,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__25627){
var vec__25628 = p__25627;
var k = cljs.core.nth.call(null,vec__25628,(0),null);
var v = cljs.core.nth.call(null,vec__25628,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__25632,p__25633){
var map__25880 = p__25632;
var map__25880__$1 = ((((!((map__25880 == null)))?((((map__25880.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25880.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25880):map__25880);
var opts = map__25880__$1;
var before_jsload = cljs.core.get.call(null,map__25880__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__25880__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__25880__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__25881 = p__25633;
var map__25881__$1 = ((((!((map__25881 == null)))?((((map__25881.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25881.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25881):map__25881);
var msg = map__25881__$1;
var files = cljs.core.get.call(null,map__25881__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__25881__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__25881__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__20554__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20554__auto__,map__25880,map__25880__$1,opts,before_jsload,on_jsload,reload_dependents,map__25881,map__25881__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__20555__auto__ = (function (){var switch__20400__auto__ = ((function (c__20554__auto__,map__25880,map__25880__$1,opts,before_jsload,on_jsload,reload_dependents,map__25881,map__25881__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_26034){
var state_val_26035 = (state_26034[(1)]);
if((state_val_26035 === (7))){
var inst_25898 = (state_26034[(7)]);
var inst_25897 = (state_26034[(8)]);
var inst_25896 = (state_26034[(9)]);
var inst_25895 = (state_26034[(10)]);
var inst_25903 = cljs.core._nth.call(null,inst_25896,inst_25898);
var inst_25904 = figwheel.client.file_reloading.eval_body.call(null,inst_25903,opts);
var inst_25905 = (inst_25898 + (1));
var tmp26036 = inst_25897;
var tmp26037 = inst_25896;
var tmp26038 = inst_25895;
var inst_25895__$1 = tmp26038;
var inst_25896__$1 = tmp26037;
var inst_25897__$1 = tmp26036;
var inst_25898__$1 = inst_25905;
var state_26034__$1 = (function (){var statearr_26039 = state_26034;
(statearr_26039[(7)] = inst_25898__$1);

(statearr_26039[(8)] = inst_25897__$1);

(statearr_26039[(9)] = inst_25896__$1);

(statearr_26039[(11)] = inst_25904);

(statearr_26039[(10)] = inst_25895__$1);

return statearr_26039;
})();
var statearr_26040_26126 = state_26034__$1;
(statearr_26040_26126[(2)] = null);

(statearr_26040_26126[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (20))){
var inst_25938 = (state_26034[(12)]);
var inst_25946 = figwheel.client.file_reloading.sort_files.call(null,inst_25938);
var state_26034__$1 = state_26034;
var statearr_26041_26127 = state_26034__$1;
(statearr_26041_26127[(2)] = inst_25946);

(statearr_26041_26127[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (27))){
var state_26034__$1 = state_26034;
var statearr_26042_26128 = state_26034__$1;
(statearr_26042_26128[(2)] = null);

(statearr_26042_26128[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (1))){
var inst_25887 = (state_26034[(13)]);
var inst_25884 = before_jsload.call(null,files);
var inst_25885 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_25886 = (function (){return ((function (inst_25887,inst_25884,inst_25885,state_val_26035,c__20554__auto__,map__25880,map__25880__$1,opts,before_jsload,on_jsload,reload_dependents,map__25881,map__25881__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__25629_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__25629_SHARP_);
});
;})(inst_25887,inst_25884,inst_25885,state_val_26035,c__20554__auto__,map__25880,map__25880__$1,opts,before_jsload,on_jsload,reload_dependents,map__25881,map__25881__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_25887__$1 = cljs.core.filter.call(null,inst_25886,files);
var inst_25888 = cljs.core.not_empty.call(null,inst_25887__$1);
var state_26034__$1 = (function (){var statearr_26043 = state_26034;
(statearr_26043[(13)] = inst_25887__$1);

(statearr_26043[(14)] = inst_25885);

(statearr_26043[(15)] = inst_25884);

return statearr_26043;
})();
if(cljs.core.truth_(inst_25888)){
var statearr_26044_26129 = state_26034__$1;
(statearr_26044_26129[(1)] = (2));

} else {
var statearr_26045_26130 = state_26034__$1;
(statearr_26045_26130[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (24))){
var state_26034__$1 = state_26034;
var statearr_26046_26131 = state_26034__$1;
(statearr_26046_26131[(2)] = null);

(statearr_26046_26131[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (39))){
var inst_25988 = (state_26034[(16)]);
var state_26034__$1 = state_26034;
var statearr_26047_26132 = state_26034__$1;
(statearr_26047_26132[(2)] = inst_25988);

(statearr_26047_26132[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (46))){
var inst_26029 = (state_26034[(2)]);
var state_26034__$1 = state_26034;
var statearr_26048_26133 = state_26034__$1;
(statearr_26048_26133[(2)] = inst_26029);

(statearr_26048_26133[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (4))){
var inst_25932 = (state_26034[(2)]);
var inst_25933 = cljs.core.List.EMPTY;
var inst_25934 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_25933);
var inst_25935 = (function (){return ((function (inst_25932,inst_25933,inst_25934,state_val_26035,c__20554__auto__,map__25880,map__25880__$1,opts,before_jsload,on_jsload,reload_dependents,map__25881,map__25881__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__25630_SHARP_){
var and__18362__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__25630_SHARP_);
if(cljs.core.truth_(and__18362__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__25630_SHARP_));
} else {
return and__18362__auto__;
}
});
;})(inst_25932,inst_25933,inst_25934,state_val_26035,c__20554__auto__,map__25880,map__25880__$1,opts,before_jsload,on_jsload,reload_dependents,map__25881,map__25881__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_25936 = cljs.core.filter.call(null,inst_25935,files);
var inst_25937 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_25938 = cljs.core.concat.call(null,inst_25936,inst_25937);
var state_26034__$1 = (function (){var statearr_26049 = state_26034;
(statearr_26049[(17)] = inst_25932);

(statearr_26049[(12)] = inst_25938);

(statearr_26049[(18)] = inst_25934);

return statearr_26049;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_26050_26134 = state_26034__$1;
(statearr_26050_26134[(1)] = (16));

} else {
var statearr_26051_26135 = state_26034__$1;
(statearr_26051_26135[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (15))){
var inst_25922 = (state_26034[(2)]);
var state_26034__$1 = state_26034;
var statearr_26052_26136 = state_26034__$1;
(statearr_26052_26136[(2)] = inst_25922);

(statearr_26052_26136[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (21))){
var inst_25948 = (state_26034[(19)]);
var inst_25948__$1 = (state_26034[(2)]);
var inst_25949 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_25948__$1);
var state_26034__$1 = (function (){var statearr_26053 = state_26034;
(statearr_26053[(19)] = inst_25948__$1);

return statearr_26053;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26034__$1,(22),inst_25949);
} else {
if((state_val_26035 === (31))){
var inst_26032 = (state_26034[(2)]);
var state_26034__$1 = state_26034;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26034__$1,inst_26032);
} else {
if((state_val_26035 === (32))){
var inst_25988 = (state_26034[(16)]);
var inst_25993 = inst_25988.cljs$lang$protocol_mask$partition0$;
var inst_25994 = (inst_25993 & (64));
var inst_25995 = inst_25988.cljs$core$ISeq$;
var inst_25996 = (inst_25994) || (inst_25995);
var state_26034__$1 = state_26034;
if(cljs.core.truth_(inst_25996)){
var statearr_26054_26137 = state_26034__$1;
(statearr_26054_26137[(1)] = (35));

} else {
var statearr_26055_26138 = state_26034__$1;
(statearr_26055_26138[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (40))){
var inst_26009 = (state_26034[(20)]);
var inst_26008 = (state_26034[(2)]);
var inst_26009__$1 = cljs.core.get.call(null,inst_26008,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_26010 = cljs.core.get.call(null,inst_26008,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_26011 = cljs.core.not_empty.call(null,inst_26009__$1);
var state_26034__$1 = (function (){var statearr_26056 = state_26034;
(statearr_26056[(21)] = inst_26010);

(statearr_26056[(20)] = inst_26009__$1);

return statearr_26056;
})();
if(cljs.core.truth_(inst_26011)){
var statearr_26057_26139 = state_26034__$1;
(statearr_26057_26139[(1)] = (41));

} else {
var statearr_26058_26140 = state_26034__$1;
(statearr_26058_26140[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (33))){
var state_26034__$1 = state_26034;
var statearr_26059_26141 = state_26034__$1;
(statearr_26059_26141[(2)] = false);

(statearr_26059_26141[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (13))){
var inst_25908 = (state_26034[(22)]);
var inst_25912 = cljs.core.chunk_first.call(null,inst_25908);
var inst_25913 = cljs.core.chunk_rest.call(null,inst_25908);
var inst_25914 = cljs.core.count.call(null,inst_25912);
var inst_25895 = inst_25913;
var inst_25896 = inst_25912;
var inst_25897 = inst_25914;
var inst_25898 = (0);
var state_26034__$1 = (function (){var statearr_26060 = state_26034;
(statearr_26060[(7)] = inst_25898);

(statearr_26060[(8)] = inst_25897);

(statearr_26060[(9)] = inst_25896);

(statearr_26060[(10)] = inst_25895);

return statearr_26060;
})();
var statearr_26061_26142 = state_26034__$1;
(statearr_26061_26142[(2)] = null);

(statearr_26061_26142[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (22))){
var inst_25956 = (state_26034[(23)]);
var inst_25948 = (state_26034[(19)]);
var inst_25951 = (state_26034[(24)]);
var inst_25952 = (state_26034[(25)]);
var inst_25951__$1 = (state_26034[(2)]);
var inst_25952__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_25951__$1);
var inst_25953 = (function (){var all_files = inst_25948;
var res_SINGLEQUOTE_ = inst_25951__$1;
var res = inst_25952__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_25956,inst_25948,inst_25951,inst_25952,inst_25951__$1,inst_25952__$1,state_val_26035,c__20554__auto__,map__25880,map__25880__$1,opts,before_jsload,on_jsload,reload_dependents,map__25881,map__25881__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__25631_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__25631_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_25956,inst_25948,inst_25951,inst_25952,inst_25951__$1,inst_25952__$1,state_val_26035,c__20554__auto__,map__25880,map__25880__$1,opts,before_jsload,on_jsload,reload_dependents,map__25881,map__25881__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_25954 = cljs.core.filter.call(null,inst_25953,inst_25951__$1);
var inst_25955 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_25956__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_25955);
var inst_25957 = cljs.core.not_empty.call(null,inst_25956__$1);
var state_26034__$1 = (function (){var statearr_26062 = state_26034;
(statearr_26062[(26)] = inst_25954);

(statearr_26062[(23)] = inst_25956__$1);

(statearr_26062[(24)] = inst_25951__$1);

(statearr_26062[(25)] = inst_25952__$1);

return statearr_26062;
})();
if(cljs.core.truth_(inst_25957)){
var statearr_26063_26143 = state_26034__$1;
(statearr_26063_26143[(1)] = (23));

} else {
var statearr_26064_26144 = state_26034__$1;
(statearr_26064_26144[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (36))){
var state_26034__$1 = state_26034;
var statearr_26065_26145 = state_26034__$1;
(statearr_26065_26145[(2)] = false);

(statearr_26065_26145[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (41))){
var inst_26009 = (state_26034[(20)]);
var inst_26013 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_26014 = cljs.core.map.call(null,inst_26013,inst_26009);
var inst_26015 = cljs.core.pr_str.call(null,inst_26014);
var inst_26016 = [cljs.core.str("figwheel-no-load meta-data: "),cljs.core.str(inst_26015)].join('');
var inst_26017 = figwheel.client.utils.log.call(null,inst_26016);
var state_26034__$1 = state_26034;
var statearr_26066_26146 = state_26034__$1;
(statearr_26066_26146[(2)] = inst_26017);

(statearr_26066_26146[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (43))){
var inst_26010 = (state_26034[(21)]);
var inst_26020 = (state_26034[(2)]);
var inst_26021 = cljs.core.not_empty.call(null,inst_26010);
var state_26034__$1 = (function (){var statearr_26067 = state_26034;
(statearr_26067[(27)] = inst_26020);

return statearr_26067;
})();
if(cljs.core.truth_(inst_26021)){
var statearr_26068_26147 = state_26034__$1;
(statearr_26068_26147[(1)] = (44));

} else {
var statearr_26069_26148 = state_26034__$1;
(statearr_26069_26148[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (29))){
var inst_25954 = (state_26034[(26)]);
var inst_25988 = (state_26034[(16)]);
var inst_25956 = (state_26034[(23)]);
var inst_25948 = (state_26034[(19)]);
var inst_25951 = (state_26034[(24)]);
var inst_25952 = (state_26034[(25)]);
var inst_25984 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_25987 = (function (){var all_files = inst_25948;
var res_SINGLEQUOTE_ = inst_25951;
var res = inst_25952;
var files_not_loaded = inst_25954;
var dependencies_that_loaded = inst_25956;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_25954,inst_25988,inst_25956,inst_25948,inst_25951,inst_25952,inst_25984,state_val_26035,c__20554__auto__,map__25880,map__25880__$1,opts,before_jsload,on_jsload,reload_dependents,map__25881,map__25881__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__25986){
var map__26070 = p__25986;
var map__26070__$1 = ((((!((map__26070 == null)))?((((map__26070.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26070.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26070):map__26070);
var namespace = cljs.core.get.call(null,map__26070__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_25954,inst_25988,inst_25956,inst_25948,inst_25951,inst_25952,inst_25984,state_val_26035,c__20554__auto__,map__25880,map__25880__$1,opts,before_jsload,on_jsload,reload_dependents,map__25881,map__25881__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_25988__$1 = cljs.core.group_by.call(null,inst_25987,inst_25954);
var inst_25990 = (inst_25988__$1 == null);
var inst_25991 = cljs.core.not.call(null,inst_25990);
var state_26034__$1 = (function (){var statearr_26072 = state_26034;
(statearr_26072[(16)] = inst_25988__$1);

(statearr_26072[(28)] = inst_25984);

return statearr_26072;
})();
if(inst_25991){
var statearr_26073_26149 = state_26034__$1;
(statearr_26073_26149[(1)] = (32));

} else {
var statearr_26074_26150 = state_26034__$1;
(statearr_26074_26150[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (44))){
var inst_26010 = (state_26034[(21)]);
var inst_26023 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_26010);
var inst_26024 = cljs.core.pr_str.call(null,inst_26023);
var inst_26025 = [cljs.core.str("not required: "),cljs.core.str(inst_26024)].join('');
var inst_26026 = figwheel.client.utils.log.call(null,inst_26025);
var state_26034__$1 = state_26034;
var statearr_26075_26151 = state_26034__$1;
(statearr_26075_26151[(2)] = inst_26026);

(statearr_26075_26151[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (6))){
var inst_25929 = (state_26034[(2)]);
var state_26034__$1 = state_26034;
var statearr_26076_26152 = state_26034__$1;
(statearr_26076_26152[(2)] = inst_25929);

(statearr_26076_26152[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (28))){
var inst_25954 = (state_26034[(26)]);
var inst_25981 = (state_26034[(2)]);
var inst_25982 = cljs.core.not_empty.call(null,inst_25954);
var state_26034__$1 = (function (){var statearr_26077 = state_26034;
(statearr_26077[(29)] = inst_25981);

return statearr_26077;
})();
if(cljs.core.truth_(inst_25982)){
var statearr_26078_26153 = state_26034__$1;
(statearr_26078_26153[(1)] = (29));

} else {
var statearr_26079_26154 = state_26034__$1;
(statearr_26079_26154[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (25))){
var inst_25952 = (state_26034[(25)]);
var inst_25968 = (state_26034[(2)]);
var inst_25969 = cljs.core.not_empty.call(null,inst_25952);
var state_26034__$1 = (function (){var statearr_26080 = state_26034;
(statearr_26080[(30)] = inst_25968);

return statearr_26080;
})();
if(cljs.core.truth_(inst_25969)){
var statearr_26081_26155 = state_26034__$1;
(statearr_26081_26155[(1)] = (26));

} else {
var statearr_26082_26156 = state_26034__$1;
(statearr_26082_26156[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (34))){
var inst_26003 = (state_26034[(2)]);
var state_26034__$1 = state_26034;
if(cljs.core.truth_(inst_26003)){
var statearr_26083_26157 = state_26034__$1;
(statearr_26083_26157[(1)] = (38));

} else {
var statearr_26084_26158 = state_26034__$1;
(statearr_26084_26158[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (17))){
var state_26034__$1 = state_26034;
var statearr_26085_26159 = state_26034__$1;
(statearr_26085_26159[(2)] = recompile_dependents);

(statearr_26085_26159[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (3))){
var state_26034__$1 = state_26034;
var statearr_26086_26160 = state_26034__$1;
(statearr_26086_26160[(2)] = null);

(statearr_26086_26160[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (12))){
var inst_25925 = (state_26034[(2)]);
var state_26034__$1 = state_26034;
var statearr_26087_26161 = state_26034__$1;
(statearr_26087_26161[(2)] = inst_25925);

(statearr_26087_26161[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (2))){
var inst_25887 = (state_26034[(13)]);
var inst_25894 = cljs.core.seq.call(null,inst_25887);
var inst_25895 = inst_25894;
var inst_25896 = null;
var inst_25897 = (0);
var inst_25898 = (0);
var state_26034__$1 = (function (){var statearr_26088 = state_26034;
(statearr_26088[(7)] = inst_25898);

(statearr_26088[(8)] = inst_25897);

(statearr_26088[(9)] = inst_25896);

(statearr_26088[(10)] = inst_25895);

return statearr_26088;
})();
var statearr_26089_26162 = state_26034__$1;
(statearr_26089_26162[(2)] = null);

(statearr_26089_26162[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (23))){
var inst_25954 = (state_26034[(26)]);
var inst_25956 = (state_26034[(23)]);
var inst_25948 = (state_26034[(19)]);
var inst_25951 = (state_26034[(24)]);
var inst_25952 = (state_26034[(25)]);
var inst_25959 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_25961 = (function (){var all_files = inst_25948;
var res_SINGLEQUOTE_ = inst_25951;
var res = inst_25952;
var files_not_loaded = inst_25954;
var dependencies_that_loaded = inst_25956;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_25954,inst_25956,inst_25948,inst_25951,inst_25952,inst_25959,state_val_26035,c__20554__auto__,map__25880,map__25880__$1,opts,before_jsload,on_jsload,reload_dependents,map__25881,map__25881__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__25960){
var map__26090 = p__25960;
var map__26090__$1 = ((((!((map__26090 == null)))?((((map__26090.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26090.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26090):map__26090);
var request_url = cljs.core.get.call(null,map__26090__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_25954,inst_25956,inst_25948,inst_25951,inst_25952,inst_25959,state_val_26035,c__20554__auto__,map__25880,map__25880__$1,opts,before_jsload,on_jsload,reload_dependents,map__25881,map__25881__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_25962 = cljs.core.reverse.call(null,inst_25956);
var inst_25963 = cljs.core.map.call(null,inst_25961,inst_25962);
var inst_25964 = cljs.core.pr_str.call(null,inst_25963);
var inst_25965 = figwheel.client.utils.log.call(null,inst_25964);
var state_26034__$1 = (function (){var statearr_26092 = state_26034;
(statearr_26092[(31)] = inst_25959);

return statearr_26092;
})();
var statearr_26093_26163 = state_26034__$1;
(statearr_26093_26163[(2)] = inst_25965);

(statearr_26093_26163[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (35))){
var state_26034__$1 = state_26034;
var statearr_26094_26164 = state_26034__$1;
(statearr_26094_26164[(2)] = true);

(statearr_26094_26164[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (19))){
var inst_25938 = (state_26034[(12)]);
var inst_25944 = figwheel.client.file_reloading.expand_files.call(null,inst_25938);
var state_26034__$1 = state_26034;
var statearr_26095_26165 = state_26034__$1;
(statearr_26095_26165[(2)] = inst_25944);

(statearr_26095_26165[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (11))){
var state_26034__$1 = state_26034;
var statearr_26096_26166 = state_26034__$1;
(statearr_26096_26166[(2)] = null);

(statearr_26096_26166[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (9))){
var inst_25927 = (state_26034[(2)]);
var state_26034__$1 = state_26034;
var statearr_26097_26167 = state_26034__$1;
(statearr_26097_26167[(2)] = inst_25927);

(statearr_26097_26167[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (5))){
var inst_25898 = (state_26034[(7)]);
var inst_25897 = (state_26034[(8)]);
var inst_25900 = (inst_25898 < inst_25897);
var inst_25901 = inst_25900;
var state_26034__$1 = state_26034;
if(cljs.core.truth_(inst_25901)){
var statearr_26098_26168 = state_26034__$1;
(statearr_26098_26168[(1)] = (7));

} else {
var statearr_26099_26169 = state_26034__$1;
(statearr_26099_26169[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (14))){
var inst_25908 = (state_26034[(22)]);
var inst_25917 = cljs.core.first.call(null,inst_25908);
var inst_25918 = figwheel.client.file_reloading.eval_body.call(null,inst_25917,opts);
var inst_25919 = cljs.core.next.call(null,inst_25908);
var inst_25895 = inst_25919;
var inst_25896 = null;
var inst_25897 = (0);
var inst_25898 = (0);
var state_26034__$1 = (function (){var statearr_26100 = state_26034;
(statearr_26100[(7)] = inst_25898);

(statearr_26100[(8)] = inst_25897);

(statearr_26100[(9)] = inst_25896);

(statearr_26100[(32)] = inst_25918);

(statearr_26100[(10)] = inst_25895);

return statearr_26100;
})();
var statearr_26101_26170 = state_26034__$1;
(statearr_26101_26170[(2)] = null);

(statearr_26101_26170[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (45))){
var state_26034__$1 = state_26034;
var statearr_26102_26171 = state_26034__$1;
(statearr_26102_26171[(2)] = null);

(statearr_26102_26171[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (26))){
var inst_25954 = (state_26034[(26)]);
var inst_25956 = (state_26034[(23)]);
var inst_25948 = (state_26034[(19)]);
var inst_25951 = (state_26034[(24)]);
var inst_25952 = (state_26034[(25)]);
var inst_25971 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_25973 = (function (){var all_files = inst_25948;
var res_SINGLEQUOTE_ = inst_25951;
var res = inst_25952;
var files_not_loaded = inst_25954;
var dependencies_that_loaded = inst_25956;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_25954,inst_25956,inst_25948,inst_25951,inst_25952,inst_25971,state_val_26035,c__20554__auto__,map__25880,map__25880__$1,opts,before_jsload,on_jsload,reload_dependents,map__25881,map__25881__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__25972){
var map__26103 = p__25972;
var map__26103__$1 = ((((!((map__26103 == null)))?((((map__26103.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26103.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26103):map__26103);
var namespace = cljs.core.get.call(null,map__26103__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__26103__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_25954,inst_25956,inst_25948,inst_25951,inst_25952,inst_25971,state_val_26035,c__20554__auto__,map__25880,map__25880__$1,opts,before_jsload,on_jsload,reload_dependents,map__25881,map__25881__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_25974 = cljs.core.map.call(null,inst_25973,inst_25952);
var inst_25975 = cljs.core.pr_str.call(null,inst_25974);
var inst_25976 = figwheel.client.utils.log.call(null,inst_25975);
var inst_25977 = (function (){var all_files = inst_25948;
var res_SINGLEQUOTE_ = inst_25951;
var res = inst_25952;
var files_not_loaded = inst_25954;
var dependencies_that_loaded = inst_25956;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_25954,inst_25956,inst_25948,inst_25951,inst_25952,inst_25971,inst_25973,inst_25974,inst_25975,inst_25976,state_val_26035,c__20554__auto__,map__25880,map__25880__$1,opts,before_jsload,on_jsload,reload_dependents,map__25881,map__25881__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_25954,inst_25956,inst_25948,inst_25951,inst_25952,inst_25971,inst_25973,inst_25974,inst_25975,inst_25976,state_val_26035,c__20554__auto__,map__25880,map__25880__$1,opts,before_jsload,on_jsload,reload_dependents,map__25881,map__25881__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_25978 = setTimeout(inst_25977,(10));
var state_26034__$1 = (function (){var statearr_26105 = state_26034;
(statearr_26105[(33)] = inst_25976);

(statearr_26105[(34)] = inst_25971);

return statearr_26105;
})();
var statearr_26106_26172 = state_26034__$1;
(statearr_26106_26172[(2)] = inst_25978);

(statearr_26106_26172[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (16))){
var state_26034__$1 = state_26034;
var statearr_26107_26173 = state_26034__$1;
(statearr_26107_26173[(2)] = reload_dependents);

(statearr_26107_26173[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (38))){
var inst_25988 = (state_26034[(16)]);
var inst_26005 = cljs.core.apply.call(null,cljs.core.hash_map,inst_25988);
var state_26034__$1 = state_26034;
var statearr_26108_26174 = state_26034__$1;
(statearr_26108_26174[(2)] = inst_26005);

(statearr_26108_26174[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (30))){
var state_26034__$1 = state_26034;
var statearr_26109_26175 = state_26034__$1;
(statearr_26109_26175[(2)] = null);

(statearr_26109_26175[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (10))){
var inst_25908 = (state_26034[(22)]);
var inst_25910 = cljs.core.chunked_seq_QMARK_.call(null,inst_25908);
var state_26034__$1 = state_26034;
if(inst_25910){
var statearr_26110_26176 = state_26034__$1;
(statearr_26110_26176[(1)] = (13));

} else {
var statearr_26111_26177 = state_26034__$1;
(statearr_26111_26177[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (18))){
var inst_25942 = (state_26034[(2)]);
var state_26034__$1 = state_26034;
if(cljs.core.truth_(inst_25942)){
var statearr_26112_26178 = state_26034__$1;
(statearr_26112_26178[(1)] = (19));

} else {
var statearr_26113_26179 = state_26034__$1;
(statearr_26113_26179[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (42))){
var state_26034__$1 = state_26034;
var statearr_26114_26180 = state_26034__$1;
(statearr_26114_26180[(2)] = null);

(statearr_26114_26180[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (37))){
var inst_26000 = (state_26034[(2)]);
var state_26034__$1 = state_26034;
var statearr_26115_26181 = state_26034__$1;
(statearr_26115_26181[(2)] = inst_26000);

(statearr_26115_26181[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26035 === (8))){
var inst_25908 = (state_26034[(22)]);
var inst_25895 = (state_26034[(10)]);
var inst_25908__$1 = cljs.core.seq.call(null,inst_25895);
var state_26034__$1 = (function (){var statearr_26116 = state_26034;
(statearr_26116[(22)] = inst_25908__$1);

return statearr_26116;
})();
if(inst_25908__$1){
var statearr_26117_26182 = state_26034__$1;
(statearr_26117_26182[(1)] = (10));

} else {
var statearr_26118_26183 = state_26034__$1;
(statearr_26118_26183[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20554__auto__,map__25880,map__25880__$1,opts,before_jsload,on_jsload,reload_dependents,map__25881,map__25881__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__20400__auto__,c__20554__auto__,map__25880,map__25880__$1,opts,before_jsload,on_jsload,reload_dependents,map__25881,map__25881__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__20401__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__20401__auto____0 = (function (){
var statearr_26122 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26122[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__20401__auto__);

(statearr_26122[(1)] = (1));

return statearr_26122;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__20401__auto____1 = (function (state_26034){
while(true){
var ret_value__20402__auto__ = (function (){try{while(true){
var result__20403__auto__ = switch__20400__auto__.call(null,state_26034);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20403__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20403__auto__;
}
break;
}
}catch (e26123){if((e26123 instanceof Object)){
var ex__20404__auto__ = e26123;
var statearr_26124_26184 = state_26034;
(statearr_26124_26184[(5)] = ex__20404__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26034);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26123;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20402__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26185 = state_26034;
state_26034 = G__26185;
continue;
} else {
return ret_value__20402__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__20401__auto__ = function(state_26034){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__20401__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__20401__auto____1.call(this,state_26034);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__20401__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__20401__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__20401__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__20401__auto__;
})()
;})(switch__20400__auto__,c__20554__auto__,map__25880,map__25880__$1,opts,before_jsload,on_jsload,reload_dependents,map__25881,map__25881__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__20556__auto__ = (function (){var statearr_26125 = f__20555__auto__.call(null);
(statearr_26125[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20554__auto__);

return statearr_26125;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20556__auto__);
});})(c__20554__auto__,map__25880,map__25880__$1,opts,before_jsload,on_jsload,reload_dependents,map__25881,map__25881__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__20554__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str(location.protocol),cljs.core.str("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__26188,link){
var map__26191 = p__26188;
var map__26191__$1 = ((((!((map__26191 == null)))?((((map__26191.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26191.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26191):map__26191);
var file = cljs.core.get.call(null,map__26191__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4425__auto__ = link.href;
if(cljs.core.truth_(temp__4425__auto__)){
var link_href = temp__4425__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4425__auto__,map__26191,map__26191__$1,file){
return (function (p1__26186_SHARP_,p2__26187_SHARP_){
if(cljs.core._EQ_.call(null,p1__26186_SHARP_,p2__26187_SHARP_)){
return p1__26186_SHARP_;
} else {
return false;
}
});})(link_href,temp__4425__auto__,map__26191,map__26191__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4425__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__26197){
var map__26198 = p__26197;
var map__26198__$1 = ((((!((map__26198 == null)))?((((map__26198.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26198.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26198):map__26198);
var match_length = cljs.core.get.call(null,map__26198__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__26198__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__26193_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__26193_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4425__auto__)){
var res = temp__4425__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.add_link_to_doc = (function figwheel$client$file_reloading$add_link_to_doc(var_args){
var args26200 = [];
var len__19443__auto___26203 = arguments.length;
var i__19444__auto___26204 = (0);
while(true){
if((i__19444__auto___26204 < len__19443__auto___26203)){
args26200.push((arguments[i__19444__auto___26204]));

var G__26205 = (i__19444__auto___26204 + (1));
i__19444__auto___26204 = G__26205;
continue;
} else {
}
break;
}

var G__26202 = args26200.length;
switch (G__26202) {
case 1:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26200.length)].join('')));

}
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = (function (new_link){
return (document.getElementsByTagName("head")[(0)]).appendChild(new_link);
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = (function (orig_link,klone){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
return parent.removeChild(orig_link);
});})(parent))
,(300));
});

figwheel.client.file_reloading.add_link_to_doc.cljs$lang$maxFixedArity = 2;
figwheel.client.file_reloading.distictify = (function figwheel$client$file_reloading$distictify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__26207_SHARP_,p2__26208_SHARP_){
return cljs.core.assoc.call(null,p1__26207_SHARP_,cljs.core.get.call(null,p2__26208_SHARP_,key),p2__26208_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(p__26209){
var map__26212 = p__26209;
var map__26212__$1 = ((((!((map__26212 == null)))?((((map__26212.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26212.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26212):map__26212);
var f_data = map__26212__$1;
var file = cljs.core.get.call(null,map__26212__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4425__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4425__auto__)){
var link = temp__4425__auto__;
return figwheel.client.file_reloading.add_link_to_doc.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href));
} else {
return null;
}
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__26214,files_msg){
var map__26221 = p__26214;
var map__26221__$1 = ((((!((map__26221 == null)))?((((map__26221.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26221.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26221):map__26221);
var opts = map__26221__$1;
var on_cssload = cljs.core.get.call(null,map__26221__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var seq__26223_26227 = cljs.core.seq.call(null,figwheel.client.file_reloading.distictify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg)));
var chunk__26224_26228 = null;
var count__26225_26229 = (0);
var i__26226_26230 = (0);
while(true){
if((i__26226_26230 < count__26225_26229)){
var f_26231 = cljs.core._nth.call(null,chunk__26224_26228,i__26226_26230);
figwheel.client.file_reloading.reload_css_file.call(null,f_26231);

var G__26232 = seq__26223_26227;
var G__26233 = chunk__26224_26228;
var G__26234 = count__26225_26229;
var G__26235 = (i__26226_26230 + (1));
seq__26223_26227 = G__26232;
chunk__26224_26228 = G__26233;
count__26225_26229 = G__26234;
i__26226_26230 = G__26235;
continue;
} else {
var temp__4425__auto___26236 = cljs.core.seq.call(null,seq__26223_26227);
if(temp__4425__auto___26236){
var seq__26223_26237__$1 = temp__4425__auto___26236;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26223_26237__$1)){
var c__19185__auto___26238 = cljs.core.chunk_first.call(null,seq__26223_26237__$1);
var G__26239 = cljs.core.chunk_rest.call(null,seq__26223_26237__$1);
var G__26240 = c__19185__auto___26238;
var G__26241 = cljs.core.count.call(null,c__19185__auto___26238);
var G__26242 = (0);
seq__26223_26227 = G__26239;
chunk__26224_26228 = G__26240;
count__26225_26229 = G__26241;
i__26226_26230 = G__26242;
continue;
} else {
var f_26243 = cljs.core.first.call(null,seq__26223_26237__$1);
figwheel.client.file_reloading.reload_css_file.call(null,f_26243);

var G__26244 = cljs.core.next.call(null,seq__26223_26237__$1);
var G__26245 = null;
var G__26246 = (0);
var G__26247 = (0);
seq__26223_26227 = G__26244;
chunk__26224_26228 = G__26245;
count__26225_26229 = G__26246;
i__26226_26230 = G__26247;
continue;
}
} else {
}
}
break;
}

return setTimeout(((function (map__26221,map__26221__$1,opts,on_cssload){
return (function (){
return on_cssload.call(null,new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg));
});})(map__26221,map__26221__$1,opts,on_cssload))
,(100));
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map